# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']] = None,
                 basic_auth_config: Optional[pulumi.Input['AppBasicAuthConfigArgs']] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 cache_config: Optional[pulumi.Input['AppCacheConfigArgs']] = None,
                 custom_headers: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['AppEnvironmentVariableArgs']]]] = None,
                 iam_service_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['AppPlatform']] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[str] access_token: The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
               
               Use `AccessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `OauthToken` .
               
               You must specify either `AccessToken` or `OauthToken` when you create a new app.
               
               Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        :param pulumi.Input['AppAutoBranchCreationConfigArgs'] auto_branch_creation_config: Sets the configuration for your automatic branch creation.
        :param pulumi.Input['AppBasicAuthConfigArgs'] basic_auth_config: The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password` .
        :param pulumi.Input[str] build_spec: The build specification (build spec) for an Amplify app.
        :param pulumi.Input['AppCacheConfigArgs'] cache_config: The cache configuration for the Amplify app. If you don't specify the cache configuration `type` , Amplify uses the default `AMPLIFY_MANAGED` setting.
        :param pulumi.Input[str] custom_headers: The custom HTTP headers for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]] custom_rules: The custom rewrite and redirect rules for an Amplify app.
        :param pulumi.Input[str] description: The description of the Amplify app.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
        :param pulumi.Input[Sequence[pulumi.Input['AppEnvironmentVariableArgs']]] environment_variables: The environment variables for the Amplify app.
               
               For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide* .
        :param pulumi.Input[str] iam_service_role: AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
        :param pulumi.Input[str] name: The name of the Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
               
               Use `OauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `AccessToken` .
               
               You must specify either `OauthToken` or `AccessToken` when you create a new app.
               
               Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        :param pulumi.Input['AppPlatform'] platform: The platform for the Amplify app. For a static app, set the platform type to `WEB` . For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE` . For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC` .
               
               If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to `WEB_COMPUTE` and set the artifacts `baseDirectory` to `.next` in the application's build settings. For an example of the build specification settings, see [Amplify build settings for a Next.js 14 SSG application](https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14) in the *Amplify Hosting User Guide* .
        :param pulumi.Input[str] repository: The Git repository for the Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tag for an Amplify app.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if auto_branch_creation_config is not None:
            pulumi.set(__self__, "auto_branch_creation_config", auto_branch_creation_config)
        if basic_auth_config is not None:
            pulumi.set(__self__, "basic_auth_config", basic_auth_config)
        if build_spec is not None:
            pulumi.set(__self__, "build_spec", build_spec)
        if cache_config is not None:
            pulumi.set(__self__, "cache_config", cache_config)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_branch_auto_deletion is not None:
            pulumi.set(__self__, "enable_branch_auto_deletion", enable_branch_auto_deletion)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if iam_service_role is not None:
            pulumi.set(__self__, "iam_service_role", iam_service_role)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.

        Use `AccessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `OauthToken` .

        You must specify either `AccessToken` or `OauthToken` when you create a new app.

        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]:
        """
        Sets the configuration for your automatic branch creation.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @auto_branch_creation_config.setter
    def auto_branch_creation_config(self, value: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]):
        pulumi.set(self, "auto_branch_creation_config", value)

    @property
    @pulumi.getter(name="basicAuthConfig")
    def basic_auth_config(self) -> Optional[pulumi.Input['AppBasicAuthConfigArgs']]:
        """
        The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password` .
        """
        return pulumi.get(self, "basic_auth_config")

    @basic_auth_config.setter
    def basic_auth_config(self, value: Optional[pulumi.Input['AppBasicAuthConfigArgs']]):
        pulumi.set(self, "basic_auth_config", value)

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The build specification (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @build_spec.setter
    def build_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_spec", value)

    @property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> Optional[pulumi.Input['AppCacheConfigArgs']]:
        """
        The cache configuration for the Amplify app. If you don't specify the cache configuration `type` , Amplify uses the default `AMPLIFY_MANAGED` setting.
        """
        return pulumi.get(self, "cache_config")

    @cache_config.setter
    def cache_config(self, value: Optional[pulumi.Input['AppCacheConfigArgs']]):
        pulumi.set(self, "cache_config", value)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[str]]:
        """
        The custom HTTP headers for an Amplify app.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]:
        """
        The custom rewrite and redirect rules for an Amplify app.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Amplify app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @enable_branch_auto_deletion.setter
    def enable_branch_auto_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_branch_auto_deletion", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppEnvironmentVariableArgs']]]]:
        """
        The environment variables for the Amplify app.

        For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide* .
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="iamServiceRole")
    def iam_service_role(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
        """
        return pulumi.get(self, "iam_service_role")

    @iam_service_role.setter
    def iam_service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_service_role", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Amplify app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.

        Use `OauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `AccessToken` .

        You must specify either `OauthToken` or `AccessToken` when you create a new app.

        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_token", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['AppPlatform']]:
        """
        The platform for the Amplify app. For a static app, set the platform type to `WEB` . For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE` . For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC` .

        If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to `WEB_COMPUTE` and set the artifacts `baseDirectory` to `.next` in the application's build settings. For an example of the build specification settings, see [Amplify build settings for a Next.js 14 SSG application](https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14) in the *Amplify Hosting User Guide* .
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['AppPlatform']]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The Git repository for the Amplify app.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tag for an Amplify app.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']]] = None,
                 basic_auth_config: Optional[pulumi.Input[Union['AppBasicAuthConfigArgs', 'AppBasicAuthConfigArgsDict']]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 cache_config: Optional[pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']]] = None,
                 custom_headers: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppEnvironmentVariableArgs', 'AppEnvironmentVariableArgsDict']]]]] = None,
                 iam_service_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['AppPlatform']] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::Amplify::App resource creates Apps in the Amplify Console. An App is a collection of branches.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
               
               Use `AccessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `OauthToken` .
               
               You must specify either `AccessToken` or `OauthToken` when you create a new app.
               
               Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        :param pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']] auto_branch_creation_config: Sets the configuration for your automatic branch creation.
        :param pulumi.Input[Union['AppBasicAuthConfigArgs', 'AppBasicAuthConfigArgsDict']] basic_auth_config: The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password` .
        :param pulumi.Input[str] build_spec: The build specification (build spec) for an Amplify app.
        :param pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']] cache_config: The cache configuration for the Amplify app. If you don't specify the cache configuration `type` , Amplify uses the default `AMPLIFY_MANAGED` setting.
        :param pulumi.Input[str] custom_headers: The custom HTTP headers for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]] custom_rules: The custom rewrite and redirect rules for an Amplify app.
        :param pulumi.Input[str] description: The description of the Amplify app.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppEnvironmentVariableArgs', 'AppEnvironmentVariableArgsDict']]]] environment_variables: The environment variables for the Amplify app.
               
               For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide* .
        :param pulumi.Input[str] iam_service_role: AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
        :param pulumi.Input[str] name: The name of the Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
               
               Use `OauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `AccessToken` .
               
               You must specify either `OauthToken` or `AccessToken` when you create a new app.
               
               Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        :param pulumi.Input['AppPlatform'] platform: The platform for the Amplify app. For a static app, set the platform type to `WEB` . For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE` . For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC` .
               
               If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to `WEB_COMPUTE` and set the artifacts `baseDirectory` to `.next` in the application's build settings. For an example of the build specification settings, see [Amplify build settings for a Next.js 14 SSG application](https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14) in the *Amplify Hosting User Guide* .
        :param pulumi.Input[str] repository: The Git repository for the Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tag for an Amplify app.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Amplify::App resource creates Apps in the Amplify Console. An App is a collection of branches.

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']]] = None,
                 basic_auth_config: Optional[pulumi.Input[Union['AppBasicAuthConfigArgs', 'AppBasicAuthConfigArgsDict']]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 cache_config: Optional[pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']]] = None,
                 custom_headers: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppEnvironmentVariableArgs', 'AppEnvironmentVariableArgsDict']]]]] = None,
                 iam_service_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['AppPlatform']] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["auto_branch_creation_config"] = auto_branch_creation_config
            __props__.__dict__["basic_auth_config"] = basic_auth_config
            __props__.__dict__["build_spec"] = build_spec
            __props__.__dict__["cache_config"] = cache_config
            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["custom_rules"] = custom_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_branch_auto_deletion"] = enable_branch_auto_deletion
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["iam_service_role"] = iam_service_role
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_token"] = oauth_token
            __props__.__dict__["platform"] = platform
            __props__.__dict__["repository"] = repository
            __props__.__dict__["tags"] = tags
            __props__.__dict__["app_id"] = None
            __props__.__dict__["app_name"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["default_domain"] = None
        super(App, __self__).__init__(
            'aws-native:amplify:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AppArgs.__new__(AppArgs)

        __props__.__dict__["access_token"] = None
        __props__.__dict__["app_id"] = None
        __props__.__dict__["app_name"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_branch_creation_config"] = None
        __props__.__dict__["basic_auth_config"] = None
        __props__.__dict__["build_spec"] = None
        __props__.__dict__["cache_config"] = None
        __props__.__dict__["custom_headers"] = None
        __props__.__dict__["custom_rules"] = None
        __props__.__dict__["default_domain"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["enable_branch_auto_deletion"] = None
        __props__.__dict__["environment_variables"] = None
        __props__.__dict__["iam_service_role"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["oauth_token"] = None
        __props__.__dict__["platform"] = None
        __props__.__dict__["repository"] = None
        __props__.__dict__["tags"] = None
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[str]]:
        """
        The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.

        Use `AccessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `OauthToken` .

        You must specify either `AccessToken` or `OauthToken` when you create a new app.

        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        Unique Id for the Amplify App.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        Name for the Amplify App.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN for the Amplify App.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> pulumi.Output[Optional['outputs.AppAutoBranchCreationConfig']]:
        """
        Sets the configuration for your automatic branch creation.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @property
    @pulumi.getter(name="basicAuthConfig")
    def basic_auth_config(self) -> pulumi.Output[Optional['outputs.AppBasicAuthConfig']]:
        """
        The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password` .
        """
        return pulumi.get(self, "basic_auth_config")

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The build specification (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> pulumi.Output[Optional['outputs.AppCacheConfig']]:
        """
        The cache configuration for the Amplify app. If you don't specify the cache configuration `type` , Amplify uses the default `AMPLIFY_MANAGED` setting.
        """
        return pulumi.get(self, "cache_config")

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[Optional[str]]:
        """
        The custom HTTP headers for an Amplify app.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AppCustomRule']]]:
        """
        The custom rewrite and redirect rules for an Amplify app.
        """
        return pulumi.get(self, "custom_rules")

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> pulumi.Output[str]:
        """
        Default domain for the Amplify App.
        """
        return pulumi.get(self, "default_domain")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Amplify app.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.AppEnvironmentVariable']]]:
        """
        The environment variables for the Amplify app.

        For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide* .
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="iamServiceRole")
    def iam_service_role(self) -> pulumi.Output[Optional[str]]:
        """
        AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
        """
        return pulumi.get(self, "iam_service_role")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Amplify app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> pulumi.Output[Optional[str]]:
        """
        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.

        Use `OauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `AccessToken` .

        You must specify either `OauthToken` or `AccessToken` when you create a new app.

        Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
        """
        return pulumi.get(self, "oauth_token")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional['AppPlatform']]:
        """
        The platform for the Amplify app. For a static app, set the platform type to `WEB` . For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE` . For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC` .

        If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to `WEB_COMPUTE` and set the artifacts `baseDirectory` to `.next` in the application's build settings. For an example of the build specification settings, see [Amplify build settings for a Next.js 14 SSG application](https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14) in the *Amplify Hosting User Guide* .
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[Optional[str]]:
        """
        The Git repository for the Amplify app.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tag for an Amplify app.
        """
        return pulumi.get(self, "tags")

