# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CertificateApiPassthroughArgs',
    'CertificateApiPassthroughArgsDict',
    'CertificateAuthorityAccessDescriptionArgs',
    'CertificateAuthorityAccessDescriptionArgsDict',
    'CertificateAuthorityAccessMethodArgs',
    'CertificateAuthorityAccessMethodArgsDict',
    'CertificateAuthorityCrlConfigurationArgs',
    'CertificateAuthorityCrlConfigurationArgsDict',
    'CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs',
    'CertificateAuthorityCrlDistributionPointExtensionConfigurationArgsDict',
    'CertificateAuthorityCsrExtensionsArgs',
    'CertificateAuthorityCsrExtensionsArgsDict',
    'CertificateAuthorityCustomAttributeArgs',
    'CertificateAuthorityCustomAttributeArgsDict',
    'CertificateAuthorityEdiPartyNameArgs',
    'CertificateAuthorityEdiPartyNameArgsDict',
    'CertificateAuthorityGeneralNameArgs',
    'CertificateAuthorityGeneralNameArgsDict',
    'CertificateAuthorityKeyUsageArgs',
    'CertificateAuthorityKeyUsageArgsDict',
    'CertificateAuthorityOcspConfigurationArgs',
    'CertificateAuthorityOcspConfigurationArgsDict',
    'CertificateAuthorityOtherNameArgs',
    'CertificateAuthorityOtherNameArgsDict',
    'CertificateAuthorityRevocationConfigurationArgs',
    'CertificateAuthorityRevocationConfigurationArgsDict',
    'CertificateAuthoritySubjectArgs',
    'CertificateAuthoritySubjectArgsDict',
    'CertificateCustomAttributeArgs',
    'CertificateCustomAttributeArgsDict',
    'CertificateCustomExtensionArgs',
    'CertificateCustomExtensionArgsDict',
    'CertificateEdiPartyNameArgs',
    'CertificateEdiPartyNameArgsDict',
    'CertificateExtendedKeyUsageArgs',
    'CertificateExtendedKeyUsageArgsDict',
    'CertificateExtensionsArgs',
    'CertificateExtensionsArgsDict',
    'CertificateGeneralNameArgs',
    'CertificateGeneralNameArgsDict',
    'CertificateKeyUsageArgs',
    'CertificateKeyUsageArgsDict',
    'CertificateOtherNameArgs',
    'CertificateOtherNameArgsDict',
    'CertificatePolicyInformationArgs',
    'CertificatePolicyInformationArgsDict',
    'CertificatePolicyQualifierInfoArgs',
    'CertificatePolicyQualifierInfoArgsDict',
    'CertificateQualifierArgs',
    'CertificateQualifierArgsDict',
    'CertificateSubjectArgs',
    'CertificateSubjectArgsDict',
    'CertificateValidityArgs',
    'CertificateValidityArgsDict',
]

MYPY = False

if not MYPY:
    class CertificateApiPassthroughArgsDict(TypedDict):
        """
        Contains X.509 certificate information to be placed in an issued certificate. An ``APIPassthrough`` or ``APICSRPassthrough`` template variant must be selected, or else this parameter is ignored. 
         If conflicting or duplicate certificate information is supplied from other sources, AWS Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
        """
        extensions: NotRequired[pulumi.Input['CertificateExtensionsArgsDict']]
        """
        Specifies X.509 extension information for a certificate.
        """
        subject: NotRequired[pulumi.Input['CertificateSubjectArgsDict']]
        """
        Contains information about the certificate subject. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
elif False:
    CertificateApiPassthroughArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateApiPassthroughArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input['CertificateExtensionsArgs']] = None,
                 subject: Optional[pulumi.Input['CertificateSubjectArgs']] = None):
        """
        Contains X.509 certificate information to be placed in an issued certificate. An ``APIPassthrough`` or ``APICSRPassthrough`` template variant must be selected, or else this parameter is ignored. 
         If conflicting or duplicate certificate information is supplied from other sources, AWS Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
        :param pulumi.Input['CertificateExtensionsArgs'] extensions: Specifies X.509 extension information for a certificate.
        :param pulumi.Input['CertificateSubjectArgs'] subject: Contains information about the certificate subject. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input['CertificateExtensionsArgs']]:
        """
        Specifies X.509 extension information for a certificate.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input['CertificateExtensionsArgs']]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input['CertificateSubjectArgs']]:
        """
        Contains information about the certificate subject. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input['CertificateSubjectArgs']]):
        pulumi.set(self, "subject", value)


if not MYPY:
    class CertificateAuthorityAccessDescriptionArgsDict(TypedDict):
        """
        Structure that contains X.509 AccessDescription information.
        """
        access_location: pulumi.Input['CertificateAuthorityGeneralNameArgsDict']
        access_method: pulumi.Input['CertificateAuthorityAccessMethodArgsDict']
elif False:
    CertificateAuthorityAccessDescriptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityAccessDescriptionArgs:
    def __init__(__self__, *,
                 access_location: pulumi.Input['CertificateAuthorityGeneralNameArgs'],
                 access_method: pulumi.Input['CertificateAuthorityAccessMethodArgs']):
        """
        Structure that contains X.509 AccessDescription information.
        """
        pulumi.set(__self__, "access_location", access_location)
        pulumi.set(__self__, "access_method", access_method)

    @property
    @pulumi.getter(name="accessLocation")
    def access_location(self) -> pulumi.Input['CertificateAuthorityGeneralNameArgs']:
        return pulumi.get(self, "access_location")

    @access_location.setter
    def access_location(self, value: pulumi.Input['CertificateAuthorityGeneralNameArgs']):
        pulumi.set(self, "access_location", value)

    @property
    @pulumi.getter(name="accessMethod")
    def access_method(self) -> pulumi.Input['CertificateAuthorityAccessMethodArgs']:
        return pulumi.get(self, "access_method")

    @access_method.setter
    def access_method(self, value: pulumi.Input['CertificateAuthorityAccessMethodArgs']):
        pulumi.set(self, "access_method", value)


if not MYPY:
    class CertificateAuthorityAccessMethodArgsDict(TypedDict):
        """
        Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
        """
        access_method_type: NotRequired[pulumi.Input[str]]
        custom_object_identifier: NotRequired[pulumi.Input[str]]
elif False:
    CertificateAuthorityAccessMethodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityAccessMethodArgs:
    def __init__(__self__, *,
                 access_method_type: Optional[pulumi.Input[str]] = None,
                 custom_object_identifier: Optional[pulumi.Input[str]] = None):
        """
        Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
        """
        if access_method_type is not None:
            pulumi.set(__self__, "access_method_type", access_method_type)
        if custom_object_identifier is not None:
            pulumi.set(__self__, "custom_object_identifier", custom_object_identifier)

    @property
    @pulumi.getter(name="accessMethodType")
    def access_method_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "access_method_type")

    @access_method_type.setter
    def access_method_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_method_type", value)

    @property
    @pulumi.getter(name="customObjectIdentifier")
    def custom_object_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "custom_object_identifier")

    @custom_object_identifier.setter
    def custom_object_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_object_identifier", value)


if not MYPY:
    class CertificateAuthorityCrlConfigurationArgsDict(TypedDict):
        """
        Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
        """
        enabled: pulumi.Input[bool]
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the `CreateCertificateAuthority` operation or for an existing CA when you call the `UpdateCertificateAuthority` operation.
        """
        crl_distribution_point_extension_configuration: NotRequired[pulumi.Input['CertificateAuthorityCrlDistributionPointExtensionConfigurationArgsDict']]
        """
        Configures the default behavior of the CRL Distribution Point extension for certificates issued by your CA. If this field is not provided, then the CRL Distribution Point extension will be present and contain the default CRL URL.
        """
        custom_cname: NotRequired[pulumi.Input[str]]
        """
        Name inserted into the certificate *CRL Distribution Points* extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.

        > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        expiration_in_days: NotRequired[pulumi.Input[int]]
        """
        Validity period of the CRL in days.
        """
        s3_bucket_name: NotRequired[pulumi.Input[str]]
        """
        Name of the S3 bucket that contains the CRL. If you do not provide a value for the *CustomCname* argument, the name of your S3 bucket is placed into the *CRL Distribution Points* extension of the issued certificate. You can change the name of your bucket by calling the [UpdateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_UpdateCertificateAuthority.html) operation. You must specify a [bucket policy](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-policies) that allows AWS Private CA to write the CRL to your bucket.

        > The `S3BucketName` parameter must conform to the [S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) .
        """
        s3_object_acl: NotRequired[pulumi.Input[str]]
        """
        Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.

        If no value is specified, the default is PUBLIC_READ.

        *Note:* This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as `BUCKET_OWNER_FULL_CONTROL` , and not doing so results in an error. If you have disabled BPA in S3, then you can specify either `BUCKET_OWNER_FULL_CONTROL` or `PUBLIC_READ` as the value.

        For more information, see [Blocking public access to the S3 bucket](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-bpa) .
        """
elif False:
    CertificateAuthorityCrlConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCrlConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 crl_distribution_point_extension_configuration: Optional[pulumi.Input['CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs']] = None,
                 custom_cname: Optional[pulumi.Input[str]] = None,
                 expiration_in_days: Optional[pulumi.Input[int]] = None,
                 s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 s3_object_acl: Optional[pulumi.Input[str]] = None):
        """
        Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
        :param pulumi.Input[bool] enabled: Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the `CreateCertificateAuthority` operation or for an existing CA when you call the `UpdateCertificateAuthority` operation.
        :param pulumi.Input['CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs'] crl_distribution_point_extension_configuration: Configures the default behavior of the CRL Distribution Point extension for certificates issued by your CA. If this field is not provided, then the CRL Distribution Point extension will be present and contain the default CRL URL.
        :param pulumi.Input[str] custom_cname: Name inserted into the certificate *CRL Distribution Points* extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.
               
               > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        :param pulumi.Input[int] expiration_in_days: Validity period of the CRL in days.
        :param pulumi.Input[str] s3_bucket_name: Name of the S3 bucket that contains the CRL. If you do not provide a value for the *CustomCname* argument, the name of your S3 bucket is placed into the *CRL Distribution Points* extension of the issued certificate. You can change the name of your bucket by calling the [UpdateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_UpdateCertificateAuthority.html) operation. You must specify a [bucket policy](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-policies) that allows AWS Private CA to write the CRL to your bucket.
               
               > The `S3BucketName` parameter must conform to the [S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) .
        :param pulumi.Input[str] s3_object_acl: Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.
               
               If no value is specified, the default is PUBLIC_READ.
               
               *Note:* This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as `BUCKET_OWNER_FULL_CONTROL` , and not doing so results in an error. If you have disabled BPA in S3, then you can specify either `BUCKET_OWNER_FULL_CONTROL` or `PUBLIC_READ` as the value.
               
               For more information, see [Blocking public access to the S3 bucket](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-bpa) .
        """
        pulumi.set(__self__, "enabled", enabled)
        if crl_distribution_point_extension_configuration is not None:
            pulumi.set(__self__, "crl_distribution_point_extension_configuration", crl_distribution_point_extension_configuration)
        if custom_cname is not None:
            pulumi.set(__self__, "custom_cname", custom_cname)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_acl is not None:
            pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the `CreateCertificateAuthority` operation or for an existing CA when you call the `UpdateCertificateAuthority` operation.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="crlDistributionPointExtensionConfiguration")
    def crl_distribution_point_extension_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs']]:
        """
        Configures the default behavior of the CRL Distribution Point extension for certificates issued by your CA. If this field is not provided, then the CRL Distribution Point extension will be present and contain the default CRL URL.
        """
        return pulumi.get(self, "crl_distribution_point_extension_configuration")

    @crl_distribution_point_extension_configuration.setter
    def crl_distribution_point_extension_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs']]):
        pulumi.set(self, "crl_distribution_point_extension_configuration", value)

    @property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> Optional[pulumi.Input[str]]:
        """
        Name inserted into the certificate *CRL Distribution Points* extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.

        > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        return pulumi.get(self, "custom_cname")

    @custom_cname.setter
    def custom_cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_cname", value)

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Validity period of the CRL in days.
        """
        return pulumi.get(self, "expiration_in_days")

    @expiration_in_days.setter
    def expiration_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_in_days", value)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the S3 bucket that contains the CRL. If you do not provide a value for the *CustomCname* argument, the name of your S3 bucket is placed into the *CRL Distribution Points* extension of the issued certificate. You can change the name of your bucket by calling the [UpdateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_UpdateCertificateAuthority.html) operation. You must specify a [bucket policy](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-policies) that allows AWS Private CA to write the CRL to your bucket.

        > The `S3BucketName` parameter must conform to the [S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) .
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.

        If no value is specified, the default is PUBLIC_READ.

        *Note:* This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as `BUCKET_OWNER_FULL_CONTROL` , and not doing so results in an error. If you have disabled BPA in S3, then you can specify either `BUCKET_OWNER_FULL_CONTROL` or `PUBLIC_READ` as the value.

        For more information, see [Blocking public access to the S3 bucket](https://docs.aws.amazon.com/privateca/latest/userguide/PcaCreateCa.html#s3-bpa) .
        """
        return pulumi.get(self, "s3_object_acl")

    @s3_object_acl.setter
    def s3_object_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_acl", value)


if not MYPY:
    class CertificateAuthorityCrlDistributionPointExtensionConfigurationArgsDict(TypedDict):
        """
        Configures the default behavior of the CRL Distribution Point extension for certificates issued by your certificate authority
        """
        omit_extension: pulumi.Input[bool]
        """
        Configures whether the CRL Distribution Point extension should be populated with the default URL to the CRL. If set to `true` , then the CDP extension will not be present in any certificates issued by that CA unless otherwise specified through CSR or API passthrough.

        > Only set this if you have another way to distribute the CRL Distribution Points for certificates issued by your CA, such as the Matter Distributed Compliance Ledger.
        > 
        > This configuration cannot be enabled with a custom CNAME set.
        """
elif False:
    CertificateAuthorityCrlDistributionPointExtensionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCrlDistributionPointExtensionConfigurationArgs:
    def __init__(__self__, *,
                 omit_extension: pulumi.Input[bool]):
        """
        Configures the default behavior of the CRL Distribution Point extension for certificates issued by your certificate authority
        :param pulumi.Input[bool] omit_extension: Configures whether the CRL Distribution Point extension should be populated with the default URL to the CRL. If set to `true` , then the CDP extension will not be present in any certificates issued by that CA unless otherwise specified through CSR or API passthrough.
               
               > Only set this if you have another way to distribute the CRL Distribution Points for certificates issued by your CA, such as the Matter Distributed Compliance Ledger.
               > 
               > This configuration cannot be enabled with a custom CNAME set.
        """
        pulumi.set(__self__, "omit_extension", omit_extension)

    @property
    @pulumi.getter(name="omitExtension")
    def omit_extension(self) -> pulumi.Input[bool]:
        """
        Configures whether the CRL Distribution Point extension should be populated with the default URL to the CRL. If set to `true` , then the CDP extension will not be present in any certificates issued by that CA unless otherwise specified through CSR or API passthrough.

        > Only set this if you have another way to distribute the CRL Distribution Points for certificates issued by your CA, such as the Matter Distributed Compliance Ledger.
        > 
        > This configuration cannot be enabled with a custom CNAME set.
        """
        return pulumi.get(self, "omit_extension")

    @omit_extension.setter
    def omit_extension(self, value: pulumi.Input[bool]):
        pulumi.set(self, "omit_extension", value)


if not MYPY:
    class CertificateAuthorityCsrExtensionsArgsDict(TypedDict):
        """
        Structure that contains CSR pass though extensions information.
        """
        key_usage: NotRequired[pulumi.Input['CertificateAuthorityKeyUsageArgsDict']]
        """
        Indicates the purpose of the certificate and of the key contained in the certificate.
        """
        subject_information_access: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityAccessDescriptionArgsDict']]]]
        """
        For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see [Subject Information Access](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2) in RFC 5280.
        """
elif False:
    CertificateAuthorityCsrExtensionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCsrExtensionsArgs:
    def __init__(__self__, *,
                 key_usage: Optional[pulumi.Input['CertificateAuthorityKeyUsageArgs']] = None,
                 subject_information_access: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityAccessDescriptionArgs']]]] = None):
        """
        Structure that contains CSR pass though extensions information.
        :param pulumi.Input['CertificateAuthorityKeyUsageArgs'] key_usage: Indicates the purpose of the certificate and of the key contained in the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityAccessDescriptionArgs']]] subject_information_access: For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see [Subject Information Access](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2) in RFC 5280.
        """
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_information_access is not None:
            pulumi.set(__self__, "subject_information_access", subject_information_access)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input['CertificateAuthorityKeyUsageArgs']]:
        """
        Indicates the purpose of the certificate and of the key contained in the certificate.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input['CertificateAuthorityKeyUsageArgs']]):
        pulumi.set(self, "key_usage", value)

    @property
    @pulumi.getter(name="subjectInformationAccess")
    def subject_information_access(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityAccessDescriptionArgs']]]]:
        """
        For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see [Subject Information Access](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2) in RFC 5280.
        """
        return pulumi.get(self, "subject_information_access")

    @subject_information_access.setter
    def subject_information_access(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityAccessDescriptionArgs']]]]):
        pulumi.set(self, "subject_information_access", value)


if not MYPY:
    class CertificateAuthorityCustomAttributeArgsDict(TypedDict):
        """
        Structure that contains X.500 attribute type and value.
        """
        object_identifier: pulumi.Input[str]
        value: pulumi.Input[str]
elif False:
    CertificateAuthorityCustomAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCustomAttributeArgs:
    def __init__(__self__, *,
                 object_identifier: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Structure that contains X.500 attribute type and value.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> pulumi.Input[str]:
        return pulumi.get(self, "object_identifier")

    @object_identifier.setter
    def object_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_identifier", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CertificateAuthorityEdiPartyNameArgsDict(TypedDict):
        """
        Structure that contains X.509 EdiPartyName information.
        """
        party_name: pulumi.Input[str]
        name_assigner: NotRequired[pulumi.Input[str]]
elif False:
    CertificateAuthorityEdiPartyNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityEdiPartyNameArgs:
    def __init__(__self__, *,
                 party_name: pulumi.Input[str],
                 name_assigner: Optional[pulumi.Input[str]] = None):
        """
        Structure that contains X.509 EdiPartyName information.
        """
        pulumi.set(__self__, "party_name", party_name)
        if name_assigner is not None:
            pulumi.set(__self__, "name_assigner", name_assigner)

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "party_name")

    @party_name.setter
    def party_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "party_name", value)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name_assigner")

    @name_assigner.setter
    def name_assigner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_assigner", value)


if not MYPY:
    class CertificateAuthorityGeneralNameArgsDict(TypedDict):
        """
        Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
        """
        directory_name: NotRequired[pulumi.Input['CertificateAuthoritySubjectArgsDict']]
        dns_name: NotRequired[pulumi.Input[str]]
        edi_party_name: NotRequired[pulumi.Input['CertificateAuthorityEdiPartyNameArgsDict']]
        ip_address: NotRequired[pulumi.Input[str]]
        other_name: NotRequired[pulumi.Input['CertificateAuthorityOtherNameArgsDict']]
        registered_id: NotRequired[pulumi.Input[str]]
        rfc822_name: NotRequired[pulumi.Input[str]]
        uniform_resource_identifier: NotRequired[pulumi.Input[str]]
elif False:
    CertificateAuthorityGeneralNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityGeneralNameArgs:
    def __init__(__self__, *,
                 directory_name: Optional[pulumi.Input['CertificateAuthoritySubjectArgs']] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 edi_party_name: Optional[pulumi.Input['CertificateAuthorityEdiPartyNameArgs']] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 other_name: Optional[pulumi.Input['CertificateAuthorityOtherNameArgs']] = None,
                 registered_id: Optional[pulumi.Input[str]] = None,
                 rfc822_name: Optional[pulumi.Input[str]] = None,
                 uniform_resource_identifier: Optional[pulumi.Input[str]] = None):
        """
        Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input['CertificateAuthoritySubjectArgs']]:
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input['CertificateAuthoritySubjectArgs']]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional[pulumi.Input['CertificateAuthorityEdiPartyNameArgs']]:
        return pulumi.get(self, "edi_party_name")

    @edi_party_name.setter
    def edi_party_name(self, value: Optional[pulumi.Input['CertificateAuthorityEdiPartyNameArgs']]):
        pulumi.set(self, "edi_party_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional[pulumi.Input['CertificateAuthorityOtherNameArgs']]:
        return pulumi.get(self, "other_name")

    @other_name.setter
    def other_name(self, value: Optional[pulumi.Input['CertificateAuthorityOtherNameArgs']]):
        pulumi.set(self, "other_name", value)

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "registered_id")

    @registered_id.setter
    def registered_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registered_id", value)

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "rfc822_name")

    @rfc822_name.setter
    def rfc822_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc822_name", value)

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uniform_resource_identifier")

    @uniform_resource_identifier.setter
    def uniform_resource_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uniform_resource_identifier", value)


if not MYPY:
    class CertificateAuthorityKeyUsageArgsDict(TypedDict):
        """
        Structure that contains X.509 KeyUsage information.
        """
        crl_sign: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to sign CRLs.
        """
        data_encipherment: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to decipher data.
        """
        decipher_only: NotRequired[pulumi.Input[bool]]
        """
        Key can be used only to decipher data.
        """
        digital_signature: NotRequired[pulumi.Input[bool]]
        """
        Key can be used for digital signing.
        """
        encipher_only: NotRequired[pulumi.Input[bool]]
        """
        Key can be used only to encipher data.
        """
        key_agreement: NotRequired[pulumi.Input[bool]]
        """
        Key can be used in a key-agreement protocol.
        """
        key_cert_sign: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to sign certificates.
        """
        key_encipherment: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to encipher data.
        """
        non_repudiation: NotRequired[pulumi.Input[bool]]
        """
        Key can be used for non-repudiation.
        """
elif False:
    CertificateAuthorityKeyUsageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityKeyUsageArgs:
    def __init__(__self__, *,
                 crl_sign: Optional[pulumi.Input[bool]] = None,
                 data_encipherment: Optional[pulumi.Input[bool]] = None,
                 decipher_only: Optional[pulumi.Input[bool]] = None,
                 digital_signature: Optional[pulumi.Input[bool]] = None,
                 encipher_only: Optional[pulumi.Input[bool]] = None,
                 key_agreement: Optional[pulumi.Input[bool]] = None,
                 key_cert_sign: Optional[pulumi.Input[bool]] = None,
                 key_encipherment: Optional[pulumi.Input[bool]] = None,
                 non_repudiation: Optional[pulumi.Input[bool]] = None):
        """
        Structure that contains X.509 KeyUsage information.
        :param pulumi.Input[bool] crl_sign: Key can be used to sign CRLs.
        :param pulumi.Input[bool] data_encipherment: Key can be used to decipher data.
        :param pulumi.Input[bool] decipher_only: Key can be used only to decipher data.
        :param pulumi.Input[bool] digital_signature: Key can be used for digital signing.
        :param pulumi.Input[bool] encipher_only: Key can be used only to encipher data.
        :param pulumi.Input[bool] key_agreement: Key can be used in a key-agreement protocol.
        :param pulumi.Input[bool] key_cert_sign: Key can be used to sign certificates.
        :param pulumi.Input[bool] key_encipherment: Key can be used to encipher data.
        :param pulumi.Input[bool] non_repudiation: Key can be used for non-repudiation.
        """
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to sign CRLs.
        """
        return pulumi.get(self, "crl_sign")

    @crl_sign.setter
    def crl_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crl_sign", value)

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to decipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @data_encipherment.setter
    def data_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_encipherment", value)

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used only to decipher data.
        """
        return pulumi.get(self, "decipher_only")

    @decipher_only.setter
    def decipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decipher_only", value)

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used for digital signing.
        """
        return pulumi.get(self, "digital_signature")

    @digital_signature.setter
    def digital_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "digital_signature", value)

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used only to encipher data.
        """
        return pulumi.get(self, "encipher_only")

    @encipher_only.setter
    def encipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encipher_only", value)

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used in a key-agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @key_agreement.setter
    def key_agreement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_agreement", value)

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to sign certificates.
        """
        return pulumi.get(self, "key_cert_sign")

    @key_cert_sign.setter
    def key_cert_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_cert_sign", value)

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to encipher data.
        """
        return pulumi.get(self, "key_encipherment")

    @key_encipherment.setter
    def key_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_encipherment", value)

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used for non-repudiation.
        """
        return pulumi.get(self, "non_repudiation")

    @non_repudiation.setter
    def non_repudiation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "non_repudiation", value)


if not MYPY:
    class CertificateAuthorityOcspConfigurationArgsDict(TypedDict):
        """
        Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
        """
        enabled: pulumi.Input[bool]
        """
        Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
        """
        ocsp_custom_cname: NotRequired[pulumi.Input[str]]
        """
        By default, AWS Private CA injects an Amazon domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.

        > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
elif False:
    CertificateAuthorityOcspConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityOcspConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 ocsp_custom_cname: Optional[pulumi.Input[str]] = None):
        """
        Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
        :param pulumi.Input[bool] enabled: Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
        :param pulumi.Input[str] ocsp_custom_cname: By default, AWS Private CA injects an Amazon domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.
               
               > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        pulumi.set(__self__, "enabled", enabled)
        if ocsp_custom_cname is not None:
            pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> Optional[pulumi.Input[str]]:
        """
        By default, AWS Private CA injects an Amazon domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.

        > The content of a Canonical Name (CNAME) record must conform to [RFC2396](https://docs.aws.amazon.com/https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        return pulumi.get(self, "ocsp_custom_cname")

    @ocsp_custom_cname.setter
    def ocsp_custom_cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocsp_custom_cname", value)


if not MYPY:
    class CertificateAuthorityOtherNameArgsDict(TypedDict):
        """
        Structure that contains X.509 OtherName information.
        """
        type_id: pulumi.Input[str]
        value: pulumi.Input[str]
elif False:
    CertificateAuthorityOtherNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityOtherNameArgs:
    def __init__(__self__, *,
                 type_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Structure that contains X.509 OtherName information.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type_id")

    @type_id.setter
    def type_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CertificateAuthorityRevocationConfigurationArgsDict(TypedDict):
        """
        Certificate Authority revocation information.
        """
        crl_configuration: NotRequired[pulumi.Input['CertificateAuthorityCrlConfigurationArgsDict']]
        """
        Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
        """
        ocsp_configuration: NotRequired[pulumi.Input['CertificateAuthorityOcspConfigurationArgsDict']]
        """
        Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
        """
elif False:
    CertificateAuthorityRevocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityRevocationConfigurationArgs:
    def __init__(__self__, *,
                 crl_configuration: Optional[pulumi.Input['CertificateAuthorityCrlConfigurationArgs']] = None,
                 ocsp_configuration: Optional[pulumi.Input['CertificateAuthorityOcspConfigurationArgs']] = None):
        """
        Certificate Authority revocation information.
        :param pulumi.Input['CertificateAuthorityCrlConfigurationArgs'] crl_configuration: Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
        :param pulumi.Input['CertificateAuthorityOcspConfigurationArgs'] ocsp_configuration: Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
        """
        if crl_configuration is not None:
            pulumi.set(__self__, "crl_configuration", crl_configuration)
        if ocsp_configuration is not None:
            pulumi.set(__self__, "ocsp_configuration", ocsp_configuration)

    @property
    @pulumi.getter(name="crlConfiguration")
    def crl_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityCrlConfigurationArgs']]:
        """
        Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
        """
        return pulumi.get(self, "crl_configuration")

    @crl_configuration.setter
    def crl_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityCrlConfigurationArgs']]):
        pulumi.set(self, "crl_configuration", value)

    @property
    @pulumi.getter(name="ocspConfiguration")
    def ocsp_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityOcspConfigurationArgs']]:
        """
        Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA.
        """
        return pulumi.get(self, "ocsp_configuration")

    @ocsp_configuration.setter
    def ocsp_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityOcspConfigurationArgs']]):
        pulumi.set(self, "ocsp_configuration", value)


if not MYPY:
    class CertificateAuthoritySubjectArgsDict(TypedDict):
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        common_name: NotRequired[pulumi.Input[str]]
        country: NotRequired[pulumi.Input[str]]
        custom_attributes: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCustomAttributeArgsDict']]]]
        distinguished_name_qualifier: NotRequired[pulumi.Input[str]]
        generation_qualifier: NotRequired[pulumi.Input[str]]
        given_name: NotRequired[pulumi.Input[str]]
        initials: NotRequired[pulumi.Input[str]]
        locality: NotRequired[pulumi.Input[str]]
        organization: NotRequired[pulumi.Input[str]]
        organizational_unit: NotRequired[pulumi.Input[str]]
        pseudonym: NotRequired[pulumi.Input[str]]
        serial_number: NotRequired[pulumi.Input[str]]
        state: NotRequired[pulumi.Input[str]]
        surname: NotRequired[pulumi.Input[str]]
        title: NotRequired[pulumi.Input[str]]
elif False:
    CertificateAuthoritySubjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthoritySubjectArgs:
    def __init__(__self__, *,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 custom_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCustomAttributeArgs']]]] = None,
                 distinguished_name_qualifier: Optional[pulumi.Input[str]] = None,
                 generation_qualifier: Optional[pulumi.Input[str]] = None,
                 given_name: Optional[pulumi.Input[str]] = None,
                 initials: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 pseudonym: Optional[pulumi.Input[str]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 surname: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCustomAttributeArgs']]]]:
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCustomAttributeArgs']]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "distinguished_name_qualifier")

    @distinguished_name_qualifier.setter
    def distinguished_name_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distinguished_name_qualifier", value)

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "generation_qualifier")

    @generation_qualifier.setter
    def generation_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation_qualifier", value)

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "given_name", value)

    @property
    @pulumi.getter
    def initials(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "initials")

    @initials.setter
    def initials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initials", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pseudonym")

    @pseudonym.setter
    def pseudonym(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pseudonym", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def surname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "surname")

    @surname.setter
    def surname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "surname", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


if not MYPY:
    class CertificateCustomAttributeArgsDict(TypedDict):
        """
        Defines the X.500 relative distinguished name (RDN).
        """
        object_identifier: pulumi.Input[str]
        """
        Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
        """
        value: pulumi.Input[str]
        """
        Specifies the attribute value of relative distinguished name (RDN).
        """
elif False:
    CertificateCustomAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateCustomAttributeArgs:
    def __init__(__self__, *,
                 object_identifier: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Defines the X.500 relative distinguished name (RDN).
        :param pulumi.Input[str] object_identifier: Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
        :param pulumi.Input[str] value: Specifies the attribute value of relative distinguished name (RDN).
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> pulumi.Input[str]:
        """
        Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
        """
        return pulumi.get(self, "object_identifier")

    @object_identifier.setter
    def object_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_identifier", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the attribute value of relative distinguished name (RDN).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CertificateCustomExtensionArgsDict(TypedDict):
        """
        Specifies the X.509 extension information for a certificate.
         Extensions present in ``CustomExtensions`` follow the ``ApiPassthrough`` [template rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations).
        """
        object_identifier: pulumi.Input[str]
        """
        Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        value: pulumi.Input[str]
        """
        Specifies the base64-encoded value of the X.509 extension.
        """
        critical: NotRequired[pulumi.Input[bool]]
        """
        Specifies the critical flag of the X.509 extension.
        """
elif False:
    CertificateCustomExtensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateCustomExtensionArgs:
    def __init__(__self__, *,
                 object_identifier: pulumi.Input[str],
                 value: pulumi.Input[str],
                 critical: Optional[pulumi.Input[bool]] = None):
        """
        Specifies the X.509 extension information for a certificate.
         Extensions present in ``CustomExtensions`` follow the ``ApiPassthrough`` [template rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations).
        :param pulumi.Input[str] object_identifier: Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        :param pulumi.Input[str] value: Specifies the base64-encoded value of the X.509 extension.
        :param pulumi.Input[bool] critical: Specifies the critical flag of the X.509 extension.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> pulumi.Input[str]:
        """
        Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        return pulumi.get(self, "object_identifier")

    @object_identifier.setter
    def object_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_identifier", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the base64-encoded value of the X.509 extension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the critical flag of the X.509 extension.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "critical", value)


if not MYPY:
    class CertificateEdiPartyNameArgsDict(TypedDict):
        """
        Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
        """
        name_assigner: pulumi.Input[str]
        """
        Specifies the name assigner.
        """
        party_name: pulumi.Input[str]
        """
        Specifies the party name.
        """
elif False:
    CertificateEdiPartyNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateEdiPartyNameArgs:
    def __init__(__self__, *,
                 name_assigner: pulumi.Input[str],
                 party_name: pulumi.Input[str]):
        """
        Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
        :param pulumi.Input[str] name_assigner: Specifies the name assigner.
        :param pulumi.Input[str] party_name: Specifies the party name.
        """
        pulumi.set(__self__, "name_assigner", name_assigner)
        pulumi.set(__self__, "party_name", party_name)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> pulumi.Input[str]:
        """
        Specifies the name assigner.
        """
        return pulumi.get(self, "name_assigner")

    @name_assigner.setter
    def name_assigner(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_assigner", value)

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> pulumi.Input[str]:
        """
        Specifies the party name.
        """
        return pulumi.get(self, "party_name")

    @party_name.setter
    def party_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "party_name", value)


if not MYPY:
    class CertificateExtendedKeyUsageArgsDict(TypedDict):
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        """
        extended_key_usage_object_identifier: NotRequired[pulumi.Input[str]]
        """
        Specifies a custom ``ExtendedKeyUsage`` with an object identifier (OID).
        """
        extended_key_usage_type: NotRequired[pulumi.Input[str]]
        """
        Specifies a standard ``ExtendedKeyUsage`` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
        """
elif False:
    CertificateExtendedKeyUsageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateExtendedKeyUsageArgs:
    def __init__(__self__, *,
                 extended_key_usage_object_identifier: Optional[pulumi.Input[str]] = None,
                 extended_key_usage_type: Optional[pulumi.Input[str]] = None):
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        :param pulumi.Input[str] extended_key_usage_object_identifier: Specifies a custom ``ExtendedKeyUsage`` with an object identifier (OID).
        :param pulumi.Input[str] extended_key_usage_type: Specifies a standard ``ExtendedKeyUsage`` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
        """
        if extended_key_usage_object_identifier is not None:
            pulumi.set(__self__, "extended_key_usage_object_identifier", extended_key_usage_object_identifier)
        if extended_key_usage_type is not None:
            pulumi.set(__self__, "extended_key_usage_type", extended_key_usage_type)

    @property
    @pulumi.getter(name="extendedKeyUsageObjectIdentifier")
    def extended_key_usage_object_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a custom ``ExtendedKeyUsage`` with an object identifier (OID).
        """
        return pulumi.get(self, "extended_key_usage_object_identifier")

    @extended_key_usage_object_identifier.setter
    def extended_key_usage_object_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_key_usage_object_identifier", value)

    @property
    @pulumi.getter(name="extendedKeyUsageType")
    def extended_key_usage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a standard ``ExtendedKeyUsage`` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
        """
        return pulumi.get(self, "extended_key_usage_type")

    @extended_key_usage_type.setter
    def extended_key_usage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_key_usage_type", value)


if not MYPY:
    class CertificateExtensionsArgsDict(TypedDict):
        """
        Contains X.509 extension information for a certificate.
        """
        certificate_policies: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyInformationArgsDict']]]]
        """
        Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
         In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
        """
        custom_extensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateCustomExtensionArgsDict']]]]
        """
        Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        extended_key_usage: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateExtendedKeyUsageArgsDict']]]]
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        """
        key_usage: NotRequired[pulumi.Input['CertificateKeyUsageArgsDict']]
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        """
        subject_alternative_names: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateGeneralNameArgsDict']]]]
        """
        The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
        """
elif False:
    CertificateExtensionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateExtensionsArgs:
    def __init__(__self__, *,
                 certificate_policies: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyInformationArgs']]]] = None,
                 custom_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomExtensionArgs']]]] = None,
                 extended_key_usage: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtendedKeyUsageArgs']]]] = None,
                 key_usage: Optional[pulumi.Input['CertificateKeyUsageArgs']] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateGeneralNameArgs']]]] = None):
        """
        Contains X.509 extension information for a certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificatePolicyInformationArgs']]] certificate_policies: Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
                In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCustomExtensionArgs']]] custom_extensions: Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        :param pulumi.Input[Sequence[pulumi.Input['CertificateExtendedKeyUsageArgs']]] extended_key_usage: Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        :param pulumi.Input['CertificateKeyUsageArgs'] key_usage: Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateGeneralNameArgs']]] subject_alternative_names: The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
        """
        if certificate_policies is not None:
            pulumi.set(__self__, "certificate_policies", certificate_policies)
        if custom_extensions is not None:
            pulumi.set(__self__, "custom_extensions", custom_extensions)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="certificatePolicies")
    def certificate_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyInformationArgs']]]]:
        """
        Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
         In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
        """
        return pulumi.get(self, "certificate_policies")

    @certificate_policies.setter
    def certificate_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyInformationArgs']]]]):
        pulumi.set(self, "certificate_policies", value)

    @property
    @pulumi.getter(name="customExtensions")
    def custom_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomExtensionArgs']]]]:
        """
        Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        return pulumi.get(self, "custom_extensions")

    @custom_extensions.setter
    def custom_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomExtensionArgs']]]]):
        pulumi.set(self, "custom_extensions", value)

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtendedKeyUsageArgs']]]]:
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        """
        return pulumi.get(self, "extended_key_usage")

    @extended_key_usage.setter
    def extended_key_usage(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateExtendedKeyUsageArgs']]]]):
        pulumi.set(self, "extended_key_usage", value)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input['CertificateKeyUsageArgs']]:
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input['CertificateKeyUsageArgs']]):
        pulumi.set(self, "key_usage", value)

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateGeneralNameArgs']]]]:
        """
        The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateGeneralNameArgs']]]]):
        pulumi.set(self, "subject_alternative_names", value)


if not MYPY:
    class CertificateGeneralNameArgsDict(TypedDict):
        """
        Describes an ASN.1 X.400 ``GeneralName`` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280). Only one of the following naming options should be provided. Providing more than one option results in an ``InvalidArgsException`` error.
        """
        directory_name: NotRequired[pulumi.Input['CertificateSubjectArgsDict']]
        """
        Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
        """
        dns_name: NotRequired[pulumi.Input[str]]
        """
        Represents ``GeneralName`` as a DNS name.
        """
        edi_party_name: NotRequired[pulumi.Input['CertificateEdiPartyNameArgsDict']]
        """
        Represents ``GeneralName`` as an ``EdiPartyName`` object.
        """
        ip_address: NotRequired[pulumi.Input[str]]
        """
        Represents ``GeneralName`` as an IPv4 or IPv6 address.
        """
        other_name: NotRequired[pulumi.Input['CertificateOtherNameArgsDict']]
        """
        Represents ``GeneralName`` using an ``OtherName`` object.
        """
        registered_id: NotRequired[pulumi.Input[str]]
        """
        Represents ``GeneralName`` as an object identifier (OID).
        """
        rfc822_name: NotRequired[pulumi.Input[str]]
        """
        Represents ``GeneralName`` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
        """
        uniform_resource_identifier: NotRequired[pulumi.Input[str]]
        """
        Represents ``GeneralName`` as a URI.
        """
elif False:
    CertificateGeneralNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateGeneralNameArgs:
    def __init__(__self__, *,
                 directory_name: Optional[pulumi.Input['CertificateSubjectArgs']] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 edi_party_name: Optional[pulumi.Input['CertificateEdiPartyNameArgs']] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 other_name: Optional[pulumi.Input['CertificateOtherNameArgs']] = None,
                 registered_id: Optional[pulumi.Input[str]] = None,
                 rfc822_name: Optional[pulumi.Input[str]] = None,
                 uniform_resource_identifier: Optional[pulumi.Input[str]] = None):
        """
        Describes an ASN.1 X.400 ``GeneralName`` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280). Only one of the following naming options should be provided. Providing more than one option results in an ``InvalidArgsException`` error.
        :param pulumi.Input['CertificateSubjectArgs'] directory_name: Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
        :param pulumi.Input[str] dns_name: Represents ``GeneralName`` as a DNS name.
        :param pulumi.Input['CertificateEdiPartyNameArgs'] edi_party_name: Represents ``GeneralName`` as an ``EdiPartyName`` object.
        :param pulumi.Input[str] ip_address: Represents ``GeneralName`` as an IPv4 or IPv6 address.
        :param pulumi.Input['CertificateOtherNameArgs'] other_name: Represents ``GeneralName`` using an ``OtherName`` object.
        :param pulumi.Input[str] registered_id: Represents ``GeneralName`` as an object identifier (OID).
        :param pulumi.Input[str] rfc822_name: Represents ``GeneralName`` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
        :param pulumi.Input[str] uniform_resource_identifier: Represents ``GeneralName`` as a URI.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input['CertificateSubjectArgs']]:
        """
        Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input['CertificateSubjectArgs']]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        Represents ``GeneralName`` as a DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional[pulumi.Input['CertificateEdiPartyNameArgs']]:
        """
        Represents ``GeneralName`` as an ``EdiPartyName`` object.
        """
        return pulumi.get(self, "edi_party_name")

    @edi_party_name.setter
    def edi_party_name(self, value: Optional[pulumi.Input['CertificateEdiPartyNameArgs']]):
        pulumi.set(self, "edi_party_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Represents ``GeneralName`` as an IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional[pulumi.Input['CertificateOtherNameArgs']]:
        """
        Represents ``GeneralName`` using an ``OtherName`` object.
        """
        return pulumi.get(self, "other_name")

    @other_name.setter
    def other_name(self, value: Optional[pulumi.Input['CertificateOtherNameArgs']]):
        pulumi.set(self, "other_name", value)

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[pulumi.Input[str]]:
        """
        Represents ``GeneralName`` as an object identifier (OID).
        """
        return pulumi.get(self, "registered_id")

    @registered_id.setter
    def registered_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registered_id", value)

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[pulumi.Input[str]]:
        """
        Represents ``GeneralName`` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
        """
        return pulumi.get(self, "rfc822_name")

    @rfc822_name.setter
    def rfc822_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc822_name", value)

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Represents ``GeneralName`` as a URI.
        """
        return pulumi.get(self, "uniform_resource_identifier")

    @uniform_resource_identifier.setter
    def uniform_resource_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uniform_resource_identifier", value)


if not MYPY:
    class CertificateKeyUsageArgsDict(TypedDict):
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        """
        crl_sign: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to sign CRLs.
        """
        data_encipherment: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to decipher data.
        """
        decipher_only: NotRequired[pulumi.Input[bool]]
        """
        Key can be used only to decipher data.
        """
        digital_signature: NotRequired[pulumi.Input[bool]]
        """
        Key can be used for digital signing.
        """
        encipher_only: NotRequired[pulumi.Input[bool]]
        """
        Key can be used only to encipher data.
        """
        key_agreement: NotRequired[pulumi.Input[bool]]
        """
        Key can be used in a key-agreement protocol.
        """
        key_cert_sign: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to sign certificates.
        """
        key_encipherment: NotRequired[pulumi.Input[bool]]
        """
        Key can be used to encipher data.
        """
        non_repudiation: NotRequired[pulumi.Input[bool]]
        """
        Key can be used for non-repudiation.
        """
elif False:
    CertificateKeyUsageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateKeyUsageArgs:
    def __init__(__self__, *,
                 crl_sign: Optional[pulumi.Input[bool]] = None,
                 data_encipherment: Optional[pulumi.Input[bool]] = None,
                 decipher_only: Optional[pulumi.Input[bool]] = None,
                 digital_signature: Optional[pulumi.Input[bool]] = None,
                 encipher_only: Optional[pulumi.Input[bool]] = None,
                 key_agreement: Optional[pulumi.Input[bool]] = None,
                 key_cert_sign: Optional[pulumi.Input[bool]] = None,
                 key_encipherment: Optional[pulumi.Input[bool]] = None,
                 non_repudiation: Optional[pulumi.Input[bool]] = None):
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        :param pulumi.Input[bool] crl_sign: Key can be used to sign CRLs.
        :param pulumi.Input[bool] data_encipherment: Key can be used to decipher data.
        :param pulumi.Input[bool] decipher_only: Key can be used only to decipher data.
        :param pulumi.Input[bool] digital_signature: Key can be used for digital signing.
        :param pulumi.Input[bool] encipher_only: Key can be used only to encipher data.
        :param pulumi.Input[bool] key_agreement: Key can be used in a key-agreement protocol.
        :param pulumi.Input[bool] key_cert_sign: Key can be used to sign certificates.
        :param pulumi.Input[bool] key_encipherment: Key can be used to encipher data.
        :param pulumi.Input[bool] non_repudiation: Key can be used for non-repudiation.
        """
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to sign CRLs.
        """
        return pulumi.get(self, "crl_sign")

    @crl_sign.setter
    def crl_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crl_sign", value)

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to decipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @data_encipherment.setter
    def data_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_encipherment", value)

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used only to decipher data.
        """
        return pulumi.get(self, "decipher_only")

    @decipher_only.setter
    def decipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decipher_only", value)

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used for digital signing.
        """
        return pulumi.get(self, "digital_signature")

    @digital_signature.setter
    def digital_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "digital_signature", value)

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used only to encipher data.
        """
        return pulumi.get(self, "encipher_only")

    @encipher_only.setter
    def encipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encipher_only", value)

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used in a key-agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @key_agreement.setter
    def key_agreement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_agreement", value)

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to sign certificates.
        """
        return pulumi.get(self, "key_cert_sign")

    @key_cert_sign.setter
    def key_cert_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_cert_sign", value)

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used to encipher data.
        """
        return pulumi.get(self, "key_encipherment")

    @key_encipherment.setter
    def key_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_encipherment", value)

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[pulumi.Input[bool]]:
        """
        Key can be used for non-repudiation.
        """
        return pulumi.get(self, "non_repudiation")

    @non_repudiation.setter
    def non_repudiation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "non_repudiation", value)


if not MYPY:
    class CertificateOtherNameArgsDict(TypedDict):
        """
        Defines a custom ASN.1 X.400 ``GeneralName`` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        """
        type_id: pulumi.Input[str]
        """
        Specifies an OID.
        """
        value: pulumi.Input[str]
        """
        Specifies an OID value.
        """
elif False:
    CertificateOtherNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateOtherNameArgs:
    def __init__(__self__, *,
                 type_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Defines a custom ASN.1 X.400 ``GeneralName`` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        :param pulumi.Input[str] type_id: Specifies an OID.
        :param pulumi.Input[str] value: Specifies an OID value.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> pulumi.Input[str]:
        """
        Specifies an OID.
        """
        return pulumi.get(self, "type_id")

    @type_id.setter
    def type_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies an OID value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CertificatePolicyInformationArgsDict(TypedDict):
        """
        Defines the X.509 ``CertificatePolicies`` extension.
        """
        cert_policy_id: pulumi.Input[str]
        """
        Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        """
        policy_qualifiers: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyQualifierInfoArgsDict']]]]
        """
        Modifies the given ``CertPolicyId`` with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
elif False:
    CertificatePolicyInformationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificatePolicyInformationArgs:
    def __init__(__self__, *,
                 cert_policy_id: pulumi.Input[str],
                 policy_qualifiers: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyQualifierInfoArgs']]]] = None):
        """
        Defines the X.509 ``CertificatePolicies`` extension.
        :param pulumi.Input[str] cert_policy_id: Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        :param pulumi.Input[Sequence[pulumi.Input['CertificatePolicyQualifierInfoArgs']]] policy_qualifiers: Modifies the given ``CertPolicyId`` with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
        pulumi.set(__self__, "cert_policy_id", cert_policy_id)
        if policy_qualifiers is not None:
            pulumi.set(__self__, "policy_qualifiers", policy_qualifiers)

    @property
    @pulumi.getter(name="certPolicyId")
    def cert_policy_id(self) -> pulumi.Input[str]:
        """
        Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        """
        return pulumi.get(self, "cert_policy_id")

    @cert_policy_id.setter
    def cert_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_policy_id", value)

    @property
    @pulumi.getter(name="policyQualifiers")
    def policy_qualifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyQualifierInfoArgs']]]]:
        """
        Modifies the given ``CertPolicyId`` with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
        return pulumi.get(self, "policy_qualifiers")

    @policy_qualifiers.setter
    def policy_qualifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePolicyQualifierInfoArgs']]]]):
        pulumi.set(self, "policy_qualifiers", value)


if not MYPY:
    class CertificatePolicyQualifierInfoArgsDict(TypedDict):
        """
        Modifies the ``CertPolicyId`` of a ``PolicyInformation`` object with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
        policy_qualifier_id: pulumi.Input[str]
        """
        Identifies the qualifier modifying a ``CertPolicyId``.
        """
        qualifier: pulumi.Input['CertificateQualifierArgsDict']
        """
        Defines the qualifier type. AWS Private CA supports the use of a URI for a CPS qualifier in this field.
        """
elif False:
    CertificatePolicyQualifierInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificatePolicyQualifierInfoArgs:
    def __init__(__self__, *,
                 policy_qualifier_id: pulumi.Input[str],
                 qualifier: pulumi.Input['CertificateQualifierArgs']):
        """
        Modifies the ``CertPolicyId`` of a ``PolicyInformation`` object with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        :param pulumi.Input[str] policy_qualifier_id: Identifies the qualifier modifying a ``CertPolicyId``.
        :param pulumi.Input['CertificateQualifierArgs'] qualifier: Defines the qualifier type. AWS Private CA supports the use of a URI for a CPS qualifier in this field.
        """
        pulumi.set(__self__, "policy_qualifier_id", policy_qualifier_id)
        pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="policyQualifierId")
    def policy_qualifier_id(self) -> pulumi.Input[str]:
        """
        Identifies the qualifier modifying a ``CertPolicyId``.
        """
        return pulumi.get(self, "policy_qualifier_id")

    @policy_qualifier_id.setter
    def policy_qualifier_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_qualifier_id", value)

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Input['CertificateQualifierArgs']:
        """
        Defines the qualifier type. AWS Private CA supports the use of a URI for a CPS qualifier in this field.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: pulumi.Input['CertificateQualifierArgs']):
        pulumi.set(self, "qualifier", value)


if not MYPY:
    class CertificateQualifierArgsDict(TypedDict):
        """
        Defines a ``PolicyInformation`` qualifier. AWS Private CA supports the [certification practice statement (CPS) qualifier](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4) defined in RFC 5280.
        """
        cps_uri: pulumi.Input[str]
        """
        Contains a pointer to a certification practice statement (CPS) published by the CA.
        """
elif False:
    CertificateQualifierArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateQualifierArgs:
    def __init__(__self__, *,
                 cps_uri: pulumi.Input[str]):
        """
        Defines a ``PolicyInformation`` qualifier. AWS Private CA supports the [certification practice statement (CPS) qualifier](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4) defined in RFC 5280.
        :param pulumi.Input[str] cps_uri: Contains a pointer to a certification practice statement (CPS) published by the CA.
        """
        pulumi.set(__self__, "cps_uri", cps_uri)

    @property
    @pulumi.getter(name="cpsUri")
    def cps_uri(self) -> pulumi.Input[str]:
        """
        Contains a pointer to a certification practice statement (CPS) published by the CA.
        """
        return pulumi.get(self, "cps_uri")

    @cps_uri.setter
    def cps_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "cps_uri", value)


if not MYPY:
    class CertificateSubjectArgsDict(TypedDict):
        """
        Contains information about the certificate subject. The ``Subject`` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The ``Subject``must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
        common_name: NotRequired[pulumi.Input[str]]
        """
        For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
         Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
        """
        country: NotRequired[pulumi.Input[str]]
        """
        Two-digit code that specifies the country in which the certificate subject located.
        """
        custom_attributes: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateCustomAttributeArgsDict']]]]
        """
        Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
          Custom attributes cannot be used in combination with standard attributes.
        """
        distinguished_name_qualifier: NotRequired[pulumi.Input[str]]
        """
        Disambiguating information for the certificate subject.
        """
        generation_qualifier: NotRequired[pulumi.Input[str]]
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.
        """
        given_name: NotRequired[pulumi.Input[str]]
        """
        First name.
        """
        initials: NotRequired[pulumi.Input[str]]
        """
        Concatenation that typically contains the first letter of the *GivenName*, the first letter of the middle name if one exists, and the first letter of the *Surname*.
        """
        locality: NotRequired[pulumi.Input[str]]
        """
        The locality (such as a city or town) in which the certificate subject is located.
        """
        organization: NotRequired[pulumi.Input[str]]
        """
        Legal name of the organization with which the certificate subject is affiliated.
        """
        organizational_unit: NotRequired[pulumi.Input[str]]
        """
        A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
        """
        pseudonym: NotRequired[pulumi.Input[str]]
        """
        Typically a shortened version of a longer *GivenName*. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
        """
        serial_number: NotRequired[pulumi.Input[str]]
        """
        The certificate serial number.
        """
        state: NotRequired[pulumi.Input[str]]
        """
        State in which the subject of the certificate is located.
        """
        surname: NotRequired[pulumi.Input[str]]
        """
        Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
        """
        title: NotRequired[pulumi.Input[str]]
        """
        A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
        """
elif False:
    CertificateSubjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSubjectArgs:
    def __init__(__self__, *,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 custom_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomAttributeArgs']]]] = None,
                 distinguished_name_qualifier: Optional[pulumi.Input[str]] = None,
                 generation_qualifier: Optional[pulumi.Input[str]] = None,
                 given_name: Optional[pulumi.Input[str]] = None,
                 initials: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 pseudonym: Optional[pulumi.Input[str]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 surname: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Contains information about the certificate subject. The ``Subject`` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The ``Subject``must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        :param pulumi.Input[str] common_name: For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
                Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
        :param pulumi.Input[str] country: Two-digit code that specifies the country in which the certificate subject located.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCustomAttributeArgs']]] custom_attributes: Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
                 Custom attributes cannot be used in combination with standard attributes.
        :param pulumi.Input[str] distinguished_name_qualifier: Disambiguating information for the certificate subject.
        :param pulumi.Input[str] generation_qualifier: Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.
        :param pulumi.Input[str] given_name: First name.
        :param pulumi.Input[str] initials: Concatenation that typically contains the first letter of the *GivenName*, the first letter of the middle name if one exists, and the first letter of the *Surname*.
        :param pulumi.Input[str] locality: The locality (such as a city or town) in which the certificate subject is located.
        :param pulumi.Input[str] organization: Legal name of the organization with which the certificate subject is affiliated.
        :param pulumi.Input[str] organizational_unit: A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
        :param pulumi.Input[str] pseudonym: Typically a shortened version of a longer *GivenName*. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
        :param pulumi.Input[str] serial_number: The certificate serial number.
        :param pulumi.Input[str] state: State in which the subject of the certificate is located.
        :param pulumi.Input[str] surname: Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
        :param pulumi.Input[str] title: A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
         Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Two-digit code that specifies the country in which the certificate subject located.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomAttributeArgs']]]]:
        """
        Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
          Custom attributes cannot be used in combination with standard attributes.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCustomAttributeArgs']]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Disambiguating information for the certificate subject.
        """
        return pulumi.get(self, "distinguished_name_qualifier")

    @distinguished_name_qualifier.setter
    def distinguished_name_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distinguished_name_qualifier", value)

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.
        """
        return pulumi.get(self, "generation_qualifier")

    @generation_qualifier.setter
    def generation_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation_qualifier", value)

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name.
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "given_name", value)

    @property
    @pulumi.getter
    def initials(self) -> Optional[pulumi.Input[str]]:
        """
        Concatenation that typically contains the first letter of the *GivenName*, the first letter of the middle name if one exists, and the first letter of the *Surname*.
        """
        return pulumi.get(self, "initials")

    @initials.setter
    def initials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initials", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality (such as a city or town) in which the certificate subject is located.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Legal name of the organization with which the certificate subject is affiliated.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[str]]:
        """
        A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[pulumi.Input[str]]:
        """
        Typically a shortened version of a longer *GivenName*. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
        """
        return pulumi.get(self, "pseudonym")

    @pseudonym.setter
    def pseudonym(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pseudonym", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate serial number.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State in which the subject of the certificate is located.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def surname(self) -> Optional[pulumi.Input[str]]:
        """
        Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
        """
        return pulumi.get(self, "surname")

    @surname.setter
    def surname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "surname", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


if not MYPY:
    class CertificateValidityArgsDict(TypedDict):
        """
        Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years. You can issue a certificate by calling the ``IssueCertificate`` operation.
        """
        type: pulumi.Input[str]
        """
        Specifies whether the ``Value`` parameter represents days, months, or years.
        """
        value: pulumi.Input[float]
        """
        A long integer interpreted according to the value of ``Type``, below.
        """
elif False:
    CertificateValidityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateValidityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[float]):
        """
        Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years. You can issue a certificate by calling the ``IssueCertificate`` operation.
        :param pulumi.Input[str] type: Specifies whether the ``Value`` parameter represents days, months, or years.
        :param pulumi.Input[float] value: A long integer interpreted according to the value of ``Type``, below.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies whether the ``Value`` parameter represents days, months, or years.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        A long integer interpreted according to the value of ``Type``, below.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


