import numpy as np

#spectral data taken from McGPU spectra files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

# UNITS: Energy [eV], Photons per (mA * s * mm^2) (at 750 mm)

SPECTRUM60KV_AL35 = np.array([[ 15.0e3,3.69755e1],
[ 15.5e3,7.60284e1],
[ 16.0e3,1.44202e2],
[ 16.5e3,2.50543e2],
[ 17.0e3,4.14450e2],
[ 17.5e3,6.39255e2],
[ 18.0e3,9.45618e2],
[ 18.5e3,1.34175e3],
[ 19.0e3,1.82652e3],
[ 19.5e3,2.41447e3],
[ 20.0e3,3.09233e3],
[ 20.5e3,3.84197e3],
[ 21.0e3,4.71803e3],
[ 21.5e3,5.62049e3],
[ 22.0e3,6.62026e3],
[ 22.5e3,7.63616e3],
[ 23.0e3,8.71456e3],
[ 23.5e3,9.74511e3],
[ 24.0e3,1.08834e4],
[ 24.5e3,1.19128e4],
[ 25.0e3,1.29030e4],
[ 25.5e3,1.39615e4],
[ 26.0e3,1.49513e4],
[ 26.5e3,1.58474e4],
[ 27.0e3,1.67786e4],
[ 27.5e3,1.75912e4],
[ 28.0e3,1.84313e4],
[ 28.5e3,1.91184e4],
[ 29.0e3,1.98201e4],
[ 29.5e3,2.03437e4],
[ 30.0e3,2.08710e4],
[ 30.5e3,2.14021e4],
[ 31.0e3,2.17308e4],
[ 31.5e3,2.21404e4],
[ 32.0e3,2.24149e4],
[ 32.5e3,2.26680e4],
[ 33.0e3,2.28511e4],
[ 33.5e3,2.29787e4],
[ 34.0e3,2.30580e4],
[ 34.5e3,2.31126e4],
[ 35.0e3,2.30857e4],
[ 35.5e3,2.30500e4],
[ 36.0e3,2.29651e4],
[ 36.5e3,2.28233e4],
[ 37.0e3,2.26729e4],
[ 37.5e3,2.24744e4],
[ 38.0e3,2.22677e4],
[ 38.5e3,2.20139e4],
[ 39.0e3,2.17295e4],
[ 39.5e3,2.14377e4],
[ 40.0e3,2.11162e4],
[ 40.5e3,2.07658e4],
[ 41.0e3,2.03945e4],
[ 41.5e3,1.99959e4],
[ 42.0e3,1.95918e4],
[ 42.5e3,1.91819e4],
[ 43.0e3,1.87333e4],
[ 43.5e3,1.82994e4],
[ 44.0e3,1.78223e4],
[ 44.5e3,1.73535e4],
[ 45.0e3,1.68564e4],
[ 45.5e3,1.63673e4],
[ 46.0e3,1.58573e4],
[ 46.5e3,1.53279e4],
[ 47.0e3,1.48167e4],
[ 47.5e3,1.42818e4],
[ 48.0e3,1.37346e4],
[ 48.5e3,1.31995e4],
[ 49.0e3,1.26480e4],
[ 49.5e3,1.20818e4],
[ 50.0e3,1.15261e4],
[ 50.5e3,1.09583e4],
[ 51.0e3,1.03896e4],
[ 51.5e3,9.81948e3],
[ 52.0e3,9.23999e3],
[ 52.5e3,8.66863e3],
[ 53.0e3,8.08867e3],
[ 53.5e3,7.50874e3],
[ 54.0e3,6.92891e3],
[ 54.5e3,6.34320e3],
[ 55.0e3,5.76421e3],
[ 55.5e3,5.18055e3],
[ 56.0e3,4.59827e3],
[ 56.5e3,4.01745e3],
[ 57.0e3,3.43817e3],
[ 57.5e3,2.86051e3],
[ 58.0e3,2.28457e3],
[ 58.5e3,1.70884e3],
[ 59.0e3,1.13721e3],
[ 59.5e3,5.67110e2],
[ 60.0e3,-4.72342e1]])

SPECTRUM90KV_AL40 = np.array([[15.0e3,1.04178e1],
[ 15.5e3,2.39995e1],
[ 16.0e3,5.05336e1],
[ 16.5e3,9.64766e1],
[ 17.0e3,1.74507e2],
[ 17.5e3,2.91945e2],
[ 18.0e3,4.66386e2],
[ 18.5e3,7.11402e2],
[ 19.0e3,1.03605e3],
[ 19.5e3,1.46023e3],
[ 20.0e3,1.98617e3],
[ 20.5e3,2.61021e3],
[ 21.0e3,3.38544e3],
[ 21.5e3,4.24095e3],
[ 22.0e3,5.24354e3],
[ 22.5e3,6.32791e3],
[ 23.0e3,7.54120e3],
[ 23.5e3,8.77681e3],
[ 24.0e3,1.01946e4],
[ 24.5e3,1.15664e4],
[ 25.0e3,1.29585e4],
[ 25.5e3,1.44935e4],
[ 26.0e3,1.60105e4],
[ 26.5e3,1.74699e4],
[ 27.0e3,1.90277e4],
[ 27.5e3,2.04829e4],
[ 28.0e3,2.20221e4],
[ 28.5e3,2.33956e4],
[ 29.0e3,2.48280e4],
[ 29.5e3,2.60390e4],
[ 30.0e3,2.72837e4],
[ 30.5e3,2.85632e4],
[ 31.0e3,2.95578e4],
[ 31.5e3,3.06992e4],
[ 32.0e3,3.16468e4],
[ 32.5e3,3.25768e4],
[ 33.0e3,3.34075e4],
[ 33.5e3,3.41587e4],
[ 34.0e3,3.48395e4],
[ 34.5e3,3.54891e4],
[ 35.0e3,3.60055e4],
[ 35.5e3,3.65150e4],
[ 36.0e3,3.69445e4],
[ 36.5e3,3.72769e4],
[ 37.0e3,3.76006e4],
[ 37.5e3,3.78407e4],
[ 38.0e3,3.80723e4],
[ 38.5e3,3.82196e4],
[ 39.0e3,3.83128e4],
[ 39.5e3,3.83984e4],
[ 40.0e3,3.84307e4],
[ 40.5e3,3.84100e4],
[ 41.0e3,3.83524e4],
[ 41.5e3,3.82432e4],
[ 42.0e3,3.81287e4],
[ 42.5e3,3.80096e4],
[ 43.0e3,3.78105e4],
[ 43.5e3,3.76531e4],
[ 44.0e3,3.74023e4],
[ 44.5e3,3.71790e4],
[ 45.0e3,3.68942e4],
[ 45.5e3,3.66373e4],
[ 46.0e3,3.63352e4],
[ 46.5e3,3.59890e4],
[ 47.0e3,3.57000e4],
[ 47.5e3,3.53536e4],
[ 48.0e3,3.49795e4],
[ 48.5e3,3.46479e4],
[ 49.0e3,3.42752e4],
[ 49.5e3,3.38628e4],
[ 50.0e3,3.34899e4],
[ 50.5e3,3.30836e4],
[ 51.0e3,3.26791e4],
[ 51.5e3,3.22751e4],
[ 52.0e3,3.18398e4],
[ 52.5e3,3.14410e4],
[ 53.0e3,3.10103e4],
[ 53.5e3,3.05821e4],
[ 54.0e3,3.01563e4],
[ 54.5e3,2.97005e4],
[ 55.0e3,2.92796e4],
[ 55.5e3,2.88296e4],
[ 56.0e3,2.83824e4],
[ 56.5e3,2.79381e4],
[ 57.0e3,2.74965e4],
[ 57.5e3,2.70575e4],
[ 58.0e3,6.96222e4],
[ 58.5e3,2.61584e4],
[ 59.0e3,2.57269e4],
[ 59.5e3,1.01222e5],
[ 60.0e3,2.48164e4],
[ 60.5e3,2.43656e4],
[ 61.0e3,2.39174e4],
[ 61.5e3,2.34718e4],
[ 62.0e3,2.30288e4],
[ 62.5e3,2.25881e4],
[ 63.0e3,2.21258e4],
[ 63.5e3,2.16900e4],
[ 64.0e3,2.12564e4],
[ 64.5e3,2.08023e4],
[ 65.0e3,2.03509e4],
[ 65.5e3,1.99230e4],
[ 66.0e3,1.94765e4],
[ 66.5e3,1.90326e4],
[ 67.0e3,4.47529e4],
[ 67.5e3,1.81519e4],
[ 68.0e3,1.77151e4],
[ 68.5e3,1.72804e4],
[ 69.0e3,2.37937e4],
[ 69.5e3,1.61531e4],
[ 70.0e3,1.44526e4],
[ 70.5e3,1.41230e4],
[ 71.0e3,1.37761e4],
[ 71.5e3,1.34418e4],
[ 72.0e3,1.31051e4],
[ 72.5e3,1.27522e4],
[ 73.0e3,1.24112e4],
[ 73.5e3,1.20550e4],
[ 74.0e3,1.17100e4],
[ 74.5e3,1.13507e4],
[ 75.0e3,1.10021e4],
[ 75.5e3,1.06401e4],
[ 76.0e3,1.02771e4],
[ 76.5e3,9.92380e3],
[ 77.0e3,9.55851e3],
[ 77.5e3,9.19241e3],
[ 78.0e3,8.83513e3],
[ 78.5e3,8.46727e3],
[ 79.0e3,8.09884e3],
[ 79.5e3,7.72989e3],
[ 80.0e3,7.36053e3],
[ 80.5e3,6.99082e3],
[ 81.0e3,6.62085e3],
[ 81.5e3,6.25067e3],
[ 82.0e3,5.88674e3],
[ 82.5e3,5.51600e3],
[ 83.0e3,5.14530e3],
[ 83.5e3,4.77470e3],
[ 84.0e3,4.39953e3],
[ 84.5e3,4.02977e3],
[ 85.0e3,3.66033e3],
[ 85.5e3,3.29129e3],
[ 86.0e3,2.92273e3],
[ 86.5e3,2.55471e3],
[ 87.0e3,2.18731e3],
[ 87.5e3,1.82062e3],
[ 88.0e3,1.45468e3],
[ 88.5e3,1.08841e3],
[ 89.0e3,7.24621e2],
[ 89.5e3,3.61821e2],
[ 90.0e3,-3.01387e1]])

SPECTRUM120KV_AL43 = np.array([[15.0e3,4.60050e0],
[15.5e3,1.12747e1],
[16.0e3,2.50967e1],
[16.5e3,5.03098e1],
[17.0e3,9.52348e1],
[17.5e3,1.65910e2],
[18.0e3,2.75323e2],
[18.5e3,4.35224e2],
[19.0e3,6.55364e2],
[19.5e3,9.53867e2],
[20.0e3,1.33784e3],
[20.5e3,1.81038e3],
[21.0e3,2.41797e3],
[21.5e3,3.11417e3],
[22.0e3,3.95821e3],
[22.5e3,4.90536e3],
[23.0e3,6.00143e3],
[23.5e3,7.16157e3],
[24.0e3,8.53114e3],
[24.5e3,9.91206e3],
[25.0e3,1.13638e4],
[25.5e3,1.30057e4],
[26.0e3,1.46880e4],
[26.5e3,1.63691e4],
[27.0e3,1.82052e4],
[27.5e3,1.99907e4],
[28.0e3,2.19178e4],
[28.5e3,2.37180e4],
[29.0e3,2.56302e4],
[29.5e3,2.73397e4],
[30.0e3,2.91254e4],
[30.5e3,3.09898e4],
[31.0e3,3.25545e4],
[31.5e3,3.43219e4],
[32.0e3,3.58841e4],
[32.5e3,3.74477e4],
[33.0e3,3.89081e4],
[33.5e3,4.02857e4],
[34.0e3,4.15873e4],
[34.5e3,4.28602e4],
[35.0e3,4.39686e4],
[35.5e3,4.50739e4],
[36.0e3,4.60779e4],
[36.5e3,4.69536e4],
[37.0e3,4.78183e4],
[37.5e3,4.85681e4],
[38.0e3,4.93042e4],
[38.5e3,4.99207e4],
[39.0e3,5.04569e4],
[39.5e3,5.09779e4],
[40.0e3,5.14178e4],
[40.5e3,5.17761e4],
[41.0e3,5.20743e4],
[41.5e3,5.22903e4],
[42.0e3,5.24917e4],
[42.5e3,5.26796e4],
[43.0e3,5.27412e4],
[43.5e3,5.28586e4],
[44.0e3,5.28281e4],
[44.5e3,5.28324e4],
[45.0e3,5.27359e4],
[45.5e3,5.26756e4],
[46.0e3,5.25391e4],
[46.5e3,5.23276e4],
[47.0e3,5.21993e4],
[47.5e3,5.19753e4],
[48.0e3,5.17017e4],
[48.5e3,5.14903e4],
[49.0e3,5.12086e4],
[49.5e3,5.08581e4],
[50.0e3,5.05665e4],
[50.5e3,5.02164e4],
[51.0e3,4.98653e4],
[51.5e3,4.95113e4],
[52.0e3,4.91019e4],
[52.5e3,4.87498e4],
[53.0e3,4.83416e4],
[53.5e3,4.79347e4],
[54.0e3,4.75291e4],
[54.5e3,4.70705e4],
[55.0e3,4.66688e4],
[55.5e3,4.62152e4],
[56.0e3,4.57648e4],
[56.5e3,4.53174e4],
[57.0e3,4.48733e4],
[57.5e3,4.44325e4],
[58.0e3,2.02129e5],
[58.5e3,4.35103e4],
[59.0e3,4.30800e4],
[59.5e3,3.24767e5],
[60.0e3,4.21319e4],
[60.5e3,4.16646e4],
[61.0e3,4.12017e4],
[61.5e3,4.07432e4],
[62.0e3,4.02891e4],
[62.5e3,3.98393e4],
[63.0e3,3.93480e4],
[63.5e3,3.89073e4],
[64.0e3,3.84706e4],
[64.5e3,3.79940e4],
[65.0e3,3.75224e4],
[65.5e3,3.70973e4],
[66.0e3,3.66351e4],
[66.5e3,3.61778e4],
[67.0e3,1.37406e5],
[67.5e3,3.52771e4],
[68.0e3,3.48337e4],
[68.5e3,3.43948e4],
[69.0e3,6.11981e4],
[69.5e3,3.22109e4],
[70.0e3,2.53113e4],
[70.5e3,2.51455e4],
[71.0e3,2.49477e4],
[71.5e3,2.47760e4],
[72.0e3,2.46015e4],
[72.5e3,2.43957e4],
[73.0e3,2.42157e4],
[73.5e3,2.40051e4],
[74.0e3,2.38198e4],
[74.5e3,2.36045e4],
[75.0e3,2.34143e4],
[75.5e3,2.31945e4],
[76.0e3,2.29728e4],
[76.5e3,2.27755e4],
[77.0e3,2.25497e4],
[77.5e3,2.23221e4],
[78.0e3,2.21184e4],
[78.5e3,2.18869e4],
[79.0e3,2.16538e4],
[79.5e3,2.14191e4],
[80.0e3,2.11828e4],
[80.5e3,2.09449e4],
[81.0e3,2.07056e4],
[81.5e3,2.04648e4],
[82.0e3,2.02460e4],
[82.5e3,2.00022e4],
[83.0e3,1.97570e4],
[83.5e3,1.95105e4],
[84.0e3,1.92404e4],
[84.5e3,1.89917e4],
[85.0e3,1.87419e4],
[85.5e3,1.84909e4],
[86.0e3,1.82388e4],
[86.5e3,1.79857e4],
[87.0e3,1.77314e4],
[87.5e3,1.74763e4],
[88.0e3,1.72201e4],
[88.5e3,1.69434e4],
[89.0e3,1.66857e4],
[89.5e3,1.64270e4],
[90.0e3,1.61676e4],
[90.5e3,1.58890e4],
[91.0e3,1.56282e4],
[91.5e3,1.53667e4],
[92.0e3,1.51045e4],
[92.5e3,1.48244e4],
[93.0e3,1.45611e4],
[93.5e3,1.42971e4],
[94.0e3,1.40163e4],
[94.5e3,1.37514e4],
[95.0e3,1.34859e4],
[95.5e3,1.32047e4],
[96.0e3,1.29384e4],
[96.5e3,1.26718e4],
[97.0e3,1.23902e4],
[97.5e3,1.21229e4],
[98.0e3,1.18414e4],
[98.5e3,1.15736e4],
[99.0e3,1.12923e4],
[99.5e3,1.10240e4],
[100.0e3,1.07554e4],
[100.5e3,1.04743e4],
[101.0e3,1.02055e4],
[101.5e3,9.92491e3],
[102.0e3,9.65584e3],
[102.5e3,9.37573e3],
[103.0e3,9.10653e3],
[103.5e3,8.82700e3],
[104.0e3,8.55782e3],
[104.5e3,8.27897e3],
[105.0e3,8.00986e3],
[105.5e3,7.73173e3],
[106.0e3,7.46283e3],
[106.5e3,7.18553e3],
[107.0e3,6.91688e3],
[107.5e3,6.64053e3],
[108.0e3,6.36483e3],
[108.5e3,6.09689e3],
[109.0e3,5.82225e3],
[109.5e3,5.55479e3],
[110.0e3,5.28130e3],
[110.5e3,5.01440e3],
[111.0e3,4.74216e3],
[111.5e3,4.47071e3],
[112.0e3,4.20498e3],
[112.5e3,3.93491e3],
[113.0e3,3.66996e3],
[113.5e3,3.40133e3],
[114.0e3,3.13363e3],
[114.5e3,2.87018e3],
[115.0e3,2.60406e3],
[115.5e3,2.34163e3],
[116.0e3,2.07717e3],
[116.5e3,1.81373e3],
[117.0e3,1.55315e3],
[117.5e3,1.29151e3],
[118.0e3,1.03096e3],
[118.5e3,7.72417e2],
[119.0e3,5.13803e2],
[119.5e3,2.56340e2],
[120.0e3,-2.13578e1]])

spectrums = {
    '60KV_AL35' : SPECTRUM60KV_AL35,
    '90KV_AL40': SPECTRUM90KV_AL40,
    '120KV_AL43': SPECTRUM120KV_AL43
}