import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

titanium_MFP = np.array([
	[5.0000000000E+03, 1.2317370395E-01, 3.4393808647E+00, 3.2483912673E-04, 3.2395418397E-04, 2.0263707619E-01],
	[5.0050000000E+03, 1.2327529789E-01, 3.4370832237E+00, 3.2555366899E-04, 3.2466551885E-04, 2.0286491038E-01],
	[5.0100000000E+03, 1.2337687405E-01, 3.4347894096E+00, 3.2626906717E-04, 3.2537770120E-04, 2.0309267906E-01],
	[5.0150000000E+03, 1.2347843246E-01, 3.4324994121E+00, 3.2698532147E-04, 3.2609073118E-04, 2.0332038227E-01],
	[5.0200000000E+03, 1.2357997314E-01, 3.4302132210E+00, 3.2770243204E-04, 3.2680460894E-04, 2.0354801998E-01],
	[5.0250000000E+03, 1.2368149611E-01, 3.4279308263E+00, 3.2842039906E-04, 3.2751933464E-04, 2.0377559223E-01],
	[5.0300000000E+03, 1.2378300139E-01, 3.4256522180E+00, 3.2913922270E-04, 3.2823490843E-04, 2.0400309900E-01],
	[5.0350000000E+03, 1.2388448901E-01, 3.4233773859E+00, 3.2985890312E-04, 3.2895133047E-04, 2.0423054032E-01],
	[5.0400000000E+03, 1.2398595897E-01, 3.4211063201E+00, 3.3057944049E-04, 3.2966860091E-04, 2.0445791619E-01],
	[5.0450000000E+03, 1.2408741131E-01, 3.4188390106E+00, 3.3130083498E-04, 3.3038671991E-04, 2.0468522661E-01],
	[5.0500000000E+03, 1.2418884604E-01, 3.4165754475E+00, 3.3202308677E-04, 3.3110568762E-04, 2.0491247160E-01],
	[5.0550000000E+03, 1.2429026318E-01, 3.4143156208E+00, 3.3274619601E-04, 3.3182550419E-04, 2.0513965117E-01],
	[5.0600000000E+03, 1.2439166276E-01, 3.4120595208E+00, 3.3350249197E-04, 3.3257831995E-04, 2.0536676533E-01],
	[5.0650000000E+03, 1.2449304479E-01, 3.4098071376E+00, 3.3428734838E-04, 3.3335953346E-04, 2.0559381409E-01],
	[5.0700000000E+03, 1.2459440930E-01, 3.4075584615E+00, 3.3507327471E-04, 3.3414180609E-04, 2.0582079746E-01],
	[5.0750000000E+03, 1.2469575630E-01, 3.4053134826E+00, 3.3586027137E-04, 3.3492513822E-04, 2.0604771546E-01],
	[5.0800000000E+03, 1.2479708582E-01, 3.4030721913E+00, 3.3664833875E-04, 3.3570953023E-04, 2.0627456809E-01],
	[5.0850000000E+03, 1.2489913280E-01, 3.4008482485E+00, 3.3743747726E-04, 3.3649498796E-04, 2.0650135537E-01],
	[5.0900000000E+03, 1.2500123416E-01, 3.3986292679E+00, 3.3822768731E-04, 3.3728150690E-04, 2.0672807731E-01],
	[5.0950000000E+03, 1.2510331862E-01, 3.3964139118E+00, 3.3901896928E-04, 3.3806908689E-04, 2.0695473393E-01],
	[5.1000000000E+03, 1.2520538619E-01, 3.3942021706E+00, 3.3981132358E-04, 3.3885772831E-04, 2.0718132524E-01],
	[5.1050000000E+03, 1.2530743690E-01, 3.3919940348E+00, 3.4060475060E-04, 3.3964743155E-04, 2.0740785125E-01],
	[5.1100000000E+03, 1.2540947076E-01, 3.3897894951E+00, 3.4139925076E-04, 3.4043819698E-04, 2.0763431199E-01],
	[5.1150000000E+03, 1.2551148780E-01, 3.3875885422E+00, 3.4219482444E-04, 3.4123002497E-04, 2.0786070747E-01],
	[5.1200000000E+03, 1.2561348802E-01, 3.3853911666E+00, 3.4300863045E-04, 3.4203997754E-04, 2.0808703770E-01],
	[5.1250000000E+03, 1.2571547146E-01, 3.3831973591E+00, 3.4382451766E-04, 3.4285199430E-04, 2.0831330269E-01],
	[5.1300000000E+03, 1.2581743812E-01, 3.3810071104E+00, 3.4464154711E-04, 3.4366514158E-04, 2.0853950248E-01],
	[5.1350000000E+03, 1.2591938804E-01, 3.3788204113E+00, 3.4545971929E-04, 3.4447941982E-04, 2.0876563707E-01],
	[5.1400000000E+03, 1.2602132122E-01, 3.3766372525E+00, 3.4627903468E-04, 3.4529482951E-04, 2.0899170649E-01],
	[5.1450000000E+03, 1.2612323769E-01, 3.3744576250E+00, 3.4709949377E-04, 3.4611137108E-04, 2.0921771075E-01],
	[5.1500000000E+03, 1.2622513747E-01, 3.3722815196E+00, 3.4792109704E-04, 3.4692904500E-04, 2.0944364987E-01],
	[5.1550000000E+03, 1.2632702057E-01, 3.3701089271E+00, 3.4874384497E-04, 3.4774785173E-04, 2.0966952387E-01],
	[5.1600000000E+03, 1.2642888702E-01, 3.3679398385E+00, 3.4956773804E-04, 3.4856779172E-04, 2.0989533277E-01],
	[5.1650000000E+03, 1.2653117820E-01, 3.3657824475E+00, 3.5039277674E-04, 3.4938886888E-04, 2.1012107660E-01],
	[5.1700000000E+03, 1.2663380867E-01, 3.3636351231E+00, 3.5121896155E-04, 3.5021108305E-04, 2.1034675536E-01],
	[5.1750000000E+03, 1.2673642306E-01, 3.3614912425E+00, 3.5204629295E-04, 3.5103443189E-04, 2.1057236909E-01],
	[5.1800000000E+03, 1.2683902138E-01, 3.3593507967E+00, 3.5287477142E-04, 3.5185891586E-04, 2.1079791781E-01],
	[5.1850000000E+03, 1.2694160365E-01, 3.3572137770E+00, 3.5370439744E-04, 3.5268453543E-04, 2.1102340154E-01],
	[5.1900000000E+03, 1.2704416989E-01, 3.3550801745E+00, 3.5453517149E-04, 3.5351129104E-04, 2.1124882029E-01],
	[5.1950000000E+03, 1.2714672012E-01, 3.3529499805E+00, 3.5536709405E-04, 3.5433918316E-04, 2.1147417410E-01],
	[5.2000000000E+03, 1.2724925435E-01, 3.3508231863E+00, 3.5620016560E-04, 3.5516821224E-04, 2.1169946298E-01],
	[5.2050000000E+03, 1.2735177261E-01, 3.3486997832E+00, 3.5703438663E-04, 3.5599837873E-04, 2.1192468697E-01],
	[5.2100000000E+03, 1.2745427491E-01, 3.3465797626E+00, 3.5786975760E-04, 3.5682968309E-04, 2.1214984608E-01],
	[5.2150000000E+03, 1.2755676127E-01, 3.3444631158E+00, 3.5870627901E-04, 3.5766212577E-04, 2.1237494035E-01],
	[5.2200000000E+03, 1.2765923171E-01, 3.3423498342E+00, 3.5954395133E-04, 3.5849570723E-04, 2.1259996979E-01],
	[5.2250000000E+03, 1.2776168624E-01, 3.3402399093E+00, 3.6038277503E-04, 3.5933042792E-04, 2.1282493443E-01],
	[5.2300000000E+03, 1.2786412489E-01, 3.3381333325E+00, 3.6122275061E-04, 3.6016628830E-04, 2.1304983429E-01],
	[5.2350000000E+03, 1.2796654766E-01, 3.3360300953E+00, 3.6207628251E-04, 3.6101562024E-04, 2.1327466942E-01],
	[5.2400000000E+03, 1.2806895458E-01, 3.3339301892E+00, 3.6295272822E-04, 3.6188772601E-04, 2.1349943982E-01],
	[5.2450000000E+03, 1.2817134567E-01, 3.3318336059E+00, 3.6383045653E-04, 3.6276110072E-04, 2.1372414553E-01],
	[5.2500000000E+03, 1.2827445590E-01, 3.3297539665E+00, 3.6470946808E-04, 3.6363575104E-04, 2.1394878658E-01],
	[5.2550000000E+03, 1.2837760368E-01, 3.3276785822E+00, 3.6558976353E-04, 3.6451167202E-04, 2.1417336299E-01],
	[5.2600000000E+03, 1.2848073619E-01, 3.3256064633E+00, 3.6647134353E-04, 3.6538886385E-04, 2.1439787479E-01],
	[5.2650000000E+03, 1.2858385344E-01, 3.3235376016E+00, 3.6735420872E-04, 3.6626732713E-04, 2.1462232202E-01],
	[5.2700000000E+03, 1.2868695546E-01, 3.3214719890E+00, 3.6823835976E-04, 3.6714706250E-04, 2.1484670470E-01],
	[5.2750000000E+03, 1.2879004226E-01, 3.3194096171E+00, 3.6912379730E-04, 3.6802807056E-04, 2.1507102286E-01],
	[5.2800000000E+03, 1.2889311385E-01, 3.3173504780E+00, 3.7001052199E-04, 3.6891035195E-04, 2.1529527653E-01],
	[5.2850000000E+03, 1.2899617025E-01, 3.3152945634E+00, 3.7089853448E-04, 3.6979390728E-04, 2.1551946574E-01],
	[5.2900000000E+03, 1.2909921149E-01, 3.3132418653E+00, 3.7178783542E-04, 3.7067873717E-04, 2.1574359053E-01],
	[5.2950000000E+03, 1.2920223756E-01, 3.3111923755E+00, 3.7267842545E-04, 3.7156484223E-04, 2.1596765092E-01],
	[5.3000000000E+03, 1.2930524850E-01, 3.3091460862E+00, 3.7357030523E-04, 3.7245222310E-04, 2.1619164695E-01],
	[5.3050000000E+03, 1.2940824432E-01, 3.3071029892E+00, 3.7446347540E-04, 3.7334088037E-04, 2.1641557864E-01],
	[5.3100000000E+03, 1.2951122504E-01, 3.3050630765E+00, 3.7535793661E-04, 3.7423081468E-04, 2.1663944604E-01],
	[5.3150000000E+03, 1.2961419066E-01, 3.3030263403E+00, 3.7625368951E-04, 3.7512202663E-04, 2.1686324917E-01],
	[5.3200000000E+03, 1.2971714122E-01, 3.3009927726E+00, 3.7715073475E-04, 3.7601451686E-04, 2.1708698807E-01],
	[5.3250000000E+03, 1.2982007672E-01, 3.2989623654E+00, 3.7804907298E-04, 3.7690828596E-04, 2.1731066277E-01],
	[5.3300000000E+03, 1.2992303170E-01, 3.2969357511E+00, 3.7894870483E-04, 3.7780333486E-04, 2.1753427330E-01],
	[5.3350000000E+03, 1.3002671596E-01, 3.2949260570E+00, 3.7984963096E-04, 3.7869967037E-04, 2.1775781970E-01],
	[5.3400000000E+03, 1.3013038571E-01, 3.2929194689E+00, 3.8075185202E-04, 3.7959728667E-04, 2.1798130200E-01],
	[5.3450000000E+03, 1.3023404097E-01, 3.2909159789E+00, 3.8165536865E-04, 3.8049618435E-04, 2.1820472018E-01],
	[5.3500000000E+03, 1.3033768177E-01, 3.2889155796E+00, 3.8256018149E-04, 3.8139636404E-04, 2.1842807426E-01],
	[5.3550000000E+03, 1.3044130812E-01, 3.2869182631E+00, 3.8346629120E-04, 3.8229782636E-04, 2.1865136425E-01],
	[5.3600000000E+03, 1.3054492002E-01, 3.2849240219E+00, 3.8437369841E-04, 3.8320057191E-04, 2.1887459016E-01],
	[5.3650000000E+03, 1.3064851751E-01, 3.2829328484E+00, 3.8528240378E-04, 3.8410460132E-04, 2.1909775200E-01],
	[5.3700000000E+03, 1.3075210059E-01, 3.2809447351E+00, 3.8619240794E-04, 3.8500991519E-04, 2.1932084979E-01],
	[5.3750000000E+03, 1.3085566927E-01, 3.2789596743E+00, 3.8710371155E-04, 3.8591651414E-04, 2.1954388354E-01],
	[5.3800000000E+03, 1.3095922358E-01, 3.2769776585E+00, 3.8801631524E-04, 3.8682439878E-04, 2.1976685326E-01],
	[5.3850000000E+03, 1.3106276354E-01, 3.2749986803E+00, 3.8893021966E-04, 3.8773356973E-04, 2.1998975897E-01],
	[5.3900000000E+03, 1.3116628914E-01, 3.2730227322E+00, 3.8984542545E-04, 3.8864402759E-04, 2.2021260069E-01],
	[5.3950000000E+03, 1.3126980042E-01, 3.2710498068E+00, 3.9076193326E-04, 3.8955577299E-04, 2.2043537842E-01],
	[5.4000000000E+03, 1.3137329738E-01, 3.2690798966E+00, 3.9167974373E-04, 3.9046880652E-04, 2.2065809219E-01],
	[5.4050000000E+03, 1.3147678004E-01, 3.2671129942E+00, 3.9259885750E-04, 3.9138312882E-04, 2.2088074201E-01],
	[5.4100000000E+03, 1.3158024842E-01, 3.2651490922E+00, 3.9351927522E-04, 3.9229874047E-04, 2.2110332790E-01],
	[5.4150000000E+03, 1.3168370253E-01, 3.2631881834E+00, 3.9444099752E-04, 3.9321564210E-04, 2.2132584987E-01],
	[5.4200000000E+03, 1.3178782286E-01, 3.2612428365E+00, 3.9536402505E-04, 3.9413384059E-04, 2.2154830794E-01],
	[5.4250000000E+03, 1.3189201879E-01, 3.2593020913E+00, 3.9628835846E-04, 3.9505333115E-04, 2.2177070213E-01],
	[5.4300000000E+03, 1.3199620100E-01, 3.2573642874E+00, 3.9721399837E-04, 3.9597411356E-04, 2.2199303245E-01],
	[5.4350000000E+03, 1.3210036950E-01, 3.2554294175E+00, 3.9814094544E-04, 3.9689618844E-04, 2.2221529893E-01],
	[5.4400000000E+03, 1.3220452431E-01, 3.2534974745E+00, 3.9906920030E-04, 3.9781955639E-04, 2.2243750158E-01],
	[5.4450000000E+03, 1.3230866544E-01, 3.2515684513E+00, 3.9999876360E-04, 3.9874421803E-04, 2.2265964042E-01],
	[5.4500000000E+03, 1.3241279291E-01, 3.2496423408E+00, 4.0092963597E-04, 3.9967017396E-04, 2.2288171547E-01],
	[5.4550000000E+03, 1.3251690672E-01, 3.2477191360E+00, 4.0186181806E-04, 4.0059742480E-04, 2.2310372675E-01],
	[5.4600000000E+03, 1.3262100690E-01, 3.2457988298E+00, 4.0279531050E-04, 4.0152597114E-04, 2.2332567428E-01],
	[5.4650000000E+03, 1.3272509346E-01, 3.2438814152E+00, 4.0373011393E-04, 4.0245581361E-04, 2.2354755808E-01],
	[5.4700000000E+03, 1.3282916642E-01, 3.2419668852E+00, 4.0466622900E-04, 4.0338695280E-04, 2.2376937817E-01],
	[5.4750000000E+03, 1.3293322577E-01, 3.2400552328E+00, 4.0560365634E-04, 4.0431938933E-04, 2.2399113457E-01],
	[5.4800000000E+03, 1.3303727156E-01, 3.2381464511E+00, 4.0654240678E-04, 4.0525313392E-04, 2.2421282731E-01],
	[5.4850000000E+03, 1.3314130377E-01, 3.2362405332E+00, 4.0748247903E-04, 4.0618818526E-04, 2.2443445640E-01],
	[5.4900000000E+03, 1.3324532244E-01, 3.2343374721E+00, 4.0842386553E-04, 4.0712453583E-04, 2.2465602187E-01],
	[5.4950000000E+03, 1.3334932757E-01, 3.2324372610E+00, 4.0936656693E-04, 4.0806218623E-04, 2.2487752373E-01],
	[5.5000000000E+03, 1.3345331917E-01, 3.2305398930E+00, 4.1031058386E-04, 4.0900113706E-04, 2.2509896202E-01],
	[5.5050000000E+03, 1.3355763758E-01, 3.2286516423E+00, 4.1125591695E-04, 4.0994139224E-04, 2.2532033676E-01],
	[5.5100000000E+03, 1.3366236347E-01, 3.2267739634E+00, 4.1220256686E-04, 4.1088295318E-04, 2.2554164796E-01],
	[5.5150000000E+03, 1.3376707638E-01, 3.2248990781E+00, 4.1315053420E-04, 4.1182581643E-04, 2.2576289565E-01],
	[5.5200000000E+03, 1.3387177632E-01, 3.2230269797E+00, 4.1409981962E-04, 4.1276998258E-04, 2.2598407986E-01],
	[5.5250000000E+03, 1.3397646330E-01, 3.2211576616E+00, 4.1505042376E-04, 4.1371545225E-04, 2.2620520061E-01],
	[5.5300000000E+03, 1.3408113734E-01, 3.2192911172E+00, 4.1600234725E-04, 4.1466222602E-04, 2.2642625793E-01],
	[5.5350000000E+03, 1.3418579845E-01, 3.2174273398E+00, 4.1695559073E-04, 4.1561030452E-04, 2.2664725184E-01],
	[5.5400000000E+03, 1.3429044665E-01, 3.2155663228E+00, 4.1791015483E-04, 4.1655968834E-04, 2.2686818236E-01],
	[5.5450000000E+03, 1.3439508194E-01, 3.2137080596E+00, 4.1886604018E-04, 4.1751037808E-04, 2.2708904952E-01],
	[5.5500000000E+03, 1.3449970434E-01, 3.2118525438E+00, 4.1982324743E-04, 4.1846237435E-04, 2.2730985335E-01],
	[5.5550000000E+03, 1.3460431386E-01, 3.2099997687E+00, 4.2078177721E-04, 4.1941567775E-04, 2.2753059388E-01],
	[5.5600000000E+03, 1.3470891052E-01, 3.2081497278E+00, 4.2174163015E-04, 4.2037028888E-04, 2.2775127113E-01],
	[5.5650000000E+03, 1.3481349434E-01, 3.2063024148E+00, 4.2270280688E-04, 4.2132620835E-04, 2.2797188512E-01],
	[5.5700000000E+03, 1.3491806531E-01, 3.2044578230E+00, 4.2366530805E-04, 4.2228343676E-04, 2.2819243589E-01],
	[5.5750000000E+03, 1.3502262346E-01, 3.2026159461E+00, 4.2462913427E-04, 4.2324197471E-04, 2.2841292346E-01],
	[5.5800000000E+03, 1.3512716880E-01, 3.2007767776E+00, 4.2559428620E-04, 4.2420182279E-04, 2.2863334787E-01],
	[5.5850000000E+03, 1.3523170134E-01, 3.1989403111E+00, 4.2656076445E-04, 4.2516298162E-04, 2.2885370913E-01],
	[5.5900000000E+03, 1.3533622109E-01, 3.1971065403E+00, 4.2752856967E-04, 4.2612545178E-04, 2.2907400728E-01],
	[5.5950000000E+03, 1.3544127712E-01, 3.1952855681E+00, 4.2849770248E-04, 4.2708923953E-04, 2.2929424235E-01],
	[5.6000000000E+03, 1.3554652408E-01, 3.1934709970E+00, 4.2946816352E-04, 4.2805434196E-04, 2.2951441436E-01],
	[5.6050000000E+03, 1.3565175878E-01, 3.1916590743E+00, 4.3043995342E-04, 4.2902075757E-04, 2.2973452335E-01],
	[5.6100000000E+03, 1.3575698124E-01, 3.1898497940E+00, 4.3141307281E-04, 4.2998848698E-04, 2.2995456935E-01],
	[5.6150000000E+03, 1.3586219146E-01, 3.1880431498E+00, 4.3238752232E-04, 4.3095753078E-04, 2.3017455238E-01],
	[5.6200000000E+03, 1.3596738948E-01, 3.1862391354E+00, 4.3336330259E-04, 4.3192788957E-04, 2.3039447247E-01],
	[5.6250000000E+03, 1.3607257528E-01, 3.1844377449E+00, 4.3434041424E-04, 4.3289956395E-04, 2.3061432967E-01],
	[5.6300000000E+03, 1.3617774890E-01, 3.1826389719E+00, 4.3531885791E-04, 4.3387255452E-04, 2.3083412399E-01],
	[5.6350000000E+03, 1.3628291033E-01, 3.1808428105E+00, 4.3629863422E-04, 4.3484686188E-04, 2.3105385547E-01],
	[5.6400000000E+03, 1.3638805960E-01, 3.1790492544E+00, 4.3727974381E-04, 4.3582248661E-04, 2.3127352415E-01],
	[5.6450000000E+03, 1.3649319671E-01, 3.1772582976E+00, 4.3826218730E-04, 4.3679942933E-04, 2.3149313004E-01],
	[5.6500000000E+03, 1.3659832167E-01, 3.1754699341E+00, 4.3924596534E-04, 4.3777769063E-04, 2.3171267320E-01],
	[5.6550000000E+03, 1.3670343451E-01, 3.1736841578E+00, 4.4023107853E-04, 4.3875727110E-04, 2.3193215364E-01],
	[5.6600000000E+03, 1.3680853522E-01, 3.1719009626E+00, 4.4121752752E-04, 4.3973817135E-04, 2.3215157140E-01],
	[5.6650000000E+03, 1.3691362383E-01, 3.1701203426E+00, 4.4220531294E-04, 4.4072039196E-04, 2.3237092652E-01],
	[5.6700000000E+03, 1.3701870034E-01, 3.1683422918E+00, 4.4319443540E-04, 4.4170393353E-04, 2.3259021902E-01],
	[5.6750000000E+03, 1.3712376477E-01, 3.1665668041E+00, 4.4418489555E-04, 4.4268879667E-04, 2.3280944895E-01],
	[5.6800000000E+03, 1.3722881713E-01, 3.1647938738E+00, 4.4517669400E-04, 4.4367498196E-04, 2.3302861633E-01],
	[5.6850000000E+03, 1.3733439826E-01, 3.1630334317E+00, 4.4616983139E-04, 4.4466249586E-04, 2.3324772121E-01],
	[5.6900000000E+03, 1.3744017065E-01, 3.1612792394E+00, 4.4716430835E-04, 4.4565133536E-04, 2.3346676361E-01],
	[5.6950000000E+03, 1.3754593149E-01, 3.1595275594E+00, 4.4816012550E-04, 4.4664149885E-04, 2.3368574356E-01],
	[5.7000000000E+03, 1.3765168079E-01, 3.1577783860E+00, 4.4915728346E-04, 4.4763298692E-04, 2.3390466112E-01],
	[5.7050000000E+03, 1.3775741857E-01, 3.1560317134E+00, 4.5015578287E-04, 4.4862580018E-04, 2.3412351630E-01],
	[5.7100000000E+03, 1.3786314484E-01, 3.1542875358E+00, 4.5115562435E-04, 4.4961993921E-04, 2.3434230915E-01],
	[5.7150000000E+03, 1.3796885960E-01, 3.1525458475E+00, 4.5215680853E-04, 4.5061540461E-04, 2.3456103971E-01],
	[5.7200000000E+03, 1.3807456287E-01, 3.1508066428E+00, 4.5315933603E-04, 4.5161219696E-04, 2.3477970800E-01],
	[5.7250000000E+03, 1.3818025465E-01, 3.1490699159E+00, 4.5416320748E-04, 4.5261031688E-04, 2.3499831407E-01],
	[5.7300000000E+03, 1.3828593497E-01, 3.1473356612E+00, 4.5516842351E-04, 4.5360976493E-04, 2.3521685795E-01],
	[5.7350000000E+03, 1.3839160384E-01, 3.1456038730E+00, 4.5618718011E-04, 4.5462265360E-04, 2.3543533968E-01],
	[5.7400000000E+03, 1.3849726125E-01, 3.1438745456E+00, 4.5722121457E-04, 4.5565070783E-04, 2.3565375930E-01],
	[5.7450000000E+03, 1.3860290723E-01, 3.1421476734E+00, 4.5825668946E-04, 4.5668018479E-04, 2.3587211684E-01],
	[5.7500000000E+03, 1.3870854179E-01, 3.1404232508E+00, 4.5929360555E-04, 4.5771108517E-04, 2.3609041235E-01],
	[5.7550000000E+03, 1.3881416493E-01, 3.1387012721E+00, 4.6033196357E-04, 4.5874340970E-04, 2.3630864586E-01],
	[5.7600000000E+03, 1.3891977667E-01, 3.1369817319E+00, 4.6137176428E-04, 4.5977715909E-04, 2.3652681741E-01],
	[5.7650000000E+03, 1.3902537702E-01, 3.1352646245E+00, 4.6241300843E-04, 4.6081233404E-04, 2.3674492704E-01],
	[5.7700000000E+03, 1.3913096599E-01, 3.1335499444E+00, 4.6345569676E-04, 4.6184893528E-04, 2.3696297476E-01],
	[5.7750000000E+03, 1.3923686321E-01, 3.1318435479E+00, 4.6449983003E-04, 4.6288696717E-04, 2.3718096058E-01],
	[5.7800000000E+03, 1.3934316496E-01, 3.1301471700E+00, 4.6554540899E-04, 4.6392643156E-04, 2.3739888453E-01],
	[5.7850000000E+03, 1.3944945585E-01, 3.1284531766E+00, 4.6659243438E-04, 4.6496732442E-04, 2.3761674662E-01],
	[5.7900000000E+03, 1.3955573589E-01, 3.1267615622E+00, 4.6764090695E-04, 4.6600964646E-04, 2.3783454687E-01],
	[5.7950000000E+03, 1.3966200508E-01, 3.1250723216E+00, 4.6869082744E-04, 4.6705339839E-04, 2.3805228530E-01],
	[5.8000000000E+03, 1.3976826344E-01, 3.1233854492E+00, 4.6974219662E-04, 4.6809858093E-04, 2.3826996194E-01],
	[5.8050000000E+03, 1.3987451097E-01, 3.1217009398E+00, 4.7079501522E-04, 4.6914519477E-04, 2.3848757680E-01],
	[5.8100000000E+03, 1.3998074770E-01, 3.1200187880E+00, 4.7184928399E-04, 4.7019324063E-04, 2.3870512991E-01],
	[5.8150000000E+03, 1.4008697362E-01, 3.1183389885E+00, 4.7290500368E-04, 4.7124271923E-04, 2.3892262129E-01],
	[5.8200000000E+03, 1.4019318874E-01, 3.1166615360E+00, 4.7396217503E-04, 4.7229363126E-04, 2.3914005095E-01],
	[5.8250000000E+03, 1.4029939309E-01, 3.1149864251E+00, 4.7502079879E-04, 4.7334597743E-04, 2.3935741892E-01],
	[5.8300000000E+03, 1.4040558667E-01, 3.1133136507E+00, 4.7608087572E-04, 4.7439975846E-04, 2.3957472523E-01],
	[5.8350000000E+03, 1.4051176948E-01, 3.1116432074E+00, 4.7714240654E-04, 4.7545497505E-04, 2.3979196989E-01],
	[5.8400000000E+03, 1.4061794155E-01, 3.1099750900E+00, 4.7820539202E-04, 4.7651162791E-04, 2.4000915292E-01],
	[5.8450000000E+03, 1.4072410287E-01, 3.1083092933E+00, 4.7926983289E-04, 4.7756971775E-04, 2.4022627436E-01],
	[5.8500000000E+03, 1.4083025347E-01, 3.1066458121E+00, 4.8033572990E-04, 4.7862924527E-04, 2.4044333422E-01],
	[5.8550000000E+03, 1.4093639334E-01, 3.1049846412E+00, 4.8140308379E-04, 4.7969021118E-04, 2.4066033252E-01],
	[5.8600000000E+03, 1.4104252251E-01, 3.1033257753E+00, 4.8247189531E-04, 4.8075261619E-04, 2.4087726930E-01],
	[5.8650000000E+03, 1.4114864097E-01, 3.1016692094E+00, 4.8354216521E-04, 4.8181646100E-04, 2.4109414457E-01],
	[5.8700000000E+03, 1.4125536502E-01, 3.1000262090E+00, 4.8461389422E-04, 4.8288175379E-04, 2.4131095836E-01],
	[5.8750000000E+03, 1.4136218944E-01, 3.0983874979E+00, 4.8568708310E-04, 4.8394848919E-04, 2.4152771069E-01],
	[5.8800000000E+03, 1.4146900367E-01, 3.0967510459E+00, 4.8676173258E-04, 4.8501666656E-04, 2.4174440159E-01],
	[5.8850000000E+03, 1.4157580772E-01, 3.0951168480E+00, 4.8783784340E-04, 4.8608628662E-04, 2.4196103109E-01],
	[5.8900000000E+03, 1.4168260159E-01, 3.0934848993E+00, 4.8891541632E-04, 4.8715735006E-04, 2.4217759920E-01],
	[5.8950000000E+03, 1.4178938530E-01, 3.0918551948E+00, 4.8999445208E-04, 4.8822985760E-04, 2.4239410595E-01],
	[5.9000000000E+03, 1.4189615885E-01, 3.0902277294E+00, 4.9107495141E-04, 4.8930380993E-04, 2.4261055138E-01],
	[5.9050000000E+03, 1.4200292226E-01, 3.0886024982E+00, 4.9215691505E-04, 4.9037920775E-04, 2.4282693550E-01],
	[5.9100000000E+03, 1.4210967554E-01, 3.0869794962E+00, 4.9324034376E-04, 4.9145605178E-04, 2.4304325834E-01],
	[5.9150000000E+03, 1.4221641869E-01, 3.0853587185E+00, 4.9432523828E-04, 4.9253434271E-04, 2.4325951993E-01],
	[5.9200000000E+03, 1.4232315172E-01, 3.0837401602E+00, 4.9541159933E-04, 4.9361408125E-04, 2.4347572029E-01],
	[5.9250000000E+03, 1.4242987465E-01, 3.0821238163E+00, 4.9649942768E-04, 4.9469526810E-04, 2.4369185946E-01],
	[5.9300000000E+03, 1.4253658748E-01, 3.0805096821E+00, 4.9758872405E-04, 4.9577790396E-04, 2.4390793745E-01],
	[5.9350000000E+03, 1.4264329022E-01, 3.0788977524E+00, 4.9867948918E-04, 4.9686198954E-04, 2.4412395431E-01],
	[5.9400000000E+03, 1.4274998288E-01, 3.0772880227E+00, 4.9977172383E-04, 4.9794752553E-04, 2.4433991005E-01],
	[5.9450000000E+03, 1.4285666548E-01, 3.0756804878E+00, 5.0086542872E-04, 4.9903451264E-04, 2.4455580470E-01],
	[5.9500000000E+03, 1.4296333801E-01, 3.0740751432E+00, 5.0196060460E-04, 5.0012295157E-04, 2.4477163829E-01],
	[5.9550000000E+03, 1.4307000049E-01, 3.0724719838E+00, 5.0305725222E-04, 5.0121284302E-04, 2.4498741085E-01],
	[5.9600000000E+03, 1.4317665294E-01, 3.0708710049E+00, 5.0415537229E-04, 5.0230418768E-04, 2.4520312241E-01],
	[5.9650000000E+03, 1.4328398649E-01, 3.0692848036E+00, 5.0525496558E-04, 5.0339699514E-04, 2.4541877300E-01],
	[5.9700000000E+03, 1.4339133804E-01, 3.0677012515E+00, 5.0635603281E-04, 5.0449125763E-04, 2.4563436264E-01],
	[5.9750000000E+03, 1.4349868004E-01, 3.0661198410E+00, 5.0745857473E-04, 5.0558697549E-04, 2.4584989137E-01],
	[5.9800000000E+03, 1.4360601251E-01, 3.0645405676E+00, 5.0856259207E-04, 5.0668414944E-04, 2.4606535922E-01],
	[5.9850000000E+03, 1.4371333545E-01, 3.0629634265E+00, 5.0966808557E-04, 5.0778278016E-04, 2.4628076621E-01],
	[5.9900000000E+03, 1.4382064888E-01, 3.0613884130E+00, 5.1077505597E-04, 5.0888286836E-04, 2.4649611238E-01],
	[5.9950000000E+03, 1.4392795280E-01, 3.0598155226E+00, 5.1188350401E-04, 5.0998441473E-04, 2.4671139775E-01],
	[6.0000000000E+03, 1.4403524722E-01, 3.0582447506E+00, 5.1299343043E-04, 5.1108741998E-04, 2.4692662236E-01],
	[6.0050000000E+03, 1.4414253215E-01, 3.0566760924E+00, 5.1411831488E-04, 5.1220526361E-04, 2.4714178624E-01],
	[6.0100000000E+03, 1.4424980760E-01, 3.0551095434E+00, 5.1524472666E-04, 5.1332461432E-04, 2.4735688942E-01],
	[6.0150000000E+03, 1.4435707358E-01, 3.0535450989E+00, 5.1637266655E-04, 5.1444547287E-04, 2.4757193193E-01],
	[6.0200000000E+03, 1.4446433010E-01, 3.0519827545E+00, 5.1750213535E-04, 5.1556784003E-04, 2.4778691380E-01],
	[6.0250000000E+03, 1.4457157716E-01, 3.0504225056E+00, 5.1863313388E-04, 5.1669171655E-04, 2.4800183506E-01],
	[6.0300000000E+03, 1.4467881477E-01, 3.0488643476E+00, 5.1976566292E-04, 5.1781710319E-04, 2.4821669575E-01],
	[6.0350000000E+03, 1.4478604295E-01, 3.0473082760E+00, 5.2089972328E-04, 5.1894400071E-04, 2.4843149590E-01],
	[6.0400000000E+03, 1.4489326170E-01, 3.0457542862E+00, 5.2203531575E-04, 5.2007240986E-04, 2.4864623554E-01],
	[6.0450000000E+03, 1.4500047103E-01, 3.0442023738E+00, 5.2317244114E-04, 5.2120233140E-04, 2.4886091470E-01],
	[6.0500000000E+03, 1.4510767094E-01, 3.0426525343E+00, 5.2431110024E-04, 5.2233376609E-04, 2.4907553342E-01],
	[6.0550000000E+03, 1.4521486146E-01, 3.0411047632E+00, 5.2545129385E-04, 5.2346671468E-04, 2.4929009172E-01],
	[6.0600000000E+03, 1.4532259150E-01, 3.0395689528E+00, 5.2659302278E-04, 5.2460118538E-04, 2.4950458965E-01],
	[6.0650000000E+03, 1.4543047517E-01, 3.0380381127E+00, 5.2773628781E-04, 5.2573717376E-04, 2.4971902724E-01],
	[6.0700000000E+03, 1.4553834993E-01, 3.0365093041E+00, 5.2888108975E-04, 5.2687467837E-04, 2.4993340452E-01],
	[6.0750000000E+03, 1.4564621578E-01, 3.0349825227E+00, 5.3002742939E-04, 5.2801369997E-04, 2.5014772152E-01],
	[6.0800000000E+03, 1.4575407274E-01, 3.0334577641E+00, 5.3117530754E-04, 5.2915423931E-04, 2.5036197828E-01],
	[6.0850000000E+03, 1.4586192081E-01, 3.0319350240E+00, 5.3232472498E-04, 5.3029629716E-04, 2.5057617483E-01],
	[6.0900000000E+03, 1.4596976001E-01, 3.0304142981E+00, 5.3347568251E-04, 5.3143987425E-04, 2.5079031121E-01],
	[6.0950000000E+03, 1.4607759033E-01, 3.0288955820E+00, 5.3462818094E-04, 5.3258497136E-04, 2.5100438745E-01],
	[6.1000000000E+03, 1.4618541178E-01, 3.0273788714E+00, 5.3578222106E-04, 5.3373158922E-04, 2.5121840359E-01],
	[6.1050000000E+03, 1.4629322438E-01, 3.0258641621E+00, 5.3693780365E-04, 5.3487972860E-04, 2.5143235966E-01],
	[6.1100000000E+03, 1.4640102813E-01, 3.0243514498E+00, 5.3809492953E-04, 5.3602939025E-04, 2.5164625570E-01],
	[6.1150000000E+03, 1.4650882305E-01, 3.0228407302E+00, 5.3925359949E-04, 5.3718057492E-04, 2.5186009175E-01],
	[6.1200000000E+03, 1.4661660913E-01, 3.0213319990E+00, 5.4041381431E-04, 5.3833328337E-04, 2.5207386783E-01],
	[6.1250000000E+03, 1.4672438639E-01, 3.0198252521E+00, 5.4157557480E-04, 5.3948751634E-04, 2.5228758399E-01],
	[6.1300000000E+03, 1.4683215483E-01, 3.0183204851E+00, 5.4273888175E-04, 5.4064327458E-04, 2.5250124027E-01],
	[6.1350000000E+03, 1.4693991446E-01, 3.0168176940E+00, 5.4390373596E-04, 5.4180055886E-04, 2.5271483669E-01],
	[6.1400000000E+03, 1.4704766529E-01, 3.0153168744E+00, 5.4507013822E-04, 5.4295936992E-04, 2.5292837330E-01],
	[6.1450000000E+03, 1.4715540734E-01, 3.0138180222E+00, 5.4623808932E-04, 5.4411970852E-04, 2.5314185013E-01],
	[6.1500000000E+03, 1.4726314059E-01, 3.0123211332E+00, 5.4740759005E-04, 5.4528157539E-04, 2.5335526723E-01],
	[6.1550000000E+03, 1.4737105712E-01, 3.0108296051E+00, 5.4857864122E-04, 5.4644497406E-04, 2.5356862462E-01],
	[6.1600000000E+03, 1.4747947831E-01, 3.0093491065E+00, 5.4975124362E-04, 5.4760990990E-04, 2.5378192234E-01],
	[6.1650000000E+03, 1.4758789119E-01, 3.0078705362E+00, 5.5092539803E-04, 5.4877637634E-04, 2.5399516049E-01],
	[6.1700000000E+03, 1.4769629579E-01, 3.0063938902E+00, 5.5210110525E-04, 5.4994437414E-04, 2.5420833927E-01],
	[6.1750000000E+03, 1.4780469209E-01, 3.0049191643E+00, 5.5327836608E-04, 5.5111390403E-04, 2.5442145871E-01],
	[6.1800000000E+03, 1.4791308012E-01, 3.0034463547E+00, 5.5445718130E-04, 5.5228496677E-04, 2.5463451882E-01],
	[6.1850000000E+03, 1.4802145988E-01, 3.0019754571E+00, 5.5563755171E-04, 5.5345756311E-04, 2.5484751962E-01],
	[6.1900000000E+03, 1.4812983138E-01, 3.0005064676E+00, 5.5681947811E-04, 5.5463169379E-04, 2.5506046112E-01],
	[6.1950000000E+03, 1.4823819461E-01, 2.9990393822E+00, 5.5800296127E-04, 5.5580735957E-04, 2.5527334334E-01],
	[6.2000000000E+03, 1.4834654961E-01, 2.9975741969E+00, 5.5918800200E-04, 5.5698456119E-04, 2.5548616629E-01],
	[6.2050000000E+03, 1.4845489635E-01, 2.9961109076E+00, 5.6037460108E-04, 5.5816329941E-04, 2.5569892998E-01],
	[6.2100000000E+03, 1.4856323487E-01, 2.9946495104E+00, 5.6156275931E-04, 5.5934357496E-04, 2.5591163444E-01],
	[6.2150000000E+03, 1.4867156516E-01, 2.9931900014E+00, 5.6275247748E-04, 5.6052538860E-04, 2.5612427967E-01],
	[6.2200000000E+03, 1.4877988723E-01, 2.9917323765E+00, 5.6394375638E-04, 5.6170874107E-04, 2.5633686568E-01],
	[6.2250000000E+03, 1.4888820108E-01, 2.9902766319E+00, 5.6513659679E-04, 5.6289363312E-04, 2.5654939251E-01],
	[6.2300000000E+03, 1.4899650674E-01, 2.9888227636E+00, 5.6633099951E-04, 5.6408006550E-04, 2.5676186015E-01],
	[6.2350000000E+03, 1.4910480419E-01, 2.9873707676E+00, 5.6752696533E-04, 5.6526803895E-04, 2.5697426864E-01],
	[6.2400000000E+03, 1.4921309345E-01, 2.9859206401E+00, 5.6872449504E-04, 5.6645755422E-04, 2.5718661797E-01],
	[6.2450000000E+03, 1.4932137453E-01, 2.9844723772E+00, 5.6992358942E-04, 5.6764861205E-04, 2.5739890818E-01],
	[6.2500000000E+03, 1.4942964744E-01, 2.9830259750E+00, 5.7112424927E-04, 5.6884121320E-04, 2.5761113927E-01],
	[6.2550000000E+03, 1.4953823327E-01, 2.9815870116E+00, 5.7232647538E-04, 5.7003536326E-04, 2.5782331127E-01],
	[6.2600000000E+03, 1.4964718927E-01, 2.9801564568E+00, 5.7353026853E-04, 5.7123106391E-04, 2.5803542418E-01],
	[6.2650000000E+03, 1.4975613758E-01, 2.9787277297E+00, 5.7473562951E-04, 5.7242831017E-04, 2.5824747804E-01],
	[6.2700000000E+03, 1.4986507820E-01, 2.9773008265E+00, 5.7594255912E-04, 5.7362710279E-04, 2.5845947284E-01],
	[6.2750000000E+03, 1.4997401112E-01, 2.9758757434E+00, 5.7715105813E-04, 5.7482744250E-04, 2.5867140863E-01],
	[6.2800000000E+03, 1.5008293638E-01, 2.9744524767E+00, 5.7836112734E-04, 5.7602933006E-04, 2.5888328540E-01],
	[6.2850000000E+03, 1.5019185395E-01, 2.9730310227E+00, 5.7957276753E-04, 5.7723276620E-04, 2.5909510317E-01],
	[6.2900000000E+03, 1.5030076387E-01, 2.9716113775E+00, 5.8078597949E-04, 5.7843775167E-04, 2.5930686198E-01],
	[6.2950000000E+03, 1.5040966612E-01, 2.9701935374E+00, 5.8200076402E-04, 5.7964428721E-04, 2.5951856183E-01],
	[6.3000000000E+03, 1.5051856072E-01, 2.9687774987E+00, 5.8321712188E-04, 5.8085237357E-04, 2.5973020274E-01],
	[6.3050000000E+03, 1.5062744768E-01, 2.9673632578E+00, 5.8443505389E-04, 5.8206201149E-04, 2.5994178474E-01],
	[6.3100000000E+03, 1.5073632700E-01, 2.9659508108E+00, 5.8565456080E-04, 5.8327320171E-04, 2.6015330784E-01],
	[6.3150000000E+03, 1.5084519868E-01, 2.9645401540E+00, 5.8687564343E-04, 5.8448594497E-04, 2.6036477206E-01],
	[6.3200000000E+03, 1.5095406274E-01, 2.9631312839E+00, 5.8809830254E-04, 5.8570024201E-04, 2.6057617742E-01],
	[6.3250000000E+03, 1.5106291918E-01, 2.9617241968E+00, 5.8932253893E-04, 5.8691609358E-04, 2.6078752394E-01],
	[6.3300000000E+03, 1.5117176801E-01, 2.9603188888E+00, 5.9054835338E-04, 5.8813350041E-04, 2.6099881164E-01],
	[6.3350000000E+03, 1.5128060923E-01, 2.9589153565E+00, 5.9177574668E-04, 5.8935246325E-04, 2.6121004054E-01],
	[6.3400000000E+03, 1.5138944285E-01, 2.9575135962E+00, 5.9300471961E-04, 5.9057298284E-04, 2.6142121066E-01],
	[6.3450000000E+03, 1.5149826888E-01, 2.9561136042E+00, 5.9423527296E-04, 5.9179505991E-04, 2.6163232203E-01],
	[6.3500000000E+03, 1.5160708732E-01, 2.9547153770E+00, 5.9546740751E-04, 5.9301869522E-04, 2.6184337465E-01],
	[6.3550000000E+03, 1.5171612501E-01, 2.9533227825E+00, 5.9670112404E-04, 5.9424389312E-04, 2.6205436856E-01],
	[6.3600000000E+03, 1.5182562163E-01, 2.9519398895E+00, 5.9793642335E-04, 5.9547065825E-04, 2.6226530377E-01],
	[6.3650000000E+03, 1.5193511113E-01, 2.9505587301E+00, 5.9917330621E-04, 5.9669898389E-04, 2.6247618031E-01],
	[6.3700000000E+03, 1.5204459352E-01, 2.9491793006E+00, 6.0041177340E-04, 5.9792887079E-04, 2.6268699819E-01],
	[6.3750000000E+03, 1.5215406881E-01, 2.9478015976E+00, 6.0165182572E-04, 5.9916031967E-04, 2.6289775744E-01],
	[6.3800000000E+03, 1.5226353700E-01, 2.9464256176E+00, 6.0289346394E-04, 6.0039333129E-04, 2.6310845808E-01],
	[6.3850000000E+03, 1.5237299810E-01, 2.9450513570E+00, 6.0413668884E-04, 6.0162790637E-04, 2.6331910013E-01],
	[6.3900000000E+03, 1.5248245212E-01, 2.9436788124E+00, 6.0538150122E-04, 6.0286404565E-04, 2.6352968362E-01],
	[6.3950000000E+03, 1.5259189905E-01, 2.9423079803E+00, 6.0662790185E-04, 6.0410174988E-04, 2.6374020856E-01],
	[6.4000000000E+03, 1.5270133892E-01, 2.9409388572E+00, 6.0787589151E-04, 6.0534101980E-04, 2.6395067499E-01],
	[6.4050000000E+03, 1.5281077171E-01, 2.9395714396E+00, 6.0912547099E-04, 6.0658185612E-04, 2.6416108291E-01],
	[6.4100000000E+03, 1.5292019744E-01, 2.9382057241E+00, 6.1037664106E-04, 6.0782425960E-04, 2.6437143237E-01],
	[6.4150000000E+03, 1.5302961612E-01, 2.9368417073E+00, 6.1162940252E-04, 6.0906823098E-04, 2.6458172337E-01],
	[6.4200000000E+03, 1.5313902775E-01, 2.9354793857E+00, 6.1288375614E-04, 6.1031377097E-04, 2.6479195594E-01],
	[6.4250000000E+03, 1.5324843233E-01, 2.9341187559E+00, 6.1413970270E-04, 6.1156088033E-04, 2.6500213011E-01],
	[6.4300000000E+03, 1.5335782988E-01, 2.9327598145E+00, 6.1539724298E-04, 6.1280955979E-04, 2.6521224589E-01],
	[6.4350000000E+03, 1.5346722039E-01, 2.9314025580E+00, 6.1665637777E-04, 6.1405981008E-04, 2.6542230332E-01],
	[6.4400000000E+03, 1.5357660388E-01, 2.9300469832E+00, 6.1791710784E-04, 6.1531163194E-04, 2.6563230242E-01],
	[6.4450000000E+03, 1.5368598035E-01, 2.9286930865E+00, 6.1917943398E-04, 6.1656502611E-04, 2.6584224321E-01],
	[6.4500000000E+03, 1.5379534980E-01, 2.9273408646E+00, 6.2044335696E-04, 6.1781999331E-04, 2.6605212572E-01],
	[6.4550000000E+03, 1.5390471225E-01, 2.9259903141E+00, 6.2170887756E-04, 6.1907653428E-04, 2.6626194996E-01],
	[6.4600000000E+03, 1.5401466637E-01, 2.9246514576E+00, 6.2297599657E-04, 6.2033465992E-04, 2.6647171597E-01],
	[6.4650000000E+03, 1.5412470243E-01, 2.9233157299E+00, 6.2424471476E-04, 6.2159436237E-04, 2.6668142378E-01],
	[6.4700000000E+03, 1.5423473194E-01, 2.9219816441E+00, 6.2551503292E-04, 6.2285564086E-04, 2.6689107340E-01],
	[6.4750000000E+03, 1.5434475491E-01, 2.9206491970E+00, 6.2678695182E-04, 6.2411849613E-04, 2.6710066486E-01],
	[6.4800000000E+03, 1.5445477135E-01, 2.9193183853E+00, 6.2806047223E-04, 6.2538292891E-04, 2.6731019818E-01],
	[6.4850000000E+03, 1.5456478127E-01, 2.9179892058E+00, 6.2933559495E-04, 6.2664893994E-04, 2.6751967340E-01],
	[6.4900000000E+03, 1.5467478466E-01, 2.9166616552E+00, 6.3061232074E-04, 6.2791652993E-04, 2.6772909054E-01],
	[6.4950000000E+03, 1.5478478153E-01, 2.9153357303E+00, 6.3189065039E-04, 6.2918569964E-04, 2.6793844963E-01],
	[6.5000000000E+03, 1.5489477189E-01, 2.9140114277E+00, 6.3317058467E-04, 6.3045644978E-04, 2.6814775068E-01],
	[6.5050000000E+03, 1.5500475575E-01, 2.9126887444E+00, 6.3445212436E-04, 6.3172878110E-04, 2.6835699373E-01],
	[6.5100000000E+03, 1.5511473310E-01, 2.9113676770E+00, 6.3573527023E-04, 6.3300269431E-04, 2.6856617881E-01],
	[6.5150000000E+03, 1.5522470396E-01, 2.9100482223E+00, 6.3702002307E-04, 6.3427819016E-04, 2.6877530593E-01],
	[6.5200000000E+03, 1.5533466833E-01, 2.9087303772E+00, 6.3830638366E-04, 6.3555526938E-04, 2.6898437514E-01],
	[6.5250000000E+03, 1.5544462621E-01, 2.9074141384E+00, 6.3959435276E-04, 6.3683393269E-04, 2.6919338645E-01],
	[6.5300000000E+03, 1.5555457761E-01, 2.9060995028E+00, 6.4088393116E-04, 6.3811418082E-04, 2.6940233989E-01],
	[6.5350000000E+03, 1.5566452254E-01, 2.9047864671E+00, 6.4217511962E-04, 6.3939601451E-04, 2.6961123549E-01],
	[6.5400000000E+03, 1.5577446101E-01, 2.9034750283E+00, 6.4346791894E-04, 6.4067943449E-04, 2.6982007328E-01],
	[6.5450000000E+03, 1.5588439300E-01, 2.9021651831E+00, 6.4476232987E-04, 6.4196444148E-04, 2.7002885329E-01],
	[6.5500000000E+03, 1.5599431854E-01, 2.9008569284E+00, 6.4605835321E-04, 6.4325103621E-04, 2.7023757553E-01],
	[6.5550000000E+03, 1.5610423763E-01, 2.8995502611E+00, 6.4735598972E-04, 6.4453921942E-04, 2.7044624005E-01],
	[6.5600000000E+03, 1.5621420870E-01, 2.8982461396E+00, 6.4865524018E-04, 6.4582899287E-04, 2.7065484687E-01],
	[6.5650000000E+03, 1.5632479627E-01, 2.8969538365E+00, 6.4995610536E-04, 6.4712036745E-04, 2.7086339602E-01],
	[6.5700000000E+03, 1.5643537785E-01, 2.8956630929E+00, 6.5125858604E-04, 6.4841333275E-04, 2.7107188752E-01],
	[6.5750000000E+03, 1.5654595343E-01, 2.8943739057E+00, 6.5256268299E-04, 6.4970788952E-04, 2.7128032141E-01],
	[6.5800000000E+03, 1.5665652303E-01, 2.8930862717E+00, 6.5386839699E-04, 6.5100403847E-04, 2.7148869771E-01],
	[6.5850000000E+03, 1.5676708665E-01, 2.8918001881E+00, 6.5517572881E-04, 6.5230178033E-04, 2.7169701646E-01],
	[6.5900000000E+03, 1.5687764429E-01, 2.8905156516E+00, 6.5648467923E-04, 6.5360111584E-04, 2.7190527768E-01],
	[6.5950000000E+03, 1.5698819597E-01, 2.8892326593E+00, 6.5779524902E-04, 6.5490204571E-04, 2.7211348140E-01],
	[6.6000000000E+03, 1.5709874167E-01, 2.8879512082E+00, 6.5910743894E-04, 6.5620457068E-04, 2.7232162766E-01],
	[6.6050000000E+03, 1.5720928142E-01, 2.8866712952E+00, 6.6042124979E-04, 6.5750869147E-04, 2.7252971647E-01],
	[6.6100000000E+03, 1.5731981521E-01, 2.8853929173E+00, 6.6173668232E-04, 6.5881440881E-04, 2.7273774788E-01],
	[6.6150000000E+03, 1.5743034305E-01, 2.8841160716E+00, 6.6305373731E-04, 6.6012172342E-04, 2.7294572191E-01],
	[6.6200000000E+03, 1.5754086494E-01, 2.8828407550E+00, 6.6437241554E-04, 6.6143063603E-04, 2.7315363859E-01],
	[6.6250000000E+03, 1.5765138089E-01, 2.8815669646E+00, 6.6569271777E-04, 6.6274114736E-04, 2.7336149796E-01],
	[6.6300000000E+03, 1.5776189090E-01, 2.8802946974E+00, 6.6701464478E-04, 6.6405325814E-04, 2.7356930004E-01],
	[6.6350000000E+03, 1.5787239499E-01, 2.8790239503E+00, 6.6833819734E-04, 6.6536696910E-04, 2.7377704486E-01],
	[6.6400000000E+03, 1.5798289314E-01, 2.8777547206E+00, 6.6966337622E-04, 6.6668228096E-04, 2.7398473245E-01],
	[6.6450000000E+03, 1.5809338537E-01, 2.8764870051E+00, 6.7099018219E-04, 6.6799919443E-04, 2.7419236286E-01],
	[6.6500000000E+03, 1.5820387169E-01, 2.8752208010E+00, 6.7231861603E-04, 6.6931771026E-04, 2.7439993609E-01],
	[6.6550000000E+03, 1.5831435209E-01, 2.8739561053E+00, 6.7364867851E-04, 6.7063782916E-04, 2.7460745220E-01],
	[6.6600000000E+03, 1.5842482658E-01, 2.8726929150E+00, 6.7498037039E-04, 6.7195955185E-04, 2.7481491121E-01],
	[6.6650000000E+03, 1.5853529517E-01, 2.8714312274E+00, 6.7631369244E-04, 6.7328287906E-04, 2.7502231315E-01],
	[6.6700000000E+03, 1.5864641024E-01, 2.8701815696E+00, 6.7764864545E-04, 6.7460782389E-04, 2.7522965805E-01],
	[6.6750000000E+03, 1.5875754299E-01, 2.8689337646E+00, 6.7898523017E-04, 6.7593437519E-04, 2.7543694594E-01],
	[6.6800000000E+03, 1.5886867028E-01, 2.8676874359E+00, 6.8032344738E-04, 6.7726253325E-04, 2.7564417687E-01],
	[6.6850000000E+03, 1.5897979212E-01, 2.8664425804E+00, 6.8166329784E-04, 6.7859229880E-04, 2.7585135085E-01],
	[6.6900000000E+03, 1.5909090852E-01, 2.8651991955E+00, 6.8300478233E-04, 6.7992367255E-04, 2.7605846793E-01],
	[6.6950000000E+03, 1.5920201947E-01, 2.8639572783E+00, 6.8434790162E-04, 6.8125665523E-04, 2.7626552812E-01],
	[6.7000000000E+03, 1.5931312500E-01, 2.8627168260E+00, 6.8569265647E-04, 6.8259124756E-04, 2.7647253148E-01],
	[6.7050000000E+03, 1.5942422509E-01, 2.8614778356E+00, 6.8703904766E-04, 6.8392745026E-04, 2.7667947803E-01],
	[6.7100000000E+03, 1.5953531975E-01, 2.8602403045E+00, 6.8838707595E-04, 6.8526526405E-04, 2.7688636780E-01],
	[6.7150000000E+03, 1.5964640900E-01, 2.8590042299E+00, 6.8973674211E-04, 6.8660468964E-04, 2.7709320082E-01],
	[6.7200000000E+03, 1.5975749282E-01, 2.8577696088E+00, 6.9108804691E-04, 6.8794572778E-04, 2.7729997714E-01],
	[6.7250000000E+03, 1.5986857123E-01, 2.8565364386E+00, 6.9244099111E-04, 6.8928837916E-04, 2.7750669677E-01],
	[6.7300000000E+03, 1.5997964424E-01, 2.8553047164E+00, 6.9379557549E-04, 6.9063264452E-04, 2.7771335977E-01],
	[6.7350000000E+03, 1.6009071183E-01, 2.8540744395E+00, 6.9515180081E-04, 6.9197852457E-04, 2.7791996615E-01],
	[6.7400000000E+03, 1.6020177403E-01, 2.8528456051E+00, 6.9650966785E-04, 6.9332602003E-04, 2.7812651596E-01],
	[6.7450000000E+03, 1.6031283083E-01, 2.8516182105E+00, 6.9786917736E-04, 6.9467513162E-04, 2.7833300922E-01],
	[6.7500000000E+03, 1.6042388224E-01, 2.8503922529E+00, 6.9923033011E-04, 6.9602586006E-04, 2.7853944598E-01],
	[6.7550000000E+03, 1.6053492825E-01, 2.8491677295E+00, 7.0059312688E-04, 6.9737820607E-04, 2.7874582626E-01],
	[6.7600000000E+03, 1.6064596889E-01, 2.8479446376E+00, 7.0195756842E-04, 6.9873217036E-04, 2.7895215010E-01],
	[6.7650000000E+03, 1.6075700414E-01, 2.8467229746E+00, 7.0332365551E-04, 7.0008775366E-04, 2.7915841754E-01],
	[6.7700000000E+03, 1.6086803402E-01, 2.8455027375E+00, 7.0469138890E-04, 7.0144495668E-04, 2.7936462861E-01],
	[6.7750000000E+03, 1.6097939720E-01, 2.8442892941E+00, 7.0606076938E-04, 7.0280378693E-04, 2.7957078334E-01],
	[6.7800000000E+03, 1.6109108635E-01, 2.8430825073E+00, 7.0743179769E-04, 7.0416424502E-04, 2.7977688178E-01],
	[6.7850000000E+03, 1.6120277056E-01, 2.8418771217E+00, 7.0880447461E-04, 7.0552632506E-04, 2.7998292395E-01],
	[6.7900000000E+03, 1.6131444985E-01, 2.8406731345E+00, 7.1017880091E-04, 7.0689002777E-04, 2.8018890988E-01],
	[6.7950000000E+03, 1.6142612422E-01, 2.8394705430E+00, 7.1155477734E-04, 7.0825535387E-04, 2.8039483963E-01],
	[6.8000000000E+03, 1.6153779367E-01, 2.8382693447E+00, 7.1293240467E-04, 7.0962230407E-04, 2.8060071321E-01],
	[6.8050000000E+03, 1.6164945820E-01, 2.8370695369E+00, 7.1431168367E-04, 7.1099087909E-04, 2.8080653067E-01],
	[6.8100000000E+03, 1.6176111782E-01, 2.8358711170E+00, 7.1569261510E-04, 7.1236107964E-04, 2.8101229204E-01],
	[6.8150000000E+03, 1.6187277253E-01, 2.8346740823E+00, 7.1707519973E-04, 7.1373290644E-04, 2.8121799736E-01],
	[6.8200000000E+03, 1.6198442234E-01, 2.8334784302E+00, 7.1845943832E-04, 7.1510636021E-04, 2.8142364667E-01],
	[6.8250000000E+03, 1.6209606724E-01, 2.8322841582E+00, 7.1984533163E-04, 7.1648144166E-04, 2.8162923999E-01],
	[6.8300000000E+03, 1.6220770726E-01, 2.8310912636E+00, 7.2123288043E-04, 7.1785815150E-04, 2.8183477738E-01],
	[6.8350000000E+03, 1.6231934237E-01, 2.8298997438E+00, 7.2262208548E-04, 7.1923649045E-04, 2.8204025885E-01],
	[6.8400000000E+03, 1.6243097260E-01, 2.8287095963E+00, 7.2401294755E-04, 7.2061645923E-04, 2.8224568446E-01],
	[6.8450000000E+03, 1.6254259795E-01, 2.8275208184E+00, 7.2540546739E-04, 7.2199805855E-04, 2.8245105423E-01],
	[6.8500000000E+03, 1.6265421841E-01, 2.8263334075E+00, 7.2679964577E-04, 7.2338128912E-04, 2.8265636820E-01],
	[6.8550000000E+03, 1.6276583400E-01, 2.8251473612E+00, 7.2819548345E-04, 7.2476615166E-04, 2.8286162642E-01],
	[6.8600000000E+03, 1.6287744471E-01, 2.8239626769E+00, 7.2959298120E-04, 7.2615264688E-04, 2.8306682891E-01],
	[6.8650000000E+03, 1.6298905055E-01, 2.8227793519E+00, 7.3099213978E-04, 7.2754077549E-04, 2.8327197572E-01],
	[6.8700000000E+03, 1.6310065153E-01, 2.8215973838E+00, 7.3239295994E-04, 7.2893053820E-04, 2.8347706688E-01],
	[6.8750000000E+03, 1.6321224764E-01, 2.8204167700E+00, 7.3379544246E-04, 7.3032193574E-04, 2.8368210243E-01],
	[6.8800000000E+03, 1.6332383890E-01, 2.8192375080E+00, 7.3519958809E-04, 7.3171496880E-04, 2.8388708241E-01],
	[6.8850000000E+03, 1.6343589027E-01, 2.8180668333E+00, 7.3660539759E-04, 7.3310964795E-04, 2.8409200685E-01],
	[6.8900000000E+03, 1.6354813624E-01, 2.8169005907E+00, 7.3801287172E-04, 7.3450596835E-04, 2.8429687579E-01],
	[6.8950000000E+03, 1.6366037778E-01, 2.8157356762E+00, 7.3942201126E-04, 7.3590392648E-04, 2.8450168920E-01],
	[6.9000000000E+03, 1.6377261491E-01, 2.8145720874E+00, 7.4083281694E-04, 7.3730352308E-04, 2.8470644705E-01],
	[6.9050000000E+03, 1.6388484763E-01, 2.8134098219E+00, 7.4224528955E-04, 7.3870475884E-04, 2.8491114936E-01],
	[6.9100000000E+03, 1.6399707594E-01, 2.8122488770E+00, 7.4365942983E-04, 7.4010763448E-04, 2.8511579615E-01],
	[6.9150000000E+03, 1.6410929983E-01, 2.8110892504E+00, 7.4507523856E-04, 7.4151215071E-04, 2.8532038742E-01],
	[6.9200000000E+03, 1.6422151933E-01, 2.8099309397E+00, 7.4649271647E-04, 7.4291830825E-04, 2.8552492318E-01],
	[6.9250000000E+03, 1.6433373442E-01, 2.8087739424E+00, 7.4791186435E-04, 7.4432610779E-04, 2.8572940346E-01],
	[6.9300000000E+03, 1.6444594512E-01, 2.8076182560E+00, 7.4933268294E-04, 7.4573555006E-04, 2.8593382827E-01],
	[6.9350000000E+03, 1.6455815142E-01, 2.8064638781E+00, 7.5075517301E-04, 7.4714663575E-04, 2.8613819762E-01],
	[6.9400000000E+03, 1.6467035333E-01, 2.8053108064E+00, 7.5217933532E-04, 7.4855936559E-04, 2.8634251151E-01],
	[6.9450000000E+03, 1.6478255086E-01, 2.8041590383E+00, 7.5360517062E-04, 7.4997374028E-04, 2.8654676998E-01],
	[6.9500000000E+03, 1.6489474400E-01, 2.8030085715E+00, 7.5503267967E-04, 7.5138976052E-04, 2.8675097303E-01],
	[6.9550000000E+03, 1.6500693276E-01, 2.8018594036E+00, 7.5646186323E-04, 7.5280742703E-04, 2.8695512067E-01],
	[6.9600000000E+03, 1.6511911714E-01, 2.8007115322E+00, 7.5789272206E-04, 7.5422674052E-04, 2.8715921293E-01],
	[6.9650000000E+03, 1.6523129715E-01, 2.7995649548E+00, 7.5932525693E-04, 7.5564770169E-04, 2.8736324981E-01],
	[6.9700000000E+03, 1.6534347279E-01, 2.7984196691E+00, 7.6075946857E-04, 7.5707031126E-04, 2.8756723133E-01],
	[6.9750000000E+03, 1.6545564406E-01, 2.7972756728E+00, 7.6219535776E-04, 7.5849456992E-04, 2.8777115751E-01],
	[6.9800000000E+03, 1.6556781097E-01, 2.7961329634E+00, 7.6363292525E-04, 7.5992047839E-04, 2.8797502835E-01],
	[6.9850000000E+03, 1.6567997352E-01, 2.7949915385E+00, 7.6507217180E-04, 7.6134803738E-04, 2.8817884389E-01],
	[6.9900000000E+03, 1.6579213171E-01, 2.7938513959E+00, 7.6651309817E-04, 7.6277724758E-04, 2.8838260412E-01],
	[6.9950000000E+03, 1.6590464380E-01, 2.7927180035E+00, 7.6795570511E-04, 7.6420811773E-04, 2.8858630907E-01],
	[7.0000000000E+03, 1.6601745259E-01, 2.7915904688E+00, 7.6939999337E-04, 7.6564064729E-04, 2.8878995876E-01],
	[7.0050000000E+03, 1.6613025746E-01, 2.7904641939E+00, 7.7085679864E-04, 7.6708555944E-04, 2.8899355319E-01],
	[7.0100000000E+03, 1.6624305840E-01, 2.7893391766E+00, 7.7231531985E-04, 7.6853215823E-04, 2.8919709239E-01],
	[7.0150000000E+03, 1.6635585542E-01, 2.7882154145E+00, 7.7377555780E-04, 7.6998044440E-04, 2.8940057637E-01],
	[7.0200000000E+03, 1.6646864853E-01, 2.7870929053E+00, 7.7523751328E-04, 7.7143041870E-04, 2.8960400514E-01],
	[7.0250000000E+03, 1.6658143773E-01, 2.7859716468E+00, 7.7670118709E-04, 7.7288208187E-04, 2.8980737873E-01],
	[7.0300000000E+03, 1.6669422301E-01, 2.7848516366E+00, 7.7816658003E-04, 7.7433543465E-04, 2.9001069715E-01],
	[7.0350000000E+03, 1.6680700438E-01, 2.7837328725E+00, 7.7963369288E-04, 7.7579047779E-04, 2.9021396041E-01],
	[7.0400000000E+03, 1.6691978185E-01, 2.7826153523E+00, 7.8110252645E-04, 7.7724721202E-04, 2.9041716854E-01],
	[7.0450000000E+03, 1.6703255542E-01, 2.7814990736E+00, 7.8257308153E-04, 7.7870563810E-04, 2.9062032154E-01],
	[7.0500000000E+03, 1.6714532509E-01, 2.7803840343E+00, 7.8404535890E-04, 7.8016575675E-04, 2.9082341945E-01],
	[7.0550000000E+03, 1.6725809087E-01, 2.7792702319E+00, 7.8551935937E-04, 7.8162756872E-04, 2.9102646226E-01],
	[7.0600000000E+03, 1.6737085275E-01, 2.7781576644E+00, 7.8699508373E-04, 7.8309107475E-04, 2.9122945001E-01],
	[7.0650000000E+03, 1.6748361073E-01, 2.7770463294E+00, 7.8847253276E-04, 7.8455627558E-04, 2.9143238271E-01],
	[7.0700000000E+03, 1.6759636484E-01, 2.7759362248E+00, 7.8995170727E-04, 7.8602317196E-04, 2.9163526038E-01],
	[7.0750000000E+03, 1.6770911505E-01, 2.7748273482E+00, 7.9143260804E-04, 7.8749176462E-04, 2.9183808303E-01],
	[7.0800000000E+03, 1.6782186139E-01, 2.7737196975E+00, 7.9291523587E-04, 7.8896205429E-04, 2.9204085068E-01],
	[7.0850000000E+03, 1.6793460384E-01, 2.7726132704E+00, 7.9439959156E-04, 7.9043404173E-04, 2.9224356336E-01],
	[7.0900000000E+03, 1.6804734242E-01, 2.7715080648E+00, 7.9588567588E-04, 7.9190772767E-04, 2.9244622107E-01],
	[7.0950000000E+03, 1.6816007713E-01, 2.7704040784E+00, 7.9737348964E-04, 7.9338311285E-04, 2.9264882383E-01],
	[7.1000000000E+03, 1.6827280797E-01, 2.7693013090E+00, 7.9886303363E-04, 7.9486019800E-04, 2.9285137168E-01],
	[7.1050000000E+03, 1.6838555490E-01, 2.7682000518E+00, 8.0035430863E-04, 7.9633898435E-04, 2.9305386461E-01],
	[7.1100000000E+03, 1.6849893485E-01, 2.7671094817E+00, 8.0184731544E-04, 7.9781948721E-04, 2.9325630266E-01],
	[7.1150000000E+03, 1.6861231135E-01, 2.7660201074E+00, 8.0334205486E-04, 7.9930169236E-04, 2.9345868584E-01],
	[7.1200000000E+03, 1.6872568441E-01, 2.7649319268E+00, 8.0483852766E-04, 8.0078560051E-04, 2.9366101417E-01],
	[7.1250000000E+03, 1.6883905404E-01, 2.7638449378E+00, 8.0633673465E-04, 8.0227121243E-04, 2.9386328767E-01],
	[7.1300000000E+03, 1.6895242023E-01, 2.7627591382E+00, 8.0783667660E-04, 8.0375852883E-04, 2.9406550636E-01],
	[7.1350000000E+03, 1.6906578299E-01, 2.7616745258E+00, 8.0933835433E-04, 8.0524755046E-04, 2.9426767025E-01],
	[7.1400000000E+03, 1.6917914232E-01, 2.7605910987E+00, 8.1084176860E-04, 8.0673827806E-04, 2.9446977937E-01],
	[7.1450000000E+03, 1.6929249822E-01, 2.7595088545E+00, 8.1234692022E-04, 8.0823071235E-04, 2.9467183374E-01],
	[7.1500000000E+03, 1.6940585069E-01, 2.7584277913E+00, 8.1385380997E-04, 8.0972485409E-04, 2.9487383337E-01],
	[7.1550000000E+03, 1.6951919975E-01, 2.7573479068E+00, 8.1536243864E-04, 8.1122070400E-04, 2.9507577829E-01],
	[7.1600000000E+03, 1.6963254538E-01, 2.7562691990E+00, 8.1687280703E-04, 8.1271826282E-04, 2.9527766851E-01],
	[7.1650000000E+03, 1.6974588760E-01, 2.7551916659E+00, 8.1838491592E-04, 8.1421753128E-04, 2.9547950406E-01],
	[7.1700000000E+03, 1.6985922640E-01, 2.7541153052E+00, 8.1989876609E-04, 8.1571851013E-04, 2.9568128495E-01],
	[7.1750000000E+03, 1.6997256179E-01, 2.7530401149E+00, 8.2141435835E-04, 8.1722120009E-04, 2.9588301121E-01],
	[7.1800000000E+03, 1.7008589377E-01, 2.7519660929E+00, 8.2293169347E-04, 8.1872560191E-04, 2.9608468286E-01],
	[7.1850000000E+03, 1.7019922234E-01, 2.7508932372E+00, 8.2445077225E-04, 8.2023171631E-04, 2.9628629991E-01],
	[7.1900000000E+03, 1.7031254751E-01, 2.7498215456E+00, 8.2597159548E-04, 8.2173954403E-04, 2.9648786239E-01],
	[7.1950000000E+03, 1.7042586927E-01, 2.7487510161E+00, 8.2749416393E-04, 8.2324908580E-04, 2.9668937031E-01],
	[7.2000000000E+03, 1.7053918764E-01, 2.7476816466E+00, 8.2901847841E-04, 8.2476034237E-04, 2.9689082371E-01],
	[7.2050000000E+03, 1.7065250260E-01, 2.7466134350E+00, 8.3054453969E-04, 8.2627331446E-04, 2.9709222260E-01],
	[7.2100000000E+03, 1.7076581417E-01, 2.7455463794E+00, 8.3207234857E-04, 8.2778800280E-04, 2.9729356699E-01],
	[7.2150000000E+03, 1.7087912235E-01, 2.7444804775E+00, 8.3360190583E-04, 8.2930440813E-04, 2.9749485692E-01],
	[7.2200000000E+03, 1.7099252853E-01, 2.7434171966E+00, 8.3513321226E-04, 8.3082253371E-04, 2.9769609240E-01],
	[7.2250000000E+03, 1.7110648548E-01, 2.7423630829E+00, 8.3666626865E-04, 8.3234239161E-04, 2.9789727346E-01],
	[7.2300000000E+03, 1.7122043945E-01, 2.7413101030E+00, 8.3820107578E-04, 8.3386396878E-04, 2.9809840011E-01],
	[7.2350000000E+03, 1.7133439046E-01, 2.7402582550E+00, 8.3973763444E-04, 8.3538726597E-04, 2.9829947238E-01],
	[7.2400000000E+03, 1.7144833850E-01, 2.7392075368E+00, 8.4127594542E-04, 8.3691228389E-04, 2.9850049029E-01],
	[7.2450000000E+03, 1.7156228358E-01, 2.7381579465E+00, 8.4281600950E-04, 8.3843902328E-04, 2.9870145386E-01],
	[7.2500000000E+03, 1.7167622571E-01, 2.7371094820E+00, 8.4435782747E-04, 8.3996748488E-04, 2.9890236312E-01],
	[7.2550000000E+03, 1.7179016487E-01, 2.7360621414E+00, 8.4590140011E-04, 8.4149766942E-04, 2.9910321808E-01],
	[7.2600000000E+03, 1.7190410108E-01, 2.7350159228E+00, 8.4744672821E-04, 8.4302957762E-04, 2.9930401877E-01],
	[7.2650000000E+03, 1.7201803433E-01, 2.7339708240E+00, 8.4899381256E-04, 8.4456321021E-04, 2.9950476521E-01],
	[7.2700000000E+03, 1.7213196463E-01, 2.7329268432E+00, 8.5054265393E-04, 8.4609856794E-04, 2.9970545742E-01],
	[7.2750000000E+03, 1.7224589199E-01, 2.7318839784E+00, 8.5209325312E-04, 8.4763565152E-04, 2.9990609542E-01],
	[7.2800000000E+03, 1.7235981639E-01, 2.7308422277E+00, 8.5364561092E-04, 8.4917446169E-04, 3.0010667925E-01],
	[7.2850000000E+03, 1.7247373785E-01, 2.7298015890E+00, 8.5519972809E-04, 8.5071499918E-04, 3.0030720891E-01],
	[7.2900000000E+03, 1.7258765637E-01, 2.7287620605E+00, 8.5675560544E-04, 8.5225726472E-04, 3.0050768444E-01],
	[7.2950000000E+03, 1.7270157194E-01, 2.7277236401E+00, 8.5831324373E-04, 8.5380125904E-04, 3.0070810586E-01],
	[7.3000000000E+03, 1.7281548458E-01, 2.7266863260E+00, 8.5987264377E-04, 8.5534698286E-04, 3.0090847318E-01],
	[7.3050000000E+03, 1.7292939428E-01, 2.7256501162E+00, 8.6143380633E-04, 8.5689443692E-04, 3.0110878644E-01],
	[7.3100000000E+03, 1.7304330105E-01, 2.7246150088E+00, 8.6299673219E-04, 8.5844362194E-04, 3.0130904566E-01],
	[7.3150000000E+03, 1.7315720488E-01, 2.7235810019E+00, 8.6456142214E-04, 8.5999453866E-04, 3.0150925085E-01],
	[7.3200000000E+03, 1.7327110578E-01, 2.7225480935E+00, 8.6612787696E-04, 8.6154718780E-04, 3.0170940205E-01],
	[7.3250000000E+03, 1.7338500375E-01, 2.7215162818E+00, 8.6769609743E-04, 8.6310157008E-04, 3.0190949927E-01],
	[7.3300000000E+03, 1.7349889880E-01, 2.7204855647E+00, 8.6926608435E-04, 8.6465768625E-04, 3.0210954255E-01],
	[7.3350000000E+03, 1.7361279092E-01, 2.7194559405E+00, 8.7083783848E-04, 8.6621553702E-04, 3.0230953190E-01],
	[7.3400000000E+03, 1.7372727593E-01, 2.7184357995E+00, 8.7241136061E-04, 8.6777513884E-04, 3.0250946735E-01],
	[7.3450000000E+03, 1.7384181677E-01, 2.7174175571E+00, 8.7398665154E-04, 8.6933647835E-04, 3.0270934892E-01],
	[7.3500000000E+03, 1.7395635511E-01, 2.7164003885E+00, 8.7556371203E-04, 8.7089955473E-04, 3.0290917663E-01],
	[7.3550000000E+03, 1.7407089095E-01, 2.7153842921E+00, 8.7714254286E-04, 8.7246436872E-04, 3.0310895052E-01],
	[7.3600000000E+03, 1.7418542429E-01, 2.7143692658E+00, 8.7872314483E-04, 8.7403092104E-04, 3.0330867061E-01],
	[7.3650000000E+03, 1.7429995512E-01, 2.7133553079E+00, 8.8030551872E-04, 8.7559921242E-04, 3.0350833691E-01],
	[7.3700000000E+03, 1.7441448346E-01, 2.7123424165E+00, 8.8188966529E-04, 8.7716924358E-04, 3.0370794946E-01],
	[7.3750000000E+03, 1.7452900931E-01, 2.7113305898E+00, 8.8347558534E-04, 8.7874101525E-04, 3.0390750828E-01],
	[7.3800000000E+03, 1.7464353266E-01, 2.7103198259E+00, 8.8506327965E-04, 8.8031452815E-04, 3.0410701339E-01],
	[7.3850000000E+03, 1.7475805352E-01, 2.7093101230E+00, 8.8665274900E-04, 8.8188978301E-04, 3.0430646482E-01],
	[7.3900000000E+03, 1.7487257189E-01, 2.7083014793E+00, 8.8824399416E-04, 8.8346678056E-04, 3.0450586259E-01],
	[7.3950000000E+03, 1.7498708777E-01, 2.7072938929E+00, 8.8983701593E-04, 8.8504552152E-04, 3.0470520674E-01],
	[7.4000000000E+03, 1.7510160116E-01, 2.7062873619E+00, 8.9143181507E-04, 8.8662600661E-04, 3.0490449728E-01],
	[7.4050000000E+03, 1.7521611207E-01, 2.7052818847E+00, 8.9302839237E-04, 8.8820823656E-04, 3.0510373423E-01],
	[7.4100000000E+03, 1.7533062050E-01, 2.7042774594E+00, 8.9462674861E-04, 8.8979221209E-04, 3.0530291764E-01],
	[7.4150000000E+03, 1.7544512644E-01, 2.7032740841E+00, 8.9622688457E-04, 8.9137793393E-04, 3.0550204751E-01],
	[7.4200000000E+03, 1.7555962991E-01, 2.7022717571E+00, 8.9782880102E-04, 8.9296540280E-04, 3.0570112388E-01],
	[7.4250000000E+03, 1.7567413089E-01, 2.7012704766E+00, 8.9943249876E-04, 8.9455461942E-04, 3.0590014677E-01],
	[7.4300000000E+03, 1.7578862940E-01, 2.7002702408E+00, 9.0103797855E-04, 8.9614558452E-04, 3.0609911621E-01],
	[7.4350000000E+03, 1.7590312544E-01, 2.6992710478E+00, 9.0264524118E-04, 8.9773829882E-04, 3.0629803222E-01],
	[7.4400000000E+03, 1.7601761900E-01, 2.6982728959E+00, 9.0425428742E-04, 8.9933276304E-04, 3.0649689483E-01],
	[7.4450000000E+03, 1.7613211010E-01, 2.6972757833E+00, 9.0586511805E-04, 9.0092897790E-04, 3.0669570407E-01],
	[7.4500000000E+03, 1.7624659872E-01, 2.6962797082E+00, 9.0747773386E-04, 9.0252694413E-04, 3.0689445996E-01],
	[7.4550000000E+03, 1.7636127591E-01, 2.6952872887E+00, 9.0909213562E-04, 9.0412666777E-04, 3.0709316253E-01],
	[7.4600000000E+03, 1.7647641268E-01, 2.6943022273E+00, 9.1070832410E-04, 9.0572815712E-04, 3.0729181180E-01],
	[7.4650000000E+03, 1.7659154739E-01, 2.6933181855E+00, 9.1232630010E-04, 9.0733140011E-04, 3.0749040781E-01],
	[7.4700000000E+03, 1.7670668005E-01, 2.6923351617E+00, 9.1394606437E-04, 9.0893639744E-04, 3.0768895057E-01],
	[7.4750000000E+03, 1.7682181066E-01, 2.6913531541E+00, 9.1556761771E-04, 9.1054314983E-04, 3.0788744011E-01],
	[7.4800000000E+03, 1.7693693922E-01, 2.6903721609E+00, 9.1719096089E-04, 9.1215165802E-04, 3.0808587647E-01],
	[7.4850000000E+03, 1.7705206573E-01, 2.6893921805E+00, 9.1881609468E-04, 9.1376192272E-04, 3.0828425967E-01],
	[7.4900000000E+03, 1.7716719020E-01, 2.6884132111E+00, 9.2044301987E-04, 9.1537394466E-04, 3.0848258973E-01],
	[7.4950000000E+03, 1.7728231263E-01, 2.6874352510E+00, 9.2207173722E-04, 9.1698772454E-04, 3.0868086668E-01],
	[7.5000000000E+03, 1.7739743301E-01, 2.6864582984E+00, 9.2370224752E-04, 9.1860326309E-04, 3.0887909055E-01],
	[7.5050000000E+03, 1.7751255135E-01, 2.6854823518E+00, 9.2533455155E-04, 9.2022056104E-04, 3.0907726137E-01],
	[7.5100000000E+03, 1.7762766765E-01, 2.6845074093E+00, 9.2696865007E-04, 9.2183961910E-04, 3.0927537916E-01],
	[7.5150000000E+03, 1.7774278192E-01, 2.6835334693E+00, 9.2860454387E-04, 9.2346043798E-04, 3.0947344395E-01],
	[7.5200000000E+03, 1.7785789414E-01, 2.6825605301E+00, 9.3024223372E-04, 9.2508301842E-04, 3.0967145577E-01],
	[7.5250000000E+03, 1.7797300433E-01, 2.6815885899E+00, 9.3188172040E-04, 9.2670736113E-04, 3.0986941465E-01],
	[7.5300000000E+03, 1.7808811249E-01, 2.6806176472E+00, 9.3352300468E-04, 9.2833346682E-04, 3.1006732061E-01],
	[7.5350000000E+03, 1.7820321861E-01, 2.6796477001E+00, 9.3516608734E-04, 9.2996133621E-04, 3.1026517368E-01],
	[7.5400000000E+03, 1.7831832270E-01, 2.6786787471E+00, 9.3681096916E-04, 9.3159097003E-04, 3.1046297389E-01],
	[7.5450000000E+03, 1.7843342476E-01, 2.6777107864E+00, 9.3845765090E-04, 9.3322236899E-04, 3.1066072128E-01],
	[7.5500000000E+03, 1.7854852479E-01, 2.6767438164E+00, 9.4010613334E-04, 9.3485553381E-04, 3.1085841584E-01],
	[7.5550000000E+03, 1.7866362280E-01, 2.6757778355E+00, 9.4175641726E-04, 9.3649046521E-04, 3.1105605755E-01],
	[7.5600000000E+03, 1.7877871878E-01, 2.6748128418E+00, 9.4340850343E-04, 9.3812716389E-04, 3.1125364643E-01],
	[7.5650000000E+03, 1.7889381273E-01, 2.6738488339E+00, 9.4506239263E-04, 9.3976563059E-04, 3.1145118247E-01],
	[7.5700000000E+03, 1.7900890466E-01, 2.6728858099E+00, 9.4671808564E-04, 9.4140586601E-04, 3.1164866570E-01],
	[7.5750000000E+03, 1.7912418634E-01, 2.6719263268E+00, 9.4837558321E-04, 9.4304787651E-04, 3.1184609612E-01],
	[7.5800000000E+03, 1.7923992613E-01, 2.6709739520E+00, 9.5003488613E-04, 9.4469167075E-04, 3.1204347374E-01],
	[7.5850000000E+03, 1.7935566431E-01, 2.6700225443E+00, 9.5169599518E-04, 9.4633723596E-04, 3.1224079857E-01],
	[7.5900000000E+03, 1.7947140088E-01, 2.6690721021E+00, 9.5335891112E-04, 9.4798457285E-04, 3.1243807062E-01],
	[7.5950000000E+03, 1.7958713584E-01, 2.6681226238E+00, 9.5502363473E-04, 9.4963368216E-04, 3.1263528991E-01],
	[7.6000000000E+03, 1.7970286920E-01, 2.6671741077E+00, 9.5669016678E-04, 9.5128456458E-04, 3.1283245643E-01],
	[7.6050000000E+03, 1.7981860095E-01, 2.6662265524E+00, 9.5835850804E-04, 9.5293722084E-04, 3.1302957021E-01],
	[7.6100000000E+03, 1.7993433109E-01, 2.6652799562E+00, 9.6002865930E-04, 9.5459165165E-04, 3.1322663126E-01],
	[7.6150000000E+03, 1.8005005964E-01, 2.6643343174E+00, 9.6170062131E-04, 9.5624785773E-04, 3.1342363958E-01],
	[7.6200000000E+03, 1.8016578658E-01, 2.6633896345E+00, 9.6337439485E-04, 9.5790583978E-04, 3.1362059519E-01],
	[7.6250000000E+03, 1.8028151191E-01, 2.6624459059E+00, 9.6504998070E-04, 9.5956559853E-04, 3.1381749810E-01],
	[7.6300000000E+03, 1.8039723565E-01, 2.6615031300E+00, 9.6672737962E-04, 9.6122713470E-04, 3.1401434831E-01],
	[7.6350000000E+03, 1.8051295779E-01, 2.6605613052E+00, 9.6840659240E-04, 9.6289044898E-04, 3.1421114585E-01],
	[7.6400000000E+03, 1.8062867833E-01, 2.6596204300E+00, 9.7008761979E-04, 9.6455554210E-04, 3.1440789072E-01],
	[7.6450000000E+03, 1.8074439728E-01, 2.6586805027E+00, 9.7177046257E-04, 9.6622241477E-04, 3.1460458293E-01],
	[7.6500000000E+03, 1.8086011463E-01, 2.6577415218E+00, 9.7345512151E-04, 9.6789106770E-04, 3.1480122250E-01],
	[7.6550000000E+03, 1.8097583038E-01, 2.6568034857E+00, 9.7514159739E-04, 9.6956150160E-04, 3.1499780944E-01],
	[7.6600000000E+03, 1.8109154454E-01, 2.6558663928E+00, 9.7682989097E-04, 9.7123371720E-04, 3.1519434375E-01],
	[7.6650000000E+03, 1.8120725711E-01, 2.6549302417E+00, 9.7852000303E-04, 9.7290771520E-04, 3.1539082546E-01],
	[7.6700000000E+03, 1.8132296809E-01, 2.6539950306E+00, 9.8021193433E-04, 9.7458349630E-04, 3.1558725457E-01],
	[7.6750000000E+03, 1.8143867747E-01, 2.6530607582E+00, 9.8190568565E-04, 9.7626106124E-04, 3.1578363110E-01],
	[7.6800000000E+03, 1.8155438527E-01, 2.6521274227E+00, 9.8360125775E-04, 9.7794041071E-04, 3.1597995506E-01],
	[7.6850000000E+03, 1.8167009147E-01, 2.6511950227E+00, 9.8529865141E-04, 9.7962154543E-04, 3.1617622645E-01],
	[7.6900000000E+03, 1.8178579609E-01, 2.6502635566E+00, 9.8699786740E-04, 9.8130446610E-04, 3.1637244530E-01],
	[7.6950000000E+03, 1.8190149913E-01, 2.6493330229E+00, 9.8869890648E-04, 9.8298917345E-04, 3.1656861162E-01],
	[7.7000000000E+03, 1.8201779239E-01, 2.6484110968E+00, 9.9040176943E-04, 9.8467568656E-04, 3.1676472541E-01],
	[7.7050000000E+03, 1.8213414329E-01, 2.6474908523E+00, 9.9210645701E-04, 9.8636398969E-04, 3.1696078670E-01],
	[7.7100000000E+03, 1.8225049301E-01, 2.6465715241E+00, 9.9381296999E-04, 9.8805408172E-04, 3.1715679549E-01],
	[7.7150000000E+03, 1.8236684156E-01, 2.6456531109E+00, 9.9552130915E-04, 9.8974596336E-04, 3.1735275180E-01],
	[7.7200000000E+03, 1.8248318893E-01, 2.6447356111E+00, 9.9723147525E-04, 9.9143963533E-04, 3.1754865564E-01],
	[7.7250000000E+03, 1.8259953513E-01, 2.6438190232E+00, 9.9894346906E-04, 9.9313509834E-04, 3.1774450702E-01],
	[7.7300000000E+03, 1.8271588015E-01, 2.6429033457E+00, 1.0006572913E-03, 9.9483235308E-04, 3.1794030596E-01],
	[7.7350000000E+03, 1.8283222400E-01, 2.6419885772E+00, 1.0023729429E-03, 9.9653140029E-04, 3.1813605247E-01],
	[7.7400000000E+03, 1.8294856668E-01, 2.6410747161E+00, 1.0040904244E-03, 9.9823224065E-04, 3.1833174656E-01],
	[7.7450000000E+03, 1.8306490818E-01, 2.6401617609E+00, 1.0058097368E-03, 9.9993487489E-04, 3.1852738825E-01],
	[7.7500000000E+03, 1.8318124852E-01, 2.6392497103E+00, 1.0075308806E-03, 1.0016393037E-03, 3.1872297756E-01],
	[7.7550000000E+03, 1.8329758769E-01, 2.6383385626E+00, 1.0092538568E-03, 1.0033455278E-03, 3.1891851448E-01],
	[7.7600000000E+03, 1.8341392569E-01, 2.6374283165E+00, 1.0109786661E-03, 1.0050535479E-03, 3.1911399905E-01],
	[7.7650000000E+03, 1.8353026251E-01, 2.6365189704E+00, 1.0127053093E-03, 1.0067633647E-03, 3.1930943127E-01],
	[7.7700000000E+03, 1.8364659818E-01, 2.6356105228E+00, 1.0144337870E-03, 1.0084749789E-03, 3.1950481116E-01],
	[7.7750000000E+03, 1.8376293267E-01, 2.6347029724E+00, 1.0161641002E-03, 1.0101883913E-03, 3.1970013873E-01],
	[7.7800000000E+03, 1.8387926600E-01, 2.6337963177E+00, 1.0178962495E-03, 1.0119036025E-03, 3.1989541399E-01],
	[7.7850000000E+03, 1.8399559817E-01, 2.6328905571E+00, 1.0196302357E-03, 1.0136206132E-03, 3.2009063697E-01],
	[7.7900000000E+03, 1.8411192917E-01, 2.6319856893E+00, 1.0213660596E-03, 1.0153394241E-03, 3.2028580767E-01],
	[7.7950000000E+03, 1.8422825900E-01, 2.6310817127E+00, 1.0231037220E-03, 1.0170600360E-03, 3.2048092611E-01],
	[7.8000000000E+03, 1.8434458768E-01, 2.6301786260E+00, 1.0248432235E-03, 1.0187824496E-03, 3.2067599230E-01],
	[7.8050000000E+03, 1.8446091519E-01, 2.6292764277E+00, 1.0265845651E-03, 1.0205066655E-03, 3.2087100626E-01],
	[7.8100000000E+03, 1.8457724154E-01, 2.6283751164E+00, 1.0283277474E-03, 1.0222326844E-03, 3.2106596800E-01],
	[7.8150000000E+03, 1.8469356673E-01, 2.6274746905E+00, 1.0300727712E-03, 1.0239605072E-03, 3.2126087755E-01],
	[7.8200000000E+03, 1.8480997670E-01, 2.6265762341E+00, 1.0318196373E-03, 1.0256901372E-03, 3.2145573490E-01],
	[7.8250000000E+03, 1.8492694923E-01, 2.6256857703E+00, 1.0335683465E-03, 1.0274215910E-03, 3.2165054008E-01],
	[7.8300000000E+03, 1.8504392101E-01, 2.6247961769E+00, 1.0353188994E-03, 1.0291548507E-03, 3.2184529311E-01],
	[7.8350000000E+03, 1.8516089203E-01, 2.6239074526E+00, 1.0370712970E-03, 1.0308899171E-03, 3.2203999399E-01],
	[7.8400000000E+03, 1.8527786230E-01, 2.6230195958E+00, 1.0388255399E-03, 1.0326267909E-03, 3.2223464275E-01],
	[7.8450000000E+03, 1.8539483182E-01, 2.6221326052E+00, 1.0405816289E-03, 1.0343654729E-03, 3.2242923940E-01],
	[7.8500000000E+03, 1.8551180059E-01, 2.6212464794E+00, 1.0423395647E-03, 1.0361059636E-03, 3.2262378395E-01],
	[7.8550000000E+03, 1.8562876860E-01, 2.6203612171E+00, 1.0440993482E-03, 1.0378482639E-03, 3.2281827643E-01],
	[7.8600000000E+03, 1.8574573586E-01, 2.6194768167E+00, 1.0458609801E-03, 1.0395923743E-03, 3.2301271684E-01],
	[7.8650000000E+03, 1.8586270238E-01, 2.6185932770E+00, 1.0476244611E-03, 1.0413382958E-03, 3.2320710520E-01],
	[7.8700000000E+03, 1.8597966814E-01, 2.6177105965E+00, 1.0493897921E-03, 1.0430860288E-03, 3.2340144153E-01],
	[7.8750000000E+03, 1.8609663315E-01, 2.6168287738E+00, 1.0511569738E-03, 1.0448355742E-03, 3.2359572585E-01],
	[7.8800000000E+03, 1.8621359742E-01, 2.6159478077E+00, 1.0529260069E-03, 1.0465869326E-03, 3.2378995816E-01],
	[7.8850000000E+03, 1.8633056093E-01, 2.6150676966E+00, 1.0546968922E-03, 1.0483401047E-03, 3.2398413849E-01],
	[7.8900000000E+03, 1.8644752370E-01, 2.6141884393E+00, 1.0564696305E-03, 1.0500950913E-03, 3.2417826685E-01],
	[7.8950000000E+03, 1.8656448572E-01, 2.6133100344E+00, 1.0582442225E-03, 1.0518518930E-03, 3.2437234326E-01],
	[7.9000000000E+03, 1.8668144699E-01, 2.6124324805E+00, 1.0600206691E-03, 1.0536105106E-03, 3.2456636774E-01],
	[7.9050000000E+03, 1.8679840752E-01, 2.6115557762E+00, 1.0617989709E-03, 1.0553709447E-03, 3.2476034030E-01],
	[7.9100000000E+03, 1.8691536729E-01, 2.6106799202E+00, 1.0635791287E-03, 1.0571331960E-03, 3.2495426095E-01],
	[7.9150000000E+03, 1.8703232633E-01, 2.6098049111E+00, 1.0653611434E-03, 1.0588972653E-03, 3.2514812973E-01],
	[7.9200000000E+03, 1.8714928461E-01, 2.6089307476E+00, 1.0671450156E-03, 1.0606631533E-03, 3.2534194663E-01],
	[7.9250000000E+03, 1.8726624216E-01, 2.6080574284E+00, 1.0689307461E-03, 1.0624308606E-03, 3.2553571168E-01],
	[7.9300000000E+03, 1.8738319896E-01, 2.6071849520E+00, 1.0707183356E-03, 1.0642003880E-03, 3.2572942489E-01],
	[7.9350000000E+03, 1.8750015501E-01, 2.6063133171E+00, 1.0725077850E-03, 1.0659717361E-03, 3.2592308629E-01],
	[7.9400000000E+03, 1.8761711032E-01, 2.6054425224E+00, 1.0742990950E-03, 1.0677449057E-03, 3.2611669589E-01],
	[7.9450000000E+03, 1.8773406489E-01, 2.6045725666E+00, 1.0760922664E-03, 1.0695198974E-03, 3.2631025370E-01],
	[7.9500000000E+03, 1.8785163898E-01, 2.6037110617E+00, 1.0778872999E-03, 1.0712967334E-03, 3.2650375975E-01],
	[7.9550000000E+03, 1.8796924114E-01, 2.6028507316E+00, 1.0796841963E-03, 1.0730753941E-03, 3.2669721405E-01],
	[7.9600000000E+03, 1.8808684295E-01, 2.6019912262E+00, 1.0814829563E-03, 1.0748558791E-03, 3.2689061661E-01],
	[7.9650000000E+03, 1.8820444443E-01, 2.6011325440E+00, 1.0832835807E-03, 1.0766381892E-03, 3.2708396747E-01],
	[7.9700000000E+03, 1.8832204557E-01, 2.6002746839E+00, 1.0850860702E-03, 1.0784223251E-03, 3.2727726662E-01],
	[7.9750000000E+03, 1.8843964637E-01, 2.5994176443E+00, 1.0868904257E-03, 1.0802082874E-03, 3.2747051410E-01],
	[7.9800000000E+03, 1.8855724683E-01, 2.5985614242E+00, 1.0886966479E-03, 1.0819960768E-03, 3.2766370991E-01],
	[7.9850000000E+03, 1.8867484695E-01, 2.5977060221E+00, 1.0905047375E-03, 1.0837856942E-03, 3.2785685408E-01],
	[7.9900000000E+03, 1.8879244674E-01, 2.5968514368E+00, 1.0923146953E-03, 1.0855771401E-03, 3.2804994663E-01],
	[7.9950000000E+03, 1.8891004618E-01, 2.5959976671E+00, 1.0941265221E-03, 1.0873704152E-03, 3.2824298757E-01],
	[8.0000000000E+03, 1.8902764529E-01, 2.5951447115E+00, 1.0959402186E-03, 1.0891655203E-03, 3.2843597691E-01],
	[8.0050000000E+03, 1.8914524406E-01, 2.5942925688E+00, 1.0977990669E-03, 1.0910052032E-03, 3.2862891469E-01],
	[8.0100000000E+03, 1.8926284249E-01, 2.5934412378E+00, 1.0996599043E-03, 1.0928468329E-03, 3.2882180091E-01],
	[8.0150000000E+03, 1.8938044058E-01, 2.5925907171E+00, 1.1015227318E-03, 1.0946904100E-03, 3.2901463560E-01],
	[8.0200000000E+03, 1.8949803834E-01, 2.5917410055E+00, 1.1033875503E-03, 1.0965359353E-03, 3.2920741877E-01],
	[8.0250000000E+03, 1.8961563575E-01, 2.5908921017E+00, 1.1052543606E-03, 1.0983834098E-03, 3.2940015044E-01],
	[8.0300000000E+03, 1.8973323284E-01, 2.5900440045E+00, 1.1071231636E-03, 1.1002328342E-03, 3.2959283064E-01],
	[8.0350000000E+03, 1.8985082958E-01, 2.5891967125E+00, 1.1089939603E-03, 1.1020842094E-03, 3.2978545937E-01],
	[8.0400000000E+03, 1.8996842599E-01, 2.5883502246E+00, 1.1108667514E-03, 1.1039375361E-03, 3.2997803665E-01],
	[8.0450000000E+03, 1.9008602206E-01, 2.5875045393E+00, 1.1127415379E-03, 1.1057928151E-03, 3.3017056252E-01],
	[8.0500000000E+03, 1.9020361780E-01, 2.5866596556E+00, 1.1146183207E-03, 1.1076500473E-03, 3.3036303698E-01],
	[8.0550000000E+03, 1.9032121320E-01, 2.5858155721E+00, 1.1164971007E-03, 1.1095092335E-03, 3.3055546005E-01],
	[8.0600000000E+03, 1.9043880826E-01, 2.5849722876E+00, 1.1183778786E-03, 1.1113703746E-03, 3.3074783175E-01],
	[8.0650000000E+03, 1.9055640299E-01, 2.5841298008E+00, 1.1202606555E-03, 1.1132334712E-03, 3.3094015211E-01],
	[8.0700000000E+03, 1.9067399738E-01, 2.5832881104E+00, 1.1221454322E-03, 1.1150985243E-03, 3.3113242114E-01],
	[8.0750000000E+03, 1.9079183470E-01, 2.5824501163E+00, 1.1240322095E-03, 1.1169655435E-03, 3.3132463885E-01],
	[8.0800000000E+03, 1.9091007784E-01, 2.5816177496E+00, 1.1259209884E-03, 1.1188345356E-03, 3.3151680528E-01],
	[8.0850000000E+03, 1.9102832104E-01, 2.5807861658E+00, 1.1278117698E-03, 1.1207054868E-03, 3.3170892043E-01],
	[8.0900000000E+03, 1.9114656431E-01, 2.5799553638E+00, 1.1297045545E-03, 1.1225783977E-03, 3.3190098433E-01],
	[8.0950000000E+03, 1.9126480764E-01, 2.5791253423E+00, 1.1315993434E-03, 1.1244532693E-03, 3.3209299700E-01],
	[8.1000000000E+03, 1.9138305103E-01, 2.5782961001E+00, 1.1334961374E-03, 1.1263301023E-03, 3.3228495846E-01],
	[8.1050000000E+03, 1.9150129450E-01, 2.5774676360E+00, 1.1353949374E-03, 1.1282088975E-03, 3.3247686872E-01],
	[8.1100000000E+03, 1.9161953802E-01, 2.5766399488E+00, 1.1372957442E-03, 1.1300896558E-03, 3.3266872781E-01],
	[8.1150000000E+03, 1.9173778162E-01, 2.5758130372E+00, 1.1391985588E-03, 1.1319723779E-03, 3.3286053574E-01],
	[8.1200000000E+03, 1.9185602528E-01, 2.5749869002E+00, 1.1411033820E-03, 1.1338570648E-03, 3.3305229254E-01],
	[8.1250000000E+03, 1.9197426900E-01, 2.5741615364E+00, 1.1430102146E-03, 1.1357437171E-03, 3.3324399822E-01],
	[8.1300000000E+03, 1.9209251279E-01, 2.5733369446E+00, 1.1449190577E-03, 1.1376323357E-03, 3.3343565281E-01],
	[8.1350000000E+03, 1.9221075664E-01, 2.5725131238E+00, 1.1468299121E-03, 1.1395229214E-03, 3.3362725632E-01],
	[8.1400000000E+03, 1.9232900056E-01, 2.5716900726E+00, 1.1487427785E-03, 1.1414154750E-03, 3.3381880878E-01],
	[8.1450000000E+03, 1.9244724454E-01, 2.5708677899E+00, 1.1506576581E-03, 1.1433099974E-03, 3.3401031021E-01],
	[8.1500000000E+03, 1.9256548859E-01, 2.5700462745E+00, 1.1525745515E-03, 1.1452064893E-03, 3.3420176062E-01],
	[8.1550000000E+03, 1.9268373271E-01, 2.5692255252E+00, 1.1544934597E-03, 1.1471049515E-03, 3.3439316003E-01],
	[8.1600000000E+03, 1.9280197688E-01, 2.5684055409E+00, 1.1564143836E-03, 1.1490053849E-03, 3.3458450841E-01],
	[8.1650000000E+03, 1.9292022113E-01, 2.5675863203E+00, 1.1583373240E-03, 1.1509077903E-03, 3.3477580579E-01],
	[8.1700000000E+03, 1.9303846544E-01, 2.5667678623E+00, 1.1602622818E-03, 1.1528121685E-03, 3.3496705215E-01],
	[8.1750000000E+03, 1.9315670981E-01, 2.5659501657E+00, 1.1621892580E-03, 1.1547185202E-03, 3.3515824752E-01],
	[8.1800000000E+03, 1.9327495425E-01, 2.5651332293E+00, 1.1641182534E-03, 1.1566268463E-03, 3.3534939189E-01],
	[8.1850000000E+03, 1.9339319875E-01, 2.5643170519E+00, 1.1660492688E-03, 1.1585371477E-03, 3.3554048527E-01],
	[8.1900000000E+03, 1.9351144332E-01, 2.5635016324E+00, 1.1679823052E-03, 1.1604494250E-03, 3.3573152768E-01],
	[8.1950000000E+03, 1.9362968795E-01, 2.5626869697E+00, 1.1699173633E-03, 1.1623636792E-03, 3.3592251911E-01],
	[8.2000000000E+03, 1.9374793264E-01, 2.5618730625E+00, 1.1718544443E-03, 1.1642799110E-03, 3.3611345958E-01],
	[8.2050000000E+03, 1.9386642573E-01, 2.5610627811E+00, 1.1737935487E-03, 1.1661981308E-03, 3.3630434909E-01],
	[8.2100000000E+03, 1.9398532179E-01, 2.5602579021E+00, 1.1757346777E-03, 1.1681183455E-03, 3.3649518764E-01],
	[8.2150000000E+03, 1.9410421831E-01, 2.5594537658E+00, 1.1776778320E-03, 1.1700405404E-03, 3.3668597526E-01],
	[8.2200000000E+03, 1.9422311530E-01, 2.5586503711E+00, 1.1796230125E-03, 1.1719647162E-03, 3.3687671194E-01],
	[8.2250000000E+03, 1.9434201275E-01, 2.5578477170E+00, 1.1815702201E-03, 1.1738908738E-03, 3.3706739770E-01],
	[8.2300000000E+03, 1.9446091067E-01, 2.5570458022E+00, 1.1835194557E-03, 1.1758190141E-03, 3.3725803253E-01],
	[8.2350000000E+03, 1.9457980904E-01, 2.5562446256E+00, 1.1854707202E-03, 1.1777491377E-03, 3.3744861646E-01],
	[8.2400000000E+03, 1.9469870788E-01, 2.5554441861E+00, 1.1874240144E-03, 1.1796812455E-03, 3.3763914948E-01],
	[8.2450000000E+03, 1.9481760718E-01, 2.5546444826E+00, 1.1893793391E-03, 1.1816153384E-03, 3.3782963160E-01],
	[8.2500000000E+03, 1.9493650695E-01, 2.5538455139E+00, 1.1913366954E-03, 1.1835514170E-03, 3.3802006284E-01],
	[8.2550000000E+03, 1.9505540717E-01, 2.5530472789E+00, 1.1932960841E-03, 1.1854894823E-03, 3.3821044320E-01],
	[8.2600000000E+03, 1.9517430785E-01, 2.5522497766E+00, 1.1952575060E-03, 1.1874295350E-03, 3.3840077269E-01],
	[8.2650000000E+03, 1.9529320900E-01, 2.5514530058E+00, 1.1972209620E-03, 1.1893715760E-03, 3.3859105131E-01],
	[8.2700000000E+03, 1.9541211061E-01, 2.5506569653E+00, 1.1991864530E-03, 1.1913156060E-03, 3.3878127908E-01],
	[8.2750000000E+03, 1.9553101268E-01, 2.5498616541E+00, 1.2011539799E-03, 1.1932616259E-03, 3.3897145601E-01],
	[8.2800000000E+03, 1.9564991520E-01, 2.5490670711E+00, 1.2031235436E-03, 1.1952096364E-03, 3.3916158210E-01],
	[8.2850000000E+03, 1.9576881819E-01, 2.5482732151E+00, 1.2050951449E-03, 1.1971596383E-03, 3.3935165736E-01],
	[8.2900000000E+03, 1.9588772164E-01, 2.5474800851E+00, 1.2070687846E-03, 1.1991116325E-03, 3.3954168180E-01],
	[8.2950000000E+03, 1.9600662554E-01, 2.5466876800E+00, 1.2090444638E-03, 1.2010656198E-03, 3.3973165543E-01],
	[8.3000000000E+03, 1.9612552991E-01, 2.5458959986E+00, 1.2110221832E-03, 1.2030216010E-03, 3.3992157825E-01],
	[8.3050000000E+03, 1.9624443473E-01, 2.5451050398E+00, 1.2130019438E-03, 1.2049795768E-03, 3.4011145029E-01],
	[8.3100000000E+03, 1.9636334002E-01, 2.5443148027E+00, 1.2149837464E-03, 1.2069395481E-03, 3.4030127154E-01],
	[8.3150000000E+03, 1.9648224576E-01, 2.5435252859E+00, 1.2169675918E-03, 1.2089015156E-03, 3.4049104202E-01],
	[8.3200000000E+03, 1.9660115196E-01, 2.5427364886E+00, 1.2189534810E-03, 1.2108654803E-03, 3.4068076173E-01],
	[8.3250000000E+03, 1.9672005861E-01, 2.5419484096E+00, 1.2209414149E-03, 1.2128314428E-03, 3.4087043069E-01],
	[8.3300000000E+03, 1.9683896573E-01, 2.5411610478E+00, 1.2229313942E-03, 1.2147994040E-03, 3.4106004890E-01],
	[8.3350000000E+03, 1.9695787330E-01, 2.5403744021E+00, 1.2249234200E-03, 1.2167693647E-03, 3.4124961637E-01],
	[8.3400000000E+03, 1.9707741456E-01, 2.5395955669E+00, 1.2269174930E-03, 1.2187413516E-03, 3.4143913312E-01],
	[8.3450000000E+03, 1.9719697643E-01, 2.5388176582E+00, 1.2289136141E-03, 1.2207153405E-03, 3.4162859914E-01],
	[8.3500000000E+03, 1.9731653916E-01, 2.5380404535E+00, 1.2309117843E-03, 1.2226913313E-03, 3.4181801446E-01],
	[8.3550000000E+03, 1.9743610273E-01, 2.5372639518E+00, 1.2329120043E-03, 1.2246693251E-03, 3.4200737908E-01],
	[8.3600000000E+03, 1.9755566716E-01, 2.5364881520E+00, 1.2349142751E-03, 1.2266493224E-03, 3.4219669302E-01],
	[8.3650000000E+03, 1.9767523245E-01, 2.5357130530E+00, 1.2369185976E-03, 1.2286313242E-03, 3.4238595627E-01],
	[8.3700000000E+03, 1.9779479858E-01, 2.5349386539E+00, 1.2389249725E-03, 1.2306153311E-03, 3.4257516885E-01],
	[8.3750000000E+03, 1.9791436557E-01, 2.5341649535E+00, 1.2409334008E-03, 1.2326013441E-03, 3.4276433078E-01],
	[8.3800000000E+03, 1.9803393341E-01, 2.5333919508E+00, 1.2429438834E-03, 1.2345893640E-03, 3.4295344206E-01],
	[8.3850000000E+03, 1.9815350210E-01, 2.5326196448E+00, 1.2449564211E-03, 1.2365793914E-03, 3.4314250270E-01],
	[8.3900000000E+03, 1.9827307164E-01, 2.5318480344E+00, 1.2469710148E-03, 1.2385714273E-03, 3.4333151271E-01],
	[8.3950000000E+03, 1.9839264204E-01, 2.5310771186E+00, 1.2489876654E-03, 1.2405654725E-03, 3.4352047210E-01],
	[8.4000000000E+03, 1.9851221328E-01, 2.5303068963E+00, 1.2510063738E-03, 1.2425615276E-03, 3.4370938089E-01],
	[8.4050000000E+03, 1.9863178537E-01, 2.5295373665E+00, 1.2530271407E-03, 1.2445595936E-03, 3.4389823908E-01],
	[8.4100000000E+03, 1.9875135831E-01, 2.5287685282E+00, 1.2550499672E-03, 1.2465596712E-03, 3.4408704668E-01],
	[8.4150000000E+03, 1.9887093209E-01, 2.5280003803E+00, 1.2570748540E-03, 1.2485617612E-03, 3.4427580371E-01],
	[8.4200000000E+03, 1.9899050673E-01, 2.5272329218E+00, 1.2591018020E-03, 1.2505658644E-03, 3.4446451017E-01],
	[8.4250000000E+03, 1.9911008221E-01, 2.5264661517E+00, 1.2611308122E-03, 1.2525719817E-03, 3.4465316608E-01],
	[8.4300000000E+03, 1.9922965854E-01, 2.5257000690E+00, 1.2631618854E-03, 1.2545801138E-03, 3.4484177144E-01],
	[8.4350000000E+03, 1.9934923571E-01, 2.5249346726E+00, 1.2651950224E-03, 1.2565902614E-03, 3.4503032627E-01],
	[8.4400000000E+03, 1.9946881373E-01, 2.5241699615E+00, 1.2672302241E-03, 1.2586024256E-03, 3.4521883058E-01],
	[8.4450000000E+03, 1.9958839260E-01, 2.5234059347E+00, 1.2692674914E-03, 1.2606166069E-03, 3.4540728439E-01],
	[8.4500000000E+03, 1.9970797231E-01, 2.5226425912E+00, 1.2713068253E-03, 1.2626328062E-03, 3.4559568769E-01],
	[8.4550000000E+03, 1.9982755286E-01, 2.5218799299E+00, 1.2733482264E-03, 1.2646510244E-03, 3.4578404050E-01],
	[8.4600000000E+03, 1.9994713426E-01, 2.5211179499E+00, 1.2753916958E-03, 1.2666712621E-03, 3.4597234284E-01],
	[8.4650000000E+03, 2.0006671650E-01, 2.5203566501E+00, 1.2774372342E-03, 1.2686935202E-03, 3.4616059471E-01],
	[8.4700000000E+03, 2.0018638656E-01, 2.5195969752E+00, 1.2794848426E-03, 1.2707178033E-03, 3.4634879613E-01],
	[8.4750000000E+03, 2.0030662551E-01, 2.5188441470E+00, 1.2815345219E-03, 1.2727441329E-03, 3.4653694711E-01],
	[8.4800000000E+03, 2.0042686570E-01, 2.5180919875E+00, 1.2835862728E-03, 1.2747724855E-03, 3.4672504765E-01],
	[8.4850000000E+03, 2.0054710713E-01, 2.5173404958E+00, 1.2856400963E-03, 1.2768028617E-03, 3.4691309778E-01],
	[8.4900000000E+03, 2.0066734979E-01, 2.5165896709E+00, 1.2876959933E-03, 1.2788352625E-03, 3.4710109749E-01],
	[8.4950000000E+03, 2.0078759369E-01, 2.5158395118E+00, 1.2897539645E-03, 1.2808696885E-03, 3.4728904682E-01],
	[8.5000000000E+03, 2.0090783883E-01, 2.5150900175E+00, 1.2918140109E-03, 1.2829061407E-03, 3.4747694575E-01],
	[8.5050000000E+03, 2.0102808520E-01, 2.5143411870E+00, 1.2938761334E-03, 1.2849446198E-03, 3.4766479432E-01],
	[8.5100000000E+03, 2.0114833281E-01, 2.5135930194E+00, 1.2959403328E-03, 1.2869851266E-03, 3.4785259253E-01],
	[8.5150000000E+03, 2.0126858166E-01, 2.5128455137E+00, 1.2980066100E-03, 1.2890276618E-03, 3.4804034039E-01],
	[8.5200000000E+03, 2.0138883173E-01, 2.5120986689E+00, 1.3000749659E-03, 1.2910722264E-03, 3.4822803791E-01],
	[8.5250000000E+03, 2.0150908304E-01, 2.5113524840E+00, 1.3021454012E-03, 1.2931188210E-03, 3.4841568511E-01],
	[8.5300000000E+03, 2.0162933558E-01, 2.5106069581E+00, 1.3042179170E-03, 1.2951674465E-03, 3.4860328199E-01],
	[8.5350000000E+03, 2.0174958936E-01, 2.5098620902E+00, 1.3062925141E-03, 1.2972181037E-03, 3.4879082858E-01],
	[8.5400000000E+03, 2.0186984436E-01, 2.5091178793E+00, 1.3083691932E-03, 1.2992707933E-03, 3.4897832488E-01],
	[8.5450000000E+03, 2.0199010059E-01, 2.5083743244E+00, 1.3104479554E-03, 1.3013255162E-03, 3.4916577090E-01],
	[8.5500000000E+03, 2.0211035806E-01, 2.5076314247E+00, 1.3125288015E-03, 1.3033822731E-03, 3.4935316667E-01],
	[8.5550000000E+03, 2.0223061675E-01, 2.5068891792E+00, 1.3146117323E-03, 1.3054410649E-03, 3.4954051218E-01],
	[8.5600000000E+03, 2.0235087667E-01, 2.5061475868E+00, 1.3166967487E-03, 1.3075018923E-03, 3.4972780746E-01],
	[8.5650000000E+03, 2.0247113782E-01, 2.5054066466E+00, 1.3187838515E-03, 1.3095647561E-03, 3.4991505251E-01],
	[8.5700000000E+03, 2.0259140019E-01, 2.5046663578E+00, 1.3208730418E-03, 1.3116296572E-03, 3.5010224735E-01],
	[8.5750000000E+03, 2.0271166379E-01, 2.5039267192E+00, 1.3229643202E-03, 1.3136965963E-03, 3.5028939200E-01],
	[8.5800000000E+03, 2.0283192861E-01, 2.5031877301E+00, 1.3250576877E-03, 1.3157655741E-03, 3.5047648645E-01],
	[8.5850000000E+03, 2.0295219466E-01, 2.5024493894E+00, 1.3271531452E-03, 1.3178365916E-03, 3.5066353074E-01],
	[8.5900000000E+03, 2.0307246194E-01, 2.5017116961E+00, 1.3292506935E-03, 1.3199096494E-03, 3.5085052486E-01],
	[8.5950000000E+03, 2.0319273043E-01, 2.5009746494E+00, 1.3313503335E-03, 1.3219847485E-03, 3.5103746884E-01],
	[8.6000000000E+03, 2.0331300015E-01, 2.5002382483E+00, 1.3334520660E-03, 1.3240618895E-03, 3.5122436268E-01],
	[8.6050000000E+03, 2.0343327109E-01, 2.4995024919E+00, 1.3355558920E-03, 1.3261410732E-03, 3.5141120640E-01],
	[8.6100000000E+03, 2.0355411080E-01, 2.4987733575E+00, 1.3376618122E-03, 1.3282223264E-03, 3.5159800002E-01],
	[8.6150000000E+03, 2.0367504152E-01, 2.4980458005E+00, 1.3397698276E-03, 1.3303056281E-03, 3.5178474354E-01],
	[8.6200000000E+03, 2.0379597387E-01, 2.4973188772E+00, 1.3418799390E-03, 1.3323909751E-03, 3.5197143698E-01],
	[8.6250000000E+03, 2.0391690782E-01, 2.4965925869E+00, 1.3439921473E-03, 1.3344783681E-03, 3.5215808035E-01],
	[8.6300000000E+03, 2.0403784339E-01, 2.4958669284E+00, 1.3461064533E-03, 1.3365678080E-03, 3.5234467367E-01],
	[8.6350000000E+03, 2.0415878058E-01, 2.4951419011E+00, 1.3482228580E-03, 1.3386592956E-03, 3.5253121695E-01],
	[8.6400000000E+03, 2.0427971938E-01, 2.4944175038E+00, 1.3503413621E-03, 1.3407528315E-03, 3.5271771020E-01],
	[8.6450000000E+03, 2.0440065979E-01, 2.4936937358E+00, 1.3524619666E-03, 1.3428484167E-03, 3.5290415344E-01],
	[8.6500000000E+03, 2.0452160181E-01, 2.4929705961E+00, 1.3545846723E-03, 1.3449460519E-03, 3.5309054668E-01],
	[8.6550000000E+03, 2.0464254544E-01, 2.4922480838E+00, 1.3567094801E-03, 1.3470457379E-03, 3.5327688994E-01],
	[8.6600000000E+03, 2.0476349067E-01, 2.4915261979E+00, 1.3588363908E-03, 1.3491474755E-03, 3.5346318322E-01],
	[8.6650000000E+03, 2.0488443752E-01, 2.4908049377E+00, 1.3609654054E-03, 1.3512512654E-03, 3.5364942655E-01],
	[8.6700000000E+03, 2.0500538597E-01, 2.4900843021E+00, 1.3630965246E-03, 1.3533571085E-03, 3.5383561993E-01],
	[8.6750000000E+03, 2.0512633603E-01, 2.4893642904E+00, 1.3652297494E-03, 1.3554650056E-03, 3.5402176338E-01],
	[8.6800000000E+03, 2.0524728770E-01, 2.4886449015E+00, 1.3673650805E-03, 1.3575749574E-03, 3.5420785692E-01],
	[8.6850000000E+03, 2.0536824097E-01, 2.4879261346E+00, 1.3695025190E-03, 1.3596869647E-03, 3.5439390056E-01],
	[8.6900000000E+03, 2.0548919584E-01, 2.4872079888E+00, 1.3716420656E-03, 1.3618010284E-03, 3.5457989431E-01],
	[8.6950000000E+03, 2.0561015232E-01, 2.4864904632E+00, 1.3737837212E-03, 1.3639171491E-03, 3.5476583818E-01],
	[8.7000000000E+03, 2.0573111039E-01, 2.4857735569E+00, 1.3759274866E-03, 1.3660353278E-03, 3.5495173220E-01],
	[8.7050000000E+03, 2.0585207007E-01, 2.4850572690E+00, 1.3780733628E-03, 1.3681555651E-03, 3.5513757637E-01],
	[8.7100000000E+03, 2.0597303135E-01, 2.4843415986E+00, 1.3802213506E-03, 1.3702778619E-03, 3.5532337072E-01],
	[8.7150000000E+03, 2.0609399423E-01, 2.4836265449E+00, 1.3823714508E-03, 1.3724022189E-03, 3.5550911525E-01],
	[8.7200000000E+03, 2.0621495870E-01, 2.4829121070E+00, 1.3845236643E-03, 1.3745286370E-03, 3.5569481010E-01],
	[8.7250000000E+03, 2.0633592477E-01, 2.4821982839E+00, 1.3866779921E-03, 1.3766571169E-03, 3.5588045535E-01],
	[8.7300000000E+03, 2.0645689244E-01, 2.4814850748E+00, 1.3888344349E-03, 1.3787876594E-03, 3.5606605098E-01],
	[8.7350000000E+03, 2.0657786170E-01, 2.4807724788E+00, 1.3909929936E-03, 1.3809202653E-03, 3.5625159701E-01],
	[8.7400000000E+03, 2.0669883256E-01, 2.4800604951E+00, 1.3931536690E-03, 1.3830549353E-03, 3.5643709343E-01],
	[8.7450000000E+03, 2.0681990776E-01, 2.4793501727E+00, 1.3953164622E-03, 1.3851916753E-03, 3.5662254024E-01],
	[8.7500000000E+03, 2.0694154096E-01, 2.4786461399E+00, 1.3974813738E-03, 1.3873305078E-03, 3.5680793744E-01],
	[8.7550000000E+03, 2.0706317615E-01, 2.4779427090E+00, 1.3996484047E-03, 1.3894714070E-03, 3.5699328504E-01],
	[8.7600000000E+03, 2.0718481332E-01, 2.4772398792E+00, 1.4018175560E-03, 1.3916143737E-03, 3.5717858302E-01],
	[8.7650000000E+03, 2.0730645248E-01, 2.4765376497E+00, 1.4039888282E-03, 1.3937594086E-03, 3.5736383140E-01],
	[8.7700000000E+03, 2.0742809362E-01, 2.4758360195E+00, 1.4061622225E-03, 1.3959065126E-03, 3.5754903017E-01],
	[8.7750000000E+03, 2.0754973675E-01, 2.4751349878E+00, 1.4083377395E-03, 1.3980556863E-03, 3.5773417933E-01],
	[8.7800000000E+03, 2.0767138186E-01, 2.4744345537E+00, 1.4105153803E-03, 1.4002069307E-03, 3.5791927888E-01],
	[8.7850000000E+03, 2.0779302895E-01, 2.4737347165E+00, 1.4126951455E-03, 1.4023602464E-03, 3.5810432883E-01],
	[8.7900000000E+03, 2.0791467802E-01, 2.4730354752E+00, 1.4148770362E-03, 1.4045156343E-03, 3.5828932917E-01],
	[8.7950000000E+03, 2.0803632907E-01, 2.4723368291E+00, 1.4170610531E-03, 1.4066730952E-03, 3.5847427990E-01],
	[8.8000000000E+03, 2.0815798210E-01, 2.4716387772E+00, 1.4192471972E-03, 1.4088326298E-03, 3.5865918103E-01],
	[8.8050000000E+03, 2.0827963710E-01, 2.4709413188E+00, 1.4214354692E-03, 1.4109942389E-03, 3.5884403256E-01],
	[8.8100000000E+03, 2.0840129408E-01, 2.4702444530E+00, 1.4236258701E-03, 1.4131579233E-03, 3.5902883448E-01],
	[8.8150000000E+03, 2.0852295304E-01, 2.4695481789E+00, 1.4258184007E-03, 1.4153236838E-03, 3.5921358681E-01],
	[8.8200000000E+03, 2.0864461397E-01, 2.4688524957E+00, 1.4280130618E-03, 1.4174915212E-03, 3.5939828953E-01],
	[8.8250000000E+03, 2.0876627687E-01, 2.4681574026E+00, 1.4302098544E-03, 1.4196614362E-03, 3.5958294265E-01],
	[8.8300000000E+03, 2.0888794174E-01, 2.4674628987E+00, 1.4324087793E-03, 1.4218334296E-03, 3.5976754617E-01],
	[8.8350000000E+03, 2.0900960858E-01, 2.4667689833E+00, 1.4346098373E-03, 1.4240075022E-03, 3.5995210010E-01],
	[8.8400000000E+03, 2.0913127740E-01, 2.4660756554E+00, 1.4368130293E-03, 1.4261836549E-03, 3.6013660443E-01],
	[8.8450000000E+03, 2.0925294817E-01, 2.4653829143E+00, 1.4390183562E-03, 1.4283618883E-03, 3.6032105917E-01],
	[8.8500000000E+03, 2.0937462092E-01, 2.4646907591E+00, 1.4412258189E-03, 1.4305422032E-03, 3.6050546431E-01],
	[8.8550000000E+03, 2.0949629563E-01, 2.4639991890E+00, 1.4434354181E-03, 1.4327246005E-03, 3.6068981986E-01],
	[8.8600000000E+03, 2.0961797231E-01, 2.4633082032E+00, 1.4456471547E-03, 1.4349090809E-03, 3.6087412582E-01],
	[8.8650000000E+03, 2.0973965095E-01, 2.4626178008E+00, 1.4478610297E-03, 1.4370956452E-03, 3.6105838219E-01],
	[8.8700000000E+03, 2.0986133156E-01, 2.4619279810E+00, 1.4500770439E-03, 1.4392842942E-03, 3.6124258898E-01],
	[8.8750000000E+03, 2.0998301412E-01, 2.4612387431E+00, 1.4522951980E-03, 1.4414750286E-03, 3.6142674618E-01],
	[8.8800000000E+03, 2.1010469865E-01, 2.4605500861E+00, 1.4545154931E-03, 1.4436678493E-03, 3.6161085381E-01],
	[8.8850000000E+03, 2.1022638641E-01, 2.4598620219E+00, 1.4567379299E-03, 1.4458627570E-03, 3.6179491185E-01],
	[8.8900000000E+03, 2.1034873610E-01, 2.4591810707E+00, 1.4589625093E-03, 1.4480597861E-03, 3.6197892031E-01],
	[8.8950000000E+03, 2.1047108815E-01, 2.4585006908E+00, 1.4611892322E-03, 1.4502589039E-03, 3.6216287919E-01],
	[8.9000000000E+03, 2.1059344254E-01, 2.4578208813E+00, 1.4634180994E-03, 1.4524601112E-03, 3.6234678850E-01],
	[8.9050000000E+03, 2.1071579929E-01, 2.4571416414E+00, 1.4656491117E-03, 1.4546634088E-03, 3.6253064824E-01],
	[8.9100000000E+03, 2.1083815839E-01, 2.4564629703E+00, 1.4678822702E-03, 1.4568687975E-03, 3.6271445841E-01],
	[8.9150000000E+03, 2.1096051983E-01, 2.4557848672E+00, 1.4701175755E-03, 1.4590762779E-03, 3.6289821901E-01],
	[8.9200000000E+03, 2.1108288362E-01, 2.4551073314E+00, 1.4723550285E-03, 1.4612858510E-03, 3.6308193005E-01],
	[8.9250000000E+03, 2.1120524975E-01, 2.4544303621E+00, 1.4745946302E-03, 1.4634975175E-03, 3.6326559153E-01],
	[8.9300000000E+03, 2.1132761823E-01, 2.4537539584E+00, 1.4768363814E-03, 1.4657112782E-03, 3.6344920344E-01],
	[8.9350000000E+03, 2.1144998905E-01, 2.4530781196E+00, 1.4790802829E-03, 1.4679271338E-03, 3.6363276580E-01],
	[8.9400000000E+03, 2.1157236221E-01, 2.4524028448E+00, 1.4813263355E-03, 1.4701450852E-03, 3.6381627861E-01],
	[8.9450000000E+03, 2.1169473771E-01, 2.4517281334E+00, 1.4835745402E-03, 1.4723651330E-03, 3.6399974186E-01],
	[8.9500000000E+03, 2.1181711555E-01, 2.4510539845E+00, 1.4858248979E-03, 1.4745872781E-03, 3.6418315557E-01],
	[8.9550000000E+03, 2.1193949573E-01, 2.4503803973E+00, 1.4880774092E-03, 1.4768115213E-03, 3.6436651973E-01],
	[8.9600000000E+03, 2.1206187824E-01, 2.4497073710E+00, 1.4903320752E-03, 1.4790378633E-03, 3.6454983435E-01],
	[8.9650000000E+03, 2.1218426309E-01, 2.4490349049E+00, 1.4925888967E-03, 1.4812663050E-03, 3.6473309942E-01],
	[8.9700000000E+03, 2.1230665027E-01, 2.4483629982E+00, 1.4948478745E-03, 1.4834968470E-03, 3.6491631497E-01],
	[8.9750000000E+03, 2.1242903978E-01, 2.4476916501E+00, 1.4971090095E-03, 1.4857294902E-03, 3.6509948098E-01],
	[8.9800000000E+03, 2.1255143162E-01, 2.4470208599E+00, 1.4993723025E-03, 1.4879642353E-03, 3.6528259746E-01],
	[8.9850000000E+03, 2.1267382580E-01, 2.4463506267E+00, 1.5016377544E-03, 1.4902010832E-03, 3.6546566441E-01],
	[8.9900000000E+03, 2.1279622230E-01, 2.4456809498E+00, 1.5039053661E-03, 1.4924400345E-03, 3.6564868184E-01],
	[8.9950000000E+03, 2.1291862113E-01, 2.4450118285E+00, 1.5061751384E-03, 1.4946810901E-03, 3.6583164975E-01],
	[9.0000000000E+03, 2.1304102228E-01, 2.4443432618E+00, 1.5084470722E-03, 1.4969242508E-03, 3.6601456815E-01],
	[9.0050000000E+03, 2.1316342576E-01, 2.4436752492E+00, 1.5107286304E-03, 1.4991768657E-03, 3.6619743703E-01],
	[9.0100000000E+03, 2.1328583157E-01, 2.4430077898E+00, 1.5130123703E-03, 1.5014316051E-03, 3.6638025641E-01],
	[9.0150000000E+03, 2.1340823969E-01, 2.4423408828E+00, 1.5152982925E-03, 1.5036884698E-03, 3.6656302628E-01],
	[9.0200000000E+03, 2.1353065014E-01, 2.4416745276E+00, 1.5175863981E-03, 1.5059474605E-03, 3.6674574665E-01],
	[9.0250000000E+03, 2.1365306291E-01, 2.4410087232E+00, 1.5198766878E-03, 1.5082085781E-03, 3.6692841752E-01],
	[9.0300000000E+03, 2.1377574006E-01, 2.4403459826E+00, 1.5221691625E-03, 1.5104718373E-03, 3.6711103890E-01],
	[9.0350000000E+03, 2.1389882176E-01, 2.4396876417E+00, 1.5244638232E-03, 1.5127372466E-03, 3.6729361079E-01],
	[9.0400000000E+03, 2.1402190617E-01, 2.4390298425E+00, 1.5267606707E-03, 1.5150047852E-03, 3.6747613320E-01],
	[9.0450000000E+03, 2.1414499329E-01, 2.4383725842E+00, 1.5290597059E-03, 1.5172744540E-03, 3.6765860612E-01],
	[9.0500000000E+03, 2.1426808312E-01, 2.4377158661E+00, 1.5313609296E-03, 1.5195462537E-03, 3.6784102957E-01],
	[9.0550000000E+03, 2.1439117565E-01, 2.4370596874E+00, 1.5336643427E-03, 1.5218201852E-03, 3.6802340354E-01],
	[9.0600000000E+03, 2.1451427088E-01, 2.4364040475E+00, 1.5359699461E-03, 1.5240962492E-03, 3.6820572805E-01],
	[9.0650000000E+03, 2.1463736883E-01, 2.4357489455E+00, 1.5382777406E-03, 1.5263744465E-03, 3.6838800309E-01],
	[9.0700000000E+03, 2.1476046947E-01, 2.4350943808E+00, 1.5405877272E-03, 1.5286547779E-03, 3.6857022868E-01],
	[9.0750000000E+03, 2.1488357281E-01, 2.4344403525E+00, 1.5428999066E-03, 1.5309372442E-03, 3.6875240481E-01],
	[9.0800000000E+03, 2.1500667885E-01, 2.4337868601E+00, 1.5452142799E-03, 1.5332218462E-03, 3.6893453148E-01],
	[9.0850000000E+03, 2.1512978759E-01, 2.4331339026E+00, 1.5475308478E-03, 1.5355085846E-03, 3.6911660872E-01],
	[9.0900000000E+03, 2.1525289903E-01, 2.4324814795E+00, 1.5498496112E-03, 1.5377974603E-03, 3.6929863651E-01],
	[9.0950000000E+03, 2.1537601316E-01, 2.4318295899E+00, 1.5521705710E-03, 1.5400884740E-03, 3.6948061486E-01],
	[9.1000000000E+03, 2.1549912999E-01, 2.4311782332E+00, 1.5544937280E-03, 1.5423816266E-03, 3.6966254379E-01],
	[9.1050000000E+03, 2.1562224950E-01, 2.4305274086E+00, 1.5568190832E-03, 1.5446769187E-03, 3.6984442329E-01],
	[9.1100000000E+03, 2.1574537171E-01, 2.4298771153E+00, 1.5591466374E-03, 1.5469743513E-03, 3.7002625336E-01],
	[9.1150000000E+03, 2.1586849661E-01, 2.4292273527E+00, 1.5614763914E-03, 1.5492739251E-03, 3.7020803402E-01],
	[9.1200000000E+03, 2.1599162419E-01, 2.4285781201E+00, 1.5638083462E-03, 1.5515756408E-03, 3.7038976527E-01],
	[9.1250000000E+03, 2.1611475446E-01, 2.4279294167E+00, 1.5661425026E-03, 1.5538794993E-03, 3.7057144711E-01],
	[9.1300000000E+03, 2.1623788742E-01, 2.4272812417E+00, 1.5684788615E-03, 1.5561855014E-03, 3.7075307956E-01],
	[9.1350000000E+03, 2.1636102306E-01, 2.4266335945E+00, 1.5708174237E-03, 1.5584936478E-03, 3.7093466260E-01],
	[9.1400000000E+03, 2.1648416138E-01, 2.4259864744E+00, 1.5731581902E-03, 1.5608039394E-03, 3.7111619625E-01],
	[9.1450000000E+03, 2.1660730239E-01, 2.4253398806E+00, 1.5755011618E-03, 1.5631163768E-03, 3.7129768052E-01],
	[9.1500000000E+03, 2.1673044607E-01, 2.4246938125E+00, 1.5778463393E-03, 1.5654309610E-03, 3.7147911541E-01],
	[9.1550000000E+03, 2.1685359243E-01, 2.4240482692E+00, 1.5801937236E-03, 1.5677476926E-03, 3.7166050093E-01],
	[9.1600000000E+03, 2.1697674146E-01, 2.4234032501E+00, 1.5825433157E-03, 1.5700665725E-03, 3.7184183707E-01],
	[9.1650000000E+03, 2.1709989318E-01, 2.4227587546E+00, 1.5848951163E-03, 1.5723876014E-03, 3.7202312386E-01],
	[9.1700000000E+03, 2.1722304756E-01, 2.4221147817E+00, 1.5872491264E-03, 1.5747107802E-03, 3.7220436128E-01],
	[9.1750000000E+03, 2.1734642314E-01, 2.4214733551E+00, 1.5896053468E-03, 1.5770361220E-03, 3.7238554936E-01],
	[9.1800000000E+03, 2.1747025162E-01, 2.4208366134E+00, 1.5919637784E-03, 1.5793636407E-03, 3.7256668808E-01],
	[9.1850000000E+03, 2.1759408317E-01, 2.4202003857E+00, 1.5943244220E-03, 1.5816933118E-03, 3.7274777747E-01],
	[9.1900000000E+03, 2.1771791779E-01, 2.4195646714E+00, 1.5966872785E-03, 1.5840251361E-03, 3.7292881752E-01],
	[9.1950000000E+03, 2.1784175546E-01, 2.4189294696E+00, 1.5990523488E-03, 1.5863591142E-03, 3.7310980825E-01],
	[9.2000000000E+03, 2.1796559619E-01, 2.4182947798E+00, 1.6014196338E-03, 1.5886952471E-03, 3.7329074965E-01],
	[9.2050000000E+03, 2.1808943999E-01, 2.4176606013E+00, 1.6037891343E-03, 1.5910335355E-03, 3.7347164173E-01],
	[9.2100000000E+03, 2.1821328684E-01, 2.4170269333E+00, 1.6061608512E-03, 1.5933739801E-03, 3.7365248451E-01],
	[9.2150000000E+03, 2.1833713674E-01, 2.4163937751E+00, 1.6085347854E-03, 1.5957165818E-03, 3.7383327798E-01],
	[9.2200000000E+03, 2.1846098970E-01, 2.4157611262E+00, 1.6109109376E-03, 1.5980613414E-03, 3.7401402215E-01],
	[9.2250000000E+03, 2.1858484571E-01, 2.4151289857E+00, 1.6132893089E-03, 1.6004082596E-03, 3.7419471703E-01],
	[9.2300000000E+03, 2.1870870477E-01, 2.4144973530E+00, 1.6156699001E-03, 1.6027573371E-03, 3.7437536263E-01],
	[9.2350000000E+03, 2.1883256687E-01, 2.4138662275E+00, 1.6180527120E-03, 1.6051085749E-03, 3.7455595895E-01],
	[9.2400000000E+03, 2.1895643203E-01, 2.4132356084E+00, 1.6204377454E-03, 1.6074619737E-03, 3.7473650599E-01],
	[9.2450000000E+03, 2.1908030023E-01, 2.4126054951E+00, 1.6228250014E-03, 1.6098175342E-03, 3.7491700377E-01],
	[9.2500000000E+03, 2.1920417148E-01, 2.4119758869E+00, 1.6252144807E-03, 1.6121752572E-03, 3.7509745229E-01],
	[9.2550000000E+03, 2.1932804577E-01, 2.4113467831E+00, 1.6276061841E-03, 1.6145351436E-03, 3.7527785156E-01],
	[9.2600000000E+03, 2.1945192309E-01, 2.4107181830E+00, 1.6300001127E-03, 1.6168971941E-03, 3.7545820158E-01],
	[9.2650000000E+03, 2.1957580346E-01, 2.4100900860E+00, 1.6323962672E-03, 1.6192614094E-03, 3.7563850236E-01],
	[9.2700000000E+03, 2.1969968687E-01, 2.4094624913E+00, 1.6347946485E-03, 1.6216277904E-03, 3.7581875391E-01],
	[9.2750000000E+03, 2.1982357331E-01, 2.4088353984E+00, 1.6371952574E-03, 1.6239963379E-03, 3.7599895623E-01],
	[9.2800000000E+03, 2.1994746279E-01, 2.4082088065E+00, 1.6395980949E-03, 1.6263670526E-03, 3.7617910934E-01],
	[9.2850000000E+03, 2.2007135530E-01, 2.4075827150E+00, 1.6420031618E-03, 1.6287399353E-03, 3.7635921323E-01],
	[9.2900000000E+03, 2.2019525084E-01, 2.4069571232E+00, 1.6444104590E-03, 1.6311149867E-03, 3.7653926792E-01],
	[9.2950000000E+03, 2.2031914941E-01, 2.4063320304E+00, 1.6468199873E-03, 1.6334922078E-03, 3.7671927341E-01],
	[9.3000000000E+03, 2.2044305101E-01, 2.4057074360E+00, 1.6492317476E-03, 1.6358715992E-03, 3.7689922971E-01],
	[9.3050000000E+03, 2.2056695564E-01, 2.4050833393E+00, 1.6516457408E-03, 1.6382531617E-03, 3.7707913683E-01],
	[9.3100000000E+03, 2.2069086329E-01, 2.4044597397E+00, 1.6540619677E-03, 1.6406368961E-03, 3.7725899477E-01],
	[9.3150000000E+03, 2.2081477397E-01, 2.4038366364E+00, 1.6564804292E-03, 1.6430228032E-03, 3.7743880354E-01],
	[9.3200000000E+03, 2.2093868767E-01, 2.4032140288E+00, 1.6589011262E-03, 1.6454108838E-03, 3.7761856315E-01],
	[9.3250000000E+03, 2.2106313711E-01, 2.4025966780E+00, 1.6613240595E-03, 1.6478011704E-03, 3.7779827360E-01],
	[9.3300000000E+03, 2.2118773055E-01, 2.4019810729E+00, 1.6637492300E-03, 1.6501936407E-03, 3.7797793491E-01],
	[9.3350000000E+03, 2.2131232741E-01, 2.4013659553E+00, 1.6661766385E-03, 1.6525882869E-03, 3.7815754708E-01],
	[9.3400000000E+03, 2.2143692767E-01, 2.4007513244E+00, 1.6686062860E-03, 1.6549851098E-03, 3.7833711012E-01],
	[9.3450000000E+03, 2.2156153135E-01, 2.4001371797E+00, 1.6710381733E-03, 1.6573841103E-03, 3.7851662403E-01],
	[9.3500000000E+03, 2.2168613844E-01, 2.3995235205E+00, 1.6734723012E-03, 1.6597852891E-03, 3.7869608883E-01],
	[9.3550000000E+03, 2.2181074893E-01, 2.3989103461E+00, 1.6759086706E-03, 1.6621886470E-03, 3.7887550452E-01],
	[9.3600000000E+03, 2.2193536282E-01, 2.3982976559E+00, 1.6783472824E-03, 1.6645941848E-03, 3.7905487110E-01],
	[9.3650000000E+03, 2.2205998012E-01, 2.3976854492E+00, 1.6807881375E-03, 1.6670019031E-03, 3.7923418859E-01],
	[9.3700000000E+03, 2.2218460082E-01, 2.3970737255E+00, 1.6832312367E-03, 1.6694118029E-03, 3.7941345700E-01],
	[9.3750000000E+03, 2.2230922492E-01, 2.3964624841E+00, 1.6856765808E-03, 1.6718238849E-03, 3.7959267633E-01],
	[9.3800000000E+03, 2.2243385242E-01, 2.3958517243E+00, 1.6881241708E-03, 1.6742381499E-03, 3.7977184659E-01],
	[9.3850000000E+03, 2.2255848331E-01, 2.3952414455E+00, 1.6905740075E-03, 1.6766545986E-03, 3.7995096779E-01],
	[9.3900000000E+03, 2.2268311760E-01, 2.3946316471E+00, 1.6930260918E-03, 1.6790732319E-03, 3.8013003993E-01],
	[9.3950000000E+03, 2.2280775528E-01, 2.3940223285E+00, 1.6954804245E-03, 1.6814940504E-03, 3.8030906303E-01],
	[9.4000000000E+03, 2.2293239635E-01, 2.3934134890E+00, 1.6979370065E-03, 1.6839170551E-03, 3.8048803710E-01],
	[9.4050000000E+03, 2.2305704081E-01, 2.3928051279E+00, 1.7003958386E-03, 1.6863422466E-03, 3.8066696213E-01],
	[9.4100000000E+03, 2.2318168866E-01, 2.3921972447E+00, 1.7028569218E-03, 1.6887696257E-03, 3.8084583814E-01],
	[9.4150000000E+03, 2.2330633989E-01, 2.3915898387E+00, 1.7053202569E-03, 1.6911991932E-03, 3.8102466514E-01],
	[9.4200000000E+03, 2.2343099451E-01, 2.3909829093E+00, 1.7077858447E-03, 1.6936309499E-03, 3.8120344313E-01],
	[9.4250000000E+03, 2.2355565251E-01, 2.3903764559E+00, 1.7102536861E-03, 1.6960648965E-03, 3.8138217213E-01],
	[9.4300000000E+03, 2.2368031389E-01, 2.3897704778E+00, 1.7127237819E-03, 1.6985010339E-03, 3.8156085214E-01],
	[9.4350000000E+03, 2.2380497865E-01, 2.3891649744E+00, 1.7151961332E-03, 1.7009393628E-03, 3.8173948317E-01],
	[9.4400000000E+03, 2.2392964679E-01, 2.3885599451E+00, 1.7176707406E-03, 1.7033798840E-03, 3.8191806524E-01],
	[9.4450000000E+03, 2.2405431830E-01, 2.3879553893E+00, 1.7201476050E-03, 1.7058225982E-03, 3.8209659834E-01],
	[9.4500000000E+03, 2.2417899318E-01, 2.3873513064E+00, 1.7226267274E-03, 1.7082675063E-03, 3.8227508248E-01],
	[9.4550000000E+03, 2.2430367144E-01, 2.3867476956E+00, 1.7251081086E-03, 1.7107146089E-03, 3.8245351768E-01],
	[9.4600000000E+03, 2.2442835307E-01, 2.3861445565E+00, 1.7275917494E-03, 1.7131639070E-03, 3.8263190395E-01],
	[9.4650000000E+03, 2.2455303807E-01, 2.3855418884E+00, 1.7300776508E-03, 1.7156154012E-03, 3.8281024129E-01],
	[9.4700000000E+03, 2.2467772643E-01, 2.3849396906E+00, 1.7325658135E-03, 1.7180690923E-03, 3.8298852971E-01],
	[9.4750000000E+03, 2.2480294709E-01, 2.3843425267E+00, 1.7350562384E-03, 1.7205250144E-03, 3.8316676922E-01],
	[9.4800000000E+03, 2.2492832071E-01, 2.3837471145E+00, 1.7375489264E-03, 1.7229831447E-03, 3.8334495983E-01],
	[9.4850000000E+03, 2.2505369809E-01, 2.3831521648E+00, 1.7400438784E-03, 1.7254434743E-03, 3.8352310156E-01],
	[9.4900000000E+03, 2.2517907923E-01, 2.3825576771E+00, 1.7425410952E-03, 1.7279060041E-03, 3.8370119439E-01],
	[9.4950000000E+03, 2.2530446413E-01, 2.3819636506E+00, 1.7450405776E-03, 1.7303707349E-03, 3.8387923836E-01],
	[9.5000000000E+03, 2.2542985277E-01, 2.3813700849E+00, 1.7475423266E-03, 1.7328376674E-03, 3.8405723346E-01],
	[9.5050000000E+03, 2.2555524517E-01, 2.3807769792E+00, 1.7500463430E-03, 1.7353068025E-03, 3.8423517970E-01],
	[9.5100000000E+03, 2.2568064132E-01, 2.3801843331E+00, 1.7525526277E-03, 1.7377781408E-03, 3.8441307710E-01],
	[9.5150000000E+03, 2.2580604121E-01, 2.3795921459E+00, 1.7550611815E-03, 1.7402516832E-03, 3.8459092567E-01],
	[9.5200000000E+03, 2.2593144485E-01, 2.3790004171E+00, 1.7575720052E-03, 1.7427274304E-03, 3.8476872540E-01],
	[9.5250000000E+03, 2.2605685223E-01, 2.3784091459E+00, 1.7600850998E-03, 1.7452053832E-03, 3.8494647632E-01],
	[9.5300000000E+03, 2.2618226336E-01, 2.3778183319E+00, 1.7626004661E-03, 1.7476855424E-03, 3.8512417843E-01],
	[9.5350000000E+03, 2.2630767822E-01, 2.3772279744E+00, 1.7651181049E-03, 1.7501679087E-03, 3.8530183174E-01],
	[9.5400000000E+03, 2.2643309682E-01, 2.3766380729E+00, 1.7676380172E-03, 1.7526524829E-03, 3.8547943626E-01],
	[9.5450000000E+03, 2.2655851916E-01, 2.3760486268E+00, 1.7701602037E-03, 1.7551392658E-03, 3.8565699200E-01],
	[9.5500000000E+03, 2.2668394523E-01, 2.3754596354E+00, 1.7726846654E-03, 1.7576282582E-03, 3.8583449897E-01],
	[9.5550000000E+03, 2.2680937503E-01, 2.3748710982E+00, 1.7752114031E-03, 1.7601194608E-03, 3.8601195718E-01],
	[9.5600000000E+03, 2.2693480856E-01, 2.3742830146E+00, 1.7777404176E-03, 1.7626128744E-03, 3.8618936664E-01],
	[9.5650000000E+03, 2.2706024583E-01, 2.3736953840E+00, 1.7802717099E-03, 1.7651084997E-03, 3.8636672736E-01],
	[9.5700000000E+03, 2.2718568681E-01, 2.3731082058E+00, 1.7828052807E-03, 1.7676063376E-03, 3.8654403934E-01],
	[9.5750000000E+03, 2.2731113153E-01, 2.3725214794E+00, 1.7853411310E-03, 1.7701063888E-03, 3.8672130261E-01],
	[9.5800000000E+03, 2.2743657997E-01, 2.3719352043E+00, 1.7878792615E-03, 1.7726086540E-03, 3.8689851716E-01],
	[9.5850000000E+03, 2.2756203212E-01, 2.3713493799E+00, 1.7904196732E-03, 1.7751131341E-03, 3.8707568301E-01],
	[9.5900000000E+03, 2.2768748800E-01, 2.3707640056E+00, 1.7929623670E-03, 1.7776198298E-03, 3.8725280017E-01],
	[9.5950000000E+03, 2.2781294760E-01, 2.3701790808E+00, 1.7955073436E-03, 1.7801287419E-03, 3.8742986864E-01],
	[9.6000000000E+03, 2.2793841091E-01, 2.3695946049E+00, 1.7980546039E-03, 1.7826398711E-03, 3.8760688844E-01],
	[9.6050000000E+03, 2.2806387793E-01, 2.3690105773E+00, 1.8006041488E-03, 1.7851532182E-03, 3.8778385958E-01],
	[9.6100000000E+03, 2.2818934867E-01, 2.3684269975E+00, 1.8031559791E-03, 1.7876687841E-03, 3.8796078207E-01],
	[9.6150000000E+03, 2.2831482312E-01, 2.3678438650E+00, 1.8057100958E-03, 1.7901865693E-03, 3.8813765592E-01],
	[9.6200000000E+03, 2.2844030127E-01, 2.3672611790E+00, 1.8082664996E-03, 1.7927065748E-03, 3.8831448114E-01],
	[9.6250000000E+03, 2.2856597816E-01, 2.3666805644E+00, 1.8108251914E-03, 1.7952288143E-03, 3.8849125773E-01],
	[9.6300000000E+03, 2.2869214697E-01, 2.3661044579E+00, 1.8133861721E-03, 1.7977533080E-03, 3.8866798571E-01],
	[9.6350000000E+03, 2.2881831987E-01, 2.3655287905E+00, 1.8159494425E-03, 1.8002800245E-03, 3.8884466509E-01],
	[9.6400000000E+03, 2.2894449688E-01, 2.3649535617E+00, 1.8185150035E-03, 1.8028089644E-03, 3.8902129588E-01],
	[9.6450000000E+03, 2.2907067798E-01, 2.3643787710E+00, 1.8210828560E-03, 1.8053401286E-03, 3.8919787810E-01],
	[9.6500000000E+03, 2.2919686317E-01, 2.3638044178E+00, 1.8236530008E-03, 1.8078735178E-03, 3.8937441174E-01],
	[9.6550000000E+03, 2.2932305245E-01, 2.3632305015E+00, 1.8262254387E-03, 1.8104091327E-03, 3.8955089682E-01],
	[9.6600000000E+03, 2.2944924583E-01, 2.3626570215E+00, 1.8288001707E-03, 1.8129469742E-03, 3.8972733335E-01],
	[9.6650000000E+03, 2.2957544329E-01, 2.3620839774E+00, 1.8313771975E-03, 1.8154870430E-03, 3.8990372135E-01],
	[9.6700000000E+03, 2.2970164484E-01, 2.3615113686E+00, 1.8339565201E-03, 1.8180293399E-03, 3.9008006082E-01],
	[9.6750000000E+03, 2.2982785047E-01, 2.3609391944E+00, 1.8365381392E-03, 1.8205738656E-03, 3.9025635177E-01],
	[9.6800000000E+03, 2.2995406019E-01, 2.3603674544E+00, 1.8391220558E-03, 1.8231206209E-03, 3.9043259422E-01],
	[9.6850000000E+03, 2.3008027398E-01, 2.3597961480E+00, 1.8417082707E-03, 1.8256696066E-03, 3.9060878817E-01],
	[9.6900000000E+03, 2.3020649186E-01, 2.3592252746E+00, 1.8442967847E-03, 1.8282208234E-03, 3.9078493363E-01],
	[9.6950000000E+03, 2.3033271381E-01, 2.3586548337E+00, 1.8468875988E-03, 1.8307742721E-03, 3.9096103062E-01],
	[9.7000000000E+03, 2.3045893983E-01, 2.3580848248E+00, 1.8494807137E-03, 1.8333299535E-03, 3.9113707915E-01],
	[9.7050000000E+03, 2.3058516993E-01, 2.3575152472E+00, 1.8520761304E-03, 1.8358878683E-03, 3.9131307923E-01],
	[9.7100000000E+03, 2.3071140409E-01, 2.3569461005E+00, 1.8546738496E-03, 1.8384480173E-03, 3.9148903087E-01],
	[9.7150000000E+03, 2.3083764233E-01, 2.3563773840E+00, 1.8572738723E-03, 1.8410104013E-03, 3.9166493408E-01],
	[9.7200000000E+03, 2.3096388463E-01, 2.3558090974E+00, 1.8598761993E-03, 1.8435750209E-03, 3.9184078886E-01],
	[9.7250000000E+03, 2.3109013099E-01, 2.3552412399E+00, 1.8624808314E-03, 1.8461418771E-03, 3.9201659524E-01],
	[9.7300000000E+03, 2.3121638142E-01, 2.3546738110E+00, 1.8650877695E-03, 1.8487109705E-03, 3.9219235323E-01],
	[9.7350000000E+03, 2.3134263591E-01, 2.3541068103E+00, 1.8676970145E-03, 1.8512823019E-03, 3.9236806282E-01],
	[9.7400000000E+03, 2.3146889446E-01, 2.3535402372E+00, 1.8703085671E-03, 1.8538558721E-03, 3.9254372405E-01],
	[9.7450000000E+03, 2.3159515706E-01, 2.3529740911E+00, 1.8729224284E-03, 1.8564316819E-03, 3.9271933690E-01],
	[9.7500000000E+03, 2.3172142372E-01, 2.3524083715E+00, 1.8755385991E-03, 1.8590097319E-03, 3.9289490131E-01],
	[9.7550000000E+03, 2.3184769443E-01, 2.3518430778E+00, 1.8781570800E-03, 1.8615900230E-03, 3.9307041727E-01],
	[9.7600000000E+03, 2.3197396919E-01, 2.3512782095E+00, 1.8807778721E-03, 1.8641725559E-03, 3.9324588478E-01],
	[9.7650000000E+03, 2.3210024800E-01, 2.3507137661E+00, 1.8834009761E-03, 1.8667573314E-03, 3.9342130384E-01],
	[9.7700000000E+03, 2.3222653085E-01, 2.3501497471E+00, 1.8860263930E-03, 1.8693443503E-03, 3.9359667444E-01],
	[9.7750000000E+03, 2.3235281775E-01, 2.3495861518E+00, 1.8886541236E-03, 1.8719336133E-03, 3.9377199657E-01],
	[9.7800000000E+03, 2.3247931528E-01, 2.3490246416E+00, 1.8912841688E-03, 1.8745251356E-03, 3.9394727025E-01],
	[9.7850000000E+03, 2.3260629848E-01, 2.3484674232E+00, 1.8939165293E-03, 1.8771189375E-03, 3.9412249547E-01],
	[9.7900000000E+03, 2.3273328612E-01, 2.3479106215E+00, 1.8965512061E-03, 1.8797149859E-03, 3.9429767222E-01],
	[9.7950000000E+03, 2.3286027819E-01, 2.3473542360E+00, 1.8991882000E-03, 1.8823132817E-03, 3.9447280051E-01],
	[9.8000000000E+03, 2.3298727470E-01, 2.3467982662E+00, 1.9018275119E-03, 1.8849138256E-03, 3.9464788034E-01],
	[9.8050000000E+03, 2.3311427564E-01, 2.3462427116E+00, 1.9044691425E-03, 1.8875166184E-03, 3.9482291169E-01],
	[9.8100000000E+03, 2.3324128100E-01, 2.3456875716E+00, 1.9071130929E-03, 1.8901216608E-03, 3.9499789458E-01],
	[9.8150000000E+03, 2.3336829079E-01, 2.3451328458E+00, 1.9097593637E-03, 1.8927289536E-03, 3.9517282899E-01],
	[9.8200000000E+03, 2.3349530501E-01, 2.3445785335E+00, 1.9124079560E-03, 1.8953384976E-03, 3.9534771494E-01],
	[9.8250000000E+03, 2.3362232364E-01, 2.3440246343E+00, 1.9150588705E-03, 1.8979502935E-03, 3.9552255241E-01],
	[9.8300000000E+03, 2.3374934670E-01, 2.3434711477E+00, 1.9177121080E-03, 1.9005643421E-03, 3.9569734141E-01],
	[9.8350000000E+03, 2.3387637417E-01, 2.3429180732E+00, 1.9203676695E-03, 1.9031806441E-03, 3.9587208193E-01],
	[9.8400000000E+03, 2.3400340606E-01, 2.3423654102E+00, 1.9230255557E-03, 1.9057992003E-03, 3.9604677398E-01],
	[9.8450000000E+03, 2.3413044237E-01, 2.3418131582E+00, 1.9256857676E-03, 1.9084200114E-03, 3.9622141755E-01],
	[9.8500000000E+03, 2.3425748308E-01, 2.3412613167E+00, 1.9283483060E-03, 1.9110430783E-03, 3.9639601264E-01],
	[9.8550000000E+03, 2.3438452821E-01, 2.3407098852E+00, 1.9310131718E-03, 1.9136684016E-03, 3.9657055926E-01],
	[9.8600000000E+03, 2.3451157774E-01, 2.3401588631E+00, 1.9336803657E-03, 1.9162959822E-03, 3.9674505740E-01],
	[9.8650000000E+03, 2.3463863167E-01, 2.3396082501E+00, 1.9363498886E-03, 1.9189258207E-03, 3.9691950706E-01],
	[9.8700000000E+03, 2.3476569001E-01, 2.3390580455E+00, 1.9390217415E-03, 1.9215579180E-03, 3.9709390824E-01],
	[9.8750000000E+03, 2.3489275275E-01, 2.3385082489E+00, 1.9416959251E-03, 1.9241922748E-03, 3.9726826093E-01],
	[9.8800000000E+03, 2.3501981989E-01, 2.3379588597E+00, 1.9443724403E-03, 1.9268288919E-03, 3.9744256515E-01],
	[9.8850000000E+03, 2.3514689143E-01, 2.3374098774E+00, 1.9470512880E-03, 1.9294677700E-03, 3.9761682088E-01],
	[9.8900000000E+03, 2.3527396736E-01, 2.3368613015E+00, 1.9497324690E-03, 1.9321089099E-03, 3.9779102814E-01],
	[9.8950000000E+03, 2.3540104768E-01, 2.3363131316E+00, 1.9524159841E-03, 1.9347523123E-03, 3.9796518691E-01],
	[9.9000000000E+03, 2.3552813240E-01, 2.3357653671E+00, 1.9551018342E-03, 1.9373979780E-03, 3.9813929719E-01],
	[9.9050000000E+03, 2.3565522150E-01, 2.3352180075E+00, 1.9577900202E-03, 1.9400459077E-03, 3.9831335900E-01],
	[9.9100000000E+03, 2.3578231499E-01, 2.3346710523E+00, 1.9604805429E-03, 1.9426961023E-03, 3.9848737232E-01],
	[9.9150000000E+03, 2.3590941287E-01, 2.3341245010E+00, 1.9631734031E-03, 1.9453485624E-03, 3.9866133715E-01],
	[9.9200000000E+03, 2.3603651512E-01, 2.3335783531E+00, 1.9658686018E-03, 1.9480032889E-03, 3.9883525351E-01],
	[9.9250000000E+03, 2.3616362176E-01, 2.3330326081E+00, 1.9685661397E-03, 1.9506602824E-03, 3.9900912138E-01],
	[9.9300000000E+03, 2.3629073278E-01, 2.3324872655E+00, 1.9712660177E-03, 1.9533195438E-03, 3.9918294077E-01],
	[9.9350000000E+03, 2.3641784817E-01, 2.3319423248E+00, 1.9739682367E-03, 1.9559810737E-03, 3.9935671167E-01],
	[9.9400000000E+03, 2.3654553376E-01, 2.3314021780E+00, 1.9766727975E-03, 1.9586449149E-03, 3.9953043409E-01],
	[9.9450000000E+03, 2.3667335152E-01, 2.3308634168E+00, 1.9793797009E-03, 1.9613110358E-03, 3.9970410803E-01],
	[9.9500000000E+03, 2.3680117406E-01, 2.3303250507E+00, 1.9820889479E-03, 1.9639794278E-03, 3.9987773348E-01],
	[9.9550000000E+03, 2.3692900135E-01, 2.3297870794E+00, 1.9848005392E-03, 1.9666500915E-03, 4.0005131045E-01],
	[9.9600000000E+03, 2.3705683342E-01, 2.3292495023E+00, 1.9875144757E-03, 1.9693230279E-03, 4.0022483894E-01],
	[9.9650000000E+03, 2.3718467024E-01, 2.3287123189E+00, 1.9902307583E-03, 1.9719982376E-03, 4.0039831895E-01],
	[9.9700000000E+03, 2.3731251183E-01, 2.3281755289E+00, 1.9929493878E-03, 1.9746757213E-03, 4.0057175047E-01],
	[9.9750000000E+03, 2.3744035817E-01, 2.3276391316E+00, 1.9956703651E-03, 1.9773554799E-03, 4.0074513352E-01],
	[9.9800000000E+03, 2.3756820926E-01, 2.3271031266E+00, 1.9983936909E-03, 1.9800375141E-03, 4.0091846808E-01],
	[9.9850000000E+03, 2.3769606511E-01, 2.3265675134E+00, 2.0011193662E-03, 1.9827218246E-03, 4.0109175417E-01],
	[9.9900000000E+03, 2.3782392571E-01, 2.3260322915E+00, 2.0038473918E-03, 1.9854084122E-03, 4.0126499177E-01],
	[9.9950000000E+03, 2.3795179106E-01, 2.3254974605E+00, 2.0065777686E-03, 1.9880972777E-03, 4.0143818090E-01],
	[1.0000000000E+04, 2.3807966116E-01, 2.3249630198E+00, 2.0093104973E-03, 1.9907884217E-03, 4.0161132154E-01],
	[1.0005000000E+04, 2.3820753599E-01, 2.3244289690E+00, 2.0121060779E-03, 1.9935412329E-03, 4.0178441372E-01],
	[1.0010000000E+04, 2.3833541558E-01, 2.3238953077E+00, 2.0149041483E-03, 1.9962964558E-03, 4.0195745741E-01],
	[1.0015000000E+04, 2.3846329990E-01, 2.3233620352E+00, 2.0177047096E-03, 1.9990540914E-03, 4.0213045263E-01],
	[1.0020000000E+04, 2.3859118895E-01, 2.3228291512E+00, 2.0205077627E-03, 2.0018141405E-03, 4.0230339937E-01],
	[1.0025000000E+04, 2.3871908275E-01, 2.3222966552E+00, 2.0233133086E-03, 2.0045766040E-03, 4.0247629765E-01],
	[1.0030000000E+04, 2.3884698127E-01, 2.3217645467E+00, 2.0261213482E-03, 2.0073414828E-03, 4.0264914745E-01],
	[1.0035000000E+04, 2.3897488453E-01, 2.3212328252E+00, 2.0289318826E-03, 2.0101087776E-03, 4.0282194877E-01],
	[1.0040000000E+04, 2.3910279251E-01, 2.3207014903E+00, 2.0317449127E-03, 2.0128784895E-03, 4.0299470163E-01],
	[1.0045000000E+04, 2.3923070522E-01, 2.3201705414E+00, 2.0345604394E-03, 2.0156506192E-03, 4.0316740602E-01],
	[1.0050000000E+04, 2.3935862266E-01, 2.3196399781E+00, 2.0373784638E-03, 2.0184251676E-03, 4.0334006194E-01],
	[1.0055000000E+04, 2.3948654482E-01, 2.3191098000E+00, 2.0401989868E-03, 2.0212021356E-03, 4.0351266939E-01],
	[1.0060000000E+04, 2.3961447170E-01, 2.3185800065E+00, 2.0430220094E-03, 2.0239815240E-03, 4.0368522838E-01],
	[1.0065000000E+04, 2.3974240329E-01, 2.3180505972E+00, 2.0458475326E-03, 2.0267633338E-03, 4.0385773891E-01],
	[1.0070000000E+04, 2.3987033960E-01, 2.3175215717E+00, 2.0486755572E-03, 2.0295475657E-03, 4.0403020097E-01],
	[1.0075000000E+04, 2.3999828063E-01, 2.3169929294E+00, 2.0515060844E-03, 2.0323342206E-03, 4.0420261457E-01],
	[1.0080000000E+04, 2.4012622636E-01, 2.3164646699E+00, 2.0543391151E-03, 2.0351232995E-03, 4.0437497972E-01],
	[1.0085000000E+04, 2.4025417681E-01, 2.3159367927E+00, 2.0571746502E-03, 2.0379148031E-03, 4.0454729640E-01],
	[1.0090000000E+04, 2.4038213196E-01, 2.3154092973E+00, 2.0600126907E-03, 2.0407087323E-03, 4.0471956463E-01],
	[1.0095000000E+04, 2.4051009182E-01, 2.3148821833E+00, 2.0628532376E-03, 2.0435050881E-03, 4.0489178440E-01],
	[1.0100000000E+04, 2.4063863480E-01, 2.3143597866E+00, 2.0656962919E-03, 2.0463039164E-03, 4.0506395572E-01],
	[1.0105000000E+04, 2.4076730535E-01, 2.3138386842E+00, 2.0685418544E-03, 2.0491051827E-03, 4.0523607859E-01],
	[1.0110000000E+04, 2.4089598100E-01, 2.3133179568E+00, 2.0713899263E-03, 2.0519088783E-03, 4.0540815302E-01],
	[1.0115000000E+04, 2.4102466175E-01, 2.3127976040E+00, 2.0742405085E-03, 2.0547150040E-03, 4.0558017899E-01],
	[1.0120000000E+04, 2.4115334759E-01, 2.3122776253E+00, 2.0770936018E-03, 2.0575235608E-03, 4.0575215652E-01],
	[1.0125000000E+04, 2.4128203852E-01, 2.3117580203E+00, 2.0799492074E-03, 2.0603345495E-03, 4.0592408560E-01],
	[1.0130000000E+04, 2.4141073455E-01, 2.3112387885E+00, 2.0828073262E-03, 2.0631479710E-03, 4.0609596625E-01],
	[1.0135000000E+04, 2.4153943566E-01, 2.3107199294E+00, 2.0856679591E-03, 2.0659638260E-03, 4.0626779845E-01],
	[1.0140000000E+04, 2.4166814185E-01, 2.3102014426E+00, 2.0885311071E-03, 2.0687821156E-03, 4.0643958222E-01],
	[1.0145000000E+04, 2.4179685313E-01, 2.3096833277E+00, 2.0913967712E-03, 2.0716028404E-03, 4.0661131755E-01],
	[1.0150000000E+04, 2.4192556948E-01, 2.3091655842E+00, 2.0942649523E-03, 2.0744260015E-03, 4.0678300445E-01],
	[1.0155000000E+04, 2.4205429092E-01, 2.3086482117E+00, 2.0971356515E-03, 2.0772515997E-03, 4.0695464292E-01],
	[1.0160000000E+04, 2.4218301743E-01, 2.3081312097E+00, 2.1000088697E-03, 2.0800796357E-03, 4.0712623296E-01],
	[1.0165000000E+04, 2.4231174901E-01, 2.3076145777E+00, 2.1028846078E-03, 2.0829101106E-03, 4.0729777457E-01],
	[1.0170000000E+04, 2.4244048567E-01, 2.3070983153E+00, 2.1057628669E-03, 2.0857430251E-03, 4.0746926776E-01],
	[1.0175000000E+04, 2.4256922739E-01, 2.3065824221E+00, 2.1086436478E-03, 2.0885783800E-03, 4.0764071253E-01],
	[1.0180000000E+04, 2.4269797418E-01, 2.3060668976E+00, 2.1115269516E-03, 2.0914161764E-03, 4.0781210888E-01],
	[1.0185000000E+04, 2.4282672603E-01, 2.3055517415E+00, 2.1144127793E-03, 2.0942564150E-03, 4.0798345681E-01],
	[1.0190000000E+04, 2.4295548295E-01, 2.3050369531E+00, 2.1173011318E-03, 2.0970990967E-03, 4.0815475633E-01],
	[1.0195000000E+04, 2.4308424492E-01, 2.3045225321E+00, 2.1201920100E-03, 2.0999442223E-03, 4.0832600744E-01],
	[1.0200000000E+04, 2.4321301195E-01, 2.3040084781E+00, 2.1230854150E-03, 2.1027917928E-03, 4.0849721014E-01],
	[1.0205000000E+04, 2.4334178404E-01, 2.3034947906E+00, 2.1259813477E-03, 2.1056418089E-03, 4.0866836443E-01],
	[1.0210000000E+04, 2.4347056118E-01, 2.3029814691E+00, 2.1288798090E-03, 2.1084942715E-03, 4.0883947032E-01],
	[1.0215000000E+04, 2.4359934337E-01, 2.3024685133E+00, 2.1317808000E-03, 2.1113491815E-03, 4.0901052781E-01],
	[1.0220000000E+04, 2.4372813061E-01, 2.3019559227E+00, 2.1346843217E-03, 2.1142065397E-03, 4.0918153690E-01],
	[1.0225000000E+04, 2.4385692289E-01, 2.3014436968E+00, 2.1375903749E-03, 2.1170663471E-03, 4.0935249760E-01],
	[1.0230000000E+04, 2.4398572022E-01, 2.3009318352E+00, 2.1404989606E-03, 2.1199286044E-03, 4.0952340991E-01],
	[1.0235000000E+04, 2.4411452259E-01, 2.3004203376E+00, 2.1434100799E-03, 2.1227933126E-03, 4.0969427382E-01],
	[1.0240000000E+04, 2.4424333000E-01, 2.2999092033E+00, 2.1463237336E-03, 2.1256604724E-03, 4.0986508936E-01],
	[1.0245000000E+04, 2.4437214244E-01, 2.2993984320E+00, 2.1492399229E-03, 2.1285300847E-03, 4.1003585651E-01],
	[1.0250000000E+04, 2.4450095992E-01, 2.2988880234E+00, 2.1521586485E-03, 2.1314021505E-03, 4.1020657527E-01],
	[1.0255000000E+04, 2.4462978243E-01, 2.2983779768E+00, 2.1550799115E-03, 2.1342766705E-03, 4.1037724567E-01],
	[1.0260000000E+04, 2.4475883678E-01, 2.2978699352E+00, 2.1580037129E-03, 2.1371536643E-03, 4.1054786769E-01],
	[1.0265000000E+04, 2.4488838002E-01, 2.2973657554E+00, 2.1609300535E-03, 2.1400331541E-03, 4.1071844134E-01],
	[1.0270000000E+04, 2.4501792870E-01, 2.2968619318E+00, 2.1638589345E-03, 2.1429151010E-03, 4.1088896662E-01],
	[1.0275000000E+04, 2.4514748281E-01, 2.2963584638E+00, 2.1667903568E-03, 2.1457995058E-03, 4.1105944354E-01],
	[1.0280000000E+04, 2.4527704234E-01, 2.2958553510E+00, 2.1697243212E-03, 2.1486863694E-03, 4.1122987210E-01],
	[1.0285000000E+04, 2.4540660729E-01, 2.2953525930E+00, 2.1726608288E-03, 2.1515756926E-03, 4.1140025230E-01],
	[1.0290000000E+04, 2.4553617766E-01, 2.2948501894E+00, 2.1755998806E-03, 2.1544674763E-03, 4.1157058415E-01],
	[1.0295000000E+04, 2.4566575345E-01, 2.2943481397E+00, 2.1785414776E-03, 2.1573617213E-03, 4.1174086765E-01],
	[1.0300000000E+04, 2.4579533465E-01, 2.2938464435E+00, 2.1814856206E-03, 2.1602584285E-03, 4.1191110280E-01],
	[1.0305000000E+04, 2.4592492126E-01, 2.2933451005E+00, 2.1844323106E-03, 2.1631575988E-03, 4.1208128961E-01],
	[1.0310000000E+04, 2.4605451329E-01, 2.2928441101E+00, 2.1873815487E-03, 2.1660592330E-03, 4.1225142808E-01],
	[1.0315000000E+04, 2.4618411072E-01, 2.2923434720E+00, 2.1903333357E-03, 2.1689633319E-03, 4.1242151822E-01],
	[1.0320000000E+04, 2.4631371355E-01, 2.2918431858E+00, 2.1932876727E-03, 2.1718698965E-03, 4.1259156002E-01],
	[1.0325000000E+04, 2.4644332179E-01, 2.2913432509E+00, 2.1962445607E-03, 2.1747789275E-03, 4.1276155350E-01],
	[1.0330000000E+04, 2.4657293543E-01, 2.2908436671E+00, 2.1992040005E-03, 2.1776904258E-03, 4.1293149865E-01],
	[1.0335000000E+04, 2.4670255447E-01, 2.2903444339E+00, 2.2021659931E-03, 2.1806043924E-03, 4.1310139548E-01],
	[1.0340000000E+04, 2.4683217890E-01, 2.2898455509E+00, 2.2051305396E-03, 2.1835208280E-03, 4.1327124399E-01],
	[1.0345000000E+04, 2.4696180873E-01, 2.2893470177E+00, 2.2080976408E-03, 2.1864397334E-03, 4.1344104420E-01],
	[1.0350000000E+04, 2.4709144394E-01, 2.2888488338E+00, 2.2110672978E-03, 2.1893611096E-03, 4.1361079609E-01],
	[1.0355000000E+04, 2.4722108455E-01, 2.2883509988E+00, 2.2140395115E-03, 2.1922849575E-03, 4.1378049968E-01],
	[1.0360000000E+04, 2.4735073054E-01, 2.2878535124E+00, 2.2170142829E-03, 2.1952112777E-03, 4.1395015496E-01],
	[1.0365000000E+04, 2.4748038191E-01, 2.2873563741E+00, 2.2199916129E-03, 2.1981400713E-03, 4.1411976196E-01],
	[1.0370000000E+04, 2.4761003866E-01, 2.2868595835E+00, 2.2229715025E-03, 2.2010713390E-03, 4.1428932065E-01],
	[1.0375000000E+04, 2.4773970080E-01, 2.2863631402E+00, 2.2259539527E-03, 2.2040050818E-03, 4.1445883106E-01],
	[1.0380000000E+04, 2.4786936831E-01, 2.2858670438E+00, 2.2289389644E-03, 2.2069413004E-03, 4.1462829319E-01],
	[1.0385000000E+04, 2.4799904119E-01, 2.2853712939E+00, 2.2319265387E-03, 2.2098799958E-03, 4.1479770703E-01],
	[1.0390000000E+04, 2.4812871944E-01, 2.2848758900E+00, 2.2349166763E-03, 2.2128211687E-03, 4.1496707260E-01],
	[1.0395000000E+04, 2.4825840307E-01, 2.2843808318E+00, 2.2379093785E-03, 2.2157648200E-03, 4.1513638990E-01],
	[1.0400000000E+04, 2.4838809206E-01, 2.2838861188E+00, 2.2409046460E-03, 2.2187109506E-03, 4.1530565893E-01],
	[1.0405000000E+04, 2.4851778642E-01, 2.2833917507E+00, 2.2439024798E-03, 2.2216595614E-03, 4.1547487970E-01],
	[1.0410000000E+04, 2.4864748613E-01, 2.2828977270E+00, 2.2469028810E-03, 2.2246106531E-03, 4.1564405221E-01],
	[1.0415000000E+04, 2.4877719121E-01, 2.2824040473E+00, 2.2499058504E-03, 2.2275642267E-03, 4.1581317647E-01],
	[1.0420000000E+04, 2.4890690165E-01, 2.2819107113E+00, 2.2529113891E-03, 2.2305202829E-03, 4.1598225248E-01],
	[1.0425000000E+04, 2.4903682627E-01, 2.2814191804E+00, 2.2559194981E-03, 2.2334788409E-03, 4.1615128024E-01],
	[1.0430000000E+04, 2.4916726781E-01, 2.2809315686E+00, 2.2589301781E-03, 2.2364399280E-03, 4.1632025976E-01],
	[1.0435000000E+04, 2.4929771511E-01, 2.2804442946E+00, 2.2619434304E-03, 2.2394035006E-03, 4.1648919105E-01],
	[1.0440000000E+04, 2.4942816817E-01, 2.2799573580E+00, 2.2649592557E-03, 2.2423695595E-03, 4.1665807410E-01],
	[1.0445000000E+04, 2.4955862698E-01, 2.2794707586E+00, 2.2679776551E-03, 2.2453381056E-03, 4.1682690893E-01],
	[1.0450000000E+04, 2.4968909153E-01, 2.2789844957E+00, 2.2709986295E-03, 2.2483091397E-03, 4.1699569554E-01],
	[1.0455000000E+04, 2.4981956184E-01, 2.2784985692E+00, 2.2740221799E-03, 2.2512826627E-03, 4.1716443393E-01],
	[1.0460000000E+04, 2.4995003789E-01, 2.2780129785E+00, 2.2770483073E-03, 2.2542586755E-03, 4.1733312411E-01],
	[1.0465000000E+04, 2.5008051968E-01, 2.2775277232E+00, 2.2800770126E-03, 2.2572371788E-03, 4.1750176609E-01],
	[1.0470000000E+04, 2.5021100721E-01, 2.2770428031E+00, 2.2831082967E-03, 2.2602181736E-03, 4.1767035986E-01],
	[1.0475000000E+04, 2.5034150048E-01, 2.2765582177E+00, 2.2861421607E-03, 2.2632016606E-03, 4.1783890543E-01],
	[1.0480000000E+04, 2.5047199948E-01, 2.2760739665E+00, 2.2891786055E-03, 2.2661876408E-03, 4.1800740281E-01],
	[1.0485000000E+04, 2.5060250421E-01, 2.2755900493E+00, 2.2922176321E-03, 2.2691761150E-03, 4.1817585201E-01],
	[1.0490000000E+04, 2.5073301468E-01, 2.2751064656E+00, 2.2952592414E-03, 2.2721670840E-03, 4.1834425302E-01],
	[1.0495000000E+04, 2.5086353087E-01, 2.2746232150E+00, 2.2983034344E-03, 2.2751605487E-03, 4.1851260586E-01],
	[1.0500000000E+04, 2.5099405279E-01, 2.2741402972E+00, 2.3013502121E-03, 2.2781565100E-03, 4.1868091052E-01],
	[1.0505000000E+04, 2.5112458043E-01, 2.2736577117E+00, 2.3043995754E-03, 2.2811549686E-03, 4.1884916702E-01],
	[1.0510000000E+04, 2.5125511379E-01, 2.2731754582E+00, 2.3074515252E-03, 2.2841559255E-03, 4.1901737535E-01],
	[1.0515000000E+04, 2.5138565286E-01, 2.2726935363E+00, 2.3105060626E-03, 2.2871593814E-03, 4.1918553553E-01],
	[1.0520000000E+04, 2.5151619765E-01, 2.2722119456E+00, 2.3135631885E-03, 2.2901653372E-03, 4.1935364756E-01],
	[1.0525000000E+04, 2.5164674816E-01, 2.2717306857E+00, 2.3166229039E-03, 2.2931737939E-03, 4.1952171145E-01],
	[1.0530000000E+04, 2.5177730437E-01, 2.2712497563E+00, 2.3196852096E-03, 2.2961847521E-03, 4.1968972719E-01],
	[1.0535000000E+04, 2.5190786629E-01, 2.2707691569E+00, 2.3227501068E-03, 2.2991982128E-03, 4.1985769480E-01],
	[1.0540000000E+04, 2.5203843392E-01, 2.2702888872E+00, 2.3258175963E-03, 2.3022141769E-03, 4.2002561427E-01],
	[1.0545000000E+04, 2.5216900725E-01, 2.2698089467E+00, 2.3288876792E-03, 2.3052326451E-03, 4.2019348563E-01],
	[1.0550000000E+04, 2.5229958628E-01, 2.2693293351E+00, 2.3319603563E-03, 2.3082536183E-03, 4.2036130886E-01],
	[1.0555000000E+04, 2.5243017100E-01, 2.2688500521E+00, 2.3350356286E-03, 2.3112770974E-03, 4.2052908399E-01],
	[1.0560000000E+04, 2.5256076143E-01, 2.2683710972E+00, 2.3381134971E-03, 2.3143030832E-03, 4.2069681100E-01],
	[1.0565000000E+04, 2.5269135754E-01, 2.2678924701E+00, 2.3411939628E-03, 2.3173315765E-03, 4.2086448992E-01],
	[1.0570000000E+04, 2.5282195934E-01, 2.2674141703E+00, 2.3442770266E-03, 2.3203625782E-03, 4.2103212073E-01],
	[1.0575000000E+04, 2.5295256684E-01, 2.2669361976E+00, 2.3473626895E-03, 2.3233960892E-03, 4.2119970346E-01],
	[1.0580000000E+04, 2.5308318002E-01, 2.2664585514E+00, 2.3504509524E-03, 2.3264321102E-03, 4.2136723810E-01],
	[1.0585000000E+04, 2.5321379888E-01, 2.2659812316E+00, 2.3535418163E-03, 2.3294706422E-03, 4.2153472467E-01],
	[1.0590000000E+04, 2.5334442342E-01, 2.2655042376E+00, 2.3566352822E-03, 2.3325116860E-03, 4.2170216316E-01],
	[1.0595000000E+04, 2.5347558584E-01, 2.2650311678E+00, 2.3597313510E-03, 2.3355552914E-03, 4.2186955358E-01],
	[1.0600000000E+04, 2.5360695215E-01, 2.2645597573E+00, 2.3628300237E-03, 2.3386014287E-03, 4.2203689594E-01],
	[1.0605000000E+04, 2.5373832453E-01, 2.2640886671E+00, 2.3659313012E-03, 2.3416500806E-03, 4.2220419025E-01],
	[1.0610000000E+04, 2.5386970300E-01, 2.2636178970E+00, 2.3690351845E-03, 2.3447012479E-03, 4.2237143651E-01],
	[1.0615000000E+04, 2.5400108754E-01, 2.2631474464E+00, 2.3721416745E-03, 2.3477549315E-03, 4.2253863472E-01],
	[1.0620000000E+04, 2.5413247816E-01, 2.2626773151E+00, 2.3752507723E-03, 2.3508111321E-03, 4.2270578489E-01],
	[1.0625000000E+04, 2.5426387486E-01, 2.2622075026E+00, 2.3783624788E-03, 2.3538698508E-03, 4.2287288704E-01],
	[1.0630000000E+04, 2.5439527762E-01, 2.2617380087E+00, 2.3814767949E-03, 2.3569310882E-03, 4.2303994115E-01],
	[1.0635000000E+04, 2.5452668645E-01, 2.2612688329E+00, 2.3845937216E-03, 2.3599948452E-03, 4.2320694725E-01],
	[1.0640000000E+04, 2.5465810134E-01, 2.2607999749E+00, 2.3877132598E-03, 2.3630611228E-03, 4.2337390534E-01],
	[1.0645000000E+04, 2.5478952230E-01, 2.2603314344E+00, 2.3908354106E-03, 2.3661299216E-03, 4.2354081541E-01],
	[1.0650000000E+04, 2.5492094932E-01, 2.2598632109E+00, 2.3939601748E-03, 2.3692012426E-03, 4.2370767749E-01],
	[1.0655000000E+04, 2.5505238239E-01, 2.2593953041E+00, 2.3970875535E-03, 2.3722750867E-03, 4.2387449157E-01],
	[1.0660000000E+04, 2.5518382152E-01, 2.2589277136E+00, 2.4002175476E-03, 2.3753514546E-03, 4.2404125767E-01],
	[1.0665000000E+04, 2.5531526671E-01, 2.2584604391E+00, 2.4033501580E-03, 2.3784303472E-03, 4.2420797578E-01],
	[1.0670000000E+04, 2.5544671794E-01, 2.2579934802E+00, 2.4064853857E-03, 2.3815117653E-03, 4.2437464591E-01],
	[1.0675000000E+04, 2.5557817522E-01, 2.2575268366E+00, 2.4096232317E-03, 2.3845957099E-03, 4.2454126807E-01],
	[1.0680000000E+04, 2.5570963854E-01, 2.2570605078E+00, 2.4127636970E-03, 2.3876821816E-03, 4.2470784223E-01],
	[1.0685000000E+04, 2.5584110791E-01, 2.2565944936E+00, 2.4159067824E-03, 2.3907711814E-03, 4.2487436837E-01],
	[1.0690000000E+04, 2.5597258331E-01, 2.2561287935E+00, 2.4190524889E-03, 2.3938627102E-03, 4.2504084649E-01],
	[1.0695000000E+04, 2.5610406476E-01, 2.2556634072E+00, 2.4222008176E-03, 2.3969567687E-03, 4.2520727659E-01],
	[1.0700000000E+04, 2.5623555223E-01, 2.2551983344E+00, 2.4253517693E-03, 2.4000533577E-03, 4.2537365867E-01],
	[1.0705000000E+04, 2.5636704574E-01, 2.2547335747E+00, 2.4285053451E-03, 2.4031524782E-03, 4.2553999273E-01],
	[1.0710000000E+04, 2.5649854528E-01, 2.2542691278E+00, 2.4316615458E-03, 2.4062541310E-03, 4.2570627877E-01],
	[1.0715000000E+04, 2.5663005084E-01, 2.2538049932E+00, 2.4348203725E-03, 2.4093583169E-03, 4.2587251677E-01],
	[1.0720000000E+04, 2.5676156243E-01, 2.2533411706E+00, 2.4379818261E-03, 2.4124650368E-03, 4.2603870675E-01],
	[1.0725000000E+04, 2.5689308004E-01, 2.2528776597E+00, 2.4411459075E-03, 2.4155742915E-03, 4.2620484869E-01],
	[1.0730000000E+04, 2.5702460367E-01, 2.2524144601E+00, 2.4443126177E-03, 2.4186860818E-03, 4.2637094260E-01],
	[1.0735000000E+04, 2.5715613332E-01, 2.2519515715E+00, 2.4474819577E-03, 2.4218004086E-03, 4.2653698848E-01],
	[1.0740000000E+04, 2.5728766898E-01, 2.2514889935E+00, 2.4506539284E-03, 2.4249172727E-03, 4.2670298632E-01],
	[1.0745000000E+04, 2.5741921065E-01, 2.2510267258E+00, 2.4538285308E-03, 2.4280366749E-03, 4.2686893612E-01],
	[1.0750000000E+04, 2.5755075833E-01, 2.2505647679E+00, 2.4570057659E-03, 2.4311586162E-03, 4.2703483788E-01],
	[1.0755000000E+04, 2.5768231202E-01, 2.2501031196E+00, 2.4601856345E-03, 2.4342830973E-03, 4.2720069159E-01],
	[1.0760000000E+04, 2.5781387171E-01, 2.2496417805E+00, 2.4633681377E-03, 2.4374101190E-03, 4.2736649727E-01],
	[1.0765000000E+04, 2.5794590188E-01, 2.2491837858E+00, 2.4665532764E-03, 2.4405397275E-03, 4.2753225490E-01],
	[1.0770000000E+04, 2.5807821387E-01, 2.2487278966E+00, 2.4697410516E-03, 2.4436719053E-03, 4.2769796448E-01],
	[1.0775000000E+04, 2.5821053226E-01, 2.2482723112E+00, 2.4729314642E-03, 2.4468066265E-03, 4.2786362601E-01],
	[1.0780000000E+04, 2.5834285706E-01, 2.2478170295E+00, 2.4761245151E-03, 2.4499438921E-03, 4.2802923950E-01],
	[1.0785000000E+04, 2.5847518827E-01, 2.2473620510E+00, 2.4793202055E-03, 2.4530837028E-03, 4.2819480493E-01],
	[1.0790000000E+04, 2.5860752588E-01, 2.2469073755E+00, 2.4825185361E-03, 2.4562260595E-03, 4.2836032231E-01],
	[1.0795000000E+04, 2.5873986988E-01, 2.2464530024E+00, 2.4857195079E-03, 2.4593709630E-03, 4.2852579164E-01],
	[1.0800000000E+04, 2.5887222028E-01, 2.2459989317E+00, 2.4889231220E-03, 2.4625184142E-03, 4.2869121292E-01],
	[1.0805000000E+04, 2.5900457708E-01, 2.2455451628E+00, 2.4921293792E-03, 2.4656684138E-03, 4.2885658613E-01],
	[1.0810000000E+04, 2.5913694027E-01, 2.2450916954E+00, 2.4953382806E-03, 2.4688209628E-03, 4.2902191130E-01],
	[1.0815000000E+04, 2.5926930984E-01, 2.2446385293E+00, 2.4985498270E-03, 2.4719760620E-03, 4.2918718840E-01],
	[1.0820000000E+04, 2.5940168580E-01, 2.2441856640E+00, 2.5017640195E-03, 2.4751337122E-03, 4.2935241744E-01],
	[1.0825000000E+04, 2.5953406814E-01, 2.2437330993E+00, 2.5049808589E-03, 2.4782939142E-03, 4.2951759843E-01],
	[1.0830000000E+04, 2.5966645687E-01, 2.2432808347E+00, 2.5082003463E-03, 2.4814566689E-03, 4.2968273135E-01],
	[1.0835000000E+04, 2.5979885197E-01, 2.2428288700E+00, 2.5114224826E-03, 2.4846219771E-03, 4.2984781621E-01],
	[1.0840000000E+04, 2.5993125345E-01, 2.2423772048E+00, 2.5146472687E-03, 2.4877898397E-03, 4.3001285301E-01],
	[1.0845000000E+04, 2.6006366130E-01, 2.2419258388E+00, 2.5178747057E-03, 2.4909602574E-03, 4.3017784174E-01],
	[1.0850000000E+04, 2.6019607552E-01, 2.2414747716E+00, 2.5211047944E-03, 2.4941332312E-03, 4.3034278241E-01],
	[1.0855000000E+04, 2.6032849610E-01, 2.2410240030E+00, 2.5243375358E-03, 2.4973087619E-03, 4.3050767502E-01],
	[1.0860000000E+04, 2.6046092305E-01, 2.2405735325E+00, 2.5275729310E-03, 2.5004868502E-03, 4.3067251956E-01],
	[1.0865000000E+04, 2.6059335637E-01, 2.2401233599E+00, 2.5308109807E-03, 2.5036674971E-03, 4.3083731603E-01],
	[1.0870000000E+04, 2.6072579604E-01, 2.2396734847E+00, 2.5340516860E-03, 2.5068507034E-03, 4.3100206444E-01],
	[1.0875000000E+04, 2.6085824207E-01, 2.2392239067E+00, 2.5372950479E-03, 2.5100364698E-03, 4.3116676477E-01],
	[1.0880000000E+04, 2.6099069445E-01, 2.2387746256E+00, 2.5405410673E-03, 2.5132247974E-03, 4.3133141704E-01],
	[1.0885000000E+04, 2.6112315318E-01, 2.2383256410E+00, 2.5437897451E-03, 2.5164156867E-03, 4.3149602125E-01],
	[1.0890000000E+04, 2.6125561827E-01, 2.2378769525E+00, 2.5470410823E-03, 2.5196091388E-03, 4.3166057738E-01],
	[1.0895000000E+04, 2.6138808970E-01, 2.2374285599E+00, 2.5502950799E-03, 2.5228051545E-03, 4.3182508544E-01],
	[1.0900000000E+04, 2.6152056747E-01, 2.2369804628E+00, 2.5535517388E-03, 2.5260037345E-03, 4.3198954543E-01],
	[1.0905000000E+04, 2.6165305159E-01, 2.2365326609E+00, 2.5568110599E-03, 2.5292048797E-03, 4.3215395736E-01],
	[1.0910000000E+04, 2.6178554204E-01, 2.2360851538E+00, 2.5600730443E-03, 2.5324085910E-03, 4.3231832121E-01],
	[1.0915000000E+04, 2.6191803883E-01, 2.2356379413E+00, 2.5633376929E-03, 2.5356148692E-03, 4.3248263699E-01],
	[1.0920000000E+04, 2.6205054195E-01, 2.2351910229E+00, 2.5666050066E-03, 2.5388237151E-03, 4.3264690470E-01],
	[1.0925000000E+04, 2.6218305140E-01, 2.2347443985E+00, 2.5698749864E-03, 2.5420351295E-03, 4.3281112434E-01],
	[1.0930000000E+04, 2.6231556718E-01, 2.2342980675E+00, 2.5731476332E-03, 2.5452491133E-03, 4.3297529591E-01],
	[1.0935000000E+04, 2.6244808929E-01, 2.2338520298E+00, 2.5764229480E-03, 2.5484656673E-03, 4.3313941941E-01],
	[1.0940000000E+04, 2.6258135086E-01, 2.2334109148E+00, 2.5797009317E-03, 2.5516848677E-03, 4.3330349483E-01],
	[1.0945000000E+04, 2.6271463608E-01, 2.2329701951E+00, 2.5829815854E-03, 2.5549066419E-03, 4.3346752219E-01],
	[1.0950000000E+04, 2.6284792803E-01, 2.2325297636E+00, 2.5862649099E-03, 2.5581309892E-03, 4.3363150147E-01],
	[1.0955000000E+04, 2.6298122672E-01, 2.2320896200E+00, 2.5895509062E-03, 2.5613579102E-03, 4.3379543269E-01],
	[1.0960000000E+04, 2.6311453213E-01, 2.2316497640E+00, 2.5928395752E-03, 2.5645874060E-03, 4.3395931583E-01],
	[1.0965000000E+04, 2.6324784426E-01, 2.2312101951E+00, 2.5961309180E-03, 2.5678194772E-03, 4.3412315090E-01],
	[1.0970000000E+04, 2.6338116313E-01, 2.2307709132E+00, 2.5994249354E-03, 2.5710541248E-03, 4.3428693790E-01],
	[1.0975000000E+04, 2.6351448871E-01, 2.2303319180E+00, 2.6027216285E-03, 2.5742913495E-03, 4.3445067684E-01],
	[1.0980000000E+04, 2.6364782100E-01, 2.2298932089E+00, 2.6060209981E-03, 2.5775311522E-03, 4.3461436770E-01],
	[1.0985000000E+04, 2.6378116002E-01, 2.2294547859E+00, 2.6093230453E-03, 2.5807735337E-03, 4.3477801049E-01],
	[1.0990000000E+04, 2.6391450574E-01, 2.2290166485E+00, 2.6126277709E-03, 2.5840184949E-03, 4.3494160522E-01],
	[1.0995000000E+04, 2.6404785818E-01, 2.2285787965E+00, 2.6159351760E-03, 2.5872660365E-03, 4.3510515187E-01],
	[1.1000000000E+04, 2.6418121732E-01, 2.2281412294E+00, 2.6192452614E-03, 2.5905161595E-03, 4.3526865046E-01],
	[1.1005000000E+04, 2.6431458317E-01, 2.2277039471E+00, 2.6225580282E-03, 2.5937688646E-03, 4.3543210098E-01],
	[1.1010000000E+04, 2.6444795571E-01, 2.2272669491E+00, 2.6258734772E-03, 2.5970241527E-03, 4.3559550343E-01],
	[1.1015000000E+04, 2.6458133496E-01, 2.2268302353E+00, 2.6291916095E-03, 2.6002820246E-03, 4.3575885782E-01],
	[1.1020000000E+04, 2.6471472090E-01, 2.2263938052E+00, 2.6325124260E-03, 2.6035424812E-03, 4.3592216414E-01],
	[1.1025000000E+04, 2.6484811353E-01, 2.2259576585E+00, 2.6358359276E-03, 2.6068055232E-03, 4.3608542240E-01],
	[1.1030000000E+04, 2.6498151286E-01, 2.2255217950E+00, 2.6391621154E-03, 2.6100711515E-03, 4.3624863259E-01],
	[1.1035000000E+04, 2.6511491887E-01, 2.2250862143E+00, 2.6424909901E-03, 2.6133393670E-03, 4.3641179472E-01],
	[1.1040000000E+04, 2.6524833157E-01, 2.2246509161E+00, 2.6458225529E-03, 2.6166101703E-03, 4.3657490879E-01],
	[1.1045000000E+04, 2.6538175095E-01, 2.2242159001E+00, 2.6491568046E-03, 2.6198835625E-03, 4.3673797479E-01],
	[1.1050000000E+04, 2.6551517701E-01, 2.2237811660E+00, 2.6524937462E-03, 2.6231595443E-03, 4.3690099274E-01],
	[1.1055000000E+04, 2.6564860975E-01, 2.2233467135E+00, 2.6558333787E-03, 2.6264381166E-03, 4.3706396262E-01],
	[1.1060000000E+04, 2.6578204916E-01, 2.2229125423E+00, 2.6591757030E-03, 2.6297192801E-03, 4.3722688444E-01],
	[1.1065000000E+04, 2.6591549524E-01, 2.2224786520E+00, 2.6625207200E-03, 2.6330030357E-03, 4.3738975821E-01],
	[1.1070000000E+04, 2.6604894799E-01, 2.2220450424E+00, 2.6658684307E-03, 2.6362893842E-03, 4.3755258392E-01],
	[1.1075000000E+04, 2.6618240741E-01, 2.2216117131E+00, 2.6692188361E-03, 2.6395783265E-03, 4.3771536158E-01],
	[1.1080000000E+04, 2.6631587349E-01, 2.2211786639E+00, 2.6725719371E-03, 2.6428698634E-03, 4.3787809117E-01],
	[1.1085000000E+04, 2.6644934624E-01, 2.2207458944E+00, 2.6759277347E-03, 2.6461639957E-03, 4.3804077272E-01],
	[1.1090000000E+04, 2.6658282564E-01, 2.2203134043E+00, 2.6792862298E-03, 2.6494607242E-03, 4.3820340621E-01],
	[1.1095000000E+04, 2.6671631169E-01, 2.2198811933E+00, 2.6826474233E-03, 2.6527600498E-03, 4.3836599166E-01],
	[1.1100000000E+04, 2.6684980440E-01, 2.2194492611E+00, 2.6860113162E-03, 2.6560619733E-03, 4.3852852905E-01],
	[1.1105000000E+04, 2.6698330376E-01, 2.2190176075E+00, 2.6893779095E-03, 2.6593664955E-03, 4.3869101839E-01],
	[1.1110000000E+04, 2.6711680977E-01, 2.2185862320E+00, 2.6927472042E-03, 2.6626736173E-03, 4.3885345969E-01],
	[1.1115000000E+04, 2.6725090726E-01, 2.2181587050E+00, 2.6961192010E-03, 2.6659834027E-03, 4.3901585294E-01],
	[1.1120000000E+04, 2.6738518707E-01, 2.2177325223E+00, 2.6994939011E-03, 2.6692958087E-03, 4.3917819815E-01],
	[1.1125000000E+04, 2.6751947394E-01, 2.2173066131E+00, 2.7028713054E-03, 2.6726108170E-03, 4.3934049531E-01],
	[1.1130000000E+04, 2.6765376788E-01, 2.2168809770E+00, 2.7062514147E-03, 2.6759284284E-03, 4.3950274443E-01],
	[1.1135000000E+04, 2.6778806886E-01, 2.2164556138E+00, 2.7096342302E-03, 2.6792486438E-03, 4.3966494552E-01],
	[1.1140000000E+04, 2.6792237690E-01, 2.2160305230E+00, 2.7130197526E-03, 2.6825714640E-03, 4.3982709856E-01],
	[1.1145000000E+04, 2.6805669198E-01, 2.2156057045E+00, 2.7164079830E-03, 2.6858968899E-03, 4.3998920357E-01],
	[1.1150000000E+04, 2.6819101411E-01, 2.2151811579E+00, 2.7197989223E-03, 2.6892249222E-03, 4.4015126054E-01],
	[1.1155000000E+04, 2.6832534328E-01, 2.2147568829E+00, 2.7231925715E-03, 2.6925555617E-03, 4.4031326948E-01],
	[1.1160000000E+04, 2.6845967949E-01, 2.2143328793E+00, 2.7265889315E-03, 2.6958888094E-03, 4.4047523039E-01],
	[1.1165000000E+04, 2.6859402273E-01, 2.2139091467E+00, 2.7299880033E-03, 2.6992246660E-03, 4.4063714327E-01],
	[1.1170000000E+04, 2.6872837301E-01, 2.2134856849E+00, 2.7333897877E-03, 2.7025631324E-03, 4.4079900812E-01],
	[1.1175000000E+04, 2.6886273033E-01, 2.2130624935E+00, 2.7367942858E-03, 2.7059042094E-03, 4.4096082494E-01],
	[1.1180000000E+04, 2.6899709467E-01, 2.2126395723E+00, 2.7402014986E-03, 2.7092478978E-03, 4.4112259374E-01],
	[1.1185000000E+04, 2.6913146603E-01, 2.2122169209E+00, 2.7436114268E-03, 2.7125941984E-03, 4.4128431452E-01],
	[1.1190000000E+04, 2.6926584442E-01, 2.2117945392E+00, 2.7470240716E-03, 2.7159431120E-03, 4.4144598727E-01],
	[1.1195000000E+04, 2.6940022983E-01, 2.2113724267E+00, 2.7504394339E-03, 2.7192946396E-03, 4.4160761201E-01],
	[1.1200000000E+04, 2.6953462226E-01, 2.2109505832E+00, 2.7538575145E-03, 2.7226487818E-03, 4.4176918873E-01],
	[1.1205000000E+04, 2.6966902170E-01, 2.2105290083E+00, 2.7572783145E-03, 2.7260055396E-03, 4.4193071744E-01],
	[1.1210000000E+04, 2.6980342815E-01, 2.2101077019E+00, 2.7607018348E-03, 2.7293649137E-03, 4.4209219814E-01],
	[1.1215000000E+04, 2.6993784162E-01, 2.2096866636E+00, 2.7641280764E-03, 2.7327269050E-03, 4.4225363082E-01],
	[1.1220000000E+04, 2.7007226209E-01, 2.2092658932E+00, 2.7675570401E-03, 2.7360915143E-03, 4.4241501550E-01],
	[1.1225000000E+04, 2.7020668956E-01, 2.2088453903E+00, 2.7709887270E-03, 2.7394587424E-03, 4.4257635218E-01],
	[1.1230000000E+04, 2.7034112403E-01, 2.2084251546E+00, 2.7744231380E-03, 2.7428285902E-03, 4.4273764084E-01],
	[1.1235000000E+04, 2.7047556550E-01, 2.2080051859E+00, 2.7778602740E-03, 2.7462010584E-03, 4.4289888151E-01],
	[1.1240000000E+04, 2.7061001397E-01, 2.2075854838E+00, 2.7813001361E-03, 2.7495761479E-03, 4.4306007418E-01],
	[1.1245000000E+04, 2.7074446943E-01, 2.2071660482E+00, 2.7847427250E-03, 2.7529538595E-03, 4.4322121885E-01],
	[1.1250000000E+04, 2.7087893188E-01, 2.2067468786E+00, 2.7881880419E-03, 2.7563341941E-03, 4.4338231553E-01],
	[1.1255000000E+04, 2.7101340131E-01, 2.2063279748E+00, 2.7916360876E-03, 2.7597171524E-03, 4.4354336422E-01],
	[1.1260000000E+04, 2.7114787773E-01, 2.2059093366E+00, 2.7950868630E-03, 2.7631027353E-03, 4.4370436492E-01],
	[1.1265000000E+04, 2.7128236113E-01, 2.2054909636E+00, 2.7985403692E-03, 2.7664909436E-03, 4.4386531763E-01],
	[1.1270000000E+04, 2.7141685151E-01, 2.2050728556E+00, 2.8019966071E-03, 2.7698817781E-03, 4.4402622236E-01],
	[1.1275000000E+04, 2.7155134887E-01, 2.2046550122E+00, 2.8054555776E-03, 2.7732752396E-03, 4.4418707910E-01],
	[1.1280000000E+04, 2.7168585320E-01, 2.2042374332E+00, 2.8089172816E-03, 2.7766713290E-03, 4.4434788787E-01],
	[1.1285000000E+04, 2.7182036450E-01, 2.2038201183E+00, 2.8123817202E-03, 2.7800700471E-03, 4.4450864866E-01],
	[1.1290000000E+04, 2.7195488277E-01, 2.2034030672E+00, 2.8158488943E-03, 2.7834713946E-03, 4.4466936148E-01],
	[1.1295000000E+04, 2.7209017419E-01, 2.2029908009E+00, 2.8193188047E-03, 2.7868754601E-03, 4.4483002632E-01],
	[1.1300000000E+04, 2.7222547726E-01, 2.2025788192E+00, 2.8227914525E-03, 2.7902821576E-03, 4.4499064320E-01],
	[1.1305000000E+04, 2.7236078770E-01, 2.2021670968E+00, 2.8262668387E-03, 2.7936914873E-03, 4.4515121211E-01],
	[1.1310000000E+04, 2.7249610552E-01, 2.2017556334E+00, 2.8297449640E-03, 2.7971034501E-03, 4.4531173306E-01],
	[1.1315000000E+04, 2.7263143073E-01, 2.2013444286E+00, 2.8332258296E-03, 2.8005180469E-03, 4.4547220606E-01],
	[1.1320000000E+04, 2.7276676330E-01, 2.2009334823E+00, 2.8367094363E-03, 2.8039352784E-03, 4.4563263109E-01],
	[1.1325000000E+04, 2.7290210325E-01, 2.2005227940E+00, 2.8401957851E-03, 2.8073551454E-03, 4.4579300817E-01],
	[1.1330000000E+04, 2.7303745056E-01, 2.2001123637E+00, 2.8436848770E-03, 2.8107776488E-03, 4.4595333730E-01],
	[1.1335000000E+04, 2.7317280524E-01, 2.1997021909E+00, 2.8471767128E-03, 2.8142027894E-03, 4.4611361848E-01],
	[1.1340000000E+04, 2.7330816728E-01, 2.1992922755E+00, 2.8506712936E-03, 2.8176305680E-03, 4.4627385171E-01],
	[1.1345000000E+04, 2.7344353668E-01, 2.1988826171E+00, 2.8541686202E-03, 2.8210609854E-03, 4.4643403701E-01],
	[1.1350000000E+04, 2.7357891344E-01, 2.1984732154E+00, 2.8576686937E-03, 2.8244940425E-03, 4.4659417436E-01],
	[1.1355000000E+04, 2.7371429756E-01, 2.1980640703E+00, 2.8611715149E-03, 2.8279297401E-03, 4.4675426378E-01],
	[1.1360000000E+04, 2.7384968902E-01, 2.1976551813E+00, 2.8646770849E-03, 2.8313680789E-03, 4.4691430527E-01],
	[1.1365000000E+04, 2.7398508783E-01, 2.1972465483E+00, 2.8681854045E-03, 2.8348090599E-03, 4.4707429883E-01],
	[1.1370000000E+04, 2.7412049399E-01, 2.1968381710E+00, 2.8716964747E-03, 2.8382526837E-03, 4.4723424446E-01],
	[1.1375000000E+04, 2.7425590749E-01, 2.1964300491E+00, 2.8752102965E-03, 2.8416989513E-03, 4.4739414217E-01],
	[1.1380000000E+04, 2.7439132833E-01, 2.1960221822E+00, 2.8787268708E-03, 2.8451478635E-03, 4.4755399196E-01],
	[1.1385000000E+04, 2.7452675651E-01, 2.1956145703E+00, 2.8822461985E-03, 2.8485994211E-03, 4.4771379383E-01],
	[1.1390000000E+04, 2.7466219202E-01, 2.1952072129E+00, 2.8857682806E-03, 2.8520536248E-03, 4.4787354779E-01],
	[1.1395000000E+04, 2.7479763486E-01, 2.1948001098E+00, 2.8892931180E-03, 2.8555104755E-03, 4.4803325384E-01],
	[1.1400000000E+04, 2.7493308503E-01, 2.1943932608E+00, 2.8928207117E-03, 2.8589699741E-03, 4.4819291198E-01],
	[1.1405000000E+04, 2.7506854253E-01, 2.1939866656E+00, 2.8963510626E-03, 2.8624321213E-03, 4.4835252222E-01],
	[1.1410000000E+04, 2.7520400735E-01, 2.1935803238E+00, 2.8998841717E-03, 2.8658969180E-03, 4.4851208457E-01],
	[1.1415000000E+04, 2.7533947949E-01, 2.1931742353E+00, 2.9034200400E-03, 2.8693643650E-03, 4.4867159901E-01],
	[1.1420000000E+04, 2.7547495895E-01, 2.1927683997E+00, 2.9069586682E-03, 2.8728344630E-03, 4.4883106557E-01],
	[1.1425000000E+04, 2.7561044572E-01, 2.1923628169E+00, 2.9105000575E-03, 2.8763072130E-03, 4.4899048423E-01],
	[1.1430000000E+04, 2.7574593980E-01, 2.1919574864E+00, 2.9140442087E-03, 2.8797826156E-03, 4.4914985502E-01],
	[1.1435000000E+04, 2.7588144119E-01, 2.1915524082E+00, 2.9175911228E-03, 2.8832606718E-03, 4.4930917792E-01],
	[1.1440000000E+04, 2.7601694989E-01, 2.1911475818E+00, 2.9211408008E-03, 2.8867413824E-03, 4.4946845294E-01],
	[1.1445000000E+04, 2.7615246589E-01, 2.1907430070E+00, 2.9246932435E-03, 2.8902247481E-03, 4.4962768009E-01],
	[1.1450000000E+04, 2.7628798920E-01, 2.1903386836E+00, 2.9282484519E-03, 2.8937107699E-03, 4.4978685937E-01],
	[1.1455000000E+04, 2.7642351980E-01, 2.1899346113E+00, 2.9318064271E-03, 2.8971994484E-03, 4.4994599078E-01],
	[1.1460000000E+04, 2.7655905769E-01, 2.1895307899E+00, 2.9353671698E-03, 2.9006907845E-03, 4.5010507433E-01],
	[1.1465000000E+04, 2.7669460288E-01, 2.1891272190E+00, 2.9389306811E-03, 2.9041847791E-03, 4.5026411002E-01],
	[1.1470000000E+04, 2.7683015535E-01, 2.1887238984E+00, 2.9424969618E-03, 2.9076814329E-03, 4.5042309786E-01],
	[1.1475000000E+04, 2.7696621764E-01, 2.1883236955E+00, 2.9460660131E-03, 2.9111808073E-03, 4.5058203785E-01],
	[1.1480000000E+04, 2.7710256577E-01, 2.1879253270E+00, 2.9496378357E-03, 2.9146828764E-03, 4.5074092998E-01],
	[1.1485000000E+04, 2.7723892161E-01, 2.1875272044E+00, 2.9532124306E-03, 2.9181876076E-03, 4.5089977428E-01],
	[1.1490000000E+04, 2.7737528515E-01, 2.1871293276E+00, 2.9567897988E-03, 2.9216950015E-03, 4.5105857074E-01],
	[1.1495000000E+04, 2.7751165639E-01, 2.1867316961E+00, 2.9603699413E-03, 2.9252050592E-03, 4.5121731936E-01],
	[1.1500000000E+04, 2.7764803533E-01, 2.1863343098E+00, 2.9639528589E-03, 2.9287177812E-03, 4.5137602015E-01],
	[1.1505000000E+04, 2.7778442196E-01, 2.1859371684E+00, 2.9675385526E-03, 2.9322331686E-03, 4.5153467312E-01],
	[1.1510000000E+04, 2.7792081629E-01, 2.1855402717E+00, 2.9711270233E-03, 2.9357512220E-03, 4.5169327826E-01],
	[1.1515000000E+04, 2.7805721830E-01, 2.1851436194E+00, 2.9747182720E-03, 2.9392719423E-03, 4.5185183558E-01],
	[1.1520000000E+04, 2.7819362801E-01, 2.1847472112E+00, 2.9783122997E-03, 2.9427953303E-03, 4.5201034509E-01],
	[1.1525000000E+04, 2.7833004539E-01, 2.1843510469E+00, 2.9819091073E-03, 2.9463213868E-03, 4.5216880679E-01],
	[1.1530000000E+04, 2.7846647046E-01, 2.1839551262E+00, 2.9855086956E-03, 2.9498501127E-03, 4.5232722068E-01],
	[1.1535000000E+04, 2.7860290321E-01, 2.1835594488E+00, 2.9891110657E-03, 2.9533815087E-03, 4.5248558675E-01],
	[1.1540000000E+04, 2.7873934363E-01, 2.1831640146E+00, 2.9927162186E-03, 2.9569155757E-03, 4.5264390499E-01],
	[1.1545000000E+04, 2.7887579172E-01, 2.1827688233E+00, 2.9963241550E-03, 2.9604523144E-03, 4.5280217539E-01],
	[1.1550000000E+04, 2.7901224748E-01, 2.1823738746E+00, 2.9999348761E-03, 2.9639917257E-03, 4.5296039796E-01],
	[1.1555000000E+04, 2.7914871091E-01, 2.1819791682E+00, 3.0035483827E-03, 2.9675338104E-03, 4.5311857269E-01],
	[1.1560000000E+04, 2.7928518200E-01, 2.1815847039E+00, 3.0071646757E-03, 2.9710785693E-03, 4.5327669959E-01],
	[1.1565000000E+04, 2.7942166075E-01, 2.1811904814E+00, 3.0107837562E-03, 2.9746260032E-03, 4.5343477865E-01],
	[1.1570000000E+04, 2.7955814716E-01, 2.1807965006E+00, 3.0144056250E-03, 2.9781761130E-03, 4.5359280987E-01],
	[1.1575000000E+04, 2.7969464123E-01, 2.1804027611E+00, 3.0180302832E-03, 2.9817288993E-03, 4.5375079324E-01],
	[1.1580000000E+04, 2.7983114295E-01, 2.1800092626E+00, 3.0216577316E-03, 2.9852843631E-03, 4.5390872877E-01],
	[1.1585000000E+04, 2.7996765231E-01, 2.1796160050E+00, 3.0252879711E-03, 2.9888425052E-03, 4.5406661646E-01],
	[1.1590000000E+04, 2.8010416932E-01, 2.1792229880E+00, 3.0289210028E-03, 2.9924033264E-03, 4.5422445630E-01],
	[1.1595000000E+04, 2.8024069398E-01, 2.1788302114E+00, 3.0325568275E-03, 2.9959668274E-03, 4.5438224829E-01],
	[1.1600000000E+04, 2.8037722628E-01, 2.1784376748E+00, 3.0361954463E-03, 2.9995330091E-03, 4.5453999243E-01],
	[1.1605000000E+04, 2.8051376621E-01, 2.1780453780E+00, 3.0398368600E-03, 3.0031018723E-03, 4.5469768872E-01],
	[1.1610000000E+04, 2.8065031378E-01, 2.1776533209E+00, 3.0434810696E-03, 3.0066734178E-03, 4.5485533716E-01],
	[1.1615000000E+04, 2.8078686898E-01, 2.1772615030E+00, 3.0471280760E-03, 3.0102476464E-03, 4.5501293775E-01],
	[1.1620000000E+04, 2.8092343181E-01, 2.1768699243E+00, 3.0507778802E-03, 3.0138245589E-03, 4.5517049048E-01],
	[1.1625000000E+04, 2.8106000226E-01, 2.1764785844E+00, 3.0544304831E-03, 3.0174041562E-03, 4.5532799536E-01],
	[1.1630000000E+04, 2.8119658034E-01, 2.1760874830E+00, 3.0580858857E-03, 3.0209864390E-03, 4.5548545238E-01],
	[1.1635000000E+04, 2.8133316604E-01, 2.1756966201E+00, 3.0617440888E-03, 3.0245714081E-03, 4.5564286154E-01],
	[1.1640000000E+04, 2.8146975936E-01, 2.1753059952E+00, 3.0654050935E-03, 3.0281590645E-03, 4.5580022285E-01],
	[1.1645000000E+04, 2.8160636029E-01, 2.1749156081E+00, 3.0690689007E-03, 3.0317494087E-03, 4.5595753629E-01],
	[1.1650000000E+04, 2.8174296883E-01, 2.1745254587E+00, 3.0727355113E-03, 3.0353424418E-03, 4.5611480188E-01],
	[1.1655000000E+04, 2.8187958499E-01, 2.1741355466E+00, 3.0764049262E-03, 3.0389381644E-03, 4.5627201960E-01],
	[1.1660000000E+04, 2.8201676866E-01, 2.1737489609E+00, 3.0800771465E-03, 3.0425366486E-03, 4.5642918946E-01],
	[1.1665000000E+04, 2.8215419161E-01, 2.1733638853E+00, 3.0837521729E-03, 3.0461378538E-03, 4.5658631146E-01],
	[1.1670000000E+04, 2.8229162260E-01, 2.1729790429E+00, 3.0874300066E-03, 3.0497417513E-03, 4.5674338559E-01],
	[1.1675000000E+04, 2.8242906161E-01, 2.1725944335E+00, 3.0911106484E-03, 3.0533483419E-03, 4.5690041186E-01],
	[1.1680000000E+04, 2.8256650865E-01, 2.1722100568E+00, 3.0947940992E-03, 3.0569576266E-03, 4.5705739026E-01],
	[1.1685000000E+04, 2.8270396371E-01, 2.1718259126E+00, 3.0984803600E-03, 3.0605696059E-03, 4.5721432080E-01],
	[1.1690000000E+04, 2.8284142679E-01, 2.1714420006E+00, 3.1021694318E-03, 3.0641842809E-03, 4.5737120347E-01],
	[1.1695000000E+04, 2.8297889788E-01, 2.1710583206E+00, 3.1058613155E-03, 3.0678016523E-03, 4.5752803828E-01],
	[1.1700000000E+04, 2.8311637698E-01, 2.1706748723E+00, 3.1095560119E-03, 3.0714217208E-03, 4.5768482521E-01],
	[1.1705000000E+04, 2.8325386409E-01, 2.1702916556E+00, 3.1132535222E-03, 3.0750444874E-03, 4.5784156428E-01],
	[1.1710000000E+04, 2.8339135921E-01, 2.1699086701E+00, 3.1169538471E-03, 3.0786699527E-03, 4.5799825548E-01],
	[1.1715000000E+04, 2.8352886233E-01, 2.1695259157E+00, 3.1206569877E-03, 3.0822981177E-03, 4.5815489881E-01],
	[1.1720000000E+04, 2.8366637346E-01, 2.1691433920E+00, 3.1243629448E-03, 3.0859289830E-03, 4.5831149427E-01],
	[1.1725000000E+04, 2.8380389258E-01, 2.1687610989E+00, 3.1280717195E-03, 3.0895625496E-03, 4.5846804186E-01],
	[1.1730000000E+04, 2.8394141969E-01, 2.1683790362E+00, 3.1317833126E-03, 3.0931988183E-03, 4.5862454158E-01],
	[1.1735000000E+04, 2.8407895480E-01, 2.1679972035E+00, 3.1354977251E-03, 3.0968377897E-03, 4.5878099342E-01],
	[1.1740000000E+04, 2.8421649789E-01, 2.1676156007E+00, 3.1392149579E-03, 3.1004794648E-03, 4.5893739740E-01],
	[1.1745000000E+04, 2.8435404897E-01, 2.1672342275E+00, 3.1429350120E-03, 3.1041238443E-03, 4.5909375351E-01],
	[1.1750000000E+04, 2.8449160803E-01, 2.1668530836E+00, 3.1466578883E-03, 3.1077709291E-03, 4.5925006174E-01],
	[1.1755000000E+04, 2.8462917508E-01, 2.1664721689E+00, 3.1503835878E-03, 3.1114207200E-03, 4.5940632211E-01],
	[1.1760000000E+04, 2.8476675010E-01, 2.1660914832E+00, 3.1541121114E-03, 3.1150732176E-03, 4.5956253460E-01],
	[1.1765000000E+04, 2.8490433309E-01, 2.1657110260E+00, 3.1578434599E-03, 3.1187284230E-03, 4.5971869922E-01],
	[1.1770000000E+04, 2.8504192405E-01, 2.1653307974E+00, 3.1615776345E-03, 3.1223863368E-03, 4.5987481597E-01],
	[1.1775000000E+04, 2.8517952299E-01, 2.1649507969E+00, 3.1653146359E-03, 3.1260469599E-03, 4.6003088485E-01],
	[1.1780000000E+04, 2.8531712988E-01, 2.1645710244E+00, 3.1690544652E-03, 3.1297102930E-03, 4.6018690585E-01],
	[1.1785000000E+04, 2.8545474474E-01, 2.1641914796E+00, 3.1727971233E-03, 3.1333763371E-03, 4.6034287899E-01],
	[1.1790000000E+04, 2.8559236756E-01, 2.1638121624E+00, 3.1765426111E-03, 3.1370450928E-03, 4.6049880425E-01],
	[1.1795000000E+04, 2.8572999834E-01, 2.1634330724E+00, 3.1802909295E-03, 3.1407165610E-03, 4.6065468164E-01],
	[1.1800000000E+04, 2.8586763707E-01, 2.1630542094E+00, 3.1840420796E-03, 3.1443907424E-03, 4.6081051116E-01],
	[1.1805000000E+04, 2.8600528375E-01, 2.1626755733E+00, 3.1877960622E-03, 3.1480676380E-03, 4.6096629281E-01],
	[1.1810000000E+04, 2.8614293837E-01, 2.1622971637E+00, 3.1915528782E-03, 3.1517472484E-03, 4.6112202659E-01],
	[1.1815000000E+04, 2.8628060094E-01, 2.1619189805E+00, 3.1953125287E-03, 3.1554295746E-03, 4.6127771250E-01],
	[1.1820000000E+04, 2.8641827146E-01, 2.1615410234E+00, 3.1990750145E-03, 3.1591146172E-03, 4.6143335054E-01],
	[1.1825000000E+04, 2.8655594991E-01, 2.1611632921E+00, 3.2028403365E-03, 3.1628023771E-03, 4.6158894071E-01],
	[1.1830000000E+04, 2.8669363630E-01, 2.1607857865E+00, 3.2066084958E-03, 3.1664928551E-03, 4.6174448301E-01],
	[1.1835000000E+04, 2.8683133062E-01, 2.1604085064E+00, 3.2103794933E-03, 3.1701860520E-03, 4.6189997745E-01],
	[1.1840000000E+04, 2.8696903287E-01, 2.1600314514E+00, 3.2141533298E-03, 3.1738819687E-03, 4.6205542401E-01],
	[1.1845000000E+04, 2.8710688497E-01, 2.1596553788E+00, 3.2179300064E-03, 3.1775806248E-03, 4.6221082271E-01],
	[1.1850000000E+04, 2.8724540505E-01, 2.1592830504E+00, 3.2217095240E-03, 3.1812820909E-03, 4.6236617353E-01],
	[1.1855000000E+04, 2.8738393348E-01, 2.1589109433E+00, 3.2254918834E-03, 3.1849862795E-03, 4.6252147650E-01],
	[1.1860000000E+04, 2.8752247026E-01, 2.1585390571E+00, 3.2292770858E-03, 3.1886931913E-03, 4.6267673159E-01],
	[1.1865000000E+04, 2.8766101539E-01, 2.1581673917E+00, 3.2330651318E-03, 3.1924028272E-03, 4.6283193882E-01],
	[1.1870000000E+04, 2.8779956886E-01, 2.1577959469E+00, 3.2368560226E-03, 3.1961151880E-03, 4.6298709819E-01],
	[1.1875000000E+04, 2.8793813068E-01, 2.1574247223E+00, 3.2406497591E-03, 3.1998302744E-03, 4.6314220969E-01],
	[1.1880000000E+04, 2.8807670084E-01, 2.1570537179E+00, 3.2444463421E-03, 3.2035480873E-03, 4.6329727333E-01],
	[1.1885000000E+04, 2.8821527933E-01, 2.1566829333E+00, 3.2482457727E-03, 3.2072686275E-03, 4.6345228911E-01],
	[1.1890000000E+04, 2.8835386616E-01, 2.1563123684E+00, 3.2520480517E-03, 3.2109918957E-03, 4.6360725703E-01],
	[1.1895000000E+04, 2.8849246132E-01, 2.1559420229E+00, 3.2558531802E-03, 3.2147178929E-03, 4.6376217709E-01],
	[1.1900000000E+04, 2.8863106480E-01, 2.1555718966E+00, 3.2596611589E-03, 3.2184466196E-03, 4.6391704928E-01],
	[1.1905000000E+04, 2.8876967661E-01, 2.1552019893E+00, 3.2634719890E-03, 3.2221780769E-03, 4.6407187362E-01],
	[1.1910000000E+04, 2.8890829674E-01, 2.1548323008E+00, 3.2672856712E-03, 3.2259122654E-03, 4.6422665010E-01],
	[1.1915000000E+04, 2.8904692518E-01, 2.1544628308E+00, 3.2711022066E-03, 3.2296491860E-03, 4.6438137872E-01],
	[1.1920000000E+04, 2.8918556195E-01, 2.1540935791E+00, 3.2749215961E-03, 3.2333888395E-03, 4.6453605949E-01],
	[1.1925000000E+04, 2.8932420702E-01, 2.1537245456E+00, 3.2787438406E-03, 3.2371312266E-03, 4.6469069240E-01],
	[1.1930000000E+04, 2.8946286041E-01, 2.1533557299E+00, 3.2825689410E-03, 3.2408763482E-03, 4.6484527746E-01],
	[1.1935000000E+04, 2.8960152210E-01, 2.1529871319E+00, 3.2863968983E-03, 3.2446242051E-03, 4.6499981467E-01],
	[1.1940000000E+04, 2.8974019209E-01, 2.1526187513E+00, 3.2902277135E-03, 3.2483747980E-03, 4.6515430403E-01],
	[1.1945000000E+04, 2.8987887039E-01, 2.1522505879E+00, 3.2940613874E-03, 3.2521281278E-03, 4.6530874553E-01],
	[1.1950000000E+04, 2.9001755698E-01, 2.1518826416E+00, 3.2978979210E-03, 3.2558841952E-03, 4.6546313919E-01],
	[1.1955000000E+04, 2.9015625186E-01, 2.1515149120E+00, 3.3017373152E-03, 3.2596430011E-03, 4.6561748500E-01],
	[1.1960000000E+04, 2.9029495504E-01, 2.1511473990E+00, 3.3055795710E-03, 3.2634045462E-03, 4.6577178297E-01],
	[1.1965000000E+04, 2.9043366651E-01, 2.1507801023E+00, 3.3094246893E-03, 3.2671688314E-03, 4.6592603309E-01],
	[1.1970000000E+04, 2.9057238626E-01, 2.1504130218E+00, 3.3132726710E-03, 3.2709358575E-03, 4.6608023536E-01],
	[1.1975000000E+04, 2.9071111429E-01, 2.1500461572E+00, 3.3171235171E-03, 3.2747056252E-03, 4.6623438980E-01],
	[1.1980000000E+04, 2.9084985061E-01, 2.1496795082E+00, 3.3209772285E-03, 3.2784781353E-03, 4.6638849639E-01],
	[1.1985000000E+04, 2.9098859520E-01, 2.1493130748E+00, 3.3248338062E-03, 3.2822533886E-03, 4.6654255515E-01],
	[1.1990000000E+04, 2.9112734806E-01, 2.1489468566E+00, 3.3286932510E-03, 3.2860313860E-03, 4.6669656607E-01],
	[1.1995000000E+04, 2.9126610920E-01, 2.1485808535E+00, 3.3325555639E-03, 3.2898121282E-03, 4.6685052915E-01],
	[1.2000000000E+04, 2.9140487860E-01, 2.1482150652E+00, 3.3364207458E-03, 3.2935956161E-03, 4.6700444440E-01],
	[1.2005000000E+04, 2.9154365627E-01, 2.1478494915E+00, 3.3402887978E-03, 3.2973818503E-03, 4.6715831181E-01],
	[1.2010000000E+04, 2.9168244219E-01, 2.1474841322E+00, 3.3441597206E-03, 3.3011708318E-03, 4.6731213140E-01],
	[1.2015000000E+04, 2.9182123638E-01, 2.1471189871E+00, 3.3480335153E-03, 3.3049625613E-03, 4.6746590315E-01],
	[1.2020000000E+04, 2.9196003883E-01, 2.1467540560E+00, 3.3519101828E-03, 3.3087570396E-03, 4.6761962708E-01],
	[1.2025000000E+04, 2.9209884952E-01, 2.1463893386E+00, 3.3557897240E-03, 3.3125542675E-03, 4.6777330319E-01],
	[1.2030000000E+04, 2.9223766847E-01, 2.1460248348E+00, 3.3596721398E-03, 3.3163542457E-03, 4.6792693146E-01],
	[1.2035000000E+04, 2.9237652994E-01, 2.1456607212E+00, 3.3635574312E-03, 3.3201569801E-03, 4.6808051192E-01],
	[1.2040000000E+04, 2.9251617803E-01, 2.1453008357E+00, 3.3674455991E-03, 3.3239625765E-03, 4.6823404456E-01],
	[1.2045000000E+04, 2.9265583479E-01, 2.1449411600E+00, 3.3713366445E-03, 3.3277709262E-03, 4.6838752938E-01],
	[1.2050000000E+04, 2.9279550023E-01, 2.1445816938E+00, 3.3752305683E-03, 3.3315820297E-03, 4.6854096638E-01],
	[1.2055000000E+04, 2.9293517434E-01, 2.1442224369E+00, 3.3791273714E-03, 3.3353958881E-03, 4.6869435556E-01],
	[1.2060000000E+04, 2.9307485712E-01, 2.1438633891E+00, 3.3830270547E-03, 3.3392125019E-03, 4.6884769694E-01],
	[1.2065000000E+04, 2.9321454856E-01, 2.1435045503E+00, 3.3869296192E-03, 3.3430318722E-03, 4.6900099050E-01],
	[1.2070000000E+04, 2.9335424866E-01, 2.1431459201E+00, 3.3908350658E-03, 3.3468539995E-03, 4.6915423626E-01],
	[1.2075000000E+04, 2.9349395743E-01, 2.1427874985E+00, 3.3947433955E-03, 3.3506788848E-03, 4.6930743421E-01],
	[1.2080000000E+04, 2.9363367485E-01, 2.1424292852E+00, 3.3986546092E-03, 3.3545065288E-03, 4.6946058435E-01],
	[1.2085000000E+04, 2.9377340092E-01, 2.1420712799E+00, 3.4025687078E-03, 3.3583369323E-03, 4.6961368670E-01],
	[1.2090000000E+04, 2.9391313564E-01, 2.1417134825E+00, 3.4064856922E-03, 3.3621700961E-03, 4.6976674124E-01],
	[1.2095000000E+04, 2.9405287901E-01, 2.1413558928E+00, 3.4104055634E-03, 3.3660060210E-03, 4.6991974798E-01],
	[1.2100000000E+04, 2.9419263102E-01, 2.1409985105E+00, 3.4143283223E-03, 3.3698447078E-03, 4.7007270694E-01],
	[1.2105000000E+04, 2.9433239168E-01, 2.1406413355E+00, 3.4182539699E-03, 3.3736861573E-03, 4.7022561809E-01],
	[1.2110000000E+04, 2.9447216097E-01, 2.1402843675E+00, 3.4221825071E-03, 3.3775303703E-03, 4.7037848146E-01],
	[1.2115000000E+04, 2.9461193890E-01, 2.1399276064E+00, 3.4261139347E-03, 3.3813773476E-03, 4.7053129704E-01],
	[1.2120000000E+04, 2.9475172545E-01, 2.1395710520E+00, 3.4300482538E-03, 3.3852270899E-03, 4.7068406483E-01],
	[1.2125000000E+04, 2.9489152064E-01, 2.1392147039E+00, 3.4339854653E-03, 3.3890795980E-03, 4.7083678484E-01],
	[1.2130000000E+04, 2.9503132445E-01, 2.1388585621E+00, 3.4379255701E-03, 3.3929348728E-03, 4.7098945706E-01],
	[1.2135000000E+04, 2.9517113689E-01, 2.1385026263E+00, 3.4418685692E-03, 3.3967929151E-03, 4.7114208151E-01],
	[1.2140000000E+04, 2.9531095794E-01, 2.1381468964E+00, 3.4458144634E-03, 3.4006537255E-03, 4.7129465818E-01],
	[1.2145000000E+04, 2.9545078761E-01, 2.1377913720E+00, 3.4497632537E-03, 3.4045173050E-03, 4.7144718708E-01],
	[1.2150000000E+04, 2.9559062590E-01, 2.1374360531E+00, 3.4537149411E-03, 3.4083836543E-03, 4.7159966821E-01],
	[1.2155000000E+04, 2.9573047279E-01, 2.1370809394E+00, 3.4576695264E-03, 3.4122527742E-03, 4.7175210156E-01],
	[1.2160000000E+04, 2.9587032829E-01, 2.1367260307E+00, 3.4616270107E-03, 3.4161246655E-03, 4.7190448716E-01],
	[1.2165000000E+04, 2.9601019240E-01, 2.1363713268E+00, 3.4655873947E-03, 3.4199993290E-03, 4.7205682499E-01],
	[1.2170000000E+04, 2.9615006511E-01, 2.1360168275E+00, 3.4695506796E-03, 3.4238767655E-03, 4.7220911505E-01],
	[1.2175000000E+04, 2.9628994642E-01, 2.1356625326E+00, 3.4735168661E-03, 3.4277569757E-03, 4.7236135736E-01],
	[1.2180000000E+04, 2.9642983632E-01, 2.1353084420E+00, 3.4774859553E-03, 3.4316399605E-03, 4.7251355192E-01],
	[1.2185000000E+04, 2.9656973481E-01, 2.1349545553E+00, 3.4814579480E-03, 3.4355257206E-03, 4.7266569872E-01],
	[1.2190000000E+04, 2.9670964190E-01, 2.1346008724E+00, 3.4854328452E-03, 3.4394142568E-03, 4.7281779777E-01],
	[1.2195000000E+04, 2.9684955757E-01, 2.1342473931E+00, 3.4894106479E-03, 3.4433055700E-03, 4.7296984908E-01],
	[1.2200000000E+04, 2.9698948182E-01, 2.1338941172E+00, 3.4933913568E-03, 3.4471996608E-03, 4.7312185264E-01],
	[1.2205000000E+04, 2.9712941466E-01, 2.1335410445E+00, 3.4973749731E-03, 3.4510965302E-03, 4.7327380846E-01],
	[1.2210000000E+04, 2.9726935607E-01, 2.1331881748E+00, 3.5013614976E-03, 3.4549961789E-03, 4.7342571655E-01],
	[1.2215000000E+04, 2.9740930605E-01, 2.1328355079E+00, 3.5053509313E-03, 3.4588986076E-03, 4.7357757689E-01],
	[1.2220000000E+04, 2.9754926461E-01, 2.1324830436E+00, 3.5093432750E-03, 3.4628038172E-03, 4.7372938951E-01],
	[1.2225000000E+04, 2.9768923174E-01, 2.1321307817E+00, 3.5133385297E-03, 3.4667118084E-03, 4.7388115440E-01],
	[1.2230000000E+04, 2.9782944904E-01, 2.1317799279E+00, 3.5173366964E-03, 3.4706226181E-03, 4.7403287156E-01],
	[1.2235000000E+04, 2.9797025692E-01, 2.1314321779E+00, 3.5213377759E-03, 3.4745362980E-03, 4.7418454100E-01],
	[1.2240000000E+04, 2.9811107380E-01, 2.1310846266E+00, 3.5253417693E-03, 3.4784527623E-03, 4.7433616271E-01],
	[1.2245000000E+04, 2.9825189968E-01, 2.1307372740E+00, 3.5293486773E-03, 3.4823720118E-03, 4.7448773672E-01],
	[1.2250000000E+04, 2.9839273455E-01, 2.1303901197E+00, 3.5333585011E-03, 3.4862940473E-03, 4.7463926300E-01],
	[1.2255000000E+04, 2.9853357841E-01, 2.1300431636E+00, 3.5373712414E-03, 3.4902188695E-03, 4.7479074158E-01],
	[1.2260000000E+04, 2.9867443125E-01, 2.1296964055E+00, 3.5413868992E-03, 3.4941464794E-03, 4.7494217245E-01],
	[1.2265000000E+04, 2.9881529308E-01, 2.1293498452E+00, 3.5454054755E-03, 3.4980768776E-03, 4.7509355562E-01],
	[1.2270000000E+04, 2.9895616389E-01, 2.1290034825E+00, 3.5494269712E-03, 3.5020100649E-03, 4.7524489108E-01],
	[1.2275000000E+04, 2.9909704368E-01, 2.1286573172E+00, 3.5534513872E-03, 3.5059460422E-03, 4.7539617885E-01],
	[1.2280000000E+04, 2.9923793244E-01, 2.1283113492E+00, 3.5574787244E-03, 3.5098848101E-03, 4.7554741893E-01],
	[1.2285000000E+04, 2.9937883017E-01, 2.1279655781E+00, 3.5615089838E-03, 3.5138263696E-03, 4.7569861131E-01],
	[1.2290000000E+04, 2.9951973687E-01, 2.1276200040E+00, 3.5655421663E-03, 3.5177707214E-03, 4.7584975601E-01],
	[1.2295000000E+04, 2.9966065254E-01, 2.1272746265E+00, 3.5695782729E-03, 3.5217178663E-03, 4.7600085302E-01],
	[1.2300000000E+04, 2.9980157716E-01, 2.1269294454E+00, 3.5736173044E-03, 3.5256678050E-03, 4.7615190235E-01],
	[1.2305000000E+04, 2.9994251075E-01, 2.1265844606E+00, 3.5776592618E-03, 3.5296205383E-03, 4.7630290401E-01],
	[1.2310000000E+04, 3.0008345329E-01, 2.1262396719E+00, 3.5817041460E-03, 3.5335760671E-03, 4.7645385799E-01],
	[1.2315000000E+04, 3.0022440479E-01, 2.1258950790E+00, 3.5857519579E-03, 3.5375343921E-03, 4.7660476431E-01],
	[1.2320000000E+04, 3.0036536523E-01, 2.1255506819E+00, 3.5898026985E-03, 3.5414955142E-03, 4.7675562296E-01],
	[1.2325000000E+04, 3.0050633463E-01, 2.1252064802E+00, 3.5938563688E-03, 3.5454594340E-03, 4.7690643394E-01],
	[1.2330000000E+04, 3.0064731296E-01, 2.1248624739E+00, 3.5979129695E-03, 3.5494261523E-03, 4.7705719725E-01],
	[1.2335000000E+04, 3.0078830024E-01, 2.1245186627E+00, 3.6019725018E-03, 3.5533956701E-03, 4.7720791289E-01],
	[1.2340000000E+04, 3.0092929645E-01, 2.1241750464E+00, 3.6060349664E-03, 3.5573679880E-03, 4.7735858086E-01],
	[1.2345000000E+04, 3.0107030160E-01, 2.1238316249E+00, 3.6101003643E-03, 3.5613431068E-03, 4.7750920114E-01],
	[1.2350000000E+04, 3.0121131568E-01, 2.1234883979E+00, 3.6141686965E-03, 3.5653210273E-03, 4.7765977375E-01],
	[1.2355000000E+04, 3.0135233869E-01, 2.1231453653E+00, 3.6182399639E-03, 3.5693017503E-03, 4.7781029868E-01],
	[1.2360000000E+04, 3.0149337062E-01, 2.1228025268E+00, 3.6223141674E-03, 3.5732852766E-03, 4.7796077594E-01],
	[1.2365000000E+04, 3.0163441147E-01, 2.1224598824E+00, 3.6263913079E-03, 3.5772716070E-03, 4.7811120551E-01],
	[1.2370000000E+04, 3.0177546125E-01, 2.1221174317E+00, 3.6304713864E-03, 3.5812607422E-03, 4.7826158740E-01],
	[1.2375000000E+04, 3.0191651994E-01, 2.1217751747E+00, 3.6345544038E-03, 3.5852526830E-03, 4.7841192162E-01],
	[1.2380000000E+04, 3.0205758754E-01, 2.1214331111E+00, 3.6386403610E-03, 3.5892474303E-03, 4.7856220815E-01],
	[1.2385000000E+04, 3.0219866406E-01, 2.1210912407E+00, 3.6427292589E-03, 3.5932449847E-03, 4.7871244700E-01],
	[1.2390000000E+04, 3.0233974948E-01, 2.1207495633E+00, 3.6468210985E-03, 3.5972453471E-03, 4.7886263816E-01],
	[1.2395000000E+04, 3.0248084380E-01, 2.1204080789E+00, 3.6509158807E-03, 3.6012485183E-03, 4.7901278165E-01],
	[1.2400000000E+04, 3.0262194703E-01, 2.1200667871E+00, 3.6550136065E-03, 3.6052544990E-03, 4.7916287745E-01],
	[1.2405000000E+04, 3.0276305915E-01, 2.1197256878E+00, 3.6591142767E-03, 3.6092632901E-03, 4.7931292557E-01],
	[1.2410000000E+04, 3.0290418017E-01, 2.1193847808E+00, 3.6632178923E-03, 3.6132748922E-03, 4.7946292600E-01],
	[1.2415000000E+04, 3.0304531008E-01, 2.1190440659E+00, 3.6673244542E-03, 3.6172893063E-03, 4.7961287875E-01],
	[1.2420000000E+04, 3.0318644888E-01, 2.1187035429E+00, 3.6714339634E-03, 3.6213065330E-03, 4.7976278381E-01],
	[1.2425000000E+04, 3.0332759656E-01, 2.1183632117E+00, 3.6755464207E-03, 3.6253265732E-03, 4.7991264119E-01],
	[1.2430000000E+04, 3.0346952170E-01, 2.1180267807E+00, 3.6796618272E-03, 3.6293495484E-03, 4.8006245089E-01],
	[1.2435000000E+04, 3.0361152216E-01, 2.1176908569E+00, 3.6837801836E-03, 3.6333753494E-03, 4.8021221290E-01],
	[1.2440000000E+04, 3.0375353193E-01, 2.1173551213E+00, 3.6879014910E-03, 3.6374039666E-03, 4.8036192722E-01],
	[1.2445000000E+04, 3.0389555103E-01, 2.1170195738E+00, 3.6920257503E-03, 3.6414354009E-03, 4.8051159386E-01],
	[1.2450000000E+04, 3.0403757943E-01, 2.1166842143E+00, 3.6961529624E-03, 3.6454696529E-03, 4.8066121282E-01],
	[1.2455000000E+04, 3.0417961715E-01, 2.1163490425E+00, 3.7002831283E-03, 3.6495067234E-03, 4.8081078408E-01],
	[1.2460000000E+04, 3.0432166417E-01, 2.1160140582E+00, 3.7044162488E-03, 3.6535466134E-03, 4.8096030767E-01],
	[1.2465000000E+04, 3.0446372050E-01, 2.1156792614E+00, 3.7085523248E-03, 3.6575893234E-03, 4.8110978356E-01],
	[1.2470000000E+04, 3.0460578613E-01, 2.1153446518E+00, 3.7126913574E-03, 3.6616348543E-03, 4.8125921178E-01],
	[1.2475000000E+04, 3.0474786106E-01, 2.1150102292E+00, 3.7168333475E-03, 3.6656832069E-03, 4.8140859230E-01],
	[1.2480000000E+04, 3.0488994528E-01, 2.1146759934E+00, 3.7209782959E-03, 3.6697343820E-03, 4.8155792515E-01],
	[1.2485000000E+04, 3.0503203879E-01, 2.1143419443E+00, 3.7251262035E-03, 3.6737883803E-03, 4.8170721030E-01],
	[1.2490000000E+04, 3.0517414159E-01, 2.1140080817E+00, 3.7292770715E-03, 3.6778452027E-03, 4.8185644778E-01],
	[1.2495000000E+04, 3.0531625367E-01, 2.1136744055E+00, 3.7334309005E-03, 3.6819048498E-03, 4.8200563756E-01],
	[1.2500000000E+04, 3.0545837504E-01, 2.1133409153E+00, 3.7375876916E-03, 3.6859673225E-03, 4.8215477967E-01],
	[1.2505000000E+04, 3.0560050569E-01, 2.1130076111E+00, 3.7418228451E-03, 3.6901059511E-03, 4.8230387409E-01],
	[1.2510000000E+04, 3.0574264561E-01, 2.1126744927E+00, 3.7460611015E-03, 3.6942475391E-03, 4.8245292082E-01],
	[1.2515000000E+04, 3.0588479481E-01, 2.1123415599E+00, 3.7503024620E-03, 3.6983920874E-03, 4.8260191988E-01],
	[1.2520000000E+04, 3.0602695327E-01, 2.1120088125E+00, 3.7545469276E-03, 3.7025395969E-03, 4.8275087125E-01],
	[1.2525000000E+04, 3.0616912101E-01, 2.1116762503E+00, 3.7587944993E-03, 3.7066900684E-03, 4.8289977494E-01],
	[1.2530000000E+04, 3.0631129800E-01, 2.1113438733E+00, 3.7630451782E-03, 3.7108435029E-03, 4.8304863094E-01],
	[1.2535000000E+04, 3.0645348426E-01, 2.1110116811E+00, 3.7672989653E-03, 3.7149999012E-03, 4.8319743927E-01],
	[1.2540000000E+04, 3.0659567977E-01, 2.1106796736E+00, 3.7715558616E-03, 3.7191592641E-03, 4.8334619991E-01],
	[1.2545000000E+04, 3.0673788454E-01, 2.1103478507E+00, 3.7758158682E-03, 3.7233215926E-03, 4.8349491288E-01],
	[1.2550000000E+04, 3.0688009856E-01, 2.1100162121E+00, 3.7800789861E-03, 3.7274868875E-03, 4.8364357817E-01],
	[1.2555000000E+04, 3.0702232183E-01, 2.1096847577E+00, 3.7843452163E-03, 3.7316551497E-03, 4.8379219577E-01],
	[1.2560000000E+04, 3.0716455434E-01, 2.1093534873E+00, 3.7886145598E-03, 3.7358263800E-03, 4.8394076570E-01],
	[1.2565000000E+04, 3.0730679610E-01, 2.1090224008E+00, 3.7928870177E-03, 3.7400005794E-03, 4.8408928795E-01],
	[1.2570000000E+04, 3.0744904709E-01, 2.1086914979E+00, 3.7971625910E-03, 3.7441777487E-03, 4.8423776253E-01],
	[1.2575000000E+04, 3.0759130732E-01, 2.1083607785E+00, 3.8014412808E-03, 3.7483578887E-03, 4.8438618943E-01],
	[1.2580000000E+04, 3.0773357678E-01, 2.1080302424E+00, 3.8057230880E-03, 3.7525410003E-03, 4.8453456865E-01],
	[1.2585000000E+04, 3.0787585547E-01, 2.1076998894E+00, 3.8100080138E-03, 3.7567270845E-03, 4.8468290020E-01],
	[1.2590000000E+04, 3.0801814339E-01, 2.1073697194E+00, 3.8142960591E-03, 3.7609161420E-03, 4.8483118408E-01],
	[1.2595000000E+04, 3.0816044053E-01, 2.1070397322E+00, 3.8185872249E-03, 3.7651081738E-03, 4.8497942028E-01],
	[1.2600000000E+04, 3.0830274689E-01, 2.1067099276E+00, 3.8228815124E-03, 3.7693031806E-03, 4.8512760882E-01],
	[1.2605000000E+04, 3.0844506247E-01, 2.1063803055E+00, 3.8271789224E-03, 3.7735011635E-03, 4.8527574968E-01],
	[1.2610000000E+04, 3.0858738727E-01, 2.1060508656E+00, 3.8314794562E-03, 3.7777021232E-03, 4.8542384287E-01],
	[1.2615000000E+04, 3.0872972127E-01, 2.1057216078E+00, 3.8357831146E-03, 3.7819060606E-03, 4.8557188840E-01],
	[1.2620000000E+04, 3.0887206449E-01, 2.1053925320E+00, 3.8400898988E-03, 3.7861129765E-03, 4.8571988626E-01],
	[1.2625000000E+04, 3.0901441690E-01, 2.1050636378E+00, 3.8443998097E-03, 3.7903228720E-03, 4.8586783645E-01],
	[1.2630000000E+04, 3.0915755328E-01, 2.1047385359E+00, 3.8487128484E-03, 3.7945358762E-03, 4.8601573898E-01],
	[1.2635000000E+04, 3.0930077170E-01, 2.1044139502E+00, 3.8530290159E-03, 3.7987518740E-03, 4.8616359384E-01],
	[1.2640000000E+04, 3.0944399976E-01, 2.1040895430E+00, 3.8573483132E-03, 3.8029708543E-03, 4.8631140104E-01],
	[1.2645000000E+04, 3.0958723747E-01, 2.1037653140E+00, 3.8616707414E-03, 3.8071928180E-03, 4.8645916058E-01],
	[1.2650000000E+04, 3.0973048481E-01, 2.1034412632E+00, 3.8659963015E-03, 3.8114177659E-03, 4.8660687246E-01],
	[1.2655000000E+04, 3.0987374178E-01, 2.1031173903E+00, 3.8703249946E-03, 3.8156456990E-03, 4.8675453668E-01],
	[1.2660000000E+04, 3.1001700839E-01, 2.1027936951E+00, 3.8746568216E-03, 3.8198766180E-03, 4.8690215325E-01],
	[1.2665000000E+04, 3.1016028462E-01, 2.1024701776E+00, 3.8789917836E-03, 3.8241105239E-03, 4.8704972216E-01],
	[1.2670000000E+04, 3.1030357048E-01, 2.1021468375E+00, 3.8833298816E-03, 3.8283474174E-03, 4.8719724341E-01],
	[1.2675000000E+04, 3.1044686595E-01, 2.1018236747E+00, 3.8876711167E-03, 3.8325872996E-03, 4.8734471701E-01],
	[1.2680000000E+04, 3.1059017105E-01, 2.1015006890E+00, 3.8920154899E-03, 3.8368301712E-03, 4.8749214296E-01],
	[1.2685000000E+04, 3.1073348576E-01, 2.1011778802E+00, 3.8963630021E-03, 3.8410760331E-03, 4.8763952126E-01],
	[1.2690000000E+04, 3.1087681008E-01, 2.1008552483E+00, 3.9007136545E-03, 3.8453248861E-03, 4.8778685191E-01],
	[1.2695000000E+04, 3.1102014401E-01, 2.1005327929E+00, 3.9050674481E-03, 3.8495767312E-03, 4.8793413492E-01],
	[1.2700000000E+04, 3.1116348754E-01, 2.1002105139E+00, 3.9094243839E-03, 3.8538315692E-03, 4.8808137028E-01],
	[1.2705000000E+04, 3.1130684068E-01, 2.0998884112E+00, 3.9137844629E-03, 3.8580894010E-03, 4.8822855799E-01],
	[1.2710000000E+04, 3.1145020342E-01, 2.0995664847E+00, 3.9181476862E-03, 3.8623502275E-03, 4.8837569806E-01],
	[1.2715000000E+04, 3.1159357575E-01, 2.0992447340E+00, 3.9225140548E-03, 3.8666140494E-03, 4.8852279050E-01],
	[1.2720000000E+04, 3.1173695767E-01, 2.0989231592E+00, 3.9268835696E-03, 3.8708808677E-03, 4.8866983529E-01],
	[1.2725000000E+04, 3.1188034918E-01, 2.0986017600E+00, 3.9312562319E-03, 3.8751506832E-03, 4.8881683245E-01],
	[1.2730000000E+04, 3.1202375028E-01, 2.0982805362E+00, 3.9356320424E-03, 3.8794234968E-03, 4.8896378197E-01],
	[1.2735000000E+04, 3.1216716097E-01, 2.0979594877E+00, 3.9400110024E-03, 3.8836993094E-03, 4.8911068386E-01],
	[1.2740000000E+04, 3.1231058123E-01, 2.0976386143E+00, 3.9443931129E-03, 3.8879781218E-03, 4.8925753812E-01],
	[1.2745000000E+04, 3.1245401107E-01, 2.0973179159E+00, 3.9487783748E-03, 3.8922599349E-03, 4.8940434475E-01],
	[1.2750000000E+04, 3.1259745049E-01, 2.0969973922E+00, 3.9531667892E-03, 3.8965447495E-03, 4.8955110375E-01],
	[1.2755000000E+04, 3.1274089947E-01, 2.0966770432E+00, 3.9575583571E-03, 3.9008325666E-03, 4.8969781513E-01],
	[1.2760000000E+04, 3.1288435802E-01, 2.0963568686E+00, 3.9619530795E-03, 3.9051233869E-03, 4.8984447888E-01],
	[1.2765000000E+04, 3.1302782614E-01, 2.0960368684E+00, 3.9663509576E-03, 3.9094172114E-03, 4.8999109501E-01],
	[1.2770000000E+04, 3.1317130382E-01, 2.0957170423E+00, 3.9707519922E-03, 3.9137140409E-03, 4.9013766352E-01],
	[1.2775000000E+04, 3.1331479106E-01, 2.0953973901E+00, 3.9751561845E-03, 3.9180138763E-03, 4.9028418442E-01],
	[1.2780000000E+04, 3.1345828785E-01, 2.0950779118E+00, 3.9795635354E-03, 3.9223167183E-03, 4.9043065770E-01],
	[1.2785000000E+04, 3.1360179420E-01, 2.0947586071E+00, 3.9839740460E-03, 3.9266225680E-03, 4.9057708336E-01],
	[1.2790000000E+04, 3.1374531009E-01, 2.0944394759E+00, 3.9883877173E-03, 3.9309314262E-03, 4.9072346142E-01],
	[1.2795000000E+04, 3.1388883553E-01, 2.0941205180E+00, 3.9928045504E-03, 3.9352432936E-03, 4.9086979186E-01],
	[1.2800000000E+04, 3.1403237051E-01, 2.0938017333E+00, 3.9972245463E-03, 3.9395581712E-03, 4.9101607470E-01],
	[1.2805000000E+04, 3.1417591504E-01, 2.0934831216E+00, 4.0016477059E-03, 3.9438760599E-03, 4.9116230994E-01],
	[1.2810000000E+04, 3.1431946910E-01, 2.0931646827E+00, 4.0060740304E-03, 3.9481969605E-03, 4.9130849757E-01],
	[1.2815000000E+04, 3.1446303269E-01, 2.0928464165E+00, 4.0105035208E-03, 3.9525208738E-03, 4.9145463760E-01],
	[1.2820000000E+04, 3.1460660581E-01, 2.0925283229E+00, 4.0149361780E-03, 3.9568478008E-03, 4.9160073004E-01],
	[1.2825000000E+04, 3.1475018846E-01, 2.0922104015E+00, 4.0193720031E-03, 3.9611777422E-03, 4.9174677488E-01],
	[1.2830000000E+04, 3.1489400794E-01, 2.0918936749E+00, 4.0238109972E-03, 3.9655107387E-03, 4.9189277213E-01],
	[1.2835000000E+04, 3.1503847067E-01, 2.0915799682E+00, 4.0282531613E-03, 3.9698468624E-03, 4.9203872178E-01],
	[1.2840000000E+04, 3.1518294336E-01, 2.0912664307E+00, 4.0326984963E-03, 3.9741860037E-03, 4.9218462386E-01],
	[1.2845000000E+04, 3.1532742603E-01, 2.0909530623E+00, 4.0371470034E-03, 3.9785281634E-03, 4.9233047834E-01],
	[1.2850000000E+04, 3.1547191865E-01, 2.0906398627E+00, 4.0415986835E-03, 3.9828733423E-03, 4.9247628524E-01],
	[1.2855000000E+04, 3.1561642124E-01, 2.0903268319E+00, 4.0460535377E-03, 3.9872215414E-03, 4.9262204457E-01],
	[1.2860000000E+04, 3.1576093379E-01, 2.0900139696E+00, 4.0505115670E-03, 3.9915727615E-03, 4.9276775631E-01],
	[1.2865000000E+04, 3.1590545629E-01, 2.0897012758E+00, 4.0549727725E-03, 3.9959270034E-03, 4.9291342048E-01],
	[1.2870000000E+04, 3.1604998874E-01, 2.0893887502E+00, 4.0594371551E-03, 4.0002842680E-03, 4.9305903708E-01],
	[1.2875000000E+04, 3.1619453113E-01, 2.0890763927E+00, 4.0639047159E-03, 4.0046445562E-03, 4.9320460611E-01],
	[1.2880000000E+04, 3.1633908348E-01, 2.0887642032E+00, 4.0683754559E-03, 4.0090078688E-03, 4.9335012757E-01],
	[1.2885000000E+04, 3.1648364576E-01, 2.0884521814E+00, 4.0728493761E-03, 4.0133742067E-03, 4.9349560147E-01],
	[1.2890000000E+04, 3.1662821798E-01, 2.0881403273E+00, 4.0773264776E-03, 4.0177435707E-03, 4.9364102780E-01],
	[1.2895000000E+04, 3.1677280014E-01, 2.0878286407E+00, 4.0818067614E-03, 4.0221159618E-03, 4.9378640658E-01],
	[1.2900000000E+04, 3.1691739223E-01, 2.0875171214E+00, 4.0862902285E-03, 4.0264913807E-03, 4.9393173780E-01],
	[1.2905000000E+04, 3.1706199424E-01, 2.0872057693E+00, 4.0907768800E-03, 4.0308698284E-03, 4.9407702147E-01],
	[1.2910000000E+04, 3.1720660619E-01, 2.0868945842E+00, 4.0952667169E-03, 4.0352513056E-03, 4.9422225759E-01],
	[1.2915000000E+04, 3.1735122805E-01, 2.0865835660E+00, 4.0997597401E-03, 4.0396358133E-03, 4.9436744616E-01],
	[1.2920000000E+04, 3.1749585984E-01, 2.0862727145E+00, 4.1042559508E-03, 4.0440233522E-03, 4.9451258719E-01],
	[1.2925000000E+04, 3.1764050154E-01, 2.0859620295E+00, 4.1087553499E-03, 4.0484139234E-03, 4.9465768068E-01],
	[1.2930000000E+04, 3.1778515315E-01, 2.0856515110E+00, 4.1132579385E-03, 4.0528075275E-03, 4.9480272662E-01],
	[1.2935000000E+04, 3.1792981467E-01, 2.0853411587E+00, 4.1177637176E-03, 4.0572041655E-03, 4.9494772504E-01],
	[1.2940000000E+04, 3.1807448610E-01, 2.0850309725E+00, 4.1222726883E-03, 4.0616038383E-03, 4.9509267592E-01],
	[1.2945000000E+04, 3.1821916743E-01, 2.0847209522E+00, 4.1267848515E-03, 4.0660065466E-03, 4.9523757927E-01],
	[1.2950000000E+04, 3.1836385866E-01, 2.0844110978E+00, 4.1313002083E-03, 4.0704122914E-03, 4.9538243510E-01],
	[1.2955000000E+04, 3.1850855979E-01, 2.0841014089E+00, 4.1358187597E-03, 4.0748210735E-03, 4.9552724340E-01],
	[1.2960000000E+04, 3.1865327082E-01, 2.0837918856E+00, 4.1403405067E-03, 4.0792328937E-03, 4.9567200418E-01],
	[1.2965000000E+04, 3.1879799173E-01, 2.0834825276E+00, 4.1448654504E-03, 4.0836477530E-03, 4.9581671745E-01],
	[1.2970000000E+04, 3.1894272253E-01, 2.0831733348E+00, 4.1493935918E-03, 4.0880656521E-03, 4.9596138320E-01],
	[1.2975000000E+04, 3.1908746322E-01, 2.0828643070E+00, 4.1539249319E-03, 4.0924865919E-03, 4.9610600145E-01],
	[1.2980000000E+04, 3.1923221379E-01, 2.0825554441E+00, 4.1584594717E-03, 4.0969105734E-03, 4.9625057218E-01],
	[1.2985000000E+04, 3.1937697423E-01, 2.0822467459E+00, 4.1629972123E-03, 4.1013375972E-03, 4.9639509542E-01],
	[1.2990000000E+04, 3.1952174456E-01, 2.0819382123E+00, 4.1675381547E-03, 4.1057676644E-03, 4.9653957115E-01],
	[1.2995000000E+04, 3.1966652475E-01, 2.0816298431E+00, 4.1720822999E-03, 4.1102007757E-03, 4.9668399939E-01],
	[1.3000000000E+04, 3.1981131481E-01, 2.0813216382E+00, 4.1766296490E-03, 4.1146369320E-03, 4.9682838013E-01],
	[1.3005000000E+04, 3.1995611474E-01, 2.0810135974E+00, 4.1811802029E-03, 4.1190761342E-03, 4.9697271339E-01],
	[1.3010000000E+04, 3.2010092453E-01, 2.0807057206E+00, 4.1857339627E-03, 4.1235183831E-03, 4.9711699915E-01],
	[1.3015000000E+04, 3.2024574418E-01, 2.0803980076E+00, 4.1902909295E-03, 4.1279636795E-03, 4.9726123744E-01],
	[1.3020000000E+04, 3.2039057369E-01, 2.0800904583E+00, 4.1948511041E-03, 4.1324120244E-03, 4.9740542824E-01],
	[1.3025000000E+04, 3.2053541305E-01, 2.0797830725E+00, 4.1994144878E-03, 4.1368634186E-03, 4.9754957157E-01],
	[1.3030000000E+04, 3.2068026226E-01, 2.0794758501E+00, 4.2039810814E-03, 4.1413178628E-03, 4.9769366743E-01],
	[1.3035000000E+04, 3.2082512131E-01, 2.0791687909E+00, 4.2085508860E-03, 4.1457753581E-03, 4.9783771582E-01],
	[1.3040000000E+04, 3.2097082935E-01, 2.0788655360E+00, 4.2131239027E-03, 4.1502360600E-03, 4.9798171674E-01],
	[1.3045000000E+04, 3.2111658335E-01, 2.0785625963E+00, 4.2177001325E-03, 4.1546998217E-03, 4.9812567020E-01],
	[1.3050000000E+04, 3.2126234764E-01, 2.0782598168E+00, 4.2222795763E-03, 4.1591666374E-03, 4.9826957620E-01],
	[1.3055000000E+04, 3.2140812222E-01, 2.0779571974E+00, 4.2268622353E-03, 4.1636365081E-03, 4.9841343475E-01],
	[1.3060000000E+04, 3.2155390709E-01, 2.0776547379E+00, 4.2314481104E-03, 4.1681094344E-03, 4.9855724585E-01],
	[1.3065000000E+04, 3.2169970225E-01, 2.0773524382E+00, 4.2360372027E-03, 4.1725854174E-03, 4.9870100950E-01],
	[1.3070000000E+04, 3.2184550768E-01, 2.0770502981E+00, 4.2406295131E-03, 4.1770644579E-03, 4.9884472571E-01],
	[1.3075000000E+04, 3.2199132340E-01, 2.0767483175E+00, 4.2452250428E-03, 4.1815465567E-03, 4.9898839448E-01],
	[1.3080000000E+04, 3.2213714939E-01, 2.0764464962E+00, 4.2498237927E-03, 4.1860317146E-03, 4.9913201580E-01],
	[1.3085000000E+04, 3.2228298565E-01, 2.0761448342E+00, 4.2544257639E-03, 4.1905199326E-03, 4.9927558967E-01],
	[1.3090000000E+04, 3.2242883218E-01, 2.0758433311E+00, 4.2590309573E-03, 4.1950112115E-03, 4.9941911610E-01],
	[1.3095000000E+04, 3.2257468898E-01, 2.0755419870E+00, 4.2636393741E-03, 4.1995055520E-03, 4.9956259509E-01],
	[1.3100000000E+04, 3.2272055603E-01, 2.0752408016E+00, 4.2682510152E-03, 4.2040029552E-03, 4.9970602663E-01],
	[1.3105000000E+04, 3.2286643335E-01, 2.0749397749E+00, 4.2728658817E-03, 4.2085034218E-03, 4.9984941072E-01],
	[1.3110000000E+04, 3.2301232092E-01, 2.0746389066E+00, 4.2774839745E-03, 4.2130069526E-03, 4.9999274737E-01],
	[1.3115000000E+04, 3.2315821875E-01, 2.0743381967E+00, 4.2821052948E-03, 4.2175135487E-03, 5.0013603658E-01],
	[1.3120000000E+04, 3.2330412682E-01, 2.0740376449E+00, 4.2867298434E-03, 4.2220232106E-03, 5.0027927834E-01],
	[1.3125000000E+04, 3.2345004514E-01, 2.0737372512E+00, 4.2913576216E-03, 4.2265359395E-03, 5.0042247266E-01],
	[1.3130000000E+04, 3.2359597371E-01, 2.0734370153E+00, 4.2959886302E-03, 4.2310517360E-03, 5.0056561954E-01],
	[1.3135000000E+04, 3.2374191251E-01, 2.0731369372E+00, 4.3006228703E-03, 4.2355706011E-03, 5.0070871898E-01],
	[1.3140000000E+04, 3.2388786155E-01, 2.0728370168E+00, 4.3052603430E-03, 4.2400925355E-03, 5.0085177098E-01],
	[1.3145000000E+04, 3.2403382082E-01, 2.0725372538E+00, 4.3099010492E-03, 4.2446175402E-03, 5.0099477554E-01],
	[1.3150000000E+04, 3.2417979033E-01, 2.0722376481E+00, 4.3145449899E-03, 4.2491456160E-03, 5.0113773266E-01],
	[1.3155000000E+04, 3.2432577006E-01, 2.0719381996E+00, 4.3191921663E-03, 4.2536767637E-03, 5.0128064234E-01],
	[1.3160000000E+04, 3.2447176001E-01, 2.0716389082E+00, 4.3238425793E-03, 4.2582109842E-03, 5.0142350459E-01],
	[1.3165000000E+04, 3.2461776019E-01, 2.0713397736E+00, 4.3284962299E-03, 4.2627482784E-03, 5.0156631940E-01],
	[1.3170000000E+04, 3.2476377058E-01, 2.0710407958E+00, 4.3331531192E-03, 4.2672886470E-03, 5.0170908677E-01],
	[1.3175000000E+04, 3.2490979119E-01, 2.0707419746E+00, 4.3378132481E-03, 4.2718320910E-03, 5.0185180671E-01],
	[1.3180000000E+04, 3.2505582201E-01, 2.0704433099E+00, 4.3424766178E-03, 4.2763786112E-03, 5.0199447921E-01],
	[1.3185000000E+04, 3.2520186304E-01, 2.0701448016E+00, 4.3471432292E-03, 4.2809282084E-03, 5.0213710428E-01],
	[1.3190000000E+04, 3.2534791427E-01, 2.0698464494E+00, 4.3518130834E-03, 4.2854808835E-03, 5.0227968192E-01],
	[1.3195000000E+04, 3.2549397570E-01, 2.0695482533E+00, 4.3564861813E-03, 4.2900366373E-03, 5.0242221213E-01],
	[1.3200000000E+04, 3.2564004733E-01, 2.0692502130E+00, 4.3611625241E-03, 4.2945954707E-03, 5.0256469491E-01],
	[1.3205000000E+04, 3.2578612916E-01, 2.0689523286E+00, 4.3658421127E-03, 4.2991573846E-03, 5.0270713026E-01],
	[1.3210000000E+04, 3.2593222118E-01, 2.0686545998E+00, 4.3705249481E-03, 4.3037223797E-03, 5.0284951819E-01],
	[1.3215000000E+04, 3.2607832339E-01, 2.0683570264E+00, 4.3752110314E-03, 4.3082904569E-03, 5.0299185868E-01],
	[1.3220000000E+04, 3.2622443579E-01, 2.0680596085E+00, 4.3799003636E-03, 4.3128616171E-03, 5.0313415175E-01],
	[1.3225000000E+04, 3.2637055837E-01, 2.0677623457E+00, 4.3845929457E-03, 4.3174358612E-03, 5.0327639740E-01],
	[1.3230000000E+04, 3.2651669112E-01, 2.0674652380E+00, 4.3892887787E-03, 4.3220131899E-03, 5.0341859563E-01],
	[1.3235000000E+04, 3.2666283406E-01, 2.0671682852E+00, 4.3939878637E-03, 4.3265936041E-03, 5.0356074643E-01],
	[1.3240000000E+04, 3.2680898717E-01, 2.0668714872E+00, 4.3986902017E-03, 4.3311771047E-03, 5.0370284982E-01],
	[1.3245000000E+04, 3.2695515045E-01, 2.0665748439E+00, 4.4033957937E-03, 4.3357636925E-03, 5.0384490579E-01],
	[1.3250000000E+04, 3.2710220338E-01, 2.0662820382E+00, 4.4081046407E-03, 4.3403535395E-03, 5.0398691434E-01],
	[1.3255000000E+04, 3.2724927634E-01, 2.0659894239E+00, 4.4128167438E-03, 4.3449464777E-03, 5.0412887547E-01],
	[1.3260000000E+04, 3.2739635993E-01, 2.0656969614E+00, 4.4175321039E-03, 4.3495425062E-03, 5.0427078919E-01],
	[1.3265000000E+04, 3.2754345413E-01, 2.0654046505E+00, 4.4222507222E-03, 4.3541416259E-03, 5.0441265550E-01],
	[1.3270000000E+04, 3.2769055896E-01, 2.0651124911E+00, 4.4269725995E-03, 4.3587438375E-03, 5.0455447439E-01],
	[1.3275000000E+04, 3.2783767439E-01, 2.0648204830E+00, 4.4316977370E-03, 4.3633491419E-03, 5.0469624588E-01],
	[1.3280000000E+04, 3.2798480043E-01, 2.0645286262E+00, 4.4364261356E-03, 4.3679575400E-03, 5.0483796996E-01],
	[1.3285000000E+04, 3.2813193708E-01, 2.0642369205E+00, 4.4411577964E-03, 4.3725690326E-03, 5.0497964663E-01],
	[1.3290000000E+04, 3.2827908434E-01, 2.0639453657E+00, 4.4458927204E-03, 4.3771836206E-03, 5.0512127589E-01],
	[1.3295000000E+04, 3.2842624219E-01, 2.0636539618E+00, 4.4506309087E-03, 4.3818013048E-03, 5.0526285776E-01],
	[1.3300000000E+04, 3.2857341064E-01, 2.0633627086E+00, 4.4553723621E-03, 4.3864220860E-03, 5.0540439222E-01],
	[1.3305000000E+04, 3.2872058968E-01, 2.0630716059E+00, 4.4601170819E-03, 4.3910459651E-03, 5.0554587928E-01],
	[1.3310000000E+04, 3.2886777931E-01, 2.0627806536E+00, 4.4648650689E-03, 4.3956729429E-03, 5.0568731895E-01],
	[1.3315000000E+04, 3.2901497953E-01, 2.0624898517E+00, 4.4696163242E-03, 4.4003030204E-03, 5.0582871121E-01],
	[1.3320000000E+04, 3.2916219033E-01, 2.0621991998E+00, 4.4743708489E-03, 4.4049361983E-03, 5.0597005609E-01],
	[1.3325000000E+04, 3.2930941171E-01, 2.0619086980E+00, 4.4791286439E-03, 4.4095724774E-03, 5.0611135357E-01],
	[1.3330000000E+04, 3.2945664367E-01, 2.0616183461E+00, 4.4838897103E-03, 4.4142118587E-03, 5.0625260366E-01],
	[1.3335000000E+04, 3.2960388621E-01, 2.0613281439E+00, 4.4886540491E-03, 4.4188543429E-03, 5.0639380636E-01],
	[1.3340000000E+04, 3.2975113931E-01, 2.0610380914E+00, 4.4934216613E-03, 4.4234999309E-03, 5.0653496168E-01],
	[1.3345000000E+04, 3.2989840298E-01, 2.0607481883E+00, 4.4981925479E-03, 4.4281486236E-03, 5.0667606961E-01],
	[1.3350000000E+04, 3.3004567722E-01, 2.0604584346E+00, 4.5029667100E-03, 4.4328004218E-03, 5.0681713016E-01],
	[1.3355000000E+04, 3.3019296202E-01, 2.0601688301E+00, 4.5077441485E-03, 4.4374553263E-03, 5.0695814333E-01],
	[1.3360000000E+04, 3.3034025737E-01, 2.0598793747E+00, 4.5125248646E-03, 4.4421133380E-03, 5.0709910911E-01],
	[1.3365000000E+04, 3.3048756328E-01, 2.0595900683E+00, 4.5173088592E-03, 4.4467744577E-03, 5.0724002753E-01],
	[1.3370000000E+04, 3.3063487974E-01, 2.0593009107E+00, 4.5220961333E-03, 4.4514386863E-03, 5.0738089857E-01],
	[1.3375000000E+04, 3.3078220675E-01, 2.0590119017E+00, 4.5268866879E-03, 4.4561060246E-03, 5.0752172223E-01],
	[1.3380000000E+04, 3.3092954431E-01, 2.0587230414E+00, 4.5316805242E-03, 4.4607764734E-03, 5.0766249853E-01],
	[1.3385000000E+04, 3.3107689240E-01, 2.0584343294E+00, 4.5364776430E-03, 4.4654500337E-03, 5.0780322746E-01],
	[1.3390000000E+04, 3.3122425104E-01, 2.0581457658E+00, 4.5412780454E-03, 4.4701267062E-03, 5.0794390902E-01],
	[1.3395000000E+04, 3.3137162021E-01, 2.0578573503E+00, 4.5460817325E-03, 4.4748064917E-03, 5.0808454322E-01],
	[1.3400000000E+04, 3.3151899991E-01, 2.0575690828E+00, 4.5508887053E-03, 4.4794893912E-03, 5.0822513006E-01],
	[1.3405000000E+04, 3.3166639015E-01, 2.0572809633E+00, 4.5556989647E-03, 4.4841754054E-03, 5.0836566954E-01],
	[1.3410000000E+04, 3.3181379091E-01, 2.0569929915E+00, 4.5605125119E-03, 4.4888645352E-03, 5.0850616166E-01],
	[1.3415000000E+04, 3.3196120219E-01, 2.0567051673E+00, 4.5653293477E-03, 4.4935567815E-03, 5.0864660643E-01],
	[1.3420000000E+04, 3.3210862399E-01, 2.0564174907E+00, 4.5701494733E-03, 4.4982521451E-03, 5.0878700385E-01],
	[1.3425000000E+04, 3.3225605631E-01, 2.0561299614E+00, 4.5749728897E-03, 4.5029506268E-03, 5.0892735392E-01],
	[1.3430000000E+04, 3.3240349914E-01, 2.0558425794E+00, 4.5797995978E-03, 4.5076522274E-03, 5.0906765665E-01],
	[1.3435000000E+04, 3.3255095248E-01, 2.0555553445E+00, 4.5846295987E-03, 4.5123569479E-03, 5.0920791203E-01],
	[1.3440000000E+04, 3.3269841633E-01, 2.0552682566E+00, 4.5894628935E-03, 4.5170647890E-03, 5.0934812007E-01],
	[1.3445000000E+04, 3.3284589068E-01, 2.0549813155E+00, 4.5942994830E-03, 4.5217757516E-03, 5.0948828077E-01],
	[1.3450000000E+04, 3.3299337553E-01, 2.0546945212E+00, 4.5991393685E-03, 4.5264898365E-03, 5.0962839413E-01],
	[1.3455000000E+04, 3.3314087089E-01, 2.0544078735E+00, 4.6039825508E-03, 4.5312070445E-03, 5.0976846016E-01],
	[1.3460000000E+04, 3.3328868732E-01, 2.0541226282E+00, 4.6088290310E-03, 4.5359274403E-03, 5.0990847886E-01],
	[1.3465000000E+04, 3.3343710697E-01, 2.0538399233E+00, 4.6136788101E-03, 4.5406510826E-03, 5.1004845023E-01],
	[1.3470000000E+04, 3.3358553758E-01, 2.0535573622E+00, 4.6185318892E-03, 4.5453778512E-03, 5.1018837428E-01],
	[1.3475000000E+04, 3.3373397914E-01, 2.0532749449E+00, 4.6233882692E-03, 4.5501077469E-03, 5.1032825100E-01],
	[1.3480000000E+04, 3.3388243164E-01, 2.0529926711E+00, 4.6282479512E-03, 4.5548407705E-03, 5.1046808040E-01],
	[1.3485000000E+04, 3.3403089509E-01, 2.0527105408E+00, 4.6331109362E-03, 4.5595769229E-03, 5.1060786249E-01],
	[1.3490000000E+04, 3.3417936949E-01, 2.0524285539E+00, 4.6379772252E-03, 4.5643162049E-03, 5.1074759726E-01],
	[1.3495000000E+04, 3.3432785482E-01, 2.0521467102E+00, 4.6428468192E-03, 4.5690586173E-03, 5.1088728472E-01],
	[1.3500000000E+04, 3.3447635108E-01, 2.0518650095E+00, 4.6477197193E-03, 4.5738041610E-03, 5.1102692488E-01],
	[1.3505000000E+04, 3.3462485828E-01, 2.0515834518E+00, 4.6525959264E-03, 4.5785528368E-03, 5.1116651772E-01],
	[1.3510000000E+04, 3.3477337641E-01, 2.0513020370E+00, 4.6574754416E-03, 4.5833046455E-03, 5.1130606327E-01],
	[1.3515000000E+04, 3.3492190546E-01, 2.0510207649E+00, 4.6623582660E-03, 4.5880595881E-03, 5.1144556151E-01],
	[1.3520000000E+04, 3.3507044543E-01, 2.0507396353E+00, 4.6672444004E-03, 4.5928176652E-03, 5.1158501246E-01],
	[1.3525000000E+04, 3.3521899632E-01, 2.0504586482E+00, 4.6721338460E-03, 4.5975788779E-03, 5.1172441611E-01],
	[1.3530000000E+04, 3.3536755813E-01, 2.0501778035E+00, 4.6770266038E-03, 4.6023432268E-03, 5.1186377248E-01],
	[1.3535000000E+04, 3.3551613084E-01, 2.0498971009E+00, 4.6819226747E-03, 4.6071107129E-03, 5.1200308155E-01],
	[1.3540000000E+04, 3.3566471447E-01, 2.0496165405E+00, 4.6868220598E-03, 4.6118813370E-03, 5.1214234335E-01],
	[1.3545000000E+04, 3.3581330900E-01, 2.0493361220E+00, 4.6917247602E-03, 4.6166550999E-03, 5.1228155786E-01],
	[1.3550000000E+04, 3.3596191444E-01, 2.0490558453E+00, 4.6966307768E-03, 4.6214320024E-03, 5.1242072509E-01],
	[1.3555000000E+04, 3.3611053077E-01, 2.0487757104E+00, 4.7015401106E-03, 4.6262120455E-03, 5.1255984505E-01],
	[1.3560000000E+04, 3.3625915800E-01, 2.0484957171E+00, 4.7064527627E-03, 4.6309952298E-03, 5.1269891774E-01],
	[1.3565000000E+04, 3.3640779613E-01, 2.0482158652E+00, 4.7113687341E-03, 4.6357815564E-03, 5.1283794316E-01],
	[1.3570000000E+04, 3.3655644514E-01, 2.0479361547E+00, 4.7162880258E-03, 4.6405710259E-03, 5.1297692131E-01],
	[1.3575000000E+04, 3.3670510504E-01, 2.0476565853E+00, 4.7212106389E-03, 4.6453636393E-03, 5.1311585220E-01],
	[1.3580000000E+04, 3.3685377582E-01, 2.0473771571E+00, 4.7261365742E-03, 4.6501593973E-03, 5.1325473584E-01],
	[1.3585000000E+04, 3.3700245749E-01, 2.0470978699E+00, 4.7310658330E-03, 4.6549583009E-03, 5.1339357222E-01],
	[1.3590000000E+04, 3.3715115002E-01, 2.0468187235E+00, 4.7359984161E-03, 4.6597603508E-03, 5.1353236134E-01],
	[1.3595000000E+04, 3.3729985344E-01, 2.0465397178E+00, 4.7409343246E-03, 4.6645655478E-03, 5.1367110322E-01],
	[1.3600000000E+04, 3.3744856772E-01, 2.0462608528E+00, 4.7458735595E-03, 4.6693738929E-03, 5.1380979786E-01],
	[1.3605000000E+04, 3.3759729287E-01, 2.0459821282E+00, 4.7508161218E-03, 4.6741853869E-03, 5.1394844525E-01],
	[1.3610000000E+04, 3.3774602888E-01, 2.0457035440E+00, 4.7557620126E-03, 4.6790000305E-03, 5.1408704541E-01],
	[1.3615000000E+04, 3.3789477576E-01, 2.0454251000E+00, 4.7607112329E-03, 4.6838178246E-03, 5.1422559833E-01],
	[1.3620000000E+04, 3.3804353349E-01, 2.0451467961E+00, 4.7656637836E-03, 4.6886387701E-03, 5.1436410402E-01],
	[1.3625000000E+04, 3.3819230208E-01, 2.0448686323E+00, 4.7706196659E-03, 4.6934628678E-03, 5.1450256248E-01],
	[1.3630000000E+04, 3.3834108152E-01, 2.0445906083E+00, 4.7755788806E-03, 4.6982901185E-03, 5.1464097373E-01],
	[1.3635000000E+04, 3.3848987180E-01, 2.0443127240E+00, 4.7805414289E-03, 4.7031205230E-03, 5.1477933775E-01],
	[1.3640000000E+04, 3.3863867293E-01, 2.0440349794E+00, 4.7855073118E-03, 4.7079540822E-03, 5.1491765455E-01],
	[1.3645000000E+04, 3.3878748490E-01, 2.0437573743E+00, 4.7904765302E-03, 4.7127907970E-03, 5.1505592415E-01],
	[1.3650000000E+04, 3.3893630772E-01, 2.0434799086E+00, 4.7954490852E-03, 4.7176306681E-03, 5.1519414653E-01],
	[1.3655000000E+04, 3.3908514136E-01, 2.0432025821E+00, 4.8004249778E-03, 4.7224736964E-03, 5.1533232171E-01],
	[1.3660000000E+04, 3.3923398584E-01, 2.0429253948E+00, 4.8054042090E-03, 4.7273198827E-03, 5.1547044969E-01],
	[1.3665000000E+04, 3.3938284114E-01, 2.0426483465E+00, 4.8103867799E-03, 4.7321692279E-03, 5.1560853047E-01],
	[1.3670000000E+04, 3.3953170728E-01, 2.0423714372E+00, 4.8153726914E-03, 4.7370217327E-03, 5.1574656406E-01],
	[1.3675000000E+04, 3.3968059519E-01, 2.0420947094E+00, 4.8203619446E-03, 4.7418774004E-03, 5.1588455046E-01],
	[1.3680000000E+04, 3.3983040058E-01, 2.0418216581E+00, 4.8253545405E-03, 4.7467364255E-03, 5.1602248967E-01],
	[1.3685000000E+04, 3.3998021724E-01, 2.0415487432E+00, 4.8303504801E-03, 4.7515986134E-03, 5.1616038170E-01],
	[1.3690000000E+04, 3.4013004520E-01, 2.0412759644E+00, 4.8353497644E-03, 4.7564639648E-03, 5.1629822655E-01],
	[1.3695000000E+04, 3.4027988443E-01, 2.0410033216E+00, 4.8403523944E-03, 4.7613324807E-03, 5.1643602423E-01],
	[1.3700000000E+04, 3.4042973494E-01, 2.0407308147E+00, 4.8453583712E-03, 4.7662041619E-03, 5.1657377474E-01],
	[1.3705000000E+04, 3.4057959672E-01, 2.0404584437E+00, 4.8503676957E-03, 4.7710790091E-03, 5.1671147809E-01],
	[1.3710000000E+04, 3.4072946978E-01, 2.0401862083E+00, 4.8553803691E-03, 4.7759570233E-03, 5.1684913427E-01],
	[1.3715000000E+04, 3.4087935410E-01, 2.0399141085E+00, 4.8603963922E-03, 4.7808382052E-03, 5.1698674329E-01],
	[1.3720000000E+04, 3.4102924969E-01, 2.0396421442E+00, 4.8654157662E-03, 4.7857225558E-03, 5.1712430516E-01],
	[1.3725000000E+04, 3.4117915654E-01, 2.0393703151E+00, 4.8704384920E-03, 4.7906100757E-03, 5.1726181988E-01],
	[1.3730000000E+04, 3.4132907464E-01, 2.0390986213E+00, 4.8754645706E-03, 4.7955007659E-03, 5.1739928746E-01],
	[1.3735000000E+04, 3.4147900400E-01, 2.0388270626E+00, 4.8804940031E-03, 4.8003946272E-03, 5.1753670790E-01],
	[1.3740000000E+04, 3.4162894462E-01, 2.0385556389E+00, 4.8855267905E-03, 4.8052916604E-03, 5.1767408119E-01],
	[1.3745000000E+04, 3.4177889648E-01, 2.0382843501E+00, 4.8905629338E-03, 4.8101918664E-03, 5.1781140736E-01],
	[1.3750000000E+04, 3.4192885958E-01, 2.0380131960E+00, 4.8956024340E-03, 4.8150952459E-03, 5.1794868639E-01],
	[1.3755000000E+04, 3.4207883393E-01, 2.0377421765E+00, 4.9006452921E-03, 4.8200017998E-03, 5.1808591831E-01],
	[1.3760000000E+04, 3.4222881952E-01, 2.0374712916E+00, 4.9056915092E-03, 4.8249115290E-03, 5.1822310310E-01],
	[1.3765000000E+04, 3.4237881634E-01, 2.0372005410E+00, 4.9107410862E-03, 4.8298244342E-03, 5.1836024077E-01],
	[1.3770000000E+04, 3.4252882439E-01, 2.0369299248E+00, 4.9157940242E-03, 4.8347405164E-03, 5.1849733134E-01],
	[1.3775000000E+04, 3.4267884367E-01, 2.0366594427E+00, 4.9208503242E-03, 4.8396597762E-03, 5.1863437480E-01],
	[1.3780000000E+04, 3.4282887418E-01, 2.0363890947E+00, 4.9259099872E-03, 4.8445822146E-03, 5.1877137116E-01],
	[1.3785000000E+04, 3.4297891591E-01, 2.0361188806E+00, 4.9309730142E-03, 4.8495078324E-03, 5.1890832048E-01],
	[1.3790000000E+04, 3.4312896885E-01, 2.0358488003E+00, 4.9360394063E-03, 4.8544366304E-03, 5.1904522278E-01],
	[1.3795000000E+04, 3.4327903302E-01, 2.0355788538E+00, 4.9411091644E-03, 4.8593686094E-03, 5.1918207806E-01],
	[1.3800000000E+04, 3.4342910839E-01, 2.0353090409E+00, 4.9461822896E-03, 4.8643037703E-03, 5.1931888632E-01],
	[1.3805000000E+04, 3.4357919498E-01, 2.0350393614E+00, 4.9512587829E-03, 4.8692421139E-03, 5.1945564756E-01],
	[1.3810000000E+04, 3.4372929277E-01, 2.0347698153E+00, 4.9563386452E-03, 4.8741836411E-03, 5.1959236177E-01],
	[1.3815000000E+04, 3.4387940177E-01, 2.0345004025E+00, 4.9614218777E-03, 4.8791283525E-03, 5.1972902897E-01],
	[1.3820000000E+04, 3.4402952196E-01, 2.0342311228E+00, 4.9665084813E-03, 4.8840762492E-03, 5.1986564915E-01],
	[1.3825000000E+04, 3.4417965335E-01, 2.0339619762E+00, 4.9715984570E-03, 4.8890273319E-03, 5.2000222231E-01],
	[1.3830000000E+04, 3.4432979593E-01, 2.0336929624E+00, 4.9766918059E-03, 4.8939816014E-03, 5.2013874846E-01],
	[1.3835000000E+04, 3.4447994971E-01, 2.0334240815E+00, 4.9817885290E-03, 4.8989390585E-03, 5.2027522758E-01],
	[1.3840000000E+04, 3.4463011467E-01, 2.0331553332E+00, 4.9868886272E-03, 4.9038997042E-03, 5.2041165969E-01],
	[1.3845000000E+04, 3.4478029081E-01, 2.0328867176E+00, 4.9919921017E-03, 4.9088635391E-03, 5.2054804478E-01],
	[1.3850000000E+04, 3.4493047814E-01, 2.0326182343E+00, 4.9970989533E-03, 4.9138305642E-03, 5.2068438285E-01],
	[1.3855000000E+04, 3.4508067664E-01, 2.0323498835E+00, 5.0022091832E-03, 4.9188007803E-03, 5.2082067391E-01],
	[1.3860000000E+04, 3.4523088631E-01, 2.0320816648E+00, 5.0073227924E-03, 4.9237741882E-03, 5.2095691796E-01],
	[1.3865000000E+04, 3.4538110716E-01, 2.0318135783E+00, 5.0124397817E-03, 4.9287507886E-03, 5.2109311499E-01],
	[1.3870000000E+04, 3.4553133917E-01, 2.0315456238E+00, 5.0175601524E-03, 4.9337305826E-03, 5.2122926501E-01],
	[1.3875000000E+04, 3.4568158235E-01, 2.0312778012E+00, 5.0226839054E-03, 4.9387135708E-03, 5.2136536801E-01],
	[1.3880000000E+04, 3.4583183669E-01, 2.0310101104E+00, 5.0278110416E-03, 4.9436997541E-03, 5.2150142401E-01],
	[1.3885000000E+04, 3.4598210219E-01, 2.0307425512E+00, 5.0329415622E-03, 4.9486891333E-03, 5.2163743299E-01],
	[1.3890000000E+04, 3.4613237884E-01, 2.0304751236E+00, 5.0380754681E-03, 4.9536817092E-03, 5.2177339496E-01],
	[1.3895000000E+04, 3.4628266665E-01, 2.0302078275E+00, 5.0432127603E-03, 4.9586774828E-03, 5.2190930992E-01],
	[1.3900000000E+04, 3.4643388139E-01, 2.0299441129E+00, 5.0483534399E-03, 4.9636766633E-03, 5.2204517788E-01],
	[1.3905000000E+04, 3.4658512420E-01, 2.0296805894E+00, 5.0534975079E-03, 4.9686790475E-03, 5.2218099883E-01],
	[1.3910000000E+04, 3.4673637862E-01, 2.0294171948E+00, 5.0586449652E-03, 4.9736846322E-03, 5.2231677277E-01],
	[1.3915000000E+04, 3.4688764465E-01, 2.0291539291E+00, 5.0637958130E-03, 4.9786934185E-03, 5.2245249971E-01],
	[1.3920000000E+04, 3.4703892230E-01, 2.0288907920E+00, 5.0689500521E-03, 4.9837054071E-03, 5.2258817964E-01],
	[1.3925000000E+04, 3.4719021156E-01, 2.0286277836E+00, 5.0741076837E-03, 4.9887205989E-03, 5.2272381257E-01],
	[1.3930000000E+04, 3.4734151242E-01, 2.0283649037E+00, 5.0792687087E-03, 4.9937389946E-03, 5.2285939850E-01],
	[1.3935000000E+04, 3.4749282488E-01, 2.0281021521E+00, 5.0844331282E-03, 4.9987605951E-03, 5.2299493743E-01],
	[1.3940000000E+04, 3.4764414894E-01, 2.0278395288E+00, 5.0896009431E-03, 5.0037854011E-03, 5.2313042935E-01],
	[1.3945000000E+04, 3.4779548459E-01, 2.0275770337E+00, 5.0947721546E-03, 5.0088134137E-03, 5.2326587428E-01],
	[1.3950000000E+04, 3.4794683184E-01, 2.0273146667E+00, 5.0999467635E-03, 5.0138446335E-03, 5.2340127222E-01],
	[1.3955000000E+04, 3.4809819068E-01, 2.0270524276E+00, 5.1051247709E-03, 5.0188790613E-03, 5.2353662316E-01],
	[1.3960000000E+04, 3.4824956110E-01, 2.0267903164E+00, 5.1103061778E-03, 5.0239166981E-03, 5.2367192710E-01],
	[1.3965000000E+04, 3.4840094310E-01, 2.0265283328E+00, 5.1154909853E-03, 5.0289575446E-03, 5.2380718405E-01],
	[1.3970000000E+04, 3.4855233668E-01, 2.0262664770E+00, 5.1206791943E-03, 5.0340016017E-03, 5.2394239401E-01],
	[1.3975000000E+04, 3.4870374184E-01, 2.0260047486E+00, 5.1258708058E-03, 5.0390488701E-03, 5.2407755698E-01],
	[1.3980000000E+04, 3.4885515857E-01, 2.0257431477E+00, 5.1310658210E-03, 5.0440993507E-03, 5.2421267296E-01],
	[1.3985000000E+04, 3.4900658687E-01, 2.0254816740E+00, 5.1362642407E-03, 5.0491530443E-03, 5.2434774195E-01],
	[1.3990000000E+04, 3.4915802673E-01, 2.0252203276E+00, 5.1414660660E-03, 5.0542099518E-03, 5.2448276395E-01],
	[1.3995000000E+04, 3.4930947816E-01, 2.0249591082E+00, 5.1466712979E-03, 5.0592700739E-03, 5.2461773898E-01],
	[1.4000000000E+04, 3.4946094114E-01, 2.0246980159E+00, 5.1518799375E-03, 5.0643334116E-03, 5.2475266702E-01],
	[1.4005000000E+04, 3.4961241568E-01, 2.0244370504E+00, 5.1570919856E-03, 5.0693999655E-03, 5.2488754808E-01],
	[1.4010000000E+04, 3.4976390178E-01, 2.0241762117E+00, 5.1623074435E-03, 5.0744697366E-03, 5.2502238216E-01],
	[1.4015000000E+04, 3.4991539942E-01, 2.0239154996E+00, 5.1675263119E-03, 5.0795427256E-03, 5.2515716926E-01],
	[1.4020000000E+04, 3.5006690861E-01, 2.0236549141E+00, 5.1727485921E-03, 5.0846189333E-03, 5.2529190938E-01],
	[1.4025000000E+04, 3.5021842934E-01, 2.0233944551E+00, 5.1779742849E-03, 5.0896983607E-03, 5.2542660254E-01],
	[1.4030000000E+04, 3.5036996162E-01, 2.0231341224E+00, 5.1832033915E-03, 5.0947810085E-03, 5.2556124872E-01],
	[1.4035000000E+04, 3.5052150543E-01, 2.0228739159E+00, 5.1884359127E-03, 5.0998668775E-03, 5.2569584792E-01],
	[1.4040000000E+04, 3.5067306077E-01, 2.0226138356E+00, 5.1936718497E-03, 5.1049559685E-03, 5.2583040016E-01],
	[1.4045000000E+04, 3.5082462764E-01, 2.0223538813E+00, 5.1989112034E-03, 5.1100482824E-03, 5.2596490544E-01],
	[1.4050000000E+04, 3.5097620604E-01, 2.0220940529E+00, 5.2041539748E-03, 5.1151438201E-03, 5.2609936375E-01],
	[1.4055000000E+04, 3.5112779596E-01, 2.0218343503E+00, 5.2094001650E-03, 5.1202425822E-03, 5.2623377509E-01],
	[1.4060000000E+04, 3.5127939741E-01, 2.0215747734E+00, 5.2146497750E-03, 5.1253445696E-03, 5.2636813947E-01],
	[1.4065000000E+04, 3.5143101037E-01, 2.0213153222E+00, 5.2199028057E-03, 5.1304497832E-03, 5.2650245690E-01],
	[1.4070000000E+04, 3.5158263484E-01, 2.0210559964E+00, 5.2251592582E-03, 5.1355582238E-03, 5.2663672736E-01],
	[1.4075000000E+04, 3.5173427083E-01, 2.0207967960E+00, 5.2304191336E-03, 5.1406698922E-03, 5.2677095088E-01],
	[1.4080000000E+04, 3.5188591832E-01, 2.0205377209E+00, 5.2356824327E-03, 5.1457847891E-03, 5.2690512744E-01],
	[1.4085000000E+04, 3.5203757731E-01, 2.0202787710E+00, 5.2409491567E-03, 5.1509029155E-03, 5.2703925704E-01],
	[1.4090000000E+04, 3.5218924781E-01, 2.0200199462E+00, 5.2462193065E-03, 5.1560242722E-03, 5.2717333970E-01],
	[1.4095000000E+04, 3.5234092981E-01, 2.0197612463E+00, 5.2514928832E-03, 5.1611488599E-03, 5.2730737541E-01],
	[1.4100000000E+04, 3.5249262330E-01, 2.0195026714E+00, 5.2567698878E-03, 5.1662766794E-03, 5.2744136418E-01],
	[1.4105000000E+04, 3.5264432828E-01, 2.0192442211E+00, 5.2620503212E-03, 5.1714077317E-03, 5.2757530601E-01],
	[1.4110000000E+04, 3.5279604475E-01, 2.0189858956E+00, 5.2673341845E-03, 5.1765420175E-03, 5.2770920089E-01],
	[1.4115000000E+04, 3.5294777271E-01, 2.0187276945E+00, 5.2726214786E-03, 5.1816795376E-03, 5.2784304884E-01],
	[1.4120000000E+04, 3.5309974315E-01, 2.0184704587E+00, 5.2779122047E-03, 5.1868203483E-03, 5.2797684985E-01],
	[1.4125000000E+04, 3.5325244126E-01, 2.0182159512E+00, 5.2832063637E-03, 5.1919645670E-03, 5.2811060393E-01],
	[1.4130000000E+04, 3.5340515132E-01, 2.0179615659E+00, 5.2885039567E-03, 5.1971120231E-03, 5.2824431108E-01],
	[1.4135000000E+04, 3.5355787334E-01, 2.0177073026E+00, 5.2938049846E-03, 5.2022627175E-03, 5.2837797130E-01],
	[1.4140000000E+04, 3.5371060731E-01, 2.0174531613E+00, 5.2991094484E-03, 5.2074166510E-03, 5.2851158459E-01],
	[1.4145000000E+04, 3.5386335322E-01, 2.0171991418E+00, 5.3044173492E-03, 5.2125738243E-03, 5.2864515096E-01],
	[1.4150000000E+04, 3.5401611108E-01, 2.0169452441E+00, 5.3097286880E-03, 5.2177342384E-03, 5.2877867041E-01],
	[1.4155000000E+04, 3.5416888088E-01, 2.0166914680E+00, 5.3150434657E-03, 5.2228978939E-03, 5.2891214294E-01],
	[1.4160000000E+04, 3.5432166261E-01, 2.0164378134E+00, 5.3203616835E-03, 5.2280647918E-03, 5.2904556856E-01],
	[1.4165000000E+04, 3.5447445628E-01, 2.0161842803E+00, 5.3256833422E-03, 5.2332349329E-03, 5.2917894726E-01],
	[1.4170000000E+04, 3.5462726188E-01, 2.0159308685E+00, 5.3310084430E-03, 5.2384083179E-03, 5.2931227905E-01],
	[1.4175000000E+04, 3.5478007940E-01, 2.0156775780E+00, 5.3363369868E-03, 5.2435849477E-03, 5.2944556393E-01],
	[1.4180000000E+04, 3.5493290885E-01, 2.0154244086E+00, 5.3416689746E-03, 5.2487648231E-03, 5.2957880191E-01],
	[1.4185000000E+04, 3.5508575022E-01, 2.0151713602E+00, 5.3470044075E-03, 5.2539479450E-03, 5.2971199298E-01],
	[1.4190000000E+04, 3.5523860350E-01, 2.0149184327E+00, 5.3523432864E-03, 5.2591343140E-03, 5.2984513716E-01],
	[1.4195000000E+04, 3.5539146870E-01, 2.0146656261E+00, 5.3576856125E-03, 5.2643239311E-03, 5.2997823444E-01],
	[1.4200000000E+04, 3.5554434581E-01, 2.0144129403E+00, 5.3630313865E-03, 5.2695167971E-03, 5.3011128482E-01],
	[1.4205000000E+04, 3.5569723483E-01, 2.0141603750E+00, 5.3683806097E-03, 5.2747129127E-03, 5.3024428831E-01],
	[1.4210000000E+04, 3.5585013575E-01, 2.0139079303E+00, 5.3737332830E-03, 5.2799122789E-03, 5.3037724491E-01],
	[1.4215000000E+04, 3.5600304857E-01, 2.0136556061E+00, 5.3790894074E-03, 5.2851148963E-03, 5.3051015463E-01],
	[1.4220000000E+04, 3.5615597329E-01, 2.0134034021E+00, 5.3844489839E-03, 5.2903207659E-03, 5.3064301746E-01],
	[1.4225000000E+04, 3.5630890990E-01, 2.0131513184E+00, 5.3898120135E-03, 5.2955298884E-03, 5.3077583342E-01],
	[1.4230000000E+04, 3.5646185840E-01, 2.0128993549E+00, 5.3951784973E-03, 5.3007422647E-03, 5.3090860249E-01],
	[1.4235000000E+04, 3.5661481880E-01, 2.0126475113E+00, 5.4005484362E-03, 5.3059578955E-03, 5.3104132470E-01],
	[1.4240000000E+04, 3.5676779107E-01, 2.0123957877E+00, 5.4059218312E-03, 5.3111767817E-03, 5.3117400003E-01],
	[1.4245000000E+04, 3.5692077523E-01, 2.0121441840E+00, 5.4112986835E-03, 5.3163989241E-03, 5.3130662849E-01],
	[1.4250000000E+04, 3.5707377126E-01, 2.0118927000E+00, 5.4166789939E-03, 5.3216243235E-03, 5.3143921009E-01],
	[1.4255000000E+04, 3.5722677917E-01, 2.0116413356E+00, 5.4220627635E-03, 5.3268529807E-03, 5.3157174483E-01],
	[1.4260000000E+04, 3.5737979895E-01, 2.0113900908E+00, 5.4274499933E-03, 5.3320848965E-03, 5.3170423271E-01],
	[1.4265000000E+04, 3.5753283060E-01, 2.0111389654E+00, 5.4328406843E-03, 5.3373200718E-03, 5.3183667373E-01],
	[1.4270000000E+04, 3.5768587412E-01, 2.0108879593E+00, 5.4382348375E-03, 5.3425585074E-03, 5.3196906790E-01],
	[1.4275000000E+04, 3.5783892949E-01, 2.0106370725E+00, 5.4436324540E-03, 5.3478002040E-03, 5.3210141522E-01],
	[1.4280000000E+04, 3.5799199673E-01, 2.0103863048E+00, 5.4490335347E-03, 5.3530451625E-03, 5.3223371569E-01],
	[1.4285000000E+04, 3.5814507582E-01, 2.0101356562E+00, 5.4544380806E-03, 5.3582933836E-03, 5.3236596932E-01],
	[1.4290000000E+04, 3.5829816676E-01, 2.0098851266E+00, 5.4598460928E-03, 5.3635448683E-03, 5.3249817612E-01],
	[1.4295000000E+04, 3.5845126955E-01, 2.0096347157E+00, 5.4652575722E-03, 5.3687996173E-03, 5.3263033607E-01],
	[1.4300000000E+04, 3.5860438419E-01, 2.0093844237E+00, 5.4706725199E-03, 5.3740576315E-03, 5.3276244920E-01],
	[1.4305000000E+04, 3.5875751066E-01, 2.0091342503E+00, 5.4760909369E-03, 5.3793189115E-03, 5.3289451549E-01],
	[1.4310000000E+04, 3.5891064898E-01, 2.0088841954E+00, 5.4815128242E-03, 5.3845834583E-03, 5.3302653496E-01],
	[1.4315000000E+04, 3.5906379913E-01, 2.0086342591E+00, 5.4869381828E-03, 5.3898512727E-03, 5.3315850761E-01],
	[1.4320000000E+04, 3.5921696112E-01, 2.0083844410E+00, 5.4923670137E-03, 5.3951223554E-03, 5.3329043343E-01],
	[1.4325000000E+04, 3.5937013494E-01, 2.0081347413E+00, 5.4977993179E-03, 5.4003967074E-03, 5.3342231244E-01],
	[1.4330000000E+04, 3.5952332058E-01, 2.0078851597E+00, 5.5032350964E-03, 5.4056743293E-03, 5.3355414464E-01],
	[1.4335000000E+04, 3.5967651804E-01, 2.0076356962E+00, 5.5086743503E-03, 5.4109552220E-03, 5.3368593003E-01],
	[1.4340000000E+04, 3.5982972733E-01, 2.0073863506E+00, 5.5141170805E-03, 5.4162393863E-03, 5.3381766862E-01],
	[1.4345000000E+04, 3.5998294843E-01, 2.0071371230E+00, 5.5195632880E-03, 5.4215268230E-03, 5.3394936041E-01],
	[1.4350000000E+04, 3.6013693689E-01, 2.0068906676E+00, 5.5250129739E-03, 5.4268177240E-03, 5.3408100539E-01],
	[1.4355000000E+04, 3.6029114411E-01, 2.0066450536E+00, 5.5304661392E-03, 5.4321119518E-03, 5.3421260359E-01],
	[1.4360000000E+04, 3.6044536363E-01, 2.0063995553E+00, 5.5359227848E-03, 5.4374094551E-03, 5.3434415499E-01],
	[1.4365000000E+04, 3.6059959544E-01, 2.0061541724E+00, 5.5413829119E-03, 5.4427102348E-03, 5.3447565961E-01],
	[1.4370000000E+04, 3.6075383953E-01, 2.0059089049E+00, 5.5468465213E-03, 5.4480142916E-03, 5.3460711744E-01],
	[1.4375000000E+04, 3.6090809591E-01, 2.0056637527E+00, 5.5523136141E-03, 5.4533216264E-03, 5.3473852849E-01],
	[1.4380000000E+04, 3.6106236457E-01, 2.0054187157E+00, 5.5577841913E-03, 5.4586322399E-03, 5.3486989277E-01],
	[1.4385000000E+04, 3.6121664550E-01, 2.0051737938E+00, 5.5632582540E-03, 5.4639461330E-03, 5.3500121028E-01],
	[1.4390000000E+04, 3.6137093871E-01, 2.0049289869E+00, 5.5687358031E-03, 5.4692633066E-03, 5.3513248102E-01],
	[1.4395000000E+04, 3.6152524418E-01, 2.0046842949E+00, 5.5742168396E-03, 5.4745837613E-03, 5.3526370500E-01],
	[1.4400000000E+04, 3.6167956192E-01, 2.0044397178E+00, 5.5797013645E-03, 5.4799074980E-03, 5.3539488221E-01],
	[1.4405000000E+04, 3.6183389193E-01, 2.0041952554E+00, 5.5851893789E-03, 5.4852345176E-03, 5.3552601267E-01],
	[1.4410000000E+04, 3.6198823420E-01, 2.0039509076E+00, 5.5906808837E-03, 5.4905648207E-03, 5.3565709638E-01],
	[1.4415000000E+04, 3.6214258872E-01, 2.0037066744E+00, 5.5961758800E-03, 5.4958984083E-03, 5.3578813334E-01],
	[1.4420000000E+04, 3.6229695549E-01, 2.0034625556E+00, 5.6016743688E-03, 5.5012352812E-03, 5.3591912356E-01],
	[1.4425000000E+04, 3.6245133452E-01, 2.0032185512E+00, 5.6071763511E-03, 5.5065754400E-03, 5.3605006704E-01],
	[1.4430000000E+04, 3.6260572579E-01, 2.0029746610E+00, 5.6126818278E-03, 5.5119188858E-03, 5.3618096378E-01],
	[1.4435000000E+04, 3.6276012931E-01, 2.0027308851E+00, 5.6181908000E-03, 5.5172656192E-03, 5.3631181379E-01],
	[1.4440000000E+04, 3.6291454507E-01, 2.0024872231E+00, 5.6237032688E-03, 5.5226156410E-03, 5.3644261707E-01],
	[1.4445000000E+04, 3.6306897306E-01, 2.0022436752E+00, 5.6292192350E-03, 5.5279689522E-03, 5.3657337363E-01],
	[1.4450000000E+04, 3.6322341329E-01, 2.0020002412E+00, 5.6347386998E-03, 5.5333255534E-03, 5.3670408347E-01],
	[1.4455000000E+04, 3.6337786575E-01, 2.0017569210E+00, 5.6402616641E-03, 5.5386854455E-03, 5.3683474659E-01],
	[1.4460000000E+04, 3.6353233043E-01, 2.0015137145E+00, 5.6457881289E-03, 5.5440486294E-03, 5.3696536300E-01],
	[1.4465000000E+04, 3.6368680734E-01, 2.0012706216E+00, 5.6513180952E-03, 5.5494151057E-03, 5.3709593271E-01],
	[1.4470000000E+04, 3.6384129647E-01, 2.0010276422E+00, 5.6568515641E-03, 5.5547848753E-03, 5.3722645571E-01],
	[1.4475000000E+04, 3.6399579782E-01, 2.0007847762E+00, 5.6623885365E-03, 5.5601579390E-03, 5.3735693202E-01],
	[1.4480000000E+04, 3.6415031138E-01, 2.0005420236E+00, 5.6679290135E-03, 5.5655342977E-03, 5.3748736163E-01],
	[1.4485000000E+04, 3.6430483716E-01, 2.0002993843E+00, 5.6734729961E-03, 5.5709139521E-03, 5.3761774455E-01],
	[1.4490000000E+04, 3.6445937514E-01, 2.0000568581E+00, 5.6790204852E-03, 5.5762969030E-03, 5.3774808079E-01],
	[1.4495000000E+04, 3.6461392532E-01, 1.9998144449E+00, 5.6845714819E-03, 5.5816831512E-03, 5.3787837035E-01],
	[1.4500000000E+04, 3.6476848771E-01, 1.9995721447E+00, 5.6901259872E-03, 5.5870726976E-03, 5.3800861323E-01],
	[1.4505000000E+04, 3.6492306229E-01, 1.9993299575E+00, 5.6956840021E-03, 5.5924655429E-03, 5.3813880944E-01],
	[1.4510000000E+04, 3.6507764907E-01, 1.9990878829E+00, 5.7012455276E-03, 5.5978616880E-03, 5.3826895898E-01],
	[1.4515000000E+04, 3.6523224804E-01, 1.9988459211E+00, 5.7068105647E-03, 5.6032611336E-03, 5.3839906186E-01],
	[1.4520000000E+04, 3.6538685920E-01, 1.9986040719E+00, 5.7123791144E-03, 5.6086638806E-03, 5.3852911808E-01],
	[1.4525000000E+04, 3.6554148255E-01, 1.9983623352E+00, 5.7179511777E-03, 5.6140699298E-03, 5.3865912765E-01],
	[1.4530000000E+04, 3.6569611807E-01, 1.9981207110E+00, 5.7235267557E-03, 5.6194792819E-03, 5.3878909056E-01],
	[1.4535000000E+04, 3.6585076578E-01, 1.9978791990E+00, 5.7291058493E-03, 5.6248919377E-03, 5.3891900684E-01],
	[1.4540000000E+04, 3.6600542566E-01, 1.9976377994E+00, 5.7346884595E-03, 5.6303078982E-03, 5.3904887647E-01],
	[1.4545000000E+04, 3.6616009771E-01, 1.9973965118E+00, 5.7402745873E-03, 5.6357271640E-03, 5.3917869947E-01],
	[1.4550000000E+04, 3.6631478193E-01, 1.9971553363E+00, 5.7458642338E-03, 5.6411497360E-03, 5.3930847584E-01],
	[1.4555000000E+04, 3.6646947832E-01, 1.9969142728E+00, 5.7514574000E-03, 5.6465756150E-03, 5.3943820558E-01],
	[1.4560000000E+04, 3.6662418687E-01, 1.9966733212E+00, 5.7570540868E-03, 5.6520048018E-03, 5.3956788870E-01],
	[1.4565000000E+04, 3.6677890757E-01, 1.9964324813E+00, 5.7626542953E-03, 5.6574372971E-03, 5.3969752520E-01],
	[1.4570000000E+04, 3.6693364044E-01, 1.9961917532E+00, 5.7682580264E-03, 5.6628731018E-03, 5.3982711510E-01],
	[1.4575000000E+04, 3.6708838546E-01, 1.9959511367E+00, 5.7738652813E-03, 5.6683122168E-03, 5.3995665838E-01],
	[1.4580000000E+04, 3.6724372399E-01, 1.9957126044E+00, 5.7794760608E-03, 5.6737547974E-03, 5.4008615507E-01],
	[1.4585000000E+04, 3.6739947098E-01, 1.9954755256E+00, 5.7850903660E-03, 5.6792007957E-03, 5.4021560516E-01],
	[1.4590000000E+04, 3.6755523059E-01, 1.9952385561E+00, 5.7907081979E-03, 5.6846501074E-03, 5.4034500865E-01],
	[1.4595000000E+04, 3.6771100284E-01, 1.9950016960E+00, 5.7963295575E-03, 5.6901027332E-03, 5.4047436556E-01],
	[1.4600000000E+04, 3.6786678771E-01, 1.9947649451E+00, 5.8019544458E-03, 5.6955586739E-03, 5.4060367589E-01],
	[1.4605000000E+04, 3.6802258521E-01, 1.9945283033E+00, 5.8075828638E-03, 5.7010179303E-03, 5.4073293963E-01],
	[1.4610000000E+04, 3.6817839533E-01, 1.9942917706E+00, 5.8132148126E-03, 5.7064805032E-03, 5.4086215681E-01],
	[1.4615000000E+04, 3.6833421807E-01, 1.9940553469E+00, 5.8188502930E-03, 5.7119463934E-03, 5.4099132742E-01],
	[1.4620000000E+04, 3.6849005342E-01, 1.9938190320E+00, 5.8244893062E-03, 5.7174156018E-03, 5.4112045147E-01],
	[1.4625000000E+04, 3.6864590138E-01, 1.9935828260E+00, 5.8301318532E-03, 5.7228881291E-03, 5.4124952896E-01],
	[1.4630000000E+04, 3.6880176195E-01, 1.9933467286E+00, 5.8357779348E-03, 5.7283639762E-03, 5.4137855989E-01],
	[1.4635000000E+04, 3.6895763513E-01, 1.9931107399E+00, 5.8414275522E-03, 5.7338431437E-03, 5.4150754428E-01],
	[1.4640000000E+04, 3.6911352091E-01, 1.9928748597E+00, 5.8470807064E-03, 5.7393256326E-03, 5.4163648213E-01],
	[1.4645000000E+04, 3.6926941928E-01, 1.9926390880E+00, 5.8527373983E-03, 5.7448114436E-03, 5.4176537344E-01],
	[1.4650000000E+04, 3.6942533025E-01, 1.9924034246E+00, 5.8583976290E-03, 5.7503005775E-03, 5.4189421822E-01],
	[1.4655000000E+04, 3.6958125381E-01, 1.9921678695E+00, 5.8640613994E-03, 5.7557930352E-03, 5.4202301648E-01],
	[1.4660000000E+04, 3.6973718996E-01, 1.9919324226E+00, 5.8697287106E-03, 5.7612888174E-03, 5.4215176821E-01],
	[1.4665000000E+04, 3.6989313869E-01, 1.9916970838E+00, 5.8753995636E-03, 5.7667879249E-03, 5.4228047343E-01],
	[1.4670000000E+04, 3.7004910000E-01, 1.9914618530E+00, 5.8810739594E-03, 5.7722903586E-03, 5.4240913213E-01],
	[1.4675000000E+04, 3.7020507390E-01, 1.9912267301E+00, 5.8867518989E-03, 5.7777961191E-03, 5.4253774433E-01],
	[1.4680000000E+04, 3.7036106036E-01, 1.9909917151E+00, 5.8924333832E-03, 5.7833052074E-03, 5.4266631003E-01],
	[1.4685000000E+04, 3.7051705940E-01, 1.9907568078E+00, 5.8981184133E-03, 5.7888176243E-03, 5.4279482924E-01],
	[1.4690000000E+04, 3.7067307101E-01, 1.9905220082E+00, 5.9038069903E-03, 5.7943333704E-03, 5.4292330196E-01],
	[1.4695000000E+04, 3.7082909519E-01, 1.9902873162E+00, 5.9094991150E-03, 5.7998524467E-03, 5.4305172819E-01],
	[1.4700000000E+04, 3.7098513192E-01, 1.9900527317E+00, 5.9151947885E-03, 5.8053748538E-03, 5.4318010795E-01],
	[1.4705000000E+04, 3.7114118121E-01, 1.9898182546E+00, 5.9208940118E-03, 5.8109005927E-03, 5.4330844123E-01],
	[1.4710000000E+04, 3.7129724306E-01, 1.9895838848E+00, 5.9265967860E-03, 5.8164296642E-03, 5.4343672804E-01],
	[1.4715000000E+04, 3.7145331746E-01, 1.9893496222E+00, 5.9323031119E-03, 5.8219620689E-03, 5.4356496839E-01],
	[1.4720000000E+04, 3.7160940441E-01, 1.9891154669E+00, 5.9380129907E-03, 5.8274978077E-03, 5.4369316229E-01],
	[1.4725000000E+04, 3.7176550391E-01, 1.9888814185E+00, 5.9437264233E-03, 5.8330368815E-03, 5.4382130973E-01],
	[1.4730000000E+04, 3.7192161595E-01, 1.9886474772E+00, 5.9494434108E-03, 5.8385792909E-03, 5.4394941073E-01],
	[1.4735000000E+04, 3.7207774052E-01, 1.9884136428E+00, 5.9551639540E-03, 5.8441250369E-03, 5.4407746529E-01],
	[1.4740000000E+04, 3.7223387764E-01, 1.9881799152E+00, 5.9608880542E-03, 5.8496741201E-03, 5.4420547342E-01],
	[1.4745000000E+04, 3.7239002728E-01, 1.9879462943E+00, 5.9666157121E-03, 5.8552265415E-03, 5.4433343512E-01],
	[1.4750000000E+04, 3.7254618946E-01, 1.9877127800E+00, 5.9723469289E-03, 5.8607823017E-03, 5.4446135039E-01],
	[1.4755000000E+04, 3.7270236416E-01, 1.9874793724E+00, 5.9780817056E-03, 5.8663414017E-03, 5.4458921925E-01],
	[1.4760000000E+04, 3.7285855138E-01, 1.9872460711E+00, 5.9838200431E-03, 5.8719038421E-03, 5.4471704169E-01],
	[1.4765000000E+04, 3.7301475113E-01, 1.9870128763E+00, 5.9895619424E-03, 5.8774696238E-03, 5.4484481773E-01],
	[1.4770000000E+04, 3.7317096339E-01, 1.9867797878E+00, 5.9953074047E-03, 5.8830387475E-03, 5.4497254737E-01],
	[1.4775000000E+04, 3.7332718816E-01, 1.9865468055E+00, 6.0010564308E-03, 5.8886112142E-03, 5.4510023061E-01],
	[1.4780000000E+04, 3.7348342544E-01, 1.9863139294E+00, 6.0068090217E-03, 5.8941870245E-03, 5.4522786747E-01],
	[1.4785000000E+04, 3.7363967523E-01, 1.9860811593E+00, 6.0125651785E-03, 5.8997661792E-03, 5.4535545794E-01],
	[1.4790000000E+04, 3.7379593753E-01, 1.9858484951E+00, 6.0183249022E-03, 5.9053486793E-03, 5.4548300204E-01],
	[1.4795000000E+04, 3.7395221232E-01, 1.9856159369E+00, 6.0240881938E-03, 5.9109345253E-03, 5.4561049977E-01],
	[1.4800000000E+04, 3.7410849961E-01, 1.9853834845E+00, 6.0298550543E-03, 5.9165237182E-03, 5.4573795113E-01],
	[1.4805000000E+04, 3.7426479939E-01, 1.9851511377E+00, 6.0356254846E-03, 5.9221162588E-03, 5.4586535613E-01],
	[1.4810000000E+04, 3.7442111167E-01, 1.9849188966E+00, 6.0413994859E-03, 5.9277121478E-03, 5.4599271478E-01],
	[1.4815000000E+04, 3.7457809249E-01, 1.9846889112E+00, 6.0471770590E-03, 5.9333115698E-03, 5.4612002708E-01],
	[1.4820000000E+04, 3.7473542292E-01, 1.9844601332E+00, 6.0529582050E-03, 5.9389144369E-03, 5.4624729304E-01],
	[1.4825000000E+04, 3.7489276633E-01, 1.9842314588E+00, 6.0587429249E-03, 5.9445206555E-03, 5.4637451266E-01],
	[1.4830000000E+04, 3.7505012271E-01, 1.9840028877E+00, 6.0645312197E-03, 5.9501302264E-03, 5.4650168596E-01],
	[1.4835000000E+04, 3.7520749206E-01, 1.9837744201E+00, 6.0703230904E-03, 5.9557431506E-03, 5.4662881293E-01],
	[1.4840000000E+04, 3.7536487437E-01, 1.9835460557E+00, 6.0761185381E-03, 5.9613594286E-03, 5.4675589359E-01],
	[1.4845000000E+04, 3.7552226966E-01, 1.9833177946E+00, 6.0819175636E-03, 5.9669790615E-03, 5.4688292793E-01],
	[1.4850000000E+04, 3.7567967790E-01, 1.9830896366E+00, 6.0877201680E-03, 5.9726020498E-03, 5.4700991597E-01],
	[1.4855000000E+04, 3.7583709910E-01, 1.9828615816E+00, 6.0935263524E-03, 5.9782283945E-03, 5.4713685771E-01],
	[1.4860000000E+04, 3.7599453325E-01, 1.9826336295E+00, 6.0993361176E-03, 5.9838580964E-03, 5.4726375316E-01],
	[1.4865000000E+04, 3.7615198036E-01, 1.9824057804E+00, 6.1051494648E-03, 5.9894911561E-03, 5.4739060232E-01],
	[1.4870000000E+04, 3.7630944041E-01, 1.9821780340E+00, 6.1109663949E-03, 5.9951275746E-03, 5.4751740520E-01],
	[1.4875000000E+04, 3.7646691340E-01, 1.9819503904E+00, 6.1167869090E-03, 6.0007673526E-03, 5.4764416181E-01],
	[1.4880000000E+04, 3.7662439934E-01, 1.9817228494E+00, 6.1226110079E-03, 6.0064104908E-03, 5.4777087215E-01],
	[1.4885000000E+04, 3.7678189821E-01, 1.9814954110E+00, 6.1284386928E-03, 6.0120569902E-03, 5.4789753622E-01],
	[1.4890000000E+04, 3.7693941002E-01, 1.9812680750E+00, 6.1342699646E-03, 6.0177068515E-03, 5.4802415405E-01],
	[1.4895000000E+04, 3.7709693476E-01, 1.9810408414E+00, 6.1401048243E-03, 6.0233600754E-03, 5.4815072562E-01],
	[1.4900000000E+04, 3.7725447243E-01, 1.9808137102E+00, 6.1459432730E-03, 6.0290166628E-03, 5.4827725095E-01],
	[1.4905000000E+04, 3.7741202302E-01, 1.9805866812E+00, 6.1517853116E-03, 6.0346766144E-03, 5.4840373004E-01],
	[1.4910000000E+04, 3.7756958653E-01, 1.9803597543E+00, 6.1576309412E-03, 6.0403399311E-03, 5.4853016291E-01],
	[1.4915000000E+04, 3.7772716296E-01, 1.9801329295E+00, 6.1634801627E-03, 6.0460066137E-03, 5.4865654955E-01],
	[1.4920000000E+04, 3.7788475230E-01, 1.9799062067E+00, 6.1693329771E-03, 6.0516766628E-03, 5.4878288997E-01],
	[1.4925000000E+04, 3.7804235456E-01, 1.9796795858E+00, 6.1751893855E-03, 6.0573500794E-03, 5.4890918419E-01],
	[1.4930000000E+04, 3.7819996972E-01, 1.9794530668E+00, 6.1810493888E-03, 6.0630268642E-03, 5.4903543220E-01],
	[1.4935000000E+04, 3.7835759779E-01, 1.9792266495E+00, 6.1869129881E-03, 6.0687070181E-03, 5.4916163401E-01],
	[1.4940000000E+04, 3.7851523876E-01, 1.9790003338E+00, 6.1927801843E-03, 6.0743905417E-03, 5.4928778963E-01],
	[1.4945000000E+04, 3.7867289263E-01, 1.9787741198E+00, 6.1986509784E-03, 6.0800774359E-03, 5.4941389907E-01],
	[1.4950000000E+04, 3.7883055940E-01, 1.9785480073E+00, 6.2045253716E-03, 6.0857677014E-03, 5.4953996232E-01],
	[1.4955000000E+04, 3.7898823905E-01, 1.9783219962E+00, 6.2104033646E-03, 6.0914613392E-03, 5.4966597941E-01],
	[1.4960000000E+04, 3.7914593159E-01, 1.9780960865E+00, 6.2162849587E-03, 6.0971583499E-03, 5.4979195033E-01],
	[1.4965000000E+04, 3.7930363702E-01, 1.9778702780E+00, 6.2221701546E-03, 6.1028587343E-03, 5.4991787510E-01],
	[1.4970000000E+04, 3.7946135533E-01, 1.9776445707E+00, 6.2280589536E-03, 6.1085624933E-03, 5.5004375371E-01],
	[1.4975000000E+04, 3.7961908652E-01, 1.9774189646E+00, 6.2339513565E-03, 6.1142696275E-03, 5.5016958617E-01],
	[1.4980000000E+04, 3.7977683059E-01, 1.9771934595E+00, 6.2398473643E-03, 6.1199801379E-03, 5.5029537250E-01],
	[1.4985000000E+04, 3.7993458752E-01, 1.9769680554E+00, 6.2457469782E-03, 6.1256940252E-03, 5.5042111270E-01],
	[1.4990000000E+04, 3.8009235733E-01, 1.9767427521E+00, 6.2516501989E-03, 6.1314112902E-03, 5.5054680677E-01],
	[1.4995000000E+04, 3.8025014000E-01, 1.9765175497E+00, 6.2575570277E-03, 6.1371319337E-03, 5.5067245473E-01],
	[1.5000000000E+04, 3.8040793554E-01, 1.9762924479E+00, 6.2634674654E-03, 6.1428559564E-03, 5.5079805657E-01],
	[1.5005000000E+04, 3.8056574393E-01, 1.9760674468E+00, 6.2694745015E-03, 6.1486727987E-03, 5.5092361231E-01],
	[1.5010000000E+04, 3.8072356518E-01, 1.9758425463E+00, 6.2754852945E-03, 6.1544931580E-03, 5.5104912195E-01],
	[1.5015000000E+04, 3.8088139928E-01, 1.9756177463E+00, 6.2814998455E-03, 6.1603170350E-03, 5.5117458550E-01],
	[1.5020000000E+04, 3.8103924623E-01, 1.9753930467E+00, 6.2875181556E-03, 6.1661444306E-03, 5.5130000296E-01],
	[1.5025000000E+04, 3.8119710603E-01, 1.9751684474E+00, 6.2935402259E-03, 6.1719753457E-03, 5.5142537435E-01],
	[1.5030000000E+04, 3.8135497867E-01, 1.9749439483E+00, 6.2995660574E-03, 6.1778097812E-03, 5.5155069967E-01],
	[1.5035000000E+04, 3.8151286415E-01, 1.9747195495E+00, 6.3055956512E-03, 6.1836477379E-03, 5.5167597892E-01],
	[1.5040000000E+04, 3.8167076247E-01, 1.9744952507E+00, 6.3116290086E-03, 6.1894892168E-03, 5.5180121212E-01],
	[1.5045000000E+04, 3.8182867362E-01, 1.9742710520E+00, 6.3176661305E-03, 6.1953342185E-03, 5.5192639927E-01],
	[1.5050000000E+04, 3.8198659760E-01, 1.9740469531E+00, 6.3237070180E-03, 6.2011827441E-03, 5.5205154037E-01],
	[1.5055000000E+04, 3.8214551364E-01, 1.9738260491E+00, 6.3297516723E-03, 6.2070350834E-03, 5.5217663544E-01],
	[1.5060000000E+04, 3.8230447202E-01, 1.9736053349E+00, 6.3358000944E-03, 6.2128909576E-03, 5.5230168448E-01],
	[1.5065000000E+04, 3.8246344373E-01, 1.9733847186E+00, 6.3418522855E-03, 6.2187503590E-03, 5.5242668750E-01],
	[1.5070000000E+04, 3.8262242875E-01, 1.9731642002E+00, 6.3479082466E-03, 6.2246132885E-03, 5.5255164451E-01],
	[1.5075000000E+04, 3.8278142709E-01, 1.9729437795E+00, 6.3539679789E-03, 6.2304797470E-03, 5.5267655551E-01],
	[1.5080000000E+04, 3.8294043874E-01, 1.9727234566E+00, 6.3600314834E-03, 6.2363497354E-03, 5.5280142050E-01],
	[1.5085000000E+04, 3.8309946370E-01, 1.9725032313E+00, 6.3660987612E-03, 6.2422232544E-03, 5.5292623951E-01],
	[1.5090000000E+04, 3.8325850196E-01, 1.9722831035E+00, 6.3721698134E-03, 6.2481003050E-03, 5.5305101253E-01],
	[1.5095000000E+04, 3.8341755353E-01, 1.9720630732E+00, 6.3782446412E-03, 6.2539808881E-03, 5.5317573956E-01],
	[1.5100000000E+04, 3.8357661839E-01, 1.9718431404E+00, 6.3843232456E-03, 6.2598650045E-03, 5.5330042061E-01],
	[1.5105000000E+04, 3.8373569655E-01, 1.9716233048E+00, 6.3904056277E-03, 6.2657526550E-03, 5.5342505568E-01],
	[1.5110000000E+04, 3.8389478800E-01, 1.9714035665E+00, 6.3964917886E-03, 6.2716438406E-03, 5.5354964475E-01],
	[1.5115000000E+04, 3.8405389274E-01, 1.9711839254E+00, 6.4025817294E-03, 6.2775385620E-03, 5.5367418784E-01],
	[1.5120000000E+04, 3.8421301077E-01, 1.9709643814E+00, 6.4086754512E-03, 6.2834368203E-03, 5.5379868496E-01],
	[1.5125000000E+04, 3.8437214208E-01, 1.9707449344E+00, 6.4147729552E-03, 6.2893386161E-03, 5.5392313609E-01],
	[1.5130000000E+04, 3.8453128666E-01, 1.9705255844E+00, 6.4208742423E-03, 6.2952439505E-03, 5.5404754126E-01],
	[1.5135000000E+04, 3.8469044453E-01, 1.9703063313E+00, 6.4269793137E-03, 6.3011528242E-03, 5.5417190045E-01],
	[1.5140000000E+04, 3.8484961566E-01, 1.9700871749E+00, 6.4330881704E-03, 6.3070652381E-03, 5.5429621368E-01],
	[1.5145000000E+04, 3.8500880006E-01, 1.9698681153E+00, 6.4392008137E-03, 6.3129811931E-03, 5.5442048095E-01],
	[1.5150000000E+04, 3.8516799773E-01, 1.9696491523E+00, 6.4453172446E-03, 6.3189006901E-03, 5.5454470225E-01],
	[1.5155000000E+04, 3.8532720866E-01, 1.9694302860E+00, 6.4514374641E-03, 6.3248237299E-03, 5.5466887760E-01],
	[1.5160000000E+04, 3.8548643285E-01, 1.9692115161E+00, 6.4575614734E-03, 6.3307503134E-03, 5.5479300699E-01],
	[1.5165000000E+04, 3.8564567030E-01, 1.9689928426E+00, 6.4636892735E-03, 6.3366804414E-03, 5.5491709044E-01],
	[1.5170000000E+04, 3.8580492100E-01, 1.9687742656E+00, 6.4698208656E-03, 6.3426141148E-03, 5.5504112794E-01],
	[1.5175000000E+04, 3.8596418495E-01, 1.9685557848E+00, 6.4759562508E-03, 6.3485513344E-03, 5.5516511950E-01],
	[1.5180000000E+04, 3.8612346214E-01, 1.9683374002E+00, 6.4820954301E-03, 6.3544921012E-03, 5.5528906511E-01],
	[1.5185000000E+04, 3.8628275258E-01, 1.9681191117E+00, 6.4882384046E-03, 6.3604364160E-03, 5.5541296480E-01],
	[1.5190000000E+04, 3.8644205625E-01, 1.9679009193E+00, 6.4943851756E-03, 6.3663842797E-03, 5.5553681855E-01],
	[1.5195000000E+04, 3.8660137317E-01, 1.9676828229E+00, 6.5005357439E-03, 6.3723356930E-03, 5.5566062637E-01],
	[1.5200000000E+04, 3.8676070331E-01, 1.9674648224E+00, 6.5066901108E-03, 6.3782906570E-03, 5.5578438827E-01],
	[1.5205000000E+04, 3.8692004669E-01, 1.9672469177E+00, 6.5128482773E-03, 6.3842491723E-03, 5.5590810424E-01],
	[1.5210000000E+04, 3.8707940329E-01, 1.9670291088E+00, 6.5190102445E-03, 6.3902112400E-03, 5.5603177430E-01],
	[1.5215000000E+04, 3.8723877311E-01, 1.9668113956E+00, 6.5251760135E-03, 6.3961768608E-03, 5.5615539845E-01],
	[1.5220000000E+04, 3.8739815616E-01, 1.9665937781E+00, 6.5313455855E-03, 6.4021460357E-03, 5.5627897668E-01],
	[1.5225000000E+04, 3.8755755242E-01, 1.9663762560E+00, 6.5375189614E-03, 6.4081187654E-03, 5.5640250902E-01],
	[1.5230000000E+04, 3.8771696190E-01, 1.9661588295E+00, 6.5436961425E-03, 6.4140950509E-03, 5.5652599544E-01],
	[1.5235000000E+04, 3.8787638458E-01, 1.9659414983E+00, 6.5498771298E-03, 6.4200748930E-03, 5.5664943597E-01],
	[1.5240000000E+04, 3.8803582048E-01, 1.9657242625E+00, 6.5560619243E-03, 6.4260582925E-03, 5.5677283061E-01],
	[1.5245000000E+04, 3.8819526957E-01, 1.9655071219E+00, 6.5622505273E-03, 6.4320452504E-03, 5.5689617935E-01],
	[1.5250000000E+04, 3.8835473187E-01, 1.9652900765E+00, 6.5684429397E-03, 6.4380357674E-03, 5.5701948221E-01],
	[1.5255000000E+04, 3.8851420736E-01, 1.9650731262E+00, 6.5746391627E-03, 6.4440298445E-03, 5.5714273919E-01],
	[1.5260000000E+04, 3.8867369605E-01, 1.9648562709E+00, 6.5808391974E-03, 6.4500274825E-03, 5.5726595028E-01],
	[1.5265000000E+04, 3.8883319793E-01, 1.9646395106E+00, 6.5870430448E-03, 6.4560286823E-03, 5.5738911550E-01],
	[1.5270000000E+04, 3.8899271300E-01, 1.9644228452E+00, 6.5932507061E-03, 6.4620334447E-03, 5.5751223485E-01],
	[1.5275000000E+04, 3.8915224125E-01, 1.9642062746E+00, 6.5994621824E-03, 6.4680417705E-03, 5.5763530834E-01],
	[1.5280000000E+04, 3.8931178268E-01, 1.9639897987E+00, 6.6056774747E-03, 6.4740536607E-03, 5.5775833596E-01],
	[1.5285000000E+04, 3.8947133730E-01, 1.9637734175E+00, 6.6118965842E-03, 6.4800691161E-03, 5.5788131772E-01],
	[1.5290000000E+04, 3.8963090508E-01, 1.9635571309E+00, 6.6181195119E-03, 6.4860881376E-03, 5.5800425363E-01],
	[1.5295000000E+04, 3.8979101177E-01, 1.9633425370E+00, 6.6243462589E-03, 6.4921108892E-03, 5.5812714369E-01],
	[1.5300000000E+04, 3.8995162942E-01, 1.9631295484E+00, 6.6305768264E-03, 6.4981373638E-03, 5.5824998790E-01],
	[1.5305000000E+04, 3.9011226073E-01, 1.9629166525E+00, 6.6368112154E-03, 6.5041674079E-03, 5.5837278628E-01],
	[1.5310000000E+04, 3.9027290572E-01, 1.9627038491E+00, 6.6430494270E-03, 6.5102010223E-03, 5.5849553881E-01],
	[1.5315000000E+04, 3.9043356437E-01, 1.9624911384E+00, 6.6492914623E-03, 6.5162382079E-03, 5.5861824551E-01],
	[1.5320000000E+04, 3.9059423668E-01, 1.9622785201E+00, 6.6555373224E-03, 6.5222789656E-03, 5.5874090638E-01],
	[1.5325000000E+04, 3.9075492265E-01, 1.9620659942E+00, 6.6617870084E-03, 6.5283232962E-03, 5.5886352143E-01],
	[1.5330000000E+04, 3.9091562227E-01, 1.9618535606E+00, 6.6680405215E-03, 6.5343712005E-03, 5.5898609066E-01],
	[1.5335000000E+04, 3.9107633554E-01, 1.9616412193E+00, 6.6742978626E-03, 6.5404226795E-03, 5.5910861407E-01],
	[1.5340000000E+04, 3.9123706247E-01, 1.9614289702E+00, 6.6805590329E-03, 6.5464777340E-03, 5.5923109167E-01],
	[1.5345000000E+04, 3.9139780303E-01, 1.9612168132E+00, 6.6868240334E-03, 6.5525363648E-03, 5.5935352346E-01],
	[1.5350000000E+04, 3.9155855724E-01, 1.9610047483E+00, 6.6930928654E-03, 6.5585985728E-03, 5.5947590945E-01],
	[1.5355000000E+04, 3.9171932509E-01, 1.9607927753E+00, 6.6993655298E-03, 6.5646643589E-03, 5.5959824964E-01],
	[1.5360000000E+04, 3.9188010657E-01, 1.9605808943E+00, 6.7056420277E-03, 6.5707337239E-03, 5.5972054404E-01],
	[1.5365000000E+04, 3.9204090168E-01, 1.9603691051E+00, 6.7119223603E-03, 6.5768066686E-03, 5.5984279265E-01],
	[1.5370000000E+04, 3.9220171042E-01, 1.9601574077E+00, 6.7182065287E-03, 6.5828831940E-03, 5.5996499548E-01],
	[1.5375000000E+04, 3.9236253279E-01, 1.9599458020E+00, 6.7244945339E-03, 6.5889633009E-03, 5.6008715252E-01],
	[1.5380000000E+04, 3.9252336877E-01, 1.9597342879E+00, 6.7307863770E-03, 6.5950469901E-03, 5.6020926380E-01],
	[1.5385000000E+04, 3.9268421838E-01, 1.9595228654E+00, 6.7370820592E-03, 6.6011342625E-03, 5.6033132930E-01],
	[1.5390000000E+04, 3.9284508160E-01, 1.9593115344E+00, 6.7433815815E-03, 6.6072251189E-03, 5.6045334903E-01],
	[1.5395000000E+04, 3.9300595843E-01, 1.9591002949E+00, 6.7496849450E-03, 6.6133195603E-03, 5.6057532300E-01],
	[1.5400000000E+04, 3.9316684887E-01, 1.9588891466E+00, 6.7559921508E-03, 6.6194175874E-03, 5.6069725122E-01],
	[1.5405000000E+04, 3.9332775292E-01, 1.9586780897E+00, 6.7623032000E-03, 6.6255192011E-03, 5.6081913369E-01],
	[1.5410000000E+04, 3.9348867056E-01, 1.9584671240E+00, 6.7686180937E-03, 6.6316244023E-03, 5.6094097040E-01],
	[1.5415000000E+04, 3.9364960181E-01, 1.9582562494E+00, 6.7749368330E-03, 6.6377331919E-03, 5.6106276138E-01],
	[1.5420000000E+04, 3.9381054665E-01, 1.9580454660E+00, 6.7812594190E-03, 6.6438455706E-03, 5.6118450662E-01],
	[1.5425000000E+04, 3.9397150509E-01, 1.9578347735E+00, 6.7875858527E-03, 6.6499615393E-03, 5.6130620613E-01],
	[1.5430000000E+04, 3.9413247711E-01, 1.9576241720E+00, 6.7939161354E-03, 6.6560810989E-03, 5.6142785991E-01],
	[1.5435000000E+04, 3.9429346272E-01, 1.9574136614E+00, 6.8002502679E-03, 6.6622042503E-03, 5.6154946796E-01],
	[1.5440000000E+04, 3.9445446191E-01, 1.9572032415E+00, 6.8065882516E-03, 6.6683309943E-03, 5.6167103030E-01],
	[1.5445000000E+04, 3.9461547468E-01, 1.9569929124E+00, 6.8129300874E-03, 6.6744613317E-03, 5.6179254693E-01],
	[1.5450000000E+04, 3.9477650103E-01, 1.9567826740E+00, 6.8192757764E-03, 6.6805952634E-03, 5.6191401785E-01],
	[1.5455000000E+04, 3.9493754094E-01, 1.9565725262E+00, 6.8256253197E-03, 6.6867327903E-03, 5.6203544306E-01],
	[1.5460000000E+04, 3.9509859443E-01, 1.9563624689E+00, 6.8319787185E-03, 6.6928739132E-03, 5.6215682258E-01],
	[1.5465000000E+04, 3.9525966149E-01, 1.9561525021E+00, 6.8383359738E-03, 6.6990186329E-03, 5.6227815641E-01],
	[1.5470000000E+04, 3.9542074211E-01, 1.9559426257E+00, 6.8446970867E-03, 6.7051669504E-03, 5.6239944454E-01],
	[1.5475000000E+04, 3.9558183628E-01, 1.9557328396E+00, 6.8510620584E-03, 6.7113188664E-03, 5.6252068700E-01],
	[1.5480000000E+04, 3.9574294402E-01, 1.9555231438E+00, 6.8574308898E-03, 6.7174743818E-03, 5.6264188378E-01],
	[1.5485000000E+04, 3.9590406530E-01, 1.9553135381E+00, 6.8638035821E-03, 6.7236334976E-03, 5.6276303489E-01],
	[1.5490000000E+04, 3.9606520014E-01, 1.9551040226E+00, 6.8701801364E-03, 6.7297962144E-03, 5.6288414033E-01],
	[1.5495000000E+04, 3.9622634852E-01, 1.9548945972E+00, 6.8765605538E-03, 6.7359625332E-03, 5.6300520010E-01],
	[1.5500000000E+04, 3.9638751045E-01, 1.9546852617E+00, 6.8829448353E-03, 6.7421324548E-03, 5.6312621422E-01],
	[1.5505000000E+04, 3.9654868592E-01, 1.9544760161E+00, 6.8893329821E-03, 6.7483059801E-03, 5.6324718270E-01],
	[1.5510000000E+04, 3.9670987492E-01, 1.9542668605E+00, 6.8957249953E-03, 6.7544831099E-03, 5.6336810552E-01],
	[1.5515000000E+04, 3.9687107746E-01, 1.9540577946E+00, 6.9021208759E-03, 6.7606638451E-03, 5.6348898270E-01],
	[1.5520000000E+04, 3.9703229353E-01, 1.9538488184E+00, 6.9085206251E-03, 6.7668481865E-03, 5.6360981425E-01],
	[1.5525000000E+04, 3.9719352313E-01, 1.9536399318E+00, 6.9149242439E-03, 6.7730361350E-03, 5.6373060017E-01],
	[1.5530000000E+04, 3.9735476625E-01, 1.9534311349E+00, 6.9213317334E-03, 6.7792276914E-03, 5.6385134046E-01],
	[1.5535000000E+04, 3.9751602289E-01, 1.9532224275E+00, 6.9277430947E-03, 6.7854228566E-03, 5.6397203514E-01],
	[1.5540000000E+04, 3.9767757999E-01, 1.9530146481E+00, 6.9341583289E-03, 6.7916217253E-03, 5.6409268420E-01],
	[1.5545000000E+04, 3.9783990222E-01, 1.9528091526E+00, 6.9405774372E-03, 6.7978244507E-03, 5.6421328765E-01],
	[1.5550000000E+04, 3.9800223846E-01, 1.9526037449E+00, 6.9470004205E-03, 6.8040307883E-03, 5.6433384551E-01],
	[1.5555000000E+04, 3.9816458873E-01, 1.9523984247E+00, 6.9534272800E-03, 6.8102407389E-03, 5.6445435776E-01],
	[1.5560000000E+04, 3.9832695301E-01, 1.9521931922E+00, 6.9598580168E-03, 6.8164543035E-03, 5.6457482442E-01],
	[1.5565000000E+04, 3.9848933130E-01, 1.9519880471E+00, 6.9662926320E-03, 6.8226714829E-03, 5.6469524550E-01],
	[1.5570000000E+04, 3.9865172360E-01, 1.9517829895E+00, 6.9727311266E-03, 6.8288922778E-03, 5.6481562099E-01],
	[1.5575000000E+04, 3.9881412991E-01, 1.9515780193E+00, 6.9791735018E-03, 6.8351166892E-03, 5.6493595091E-01],
	[1.5580000000E+04, 3.9897655021E-01, 1.9513731363E+00, 6.9856197586E-03, 6.8413447180E-03, 5.6505623526E-01],
	[1.5585000000E+04, 3.9913898452E-01, 1.9511683406E+00, 6.9920698982E-03, 6.8475763649E-03, 5.6517647405E-01],
	[1.5590000000E+04, 3.9930143282E-01, 1.9509636321E+00, 6.9985239216E-03, 6.8538116308E-03, 5.6529666728E-01],
	[1.5595000000E+04, 3.9946389512E-01, 1.9507590107E+00, 7.0049818299E-03, 6.8600505166E-03, 5.6541681496E-01],
	[1.5600000000E+04, 3.9962637140E-01, 1.9505544763E+00, 7.0114436242E-03, 6.8662930231E-03, 5.6553691709E-01],
	[1.5605000000E+04, 3.9978886167E-01, 1.9503500289E+00, 7.0179093057E-03, 6.8725391512E-03, 5.6565697368E-01],
	[1.5610000000E+04, 3.9995136593E-01, 1.9501456685E+00, 7.0243788753E-03, 6.8787889017E-03, 5.6577698473E-01],
	[1.5615000000E+04, 4.0011388416E-01, 1.9499413948E+00, 7.0308523342E-03, 6.8850422754E-03, 5.6589695026E-01],
	[1.5620000000E+04, 4.0027641637E-01, 1.9497372080E+00, 7.0373296836E-03, 6.8912992732E-03, 5.6601687026E-01],
	[1.5625000000E+04, 4.0043896255E-01, 1.9495331079E+00, 7.0438109243E-03, 6.8975598960E-03, 5.6613674475E-01],
	[1.5630000000E+04, 4.0060152270E-01, 1.9493290944E+00, 7.0502960577E-03, 6.9038241446E-03, 5.6625657372E-01],
	[1.5635000000E+04, 4.0076409681E-01, 1.9491251676E+00, 7.0567850847E-03, 6.9100920198E-03, 5.6637635719E-01],
	[1.5640000000E+04, 4.0092668489E-01, 1.9489213272E+00, 7.0632780064E-03, 6.9163635226E-03, 5.6649609516E-01],
	[1.5645000000E+04, 4.0108928693E-01, 1.9487175733E+00, 7.0697748240E-03, 6.9226386536E-03, 5.6661578763E-01],
	[1.5650000000E+04, 4.0125190293E-01, 1.9485139059E+00, 7.0762755385E-03, 6.9289174139E-03, 5.6673543462E-01],
	[1.5655000000E+04, 4.0141453287E-01, 1.9483103247E+00, 7.0827801510E-03, 6.9351998042E-03, 5.6685503612E-01],
	[1.5660000000E+04, 4.0157717677E-01, 1.9481068299E+00, 7.0892886627E-03, 6.9414858253E-03, 5.6697459215E-01],
	[1.5665000000E+04, 4.0173983462E-01, 1.9479034212E+00, 7.0958010745E-03, 6.9477754782E-03, 5.6709410271E-01],
	[1.5670000000E+04, 4.0190250640E-01, 1.9477000987E+00, 7.1023173877E-03, 6.9540687637E-03, 5.6721356780E-01],
	[1.5675000000E+04, 4.0206519213E-01, 1.9474968622E+00, 7.1088376032E-03, 6.9603656826E-03, 5.6733298744E-01],
	[1.5680000000E+04, 4.0222789180E-01, 1.9472937118E+00, 7.1153617222E-03, 6.9666662357E-03, 5.6745236163E-01],
	[1.5685000000E+04, 4.0239060539E-01, 1.9470906473E+00, 7.1218897458E-03, 6.9729704239E-03, 5.6757169037E-01],
	[1.5690000000E+04, 4.0255333292E-01, 1.9468876687E+00, 7.1284216750E-03, 6.9792782481E-03, 5.6769097367E-01],
	[1.5695000000E+04, 4.0271607438E-01, 1.9466847760E+00, 7.1349575110E-03, 6.9855897091E-03, 5.6781021154E-01],
	[1.5700000000E+04, 4.0287882976E-01, 1.9464819690E+00, 7.1414972548E-03, 6.9919048078E-03, 5.6792940398E-01],
	[1.5705000000E+04, 4.0304159906E-01, 1.9462792476E+00, 7.1480409076E-03, 6.9982235449E-03, 5.6804855100E-01],
	[1.5710000000E+04, 4.0320438227E-01, 1.9460766120E+00, 7.1545884703E-03, 7.0045459214E-03, 5.6816765260E-01],
	[1.5715000000E+04, 4.0336717940E-01, 1.9458740619E+00, 7.1611399442E-03, 7.0108719380E-03, 5.6828670880E-01],
	[1.5720000000E+04, 4.0352999045E-01, 1.9456715973E+00, 7.1676953303E-03, 7.0172015956E-03, 5.6840571960E-01],
	[1.5725000000E+04, 4.0369281540E-01, 1.9454692181E+00, 7.1742546297E-03, 7.0235348952E-03, 5.6852468500E-01],
	[1.5730000000E+04, 4.0385565425E-01, 1.9452669243E+00, 7.1808178435E-03, 7.0298718374E-03, 5.6864360501E-01],
	[1.5735000000E+04, 4.0401850701E-01, 1.9450647159E+00, 7.1873849727E-03, 7.0362124231E-03, 5.6876247964E-01],
	[1.5740000000E+04, 4.0418137366E-01, 1.9448625927E+00, 7.1939560185E-03, 7.0425566533E-03, 5.6888130889E-01],
	[1.5745000000E+04, 4.0434425421E-01, 1.9446605546E+00, 7.2005309820E-03, 7.0489045287E-03, 5.6900009277E-01],
	[1.5750000000E+04, 4.0450714864E-01, 1.9444586017E+00, 7.2071098642E-03, 7.0552560501E-03, 5.6911883129E-01],
	[1.5755000000E+04, 4.0467005697E-01, 1.9442567339E+00, 7.2136926663E-03, 7.0616112185E-03, 5.6923752445E-01],
	[1.5760000000E+04, 4.0483297918E-01, 1.9440549511E+00, 7.2202793892E-03, 7.0679700347E-03, 5.6935617226E-01],
	[1.5765000000E+04, 4.0499591528E-01, 1.9438532532E+00, 7.2268700342E-03, 7.0743324994E-03, 5.6947477473E-01],
	[1.5770000000E+04, 4.0515886525E-01, 1.9436516402E+00, 7.2334646024E-03, 7.0806986136E-03, 5.6959333186E-01],
	[1.5775000000E+04, 4.0532182910E-01, 1.9434501120E+00, 7.2400630947E-03, 7.0870683781E-03, 5.6971184365E-01],
	[1.5780000000E+04, 4.0548480682E-01, 1.9432486686E+00, 7.2466655123E-03, 7.0934417937E-03, 5.6983031013E-01],
	[1.5785000000E+04, 4.0564779841E-01, 1.9430473098E+00, 7.2532718563E-03, 7.0998188613E-03, 5.6994873128E-01],
	[1.5790000000E+04, 4.0581106332E-01, 1.9428467646E+00, 7.2598821277E-03, 7.1061996710E-03, 5.7006710713E-01],
	[1.5795000000E+04, 4.0597513657E-01, 1.9426485341E+00, 7.2664963277E-03, 7.1125844083E-03, 5.7018543766E-01],
	[1.5800000000E+04, 4.0613922419E-01, 1.9424503865E+00, 7.2731144574E-03, 7.1189728011E-03, 5.7030372291E-01],
	[1.5805000000E+04, 4.0630332618E-01, 1.9422523218E+00, 7.2797365178E-03, 7.1253648501E-03, 5.7042196285E-01],
	[1.5810000000E+04, 4.0646744254E-01, 1.9420543399E+00, 7.2863625100E-03, 7.1317605562E-03, 5.7054015752E-01],
	[1.5815000000E+04, 4.0663157327E-01, 1.9418564408E+00, 7.2929924352E-03, 7.1381599203E-03, 5.7065830691E-01],
	[1.5820000000E+04, 4.0679571836E-01, 1.9416586244E+00, 7.2996262943E-03, 7.1445629431E-03, 5.7077641102E-01],
	[1.5825000000E+04, 4.0695987780E-01, 1.9414608907E+00, 7.3062640886E-03, 7.1509696256E-03, 5.7089446987E-01],
	[1.5830000000E+04, 4.0712405160E-01, 1.9412632396E+00, 7.3129058190E-03, 7.1573799686E-03, 5.7101248347E-01],
	[1.5835000000E+04, 4.0728823975E-01, 1.9410656710E+00, 7.3195514868E-03, 7.1637939729E-03, 5.7113045181E-01],
	[1.5840000000E+04, 4.0745244225E-01, 1.9408681848E+00, 7.3262010929E-03, 7.1702116394E-03, 5.7124837491E-01],
	[1.5845000000E+04, 4.0761665910E-01, 1.9406707811E+00, 7.3328546384E-03, 7.1766329689E-03, 5.7136625277E-01],
	[1.5850000000E+04, 4.0778089029E-01, 1.9404734598E+00, 7.3395121245E-03, 7.1830579622E-03, 5.7148408540E-01],
	[1.5855000000E+04, 4.0794513581E-01, 1.9402762207E+00, 7.3461735523E-03, 7.1894866201E-03, 5.7160187281E-01],
	[1.5860000000E+04, 4.0810939568E-01, 1.9400790638E+00, 7.3528389227E-03, 7.1959189436E-03, 5.7171961500E-01],
	[1.5865000000E+04, 4.0827366987E-01, 1.9398819892E+00, 7.3595082370E-03, 7.2023549335E-03, 5.7183731198E-01],
	[1.5870000000E+04, 4.0843795839E-01, 1.9396849966E+00, 7.3661814962E-03, 7.2087945905E-03, 5.7195496376E-01],
	[1.5875000000E+04, 4.0860226124E-01, 1.9394880861E+00, 7.3728587014E-03, 7.2152379156E-03, 5.7207257034E-01],
	[1.5880000000E+04, 4.0876657841E-01, 1.9392912576E+00, 7.3795398537E-03, 7.2216849096E-03, 5.7219013174E-01],
	[1.5885000000E+04, 4.0893090990E-01, 1.9390945110E+00, 7.3862249541E-03, 7.2281355732E-03, 5.7230764795E-01],
	[1.5890000000E+04, 4.0909525571E-01, 1.9388978462E+00, 7.3929140039E-03, 7.2345899075E-03, 5.7242511899E-01],
	[1.5895000000E+04, 4.0925961582E-01, 1.9387012633E+00, 7.3996070039E-03, 7.2410479131E-03, 5.7254254486E-01],
	[1.5900000000E+04, 4.0942399025E-01, 1.9385047621E+00, 7.4063039554E-03, 7.2475095909E-03, 5.7265992557E-01],
	[1.5905000000E+04, 4.0958837898E-01, 1.9383083427E+00, 7.4130048595E-03, 7.2539749418E-03, 5.7277726113E-01],
	[1.5910000000E+04, 4.0975278202E-01, 1.9381120048E+00, 7.4197097171E-03, 7.2604439666E-03, 5.7289455154E-01],
	[1.5915000000E+04, 4.0991719935E-01, 1.9379157485E+00, 7.4264185295E-03, 7.2669166662E-03, 5.7301179681E-01],
	[1.5920000000E+04, 4.1008163099E-01, 1.9377195738E+00, 7.4331312977E-03, 7.2733930413E-03, 5.7312899695E-01],
	[1.5925000000E+04, 4.1024607691E-01, 1.9375234805E+00, 7.4398480228E-03, 7.2798730928E-03, 5.7324615197E-01],
	[1.5930000000E+04, 4.1041053713E-01, 1.9373274686E+00, 7.4465687058E-03, 7.2863568216E-03, 5.7336326186E-01],
	[1.5935000000E+04, 4.1057501163E-01, 1.9371315380E+00, 7.4532933479E-03, 7.2928442285E-03, 5.7348032665E-01],
	[1.5940000000E+04, 4.1073950041E-01, 1.9369356887E+00, 7.4600219502E-03, 7.2993353143E-03, 5.7359734634E-01],
	[1.5945000000E+04, 4.1090400348E-01, 1.9367399206E+00, 7.4667545137E-03, 7.3058300799E-03, 5.7371432093E-01],
	[1.5950000000E+04, 4.1106852082E-01, 1.9365442336E+00, 7.4734910395E-03, 7.3123285261E-03, 5.7383125043E-01],
	[1.5955000000E+04, 4.1123305243E-01, 1.9363486278E+00, 7.4802315288E-03, 7.3188306537E-03, 5.7394813485E-01],
	[1.5960000000E+04, 4.1139759832E-01, 1.9361531030E+00, 7.4869759825E-03, 7.3253364635E-03, 5.7406497420E-01],
	[1.5965000000E+04, 4.1156215847E-01, 1.9359576592E+00, 7.4937244019E-03, 7.3318459565E-03, 5.7418176848E-01],
	[1.5970000000E+04, 4.1172673288E-01, 1.9357622963E+00, 7.5004767879E-03, 7.3383591334E-03, 5.7429851770E-01],
	[1.5975000000E+04, 4.1189132156E-01, 1.9355670142E+00, 7.5072331418E-03, 7.3448759951E-03, 5.7441522187E-01],
	[1.5980000000E+04, 4.1205592450E-01, 1.9353718130E+00, 7.5139934645E-03, 7.3513965424E-03, 5.7453188100E-01],
	[1.5985000000E+04, 4.1222054168E-01, 1.9351766925E+00, 7.5207577571E-03, 7.3579207761E-03, 5.7464849509E-01],
	[1.5990000000E+04, 4.1238517312E-01, 1.9349816527E+00, 7.5275260208E-03, 7.3644486971E-03, 5.7476506415E-01],
	[1.5995000000E+04, 4.1254981881E-01, 1.9347866935E+00, 7.5342982566E-03, 7.3709803063E-03, 5.7488158818E-01],
	[1.6000000000E+04, 4.1271447874E-01, 1.9345918149E+00, 7.5410744656E-03, 7.3775156043E-03, 5.7499806721E-01],
	[1.6005000000E+04, 4.1287915291E-01, 1.9343970168E+00, 7.5478546490E-03, 7.3840545922E-03, 5.7511450123E-01],
	[1.6010000000E+04, 4.1304384133E-01, 1.9342022991E+00, 7.5546388077E-03, 7.3905972706E-03, 5.7523089025E-01],
	[1.6015000000E+04, 4.1320854397E-01, 1.9340076618E+00, 7.5614269429E-03, 7.3971436406E-03, 5.7534723427E-01],
	[1.6020000000E+04, 4.1337326085E-01, 1.9338131049E+00, 7.5682190557E-03, 7.4036937028E-03, 5.7546353332E-01],
	[1.6025000000E+04, 4.1353799195E-01, 1.9336186283E+00, 7.5750151472E-03, 7.4102474581E-03, 5.7557978738E-01],
	[1.6030000000E+04, 4.1370273729E-01, 1.9334242318E+00, 7.5818152184E-03, 7.4168049073E-03, 5.7569599648E-01],
	[1.6035000000E+04, 4.1386749684E-01, 1.9332299156E+00, 7.5886192704E-03, 7.4233660513E-03, 5.7581216062E-01],
	[1.6040000000E+04, 4.1403227061E-01, 1.9330356794E+00, 7.5954273044E-03, 7.4299308910E-03, 5.7592827980E-01],
	[1.6045000000E+04, 4.1419749778E-01, 1.9328427093E+00, 7.6022393213E-03, 7.4364995862E-03, 5.7604435404E-01],
	[1.6050000000E+04, 4.1436336964E-01, 1.9326515197E+00, 7.6090553224E-03, 7.4430722077E-03, 5.7616038334E-01],
	[1.6055000000E+04, 4.1452925623E-01, 1.9324604086E+00, 7.6158753087E-03, 7.4496485283E-03, 5.7627636771E-01],
	[1.6060000000E+04, 4.1469515755E-01, 1.9322693759E+00, 7.6226992812E-03, 7.4562285488E-03, 5.7639230716E-01],
	[1.6065000000E+04, 4.1486107359E-01, 1.9320784216E+00, 7.6295272411E-03, 7.4628122700E-03, 5.7650820169E-01],
	[1.6070000000E+04, 4.1502700435E-01, 1.9318875455E+00, 7.6363591894E-03, 7.4693996929E-03, 5.7662405132E-01],
	[1.6075000000E+04, 4.1519294983E-01, 1.9316967476E+00, 7.6431951273E-03, 7.4759908181E-03, 5.7673985604E-01],
	[1.6080000000E+04, 4.1535891002E-01, 1.9315060280E+00, 7.6500350558E-03, 7.4825856466E-03, 5.7685561588E-01],
	[1.6085000000E+04, 4.1552488492E-01, 1.9313153864E+00, 7.6568789760E-03, 7.4891841792E-03, 5.7697133083E-01],
	[1.6090000000E+04, 4.1569087452E-01, 1.9311248229E+00, 7.6637268891E-03, 7.4957864168E-03, 5.7708700090E-01],
	[1.6095000000E+04, 4.1585687883E-01, 1.9309343374E+00, 7.6705787960E-03, 7.5023923600E-03, 5.7720262611E-01],
	[1.6100000000E+04, 4.1602289784E-01, 1.9307439299E+00, 7.6774346979E-03, 7.5090020099E-03, 5.7731820646E-01],
	[1.6105000000E+04, 4.1618893155E-01, 1.9305536002E+00, 7.6842945958E-03, 7.5156153672E-03, 5.7743374196E-01],
	[1.6110000000E+04, 4.1635497995E-01, 1.9303633484E+00, 7.6911584909E-03, 7.5222324327E-03, 5.7754923261E-01],
	[1.6115000000E+04, 4.1652104304E-01, 1.9301731743E+00, 7.6980263843E-03, 7.5288532072E-03, 5.7766467843E-01],
	[1.6120000000E+04, 4.1668712082E-01, 1.9299830780E+00, 7.7048982769E-03, 7.5354776917E-03, 5.7778007942E-01],
	[1.6125000000E+04, 4.1685321328E-01, 1.9297930593E+00, 7.7117741700E-03, 7.5421058870E-03, 5.7789543559E-01],
	[1.6130000000E+04, 4.1701932042E-01, 1.9296031183E+00, 7.7186540646E-03, 7.5487377937E-03, 5.7801074694E-01],
	[1.6135000000E+04, 4.1718544224E-01, 1.9294132548E+00, 7.7255379618E-03, 7.5553734129E-03, 5.7812601349E-01],
	[1.6140000000E+04, 4.1735157873E-01, 1.9292234688E+00, 7.7324258626E-03, 7.5620127453E-03, 5.7824123525E-01],
	[1.6145000000E+04, 4.1751772989E-01, 1.9290337603E+00, 7.7393177683E-03, 7.5686557918E-03, 5.7835641222E-01],
	[1.6150000000E+04, 4.1768389572E-01, 1.9288441291E+00, 7.7462136797E-03, 7.5753025532E-03, 5.7847154441E-01],
	[1.6155000000E+04, 4.1785007622E-01, 1.9286545753E+00, 7.7531135981E-03, 7.5819530302E-03, 5.7858663183E-01],
	[1.6160000000E+04, 4.1801627137E-01, 1.9284650987E+00, 7.7600175246E-03, 7.5886072238E-03, 5.7870167448E-01],
	[1.6165000000E+04, 4.1818248119E-01, 1.9282756994E+00, 7.7669254601E-03, 7.5952651348E-03, 5.7881667238E-01],
	[1.6170000000E+04, 4.1834870566E-01, 1.9280863772E+00, 7.7738374058E-03, 7.6019267640E-03, 5.7893162553E-01],
	[1.6175000000E+04, 4.1851494478E-01, 1.9278971322E+00, 7.7807533628E-03, 7.6085921122E-03, 5.7904653395E-01],
	[1.6180000000E+04, 4.1868119854E-01, 1.9277079642E+00, 7.7876733322E-03, 7.6152611802E-03, 5.7916139763E-01],
	[1.6185000000E+04, 4.1884746696E-01, 1.9275188732E+00, 7.7945973151E-03, 7.6219339690E-03, 5.7927621659E-01],
	[1.6190000000E+04, 4.1901375001E-01, 1.9273298592E+00, 7.8015253125E-03, 7.6286104792E-03, 5.7939099084E-01],
	[1.6195000000E+04, 4.1918004770E-01, 1.9271409220E+00, 7.8084573255E-03, 7.6352907118E-03, 5.7950572038E-01],
	[1.6200000000E+04, 4.1934636003E-01, 1.9269520617E+00, 7.8153933552E-03, 7.6419746676E-03, 5.7962040522E-01],
	[1.6205000000E+04, 4.1951268699E-01, 1.9267632782E+00, 7.8223334028E-03, 7.6486623474E-03, 5.7973504537E-01],
	[1.6210000000E+04, 4.1967902858E-01, 1.9265745714E+00, 7.8292774692E-03, 7.6553537520E-03, 5.7984964084E-01],
	[1.6215000000E+04, 4.1984538479E-01, 1.9263859412E+00, 7.8362255557E-03, 7.6620488822E-03, 5.7996419164E-01],
	[1.6220000000E+04, 4.2001175563E-01, 1.9261973877E+00, 7.8431776631E-03, 7.6687477389E-03, 5.8007869778E-01],
	[1.6225000000E+04, 4.2017814108E-01, 1.9260089107E+00, 7.8501337928E-03, 7.6754503229E-03, 5.8019315926E-01],
	[1.6230000000E+04, 4.2034454115E-01, 1.9258205103E+00, 7.8570939457E-03, 7.6821566350E-03, 5.8030757609E-01],
	[1.6235000000E+04, 4.2051095583E-01, 1.9256321863E+00, 7.8640581229E-03, 7.6888666761E-03, 5.8042194828E-01],
	[1.6240000000E+04, 4.2067738513E-01, 1.9254439387E+00, 7.8710263255E-03, 7.6955804470E-03, 5.8053627584E-01],
	[1.6245000000E+04, 4.2084382902E-01, 1.9252557674E+00, 7.8779985546E-03, 7.7022979485E-03, 5.8065055878E-01],
	[1.6250000000E+04, 4.2101028753E-01, 1.9250676725E+00, 7.8849748113E-03, 7.7090191814E-03, 5.8076479711E-01],
	[1.6255000000E+04, 4.2117676063E-01, 1.9248796537E+00, 7.8919550966E-03, 7.7157441466E-03, 5.8087899083E-01],
	[1.6260000000E+04, 4.2134324832E-01, 1.9246917112E+00, 7.8989394117E-03, 7.7224728448E-03, 5.8099313995E-01],
	[1.6265000000E+04, 4.2150975061E-01, 1.9245038447E+00, 7.9059277577E-03, 7.7292052770E-03, 5.8110724448E-01],
	[1.6270000000E+04, 4.2167626749E-01, 1.9243160544E+00, 7.9129201356E-03, 7.7359414438E-03, 5.8122130444E-01],
	[1.6275000000E+04, 4.2184279896E-01, 1.9241283400E+00, 7.9199165465E-03, 7.7426813463E-03, 5.8133531983E-01],
	[1.6280000000E+04, 4.2200934501E-01, 1.9239407017E+00, 7.9269169915E-03, 7.7494249851E-03, 5.8144929065E-01],
	[1.6285000000E+04, 4.2217590564E-01, 1.9237531392E+00, 7.9339214717E-03, 7.7561723611E-03, 5.8156321692E-01],
	[1.6290000000E+04, 4.2234248085E-01, 1.9235656526E+00, 7.9409299882E-03, 7.7629234752E-03, 5.8167709864E-01],
	[1.6295000000E+04, 4.2250907064E-01, 1.9233782418E+00, 7.9479425420E-03, 7.7696783281E-03, 5.8179093582E-01],
	[1.6300000000E+04, 4.2267567499E-01, 1.9231909067E+00, 7.9549591342E-03, 7.7764369206E-03, 5.8190472848E-01],
	[1.6305000000E+04, 4.2284311526E-01, 1.9230057793E+00, 7.9619797660E-03, 7.7831995669E-03, 5.8201847662E-01],
	[1.6310000000E+04, 4.2301083450E-01, 1.9228214115E+00, 7.9690044384E-03, 7.7899660561E-03, 5.8213218024E-01],
	[1.6315000000E+04, 4.2317856883E-01, 1.9226371178E+00, 7.9760331525E-03, 7.7967362884E-03, 5.8224583934E-01],
	[1.6320000000E+04, 4.2334631824E-01, 1.9224528982E+00, 7.9830659094E-03, 7.8035102648E-03, 5.8235945393E-01],
	[1.6325000000E+04, 4.2351408273E-01, 1.9222687528E+00, 7.9901027102E-03, 7.8102879859E-03, 5.8247302402E-01],
	[1.6330000000E+04, 4.2368186229E-01, 1.9220846813E+00, 7.9971435559E-03, 7.8170694527E-03, 5.8258654960E-01],
	[1.6335000000E+04, 4.2384965693E-01, 1.9219006838E+00, 8.0041884477E-03, 7.8238546660E-03, 5.8270003070E-01],
	[1.6340000000E+04, 4.2401746664E-01, 1.9217167602E+00, 8.0112373866E-03, 7.8306436265E-03, 5.8281346730E-01],
	[1.6345000000E+04, 4.2418529141E-01, 1.9215329105E+00, 8.0182903737E-03, 7.8374363352E-03, 5.8292685943E-01],
	[1.6350000000E+04, 4.2435313125E-01, 1.9213491346E+00, 8.0253474102E-03, 7.8442327928E-03, 5.8304020707E-01],
	[1.6355000000E+04, 4.2452098615E-01, 1.9211654325E+00, 8.0324084970E-03, 7.8510330002E-03, 5.8315351025E-01],
	[1.6360000000E+04, 4.2468885611E-01, 1.9209818041E+00, 8.0394736352E-03, 7.8578369582E-03, 5.8326676896E-01],
	[1.6365000000E+04, 4.2485674112E-01, 1.9207982493E+00, 8.0465428261E-03, 7.8646446676E-03, 5.8337998321E-01],
	[1.6370000000E+04, 4.2502464118E-01, 1.9206147681E+00, 8.0536160705E-03, 7.8714561292E-03, 5.8349315301E-01],
	[1.6375000000E+04, 4.2519255629E-01, 1.9204313605E+00, 8.0606933698E-03, 7.8782713438E-03, 5.8360627836E-01],
	[1.6380000000E+04, 4.2536048644E-01, 1.9202480264E+00, 8.0677747248E-03, 7.8850903124E-03, 5.8371935926E-01],
	[1.6385000000E+04, 4.2552843163E-01, 1.9200647657E+00, 8.0748601367E-03, 7.8919130356E-03, 5.8383239574E-01],
	[1.6390000000E+04, 4.2569639187E-01, 1.9198815785E+00, 8.0819496066E-03, 7.8987395143E-03, 5.8394538778E-01],
	[1.6395000000E+04, 4.2586436713E-01, 1.9196984646E+00, 8.0890431355E-03, 7.9055697494E-03, 5.8405833539E-01],
	[1.6400000000E+04, 4.2603235743E-01, 1.9195154239E+00, 8.0961407247E-03, 7.9124037416E-03, 5.8417123859E-01],
	[1.6405000000E+04, 4.2620036275E-01, 1.9193324565E+00, 8.1032423750E-03, 7.9192414918E-03, 5.8428409738E-01],
	[1.6410000000E+04, 4.2636838310E-01, 1.9191495623E+00, 8.1103480877E-03, 7.9260830008E-03, 5.8439691176E-01],
	[1.6415000000E+04, 4.2653641847E-01, 1.9189667413E+00, 8.1174578638E-03, 7.9329282695E-03, 5.8450968174E-01],
	[1.6420000000E+04, 4.2670446886E-01, 1.9187839933E+00, 8.1245717043E-03, 7.9397772985E-03, 5.8462240732E-01],
	[1.6425000000E+04, 4.2687253427E-01, 1.9186013183E+00, 8.1316896105E-03, 7.9466300889E-03, 5.8473508852E-01],
	[1.6430000000E+04, 4.2704061468E-01, 1.9184187164E+00, 8.1388115833E-03, 7.9534866413E-03, 5.8484772533E-01],
	[1.6435000000E+04, 4.2720871011E-01, 1.9182361874E+00, 8.1459376239E-03, 7.9603469566E-03, 5.8496031777E-01],
	[1.6440000000E+04, 4.2737682053E-01, 1.9180537312E+00, 8.1530677333E-03, 7.9672110356E-03, 5.8507286584E-01],
	[1.6445000000E+04, 4.2754494597E-01, 1.9178713479E+00, 8.1602019126E-03, 7.9740788791E-03, 5.8518536955E-01],
	[1.6450000000E+04, 4.2771308640E-01, 1.9176890374E+00, 8.1673401629E-03, 7.9809504880E-03, 5.8529782889E-01],
	[1.6455000000E+04, 4.2788124182E-01, 1.9175067996E+00, 8.1744824853E-03, 7.9878258631E-03, 5.8541024389E-01],
	[1.6460000000E+04, 4.2804941224E-01, 1.9173246344E+00, 8.1816288809E-03, 7.9947050052E-03, 5.8552261454E-01],
	[1.6465000000E+04, 4.2821759765E-01, 1.9171425419E+00, 8.1887793507E-03, 8.0015879151E-03, 5.8563494085E-01],
	[1.6470000000E+04, 4.2838579804E-01, 1.9169605220E+00, 8.1959338959E-03, 8.0084745936E-03, 5.8574722283E-01],
	[1.6475000000E+04, 4.2855401342E-01, 1.9167785746E+00, 8.2030925175E-03, 8.0153650415E-03, 5.8585946048E-01],
	[1.6480000000E+04, 4.2872224378E-01, 1.9165966996E+00, 8.2102552166E-03, 8.0222592597E-03, 5.8597165382E-01],
	[1.6485000000E+04, 4.2889048911E-01, 1.9164148971E+00, 8.2174219942E-03, 8.0291572490E-03, 5.8608380284E-01],
	[1.6490000000E+04, 4.2905874941E-01, 1.9162331670E+00, 8.2245928516E-03, 8.0360590102E-03, 5.8619590755E-01],
	[1.6495000000E+04, 4.2922702469E-01, 1.9160515092E+00, 8.2317677897E-03, 8.0429645442E-03, 5.8630796796E-01],
	[1.6500000000E+04, 4.2939531493E-01, 1.9158699236E+00, 8.2389468097E-03, 8.0498738516E-03, 5.8641998407E-01],
	[1.6505000000E+04, 4.2956362014E-01, 1.9156884103E+00, 8.2461299126E-03, 8.0567869334E-03, 5.8653195590E-01],
	[1.6510000000E+04, 4.2973194030E-01, 1.9155069691E+00, 8.2533170995E-03, 8.0637037903E-03, 5.8664388345E-01],
	[1.6515000000E+04, 4.2990027542E-01, 1.9153256000E+00, 8.2605083715E-03, 8.0706244233E-03, 5.8675576672E-01],
	[1.6520000000E+04, 4.3006862550E-01, 1.9151443031E+00, 8.2677037297E-03, 8.0775488330E-03, 5.8686760572E-01],
	[1.6525000000E+04, 4.3023699053E-01, 1.9149630781E+00, 8.2749031752E-03, 8.0844770204E-03, 5.8697940046E-01],
	[1.6530000000E+04, 4.3040537050E-01, 1.9147819251E+00, 8.2821067090E-03, 8.0914089862E-03, 5.8709115095E-01],
	[1.6535000000E+04, 4.3057376542E-01, 1.9146008440E+00, 8.2893143323E-03, 8.0983447312E-03, 5.8720285719E-01],
	[1.6540000000E+04, 4.3074217528E-01, 1.9144198348E+00, 8.2965260460E-03, 8.1052842563E-03, 5.8731451918E-01],
	[1.6545000000E+04, 4.3091060008E-01, 1.9142388974E+00, 8.3037418514E-03, 8.1122275622E-03, 5.8742613694E-01],
	[1.6550000000E+04, 4.3107903982E-01, 1.9140580317E+00, 8.3109617495E-03, 8.1191746499E-03, 5.8753771047E-01],
	[1.6555000000E+04, 4.3124749448E-01, 1.9138772378E+00, 8.3181857413E-03, 8.1261255200E-03, 5.8764923977E-01],
	[1.6560000000E+04, 4.3141596407E-01, 1.9136965156E+00, 8.3254138279E-03, 8.1330801735E-03, 5.8776072487E-01],
	[1.6565000000E+04, 4.3158474742E-01, 1.9135166108E+00, 8.3326460106E-03, 8.1400387309E-03, 5.8787216575E-01],
	[1.6570000000E+04, 4.3175434853E-01, 1.9133387799E+00, 8.3398822902E-03, 8.1470013957E-03, 5.8798356243E-01],
	[1.6575000000E+04, 4.3192396510E-01, 1.9131610192E+00, 8.3471226679E-03, 8.1539678473E-03, 5.8809491491E-01],
	[1.6580000000E+04, 4.3209359711E-01, 1.9129833286E+00, 8.3543671449E-03, 8.1609380865E-03, 5.8820622321E-01],
	[1.6585000000E+04, 4.3226324457E-01, 1.9128057081E+00, 8.3616157220E-03, 8.1679121143E-03, 5.8831748732E-01],
	[1.6590000000E+04, 4.3243290746E-01, 1.9126281576E+00, 8.3688684006E-03, 8.1748899313E-03, 5.8842870726E-01],
	[1.6595000000E+04, 4.3260258579E-01, 1.9124506771E+00, 8.3761251816E-03, 8.1818715384E-03, 5.8853988303E-01],
	[1.6600000000E+04, 4.3277227955E-01, 1.9122732665E+00, 8.3833860661E-03, 8.1888569364E-03, 5.8865101464E-01],
	[1.6605000000E+04, 4.3294198874E-01, 1.9120959258E+00, 8.3906510552E-03, 8.1958461262E-03, 5.8876210210E-01],
	[1.6610000000E+04, 4.3311171336E-01, 1.9119186549E+00, 8.3979201500E-03, 8.2028391085E-03, 5.8887314541E-01],
	[1.6615000000E+04, 4.3328145341E-01, 1.9117414538E+00, 8.4051933516E-03, 8.2098358842E-03, 5.8898414458E-01],
	[1.6620000000E+04, 4.3345120887E-01, 1.9115643225E+00, 8.4124706610E-03, 8.2168364540E-03, 5.8909509961E-01],
	[1.6625000000E+04, 4.3362097974E-01, 1.9113872608E+00, 8.4197520794E-03, 8.2238408188E-03, 5.8920601052E-01],
	[1.6630000000E+04, 4.3379076604E-01, 1.9112102687E+00, 8.4270376078E-03, 8.2308489795E-03, 5.8931687730E-01],
	[1.6635000000E+04, 4.3396056774E-01, 1.9110333463E+00, 8.4343272473E-03, 8.2378609367E-03, 5.8942769998E-01],
	[1.6640000000E+04, 4.3413038485E-01, 1.9108564934E+00, 8.4416209990E-03, 8.2448766913E-03, 5.8953847855E-01],
	[1.6645000000E+04, 4.3430021736E-01, 1.9106797099E+00, 8.4489188639E-03, 8.2518962442E-03, 5.8964921302E-01],
	[1.6650000000E+04, 4.3447006527E-01, 1.9105029960E+00, 8.4562208432E-03, 8.2589195961E-03, 5.8975990340E-01],
	[1.6655000000E+04, 4.3463992858E-01, 1.9103263514E+00, 8.4635269380E-03, 8.2659467479E-03, 5.8987054970E-01],
	[1.6660000000E+04, 4.3480980728E-01, 1.9101497762E+00, 8.4708371492E-03, 8.2729777004E-03, 5.8998115192E-01],
	[1.6665000000E+04, 4.3497970138E-01, 1.9099732702E+00, 8.4781514781E-03, 8.2800124543E-03, 5.9009171007E-01],
	[1.6670000000E+04, 4.3514961086E-01, 1.9097968335E+00, 8.4854699256E-03, 8.2870510105E-03, 5.9020222415E-01],
	[1.6675000000E+04, 4.3531953573E-01, 1.9096204661E+00, 8.4927924930E-03, 8.2940933699E-03, 5.9031269419E-01],
	[1.6680000000E+04, 4.3548947597E-01, 1.9094441677E+00, 8.5001191811E-03, 8.3011395331E-03, 5.9042312017E-01],
	[1.6685000000E+04, 4.3565943160E-01, 1.9092679385E+00, 8.5074499912E-03, 8.3081895011E-03, 5.9053350211E-01],
	[1.6690000000E+04, 4.3582940260E-01, 1.9090917784E+00, 8.5147849244E-03, 8.3152432746E-03, 5.9064384002E-01],
	[1.6695000000E+04, 4.3599938897E-01, 1.9089156872E+00, 8.5221239816E-03, 8.3223008545E-03, 5.9075413390E-01],
	[1.6700000000E+04, 4.3616939071E-01, 1.9087396651E+00, 8.5294671640E-03, 8.3293622415E-03, 5.9086438376E-01],
	[1.6705000000E+04, 4.3633940781E-01, 1.9085637118E+00, 8.5368144726E-03, 8.3364274365E-03, 5.9097458962E-01],
	[1.6710000000E+04, 4.3650944028E-01, 1.9083878274E+00, 8.5441659086E-03, 8.3434964403E-03, 5.9108475146E-01],
	[1.6715000000E+04, 4.3667948810E-01, 1.9082120118E+00, 8.5515214731E-03, 8.3505692536E-03, 5.9119486931E-01],
	[1.6720000000E+04, 4.3684955128E-01, 1.9080362650E+00, 8.5588811670E-03, 8.3576458774E-03, 5.9130494317E-01],
	[1.6725000000E+04, 4.3701962981E-01, 1.9078605870E+00, 8.5662449916E-03, 8.3647263124E-03, 5.9141497305E-01],
	[1.6730000000E+04, 4.3718972370E-01, 1.9076849776E+00, 8.5736129478E-03, 8.3718105593E-03, 5.9152495896E-01],
	[1.6735000000E+04, 4.3735983292E-01, 1.9075094368E+00, 8.5809850368E-03, 8.3788986191E-03, 5.9163490089E-01],
	[1.6740000000E+04, 4.3752995749E-01, 1.9073339647E+00, 8.5883612596E-03, 8.3859904926E-03, 5.9174479887E-01],
	[1.6745000000E+04, 4.3770009740E-01, 1.9071585610E+00, 8.5957416174E-03, 8.3930861805E-03, 5.9185465290E-01],
	[1.6750000000E+04, 4.3787025264E-01, 1.9069832259E+00, 8.6031261111E-03, 8.4001856836E-03, 5.9196446298E-01],
	[1.6755000000E+04, 4.3804042322E-01, 1.9068079592E+00, 8.6105147420E-03, 8.4072890028E-03, 5.9207422912E-01],
	[1.6760000000E+04, 4.3821060913E-01, 1.9066327609E+00, 8.6179075110E-03, 8.4143961388E-03, 5.9218395133E-01],
	[1.6765000000E+04, 4.3838081036E-01, 1.9064576309E+00, 8.6253044192E-03, 8.4215070926E-03, 5.9229362962E-01],
	[1.6770000000E+04, 4.3855102692E-01, 1.9062825693E+00, 8.6327054678E-03, 8.4286218648E-03, 5.9240326400E-01],
	[1.6775000000E+04, 4.3872125880E-01, 1.9061075759E+00, 8.6401106579E-03, 8.4357404563E-03, 5.9251285447E-01],
	[1.6780000000E+04, 4.3889150599E-01, 1.9059326507E+00, 8.6475199904E-03, 8.4428628678E-03, 5.9262240104E-01],
	[1.6785000000E+04, 4.3906176850E-01, 1.9057577937E+00, 8.6549334665E-03, 8.4499891003E-03, 5.9273190372E-01],
	[1.6790000000E+04, 4.3923204632E-01, 1.9055830048E+00, 8.6623510872E-03, 8.4571191545E-03, 5.9284136252E-01],
	[1.6795000000E+04, 4.3940233945E-01, 1.9054082839E+00, 8.6697728537E-03, 8.4642530312E-03, 5.9295077744E-01],
	[1.6800000000E+04, 4.3957264788E-01, 1.9052336311E+00, 8.6771987670E-03, 8.4713907313E-03, 5.9306014849E-01],
	[1.6805000000E+04, 4.3974297161E-01, 1.9050590463E+00, 8.6846288283E-03, 8.4785322554E-03, 5.9316947568E-01],
	[1.6810000000E+04, 4.3991331064E-01, 1.9048845293E+00, 8.6920630385E-03, 8.4856776045E-03, 5.9327875902E-01],
	[1.6815000000E+04, 4.4008366496E-01, 1.9047100803E+00, 8.6995013988E-03, 8.4928267794E-03, 5.9338799852E-01],
	[1.6820000000E+04, 4.4025403458E-01, 1.9045356991E+00, 8.7069439102E-03, 8.4999797808E-03, 5.9349719418E-01],
	[1.6825000000E+04, 4.4042441948E-01, 1.9043613857E+00, 8.7143905739E-03, 8.5071366095E-03, 5.9360634600E-01],
	[1.6830000000E+04, 4.4059481967E-01, 1.9041871400E+00, 8.7218413909E-03, 8.5142972664E-03, 5.9371545401E-01],
	[1.6835000000E+04, 4.4076628705E-01, 1.9040154856E+00, 8.7292963623E-03, 8.5214621959E-03, 5.9382451820E-01],
	[1.6840000000E+04, 4.4093783630E-01, 1.9038440560E+00, 8.7367554892E-03, 8.5286309842E-03, 5.9393353859E-01],
	[1.6845000000E+04, 4.4110940135E-01, 1.9036726928E+00, 8.7442187726E-03, 8.5358036042E-03, 5.9404251518E-01],
	[1.6850000000E+04, 4.4128098221E-01, 1.9035013959E+00, 8.7516862137E-03, 8.5429800567E-03, 5.9415144798E-01],
	[1.6855000000E+04, 4.4145257888E-01, 1.9033301652E+00, 8.7591578135E-03, 8.5501603425E-03, 5.9426033700E-01],
	[1.6860000000E+04, 4.4162419135E-01, 1.9031590006E+00, 8.7666335731E-03, 8.5573444625E-03, 5.9436918225E-01],
	[1.6865000000E+04, 4.4179581961E-01, 1.9029879022E+00, 8.7741134936E-03, 8.5645324173E-03, 5.9447798373E-01],
	[1.6870000000E+04, 4.4196746368E-01, 1.9028168699E+00, 8.7815975760E-03, 8.5717242079E-03, 5.9458674145E-01],
	[1.6875000000E+04, 4.4213912353E-01, 1.9026459037E+00, 8.7890858215E-03, 8.5789198351E-03, 5.9469545542E-01],
	[1.6880000000E+04, 4.4231079917E-01, 1.9024750035E+00, 8.7965782312E-03, 8.5861192995E-03, 5.9480412566E-01],
	[1.6885000000E+04, 4.4248249059E-01, 1.9023041692E+00, 8.8040748060E-03, 8.5933226021E-03, 5.9491275215E-01],
	[1.6890000000E+04, 4.4265419780E-01, 1.9021334008E+00, 8.8115755471E-03, 8.6005297437E-03, 5.9502133493E-01],
	[1.6895000000E+04, 4.4282592079E-01, 1.9019626983E+00, 8.8190804556E-03, 8.6077407250E-03, 5.9512987398E-01],
	[1.6900000000E+04, 4.4299765955E-01, 1.9017920616E+00, 8.8265895326E-03, 8.6149555468E-03, 5.9523836933E-01],
	[1.6905000000E+04, 4.4316941408E-01, 1.9016214907E+00, 8.8341027791E-03, 8.6221742100E-03, 5.9534682097E-01],
	[1.6910000000E+04, 4.4334118438E-01, 1.9014509856E+00, 8.8416201962E-03, 8.6293967154E-03, 5.9545522893E-01],
	[1.6915000000E+04, 4.4351297045E-01, 1.9012805461E+00, 8.8491417850E-03, 8.6366230637E-03, 5.9556359319E-01],
	[1.6920000000E+04, 4.4368477228E-01, 1.9011101723E+00, 8.8566675466E-03, 8.6438532558E-03, 5.9567191379E-01],
	[1.6925000000E+04, 4.4385658987E-01, 1.9009398640E+00, 8.8641974821E-03, 8.6510872925E-03, 5.9578019071E-01],
	[1.6930000000E+04, 4.4402842322E-01, 1.9007696214E+00, 8.8717315924E-03, 8.6583251745E-03, 5.9588842397E-01],
	[1.6935000000E+04, 4.4420027232E-01, 1.9005994442E+00, 8.8792698788E-03, 8.6655669027E-03, 5.9599661359E-01],
	[1.6940000000E+04, 4.4437213717E-01, 1.9004293325E+00, 8.8868123424E-03, 8.6728124779E-03, 5.9610475956E-01],
	[1.6945000000E+04, 4.4454401776E-01, 1.9002592862E+00, 8.8943589840E-03, 8.6800619009E-03, 5.9621286189E-01],
	[1.6950000000E+04, 4.4471591410E-01, 1.9000893053E+00, 8.9019098050E-03, 8.6873151724E-03, 5.9632092060E-01],
	[1.6955000000E+04, 4.4488782618E-01, 1.8999193897E+00, 8.9094648063E-03, 8.6945722933E-03, 5.9642893569E-01],
	[1.6960000000E+04, 4.4505975400E-01, 1.8997495395E+00, 8.9170239890E-03, 8.7018332644E-03, 5.9653690717E-01],
	[1.6965000000E+04, 4.4523169755E-01, 1.8995797544E+00, 8.9245873542E-03, 8.7090980865E-03, 5.9664483505E-01],
	[1.6970000000E+04, 4.4540365683E-01, 1.8994100346E+00, 8.9321549030E-03, 8.7163667604E-03, 5.9675271933E-01],
	[1.6975000000E+04, 4.4557563183E-01, 1.8992403799E+00, 8.9397266365E-03, 8.7236392869E-03, 5.9686056004E-01],
	[1.6980000000E+04, 4.4574762257E-01, 1.8990707903E+00, 8.9473025557E-03, 8.7309156667E-03, 5.9696835716E-01],
	[1.6985000000E+04, 4.4591962902E-01, 1.8989012658E+00, 8.9548826617E-03, 8.7381959007E-03, 5.9707611072E-01],
	[1.6990000000E+04, 4.4609165119E-01, 1.8987318064E+00, 8.9624669557E-03, 8.7454799897E-03, 5.9718382072E-01],
	[1.6995000000E+04, 4.4626368907E-01, 1.8985624119E+00, 8.9700554386E-03, 8.7527679345E-03, 5.9729148717E-01],
	[1.7000000000E+04, 4.4643574267E-01, 1.8983930823E+00, 8.9776481116E-03, 8.7600597359E-03, 5.9739911007E-01],
	[1.7005000000E+04, 4.4660781197E-01, 1.8982238176E+00, 8.9852449757E-03, 8.7673553947E-03, 5.9750668945E-01],
	[1.7010000000E+04, 4.4677989698E-01, 1.8980546178E+00, 8.9928460321E-03, 8.7746549116E-03, 5.9761422530E-01],
	[1.7015000000E+04, 4.4695199769E-01, 1.8978854828E+00, 9.0004512818E-03, 8.7819582876E-03, 5.9772171763E-01],
	[1.7020000000E+04, 4.4712411410E-01, 1.8977164125E+00, 9.0080607258E-03, 8.7892655233E-03, 5.9782916645E-01],
	[1.7025000000E+04, 4.4729624620E-01, 1.8975474070E+00, 9.0156743654E-03, 8.7965766196E-03, 5.9793657178E-01],
	[1.7030000000E+04, 4.4746839400E-01, 1.8973784661E+00, 9.0232922014E-03, 8.8038915772E-03, 5.9804393361E-01],
	[1.7035000000E+04, 4.4764055749E-01, 1.8972095898E+00, 9.0309142351E-03, 8.8112103971E-03, 5.9815125197E-01],
	[1.7040000000E+04, 4.4781273666E-01, 1.8970407782E+00, 9.0385404675E-03, 8.8185330799E-03, 5.9825852685E-01],
	[1.7045000000E+04, 4.4798493151E-01, 1.8968720311E+00, 9.0461708997E-03, 8.8258596265E-03, 5.9836575826E-01],
	[1.7050000000E+04, 4.4815714205E-01, 1.8967033484E+00, 9.0538055328E-03, 8.8331900377E-03, 5.9847294622E-01],
	[1.7055000000E+04, 4.4832936826E-01, 1.8965347303E+00, 9.0614443678E-03, 8.8405243142E-03, 5.9858009073E-01],
	[1.7060000000E+04, 4.4850161014E-01, 1.8963661765E+00, 9.0690874058E-03, 8.8478624569E-03, 5.9868719181E-01],
	[1.7065000000E+04, 4.4867386770E-01, 1.8961976871E+00, 9.0767346480E-03, 8.8552044665E-03, 5.9879424946E-01],
	[1.7070000000E+04, 4.4884614092E-01, 1.8960292620E+00, 9.0843860953E-03, 8.8625503440E-03, 5.9890126368E-01],
	[1.7075000000E+04, 4.4901842980E-01, 1.8958609012E+00, 9.0920417489E-03, 8.8699000899E-03, 5.9900823450E-01],
	[1.7080000000E+04, 4.4919073434E-01, 1.8956926047E+00, 9.0997016098E-03, 8.8772537052E-03, 5.9911516191E-01],
	[1.7085000000E+04, 4.4936305455E-01, 1.8955243723E+00, 9.1073656792E-03, 8.8846111907E-03, 5.9922204592E-01],
	[1.7090000000E+04, 4.4953539040E-01, 1.8953562041E+00, 9.1150339580E-03, 8.8919725471E-03, 5.9932888655E-01],
	[1.7095000000E+04, 4.4970774191E-01, 1.8951881000E+00, 9.1227064475E-03, 8.8993377753E-03, 5.9943568381E-01],
	[1.7100000000E+04, 4.4988010907E-01, 1.8950200600E+00, 9.1303831486E-03, 8.9067068759E-03, 5.9954243770E-01],
	[1.7105000000E+04, 4.5005334506E-01, 1.8948540521E+00, 9.1380640624E-03, 8.9140802282E-03, 5.9964914823E-01],
	[1.7110000000E+04, 4.5022687865E-01, 1.8946887563E+00, 9.1457491901E-03, 8.9214575805E-03, 5.9975581541E-01],
	[1.7115000000E+04, 4.5040042841E-01, 1.8945235233E+00, 9.1534385327E-03, 8.9288388088E-03, 5.9986243925E-01],
	[1.7120000000E+04, 4.5057399434E-01, 1.8943583529E+00, 9.1611320912E-03, 8.9362239141E-03, 5.9996901976E-01],
	[1.7125000000E+04, 4.5074757645E-01, 1.8941932452E+00, 9.1688298668E-03, 8.9436128970E-03, 6.0007555694E-01],
	[1.7130000000E+04, 4.5092117473E-01, 1.8940282001E+00, 9.1765318606E-03, 8.9510057585E-03, 6.0018205081E-01],
	[1.7135000000E+04, 4.5109478918E-01, 1.8938632175E+00, 9.1842380735E-03, 8.9584024992E-03, 6.0028850138E-01],
	[1.7140000000E+04, 4.5126841978E-01, 1.8936982974E+00, 9.1919485068E-03, 8.9658031200E-03, 6.0039490865E-01],
	[1.7145000000E+04, 4.5144206655E-01, 1.8935334397E+00, 9.1996631614E-03, 8.9732076217E-03, 6.0050127264E-01],
	[1.7150000000E+04, 4.5161572947E-01, 1.8933686445E+00, 9.2073820385E-03, 8.9806160051E-03, 6.0060759335E-01],
	[1.7155000000E+04, 4.5178940855E-01, 1.8932039116E+00, 9.2151051392E-03, 8.9880282710E-03, 6.0071387079E-01],
	[1.7160000000E+04, 4.5196310377E-01, 1.8930392411E+00, 9.2228324644E-03, 8.9954444201E-03, 6.0082010497E-01],
	[1.7165000000E+04, 4.5213681514E-01, 1.8928746329E+00, 9.2305640153E-03, 9.0028644533E-03, 6.0092629590E-01],
	[1.7170000000E+04, 4.5231054266E-01, 1.8927100869E+00, 9.2382997930E-03, 9.0102883713E-03, 6.0103244359E-01],
	[1.7175000000E+04, 4.5248428631E-01, 1.8925456031E+00, 9.2460397986E-03, 9.0177161750E-03, 6.0113854805E-01],
	[1.7180000000E+04, 4.5265804611E-01, 1.8923811815E+00, 9.2537840331E-03, 9.0251478652E-03, 6.0124460928E-01],
	[1.7185000000E+04, 4.5283182203E-01, 1.8922168220E+00, 9.2615324976E-03, 9.0325834425E-03, 6.0135062731E-01],
	[1.7190000000E+04, 4.5300561409E-01, 1.8920525246E+00, 9.2692851931E-03, 9.0400229079E-03, 6.0145660212E-01],
	[1.7195000000E+04, 4.5317942228E-01, 1.8918882893E+00, 9.2770421209E-03, 9.0474662622E-03, 6.0156253375E-01],
	[1.7200000000E+04, 4.5335324659E-01, 1.8917241159E+00, 9.2848032819E-03, 9.0549135060E-03, 6.0166842219E-01],
	[1.7205000000E+04, 4.5352708702E-01, 1.8915600045E+00, 9.2925686772E-03, 9.0623646403E-03, 6.0177426745E-01],
	[1.7210000000E+04, 4.5370094356E-01, 1.8913959550E+00, 9.3003383079E-03, 9.0698196657E-03, 6.0188006954E-01],
	[1.7215000000E+04, 4.5387481623E-01, 1.8912319674E+00, 9.3081121751E-03, 9.0772785832E-03, 6.0198582848E-01],
	[1.7220000000E+04, 4.5404870500E-01, 1.8910680416E+00, 9.3158902798E-03, 9.0847413934E-03, 6.0209154427E-01],
	[1.7225000000E+04, 4.5422260988E-01, 1.8909041776E+00, 9.3236726232E-03, 9.0922080973E-03, 6.0219721692E-01],
	[1.7230000000E+04, 4.5439653087E-01, 1.8907403754E+00, 9.3314592063E-03, 9.0996786954E-03, 6.0230284644E-01],
	[1.7235000000E+04, 4.5457046796E-01, 1.8905766349E+00, 9.3392500302E-03, 9.1071531888E-03, 6.0240843285E-01],
	[1.7240000000E+04, 4.5474442115E-01, 1.8904129560E+00, 9.3470450959E-03, 9.1146315781E-03, 6.0251397614E-01],
	[1.7245000000E+04, 4.5491839043E-01, 1.8902493388E+00, 9.3548444046E-03, 9.1221138642E-03, 6.0261947632E-01],
	[1.7250000000E+04, 4.5509237581E-01, 1.8900857832E+00, 9.3626479574E-03, 9.1296000478E-03, 6.0272493342E-01],
	[1.7255000000E+04, 4.5526637728E-01, 1.8899222891E+00, 9.3704557552E-03, 9.1370901297E-03, 6.0283034744E-01],
	[1.7260000000E+04, 4.5544039483E-01, 1.8897588565E+00, 9.3782677993E-03, 9.1445841107E-03, 6.0293571838E-01],
	[1.7265000000E+04, 4.5561442846E-01, 1.8895954854E+00, 9.3860840905E-03, 9.1520819917E-03, 6.0304104625E-01],
	[1.7270000000E+04, 4.5578847818E-01, 1.8894321757E+00, 9.3939046302E-03, 9.1595837733E-03, 6.0314633108E-01],
	[1.7275000000E+04, 4.5596254397E-01, 1.8892689274E+00, 9.4017294192E-03, 9.1670894565E-03, 6.0325157286E-01],
	[1.7280000000E+04, 4.5613662583E-01, 1.8891057404E+00, 9.4095584588E-03, 9.1745990419E-03, 6.0335677160E-01],
	[1.7285000000E+04, 4.5631072377E-01, 1.8889426147E+00, 9.4173917499E-03, 9.1821125304E-03, 6.0346192732E-01],
	[1.7290000000E+04, 4.5648483777E-01, 1.8887795503E+00, 9.4252292937E-03, 9.1896299227E-03, 6.0356704002E-01],
	[1.7295000000E+04, 4.5665896783E-01, 1.8886165471E+00, 9.4330710912E-03, 9.1971512197E-03, 6.0367210972E-01],
	[1.7300000000E+04, 4.5683311396E-01, 1.8884536051E+00, 9.4409171435E-03, 9.2046764221E-03, 6.0377713642E-01],
	[1.7305000000E+04, 4.5700727614E-01, 1.8882907242E+00, 9.4487674517E-03, 9.2122055307E-03, 6.0388212013E-01],
	[1.7310000000E+04, 4.5718145438E-01, 1.8881279044E+00, 9.4566220169E-03, 9.2197385464E-03, 6.0398706087E-01],
	[1.7315000000E+04, 4.5735564867E-01, 1.8879651457E+00, 9.4644808401E-03, 9.2272754699E-03, 6.0409195863E-01],
	[1.7320000000E+04, 4.5752985901E-01, 1.8878024480E+00, 9.4723439224E-03, 9.2348163019E-03, 6.0419681344E-01],
	[1.7325000000E+04, 4.5770408539E-01, 1.8876398113E+00, 9.4802112649E-03, 9.2423610433E-03, 6.0430162531E-01],
	[1.7330000000E+04, 4.5787832782E-01, 1.8874772355E+00, 9.4880828688E-03, 9.2499096949E-03, 6.0440639423E-01],
	[1.7335000000E+04, 4.5805258628E-01, 1.8873147206E+00, 9.4959587349E-03, 9.2574622575E-03, 6.0451112022E-01],
	[1.7340000000E+04, 4.5822686078E-01, 1.8871522665E+00, 9.5038388645E-03, 9.2650187318E-03, 6.0461580329E-01],
	[1.7345000000E+04, 4.5840115131E-01, 1.8869898733E+00, 9.5117232586E-03, 9.2725791186E-03, 6.0472044346E-01],
	[1.7350000000E+04, 4.5857545787E-01, 1.8868275409E+00, 9.5196119183E-03, 9.2801434187E-03, 6.0482504072E-01],
	[1.7355000000E+04, 4.5874978045E-01, 1.8866652691E+00, 9.5275048446E-03, 9.2877116329E-03, 6.0492959510E-01],
	[1.7360000000E+04, 4.5892411906E-01, 1.8865030581E+00, 9.5354020387E-03, 9.2952837621E-03, 6.0503410659E-01],
	[1.7365000000E+04, 4.5909847369E-01, 1.8863409077E+00, 9.5433035016E-03, 9.3028598068E-03, 6.0513857521E-01],
	[1.7370000000E+04, 4.5927284434E-01, 1.8861788180E+00, 9.5512092344E-03, 9.3104397681E-03, 6.0524300098E-01],
	[1.7375000000E+04, 4.5944723100E-01, 1.8860167888E+00, 9.5591192382E-03, 9.3180236466E-03, 6.0534738389E-01],
	[1.7380000000E+04, 4.5962242879E-01, 1.8858565841E+00, 9.5670335140E-03, 9.3256118136E-03, 6.0545172396E-01],
	[1.7385000000E+04, 4.5979799928E-01, 1.8856972292E+00, 9.5749520630E-03, 9.3332040664E-03, 6.0555602120E-01],
	[1.7390000000E+04, 4.5997358632E-01, 1.8855379336E+00, 9.5828748861E-03, 9.3408002401E-03, 6.0566027562E-01],
	[1.7395000000E+04, 4.6014918990E-01, 1.8853786972E+00, 9.5908019846E-03, 9.3484003354E-03, 6.0576448723E-01],
	[1.7400000000E+04, 4.6032481003E-01, 1.8852195200E+00, 9.5987333594E-03, 9.3560043531E-03, 6.0586865603E-01],
	[1.7405000000E+04, 4.6050044670E-01, 1.8850604020E+00, 9.6066690116E-03, 9.3636122941E-03, 6.0597278205E-01],
	[1.7410000000E+04, 4.6067609990E-01, 1.8849013431E+00, 9.6146089423E-03, 9.3712241590E-03, 6.0607686528E-01],
	[1.7415000000E+04, 4.6085176964E-01, 1.8847423433E+00, 9.6225531527E-03, 9.3788399487E-03, 6.0618090574E-01],
	[1.7420000000E+04, 4.6102745591E-01, 1.8845834026E+00, 9.6305016437E-03, 9.3864596640E-03, 6.0628490344E-01],
	[1.7425000000E+04, 4.6120315871E-01, 1.8844245209E+00, 9.6384544164E-03, 9.3940833056E-03, 6.0638885839E-01],
	[1.7430000000E+04, 4.6137887803E-01, 1.8842656981E+00, 9.6464114720E-03, 9.4017108744E-03, 6.0649277060E-01],
	[1.7435000000E+04, 4.6155461387E-01, 1.8841069343E+00, 9.6543728114E-03, 9.4093423710E-03, 6.0659664007E-01],
	[1.7440000000E+04, 4.6173036622E-01, 1.8839482294E+00, 9.6623384359E-03, 9.4169777964E-03, 6.0670046681E-01],
	[1.7445000000E+04, 4.6190613509E-01, 1.8837895833E+00, 9.6703083464E-03, 9.4246171513E-03, 6.0680425083E-01],
	[1.7450000000E+04, 4.6208192048E-01, 1.8836309960E+00, 9.6782825440E-03, 9.4322604364E-03, 6.0690799213E-01],
	[1.7455000000E+04, 4.6225772237E-01, 1.8834724676E+00, 9.6862610298E-03, 9.4399076526E-03, 6.0701169073E-01],
	[1.7460000000E+04, 4.6243354076E-01, 1.8833139978E+00, 9.6942438049E-03, 9.4475588006E-03, 6.0711534662E-01],
	[1.7465000000E+04, 4.6260937566E-01, 1.8831555868E+00, 9.7022308704E-03, 9.4552138813E-03, 6.0721895983E-01],
	[1.7470000000E+04, 4.6278522706E-01, 1.8829972344E+00, 9.7102222273E-03, 9.4628728954E-03, 6.0732253034E-01],
	[1.7475000000E+04, 4.6296109495E-01, 1.8828389407E+00, 9.7182178767E-03, 9.4705358436E-03, 6.0742605818E-01],
	[1.7480000000E+04, 4.6313697933E-01, 1.8826807055E+00, 9.7262178197E-03, 9.4782027269E-03, 6.0752954335E-01],
	[1.7485000000E+04, 4.6331288020E-01, 1.8825225289E+00, 9.7342220573E-03, 9.4858735459E-03, 6.0763298586E-01],
	[1.7490000000E+04, 4.6348879756E-01, 1.8823644108E+00, 9.7422305907E-03, 9.4935483014E-03, 6.0773638571E-01],
	[1.7495000000E+04, 4.6366473140E-01, 1.8822063512E+00, 9.7502434210E-03, 9.5012269943E-03, 6.0783974292E-01],
	[1.7500000000E+04, 4.6384068172E-01, 1.8820483500E+00, 9.7582605491E-03, 9.5089096252E-03, 6.0794305749E-01],
	[1.7505000000E+04, 4.6401664852E-01, 1.8818904072E+00, 9.7663633163E-03, 9.5166734292E-03, 6.0804632942E-01],
	[1.7510000000E+04, 4.6419263179E-01, 1.8817325228E+00, 9.7744704946E-03, 9.5244412742E-03, 6.0814955873E-01],
	[1.7515000000E+04, 4.6436863152E-01, 1.8815746966E+00, 9.7825820853E-03, 9.5322131609E-03, 6.0825274543E-01],
	[1.7520000000E+04, 4.6454464773E-01, 1.8814169288E+00, 9.7906980894E-03, 9.5399890902E-03, 6.0835588952E-01],
	[1.7525000000E+04, 4.6472068040E-01, 1.8812592192E+00, 9.7988185081E-03, 9.5477690629E-03, 6.0845899100E-01],
	[1.7530000000E+04, 4.6489672953E-01, 1.8811015678E+00, 9.8069433425E-03, 9.5555530798E-03, 6.0856204989E-01],
	[1.7535000000E+04, 4.6507279512E-01, 1.8809439745E+00, 9.8150725938E-03, 9.5633411419E-03, 6.0866506620E-01],
	[1.7540000000E+04, 4.6524887716E-01, 1.8807864394E+00, 9.8232062630E-03, 9.5711332498E-03, 6.0876803993E-01],
	[1.7545000000E+04, 4.6542497565E-01, 1.8806289624E+00, 9.8313443515E-03, 9.5789294045E-03, 6.0887097109E-01],
	[1.7550000000E+04, 4.6560109059E-01, 1.8804715434E+00, 9.8394868602E-03, 9.5867296068E-03, 6.0897385969E-01],
	[1.7555000000E+04, 4.6577722197E-01, 1.8803141825E+00, 9.8476337903E-03, 9.5945338575E-03, 6.0907670574E-01],
	[1.7560000000E+04, 4.6595336980E-01, 1.8801568795E+00, 9.8557851431E-03, 9.6023421575E-03, 6.0917950924E-01],
	[1.7565000000E+04, 4.6612953406E-01, 1.8799996345E+00, 9.8639409195E-03, 9.6101545075E-03, 6.0928227020E-01],
	[1.7570000000E+04, 4.6630571476E-01, 1.8798424473E+00, 9.8721011208E-03, 9.6179709084E-03, 6.0938498864E-01],
	[1.7575000000E+04, 4.6648191189E-01, 1.8796853180E+00, 9.8802657480E-03, 9.6257913610E-03, 6.0948766455E-01],
	[1.7580000000E+04, 4.6665812546E-01, 1.8795282466E+00, 9.8884348024E-03, 9.6336158662E-03, 6.0959029795E-01],
	[1.7585000000E+04, 4.6683435544E-01, 1.8793712329E+00, 9.8966082851E-03, 9.6414444248E-03, 6.0969288884E-01],
	[1.7590000000E+04, 4.6701060185E-01, 1.8792142770E+00, 9.9047861972E-03, 9.6492770376E-03, 6.0979543723E-01],
	[1.7595000000E+04, 4.6718686468E-01, 1.8790573788E+00, 9.9129685398E-03, 9.6571137055E-03, 6.0989794314E-01],
	[1.7600000000E+04, 4.6736314392E-01, 1.8789005383E+00, 9.9211553141E-03, 9.6649544292E-03, 6.1000040656E-01],
	[1.7605000000E+04, 4.6753943958E-01, 1.8787437554E+00, 9.9293465212E-03, 9.6727992097E-03, 6.1010282751E-01],
	[1.7610000000E+04, 4.6771575165E-01, 1.8785870301E+00, 9.9375421624E-03, 9.6806480476E-03, 6.1020520599E-01],
	[1.7615000000E+04, 4.6789208013E-01, 1.8784303623E+00, 9.9457422386E-03, 9.6885009440E-03, 6.1030754202E-01],
	[1.7620000000E+04, 4.6806842500E-01, 1.8782737521E+00, 9.9539467511E-03, 9.6963578995E-03, 6.1040983560E-01],
	[1.7625000000E+04, 4.6824478628E-01, 1.8781171994E+00, 9.9621557010E-03, 9.7042189151E-03, 6.1051208674E-01],
	[1.7630000000E+04, 4.6842116396E-01, 1.8779607041E+00, 9.9703690894E-03, 9.7120839915E-03, 6.1061429544E-01],
	[1.7635000000E+04, 4.6859755803E-01, 1.8778042662E+00, 9.9785869175E-03, 9.7199531296E-03, 6.1071646173E-01],
	[1.7640000000E+04, 4.6877396850E-01, 1.8776478857E+00, 9.9868091864E-03, 9.7278263302E-03, 6.1081858559E-01],
	[1.7645000000E+04, 4.6895039535E-01, 1.8774915626E+00, 9.9950358972E-03, 9.7357035941E-03, 6.1092066705E-01],
	[1.7650000000E+04, 4.6912683858E-01, 1.8773352967E+00, 1.0003267051E-02, 9.7435849222E-03, 6.1102270611E-01],
	[1.7655000000E+04, 4.6930329820E-01, 1.8771790881E+00, 1.0011502649E-02, 9.7514703152E-03, 6.1112470277E-01],
	[1.7660000000E+04, 4.6948063759E-01, 1.8770247869E+00, 1.0019742693E-02, 9.7593601972E-03, 6.1122665706E-01],
	[1.7665000000E+04, 4.6965829272E-01, 1.8768711823E+00, 1.0027987183E-02, 9.7672542934E-03, 6.1132856897E-01],
	[1.7670000000E+04, 4.6983596476E-01, 1.8767176337E+00, 1.0036236121E-02, 9.7751524584E-03, 6.1143043851E-01],
	[1.7675000000E+04, 4.7001365372E-01, 1.8765641411E+00, 1.0044489507E-02, 9.7830546930E-03, 6.1153226569E-01],
	[1.7680000000E+04, 4.7019135959E-01, 1.8764107045E+00, 1.0052747344E-02, 9.7909609981E-03, 6.1163405053E-01],
	[1.7685000000E+04, 4.7036908238E-01, 1.8762573238E+00, 1.0061009631E-02, 9.7988713744E-03, 6.1173579303E-01],
	[1.7690000000E+04, 4.7054682207E-01, 1.8761039990E+00, 1.0069276371E-02, 9.8067858228E-03, 6.1183749319E-01],
	[1.7695000000E+04, 4.7072457867E-01, 1.8759507301E+00, 1.0077547564E-02, 9.8147043441E-03, 6.1193915103E-01],
	[1.7700000000E+04, 4.7090235216E-01, 1.8757975170E+00, 1.0085823211E-02, 9.8226269391E-03, 6.1204076655E-01],
	[1.7705000000E+04, 4.7108014256E-01, 1.8756443597E+00, 1.0094103315E-02, 9.8305536087E-03, 6.1214233977E-01],
	[1.7710000000E+04, 4.7125794985E-01, 1.8754912581E+00, 1.0102387875E-02, 9.8384843537E-03, 6.1224387069E-01],
	[1.7715000000E+04, 4.7143577403E-01, 1.8753382122E+00, 1.0110676893E-02, 9.8464191750E-03, 6.1234535932E-01],
	[1.7720000000E+04, 4.7161361510E-01, 1.8751852220E+00, 1.0118970369E-02, 9.8543580732E-03, 6.1244680566E-01],
	[1.7725000000E+04, 4.7179147305E-01, 1.8750322874E+00, 1.0127268307E-02, 9.8623010494E-03, 6.1254820974E-01],
	[1.7730000000E+04, 4.7196934789E-01, 1.8748794085E+00, 1.0135570705E-02, 9.8702481042E-03, 6.1264957155E-01],
	[1.7735000000E+04, 4.7214723961E-01, 1.8747265851E+00, 1.0143877566E-02, 9.8781992386E-03, 6.1275089110E-01],
	[1.7740000000E+04, 4.7232514820E-01, 1.8745738172E+00, 1.0152188890E-02, 9.8861544533E-03, 6.1285216841E-01],
	[1.7745000000E+04, 4.7250307367E-01, 1.8744211048E+00, 1.0160504680E-02, 9.8941137491E-03, 6.1295340348E-01],
	[1.7750000000E+04, 4.7268101600E-01, 1.8742684479E+00, 1.0168824935E-02, 9.9020771270E-03, 6.1305459632E-01],
	[1.7755000000E+04, 4.7285897520E-01, 1.8741158464E+00, 1.0177149657E-02, 9.9100445877E-03, 6.1315574694E-01],
	[1.7760000000E+04, 4.7303695126E-01, 1.8739633003E+00, 1.0185478847E-02, 9.9180161320E-03, 6.1325685535E-01],
	[1.7765000000E+04, 4.7321494419E-01, 1.8738108096E+00, 1.0193812507E-02, 9.9259917608E-03, 6.1335792155E-01],
	[1.7770000000E+04, 4.7339295397E-01, 1.8736583742E+00, 1.0202150637E-02, 9.9339714749E-03, 6.1345894556E-01],
	[1.7775000000E+04, 4.7357098060E-01, 1.8735059940E+00, 1.0210493239E-02, 9.9419552751E-03, 6.1355992739E-01],
	[1.7780000000E+04, 4.7374902409E-01, 1.8733536691E+00, 1.0218840313E-02, 9.9499431622E-03, 6.1366086704E-01],
	[1.7785000000E+04, 4.7392708442E-01, 1.8732013994E+00, 1.0227191861E-02, 9.9579351371E-03, 6.1376176451E-01],
	[1.7790000000E+04, 4.7410516160E-01, 1.8730491849E+00, 1.0235547885E-02, 9.9659312006E-03, 6.1386261983E-01],
	[1.7795000000E+04, 4.7428325562E-01, 1.8728970255E+00, 1.0243908384E-02, 9.9739313535E-03, 6.1396343300E-01],
	[1.7800000000E+04, 4.7446136647E-01, 1.8727449212E+00, 1.0252273361E-02, 9.9819355966E-03, 6.1406420403E-01],
	[1.7805000000E+04, 4.7463949417E-01, 1.8725928720E+00, 1.0260642816E-02, 9.9899439307E-03, 6.1416493293E-01],
	[1.7810000000E+04, 4.7481763869E-01, 1.8724408778E+00, 1.0269016750E-02, 9.9979563568E-03, 6.1426561970E-01],
	[1.7815000000E+04, 4.7499580004E-01, 1.8722889386E+00, 1.0277395166E-02, 1.0005972875E-02, 6.1436626435E-01],
	[1.7820000000E+04, 4.7517397822E-01, 1.8721370544E+00, 1.0285778063E-02, 1.0013993488E-02, 6.1446686690E-01],
	[1.7825000000E+04, 4.7535217322E-01, 1.8719852251E+00, 1.0294165443E-02, 1.0022018194E-02, 6.1456742736E-01],
	[1.7830000000E+04, 4.7553038504E-01, 1.8718334507E+00, 1.0302557307E-02, 1.0030046996E-02, 6.1466794572E-01],
	[1.7835000000E+04, 4.7570861367E-01, 1.8716817312E+00, 1.0310953657E-02, 1.0038079894E-02, 6.1476842201E-01],
	[1.7840000000E+04, 4.7588685912E-01, 1.8715300664E+00, 1.0319354493E-02, 1.0046116888E-02, 6.1486885623E-01],
	[1.7845000000E+04, 4.7606512138E-01, 1.8713784565E+00, 1.0327759816E-02, 1.0054157980E-02, 6.1496924838E-01],
	[1.7850000000E+04, 4.7624340044E-01, 1.8712269013E+00, 1.0336169628E-02, 1.0062203171E-02, 6.1506959849E-01],
	[1.7855000000E+04, 4.7642169631E-01, 1.8710754008E+00, 1.0344583930E-02, 1.0070252461E-02, 6.1516990655E-01],
	[1.7860000000E+04, 4.7660000898E-01, 1.8709239550E+00, 1.0353002723E-02, 1.0078305851E-02, 6.1527017258E-01],
	[1.7865000000E+04, 4.7677833844E-01, 1.8707725639E+00, 1.0361426008E-02, 1.0086363341E-02, 6.1537039658E-01],
	[1.7870000000E+04, 4.7695668470E-01, 1.8706212273E+00, 1.0369853786E-02, 1.0094424934E-02, 6.1547057857E-01],
	[1.7875000000E+04, 4.7713504775E-01, 1.8704699454E+00, 1.0378286058E-02, 1.0102490629E-02, 6.1557071855E-01],
	[1.7880000000E+04, 4.7731342759E-01, 1.8703187179E+00, 1.0386722826E-02, 1.0110560427E-02, 6.1567081653E-01],
	[1.7885000000E+04, 4.7749182422E-01, 1.8701675450E+00, 1.0395164091E-02, 1.0118634330E-02, 6.1577087253E-01],
	[1.7890000000E+04, 4.7767023762E-01, 1.8700164266E+00, 1.0403609854E-02, 1.0126712337E-02, 6.1587088654E-01],
	[1.7895000000E+04, 4.7784866781E-01, 1.8698653625E+00, 1.0412060115E-02, 1.0134794451E-02, 6.1597085859E-01],
	[1.7900000000E+04, 4.7802711477E-01, 1.8697143529E+00, 1.0420514876E-02, 1.0142880671E-02, 6.1607078868E-01],
	[1.7905000000E+04, 4.7820557850E-01, 1.8695633977E+00, 1.0428974139E-02, 1.0150970998E-02, 6.1617067682E-01],
	[1.7910000000E+04, 4.7838405900E-01, 1.8694124968E+00, 1.0437437904E-02, 1.0159065434E-02, 6.1627052301E-01],
	[1.7915000000E+04, 4.7856255627E-01, 1.8692616501E+00, 1.0445906172E-02, 1.0167163979E-02, 6.1637032727E-01],
	[1.7920000000E+04, 4.7874107030E-01, 1.8691108578E+00, 1.0454378945E-02, 1.0175266634E-02, 6.1647008961E-01],
	[1.7925000000E+04, 4.7891960109E-01, 1.8689601196E+00, 1.0462856224E-02, 1.0183373399E-02, 6.1656981004E-01],
	[1.7930000000E+04, 4.7909814864E-01, 1.8688094357E+00, 1.0471338009E-02, 1.0191484276E-02, 6.1666948856E-01],
	[1.7935000000E+04, 4.7927671294E-01, 1.8686588059E+00, 1.0479824303E-02, 1.0199599265E-02, 6.1676912519E-01],
	[1.7940000000E+04, 4.7945529399E-01, 1.8685082303E+00, 1.0488315106E-02, 1.0207718368E-02, 6.1686871993E-01],
	[1.7945000000E+04, 4.7963493663E-01, 1.8683598792E+00, 1.0496810419E-02, 1.0215842123E-02, 6.1696827279E-01],
	[1.7950000000E+04, 4.7981471988E-01, 1.8682118374E+00, 1.0505310243E-02, 1.0223970058E-02, 6.1706778379E-01],
	[1.7955000000E+04, 4.7999452041E-01, 1.8680638485E+00, 1.0513814581E-02, 1.0232102110E-02, 6.1716725293E-01],
	[1.7960000000E+04, 4.8017433822E-01, 1.8679159125E+00, 1.0522323431E-02, 1.0240238280E-02, 6.1726668022E-01],
	[1.7965000000E+04, 4.8035417332E-01, 1.8677680295E+00, 1.0530836797E-02, 1.0248378568E-02, 6.1736606567E-01],
	[1.7970000000E+04, 4.8053402570E-01, 1.8676201993E+00, 1.0539354679E-02, 1.0256522976E-02, 6.1746540930E-01],
	[1.7975000000E+04, 4.8071389535E-01, 1.8674724219E+00, 1.0547877077E-02, 1.0264671504E-02, 6.1756471110E-01],
	[1.7980000000E+04, 4.8089378228E-01, 1.8673246973E+00, 1.0556403994E-02, 1.0272824153E-02, 6.1766397110E-01],
	[1.7985000000E+04, 4.8107368648E-01, 1.8671770255E+00, 1.0564935431E-02, 1.0280980924E-02, 6.1776318929E-01],
	[1.7990000000E+04, 4.8125360794E-01, 1.8670294064E+00, 1.0573471388E-02, 1.0289141818E-02, 6.1786236569E-01],
	[1.7995000000E+04, 4.8143354667E-01, 1.8668818400E+00, 1.0582011866E-02, 1.0297306835E-02, 6.1796150031E-01],
	[1.8000000000E+04, 4.8161350265E-01, 1.8667343262E+00, 1.0590556868E-02, 1.0305475977E-02, 6.1806059316E-01],
	[1.8005000000E+04, 4.8179347590E-01, 1.8665868651E+00, 1.0599106393E-02, 1.0313649244E-02, 6.1815964425E-01],
	[1.8010000000E+04, 4.8197346640E-01, 1.8664394565E+00, 1.0607660444E-02, 1.0321826636E-02, 6.1825865359E-01],
	[1.8015000000E+04, 4.8215347415E-01, 1.8662921005E+00, 1.0616219021E-02, 1.0330008156E-02, 6.1835762118E-01],
	[1.8020000000E+04, 4.8233349915E-01, 1.8661447970E+00, 1.0624782125E-02, 1.0338193803E-02, 6.1845654704E-01],
	[1.8025000000E+04, 4.8251354139E-01, 1.8659975460E+00, 1.0633349757E-02, 1.0346383578E-02, 6.1855543117E-01],
	[1.8030000000E+04, 4.8269360087E-01, 1.8658503475E+00, 1.0641921920E-02, 1.0354577483E-02, 6.1865427359E-01],
	[1.8035000000E+04, 4.8287367759E-01, 1.8657032014E+00, 1.0650498613E-02, 1.0362775518E-02, 6.1875307431E-01],
	[1.8040000000E+04, 4.8305377155E-01, 1.8655561076E+00, 1.0659079838E-02, 1.0370977683E-02, 6.1885183333E-01],
	[1.8045000000E+04, 4.8323388274E-01, 1.8654090663E+00, 1.0667665596E-02, 1.0379183981E-02, 6.1895055067E-01],
	[1.8050000000E+04, 4.8341401116E-01, 1.8652620772E+00, 1.0676255888E-02, 1.0387394410E-02, 6.1904922633E-01],
	[1.8055000000E+04, 4.8359415680E-01, 1.8651151404E+00, 1.0684850715E-02, 1.0395608973E-02, 6.1914786033E-01],
	[1.8060000000E+04, 4.8377431967E-01, 1.8649682559E+00, 1.0693450079E-02, 1.0403827670E-02, 6.1924645267E-01],
	[1.8065000000E+04, 4.8395449976E-01, 1.8648214237E+00, 1.0702053981E-02, 1.0412050502E-02, 6.1934500337E-01],
	[1.8070000000E+04, 4.8413469706E-01, 1.8646746436E+00, 1.0710662421E-02, 1.0420277470E-02, 6.1944351243E-01],
	[1.8075000000E+04, 4.8431491158E-01, 1.8645279156E+00, 1.0719275402E-02, 1.0428508574E-02, 6.1954197986E-01],
	[1.8080000000E+04, 4.8449514331E-01, 1.8643812398E+00, 1.0727892923E-02, 1.0436743816E-02, 6.1964040568E-01],
	[1.8085000000E+04, 4.8467539224E-01, 1.8642346161E+00, 1.0736514986E-02, 1.0444983195E-02, 6.1973878989E-01],
	[1.8090000000E+04, 4.8485565838E-01, 1.8640880444E+00, 1.0745141593E-02, 1.0453226714E-02, 6.1983713251E-01],
	[1.8095000000E+04, 4.8503594172E-01, 1.8639415248E+00, 1.0753772744E-02, 1.0461474373E-02, 6.1993543353E-01],
	[1.8100000000E+04, 4.8521624226E-01, 1.8637950572E+00, 1.0762408441E-02, 1.0469726172E-02, 6.2003369299E-01],
	[1.8105000000E+04, 4.8539655999E-01, 1.8636486415E+00, 1.0771048684E-02, 1.0477982112E-02, 6.2013191087E-01],
	[1.8110000000E+04, 4.8557689491E-01, 1.8635022777E+00, 1.0779693475E-02, 1.0486242195E-02, 6.2023008720E-01],
	[1.8115000000E+04, 4.8575724703E-01, 1.8633559658E+00, 1.0788342816E-02, 1.0494506421E-02, 6.2032822198E-01],
	[1.8120000000E+04, 4.8593761633E-01, 1.8632097058E+00, 1.0796996706E-02, 1.0502774790E-02, 6.2042631523E-01],
	[1.8125000000E+04, 4.8611800281E-01, 1.8630634977E+00, 1.0805655147E-02, 1.0511047305E-02, 6.2052436695E-01],
	[1.8130000000E+04, 4.8629840647E-01, 1.8629173413E+00, 1.0814318141E-02, 1.0519323964E-02, 6.2062237715E-01],
	[1.8135000000E+04, 4.8647882730E-01, 1.8627712367E+00, 1.0822985689E-02, 1.0527604770E-02, 6.2072034585E-01],
	[1.8140000000E+04, 4.8665926531E-01, 1.8626251838E+00, 1.0831657791E-02, 1.0535889723E-02, 6.2081827304E-01],
	[1.8145000000E+04, 4.8683972049E-01, 1.8624791826E+00, 1.0840334449E-02, 1.0544178824E-02, 6.2091615876E-01],
	[1.8150000000E+04, 4.8702019283E-01, 1.8623332331E+00, 1.0849015664E-02, 1.0552472074E-02, 6.2101400299E-01],
	[1.8155000000E+04, 4.8720068234E-01, 1.8621873352E+00, 1.0857701437E-02, 1.0560769473E-02, 6.2111180576E-01],
	[1.8160000000E+04, 4.8738118901E-01, 1.8620414889E+00, 1.0866391769E-02, 1.0569071022E-02, 6.2120956707E-01],
	[1.8165000000E+04, 4.8756171284E-01, 1.8618956942E+00, 1.0875086662E-02, 1.0577376723E-02, 6.2130728694E-01],
	[1.8170000000E+04, 4.8774225382E-01, 1.8617499510E+00, 1.0883786116E-02, 1.0585686575E-02, 6.2140496537E-01],
	[1.8175000000E+04, 4.8792281196E-01, 1.8616042593E+00, 1.0892490132E-02, 1.0594000581E-02, 6.2150260238E-01],
	[1.8180000000E+04, 4.8810338724E-01, 1.8614586191E+00, 1.0901198713E-02, 1.0602318739E-02, 6.2160019797E-01],
	[1.8185000000E+04, 4.8828397966E-01, 1.8613130304E+00, 1.0909911858E-02, 1.0610641052E-02, 6.2169775215E-01],
	[1.8190000000E+04, 4.8846458923E-01, 1.8611674930E+00, 1.0918629569E-02, 1.0618967521E-02, 6.2179526494E-01],
	[1.8195000000E+04, 4.8864521594E-01, 1.8610220070E+00, 1.0927351848E-02, 1.0627298145E-02, 6.2189273634E-01],
	[1.8200000000E+04, 4.8882585978E-01, 1.8608765724E+00, 1.0936078695E-02, 1.0635632926E-02, 6.2199016637E-01],
	[1.8205000000E+04, 4.8900652076E-01, 1.8607311890E+00, 1.0944810111E-02, 1.0643971865E-02, 6.2208755503E-01],
	[1.8210000000E+04, 4.8918719887E-01, 1.8605858570E+00, 1.0953546098E-02, 1.0652314962E-02, 6.2218490234E-01],
	[1.8215000000E+04, 4.8936789410E-01, 1.8604405762E+00, 1.0962286656E-02, 1.0660662218E-02, 6.2228220831E-01],
	[1.8220000000E+04, 4.8954860645E-01, 1.8602953466E+00, 1.0971031788E-02, 1.0669013634E-02, 6.2237947294E-01],
	[1.8225000000E+04, 4.8972933593E-01, 1.8601501682E+00, 1.0979781493E-02, 1.0677369211E-02, 6.2247669625E-01],
	[1.8230000000E+04, 4.8991023607E-01, 1.8600053502E+00, 1.0988535773E-02, 1.0685729033E-02, 6.2257387824E-01],
	[1.8235000000E+04, 4.9009217394E-01, 1.8598626385E+00, 1.0997294630E-02, 1.0694093571E-02, 6.2267101893E-01],
	[1.8240000000E+04, 4.9027412947E-01, 1.8597199769E+00, 1.1006058064E-02, 1.0702462274E-02, 6.2276811833E-01],
	[1.8245000000E+04, 4.9045610266E-01, 1.8595773653E+00, 1.1014826077E-02, 1.0710835143E-02, 6.2286517645E-01],
	[1.8250000000E+04, 4.9063809349E-01, 1.8594348037E+00, 1.1023598669E-02, 1.0719212177E-02, 6.2296219330E-01],
	[1.8255000000E+04, 4.9082010198E-01, 1.8592922920E+00, 1.1032375843E-02, 1.0727593379E-02, 6.2305916888E-01],
	[1.8260000000E+04, 4.9100212811E-01, 1.8591498304E+00, 1.1041157598E-02, 1.0735978749E-02, 6.2315610322E-01],
	[1.8265000000E+04, 4.9118417189E-01, 1.8590074186E+00, 1.1049943936E-02, 1.0744368287E-02, 6.2325299631E-01],
	[1.8270000000E+04, 4.9136623330E-01, 1.8588650567E+00, 1.1058734858E-02, 1.0752761995E-02, 6.2334984817E-01],
	[1.8275000000E+04, 4.9154831235E-01, 1.8587227447E+00, 1.1067530366E-02, 1.0761159873E-02, 6.2344665882E-01],
	[1.8280000000E+04, 4.9173040904E-01, 1.8585804825E+00, 1.1076330460E-02, 1.0769561922E-02, 6.2354342825E-01],
	[1.8285000000E+04, 4.9191252335E-01, 1.8584382701E+00, 1.1085135142E-02, 1.0777968143E-02, 6.2364015649E-01],
	[1.8290000000E+04, 4.9209465529E-01, 1.8582961074E+00, 1.1093944413E-02, 1.0786378537E-02, 6.2373684354E-01],
	[1.8295000000E+04, 4.9227680486E-01, 1.8581539945E+00, 1.1102758273E-02, 1.0794793104E-02, 6.2383348941E-01],
	[1.8300000000E+04, 4.9245897204E-01, 1.8580119313E+00, 1.1111576725E-02, 1.0803211846E-02, 6.2393009411E-01],
	[1.8305000000E+04, 4.9264115685E-01, 1.8578699177E+00, 1.1120399769E-02, 1.0811634763E-02, 6.2402665766E-01],
	[1.8310000000E+04, 4.9282335926E-01, 1.8577279538E+00, 1.1129227406E-02, 1.0820061855E-02, 6.2412318006E-01],
	[1.8315000000E+04, 4.9300557929E-01, 1.8575860395E+00, 1.1138059637E-02, 1.0828493125E-02, 6.2421966132E-01],
	[1.8320000000E+04, 4.9318781693E-01, 1.8574441747E+00, 1.1146896464E-02, 1.0836928572E-02, 6.2431610146E-01],
	[1.8325000000E+04, 4.9337007218E-01, 1.8573023595E+00, 1.1155737888E-02, 1.0845368197E-02, 6.2441250049E-01],
	[1.8330000000E+04, 4.9355234502E-01, 1.8571605938E+00, 1.1164583910E-02, 1.0853812001E-02, 6.2450885842E-01],
	[1.8335000000E+04, 4.9373463547E-01, 1.8570188776E+00, 1.1173434530E-02, 1.0862259985E-02, 6.2460517525E-01],
	[1.8340000000E+04, 4.9391694351E-01, 1.8568772109E+00, 1.1182289751E-02, 1.0870712150E-02, 6.2470145099E-01],
	[1.8345000000E+04, 4.9409926914E-01, 1.8567355935E+00, 1.1191149573E-02, 1.0879168497E-02, 6.2479768567E-01],
	[1.8350000000E+04, 4.9428161237E-01, 1.8565940256E+00, 1.1200013997E-02, 1.0887629026E-02, 6.2489387929E-01],
	[1.8355000000E+04, 4.9446397318E-01, 1.8564525070E+00, 1.1208883025E-02, 1.0896093738E-02, 6.2499003185E-01],
	[1.8360000000E+04, 4.9464635157E-01, 1.8563110377E+00, 1.1217756658E-02, 1.0904562634E-02, 6.2508614338E-01],
	[1.8365000000E+04, 4.9482874755E-01, 1.8561696177E+00, 1.1226634896E-02, 1.0913035715E-02, 6.2518221388E-01],
	[1.8370000000E+04, 4.9501116110E-01, 1.8560282471E+00, 1.1235517742E-02, 1.0921512981E-02, 6.2527824336E-01],
	[1.8375000000E+04, 4.9519359222E-01, 1.8558869256E+00, 1.1244405195E-02, 1.0929994434E-02, 6.2537423183E-01],
	[1.8380000000E+04, 4.9537604092E-01, 1.8557456533E+00, 1.1253297258E-02, 1.0938480074E-02, 6.2547017931E-01],
	[1.8385000000E+04, 4.9555850719E-01, 1.8556044302E+00, 1.1262193930E-02, 1.0946969901E-02, 6.2556608580E-01],
	[1.8390000000E+04, 4.9574099102E-01, 1.8554632563E+00, 1.1271095215E-02, 1.0955463918E-02, 6.2566195131E-01],
	[1.8395000000E+04, 4.9592349241E-01, 1.8553221315E+00, 1.1280001112E-02, 1.0963962124E-02, 6.2575777586E-01],
	[1.8400000000E+04, 4.9610601136E-01, 1.8551810558E+00, 1.1288911623E-02, 1.0972464520E-02, 6.2585355946E-01],
	[1.8405000000E+04, 4.9628854787E-01, 1.8550400291E+00, 1.1297826748E-02, 1.0980971108E-02, 6.2594930212E-01],
	[1.8410000000E+04, 4.9647110193E-01, 1.8548990514E+00, 1.1306746490E-02, 1.0989481888E-02, 6.2604500384E-01],
	[1.8415000000E+04, 4.9665367354E-01, 1.8547581227E+00, 1.1315670849E-02, 1.0997996860E-02, 6.2614066464E-01],
	[1.8420000000E+04, 4.9683626270E-01, 1.8546172430E+00, 1.1324599826E-02, 1.1006516026E-02, 6.2623628454E-01],
	[1.8425000000E+04, 4.9701886940E-01, 1.8544764122E+00, 1.1333533422E-02, 1.1015039386E-02, 6.2633186353E-01],
	[1.8430000000E+04, 4.9720149364E-01, 1.8543356304E+00, 1.1342471640E-02, 1.1023566941E-02, 6.2642740164E-01],
	[1.8435000000E+04, 4.9738413542E-01, 1.8541948974E+00, 1.1351414478E-02, 1.1032098693E-02, 6.2652289887E-01],
	[1.8440000000E+04, 4.9756679473E-01, 1.8540542132E+00, 1.1360361940E-02, 1.1040634641E-02, 6.2661835523E-01],
	[1.8445000000E+04, 4.9774947157E-01, 1.8539135779E+00, 1.1369314026E-02, 1.1049174787E-02, 6.2671377074E-01],
	[1.8450000000E+04, 4.9793216594E-01, 1.8537729913E+00, 1.1378270736E-02, 1.1057719131E-02, 6.2680914540E-01],
	[1.8455000000E+04, 4.9811487784E-01, 1.8536324535E+00, 1.1387232073E-02, 1.1066267674E-02, 6.2690447923E-01],
	[1.8460000000E+04, 4.9829760726E-01, 1.8534919644E+00, 1.1396198037E-02, 1.1074820417E-02, 6.2699977224E-01],
	[1.8465000000E+04, 4.9848035420E-01, 1.8533515240E+00, 1.1405168630E-02, 1.1083377361E-02, 6.2709502443E-01],
	[1.8470000000E+04, 4.9866311865E-01, 1.8532111322E+00, 1.1414143853E-02, 1.1091938506E-02, 6.2719023583E-01],
	[1.8475000000E+04, 4.9884590062E-01, 1.8530707891E+00, 1.1423123706E-02, 1.1100503854E-02, 6.2728540643E-01],
	[1.8480000000E+04, 4.9902870009E-01, 1.8529304946E+00, 1.1432108191E-02, 1.1109073404E-02, 6.2738053626E-01],
	[1.8485000000E+04, 4.9921151708E-01, 1.8527902487E+00, 1.1441097309E-02, 1.1117647159E-02, 6.2747562532E-01],
	[1.8490000000E+04, 4.9939435156E-01, 1.8526500512E+00, 1.1450091062E-02, 1.1126225119E-02, 6.2757067363E-01],
	[1.8495000000E+04, 4.9957720355E-01, 1.8525099024E+00, 1.1459089449E-02, 1.1134807284E-02, 6.2766568118E-01],
	[1.8500000000E+04, 4.9976007303E-01, 1.8523698019E+00, 1.1468092474E-02, 1.1143393655E-02, 6.2776064799E-01],
	[1.8505000000E+04, 4.9994296001E-01, 1.8522297500E+00, 1.1477100135E-02, 1.1151984233E-02, 6.2785557407E-01],
	[1.8510000000E+04, 5.0012586448E-01, 1.8520897464E+00, 1.1486112436E-02, 1.1160579020E-02, 6.2795045942E-01],
	[1.8515000000E+04, 5.0030878644E-01, 1.8519497913E+00, 1.1495129376E-02, 1.1169178015E-02, 6.2804530406E-01],
	[1.8520000000E+04, 5.0049172588E-01, 1.8518098845E+00, 1.1504150957E-02, 1.1177781219E-02, 6.2814010800E-01],
	[1.8525000000E+04, 5.0067519880E-01, 1.8516710337E+00, 1.1513177181E-02, 1.1186388929E-02, 6.2823487124E-01],
	[1.8530000000E+04, 5.0085935361E-01, 1.8515335273E+00, 1.1522208047E-02, 1.1195001229E-02, 6.2832959379E-01],
	[1.8535000000E+04, 5.0104352645E-01, 1.8513960682E+00, 1.1531243558E-02, 1.1203617742E-02, 6.2842427566E-01],
	[1.8540000000E+04, 5.0122771731E-01, 1.8512586564E+00, 1.1540283715E-02, 1.1212238470E-02, 6.2851891686E-01],
	[1.8545000000E+04, 5.0141192618E-01, 1.8511212918E+00, 1.1549328518E-02, 1.1220863412E-02, 6.2861351740E-01],
	[1.8550000000E+04, 5.0159615307E-01, 1.8509839745E+00, 1.1558377969E-02, 1.1229492571E-02, 6.2870807729E-01],
	[1.8555000000E+04, 5.0178039796E-01, 1.8508467043E+00, 1.1567432069E-02, 1.1238125946E-02, 6.2880259654E-01],
	[1.8560000000E+04, 5.0196466087E-01, 1.8507094813E+00, 1.1576490820E-02, 1.1246763538E-02, 6.2889707515E-01],
	[1.8565000000E+04, 5.0214894177E-01, 1.8505723054E+00, 1.1585554221E-02, 1.1255405348E-02, 6.2899151314E-01],
	[1.8570000000E+04, 5.0233324068E-01, 1.8504351767E+00, 1.1594622274E-02, 1.1264051378E-02, 6.2908591051E-01],
	[1.8575000000E+04, 5.0251755759E-01, 1.8502980950E+00, 1.1603694982E-02, 1.1272701627E-02, 6.2918026728E-01],
	[1.8580000000E+04, 5.0270189249E-01, 1.8501610603E+00, 1.1612772343E-02, 1.1281356096E-02, 6.2927458344E-01],
	[1.8585000000E+04, 5.0288624539E-01, 1.8500240727E+00, 1.1621854361E-02, 1.1290014787E-02, 6.2936885902E-01],
	[1.8590000000E+04, 5.0307061627E-01, 1.8498871321E+00, 1.1630941035E-02, 1.1298677700E-02, 6.2946309403E-01],
	[1.8595000000E+04, 5.0325500514E-01, 1.8497502384E+00, 1.1640032367E-02, 1.1307344836E-02, 6.2955728846E-01],
	[1.8600000000E+04, 5.0343941199E-01, 1.8496133916E+00, 1.1649128359E-02, 1.1316016195E-02, 6.2965144233E-01],
	[1.8605000000E+04, 5.0362383683E-01, 1.8494765918E+00, 1.1658229011E-02, 1.1324691779E-02, 6.2974555565E-01],
	[1.8610000000E+04, 5.0380827963E-01, 1.8493398388E+00, 1.1667334324E-02, 1.1333371588E-02, 6.2983962843E-01],
	[1.8615000000E+04, 5.0399274041E-01, 1.8492031327E+00, 1.1676444299E-02, 1.1342055624E-02, 6.2993366067E-01],
	[1.8620000000E+04, 5.0417721917E-01, 1.8490664734E+00, 1.1685558939E-02, 1.1350743886E-02, 6.3002765240E-01],
	[1.8625000000E+04, 5.0436171588E-01, 1.8489298608E+00, 1.1694678243E-02, 1.1359436376E-02, 6.3012160360E-01],
	[1.8630000000E+04, 5.0454623057E-01, 1.8487932951E+00, 1.1703802213E-02, 1.1368133094E-02, 6.3021551431E-01],
	[1.8635000000E+04, 5.0473076321E-01, 1.8486567760E+00, 1.1712930850E-02, 1.1376834041E-02, 6.3030938452E-01],
	[1.8640000000E+04, 5.0491531381E-01, 1.8485203037E+00, 1.1722064156E-02, 1.1385539219E-02, 6.3040321424E-01],
	[1.8645000000E+04, 5.0509988237E-01, 1.8483838780E+00, 1.1731202131E-02, 1.1394248627E-02, 6.3049700348E-01],
	[1.8650000000E+04, 5.0528446888E-01, 1.8482474990E+00, 1.1740344776E-02, 1.1402962267E-02, 6.3059075226E-01],
	[1.8655000000E+04, 5.0546907334E-01, 1.8481111666E+00, 1.1749492093E-02, 1.1411680140E-02, 6.3068446058E-01],
	[1.8660000000E+04, 5.0565369574E-01, 1.8479748808E+00, 1.1758644083E-02, 1.1420402245E-02, 6.3077812845E-01],
	[1.8665000000E+04, 5.0583833609E-01, 1.8478386415E+00, 1.1767800746E-02, 1.1429128585E-02, 6.3087175588E-01],
	[1.8670000000E+04, 5.0602299437E-01, 1.8477024488E+00, 1.1776962085E-02, 1.1437859159E-02, 6.3096534289E-01],
	[1.8675000000E+04, 5.0620767060E-01, 1.8475663026E+00, 1.1786128099E-02, 1.1446593969E-02, 6.3105888947E-01],
	[1.8680000000E+04, 5.0639236475E-01, 1.8474302028E+00, 1.1795298792E-02, 1.1455333015E-02, 6.3115239564E-01],
	[1.8685000000E+04, 5.0657707684E-01, 1.8472941495E+00, 1.1804474162E-02, 1.1464076299E-02, 6.3124586141E-01],
	[1.8690000000E+04, 5.0676180685E-01, 1.8471581426E+00, 1.1813654212E-02, 1.1472823820E-02, 6.3133928679E-01],
	[1.8695000000E+04, 5.0694655479E-01, 1.8470221821E+00, 1.1822838943E-02, 1.1481575580E-02, 6.3143267179E-01],
	[1.8700000000E+04, 5.0713132065E-01, 1.8468862680E+00, 1.1832028355E-02, 1.1490331579E-02, 6.3152601641E-01],
	[1.8705000000E+04, 5.0731610443E-01, 1.8467504002E+00, 1.1841222451E-02, 1.1499091819E-02, 6.3161932067E-01],
	[1.8710000000E+04, 5.0750090612E-01, 1.8466145787E+00, 1.1850421230E-02, 1.1507856300E-02, 6.3171258458E-01],
	[1.8715000000E+04, 5.0768572573E-01, 1.8464788035E+00, 1.1859624695E-02, 1.1516625023E-02, 6.3180580815E-01],
	[1.8720000000E+04, 5.0787056324E-01, 1.8463430745E+00, 1.1868832846E-02, 1.1525397989E-02, 6.3189899138E-01],
	[1.8725000000E+04, 5.0805541866E-01, 1.8462073918E+00, 1.1878045685E-02, 1.1534175197E-02, 6.3199213428E-01],
	[1.8730000000E+04, 5.0824029198E-01, 1.8460717552E+00, 1.1887263212E-02, 1.1542956651E-02, 6.3208523688E-01],
	[1.8735000000E+04, 5.0842518321E-01, 1.8459361648E+00, 1.1896485429E-02, 1.1551742349E-02, 6.3217829916E-01],
	[1.8740000000E+04, 5.0861009233E-01, 1.8458006205E+00, 1.1905712337E-02, 1.1560532293E-02, 6.3227132116E-01],
	[1.8745000000E+04, 5.0879501934E-01, 1.8456651224E+00, 1.1914943937E-02, 1.1569326484E-02, 6.3236430286E-01],
	[1.8750000000E+04, 5.0897996424E-01, 1.8455296703E+00, 1.1924180230E-02, 1.1578124922E-02, 6.3245724429E-01],
	[1.8755000000E+04, 5.0916492704E-01, 1.8453942643E+00, 1.1933421218E-02, 1.1586927608E-02, 6.3255014546E-01],
	[1.8760000000E+04, 5.0934990771E-01, 1.8452589043E+00, 1.1942666901E-02, 1.1595734543E-02, 6.3264300637E-01],
	[1.8765000000E+04, 5.0953490627E-01, 1.8451235903E+00, 1.1951917280E-02, 1.1604545728E-02, 6.3273582703E-01],
	[1.8770000000E+04, 5.0971992271E-01, 1.8449883223E+00, 1.1961172357E-02, 1.1613361163E-02, 6.3282860745E-01],
	[1.8775000000E+04, 5.0990495702E-01, 1.8448531002E+00, 1.1970432133E-02, 1.1622180850E-02, 6.3292134765E-01],
	[1.8780000000E+04, 5.1009000921E-01, 1.8447179240E+00, 1.1979696609E-02, 1.1631004789E-02, 6.3301404763E-01],
	[1.8785000000E+04, 5.1027507926E-01, 1.8445827938E+00, 1.1988965786E-02, 1.1639832981E-02, 6.3310670740E-01],
	[1.8790000000E+04, 5.1046016719E-01, 1.8444477093E+00, 1.1998239665E-02, 1.1648665426E-02, 6.3319932698E-01],
	[1.8795000000E+04, 5.1064527297E-01, 1.8443126707E+00, 1.2007518248E-02, 1.1657502126E-02, 6.3329190637E-01],
	[1.8800000000E+04, 5.1083039662E-01, 1.8441776779E+00, 1.2016801535E-02, 1.1666343081E-02, 6.3338444558E-01],
	[1.8805000000E+04, 5.1101553812E-01, 1.8440427309E+00, 1.2026089528E-02, 1.1675188292E-02, 6.3347694463E-01],
	[1.8810000000E+04, 5.1120069748E-01, 1.8439078296E+00, 1.2035382227E-02, 1.1684037760E-02, 6.3356940351E-01],
	[1.8815000000E+04, 5.1138587469E-01, 1.8437729741E+00, 1.2044679634E-02, 1.1692891486E-02, 6.3366182225E-01],
	[1.8820000000E+04, 5.1157106974E-01, 1.8436381642E+00, 1.2053981751E-02, 1.1701749470E-02, 6.3375420085E-01],
	[1.8825000000E+04, 5.1175723040E-01, 1.8435051938E+00, 1.2063288577E-02, 1.1710612282E-02, 6.3384653933E-01],
	[1.8830000000E+04, 5.1194364802E-01, 1.8433727200E+00, 1.2072600115E-02, 1.1719479498E-02, 6.3393883768E-01],
	[1.8835000000E+04, 5.1213008403E-01, 1.8432402908E+00, 1.2081916365E-02, 1.1728350977E-02, 6.3403109593E-01],
	[1.8840000000E+04, 5.1231653843E-01, 1.8431079062E+00, 1.2091237329E-02, 1.1737226719E-02, 6.3412331408E-01],
	[1.8845000000E+04, 5.1250301120E-01, 1.8429755664E+00, 1.2100563008E-02, 1.1746106724E-02, 6.3421549214E-01],
	[1.8850000000E+04, 5.1268950235E-01, 1.8428432711E+00, 1.2109893402E-02, 1.1754990994E-02, 6.3430763013E-01],
	[1.8855000000E+04, 5.1287601187E-01, 1.8427110204E+00, 1.2119228513E-02, 1.1763879530E-02, 6.3439972804E-01],
	[1.8860000000E+04, 5.1306253976E-01, 1.8425788142E+00, 1.2128568343E-02, 1.1772772331E-02, 6.3449178590E-01],
	[1.8865000000E+04, 5.1324908602E-01, 1.8424466526E+00, 1.2137912891E-02, 1.1781669400E-02, 6.3458380371E-01],
	[1.8870000000E+04, 5.1343565065E-01, 1.8423145354E+00, 1.2147262160E-02, 1.1790570737E-02, 6.3467578149E-01],
	[1.8875000000E+04, 5.1362223363E-01, 1.8421824628E+00, 1.2156616151E-02, 1.1799476342E-02, 6.3476771924E-01],
	[1.8880000000E+04, 5.1380883498E-01, 1.8420504346E+00, 1.2165974864E-02, 1.1808386216E-02, 6.3485961697E-01],
	[1.8885000000E+04, 5.1399545468E-01, 1.8419184508E+00, 1.2175338301E-02, 1.1817300360E-02, 6.3495147469E-01],
	[1.8890000000E+04, 5.1418209273E-01, 1.8417865114E+00, 1.2184706462E-02, 1.1826218776E-02, 6.3504329242E-01],
	[1.8895000000E+04, 5.1436874913E-01, 1.8416546163E+00, 1.2194079350E-02, 1.1835141463E-02, 6.3513507016E-01],
	[1.8900000000E+04, 5.1455542387E-01, 1.8415227656E+00, 1.2203456965E-02, 1.1844068422E-02, 6.3522680793E-01],
	[1.8905000000E+04, 5.1474211696E-01, 1.8413909592E+00, 1.2212839308E-02, 1.1852999655E-02, 6.3531850573E-01],
	[1.8910000000E+04, 5.1492882839E-01, 1.8412591971E+00, 1.2222226381E-02, 1.1861935161E-02, 6.3541016358E-01],
	[1.8915000000E+04, 5.1511555815E-01, 1.8411274793E+00, 1.2231618184E-02, 1.1870874943E-02, 6.3550178147E-01],
	[1.8920000000E+04, 5.1530230625E-01, 1.8409958057E+00, 1.2241014719E-02, 1.1879819000E-02, 6.3559335944E-01],
	[1.8925000000E+04, 5.1548907268E-01, 1.8408641763E+00, 1.2250415986E-02, 1.1888767333E-02, 6.3568489748E-01],
	[1.8930000000E+04, 5.1567585744E-01, 1.8407325911E+00, 1.2259821988E-02, 1.1897719944E-02, 6.3577639560E-01],
	[1.8935000000E+04, 5.1586266052E-01, 1.8406010500E+00, 1.2269232725E-02, 1.1906676832E-02, 6.3586785382E-01],
	[1.8940000000E+04, 5.1604948192E-01, 1.8404695531E+00, 1.2278648197E-02, 1.1915638000E-02, 6.3595927215E-01],
	[1.8945000000E+04, 5.1623632164E-01, 1.8403381002E+00, 1.2288068408E-02, 1.1924603446E-02, 6.3605065059E-01],
	[1.8950000000E+04, 5.1642317968E-01, 1.8402066915E+00, 1.2297493356E-02, 1.1933573173E-02, 6.3614198916E-01],
	[1.8955000000E+04, 5.1661005602E-01, 1.8400753267E+00, 1.2306923045E-02, 1.1942547181E-02, 6.3623328787E-01],
	[1.8960000000E+04, 5.1679695068E-01, 1.8399440060E+00, 1.2316357474E-02, 1.1951525471E-02, 6.3632454673E-01],
	[1.8965000000E+04, 5.1698386365E-01, 1.8398127293E+00, 1.2325796645E-02, 1.1960508044E-02, 6.3641576574E-01],
	[1.8970000000E+04, 5.1717079491E-01, 1.8396814966E+00, 1.2335240559E-02, 1.1969494899E-02, 6.3650694493E-01],
	[1.8975000000E+04, 5.1735774448E-01, 1.8395503078E+00, 1.2344689217E-02, 1.1978486039E-02, 6.3659808429E-01],
	[1.8980000000E+04, 5.1754471235E-01, 1.8394191629E+00, 1.2354142620E-02, 1.1987481464E-02, 6.3668918384E-01],
	[1.8985000000E+04, 5.1773169851E-01, 1.8392880619E+00, 1.2363600770E-02, 1.1996481175E-02, 6.3678024359E-01],
	[1.8990000000E+04, 5.1791870296E-01, 1.8391570048E+00, 1.2373063667E-02, 1.2005485172E-02, 6.3687126355E-01],
	[1.8995000000E+04, 5.1810572569E-01, 1.8390259915E+00, 1.2382531313E-02, 1.2014493456E-02, 6.3696224374E-01],
	[1.9000000000E+04, 5.1829276672E-01, 1.8388950220E+00, 1.2392003709E-02, 1.2023506029E-02, 6.3705318415E-01],
	[1.9005000000E+04, 5.1847982602E-01, 1.8387640963E+00, 1.2401480855E-02, 1.2032522890E-02, 6.3714408481E-01],
	[1.9010000000E+04, 5.1866690361E-01, 1.8386332144E+00, 1.2410962754E-02, 1.2041544041E-02, 6.3723494572E-01],
	[1.9015000000E+04, 5.1885399947E-01, 1.8385023762E+00, 1.2420449406E-02, 1.2050569482E-02, 6.3732576689E-01],
	[1.9020000000E+04, 5.1904111360E-01, 1.8383715817E+00, 1.2429940812E-02, 1.2059599215E-02, 6.3741654834E-01],
	[1.9025000000E+04, 5.1922824601E-01, 1.8382408309E+00, 1.2439436974E-02, 1.2068633239E-02, 6.3750729007E-01],
	[1.9030000000E+04, 5.1941539668E-01, 1.8381101237E+00, 1.2448937892E-02, 1.2077671556E-02, 6.3759799209E-01],
	[1.9035000000E+04, 5.1960256561E-01, 1.8379794602E+00, 1.2458443568E-02, 1.2086714167E-02, 6.3768865442E-01],
	[1.9040000000E+04, 5.1978975281E-01, 1.8378488403E+00, 1.2467954003E-02, 1.2095761072E-02, 6.3777927707E-01],
	[1.9045000000E+04, 5.1997695826E-01, 1.8377182639E+00, 1.2477469198E-02, 1.2104812272E-02, 6.3786986005E-01],
	[1.9050000000E+04, 5.2016418197E-01, 1.8375877311E+00, 1.2486989154E-02, 1.2113867767E-02, 6.3796040336E-01],
	[1.9055000000E+04, 5.2035142393E-01, 1.8374572418E+00, 1.2496513872E-02, 1.2122927560E-02, 6.3805090702E-01],
	[1.9060000000E+04, 5.2053868414E-01, 1.8373267960E+00, 1.2506043354E-02, 1.2131991649E-02, 6.3814137104E-01],
	[1.9065000000E+04, 5.2072596259E-01, 1.8371963937E+00, 1.2515577600E-02, 1.2141060037E-02, 6.3823179543E-01],
	[1.9070000000E+04, 5.2091325929E-01, 1.8370660349E+00, 1.2525116612E-02, 1.2150132724E-02, 6.3832218020E-01],
	[1.9075000000E+04, 5.2110057423E-01, 1.8369357194E+00, 1.2534660390E-02, 1.2159209710E-02, 6.3841252536E-01],
	[1.9080000000E+04, 5.2128790740E-01, 1.8368054474E+00, 1.2544208937E-02, 1.2168290997E-02, 6.3850283092E-01],
	[1.9085000000E+04, 5.2147525881E-01, 1.8366752187E+00, 1.2553762252E-02, 1.2177376586E-02, 6.3859309690E-01],
	[1.9090000000E+04, 5.2166262845E-01, 1.8365450334E+00, 1.2563320338E-02, 1.2186466476E-02, 6.3868332330E-01],
	[1.9095000000E+04, 5.2185001632E-01, 1.8364148913E+00, 1.2572883195E-02, 1.2195560669E-02, 6.3877351013E-01],
	[1.9100000000E+04, 5.2203742241E-01, 1.8362847926E+00, 1.2582450824E-02, 1.2204659165E-02, 6.3886365741E-01],
	[1.9105000000E+04, 5.2222484672E-01, 1.8361547372E+00, 1.2592023227E-02, 1.2213761966E-02, 6.3895376514E-01],
	[1.9110000000E+04, 5.2241228925E-01, 1.8360247249E+00, 1.2601600405E-02, 1.2222869072E-02, 6.3904383335E-01],
	[1.9115000000E+04, 5.2259975000E-01, 1.8358947559E+00, 1.2611182358E-02, 1.2231980484E-02, 6.3913386202E-01],
	[1.9120000000E+04, 5.2278722896E-01, 1.8357648301E+00, 1.2620769089E-02, 1.2241096203E-02, 6.3922385119E-01],
	[1.9125000000E+04, 5.2297496508E-01, 1.8356353859E+00, 1.2630360597E-02, 1.2250216379E-02, 6.3931380086E-01],
	[1.9130000000E+04, 5.2316367349E-01, 1.8355077345E+00, 1.2639956885E-02, 1.2259341466E-02, 6.3940371104E-01],
	[1.9135000000E+04, 5.2335240064E-01, 1.8353801253E+00, 1.2649557953E-02, 1.2268470864E-02, 6.3949358173E-01],
	[1.9140000000E+04, 5.2354114654E-01, 1.8352525583E+00, 1.2659163803E-02, 1.2277604573E-02, 6.3958341296E-01],
	[1.9145000000E+04, 5.2372991119E-01, 1.8351250335E+00, 1.2668774435E-02, 1.2286742594E-02, 6.3967320474E-01],
	[1.9150000000E+04, 5.2391869458E-01, 1.8349975509E+00, 1.2678389851E-02, 1.2295884928E-02, 6.3976295707E-01],
	[1.9155000000E+04, 5.2410749670E-01, 1.8348701104E+00, 1.2688010052E-02, 1.2305031576E-02, 6.3985266996E-01],
	[1.9160000000E+04, 5.2429631756E-01, 1.8347427120E+00, 1.2697635039E-02, 1.2314182538E-02, 6.3994234343E-01],
	[1.9165000000E+04, 5.2448515715E-01, 1.8346153556E+00, 1.2707264813E-02, 1.2323337815E-02, 6.4003197748E-01],
	[1.9170000000E+04, 5.2467401547E-01, 1.8344880414E+00, 1.2716899375E-02, 1.2332497408E-02, 6.4012157213E-01],
	[1.9175000000E+04, 5.2486289251E-01, 1.8343607692E+00, 1.2726538727E-02, 1.2341661318E-02, 6.4021112740E-01],
	[1.9180000000E+04, 5.2505178828E-01, 1.8342335389E+00, 1.2736182869E-02, 1.2350829545E-02, 6.4030064328E-01],
	[1.9185000000E+04, 5.2524070277E-01, 1.8341063507E+00, 1.2745831803E-02, 1.2360002091E-02, 6.4039011979E-01],
	[1.9190000000E+04, 5.2542963597E-01, 1.8339792044E+00, 1.2755485529E-02, 1.2369178956E-02, 6.4047955695E-01],
	[1.9195000000E+04, 5.2561858789E-01, 1.8338521001E+00, 1.2765144050E-02, 1.2378360141E-02, 6.4056895476E-01],
	[1.9200000000E+04, 5.2580755852E-01, 1.8337250377E+00, 1.2774807366E-02, 1.2387545646E-02, 6.4065831323E-01],
	[1.9205000000E+04, 5.2599654786E-01, 1.8335980171E+00, 1.2784475477E-02, 1.2396735473E-02, 6.4074763238E-01],
	[1.9210000000E+04, 5.2618555590E-01, 1.8334710385E+00, 1.2794148387E-02, 1.2405929621E-02, 6.4083691221E-01],
	[1.9215000000E+04, 5.2637458264E-01, 1.8333441016E+00, 1.2803826094E-02, 1.2415128093E-02, 6.4092615274E-01],
	[1.9220000000E+04, 5.2656362808E-01, 1.8332172066E+00, 1.2813508601E-02, 1.2424330889E-02, 6.4101535398E-01],
	[1.9225000000E+04, 5.2675269222E-01, 1.8330903533E+00, 1.2823195909E-02, 1.2433538008E-02, 6.4110451594E-01],
	[1.9230000000E+04, 5.2694177504E-01, 1.8329635418E+00, 1.2832888019E-02, 1.2442749453E-02, 6.4119363863E-01],
	[1.9235000000E+04, 5.2713087656E-01, 1.8328367721E+00, 1.2842584932E-02, 1.2451965225E-02, 6.4128272207E-01],
	[1.9240000000E+04, 5.2731999677E-01, 1.8327100441E+00, 1.2852286648E-02, 1.2461185322E-02, 6.4137176626E-01],
	[1.9245000000E+04, 5.2750913566E-01, 1.8325833577E+00, 1.2861993170E-02, 1.2470409748E-02, 6.4146077121E-01],
	[1.9250000000E+04, 5.2769829322E-01, 1.8324567130E+00, 1.2871704499E-02, 1.2479638501E-02, 6.4154973693E-01],
	[1.9255000000E+04, 5.2788746947E-01, 1.8323301100E+00, 1.2881420635E-02, 1.2488871584E-02, 6.4163866345E-01],
	[1.9260000000E+04, 5.2807666439E-01, 1.8322035486E+00, 1.2891141579E-02, 1.2498108997E-02, 6.4172755076E-01],
	[1.9265000000E+04, 5.2826587798E-01, 1.8320770287E+00, 1.2900867334E-02, 1.2507350740E-02, 6.4181639888E-01],
	[1.9270000000E+04, 5.2845511024E-01, 1.8319505504E+00, 1.2910597899E-02, 1.2516596815E-02, 6.4190520783E-01],
	[1.9275000000E+04, 5.2864436117E-01, 1.8318241137E+00, 1.2920333276E-02, 1.2525847221E-02, 6.4199397760E-01],
	[1.9280000000E+04, 5.2883363076E-01, 1.8316977185E+00, 1.2930073466E-02, 1.2535101961E-02, 6.4208270822E-01],
	[1.9285000000E+04, 5.2902291900E-01, 1.8315713648E+00, 1.2939818471E-02, 1.2544361034E-02, 6.4217139969E-01],
	[1.9290000000E+04, 5.2921222591E-01, 1.8314450525E+00, 1.2949568291E-02, 1.2553624442E-02, 6.4226005203E-01],
	[1.9295000000E+04, 5.2940155146E-01, 1.8313187817E+00, 1.2959322928E-02, 1.2562892185E-02, 6.4234866525E-01],
	[1.9300000000E+04, 5.2959089567E-01, 1.8311925523E+00, 1.2969082382E-02, 1.2572164264E-02, 6.4243723935E-01],
	[1.9305000000E+04, 5.2978025853E-01, 1.8310663643E+00, 1.2978846655E-02, 1.2581440680E-02, 6.4252577436E-01],
	[1.9310000000E+04, 5.2996964003E-01, 1.8309402177E+00, 1.2988615748E-02, 1.2590721433E-02, 6.4261427027E-01],
	[1.9315000000E+04, 5.3015904017E-01, 1.8308141124E+00, 1.2998389662E-02, 1.2600006524E-02, 6.4270272711E-01],
	[1.9320000000E+04, 5.3034845895E-01, 1.8306880484E+00, 1.3008168398E-02, 1.2609295955E-02, 6.4279114488E-01],
	[1.9325000000E+04, 5.3053789636E-01, 1.8305620258E+00, 1.3017951958E-02, 1.2618589725E-02, 6.4287952360E-01],
	[1.9330000000E+04, 5.3072735241E-01, 1.8304360444E+00, 1.3027740342E-02, 1.2627887836E-02, 6.4296786328E-01],
	[1.9335000000E+04, 5.3091682709E-01, 1.8303101042E+00, 1.3037533551E-02, 1.2637190288E-02, 6.4305616392E-01],
	[1.9340000000E+04, 5.3110632039E-01, 1.8301842053E+00, 1.3047331588E-02, 1.2646497083E-02, 6.4314442555E-01],
	[1.9345000000E+04, 5.3129583232E-01, 1.8300583476E+00, 1.3057134452E-02, 1.2655808220E-02, 6.4323264816E-01],
	[1.9350000000E+04, 5.3148536286E-01, 1.8299325311E+00, 1.3066942145E-02, 1.2665123701E-02, 6.4332083178E-01],
	[1.9355000000E+04, 5.3167491203E-01, 1.8298067557E+00, 1.3076754668E-02, 1.2674443526E-02, 6.4340897641E-01],
	[1.9360000000E+04, 5.3186447981E-01, 1.8296810215E+00, 1.3086572023E-02, 1.2683767697E-02, 6.4349708207E-01],
	[1.9365000000E+04, 5.3205406620E-01, 1.8295553283E+00, 1.3096394209E-02, 1.2693096213E-02, 6.4358514876E-01],
	[1.9370000000E+04, 5.3224367120E-01, 1.8294296763E+00, 1.3106221230E-02, 1.2702429076E-02, 6.4367317650E-01],
	[1.9375000000E+04, 5.3243329481E-01, 1.8293040652E+00, 1.3116053085E-02, 1.2711766286E-02, 6.4376116531E-01],
	[1.9380000000E+04, 5.3262293701E-01, 1.8291784953E+00, 1.3125889775E-02, 1.2721107845E-02, 6.4384911518E-01],
	[1.9385000000E+04, 5.3281259782E-01, 1.8290529663E+00, 1.3135731303E-02, 1.2730453753E-02, 6.4393702614E-01],
	[1.9390000000E+04, 5.3300227723E-01, 1.8289274783E+00, 1.3145577669E-02, 1.2739804010E-02, 6.4402489819E-01],
	[1.9395000000E+04, 5.3319197522E-01, 1.8288020313E+00, 1.3155428873E-02, 1.2749158618E-02, 6.4411273135E-01],
	[1.9400000000E+04, 5.3338169181E-01, 1.8286766252E+00, 1.3165284918E-02, 1.2758517578E-02, 6.4420052563E-01],
	[1.9405000000E+04, 5.3357142699E-01, 1.8285512600E+00, 1.3175145805E-02, 1.2767880889E-02, 6.4428828104E-01],
	[1.9410000000E+04, 5.3376118075E-01, 1.8284259358E+00, 1.3185011534E-02, 1.2777248553E-02, 6.4437599759E-01],
	[1.9415000000E+04, 5.3395095310E-01, 1.8283006523E+00, 1.3194882106E-02, 1.2786620570E-02, 6.4446367529E-01],
	[1.9420000000E+04, 5.3414074402E-01, 1.8281754098E+00, 1.3204757524E-02, 1.2795996942E-02, 6.4455131415E-01],
	[1.9425000000E+04, 5.3433055352E-01, 1.8280502080E+00, 1.3214637787E-02, 1.2805377669E-02, 6.4463891420E-01],
	[1.9430000000E+04, 5.3452038159E-01, 1.8279250471E+00, 1.3224522897E-02, 1.2814762752E-02, 6.4472647543E-01],
	[1.9435000000E+04, 5.3471097944E-01, 1.8278012626E+00, 1.3234412856E-02, 1.2824152689E-02, 6.4481399785E-01],
	[1.9440000000E+04, 5.3490204458E-01, 1.8276783153E+00, 1.3244307664E-02, 1.2833547282E-02, 6.4490148149E-01],
	[1.9445000000E+04, 5.3509312884E-01, 1.8275554078E+00, 1.3254207322E-02, 1.2842946235E-02, 6.4498892636E-01],
	[1.9450000000E+04, 5.3528423220E-01, 1.8274325403E+00, 1.3264111832E-02, 1.2852349549E-02, 6.4507633246E-01],
	[1.9455000000E+04, 5.3547535466E-01, 1.8273097125E+00, 1.3274021194E-02, 1.2861757223E-02, 6.4516369980E-01],
	[1.9460000000E+04, 5.3566649622E-01, 1.8271869246E+00, 1.3283935411E-02, 1.2871169260E-02, 6.4525102840E-01],
	[1.9465000000E+04, 5.3585765689E-01, 1.8270641765E+00, 1.3293854482E-02, 1.2880585660E-02, 6.4533831827E-01],
	[1.9470000000E+04, 5.3604883665E-01, 1.8269414682E+00, 1.3303778409E-02, 1.2890006423E-02, 6.4542556942E-01],
	[1.9475000000E+04, 5.3624003549E-01, 1.8268187995E+00, 1.3313707194E-02, 1.2899431550E-02, 6.4551278187E-01],
	[1.9480000000E+04, 5.3643125343E-01, 1.8266961707E+00, 1.3323640837E-02, 1.2908861043E-02, 6.4559995562E-01],
	[1.9485000000E+04, 5.3662249046E-01, 1.8265735815E+00, 1.3333579340E-02, 1.2918294901E-02, 6.4568709069E-01],
	[1.9490000000E+04, 5.3681374656E-01, 1.8264510320E+00, 1.3343522703E-02, 1.2927733126E-02, 6.4577418708E-01],
	[1.9495000000E+04, 5.3700502175E-01, 1.8263285221E+00, 1.3353470927E-02, 1.2937175718E-02, 6.4586124481E-01],
	[1.9500000000E+04, 5.3719631602E-01, 1.8262060519E+00, 1.3363424015E-02, 1.2946622679E-02, 6.4594826389E-01],
	[1.9505000000E+04, 5.3738762935E-01, 1.8260836213E+00, 1.3373381967E-02, 1.2956074008E-02, 6.4603524433E-01],
	[1.9510000000E+04, 5.3757896176E-01, 1.8259612303E+00, 1.3383344784E-02, 1.2965529707E-02, 6.4612218613E-01],
	[1.9515000000E+04, 5.3777031324E-01, 1.8258388788E+00, 1.3393312467E-02, 1.2974989777E-02, 6.4620908930E-01],
	[1.9520000000E+04, 5.3796168378E-01, 1.8257165669E+00, 1.3403285017E-02, 1.2984454218E-02, 6.4629595386E-01],
	[1.9525000000E+04, 5.3815307339E-01, 1.8255942945E+00, 1.3413262436E-02, 1.2993923030E-02, 6.4638277982E-01],
	[1.9530000000E+04, 5.3834448205E-01, 1.8254720615E+00, 1.3423244724E-02, 1.3003396216E-02, 6.4646956719E-01],
	[1.9535000000E+04, 5.3853590977E-01, 1.8253498681E+00, 1.3433231884E-02, 1.3012873774E-02, 6.4655631597E-01],
	[1.9540000000E+04, 5.3872735654E-01, 1.8252277141E+00, 1.3443223915E-02, 1.3022355707E-02, 6.4664302617E-01],
	[1.9545000000E+04, 5.3891882236E-01, 1.8251055995E+00, 1.3453220819E-02, 1.3031842015E-02, 6.4672969781E-01],
	[1.9550000000E+04, 5.3911030723E-01, 1.8249835243E+00, 1.3463222598E-02, 1.3041332699E-02, 6.4681633090E-01],
	[1.9555000000E+04, 5.3930181114E-01, 1.8248614886E+00, 1.3473229251E-02, 1.3050827759E-02, 6.4690292545E-01],
	[1.9560000000E+04, 5.3949333410E-01, 1.8247394921E+00, 1.3483240781E-02, 1.3060327196E-02, 6.4698948146E-01],
	[1.9565000000E+04, 5.3968487609E-01, 1.8246175350E+00, 1.3493257189E-02, 1.3069831012E-02, 6.4707599894E-01],
	[1.9570000000E+04, 5.3987643712E-01, 1.8244956172E+00, 1.3503278475E-02, 1.3079339206E-02, 6.4716247791E-01],
	[1.9575000000E+04, 5.4006801718E-01, 1.8243737387E+00, 1.3513304641E-02, 1.3088851779E-02, 6.4724891838E-01],
	[1.9580000000E+04, 5.4025961627E-01, 1.8242518995E+00, 1.3523335688E-02, 1.3098368733E-02, 6.4733532035E-01],
	[1.9585000000E+04, 5.4045123438E-01, 1.8241300995E+00, 1.3533371618E-02, 1.3107890068E-02, 6.4742168384E-01],
	[1.9590000000E+04, 5.4064287152E-01, 1.8240083387E+00, 1.3543412430E-02, 1.3117415785E-02, 6.4750800886E-01],
	[1.9595000000E+04, 5.4083452768E-01, 1.8238866171E+00, 1.3553458126E-02, 1.3126945884E-02, 6.4759429542E-01],
	[1.9600000000E+04, 5.4102620286E-01, 1.8237649347E+00, 1.3563508708E-02, 1.3136480367E-02, 6.4768054352E-01],
	[1.9605000000E+04, 5.4121789705E-01, 1.8236432915E+00, 1.3573564177E-02, 1.3146019233E-02, 6.4776675318E-01],
	[1.9610000000E+04, 5.4140961025E-01, 1.8235216874E+00, 1.3583624533E-02, 1.3155562484E-02, 6.4785292440E-01],
	[1.9615000000E+04, 5.4160134246E-01, 1.8234001224E+00, 1.3593689778E-02, 1.3165110121E-02, 6.4793905720E-01],
	[1.9620000000E+04, 5.4179309368E-01, 1.8232785964E+00, 1.3603759914E-02, 1.3174662144E-02, 6.4802515159E-01],
	[1.9625000000E+04, 5.4198486390E-01, 1.8231571096E+00, 1.3613834940E-02, 1.3184218555E-02, 6.4811120758E-01],
	[1.9630000000E+04, 5.4217665312E-01, 1.8230356618E+00, 1.3623914858E-02, 1.3193779353E-02, 6.4819722518E-01],
	[1.9635000000E+04, 5.4236846133E-01, 1.8229142530E+00, 1.3633999670E-02, 1.3203344539E-02, 6.4828320440E-01],
	[1.9640000000E+04, 5.4256028854E-01, 1.8227928831E+00, 1.3644089376E-02, 1.3212914115E-02, 6.4836914524E-01],
	[1.9645000000E+04, 5.4275213474E-01, 1.8226715523E+00, 1.3654183978E-02, 1.3222488081E-02, 6.4845504772E-01],
	[1.9650000000E+04, 5.4294399993E-01, 1.8225502604E+00, 1.3664283476E-02, 1.3232066438E-02, 6.4854091186E-01],
	[1.9655000000E+04, 5.4313588410E-01, 1.8224290075E+00, 1.3674387873E-02, 1.3241649187E-02, 6.4862673765E-01],
	[1.9660000000E+04, 5.4332778726E-01, 1.8223077934E+00, 1.3684497168E-02, 1.3251236328E-02, 6.4871252511E-01],
	[1.9665000000E+04, 5.4351970939E-01, 1.8221866182E+00, 1.3694611364E-02, 1.3260827861E-02, 6.4879827426E-01],
	[1.9670000000E+04, 5.4371165050E-01, 1.8220654819E+00, 1.3704730460E-02, 1.3270423789E-02, 6.4888398509E-01],
	[1.9675000000E+04, 5.4390361058E-01, 1.8219443844E+00, 1.3714854460E-02, 1.3280024111E-02, 6.4896965763E-01],
	[1.9680000000E+04, 5.4409558963E-01, 1.8218233258E+00, 1.3724983362E-02, 1.3289628829E-02, 6.4905529187E-01],
	[1.9685000000E+04, 5.4428758765E-01, 1.8217023059E+00, 1.3735117169E-02, 1.3299237943E-02, 6.4914088784E-01],
	[1.9690000000E+04, 5.4447960464E-01, 1.8215813248E+00, 1.3745255882E-02, 1.3308851453E-02, 6.4922644555E-01],
	[1.9695000000E+04, 5.4467164058E-01, 1.8214603825E+00, 1.3755399502E-02, 1.3318469362E-02, 6.4931196499E-01],
	[1.9700000000E+04, 5.4486369548E-01, 1.8213394789E+00, 1.3765548030E-02, 1.3328091668E-02, 6.4939744619E-01],
	[1.9705000000E+04, 5.4505576934E-01, 1.8212186139E+00, 1.3775701467E-02, 1.3337718374E-02, 6.4948288916E-01],
	[1.9710000000E+04, 5.4524786215E-01, 1.8210977877E+00, 1.3785859814E-02, 1.3347349479E-02, 6.4956829389E-01],
	[1.9715000000E+04, 5.4543997391E-01, 1.8209770001E+00, 1.3796023073E-02, 1.3356984985E-02, 6.4965366042E-01],
	[1.9720000000E+04, 5.4563210462E-01, 1.8208562512E+00, 1.3806191244E-02, 1.3366624893E-02, 6.4973898874E-01],
	[1.9725000000E+04, 5.4582425427E-01, 1.8207355409E+00, 1.3816364329E-02, 1.3376269202E-02, 6.4982427886E-01],
	[1.9730000000E+04, 5.4601642286E-01, 1.8206148692E+00, 1.3826542329E-02, 1.3385917915E-02, 6.4990953080E-01],
	[1.9735000000E+04, 5.4620861039E-01, 1.8204942360E+00, 1.3836725244E-02, 1.3395571031E-02, 6.4999474457E-01],
	[1.9740000000E+04, 5.4640081685E-01, 1.8203736414E+00, 1.3846913077E-02, 1.3405228551E-02, 6.5007992018E-01],
	[1.9745000000E+04, 5.4659311577E-01, 1.8202532120E+00, 1.3857105828E-02, 1.3414890528E-02, 6.5016505763E-01],
	[1.9750000000E+04, 5.4678656661E-01, 1.8201347730E+00, 1.3867303498E-02, 1.3424557699E-02, 6.5025015695E-01],
	[1.9755000000E+04, 5.4698003692E-01, 1.8200163716E+00, 1.3877506088E-02, 1.3434229279E-02, 6.5033521813E-01],
	[1.9760000000E+04, 5.4717352670E-01, 1.8198980079E+00, 1.3887713600E-02, 1.3443905268E-02, 6.5042024120E-01],
	[1.9765000000E+04, 5.4736703595E-01, 1.8197796818E+00, 1.3897926035E-02, 1.3453585667E-02, 6.5050522615E-01],
	[1.9770000000E+04, 5.4756056466E-01, 1.8196613933E+00, 1.3908143393E-02, 1.3463270477E-02, 6.5059017301E-01],
	[1.9775000000E+04, 5.4775411283E-01, 1.8195431425E+00, 1.3918365677E-02, 1.3472959697E-02, 6.5067508178E-01],
	[1.9780000000E+04, 5.4794768046E-01, 1.8194249292E+00, 1.3928592886E-02, 1.3482653330E-02, 6.5075995248E-01],
	[1.9785000000E+04, 5.4814126754E-01, 1.8193067534E+00, 1.3938825023E-02, 1.3492351375E-02, 6.5084478510E-01],
	[1.9790000000E+04, 5.4833487407E-01, 1.8191886152E+00, 1.3949062088E-02, 1.3502053835E-02, 6.5092957967E-01],
	[1.9795000000E+04, 5.4852850005E-01, 1.8190705145E+00, 1.3959304082E-02, 1.3511760708E-02, 6.5101433620E-01],
	[1.9800000000E+04, 5.4872214547E-01, 1.8189524514E+00, 1.3969551007E-02, 1.3521471996E-02, 6.5109905469E-01],
	[1.9805000000E+04, 5.4891581034E-01, 1.8188344256E+00, 1.3979802864E-02, 1.3531187701E-02, 6.5118373516E-01],
	[1.9810000000E+04, 5.4910949464E-01, 1.8187164374E+00, 1.3990059654E-02, 1.3540907821E-02, 6.5126837762E-01],
	[1.9815000000E+04, 5.4930319838E-01, 1.8185984865E+00, 1.4000321377E-02, 1.3550632360E-02, 6.5135298208E-01],
	[1.9820000000E+04, 5.4949692156E-01, 1.8184805731E+00, 1.4010588036E-02, 1.3560361316E-02, 6.5143754854E-01],
	[1.9825000000E+04, 5.4969066416E-01, 1.8183626970E+00, 1.4020859630E-02, 1.3570094691E-02, 6.5152207703E-01],
	[1.9830000000E+04, 5.4988442619E-01, 1.8182448583E+00, 1.4031136162E-02, 1.3579832485E-02, 6.5160656755E-01],
	[1.9835000000E+04, 5.5007820765E-01, 1.8181270570E+00, 1.4041417633E-02, 1.3589574700E-02, 6.5169102010E-01],
	[1.9840000000E+04, 5.5027200853E-01, 1.8180092929E+00, 1.4051704043E-02, 1.3599321335E-02, 6.5177543472E-01],
	[1.9845000000E+04, 5.5046582882E-01, 1.8178915662E+00, 1.4061995394E-02, 1.3609072393E-02, 6.5185981139E-01],
	[1.9850000000E+04, 5.5065966853E-01, 1.8177738767E+00, 1.4072291687E-02, 1.3618827873E-02, 6.5194415014E-01],
	[1.9855000000E+04, 5.5085352766E-01, 1.8176562245E+00, 1.4082592922E-02, 1.3628587776E-02, 6.5202845097E-01],
	[1.9860000000E+04, 5.5104740619E-01, 1.8175386096E+00, 1.4092899102E-02, 1.3638352104E-02, 6.5211271390E-01],
	[1.9865000000E+04, 5.5124130413E-01, 1.8174210318E+00, 1.4103210227E-02, 1.3648120856E-02, 6.5219693894E-01],
	[1.9870000000E+04, 5.5143522147E-01, 1.8173034913E+00, 1.4113526298E-02, 1.3657894033E-02, 6.5228112610E-01],
	[1.9875000000E+04, 5.5162915822E-01, 1.8171859879E+00, 1.4123847317E-02, 1.3667671637E-02, 6.5236527538E-01],
	[1.9880000000E+04, 5.5182311436E-01, 1.8170685217E+00, 1.4134173285E-02, 1.3677453668E-02, 6.5244938681E-01],
	[1.9885000000E+04, 5.5201708989E-01, 1.8169510926E+00, 1.4144504202E-02, 1.3687240127E-02, 6.5253346039E-01],
	[1.9890000000E+04, 5.5221108482E-01, 1.8168337006E+00, 1.4154840070E-02, 1.3697031014E-02, 6.5261749612E-01],
	[1.9895000000E+04, 5.5240509914E-01, 1.8167163457E+00, 1.4165180890E-02, 1.3706826330E-02, 6.5270149404E-01],
	[1.9900000000E+04, 5.5259913284E-01, 1.8165990279E+00, 1.4175526663E-02, 1.3716626076E-02, 6.5278545413E-01],
	[1.9905000000E+04, 5.5279318593E-01, 1.8164817471E+00, 1.4185877391E-02, 1.3726430253E-02, 6.5286937642E-01],
	[1.9910000000E+04, 5.5298725840E-01, 1.8163645033E+00, 1.4196233073E-02, 1.3736238862E-02, 6.5295326092E-01],
	[1.9915000000E+04, 5.5318135024E-01, 1.8162472966E+00, 1.4206593713E-02, 1.3746051902E-02, 6.5303710763E-01],
	[1.9920000000E+04, 5.5337546146E-01, 1.8161301268E+00, 1.4216959309E-02, 1.3755869376E-02, 6.5312091658E-01],
	[1.9925000000E+04, 5.5356959205E-01, 1.8160129940E+00, 1.4227329865E-02, 1.3765691283E-02, 6.5320468776E-01],
	[1.9930000000E+04, 5.5376374201E-01, 1.8158958981E+00, 1.4237705381E-02, 1.3775517625E-02, 6.5328842119E-01],
	[1.9935000000E+04, 5.5395791133E-01, 1.8157788392E+00, 1.4248085857E-02, 1.3785348402E-02, 6.5337211689E-01],
	[1.9940000000E+04, 5.5415210002E-01, 1.8156618171E+00, 1.4258471296E-02, 1.3795183614E-02, 6.5345577485E-01],
	[1.9945000000E+04, 5.5434630806E-01, 1.8155448319E+00, 1.4268861698E-02, 1.3805023264E-02, 6.5353939511E-01],
	[1.9950000000E+04, 5.5454053546E-01, 1.8154278836E+00, 1.4279257064E-02, 1.3814867351E-02, 6.5362297765E-01],
	[1.9955000000E+04, 5.5473478222E-01, 1.8153109722E+00, 1.4289657396E-02, 1.3824715876E-02, 6.5370652251E-01],
	[1.9960000000E+04, 5.5492904833E-01, 1.8151940975E+00, 1.4300062694E-02, 1.3834568840E-02, 6.5379002968E-01],
	[1.9965000000E+04, 5.5512333378E-01, 1.8150772596E+00, 1.4310472961E-02, 1.3844426243E-02, 6.5387349917E-01],
	[1.9970000000E+04, 5.5531763858E-01, 1.8149604585E+00, 1.4320888196E-02, 1.3854288087E-02, 6.5395693101E-01],
	[1.9975000000E+04, 5.5551196273E-01, 1.8148436942E+00, 1.4331308401E-02, 1.3864154372E-02, 6.5404032520E-01],
	[1.9980000000E+04, 5.5570630621E-01, 1.8147269666E+00, 1.4341733577E-02, 1.3874025099E-02, 6.5412368176E-01],
	[1.9985000000E+04, 5.5590066903E-01, 1.8146102757E+00, 1.4352163726E-02, 1.3883900268E-02, 6.5420700068E-01],
	[1.9990000000E+04, 5.5609505118E-01, 1.8144936215E+00, 1.4362598848E-02, 1.3893779881E-02, 6.5429028199E-01],
	[1.9995000000E+04, 5.5628945266E-01, 1.8143770040E+00, 1.4373038944E-02, 1.3903663938E-02, 6.5437352570E-01],
	[2.0000000000E+04, 5.5648387347E-01, 1.8142604231E+00, 1.4383484016E-02, 1.3913552439E-02, 6.5445673181E-01],
	[2.0005000000E+04, 5.5667831360E-01, 1.8141438789E+00, 1.4393994820E-02, 1.3923502234E-02, 6.5453990035E-01],
	[2.0010000000E+04, 5.5687277306E-01, 1.8140273712E+00, 1.4404510675E-02, 1.3933456541E-02, 6.5462303131E-01],
	[2.0015000000E+04, 5.5706725183E-01, 1.8139109002E+00, 1.4415031582E-02, 1.3943415359E-02, 6.5470612472E-01],
	[2.0020000000E+04, 5.5726174992E-01, 1.8137944657E+00, 1.4425557543E-02, 1.3953378691E-02, 6.5478918057E-01],
	[2.0025000000E+04, 5.5745626732E-01, 1.8136780678E+00, 1.4436088559E-02, 1.3963346536E-02, 6.5487219889E-01],
	[2.0030000000E+04, 5.5765080404E-01, 1.8135617064E+00, 1.4446624631E-02, 1.3973318895E-02, 6.5495517969E-01],
	[2.0035000000E+04, 5.5784536006E-01, 1.8134453815E+00, 1.4457165759E-02, 1.3983295770E-02, 6.5503812297E-01],
	[2.0040000000E+04, 5.5803993538E-01, 1.8133290930E+00, 1.4467711946E-02, 1.3993277161E-02, 6.5512102875E-01],
	[2.0045000000E+04, 5.5823453001E-01, 1.8132128411E+00, 1.4478263192E-02, 1.4003263068E-02, 6.5520389705E-01],
	[2.0050000000E+04, 5.5842914394E-01, 1.8130966256E+00, 1.4488819499E-02, 1.4013253493E-02, 6.5528672786E-01],
	[2.0055000000E+04, 5.5862377716E-01, 1.8129804465E+00, 1.4499380867E-02, 1.4023248436E-02, 6.5536952120E-01],
	[2.0060000000E+04, 5.5881842967E-01, 1.8128643038E+00, 1.4509947299E-02, 1.4033247898E-02, 6.5545227709E-01],
	[2.0065000000E+04, 5.5901369513E-01, 1.8127491874E+00, 1.4520518794E-02, 1.4043252314E-02, 6.5553499553E-01],
	[2.0070000000E+04, 5.5920960212E-01, 1.8126351437E+00, 1.4531095355E-02, 1.4053261706E-02, 6.5561767654E-01],
	[2.0075000000E+04, 5.5940552895E-01, 1.8125211356E+00, 1.4541676981E-02, 1.4063275622E-02, 6.5570032013E-01],
	[2.0080000000E+04, 5.5960147560E-01, 1.8124071630E+00, 1.4552263676E-02, 1.4073294061E-02, 6.5578292631E-01],
	[2.0085000000E+04, 5.5979744207E-01, 1.8122932259E+00, 1.4562855439E-02, 1.4083317025E-02, 6.5586549508E-01],
	[2.0090000000E+04, 5.5999342837E-01, 1.8121793244E+00, 1.4573452272E-02, 1.4093344515E-02, 6.5594802648E-01],
	[2.0095000000E+04, 5.6018943449E-01, 1.8120654584E+00, 1.4584054176E-02, 1.4103376530E-02, 6.5603052049E-01],
	[2.0100000000E+04, 5.6038546042E-01, 1.8119516279E+00, 1.4594661152E-02, 1.4113413073E-02, 6.5611297714E-01],
	[2.0105000000E+04, 5.6058150616E-01, 1.8118378328E+00, 1.4605273202E-02, 1.4123454143E-02, 6.5619539644E-01],
	[2.0110000000E+04, 5.6077757172E-01, 1.8117240732E+00, 1.4615890326E-02, 1.4133499741E-02, 6.5627777840E-01],
	[2.0115000000E+04, 5.6097365708E-01, 1.8116103489E+00, 1.4626512525E-02, 1.4143549869E-02, 6.5636012302E-01],
	[2.0120000000E+04, 5.6116976224E-01, 1.8114966601E+00, 1.4637139802E-02, 1.4153604527E-02, 6.5644243033E-01],
	[2.0125000000E+04, 5.6136588721E-01, 1.8113830067E+00, 1.4647772157E-02, 1.4163663715E-02, 6.5652470033E-01],
	[2.0130000000E+04, 5.6156203197E-01, 1.8112693886E+00, 1.4658409590E-02, 1.4173727435E-02, 6.5660693304E-01],
	[2.0135000000E+04, 5.6175819653E-01, 1.8111558059E+00, 1.4669052104E-02, 1.4183795688E-02, 6.5668912846E-01],
	[2.0140000000E+04, 5.6195438088E-01, 1.8110422585E+00, 1.4679699700E-02, 1.4193868473E-02, 6.5677128661E-01],
	[2.0145000000E+04, 5.6215058502E-01, 1.8109287464E+00, 1.4690352378E-02, 1.4203945792E-02, 6.5685340750E-01],
	[2.0150000000E+04, 5.6234680895E-01, 1.8108152696E+00, 1.4701010140E-02, 1.4214027646E-02, 6.5693549115E-01],
	[2.0155000000E+04, 5.6254305266E-01, 1.8107018280E+00, 1.4711672987E-02, 1.4224114035E-02, 6.5701753755E-01],
	[2.0160000000E+04, 5.6273931615E-01, 1.8105884217E+00, 1.4722340920E-02, 1.4234204960E-02, 6.5709954673E-01],
	[2.0165000000E+04, 5.6293559942E-01, 1.8104750506E+00, 1.4733013941E-02, 1.4244300422E-02, 6.5718151870E-01],
	[2.0170000000E+04, 5.6313190247E-01, 1.8103617147E+00, 1.4743692050E-02, 1.4254400421E-02, 6.5726345347E-01],
	[2.0175000000E+04, 5.6332822528E-01, 1.8102484140E+00, 1.4754375248E-02, 1.4264504959E-02, 6.5734535104E-01],
	[2.0180000000E+04, 5.6352456787E-01, 1.8101351484E+00, 1.4765063538E-02, 1.4274614036E-02, 6.5742721144E-01],
	[2.0185000000E+04, 5.6372093022E-01, 1.8100219180E+00, 1.4775756919E-02, 1.4284727653E-02, 6.5750903467E-01],
	[2.0190000000E+04, 5.6391731233E-01, 1.8099087228E+00, 1.4786455394E-02, 1.4294845810E-02, 6.5759082074E-01],
	[2.0195000000E+04, 5.6411371421E-01, 1.8097955626E+00, 1.4797158962E-02, 1.4304968509E-02, 6.5767256967E-01],
	[2.0200000000E+04, 5.6431013584E-01, 1.8096824375E+00, 1.4807867627E-02, 1.4315095750E-02, 6.5775428147E-01],
	[2.0205000000E+04, 5.6450657723E-01, 1.8095693475E+00, 1.4818581388E-02, 1.4325227534E-02, 6.5783595615E-01],
	[2.0210000000E+04, 5.6470303836E-01, 1.8094562925E+00, 1.4829300246E-02, 1.4335363861E-02, 6.5791759372E-01],
	[2.0215000000E+04, 5.6489951925E-01, 1.8093432726E+00, 1.4840024204E-02, 1.4345504734E-02, 6.5799919420E-01],
	[2.0220000000E+04, 5.6509601988E-01, 1.8092302876E+00, 1.4850753262E-02, 1.4355650151E-02, 6.5808075759E-01],
	[2.0225000000E+04, 5.6529254026E-01, 1.8091173377E+00, 1.4861487421E-02, 1.4365800114E-02, 6.5816228391E-01],
	[2.0230000000E+04, 5.6548908037E-01, 1.8090044227E+00, 1.4872226682E-02, 1.4375954624E-02, 6.5824377317E-01],
	[2.0235000000E+04, 5.6568564023E-01, 1.8088915427E+00, 1.4882971047E-02, 1.4386113681E-02, 6.5832522537E-01],
	[2.0240000000E+04, 5.6588221981E-01, 1.8087786976E+00, 1.4893720517E-02, 1.4396277287E-02, 6.5840664054E-01],
	[2.0245000000E+04, 5.6607881913E-01, 1.8086658874E+00, 1.4904475093E-02, 1.4406445442E-02, 6.5848801869E-01],
	[2.0250000000E+04, 5.6627543818E-01, 1.8085531121E+00, 1.4915234776E-02, 1.4416618146E-02, 6.5856935982E-01],
	[2.0255000000E+04, 5.6647207695E-01, 1.8084403717E+00, 1.4925999567E-02, 1.4426795401E-02, 6.5865066395E-01],
	[2.0260000000E+04, 5.6666873544E-01, 1.8083276661E+00, 1.4936769467E-02, 1.4436977207E-02, 6.5873193109E-01],
	[2.0265000000E+04, 5.6686541366E-01, 1.8082149954E+00, 1.4947544478E-02, 1.4447163566E-02, 6.5881316126E-01],
	[2.0270000000E+04, 5.6706211159E-01, 1.8081023594E+00, 1.4958324601E-02, 1.4457354477E-02, 6.5889435445E-01],
	[2.0275000000E+04, 5.6725882923E-01, 1.8079897583E+00, 1.4969109837E-02, 1.4467549941E-02, 6.5897551070E-01],
	[2.0280000000E+04, 5.6745556659E-01, 1.8078771920E+00, 1.4979900187E-02, 1.4477749960E-02, 6.5905663000E-01],
	[2.0285000000E+04, 5.6765232365E-01, 1.8077646603E+00, 1.4990695652E-02, 1.4487954534E-02, 6.5913771237E-01],
	[2.0290000000E+04, 5.6784910042E-01, 1.8076521635E+00, 1.5001496233E-02, 1.4498163664E-02, 6.5921875782E-01],
	[2.0295000000E+04, 5.6804589689E-01, 1.8075397013E+00, 1.5012301932E-02, 1.4508377350E-02, 6.5929976636E-01],
	[2.0300000000E+04, 5.6824271306E-01, 1.8074272739E+00, 1.5023112750E-02, 1.4518595593E-02, 6.5938073802E-01],
	[2.0305000000E+04, 5.6843954893E-01, 1.8073148811E+00, 1.5033928688E-02, 1.4528818395E-02, 6.5946167278E-01],
	[2.0310000000E+04, 5.6863640449E-01, 1.8072025230E+00, 1.5044749746E-02, 1.4539045756E-02, 6.5954257068E-01],
	[2.0315000000E+04, 5.6883327974E-01, 1.8070901995E+00, 1.5055575927E-02, 1.4549277676E-02, 6.5962343172E-01],
	[2.0320000000E+04, 5.6903017468E-01, 1.8069779107E+00, 1.5066407232E-02, 1.4559514156E-02, 6.5970425592E-01],
	[2.0325000000E+04, 5.6922708931E-01, 1.8068656564E+00, 1.5077243661E-02, 1.4569755198E-02, 6.5978504328E-01],
	[2.0330000000E+04, 5.6942402362E-01, 1.8067534367E+00, 1.5088085215E-02, 1.4580000801E-02, 6.5986579381E-01],
	[2.0335000000E+04, 5.6962097760E-01, 1.8066412516E+00, 1.5098931896E-02, 1.4590250967E-02, 6.5994650754E-01],
	[2.0340000000E+04, 5.6981795127E-01, 1.8065291011E+00, 1.5109783706E-02, 1.4600505696E-02, 6.6002718447E-01],
	[2.0345000000E+04, 5.7001494460E-01, 1.8064169850E+00, 1.5120640645E-02, 1.4610764990E-02, 6.6010782461E-01],
	[2.0350000000E+04, 5.7021195761E-01, 1.8063049035E+00, 1.5131502714E-02, 1.4621028848E-02, 6.6018842797E-01],
	[2.0355000000E+04, 5.7040899029E-01, 1.8061928565E+00, 1.5142369914E-02, 1.4631297272E-02, 6.6026899458E-01],
	[2.0360000000E+04, 5.7060604263E-01, 1.8060808439E+00, 1.5153242247E-02, 1.4641570262E-02, 6.6034952443E-01],
	[2.0365000000E+04, 5.7080311463E-01, 1.8059688657E+00, 1.5164119714E-02, 1.4651847820E-02, 6.6043001755E-01],
	[2.0370000000E+04, 5.7100020629E-01, 1.8058569220E+00, 1.5175002316E-02, 1.4662129945E-02, 6.6051047394E-01],
	[2.0375000000E+04, 5.7119731761E-01, 1.8057450128E+00, 1.5185890055E-02, 1.4672416639E-02, 6.6059089362E-01],
	[2.0380000000E+04, 5.7139444858E-01, 1.8056331379E+00, 1.5196782930E-02, 1.4682707902E-02, 6.6067127659E-01],
	[2.0385000000E+04, 5.7159159921E-01, 1.8055212973E+00, 1.5207680944E-02, 1.4693003736E-02, 6.6075162288E-01],
	[2.0390000000E+04, 5.7178986688E-01, 1.8054112560E+00, 1.5218584098E-02, 1.4703304983E-02, 6.6083193249E-01],
	[2.0395000000E+04, 5.7198828699E-01, 1.8053014611E+00, 1.5229492392E-02, 1.4713610905E-02, 6.6091220543E-01],
	[2.0400000000E+04, 5.7218672728E-01, 1.8051916998E+00, 1.5240405829E-02, 1.4723921401E-02, 6.6099244172E-01],
	[2.0405000000E+04, 5.7238518777E-01, 1.8050819720E+00, 1.5251324409E-02, 1.4734236472E-02, 6.6107264137E-01],
	[2.0410000000E+04, 5.7258366845E-01, 1.8049722778E+00, 1.5262248133E-02, 1.4744556119E-02, 6.6115280439E-01],
	[2.0415000000E+04, 5.7278216930E-01, 1.8048626171E+00, 1.5273177002E-02, 1.4754880342E-02, 6.6123293079E-01],
	[2.0420000000E+04, 5.7298069034E-01, 1.8047529900E+00, 1.5284111018E-02, 1.4765209143E-02, 6.6131302059E-01],
	[2.0425000000E+04, 5.7317923155E-01, 1.8046433963E+00, 1.5295050182E-02, 1.4775542522E-02, 6.6139307380E-01],
	[2.0430000000E+04, 5.7337779294E-01, 1.8045338361E+00, 1.5305994495E-02, 1.4785880480E-02, 6.6147309043E-01],
	[2.0435000000E+04, 5.7357637449E-01, 1.8044243094E+00, 1.5316943958E-02, 1.4796223017E-02, 6.6155307048E-01],
	[2.0440000000E+04, 5.7377497622E-01, 1.8043148161E+00, 1.5327898572E-02, 1.4806570134E-02, 6.6163301399E-01],
	[2.0445000000E+04, 5.7397359811E-01, 1.8042053562E+00, 1.5338858339E-02, 1.4816921832E-02, 6.6171292094E-01],
	[2.0450000000E+04, 5.7417224016E-01, 1.8040959297E+00, 1.5349823259E-02, 1.4827278113E-02, 6.6179279137E-01],
	[2.0455000000E+04, 5.7437090237E-01, 1.8039865367E+00, 1.5360793334E-02, 1.4837638975E-02, 6.6187262526E-01],
	[2.0460000000E+04, 5.7456958474E-01, 1.8038771769E+00, 1.5371768565E-02, 1.4848004421E-02, 6.6195242265E-01],
	[2.0465000000E+04, 5.7476828727E-01, 1.8037678506E+00, 1.5382748953E-02, 1.4858374451E-02, 6.6203218352E-01],
	[2.0470000000E+04, 5.7496700994E-01, 1.8036585576E+00, 1.5393734499E-02, 1.4868749066E-02, 6.6211190791E-01],
	[2.0475000000E+04, 5.7516575276E-01, 1.8035492978E+00, 1.5404725205E-02, 1.4879128266E-02, 6.6219159581E-01],
	[2.0480000000E+04, 5.7536451573E-01, 1.8034400714E+00, 1.5415721072E-02, 1.4889512053E-02, 6.6227124725E-01],
	[2.0485000000E+04, 5.7556329884E-01, 1.8033308783E+00, 1.5426722100E-02, 1.4899900426E-02, 6.6235086222E-01],
	[2.0490000000E+04, 5.7576210208E-01, 1.8032217184E+00, 1.5437728291E-02, 1.4910293388E-02, 6.6243044074E-01],
	[2.0495000000E+04, 5.7596092547E-01, 1.8031125917E+00, 1.5448739646E-02, 1.4920690938E-02, 6.6250998282E-01],
	[2.0500000000E+04, 5.7615976899E-01, 1.8030034983E+00, 1.5459756166E-02, 1.4931093077E-02, 6.6258948847E-01],
	[2.0505000000E+04, 5.7635863263E-01, 1.8028944380E+00, 1.5470777853E-02, 1.4941499806E-02, 6.6266895770E-01],
	[2.0510000000E+04, 5.7655751641E-01, 1.8027854110E+00, 1.5481804707E-02, 1.4951911126E-02, 6.6274839052E-01],
	[2.0515000000E+04, 5.7675642031E-01, 1.8026764171E+00, 1.5492836730E-02, 1.4962327037E-02, 6.6282778695E-01],
	[2.0520000000E+04, 5.7695534434E-01, 1.8025674564E+00, 1.5503873923E-02, 1.4972747541E-02, 6.6290714699E-01],
	[2.0525000000E+04, 5.7715428848E-01, 1.8024585288E+00, 1.5514916287E-02, 1.4983172638E-02, 6.6298647065E-01],
	[2.0530000000E+04, 5.7735325274E-01, 1.8023496343E+00, 1.5525963823E-02, 1.4993602328E-02, 6.6306575795E-01],
	[2.0535000000E+04, 5.7755223711E-01, 1.8022407729E+00, 1.5537016532E-02, 1.5004036613E-02, 6.6314500890E-01],
	[2.0540000000E+04, 5.7775124159E-01, 1.8021319446E+00, 1.5548074416E-02, 1.5014475494E-02, 6.6322422350E-01],
	[2.0545000000E+04, 5.7795026618E-01, 1.8020231493E+00, 1.5559137476E-02, 1.5024918970E-02, 6.6330340177E-01],
	[2.0550000000E+04, 5.7814931088E-01, 1.8019143871E+00, 1.5570205713E-02, 1.5035367043E-02, 6.6338254371E-01],
	[2.0555000000E+04, 5.7834837568E-01, 1.8018056579E+00, 1.5581279127E-02, 1.5045819713E-02, 6.6346164935E-01],
	[2.0560000000E+04, 5.7854746058E-01, 1.8016969617E+00, 1.5592357721E-02, 1.5056276982E-02, 6.6354071868E-01],
	[2.0565000000E+04, 5.7874656557E-01, 1.8015882985E+00, 1.5603441495E-02, 1.5066738850E-02, 6.6361975173E-01],
	[2.0570000000E+04, 5.7894569066E-01, 1.8014796683E+00, 1.5614530451E-02, 1.5077205317E-02, 6.6369874850E-01],
	[2.0575000000E+04, 5.7914483583E-01, 1.8013710710E+00, 1.5625624589E-02, 1.5087676385E-02, 6.6377770900E-01],
	[2.0580000000E+04, 5.7934400110E-01, 1.8012625066E+00, 1.5636723911E-02, 1.5098152054E-02, 6.6385663324E-01],
	[2.0585000000E+04, 5.7954318645E-01, 1.8011539752E+00, 1.5647828418E-02, 1.5108632325E-02, 6.6393552124E-01],
	[2.0590000000E+04, 5.7974239188E-01, 1.8010454766E+00, 1.5658938111E-02, 1.5119117199E-02, 6.6401437300E-01],
	[2.0595000000E+04, 5.7994161739E-01, 1.8009370110E+00, 1.5670052992E-02, 1.5129606676E-02, 6.6409318853E-01],
	[2.0600000000E+04, 5.8014086298E-01, 1.8008285781E+00, 1.5681173061E-02, 1.5140100757E-02, 6.6417196786E-01],
	[2.0605000000E+04, 5.8034012864E-01, 1.8007201782E+00, 1.5692298320E-02, 1.5150599444E-02, 6.6425071098E-01],
	[2.0610000000E+04, 5.8053941437E-01, 1.8006118110E+00, 1.5703428769E-02, 1.5161102736E-02, 6.6432941791E-01],
	[2.0615000000E+04, 5.8073872017E-01, 1.8005034767E+00, 1.5714564411E-02, 1.5171610634E-02, 6.6440808866E-01],
	[2.0620000000E+04, 5.8093804603E-01, 1.8003951751E+00, 1.5725705245E-02, 1.5182123140E-02, 6.6448672324E-01],
	[2.0625000000E+04, 5.8113739196E-01, 1.8002869063E+00, 1.5736851274E-02, 1.5192640253E-02, 6.6456532166E-01],
	[2.0630000000E+04, 5.8133675795E-01, 1.8001786703E+00, 1.5748002498E-02, 1.5203161975E-02, 6.6464388393E-01],
	[2.0635000000E+04, 5.8153614399E-01, 1.8000704670E+00, 1.5759158919E-02, 1.5213688307E-02, 6.6472241007E-01],
	[2.0640000000E+04, 5.8173555008E-01, 1.7999622964E+00, 1.5770320538E-02, 1.5224219248E-02, 6.6480090008E-01],
	[2.0645000000E+04, 5.8193497623E-01, 1.7998541586E+00, 1.5781487355E-02, 1.5234754801E-02, 6.6487935398E-01],
	[2.0650000000E+04, 5.8213442243E-01, 1.7997460533E+00, 1.5792659373E-02, 1.5245294965E-02, 6.6495777177E-01],
	[2.0655000000E+04, 5.8233388866E-01, 1.7996379808E+00, 1.5803836592E-02, 1.5255839742E-02, 6.6503615347E-01],
	[2.0660000000E+04, 5.8253337495E-01, 1.7995299409E+00, 1.5815019013E-02, 1.5266389131E-02, 6.6511449909E-01],
	[2.0665000000E+04, 5.8273288127E-01, 1.7994219337E+00, 1.5826206638E-02, 1.5276943135E-02, 6.6519280864E-01],
	[2.0670000000E+04, 5.8293240762E-01, 1.7993139590E+00, 1.5837399468E-02, 1.5287501753E-02, 6.6527108214E-01],
	[2.0675000000E+04, 5.8313195401E-01, 1.7992060169E+00, 1.5848597503E-02, 1.5298064986E-02, 6.6534931958E-01],
	[2.0680000000E+04, 5.8333152044E-01, 1.7990981074E+00, 1.5859800746E-02, 1.5308632836E-02, 6.6542752099E-01],
	[2.0685000000E+04, 5.8353110689E-01, 1.7989902305E+00, 1.5871009196E-02, 1.5319205302E-02, 6.6550568637E-01],
	[2.0690000000E+04, 5.8373071336E-01, 1.7988823861E+00, 1.5882222857E-02, 1.5329782386E-02, 6.6558381573E-01],
	[2.0695000000E+04, 5.8393033986E-01, 1.7987745743E+00, 1.5893441727E-02, 1.5340364088E-02, 6.6566190910E-01],
	[2.0700000000E+04, 5.8412998638E-01, 1.7986667949E+00, 1.5904665810E-02, 1.5350950409E-02, 6.6573996647E-01],
	[2.0705000000E+04, 5.8432965291E-01, 1.7985590480E+00, 1.5915895105E-02, 1.5361541350E-02, 6.6581798786E-01],
	[2.0710000000E+04, 5.8452933946E-01, 1.7984513336E+00, 1.5927129614E-02, 1.5372136911E-02, 6.6589597328E-01],
	[2.0715000000E+04, 5.8472936530E-01, 1.7983441469E+00, 1.5938369339E-02, 1.5382737351E-02, 6.6597392274E-01],
	[2.0720000000E+04, 5.8493033673E-01, 1.7982384272E+00, 1.5949614280E-02, 1.5393343159E-02, 6.6605183625E-01],
	[2.0725000000E+04, 5.8513132871E-01, 1.7981327392E+00, 1.5960864438E-02, 1.5403953592E-02, 6.6612971383E-01],
	[2.0730000000E+04, 5.8533234125E-01, 1.7980270830E+00, 1.5972119815E-02, 1.5414568651E-02, 6.6620755548E-01],
	[2.0735000000E+04, 5.8553337435E-01, 1.7979214584E+00, 1.5983380412E-02, 1.5425188335E-02, 6.6628536122E-01],
	[2.0740000000E+04, 5.8573442799E-01, 1.7978158655E+00, 1.5994646230E-02, 1.5435812647E-02, 6.6636313106E-01],
	[2.0745000000E+04, 5.8593550218E-01, 1.7977103042E+00, 1.6005917270E-02, 1.5446441586E-02, 6.6644086501E-01],
	[2.0750000000E+04, 5.8613659691E-01, 1.7976047746E+00, 1.6017193533E-02, 1.5457075153E-02, 6.6651856307E-01],
	[2.0755000000E+04, 5.8633771218E-01, 1.7974992766E+00, 1.6028475021E-02, 1.5467713350E-02, 6.6659622527E-01],
	[2.0760000000E+04, 5.8653884799E-01, 1.7973938103E+00, 1.6039761735E-02, 1.5478356176E-02, 6.6667385161E-01],
	[2.0765000000E+04, 5.8674000434E-01, 1.7972883754E+00, 1.6051053675E-02, 1.5489003633E-02, 6.6675144210E-01],
	[2.0770000000E+04, 5.8694118122E-01, 1.7971829722E+00, 1.6062350843E-02, 1.5499655721E-02, 6.6682899676E-01],
	[2.0775000000E+04, 5.8714237862E-01, 1.7970776005E+00, 1.6073653240E-02, 1.5510312441E-02, 6.6690651560E-01],
	[2.0780000000E+04, 5.8734359655E-01, 1.7969722604E+00, 1.6084960868E-02, 1.5520973795E-02, 6.6698399863E-01],
	[2.0785000000E+04, 5.8754483501E-01, 1.7968669517E+00, 1.6096273727E-02, 1.5531639781E-02, 6.6706144585E-01],
	[2.0790000000E+04, 5.8774609399E-01, 1.7967616746E+00, 1.6107591819E-02, 1.5542310402E-02, 6.6713885729E-01],
	[2.0795000000E+04, 5.8794737348E-01, 1.7966564289E+00, 1.6118915144E-02, 1.5552985658E-02, 6.6721623294E-01],
	[2.0800000000E+04, 5.8814867349E-01, 1.7965512147E+00, 1.6130243705E-02, 1.5563665550E-02, 6.6729357284E-01],
	[2.0805000000E+04, 5.8834999402E-01, 1.7964460320E+00, 1.6141577501E-02, 1.5574350078E-02, 6.6737087697E-01],
	[2.0810000000E+04, 5.8855133505E-01, 1.7963408807E+00, 1.6152916535E-02, 1.5585039243E-02, 6.6744814536E-01],
	[2.0815000000E+04, 5.8875269658E-01, 1.7962357608E+00, 1.6164260807E-02, 1.5595733046E-02, 6.6752537803E-01],
	[2.0820000000E+04, 5.8895407863E-01, 1.7961306723E+00, 1.6175610319E-02, 1.5606431488E-02, 6.6760257497E-01],
	[2.0825000000E+04, 5.8915548117E-01, 1.7960256151E+00, 1.6186965071E-02, 1.5617134570E-02, 6.6767973620E-01],
	[2.0830000000E+04, 5.8935690421E-01, 1.7959205894E+00, 1.6198325065E-02, 1.5627842291E-02, 6.6775686173E-01],
	[2.0835000000E+04, 5.8955834774E-01, 1.7958155950E+00, 1.6209690303E-02, 1.5638554654E-02, 6.6783395158E-01],
	[2.0840000000E+04, 5.8975981177E-01, 1.7957106319E+00, 1.6221060784E-02, 1.5649271658E-02, 6.6791100575E-01],
	[2.0845000000E+04, 5.8996129629E-01, 1.7956057001E+00, 1.6232436511E-02, 1.5659993304E-02, 6.6798802426E-01],
	[2.0850000000E+04, 5.9016280129E-01, 1.7955007996E+00, 1.6243817485E-02, 1.5670719594E-02, 6.6806500712E-01],
	[2.0855000000E+04, 5.9036432678E-01, 1.7953959304E+00, 1.6255203706E-02, 1.5681450527E-02, 6.6814195434E-01],
	[2.0860000000E+04, 5.9056587275E-01, 1.7952910925E+00, 1.6266595176E-02, 1.5692186105E-02, 6.6821886593E-01],
	[2.0865000000E+04, 5.9076743920E-01, 1.7951862858E+00, 1.6277991896E-02, 1.5702926328E-02, 6.6829574190E-01],
	[2.0870000000E+04, 5.9096902612E-01, 1.7950815104E+00, 1.6289393867E-02, 1.5713671197E-02, 6.6837258227E-01],
	[2.0875000000E+04, 5.9117063351E-01, 1.7949767661E+00, 1.6300801091E-02, 1.5724420713E-02, 6.6844938704E-01],
	[2.0880000000E+04, 5.9137226138E-01, 1.7948720531E+00, 1.6312213568E-02, 1.5735174877E-02, 6.6852615623E-01],
	[2.0885000000E+04, 5.9157390971E-01, 1.7947673712E+00, 1.6323631300E-02, 1.5745933689E-02, 6.6860288985E-01],
	[2.0890000000E+04, 5.9177557850E-01, 1.7946627205E+00, 1.6335054287E-02, 1.5756697149E-02, 6.6867958792E-01],
	[2.0895000000E+04, 5.9197726776E-01, 1.7945581009E+00, 1.6346482532E-02, 1.5767465260E-02, 6.6875625043E-01],
	[2.0900000000E+04, 5.9217897747E-01, 1.7944535125E+00, 1.6357916035E-02, 1.5778238021E-02, 6.6883287741E-01],
	[2.0905000000E+04, 5.9238070765E-01, 1.7943489551E+00, 1.6369354797E-02, 1.5789015433E-02, 6.6890946886E-01],
	[2.0910000000E+04, 5.9258245827E-01, 1.7942444289E+00, 1.6380798819E-02, 1.5799797496E-02, 6.6898602480E-01],
	[2.0915000000E+04, 5.9278422934E-01, 1.7941399338E+00, 1.6392248103E-02, 1.5810584213E-02, 6.6906254524E-01],
	[2.0920000000E+04, 5.9298602086E-01, 1.7940354697E+00, 1.6403702650E-02, 1.5821375583E-02, 6.6913903019E-01],
	[2.0925000000E+04, 5.9318783283E-01, 1.7939310366E+00, 1.6415162461E-02, 1.5832171607E-02, 6.6921547967E-01],
	[2.0930000000E+04, 5.9338966523E-01, 1.7938266346E+00, 1.6426627537E-02, 1.5842972285E-02, 6.6929189367E-01],
	[2.0935000000E+04, 5.9359151808E-01, 1.7937222636E+00, 1.6438097879E-02, 1.5853777620E-02, 6.6936827223E-01],
	[2.0940000000E+04, 5.9379339136E-01, 1.7936179236E+00, 1.6449573488E-02, 1.5864587610E-02, 6.6944461534E-01],
	[2.0945000000E+04, 5.9399528507E-01, 1.7935136145E+00, 1.6461054367E-02, 1.5875402258E-02, 6.6952092302E-01],
	[2.0950000000E+04, 5.9419719921E-01, 1.7934093365E+00, 1.6472540514E-02, 1.5886221563E-02, 6.6959719528E-01],
	[2.0955000000E+04, 5.9439913378E-01, 1.7933050893E+00, 1.6484031933E-02, 1.5897045527E-02, 6.6967343213E-01],
	[2.0960000000E+04, 5.9460108878E-01, 1.7932008731E+00, 1.6495528624E-02, 1.5907874150E-02, 6.6974963359E-01],
	[2.0965000000E+04, 5.9480306420E-01, 1.7930966879E+00, 1.6507030588E-02, 1.5918707433E-02, 6.6982579967E-01],
	[2.0970000000E+04, 5.9500506003E-01, 1.7929925335E+00, 1.6518537827E-02, 1.5929545376E-02, 6.6990193037E-01],
	[2.0975000000E+04, 5.9520707629E-01, 1.7928884099E+00, 1.6530050341E-02, 1.5940387981E-02, 6.6997802571E-01],
	[2.0980000000E+04, 5.9540911295E-01, 1.7927843173E+00, 1.6541568132E-02, 1.5951235248E-02, 6.7005408571E-01],
	[2.0985000000E+04, 5.9561117003E-01, 1.7926802555E+00, 1.6553091200E-02, 1.5962087178E-02, 6.7013011036E-01],
	[2.0990000000E+04, 5.9581324751E-01, 1.7925762245E+00, 1.6564619548E-02, 1.5972943771E-02, 6.7020609969E-01],
	[2.0995000000E+04, 5.9601534540E-01, 1.7924722244E+00, 1.6576153176E-02, 1.5983805029E-02, 6.7028205371E-01],
	[2.1000000000E+04, 5.9621746369E-01, 1.7923682550E+00, 1.6587692085E-02, 1.5994670952E-02, 6.7035797243E-01],
	[2.1005000000E+04, 5.9641960238E-01, 1.7922643164E+00, 1.6599236277E-02, 1.6005541540E-02, 6.7043385586E-01],
	[2.1010000000E+04, 5.9662176147E-01, 1.7921604086E+00, 1.6610785752E-02, 1.6016416795E-02, 6.7050970401E-01],
	[2.1015000000E+04, 5.9682394095E-01, 1.7920565315E+00, 1.6622340512E-02, 1.6027296718E-02, 6.7058551690E-01],
	[2.1020000000E+04, 5.9702614082E-01, 1.7919526852E+00, 1.6633900558E-02, 1.6038181308E-02, 6.7066129453E-01],
	[2.1025000000E+04, 5.9722836108E-01, 1.7918488695E+00, 1.6645465892E-02, 1.6049070566E-02, 6.7073703692E-01],
	[2.1030000000E+04, 5.9743060173E-01, 1.7917450846E+00, 1.6657036513E-02, 1.6059964495E-02, 6.7081274408E-01],
	[2.1035000000E+04, 5.9763286276E-01, 1.7916413303E+00, 1.6668612424E-02, 1.6070863093E-02, 6.7088841602E-01],
	[2.1040000000E+04, 5.9783514417E-01, 1.7915376068E+00, 1.6680193626E-02, 1.6081766362E-02, 6.7096405275E-01],
	[2.1045000000E+04, 5.9803744595E-01, 1.7914339138E+00, 1.6691780120E-02, 1.6092674302E-02, 6.7103965429E-01],
	[2.1050000000E+04, 5.9824047875E-01, 1.7913313141E+00, 1.6703371906E-02, 1.6103587516E-02, 6.7111522065E-01],
	[2.1055000000E+04, 5.9844408165E-01, 1.7912295657E+00, 1.6714968987E-02, 1.6114505869E-02, 6.7119075184E-01],
	[2.1060000000E+04, 5.9864770548E-01, 1.7911278473E+00, 1.6726571363E-02, 1.6125428897E-02, 6.7126624787E-01],
	[2.1065000000E+04, 5.9885135023E-01, 1.7910261589E+00, 1.6738179035E-02, 1.6136356602E-02, 6.7134170875E-01],
	[2.1070000000E+04, 5.9905501590E-01, 1.7909245003E+00, 1.6749792005E-02, 1.6147288984E-02, 6.7141713450E-01],
	[2.1075000000E+04, 5.9925870248E-01, 1.7908228716E+00, 1.6761410273E-02, 1.6158226044E-02, 6.7149252513E-01],
	[2.1080000000E+04, 5.9946240998E-01, 1.7907212728E+00, 1.6773033842E-02, 1.6169167783E-02, 6.7156788064E-01],
	[2.1085000000E+04, 5.9966613839E-01, 1.7906197039E+00, 1.6784662711E-02, 1.6180114201E-02, 6.7164320106E-01],
	[2.1090000000E+04, 5.9986988770E-01, 1.7905181648E+00, 1.6796296883E-02, 1.6191065300E-02, 6.7171848639E-01],
	[2.1095000000E+04, 6.0007365792E-01, 1.7904166555E+00, 1.6807936358E-02, 1.6202021079E-02, 6.7179373665E-01],
	[2.1100000000E+04, 6.0027744904E-01, 1.7903151760E+00, 1.6819581138E-02, 1.6212981540E-02, 6.7186895184E-01],
	[2.1105000000E+04, 6.0048126106E-01, 1.7902137263E+00, 1.6831231223E-02, 1.6223946683E-02, 6.7194413198E-01],
	[2.1110000000E+04, 6.0068509398E-01, 1.7901123064E+00, 1.6842886616E-02, 1.6234916509E-02, 6.7201927708E-01],
	[2.1115000000E+04, 6.0088894779E-01, 1.7900109163E+00, 1.6854547316E-02, 1.6245891018E-02, 6.7209438716E-01],
	[2.1120000000E+04, 6.0109282249E-01, 1.7899095559E+00, 1.6866213325E-02, 1.6256870213E-02, 6.7216946222E-01],
	[2.1125000000E+04, 6.0129671808E-01, 1.7898082253E+00, 1.6877884645E-02, 1.6267854092E-02, 6.7224450228E-01],
	[2.1130000000E+04, 6.0150063455E-01, 1.7897069243E+00, 1.6889561277E-02, 1.6278842657E-02, 6.7231950735E-01],
	[2.1135000000E+04, 6.0170457191E-01, 1.7896056531E+00, 1.6901243221E-02, 1.6289835909E-02, 6.7239447745E-01],
	[2.1140000000E+04, 6.0190853014E-01, 1.7895044115E+00, 1.6912930478E-02, 1.6300833849E-02, 6.7246941257E-01],
	[2.1145000000E+04, 6.0211250925E-01, 1.7894031996E+00, 1.6924623051E-02, 1.6311836476E-02, 6.7254431274E-01],
	[2.1150000000E+04, 6.0231650923E-01, 1.7893020174E+00, 1.6936320940E-02, 1.6322843792E-02, 6.7261917797E-01],
	[2.1155000000E+04, 6.0252053009E-01, 1.7892008648E+00, 1.6948024146E-02, 1.6333855798E-02, 6.7269400827E-01],
	[2.1160000000E+04, 6.0272457181E-01, 1.7890997418E+00, 1.6959732671E-02, 1.6344872494E-02, 6.7276880366E-01],
	[2.1165000000E+04, 6.0292863440E-01, 1.7889986484E+00, 1.6971446515E-02, 1.6355893881E-02, 6.7284356413E-01],
	[2.1170000000E+04, 6.0313271785E-01, 1.7888975846E+00, 1.6983165680E-02, 1.6366919960E-02, 6.7291828972E-01],
	[2.1175000000E+04, 6.0333682216E-01, 1.7887965504E+00, 1.6994890167E-02, 1.6377950731E-02, 6.7299298042E-01],
	[2.1180000000E+04, 6.0354094733E-01, 1.7886955458E+00, 1.7006619978E-02, 1.6388986195E-02, 6.7306763625E-01],
	[2.1185000000E+04, 6.0374509335E-01, 1.7885945707E+00, 1.7018355112E-02, 1.6400026354E-02, 6.7314225723E-01],
	[2.1190000000E+04, 6.0394926023E-01, 1.7884936251E+00, 1.7030095572E-02, 1.6411071206E-02, 6.7321684336E-01],
	[2.1195000000E+04, 6.0415344795E-01, 1.7883927090E+00, 1.7041841358E-02, 1.6422120754E-02, 6.7329139466E-01],
	[2.1200000000E+04, 6.0435765652E-01, 1.7882918224E+00, 1.7053592472E-02, 1.6433174998E-02, 6.7336591114E-01],
	[2.1205000000E+04, 6.0456188593E-01, 1.7881909653E+00, 1.7065348915E-02, 1.6444233939E-02, 6.7344039281E-01],
	[2.1210000000E+04, 6.0476613618E-01, 1.7880901377E+00, 1.7077110688E-02, 1.6455297577E-02, 6.7351483968E-01],
	[2.1215000000E+04, 6.0497040726E-01, 1.7879893395E+00, 1.7088877792E-02, 1.6466365914E-02, 6.7358925177E-01],
	[2.1220000000E+04, 6.0517469919E-01, 1.7878885708E+00, 1.7100650229E-02, 1.6477438949E-02, 6.7366362909E-01],
	[2.1225000000E+04, 6.0537901194E-01, 1.7877878314E+00, 1.7112427999E-02, 1.6488516684E-02, 6.7373797165E-01],
	[2.1230000000E+04, 6.0558334552E-01, 1.7876871215E+00, 1.7124211104E-02, 1.6499599119E-02, 6.7381227947E-01],
	[2.1235000000E+04, 6.0578769993E-01, 1.7875864410E+00, 1.7135999545E-02, 1.6510686256E-02, 6.7388655254E-01],
	[2.1240000000E+04, 6.0599207517E-01, 1.7874857898E+00, 1.7147793322E-02, 1.6521778094E-02, 6.7396079090E-01],
	[2.1245000000E+04, 6.0619647122E-01, 1.7873851680E+00, 1.7159592438E-02, 1.6532874634E-02, 6.7403499455E-01],
	[2.1250000000E+04, 6.0640088809E-01, 1.7872845755E+00, 1.7171396893E-02, 1.6543975878E-02, 6.7410916350E-01],
	[2.1255000000E+04, 6.0660532578E-01, 1.7871840124E+00, 1.7183206689E-02, 1.6555081826E-02, 6.7418329776E-01],
	[2.1260000000E+04, 6.0680978428E-01, 1.7870834785E+00, 1.7195021826E-02, 1.6566192478E-02, 6.7425739735E-01],
	[2.1265000000E+04, 6.0701426359E-01, 1.7869829740E+00, 1.7206842306E-02, 1.6577307836E-02, 6.7433146228E-01],
	[2.1270000000E+04, 6.0721876370E-01, 1.7868824987E+00, 1.7218668130E-02, 1.6588427900E-02, 6.7440549256E-01],
	[2.1275000000E+04, 6.0742328462E-01, 1.7867820527E+00, 1.7230499299E-02, 1.6599552670E-02, 6.7447948820E-01],
	[2.1280000000E+04, 6.0762782634E-01, 1.7866816360E+00, 1.7242335815E-02, 1.6610682149E-02, 6.7455344922E-01],
	[2.1285000000E+04, 6.0783238886E-01, 1.7865812485E+00, 1.7254177678E-02, 1.6621816335E-02, 6.7462737563E-01],
	[2.1290000000E+04, 6.0803697218E-01, 1.7864808902E+00, 1.7266024889E-02, 1.6632955230E-02, 6.7470126743E-01],
	[2.1295000000E+04, 6.0824157628E-01, 1.7863805611E+00, 1.7277877450E-02, 1.6644098835E-02, 6.7477512466E-01],
	[2.1300000000E+04, 6.0844620118E-01, 1.7862802612E+00, 1.7289735363E-02, 1.6655247151E-02, 6.7484894730E-01],
	[2.1305000000E+04, 6.0865084687E-01, 1.7861799904E+00, 1.7301598627E-02, 1.6666400177E-02, 6.7492273539E-01],
	[2.1310000000E+04, 6.0885551334E-01, 1.7860797488E+00, 1.7313467244E-02, 1.6677557915E-02, 6.7499648892E-01],
	[2.1315000000E+04, 6.0906020059E-01, 1.7859795364E+00, 1.7325341216E-02, 1.6688720366E-02, 6.7507020792E-01],
	[2.1320000000E+04, 6.0926490862E-01, 1.7858793531E+00, 1.7337220543E-02, 1.6699887530E-02, 6.7514389239E-01],
	[2.1325000000E+04, 6.0946963743E-01, 1.7857791989E+00, 1.7349105227E-02, 1.6711059408E-02, 6.7521754235E-01],
	[2.1330000000E+04, 6.0967438701E-01, 1.7856790738E+00, 1.7360995269E-02, 1.6722236001E-02, 6.7529115781E-01],
	[2.1335000000E+04, 6.0987915736E-01, 1.7855789777E+00, 1.7372890670E-02, 1.6733417309E-02, 6.7536473878E-01],
	[2.1340000000E+04, 6.1008394848E-01, 1.7854789107E+00, 1.7384791431E-02, 1.6744603333E-02, 6.7543828528E-01],
	[2.1345000000E+04, 6.1028876036E-01, 1.7853788728E+00, 1.7396697554E-02, 1.6755794074E-02, 6.7551179731E-01],
	[2.1350000000E+04, 6.1049359301E-01, 1.7852788639E+00, 1.7408609039E-02, 1.6766989532E-02, 6.7558527492E-01],
	[2.1355000000E+04, 6.1069844642E-01, 1.7851788841E+00, 1.7420525888E-02, 1.6778189709E-02, 6.7565871816E-01],
	[2.1360000000E+04, 6.1090332058E-01, 1.7850789332E+00, 1.7432448101E-02, 1.6789394604E-02, 6.7573212702E-01],
	[2.1365000000E+04, 6.1110821550E-01, 1.7849790113E+00, 1.7444375680E-02, 1.6800604220E-02, 6.7580550154E-01],
	[2.1370000000E+04, 6.1131313117E-01, 1.7848791184E+00, 1.7456308627E-02, 1.6811818555E-02, 6.7587884171E-01],
	[2.1375000000E+04, 6.1151806759E-01, 1.7847792545E+00, 1.7468246942E-02, 1.6823037612E-02, 6.7595214754E-01],
	[2.1380000000E+04, 6.1172302475E-01, 1.7846794195E+00, 1.7480190626E-02, 1.6834261390E-02, 6.7602541905E-01],
	[2.1385000000E+04, 6.1192800266E-01, 1.7845796134E+00, 1.7492139681E-02, 1.6845489891E-02, 6.7609865624E-01],
	[2.1390000000E+04, 6.1213401909E-01, 1.7844813032E+00, 1.7504094108E-02, 1.6856724018E-02, 6.7617185913E-01],
	[2.1395000000E+04, 6.1234031465E-01, 1.7843833931E+00, 1.7516053907E-02, 1.6867963100E-02, 6.7624502772E-01],
	[2.1400000000E+04, 6.1254663151E-01, 1.7842855112E+00, 1.7528019081E-02, 1.6879206908E-02, 6.7631816203E-01],
	[2.1405000000E+04, 6.1275296966E-01, 1.7841876576E+00, 1.7539989630E-02, 1.6890455444E-02, 6.7639126206E-01],
	[2.1410000000E+04, 6.1295932909E-01, 1.7840898321E+00, 1.7551965555E-02, 1.6901708708E-02, 6.7646432783E-01],
	[2.1415000000E+04, 6.1316570982E-01, 1.7839920349E+00, 1.7563946858E-02, 1.6912966700E-02, 6.7653735934E-01],
	[2.1420000000E+04, 6.1337211182E-01, 1.7838942659E+00, 1.7575933540E-02, 1.6924229423E-02, 6.7661035661E-01],
	[2.1425000000E+04, 6.1357853511E-01, 1.7837965250E+00, 1.7587925601E-02, 1.6935496876E-02, 6.7668331965E-01],
	[2.1430000000E+04, 6.1378497967E-01, 1.7836988123E+00, 1.7599923044E-02, 1.6946769059E-02, 6.7675624846E-01],
	[2.1435000000E+04, 6.1399144551E-01, 1.7836011278E+00, 1.7611925868E-02, 1.6958045975E-02, 6.7682914306E-01],
	[2.1440000000E+04, 6.1419793261E-01, 1.7835034713E+00, 1.7623934076E-02, 1.6969327623E-02, 6.7690200346E-01],
	[2.1445000000E+04, 6.1440444099E-01, 1.7834058430E+00, 1.7635947669E-02, 1.6980614004E-02, 6.7697482966E-01],
	[2.1450000000E+04, 6.1461097064E-01, 1.7833082428E+00, 1.7647966647E-02, 1.6991905119E-02, 6.7704762168E-01],
	[2.1455000000E+04, 6.1481752154E-01, 1.7832106707E+00, 1.7659991012E-02, 1.7003200969E-02, 6.7712037953E-01],
	[2.1460000000E+04, 6.1502409371E-01, 1.7831131267E+00, 1.7672020765E-02, 1.7014501554E-02, 6.7719310321E-01],
	[2.1465000000E+04, 6.1523068714E-01, 1.7830156107E+00, 1.7684055907E-02, 1.7025806875E-02, 6.7726579275E-01],
	[2.1470000000E+04, 6.1543730182E-01, 1.7829181227E+00, 1.7696096440E-02, 1.7037116932E-02, 6.7733844814E-01],
	[2.1475000000E+04, 6.1564393775E-01, 1.7828206628E+00, 1.7708142364E-02, 1.7048431727E-02, 6.7741106940E-01],
	[2.1480000000E+04, 6.1585059493E-01, 1.7827232309E+00, 1.7720193680E-02, 1.7059751260E-02, 6.7748365654E-01],
	[2.1485000000E+04, 6.1605727336E-01, 1.7826258270E+00, 1.7732250391E-02, 1.7071075533E-02, 6.7755620957E-01],
	[2.1490000000E+04, 6.1626397303E-01, 1.7825284511E+00, 1.7744312496E-02, 1.7082404544E-02, 6.7762872850E-01],
	[2.1495000000E+04, 6.1647069395E-01, 1.7824311032E+00, 1.7756379997E-02, 1.7093738296E-02, 6.7770121334E-01],
	[2.1500000000E+04, 6.1667743610E-01, 1.7823337832E+00, 1.7768452896E-02, 1.7105076789E-02, 6.7777366410E-01],
	[2.1505000000E+04, 6.1688419949E-01, 1.7822364912E+00, 1.7780531193E-02, 1.7116420023E-02, 6.7784608079E-01],
	[2.1510000000E+04, 6.1709098411E-01, 1.7821392270E+00, 1.7792614889E-02, 1.7127768000E-02, 6.7791846342E-01],
	[2.1515000000E+04, 6.1729778996E-01, 1.7820419908E+00, 1.7804703987E-02, 1.7139120720E-02, 6.7799081201E-01],
	[2.1520000000E+04, 6.1750461704E-01, 1.7819447825E+00, 1.7816798486E-02, 1.7150478184E-02, 6.7806312656E-01],
	[2.1525000000E+04, 6.1771146535E-01, 1.7818476021E+00, 1.7828898388E-02, 1.7161840392E-02, 6.7813540708E-01],
	[2.1530000000E+04, 6.1791833487E-01, 1.7817504496E+00, 1.7841003694E-02, 1.7173207346E-02, 6.7820765358E-01],
	[2.1535000000E+04, 6.1812522562E-01, 1.7816533249E+00, 1.7853114406E-02, 1.7184579045E-02, 6.7827986608E-01],
	[2.1540000000E+04, 6.1833213758E-01, 1.7815562280E+00, 1.7865230524E-02, 1.7195955491E-02, 6.7835204458E-01],
	[2.1545000000E+04, 6.1853907075E-01, 1.7814591590E+00, 1.7877352050E-02, 1.7207336685E-02, 6.7842418910E-01],
	[2.1550000000E+04, 6.1874602514E-01, 1.7813621178E+00, 1.7889478985E-02, 1.7218722626E-02, 6.7849629964E-01],
	[2.1555000000E+04, 6.1895300073E-01, 1.7812651043E+00, 1.7901611330E-02, 1.7230113317E-02, 6.7856837622E-01],
	[2.1560000000E+04, 6.1915999753E-01, 1.7811681187E+00, 1.7913749085E-02, 1.7241508756E-02, 6.7864041885E-01],
	[2.1565000000E+04, 6.1936701554E-01, 1.7810711608E+00, 1.7925892254E-02, 1.7252908946E-02, 6.7871242753E-01],
	[2.1570000000E+04, 6.1957405474E-01, 1.7809742307E+00, 1.7938040835E-02, 1.7264313887E-02, 6.7878440228E-01],
	[2.1575000000E+04, 6.1978111514E-01, 1.7808773283E+00, 1.7950194831E-02, 1.7275723579E-02, 6.7885634311E-01],
	[2.1580000000E+04, 6.1998819673E-01, 1.7807804537E+00, 1.7962354243E-02, 1.7287138023E-02, 6.7892825003E-01],
	[2.1585000000E+04, 6.2019529952E-01, 1.7806836067E+00, 1.7974519072E-02, 1.7298557221E-02, 6.7900012304E-01],
	[2.1590000000E+04, 6.2040242349E-01, 1.7805867875E+00, 1.7986689319E-02, 1.7309981172E-02, 6.7907196217E-01],
	[2.1595000000E+04, 6.2060956866E-01, 1.7804899959E+00, 1.7998864986E-02, 1.7321409878E-02, 6.7914376742E-01],
	[2.1600000000E+04, 6.2081673500E-01, 1.7803932320E+00, 1.8011046072E-02, 1.7332843338E-02, 6.7921553880E-01],
	[2.1605000000E+04, 6.2102392253E-01, 1.7802964958E+00, 1.8023232580E-02, 1.7344281555E-02, 6.7928727632E-01],
	[2.1610000000E+04, 6.2123113123E-01, 1.7801997872E+00, 1.8035424511E-02, 1.7355724528E-02, 6.7935897999E-01],
	[2.1615000000E+04, 6.2143836111E-01, 1.7801031062E+00, 1.8047621866E-02, 1.7367172258E-02, 6.7943064983E-01],
	[2.1620000000E+04, 6.2164561216E-01, 1.7800064528E+00, 1.8059824646E-02, 1.7378624746E-02, 6.7950228584E-01],
	[2.1625000000E+04, 6.2185288438E-01, 1.7799098271E+00, 1.8072032852E-02, 1.7390081993E-02, 6.7957388804E-01],
	[2.1630000000E+04, 6.2206017777E-01, 1.7798132289E+00, 1.8084246485E-02, 1.7401543998E-02, 6.7964545643E-01],
	[2.1635000000E+04, 6.2226749232E-01, 1.7797166582E+00, 1.8096465547E-02, 1.7413010764E-02, 6.7971699103E-01],
	[2.1640000000E+04, 6.2247482804E-01, 1.7796201152E+00, 1.8108690039E-02, 1.7424482291E-02, 6.7978849185E-01],
	[2.1645000000E+04, 6.2268218491E-01, 1.7795235996E+00, 1.8120919961E-02, 1.7435958579E-02, 6.7985995890E-01],
	[2.1650000000E+04, 6.2288956294E-01, 1.7794271116E+00, 1.8133155315E-02, 1.7447439629E-02, 6.7993139218E-01],
	[2.1655000000E+04, 6.2309696213E-01, 1.7793306512E+00, 1.8145396103E-02, 1.7458925442E-02, 6.8000279171E-01],
	[2.1660000000E+04, 6.2330438246E-01, 1.7792342182E+00, 1.8157642324E-02, 1.7470416019E-02, 6.8007415751E-01],
	[2.1665000000E+04, 6.2351182394E-01, 1.7791378126E+00, 1.8169893982E-02, 1.7481911359E-02, 6.8014548957E-01],
	[2.1670000000E+04, 6.2371928657E-01, 1.7790414346E+00, 1.8182151075E-02, 1.7493411465E-02, 6.8021678792E-01],
	[2.1675000000E+04, 6.2392677034E-01, 1.7789450840E+00, 1.8194413607E-02, 1.7504916336E-02, 6.8028805256E-01],
	[2.1680000000E+04, 6.2413427525E-01, 1.7788487609E+00, 1.8206681577E-02, 1.7516425974E-02, 6.8035928350E-01],
	[2.1685000000E+04, 6.2434180129E-01, 1.7787524651E+00, 1.8218954988E-02, 1.7527940378E-02, 6.8043048076E-01],
	[2.1690000000E+04, 6.2454934848E-01, 1.7786561968E+00, 1.8231233840E-02, 1.7539459551E-02, 6.8050164434E-01],
	[2.1695000000E+04, 6.2475691679E-01, 1.7785599559E+00, 1.8243518134E-02, 1.7550983491E-02, 6.8057277426E-01],
	[2.1700000000E+04, 6.2496450623E-01, 1.7784637424E+00, 1.8255807872E-02, 1.7562512201E-02, 6.8064387052E-01],
	[2.1705000000E+04, 6.2517211680E-01, 1.7783675562E+00, 1.8268103054E-02, 1.7574045681E-02, 6.8071493315E-01],
	[2.1710000000E+04, 6.2537974849E-01, 1.7782713974E+00, 1.8280403682E-02, 1.7585583931E-02, 6.8078596214E-01],
	[2.1715000000E+04, 6.2558740130E-01, 1.7781752659E+00, 1.8292709758E-02, 1.7597126952E-02, 6.8085695752E-01],
	[2.1720000000E+04, 6.2579507523E-01, 1.7780791618E+00, 1.8305021281E-02, 1.7608674745E-02, 6.8092791928E-01],
	[2.1725000000E+04, 6.2600277028E-01, 1.7779830850E+00, 1.8317338254E-02, 1.7620227311E-02, 6.8099884745E-01],
	[2.1730000000E+04, 6.2621048644E-01, 1.7778870354E+00, 1.8329660677E-02, 1.7631784650E-02, 6.8106974203E-01],
	[2.1735000000E+04, 6.2641943884E-01, 1.7777927015E+00, 1.8341988552E-02, 1.7643347894E-02, 6.8114060303E-01],
	[2.1740000000E+04, 6.2662848949E-01, 1.7776985007E+00, 1.8354321880E-02, 1.7654915985E-02, 6.8121143047E-01],
	[2.1745000000E+04, 6.2683756180E-01, 1.7776043265E+00, 1.8366660662E-02, 1.7666488854E-02, 6.8128222435E-01],
	[2.1750000000E+04, 6.2704665578E-01, 1.7775101790E+00, 1.8379004898E-02, 1.7678066501E-02, 6.8135298469E-01],
	[2.1755000000E+04, 6.2725577142E-01, 1.7774160581E+00, 1.8391354591E-02, 1.7689648928E-02, 6.8142371150E-01],
	[2.1760000000E+04, 6.2746490872E-01, 1.7773219638E+00, 1.8403709742E-02, 1.7701236134E-02, 6.8149440478E-01],
	[2.1765000000E+04, 6.2767406768E-01, 1.7772278961E+00, 1.8416070351E-02, 1.7712828120E-02, 6.8156506456E-01],
	[2.1770000000E+04, 6.2788324828E-01, 1.7771338550E+00, 1.8428436420E-02, 1.7724424888E-02, 6.8163569084E-01],
	[2.1775000000E+04, 6.2809245054E-01, 1.7770398404E+00, 1.8440807950E-02, 1.7736026437E-02, 6.8170628363E-01],
	[2.1780000000E+04, 6.2830167445E-01, 1.7769458524E+00, 1.8453184942E-02, 1.7747632769E-02, 6.8177684294E-01],
	[2.1785000000E+04, 6.2851092000E-01, 1.7768518910E+00, 1.8465567397E-02, 1.7759243884E-02, 6.8184736879E-01],
	[2.1790000000E+04, 6.2872018719E-01, 1.7767579561E+00, 1.8477955316E-02, 1.7770859782E-02, 6.8191786118E-01],
	[2.1795000000E+04, 6.2892947603E-01, 1.7766640477E+00, 1.8490348701E-02, 1.7782480466E-02, 6.8198832013E-01],
	[2.1800000000E+04, 6.2913878650E-01, 1.7765701658E+00, 1.8502747553E-02, 1.7794105935E-02, 6.8205874564E-01],
	[2.1805000000E+04, 6.2934811860E-01, 1.7764763104E+00, 1.8515151872E-02, 1.7805736189E-02, 6.8212913774E-01],
	[2.1810000000E+04, 6.2955747234E-01, 1.7763824815E+00, 1.8527561660E-02, 1.7817371231E-02, 6.8219949642E-01],
	[2.1815000000E+04, 6.2976684770E-01, 1.7762886790E+00, 1.8539976919E-02, 1.7829011059E-02, 6.8226982171E-01],
	[2.1820000000E+04, 6.2997624469E-01, 1.7761949030E+00, 1.8552397649E-02, 1.7840655676E-02, 6.8234011361E-01],
	[2.1825000000E+04, 6.3018566330E-01, 1.7761011534E+00, 1.8564823851E-02, 1.7852305081E-02, 6.8241037213E-01],
	[2.1830000000E+04, 6.3039510353E-01, 1.7760074302E+00, 1.8577255527E-02, 1.7863959276E-02, 6.8248059728E-01],
	[2.1835000000E+04, 6.3060456538E-01, 1.7759137335E+00, 1.8589692678E-02, 1.7875618262E-02, 6.8255078908E-01],
	[2.1840000000E+04, 6.3081404885E-01, 1.7758200631E+00, 1.8602135305E-02, 1.7887282037E-02, 6.8262094754E-01],
	[2.1845000000E+04, 6.3102355393E-01, 1.7757264192E+00, 1.8614583409E-02, 1.7898950605E-02, 6.8269107267E-01],
	[2.1850000000E+04, 6.3123308061E-01, 1.7756328015E+00, 1.8627036991E-02, 1.7910623965E-02, 6.8276116447E-01],
	[2.1855000000E+04, 6.3144262891E-01, 1.7755392103E+00, 1.8639496052E-02, 1.7922302117E-02, 6.8283122297E-01],
	[2.1860000000E+04, 6.3165219881E-01, 1.7754456454E+00, 1.8651960594E-02, 1.7933985063E-02, 6.8290124816E-01],
	[2.1865000000E+04, 6.3186179030E-01, 1.7753521068E+00, 1.8664430618E-02, 1.7945672804E-02, 6.8297124007E-01],
	[2.1870000000E+04, 6.3207140340E-01, 1.7752585945E+00, 1.8676906125E-02, 1.7957365339E-02, 6.8304119871E-01],
	[2.1875000000E+04, 6.3228103810E-01, 1.7751651085E+00, 1.8689387116E-02, 1.7969062671E-02, 6.8311112408E-01],
	[2.1880000000E+04, 6.3249069438E-01, 1.7750716489E+00, 1.8701873591E-02, 1.7980764798E-02, 6.8318101620E-01],
	[2.1885000000E+04, 6.3270037226E-01, 1.7749782155E+00, 1.8714365554E-02, 1.7992471723E-02, 6.8325087507E-01],
	[2.1890000000E+04, 6.3291007173E-01, 1.7748848083E+00, 1.8726863003E-02, 1.8004183445E-02, 6.8332070072E-01],
	[2.1895000000E+04, 6.3311979278E-01, 1.7747914274E+00, 1.8739365942E-02, 1.8015899966E-02, 6.8339049314E-01],
	[2.1900000000E+04, 6.3332953541E-01, 1.7746980727E+00, 1.8751874370E-02, 1.8027621286E-02, 6.8346025236E-01],
	[2.1905000000E+04, 6.3353929962E-01, 1.7746047443E+00, 1.8764388289E-02, 1.8039347406E-02, 6.8352997838E-01],
	[2.1910000000E+04, 6.3374908541E-01, 1.7745114420E+00, 1.8776907700E-02, 1.8051078326E-02, 6.8359967122E-01],
	[2.1915000000E+04, 6.3395889277E-01, 1.7744181660E+00, 1.8789432605E-02, 1.8062814048E-02, 6.8366933088E-01],
	[2.1920000000E+04, 6.3416872171E-01, 1.7743249161E+00, 1.8801963004E-02, 1.8074554571E-02, 6.8373895738E-01],
	[2.1925000000E+04, 6.3437857221E-01, 1.7742316924E+00, 1.8814498899E-02, 1.8086299898E-02, 6.8380855073E-01],
	[2.1930000000E+04, 6.3458844428E-01, 1.7741384949E+00, 1.8827040290E-02, 1.8098050027E-02, 6.8387811094E-01],
	[2.1935000000E+04, 6.3479833792E-01, 1.7740453235E+00, 1.8839587179E-02, 1.8109804960E-02, 6.8394763802E-01],
	[2.1940000000E+04, 6.3500825311E-01, 1.7739521782E+00, 1.8852139568E-02, 1.8121564699E-02, 6.8401713198E-01],
	[2.1945000000E+04, 6.3521818986E-01, 1.7738590590E+00, 1.8864697456E-02, 1.8133329242E-02, 6.8408659284E-01],
	[2.1950000000E+04, 6.3542814817E-01, 1.7737659659E+00, 1.8877260846E-02, 1.8145098591E-02, 6.8415602061E-01],
	[2.1955000000E+04, 6.3563812803E-01, 1.7736728990E+00, 1.8889829739E-02, 1.8156872748E-02, 6.8422541529E-01],
	[2.1960000000E+04, 6.3584812944E-01, 1.7735798581E+00, 1.8902404135E-02, 1.8168651711E-02, 6.8429477690E-01],
	[2.1965000000E+04, 6.3605815240E-01, 1.7734868432E+00, 1.8914984036E-02, 1.8180435483E-02, 6.8436410545E-01],
	[2.1970000000E+04, 6.3626819690E-01, 1.7733938544E+00, 1.8927569443E-02, 1.8192224064E-02, 6.8443340095E-01],
	[2.1975000000E+04, 6.3647826295E-01, 1.7733008916E+00, 1.8940160357E-02, 1.8204017454E-02, 6.8450266342E-01],
	[2.1980000000E+04, 6.3668835053E-01, 1.7732079549E+00, 1.8952756779E-02, 1.8215815654E-02, 6.8457189286E-01],
	[2.1985000000E+04, 6.3689845965E-01, 1.7731150442E+00, 1.8965358711E-02, 1.8227618665E-02, 6.8464108929E-01],
	[2.1990000000E+04, 6.3710859030E-01, 1.7730221594E+00, 1.8977966154E-02, 1.8239426488E-02, 6.8471025271E-01],
	[2.1995000000E+04, 6.3731874249E-01, 1.7729293007E+00, 1.8990579108E-02, 1.8251239123E-02, 6.8477938315E-01],
	[2.2000000000E+04, 6.3752891620E-01, 1.7728364679E+00, 1.9003197576E-02, 1.8263056571E-02, 6.8484848060E-01],
	[2.2005000000E+04, 6.3773911144E-01, 1.7727436610E+00, 1.9015821557E-02, 1.8274878832E-02, 6.8491754509E-01],
	[2.2010000000E+04, 6.3794932820E-01, 1.7726508802E+00, 1.9028451054E-02, 1.8286705908E-02, 6.8498657662E-01],
	[2.2015000000E+04, 6.3815956648E-01, 1.7725581252E+00, 1.9041086067E-02, 1.8298537799E-02, 6.8505557521E-01],
	[2.2020000000E+04, 6.3836982628E-01, 1.7724653961E+00, 1.9053726597E-02, 1.8310374505E-02, 6.8512454086E-01],
	[2.2025000000E+04, 6.3858010760E-01, 1.7723726930E+00, 1.9066372646E-02, 1.8322216028E-02, 6.8519347360E-01],
	[2.2030000000E+04, 6.3879041042E-01, 1.7722800157E+00, 1.9079024216E-02, 1.8334062368E-02, 6.8526237342E-01],
	[2.2035000000E+04, 6.3900073476E-01, 1.7721873644E+00, 1.9091681306E-02, 1.8345913526E-02, 6.8533124034E-01],
	[2.2040000000E+04, 6.3921108060E-01, 1.7720947388E+00, 1.9104343918E-02, 1.8357769502E-02, 6.8540007438E-01],
	[2.2045000000E+04, 6.3942144795E-01, 1.7720021392E+00, 1.9117012054E-02, 1.8369630297E-02, 6.8546887555E-01],
	[2.2050000000E+04, 6.3963183680E-01, 1.7719095653E+00, 1.9129685714E-02, 1.8381495912E-02, 6.8553764385E-01],
	[2.2055000000E+04, 6.3984224715E-01, 1.7718170173E+00, 1.9142364900E-02, 1.8393366347E-02, 6.8560637929E-01],
	[2.2060000000E+04, 6.4005267899E-01, 1.7717244951E+00, 1.9155049613E-02, 1.8405241603E-02, 6.8567508190E-01],
	[2.2065000000E+04, 6.4026313233E-01, 1.7716319987E+00, 1.9167739853E-02, 1.8417121682E-02, 6.8574375168E-01],
	[2.2070000000E+04, 6.4047360716E-01, 1.7715395281E+00, 1.9180435623E-02, 1.8429006583E-02, 6.8581238864E-01],
	[2.2075000000E+04, 6.4068410347E-01, 1.7714470833E+00, 1.9193136923E-02, 1.8440896307E-02, 6.8588099280E-01],
	[2.2080000000E+04, 6.4089462128E-01, 1.7713546642E+00, 1.9205843755E-02, 1.8452790855E-02, 6.8594956416E-01],
	[2.2085000000E+04, 6.4110643604E-01, 1.7712639791E+00, 1.9218556119E-02, 1.8464691471E-02, 6.8601810275E-01],
	[2.2090000000E+04, 6.4131830547E-01, 1.7711733629E+00, 1.9231274016E-02, 1.8476596946E-02, 6.8608660856E-01],
	[2.2095000000E+04, 6.4153019694E-01, 1.7710827718E+00, 1.9243997449E-02, 1.8488507250E-02, 6.8615508161E-01],
	[2.2100000000E+04, 6.4174211044E-01, 1.7709922058E+00, 1.9256726418E-02, 1.8500422383E-02, 6.8622352192E-01],
	[2.2105000000E+04, 6.4195404599E-01, 1.7709016650E+00, 1.9269460924E-02, 1.8512342345E-02, 6.8629192949E-01],
	[2.2110000000E+04, 6.4216600357E-01, 1.7708111493E+00, 1.9282200968E-02, 1.8524267138E-02, 6.8636030434E-01],
	[2.2115000000E+04, 6.4237798318E-01, 1.7707206586E+00, 1.9294946552E-02, 1.8536196761E-02, 6.8642864648E-01],
	[2.2120000000E+04, 6.4258998482E-01, 1.7706301930E+00, 1.9307697676E-02, 1.8548131216E-02, 6.8649695591E-01],
	[2.2125000000E+04, 6.4280200849E-01, 1.7705397525E+00, 1.9320454343E-02, 1.8560070504E-02, 6.8656523266E-01],
	[2.2130000000E+04, 6.4301405419E-01, 1.7704493371E+00, 1.9333216552E-02, 1.8572014625E-02, 6.8663347673E-01],
	[2.2135000000E+04, 6.4322612190E-01, 1.7703589467E+00, 1.9345984305E-02, 1.8583963579E-02, 6.8670168814E-01],
	[2.2140000000E+04, 6.4343821164E-01, 1.7702685813E+00, 1.9358757604E-02, 1.8595917367E-02, 6.8676986690E-01],
	[2.2145000000E+04, 6.4365032339E-01, 1.7701782409E+00, 1.9371536449E-02, 1.8607875991E-02, 6.8683801301E-01],
	[2.2150000000E+04, 6.4386245715E-01, 1.7700879256E+00, 1.9384320842E-02, 1.8619839451E-02, 6.8690612650E-01],
	[2.2155000000E+04, 6.4407461293E-01, 1.7699976352E+00, 1.9397110783E-02, 1.8631807747E-02, 6.8697420737E-01],
	[2.2160000000E+04, 6.4428679071E-01, 1.7699073698E+00, 1.9409906275E-02, 1.8643780880E-02, 6.8704225563E-01],
	[2.2165000000E+04, 6.4449899050E-01, 1.7698171294E+00, 1.9422707317E-02, 1.8655758851E-02, 6.8711027130E-01],
	[2.2170000000E+04, 6.4471121229E-01, 1.7697269139E+00, 1.9435513912E-02, 1.8667741660E-02, 6.8717825439E-01],
	[2.2175000000E+04, 6.4492345608E-01, 1.7696367234E+00, 1.9448326060E-02, 1.8679729308E-02, 6.8724620490E-01],
	[2.2180000000E+04, 6.4513572187E-01, 1.7695465578E+00, 1.9461143763E-02, 1.8691721797E-02, 6.8731412286E-01],
	[2.2185000000E+04, 6.4534800965E-01, 1.7694564171E+00, 1.9473967021E-02, 1.8703719126E-02, 6.8738200827E-01],
	[2.2190000000E+04, 6.4556031943E-01, 1.7693663014E+00, 1.9486795836E-02, 1.8715721296E-02, 6.8744986115E-01],
	[2.2195000000E+04, 6.4577265120E-01, 1.7692762105E+00, 1.9499630210E-02, 1.8727728308E-02, 6.8751768151E-01],
	[2.2200000000E+04, 6.4598500495E-01, 1.7691861445E+00, 1.9512470142E-02, 1.8739740162E-02, 6.8758546935E-01],
	[2.2205000000E+04, 6.4619738068E-01, 1.7690961033E+00, 1.9525315635E-02, 1.8751756860E-02, 6.8765322470E-01],
	[2.2210000000E+04, 6.4640977840E-01, 1.7690060870E+00, 1.9538166689E-02, 1.8763778401E-02, 6.8772094755E-01],
	[2.2215000000E+04, 6.4662219810E-01, 1.7689160956E+00, 1.9551023305E-02, 1.8775804788E-02, 6.8778863794E-01],
	[2.2220000000E+04, 6.4683463977E-01, 1.7688261290E+00, 1.9563885486E-02, 1.8787836019E-02, 6.8785629586E-01],
	[2.2225000000E+04, 6.4704710342E-01, 1.7687361872E+00, 1.9576753231E-02, 1.8799872097E-02, 6.8792392133E-01],
	[2.2230000000E+04, 6.4725958903E-01, 1.7686462702E+00, 1.9589626543E-02, 1.8811913021E-02, 6.8799151436E-01],
	[2.2235000000E+04, 6.4747209662E-01, 1.7685563780E+00, 1.9602505422E-02, 1.8823958792E-02, 6.8805907496E-01],
	[2.2240000000E+04, 6.4768462617E-01, 1.7684665105E+00, 1.9615389869E-02, 1.8836009411E-02, 6.8812660315E-01],
	[2.2245000000E+04, 6.4789717768E-01, 1.7683766679E+00, 1.9628279885E-02, 1.8848064880E-02, 6.8819409893E-01],
	[2.2250000000E+04, 6.4810975115E-01, 1.7682868500E+00, 1.9641175473E-02, 1.8860125197E-02, 6.8826156232E-01],
	[2.2255000000E+04, 6.4832234658E-01, 1.7681970568E+00, 1.9654076632E-02, 1.8872190364E-02, 6.8832899333E-01],
	[2.2260000000E+04, 6.4853496397E-01, 1.7681072884E+00, 1.9666983364E-02, 1.8884260382E-02, 6.8839639198E-01],
	[2.2265000000E+04, 6.4874760331E-01, 1.7680175447E+00, 1.9679895671E-02, 1.8896335252E-02, 6.8846375827E-01],
	[2.2270000000E+04, 6.4896026459E-01, 1.7679278256E+00, 1.9692813553E-02, 1.8908414973E-02, 6.8853109221E-01],
	[2.2275000000E+04, 6.4917294783E-01, 1.7678381313E+00, 1.9705737011E-02, 1.8920499548E-02, 6.8859839383E-01],
	[2.2280000000E+04, 6.4938565300E-01, 1.7677484617E+00, 1.9718666047E-02, 1.8932588975E-02, 6.8866566312E-01],
	[2.2285000000E+04, 6.4959838012E-01, 1.7676588167E+00, 1.9731600661E-02, 1.8944683257E-02, 6.8873290011E-01],
	[2.2290000000E+04, 6.4981112918E-01, 1.7675691964E+00, 1.9744540856E-02, 1.8956782393E-02, 6.8880010480E-01],
	[2.2295000000E+04, 6.5002390017E-01, 1.7674796007E+00, 1.9757486632E-02, 1.8968886385E-02, 6.8886727721E-01],
	[2.2300000000E+04, 6.5023669310E-01, 1.7673900297E+00, 1.9770437990E-02, 1.8980995233E-02, 6.8893441734E-01],
	[2.2305000000E+04, 6.5044950796E-01, 1.7673004833E+00, 1.9783394931E-02, 1.8993108938E-02, 6.8900152522E-01],
	[2.2310000000E+04, 6.5066234474E-01, 1.7672109614E+00, 1.9796357457E-02, 1.9005227500E-02, 6.8906860085E-01],
	[2.2315000000E+04, 6.5087520345E-01, 1.7671214642E+00, 1.9809325569E-02, 1.9017350920E-02, 6.8913564424E-01],
	[2.2320000000E+04, 6.5108808409E-01, 1.7670319916E+00, 1.9822299267E-02, 1.9029479200E-02, 6.8920265541E-01],
	[2.2325000000E+04, 6.5130098664E-01, 1.7669425435E+00, 1.9835278554E-02, 1.9041612338E-02, 6.8926963437E-01],
	[2.2330000000E+04, 6.5151391111E-01, 1.7668531200E+00, 1.9848263430E-02, 1.9053750337E-02, 6.8933658113E-01],
	[2.2335000000E+04, 6.5172685750E-01, 1.7667637210E+00, 1.9861253896E-02, 1.9065893196E-02, 6.8940349570E-01],
	[2.2340000000E+04, 6.5193982580E-01, 1.7666743466E+00, 1.9874249953E-02, 1.9078040917E-02, 6.8947037810E-01],
	[2.2345000000E+04, 6.5215281601E-01, 1.7665849967E+00, 1.9887251603E-02, 1.9090193500E-02, 6.8953722833E-01],
	[2.2350000000E+04, 6.5236582812E-01, 1.7664956713E+00, 1.9900258847E-02, 1.9102350946E-02, 6.8960404642E-01],
	[2.2355000000E+04, 6.5257886214E-01, 1.7664063704E+00, 1.9913271686E-02, 1.9114513256E-02, 6.8967083236E-01],
	[2.2360000000E+04, 6.5279191806E-01, 1.7663170939E+00, 1.9926290121E-02, 1.9126680430E-02, 6.8973758618E-01],
	[2.2365000000E+04, 6.5300499588E-01, 1.7662278420E+00, 1.9939446738E-02, 1.9138974621E-02, 6.8980430788E-01],
	[2.2370000000E+04, 6.5321809560E-01, 1.7661386145E+00, 1.9952630694E-02, 1.9151293699E-02, 6.8987099749E-01],
	[2.2375000000E+04, 6.5343121721E-01, 1.7660494114E+00, 1.9965820417E-02, 1.9163617788E-02, 6.8993765500E-01],
	[2.2380000000E+04, 6.5364436071E-01, 1.7659602328E+00, 1.9979015910E-02, 1.9175946889E-02, 6.9000428043E-01],
	[2.2385000000E+04, 6.5385752609E-01, 1.7658710786E+00, 1.9992217173E-02, 1.9188281003E-02, 6.9007087380E-01],
	[2.2390000000E+04, 6.5407071337E-01, 1.7657819488E+00, 2.0005424207E-02, 1.9200620130E-02, 6.9013743511E-01],
	[2.2395000000E+04, 6.5428392253E-01, 1.7656928435E+00, 2.0018637014E-02, 1.9212964271E-02, 6.9020396439E-01],
	[2.2400000000E+04, 6.5449715357E-01, 1.7656037625E+00, 2.0031855595E-02, 1.9225313428E-02, 6.9027046163E-01],
	[2.2405000000E+04, 6.5471040648E-01, 1.7655147059E+00, 2.0045079951E-02, 1.9237667600E-02, 6.9033692685E-01],
	[2.2410000000E+04, 6.5492368127E-01, 1.7654256736E+00, 2.0058310084E-02, 1.9250026788E-02, 6.9040336008E-01],
	[2.2415000000E+04, 6.5513697794E-01, 1.7653366657E+00, 2.0071545995E-02, 1.9262390994E-02, 6.9046976130E-01],
	[2.2420000000E+04, 6.5535029647E-01, 1.7652476821E+00, 2.0084787684E-02, 1.9274760217E-02, 6.9053613055E-01],
	[2.2425000000E+04, 6.5556363687E-01, 1.7651587229E+00, 2.0098035154E-02, 1.9287134459E-02, 6.9060246783E-01],
	[2.2430000000E+04, 6.5577699914E-01, 1.7650697880E+00, 2.0111288405E-02, 1.9299513721E-02, 6.9066877315E-01],
	[2.2435000000E+04, 6.5599038326E-01, 1.7649808773E+00, 2.0124547438E-02, 1.9311898002E-02, 6.9073504653E-01],
	[2.2440000000E+04, 6.5620495914E-01, 1.7648935013E+00, 2.0137812256E-02, 1.9324288500E-02, 6.9080128798E-01],
	[2.2445000000E+04, 6.5641971232E-01, 1.7648063490E+00, 2.0151082859E-02, 1.9336684179E-02, 6.9086749751E-01],
	[2.2450000000E+04, 6.5663448792E-01, 1.7647192204E+00, 2.0164359248E-02, 1.9349084883E-02, 6.9093367513E-01],
	[2.2455000000E+04, 6.5684928594E-01, 1.7646321156E+00, 2.0177641424E-02, 1.9361490613E-02, 6.9099982086E-01],
	[2.2460000000E+04, 6.5706410637E-01, 1.7645450344E+00, 2.0190929390E-02, 1.9373901369E-02, 6.9106593470E-01],
	[2.2465000000E+04, 6.5727894922E-01, 1.7644579769E+00, 2.0204223145E-02, 1.9386317151E-02, 6.9113201667E-01],
	[2.2470000000E+04, 6.5749381449E-01, 1.7643709430E+00, 2.0217522692E-02, 1.9398737961E-02, 6.9119806679E-01],
	[2.2475000000E+04, 6.5770870216E-01, 1.7642839328E+00, 2.0230828031E-02, 1.9411163799E-02, 6.9126408505E-01],
	[2.2480000000E+04, 6.5792361225E-01, 1.7641969463E+00, 2.0244139164E-02, 1.9423594666E-02, 6.9133007149E-01],
	[2.2485000000E+04, 6.5813854473E-01, 1.7641099834E+00, 2.0257456092E-02, 1.9436030563E-02, 6.9139602610E-01],
	[2.2490000000E+04, 6.5835349962E-01, 1.7640230441E+00, 2.0270778816E-02, 1.9448471490E-02, 6.9146194891E-01],
	[2.2495000000E+04, 6.5856847691E-01, 1.7639361284E+00, 2.0284107338E-02, 1.9460917449E-02, 6.9152783992E-01],
	[2.2500000000E+04, 6.5878347659E-01, 1.7638492364E+00, 2.0297441658E-02, 1.9473368439E-02, 6.9159369914E-01],
	[2.2505000000E+04, 6.5899849867E-01, 1.7637623679E+00, 2.0310781778E-02, 1.9485824461E-02, 6.9165952659E-01],
	[2.2510000000E+04, 6.5921354314E-01, 1.7636755230E+00, 2.0324127699E-02, 1.9498285517E-02, 6.9172532228E-01],
	[2.2515000000E+04, 6.5942861000E-01, 1.7635887016E+00, 2.0337479423E-02, 1.9510751607E-02, 6.9179108623E-01],
	[2.2520000000E+04, 6.5964369925E-01, 1.7635019038E+00, 2.0350836950E-02, 1.9523222732E-02, 6.9185681844E-01],
	[2.2525000000E+04, 6.5985881088E-01, 1.7634151295E+00, 2.0364200283E-02, 1.9535698892E-02, 6.9192251892E-01],
	[2.2530000000E+04, 6.6007394489E-01, 1.7633283788E+00, 2.0377569421E-02, 1.9548180088E-02, 6.9198818770E-01],
	[2.2535000000E+04, 6.6028910128E-01, 1.7632416516E+00, 2.0390944366E-02, 1.9560666321E-02, 6.9205382478E-01],
	[2.2540000000E+04, 6.6050428004E-01, 1.7631549479E+00, 2.0404325120E-02, 1.9573157592E-02, 6.9211943017E-01],
	[2.2545000000E+04, 6.6071948118E-01, 1.7630682677E+00, 2.0417711684E-02, 1.9585653900E-02, 6.9218500389E-01],
	[2.2550000000E+04, 6.6093470468E-01, 1.7629816109E+00, 2.0431104059E-02, 1.9598155248E-02, 6.9225054595E-01],
	[2.2555000000E+04, 6.6114995056E-01, 1.7628949777E+00, 2.0444502246E-02, 1.9610661636E-02, 6.9231605636E-01],
	[2.2560000000E+04, 6.6136521880E-01, 1.7628083678E+00, 2.0457906247E-02, 1.9623173064E-02, 6.9238153513E-01],
	[2.2565000000E+04, 6.6158050940E-01, 1.7627217815E+00, 2.0471316062E-02, 1.9635689534E-02, 6.9244698228E-01],
	[2.2570000000E+04, 6.6179582236E-01, 1.7626352186E+00, 2.0484731693E-02, 1.9648211045E-02, 6.9251239782E-01],
	[2.2575000000E+04, 6.6201115768E-01, 1.7625486791E+00, 2.0498153142E-02, 1.9660737599E-02, 6.9257778176E-01],
	[2.2580000000E+04, 6.6222651536E-01, 1.7624621630E+00, 2.0511580409E-02, 1.9673269196E-02, 6.9264313411E-01],
	[2.2585000000E+04, 6.6244189538E-01, 1.7623756703E+00, 2.0525013495E-02, 1.9685805837E-02, 6.9270845489E-01],
	[2.2590000000E+04, 6.6265729776E-01, 1.7622892010E+00, 2.0538452402E-02, 1.9698347523E-02, 6.9277374410E-01],
	[2.2595000000E+04, 6.6287272248E-01, 1.7622027551E+00, 2.0551897132E-02, 1.9710894254E-02, 6.9283900177E-01],
	[2.2600000000E+04, 6.6308816955E-01, 1.7621163325E+00, 2.0565347685E-02, 1.9723446032E-02, 6.9290422790E-01],
	[2.2605000000E+04, 6.6330363895E-01, 1.7620299333E+00, 2.0578804062E-02, 1.9736002857E-02, 6.9296942251E-01],
	[2.2610000000E+04, 6.6351913070E-01, 1.7619435574E+00, 2.0592266265E-02, 1.9748564729E-02, 6.9303458560E-01],
	[2.2615000000E+04, 6.6373464478E-01, 1.7618572049E+00, 2.0605734295E-02, 1.9761131649E-02, 6.9309971719E-01],
	[2.2620000000E+04, 6.6395018120E-01, 1.7617708757E+00, 2.0619208154E-02, 1.9773703619E-02, 6.9316481730E-01],
	[2.2625000000E+04, 6.6416573994E-01, 1.7616845698E+00, 2.0632687842E-02, 1.9786280638E-02, 6.9322988593E-01],
	[2.2630000000E+04, 6.6438132102E-01, 1.7615982872E+00, 2.0646173361E-02, 1.9798862708E-02, 6.9329492310E-01],
	[2.2635000000E+04, 6.6459692442E-01, 1.7615120279E+00, 2.0659664711E-02, 1.9811449829E-02, 6.9335992882E-01],
	[2.2640000000E+04, 6.6481255014E-01, 1.7614257919E+00, 2.0673161895E-02, 1.9824042001E-02, 6.9342490310E-01],
	[2.2645000000E+04, 6.6502819819E-01, 1.7613395791E+00, 2.0686664913E-02, 1.9836639227E-02, 6.9348984596E-01],
	[2.2650000000E+04, 6.6524386855E-01, 1.7612533896E+00, 2.0700173768E-02, 1.9849241506E-02, 6.9355475741E-01],
	[2.2655000000E+04, 6.6545956123E-01, 1.7611672233E+00, 2.0713688458E-02, 1.9861848839E-02, 6.9361963745E-01],
	[2.2660000000E+04, 6.6567527622E-01, 1.7610810802E+00, 2.0727208987E-02, 1.9874461226E-02, 6.9368448611E-01],
	[2.2665000000E+04, 6.6589101352E-01, 1.7609949604E+00, 2.0740735356E-02, 1.9887078669E-02, 6.9374930340E-01],
	[2.2670000000E+04, 6.6610677312E-01, 1.7609088638E+00, 2.0754267565E-02, 1.9899701169E-02, 6.9381408932E-01],
	[2.2675000000E+04, 6.6632255504E-01, 1.7608227903E+00, 2.0767805616E-02, 1.9912328725E-02, 6.9387884389E-01],
	[2.2680000000E+04, 6.6653835925E-01, 1.7607367401E+00, 2.0781349510E-02, 1.9924961339E-02, 6.9394356712E-01],
	[2.2685000000E+04, 6.6675418576E-01, 1.7606507130E+00, 2.0794899248E-02, 1.9937599011E-02, 6.9400825903E-01],
	[2.2690000000E+04, 6.6697003457E-01, 1.7605647091E+00, 2.0808454832E-02, 1.9950241742E-02, 6.9407291963E-01],
	[2.2695000000E+04, 6.6718590568E-01, 1.7604787283E+00, 2.0822016262E-02, 1.9962889533E-02, 6.9413754893E-01],
	[2.2700000000E+04, 6.6740179908E-01, 1.7603927707E+00, 2.0835583541E-02, 1.9975542384E-02, 6.9420214694E-01],
	[2.2705000000E+04, 6.6761771476E-01, 1.7603068362E+00, 2.0849156669E-02, 1.9988200296E-02, 6.9426671367E-01],
	[2.2710000000E+04, 6.6783365273E-01, 1.7602209248E+00, 2.0862735647E-02, 2.0000863271E-02, 6.9433124915E-01],
	[2.2715000000E+04, 6.6804961299E-01, 1.7601350365E+00, 2.0876320477E-02, 2.0013531308E-02, 6.9439575337E-01],
	[2.2720000000E+04, 6.6826559553E-01, 1.7600491713E+00, 2.0889911160E-02, 2.0026204408E-02, 6.9446022636E-01],
	[2.2725000000E+04, 6.6848160034E-01, 1.7599633292E+00, 2.0903507697E-02, 2.0038882572E-02, 6.9452466812E-01],
	[2.2730000000E+04, 6.6869762743E-01, 1.7598775102E+00, 2.0917110089E-02, 2.0051565801E-02, 6.9458907867E-01],
	[2.2735000000E+04, 6.6891367680E-01, 1.7597917142E+00, 2.0930718338E-02, 2.0064254095E-02, 6.9465345803E-01],
	[2.2740000000E+04, 6.6912974844E-01, 1.7597059413E+00, 2.0944332445E-02, 2.0076947456E-02, 6.9471780619E-01],
	[2.2745000000E+04, 6.6934584234E-01, 1.7596201914E+00, 2.0957952411E-02, 2.0089645883E-02, 6.9478212318E-01],
	[2.2750000000E+04, 6.6956195851E-01, 1.7595344645E+00, 2.0971578238E-02, 2.0102349378E-02, 6.9484640901E-01],
	[2.2755000000E+04, 6.6977809694E-01, 1.7594487607E+00, 2.0985209925E-02, 2.0115057941E-02, 6.9491066369E-01],
	[2.2760000000E+04, 6.6999425764E-01, 1.7593630798E+00, 2.0998847476E-02, 2.0127771573E-02, 6.9497488724E-01],
	[2.2765000000E+04, 6.7021044059E-01, 1.7592774219E+00, 2.1012490891E-02, 2.0140490274E-02, 6.9503907966E-01],
	[2.2770000000E+04, 6.7042664579E-01, 1.7591917871E+00, 2.1026140171E-02, 2.0153214046E-02, 6.9510324097E-01],
	[2.2775000000E+04, 6.7064287325E-01, 1.7591061751E+00, 2.1039795317E-02, 2.0165942890E-02, 6.9516737118E-01],
	[2.2780000000E+04, 6.7085912296E-01, 1.7590205862E+00, 2.1053456332E-02, 2.0178676804E-02, 6.9523147030E-01],
	[2.2785000000E+04, 6.7107539492E-01, 1.7589350202E+00, 2.1067123215E-02, 2.0191415792E-02, 6.9529553835E-01],
	[2.2790000000E+04, 6.7129168912E-01, 1.7588494771E+00, 2.1080795968E-02, 2.0204159852E-02, 6.9535957535E-01],
	[2.2795000000E+04, 6.7150800556E-01, 1.7587639570E+00, 2.1094474593E-02, 2.0216908987E-02, 6.9542358129E-01],
	[2.2800000000E+04, 6.7172521187E-01, 1.7586795394E+00, 2.1108159090E-02, 2.0229664126E-02, 6.9548755620E-01],
	[2.2805000000E+04, 6.7194291508E-01, 1.7585957344E+00, 2.1121849462E-02, 2.0242424850E-02, 6.9555150008E-01],
	[2.2810000000E+04, 6.7216064110E-01, 1.7585119517E+00, 2.1135545708E-02, 2.0255190653E-02, 6.9561541296E-01],
	[2.2815000000E+04, 6.7237838992E-01, 1.7584281914E+00, 2.1149247831E-02, 2.0267961536E-02, 6.9567929484E-01],
	[2.2820000000E+04, 6.7259616155E-01, 1.7583444534E+00, 2.1162955831E-02, 2.0280737498E-02, 6.9574314573E-01],
	[2.2825000000E+04, 6.7281395597E-01, 1.7582607378E+00, 2.1176669711E-02, 2.0293518541E-02, 6.9580696565E-01],
	[2.2830000000E+04, 6.7303177319E-01, 1.7581770445E+00, 2.1190389470E-02, 2.0306304665E-02, 6.9587075461E-01],
	[2.2835000000E+04, 6.7324961321E-01, 1.7580933735E+00, 2.1204115110E-02, 2.0319095871E-02, 6.9593451263E-01],
	[2.2840000000E+04, 6.7346747602E-01, 1.7580097248E+00, 2.1217846633E-02, 2.0331892161E-02, 6.9599823971E-01],
	[2.2845000000E+04, 6.7368536161E-01, 1.7579260984E+00, 2.1231584040E-02, 2.0344693533E-02, 6.9606193587E-01],
	[2.2850000000E+04, 6.7390326999E-01, 1.7578424942E+00, 2.1245327332E-02, 2.0357499990E-02, 6.9612560112E-01],
	[2.2855000000E+04, 6.7412120116E-01, 1.7577589123E+00, 2.1259076510E-02, 2.0370311532E-02, 6.9618923547E-01],
	[2.2860000000E+04, 6.7433915511E-01, 1.7576753527E+00, 2.1272831575E-02, 2.0383128160E-02, 6.9625283894E-01],
	[2.2865000000E+04, 6.7455713183E-01, 1.7575918154E+00, 2.1286592530E-02, 2.0395949874E-02, 6.9631641154E-01],
	[2.2870000000E+04, 6.7477513133E-01, 1.7575083002E+00, 2.1300359374E-02, 2.0408776675E-02, 6.9637995329E-01],
	[2.2875000000E+04, 6.7499315361E-01, 1.7574248073E+00, 2.1314132109E-02, 2.0421608563E-02, 6.9644346419E-01],
	[2.2880000000E+04, 6.7521119865E-01, 1.7573413366E+00, 2.1327910736E-02, 2.0434445540E-02, 6.9650694425E-01],
	[2.2885000000E+04, 6.7542926647E-01, 1.7572578881E+00, 2.1341695258E-02, 2.0447287607E-02, 6.9657039350E-01],
	[2.2890000000E+04, 6.7564735705E-01, 1.7571744618E+00, 2.1355485674E-02, 2.0460134763E-02, 6.9663381193E-01],
	[2.2895000000E+04, 6.7586547039E-01, 1.7570910577E+00, 2.1369281986E-02, 2.0472987009E-02, 6.9669719958E-01],
	[2.2900000000E+04, 6.7608360649E-01, 1.7570076757E+00, 2.1383084195E-02, 2.0485844347E-02, 6.9676055644E-01],
	[2.2905000000E+04, 6.7630176535E-01, 1.7569243159E+00, 2.1396892303E-02, 2.0498706777E-02, 6.9682388253E-01],
	[2.2910000000E+04, 6.7651994697E-01, 1.7568409783E+00, 2.1410706311E-02, 2.0511574299E-02, 6.9688717787E-01],
	[2.2915000000E+04, 6.7673815134E-01, 1.7567576628E+00, 2.1424526219E-02, 2.0524446915E-02, 6.9695044247E-01],
	[2.2920000000E+04, 6.7695637846E-01, 1.7566743694E+00, 2.1438352030E-02, 2.0537324625E-02, 6.9701367633E-01],
	[2.2925000000E+04, 6.7717462832E-01, 1.7565910981E+00, 2.1452183745E-02, 2.0550207430E-02, 6.9707687947E-01],
	[2.2930000000E+04, 6.7739290093E-01, 1.7565078490E+00, 2.1466021364E-02, 2.0563095330E-02, 6.9714005191E-01],
	[2.2935000000E+04, 6.7761119628E-01, 1.7564246219E+00, 2.1479864889E-02, 2.0575988327E-02, 6.9720319366E-01],
	[2.2940000000E+04, 6.7782951438E-01, 1.7563414169E+00, 2.1493714321E-02, 2.0588886420E-02, 6.9726630473E-01],
	[2.2945000000E+04, 6.7804785521E-01, 1.7562582340E+00, 2.1507569662E-02, 2.0601789611E-02, 6.9732938513E-01],
	[2.2950000000E+04, 6.7826621877E-01, 1.7561750732E+00, 2.1521430912E-02, 2.0614697900E-02, 6.9739243488E-01],
	[2.2955000000E+04, 6.7848460506E-01, 1.7560919344E+00, 2.1535298073E-02, 2.0627611288E-02, 6.9745545398E-01],
	[2.2960000000E+04, 6.7870301409E-01, 1.7560088176E+00, 2.1549171146E-02, 2.0640529775E-02, 6.9751844246E-01],
	[2.2965000000E+04, 6.7892144584E-01, 1.7559257229E+00, 2.1563050132E-02, 2.0653453363E-02, 6.9758140032E-01],
	[2.2970000000E+04, 6.7913990032E-01, 1.7558426502E+00, 2.1576935034E-02, 2.0666382053E-02, 6.9764432758E-01],
	[2.2975000000E+04, 6.7935837751E-01, 1.7557595995E+00, 2.1590825850E-02, 2.0679315844E-02, 6.9770722425E-01],
	[2.2980000000E+04, 6.7957687743E-01, 1.7556765708E+00, 2.1604722584E-02, 2.0692254737E-02, 6.9777009034E-01],
	[2.2985000000E+04, 6.7979540006E-01, 1.7555935641E+00, 2.1618625236E-02, 2.0705198734E-02, 6.9783292586E-01],
	[2.2990000000E+04, 6.8001394541E-01, 1.7555105794E+00, 2.1632533808E-02, 2.0718147834E-02, 6.9789573084E-01],
	[2.2995000000E+04, 6.8023251347E-01, 1.7554276167E+00, 2.1646448300E-02, 2.0731102039E-02, 6.9795850527E-01],
	[2.3000000000E+04, 6.8045110423E-01, 1.7553446759E+00, 2.1660368715E-02, 2.0744061349E-02, 6.9802124918E-01],
	[2.3005000000E+04, 6.8066971771E-01, 1.7552617570E+00, 2.1674295052E-02, 2.0757025765E-02, 6.9808396258E-01],
	[2.3010000000E+04, 6.8088835388E-01, 1.7551788601E+00, 2.1688227314E-02, 2.0769995288E-02, 6.9814664547E-01],
	[2.3015000000E+04, 6.8110701276E-01, 1.7550959851E+00, 2.1702165502E-02, 2.0782969918E-02, 6.9820929788E-01],
	[2.3020000000E+04, 6.8132569433E-01, 1.7550131320E+00, 2.1716109616E-02, 2.0795949657E-02, 6.9827191981E-01],
	[2.3025000000E+04, 6.8154439860E-01, 1.7549303008E+00, 2.1730059658E-02, 2.0808934504E-02, 6.9833451128E-01],
	[2.3030000000E+04, 6.8176312557E-01, 1.7548474916E+00, 2.1744015630E-02, 2.0821924460E-02, 6.9839707230E-01],
	[2.3035000000E+04, 6.8198187522E-01, 1.7547647042E+00, 2.1757977533E-02, 2.0834919527E-02, 6.9845960288E-01],
	[2.3040000000E+04, 6.8220064756E-01, 1.7546819386E+00, 2.1771945367E-02, 2.0847919704E-02, 6.9852210304E-01],
	[2.3045000000E+04, 6.8241944259E-01, 1.7545991950E+00, 2.1785919134E-02, 2.0860924993E-02, 6.9858457279E-01],
	[2.3050000000E+04, 6.8263826030E-01, 1.7545164732E+00, 2.1799898836E-02, 2.0873935394E-02, 6.9864701214E-01],
	[2.3055000000E+04, 6.8285710069E-01, 1.7544337732E+00, 2.1813884473E-02, 2.0886950908E-02, 6.9870942111E-01],
	[2.3060000000E+04, 6.8307596376E-01, 1.7543510950E+00, 2.1827876047E-02, 2.0899971536E-02, 6.9877179970E-01],
	[2.3065000000E+04, 6.8329484951E-01, 1.7542684387E+00, 2.1841873558E-02, 2.0912997278E-02, 6.9883414792E-01],
	[2.3070000000E+04, 6.8351375792E-01, 1.7541858042E+00, 2.1855877009E-02, 2.0926028135E-02, 6.9889646579E-01],
	[2.3075000000E+04, 6.8373268901E-01, 1.7541031915E+00, 2.1869886401E-02, 2.0939064108E-02, 6.9895875331E-01],
	[2.3080000000E+04, 6.8395164276E-01, 1.7540206006E+00, 2.1883901734E-02, 2.0952105197E-02, 6.9902101050E-01],
	[2.3085000000E+04, 6.8417061918E-01, 1.7539380314E+00, 2.1897923010E-02, 2.0965151403E-02, 6.9908323737E-01],
	[2.3090000000E+04, 6.8438961826E-01, 1.7538554840E+00, 2.1911950230E-02, 2.0978202727E-02, 6.9914543392E-01],
	[2.3095000000E+04, 6.8460864000E-01, 1.7537729584E+00, 2.1925983395E-02, 2.0991259170E-02, 6.9920760016E-01],
	[2.3100000000E+04, 6.8482768440E-01, 1.7536904545E+00, 2.1940022507E-02, 2.1004320731E-02, 6.9926973612E-01],
	[2.3105000000E+04, 6.8504675146E-01, 1.7536079724E+00, 2.1954067567E-02, 2.1017387413E-02, 6.9933184179E-01],
	[2.3110000000E+04, 6.8526584116E-01, 1.7535255120E+00, 2.1968118576E-02, 2.1030459215E-02, 6.9939391719E-01],
	[2.3115000000E+04, 6.8548495352E-01, 1.7534430733E+00, 2.1982175535E-02, 2.1043536138E-02, 6.9945596232E-01],
	[2.3120000000E+04, 6.8570408852E-01, 1.7533606563E+00, 2.1996238446E-02, 2.1056618183E-02, 6.9951797721E-01],
	[2.3125000000E+04, 6.8592324616E-01, 1.7532782610E+00, 2.2010307310E-02, 2.1069705351E-02, 6.9957996185E-01],
	[2.3130000000E+04, 6.8614242645E-01, 1.7531958874E+00, 2.2024382127E-02, 2.1082797642E-02, 6.9964191626E-01],
	[2.3135000000E+04, 6.8636162938E-01, 1.7531135354E+00, 2.2038462900E-02, 2.1095895057E-02, 6.9970384046E-01],
	[2.3140000000E+04, 6.8658085494E-01, 1.7530312052E+00, 2.2052549629E-02, 2.1108997597E-02, 6.9976573444E-01],
	[2.3145000000E+04, 6.8680010314E-01, 1.7529488965E+00, 2.2066642316E-02, 2.1122105262E-02, 6.9982759823E-01],
	[2.3150000000E+04, 6.8701937397E-01, 1.7528666096E+00, 2.2080740962E-02, 2.1135218054E-02, 6.9988943182E-01],
	[2.3155000000E+04, 6.8723866743E-01, 1.7527843442E+00, 2.2094845567E-02, 2.1148335972E-02, 6.9995123524E-01],
	[2.3160000000E+04, 6.8745798352E-01, 1.7527021005E+00, 2.2108956135E-02, 2.1161459017E-02, 7.0001300850E-01],
	[2.3165000000E+04, 6.8767765824E-01, 1.7526202814E+00, 2.2123072664E-02, 2.1174587568E-02, 7.0007475159E-01],
	[2.3170000000E+04, 6.8789837911E-01, 1.7525397108E+00, 2.2137195158E-02, 2.1187722399E-02, 7.0013646454E-01],
	[2.3175000000E+04, 6.8811912317E-01, 1.7524591613E+00, 2.2151323617E-02, 2.1200862362E-02, 7.0019814736E-01],
	[2.3180000000E+04, 6.8833989042E-01, 1.7523786329E+00, 2.2165458042E-02, 2.1214007458E-02, 7.0025980005E-01],
	[2.3185000000E+04, 6.8856068086E-01, 1.7522981256E+00, 2.2179598435E-02, 2.1227157687E-02, 7.0032142262E-01],
	[2.3190000000E+04, 6.8878149449E-01, 1.7522176393E+00, 2.2193744796E-02, 2.1240313051E-02, 7.0038301510E-01],
	[2.3195000000E+04, 6.8900233131E-01, 1.7521371741E+00, 2.2207897127E-02, 2.1253473549E-02, 7.0044457748E-01],
	[2.3200000000E+04, 6.8922319131E-01, 1.7520567299E+00, 2.2222055430E-02, 2.1266639183E-02, 7.0050610977E-01],
	[2.3205000000E+04, 6.8944407448E-01, 1.7519763068E+00, 2.2236219705E-02, 2.1279809954E-02, 7.0056761200E-01],
	[2.3210000000E+04, 6.8966498084E-01, 1.7518959046E+00, 2.2250389954E-02, 2.1292985861E-02, 7.0062908417E-01],
	[2.3215000000E+04, 6.8988591037E-01, 1.7518155235E+00, 2.2264566177E-02, 2.1306166906E-02, 7.0069052628E-01],
	[2.3220000000E+04, 6.9010686307E-01, 1.7517351633E+00, 2.2278748377E-02, 2.1319353090E-02, 7.0075193836E-01],
	[2.3225000000E+04, 6.9032783894E-01, 1.7516548242E+00, 2.2292936554E-02, 2.1332544413E-02, 7.0081332040E-01],
	[2.3230000000E+04, 6.9054883798E-01, 1.7515745060E+00, 2.2307130710E-02, 2.1345740875E-02, 7.0087467243E-01],
	[2.3235000000E+04, 6.9076986018E-01, 1.7514942088E+00, 2.2321330846E-02, 2.1358942478E-02, 7.0093599445E-01],
	[2.3240000000E+04, 6.9099090555E-01, 1.7514139326E+00, 2.2335536962E-02, 2.1372149222E-02, 7.0099728648E-01],
	[2.3245000000E+04, 6.9121197408E-01, 1.7513336773E+00, 2.2349749061E-02, 2.1385361108E-02, 7.0105854852E-01],
	[2.3250000000E+04, 6.9143306576E-01, 1.7512534429E+00, 2.2363967144E-02, 2.1398578136E-02, 7.0111978058E-01],
	[2.3255000000E+04, 6.9165418059E-01, 1.7511732295E+00, 2.2378191211E-02, 2.1411800308E-02, 7.0118098268E-01],
	[2.3260000000E+04, 6.9187531858E-01, 1.7510930369E+00, 2.2392421265E-02, 2.1425027623E-02, 7.0124215482E-01],
	[2.3265000000E+04, 6.9209647972E-01, 1.7510128653E+00, 2.2406657305E-02, 2.1438260083E-02, 7.0130329702E-01],
	[2.3270000000E+04, 6.9231766400E-01, 1.7509327146E+00, 2.2420899335E-02, 2.1451497689E-02, 7.0136440929E-01],
	[2.3275000000E+04, 6.9253887143E-01, 1.7508525848E+00, 2.2435147353E-02, 2.1464740440E-02, 7.0142549164E-01],
	[2.3280000000E+04, 6.9276010200E-01, 1.7507724758E+00, 2.2449401363E-02, 2.1477988338E-02, 7.0148654408E-01],
	[2.3285000000E+04, 6.9298135570E-01, 1.7506923877E+00, 2.2463661365E-02, 2.1491241383E-02, 7.0154756662E-01],
	[2.3290000000E+04, 6.9320263255E-01, 1.7506123205E+00, 2.2477927360E-02, 2.1504499576E-02, 7.0160855927E-01],
	[2.3295000000E+04, 6.9342393253E-01, 1.7505322741E+00, 2.2492199350E-02, 2.1517762918E-02, 7.0166952204E-01],
	[2.3300000000E+04, 6.9364525564E-01, 1.7504522486E+00, 2.2506477336E-02, 2.1531031409E-02, 7.0173045494E-01],
	[2.3305000000E+04, 6.9386660188E-01, 1.7503722439E+00, 2.2520761319E-02, 2.1544305051E-02, 7.0179135799E-01],
	[2.3310000000E+04, 6.9408797124E-01, 1.7502922600E+00, 2.2535051300E-02, 2.1557583843E-02, 7.0185223119E-01],
	[2.3315000000E+04, 6.9430936373E-01, 1.7502122969E+00, 2.2549347281E-02, 2.1570867786E-02, 7.0191307456E-01],
	[2.3320000000E+04, 6.9453077934E-01, 1.7501323546E+00, 2.2563649262E-02, 2.1584156882E-02, 7.0197388810E-01],
	[2.3325000000E+04, 6.9475221807E-01, 1.7500524331E+00, 2.2577957246E-02, 2.1597451131E-02, 7.0203467183E-01],
	[2.3330000000E+04, 6.9497367991E-01, 1.7499725324E+00, 2.2592271233E-02, 2.1610750532E-02, 7.0209542576E-01],
	[2.3335000000E+04, 6.9519516487E-01, 1.7498926525E+00, 2.2606591224E-02, 2.1624055089E-02, 7.0215614990E-01],
	[2.3340000000E+04, 6.9541667294E-01, 1.7498127933E+00, 2.2620917221E-02, 2.1637364799E-02, 7.0221684426E-01],
	[2.3345000000E+04, 6.9563820411E-01, 1.7497329549E+00, 2.2635249225E-02, 2.1650679666E-02, 7.0227750884E-01],
	[2.3350000000E+04, 6.9585975840E-01, 1.7496531372E+00, 2.2649587237E-02, 2.1663999689E-02, 7.0233814367E-01],
	[2.3355000000E+04, 6.9608133578E-01, 1.7495733402E+00, 2.2663931259E-02, 2.1677324868E-02, 7.0239874875E-01],
	[2.3360000000E+04, 6.9630293627E-01, 1.7494935639E+00, 2.2678281291E-02, 2.1690655205E-02, 7.0245932410E-01],
	[2.3365000000E+04, 6.9652455986E-01, 1.7494138084E+00, 2.2692637335E-02, 2.1703990701E-02, 7.0251986972E-01],
	[2.3370000000E+04, 6.9674620654E-01, 1.7493340736E+00, 2.2706999392E-02, 2.1717331355E-02, 7.0258038562E-01],
	[2.3375000000E+04, 6.9696787631E-01, 1.7492543594E+00, 2.2721367463E-02, 2.1730677169E-02, 7.0264087182E-01],
	[2.3380000000E+04, 6.9718956918E-01, 1.7491746659E+00, 2.2735741550E-02, 2.1744028143E-02, 7.0270132833E-01],
	[2.3385000000E+04, 6.9741128513E-01, 1.7490949931E+00, 2.2750121654E-02, 2.1757384278E-02, 7.0276175515E-01],
	[2.3390000000E+04, 6.9763302417E-01, 1.7490153410E+00, 2.2764507776E-02, 2.1770745575E-02, 7.0282215231E-01],
	[2.3395000000E+04, 6.9785478629E-01, 1.7489357095E+00, 2.2778899917E-02, 2.1784112035E-02, 7.0288251980E-01],
	[2.3400000000E+04, 6.9807657149E-01, 1.7488560987E+00, 2.2793298079E-02, 2.1797483657E-02, 7.0294285765E-01],
	[2.3405000000E+04, 6.9829837977E-01, 1.7487765085E+00, 2.2807702262E-02, 2.1810860443E-02, 7.0300316586E-01],
	[2.3410000000E+04, 6.9852021113E-01, 1.7486969389E+00, 2.2822112468E-02, 2.1824242393E-02, 7.0306344444E-01],
	[2.3415000000E+04, 6.9874206556E-01, 1.7486173899E+00, 2.2836528699E-02, 2.1837629508E-02, 7.0312369340E-01],
	[2.3420000000E+04, 6.9896394306E-01, 1.7485378615E+00, 2.2850950955E-02, 2.1851021790E-02, 7.0318391276E-01],
	[2.3425000000E+04, 6.9918584362E-01, 1.7484583537E+00, 2.2865379237E-02, 2.1864419237E-02, 7.0324410253E-01],
	[2.3430000000E+04, 6.9940776726E-01, 1.7483788665E+00, 2.2879813547E-02, 2.1877821852E-02, 7.0330426272E-01],
	[2.3435000000E+04, 6.9962971395E-01, 1.7482993999E+00, 2.2894253887E-02, 2.1891229634E-02, 7.0336439333E-01],
	[2.3440000000E+04, 6.9985168371E-01, 1.7482199538E+00, 2.2908700257E-02, 2.1904642585E-02, 7.0342449438E-01],
	[2.3445000000E+04, 7.0007367652E-01, 1.7481405283E+00, 2.2923152658E-02, 2.1918060705E-02, 7.0348456588E-01],
	[2.3450000000E+04, 7.0029569239E-01, 1.7480611234E+00, 2.2937611092E-02, 2.1931483995E-02, 7.0354460785E-01],
	[2.3455000000E+04, 7.0051773131E-01, 1.7479817389E+00, 2.2952075560E-02, 2.1944912455E-02, 7.0360462028E-01],
	[2.3460000000E+04, 7.0073979328E-01, 1.7479023750E+00, 2.2966546064E-02, 2.1958346086E-02, 7.0366460321E-01],
	[2.3465000000E+04, 7.0096187830E-01, 1.7478230316E+00, 2.2981022604E-02, 2.1971784890E-02, 7.0372455662E-01],
	[2.3470000000E+04, 7.0118398637E-01, 1.7477437088E+00, 2.2995505182E-02, 2.1985228865E-02, 7.0378448054E-01],
	[2.3475000000E+04, 7.0140611748E-01, 1.7476644064E+00, 2.3009993798E-02, 2.1998678014E-02, 7.0384437498E-01],
	[2.3480000000E+04, 7.0162827162E-01, 1.7475851245E+00, 2.3024488455E-02, 2.2012132337E-02, 7.0390423995E-01],
	[2.3485000000E+04, 7.0185044881E-01, 1.7475058630E+00, 2.3038989153E-02, 2.2025591834E-02, 7.0396407546E-01],
	[2.3490000000E+04, 7.0207264903E-01, 1.7474266221E+00, 2.3053495894E-02, 2.2039056507E-02, 7.0402388151E-01],
	[2.3495000000E+04, 7.0229487228E-01, 1.7473474016E+00, 2.3068008679E-02, 2.2052526355E-02, 7.0408365813E-01],
	[2.3500000000E+04, 7.0251711857E-01, 1.7472682015E+00, 2.3082527509E-02, 2.2066001380E-02, 7.0414340533E-01],
	[2.3505000000E+04, 7.0273938788E-01, 1.7471890219E+00, 2.3097052385E-02, 2.2079481583E-02, 7.0420312310E-01],
	[2.3510000000E+04, 7.0296168021E-01, 1.7471098627E+00, 2.3111583309E-02, 2.2092966963E-02, 7.0426281147E-01],
	[2.3515000000E+04, 7.0318399557E-01, 1.7470307239E+00, 2.3126120281E-02, 2.2106457521E-02, 7.0432247045E-01],
	[2.3520000000E+04, 7.0340633395E-01, 1.7469516056E+00, 2.3140663304E-02, 2.2119953259E-02, 7.0438210005E-01],
	[2.3525000000E+04, 7.0362869535E-01, 1.7468725076E+00, 2.3155212378E-02, 2.2133454177E-02, 7.0444170027E-01],
	[2.3530000000E+04, 7.0385107976E-01, 1.7467934300E+00, 2.3169767504E-02, 2.2146960276E-02, 7.0450127113E-01],
	[2.3535000000E+04, 7.0407348718E-01, 1.7467143729E+00, 2.3184328684E-02, 2.2160471555E-02, 7.0456081265E-01],
	[2.3540000000E+04, 7.0429683509E-01, 1.7466363964E+00, 2.3198895919E-02, 2.2173989097E-02, 7.0462032483E-01],
	[2.3545000000E+04, 7.0452066617E-01, 1.7465589711E+00, 2.3213469211E-02, 2.2187512366E-02, 7.0467980768E-01],
	[2.3550000000E+04, 7.0474452083E-01, 1.7464815657E+00, 2.3228048559E-02, 2.2201040820E-02, 7.0473926121E-01],
	[2.3555000000E+04, 7.0496839908E-01, 1.7464041802E+00, 2.3242633967E-02, 2.2214574461E-02, 7.0479868545E-01],
	[2.3560000000E+04, 7.0519230091E-01, 1.7463268146E+00, 2.3257225434E-02, 2.2228113289E-02, 7.0485808039E-01],
	[2.3565000000E+04, 7.0541622631E-01, 1.7462494687E+00, 2.3271822962E-02, 2.2241657306E-02, 7.0491744605E-01],
	[2.3570000000E+04, 7.0564017529E-01, 1.7461721428E+00, 2.3286426553E-02, 2.2255206511E-02, 7.0497678243E-01],
	[2.3575000000E+04, 7.0586414785E-01, 1.7460948366E+00, 2.3301036207E-02, 2.2268760906E-02, 7.0503608956E-01],
	[2.3580000000E+04, 7.0608814397E-01, 1.7460175502E+00, 2.3315651926E-02, 2.2282320491E-02, 7.0509536745E-01],
	[2.3585000000E+04, 7.0631216366E-01, 1.7459402837E+00, 2.3330273711E-02, 2.2295885266E-02, 7.0515461609E-01],
	[2.3590000000E+04, 7.0653620692E-01, 1.7458630370E+00, 2.3344901564E-02, 2.2309455233E-02, 7.0521383551E-01],
	[2.3595000000E+04, 7.0676027373E-01, 1.7457858100E+00, 2.3359535485E-02, 2.2323030392E-02, 7.0527302572E-01],
	[2.3600000000E+04, 7.0698436411E-01, 1.7457086028E+00, 2.3374175475E-02, 2.2336610744E-02, 7.0533218673E-01],
	[2.3605000000E+04, 7.0720847805E-01, 1.7456314154E+00, 2.3388821537E-02, 2.2350196290E-02, 7.0539131854E-01],
	[2.3610000000E+04, 7.0743261553E-01, 1.7455542478E+00, 2.3403473670E-02, 2.2363787029E-02, 7.0545042117E-01],
	[2.3615000000E+04, 7.0765677658E-01, 1.7454770999E+00, 2.3418131878E-02, 2.2377382963E-02, 7.0550949464E-01],
	[2.3620000000E+04, 7.0788096117E-01, 1.7453999717E+00, 2.3432796159E-02, 2.2390984093E-02, 7.0556853895E-01],
	[2.3625000000E+04, 7.0810516931E-01, 1.7453228633E+00, 2.3447466517E-02, 2.2404590419E-02, 7.0562755411E-01],
	[2.3630000000E+04, 7.0832940099E-01, 1.7452457746E+00, 2.3462142952E-02, 2.2418201942E-02, 7.0568654014E-01],
	[2.3635000000E+04, 7.0855365622E-01, 1.7451687056E+00, 2.3476825465E-02, 2.2431818662E-02, 7.0574549705E-01],
	[2.3640000000E+04, 7.0877793498E-01, 1.7450916563E+00, 2.3491514058E-02, 2.2445440581E-02, 7.0580442484E-01],
	[2.3645000000E+04, 7.0900223729E-01, 1.7450146267E+00, 2.3506208731E-02, 2.2459067698E-02, 7.0586332354E-01],
	[2.3650000000E+04, 7.0922656312E-01, 1.7449376168E+00, 2.3520909487E-02, 2.2472700015E-02, 7.0592219314E-01],
	[2.3655000000E+04, 7.0945091249E-01, 1.7448606266E+00, 2.3535616325E-02, 2.2486337531E-02, 7.0598103367E-01],
	[2.3660000000E+04, 7.0967528539E-01, 1.7447836560E+00, 2.3550329249E-02, 2.2499980249E-02, 7.0603984513E-01],
	[2.3665000000E+04, 7.0989968182E-01, 1.7447067051E+00, 2.3565048258E-02, 2.2513628168E-02, 7.0609862754E-01],
	[2.3670000000E+04, 7.1012410177E-01, 1.7446297739E+00, 2.3579773354E-02, 2.2527281290E-02, 7.0615738090E-01],
	[2.3675000000E+04, 7.1034854525E-01, 1.7445528623E+00, 2.3594504538E-02, 2.2540939614E-02, 7.0621610523E-01],
	[2.3680000000E+04, 7.1057301224E-01, 1.7444759703E+00, 2.3609241812E-02, 2.2554603142E-02, 7.0627480054E-01],
	[2.3685000000E+04, 7.1079750275E-01, 1.7443990979E+00, 2.3623985176E-02, 2.2568271874E-02, 7.0633346685E-01],
	[2.3690000000E+04, 7.1102201678E-01, 1.7443222452E+00, 2.3638734632E-02, 2.2581945810E-02, 7.0639210415E-01],
	[2.3695000000E+04, 7.1124655432E-01, 1.7442454120E+00, 2.3653490181E-02, 2.2595624953E-02, 7.0645071247E-01],
	[2.3700000000E+04, 7.1147111536E-01, 1.7441685985E+00, 2.3668251825E-02, 2.2609309301E-02, 7.0650929181E-01],
	[2.3705000000E+04, 7.1169569992E-01, 1.7440918045E+00, 2.3683019564E-02, 2.2622998856E-02, 7.0656784219E-01],
	[2.3710000000E+04, 7.1192030798E-01, 1.7440150301E+00, 2.3697793400E-02, 2.2636693619E-02, 7.0662636362E-01],
	[2.3715000000E+04, 7.1214493954E-01, 1.7439382753E+00, 2.3712573334E-02, 2.2650393590E-02, 7.0668485611E-01],
	[2.3720000000E+04, 7.1236959460E-01, 1.7438615401E+00, 2.3727359367E-02, 2.2664098770E-02, 7.0674331967E-01],
	[2.3725000000E+04, 7.1259427316E-01, 1.7437848243E+00, 2.3742151501E-02, 2.2677809159E-02, 7.0680175431E-01],
	[2.3730000000E+04, 7.1281897521E-01, 1.7437081282E+00, 2.3756949736E-02, 2.2691524759E-02, 7.0686016004E-01],
	[2.3735000000E+04, 7.1304370076E-01, 1.7436314515E+00, 2.3771754075E-02, 2.2705245569E-02, 7.0691853688E-01],
	[2.3740000000E+04, 7.1326844979E-01, 1.7435547944E+00, 2.3786564518E-02, 2.2718971591E-02, 7.0697688484E-01],
	[2.3745000000E+04, 7.1349322232E-01, 1.7434781568E+00, 2.3801381066E-02, 2.2732702825E-02, 7.0703520393E-01],
	[2.3750000000E+04, 7.1371801832E-01, 1.7434015387E+00, 2.3816203720E-02, 2.2746439271E-02, 7.0709349416E-01],
	[2.3755000000E+04, 7.1394283781E-01, 1.7433249401E+00, 2.3831032483E-02, 2.2760180932E-02, 7.0715175553E-01],
	[2.3760000000E+04, 7.1416768078E-01, 1.7432483610E+00, 2.3845867355E-02, 2.2773927806E-02, 7.0720998807E-01],
	[2.3765000000E+04, 7.1439254723E-01, 1.7431718013E+00, 2.3860708337E-02, 2.2787679895E-02, 7.0726819179E-01],
	[2.3770000000E+04, 7.1461743715E-01, 1.7430952611E+00, 2.3875555430E-02, 2.2801437200E-02, 7.0732636669E-01],
	[2.3775000000E+04, 7.1484235054E-01, 1.7430187404E+00, 2.3890408636E-02, 2.2815199721E-02, 7.0738451279E-01],
	[2.3780000000E+04, 7.1506728741E-01, 1.7429422392E+00, 2.3905267957E-02, 2.2828967458E-02, 7.0744263010E-01],
	[2.3785000000E+04, 7.1529224774E-01, 1.7428657573E+00, 2.3920133393E-02, 2.2842740413E-02, 7.0750071863E-01],
	[2.3790000000E+04, 7.1551723153E-01, 1.7427892949E+00, 2.3935004945E-02, 2.2856518587E-02, 7.0755877839E-01],
	[2.3795000000E+04, 7.1574223879E-01, 1.7427128519E+00, 2.3949882615E-02, 2.2870301979E-02, 7.0761680940E-01],
	[2.3800000000E+04, 7.1596726951E-01, 1.7426364284E+00, 2.3964766403E-02, 2.2884090590E-02, 7.0767481166E-01],
	[2.3805000000E+04, 7.1619232369E-01, 1.7425600242E+00, 2.3979656312E-02, 2.2897884422E-02, 7.0773278518E-01],
	[2.3810000000E+04, 7.1641740132E-01, 1.7424836394E+00, 2.3994552343E-02, 2.2911683474E-02, 7.0779072999E-01],
	[2.3815000000E+04, 7.1664250240E-01, 1.7424072741E+00, 2.4009454496E-02, 2.2925487748E-02, 7.0784864609E-01],
	[2.3820000000E+04, 7.1686762693E-01, 1.7423309281E+00, 2.4024362773E-02, 2.2939297244E-02, 7.0790653348E-01],
	[2.3825000000E+04, 7.1709277491E-01, 1.7422546014E+00, 2.4039277175E-02, 2.2953111963E-02, 7.0796439219E-01],
	[2.3830000000E+04, 7.1731794634E-01, 1.7421782941E+00, 2.4054197703E-02, 2.2966931905E-02, 7.0802222223E-01],
	[2.3835000000E+04, 7.1754314121E-01, 1.7421020062E+00, 2.4069124359E-02, 2.2980757071E-02, 7.0808002360E-01],
	[2.3840000000E+04, 7.1776835951E-01, 1.7420257376E+00, 2.4084057144E-02, 2.2994587462E-02, 7.0813779632E-01],
	[2.3845000000E+04, 7.1799360126E-01, 1.7419494884E+00, 2.4098996059E-02, 2.3008423078E-02, 7.0819554040E-01],
	[2.3850000000E+04, 7.1821886644E-01, 1.7418732585E+00, 2.4113941105E-02, 2.3022263920E-02, 7.0825325586E-01],
	[2.3855000000E+04, 7.1844415505E-01, 1.7417970478E+00, 2.4128892283E-02, 2.3036109989E-02, 7.0831094269E-01],
	[2.3860000000E+04, 7.1866946709E-01, 1.7417208565E+00, 2.4143849595E-02, 2.3049961286E-02, 7.0836860092E-01],
	[2.3865000000E+04, 7.1889480257E-01, 1.7416446845E+00, 2.4158813043E-02, 2.3063817810E-02, 7.0842623055E-01],
	[2.3870000000E+04, 7.1912016146E-01, 1.7415685318E+00, 2.4173782626E-02, 2.3077679563E-02, 7.0848383161E-01],
	[2.3875000000E+04, 7.1934554378E-01, 1.7414923983E+00, 2.4188758347E-02, 2.3091546546E-02, 7.0854140409E-01],
	[2.3880000000E+04, 7.1957094952E-01, 1.7414162842E+00, 2.4203740206E-02, 2.3105418758E-02, 7.0859894801E-01],
	[2.3885000000E+04, 7.1979637868E-01, 1.7413401892E+00, 2.4218728205E-02, 2.3119296201E-02, 7.0865646339E-01],
	[2.3890000000E+04, 7.2002183125E-01, 1.7412641136E+00, 2.4233722346E-02, 2.3133178876E-02, 7.0871395023E-01],
	[2.3895000000E+04, 7.2024730723E-01, 1.7411880572E+00, 2.4248722628E-02, 2.3147066782E-02, 7.0877140855E-01],
	[2.3900000000E+04, 7.2047280663E-01, 1.7411120200E+00, 2.4263729054E-02, 2.3160959921E-02, 7.0882883835E-01],
	[2.3905000000E+04, 7.2069832943E-01, 1.7410360020E+00, 2.4278741625E-02, 2.3174858293E-02, 7.0888623966E-01],
	[2.3910000000E+04, 7.2092387564E-01, 1.7409600033E+00, 2.4293760342E-02, 2.3188761899E-02, 7.0894361247E-01],
	[2.3915000000E+04, 7.2114944525E-01, 1.7408840237E+00, 2.4308785207E-02, 2.3202670740E-02, 7.0900095681E-01],
	[2.3920000000E+04, 7.2137627263E-01, 1.7408094379E+00, 2.4323816219E-02, 2.3216586339E-02, 7.0905827269E-01],
	[2.3925000000E+04, 7.2160328507E-01, 1.7407350503E+00, 2.4338853382E-02, 2.3230507376E-02, 7.0911556011E-01],
	[2.3930000000E+04, 7.2183032149E-01, 1.7406606815E+00, 2.4353896695E-02, 2.3244433652E-02, 7.0917281908E-01],
	[2.3935000000E+04, 7.2205738189E-01, 1.7405863313E+00, 2.4368946161E-02, 2.3258365168E-02, 7.0923004963E-01],
	[2.3940000000E+04, 7.2228446626E-01, 1.7405119999E+00, 2.4384001780E-02, 2.3272301925E-02, 7.0928725176E-01],
	[2.3945000000E+04, 7.2251157461E-01, 1.7404376871E+00, 2.4399063553E-02, 2.3286243923E-02, 7.0934442548E-01],
	[2.3950000000E+04, 7.2273870692E-01, 1.7403633930E+00, 2.4414131483E-02, 2.3300191163E-02, 7.0940157081E-01],
	[2.3955000000E+04, 7.2296586320E-01, 1.7402891176E+00, 2.4429205569E-02, 2.3314143646E-02, 7.0945868775E-01],
	[2.3960000000E+04, 7.2319304345E-01, 1.7402148609E+00, 2.4444285814E-02, 2.3328101373E-02, 7.0951577632E-01],
	[2.3965000000E+04, 7.2342024766E-01, 1.7401406229E+00, 2.4459372218E-02, 2.3342064343E-02, 7.0957283653E-01],
	[2.3970000000E+04, 7.2364747582E-01, 1.7400664035E+00, 2.4474464783E-02, 2.3356032558E-02, 7.0962986840E-01],
	[2.3975000000E+04, 7.2387472795E-01, 1.7399922027E+00, 2.4489563511E-02, 2.3370006019E-02, 7.0968687192E-01],
	[2.3980000000E+04, 7.2410200403E-01, 1.7399180206E+00, 2.4504668401E-02, 2.3383984725E-02, 7.0974384713E-01],
	[2.3985000000E+04, 7.2432930406E-01, 1.7398438571E+00, 2.4519779456E-02, 2.3397968678E-02, 7.0980079402E-01],
	[2.3990000000E+04, 7.2455662804E-01, 1.7397697122E+00, 2.4534896676E-02, 2.3411957879E-02, 7.0985771261E-01],
	[2.3995000000E+04, 7.2478397597E-01, 1.7396955859E+00, 2.4550020064E-02, 2.3425952327E-02, 7.0991460290E-01],
	[2.4000000000E+04, 7.2501134784E-01, 1.7396214783E+00, 2.4565149619E-02, 2.3439952024E-02, 7.0997146493E-01],
	[2.4005000000E+04, 7.2523874366E-01, 1.7395473892E+00, 2.4580285345E-02, 2.3453956970E-02, 7.1002829868E-01],
	[2.4010000000E+04, 7.2546616341E-01, 1.7394733187E+00, 2.4595427240E-02, 2.3467967167E-02, 7.1008510418E-01],
	[2.4015000000E+04, 7.2569360710E-01, 1.7393992668E+00, 2.4610575308E-02, 2.3481982614E-02, 7.1014188144E-01],
	[2.4020000000E+04, 7.2592107473E-01, 1.7393252335E+00, 2.4625729548E-02, 2.3496003312E-02, 7.1019863047E-01],
	[2.4025000000E+04, 7.2614856629E-01, 1.7392512187E+00, 2.4640889963E-02, 2.3510029261E-02, 7.1025535128E-01],
	[2.4030000000E+04, 7.2637608178E-01, 1.7391772224E+00, 2.4656056553E-02, 2.3524060464E-02, 7.1031204388E-01],
	[2.4035000000E+04, 7.2660362120E-01, 1.7391032447E+00, 2.4671229321E-02, 2.3538096920E-02, 7.1036870829E-01],
	[2.4040000000E+04, 7.2683118454E-01, 1.7390292856E+00, 2.4686408266E-02, 2.3552138629E-02, 7.1042534452E-01],
	[2.4045000000E+04, 7.2705877181E-01, 1.7389553450E+00, 2.4701593390E-02, 2.3566185593E-02, 7.1048195257E-01],
	[2.4050000000E+04, 7.2728638299E-01, 1.7388814228E+00, 2.4716784695E-02, 2.3580237812E-02, 7.1053853246E-01],
	[2.4055000000E+04, 7.2751401810E-01, 1.7388075192E+00, 2.4731982181E-02, 2.3594295287E-02, 7.1059508421E-01],
	[2.4060000000E+04, 7.2774167711E-01, 1.7387336341E+00, 2.4747185851E-02, 2.3608358018E-02, 7.1065160782E-01],
	[2.4065000000E+04, 7.2796936005E-01, 1.7386597675E+00, 2.4762395704E-02, 2.3622426007E-02, 7.1070810331E-01],
	[2.4070000000E+04, 7.2819706689E-01, 1.7385859194E+00, 2.4777611743E-02, 2.3636499253E-02, 7.1076457068E-01],
	[2.4075000000E+04, 7.2842479764E-01, 1.7385120897E+00, 2.4792833969E-02, 2.3650577758E-02, 7.1082100995E-01],
	[2.4080000000E+04, 7.2865255229E-01, 1.7384382785E+00, 2.4808062382E-02, 2.3664661521E-02, 7.1087742114E-01],
	[2.4085000000E+04, 7.2888033085E-01, 1.7383644858E+00, 2.4823296985E-02, 2.3678750544E-02, 7.1093380425E-01],
	[2.4090000000E+04, 7.2910813331E-01, 1.7382907115E+00, 2.4838537778E-02, 2.3692844828E-02, 7.1099015929E-01],
	[2.4095000000E+04, 7.2933595966E-01, 1.7382169557E+00, 2.4853784762E-02, 2.3706944373E-02, 7.1104648628E-01],
	[2.4100000000E+04, 7.2956380991E-01, 1.7381432182E+00, 2.4869037939E-02, 2.3721049179E-02, 7.1110278523E-01],
	[2.4105000000E+04, 7.2979168406E-01, 1.7380694992E+00, 2.4884297310E-02, 2.3735159247E-02, 7.1115905615E-01],
	[2.4110000000E+04, 7.3001958209E-01, 1.7379957987E+00, 2.4899562876E-02, 2.3749274579E-02, 7.1121529905E-01],
	[2.4115000000E+04, 7.3024750402E-01, 1.7379221165E+00, 2.4914834639E-02, 2.3763395174E-02, 7.1127151395E-01],
	[2.4120000000E+04, 7.3047544983E-01, 1.7378484527E+00, 2.4930112599E-02, 2.3777521033E-02, 7.1132770085E-01],
	[2.4125000000E+04, 7.3070341952E-01, 1.7377748074E+00, 2.4945396758E-02, 2.3791652157E-02, 7.1138385978E-01],
	[2.4130000000E+04, 7.3093141309E-01, 1.7377011804E+00, 2.4960687118E-02, 2.3805788547E-02, 7.1143999073E-01],
	[2.4135000000E+04, 7.3115943054E-01, 1.7376275717E+00, 2.4975983678E-02, 2.3819930203E-02, 7.1149609372E-01],
	[2.4140000000E+04, 7.3138747187E-01, 1.7375539815E+00, 2.4991286442E-02, 2.3834077125E-02, 7.1155216877E-01],
	[2.4145000000E+04, 7.3161553707E-01, 1.7374804096E+00, 2.5006595409E-02, 2.3848229315E-02, 7.1160821588E-01],
	[2.4150000000E+04, 7.3184362614E-01, 1.7374068560E+00, 2.5021910581E-02, 2.3862386774E-02, 7.1166423507E-01],
	[2.4155000000E+04, 7.3207173909E-01, 1.7373333208E+00, 2.5037231959E-02, 2.3876549501E-02, 7.1172022636E-01],
	[2.4160000000E+04, 7.3229987589E-01, 1.7372598039E+00, 2.5052559545E-02, 2.3890717497E-02, 7.1177618974E-01],
	[2.4165000000E+04, 7.3252803656E-01, 1.7371863053E+00, 2.5067893340E-02, 2.3904890763E-02, 7.1183212523E-01],
	[2.4170000000E+04, 7.3275622110E-01, 1.7371128251E+00, 2.5083233345E-02, 2.3919069300E-02, 7.1188803286E-01],
	[2.4175000000E+04, 7.3298442949E-01, 1.7370393632E+00, 2.5098579560E-02, 2.3933253109E-02, 7.1194391261E-01],
	[2.4180000000E+04, 7.3321266173E-01, 1.7369659195E+00, 2.5113931989E-02, 2.3947442189E-02, 7.1199976452E-01],
	[2.4185000000E+04, 7.3344091784E-01, 1.7368924942E+00, 2.5129290631E-02, 2.3961636542E-02, 7.1205558859E-01],
	[2.4190000000E+04, 7.3366919779E-01, 1.7368190871E+00, 2.5144655487E-02, 2.3975836168E-02, 7.1211138483E-01],
	[2.4195000000E+04, 7.3389750159E-01, 1.7367456983E+00, 2.5160026560E-02, 2.3990041068E-02, 7.1216715326E-01],
	[2.4200000000E+04, 7.3412582924E-01, 1.7366723278E+00, 2.5175403851E-02, 2.4004251243E-02, 7.1222289389E-01],
	[2.4205000000E+04, 7.3435418073E-01, 1.7365989755E+00, 2.5190787359E-02, 2.4018466693E-02, 7.1227860672E-01],
	[2.4210000000E+04, 7.3458255607E-01, 1.7365256415E+00, 2.5206177088E-02, 2.4032687418E-02, 7.1233429177E-01],
	[2.4215000000E+04, 7.3481095524E-01, 1.7364523257E+00, 2.5221573038E-02, 2.4046913421E-02, 7.1238994906E-01],
	[2.4220000000E+04, 7.3503937825E-01, 1.7363790281E+00, 2.5236975210E-02, 2.4061144700E-02, 7.1244557859E-01],
	[2.4225000000E+04, 7.3526782510E-01, 1.7363057488E+00, 2.5252383605E-02, 2.4075381257E-02, 7.1250118038E-01],
	[2.4230000000E+04, 7.3549629578E-01, 1.7362324876E+00, 2.5267798225E-02, 2.4089623092E-02, 7.1255675444E-01],
	[2.4235000000E+04, 7.3572479028E-01, 1.7361592447E+00, 2.5283219071E-02, 2.4103870207E-02, 7.1261230078E-01],
	[2.4240000000E+04, 7.3595330862E-01, 1.7360860200E+00, 2.5298646145E-02, 2.4118122601E-02, 7.1266781941E-01],
	[2.4245000000E+04, 7.3618185078E-01, 1.7360128135E+00, 2.5314079446E-02, 2.4132380275E-02, 7.1272331035E-01],
	[2.4250000000E+04, 7.3641041676E-01, 1.7359396251E+00, 2.5329518978E-02, 2.4146643231E-02, 7.1277877360E-01],
	[2.4255000000E+04, 7.3663900656E-01, 1.7358664550E+00, 2.5344964740E-02, 2.4160911468E-02, 7.1283420918E-01],
	[2.4260000000E+04, 7.3686762018E-01, 1.7357933030E+00, 2.5360416734E-02, 2.4175184987E-02, 7.1288961710E-01],
	[2.4265000000E+04, 7.3709625762E-01, 1.7357201691E+00, 2.5375874962E-02, 2.4189463789E-02, 7.1294499737E-01],
	[2.4270000000E+04, 7.3732491886E-01, 1.7356470534E+00, 2.5391339424E-02, 2.4203747875E-02, 7.1300035001E-01],
	[2.4275000000E+04, 7.3755360392E-01, 1.7355739559E+00, 2.5406810122E-02, 2.4218037244E-02, 7.1305567503E-01],
	[2.4280000000E+04, 7.3778231278E-01, 1.7355008764E+00, 2.5422287057E-02, 2.4232331899E-02, 7.1311097243E-01],
	[2.4285000000E+04, 7.3801104545E-01, 1.7354278151E+00, 2.5437770230E-02, 2.4246631839E-02, 7.1316624224E-01],
	[2.4290000000E+04, 7.3823980193E-01, 1.7353547719E+00, 2.5453259643E-02, 2.4260937065E-02, 7.1322148446E-01],
	[2.4295000000E+04, 7.3846858220E-01, 1.7352817469E+00, 2.5468755296E-02, 2.4275247578E-02, 7.1327669910E-01],
	[2.4300000000E+04, 7.3869738627E-01, 1.7352087399E+00, 2.5484257191E-02, 2.4289563378E-02, 7.1333188618E-01],
	[2.4305000000E+04, 7.3892746269E-01, 1.7351370907E+00, 2.5499765330E-02, 2.4303886080E-02, 7.1338704571E-01],
	[2.4310000000E+04, 7.3915772906E-01, 1.7350656368E+00, 2.5515279713E-02, 2.4318214287E-02, 7.1344217769E-01],
	[2.4315000000E+04, 7.3938801981E-01, 1.7349942006E+00, 2.5530800341E-02, 2.4332547786E-02, 7.1349728215E-01],
	[2.4320000000E+04, 7.3961833493E-01, 1.7349227821E+00, 2.5546327216E-02, 2.4346886578E-02, 7.1355235910E-01],
	[2.4325000000E+04, 7.3984867443E-01, 1.7348513811E+00, 2.5561860340E-02, 2.4361230664E-02, 7.1360740854E-01],
	[2.4330000000E+04, 7.4007903830E-01, 1.7347799978E+00, 2.5577399712E-02, 2.4375580044E-02, 7.1366243049E-01],
	[2.4335000000E+04, 7.4030942654E-01, 1.7347086320E+00, 2.5592945336E-02, 2.4389934719E-02, 7.1371742497E-01],
	[2.4340000000E+04, 7.4053983914E-01, 1.7346372839E+00, 2.5608497211E-02, 2.4404294689E-02, 7.1377239197E-01],
	[2.4345000000E+04, 7.4077027611E-01, 1.7345659533E+00, 2.5624055339E-02, 2.4418659956E-02, 7.1382733152E-01],
	[2.4350000000E+04, 7.4100073744E-01, 1.7344946404E+00, 2.5639619721E-02, 2.4433030519E-02, 7.1388224363E-01],
	[2.4355000000E+04, 7.4123122313E-01, 1.7344233450E+00, 2.5655190359E-02, 2.4447406379E-02, 7.1393712831E-01],
	[2.4360000000E+04, 7.4146173318E-01, 1.7343520671E+00, 2.5670767253E-02, 2.4461787538E-02, 7.1399198556E-01],
	[2.4365000000E+04, 7.4169226758E-01, 1.7342808069E+00, 2.5686350405E-02, 2.4476173995E-02, 7.1404681541E-01],
	[2.4370000000E+04, 7.4192282633E-01, 1.7342095641E+00, 2.5701939817E-02, 2.4490565752E-02, 7.1410161787E-01],
	[2.4375000000E+04, 7.4215340943E-01, 1.7341383390E+00, 2.5717535488E-02, 2.4504962808E-02, 7.1415639294E-01],
	[2.4380000000E+04, 7.4238401688E-01, 1.7340671313E+00, 2.5733137422E-02, 2.4519365165E-02, 7.1421114064E-01],
	[2.4385000000E+04, 7.4261464867E-01, 1.7339959412E+00, 2.5748745618E-02, 2.4533772823E-02, 7.1426586099E-01],
	[2.4390000000E+04, 7.4284530480E-01, 1.7339247686E+00, 2.5764360078E-02, 2.4548185783E-02, 7.1432055398E-01],
	[2.4395000000E+04, 7.4307598528E-01, 1.7338536135E+00, 2.5779980804E-02, 2.4562604046E-02, 7.1437521965E-01],
	[2.4400000000E+04, 7.4330669009E-01, 1.7337824759E+00, 2.5795607796E-02, 2.4577027611E-02, 7.1442985799E-01],
	[2.4405000000E+04, 7.4353741923E-01, 1.7337113558E+00, 2.5811241055E-02, 2.4591456481E-02, 7.1448446902E-01],
	[2.4410000000E+04, 7.4376817271E-01, 1.7336402531E+00, 2.5826880584E-02, 2.4605890654E-02, 7.1453905275E-01],
	[2.4415000000E+04, 7.4399895052E-01, 1.7335691680E+00, 2.5842526383E-02, 2.4620330133E-02, 7.1459360919E-01],
	[2.4420000000E+04, 7.4422975266E-01, 1.7334981003E+00, 2.5858178454E-02, 2.4634774917E-02, 7.1464813837E-01],
	[2.4425000000E+04, 7.4446057912E-01, 1.7334270501E+00, 2.5873836797E-02, 2.4649225008E-02, 7.1470264028E-01],
	[2.4430000000E+04, 7.4469142990E-01, 1.7333560174E+00, 2.5889501414E-02, 2.4663680405E-02, 7.1475711494E-01],
	[2.4435000000E+04, 7.4492230500E-01, 1.7332850021E+00, 2.5905172306E-02, 2.4678141110E-02, 7.1481156236E-01],
	[2.4440000000E+04, 7.4515320443E-01, 1.7332140042E+00, 2.5920849474E-02, 2.4692607123E-02, 7.1486598255E-01],
	[2.4445000000E+04, 7.4538412816E-01, 1.7331430238E+00, 2.5936532920E-02, 2.4707078445E-02, 7.1492037554E-01],
	[2.4450000000E+04, 7.4561507621E-01, 1.7330720607E+00, 2.5952222645E-02, 2.4721555077E-02, 7.1497474132E-01],
	[2.4455000000E+04, 7.4584604857E-01, 1.7330011151E+00, 2.5967918649E-02, 2.4736037018E-02, 7.1502907991E-01],
	[2.4460000000E+04, 7.4607704524E-01, 1.7329301869E+00, 2.5983620936E-02, 2.4750524271E-02, 7.1508339132E-01],
	[2.4465000000E+04, 7.4630806622E-01, 1.7328592762E+00, 2.5999329504E-02, 2.4765016834E-02, 7.1513767557E-01],
	[2.4470000000E+04, 7.4653911150E-01, 1.7327883827E+00, 2.6015044356E-02, 2.4779514710E-02, 7.1519193267E-01],
	[2.4475000000E+04, 7.4677018108E-01, 1.7327175067E+00, 2.6030765494E-02, 2.4794017898E-02, 7.1524616263E-01],
	[2.4480000000E+04, 7.4700127495E-01, 1.7326466481E+00, 2.6046492917E-02, 2.4808526399E-02, 7.1530036545E-01],
	[2.4485000000E+04, 7.4723239313E-01, 1.7325758068E+00, 2.6062226628E-02, 2.4823040214E-02, 7.1535454116E-01],
	[2.4490000000E+04, 7.4746353560E-01, 1.7325049829E+00, 2.6077966627E-02, 2.4837559344E-02, 7.1540868977E-01],
	[2.4495000000E+04, 7.4769470236E-01, 1.7324341763E+00, 2.6093712916E-02, 2.4852083789E-02, 7.1546281128E-01],
	[2.4500000000E+04, 7.4792589340E-01, 1.7323633871E+00, 2.6109465497E-02, 2.4866613549E-02, 7.1551690571E-01],
	[2.4505000000E+04, 7.4815710874E-01, 1.7322926152E+00, 2.6125224369E-02, 2.4881148626E-02, 7.1557097308E-01],
	[2.4510000000E+04, 7.4838834836E-01, 1.7322218607E+00, 2.6140989536E-02, 2.4895689020E-02, 7.1562501339E-01],
	[2.4515000000E+04, 7.4861961226E-01, 1.7321511235E+00, 2.6156760997E-02, 2.4910234732E-02, 7.1567902665E-01],
	[2.4520000000E+04, 7.4885090044E-01, 1.7320804035E+00, 2.6172538754E-02, 2.4924785761E-02, 7.1573301288E-01],
	[2.4525000000E+04, 7.4908221289E-01, 1.7320097009E+00, 2.6188322808E-02, 2.4939342110E-02, 7.1578697210E-01],
	[2.4530000000E+04, 7.4931354963E-01, 1.7319390156E+00, 2.6204113161E-02, 2.4953903778E-02, 7.1584090430E-01],
	[2.4535000000E+04, 7.4954491063E-01, 1.7318683476E+00, 2.6219909813E-02, 2.4968470767E-02, 7.1589480951E-01],
	[2.4540000000E+04, 7.4977629590E-01, 1.7317976969E+00, 2.6235712767E-02, 2.4983043076E-02, 7.1594868774E-01],
	[2.4545000000E+04, 7.5000770544E-01, 1.7317270634E+00, 2.6251522022E-02, 2.4997620706E-02, 7.1600253900E-01],
	[2.4550000000E+04, 7.5023913925E-01, 1.7316564472E+00, 2.6267337581E-02, 2.5012203659E-02, 7.1605636329E-01],
	[2.4555000000E+04, 7.5047059732E-01, 1.7315858483E+00, 2.6283159444E-02, 2.5026791934E-02, 7.1611016065E-01],
	[2.4560000000E+04, 7.5070207965E-01, 1.7315152666E+00, 2.6298987614E-02, 2.5041385533E-02, 7.1616393106E-01],
	[2.4565000000E+04, 7.5093358623E-01, 1.7314447021E+00, 2.6314822090E-02, 2.5055984455E-02, 7.1621767455E-01],
	[2.4570000000E+04, 7.5116511707E-01, 1.7313741549E+00, 2.6330662875E-02, 2.5070588702E-02, 7.1627139114E-01],
	[2.4575000000E+04, 7.5139667217E-01, 1.7313036249E+00, 2.6346509969E-02, 2.5085198274E-02, 7.1632508082E-01],
	[2.4580000000E+04, 7.5162825151E-01, 1.7312331122E+00, 2.6362363374E-02, 2.5099813172E-02, 7.1637874362E-01],
	[2.4585000000E+04, 7.5185985510E-01, 1.7311626166E+00, 2.6378223091E-02, 2.5114433396E-02, 7.1643237955E-01],
	[2.4590000000E+04, 7.5209148294E-01, 1.7310921383E+00, 2.6394089121E-02, 2.5129058948E-02, 7.1648598861E-01],
	[2.4595000000E+04, 7.5232313502E-01, 1.7310216772E+00, 2.6409961466E-02, 2.5143689827E-02, 7.1653957083E-01],
	[2.4600000000E+04, 7.5255481135E-01, 1.7309512332E+00, 2.6425840126E-02, 2.5158326034E-02, 7.1659312620E-01],
	[2.4605000000E+04, 7.5278651191E-01, 1.7308808064E+00, 2.6441725103E-02, 2.5172967570E-02, 7.1664665475E-01],
	[2.4610000000E+04, 7.5301823671E-01, 1.7308103969E+00, 2.6457616398E-02, 2.5187614436E-02, 7.1670015649E-01],
	[2.4615000000E+04, 7.5324998574E-01, 1.7307400044E+00, 2.6473514013E-02, 2.5202266632E-02, 7.1675363143E-01],
	[2.4620000000E+04, 7.5348175900E-01, 1.7306696292E+00, 2.6489417948E-02, 2.5216924159E-02, 7.1680707958E-01],
	[2.4625000000E+04, 7.5371355649E-01, 1.7305992710E+00, 2.6505328205E-02, 2.5231587017E-02, 7.1686050095E-01],
	[2.4630000000E+04, 7.5394537821E-01, 1.7305289301E+00, 2.6521244785E-02, 2.5246255207E-02, 7.1691389556E-01],
	[2.4635000000E+04, 7.5417722416E-01, 1.7304586062E+00, 2.6537167689E-02, 2.5260928729E-02, 7.1696726342E-01],
	[2.4640000000E+04, 7.5440909432E-01, 1.7303882995E+00, 2.6553096919E-02, 2.5275607586E-02, 7.1702060454E-01],
	[2.4645000000E+04, 7.5464098870E-01, 1.7303180099E+00, 2.6569032476E-02, 2.5290291775E-02, 7.1707391893E-01],
	[2.4650000000E+04, 7.5487290731E-01, 1.7302477375E+00, 2.6584974360E-02, 2.5304981300E-02, 7.1712720660E-01],
	[2.4655000000E+04, 7.5510485012E-01, 1.7301774821E+00, 2.6600922574E-02, 2.5319676159E-02, 7.1718046757E-01],
	[2.4660000000E+04, 7.5533681715E-01, 1.7301072438E+00, 2.6616877118E-02, 2.5334376355E-02, 7.1723370184E-01],
	[2.4665000000E+04, 7.5556880839E-01, 1.7300370226E+00, 2.6632837994E-02, 2.5349081886E-02, 7.1728690942E-01],
	[2.4670000000E+04, 7.5580082384E-01, 1.7299668186E+00, 2.6648805202E-02, 2.5363792755E-02, 7.1734009033E-01],
	[2.4675000000E+04, 7.5603286349E-01, 1.7298966315E+00, 2.6664778745E-02, 2.5378508961E-02, 7.1739324456E-01],
	[2.4680000000E+04, 7.5626492734E-01, 1.7298264616E+00, 2.6680758623E-02, 2.5393230506E-02, 7.1744637215E-01],
	[2.4685000000E+04, 7.5649701539E-01, 1.7297563087E+00, 2.6696744837E-02, 2.5407957389E-02, 7.1749947309E-01],
	[2.4690000000E+04, 7.5672912765E-01, 1.7296861728E+00, 2.6712737389E-02, 2.5422689612E-02, 7.1755254739E-01],
	[2.4695000000E+04, 7.5696218356E-01, 1.7296170048E+00, 2.6728736281E-02, 2.5437428419E-02, 7.1760559506E-01],
	[2.4700000000E+04, 7.5719577770E-01, 1.7295483844E+00, 2.6744741512E-02, 2.5452173264E-02, 7.1765861613E-01],
	[2.4705000000E+04, 7.5742939663E-01, 1.7294797807E+00, 2.6760753085E-02, 2.5466923454E-02, 7.1771161058E-01],
	[2.4710000000E+04, 7.5766304033E-01, 1.7294111936E+00, 2.6776771001E-02, 2.5481678988E-02, 7.1776457844E-01],
	[2.4715000000E+04, 7.5789670881E-01, 1.7293426231E+00, 2.6792795261E-02, 2.5496439869E-02, 7.1781751972E-01],
	[2.4720000000E+04, 7.5813040207E-01, 1.7292740691E+00, 2.6808825865E-02, 2.5511206095E-02, 7.1787043442E-01],
	[2.4725000000E+04, 7.5836412011E-01, 1.7292055318E+00, 2.6824862817E-02, 2.5525977669E-02, 7.1792332256E-01],
	[2.4730000000E+04, 7.5859786291E-01, 1.7291370110E+00, 2.6840906115E-02, 2.5540754590E-02, 7.1797618415E-01],
	[2.4735000000E+04, 7.5883163048E-01, 1.7290685068E+00, 2.6856955763E-02, 2.5555536859E-02, 7.1802901919E-01],
	[2.4740000000E+04, 7.5906542281E-01, 1.7290000191E+00, 2.6873011761E-02, 2.5570324477E-02, 7.1808182770E-01],
	[2.4745000000E+04, 7.5929923991E-01, 1.7289315480E+00, 2.6889074109E-02, 2.5585117445E-02, 7.1813460968E-01],
	[2.4750000000E+04, 7.5953308177E-01, 1.7288630934E+00, 2.6905142811E-02, 2.5599915763E-02, 7.1818736516E-01],
	[2.4755000000E+04, 7.5976694839E-01, 1.7287946554E+00, 2.6921217866E-02, 2.5614719431E-02, 7.1824009413E-01],
	[2.4760000000E+04, 7.6000083977E-01, 1.7287262339E+00, 2.6937299276E-02, 2.5629528450E-02, 7.1829279661E-01],
	[2.4765000000E+04, 7.6023475590E-01, 1.7286578289E+00, 2.6953387043E-02, 2.5644342822E-02, 7.1834547261E-01],
	[2.4770000000E+04, 7.6046869678E-01, 1.7285894405E+00, 2.6969481166E-02, 2.5659162546E-02, 7.1839812213E-01],
	[2.4775000000E+04, 7.6070266240E-01, 1.7285210685E+00, 2.6985581649E-02, 2.5673987623E-02, 7.1845074520E-01],
	[2.4780000000E+04, 7.6093665278E-01, 1.7284527131E+00, 2.7001688491E-02, 2.5688818054E-02, 7.1850334182E-01],
	[2.4785000000E+04, 7.6117066790E-01, 1.7283843741E+00, 2.7017801695E-02, 2.5703653839E-02, 7.1855591199E-01],
	[2.4790000000E+04, 7.6140470776E-01, 1.7283160517E+00, 2.7033921261E-02, 2.5718494980E-02, 7.1860845574E-01],
	[2.4795000000E+04, 7.6163877237E-01, 1.7282477457E+00, 2.7050047190E-02, 2.5733341476E-02, 7.1866097307E-01],
	[2.4800000000E+04, 7.6187286170E-01, 1.7281794561E+00, 2.7066179484E-02, 2.5748193328E-02, 7.1871346399E-01],
	[2.4805000000E+04, 7.6210697578E-01, 1.7281111831E+00, 2.7082318144E-02, 2.5763050537E-02, 7.1876592851E-01],
	[2.4810000000E+04, 7.6234111458E-01, 1.7280429265E+00, 2.7098463172E-02, 2.5777913103E-02, 7.1881836664E-01],
	[2.4815000000E+04, 7.6257527812E-01, 1.7279746863E+00, 2.7114614568E-02, 2.5792781028E-02, 7.1887077840E-01],
	[2.4820000000E+04, 7.6280946639E-01, 1.7279064626E+00, 2.7130772333E-02, 2.5807654311E-02, 7.1892316378E-01],
	[2.4825000000E+04, 7.6304367937E-01, 1.7278382554E+00, 2.7146936470E-02, 2.5822532953E-02, 7.1897552282E-01],
	[2.4830000000E+04, 7.6327791709E-01, 1.7277700645E+00, 2.7163106979E-02, 2.5837416956E-02, 7.1902785550E-01],
	[2.4835000000E+04, 7.6351217952E-01, 1.7277018901E+00, 2.7179283861E-02, 2.5852306319E-02, 7.1908016185E-01],
	[2.4840000000E+04, 7.6374646667E-01, 1.7276337321E+00, 2.7195467118E-02, 2.5867201043E-02, 7.1913244187E-01],
	[2.4845000000E+04, 7.6398077854E-01, 1.7275655905E+00, 2.7211656750E-02, 2.5882101129E-02, 7.1918469558E-01],
	[2.4850000000E+04, 7.6421511512E-01, 1.7274974653E+00, 2.7227852760E-02, 2.5897006577E-02, 7.1923692299E-01],
	[2.4855000000E+04, 7.6444947641E-01, 1.7274293565E+00, 2.7244055148E-02, 2.5911917388E-02, 7.1928912410E-01],
	[2.4860000000E+04, 7.6468386241E-01, 1.7273612641E+00, 2.7260263916E-02, 2.5926833563E-02, 7.1934129892E-01],
	[2.4865000000E+04, 7.6491827312E-01, 1.7272931880E+00, 2.7276479064E-02, 2.5941755102E-02, 7.1939344748E-01],
	[2.4870000000E+04, 7.6515270853E-01, 1.7272251283E+00, 2.7292700595E-02, 2.5956682006E-02, 7.1944556977E-01],
	[2.4875000000E+04, 7.6538716864E-01, 1.7271570850E+00, 2.7308928508E-02, 2.5971614275E-02, 7.1949766580E-01],
	[2.4880000000E+04, 7.6562165345E-01, 1.7270890580E+00, 2.7325162806E-02, 2.5986551911E-02, 7.1954973560E-01],
	[2.4885000000E+04, 7.6585616296E-01, 1.7270210474E+00, 2.7341403490E-02, 2.6001494913E-02, 7.1960177917E-01],
	[2.4890000000E+04, 7.6609069717E-01, 1.7269530532E+00, 2.7357650560E-02, 2.6016443282E-02, 7.1965379651E-01],
	[2.4895000000E+04, 7.6632525606E-01, 1.7268850752E+00, 2.7373904019E-02, 2.6031397019E-02, 7.1970578765E-01],
	[2.4900000000E+04, 7.6655983965E-01, 1.7268171136E+00, 2.7390163867E-02, 2.6046356125E-02, 7.1975775258E-01],
	[2.4905000000E+04, 7.6679444792E-01, 1.7267491683E+00, 2.7406430106E-02, 2.6061320600E-02, 7.1980969133E-01],
	[2.4910000000E+04, 7.6702908088E-01, 1.7266812393E+00, 2.7422702737E-02, 2.6076290444E-02, 7.1986160390E-01],
	[2.4915000000E+04, 7.6726373852E-01, 1.7266133266E+00, 2.7438981760E-02, 2.6091265659E-02, 7.1991349029E-01],
	[2.4920000000E+04, 7.6749842084E-01, 1.7265454303E+00, 2.7455267178E-02, 2.6106246245E-02, 7.1996535054E-01],
	[2.4925000000E+04, 7.6773312784E-01, 1.7264775502E+00, 2.7471558991E-02, 2.6121232202E-02, 7.2001718463E-01],
	[2.4930000000E+04, 7.6796785952E-01, 1.7264096864E+00, 2.7487857201E-02, 2.6136223532E-02, 7.2006899259E-01],
	[2.4935000000E+04, 7.6820261586E-01, 1.7263418388E+00, 2.7504161809E-02, 2.6151220234E-02, 7.2012077442E-01],
	[2.4940000000E+04, 7.6843739688E-01, 1.7262740076E+00, 2.7520472816E-02, 2.6166222310E-02, 7.2017253014E-01],
	[2.4945000000E+04, 7.6867220257E-01, 1.7262061926E+00, 2.7536790224E-02, 2.6181229759E-02, 7.2022425976E-01],
	[2.4950000000E+04, 7.6890703293E-01, 1.7261383938E+00, 2.7553114033E-02, 2.6196242584E-02, 7.2027596327E-01],
	[2.4955000000E+04, 7.6914188794E-01, 1.7260706114E+00, 2.7569444245E-02, 2.6211260783E-02, 7.2032764071E-01],
	[2.4960000000E+04, 7.6937676762E-01, 1.7260028451E+00, 2.7585780862E-02, 2.6226284358E-02, 7.2037929207E-01],
	[2.4965000000E+04, 7.6961167196E-01, 1.7259350951E+00, 2.7602123883E-02, 2.6241313310E-02, 7.2043091737E-01],
	[2.4970000000E+04, 7.6984660096E-01, 1.7258673613E+00, 2.7618473311E-02, 2.6256347639E-02, 7.2048251662E-01],
	[2.4975000000E+04, 7.7008155461E-01, 1.7257996437E+00, 2.7634829147E-02, 2.6271387345E-02, 7.2053408983E-01],
	[2.4980000000E+04, 7.7031653291E-01, 1.7257319423E+00, 2.7651191392E-02, 2.6286432430E-02, 7.2058563701E-01],
	[2.4985000000E+04, 7.7055153587E-01, 1.7256642572E+00, 2.7667560047E-02, 2.6301482893E-02, 7.2063715816E-01],
	[2.4990000000E+04, 7.7078656347E-01, 1.7255965882E+00, 2.7683935114E-02, 2.6316538736E-02, 7.2068865331E-01],
	[2.4995000000E+04, 7.7102161571E-01, 1.7255289355E+00, 2.7700316593E-02, 2.6331599959E-02, 7.2074012246E-01],
	[2.5000000000E+04, 7.7125669260E-01, 1.7254612989E+00, 2.7716704486E-02, 2.6346666562E-02, 7.2079156562E-01],
	[2.5005000000E+04, 7.7149179413E-01, 1.7253936785E+00, 2.7733118108E-02, 2.6361755998E-02, 7.2084298281E-01],
	[2.5010000000E+04, 7.7172692029E-01, 1.7253260742E+00, 2.7749538165E-02, 2.6376850831E-02, 7.2089437403E-01],
	[2.5015000000E+04, 7.7196207110E-01, 1.7252584861E+00, 2.7765964659E-02, 2.6391951062E-02, 7.2094573929E-01],
	[2.5020000000E+04, 7.7219724653E-01, 1.7251909142E+00, 2.7782397590E-02, 2.6407056693E-02, 7.2099707860E-01],
	[2.5025000000E+04, 7.7243244660E-01, 1.7251233584E+00, 2.7798836961E-02, 2.6422167722E-02, 7.2104839199E-01],
	[2.5030000000E+04, 7.7266767129E-01, 1.7250558188E+00, 2.7815282772E-02, 2.6437284152E-02, 7.2109967944E-01],
	[2.5035000000E+04, 7.7290292062E-01, 1.7249882953E+00, 2.7831735024E-02, 2.6452405983E-02, 7.2115094099E-01],
	[2.5040000000E+04, 7.7313819456E-01, 1.7249207879E+00, 2.7848193720E-02, 2.6467533215E-02, 7.2120217663E-01],
	[2.5045000000E+04, 7.7337349313E-01, 1.7248532967E+00, 2.7864658859E-02, 2.6482665849E-02, 7.2125338638E-01],
	[2.5050000000E+04, 7.7360881632E-01, 1.7247858215E+00, 2.7881130443E-02, 2.6497803885E-02, 7.2130457025E-01],
	[2.5055000000E+04, 7.7384416412E-01, 1.7247183625E+00, 2.7897608474E-02, 2.6512947325E-02, 7.2135572825E-01],
	[2.5060000000E+04, 7.7407953654E-01, 1.7246509195E+00, 2.7914092953E-02, 2.6528096168E-02, 7.2140686038E-01],
	[2.5065000000E+04, 7.7431493357E-01, 1.7245834927E+00, 2.7930583881E-02, 2.6543250416E-02, 7.2145796667E-01],
	[2.5070000000E+04, 7.7455035521E-01, 1.7245160819E+00, 2.7947081259E-02, 2.6558410068E-02, 7.2150904712E-01],
	[2.5075000000E+04, 7.7478580146E-01, 1.7244486872E+00, 2.7963585088E-02, 2.6573575126E-02, 7.2156010175E-01],
	[2.5080000000E+04, 7.7502127232E-01, 1.7243813086E+00, 2.7980095370E-02, 2.6588745591E-02, 7.2161113055E-01],
	[2.5085000000E+04, 7.7525676777E-01, 1.7243139461E+00, 2.7996612106E-02, 2.6603921462E-02, 7.2166213355E-01],
	[2.5090000000E+04, 7.7549248846E-01, 1.7242468035E+00, 2.8013135297E-02, 2.6619103026E-02, 7.2171311076E-01],
	[2.5095000000E+04, 7.7572945855E-01, 1.7241809209E+00, 2.8029664944E-02, 2.6634291738E-02, 7.2176406218E-01],
	[2.5100000000E+04, 7.7596645383E-01, 1.7241150541E+00, 2.8046201049E-02, 2.6649485863E-02, 7.2181498782E-01],
	[2.5105000000E+04, 7.7620347428E-01, 1.7240492028E+00, 2.8062743613E-02, 2.6664685400E-02, 7.2186588771E-01],
	[2.5110000000E+04, 7.7644051991E-01, 1.7239833672E+00, 2.8079292637E-02, 2.6679890350E-02, 7.2191676184E-01],
	[2.5115000000E+04, 7.7667759072E-01, 1.7239175473E+00, 2.8095848122E-02, 2.6695100714E-02, 7.2196761022E-01],
	[2.5120000000E+04, 7.7691468669E-01, 1.7238517429E+00, 2.8112410070E-02, 2.6710316492E-02, 7.2201843288E-01],
	[2.5125000000E+04, 7.7715180783E-01, 1.7237859541E+00, 2.8128978482E-02, 2.6725537684E-02, 7.2206922982E-01],
	[2.5130000000E+04, 7.7738895414E-01, 1.7237201810E+00, 2.8145553358E-02, 2.6740764293E-02, 7.2212000105E-01],
	[2.5135000000E+04, 7.7762612562E-01, 1.7236544234E+00, 2.8162134701E-02, 2.6755996317E-02, 7.2217074658E-01],
	[2.5140000000E+04, 7.7786332225E-01, 1.7235886814E+00, 2.8178722512E-02, 2.6771233758E-02, 7.2222146642E-01],
	[2.5145000000E+04, 7.7810054404E-01, 1.7235229550E+00, 2.8195316791E-02, 2.6786476616E-02, 7.2227216058E-01],
	[2.5150000000E+04, 7.7833779099E-01, 1.7234572442E+00, 2.8211917540E-02, 2.6801724893E-02, 7.2232282908E-01],
	[2.5155000000E+04, 7.7857506310E-01, 1.7233915489E+00, 2.8228524760E-02, 2.6816978587E-02, 7.2237347192E-01],
	[2.5160000000E+04, 7.7881236036E-01, 1.7233258692E+00, 2.8245138453E-02, 2.6832237701E-02, 7.2242408912E-01],
	[2.5165000000E+04, 7.7904968276E-01, 1.7232602051E+00, 2.8261758619E-02, 2.6847502235E-02, 7.2247468068E-01],
	[2.5170000000E+04, 7.7928703032E-01, 1.7231945565E+00, 2.8278385260E-02, 2.6862772189E-02, 7.2252524663E-01],
	[2.5175000000E+04, 7.7952440302E-01, 1.7231289234E+00, 2.8295018378E-02, 2.6878047563E-02, 7.2257578695E-01],
	[2.5180000000E+04, 7.7976180086E-01, 1.7230633059E+00, 2.8311657973E-02, 2.6893328360E-02, 7.2262630168E-01],
	[2.5185000000E+04, 7.7999922385E-01, 1.7229977039E+00, 2.8328304046E-02, 2.6908614578E-02, 7.2267679082E-01],
	[2.5190000000E+04, 7.8023667197E-01, 1.7229321174E+00, 2.8344956599E-02, 2.6923906219E-02, 7.2272725438E-01],
	[2.5195000000E+04, 7.8047414523E-01, 1.7228665465E+00, 2.8361615634E-02, 2.6939203284E-02, 7.2277769237E-01],
	[2.5200000000E+04, 7.8071164362E-01, 1.7228009910E+00, 2.8378281150E-02, 2.6954505772E-02, 7.2282810480E-01],
	[2.5205000000E+04, 7.8094916714E-01, 1.7227354511E+00, 2.8394953151E-02, 2.6969813685E-02, 7.2287849168E-01],
	[2.5210000000E+04, 7.8118671579E-01, 1.7226699266E+00, 2.8411631636E-02, 2.6985127023E-02, 7.2292885303E-01],
	[2.5215000000E+04, 7.8142428957E-01, 1.7226044176E+00, 2.8428316607E-02, 2.7000445787E-02, 7.2297918885E-01],
	[2.5220000000E+04, 7.8166188847E-01, 1.7225389241E+00, 2.8445008065E-02, 2.7015769977E-02, 7.2302949916E-01],
	[2.5225000000E+04, 7.8189951250E-01, 1.7224734461E+00, 2.8461706012E-02, 2.7031099594E-02, 7.2307978396E-01],
	[2.5230000000E+04, 7.8213716164E-01, 1.7224079835E+00, 2.8478410448E-02, 2.7046434639E-02, 7.2313004327E-01],
	[2.5235000000E+04, 7.8237483590E-01, 1.7223425364E+00, 2.8495121376E-02, 2.7061775111E-02, 7.2318027710E-01],
	[2.5240000000E+04, 7.8261253528E-01, 1.7222771048E+00, 2.8511838796E-02, 2.7077121013E-02, 7.2323048546E-01],
	[2.5245000000E+04, 7.8285025977E-01, 1.7222116886E+00, 2.8528562709E-02, 2.7092472344E-02, 7.2328066835E-01],
	[2.5250000000E+04, 7.8308800937E-01, 1.7221462878E+00, 2.8545293117E-02, 2.7107829105E-02, 7.2333082580E-01],
	[2.5255000000E+04, 7.8332578407E-01, 1.7220809025E+00, 2.8562030021E-02, 2.7123191296E-02, 7.2338095781E-01],
	[2.5260000000E+04, 7.8356358389E-01, 1.7220155325E+00, 2.8578773421E-02, 2.7138558918E-02, 7.2343106440E-01],
	[2.5265000000E+04, 7.8380140880E-01, 1.7219501781E+00, 2.8595523321E-02, 2.7153931973E-02, 7.2348114556E-01],
	[2.5270000000E+04, 7.8403925882E-01, 1.7218848390E+00, 2.8612279720E-02, 2.7169310459E-02, 7.2353120132E-01],
	[2.5275000000E+04, 7.8427713394E-01, 1.7218195153E+00, 2.8629042619E-02, 2.7184694379E-02, 7.2358123169E-01],
	[2.5280000000E+04, 7.8451503415E-01, 1.7217542070E+00, 2.8645812021E-02, 2.7200083732E-02, 7.2363123667E-01],
	[2.5285000000E+04, 7.8475295946E-01, 1.7216889142E+00, 2.8662587926E-02, 2.7215478519E-02, 7.2368121628E-01],
	[2.5290000000E+04, 7.8499090985E-01, 1.7216236367E+00, 2.8679370336E-02, 2.7230878741E-02, 7.2373117052E-01],
	[2.5295000000E+04, 7.8522888534E-01, 1.7215583745E+00, 2.8696159252E-02, 2.7246284398E-02, 7.2378109942E-01],
	[2.5300000000E+04, 7.8546688592E-01, 1.7214931278E+00, 2.8712954674E-02, 2.7261695491E-02, 7.2383100297E-01],
	[2.5305000000E+04, 7.8570491158E-01, 1.7214278964E+00, 2.8729756605E-02, 2.7277112020E-02, 7.2388088120E-01],
	[2.5310000000E+04, 7.8594296232E-01, 1.7213626804E+00, 2.8746565045E-02, 2.7292533987E-02, 7.2393073411E-01],
	[2.5315000000E+04, 7.8618103814E-01, 1.7212974797E+00, 2.8763379996E-02, 2.7307961392E-02, 7.2398056171E-01],
	[2.5320000000E+04, 7.8641913904E-01, 1.7212322944E+00, 2.8780201459E-02, 2.7323394234E-02, 7.2403036401E-01],
	[2.5325000000E+04, 7.8665726502E-01, 1.7211671244E+00, 2.8797029436E-02, 2.7338832516E-02, 7.2408014103E-01],
	[2.5330000000E+04, 7.8689541607E-01, 1.7211019698E+00, 2.8813863926E-02, 2.7354276237E-02, 7.2412989278E-01],
	[2.5335000000E+04, 7.8713359219E-01, 1.7210368304E+00, 2.8830704933E-02, 2.7369725399E-02, 7.2417961926E-01],
	[2.5340000000E+04, 7.8737179338E-01, 1.7209717064E+00, 2.8847552456E-02, 2.7385180000E-02, 7.2422932048E-01],
	[2.5345000000E+04, 7.8761001964E-01, 1.7209065977E+00, 2.8864406497E-02, 2.7400640044E-02, 7.2427899647E-01],
	[2.5350000000E+04, 7.8784827096E-01, 1.7208415043E+00, 2.8881267058E-02, 2.7416105529E-02, 7.2432864723E-01],
	[2.5355000000E+04, 7.8808654734E-01, 1.7207764262E+00, 2.8898134140E-02, 2.7431576456E-02, 7.2437827276E-01],
	[2.5360000000E+04, 7.8832484878E-01, 1.7207113634E+00, 2.8915007743E-02, 2.7447052827E-02, 7.2442787309E-01],
	[2.5365000000E+04, 7.8856317528E-01, 1.7206463159E+00, 2.8931887869E-02, 2.7462534641E-02, 7.2447744822E-01],
	[2.5370000000E+04, 7.8880152683E-01, 1.7205812837E+00, 2.8948774520E-02, 2.7478021900E-02, 7.2452699816E-01],
	[2.5375000000E+04, 7.8903990344E-01, 1.7205162667E+00, 2.8965667696E-02, 2.7493514603E-02, 7.2457652293E-01],
	[2.5380000000E+04, 7.8927830509E-01, 1.7204512650E+00, 2.8982567399E-02, 2.7509012752E-02, 7.2462602254E-01],
	[2.5385000000E+04, 7.8951673180E-01, 1.7203862786E+00, 2.8999473630E-02, 2.7524516347E-02, 7.2467549699E-01],
	[2.5390000000E+04, 7.8975518354E-01, 1.7203213074E+00, 2.9016386390E-02, 2.7540025388E-02, 7.2472494629E-01],
	[2.5395000000E+04, 7.8999366034E-01, 1.7202563515E+00, 2.9033305681E-02, 2.7555539877E-02, 7.2477437047E-01],
	[2.5400000000E+04, 7.9023216217E-01, 1.7201914108E+00, 2.9050231504E-02, 2.7571059814E-02, 7.2482376952E-01],
	[2.5405000000E+04, 7.9047068904E-01, 1.7201264853E+00, 2.9067163859E-02, 2.7586585199E-02, 7.2487314347E-01],
	[2.5410000000E+04, 7.9070924095E-01, 1.7200615751E+00, 2.9084102749E-02, 2.7602116032E-02, 7.2492249231E-01],
	[2.5415000000E+04, 7.9094781789E-01, 1.7199966801E+00, 2.9101048174E-02, 2.7617652316E-02, 7.2497181607E-01],
	[2.5420000000E+04, 7.9118641987E-01, 1.7199318003E+00, 2.9118000136E-02, 2.7633194049E-02, 7.2502111475E-01],
	[2.5425000000E+04, 7.9142504687E-01, 1.7198669357E+00, 2.9134958635E-02, 2.7648741234E-02, 7.2507038837E-01],
	[2.5430000000E+04, 7.9166369890E-01, 1.7198020863E+00, 2.9151923674E-02, 2.7664293870E-02, 7.2511963693E-01],
	[2.5435000000E+04, 7.9190237596E-01, 1.7197372521E+00, 2.9168895254E-02, 2.7679851957E-02, 7.2516886045E-01],
	[2.5440000000E+04, 7.9214107804E-01, 1.7196724331E+00, 2.9185873374E-02, 2.7695415497E-02, 7.2521805894E-01],
	[2.5445000000E+04, 7.9237980514E-01, 1.7196076292E+00, 2.9202858038E-02, 2.7710984491E-02, 7.2526723240E-01],
	[2.5450000000E+04, 7.9261855726E-01, 1.7195428406E+00, 2.9219849246E-02, 2.7726558938E-02, 7.2531638086E-01],
	[2.5455000000E+04, 7.9285733439E-01, 1.7194780671E+00, 2.9236846999E-02, 2.7742138839E-02, 7.2536550431E-01],
	[2.5460000000E+04, 7.9309613654E-01, 1.7194133087E+00, 2.9253851299E-02, 2.7757724195E-02, 7.2541460278E-01],
	[2.5465000000E+04, 7.9333496369E-01, 1.7193485656E+00, 2.9270862146E-02, 2.7773315007E-02, 7.2546367627E-01],
	[2.5470000000E+04, 7.9357381586E-01, 1.7192838375E+00, 2.9287879542E-02, 2.7788911275E-02, 7.2551272479E-01],
	[2.5475000000E+04, 7.9381269303E-01, 1.7192191246E+00, 2.9304903489E-02, 2.7804512999E-02, 7.2556174836E-01],
	[2.5480000000E+04, 7.9405159521E-01, 1.7191544269E+00, 2.9321933987E-02, 2.7820120181E-02, 7.2561074698E-01],
	[2.5485000000E+04, 7.9429052239E-01, 1.7190897443E+00, 2.9338971038E-02, 2.7835732820E-02, 7.2565972067E-01],
	[2.5490000000E+04, 7.9452947457E-01, 1.7190250768E+00, 2.9356014643E-02, 2.7851350918E-02, 7.2570866944E-01],
	[2.5495000000E+04, 7.9476894152E-01, 1.7189609348E+00, 2.9373064803E-02, 2.7866975211E-02, 7.2575759330E-01],
	[2.5500000000E+04, 7.9500930425E-01, 1.7188977147E+00, 2.9390121520E-02, 2.7882606274E-02, 7.2580649226E-01],
	[2.5505000000E+04, 7.9524969252E-01, 1.7188345093E+00, 2.9407184794E-02, 2.7898242801E-02, 7.2585536633E-01],
	[2.5510000000E+04, 7.9549010634E-01, 1.7187713187E+00, 2.9424254627E-02, 2.7913884791E-02, 7.2590421553E-01],
	[2.5515000000E+04, 7.9573054570E-01, 1.7187081427E+00, 2.9441331020E-02, 2.7929532247E-02, 7.2595303985E-01],
	[2.5520000000E+04, 7.9597101061E-01, 1.7186449815E+00, 2.9458413975E-02, 2.7945185167E-02, 7.2600183932E-01],
	[2.5525000000E+04, 7.9621150104E-01, 1.7185818349E+00, 2.9475503492E-02, 2.7960843553E-02, 7.2605061395E-01],
	[2.5530000000E+04, 7.9645201702E-01, 1.7185187031E+00, 2.9492599573E-02, 2.7976507405E-02, 7.2609936374E-01],
	[2.5535000000E+04, 7.9669255852E-01, 1.7184555859E+00, 2.9509702219E-02, 2.7992176724E-02, 7.2614808872E-01],
	[2.5540000000E+04, 7.9693312556E-01, 1.7183924834E+00, 2.9526811432E-02, 2.8007851511E-02, 7.2619678888E-01],
	[2.5545000000E+04, 7.9717371813E-01, 1.7183293955E+00, 2.9543927212E-02, 2.8023531766E-02, 7.2624546424E-01],
	[2.5550000000E+04, 7.9741433622E-01, 1.7182663224E+00, 2.9561049560E-02, 2.8039217489E-02, 7.2629411481E-01],
	[2.5555000000E+04, 7.9765497983E-01, 1.7182032638E+00, 2.9578178479E-02, 2.8054908682E-02, 7.2634274060E-01],
	[2.5560000000E+04, 7.9789564896E-01, 1.7181402200E+00, 2.9595313969E-02, 2.8070605344E-02, 7.2639134163E-01],
	[2.5565000000E+04, 7.9813634362E-01, 1.7180771908E+00, 2.9612456032E-02, 2.8086307477E-02, 7.2643991790E-01],
	[2.5570000000E+04, 7.9837706379E-01, 1.7180141762E+00, 2.9629604668E-02, 2.8102015081E-02, 7.2648846943E-01],
	[2.5575000000E+04, 7.9861780947E-01, 1.7179511762E+00, 2.9646759879E-02, 2.8117728157E-02, 7.2653699623E-01],
	[2.5580000000E+04, 7.9885858067E-01, 1.7178881909E+00, 2.9663921667E-02, 2.8133446704E-02, 7.2658549830E-01],
	[2.5585000000E+04, 7.9909937738E-01, 1.7178252202E+00, 2.9681090031E-02, 2.8149170725E-02, 7.2663397566E-01],
	[2.5590000000E+04, 7.9934019959E-01, 1.7177622641E+00, 2.9698264975E-02, 2.8164900218E-02, 7.2668242832E-01],
	[2.5595000000E+04, 7.9958104731E-01, 1.7176993226E+00, 2.9715446498E-02, 2.8180635186E-02, 7.2673085630E-01],
	[2.5600000000E+04, 7.9982192054E-01, 1.7176363957E+00, 2.9732634603E-02, 2.8196375628E-02, 7.2677925959E-01],
	[2.5605000000E+04, 8.0006281926E-01, 1.7175734834E+00, 2.9749829289E-02, 2.8212121545E-02, 7.2682763822E-01],
	[2.5610000000E+04, 8.0030374348E-01, 1.7175105857E+00, 2.9767030560E-02, 2.8227872938E-02, 7.2687599220E-01],
	[2.5615000000E+04, 8.0054469320E-01, 1.7174477025E+00, 2.9784238415E-02, 2.8243629807E-02, 7.2692432153E-01],
	[2.5620000000E+04, 8.0078566841E-01, 1.7173848340E+00, 2.9801452856E-02, 2.8259392153E-02, 7.2697262623E-01],
	[2.5625000000E+04, 8.0102666911E-01, 1.7173219800E+00, 2.9818673885E-02, 2.8275159977E-02, 7.2702090630E-01],
	[2.5630000000E+04, 8.0126769531E-01, 1.7172591406E+00, 2.9835901502E-02, 2.8290933278E-02, 7.2706916177E-01],
	[2.5635000000E+04, 8.0150874699E-01, 1.7171963157E+00, 2.9853135709E-02, 2.8306712058E-02, 7.2711739263E-01],
	[2.5640000000E+04, 8.0174982415E-01, 1.7171335054E+00, 2.9870376507E-02, 2.8322496317E-02, 7.2716559891E-01],
	[2.5645000000E+04, 8.0199092680E-01, 1.7170707096E+00, 2.9887623897E-02, 2.8338286056E-02, 7.2721378061E-01],
	[2.5650000000E+04, 8.0223205492E-01, 1.7170079284E+00, 2.9904877881E-02, 2.8354081275E-02, 7.2726193775E-01],
	[2.5655000000E+04, 8.0247320853E-01, 1.7169451617E+00, 2.9922138459E-02, 2.8369881975E-02, 7.2731007033E-01],
	[2.5660000000E+04, 8.0271438761E-01, 1.7168824095E+00, 2.9939405634E-02, 2.8385688156E-02, 7.2735817836E-01],
	[2.5665000000E+04, 8.0295559216E-01, 1.7168196718E+00, 2.9956679405E-02, 2.8401499820E-02, 7.2740626187E-01],
	[2.5670000000E+04, 8.0319682219E-01, 1.7167569487E+00, 2.9973959775E-02, 2.8417316966E-02, 7.2745432085E-01],
	[2.5675000000E+04, 8.0343807768E-01, 1.7166942401E+00, 2.9991246745E-02, 2.8433139595E-02, 7.2750235532E-01],
	[2.5680000000E+04, 8.0367935864E-01, 1.7166315459E+00, 3.0008540315E-02, 2.8448967709E-02, 7.2755036529E-01],
	[2.5685000000E+04, 8.0392066507E-01, 1.7165688663E+00, 3.0025840488E-02, 2.8464801306E-02, 7.2759835078E-01],
	[2.5690000000E+04, 8.0416199695E-01, 1.7165062011E+00, 3.0043147263E-02, 2.8480640389E-02, 7.2764631179E-01],
	[2.5695000000E+04, 8.0440335430E-01, 1.7164435504E+00, 3.0060460644E-02, 2.8496484957E-02, 7.2769424833E-01],
	[2.5700000000E+04, 8.0464473710E-01, 1.7163809142E+00, 3.0077780630E-02, 2.8512335011E-02, 7.2774216042E-01],
	[2.5705000000E+04, 8.0488614536E-01, 1.7163182925E+00, 3.0095107224E-02, 2.8528190552E-02, 7.2779004807E-01],
	[2.5710000000E+04, 8.0512757907E-01, 1.7162556853E+00, 3.0112440425E-02, 2.8544051580E-02, 7.2783791128E-01],
	[2.5715000000E+04, 8.0536903824E-01, 1.7161930924E+00, 3.0129780236E-02, 2.8559918096E-02, 7.2788575008E-01],
	[2.5720000000E+04, 8.0561052285E-01, 1.7161305141E+00, 3.0147126658E-02, 2.8575790100E-02, 7.2793356446E-01],
	[2.5725000000E+04, 8.0585203290E-01, 1.7160679502E+00, 3.0164479692E-02, 2.8591667593E-02, 7.2798135445E-01],
	[2.5730000000E+04, 8.0609356840E-01, 1.7160054007E+00, 3.0181839339E-02, 2.8607550576E-02, 7.2802912005E-01],
	[2.5735000000E+04, 8.0633512935E-01, 1.7159428657E+00, 3.0199205601E-02, 2.8623439049E-02, 7.2807686127E-01],
	[2.5740000000E+04, 8.0657671573E-01, 1.7158803451E+00, 3.0216578478E-02, 2.8639333013E-02, 7.2812457813E-01],
	[2.5745000000E+04, 8.0681832755E-01, 1.7158178389E+00, 3.0233957973E-02, 2.8655232468E-02, 7.2817227063E-01],
	[2.5750000000E+04, 8.0705996480E-01, 1.7157553471E+00, 3.0251344085E-02, 2.8671137415E-02, 7.2821993880E-01],
	[2.5755000000E+04, 8.0730162749E-01, 1.7156928697E+00, 3.0268736817E-02, 2.8687047854E-02, 7.2826758263E-01],
	[2.5760000000E+04, 8.0754331560E-01, 1.7156304068E+00, 3.0286136169E-02, 2.8702963786E-02, 7.2831520214E-01],
	[2.5765000000E+04, 8.0778502915E-01, 1.7155679582E+00, 3.0303542143E-02, 2.8718885212E-02, 7.2836279735E-01],
	[2.5770000000E+04, 8.0802676812E-01, 1.7155055240E+00, 3.0320954741E-02, 2.8734812132E-02, 7.2841036825E-01],
	[2.5775000000E+04, 8.0826853251E-01, 1.7154431042E+00, 3.0338373963E-02, 2.8750744547E-02, 7.2845791487E-01],
	[2.5780000000E+04, 8.0851032232E-01, 1.7153806988E+00, 3.0355799810E-02, 2.8766682457E-02, 7.2850543722E-01],
	[2.5785000000E+04, 8.0875213756E-01, 1.7153183078E+00, 3.0373232284E-02, 2.8782625863E-02, 7.2855293530E-01],
	[2.5790000000E+04, 8.0899397821E-01, 1.7152559311E+00, 3.0390671386E-02, 2.8798574766E-02, 7.2860040913E-01],
	[2.5795000000E+04, 8.0923584427E-01, 1.7151935688E+00, 3.0408117118E-02, 2.8814529165E-02, 7.2864785872E-01],
	[2.5800000000E+04, 8.0947773575E-01, 1.7151312208E+00, 3.0425569479E-02, 2.8830489063E-02, 7.2869528408E-01],
	[2.5805000000E+04, 8.0971965264E-01, 1.7150688872E+00, 3.0443028473E-02, 2.8846454458E-02, 7.2874268522E-01],
	[2.5810000000E+04, 8.0996159493E-01, 1.7150065679E+00, 3.0460494100E-02, 2.8862425352E-02, 7.2879006215E-01],
	[2.5815000000E+04, 8.1020356263E-01, 1.7149442630E+00, 3.0477966361E-02, 2.8878401745E-02, 7.2883741489E-01],
	[2.5820000000E+04, 8.1044555574E-01, 1.7148819724E+00, 3.0495445257E-02, 2.8894383638E-02, 7.2888474344E-01],
	[2.5825000000E+04, 8.1068757424E-01, 1.7148196961E+00, 3.0512930790E-02, 2.8910371032E-02, 7.2893204782E-01],
	[2.5830000000E+04, 8.1092961814E-01, 1.7147574341E+00, 3.0530422961E-02, 2.8926363927E-02, 7.2897932803E-01],
	[2.5835000000E+04, 8.1117168744E-01, 1.7146951865E+00, 3.0547921771E-02, 2.8942362323E-02, 7.2902658409E-01],
	[2.5840000000E+04, 8.1141378214E-01, 1.7146329531E+00, 3.0565427221E-02, 2.8958366222E-02, 7.2907381602E-01],
	[2.5845000000E+04, 8.1165590222E-01, 1.7145707340E+00, 3.0582939313E-02, 2.8974375623E-02, 7.2912102381E-01],
	[2.5850000000E+04, 8.1189804770E-01, 1.7145085293E+00, 3.0600458048E-02, 2.8990390527E-02, 7.2916820749E-01],
	[2.5855000000E+04, 8.1214021856E-01, 1.7144463388E+00, 3.0617983427E-02, 2.9006410936E-02, 7.2921536706E-01],
	[2.5860000000E+04, 8.1238241481E-01, 1.7143841626E+00, 3.0635515451E-02, 2.9022436849E-02, 7.2926250254E-01],
	[2.5865000000E+04, 8.1262463644E-01, 1.7143220007E+00, 3.0653054122E-02, 2.9038468266E-02, 7.2930961393E-01],
	[2.5870000000E+04, 8.1286688345E-01, 1.7142598530E+00, 3.0670599441E-02, 2.9054505190E-02, 7.2935670125E-01],
	[2.5875000000E+04, 8.1310915584E-01, 1.7141977196E+00, 3.0688151409E-02, 2.9070547619E-02, 7.2940376451E-01],
	[2.5880000000E+04, 8.1335145361E-01, 1.7141356005E+00, 3.0705710026E-02, 2.9086595556E-02, 7.2945080371E-01],
	[2.5885000000E+04, 8.1359377674E-01, 1.7140734956E+00, 3.0723275296E-02, 2.9102648999E-02, 7.2949781888E-01],
	[2.5890000000E+04, 8.1383612526E-01, 1.7140114050E+00, 3.0740847218E-02, 2.9118707951E-02, 7.2954481002E-01],
	[2.5895000000E+04, 8.1407849914E-01, 1.7139493286E+00, 3.0758425794E-02, 2.9134772410E-02, 7.2959177715E-01],
	[2.5900000000E+04, 8.1432089839E-01, 1.7138872664E+00, 3.0776011025E-02, 2.9150842379E-02, 7.2963872027E-01],
	[2.5905000000E+04, 8.1456368194E-01, 1.7138256056E+00, 3.0793602913E-02, 2.9166918430E-02, 7.2968563940E-01],
	[2.5910000000E+04, 8.1480741914E-01, 1.7137649594E+00, 3.0811201458E-02, 2.9183001472E-02, 7.2973253454E-01],
	[2.5915000000E+04, 8.1505118222E-01, 1.7137043271E+00, 3.0828806663E-02, 2.9199090029E-02, 7.2977940571E-01],
	[2.5920000000E+04, 8.1529497118E-01, 1.7136437087E+00, 3.0846418527E-02, 2.9215184099E-02, 7.2982625293E-01],
	[2.5925000000E+04, 8.1553878602E-01, 1.7135831040E+00, 3.0864037053E-02, 2.9231283685E-02, 7.2987307619E-01],
	[2.5930000000E+04, 8.1578262673E-01, 1.7135225132E+00, 3.0881662241E-02, 2.9247388786E-02, 7.2991987552E-01],
	[2.5935000000E+04, 8.1602649331E-01, 1.7134619363E+00, 3.0899294093E-02, 2.9263499404E-02, 7.2996665092E-01],
	[2.5940000000E+04, 8.1627038576E-01, 1.7134013731E+00, 3.0916932611E-02, 2.9279615538E-02, 7.3001340241E-01],
	[2.5945000000E+04, 8.1651430407E-01, 1.7133408238E+00, 3.0934577794E-02, 2.9295737189E-02, 7.3006012999E-01],
	[2.5950000000E+04, 8.1675824825E-01, 1.7132802882E+00, 3.0952229645E-02, 2.9311864359E-02, 7.3010683368E-01],
	[2.5955000000E+04, 8.1700221830E-01, 1.7132197665E+00, 3.0969888165E-02, 2.9327997046E-02, 7.3015351349E-01],
	[2.5960000000E+04, 8.1724621420E-01, 1.7131592586E+00, 3.0987553355E-02, 2.9344135253E-02, 7.3020016943E-01],
	[2.5965000000E+04, 8.1749023596E-01, 1.7130987644E+00, 3.1005225216E-02, 2.9360278979E-02, 7.3024680151E-01],
	[2.5970000000E+04, 8.1773428357E-01, 1.7130382841E+00, 3.1022903749E-02, 2.9376428225E-02, 7.3029340975E-01],
	[2.5975000000E+04, 8.1797835704E-01, 1.7129778175E+00, 3.1040588957E-02, 2.9392582992E-02, 7.3033999414E-01],
	[2.5980000000E+04, 8.1822245636E-01, 1.7129173647E+00, 3.1058280839E-02, 2.9408743280E-02, 7.3038655472E-01],
	[2.5985000000E+04, 8.1846658153E-01, 1.7128569256E+00, 3.1075979397E-02, 2.9424909090E-02, 7.3043309148E-01],
	[2.5990000000E+04, 8.1871073255E-01, 1.7127965003E+00, 3.1093684633E-02, 2.9441080422E-02, 7.3047960444E-01],
	[2.5995000000E+04, 8.1895490941E-01, 1.7127360888E+00, 3.1111396547E-02, 2.9457257277E-02, 7.3052609361E-01],
	[2.6000000000E+04, 8.1919911211E-01, 1.7126756910E+00, 3.1129115142E-02, 2.9473439656E-02, 7.3057255899E-01],
	[2.6005000000E+04, 8.1944334065E-01, 1.7126153070E+00, 3.1146840417E-02, 2.9489627558E-02, 7.3061900061E-01],
	[2.6010000000E+04, 8.1968759503E-01, 1.7125549367E+00, 3.1164572375E-02, 2.9505820986E-02, 7.3066541848E-01],
	[2.6015000000E+04, 8.1993187525E-01, 1.7124945801E+00, 3.1182311016E-02, 2.9522019938E-02, 7.3071181260E-01],
	[2.6020000000E+04, 8.2017618129E-01, 1.7124342372E+00, 3.1200056342E-02, 2.9538224416E-02, 7.3075818298E-01],
	[2.6025000000E+04, 8.2042051317E-01, 1.7123739081E+00, 3.1217808354E-02, 2.9554434421E-02, 7.3080452964E-01],
	[2.6030000000E+04, 8.2066487088E-01, 1.7123135927E+00, 3.1235567054E-02, 2.9570649952E-02, 7.3085085259E-01],
	[2.6035000000E+04, 8.2090925441E-01, 1.7122532910E+00, 3.1253332442E-02, 2.9586871011E-02, 7.3089715184E-01],
	[2.6040000000E+04, 8.2115366377E-01, 1.7121930030E+00, 3.1271104519E-02, 2.9603097597E-02, 7.3094342740E-01],
	[2.6045000000E+04, 8.2139809895E-01, 1.7121327287E+00, 3.1288883288E-02, 2.9619329713E-02, 7.3098967928E-01],
	[2.6050000000E+04, 8.2164255995E-01, 1.7120724681E+00, 3.1306668749E-02, 2.9635567357E-02, 7.3103590750E-01],
	[2.6055000000E+04, 8.2188704677E-01, 1.7120122212E+00, 3.1324460903E-02, 2.9651810531E-02, 7.3108211206E-01],
	[2.6060000000E+04, 8.2213155940E-01, 1.7119519879E+00, 3.1342259752E-02, 2.9668059235E-02, 7.3112829298E-01],
	[2.6065000000E+04, 8.2237609784E-01, 1.7118917683E+00, 3.1360065297E-02, 2.9684313470E-02, 7.3117445026E-01],
	[2.6070000000E+04, 8.2262066210E-01, 1.7118315624E+00, 3.1377877539E-02, 2.9700573236E-02, 7.3122058392E-01],
	[2.6075000000E+04, 8.2286525217E-01, 1.7117713702E+00, 3.1395696479E-02, 2.9716838535E-02, 7.3126669398E-01],
	[2.6080000000E+04, 8.2310986804E-01, 1.7117111916E+00, 3.1413522119E-02, 2.9733109365E-02, 7.3131278043E-01],
	[2.6085000000E+04, 8.2335450971E-01, 1.7116510267E+00, 3.1431354460E-02, 2.9749385729E-02, 7.3135884330E-01],
	[2.6090000000E+04, 8.2359917719E-01, 1.7115908754E+00, 3.1449193503E-02, 2.9765667626E-02, 7.3140488259E-01],
	[2.6095000000E+04, 8.2384387047E-01, 1.7115307377E+00, 3.1467039250E-02, 2.9781955058E-02, 7.3145089831E-01],
	[2.6100000000E+04, 8.2408858954E-01, 1.7114706137E+00, 3.1484891700E-02, 2.9798248024E-02, 7.3149689049E-01],
	[2.6105000000E+04, 8.2433333441E-01, 1.7114105033E+00, 3.1502750857E-02, 2.9814546525E-02, 7.3154285912E-01],
	[2.6110000000E+04, 8.2457810507E-01, 1.7113504066E+00, 3.1520616721E-02, 2.9830850563E-02, 7.3158880422E-01],
	[2.6115000000E+04, 8.2482290153E-01, 1.7112903234E+00, 3.1538489293E-02, 2.9847160136E-02, 7.3163472580E-01],
	[2.6120000000E+04, 8.2506772377E-01, 1.7112302539E+00, 3.1556368574E-02, 2.9863475247E-02, 7.3168062387E-01],
	[2.6125000000E+04, 8.2531257180E-01, 1.7111701980E+00, 3.1574254566E-02, 2.9879795895E-02, 7.3172649845E-01],
	[2.6130000000E+04, 8.2555744561E-01, 1.7111101556E+00, 3.1592147270E-02, 2.9896122081E-02, 7.3177234954E-01],
	[2.6135000000E+04, 8.2580234520E-01, 1.7110501269E+00, 3.1610046687E-02, 2.9912453805E-02, 7.3181817716E-01],
	[2.6140000000E+04, 8.2604727058E-01, 1.7109901118E+00, 3.1627952819E-02, 2.9928791069E-02, 7.3186398131E-01],
	[2.6145000000E+04, 8.2629222173E-01, 1.7109301102E+00, 3.1645865666E-02, 2.9945133873E-02, 7.3190976201E-01],
	[2.6150000000E+04, 8.2653719866E-01, 1.7108701222E+00, 3.1663785230E-02, 2.9961482216E-02, 7.3195551927E-01],
	[2.6155000000E+04, 8.2678220136E-01, 1.7108101478E+00, 3.1681711513E-02, 2.9977836101E-02, 7.3200125309E-01],
	[2.6160000000E+04, 8.2702722983E-01, 1.7107501869E+00, 3.1699644514E-02, 2.9994195527E-02, 7.3204696350E-01],
	[2.6165000000E+04, 8.2727228407E-01, 1.7106902397E+00, 3.1717584237E-02, 3.0010560495E-02, 7.3209265048E-01],
	[2.6170000000E+04, 8.2751736407E-01, 1.7106303059E+00, 3.1735530681E-02, 3.0026931005E-02, 7.3213831407E-01],
	[2.6175000000E+04, 8.2776246984E-01, 1.7105703857E+00, 3.1753483848E-02, 3.0043307059E-02, 7.3218395426E-01],
	[2.6180000000E+04, 8.2800760137E-01, 1.7105104791E+00, 3.1771443739E-02, 3.0059688655E-02, 7.3222957106E-01],
	[2.6185000000E+04, 8.2825275866E-01, 1.7104505860E+00, 3.1789410356E-02, 3.0076075797E-02, 7.3227516449E-01],
	[2.6190000000E+04, 8.2849794171E-01, 1.7103907064E+00, 3.1807383700E-02, 3.0092468482E-02, 7.3232073455E-01],
	[2.6195000000E+04, 8.2874315052E-01, 1.7103308404E+00, 3.1825363772E-02, 3.0108866713E-02, 7.3236628126E-01],
	[2.6200000000E+04, 8.2898838508E-01, 1.7102709878E+00, 3.1843350572E-02, 3.0125270490E-02, 7.3241180462E-01],
	[2.6205000000E+04, 8.2923364538E-01, 1.7102111488E+00, 3.1861344104E-02, 3.0141679813E-02, 7.3245730465E-01],
	[2.6210000000E+04, 8.2947893144E-01, 1.7101513233E+00, 3.1879344367E-02, 3.0158094684E-02, 7.3250278135E-01],
	[2.6215000000E+04, 8.2972424325E-01, 1.7100915113E+00, 3.1897351363E-02, 3.0174515101E-02, 7.3254823473E-01],
	[2.6220000000E+04, 8.2996958079E-01, 1.7100317128E+00, 3.1915365093E-02, 3.0190941067E-02, 7.3259366480E-01],
	[2.6225000000E+04, 8.3021494408E-01, 1.7099719278E+00, 3.1933385558E-02, 3.0207372581E-02, 7.3263907158E-01],
	[2.6230000000E+04, 8.3046033311E-01, 1.7099121563E+00, 3.1951412761E-02, 3.0223809644E-02, 7.3268445507E-01],
	[2.6235000000E+04, 8.3070574788E-01, 1.7098523983E+00, 3.1969446701E-02, 3.0240252257E-02, 7.3272981528E-01],
	[2.6240000000E+04, 8.3095118838E-01, 1.7097926537E+00, 3.1987487380E-02, 3.0256700420E-02, 7.3277515223E-01],
	[2.6245000000E+04, 8.3119665462E-01, 1.7097329226E+00, 3.2005534799E-02, 3.0273154134E-02, 7.3282046591E-01],
	[2.6250000000E+04, 8.3144214659E-01, 1.7096732050E+00, 3.2023588960E-02, 3.0289613399E-02, 7.3286575635E-01],
	[2.6255000000E+04, 8.3168766428E-01, 1.7096135008E+00, 3.2041649864E-02, 3.0306078216E-02, 7.3291102355E-01],
	[2.6260000000E+04, 8.3193320771E-01, 1.7095538101E+00, 3.2059717512E-02, 3.0322548586E-02, 7.3295626752E-01],
	[2.6265000000E+04, 8.3217877685E-01, 1.7094941328E+00, 3.2077791905E-02, 3.0339024508E-02, 7.3300148827E-01],
	[2.6270000000E+04, 8.3242437172E-01, 1.7094344690E+00, 3.2095873044E-02, 3.0355505984E-02, 7.3304668581E-01],
	[2.6275000000E+04, 8.3266999231E-01, 1.7093748186E+00, 3.2113960931E-02, 3.0371993014E-02, 7.3309186015E-01],
	[2.6280000000E+04, 8.3291563862E-01, 1.7093151817E+00, 3.2132055568E-02, 3.0388485599E-02, 7.3313701130E-01],
	[2.6285000000E+04, 8.3316131064E-01, 1.7092555581E+00, 3.2150156954E-02, 3.0404983738E-02, 7.3318213928E-01],
	[2.6290000000E+04, 8.3340700838E-01, 1.7091959480E+00, 3.2168265092E-02, 3.0421487434E-02, 7.3322724408E-01],
	[2.6295000000E+04, 8.3365273183E-01, 1.7091363513E+00, 3.2186379982E-02, 3.0437996685E-02, 7.3327232572E-01],
	[2.6300000000E+04, 8.3389848098E-01, 1.7090767680E+00, 3.2204501627E-02, 3.0454511494E-02, 7.3331738421E-01],
	[2.6305000000E+04, 8.3414425585E-01, 1.7090171981E+00, 3.2222630026E-02, 3.0471031860E-02, 7.3336241956E-01],
	[2.6310000000E+04, 8.3439005642E-01, 1.7089576417E+00, 3.2240765182E-02, 3.0487557783E-02, 7.3340743178E-01],
	[2.6315000000E+04, 8.3463588269E-01, 1.7088980986E+00, 3.2258907096E-02, 3.0504089265E-02, 7.3345242088E-01],
	[2.6320000000E+04, 8.3488173466E-01, 1.7088385689E+00, 3.2277055768E-02, 3.0520626306E-02, 7.3349738687E-01],
	[2.6325000000E+04, 8.3512867496E-01, 1.7087802433E+00, 3.2295211200E-02, 3.0537170708E-02, 7.3354232976E-01],
	[2.6330000000E+04, 8.3537579134E-01, 1.7087220987E+00, 3.2313373394E-02, 3.0553720927E-02, 7.3358724956E-01],
	[2.6335000000E+04, 8.3562293389E-01, 1.7086639672E+00, 3.2331542350E-02, 3.0570276710E-02, 7.3363214627E-01],
	[2.6340000000E+04, 8.3587010263E-01, 1.7086058487E+00, 3.2349718070E-02, 3.0586838056E-02, 7.3367701991E-01],
	[2.6345000000E+04, 8.3611729753E-01, 1.7085477432E+00, 3.2367900555E-02, 3.0603404968E-02, 7.3372187049E-01],
	[2.6350000000E+04, 8.3636451861E-01, 1.7084896507E+00, 3.2386089806E-02, 3.0619977445E-02, 7.3376669802E-01],
	[2.6355000000E+04, 8.3661176586E-01, 1.7084315712E+00, 3.2404285825E-02, 3.0636555488E-02, 7.3381150251E-01],
	[2.6360000000E+04, 8.3685903928E-01, 1.7083735047E+00, 3.2422488612E-02, 3.0653139098E-02, 7.3385628396E-01],
	[2.6365000000E+04, 8.3710633886E-01, 1.7083154511E+00, 3.2440698169E-02, 3.0669728274E-02, 7.3390104240E-01],
	[2.6370000000E+04, 8.3735366461E-01, 1.7082574106E+00, 3.2458914498E-02, 3.0686323019E-02, 7.3394577782E-01],
	[2.6375000000E+04, 8.3760101652E-01, 1.7081993830E+00, 3.2477137598E-02, 3.0702923331E-02, 7.3399049023E-01],
	[2.6380000000E+04, 8.3784839459E-01, 1.7081413684E+00, 3.2495367473E-02, 3.0719529212E-02, 7.3403517966E-01],
	[2.6385000000E+04, 8.3809579881E-01, 1.7080833668E+00, 3.2513604122E-02, 3.0736140662E-02, 7.3407984610E-01],
	[2.6390000000E+04, 8.3834322919E-01, 1.7080253781E+00, 3.2531847547E-02, 3.0752757682E-02, 7.3412448957E-01],
	[2.6395000000E+04, 8.3859068573E-01, 1.7079674024E+00, 3.2550097750E-02, 3.0769380272E-02, 7.3416911008E-01],
	[2.6400000000E+04, 8.3883816841E-01, 1.7079094396E+00, 3.2568354731E-02, 3.0786008433E-02, 7.3421370763E-01],
	[2.6405000000E+04, 8.3908567724E-01, 1.7078514897E+00, 3.2586618492E-02, 3.0802642166E-02, 7.3425828224E-01],
	[2.6410000000E+04, 8.3933321222E-01, 1.7077935529E+00, 3.2604889034E-02, 3.0819281470E-02, 7.3430283392E-01],
	[2.6415000000E+04, 8.3958077334E-01, 1.7077356289E+00, 3.2623166359E-02, 3.0835926347E-02, 7.3434736268E-01],
	[2.6420000000E+04, 8.3982836061E-01, 1.7076777179E+00, 3.2641450466E-02, 3.0852576797E-02, 7.3439186852E-01],
	[2.6425000000E+04, 8.4007597401E-01, 1.7076198197E+00, 3.2659741359E-02, 3.0869232820E-02, 7.3443635146E-01],
	[2.6430000000E+04, 8.4032361355E-01, 1.7075619345E+00, 3.2678039037E-02, 3.0885894418E-02, 7.3448081150E-01],
	[2.6435000000E+04, 8.4057127923E-01, 1.7075040623E+00, 3.2696343503E-02, 3.0902561590E-02, 7.3452524866E-01],
	[2.6440000000E+04, 8.4081897104E-01, 1.7074462029E+00, 3.2714654757E-02, 3.0919234337E-02, 7.3456966295E-01],
	[2.6445000000E+04, 8.4106668898E-01, 1.7073883564E+00, 3.2732972801E-02, 3.0935912660E-02, 7.3461405438E-01],
	[2.6450000000E+04, 8.4131443305E-01, 1.7073305228E+00, 3.2751297635E-02, 3.0952596560E-02, 7.3465842295E-01],
	[2.6455000000E+04, 8.4156220325E-01, 1.7072727021E+00, 3.2769629262E-02, 3.0969286036E-02, 7.3470276868E-01],
	[2.6460000000E+04, 8.4180999957E-01, 1.7072148943E+00, 3.2787967682E-02, 3.0985981090E-02, 7.3474709157E-01],
	[2.6465000000E+04, 8.4205782201E-01, 1.7071570994E+00, 3.2806312897E-02, 3.1002681721E-02, 7.3479139164E-01],
	[2.6470000000E+04, 8.4230567057E-01, 1.7070993173E+00, 3.2824664907E-02, 3.1019387931E-02, 7.3483566890E-01],
	[2.6475000000E+04, 8.4255354525E-01, 1.7070415481E+00, 3.2843023715E-02, 3.1036099720E-02, 7.3487992335E-01],
	[2.6480000000E+04, 8.4280144605E-01, 1.7069837918E+00, 3.2861389321E-02, 3.1052817088E-02, 7.3492415501E-01],
	[2.6485000000E+04, 8.4304937296E-01, 1.7069260484E+00, 3.2879761726E-02, 3.1069540037E-02, 7.3496836389E-01],
	[2.6490000000E+04, 8.4329732598E-01, 1.7068683177E+00, 3.2898140932E-02, 3.1086268566E-02, 7.3501254999E-01],
	[2.6495000000E+04, 8.4354530511E-01, 1.7068106000E+00, 3.2916526940E-02, 3.1103002676E-02, 7.3505671333E-01],
	[2.6500000000E+04, 8.4379331034E-01, 1.7067528951E+00, 3.2934919752E-02, 3.1119742367E-02, 7.3510085391E-01],
	[2.6505000000E+04, 8.4404134169E-01, 1.7066952030E+00, 3.2953319368E-02, 3.1136487641E-02, 7.3514497176E-01],
	[2.6510000000E+04, 8.4428939913E-01, 1.7066375237E+00, 3.2971725789E-02, 3.1153238498E-02, 7.3518906686E-01],
	[2.6515000000E+04, 8.4453748267E-01, 1.7065798573E+00, 3.2990139017E-02, 3.1169994938E-02, 7.3523313925E-01],
	[2.6520000000E+04, 8.4478559232E-01, 1.7065222037E+00, 3.3008559054E-02, 3.1186756962E-02, 7.3527718892E-01],
	[2.6525000000E+04, 8.4503372806E-01, 1.7064645629E+00, 3.3026985900E-02, 3.1203524570E-02, 7.3532121589E-01],
	[2.6530000000E+04, 8.4528188989E-01, 1.7064069349E+00, 3.3045419556E-02, 3.1220297763E-02, 7.3536522016E-01],
	[2.6535000000E+04, 8.4553007781E-01, 1.7063493197E+00, 3.3063860025E-02, 3.1237076542E-02, 7.3540920175E-01],
	[2.6540000000E+04, 8.4577829183E-01, 1.7062917174E+00, 3.3082307306E-02, 3.1253860906E-02, 7.3545316066E-01],
	[2.6545000000E+04, 8.4602653193E-01, 1.7062341278E+00, 3.3100761402E-02, 3.1270650857E-02, 7.3549709692E-01],
	[2.6550000000E+04, 8.4627479811E-01, 1.7061765510E+00, 3.3119222313E-02, 3.1287446395E-02, 7.3554101052E-01],
	[2.6555000000E+04, 8.4652309038E-01, 1.7061189870E+00, 3.3137690042E-02, 3.1304247521E-02, 7.3558490147E-01],
	[2.6560000000E+04, 8.4677140873E-01, 1.7060614358E+00, 3.3156164588E-02, 3.1321054235E-02, 7.3562876979E-01],
	[2.6565000000E+04, 8.4701975316E-01, 1.7060038973E+00, 3.3174645953E-02, 3.1337866537E-02, 7.3567261549E-01],
	[2.6570000000E+04, 8.4726812367E-01, 1.7059463716E+00, 3.3193134139E-02, 3.1354684429E-02, 7.3571643858E-01],
	[2.6575000000E+04, 8.4751652025E-01, 1.7058888587E+00, 3.3211629147E-02, 3.1371507910E-02, 7.3576023906E-01],
	[2.6580000000E+04, 8.4776494290E-01, 1.7058313586E+00, 3.3230130977E-02, 3.1388336981E-02, 7.3580401695E-01],
	[2.6585000000E+04, 8.4801339162E-01, 1.7057738712E+00, 3.3248639632E-02, 3.1405171643E-02, 7.3584777226E-01],
	[2.6590000000E+04, 8.4826186641E-01, 1.7057163965E+00, 3.3267155112E-02, 3.1422011897E-02, 7.3589150499E-01],
	[2.6595000000E+04, 8.4851036726E-01, 1.7056589346E+00, 3.3285677419E-02, 3.1438857742E-02, 7.3593521516E-01],
	[2.6600000000E+04, 8.4875889418E-01, 1.7056014854E+00, 3.3304206553E-02, 3.1455709180E-02, 7.3597890277E-01],
	[2.6605000000E+04, 8.4900744716E-01, 1.7055440489E+00, 3.3322742517E-02, 3.1472566211E-02, 7.3602256785E-01],
	[2.6610000000E+04, 8.4925602620E-01, 1.7054866252E+00, 3.3341285311E-02, 3.1489428835E-02, 7.3606621039E-01],
	[2.6615000000E+04, 8.4950463130E-01, 1.7054292142E+00, 3.3359834937E-02, 3.1506297053E-02, 7.3610983041E-01],
	[2.6620000000E+04, 8.4975326245E-01, 1.7053718159E+00, 3.3378391395E-02, 3.1523170865E-02, 7.3615342792E-01],
	[2.6625000000E+04, 8.5000191965E-01, 1.7053144304E+00, 3.3396954688E-02, 3.1540050273E-02, 7.3619700292E-01],
	[2.6630000000E+04, 8.5025060290E-01, 1.7052570575E+00, 3.3415524816E-02, 3.1556935276E-02, 7.3624055543E-01],
	[2.6635000000E+04, 8.5049931221E-01, 1.7051996973E+00, 3.3434101780E-02, 3.1573825876E-02, 7.3628408546E-01],
	[2.6640000000E+04, 8.5074804755E-01, 1.7051423499E+00, 3.3452685582E-02, 3.1590722071E-02, 7.3632759302E-01],
	[2.6645000000E+04, 8.5099680895E-01, 1.7050850151E+00, 3.3471276223E-02, 3.1607623864E-02, 7.3637107811E-01],
	[2.6650000000E+04, 8.5124559638E-01, 1.7050276930E+00, 3.3489873704E-02, 3.1624531255E-02, 7.3641454075E-01],
	[2.6655000000E+04, 8.5149440985E-01, 1.7049703836E+00, 3.3508478027E-02, 3.1641444244E-02, 7.3645798095E-01],
	[2.6660000000E+04, 8.5174324937E-01, 1.7049130869E+00, 3.3527089192E-02, 3.1658362832E-02, 7.3650139872E-01],
	[2.6665000000E+04, 8.5199211491E-01, 1.7048558028E+00, 3.3545707201E-02, 3.1675287019E-02, 7.3654479407E-01],
	[2.6670000000E+04, 8.5224100649E-01, 1.7047985314E+00, 3.3564332056E-02, 3.1692216806E-02, 7.3658816700E-01],
	[2.6675000000E+04, 8.5248992410E-01, 1.7047412726E+00, 3.3582963756E-02, 3.1709152193E-02, 7.3663151754E-01],
	[2.6680000000E+04, 8.5273886774E-01, 1.7046840265E+00, 3.3601602305E-02, 3.1726093181E-02, 7.3667484568E-01],
	[2.6685000000E+04, 8.5298783741E-01, 1.7046267931E+00, 3.3620247702E-02, 3.1743039770E-02, 7.3671815144E-01],
	[2.6690000000E+04, 8.5323683310E-01, 1.7045695723E+00, 3.3638899949E-02, 3.1759991961E-02, 7.3676143483E-01],
	[2.6695000000E+04, 8.5348585481E-01, 1.7045123642E+00, 3.3657559048E-02, 3.1776949755E-02, 7.3680469586E-01],
	[2.6700000000E+04, 8.5373490255E-01, 1.7044551686E+00, 3.3676224999E-02, 3.1793913152E-02, 7.3684793454E-01],
	[2.6705000000E+04, 8.5398397630E-01, 1.7043979857E+00, 3.3694897804E-02, 3.1810882152E-02, 7.3689115088E-01],
	[2.6710000000E+04, 8.5423307607E-01, 1.7043408155E+00, 3.3713577464E-02, 3.1827856756E-02, 7.3693434488E-01],
	[2.6715000000E+04, 8.5448220185E-01, 1.7042836578E+00, 3.3732263980E-02, 3.1844836965E-02, 7.3697751657E-01],
	[2.6720000000E+04, 8.5473135364E-01, 1.7042265128E+00, 3.3750957353E-02, 3.1861822778E-02, 7.3702066595E-01],
	[2.6725000000E+04, 8.5498053144E-01, 1.7041693803E+00, 3.3769657585E-02, 3.1878814198E-02, 7.3706379302E-01],
	[2.6730000000E+04, 8.5522973525E-01, 1.7041122605E+00, 3.3788364677E-02, 3.1895811223E-02, 7.3710689781E-01],
	[2.6735000000E+04, 8.5547896507E-01, 1.7040551533E+00, 3.3807078631E-02, 3.1912813856E-02, 7.3714998032E-01],
	[2.6740000000E+04, 8.5572822089E-01, 1.7039980586E+00, 3.3825799447E-02, 3.1929822095E-02, 7.3719304055E-01],
	[2.6745000000E+04, 8.5597765176E-01, 1.7039411511E+00, 3.3844527126E-02, 3.1946836211E-02, 7.3723607853E-01],
	[2.6750000000E+04, 8.5622809645E-01, 1.7038854120E+00, 3.3863261670E-02, 3.1963857719E-02, 7.3727909426E-01],
	[2.6755000000E+04, 8.5647856759E-01, 1.7038296852E+00, 3.3882003080E-02, 3.1980884839E-02, 7.3732208775E-01],
	[2.6760000000E+04, 8.5672906517E-01, 1.7037739706E+00, 3.3900751358E-02, 3.1997917571E-02, 7.3736505901E-01],
	[2.6765000000E+04, 8.5697958920E-01, 1.7037182682E+00, 3.3919506504E-02, 3.2014955916E-02, 7.3740800805E-01],
	[2.6770000000E+04, 8.5723013967E-01, 1.7036625781E+00, 3.3938268520E-02, 3.2031999875E-02, 7.3745093488E-01],
	[2.6775000000E+04, 8.5748071658E-01, 1.7036069002E+00, 3.3957037407E-02, 3.2049049447E-02, 7.3749383952E-01],
	[2.6780000000E+04, 8.5773131992E-01, 1.7035512345E+00, 3.3975813166E-02, 3.2066104634E-02, 7.3753672196E-01],
	[2.6785000000E+04, 8.5798194970E-01, 1.7034955810E+00, 3.3994595799E-02, 3.2083165436E-02, 7.3757958223E-01],
	[2.6790000000E+04, 8.5823260591E-01, 1.7034399397E+00, 3.4013385306E-02, 3.2100231853E-02, 7.3762242033E-01],
	[2.6795000000E+04, 8.5848328855E-01, 1.7033843106E+00, 3.4032181690E-02, 3.2117303887E-02, 7.3766523627E-01],
	[2.6800000000E+04, 8.5873399763E-01, 1.7033286938E+00, 3.4050984950E-02, 3.2134381537E-02, 7.3770803007E-01],
	[2.6805000000E+04, 8.5898473312E-01, 1.7032730891E+00, 3.4069795089E-02, 3.2151464804E-02, 7.3775080173E-01],
	[2.6810000000E+04, 8.5923549504E-01, 1.7032174966E+00, 3.4088612108E-02, 3.2168553689E-02, 7.3779355126E-01],
	[2.6815000000E+04, 8.5948628339E-01, 1.7031619162E+00, 3.4107436007E-02, 3.2185648192E-02, 7.3783627867E-01],
	[2.6820000000E+04, 8.5973709815E-01, 1.7031063481E+00, 3.4126266789E-02, 3.2202748313E-02, 7.3787898398E-01],
	[2.6825000000E+04, 8.5998793933E-01, 1.7030507921E+00, 3.4145104454E-02, 3.2219854054E-02, 7.3792166719E-01],
	[2.6830000000E+04, 8.6023880692E-01, 1.7029952483E+00, 3.4163949003E-02, 3.2236965414E-02, 7.3796432831E-01],
	[2.6835000000E+04, 8.6048970093E-01, 1.7029397166E+00, 3.4182800439E-02, 3.2254082395E-02, 7.3800696736E-01],
	[2.6840000000E+04, 8.6074062135E-01, 1.7028841971E+00, 3.4201658761E-02, 3.2271204997E-02, 7.3804958434E-01],
	[2.6845000000E+04, 8.6099156818E-01, 1.7028286898E+00, 3.4220523972E-02, 3.2288333219E-02, 7.3809217926E-01],
	[2.6850000000E+04, 8.6124254142E-01, 1.7027731946E+00, 3.4239396072E-02, 3.2305467064E-02, 7.3813475214E-01],
	[2.6855000000E+04, 8.6149354106E-01, 1.7027177115E+00, 3.4258275063E-02, 3.2322606531E-02, 7.3817730299E-01],
	[2.6860000000E+04, 8.6174456710E-01, 1.7026622406E+00, 3.4277160946E-02, 3.2339751620E-02, 7.3821983181E-01],
	[2.6865000000E+04, 8.6199561955E-01, 1.7026067818E+00, 3.4296053722E-02, 3.2356902333E-02, 7.3826233861E-01],
	[2.6870000000E+04, 8.6224669839E-01, 1.7025513352E+00, 3.4314953393E-02, 3.2374058670E-02, 7.3830482341E-01],
	[2.6875000000E+04, 8.6249780363E-01, 1.7024959006E+00, 3.4333859959E-02, 3.2391220631E-02, 7.3834728622E-01],
	[2.6880000000E+04, 8.6274893526E-01, 1.7024404782E+00, 3.4352773422E-02, 3.2408388217E-02, 7.3838972704E-01],
	[2.6885000000E+04, 8.6300009329E-01, 1.7023850679E+00, 3.4371693783E-02, 3.2425561429E-02, 7.3843214589E-01],
	[2.6890000000E+04, 8.6325127770E-01, 1.7023296697E+00, 3.4390621044E-02, 3.2442740267E-02, 7.3847454277E-01],
	[2.6895000000E+04, 8.6350248850E-01, 1.7022742836E+00, 3.4409555205E-02, 3.2459924731E-02, 7.3851691770E-01],
	[2.6900000000E+04, 8.6375372569E-01, 1.7022189096E+00, 3.4428496268E-02, 3.2477114822E-02, 7.3855927069E-01],
	[2.6905000000E+04, 8.6400498926E-01, 1.7021635476E+00, 3.4447444234E-02, 3.2494310540E-02, 7.3860160175E-01],
	[2.6910000000E+04, 8.6425627921E-01, 1.7021081978E+00, 3.4466399104E-02, 3.2511511887E-02, 7.3864391088E-01],
	[2.6915000000E+04, 8.6450759554E-01, 1.7020528601E+00, 3.4485360880E-02, 3.2528718862E-02, 7.3868619810E-01],
	[2.6920000000E+04, 8.6475893825E-01, 1.7019975344E+00, 3.4504329563E-02, 3.2545931466E-02, 7.3872846341E-01],
	[2.6925000000E+04, 8.6501030734E-01, 1.7019422208E+00, 3.4523305154E-02, 3.2563149700E-02, 7.3877070684E-01],
	[2.6930000000E+04, 8.6526170279E-01, 1.7018869193E+00, 3.4542287653E-02, 3.2580373563E-02, 7.3881292838E-01],
	[2.6935000000E+04, 8.6551312462E-01, 1.7018316298E+00, 3.4561277064E-02, 3.2597603058E-02, 7.3885512805E-01],
	[2.6940000000E+04, 8.6576457281E-01, 1.7017763524E+00, 3.4580273386E-02, 3.2614838183E-02, 7.3889730586E-01],
	[2.6945000000E+04, 8.6601604737E-01, 1.7017210871E+00, 3.4599276621E-02, 3.2632078940E-02, 7.3893946182E-01],
	[2.6950000000E+04, 8.6626754830E-01, 1.7016658338E+00, 3.4618286770E-02, 3.2649325330E-02, 7.3898159594E-01],
	[2.6955000000E+04, 8.6651907559E-01, 1.7016105925E+00, 3.4637303834E-02, 3.2666577352E-02, 7.3902370823E-01],
	[2.6960000000E+04, 8.6677062923E-01, 1.7015553633E+00, 3.4656327815E-02, 3.2683835007E-02, 7.3906579869E-01],
	[2.6965000000E+04, 8.6702220924E-01, 1.7015001461E+00, 3.4675358714E-02, 3.2701098296E-02, 7.3910786735E-01],
	[2.6970000000E+04, 8.6727381560E-01, 1.7014449410E+00, 3.4694396532E-02, 3.2718367219E-02, 7.3914991421E-01],
	[2.6975000000E+04, 8.6752544831E-01, 1.7013897478E+00, 3.4713441271E-02, 3.2735641777E-02, 7.3919193927E-01],
	[2.6980000000E+04, 8.6777710738E-01, 1.7013345667E+00, 3.4732492931E-02, 3.2752921970E-02, 7.3923394256E-01],
	[2.6985000000E+04, 8.6802879280E-01, 1.7012793976E+00, 3.4751551513E-02, 3.2770207799E-02, 7.3927592408E-01],
	[2.6990000000E+04, 8.6828050456E-01, 1.7012242405E+00, 3.4770617020E-02, 3.2787499264E-02, 7.3931788384E-01],
	[2.6995000000E+04, 8.6853224267E-01, 1.7011690954E+00, 3.4789689452E-02, 3.2804796365E-02, 7.3935982186E-01],
	[2.7000000000E+04, 8.6878400712E-01, 1.7011139624E+00, 3.4808768810E-02, 3.2822099105E-02, 7.3940173813E-01],
	[2.7005000000E+04, 8.6903579791E-01, 1.7010588413E+00, 3.4827855096E-02, 3.2839407482E-02, 7.3944363268E-01],
	[2.7010000000E+04, 8.6928761504E-01, 1.7010037322E+00, 3.4846948312E-02, 3.2856721497E-02, 7.3948550551E-01],
	[2.7015000000E+04, 8.6953945851E-01, 1.7009486351E+00, 3.4866048457E-02, 3.2874041151E-02, 7.3952735663E-01],
	[2.7020000000E+04, 8.6979132831E-01, 1.7008935499E+00, 3.4885155533E-02, 3.2891366444E-02, 7.3956918605E-01],
	[2.7025000000E+04, 8.7004322444E-01, 1.7008384768E+00, 3.4904269543E-02, 3.2908697378E-02, 7.3961099379E-01],
	[2.7030000000E+04, 8.7029514690E-01, 1.7007834156E+00, 3.4923390486E-02, 3.2926033951E-02, 7.3965277985E-01],
	[2.7035000000E+04, 8.7054709570E-01, 1.7007283664E+00, 3.4942518364E-02, 3.2943376166E-02, 7.3969454425E-01],
	[2.7040000000E+04, 8.7079907081E-01, 1.7006733291E+00, 3.4961653179E-02, 3.2960724022E-02, 7.3973628699E-01],
	[2.7045000000E+04, 8.7105107226E-01, 1.7006183038E+00, 3.4980794931E-02, 3.2978077520E-02, 7.3977800808E-01],
	[2.7050000000E+04, 8.7130310002E-01, 1.7005632905E+00, 3.4999943622E-02, 3.2995436660E-02, 7.3981970754E-01],
	[2.7055000000E+04, 8.7155515410E-01, 1.7005082891E+00, 3.5019099252E-02, 3.3012801443E-02, 7.3986138537E-01],
	[2.7060000000E+04, 8.7180723450E-01, 1.7004532996E+00, 3.5038261825E-02, 3.3030171869E-02, 7.3990304159E-01],
	[2.7065000000E+04, 8.7205934122E-01, 1.7003983221E+00, 3.5057431339E-02, 3.3047547940E-02, 7.3994467621E-01],
	[2.7070000000E+04, 8.7231147425E-01, 1.7003433565E+00, 3.5076607798E-02, 3.3064929655E-02, 7.3998628923E-01],
	[2.7075000000E+04, 8.7256363359E-01, 1.7002884028E+00, 3.5095791201E-02, 3.3082317015E-02, 7.4002788066E-01],
	[2.7080000000E+04, 8.7281581924E-01, 1.7002334611E+00, 3.5114981551E-02, 3.3099710020E-02, 7.4006945053E-01],
	[2.7085000000E+04, 8.7306803120E-01, 1.7001785313E+00, 3.5134178848E-02, 3.3117108671E-02, 7.4011099883E-01],
	[2.7090000000E+04, 8.7332026946E-01, 1.7001236134E+00, 3.5153383093E-02, 3.3134512969E-02, 7.4015252557E-01],
	[2.7095000000E+04, 8.7357253402E-01, 1.7000687074E+00, 3.5172594289E-02, 3.3151922913E-02, 7.4019403078E-01],
	[2.7100000000E+04, 8.7382482489E-01, 1.7000138133E+00, 3.5191812435E-02, 3.3169338506E-02, 7.4023551445E-01],
	[2.7105000000E+04, 8.7407714205E-01, 1.6999589311E+00, 3.5211037534E-02, 3.3186759746E-02, 7.4027697660E-01],
	[2.7110000000E+04, 8.7432948551E-01, 1.6999040608E+00, 3.5230269587E-02, 3.3204186634E-02, 7.4031841724E-01],
	[2.7115000000E+04, 8.7458185526E-01, 1.6998492024E+00, 3.5249508594E-02, 3.3221619172E-02, 7.4035983637E-01],
	[2.7120000000E+04, 8.7483425131E-01, 1.6997943558E+00, 3.5268754558E-02, 3.3239057359E-02, 7.4040123402E-01],
	[2.7125000000E+04, 8.7508667364E-01, 1.6997395212E+00, 3.5288007478E-02, 3.3256501197E-02, 7.4044261018E-01],
	[2.7130000000E+04, 8.7533912227E-01, 1.6996846984E+00, 3.5307267357E-02, 3.3273950684E-02, 7.4048396488E-01],
	[2.7135000000E+04, 8.7559159718E-01, 1.6996298875E+00, 3.5326534196E-02, 3.3291405823E-02, 7.4052529811E-01],
	[2.7140000000E+04, 8.7584409837E-01, 1.6995750885E+00, 3.5345807996E-02, 3.3308866613E-02, 7.4056660990E-01],
	[2.7145000000E+04, 8.7609662585E-01, 1.6995203013E+00, 3.5365088758E-02, 3.3326333055E-02, 7.4060790024E-01],
	[2.7150000000E+04, 8.7634917960E-01, 1.6994655260E+00, 3.5384376484E-02, 3.3343805150E-02, 7.4064916916E-01],
	[2.7155000000E+04, 8.7660175964E-01, 1.6994107625E+00, 3.5403671174E-02, 3.3361282898E-02, 7.4069041665E-01],
	[2.7160000000E+04, 8.7685436594E-01, 1.6993560109E+00, 3.5422972830E-02, 3.3378766300E-02, 7.4073164274E-01],
	[2.7165000000E+04, 8.7710699852E-01, 1.6993012711E+00, 3.5442281453E-02, 3.3396255355E-02, 7.4077284743E-01],
	[2.7170000000E+04, 8.7735965738E-01, 1.6992465432E+00, 3.5461597045E-02, 3.3413750065E-02, 7.4081403073E-01],
	[2.7175000000E+04, 8.7761236541E-01, 1.6991918553E+00, 3.5480919606E-02, 3.3431250474E-02, 7.4085519266E-01],
	[2.7180000000E+04, 8.7786613652E-01, 1.6991384538E+00, 3.5500249138E-02, 3.3448758538E-02, 7.4089633321E-01],
	[2.7185000000E+04, 8.7811993431E-01, 1.6990850639E+00, 3.5519585642E-02, 3.3466272261E-02, 7.4093745241E-01],
	[2.7190000000E+04, 8.7837375878E-01, 1.6990316855E+00, 3.5538929119E-02, 3.3483791644E-02, 7.4097855027E-01],
	[2.7195000000E+04, 8.7862760992E-01, 1.6989783185E+00, 3.5558279571E-02, 3.3501316687E-02, 7.4101962678E-01],
	[2.7200000000E+04, 8.7888148774E-01, 1.6989249631E+00, 3.5577636998E-02, 3.3518847390E-02, 7.4106068197E-01],
	[2.7205000000E+04, 8.7913539223E-01, 1.6988716191E+00, 3.5597001403E-02, 3.3536383755E-02, 7.4110171585E-01],
	[2.7210000000E+04, 8.7938932339E-01, 1.6988182866E+00, 3.5616372786E-02, 3.3553925781E-02, 7.4114272842E-01],
	[2.7215000000E+04, 8.7964328123E-01, 1.6987649656E+00, 3.5635751148E-02, 3.3571473469E-02, 7.4118371970E-01],
	[2.7220000000E+04, 8.7989726572E-01, 1.6987116560E+00, 3.5655136491E-02, 3.3589026820E-02, 7.4122468969E-01],
	[2.7225000000E+04, 8.8015127689E-01, 1.6986583579E+00, 3.5674528816E-02, 3.3606585834E-02, 7.4126563840E-01],
	[2.7230000000E+04, 8.8040531471E-01, 1.6986050713E+00, 3.5693928124E-02, 3.3624150512E-02, 7.4130656585E-01],
	[2.7235000000E+04, 8.8065937920E-01, 1.6985517961E+00, 3.5713334416E-02, 3.3641720854E-02, 7.4134747205E-01],
	[2.7240000000E+04, 8.8091347034E-01, 1.6984985324E+00, 3.5732747694E-02, 3.3659296860E-02, 7.4138835701E-01],
	[2.7245000000E+04, 8.8116758814E-01, 1.6984452801E+00, 3.5752167959E-02, 3.3676878532E-02, 7.4142922073E-01],
	[2.7250000000E+04, 8.8142173259E-01, 1.6983920392E+00, 3.5771595212E-02, 3.3694465869E-02, 7.4147006323E-01],
	[2.7255000000E+04, 8.8167590370E-01, 1.6983388098E+00, 3.5791029454E-02, 3.3712058872E-02, 7.4151088452E-01],
	[2.7260000000E+04, 8.8193010145E-01, 1.6982855919E+00, 3.5810470686E-02, 3.3729657542E-02, 7.4155168460E-01],
	[2.7265000000E+04, 8.8218432585E-01, 1.6982323853E+00, 3.5829918911E-02, 3.3747261880E-02, 7.4159246350E-01],
	[2.7270000000E+04, 8.8243857690E-01, 1.6981791902E+00, 3.5849374128E-02, 3.3764871884E-02, 7.4163322121E-01],
	[2.7275000000E+04, 8.8269285459E-01, 1.6981260065E+00, 3.5868836340E-02, 3.3782487557E-02, 7.4167395775E-01],
	[2.7280000000E+04, 8.8294715893E-01, 1.6980728342E+00, 3.5888305547E-02, 3.3800108899E-02, 7.4171467313E-01],
	[2.7285000000E+04, 8.8320148990E-01, 1.6980196733E+00, 3.5907781751E-02, 3.3817735909E-02, 7.4175536736E-01],
	[2.7290000000E+04, 8.8345584751E-01, 1.6979665238E+00, 3.5927264952E-02, 3.3835368590E-02, 7.4179604045E-01],
	[2.7295000000E+04, 8.8371023176E-01, 1.6979133858E+00, 3.5946755153E-02, 3.3853006940E-02, 7.4183669241E-01],
	[2.7300000000E+04, 8.8396464263E-01, 1.6978602591E+00, 3.5966252354E-02, 3.3870650961E-02, 7.4187732325E-01],
	[2.7305000000E+04, 8.8421908014E-01, 1.6978071438E+00, 3.5985756557E-02, 3.3888300653E-02, 7.4191793299E-01],
	[2.7310000000E+04, 8.8447354428E-01, 1.6977540399E+00, 3.6005267763E-02, 3.3905956017E-02, 7.4195852162E-01],
	[2.7315000000E+04, 8.8472803505E-01, 1.6977009474E+00, 3.6024785973E-02, 3.3923617053E-02, 7.4199908917E-01],
	[2.7320000000E+04, 8.8498255243E-01, 1.6976478662E+00, 3.6044311188E-02, 3.3941283762E-02, 7.4203963564E-01],
	[2.7325000000E+04, 8.8523709645E-01, 1.6975947964E+00, 3.6063843409E-02, 3.3958956143E-02, 7.4208016104E-01],
	[2.7330000000E+04, 8.8549166708E-01, 1.6975417380E+00, 3.6083382639E-02, 3.3976634198E-02, 7.4212066538E-01],
	[2.7335000000E+04, 8.8574626433E-01, 1.6974886910E+00, 3.6102928877E-02, 3.3994317928E-02, 7.4216114868E-01],
	[2.7340000000E+04, 8.8600088820E-01, 1.6974356553E+00, 3.6122482126E-02, 3.4012007332E-02, 7.4220161094E-01],
	[2.7345000000E+04, 8.8625553868E-01, 1.6973826310E+00, 3.6142042386E-02, 3.4029702411E-02, 7.4224205217E-01],
	[2.7350000000E+04, 8.8651021577E-01, 1.6973296180E+00, 3.6161609659E-02, 3.4047403165E-02, 7.4228247239E-01],
	[2.7355000000E+04, 8.8676491948E-01, 1.6972766164E+00, 3.6181183946E-02, 3.4065109596E-02, 7.4232287160E-01],
	[2.7360000000E+04, 8.8701964979E-01, 1.6972236261E+00, 3.6200765247E-02, 3.4082821703E-02, 7.4236324982E-01],
	[2.7365000000E+04, 8.8727440671E-01, 1.6971706472E+00, 3.6220353566E-02, 3.4100539488E-02, 7.4240360705E-01],
	[2.7370000000E+04, 8.8752919023E-01, 1.6971176795E+00, 3.6239948902E-02, 3.4118262950E-02, 7.4244394331E-01],
	[2.7375000000E+04, 8.8778400035E-01, 1.6970647232E+00, 3.6259551256E-02, 3.4135992090E-02, 7.4248425861E-01],
	[2.7380000000E+04, 8.8803883707E-01, 1.6970117783E+00, 3.6279160631E-02, 3.4153726908E-02, 7.4252455295E-01],
	[2.7385000000E+04, 8.8829370039E-01, 1.6969588446E+00, 3.6298777027E-02, 3.4171467406E-02, 7.4256482635E-01],
	[2.7390000000E+04, 8.8854859031E-01, 1.6969059223E+00, 3.6318573186E-02, 3.4189366662E-02, 7.4260507881E-01],
	[2.7395000000E+04, 8.8880350682E-01, 1.6968530113E+00, 3.6338425268E-02, 3.4207314918E-02, 7.4264531036E-01],
	[2.7400000000E+04, 8.8905844992E-01, 1.6968001116E+00, 3.6358284575E-02, 3.4225269015E-02, 7.4268552099E-01],
	[2.7405000000E+04, 8.8931341961E-01, 1.6967472231E+00, 3.6378151109E-02, 3.4243228954E-02, 7.4272571072E-01],
	[2.7410000000E+04, 8.8956841589E-01, 1.6966943460E+00, 3.6398024871E-02, 3.4261194735E-02, 7.4276587955E-01],
	[2.7415000000E+04, 8.8982343875E-01, 1.6966414802E+00, 3.6417905862E-02, 3.4279166359E-02, 7.4280602751E-01],
	[2.7420000000E+04, 8.9007848820E-01, 1.6965886257E+00, 3.6437794084E-02, 3.4297143826E-02, 7.4284615459E-01],
	[2.7425000000E+04, 8.9033356422E-01, 1.6965357824E+00, 3.6457689538E-02, 3.4315127137E-02, 7.4288626082E-01],
	[2.7430000000E+04, 8.9058866683E-01, 1.6964829504E+00, 3.6477592225E-02, 3.4333116293E-02, 7.4292634619E-01],
	[2.7435000000E+04, 8.9084379601E-01, 1.6964301297E+00, 3.6497502147E-02, 3.4351111293E-02, 7.4296641073E-01],
	[2.7440000000E+04, 8.9109895177E-01, 1.6963773203E+00, 3.6517419304E-02, 3.4369112139E-02, 7.4300645443E-01],
	[2.7445000000E+04, 8.9135413410E-01, 1.6963245221E+00, 3.6537343699E-02, 3.4387118831E-02, 7.4304647732E-01],
	[2.7450000000E+04, 8.9160934300E-01, 1.6962717352E+00, 3.6557275333E-02, 3.4405131370E-02, 7.4308647940E-01],
	[2.7455000000E+04, 8.9186457846E-01, 1.6962189596E+00, 3.6577214206E-02, 3.4423149756E-02, 7.4312646068E-01],
	[2.7460000000E+04, 8.9211984050E-01, 1.6961661952E+00, 3.6597160320E-02, 3.4441173989E-02, 7.4316642117E-01],
	[2.7465000000E+04, 8.9237512910E-01, 1.6961134420E+00, 3.6617113676E-02, 3.4459204071E-02, 7.4320636088E-01],
	[2.7470000000E+04, 8.9263044426E-01, 1.6960607001E+00, 3.6637074277E-02, 3.4477240001E-02, 7.4324627983E-01],
	[2.7475000000E+04, 8.9288578598E-01, 1.6960079694E+00, 3.6657042122E-02, 3.4495281780E-02, 7.4328617802E-01],
	[2.7480000000E+04, 8.9314115426E-01, 1.6959552500E+00, 3.6677017214E-02, 3.4513329409E-02, 7.4332605546E-01],
	[2.7485000000E+04, 8.9339654910E-01, 1.6959025418E+00, 3.6696999554E-02, 3.4531382889E-02, 7.4336591217E-01],
	[2.7490000000E+04, 8.9365197049E-01, 1.6958498448E+00, 3.6716989142E-02, 3.4549442219E-02, 7.4340574815E-01],
	[2.7495000000E+04, 8.9390741843E-01, 1.6957971591E+00, 3.6736985981E-02, 3.4567507400E-02, 7.4344556342E-01],
	[2.7500000000E+04, 8.9416289292E-01, 1.6957444845E+00, 3.6756990071E-02, 3.4585578434E-02, 7.4348535798E-01],
	[2.7505000000E+04, 8.9441839396E-01, 1.6956918212E+00, 3.6777001414E-02, 3.4603655319E-02, 7.4352513184E-01],
	[2.7510000000E+04, 8.9467392155E-01, 1.6956391691E+00, 3.6797020012E-02, 3.4621738058E-02, 7.4356488502E-01],
	[2.7515000000E+04, 8.9492947568E-01, 1.6955865281E+00, 3.6817045865E-02, 3.4639826650E-02, 7.4360461753E-01],
	[2.7520000000E+04, 8.9518505635E-01, 1.6955338984E+00, 3.6837078975E-02, 3.4657921096E-02, 7.4364432938E-01],
	[2.7525000000E+04, 8.9544066356E-01, 1.6954812799E+00, 3.6857119343E-02, 3.4676021397E-02, 7.4368402057E-01],
	[2.7530000000E+04, 8.9569629731E-01, 1.6954286726E+00, 3.6877166970E-02, 3.4694127553E-02, 7.4372369112E-01],
	[2.7535000000E+04, 8.9595195759E-01, 1.6953760764E+00, 3.6897221859E-02, 3.4712239564E-02, 7.4376334103E-01],
	[2.7540000000E+04, 8.9620764441E-01, 1.6953234914E+00, 3.6917284009E-02, 3.4730357431E-02, 7.4380297032E-01],
	[2.7545000000E+04, 8.9646335775E-01, 1.6952709176E+00, 3.6937353423E-02, 3.4748481155E-02, 7.4384257900E-01],
	[2.7550000000E+04, 8.9671909763E-01, 1.6952183550E+00, 3.6957430101E-02, 3.4766610736E-02, 7.4388216708E-01],
	[2.7555000000E+04, 8.9697486403E-01, 1.6951658036E+00, 3.6977514046E-02, 3.4784746175E-02, 7.4392173457E-01],
	[2.7560000000E+04, 8.9723065696E-01, 1.6951132633E+00, 3.6997605258E-02, 3.4802887471E-02, 7.4396128148E-01],
	[2.7565000000E+04, 8.9748647642E-01, 1.6950607341E+00, 3.7017703738E-02, 3.4821034627E-02, 7.4400080782E-01],
	[2.7570000000E+04, 8.9774232239E-01, 1.6950082162E+00, 3.7037809489E-02, 3.4839187642E-02, 7.4404031359E-01],
	[2.7575000000E+04, 8.9799819488E-01, 1.6949557093E+00, 3.7057922511E-02, 3.4857346516E-02, 7.4407979880E-01],
	[2.7580000000E+04, 8.9825409389E-01, 1.6949032137E+00, 3.7078042805E-02, 3.4875511251E-02, 7.4411926347E-01],
	[2.7585000000E+04, 8.9851001941E-01, 1.6948507291E+00, 3.7098170373E-02, 3.4893681847E-02, 7.4415870761E-01],
	[2.7590000000E+04, 8.9876597145E-01, 1.6947982557E+00, 3.7118305216E-02, 3.4911858304E-02, 7.4419813121E-01],
	[2.7595000000E+04, 8.9902195000E-01, 1.6947457935E+00, 3.7138447336E-02, 3.4930040622E-02, 7.4423753430E-01],
	[2.7600000000E+04, 8.9927795505E-01, 1.6946933423E+00, 3.7158596734E-02, 3.4948228804E-02, 7.4427691688E-01],
	[2.7605000000E+04, 8.9953398662E-01, 1.6946409023E+00, 3.7178753411E-02, 3.4966422848E-02, 7.4431627896E-01],
	[2.7610000000E+04, 8.9979004468E-01, 1.6945884734E+00, 3.7198917368E-02, 3.4984622755E-02, 7.4435562054E-01],
	[2.7615000000E+04, 9.0004664520E-01, 1.6945367266E+00, 3.7219088607E-02, 3.5002829593E-02, 7.4439494165E-01],
	[2.7620000000E+04, 9.0030373769E-01, 1.6944855957E+00, 3.7239267129E-02, 3.5021043260E-02, 7.4443424228E-01],
	[2.7625000000E+04, 9.0056085706E-01, 1.6944344756E+00, 3.7259452935E-02, 3.5039262794E-02, 7.4447352244E-01],
	[2.7630000000E+04, 9.0081800331E-01, 1.6943833662E+00, 3.7279646028E-02, 3.5057488197E-02, 7.4451278215E-01],
	[2.7635000000E+04, 9.0107517643E-01, 1.6943322677E+00, 3.7299846407E-02, 3.5075719469E-02, 7.4455202142E-01],
	[2.7640000000E+04, 9.0133237642E-01, 1.6942811799E+00, 3.7320054074E-02, 3.5093956611E-02, 7.4459124024E-01],
	[2.7645000000E+04, 9.0158960329E-01, 1.6942301029E+00, 3.7340269031E-02, 3.5112199623E-02, 7.4463043864E-01],
	[2.7650000000E+04, 9.0184685703E-01, 1.6941790367E+00, 3.7360491279E-02, 3.5130448506E-02, 7.4466961662E-01],
	[2.7655000000E+04, 9.0210413763E-01, 1.6941279813E+00, 3.7380720819E-02, 3.5148703259E-02, 7.4470877419E-01],
	[2.7660000000E+04, 9.0236144510E-01, 1.6940769366E+00, 3.7400957653E-02, 3.5166963885E-02, 7.4474791136E-01],
	[2.7665000000E+04, 9.0261877944E-01, 1.6940259027E+00, 3.7421201781E-02, 3.5185230382E-02, 7.4478702814E-01],
	[2.7670000000E+04, 9.0287614063E-01, 1.6939748796E+00, 3.7441453206E-02, 3.5203502752E-02, 7.4482612453E-01],
	[2.7675000000E+04, 9.0313352869E-01, 1.6939238672E+00, 3.7461711928E-02, 3.5221780996E-02, 7.4486520055E-01],
	[2.7680000000E+04, 9.0339094360E-01, 1.6938728656E+00, 3.7481977949E-02, 3.5240065113E-02, 7.4490425621E-01],
	[2.7685000000E+04, 9.0364838537E-01, 1.6938218747E+00, 3.7502251270E-02, 3.5258355105E-02, 7.4494329151E-01],
	[2.7690000000E+04, 9.0390585399E-01, 1.6937708946E+00, 3.7522531893E-02, 3.5276650971E-02, 7.4498230646E-01],
	[2.7695000000E+04, 9.0416334946E-01, 1.6937199251E+00, 3.7542819818E-02, 3.5294952713E-02, 7.4502130108E-01],
	[2.7700000000E+04, 9.0442087179E-01, 1.6936689665E+00, 3.7563115047E-02, 3.5313260331E-02, 7.4506027537E-01],
	[2.7705000000E+04, 9.0467842096E-01, 1.6936180185E+00, 3.7583417582E-02, 3.5331573824E-02, 7.4509922934E-01],
	[2.7710000000E+04, 9.0493599697E-01, 1.6935670813E+00, 3.7603727423E-02, 3.5349893195E-02, 7.4513816300E-01],
	[2.7715000000E+04, 9.0519359983E-01, 1.6935161548E+00, 3.7624044572E-02, 3.5368218443E-02, 7.4517707636E-01],
	[2.7720000000E+04, 9.0545122953E-01, 1.6934652391E+00, 3.7644369030E-02, 3.5386549570E-02, 7.4521596942E-01],
	[2.7725000000E+04, 9.0570888607E-01, 1.6934143340E+00, 3.7664700799E-02, 3.5404886574E-02, 7.4525484221E-01],
	[2.7730000000E+04, 9.0596656944E-01, 1.6933634396E+00, 3.7685039880E-02, 3.5423229458E-02, 7.4529369472E-01],
	[2.7735000000E+04, 9.0622427965E-01, 1.6933125560E+00, 3.7705386274E-02, 3.5441578221E-02, 7.4533252697E-01],
	[2.7740000000E+04, 9.0648201669E-01, 1.6932616831E+00, 3.7725739983E-02, 3.5459932864E-02, 7.4537133896E-01],
	[2.7745000000E+04, 9.0673978057E-01, 1.6932108208E+00, 3.7746101007E-02, 3.5478293387E-02, 7.4541013070E-01],
	[2.7750000000E+04, 9.0699757127E-01, 1.6931599692E+00, 3.7766469349E-02, 3.5496659792E-02, 7.4544890221E-01],
	[2.7755000000E+04, 9.0725538880E-01, 1.6931091284E+00, 3.7786845009E-02, 3.5515032078E-02, 7.4548765349E-01],
	[2.7760000000E+04, 9.0751323316E-01, 1.6930582982E+00, 3.7807227988E-02, 3.5533410246E-02, 7.4552638456E-01],
	[2.7765000000E+04, 9.0777110433E-01, 1.6930074787E+00, 3.7827618289E-02, 3.5551794297E-02, 7.4556509541E-01],
	[2.7770000000E+04, 9.0802900233E-01, 1.6929566699E+00, 3.7848015912E-02, 3.5570184230E-02, 7.4560378606E-01],
	[2.7775000000E+04, 9.0828692715E-01, 1.6929058717E+00, 3.7868420859E-02, 3.5588580048E-02, 7.4564245652E-01],
	[2.7780000000E+04, 9.0854487878E-01, 1.6928550842E+00, 3.7888833131E-02, 3.5606981749E-02, 7.4568110680E-01],
	[2.7785000000E+04, 9.0880285723E-01, 1.6928043074E+00, 3.7909252729E-02, 3.5625389335E-02, 7.4571973691E-01],
	[2.7790000000E+04, 9.0906086249E-01, 1.6927535412E+00, 3.7929679655E-02, 3.5643802806E-02, 7.4575834685E-01],
	[2.7795000000E+04, 9.0931889456E-01, 1.6927027857E+00, 3.7950113910E-02, 3.5662222163E-02, 7.4579693664E-01],
	[2.7800000000E+04, 9.0957695344E-01, 1.6926520409E+00, 3.7970555494E-02, 3.5680647406E-02, 7.4583550628E-01],
	[2.7805000000E+04, 9.0983503912E-01, 1.6926013066E+00, 3.7991004411E-02, 3.5699078536E-02, 7.4587405579E-01],
	[2.7810000000E+04, 9.1009315161E-01, 1.6925505831E+00, 3.8011460660E-02, 3.5717515553E-02, 7.4591258517E-01],
	[2.7815000000E+04, 9.1035129090E-01, 1.6924998701E+00, 3.8031924244E-02, 3.5735958458E-02, 7.4595109443E-01],
	[2.7820000000E+04, 9.1060945700E-01, 1.6924491678E+00, 3.8052395163E-02, 3.5754407250E-02, 7.4598958358E-01],
	[2.7825000000E+04, 9.1086764989E-01, 1.6923984762E+00, 3.8072873418E-02, 3.5772861932E-02, 7.4602805264E-01],
	[2.7830000000E+04, 9.1112586957E-01, 1.6923477951E+00, 3.8093359012E-02, 3.5791322503E-02, 7.4606650160E-01],
	[2.7835000000E+04, 9.1138411606E-01, 1.6922971247E+00, 3.8113851945E-02, 3.5809788963E-02, 7.4610493048E-01],
	[2.7840000000E+04, 9.1164238933E-01, 1.6922464649E+00, 3.8134352219E-02, 3.5828261314E-02, 7.4614333929E-01],
	[2.7845000000E+04, 9.1190068939E-01, 1.6921958157E+00, 3.8154859835E-02, 3.5846739556E-02, 7.4618172804E-01],
	[2.7850000000E+04, 9.1215901624E-01, 1.6921451771E+00, 3.8175374795E-02, 3.5865223689E-02, 7.4622009673E-01],
	[2.7855000000E+04, 9.1241736988E-01, 1.6920945492E+00, 3.8195897099E-02, 3.5883713713E-02, 7.4625844538E-01],
	[2.7860000000E+04, 9.1267575030E-01, 1.6920439318E+00, 3.8216426748E-02, 3.5902209630E-02, 7.4629677400E-01],
	[2.7865000000E+04, 9.1293415751E-01, 1.6919933250E+00, 3.8236963746E-02, 3.5920711440E-02, 7.4633508258E-01],
	[2.7870000000E+04, 9.1319259149E-01, 1.6919427288E+00, 3.8257508091E-02, 3.5939219143E-02, 7.4637337116E-01],
	[2.7875000000E+04, 9.1345105225E-01, 1.6918921433E+00, 3.8278059787E-02, 3.5957732740E-02, 7.4641163972E-01],
	[2.7880000000E+04, 9.1370953979E-01, 1.6918415682E+00, 3.8298618834E-02, 3.5976252231E-02, 7.4644988829E-01],
	[2.7885000000E+04, 9.1396805410E-01, 1.6917910038E+00, 3.8319185233E-02, 3.5994777617E-02, 7.4648811686E-01],
	[2.7890000000E+04, 9.1422659518E-01, 1.6917404500E+00, 3.8339758986E-02, 3.6013308899E-02, 7.4652632546E-01],
	[2.7895000000E+04, 9.1448516304E-01, 1.6916899067E+00, 3.8360340095E-02, 3.6031846076E-02, 7.4656451409E-01],
	[2.7900000000E+04, 9.1474375766E-01, 1.6916393740E+00, 3.8380928560E-02, 3.6050389150E-02, 7.4660268275E-01],
	[2.7905000000E+04, 9.1500237904E-01, 1.6915888518E+00, 3.8401524382E-02, 3.6068938120E-02, 7.4664083146E-01],
	[2.7910000000E+04, 9.1526102719E-01, 1.6915383403E+00, 3.8422127564E-02, 3.6087492988E-02, 7.4667896023E-01],
	[2.7915000000E+04, 9.1551970211E-01, 1.6914878392E+00, 3.8442738106E-02, 3.6106053754E-02, 7.4671706907E-01],
	[2.7920000000E+04, 9.1577840378E-01, 1.6914373487E+00, 3.8463356009E-02, 3.6124620418E-02, 7.4675515798E-01],
	[2.7925000000E+04, 9.1603713221E-01, 1.6913868688E+00, 3.8483981276E-02, 3.6143192981E-02, 7.4679322698E-01],
	[2.7930000000E+04, 9.1629588739E-01, 1.6913363994E+00, 3.8504613907E-02, 3.6161771444E-02, 7.4683127607E-01],
	[2.7935000000E+04, 9.1655466933E-01, 1.6912859406E+00, 3.8525253903E-02, 3.6180355806E-02, 7.4686930526E-01],
	[2.7940000000E+04, 9.1681347802E-01, 1.6912354923E+00, 3.8545901267E-02, 3.6198946069E-02, 7.4690731457E-01],
	[2.7945000000E+04, 9.1707231346E-01, 1.6911850545E+00, 3.8566555999E-02, 3.6217542233E-02, 7.4694530400E-01],
	[2.7950000000E+04, 9.1733117565E-01, 1.6911346272E+00, 3.8587218100E-02, 3.6236144298E-02, 7.4698327356E-01],
	[2.7955000000E+04, 9.1759006458E-01, 1.6910842105E+00, 3.8607887572E-02, 3.6254752265E-02, 7.4702122325E-01],
	[2.7960000000E+04, 9.1784898026E-01, 1.6910338043E+00, 3.8628564416E-02, 3.6273366134E-02, 7.4705915310E-01],
	[2.7965000000E+04, 9.1810792268E-01, 1.6909834086E+00, 3.8649248634E-02, 3.6291985907E-02, 7.4709706311E-01],
	[2.7970000000E+04, 9.1836689183E-01, 1.6909330234E+00, 3.8669940227E-02, 3.6310611583E-02, 7.4713495329E-01],
	[2.7975000000E+04, 9.1862588773E-01, 1.6908826488E+00, 3.8690639195E-02, 3.6329243162E-02, 7.4717282364E-01],
	[2.7980000000E+04, 9.1888491036E-01, 1.6908322846E+00, 3.8711345541E-02, 3.6347880647E-02, 7.4721067418E-01],
	[2.7985000000E+04, 9.1914395972E-01, 1.6907819309E+00, 3.8732059266E-02, 3.6366524036E-02, 7.4724850491E-01],
	[2.7990000000E+04, 9.1940303582E-01, 1.6907315877E+00, 3.8752780371E-02, 3.6385173330E-02, 7.4728631585E-01],
	[2.7995000000E+04, 9.1966213864E-01, 1.6906812551E+00, 3.8773508857E-02, 3.6403828531E-02, 7.4732410701E-01],
	[2.8000000000E+04, 9.1992126819E-01, 1.6906309329E+00, 3.8794244726E-02, 3.6422489638E-02, 7.4736187838E-01],
	[2.8005000000E+04, 9.2018042447E-01, 1.6905806211E+00, 3.8814987978E-02, 3.6441156652E-02, 7.4739962999E-01],
	[2.8010000000E+04, 9.2043960747E-01, 1.6905303199E+00, 3.8835738617E-02, 3.6459829573E-02, 7.4743736185E-01],
	[2.8015000000E+04, 9.2069881719E-01, 1.6904800291E+00, 3.8856496641E-02, 3.6478508403E-02, 7.4747507395E-01],
	[2.8020000000E+04, 9.2095805363E-01, 1.6904297488E+00, 3.8877262054E-02, 3.6497193140E-02, 7.4751276631E-01],
	[2.8025000000E+04, 9.2121731679E-01, 1.6903794790E+00, 3.8898034855E-02, 3.6515883787E-02, 7.4755043895E-01],
	[2.8030000000E+04, 9.2147660667E-01, 1.6903292197E+00, 3.8918815048E-02, 3.6534580343E-02, 7.4758809186E-01],
	[2.8035000000E+04, 9.2173592325E-01, 1.6902789707E+00, 3.8939602632E-02, 3.6553282809E-02, 7.4762572507E-01],
	[2.8040000000E+04, 9.2199526655E-01, 1.6902287323E+00, 3.8960397609E-02, 3.6571991186E-02, 7.4766333857E-01],
	[2.8045000000E+04, 9.2225463656E-01, 1.6901785043E+00, 3.8981199980E-02, 3.6590705473E-02, 7.4770093237E-01],
	[2.8050000000E+04, 9.2251403327E-01, 1.6901282867E+00, 3.9002009748E-02, 3.6609425672E-02, 7.4773850650E-01],
	[2.8055000000E+04, 9.2277345669E-01, 1.6900780796E+00, 3.9022826912E-02, 3.6628151783E-02, 7.4777606095E-01],
	[2.8060000000E+04, 9.2303346698E-01, 1.6900286597E+00, 3.9043651475E-02, 3.6646885054E-02, 7.4781359573E-01],
	[2.8065000000E+04, 9.2329384530E-01, 1.6899797229E+00, 3.9064483437E-02, 3.6665625001E-02, 7.4785111086E-01],
	[2.8070000000E+04, 9.2355425067E-01, 1.6899307962E+00, 3.9085322801E-02, 3.6684370864E-02, 7.4788860634E-01],
	[2.8075000000E+04, 9.2381468309E-01, 1.6898818796E+00, 3.9106169567E-02, 3.6703122644E-02, 7.4792608219E-01],
	[2.8080000000E+04, 9.2407514254E-01, 1.6898329732E+00, 3.9127023736E-02, 3.6721880342E-02, 7.4796353841E-01],
	[2.8085000000E+04, 9.2433562904E-01, 1.6897840768E+00, 3.9147885310E-02, 3.6740643957E-02, 7.4800097501E-01],
	[2.8090000000E+04, 9.2459614257E-01, 1.6897351906E+00, 3.9168754291E-02, 3.6759413491E-02, 7.4803839200E-01],
	[2.8095000000E+04, 9.2485668314E-01, 1.6896863145E+00, 3.9189630679E-02, 3.6778188944E-02, 7.4807578939E-01],
	[2.8100000000E+04, 9.2511725075E-01, 1.6896374486E+00, 3.9210514476E-02, 3.6796970316E-02, 7.4811316719E-01],
	[2.8105000000E+04, 9.2537784538E-01, 1.6895885927E+00, 3.9231405683E-02, 3.6815757608E-02, 7.4815052540E-01],
	[2.8110000000E+04, 9.2563846705E-01, 1.6895397469E+00, 3.9252304302E-02, 3.6834550820E-02, 7.4818786405E-01],
	[2.8115000000E+04, 9.2589911574E-01, 1.6894909113E+00, 3.9273210333E-02, 3.6853349954E-02, 7.4822518314E-01],
	[2.8120000000E+04, 9.2615979146E-01, 1.6894420857E+00, 3.9294123779E-02, 3.6872155008E-02, 7.4826248267E-01],
	[2.8125000000E+04, 9.2642049421E-01, 1.6893932702E+00, 3.9315044639E-02, 3.6890965985E-02, 7.4829976265E-01],
	[2.8130000000E+04, 9.2668122397E-01, 1.6893444648E+00, 3.9335972917E-02, 3.6909782884E-02, 7.4833702310E-01],
	[2.8135000000E+04, 9.2694198076E-01, 1.6892956695E+00, 3.9356908613E-02, 3.6928605705E-02, 7.4837426403E-01],
	[2.8140000000E+04, 9.2720276457E-01, 1.6892468843E+00, 3.9377851728E-02, 3.6947434451E-02, 7.4841148544E-01],
	[2.8145000000E+04, 9.2746357539E-01, 1.6891981092E+00, 3.9398802263E-02, 3.6966269120E-02, 7.4844868735E-01],
	[2.8150000000E+04, 9.2772441322E-01, 1.6891493441E+00, 3.9419760221E-02, 3.6985109713E-02, 7.4848586975E-01],
	[2.8155000000E+04, 9.2798527807E-01, 1.6891005891E+00, 3.9440725602E-02, 3.7003956231E-02, 7.4852303267E-01],
	[2.8160000000E+04, 9.2824616992E-01, 1.6890518441E+00, 3.9461698407E-02, 3.7022808675E-02, 7.4856017611E-01],
	[2.8165000000E+04, 9.2850708879E-01, 1.6890031093E+00, 3.9482678639E-02, 3.7041667044E-02, 7.4859730008E-01],
	[2.8170000000E+04, 9.2876803466E-01, 1.6889543844E+00, 3.9503666297E-02, 3.7060531340E-02, 7.4863440459E-01],
	[2.8175000000E+04, 9.2902900753E-01, 1.6889056697E+00, 3.9524661384E-02, 3.7079401562E-02, 7.4867148965E-01],
	[2.8180000000E+04, 9.2929000741E-01, 1.6888569649E+00, 3.9545663901E-02, 3.7098277712E-02, 7.4870855527E-01],
	[2.8185000000E+04, 9.2955103429E-01, 1.6888082702E+00, 3.9566673849E-02, 3.7117159790E-02, 7.4874560146E-01],
	[2.8190000000E+04, 9.2981208816E-01, 1.6887595856E+00, 3.9587691230E-02, 3.7136047796E-02, 7.4878262822E-01],
	[2.8195000000E+04, 9.3007316903E-01, 1.6887109110E+00, 3.9608716044E-02, 3.7154941730E-02, 7.4881963557E-01],
	[2.8200000000E+04, 9.3033427690E-01, 1.6886622464E+00, 3.9629748293E-02, 3.7173841595E-02, 7.4885662352E-01],
	[2.8205000000E+04, 9.3059541176E-01, 1.6886135919E+00, 3.9650787979E-02, 3.7192747388E-02, 7.4889359207E-01],
	[2.8210000000E+04, 9.3085657360E-01, 1.6885649474E+00, 3.9671835102E-02, 3.7211659112E-02, 7.4893054124E-01],
	[2.8215000000E+04, 9.3111776244E-01, 1.6885163129E+00, 3.9692889664E-02, 3.7230576767E-02, 7.4896747103E-01],
	[2.8220000000E+04, 9.3137897826E-01, 1.6884676884E+00, 3.9713951667E-02, 3.7249500353E-02, 7.4900438145E-01],
	[2.8225000000E+04, 9.3164022107E-01, 1.6884190740E+00, 3.9735021111E-02, 3.7268429871E-02, 7.4904127252E-01],
	[2.8230000000E+04, 9.3190149085E-01, 1.6883704695E+00, 3.9756097998E-02, 3.7287365321E-02, 7.4907814424E-01],
	[2.8235000000E+04, 9.3216278762E-01, 1.6883218751E+00, 3.9777182330E-02, 3.7306306704E-02, 7.4911499662E-01],
	[2.8240000000E+04, 9.3242411137E-01, 1.6882732906E+00, 3.9798274107E-02, 3.7325254019E-02, 7.4915182967E-01],
	[2.8245000000E+04, 9.3268546209E-01, 1.6882247162E+00, 3.9819373331E-02, 3.7344207269E-02, 7.4918864340E-01],
	[2.8250000000E+04, 9.3294683979E-01, 1.6881761518E+00, 3.9840480003E-02, 3.7363166453E-02, 7.4922543783E-01],
	[2.8255000000E+04, 9.3320824445E-01, 1.6881275973E+00, 3.9861594124E-02, 3.7382131571E-02, 7.4926221295E-01],
	[2.8260000000E+04, 9.3346967609E-01, 1.6880790528E+00, 3.9882715696E-02, 3.7401102625E-02, 7.4929896877E-01],
	[2.8265000000E+04, 9.3373113470E-01, 1.6880305184E+00, 3.9903844721E-02, 3.7420079614E-02, 7.4933570532E-01],
	[2.8270000000E+04, 9.3399262027E-01, 1.6879819939E+00, 3.9924981198E-02, 3.7439062539E-02, 7.4937242259E-01],
	[2.8275000000E+04, 9.3425413281E-01, 1.6879334793E+00, 3.9946125131E-02, 3.7458051401E-02, 7.4940912060E-01],
	[2.8280000000E+04, 9.3451567231E-01, 1.6878849748E+00, 3.9967276519E-02, 3.7477046200E-02, 7.4944579936E-01],
	[2.8285000000E+04, 9.3477723877E-01, 1.6878364802E+00, 3.9988435365E-02, 3.7496046937E-02, 7.4948245887E-01],
	[2.8290000000E+04, 9.3503883218E-01, 1.6877879956E+00, 4.0009601670E-02, 3.7515053612E-02, 7.4951909914E-01],
	[2.8295000000E+04, 9.3530045256E-01, 1.6877395209E+00, 4.0030775434E-02, 3.7534066225E-02, 7.4955572019E-01],
	[2.8300000000E+04, 9.3556209989E-01, 1.6876910562E+00, 4.0051956660E-02, 3.7553084777E-02, 7.4959232202E-01],
	[2.8305000000E+04, 9.3582377417E-01, 1.6876426015E+00, 4.0073145348E-02, 3.7572109269E-02, 7.4962890465E-01],
	[2.8310000000E+04, 9.3608547540E-01, 1.6875941567E+00, 4.0094341500E-02, 3.7591139701E-02, 7.4966546808E-01],
	[2.8315000000E+04, 9.3634720357E-01, 1.6875457218E+00, 4.0115545117E-02, 3.7610176073E-02, 7.4970201231E-01],
	[2.8320000000E+04, 9.3660895870E-01, 1.6874972969E+00, 4.0136756201E-02, 3.7629218386E-02, 7.4973853737E-01],
	[2.8325000000E+04, 9.3687074077E-01, 1.6874488819E+00, 4.0157974753E-02, 3.7648266641E-02, 7.4977504326E-01],
	[2.8330000000E+04, 9.3713254978E-01, 1.6874004769E+00, 4.0179200774E-02, 3.7667320837E-02, 7.4981152999E-01],
	[2.8335000000E+04, 9.3739438573E-01, 1.6873520818E+00, 4.0200434265E-02, 3.7686380977E-02, 7.4984799756E-01],
	[2.8340000000E+04, 9.3765624862E-01, 1.6873036966E+00, 4.0221675228E-02, 3.7705447059E-02, 7.4988444600E-01],
	[2.8345000000E+04, 9.3791813845E-01, 1.6872553213E+00, 4.0242923664E-02, 3.7724519084E-02, 7.4992087530E-01],
	[2.8350000000E+04, 9.3818005521E-01, 1.6872069560E+00, 4.0264179575E-02, 3.7743597053E-02, 7.4995728548E-01],
	[2.8355000000E+04, 9.3844199890E-01, 1.6871586006E+00, 4.0285442961E-02, 3.7762680967E-02, 7.4999367655E-01],
	[2.8360000000E+04, 9.3870396953E-01, 1.6871102551E+00, 4.0306713824E-02, 3.7781770825E-02, 7.5003004851E-01],
	[2.8365000000E+04, 9.3896596708E-01, 1.6870619195E+00, 4.0327992165E-02, 3.7800866629E-02, 7.5006640138E-01],
	[2.8370000000E+04, 9.3922799156E-01, 1.6870135938E+00, 4.0349277986E-02, 3.7819968378E-02, 7.5010273516E-01],
	[2.8375000000E+04, 9.3949004296E-01, 1.6869652780E+00, 4.0370571288E-02, 3.7839076074E-02, 7.5013904986E-01],
	[2.8380000000E+04, 9.3975212129E-01, 1.6869169720E+00, 4.0391872073E-02, 3.7858189717E-02, 7.5017534550E-01],
	[2.8385000000E+04, 9.4001422654E-01, 1.6868686760E+00, 4.0413180340E-02, 3.7877309307E-02, 7.5021162208E-01],
	[2.8390000000E+04, 9.4027635870E-01, 1.6868203899E+00, 4.0434496093E-02, 3.7896434844E-02, 7.5024787961E-01],
	[2.8395000000E+04, 9.4053851778E-01, 1.6867721137E+00, 4.0455819332E-02, 3.7915566330E-02, 7.5028411811E-01],
	[2.8400000000E+04, 9.4080070378E-01, 1.6867238473E+00, 4.0477150058E-02, 3.7934703764E-02, 7.5032033757E-01],
	[2.8405000000E+04, 9.4106291669E-01, 1.6866755908E+00, 4.0498488273E-02, 3.7953847148E-02, 7.5035653802E-01],
	[2.8410000000E+04, 9.4132515651E-01, 1.6866273442E+00, 4.0519833978E-02, 3.7972996481E-02, 7.5039271945E-01],
	[2.8415000000E+04, 9.4158742324E-01, 1.6865791075E+00, 4.0541187175E-02, 3.7992151764E-02, 7.5042888189E-01],
	[2.8420000000E+04, 9.4184971687E-01, 1.6865308806E+00, 4.0562547864E-02, 3.8011312998E-02, 7.5046502533E-01],
	[2.8425000000E+04, 9.4211203741E-01, 1.6864826636E+00, 4.0583916047E-02, 3.8030480183E-02, 7.5050114979E-01],
	[2.8430000000E+04, 9.4237438485E-01, 1.6864344565E+00, 4.0605291726E-02, 3.8049653320E-02, 7.5053725528E-01],
	[2.8435000000E+04, 9.4263675920E-01, 1.6863862592E+00, 4.0626674901E-02, 3.8068832408E-02, 7.5057334180E-01],
	[2.8440000000E+04, 9.4289916044E-01, 1.6863380717E+00, 4.0648065574E-02, 3.8088017449E-02, 7.5060940937E-01],
	[2.8445000000E+04, 9.4316158858E-01, 1.6862898941E+00, 4.0669463747E-02, 3.8107208443E-02, 7.5064545800E-01],
	[2.8450000000E+04, 9.4342404361E-01, 1.6862417264E+00, 4.0690869420E-02, 3.8126405390E-02, 7.5068148769E-01],
	[2.8455000000E+04, 9.4368652554E-01, 1.6861935685E+00, 4.0712282595E-02, 3.8145608292E-02, 7.5071749845E-01],
	[2.8460000000E+04, 9.4394903435E-01, 1.6861454204E+00, 4.0733703273E-02, 3.8164817147E-02, 7.5075349030E-01],
	[2.8465000000E+04, 9.4421157006E-01, 1.6860972822E+00, 4.0755131456E-02, 3.8184031958E-02, 7.5078946324E-01],
	[2.8470000000E+04, 9.4447413266E-01, 1.6860491538E+00, 4.0776567144E-02, 3.8203252724E-02, 7.5082541728E-01],
	[2.8475000000E+04, 9.4473672213E-01, 1.6860010352E+00, 4.0798010340E-02, 3.8222479445E-02, 7.5086135243E-01],
	[2.8480000000E+04, 9.4499933850E-01, 1.6859529264E+00, 4.0819461044E-02, 3.8241712124E-02, 7.5089726871E-01],
	[2.8485000000E+04, 9.4526198174E-01, 1.6859048275E+00, 4.0840919257E-02, 3.8260950758E-02, 7.5093316612E-01],
	[2.8490000000E+04, 9.4552465186E-01, 1.6858567383E+00, 4.0862384982E-02, 3.8280195350E-02, 7.5096904466E-01],
	[2.8495000000E+04, 9.4578734886E-01, 1.6858086590E+00, 4.0883858219E-02, 3.8299445900E-02, 7.5100490436E-01],
	[2.8500000000E+04, 9.4605007273E-01, 1.6857605895E+00, 4.0905338970E-02, 3.8318702408E-02, 7.5104074521E-01],
	[2.8505000000E+04, 9.4631282348E-01, 1.6857125298E+00, 4.0926827236E-02, 3.8337964875E-02, 7.5107656723E-01],
	[2.8510000000E+04, 9.4657583556E-01, 1.6856648299E+00, 4.0948323018E-02, 3.8357233866E-02, 7.5111237043E-01],
	[2.8515000000E+04, 9.4683945999E-01, 1.6856180136E+00, 4.0969826318E-02, 3.8376510233E-02, 7.5114815482E-01],
	[2.8520000000E+04, 9.4710311160E-01, 1.6855712068E+00, 4.0991337137E-02, 3.8395792563E-02, 7.5118392040E-01],
	[2.8525000000E+04, 9.4736679039E-01, 1.6855244096E+00, 4.1012855476E-02, 3.8415080857E-02, 7.5121966719E-01],
	[2.8530000000E+04, 9.4763049636E-01, 1.6854776218E+00, 4.1034381336E-02, 3.8434375114E-02, 7.5125539520E-01],
	[2.8535000000E+04, 9.4789422950E-01, 1.6854308435E+00, 4.1055914720E-02, 3.8453675336E-02, 7.5129110443E-01],
	[2.8540000000E+04, 9.4815798981E-01, 1.6853840747E+00, 4.1077455627E-02, 3.8472981523E-02, 7.5132679489E-01],
	[2.8545000000E+04, 9.4842177729E-01, 1.6853373154E+00, 4.1099004060E-02, 3.8492293675E-02, 7.5136246659E-01],
	[2.8550000000E+04, 9.4868559193E-01, 1.6852905655E+00, 4.1120560020E-02, 3.8511611793E-02, 7.5139811955E-01],
	[2.8555000000E+04, 9.4894943375E-01, 1.6852438252E+00, 4.1142123508E-02, 3.8530935877E-02, 7.5143375377E-01],
	[2.8560000000E+04, 9.4921330273E-01, 1.6851970943E+00, 4.1163694525E-02, 3.8550265928E-02, 7.5146936927E-01],
	[2.8565000000E+04, 9.4947719886E-01, 1.6851503730E+00, 4.1185273073E-02, 3.8569601946E-02, 7.5150496604E-01],
	[2.8570000000E+04, 9.4974112216E-01, 1.6851036611E+00, 4.1206859153E-02, 3.8588943932E-02, 7.5154054410E-01],
	[2.8575000000E+04, 9.5000507262E-01, 1.6850569586E+00, 4.1228452766E-02, 3.8608291886E-02, 7.5157610347E-01],
	[2.8580000000E+04, 9.5026905023E-01, 1.6850102656E+00, 4.1250053914E-02, 3.8627645809E-02, 7.5161164414E-01],
	[2.8585000000E+04, 9.5053305500E-01, 1.6849635821E+00, 4.1271662598E-02, 3.8647005701E-02, 7.5164716613E-01],
	[2.8590000000E+04, 9.5079708692E-01, 1.6849169081E+00, 4.1293278819E-02, 3.8666371562E-02, 7.5168266945E-01],
	[2.8595000000E+04, 9.5106114599E-01, 1.6848702435E+00, 4.1314902579E-02, 3.8685743394E-02, 7.5171815411E-01],
	[2.8600000000E+04, 9.5132523220E-01, 1.6848235883E+00, 4.1336533879E-02, 3.8705121196E-02, 7.5175362011E-01],
	[2.8605000000E+04, 9.5158934557E-01, 1.6847769426E+00, 4.1358172719E-02, 3.8724504969E-02, 7.5178906747E-01],
	[2.8610000000E+04, 9.5185348607E-01, 1.6847303064E+00, 4.1379819103E-02, 3.8743894714E-02, 7.5182449620E-01],
	[2.8615000000E+04, 9.5211765372E-01, 1.6846836795E+00, 4.1401473030E-02, 3.8763290430E-02, 7.5185990630E-01],
	[2.8620000000E+04, 9.5238184851E-01, 1.6846370621E+00, 4.1423134502E-02, 3.8782692119E-02, 7.5189529778E-01],
	[2.8625000000E+04, 9.5264607044E-01, 1.6845904542E+00, 4.1444803521E-02, 3.8802099781E-02, 7.5193067066E-01],
	[2.8630000000E+04, 9.5291031950E-01, 1.6845438557E+00, 4.1466480087E-02, 3.8821513416E-02, 7.5196602495E-01],
	[2.8635000000E+04, 9.5317459570E-01, 1.6844972666E+00, 4.1488164203E-02, 3.8840933025E-02, 7.5200136064E-01],
	[2.8640000000E+04, 9.5343889903E-01, 1.6844506869E+00, 4.1509855869E-02, 3.8860358608E-02, 7.5203667776E-01],
	[2.8645000000E+04, 9.5370322949E-01, 1.6844041167E+00, 4.1531555086E-02, 3.8879790166E-02, 7.5207197631E-01],
	[2.8650000000E+04, 9.5396758708E-01, 1.6843575558E+00, 4.1553261857E-02, 3.8899227699E-02, 7.5210725630E-01],
	[2.8655000000E+04, 9.5423197180E-01, 1.6843110044E+00, 4.1574976181E-02, 3.8918671208E-02, 7.5214251774E-01],
	[2.8660000000E+04, 9.5449638364E-01, 1.6842644624E+00, 4.1596698062E-02, 3.8938120693E-02, 7.5217776064E-01],
	[2.8665000000E+04, 9.5476082261E-01, 1.6842179298E+00, 4.1618427499E-02, 3.8957576154E-02, 7.5221298501E-01],
	[2.8670000000E+04, 9.5502528869E-01, 1.6841714066E+00, 4.1640164495E-02, 3.8977037593E-02, 7.5224819085E-01],
	[2.8675000000E+04, 9.5528978189E-01, 1.6841248927E+00, 4.1661909050E-02, 3.8996505009E-02, 7.5228337819E-01],
	[2.8680000000E+04, 9.5555430221E-01, 1.6840783883E+00, 4.1683661166E-02, 3.9015978403E-02, 7.5231854702E-01],
	[2.8685000000E+04, 9.5581884965E-01, 1.6840318933E+00, 4.1705420844E-02, 3.9035457775E-02, 7.5235369736E-01],
	[2.8690000000E+04, 9.5608342420E-01, 1.6839854076E+00, 4.1727188085E-02, 3.9054943127E-02, 7.5238882922E-01],
	[2.8695000000E+04, 9.5634802586E-01, 1.6839389314E+00, 4.1748962892E-02, 3.9074434458E-02, 7.5242394260E-01],
	[2.8700000000E+04, 9.5661265462E-01, 1.6838924645E+00, 4.1770745264E-02, 3.9093931768E-02, 7.5245903751E-01],
	[2.8705000000E+04, 9.5687731050E-01, 1.6838460070E+00, 4.1792535204E-02, 3.9113435059E-02, 7.5249411398E-01],
	[2.8710000000E+04, 9.5714199348E-01, 1.6837995589E+00, 4.1814332713E-02, 3.9132944331E-02, 7.5252917199E-01],
	[2.8715000000E+04, 9.5740670356E-01, 1.6837531201E+00, 4.1836137791E-02, 3.9152459584E-02, 7.5256421157E-01],
	[2.8720000000E+04, 9.5767144075E-01, 1.6837066907E+00, 4.1857950441E-02, 3.9171980819E-02, 7.5259923272E-01],
	[2.8725000000E+04, 9.5793620503E-01, 1.6836602707E+00, 4.1879770664E-02, 3.9191508036E-02, 7.5263423545E-01],
	[2.8730000000E+04, 9.5820099641E-01, 1.6836138600E+00, 4.1901598460E-02, 3.9211041235E-02, 7.5266921978E-01],
	[2.8735000000E+04, 9.5846581489E-01, 1.6835674587E+00, 4.1923433832E-02, 3.9230580418E-02, 7.5270418570E-01],
	[2.8740000000E+04, 9.5873066046E-01, 1.6835210667E+00, 4.1945276780E-02, 3.9250125584E-02, 7.5273913324E-01],
	[2.8745000000E+04, 9.5899553312E-01, 1.6834746841E+00, 4.1967127306E-02, 3.9269676734E-02, 7.5277406239E-01],
	[2.8750000000E+04, 9.5926043288E-01, 1.6834283108E+00, 4.1988985412E-02, 3.9289233868E-02, 7.5280897318E-01],
	[2.8755000000E+04, 9.5952535971E-01, 1.6833819469E+00, 4.2010851097E-02, 3.9308796988E-02, 7.5284386560E-01],
	[2.8760000000E+04, 9.5979031364E-01, 1.6833355923E+00, 4.2032724365E-02, 3.9328366093E-02, 7.5287873967E-01],
	[2.8765000000E+04, 9.6005529465E-01, 1.6832892471E+00, 4.2054605216E-02, 3.9347941183E-02, 7.5291359540E-01],
	[2.8770000000E+04, 9.6032030274E-01, 1.6832429111E+00, 4.2076493651E-02, 3.9367522260E-02, 7.5294843279E-01],
	[2.8775000000E+04, 9.6058533791E-01, 1.6831965845E+00, 4.2098389672E-02, 3.9387109324E-02, 7.5298325186E-01],
	[2.8780000000E+04, 9.6085040016E-01, 1.6831502672E+00, 4.2120293280E-02, 3.9406702375E-02, 7.5301805262E-01],
	[2.8785000000E+04, 9.6111548948E-01, 1.6831039593E+00, 4.2142204476E-02, 3.9426301413E-02, 7.5305283507E-01],
	[2.8790000000E+04, 9.6138060588E-01, 1.6830576607E+00, 4.2164123262E-02, 3.9445906440E-02, 7.5308759923E-01],
	[2.8795000000E+04, 9.6164574935E-01, 1.6830113713E+00, 4.2186049639E-02, 3.9465517455E-02, 7.5312234510E-01],
	[2.8800000000E+04, 9.6191091989E-01, 1.6829650913E+00, 4.2207983609E-02, 3.9485134459E-02, 7.5315707269E-01],
	[2.8805000000E+04, 9.6217611750E-01, 1.6829188206E+00, 4.2229925172E-02, 3.9504757453E-02, 7.5319178202E-01],
	[2.8810000000E+04, 9.6244134218E-01, 1.6828725592E+00, 4.2251874330E-02, 3.9524386437E-02, 7.5322647308E-01],
	[2.8815000000E+04, 9.6270659392E-01, 1.6828263071E+00, 4.2273831084E-02, 3.9544021411E-02, 7.5326114590E-01],
	[2.8820000000E+04, 9.6297187272E-01, 1.6827800643E+00, 4.2295795435E-02, 3.9563662376E-02, 7.5329580048E-01],
	[2.8825000000E+04, 9.6323717858E-01, 1.6827338307E+00, 4.2317767386E-02, 3.9583309332E-02, 7.5333043683E-01],
	[2.8830000000E+04, 9.6350251150E-01, 1.6826876065E+00, 4.2339746936E-02, 3.9602962280E-02, 7.5336505496E-01],
	[2.8835000000E+04, 9.6376787148E-01, 1.6826413916E+00, 4.2361734088E-02, 3.9622621221E-02, 7.5339965488E-01],
	[2.8840000000E+04, 9.6403325852E-01, 1.6825951859E+00, 4.2383728843E-02, 3.9642286153E-02, 7.5343423659E-01],
	[2.8845000000E+04, 9.6429867260E-01, 1.6825489895E+00, 4.2405731202E-02, 3.9661957080E-02, 7.5346880012E-01],
	[2.8850000000E+04, 9.6456411374E-01, 1.6825028024E+00, 4.2427741166E-02, 3.9681633999E-02, 7.5350334546E-01],
	[2.8855000000E+04, 9.6482958192E-01, 1.6824566246E+00, 4.2449758737E-02, 3.9701316913E-02, 7.5353787263E-01],
	[2.8860000000E+04, 9.6509507716E-01, 1.6824104560E+00, 4.2471783916E-02, 3.9721005821E-02, 7.5357238163E-01],
	[2.8865000000E+04, 9.6536059943E-01, 1.6823642967E+00, 4.2493816704E-02, 3.9740700724E-02, 7.5360687248E-01],
	[2.8870000000E+04, 9.6562614875E-01, 1.6823181466E+00, 4.2515857103E-02, 3.9760401623E-02, 7.5364134519E-01],
	[2.8875000000E+04, 9.6589172512E-01, 1.6822720059E+00, 4.2537905114E-02, 3.9780108517E-02, 7.5367579975E-01],
	[2.8880000000E+04, 9.6615732852E-01, 1.6822258743E+00, 4.2559960738E-02, 3.9799821407E-02, 7.5371023620E-01],
	[2.8885000000E+04, 9.6642295896E-01, 1.6821797520E+00, 4.2582023977E-02, 3.9819540295E-02, 7.5374465452E-01],
	[2.8890000000E+04, 9.6668861643E-01, 1.6821336390E+00, 4.2604094832E-02, 3.9839265179E-02, 7.5377905474E-01],
	[2.8895000000E+04, 9.6695430094E-01, 1.6820875352E+00, 4.2626173303E-02, 3.9858996062E-02, 7.5381343686E-01],
	[2.8900000000E+04, 9.6722001248E-01, 1.6820414407E+00, 4.2648259394E-02, 3.9878732942E-02, 7.5384780089E-01],
	[2.8905000000E+04, 9.6748575105E-01, 1.6819953553E+00, 4.2670353104E-02, 3.9898475821E-02, 7.5388214684E-01],
	[2.8910000000E+04, 9.6775151664E-01, 1.6819492793E+00, 4.2692454435E-02, 3.9918224698E-02, 7.5391647472E-01],
	[2.8915000000E+04, 9.6801730926E-01, 1.6819032124E+00, 4.2714563388E-02, 3.9937979576E-02, 7.5395078453E-01],
	[2.8920000000E+04, 9.6828312891E-01, 1.6818571548E+00, 4.2736679966E-02, 3.9957740453E-02, 7.5398507629E-01],
	[2.8925000000E+04, 9.6854897558E-01, 1.6818111064E+00, 4.2758804168E-02, 3.9977507330E-02, 7.5401935000E-01],
	[2.8930000000E+04, 9.6881484927E-01, 1.6817650672E+00, 4.2780935997E-02, 3.9997280209E-02, 7.5405360568E-01],
	[2.8935000000E+04, 9.6908074997E-01, 1.6817190372E+00, 4.2803075453E-02, 4.0017059088E-02, 7.5408784332E-01],
	[2.8940000000E+04, 9.6934667770E-01, 1.6816730165E+00, 4.2825222538E-02, 4.0036843969E-02, 7.5412206294E-01],
	[2.8945000000E+04, 9.6961263243E-01, 1.6816270049E+00, 4.2847377254E-02, 4.0056634853E-02, 7.5415626455E-01],
	[2.8950000000E+04, 9.6987861418E-01, 1.6815810026E+00, 4.2869539601E-02, 4.0076431739E-02, 7.5419044815E-01],
	[2.8955000000E+04, 9.7014462294E-01, 1.6815350095E+00, 4.2891709581E-02, 4.0096234628E-02, 7.5422461376E-01],
	[2.8960000000E+04, 9.7041065871E-01, 1.6814890255E+00, 4.2913887196E-02, 4.0116043520E-02, 7.5425876137E-01],
	[2.8965000000E+04, 9.7067672148E-01, 1.6814430508E+00, 4.2936072446E-02, 4.0135858416E-02, 7.5429289101E-01],
	[2.8970000000E+04, 9.7094317685E-01, 1.6813976801E+00, 4.2958265332E-02, 4.0155680282E-02, 7.5432700267E-01],
	[2.8975000000E+04, 9.7121003066E-01, 1.6813529224E+00, 4.2980465857E-02, 4.0175509133E-02, 7.5436109637E-01],
	[2.8980000000E+04, 9.7147691174E-01, 1.6813081736E+00, 4.3002674021E-02, 4.0195343993E-02, 7.5439517212E-01],
	[2.8985000000E+04, 9.7174382010E-01, 1.6812634338E+00, 4.3024889827E-02, 4.0215184862E-02, 7.5442922991E-01],
	[2.8990000000E+04, 9.7201075573E-01, 1.6812187028E+00, 4.3047113274E-02, 4.0235031739E-02, 7.5446326977E-01],
	[2.8995000000E+04, 9.7227771863E-01, 1.6811739808E+00, 4.3069344364E-02, 4.0254884626E-02, 7.5449729170E-01],
	[2.9000000000E+04, 9.7254470881E-01, 1.6811292676E+00, 4.3091583099E-02, 4.0274743523E-02, 7.5453129570E-01],
	[2.9005000000E+04, 9.7281172625E-01, 1.6810845634E+00, 4.3113829481E-02, 4.0294608430E-02, 7.5456528179E-01],
	[2.9010000000E+04, 9.7307877096E-01, 1.6810398680E+00, 4.3136083509E-02, 4.0314479348E-02, 7.5459924997E-01],
	[2.9015000000E+04, 9.7334584294E-01, 1.6809951815E+00, 4.3158345186E-02, 4.0334356277E-02, 7.5463320026E-01],
	[2.9020000000E+04, 9.7361294217E-01, 1.6809505039E+00, 4.3180614513E-02, 4.0354239217E-02, 7.5466713266E-01],
	[2.9025000000E+04, 9.7388006867E-01, 1.6809058352E+00, 4.3202891492E-02, 4.0374128170E-02, 7.5470104717E-01],
	[2.9030000000E+04, 9.7414722243E-01, 1.6808611754E+00, 4.3225176123E-02, 4.0394023136E-02, 7.5473494382E-01],
	[2.9035000000E+04, 9.7441440344E-01, 1.6808165245E+00, 4.3247468407E-02, 4.0413924114E-02, 7.5476882260E-01],
	[2.9040000000E+04, 9.7468161171E-01, 1.6807718824E+00, 4.3269768347E-02, 4.0433831106E-02, 7.5480268352E-01],
	[2.9045000000E+04, 9.7494884723E-01, 1.6807272492E+00, 4.3292075944E-02, 4.0453744112E-02, 7.5483652660E-01],
	[2.9050000000E+04, 9.7521611001E-01, 1.6806826249E+00, 4.3314391198E-02, 4.0473663132E-02, 7.5487035184E-01],
	[2.9055000000E+04, 9.7548340003E-01, 1.6806380094E+00, 4.3336714111E-02, 4.0493588167E-02, 7.5490415925E-01],
	[2.9060000000E+04, 9.7575071730E-01, 1.6805934028E+00, 4.3359044685E-02, 4.0513519217E-02, 7.5493794883E-01],
	[2.9065000000E+04, 9.7601806182E-01, 1.6805488051E+00, 4.3381382921E-02, 4.0533456283E-02, 7.5497172060E-01],
	[2.9070000000E+04, 9.7628543357E-01, 1.6805042162E+00, 4.3403728819E-02, 4.0553399365E-02, 7.5500547457E-01],
	[2.9075000000E+04, 9.7655283258E-01, 1.6804596362E+00, 4.3426082382E-02, 4.0573348463E-02, 7.5503921074E-01],
	[2.9080000000E+04, 9.7682025882E-01, 1.6804150650E+00, 4.3448443610E-02, 4.0593303579E-02, 7.5507292912E-01],
	[2.9085000000E+04, 9.7708771230E-01, 1.6803705026E+00, 4.3470812506E-02, 4.0613264712E-02, 7.5510662972E-01],
	[2.9090000000E+04, 9.7735519301E-01, 1.6803259491E+00, 4.3493189070E-02, 4.0633231863E-02, 7.5514031254E-01],
	[2.9095000000E+04, 9.7762270096E-01, 1.6802814045E+00, 4.3515573303E-02, 4.0653205032E-02, 7.5517397760E-01],
	[2.9100000000E+04, 9.7789023614E-01, 1.6802368686E+00, 4.3537965207E-02, 4.0673184219E-02, 7.5520762491E-01],
	[2.9105000000E+04, 9.7815779855E-01, 1.6801923416E+00, 4.3560364784E-02, 4.0693169427E-02, 7.5524125447E-01],
	[2.9110000000E+04, 9.7842538819E-01, 1.6801478235E+00, 4.3582772034E-02, 4.0713160653E-02, 7.5527486629E-01],
	[2.9115000000E+04, 9.7869300505E-01, 1.6801033141E+00, 4.3605186958E-02, 4.0733157900E-02, 7.5530846039E-01],
	[2.9120000000E+04, 9.7896064914E-01, 1.6800588136E+00, 4.3627609559E-02, 4.0753161167E-02, 7.5534203676E-01],
	[2.9125000000E+04, 9.7922832046E-01, 1.6800143219E+00, 4.3650039838E-02, 4.0773170455E-02, 7.5537559541E-01],
	[2.9130000000E+04, 9.7949601899E-01, 1.6799698390E+00, 4.3672477795E-02, 4.0793185765E-02, 7.5540913636E-01],
	[2.9135000000E+04, 9.7976374474E-01, 1.6799253649E+00, 4.3694923432E-02, 4.0813207096E-02, 7.5544265962E-01],
	[2.9140000000E+04, 9.8003149771E-01, 1.6798808996E+00, 4.3717376750E-02, 4.0833234450E-02, 7.5547616518E-01],
	[2.9145000000E+04, 9.8029927790E-01, 1.6798364432E+00, 4.3739837752E-02, 4.0853267827E-02, 7.5550965307E-01],
	[2.9150000000E+04, 9.8056708529E-01, 1.6797919955E+00, 4.3762306437E-02, 4.0873307226E-02, 7.5554312328E-01],
	[2.9155000000E+04, 9.8083491990E-01, 1.6797475567E+00, 4.3784782807E-02, 4.0893352649E-02, 7.5557657583E-01],
	[2.9160000000E+04, 9.8110278172E-01, 1.6797031266E+00, 4.3807266865E-02, 4.0913404096E-02, 7.5561001073E-01],
	[2.9165000000E+04, 9.8137067074E-01, 1.6796587053E+00, 4.3829758610E-02, 4.0933461568E-02, 7.5564342798E-01],
	[2.9170000000E+04, 9.8163858698E-01, 1.6796142928E+00, 4.3852258044E-02, 4.0953525064E-02, 7.5567682759E-01],
	[2.9175000000E+04, 9.8190653041E-01, 1.6795698891E+00, 4.3874765169E-02, 4.0973594586E-02, 7.5571020957E-01],
	[2.9180000000E+04, 9.8217450105E-01, 1.6795254942E+00, 4.3897279986E-02, 4.0993670134E-02, 7.5574357393E-01],
	[2.9185000000E+04, 9.8244249888E-01, 1.6794811081E+00, 4.3919802496E-02, 4.1013751707E-02, 7.5577692068E-01],
	[2.9190000000E+04, 9.8271052391E-01, 1.6794367307E+00, 4.3942332700E-02, 4.1033839308E-02, 7.5581024982E-01],
	[2.9195000000E+04, 9.8297857614E-01, 1.6793923621E+00, 4.3964870600E-02, 4.1053932935E-02, 7.5584356137E-01],
	[2.9200000000E+04, 9.8324665557E-01, 1.6793480023E+00, 4.3987416197E-02, 4.1074032590E-02, 7.5587685533E-01],
	[2.9205000000E+04, 9.8351476218E-01, 1.6793036513E+00, 4.4009969493E-02, 4.1094138273E-02, 7.5591013171E-01],
	[2.9210000000E+04, 9.8378289599E-01, 1.6792593090E+00, 4.4032530488E-02, 4.1114249984E-02, 7.5594339052E-01],
	[2.9215000000E+04, 9.8405105698E-01, 1.6792149755E+00, 4.4055099185E-02, 4.1134367724E-02, 7.5597663176E-01],
	[2.9220000000E+04, 9.8431924516E-01, 1.6791706507E+00, 4.4077675584E-02, 4.1154491493E-02, 7.5600985546E-01],
	[2.9225000000E+04, 9.8458746053E-01, 1.6791263347E+00, 4.4100259686E-02, 4.1174621292E-02, 7.5604306160E-01],
	[2.9230000000E+04, 9.8485570308E-01, 1.6790820274E+00, 4.4122851493E-02, 4.1194757121E-02, 7.5607625021E-01],
	[2.9235000000E+04, 9.8512397281E-01, 1.6790377289E+00, 4.4145451007E-02, 4.1214898980E-02, 7.5610942129E-01],
	[2.9240000000E+04, 9.8539226971E-01, 1.6789934391E+00, 4.4168058228E-02, 4.1235046870E-02, 7.5614257486E-01],
	[2.9245000000E+04, 9.8566059380E-01, 1.6789491581E+00, 4.4190673158E-02, 4.1255200792E-02, 7.5617571091E-01],
	[2.9250000000E+04, 9.8592894506E-01, 1.6789048858E+00, 4.4213295798E-02, 4.1275360746E-02, 7.5620882945E-01],
	[2.9255000000E+04, 9.8619732349E-01, 1.6788606222E+00, 4.4235926150E-02, 4.1295526732E-02, 7.5624193050E-01],
	[2.9260000000E+04, 9.8646572909E-01, 1.6788163674E+00, 4.4258564215E-02, 4.1315698750E-02, 7.5627501407E-01],
	[2.9265000000E+04, 9.8673416187E-01, 1.6787721213E+00, 4.4281209994E-02, 4.1335876802E-02, 7.5630808015E-01],
	[2.9270000000E+04, 9.8700262181E-01, 1.6787278839E+00, 4.4303863488E-02, 4.1356060887E-02, 7.5634112877E-01],
	[2.9275000000E+04, 9.8727110892E-01, 1.6786836553E+00, 4.4326524699E-02, 4.1376251006E-02, 7.5637415992E-01],
	[2.9280000000E+04, 9.8753962319E-01, 1.6786394353E+00, 4.4349193628E-02, 4.1396447159E-02, 7.5640717363E-01],
	[2.9285000000E+04, 9.8780816462E-01, 1.6785952241E+00, 4.4371870276E-02, 4.1416649347E-02, 7.5644016988E-01],
	[2.9290000000E+04, 9.8807673321E-01, 1.6785510216E+00, 4.4394554645E-02, 4.1436857571E-02, 7.5647314871E-01],
	[2.9295000000E+04, 9.8834532896E-01, 1.6785068278E+00, 4.4417246736E-02, 4.1457071830E-02, 7.5650611010E-01],
	[2.9300000000E+04, 9.8861395187E-01, 1.6784626427E+00, 4.4439946550E-02, 4.1477292125E-02, 7.5653905407E-01],
	[2.9305000000E+04, 9.8888260193E-01, 1.6784184663E+00, 4.4462654089E-02, 4.1497518457E-02, 7.5657198064E-01],
	[2.9310000000E+04, 9.8915127914E-01, 1.6783742986E+00, 4.4485369354E-02, 4.1517750826E-02, 7.5660488980E-01],
	[2.9315000000E+04, 9.8941998351E-01, 1.6783301396E+00, 4.4508092346E-02, 4.1537989232E-02, 7.5663778157E-01],
	[2.9320000000E+04, 9.8968871502E-01, 1.6782859893E+00, 4.4530823067E-02, 4.1558233676E-02, 7.5667065595E-01],
	[2.9325000000E+04, 9.8995747368E-01, 1.6782418477E+00, 4.4553561517E-02, 4.1578484158E-02, 7.5670351296E-01],
	[2.9330000000E+04, 9.9022625948E-01, 1.6781977148E+00, 4.4576307699E-02, 4.1598740679E-02, 7.5673635260E-01],
	[2.9335000000E+04, 9.9049507243E-01, 1.6781535905E+00, 4.4599061613E-02, 4.1619003239E-02, 7.5676917487E-01],
	[2.9340000000E+04, 9.9076391252E-01, 1.6781094750E+00, 4.4621823260E-02, 4.1639271838E-02, 7.5680197980E-01],
	[2.9345000000E+04, 9.9103277975E-01, 1.6780653681E+00, 4.4644592643E-02, 4.1659546478E-02, 7.5683476738E-01],
	[2.9350000000E+04, 9.9130167411E-01, 1.6780212698E+00, 4.4667369763E-02, 4.1679827157E-02, 7.5686753763E-01],
	[2.9355000000E+04, 9.9157059561E-01, 1.6779771803E+00, 4.4690154620E-02, 4.1700113878E-02, 7.5690029056E-01],
	[2.9360000000E+04, 9.9183954425E-01, 1.6779330994E+00, 4.4712947216E-02, 4.1720406640E-02, 7.5693302616E-01],
	[2.9365000000E+04, 9.9210852001E-01, 1.6778890272E+00, 4.4735747552E-02, 4.1740705443E-02, 7.5696574446E-01],
	[2.9370000000E+04, 9.9237752291E-01, 1.6778449637E+00, 4.4758555630E-02, 4.1761010288E-02, 7.5699844545E-01],
	[2.9375000000E+04, 9.9264655293E-01, 1.6778009088E+00, 4.4781371451E-02, 4.1781321176E-02, 7.5703112915E-01],
	[2.9380000000E+04, 9.9291561008E-01, 1.6777568625E+00, 4.4804195016E-02, 4.1801638107E-02, 7.5706379557E-01],
	[2.9385000000E+04, 9.9318469435E-01, 1.6777128249E+00, 4.4827026327E-02, 4.1821961081E-02, 7.5709644471E-01],
	[2.9390000000E+04, 9.9345380575E-01, 1.6776687960E+00, 4.4849865385E-02, 4.1842290099E-02, 7.5712907659E-01],
	[2.9395000000E+04, 9.9372294426E-01, 1.6776247757E+00, 4.4872712191E-02, 4.1862625161E-02, 7.5716169121E-01],
	[2.9400000000E+04, 9.9399210990E-01, 1.6775807640E+00, 4.4895566746E-02, 4.1882966267E-02, 7.5719428857E-01],
	[2.9405000000E+04, 9.9426130265E-01, 1.6775367610E+00, 4.4918429052E-02, 4.1903313419E-02, 7.5722686870E-01],
	[2.9410000000E+04, 9.9453052252E-01, 1.6774927666E+00, 4.4941299110E-02, 4.1923666616E-02, 7.5725943159E-01],
	[2.9415000000E+04, 9.9479976949E-01, 1.6774487809E+00, 4.4964176922E-02, 4.1944025858E-02, 7.5729197726E-01],
	[2.9420000000E+04, 9.9506904358E-01, 1.6774048038E+00, 4.4987062488E-02, 4.1964391147E-02, 7.5732450571E-01],
	[2.9425000000E+04, 9.9533834478E-01, 1.6773608353E+00, 4.5009955811E-02, 4.1984762483E-02, 7.5735701696E-01],
	[2.9430000000E+04, 9.9560767309E-01, 1.6773168754E+00, 4.5032856891E-02, 4.2005139866E-02, 7.5738951100E-01],
	[2.9435000000E+04, 9.9587717763E-01, 1.6772731927E+00, 4.5055765729E-02, 4.2025523731E-02, 7.5742198786E-01],
	[2.9440000000E+04, 9.9614721253E-01, 1.6772304243E+00, 4.5078682328E-02, 4.2045915109E-02, 7.5745444753E-01],
	[2.9445000000E+04, 9.9641727476E-01, 1.6771876642E+00, 4.5101606687E-02, 4.2066312539E-02, 7.5748689003E-01],
	[2.9450000000E+04, 9.9668736434E-01, 1.6771449125E+00, 4.5124538810E-02, 4.2086716021E-02, 7.5751931536E-01],
	[2.9455000000E+04, 9.9695748126E-01, 1.6771021692E+00, 4.5147478696E-02, 4.2107125554E-02, 7.5755172354E-01],
	[2.9460000000E+04, 9.9722762551E-01, 1.6770594342E+00, 4.5170426347E-02, 4.2127541140E-02, 7.5758411456E-01],
	[2.9465000000E+04, 9.9749779710E-01, 1.6770167075E+00, 4.5193381765E-02, 4.2147962779E-02, 7.5761648845E-01],
	[2.9470000000E+04, 9.9776799603E-01, 1.6769739892E+00, 4.5216344951E-02, 4.2168390470E-02, 7.5764884521E-01],
	[2.9475000000E+04, 9.9803822229E-01, 1.6769312792E+00, 4.5239315906E-02, 4.2188824216E-02, 7.5768118484E-01],
	[2.9480000000E+04, 9.9830847588E-01, 1.6768885776E+00, 4.5262294632E-02, 4.2209264016E-02, 7.5771350736E-01],
	[2.9485000000E+04, 9.9857875680E-01, 1.6768458842E+00, 4.5285281129E-02, 4.2229709870E-02, 7.5774581277E-01],
	[2.9490000000E+04, 9.9884906505E-01, 1.6768031992E+00, 4.5308275399E-02, 4.2250161779E-02, 7.5777810109E-01],
	[2.9495000000E+04, 9.9911940062E-01, 1.6767605225E+00, 4.5331277444E-02, 4.2270619743E-02, 7.5781037232E-01],
	[2.9500000000E+04, 9.9938976352E-01, 1.6767178542E+00, 4.5354287264E-02, 4.2291083763E-02, 7.5784262646E-01],
	[2.9505000000E+04, 9.9966015374E-01, 1.6766751941E+00, 4.5377304862E-02, 4.2311553839E-02, 7.5787486354E-01],
	[2.9510000000E+04, 9.9993057127E-01, 1.6766325424E+00, 4.5400330237E-02, 4.2332029972E-02, 7.5790708355E-01],
	[2.9515000000E+04, 1.0002010161E+00, 1.6765898990E+00, 4.5423363393E-02, 4.2352512162E-02, 7.5793928650E-01],
	[2.9520000000E+04, 1.0004714883E+00, 1.6765472639E+00, 4.5446404329E-02, 4.2373000409E-02, 7.5797147241E-01],
	[2.9525000000E+04, 1.0007419878E+00, 1.6765046371E+00, 4.5469453047E-02, 4.2393494714E-02, 7.5800364128E-01],
	[2.9530000000E+04, 1.0010125146E+00, 1.6764620186E+00, 4.5492509549E-02, 4.2413995077E-02, 7.5803579312E-01],
	[2.9535000000E+04, 1.0012830687E+00, 1.6764194084E+00, 4.5515573836E-02, 4.2434501499E-02, 7.5806792794E-01],
	[2.9540000000E+04, 1.0015536501E+00, 1.6763768065E+00, 4.5538645909E-02, 4.2455013980E-02, 7.5810004575E-01],
	[2.9545000000E+04, 1.0018242588E+00, 1.6763342128E+00, 4.5561725770E-02, 4.2475532520E-02, 7.5813214656E-01],
	[2.9550000000E+04, 1.0020948949E+00, 1.6762916275E+00, 4.5584813419E-02, 4.2496057120E-02, 7.5816423036E-01],
	[2.9555000000E+04, 1.0023655582E+00, 1.6762490505E+00, 4.5607908859E-02, 4.2516587781E-02, 7.5819629718E-01],
	[2.9560000000E+04, 1.0026362488E+00, 1.6762064817E+00, 4.5631012090E-02, 4.2537124502E-02, 7.5822834703E-01],
	[2.9565000000E+04, 1.0029069668E+00, 1.6761639212E+00, 4.5654123113E-02, 4.2557667285E-02, 7.5826037990E-01],
	[2.9570000000E+04, 1.0031777120E+00, 1.6761213690E+00, 4.5677241931E-02, 4.2578216129E-02, 7.5829239581E-01],
	[2.9575000000E+04, 1.0034484845E+00, 1.6760788251E+00, 4.5700368544E-02, 4.2598771034E-02, 7.5832439477E-01],
	[2.9580000000E+04, 1.0037192843E+00, 1.6760362895E+00, 4.5723502954E-02, 4.2619332003E-02, 7.5835637678E-01],
	[2.9585000000E+04, 1.0039901114E+00, 1.6759937621E+00, 4.5746645161E-02, 4.2639899034E-02, 7.5838834186E-01],
	[2.9590000000E+04, 1.0042609658E+00, 1.6759512430E+00, 4.5769795168E-02, 4.2660472128E-02, 7.5842029000E-01],
	[2.9595000000E+04, 1.0045318475E+00, 1.6759087321E+00, 4.5792952976E-02, 4.2681051286E-02, 7.5845222123E-01],
	[2.9600000000E+04, 1.0048027565E+00, 1.6758662295E+00, 4.5816118585E-02, 4.2701636508E-02, 7.5848413555E-01],
	[2.9605000000E+04, 1.0050736927E+00, 1.6758237352E+00, 4.5839291998E-02, 4.2722227794E-02, 7.5851603297E-01],
	[2.9610000000E+04, 1.0053446563E+00, 1.6757812491E+00, 4.5862473215E-02, 4.2742825145E-02, 7.5854791349E-01],
	[2.9615000000E+04, 1.0056156471E+00, 1.6757387712E+00, 4.5885662237E-02, 4.2763428562E-02, 7.5857977713E-01],
	[2.9620000000E+04, 1.0058866652E+00, 1.6756963017E+00, 4.5908859068E-02, 4.2784038044E-02, 7.5861162389E-01],
	[2.9625000000E+04, 1.0061577106E+00, 1.6756538403E+00, 4.5932063706E-02, 4.2804653592E-02, 7.5864345379E-01],
	[2.9630000000E+04, 1.0064287832E+00, 1.6756113872E+00, 4.5955276154E-02, 4.2825275206E-02, 7.5867526682E-01],
	[2.9635000000E+04, 1.0066998832E+00, 1.6755689423E+00, 4.5978496414E-02, 4.2845902888E-02, 7.5870706300E-01],
	[2.9640000000E+04, 1.0069710104E+00, 1.6755265057E+00, 4.6001724485E-02, 4.2866536637E-02, 7.5873884234E-01],
	[2.9645000000E+04, 1.0072421648E+00, 1.6754840773E+00, 4.6024960371E-02, 4.2887176453E-02, 7.5877060485E-01],
	[2.9650000000E+04, 1.0075133466E+00, 1.6754416571E+00, 4.6048204071E-02, 4.2907822338E-02, 7.5880235053E-01],
	[2.9655000000E+04, 1.0077845555E+00, 1.6753992452E+00, 4.6071455588E-02, 4.2928474291E-02, 7.5883407939E-01],
	[2.9660000000E+04, 1.0080557918E+00, 1.6753568415E+00, 4.6094714922E-02, 4.2949132313E-02, 7.5886579145E-01],
	[2.9665000000E+04, 1.0083270553E+00, 1.6753144460E+00, 4.6117982075E-02, 4.2969796404E-02, 7.5889748670E-01],
	[2.9670000000E+04, 1.0085983461E+00, 1.6752720587E+00, 4.6141257049E-02, 4.2990466565E-02, 7.5892916516E-01],
	[2.9675000000E+04, 1.0088696642E+00, 1.6752296797E+00, 4.6164539843E-02, 4.3011142796E-02, 7.5896082684E-01],
	[2.9680000000E+04, 1.0091410095E+00, 1.6751873088E+00, 4.6187830461E-02, 4.3031825098E-02, 7.5899247175E-01],
	[2.9685000000E+04, 1.0094123820E+00, 1.6751449462E+00, 4.6211128903E-02, 4.3052513471E-02, 7.5902409989E-01],
	[2.9690000000E+04, 1.0096837818E+00, 1.6751025917E+00, 4.6234435171E-02, 4.3073207915E-02, 7.5905571127E-01],
	[2.9695000000E+04, 1.0099552089E+00, 1.6750602455E+00, 4.6257749265E-02, 4.3093908431E-02, 7.5908730590E-01],
	[2.9700000000E+04, 1.0102266632E+00, 1.6750179075E+00, 4.6281071187E-02, 4.3114615019E-02, 7.5911888379E-01],
	[2.9705000000E+04, 1.0104981447E+00, 1.6749755776E+00, 4.6304400939E-02, 4.3135327679E-02, 7.5915044495E-01],
	[2.9710000000E+04, 1.0107696535E+00, 1.6749332560E+00, 4.6327738522E-02, 4.3156046413E-02, 7.5918198939E-01],
	[2.9715000000E+04, 1.0110411896E+00, 1.6748909425E+00, 4.6351083936E-02, 4.3176771219E-02, 7.5921351711E-01],
	[2.9720000000E+04, 1.0113127529E+00, 1.6748486373E+00, 4.6374437184E-02, 4.3197502100E-02, 7.5924502812E-01],
	[2.9725000000E+04, 1.0115843434E+00, 1.6748063402E+00, 4.6397798266E-02, 4.3218239055E-02, 7.5927652244E-01],
	[2.9730000000E+04, 1.0118559611E+00, 1.6747640513E+00, 4.6421167185E-02, 4.3238982084E-02, 7.5930800007E-01],
	[2.9735000000E+04, 1.0121276061E+00, 1.6747217706E+00, 4.6444543940E-02, 4.3259731189E-02, 7.5933946101E-01],
	[2.9740000000E+04, 1.0123992784E+00, 1.6746794980E+00, 4.6467928535E-02, 4.3280486369E-02, 7.5937090528E-01],
	[2.9745000000E+04, 1.0126709778E+00, 1.6746372336E+00, 4.6491320969E-02, 4.3301247624E-02, 7.5940233289E-01],
	[2.9750000000E+04, 1.0129427045E+00, 1.6745949774E+00, 4.6514721244E-02, 4.3322014956E-02, 7.5943374385E-01],
	[2.9755000000E+04, 1.0132144584E+00, 1.6745527294E+00, 4.6538129362E-02, 4.3342788364E-02, 7.5946513815E-01],
	[2.9760000000E+04, 1.0134862396E+00, 1.6745104895E+00, 4.6561545323E-02, 4.3363567850E-02, 7.5949651582E-01],
	[2.9765000000E+04, 1.0137580480E+00, 1.6744682578E+00, 4.6584969130E-02, 4.3384353412E-02, 7.5952787686E-01],
	[2.9770000000E+04, 1.0140298836E+00, 1.6744260343E+00, 4.6608400783E-02, 4.3405145053E-02, 7.5955922128E-01],
	[2.9775000000E+04, 1.0143017464E+00, 1.6743838189E+00, 4.6631840284E-02, 4.3425942772E-02, 7.5959054908E-01],
	[2.9780000000E+04, 1.0145736364E+00, 1.6743416117E+00, 4.6655287634E-02, 4.3446746569E-02, 7.5962186028E-01],
	[2.9785000000E+04, 1.0148455537E+00, 1.6742994126E+00, 4.6678742834E-02, 4.3467556445E-02, 7.5965315488E-01],
	[2.9790000000E+04, 1.0151174981E+00, 1.6742572216E+00, 4.6702205886E-02, 4.3488372401E-02, 7.5968443290E-01],
	[2.9795000000E+04, 1.0153894698E+00, 1.6742150388E+00, 4.6725676791E-02, 4.3509194437E-02, 7.5971569433E-01],
	[2.9800000000E+04, 1.0156614687E+00, 1.6741728642E+00, 4.6749155551E-02, 4.3530022552E-02, 7.5974693920E-01],
	[2.9805000000E+04, 1.0159334948E+00, 1.6741306976E+00, 4.6772642166E-02, 4.3550856749E-02, 7.5977816750E-01],
	[2.9810000000E+04, 1.0162055482E+00, 1.6740885393E+00, 4.6796136637E-02, 4.3571697026E-02, 7.5980937925E-01],
	[2.9815000000E+04, 1.0164776287E+00, 1.6740463890E+00, 4.6819638967E-02, 4.3592543384E-02, 7.5984057446E-01],
	[2.9820000000E+04, 1.0167497364E+00, 1.6740042469E+00, 4.6843149157E-02, 4.3613395825E-02, 7.5987175313E-01],
	[2.9825000000E+04, 1.0170218713E+00, 1.6739621129E+00, 4.6866667207E-02, 4.3634254347E-02, 7.5990291527E-01],
	[2.9830000000E+04, 1.0172940335E+00, 1.6739199870E+00, 4.6890193120E-02, 4.3655118953E-02, 7.5993406089E-01],
	[2.9835000000E+04, 1.0175662228E+00, 1.6738778693E+00, 4.6913726896E-02, 4.3675989641E-02, 7.5996519000E-01],
	[2.9840000000E+04, 1.0178384393E+00, 1.6738357596E+00, 4.6937268536E-02, 4.3696866412E-02, 7.5999630261E-01],
	[2.9845000000E+04, 1.0181106830E+00, 1.6737936581E+00, 4.6960818043E-02, 4.3717749267E-02, 7.6002739873E-01],
	[2.9850000000E+04, 1.0183829540E+00, 1.6737515647E+00, 4.6984375417E-02, 4.3738638207E-02, 7.6005847836E-01],
	[2.9855000000E+04, 1.0186552521E+00, 1.6737094794E+00, 4.7007940660E-02, 4.3759533231E-02, 7.6008954151E-01],
	[2.9860000000E+04, 1.0189275774E+00, 1.6736674022E+00, 4.7031513773E-02, 4.3780434340E-02, 7.6012058820E-01],
	[2.9865000000E+04, 1.0191999298E+00, 1.6736253331E+00, 4.7055094757E-02, 4.3801341534E-02, 7.6015161842E-01],
	[2.9870000000E+04, 1.0194723095E+00, 1.6735832721E+00, 4.7078683614E-02, 4.3822254814E-02, 7.6018263219E-01],
	[2.9875000000E+04, 1.0197447164E+00, 1.6735412192E+00, 4.7102280345E-02, 4.3843174180E-02, 7.6021362952E-01],
	[2.9880000000E+04, 1.0200171504E+00, 1.6734991744E+00, 4.7125884951E-02, 4.3864099632E-02, 7.6024461042E-01],
	[2.9885000000E+04, 1.0202896116E+00, 1.6734571377E+00, 4.7149497434E-02, 4.3885031172E-02, 7.6027557489E-01],
	[2.9890000000E+04, 1.0205621000E+00, 1.6734151090E+00, 4.7173117794E-02, 4.3905968799E-02, 7.6030652294E-01],
	[2.9895000000E+04, 1.0208346156E+00, 1.6733730885E+00, 4.7196746034E-02, 4.3926912513E-02, 7.6033745459E-01],
	[2.9900000000E+04, 1.0211071584E+00, 1.6733310760E+00, 4.7220382154E-02, 4.3947862316E-02, 7.6036836983E-01],
	[2.9905000000E+04, 1.0213797283E+00, 1.6732890717E+00, 4.7244026156E-02, 4.3968818207E-02, 7.6039926868E-01],
	[2.9910000000E+04, 1.0216525844E+00, 1.6732476043E+00, 4.7267678041E-02, 4.3989781032E-02, 7.6043015115E-01],
	[2.9915000000E+04, 1.0219257722E+00, 1.6732067665E+00, 4.7291337810E-02, 4.4010750943E-02, 7.6046101725E-01],
	[2.9920000000E+04, 1.0221989874E+00, 1.6731659366E+00, 4.7315005466E-02, 4.4031726947E-02, 7.6049186697E-01],
	[2.9925000000E+04, 1.0224722300E+00, 1.6731251145E+00, 4.7338681008E-02, 4.4052709043E-02, 7.6052270034E-01],
	[2.9930000000E+04, 1.0227455000E+00, 1.6730843002E+00, 4.7362364438E-02, 4.4073697232E-02, 7.6055351736E-01],
	[2.9935000000E+04, 1.0230187973E+00, 1.6730434938E+00, 4.7386055758E-02, 4.4094691514E-02, 7.6058431804E-01],
	[2.9940000000E+04, 1.0232921220E+00, 1.6730026951E+00, 4.7409754970E-02, 4.4115691891E-02, 7.6061510239E-01],
	[2.9945000000E+04, 1.0235654741E+00, 1.6729619043E+00, 4.7433462073E-02, 4.4136698362E-02, 7.6064587042E-01],
	[2.9950000000E+04, 1.0238388535E+00, 1.6729211212E+00, 4.7457177070E-02, 4.4157710927E-02, 7.6067662212E-01],
	[2.9955000000E+04, 1.0241122603E+00, 1.6728803460E+00, 4.7480899962E-02, 4.4178729588E-02, 7.6070735753E-01],
	[2.9960000000E+04, 1.0243856945E+00, 1.6728395785E+00, 4.7504630750E-02, 4.4199754344E-02, 7.6073807663E-01],
	[2.9965000000E+04, 1.0246591560E+00, 1.6727988189E+00, 4.7528369436E-02, 4.4220785196E-02, 7.6076877944E-01],
	[2.9970000000E+04, 1.0249326449E+00, 1.6727580670E+00, 4.7552116020E-02, 4.4241822144E-02, 7.6079946598E-01],
	[2.9975000000E+04, 1.0252061611E+00, 1.6727173230E+00, 4.7575870505E-02, 4.4262865189E-02, 7.6083013624E-01],
	[2.9980000000E+04, 1.0254797047E+00, 1.6726765867E+00, 4.7599632891E-02, 4.4283914331E-02, 7.6086079023E-01],
	[2.9985000000E+04, 1.0257532756E+00, 1.6726358582E+00, 4.7623403180E-02, 4.4304969570E-02, 7.6089142797E-01],
	[2.9990000000E+04, 1.0260268739E+00, 1.6725951375E+00, 4.7647181373E-02, 4.4326030907E-02, 7.6092204946E-01],
	[2.9995000000E+04, 1.0263004995E+00, 1.6725544246E+00, 4.7670967471E-02, 4.4347098342E-02, 7.6095265472E-01],
	[3.0000000000E+04, 1.0265741524E+00, 1.6725137194E+00, 4.7694761476E-02, 4.4368171876E-02, 7.6098324374E-01],
	[3.0005000000E+04, 1.0268478328E+00, 1.6724730220E+00, 4.7718646263E-02, 4.4389323222E-02, 7.6101381654E-01],
	[3.0010000000E+04, 1.0271215404E+00, 1.6724323324E+00, 4.7742539029E-02, 4.4410480720E-02, 7.6104437313E-01],
	[3.0015000000E+04, 1.0273952754E+00, 1.6723916506E+00, 4.7766439774E-02, 4.4431644372E-02, 7.6107491351E-01],
	[3.0020000000E+04, 1.0276690377E+00, 1.6723509765E+00, 4.7790348500E-02, 4.4452814176E-02, 7.6110543770E-01],
	[3.0025000000E+04, 1.0279428274E+00, 1.6723103102E+00, 4.7814265209E-02, 4.4473990133E-02, 7.6113594570E-01],
	[3.0030000000E+04, 1.0282166444E+00, 1.6722696517E+00, 4.7838189901E-02, 4.4495172244E-02, 7.6116643752E-01],
	[3.0035000000E+04, 1.0284904887E+00, 1.6722290009E+00, 4.7862122579E-02, 4.4516360510E-02, 7.6119691317E-01],
	[3.0040000000E+04, 1.0287643604E+00, 1.6721883578E+00, 4.7886063242E-02, 4.4537554929E-02, 7.6122737266E-01],
	[3.0045000000E+04, 1.0290382594E+00, 1.6721477225E+00, 4.7910011894E-02, 4.4558755504E-02, 7.6125781599E-01],
	[3.0050000000E+04, 1.0293121857E+00, 1.6721070950E+00, 4.7933968534E-02, 4.4579962235E-02, 7.6128824318E-01],
	[3.0055000000E+04, 1.0295861394E+00, 1.6720664752E+00, 4.7957933165E-02, 4.4601175121E-02, 7.6131865423E-01],
	[3.0060000000E+04, 1.0298601204E+00, 1.6720258632E+00, 4.7981905787E-02, 4.4622394163E-02, 7.6134904915E-01],
	[3.0065000000E+04, 1.0301341286E+00, 1.6719852589E+00, 4.8005886403E-02, 4.4643619362E-02, 7.6137942795E-01],
	[3.0070000000E+04, 1.0304081643E+00, 1.6719446623E+00, 4.8029875012E-02, 4.4664850718E-02, 7.6140979065E-01],
	[3.0075000000E+04, 1.0306822272E+00, 1.6719040735E+00, 4.8053871618E-02, 4.4686088231E-02, 7.6144013723E-01],
	[3.0080000000E+04, 1.0309563174E+00, 1.6718634924E+00, 4.8077876220E-02, 4.4707331901E-02, 7.6147046773E-01],
	[3.0085000000E+04, 1.0312304350E+00, 1.6718229190E+00, 4.8101888821E-02, 4.4728581730E-02, 7.6150078214E-01],
	[3.0090000000E+04, 1.0315045799E+00, 1.6717823534E+00, 4.8125909422E-02, 4.4749837718E-02, 7.6153108047E-01],
	[3.0095000000E+04, 1.0317787521E+00, 1.6717417954E+00, 4.8149938023E-02, 4.4771099864E-02, 7.6156136273E-01],
	[3.0100000000E+04, 1.0320529516E+00, 1.6717012452E+00, 4.8173974627E-02, 4.4792368170E-02, 7.6159162893E-01],
	[3.0105000000E+04, 1.0323271784E+00, 1.6716607028E+00, 4.8198019235E-02, 4.4813642635E-02, 7.6162187908E-01],
	[3.0110000000E+04, 1.0326014325E+00, 1.6716201680E+00, 4.8222071848E-02, 4.4834923261E-02, 7.6165211319E-01],
	[3.0115000000E+04, 1.0328757139E+00, 1.6715796409E+00, 4.8246132467E-02, 4.4856210047E-02, 7.6168233126E-01],
	[3.0120000000E+04, 1.0331500226E+00, 1.6715391216E+00, 4.8270201093E-02, 4.4877502994E-02, 7.6171253330E-01],
	[3.0125000000E+04, 1.0334243586E+00, 1.6714986100E+00, 4.8294277729E-02, 4.4898802102E-02, 7.6174271933E-01],
	[3.0130000000E+04, 1.0336987219E+00, 1.6714581061E+00, 4.8318362375E-02, 4.4920107372E-02, 7.6177288935E-01],
	[3.0135000000E+04, 1.0339731125E+00, 1.6714176098E+00, 4.8342455033E-02, 4.4941418804E-02, 7.6180304336E-01],
	[3.0140000000E+04, 1.0342475304E+00, 1.6713771213E+00, 4.8366555704E-02, 4.4962736398E-02, 7.6183318138E-01],
	[3.0145000000E+04, 1.0345219756E+00, 1.6713366405E+00, 4.8390664390E-02, 4.4984060155E-02, 7.6186330342E-01],
	[3.0150000000E+04, 1.0347964481E+00, 1.6712961673E+00, 4.8414781091E-02, 4.5005390076E-02, 7.6189340949E-01],
	[3.0155000000E+04, 1.0350709479E+00, 1.6712557019E+00, 4.8438905809E-02, 4.5026726160E-02, 7.6192349958E-01],
	[3.0160000000E+04, 1.0353454749E+00, 1.6712152441E+00, 4.8463038545E-02, 4.5048068408E-02, 7.6195357372E-01],
	[3.0165000000E+04, 1.0356200293E+00, 1.6711747941E+00, 4.8487179301E-02, 4.5069416820E-02, 7.6198363191E-01],
	[3.0170000000E+04, 1.0358946109E+00, 1.6711343517E+00, 4.8511328079E-02, 4.5090771397E-02, 7.6201367415E-01],
	[3.0175000000E+04, 1.0361692198E+00, 1.6710939170E+00, 4.8535484878E-02, 4.5112132139E-02, 7.6204370047E-01],
	[3.0180000000E+04, 1.0364438560E+00, 1.6710534900E+00, 4.8559649702E-02, 4.5133499047E-02, 7.6207371085E-01],
	[3.0185000000E+04, 1.0367185195E+00, 1.6710130706E+00, 4.8583822550E-02, 4.5154872121E-02, 7.6210370532E-01],
	[3.0190000000E+04, 1.0369932102E+00, 1.6709726589E+00, 4.8608003425E-02, 4.5176251361E-02, 7.6213368388E-01],
	[3.0195000000E+04, 1.0372679283E+00, 1.6709322549E+00, 4.8632192327E-02, 4.5197636768E-02, 7.6216364653E-01],
	[3.0200000000E+04, 1.0375426735E+00, 1.6708918586E+00, 4.8656389259E-02, 4.5219028342E-02, 7.6219359326E-01],
	[3.0205000000E+04, 1.0378174461E+00, 1.6708514699E+00, 4.8680594221E-02, 4.5240426083E-02, 7.6222352409E-01],
	[3.0210000000E+04, 1.0380922459E+00, 1.6708110889E+00, 4.8704807215E-02, 4.5261829993E-02, 7.6225343902E-01],
	[3.0215000000E+04, 1.0383670730E+00, 1.6707707155E+00, 4.8729028242E-02, 4.5283240070E-02, 7.6228333807E-01],
	[3.0220000000E+04, 1.0386419274E+00, 1.6707303498E+00, 4.8753257303E-02, 4.5304656317E-02, 7.6231322124E-01],
	[3.0225000000E+04, 1.0389168090E+00, 1.6706899918E+00, 4.8777494400E-02, 4.5326078732E-02, 7.6234308854E-01],
	[3.0230000000E+04, 1.0391917179E+00, 1.6706496413E+00, 4.8801739534E-02, 4.5347507316E-02, 7.6237293997E-01],
	[3.0235000000E+04, 1.0394666541E+00, 1.6706092986E+00, 4.8825992706E-02, 4.5368942071E-02, 7.6240277555E-01],
	[3.0240000000E+04, 1.0397416175E+00, 1.6705689635E+00, 4.8850253919E-02, 4.5390382995E-02, 7.6243259529E-01],
	[3.0245000000E+04, 1.0400166082E+00, 1.6705286360E+00, 4.8874523172E-02, 4.5411830091E-02, 7.6246239918E-01],
	[3.0250000000E+04, 1.0402916261E+00, 1.6704883162E+00, 4.8898800468E-02, 4.5433283357E-02, 7.6249218724E-01],
	[3.0255000000E+04, 1.0405666713E+00, 1.6704480040E+00, 4.8923085807E-02, 4.5454742794E-02, 7.6252195948E-01],
	[3.0260000000E+04, 1.0408417437E+00, 1.6704076994E+00, 4.8947379192E-02, 4.5476208403E-02, 7.6255171591E-01],
	[3.0265000000E+04, 1.0411168434E+00, 1.6703674025E+00, 4.8971680623E-02, 4.5497680185E-02, 7.6258145653E-01],
	[3.0270000000E+04, 1.0413919703E+00, 1.6703271132E+00, 4.8995990101E-02, 4.5519158138E-02, 7.6261118134E-01],
	[3.0275000000E+04, 1.0416671245E+00, 1.6702868316E+00, 4.9020307629E-02, 4.5540642265E-02, 7.6264089037E-01],
	[3.0280000000E+04, 1.0419423059E+00, 1.6702465575E+00, 4.9044633208E-02, 4.5562132565E-02, 7.6267058361E-01],
	[3.0285000000E+04, 1.0422175145E+00, 1.6702062911E+00, 4.9068966838E-02, 4.5583629038E-02, 7.6270026108E-01],
	[3.0290000000E+04, 1.0424927504E+00, 1.6701660323E+00, 4.9093308521E-02, 4.5605131686E-02, 7.6272992278E-01],
	[3.0295000000E+04, 1.0427680135E+00, 1.6701257811E+00, 4.9117658258E-02, 4.5626640507E-02, 7.6275956872E-01],
	[3.0300000000E+04, 1.0430433039E+00, 1.6700855375E+00, 4.9142016052E-02, 4.5648155504E-02, 7.6278919891E-01],
	[3.0305000000E+04, 1.0433186215E+00, 1.6700453015E+00, 4.9166381902E-02, 4.5669676676E-02, 7.6281881336E-01],
	[3.0310000000E+04, 1.0435939664E+00, 1.6700050732E+00, 4.9190755811E-02, 4.5691204023E-02, 7.6284841206E-01],
	[3.0315000000E+04, 1.0438693384E+00, 1.6699648524E+00, 4.9215137780E-02, 4.5712737546E-02, 7.6287799505E-01],
	[3.0320000000E+04, 1.0441447377E+00, 1.6699246392E+00, 4.9239527810E-02, 4.5734277245E-02, 7.6290756231E-01],
	[3.0325000000E+04, 1.0444201643E+00, 1.6698844337E+00, 4.9263925902E-02, 4.5755823121E-02, 7.6293711386E-01],
	[3.0330000000E+04, 1.0446956180E+00, 1.6698442357E+00, 4.9288332058E-02, 4.5777375174E-02, 7.6296664970E-01],
	[3.0335000000E+04, 1.0449710990E+00, 1.6698040454E+00, 4.9312746279E-02, 4.5798933405E-02, 7.6299616985E-01],
	[3.0340000000E+04, 1.0452466072E+00, 1.6697638626E+00, 4.9337168566E-02, 4.5820497813E-02, 7.6302567431E-01],
	[3.0345000000E+04, 1.0455221426E+00, 1.6697236874E+00, 4.9361598922E-02, 4.5842068399E-02, 7.6305516309E-01],
	[3.0350000000E+04, 1.0457977052E+00, 1.6696835198E+00, 4.9386037346E-02, 4.5863645164E-02, 7.6308463620E-01],
	[3.0355000000E+04, 1.0460732951E+00, 1.6696433598E+00, 4.9410483841E-02, 4.5885228108E-02, 7.6311409365E-01],
	[3.0360000000E+04, 1.0463489122E+00, 1.6696032073E+00, 4.9434938408E-02, 4.5906817231E-02, 7.6314353543E-01],
	[3.0365000000E+04, 1.0466245564E+00, 1.6695630625E+00, 4.9459401048E-02, 4.5928412534E-02, 7.6317296157E-01],
	[3.0370000000E+04, 1.0469002279E+00, 1.6695229252E+00, 4.9483871762E-02, 4.5950014017E-02, 7.6320237207E-01],
	[3.0375000000E+04, 1.0471759266E+00, 1.6694827955E+00, 4.9508350552E-02, 4.5971621680E-02, 7.6323176694E-01],
	[3.0380000000E+04, 1.0474516525E+00, 1.6694426733E+00, 4.9532837420E-02, 4.5993235524E-02, 7.6326114618E-01],
	[3.0385000000E+04, 1.0477274057E+00, 1.6694025587E+00, 4.9557332365E-02, 4.6014855549E-02, 7.6329050980E-01],
	[3.0390000000E+04, 1.0480032608E+00, 1.6693626380E+00, 4.9581835391E-02, 4.6036482042E-02, 7.6331985782E-01],
	[3.0395000000E+04, 1.0482795221E+00, 1.6693236678E+00, 4.9606346498E-02, 4.6058116167E-02, 7.6334919024E-01],
	[3.0400000000E+04, 1.0485558107E+00, 1.6692847048E+00, 4.9630865687E-02, 4.6079756476E-02, 7.6337850706E-01],
	[3.0405000000E+04, 1.0488321267E+00, 1.6692457492E+00, 4.9655392960E-02, 4.6101402970E-02, 7.6340780830E-01],
	[3.0410000000E+04, 1.0491084701E+00, 1.6692068009E+00, 4.9679928318E-02, 4.6123055650E-02, 7.6343709396E-01],
	[3.0415000000E+04, 1.0493848408E+00, 1.6691678598E+00, 4.9704471762E-02, 4.6144714516E-02, 7.6346636405E-01],
	[3.0420000000E+04, 1.0496612389E+00, 1.6691289261E+00, 4.9729023295E-02, 4.6166379569E-02, 7.6349561858E-01],
	[3.0425000000E+04, 1.0499376644E+00, 1.6690899998E+00, 4.9753582916E-02, 4.6188050808E-02, 7.6352485756E-01],
	[3.0430000000E+04, 1.0502141171E+00, 1.6690510807E+00, 4.9778150628E-02, 4.6209728234E-02, 7.6355408100E-01],
	[3.0435000000E+04, 1.0504905973E+00, 1.6690121689E+00, 4.9802726432E-02, 4.6231411847E-02, 7.6358328889E-01],
	[3.0440000000E+04, 1.0507671048E+00, 1.6689732644E+00, 4.9827310329E-02, 4.6253101649E-02, 7.6361248126E-01],
	[3.0445000000E+04, 1.0510436396E+00, 1.6689343672E+00, 4.9851902321E-02, 4.6274797638E-02, 7.6364165811E-01],
	[3.0450000000E+04, 1.0513202018E+00, 1.6688954773E+00, 4.9876502408E-02, 4.6296499816E-02, 7.6367081944E-01],
	[3.0455000000E+04, 1.0515967913E+00, 1.6688565947E+00, 4.9901110592E-02, 4.6318208184E-02, 7.6369996527E-01],
	[3.0460000000E+04, 1.0518734082E+00, 1.6688177194E+00, 4.9925726875E-02, 4.6339922740E-02, 7.6372909560E-01],
	[3.0465000000E+04, 1.0521500524E+00, 1.6687788513E+00, 4.9950351258E-02, 4.6361643486E-02, 7.6375821044E-01],
	[3.0470000000E+04, 1.0524267240E+00, 1.6687399906E+00, 4.9974983742E-02, 4.6383370422E-02, 7.6378730980E-01],
	[3.0475000000E+04, 1.0527034229E+00, 1.6687011371E+00, 4.9999624329E-02, 4.6405103549E-02, 7.6381639368E-01],
	[3.0480000000E+04, 1.0529801491E+00, 1.6686622909E+00, 5.0024273019E-02, 4.6426842866E-02, 7.6384546210E-01],
	[3.0485000000E+04, 1.0532569027E+00, 1.6686234520E+00, 5.0048929814E-02, 4.6448588375E-02, 7.6387451507E-01],
	[3.0490000000E+04, 1.0535336836E+00, 1.6685846204E+00, 5.0073594716E-02, 4.6470340075E-02, 7.6390355258E-01],
	[3.0495000000E+04, 1.0538104919E+00, 1.6685457960E+00, 5.0098267726E-02, 4.6492097967E-02, 7.6393257465E-01],
	[3.0500000000E+04, 1.0540873274E+00, 1.6685069789E+00, 5.0122948845E-02, 4.6513862051E-02, 7.6396158129E-01],
	[3.0505000000E+04, 1.0543641903E+00, 1.6684681691E+00, 5.0147638075E-02, 4.6535632328E-02, 7.6399057250E-01],
	[3.0510000000E+04, 1.0546410805E+00, 1.6684293665E+00, 5.0172335416E-02, 4.6557408798E-02, 7.6401954829E-01],
	[3.0515000000E+04, 1.0549179981E+00, 1.6683905712E+00, 5.0197040871E-02, 4.6579191461E-02, 7.6404850867E-01],
	[3.0520000000E+04, 1.0551949429E+00, 1.6683517831E+00, 5.0221754440E-02, 4.6600980319E-02, 7.6407745365E-01],
	[3.0525000000E+04, 1.0554719151E+00, 1.6683130023E+00, 5.0246476125E-02, 4.6622775370E-02, 7.6410638323E-01],
	[3.0530000000E+04, 1.0557489146E+00, 1.6682742288E+00, 5.0271205927E-02, 4.6644576615E-02, 7.6413529743E-01],
	[3.0535000000E+04, 1.0560259414E+00, 1.6682354625E+00, 5.0295943847E-02, 4.6666384056E-02, 7.6416419624E-01],
	[3.0540000000E+04, 1.0563029956E+00, 1.6681967035E+00, 5.0320689888E-02, 4.6688197692E-02, 7.6419307969E-01],
	[3.0545000000E+04, 1.0565800770E+00, 1.6681579517E+00, 5.0345444049E-02, 4.6710017523E-02, 7.6422194777E-01],
	[3.0550000000E+04, 1.0568571858E+00, 1.6681192071E+00, 5.0370206334E-02, 4.6731843550E-02, 7.6425080049E-01],
	[3.0555000000E+04, 1.0571343218E+00, 1.6680804698E+00, 5.0394976742E-02, 4.6753675774E-02, 7.6427963786E-01],
	[3.0560000000E+04, 1.0574114852E+00, 1.6680417397E+00, 5.0419755275E-02, 4.6775514194E-02, 7.6430845990E-01],
	[3.0565000000E+04, 1.0576886759E+00, 1.6680030169E+00, 5.0444541935E-02, 4.6797358812E-02, 7.6433726659E-01],
	[3.0570000000E+04, 1.0579658939E+00, 1.6679643012E+00, 5.0469336722E-02, 4.6819209626E-02, 7.6436605797E-01],
	[3.0575000000E+04, 1.0582431392E+00, 1.6679255929E+00, 5.0494139639E-02, 4.6841066639E-02, 7.6439483403E-01],
	[3.0580000000E+04, 1.0585204118E+00, 1.6678868917E+00, 5.0518950687E-02, 4.6862929849E-02, 7.6442359477E-01],
	[3.0585000000E+04, 1.0587977117E+00, 1.6678481978E+00, 5.0543769866E-02, 4.6884799258E-02, 7.6445234022E-01],
	[3.0590000000E+04, 1.0590750388E+00, 1.6678095111E+00, 5.0568597179E-02, 4.6906674866E-02, 7.6448107037E-01],
	[3.0595000000E+04, 1.0593523933E+00, 1.6677708316E+00, 5.0593432626E-02, 4.6928556674E-02, 7.6450978523E-01],
	[3.0600000000E+04, 1.0596297751E+00, 1.6677321593E+00, 5.0618276208E-02, 4.6950444680E-02, 7.6453848482E-01],
	[3.0605000000E+04, 1.0599071842E+00, 1.6676934943E+00, 5.0643127929E-02, 4.6972338887E-02, 7.6456716913E-01],
	[3.0610000000E+04, 1.0601846205E+00, 1.6676548364E+00, 5.0667987787E-02, 4.6994239294E-02, 7.6459583819E-01],
	[3.0615000000E+04, 1.0604620842E+00, 1.6676161858E+00, 5.0692855786E-02, 4.7016145902E-02, 7.6462449198E-01],
	[3.0620000000E+04, 1.0607395751E+00, 1.6675775424E+00, 5.0717731926E-02, 4.7038058711E-02, 7.6465313053E-01],
	[3.0625000000E+04, 1.0610170933E+00, 1.6675389062E+00, 5.0742616208E-02, 4.7059977721E-02, 7.6468175384E-01],
	[3.0630000000E+04, 1.0612946388E+00, 1.6675002771E+00, 5.0767508634E-02, 4.7081902933E-02, 7.6471036192E-01],
	[3.0635000000E+04, 1.0615722116E+00, 1.6674616553E+00, 5.0792409206E-02, 4.7103834347E-02, 7.6473895477E-01],
	[3.0640000000E+04, 1.0618498117E+00, 1.6674230407E+00, 5.0817317924E-02, 4.7125771963E-02, 7.6476753241E-01],
	[3.0645000000E+04, 1.0621274390E+00, 1.6673844333E+00, 5.0842234790E-02, 4.7147715783E-02, 7.6479609484E-01],
	[3.0650000000E+04, 1.0624050936E+00, 1.6673458330E+00, 5.0867159805E-02, 4.7169665805E-02, 7.6482464207E-01],
	[3.0655000000E+04, 1.0626827755E+00, 1.6673072400E+00, 5.0892092971E-02, 4.7191622031E-02, 7.6485317411E-01],
	[3.0660000000E+04, 1.0629604847E+00, 1.6672686541E+00, 5.0917034288E-02, 4.7213584461E-02, 7.6488168939E-01],
	[3.0665000000E+04, 1.0632382211E+00, 1.6672300755E+00, 5.0941983759E-02, 4.7235553095E-02, 7.6491018703E-01],
	[3.0670000000E+04, 1.0635159848E+00, 1.6671915040E+00, 5.0966941385E-02, 4.7257527934E-02, 7.6493866779E-01],
	[3.0675000000E+04, 1.0637937758E+00, 1.6671529397E+00, 5.0991907166E-02, 4.7279508978E-02, 7.6496713240E-01],
	[3.0680000000E+04, 1.0640715940E+00, 1.6671143826E+00, 5.1016881105E-02, 4.7301496227E-02, 7.6499558163E-01],
	[3.0685000000E+04, 1.0643494395E+00, 1.6670758326E+00, 5.1041863202E-02, 4.7323489682E-02, 7.6502401621E-01],
	[3.0690000000E+04, 1.0646273123E+00, 1.6670372898E+00, 5.1066853459E-02, 4.7345489343E-02, 7.6505243690E-01],
	[3.0695000000E+04, 1.0649052123E+00, 1.6669987542E+00, 5.1091851877E-02, 4.7367495210E-02, 7.6508084443E-01],
	[3.0700000000E+04, 1.0651831396E+00, 1.6669602258E+00, 5.1116858458E-02, 4.7389507284E-02, 7.6510923954E-01],
	[3.0705000000E+04, 1.0654610941E+00, 1.6669217045E+00, 5.1141873203E-02, 4.7411525565E-02, 7.6513762298E-01],
	[3.0710000000E+04, 1.0657390759E+00, 1.6668831904E+00, 5.1166896113E-02, 4.7433550054E-02, 7.6516599548E-01],
	[3.0715000000E+04, 1.0660170850E+00, 1.6668446834E+00, 5.1191927190E-02, 4.7455580751E-02, 7.6519435777E-01],
	[3.0720000000E+04, 1.0662951213E+00, 1.6668061836E+00, 5.1216966434E-02, 4.7477617655E-02, 7.6522271059E-01],
	[3.0725000000E+04, 1.0665731848E+00, 1.6667676909E+00, 5.1242013848E-02, 4.7499660768E-02, 7.6525105467E-01],
	[3.0730000000E+04, 1.0668512756E+00, 1.6667292054E+00, 5.1267069433E-02, 4.7521710091E-02, 7.6527939074E-01],
	[3.0735000000E+04, 1.0671293936E+00, 1.6666907271E+00, 5.1292133189E-02, 4.7543765622E-02, 7.6530771954E-01],
	[3.0740000000E+04, 1.0674075389E+00, 1.6666522559E+00, 5.1317205119E-02, 4.7565827363E-02, 7.6533604179E-01],
	[3.0745000000E+04, 1.0676857114E+00, 1.6666137918E+00, 5.1342285223E-02, 4.7587895314E-02, 7.6536435822E-01],
	[3.0750000000E+04, 1.0679639112E+00, 1.6665753349E+00, 5.1367373503E-02, 4.7609969475E-02, 7.6539266956E-01],
	[3.0755000000E+04, 1.0682421382E+00, 1.6665368852E+00, 5.1392469961E-02, 4.7632049847E-02, 7.6542097653E-01],
	[3.0760000000E+04, 1.0685203924E+00, 1.6664984425E+00, 5.1417574597E-02, 4.7654136430E-02, 7.6544927986E-01],
	[3.0765000000E+04, 1.0687986739E+00, 1.6664600070E+00, 5.1442687413E-02, 4.7676229224E-02, 7.6547758028E-01],
	[3.0770000000E+04, 1.0690769826E+00, 1.6664215787E+00, 5.1467808410E-02, 4.7698328230E-02, 7.6550587852E-01],
	[3.0775000000E+04, 1.0693553186E+00, 1.6663831574E+00, 5.1492937590E-02, 4.7720433448E-02, 7.6553417530E-01],
	[3.0780000000E+04, 1.0696336817E+00, 1.6663447433E+00, 5.1518074954E-02, 4.7742544878E-02, 7.6556247135E-01],
	[3.0785000000E+04, 1.0699120721E+00, 1.6663063363E+00, 5.1543220503E-02, 4.7764662521E-02, 7.6559076738E-01],
	[3.0790000000E+04, 1.0701904898E+00, 1.6662679365E+00, 5.1568374239E-02, 4.7786786378E-02, 7.6561906414E-01],
	[3.0795000000E+04, 1.0704689346E+00, 1.6662295437E+00, 5.1593536163E-02, 4.7808916447E-02, 7.6564736235E-01],
	[3.0800000000E+04, 1.0707474067E+00, 1.6661911581E+00, 5.1618706276E-02, 4.7831052731E-02, 7.6567566273E-01],
	[3.0805000000E+04, 1.0710259060E+00, 1.6661527796E+00, 5.1643884580E-02, 4.7853195228E-02, 7.6570396602E-01],
	[3.0810000000E+04, 1.0713044325E+00, 1.6661144082E+00, 5.1669071075E-02, 4.7875343941E-02, 7.6573227290E-01],
	[3.0815000000E+04, 1.0715829862E+00, 1.6660760439E+00, 5.1694265764E-02, 4.7897498868E-02, 7.6576058128E-01],
	[3.0820000000E+04, 1.0718615672E+00, 1.6660376867E+00, 5.1719468648E-02, 4.7919660010E-02, 7.6578888967E-01],
	[3.0825000000E+04, 1.0721401754E+00, 1.6659993366E+00, 5.1744679727E-02, 4.7941827368E-02, 7.6581719806E-01],
	[3.0830000000E+04, 1.0724188107E+00, 1.6659609937E+00, 5.1769899004E-02, 4.7964000941E-02, 7.6584550645E-01],
	[3.0835000000E+04, 1.0726974733E+00, 1.6659226578E+00, 5.1795126479E-02, 4.7986180731E-02, 7.6587381484E-01],
	[3.0840000000E+04, 1.0729761631E+00, 1.6658843290E+00, 5.1820362155E-02, 4.8008366738E-02, 7.6590212323E-01],
	[3.0845000000E+04, 1.0732548801E+00, 1.6658460074E+00, 5.1845606031E-02, 4.8030558961E-02, 7.6593043161E-01],
	[3.0850000000E+04, 1.0735336243E+00, 1.6658076928E+00, 5.1870858111E-02, 4.8052757402E-02, 7.6595874000E-01],
	[3.0855000000E+04, 1.0738123958E+00, 1.6657693853E+00, 5.1896118394E-02, 4.8074962060E-02, 7.6598704837E-01],
	[3.0860000000E+04, 1.0740911944E+00, 1.6657310849E+00, 5.1921386883E-02, 4.8097172937E-02, 7.6601535674E-01],
	[3.0865000000E+04, 1.0743700202E+00, 1.6656927915E+00, 5.1946663578E-02, 4.8119390031E-02, 7.6604366511E-01],
	[3.0870000000E+04, 1.0746488732E+00, 1.6656545053E+00, 5.1971948481E-02, 4.8141613345E-02, 7.6607197346E-01],
	[3.0875000000E+04, 1.0749277534E+00, 1.6656162261E+00, 5.1997241594E-02, 4.8163842877E-02, 7.6610028180E-01],
	[3.0880000000E+04, 1.0752067675E+00, 1.6655783091E+00, 5.2022542917E-02, 4.8186079140E-02, 7.6612859013E-01],
	[3.0885000000E+04, 1.0754860354E+00, 1.6655411531E+00, 5.2047852452E-02, 4.8208322711E-02, 7.6615689845E-01],
	[3.0890000000E+04, 1.0757653307E+00, 1.6655040039E+00, 5.2073170201E-02, 4.8230572504E-02, 7.6618520676E-01],
	[3.0895000000E+04, 1.0760446532E+00, 1.6654668616E+00, 5.2098496164E-02, 4.8252828520E-02, 7.6621351505E-01],
	[3.0900000000E+04, 1.0763240031E+00, 1.6654297261E+00, 5.2123830343E-02, 4.8275090758E-02, 7.6624182332E-01],
	[3.0905000000E+04, 1.0766033802E+00, 1.6653925975E+00, 5.2149172740E-02, 4.8297359221E-02, 7.6627013157E-01],
	[3.0910000000E+04, 1.0768827847E+00, 1.6653554756E+00, 5.2174523355E-02, 4.8319633907E-02, 7.6629843980E-01],
	[3.0915000000E+04, 1.0771622164E+00, 1.6653183606E+00, 5.2199882190E-02, 4.8341914817E-02, 7.6632674802E-01],
	[3.0920000000E+04, 1.0774416755E+00, 1.6652812525E+00, 5.2225249247E-02, 4.8364201952E-02, 7.6635505621E-01],
	[3.0925000000E+04, 1.0777211619E+00, 1.6652441511E+00, 5.2250624526E-02, 4.8386495312E-02, 7.6638336438E-01],
	[3.0930000000E+04, 1.0780006755E+00, 1.6652070566E+00, 5.2276008029E-02, 4.8408794896E-02, 7.6641167252E-01],
	[3.0935000000E+04, 1.0782802165E+00, 1.6651699689E+00, 5.2301399758E-02, 4.8431100707E-02, 7.6643998064E-01],
	[3.0940000000E+04, 1.0785597847E+00, 1.6651328881E+00, 5.2326799713E-02, 4.8453412743E-02, 7.6646828873E-01],
	[3.0945000000E+04, 1.0788393803E+00, 1.6650958140E+00, 5.2352207896E-02, 4.8475731005E-02, 7.6649659679E-01],
	[3.0950000000E+04, 1.0791190031E+00, 1.6650587468E+00, 5.2377624309E-02, 4.8498055494E-02, 7.6652490482E-01],
	[3.0955000000E+04, 1.0793986532E+00, 1.6650216864E+00, 5.2403048952E-02, 4.8520386210E-02, 7.6655321282E-01],
	[3.0960000000E+04, 1.0796783306E+00, 1.6649846327E+00, 5.2428481828E-02, 4.8542723153E-02, 7.6658152079E-01],
	[3.0965000000E+04, 1.0799580353E+00, 1.6649475859E+00, 5.2453922936E-02, 4.8565066324E-02, 7.6660982872E-01],
	[3.0970000000E+04, 1.0802377673E+00, 1.6649105459E+00, 5.2479372280E-02, 4.8587415722E-02, 7.6663813662E-01],
	[3.0975000000E+04, 1.0805175265E+00, 1.6648735127E+00, 5.2504829859E-02, 4.8609771349E-02, 7.6666644448E-01],
	[3.0980000000E+04, 1.0807973130E+00, 1.6648364863E+00, 5.2530295676E-02, 4.8632133204E-02, 7.6669475231E-01],
	[3.0985000000E+04, 1.0810771268E+00, 1.6647994667E+00, 5.2555769731E-02, 4.8654501288E-02, 7.6672306009E-01],
	[3.0990000000E+04, 1.0813569679E+00, 1.6647624539E+00, 5.2581252027E-02, 4.8676875602E-02, 7.6675136784E-01],
	[3.0995000000E+04, 1.0816368363E+00, 1.6647254479E+00, 5.2606742563E-02, 4.8699256145E-02, 7.6677967554E-01],
	[3.1000000000E+04, 1.0819167319E+00, 1.6646884487E+00, 5.2632241343E-02, 4.8721642918E-02, 7.6680798320E-01],
	[3.1005000000E+04, 1.0821966548E+00, 1.6646514563E+00, 5.2657748366E-02, 4.8744035921E-02, 7.6683629082E-01],
	[3.1010000000E+04, 1.0824766050E+00, 1.6646144707E+00, 5.2683263635E-02, 4.8766435155E-02, 7.6686459839E-01],
	[3.1015000000E+04, 1.0827565824E+00, 1.6645774918E+00, 5.2708787151E-02, 4.8788840620E-02, 7.6689290592E-01],
	[3.1020000000E+04, 1.0830365871E+00, 1.6645405197E+00, 5.2734318915E-02, 4.8811252316E-02, 7.6692121340E-01],
	[3.1025000000E+04, 1.0833166190E+00, 1.6645035544E+00, 5.2759858928E-02, 4.8833670244E-02, 7.6694952083E-01],
	[3.1030000000E+04, 1.0835966783E+00, 1.6644665959E+00, 5.2785407191E-02, 4.8856094404E-02, 7.6697782820E-01],
	[3.1035000000E+04, 1.0838767648E+00, 1.6644296442E+00, 5.2810963707E-02, 4.8878524796E-02, 7.6700613553E-01],
	[3.1040000000E+04, 1.0841568785E+00, 1.6643926992E+00, 5.2836528476E-02, 4.8900961421E-02, 7.6703444280E-01],
	[3.1045000000E+04, 1.0844370195E+00, 1.6643557610E+00, 5.2862101500E-02, 4.8923404278E-02, 7.6706275002E-01],
	[3.1050000000E+04, 1.0847171877E+00, 1.6643188296E+00, 5.2887682780E-02, 4.8945853369E-02, 7.6709105718E-01],
	[3.1055000000E+04, 1.0849973832E+00, 1.6642819049E+00, 5.2913272318E-02, 4.8968308694E-02, 7.6711936429E-01],
	[3.1060000000E+04, 1.0852776060E+00, 1.6642449870E+00, 5.2938870114E-02, 4.8990770252E-02, 7.6714767134E-01],
	[3.1065000000E+04, 1.0855578560E+00, 1.6642080759E+00, 5.2964476170E-02, 4.9013238045E-02, 7.6717597832E-01],
	[3.1070000000E+04, 1.0858381333E+00, 1.6641711715E+00, 5.2990090487E-02, 4.9035712073E-02, 7.6720428525E-01],
	[3.1075000000E+04, 1.0861184378E+00, 1.6641342739E+00, 5.3015713067E-02, 4.9058192335E-02, 7.6723259212E-01],
	[3.1080000000E+04, 1.0863987695E+00, 1.6640973830E+00, 5.3041343912E-02, 4.9080678833E-02, 7.6726089892E-01],
	[3.1085000000E+04, 1.0866791285E+00, 1.6640604989E+00, 5.3066983021E-02, 4.9103171566E-02, 7.6728920565E-01],
	[3.1090000000E+04, 1.0869595147E+00, 1.6640236216E+00, 5.3092630398E-02, 4.9125670536E-02, 7.6731751233E-01],
	[3.1095000000E+04, 1.0872399282E+00, 1.6639867509E+00, 5.3118286042E-02, 4.9148175741E-02, 7.6734581893E-01],
	[3.1100000000E+04, 1.0875203689E+00, 1.6639498871E+00, 5.3143949956E-02, 4.9170687184E-02, 7.6737412546E-01],
	[3.1105000000E+04, 1.0878008368E+00, 1.6639130299E+00, 5.3169622141E-02, 4.9193204863E-02, 7.6740243193E-01],
	[3.1110000000E+04, 1.0880813320E+00, 1.6638761795E+00, 5.3195302598E-02, 4.9215728779E-02, 7.6743073832E-01],
	[3.1115000000E+04, 1.0883618544E+00, 1.6638393359E+00, 5.3220991328E-02, 4.9238258934E-02, 7.6745904465E-01],
	[3.1120000000E+04, 1.0886424040E+00, 1.6638024990E+00, 5.3246688333E-02, 4.9260795326E-02, 7.6748735089E-01],
	[3.1125000000E+04, 1.0889229809E+00, 1.6637656688E+00, 5.3272393614E-02, 4.9283337956E-02, 7.6751565707E-01],
	[3.1130000000E+04, 1.0892035850E+00, 1.6637288453E+00, 5.3298107172E-02, 4.9305886825E-02, 7.6754396317E-01],
	[3.1135000000E+04, 1.0894842163E+00, 1.6636920286E+00, 5.3323829009E-02, 4.9328441933E-02, 7.6757226919E-01],
	[3.1140000000E+04, 1.0897648749E+00, 1.6636552186E+00, 5.3349559126E-02, 4.9351003280E-02, 7.6760057513E-01],
	[3.1145000000E+04, 1.0900455606E+00, 1.6636184154E+00, 5.3375297525E-02, 4.9373570867E-02, 7.6762888099E-01],
	[3.1150000000E+04, 1.0903262736E+00, 1.6635816188E+00, 5.3401044206E-02, 4.9396144694E-02, 7.6765718677E-01],
	[3.1155000000E+04, 1.0906070138E+00, 1.6635448290E+00, 5.3426799172E-02, 4.9418724761E-02, 7.6768549246E-01],
	[3.1160000000E+04, 1.0908877812E+00, 1.6635080459E+00, 5.3452562423E-02, 4.9441311069E-02, 7.6771379808E-01],
	[3.1165000000E+04, 1.0911685758E+00, 1.6634712695E+00, 5.3478333960E-02, 4.9463903617E-02, 7.6774210360E-01],
	[3.1170000000E+04, 1.0914493977E+00, 1.6634344998E+00, 5.3504113786E-02, 4.9486502407E-02, 7.6777040905E-01],
	[3.1175000000E+04, 1.0917302467E+00, 1.6633977368E+00, 5.3529901901E-02, 4.9509107438E-02, 7.6779871440E-01],
	[3.1180000000E+04, 1.0920111230E+00, 1.6633609805E+00, 5.3555698307E-02, 4.9531718711E-02, 7.6782701966E-01],
	[3.1185000000E+04, 1.0922920265E+00, 1.6633242310E+00, 5.3581503006E-02, 4.9554336227E-02, 7.6785532484E-01],
	[3.1190000000E+04, 1.0925729572E+00, 1.6632874881E+00, 5.3607315997E-02, 4.9576959985E-02, 7.6788362992E-01],
	[3.1195000000E+04, 1.0928539150E+00, 1.6632507520E+00, 5.3633137283E-02, 4.9599589986E-02, 7.6791193491E-01],
	[3.1200000000E+04, 1.0931349001E+00, 1.6632140225E+00, 5.3658966866E-02, 4.9622226230E-02, 7.6794023981E-01],
	[3.1205000000E+04, 1.0934159124E+00, 1.6631772997E+00, 5.3684804746E-02, 4.9644868717E-02, 7.6796854461E-01],
	[3.1210000000E+04, 1.0936969519E+00, 1.6631405837E+00, 5.3710650924E-02, 4.9667517448E-02, 7.6799684931E-01],
	[3.1215000000E+04, 1.0939780186E+00, 1.6631038743E+00, 5.3736505403E-02, 4.9690172424E-02, 7.6802515392E-01],
	[3.1220000000E+04, 1.0942591125E+00, 1.6630671716E+00, 5.3762368183E-02, 4.9712833644E-02, 7.6805345842E-01],
	[3.1225000000E+04, 1.0945402336E+00, 1.6630304756E+00, 5.3788239266E-02, 4.9735501109E-02, 7.6808176283E-01],
	[3.1230000000E+04, 1.0948213818E+00, 1.6629937863E+00, 5.3814118653E-02, 4.9758174819E-02, 7.6811006713E-01],
	[3.1235000000E+04, 1.0951025573E+00, 1.6629571037E+00, 5.3840006346E-02, 4.9780854774E-02, 7.6813837133E-01],
	[3.1240000000E+04, 1.0953837599E+00, 1.6629204277E+00, 5.3865902345E-02, 4.9803540975E-02, 7.6816667543E-01],
	[3.1245000000E+04, 1.0956649898E+00, 1.6628837584E+00, 5.3891806653E-02, 4.9826233423E-02, 7.6819497942E-01],
	[3.1250000000E+04, 1.0959462468E+00, 1.6628470958E+00, 5.3917719270E-02, 4.9848932116E-02, 7.6822328331E-01],
	[3.1255000000E+04, 1.0962275310E+00, 1.6628104399E+00, 5.3943640198E-02, 4.9871637057E-02, 7.6825158708E-01],
	[3.1260000000E+04, 1.0965088424E+00, 1.6627737907E+00, 5.3969569438E-02, 4.9894348244E-02, 7.6827989075E-01],
	[3.1265000000E+04, 1.0967901809E+00, 1.6627371481E+00, 5.3995506991E-02, 4.9917065679E-02, 7.6830819431E-01],
	[3.1270000000E+04, 1.0970715467E+00, 1.6627005122E+00, 5.4021452859E-02, 4.9939789362E-02, 7.6833649775E-01],
	[3.1275000000E+04, 1.0973529396E+00, 1.6626638829E+00, 5.4047407043E-02, 4.9962519292E-02, 7.6836480108E-01],
	[3.1280000000E+04, 1.0976343597E+00, 1.6626272603E+00, 5.4073369545E-02, 4.9985255471E-02, 7.6839310430E-01],
	[3.1285000000E+04, 1.0979158070E+00, 1.6625906444E+00, 5.4099340366E-02, 5.0007997899E-02, 7.6842140740E-01],
	[3.1290000000E+04, 1.0981972814E+00, 1.6625540351E+00, 5.4125319507E-02, 5.0030746576E-02, 7.6844971038E-01],
	[3.1295000000E+04, 1.0984787830E+00, 1.6625174325E+00, 5.4151306969E-02, 5.0053501502E-02, 7.6847801325E-01],
	[3.1300000000E+04, 1.0987603118E+00, 1.6624808366E+00, 5.4177302754E-02, 5.0076262677E-02, 7.6850631600E-01],
	[3.1305000000E+04, 1.0990418677E+00, 1.6624442472E+00, 5.4203306863E-02, 5.0099030103E-02, 7.6853461862E-01],
	[3.1310000000E+04, 1.0993234509E+00, 1.6624076646E+00, 5.4229319298E-02, 5.0121803778E-02, 7.6856292112E-01],
	[3.1315000000E+04, 1.0996050611E+00, 1.6623710886E+00, 5.4255340059E-02, 5.0144583705E-02, 7.6859122350E-01],
	[3.1320000000E+04, 1.0998866986E+00, 1.6623345192E+00, 5.4281369149E-02, 5.0167369882E-02, 7.6861952576E-01],
	[3.1325000000E+04, 1.1001683632E+00, 1.6622979565E+00, 5.4307406568E-02, 5.0190162310E-02, 7.6864782789E-01],
	[3.1330000000E+04, 1.1004500549E+00, 1.6622614004E+00, 5.4333452318E-02, 5.0212960990E-02, 7.6867612989E-01],
	[3.1335000000E+04, 1.1007317738E+00, 1.6622248509E+00, 5.4359506400E-02, 5.0235765922E-02, 7.6870443176E-01],
	[3.1340000000E+04, 1.1010135199E+00, 1.6621883081E+00, 5.4385568816E-02, 5.0258577106E-02, 7.6873273351E-01],
	[3.1345000000E+04, 1.1012952931E+00, 1.6621517719E+00, 5.4411639567E-02, 5.0281394542E-02, 7.6876103512E-01],
	[3.1350000000E+04, 1.1015770935E+00, 1.6621152424E+00, 5.4437718653E-02, 5.0304218231E-02, 7.6878933660E-01],
	[3.1355000000E+04, 1.1018589210E+00, 1.6620787194E+00, 5.4463806077E-02, 5.0327048173E-02, 7.6881763795E-01],
	[3.1360000000E+04, 1.1021407757E+00, 1.6620422031E+00, 5.4489901840E-02, 5.0349884369E-02, 7.6884593916E-01],
	[3.1365000000E+04, 1.1024226575E+00, 1.6620056935E+00, 5.4516005944E-02, 5.0372726818E-02, 7.6887424024E-01],
	[3.1370000000E+04, 1.1027045664E+00, 1.6619691904E+00, 5.4542118388E-02, 5.0395575522E-02, 7.6890254118E-01],
	[3.1375000000E+04, 1.1029865025E+00, 1.6619326940E+00, 5.4568239176E-02, 5.0418430480E-02, 7.6893084198E-01],
	[3.1380000000E+04, 1.1032686552E+00, 1.6618971847E+00, 5.4594368308E-02, 5.0441292991E-02, 7.6895914264E-01],
	[3.1385000000E+04, 1.1035508561E+00, 1.6618617906E+00, 5.4620505785E-02, 5.0464161904E-02, 7.6898744316E-01],
	[3.1390000000E+04, 1.1038330842E+00, 1.6618264029E+00, 5.4646651609E-02, 5.0487037075E-02, 7.6901574354E-01],
	[3.1395000000E+04, 1.1041153395E+00, 1.6617910216E+00, 5.4672805781E-02, 5.0509918503E-02, 7.6904404377E-01],
	[3.1400000000E+04, 1.1043976221E+00, 1.6617556467E+00, 5.4698968303E-02, 5.0532806189E-02, 7.6907234386E-01],
	[3.1405000000E+04, 1.1046799318E+00, 1.6617202782E+00, 5.4725139176E-02, 5.0555700134E-02, 7.6910064380E-01],
	[3.1410000000E+04, 1.1049622687E+00, 1.6616849161E+00, 5.4751318401E-02, 5.0578600338E-02, 7.6912894360E-01],
	[3.1415000000E+04, 1.1052446329E+00, 1.6616495604E+00, 5.4777505979E-02, 5.0601506800E-02, 7.6915724325E-01],
	[3.1420000000E+04, 1.1055270242E+00, 1.6616142110E+00, 5.4803701912E-02, 5.0624419522E-02, 7.6918554274E-01],
	[3.1425000000E+04, 1.1058094428E+00, 1.6615788680E+00, 5.4829906202E-02, 5.0647338504E-02, 7.6921384209E-01],
	[3.1430000000E+04, 1.1060918885E+00, 1.6615435314E+00, 5.4856118849E-02, 5.0670263746E-02, 7.6924214128E-01],
	[3.1435000000E+04, 1.1063743615E+00, 1.6615082011E+00, 5.4882339855E-02, 5.0693195248E-02, 7.6927044032E-01],
	[3.1440000000E+04, 1.1066568616E+00, 1.6614728773E+00, 5.4908569221E-02, 5.0716133010E-02, 7.6929873921E-01],
	[3.1445000000E+04, 1.1069393889E+00, 1.6614375598E+00, 5.4934806949E-02, 5.0739077034E-02, 7.6932703794E-01],
	[3.1450000000E+04, 1.1072219434E+00, 1.6614022486E+00, 5.4961053039E-02, 5.0762027319E-02, 7.6935533651E-01],
	[3.1455000000E+04, 1.1075045252E+00, 1.6613669438E+00, 5.4987307494E-02, 5.0784983865E-02, 7.6938363493E-01],
	[3.1460000000E+04, 1.1077871340E+00, 1.6613316454E+00, 5.5013570314E-02, 5.0807946673E-02, 7.6941193318E-01],
	[3.1465000000E+04, 1.1080697701E+00, 1.6612963534E+00, 5.5039841501E-02, 5.0830915744E-02, 7.6944023127E-01],
	[3.1470000000E+04, 1.1083524334E+00, 1.6612610677E+00, 5.5066121057E-02, 5.0853891077E-02, 7.6946852920E-01],
	[3.1475000000E+04, 1.1086351238E+00, 1.6612257883E+00, 5.5092408982E-02, 5.0876872672E-02, 7.6949682697E-01],
	[3.1480000000E+04, 1.1089178415E+00, 1.6611905153E+00, 5.5118705277E-02, 5.0899860531E-02, 7.6952512457E-01],
	[3.1485000000E+04, 1.1092005863E+00, 1.6611552487E+00, 5.5145009945E-02, 5.0922854653E-02, 7.6955342201E-01],
	[3.1490000000E+04, 1.1094833583E+00, 1.6611199884E+00, 5.5171322987E-02, 5.0945855039E-02, 7.6958171927E-01],
	[3.1495000000E+04, 1.1097661574E+00, 1.6610847345E+00, 5.5197644404E-02, 5.0968861689E-02, 7.6961001637E-01],
	[3.1500000000E+04, 1.1100489838E+00, 1.6610494869E+00, 5.5223974196E-02, 5.0991874603E-02, 7.6963831330E-01],
	[3.1505000000E+04, 1.1103318373E+00, 1.6610142456E+00, 5.5250312367E-02, 5.1014893782E-02, 7.6966661006E-01],
	[3.1510000000E+04, 1.1106147179E+00, 1.6609790107E+00, 5.5276658916E-02, 5.1037919226E-02, 7.6969490665E-01],
	[3.1515000000E+04, 1.1108976258E+00, 1.6609437821E+00, 5.5303013845E-02, 5.1060950935E-02, 7.6972320306E-01],
	[3.1520000000E+04, 1.1111805608E+00, 1.6609085599E+00, 5.5329377156E-02, 5.1083988910E-02, 7.6975149930E-01],
	[3.1525000000E+04, 1.1114635230E+00, 1.6608733440E+00, 5.5355748850E-02, 5.1107033150E-02, 7.6977979536E-01],
	[3.1530000000E+04, 1.1117465123E+00, 1.6608381344E+00, 5.5382128928E-02, 5.1130083657E-02, 7.6980809124E-01],
	[3.1535000000E+04, 1.1120295288E+00, 1.6608029311E+00, 5.5408517392E-02, 5.1153140430E-02, 7.6983638694E-01],
	[3.1540000000E+04, 1.1123125725E+00, 1.6607677342E+00, 5.5434914243E-02, 5.1176203470E-02, 7.6986468247E-01],
	[3.1545000000E+04, 1.1125956433E+00, 1.6607325436E+00, 5.5461319482E-02, 5.1199272777E-02, 7.6989297781E-01],
	[3.1550000000E+04, 1.1128787413E+00, 1.6606973593E+00, 5.5487733110E-02, 5.1222348351E-02, 7.6992127297E-01],
	[3.1555000000E+04, 1.1131618664E+00, 1.6606621814E+00, 5.5514155130E-02, 5.1245430193E-02, 7.6994956795E-01],
	[3.1560000000E+04, 1.1134450187E+00, 1.6606270098E+00, 5.5540585541E-02, 5.1268518303E-02, 7.6997786274E-01],
	[3.1565000000E+04, 1.1137281982E+00, 1.6605918444E+00, 5.5567024347E-02, 5.1291612681E-02, 7.7000615735E-01],
	[3.1570000000E+04, 1.1140114048E+00, 1.6605566854E+00, 5.5593471547E-02, 5.1314713328E-02, 7.7003445176E-01],
	[3.1575000000E+04, 1.1142946385E+00, 1.6605215327E+00, 5.5619927143E-02, 5.1337820244E-02, 7.7006274599E-01],
	[3.1580000000E+04, 1.1145778994E+00, 1.6604863864E+00, 5.5646391137E-02, 5.1360933429E-02, 7.7009104003E-01],
	[3.1585000000E+04, 1.1148611874E+00, 1.6604512463E+00, 5.5672863530E-02, 5.1384052883E-02, 7.7011933388E-01],
	[3.1590000000E+04, 1.1151445026E+00, 1.6604161125E+00, 5.5699344323E-02, 5.1407178607E-02, 7.7014762754E-01],
	[3.1595000000E+04, 1.1154278449E+00, 1.6603809851E+00, 5.5725833518E-02, 5.1430310602E-02, 7.7017592100E-01],
	[3.1600000000E+04, 1.1157112144E+00, 1.6603458639E+00, 5.5752331116E-02, 5.1453448866E-02, 7.7020421426E-01],
	[3.1605000000E+04, 1.1159946110E+00, 1.6603107490E+00, 5.5778837118E-02, 5.1476593402E-02, 7.7023250733E-01],
	[3.1610000000E+04, 1.1162780347E+00, 1.6602756405E+00, 5.5805351526E-02, 5.1499744208E-02, 7.7026080020E-01],
	[3.1615000000E+04, 1.1165614856E+00, 1.6602405382E+00, 5.5831874340E-02, 5.1522901286E-02, 7.7028909288E-01],
	[3.1620000000E+04, 1.1168449636E+00, 1.6602054422E+00, 5.5858405563E-02, 5.1546064635E-02, 7.7031738535E-01],
	[3.1625000000E+04, 1.1171284687E+00, 1.6601703525E+00, 5.5884945196E-02, 5.1569234256E-02, 7.7034567762E-01],
	[3.1630000000E+04, 1.1174120009E+00, 1.6601352691E+00, 5.5911493239E-02, 5.1592410150E-02, 7.7037396969E-01],
	[3.1635000000E+04, 1.1176955603E+00, 1.6601001920E+00, 5.5938049695E-02, 5.1615592316E-02, 7.7040226155E-01],
	[3.1640000000E+04, 1.1179791469E+00, 1.6600651212E+00, 5.5964614564E-02, 5.1638780754E-02, 7.7043055321E-01],
	[3.1645000000E+04, 1.1182627605E+00, 1.6600300566E+00, 5.5991187849E-02, 5.1661975466E-02, 7.7045884467E-01],
	[3.1650000000E+04, 1.1185464013E+00, 1.6599949984E+00, 5.6017769549E-02, 5.1685176451E-02, 7.7048713591E-01],
	[3.1655000000E+04, 1.1188300691E+00, 1.6599599464E+00, 5.6044359668E-02, 5.1708383710E-02, 7.7051542695E-01],
	[3.1660000000E+04, 1.1191137641E+00, 1.6599249007E+00, 5.6070958205E-02, 5.1731597243E-02, 7.7054371778E-01],
	[3.1665000000E+04, 1.1193974863E+00, 1.6598898612E+00, 5.6097565162E-02, 5.1754817050E-02, 7.7057200839E-01],
	[3.1670000000E+04, 1.1196812355E+00, 1.6598548281E+00, 5.6124180542E-02, 5.1778043131E-02, 7.7060029880E-01],
	[3.1675000000E+04, 1.1199650119E+00, 1.6598198012E+00, 5.6150804344E-02, 5.1801275488E-02, 7.7062858898E-01],
	[3.1680000000E+04, 1.1202488153E+00, 1.6597847806E+00, 5.6177436570E-02, 5.1824514119E-02, 7.7065687896E-01],
	[3.1685000000E+04, 1.1205326459E+00, 1.6597497662E+00, 5.6204077222E-02, 5.1847759026E-02, 7.7068516872E-01],
	[3.1690000000E+04, 1.1208165036E+00, 1.6597147581E+00, 5.6230726301E-02, 5.1871010209E-02, 7.7071345826E-01],
	[3.1695000000E+04, 1.1211003884E+00, 1.6596797563E+00, 5.6257383808E-02, 5.1894267668E-02, 7.7074174758E-01],
	[3.1700000000E+04, 1.1213843003E+00, 1.6596447607E+00, 5.6284049745E-02, 5.1917531403E-02, 7.7077003668E-01],
	[3.1705000000E+04, 1.1216682393E+00, 1.6596097714E+00, 5.6310724113E-02, 5.1940801415E-02, 7.7079832556E-01],
	[3.1710000000E+04, 1.1219522054E+00, 1.6595747883E+00, 5.6337406914E-02, 5.1964077704E-02, 7.7082661421E-01],
	[3.1715000000E+04, 1.1222361986E+00, 1.6595398115E+00, 5.6364098148E-02, 5.1987360270E-02, 7.7085490265E-01],
	[3.1720000000E+04, 1.1225202189E+00, 1.6595048409E+00, 5.6390797817E-02, 5.2010649113E-02, 7.7088319085E-01],
	[3.1725000000E+04, 1.1228042663E+00, 1.6594698766E+00, 5.6417505922E-02, 5.2033944234E-02, 7.7091147883E-01],
	[3.1730000000E+04, 1.1230883408E+00, 1.6594349186E+00, 5.6444222465E-02, 5.2057245634E-02, 7.7093976659E-01],
	[3.1735000000E+04, 1.1233724424E+00, 1.6593999667E+00, 5.6470947447E-02, 5.2080553312E-02, 7.7096805411E-01],
	[3.1740000000E+04, 1.1236565711E+00, 1.6593650212E+00, 5.6497680869E-02, 5.2103867268E-02, 7.7099634141E-01],
	[3.1745000000E+04, 1.1239407269E+00, 1.6593300818E+00, 5.6524422733E-02, 5.2127187503E-02, 7.7102462847E-01],
	[3.1750000000E+04, 1.1242249097E+00, 1.6592951487E+00, 5.6551173040E-02, 5.2150514018E-02, 7.7105291530E-01],
	[3.1755000000E+04, 1.1245091197E+00, 1.6592602219E+00, 5.6577931791E-02, 5.2173846812E-02, 7.7108120190E-01],
	[3.1760000000E+04, 1.1247933567E+00, 1.6592253012E+00, 5.6604698988E-02, 5.2197185886E-02, 7.7110948826E-01],
	[3.1765000000E+04, 1.1250776209E+00, 1.6591903868E+00, 5.6631474632E-02, 5.2220531240E-02, 7.7113777439E-01],
	[3.1770000000E+04, 1.1253619121E+00, 1.6591554787E+00, 5.6658258724E-02, 5.2243882874E-02, 7.7116606027E-01],
	[3.1775000000E+04, 1.1256462304E+00, 1.6591205767E+00, 5.6685051266E-02, 5.2267240790E-02, 7.7119434592E-01],
	[3.1780000000E+04, 1.1259305757E+00, 1.6590856810E+00, 5.6711852259E-02, 5.2290604986E-02, 7.7122263133E-01],
	[3.1785000000E+04, 1.1262149482E+00, 1.6590507915E+00, 5.6738661704E-02, 5.2313975463E-02, 7.7125091650E-01],
	[3.1790000000E+04, 1.1264993477E+00, 1.6590159082E+00, 5.6765479603E-02, 5.2337352222E-02, 7.7127920143E-01],
	[3.1795000000E+04, 1.1267837743E+00, 1.6589810312E+00, 5.6792305957E-02, 5.2360735263E-02, 7.7130748611E-01],
	[3.1800000000E+04, 1.1270682280E+00, 1.6589461603E+00, 5.6819140768E-02, 5.2384124586E-02, 7.7133577054E-01],
	[3.1805000000E+04, 1.1273527087E+00, 1.6589112957E+00, 5.6845984036E-02, 5.2407520191E-02, 7.7136405473E-01],
	[3.1810000000E+04, 1.1276372165E+00, 1.6588764373E+00, 5.6872835763E-02, 5.2430922079E-02, 7.7139233868E-01],
	[3.1815000000E+04, 1.1279217514E+00, 1.6588415851E+00, 5.6899695950E-02, 5.2454330251E-02, 7.7142062237E-01],
	[3.1820000000E+04, 1.1282063133E+00, 1.6588067391E+00, 5.6926564599E-02, 5.2477744705E-02, 7.7144890582E-01],
	[3.1825000000E+04, 1.1284909023E+00, 1.6587718994E+00, 5.6953441711E-02, 5.2501165443E-02, 7.7147718901E-01],
	[3.1830000000E+04, 1.1287755184E+00, 1.6587370658E+00, 5.6980327288E-02, 5.2524592465E-02, 7.7150547195E-01],
	[3.1835000000E+04, 1.1290601615E+00, 1.6587022384E+00, 5.7007221330E-02, 5.2548025771E-02, 7.7153375464E-01],
	[3.1840000000E+04, 1.1293448317E+00, 1.6586674173E+00, 5.7034123840E-02, 5.2571465361E-02, 7.7156203707E-01],
	[3.1845000000E+04, 1.1296295290E+00, 1.6586326023E+00, 5.7061034817E-02, 5.2594911236E-02, 7.7159031924E-01],
	[3.1850000000E+04, 1.1299142533E+00, 1.6585977935E+00, 5.7087954265E-02, 5.2618363396E-02, 7.7161860116E-01],
	[3.1855000000E+04, 1.1301990046E+00, 1.6585629909E+00, 5.7114882183E-02, 5.2641821841E-02, 7.7164688282E-01],
	[3.1860000000E+04, 1.1304837830E+00, 1.6585281945E+00, 5.7141818574E-02, 5.2665286572E-02, 7.7167516422E-01],
	[3.1865000000E+04, 1.1307685885E+00, 1.6584934043E+00, 5.7168763438E-02, 5.2688757589E-02, 7.7170344536E-01],
	[3.1870000000E+04, 1.1310534210E+00, 1.6584586203E+00, 5.7195716778E-02, 5.2712234891E-02, 7.7173172624E-01],
	[3.1875000000E+04, 1.1313382806E+00, 1.6584238425E+00, 5.7222678594E-02, 5.2735718481E-02, 7.7176000685E-01],
	[3.1880000000E+04, 1.1316231672E+00, 1.6583890709E+00, 5.7249648887E-02, 5.2759208357E-02, 7.7178828720E-01],
	[3.1885000000E+04, 1.1319081557E+00, 1.6583552465E+00, 5.7276627660E-02, 5.2782705636E-02, 7.7181656728E-01],
	[3.1890000000E+04, 1.1321931817E+00, 1.6583215571E+00, 5.7303614913E-02, 5.2806209357E-02, 7.7184484710E-01],
	[3.1895000000E+04, 1.1324782347E+00, 1.6582878736E+00, 5.7330610648E-02, 5.2829719368E-02, 7.7187312664E-01],
	[3.1900000000E+04, 1.1327633147E+00, 1.6582541961E+00, 5.7357614866E-02, 5.2853235668E-02, 7.7190140592E-01],
	[3.1905000000E+04, 1.1330484219E+00, 1.6582205246E+00, 5.7384627568E-02, 5.2876758259E-02, 7.7192968493E-01],
	[3.1910000000E+04, 1.1333335561E+00, 1.6581868590E+00, 5.7411648756E-02, 5.2900287140E-02, 7.7195796366E-01],
	[3.1915000000E+04, 1.1336187173E+00, 1.6581531994E+00, 5.7438678431E-02, 5.2923822312E-02, 7.7198624212E-01],
	[3.1920000000E+04, 1.1339039057E+00, 1.6581195457E+00, 5.7465716595E-02, 5.2947363775E-02, 7.7201452031E-01],
	[3.1925000000E+04, 1.1341891210E+00, 1.6580858980E+00, 5.7492763248E-02, 5.2970911529E-02, 7.7204279822E-01],
	[3.1930000000E+04, 1.1344743635E+00, 1.6580522563E+00, 5.7519818392E-02, 5.2994465574E-02, 7.7207107585E-01],
	[3.1935000000E+04, 1.1347596330E+00, 1.6580186205E+00, 5.7546882029E-02, 5.3018025911E-02, 7.7209935320E-01],
	[3.1940000000E+04, 1.1350449295E+00, 1.6579849906E+00, 5.7573954159E-02, 5.3041592541E-02, 7.7212763028E-01],
	[3.1945000000E+04, 1.1353302531E+00, 1.6579513667E+00, 5.7601034785E-02, 5.3065165462E-02, 7.7215590707E-01],
	[3.1950000000E+04, 1.1356156038E+00, 1.6579177487E+00, 5.7628123907E-02, 5.3088744677E-02, 7.7218418359E-01],
	[3.1955000000E+04, 1.1359009815E+00, 1.6578841367E+00, 5.7655221527E-02, 5.3112330184E-02, 7.7221245981E-01],
	[3.1960000000E+04, 1.1361863863E+00, 1.6578505306E+00, 5.7682327645E-02, 5.3135921984E-02, 7.7224073576E-01],
	[3.1965000000E+04, 1.1364718181E+00, 1.6578169305E+00, 5.7709442265E-02, 5.3159520078E-02, 7.7226901142E-01],
	[3.1970000000E+04, 1.1367572769E+00, 1.6577833363E+00, 5.7736565386E-02, 5.3183124466E-02, 7.7229728679E-01],
	[3.1975000000E+04, 1.1370427628E+00, 1.6577497480E+00, 5.7763697010E-02, 5.3206735147E-02, 7.7232556187E-01],
	[3.1980000000E+04, 1.1373282757E+00, 1.6577161656E+00, 5.7790837138E-02, 5.3230352123E-02, 7.7235383667E-01],
	[3.1985000000E+04, 1.1376138157E+00, 1.6576825892E+00, 5.7817985773E-02, 5.3253975393E-02, 7.7238211117E-01],
	[3.1990000000E+04, 1.1378993827E+00, 1.6576490187E+00, 5.7845142914E-02, 5.3277604959E-02, 7.7241038538E-01],
	[3.1995000000E+04, 1.1381849768E+00, 1.6576154542E+00, 5.7872308564E-02, 5.3301240819E-02, 7.7243865930E-01],
	[3.2000000000E+04, 1.1384705979E+00, 1.6575818955E+00, 5.7899482723E-02, 5.3324882975E-02, 7.7246693293E-01],
	[3.2005000000E+04, 1.1387562460E+00, 1.6575483428E+00, 5.7926665394E-02, 5.3348531426E-02, 7.7249520626E-01],
	[3.2010000000E+04, 1.1390419211E+00, 1.6575147960E+00, 5.7953856577E-02, 5.3372186174E-02, 7.7252347929E-01],
	[3.2015000000E+04, 1.1393276233E+00, 1.6574812551E+00, 5.7981056274E-02, 5.3395847217E-02, 7.7255175202E-01],
	[3.2020000000E+04, 1.1396133525E+00, 1.6574477202E+00, 5.8008264486E-02, 5.3419514557E-02, 7.7258002446E-01],
	[3.2025000000E+04, 1.1398991087E+00, 1.6574141911E+00, 5.8035481215E-02, 5.3443188194E-02, 7.7260829659E-01],
	[3.2030000000E+04, 1.1401848920E+00, 1.6573806680E+00, 5.8062706461E-02, 5.3466868128E-02, 7.7263656842E-01],
	[3.2035000000E+04, 1.1404707023E+00, 1.6573471508E+00, 5.8089940226E-02, 5.3490554359E-02, 7.7266483995E-01],
	[3.2040000000E+04, 1.1407565396E+00, 1.6573136395E+00, 5.8117182512E-02, 5.3514246888E-02, 7.7269311118E-01],
	[3.2045000000E+04, 1.1410424039E+00, 1.6572801341E+00, 5.8144433320E-02, 5.3537945715E-02, 7.7272138210E-01],
	[3.2050000000E+04, 1.1413282952E+00, 1.6572466346E+00, 5.8171692651E-02, 5.3561650839E-02, 7.7274965272E-01],
	[3.2055000000E+04, 1.1416142136E+00, 1.6572131410E+00, 5.8198960506E-02, 5.3585362263E-02, 7.7277792302E-01],
	[3.2060000000E+04, 1.1419001590E+00, 1.6571796533E+00, 5.8226236887E-02, 5.3609079984E-02, 7.7280619302E-01],
	[3.2065000000E+04, 1.1421861314E+00, 1.6571461715E+00, 5.8253521795E-02, 5.3632804005E-02, 7.7283446271E-01],
	[3.2070000000E+04, 1.1424721308E+00, 1.6571126956E+00, 5.8280815232E-02, 5.3656534325E-02, 7.7286273208E-01],
	[3.2075000000E+04, 1.1427581572E+00, 1.6570792256E+00, 5.8308117198E-02, 5.3680270945E-02, 7.7289100115E-01],
	[3.2080000000E+04, 1.1430442106E+00, 1.6570457614E+00, 5.8335427696E-02, 5.3704013864E-02, 7.7291926990E-01],
	[3.2085000000E+04, 1.1433302910E+00, 1.6570123032E+00, 5.8362746726E-02, 5.3727763083E-02, 7.7294753833E-01],
	[3.2090000000E+04, 1.1436163985E+00, 1.6569788509E+00, 5.8390074289E-02, 5.3751518603E-02, 7.7297580645E-01],
	[3.2095000000E+04, 1.1439025329E+00, 1.6569454044E+00, 5.8417410388E-02, 5.3775280423E-02, 7.7300407425E-01],
	[3.2100000000E+04, 1.1441886943E+00, 1.6569119639E+00, 5.8444755024E-02, 5.3799048544E-02, 7.7303234174E-01],
	[3.2105000000E+04, 1.1444748828E+00, 1.6568785292E+00, 5.8472108197E-02, 5.3822822966E-02, 7.7306060890E-01],
	[3.2110000000E+04, 1.1447610982E+00, 1.6568451004E+00, 5.8499469910E-02, 5.3846603689E-02, 7.7308887574E-01],
	[3.2115000000E+04, 1.1450473406E+00, 1.6568116775E+00, 5.8526840163E-02, 5.3870390714E-02, 7.7311714226E-01],
	[3.2120000000E+04, 1.1453336101E+00, 1.6567782604E+00, 5.8554218957E-02, 5.3894184041E-02, 7.7314540845E-01],
	[3.2125000000E+04, 1.1456199065E+00, 1.6567448493E+00, 5.8581606295E-02, 5.3917983670E-02, 7.7317367432E-01],
	[3.2130000000E+04, 1.1459062299E+00, 1.6567114440E+00, 5.8609002178E-02, 5.3941789602E-02, 7.7320193987E-01],
	[3.2135000000E+04, 1.1461925803E+00, 1.6566780446E+00, 5.8636406606E-02, 5.3965601836E-02, 7.7323020509E-01],
	[3.2140000000E+04, 1.1464789577E+00, 1.6566446510E+00, 5.8663819581E-02, 5.3989420373E-02, 7.7325846998E-01],
	[3.2145000000E+04, 1.1467653621E+00, 1.6566112633E+00, 5.8691241105E-02, 5.4013245214E-02, 7.7328673454E-01],
	[3.2150000000E+04, 1.1470517934E+00, 1.6565778815E+00, 5.8718671179E-02, 5.4037076358E-02, 7.7331499876E-01],
	[3.2155000000E+04, 1.1473382518E+00, 1.6565445055E+00, 5.8746109804E-02, 5.4060913806E-02, 7.7334326266E-01],
	[3.2160000000E+04, 1.1476247371E+00, 1.6565111354E+00, 5.8773556981E-02, 5.4084757557E-02, 7.7337152622E-01],
	[3.2165000000E+04, 1.1479112494E+00, 1.6564777712E+00, 5.8801012712E-02, 5.4108607613E-02, 7.7339978945E-01],
	[3.2170000000E+04, 1.1481977887E+00, 1.6564444128E+00, 5.8828476999E-02, 5.4132463974E-02, 7.7342805235E-01],
	[3.2175000000E+04, 1.1484843549E+00, 1.6564110603E+00, 5.8855949842E-02, 5.4156326639E-02, 7.7345631490E-01],
	[3.2180000000E+04, 1.1487709482E+00, 1.6563777137E+00, 5.8883431243E-02, 5.4180195610E-02, 7.7348457712E-01],
	[3.2185000000E+04, 1.1490575684E+00, 1.6563443728E+00, 5.8910921203E-02, 5.4204070886E-02, 7.7351283900E-01],
	[3.2190000000E+04, 1.1493442156E+00, 1.6563110379E+00, 5.8938419723E-02, 5.4227952467E-02, 7.7354110054E-01],
	[3.2195000000E+04, 1.1496308897E+00, 1.6562777088E+00, 5.8965926805E-02, 5.4251840355E-02, 7.7356936173E-01],
	[3.2200000000E+04, 1.1499175909E+00, 1.6562443855E+00, 5.8993442451E-02, 5.4275734548E-02, 7.7359762259E-01],
	[3.2205000000E+04, 1.1502043190E+00, 1.6562110681E+00, 5.9020966661E-02, 5.4299635048E-02, 7.7362588310E-01],
	[3.2210000000E+04, 1.1504910740E+00, 1.6561777565E+00, 5.9048499437E-02, 5.4323541855E-02, 7.7365414326E-01],
	[3.2215000000E+04, 1.1507778560E+00, 1.6561444507E+00, 5.9076040780E-02, 5.4347454968E-02, 7.7368240308E-01],
	[3.2220000000E+04, 1.1510646650E+00, 1.6561111508E+00, 5.9103590692E-02, 5.4371374389E-02, 7.7371066255E-01],
	[3.2225000000E+04, 1.1513515010E+00, 1.6560778568E+00, 5.9131149173E-02, 5.4395300117E-02, 7.7373892167E-01],
	[3.2230000000E+04, 1.1516383639E+00, 1.6560445685E+00, 5.9158716226E-02, 5.4419232153E-02, 7.7376718044E-01],
	[3.2235000000E+04, 1.1519252537E+00, 1.6560112861E+00, 5.9186291851E-02, 5.4443170497E-02, 7.7379543886E-01],
	[3.2240000000E+04, 1.1522121705E+00, 1.6559780096E+00, 5.9213876050E-02, 5.4467115149E-02, 7.7382369693E-01],
	[3.2245000000E+04, 1.1524991143E+00, 1.6559447388E+00, 5.9241468825E-02, 5.4491066109E-02, 7.7385195464E-01],
	[3.2250000000E+04, 1.1527860850E+00, 1.6559114739E+00, 5.9269070176E-02, 5.4515023378E-02, 7.7388021200E-01],
	[3.2255000000E+04, 1.1530730827E+00, 1.6558782148E+00, 5.9296680105E-02, 5.4538986956E-02, 7.7390846900E-01],
	[3.2260000000E+04, 1.1533601073E+00, 1.6558449616E+00, 5.9324298613E-02, 5.4562956844E-02, 7.7393672564E-01],
	[3.2265000000E+04, 1.1536471589E+00, 1.6558117141E+00, 5.9351925701E-02, 5.4586933041E-02, 7.7396498193E-01],
	[3.2270000000E+04, 1.1539342374E+00, 1.6557784725E+00, 5.9379561372E-02, 5.4610915548E-02, 7.7399323785E-01],
	[3.2275000000E+04, 1.1542213428E+00, 1.6557452367E+00, 5.9407205625E-02, 5.4634904364E-02, 7.7402149342E-01],
	[3.2280000000E+04, 1.1545084752E+00, 1.6557120067E+00, 5.9434858463E-02, 5.4658899491E-02, 7.7404974862E-01],
	[3.2285000000E+04, 1.1547956346E+00, 1.6556787825E+00, 5.9462519888E-02, 5.4682900929E-02, 7.7407800346E-01],
	[3.2290000000E+04, 1.1550828209E+00, 1.6556455641E+00, 5.9490189899E-02, 5.4706908677E-02, 7.7410625793E-01],
	[3.2295000000E+04, 1.1553700341E+00, 1.6556123516E+00, 5.9517868499E-02, 5.4730922737E-02, 7.7413451204E-01],
	[3.2300000000E+04, 1.1556572742E+00, 1.6555791448E+00, 5.9545555689E-02, 5.4754943108E-02, 7.7416276578E-01],
	[3.2305000000E+04, 1.1559445413E+00, 1.6555459439E+00, 5.9573251470E-02, 5.4778969790E-02, 7.7419101916E-01],
	[3.2310000000E+04, 1.1562318353E+00, 1.6555127488E+00, 5.9600955843E-02, 5.4803002784E-02, 7.7421927216E-01],
	[3.2315000000E+04, 1.1565191563E+00, 1.6554795594E+00, 5.9628668811E-02, 5.4827042090E-02, 7.7424752479E-01],
	[3.2320000000E+04, 1.1568065042E+00, 1.6554463759E+00, 5.9656390374E-02, 5.4851087709E-02, 7.7427577705E-01],
	[3.2325000000E+04, 1.1570938790E+00, 1.6554131981E+00, 5.9684120533E-02, 5.4875139640E-02, 7.7430402894E-01],
	[3.2330000000E+04, 1.1573812807E+00, 1.6553800262E+00, 5.9711859290E-02, 5.4899197884E-02, 7.7433228045E-01],
	[3.2335000000E+04, 1.1576687094E+00, 1.6553468601E+00, 5.9739606647E-02, 5.4923262441E-02, 7.7436053159E-01],
	[3.2340000000E+04, 1.1579561649E+00, 1.6553136997E+00, 5.9767362604E-02, 5.4947333311E-02, 7.7438878235E-01],
	[3.2345000000E+04, 1.1582436474E+00, 1.6552805451E+00, 5.9795127163E-02, 5.4971410495E-02, 7.7441703274E-01],
	[3.2350000000E+04, 1.1585311569E+00, 1.6552473964E+00, 5.9822900325E-02, 5.4995493993E-02, 7.7444528274E-01],
	[3.2355000000E+04, 1.1588186932E+00, 1.6552142534E+00, 5.9850682092E-02, 5.5019583805E-02, 7.7447353237E-01],
	[3.2360000000E+04, 1.1591062564E+00, 1.6551811162E+00, 5.9878472465E-02, 5.5043679931E-02, 7.7450178161E-01],
	[3.2365000000E+04, 1.1593938466E+00, 1.6551479847E+00, 5.9906271445E-02, 5.5067782372E-02, 7.7453003047E-01],
	[3.2370000000E+04, 1.1596814637E+00, 1.6551148591E+00, 5.9934079033E-02, 5.5091891128E-02, 7.7455827895E-01],
	[3.2375000000E+04, 1.1599691077E+00, 1.6550817392E+00, 5.9961895232E-02, 5.5116006198E-02, 7.7458652704E-01],
	[3.2380000000E+04, 1.1602567786E+00, 1.6550486251E+00, 5.9989720042E-02, 5.5140127585E-02, 7.7461477474E-01],
	[3.2385000000E+04, 1.1605444764E+00, 1.6550155168E+00, 6.0017553464E-02, 5.5164255286E-02, 7.7464302206E-01],
	[3.2390000000E+04, 1.1608322011E+00, 1.6549824143E+00, 6.0045395501E-02, 5.5188389304E-02, 7.7467126899E-01],
	[3.2395000000E+04, 1.1611199428E+00, 1.6549495621E+00, 6.0073246152E-02, 5.5212529887E-02, 7.7469951553E-01],
	[3.2400000000E+04, 1.1614076789E+00, 1.6549175222E+00, 6.0101105421E-02, 5.5236677612E-02, 7.7472776168E-01],
	[3.2405000000E+04, 1.1616954418E+00, 1.6548854879E+00, 6.0128973307E-02, 5.5260831656E-02, 7.7475600744E-01],
	[3.2410000000E+04, 1.1619832316E+00, 1.6548534591E+00, 6.0156849812E-02, 5.5284992018E-02, 7.7478425280E-01],
	[3.2415000000E+04, 1.1622710483E+00, 1.6548214359E+00, 6.0184734938E-02, 5.5309158699E-02, 7.7481249777E-01],
	[3.2420000000E+04, 1.1625588919E+00, 1.6547894182E+00, 6.0212628686E-02, 5.5333331699E-02, 7.7484074234E-01],
	[3.2425000000E+04, 1.1628467624E+00, 1.6547574061E+00, 6.0240531058E-02, 5.5357511019E-02, 7.7486898652E-01],
	[3.2430000000E+04, 1.1631346597E+00, 1.6547253996E+00, 6.0268442054E-02, 5.5381696658E-02, 7.7489723029E-01],
	[3.2435000000E+04, 1.1634225839E+00, 1.6546933986E+00, 6.0296361676E-02, 5.5405888617E-02, 7.7492547367E-01],
	[3.2440000000E+04, 1.1637105350E+00, 1.6546614032E+00, 6.0324289925E-02, 5.5430086897E-02, 7.7495371665E-01],
	[3.2445000000E+04, 1.1639985130E+00, 1.6546294133E+00, 6.0352226803E-02, 5.5454291496E-02, 7.7498195922E-01],
	[3.2450000000E+04, 1.1642865178E+00, 1.6545974290E+00, 6.0380172311E-02, 5.5478502417E-02, 7.7501020140E-01],
	[3.2455000000E+04, 1.1645745495E+00, 1.6545654502E+00, 6.0408126450E-02, 5.5502719658E-02, 7.7503844316E-01],
	[3.2460000000E+04, 1.1648626081E+00, 1.6545334769E+00, 6.0436089222E-02, 5.5526943220E-02, 7.7506668453E-01],
	[3.2465000000E+04, 1.1651506935E+00, 1.6545015092E+00, 6.0464060627E-02, 5.5551173104E-02, 7.7509492549E-01],
	[3.2470000000E+04, 1.1654388058E+00, 1.6544695470E+00, 6.0492040668E-02, 5.5575409309E-02, 7.7512316603E-01],
	[3.2475000000E+04, 1.1657269450E+00, 1.6544375904E+00, 6.0520029346E-02, 5.5599651836E-02, 7.7515140617E-01],
	[3.2480000000E+04, 1.1660151110E+00, 1.6544056393E+00, 6.0548026662E-02, 5.5623900686E-02, 7.7517964590E-01],
	[3.2485000000E+04, 1.1663033039E+00, 1.6543736938E+00, 6.0576032617E-02, 5.5648155857E-02, 7.7520788522E-01],
	[3.2490000000E+04, 1.1665915237E+00, 1.6543417537E+00, 6.0604047212E-02, 5.5672417352E-02, 7.7523612413E-01],
	[3.2495000000E+04, 1.1668797703E+00, 1.6543098193E+00, 6.0632070450E-02, 5.5696685169E-02, 7.7526436262E-01],
	[3.2500000000E+04, 1.1671680437E+00, 1.6542778903E+00, 6.0660102331E-02, 5.5720959309E-02, 7.7529260070E-01],
	[3.2505000000E+04, 1.1674563441E+00, 1.6542459669E+00, 6.0688142857E-02, 5.5745239772E-02, 7.7532083836E-01],
	[3.2510000000E+04, 1.1677446712E+00, 1.6542140490E+00, 6.0716192028E-02, 5.5769526559E-02, 7.7534907561E-01],
	[3.2515000000E+04, 1.1680330253E+00, 1.6541821366E+00, 6.0744249847E-02, 5.5793819670E-02, 7.7537731243E-01],
	[3.2520000000E+04, 1.1683214061E+00, 1.6541502297E+00, 6.0772316315E-02, 5.5818119105E-02, 7.7540554884E-01],
	[3.2525000000E+04, 1.1686098138E+00, 1.6541183284E+00, 6.0800391432E-02, 5.5842424864E-02, 7.7543378483E-01],
	[3.2530000000E+04, 1.1688982484E+00, 1.6540864326E+00, 6.0828475201E-02, 5.5866736948E-02, 7.7546202039E-01],
	[3.2535000000E+04, 1.1691867098E+00, 1.6540545423E+00, 6.0856567623E-02, 5.5891055357E-02, 7.7549025553E-01],
	[3.2540000000E+04, 1.1694751981E+00, 1.6540226575E+00, 6.0884668698E-02, 5.5915380090E-02, 7.7551849025E-01],
	[3.2545000000E+04, 1.1697637132E+00, 1.6539907782E+00, 6.0912778429E-02, 5.5939711149E-02, 7.7554672454E-01],
	[3.2550000000E+04, 1.1700522551E+00, 1.6539589044E+00, 6.0940896817E-02, 5.5964048534E-02, 7.7557495841E-01],
	[3.2555000000E+04, 1.1703408239E+00, 1.6539270362E+00, 6.0969023863E-02, 5.5988392244E-02, 7.7560319184E-01],
	[3.2560000000E+04, 1.1706294195E+00, 1.6538951734E+00, 6.0997159568E-02, 5.6012742280E-02, 7.7563142485E-01],
	[3.2565000000E+04, 1.1709180419E+00, 1.6538633162E+00, 6.1025303933E-02, 5.6037098642E-02, 7.7565965743E-01],
	[3.2570000000E+04, 1.1712066912E+00, 1.6538314645E+00, 6.1053456961E-02, 5.6061461331E-02, 7.7568788958E-01],
	[3.2575000000E+04, 1.1714953673E+00, 1.6537996182E+00, 6.1081618652E-02, 5.6085830347E-02, 7.7571612129E-01],
	[3.2580000000E+04, 1.1717840702E+00, 1.6537677775E+00, 6.1109789008E-02, 5.6110205689E-02, 7.7574435257E-01],
	[3.2585000000E+04, 1.1720728000E+00, 1.6537359423E+00, 6.1137968029E-02, 5.6134587359E-02, 7.7577258341E-01],
	[3.2590000000E+04, 1.1723615566E+00, 1.6537041125E+00, 6.1166155719E-02, 5.6158975356E-02, 7.7580081382E-01],
	[3.2595000000E+04, 1.1726503400E+00, 1.6536722883E+00, 6.1194352076E-02, 5.6183369680E-02, 7.7582904380E-01],
	[3.2600000000E+04, 1.1729391503E+00, 1.6536404695E+00, 6.1222557104E-02, 5.6207770333E-02, 7.7585727333E-01],
	[3.2605000000E+04, 1.1732279873E+00, 1.6536086563E+00, 6.1250770803E-02, 5.6232177314E-02, 7.7588550242E-01],
	[3.2610000000E+04, 1.1735168512E+00, 1.6535768485E+00, 6.1278993175E-02, 5.6256590623E-02, 7.7591373108E-01],
	[3.2615000000E+04, 1.1738057419E+00, 1.6535450462E+00, 6.1307224221E-02, 5.6281010260E-02, 7.7594195929E-01],
	[3.2620000000E+04, 1.1740946594E+00, 1.6535132495E+00, 6.1335463943E-02, 5.6305436227E-02, 7.7597018706E-01],
	[3.2625000000E+04, 1.1743836037E+00, 1.6534814582E+00, 6.1363712341E-02, 5.6329868522E-02, 7.7599841438E-01],
	[3.2630000000E+04, 1.1746725749E+00, 1.6534496723E+00, 6.1391969417E-02, 5.6354307147E-02, 7.7602664126E-01],
	[3.2635000000E+04, 1.1749615728E+00, 1.6534178920E+00, 6.1420235172E-02, 5.6378752102E-02, 7.7605486770E-01],
	[3.2640000000E+04, 1.1752505976E+00, 1.6533861171E+00, 6.1448509608E-02, 5.6403203386E-02, 7.7608309369E-01],
	[3.2645000000E+04, 1.1755396492E+00, 1.6533543477E+00, 6.1476792727E-02, 5.6427661000E-02, 7.7611131922E-01],
	[3.2650000000E+04, 1.1758287276E+00, 1.6533225838E+00, 6.1505084528E-02, 5.6452124944E-02, 7.7613954431E-01],
	[3.2655000000E+04, 1.1761178327E+00, 1.6532908254E+00, 6.1533385015E-02, 5.6476595219E-02, 7.7616776895E-01],
	[3.2660000000E+04, 1.1764069647E+00, 1.6532590724E+00, 6.1561694187E-02, 5.6501071825E-02, 7.7619599314E-01],
	[3.2665000000E+04, 1.1766961235E+00, 1.6532273250E+00, 6.1590012047E-02, 5.6525554761E-02, 7.7622421687E-01],
	[3.2670000000E+04, 1.1769853091E+00, 1.6531955829E+00, 6.1618338595E-02, 5.6550044029E-02, 7.7625244015E-01],
	[3.2675000000E+04, 1.1772745215E+00, 1.6531638464E+00, 6.1646673834E-02, 5.6574539628E-02, 7.7628066297E-01],
	[3.2680000000E+04, 1.1775637607E+00, 1.6531321153E+00, 6.1675017764E-02, 5.6599041559E-02, 7.7630888534E-01],
	[3.2685000000E+04, 1.1778530267E+00, 1.6531003897E+00, 6.1703370387E-02, 5.6623549822E-02, 7.7633710724E-01],
	[3.2690000000E+04, 1.1781423195E+00, 1.6530686695E+00, 6.1731731703E-02, 5.6648064416E-02, 7.7636532869E-01],
	[3.2695000000E+04, 1.1784316390E+00, 1.6530369548E+00, 6.1760101716E-02, 5.6672585343E-02, 7.7639354968E-01],
	[3.2700000000E+04, 1.1787209854E+00, 1.6530052455E+00, 6.1788480425E-02, 5.6697112603E-02, 7.7642177021E-01],
	[3.2705000000E+04, 1.1790103586E+00, 1.6529735418E+00, 6.1816867832E-02, 5.6721646195E-02, 7.7644999027E-01],
	[3.2710000000E+04, 1.1792997585E+00, 1.6529418434E+00, 6.1845263938E-02, 5.6746186121E-02, 7.7647820987E-01],
	[3.2715000000E+04, 1.1795891852E+00, 1.6529101505E+00, 6.1873668745E-02, 5.6770732379E-02, 7.7650642901E-01],
	[3.2720000000E+04, 1.1798786387E+00, 1.6528784631E+00, 6.1902082255E-02, 5.6795284971E-02, 7.7653464767E-01],
	[3.2725000000E+04, 1.1801681190E+00, 1.6528467811E+00, 6.1930504467E-02, 5.6819843897E-02, 7.7656286588E-01],
	[3.2730000000E+04, 1.1804576261E+00, 1.6528151046E+00, 6.1958935385E-02, 5.6844409157E-02, 7.7659108361E-01],
	[3.2735000000E+04, 1.1807471600E+00, 1.6527834335E+00, 6.1987375008E-02, 5.6868980751E-02, 7.7661930087E-01],
	[3.2740000000E+04, 1.1810367206E+00, 1.6527517679E+00, 6.2015823339E-02, 5.6893558679E-02, 7.7664751766E-01],
	[3.2745000000E+04, 1.1813263080E+00, 1.6527201076E+00, 6.2044280379E-02, 5.6918142942E-02, 7.7667573398E-01],
	[3.2750000000E+04, 1.1816159222E+00, 1.6526884529E+00, 6.2072746129E-02, 5.6942733540E-02, 7.7670394983E-01],
	[3.2755000000E+04, 1.1819055631E+00, 1.6526568036E+00, 6.2101220590E-02, 5.6967330473E-02, 7.7673216520E-01],
	[3.2760000000E+04, 1.1821952309E+00, 1.6526251597E+00, 6.2129703764E-02, 5.6991933741E-02, 7.7676038009E-01],
	[3.2765000000E+04, 1.1824849254E+00, 1.6525935212E+00, 6.2158195652E-02, 5.7016543345E-02, 7.7678859451E-01],
	[3.2770000000E+04, 1.1827746466E+00, 1.6525618882E+00, 6.2186696256E-02, 5.7041159284E-02, 7.7681680845E-01],
	[3.2775000000E+04, 1.1830643947E+00, 1.6525302606E+00, 6.2215205576E-02, 5.7065781559E-02, 7.7684502191E-01],
	[3.2780000000E+04, 1.1833541695E+00, 1.6524986384E+00, 6.2243723615E-02, 5.7090410171E-02, 7.7687323489E-01],
	[3.2785000000E+04, 1.1836439710E+00, 1.6524670217E+00, 6.2272250373E-02, 5.7115045119E-02, 7.7690144739E-01],
	[3.2790000000E+04, 1.1839337993E+00, 1.6524354104E+00, 6.2300785851E-02, 5.7139686403E-02, 7.7692965940E-01],
	[3.2795000000E+04, 1.1842236544E+00, 1.6524038045E+00, 6.2329330052E-02, 5.7164334025E-02, 7.7695787093E-01],
	[3.2800000000E+04, 1.1845135363E+00, 1.6523722041E+00, 6.2357882977E-02, 5.7188987983E-02, 7.7698608198E-01],
	[3.2805000000E+04, 1.1848034449E+00, 1.6523406090E+00, 6.2386444626E-02, 5.7213648279E-02, 7.7701429254E-01],
	[3.2810000000E+04, 1.1850933802E+00, 1.6523090194E+00, 6.2415015001E-02, 5.7238314913E-02, 7.7704250261E-01],
	[3.2815000000E+04, 1.1853833423E+00, 1.6522774352E+00, 6.2443594103E-02, 5.7262987884E-02, 7.7707071219E-01],
	[3.2820000000E+04, 1.1856733312E+00, 1.6522458564E+00, 6.2472181935E-02, 5.7287667193E-02, 7.7709892128E-01],
	[3.2825000000E+04, 1.1859633468E+00, 1.6522142831E+00, 6.2500778497E-02, 5.7312352840E-02, 7.7712712989E-01],
	[3.2830000000E+04, 1.1862533892E+00, 1.6521827151E+00, 6.2529383790E-02, 5.7337044826E-02, 7.7715533800E-01],
	[3.2835000000E+04, 1.1865434583E+00, 1.6521511526E+00, 6.2557997815E-02, 5.7361743151E-02, 7.7718354561E-01],
	[3.2840000000E+04, 1.1868335541E+00, 1.6521195954E+00, 6.2586620575E-02, 5.7386447814E-02, 7.7721175273E-01],
	[3.2845000000E+04, 1.1871236767E+00, 1.6520880437E+00, 6.2615252071E-02, 5.7411158816E-02, 7.7723995936E-01],
	[3.2850000000E+04, 1.1874138260E+00, 1.6520564974E+00, 6.2643892303E-02, 5.7435876158E-02, 7.7726816549E-01],
	[3.2855000000E+04, 1.1877040021E+00, 1.6520249564E+00, 6.2672541274E-02, 5.7460599839E-02, 7.7729637112E-01],
	[3.2860000000E+04, 1.1879942049E+00, 1.6519934209E+00, 6.2701198984E-02, 5.7485329860E-02, 7.7732457625E-01],
	[3.2865000000E+04, 1.1882844345E+00, 1.6519618908E+00, 6.2729865434E-02, 5.7510066221E-02, 7.7735278088E-01],
	[3.2870000000E+04, 1.1885746908E+00, 1.6519303661E+00, 6.2758540627E-02, 5.7534808922E-02, 7.7738098500E-01],
	[3.2875000000E+04, 1.1888649738E+00, 1.6518988467E+00, 6.2787224564E-02, 5.7559557964E-02, 7.7740918863E-01],
	[3.2880000000E+04, 1.1891552836E+00, 1.6518673328E+00, 6.2815917245E-02, 5.7584313346E-02, 7.7743739175E-01],
	[3.2885000000E+04, 1.1894456201E+00, 1.6518358243E+00, 6.2844618672E-02, 5.7609075069E-02, 7.7746559436E-01],
	[3.2890000000E+04, 1.1897359833E+00, 1.6518043211E+00, 6.2873328847E-02, 5.7633843133E-02, 7.7749379647E-01],
	[3.2895000000E+04, 1.1900263732E+00, 1.6517728234E+00, 6.2902047771E-02, 5.7658617538E-02, 7.7752199808E-01],
	[3.2900000000E+04, 1.1903167899E+00, 1.6517413310E+00, 6.2930775445E-02, 5.7683398285E-02, 7.7755019917E-01],
	[3.2905000000E+04, 1.1906072333E+00, 1.6517098440E+00, 6.2959511870E-02, 5.7708185373E-02, 7.7757839975E-01],
	[3.2910000000E+04, 1.1908977034E+00, 1.6516783624E+00, 6.2988257048E-02, 5.7732978804E-02, 7.7760659982E-01],
	[3.2915000000E+04, 1.1911882003E+00, 1.6516468862E+00, 6.3017010981E-02, 5.7757778576E-02, 7.7763479938E-01],
	[3.2920000000E+04, 1.1914785627E+00, 1.6516163792E+00, 6.3045773669E-02, 5.7782585492E-02, 7.7766299843E-01],
	[3.2925000000E+04, 1.1917689403E+00, 1.6515859462E+00, 6.3074545113E-02, 5.7807398809E-02, 7.7769119696E-01],
	[3.2930000000E+04, 1.1920593445E+00, 1.6515555184E+00, 6.3103325316E-02, 5.7832218470E-02, 7.7771939497E-01],
	[3.2935000000E+04, 1.1923497754E+00, 1.6515250957E+00, 6.3132114279E-02, 5.7857044476E-02, 7.7774759247E-01],
	[3.2940000000E+04, 1.1926402329E+00, 1.6514946783E+00, 6.3160912002E-02, 5.7881876826E-02, 7.7777578945E-01],
	[3.2945000000E+04, 1.1929307171E+00, 1.6514642660E+00, 6.3189718487E-02, 5.7906715522E-02, 7.7780398591E-01],
	[3.2950000000E+04, 1.1932212280E+00, 1.6514338589E+00, 6.3218533736E-02, 5.7931560563E-02, 7.7783218185E-01],
	[3.2955000000E+04, 1.1935117654E+00, 1.6514034570E+00, 6.3247357750E-02, 5.7956411949E-02, 7.7786037727E-01],
	[3.2960000000E+04, 1.1938023296E+00, 1.6513730603E+00, 6.3276190530E-02, 5.7981269681E-02, 7.7788857217E-01],
	[3.2965000000E+04, 1.1940929204E+00, 1.6513426687E+00, 6.3305032078E-02, 5.8006133759E-02, 7.7791676654E-01],
	[3.2970000000E+04, 1.1943835378E+00, 1.6513122823E+00, 6.3333882394E-02, 5.8031004183E-02, 7.7794496038E-01],
	[3.2975000000E+04, 1.1946741819E+00, 1.6512819010E+00, 6.3362741481E-02, 5.8055880953E-02, 7.7797315370E-01],
	[3.2980000000E+04, 1.1949648526E+00, 1.6512515249E+00, 6.3391609339E-02, 5.8080764070E-02, 7.7800134649E-01],
	[3.2985000000E+04, 1.1952555500E+00, 1.6512211540E+00, 6.3420485970E-02, 5.8105653534E-02, 7.7802953876E-01],
	[3.2990000000E+04, 1.1955462740E+00, 1.6511907883E+00, 6.3449371376E-02, 5.8130549344E-02, 7.7805773049E-01],
	[3.2995000000E+04, 1.1958370247E+00, 1.6511604277E+00, 6.3478265556E-02, 5.8155451502E-02, 7.7808592169E-01],
	[3.3000000000E+04, 1.1961278019E+00, 1.6511300722E+00, 6.3507168514E-02, 5.8180360007E-02, 7.7811411237E-01],
	[3.3005000000E+04, 1.1964186059E+00, 1.6510997220E+00, 6.3536080250E-02, 5.8205274859E-02, 7.7814230250E-01],
	[3.3010000000E+04, 1.1967094364E+00, 1.6510693768E+00, 6.3565000765E-02, 5.8230196060E-02, 7.7817049211E-01],
	[3.3015000000E+04, 1.1970002936E+00, 1.6510390369E+00, 6.3593930062E-02, 5.8255123608E-02, 7.7819868117E-01],
	[3.3020000000E+04, 1.1972911774E+00, 1.6510087021E+00, 6.3622868140E-02, 5.8280057504E-02, 7.7822686970E-01],
	[3.3025000000E+04, 1.1975820878E+00, 1.6509783724E+00, 6.3651815002E-02, 5.8304997749E-02, 7.7825505769E-01],
	[3.3030000000E+04, 1.1978730249E+00, 1.6509480479E+00, 6.3680770649E-02, 5.8329944343E-02, 7.7828324515E-01],
	[3.3035000000E+04, 1.1981639886E+00, 1.6509177285E+00, 6.3709735083E-02, 5.8354897285E-02, 7.7831143206E-01],
	[3.3040000000E+04, 1.1984549789E+00, 1.6508874143E+00, 6.3738708303E-02, 5.8379856577E-02, 7.7833961843E-01],
	[3.3045000000E+04, 1.1987459959E+00, 1.6508571052E+00, 6.3767690313E-02, 5.8404822218E-02, 7.7836780426E-01],
	[3.3050000000E+04, 1.1990370394E+00, 1.6508268012E+00, 6.3796681113E-02, 5.8429794208E-02, 7.7839598954E-01],
	[3.3055000000E+04, 1.1993281096E+00, 1.6507965024E+00, 6.3825680705E-02, 5.8454772548E-02, 7.7842417428E-01],
	[3.3060000000E+04, 1.1996192064E+00, 1.6507662088E+00, 6.3854689089E-02, 5.8479757237E-02, 7.7845235848E-01],
	[3.3065000000E+04, 1.1999103298E+00, 1.6507359203E+00, 6.3883706268E-02, 5.8504748277E-02, 7.7848054212E-01],
	[3.3070000000E+04, 1.2002014798E+00, 1.6507056369E+00, 6.3912732242E-02, 5.8529745667E-02, 7.7850872522E-01],
	[3.3075000000E+04, 1.2004926565E+00, 1.6506753586E+00, 6.3941767013E-02, 5.8554749408E-02, 7.7853690777E-01],
	[3.3080000000E+04, 1.2007838597E+00, 1.6506450855E+00, 6.3970810582E-02, 5.8579759499E-02, 7.7856508977E-01],
	[3.3085000000E+04, 1.2010750896E+00, 1.6506148175E+00, 6.3999862951E-02, 5.8604775941E-02, 7.7859327121E-01],
	[3.3090000000E+04, 1.2013663460E+00, 1.6505845546E+00, 6.4028924121E-02, 5.8629798735E-02, 7.7862145210E-01],
	[3.3095000000E+04, 1.2016576291E+00, 1.6505542969E+00, 6.4057994094E-02, 5.8654827879E-02, 7.7864963244E-01],
	[3.3100000000E+04, 1.2019489388E+00, 1.6505240443E+00, 6.4087072869E-02, 5.8679863375E-02, 7.7867781222E-01],
	[3.3105000000E+04, 1.2022402751E+00, 1.6504937968E+00, 6.4116160450E-02, 5.8704905223E-02, 7.7870599145E-01],
	[3.3110000000E+04, 1.2025316380E+00, 1.6504635544E+00, 6.4145256837E-02, 5.8729953423E-02, 7.7873417012E-01],
	[3.3115000000E+04, 1.2028230274E+00, 1.6504333172E+00, 6.4174362031E-02, 5.8755007975E-02, 7.7876234823E-01],
	[3.3120000000E+04, 1.2031144435E+00, 1.6504030851E+00, 6.4203476035E-02, 5.8780068879E-02, 7.7879052578E-01],
	[3.3125000000E+04, 1.2034058862E+00, 1.6503728581E+00, 6.4232598849E-02, 5.8805136136E-02, 7.7881870276E-01],
	[3.3130000000E+04, 1.2036973555E+00, 1.6503426362E+00, 6.4261730474E-02, 5.8830209746E-02, 7.7884687919E-01],
	[3.3135000000E+04, 1.2039888513E+00, 1.6503124194E+00, 6.4290870912E-02, 5.8855289708E-02, 7.7887505505E-01],
	[3.3140000000E+04, 1.2042803738E+00, 1.6502822077E+00, 6.4320020165E-02, 5.8880376024E-02, 7.7890323035E-01],
	[3.3145000000E+04, 1.2045719228E+00, 1.6502520012E+00, 6.4349178233E-02, 5.8905468693E-02, 7.7893140508E-01],
	[3.3150000000E+04, 1.2048634985E+00, 1.6502217997E+00, 6.4378345118E-02, 5.8930567716E-02, 7.7895957925E-01],
	[3.3155000000E+04, 1.2051551007E+00, 1.6501916034E+00, 6.4407520822E-02, 5.8955673092E-02, 7.7898775284E-01],
	[3.3160000000E+04, 1.2054467295E+00, 1.6501614121E+00, 6.4436705345E-02, 5.8980784823E-02, 7.7901592587E-01],
	[3.3165000000E+04, 1.2057383849E+00, 1.6501312260E+00, 6.4465898689E-02, 5.9005902907E-02, 7.7904409833E-01],
	[3.3170000000E+04, 1.2060300669E+00, 1.6501010450E+00, 6.4495100855E-02, 5.9031027346E-02, 7.7907227021E-01],
	[3.3175000000E+04, 1.2063217754E+00, 1.6500708691E+00, 6.4524311845E-02, 5.9056158139E-02, 7.7910044152E-01],
	[3.3180000000E+04, 1.2066135106E+00, 1.6500406982E+00, 6.4553531660E-02, 5.9081295287E-02, 7.7912861226E-01],
	[3.3185000000E+04, 1.2069052723E+00, 1.6500105325E+00, 6.4582760301E-02, 5.9106438790E-02, 7.7915678243E-01],
	[3.3190000000E+04, 1.2071970606E+00, 1.6499803719E+00, 6.4611997770E-02, 5.9131588649E-02, 7.7918495201E-01],
	[3.3195000000E+04, 1.2074888754E+00, 1.6499502163E+00, 6.4641244068E-02, 5.9156744862E-02, 7.7921312102E-01],
	[3.3200000000E+04, 1.2077807169E+00, 1.6499200659E+00, 6.4670499196E-02, 5.9181907432E-02, 7.7924128945E-01],
	[3.3205000000E+04, 1.2080725849E+00, 1.6498899205E+00, 6.4699763155E-02, 5.9207076356E-02, 7.7926945731E-01],
	[3.3210000000E+04, 1.2083644795E+00, 1.6498597803E+00, 6.4729035948E-02, 5.9232251637E-02, 7.7929762458E-01],
	[3.3215000000E+04, 1.2086564006E+00, 1.6498296451E+00, 6.4758317575E-02, 5.9257433274E-02, 7.7932579127E-01],
	[3.3220000000E+04, 1.2089483483E+00, 1.6497995150E+00, 6.4787608038E-02, 5.9282621268E-02, 7.7935395737E-01],
	[3.3225000000E+04, 1.2092403226E+00, 1.6497693900E+00, 6.4816907337E-02, 5.9307815617E-02, 7.7938212290E-01],
	[3.3230000000E+04, 1.2095323234E+00, 1.6497392701E+00, 6.4846215475E-02, 5.9333016324E-02, 7.7941028783E-01],
	[3.3235000000E+04, 1.2098243508E+00, 1.6497091553E+00, 6.4875532453E-02, 5.9358223388E-02, 7.7943845218E-01],
	[3.3240000000E+04, 1.2101164048E+00, 1.6496790455E+00, 6.4904858272E-02, 5.9383436808E-02, 7.7946661594E-01],
	[3.3245000000E+04, 1.2104084853E+00, 1.6496489408E+00, 6.4934192932E-02, 5.9408656586E-02, 7.7949477912E-01],
	[3.3250000000E+04, 1.2107005924E+00, 1.6496188412E+00, 6.4963536437E-02, 5.9433882722E-02, 7.7952294170E-01],
	[3.3255000000E+04, 1.2109927260E+00, 1.6495887467E+00, 6.4992888787E-02, 5.9459115215E-02, 7.7955110369E-01],
	[3.3260000000E+04, 1.2112848862E+00, 1.6495586572E+00, 6.5022249983E-02, 5.9484354066E-02, 7.7957926509E-01],
	[3.3265000000E+04, 1.2115770730E+00, 1.6495285728E+00, 6.5051620026E-02, 5.9509599275E-02, 7.7960742590E-01],
	[3.3270000000E+04, 1.2118692863E+00, 1.6494984935E+00, 6.5080998919E-02, 5.9534850843E-02, 7.7963558611E-01],
	[3.3275000000E+04, 1.2121615261E+00, 1.6494684193E+00, 6.5110386662E-02, 5.9560108769E-02, 7.7966374573E-01],
	[3.3280000000E+04, 1.2124537925E+00, 1.6494383501E+00, 6.5139783256E-02, 5.9585373053E-02, 7.7969190475E-01],
	[3.3285000000E+04, 1.2127460854E+00, 1.6494082860E+00, 6.5169188704E-02, 5.9610643697E-02, 7.7972006317E-01],
	[3.3290000000E+04, 1.2130384049E+00, 1.6493782269E+00, 6.5198603006E-02, 5.9635920699E-02, 7.7974822099E-01],
	[3.3295000000E+04, 1.2133307509E+00, 1.6493481729E+00, 6.5228026164E-02, 5.9661204061E-02, 7.7977637822E-01],
	[3.3300000000E+04, 1.2136231235E+00, 1.6493181240E+00, 6.5257458178E-02, 5.9686493782E-02, 7.7980453484E-01],
	[3.3305000000E+04, 1.2139155226E+00, 1.6492880801E+00, 6.5286899051E-02, 5.9711789863E-02, 7.7983269086E-01],
	[3.3310000000E+04, 1.2142079482E+00, 1.6492580413E+00, 6.5316348784E-02, 5.9737092304E-02, 7.7986084627E-01],
	[3.3315000000E+04, 1.2145004004E+00, 1.6492280076E+00, 6.5345807378E-02, 5.9762401105E-02, 7.7988900108E-01],
	[3.3320000000E+04, 1.2147928791E+00, 1.6491979789E+00, 6.5375274834E-02, 5.9787716265E-02, 7.7991715529E-01],
	[3.3325000000E+04, 1.2150853844E+00, 1.6491679552E+00, 6.5404751154E-02, 5.9813037787E-02, 7.7994530888E-01],
	[3.3330000000E+04, 1.2153779162E+00, 1.6491379366E+00, 6.5434236338E-02, 5.9838365669E-02, 7.7997346187E-01],
	[3.3335000000E+04, 1.2156704745E+00, 1.6491079231E+00, 6.5463730390E-02, 5.9863699911E-02, 7.8000161425E-01],
	[3.3340000000E+04, 1.2159630593E+00, 1.6490779146E+00, 6.5493233308E-02, 5.9889040515E-02, 7.8002976602E-01],
	[3.3345000000E+04, 1.2162556707E+00, 1.6490479111E+00, 6.5522745096E-02, 5.9914387480E-02, 7.8005791718E-01],
	[3.3350000000E+04, 1.2165483086E+00, 1.6490179127E+00, 6.5552265755E-02, 5.9939740806E-02, 7.8008606772E-01],
	[3.3355000000E+04, 1.2168409730E+00, 1.6489879193E+00, 6.5581795285E-02, 5.9965100493E-02, 7.8011421765E-01],
	[3.3360000000E+04, 1.2171336639E+00, 1.6489579310E+00, 6.5611333688E-02, 5.9990466543E-02, 7.8014236697E-01],
	[3.3365000000E+04, 1.2174263814E+00, 1.6489279477E+00, 6.5640880965E-02, 6.0015838954E-02, 7.8017051567E-01],
	[3.3370000000E+04, 1.2177191253E+00, 1.6488979695E+00, 6.5670437118E-02, 6.0041217727E-02, 7.8019866375E-01],
	[3.3375000000E+04, 1.2180118958E+00, 1.6488679963E+00, 6.5700002149E-02, 6.0066602863E-02, 7.8022681121E-01],
	[3.3380000000E+04, 1.2183046929E+00, 1.6488380281E+00, 6.5729576057E-02, 6.0091994361E-02, 7.8025495805E-01],
	[3.3385000000E+04, 1.2185975164E+00, 1.6488080649E+00, 6.5759158846E-02, 6.0117392221E-02, 7.8028310428E-01],
	[3.3390000000E+04, 1.2188903664E+00, 1.6487781068E+00, 6.5788750515E-02, 6.0142796445E-02, 7.8031124988E-01],
	[3.3395000000E+04, 1.2191832430E+00, 1.6487481537E+00, 6.5818351067E-02, 6.0168207031E-02, 7.8033939486E-01],
	[3.3400000000E+04, 1.2194761460E+00, 1.6487182057E+00, 6.5847960502E-02, 6.0193623981E-02, 7.8036753921E-01],
	[3.3405000000E+04, 1.2197690756E+00, 1.6486882626E+00, 6.5877578823E-02, 6.0219047294E-02, 7.8039568294E-01],
	[3.3410000000E+04, 1.2200620317E+00, 1.6486583246E+00, 6.5907206030E-02, 6.0244476971E-02, 7.8042382604E-01],
	[3.3415000000E+04, 1.2203550143E+00, 1.6486283917E+00, 6.5936842125E-02, 6.0269913011E-02, 7.8045196852E-01],
	[3.3420000000E+04, 1.2206480233E+00, 1.6485984637E+00, 6.5966487108E-02, 6.0295355415E-02, 7.8048011036E-01],
	[3.3425000000E+04, 1.2209410589E+00, 1.6485685408E+00, 6.5996140983E-02, 6.0320804184E-02, 7.8050825158E-01],
	[3.3430000000E+04, 1.2212341210E+00, 1.6485386228E+00, 6.6025803749E-02, 6.0346259316E-02, 7.8053639216E-01],
	[3.3435000000E+04, 1.2215272096E+00, 1.6485087099E+00, 6.6055475408E-02, 6.0371720814E-02, 7.8056453212E-01],
	[3.3440000000E+04, 1.2218203247E+00, 1.6484788021E+00, 6.6085155961E-02, 6.0397188675E-02, 7.8059267144E-01],
	[3.3445000000E+04, 1.2221134663E+00, 1.6484488992E+00, 6.6114845410E-02, 6.0422662902E-02, 7.8062081012E-01],
	[3.3450000000E+04, 1.2224063427E+00, 1.6484199701E+00, 6.6144543757E-02, 6.0448144084E-02, 7.8064894817E-01],
	[3.3455000000E+04, 1.2226992318E+00, 1.6483910917E+00, 6.6174251001E-02, 6.0473631659E-02, 7.8067708559E-01],
	[3.3460000000E+04, 1.2229921473E+00, 1.6483622180E+00, 6.6203967146E-02, 6.0499125602E-02, 7.8070522236E-01],
	[3.3465000000E+04, 1.2232850892E+00, 1.6483333492E+00, 6.6233692191E-02, 6.0524625911E-02, 7.8073335850E-01],
	[3.3470000000E+04, 1.2235780575E+00, 1.6483044852E+00, 6.6263426140E-02, 6.0550132588E-02, 7.8076149400E-01],
	[3.3475000000E+04, 1.2238710521E+00, 1.6482756260E+00, 6.6293168991E-02, 6.0575645632E-02, 7.8078962885E-01],
	[3.3480000000E+04, 1.2241640732E+00, 1.6482467716E+00, 6.6322920748E-02, 6.0601165043E-02, 7.8081776307E-01],
	[3.3485000000E+04, 1.2244571206E+00, 1.6482179220E+00, 6.6352681412E-02, 6.0626690822E-02, 7.8084589664E-01],
	[3.3490000000E+04, 1.2247501944E+00, 1.6481890773E+00, 6.6382450983E-02, 6.0652222969E-02, 7.8087402956E-01],
	[3.3495000000E+04, 1.2250432946E+00, 1.6481602373E+00, 6.6412229463E-02, 6.0677761484E-02, 7.8090216184E-01],
	[3.3500000000E+04, 1.2253364211E+00, 1.6481314022E+00, 6.6442016853E-02, 6.0703306366E-02, 7.8093029348E-01],
	[3.3505000000E+04, 1.2256295741E+00, 1.6481025718E+00, 6.6471813156E-02, 6.0728857618E-02, 7.8095842446E-01],
	[3.3510000000E+04, 1.2259227534E+00, 1.6480737463E+00, 6.6501618371E-02, 6.0754415238E-02, 7.8098655480E-01],
	[3.3515000000E+04, 1.2262159591E+00, 1.6480449256E+00, 6.6531432501E-02, 6.0779979226E-02, 7.8101468449E-01],
	[3.3520000000E+04, 1.2265091911E+00, 1.6480161097E+00, 6.6561255547E-02, 6.0805549584E-02, 7.8104281352E-01],
	[3.3525000000E+04, 1.2268024495E+00, 1.6479872986E+00, 6.6591087510E-02, 6.0831126310E-02, 7.8107094191E-01],
	[3.3530000000E+04, 1.2270957343E+00, 1.6479584923E+00, 6.6620928392E-02, 6.0856709406E-02, 7.8109906964E-01],
	[3.3535000000E+04, 1.2273890455E+00, 1.6479296907E+00, 6.6650778193E-02, 6.0882298871E-02, 7.8112719671E-01],
	[3.3540000000E+04, 1.2276823830E+00, 1.6479008940E+00, 6.6680636915E-02, 6.0907894706E-02, 7.8115532313E-01],
	[3.3545000000E+04, 1.2279757469E+00, 1.6478721021E+00, 6.6710504560E-02, 6.0933496911E-02, 7.8118344889E-01],
	[3.3550000000E+04, 1.2282691371E+00, 1.6478433150E+00, 6.6740381128E-02, 6.0959105485E-02, 7.8121157400E-01],
	[3.3555000000E+04, 1.2285625538E+00, 1.6478145327E+00, 6.6770266622E-02, 6.0984720430E-02, 7.8123969844E-01],
	[3.3560000000E+04, 1.2288559967E+00, 1.6477857551E+00, 6.6800161042E-02, 6.1010341745E-02, 7.8126782223E-01],
	[3.3565000000E+04, 1.2291494661E+00, 1.6477569824E+00, 6.6830064390E-02, 6.1035969430E-02, 7.8129594535E-01],
	[3.3570000000E+04, 1.2294429617E+00, 1.6477282144E+00, 6.6859976668E-02, 6.1061603487E-02, 7.8132406781E-01],
	[3.3575000000E+04, 1.2297364838E+00, 1.6476994512E+00, 6.6889897875E-02, 6.1087243914E-02, 7.8135218961E-01],
	[3.3580000000E+04, 1.2300300322E+00, 1.6476706928E+00, 6.6919828015E-02, 6.1112890712E-02, 7.8138031074E-01],
	[3.3585000000E+04, 1.2303236069E+00, 1.6476419392E+00, 6.6949767087E-02, 6.1138543881E-02, 7.8140843121E-01],
	[3.3590000000E+04, 1.2306172080E+00, 1.6476131904E+00, 6.6979715094E-02, 6.1164203421E-02, 7.8143655101E-01],
	[3.3595000000E+04, 1.2309108354E+00, 1.6475844463E+00, 6.7009672037E-02, 6.1189869333E-02, 7.8146467014E-01],
	[3.3600000000E+04, 1.2312044892E+00, 1.6475557071E+00, 6.7039637917E-02, 6.1215541617E-02, 7.8149278860E-01],
	[3.3605000000E+04, 1.2314981694E+00, 1.6475269726E+00, 6.7069612736E-02, 6.1241220273E-02, 7.8152090640E-01],
	[3.3610000000E+04, 1.2317918758E+00, 1.6474982429E+00, 6.7099596494E-02, 6.1266905300E-02, 7.8154902352E-01],
	[3.3615000000E+04, 1.2320856086E+00, 1.6474695179E+00, 6.7129589194E-02, 6.1292596700E-02, 7.8157713997E-01],
	[3.3620000000E+04, 1.2323793678E+00, 1.6474407978E+00, 6.7159590836E-02, 6.1318294472E-02, 7.8160525574E-01],
	[3.3625000000E+04, 1.2326731533E+00, 1.6474120824E+00, 6.7189601422E-02, 6.1343998617E-02, 7.8163337084E-01],
	[3.3630000000E+04, 1.2329669651E+00, 1.6473833717E+00, 6.7219620953E-02, 6.1369709134E-02, 7.8166148527E-01],
	[3.3635000000E+04, 1.2332608033E+00, 1.6473546659E+00, 6.7249649431E-02, 6.1395426025E-02, 7.8168959901E-01],
	[3.3640000000E+04, 1.2335546678E+00, 1.6473259648E+00, 6.7279686856E-02, 6.1421149288E-02, 7.8171771208E-01],
	[3.3645000000E+04, 1.2338485586E+00, 1.6472972685E+00, 6.7309733231E-02, 6.1446878925E-02, 7.8174582447E-01],
	[3.3650000000E+04, 1.2341424758E+00, 1.6472685769E+00, 6.7339788556E-02, 6.1472614935E-02, 7.8177393618E-01],
	[3.3655000000E+04, 1.2344364193E+00, 1.6472398901E+00, 6.7369852833E-02, 6.1498357319E-02, 7.8180204721E-01],
	[3.3660000000E+04, 1.2347303891E+00, 1.6472112081E+00, 6.7399926063E-02, 6.1524106076E-02, 7.8183015756E-01],
	[3.3665000000E+04, 1.2350243853E+00, 1.6471825308E+00, 6.7430008248E-02, 6.1549861207E-02, 7.8185826722E-01],
	[3.3670000000E+04, 1.2353184078E+00, 1.6471538583E+00, 6.7460099388E-02, 6.1575622713E-02, 7.8188637620E-01],
	[3.3675000000E+04, 1.2356124565E+00, 1.6471251905E+00, 6.7490199486E-02, 6.1601390592E-02, 7.8191448449E-01],
	[3.3680000000E+04, 1.2359065317E+00, 1.6470965275E+00, 6.7520308542E-02, 6.1627164847E-02, 7.8194259209E-01],
	[3.3685000000E+04, 1.2362006331E+00, 1.6470678692E+00, 6.7550426558E-02, 6.1652945475E-02, 7.8197069901E-01],
	[3.3690000000E+04, 1.2364947609E+00, 1.6470392157E+00, 6.7580553536E-02, 6.1678732478E-02, 7.8199880524E-01],
	[3.3695000000E+04, 1.2367889149E+00, 1.6470105670E+00, 6.7610689476E-02, 6.1704525857E-02, 7.8202691077E-01],
	[3.3700000000E+04, 1.2370830953E+00, 1.6469819230E+00, 6.7640834379E-02, 6.1730325610E-02, 7.8205501562E-01],
	[3.3705000000E+04, 1.2373773020E+00, 1.6469532837E+00, 6.7670988248E-02, 6.1756131739E-02, 7.8208311977E-01],
	[3.3710000000E+04, 1.2376715351E+00, 1.6469246492E+00, 6.7701151084E-02, 6.1781944243E-02, 7.8211122323E-01],
	[3.3715000000E+04, 1.2379657944E+00, 1.6468960195E+00, 6.7731322887E-02, 6.1807763122E-02, 7.8213932599E-01],
	[3.3720000000E+04, 1.2382600800E+00, 1.6468673944E+00, 6.7761503660E-02, 6.1833588377E-02, 7.8216742806E-01],
	[3.3725000000E+04, 1.2385543920E+00, 1.6468387742E+00, 6.7791693403E-02, 6.1859420009E-02, 7.8219552943E-01],
	[3.3730000000E+04, 1.2388487302E+00, 1.6468101586E+00, 6.7821892118E-02, 6.1885258016E-02, 7.8222363011E-01],
	[3.3735000000E+04, 1.2391430948E+00, 1.6467815478E+00, 6.7852099807E-02, 6.1911102399E-02, 7.8225173008E-01],
	[3.3740000000E+04, 1.2394374856E+00, 1.6467529418E+00, 6.7882316470E-02, 6.1936953159E-02, 7.8227982936E-01],
	[3.3745000000E+04, 1.2397319028E+00, 1.6467243404E+00, 6.7912542108E-02, 6.1962810295E-02, 7.8230792793E-01],
	[3.3750000000E+04, 1.2400263463E+00, 1.6466957438E+00, 6.7942776724E-02, 6.1988673809E-02, 7.8233602580E-01],
	[3.3755000000E+04, 1.2403208160E+00, 1.6466671520E+00, 6.7973020319E-02, 6.2014543699E-02, 7.8236412296E-01],
	[3.3760000000E+04, 1.2406153121E+00, 1.6466385648E+00, 6.8003272893E-02, 6.2040419966E-02, 7.8239221943E-01],
	[3.3765000000E+04, 1.2409098344E+00, 1.6466099824E+00, 6.8033534449E-02, 6.2066302610E-02, 7.8242031518E-01],
	[3.3770000000E+04, 1.2412043831E+00, 1.6465814048E+00, 6.8063804987E-02, 6.2092191631E-02, 7.8244841023E-01],
	[3.3775000000E+04, 1.2414989580E+00, 1.6465528318E+00, 6.8094084510E-02, 6.2118087030E-02, 7.8247650457E-01],
	[3.3780000000E+04, 1.2417935592E+00, 1.6465242636E+00, 6.8124373017E-02, 6.2143988807E-02, 7.8250459820E-01],
	[3.3785000000E+04, 1.2420881868E+00, 1.6464957001E+00, 6.8154670511E-02, 6.2169896962E-02, 7.8253269112E-01],
	[3.3790000000E+04, 1.2423828406E+00, 1.6464671413E+00, 6.8184976993E-02, 6.2195811494E-02, 7.8256078333E-01],
	[3.3795000000E+04, 1.2426775207E+00, 1.6464385873E+00, 6.8215292464E-02, 6.2221732405E-02, 7.8258887483E-01],
	[3.3800000000E+04, 1.2429722270E+00, 1.6464100380E+00, 6.8245616926E-02, 6.2247659694E-02, 7.8261696561E-01],
	[3.3805000000E+04, 1.2432669597E+00, 1.6463814933E+00, 6.8275950380E-02, 6.2273593362E-02, 7.8264505568E-01],
	[3.3810000000E+04, 1.2435617186E+00, 1.6463529534E+00, 6.8306292827E-02, 6.2299533408E-02, 7.8267314504E-01],
	[3.3815000000E+04, 1.2438565038E+00, 1.6463244183E+00, 6.8336644268E-02, 6.2325479833E-02, 7.8270123367E-01],
	[3.3820000000E+04, 1.2441513153E+00, 1.6462958878E+00, 6.8367004706E-02, 6.2351432637E-02, 7.8272932159E-01],
	[3.3825000000E+04, 1.2444461531E+00, 1.6462673620E+00, 6.8397374140E-02, 6.2377391820E-02, 7.8275740879E-01],
	[3.3830000000E+04, 1.2447410172E+00, 1.6462388410E+00, 6.8427752574E-02, 6.2403357382E-02, 7.8278549527E-01],
	[3.3835000000E+04, 1.2450359075E+00, 1.6462103246E+00, 6.8458140007E-02, 6.2429329324E-02, 7.8281358103E-01],
	[3.3840000000E+04, 1.2453308241E+00, 1.6461818130E+00, 6.8488536442E-02, 6.2455307645E-02, 7.8284166606E-01],
	[3.3845000000E+04, 1.2456257670E+00, 1.6461533061E+00, 6.8518941879E-02, 6.2481292346E-02, 7.8286975037E-01],
	[3.3850000000E+04, 1.2459207361E+00, 1.6461248039E+00, 6.8549356320E-02, 6.2507283427E-02, 7.8289783396E-01],
	[3.3855000000E+04, 1.2462157315E+00, 1.6460963064E+00, 6.8579779767E-02, 6.2533280888E-02, 7.8292591682E-01],
	[3.3860000000E+04, 1.2465107532E+00, 1.6460678135E+00, 6.8610212220E-02, 6.2559284729E-02, 7.8295399896E-01],
	[3.3865000000E+04, 1.2468058011E+00, 1.6460393254E+00, 6.8640653681E-02, 6.2585294950E-02, 7.8298208037E-01],
	[3.3870000000E+04, 1.2471008753E+00, 1.6460108420E+00, 6.8671104151E-02, 6.2611311552E-02, 7.8301016104E-01],
	[3.3875000000E+04, 1.2473959758E+00, 1.6459823633E+00, 6.8701563632E-02, 6.2637334535E-02, 7.8303824099E-01],
	[3.3880000000E+04, 1.2476911025E+00, 1.6459538893E+00, 6.8732032125E-02, 6.2663363898E-02, 7.8306632021E-01],
	[3.3885000000E+04, 1.2479862555E+00, 1.6459254199E+00, 6.8762509631E-02, 6.2689399643E-02, 7.8309439869E-01],
	[3.3890000000E+04, 1.2482814347E+00, 1.6458969553E+00, 6.8792996152E-02, 6.2715441768E-02, 7.8312247645E-01],
	[3.3895000000E+04, 1.2485766402E+00, 1.6458684954E+00, 6.8823491688E-02, 6.2741490275E-02, 7.8315055346E-01],
	[3.3900000000E+04, 1.2488718719E+00, 1.6458400401E+00, 6.8853996243E-02, 6.2767545163E-02, 7.8317862974E-01],
	[3.3905000000E+04, 1.2491671299E+00, 1.6458115895E+00, 6.8884509815E-02, 6.2793606433E-02, 7.8320670529E-01],
	[3.3910000000E+04, 1.2494624142E+00, 1.6457831437E+00, 6.8915032408E-02, 6.2819674084E-02, 7.8323478010E-01],
	[3.3915000000E+04, 1.2497577247E+00, 1.6457547025E+00, 6.8945564022E-02, 6.2845748118E-02, 7.8326285416E-01],
	[3.3920000000E+04, 1.2500530614E+00, 1.6457262659E+00, 6.8976104659E-02, 6.2871828533E-02, 7.8329092749E-01],
	[3.3925000000E+04, 1.2503484244E+00, 1.6456978341E+00, 6.9006654319E-02, 6.2897915331E-02, 7.8331900008E-01],
	[3.3930000000E+04, 1.2506438136E+00, 1.6456694070E+00, 6.9037213005E-02, 6.2924008511E-02, 7.8334707193E-01],
	[3.3935000000E+04, 1.2509392291E+00, 1.6456409845E+00, 6.9067780718E-02, 6.2950108073E-02, 7.8337514303E-01],
	[3.3940000000E+04, 1.2512346708E+00, 1.6456125667E+00, 6.9098357459E-02, 6.2976214018E-02, 7.8340321339E-01],
	[3.3945000000E+04, 1.2515301388E+00, 1.6455841536E+00, 6.9128943229E-02, 6.3002326346E-02, 7.8343128300E-01],
	[3.3950000000E+04, 1.2518256330E+00, 1.6455557452E+00, 6.9159538029E-02, 6.3028445056E-02, 7.8345935186E-01],
	[3.3955000000E+04, 1.2521211534E+00, 1.6455273414E+00, 6.9190141862E-02, 6.3054570150E-02, 7.8348741998E-01],
	[3.3960000000E+04, 1.2524167001E+00, 1.6454989423E+00, 6.9220754728E-02, 6.3080701627E-02, 7.8351548735E-01],
	[3.3965000000E+04, 1.2527122730E+00, 1.6454705479E+00, 6.9251376628E-02, 6.3106839487E-02, 7.8354355397E-01],
	[3.3970000000E+04, 1.2530078721E+00, 1.6454421582E+00, 6.9282007565E-02, 6.3132983731E-02, 7.8357161984E-01],
	[3.3975000000E+04, 1.2533034975E+00, 1.6454137731E+00, 6.9312647539E-02, 6.3159134359E-02, 7.8359968496E-01],
	[3.3980000000E+04, 1.2535991491E+00, 1.6453853927E+00, 6.9343296552E-02, 6.3185291370E-02, 7.8362774932E-01],
	[3.3985000000E+04, 1.2538947078E+00, 1.6453572865E+00, 6.9373954604E-02, 6.3211454860E-02, 7.8365581293E-01],
	[3.3990000000E+04, 1.2541899711E+00, 1.6453299122E+00, 6.9404621698E-02, 6.3237624992E-02, 7.8368387579E-01],
	[3.3995000000E+04, 1.2544852606E+00, 1.6453025424E+00, 6.9435297835E-02, 6.3263801509E-02, 7.8371193789E-01],
	[3.4000000000E+04, 1.2547805762E+00, 1.6452751770E+00, 6.9465983016E-02, 6.3289984412E-02, 7.8373999923E-01],
	[3.4005000000E+04, 1.2550759178E+00, 1.6452478162E+00, 6.9496677242E-02, 6.3316173700E-02, 7.8376805981E-01],
	[3.4010000000E+04, 1.2553712855E+00, 1.6452204598E+00, 6.9527380514E-02, 6.3342369374E-02, 7.8379611964E-01],
	[3.4015000000E+04, 1.2556666793E+00, 1.6451931079E+00, 6.9558092835E-02, 6.3368571435E-02, 7.8382417870E-01],
	[3.4020000000E+04, 1.2559620992E+00, 1.6451657605E+00, 6.9588814205E-02, 6.3394779881E-02, 7.8385223700E-01],
	[3.4025000000E+04, 1.2562575451E+00, 1.6451384175E+00, 6.9619544626E-02, 6.3420994713E-02, 7.8388029454E-01],
	[3.4030000000E+04, 1.2565530171E+00, 1.6451110790E+00, 6.9650284099E-02, 6.3447215932E-02, 7.8390835132E-01],
	[3.4035000000E+04, 1.2568485152E+00, 1.6450837450E+00, 6.9681032625E-02, 6.3473443537E-02, 7.8393640733E-01],
	[3.4040000000E+04, 1.2571440393E+00, 1.6450564155E+00, 6.9711790206E-02, 6.3499677529E-02, 7.8396446257E-01],
	[3.4045000000E+04, 1.2574395895E+00, 1.6450290904E+00, 6.9742556843E-02, 6.3525917908E-02, 7.8399251705E-01],
	[3.4050000000E+04, 1.2577351658E+00, 1.6450017698E+00, 6.9773332538E-02, 6.3552164673E-02, 7.8402057076E-01],
	[3.4055000000E+04, 1.2580307681E+00, 1.6449744537E+00, 6.9804117291E-02, 6.3578417826E-02, 7.8404862370E-01],
	[3.4060000000E+04, 1.2583263965E+00, 1.6449471420E+00, 6.9834911104E-02, 6.3604677366E-02, 7.8407667586E-01],
	[3.4065000000E+04, 1.2586220510E+00, 1.6449198348E+00, 6.9865713979E-02, 6.3630943293E-02, 7.8410472726E-01],
	[3.4070000000E+04, 1.2589177315E+00, 1.6448925320E+00, 6.9896525916E-02, 6.3657215608E-02, 7.8413277789E-01],
	[3.4075000000E+04, 1.2592134381E+00, 1.6448652337E+00, 6.9927346917E-02, 6.3683494311E-02, 7.8416082774E-01],
	[3.4080000000E+04, 1.2595091707E+00, 1.6448379399E+00, 6.9958176984E-02, 6.3709779401E-02, 7.8418887682E-01],
	[3.4085000000E+04, 1.2598049294E+00, 1.6448106505E+00, 6.9989016117E-02, 6.3736070879E-02, 7.8421692512E-01],
	[3.4090000000E+04, 1.2601007141E+00, 1.6447833656E+00, 7.0019864319E-02, 6.3762368746E-02, 7.8424497264E-01],
	[3.4095000000E+04, 1.2603965249E+00, 1.6447560851E+00, 7.0050721590E-02, 6.3788673000E-02, 7.8427301939E-01],
	[3.4100000000E+04, 1.2606923617E+00, 1.6447288091E+00, 7.0081587931E-02, 6.3814983643E-02, 7.8430106536E-01],
	[3.4105000000E+04, 1.2609882246E+00, 1.6447015375E+00, 7.0112463345E-02, 6.3841300675E-02, 7.8432911054E-01],
	[3.4110000000E+04, 1.2612841135E+00, 1.6446742704E+00, 7.0143347832E-02, 6.3867624095E-02, 7.8435715495E-01],
	[3.4115000000E+04, 1.2615800285E+00, 1.6446470077E+00, 7.0174241394E-02, 6.3893953904E-02, 7.8438519857E-01],
	[3.4120000000E+04, 1.2618759695E+00, 1.6446197495E+00, 7.0205144032E-02, 6.3920290101E-02, 7.8441324141E-01],
	[3.4125000000E+04, 1.2621719366E+00, 1.6445924958E+00, 7.0236055747E-02, 6.3946632688E-02, 7.8444128347E-01],
	[3.4130000000E+04, 1.2624679297E+00, 1.6445652464E+00, 7.0266976541E-02, 6.3972981664E-02, 7.8446932474E-01],
	[3.4135000000E+04, 1.2627639488E+00, 1.6445380015E+00, 7.0297906416E-02, 6.3999337030E-02, 7.8449736523E-01],
	[3.4140000000E+04, 1.2630599940E+00, 1.6445107611E+00, 7.0328845371E-02, 6.4025698785E-02, 7.8452540492E-01],
	[3.4145000000E+04, 1.2633560652E+00, 1.6444835251E+00, 7.0359793410E-02, 6.4052066929E-02, 7.8455344383E-01],
	[3.4150000000E+04, 1.2636521625E+00, 1.6444562935E+00, 7.0390750532E-02, 6.4078441463E-02, 7.8458148195E-01],
	[3.4155000000E+04, 1.2639482858E+00, 1.6444290664E+00, 7.0421716740E-02, 6.4104822387E-02, 7.8460951928E-01],
	[3.4160000000E+04, 1.2642444351E+00, 1.6444018437E+00, 7.0452692035E-02, 6.4131209701E-02, 7.8463755581E-01],
	[3.4165000000E+04, 1.2645406104E+00, 1.6443746255E+00, 7.0483676417E-02, 6.4157603406E-02, 7.8466559156E-01],
	[3.4170000000E+04, 1.2648368118E+00, 1.6443474116E+00, 7.0514669890E-02, 6.4184003500E-02, 7.8469362651E-01],
	[3.4175000000E+04, 1.2651330392E+00, 1.6443202022E+00, 7.0545672453E-02, 6.4210409985E-02, 7.8472166066E-01],
	[3.4180000000E+04, 1.2654292926E+00, 1.6442929973E+00, 7.0576684108E-02, 6.4236822861E-02, 7.8474969402E-01],
	[3.4185000000E+04, 1.2657255721E+00, 1.6442657967E+00, 7.0607704856E-02, 6.4263242127E-02, 7.8477772658E-01],
	[3.4190000000E+04, 1.2660218775E+00, 1.6442386006E+00, 7.0638734700E-02, 6.4289667784E-02, 7.8480575834E-01],
	[3.4195000000E+04, 1.2663182090E+00, 1.6442114090E+00, 7.0669773639E-02, 6.4316099832E-02, 7.8483378930E-01],
	[3.4200000000E+04, 1.2666145665E+00, 1.6441842217E+00, 7.0700821676E-02, 6.4342538271E-02, 7.8486181946E-01],
	[3.4205000000E+04, 1.2669109500E+00, 1.6441570389E+00, 7.0731878812E-02, 6.4368983101E-02, 7.8488984883E-01],
	[3.4210000000E+04, 1.2672073596E+00, 1.6441298605E+00, 7.0762945048E-02, 6.4395434323E-02, 7.8491787738E-01],
	[3.4215000000E+04, 1.2675037951E+00, 1.6441026865E+00, 7.0794020385E-02, 6.4421891936E-02, 7.8494590514E-01],
	[3.4220000000E+04, 1.2678002567E+00, 1.6440755169E+00, 7.0825104825E-02, 6.4448355940E-02, 7.8497393209E-01],
	[3.4225000000E+04, 1.2680967443E+00, 1.6440483518E+00, 7.0856198369E-02, 6.4474826337E-02, 7.8500195823E-01],
	[3.4230000000E+04, 1.2683932579E+00, 1.6440211911E+00, 7.0887301019E-02, 6.4501303125E-02, 7.8502998357E-01],
	[3.4235000000E+04, 1.2686897975E+00, 1.6439940348E+00, 7.0918412775E-02, 6.4527786306E-02, 7.8505800810E-01],
	[3.4240000000E+04, 1.2689863631E+00, 1.6439668829E+00, 7.0949533640E-02, 6.4554275878E-02, 7.8508603182E-01],
	[3.4245000000E+04, 1.2692829547E+00, 1.6439397354E+00, 7.0980663614E-02, 6.4580771843E-02, 7.8511405473E-01],
	[3.4250000000E+04, 1.2695795723E+00, 1.6439125923E+00, 7.1011802699E-02, 6.4607274200E-02, 7.8514207683E-01],
	[3.4255000000E+04, 1.2698762159E+00, 1.6438854536E+00, 7.1042950896E-02, 6.4633782950E-02, 7.8517009811E-01],
	[3.4260000000E+04, 1.2701728856E+00, 1.6438583194E+00, 7.1074108206E-02, 6.4660298092E-02, 7.8519811859E-01],
	[3.4265000000E+04, 1.2704695812E+00, 1.6438311895E+00, 7.1105274632E-02, 6.4686819627E-02, 7.8522613825E-01],
	[3.4270000000E+04, 1.2707663028E+00, 1.6438040641E+00, 7.1136450173E-02, 6.4713347555E-02, 7.8525415709E-01],
	[3.4275000000E+04, 1.2710630504E+00, 1.6437769431E+00, 7.1167634832E-02, 6.4739881876E-02, 7.8528217512E-01],
	[3.4280000000E+04, 1.2713598240E+00, 1.6437498264E+00, 7.1198828610E-02, 6.4766422591E-02, 7.8531019233E-01],
	[3.4285000000E+04, 1.2716566236E+00, 1.6437227142E+00, 7.1230031508E-02, 6.4792969698E-02, 7.8533820872E-01],
	[3.4290000000E+04, 1.2719534492E+00, 1.6436956064E+00, 7.1261243527E-02, 6.4819523199E-02, 7.8536622429E-01],
	[3.4295000000E+04, 1.2722503008E+00, 1.6436685029E+00, 7.1292464670E-02, 6.4846083094E-02, 7.8539423904E-01],
	[3.4300000000E+04, 1.2725471784E+00, 1.6436414039E+00, 7.1323694936E-02, 6.4872649382E-02, 7.8542225297E-01],
	[3.4305000000E+04, 1.2728440819E+00, 1.6436143093E+00, 7.1354934328E-02, 6.4899222064E-02, 7.8545026608E-01],
	[3.4310000000E+04, 1.2731410115E+00, 1.6435872190E+00, 7.1386182847E-02, 6.4925801140E-02, 7.8547827836E-01],
	[3.4315000000E+04, 1.2734379670E+00, 1.6435601332E+00, 7.1417440494E-02, 6.4952386610E-02, 7.8550628981E-01],
	[3.4320000000E+04, 1.2737349485E+00, 1.6435330517E+00, 7.1448707271E-02, 6.4978978474E-02, 7.8553430045E-01],
	[3.4325000000E+04, 1.2740319560E+00, 1.6435059747E+00, 7.1479983178E-02, 6.5005576732E-02, 7.8556231025E-01],
	[3.4330000000E+04, 1.2743289895E+00, 1.6434789020E+00, 7.1511268218E-02, 6.5032181385E-02, 7.8559031923E-01],
	[3.4335000000E+04, 1.2746260489E+00, 1.6434518337E+00, 7.1542562391E-02, 6.5058792433E-02, 7.8561832737E-01],
	[3.4340000000E+04, 1.2749231344E+00, 1.6434247698E+00, 7.1573865699E-02, 6.5085409875E-02, 7.8564633469E-01],
	[3.4345000000E+04, 1.2752202458E+00, 1.6433977103E+00, 7.1605178143E-02, 6.5112033712E-02, 7.8567434117E-01],
	[3.4350000000E+04, 1.2755173832E+00, 1.6433706552E+00, 7.1636499724E-02, 6.5138663944E-02, 7.8570234683E-01],
	[3.4355000000E+04, 1.2758145465E+00, 1.6433436044E+00, 7.1667830445E-02, 6.5165300571E-02, 7.8573035165E-01],
	[3.4360000000E+04, 1.2761117358E+00, 1.6433165581E+00, 7.1699170306E-02, 6.5191943593E-02, 7.8575835563E-01],
	[3.4365000000E+04, 1.2764089511E+00, 1.6432895161E+00, 7.1730519308E-02, 6.5218593010E-02, 7.8578635878E-01],
	[3.4370000000E+04, 1.2767061924E+00, 1.6432624785E+00, 7.1761877453E-02, 6.5245248823E-02, 7.8581436109E-01],
	[3.4375000000E+04, 1.2770034596E+00, 1.6432354453E+00, 7.1793244742E-02, 6.5271911031E-02, 7.8584236257E-01],
	[3.4380000000E+04, 1.2773007528E+00, 1.6432084164E+00, 7.1824621177E-02, 6.5298579635E-02, 7.8587036321E-01],
	[3.4385000000E+04, 1.2775980719E+00, 1.6431813920E+00, 7.1856006759E-02, 6.5325254635E-02, 7.8589836300E-01],
	[3.4390000000E+04, 1.2778954170E+00, 1.6431543719E+00, 7.1887401489E-02, 6.5351936030E-02, 7.8592636196E-01],
	[3.4395000000E+04, 1.2781927881E+00, 1.6431273561E+00, 7.1918805368E-02, 6.5378623822E-02, 7.8595436007E-01],
	[3.4400000000E+04, 1.2784901851E+00, 1.6431003448E+00, 7.1950218399E-02, 6.5405318010E-02, 7.8598235734E-01],
	[3.4405000000E+04, 1.2787876081E+00, 1.6430733378E+00, 7.1981640581E-02, 6.5432018593E-02, 7.8601035377E-01],
	[3.4410000000E+04, 1.2790850571E+00, 1.6430463352E+00, 7.2013071918E-02, 6.5458725574E-02, 7.8603834935E-01],
	[3.4415000000E+04, 1.2793825320E+00, 1.6430193369E+00, 7.2044512409E-02, 6.5485438951E-02, 7.8606634409E-01],
	[3.4420000000E+04, 1.2796800328E+00, 1.6429923431E+00, 7.2075962056E-02, 6.5512158724E-02, 7.8609433798E-01],
	[3.4425000000E+04, 1.2799775596E+00, 1.6429653535E+00, 7.2107420861E-02, 6.5538884894E-02, 7.8612233102E-01],
	[3.4430000000E+04, 1.2802751124E+00, 1.6429383684E+00, 7.2138888825E-02, 6.5565617461E-02, 7.8615032321E-01],
	[3.4435000000E+04, 1.2805726911E+00, 1.6429113876E+00, 7.2170365949E-02, 6.5592356425E-02, 7.8617831455E-01],
	[3.4440000000E+04, 1.2808702957E+00, 1.6428844111E+00, 7.2201852234E-02, 6.5619101786E-02, 7.8620630504E-01],
	[3.4445000000E+04, 1.2811679263E+00, 1.6428574391E+00, 7.2233347683E-02, 6.5645853544E-02, 7.8623429468E-01],
	[3.4450000000E+04, 1.2814655829E+00, 1.6428304714E+00, 7.2264852296E-02, 6.5672611700E-02, 7.8626228346E-01],
	[3.4455000000E+04, 1.2817632653E+00, 1.6428035080E+00, 7.2296366074E-02, 6.5699376253E-02, 7.8629027139E-01],
	[3.4460000000E+04, 1.2820609738E+00, 1.6427765490E+00, 7.2327889019E-02, 6.5726147203E-02, 7.8631825846E-01],
	[3.4465000000E+04, 1.2823587081E+00, 1.6427495943E+00, 7.2359421133E-02, 6.5752924551E-02, 7.8634624468E-01],
	[3.4470000000E+04, 1.2826564684E+00, 1.6427226440E+00, 7.2390962416E-02, 6.5779708297E-02, 7.8637423004E-01],
	[3.4475000000E+04, 1.2829542546E+00, 1.6426956981E+00, 7.2422512870E-02, 6.5806498441E-02, 7.8640221454E-01],
	[3.4480000000E+04, 1.2832520668E+00, 1.6426687565E+00, 7.2454072496E-02, 6.5833294983E-02, 7.8643019818E-01],
	[3.4485000000E+04, 1.2835499049E+00, 1.6426418192E+00, 7.2485641296E-02, 6.5860097923E-02, 7.8645818096E-01],
	[3.4490000000E+04, 1.2838477689E+00, 1.6426148863E+00, 7.2517219271E-02, 6.5886907261E-02, 7.8648616288E-01],
	[3.4495000000E+04, 1.2841456589E+00, 1.6425879578E+00, 7.2548806422E-02, 6.5913722997E-02, 7.8651414393E-01],
	[3.4500000000E+04, 1.2844435748E+00, 1.6425610336E+00, 7.2580402750E-02, 6.5940545132E-02, 7.8654212412E-01],
	[3.4505000000E+04, 1.2847415166E+00, 1.6425341137E+00, 7.2612008258E-02, 6.5967373666E-02, 7.8657010345E-01],
	[3.4510000000E+04, 1.2850394843E+00, 1.6425071982E+00, 7.2643622946E-02, 6.5994208598E-02, 7.8659808191E-01],
	[3.4515000000E+04, 1.2853374780E+00, 1.6424802870E+00, 7.2675246815E-02, 6.6021049929E-02, 7.8662605950E-01],
	[3.4520000000E+04, 1.2856354976E+00, 1.6424533801E+00, 7.2706879868E-02, 6.6047897658E-02, 7.8665403623E-01],
	[3.4525000000E+04, 1.2859335431E+00, 1.6424264776E+00, 7.2738522105E-02, 6.6074751787E-02, 7.8668201209E-01],
	[3.4530000000E+04, 1.2862316145E+00, 1.6423995794E+00, 7.2770173527E-02, 6.6101612315E-02, 7.8670998707E-01],
	[3.4535000000E+04, 1.2865292190E+00, 1.6423735204E+00, 7.2801834136E-02, 6.6128479293E-02, 7.8673796119E-01],
	[3.4540000000E+04, 1.2868267639E+00, 1.6423476103E+00, 7.2833503934E-02, 6.6155352681E-02, 7.8676593443E-01],
	[3.4545000000E+04, 1.2871243345E+00, 1.6423217043E+00, 7.2865182921E-02, 6.6182232469E-02, 7.8679390680E-01],
	[3.4550000000E+04, 1.2874219308E+00, 1.6422958024E+00, 7.2896871099E-02, 6.6209118657E-02, 7.8682187829E-01],
	[3.4555000000E+04, 1.2877195528E+00, 1.6422699047E+00, 7.2928568470E-02, 6.6236011246E-02, 7.8684984891E-01],
	[3.4560000000E+04, 1.2880172006E+00, 1.6422440112E+00, 7.2960275034E-02, 6.6262910235E-02, 7.8687781865E-01],
	[3.4565000000E+04, 1.2883148741E+00, 1.6422181218E+00, 7.2991990793E-02, 6.6289815625E-02, 7.8690578752E-01],
	[3.4570000000E+04, 1.2886125733E+00, 1.6421922366E+00, 7.3023715748E-02, 6.6316727416E-02, 7.8693375550E-01],
	[3.4575000000E+04, 1.2889102982E+00, 1.6421663556E+00, 7.3055449901E-02, 6.6343645608E-02, 7.8696172261E-01],
	[3.4580000000E+04, 1.2892080489E+00, 1.6421404786E+00, 7.3087193253E-02, 6.6370570200E-02, 7.8698968884E-01],
	[3.4585000000E+04, 1.2895058253E+00, 1.6421146059E+00, 7.3118945806E-02, 6.6397501195E-02, 7.8701765418E-01],
	[3.4590000000E+04, 1.2898036274E+00, 1.6420887372E+00, 7.3150707560E-02, 6.6424438590E-02, 7.8704561864E-01],
	[3.4595000000E+04, 1.2901014552E+00, 1.6420628728E+00, 7.3182478517E-02, 6.6451382387E-02, 7.8707358222E-01],
	[3.4600000000E+04, 1.2903993087E+00, 1.6420370124E+00, 7.3214258678E-02, 6.6478332585E-02, 7.8710154492E-01],
	[3.4605000000E+04, 1.2906971880E+00, 1.6420111562E+00, 7.3246048045E-02, 6.6505289185E-02, 7.8712950672E-01],
	[3.4610000000E+04, 1.2909950929E+00, 1.6419853042E+00, 7.3277846619E-02, 6.6532252186E-02, 7.8715746764E-01],
	[3.4615000000E+04, 1.2912930236E+00, 1.6419594563E+00, 7.3309654401E-02, 6.6559221589E-02, 7.8718542768E-01],
	[3.4620000000E+04, 1.2915909800E+00, 1.6419336125E+00, 7.3341471393E-02, 6.6586197395E-02, 7.8721338682E-01],
	[3.4625000000E+04, 1.2918889620E+00, 1.6419077729E+00, 7.3373297596E-02, 6.6613179602E-02, 7.8724134507E-01],
	[3.4630000000E+04, 1.2921869698E+00, 1.6418819374E+00, 7.3405133011E-02, 6.6640168211E-02, 7.8726930244E-01],
	[3.4635000000E+04, 1.2924850033E+00, 1.6418561061E+00, 7.3436977640E-02, 6.6667163223E-02, 7.8729725891E-01],
	[3.4640000000E+04, 1.2927830625E+00, 1.6418302788E+00, 7.3468831484E-02, 6.6694164637E-02, 7.8732521449E-01],
	[3.4645000000E+04, 1.2930811474E+00, 1.6418044558E+00, 7.3500694544E-02, 6.6721172453E-02, 7.8735316917E-01],
	[3.4650000000E+04, 1.2933792580E+00, 1.6417786368E+00, 7.3532566822E-02, 6.6748186672E-02, 7.8738112296E-01],
	[3.4655000000E+04, 1.2936773943E+00, 1.6417528220E+00, 7.3564448319E-02, 6.6775207294E-02, 7.8740907585E-01],
	[3.4660000000E+04, 1.2939755563E+00, 1.6417270113E+00, 7.3596339037E-02, 6.6802234318E-02, 7.8743702785E-01],
	[3.4665000000E+04, 1.2942737439E+00, 1.6417012047E+00, 7.3628238976E-02, 6.6829267745E-02, 7.8746497894E-01],
	[3.4670000000E+04, 1.2945719573E+00, 1.6416754023E+00, 7.3660148138E-02, 6.6856307575E-02, 7.8749292914E-01],
	[3.4675000000E+04, 1.2948701964E+00, 1.6416496040E+00, 7.3692066524E-02, 6.6883353808E-02, 7.8752087844E-01],
	[3.4680000000E+04, 1.2951684611E+00, 1.6416238098E+00, 7.3723994136E-02, 6.6910406445E-02, 7.8754882683E-01],
	[3.4685000000E+04, 1.2954667516E+00, 1.6415980198E+00, 7.3755930975E-02, 6.6937465484E-02, 7.8757677433E-01],
	[3.4690000000E+04, 1.2957650677E+00, 1.6415722338E+00, 7.3787877043E-02, 6.6964530927E-02, 7.8760472092E-01],
	[3.4695000000E+04, 1.2960634095E+00, 1.6415464520E+00, 7.3819832340E-02, 6.6991602773E-02, 7.8763266660E-01],
	[3.4700000000E+04, 1.2963617770E+00, 1.6415206743E+00, 7.3851796868E-02, 6.7018681023E-02, 7.8766061138E-01],
	[3.4705000000E+04, 1.2966601702E+00, 1.6414949008E+00, 7.3883770629E-02, 6.7045765677E-02, 7.8768855526E-01],
	[3.4710000000E+04, 1.2969585891E+00, 1.6414691313E+00, 7.3915753623E-02, 6.7072856734E-02, 7.8771649822E-01],
	[3.4715000000E+04, 1.2972570337E+00, 1.6414433660E+00, 7.3947745853E-02, 6.7099954196E-02, 7.8774444028E-01],
	[3.4720000000E+04, 1.2975555039E+00, 1.6414176047E+00, 7.3979747319E-02, 6.7127058061E-02, 7.8777238143E-01],
	[3.4725000000E+04, 1.2978539998E+00, 1.6413918476E+00, 7.4011758022E-02, 6.7154168330E-02, 7.8780032167E-01],
	[3.4730000000E+04, 1.2981525214E+00, 1.6413660946E+00, 7.4043777965E-02, 6.7181285003E-02, 7.8782826099E-01],
	[3.4735000000E+04, 1.2984510686E+00, 1.6413403457E+00, 7.4075807147E-02, 6.7208408081E-02, 7.8785619940E-01],
	[3.4740000000E+04, 1.2987496416E+00, 1.6413146010E+00, 7.4107845572E-02, 6.7235537563E-02, 7.8788413690E-01],
	[3.4745000000E+04, 1.2990482402E+00, 1.6412888603E+00, 7.4139893240E-02, 6.7262673449E-02, 7.8791207349E-01],
	[3.4750000000E+04, 1.2993468644E+00, 1.6412631237E+00, 7.4171950152E-02, 6.7289815740E-02, 7.8794000916E-01],
	[3.4755000000E+04, 1.2996455144E+00, 1.6412373913E+00, 7.4204016310E-02, 6.7316964436E-02, 7.8796794391E-01],
	[3.4760000000E+04, 1.2999441900E+00, 1.6412116629E+00, 7.4236091715E-02, 6.7344119536E-02, 7.8799587774E-01],
	[3.4765000000E+04, 1.3002428912E+00, 1.6411859387E+00, 7.4268176368E-02, 6.7371281041E-02, 7.8802381066E-01],
	[3.4770000000E+04, 1.3005416182E+00, 1.6411602186E+00, 7.4300270271E-02, 6.7398448951E-02, 7.8805174266E-01],
	[3.4775000000E+04, 1.3008403708E+00, 1.6411345025E+00, 7.4332373425E-02, 6.7425623267E-02, 7.8807967373E-01],
	[3.4780000000E+04, 1.3011391490E+00, 1.6411087906E+00, 7.4364485832E-02, 6.7452803987E-02, 7.8810760388E-01],
	[3.4785000000E+04, 1.3014379529E+00, 1.6410830827E+00, 7.4396607492E-02, 6.7479991112E-02, 7.8813553311E-01],
	[3.4790000000E+04, 1.3017367825E+00, 1.6410573790E+00, 7.4428738408E-02, 6.7507184643E-02, 7.8816346142E-01],
	[3.4795000000E+04, 1.3020356377E+00, 1.6410316793E+00, 7.4460878579E-02, 6.7534384579E-02, 7.8819138880E-01],
	[3.4800000000E+04, 1.3023345186E+00, 1.6410059838E+00, 7.4493028009E-02, 6.7561590921E-02, 7.8821931526E-01],
	[3.4805000000E+04, 1.3026334252E+00, 1.6409802923E+00, 7.4525186698E-02, 6.7588803668E-02, 7.8824724078E-01],
	[3.4810000000E+04, 1.3029323574E+00, 1.6409546050E+00, 7.4557354647E-02, 6.7616022821E-02, 7.8827516538E-01],
	[3.4815000000E+04, 1.3032313152E+00, 1.6409289217E+00, 7.4589531858E-02, 6.7643248379E-02, 7.8830308905E-01],
	[3.4820000000E+04, 1.3035302987E+00, 1.6409032425E+00, 7.4621718332E-02, 6.7670480344E-02, 7.8833101180E-01],
	[3.4825000000E+04, 1.3038293078E+00, 1.6408775674E+00, 7.4653914070E-02, 6.7697718714E-02, 7.8835893361E-01],
	[3.4830000000E+04, 1.3041283426E+00, 1.6408518964E+00, 7.4686119074E-02, 6.7724963491E-02, 7.8838685448E-01],
	[3.4835000000E+04, 1.3044274030E+00, 1.6408262295E+00, 7.4718333346E-02, 6.7752214674E-02, 7.8841477443E-01],
	[3.4840000000E+04, 1.3047264891E+00, 1.6408005666E+00, 7.4750556885E-02, 6.7779472263E-02, 7.8844269344E-01],
	[3.4845000000E+04, 1.3050256008E+00, 1.6407749079E+00, 7.4782789695E-02, 6.7806736258E-02, 7.8847061151E-01],
	[3.4850000000E+04, 1.3053247382E+00, 1.6407492532E+00, 7.4815031776E-02, 6.7834006659E-02, 7.8849852865E-01],
	[3.4855000000E+04, 1.3056239012E+00, 1.6407236026E+00, 7.4847283129E-02, 6.7861283467E-02, 7.8852644485E-01],
	[3.4860000000E+04, 1.3059230898E+00, 1.6406979561E+00, 7.4879543756E-02, 6.7888566682E-02, 7.8855436012E-01],
	[3.4865000000E+04, 1.3062223041E+00, 1.6406723137E+00, 7.4911813658E-02, 6.7915856304E-02, 7.8858227445E-01],
	[3.4870000000E+04, 1.3065215440E+00, 1.6406466753E+00, 7.4944092836E-02, 6.7943152332E-02, 7.8861018784E-01],
	[3.4875000000E+04, 1.3068208095E+00, 1.6406210411E+00, 7.4976381292E-02, 6.7970454767E-02, 7.8863810029E-01],
	[3.4880000000E+04, 1.3071201007E+00, 1.6405954109E+00, 7.5008679028E-02, 6.7997763609E-02, 7.8866601180E-01],
	[3.4885000000E+04, 1.3074194175E+00, 1.6405697847E+00, 7.5040986044E-02, 6.8025078857E-02, 7.8869392237E-01],
	[3.4890000000E+04, 1.3077187599E+00, 1.6405441627E+00, 7.5073302341E-02, 6.8052400514E-02, 7.8872183200E-01],
	[3.4895000000E+04, 1.3080181279E+00, 1.6405185447E+00, 7.5105627922E-02, 6.8079728577E-02, 7.8874974068E-01],
	[3.4900000000E+04, 1.3083175216E+00, 1.6404929308E+00, 7.5137962787E-02, 6.8107063047E-02, 7.8877764842E-01],
	[3.4905000000E+04, 1.3086169409E+00, 1.6404673209E+00, 7.5170306938E-02, 6.8134403925E-02, 7.8880555522E-01],
	[3.4910000000E+04, 1.3089163858E+00, 1.6404417152E+00, 7.5202660377E-02, 6.8161751211E-02, 7.8883346107E-01],
	[3.4915000000E+04, 1.3092158564E+00, 1.6404161135E+00, 7.5235023103E-02, 6.8189104904E-02, 7.8886136597E-01],
	[3.4920000000E+04, 1.3095153525E+00, 1.6403905158E+00, 7.5267395120E-02, 6.8216465004E-02, 7.8888926993E-01],
	[3.4925000000E+04, 1.3098148743E+00, 1.6403649222E+00, 7.5299776428E-02, 6.8243831512E-02, 7.8891717294E-01],
	[3.4930000000E+04, 1.3101144217E+00, 1.6403393327E+00, 7.5332167028E-02, 6.8271204428E-02, 7.8894507499E-01],
	[3.4935000000E+04, 1.3104139947E+00, 1.6403137473E+00, 7.5364566922E-02, 6.8298583752E-02, 7.8897297610E-01],
	[3.4940000000E+04, 1.3107135933E+00, 1.6402881659E+00, 7.5396976111E-02, 6.8325969484E-02, 7.8900087625E-01],
	[3.4945000000E+04, 1.3110132176E+00, 1.6402625886E+00, 7.5429394597E-02, 6.8353361624E-02, 7.8902877545E-01],
	[3.4950000000E+04, 1.3113128674E+00, 1.6402370153E+00, 7.5461822380E-02, 6.8380760172E-02, 7.8905667369E-01],
	[3.4955000000E+04, 1.3116125429E+00, 1.6402114461E+00, 7.5494259463E-02, 6.8408165129E-02, 7.8908457098E-01],
	[3.4960000000E+04, 1.3119122439E+00, 1.6401858809E+00, 7.5526705846E-02, 6.8435576493E-02, 7.8911246731E-01],
	[3.4965000000E+04, 1.3122119706E+00, 1.6401603198E+00, 7.5559161531E-02, 6.8462994266E-02, 7.8914036268E-01],
	[3.4970000000E+04, 1.3125117229E+00, 1.6401347627E+00, 7.5591626519E-02, 6.8490418448E-02, 7.8916825710E-01],
	[3.4975000000E+04, 1.3128115007E+00, 1.6401092097E+00, 7.5624100812E-02, 6.8517849038E-02, 7.8919615055E-01],
	[3.4980000000E+04, 1.3131113042E+00, 1.6400836608E+00, 7.5656584411E-02, 6.8545286037E-02, 7.8922404305E-01],
	[3.4985000000E+04, 1.3134111333E+00, 1.6400581159E+00, 7.5689077317E-02, 6.8572729444E-02, 7.8925193458E-01],
	[3.4990000000E+04, 1.3137109880E+00, 1.6400325750E+00, 7.5721579531E-02, 6.8600179260E-02, 7.8927982515E-01],
	[3.4995000000E+04, 1.3140108682E+00, 1.6400070382E+00, 7.5754091055E-02, 6.8627635485E-02, 7.8930771476E-01],
	[3.5000000000E+04, 1.3143107741E+00, 1.6399815055E+00, 7.5786611890E-02, 6.8655098119E-02, 7.8933560340E-01],
	[3.5005000000E+04, 1.3146107056E+00, 1.6399559768E+00, 7.5819413521E-02, 6.8682789942E-02, 7.8936349108E-01],
	[3.5010000000E+04, 1.3149106626E+00, 1.6399304521E+00, 7.5852224660E-02, 6.8710488309E-02, 7.8939137778E-01],
	[3.5015000000E+04, 1.3152106453E+00, 1.6399049314E+00, 7.5885045310E-02, 6.8738193219E-02, 7.8941926352E-01],
	[3.5020000000E+04, 1.3155106535E+00, 1.6398794149E+00, 7.5917875472E-02, 6.8765904672E-02, 7.8944714830E-01],
	[3.5025000000E+04, 1.3158106873E+00, 1.6398539023E+00, 7.5950715147E-02, 6.8793622669E-02, 7.8947503210E-01],
	[3.5030000000E+04, 1.3161107467E+00, 1.6398283938E+00, 7.5983564337E-02, 6.8821347209E-02, 7.8950291493E-01],
	[3.5035000000E+04, 1.3164108317E+00, 1.6398028893E+00, 7.6016423043E-02, 6.8849078293E-02, 7.8953079678E-01],
	[3.5040000000E+04, 1.3167109423E+00, 1.6397773889E+00, 7.6049291266E-02, 6.8876815920E-02, 7.8955867767E-01],
	[3.5045000000E+04, 1.3170110785E+00, 1.6397518925E+00, 7.6082169008E-02, 6.8904560092E-02, 7.8958655758E-01],
	[3.5050000000E+04, 1.3173112402E+00, 1.6397264001E+00, 7.6115056270E-02, 6.8932310807E-02, 7.8961443651E-01],
	[3.5055000000E+04, 1.3176114276E+00, 1.6397009118E+00, 7.6147953054E-02, 6.8960068067E-02, 7.8964231447E-01],
	[3.5060000000E+04, 1.3179116405E+00, 1.6396754275E+00, 7.6180859361E-02, 6.8987831871E-02, 7.8967019145E-01],
	[3.5065000000E+04, 1.3182118789E+00, 1.6396499472E+00, 7.6213775193E-02, 6.9015602218E-02, 7.8969806745E-01],
	[3.5070000000E+04, 1.3185121430E+00, 1.6396244710E+00, 7.6246700550E-02, 6.9043379110E-02, 7.8972594248E-01],
	[3.5075000000E+04, 1.3188124326E+00, 1.6395989987E+00, 7.6279635435E-02, 6.9071162547E-02, 7.8975381652E-01],
	[3.5080000000E+04, 1.3191127478E+00, 1.6395735306E+00, 7.6312579848E-02, 6.9098952528E-02, 7.8978168958E-01],
	[3.5085000000E+04, 1.3194130886E+00, 1.6395480664E+00, 7.6345533792E-02, 6.9126749054E-02, 7.8980956166E-01],
	[3.5090000000E+04, 1.3197130228E+00, 1.6395232542E+00, 7.6378497266E-02, 6.9154552090E-02, 7.8983743275E-01],
	[3.5095000000E+04, 1.3200127721E+00, 1.6394987611E+00, 7.6411470274E-02, 6.9182361656E-02, 7.8986530286E-01],
	[3.5100000000E+04, 1.3203125469E+00, 1.6394742718E+00, 7.6444452816E-02, 6.9210177767E-02, 7.8989317198E-01],
	[3.5105000000E+04, 1.3206123470E+00, 1.6394497864E+00, 7.6477444893E-02, 6.9238000423E-02, 7.8992104012E-01],
	[3.5110000000E+04, 1.3209121724E+00, 1.6394253048E+00, 7.6510446508E-02, 6.9265829626E-02, 7.8994890727E-01],
	[3.5115000000E+04, 1.3212120232E+00, 1.6394008271E+00, 7.6543457661E-02, 6.9293665374E-02, 7.8997677343E-01],
	[3.5120000000E+04, 1.3215118994E+00, 1.6393763532E+00, 7.6576478354E-02, 6.9321507669E-02, 7.9000463860E-01],
	[3.5125000000E+04, 1.3218118009E+00, 1.6393518832E+00, 7.6609508588E-02, 6.9349356510E-02, 7.9003250278E-01],
	[3.5130000000E+04, 1.3221117278E+00, 1.6393274170E+00, 7.6642548364E-02, 6.9377211896E-02, 7.9006036597E-01],
	[3.5135000000E+04, 1.3224116801E+00, 1.6393029547E+00, 7.6675597685E-02, 6.9405073829E-02, 7.9008822816E-01],
	[3.5140000000E+04, 1.3227116577E+00, 1.6392784963E+00, 7.6708656551E-02, 6.9432942309E-02, 7.9011608936E-01],
	[3.5145000000E+04, 1.3230116606E+00, 1.6392540416E+00, 7.6741724964E-02, 6.9460817335E-02, 7.9014394957E-01],
	[3.5150000000E+04, 1.3233116889E+00, 1.6392295908E+00, 7.6774802925E-02, 6.9488698907E-02, 7.9017180878E-01],
	[3.5155000000E+04, 1.3236117426E+00, 1.6392051439E+00, 7.6807890436E-02, 6.9516587026E-02, 7.9019966699E-01],
	[3.5160000000E+04, 1.3239118216E+00, 1.6391807008E+00, 7.6840987497E-02, 6.9544481692E-02, 7.9022752420E-01],
	[3.5165000000E+04, 1.3242119259E+00, 1.6391562615E+00, 7.6874094112E-02, 6.9572382905E-02, 7.9025538042E-01],
	[3.5170000000E+04, 1.3245120556E+00, 1.6391318261E+00, 7.6907210280E-02, 6.9600290664E-02, 7.9028323563E-01],
	[3.5175000000E+04, 1.3248122106E+00, 1.6391073945E+00, 7.6940336003E-02, 6.9628204970E-02, 7.9031108985E-01],
	[3.5180000000E+04, 1.3251123910E+00, 1.6390829668E+00, 7.6973471283E-02, 6.9656125824E-02, 7.9033894306E-01],
	[3.5185000000E+04, 1.3254125967E+00, 1.6390585429E+00, 7.7006616120E-02, 6.9684053225E-02, 7.9036679527E-01],
	[3.5190000000E+04, 1.3257128278E+00, 1.6390341228E+00, 7.7039770518E-02, 6.9711987172E-02, 7.9039464647E-01],
	[3.5195000000E+04, 1.3260130842E+00, 1.6390097066E+00, 7.7072934476E-02, 6.9739927668E-02, 7.9042249667E-01],
	[3.5200000000E+04, 1.3263133659E+00, 1.6389852942E+00, 7.7106107996E-02, 6.9767874710E-02, 7.9045034586E-01],
	[3.5205000000E+04, 1.3266136730E+00, 1.6389608856E+00, 7.7139291080E-02, 6.9795828300E-02, 7.9047819404E-01],
	[3.5210000000E+04, 1.3269140054E+00, 1.6389364808E+00, 7.7172483728E-02, 6.9823788438E-02, 7.9050604122E-01],
	[3.5215000000E+04, 1.3272143631E+00, 1.6389120799E+00, 7.7205685944E-02, 6.9851755123E-02, 7.9053388739E-01],
	[3.5220000000E+04, 1.3275147462E+00, 1.6388876828E+00, 7.7238897727E-02, 6.9879728357E-02, 7.9056173254E-01],
	[3.5225000000E+04, 1.3278151546E+00, 1.6388632895E+00, 7.7272119079E-02, 6.9907708137E-02, 7.9058957669E-01],
	[3.5230000000E+04, 1.3281155883E+00, 1.6388389001E+00, 7.7305350002E-02, 6.9935694466E-02, 7.9061741982E-01],
	[3.5235000000E+04, 1.3284160474E+00, 1.6388145145E+00, 7.7338590496E-02, 6.9963687343E-02, 7.9064526194E-01],
	[3.5240000000E+04, 1.3287165317E+00, 1.6387901327E+00, 7.7371840565E-02, 6.9991686768E-02, 7.9067310304E-01],
	[3.5245000000E+04, 1.3290170414E+00, 1.6387657547E+00, 7.7405100208E-02, 7.0019692741E-02, 7.9070094313E-01],
	[3.5250000000E+04, 1.3293175765E+00, 1.6387413806E+00, 7.7438369427E-02, 7.0047705262E-02, 7.9072878220E-01],
	[3.5255000000E+04, 1.3296181368E+00, 1.6387170102E+00, 7.7471648223E-02, 7.0075724332E-02, 7.9075662025E-01],
	[3.5260000000E+04, 1.3299187225E+00, 1.6386926437E+00, 7.7504936599E-02, 7.0103749950E-02, 7.9078445729E-01],
	[3.5265000000E+04, 1.3302193334E+00, 1.6386682810E+00, 7.7538234555E-02, 7.0131782116E-02, 7.9081229330E-01],
	[3.5270000000E+04, 1.3305199697E+00, 1.6386439221E+00, 7.7571542093E-02, 7.0159820831E-02, 7.9084012830E-01],
	[3.5275000000E+04, 1.3308206313E+00, 1.6386195671E+00, 7.7604859214E-02, 7.0187866095E-02, 7.9086796227E-01],
	[3.5280000000E+04, 1.3311213183E+00, 1.6385952158E+00, 7.7638185920E-02, 7.0215917907E-02, 7.9089579522E-01],
	[3.5285000000E+04, 1.3314220305E+00, 1.6385708684E+00, 7.7671522211E-02, 7.0243976268E-02, 7.9092362715E-01],
	[3.5290000000E+04, 1.3317227680E+00, 1.6385465247E+00, 7.7704868090E-02, 7.0272041178E-02, 7.9095145805E-01],
	[3.5295000000E+04, 1.3320235309E+00, 1.6385221849E+00, 7.7738223558E-02, 7.0300112637E-02, 7.9097928793E-01],
	[3.5300000000E+04, 1.3323243190E+00, 1.6384978489E+00, 7.7771588616E-02, 7.0328190645E-02, 7.9100711678E-01],
	[3.5305000000E+04, 1.3326251325E+00, 1.6384735167E+00, 7.7804963265E-02, 7.0356275202E-02, 7.9103494460E-01],
	[3.5310000000E+04, 1.3329259713E+00, 1.6384491883E+00, 7.7838347508E-02, 7.0384366308E-02, 7.9106277139E-01],
	[3.5315000000E+04, 1.3332268353E+00, 1.6384248637E+00, 7.7871741345E-02, 7.0412463963E-02, 7.9109059715E-01],
	[3.5320000000E+04, 1.3335277247E+00, 1.6384005429E+00, 7.7905144777E-02, 7.0440568168E-02, 7.9111842188E-01],
	[3.5325000000E+04, 1.3338286394E+00, 1.6383762260E+00, 7.7938557807E-02, 7.0468678922E-02, 7.9114624558E-01],
	[3.5330000000E+04, 1.3341295794E+00, 1.6383519128E+00, 7.7971980435E-02, 7.0496796226E-02, 7.9117406825E-01],
	[3.5335000000E+04, 1.3344305446E+00, 1.6383276034E+00, 7.8005412663E-02, 7.0524920079E-02, 7.9120188988E-01],
	[3.5340000000E+04, 1.3347315352E+00, 1.6383032978E+00, 7.8038854493E-02, 7.0553050482E-02, 7.9122971048E-01],
	[3.5345000000E+04, 1.3350325510E+00, 1.6382789961E+00, 7.8072305925E-02, 7.0581187435E-02, 7.9125753004E-01],
	[3.5350000000E+04, 1.3353335922E+00, 1.6382546981E+00, 7.8105766962E-02, 7.0609330937E-02, 7.9128534856E-01],
	[3.5355000000E+04, 1.3356346586E+00, 1.6382304039E+00, 7.8139237604E-02, 7.0637480989E-02, 7.9131316605E-01],
	[3.5360000000E+04, 1.3359357504E+00, 1.6382061135E+00, 7.8172717853E-02, 7.0665637591E-02, 7.9134098250E-01],
	[3.5365000000E+04, 1.3362368674E+00, 1.6381818269E+00, 7.8206207710E-02, 7.0693800743E-02, 7.9136879790E-01],
	[3.5370000000E+04, 1.3365380097E+00, 1.6381575441E+00, 7.8239707177E-02, 7.0721970446E-02, 7.9139661227E-01],
	[3.5375000000E+04, 1.3368391773E+00, 1.6381332651E+00, 7.8273216255E-02, 7.0750146698E-02, 7.9142442560E-01],
	[3.5380000000E+04, 1.3371403702E+00, 1.6381089899E+00, 7.8306734946E-02, 7.0778329501E-02, 7.9145223788E-01],
	[3.5385000000E+04, 1.3374415883E+00, 1.6380847185E+00, 7.8340263251E-02, 7.0806518853E-02, 7.9148004911E-01],
	[3.5390000000E+04, 1.3377428318E+00, 1.6380604509E+00, 7.8373801171E-02, 7.0834714757E-02, 7.9150785930E-01],
	[3.5395000000E+04, 1.3380441005E+00, 1.6380361870E+00, 7.8407348707E-02, 7.0862917210E-02, 7.9153566845E-01],
	[3.5400000000E+04, 1.3383453945E+00, 1.6380119269E+00, 7.8440905862E-02, 7.0891126214E-02, 7.9156347655E-01],
	[3.5405000000E+04, 1.3386467138E+00, 1.6379876707E+00, 7.8474472637E-02, 7.0919341769E-02, 7.9159128360E-01],
	[3.5410000000E+04, 1.3389480583E+00, 1.6379634182E+00, 7.8508049032E-02, 7.0947563874E-02, 7.9161908960E-01],
	[3.5415000000E+04, 1.3392494281E+00, 1.6379391695E+00, 7.8541635050E-02, 7.0975792530E-02, 7.9164689455E-01],
	[3.5420000000E+04, 1.3395508232E+00, 1.6379149245E+00, 7.8575230691E-02, 7.1004027737E-02, 7.9167469845E-01],
	[3.5425000000E+04, 1.3398522436E+00, 1.6378906834E+00, 7.8608835958E-02, 7.1032269495E-02, 7.9170250130E-01],
	[3.5430000000E+04, 1.3401536892E+00, 1.6378664460E+00, 7.8642450851E-02, 7.1060517803E-02, 7.9173030309E-01],
	[3.5435000000E+04, 1.3404551602E+00, 1.6378422125E+00, 7.8676075372E-02, 7.1088772663E-02, 7.9175810383E-01],
	[3.5440000000E+04, 1.3407566563E+00, 1.6378179826E+00, 7.8709709522E-02, 7.1117034073E-02, 7.9178590352E-01],
	[3.5445000000E+04, 1.3410581778E+00, 1.6377937566E+00, 7.8743353303E-02, 7.1145302035E-02, 7.9181370215E-01],
	[3.5450000000E+04, 1.3413597245E+00, 1.6377695344E+00, 7.8777006716E-02, 7.1173576548E-02, 7.9184149972E-01],
	[3.5455000000E+04, 1.3416612964E+00, 1.6377453159E+00, 7.8810669763E-02, 7.1201857612E-02, 7.9186929623E-01],
	[3.5460000000E+04, 1.3419628937E+00, 1.6377211012E+00, 7.8844342445E-02, 7.1230145227E-02, 7.9189709168E-01],
	[3.5465000000E+04, 1.3422645161E+00, 1.6376968902E+00, 7.8878024763E-02, 7.1258439394E-02, 7.9192488608E-01],
	[3.5470000000E+04, 1.3425661639E+00, 1.6376726831E+00, 7.8911716718E-02, 7.1286740112E-02, 7.9195267941E-01],
	[3.5475000000E+04, 1.3428678369E+00, 1.6376484797E+00, 7.8945418313E-02, 7.1315047382E-02, 7.9198047168E-01],
	[3.5480000000E+04, 1.3431695351E+00, 1.6376242800E+00, 7.8979129548E-02, 7.1343361203E-02, 7.9200826289E-01],
	[3.5485000000E+04, 1.3434712587E+00, 1.6376000842E+00, 7.9012850425E-02, 7.1371681576E-02, 7.9203605303E-01],
	[3.5490000000E+04, 1.3437730074E+00, 1.6375758921E+00, 7.9046580946E-02, 7.1400008501E-02, 7.9206384211E-01],
	[3.5495000000E+04, 1.3440747814E+00, 1.6375517038E+00, 7.9080321111E-02, 7.1428341978E-02, 7.9209163012E-01],
	[3.5500000000E+04, 1.3443765807E+00, 1.6375275192E+00, 7.9114070922E-02, 7.1456682006E-02, 7.9211941706E-01],
	[3.5505000000E+04, 1.3446784052E+00, 1.6375033384E+00, 7.9147830381E-02, 7.1485028586E-02, 7.9214720294E-01],
	[3.5510000000E+04, 1.3449802549E+00, 1.6374791614E+00, 7.9181599489E-02, 7.1513381718E-02, 7.9217498774E-01],
	[3.5515000000E+04, 1.3452821299E+00, 1.6374549881E+00, 7.9215378247E-02, 7.1541741402E-02, 7.9220277148E-01],
	[3.5520000000E+04, 1.3455840302E+00, 1.6374308186E+00, 7.9249166656E-02, 7.1570107639E-02, 7.9223055414E-01],
	[3.5525000000E+04, 1.3458859557E+00, 1.6374066528E+00, 7.9282964719E-02, 7.1598480427E-02, 7.9225833573E-01],
	[3.5530000000E+04, 1.3461879064E+00, 1.6373824908E+00, 7.9316772437E-02, 7.1626859767E-02, 7.9228611625E-01],
	[3.5535000000E+04, 1.3464898824E+00, 1.6373583326E+00, 7.9350589810E-02, 7.1655245660E-02, 7.9231389570E-01],
	[3.5540000000E+04, 1.3467918836E+00, 1.6373341781E+00, 7.9384416840E-02, 7.1683638105E-02, 7.9234167407E-01],
	[3.5545000000E+04, 1.3470939100E+00, 1.6373100273E+00, 7.9418253529E-02, 7.1712037103E-02, 7.9236945136E-01],
	[3.5550000000E+04, 1.3473959617E+00, 1.6372858804E+00, 7.9452099879E-02, 7.1740442653E-02, 7.9239722757E-01],
	[3.5555000000E+04, 1.3476980386E+00, 1.6372617371E+00, 7.9485955889E-02, 7.1768854755E-02, 7.9242500271E-01],
	[3.5560000000E+04, 1.3480001407E+00, 1.6372375976E+00, 7.9519821563E-02, 7.1797273411E-02, 7.9245277677E-01],
	[3.5565000000E+04, 1.3483022681E+00, 1.6372134619E+00, 7.9553696901E-02, 7.1825698618E-02, 7.9248054975E-01],
	[3.5570000000E+04, 1.3486044207E+00, 1.6371893299E+00, 7.9587581905E-02, 7.1854130379E-02, 7.9250832164E-01],
	[3.5575000000E+04, 1.3489065985E+00, 1.6371652017E+00, 7.9621476575E-02, 7.1882568692E-02, 7.9253609246E-01],
	[3.5580000000E+04, 1.3492088016E+00, 1.6371410772E+00, 7.9655380914E-02, 7.1911013557E-02, 7.9256386219E-01],
	[3.5585000000E+04, 1.3495110299E+00, 1.6371169565E+00, 7.9689294923E-02, 7.1939464976E-02, 7.9259163083E-01],
	[3.5590000000E+04, 1.3498132834E+00, 1.6370928395E+00, 7.9723218604E-02, 7.1967922948E-02, 7.9261939840E-01],
	[3.5595000000E+04, 1.3501155621E+00, 1.6370687262E+00, 7.9757151957E-02, 7.1996387472E-02, 7.9264716487E-01],
	[3.5600000000E+04, 1.3504178660E+00, 1.6370446167E+00, 7.9791094984E-02, 7.2024858550E-02, 7.9267493026E-01],
	[3.5605000000E+04, 1.3507201952E+00, 1.6370205109E+00, 7.9825047686E-02, 7.2053336181E-02, 7.9270269456E-01],
	[3.5610000000E+04, 1.3510225496E+00, 1.6369964089E+00, 7.9859010066E-02, 7.2081820365E-02, 7.9273045777E-01],
	[3.5615000000E+04, 1.3513249292E+00, 1.6369723106E+00, 7.9892982124E-02, 7.2110311102E-02, 7.9275821989E-01],
	[3.5620000000E+04, 1.3516273340E+00, 1.6369482161E+00, 7.9926963861E-02, 7.2138808392E-02, 7.9278598092E-01],
	[3.5625000000E+04, 1.3519297640E+00, 1.6369241252E+00, 7.9960955280E-02, 7.2167312235E-02, 7.9281374085E-01],
	[3.5630000000E+04, 1.3522322193E+00, 1.6369000382E+00, 7.9994956380E-02, 7.2195822632E-02, 7.9284149970E-01],
	[3.5635000000E+04, 1.3525346997E+00, 1.6368759548E+00, 8.0028967165E-02, 7.2224339583E-02, 7.9286925744E-01],
	[3.5640000000E+04, 1.3528372054E+00, 1.6368518752E+00, 8.0062987635E-02, 7.2252863086E-02, 7.9289701410E-01],
	[3.5645000000E+04, 1.3531397362E+00, 1.6368277993E+00, 8.0097017792E-02, 7.2281393144E-02, 7.9292476966E-01],
	[3.5650000000E+04, 1.3534422923E+00, 1.6368037272E+00, 8.0131057637E-02, 7.2309929754E-02, 7.9295252412E-01],
	[3.5655000000E+04, 1.3537445128E+00, 1.6367803259E+00, 8.0165107171E-02, 7.2338473191E-02, 7.9298027748E-01],
	[3.5660000000E+04, 1.3540466061E+00, 1.6367572095E+00, 8.0199166396E-02, 7.2367023298E-02, 7.9300802974E-01],
	[3.5665000000E+04, 1.3543487244E+00, 1.6367340968E+00, 8.0233235314E-02, 7.2395579960E-02, 7.9303578090E-01],
	[3.5670000000E+04, 1.3546508678E+00, 1.6367109876E+00, 8.0267313925E-02, 7.2424143177E-02, 7.9306353096E-01],
	[3.5675000000E+04, 1.3549530362E+00, 1.6366878820E+00, 8.0301402231E-02, 7.2452712949E-02, 7.9309127992E-01],
	[3.5680000000E+04, 1.3552552297E+00, 1.6366647800E+00, 8.0335500233E-02, 7.2481289277E-02, 7.9311902778E-01],
	[3.5685000000E+04, 1.3555574482E+00, 1.6366416815E+00, 8.0369607934E-02, 7.2509872159E-02, 7.9314677453E-01],
	[3.5690000000E+04, 1.3558596918E+00, 1.6366185866E+00, 8.0403725334E-02, 7.2538461597E-02, 7.9317452018E-01],
	[3.5695000000E+04, 1.3561619604E+00, 1.6365954952E+00, 8.0437852434E-02, 7.2567057590E-02, 7.9320226472E-01],
	[3.5700000000E+04, 1.3564642540E+00, 1.6365724074E+00, 8.0471989236E-02, 7.2595660138E-02, 7.9323000815E-01],
	[3.5705000000E+04, 1.3567665727E+00, 1.6365493232E+00, 8.0506135742E-02, 7.2624269242E-02, 7.9325775048E-01],
	[3.5710000000E+04, 1.3570689163E+00, 1.6365262425E+00, 8.0540291953E-02, 7.2652884901E-02, 7.9328549170E-01],
	[3.5715000000E+04, 1.3573712851E+00, 1.6365031654E+00, 8.0574457870E-02, 7.2681507115E-02, 7.9331323180E-01],
	[3.5720000000E+04, 1.3576736788E+00, 1.6364800918E+00, 8.0608633494E-02, 7.2710135886E-02, 7.9334097080E-01],
	[3.5725000000E+04, 1.3579760976E+00, 1.6364570218E+00, 8.0642818828E-02, 7.2738771211E-02, 7.9336870868E-01],
	[3.5730000000E+04, 1.3582785414E+00, 1.6364339554E+00, 8.0677013872E-02, 7.2767413093E-02, 7.9339644545E-01],
	[3.5735000000E+04, 1.3585810102E+00, 1.6364108924E+00, 8.0711218628E-02, 7.2796061530E-02, 7.9342418111E-01],
	[3.5740000000E+04, 1.3588835040E+00, 1.6363878331E+00, 8.0745433097E-02, 7.2824716523E-02, 7.9345191565E-01],
	[3.5745000000E+04, 1.3591860229E+00, 1.6363647773E+00, 8.0779657281E-02, 7.2853378071E-02, 7.9347964908E-01],
	[3.5750000000E+04, 1.3594885668E+00, 1.6363417250E+00, 8.0813891181E-02, 7.2882046176E-02, 7.9350738138E-01],
	[3.5755000000E+04, 1.3597911357E+00, 1.6363186763E+00, 8.0848134798E-02, 7.2910720836E-02, 7.9353511258E-01],
	[3.5760000000E+04, 1.3600937296E+00, 1.6362956312E+00, 8.0882388134E-02, 7.2939402052E-02, 7.9356284265E-01],
	[3.5765000000E+04, 1.3603963486E+00, 1.6362725896E+00, 8.0916651191E-02, 7.2968089825E-02, 7.9359057160E-01],
	[3.5770000000E+04, 1.3606989925E+00, 1.6362495515E+00, 8.0950923969E-02, 7.2996784153E-02, 7.9361829943E-01],
	[3.5775000000E+04, 1.3610016615E+00, 1.6362265170E+00, 8.0985206470E-02, 7.3025485037E-02, 7.9364602614E-01],
	[3.5780000000E+04, 1.3613043555E+00, 1.6362034860E+00, 8.1019498695E-02, 7.3054192477E-02, 7.9367375173E-01],
	[3.5785000000E+04, 1.3616070745E+00, 1.6361804586E+00, 8.1053800647E-02, 7.3082906474E-02, 7.9370147619E-01],
	[3.5790000000E+04, 1.3619098185E+00, 1.6361574347E+00, 8.1088112325E-02, 7.3111627027E-02, 7.9372919953E-01],
	[3.5795000000E+04, 1.3622125875E+00, 1.6361344143E+00, 8.1122433732E-02, 7.3140354136E-02, 7.9375692174E-01],
	[3.5800000000E+04, 1.3625153815E+00, 1.6361113975E+00, 8.1156764869E-02, 7.3169087801E-02, 7.9378464282E-01],
	[3.5805000000E+04, 1.3628182005E+00, 1.6360883842E+00, 8.1191105738E-02, 7.3197828023E-02, 7.9381236278E-01],
	[3.5810000000E+04, 1.3631210445E+00, 1.6360653745E+00, 8.1225456340E-02, 7.3226574801E-02, 7.9384008161E-01],
	[3.5815000000E+04, 1.3634239136E+00, 1.6360423683E+00, 8.1259816675E-02, 7.3255328135E-02, 7.9386779931E-01],
	[3.5820000000E+04, 1.3637268076E+00, 1.6360193656E+00, 8.1294186747E-02, 7.3284088026E-02, 7.9389551588E-01],
	[3.5825000000E+04, 1.3640297266E+00, 1.6359963665E+00, 8.1328566555E-02, 7.3312854473E-02, 7.9392323132E-01],
	[3.5830000000E+04, 1.3643326706E+00, 1.6359733709E+00, 8.1362956102E-02, 7.3341627477E-02, 7.9395094562E-01],
	[3.5835000000E+04, 1.3646356397E+00, 1.6359503788E+00, 8.1397355388E-02, 7.3370407038E-02, 7.9397865879E-01],
	[3.5840000000E+04, 1.3649386337E+00, 1.6359273903E+00, 8.1431764416E-02, 7.3399193155E-02, 7.9400637083E-01],
	[3.5845000000E+04, 1.3652416527E+00, 1.6359044052E+00, 8.1466183186E-02, 7.3427985828E-02, 7.9403408173E-01],
	[3.5850000000E+04, 1.3655446967E+00, 1.6358814238E+00, 8.1500611701E-02, 7.3456785059E-02, 7.9406179149E-01],
	[3.5855000000E+04, 1.3658477656E+00, 1.6358584458E+00, 8.1535049961E-02, 7.3485590846E-02, 7.9408950012E-01],
	[3.5860000000E+04, 1.3661508596E+00, 1.6358354714E+00, 8.1569497967E-02, 7.3514403190E-02, 7.9411720761E-01],
	[3.5865000000E+04, 1.3664539786E+00, 1.6358125005E+00, 8.1603955722E-02, 7.3543222091E-02, 7.9414491396E-01],
	[3.5870000000E+04, 1.3667571225E+00, 1.6357895331E+00, 8.1638423227E-02, 7.3572047548E-02, 7.9417261917E-01],
	[3.5875000000E+04, 1.3670602915E+00, 1.6357665693E+00, 8.1672900482E-02, 7.3600879563E-02, 7.9420032323E-01],
	[3.5880000000E+04, 1.3673634854E+00, 1.6357436089E+00, 8.1707387490E-02, 7.3629718134E-02, 7.9422802616E-01],
	[3.5885000000E+04, 1.3676667043E+00, 1.6357206521E+00, 8.1741884252E-02, 7.3658563263E-02, 7.9425572794E-01],
	[3.5890000000E+04, 1.3679699482E+00, 1.6356976988E+00, 8.1776390769E-02, 7.3687414948E-02, 7.9428342858E-01],
	[3.5895000000E+04, 1.3682732170E+00, 1.6356747491E+00, 8.1810907043E-02, 7.3716273190E-02, 7.9431112807E-01],
	[3.5900000000E+04, 1.3685765108E+00, 1.6356518028E+00, 8.1845433074E-02, 7.3745137990E-02, 7.9433882641E-01],
	[3.5905000000E+04, 1.3688798297E+00, 1.6356288601E+00, 8.1879968865E-02, 7.3774009347E-02, 7.9436652361E-01],
	[3.5910000000E+04, 1.3691831734E+00, 1.6356059209E+00, 8.1914514417E-02, 7.3802887260E-02, 7.9439421966E-01],
	[3.5915000000E+04, 1.3694865422E+00, 1.6355829852E+00, 8.1949069731E-02, 7.3831771731E-02, 7.9442191456E-01],
	[3.5920000000E+04, 1.3697899359E+00, 1.6355600530E+00, 8.1983634809E-02, 7.3860662760E-02, 7.9444960832E-01],
	[3.5925000000E+04, 1.3700933546E+00, 1.6355371243E+00, 8.2018209651E-02, 7.3889560345E-02, 7.9447730092E-01],
	[3.5930000000E+04, 1.3703967983E+00, 1.6355141991E+00, 8.2052794260E-02, 7.3918464488E-02, 7.9450499236E-01],
	[3.5935000000E+04, 1.3707002669E+00, 1.6354912775E+00, 8.2087388637E-02, 7.3947375188E-02, 7.9453268266E-01],
	[3.5940000000E+04, 1.3710037605E+00, 1.6354683594E+00, 8.2121992783E-02, 7.3976292445E-02, 7.9456037180E-01],
	[3.5945000000E+04, 1.3713072791E+00, 1.6354454447E+00, 8.2156606700E-02, 7.4005216260E-02, 7.9458805979E-01],
	[3.5950000000E+04, 1.3716108226E+00, 1.6354225336E+00, 8.2191230388E-02, 7.4034146632E-02, 7.9461574662E-01],
	[3.5955000000E+04, 1.3719143911E+00, 1.6353996260E+00, 8.2225863850E-02, 7.4063083562E-02, 7.9464343229E-01],
	[3.5960000000E+04, 1.3722179846E+00, 1.6353767219E+00, 8.2260507087E-02, 7.4092027049E-02, 7.9467111681E-01],
	[3.5965000000E+04, 1.3725216030E+00, 1.6353538213E+00, 8.2295160100E-02, 7.4120977094E-02, 7.9469880016E-01],
	[3.5970000000E+04, 1.3728252464E+00, 1.6353309242E+00, 8.2329822891E-02, 7.4149933696E-02, 7.9472648236E-01],
	[3.5975000000E+04, 1.3731289147E+00, 1.6353080306E+00, 8.2364495461E-02, 7.4178896856E-02, 7.9475416340E-01],
	[3.5980000000E+04, 1.3734326080E+00, 1.6352851405E+00, 8.2399177811E-02, 7.4207866573E-02, 7.9478184327E-01],
	[3.5985000000E+04, 1.3737363262E+00, 1.6352622539E+00, 8.2433869942E-02, 7.4236842848E-02, 7.9480952198E-01],
	[3.5990000000E+04, 1.3740400694E+00, 1.6352393708E+00, 8.2468571857E-02, 7.4265825681E-02, 7.9483719953E-01],
	[3.5995000000E+04, 1.3743438375E+00, 1.6352164912E+00, 8.2503283557E-02, 7.4294815071E-02, 7.9486487592E-01],
	[3.6000000000E+04, 1.3746476306E+00, 1.6351936151E+00, 8.2538005043E-02, 7.4323811020E-02, 7.9489255113E-01],
	[3.6005000000E+04, 1.3749514486E+00, 1.6351707425E+00, 8.2572736315E-02, 7.4352813525E-02, 7.9492022519E-01],
	[3.6010000000E+04, 1.3752552916E+00, 1.6351478734E+00, 8.2607477377E-02, 7.4381822589E-02, 7.9494789807E-01],
	[3.6015000000E+04, 1.3755591595E+00, 1.6351250078E+00, 8.2642228229E-02, 7.4410838211E-02, 7.9497556979E-01],
	[3.6020000000E+04, 1.3758630524E+00, 1.6351021457E+00, 8.2676988873E-02, 7.4439860390E-02, 7.9500324033E-01],
	[3.6025000000E+04, 1.3761669702E+00, 1.6350792871E+00, 8.2711759309E-02, 7.4468889127E-02, 7.9503090971E-01],
	[3.6030000000E+04, 1.3764709130E+00, 1.6350564320E+00, 8.2746539540E-02, 7.4497924422E-02, 7.9505857791E-01],
	[3.6035000000E+04, 1.3767748807E+00, 1.6350335803E+00, 8.2781329567E-02, 7.4526966275E-02, 7.9508624495E-01],
	[3.6040000000E+04, 1.3770788733E+00, 1.6350107322E+00, 8.2816129391E-02, 7.4556014686E-02, 7.9511391080E-01],
	[3.6045000000E+04, 1.3773828908E+00, 1.6349878875E+00, 8.2850939013E-02, 7.4585069655E-02, 7.9514157549E-01],
	[3.6050000000E+04, 1.3776869333E+00, 1.6349650463E+00, 8.2885758436E-02, 7.4614131182E-02, 7.9516923900E-01],
	[3.6055000000E+04, 1.3779910008E+00, 1.6349422087E+00, 8.2920587659E-02, 7.4643199267E-02, 7.9519690133E-01],
	[3.6060000000E+04, 1.3782950931E+00, 1.6349193745E+00, 8.2955426686E-02, 7.4672273910E-02, 7.9522456249E-01],
	[3.6065000000E+04, 1.3785992104E+00, 1.6348965437E+00, 8.2990275517E-02, 7.4701355112E-02, 7.9525222247E-01],
	[3.6070000000E+04, 1.3789033527E+00, 1.6348737165E+00, 8.3025134153E-02, 7.4730442871E-02, 7.9527988127E-01],
	[3.6075000000E+04, 1.3792075198E+00, 1.6348508928E+00, 8.3060002597E-02, 7.4759537188E-02, 7.9530753889E-01],
	[3.6080000000E+04, 1.3795117119E+00, 1.6348280725E+00, 8.3094880848E-02, 7.4788638064E-02, 7.9533519533E-01],
	[3.6085000000E+04, 1.3798159289E+00, 1.6348052557E+00, 8.3129768910E-02, 7.4817745497E-02, 7.9536285059E-01],
	[3.6090000000E+04, 1.3801201708E+00, 1.6347824424E+00, 8.3164666782E-02, 7.4846859489E-02, 7.9539050466E-01],
	[3.6095000000E+04, 1.3804244377E+00, 1.6347596326E+00, 8.3199574468E-02, 7.4875980039E-02, 7.9541815755E-01],
	[3.6100000000E+04, 1.3807287294E+00, 1.6347368262E+00, 8.3234491967E-02, 7.4905107148E-02, 7.9544580926E-01],
	[3.6105000000E+04, 1.3810330461E+00, 1.6347140234E+00, 8.3269419282E-02, 7.4934240814E-02, 7.9547345978E-01],
	[3.6110000000E+04, 1.3813373877E+00, 1.6346912240E+00, 8.3304356413E-02, 7.4963381039E-02, 7.9550110911E-01],
	[3.6115000000E+04, 1.3816417543E+00, 1.6346684281E+00, 8.3339303363E-02, 7.4992527822E-02, 7.9552875726E-01],
	[3.6120000000E+04, 1.3819461457E+00, 1.6346456356E+00, 8.3374260132E-02, 7.5021681164E-02, 7.9555640421E-01],
	[3.6125000000E+04, 1.3822505621E+00, 1.6346228466E+00, 8.3409226722E-02, 7.5050841064E-02, 7.9558404998E-01],
	[3.6130000000E+04, 1.3825550033E+00, 1.6346000611E+00, 8.3444203134E-02, 7.5080007522E-02, 7.9561169456E-01],
	[3.6135000000E+04, 1.3828594695E+00, 1.6345772791E+00, 8.3479189370E-02, 7.5109180538E-02, 7.9563933795E-01],
	[3.6140000000E+04, 1.3831639606E+00, 1.6345545005E+00, 8.3514185432E-02, 7.5138360113E-02, 7.9566698014E-01],
	[3.6145000000E+04, 1.3834684766E+00, 1.6345317254E+00, 8.3549191320E-02, 7.5167546247E-02, 7.9569462114E-01],
	[3.6150000000E+04, 1.3837730175E+00, 1.6345089538E+00, 8.3584207036E-02, 7.5196738939E-02, 7.9572226095E-01],
	[3.6155000000E+04, 1.3840775833E+00, 1.6344861856E+00, 8.3619232581E-02, 7.5225938189E-02, 7.9574989956E-01],
	[3.6160000000E+04, 1.3843821740E+00, 1.6344634209E+00, 8.3654267957E-02, 7.5255143998E-02, 7.9577753698E-01],
	[3.6165000000E+04, 1.3846867896E+00, 1.6344406597E+00, 8.3689313165E-02, 7.5284356365E-02, 7.9580517319E-01],
	[3.6170000000E+04, 1.3849914301E+00, 1.6344179019E+00, 8.3724368207E-02, 7.5313575291E-02, 7.9583280821E-01],
	[3.6175000000E+04, 1.3852960955E+00, 1.6343951476E+00, 8.3759433084E-02, 7.5342800775E-02, 7.9586044204E-01],
	[3.6180000000E+04, 1.3856007858E+00, 1.6343723968E+00, 8.3794507797E-02, 7.5372032818E-02, 7.9588807466E-01],
	[3.6185000000E+04, 1.3859055011E+00, 1.6343496494E+00, 8.3829592348E-02, 7.5401271419E-02, 7.9591570608E-01],
	[3.6190000000E+04, 1.3862102412E+00, 1.6343269055E+00, 8.3864686738E-02, 7.5430516579E-02, 7.9594333630E-01],
	[3.6195000000E+04, 1.3865150062E+00, 1.6343041650E+00, 8.3899790969E-02, 7.5459768298E-02, 7.9597096531E-01],
	[3.6200000000E+04, 1.3868197960E+00, 1.6342814280E+00, 8.3934905041E-02, 7.5489026575E-02, 7.9599859312E-01],
	[3.6205000000E+04, 1.3871246108E+00, 1.6342586945E+00, 8.3970028957E-02, 7.5518291411E-02, 7.9602621973E-01],
	[3.6210000000E+04, 1.3874294505E+00, 1.6342359644E+00, 8.4005162718E-02, 7.5547562805E-02, 7.9605384513E-01],
	[3.6215000000E+04, 1.3877343151E+00, 1.6342132377E+00, 8.4040306325E-02, 7.5576840758E-02, 7.9608146933E-01],
	[3.6220000000E+04, 1.3880392045E+00, 1.6341905145E+00, 8.4075459779E-02, 7.5606125270E-02, 7.9610909232E-01],
	[3.6225000000E+04, 1.3883441188E+00, 1.6341677948E+00, 8.4110623083E-02, 7.5635416341E-02, 7.9613671410E-01],
	[3.6230000000E+04, 1.3886487373E+00, 1.6341459337E+00, 8.4145796236E-02, 7.5664714851E-02, 7.9616433467E-01],
	[3.6235000000E+04, 1.3889533508E+00, 1.6341241552E+00, 8.4180979242E-02, 7.5694020003E-02, 7.9619195403E-01],
	[3.6240000000E+04, 1.3892579891E+00, 1.6341023799E+00, 8.4216172101E-02, 7.5723331716E-02, 7.9621957218E-01],
	[3.6245000000E+04, 1.3895626521E+00, 1.6340806079E+00, 8.4251374814E-02, 7.5752649989E-02, 7.9624718911E-01],
	[3.6250000000E+04, 1.3898673400E+00, 1.6340588392E+00, 8.4286587383E-02, 7.5781974824E-02, 7.9627480484E-01],
	[3.6255000000E+04, 1.3901720526E+00, 1.6340370738E+00, 8.4321809809E-02, 7.5811306218E-02, 7.9630241935E-01],
	[3.6260000000E+04, 1.3904767899E+00, 1.6340153117E+00, 8.4357042095E-02, 7.5840644174E-02, 7.9633003264E-01],
	[3.6265000000E+04, 1.3907815521E+00, 1.6339935529E+00, 8.4392284240E-02, 7.5869988690E-02, 7.9635764472E-01],
	[3.6270000000E+04, 1.3910863390E+00, 1.6339717973E+00, 8.4427536247E-02, 7.5899339766E-02, 7.9638525558E-01],
	[3.6275000000E+04, 1.3913911507E+00, 1.6339500451E+00, 8.4462798117E-02, 7.5928697403E-02, 7.9641286523E-01],
	[3.6280000000E+04, 1.3916959871E+00, 1.6339282961E+00, 8.4498069851E-02, 7.5958061601E-02, 7.9644047365E-01],
	[3.6285000000E+04, 1.3920008483E+00, 1.6339065505E+00, 8.4533351451E-02, 7.5987432360E-02, 7.9646808086E-01],
	[3.6290000000E+04, 1.3923057343E+00, 1.6338848081E+00, 8.4568642919E-02, 7.6016809680E-02, 7.9649568684E-01],
	[3.6295000000E+04, 1.3926106450E+00, 1.6338630690E+00, 8.4603944254E-02, 7.6046193560E-02, 7.9652329160E-01],
	[3.6300000000E+04, 1.3929155805E+00, 1.6338413332E+00, 8.4639255460E-02, 7.6075584000E-02, 7.9655089514E-01],
	[3.6305000000E+04, 1.3932205407E+00, 1.6338196006E+00, 8.4674576537E-02, 7.6104981002E-02, 7.9657849746E-01],
	[3.6310000000E+04, 1.3935255257E+00, 1.6337978714E+00, 8.4709907487E-02, 7.6134384564E-02, 7.9660609855E-01],
	[3.6315000000E+04, 1.3938305355E+00, 1.6337761454E+00, 8.4745248311E-02, 7.6163794687E-02, 7.9663369842E-01],
	[3.6320000000E+04, 1.3941355700E+00, 1.6337544227E+00, 8.4780599010E-02, 7.6193211371E-02, 7.9666129706E-01],
	[3.6325000000E+04, 1.3944406293E+00, 1.6337327033E+00, 8.4815959587E-02, 7.6222634616E-02, 7.9668889448E-01],
	[3.6330000000E+04, 1.3947457133E+00, 1.6337109872E+00, 8.4851330042E-02, 7.6252064421E-02, 7.9671649066E-01],
	[3.6335000000E+04, 1.3950508221E+00, 1.6336892743E+00, 8.4886710376E-02, 7.6281500787E-02, 7.9674408562E-01],
	[3.6340000000E+04, 1.3953559556E+00, 1.6336675647E+00, 8.4922100592E-02, 7.6310943714E-02, 7.9677167935E-01],
	[3.6345000000E+04, 1.3956611138E+00, 1.6336458584E+00, 8.4957500690E-02, 7.6340393202E-02, 7.9679927184E-01],
	[3.6350000000E+04, 1.3959662968E+00, 1.6336241554E+00, 8.4992910672E-02, 7.6369849251E-02, 7.9682686311E-01],
	[3.6355000000E+04, 1.3962715046E+00, 1.6336024557E+00, 8.5028330540E-02, 7.6399311860E-02, 7.9685445314E-01],
	[3.6360000000E+04, 1.3965767371E+00, 1.6335807592E+00, 8.5063760294E-02, 7.6428781030E-02, 7.9688204194E-01],
	[3.6365000000E+04, 1.3968819943E+00, 1.6335590660E+00, 8.5099199936E-02, 7.6458256761E-02, 7.9690962950E-01],
	[3.6370000000E+04, 1.3971872762E+00, 1.6335373760E+00, 8.5134649468E-02, 7.6487739053E-02, 7.9693721583E-01],
	[3.6375000000E+04, 1.3974925830E+00, 1.6335156893E+00, 8.5170108891E-02, 7.6517227905E-02, 7.9696480092E-01],
	[3.6380000000E+04, 1.3977979144E+00, 1.6334940059E+00, 8.5205578206E-02, 7.6546723319E-02, 7.9699238477E-01],
	[3.6385000000E+04, 1.3981032706E+00, 1.6334723258E+00, 8.5241057415E-02, 7.6576225293E-02, 7.9701996738E-01],
	[3.6390000000E+04, 1.3984086515E+00, 1.6334506489E+00, 8.5276546519E-02, 7.6605733828E-02, 7.9704754876E-01],
	[3.6395000000E+04, 1.3987140571E+00, 1.6334289753E+00, 8.5312045520E-02, 7.6635248924E-02, 7.9707512890E-01],
	[3.6400000000E+04, 1.3990194875E+00, 1.6334073050E+00, 8.5347554419E-02, 7.6664770581E-02, 7.9710270779E-01],
	[3.6405000000E+04, 1.3993249426E+00, 1.6333856379E+00, 8.5383073217E-02, 7.6694298799E-02, 7.9713028544E-01],
	[3.6410000000E+04, 1.3996304224E+00, 1.6333639741E+00, 8.5418601915E-02, 7.6723833577E-02, 7.9715786185E-01],
	[3.6415000000E+04, 1.3999359270E+00, 1.6333423136E+00, 8.5454140516E-02, 7.6753374916E-02, 7.9718543701E-01],
	[3.6420000000E+04, 1.4002414563E+00, 1.6333206563E+00, 8.5489689020E-02, 7.6782922817E-02, 7.9721301094E-01],
	[3.6425000000E+04, 1.4005470103E+00, 1.6332990022E+00, 8.5525247430E-02, 7.6812477278E-02, 7.9724058361E-01],
	[3.6430000000E+04, 1.4008525890E+00, 1.6332773515E+00, 8.5560815745E-02, 7.6842038300E-02, 7.9726815504E-01],
	[3.6435000000E+04, 1.4011581925E+00, 1.6332557040E+00, 8.5596393969E-02, 7.6871605882E-02, 7.9729572522E-01],
	[3.6440000000E+04, 1.4014638207E+00, 1.6332340597E+00, 8.5631982101E-02, 7.6901180026E-02, 7.9732329415E-01],
	[3.6445000000E+04, 1.4017694736E+00, 1.6332124187E+00, 8.5667580144E-02, 7.6930760730E-02, 7.9735086183E-01],
	[3.6450000000E+04, 1.4020751512E+00, 1.6331907810E+00, 8.5703188099E-02, 7.6960347996E-02, 7.9737842826E-01],
	[3.6455000000E+04, 1.4023808535E+00, 1.6331691465E+00, 8.5738805968E-02, 7.6989941822E-02, 7.9740599344E-01],
	[3.6460000000E+04, 1.4026865805E+00, 1.6331475152E+00, 8.5774433751E-02, 7.7019542209E-02, 7.9743355737E-01],
	[3.6465000000E+04, 1.4029923323E+00, 1.6331258873E+00, 8.5810071450E-02, 7.7049149157E-02, 7.9746112004E-01],
	[3.6470000000E+04, 1.4032981088E+00, 1.6331042625E+00, 8.5845719066E-02, 7.7078762665E-02, 7.9748868146E-01],
	[3.6475000000E+04, 1.4036039099E+00, 1.6330826411E+00, 8.5881376602E-02, 7.7108382735E-02, 7.9751624163E-01],
	[3.6480000000E+04, 1.4039097358E+00, 1.6330610228E+00, 8.5917044058E-02, 7.7138009365E-02, 7.9754380054E-01],
	[3.6485000000E+04, 1.4042155864E+00, 1.6330394079E+00, 8.5952721436E-02, 7.7167642556E-02, 7.9757135819E-01],
	[3.6490000000E+04, 1.4045214617E+00, 1.6330177961E+00, 8.5988408737E-02, 7.7197282308E-02, 7.9759891458E-01],
	[3.6495000000E+04, 1.4048273617E+00, 1.6329961876E+00, 8.6024105962E-02, 7.7226928621E-02, 7.9762646972E-01],
	[3.6500000000E+04, 1.4051332864E+00, 1.6329745824E+00, 8.6059813113E-02, 7.7256581495E-02, 7.9765402360E-01],
	[3.6505000000E+04, 1.4054392358E+00, 1.6329529804E+00, 8.6095530192E-02, 7.7286240929E-02, 7.9768157621E-01],
	[3.6510000000E+04, 1.4057452099E+00, 1.6329313817E+00, 8.6131257200E-02, 7.7315906925E-02, 7.9770912756E-01],
	[3.6515000000E+04, 1.4060512087E+00, 1.6329097862E+00, 8.6166994137E-02, 7.7345579481E-02, 7.9773667766E-01],
	[3.6520000000E+04, 1.4063572323E+00, 1.6328881939E+00, 8.6202741006E-02, 7.7375258598E-02, 7.9776422648E-01],
	[3.6525000000E+04, 1.4066632805E+00, 1.6328666049E+00, 8.6238497808E-02, 7.7404944275E-02, 7.9779177405E-01],
	[3.6530000000E+04, 1.4069693534E+00, 1.6328450191E+00, 8.6274264544E-02, 7.7434636514E-02, 7.9781932035E-01],
	[3.6535000000E+04, 1.4072754509E+00, 1.6328234365E+00, 8.6310041216E-02, 7.7464335313E-02, 7.9784686538E-01],
	[3.6540000000E+04, 1.4075815732E+00, 1.6328018572E+00, 8.6345827826E-02, 7.7494040673E-02, 7.9787440914E-01],
	[3.6545000000E+04, 1.4078877202E+00, 1.6327802812E+00, 8.6381624373E-02, 7.7523752594E-02, 7.9790195164E-01],
	[3.6550000000E+04, 1.4081938919E+00, 1.6327587083E+00, 8.6417430861E-02, 7.7553471076E-02, 7.9792949287E-01],
	[3.6555000000E+04, 1.4085000882E+00, 1.6327371388E+00, 8.6453247290E-02, 7.7583196118E-02, 7.9795703283E-01],
	[3.6560000000E+04, 1.4088063092E+00, 1.6327155724E+00, 8.6489073662E-02, 7.7612927721E-02, 7.9798457152E-01],
	[3.6565000000E+04, 1.4091125550E+00, 1.6326940093E+00, 8.6524909978E-02, 7.7642665885E-02, 7.9801210893E-01],
	[3.6570000000E+04, 1.4094188254E+00, 1.6326724494E+00, 8.6560756239E-02, 7.7672410609E-02, 7.9803964508E-01],
	[3.6575000000E+04, 1.4097251205E+00, 1.6326508927E+00, 8.6596612447E-02, 7.7702161894E-02, 7.9806717995E-01],
	[3.6580000000E+04, 1.4100314402E+00, 1.6326293393E+00, 8.6632478604E-02, 7.7731919740E-02, 7.9809471355E-01],
	[3.6585000000E+04, 1.4103377847E+00, 1.6326077891E+00, 8.6668354710E-02, 7.7761684147E-02, 7.9812224587E-01],
	[3.6590000000E+04, 1.4106441538E+00, 1.6325862421E+00, 8.6704240768E-02, 7.7791455114E-02, 7.9814977691E-01],
	[3.6595000000E+04, 1.4109505476E+00, 1.6325646984E+00, 8.6740136778E-02, 7.7821232642E-02, 7.9817730668E-01],
	[3.6600000000E+04, 1.4112569661E+00, 1.6325431579E+00, 8.6776042742E-02, 7.7851016731E-02, 7.9820483517E-01],
	[3.6605000000E+04, 1.4115634093E+00, 1.6325216206E+00, 8.6811958661E-02, 7.7880807380E-02, 7.9823236238E-01],
	[3.6610000000E+04, 1.4118698771E+00, 1.6325000866E+00, 8.6847884537E-02, 7.7910604590E-02, 7.9825988831E-01],
	[3.6615000000E+04, 1.4121763696E+00, 1.6324785557E+00, 8.6883820371E-02, 7.7940408360E-02, 7.9828741296E-01],
	[3.6620000000E+04, 1.4124828868E+00, 1.6324570281E+00, 8.6919766165E-02, 7.7970218691E-02, 7.9831493633E-01],
	[3.6625000000E+04, 1.4127894286E+00, 1.6324355037E+00, 8.6955721919E-02, 7.8000035583E-02, 7.9834245841E-01],
	[3.6630000000E+04, 1.4130959951E+00, 1.6324139826E+00, 8.6991687636E-02, 7.8029859035E-02, 7.9836997922E-01],
	[3.6635000000E+04, 1.4134025863E+00, 1.6323924646E+00, 8.7027663317E-02, 7.8059689048E-02, 7.9839749873E-01],
	[3.6640000000E+04, 1.4137092021E+00, 1.6323709499E+00, 8.7063648963E-02, 7.8089525621E-02, 7.9842501697E-01],
	[3.6645000000E+04, 1.4140158426E+00, 1.6323494384E+00, 8.7099644575E-02, 7.8119368755E-02, 7.9845253391E-01],
	[3.6650000000E+04, 1.4143225078E+00, 1.6323279301E+00, 8.7135650155E-02, 7.8149218450E-02, 7.9848004957E-01],
	[3.6655000000E+04, 1.4146291976E+00, 1.6323064250E+00, 8.7171665705E-02, 7.8179074704E-02, 7.9850756394E-01],
	[3.6660000000E+04, 1.4149359121E+00, 1.6322849232E+00, 8.7207691225E-02, 7.8208937520E-02, 7.9853507703E-01],
	[3.6665000000E+04, 1.4152426512E+00, 1.6322634245E+00, 8.7243726718E-02, 7.8238806896E-02, 7.9856258882E-01],
	[3.6670000000E+04, 1.4155494150E+00, 1.6322419291E+00, 8.7279772184E-02, 7.8268682832E-02, 7.9859009932E-01],
	[3.6675000000E+04, 1.4158562035E+00, 1.6322204369E+00, 8.7315827624E-02, 7.8298565329E-02, 7.9861760853E-01],
	[3.6680000000E+04, 1.4161630166E+00, 1.6321989479E+00, 8.7351893042E-02, 7.8328454386E-02, 7.9864511645E-01],
	[3.6685000000E+04, 1.4164698543E+00, 1.6321774621E+00, 8.7387968437E-02, 7.8358350004E-02, 7.9867262307E-01],
	[3.6690000000E+04, 1.4167767167E+00, 1.6321559796E+00, 8.7424053811E-02, 7.8388252182E-02, 7.9870012840E-01],
	[3.6695000000E+04, 1.4170836038E+00, 1.6321345002E+00, 8.7460149165E-02, 7.8418160920E-02, 7.9872763244E-01],
	[3.6700000000E+04, 1.4173905155E+00, 1.6321130240E+00, 8.7496254502E-02, 7.8448076219E-02, 7.9875513518E-01],
	[3.6705000000E+04, 1.4176974518E+00, 1.6320915511E+00, 8.7532369821E-02, 7.8477998078E-02, 7.9878263662E-01],
	[3.6710000000E+04, 1.4180044128E+00, 1.6320700814E+00, 8.7568495126E-02, 7.8507926497E-02, 7.9881013676E-01],
	[3.6715000000E+04, 1.4183113984E+00, 1.6320486148E+00, 8.7604630417E-02, 7.8537861477E-02, 7.9883763561E-01],
	[3.6720000000E+04, 1.4186184087E+00, 1.6320271515E+00, 8.7640775695E-02, 7.8567803016E-02, 7.9886513315E-01],
	[3.6725000000E+04, 1.4189254437E+00, 1.6320056914E+00, 8.7676930962E-02, 7.8597751117E-02, 7.9889262939E-01],
	[3.6730000000E+04, 1.4192325032E+00, 1.6319842345E+00, 8.7713096220E-02, 7.8627705777E-02, 7.9892012434E-01],
	[3.6735000000E+04, 1.4195395874E+00, 1.6319627808E+00, 8.7749271469E-02, 7.8657666998E-02, 7.9894761798E-01],
	[3.6740000000E+04, 1.4198466962E+00, 1.6319413302E+00, 8.7785456711E-02, 7.8687634778E-02, 7.9897511031E-01],
	[3.6745000000E+04, 1.4201538297E+00, 1.6319198829E+00, 8.7821651948E-02, 7.8717609119E-02, 7.9900260134E-01],
	[3.6750000000E+04, 1.4204609878E+00, 1.6318984388E+00, 8.7857857181E-02, 7.8747590020E-02, 7.9903009107E-01],
	[3.6755000000E+04, 1.4207681706E+00, 1.6318769979E+00, 8.7894072411E-02, 7.8777577481E-02, 7.9905757949E-01],
	[3.6760000000E+04, 1.4210753779E+00, 1.6318555602E+00, 8.7930297640E-02, 7.8807571503E-02, 7.9908506661E-01],
	[3.6765000000E+04, 1.4213826099E+00, 1.6318341257E+00, 8.7966532869E-02, 7.8837572084E-02, 7.9911255241E-01],
	[3.6770000000E+04, 1.4216898666E+00, 1.6318126944E+00, 8.8002778099E-02, 7.8867579225E-02, 7.9914003691E-01],
	[3.6775000000E+04, 1.4219971478E+00, 1.6317912662E+00, 8.8039033332E-02, 7.8897592927E-02, 7.9916752010E-01],
	[3.6780000000E+04, 1.4223044537E+00, 1.6317698413E+00, 8.8075298570E-02, 7.8927613188E-02, 7.9919500197E-01],
	[3.6785000000E+04, 1.4226117842E+00, 1.6317484196E+00, 8.8111573814E-02, 7.8957640010E-02, 7.9922248254E-01],
	[3.6790000000E+04, 1.4229191393E+00, 1.6317270010E+00, 8.8147859064E-02, 7.8987673391E-02, 7.9924996179E-01],
	[3.6795000000E+04, 1.4232265191E+00, 1.6317055857E+00, 8.8184154323E-02, 7.9017713332E-02, 7.9927743973E-01],
	[3.6800000000E+04, 1.4235339235E+00, 1.6316841735E+00, 8.8220459592E-02, 7.9047759833E-02, 7.9930491636E-01],
	[3.6805000000E+04, 1.4238413525E+00, 1.6316627645E+00, 8.8256774873E-02, 7.9077812894E-02, 7.9933239167E-01],
	[3.6810000000E+04, 1.4241487545E+00, 1.6316416158E+00, 8.8293100166E-02, 7.9107872960E-02, 7.9935986566E-01],
	[3.6815000000E+04, 1.4244560479E+00, 1.6316211338E+00, 8.8329435473E-02, 7.9137940737E-02, 7.9938733834E-01],
	[3.6820000000E+04, 1.4247633659E+00, 1.6316006547E+00, 8.8365780796E-02, 7.9168015075E-02, 7.9941480970E-01],
	[3.6825000000E+04, 1.4250707084E+00, 1.6315801787E+00, 8.8402136135E-02, 7.9198095976E-02, 7.9944227974E-01],
	[3.6830000000E+04, 1.4253780755E+00, 1.6315597057E+00, 8.8438501493E-02, 7.9228183439E-02, 7.9946974846E-01],
	[3.6835000000E+04, 1.4256854672E+00, 1.6315392358E+00, 8.8474876871E-02, 7.9258277464E-02, 7.9949721586E-01],
	[3.6840000000E+04, 1.4259928834E+00, 1.6315187689E+00, 8.8511262270E-02, 7.9288378052E-02, 7.9952468194E-01],
	[3.6845000000E+04, 1.4263003241E+00, 1.6314983051E+00, 8.8547657691E-02, 7.9318485201E-02, 7.9955214670E-01],
	[3.6850000000E+04, 1.4266077894E+00, 1.6314778442E+00, 8.8584063137E-02, 7.9348598913E-02, 7.9957961013E-01],
	[3.6855000000E+04, 1.4269152793E+00, 1.6314573864E+00, 8.8620478607E-02, 7.9378719187E-02, 7.9960707224E-01],
	[3.6860000000E+04, 1.4272227937E+00, 1.6314369317E+00, 8.8656904105E-02, 7.9408846023E-02, 7.9963453303E-01],
	[3.6865000000E+04, 1.4275303327E+00, 1.6314164799E+00, 8.8693339630E-02, 7.9438979421E-02, 7.9966199249E-01],
	[3.6870000000E+04, 1.4278378962E+00, 1.6313960312E+00, 8.8729785185E-02, 7.9469119381E-02, 7.9968945062E-01],
	[3.6875000000E+04, 1.4281454842E+00, 1.6313755856E+00, 8.8766240771E-02, 7.9499265903E-02, 7.9971690742E-01],
	[3.6880000000E+04, 1.4284530968E+00, 1.6313551429E+00, 8.8802706389E-02, 7.9529418987E-02, 7.9974436290E-01],
	[3.6885000000E+04, 1.4287607340E+00, 1.6313347033E+00, 8.8839182041E-02, 7.9559578633E-02, 7.9977181705E-01],
	[3.6890000000E+04, 1.4290683957E+00, 1.6313142667E+00, 8.8875667728E-02, 7.9589744841E-02, 7.9979926987E-01],
	[3.6895000000E+04, 1.4293760819E+00, 1.6312938332E+00, 8.8912163452E-02, 7.9619917611E-02, 7.9982672135E-01],
	[3.6900000000E+04, 1.4296837926E+00, 1.6312734026E+00, 8.8948669214E-02, 7.9650096942E-02, 7.9985417151E-01],
	[3.6905000000E+04, 1.4299915279E+00, 1.6312529751E+00, 8.8985185014E-02, 7.9680282836E-02, 7.9988162033E-01],
	[3.6910000000E+04, 1.4302992878E+00, 1.6312325506E+00, 8.9021710856E-02, 7.9710475291E-02, 7.9990906781E-01],
	[3.6915000000E+04, 1.4306070721E+00, 1.6312121291E+00, 8.9058246740E-02, 7.9740674308E-02, 7.9993651397E-01],
	[3.6920000000E+04, 1.4309148810E+00, 1.6311917107E+00, 8.9094792667E-02, 7.9770879887E-02, 7.9996395878E-01],
	[3.6925000000E+04, 1.4312227145E+00, 1.6311712953E+00, 8.9131348639E-02, 7.9801092027E-02, 7.9999140226E-01],
	[3.6930000000E+04, 1.4315305724E+00, 1.6311508829E+00, 8.9167914658E-02, 7.9831310729E-02, 8.0001884441E-01],
	[3.6935000000E+04, 1.4318384549E+00, 1.6311304735E+00, 8.9204490724E-02, 7.9861535993E-02, 8.0004628521E-01],
	[3.6940000000E+04, 1.4321463619E+00, 1.6311100671E+00, 8.9241076840E-02, 7.9891767818E-02, 8.0007372468E-01],
	[3.6945000000E+04, 1.4324542935E+00, 1.6310896637E+00, 8.9277673005E-02, 7.9922006205E-02, 8.0010116280E-01],
	[3.6950000000E+04, 1.4327622495E+00, 1.6310692634E+00, 8.9314279223E-02, 7.9952251153E-02, 8.0012859959E-01],
	[3.6955000000E+04, 1.4330702301E+00, 1.6310488661E+00, 8.9350895495E-02, 7.9982502663E-02, 8.0015603503E-01],
	[3.6960000000E+04, 1.4333782352E+00, 1.6310284718E+00, 8.9387521820E-02, 8.0012760734E-02, 8.0018346913E-01],
	[3.6965000000E+04, 1.4336862649E+00, 1.6310080805E+00, 8.9424158203E-02, 8.0043025367E-02, 8.0021090189E-01],
	[3.6970000000E+04, 1.4339943190E+00, 1.6309876922E+00, 8.9460804642E-02, 8.0073296561E-02, 8.0023833330E-01],
	[3.6975000000E+04, 1.4343023977E+00, 1.6309673069E+00, 8.9497461141E-02, 8.0103574316E-02, 8.0026576337E-01],
	[3.6980000000E+04, 1.4346105009E+00, 1.6309469247E+00, 8.9534127700E-02, 8.0133858633E-02, 8.0029319209E-01],
	[3.6985000000E+04, 1.4349186286E+00, 1.6309265454E+00, 8.9570804320E-02, 8.0164149511E-02, 8.0032061946E-01],
	[3.6990000000E+04, 1.4352267808E+00, 1.6309061692E+00, 8.9607491004E-02, 8.0194446950E-02, 8.0034804549E-01],
	[3.6995000000E+04, 1.4355349575E+00, 1.6308857959E+00, 8.9644187752E-02, 8.0224750951E-02, 8.0037547017E-01],
	[3.7000000000E+04, 1.4358431588E+00, 1.6308654257E+00, 8.9680894566E-02, 8.0255061512E-02, 8.0040289349E-01],
	[3.7005000000E+04, 1.4361513845E+00, 1.6308450585E+00, 8.9717611448E-02, 8.0285378635E-02, 8.0043031547E-01],
	[3.7010000000E+04, 1.4364596348E+00, 1.6308246943E+00, 8.9754338398E-02, 8.0315702319E-02, 8.0045773610E-01],
	[3.7015000000E+04, 1.4367679095E+00, 1.6308043331E+00, 8.9791075418E-02, 8.0346032564E-02, 8.0048515537E-01],
	[3.7020000000E+04, 1.4370762088E+00, 1.6307839749E+00, 8.9827822510E-02, 8.0376369370E-02, 8.0051257329E-01],
	[3.7025000000E+04, 1.4373845326E+00, 1.6307636197E+00, 8.9864579675E-02, 8.0406712736E-02, 8.0053998985E-01],
	[3.7030000000E+04, 1.4376928808E+00, 1.6307432675E+00, 8.9901346914E-02, 8.0437062664E-02, 8.0056740506E-01],
	[3.7035000000E+04, 1.4380012536E+00, 1.6307229183E+00, 8.9938124229E-02, 8.0467419153E-02, 8.0059481892E-01],
	[3.7040000000E+04, 1.4383096509E+00, 1.6307025721E+00, 8.9974911621E-02, 8.0497782202E-02, 8.0062223142E-01],
	[3.7045000000E+04, 1.4386180727E+00, 1.6306822289E+00, 9.0011709092E-02, 8.0528151812E-02, 8.0064964256E-01],
	[3.7050000000E+04, 1.4389265189E+00, 1.6306618887E+00, 9.0048516642E-02, 8.0558527984E-02, 8.0067705234E-01],
	[3.7055000000E+04, 1.4392349897E+00, 1.6306415516E+00, 9.0085334274E-02, 8.0588910715E-02, 8.0070446076E-01],
	[3.7060000000E+04, 1.4395434850E+00, 1.6306212174E+00, 9.0122161989E-02, 8.0619300008E-02, 8.0073186783E-01],
	[3.7065000000E+04, 1.4398520047E+00, 1.6306008862E+00, 9.0158999788E-02, 8.0649695861E-02, 8.0075927353E-01],
	[3.7070000000E+04, 1.4401605490E+00, 1.6305805580E+00, 9.0195847672E-02, 8.0680098274E-02, 8.0078667787E-01],
	[3.7075000000E+04, 1.4404691177E+00, 1.6305602328E+00, 9.0232705643E-02, 8.0710507249E-02, 8.0081408084E-01],
	[3.7080000000E+04, 1.4407777109E+00, 1.6305399105E+00, 9.0269573703E-02, 8.0740922783E-02, 8.0084148245E-01],
	[3.7085000000E+04, 1.4410863287E+00, 1.6305195913E+00, 9.0306451852E-02, 8.0771344878E-02, 8.0086888270E-01],
	[3.7090000000E+04, 1.4413949709E+00, 1.6304992751E+00, 9.0343340092E-02, 8.0801773534E-02, 8.0089628159E-01],
	[3.7095000000E+04, 1.4417036376E+00, 1.6304789619E+00, 9.0380238425E-02, 8.0832208750E-02, 8.0092367910E-01],
	[3.7100000000E+04, 1.4420123287E+00, 1.6304586516E+00, 9.0417146852E-02, 8.0862650526E-02, 8.0095107525E-01],
	[3.7105000000E+04, 1.4423210444E+00, 1.6304383444E+00, 9.0454065374E-02, 8.0893098863E-02, 8.0097847003E-01],
	[3.7110000000E+04, 1.4426297845E+00, 1.6304180401E+00, 9.0490993993E-02, 8.0923553760E-02, 8.0100586344E-01],
	[3.7115000000E+04, 1.4429385491E+00, 1.6303977388E+00, 9.0527932710E-02, 8.0954015217E-02, 8.0103325549E-01],
	[3.7120000000E+04, 1.4432473382E+00, 1.6303774405E+00, 9.0564881527E-02, 8.0984483234E-02, 8.0106064616E-01],
	[3.7125000000E+04, 1.4435561518E+00, 1.6303571452E+00, 9.0601840445E-02, 8.1014957811E-02, 8.0108803546E-01],
	[3.7130000000E+04, 1.4438649898E+00, 1.6303368529E+00, 9.0638809465E-02, 8.1045438948E-02, 8.0111542338E-01],
	[3.7135000000E+04, 1.4441738524E+00, 1.6303165636E+00, 9.0675788588E-02, 8.1075926646E-02, 8.0114280994E-01],
	[3.7140000000E+04, 1.4444827394E+00, 1.6302962772E+00, 9.0712777817E-02, 8.1106420903E-02, 8.0117019512E-01],
	[3.7145000000E+04, 1.4447916508E+00, 1.6302759939E+00, 9.0749777153E-02, 8.1136921720E-02, 8.0119757892E-01],
	[3.7150000000E+04, 1.4451005868E+00, 1.6302557135E+00, 9.0786786596E-02, 8.1167429097E-02, 8.0122496135E-01],
	[3.7155000000E+04, 1.4454095472E+00, 1.6302354361E+00, 9.0823806149E-02, 8.1197943034E-02, 8.0125234240E-01],
	[3.7160000000E+04, 1.4457185320E+00, 1.6302151617E+00, 9.0860835812E-02, 8.1228463530E-02, 8.0127972208E-01],
	[3.7165000000E+04, 1.4460275414E+00, 1.6301948902E+00, 9.0897875587E-02, 8.1258990586E-02, 8.0130710037E-01],
	[3.7170000000E+04, 1.4463365752E+00, 1.6301746218E+00, 9.0934925477E-02, 8.1289524202E-02, 8.0133447729E-01],
	[3.7175000000E+04, 1.4466456335E+00, 1.6301543563E+00, 9.0971985481E-02, 8.1320064378E-02, 8.0136185283E-01],
	[3.7180000000E+04, 1.4469547162E+00, 1.6301340938E+00, 9.1009055601E-02, 8.1350611113E-02, 8.0138922698E-01],
	[3.7185000000E+04, 1.4472638234E+00, 1.6301138342E+00, 9.1046135839E-02, 8.1381164408E-02, 8.0141659976E-01],
	[3.7190000000E+04, 1.4475729550E+00, 1.6300935777E+00, 9.1083226196E-02, 8.1411724262E-02, 8.0144397115E-01],
	[3.7195000000E+04, 1.4478821111E+00, 1.6300733241E+00, 9.1120326674E-02, 8.1442290675E-02, 8.0147134115E-01],
	[3.7200000000E+04, 1.4481912917E+00, 1.6300530735E+00, 9.1157437274E-02, 8.1472863648E-02, 8.0149870977E-01],
	[3.7205000000E+04, 1.4485004967E+00, 1.6300328259E+00, 9.1194557997E-02, 8.1503443180E-02, 8.0152607701E-01],
	[3.7210000000E+04, 1.4488097262E+00, 1.6300125812E+00, 9.1231688845E-02, 8.1534029271E-02, 8.0155344286E-01],
	[3.7215000000E+04, 1.4491189801E+00, 1.6299923395E+00, 9.1268829819E-02, 8.1564621922E-02, 8.0158080732E-01],
	[3.7220000000E+04, 1.4494282585E+00, 1.6299721008E+00, 9.1305980920E-02, 8.1595221132E-02, 8.0160817040E-01],
	[3.7225000000E+04, 1.4497375613E+00, 1.6299518651E+00, 9.1343142151E-02, 8.1625826900E-02, 8.0163553209E-01],
	[3.7230000000E+04, 1.4500468886E+00, 1.6299316323E+00, 9.1380313512E-02, 8.1656439228E-02, 8.0166289238E-01],
	[3.7235000000E+04, 1.4503562403E+00, 1.6299114025E+00, 9.1417495004E-02, 8.1687058115E-02, 8.0169025129E-01],
	[3.7240000000E+04, 1.4506656165E+00, 1.6298911756E+00, 9.1454686630E-02, 8.1717683561E-02, 8.0171760880E-01],
	[3.7245000000E+04, 1.4509750171E+00, 1.6298709518E+00, 9.1491888390E-02, 8.1748315565E-02, 8.0174496493E-01],
	[3.7250000000E+04, 1.4512844421E+00, 1.6298507308E+00, 9.1529100287E-02, 8.1778954129E-02, 8.0177231965E-01],
	[3.7255000000E+04, 1.4515938916E+00, 1.6298305129E+00, 9.1566322320E-02, 8.1809599251E-02, 8.0179967299E-01],
	[3.7260000000E+04, 1.4519033656E+00, 1.6298102979E+00, 9.1603554493E-02, 8.1840250932E-02, 8.0182702493E-01],
	[3.7265000000E+04, 1.4522128640E+00, 1.6297900859E+00, 9.1640796805E-02, 8.1870909171E-02, 8.0185437547E-01],
	[3.7270000000E+04, 1.4525223868E+00, 1.6297698768E+00, 9.1678049259E-02, 8.1901573969E-02, 8.0188172462E-01],
	[3.7275000000E+04, 1.4528319340E+00, 1.6297496707E+00, 9.1715311856E-02, 8.1932245326E-02, 8.0190907237E-01],
	[3.7280000000E+04, 1.4531415057E+00, 1.6297294676E+00, 9.1752584598E-02, 8.1962923241E-02, 8.0193641872E-01],
	[3.7285000000E+04, 1.4534511018E+00, 1.6297092674E+00, 9.1789867485E-02, 8.1993607714E-02, 8.0196376367E-01],
	[3.7290000000E+04, 1.4537607224E+00, 1.6296890702E+00, 9.1827160519E-02, 8.2024298746E-02, 8.0199110723E-01],
	[3.7295000000E+04, 1.4540703674E+00, 1.6296688760E+00, 9.1864463702E-02, 8.2054996336E-02, 8.0201844938E-01],
	[3.7300000000E+04, 1.4543800368E+00, 1.6296486847E+00, 9.1901777035E-02, 8.2085700485E-02, 8.0204579013E-01],
	[3.7305000000E+04, 1.4546897306E+00, 1.6296284963E+00, 9.1939100519E-02, 8.2116411191E-02, 8.0207312948E-01],
	[3.7310000000E+04, 1.4549994489E+00, 1.6296083109E+00, 9.1976434156E-02, 8.2147128456E-02, 8.0210046742E-01],
	[3.7315000000E+04, 1.4553091916E+00, 1.6295881285E+00, 9.2013777947E-02, 8.2177852278E-02, 8.0212780396E-01],
	[3.7320000000E+04, 1.4556189587E+00, 1.6295679490E+00, 9.2051131894E-02, 8.2208582659E-02, 8.0215513909E-01],
	[3.7325000000E+04, 1.4559287502E+00, 1.6295477725E+00, 9.2088495997E-02, 8.2239319598E-02, 8.0218247282E-01],
	[3.7330000000E+04, 1.4562385662E+00, 1.6295275989E+00, 9.2125870259E-02, 8.2270063094E-02, 8.0220980514E-01],
	[3.7335000000E+04, 1.4565484066E+00, 1.6295074283E+00, 9.2163254681E-02, 8.2300813149E-02, 8.0223713606E-01],
	[3.7340000000E+04, 1.4568582714E+00, 1.6294872606E+00, 9.2200649264E-02, 8.2331569761E-02, 8.0226446556E-01],
	[3.7345000000E+04, 1.4571681606E+00, 1.6294670959E+00, 9.2238054010E-02, 8.2362332930E-02, 8.0229179366E-01],
	[3.7350000000E+04, 1.4574780743E+00, 1.6294469342E+00, 9.2275468919E-02, 8.2393102658E-02, 8.0231912034E-01],
	[3.7355000000E+04, 1.4577880123E+00, 1.6294267753E+00, 9.2312893994E-02, 8.2423878943E-02, 8.0234644561E-01],
	[3.7360000000E+04, 1.4580979748E+00, 1.6294066195E+00, 9.2350329235E-02, 8.2454661785E-02, 8.0237376948E-01],
	[3.7365000000E+04, 1.4584079616E+00, 1.6293864665E+00, 9.2387774645E-02, 8.2485451185E-02, 8.0240109193E-01],
	[3.7370000000E+04, 1.4587179729E+00, 1.6293663165E+00, 9.2425230224E-02, 8.2516247142E-02, 8.0242841296E-01],
	[3.7375000000E+04, 1.4590280086E+00, 1.6293461695E+00, 9.2462695975E-02, 8.2547049657E-02, 8.0245573258E-01],
	[3.7380000000E+04, 1.4593380687E+00, 1.6293260254E+00, 9.2500171897E-02, 8.2577858728E-02, 8.0248305079E-01],
	[3.7385000000E+04, 1.4596481532E+00, 1.6293058843E+00, 9.2537657994E-02, 8.2608674357E-02, 8.0251036758E-01],
	[3.7390000000E+04, 1.4599582622E+00, 1.6292857461E+00, 9.2575154265E-02, 8.2639496543E-02, 8.0253768295E-01],
	[3.7395000000E+04, 1.4602683955E+00, 1.6292656108E+00, 9.2612660714E-02, 8.2670325286E-02, 8.0256499690E-01],
	[3.7400000000E+04, 1.4605785532E+00, 1.6292454785E+00, 9.2650177340E-02, 8.2701160586E-02, 8.0259230944E-01],
	[3.7405000000E+04, 1.4608887232E+00, 1.6292260434E+00, 9.2687704145E-02, 8.2732004195E-02, 8.0261962055E-01],
	[3.7410000000E+04, 1.4611989138E+00, 1.6292068239E+00, 9.2725241131E-02, 8.2762854899E-02, 8.0264693025E-01],
	[3.7415000000E+04, 1.4615091288E+00, 1.6291876071E+00, 9.2762788300E-02, 8.2793712163E-02, 8.0267423852E-01],
	[3.7420000000E+04, 1.4618193681E+00, 1.6291683931E+00, 9.2800345652E-02, 8.2824575988E-02, 8.0270154538E-01],
	[3.7425000000E+04, 1.4621296319E+00, 1.6291491819E+00, 9.2837913189E-02, 8.2855446372E-02, 8.0272885080E-01],
	[3.7430000000E+04, 1.4624399201E+00, 1.6291299735E+00, 9.2875490912E-02, 8.2886323315E-02, 8.0275615481E-01],
	[3.7435000000E+04, 1.4627502327E+00, 1.6291107679E+00, 9.2913078823E-02, 8.2917206819E-02, 8.0278345739E-01],
	[3.7440000000E+04, 1.4630605696E+00, 1.6290915651E+00, 9.2950676924E-02, 8.2948096882E-02, 8.0281075854E-01],
	[3.7445000000E+04, 1.4633709309E+00, 1.6290723650E+00, 9.2988285215E-02, 8.2978993505E-02, 8.0283805827E-01],
	[3.7450000000E+04, 1.4636813167E+00, 1.6290531678E+00, 9.3025903698E-02, 8.3009896687E-02, 8.0286535657E-01],
	[3.7455000000E+04, 1.4639917268E+00, 1.6290339733E+00, 9.3063532374E-02, 8.3040806429E-02, 8.0289265345E-01],
	[3.7460000000E+04, 1.4643021612E+00, 1.6290147817E+00, 9.3101171245E-02, 8.3071722730E-02, 8.0291994889E-01],
	[3.7465000000E+04, 1.4646126201E+00, 1.6289955928E+00, 9.3138820312E-02, 8.3102645590E-02, 8.0294724290E-01],
	[3.7470000000E+04, 1.4649231033E+00, 1.6289764067E+00, 9.3176479577E-02, 8.3133575009E-02, 8.0297453549E-01],
	[3.7475000000E+04, 1.4652336110E+00, 1.6289572234E+00, 9.3214149041E-02, 8.3164510988E-02, 8.0300182664E-01],
	[3.7480000000E+04, 1.4655441430E+00, 1.6289380429E+00, 9.3251828705E-02, 8.3195453526E-02, 8.0302911636E-01],
	[3.7485000000E+04, 1.4658546993E+00, 1.6289188652E+00, 9.3289518571E-02, 8.3226402622E-02, 8.0305640465E-01],
	[3.7490000000E+04, 1.4661652801E+00, 1.6288996902E+00, 9.3327218640E-02, 8.3257358278E-02, 8.0308369150E-01],
	[3.7495000000E+04, 1.4664758852E+00, 1.6288805181E+00, 9.3364928914E-02, 8.3288320493E-02, 8.0311097692E-01],
	[3.7500000000E+04, 1.4667865147E+00, 1.6288613487E+00, 9.3402649393E-02, 8.3319289266E-02, 8.0313826090E-01],
	[3.7505000000E+04, 1.4670971686E+00, 1.6288421821E+00, 9.3440380080E-02, 8.3350264598E-02, 8.0316554345E-01],
	[3.7510000000E+04, 1.4674078468E+00, 1.6288230183E+00, 9.3478120976E-02, 8.3381246489E-02, 8.0319282455E-01],
	[3.7515000000E+04, 1.4677185494E+00, 1.6288038572E+00, 9.3515872082E-02, 8.3412234938E-02, 8.0322010422E-01],
	[3.7520000000E+04, 1.4680292764E+00, 1.6287846990E+00, 9.3553633400E-02, 8.3443229946E-02, 8.0324738246E-01],
	[3.7525000000E+04, 1.4683400277E+00, 1.6287655435E+00, 9.3591404931E-02, 8.3474231512E-02, 8.0327465925E-01],
	[3.7530000000E+04, 1.4686508034E+00, 1.6287463908E+00, 9.3629186676E-02, 8.3505239637E-02, 8.0330193460E-01],
	[3.7535000000E+04, 1.4689616034E+00, 1.6287272408E+00, 9.3666978637E-02, 8.3536254320E-02, 8.0332920851E-01],
	[3.7540000000E+04, 1.4692724278E+00, 1.6287080937E+00, 9.3704780815E-02, 8.3567275561E-02, 8.0335648097E-01],
	[3.7545000000E+04, 1.4695832766E+00, 1.6286889493E+00, 9.3742593211E-02, 8.3598303361E-02, 8.0338375200E-01],
	[3.7550000000E+04, 1.4698941498E+00, 1.6286698077E+00, 9.3780415828E-02, 8.3629337718E-02, 8.0341102158E-01],
	[3.7555000000E+04, 1.4702050472E+00, 1.6286506689E+00, 9.3818248666E-02, 8.3660378633E-02, 8.0343828971E-01],
	[3.7560000000E+04, 1.4705159691E+00, 1.6286315328E+00, 9.3856091727E-02, 8.3691426107E-02, 8.0346555640E-01],
	[3.7565000000E+04, 1.4708269153E+00, 1.6286123995E+00, 9.3893945012E-02, 8.3722480138E-02, 8.0349282164E-01],
	[3.7570000000E+04, 1.4711378858E+00, 1.6285932690E+00, 9.3931808522E-02, 8.3753540727E-02, 8.0352008544E-01],
	[3.7575000000E+04, 1.4714488807E+00, 1.6285741413E+00, 9.3969682260E-02, 8.3784607874E-02, 8.0354734779E-01],
	[3.7580000000E+04, 1.4717599000E+00, 1.6285550163E+00, 9.4007566226E-02, 8.3815681578E-02, 8.0357460869E-01],
	[3.7585000000E+04, 1.4720709436E+00, 1.6285358941E+00, 9.4045460422E-02, 8.3846761840E-02, 8.0360186813E-01],
	[3.7590000000E+04, 1.4723820115E+00, 1.6285167746E+00, 9.4083364849E-02, 8.3877848659E-02, 8.0362912613E-01],
	[3.7595000000E+04, 1.4726931038E+00, 1.6284976580E+00, 9.4121279508E-02, 8.3908942036E-02, 8.0365638268E-01],
	[3.7600000000E+04, 1.4730042205E+00, 1.6284785441E+00, 9.4159204402E-02, 8.3940041970E-02, 8.0368363777E-01],
	[3.7605000000E+04, 1.4733153614E+00, 1.6284594329E+00, 9.4197139531E-02, 8.3971148461E-02, 8.0371089141E-01],
	[3.7610000000E+04, 1.4736265268E+00, 1.6284403246E+00, 9.4235084897E-02, 8.4002261510E-02, 8.0373814360E-01],
	[3.7615000000E+04, 1.4739377164E+00, 1.6284212190E+00, 9.4273040501E-02, 8.4033381115E-02, 8.0376539433E-01],
	[3.7620000000E+04, 1.4742489304E+00, 1.6284021161E+00, 9.4311006345E-02, 8.4064507277E-02, 8.0379264361E-01],
	[3.7625000000E+04, 1.4745601688E+00, 1.6283830160E+00, 9.4348982429E-02, 8.4095639997E-02, 8.0381989142E-01],
	[3.7630000000E+04, 1.4748714315E+00, 1.6283639187E+00, 9.4386968756E-02, 8.4126779273E-02, 8.0384713779E-01],
	[3.7635000000E+04, 1.4751827185E+00, 1.6283448241E+00, 9.4424965327E-02, 8.4157925106E-02, 8.0387438269E-01],
	[3.7640000000E+04, 1.4754940298E+00, 1.6283257323E+00, 9.4462972143E-02, 8.4189077496E-02, 8.0390162614E-01],
	[3.7645000000E+04, 1.4758053655E+00, 1.6283066433E+00, 9.4500989206E-02, 8.4220236442E-02, 8.0392886812E-01],
	[3.7650000000E+04, 1.4761167255E+00, 1.6282875570E+00, 9.4539016517E-02, 8.4251401945E-02, 8.0395610865E-01],
	[3.7655000000E+04, 1.4764281099E+00, 1.6282684735E+00, 9.4577054077E-02, 8.4282574004E-02, 8.0398334771E-01],
	[3.7660000000E+04, 1.4767395185E+00, 1.6282493927E+00, 9.4615101888E-02, 8.4313752619E-02, 8.0401058531E-01],
	[3.7665000000E+04, 1.4770509515E+00, 1.6282303147E+00, 9.4653159951E-02, 8.4344937791E-02, 8.0403782145E-01],
	[3.7670000000E+04, 1.4773624088E+00, 1.6282112395E+00, 9.4691228268E-02, 8.4376129519E-02, 8.0406505612E-01],
	[3.7675000000E+04, 1.4776738905E+00, 1.6281921670E+00, 9.4729306840E-02, 8.4407327803E-02, 8.0409228933E-01],
	[3.7680000000E+04, 1.4779853965E+00, 1.6281730973E+00, 9.4767395668E-02, 8.4438532643E-02, 8.0411952107E-01],
	[3.7685000000E+04, 1.4782969268E+00, 1.6281540303E+00, 9.4805494754E-02, 8.4469744040E-02, 8.0414675135E-01],
	[3.7690000000E+04, 1.4786084814E+00, 1.6281349660E+00, 9.4843604099E-02, 8.4500961991E-02, 8.0417398016E-01],
	[3.7695000000E+04, 1.4789200603E+00, 1.6281159045E+00, 9.4881723705E-02, 8.4532186499E-02, 8.0420120750E-01],
	[3.7700000000E+04, 1.4792316636E+00, 1.6280968458E+00, 9.4919853573E-02, 8.4563417562E-02, 8.0422843337E-01],
	[3.7705000000E+04, 1.4795432911E+00, 1.6280777898E+00, 9.4957993704E-02, 8.4594655181E-02, 8.0425565778E-01],
	[3.7710000000E+04, 1.4798549430E+00, 1.6280587366E+00, 9.4996144100E-02, 8.4625899356E-02, 8.0428288071E-01],
	[3.7715000000E+04, 1.4801666192E+00, 1.6280396861E+00, 9.5034304763E-02, 8.4657150086E-02, 8.0431010217E-01],
	[3.7720000000E+04, 1.4804783197E+00, 1.6280206384E+00, 9.5072475693E-02, 8.4688407371E-02, 8.0433732216E-01],
	[3.7725000000E+04, 1.4807900445E+00, 1.6280015934E+00, 9.5110656892E-02, 8.4719671211E-02, 8.0436454067E-01],
	[3.7730000000E+04, 1.4811017937E+00, 1.6279825512E+00, 9.5148848361E-02, 8.4750941607E-02, 8.0439175772E-01],
	[3.7735000000E+04, 1.4814135671E+00, 1.6279635117E+00, 9.5187050103E-02, 8.4782218557E-02, 8.0441897328E-01],
	[3.7740000000E+04, 1.4817253649E+00, 1.6279444749E+00, 9.5225262117E-02, 8.4813502063E-02, 8.0444618738E-01],
	[3.7745000000E+04, 1.4820371869E+00, 1.6279254409E+00, 9.5263484406E-02, 8.4844792124E-02, 8.0447339999E-01],
	[3.7750000000E+04, 1.4823490333E+00, 1.6279064097E+00, 9.5301716972E-02, 8.4876088739E-02, 8.0450061113E-01],
	[3.7755000000E+04, 1.4826609039E+00, 1.6278873811E+00, 9.5339959814E-02, 8.4907391909E-02, 8.0452782079E-01],
	[3.7760000000E+04, 1.4829727989E+00, 1.6278683554E+00, 9.5378212936E-02, 8.4938701634E-02, 8.0455502897E-01],
	[3.7765000000E+04, 1.4832847182E+00, 1.6278493323E+00, 9.5416476337E-02, 8.4970017913E-02, 8.0458223568E-01],
	[3.7770000000E+04, 1.4835966617E+00, 1.6278303120E+00, 9.5454750021E-02, 8.5001340746E-02, 8.0460944090E-01],
	[3.7775000000E+04, 1.4839086296E+00, 1.6278112945E+00, 9.5493033987E-02, 8.5032670135E-02, 8.0463664464E-01],
	[3.7780000000E+04, 1.4842206217E+00, 1.6277922797E+00, 9.5531328238E-02, 8.5064006077E-02, 8.0466384690E-01],
	[3.7785000000E+04, 1.4845326382E+00, 1.6277732676E+00, 9.5569632775E-02, 8.5095348573E-02, 8.0469104767E-01],
	[3.7790000000E+04, 1.4848446789E+00, 1.6277542583E+00, 9.5607947599E-02, 8.5126697624E-02, 8.0471824697E-01],
	[3.7795000000E+04, 1.4851567440E+00, 1.6277352517E+00, 9.5646272711E-02, 8.5158053228E-02, 8.0474544477E-01],
	[3.7800000000E+04, 1.4854688333E+00, 1.6277162478E+00, 9.5684608114E-02, 8.5189415387E-02, 8.0477264110E-01],
	[3.7805000000E+04, 1.4857809469E+00, 1.6276972467E+00, 9.5722953808E-02, 8.5220784099E-02, 8.0479983593E-01],
	[3.7810000000E+04, 1.4860930849E+00, 1.6276782483E+00, 9.5761309795E-02, 8.5252159365E-02, 8.0482702928E-01],
	[3.7815000000E+04, 1.4864052471E+00, 1.6276592526E+00, 9.5799676076E-02, 8.5283541185E-02, 8.0485422115E-01],
	[3.7820000000E+04, 1.4867174335E+00, 1.6276402597E+00, 9.5838052653E-02, 8.5314929558E-02, 8.0488141152E-01],
	[3.7825000000E+04, 1.4870296443E+00, 1.6276212695E+00, 9.5876439526E-02, 8.5346324484E-02, 8.0490860040E-01],
	[3.7830000000E+04, 1.4873418794E+00, 1.6276022820E+00, 9.5914836699E-02, 8.5377725964E-02, 8.0493578780E-01],
	[3.7835000000E+04, 1.4876541387E+00, 1.6275832973E+00, 9.5953244171E-02, 8.5409133998E-02, 8.0496297370E-01],
	[3.7840000000E+04, 1.4879664223E+00, 1.6275643153E+00, 9.5991661944E-02, 8.5440548584E-02, 8.0499015811E-01],
	[3.7845000000E+04, 1.4882787302E+00, 1.6275453360E+00, 9.6030090020E-02, 8.5471969723E-02, 8.0501734103E-01],
	[3.7850000000E+04, 1.4885910624E+00, 1.6275263595E+00, 9.6068528401E-02, 8.5503397416E-02, 8.0504452246E-01],
	[3.7855000000E+04, 1.4889034188E+00, 1.6275073856E+00, 9.6106977086E-02, 8.5534831661E-02, 8.0507170239E-01],
	[3.7860000000E+04, 1.4892157996E+00, 1.6274884146E+00, 9.6145436079E-02, 8.5566272459E-02, 8.0509888082E-01],
	[3.7865000000E+04, 1.4895282046E+00, 1.6274694462E+00, 9.6183905379E-02, 8.5597719809E-02, 8.0512605776E-01],
	[3.7870000000E+04, 1.4898406339E+00, 1.6274504806E+00, 9.6222384990E-02, 8.5629173712E-02, 8.0515323321E-01],
	[3.7875000000E+04, 1.4901530874E+00, 1.6274315176E+00, 9.6260874911E-02, 8.5660634168E-02, 8.0518040715E-01],
	[3.7880000000E+04, 1.4904655652E+00, 1.6274125575E+00, 9.6299375145E-02, 8.5692101176E-02, 8.0520757960E-01],
	[3.7885000000E+04, 1.4907780673E+00, 1.6273936000E+00, 9.6337885693E-02, 8.5723574737E-02, 8.0523475055E-01],
	[3.7890000000E+04, 1.4910905937E+00, 1.6273746452E+00, 9.6376406556E-02, 8.5755054849E-02, 8.0526192000E-01],
	[3.7895000000E+04, 1.4914031443E+00, 1.6273556932E+00, 9.6414937735E-02, 8.5786541514E-02, 8.0528908795E-01],
	[3.7900000000E+04, 1.4917157192E+00, 1.6273367439E+00, 9.6453479233E-02, 8.5818034730E-02, 8.0531625440E-01],
	[3.7905000000E+04, 1.4920283183E+00, 1.6273177973E+00, 9.6492031050E-02, 8.5849534499E-02, 8.0534341934E-01],
	[3.7910000000E+04, 1.4923409417E+00, 1.6272988535E+00, 9.6530593189E-02, 8.5881040819E-02, 8.0537058278E-01],
	[3.7915000000E+04, 1.4926535894E+00, 1.6272799123E+00, 9.6569165649E-02, 8.5912553691E-02, 8.0539774472E-01],
	[3.7920000000E+04, 1.4929662613E+00, 1.6272609739E+00, 9.6607748433E-02, 8.5944073114E-02, 8.0542490515E-01],
	[3.7925000000E+04, 1.4932789575E+00, 1.6272420382E+00, 9.6646341542E-02, 8.5975599089E-02, 8.0545206408E-01],
	[3.7930000000E+04, 1.4935916780E+00, 1.6272231052E+00, 9.6684944978E-02, 8.6007131616E-02, 8.0547922150E-01],
	[3.7935000000E+04, 1.4939044227E+00, 1.6272041750E+00, 9.6723558741E-02, 8.6038670694E-02, 8.0550637742E-01],
	[3.7940000000E+04, 1.4942171916E+00, 1.6271852474E+00, 9.6762182834E-02, 8.6070216322E-02, 8.0553353182E-01],
	[3.7945000000E+04, 1.4945299849E+00, 1.6271663226E+00, 9.6800817257E-02, 8.6101768502E-02, 8.0556068472E-01],
	[3.7950000000E+04, 1.4948428023E+00, 1.6271474004E+00, 9.6839462013E-02, 8.6133327233E-02, 8.0558783611E-01],
	[3.7955000000E+04, 1.4951556440E+00, 1.6271284810E+00, 9.6878117102E-02, 8.6164892515E-02, 8.0561498598E-01],
	[3.7960000000E+04, 1.4954685100E+00, 1.6271095643E+00, 9.6916782526E-02, 8.6196464347E-02, 8.0564213435E-01],
	[3.7965000000E+04, 1.4957814002E+00, 1.6270906503E+00, 9.6955458286E-02, 8.6228042731E-02, 8.0566928121E-01],
	[3.7970000000E+04, 1.4960943147E+00, 1.6270717390E+00, 9.6994144384E-02, 8.6259627664E-02, 8.0569642655E-01],
	[3.7975000000E+04, 1.4964072534E+00, 1.6270528305E+00, 9.7032840821E-02, 8.6291219149E-02, 8.0572357038E-01],
	[3.7980000000E+04, 1.4967202163E+00, 1.6270339246E+00, 9.7071547598E-02, 8.6322817183E-02, 8.0575071269E-01],
	[3.7985000000E+04, 1.4970332035E+00, 1.6270150214E+00, 9.7110264718E-02, 8.6354421768E-02, 8.0577785349E-01],
	[3.7990000000E+04, 1.4973462150E+00, 1.6269961210E+00, 9.7148992180E-02, 8.6386032903E-02, 8.0580499277E-01],
	[3.7995000000E+04, 1.4976592506E+00, 1.6269772232E+00, 9.7187729988E-02, 8.6417650588E-02, 8.0583213054E-01],
	[3.8000000000E+04, 1.4979723105E+00, 1.6269583282E+00, 9.7226478141E-02, 8.6449274823E-02, 8.0585926679E-01],
	[3.8005000000E+04, 1.4982854484E+00, 1.6269397433E+00, 9.7265236642E-02, 8.6480906655E-02, 8.0588640152E-01],
	[3.8010000000E+04, 1.4985987130E+00, 1.6269217473E+00, 9.7304005492E-02, 8.6512547037E-02, 8.0591353473E-01],
	[3.8015000000E+04, 1.4989120018E+00, 1.6269037538E+00, 9.7342784692E-02, 8.6544193973E-02, 8.0594066642E-01],
	[3.8020000000E+04, 1.4992253149E+00, 1.6268857629E+00, 9.7381574244E-02, 8.6575847462E-02, 8.0596779659E-01],
	[3.8025000000E+04, 1.4995386523E+00, 1.6268677746E+00, 9.7420374149E-02, 8.6607507505E-02, 8.0599492524E-01],
	[3.8030000000E+04, 1.4998520140E+00, 1.6268497888E+00, 9.7459184408E-02, 8.6639174101E-02, 8.0602205237E-01],
	[3.8035000000E+04, 1.5001653999E+00, 1.6268318056E+00, 9.7498005023E-02, 8.6670847250E-02, 8.0604917797E-01],
	[3.8040000000E+04, 1.5004788101E+00, 1.6268138250E+00, 9.7536835996E-02, 8.6702526951E-02, 8.0607630205E-01],
	[3.8045000000E+04, 1.5007922446E+00, 1.6267958469E+00, 9.7575677327E-02, 8.6734213206E-02, 8.0610342460E-01],
	[3.8050000000E+04, 1.5011057034E+00, 1.6267778714E+00, 9.7614529019E-02, 8.6765906013E-02, 8.0613054563E-01],
	[3.8055000000E+04, 1.5014191864E+00, 1.6267598985E+00, 9.7653391072E-02, 8.6797605374E-02, 8.0615766514E-01],
	[3.8060000000E+04, 1.5017326937E+00, 1.6267419281E+00, 9.7692263488E-02, 8.6829311286E-02, 8.0618478311E-01],
	[3.8065000000E+04, 1.5020462252E+00, 1.6267239602E+00, 9.7731146268E-02, 8.6861023751E-02, 8.0621189956E-01],
	[3.8070000000E+04, 1.5023597811E+00, 1.6267059950E+00, 9.7770039414E-02, 8.6892742769E-02, 8.0623901448E-01],
	[3.8075000000E+04, 1.5026733611E+00, 1.6266880322E+00, 9.7808942927E-02, 8.6924468338E-02, 8.0626612787E-01],
	[3.8080000000E+04, 1.5029869655E+00, 1.6266700721E+00, 9.7847856808E-02, 8.6956200460E-02, 8.0629323973E-01],
	[3.8085000000E+04, 1.5033005941E+00, 1.6266521145E+00, 9.7886781060E-02, 8.6987939134E-02, 8.0632035006E-01],
	[3.8090000000E+04, 1.5036142470E+00, 1.6266341594E+00, 9.7925715683E-02, 8.7019684359E-02, 8.0634745886E-01],
	[3.8095000000E+04, 1.5039279241E+00, 1.6266162069E+00, 9.7964660678E-02, 8.7051436137E-02, 8.0637456612E-01],
	[3.8100000000E+04, 1.5042416255E+00, 1.6265982570E+00, 9.8003616048E-02, 8.7083194466E-02, 8.0640167185E-01],
	[3.8105000000E+04, 1.5045553511E+00, 1.6265803096E+00, 9.8042581793E-02, 8.7114959346E-02, 8.0642877605E-01],
	[3.8110000000E+04, 1.5048691010E+00, 1.6265623648E+00, 9.8081557915E-02, 8.7146730779E-02, 8.0645587871E-01],
	[3.8115000000E+04, 1.5051828752E+00, 1.6265444225E+00, 9.8120544415E-02, 8.7178508762E-02, 8.0648297984E-01],
	[3.8120000000E+04, 1.5054966736E+00, 1.6265264828E+00, 9.8159541296E-02, 8.7210293297E-02, 8.0651007943E-01],
	[3.8125000000E+04, 1.5058104963E+00, 1.6265085456E+00, 9.8198548557E-02, 8.7242084382E-02, 8.0653717748E-01],
	[3.8130000000E+04, 1.5061243432E+00, 1.6264906110E+00, 9.8237566201E-02, 8.7273882019E-02, 8.0656427399E-01],
	[3.8135000000E+04, 1.5064382143E+00, 1.6264726789E+00, 9.8276594228E-02, 8.7305686207E-02, 8.0659136897E-01],
	[3.8140000000E+04, 1.5067521097E+00, 1.6264547494E+00, 9.8315632641E-02, 8.7337496945E-02, 8.0661846240E-01],
	[3.8145000000E+04, 1.5070660294E+00, 1.6264368224E+00, 9.8354681441E-02, 8.7369314234E-02, 8.0664555430E-01],
	[3.8150000000E+04, 1.5073799732E+00, 1.6264188979E+00, 9.8393740629E-02, 8.7401138074E-02, 8.0667264465E-01],
	[3.8155000000E+04, 1.5076939414E+00, 1.6264009761E+00, 9.8432810207E-02, 8.7432968464E-02, 8.0669973346E-01],
	[3.8160000000E+04, 1.5080079338E+00, 1.6263830567E+00, 9.8471890175E-02, 8.7464805404E-02, 8.0672682073E-01],
	[3.8165000000E+04, 1.5083219504E+00, 1.6263651399E+00, 9.8510980536E-02, 8.7496648895E-02, 8.0675390646E-01],
	[3.8170000000E+04, 1.5086359912E+00, 1.6263472257E+00, 9.8550081290E-02, 8.7528498936E-02, 8.0678099064E-01],
	[3.8175000000E+04, 1.5089500563E+00, 1.6263293140E+00, 9.8589192440E-02, 8.7560355526E-02, 8.0680807327E-01],
	[3.8180000000E+04, 1.5092641456E+00, 1.6263114048E+00, 9.8628313986E-02, 8.7592218667E-02, 8.0683515436E-01],
	[3.8185000000E+04, 1.5095782592E+00, 1.6262934982E+00, 9.8667445930E-02, 8.7624088357E-02, 8.0686223390E-01],
	[3.8190000000E+04, 1.5098923970E+00, 1.6262755941E+00, 9.8706588274E-02, 8.7655964597E-02, 8.0688931190E-01],
	[3.8195000000E+04, 1.5102065590E+00, 1.6262576925E+00, 9.8745741018E-02, 8.7687847386E-02, 8.0691638835E-01],
	[3.8200000000E+04, 1.5105207453E+00, 1.6262397935E+00, 9.8784904165E-02, 8.7719736725E-02, 8.0694346324E-01],
	[3.8205000000E+04, 1.5108349558E+00, 1.6262218971E+00, 9.8824077715E-02, 8.7751632613E-02, 8.0697053659E-01],
	[3.8210000000E+04, 1.5111491905E+00, 1.6262040032E+00, 9.8863261669E-02, 8.7783535050E-02, 8.0699760839E-01],
	[3.8215000000E+04, 1.5114634494E+00, 1.6261861118E+00, 9.8902456031E-02, 8.7815444036E-02, 8.0702467863E-01],
	[3.8220000000E+04, 1.5117777326E+00, 1.6261682229E+00, 9.8941660800E-02, 8.7847359571E-02, 8.0705174733E-01],
	[3.8225000000E+04, 1.5120920400E+00, 1.6261503366E+00, 9.8980875978E-02, 8.7879281655E-02, 8.0707881447E-01],
	[3.8230000000E+04, 1.5124063716E+00, 1.6261324528E+00, 9.9020101567E-02, 8.7911210288E-02, 8.0710588005E-01],
	[3.8235000000E+04, 1.5127207275E+00, 1.6261145716E+00, 9.9059337568E-02, 8.7943145469E-02, 8.0713294408E-01],
	[3.8240000000E+04, 1.5130351075E+00, 1.6260966929E+00, 9.9098583982E-02, 8.7975087198E-02, 8.0716000656E-01],
	[3.8245000000E+04, 1.5133495118E+00, 1.6260788167E+00, 9.9137840811E-02, 8.8007035476E-02, 8.0718706748E-01],
	[3.8250000000E+04, 1.5136639403E+00, 1.6260609431E+00, 9.9177108056E-02, 8.8038990302E-02, 8.0721412684E-01],
	[3.8255000000E+04, 1.5139783930E+00, 1.6260430720E+00, 9.9216385718E-02, 8.8070951677E-02, 8.0724118465E-01],
	[3.8260000000E+04, 1.5142928700E+00, 1.6260252034E+00, 9.9255673800E-02, 8.8102919599E-02, 8.0726824089E-01],
	[3.8265000000E+04, 1.5146073711E+00, 1.6260073374E+00, 9.9294972302E-02, 8.8134894068E-02, 8.0729529558E-01],
	[3.8270000000E+04, 1.5149218965E+00, 1.6259894739E+00, 9.9334281226E-02, 8.8166875086E-02, 8.0732234871E-01],
	[3.8275000000E+04, 1.5152364461E+00, 1.6259716129E+00, 9.9373600572E-02, 8.8198862651E-02, 8.0734940027E-01],
	[3.8280000000E+04, 1.5155510198E+00, 1.6259537544E+00, 9.9412930344E-02, 8.8230856764E-02, 8.0737645028E-01],
	[3.8285000000E+04, 1.5158656178E+00, 1.6259358985E+00, 9.9452270541E-02, 8.8262857424E-02, 8.0740349872E-01],
	[3.8290000000E+04, 1.5161802400E+00, 1.6259180451E+00, 9.9491621166E-02, 8.8294864631E-02, 8.0743054560E-01],
	[3.8295000000E+04, 1.5164948864E+00, 1.6259001943E+00, 9.9530982220E-02, 8.8326878385E-02, 8.0745759092E-01],
	[3.8300000000E+04, 1.5168095571E+00, 1.6258823459E+00, 9.9570353704E-02, 8.8358898686E-02, 8.0748463467E-01],
	[3.8305000000E+04, 1.5171242519E+00, 1.6258645001E+00, 9.9609735619E-02, 8.8390925535E-02, 8.0751167685E-01],
	[3.8310000000E+04, 1.5174389709E+00, 1.6258466568E+00, 9.9649127968E-02, 8.8422958929E-02, 8.0753871747E-01],
	[3.8315000000E+04, 1.5177537141E+00, 1.6258288161E+00, 9.9688530750E-02, 8.8454998871E-02, 8.0756575652E-01],
	[3.8320000000E+04, 1.5180684815E+00, 1.6258109778E+00, 9.9727943969E-02, 8.8487045358E-02, 8.0759279401E-01],
	[3.8325000000E+04, 1.5183832731E+00, 1.6257931421E+00, 9.9767367625E-02, 8.8519098393E-02, 8.0761982992E-01],
	[3.8330000000E+04, 1.5186980890E+00, 1.6257753089E+00, 9.9806801719E-02, 8.8551157973E-02, 8.0764686427E-01],
	[3.8335000000E+04, 1.5190129290E+00, 1.6257574782E+00, 9.9846246254E-02, 8.8583224099E-02, 8.0767389705E-01],
	[3.8340000000E+04, 1.5193277932E+00, 1.6257396501E+00, 9.9885701229E-02, 8.8615296772E-02, 8.0770092825E-01],
	[3.8345000000E+04, 1.5196426816E+00, 1.6257218245E+00, 9.9925166648E-02, 8.8647375990E-02, 8.0772795789E-01],
	[3.8350000000E+04, 1.5199575942E+00, 1.6257040013E+00, 9.9964642511E-02, 8.8679461754E-02, 8.0775498595E-01],
	[3.8355000000E+04, 1.5202725309E+00, 1.6256861807E+00, 1.0000412882E-01, 8.8711554063E-02, 8.0778201243E-01],
	[3.8360000000E+04, 1.5205874919E+00, 1.6256683627E+00, 1.0004362557E-01, 8.8743652918E-02, 8.0780903735E-01],
	[3.8365000000E+04, 1.5209024771E+00, 1.6256505471E+00, 1.0008313278E-01, 8.8775758318E-02, 8.0783606069E-01],
	[3.8370000000E+04, 1.5212174864E+00, 1.6256327341E+00, 1.0012265043E-01, 8.8807870264E-02, 8.0786308245E-01],
	[3.8375000000E+04, 1.5215325200E+00, 1.6256149235E+00, 1.0016217854E-01, 8.8839988754E-02, 8.0789010264E-01],
	[3.8380000000E+04, 1.5218475777E+00, 1.6255971155E+00, 1.0020171709E-01, 8.8872113790E-02, 8.0791712125E-01],
	[3.8385000000E+04, 1.5221626596E+00, 1.6255793100E+00, 1.0024126611E-01, 8.8904245370E-02, 8.0794413828E-01],
	[3.8390000000E+04, 1.5224777657E+00, 1.6255615071E+00, 1.0028082557E-01, 8.8936383494E-02, 8.0797115374E-01],
	[3.8395000000E+04, 1.5227928959E+00, 1.6255437066E+00, 1.0032039550E-01, 8.8968528164E-02, 8.0799816761E-01],
	[3.8400000000E+04, 1.5231080504E+00, 1.6255259086E+00, 1.0035997588E-01, 8.9000679378E-02, 8.0802517991E-01],
	[3.8405000000E+04, 1.5234232290E+00, 1.6255081132E+00, 1.0039956672E-01, 8.9032837135E-02, 8.0805219062E-01],
	[3.8410000000E+04, 1.5237384318E+00, 1.6254903203E+00, 1.0043916802E-01, 8.9065001438E-02, 8.0807919975E-01],
	[3.8415000000E+04, 1.5240536588E+00, 1.6254725299E+00, 1.0047877979E-01, 8.9097172284E-02, 8.0810620730E-01],
	[3.8420000000E+04, 1.5243689099E+00, 1.6254547419E+00, 1.0051840202E-01, 8.9129349674E-02, 8.0813321327E-01],
	[3.8425000000E+04, 1.5246841852E+00, 1.6254369565E+00, 1.0055803471E-01, 8.9161533607E-02, 8.0816021765E-01],
	[3.8430000000E+04, 1.5249994847E+00, 1.6254191737E+00, 1.0059767787E-01, 8.9193724085E-02, 8.0818722045E-01],
	[3.8435000000E+04, 1.5253148084E+00, 1.6254013933E+00, 1.0063733150E-01, 8.9225921105E-02, 8.0821422166E-01],
	[3.8440000000E+04, 1.5256301562E+00, 1.6253836154E+00, 1.0067699560E-01, 8.9258124669E-02, 8.0824122129E-01],
	[3.8445000000E+04, 1.5259455282E+00, 1.6253658400E+00, 1.0071667017E-01, 8.9290334777E-02, 8.0826821932E-01],
	[3.8450000000E+04, 1.5262609244E+00, 1.6253480672E+00, 1.0075635521E-01, 8.9322551427E-02, 8.0829521578E-01],
	[3.8455000000E+04, 1.5265763447E+00, 1.6253302968E+00, 1.0079605072E-01, 8.9354774620E-02, 8.0832221064E-01],
	[3.8460000000E+04, 1.5268917892E+00, 1.6253125289E+00, 1.0083575671E-01, 8.9387004356E-02, 8.0834920391E-01],
	[3.8465000000E+04, 1.5272072579E+00, 1.6252947636E+00, 1.0087547318E-01, 8.9419240635E-02, 8.0837619560E-01],
	[3.8470000000E+04, 1.5275227507E+00, 1.6252770008E+00, 1.0091520012E-01, 8.9451483456E-02, 8.0840318569E-01],
	[3.8475000000E+04, 1.5278382677E+00, 1.6252592404E+00, 1.0095493755E-01, 8.9483732820E-02, 8.0843017419E-01],
	[3.8480000000E+04, 1.5281538088E+00, 1.6252414826E+00, 1.0099468545E-01, 8.9515988726E-02, 8.0845716110E-01],
	[3.8485000000E+04, 1.5284693741E+00, 1.6252237272E+00, 1.0103444384E-01, 8.9548251173E-02, 8.0848414641E-01],
	[3.8490000000E+04, 1.5287849635E+00, 1.6252059744E+00, 1.0107421271E-01, 8.9580520163E-02, 8.0851113014E-01],
	[3.8495000000E+04, 1.5291005771E+00, 1.6251882241E+00, 1.0111399206E-01, 8.9612795695E-02, 8.0853811226E-01],
	[3.8500000000E+04, 1.5294162149E+00, 1.6251704762E+00, 1.0115378190E-01, 8.9645077768E-02, 8.0856509279E-01],
	[3.8505000000E+04, 1.5297318768E+00, 1.6251527309E+00, 1.0119358223E-01, 8.9677366383E-02, 8.0859207173E-01],
	[3.8510000000E+04, 1.5300475629E+00, 1.6251349880E+00, 1.0123339305E-01, 8.9709661540E-02, 8.0861904907E-01],
	[3.8515000000E+04, 1.5303632731E+00, 1.6251172477E+00, 1.0127321436E-01, 8.9741963237E-02, 8.0864602481E-01],
	[3.8520000000E+04, 1.5306790074E+00, 1.6250995098E+00, 1.0131304616E-01, 8.9774271476E-02, 8.0867299895E-01],
	[3.8525000000E+04, 1.5309947659E+00, 1.6250817745E+00, 1.0135288845E-01, 8.9806586256E-02, 8.0869997150E-01],
	[3.8530000000E+04, 1.5313105486E+00, 1.6250640416E+00, 1.0139274124E-01, 8.9838907576E-02, 8.0872694244E-01],
	[3.8535000000E+04, 1.5316263554E+00, 1.6250463112E+00, 1.0143260452E-01, 8.9871235438E-02, 8.0875391178E-01],
	[3.8540000000E+04, 1.5319421863E+00, 1.6250285834E+00, 1.0147247830E-01, 8.9903569839E-02, 8.0878087953E-01],
	[3.8545000000E+04, 1.5322580414E+00, 1.6250108580E+00, 1.0151236258E-01, 8.9935910782E-02, 8.0880784567E-01],
	[3.8550000000E+04, 1.5325739206E+00, 1.6249931351E+00, 1.0155225736E-01, 8.9968258264E-02, 8.0883481020E-01],
	[3.8555000000E+04, 1.5328898240E+00, 1.6249754147E+00, 1.0159216264E-01, 9.0000612287E-02, 8.0886177314E-01],
	[3.8560000000E+04, 1.5332057515E+00, 1.6249576968E+00, 1.0163207843E-01, 9.0032972849E-02, 8.0888873446E-01],
	[3.8565000000E+04, 1.5335217031E+00, 1.6249399814E+00, 1.0167200472E-01, 9.0065339952E-02, 8.0891569419E-01],
	[3.8570000000E+04, 1.5338376789E+00, 1.6249222685E+00, 1.0171194152E-01, 9.0097713594E-02, 8.0894265230E-01],
	[3.8575000000E+04, 1.5341536788E+00, 1.6249045581E+00, 1.0175188882E-01, 9.0130093776E-02, 8.0896960882E-01],
	[3.8580000000E+04, 1.5344697028E+00, 1.6248868501E+00, 1.0179184663E-01, 9.0162480497E-02, 8.0899656372E-01],
	[3.8585000000E+04, 1.5347857510E+00, 1.6248691446E+00, 1.0183181495E-01, 9.0194873758E-02, 8.0902351701E-01],
	[3.8590000000E+04, 1.5351018233E+00, 1.6248514417E+00, 1.0187179378E-01, 9.0227273557E-02, 8.0905046870E-01],
	[3.8595000000E+04, 1.5354179197E+00, 1.6248337412E+00, 1.0191178313E-01, 9.0259679896E-02, 8.0907741878E-01],
	[3.8600000000E+04, 1.5357340403E+00, 1.6248160432E+00, 1.0195178299E-01, 9.0292092773E-02, 8.0910436724E-01],
	[3.8605000000E+04, 1.5360501850E+00, 1.6247983477E+00, 1.0199179337E-01, 9.0324512189E-02, 8.0913131410E-01],
	[3.8610000000E+04, 1.5363663538E+00, 1.6247806547E+00, 1.0203181426E-01, 9.0356938144E-02, 8.0915825934E-01],
	[3.8615000000E+04, 1.5366825467E+00, 1.6247629641E+00, 1.0207184567E-01, 9.0389370637E-02, 8.0918520297E-01],
	[3.8620000000E+04, 1.5369990899E+00, 1.6247461423E+00, 1.0211188760E-01, 9.0421813480E-02, 8.0921214499E-01],
	[3.8625000000E+04, 1.5373156626E+00, 1.6247293372E+00, 1.0215194006E-01, 9.0454262929E-02, 8.0923908539E-01],
	[3.8630000000E+04, 1.5376322596E+00, 1.6247125344E+00, 1.0219200303E-01, 9.0486718920E-02, 8.0926602418E-01],
	[3.8635000000E+04, 1.5379488808E+00, 1.6246957340E+00, 1.0223207653E-01, 9.0519181454E-02, 8.0929296135E-01],
	[3.8640000000E+04, 1.5382655261E+00, 1.6246789359E+00, 1.0227216056E-01, 9.0551650530E-02, 8.0931989690E-01],
	[3.8645000000E+04, 1.5385821957E+00, 1.6246621401E+00, 1.0231225511E-01, 9.0584126148E-02, 8.0934683084E-01],
	[3.8650000000E+04, 1.5388988895E+00, 1.6246453467E+00, 1.0235236019E-01, 9.0616608308E-02, 8.0937376316E-01],
	[3.8655000000E+04, 1.5392156076E+00, 1.6246285557E+00, 1.0239247580E-01, 9.0649097010E-02, 8.0940069386E-01],
	[3.8660000000E+04, 1.5395323498E+00, 1.6246117670E+00, 1.0243260194E-01, 9.0681592254E-02, 8.0942762295E-01],
	[3.8665000000E+04, 1.5398491162E+00, 1.6245949806E+00, 1.0247273861E-01, 9.0714094039E-02, 8.0945455041E-01],
	[3.8670000000E+04, 1.5401659068E+00, 1.6245781966E+00, 1.0251288582E-01, 9.0746602366E-02, 8.0948147625E-01],
	[3.8675000000E+04, 1.5404827217E+00, 1.6245614149E+00, 1.0255304356E-01, 9.0779117234E-02, 8.0950840047E-01],
	[3.8680000000E+04, 1.5407995607E+00, 1.6245446356E+00, 1.0259321184E-01, 9.0811638643E-02, 8.0953532307E-01],
	[3.8685000000E+04, 1.5411164239E+00, 1.6245278586E+00, 1.0263339066E-01, 9.0844166594E-02, 8.0956224404E-01],
	[3.8690000000E+04, 1.5414333113E+00, 1.6245110839E+00, 1.0267358002E-01, 9.0876701085E-02, 8.0958916339E-01],
	[3.8695000000E+04, 1.5417502230E+00, 1.6244943116E+00, 1.0271377992E-01, 9.0909242116E-02, 8.0961608112E-01],
	[3.8700000000E+04, 1.5420671588E+00, 1.6244775417E+00, 1.0275399036E-01, 9.0941789689E-02, 8.0964299722E-01],
	[3.8705000000E+04, 1.5423841188E+00, 1.6244607740E+00, 1.0279421134E-01, 9.0974343801E-02, 8.0966991169E-01],
	[3.8710000000E+04, 1.5427011030E+00, 1.6244440088E+00, 1.0283444287E-01, 9.1006904454E-02, 8.0969682454E-01],
	[3.8715000000E+04, 1.5430181114E+00, 1.6244272458E+00, 1.0287468495E-01, 9.1039471647E-02, 8.0972373576E-01],
	[3.8720000000E+04, 1.5433351440E+00, 1.6244104852E+00, 1.0291493757E-01, 9.1072045380E-02, 8.0975064535E-01],
	[3.8725000000E+04, 1.5436522008E+00, 1.6243937269E+00, 1.0295520075E-01, 9.1104625653E-02, 8.0977755331E-01],
	[3.8730000000E+04, 1.5439692817E+00, 1.6243769710E+00, 1.0299547447E-01, 9.1137212465E-02, 8.0980445964E-01],
	[3.8735000000E+04, 1.5442863869E+00, 1.6243602174E+00, 1.0303575875E-01, 9.1169805817E-02, 8.0983136434E-01],
	[3.8740000000E+04, 1.5446035162E+00, 1.6243434661E+00, 1.0307605358E-01, 9.1202405709E-02, 8.0985826741E-01],
	[3.8745000000E+04, 1.5449206698E+00, 1.6243267172E+00, 1.0311635896E-01, 9.1235012139E-02, 8.0988516885E-01],
	[3.8750000000E+04, 1.5452378475E+00, 1.6243099706E+00, 1.0315667490E-01, 9.1267625108E-02, 8.0991206866E-01],
	[3.8755000000E+04, 1.5455550494E+00, 1.6242932263E+00, 1.0319700140E-01, 9.1300244617E-02, 8.0993896683E-01],
	[3.8760000000E+04, 1.5458722754E+00, 1.6242764844E+00, 1.0323733846E-01, 9.1332870664E-02, 8.0996586337E-01],
	[3.8765000000E+04, 1.5461895257E+00, 1.6242597448E+00, 1.0327768608E-01, 9.1365503249E-02, 8.0999275827E-01],
	[3.8770000000E+04, 1.5465068001E+00, 1.6242430075E+00, 1.0331804426E-01, 9.1398142373E-02, 8.1001965154E-01],
	[3.8775000000E+04, 1.5468240987E+00, 1.6242262726E+00, 1.0335841300E-01, 9.1430788035E-02, 8.1004654317E-01],
	[3.8780000000E+04, 1.5471414215E+00, 1.6242095400E+00, 1.0339879231E-01, 9.1463440236E-02, 8.1007343316E-01],
	[3.8785000000E+04, 1.5474587684E+00, 1.6241928097E+00, 1.0343918219E-01, 9.1496098974E-02, 8.1010032152E-01],
	[3.8790000000E+04, 1.5477761395E+00, 1.6241760817E+00, 1.0347958263E-01, 9.1528764250E-02, 8.1012720823E-01],
	[3.8795000000E+04, 1.5480935348E+00, 1.6241593561E+00, 1.0351999364E-01, 9.1561436064E-02, 8.1015409331E-01],
	[3.8800000000E+04, 1.5484109543E+00, 1.6241426328E+00, 1.0356041522E-01, 9.1594114415E-02, 8.1018097675E-01],
	[3.8805000000E+04, 1.5487283979E+00, 1.6241259118E+00, 1.0360084738E-01, 9.1626799303E-02, 8.1020785854E-01],
	[3.8810000000E+04, 1.5490458657E+00, 1.6241091932E+00, 1.0364129010E-01, 9.1659490729E-02, 8.1023473870E-01],
	[3.8815000000E+04, 1.5493633577E+00, 1.6240924769E+00, 1.0368174341E-01, 9.1692188692E-02, 8.1026161721E-01],
	[3.8820000000E+04, 1.5496808738E+00, 1.6240757629E+00, 1.0372220728E-01, 9.1724893191E-02, 8.1028849408E-01],
	[3.8825000000E+04, 1.5499984141E+00, 1.6240590512E+00, 1.0376268174E-01, 9.1757604227E-02, 8.1031536931E-01],
	[3.8830000000E+04, 1.5503159786E+00, 1.6240423419E+00, 1.0380316677E-01, 9.1790321800E-02, 8.1034224289E-01],
	[3.8835000000E+04, 1.5506335672E+00, 1.6240256349E+00, 1.0384366238E-01, 9.1823045909E-02, 8.1036911482E-01],
	[3.8840000000E+04, 1.5509511800E+00, 1.6240089302E+00, 1.0388416858E-01, 9.1855776554E-02, 8.1039598511E-01],
	[3.8845000000E+04, 1.5512688169E+00, 1.6239922278E+00, 1.0392468536E-01, 9.1888513736E-02, 8.1042285376E-01],
	[3.8850000000E+04, 1.5515864780E+00, 1.6239755278E+00, 1.0396521272E-01, 9.1921257453E-02, 8.1044972075E-01],
	[3.8855000000E+04, 1.5519041633E+00, 1.6239588300E+00, 1.0400575067E-01, 9.1954007706E-02, 8.1047658610E-01],
	[3.8860000000E+04, 1.5522218727E+00, 1.6239421346E+00, 1.0404629921E-01, 9.1986764494E-02, 8.1050344980E-01],
	[3.8865000000E+04, 1.5525396062E+00, 1.6239254415E+00, 1.0408685833E-01, 9.2019527818E-02, 8.1053031184E-01],
	[3.8870000000E+04, 1.5528573640E+00, 1.6239087508E+00, 1.0412742805E-01, 9.2052297677E-02, 8.1055717224E-01],
	[3.8875000000E+04, 1.5531751458E+00, 1.6238920623E+00, 1.0416800835E-01, 9.2085074072E-02, 8.1058403099E-01],
	[3.8880000000E+04, 1.5534929518E+00, 1.6238753762E+00, 1.0420859925E-01, 9.2117857001E-02, 8.1061088809E-01],
	[3.8885000000E+04, 1.5538107820E+00, 1.6238586923E+00, 1.0424920074E-01, 9.2150646465E-02, 8.1063774353E-01],
	[3.8890000000E+04, 1.5541286363E+00, 1.6238420108E+00, 1.0428981283E-01, 9.2183442463E-02, 8.1066459732E-01],
	[3.8895000000E+04, 1.5544465148E+00, 1.6238253317E+00, 1.0433043552E-01, 9.2216244996E-02, 8.1069144945E-01],
	[3.8900000000E+04, 1.5547644174E+00, 1.6238086548E+00, 1.0437106880E-01, 9.2249054063E-02, 8.1071829993E-01],
	[3.8905000000E+04, 1.5550823441E+00, 1.6237919802E+00, 1.0441171268E-01, 9.2281869665E-02, 8.1074514876E-01],
	[3.8910000000E+04, 1.5554002950E+00, 1.6237753080E+00, 1.0445236717E-01, 9.2314691800E-02, 8.1077199593E-01],
	[3.8915000000E+04, 1.5557182700E+00, 1.6237586381E+00, 1.0449303226E-01, 9.2347520469E-02, 8.1079884144E-01],
	[3.8920000000E+04, 1.5560362692E+00, 1.6237419704E+00, 1.0453370795E-01, 9.2380355672E-02, 8.1082568530E-01],
	[3.8925000000E+04, 1.5563542925E+00, 1.6237253051E+00, 1.0457439425E-01, 9.2413197408E-02, 8.1085252749E-01],
	[3.8930000000E+04, 1.5566723399E+00, 1.6237086421E+00, 1.0461509115E-01, 9.2446045677E-02, 8.1087936803E-01],
	[3.8935000000E+04, 1.5569904115E+00, 1.6236919815E+00, 1.0465579866E-01, 9.2478900480E-02, 8.1090620691E-01],
	[3.8940000000E+04, 1.5573085072E+00, 1.6236753231E+00, 1.0469651678E-01, 9.2511761815E-02, 8.1093304412E-01],
	[3.8945000000E+04, 1.5576266270E+00, 1.6236586670E+00, 1.0473724552E-01, 9.2544629683E-02, 8.1095987968E-01],
	[3.8950000000E+04, 1.5579447710E+00, 1.6236420133E+00, 1.0477798486E-01, 9.2577504084E-02, 8.1098671357E-01],
	[3.8955000000E+04, 1.5582629391E+00, 1.6236253618E+00, 1.0481873482E-01, 9.2610385017E-02, 8.1101354580E-01],
	[3.8960000000E+04, 1.5585811314E+00, 1.6236087127E+00, 1.0485949540E-01, 9.2643272483E-02, 8.1104037637E-01],
	[3.8965000000E+04, 1.5588993477E+00, 1.6235920659E+00, 1.0490026659E-01, 9.2676166480E-02, 8.1106720527E-01],
	[3.8970000000E+04, 1.5592175882E+00, 1.6235754214E+00, 1.0494104840E-01, 9.2709067010E-02, 8.1109403251E-01],
	[3.8975000000E+04, 1.5595358528E+00, 1.6235587791E+00, 1.0498184083E-01, 9.2741974071E-02, 8.1112085808E-01],
	[3.8980000000E+04, 1.5598541416E+00, 1.6235421392E+00, 1.0502264388E-01, 9.2774887664E-02, 8.1114768199E-01],
	[3.8985000000E+04, 1.5601724544E+00, 1.6235255016E+00, 1.0506345755E-01, 9.2807807789E-02, 8.1117450423E-01],
	[3.8990000000E+04, 1.5604907914E+00, 1.6235088663E+00, 1.0510428184E-01, 9.2840734444E-02, 8.1120132480E-01],
	[3.8995000000E+04, 1.5608091525E+00, 1.6234922333E+00, 1.0514511676E-01, 9.2873667631E-02, 8.1122814370E-01],
	[3.9000000000E+04, 1.5611275378E+00, 1.6234756026E+00, 1.0518596231E-01, 9.2906607349E-02, 8.1125496093E-01],
	[3.9005000000E+04, 1.5614459471E+00, 1.6234589742E+00, 1.0522681849E-01, 9.2939553597E-02, 8.1128177650E-01],
	[3.9010000000E+04, 1.5617643806E+00, 1.6234423481E+00, 1.0526768529E-01, 9.2972506376E-02, 8.1130859039E-01],
	[3.9015000000E+04, 1.5620828382E+00, 1.6234257244E+00, 1.0530856272E-01, 9.3005465686E-02, 8.1133540261E-01],
	[3.9020000000E+04, 1.5624013198E+00, 1.6234091029E+00, 1.0534945079E-01, 9.3038431525E-02, 8.1136221315E-01],
	[3.9025000000E+04, 1.5627198256E+00, 1.6233924837E+00, 1.0539034949E-01, 9.3071403895E-02, 8.1138902202E-01],
	[3.9030000000E+04, 1.5630383556E+00, 1.6233758668E+00, 1.0543125883E-01, 9.3104382795E-02, 8.1141582922E-01],
	[3.9035000000E+04, 1.5633569096E+00, 1.6233592522E+00, 1.0547217880E-01, 9.3137368224E-02, 8.1144263475E-01],
	[3.9040000000E+04, 1.5636754877E+00, 1.6233426399E+00, 1.0551310941E-01, 9.3170360183E-02, 8.1146943860E-01],
	[3.9045000000E+04, 1.5639940900E+00, 1.6233260299E+00, 1.0555405066E-01, 9.3203358671E-02, 8.1149624077E-01],
	[3.9050000000E+04, 1.5643127163E+00, 1.6233094222E+00, 1.0559500255E-01, 9.3236363689E-02, 8.1152304126E-01],
	[3.9055000000E+04, 1.5646313668E+00, 1.6232928168E+00, 1.0563596508E-01, 9.3269375235E-02, 8.1154984008E-01],
	[3.9060000000E+04, 1.5649500413E+00, 1.6232762137E+00, 1.0567693825E-01, 9.3302393310E-02, 8.1157663722E-01],
	[3.9065000000E+04, 1.5652687400E+00, 1.6232596129E+00, 1.0571792207E-01, 9.3335417914E-02, 8.1160343267E-01],
	[3.9070000000E+04, 1.5655874628E+00, 1.6232430144E+00, 1.0575891653E-01, 9.3368449047E-02, 8.1163022645E-01],
	[3.9075000000E+04, 1.5659062096E+00, 1.6232264181E+00, 1.0579992165E-01, 9.3401486707E-02, 8.1165701855E-01],
	[3.9080000000E+04, 1.5662249806E+00, 1.6232098242E+00, 1.0584093741E-01, 9.3434530896E-02, 8.1168380896E-01],
	[3.9085000000E+04, 1.5665437756E+00, 1.6231932326E+00, 1.0588196382E-01, 9.3467581613E-02, 8.1171059769E-01],
	[3.9090000000E+04, 1.5668625948E+00, 1.6231766432E+00, 1.0592300088E-01, 9.3500638858E-02, 8.1173738474E-01],
	[3.9095000000E+04, 1.5671814381E+00, 1.6231600562E+00, 1.0596404860E-01, 9.3533702630E-02, 8.1176417011E-01],
	[3.9100000000E+04, 1.5675003054E+00, 1.6231434714E+00, 1.0600510697E-01, 9.3566772930E-02, 8.1179095379E-01],
	[3.9105000000E+04, 1.5678191968E+00, 1.6231268889E+00, 1.0604617600E-01, 9.3599849757E-02, 8.1181773578E-01],
	[3.9110000000E+04, 1.5681381124E+00, 1.6231103088E+00, 1.0608725568E-01, 9.3632933111E-02, 8.1184451609E-01],
	[3.9115000000E+04, 1.5684570520E+00, 1.6230937309E+00, 1.0612834603E-01, 9.3666022992E-02, 8.1187129471E-01],
	[3.9120000000E+04, 1.5687760157E+00, 1.6230771552E+00, 1.0616944703E-01, 9.3699119400E-02, 8.1189807164E-01],
	[3.9125000000E+04, 1.5690950035E+00, 1.6230605819E+00, 1.0621055869E-01, 9.3732222334E-02, 8.1192484688E-01],
	[3.9130000000E+04, 1.5694140154E+00, 1.6230440109E+00, 1.0625168102E-01, 9.3765331795E-02, 8.1195162044E-01],
	[3.9135000000E+04, 1.5697330514E+00, 1.6230274421E+00, 1.0629281401E-01, 9.3798447781E-02, 8.1197839230E-01],
	[3.9140000000E+04, 1.5700521114E+00, 1.6230108757E+00, 1.0633395767E-01, 9.3831570294E-02, 8.1200516247E-01],
	[3.9145000000E+04, 1.5703711956E+00, 1.6229943115E+00, 1.0637511200E-01, 9.3864699333E-02, 8.1203193095E-01],
	[3.9150000000E+04, 1.5706903038E+00, 1.6229777496E+00, 1.0641627699E-01, 9.3897834897E-02, 8.1205869774E-01],
	[3.9155000000E+04, 1.5710094361E+00, 1.6229611900E+00, 1.0645745265E-01, 9.3930976987E-02, 8.1208546284E-01],
	[3.9160000000E+04, 1.5713285924E+00, 1.6229446327E+00, 1.0649863899E-01, 9.3964125602E-02, 8.1211222624E-01],
	[3.9165000000E+04, 1.5716477729E+00, 1.6229280777E+00, 1.0653983599E-01, 9.3997280742E-02, 8.1213898794E-01],
	[3.9170000000E+04, 1.5719669774E+00, 1.6229115249E+00, 1.0658104368E-01, 9.4030442407E-02, 8.1216574796E-01],
	[3.9175000000E+04, 1.5722862060E+00, 1.6228949744E+00, 1.0662226203E-01, 9.4063610596E-02, 8.1219250627E-01],
	[3.9180000000E+04, 1.5726054587E+00, 1.6228784262E+00, 1.0666349107E-01, 9.4096785311E-02, 8.1221926289E-01],
	[3.9185000000E+04, 1.5729247355E+00, 1.6228618803E+00, 1.0670473078E-01, 9.4129966549E-02, 8.1224601781E-01],
	[3.9190000000E+04, 1.5732440363E+00, 1.6228453367E+00, 1.0674598117E-01, 9.4163154312E-02, 8.1227277103E-01],
	[3.9195000000E+04, 1.5735633612E+00, 1.6228287953E+00, 1.0678724225E-01, 9.4196348599E-02, 8.1229952255E-01],
	[3.9200000000E+04, 1.5738827102E+00, 1.6228122562E+00, 1.0682851400E-01, 9.4229549409E-02, 8.1232627237E-01],
	[3.9205000000E+04, 1.5742020832E+00, 1.6227957194E+00, 1.0686979644E-01, 9.4262756744E-02, 8.1235302049E-01],
	[3.9210000000E+04, 1.5745214803E+00, 1.6227791849E+00, 1.0691108957E-01, 9.4295970601E-02, 8.1237976691E-01],
	[3.9215000000E+04, 1.5748409015E+00, 1.6227626527E+00, 1.0695239338E-01, 9.4329190982E-02, 8.1240651162E-01],
	[3.9220000000E+04, 1.5751603467E+00, 1.6227461227E+00, 1.0699370788E-01, 9.4362417886E-02, 8.1243325464E-01],
	[3.9225000000E+04, 1.5754798160E+00, 1.6227295950E+00, 1.0703503307E-01, 9.4395651313E-02, 8.1245999595E-01],
	[3.9230000000E+04, 1.5757993093E+00, 1.6227130696E+00, 1.0707636895E-01, 9.4428891262E-02, 8.1248673555E-01],
	[3.9235000000E+04, 1.5761188267E+00, 1.6226965464E+00, 1.0711771552E-01, 9.4462137734E-02, 8.1251347345E-01],
	[3.9240000000E+04, 1.5764387017E+00, 1.6226805928E+00, 1.0715907279E-01, 9.4495393851E-02, 8.1254020964E-01],
	[3.9245000000E+04, 1.5767587774E+00, 1.6226649419E+00, 1.0720044075E-01, 9.4528658147E-02, 8.1256694413E-01],
	[3.9250000000E+04, 1.5770788773E+00, 1.6226492931E+00, 1.0724181941E-01, 9.4561928971E-02, 8.1259367691E-01],
	[3.9255000000E+04, 1.5773990015E+00, 1.6226336464E+00, 1.0728320877E-01, 9.4595206322E-02, 8.1262040798E-01],
	[3.9260000000E+04, 1.5777191498E+00, 1.6226180019E+00, 1.0732460883E-01, 9.4628490201E-02, 8.1264713734E-01],
	[3.9265000000E+04, 1.5780393224E+00, 1.6226023596E+00, 1.0736601958E-01, 9.4661780606E-02, 8.1267386499E-01],
	[3.9270000000E+04, 1.5783595191E+00, 1.6225867193E+00, 1.0740744104E-01, 9.4695077537E-02, 8.1270059093E-01],
	[3.9275000000E+04, 1.5786797400E+00, 1.6225710813E+00, 1.0744887321E-01, 9.4728380995E-02, 8.1272731516E-01],
	[3.9280000000E+04, 1.5789999851E+00, 1.6225554453E+00, 1.0749031607E-01, 9.4761690980E-02, 8.1275403768E-01],
	[3.9285000000E+04, 1.5793202544E+00, 1.6225398115E+00, 1.0753176965E-01, 9.4795007490E-02, 8.1278075848E-01],
	[3.9290000000E+04, 1.5796405479E+00, 1.6225241799E+00, 1.0757323393E-01, 9.4828330526E-02, 8.1280747757E-01],
	[3.9295000000E+04, 1.5799608656E+00, 1.6225085503E+00, 1.0761470892E-01, 9.4861660088E-02, 8.1283419495E-01],
	[3.9300000000E+04, 1.5802812074E+00, 1.6224929230E+00, 1.0765619462E-01, 9.4894996176E-02, 8.1286091061E-01],
	[3.9305000000E+04, 1.5806015735E+00, 1.6224772977E+00, 1.0769769104E-01, 9.4928338789E-02, 8.1288762456E-01],
	[3.9310000000E+04, 1.5809219637E+00, 1.6224616746E+00, 1.0773919817E-01, 9.4961687927E-02, 8.1291433678E-01],
	[3.9315000000E+04, 1.5812423781E+00, 1.6224460536E+00, 1.0778071601E-01, 9.4995043589E-02, 8.1294104729E-01],
	[3.9320000000E+04, 1.5815628167E+00, 1.6224304348E+00, 1.0782224457E-01, 9.5028405777E-02, 8.1296775609E-01],
	[3.9325000000E+04, 1.5818832794E+00, 1.6224148181E+00, 1.0786378384E-01, 9.5061774489E-02, 8.1299446316E-01],
	[3.9330000000E+04, 1.5822037664E+00, 1.6223992036E+00, 1.0790533384E-01, 9.5095149726E-02, 8.1302116852E-01],
	[3.9335000000E+04, 1.5825242775E+00, 1.6223835911E+00, 1.0794689456E-01, 9.5128531487E-02, 8.1304787215E-01],
	[3.9340000000E+04, 1.5828448128E+00, 1.6223679808E+00, 1.0798846599E-01, 9.5161919771E-02, 8.1307457406E-01],
	[3.9345000000E+04, 1.5831653723E+00, 1.6223523727E+00, 1.0803004815E-01, 9.5195314580E-02, 8.1310127425E-01],
	[3.9350000000E+04, 1.5834859559E+00, 1.6223367667E+00, 1.0807164104E-01, 9.5228715912E-02, 8.1312797272E-01],
	[3.9355000000E+04, 1.5838065637E+00, 1.6223211628E+00, 1.0811324465E-01, 9.5262123768E-02, 8.1315466947E-01],
	[3.9360000000E+04, 1.5841271957E+00, 1.6223055610E+00, 1.0815485899E-01, 9.5295538147E-02, 8.1318136449E-01],
	[3.9365000000E+04, 1.5844478519E+00, 1.6222899614E+00, 1.0819648406E-01, 9.5328959048E-02, 8.1320805779E-01],
	[3.9370000000E+04, 1.5847685322E+00, 1.6222743639E+00, 1.0823811986E-01, 9.5362386473E-02, 8.1323474936E-01],
	[3.9375000000E+04, 1.5850892367E+00, 1.6222587686E+00, 1.0827976639E-01, 9.5395820420E-02, 8.1326143920E-01],
	[3.9380000000E+04, 1.5854099654E+00, 1.6222431753E+00, 1.0832142365E-01, 9.5429260890E-02, 8.1328812732E-01],
	[3.9385000000E+04, 1.5857307182E+00, 1.6222275842E+00, 1.0836309165E-01, 9.5462707882E-02, 8.1331481371E-01],
	[3.9390000000E+04, 1.5860514952E+00, 1.6222119952E+00, 1.0840477038E-01, 9.5496161396E-02, 8.1334149837E-01],
	[3.9395000000E+04, 1.5863722963E+00, 1.6221964084E+00, 1.0844645985E-01, 9.5529621432E-02, 8.1336818130E-01],
	[3.9400000000E+04, 1.5866931216E+00, 1.6221808237E+00, 1.0848816006E-01, 9.5563087990E-02, 8.1339486250E-01],
	[3.9405000000E+04, 1.5870139711E+00, 1.6221652411E+00, 1.0852987101E-01, 9.5596561069E-02, 8.1342154198E-01],
	[3.9410000000E+04, 1.5873348447E+00, 1.6221496606E+00, 1.0857159270E-01, 9.5630040670E-02, 8.1344821972E-01],
	[3.9415000000E+04, 1.5876557425E+00, 1.6221340823E+00, 1.0861332513E-01, 9.5663526791E-02, 8.1347489572E-01],
	[3.9420000000E+04, 1.5879766645E+00, 1.6221185061E+00, 1.0865506831E-01, 9.5697019434E-02, 8.1350157000E-01],
	[3.9425000000E+04, 1.5882976106E+00, 1.6221029320E+00, 1.0869682224E-01, 9.5730518597E-02, 8.1352824254E-01],
	[3.9430000000E+04, 1.5886185808E+00, 1.6220873600E+00, 1.0873858691E-01, 9.5764024280E-02, 8.1355491335E-01],
	[3.9435000000E+04, 1.5889395752E+00, 1.6220717902E+00, 1.0878036233E-01, 9.5797536484E-02, 8.1358158242E-01],
	[3.9440000000E+04, 1.5892605938E+00, 1.6220562225E+00, 1.0882214850E-01, 9.5831055208E-02, 8.1360824975E-01],
	[3.9445000000E+04, 1.5895816365E+00, 1.6220406569E+00, 1.0886394542E-01, 9.5864580452E-02, 8.1363491535E-01],
	[3.9450000000E+04, 1.5899027033E+00, 1.6220250934E+00, 1.0890575309E-01, 9.5898112216E-02, 8.1366157921E-01],
	[3.9455000000E+04, 1.5902237943E+00, 1.6220095321E+00, 1.0894757152E-01, 9.5931650499E-02, 8.1368824134E-01],
	[3.9460000000E+04, 1.5905449095E+00, 1.6219939729E+00, 1.0898940070E-01, 9.5965195301E-02, 8.1371490172E-01],
	[3.9465000000E+04, 1.5908660487E+00, 1.6219784158E+00, 1.0903124064E-01, 9.5998746623E-02, 8.1374156037E-01],
	[3.9470000000E+04, 1.5911872122E+00, 1.6219628608E+00, 1.0907309134E-01, 9.6032304463E-02, 8.1376821727E-01],
	[3.9475000000E+04, 1.5915083998E+00, 1.6219473079E+00, 1.0911495280E-01, 9.6065868822E-02, 8.1379487243E-01],
	[3.9480000000E+04, 1.5918296115E+00, 1.6219317572E+00, 1.0915682502E-01, 9.6099439700E-02, 8.1382152586E-01],
	[3.9485000000E+04, 1.5921508473E+00, 1.6219162085E+00, 1.0919870800E-01, 9.6133017096E-02, 8.1384817754E-01],
	[3.9490000000E+04, 1.5924721073E+00, 1.6219006620E+00, 1.0924060174E-01, 9.6166601010E-02, 8.1387482747E-01],
	[3.9495000000E+04, 1.5927933914E+00, 1.6218851176E+00, 1.0928250625E-01, 9.6200191442E-02, 8.1390147566E-01],
	[3.9500000000E+04, 1.5931146997E+00, 1.6218695754E+00, 1.0932442153E-01, 9.6233788391E-02, 8.1392812211E-01],
	[3.9505000000E+04, 1.5934360321E+00, 1.6218540352E+00, 1.0936634758E-01, 9.6267391859E-02, 8.1395476681E-01],
	[3.9510000000E+04, 1.5937573886E+00, 1.6218384972E+00, 1.0940828439E-01, 9.6301001843E-02, 8.1398140977E-01],
	[3.9515000000E+04, 1.5940787693E+00, 1.6218229612E+00, 1.0945023198E-01, 9.6334618345E-02, 8.1400805098E-01],
	[3.9520000000E+04, 1.5944001741E+00, 1.6218074274E+00, 1.0949219034E-01, 9.6368241363E-02, 8.1403469044E-01],
	[3.9525000000E+04, 1.5947216030E+00, 1.6217918957E+00, 1.0953415947E-01, 9.6401870898E-02, 8.1406132815E-01],
	[3.9530000000E+04, 1.5950430561E+00, 1.6217763661E+00, 1.0957613938E-01, 9.6435506950E-02, 8.1408796412E-01],
	[3.9535000000E+04, 1.5953645333E+00, 1.6217608386E+00, 1.0961813006E-01, 9.6469149517E-02, 8.1411459833E-01],
	[3.9540000000E+04, 1.5956860346E+00, 1.6217453133E+00, 1.0966013152E-01, 9.6502798601E-02, 8.1414123080E-01],
	[3.9545000000E+04, 1.5960075600E+00, 1.6217297900E+00, 1.0970214376E-01, 9.6536454201E-02, 8.1416786151E-01],
	[3.9550000000E+04, 1.5963291096E+00, 1.6217142689E+00, 1.0974416679E-01, 9.6570116317E-02, 8.1419449047E-01],
	[3.9555000000E+04, 1.5966506832E+00, 1.6216987499E+00, 1.0978620059E-01, 9.6603784947E-02, 8.1422111768E-01],
	[3.9560000000E+04, 1.5969722810E+00, 1.6216832329E+00, 1.0982824518E-01, 9.6637460094E-02, 8.1424774313E-01],
	[3.9565000000E+04, 1.5972939029E+00, 1.6216677181E+00, 1.0987030055E-01, 9.6671141755E-02, 8.1427436683E-01],
	[3.9570000000E+04, 1.5976155490E+00, 1.6216522054E+00, 1.0991236671E-01, 9.6704829931E-02, 8.1430098878E-01],
	[3.9575000000E+04, 1.5979372191E+00, 1.6216366948E+00, 1.0995444366E-01, 9.6738524621E-02, 8.1432760897E-01],
	[3.9580000000E+04, 1.5982589134E+00, 1.6216211864E+00, 1.0999653139E-01, 9.6772225826E-02, 8.1435422740E-01],
	[3.9585000000E+04, 1.5985806318E+00, 1.6216056800E+00, 1.1003862992E-01, 9.6805933546E-02, 8.1438084408E-01],
	[3.9590000000E+04, 1.5989023743E+00, 1.6215901757E+00, 1.1008073924E-01, 9.6839647779E-02, 8.1440745900E-01],
	[3.9595000000E+04, 1.5992241409E+00, 1.6215746735E+00, 1.1012285935E-01, 9.6873368526E-02, 8.1443407216E-01],
	[3.9600000000E+04, 1.5995459316E+00, 1.6215591735E+00, 1.1016499026E-01, 9.6907095787E-02, 8.1446068356E-01],
	[3.9605000000E+04, 1.5998677465E+00, 1.6215436755E+00, 1.1020713196E-01, 9.6940829561E-02, 8.1448729320E-01],
	[3.9610000000E+04, 1.6001895854E+00, 1.6215281797E+00, 1.1024928446E-01, 9.6974569848E-02, 8.1451390108E-01],
	[3.9615000000E+04, 1.6005114484E+00, 1.6215126859E+00, 1.1029144776E-01, 9.7008316648E-02, 8.1454050720E-01],
	[3.9620000000E+04, 1.6008333356E+00, 1.6214971943E+00, 1.1033362186E-01, 9.7042069961E-02, 8.1456711156E-01],
	[3.9625000000E+04, 1.6011552469E+00, 1.6214817048E+00, 1.1037580677E-01, 9.7075829786E-02, 8.1459371415E-01],
	[3.9630000000E+04, 1.6014771822E+00, 1.6214662173E+00, 1.1041800247E-01, 9.7109596124E-02, 8.1462031498E-01],
	[3.9635000000E+04, 1.6017991417E+00, 1.6214507320E+00, 1.1046020898E-01, 9.7143368974E-02, 8.1464691405E-01],
	[3.9640000000E+04, 1.6021211252E+00, 1.6214352488E+00, 1.1050242630E-01, 9.7177148336E-02, 8.1467351135E-01],
	[3.9645000000E+04, 1.6024431329E+00, 1.6214197676E+00, 1.1054465442E-01, 9.7210934209E-02, 8.1470010688E-01],
	[3.9650000000E+04, 1.6027651647E+00, 1.6214042886E+00, 1.1058689335E-01, 9.7244726594E-02, 8.1472670065E-01],
	[3.9655000000E+04, 1.6030872205E+00, 1.6213888117E+00, 1.1062914310E-01, 9.7278525490E-02, 8.1475329266E-01],
	[3.9660000000E+04, 1.6034093005E+00, 1.6213733368E+00, 1.1067140365E-01, 9.7312330898E-02, 8.1477988289E-01],
	[3.9665000000E+04, 1.6037314046E+00, 1.6213578641E+00, 1.1071367502E-01, 9.7346142816E-02, 8.1480647136E-01],
	[3.9670000000E+04, 1.6040535327E+00, 1.6213423935E+00, 1.1075595720E-01, 9.7379961244E-02, 8.1483305805E-01],
	[3.9675000000E+04, 1.6043756849E+00, 1.6213269249E+00, 1.1079825020E-01, 9.7413786183E-02, 8.1485964298E-01],
	[3.9680000000E+04, 1.6046978613E+00, 1.6213114585E+00, 1.1084055401E-01, 9.7447617633E-02, 8.1488622614E-01],
	[3.9685000000E+04, 1.6050200617E+00, 1.6212959941E+00, 1.1088286865E-01, 9.7481455592E-02, 8.1491280752E-01],
	[3.9690000000E+04, 1.6053422862E+00, 1.6212805319E+00, 1.1092519410E-01, 9.7515300061E-02, 8.1493938713E-01],
	[3.9695000000E+04, 1.6056645348E+00, 1.6212650717E+00, 1.1096753037E-01, 9.7549151040E-02, 8.1496596497E-01],
	[3.9700000000E+04, 1.6059868075E+00, 1.6212496137E+00, 1.1100987747E-01, 9.7583008528E-02, 8.1499254104E-01],
	[3.9705000000E+04, 1.6063091043E+00, 1.6212341577E+00, 1.1105223539E-01, 9.7616872525E-02, 8.1501911533E-01],
	[3.9710000000E+04, 1.6066314251E+00, 1.6212187038E+00, 1.1109460414E-01, 9.7650743031E-02, 8.1504568784E-01],
	[3.9715000000E+04, 1.6069537700E+00, 1.6212032520E+00, 1.1113698372E-01, 9.7684620045E-02, 8.1507225859E-01],
	[3.9720000000E+04, 1.6072761391E+00, 1.6211878024E+00, 1.1117937412E-01, 9.7718503568E-02, 8.1509882755E-01],
	[3.9725000000E+04, 1.6075985322E+00, 1.6211723548E+00, 1.1122177535E-01, 9.7752393600E-02, 8.1512539474E-01],
	[3.9730000000E+04, 1.6079209493E+00, 1.6211569093E+00, 1.1126418742E-01, 9.7786290139E-02, 8.1515196015E-01],
	[3.9735000000E+04, 1.6082433906E+00, 1.6211414658E+00, 1.1130661031E-01, 9.7820193186E-02, 8.1517852378E-01],
	[3.9740000000E+04, 1.6085658559E+00, 1.6211260245E+00, 1.1134904405E-01, 9.7854102741E-02, 8.1520508563E-01],
	[3.9745000000E+04, 1.6088883453E+00, 1.6211105853E+00, 1.1139148861E-01, 9.7888018803E-02, 8.1523164570E-01],
	[3.9750000000E+04, 1.6092108588E+00, 1.6210951481E+00, 1.1143394402E-01, 9.7921941372E-02, 8.1525820399E-01],
	[3.9755000000E+04, 1.6095333964E+00, 1.6210797131E+00, 1.1147641026E-01, 9.7955870448E-02, 8.1528476050E-01],
	[3.9760000000E+04, 1.6098559580E+00, 1.6210642801E+00, 1.1151888734E-01, 9.7989806031E-02, 8.1531131523E-01],
	[3.9765000000E+04, 1.6101785437E+00, 1.6210488492E+00, 1.1156137526E-01, 9.8023748121E-02, 8.1533786817E-01],
	[3.9770000000E+04, 1.6105011534E+00, 1.6210334204E+00, 1.1160387403E-01, 9.8057696716E-02, 8.1536441933E-01],
	[3.9775000000E+04, 1.6108237873E+00, 1.6210179937E+00, 1.1164638364E-01, 9.8091651818E-02, 8.1539096871E-01],
	[3.9780000000E+04, 1.6111464452E+00, 1.6210025691E+00, 1.1168890409E-01, 9.8125613426E-02, 8.1541751630E-01],
	[3.9785000000E+04, 1.6114691271E+00, 1.6209871466E+00, 1.1173143539E-01, 9.8159581539E-02, 8.1544406211E-01],
	[3.9790000000E+04, 1.6117918332E+00, 1.6209717261E+00, 1.1177397754E-01, 9.8193556158E-02, 8.1547060613E-01],
	[3.9795000000E+04, 1.6121145633E+00, 1.6209563078E+00, 1.1181653054E-01, 9.8227537281E-02, 8.1549714836E-01],
	[3.9800000000E+04, 1.6124373174E+00, 1.6209408915E+00, 1.1185909439E-01, 9.8261524910E-02, 8.1552368880E-01],
	[3.9805000000E+04, 1.6127600956E+00, 1.6209254773E+00, 1.1190166909E-01, 9.8295519043E-02, 8.1555022746E-01],
	[3.9810000000E+04, 1.6130828979E+00, 1.6209100652E+00, 1.1194425465E-01, 9.8329519681E-02, 8.1557676433E-01],
	[3.9815000000E+04, 1.6134057242E+00, 1.6208946551E+00, 1.1198685106E-01, 9.8363526823E-02, 8.1560329940E-01],
	[3.9820000000E+04, 1.6137285746E+00, 1.6208792472E+00, 1.1202945833E-01, 9.8397540469E-02, 8.1562983269E-01],
	[3.9825000000E+04, 1.6140514491E+00, 1.6208638413E+00, 1.1207207645E-01, 9.8431560620E-02, 8.1565636419E-01],
	[3.9830000000E+04, 1.6143743475E+00, 1.6208484375E+00, 1.1211470544E-01, 9.8465587273E-02, 8.1568289389E-01],
	[3.9835000000E+04, 1.6146972701E+00, 1.6208330358E+00, 1.1215734528E-01, 9.8499620430E-02, 8.1570942180E-01],
	[3.9840000000E+04, 1.6150202167E+00, 1.6208176362E+00, 1.1219999599E-01, 9.8533660090E-02, 8.1573594792E-01],
	[3.9845000000E+04, 1.6153431874E+00, 1.6208022386E+00, 1.1224265756E-01, 9.8567706253E-02, 8.1576247224E-01],
	[3.9850000000E+04, 1.6156661821E+00, 1.6207868431E+00, 1.1228533000E-01, 9.8601758919E-02, 8.1578899477E-01],
	[3.9855000000E+04, 1.6159892008E+00, 1.6207714497E+00, 1.1232801330E-01, 9.8635818087E-02, 8.1581551550E-01],
	[3.9860000000E+04, 1.6163122436E+00, 1.6207560584E+00, 1.1237070747E-01, 9.8669883758E-02, 8.1584203444E-01],
	[3.9865000000E+04, 1.6166353105E+00, 1.6207406692E+00, 1.1241341251E-01, 9.8703955930E-02, 8.1586855158E-01],
	[3.9870000000E+04, 1.6169586196E+00, 1.6207255574E+00, 1.1245612842E-01, 9.8738036440E-02, 8.1589506692E-01],
	[3.9875000000E+04, 1.6172824123E+00, 1.6207110274E+00, 1.1249885520E-01, 9.8772127321E-02, 8.1592158046E-01],
	[3.9880000000E+04, 1.6176062291E+00, 1.6206964993E+00, 1.1254159286E-01, 9.8806224709E-02, 8.1594809221E-01],
	[3.9885000000E+04, 1.6179300703E+00, 1.6206819731E+00, 1.1258434139E-01, 9.8840328604E-02, 8.1597460215E-01],
	[3.9890000000E+04, 1.6182539356E+00, 1.6206674489E+00, 1.1262710080E-01, 9.8874439006E-02, 8.1600111030E-01],
	[3.9895000000E+04, 1.6185778252E+00, 1.6206529266E+00, 1.1266987108E-01, 9.8908555915E-02, 8.1602761664E-01],
	[3.9900000000E+04, 1.6189017389E+00, 1.6206384063E+00, 1.1271265224E-01, 9.8942679331E-02, 8.1605412118E-01],
	[3.9905000000E+04, 1.6192256770E+00, 1.6206238879E+00, 1.1275544429E-01, 9.8976809253E-02, 8.1608062392E-01],
	[3.9910000000E+04, 1.6195496392E+00, 1.6206093715E+00, 1.1279824721E-01, 9.9010945681E-02, 8.1610712486E-01],
	[3.9915000000E+04, 1.6198736256E+00, 1.6205948571E+00, 1.1284106102E-01, 9.9045088615E-02, 8.1613362399E-01],
	[3.9920000000E+04, 1.6201976363E+00, 1.6205803445E+00, 1.1288388571E-01, 9.9079238055E-02, 8.1616012132E-01],
	[3.9925000000E+04, 1.6205216712E+00, 1.6205658340E+00, 1.1292672129E-01, 9.9113394001E-02, 8.1618661684E-01],
	[3.9930000000E+04, 1.6208457303E+00, 1.6205513253E+00, 1.1296956776E-01, 9.9147556451E-02, 8.1621311055E-01],
	[3.9935000000E+04, 1.6211698136E+00, 1.6205368187E+00, 1.1301242511E-01, 9.9181725407E-02, 8.1623960246E-01],
	[3.9940000000E+04, 1.6214939211E+00, 1.6205223139E+00, 1.1305529336E-01, 9.9215900868E-02, 8.1626609257E-01],
	[3.9945000000E+04, 1.6218180529E+00, 1.6205078111E+00, 1.1309817250E-01, 9.9250082833E-02, 8.1629258086E-01],
	[3.9950000000E+04, 1.6221422088E+00, 1.6204933103E+00, 1.1314106253E-01, 9.9284271302E-02, 8.1631906734E-01],
	[3.9955000000E+04, 1.6224663890E+00, 1.6204788114E+00, 1.1318396345E-01, 9.9318466276E-02, 8.1634555202E-01],
	[3.9960000000E+04, 1.6227905933E+00, 1.6204643144E+00, 1.1322687527E-01, 9.9352667753E-02, 8.1637203489E-01],
	[3.9965000000E+04, 1.6231148219E+00, 1.6204498194E+00, 1.1326979799E-01, 9.9386875735E-02, 8.1639851594E-01],
	[3.9970000000E+04, 1.6234390747E+00, 1.6204353264E+00, 1.1331273161E-01, 9.9421090219E-02, 8.1642499518E-01],
	[3.9975000000E+04, 1.6237633517E+00, 1.6204208352E+00, 1.1335567612E-01, 9.9455311207E-02, 8.1645147261E-01],
	[3.9980000000E+04, 1.6240876529E+00, 1.6204063461E+00, 1.1339863154E-01, 9.9489538698E-02, 8.1647794823E-01],
	[3.9985000000E+04, 1.6244119783E+00, 1.6203918588E+00, 1.1344159786E-01, 9.9523772691E-02, 8.1650442204E-01],
	[3.9990000000E+04, 1.6247363279E+00, 1.6203773735E+00, 1.1348457509E-01, 9.9558013187E-02, 8.1653089403E-01],
	[3.9995000000E+04, 1.6250607017E+00, 1.6203628902E+00, 1.1352756322E-01, 9.9592260186E-02, 8.1655736420E-01],
	[4.0000000000E+04, 1.6253850997E+00, 1.6203484087E+00, 1.1357056226E-01, 9.9626513686E-02, 8.1658383256E-01],
	[4.0005000000E+04, 1.6257095219E+00, 1.6203339293E+00, 1.1361386431E-01, 9.9660998454E-02, 8.1661029910E-01],
	[4.0010000000E+04, 1.6260339682E+00, 1.6203194517E+00, 1.1365717746E-01, 9.9695489835E-02, 8.1663676383E-01],
	[4.0015000000E+04, 1.6263584388E+00, 1.6203049761E+00, 1.1370050170E-01, 9.9729987828E-02, 8.1666322674E-01],
	[4.0020000000E+04, 1.6266829336E+00, 1.6202905025E+00, 1.1374383705E-01, 9.9764492434E-02, 8.1668968783E-01],
	[4.0025000000E+04, 1.6270074526E+00, 1.6202760307E+00, 1.1378718349E-01, 9.9799003652E-02, 8.1671614710E-01],
	[4.0030000000E+04, 1.6273319957E+00, 1.6202615609E+00, 1.1383054104E-01, 9.9833521482E-02, 8.1674260455E-01],
	[4.0035000000E+04, 1.6276565631E+00, 1.6202470931E+00, 1.1387390968E-01, 9.9868045924E-02, 8.1676906018E-01],
	[4.0040000000E+04, 1.6279811546E+00, 1.6202326272E+00, 1.1391728943E-01, 9.9902576977E-02, 8.1679551399E-01],
	[4.0045000000E+04, 1.6283057704E+00, 1.6202181632E+00, 1.1396068029E-01, 9.9937114641E-02, 8.1682196597E-01],
	[4.0050000000E+04, 1.6286304103E+00, 1.6202037011E+00, 1.1400408226E-01, 9.9971658916E-02, 8.1684841614E-01],
	[4.0055000000E+04, 1.6289550744E+00, 1.6201892410E+00, 1.1404749533E-01, 1.0000620980E-01, 8.1687486448E-01],
	[4.0060000000E+04, 1.6292797627E+00, 1.6201747828E+00, 1.1409091951E-01, 1.0004076730E-01, 8.1690131100E-01],
	[4.0065000000E+04, 1.6296044751E+00, 1.6201603266E+00, 1.1413435480E-01, 1.0007533141E-01, 8.1692775569E-01],
	[4.0070000000E+04, 1.6299292118E+00, 1.6201458723E+00, 1.1417780121E-01, 1.0010990212E-01, 8.1695419856E-01],
	[4.0075000000E+04, 1.6302539726E+00, 1.6201314199E+00, 1.1422125873E-01, 1.0014447945E-01, 8.1698063960E-01],
	[4.0080000000E+04, 1.6305787576E+00, 1.6201169695E+00, 1.1426472737E-01, 1.0017906338E-01, 8.1700707881E-01],
	[4.0085000000E+04, 1.6309035668E+00, 1.6201025209E+00, 1.1430820712E-01, 1.0021365393E-01, 8.1703351620E-01],
	[4.0090000000E+04, 1.6312284002E+00, 1.6200880744E+00, 1.1435169799E-01, 1.0024825109E-01, 8.1705995176E-01],
	[4.0095000000E+04, 1.6315532577E+00, 1.6200736297E+00, 1.1439519998E-01, 1.0028285485E-01, 8.1708638549E-01],
	[4.0100000000E+04, 1.6318781394E+00, 1.6200591870E+00, 1.1443871310E-01, 1.0031746522E-01, 8.1711281739E-01],
	[4.0105000000E+04, 1.6322030453E+00, 1.6200447462E+00, 1.1448223733E-01, 1.0035208220E-01, 8.1713924746E-01],
	[4.0110000000E+04, 1.6325279754E+00, 1.6200303073E+00, 1.1452577270E-01, 1.0038670579E-01, 8.1716567570E-01],
	[4.0115000000E+04, 1.6328529296E+00, 1.6200158704E+00, 1.1456931918E-01, 1.0042133599E-01, 8.1719210211E-01],
	[4.0120000000E+04, 1.6331779080E+00, 1.6200014354E+00, 1.1461287680E-01, 1.0045597279E-01, 8.1721852669E-01],
	[4.0125000000E+04, 1.6335029106E+00, 1.6199870023E+00, 1.1465644554E-01, 1.0049061620E-01, 8.1724494943E-01],
	[4.0130000000E+04, 1.6338279373E+00, 1.6199725711E+00, 1.1470002541E-01, 1.0052526622E-01, 8.1727137034E-01],
	[4.0135000000E+04, 1.6341529882E+00, 1.6199581419E+00, 1.1474361642E-01, 1.0055992285E-01, 8.1729778942E-01],
	[4.0140000000E+04, 1.6344780633E+00, 1.6199437146E+00, 1.1478721856E-01, 1.0059458608E-01, 8.1732420666E-01],
	[4.0145000000E+04, 1.6348031625E+00, 1.6199292892E+00, 1.1483083183E-01, 1.0062925592E-01, 8.1735062206E-01],
	[4.0150000000E+04, 1.6351282859E+00, 1.6199148658E+00, 1.1487445624E-01, 1.0066393237E-01, 8.1737703563E-01],
	[4.0155000000E+04, 1.6354534335E+00, 1.6199004442E+00, 1.1491809178E-01, 1.0069861542E-01, 8.1740344737E-01],
	[4.0160000000E+04, 1.6357786052E+00, 1.6198860246E+00, 1.1496173847E-01, 1.0073330508E-01, 8.1742985726E-01],
	[4.0165000000E+04, 1.6361038011E+00, 1.6198716070E+00, 1.1500539630E-01, 1.0076800134E-01, 8.1745626532E-01],
	[4.0170000000E+04, 1.6364290211E+00, 1.6198571912E+00, 1.1504906526E-01, 1.0080270421E-01, 8.1748267154E-01],
	[4.0175000000E+04, 1.6367542653E+00, 1.6198427774E+00, 1.1509274538E-01, 1.0083741368E-01, 8.1750907592E-01],
	[4.0180000000E+04, 1.6370795336E+00, 1.6198283654E+00, 1.1513643663E-01, 1.0087212976E-01, 8.1753547845E-01],
	[4.0185000000E+04, 1.6374048261E+00, 1.6198139555E+00, 1.1518013903E-01, 1.0090685245E-01, 8.1756187915E-01],
	[4.0190000000E+04, 1.6377301428E+00, 1.6197995474E+00, 1.1522385258E-01, 1.0094158173E-01, 8.1758827801E-01],
	[4.0195000000E+04, 1.6380554836E+00, 1.6197851412E+00, 1.1526757728E-01, 1.0097631762E-01, 8.1761467502E-01],
	[4.0200000000E+04, 1.6383808485E+00, 1.6197707370E+00, 1.1531131313E-01, 1.0101106012E-01, 8.1764107019E-01],
	[4.0205000000E+04, 1.6387062376E+00, 1.6197563347E+00, 1.1535506014E-01, 1.0104580922E-01, 8.1766746352E-01],
	[4.0210000000E+04, 1.6390316509E+00, 1.6197419343E+00, 1.1539881829E-01, 1.0108056492E-01, 8.1769385500E-01],
	[4.0215000000E+04, 1.6393570883E+00, 1.6197275358E+00, 1.1544258760E-01, 1.0111532723E-01, 8.1772024464E-01],
	[4.0220000000E+04, 1.6396825498E+00, 1.6197131393E+00, 1.1548636807E-01, 1.0115009614E-01, 8.1774663243E-01],
	[4.0225000000E+04, 1.6400080355E+00, 1.6196987446E+00, 1.1553015969E-01, 1.0118487165E-01, 8.1777301838E-01],
	[4.0230000000E+04, 1.6403335453E+00, 1.6196843519E+00, 1.1557396248E-01, 1.0121965376E-01, 8.1779940247E-01],
	[4.0235000000E+04, 1.6406590793E+00, 1.6196699611E+00, 1.1561777642E-01, 1.0125444248E-01, 8.1782578472E-01],
	[4.0240000000E+04, 1.6409846374E+00, 1.6196555722E+00, 1.1566160153E-01, 1.0128923780E-01, 8.1785216513E-01],
	[4.0245000000E+04, 1.6413102197E+00, 1.6196411852E+00, 1.1570543780E-01, 1.0132403972E-01, 8.1787854368E-01],
	[4.0250000000E+04, 1.6416358260E+00, 1.6196268002E+00, 1.1574928524E-01, 1.0135884824E-01, 8.1790492038E-01],
	[4.0255000000E+04, 1.6419614566E+00, 1.6196124170E+00, 1.1579314384E-01, 1.0139366336E-01, 8.1793129524E-01],
	[4.0260000000E+04, 1.6422871112E+00, 1.6195980358E+00, 1.1583701361E-01, 1.0142848508E-01, 8.1795766824E-01],
	[4.0265000000E+04, 1.6426127900E+00, 1.6195836565E+00, 1.1588089455E-01, 1.0146331341E-01, 8.1798403939E-01],
	[4.0270000000E+04, 1.6429384930E+00, 1.6195692791E+00, 1.1592478667E-01, 1.0149814833E-01, 8.1801040869E-01],
	[4.0275000000E+04, 1.6432642200E+00, 1.6195549036E+00, 1.1596868995E-01, 1.0153298986E-01, 8.1803677614E-01],
	[4.0280000000E+04, 1.6435899712E+00, 1.6195405300E+00, 1.1601260441E-01, 1.0156783798E-01, 8.1806314173E-01],
	[4.0285000000E+04, 1.6439157465E+00, 1.6195261584E+00, 1.1605653004E-01, 1.0160269271E-01, 8.1808950546E-01],
	[4.0290000000E+04, 1.6442415460E+00, 1.6195117886E+00, 1.1610046685E-01, 1.0163755403E-01, 8.1811586735E-01],
	[4.0295000000E+04, 1.6445673695E+00, 1.6194974208E+00, 1.1614441484E-01, 1.0167242196E-01, 8.1814222737E-01],
	[4.0300000000E+04, 1.6448932172E+00, 1.6194830548E+00, 1.1618837401E-01, 1.0170729648E-01, 8.1816858554E-01],
	[4.0305000000E+04, 1.6452190891E+00, 1.6194686908E+00, 1.1623234436E-01, 1.0174217760E-01, 8.1819494186E-01],
	[4.0310000000E+04, 1.6455449850E+00, 1.6194543287E+00, 1.1627632589E-01, 1.0177706532E-01, 8.1822129631E-01],
	[4.0315000000E+04, 1.6458709051E+00, 1.6194399685E+00, 1.1632031861E-01, 1.0181195964E-01, 8.1824764891E-01],
	[4.0320000000E+04, 1.6461968493E+00, 1.6194256102E+00, 1.1636432251E-01, 1.0184686055E-01, 8.1827399965E-01],
	[4.0325000000E+04, 1.6465228176E+00, 1.6194112538E+00, 1.1640833760E-01, 1.0188176807E-01, 8.1830034853E-01],
	[4.0330000000E+04, 1.6468488100E+00, 1.6193968993E+00, 1.1645236388E-01, 1.0191668218E-01, 8.1832669555E-01],
	[4.0335000000E+04, 1.6471748266E+00, 1.6193825467E+00, 1.1649640135E-01, 1.0195160289E-01, 8.1835304070E-01],
	[4.0340000000E+04, 1.6475008673E+00, 1.6193681961E+00, 1.1654045001E-01, 1.0198653019E-01, 8.1837938400E-01],
	[4.0345000000E+04, 1.6478269320E+00, 1.6193538473E+00, 1.1658450986E-01, 1.0202146409E-01, 8.1840572543E-01],
	[4.0350000000E+04, 1.6481530209E+00, 1.6193395004E+00, 1.1662858091E-01, 1.0205640459E-01, 8.1843206500E-01],
	[4.0355000000E+04, 1.6484791339E+00, 1.6193251555E+00, 1.1667266315E-01, 1.0209135169E-01, 8.1845840271E-01],
	[4.0360000000E+04, 1.6488052711E+00, 1.6193108124E+00, 1.1671675659E-01, 1.0212630538E-01, 8.1848473855E-01],
	[4.0365000000E+04, 1.6491314323E+00, 1.6192964713E+00, 1.1676086123E-01, 1.0216126567E-01, 8.1851107253E-01],
	[4.0370000000E+04, 1.6494576176E+00, 1.6192821320E+00, 1.1680497707E-01, 1.0219623255E-01, 8.1853740464E-01],
	[4.0375000000E+04, 1.6497838271E+00, 1.6192677947E+00, 1.1684910411E-01, 1.0223120603E-01, 8.1856373489E-01],
	[4.0380000000E+04, 1.6501100606E+00, 1.6192534593E+00, 1.1689324235E-01, 1.0226618610E-01, 8.1859006327E-01],
	[4.0385000000E+04, 1.6504363183E+00, 1.6192391257E+00, 1.1693739180E-01, 1.0230117277E-01, 8.1861638978E-01],
	[4.0390000000E+04, 1.6507626001E+00, 1.6192247941E+00, 1.1698155245E-01, 1.0233616603E-01, 8.1864271442E-01],
	[4.0395000000E+04, 1.6510889059E+00, 1.6192104644E+00, 1.1702572431E-01, 1.0237116588E-01, 8.1866903719E-01],
	[4.0400000000E+04, 1.6514152359E+00, 1.6191961365E+00, 1.1706990738E-01, 1.0240617233E-01, 8.1869535810E-01],
	[4.0405000000E+04, 1.6517415900E+00, 1.6191818106E+00, 1.1711410166E-01, 1.0244118538E-01, 8.1872167713E-01],
	[4.0410000000E+04, 1.6520679681E+00, 1.6191674866E+00, 1.1715830715E-01, 1.0247620501E-01, 8.1874799429E-01],
	[4.0415000000E+04, 1.6523943704E+00, 1.6191531644E+00, 1.1720252386E-01, 1.0251123124E-01, 8.1877430959E-01],
	[4.0420000000E+04, 1.6527207968E+00, 1.6191388442E+00, 1.1724675178E-01, 1.0254626407E-01, 8.1880062300E-01],
	[4.0425000000E+04, 1.6530472472E+00, 1.6191245259E+00, 1.1729099092E-01, 1.0258130348E-01, 8.1882693455E-01],
	[4.0430000000E+04, 1.6533737218E+00, 1.6191102094E+00, 1.1733524127E-01, 1.0261634949E-01, 8.1885324422E-01],
	[4.0435000000E+04, 1.6537002204E+00, 1.6190958949E+00, 1.1737950284E-01, 1.0265140209E-01, 8.1887955202E-01],
	[4.0440000000E+04, 1.6540267432E+00, 1.6190815822E+00, 1.1742377564E-01, 1.0268646128E-01, 8.1890585795E-01],
	[4.0445000000E+04, 1.6543532900E+00, 1.6190672715E+00, 1.1746805965E-01, 1.0272152707E-01, 8.1893216200E-01],
	[4.0450000000E+04, 1.6546798609E+00, 1.6190529626E+00, 1.1751235489E-01, 1.0275659944E-01, 8.1895846417E-01],
	[4.0455000000E+04, 1.6550064559E+00, 1.6190386557E+00, 1.1755666136E-01, 1.0279167841E-01, 8.1898476446E-01],
	[4.0460000000E+04, 1.6553330750E+00, 1.6190243506E+00, 1.1760097905E-01, 1.0282676397E-01, 8.1901106288E-01],
	[4.0465000000E+04, 1.6556597182E+00, 1.6190100474E+00, 1.1764530797E-01, 1.0286185611E-01, 8.1903735942E-01],
	[4.0470000000E+04, 1.6559863855E+00, 1.6189957461E+00, 1.1768964811E-01, 1.0289695485E-01, 8.1906365408E-01],
	[4.0475000000E+04, 1.6563130769E+00, 1.6189814467E+00, 1.1773399949E-01, 1.0293206018E-01, 8.1908994686E-01],
	[4.0480000000E+04, 1.6566397923E+00, 1.6189671493E+00, 1.1777836210E-01, 1.0296717210E-01, 8.1911623777E-01],
	[4.0485000000E+04, 1.6569665318E+00, 1.6189528537E+00, 1.1782273595E-01, 1.0300229061E-01, 8.1914252679E-01],
	[4.0490000000E+04, 1.6572932954E+00, 1.6189385599E+00, 1.1786712103E-01, 1.0303741570E-01, 8.1916881393E-01],
	[4.0495000000E+04, 1.6576200831E+00, 1.6189242681E+00, 1.1791151734E-01, 1.0307254739E-01, 8.1919509919E-01],
	[4.0500000000E+04, 1.6579468948E+00, 1.6189099782E+00, 1.1795592490E-01, 1.0310768566E-01, 8.1922138256E-01],
	[4.0505000000E+04, 1.6582737307E+00, 1.6188956902E+00, 1.1800034369E-01, 1.0314283053E-01, 8.1924766405E-01],
	[4.0510000000E+04, 1.6586005906E+00, 1.6188814040E+00, 1.1804477372E-01, 1.0317798198E-01, 8.1927394366E-01],
	[4.0515000000E+04, 1.6589281807E+00, 1.6188679254E+00, 1.1808921500E-01, 1.0321314603E-01, 8.1930022138E-01],
	[4.0520000000E+04, 1.6592558270E+00, 1.6188544849E+00, 1.1813366752E-01, 1.0324831694E-01, 8.1932649722E-01],
	[4.0525000000E+04, 1.6595834976E+00, 1.6188410462E+00, 1.1817813129E-01, 1.0328349445E-01, 8.1935277117E-01],
	[4.0530000000E+04, 1.6599111925E+00, 1.6188276093E+00, 1.1822260630E-01, 1.0331867855E-01, 8.1937904324E-01],
	[4.0535000000E+04, 1.6602389116E+00, 1.6188141741E+00, 1.1826709256E-01, 1.0335386924E-01, 8.1940531342E-01],
	[4.0540000000E+04, 1.6605666550E+00, 1.6188007407E+00, 1.1831159007E-01, 1.0338906653E-01, 8.1943158171E-01],
	[4.0545000000E+04, 1.6608944226E+00, 1.6187873091E+00, 1.1835609884E-01, 1.0342427042E-01, 8.1945784811E-01],
	[4.0550000000E+04, 1.6612222146E+00, 1.6187738793E+00, 1.1840061885E-01, 1.0345948089E-01, 8.1948411262E-01],
	[4.0555000000E+04, 1.6615500308E+00, 1.6187604512E+00, 1.1844515012E-01, 1.0349469796E-01, 8.1951037525E-01],
	[4.0560000000E+04, 1.6618778712E+00, 1.6187470249E+00, 1.1848969264E-01, 1.0352992162E-01, 8.1953663598E-01],
	[4.0565000000E+04, 1.6622057359E+00, 1.6187336003E+00, 1.1853424642E-01, 1.0356515187E-01, 8.1956289482E-01],
	[4.0570000000E+04, 1.6625336249E+00, 1.6187201775E+00, 1.1857881146E-01, 1.0360038871E-01, 8.1958915177E-01],
	[4.0575000000E+04, 1.6628615382E+00, 1.6187067565E+00, 1.1862338776E-01, 1.0363563215E-01, 8.1961540683E-01],
	[4.0580000000E+04, 1.6631894757E+00, 1.6186933372E+00, 1.1866797532E-01, 1.0367088217E-01, 8.1964166000E-01],
	[4.0585000000E+04, 1.6635174374E+00, 1.6186799198E+00, 1.1871257415E-01, 1.0370613879E-01, 8.1966791127E-01],
	[4.0590000000E+04, 1.6638454234E+00, 1.6186665040E+00, 1.1875718424E-01, 1.0374140200E-01, 8.1969416064E-01],
	[4.0595000000E+04, 1.6641734337E+00, 1.6186530901E+00, 1.1880180559E-01, 1.0377667180E-01, 8.1972040813E-01],
	[4.0600000000E+04, 1.6645014682E+00, 1.6186396779E+00, 1.1884643821E-01, 1.0381194819E-01, 8.1974665371E-01],
	[4.0605000000E+04, 1.6648295270E+00, 1.6186262674E+00, 1.1889108210E-01, 1.0384723117E-01, 8.1977289740E-01],
	[4.0610000000E+04, 1.6651576100E+00, 1.6186128588E+00, 1.1893573726E-01, 1.0388252073E-01, 8.1979913920E-01],
	[4.0615000000E+04, 1.6654857173E+00, 1.6185994518E+00, 1.1898040369E-01, 1.0391781689E-01, 8.1982537909E-01],
	[4.0620000000E+04, 1.6658138488E+00, 1.6185860467E+00, 1.1902508139E-01, 1.0395311964E-01, 8.1985161709E-01],
	[4.0625000000E+04, 1.6661420046E+00, 1.6185726433E+00, 1.1906977037E-01, 1.0398842898E-01, 8.1987785319E-01],
	[4.0630000000E+04, 1.6664701846E+00, 1.6185592417E+00, 1.1911447063E-01, 1.0402374490E-01, 8.1990408739E-01],
	[4.0635000000E+04, 1.6667983889E+00, 1.6185458418E+00, 1.1915918216E-01, 1.0405906741E-01, 8.1993031969E-01],
	[4.0640000000E+04, 1.6671266174E+00, 1.6185324437E+00, 1.1920390497E-01, 1.0409439651E-01, 8.1995655009E-01],
	[4.0645000000E+04, 1.6674548701E+00, 1.6185190473E+00, 1.1924863906E-01, 1.0412973220E-01, 8.1998277858E-01],
	[4.0650000000E+04, 1.6677831471E+00, 1.6185056527E+00, 1.1929338443E-01, 1.0416507448E-01, 8.2000900518E-01],
	[4.0655000000E+04, 1.6681114484E+00, 1.6184922599E+00, 1.1933814109E-01, 1.0420042334E-01, 8.2003522987E-01],
	[4.0660000000E+04, 1.6684397739E+00, 1.6184788688E+00, 1.1938290903E-01, 1.0423577879E-01, 8.2006145266E-01],
	[4.0665000000E+04, 1.6687681236E+00, 1.6184654795E+00, 1.1942768825E-01, 1.0427114083E-01, 8.2008767355E-01],
	[4.0670000000E+04, 1.6690964975E+00, 1.6184520919E+00, 1.1947247877E-01, 1.0430650946E-01, 8.2011389253E-01],
	[4.0675000000E+04, 1.6694248957E+00, 1.6184387061E+00, 1.1951728057E-01, 1.0434188467E-01, 8.2014010961E-01],
	[4.0680000000E+04, 1.6697533181E+00, 1.6184253221E+00, 1.1956209367E-01, 1.0437726646E-01, 8.2016632478E-01],
	[4.0685000000E+04, 1.6700817648E+00, 1.6184119398E+00, 1.1960691805E-01, 1.0441265484E-01, 8.2019253804E-01],
	[4.0690000000E+04, 1.6704102357E+00, 1.6183985593E+00, 1.1965175373E-01, 1.0444804981E-01, 8.2021874940E-01],
	[4.0695000000E+04, 1.6707387308E+00, 1.6183851805E+00, 1.1969660070E-01, 1.0448345136E-01, 8.2024495885E-01],
	[4.0700000000E+04, 1.6710672502E+00, 1.6183718034E+00, 1.1974145897E-01, 1.0451885950E-01, 8.2027116639E-01],
	[4.0705000000E+04, 1.6713957938E+00, 1.6183584282E+00, 1.1978632854E-01, 1.0455427422E-01, 8.2029737202E-01],
	[4.0710000000E+04, 1.6717243616E+00, 1.6183450546E+00, 1.1983120941E-01, 1.0458969553E-01, 8.2032357574E-01],
	[4.0715000000E+04, 1.6720529536E+00, 1.6183316829E+00, 1.1987610158E-01, 1.0462512342E-01, 8.2034977756E-01],
	[4.0720000000E+04, 1.6723815699E+00, 1.6183183129E+00, 1.1992100505E-01, 1.0466055789E-01, 8.2037597746E-01],
	[4.0725000000E+04, 1.6727102103E+00, 1.6183049446E+00, 1.1996591982E-01, 1.0469599895E-01, 8.2040217545E-01],
	[4.0730000000E+04, 1.6730388751E+00, 1.6182915781E+00, 1.2001084590E-01, 1.0473144659E-01, 8.2042837153E-01],
	[4.0735000000E+04, 1.6733675640E+00, 1.6182782133E+00, 1.2005578329E-01, 1.0476690081E-01, 8.2045456569E-01],
	[4.0740000000E+04, 1.6736962771E+00, 1.6182648503E+00, 1.2010073198E-01, 1.0480236162E-01, 8.2048075794E-01],
	[4.0745000000E+04, 1.6740250145E+00, 1.6182514890E+00, 1.2014569198E-01, 1.0483782901E-01, 8.2050694828E-01],
	[4.0750000000E+04, 1.6743537761E+00, 1.6182381295E+00, 1.2019066329E-01, 1.0487330298E-01, 8.2053313670E-01],
	[4.0755000000E+04, 1.6746825619E+00, 1.6182247718E+00, 1.2023564592E-01, 1.0490878353E-01, 8.2055932321E-01],
	[4.0760000000E+04, 1.6750113719E+00, 1.6182114158E+00, 1.2028063986E-01, 1.0494427067E-01, 8.2058550780E-01],
	[4.0765000000E+04, 1.6753402062E+00, 1.6181980615E+00, 1.2032564511E-01, 1.0497976438E-01, 8.2061169048E-01],
	[4.0770000000E+04, 1.6756690646E+00, 1.6181847090E+00, 1.2037066169E-01, 1.0501526468E-01, 8.2063787124E-01],
	[4.0775000000E+04, 1.6759979473E+00, 1.6181713582E+00, 1.2041568958E-01, 1.0505077155E-01, 8.2066405008E-01],
	[4.0780000000E+04, 1.6763268542E+00, 1.6181580092E+00, 1.2046072879E-01, 1.0508628501E-01, 8.2069022700E-01],
	[4.0785000000E+04, 1.6766557853E+00, 1.6181446619E+00, 1.2050577932E-01, 1.0512180505E-01, 8.2071640201E-01],
	[4.0790000000E+04, 1.6769847406E+00, 1.6181313164E+00, 1.2055084117E-01, 1.0515733167E-01, 8.2074257509E-01],
	[4.0795000000E+04, 1.6773137201E+00, 1.6181179726E+00, 1.2059591435E-01, 1.0519286486E-01, 8.2076874625E-01],
	[4.0800000000E+04, 1.6776427238E+00, 1.6181046306E+00, 1.2064099885E-01, 1.0522840464E-01, 8.2079491549E-01],
	[4.0805000000E+04, 1.6779717517E+00, 1.6180912903E+00, 1.2068609468E-01, 1.0526395099E-01, 8.2082108282E-01],
	[4.0810000000E+04, 1.6783008038E+00, 1.6180779517E+00, 1.2073120184E-01, 1.0529950393E-01, 8.2084724821E-01],
	[4.0815000000E+04, 1.6786298801E+00, 1.6180646149E+00, 1.2077632032E-01, 1.0533506344E-01, 8.2087341169E-01],
	[4.0820000000E+04, 1.6789589806E+00, 1.6180512798E+00, 1.2082145014E-01, 1.0537062953E-01, 8.2089957324E-01],
	[4.0825000000E+04, 1.6792881054E+00, 1.6180379465E+00, 1.2086659129E-01, 1.0540620220E-01, 8.2092573287E-01],
	[4.0830000000E+04, 1.6796172543E+00, 1.6180246150E+00, 1.2091174378E-01, 1.0544178145E-01, 8.2095189058E-01],
	[4.0835000000E+04, 1.6799464274E+00, 1.6180112851E+00, 1.2095690760E-01, 1.0547736727E-01, 8.2097804636E-01],
	[4.0840000000E+04, 1.6802756247E+00, 1.6179979570E+00, 1.2100208276E-01, 1.0551295967E-01, 8.2100420021E-01],
	[4.0845000000E+04, 1.6806048462E+00, 1.6179846307E+00, 1.2104726926E-01, 1.0554855865E-01, 8.2103035213E-01],
	[4.0850000000E+04, 1.6809340920E+00, 1.6179713061E+00, 1.2109246709E-01, 1.0558416420E-01, 8.2105650213E-01],
	[4.0855000000E+04, 1.6812633619E+00, 1.6179579832E+00, 1.2113767627E-01, 1.0561977633E-01, 8.2108265021E-01],
	[4.0860000000E+04, 1.6815926560E+00, 1.6179446621E+00, 1.2118289679E-01, 1.0565539504E-01, 8.2110879635E-01],
	[4.0865000000E+04, 1.6819219742E+00, 1.6179313427E+00, 1.2122812866E-01, 1.0569102032E-01, 8.2113494056E-01],
	[4.0870000000E+04, 1.6822513167E+00, 1.6179180250E+00, 1.2127337187E-01, 1.0572665218E-01, 8.2116108285E-01],
	[4.0875000000E+04, 1.6825806834E+00, 1.6179047091E+00, 1.2131862643E-01, 1.0576229061E-01, 8.2118722320E-01],
	[4.0880000000E+04, 1.6829100742E+00, 1.6178913950E+00, 1.2136389234E-01, 1.0579793562E-01, 8.2121336162E-01],
	[4.0885000000E+04, 1.6832394893E+00, 1.6178780825E+00, 1.2140916960E-01, 1.0583358720E-01, 8.2123949812E-01],
	[4.0890000000E+04, 1.6835689285E+00, 1.6178647718E+00, 1.2145445821E-01, 1.0586924535E-01, 8.2126563268E-01],
	[4.0895000000E+04, 1.6838983919E+00, 1.6178514629E+00, 1.2149975817E-01, 1.0590491008E-01, 8.2129176530E-01],
	[4.0900000000E+04, 1.6842278795E+00, 1.6178381556E+00, 1.2154506949E-01, 1.0594058138E-01, 8.2131789600E-01],
	[4.0905000000E+04, 1.6845573913E+00, 1.6178248502E+00, 1.2159039216E-01, 1.0597625926E-01, 8.2134402476E-01],
	[4.0910000000E+04, 1.6848869272E+00, 1.6178115464E+00, 1.2163572619E-01, 1.0601194371E-01, 8.2137015158E-01],
	[4.0915000000E+04, 1.6852164874E+00, 1.6177982444E+00, 1.2168107158E-01, 1.0604763473E-01, 8.2139627647E-01],
	[4.0920000000E+04, 1.6855460717E+00, 1.6177849441E+00, 1.2172642833E-01, 1.0608333233E-01, 8.2142239943E-01],
	[4.0925000000E+04, 1.6858756802E+00, 1.6177716456E+00, 1.2177179645E-01, 1.0611903650E-01, 8.2144852045E-01],
	[4.0930000000E+04, 1.6862053128E+00, 1.6177583487E+00, 1.2181717592E-01, 1.0615474723E-01, 8.2147463953E-01],
	[4.0935000000E+04, 1.6865349697E+00, 1.6177450537E+00, 1.2186256676E-01, 1.0619046454E-01, 8.2150075667E-01],
	[4.0940000000E+04, 1.6868646507E+00, 1.6177317603E+00, 1.2190796897E-01, 1.0622618843E-01, 8.2152687187E-01],
	[4.0945000000E+04, 1.6871943558E+00, 1.6177184687E+00, 1.2195338255E-01, 1.0626191888E-01, 8.2155298514E-01],
	[4.0950000000E+04, 1.6875240852E+00, 1.6177051788E+00, 1.2199880749E-01, 1.0629765590E-01, 8.2157909647E-01],
	[4.0955000000E+04, 1.6878538387E+00, 1.6176918907E+00, 1.2204424380E-01, 1.0633339950E-01, 8.2160520585E-01],
	[4.0960000000E+04, 1.6881836164E+00, 1.6176786043E+00, 1.2208969149E-01, 1.0636914966E-01, 8.2163131330E-01],
	[4.0965000000E+04, 1.6885134183E+00, 1.6176653196E+00, 1.2213515055E-01, 1.0640490640E-01, 8.2165741880E-01],
	[4.0970000000E+04, 1.6888432443E+00, 1.6176520366E+00, 1.2218062099E-01, 1.0644066970E-01, 8.2168352237E-01],
	[4.0975000000E+04, 1.6891730945E+00, 1.6176387554E+00, 1.2222610280E-01, 1.0647643957E-01, 8.2170962399E-01],
	[4.0980000000E+04, 1.6895029689E+00, 1.6176254759E+00, 1.2227159599E-01, 1.0651221602E-01, 8.2173572366E-01],
	[4.0985000000E+04, 1.6898328674E+00, 1.6176121981E+00, 1.2231710056E-01, 1.0654799903E-01, 8.2176182140E-01],
	[4.0990000000E+04, 1.6901627901E+00, 1.6175989221E+00, 1.2236261651E-01, 1.0658378861E-01, 8.2178791719E-01],
	[4.0995000000E+04, 1.6904927369E+00, 1.6175856478E+00, 1.2240814384E-01, 1.0661958475E-01, 8.2181401103E-01],
	[4.1000000000E+04, 1.6908227079E+00, 1.6175723752E+00, 1.2245368255E-01, 1.0665538747E-01, 8.2184010293E-01],
	[4.1005000000E+04, 1.6911527031E+00, 1.6175591043E+00, 1.2249923266E-01, 1.0669119675E-01, 8.2186619288E-01],
	[4.1010000000E+04, 1.6914827224E+00, 1.6175458352E+00, 1.2254479414E-01, 1.0672701260E-01, 8.2189228088E-01],
	[4.1015000000E+04, 1.6918127658E+00, 1.6175325678E+00, 1.2259036702E-01, 1.0676283502E-01, 8.2191836694E-01],
	[4.1020000000E+04, 1.6921428335E+00, 1.6175193021E+00, 1.2263595128E-01, 1.0679866400E-01, 8.2194445105E-01],
	[4.1025000000E+04, 1.6924729252E+00, 1.6175060382E+00, 1.2268154694E-01, 1.0683449955E-01, 8.2197053321E-01],
	[4.1030000000E+04, 1.6928030412E+00, 1.6174927759E+00, 1.2272715399E-01, 1.0687034167E-01, 8.2199661342E-01],
	[4.1035000000E+04, 1.6931331813E+00, 1.6174795154E+00, 1.2277277243E-01, 1.0690619035E-01, 8.2202269169E-01],
	[4.1040000000E+04, 1.6934633455E+00, 1.6174662567E+00, 1.2281840227E-01, 1.0694204560E-01, 8.2204876800E-01],
	[4.1045000000E+04, 1.6937935339E+00, 1.6174529996E+00, 1.2286404351E-01, 1.0697790741E-01, 8.2207484236E-01],
	[4.1050000000E+04, 1.6941237464E+00, 1.6174397443E+00, 1.2290969614E-01, 1.0701377579E-01, 8.2210091477E-01],
	[4.1055000000E+04, 1.6944539831E+00, 1.6174264907E+00, 1.2295536017E-01, 1.0704965073E-01, 8.2212698522E-01],
	[4.1060000000E+04, 1.6947842439E+00, 1.6174132388E+00, 1.2300103561E-01, 1.0708553224E-01, 8.2215305373E-01],
	[4.1065000000E+04, 1.6951145289E+00, 1.6173999886E+00, 1.2304672245E-01, 1.0712142031E-01, 8.2217912028E-01],
	[4.1070000000E+04, 1.6954448380E+00, 1.6173867402E+00, 1.2309242069E-01, 1.0715731494E-01, 8.2220518487E-01],
	[4.1075000000E+04, 1.6957751712E+00, 1.6173734935E+00, 1.2313813033E-01, 1.0719321614E-01, 8.2223124751E-01],
	[4.1080000000E+04, 1.6961055286E+00, 1.6173602485E+00, 1.2318385139E-01, 1.0722912390E-01, 8.2225730820E-01],
	[4.1085000000E+04, 1.6964359101E+00, 1.6173470052E+00, 1.2322958385E-01, 1.0726503822E-01, 8.2228336693E-01],
	[4.1090000000E+04, 1.6967663158E+00, 1.6173337636E+00, 1.2327532772E-01, 1.0730095911E-01, 8.2230942370E-01],
	[4.1095000000E+04, 1.6970967456E+00, 1.6173205238E+00, 1.2332108301E-01, 1.0733688655E-01, 8.2233547852E-01],
	[4.1100000000E+04, 1.6974271995E+00, 1.6173072857E+00, 1.2336684971E-01, 1.0737282056E-01, 8.2236153138E-01],
	[4.1105000000E+04, 1.6977576776E+00, 1.6172940493E+00, 1.2341262782E-01, 1.0740876113E-01, 8.2238758228E-01],
	[4.1110000000E+04, 1.6980881798E+00, 1.6172808146E+00, 1.2345841734E-01, 1.0744470827E-01, 8.2241363122E-01],
	[4.1115000000E+04, 1.6984187061E+00, 1.6172675816E+00, 1.2350421829E-01, 1.0748066196E-01, 8.2243967820E-01],
	[4.1120000000E+04, 1.6987492566E+00, 1.6172543504E+00, 1.2355003065E-01, 1.0751662222E-01, 8.2246572322E-01],
	[4.1125000000E+04, 1.6990798312E+00, 1.6172411209E+00, 1.2359585444E-01, 1.0755258903E-01, 8.2249176628E-01],
	[4.1130000000E+04, 1.6994104299E+00, 1.6172278931E+00, 1.2364168964E-01, 1.0758856240E-01, 8.2251780738E-01],
	[4.1135000000E+04, 1.6997410528E+00, 1.6172146670E+00, 1.2368753627E-01, 1.0762454234E-01, 8.2254384652E-01],
	[4.1140000000E+04, 1.7000716998E+00, 1.6172014426E+00, 1.2373339432E-01, 1.0766052883E-01, 8.2256988369E-01],
	[4.1145000000E+04, 1.7004023709E+00, 1.6171882199E+00, 1.2377926380E-01, 1.0769652189E-01, 8.2259591891E-01],
	[4.1150000000E+04, 1.7007330661E+00, 1.6171749990E+00, 1.2382514471E-01, 1.0773252150E-01, 8.2262195216E-01],
	[4.1155000000E+04, 1.7010637855E+00, 1.6171617797E+00, 1.2387103704E-01, 1.0776852767E-01, 8.2264798344E-01],
	[4.1160000000E+04, 1.7013945289E+00, 1.6171485622E+00, 1.2391694081E-01, 1.0780454040E-01, 8.2267401276E-01],
	[4.1165000000E+04, 1.7017256895E+00, 1.6171357815E+00, 1.2396285601E-01, 1.0784056320E-01, 8.2270004011E-01],
	[4.1170000000E+04, 1.7020572301E+00, 1.6171233963E+00, 1.2400878264E-01, 1.0787659574E-01, 8.2272606550E-01],
	[4.1175000000E+04, 1.7023887951E+00, 1.6171110127E+00, 1.2405472070E-01, 1.0791263485E-01, 8.2275208892E-01],
	[4.1180000000E+04, 1.7027203843E+00, 1.6170986307E+00, 1.2410067020E-01, 1.0794868052E-01, 8.2277811037E-01],
	[4.1185000000E+04, 1.7030519979E+00, 1.6170862503E+00, 1.2414663114E-01, 1.0798473275E-01, 8.2280412986E-01],
	[4.1190000000E+04, 1.7033836357E+00, 1.6170738715E+00, 1.2419260352E-01, 1.0802079155E-01, 8.2283014738E-01],
	[4.1195000000E+04, 1.7037152979E+00, 1.6170614943E+00, 1.2423858734E-01, 1.0805685691E-01, 8.2285616292E-01],
	[4.1200000000E+04, 1.7040469844E+00, 1.6170491187E+00, 1.2428458260E-01, 1.0809292884E-01, 8.2288217650E-01],
	[4.1205000000E+04, 1.7043786952E+00, 1.6170367447E+00, 1.2433058931E-01, 1.0812900733E-01, 8.2290818811E-01],
	[4.1210000000E+04, 1.7047104303E+00, 1.6170243723E+00, 1.2437660746E-01, 1.0816509237E-01, 8.2293419775E-01],
	[4.1215000000E+04, 1.7050421898E+00, 1.6170120014E+00, 1.2442263706E-01, 1.0820118399E-01, 8.2296020541E-01],
	[4.1220000000E+04, 1.7053739735E+00, 1.6169996322E+00, 1.2446867810E-01, 1.0823728216E-01, 8.2298621111E-01],
	[4.1225000000E+04, 1.7057057816E+00, 1.6169872646E+00, 1.2451473059E-01, 1.0827338689E-01, 8.2301221483E-01],
	[4.1230000000E+04, 1.7060376139E+00, 1.6169748985E+00, 1.2456079454E-01, 1.0830949819E-01, 8.2303821658E-01],
	[4.1235000000E+04, 1.7063694706E+00, 1.6169625341E+00, 1.2460686993E-01, 1.0834561604E-01, 8.2306421635E-01],
	[4.1240000000E+04, 1.7067013515E+00, 1.6169501712E+00, 1.2465295678E-01, 1.0838174046E-01, 8.2309021415E-01],
	[4.1245000000E+04, 1.7070332568E+00, 1.6169378100E+00, 1.2469905509E-01, 1.0841787144E-01, 8.2311620997E-01],
	[4.1250000000E+04, 1.7073651863E+00, 1.6169254503E+00, 1.2474516485E-01, 1.0845400897E-01, 8.2314220382E-01],
	[4.1255000000E+04, 1.7076971402E+00, 1.6169130922E+00, 1.2479128607E-01, 1.0849015307E-01, 8.2316819570E-01],
	[4.1260000000E+04, 1.7080291184E+00, 1.6169007357E+00, 1.2483741875E-01, 1.0852630372E-01, 8.2319418559E-01],
	[4.1265000000E+04, 1.7083611208E+00, 1.6168883809E+00, 1.2488356289E-01, 1.0856246094E-01, 8.2322017351E-01],
	[4.1270000000E+04, 1.7086931476E+00, 1.6168760276E+00, 1.2492971850E-01, 1.0859862471E-01, 8.2324615945E-01],
	[4.1275000000E+04, 1.7090251986E+00, 1.6168636758E+00, 1.2497588557E-01, 1.0863479504E-01, 8.2327214341E-01],
	[4.1280000000E+04, 1.7093572740E+00, 1.6168513257E+00, 1.2502206410E-01, 1.0867097193E-01, 8.2329812540E-01],
	[4.1285000000E+04, 1.7096893736E+00, 1.6168389772E+00, 1.2506825410E-01, 1.0870715537E-01, 8.2332410540E-01],
	[4.1290000000E+04, 1.7100214975E+00, 1.6168266303E+00, 1.2511445557E-01, 1.0874334538E-01, 8.2335008342E-01],
	[4.1295000000E+04, 1.7103536457E+00, 1.6168142849E+00, 1.2516066850E-01, 1.0877954194E-01, 8.2337605946E-01],
	[4.1300000000E+04, 1.7106858182E+00, 1.6168019412E+00, 1.2520689291E-01, 1.0881574505E-01, 8.2340203352E-01],
	[4.1305000000E+04, 1.7110180150E+00, 1.6167895990E+00, 1.2525312879E-01, 1.0885195473E-01, 8.2342800560E-01],
	[4.1310000000E+04, 1.7113502361E+00, 1.6167772584E+00, 1.2529937615E-01, 1.0888817096E-01, 8.2345397570E-01],
	[4.1315000000E+04, 1.7116824815E+00, 1.6167649194E+00, 1.2534563498E-01, 1.0892439374E-01, 8.2347994381E-01],
	[4.1320000000E+04, 1.7120147511E+00, 1.6167525820E+00, 1.2539190529E-01, 1.0896062308E-01, 8.2350590994E-01],
	[4.1325000000E+04, 1.7123470451E+00, 1.6167402462E+00, 1.2543818708E-01, 1.0899685898E-01, 8.2353187408E-01],
	[4.1330000000E+04, 1.7126793633E+00, 1.6167279119E+00, 1.2548448034E-01, 1.0903310143E-01, 8.2355783624E-01],
	[4.1335000000E+04, 1.7130117058E+00, 1.6167155793E+00, 1.2553078509E-01, 1.0906935043E-01, 8.2358379642E-01],
	[4.1340000000E+04, 1.7133440726E+00, 1.6167032482E+00, 1.2557710132E-01, 1.0910560599E-01, 8.2360975460E-01],
	[4.1345000000E+04, 1.7136764636E+00, 1.6166909188E+00, 1.2562342904E-01, 1.0914186810E-01, 8.2363571080E-01],
	[4.1350000000E+04, 1.7140088790E+00, 1.6166785909E+00, 1.2566976824E-01, 1.0917813677E-01, 8.2366166502E-01],
	[4.1355000000E+04, 1.7143413186E+00, 1.6166662646E+00, 1.2571611893E-01, 1.0921441199E-01, 8.2368761724E-01],
	[4.1360000000E+04, 1.7146737825E+00, 1.6166539398E+00, 1.2576248111E-01, 1.0925069376E-01, 8.2371356748E-01],
	[4.1365000000E+04, 1.7150062706E+00, 1.6166416167E+00, 1.2580885478E-01, 1.0928698209E-01, 8.2373951573E-01],
	[4.1370000000E+04, 1.7153387831E+00, 1.6166292951E+00, 1.2585523993E-01, 1.0932327697E-01, 8.2376546199E-01],
	[4.1375000000E+04, 1.7156713198E+00, 1.6166169752E+00, 1.2590163659E-01, 1.0935957840E-01, 8.2379140626E-01],
	[4.1380000000E+04, 1.7160038808E+00, 1.6166046568E+00, 1.2594804473E-01, 1.0939588638E-01, 8.2381734853E-01],
	[4.1385000000E+04, 1.7163364660E+00, 1.6165923400E+00, 1.2599446438E-01, 1.0943220091E-01, 8.2384328882E-01],
	[4.1390000000E+04, 1.7166690755E+00, 1.6165800247E+00, 1.2604089552E-01, 1.0946852199E-01, 8.2386922711E-01],
	[4.1395000000E+04, 1.7170017093E+00, 1.6165677111E+00, 1.2608733816E-01, 1.0950484963E-01, 8.2389516341E-01],
	[4.1400000000E+04, 1.7173343674E+00, 1.6165553990E+00, 1.2613379230E-01, 1.0954118381E-01, 8.2392109772E-01],
	[4.1405000000E+04, 1.7176670497E+00, 1.6165430886E+00, 1.2618025794E-01, 1.0957752455E-01, 8.2394703004E-01],
	[4.1410000000E+04, 1.7179997563E+00, 1.6165307797E+00, 1.2622673508E-01, 1.0961387183E-01, 8.2397296036E-01],
	[4.1415000000E+04, 1.7183324871E+00, 1.6165184723E+00, 1.2627322373E-01, 1.0965022567E-01, 8.2399888868E-01],
	[4.1420000000E+04, 1.7186652422E+00, 1.6165061666E+00, 1.2631972389E-01, 1.0968658605E-01, 8.2402481501E-01],
	[4.1425000000E+04, 1.7189980216E+00, 1.6164938624E+00, 1.2636623555E-01, 1.0972295298E-01, 8.2405073935E-01],
	[4.1430000000E+04, 1.7193308252E+00, 1.6164815598E+00, 1.2641275873E-01, 1.0975932646E-01, 8.2407666168E-01],
	[4.1435000000E+04, 1.7196636531E+00, 1.6164692588E+00, 1.2645929341E-01, 1.0979570649E-01, 8.2410258202E-01],
	[4.1440000000E+04, 1.7199965052E+00, 1.6164569594E+00, 1.2650583961E-01, 1.0983209307E-01, 8.2412850037E-01],
	[4.1445000000E+04, 1.7203293816E+00, 1.6164446615E+00, 1.2655239731E-01, 1.0986848619E-01, 8.2415441671E-01],
	[4.1450000000E+04, 1.7206622823E+00, 1.6164323653E+00, 1.2659896654E-01, 1.0990488586E-01, 8.2418033106E-01],
	[4.1455000000E+04, 1.7209952072E+00, 1.6164200706E+00, 1.2664554728E-01, 1.0994129208E-01, 8.2420624340E-01],
	[4.1460000000E+04, 1.7213281563E+00, 1.6164077774E+00, 1.2669213954E-01, 1.0997770484E-01, 8.2423215375E-01],
	[4.1465000000E+04, 1.7216611297E+00, 1.6163954859E+00, 1.2673874331E-01, 1.1001412416E-01, 8.2425806209E-01],
	[4.1470000000E+04, 1.7219941274E+00, 1.6163831959E+00, 1.2678535861E-01, 1.1005055001E-01, 8.2428396844E-01],
	[4.1475000000E+04, 1.7223271493E+00, 1.6163709075E+00, 1.2683198543E-01, 1.1008698241E-01, 8.2430987278E-01],
	[4.1480000000E+04, 1.7226601955E+00, 1.6163586207E+00, 1.2687862378E-01, 1.1012342136E-01, 8.2433577512E-01],
	[4.1485000000E+04, 1.7229932659E+00, 1.6163463355E+00, 1.2692527365E-01, 1.1015986685E-01, 8.2436167545E-01],
	[4.1490000000E+04, 1.7233263605E+00, 1.6163340518E+00, 1.2697193504E-01, 1.1019631889E-01, 8.2438757379E-01],
	[4.1495000000E+04, 1.7236594794E+00, 1.6163217697E+00, 1.2701860797E-01, 1.1023277747E-01, 8.2441347012E-01],
	[4.1500000000E+04, 1.7239926225E+00, 1.6163094892E+00, 1.2706529242E-01, 1.1026924260E-01, 8.2443936444E-01],
	[4.1505000000E+04, 1.7243257899E+00, 1.6162972102E+00, 1.2711198841E-01, 1.1030571427E-01, 8.2446525676E-01],
	[4.1510000000E+04, 1.7246589815E+00, 1.6162849328E+00, 1.2715869593E-01, 1.1034219248E-01, 8.2449114708E-01],
	[4.1515000000E+04, 1.7249921974E+00, 1.6162726570E+00, 1.2720541498E-01, 1.1037867724E-01, 8.2451703538E-01],
	[4.1520000000E+04, 1.7253254375E+00, 1.6162603828E+00, 1.2725214556E-01, 1.1041516853E-01, 8.2454292168E-01],
	[4.1525000000E+04, 1.7256587018E+00, 1.6162481101E+00, 1.2729888769E-01, 1.1045166637E-01, 8.2456880598E-01],
	[4.1530000000E+04, 1.7259919904E+00, 1.6162358390E+00, 1.2734564135E-01, 1.1048817076E-01, 8.2459468826E-01],
	[4.1535000000E+04, 1.7263253032E+00, 1.6162235695E+00, 1.2739240655E-01, 1.1052468168E-01, 8.2462056854E-01],
	[4.1540000000E+04, 1.7266586402E+00, 1.6162113016E+00, 1.2743918329E-01, 1.1056119915E-01, 8.2464644680E-01],
	[4.1545000000E+04, 1.7269920015E+00, 1.6161990352E+00, 1.2748597158E-01, 1.1059772315E-01, 8.2467232306E-01],
	[4.1550000000E+04, 1.7273253870E+00, 1.6161867704E+00, 1.2753277141E-01, 1.1063425370E-01, 8.2469819731E-01],
	[4.1555000000E+04, 1.7276587967E+00, 1.6161745071E+00, 1.2757958279E-01, 1.1067079079E-01, 8.2472406955E-01],
	[4.1560000000E+04, 1.7279922306E+00, 1.6161622454E+00, 1.2762640571E-01, 1.1070733441E-01, 8.2474993977E-01],
	[4.1565000000E+04, 1.7283256888E+00, 1.6161499853E+00, 1.2767324018E-01, 1.1074388458E-01, 8.2477580798E-01],
	[4.1570000000E+04, 1.7286591712E+00, 1.6161377268E+00, 1.2772008620E-01, 1.1078044129E-01, 8.2480167418E-01],
	[4.1575000000E+04, 1.7289926779E+00, 1.6161254698E+00, 1.2776694377E-01, 1.1081700453E-01, 8.2482753837E-01],
	[4.1580000000E+04, 1.7293262087E+00, 1.6161132144E+00, 1.2781381290E-01, 1.1085357432E-01, 8.2485340054E-01],
	[4.1585000000E+04, 1.7296597638E+00, 1.6161009605E+00, 1.2786069358E-01, 1.1089015064E-01, 8.2487926070E-01],
	[4.1590000000E+04, 1.7299933431E+00, 1.6160887083E+00, 1.2790758581E-01, 1.1092673350E-01, 8.2490511885E-01],
	[4.1595000000E+04, 1.7303269467E+00, 1.6160764576E+00, 1.2795448961E-01, 1.1096332290E-01, 8.2493097498E-01],
	[4.1600000000E+04, 1.7306605744E+00, 1.6160642084E+00, 1.2800140496E-01, 1.1099991883E-01, 8.2495682909E-01],
	[4.1605000000E+04, 1.7309942264E+00, 1.6160519608E+00, 1.2804833187E-01, 1.1103652131E-01, 8.2498268118E-01],
	[4.1610000000E+04, 1.7313279026E+00, 1.6160397148E+00, 1.2809527034E-01, 1.1107313032E-01, 8.2500853126E-01],
	[4.1615000000E+04, 1.7316616030E+00, 1.6160274704E+00, 1.2814222038E-01, 1.1110974586E-01, 8.2503437933E-01],
	[4.1620000000E+04, 1.7319953276E+00, 1.6160152275E+00, 1.2818918198E-01, 1.1114636795E-01, 8.2506022537E-01],
	[4.1625000000E+04, 1.7323290764E+00, 1.6160029862E+00, 1.2823615515E-01, 1.1118299656E-01, 8.2508606939E-01],
	[4.1630000000E+04, 1.7326628495E+00, 1.6159907464E+00, 1.2828313988E-01, 1.1121963172E-01, 8.2511191140E-01],
	[4.1635000000E+04, 1.7329966467E+00, 1.6159785082E+00, 1.2833013619E-01, 1.1125627341E-01, 8.2513775138E-01],
	[4.1640000000E+04, 1.7333304682E+00, 1.6159662716E+00, 1.2837714406E-01, 1.1129292163E-01, 8.2516358935E-01],
	[4.1645000000E+04, 1.7336643139E+00, 1.6159540365E+00, 1.2842416351E-01, 1.1132957639E-01, 8.2518942529E-01],
	[4.1650000000E+04, 1.7339981837E+00, 1.6159418030E+00, 1.2847119453E-01, 1.1136623768E-01, 8.2521525922E-01],
	[4.1655000000E+04, 1.7343320778E+00, 1.6159295710E+00, 1.2851823712E-01, 1.1140290550E-01, 8.2524109112E-01],
	[4.1660000000E+04, 1.7346659961E+00, 1.6159173406E+00, 1.2856529129E-01, 1.1143957986E-01, 8.2526692099E-01],
	[4.1665000000E+04, 1.7349999386E+00, 1.6159051118E+00, 1.2861235704E-01, 1.1147626075E-01, 8.2529274885E-01],
	[4.1670000000E+04, 1.7353339053E+00, 1.6158928845E+00, 1.2865943436E-01, 1.1151294818E-01, 8.2531857468E-01],
	[4.1675000000E+04, 1.7356678963E+00, 1.6158806588E+00, 1.2870652327E-01, 1.1154964213E-01, 8.2534439848E-01],
	[4.1680000000E+04, 1.7360019114E+00, 1.6158684347E+00, 1.2875362376E-01, 1.1158634262E-01, 8.2537022027E-01],
	[4.1685000000E+04, 1.7363359507E+00, 1.6158562121E+00, 1.2880073584E-01, 1.1162304964E-01, 8.2539604002E-01],
	[4.1690000000E+04, 1.7366700142E+00, 1.6158439911E+00, 1.2884785949E-01, 1.1165976320E-01, 8.2542185775E-01],
	[4.1695000000E+04, 1.7370041019E+00, 1.6158317716E+00, 1.2889499474E-01, 1.1169648328E-01, 8.2544767345E-01],
	[4.1700000000E+04, 1.7373382138E+00, 1.6158195537E+00, 1.2894214157E-01, 1.1173320989E-01, 8.2547348713E-01],
	[4.1705000000E+04, 1.7376723499E+00, 1.6158073373E+00, 1.2898929999E-01, 1.1176994304E-01, 8.2549929878E-01],
	[4.1710000000E+04, 1.7380065102E+00, 1.6157951225E+00, 1.2903647001E-01, 1.1180668271E-01, 8.2552510840E-01],
	[4.1715000000E+04, 1.7383406947E+00, 1.6157829093E+00, 1.2908365161E-01, 1.1184342891E-01, 8.2555091599E-01],
	[4.1720000000E+04, 1.7386749034E+00, 1.6157706976E+00, 1.2913084481E-01, 1.1188018165E-01, 8.2557672155E-01],
	[4.1725000000E+04, 1.7390091362E+00, 1.6157584874E+00, 1.2917804960E-01, 1.1191694091E-01, 8.2560252508E-01],
	[4.1730000000E+04, 1.7393433933E+00, 1.6157462788E+00, 1.2922526599E-01, 1.1195370670E-01, 8.2562832658E-01],
	[4.1735000000E+04, 1.7396776746E+00, 1.6157340718E+00, 1.2927249398E-01, 1.1199047902E-01, 8.2565412605E-01],
	[4.1740000000E+04, 1.7400119800E+00, 1.6157218664E+00, 1.2931973357E-01, 1.1202725787E-01, 8.2567992349E-01],
	[4.1745000000E+04, 1.7403463096E+00, 1.6157096624E+00, 1.2936698476E-01, 1.1206404324E-01, 8.2570571890E-01],
	[4.1750000000E+04, 1.7406806634E+00, 1.6156974601E+00, 1.2941424755E-01, 1.1210083514E-01, 8.2573151227E-01],
	[4.1755000000E+04, 1.7410150414E+00, 1.6156852593E+00, 1.2946152195E-01, 1.1213763357E-01, 8.2575730362E-01],
	[4.1760000000E+04, 1.7413494436E+00, 1.6156730600E+00, 1.2950880795E-01, 1.1217443853E-01, 8.2578309292E-01],
	[4.1765000000E+04, 1.7416838700E+00, 1.6156608623E+00, 1.2955610556E-01, 1.1221125001E-01, 8.2580888019E-01],
	[4.1770000000E+04, 1.7420183205E+00, 1.6156486662E+00, 1.2960341478E-01, 1.1224806801E-01, 8.2583466543E-01],
	[4.1775000000E+04, 1.7423527952E+00, 1.6156364716E+00, 1.2965073560E-01, 1.1228489255E-01, 8.2586044863E-01],
	[4.1780000000E+04, 1.7426872941E+00, 1.6156242785E+00, 1.2969806804E-01, 1.1232172361E-01, 8.2588622980E-01],
	[4.1785000000E+04, 1.7430218172E+00, 1.6156120870E+00, 1.2974541209E-01, 1.1235856119E-01, 8.2591200893E-01],
	[4.1790000000E+04, 1.7433563645E+00, 1.6155998971E+00, 1.2979276775E-01, 1.1239540530E-01, 8.2593778602E-01],
	[4.1795000000E+04, 1.7436909359E+00, 1.6155877087E+00, 1.2984013503E-01, 1.1243225593E-01, 8.2596356108E-01],
	[4.1800000000E+04, 1.7440255315E+00, 1.6155755218E+00, 1.2988751393E-01, 1.1246911308E-01, 8.2598933410E-01],
	[4.1805000000E+04, 1.7443601513E+00, 1.6155633365E+00, 1.2993490445E-01, 1.1250597676E-01, 8.2601510507E-01],
	[4.1810000000E+04, 1.7446947952E+00, 1.6155511528E+00, 1.2998230658E-01, 1.1254284697E-01, 8.2604087401E-01],
	[4.1815000000E+04, 1.7450294633E+00, 1.6155389706E+00, 1.3002972034E-01, 1.1257972369E-01, 8.2606664091E-01],
	[4.1820000000E+04, 1.7453641556E+00, 1.6155267899E+00, 1.3007714572E-01, 1.1261660694E-01, 8.2609240577E-01],
	[4.1825000000E+04, 1.7456988721E+00, 1.6155146108E+00, 1.3012458273E-01, 1.1265349671E-01, 8.2611816859E-01],
	[4.1830000000E+04, 1.7460343670E+00, 1.6155032439E+00, 1.3017203136E-01, 1.1269040009E-01, 8.2614392937E-01],
	[4.1835000000E+04, 1.7463698914E+00, 1.6154918839E+00, 1.3021949161E-01, 1.1272731004E-01, 8.2616968810E-01],
	[4.1840000000E+04, 1.7467054402E+00, 1.6154805254E+00, 1.3026696350E-01, 1.1276422652E-01, 8.2619544479E-01],
	[4.1845000000E+04, 1.7470410133E+00, 1.6154691683E+00, 1.3031444702E-01, 1.1280114954E-01, 8.2622119944E-01],
	[4.1850000000E+04, 1.7473766108E+00, 1.6154578127E+00, 1.3036194216E-01, 1.1283807908E-01, 8.2624695205E-01],
	[4.1855000000E+04, 1.7477122327E+00, 1.6154464584E+00, 1.3040944895E-01, 1.1287501514E-01, 8.2627270261E-01],
	[4.1860000000E+04, 1.7480478789E+00, 1.6154351057E+00, 1.3045696736E-01, 1.1291195773E-01, 8.2629845112E-01],
	[4.1865000000E+04, 1.7483835495E+00, 1.6154237543E+00, 1.3050449741E-01, 1.1294890686E-01, 8.2632419759E-01],
	[4.1870000000E+04, 1.7487192444E+00, 1.6154124044E+00, 1.3055203910E-01, 1.1298586250E-01, 8.2634994202E-01],
	[4.1875000000E+04, 1.7490549637E+00, 1.6154010559E+00, 1.3059959243E-01, 1.1302282467E-01, 8.2637568440E-01],
	[4.1880000000E+04, 1.7493907074E+00, 1.6153897089E+00, 1.3064715740E-01, 1.1305979337E-01, 8.2640142473E-01],
	[4.1885000000E+04, 1.7497264754E+00, 1.6153783633E+00, 1.3069473401E-01, 1.1309676860E-01, 8.2642716301E-01],
	[4.1890000000E+04, 1.7500622677E+00, 1.6153670191E+00, 1.3074232227E-01, 1.1313375034E-01, 8.2645289925E-01],
	[4.1895000000E+04, 1.7503980845E+00, 1.6153556763E+00, 1.3078992217E-01, 1.1317073862E-01, 8.2647863344E-01],
	[4.1900000000E+04, 1.7507339255E+00, 1.6153443350E+00, 1.3083753371E-01, 1.1320773341E-01, 8.2650436558E-01],
	[4.1905000000E+04, 1.7510697909E+00, 1.6153329951E+00, 1.3088515691E-01, 1.1324473473E-01, 8.2653009567E-01],
	[4.1910000000E+04, 1.7514056807E+00, 1.6153216567E+00, 1.3093279175E-01, 1.1328174258E-01, 8.2655582371E-01],
	[4.1915000000E+04, 1.7517415948E+00, 1.6153103197E+00, 1.3098043824E-01, 1.1331875695E-01, 8.2658154969E-01],
	[4.1920000000E+04, 1.7520775333E+00, 1.6152989841E+00, 1.3102809639E-01, 1.1335577784E-01, 8.2660727363E-01],
	[4.1925000000E+04, 1.7524134961E+00, 1.6152876500E+00, 1.3107576618E-01, 1.1339280525E-01, 8.2663299552E-01],
	[4.1930000000E+04, 1.7527494833E+00, 1.6152763172E+00, 1.3112344764E-01, 1.1342983919E-01, 8.2665871535E-01],
	[4.1935000000E+04, 1.7530854948E+00, 1.6152649860E+00, 1.3117114075E-01, 1.1346687964E-01, 8.2668443313E-01],
	[4.1940000000E+04, 1.7534215306E+00, 1.6152536561E+00, 1.3121884552E-01, 1.1350392662E-01, 8.2671014886E-01],
	[4.1945000000E+04, 1.7537575908E+00, 1.6152423277E+00, 1.3126656194E-01, 1.1354098012E-01, 8.2673586253E-01],
	[4.1950000000E+04, 1.7540936753E+00, 1.6152310007E+00, 1.3131429003E-01, 1.1357804014E-01, 8.2676157415E-01],
	[4.1955000000E+04, 1.7544297842E+00, 1.6152196751E+00, 1.3136202978E-01, 1.1361510668E-01, 8.2678728371E-01],
	[4.1960000000E+04, 1.7547659174E+00, 1.6152083510E+00, 1.3140978120E-01, 1.1365217974E-01, 8.2681299122E-01],
	[4.1965000000E+04, 1.7551020749E+00, 1.6151970283E+00, 1.3145754428E-01, 1.1368925932E-01, 8.2683869667E-01],
	[4.1970000000E+04, 1.7554382568E+00, 1.6151857070E+00, 1.3150531902E-01, 1.1372634542E-01, 8.2686440007E-01],
	[4.1975000000E+04, 1.7557744630E+00, 1.6151743871E+00, 1.3155310544E-01, 1.1376343804E-01, 8.2689010141E-01],
	[4.1980000000E+04, 1.7561106936E+00, 1.6151630687E+00, 1.3160090352E-01, 1.1380053718E-01, 8.2691580069E-01],
	[4.1985000000E+04, 1.7564469484E+00, 1.6151517517E+00, 1.3164871328E-01, 1.1383764284E-01, 8.2694149791E-01],
	[4.1990000000E+04, 1.7567832276E+00, 1.6151404361E+00, 1.3169653471E-01, 1.1387475501E-01, 8.2696719308E-01],
	[4.1995000000E+04, 1.7571195312E+00, 1.6151291220E+00, 1.3174436781E-01, 1.1391187370E-01, 8.2699288618E-01],
	[4.2000000000E+04, 1.7574558590E+00, 1.6151178093E+00, 1.3179221259E-01, 1.1394899891E-01, 8.2701857722E-01],
	[4.2005000000E+04, 1.7577922112E+00, 1.6151064980E+00, 1.3184006904E-01, 1.1398613063E-01, 8.2704426621E-01],
	[4.2010000000E+04, 1.7581285878E+00, 1.6150951881E+00, 1.3188793717E-01, 1.1402326888E-01, 8.2706995313E-01],
	[4.2015000000E+04, 1.7584649886E+00, 1.6150838797E+00, 1.3193581698E-01, 1.1406041363E-01, 8.2709563800E-01],
	[4.2020000000E+04, 1.7588014138E+00, 1.6150725727E+00, 1.3198370848E-01, 1.1409756491E-01, 8.2712132080E-01],
	[4.2025000000E+04, 1.7591378633E+00, 1.6150612671E+00, 1.3203161165E-01, 1.1413472270E-01, 8.2714700153E-01],
	[4.2030000000E+04, 1.7594743371E+00, 1.6150499629E+00, 1.3207952652E-01, 1.1417188700E-01, 8.2717268021E-01],
	[4.2035000000E+04, 1.7598108352E+00, 1.6150386601E+00, 1.3212745306E-01, 1.1420905782E-01, 8.2719835682E-01],
	[4.2040000000E+04, 1.7601473577E+00, 1.6150273588E+00, 1.3217539130E-01, 1.1424623515E-01, 8.2722403137E-01],
	[4.2045000000E+04, 1.7604839045E+00, 1.6150160589E+00, 1.3222334122E-01, 1.1428341900E-01, 8.2724970385E-01],
	[4.2050000000E+04, 1.7608204756E+00, 1.6150047605E+00, 1.3227130283E-01, 1.1432060936E-01, 8.2727537427E-01],
	[4.2055000000E+04, 1.7611570710E+00, 1.6149934634E+00, 1.3231927613E-01, 1.1435780624E-01, 8.2730104262E-01],
	[4.2060000000E+04, 1.7614936907E+00, 1.6149821678E+00, 1.3236726113E-01, 1.1439500962E-01, 8.2732670891E-01],
	[4.2065000000E+04, 1.7618303347E+00, 1.6149708736E+00, 1.3241525782E-01, 1.1443221952E-01, 8.2735237313E-01],
	[4.2070000000E+04, 1.7621670031E+00, 1.6149595808E+00, 1.3246326621E-01, 1.1446943593E-01, 8.2737803528E-01],
	[4.2075000000E+04, 1.7625036958E+00, 1.6149482894E+00, 1.3251128629E-01, 1.1450665886E-01, 8.2740369536E-01],
	[4.2080000000E+04, 1.7628404127E+00, 1.6149369995E+00, 1.3255931808E-01, 1.1454388829E-01, 8.2742935338E-01],
	[4.2085000000E+04, 1.7631771540E+00, 1.6149257109E+00, 1.3260736156E-01, 1.1458112424E-01, 8.2745500933E-01],
	[4.2090000000E+04, 1.7635139196E+00, 1.6149144238E+00, 1.3265541674E-01, 1.1461836670E-01, 8.2748066321E-01],
	[4.2095000000E+04, 1.7638507095E+00, 1.6149031381E+00, 1.3270348363E-01, 1.1465561566E-01, 8.2750631501E-01],
	[4.2100000000E+04, 1.7641875237E+00, 1.6148918539E+00, 1.3275156223E-01, 1.1469287114E-01, 8.2753196475E-01],
	[4.2105000000E+04, 1.7645243622E+00, 1.6148805710E+00, 1.3279965252E-01, 1.1473013313E-01, 8.2755761242E-01],
	[4.2110000000E+04, 1.7648612251E+00, 1.6148692896E+00, 1.3284775453E-01, 1.1476740163E-01, 8.2758325802E-01],
	[4.2115000000E+04, 1.7651981122E+00, 1.6148580096E+00, 1.3289586825E-01, 1.1480467663E-01, 8.2760890154E-01],
	[4.2120000000E+04, 1.7655350236E+00, 1.6148467310E+00, 1.3294399367E-01, 1.1484195815E-01, 8.2763454299E-01],
	[4.2125000000E+04, 1.7658719593E+00, 1.6148354538E+00, 1.3299213081E-01, 1.1487924617E-01, 8.2766018237E-01],
	[4.2130000000E+04, 1.7662089193E+00, 1.6148241781E+00, 1.3304027966E-01, 1.1491654070E-01, 8.2768581967E-01],
	[4.2135000000E+04, 1.7665459037E+00, 1.6148129037E+00, 1.3308844023E-01, 1.1495384173E-01, 8.2771145490E-01],
	[4.2140000000E+04, 1.7668829123E+00, 1.6148016308E+00, 1.3313661251E-01, 1.1499114928E-01, 8.2773708806E-01],
	[4.2145000000E+04, 1.7672199452E+00, 1.6147903593E+00, 1.3318479651E-01, 1.1502846333E-01, 8.2776271914E-01],
	[4.2150000000E+04, 1.7675570024E+00, 1.6147790892E+00, 1.3323299223E-01, 1.1506578389E-01, 8.2778834815E-01],
	[4.2155000000E+04, 1.7678940839E+00, 1.6147678205E+00, 1.3328119967E-01, 1.1510311095E-01, 8.2781397508E-01],
	[4.2160000000E+04, 1.7682311897E+00, 1.6147565533E+00, 1.3332941884E-01, 1.1514044452E-01, 8.2783959993E-01],
	[4.2165000000E+04, 1.7685683198E+00, 1.6147452874E+00, 1.3337764972E-01, 1.1517778460E-01, 8.2786522271E-01],
	[4.2170000000E+04, 1.7689054742E+00, 1.6147340230E+00, 1.3342589233E-01, 1.1521513118E-01, 8.2789084340E-01],
	[4.2175000000E+04, 1.7692426529E+00, 1.6147227600E+00, 1.3347414667E-01, 1.1525248426E-01, 8.2791646202E-01],
	[4.2180000000E+04, 1.7695798558E+00, 1.6147114984E+00, 1.3352241274E-01, 1.1528984385E-01, 8.2794207857E-01],
	[4.2185000000E+04, 1.7699170831E+00, 1.6147002382E+00, 1.3357069053E-01, 1.1532720994E-01, 8.2796769303E-01],
	[4.2190000000E+04, 1.7702543346E+00, 1.6146889794E+00, 1.3361898006E-01, 1.1536458254E-01, 8.2799330541E-01],
	[4.2195000000E+04, 1.7705916104E+00, 1.6146777220E+00, 1.3366728132E-01, 1.1540196164E-01, 8.2801891571E-01],
	[4.2200000000E+04, 1.7709289105E+00, 1.6146664661E+00, 1.3371559431E-01, 1.1543934724E-01, 8.2804452393E-01],
	[4.2205000000E+04, 1.7712662349E+00, 1.6146552115E+00, 1.3376391904E-01, 1.1547673934E-01, 8.2807013007E-01],
	[4.2210000000E+04, 1.7716035835E+00, 1.6146439584E+00, 1.3381225550E-01, 1.1551413795E-01, 8.2809573413E-01],
	[4.2215000000E+04, 1.7719409565E+00, 1.6146327067E+00, 1.3386060370E-01, 1.1555154305E-01, 8.2812133611E-01],
	[4.2220000000E+04, 1.7722783537E+00, 1.6146214564E+00, 1.3390896365E-01, 1.1558895466E-01, 8.2814693600E-01],
	[4.2225000000E+04, 1.7726157752E+00, 1.6146102075E+00, 1.3395733533E-01, 1.1562637277E-01, 8.2817253381E-01],
	[4.2230000000E+04, 1.7729532210E+00, 1.6145989600E+00, 1.3400571876E-01, 1.1566379738E-01, 8.2819812954E-01],
	[4.2235000000E+04, 1.7732906910E+00, 1.6145877139E+00, 1.3405411393E-01, 1.1570122849E-01, 8.2822372318E-01],
	[4.2240000000E+04, 1.7736281854E+00, 1.6145764692E+00, 1.3410252084E-01, 1.1573866610E-01, 8.2824931473E-01],
	[4.2245000000E+04, 1.7739657040E+00, 1.6145652260E+00, 1.3415093950E-01, 1.1577611021E-01, 8.2827490420E-01],
	[4.2250000000E+04, 1.7743032468E+00, 1.6145539841E+00, 1.3419936992E-01, 1.1581356082E-01, 8.2830049159E-01],
	[4.2255000000E+04, 1.7746408140E+00, 1.6145427437E+00, 1.3424781208E-01, 1.1585101793E-01, 8.2832607689E-01],
	[4.2260000000E+04, 1.7749784054E+00, 1.6145315047E+00, 1.3429626599E-01, 1.1588848153E-01, 8.2835166010E-01],
	[4.2265000000E+04, 1.7753160211E+00, 1.6145202670E+00, 1.3434473165E-01, 1.1592595164E-01, 8.2837724122E-01],
	[4.2270000000E+04, 1.7756536610E+00, 1.6145090308E+00, 1.3439320907E-01, 1.1596342824E-01, 8.2840282026E-01],
	[4.2275000000E+04, 1.7759913253E+00, 1.6144977960E+00, 1.3444169825E-01, 1.1600091133E-01, 8.2842839721E-01],
	[4.2280000000E+04, 1.7763290137E+00, 1.6144865626E+00, 1.3449019918E-01, 1.1603840093E-01, 8.2845397207E-01],
	[4.2285000000E+04, 1.7766667265E+00, 1.6144753306E+00, 1.3453871187E-01, 1.1607589702E-01, 8.2847954484E-01],
	[4.2290000000E+04, 1.7770044635E+00, 1.6144641000E+00, 1.3458723632E-01, 1.1611339961E-01, 8.2850511551E-01],
	[4.2295000000E+04, 1.7773422248E+00, 1.6144528708E+00, 1.3463577254E-01, 1.1615090869E-01, 8.2853068410E-01],
	[4.2300000000E+04, 1.7776800103E+00, 1.6144416431E+00, 1.3468432051E-01, 1.1618842427E-01, 8.2855625060E-01],
	[4.2305000000E+04, 1.7780178201E+00, 1.6144304167E+00, 1.3473288025E-01, 1.1622594634E-01, 8.2858181501E-01],
	[4.2310000000E+04, 1.7783556542E+00, 1.6144191917E+00, 1.3478145176E-01, 1.1626347491E-01, 8.2860737732E-01],
	[4.2315000000E+04, 1.7786935125E+00, 1.6144079681E+00, 1.3483003503E-01, 1.1630100997E-01, 8.2863293754E-01],
	[4.2320000000E+04, 1.7790313951E+00, 1.6143967460E+00, 1.3487863008E-01, 1.1633855152E-01, 8.2865849567E-01],
	[4.2325000000E+04, 1.7793693019E+00, 1.6143855252E+00, 1.3492723689E-01, 1.1637609957E-01, 8.2868405170E-01],
	[4.2330000000E+04, 1.7797072330E+00, 1.6143743059E+00, 1.3497585547E-01, 1.1641365411E-01, 8.2870960565E-01],
	[4.2335000000E+04, 1.7800451883E+00, 1.6143630879E+00, 1.3502448583E-01, 1.1645121515E-01, 8.2873515749E-01],
	[4.2340000000E+04, 1.7803831679E+00, 1.6143518714E+00, 1.3507312796E-01, 1.1648878267E-01, 8.2876070724E-01],
	[4.2345000000E+04, 1.7807211717E+00, 1.6143406562E+00, 1.3512178187E-01, 1.1652635669E-01, 8.2878625490E-01],
	[4.2350000000E+04, 1.7810591998E+00, 1.6143294425E+00, 1.3517044756E-01, 1.1656393720E-01, 8.2881180046E-01],
	[4.2355000000E+04, 1.7813972521E+00, 1.6143182301E+00, 1.3521912502E-01, 1.1660152420E-01, 8.2883734392E-01],
	[4.2360000000E+04, 1.7817353287E+00, 1.6143070192E+00, 1.3526781427E-01, 1.1663911769E-01, 8.2886288528E-01],
	[4.2365000000E+04, 1.7820734296E+00, 1.6142958097E+00, 1.3531651530E-01, 1.1667671768E-01, 8.2888842455E-01],
	[4.2370000000E+04, 1.7824115546E+00, 1.6142846015E+00, 1.3536522811E-01, 1.1671432415E-01, 8.2891396172E-01],
	[4.2375000000E+04, 1.7827497039E+00, 1.6142733948E+00, 1.3541395271E-01, 1.1675193711E-01, 8.2893949679E-01],
	[4.2380000000E+04, 1.7830878775E+00, 1.6142621895E+00, 1.3546268909E-01, 1.1678955656E-01, 8.2896502976E-01],
	[4.2385000000E+04, 1.7834260753E+00, 1.6142509855E+00, 1.3551143726E-01, 1.1682718250E-01, 8.2899056064E-01],
	[4.2390000000E+04, 1.7837642974E+00, 1.6142397830E+00, 1.3556019722E-01, 1.1686481493E-01, 8.2901608941E-01],
	[4.2395000000E+04, 1.7841025436E+00, 1.6142285818E+00, 1.3560896897E-01, 1.1690245384E-01, 8.2904161608E-01],
	[4.2400000000E+04, 1.7844408142E+00, 1.6142173821E+00, 1.3565775252E-01, 1.1694009925E-01, 8.2906714065E-01],
	[4.2405000000E+04, 1.7847791089E+00, 1.6142061838E+00, 1.3570654785E-01, 1.1697775114E-01, 8.2909266312E-01],
	[4.2410000000E+04, 1.7851174279E+00, 1.6141949868E+00, 1.3575535498E-01, 1.1701540952E-01, 8.2911818348E-01],
	[4.2415000000E+04, 1.7854557712E+00, 1.6141837913E+00, 1.3580417391E-01, 1.1705307438E-01, 8.2914370175E-01],
	[4.2420000000E+04, 1.7857941386E+00, 1.6141725971E+00, 1.3585300464E-01, 1.1709074573E-01, 8.2916921791E-01],
	[4.2425000000E+04, 1.7861325303E+00, 1.6141614044E+00, 1.3590184717E-01, 1.1712842357E-01, 8.2919473196E-01],
	[4.2430000000E+04, 1.7864709463E+00, 1.6141502130E+00, 1.3595070149E-01, 1.1716610789E-01, 8.2922024392E-01],
	[4.2435000000E+04, 1.7868093864E+00, 1.6141390231E+00, 1.3599956762E-01, 1.1720379870E-01, 8.2924575376E-01],
	[4.2440000000E+04, 1.7871478508E+00, 1.6141278345E+00, 1.3604844556E-01, 1.1724149599E-01, 8.2927126151E-01],
	[4.2445000000E+04, 1.7874863394E+00, 1.6141166473E+00, 1.3609733529E-01, 1.1727919976E-01, 8.2929676714E-01],
	[4.2450000000E+04, 1.7878248523E+00, 1.6141054616E+00, 1.3614623684E-01, 1.1731691002E-01, 8.2932227067E-01],
	[4.2455000000E+04, 1.7881633894E+00, 1.6140942772E+00, 1.3619515019E-01, 1.1735462677E-01, 8.2934777210E-01],
	[4.2460000000E+04, 1.7885019507E+00, 1.6140830942E+00, 1.3624407536E-01, 1.1739234999E-01, 8.2937327141E-01],
	[4.2465000000E+04, 1.7888405362E+00, 1.6140719126E+00, 1.3629301233E-01, 1.1743007970E-01, 8.2939876862E-01],
	[4.2470000000E+04, 1.7891791459E+00, 1.6140607324E+00, 1.3634196112E-01, 1.1746781589E-01, 8.2942426373E-01],
	[4.2475000000E+04, 1.7895177799E+00, 1.6140495536E+00, 1.3639092172E-01, 1.1750555856E-01, 8.2944975672E-01],
	[4.2480000000E+04, 1.7898564381E+00, 1.6140383762E+00, 1.3643989414E-01, 1.1754330772E-01, 8.2947524760E-01],
	[4.2485000000E+04, 1.7901951205E+00, 1.6140272002E+00, 1.3648887838E-01, 1.1758106335E-01, 8.2950073637E-01],
	[4.2490000000E+04, 1.7905338271E+00, 1.6140160256E+00, 1.3653787443E-01, 1.1761882547E-01, 8.2952622304E-01],
	[4.2495000000E+04, 1.7908725580E+00, 1.6140048523E+00, 1.3658688230E-01, 1.1765659407E-01, 8.2955170759E-01],
	[4.2500000000E+04, 1.7912115657E+00, 1.6139939441E+00, 1.3663590200E-01, 1.1769437163E-01, 8.2957719003E-01],
	[4.2505000000E+04, 1.7915511153E+00, 1.6139835772E+00, 1.3668493351E-01, 1.1773216079E-01, 8.2960267036E-01],
	[4.2510000000E+04, 1.7918906893E+00, 1.6139732116E+00, 1.3673397686E-01, 1.1776995644E-01, 8.2962814858E-01],
	[4.2515000000E+04, 1.7922302877E+00, 1.6139628473E+00, 1.3678303202E-01, 1.1780775857E-01, 8.2965362468E-01],
	[4.2520000000E+04, 1.7925699105E+00, 1.6139524843E+00, 1.3683209902E-01, 1.1784556719E-01, 8.2967909868E-01],
	[4.2525000000E+04, 1.7929095578E+00, 1.6139421225E+00, 1.3688117784E-01, 1.1788338230E-01, 8.2970457055E-01],
	[4.2530000000E+04, 1.7932492294E+00, 1.6139317620E+00, 1.3693026850E-01, 1.1792120389E-01, 8.2973004032E-01],
	[4.2535000000E+04, 1.7935889255E+00, 1.6139214029E+00, 1.3697937098E-01, 1.1795903196E-01, 8.2975550797E-01],
	[4.2540000000E+04, 1.7939286459E+00, 1.6139110450E+00, 1.3702848530E-01, 1.1799686652E-01, 8.2978097350E-01],
	[4.2545000000E+04, 1.7942683908E+00, 1.6139006883E+00, 1.3707761145E-01, 1.1803470756E-01, 8.2980643692E-01],
	[4.2550000000E+04, 1.7946081601E+00, 1.6138903330E+00, 1.3712674944E-01, 1.1807255509E-01, 8.2983189823E-01],
	[4.2555000000E+04, 1.7949479538E+00, 1.6138799790E+00, 1.3717589927E-01, 1.1811040910E-01, 8.2985735741E-01],
	[4.2560000000E+04, 1.7952877718E+00, 1.6138696262E+00, 1.3722506093E-01, 1.1814826959E-01, 8.2988281448E-01],
	[4.2565000000E+04, 1.7956276143E+00, 1.6138592747E+00, 1.3727423444E-01, 1.1818613657E-01, 8.2990826943E-01],
	[4.2570000000E+04, 1.7959674812E+00, 1.6138489245E+00, 1.3732341979E-01, 1.1822401003E-01, 8.2993372227E-01],
	[4.2575000000E+04, 1.7963073725E+00, 1.6138385756E+00, 1.3737261698E-01, 1.1826188997E-01, 8.2995917298E-01],
	[4.2580000000E+04, 1.7966472882E+00, 1.6138282280E+00, 1.3742182602E-01, 1.1829977639E-01, 8.2998462158E-01],
	[4.2585000000E+04, 1.7969872283E+00, 1.6138178816E+00, 1.3747104690E-01, 1.1833766929E-01, 8.3001006805E-01],
	[4.2590000000E+04, 1.7973271928E+00, 1.6138075365E+00, 1.3752027963E-01, 1.1837556867E-01, 8.3003551241E-01],
	[4.2595000000E+04, 1.7976671817E+00, 1.6137971927E+00, 1.3756952421E-01, 1.1841347454E-01, 8.3006095465E-01],
	[4.2600000000E+04, 1.7980071949E+00, 1.6137868502E+00, 1.3761878064E-01, 1.1845138688E-01, 8.3008639476E-01],
	[4.2605000000E+04, 1.7983472326E+00, 1.6137765090E+00, 1.3766804892E-01, 1.1848930570E-01, 8.3011183276E-01],
	[4.2610000000E+04, 1.7986872947E+00, 1.6137661690E+00, 1.3771732906E-01, 1.1852723100E-01, 8.3013726863E-01],
	[4.2615000000E+04, 1.7990273811E+00, 1.6137558304E+00, 1.3776662105E-01, 1.1856516278E-01, 8.3016270238E-01],
	[4.2620000000E+04, 1.7993674920E+00, 1.6137454930E+00, 1.3781592489E-01, 1.1860310104E-01, 8.3018813400E-01],
	[4.2625000000E+04, 1.7997076272E+00, 1.6137351569E+00, 1.3786524060E-01, 1.1864104578E-01, 8.3021356351E-01],
	[4.2630000000E+04, 1.8000477869E+00, 1.6137248220E+00, 1.3791456816E-01, 1.1867899699E-01, 8.3023899089E-01],
	[4.2635000000E+04, 1.8003879709E+00, 1.6137144885E+00, 1.3796390759E-01, 1.1871695468E-01, 8.3026441614E-01],
	[4.2640000000E+04, 1.8007281793E+00, 1.6137041562E+00, 1.3801325888E-01, 1.1875491885E-01, 8.3028983927E-01],
	[4.2645000000E+04, 1.8010684121E+00, 1.6136938252E+00, 1.3806262203E-01, 1.1879288949E-01, 8.3031526027E-01],
	[4.2650000000E+04, 1.8014086692E+00, 1.6136834955E+00, 1.3811199704E-01, 1.1883086661E-01, 8.3034067915E-01],
	[4.2655000000E+04, 1.8017489508E+00, 1.6136731670E+00, 1.3816138393E-01, 1.1886885021E-01, 8.3036609591E-01],
	[4.2660000000E+04, 1.8020892567E+00, 1.6136628398E+00, 1.3821078268E-01, 1.1890684028E-01, 8.3039151053E-01],
	[4.2665000000E+04, 1.8024295870E+00, 1.6136525139E+00, 1.3826019330E-01, 1.1894483682E-01, 8.3041692303E-01],
	[4.2670000000E+04, 1.8027699417E+00, 1.6136421893E+00, 1.3830961579E-01, 1.1898283984E-01, 8.3044233340E-01],
	[4.2675000000E+04, 1.8031103208E+00, 1.6136318660E+00, 1.3835905016E-01, 1.1902084934E-01, 8.3046774164E-01],
	[4.2680000000E+04, 1.8034507242E+00, 1.6136215439E+00, 1.3840849640E-01, 1.1905886530E-01, 8.3049314776E-01],
	[4.2685000000E+04, 1.8037911521E+00, 1.6136112231E+00, 1.3845795451E-01, 1.1909688774E-01, 8.3051855174E-01],
	[4.2690000000E+04, 1.8041316043E+00, 1.6136009036E+00, 1.3850742450E-01, 1.1913491665E-01, 8.3054395359E-01],
	[4.2695000000E+04, 1.8044720808E+00, 1.6135905854E+00, 1.3855690637E-01, 1.1917295204E-01, 8.3056935332E-01],
	[4.2700000000E+04, 1.8048125818E+00, 1.6135802684E+00, 1.3860640012E-01, 1.1921099390E-01, 8.3059475091E-01],
	[4.2705000000E+04, 1.8051531071E+00, 1.6135699527E+00, 1.3865590575E-01, 1.1924904222E-01, 8.3062014637E-01],
	[4.2710000000E+04, 1.8054936568E+00, 1.6135596383E+00, 1.3870542327E-01, 1.1928709702E-01, 8.3064553971E-01],
	[4.2715000000E+04, 1.8058342308E+00, 1.6135493251E+00, 1.3875495266E-01, 1.1932515829E-01, 8.3067093090E-01],
	[4.2720000000E+04, 1.8061748293E+00, 1.6135390133E+00, 1.3880449395E-01, 1.1936322603E-01, 8.3069631997E-01],
	[4.2725000000E+04, 1.8065154521E+00, 1.6135287027E+00, 1.3885404712E-01, 1.1940130024E-01, 8.3072170690E-01],
	[4.2730000000E+04, 1.8068560992E+00, 1.6135183933E+00, 1.3890361218E-01, 1.1943938092E-01, 8.3074709170E-01],
	[4.2735000000E+04, 1.8071967707E+00, 1.6135080853E+00, 1.3895318913E-01, 1.1947746807E-01, 8.3077247436E-01],
	[4.2740000000E+04, 1.8075374666E+00, 1.6134977785E+00, 1.3900277797E-01, 1.1951556169E-01, 8.3079785489E-01],
	[4.2745000000E+04, 1.8078781869E+00, 1.6134874730E+00, 1.3905237870E-01, 1.1955366178E-01, 8.3082323328E-01],
	[4.2750000000E+04, 1.8082189315E+00, 1.6134771687E+00, 1.3910199133E-01, 1.1959176833E-01, 8.3084860954E-01],
	[4.2755000000E+04, 1.8085597005E+00, 1.6134668658E+00, 1.3915161586E-01, 1.1962988135E-01, 8.3087398366E-01],
	[4.2760000000E+04, 1.8089004938E+00, 1.6134565641E+00, 1.3920125228E-01, 1.1966800084E-01, 8.3089935564E-01],
	[4.2765000000E+04, 1.8092413115E+00, 1.6134462636E+00, 1.3925090060E-01, 1.1970612679E-01, 8.3092472548E-01],
	[4.2770000000E+04, 1.8095821535E+00, 1.6134359645E+00, 1.3930056082E-01, 1.1974425922E-01, 8.3095009319E-01],
	[4.2775000000E+04, 1.8099230200E+00, 1.6134256666E+00, 1.3935023294E-01, 1.1978239810E-01, 8.3097545876E-01],
	[4.2780000000E+04, 1.8102639107E+00, 1.6134153699E+00, 1.3939991697E-01, 1.1982054346E-01, 8.3100082219E-01],
	[4.2785000000E+04, 1.8106048258E+00, 1.6134050746E+00, 1.3944961290E-01, 1.1985869527E-01, 8.3102618347E-01],
	[4.2790000000E+04, 1.8109457653E+00, 1.6133947805E+00, 1.3949932074E-01, 1.1989685356E-01, 8.3105154262E-01],
	[4.2795000000E+04, 1.8112867291E+00, 1.6133844877E+00, 1.3954904048E-01, 1.1993501830E-01, 8.3107689963E-01],
	[4.2800000000E+04, 1.8116277173E+00, 1.6133741961E+00, 1.3959877213E-01, 1.1997318952E-01, 8.3110225450E-01],
	[4.2805000000E+04, 1.8119687298E+00, 1.6133639059E+00, 1.3964851570E-01, 1.2001136719E-01, 8.3112760722E-01],
	[4.2810000000E+04, 1.8123097667E+00, 1.6133536169E+00, 1.3969827117E-01, 1.2004955133E-01, 8.3115295780E-01],
	[4.2815000000E+04, 1.8126508279E+00, 1.6133433291E+00, 1.3974803856E-01, 1.2008774193E-01, 8.3117830624E-01],
	[4.2820000000E+04, 1.8129919135E+00, 1.6133330426E+00, 1.3979781787E-01, 1.2012593899E-01, 8.3120365253E-01],
	[4.2825000000E+04, 1.8133330234E+00, 1.6133227574E+00, 1.3984760909E-01, 1.2016414251E-01, 8.3122899669E-01],
	[4.2830000000E+04, 1.8136741576E+00, 1.6133124735E+00, 1.3989741223E-01, 1.2020235250E-01, 8.3125433869E-01],
	[4.2835000000E+04, 1.8140153162E+00, 1.6133021908E+00, 1.3994722728E-01, 1.2024056895E-01, 8.3127967855E-01],
	[4.2840000000E+04, 1.8143564991E+00, 1.6132919094E+00, 1.3999705426E-01, 1.2027879185E-01, 8.3130501627E-01],
	[4.2845000000E+04, 1.8146977064E+00, 1.6132816292E+00, 1.4004689316E-01, 1.2031702122E-01, 8.3133035184E-01],
	[4.2850000000E+04, 1.8150389380E+00, 1.6132713504E+00, 1.4009674399E-01, 1.2035525705E-01, 8.3135568526E-01],
	[4.2855000000E+04, 1.8153801940E+00, 1.6132610727E+00, 1.4014660674E-01, 1.2039349933E-01, 8.3138101654E-01],
	[4.2860000000E+04, 1.8157214743E+00, 1.6132507964E+00, 1.4019648141E-01, 1.2043174808E-01, 8.3140634566E-01],
	[4.2865000000E+04, 1.8160627789E+00, 1.6132405213E+00, 1.4024636802E-01, 1.2047000328E-01, 8.3143167264E-01],
	[4.2870000000E+04, 1.8164041079E+00, 1.6132302475E+00, 1.4029626655E-01, 1.2050826495E-01, 8.3145699747E-01],
	[4.2875000000E+04, 1.8167454612E+00, 1.6132199749E+00, 1.4034617702E-01, 1.2054653307E-01, 8.3148232016E-01],
	[4.2880000000E+04, 1.8170868388E+00, 1.6132097036E+00, 1.4039609941E-01, 1.2058480764E-01, 8.3150764069E-01],
	[4.2885000000E+04, 1.8174282408E+00, 1.6131994336E+00, 1.4044603375E-01, 1.2062308868E-01, 8.3153295907E-01],
	[4.2890000000E+04, 1.8177696671E+00, 1.6131891648E+00, 1.4049598001E-01, 1.2066137617E-01, 8.3155827530E-01],
	[4.2895000000E+04, 1.8181111177E+00, 1.6131788973E+00, 1.4054593822E-01, 1.2069967011E-01, 8.3158358938E-01],
	[4.2900000000E+04, 1.8184525926E+00, 1.6131686310E+00, 1.4059590836E-01, 1.2073797052E-01, 8.3160890131E-01],
	[4.2905000000E+04, 1.8187940919E+00, 1.6131583661E+00, 1.4064589044E-01, 1.2077627737E-01, 8.3163421108E-01],
	[4.2910000000E+04, 1.8191356155E+00, 1.6131481023E+00, 1.4069588446E-01, 1.2081459069E-01, 8.3165951870E-01],
	[4.2915000000E+04, 1.8194771634E+00, 1.6131378399E+00, 1.4074589043E-01, 1.2085291045E-01, 8.3168482417E-01],
	[4.2920000000E+04, 1.8198187357E+00, 1.6131275787E+00, 1.4079590834E-01, 1.2089123668E-01, 8.3171012749E-01],
	[4.2925000000E+04, 1.8201603323E+00, 1.6131173187E+00, 1.4084593819E-01, 1.2092956935E-01, 8.3173542865E-01],
	[4.2930000000E+04, 1.8205019532E+00, 1.6131070600E+00, 1.4089597999E-01, 1.2096790848E-01, 8.3176072765E-01],
	[4.2935000000E+04, 1.8208435984E+00, 1.6130968026E+00, 1.4094603374E-01, 1.2100625406E-01, 8.3178602450E-01],
	[4.2940000000E+04, 1.8211852679E+00, 1.6130865465E+00, 1.4099609944E-01, 1.2104460609E-01, 8.3181131920E-01],
	[4.2945000000E+04, 1.8215269618E+00, 1.6130762915E+00, 1.4104617710E-01, 1.2108296458E-01, 8.3183661174E-01],
	[4.2950000000E+04, 1.8218686800E+00, 1.6130660379E+00, 1.4109626670E-01, 1.2112132951E-01, 8.3186190212E-01],
	[4.2955000000E+04, 1.8222104225E+00, 1.6130557855E+00, 1.4114636826E-01, 1.2115970090E-01, 8.3188719034E-01],
	[4.2960000000E+04, 1.8225521893E+00, 1.6130455344E+00, 1.4119648178E-01, 1.2119807874E-01, 8.3191247640E-01],
	[4.2965000000E+04, 1.8228939804E+00, 1.6130352845E+00, 1.4124660725E-01, 1.2123646303E-01, 8.3193776031E-01],
	[4.2970000000E+04, 1.8232357958E+00, 1.6130250359E+00, 1.4129674468E-01, 1.2127485377E-01, 8.3196304206E-01],
	[4.2975000000E+04, 1.8235776356E+00, 1.6130147886E+00, 1.4134689407E-01, 1.2131325096E-01, 8.3198832164E-01],
	[4.2980000000E+04, 1.8239194996E+00, 1.6130045425E+00, 1.4139705542E-01, 1.2135165459E-01, 8.3201359907E-01],
	[4.2985000000E+04, 1.8242613880E+00, 1.6129942976E+00, 1.4144722874E-01, 1.2139006468E-01, 8.3203887434E-01],
	[4.2990000000E+04, 1.8246033007E+00, 1.6129840540E+00, 1.4149741402E-01, 1.2142848121E-01, 8.3206414744E-01],
	[4.2995000000E+04, 1.8249452377E+00, 1.6129738117E+00, 1.4154761127E-01, 1.2146690420E-01, 8.3208941839E-01],
	[4.3000000000E+04, 1.8252871990E+00, 1.6129635706E+00, 1.4159782048E-01, 1.2150533362E-01, 8.3211468717E-01],
	[4.3005000000E+04, 1.8256291846E+00, 1.6129533308E+00, 1.4164804166E-01, 1.2154376950E-01, 8.3213995379E-01],
	[4.3010000000E+04, 1.8259711945E+00, 1.6129430923E+00, 1.4169827482E-01, 1.2158221182E-01, 8.3216521824E-01],
	[4.3015000000E+04, 1.8263132287E+00, 1.6129328550E+00, 1.4174851994E-01, 1.2162066059E-01, 8.3219048054E-01],
	[4.3020000000E+04, 1.8266552872E+00, 1.6129226189E+00, 1.4179877704E-01, 1.2165911581E-01, 8.3221574066E-01],
	[4.3025000000E+04, 1.8269973700E+00, 1.6129123841E+00, 1.4184904611E-01, 1.2169757747E-01, 8.3224099863E-01],
	[4.3030000000E+04, 1.8273394771E+00, 1.6129021506E+00, 1.4189932716E-01, 1.2173604557E-01, 8.3226625443E-01],
	[4.3035000000E+04, 1.8276816085E+00, 1.6128919183E+00, 1.4194962019E-01, 1.2177452012E-01, 8.3229150806E-01],
	[4.3040000000E+04, 1.8280237642E+00, 1.6128816873E+00, 1.4199992520E-01, 1.2181300111E-01, 8.3231675952E-01],
	[4.3045000000E+04, 1.8283659442E+00, 1.6128714575E+00, 1.4205024219E-01, 1.2185148855E-01, 8.3234200882E-01],
	[4.3050000000E+04, 1.8287081485E+00, 1.6128612290E+00, 1.4210057116E-01, 1.2188998243E-01, 8.3236725596E-01],
	[4.3055000000E+04, 1.8290503771E+00, 1.6128510017E+00, 1.4215091211E-01, 1.2192848275E-01, 8.3239250092E-01],
	[4.3060000000E+04, 1.8293926300E+00, 1.6128407757E+00, 1.4220126505E-01, 1.2196698952E-01, 8.3241774372E-01],
	[4.3065000000E+04, 1.8297349072E+00, 1.6128305509E+00, 1.4225162997E-01, 1.2200550272E-01, 8.3244298434E-01],
	[4.3070000000E+04, 1.8300772086E+00, 1.6128203274E+00, 1.4230200689E-01, 1.2204402237E-01, 8.3246822280E-01],
	[4.3075000000E+04, 1.8304195344E+00, 1.6128101051E+00, 1.4235239579E-01, 1.2208254846E-01, 8.3249345909E-01],
	[4.3080000000E+04, 1.8307618844E+00, 1.6127998841E+00, 1.4240279668E-01, 1.2212108099E-01, 8.3251869321E-01],
	[4.3085000000E+04, 1.8311042588E+00, 1.6127896643E+00, 1.4245320957E-01, 1.2215961996E-01, 8.3254392515E-01],
	[4.3090000000E+04, 1.8314466574E+00, 1.6127794458E+00, 1.4250363444E-01, 1.2219816537E-01, 8.3256915493E-01],
	[4.3095000000E+04, 1.8317890803E+00, 1.6127692286E+00, 1.4255407132E-01, 1.2223671722E-01, 8.3259438253E-01],
	[4.3100000000E+04, 1.8321315275E+00, 1.6127590126E+00, 1.4260452019E-01, 1.2227527551E-01, 8.3261960797E-01],
	[4.3105000000E+04, 1.8324739990E+00, 1.6127487978E+00, 1.4265498106E-01, 1.2231384024E-01, 8.3264483122E-01],
	[4.3110000000E+04, 1.8328164947E+00, 1.6127385843E+00, 1.4270545393E-01, 1.2235241140E-01, 8.3267005231E-01],
	[4.3115000000E+04, 1.8331590148E+00, 1.6127283720E+00, 1.4275593880E-01, 1.2239098900E-01, 8.3269527122E-01],
	[4.3120000000E+04, 1.8335015591E+00, 1.6127181610E+00, 1.4280643567E-01, 1.2242957304E-01, 8.3272048796E-01],
	[4.3125000000E+04, 1.8338441277E+00, 1.6127079512E+00, 1.4285694455E-01, 1.2246816352E-01, 8.3274570252E-01],
	[4.3130000000E+04, 1.8341867206E+00, 1.6126977427E+00, 1.4290746543E-01, 1.2250676043E-01, 8.3277091491E-01],
	[4.3135000000E+04, 1.8345293377E+00, 1.6126875355E+00, 1.4295799832E-01, 1.2254536378E-01, 8.3279612512E-01],
	[4.3140000000E+04, 1.8348719792E+00, 1.6126773294E+00, 1.4300854322E-01, 1.2258397357E-01, 8.3282133316E-01],
	[4.3145000000E+04, 1.8352146449E+00, 1.6126671247E+00, 1.4305910012E-01, 1.2262258978E-01, 8.3284653901E-01],
	[4.3150000000E+04, 1.8355573348E+00, 1.6126569211E+00, 1.4310966904E-01, 1.2266121244E-01, 8.3287174270E-01],
	[4.3155000000E+04, 1.8359000491E+00, 1.6126467189E+00, 1.4316024998E-01, 1.2269984153E-01, 8.3289694420E-01],
	[4.3160000000E+04, 1.8362427876E+00, 1.6126365178E+00, 1.4321084292E-01, 1.2273847705E-01, 8.3292214352E-01],
	[4.3165000000E+04, 1.8365855504E+00, 1.6126263180E+00, 1.4326144788E-01, 1.2277711900E-01, 8.3294734067E-01],
	[4.3170000000E+04, 1.8369283375E+00, 1.6126161195E+00, 1.4331206486E-01, 1.2281576739E-01, 8.3297253564E-01],
	[4.3175000000E+04, 1.8372711488E+00, 1.6126059222E+00, 1.4336269386E-01, 1.2285442221E-01, 8.3299772842E-01],
	[4.3180000000E+04, 1.8376139844E+00, 1.6125957261E+00, 1.4341333488E-01, 1.2289308347E-01, 8.3302291903E-01],
	[4.3185000000E+04, 1.8379572309E+00, 1.6125859229E+00, 1.4346398792E-01, 1.2293175515E-01, 8.3304810746E-01],
	[4.3190000000E+04, 1.8383008963E+00, 1.6125765206E+00, 1.4351465298E-01, 1.2297043737E-01, 8.3307329370E-01],
	[4.3195000000E+04, 1.8386445863E+00, 1.6125671194E+00, 1.4356533006E-01, 1.2300912602E-01, 8.3309847776E-01],
	[4.3200000000E+04, 1.8389883007E+00, 1.6125577194E+00, 1.4361601918E-01, 1.2304782112E-01, 8.3312365964E-01],
	[4.3205000000E+04, 1.8393320395E+00, 1.6125483205E+00, 1.4366672032E-01, 1.2308652265E-01, 8.3314883934E-01],
	[4.3210000000E+04, 1.8396758029E+00, 1.6125389227E+00, 1.4371743349E-01, 1.2312523061E-01, 8.3317401686E-01],
	[4.3215000000E+04, 1.8400195906E+00, 1.6125295261E+00, 1.4376815869E-01, 1.2316394502E-01, 8.3319919219E-01],
	[4.3220000000E+04, 1.8403634029E+00, 1.6125201306E+00, 1.4381889592E-01, 1.2320266586E-01, 8.3322436533E-01],
	[4.3225000000E+04, 1.8407072396E+00, 1.6125107363E+00, 1.4386964518E-01, 1.2324139314E-01, 8.3324953630E-01],
	[4.3230000000E+04, 1.8410511007E+00, 1.6125013431E+00, 1.4392040648E-01, 1.2328012685E-01, 8.3327470507E-01],
	[4.3235000000E+04, 1.8413949864E+00, 1.6124919510E+00, 1.4397117982E-01, 1.2331886700E-01, 8.3329987166E-01],
	[4.3240000000E+04, 1.8417388964E+00, 1.6124825601E+00, 1.4402196519E-01, 1.2335761358E-01, 8.3332503607E-01],
	[4.3245000000E+04, 1.8420828310E+00, 1.6124731703E+00, 1.4407276260E-01, 1.2339636660E-01, 8.3335019828E-01],
	[4.3250000000E+04, 1.8424267899E+00, 1.6124637817E+00, 1.4412357205E-01, 1.2343512605E-01, 8.3337535831E-01],
	[4.3255000000E+04, 1.8427707734E+00, 1.6124543942E+00, 1.4417439355E-01, 1.2347389194E-01, 8.3340051616E-01],
	[4.3260000000E+04, 1.8431147813E+00, 1.6124450078E+00, 1.4422522709E-01, 1.2351266425E-01, 8.3342567181E-01],
	[4.3265000000E+04, 1.8434588136E+00, 1.6124356226E+00, 1.4427607267E-01, 1.2355144301E-01, 8.3345082528E-01],
	[4.3270000000E+04, 1.8438028704E+00, 1.6124262385E+00, 1.4432693030E-01, 1.2359022819E-01, 8.3347597655E-01],
	[4.3275000000E+04, 1.8441469516E+00, 1.6124168556E+00, 1.4437779998E-01, 1.2362901980E-01, 8.3350112564E-01],
	[4.3280000000E+04, 1.8444910573E+00, 1.6124074738E+00, 1.4442868170E-01, 1.2366781785E-01, 8.3352627254E-01],
	[4.3285000000E+04, 1.8448351874E+00, 1.6123980931E+00, 1.4447957548E-01, 1.2370662233E-01, 8.3355141724E-01],
	[4.3290000000E+04, 1.8451793420E+00, 1.6123887136E+00, 1.4453048131E-01, 1.2374543324E-01, 8.3357655976E-01],
	[4.3295000000E+04, 1.8455235210E+00, 1.6123793352E+00, 1.4458139919E-01, 1.2378425058E-01, 8.3360170008E-01],
	[4.3300000000E+04, 1.8458677244E+00, 1.6123699580E+00, 1.4463232913E-01, 1.2382307435E-01, 8.3362683821E-01],
	[4.3305000000E+04, 1.8462119523E+00, 1.6123605819E+00, 1.4468327113E-01, 1.2386190454E-01, 8.3365197415E-01],
	[4.3310000000E+04, 1.8465562046E+00, 1.6123512069E+00, 1.4473422518E-01, 1.2390074117E-01, 8.3367710790E-01],
	[4.3315000000E+04, 1.8469004814E+00, 1.6123418331E+00, 1.4478519129E-01, 1.2393958422E-01, 8.3370223945E-01],
	[4.3320000000E+04, 1.8472447826E+00, 1.6123324604E+00, 1.4483616947E-01, 1.2397843371E-01, 8.3372736881E-01],
	[4.3325000000E+04, 1.8475891083E+00, 1.6123230888E+00, 1.4488715970E-01, 1.2401728962E-01, 8.3375249597E-01],
	[4.3330000000E+04, 1.8479334584E+00, 1.6123137184E+00, 1.4493816201E-01, 1.2405615196E-01, 8.3377762094E-01],
	[4.3335000000E+04, 1.8482778329E+00, 1.6123043491E+00, 1.4498917637E-01, 1.2409502072E-01, 8.3380274371E-01],
	[4.3340000000E+04, 1.8486222318E+00, 1.6122949809E+00, 1.4504020280E-01, 1.2413389591E-01, 8.3382786429E-01],
	[4.3345000000E+04, 1.8489666552E+00, 1.6122856139E+00, 1.4509124131E-01, 1.2417277753E-01, 8.3385298267E-01],
	[4.3350000000E+04, 1.8493111030E+00, 1.6122762480E+00, 1.4514229188E-01, 1.2421166557E-01, 8.3387809885E-01],
	[4.3355000000E+04, 1.8496555753E+00, 1.6122668833E+00, 1.4519335452E-01, 1.2425056003E-01, 8.3390321284E-01],
	[4.3360000000E+04, 1.8500000719E+00, 1.6122575196E+00, 1.4524442923E-01, 1.2428946092E-01, 8.3392832462E-01],
	[4.3365000000E+04, 1.8503445931E+00, 1.6122481572E+00, 1.4529551602E-01, 1.2432836824E-01, 8.3395343421E-01],
	[4.3370000000E+04, 1.8506891386E+00, 1.6122387958E+00, 1.4534661489E-01, 1.2436728198E-01, 8.3397854160E-01],
	[4.3375000000E+04, 1.8510337085E+00, 1.6122294356E+00, 1.4539772583E-01, 1.2440620214E-01, 8.3400364680E-01],
	[4.3380000000E+04, 1.8513783029E+00, 1.6122200765E+00, 1.4544884885E-01, 1.2444512872E-01, 8.3402874979E-01],
	[4.3385000000E+04, 1.8517229217E+00, 1.6122107186E+00, 1.4549998395E-01, 1.2448406173E-01, 8.3405385058E-01],
	[4.3390000000E+04, 1.8520675650E+00, 1.6122013617E+00, 1.4555113113E-01, 1.2452300116E-01, 8.3407894917E-01],
	[4.3395000000E+04, 1.8524122326E+00, 1.6121920061E+00, 1.4560229040E-01, 1.2456194701E-01, 8.3410404556E-01],
	[4.3400000000E+04, 1.8527569247E+00, 1.6121826515E+00, 1.4565346175E-01, 1.2460089928E-01, 8.3412913974E-01],
	[4.3405000000E+04, 1.8531016412E+00, 1.6121732981E+00, 1.4570464518E-01, 1.2463985797E-01, 8.3415423173E-01],
	[4.3410000000E+04, 1.8534463821E+00, 1.6121639458E+00, 1.4575584071E-01, 1.2467882308E-01, 8.3417932151E-01],
	[4.3415000000E+04, 1.8537911474E+00, 1.6121545946E+00, 1.4580704832E-01, 1.2471779461E-01, 8.3420440909E-01],
	[4.3420000000E+04, 1.8541359371E+00, 1.6121452446E+00, 1.4585826802E-01, 1.2475677256E-01, 8.3422949446E-01],
	[4.3425000000E+04, 1.8544807513E+00, 1.6121358957E+00, 1.4590949981E-01, 1.2479575693E-01, 8.3425457763E-01],
	[4.3430000000E+04, 1.8548255899E+00, 1.6121265480E+00, 1.4596074370E-01, 1.2483474772E-01, 8.3427965860E-01],
	[4.3435000000E+04, 1.8551704528E+00, 1.6121172013E+00, 1.4601199968E-01, 1.2487374492E-01, 8.3430473736E-01],
	[4.3440000000E+04, 1.8555153402E+00, 1.6121078558E+00, 1.4606326776E-01, 1.2491274855E-01, 8.3432981391E-01],
	[4.3445000000E+04, 1.8558602521E+00, 1.6120985114E+00, 1.4611454793E-01, 1.2495175859E-01, 8.3435488826E-01],
	[4.3450000000E+04, 1.8562051883E+00, 1.6120891682E+00, 1.4616584021E-01, 1.2499077504E-01, 8.3437996041E-01],
	[4.3455000000E+04, 1.8565501489E+00, 1.6120798261E+00, 1.4621714458E-01, 1.2502979791E-01, 8.3440503034E-01],
	[4.3460000000E+04, 1.8568951339E+00, 1.6120704851E+00, 1.4626846106E-01, 1.2506882720E-01, 8.3443009807E-01],
	[4.3465000000E+04, 1.8572401434E+00, 1.6120611452E+00, 1.4631978964E-01, 1.2510786290E-01, 8.3445516359E-01],
	[4.3470000000E+04, 1.8575851772E+00, 1.6120518065E+00, 1.4637113032E-01, 1.2514690502E-01, 8.3448022690E-01],
	[4.3475000000E+04, 1.8579302355E+00, 1.6120424689E+00, 1.4642248311E-01, 1.2518595355E-01, 8.3450528800E-01],
	[4.3480000000E+04, 1.8582753181E+00, 1.6120331324E+00, 1.4647384801E-01, 1.2522500850E-01, 8.3453034690E-01],
	[4.3485000000E+04, 1.8586204252E+00, 1.6120237971E+00, 1.4652522502E-01, 1.2526406986E-01, 8.3455540358E-01],
	[4.3490000000E+04, 1.8589655566E+00, 1.6120144629E+00, 1.4657661414E-01, 1.2530313763E-01, 8.3458045805E-01],
	[4.3495000000E+04, 1.8593107125E+00, 1.6120051298E+00, 1.4662801537E-01, 1.2534221181E-01, 8.3460551031E-01],
	[4.3500000000E+04, 1.8596558927E+00, 1.6119957978E+00, 1.4667942872E-01, 1.2538129241E-01, 8.3463056036E-01],
	[4.3505000000E+04, 1.8600010974E+00, 1.6119864670E+00, 1.4673085418E-01, 1.2542037942E-01, 8.3465560820E-01],
	[4.3510000000E+04, 1.8603463264E+00, 1.6119771373E+00, 1.4678229175E-01, 1.2545947284E-01, 8.3468065383E-01],
	[4.3515000000E+04, 1.8606915799E+00, 1.6119678087E+00, 1.4683374145E-01, 1.2549857267E-01, 8.3470569724E-01],
	[4.3520000000E+04, 1.8610368577E+00, 1.6119584812E+00, 1.4688520326E-01, 1.2553767891E-01, 8.3473073844E-01],
	[4.3525000000E+04, 1.8613821600E+00, 1.6119491549E+00, 1.4693667720E-01, 1.2557679156E-01, 8.3475577743E-01],
	[4.3530000000E+04, 1.8617274866E+00, 1.6119398297E+00, 1.4698816325E-01, 1.2561591062E-01, 8.3478081420E-01],
	[4.3535000000E+04, 1.8620728376E+00, 1.6119305056E+00, 1.4703966143E-01, 1.2565503609E-01, 8.3480584876E-01],
	[4.3540000000E+04, 1.8624182130E+00, 1.6119211826E+00, 1.4709117174E-01, 1.2569416796E-01, 8.3483088110E-01],
	[4.3545000000E+04, 1.8627636128E+00, 1.6119118608E+00, 1.4714269418E-01, 1.2573330625E-01, 8.3485591123E-01],
	[4.3550000000E+04, 1.8631090370E+00, 1.6119025401E+00, 1.4719422874E-01, 1.2577245094E-01, 8.3488093914E-01],
	[4.3555000000E+04, 1.8634544856E+00, 1.6118932205E+00, 1.4724577543E-01, 1.2581160204E-01, 8.3490596484E-01],
	[4.3560000000E+04, 1.8637999585E+00, 1.6118839020E+00, 1.4729733425E-01, 1.2585075954E-01, 8.3493098832E-01],
	[4.3565000000E+04, 1.8641454559E+00, 1.6118745847E+00, 1.4734890521E-01, 1.2588992346E-01, 8.3495600958E-01],
	[4.3570000000E+04, 1.8644909776E+00, 1.6118652685E+00, 1.4740048830E-01, 1.2592909377E-01, 8.3498102862E-01],
	[4.3575000000E+04, 1.8648365237E+00, 1.6118559534E+00, 1.4745208352E-01, 1.2596827050E-01, 8.3500604544E-01],
	[4.3580000000E+04, 1.8651820942E+00, 1.6118466394E+00, 1.4750369088E-01, 1.2600745363E-01, 8.3503106005E-01],
	[4.3585000000E+04, 1.8655276891E+00, 1.6118373266E+00, 1.4755531038E-01, 1.2604664316E-01, 8.3505607243E-01],
	[4.3590000000E+04, 1.8658733083E+00, 1.6118280148E+00, 1.4760694203E-01, 1.2608583909E-01, 8.3508108260E-01],
	[4.3595000000E+04, 1.8662189520E+00, 1.6118187042E+00, 1.4765858581E-01, 1.2612504143E-01, 8.3510609055E-01],
	[4.3600000000E+04, 1.8665646200E+00, 1.6118093947E+00, 1.4771024173E-01, 1.2616425018E-01, 8.3513109627E-01],
	[4.3605000000E+04, 1.8669103124E+00, 1.6118000864E+00, 1.4776190980E-01, 1.2620346532E-01, 8.3515609978E-01],
	[4.3610000000E+04, 1.8672560291E+00, 1.6117907791E+00, 1.4781359002E-01, 1.2624268687E-01, 8.3518110106E-01],
	[4.3615000000E+04, 1.8676017703E+00, 1.6117814730E+00, 1.4786528238E-01, 1.2628191482E-01, 8.3520610012E-01],
	[4.3620000000E+04, 1.8679475358E+00, 1.6117721680E+00, 1.4791698689E-01, 1.2632114917E-01, 8.3523109696E-01],
	[4.3625000000E+04, 1.8682933256E+00, 1.6117628641E+00, 1.4796870355E-01, 1.2636038992E-01, 8.3525609157E-01],
	[4.3630000000E+04, 1.8686391399E+00, 1.6117535614E+00, 1.4802043237E-01, 1.2639963707E-01, 8.3528108396E-01],
	[4.3635000000E+04, 1.8689849785E+00, 1.6117442597E+00, 1.4807217333E-01, 1.2643889062E-01, 8.3530607413E-01],
	[4.3640000000E+04, 1.8693308415E+00, 1.6117349592E+00, 1.4812392645E-01, 1.2647815057E-01, 8.3533106207E-01],
	[4.3645000000E+04, 1.8696767289E+00, 1.6117256598E+00, 1.4817569173E-01, 1.2651741692E-01, 8.3535604779E-01],
	[4.3650000000E+04, 1.8700226406E+00, 1.6117163615E+00, 1.4822746916E-01, 1.2655668967E-01, 8.3538103128E-01],
	[4.3655000000E+04, 1.8703685767E+00, 1.6117070644E+00, 1.4827925876E-01, 1.2659596881E-01, 8.3540601255E-01],
	[4.3660000000E+04, 1.8707145371E+00, 1.6116977683E+00, 1.4833106051E-01, 1.2663525436E-01, 8.3543099159E-01],
	[4.3665000000E+04, 1.8710605219E+00, 1.6116884734E+00, 1.4838287443E-01, 1.2667454630E-01, 8.3545596841E-01],
	[4.3670000000E+04, 1.8714065311E+00, 1.6116791796E+00, 1.4843470051E-01, 1.2671384463E-01, 8.3548094299E-01],
	[4.3675000000E+04, 1.8717525647E+00, 1.6116698869E+00, 1.4848653875E-01, 1.2675314937E-01, 8.3550591535E-01],
	[4.3680000000E+04, 1.8720986226E+00, 1.6116605953E+00, 1.4853838916E-01, 1.2679246050E-01, 8.3553088548E-01],
	[4.3685000000E+04, 1.8724447048E+00, 1.6116513049E+00, 1.4859025174E-01, 1.2683177802E-01, 8.3555585339E-01],
	[4.3690000000E+04, 1.8727908114E+00, 1.6116420155E+00, 1.4864212649E-01, 1.2687110194E-01, 8.3558081906E-01],
	[4.3695000000E+04, 1.8731369424E+00, 1.6116327273E+00, 1.4869401340E-01, 1.2691043225E-01, 8.3560578250E-01],
	[4.3700000000E+04, 1.8734830977E+00, 1.6116234402E+00, 1.4874591249E-01, 1.2694976896E-01, 8.3563074372E-01],
	[4.3705000000E+04, 1.8738292774E+00, 1.6116141542E+00, 1.4879782376E-01, 1.2698911206E-01, 8.3565570270E-01],
	[4.3710000000E+04, 1.8741754815E+00, 1.6116048693E+00, 1.4884974720E-01, 1.2702846155E-01, 8.3568065945E-01],
	[4.3715000000E+04, 1.8745217099E+00, 1.6115955856E+00, 1.4890168281E-01, 1.2706781744E-01, 8.3570561398E-01],
	[4.3720000000E+04, 1.8748679626E+00, 1.6115863029E+00, 1.4895363060E-01, 1.2710717972E-01, 8.3573056627E-01],
	[4.3725000000E+04, 1.8752142397E+00, 1.6115770214E+00, 1.4900559058E-01, 1.2714654839E-01, 8.3575551632E-01],
	[4.3730000000E+04, 1.8755605412E+00, 1.6115677410E+00, 1.4905756273E-01, 1.2718592345E-01, 8.3578046415E-01],
	[4.3735000000E+04, 1.8759068669E+00, 1.6115584617E+00, 1.4910954707E-01, 1.2722530490E-01, 8.3580540974E-01],
	[4.3740000000E+04, 1.8762532171E+00, 1.6115491835E+00, 1.4916154359E-01, 1.2726469274E-01, 8.3583035310E-01],
	[4.3745000000E+04, 1.8765995916E+00, 1.6115399064E+00, 1.4921355229E-01, 1.2730408697E-01, 8.3585529422E-01],
	[4.3750000000E+04, 1.8769459904E+00, 1.6115306305E+00, 1.4926557318E-01, 1.2734348759E-01, 8.3588023311E-01],
	[4.3755000000E+04, 1.8772924136E+00, 1.6115213556E+00, 1.4931760626E-01, 1.2738289460E-01, 8.3590516977E-01],
	[4.3760000000E+04, 1.8776388611E+00, 1.6115120819E+00, 1.4936965153E-01, 1.2742230799E-01, 8.3593010419E-01],
	[4.3765000000E+04, 1.8779853330E+00, 1.6115028093E+00, 1.4942170900E-01, 1.2746172778E-01, 8.3595503637E-01],
	[4.3770000000E+04, 1.8783318292E+00, 1.6114935378E+00, 1.4947377865E-01, 1.2750115395E-01, 8.3597996632E-01],
	[4.3775000000E+04, 1.8786783497E+00, 1.6114842674E+00, 1.4952586050E-01, 1.2754058651E-01, 8.3600489403E-01],
	[4.3780000000E+04, 1.8790248946E+00, 1.6114749981E+00, 1.4957795454E-01, 1.2758002546E-01, 8.3602981950E-01],
	[4.3785000000E+04, 1.8793714638E+00, 1.6114657299E+00, 1.4963006078E-01, 1.2761947079E-01, 8.3605474274E-01],
	[4.3790000000E+04, 1.8797180574E+00, 1.6114564629E+00, 1.4968217922E-01, 1.2765892250E-01, 8.3607966374E-01],
	[4.3795000000E+04, 1.8800646752E+00, 1.6114471969E+00, 1.4973430986E-01, 1.2769838061E-01, 8.3610458250E-01],
	[4.3800000000E+04, 1.8804113175E+00, 1.6114379321E+00, 1.4978645270E-01, 1.2773784509E-01, 8.3612949902E-01],
	[4.3805000000E+04, 1.8807579840E+00, 1.6114286683E+00, 1.4983860774E-01, 1.2777731596E-01, 8.3615441330E-01],
	[4.3810000000E+04, 1.8811046749E+00, 1.6114194057E+00, 1.4989077499E-01, 1.2781679322E-01, 8.3617932534E-01],
	[4.3815000000E+04, 1.8814513901E+00, 1.6114101442E+00, 1.4994295444E-01, 1.2785627686E-01, 8.3620423514E-01],
	[4.3820000000E+04, 1.8817981297E+00, 1.6114008838E+00, 1.4999514610E-01, 1.2789576688E-01, 8.3622914270E-01],
	[4.3825000000E+04, 1.8821448936E+00, 1.6113916245E+00, 1.5004734997E-01, 1.2793526328E-01, 8.3625404802E-01],
	[4.3830000000E+04, 1.8824916818E+00, 1.6113823664E+00, 1.5009956605E-01, 1.2797476606E-01, 8.3627895109E-01],
	[4.3835000000E+04, 1.8828384943E+00, 1.6113731093E+00, 1.5015179434E-01, 1.2801427523E-01, 8.3630385193E-01],
	[4.3840000000E+04, 1.8831853312E+00, 1.6113638533E+00, 1.5020403484E-01, 1.2805379077E-01, 8.3632875052E-01],
	[4.3845000000E+04, 1.8835321924E+00, 1.6113545985E+00, 1.5025628756E-01, 1.2809331270E-01, 8.3635364687E-01],
	[4.3850000000E+04, 1.8838790779E+00, 1.6113453448E+00, 1.5030855250E-01, 1.2813284101E-01, 8.3637854098E-01],
	[4.3855000000E+04, 1.8842259877E+00, 1.6113360921E+00, 1.5036082965E-01, 1.2817237569E-01, 8.3640343284E-01],
	[4.3860000000E+04, 1.8845729219E+00, 1.6113268406E+00, 1.5041311902E-01, 1.2821191676E-01, 8.3642832246E-01],
	[4.3865000000E+04, 1.8849198803E+00, 1.6113175902E+00, 1.5046542061E-01, 1.2825146420E-01, 8.3645320983E-01],
	[4.3870000000E+04, 1.8852668631E+00, 1.6113083409E+00, 1.5051773442E-01, 1.2829101802E-01, 8.3647809496E-01],
	[4.3875000000E+04, 1.8856138702E+00, 1.6112990927E+00, 1.5057006046E-01, 1.2833057822E-01, 8.3650297784E-01],
	[4.3880000000E+04, 1.8859612653E+00, 1.6112902032E+00, 1.5062239872E-01, 1.2837014875E-01, 8.3652785847E-01],
	[4.3885000000E+04, 1.8863091136E+00, 1.6112817364E+00, 1.5067474921E-01, 1.2840973032E-01, 8.3655273686E-01],
	[4.3890000000E+04, 1.8866569864E+00, 1.6112732705E+00, 1.5072711192E-01, 1.2844931828E-01, 8.3657761300E-01],
	[4.3895000000E+04, 1.8870048837E+00, 1.6112648057E+00, 1.5077948687E-01, 1.2848891263E-01, 8.3660248690E-01],
	[4.3900000000E+04, 1.8873528055E+00, 1.6112563419E+00, 1.5083187404E-01, 1.2852851335E-01, 8.3662735854E-01],
	[4.3905000000E+04, 1.8877007518E+00, 1.6112478791E+00, 1.5088427345E-01, 1.2856812046E-01, 8.3665222794E-01],
	[4.3910000000E+04, 1.8880487227E+00, 1.6112394173E+00, 1.5093668509E-01, 1.2860773396E-01, 8.3667709509E-01],
	[4.3915000000E+04, 1.8883967180E+00, 1.6112309566E+00, 1.5098910897E-01, 1.2864735383E-01, 8.3670195999E-01],
	[4.3920000000E+04, 1.8887447379E+00, 1.6112224968E+00, 1.5104154508E-01, 1.2868698009E-01, 8.3672682264E-01],
	[4.3925000000E+04, 1.8890927823E+00, 1.6112140380E+00, 1.5109399343E-01, 1.2872661272E-01, 8.3675168304E-01],
	[4.3930000000E+04, 1.8894408511E+00, 1.6112055803E+00, 1.5114645402E-01, 1.2876625174E-01, 8.3677654119E-01],
	[4.3935000000E+04, 1.8897889445E+00, 1.6111971235E+00, 1.5119892685E-01, 1.2880589714E-01, 8.3680139709E-01],
	[4.3940000000E+04, 1.8901370624E+00, 1.6111886678E+00, 1.5125141192E-01, 1.2884554892E-01, 8.3682625074E-01],
	[4.3945000000E+04, 1.8904852048E+00, 1.6111802130E+00, 1.5130390924E-01, 1.2888520708E-01, 8.3685110213E-01],
	[4.3950000000E+04, 1.8908333717E+00, 1.6111717593E+00, 1.5135641880E-01, 1.2892487161E-01, 8.3687595128E-01],
	[4.3955000000E+04, 1.8911815632E+00, 1.6111633066E+00, 1.5140894061E-01, 1.2896454253E-01, 8.3690079817E-01],
	[4.3960000000E+04, 1.8915297791E+00, 1.6111548549E+00, 1.5146147466E-01, 1.2900421982E-01, 8.3692564281E-01],
	[4.3965000000E+04, 1.8918780195E+00, 1.6111464042E+00, 1.5151402097E-01, 1.2904390349E-01, 8.3695048519E-01],
	[4.3970000000E+04, 1.8922262844E+00, 1.6111379544E+00, 1.5156657953E-01, 1.2908359353E-01, 8.3697532532E-01],
	[4.3975000000E+04, 1.8925745738E+00, 1.6111295057E+00, 1.5161915034E-01, 1.2912328996E-01, 8.3700016319E-01],
	[4.3980000000E+04, 1.8929228877E+00, 1.6111210580E+00, 1.5167173340E-01, 1.2916299276E-01, 8.3702499881E-01],
	[4.3985000000E+04, 1.8932712261E+00, 1.6111126114E+00, 1.5172432872E-01, 1.2920270193E-01, 8.3704983218E-01],
	[4.3990000000E+04, 1.8936195890E+00, 1.6111041657E+00, 1.5177693630E-01, 1.2924241748E-01, 8.3707466329E-01],
	[4.3995000000E+04, 1.8939679764E+00, 1.6110957210E+00, 1.5182955613E-01, 1.2928213940E-01, 8.3709949214E-01],
	[4.4000000000E+04, 1.8943163883E+00, 1.6110872773E+00, 1.5188218823E-01, 1.2932186770E-01, 8.3712431873E-01],
	[4.4005000000E+04, 1.8946648247E+00, 1.6110788346E+00, 1.5193483258E-01, 1.2936160237E-01, 8.3714914307E-01],
	[4.4010000000E+04, 1.8950132856E+00, 1.6110703930E+00, 1.5198748920E-01, 1.2940134341E-01, 8.3717396515E-01],
	[4.4015000000E+04, 1.8953617709E+00, 1.6110619523E+00, 1.5204015809E-01, 1.2944109083E-01, 8.3719878498E-01],
	[4.4020000000E+04, 1.8957102808E+00, 1.6110535126E+00, 1.5209283924E-01, 1.2948084462E-01, 8.3722360254E-01],
	[4.4025000000E+04, 1.8960588151E+00, 1.6110450739E+00, 1.5214553265E-01, 1.2952060478E-01, 8.3724841785E-01],
	[4.4030000000E+04, 1.8964073740E+00, 1.6110366363E+00, 1.5219823834E-01, 1.2956037131E-01, 8.3727323090E-01],
	[4.4035000000E+04, 1.8967559573E+00, 1.6110281996E+00, 1.5225095629E-01, 1.2960014421E-01, 8.3729804168E-01],
	[4.4040000000E+04, 1.8971045651E+00, 1.6110197640E+00, 1.5230368652E-01, 1.2963992349E-01, 8.3732285021E-01],
	[4.4045000000E+04, 1.8974531974E+00, 1.6110113293E+00, 1.5235642902E-01, 1.2967970913E-01, 8.3734765648E-01],
	[4.4050000000E+04, 1.8978018541E+00, 1.6110028957E+00, 1.5240918379E-01, 1.2971950114E-01, 8.3737246048E-01],
	[4.4055000000E+04, 1.8981505354E+00, 1.6109944630E+00, 1.5246195084E-01, 1.2975929952E-01, 8.3739726222E-01],
	[4.4060000000E+04, 1.8984992411E+00, 1.6109860314E+00, 1.5251473017E-01, 1.2979910427E-01, 8.3742206171E-01],
	[4.4065000000E+04, 1.8988479713E+00, 1.6109776007E+00, 1.5256752178E-01, 1.2983891538E-01, 8.3744685893E-01],
	[4.4070000000E+04, 1.8991967260E+00, 1.6109691711E+00, 1.5262032567E-01, 1.2987873287E-01, 8.3747165388E-01],
	[4.4075000000E+04, 1.8995455052E+00, 1.6109607424E+00, 1.5267314183E-01, 1.2991855672E-01, 8.3749644658E-01],
	[4.4080000000E+04, 1.8998943088E+00, 1.6109523148E+00, 1.5272597029E-01, 1.2995838694E-01, 8.3752123701E-01],
	[4.4085000000E+04, 1.9002431369E+00, 1.6109438881E+00, 1.5277881102E-01, 1.2999822352E-01, 8.3754602517E-01],
	[4.4090000000E+04, 1.9005919895E+00, 1.6109354625E+00, 1.5283166405E-01, 1.3003806647E-01, 8.3757081107E-01],
	[4.4095000000E+04, 1.9009408666E+00, 1.6109270378E+00, 1.5288452936E-01, 1.3007791578E-01, 8.3759559471E-01],
	[4.4100000000E+04, 1.9012897681E+00, 1.6109186142E+00, 1.5293740696E-01, 1.3011777146E-01, 8.3762037608E-01],
	[4.4105000000E+04, 1.9016386941E+00, 1.6109101915E+00, 1.5299029685E-01, 1.3015763350E-01, 8.3764515519E-01],
	[4.4110000000E+04, 1.9019876446E+00, 1.6109017699E+00, 1.5304319903E-01, 1.3019750190E-01, 8.3766993203E-01],
	[4.4115000000E+04, 1.9023366196E+00, 1.6108933492E+00, 1.5309611351E-01, 1.3023737667E-01, 8.3769470660E-01],
	[4.4120000000E+04, 1.9026856190E+00, 1.6108849295E+00, 1.5314904028E-01, 1.3027725780E-01, 8.3771947891E-01],
	[4.4125000000E+04, 1.9030346429E+00, 1.6108765109E+00, 1.5320197935E-01, 1.3031714529E-01, 8.3774424894E-01],
	[4.4130000000E+04, 1.9033836912E+00, 1.6108680932E+00, 1.5325493071E-01, 1.3035703915E-01, 8.3776901671E-01],
	[4.4135000000E+04, 1.9037327640E+00, 1.6108596766E+00, 1.5330789438E-01, 1.3039693936E-01, 8.3779378222E-01],
	[4.4140000000E+04, 1.9040818613E+00, 1.6108512609E+00, 1.5336087034E-01, 1.3043684593E-01, 8.3781854545E-01],
	[4.4145000000E+04, 1.9044309831E+00, 1.6108428462E+00, 1.5341385861E-01, 1.3047675887E-01, 8.3784330642E-01],
	[4.4150000000E+04, 1.9047801293E+00, 1.6108344326E+00, 1.5346685918E-01, 1.3051667816E-01, 8.3786806511E-01],
	[4.4155000000E+04, 1.9051292999E+00, 1.6108260199E+00, 1.5351987206E-01, 1.3055660382E-01, 8.3789282153E-01],
	[4.4160000000E+04, 1.9054784950E+00, 1.6108176082E+00, 1.5357289724E-01, 1.3059653583E-01, 8.3791757569E-01],
	[4.4165000000E+04, 1.9058277146E+00, 1.6108091975E+00, 1.5362593474E-01, 1.3063647420E-01, 8.3794232757E-01],
	[4.4170000000E+04, 1.9061769587E+00, 1.6108007878E+00, 1.5367898454E-01, 1.3067641893E-01, 8.3796707719E-01],
	[4.4175000000E+04, 1.9065262272E+00, 1.6107923792E+00, 1.5373204665E-01, 1.3071637001E-01, 8.3799182453E-01],
	[4.4180000000E+04, 1.9068755201E+00, 1.6107839715E+00, 1.5378512108E-01, 1.3075632746E-01, 8.3801656959E-01],
	[4.4185000000E+04, 1.9072248375E+00, 1.6107755648E+00, 1.5383820782E-01, 1.3079629125E-01, 8.3804131239E-01],
	[4.4190000000E+04, 1.9075741794E+00, 1.6107671591E+00, 1.5389130687E-01, 1.3083626141E-01, 8.3806605291E-01],
	[4.4195000000E+04, 1.9079235457E+00, 1.6107587544E+00, 1.5394441824E-01, 1.3087623792E-01, 8.3809079116E-01],
	[4.4200000000E+04, 1.9082729365E+00, 1.6107503506E+00, 1.5399754193E-01, 1.3091622078E-01, 8.3811552714E-01],
	[4.4205000000E+04, 1.9086223517E+00, 1.6107419479E+00, 1.5405067794E-01, 1.3095621000E-01, 8.3814026084E-01],
	[4.4210000000E+04, 1.9089717913E+00, 1.6107335462E+00, 1.5410382627E-01, 1.3099620557E-01, 8.3816499227E-01],
	[4.4215000000E+04, 1.9093212554E+00, 1.6107251455E+00, 1.5415698693E-01, 1.3103620750E-01, 8.3818972142E-01],
	[4.4220000000E+04, 1.9096707440E+00, 1.6107167457E+00, 1.5421015991E-01, 1.3107621577E-01, 8.3821444830E-01],
	[4.4225000000E+04, 1.9100202570E+00, 1.6107083470E+00, 1.5426334521E-01, 1.3111623040E-01, 8.3823917290E-01],
	[4.4230000000E+04, 1.9103697944E+00, 1.6106999492E+00, 1.5431654284E-01, 1.3115625138E-01, 8.3826389522E-01],
	[4.4235000000E+04, 1.9107193563E+00, 1.6106915525E+00, 1.5436975280E-01, 1.3119627872E-01, 8.3828861527E-01],
	[4.4240000000E+04, 1.9110689427E+00, 1.6106831567E+00, 1.5442297509E-01, 1.3123631240E-01, 8.3831333304E-01],
	[4.4245000000E+04, 1.9114185534E+00, 1.6106747619E+00, 1.5447620972E-01, 1.3127635243E-01, 8.3833804853E-01],
	[4.4250000000E+04, 1.9117681887E+00, 1.6106663682E+00, 1.5452945667E-01, 1.3131639882E-01, 8.3836276175E-01],
	[4.4255000000E+04, 1.9121178483E+00, 1.6106579754E+00, 1.5458271596E-01, 1.3135645155E-01, 8.3838747269E-01],
	[4.4260000000E+04, 1.9124675324E+00, 1.6106495836E+00, 1.5463598759E-01, 1.3139651063E-01, 8.3841218134E-01],
	[4.4265000000E+04, 1.9128172409E+00, 1.6106411928E+00, 1.5468927155E-01, 1.3143657606E-01, 8.3843688772E-01],
	[4.4270000000E+04, 1.9131669739E+00, 1.6106328030E+00, 1.5474256785E-01, 1.3147664784E-01, 8.3846159182E-01],
	[4.4275000000E+04, 1.9135167313E+00, 1.6106244141E+00, 1.5479587649E-01, 1.3151672596E-01, 8.3848629364E-01],
	[4.4280000000E+04, 1.9138665132E+00, 1.6106160263E+00, 1.5484919748E-01, 1.3155681043E-01, 8.3851099318E-01],
	[4.4285000000E+04, 1.9142163194E+00, 1.6106076395E+00, 1.5490253080E-01, 1.3159690125E-01, 8.3853569044E-01],
	[4.4290000000E+04, 1.9145661501E+00, 1.6105992536E+00, 1.5495587647E-01, 1.3163699842E-01, 8.3856038541E-01],
	[4.4295000000E+04, 1.9149160053E+00, 1.6105908688E+00, 1.5500923449E-01, 1.3167710193E-01, 8.3858507811E-01],
	[4.4300000000E+04, 1.9152658848E+00, 1.6105824849E+00, 1.5506260486E-01, 1.3171721178E-01, 8.3860976852E-01],
	[4.4305000000E+04, 1.9156157888E+00, 1.6105741020E+00, 1.5511598757E-01, 1.3175732798E-01, 8.3863445665E-01],
	[4.4310000000E+04, 1.9159657172E+00, 1.6105657201E+00, 1.5516938264E-01, 1.3179745052E-01, 8.3865914250E-01],
	[4.4315000000E+04, 1.9163156701E+00, 1.6105573392E+00, 1.5522279006E-01, 1.3183757941E-01, 8.3868382606E-01],
	[4.4320000000E+04, 1.9166656474E+00, 1.6105489593E+00, 1.5527620983E-01, 1.3187771463E-01, 8.3870850734E-01],
	[4.4325000000E+04, 1.9170156491E+00, 1.6105405804E+00, 1.5532964195E-01, 1.3191785620E-01, 8.3873318634E-01],
	[4.4330000000E+04, 1.9173656752E+00, 1.6105322025E+00, 1.5538308644E-01, 1.3195800412E-01, 8.3875786305E-01],
	[4.4335000000E+04, 1.9177157257E+00, 1.6105238255E+00, 1.5543654328E-01, 1.3199815837E-01, 8.3878253748E-01],
	[4.4340000000E+04, 1.9180658007E+00, 1.6105154496E+00, 1.5549001248E-01, 1.3203831897E-01, 8.3880720962E-01],
	[4.4345000000E+04, 1.9184159001E+00, 1.6105070746E+00, 1.5554349404E-01, 1.3207848590E-01, 8.3883187947E-01],
	[4.4350000000E+04, 1.9187660239E+00, 1.6104987006E+00, 1.5559698796E-01, 1.3211865918E-01, 8.3885654704E-01],
	[4.4355000000E+04, 1.9191161721E+00, 1.6104903276E+00, 1.5565049425E-01, 1.3215883879E-01, 8.3888121232E-01],
	[4.4360000000E+04, 1.9194663448E+00, 1.6104819556E+00, 1.5570401290E-01, 1.3219902474E-01, 8.3890587532E-01],
	[4.4365000000E+04, 1.9198165418E+00, 1.6104735846E+00, 1.5575754392E-01, 1.3223921703E-01, 8.3893053603E-01],
	[4.4370000000E+04, 1.9201667633E+00, 1.6104652146E+00, 1.5581108730E-01, 1.3227941566E-01, 8.3895519445E-01],
	[4.4375000000E+04, 1.9205170092E+00, 1.6104568455E+00, 1.5586464306E-01, 1.3231962063E-01, 8.3897985058E-01],
	[4.4380000000E+04, 1.9208672795E+00, 1.6104484775E+00, 1.5591821119E-01, 1.3235983193E-01, 8.3900450442E-01],
	[4.4385000000E+04, 1.9212175742E+00, 1.6104401104E+00, 1.5597179169E-01, 1.3240004957E-01, 8.3902915597E-01],
	[4.4390000000E+04, 1.9215678934E+00, 1.6104317443E+00, 1.5602538456E-01, 1.3244027355E-01, 8.3905380524E-01],
	[4.4395000000E+04, 1.9219182369E+00, 1.6104233792E+00, 1.5607898981E-01, 1.3248050386E-01, 8.3907845221E-01],
	[4.4400000000E+04, 1.9222686048E+00, 1.6104150151E+00, 1.5613260744E-01, 1.3252074050E-01, 8.3910309690E-01],
	[4.4405000000E+04, 1.9226189972E+00, 1.6104066520E+00, 1.5618623744E-01, 1.3256098348E-01, 8.3912773929E-01],
	[4.4410000000E+04, 1.9229694140E+00, 1.6103982898E+00, 1.5623987983E-01, 1.3260123280E-01, 8.3915237939E-01],
	[4.4415000000E+04, 1.9233198551E+00, 1.6103899287E+00, 1.5629353460E-01, 1.3264148845E-01, 8.3917701720E-01],
	[4.4420000000E+04, 1.9236703207E+00, 1.6103815685E+00, 1.5634720174E-01, 1.3268175043E-01, 8.3920165272E-01],
	[4.4425000000E+04, 1.9240208107E+00, 1.6103732093E+00, 1.5640088128E-01, 1.3272201874E-01, 8.3922628595E-01],
	[4.4430000000E+04, 1.9243713251E+00, 1.6103648511E+00, 1.5645457320E-01, 1.3276229338E-01, 8.3925091688E-01],
	[4.4435000000E+04, 1.9247218638E+00, 1.6103564939E+00, 1.5650827750E-01, 1.3280257436E-01, 8.3927554552E-01],
	[4.4440000000E+04, 1.9250724270E+00, 1.6103481376E+00, 1.5656199420E-01, 1.3284286166E-01, 8.3930017187E-01],
	[4.4445000000E+04, 1.9254230146E+00, 1.6103397824E+00, 1.5661572328E-01, 1.3288315530E-01, 8.3932479592E-01],
	[4.4450000000E+04, 1.9257736266E+00, 1.6103314281E+00, 1.5666946476E-01, 1.3292345527E-01, 8.3934941768E-01],
	[4.4455000000E+04, 1.9261242630E+00, 1.6103230748E+00, 1.5672321863E-01, 1.3296376156E-01, 8.3937403715E-01],
	[4.4460000000E+04, 1.9264749237E+00, 1.6103147225E+00, 1.5677698489E-01, 1.3300407419E-01, 8.3939865432E-01],
	[4.4465000000E+04, 1.9268256089E+00, 1.6103063712E+00, 1.5683076355E-01, 1.3304439314E-01, 8.3942326919E-01],
	[4.4470000000E+04, 1.9271763185E+00, 1.6102980208E+00, 1.5688455461E-01, 1.3308471842E-01, 8.3944788177E-01],
	[4.4475000000E+04, 1.9275270524E+00, 1.6102896715E+00, 1.5693835807E-01, 1.3312505003E-01, 8.3947249205E-01],
	[4.4480000000E+04, 1.9278778108E+00, 1.6102813231E+00, 1.5699217392E-01, 1.3316538796E-01, 8.3949710003E-01],
	[4.4485000000E+04, 1.9282285935E+00, 1.6102729757E+00, 1.5704600218E-01, 1.3320573222E-01, 8.3952170572E-01],
	[4.4490000000E+04, 1.9285794006E+00, 1.6102646293E+00, 1.5709984284E-01, 1.3324608281E-01, 8.3954630911E-01],
	[4.4495000000E+04, 1.9289302322E+00, 1.6102562839E+00, 1.5715369591E-01, 1.3328643972E-01, 8.3957091020E-01],
	[4.4500000000E+04, 1.9292810881E+00, 1.6102479394E+00, 1.5720756138E-01, 1.3332680296E-01, 8.3959550900E-01],
	[4.4505000000E+04, 1.9296319684E+00, 1.6102395959E+00, 1.5726143926E-01, 1.3336717252E-01, 8.3962010549E-01],
	[4.4510000000E+04, 1.9299828731E+00, 1.6102312534E+00, 1.5731532955E-01, 1.3340754840E-01, 8.3964469969E-01],
	[4.4515000000E+04, 1.9303338021E+00, 1.6102229119E+00, 1.5736923225E-01, 1.3344793061E-01, 8.3966929159E-01],
	[4.4520000000E+04, 1.9306847556E+00, 1.6102145714E+00, 1.5742314737E-01, 1.3348831914E-01, 8.3969388118E-01],
	[4.4525000000E+04, 1.9310357334E+00, 1.6102062318E+00, 1.5747707489E-01, 1.3352871399E-01, 8.3971846848E-01],
	[4.4530000000E+04, 1.9313867356E+00, 1.6101978933E+00, 1.5753101483E-01, 1.3356911517E-01, 8.3974305347E-01],
	[4.4535000000E+04, 1.9317377622E+00, 1.6101895557E+00, 1.5758496719E-01, 1.3360952266E-01, 8.3976763617E-01],
	[4.4540000000E+04, 1.9320888132E+00, 1.6101812191E+00, 1.5763893196E-01, 1.3364993648E-01, 8.3979221656E-01],
	[4.4545000000E+04, 1.9324398886E+00, 1.6101728834E+00, 1.5769290916E-01, 1.3369035661E-01, 8.3981679465E-01],
	[4.4550000000E+04, 1.9327909883E+00, 1.6101645488E+00, 1.5774689877E-01, 1.3373078307E-01, 8.3984137044E-01],
	[4.4555000000E+04, 1.9331421124E+00, 1.6101562151E+00, 1.5780090081E-01, 1.3377121584E-01, 8.3986594393E-01],
	[4.4560000000E+04, 1.9334932609E+00, 1.6101478824E+00, 1.5785491527E-01, 1.3381165494E-01, 8.3989051511E-01],
	[4.4565000000E+04, 1.9338444337E+00, 1.6101395507E+00, 1.5790894216E-01, 1.3385210035E-01, 8.3991508399E-01],
	[4.4570000000E+04, 1.9341956310E+00, 1.6101312199E+00, 1.5796298147E-01, 1.3389255208E-01, 8.3993965056E-01],
	[4.4575000000E+04, 1.9345468526E+00, 1.6101228902E+00, 1.5801703322E-01, 1.3393301012E-01, 8.3996421483E-01],
	[4.4580000000E+04, 1.9348980986E+00, 1.6101145614E+00, 1.5807109739E-01, 1.3397347449E-01, 8.3998877680E-01],
	[4.4585000000E+04, 1.9352495174E+00, 1.6101063753E+00, 1.5812517399E-01, 1.3401394686E-01, 8.4001333646E-01],
	[4.4590000000E+04, 1.9356016163E+00, 1.6100988158E+00, 1.5817926302E-01, 1.3405443303E-01, 8.4003789382E-01],
	[4.4595000000E+04, 1.9359537397E+00, 1.6100912572E+00, 1.5823336449E-01, 1.3409492552E-01, 8.4006244887E-01],
	[4.4600000000E+04, 1.9363058878E+00, 1.6100836995E+00, 1.5828747840E-01, 1.3413542434E-01, 8.4008700161E-01],
	[4.4605000000E+04, 1.9366580604E+00, 1.6100761426E+00, 1.5834160474E-01, 1.3417592948E-01, 8.4011155205E-01],
	[4.4610000000E+04, 1.9370102575E+00, 1.6100685867E+00, 1.5839574352E-01, 1.3421644095E-01, 8.4013610018E-01],
	[4.4615000000E+04, 1.9373624793E+00, 1.6100610316E+00, 1.5844989474E-01, 1.3425695873E-01, 8.4016064600E-01],
	[4.4620000000E+04, 1.9377147256E+00, 1.6100534774E+00, 1.5850405840E-01, 1.3429748284E-01, 8.4018518952E-01],
	[4.4625000000E+04, 1.9380669964E+00, 1.6100459241E+00, 1.5855823450E-01, 1.3433801326E-01, 8.4020973073E-01],
	[4.4630000000E+04, 1.9384192919E+00, 1.6100383717E+00, 1.5861242305E-01, 1.3437855001E-01, 8.4023426962E-01],
	[4.4635000000E+04, 1.9387716119E+00, 1.6100308202E+00, 1.5866662404E-01, 1.3441909308E-01, 8.4025880621E-01],
	[4.4640000000E+04, 1.9391239564E+00, 1.6100232695E+00, 1.5872083749E-01, 1.3445964246E-01, 8.4028334049E-01],
	[4.4645000000E+04, 1.9394763255E+00, 1.6100157197E+00, 1.5877506338E-01, 1.3450019816E-01, 8.4030787246E-01],
	[4.4650000000E+04, 1.9398287192E+00, 1.6100081708E+00, 1.5882930171E-01, 1.3454076019E-01, 8.4033240212E-01],
	[4.4655000000E+04, 1.9401811374E+00, 1.6100006228E+00, 1.5888355251E-01, 1.3458132853E-01, 8.4035692947E-01],
	[4.4660000000E+04, 1.9405335802E+00, 1.6099930757E+00, 1.5893781575E-01, 1.3462190318E-01, 8.4038145451E-01],
	[4.4665000000E+04, 1.9408860475E+00, 1.6099855294E+00, 1.5899209145E-01, 1.3466248415E-01, 8.4040597724E-01],
	[4.4670000000E+04, 1.9412385394E+00, 1.6099779840E+00, 1.5904637960E-01, 1.3470307144E-01, 8.4043049766E-01],
	[4.4675000000E+04, 1.9415910559E+00, 1.6099704395E+00, 1.5910068022E-01, 1.3474366505E-01, 8.4045501576E-01],
	[4.4680000000E+04, 1.9419435969E+00, 1.6099628959E+00, 1.5915499329E-01, 1.3478426497E-01, 8.4047953155E-01],
	[4.4685000000E+04, 1.9422961624E+00, 1.6099553532E+00, 1.5920931882E-01, 1.3482487120E-01, 8.4050404503E-01],
	[4.4690000000E+04, 1.9426487525E+00, 1.6099478113E+00, 1.5926365681E-01, 1.3486548375E-01, 8.4052855620E-01],
	[4.4695000000E+04, 1.9430013672E+00, 1.6099402703E+00, 1.5931800727E-01, 1.3490610261E-01, 8.4055306505E-01],
	[4.4700000000E+04, 1.9433540064E+00, 1.6099327302E+00, 1.5937237019E-01, 1.3494672778E-01, 8.4057757159E-01],
	[4.4705000000E+04, 1.9437066702E+00, 1.6099251910E+00, 1.5942674558E-01, 1.3498735927E-01, 8.4060207581E-01],
	[4.4710000000E+04, 1.9440593584E+00, 1.6099176527E+00, 1.5948113343E-01, 1.3502799707E-01, 8.4062657772E-01],
	[4.4715000000E+04, 1.9444120713E+00, 1.6099101152E+00, 1.5953553376E-01, 1.3506864118E-01, 8.4065107731E-01],
	[4.4720000000E+04, 1.9447648087E+00, 1.6099025786E+00, 1.5958994655E-01, 1.3510929160E-01, 8.4067557459E-01],
	[4.4725000000E+04, 1.9451175706E+00, 1.6098950429E+00, 1.5964437182E-01, 1.3514994833E-01, 8.4070006955E-01],
	[4.4730000000E+04, 1.9454703571E+00, 1.6098875081E+00, 1.5969880956E-01, 1.3519061137E-01, 8.4072456220E-01],
	[4.4735000000E+04, 1.9458231681E+00, 1.6098799741E+00, 1.5975325978E-01, 1.3523128072E-01, 8.4074905253E-01],
	[4.4740000000E+04, 1.9461760036E+00, 1.6098724410E+00, 1.5980772247E-01, 1.3527195638E-01, 8.4077354054E-01],
	[4.4745000000E+04, 1.9465288637E+00, 1.6098649088E+00, 1.5986219764E-01, 1.3531263834E-01, 8.4079802624E-01],
	[4.4750000000E+04, 1.9468817484E+00, 1.6098573775E+00, 1.5991668529E-01, 1.3535332662E-01, 8.4082250961E-01],
	[4.4755000000E+04, 1.9472346575E+00, 1.6098498471E+00, 1.5997118542E-01, 1.3539402120E-01, 8.4084699067E-01],
	[4.4760000000E+04, 1.9475875912E+00, 1.6098423175E+00, 1.6002569803E-01, 1.3543472209E-01, 8.4087146941E-01],
	[4.4765000000E+04, 1.9479405495E+00, 1.6098347888E+00, 1.6008022313E-01, 1.3547542928E-01, 8.4089594584E-01],
	[4.4770000000E+04, 1.9482935323E+00, 1.6098272610E+00, 1.6013476071E-01, 1.3551614278E-01, 8.4092041994E-01],
	[4.4775000000E+04, 1.9486465396E+00, 1.6098197340E+00, 1.6018931078E-01, 1.3555686259E-01, 8.4094489172E-01],
	[4.4780000000E+04, 1.9489995714E+00, 1.6098122080E+00, 1.6024387334E-01, 1.3559758870E-01, 8.4096936118E-01],
	[4.4785000000E+04, 1.9493526278E+00, 1.6098046828E+00, 1.6029844838E-01, 1.3563832111E-01, 8.4099382833E-01],
	[4.4790000000E+04, 1.9497057087E+00, 1.6097971585E+00, 1.6035303592E-01, 1.3567905983E-01, 8.4101829315E-01],
	[4.4795000000E+04, 1.9500588141E+00, 1.6097896350E+00, 1.6040763595E-01, 1.3571980485E-01, 8.4104275565E-01],
	[4.4800000000E+04, 1.9504119441E+00, 1.6097821125E+00, 1.6046224848E-01, 1.3576055617E-01, 8.4106721583E-01],
	[4.4805000000E+04, 1.9507650985E+00, 1.6097745908E+00, 1.6051687350E-01, 1.3580131380E-01, 8.4109167368E-01],
	[4.4810000000E+04, 1.9511182776E+00, 1.6097670700E+00, 1.6057151101E-01, 1.3584207772E-01, 8.4111612922E-01],
	[4.4815000000E+04, 1.9514714811E+00, 1.6097595500E+00, 1.6062616103E-01, 1.3588284795E-01, 8.4114058243E-01],
	[4.4820000000E+04, 1.9518247091E+00, 1.6097520309E+00, 1.6068082354E-01, 1.3592362448E-01, 8.4116503332E-01],
	[4.4825000000E+04, 1.9521779617E+00, 1.6097445127E+00, 1.6073549856E-01, 1.3596440731E-01, 8.4118948188E-01],
	[4.4830000000E+04, 1.9525312388E+00, 1.6097369954E+00, 1.6079018608E-01, 1.3600519643E-01, 8.4121392812E-01],
	[4.4835000000E+04, 1.9528845405E+00, 1.6097294790E+00, 1.6084488610E-01, 1.3604599186E-01, 8.4123837204E-01],
	[4.4840000000E+04, 1.9532378666E+00, 1.6097219634E+00, 1.6089959863E-01, 1.3608679358E-01, 8.4126281363E-01],
	[4.4845000000E+04, 1.9535912173E+00, 1.6097144487E+00, 1.6095432367E-01, 1.3612760160E-01, 8.4128725290E-01],
	[4.4850000000E+04, 1.9539445924E+00, 1.6097069349E+00, 1.6100906121E-01, 1.3616841592E-01, 8.4131168984E-01],
	[4.4855000000E+04, 1.9542979921E+00, 1.6096994219E+00, 1.6106381127E-01, 1.3620923654E-01, 8.4133612446E-01],
	[4.4860000000E+04, 1.9546514163E+00, 1.6096919098E+00, 1.6111857384E-01, 1.3625006345E-01, 8.4136055675E-01],
	[4.4865000000E+04, 1.9550048651E+00, 1.6096843986E+00, 1.6117334892E-01, 1.3629089666E-01, 8.4138498671E-01],
	[4.4870000000E+04, 1.9553583383E+00, 1.6096768883E+00, 1.6122813651E-01, 1.3633173616E-01, 8.4140941435E-01],
	[4.4875000000E+04, 1.9557118361E+00, 1.6096693788E+00, 1.6128293662E-01, 1.3637258196E-01, 8.4143383966E-01],
	[4.4880000000E+04, 1.9560653583E+00, 1.6096618702E+00, 1.6133774925E-01, 1.3641343405E-01, 8.4145826264E-01],
	[4.4885000000E+04, 1.9564189051E+00, 1.6096543625E+00, 1.6139257440E-01, 1.3645429243E-01, 8.4148268330E-01],
	[4.4890000000E+04, 1.9567724764E+00, 1.6096468556E+00, 1.6144741206E-01, 1.3649515711E-01, 8.4150710162E-01],
	[4.4895000000E+04, 1.9571260722E+00, 1.6096393497E+00, 1.6150226225E-01, 1.3653602808E-01, 8.4153151762E-01],
	[4.4900000000E+04, 1.9574796925E+00, 1.6096318446E+00, 1.6155712497E-01, 1.3657690534E-01, 8.4155593129E-01],
	[4.4905000000E+04, 1.9578333373E+00, 1.6096243403E+00, 1.6161200020E-01, 1.3661778889E-01, 8.4158034263E-01],
	[4.4910000000E+04, 1.9581870066E+00, 1.6096168369E+00, 1.6166688797E-01, 1.3665867874E-01, 8.4160475164E-01],
	[4.4915000000E+04, 1.9585407004E+00, 1.6096093344E+00, 1.6172178826E-01, 1.3669957487E-01, 8.4162915832E-01],
	[4.4920000000E+04, 1.9588944187E+00, 1.6096018328E+00, 1.6177670108E-01, 1.3674047730E-01, 8.4165356266E-01],
	[4.4925000000E+04, 1.9592481615E+00, 1.6095943321E+00, 1.6183162643E-01, 1.3678138601E-01, 8.4167796468E-01],
	[4.4930000000E+04, 1.9596019288E+00, 1.6095868322E+00, 1.6188656431E-01, 1.3682230101E-01, 8.4170236437E-01],
	[4.4935000000E+04, 1.9599557207E+00, 1.6095793331E+00, 1.6194151473E-01, 1.3686322230E-01, 8.4172676172E-01],
	[4.4940000000E+04, 1.9603095370E+00, 1.6095718350E+00, 1.6199647768E-01, 1.3690414988E-01, 8.4175115675E-01],
	[4.4945000000E+04, 1.9606633778E+00, 1.6095643377E+00, 1.6205145317E-01, 1.3694508375E-01, 8.4177554944E-01],
	[4.4950000000E+04, 1.9610172431E+00, 1.6095568413E+00, 1.6210644120E-01, 1.3698602390E-01, 8.4179993979E-01],
	[4.4955000000E+04, 1.9613711329E+00, 1.6095493458E+00, 1.6216144176E-01, 1.3702697034E-01, 8.4182432782E-01],
	[4.4960000000E+04, 1.9617250472E+00, 1.6095418511E+00, 1.6221645487E-01, 1.3706792306E-01, 8.4184871351E-01],
	[4.4965000000E+04, 1.9620789860E+00, 1.6095343573E+00, 1.6227148052E-01, 1.3710888207E-01, 8.4187309687E-01],
	[4.4970000000E+04, 1.9624329493E+00, 1.6095268643E+00, 1.6232651871E-01, 1.3714984736E-01, 8.4189747789E-01],
	[4.4975000000E+04, 1.9627869371E+00, 1.6095193723E+00, 1.6238156945E-01, 1.3719081894E-01, 8.4192185658E-01],
	[4.4980000000E+04, 1.9631409494E+00, 1.6095118811E+00, 1.6243663273E-01, 1.3723179680E-01, 8.4194623293E-01],
	[4.4985000000E+04, 1.9634949861E+00, 1.6095043907E+00, 1.6249170857E-01, 1.3727278095E-01, 8.4197060695E-01],
	[4.4990000000E+04, 1.9638490474E+00, 1.6094969013E+00, 1.6254679695E-01, 1.3731377137E-01, 8.4199497864E-01],
	[4.4995000000E+04, 1.9642031331E+00, 1.6094894127E+00, 1.6260189788E-01, 1.3735476808E-01, 8.4201934798E-01],
	[4.5000000000E+04, 1.9645572433E+00, 1.6094819249E+00, 1.6265701137E-01, 1.3739577107E-01, 8.4204371499E-01],
	[4.5005000000E+04, 1.9649113781E+00, 1.6094744381E+00, 1.6271234238E-01, 1.3743692657E-01, 8.4206807967E-01],
	[4.5010000000E+04, 1.9652655372E+00, 1.6094669521E+00, 1.6276768606E-01, 1.3747808842E-01, 8.4209244200E-01],
	[4.5015000000E+04, 1.9656197209E+00, 1.6094594669E+00, 1.6282304241E-01, 1.3751925660E-01, 8.4211680200E-01],
	[4.5020000000E+04, 1.9659739291E+00, 1.6094519827E+00, 1.6287841144E-01, 1.3756043112E-01, 8.4214115966E-01],
	[4.5025000000E+04, 1.9663281617E+00, 1.6094444993E+00, 1.6293379315E-01, 1.3760161198E-01, 8.4216551499E-01],
	[4.5030000000E+04, 1.9666824189E+00, 1.6094370167E+00, 1.6298918753E-01, 1.3764279918E-01, 8.4218986797E-01],
	[4.5035000000E+04, 1.9670367005E+00, 1.6094295350E+00, 1.6304459459E-01, 1.3768399271E-01, 8.4221421862E-01],
	[4.5040000000E+04, 1.9673910065E+00, 1.6094220542E+00, 1.6310001434E-01, 1.3772519258E-01, 8.4223856693E-01],
	[4.5045000000E+04, 1.9677453371E+00, 1.6094145743E+00, 1.6315544676E-01, 1.3776639879E-01, 8.4226291289E-01],
	[4.5050000000E+04, 1.9680996921E+00, 1.6094070952E+00, 1.6321089187E-01, 1.3780761133E-01, 8.4228725652E-01],
	[4.5055000000E+04, 1.9684540717E+00, 1.6093996170E+00, 1.6326634967E-01, 1.3784883021E-01, 8.4231159781E-01],
	[4.5060000000E+04, 1.9688084756E+00, 1.6093921397E+00, 1.6332182015E-01, 1.3789005542E-01, 8.4233593675E-01],
	[4.5065000000E+04, 1.9691629041E+00, 1.6093846632E+00, 1.6337730332E-01, 1.3793128696E-01, 8.4236027336E-01],
	[4.5070000000E+04, 1.9695173570E+00, 1.6093771876E+00, 1.6343279918E-01, 1.3797252484E-01, 8.4238460762E-01],
	[4.5075000000E+04, 1.9698718344E+00, 1.6093697128E+00, 1.6348830773E-01, 1.3801376905E-01, 8.4240893954E-01],
	[4.5080000000E+04, 1.9702263363E+00, 1.6093622389E+00, 1.6354382898E-01, 1.3805501959E-01, 8.4243326912E-01],
	[4.5085000000E+04, 1.9705808626E+00, 1.6093547659E+00, 1.6359936292E-01, 1.3809627646E-01, 8.4245759636E-01],
	[4.5090000000E+04, 1.9709354135E+00, 1.6093472937E+00, 1.6365490955E-01, 1.3813753967E-01, 8.4248192126E-01],
	[4.5095000000E+04, 1.9712899887E+00, 1.6093398224E+00, 1.6371046888E-01, 1.3817880920E-01, 8.4250624381E-01],
	[4.5100000000E+04, 1.9716445885E+00, 1.6093323520E+00, 1.6376604092E-01, 1.3822008506E-01, 8.4253056401E-01],
	[4.5105000000E+04, 1.9719992127E+00, 1.6093248824E+00, 1.6382162565E-01, 1.3826136726E-01, 8.4255488188E-01],
	[4.5110000000E+04, 1.9723538614E+00, 1.6093174137E+00, 1.6387722308E-01, 1.3830265578E-01, 8.4257919740E-01],
	[4.5115000000E+04, 1.9727085345E+00, 1.6093099459E+00, 1.6393283322E-01, 1.3834395063E-01, 8.4260351057E-01],
	[4.5120000000E+04, 1.9730632321E+00, 1.6093024789E+00, 1.6398845606E-01, 1.3838525181E-01, 8.4262782140E-01],
	[4.5125000000E+04, 1.9734179541E+00, 1.6092950128E+00, 1.6404409160E-01, 1.3842655931E-01, 8.4265212989E-01],
	[4.5130000000E+04, 1.9737727007E+00, 1.6092875475E+00, 1.6409973986E-01, 1.3846787314E-01, 8.4267643603E-01],
	[4.5135000000E+04, 1.9741274716E+00, 1.6092800831E+00, 1.6415540082E-01, 1.3850919330E-01, 8.4270073982E-01],
	[4.5140000000E+04, 1.9744822671E+00, 1.6092726196E+00, 1.6421107450E-01, 1.3855051978E-01, 8.4272504127E-01],
	[4.5145000000E+04, 1.9748370870E+00, 1.6092651569E+00, 1.6426676089E-01, 1.3859185259E-01, 8.4274934037E-01],
	[4.5150000000E+04, 1.9751919313E+00, 1.6092576951E+00, 1.6432245999E-01, 1.3863319172E-01, 8.4277363712E-01],
	[4.5155000000E+04, 1.9755468001E+00, 1.6092502341E+00, 1.6437817181E-01, 1.3867453717E-01, 8.4279793153E-01],
	[4.5160000000E+04, 1.9759016934E+00, 1.6092427740E+00, 1.6443389634E-01, 1.3871588895E-01, 8.4282222358E-01],
	[4.5165000000E+04, 1.9762566111E+00, 1.6092353148E+00, 1.6448963359E-01, 1.3875724705E-01, 8.4284651329E-01],
	[4.5170000000E+04, 1.9766115533E+00, 1.6092278564E+00, 1.6454538356E-01, 1.3879861148E-01, 8.4287080066E-01],
	[4.5175000000E+04, 1.9769665199E+00, 1.6092203989E+00, 1.6460114626E-01, 1.3883998222E-01, 8.4289508567E-01],
	[4.5180000000E+04, 1.9773215109E+00, 1.6092129422E+00, 1.6465692167E-01, 1.3888135929E-01, 8.4291936833E-01],
	[4.5185000000E+04, 1.9776765264E+00, 1.6092054864E+00, 1.6471270981E-01, 1.3892274268E-01, 8.4294364864E-01],
	[4.5190000000E+04, 1.9780315664E+00, 1.6091980315E+00, 1.6476851068E-01, 1.3896413238E-01, 8.4296792661E-01],
	[4.5195000000E+04, 1.9783866308E+00, 1.6091905774E+00, 1.6482432427E-01, 1.3900552841E-01, 8.4299220222E-01],
	[4.5200000000E+04, 1.9787417197E+00, 1.6091831242E+00, 1.6488015059E-01, 1.3904693075E-01, 8.4301647548E-01],
	[4.5205000000E+04, 1.9790968329E+00, 1.6091756719E+00, 1.6493598964E-01, 1.3908833942E-01, 8.4304074640E-01],
	[4.5210000000E+04, 1.9794519707E+00, 1.6091682204E+00, 1.6499184142E-01, 1.3912975440E-01, 8.4306501496E-01],
	[4.5215000000E+04, 1.9798071329E+00, 1.6091607697E+00, 1.6504770594E-01, 1.3917117569E-01, 8.4308928117E-01],
	[4.5220000000E+04, 1.9801623195E+00, 1.6091533199E+00, 1.6510358319E-01, 1.3921260331E-01, 8.4311354502E-01],
	[4.5225000000E+04, 1.9805175306E+00, 1.6091458710E+00, 1.6515947318E-01, 1.3925403724E-01, 8.4313780653E-01],
	[4.5230000000E+04, 1.9808727661E+00, 1.6091384229E+00, 1.6521537590E-01, 1.3929547749E-01, 8.4316206568E-01],
	[4.5235000000E+04, 1.9812280260E+00, 1.6091309757E+00, 1.6527129137E-01, 1.3933692405E-01, 8.4318632248E-01],
	[4.5240000000E+04, 1.9815833104E+00, 1.6091235294E+00, 1.6532721957E-01, 1.3937837692E-01, 8.4321057693E-01],
	[4.5245000000E+04, 1.9819386192E+00, 1.6091160839E+00, 1.6538316052E-01, 1.3941983611E-01, 8.4323482902E-01],
	[4.5250000000E+04, 1.9822939524E+00, 1.6091086393E+00, 1.6543911421E-01, 1.3946130161E-01, 8.4325907876E-01],
	[4.5255000000E+04, 1.9826493101E+00, 1.6091011955E+00, 1.6549508065E-01, 1.3950277343E-01, 8.4328332614E-01],
	[4.5260000000E+04, 1.9830046923E+00, 1.6090937526E+00, 1.6555105983E-01, 1.3954425156E-01, 8.4330757117E-01],
	[4.5265000000E+04, 1.9833600988E+00, 1.6090863105E+00, 1.6560705176E-01, 1.3958573600E-01, 8.4333181384E-01],
	[4.5270000000E+04, 1.9837155298E+00, 1.6090788693E+00, 1.6566305644E-01, 1.3962722675E-01, 8.4335605416E-01],
	[4.5275000000E+04, 1.9840709852E+00, 1.6090714289E+00, 1.6571907387E-01, 1.3966872381E-01, 8.4338029212E-01],
	[4.5280000000E+04, 1.9844264650E+00, 1.6090639894E+00, 1.6577510406E-01, 1.3971022718E-01, 8.4340452773E-01],
	[4.5285000000E+04, 1.9847819693E+00, 1.6090565508E+00, 1.6583114700E-01, 1.3975173686E-01, 8.4342876098E-01],
	[4.5290000000E+04, 1.9851374980E+00, 1.6090491130E+00, 1.6588720269E-01, 1.3979325285E-01, 8.4345299187E-01],
	[4.5295000000E+04, 1.9854930511E+00, 1.6090416761E+00, 1.6594327114E-01, 1.3983477515E-01, 8.4347722041E-01],
	[4.5300000000E+04, 1.9858486287E+00, 1.6090342400E+00, 1.6599935235E-01, 1.3987630375E-01, 8.4350144659E-01],
	[4.5305000000E+04, 1.9862047570E+00, 1.6090272856E+00, 1.6605544632E-01, 1.3991784491E-01, 8.4352567041E-01],
	[4.5310000000E+04, 1.9865612110E+00, 1.6090206070E+00, 1.6611155305E-01, 1.3995939596E-01, 8.4354989187E-01],
	[4.5315000000E+04, 1.9869176897E+00, 1.6090139293E+00, 1.6616767254E-01, 1.4000095333E-01, 8.4357411098E-01],
	[4.5320000000E+04, 1.9872741930E+00, 1.6090072523E+00, 1.6622380480E-01, 1.4004251701E-01, 8.4359832772E-01],
	[4.5325000000E+04, 1.9876307209E+00, 1.6090005760E+00, 1.6627994983E-01, 1.4008408700E-01, 8.4362254211E-01],
	[4.5330000000E+04, 1.9879872735E+00, 1.6089939005E+00, 1.6633610762E-01, 1.4012566331E-01, 8.4364675414E-01],
	[4.5335000000E+04, 1.9883438507E+00, 1.6089872258E+00, 1.6639227818E-01, 1.4016724593E-01, 8.4367096380E-01],
	[4.5340000000E+04, 1.9887004525E+00, 1.6089805518E+00, 1.6644846151E-01, 1.4020883486E-01, 8.4369517111E-01],
	[4.5345000000E+04, 1.9890570789E+00, 1.6089738787E+00, 1.6650465762E-01, 1.4025043010E-01, 8.4371937606E-01],
	[4.5350000000E+04, 1.9894137299E+00, 1.6089672062E+00, 1.6656086650E-01, 1.4029203166E-01, 8.4374357864E-01],
	[4.5355000000E+04, 1.9897704056E+00, 1.6089605346E+00, 1.6661708815E-01, 1.4033363952E-01, 8.4376777887E-01],
	[4.5360000000E+04, 1.9901271059E+00, 1.6089538637E+00, 1.6667332258E-01, 1.4037525370E-01, 8.4379197673E-01],
	[4.5365000000E+04, 1.9904838307E+00, 1.6089471935E+00, 1.6672956979E-01, 1.4041687419E-01, 8.4381617223E-01],
	[4.5370000000E+04, 1.9908405803E+00, 1.6089405241E+00, 1.6678582977E-01, 1.4045850098E-01, 8.4384036537E-01],
	[4.5375000000E+04, 1.9911973544E+00, 1.6089338555E+00, 1.6684210254E-01, 1.4050013409E-01, 8.4386455614E-01],
	[4.5380000000E+04, 1.9915541531E+00, 1.6089271877E+00, 1.6689838809E-01, 1.4054177350E-01, 8.4388874456E-01],
	[4.5385000000E+04, 1.9919109765E+00, 1.6089205206E+00, 1.6695468643E-01, 1.4058341922E-01, 8.4391293061E-01],
	[4.5390000000E+04, 1.9922678244E+00, 1.6089138543E+00, 1.6701099755E-01, 1.4062507125E-01, 8.4393711429E-01],
	[4.5395000000E+04, 1.9926246970E+00, 1.6089071887E+00, 1.6706732145E-01, 1.4066672958E-01, 8.4396129561E-01],
	[4.5400000000E+04, 1.9929815942E+00, 1.6089005239E+00, 1.6712365815E-01, 1.4070839422E-01, 8.4398547457E-01],
	[4.5405000000E+04, 1.9933385160E+00, 1.6088938599E+00, 1.6718000763E-01, 1.4075006516E-01, 8.4400965117E-01],
	[4.5410000000E+04, 1.9936954624E+00, 1.6088871966E+00, 1.6723636991E-01, 1.4079174241E-01, 8.4403382539E-01],
	[4.5415000000E+04, 1.9940524334E+00, 1.6088805341E+00, 1.6729274498E-01, 1.4083342596E-01, 8.4405799726E-01],
	[4.5420000000E+04, 1.9944094290E+00, 1.6088738723E+00, 1.6734913285E-01, 1.4087511582E-01, 8.4408216676E-01],
	[4.5425000000E+04, 1.9947664493E+00, 1.6088672113E+00, 1.6740553351E-01, 1.4091681198E-01, 8.4410633389E-01],
	[4.5430000000E+04, 1.9951234941E+00, 1.6088605511E+00, 1.6746194696E-01, 1.4095851444E-01, 8.4413049865E-01],
	[4.5435000000E+04, 1.9954805635E+00, 1.6088538916E+00, 1.6751837322E-01, 1.4100022320E-01, 8.4415466105E-01],
	[4.5440000000E+04, 1.9958376575E+00, 1.6088472329E+00, 1.6757481228E-01, 1.4104193827E-01, 8.4417882108E-01],
	[4.5445000000E+04, 1.9961947762E+00, 1.6088405749E+00, 1.6763126414E-01, 1.4108365964E-01, 8.4420297875E-01],
	[4.5450000000E+04, 1.9965519194E+00, 1.6088339177E+00, 1.6768772880E-01, 1.4112538730E-01, 8.4422713405E-01],
	[4.5455000000E+04, 1.9969090872E+00, 1.6088272613E+00, 1.6774420627E-01, 1.4116712127E-01, 8.4425128698E-01],
	[4.5460000000E+04, 1.9972662797E+00, 1.6088206056E+00, 1.6780069654E-01, 1.4120886153E-01, 8.4427543754E-01],
	[4.5465000000E+04, 1.9976234967E+00, 1.6088139507E+00, 1.6785719962E-01, 1.4125060809E-01, 8.4429958573E-01],
	[4.5470000000E+04, 1.9979807383E+00, 1.6088072965E+00, 1.6791371551E-01, 1.4129236096E-01, 8.4432373155E-01],
	[4.5475000000E+04, 1.9983380045E+00, 1.6088006431E+00, 1.6797024422E-01, 1.4133412011E-01, 8.4434787501E-01],
	[4.5480000000E+04, 1.9986952954E+00, 1.6087939905E+00, 1.6802678573E-01, 1.4137588557E-01, 8.4437201609E-01],
	[4.5485000000E+04, 1.9990526108E+00, 1.6087873386E+00, 1.6808334006E-01, 1.4141765732E-01, 8.4439615481E-01],
	[4.5490000000E+04, 1.9994099508E+00, 1.6087806875E+00, 1.6813990720E-01, 1.4145943537E-01, 8.4442029115E-01],
	[4.5495000000E+04, 1.9997673154E+00, 1.6087740371E+00, 1.6819648717E-01, 1.4150121971E-01, 8.4444442513E-01],
	[4.5500000000E+04, 2.0001247045E+00, 1.6087673875E+00, 1.6825307995E-01, 1.4154301035E-01, 8.4446855673E-01],
	[4.5505000000E+04, 2.0004821183E+00, 1.6087607387E+00, 1.6830968554E-01, 1.4158480728E-01, 8.4449268596E-01],
	[4.5510000000E+04, 2.0008395567E+00, 1.6087540906E+00, 1.6836630397E-01, 1.4162661050E-01, 8.4451681282E-01],
	[4.5515000000E+04, 2.0011970196E+00, 1.6087474433E+00, 1.6842293521E-01, 1.4166842002E-01, 8.4454093731E-01],
	[4.5520000000E+04, 2.0015545071E+00, 1.6087407967E+00, 1.6847957928E-01, 1.4171023583E-01, 8.4456505943E-01],
	[4.5525000000E+04, 2.0019120193E+00, 1.6087341509E+00, 1.6853623617E-01, 1.4175205793E-01, 8.4458917917E-01],
	[4.5530000000E+04, 2.0022695559E+00, 1.6087275058E+00, 1.6859290589E-01, 1.4179388632E-01, 8.4461329654E-01],
	[4.5535000000E+04, 2.0026271172E+00, 1.6087208615E+00, 1.6864958844E-01, 1.4183572101E-01, 8.4463741154E-01],
	[4.5540000000E+04, 2.0029847031E+00, 1.6087142180E+00, 1.6870628382E-01, 1.4187756198E-01, 8.4466152417E-01],
	[4.5545000000E+04, 2.0033423135E+00, 1.6087075752E+00, 1.6876299203E-01, 1.4191940924E-01, 8.4468563442E-01],
	[4.5550000000E+04, 2.0036999486E+00, 1.6087009332E+00, 1.6881971308E-01, 1.4196126279E-01, 8.4470974229E-01],
	[4.5555000000E+04, 2.0040576082E+00, 1.6086942919E+00, 1.6887644696E-01, 1.4200312263E-01, 8.4473384780E-01],
	[4.5560000000E+04, 2.0044152923E+00, 1.6086876514E+00, 1.6893319368E-01, 1.4204498876E-01, 8.4475795092E-01],
	[4.5565000000E+04, 2.0047730011E+00, 1.6086810116E+00, 1.6898995323E-01, 1.4208686118E-01, 8.4478205168E-01],
	[4.5570000000E+04, 2.0051307344E+00, 1.6086743726E+00, 1.6904672563E-01, 1.4212873988E-01, 8.4480615005E-01],
	[4.5575000000E+04, 2.0054884924E+00, 1.6086677343E+00, 1.6910351086E-01, 1.4217062487E-01, 8.4483024606E-01],
	[4.5580000000E+04, 2.0058462748E+00, 1.6086610969E+00, 1.6916030894E-01, 1.4221251614E-01, 8.4485433968E-01],
	[4.5585000000E+04, 2.0062040819E+00, 1.6086544601E+00, 1.6921711986E-01, 1.4225441370E-01, 8.4487843093E-01],
	[4.5590000000E+04, 2.0065619135E+00, 1.6086478241E+00, 1.6927394362E-01, 1.4229631754E-01, 8.4490251980E-01],
	[4.5595000000E+04, 2.0069197697E+00, 1.6086411889E+00, 1.6933078024E-01, 1.4233822766E-01, 8.4492660630E-01],
	[4.5600000000E+04, 2.0072776505E+00, 1.6086345544E+00, 1.6938762970E-01, 1.4238014407E-01, 8.4495069042E-01],
	[4.5605000000E+04, 2.0076355558E+00, 1.6086279207E+00, 1.6944449201E-01, 1.4242206677E-01, 8.4497477216E-01],
	[4.5610000000E+04, 2.0079934857E+00, 1.6086212877E+00, 1.6950136717E-01, 1.4246399574E-01, 8.4499885152E-01],
	[4.5615000000E+04, 2.0083514402E+00, 1.6086146555E+00, 1.6955825519E-01, 1.4250593099E-01, 8.4502292850E-01],
	[4.5620000000E+04, 2.0087094192E+00, 1.6086080241E+00, 1.6961515606E-01, 1.4254787253E-01, 8.4504700311E-01],
	[4.5625000000E+04, 2.0090674228E+00, 1.6086013934E+00, 1.6967206978E-01, 1.4258982035E-01, 8.4507107533E-01],
	[4.5630000000E+04, 2.0094254510E+00, 1.6085947634E+00, 1.6972899636E-01, 1.4263177444E-01, 8.4509514518E-01],
	[4.5635000000E+04, 2.0097835037E+00, 1.6085881342E+00, 1.6978593580E-01, 1.4267373482E-01, 8.4511921265E-01],
	[4.5640000000E+04, 2.0101415810E+00, 1.6085815058E+00, 1.6984288811E-01, 1.4271570147E-01, 8.4514327773E-01],
	[4.5645000000E+04, 2.0104996829E+00, 1.6085748781E+00, 1.6989985327E-01, 1.4275767440E-01, 8.4516734044E-01],
	[4.5650000000E+04, 2.0108578093E+00, 1.6085682512E+00, 1.6995683130E-01, 1.4279965361E-01, 8.4519140077E-01],
	[4.5655000000E+04, 2.0112159603E+00, 1.6085616250E+00, 1.7001382219E-01, 1.4284163910E-01, 8.4521545871E-01],
	[4.5660000000E+04, 2.0115741358E+00, 1.6085549996E+00, 1.7007082594E-01, 1.4288363086E-01, 8.4523951428E-01],
	[4.5665000000E+04, 2.0119323359E+00, 1.6085483749E+00, 1.7012784257E-01, 1.4292562890E-01, 8.4526356746E-01],
	[4.5670000000E+04, 2.0122905605E+00, 1.6085417510E+00, 1.7018487206E-01, 1.4296763322E-01, 8.4528761826E-01],
	[4.5675000000E+04, 2.0126488097E+00, 1.6085351278E+00, 1.7024191443E-01, 1.4300964380E-01, 8.4531166668E-01],
	[4.5680000000E+04, 2.0130070835E+00, 1.6085285054E+00, 1.7029896967E-01, 1.4305166067E-01, 8.4533571272E-01],
	[4.5685000000E+04, 2.0133653818E+00, 1.6085218837E+00, 1.7035603778E-01, 1.4309368380E-01, 8.4535975637E-01],
	[4.5690000000E+04, 2.0137237046E+00, 1.6085152628E+00, 1.7041311876E-01, 1.4313571321E-01, 8.4538379764E-01],
	[4.5695000000E+04, 2.0140820520E+00, 1.6085086427E+00, 1.7047021263E-01, 1.4317774889E-01, 8.4540783653E-01],
	[4.5700000000E+04, 2.0144404240E+00, 1.6085020232E+00, 1.7052731937E-01, 1.4321979084E-01, 8.4543187304E-01],
	[4.5705000000E+04, 2.0147988205E+00, 1.6084954046E+00, 1.7058443899E-01, 1.4326183907E-01, 8.4545590716E-01],
	[4.5710000000E+04, 2.0151572415E+00, 1.6084887867E+00, 1.7064157149E-01, 1.4330389356E-01, 8.4547993889E-01],
	[4.5715000000E+04, 2.0155156871E+00, 1.6084821695E+00, 1.7069871688E-01, 1.4334595433E-01, 8.4550396824E-01],
	[4.5720000000E+04, 2.0158741573E+00, 1.6084755531E+00, 1.7075587514E-01, 1.4338802136E-01, 8.4552799521E-01],
	[4.5725000000E+04, 2.0162326520E+00, 1.6084689375E+00, 1.7081304630E-01, 1.4343009466E-01, 8.4555201979E-01],
	[4.5730000000E+04, 2.0165911712E+00, 1.6084623226E+00, 1.7087023034E-01, 1.4347217423E-01, 8.4557604198E-01],
	[4.5735000000E+04, 2.0169497150E+00, 1.6084557084E+00, 1.7092742727E-01, 1.4351426007E-01, 8.4560006179E-01],
	[4.5740000000E+04, 2.0173082833E+00, 1.6084490950E+00, 1.7098463709E-01, 1.4355635218E-01, 8.4562407922E-01],
	[4.5745000000E+04, 2.0176668762E+00, 1.6084424824E+00, 1.7104185980E-01, 1.4359845055E-01, 8.4564809425E-01],
	[4.5750000000E+04, 2.0180254936E+00, 1.6084358704E+00, 1.7109909541E-01, 1.4364055519E-01, 8.4567210690E-01],
	[4.5755000000E+04, 2.0183841355E+00, 1.6084292593E+00, 1.7115634391E-01, 1.4368266609E-01, 8.4569611716E-01],
	[4.5760000000E+04, 2.0187428020E+00, 1.6084226489E+00, 1.7121360531E-01, 1.4372478326E-01, 8.4572012504E-01],
	[4.5765000000E+04, 2.0191014930E+00, 1.6084160392E+00, 1.7127087960E-01, 1.4376690669E-01, 8.4574413053E-01],
	[4.5770000000E+04, 2.0194602085E+00, 1.6084094303E+00, 1.7132816679E-01, 1.4380903639E-01, 8.4576813363E-01],
	[4.5775000000E+04, 2.0198189486E+00, 1.6084028222E+00, 1.7138546689E-01, 1.4385117234E-01, 8.4579213434E-01],
	[4.5780000000E+04, 2.0201777132E+00, 1.6083962148E+00, 1.7144277988E-01, 1.4389331457E-01, 8.4581613266E-01],
	[4.5785000000E+04, 2.0205365024E+00, 1.6083896081E+00, 1.7150010578E-01, 1.4393546305E-01, 8.4584012859E-01],
	[4.5790000000E+04, 2.0208953160E+00, 1.6083830022E+00, 1.7155744459E-01, 1.4397761779E-01, 8.4586412214E-01],
	[4.5795000000E+04, 2.0212541542E+00, 1.6083763970E+00, 1.7161479630E-01, 1.4401977880E-01, 8.4588811329E-01],
	[4.5800000000E+04, 2.0216130170E+00, 1.6083697926E+00, 1.7167216092E-01, 1.4406194606E-01, 8.4591210205E-01],
	[4.5805000000E+04, 2.0219719043E+00, 1.6083631890E+00, 1.7172953844E-01, 1.4410411959E-01, 8.4593608843E-01],
	[4.5810000000E+04, 2.0223308160E+00, 1.6083565860E+00, 1.7178692888E-01, 1.4414629937E-01, 8.4596007241E-01],
	[4.5815000000E+04, 2.0226897524E+00, 1.6083499839E+00, 1.7184433224E-01, 1.4418848541E-01, 8.4598405400E-01],
	[4.5820000000E+04, 2.0230487132E+00, 1.6083433825E+00, 1.7190174850E-01, 1.4423067771E-01, 8.4600803321E-01],
	[4.5825000000E+04, 2.0234076986E+00, 1.6083367818E+00, 1.7195917769E-01, 1.4427287627E-01, 8.4603201002E-01],
	[4.5830000000E+04, 2.0237667085E+00, 1.6083301819E+00, 1.7201661979E-01, 1.4431508108E-01, 8.4605598443E-01],
	[4.5835000000E+04, 2.0241257429E+00, 1.6083235827E+00, 1.7207407480E-01, 1.4435729215E-01, 8.4607995646E-01],
	[4.5840000000E+04, 2.0244848018E+00, 1.6083169842E+00, 1.7213154274E-01, 1.4439950947E-01, 8.4610392609E-01],
	[4.5845000000E+04, 2.0248438853E+00, 1.6083103866E+00, 1.7218902360E-01, 1.4444173305E-01, 8.4612789334E-01],
	[4.5850000000E+04, 2.0252029933E+00, 1.6083037896E+00, 1.7224651738E-01, 1.4448396289E-01, 8.4615185818E-01],
	[4.5855000000E+04, 2.0255621258E+00, 1.6082971934E+00, 1.7230402409E-01, 1.4452619897E-01, 8.4617582064E-01],
	[4.5860000000E+04, 2.0259212828E+00, 1.6082905980E+00, 1.7236154372E-01, 1.4456844132E-01, 8.4619978070E-01],
	[4.5865000000E+04, 2.0262804643E+00, 1.6082840033E+00, 1.7241907628E-01, 1.4461068991E-01, 8.4622373837E-01],
	[4.5870000000E+04, 2.0266396704E+00, 1.6082774093E+00, 1.7247662177E-01, 1.4465294475E-01, 8.4624769364E-01],
	[4.5875000000E+04, 2.0269989010E+00, 1.6082708161E+00, 1.7253418019E-01, 1.4469520585E-01, 8.4627164652E-01],
	[4.5880000000E+04, 2.0273581560E+00, 1.6082642236E+00, 1.7259175155E-01, 1.4473747320E-01, 8.4629559700E-01],
	[4.5885000000E+04, 2.0277174356E+00, 1.6082576319E+00, 1.7264933583E-01, 1.4477974679E-01, 8.4631954509E-01],
	[4.5890000000E+04, 2.0280767397E+00, 1.6082510410E+00, 1.7270693305E-01, 1.4482202664E-01, 8.4634349079E-01],
	[4.5895000000E+04, 2.0284360683E+00, 1.6082444507E+00, 1.7276454321E-01, 1.4486431273E-01, 8.4636743408E-01],
	[4.5900000000E+04, 2.0287954215E+00, 1.6082378612E+00, 1.7282216631E-01, 1.4490660508E-01, 8.4639137498E-01],
	[4.5905000000E+04, 2.0291547991E+00, 1.6082312725E+00, 1.7287980234E-01, 1.4494890367E-01, 8.4641531349E-01],
	[4.5910000000E+04, 2.0295142012E+00, 1.6082246845E+00, 1.7293745132E-01, 1.4499120851E-01, 8.4643924960E-01],
	[4.5915000000E+04, 2.0298736279E+00, 1.6082180973E+00, 1.7299511324E-01, 1.4503351959E-01, 8.4646318331E-01],
	[4.5920000000E+04, 2.0302330790E+00, 1.6082115108E+00, 1.7305278810E-01, 1.4507583692E-01, 8.4648711463E-01],
	[4.5925000000E+04, 2.0305925547E+00, 1.6082049250E+00, 1.7311047591E-01, 1.4511816050E-01, 8.4651104354E-01],
	[4.5930000000E+04, 2.0309520548E+00, 1.6081983400E+00, 1.7316817666E-01, 1.4516049032E-01, 8.4653497006E-01],
	[4.5935000000E+04, 2.0313115795E+00, 1.6081917557E+00, 1.7322589037E-01, 1.4520282639E-01, 8.4655889418E-01],
	[4.5940000000E+04, 2.0316711287E+00, 1.6081851722E+00, 1.7328361702E-01, 1.4524516869E-01, 8.4658281591E-01],
	[4.5945000000E+04, 2.0320307023E+00, 1.6081785894E+00, 1.7334135662E-01, 1.4528751725E-01, 8.4660673523E-01],
	[4.5950000000E+04, 2.0323903005E+00, 1.6081720073E+00, 1.7339910918E-01, 1.4532987204E-01, 8.4663065216E-01],
	[4.5955000000E+04, 2.0327499232E+00, 1.6081654260E+00, 1.7345687470E-01, 1.4537223308E-01, 8.4665456668E-01],
	[4.5960000000E+04, 2.0331095703E+00, 1.6081588455E+00, 1.7351465316E-01, 1.4541460036E-01, 8.4667847881E-01],
	[4.5965000000E+04, 2.0334692420E+00, 1.6081522657E+00, 1.7357244459E-01, 1.4545697387E-01, 8.4670238853E-01],
	[4.5970000000E+04, 2.0338289381E+00, 1.6081456866E+00, 1.7363024897E-01, 1.4549935363E-01, 8.4672629586E-01],
	[4.5975000000E+04, 2.0341886588E+00, 1.6081391083E+00, 1.7368806632E-01, 1.4554173963E-01, 8.4675020079E-01],
	[4.5980000000E+04, 2.0345484039E+00, 1.6081325307E+00, 1.7374589663E-01, 1.4558413187E-01, 8.4677410331E-01],
	[4.5985000000E+04, 2.0349081736E+00, 1.6081259538E+00, 1.7380373990E-01, 1.4562653034E-01, 8.4679800344E-01],
	[4.5990000000E+04, 2.0352679677E+00, 1.6081193777E+00, 1.7386159613E-01, 1.4566893505E-01, 8.4682190116E-01],
	[4.5995000000E+04, 2.0356277863E+00, 1.6081128024E+00, 1.7391946534E-01, 1.4571134600E-01, 8.4684579648E-01],
	[4.6000000000E+04, 2.0359876294E+00, 1.6081062278E+00, 1.7397734751E-01, 1.4575376319E-01, 8.4686968940E-01],
	[4.6005000000E+04, 2.0363474970E+00, 1.6080996539E+00, 1.7403524265E-01, 1.4579618661E-01, 8.4689357991E-01],
	[4.6010000000E+04, 2.0367073891E+00, 1.6080930808E+00, 1.7409315076E-01, 1.4583861627E-01, 8.4691746803E-01],
	[4.6015000000E+04, 2.0370673057E+00, 1.6080865084E+00, 1.7415107184E-01, 1.4588105216E-01, 8.4694135374E-01],
	[4.6020000000E+04, 2.0374272467E+00, 1.6080799367E+00, 1.7420900590E-01, 1.4592349429E-01, 8.4696523705E-01],
	[4.6025000000E+04, 2.0377872123E+00, 1.6080733658E+00, 1.7426695293E-01, 1.4596594265E-01, 8.4698911795E-01],
	[4.6030000000E+04, 2.0381472023E+00, 1.6080667956E+00, 1.7432491294E-01, 1.4600839724E-01, 8.4701299645E-01],
	[4.6035000000E+04, 2.0385078890E+00, 1.6080608045E+00, 1.7438288593E-01, 1.4605086628E-01, 8.4703687255E-01],
	[4.6040000000E+04, 2.0388687938E+00, 1.6080549805E+00, 1.7444087189E-01, 1.4609334394E-01, 8.4706074624E-01],
	[4.6045000000E+04, 2.0392297233E+00, 1.6080491572E+00, 1.7449887084E-01, 1.4613582783E-01, 8.4708461753E-01],
	[4.6050000000E+04, 2.0395906776E+00, 1.6080433345E+00, 1.7455688277E-01, 1.4617831796E-01, 8.4710848642E-01],
	[4.6055000000E+04, 2.0399516565E+00, 1.6080375125E+00, 1.7461490769E-01, 1.4622081433E-01, 8.4713235289E-01],
	[4.6060000000E+04, 2.0403126600E+00, 1.6080316911E+00, 1.7467294559E-01, 1.4626331695E-01, 8.4715621697E-01],
	[4.6065000000E+04, 2.0406736883E+00, 1.6080258703E+00, 1.7473099648E-01, 1.4630582580E-01, 8.4718007863E-01],
	[4.6070000000E+04, 2.0410347413E+00, 1.6080200503E+00, 1.7478906036E-01, 1.4634834088E-01, 8.4720393789E-01],
	[4.6075000000E+04, 2.0413958189E+00, 1.6080142308E+00, 1.7484713723E-01, 1.4639086221E-01, 8.4722779475E-01],
	[4.6080000000E+04, 2.0417569213E+00, 1.6080084121E+00, 1.7490522709E-01, 1.4643338977E-01, 8.4725164920E-01],
	[4.6085000000E+04, 2.0421180483E+00, 1.6080025939E+00, 1.7496332994E-01, 1.4647592357E-01, 8.4727550124E-01],
	[4.6090000000E+04, 2.0424792000E+00, 1.6079967765E+00, 1.7502144579E-01, 1.4651846360E-01, 8.4729935087E-01],
	[4.6095000000E+04, 2.0428403764E+00, 1.6079909596E+00, 1.7507957464E-01, 1.4656100987E-01, 8.4732319810E-01],
	[4.6100000000E+04, 2.0432015775E+00, 1.6079851435E+00, 1.7513771648E-01, 1.4660356237E-01, 8.4734704292E-01],
	[4.6105000000E+04, 2.0435628032E+00, 1.6079793280E+00, 1.7519587132E-01, 1.4664612110E-01, 8.4737088533E-01],
	[4.6110000000E+04, 2.0439240537E+00, 1.6079735131E+00, 1.7525403917E-01, 1.4668868607E-01, 8.4739472533E-01],
	[4.6115000000E+04, 2.0442853288E+00, 1.6079676989E+00, 1.7531222001E-01, 1.4673125727E-01, 8.4741856292E-01],
	[4.6120000000E+04, 2.0446466286E+00, 1.6079618853E+00, 1.7537041386E-01, 1.4677383470E-01, 8.4744239811E-01],
	[4.6125000000E+04, 2.0450079530E+00, 1.6079560724E+00, 1.7542862072E-01, 1.4681641837E-01, 8.4746623088E-01],
	[4.6130000000E+04, 2.0453693022E+00, 1.6079502602E+00, 1.7548684058E-01, 1.4685900826E-01, 8.4749006125E-01],
	[4.6135000000E+04, 2.0457306760E+00, 1.6079444486E+00, 1.7554507345E-01, 1.4690160439E-01, 8.4751388920E-01],
	[4.6140000000E+04, 2.0460920745E+00, 1.6079386376E+00, 1.7560331933E-01, 1.4694420674E-01, 8.4753771475E-01],
	[4.6145000000E+04, 2.0464534977E+00, 1.6079328273E+00, 1.7566157822E-01, 1.4698681532E-01, 8.4756153788E-01],
	[4.6150000000E+04, 2.0468149455E+00, 1.6079270176E+00, 1.7571985012E-01, 1.4702943013E-01, 8.4758535860E-01],
	[4.6155000000E+04, 2.0471764180E+00, 1.6079212086E+00, 1.7577813504E-01, 1.4707205117E-01, 8.4760917692E-01],
	[4.6160000000E+04, 2.0475379152E+00, 1.6079154003E+00, 1.7583643298E-01, 1.4711467844E-01, 8.4763299282E-01],
	[4.6165000000E+04, 2.0478994370E+00, 1.6079095926E+00, 1.7589474393E-01, 1.4715731193E-01, 8.4765680630E-01],
	[4.6170000000E+04, 2.0482609836E+00, 1.6079037855E+00, 1.7595306790E-01, 1.4719995164E-01, 8.4768061738E-01],
	[4.6175000000E+04, 2.0486225547E+00, 1.6078979791E+00, 1.7601140489E-01, 1.4724259759E-01, 8.4770442604E-01],
	[4.6180000000E+04, 2.0489841506E+00, 1.6078921734E+00, 1.7606975490E-01, 1.4728524975E-01, 8.4772823229E-01],
	[4.6185000000E+04, 2.0493457711E+00, 1.6078863683E+00, 1.7612811794E-01, 1.4732790814E-01, 8.4775203613E-01],
	[4.6190000000E+04, 2.0497074163E+00, 1.6078805638E+00, 1.7618649400E-01, 1.4737057276E-01, 8.4777583755E-01],
	[4.6195000000E+04, 2.0500690861E+00, 1.6078747600E+00, 1.7624488308E-01, 1.4741324360E-01, 8.4779963656E-01],
	[4.6200000000E+04, 2.0504307806E+00, 1.6078689568E+00, 1.7630328520E-01, 1.4745592065E-01, 8.4782343315E-01],
	[4.6205000000E+04, 2.0507924998E+00, 1.6078631543E+00, 1.7636170034E-01, 1.4749860394E-01, 8.4784722733E-01],
	[4.6210000000E+04, 2.0511542436E+00, 1.6078573525E+00, 1.7642012852E-01, 1.4754129344E-01, 8.4787101909E-01],
	[4.6215000000E+04, 2.0515160121E+00, 1.6078515513E+00, 1.7647856972E-01, 1.4758398916E-01, 8.4789480844E-01],
	[4.6220000000E+04, 2.0518778053E+00, 1.6078457507E+00, 1.7653702396E-01, 1.4762669110E-01, 8.4791859537E-01],
	[4.6225000000E+04, 2.0522396231E+00, 1.6078399508E+00, 1.7659549124E-01, 1.4766939926E-01, 8.4794237989E-01],
	[4.6230000000E+04, 2.0526014655E+00, 1.6078341515E+00, 1.7665397155E-01, 1.4771211364E-01, 8.4796616199E-01],
	[4.6235000000E+04, 2.0529633326E+00, 1.6078283529E+00, 1.7671246490E-01, 1.4775483424E-01, 8.4798994167E-01],
	[4.6240000000E+04, 2.0533252244E+00, 1.6078225549E+00, 1.7677097129E-01, 1.4779756105E-01, 8.4801371894E-01],
	[4.6245000000E+04, 2.0536871408E+00, 1.6078167576E+00, 1.7682949073E-01, 1.4784029408E-01, 8.4803749379E-01],
	[4.6250000000E+04, 2.0540490819E+00, 1.6078109610E+00, 1.7688802320E-01, 1.4788303333E-01, 8.4806126622E-01],
	[4.6255000000E+04, 2.0544110476E+00, 1.6078051649E+00, 1.7694656872E-01, 1.4792577880E-01, 8.4808503623E-01],
	[4.6260000000E+04, 2.0547730380E+00, 1.6077993695E+00, 1.7700512728E-01, 1.4796853047E-01, 8.4810880383E-01],
	[4.6265000000E+04, 2.0551350530E+00, 1.6077935748E+00, 1.7706369890E-01, 1.4801128837E-01, 8.4813256900E-01],
	[4.6270000000E+04, 2.0554970927E+00, 1.6077877807E+00, 1.7712228356E-01, 1.4805405247E-01, 8.4815633176E-01],
	[4.6275000000E+04, 2.0558591570E+00, 1.6077819873E+00, 1.7718088127E-01, 1.4809682279E-01, 8.4818009210E-01],
	[4.6280000000E+04, 2.0562212460E+00, 1.6077761945E+00, 1.7723949203E-01, 1.4813959932E-01, 8.4820385001E-01],
	[4.6285000000E+04, 2.0565833596E+00, 1.6077704024E+00, 1.7729811585E-01, 1.4818238206E-01, 8.4822760551E-01],
	[4.6290000000E+04, 2.0569454979E+00, 1.6077646109E+00, 1.7735675272E-01, 1.4822517102E-01, 8.4825135859E-01],
	[4.6295000000E+04, 2.0573076608E+00, 1.6077588200E+00, 1.7741540264E-01, 1.4826796618E-01, 8.4827510924E-01],
	[4.6300000000E+04, 2.0576698483E+00, 1.6077530298E+00, 1.7747406563E-01, 1.4831076756E-01, 8.4829885748E-01],
	[4.6305000000E+04, 2.0580320605E+00, 1.6077472402E+00, 1.7753274167E-01, 1.4835357514E-01, 8.4832260329E-01],
	[4.6310000000E+04, 2.0583942973E+00, 1.6077414513E+00, 1.7759143078E-01, 1.4839638894E-01, 8.4834634668E-01],
	[4.6315000000E+04, 2.0587565588E+00, 1.6077356631E+00, 1.7765013294E-01, 1.4843920894E-01, 8.4837008765E-01],
	[4.6320000000E+04, 2.0591188449E+00, 1.6077298754E+00, 1.7770884817E-01, 1.4848203515E-01, 8.4839382620E-01],
	[4.6325000000E+04, 2.0594811556E+00, 1.6077240885E+00, 1.7776757647E-01, 1.4852486756E-01, 8.4841756233E-01],
	[4.6330000000E+04, 2.0598434910E+00, 1.6077183021E+00, 1.7782631783E-01, 1.4856770619E-01, 8.4844129603E-01],
	[4.6335000000E+04, 2.0602058510E+00, 1.6077125165E+00, 1.7788507226E-01, 1.4861055101E-01, 8.4846502731E-01],
	[4.6340000000E+04, 2.0605682357E+00, 1.6077067314E+00, 1.7794383976E-01, 1.4865340205E-01, 8.4848875616E-01],
	[4.6345000000E+04, 2.0609306449E+00, 1.6077009470E+00, 1.7800262033E-01, 1.4869625928E-01, 8.4851248259E-01],
	[4.6350000000E+04, 2.0612930788E+00, 1.6076951633E+00, 1.7806141398E-01, 1.4873912273E-01, 8.4853620660E-01],
	[4.6355000000E+04, 2.0616555374E+00, 1.6076893802E+00, 1.7812022070E-01, 1.4878199237E-01, 8.4855992818E-01],
	[4.6360000000E+04, 2.0620180206E+00, 1.6076835977E+00, 1.7817904049E-01, 1.4882486822E-01, 8.4858364734E-01],
	[4.6365000000E+04, 2.0623805284E+00, 1.6076778159E+00, 1.7823787336E-01, 1.4886775027E-01, 8.4860736407E-01],
	[4.6370000000E+04, 2.0627430608E+00, 1.6076720347E+00, 1.7829671931E-01, 1.4891063852E-01, 8.4863107838E-01],
	[4.6375000000E+04, 2.0631056179E+00, 1.6076662542E+00, 1.7835557834E-01, 1.4895353297E-01, 8.4865479026E-01],
	[4.6380000000E+04, 2.0634681996E+00, 1.6076604743E+00, 1.7841445045E-01, 1.4899643362E-01, 8.4867849971E-01],
	[4.6385000000E+04, 2.0638308059E+00, 1.6076546951E+00, 1.7847333565E-01, 1.4903934047E-01, 8.4870220674E-01],
	[4.6390000000E+04, 2.0641934368E+00, 1.6076489165E+00, 1.7853223393E-01, 1.4908225352E-01, 8.4872591134E-01],
	[4.6395000000E+04, 2.0645560924E+00, 1.6076431385E+00, 1.7859114529E-01, 1.4912517277E-01, 8.4874961352E-01],
	[4.6400000000E+04, 2.0649187726E+00, 1.6076373612E+00, 1.7865006974E-01, 1.4916809822E-01, 8.4877331326E-01],
	[4.6405000000E+04, 2.0652814774E+00, 1.6076315845E+00, 1.7870900729E-01, 1.4921102986E-01, 8.4879701058E-01],
	[4.6410000000E+04, 2.0656442068E+00, 1.6076258085E+00, 1.7876795792E-01, 1.4925396770E-01, 8.4882070547E-01],
	[4.6415000000E+04, 2.0660069609E+00, 1.6076200331E+00, 1.7882692164E-01, 1.4929691174E-01, 8.4884439793E-01],
	[4.6420000000E+04, 2.0663697395E+00, 1.6076142584E+00, 1.7888589846E-01, 1.4933986197E-01, 8.4886808797E-01],
	[4.6425000000E+04, 2.0667325428E+00, 1.6076084843E+00, 1.7894488838E-01, 1.4938281840E-01, 8.4889177557E-01],
	[4.6430000000E+04, 2.0670953707E+00, 1.6076027108E+00, 1.7900389139E-01, 1.4942578102E-01, 8.4891546075E-01],
	[4.6435000000E+04, 2.0674582232E+00, 1.6075969380E+00, 1.7906290750E-01, 1.4946874983E-01, 8.4893914349E-01],
	[4.6440000000E+04, 2.0678211004E+00, 1.6075911659E+00, 1.7912193670E-01, 1.4951172484E-01, 8.4896282380E-01],
	[4.6445000000E+04, 2.0681840021E+00, 1.6075853943E+00, 1.7918097901E-01, 1.4955470604E-01, 8.4898650169E-01],
	[4.6450000000E+04, 2.0685469285E+00, 1.6075796235E+00, 1.7924003443E-01, 1.4959769343E-01, 8.4901017714E-01],
	[4.6455000000E+04, 2.0689098794E+00, 1.6075738532E+00, 1.7929910294E-01, 1.4964068701E-01, 8.4903385017E-01],
	[4.6460000000E+04, 2.0692728550E+00, 1.6075680836E+00, 1.7935818456E-01, 1.4968368678E-01, 8.4905752076E-01],
	[4.6465000000E+04, 2.0696358552E+00, 1.6075623147E+00, 1.7941727929E-01, 1.4972669274E-01, 8.4908118892E-01],
	[4.6470000000E+04, 2.0699988800E+00, 1.6075565463E+00, 1.7947638713E-01, 1.4976970489E-01, 8.4910485464E-01],
	[4.6475000000E+04, 2.0703619294E+00, 1.6075507787E+00, 1.7953550808E-01, 1.4981272323E-01, 8.4912851794E-01],
	[4.6480000000E+04, 2.0707250034E+00, 1.6075450116E+00, 1.7959464214E-01, 1.4985574776E-01, 8.4915217880E-01],
	[4.6485000000E+04, 2.0710881021E+00, 1.6075392452E+00, 1.7965378931E-01, 1.4989877847E-01, 8.4917583723E-01],
	[4.6490000000E+04, 2.0714512253E+00, 1.6075334795E+00, 1.7971294960E-01, 1.4994181537E-01, 8.4919949323E-01],
	[4.6495000000E+04, 2.0718143731E+00, 1.6075277144E+00, 1.7977212300E-01, 1.4998485846E-01, 8.4922314679E-01],
	[4.6500000000E+04, 2.0721775456E+00, 1.6075219499E+00, 1.7983130952E-01, 1.5002790773E-01, 8.4924679792E-01],
	[4.6505000000E+04, 2.0725407426E+00, 1.6075161861E+00, 1.7989050916E-01, 1.5007096319E-01, 8.4927044662E-01],
	[4.6510000000E+04, 2.0729039643E+00, 1.6075104229E+00, 1.7994972192E-01, 1.5011402483E-01, 8.4929409288E-01],
	[4.6515000000E+04, 2.0732672105E+00, 1.6075046603E+00, 1.8000894780E-01, 1.5015709265E-01, 8.4931773670E-01],
	[4.6520000000E+04, 2.0736304813E+00, 1.6074988984E+00, 1.8006818681E-01, 1.5020016666E-01, 8.4934137810E-01],
	[4.6525000000E+04, 2.0739937768E+00, 1.6074931372E+00, 1.8012743894E-01, 1.5024324685E-01, 8.4936501705E-01],
	[4.6530000000E+04, 2.0743570968E+00, 1.6074873765E+00, 1.8018670419E-01, 1.5028633322E-01, 8.4938865357E-01],
	[4.6535000000E+04, 2.0747204414E+00, 1.6074816165E+00, 1.8024598258E-01, 1.5032942577E-01, 8.4941228765E-01],
	[4.6540000000E+04, 2.0750838107E+00, 1.6074758572E+00, 1.8030527410E-01, 1.5037252450E-01, 8.4943591930E-01],
	[4.6545000000E+04, 2.0754472045E+00, 1.6074700985E+00, 1.8036457874E-01, 1.5041562941E-01, 8.4945954851E-01],
	[4.6550000000E+04, 2.0758106229E+00, 1.6074643404E+00, 1.8042389652E-01, 1.5045874050E-01, 8.4948317529E-01],
	[4.6555000000E+04, 2.0761740659E+00, 1.6074585830E+00, 1.8048322743E-01, 1.5050185777E-01, 8.4950679962E-01],
	[4.6560000000E+04, 2.0765375335E+00, 1.6074528262E+00, 1.8054257148E-01, 1.5054498122E-01, 8.4953042152E-01],
	[4.6565000000E+04, 2.0769010257E+00, 1.6074470700E+00, 1.8060192867E-01, 1.5058811084E-01, 8.4955404099E-01],
	[4.6570000000E+04, 2.0772645425E+00, 1.6074413145E+00, 1.8066129899E-01, 1.5063124665E-01, 8.4957765801E-01],
	[4.6575000000E+04, 2.0776280839E+00, 1.6074355596E+00, 1.8072068245E-01, 1.5067438862E-01, 8.4960127259E-01],
	[4.6580000000E+04, 2.0779916498E+00, 1.6074298054E+00, 1.8078007906E-01, 1.5071753678E-01, 8.4962488474E-01],
	[4.6585000000E+04, 2.0783552403E+00, 1.6074240518E+00, 1.8083948881E-01, 1.5076069110E-01, 8.4964849445E-01],
	[4.6590000000E+04, 2.0787188555E+00, 1.6074182988E+00, 1.8089891170E-01, 1.5080385160E-01, 8.4967210171E-01],
	[4.6595000000E+04, 2.0790824952E+00, 1.6074125465E+00, 1.8095834774E-01, 1.5084701828E-01, 8.4969570654E-01],
	[4.6600000000E+04, 2.0794461595E+00, 1.6074067948E+00, 1.8101779693E-01, 1.5089019113E-01, 8.4971930893E-01],
	[4.6605000000E+04, 2.0798098484E+00, 1.6074010438E+00, 1.8107725926E-01, 1.5093337015E-01, 8.4974290888E-01],
	[4.6610000000E+04, 2.0801735618E+00, 1.6073952933E+00, 1.8113673475E-01, 1.5097655534E-01, 8.4976650638E-01],
	[4.6615000000E+04, 2.0805372999E+00, 1.6073895436E+00, 1.8119622339E-01, 1.5101974670E-01, 8.4979010145E-01],
	[4.6620000000E+04, 2.0809010625E+00, 1.6073837944E+00, 1.8125572518E-01, 1.5106294423E-01, 8.4981369407E-01],
	[4.6625000000E+04, 2.0812648497E+00, 1.6073780459E+00, 1.8131524012E-01, 1.5110614793E-01, 8.4983728426E-01],
	[4.6630000000E+04, 2.0816286615E+00, 1.6073722981E+00, 1.8137476823E-01, 1.5114935781E-01, 8.4986087200E-01],
	[4.6635000000E+04, 2.0819924978E+00, 1.6073665508E+00, 1.8143430949E-01, 1.5119257385E-01, 8.4988445730E-01],
	[4.6640000000E+04, 2.0823563587E+00, 1.6073608043E+00, 1.8149386391E-01, 1.5123579605E-01, 8.4990804015E-01],
	[4.6645000000E+04, 2.0827202443E+00, 1.6073550583E+00, 1.8155343149E-01, 1.5127902443E-01, 8.4993162057E-01],
	[4.6650000000E+04, 2.0830841543E+00, 1.6073493130E+00, 1.8161301224E-01, 1.5132225897E-01, 8.4995519854E-01],
	[4.6655000000E+04, 2.0834480890E+00, 1.6073435683E+00, 1.8167260614E-01, 1.5136549968E-01, 8.4997877407E-01],
	[4.6660000000E+04, 2.0838120482E+00, 1.6073378243E+00, 1.8173221322E-01, 1.5140874655E-01, 8.5000234715E-01],
	[4.6665000000E+04, 2.0841760320E+00, 1.6073320808E+00, 1.8179183346E-01, 1.5145199959E-01, 8.5002591779E-01],
	[4.6670000000E+04, 2.0845400404E+00, 1.6073263381E+00, 1.8185146687E-01, 1.5149525879E-01, 8.5004948599E-01],
	[4.6675000000E+04, 2.0849040733E+00, 1.6073205959E+00, 1.8191111345E-01, 1.5153852415E-01, 8.5007305174E-01],
	[4.6680000000E+04, 2.0852681308E+00, 1.6073148544E+00, 1.8197077320E-01, 1.5158179568E-01, 8.5009661504E-01],
	[4.6685000000E+04, 2.0856322129E+00, 1.6073091136E+00, 1.8203044612E-01, 1.5162507337E-01, 8.5012017591E-01],
	[4.6690000000E+04, 2.0859963195E+00, 1.6073033733E+00, 1.8209013222E-01, 1.5166835722E-01, 8.5014373432E-01],
	[4.6695000000E+04, 2.0863604507E+00, 1.6072976337E+00, 1.8214983149E-01, 1.5171164723E-01, 8.5016729029E-01],
	[4.6700000000E+04, 2.0867246065E+00, 1.6072918948E+00, 1.8220954394E-01, 1.5175494340E-01, 8.5019084382E-01],
	[4.6705000000E+04, 2.0870887868E+00, 1.6072861565E+00, 1.8226926957E-01, 1.5179824574E-01, 8.5021439489E-01],
	[4.6710000000E+04, 2.0874529917E+00, 1.6072804188E+00, 1.8232900839E-01, 1.5184155423E-01, 8.5023794352E-01],
	[4.6715000000E+04, 2.0878172211E+00, 1.6072746817E+00, 1.8238876038E-01, 1.5188486888E-01, 8.5026148971E-01],
	[4.6720000000E+04, 2.0881814752E+00, 1.6072689453E+00, 1.8244852555E-01, 1.5192818968E-01, 8.5028503345E-01],
	[4.6725000000E+04, 2.0885457537E+00, 1.6072632095E+00, 1.8250830392E-01, 1.5197151665E-01, 8.5030857473E-01],
	[4.6730000000E+04, 2.0889100569E+00, 1.6072574743E+00, 1.8256809546E-01, 1.5201484977E-01, 8.5033211358E-01],
	[4.6735000000E+04, 2.0892743845E+00, 1.6072517398E+00, 1.8262790020E-01, 1.5205818904E-01, 8.5035564997E-01],
	[4.6740000000E+04, 2.0896387368E+00, 1.6072460059E+00, 1.8268771812E-01, 1.5210153447E-01, 8.5037918391E-01],
	[4.6745000000E+04, 2.0900031136E+00, 1.6072402727E+00, 1.8274754924E-01, 1.5214488606E-01, 8.5040271541E-01],
	[4.6750000000E+04, 2.0903675149E+00, 1.6072345401E+00, 1.8280739355E-01, 1.5218824380E-01, 8.5042624446E-01],
	[4.6755000000E+04, 2.0907319408E+00, 1.6072288081E+00, 1.8286725105E-01, 1.5223160769E-01, 8.5044977106E-01],
	[4.6760000000E+04, 2.0910963913E+00, 1.6072230767E+00, 1.8292712175E-01, 1.5227497773E-01, 8.5047329520E-01],
	[4.6765000000E+04, 2.0914608663E+00, 1.6072173460E+00, 1.8298700564E-01, 1.5231835393E-01, 8.5049681690E-01],
	[4.6770000000E+04, 2.0918253659E+00, 1.6072116159E+00, 1.8304690274E-01, 1.5236173628E-01, 8.5052033615E-01],
	[4.6775000000E+04, 2.0921904051E+00, 1.6072063040E+00, 1.8310681303E-01, 1.5240513126E-01, 8.5054385295E-01],
	[4.6780000000E+04, 2.0925558593E+00, 1.6072013090E+00, 1.8316673653E-01, 1.5244853732E-01, 8.5056736729E-01],
	[4.6785000000E+04, 2.0929213383E+00, 1.6071963145E+00, 1.8322667322E-01, 1.5249194954E-01, 8.5059087919E-01],
	[4.6790000000E+04, 2.0932868421E+00, 1.6071913206E+00, 1.8328662313E-01, 1.5253536792E-01, 8.5061438863E-01],
	[4.6795000000E+04, 2.0936523706E+00, 1.6071863272E+00, 1.8334658623E-01, 1.5257879246E-01, 8.5063789563E-01],
	[4.6800000000E+04, 2.0940179239E+00, 1.6071813344E+00, 1.8340656255E-01, 1.5262222315E-01, 8.5066140017E-01],
	[4.6805000000E+04, 2.0943835020E+00, 1.6071763422E+00, 1.8346655207E-01, 1.5266566001E-01, 8.5068490226E-01],
	[4.6810000000E+04, 2.0947491048E+00, 1.6071713505E+00, 1.8352655481E-01, 1.5270910301E-01, 8.5070840189E-01],
	[4.6815000000E+04, 2.0951147324E+00, 1.6071663593E+00, 1.8358657076E-01, 1.5275255218E-01, 8.5073189908E-01],
	[4.6820000000E+04, 2.0954803848E+00, 1.6071613687E+00, 1.8364659992E-01, 1.5279600750E-01, 8.5075539381E-01],
	[4.6825000000E+04, 2.0958460619E+00, 1.6071563786E+00, 1.8370664229E-01, 1.5283946897E-01, 8.5077888608E-01],
	[4.6830000000E+04, 2.0962117637E+00, 1.6071513891E+00, 1.8376669788E-01, 1.5288293660E-01, 8.5080237591E-01],
	[4.6835000000E+04, 2.0965774904E+00, 1.6071464001E+00, 1.8382676669E-01, 1.5292641038E-01, 8.5082586327E-01],
	[4.6840000000E+04, 2.0969432417E+00, 1.6071414117E+00, 1.8388684872E-01, 1.5296989031E-01, 8.5084934819E-01],
	[4.6845000000E+04, 2.0973090179E+00, 1.6071364238E+00, 1.8394694397E-01, 1.5301337639E-01, 8.5087283065E-01],
	[4.6850000000E+04, 2.0976748188E+00, 1.6071314365E+00, 1.8400705244E-01, 1.5305686863E-01, 8.5089631066E-01],
	[4.6855000000E+04, 2.0980406444E+00, 1.6071264497E+00, 1.8406717414E-01, 1.5310036701E-01, 8.5091978821E-01],
	[4.6860000000E+04, 2.0984064948E+00, 1.6071214635E+00, 1.8412730906E-01, 1.5314387155E-01, 8.5094326330E-01],
	[4.6865000000E+04, 2.0987723700E+00, 1.6071164778E+00, 1.8418745721E-01, 1.5318738224E-01, 8.5096673594E-01],
	[4.6870000000E+04, 2.0991382698E+00, 1.6071114927E+00, 1.8424761858E-01, 1.5323089907E-01, 8.5099020612E-01],
	[4.6875000000E+04, 2.0995041945E+00, 1.6071065081E+00, 1.8430779319E-01, 1.5327442205E-01, 8.5101367385E-01],
	[4.6880000000E+04, 2.0998701439E+00, 1.6071015240E+00, 1.8436798103E-01, 1.5331795118E-01, 8.5103713912E-01],
	[4.6885000000E+04, 2.1002361180E+00, 1.6070965405E+00, 1.8442818210E-01, 1.5336148646E-01, 8.5106060193E-01],
	[4.6890000000E+04, 2.1006021169E+00, 1.6070915576E+00, 1.8448839640E-01, 1.5340502788E-01, 8.5108406229E-01],
	[4.6895000000E+04, 2.1009681406E+00, 1.6070865752E+00, 1.8454862394E-01, 1.5344857545E-01, 8.5110752019E-01],
	[4.6900000000E+04, 2.1013341889E+00, 1.6070815933E+00, 1.8460886472E-01, 1.5349212916E-01, 8.5113097563E-01],
	[4.6905000000E+04, 2.1017002621E+00, 1.6070766120E+00, 1.8466911874E-01, 1.5353568902E-01, 8.5115442861E-01],
	[4.6910000000E+04, 2.1020663599E+00, 1.6070716313E+00, 1.8472938600E-01, 1.5357925502E-01, 8.5117787914E-01],
	[4.6915000000E+04, 2.1024324825E+00, 1.6070666511E+00, 1.8478966650E-01, 1.5362282716E-01, 8.5120132720E-01],
	[4.6920000000E+04, 2.1027986299E+00, 1.6070616714E+00, 1.8484996024E-01, 1.5366640545E-01, 8.5122477281E-01],
	[4.6925000000E+04, 2.1031648020E+00, 1.6070566923E+00, 1.8491026723E-01, 1.5370998987E-01, 8.5124821596E-01],
	[4.6930000000E+04, 2.1035309988E+00, 1.6070517137E+00, 1.8497058746E-01, 1.5375358044E-01, 8.5127165665E-01],
	[4.6935000000E+04, 2.1038972203E+00, 1.6070467357E+00, 1.8503092094E-01, 1.5379717715E-01, 8.5129509488E-01],
	[4.6940000000E+04, 2.1042634666E+00, 1.6070417582E+00, 1.8509126767E-01, 1.5384078000E-01, 8.5131853065E-01],
	[4.6945000000E+04, 2.1046297377E+00, 1.6070367812E+00, 1.8515162766E-01, 1.5388438899E-01, 8.5134196396E-01],
	[4.6950000000E+04, 2.1049960335E+00, 1.6070318048E+00, 1.8521200089E-01, 1.5392800411E-01, 8.5136539480E-01],
	[4.6955000000E+04, 2.1053623540E+00, 1.6070268290E+00, 1.8527238738E-01, 1.5397162538E-01, 8.5138882319E-01],
	[4.6960000000E+04, 2.1057286992E+00, 1.6070218537E+00, 1.8533278712E-01, 1.5401525278E-01, 8.5141224912E-01],
	[4.6965000000E+04, 2.1060950692E+00, 1.6070168789E+00, 1.8539320012E-01, 1.5405888631E-01, 8.5143567258E-01],
	[4.6970000000E+04, 2.1064614639E+00, 1.6070119047E+00, 1.8545362638E-01, 1.5410252599E-01, 8.5145909359E-01],
	[4.6975000000E+04, 2.1068278833E+00, 1.6070069310E+00, 1.8551406590E-01, 1.5414617179E-01, 8.5148251213E-01],
	[4.6980000000E+04, 2.1071943275E+00, 1.6070019579E+00, 1.8557451868E-01, 1.5418982374E-01, 8.5150592821E-01],
	[4.6985000000E+04, 2.1075607963E+00, 1.6069969853E+00, 1.8563498472E-01, 1.5423348181E-01, 8.5152934182E-01],
	[4.6990000000E+04, 2.1079272900E+00, 1.6069920133E+00, 1.8569546403E-01, 1.5427714602E-01, 8.5155275298E-01],
	[4.6995000000E+04, 2.1082938083E+00, 1.6069870418E+00, 1.8575595660E-01, 1.5432081636E-01, 8.5157616167E-01],
	[4.7000000000E+04, 2.1086603514E+00, 1.6069820709E+00, 1.8581646244E-01, 1.5436449284E-01, 8.5159956790E-01],
	[4.7005000000E+04, 2.1090269192E+00, 1.6069771005E+00, 1.8587698155E-01, 1.5440817544E-01, 8.5162297166E-01],
	[4.7010000000E+04, 2.1093935117E+00, 1.6069721306E+00, 1.8593751393E-01, 1.5445186418E-01, 8.5164637296E-01],
	[4.7015000000E+04, 2.1097601289E+00, 1.6069671613E+00, 1.8599805958E-01, 1.5449555905E-01, 8.5166977180E-01],
	[4.7020000000E+04, 2.1101267709E+00, 1.6069621925E+00, 1.8605861851E-01, 1.5453926004E-01, 8.5169316817E-01],
	[4.7025000000E+04, 2.1104934375E+00, 1.6069572243E+00, 1.8611919071E-01, 1.5458296717E-01, 8.5171656207E-01],
	[4.7030000000E+04, 2.1108601289E+00, 1.6069522566E+00, 1.8617977618E-01, 1.5462668042E-01, 8.5173995352E-01],
	[4.7035000000E+04, 2.1112268451E+00, 1.6069472895E+00, 1.8624037494E-01, 1.5467039980E-01, 8.5176334249E-01],
	[4.7040000000E+04, 2.1115935859E+00, 1.6069423229E+00, 1.8630098697E-01, 1.5471412530E-01, 8.5178672900E-01],
	[4.7045000000E+04, 2.1119603514E+00, 1.6069373568E+00, 1.8636161228E-01, 1.5475785694E-01, 8.5181011305E-01],
	[4.7050000000E+04, 2.1123271417E+00, 1.6069323913E+00, 1.8642225088E-01, 1.5480159469E-01, 8.5183349463E-01],
	[4.7055000000E+04, 2.1126939567E+00, 1.6069274263E+00, 1.8648290276E-01, 1.5484533858E-01, 8.5185687374E-01],
	[4.7060000000E+04, 2.1130607964E+00, 1.6069224619E+00, 1.8654356792E-01, 1.5488908858E-01, 8.5188025039E-01],
	[4.7065000000E+04, 2.1134276608E+00, 1.6069174980E+00, 1.8660424638E-01, 1.5493284471E-01, 8.5190362456E-01],
	[4.7070000000E+04, 2.1137945499E+00, 1.6069125347E+00, 1.8666493812E-01, 1.5497660697E-01, 8.5192699628E-01],
	[4.7075000000E+04, 2.1141614637E+00, 1.6069075719E+00, 1.8672564315E-01, 1.5502037534E-01, 8.5195036552E-01],
	[4.7080000000E+04, 2.1145284023E+00, 1.6069026096E+00, 1.8678636147E-01, 1.5506414984E-01, 8.5197373230E-01],
	[4.7085000000E+04, 2.1148953655E+00, 1.6068976479E+00, 1.8684709308E-01, 1.5510793046E-01, 8.5199709661E-01],
	[4.7090000000E+04, 2.1152623535E+00, 1.6068926868E+00, 1.8690783799E-01, 1.5515171719E-01, 8.5202045845E-01],
	[4.7095000000E+04, 2.1156293661E+00, 1.6068877261E+00, 1.8696859619E-01, 1.5519551005E-01, 8.5204381782E-01],
	[4.7100000000E+04, 2.1159964035E+00, 1.6068827661E+00, 1.8702936770E-01, 1.5523930903E-01, 8.5206717472E-01],
	[4.7105000000E+04, 2.1163634656E+00, 1.6068778065E+00, 1.8709015250E-01, 1.5528311412E-01, 8.5209052915E-01],
	[4.7110000000E+04, 2.1167305524E+00, 1.6068728475E+00, 1.8715095060E-01, 1.5532692533E-01, 8.5211388112E-01],
	[4.7115000000E+04, 2.1170976638E+00, 1.6068678890E+00, 1.8721176200E-01, 1.5537074266E-01, 8.5213723061E-01],
	[4.7120000000E+04, 2.1174648000E+00, 1.6068629311E+00, 1.8727258670E-01, 1.5541456611E-01, 8.5216057764E-01],
	[4.7125000000E+04, 2.1178319609E+00, 1.6068579738E+00, 1.8733342471E-01, 1.5545839567E-01, 8.5218392219E-01],
	[4.7130000000E+04, 2.1181991465E+00, 1.6068530169E+00, 1.8739427603E-01, 1.5550223135E-01, 8.5220726428E-01],
	[4.7135000000E+04, 2.1185663568E+00, 1.6068480606E+00, 1.8745514066E-01, 1.5554607314E-01, 8.5223060389E-01],
	[4.7140000000E+04, 2.1189335918E+00, 1.6068431049E+00, 1.8751601859E-01, 1.5558992104E-01, 8.5225394103E-01],
	[4.7145000000E+04, 2.1193008515E+00, 1.6068381497E+00, 1.8757690983E-01, 1.5563377506E-01, 8.5227727570E-01],
	[4.7150000000E+04, 2.1196681358E+00, 1.6068331950E+00, 1.8763781439E-01, 1.5567763519E-01, 8.5230060790E-01],
	[4.7155000000E+04, 2.1200354449E+00, 1.6068282409E+00, 1.8769873226E-01, 1.5572150143E-01, 8.5232393763E-01],
	[4.7160000000E+04, 2.1204027787E+00, 1.6068232873E+00, 1.8775966345E-01, 1.5576537378E-01, 8.5234726489E-01],
	[4.7165000000E+04, 2.1207701371E+00, 1.6068183342E+00, 1.8782060795E-01, 1.5580925224E-01, 8.5237058967E-01],
	[4.7170000000E+04, 2.1211375203E+00, 1.6068133817E+00, 1.8788156577E-01, 1.5585313681E-01, 8.5239391198E-01],
	[4.7175000000E+04, 2.1215049281E+00, 1.6068084297E+00, 1.8794253691E-01, 1.5589702750E-01, 8.5241723182E-01],
	[4.7180000000E+04, 2.1218723607E+00, 1.6068034783E+00, 1.8800352137E-01, 1.5594092429E-01, 8.5244054919E-01],
	[4.7185000000E+04, 2.1222398179E+00, 1.6067985274E+00, 1.8806451916E-01, 1.5598482718E-01, 8.5246386408E-01],
	[4.7190000000E+04, 2.1226072998E+00, 1.6067935771E+00, 1.8812553027E-01, 1.5602873619E-01, 8.5248717650E-01],
	[4.7195000000E+04, 2.1229748064E+00, 1.6067886272E+00, 1.8818655470E-01, 1.5607265130E-01, 8.5251048644E-01],
	[4.7200000000E+04, 2.1233423377E+00, 1.6067836780E+00, 1.8824759246E-01, 1.5611657252E-01, 8.5253379391E-01],
	[4.7205000000E+04, 2.1237098937E+00, 1.6067787292E+00, 1.8830864355E-01, 1.5616049984E-01, 8.5255709891E-01],
	[4.7210000000E+04, 2.1240774743E+00, 1.6067737811E+00, 1.8836970797E-01, 1.5620443326E-01, 8.5258040143E-01],
	[4.7215000000E+04, 2.1244450797E+00, 1.6067688334E+00, 1.8843078573E-01, 1.5624837279E-01, 8.5260370147E-01],
	[4.7220000000E+04, 2.1248127097E+00, 1.6067638863E+00, 1.8849187681E-01, 1.5629231843E-01, 8.5262699904E-01],
	[4.7225000000E+04, 2.1251803644E+00, 1.6067589397E+00, 1.8855298123E-01, 1.5633627016E-01, 8.5265029414E-01],
	[4.7230000000E+04, 2.1255480438E+00, 1.6067539937E+00, 1.8861409899E-01, 1.5638022800E-01, 8.5267358676E-01],
	[4.7235000000E+04, 2.1259157479E+00, 1.6067490482E+00, 1.8867523008E-01, 1.5642419194E-01, 8.5269687690E-01],
	[4.7240000000E+04, 2.1262834766E+00, 1.6067441032E+00, 1.8873637452E-01, 1.5646816198E-01, 8.5272016457E-01],
	[4.7245000000E+04, 2.1266512300E+00, 1.6067391588E+00, 1.8879753229E-01, 1.5651213812E-01, 8.5274344976E-01],
	[4.7250000000E+04, 2.1270190081E+00, 1.6067342149E+00, 1.8885870341E-01, 1.5655612036E-01, 8.5276673247E-01],
	[4.7255000000E+04, 2.1273868109E+00, 1.6067292716E+00, 1.8891988787E-01, 1.5660010869E-01, 8.5279001271E-01],
	[4.7260000000E+04, 2.1277546384E+00, 1.6067243288E+00, 1.8898108568E-01, 1.5664410313E-01, 8.5281329047E-01],
	[4.7265000000E+04, 2.1281224905E+00, 1.6067193865E+00, 1.8904229683E-01, 1.5668810366E-01, 8.5283656575E-01],
	[4.7270000000E+04, 2.1284903673E+00, 1.6067144448E+00, 1.8910352133E-01, 1.5673211029E-01, 8.5285983855E-01],
	[4.7275000000E+04, 2.1288582688E+00, 1.6067095036E+00, 1.8916475918E-01, 1.5677612301E-01, 8.5288310888E-01],
	[4.7280000000E+04, 2.1292261949E+00, 1.6067045629E+00, 1.8922601038E-01, 1.5682014183E-01, 8.5290637672E-01],
	[4.7285000000E+04, 2.1295941458E+00, 1.6066996228E+00, 1.8928727494E-01, 1.5686416675E-01, 8.5292964209E-01],
	[4.7290000000E+04, 2.1299621212E+00, 1.6066946832E+00, 1.8934855285E-01, 1.5690819775E-01, 8.5295290498E-01],
	[4.7295000000E+04, 2.1303301214E+00, 1.6066897442E+00, 1.8940984411E-01, 1.5695223485E-01, 8.5297616539E-01],
	[4.7300000000E+04, 2.1306981462E+00, 1.6066848057E+00, 1.8947114873E-01, 1.5699627805E-01, 8.5299942332E-01],
	[4.7305000000E+04, 2.1310661957E+00, 1.6066798677E+00, 1.8953246671E-01, 1.5704032733E-01, 8.5302267878E-01],
	[4.7310000000E+04, 2.1314342699E+00, 1.6066749303E+00, 1.8959379805E-01, 1.5708438271E-01, 8.5304593175E-01],
	[4.7315000000E+04, 2.1318023687E+00, 1.6066699934E+00, 1.8965514275E-01, 1.5712844418E-01, 8.5306918224E-01],
	[4.7320000000E+04, 2.1321704922E+00, 1.6066650571E+00, 1.8971650082E-01, 1.5717251173E-01, 8.5309243025E-01],
	[4.7325000000E+04, 2.1325386403E+00, 1.6066601212E+00, 1.8977787225E-01, 1.5721658538E-01, 8.5311567578E-01],
	[4.7330000000E+04, 2.1329068131E+00, 1.6066551860E+00, 1.8983925705E-01, 1.5726066511E-01, 8.5313891883E-01],
	[4.7335000000E+04, 2.1332750106E+00, 1.6066502512E+00, 1.8990065521E-01, 1.5730475094E-01, 8.5316215940E-01],
	[4.7340000000E+04, 2.1336432328E+00, 1.6066453170E+00, 1.8996206674E-01, 1.5734884285E-01, 8.5318539748E-01],
	[4.7345000000E+04, 2.1340114795E+00, 1.6066403833E+00, 1.9002349165E-01, 1.5739294084E-01, 8.5320863309E-01],
	[4.7350000000E+04, 2.1343797510E+00, 1.6066354502E+00, 1.9008492992E-01, 1.5743704492E-01, 8.5323186621E-01],
	[4.7355000000E+04, 2.1347480471E+00, 1.6066305176E+00, 1.9014638157E-01, 1.5748115509E-01, 8.5325509685E-01],
	[4.7360000000E+04, 2.1351163679E+00, 1.6066255855E+00, 1.9020784660E-01, 1.5752527134E-01, 8.5327832501E-01],
	[4.7365000000E+04, 2.1354847133E+00, 1.6066206540E+00, 1.9026932500E-01, 1.5756939368E-01, 8.5330155069E-01],
	[4.7370000000E+04, 2.1358530834E+00, 1.6066157230E+00, 1.9033081678E-01, 1.5761352210E-01, 8.5332477388E-01],
	[4.7375000000E+04, 2.1362214781E+00, 1.6066107926E+00, 1.9039232194E-01, 1.5765765660E-01, 8.5334799459E-01],
	[4.7380000000E+04, 2.1365898975E+00, 1.6066058626E+00, 1.9045384048E-01, 1.5770179718E-01, 8.5337121282E-01],
	[4.7385000000E+04, 2.1369583415E+00, 1.6066009332E+00, 1.9051537241E-01, 1.5774594385E-01, 8.5339442856E-01],
	[4.7390000000E+04, 2.1373268102E+00, 1.6065960044E+00, 1.9057691771E-01, 1.5779009659E-01, 8.5341764182E-01],
	[4.7395000000E+04, 2.1376953035E+00, 1.6065910761E+00, 1.9063847641E-01, 1.5783425542E-01, 8.5344085259E-01],
	[4.7400000000E+04, 2.1380638215E+00, 1.6065861483E+00, 1.9070004849E-01, 1.5787842032E-01, 8.5346406088E-01],
	[4.7405000000E+04, 2.1384323641E+00, 1.6065812211E+00, 1.9076163396E-01, 1.5792259130E-01, 8.5348726668E-01],
	[4.7410000000E+04, 2.1388009314E+00, 1.6065762943E+00, 1.9082323282E-01, 1.5796676836E-01, 8.5351047000E-01],
	[4.7415000000E+04, 2.1391695233E+00, 1.6065713682E+00, 1.9088484507E-01, 1.5801095150E-01, 8.5353367084E-01],
	[4.7420000000E+04, 2.1395381399E+00, 1.6065664425E+00, 1.9094647071E-01, 1.5805514071E-01, 8.5355686919E-01],
	[4.7425000000E+04, 2.1399067811E+00, 1.6065615174E+00, 1.9100810975E-01, 1.5809933600E-01, 8.5358006505E-01],
	[4.7430000000E+04, 2.1402754469E+00, 1.6065565928E+00, 1.9106976219E-01, 1.5814353737E-01, 8.5360325843E-01],
	[4.7435000000E+04, 2.1406441374E+00, 1.6065516688E+00, 1.9113142802E-01, 1.5818774481E-01, 8.5362644932E-01],
	[4.7440000000E+04, 2.1410128526E+00, 1.6065467453E+00, 1.9119310725E-01, 1.5823195832E-01, 8.5364963772E-01],
	[4.7445000000E+04, 2.1413815923E+00, 1.6065418223E+00, 1.9125479989E-01, 1.5827617790E-01, 8.5367282364E-01],
	[4.7450000000E+04, 2.1417503567E+00, 1.6065368999E+00, 1.9131650592E-01, 1.5832040356E-01, 8.5369600707E-01],
	[4.7455000000E+04, 2.1421191458E+00, 1.6065319780E+00, 1.9137822536E-01, 1.5836463529E-01, 8.5371918802E-01],
	[4.7460000000E+04, 2.1424879595E+00, 1.6065270566E+00, 1.9143995821E-01, 1.5840887309E-01, 8.5374236647E-01],
	[4.7465000000E+04, 2.1428567978E+00, 1.6065221358E+00, 1.9150170446E-01, 1.5845311696E-01, 8.5376554244E-01],
	[4.7470000000E+04, 2.1432256608E+00, 1.6065172155E+00, 1.9156346411E-01, 1.5849736691E-01, 8.5378871592E-01],
	[4.7475000000E+04, 2.1435945484E+00, 1.6065122957E+00, 1.9162523718E-01, 1.5854162292E-01, 8.5381188691E-01],
	[4.7480000000E+04, 2.1439634606E+00, 1.6065073765E+00, 1.9168702366E-01, 1.5858588499E-01, 8.5383505542E-01],
	[4.7485000000E+04, 2.1443323975E+00, 1.6065024578E+00, 1.9174882356E-01, 1.5863015314E-01, 8.5385822143E-01],
	[4.7490000000E+04, 2.1447013590E+00, 1.6064975396E+00, 1.9181063686E-01, 1.5867442735E-01, 8.5388138496E-01],
	[4.7495000000E+04, 2.1450703451E+00, 1.6064926220E+00, 1.9187246358E-01, 1.5871870763E-01, 8.5390454599E-01],
	[4.7500000000E+04, 2.1454393558E+00, 1.6064877049E+00, 1.9193430372E-01, 1.5876299398E-01, 8.5392770454E-01],
	[4.7505000000E+04, 2.1458083912E+00, 1.6064827883E+00, 1.9199615728E-01, 1.5880728639E-01, 8.5395086060E-01],
	[4.7510000000E+04, 2.1461774512E+00, 1.6064778722E+00, 1.9205802426E-01, 1.5885158486E-01, 8.5397401417E-01],
	[4.7515000000E+04, 2.1465465359E+00, 1.6064729567E+00, 1.9211990466E-01, 1.5889588940E-01, 8.5399716525E-01],
	[4.7520000000E+04, 2.1469156451E+00, 1.6064680418E+00, 1.9218179848E-01, 1.5894020000E-01, 8.5402031383E-01],
	[4.7525000000E+04, 2.1472847790E+00, 1.6064631273E+00, 1.9224370573E-01, 1.5898451667E-01, 8.5404345993E-01],
	[4.7530000000E+04, 2.1476548601E+00, 1.6064589187E+00, 1.9230562640E-01, 1.5902885136E-01, 8.5406660353E-01],
	[4.7535000000E+04, 2.1480249895E+00, 1.6064547284E+00, 1.9236756051E-01, 1.5907319243E-01, 8.5408974465E-01],
	[4.7540000000E+04, 2.1483951438E+00, 1.6064505386E+00, 1.9242950804E-01, 1.5911753957E-01, 8.5411288327E-01],
	[4.7545000000E+04, 2.1487653228E+00, 1.6064463492E+00, 1.9249146900E-01, 1.5916189278E-01, 8.5413601940E-01],
	[4.7550000000E+04, 2.1491355268E+00, 1.6064421602E+00, 1.9255344339E-01, 1.5920625207E-01, 8.5415915304E-01],
	[4.7555000000E+04, 2.1495057555E+00, 1.6064379718E+00, 1.9261543122E-01, 1.5925061742E-01, 8.5418228419E-01],
	[4.7560000000E+04, 2.1498760091E+00, 1.6064337837E+00, 1.9267743248E-01, 1.5929498883E-01, 8.5420541285E-01],
	[4.7565000000E+04, 2.1502462876E+00, 1.6064295961E+00, 1.9273944718E-01, 1.5933936632E-01, 8.5422853901E-01],
	[4.7570000000E+04, 2.1506165909E+00, 1.6064254090E+00, 1.9280147532E-01, 1.5938374987E-01, 8.5425166268E-01],
	[4.7575000000E+04, 2.1509869190E+00, 1.6064212223E+00, 1.9286351690E-01, 1.5942813949E-01, 8.5427478385E-01],
	[4.7580000000E+04, 2.1513572720E+00, 1.6064170361E+00, 1.9292557191E-01, 1.5947253517E-01, 8.5429790254E-01],
	[4.7585000000E+04, 2.1517276498E+00, 1.6064128503E+00, 1.9298764037E-01, 1.5951693692E-01, 8.5432101873E-01],
	[4.7590000000E+04, 2.1520980525E+00, 1.6064086650E+00, 1.9304972228E-01, 1.5956134474E-01, 8.5434413242E-01],
	[4.7595000000E+04, 2.1524684800E+00, 1.6064044801E+00, 1.9311181763E-01, 1.5960575861E-01, 8.5436724363E-01],
	[4.7600000000E+04, 2.1528389323E+00, 1.6064002957E+00, 1.9317392643E-01, 1.5965017855E-01, 8.5439035233E-01],
	[4.7605000000E+04, 2.1532094095E+00, 1.6063961117E+00, 1.9323604867E-01, 1.5969460455E-01, 8.5441345855E-01],
	[4.7610000000E+04, 2.1535799115E+00, 1.6063919282E+00, 1.9329818437E-01, 1.5973903662E-01, 8.5443656226E-01],
	[4.7615000000E+04, 2.1539504383E+00, 1.6063877451E+00, 1.9336033352E-01, 1.5978347474E-01, 8.5445966349E-01],
	[4.7620000000E+04, 2.1543209900E+00, 1.6063835625E+00, 1.9342249612E-01, 1.5982791892E-01, 8.5448276222E-01],
	[4.7625000000E+04, 2.1546915665E+00, 1.6063793803E+00, 1.9348467217E-01, 1.5987236917E-01, 8.5450585845E-01],
	[4.7630000000E+04, 2.1550621678E+00, 1.6063751986E+00, 1.9354686169E-01, 1.5991682547E-01, 8.5452895219E-01],
	[4.7635000000E+04, 2.1554327940E+00, 1.6063710173E+00, 1.9360906466E-01, 1.5996128783E-01, 8.5455204343E-01],
	[4.7640000000E+04, 2.1558034450E+00, 1.6063668365E+00, 1.9367128109E-01, 1.6000575624E-01, 8.5457513217E-01],
	[4.7645000000E+04, 2.1561741208E+00, 1.6063626561E+00, 1.9373351097E-01, 1.6005023072E-01, 8.5459821842E-01],
	[4.7650000000E+04, 2.1565448215E+00, 1.6063584762E+00, 1.9379575433E-01, 1.6009471125E-01, 8.5462130217E-01],
	[4.7655000000E+04, 2.1569155469E+00, 1.6063542967E+00, 1.9385801114E-01, 1.6013919783E-01, 8.5464438343E-01],
	[4.7660000000E+04, 2.1572862972E+00, 1.6063501177E+00, 1.9392028142E-01, 1.6018369047E-01, 8.5466746219E-01],
	[4.7665000000E+04, 2.1576570724E+00, 1.6063459391E+00, 1.9398256517E-01, 1.6022818916E-01, 8.5469053845E-01],
	[4.7670000000E+04, 2.1580278723E+00, 1.6063417609E+00, 1.9404486238E-01, 1.6027269391E-01, 8.5471361221E-01],
	[4.7675000000E+04, 2.1583986971E+00, 1.6063375833E+00, 1.9410717307E-01, 1.6031720471E-01, 8.5473668347E-01],
	[4.7680000000E+04, 2.1587695467E+00, 1.6063334060E+00, 1.9416949722E-01, 1.6036172156E-01, 8.5475975224E-01],
	[4.7685000000E+04, 2.1591404211E+00, 1.6063292292E+00, 1.9423183485E-01, 1.6040624446E-01, 8.5478281851E-01],
	[4.7690000000E+04, 2.1595113203E+00, 1.6063250529E+00, 1.9429418596E-01, 1.6045077342E-01, 8.5480588228E-01],
	[4.7695000000E+04, 2.1598822444E+00, 1.6063208770E+00, 1.9435655053E-01, 1.6049530842E-01, 8.5482894355E-01],
	[4.7700000000E+04, 2.1602531933E+00, 1.6063167016E+00, 1.9441892859E-01, 1.6053984947E-01, 8.5485200233E-01],
	[4.7705000000E+04, 2.1606241670E+00, 1.6063125266E+00, 1.9448132012E-01, 1.6058439657E-01, 8.5487505860E-01],
	[4.7710000000E+04, 2.1609951655E+00, 1.6063083521E+00, 1.9454372514E-01, 1.6062894972E-01, 8.5489811237E-01],
	[4.7715000000E+04, 2.1613661888E+00, 1.6063041780E+00, 1.9460614363E-01, 1.6067350891E-01, 8.5492116365E-01],
	[4.7720000000E+04, 2.1617372369E+00, 1.6063000043E+00, 1.9466857561E-01, 1.6071807416E-01, 8.5494421242E-01],
	[4.7725000000E+04, 2.1621083099E+00, 1.6062958311E+00, 1.9473102108E-01, 1.6076264544E-01, 8.5496725870E-01],
	[4.7730000000E+04, 2.1624794076E+00, 1.6062916584E+00, 1.9479348003E-01, 1.6080722278E-01, 8.5499030247E-01],
	[4.7735000000E+04, 2.1628505302E+00, 1.6062874861E+00, 1.9485595246E-01, 1.6085180615E-01, 8.5501334375E-01],
	[4.7740000000E+04, 2.1632216776E+00, 1.6062833142E+00, 1.9491843839E-01, 1.6089639557E-01, 8.5503638252E-01],
	[4.7745000000E+04, 2.1635928498E+00, 1.6062791428E+00, 1.9498093781E-01, 1.6094099104E-01, 8.5505941879E-01],
	[4.7750000000E+04, 2.1639640468E+00, 1.6062749719E+00, 1.9504345072E-01, 1.6098559254E-01, 8.5508245256E-01],
	[4.7755000000E+04, 2.1643352686E+00, 1.6062708014E+00, 1.9510597712E-01, 1.6103020009E-01, 8.5510548383E-01],
	[4.7760000000E+04, 2.1647065152E+00, 1.6062666313E+00, 1.9516851702E-01, 1.6107481368E-01, 8.5512851260E-01],
	[4.7765000000E+04, 2.1650777866E+00, 1.6062624617E+00, 1.9523107041E-01, 1.6111943330E-01, 8.5515153886E-01],
	[4.7770000000E+04, 2.1654490828E+00, 1.6062582925E+00, 1.9529363730E-01, 1.6116405897E-01, 8.5517456263E-01],
	[4.7775000000E+04, 2.1658204039E+00, 1.6062541238E+00, 1.9535621770E-01, 1.6120869068E-01, 8.5519758389E-01],
	[4.7780000000E+04, 2.1661917497E+00, 1.6062499555E+00, 1.9541881159E-01, 1.6125332842E-01, 8.5522060265E-01],
	[4.7785000000E+04, 2.1665631203E+00, 1.6062457877E+00, 1.9548141899E-01, 1.6129797221E-01, 8.5524361890E-01],
	[4.7790000000E+04, 2.1669345158E+00, 1.6062416203E+00, 1.9554403989E-01, 1.6134262202E-01, 8.5526663265E-01],
	[4.7795000000E+04, 2.1673059360E+00, 1.6062374534E+00, 1.9560667429E-01, 1.6138727788E-01, 8.5528964390E-01],
	[4.7800000000E+04, 2.1676773811E+00, 1.6062332869E+00, 1.9566932221E-01, 1.6143193977E-01, 8.5531265265E-01],
	[4.7805000000E+04, 2.1680488509E+00, 1.6062291209E+00, 1.9573198363E-01, 1.6147660770E-01, 8.5533565889E-01],
	[4.7810000000E+04, 2.1684203455E+00, 1.6062249553E+00, 1.9579465856E-01, 1.6152128165E-01, 8.5535866263E-01],
	[4.7815000000E+04, 2.1687918649E+00, 1.6062207901E+00, 1.9585734700E-01, 1.6156596165E-01, 8.5538166386E-01],
	[4.7820000000E+04, 2.1691634092E+00, 1.6062166254E+00, 1.9592004896E-01, 1.6161064767E-01, 8.5540466259E-01],
	[4.7825000000E+04, 2.1695349782E+00, 1.6062124612E+00, 1.9598276443E-01, 1.6165533973E-01, 8.5542765881E-01],
	[4.7830000000E+04, 2.1699065720E+00, 1.6062082974E+00, 1.9604549342E-01, 1.6170003782E-01, 8.5545065253E-01],
	[4.7835000000E+04, 2.1702781906E+00, 1.6062041340E+00, 1.9610823592E-01, 1.6174474194E-01, 8.5547364375E-01],
	[4.7840000000E+04, 2.1706498340E+00, 1.6061999711E+00, 1.9617099195E-01, 1.6178945209E-01, 8.5549663246E-01],
	[4.7845000000E+04, 2.1710215022E+00, 1.6061958086E+00, 1.9623376149E-01, 1.6183416826E-01, 8.5551961866E-01],
	[4.7850000000E+04, 2.1713931952E+00, 1.6061916466E+00, 1.9629654456E-01, 1.6187889047E-01, 8.5554260236E-01],
	[4.7855000000E+04, 2.1717649129E+00, 1.6061874850E+00, 1.9635934115E-01, 1.6192361871E-01, 8.5556558355E-01],
	[4.7860000000E+04, 2.1721366555E+00, 1.6061833239E+00, 1.9642215126E-01, 1.6196835297E-01, 8.5558856224E-01],
	[4.7865000000E+04, 2.1725084228E+00, 1.6061791632E+00, 1.9648497491E-01, 1.6201309325E-01, 8.5561153842E-01],
	[4.7870000000E+04, 2.1728802149E+00, 1.6061750030E+00, 1.9654781208E-01, 1.6205783957E-01, 8.5563451209E-01],
	[4.7875000000E+04, 2.1732520319E+00, 1.6061708432E+00, 1.9661066278E-01, 1.6210259191E-01, 8.5565748326E-01],
	[4.7880000000E+04, 2.1736238736E+00, 1.6061666838E+00, 1.9667352701E-01, 1.6214735027E-01, 8.5568045191E-01],
	[4.7885000000E+04, 2.1739957400E+00, 1.6061625249E+00, 1.9673640477E-01, 1.6219211466E-01, 8.5570341807E-01],
	[4.7890000000E+04, 2.1743676313E+00, 1.6061583664E+00, 1.9679929607E-01, 1.6223688507E-01, 8.5572638171E-01],
	[4.7895000000E+04, 2.1747395473E+00, 1.6061542084E+00, 1.9686220090E-01, 1.6228166150E-01, 8.5574934285E-01],
	[4.7900000000E+04, 2.1751114882E+00, 1.6061500509E+00, 1.9692511927E-01, 1.6232644395E-01, 8.5577230147E-01],
	[4.7905000000E+04, 2.1754834538E+00, 1.6061458937E+00, 1.9698805118E-01, 1.6237123243E-01, 8.5579525759E-01],
	[4.7910000000E+04, 2.1758554441E+00, 1.6061417370E+00, 1.9705099663E-01, 1.6241602692E-01, 8.5581821121E-01],
	[4.7915000000E+04, 2.1762274593E+00, 1.6061375808E+00, 1.9711395562E-01, 1.6246082743E-01, 8.5584116231E-01],
	[4.7920000000E+04, 2.1765994992E+00, 1.6061334250E+00, 1.9717692815E-01, 1.6250563397E-01, 8.5586411090E-01],
	[4.7925000000E+04, 2.1769715639E+00, 1.6061292697E+00, 1.9723991423E-01, 1.6255044652E-01, 8.5588705699E-01],
	[4.7930000000E+04, 2.1773436534E+00, 1.6061251148E+00, 1.9730291386E-01, 1.6259526508E-01, 8.5591000056E-01],
	[4.7935000000E+04, 2.1777157677E+00, 1.6061209603E+00, 1.9736592703E-01, 1.6264008967E-01, 8.5593294163E-01],
	[4.7940000000E+04, 2.1780879067E+00, 1.6061168063E+00, 1.9742895375E-01, 1.6268492027E-01, 8.5595588019E-01],
	[4.7945000000E+04, 2.1784600705E+00, 1.6061126527E+00, 1.9749199402E-01, 1.6272975689E-01, 8.5597881623E-01],
	[4.7950000000E+04, 2.1788322591E+00, 1.6061084996E+00, 1.9755504785E-01, 1.6277459952E-01, 8.5600174977E-01],
	[4.7955000000E+04, 2.1792044725E+00, 1.6061043469E+00, 1.9761811522E-01, 1.6281944816E-01, 8.5602468080E-01],
	[4.7960000000E+04, 2.1795767106E+00, 1.6061001947E+00, 1.9768119616E-01, 1.6286430282E-01, 8.5604760931E-01],
	[4.7965000000E+04, 2.1799489735E+00, 1.6060960429E+00, 1.9774429065E-01, 1.6290916349E-01, 8.5607053532E-01],
	[4.7970000000E+04, 2.1803212611E+00, 1.6060918915E+00, 1.9780739869E-01, 1.6295403017E-01, 8.5609345881E-01],
	[4.7975000000E+04, 2.1806935735E+00, 1.6060877406E+00, 1.9787052030E-01, 1.6299890286E-01, 8.5611637980E-01],
	[4.7980000000E+04, 2.1810659107E+00, 1.6060835901E+00, 1.9793365547E-01, 1.6304378157E-01, 8.5613929827E-01],
	[4.7985000000E+04, 2.1814382727E+00, 1.6060794401E+00, 1.9799680420E-01, 1.6308866628E-01, 8.5616221423E-01],
	[4.7990000000E+04, 2.1818106594E+00, 1.6060752905E+00, 1.9805996649E-01, 1.6313355700E-01, 8.5618512768E-01],
	[4.7995000000E+04, 2.1821830709E+00, 1.6060711414E+00, 1.9812314235E-01, 1.6317845373E-01, 8.5620803861E-01],
	[4.8000000000E+04, 2.1825555071E+00, 1.6060669927E+00, 1.9818633178E-01, 1.6322335647E-01, 8.5623094704E-01],
	[4.8005000000E+04, 2.1829279681E+00, 1.6060628444E+00, 1.9824953478E-01, 1.6326826521E-01, 8.5625385295E-01],
	[4.8010000000E+04, 2.1833004538E+00, 1.6060586966E+00, 1.9831275134E-01, 1.6331317997E-01, 8.5627675635E-01],
	[4.8015000000E+04, 2.1836729644E+00, 1.6060545493E+00, 1.9837598148E-01, 1.6335810072E-01, 8.5629965723E-01],
	[4.8020000000E+04, 2.1840454996E+00, 1.6060504023E+00, 1.9843922519E-01, 1.6340302748E-01, 8.5632255560E-01],
	[4.8025000000E+04, 2.1844180597E+00, 1.6060462559E+00, 1.9850248248E-01, 1.6344796025E-01, 8.5634545146E-01],
	[4.8030000000E+04, 2.1847906445E+00, 1.6060421098E+00, 1.9856575334E-01, 1.6349289902E-01, 8.5636834481E-01],
	[4.8035000000E+04, 2.1851632540E+00, 1.6060379642E+00, 1.9862903778E-01, 1.6353784379E-01, 8.5639123564E-01],
	[4.8040000000E+04, 2.1855358883E+00, 1.6060338191E+00, 1.9869233580E-01, 1.6358279456E-01, 8.5641412396E-01],
	[4.8045000000E+04, 2.1859085473E+00, 1.6060296744E+00, 1.9875564740E-01, 1.6362775134E-01, 8.5643700976E-01],
	[4.8050000000E+04, 2.1862812311E+00, 1.6060255301E+00, 1.9881897258E-01, 1.6367271411E-01, 8.5645989305E-01],
	[4.8055000000E+04, 2.1866539397E+00, 1.6060213863E+00, 1.9888231134E-01, 1.6371768288E-01, 8.5648277383E-01],
	[4.8060000000E+04, 2.1870266730E+00, 1.6060172429E+00, 1.9894566369E-01, 1.6376265766E-01, 8.5650565209E-01],
	[4.8065000000E+04, 2.1873994311E+00, 1.6060130999E+00, 1.9900902963E-01, 1.6380763843E-01, 8.5652852783E-01],
	[4.8070000000E+04, 2.1877722139E+00, 1.6060089574E+00, 1.9907240915E-01, 1.6385262520E-01, 8.5655140106E-01],
	[4.8075000000E+04, 2.1881450214E+00, 1.6060048154E+00, 1.9913580227E-01, 1.6389761797E-01, 8.5657427178E-01],
	[4.8080000000E+04, 2.1885178537E+00, 1.6060006738E+00, 1.9919920897E-01, 1.6394261673E-01, 8.5659713998E-01],
	[4.8085000000E+04, 2.1888907108E+00, 1.6059965326E+00, 1.9926262927E-01, 1.6398762149E-01, 8.5662000566E-01],
	[4.8090000000E+04, 2.1892635926E+00, 1.6059923918E+00, 1.9932606316E-01, 1.6403263225E-01, 8.5664286883E-01],
	[4.8095000000E+04, 2.1896364991E+00, 1.6059882515E+00, 1.9938951065E-01, 1.6407764899E-01, 8.5666572948E-01],
	[4.8100000000E+04, 2.1900094304E+00, 1.6059841117E+00, 1.9945297173E-01, 1.6412267173E-01, 8.5668858761E-01],
	[4.8105000000E+04, 2.1903823864E+00, 1.6059799723E+00, 1.9951644642E-01, 1.6416770047E-01, 8.5671144323E-01],
	[4.8110000000E+04, 2.1907553671E+00, 1.6059758333E+00, 1.9957993470E-01, 1.6421273520E-01, 8.5673429633E-01],
	[4.8115000000E+04, 2.1911283726E+00, 1.6059716948E+00, 1.9964343659E-01, 1.6425777591E-01, 8.5675714691E-01],
	[4.8120000000E+04, 2.1915014029E+00, 1.6059675567E+00, 1.9970695207E-01, 1.6430282262E-01, 8.5677999498E-01],
	[4.8125000000E+04, 2.1918744579E+00, 1.6059634190E+00, 1.9977048117E-01, 1.6434787532E-01, 8.5680284053E-01],
	[4.8130000000E+04, 2.1922475376E+00, 1.6059592818E+00, 1.9983402387E-01, 1.6439293401E-01, 8.5682568356E-01],
	[4.8135000000E+04, 2.1926206420E+00, 1.6059551450E+00, 1.9989758017E-01, 1.6443799869E-01, 8.5684852408E-01],
	[4.8140000000E+04, 2.1929937712E+00, 1.6059510087E+00, 1.9996115009E-01, 1.6448306935E-01, 8.5687136207E-01],
	[4.8145000000E+04, 2.1933669251E+00, 1.6059468728E+00, 2.0002473361E-01, 1.6452814600E-01, 8.5689419755E-01],
	[4.8150000000E+04, 2.1937401038E+00, 1.6059427374E+00, 2.0008833075E-01, 1.6457322864E-01, 8.5691703051E-01],
	[4.8155000000E+04, 2.1941133072E+00, 1.6059386024E+00, 2.0015194150E-01, 1.6461831726E-01, 8.5693986095E-01],
	[4.8160000000E+04, 2.1944865353E+00, 1.6059344678E+00, 2.0021556587E-01, 1.6466341187E-01, 8.5696268887E-01],
	[4.8165000000E+04, 2.1948597882E+00, 1.6059303337E+00, 2.0027920386E-01, 1.6470851246E-01, 8.5698551427E-01],
	[4.8170000000E+04, 2.1952330657E+00, 1.6059262000E+00, 2.0034285546E-01, 1.6475361904E-01, 8.5700833715E-01],
	[4.8175000000E+04, 2.1956063681E+00, 1.6059220667E+00, 2.0040652068E-01, 1.6479873160E-01, 8.5703115752E-01],
	[4.8180000000E+04, 2.1959796951E+00, 1.6059179339E+00, 2.0047019952E-01, 1.6484385014E-01, 8.5705397536E-01],
	[4.8185000000E+04, 2.1963530469E+00, 1.6059138015E+00, 2.0053389199E-01, 1.6488897466E-01, 8.5707679068E-01],
	[4.8190000000E+04, 2.1967264234E+00, 1.6059096696E+00, 2.0059759807E-01, 1.6493410517E-01, 8.5709960349E-01],
	[4.8195000000E+04, 2.1970998246E+00, 1.6059055381E+00, 2.0066131779E-01, 1.6497924165E-01, 8.5712241377E-01],
	[4.8200000000E+04, 2.1974732505E+00, 1.6059014071E+00, 2.0072505113E-01, 1.6502438411E-01, 8.5714522153E-01],
	[4.8205000000E+04, 2.1978467012E+00, 1.6058972764E+00, 2.0078879810E-01, 1.6506953255E-01, 8.5716802678E-01],
	[4.8210000000E+04, 2.1982201766E+00, 1.6058931463E+00, 2.0085255870E-01, 1.6511468697E-01, 8.5719082950E-01],
	[4.8215000000E+04, 2.1985936767E+00, 1.6058890165E+00, 2.0091633293E-01, 1.6515984737E-01, 8.5721362970E-01],
	[4.8220000000E+04, 2.1989672015E+00, 1.6058848872E+00, 2.0098012080E-01, 1.6520501374E-01, 8.5723642738E-01],
	[4.8225000000E+04, 2.1993407511E+00, 1.6058807584E+00, 2.0104392230E-01, 1.6525018609E-01, 8.5725922253E-01],
	[4.8230000000E+04, 2.1997143254E+00, 1.6058766300E+00, 2.0110773744E-01, 1.6529536441E-01, 8.5728201517E-01],
	[4.8235000000E+04, 2.2000879244E+00, 1.6058725020E+00, 2.0117156621E-01, 1.6534054871E-01, 8.5730480528E-01],
	[4.8240000000E+04, 2.2004615481E+00, 1.6058683744E+00, 2.0123540862E-01, 1.6538573898E-01, 8.5732759288E-01],
	[4.8245000000E+04, 2.2008351965E+00, 1.6058642473E+00, 2.0129926468E-01, 1.6543093523E-01, 8.5735037795E-01],
	[4.8250000000E+04, 2.2012088696E+00, 1.6058601207E+00, 2.0136313437E-01, 1.6547613744E-01, 8.5737316049E-01],
	[4.8255000000E+04, 2.2015825675E+00, 1.6058559944E+00, 2.0142701771E-01, 1.6552134563E-01, 8.5739594052E-01],
	[4.8260000000E+04, 2.2019562900E+00, 1.6058518687E+00, 2.0149091469E-01, 1.6556655979E-01, 8.5741871802E-01],
	[4.8265000000E+04, 2.2023300373E+00, 1.6058477433E+00, 2.0155482533E-01, 1.6561177992E-01, 8.5744149300E-01],
	[4.8270000000E+04, 2.2027038093E+00, 1.6058436184E+00, 2.0161874960E-01, 1.6565700602E-01, 8.5746426545E-01],
	[4.8275000000E+04, 2.2030776060E+00, 1.6058394939E+00, 2.0168268753E-01, 1.6570223808E-01, 8.5748703538E-01],
	[4.8280000000E+04, 2.2034514274E+00, 1.6058353699E+00, 2.0174663911E-01, 1.6574747612E-01, 8.5750980279E-01],
	[4.8285000000E+04, 2.2038252736E+00, 1.6058312463E+00, 2.0181060435E-01, 1.6579272012E-01, 8.5753256768E-01],
	[4.8290000000E+04, 2.2041991444E+00, 1.6058271231E+00, 2.0187458323E-01, 1.6583797009E-01, 8.5755533004E-01],
	[4.8295000000E+04, 2.2045739852E+00, 1.6058236826E+00, 2.0193857577E-01, 1.6588323865E-01, 8.5757808987E-01],
	[4.8300000000E+04, 2.2049488930E+00, 1.6058202730E+00, 2.0200258197E-01, 1.6592851376E-01, 8.5760084718E-01],
	[4.8305000000E+04, 2.2053238258E+00, 1.6058168636E+00, 2.0206660183E-01, 1.6597379484E-01, 8.5762360197E-01],
	[4.8310000000E+04, 2.2056987835E+00, 1.6058134547E+00, 2.0213063535E-01, 1.6601908189E-01, 8.5764635423E-01],
	[4.8315000000E+04, 2.2060737662E+00, 1.6058100460E+00, 2.0219468253E-01, 1.6606437492E-01, 8.5766910397E-01],
	[4.8320000000E+04, 2.2064487738E+00, 1.6058066378E+00, 2.0225874337E-01, 1.6610967393E-01, 8.5769185118E-01],
	[4.8325000000E+04, 2.2068238063E+00, 1.6058032299E+00, 2.0232281788E-01, 1.6615497890E-01, 8.5771459587E-01],
	[4.8330000000E+04, 2.2071988638E+00, 1.6057998224E+00, 2.0238690605E-01, 1.6620028985E-01, 8.5773733803E-01],
	[4.8335000000E+04, 2.2075739462E+00, 1.6057964152E+00, 2.0245100789E-01, 1.6624560677E-01, 8.5776007767E-01],
	[4.8340000000E+04, 2.2079490535E+00, 1.6057930084E+00, 2.0251512340E-01, 1.6629092966E-01, 8.5778281477E-01],
	[4.8345000000E+04, 2.2083241858E+00, 1.6057896020E+00, 2.0257925258E-01, 1.6633625851E-01, 8.5780554936E-01],
	[4.8350000000E+04, 2.2086993430E+00, 1.6057861959E+00, 2.0264339544E-01, 1.6638159334E-01, 8.5782828141E-01],
	[4.8355000000E+04, 2.2090745251E+00, 1.6057827901E+00, 2.0270755196E-01, 1.6642693414E-01, 8.5785101095E-01],
	[4.8360000000E+04, 2.2094497322E+00, 1.6057793848E+00, 2.0277172216E-01, 1.6647228090E-01, 8.5787373795E-01],
	[4.8365000000E+04, 2.2098249641E+00, 1.6057759798E+00, 2.0283590604E-01, 1.6651763363E-01, 8.5789646243E-01],
	[4.8370000000E+04, 2.2102002211E+00, 1.6057725751E+00, 2.0290010360E-01, 1.6656299233E-01, 8.5791918437E-01],
	[4.8375000000E+04, 2.2105755029E+00, 1.6057691708E+00, 2.0296431483E-01, 1.6660835699E-01, 8.5794190380E-01],
	[4.8380000000E+04, 2.2109508096E+00, 1.6057657669E+00, 2.0302853975E-01, 1.6665372761E-01, 8.5796462069E-01],
	[4.8385000000E+04, 2.2113261413E+00, 1.6057623633E+00, 2.0309277835E-01, 1.6669910421E-01, 8.5798733506E-01],
	[4.8390000000E+04, 2.2117014979E+00, 1.6057589601E+00, 2.0315703063E-01, 1.6674448676E-01, 8.5801004690E-01],
	[4.8395000000E+04, 2.2120768794E+00, 1.6057555572E+00, 2.0322129660E-01, 1.6678987528E-01, 8.5803275621E-01],
	[4.8400000000E+04, 2.2124522859E+00, 1.6057521547E+00, 2.0328557626E-01, 1.6683526975E-01, 8.5805546299E-01],
	[4.8405000000E+04, 2.2128277172E+00, 1.6057487526E+00, 2.0334986961E-01, 1.6688067019E-01, 8.5807816725E-01],
	[4.8410000000E+04, 2.2132031735E+00, 1.6057453508E+00, 2.0341417664E-01, 1.6692607659E-01, 8.5810086897E-01],
	[4.8415000000E+04, 2.2135786547E+00, 1.6057419494E+00, 2.0347849737E-01, 1.6697148895E-01, 8.5812356817E-01],
	[4.8420000000E+04, 2.2139541608E+00, 1.6057385483E+00, 2.0354283179E-01, 1.6701690727E-01, 8.5814626484E-01],
	[4.8425000000E+04, 2.2143296919E+00, 1.6057351476E+00, 2.0360717990E-01, 1.6706233155E-01, 8.5816895898E-01],
	[4.8430000000E+04, 2.2147052478E+00, 1.6057317473E+00, 2.0367154171E-01, 1.6710776178E-01, 8.5819165059E-01],
	[4.8435000000E+04, 2.2150808287E+00, 1.6057283473E+00, 2.0373591722E-01, 1.6715319797E-01, 8.5821433967E-01],
	[4.8440000000E+04, 2.2154564345E+00, 1.6057249476E+00, 2.0380030643E-01, 1.6719864012E-01, 8.5823702622E-01],
	[4.8445000000E+04, 2.2158320652E+00, 1.6057215484E+00, 2.0386470934E-01, 1.6724408822E-01, 8.5825971024E-01],
	[4.8450000000E+04, 2.2162077208E+00, 1.6057181495E+00, 2.0392912595E-01, 1.6728954228E-01, 8.5828239173E-01],
	[4.8455000000E+04, 2.2165834013E+00, 1.6057147509E+00, 2.0399355626E-01, 1.6733500229E-01, 8.5830507069E-01],
	[4.8460000000E+04, 2.2169591067E+00, 1.6057113527E+00, 2.0405800028E-01, 1.6738046825E-01, 8.5832774712E-01],
	[4.8465000000E+04, 2.2173348370E+00, 1.6057079549E+00, 2.0412245801E-01, 1.6742594017E-01, 8.5835042102E-01],
	[4.8470000000E+04, 2.2177105923E+00, 1.6057045574E+00, 2.0418692944E-01, 1.6747141804E-01, 8.5837309239E-01],
	[4.8475000000E+04, 2.2180863724E+00, 1.6057011603E+00, 2.0425141459E-01, 1.6751690186E-01, 8.5839576123E-01],
	[4.8480000000E+04, 2.2184621775E+00, 1.6056977635E+00, 2.0431591344E-01, 1.6756239163E-01, 8.5841842753E-01],
	[4.8485000000E+04, 2.2188380074E+00, 1.6056943671E+00, 2.0438042601E-01, 1.6760788735E-01, 8.5844109131E-01],
	[4.8490000000E+04, 2.2192138623E+00, 1.6056909710E+00, 2.0444495229E-01, 1.6765338901E-01, 8.5846375255E-01],
	[4.8495000000E+04, 2.2195897420E+00, 1.6056875753E+00, 2.0450949229E-01, 1.6769889663E-01, 8.5848641126E-01],
	[4.8500000000E+04, 2.2199656467E+00, 1.6056841800E+00, 2.0457404600E-01, 1.6774441019E-01, 8.5850906744E-01],
	[4.8505000000E+04, 2.2203415763E+00, 1.6056807850E+00, 2.0463861343E-01, 1.6778992970E-01, 8.5853172109E-01],
	[4.8510000000E+04, 2.2207175307E+00, 1.6056773904E+00, 2.0470319459E-01, 1.6783545516E-01, 8.5855437221E-01],
	[4.8515000000E+04, 2.2210935101E+00, 1.6056739961E+00, 2.0476778946E-01, 1.6788098656E-01, 8.5857702079E-01],
	[4.8520000000E+04, 2.2214695144E+00, 1.6056706022E+00, 2.0483239806E-01, 1.6792652391E-01, 8.5859966684E-01],
	[4.8525000000E+04, 2.2218455435E+00, 1.6056672086E+00, 2.0489702038E-01, 1.6797206720E-01, 8.5862231036E-01],
	[4.8530000000E+04, 2.2222215976E+00, 1.6056638154E+00, 2.0496165643E-01, 1.6801761643E-01, 8.5864495134E-01],
	[4.8535000000E+04, 2.2225976765E+00, 1.6056604226E+00, 2.0502630621E-01, 1.6806317161E-01, 8.5866758979E-01],
	[4.8540000000E+04, 2.2229737804E+00, 1.6056570301E+00, 2.0509096971E-01, 1.6810873272E-01, 8.5869022571E-01],
	[4.8545000000E+04, 2.2233499091E+00, 1.6056536380E+00, 2.0515564695E-01, 1.6815429978E-01, 8.5871285909E-01],
	[4.8550000000E+04, 2.2237260628E+00, 1.6056502462E+00, 2.0522033792E-01, 1.6819987278E-01, 8.5873548995E-01],
	[4.8555000000E+04, 2.2241022413E+00, 1.6056468548E+00, 2.0528504262E-01, 1.6824545171E-01, 8.5875811826E-01],
	[4.8560000000E+04, 2.2244784447E+00, 1.6056434638E+00, 2.0534976105E-01, 1.6829103659E-01, 8.5878074405E-01],
	[4.8565000000E+04, 2.2248546730E+00, 1.6056400731E+00, 2.0541449323E-01, 1.6833662740E-01, 8.5880336729E-01],
	[4.8570000000E+04, 2.2252309263E+00, 1.6056366827E+00, 2.0547923914E-01, 1.6838222416E-01, 8.5882598801E-01],
	[4.8575000000E+04, 2.2256072043E+00, 1.6056332927E+00, 2.0554399879E-01, 1.6842782684E-01, 8.5884860619E-01],
	[4.8580000000E+04, 2.2259835073E+00, 1.6056299031E+00, 2.0560877218E-01, 1.6847343547E-01, 8.5887122183E-01],
	[4.8585000000E+04, 2.2263598352E+00, 1.6056265138E+00, 2.0567355932E-01, 1.6851905002E-01, 8.5889383494E-01],
	[4.8590000000E+04, 2.2267361879E+00, 1.6056231249E+00, 2.0573836020E-01, 1.6856467052E-01, 8.5891644552E-01],
	[4.8595000000E+04, 2.2271125656E+00, 1.6056197363E+00, 2.0580317482E-01, 1.6861029694E-01, 8.5893905356E-01],
	[4.8600000000E+04, 2.2274889681E+00, 1.6056163481E+00, 2.0586800320E-01, 1.6865592930E-01, 8.5896165906E-01],
	[4.8605000000E+04, 2.2278653955E+00, 1.6056129603E+00, 2.0593284532E-01, 1.6870156759E-01, 8.5898426203E-01],
	[4.8610000000E+04, 2.2282418478E+00, 1.6056095728E+00, 2.0599770119E-01, 1.6874721182E-01, 8.5900686246E-01],
	[4.8615000000E+04, 2.2286183250E+00, 1.6056061856E+00, 2.0606257081E-01, 1.6879286197E-01, 8.5902946036E-01],
	[4.8620000000E+04, 2.2289948270E+00, 1.6056027988E+00, 2.0612745419E-01, 1.6883851805E-01, 8.5905205572E-01],
	[4.8625000000E+04, 2.2293713539E+00, 1.6055994124E+00, 2.0619235132E-01, 1.6888418007E-01, 8.5907464854E-01],
	[4.8630000000E+04, 2.2297479057E+00, 1.6055960263E+00, 2.0625726220E-01, 1.6892984801E-01, 8.5909723883E-01],
	[4.8635000000E+04, 2.2301244824E+00, 1.6055926406E+00, 2.0632218685E-01, 1.6897552188E-01, 8.5911982658E-01],
	[4.8640000000E+04, 2.2305010840E+00, 1.6055892552E+00, 2.0638712525E-01, 1.6902120167E-01, 8.5914241180E-01],
	[4.8645000000E+04, 2.2308777104E+00, 1.6055858702E+00, 2.0645207742E-01, 1.6906688739E-01, 8.5916499447E-01],
	[4.8650000000E+04, 2.2312543617E+00, 1.6055824856E+00, 2.0651704334E-01, 1.6911257904E-01, 8.5918757461E-01],
	[4.8655000000E+04, 2.2316310379E+00, 1.6055791013E+00, 2.0658202303E-01, 1.6915827661E-01, 8.5921015222E-01],
	[4.8660000000E+04, 2.2320077390E+00, 1.6055757173E+00, 2.0664701649E-01, 1.6920398011E-01, 8.5923272728E-01],
	[4.8665000000E+04, 2.2323844649E+00, 1.6055723337E+00, 2.0671202371E-01, 1.6924968953E-01, 8.5925529981E-01],
	[4.8670000000E+04, 2.2327612157E+00, 1.6055689505E+00, 2.0677704470E-01, 1.6929540487E-01, 8.5927786980E-01],
	[4.8675000000E+04, 2.2331379914E+00, 1.6055655676E+00, 2.0684207946E-01, 1.6934112614E-01, 8.5930043725E-01],
	[4.8680000000E+04, 2.2335147919E+00, 1.6055621851E+00, 2.0690712799E-01, 1.6938685332E-01, 8.5932300216E-01],
	[4.8685000000E+04, 2.2338916173E+00, 1.6055588029E+00, 2.0697219030E-01, 1.6943258643E-01, 8.5934556454E-01],
	[4.8690000000E+04, 2.2342684676E+00, 1.6055554211E+00, 2.0703726637E-01, 1.6947832545E-01, 8.5936812438E-01],
	[4.8695000000E+04, 2.2346453427E+00, 1.6055520396E+00, 2.0710235623E-01, 1.6952407040E-01, 8.5939068167E-01],
	[4.8700000000E+04, 2.2350222427E+00, 1.6055486585E+00, 2.0716745986E-01, 1.6956982126E-01, 8.5941323643E-01],
	[4.8705000000E+04, 2.2353991676E+00, 1.6055452778E+00, 2.0723257727E-01, 1.6961557804E-01, 8.5943578865E-01],
	[4.8710000000E+04, 2.2357761174E+00, 1.6055418974E+00, 2.0729770846E-01, 1.6966134074E-01, 8.5945833833E-01],
	[4.8715000000E+04, 2.2361530920E+00, 1.6055385173E+00, 2.0736285343E-01, 1.6970710935E-01, 8.5948088547E-01],
	[4.8720000000E+04, 2.2365300914E+00, 1.6055351376E+00, 2.0742801218E-01, 1.6975288388E-01, 8.5950343007E-01],
	[4.8725000000E+04, 2.2369071157E+00, 1.6055317583E+00, 2.0749318472E-01, 1.6979866432E-01, 8.5952597214E-01],
	[4.8730000000E+04, 2.2372841649E+00, 1.6055283793E+00, 2.0755837105E-01, 1.6984445068E-01, 8.5954851166E-01],
	[4.8735000000E+04, 2.2376612390E+00, 1.6055250007E+00, 2.0762357116E-01, 1.6989024295E-01, 8.5957104864E-01],
	[4.8740000000E+04, 2.2380383379E+00, 1.6055216224E+00, 2.0768878506E-01, 1.6993604113E-01, 8.5959358308E-01],
	[4.8745000000E+04, 2.2384154616E+00, 1.6055182445E+00, 2.0775401275E-01, 1.6998184522E-01, 8.5961611498E-01],
	[4.8750000000E+04, 2.2387926103E+00, 1.6055148669E+00, 2.0781925424E-01, 1.7002765523E-01, 8.5963864434E-01],
	[4.8755000000E+04, 2.2391697837E+00, 1.6055114897E+00, 2.0788450952E-01, 1.7007347114E-01, 8.5966117116E-01],
	[4.8760000000E+04, 2.2395469821E+00, 1.6055081128E+00, 2.0794977859E-01, 1.7011929297E-01, 8.5968369544E-01],
	[4.8765000000E+04, 2.2399242052E+00, 1.6055047363E+00, 2.0801506146E-01, 1.7016512070E-01, 8.5970621718E-01],
	[4.8770000000E+04, 2.2403014533E+00, 1.6055013602E+00, 2.0808035813E-01, 1.7021095434E-01, 8.5972873637E-01],
	[4.8775000000E+04, 2.2406787262E+00, 1.6054979844E+00, 2.0814566860E-01, 1.7025679389E-01, 8.5975125303E-01],
	[4.8780000000E+04, 2.2410560239E+00, 1.6054946089E+00, 2.0821099287E-01, 1.7030263934E-01, 8.5977376714E-01],
	[4.8785000000E+04, 2.2414333465E+00, 1.6054912338E+00, 2.0827633094E-01, 1.7034849070E-01, 8.5979627872E-01],
	[4.8790000000E+04, 2.2418106939E+00, 1.6054878591E+00, 2.0834168282E-01, 1.7039434796E-01, 8.5981878774E-01],
	[4.8795000000E+04, 2.2421880662E+00, 1.6054844847E+00, 2.0840704850E-01, 1.7044021113E-01, 8.5984129423E-01],
	[4.8800000000E+04, 2.2425654633E+00, 1.6054811106E+00, 2.0847242799E-01, 1.7048608020E-01, 8.5986379818E-01],
	[4.8805000000E+04, 2.2429428853E+00, 1.6054777370E+00, 2.0853782129E-01, 1.7053195518E-01, 8.5988629958E-01],
	[4.8810000000E+04, 2.2433203321E+00, 1.6054743636E+00, 2.0860322840E-01, 1.7057783605E-01, 8.5990879844E-01],
	[4.8815000000E+04, 2.2436978038E+00, 1.6054709906E+00, 2.0866864932E-01, 1.7062372283E-01, 8.5993129476E-01],
	[4.8820000000E+04, 2.2440753003E+00, 1.6054676180E+00, 2.0873408405E-01, 1.7066961551E-01, 8.5995378854E-01],
	[4.8825000000E+04, 2.2444528217E+00, 1.6054642457E+00, 2.0879953260E-01, 1.7071551409E-01, 8.5997627977E-01],
	[4.8830000000E+04, 2.2448303679E+00, 1.6054608738E+00, 2.0886499496E-01, 1.7076141857E-01, 8.5999876846E-01],
	[4.8835000000E+04, 2.2452079389E+00, 1.6054575022E+00, 2.0893047115E-01, 1.7080732894E-01, 8.6002125460E-01],
	[4.8840000000E+04, 2.2455855348E+00, 1.6054541310E+00, 2.0899596115E-01, 1.7085324521E-01, 8.6004373820E-01],
	[4.8845000000E+04, 2.2459631555E+00, 1.6054507602E+00, 2.0906146497E-01, 1.7089916738E-01, 8.6006621926E-01],
	[4.8850000000E+04, 2.2463408011E+00, 1.6054473897E+00, 2.0912698261E-01, 1.7094509545E-01, 8.6008869778E-01],
	[4.8855000000E+04, 2.2467184715E+00, 1.6054440195E+00, 2.0919251408E-01, 1.7099102941E-01, 8.6011117375E-01],
	[4.8860000000E+04, 2.2470961667E+00, 1.6054406497E+00, 2.0925805938E-01, 1.7103696926E-01, 8.6013364718E-01],
	[4.8865000000E+04, 2.2474738868E+00, 1.6054372802E+00, 2.0932361850E-01, 1.7108291501E-01, 8.6015611806E-01],
	[4.8870000000E+04, 2.2478516317E+00, 1.6054339111E+00, 2.0938919144E-01, 1.7112886666E-01, 8.6017858640E-01],
	[4.8875000000E+04, 2.2482294014E+00, 1.6054305424E+00, 2.0945477822E-01, 1.7117482419E-01, 8.6020105219E-01],
	[4.8880000000E+04, 2.2486071960E+00, 1.6054271740E+00, 2.0952037883E-01, 1.7122078762E-01, 8.6022351544E-01],
	[4.8885000000E+04, 2.2489850154E+00, 1.6054238059E+00, 2.0958599327E-01, 1.7126675693E-01, 8.6024597614E-01],
	[4.8890000000E+04, 2.2493628596E+00, 1.6054204382E+00, 2.0965162155E-01, 1.7131273214E-01, 8.6026843430E-01],
	[4.8895000000E+04, 2.2497407287E+00, 1.6054170709E+00, 2.0971726366E-01, 1.7135871324E-01, 8.6029088991E-01],
	[4.8900000000E+04, 2.2501186226E+00, 1.6054137039E+00, 2.0978291961E-01, 1.7140470022E-01, 8.6031334298E-01],
	[4.8905000000E+04, 2.2504965413E+00, 1.6054103372E+00, 2.0984858940E-01, 1.7145069309E-01, 8.6033579350E-01],
	[4.8910000000E+04, 2.2508744848E+00, 1.6054069709E+00, 2.0991427302E-01, 1.7149669185E-01, 8.6035824148E-01],
	[4.8915000000E+04, 2.2512524532E+00, 1.6054036050E+00, 2.0997997049E-01, 1.7154269650E-01, 8.6038068691E-01],
	[4.8920000000E+04, 2.2516304464E+00, 1.6054002394E+00, 2.1004568181E-01, 1.7158870703E-01, 8.6040312979E-01],
	[4.8925000000E+04, 2.2520084644E+00, 1.6053968742E+00, 2.1011140697E-01, 1.7163472345E-01, 8.6042557013E-01],
	[4.8930000000E+04, 2.2523865073E+00, 1.6053935093E+00, 2.1017714597E-01, 1.7168074575E-01, 8.6044800792E-01],
	[4.8935000000E+04, 2.2527645750E+00, 1.6053901447E+00, 2.1024289882E-01, 1.7172677393E-01, 8.6047044317E-01],
	[4.8940000000E+04, 2.2531426675E+00, 1.6053867805E+00, 2.1030866552E-01, 1.7177280800E-01, 8.6049287587E-01],
	[4.8945000000E+04, 2.2535207848E+00, 1.6053834167E+00, 2.1037444607E-01, 1.7181884795E-01, 8.6051530602E-01],
	[4.8950000000E+04, 2.2538989269E+00, 1.6053800532E+00, 2.1044024048E-01, 1.7186489377E-01, 8.6053773362E-01],
	[4.8955000000E+04, 2.2542770939E+00, 1.6053766901E+00, 2.1050604874E-01, 1.7191094548E-01, 8.6056015868E-01],
	[4.8960000000E+04, 2.2546552857E+00, 1.6053733273E+00, 2.1057187085E-01, 1.7195700307E-01, 8.6058258119E-01],
	[4.8965000000E+04, 2.2550335022E+00, 1.6053699649E+00, 2.1063770682E-01, 1.7200306654E-01, 8.6060500116E-01],
	[4.8970000000E+04, 2.2554117437E+00, 1.6053666028E+00, 2.1070355665E-01, 1.7204913589E-01, 8.6062741857E-01],
	[4.8975000000E+04, 2.2557900099E+00, 1.6053632410E+00, 2.1076942033E-01, 1.7209521111E-01, 8.6064983344E-01],
	[4.8980000000E+04, 2.2561683009E+00, 1.6053598797E+00, 2.1083529788E-01, 1.7214129221E-01, 8.6067224576E-01],
	[4.8985000000E+04, 2.2565466168E+00, 1.6053565186E+00, 2.1090118929E-01, 1.7218737919E-01, 8.6069465553E-01],
	[4.8990000000E+04, 2.2569249574E+00, 1.6053531579E+00, 2.1096709457E-01, 1.7223347204E-01, 8.6071706275E-01],
	[4.8995000000E+04, 2.2573033229E+00, 1.6053497976E+00, 2.1103301371E-01, 1.7227957076E-01, 8.6073946743E-01],
	[4.9000000000E+04, 2.2576817132E+00, 1.6053464376E+00, 2.1109894672E-01, 1.7232567536E-01, 8.6076186956E-01],
	[4.9005000000E+04, 2.2580601283E+00, 1.6053430780E+00, 2.1116489360E-01, 1.7237178583E-01, 8.6078426914E-01],
	[4.9010000000E+04, 2.2584385682E+00, 1.6053397187E+00, 2.1123085435E-01, 1.7241790218E-01, 8.6080666616E-01],
	[4.9015000000E+04, 2.2588170329E+00, 1.6053363598E+00, 2.1129682897E-01, 1.7246402439E-01, 8.6082906065E-01],
	[4.9020000000E+04, 2.2591955225E+00, 1.6053330012E+00, 2.1136281746E-01, 1.7251015248E-01, 8.6085145258E-01],
	[4.9025000000E+04, 2.2595740368E+00, 1.6053296429E+00, 2.1142881983E-01, 1.7255628643E-01, 8.6087384196E-01],
	[4.9030000000E+04, 2.2599525759E+00, 1.6053262851E+00, 2.1149483607E-01, 1.7260242626E-01, 8.6089622879E-01],
	[4.9035000000E+04, 2.2603311399E+00, 1.6053229275E+00, 2.1156086620E-01, 1.7264857195E-01, 8.6091861308E-01],
	[4.9040000000E+04, 2.2607097286E+00, 1.6053195703E+00, 2.1162691020E-01, 1.7269472351E-01, 8.6094099481E-01],
	[4.9045000000E+04, 2.2610883422E+00, 1.6053162135E+00, 2.1169296808E-01, 1.7274088094E-01, 8.6096337399E-01],
	[4.9050000000E+04, 2.2614669805E+00, 1.6053128570E+00, 2.1175903984E-01, 1.7278704423E-01, 8.6098575063E-01],
	[4.9055000000E+04, 2.2618456437E+00, 1.6053095009E+00, 2.1182512549E-01, 1.7283321339E-01, 8.6100812471E-01],
	[4.9060000000E+04, 2.2622243316E+00, 1.6053061451E+00, 2.1189122502E-01, 1.7287938841E-01, 8.6103049624E-01],
	[4.9065000000E+04, 2.2626030444E+00, 1.6053027896E+00, 2.1195733845E-01, 1.7292556930E-01, 8.6105286523E-01],
	[4.9070000000E+04, 2.2629822719E+00, 1.6052997689E+00, 2.1202346575E-01, 1.7297176280E-01, 8.6107523166E-01],
	[4.9075000000E+04, 2.2633620640E+00, 1.6052971165E+00, 2.1208960695E-01, 1.7301796959E-01, 8.6109759554E-01],
	[4.9080000000E+04, 2.2637418811E+00, 1.6052944643E+00, 2.1215576204E-01, 1.7306418225E-01, 8.6111995687E-01],
	[4.9085000000E+04, 2.2641217232E+00, 1.6052918125E+00, 2.1222193102E-01, 1.7311040079E-01, 8.6114231565E-01],
	[4.9090000000E+04, 2.2645015903E+00, 1.6052891609E+00, 2.1228811390E-01, 1.7315662519E-01, 8.6116467188E-01],
	[4.9095000000E+04, 2.2648814825E+00, 1.6052865096E+00, 2.1235431067E-01, 1.7320285547E-01, 8.6118702556E-01],
	[4.9100000000E+04, 2.2652613997E+00, 1.6052838586E+00, 2.1242052134E-01, 1.7324909162E-01, 8.6120937668E-01],
	[4.9105000000E+04, 2.2656413419E+00, 1.6052812078E+00, 2.1248674591E-01, 1.7329533364E-01, 8.6123172526E-01],
	[4.9110000000E+04, 2.2660213092E+00, 1.6052785574E+00, 2.1255298438E-01, 1.7334158153E-01, 8.6125407128E-01],
	[4.9115000000E+04, 2.2664013015E+00, 1.6052759072E+00, 2.1261923675E-01, 1.7338783528E-01, 8.6127641475E-01],
	[4.9120000000E+04, 2.2667813189E+00, 1.6052732572E+00, 2.1268550303E-01, 1.7343409491E-01, 8.6129875567E-01],
	[4.9125000000E+04, 2.2671613612E+00, 1.6052706076E+00, 2.1275178320E-01, 1.7348036040E-01, 8.6132109404E-01],
	[4.9130000000E+04, 2.2675414286E+00, 1.6052679582E+00, 2.1281807729E-01, 1.7352663175E-01, 8.6134342985E-01],
	[4.9135000000E+04, 2.2679215210E+00, 1.6052653091E+00, 2.1288438528E-01, 1.7357290897E-01, 8.6136576311E-01],
	[4.9140000000E+04, 2.2683016385E+00, 1.6052626603E+00, 2.1295070719E-01, 1.7361919205E-01, 8.6138809382E-01],
	[4.9145000000E+04, 2.2686817810E+00, 1.6052600117E+00, 2.1301704300E-01, 1.7366548100E-01, 8.6141042198E-01],
	[4.9150000000E+04, 2.2690619485E+00, 1.6052573634E+00, 2.1308339272E-01, 1.7371177581E-01, 8.6143274758E-01],
	[4.9155000000E+04, 2.2694421410E+00, 1.6052547154E+00, 2.1314975636E-01, 1.7375807648E-01, 8.6145507063E-01],
	[4.9160000000E+04, 2.2698223585E+00, 1.6052520677E+00, 2.1321613392E-01, 1.7380438302E-01, 8.6147739113E-01],
	[4.9165000000E+04, 2.2702026011E+00, 1.6052494202E+00, 2.1328252539E-01, 1.7385069541E-01, 8.6149970907E-01],
	[4.9170000000E+04, 2.2705828687E+00, 1.6052467730E+00, 2.1334893078E-01, 1.7389701366E-01, 8.6152202446E-01],
	[4.9175000000E+04, 2.2709631613E+00, 1.6052441261E+00, 2.1341535009E-01, 1.7394333778E-01, 8.6154433730E-01],
	[4.9180000000E+04, 2.2713434789E+00, 1.6052414794E+00, 2.1348178332E-01, 1.7398966775E-01, 8.6156664758E-01],
	[4.9185000000E+04, 2.2717238215E+00, 1.6052388331E+00, 2.1354823047E-01, 1.7403600357E-01, 8.6158895531E-01],
	[4.9190000000E+04, 2.2721041892E+00, 1.6052361870E+00, 2.1361469155E-01, 1.7408234526E-01, 8.6161126049E-01],
	[4.9195000000E+04, 2.2724845819E+00, 1.6052335411E+00, 2.1368116656E-01, 1.7412869280E-01, 8.6163356311E-01],
	[4.9200000000E+04, 2.2728649996E+00, 1.6052308956E+00, 2.1374765549E-01, 1.7417504619E-01, 8.6165586318E-01],
	[4.9205000000E+04, 2.2732454423E+00, 1.6052282503E+00, 2.1381415835E-01, 1.7422140544E-01, 8.6167816069E-01],
	[4.9210000000E+04, 2.2736259100E+00, 1.6052256053E+00, 2.1388067514E-01, 1.7426777055E-01, 8.6170045565E-01],
	[4.9215000000E+04, 2.2740064027E+00, 1.6052229606E+00, 2.1394720586E-01, 1.7431414150E-01, 8.6172274805E-01],
	[4.9220000000E+04, 2.2743869205E+00, 1.6052203161E+00, 2.1401375052E-01, 1.7436051831E-01, 8.6174503790E-01],
	[4.9225000000E+04, 2.2747674632E+00, 1.6052176719E+00, 2.1408030911E-01, 1.7440690097E-01, 8.6176732519E-01],
	[4.9230000000E+04, 2.2751480310E+00, 1.6052150280E+00, 2.1414688164E-01, 1.7445328948E-01, 8.6178960993E-01],
	[4.9235000000E+04, 2.2755286237E+00, 1.6052123844E+00, 2.1421346810E-01, 1.7449968384E-01, 8.6181189211E-01],
	[4.9240000000E+04, 2.2759092415E+00, 1.6052097410E+00, 2.1428006850E-01, 1.7454608405E-01, 8.6183417174E-01],
	[4.9245000000E+04, 2.2762898843E+00, 1.6052070979E+00, 2.1434668285E-01, 1.7459249011E-01, 8.6185644881E-01],
	[4.9250000000E+04, 2.2766705521E+00, 1.6052044551E+00, 2.1441331114E-01, 1.7463890201E-01, 8.6187872333E-01],
	[4.9255000000E+04, 2.2770512449E+00, 1.6052018126E+00, 2.1447995337E-01, 1.7468531976E-01, 8.6190099529E-01],
	[4.9260000000E+04, 2.2774319627E+00, 1.6051991703E+00, 2.1454660954E-01, 1.7473174336E-01, 8.6192326469E-01],
	[4.9265000000E+04, 2.2778127055E+00, 1.6051965283E+00, 2.1461327967E-01, 1.7477817280E-01, 8.6194553154E-01],
	[4.9270000000E+04, 2.2781934733E+00, 1.6051938866E+00, 2.1467996374E-01, 1.7482460809E-01, 8.6196779583E-01],
	[4.9275000000E+04, 2.2785742661E+00, 1.6051912451E+00, 2.1474666176E-01, 1.7487104922E-01, 8.6199005757E-01],
	[4.9280000000E+04, 2.2789550840E+00, 1.6051886039E+00, 2.1481337374E-01, 1.7491749620E-01, 8.6201231675E-01],
	[4.9285000000E+04, 2.2793359268E+00, 1.6051859630E+00, 2.1488009966E-01, 1.7496394901E-01, 8.6203457337E-01],
	[4.9290000000E+04, 2.2797167946E+00, 1.6051833224E+00, 2.1494683954E-01, 1.7501040767E-01, 8.6205682744E-01],
	[4.9295000000E+04, 2.2800976874E+00, 1.6051806820E+00, 2.1501359338E-01, 1.7505687217E-01, 8.6207907895E-01],
	[4.9300000000E+04, 2.2804786052E+00, 1.6051780419E+00, 2.1508036117E-01, 1.7510334251E-01, 8.6210132790E-01],
	[4.9305000000E+04, 2.2808595480E+00, 1.6051754021E+00, 2.1514714293E-01, 1.7514981868E-01, 8.6212357429E-01],
	[4.9310000000E+04, 2.2812405158E+00, 1.6051727625E+00, 2.1521393864E-01, 1.7519630070E-01, 8.6214581813E-01],
	[4.9315000000E+04, 2.2816215086E+00, 1.6051701232E+00, 2.1528074831E-01, 1.7524278855E-01, 8.6216805941E-01],
	[4.9320000000E+04, 2.2820025264E+00, 1.6051674842E+00, 2.1534757195E-01, 1.7528928224E-01, 8.6219029813E-01],
	[4.9325000000E+04, 2.2823835692E+00, 1.6051648455E+00, 2.1541440956E-01, 1.7533578177E-01, 8.6221253429E-01],
	[4.9330000000E+04, 2.2827646370E+00, 1.6051622070E+00, 2.1548126112E-01, 1.7538228713E-01, 8.6223476790E-01],
	[4.9335000000E+04, 2.2831457297E+00, 1.6051595688E+00, 2.1554812666E-01, 1.7542879833E-01, 8.6225699895E-01],
	[4.9340000000E+04, 2.2835268475E+00, 1.6051569309E+00, 2.1561500617E-01, 1.7547531536E-01, 8.6227922744E-01],
	[4.9345000000E+04, 2.2839079902E+00, 1.6051542933E+00, 2.1568189965E-01, 1.7552183822E-01, 8.6230145337E-01],
	[4.9350000000E+04, 2.2842891580E+00, 1.6051516559E+00, 2.1574880710E-01, 1.7556836692E-01, 8.6232367674E-01],
	[4.9355000000E+04, 2.2846703507E+00, 1.6051490188E+00, 2.1581572852E-01, 1.7561490144E-01, 8.6234589755E-01],
	[4.9360000000E+04, 2.2850515684E+00, 1.6051463819E+00, 2.1588266392E-01, 1.7566144180E-01, 8.6236811580E-01],
	[4.9365000000E+04, 2.2854328111E+00, 1.6051437454E+00, 2.1594961330E-01, 1.7570798799E-01, 8.6239033149E-01],
	[4.9370000000E+04, 2.2858140788E+00, 1.6051411091E+00, 2.1601657665E-01, 1.7575454001E-01, 8.6241254463E-01],
	[4.9375000000E+04, 2.2861953714E+00, 1.6051384731E+00, 2.1608355399E-01, 1.7580109785E-01, 8.6243475520E-01],
	[4.9380000000E+04, 2.2865766891E+00, 1.6051358373E+00, 2.1615054530E-01, 1.7584766152E-01, 8.6245696321E-01],
	[4.9385000000E+04, 2.2869580317E+00, 1.6051332018E+00, 2.1621755060E-01, 1.7589423102E-01, 8.6247916867E-01],
	[4.9390000000E+04, 2.2873393993E+00, 1.6051305666E+00, 2.1628456989E-01, 1.7594080635E-01, 8.6250137156E-01],
	[4.9395000000E+04, 2.2877207919E+00, 1.6051279317E+00, 2.1635160316E-01, 1.7598738750E-01, 8.6252357189E-01],
	[4.9400000000E+04, 2.2881022095E+00, 1.6051252970E+00, 2.1641865041E-01, 1.7603397448E-01, 8.6254576966E-01],
	[4.9405000000E+04, 2.2884836520E+00, 1.6051226626E+00, 2.1648571166E-01, 1.7608056728E-01, 8.6256796488E-01],
	[4.9410000000E+04, 2.2888651196E+00, 1.6051200285E+00, 2.1655278690E-01, 1.7612716590E-01, 8.6259015753E-01],
	[4.9415000000E+04, 2.2892466121E+00, 1.6051173946E+00, 2.1661987613E-01, 1.7617377035E-01, 8.6261234761E-01],
	[4.9420000000E+04, 2.2896281295E+00, 1.6051147611E+00, 2.1668697935E-01, 1.7622038061E-01, 8.6263453514E-01],
	[4.9425000000E+04, 2.2900096720E+00, 1.6051121277E+00, 2.1675409656E-01, 1.7626699670E-01, 8.6265672011E-01],
	[4.9430000000E+04, 2.2903912394E+00, 1.6051094947E+00, 2.1682122778E-01, 1.7631361861E-01, 8.6267890251E-01],
	[4.9435000000E+04, 2.2907728318E+00, 1.6051068619E+00, 2.1688837299E-01, 1.7636024633E-01, 8.6270108235E-01],
	[4.9440000000E+04, 2.2911544492E+00, 1.6051042294E+00, 2.1695553220E-01, 1.7640687988E-01, 8.6272325963E-01],
	[4.9445000000E+04, 2.2915360915E+00, 1.6051015972E+00, 2.1702270541E-01, 1.7645351924E-01, 8.6274543435E-01],
	[4.9450000000E+04, 2.2919177589E+00, 1.6050989652E+00, 2.1708989263E-01, 1.7650016442E-01, 8.6276760650E-01],
	[4.9455000000E+04, 2.2922994511E+00, 1.6050963336E+00, 2.1715709384E-01, 1.7654681542E-01, 8.6278977609E-01],
	[4.9460000000E+04, 2.2926811684E+00, 1.6050937021E+00, 2.1722430907E-01, 1.7659347223E-01, 8.6281194312E-01],
	[4.9465000000E+04, 2.2930629106E+00, 1.6050910710E+00, 2.1729153830E-01, 1.7664013486E-01, 8.6283410759E-01],
	[4.9470000000E+04, 2.2934446778E+00, 1.6050884401E+00, 2.1735878154E-01, 1.7668680330E-01, 8.6285626949E-01],
	[4.9475000000E+04, 2.2938264700E+00, 1.6050858095E+00, 2.1742603879E-01, 1.7673347755E-01, 8.6287842883E-01],
	[4.9480000000E+04, 2.2942082871E+00, 1.6050831792E+00, 2.1749331005E-01, 1.7678015761E-01, 8.6290058561E-01],
	[4.9485000000E+04, 2.2945901292E+00, 1.6050805491E+00, 2.1756059532E-01, 1.7682684349E-01, 8.6292273982E-01],
	[4.9490000000E+04, 2.2949719962E+00, 1.6050779193E+00, 2.1762789461E-01, 1.7687353518E-01, 8.6294489147E-01],
	[4.9495000000E+04, 2.2953538882E+00, 1.6050752898E+00, 2.1769520791E-01, 1.7692023267E-01, 8.6296704055E-01],
	[4.9500000000E+04, 2.2957358052E+00, 1.6050726605E+00, 2.1776253523E-01, 1.7696693598E-01, 8.6298918707E-01],
	[4.9505000000E+04, 2.2961177472E+00, 1.6050700315E+00, 2.1782987657E-01, 1.7701364510E-01, 8.6301133103E-01],
	[4.9510000000E+04, 2.2964997141E+00, 1.6050674028E+00, 2.1789723194E-01, 1.7706036002E-01, 8.6303347242E-01],
	[4.9515000000E+04, 2.2968817059E+00, 1.6050647744E+00, 2.1796460132E-01, 1.7710708075E-01, 8.6305561124E-01],
	[4.9520000000E+04, 2.2972637227E+00, 1.6050621462E+00, 2.1803198472E-01, 1.7715380728E-01, 8.6307774750E-01],
	[4.9525000000E+04, 2.2976457645E+00, 1.6050595183E+00, 2.1809938216E-01, 1.7720053962E-01, 8.6309988120E-01],
	[4.9530000000E+04, 2.2980278312E+00, 1.6050568907E+00, 2.1816679361E-01, 1.7724727777E-01, 8.6312201233E-01],
	[4.9535000000E+04, 2.2984099229E+00, 1.6050542633E+00, 2.1823421910E-01, 1.7729402172E-01, 8.6314414090E-01],
	[4.9540000000E+04, 2.2987920395E+00, 1.6050516362E+00, 2.1830165862E-01, 1.7734077147E-01, 8.6316626690E-01],
	[4.9545000000E+04, 2.2991741811E+00, 1.6050490094E+00, 2.1836911216E-01, 1.7738752702E-01, 8.6318839033E-01],
	[4.9550000000E+04, 2.2995563477E+00, 1.6050463828E+00, 2.1843657974E-01, 1.7743428838E-01, 8.6321051120E-01],
	[4.9555000000E+04, 2.2999385392E+00, 1.6050437565E+00, 2.1850406135E-01, 1.7748105554E-01, 8.6323262950E-01],
	[4.9560000000E+04, 2.3003207556E+00, 1.6050411305E+00, 2.1857155700E-01, 1.7752782849E-01, 8.6325474524E-01],
	[4.9565000000E+04, 2.3007029970E+00, 1.6050385047E+00, 2.1863906669E-01, 1.7757460725E-01, 8.6327685840E-01],
	[4.9570000000E+04, 2.3010852633E+00, 1.6050358792E+00, 2.1870659041E-01, 1.7762139180E-01, 8.6329896901E-01],
	[4.9575000000E+04, 2.3014675546E+00, 1.6050332540E+00, 2.1877412818E-01, 1.7766818215E-01, 8.6332107704E-01],
	[4.9580000000E+04, 2.3018498709E+00, 1.6050306291E+00, 2.1884167998E-01, 1.7771497830E-01, 8.6334318251E-01],
	[4.9585000000E+04, 2.3022322121E+00, 1.6050280044E+00, 2.1890924583E-01, 1.7776178024E-01, 8.6336528541E-01],
	[4.9590000000E+04, 2.3026145782E+00, 1.6050253800E+00, 2.1897682572E-01, 1.7780858798E-01, 8.6338738575E-01],
	[4.9595000000E+04, 2.3029969693E+00, 1.6050227559E+00, 2.1904441966E-01, 1.7785540152E-01, 8.6340948351E-01],
	[4.9600000000E+04, 2.3033793853E+00, 1.6050201320E+00, 2.1911202765E-01, 1.7790222084E-01, 8.6343157871E-01],
	[4.9605000000E+04, 2.3037618263E+00, 1.6050175084E+00, 2.1917964969E-01, 1.7794904596E-01, 8.6345367135E-01],
	[4.9610000000E+04, 2.3041442922E+00, 1.6050148851E+00, 2.1924728577E-01, 1.7799587688E-01, 8.6347576141E-01],
	[4.9615000000E+04, 2.3045267830E+00, 1.6050122620E+00, 2.1931493591E-01, 1.7804271358E-01, 8.6349784890E-01],
	[4.9620000000E+04, 2.3049092988E+00, 1.6050096392E+00, 2.1938260010E-01, 1.7808955607E-01, 8.6351993383E-01],
	[4.9625000000E+04, 2.3052918395E+00, 1.6050070167E+00, 2.1945027835E-01, 1.7813640436E-01, 8.6354201619E-01],
	[4.9630000000E+04, 2.3056744052E+00, 1.6050043944E+00, 2.1951797065E-01, 1.7818325843E-01, 8.6356409598E-01],
	[4.9635000000E+04, 2.3060569958E+00, 1.6050017724E+00, 2.1958567702E-01, 1.7823011829E-01, 8.6358617320E-01],
	[4.9640000000E+04, 2.3064396114E+00, 1.6049991507E+00, 2.1965339744E-01, 1.7827698394E-01, 8.6360824785E-01],
	[4.9645000000E+04, 2.3068222518E+00, 1.6049965293E+00, 2.1972113192E-01, 1.7832385537E-01, 8.6363031994E-01],
	[4.9650000000E+04, 2.3072049173E+00, 1.6049939081E+00, 2.1978888046E-01, 1.7837073260E-01, 8.6365238945E-01],
	[4.9655000000E+04, 2.3075876076E+00, 1.6049912872E+00, 2.1985664307E-01, 1.7841761560E-01, 8.6367445640E-01],
	[4.9660000000E+04, 2.3079703229E+00, 1.6049886665E+00, 2.1992441975E-01, 1.7846450439E-01, 8.6369652077E-01],
	[4.9665000000E+04, 2.3083530631E+00, 1.6049860461E+00, 2.1999221049E-01, 1.7851139897E-01, 8.6371858258E-01],
	[4.9670000000E+04, 2.3087358282E+00, 1.6049834260E+00, 2.2006001530E-01, 1.7855829932E-01, 8.6374064181E-01],
	[4.9675000000E+04, 2.3091186183E+00, 1.6049808062E+00, 2.2012783418E-01, 1.7860520546E-01, 8.6376269848E-01],
	[4.9680000000E+04, 2.3095014333E+00, 1.6049781866E+00, 2.2019566713E-01, 1.7865211738E-01, 8.6378475257E-01],
	[4.9685000000E+04, 2.3098842733E+00, 1.6049755673E+00, 2.2026351416E-01, 1.7869903508E-01, 8.6380680410E-01],
	[4.9690000000E+04, 2.3102671381E+00, 1.6049729482E+00, 2.2033137526E-01, 1.7874595856E-01, 8.6382885305E-01],
	[4.9695000000E+04, 2.3106500279E+00, 1.6049703295E+00, 2.2039925043E-01, 1.7879288782E-01, 8.6385089944E-01],
	[4.9700000000E+04, 2.3110329426E+00, 1.6049677110E+00, 2.2046713969E-01, 1.7883982286E-01, 8.6387294325E-01],
	[4.9705000000E+04, 2.3114158823E+00, 1.6049650927E+00, 2.2053504302E-01, 1.7888676367E-01, 8.6389498449E-01],
	[4.9710000000E+04, 2.3117988468E+00, 1.6049624748E+00, 2.2060296043E-01, 1.7893371026E-01, 8.6391702316E-01],
	[4.9715000000E+04, 2.3121818363E+00, 1.6049598571E+00, 2.2067089193E-01, 1.7898066263E-01, 8.6393905926E-01],
	[4.9720000000E+04, 2.3125648507E+00, 1.6049572396E+00, 2.2073883751E-01, 1.7902762077E-01, 8.6396109279E-01],
	[4.9725000000E+04, 2.3129478901E+00, 1.6049546225E+00, 2.2080679717E-01, 1.7907458468E-01, 8.6398312374E-01],
	[4.9730000000E+04, 2.3133309543E+00, 1.6049520056E+00, 2.2087477092E-01, 1.7912155437E-01, 8.6400515213E-01],
	[4.9735000000E+04, 2.3137140435E+00, 1.6049493889E+00, 2.2094275876E-01, 1.7916852983E-01, 8.6402717794E-01],
	[4.9740000000E+04, 2.3140971576E+00, 1.6049467726E+00, 2.2101076069E-01, 1.7921551106E-01, 8.6404920118E-01],
	[4.9745000000E+04, 2.3144802966E+00, 1.6049441565E+00, 2.2107877671E-01, 1.7926249807E-01, 8.6407122185E-01],
	[4.9750000000E+04, 2.3148634605E+00, 1.6049415406E+00, 2.2114680682E-01, 1.7930949084E-01, 8.6409323994E-01],
	[4.9755000000E+04, 2.3152466494E+00, 1.6049389251E+00, 2.2121485103E-01, 1.7935648938E-01, 8.6411525546E-01],
	[4.9760000000E+04, 2.3156298631E+00, 1.6049363098E+00, 2.2128290933E-01, 1.7940349370E-01, 8.6413726841E-01],
	[4.9765000000E+04, 2.3160131018E+00, 1.6049336947E+00, 2.2135098173E-01, 1.7945050378E-01, 8.6415927879E-01],
	[4.9770000000E+04, 2.3163963654E+00, 1.6049310800E+00, 2.2141906823E-01, 1.7949751962E-01, 8.6418128659E-01],
	[4.9775000000E+04, 2.3167796539E+00, 1.6049284655E+00, 2.2148716882E-01, 1.7954454123E-01, 8.6420329182E-01],
	[4.9780000000E+04, 2.3171629673E+00, 1.6049258513E+00, 2.2155528352E-01, 1.7959156861E-01, 8.6422529448E-01],
	[4.9785000000E+04, 2.3175463057E+00, 1.6049232373E+00, 2.2162341233E-01, 1.7963860176E-01, 8.6424729457E-01],
	[4.9790000000E+04, 2.3179296689E+00, 1.6049206236E+00, 2.2169155523E-01, 1.7968564066E-01, 8.6426929208E-01],
	[4.9795000000E+04, 2.3183130570E+00, 1.6049180102E+00, 2.2175971225E-01, 1.7973268533E-01, 8.6429128701E-01],
	[4.9800000000E+04, 2.3186964701E+00, 1.6049153970E+00, 2.2182788337E-01, 1.7977973577E-01, 8.6431327937E-01],
	[4.9805000000E+04, 2.3190799081E+00, 1.6049127841E+00, 2.2189606860E-01, 1.7982679196E-01, 8.6433526916E-01],
	[4.9810000000E+04, 2.3194633709E+00, 1.6049101715E+00, 2.2196426794E-01, 1.7987385391E-01, 8.6435725638E-01],
	[4.9815000000E+04, 2.3198468587E+00, 1.6049075591E+00, 2.2203248139E-01, 1.7992092163E-01, 8.6437924101E-01],
	[4.9820000000E+04, 2.3202303714E+00, 1.6049049470E+00, 2.2210070896E-01, 1.7996799510E-01, 8.6440122308E-01],
	[4.9825000000E+04, 2.3206139090E+00, 1.6049023352E+00, 2.2216895064E-01, 1.8001507433E-01, 8.6442320257E-01],
	[4.9830000000E+04, 2.3209974715E+00, 1.6048997236E+00, 2.2223720644E-01, 1.8006215932E-01, 8.6444517948E-01],
	[4.9835000000E+04, 2.3213810588E+00, 1.6048971124E+00, 2.2230547636E-01, 1.8010925007E-01, 8.6446715382E-01],
	[4.9840000000E+04, 2.3217646711E+00, 1.6048945013E+00, 2.2237376039E-01, 1.8015634657E-01, 8.6448912559E-01],
	[4.9845000000E+04, 2.3221483083E+00, 1.6048918906E+00, 2.2244205855E-01, 1.8020344883E-01, 8.6451109478E-01],
	[4.9850000000E+04, 2.3225319704E+00, 1.6048892801E+00, 2.2251037083E-01, 1.8025055684E-01, 8.6453306139E-01],
	[4.9855000000E+04, 2.3229156574E+00, 1.6048866698E+00, 2.2257869724E-01, 1.8029767061E-01, 8.6455502543E-01],
	[4.9860000000E+04, 2.3232998953E+00, 1.6048844001E+00, 2.2264703777E-01, 1.8034479759E-01, 8.6457698689E-01],
	[4.9865000000E+04, 2.3236847022E+00, 1.6048824824E+00, 2.2271539242E-01, 1.8039193806E-01, 8.6459894578E-01],
	[4.9870000000E+04, 2.3240695342E+00, 1.6048805650E+00, 2.2278376121E-01, 1.8043908428E-01, 8.6462090209E-01],
	[4.9875000000E+04, 2.3244543914E+00, 1.6048786477E+00, 2.2285214413E-01, 1.8048623628E-01, 8.6464285582E-01],
	[4.9880000000E+04, 2.3248392737E+00, 1.6048767306E+00, 2.2292054118E-01, 1.8053339403E-01, 8.6466480698E-01],
	[4.9885000000E+04, 2.3252241812E+00, 1.6048748137E+00, 2.2298895236E-01, 1.8058055754E-01, 8.6468675556E-01],
	[4.9890000000E+04, 2.3256091138E+00, 1.6048728970E+00, 2.2305737767E-01, 1.8062772682E-01, 8.6470870156E-01],
	[4.9895000000E+04, 2.3259940715E+00, 1.6048709805E+00, 2.2312581713E-01, 1.8067490185E-01, 8.6473064499E-01],
	[4.9900000000E+04, 2.3263790544E+00, 1.6048690642E+00, 2.2319427072E-01, 1.8072208265E-01, 8.6475258584E-01],
	[4.9905000000E+04, 2.3267640624E+00, 1.6048671481E+00, 2.2326273845E-01, 1.8076926920E-01, 8.6477452411E-01],
	[4.9910000000E+04, 2.3271490955E+00, 1.6048652322E+00, 2.2333122032E-01, 1.8081646151E-01, 8.6479645981E-01],
	[4.9915000000E+04, 2.3275341538E+00, 1.6048633165E+00, 2.2339971633E-01, 1.8086365957E-01, 8.6481839293E-01],
	[4.9920000000E+04, 2.3279192372E+00, 1.6048614010E+00, 2.2346822648E-01, 1.8091086339E-01, 8.6484032347E-01],
	[4.9925000000E+04, 2.3283043458E+00, 1.6048594856E+00, 2.2353675079E-01, 1.8095807297E-01, 8.6486225143E-01],
	[4.9930000000E+04, 2.3286894795E+00, 1.6048575705E+00, 2.2360528923E-01, 1.8100528830E-01, 8.6488417682E-01],
	[4.9935000000E+04, 2.3290746383E+00, 1.6048556556E+00, 2.2367384183E-01, 1.8105250938E-01, 8.6490609962E-01],
	[4.9940000000E+04, 2.3294598222E+00, 1.6048537408E+00, 2.2374240858E-01, 1.8109973622E-01, 8.6492801985E-01],
	[4.9945000000E+04, 2.3298450313E+00, 1.6048518262E+00, 2.2381098947E-01, 1.8114696880E-01, 8.6494993750E-01],
	[4.9950000000E+04, 2.3302302655E+00, 1.6048499119E+00, 2.2387958453E-01, 1.8119420714E-01, 8.6497185258E-01],
	[4.9955000000E+04, 2.3306155248E+00, 1.6048479977E+00, 2.2394819373E-01, 1.8124145123E-01, 8.6499376507E-01],
	[4.9960000000E+04, 2.3310008093E+00, 1.6048460837E+00, 2.2401681709E-01, 1.8128870106E-01, 8.6501567499E-01],
	[4.9965000000E+04, 2.3313861189E+00, 1.6048441700E+00, 2.2408545461E-01, 1.8133595665E-01, 8.6503758232E-01],
	[4.9970000000E+04, 2.3317714536E+00, 1.6048422564E+00, 2.2415410628E-01, 1.8138321798E-01, 8.6505948708E-01],
	[4.9975000000E+04, 2.3321568134E+00, 1.6048403430E+00, 2.2422277212E-01, 1.8143048506E-01, 8.6508138926E-01],
	[4.9980000000E+04, 2.3325421984E+00, 1.6048384298E+00, 2.2429145212E-01, 1.8147775789E-01, 8.6510328885E-01],
	[4.9985000000E+04, 2.3329276084E+00, 1.6048365168E+00, 2.2436014628E-01, 1.8152503646E-01, 8.6512518587E-01],
	[4.9990000000E+04, 2.3333130437E+00, 1.6048346040E+00, 2.2442885461E-01, 1.8157232078E-01, 8.6514708031E-01],
	[4.9995000000E+04, 2.3336985040E+00, 1.6048326914E+00, 2.2449757710E-01, 1.8161961083E-01, 8.6516897217E-01],
	[5.0000000000E+04, 2.3340839894E+00, 1.6048307789E+00, 2.2456631376E-01, 1.8166690664E-01, 8.6519086145E-01],
	[5.0005000000E+04, 2.3344695000E+00, 1.6048288667E+00, 2.2463552027E-01, 1.8171450637E-01, 8.6521274815E-01],
	[5.0010000000E+04, 2.3348550357E+00, 1.6048269547E+00, 2.2470474119E-01, 1.8176211194E-01, 8.6523463227E-01],
	[5.0015000000E+04, 2.3352405965E+00, 1.6048250428E+00, 2.2477397652E-01, 1.8180972334E-01, 8.6525651381E-01],
	[5.0020000000E+04, 2.3356261824E+00, 1.6048231312E+00, 2.2484322625E-01, 1.8185734059E-01, 8.6527839277E-01],
	[5.0025000000E+04, 2.3360117934E+00, 1