import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

red_marrow_Woodard_MFP = np.array([
	[5.0000000000E+03, 2.1232329795E+00, 7.3728219771E+00, 2.9976006333E-02, 2.9440662056E-02, 3.3912941964E-01],
	[5.0050000000E+03, 2.1256511824E+00, 7.3697584051E+00, 3.0066787200E-02, 2.9528642632E-02, 3.3938412637E-01],
	[5.0100000000E+03, 2.1280697208E+00, 7.3666991631E+00, 3.0157751537E-02, 2.9616794687E-02, 3.3963859039E-01],
	[5.0150000000E+03, 2.1304885943E+00, 7.3636442408E+00, 3.0248899529E-02, 2.9705118367E-02, 3.3989281233E-01],
	[5.0200000000E+03, 2.1329078027E+00, 7.3605936277E+00, 3.0340231362E-02, 2.9793613816E-02, 3.4014679279E-01],
	[5.0250000000E+03, 2.1353273457E+00, 7.3575473134E+00, 3.0431747222E-02, 2.9882281181E-02, 3.4040053242E-01],
	[5.0300000000E+03, 2.1377472230E+00, 7.3545052877E+00, 3.0523447295E-02, 2.9971120606E-02, 3.4065403182E-01],
	[5.0350000000E+03, 2.1401674343E+00, 7.3514675403E+00, 3.0615331767E-02, 3.0060132237E-02, 3.4090729162E-01],
	[5.0400000000E+03, 2.1425879793E+00, 7.3484340608E+00, 3.0707400823E-02, 3.0149316220E-02, 3.4116031242E-01],
	[5.0450000000E+03, 2.1450088578E+00, 7.3454048391E+00, 3.0799654649E-02, 3.0238672698E-02, 3.4141309485E-01],
	[5.0500000000E+03, 2.1474300694E+00, 7.3423798650E+00, 3.0892093432E-02, 3.0328201818E-02, 3.4166563951E-01],
	[5.0550000000E+03, 2.1498516139E+00, 7.3393591284E+00, 3.0984717356E-02, 3.0417903723E-02, 3.4191794702E-01],
	[5.0600000000E+03, 2.1522734909E+00, 7.3363426190E+00, 3.1077526608E-02, 3.0507778559E-02, 3.4217001797E-01],
	[5.0650000000E+03, 2.1546957003E+00, 7.3333303269E+00, 3.1170521373E-02, 3.0597826470E-02, 3.4242185298E-01],
	[5.0700000000E+03, 2.1571182417E+00, 7.3303222420E+00, 3.1263701838E-02, 3.0688047601E-02, 3.4267345264E-01],
	[5.0750000000E+03, 2.1595411148E+00, 7.3273183542E+00, 3.1357068189E-02, 3.0778442097E-02, 3.4292481756E-01],
	[5.0800000000E+03, 2.1619643194E+00, 7.3243186536E+00, 3.1450620610E-02, 3.0869010101E-02, 3.4317594834E-01],
	[5.0850000000E+03, 2.1644007615E+00, 7.3213630500E+00, 3.1544359288E-02, 3.0959755112E-02, 3.4342684557E-01],
	[5.0900000000E+03, 2.1668388042E+00, 7.3184154134E+00, 3.1638284409E-02, 3.1050674278E-02, 3.4367750985E-01],
	[5.0950000000E+03, 2.1692771955E+00, 7.3154718559E+00, 3.1732396158E-02, 3.1141767420E-02, 3.4392794176E-01],
	[5.1000000000E+03, 2.1717159350E+00, 7.3125323679E+00, 3.1826694721E-02, 3.1233034680E-02, 3.4417814191E-01],
	[5.1050000000E+03, 2.1741550223E+00, 7.3095969397E+00, 3.1921180285E-02, 3.1324476203E-02, 3.4442811088E-01],
	[5.1100000000E+03, 2.1765944572E+00, 7.3066655618E+00, 3.2015853034E-02, 3.1416092134E-02, 3.4467784925E-01],
	[5.1150000000E+03, 2.1790342395E+00, 7.3037382246E+00, 3.2110713156E-02, 3.1507882615E-02, 3.4492735761E-01],
	[5.1200000000E+03, 2.1814743688E+00, 7.3008149186E+00, 3.2205760834E-02, 3.1599847791E-02, 3.4517663654E-01],
	[5.1250000000E+03, 2.1839148448E+00, 7.2978956344E+00, 3.2300996257E-02, 3.1691987805E-02, 3.4542568663E-01],
	[5.1300000000E+03, 2.1863556673E+00, 7.2949803624E+00, 3.2396419608E-02, 3.1784302801E-02, 3.4567450845E-01],
	[5.1350000000E+03, 2.1887968359E+00, 7.2920690933E+00, 3.2492031074E-02, 3.1876792922E-02, 3.4592310258E-01],
	[5.1400000000E+03, 2.1912383503E+00, 7.2891618177E+00, 3.2587830842E-02, 3.1969458312E-02, 3.4617146960E-01],
	[5.1450000000E+03, 2.1936802104E+00, 7.2862585263E+00, 3.2683819096E-02, 3.2062299113E-02, 3.4641961007E-01],
	[5.1500000000E+03, 2.1961224157E+00, 7.2833592096E+00, 3.2779996022E-02, 3.2155315469E-02, 3.4666752457E-01],
	[5.1550000000E+03, 2.1985649661E+00, 7.2804638584E+00, 3.2876361807E-02, 3.2248507523E-02, 3.4691521378E-01],
	[5.1600000000E+03, 2.2010078612E+00, 7.2775724635E+00, 3.2972916635E-02, 3.2341875418E-02, 3.4716267838E-01],
	[5.1650000000E+03, 2.2034586929E+00, 7.2747084540E+00, 3.3069660694E-02, 3.2435421407E-02, 3.4740991900E-01],
	[5.1700000000E+03, 2.2059159973E+00, 7.2718672029E+00, 3.3166594168E-02, 3.2529145249E-02, 3.4765693627E-01],
	[5.1750000000E+03, 2.2083736628E+00, 7.2690298063E+00, 3.3263717244E-02, 3.2623045395E-02, 3.4790373081E-01],
	[5.1800000000E+03, 2.2108316890E+00, 7.2661962554E+00, 3.3361030107E-02, 3.2717121987E-02, 3.4815030326E-01],
	[5.1850000000E+03, 2.2132900758E+00, 7.2633665413E+00, 3.3458532944E-02, 3.2811375168E-02, 3.4839665422E-01],
	[5.1900000000E+03, 2.2157488226E+00, 7.2605406549E+00, 3.3556225939E-02, 3.2905805080E-02, 3.4864278432E-01],
	[5.1950000000E+03, 2.2182079294E+00, 7.2577185876E+00, 3.3654109279E-02, 3.3000411865E-02, 3.4888869418E-01],
	[5.2000000000E+03, 2.2206673958E+00, 7.2549003303E+00, 3.3752183150E-02, 3.3095195666E-02, 3.4913438441E-01],
	[5.2050000000E+03, 2.2231272214E+00, 7.2520858745E+00, 3.3850447737E-02, 3.3190156626E-02, 3.4937985562E-01],
	[5.2100000000E+03, 2.2255874061E+00, 7.2492752112E+00, 3.3948903226E-02, 3.3285294885E-02, 3.4962510843E-01],
	[5.2150000000E+03, 2.2280479495E+00, 7.2464683317E+00, 3.4047549803E-02, 3.3380610586E-02, 3.4987014344E-01],
	[5.2200000000E+03, 2.2305088513E+00, 7.2436652274E+00, 3.4146387654E-02, 3.3476103872E-02, 3.5011496126E-01],
	[5.2250000000E+03, 2.2329701112E+00, 7.2408658895E+00, 3.4245416964E-02, 3.3571774882E-02, 3.5035956249E-01],
	[5.2300000000E+03, 2.2354317290E+00, 7.2380703093E+00, 3.4344637920E-02, 3.3667623761E-02, 3.5060394773E-01],
	[5.2350000000E+03, 2.2378937043E+00, 7.2352784783E+00, 3.4444050707E-02, 3.3763650648E-02, 3.5084811759E-01],
	[5.2400000000E+03, 2.2403560369E+00, 7.2324903879E+00, 3.4543655512E-02, 3.3859855685E-02, 3.5109207267E-01],
	[5.2450000000E+03, 2.2428187265E+00, 7.2297060294E+00, 3.4643452519E-02, 3.3956239014E-02, 3.5133581355E-01],
	[5.2500000000E+03, 2.2452941442E+00, 7.2269635128E+00, 3.4743441914E-02, 3.4052804468E-02, 3.5157934083E-01],
	[5.2550000000E+03, 2.2477708240E+00, 7.2242273849E+00, 3.4843623884E-02, 3.4149548795E-02, 3.5182265510E-01],
	[5.2600000000E+03, 2.2502478765E+00, 7.2214948936E+00, 3.4943998615E-02, 3.4246471873E-02, 3.5206575696E-01],
	[5.2650000000E+03, 2.2527253013E+00, 7.2187660306E+00, 3.5044566291E-02, 3.4343573843E-02, 3.5230864698E-01],
	[5.2700000000E+03, 2.2552030981E+00, 7.2160407875E+00, 3.5145327099E-02, 3.4440854845E-02, 3.5255132577E-01],
	[5.2750000000E+03, 2.2576812667E+00, 7.2133191563E+00, 3.5246281225E-02, 3.4538315020E-02, 3.5279379389E-01],
	[5.2800000000E+03, 2.2601598068E+00, 7.2106011285E+00, 3.5347428854E-02, 3.4635954510E-02, 3.5303605193E-01],
	[5.2850000000E+03, 2.2626387180E+00, 7.2078866962E+00, 3.5448770172E-02, 3.4733773454E-02, 3.5327810047E-01],
	[5.2900000000E+03, 2.2651180000E+00, 7.2051758511E+00, 3.5550305366E-02, 3.4831771994E-02, 3.5351994008E-01],
	[5.2950000000E+03, 2.2675976526E+00, 7.2024685852E+00, 3.5652034620E-02, 3.4929950270E-02, 3.5376157135E-01],
	[5.3000000000E+03, 2.2700776755E+00, 7.1997648902E+00, 3.5753958121E-02, 3.5028308423E-02, 3.5400299485E-01],
	[5.3050000000E+03, 2.2725580683E+00, 7.1970647582E+00, 3.5856076054E-02, 3.5126846592E-02, 3.5424421114E-01],
	[5.3100000000E+03, 2.2750388308E+00, 7.1943681811E+00, 3.5958388606E-02, 3.5225564918E-02, 3.5448522080E-01],
	[5.3150000000E+03, 2.2775199627E+00, 7.1916751508E+00, 3.6060895961E-02, 3.5324463541E-02, 3.5472602439E-01],
	[5.3200000000E+03, 2.2800014637E+00, 7.1889856595E+00, 3.6163598306E-02, 3.5423542601E-02, 3.5496662249E-01],
	[5.3250000000E+03, 2.2824833335E+00, 7.1862996990E+00, 3.6266495827E-02, 3.5522802238E-02, 3.5520701564E-01],
	[5.3300000000E+03, 2.2849661397E+00, 7.1836190132E+00, 3.6369588709E-02, 3.5622242772E-02, 3.5544720443E-01],
	[5.3350000000E+03, 2.2874615582E+00, 7.1809795499E+00, 3.6472877139E-02, 3.5721868083E-02, 3.5568718940E-01],
	[5.3400000000E+03, 2.2899573606E+00, 7.1783435277E+00, 3.6576361301E-02, 3.5821674425E-02, 3.5592697112E-01],
	[5.3450000000E+03, 2.2924535464E+00, 7.1757109388E+00, 3.6680041383E-02, 3.5921661939E-02, 3.5616655013E-01],
	[5.3500000000E+03, 2.2949501155E+00, 7.1730817755E+00, 3.6783917568E-02, 3.6021830763E-02, 3.5640592701E-01],
	[5.3550000000E+03, 2.2974470674E+00, 7.1704560301E+00, 3.6887990044E-02, 3.6122181037E-02, 3.5664510229E-01],
	[5.3600000000E+03, 2.2999444020E+00, 7.1678336952E+00, 3.6992258997E-02, 3.6222712901E-02, 3.5688407653E-01],
	[5.3650000000E+03, 2.3024421188E+00, 7.1652147630E+00, 3.7096724611E-02, 3.6323426493E-02, 3.5712285027E-01],
	[5.3700000000E+03, 2.3049402177E+00, 7.1625992260E+00, 3.7201387073E-02, 3.6424321953E-02, 3.5736142408E-01],
	[5.3750000000E+03, 2.3074386982E+00, 7.1599870765E+00, 3.7306246568E-02, 3.6525399420E-02, 3.5759979848E-01],
	[5.3800000000E+03, 2.3099375602E+00, 7.1573783072E+00, 3.7411303283E-02, 3.6626659032E-02, 3.5783797403E-01],
	[5.3850000000E+03, 2.3124368033E+00, 7.1547729104E+00, 3.7516557403E-02, 3.6728100928E-02, 3.5807595127E-01],
	[5.3900000000E+03, 2.3149364271E+00, 7.1521708788E+00, 3.7622009113E-02, 3.6829725247E-02, 3.5831373073E-01],
	[5.3950000000E+03, 2.3174364315E+00, 7.1495722047E+00, 3.7727658600E-02, 3.6931532128E-02, 3.5855131295E-01],
	[5.4000000000E+03, 2.3199368162E+00, 7.1469768808E+00, 3.7833506050E-02, 3.7033521708E-02, 3.5878869848E-01],
	[5.4050000000E+03, 2.3224375807E+00, 7.1443848997E+00, 3.7939551648E-02, 3.7135694127E-02, 3.5902588784E-01],
	[5.4100000000E+03, 2.3249387249E+00, 7.1417962540E+00, 3.8045795580E-02, 3.7238049522E-02, 3.5926288157E-01],
	[5.4150000000E+03, 2.3274402485E+00, 7.1392109363E+00, 3.8152238032E-02, 3.7340588032E-02, 3.5949968021E-01],
	[5.4200000000E+03, 2.3299530753E+00, 7.1366626302E+00, 3.8258879189E-02, 3.7443313543E-02, 3.5973628427E-01],
	[5.4250000000E+03, 2.3324677298E+00, 7.1341220030E+00, 3.8365719238E-02, 3.7546222971E-02, 3.5997269429E-01],
	[5.4300000000E+03, 2.3349827780E+00, 7.1315846196E+00, 3.8472758363E-02, 3.7649315965E-02, 3.6020891079E-01],
	[5.4350000000E+03, 2.3374982195E+00, 7.1290504728E+00, 3.8579996752E-02, 3.7752592661E-02, 3.6044493431E-01],
	[5.4400000000E+03, 2.3400140541E+00, 7.1265195555E+00, 3.8687434589E-02, 3.7856053198E-02, 3.6068076535E-01],
	[5.4450000000E+03, 2.3425302815E+00, 7.1239918606E+00, 3.8795072061E-02, 3.7959697713E-02, 3.6091640445E-01],
	[5.4500000000E+03, 2.3450469013E+00, 7.1214673811E+00, 3.8902909353E-02, 3.8063526344E-02, 3.6115185212E-01],
	[5.4550000000E+03, 2.3475639133E+00, 7.1189461099E+00, 3.9010946651E-02, 3.8167539229E-02, 3.6138710888E-01],
	[5.4600000000E+03, 2.3500813172E+00, 7.1164280400E+00, 3.9119184141E-02, 3.8271736504E-02, 3.6162217525E-01],
	[5.4650000000E+03, 2.3525991126E+00, 7.1139131644E+00, 3.9227622008E-02, 3.8376118307E-02, 3.6185705176E-01],
	[5.4700000000E+03, 2.3551172993E+00, 7.1114014762E+00, 3.9336260439E-02, 3.8480684775E-02, 3.6209173903E-01],
	[5.4750000000E+03, 2.3576358769E+00, 7.1088929684E+00, 3.9445099619E-02, 3.8585436045E-02, 3.6232623761E-01],
	[5.4800000000E+03, 2.3601548453E+00, 7.1063876341E+00, 3.9554505251E-02, 3.8690721981E-02, 3.6256054803E-01],
	[5.4850000000E+03, 2.3626742040E+00, 7.1038854663E+00, 3.9664408662E-02, 3.8796476748E-02, 3.6279467085E-01],
	[5.4900000000E+03, 2.3651939528E+00, 7.1013864582E+00, 3.9774516468E-02, 3.8902419568E-02, 3.6302860660E-01],
	[5.4950000000E+03, 2.3677140913E+00, 7.0988906030E+00, 3.9884828862E-02, 3.9008550583E-02, 3.6326235582E-01],
	[5.5000000000E+03, 2.3702346194E+00, 7.0963978938E+00, 3.9995346036E-02, 3.9114869935E-02, 3.6349591905E-01],
	[5.5050000000E+03, 2.3727608599E+00, 7.0939247911E+00, 4.0106068182E-02, 3.9221379724E-02, 3.6372929684E-01],
	[5.5100000000E+03, 2.3752940793E+00, 7.0914751322E+00, 4.0216995493E-02, 3.9328080579E-02, 3.6396248970E-01],
	[5.5150000000E+03, 2.3778277019E+00, 7.0890285399E+00, 4.0328128161E-02, 3.9434970234E-02, 3.6419549817E-01],
	[5.5200000000E+03, 2.3803617273E+00, 7.0865850076E+00, 4.0439466377E-02, 3.9542048828E-02, 3.6442832279E-01],
	[5.5250000000E+03, 2.3828961553E+00, 7.0841445289E+00, 4.0551010335E-02, 3.9649316504E-02, 3.6466096407E-01],
	[5.5300000000E+03, 2.3854309855E+00, 7.0817070970E+00, 4.0662760225E-02, 3.9756773402E-02, 3.6489342256E-01],
	[5.5350000000E+03, 2.3879662177E+00, 7.0792727055E+00, 4.0774716242E-02, 3.9864419664E-02, 3.6512569877E-01],
	[5.5400000000E+03, 2.3905018515E+00, 7.0768413478E+00, 4.0886878576E-02, 3.9972255430E-02, 3.6535779323E-01],
	[5.5450000000E+03, 2.3930378866E+00, 7.0744130173E+00, 4.0999247420E-02, 4.0080280842E-02, 3.6558970645E-01],
	[5.5500000000E+03, 2.3955743228E+00, 7.0719877077E+00, 4.1111822967E-02, 4.0188496039E-02, 3.6582143896E-01],
	[5.5550000000E+03, 2.3981111598E+00, 7.0695654124E+00, 4.1224605407E-02, 4.0296901163E-02, 3.6605299128E-01],
	[5.5600000000E+03, 2.4006483972E+00, 7.0671461249E+00, 4.1337594935E-02, 4.0405496353E-02, 3.6628436393E-01],
	[5.5650000000E+03, 2.4031860347E+00, 7.0647298389E+00, 4.1450791741E-02, 4.0514281751E-02, 3.6651555741E-01],
	[5.5700000000E+03, 2.4057240721E+00, 7.0623165479E+00, 4.1564196019E-02, 4.0623257497E-02, 3.6674657224E-01],
	[5.5750000000E+03, 2.4082625091E+00, 7.0599062455E+00, 4.1677807960E-02, 4.0732423729E-02, 3.6697740894E-01],
	[5.5800000000E+03, 2.4108013453E+00, 7.0574989254E+00, 4.1791627756E-02, 4.0841780590E-02, 3.6720806801E-01],
	[5.5850000000E+03, 2.4133405805E+00, 7.0550945811E+00, 4.1905655601E-02, 4.0951328218E-02, 3.6743854997E-01],
	[5.5900000000E+03, 2.4158802143E+00, 7.0526932064E+00, 4.2019891685E-02, 4.1061066753E-02, 3.6766885531E-01],
	[5.5950000000E+03, 2.4184286033E+00, 7.0503207388E+00, 4.2134336202E-02, 4.1170999642E-02, 3.6789898455E-01],
	[5.6000000000E+03, 2.4209804960E+00, 7.0479607843E+00, 4.2248989343E-02, 4.1281124974E-02, 3.6812893818E-01],
	[5.6050000000E+03, 2.4235328004E+00, 7.0456037248E+00, 4.2363851302E-02, 4.1391441671E-02, 3.6835871672E-01],
	[5.6100000000E+03, 2.4260855161E+00, 7.0432495542E+00, 4.2478922269E-02, 4.1501949871E-02, 3.6858832066E-01],
	[5.6150000000E+03, 2.4286386429E+00, 7.0408982665E+00, 4.2594202438E-02, 4.1612649715E-02, 3.6881775049E-01],
	[5.6200000000E+03, 2.4311921805E+00, 7.0385498554E+00, 4.2709692001E-02, 4.1723541342E-02, 3.6904700672E-01],
	[5.6250000000E+03, 2.4337461285E+00, 7.0362043150E+00, 4.2825391149E-02, 4.1834624890E-02, 3.6927608985E-01],
	[5.6300000000E+03, 2.4363004866E+00, 7.0338616392E+00, 4.2941300076E-02, 4.1945900499E-02, 3.6950500036E-01],
	[5.6350000000E+03, 2.4388552547E+00, 7.0315218220E+00, 4.3057418973E-02, 4.2057368307E-02, 3.6973373875E-01],
	[5.6400000000E+03, 2.4414104322E+00, 7.0291848573E+00, 4.3173748033E-02, 4.2169028455E-02, 3.6996230551E-01],
	[5.6450000000E+03, 2.4439660191E+00, 7.0268507391E+00, 4.3290287448E-02, 4.2280881079E-02, 3.7019070113E-01],
	[5.6500000000E+03, 2.4465220149E+00, 7.0245194614E+00, 4.3407037411E-02, 4.2392926320E-02, 3.7041892610E-01],
	[5.6550000000E+03, 2.4490784194E+00, 7.0221910184E+00, 4.3523998113E-02, 4.2505164315E-02, 3.7064698091E-01],
	[5.6600000000E+03, 2.4516352323E+00, 7.0198654040E+00, 4.3641169746E-02, 4.2617595203E-02, 3.7087486603E-01],
	[5.6650000000E+03, 2.4541924532E+00, 7.0175426122E+00, 4.3758552504E-02, 4.2730219122E-02, 3.7110258196E-01],
	[5.6700000000E+03, 2.4567500819E+00, 7.0152226373E+00, 4.3876146579E-02, 4.2843036210E-02, 3.7133012917E-01],
	[5.6750000000E+03, 2.4593081181E+00, 7.0129054732E+00, 4.3993952162E-02, 4.2956046605E-02, 3.7155750815E-01],
	[5.6800000000E+03, 2.4618665616E+00, 7.0105911142E+00, 4.4111969446E-02, 4.3069250446E-02, 3.7178471938E-01],
	[5.6850000000E+03, 2.4644334068E+00, 7.0083045146E+00, 4.4230198624E-02, 4.3182651272E-02, 3.7201176333E-01],
	[5.6900000000E+03, 2.4670036694E+00, 7.0060300267E+00, 4.4348639887E-02, 4.3296247128E-02, 3.7223864048E-01],
	[5.6950000000E+03, 2.4695743515E+00, 7.0037582737E+00, 4.4467293428E-02, 4.3410036882E-02, 3.7246535130E-01],
	[5.7000000000E+03, 2.4721454527E+00, 7.0014892500E+00, 4.4586159440E-02, 4.3524020671E-02, 3.7269189627E-01],
	[5.7050000000E+03, 2.4747169730E+00, 6.9992229500E+00, 4.4705238114E-02, 4.3638198632E-02, 3.7291827586E-01],
	[5.7100000000E+03, 2.4772889118E+00, 6.9969593679E+00, 4.4824529643E-02, 4.3752570904E-02, 3.7314449055E-01],
	[5.7150000000E+03, 2.4798612689E+00, 6.9946984982E+00, 4.4944034219E-02, 4.3867137623E-02, 3.7337054079E-01],
	[5.7200000000E+03, 2.4824340441E+00, 6.9924403353E+00, 4.5063752035E-02, 4.3981898926E-02, 3.7359642706E-01],
	[5.7250000000E+03, 2.4850072370E+00, 6.9901848734E+00, 4.5183683282E-02, 4.4096854951E-02, 3.7382214982E-01],
	[5.7300000000E+03, 2.4875808474E+00, 6.9879321071E+00, 4.5303828154E-02, 4.4212005834E-02, 3.7404770954E-01],
	[5.7350000000E+03, 2.4901548748E+00, 6.9856820307E+00, 4.5424221066E-02, 4.4327384303E-02, 3.7427310669E-01],
	[5.7400000000E+03, 2.4927293191E+00, 6.9834346388E+00, 4.5544867163E-02, 4.4442995202E-02, 3.7449834172E-01],
	[5.7450000000E+03, 2.4953041799E+00, 6.9811899258E+00, 4.5665727834E-02, 4.4558801711E-02, 3.7472341509E-01],
	[5.7500000000E+03, 2.4978794570E+00, 6.9789478861E+00, 4.5786803273E-02, 4.4674803969E-02, 3.7494832727E-01],
	[5.7550000000E+03, 2.5004551501E+00, 6.9767085143E+00, 4.5908093672E-02, 4.4791002111E-02, 3.7517307872E-01],
	[5.7600000000E+03, 2.5030312587E+00, 6.9744718048E+00, 4.6029599226E-02, 4.4907396275E-02, 3.7539766989E-01],
	[5.7650000000E+03, 2.5056077828E+00, 6.9722377522E+00, 4.6151320126E-02, 4.5023986598E-02, 3.7562210132E-01],
	[5.7700000000E+03, 2.5081847219E+00, 6.9700063511E+00, 4.6273256568E-02, 4.5140773216E-02, 3.7584637346E-01],
	[5.7750000000E+03, 2.5107666556E+00, 6.9677920063E+00, 4.6395408743E-02, 4.5257758363E-02, 3.7607048679E-01],
	[5.7800000000E+03, 2.5133549674E+00, 6.9655990026E+00, 4.6517776845E-02, 4.5374942832E-02, 3.7629444177E-01],
	[5.7850000000E+03, 2.5159437059E+00, 6.9634085843E+00, 4.6640361068E-02, 4.5492324046E-02, 3.7651823887E-01],
	[5.7900000000E+03, 2.5185328708E+00, 6.9612207464E+00, 4.6763161604E-02, 4.5609902141E-02, 3.7674187854E-01],
	[5.7950000000E+03, 2.5211224619E+00, 6.9590354835E+00, 4.6886178647E-02, 4.5727677255E-02, 3.7696536126E-01],
	[5.8000000000E+03, 2.5237124788E+00, 6.9568527903E+00, 4.7009412390E-02, 4.5845649522E-02, 3.7718868748E-01],
	[5.8050000000E+03, 2.5263029213E+00, 6.9546726617E+00, 4.7132863027E-02, 4.5963819079E-02, 3.7741185765E-01],
	[5.8100000000E+03, 2.5288937890E+00, 6.9524950924E+00, 4.7256530751E-02, 4.6082186063E-02, 3.7763487225E-01],
	[5.8150000000E+03, 2.5314850816E+00, 6.9503200772E+00, 4.7380415754E-02, 4.6200750609E-02, 3.7785773171E-01],
	[5.8200000000E+03, 2.5340767989E+00, 6.9481476109E+00, 4.7504518232E-02, 4.6319512853E-02, 3.7808043650E-01],
	[5.8250000000E+03, 2.5366689406E+00, 6.9459776884E+00, 4.7628838375E-02, 4.6438472930E-02, 3.7830298707E-01],
	[5.8300000000E+03, 2.5392615063E+00, 6.9438103045E+00, 4.7753376379E-02, 4.6557630977E-02, 3.7852538387E-01],
	[5.8350000000E+03, 2.5418544958E+00, 6.9416454541E+00, 4.7878132436E-02, 4.6676987128E-02, 3.7874762735E-01],
	[5.8400000000E+03, 2.5444479088E+00, 6.9394831319E+00, 4.8003106739E-02, 4.6796541519E-02, 3.7896971797E-01],
	[5.8450000000E+03, 2.5470417450E+00, 6.9373233330E+00, 4.8128299483E-02, 4.6916294285E-02, 3.7919165616E-01],
	[5.8500000000E+03, 2.5496360040E+00, 6.9351660522E+00, 4.8253710859E-02, 4.7036245562E-02, 3.7941344238E-01],
	[5.8550000000E+03, 2.5522306857E+00, 6.9330112844E+00, 4.8379341063E-02, 4.7156395483E-02, 3.7963507707E-01],
	[5.8600000000E+03, 2.5548257896E+00, 6.9308590246E+00, 4.8505190286E-02, 4.7276744185E-02, 3.7985656067E-01],
	[5.8650000000E+03, 2.5574213156E+00, 6.9287092676E+00, 4.8631258722E-02, 4.7397291801E-02, 3.8007789362E-01],
	[5.8700000000E+03, 2.5600258067E+00, 6.9265891299E+00, 4.8757546565E-02, 4.7518042686E-02, 3.8029907638E-01],
	[5.8750000000E+03, 2.5626322637E+00, 6.9244763097E+00, 4.8884054007E-02, 4.7638993550E-02, 3.8052010937E-01],
	[5.8800000000E+03, 2.5652391537E+00, 6.9223659307E+00, 4.9010781243E-02, 4.7760143772E-02, 3.8074099304E-01],
	[5.8850000000E+03, 2.5678464765E+00, 6.9202579877E+00, 4.9137728466E-02, 4.7881493487E-02, 3.8096172783E-01],
	[5.8900000000E+03, 2.5704542317E+00, 6.9181524760E+00, 4.9264895868E-02, 4.8003042830E-02, 3.8118231416E-01],
	[5.8950000000E+03, 2.5730624190E+00, 6.9160493907E+00, 4.9392283643E-02, 4.8124791935E-02, 3.8140275248E-01],
	[5.9000000000E+03, 2.5756710382E+00, 6.9139487270E+00, 4.9519891985E-02, 4.8246740934E-02, 3.8162304322E-01],
	[5.9050000000E+03, 2.5782800889E+00, 6.9118504799E+00, 4.9647721087E-02, 4.8368889964E-02, 3.8184318681E-01],
	[5.9100000000E+03, 2.5808895709E+00, 6.9097546448E+00, 4.9775771143E-02, 4.8491239157E-02, 3.8206318368E-01],
	[5.9150000000E+03, 2.5834994838E+00, 6.9076612167E+00, 4.9904042345E-02, 4.8613788647E-02, 3.8228303427E-01],
	[5.9200000000E+03, 2.5861098274E+00, 6.9055701909E+00, 5.0032534887E-02, 4.8736538568E-02, 3.8250273899E-01],
	[5.9250000000E+03, 2.5887206014E+00, 6.9034815626E+00, 5.0161248962E-02, 4.8859489052E-02, 3.8272229829E-01],
	[5.9300000000E+03, 2.5913318055E+00, 6.9013953270E+00, 5.0290184764E-02, 4.8982640235E-02, 3.8294171258E-01],
	[5.9350000000E+03, 2.5939434393E+00, 6.8993114794E+00, 5.0419342487E-02, 4.9105992248E-02, 3.8316098229E-01],
	[5.9400000000E+03, 2.5965555027E+00, 6.8972300151E+00, 5.0548722322E-02, 4.9229545225E-02, 3.8338010785E-01],
	[5.9450000000E+03, 2.5991679952E+00, 6.8951509292E+00, 5.0678324465E-02, 4.9353299299E-02, 3.8359908968E-01],
	[5.9500000000E+03, 2.6017809167E+00, 6.8930742172E+00, 5.0808149108E-02, 4.9477254602E-02, 3.8381792819E-01],
	[5.9550000000E+03, 2.6043942668E+00, 6.8909998742E+00, 5.0938196445E-02, 4.9601411268E-02, 3.8403662381E-01],
	[5.9600000000E+03, 2.6070080453E+00, 6.8889278956E+00, 5.1068466668E-02, 4.9725769429E-02, 3.8425517697E-01],
	[5.9650000000E+03, 2.6096315026E+00, 6.8868879673E+00, 5.1198959972E-02, 4.9850334149E-02, 3.8447358807E-01],
	[5.9700000000E+03, 2.6122557674E+00, 6.8848515340E+00, 5.1329676550E-02, 4.9975100866E-02, 3.8469185753E-01],
	[5.9750000000E+03, 2.6148804709E+00, 6.8828174070E+00, 5.1460616596E-02, 5.0100069515E-02, 3.8490998577E-01],
	[5.9800000000E+03, 2.6175056129E+00, 6.8807855818E+00, 5.1591780301E-02, 5.0225240231E-02, 3.8512797321E-01],
	[5.9850000000E+03, 2.6201311929E+00, 6.8787560537E+00, 5.1723167861E-02, 5.0350613144E-02, 3.8534582026E-01],
	[5.9900000000E+03, 2.6227572108E+00, 6.8767288182E+00, 5.1854779469E-02, 5.0476188388E-02, 3.8556352733E-01],
	[5.9950000000E+03, 2.6253836663E+00, 6.8747038710E+00, 5.1986615317E-02, 5.0601966093E-02, 3.8578109483E-01],
	[6.0000000000E+03, 2.6280105590E+00, 6.8726812075E+00, 5.2118675599E-02, 5.0727946392E-02, 3.8599852318E-01],
	[6.0050000000E+03, 2.6306378886E+00, 6.8706608231E+00, 5.2251692323E-02, 5.0854822625E-02, 3.8621581278E-01],
	[6.0100000000E+03, 2.6332656549E+00, 6.8686427135E+00, 5.2384936980E-02, 5.0981904522E-02, 3.8643296403E-01],
	[6.0150000000E+03, 2.6358938576E+00, 6.8666268742E+00, 5.2518409769E-02, 5.1109192219E-02, 3.8664997736E-01],
	[6.0200000000E+03, 2.6385224963E+00, 6.8646133008E+00, 5.2652110890E-02, 5.1236685850E-02, 3.8686685315E-01],
	[6.0250000000E+03, 2.6411515708E+00, 6.8626019888E+00, 5.2786040542E-02, 5.1364385553E-02, 3.8708359183E-01],
	[6.0300000000E+03, 2.6437810809E+00, 6.8605929338E+00, 5.2920198924E-02, 5.1492291462E-02, 3.8730019378E-01],
	[6.0350000000E+03, 2.6464110261E+00, 6.8585861315E+00, 5.3054586236E-02, 5.1620403714E-02, 3.8751665942E-01],
	[6.0400000000E+03, 2.6490414063E+00, 6.8565815774E+00, 5.3189202677E-02, 5.1748722442E-02, 3.8773298915E-01],
	[6.0450000000E+03, 2.6516722211E+00, 6.8545792671E+00, 5.3324048447E-02, 5.1877247783E-02, 3.8794918336E-01],
	[6.0500000000E+03, 2.6543034703E+00, 6.8525791963E+00, 5.3459123745E-02, 5.2005979872E-02, 3.8816524246E-01],
	[6.0550000000E+03, 2.6569351535E+00, 6.8505813607E+00, 5.3594428769E-02, 5.2134918843E-02, 3.8838116684E-01],
	[6.0600000000E+03, 2.6595743887E+00, 6.8486087110E+00, 5.3729963720E-02, 5.2264068916E-02, 3.8859695690E-01],
	[6.0650000000E+03, 2.6622161755E+00, 6.8466450506E+00, 5.3865728798E-02, 5.2393427389E-02, 3.8881261304E-01],
	[6.0700000000E+03, 2.6648584062E+00, 6.8446835707E+00, 5.4001724200E-02, 5.2522993191E-02, 3.8902813566E-01],
	[6.0750000000E+03, 2.6675010805E+00, 6.8427242671E+00, 5.4137950127E-02, 5.2652766455E-02, 3.8924352514E-01],
	[6.0800000000E+03, 2.6701441980E+00, 6.8407671356E+00, 5.4274406779E-02, 5.2782747318E-02, 3.8945878188E-01],
	[6.0850000000E+03, 2.6727877586E+00, 6.8388121720E+00, 5.4411094353E-02, 5.2912935912E-02, 3.8967390628E-01],
	[6.0900000000E+03, 2.6754317618E+00, 6.8368593721E+00, 5.4548013051E-02, 5.3043332373E-02, 3.8988889872E-01],
	[6.0950000000E+03, 2.6780762075E+00, 6.8349087318E+00, 5.4685163071E-02, 5.3173936833E-02, 3.9010375959E-01],
	[6.1000000000E+03, 2.6807210954E+00, 6.8329602469E+00, 5.4822544613E-02, 5.3304749429E-02, 3.9031848929E-01],
	[6.1050000000E+03, 2.6833664251E+00, 6.8310139132E+00, 5.4960157876E-02, 5.3435770292E-02, 3.9053308820E-01],
	[6.1100000000E+03, 2.6860121963E+00, 6.8290697267E+00, 5.5098003059E-02, 5.3566999557E-02, 3.9074755672E-01],
	[6.1150000000E+03, 2.6886584088E+00, 6.8271276831E+00, 5.5236080363E-02, 5.3698437357E-02, 3.9096189521E-01],
	[6.1200000000E+03, 2.6913050623E+00, 6.8251877785E+00, 5.5374389986E-02, 5.3830083827E-02, 3.9117610408E-01],
	[6.1250000000E+03, 2.6939521565E+00, 6.8232500086E+00, 5.5512932128E-02, 5.3961939098E-02, 3.9139018371E-01],
	[6.1300000000E+03, 2.6965996911E+00, 6.8213143694E+00, 5.5651706988E-02, 5.4094003305E-02, 3.9160413447E-01],
	[6.1350000000E+03, 2.6992476658E+00, 6.8193808568E+00, 5.5790714767E-02, 5.4226276581E-02, 3.9181795675E-01],
	[6.1400000000E+03, 2.7018960804E+00, 6.8174494668E+00, 5.5929955662E-02, 5.4358759058E-02, 3.9203165094E-01],
	[6.1450000000E+03, 2.7045449345E+00, 6.8155201953E+00, 5.6069429874E-02, 5.4491450869E-02, 3.9224521741E-01],
	[6.1500000000E+03, 2.7071942279E+00, 6.8135930382E+00, 5.6209137603E-02, 5.4624352148E-02, 3.9245865655E-01],
	[6.1550000000E+03, 2.7098463804E+00, 6.8116757920E+00, 5.6349079047E-02, 5.4757464518E-02, 3.9267196873E-01],
	[6.1600000000E+03, 2.7125054441E+00, 6.8097814685E+00, 5.6489254407E-02, 5.4890790634E-02, 3.9288515432E-01],
	[6.1650000000E+03, 2.7151649564E+00, 6.8078892082E+00, 5.6629663881E-02, 5.5024326658E-02, 3.9309821372E-01],
	[6.1700000000E+03, 2.7178249170E+00, 6.8059990071E+00, 5.6770307670E-02, 5.5158072721E-02, 3.9331114728E-01],
	[6.1750000000E+03, 2.7204853256E+00, 6.8041108613E+00, 5.6911185972E-02, 5.5292028956E-02, 3.9352395540E-01],
	[6.1800000000E+03, 2.7231461820E+00, 6.8022247670E+00, 5.7052298988E-02, 5.5426195496E-02, 3.9373663843E-01],
	[6.1850000000E+03, 2.7258074859E+00, 6.8003407202E+00, 5.7193646916E-02, 5.5560572471E-02, 3.9394919676E-01],
	[6.1900000000E+03, 2.7284692369E+00, 6.7984587170E+00, 5.7335229957E-02, 5.5695160014E-02, 3.9416163076E-01],
	[6.1950000000E+03, 2.7311314347E+00, 6.7965787537E+00, 5.7477048309E-02, 5.5829958257E-02, 3.9437394079E-01],
	[6.2000000000E+03, 2.7337940792E+00, 6.7947008263E+00, 5.7619102173E-02, 5.5964967331E-02, 3.9458612724E-01],
	[6.2050000000E+03, 2.7364571700E+00, 6.7928249310E+00, 5.7761391748E-02, 5.6100187368E-02, 3.9479819046E-01],
	[6.2100000000E+03, 2.7391207068E+00, 6.7909510639E+00, 5.7903917234E-02, 5.6235618499E-02, 3.9501013083E-01],
	[6.2150000000E+03, 2.7417846893E+00, 6.7890792213E+00, 5.8046678829E-02, 5.6371260855E-02, 3.9522194872E-01],
	[6.2200000000E+03, 2.7444491173E+00, 6.7872093994E+00, 5.8189676734E-02, 5.6507114568E-02, 3.9543364448E-01],
	[6.2250000000E+03, 2.7471139905E+00, 6.7853415942E+00, 5.8332911148E-02, 5.6643179768E-02, 3.9564521850E-01],
	[6.2300000000E+03, 2.7497793085E+00, 6.7834758021E+00, 5.8476382271E-02, 5.6779456586E-02, 3.9585667113E-01],
	[6.2350000000E+03, 2.7524450712E+00, 6.7816120193E+00, 5.8620090303E-02, 5.6915945153E-02, 3.9606800274E-01],
	[6.2400000000E+03, 2.7551112781E+00, 6.7797502419E+00, 5.8764035442E-02, 5.7052645599E-02, 3.9627921369E-01],
	[6.2450000000E+03, 2.7577779292E+00, 6.7778904663E+00, 5.8908217888E-02, 5.7189558055E-02, 3.9649030434E-01],
	[6.2500000000E+03, 2.7604450239E+00, 6.7760326886E+00, 5.9052637842E-02, 5.7326682651E-02, 3.9670127506E-01],
	[6.2550000000E+03, 2.7631164887E+00, 6.7741895591E+00, 5.9197295503E-02, 5.7464022126E-02, 3.9691212620E-01],
	[6.2600000000E+03, 2.7657930260E+00, 6.7723632896E+00, 5.9342191069E-02, 5.7601577105E-02, 3.9712285814E-01],
	[6.2650000000E+03, 2.7684700160E+00, 6.7705389699E+00, 5.9487324742E-02, 5.7739344658E-02, 3.9733347122E-01],
	[6.2700000000E+03, 2.7711474583E+00, 6.7687165964E+00, 5.9632696720E-02, 5.7877324915E-02, 3.9754396580E-01],
	[6.2750000000E+03, 2.7738253526E+00, 6.7668961655E+00, 5.9778307204E-02, 5.8015518006E-02, 3.9775434225E-01],
	[6.2800000000E+03, 2.7765036986E+00, 6.7650776736E+00, 5.9924156392E-02, 5.8153924060E-02, 3.9796460091E-01],
	[6.2850000000E+03, 2.7791824962E+00, 6.7632611171E+00, 6.0070244485E-02, 5.8292543208E-02, 3.9817474216E-01],
	[6.2900000000E+03, 2.7818617449E+00, 6.7614464924E+00, 6.0216571681E-02, 5.8431375579E-02, 3.9838476633E-01],
	[6.2950000000E+03, 2.7845414446E+00, 6.7596337958E+00, 6.0363138182E-02, 5.8570421301E-02, 3.9859467379E-01],
	[6.3000000000E+03, 2.7872215949E+00, 6.7578230239E+00, 6.0509944186E-02, 5.8709680505E-02, 3.9880446489E-01],
	[6.3050000000E+03, 2.7899021955E+00, 6.7560141730E+00, 6.0656989893E-02, 5.8849153319E-02, 3.9901413998E-01],
	[6.3100000000E+03, 2.7925832461E+00, 6.7542072396E+00, 6.0804275502E-02, 5.8988839873E-02, 3.9922369945E-01],
	[6.3150000000E+03, 2.7952647466E+00, 6.7524022201E+00, 6.0951801214E-02, 5.9128740294E-02, 3.9943314378E-01],
	[6.3200000000E+03, 2.7979466966E+00, 6.7505991110E+00, 6.1099567228E-02, 5.9268854712E-02, 3.9964247330E-01],
	[6.3250000000E+03, 2.8006290957E+00, 6.7487979088E+00, 6.1247573744E-02, 5.9409183255E-02, 3.9985168835E-01],
	[6.3300000000E+03, 2.8033119439E+00, 6.7469986099E+00, 6.1395820961E-02, 5.9549726051E-02, 4.0006078925E-01],
	[6.3350000000E+03, 2.8059952406E+00, 6.7452012109E+00, 6.1544309080E-02, 5.9690483230E-02, 4.0026977634E-01],
	[6.3400000000E+03, 2.8086789858E+00, 6.7434057082E+00, 6.1693038299E-02, 5.9831454918E-02, 4.0047864993E-01],
	[6.3450000000E+03, 2.8113631790E+00, 6.7416120983E+00, 6.1842008819E-02, 5.9972641244E-02, 4.0068741037E-01],
	[6.3500000000E+03, 2.8140478201E+00, 6.7398203778E+00, 6.1991220839E-02, 6.0114042336E-02, 4.0089605797E-01],
	[6.3550000000E+03, 2.8167355953E+00, 6.7380392167E+00, 6.2140674559E-02, 6.0255660244E-02, 4.0110459305E-01],
	[6.3600000000E+03, 2.8194293454E+00, 6.7362777417E+00, 6.2290370178E-02, 6.0397497155E-02, 4.0131301596E-01],
	[6.3650000000E+03, 2.8221235517E+00, 6.7345181110E+00, 6.2440307898E-02, 6.0539549260E-02, 4.0152132700E-01],
	[6.3700000000E+03, 2.8248182139E+00, 6.7327603210E+00, 6.2590487916E-02, 6.0681816685E-02, 4.0172952651E-01],
	[6.3750000000E+03, 2.8275133318E+00, 6.7310043686E+00, 6.2740910433E-02, 6.0824299559E-02, 4.0193761480E-01],
	[6.3800000000E+03, 2.8302089050E+00, 6.7292502502E+00, 6.2891575649E-02, 6.0966998008E-02, 4.0214559220E-01],
	[6.3850000000E+03, 2.8329049334E+00, 6.7274979626E+00, 6.3042483763E-02, 6.1109912160E-02, 4.0235345903E-01],
	[6.3900000000E+03, 2.8356014165E+00, 6.7257475024E+00, 6.3193634975E-02, 6.1253042141E-02, 4.0256121560E-01],
	[6.3950000000E+03, 2.8382983541E+00, 6.7239988663E+00, 6.3345029486E-02, 6.1396388078E-02, 4.0276886225E-01],
	[6.4000000000E+03, 2.8409957460E+00, 6.7222520510E+00, 6.3496667493E-02, 6.1539950099E-02, 4.0297639928E-01],
	[6.4050000000E+03, 2.8436935918E+00, 6.7205070530E+00, 6.3648549199E-02, 6.1683728329E-02, 4.0318382702E-01],
	[6.4100000000E+03, 2.8463918914E+00, 6.7187638692E+00, 6.3800674801E-02, 6.1827722895E-02, 4.0339114579E-01],
	[6.4150000000E+03, 2.8490906443E+00, 6.7170224963E+00, 6.3953044501E-02, 6.1971933923E-02, 4.0359835589E-01],
	[6.4200000000E+03, 2.8517898503E+00, 6.7152829309E+00, 6.4105658498E-02, 6.2116361541E-02, 4.0380545766E-01],
	[6.4250000000E+03, 2.8544895093E+00, 6.7135451697E+00, 6.4258516991E-02, 6.2261005872E-02, 4.0401245139E-01],
	[6.4300000000E+03, 2.8571896208E+00, 6.7118092095E+00, 6.4411620180E-02, 6.2405867044E-02, 4.0421933742E-01],
	[6.4350000000E+03, 2.8598901845E+00, 6.7100750471E+00, 6.4564968266E-02, 6.2550945183E-02, 4.0442611604E-01],
	[6.4400000000E+03, 2.8625912004E+00, 6.7083426791E+00, 6.4718561447E-02, 6.2696240413E-02, 4.0463278758E-01],
	[6.4450000000E+03, 2.8652926679E+00, 6.7066121023E+00, 6.4872399925E-02, 6.2841752861E-02, 4.0483935235E-01],
	[6.4500000000E+03, 2.8679945870E+00, 6.7048833135E+00, 6.5026483898E-02, 6.2987482651E-02, 4.0504581066E-01],
	[6.4550000000E+03, 2.8706969572E+00, 6.7031563095E+00, 6.5180813567E-02, 6.3133429909E-02, 4.0525216282E-01],
	[6.4600000000E+03, 2.8734066334E+00, 6.7014532792E+00, 6.5335389131E-02, 6.3279600063E-02, 4.0545840914E-01],
	[6.4650000000E+03, 2.8761177818E+00, 6.6997552776E+00, 6.5490210790E-02, 6.3425988763E-02, 4.0566454993E-01],
	[6.4700000000E+03, 2.8788293894E+00, 6.6980590185E+00, 6.5645278745E-02, 6.3572595350E-02, 4.0587058550E-01],
	[6.4750000000E+03, 2.8815414558E+00, 6.6963644987E+00, 6.5800593194E-02, 6.3719419951E-02, 4.0607651617E-01],
	[6.4800000000E+03, 2.8842539807E+00, 6.6946717150E+00, 6.5956154338E-02, 6.3866462690E-02, 4.0628234223E-01],
	[6.4850000000E+03, 2.8869669640E+00, 6.6929806645E+00, 6.6111962376E-02, 6.4013723692E-02, 4.0648806400E-01],
	[6.4900000000E+03, 2.8896804052E+00, 6.6912913440E+00, 6.6268017509E-02, 6.4161203081E-02, 4.0669368177E-01],
	[6.4950000000E+03, 2.8923943042E+00, 6.6896037503E+00, 6.6424319936E-02, 6.4308900982E-02, 4.0689919587E-01],
	[6.5000000000E+03, 2.8951086606E+00, 6.6879178804E+00, 6.6580869858E-02, 6.4456817518E-02, 4.0710460659E-01],
	[6.5050000000E+03, 2.8978234741E+00, 6.6862337312E+00, 6.6737667474E-02, 6.4604952813E-02, 4.0730991424E-01],
	[6.5100000000E+03, 2.9005387446E+00, 6.6845512996E+00, 6.6894712983E-02, 6.4753306993E-02, 4.0751511912E-01],
	[6.5150000000E+03, 2.9032544717E+00, 6.6828705825E+00, 6.7052006587E-02, 6.4901880180E-02, 4.0772022153E-01],
	[6.5200000000E+03, 2.9059706552E+00, 6.6811915770E+00, 6.7209548484E-02, 6.5050672498E-02, 4.0792522179E-01],
	[6.5250000000E+03, 2.9086872947E+00, 6.6795142799E+00, 6.7367338875E-02, 6.5199684070E-02, 4.0813012018E-01],
	[6.5300000000E+03, 2.9114043901E+00, 6.6778386882E+00, 6.7525377960E-02, 6.5348915020E-02, 4.0833491702E-01],
	[6.5350000000E+03, 2.9141219409E+00, 6.6761647988E+00, 6.7683665938E-02, 6.5498365471E-02, 4.0853961260E-01],
	[6.5400000000E+03, 2.9168399471E+00, 6.6744926087E+00, 6.7842203009E-02, 6.5648035547E-02, 4.0874420722E-01],
	[6.5450000000E+03, 2.9195584082E+00, 6.6728221150E+00, 6.8000989374E-02, 6.5797925369E-02, 4.0894870119E-01],
	[6.5500000000E+03, 2.9222773241E+00, 6.6711533145E+00, 6.8160025233E-02, 6.5948035061E-02, 4.0915309479E-01],
	[6.5550000000E+03, 2.9249966944E+00, 6.6694862044E+00, 6.8319310784E-02, 6.6098364746E-02, 4.0935738834E-01],
	[6.5600000000E+03, 2.9277171640E+00, 6.6678228832E+00, 6.8478846229E-02, 6.6248915084E-02, 4.0956158213E-01],
	[6.5650000000E+03, 2.9304449679E+00, 6.6661836285E+00, 6.8638631767E-02, 6.6399691416E-02, 4.0976567645E-01],
	[6.5700000000E+03, 2.9331732338E+00, 6.6645460244E+00, 6.8798667598E-02, 6.6550688154E-02, 4.0996967161E-01],
	[6.5750000000E+03, 2.9359019612E+00, 6.6629100679E+00, 6.8958953922E-02, 6.6701905421E-02, 4.1017356789E-01],
	[6.5800000000E+03, 2.9386311500E+00, 6.6612757561E+00, 6.9119490939E-02, 6.6853343338E-02, 4.1037736560E-01],
	[6.5850000000E+03, 2.9413607998E+00, 6.6596430861E+00, 6.9280278849E-02, 6.7005002028E-02, 4.1058106503E-01],
	[6.5900000000E+03, 2.9440909105E+00, 6.6580120551E+00, 6.9441317852E-02, 6.7156881613E-02, 4.1078466647E-01],
	[6.5950000000E+03, 2.9468214817E+00, 6.6563826601E+00, 6.9602608148E-02, 6.7308982213E-02, 4.1098817021E-01],
	[6.6000000000E+03, 2.9495525131E+00, 6.6547548983E+00, 6.9764149937E-02, 6.7461303952E-02, 4.1119157656E-01],
	[6.6050000000E+03, 2.9522840046E+00, 6.6531287667E+00, 6.9925943419E-02, 6.7613846950E-02, 4.1139488580E-01],
	[6.6100000000E+03, 2.9550159557E+00, 6.6515042626E+00, 7.0087988794E-02, 6.7766611328E-02, 4.1159809822E-01],
	[6.6150000000E+03, 2.9577483663E+00, 6.6498813831E+00, 7.0250286262E-02, 6.7919597209E-02, 4.1180121412E-01],
	[6.6200000000E+03, 2.9604812361E+00, 6.6482601252E+00, 7.0412836023E-02, 6.8072804712E-02, 4.1200423379E-01],
	[6.6250000000E+03, 2.9632145648E+00, 6.6466404863E+00, 7.0575638277E-02, 6.8226233959E-02, 4.1220715751E-01],
	[6.6300000000E+03, 2.9659483521E+00, 6.6450224633E+00, 7.0738693224E-02, 6.8379885071E-02, 4.1240998558E-01],
	[6.6350000000E+03, 2.9686825978E+00, 6.6434060536E+00, 7.0902001063E-02, 6.8533758168E-02, 4.1261271829E-01],
	[6.6400000000E+03, 2.9714173016E+00, 6.6417912543E+00, 7.1065561996E-02, 6.8687853370E-02, 4.1281535592E-01],
	[6.6450000000E+03, 2.9741524632E+00, 6.6401780625E+00, 7.1229376222E-02, 6.8842170798E-02, 4.1301789876E-01],
	[6.6500000000E+03, 2.9768880824E+00, 6.6385664755E+00, 7.1393443941E-02, 6.8996710573E-02, 4.1322034710E-01],
	[6.6550000000E+03, 2.9796241589E+00, 6.6369564905E+00, 7.1557765354E-02, 6.9151472813E-02, 4.1342270123E-01],
	[6.6600000000E+03, 2.9823606924E+00, 6.6353481046E+00, 7.1722340659E-02, 6.9306457640E-02, 4.1362496143E-01],
	[6.6650000000E+03, 2.9850976827E+00, 6.6337413151E+00, 7.1887170058E-02, 6.9461665173E-02, 4.1382712799E-01],
	[6.6700000000E+03, 2.9878420620E+00, 6.6321588476E+00, 7.2052253750E-02, 6.9617101799E-02, 4.1402920119E-01],
	[6.6750000000E+03, 2.9905871510E+00, 6.6305787484E+00, 7.2217591936E-02, 6.9772761639E-02, 4.1423118132E-01],
	[6.6800000000E+03, 2.9933327038E+00, 6.6290002085E+00, 7.2383184815E-02, 6.9928644590E-02, 4.1443306867E-01],
	[6.6850000000E+03, 2.9960787201E+00, 6.6274232250E+00, 7.2549032587E-02, 7.0084750773E-02, 4.1463486351E-01],
	[6.6900000000E+03, 2.9988251996E+00, 6.6258477954E+00, 7.2715135454E-02, 7.0241080307E-02, 4.1483656613E-01],
	[6.6950000000E+03, 3.0015721420E+00, 6.6242739168E+00, 7.2881493614E-02, 7.0397633310E-02, 4.1503817682E-01],
	[6.7000000000E+03, 3.0043195471E+00, 6.6227015866E+00, 7.3048107267E-02, 7.0554409901E-02, 4.1523969585E-01],
	[6.7050000000E+03, 3.0070674146E+00, 6.6211308022E+00, 7.3214976615E-02, 7.0711410200E-02, 4.1544112351E-01],
	[6.7100000000E+03, 3.0098157442E+00, 6.6195615608E+00, 7.3382101857E-02, 7.0868634325E-02, 4.1564246007E-01],
	[6.7150000000E+03, 3.0125645358E+00, 6.6179938598E+00, 7.3549483193E-02, 7.1026082395E-02, 4.1584370583E-01],
	[6.7200000000E+03, 3.0153137889E+00, 6.6164276966E+00, 7.3717120823E-02, 7.1183754527E-02, 4.1604486105E-01],
	[6.7250000000E+03, 3.0180635034E+00, 6.6148630684E+00, 7.3885014948E-02, 7.1341650841E-02, 4.1624592601E-01],
	[6.7300000000E+03, 3.0208136789E+00, 6.6132999727E+00, 7.4053165767E-02, 7.1499771454E-02, 4.1644690101E-01],
	[6.7350000000E+03, 3.0235643153E+00, 6.6117384068E+00, 7.4221573481E-02, 7.1658116485E-02, 4.1664778631E-01],
	[6.7400000000E+03, 3.0263154122E+00, 6.6101783681E+00, 7.4390238289E-02, 7.1816686051E-02, 4.1684858220E-01],
	[6.7450000000E+03, 3.0290669694E+00, 6.6086198539E+00, 7.4559160393E-02, 7.1975480270E-02, 4.1704928894E-01],
	[6.7500000000E+03, 3.0318189866E+00, 6.6070628617E+00, 7.4728339991E-02, 7.2134499259E-02, 4.1724990682E-01],
	[6.7550000000E+03, 3.0345714636E+00, 6.6055073888E+00, 7.4897777285E-02, 7.2293743136E-02, 4.1745043612E-01],
	[6.7600000000E+03, 3.0373244000E+00, 6.6039534326E+00, 7.5067472474E-02, 7.2453212017E-02, 4.1765087711E-01],
	[6.7650000000E+03, 3.0400777957E+00, 6.6024009905E+00, 7.5237425759E-02, 7.2612906022E-02, 4.1785123007E-01],
	[6.7700000000E+03, 3.0428316503E+00, 6.6008500600E+00, 7.5407637339E-02, 7.2772825265E-02, 4.1805149526E-01],
	[6.7750000000E+03, 3.0455894168E+00, 6.5993120770E+00, 7.5578107415E-02, 7.2932973241E-02, 4.1825167298E-01],
	[6.7800000000E+03, 3.0483510223E+00, 6.5977867600E+00, 7.5748836188E-02, 7.3093350027E-02, 4.1845176348E-01],
	[6.7850000000E+03, 3.0511130933E+00, 6.5962629197E+00, 7.5919823856E-02, 7.3253952451E-02, 4.1865176705E-01],
	[6.7900000000E+03, 3.0538756295E+00, 6.5947405534E+00, 7.6091070621E-02, 7.3414780628E-02, 4.1885168396E-01],
	[6.7950000000E+03, 3.0566386307E+00, 6.5932196587E+00, 7.6262576683E-02, 7.3575834675E-02, 4.1905151447E-01],
	[6.8000000000E+03, 3.0594020965E+00, 6.5917002331E+00, 7.6434342241E-02, 7.3737114710E-02, 4.1925125887E-01],
	[6.8050000000E+03, 3.0621660269E+00, 6.5901822741E+00, 7.6606367496E-02, 7.3898620847E-02, 4.1945091742E-01],
	[6.8100000000E+03, 3.0649304214E+00, 6.5886657792E+00, 7.6778652649E-02, 7.4060353202E-02, 4.1965049040E-01],
	[6.8150000000E+03, 3.0676952798E+00, 6.5871507459E+00, 7.6951197899E-02, 7.4222311893E-02, 4.1984997808E-01],
	[6.8200000000E+03, 3.0704606019E+00, 6.5856371717E+00, 7.7124003447E-02, 7.4384497033E-02, 4.2004938074E-01],
	[6.8250000000E+03, 3.0732263874E+00, 6.5841250541E+00, 7.7297069492E-02, 7.4546908740E-02, 4.2024869861E-01],
	[6.8300000000E+03, 3.0759926360E+00, 6.5826143908E+00, 7.7470396236E-02, 7.4709547128E-02, 4.2044793193E-01],
	[6.8350000000E+03, 3.0787593475E+00, 6.5811051792E+00, 7.7643983878E-02, 7.4872412312E-02, 4.2064708092E-01],
	[6.8400000000E+03, 3.0815265216E+00, 6.5795974168E+00, 7.7817832619E-02, 7.5035504408E-02, 4.2084614583E-01],
	[6.8450000000E+03, 3.0842941581E+00, 6.5780911013E+00, 7.7991942658E-02, 7.5198823531E-02, 4.2104512689E-01],
	[6.8500000000E+03, 3.0870622566E+00, 6.5765862301E+00, 7.8166314197E-02, 7.5362369795E-02, 4.2124402432E-01],
	[6.8550000000E+03, 3.0898308169E+00, 6.5750828009E+00, 7.8340947435E-02, 7.5526143316E-02, 4.2144283835E-01],
	[6.8600000000E+03, 3.0925998389E+00, 6.5735808112E+00, 7.8515842572E-02, 7.5690144207E-02, 4.2164156923E-01],
	[6.8650000000E+03, 3.0953693221E+00, 6.5720802586E+00, 7.8690999810E-02, 7.5854372583E-02, 4.2184021718E-01],
	[6.8700000000E+03, 3.0981392664E+00, 6.5705811406E+00, 7.8866419347E-02, 7.6018828558E-02, 4.2203878243E-01],
	[6.8750000000E+03, 3.1009096714E+00, 6.5690834549E+00, 7.9042101385E-02, 7.6183512247E-02, 4.2223726521E-01],
	[6.8800000000E+03, 3.1036805370E+00, 6.5675871990E+00, 7.9218046124E-02, 7.6348423764E-02, 4.2243566575E-01],
	[6.8850000000E+03, 3.1064563989E+00, 6.5661075816E+00, 7.9394253763E-02, 7.6513568039E-02, 4.2263398428E-01],
	[6.8900000000E+03, 3.1092346688E+00, 6.5646358802E+00, 7.9570724504E-02, 7.6678942472E-02, 4.2283222103E-01],
	[6.8950000000E+03, 3.1120134053E+00, 6.5631655760E+00, 7.9747458546E-02, 7.6844545123E-02, 4.2303037622E-01],
	[6.9000000000E+03, 3.1147926081E+00, 6.5616966666E+00, 7.9924456091E-02, 7.7010376105E-02, 4.2322845009E-01],
	[6.9050000000E+03, 3.1175722771E+00, 6.5602291496E+00, 8.0101717337E-02, 7.7176435531E-02, 4.2342644287E-01],
	[6.9100000000E+03, 3.1203524119E+00, 6.5587630227E+00, 8.0279242486E-02, 7.7342723515E-02, 4.2362435477E-01],
	[6.9150000000E+03, 3.1231330122E+00, 6.5572982836E+00, 8.0457031737E-02, 7.7509240170E-02, 4.2382218603E-01],
	[6.9200000000E+03, 3.1259140779E+00, 6.5558349300E+00, 8.0635085292E-02, 7.7675985608E-02, 4.2401993688E-01],
	[6.9250000000E+03, 3.1286956087E+00, 6.5543729595E+00, 8.0813403350E-02, 7.7842959942E-02, 4.2421760753E-01],
	[6.9300000000E+03, 3.1314776043E+00, 6.5529123700E+00, 8.0991986112E-02, 7.8010163286E-02, 4.2441519822E-01],
	[6.9350000000E+03, 3.1342600644E+00, 6.5514531589E+00, 8.1170833778E-02, 7.8177595751E-02, 4.2461270917E-01],
	[6.9400000000E+03, 3.1370429888E+00, 6.5499953242E+00, 8.1349946548E-02, 7.8345257450E-02, 4.2481014061E-01],
	[6.9450000000E+03, 3.1398263773E+00, 6.5485388634E+00, 8.1529324624E-02, 7.8513148496E-02, 4.2500749276E-01],
	[6.9500000000E+03, 3.1426102295E+00, 6.5470837744E+00, 8.1708968204E-02, 7.8681269000E-02, 4.2520476585E-01],
	[6.9550000000E+03, 3.1453945453E+00, 6.5456300548E+00, 8.1888877490E-02, 7.8849619074E-02, 4.2540196010E-01],
	[6.9600000000E+03, 3.1481793243E+00, 6.5441777023E+00, 8.2069052681E-02, 7.9018198830E-02, 4.2559907573E-01],
	[6.9650000000E+03, 3.1509645663E+00, 6.5427267147E+00, 8.2249493979E-02, 7.9187008379E-02, 4.2579611297E-01],
	[6.9700000000E+03, 3.1537502711E+00, 6.5412770897E+00, 8.2430201584E-02, 7.9356047834E-02, 4.2599307204E-01],
	[6.9750000000E+03, 3.1565364384E+00, 6.5398288251E+00, 8.2611175695E-02, 7.9525317305E-02, 4.2618995316E-01],
	[6.9800000000E+03, 3.1593230679E+00, 6.5383819186E+00, 8.2792416514E-02, 7.9694816904E-02, 4.2638675655E-01],
	[6.9850000000E+03, 3.1621101594E+00, 6.5369363680E+00, 8.2973924240E-02, 7.9864546741E-02, 4.2658348245E-01],
	[6.9900000000E+03, 3.1648977127E+00, 6.5354921710E+00, 8.3155699075E-02, 8.0034506928E-02, 4.2678013106E-01],
	[6.9950000000E+03, 3.1676890691E+00, 6.5340606670E+00, 8.3337741218E-02, 8.0204701427E-02, 4.2697670262E-01],
	[7.0000000000E+03, 3.1704836968E+00, 6.5326400140E+00, 8.3520050870E-02, 8.0375129767E-02, 4.2717319733E-01],
	[7.0050000000E+03, 3.1732787920E+00, 6.5312206840E+00, 8.3704287807E-02, 8.0547325591E-02, 4.2736961543E-01],
	[7.0100000000E+03, 3.1760743543E+00, 6.5298026747E+00, 8.3888798820E-02, 8.0719757580E-02, 4.2756595713E-01],
	[7.0150000000E+03, 3.1788703834E+00, 6.5283859840E+00, 8.4073584121E-02, 8.0892425848E-02, 4.2776222265E-01],
	[7.0200000000E+03, 3.1816668793E+00, 6.5269706097E+00, 8.4258643919E-02, 8.1065330515E-02, 4.2795841222E-01],
	[7.0250000000E+03, 3.1844638415E+00, 6.5255565497E+00, 8.4443978426E-02, 8.1238471696E-02, 4.2815452604E-01],
	[7.0300000000E+03, 3.1872612699E+00, 6.5241438019E+00, 8.4629587853E-02, 8.1411849508E-02, 4.2835056435E-01],
	[7.0350000000E+03, 3.1900591641E+00, 6.5227323640E+00, 8.4815472409E-02, 8.1585464068E-02, 4.2854652735E-01],
	[7.0400000000E+03, 3.1928575240E+00, 6.5213222339E+00, 8.5001632307E-02, 8.1759315492E-02, 4.2874241528E-01],
	[7.0450000000E+03, 3.1956563492E+00, 6.5199134095E+00, 8.5188067756E-02, 8.1933403897E-02, 4.2893822834E-01],
	[7.0500000000E+03, 3.1984556396E+00, 6.5185058887E+00, 8.5374778968E-02, 8.2107729398E-02, 4.2913396675E-01],
	[7.0550000000E+03, 3.2012553948E+00, 6.5170996693E+00, 8.5561766154E-02, 8.2282292112E-02, 4.2932963073E-01],
	[7.0600000000E+03, 3.2040556147E+00, 6.5156947491E+00, 8.5749029524E-02, 8.2457092154E-02, 4.2952522050E-01],
	[7.0650000000E+03, 3.2068562989E+00, 6.5142911262E+00, 8.5936569288E-02, 8.2632129640E-02, 4.2972073627E-01],
	[7.0700000000E+03, 3.2096574473E+00, 6.5128887983E+00, 8.6124385659E-02, 8.2807404686E-02, 4.2991617827E-01],
	[7.0750000000E+03, 3.2124590595E+00, 6.5114877634E+00, 8.6312478847E-02, 8.2982917406E-02, 4.3011154670E-01],
	[7.0800000000E+03, 3.2152611353E+00, 6.5100880193E+00, 8.6500849063E-02, 8.3158667917E-02, 4.3030684178E-01],
	[7.0850000000E+03, 3.2180636745E+00, 6.5086895640E+00, 8.3979238908E-02, 8.0827077011E-02, 4.3050206374E-01],
	[7.0900000000E+03, 3.2208666767E+00, 6.5072923953E+00, 8.4161190896E-02, 8.0997170224E-02, 4.3069721277E-01],
	[7.0950000000E+03, 3.2236701419E+00, 6.5058965112E+00, 8.4343407595E-02, 8.1167491519E-02, 4.3089228911E-01],
	[7.1000000000E+03, 3.2264740696E+00, 6.5045019096E+00, 8.4525889201E-02, 8.1338041004E-02, 4.3108729296E-01],
	[7.1050000000E+03, 3.2292786398E+00, 6.5031091974E+00, 8.4708635910E-02, 8.1508818997E-02, 4.3128222453E-01],
	[7.1100000000E+03, 3.2320894173E+00, 6.5017371735E+00, 8.4891647918E-02, 8.1679832128E-02, 4.3147708405E-01],
	[7.1150000000E+03, 3.2349006628E+00, 6.5003664034E+00, 8.5074925423E-02, 8.1851073821E-02, 4.3167187172E-01],
	[7.1200000000E+03, 3.2377123760E+00, 6.4989968849E+00, 8.5258468619E-02, 8.2022544181E-02, 4.3186658776E-01],
	[7.1250000000E+03, 3.2405245567E+00, 6.4976286160E+00, 8.5442277703E-02, 8.2194243316E-02, 4.3206123238E-01],
	[7.1300000000E+03, 3.2433372046E+00, 6.4962615947E+00, 8.5626352871E-02, 8.2366171333E-02, 4.3225580579E-01],
	[7.1350000000E+03, 3.2461503195E+00, 6.4948958191E+00, 8.5810694320E-02, 8.2538328339E-02, 4.3245030822E-01],
	[7.1400000000E+03, 3.2489639012E+00, 6.4935312870E+00, 8.5995302245E-02, 8.2710714441E-02, 4.3264473986E-01],
	[7.1450000000E+03, 3.2517779493E+00, 6.4921679966E+00, 8.6180176843E-02, 8.2883329745E-02, 4.3283910093E-01],
	[7.1500000000E+03, 3.2545924637E+00, 6.4908059457E+00, 8.6365318310E-02, 8.3056174358E-02, 4.3303339165E-01],
	[7.1550000000E+03, 3.2574074441E+00, 6.4894451325E+00, 8.6550726843E-02, 8.3229248386E-02, 4.3322761222E-01],
	[7.1600000000E+03, 3.2602228902E+00, 6.4880855549E+00, 8.6736402637E-02, 8.3402551935E-02, 4.3342176285E-01],
	[7.1650000000E+03, 3.2630388018E+00, 6.4867272109E+00, 8.6922345888E-02, 8.3576085112E-02, 4.3361584376E-01],
	[7.1700000000E+03, 3.2658551787E+00, 6.4853700986E+00, 8.7108556794E-02, 8.3749848021E-02, 4.3380985516E-01],
	[7.1750000000E+03, 3.2686720205E+00, 6.4840142159E+00, 8.7295035549E-02, 8.3923840770E-02, 4.3400379725E-01],
	[7.1800000000E+03, 3.2714893271E+00, 6.4826595610E+00, 8.7481782351E-02, 8.4098063463E-02, 4.3419767025E-01],
	[7.1850000000E+03, 3.2743070982E+00, 6.4813061318E+00, 8.7668797396E-02, 8.4272516206E-02, 4.3439147437E-01],
	[7.1900000000E+03, 3.2771253336E+00, 6.4799539264E+00, 8.7856080879E-02, 8.4447199104E-02, 4.3458520981E-01],
	[7.1950000000E+03, 3.2799440330E+00, 6.4786029428E+00, 8.8043632998E-02, 8.4622112262E-02, 4.3477887679E-01],
	[7.2000000000E+03, 3.2827631961E+00, 6.4772531791E+00, 8.8231453948E-02, 8.4797255786E-02, 4.3497247551E-01],
	[7.2050000000E+03, 3.2855828228E+00, 6.4759046334E+00, 8.8419543925E-02, 8.4972629779E-02, 4.3516600618E-01],
	[7.2100000000E+03, 3.2884029127E+00, 6.4745573036E+00, 8.8607903126E-02, 8.5148234347E-02, 4.3535946902E-01],
	[7.2150000000E+03, 3.2912234657E+00, 6.4732111879E+00, 8.8796531748E-02, 8.5324069594E-02, 4.3555286422E-01],
	[7.2200000000E+03, 3.2940453683E+00, 6.4718692579E+00, 8.8985429985E-02, 8.5500136742E-02, 4.3574619200E-01],
	[7.2250000000E+03, 3.2968725818E+00, 6.4705447709E+00, 8.9174598036E-02, 8.5676440905E-02, 4.3593945257E-01],
	[7.2300000000E+03, 3.2997002634E+00, 6.4692214709E+00, 8.9364036095E-02, 8.5852976109E-02, 4.3613264613E-01],
	[7.2350000000E+03, 3.3025284129E+00, 6.4678993561E+00, 8.9553744359E-02, 8.6029742458E-02, 4.3632577288E-01],
	[7.2400000000E+03, 3.3053570301E+00, 6.4665784246E+00, 8.9743723025E-02, 8.6206740057E-02, 4.3651883304E-01],
	[7.2450000000E+03, 3.3081861147E+00, 6.4652586745E+00, 8.9933972289E-02, 8.6383969009E-02, 4.3671182682E-01],
	[7.2500000000E+03, 3.3110156665E+00, 6.4639401039E+00, 9.0124492346E-02, 8.6561429417E-02, 4.3690475441E-01],
	[7.2550000000E+03, 3.3138456852E+00, 6.4626227111E+00, 9.0315283394E-02, 8.6739121386E-02, 4.3709761602E-01],
	[7.2600000000E+03, 3.3166761705E+00, 6.4613064940E+00, 9.0506345628E-02, 8.6917045019E-02, 4.3729041187E-01],
	[7.2650000000E+03, 3.3195071223E+00, 6.4599914510E+00, 9.0697679246E-02, 8.7095200418E-02, 4.3748314215E-01],
	[7.2700000000E+03, 3.3223385403E+00, 6.4586775800E+00, 9.0889284442E-02, 8.7273587688E-02, 4.3767580707E-01],
	[7.2750000000E+03, 3.3251704242E+00, 6.4573648793E+00, 9.1081161414E-02, 8.7452206930E-02, 4.3786840684E-01],
	[7.2800000000E+03, 3.3280027738E+00, 6.4560533471E+00, 9.1273310358E-02, 8.7631058247E-02, 4.3806094166E-01],
	[7.2850000000E+03, 3.3308355889E+00, 6.4547429814E+00, 9.1465731469E-02, 8.7810141743E-02, 4.3825341173E-01],
	[7.2900000000E+03, 3.3336688692E+00, 6.4534337804E+00, 9.1658424945E-02, 8.7989457519E-02, 4.3844581722E-01],
	[7.2950000000E+03, 3.3365026145E+00, 6.4521257423E+00, 9.1851390982E-02, 8.8169005678E-02, 4.3863815829E-01],
	[7.3000000000E+03, 3.3393368245E+00, 6.4508188654E+00, 9.2044629776E-02, 8.8348786322E-02, 4.3883043510E-01],
	[7.3050000000E+03, 3.3421714990E+00, 6.4495131476E+00, 9.2238141523E-02, 8.8528799553E-02, 4.3902264783E-01],
	[7.3100000000E+03, 3.3450066377E+00, 6.4482085873E+00, 9.2431926420E-02, 8.8709045473E-02, 4.3921479663E-01],
	[7.3150000000E+03, 3.3478422405E+00, 6.4469051827E+00, 9.2625984662E-02, 8.8889524183E-02, 4.3940688167E-01],
	[7.3200000000E+03, 3.3506783070E+00, 6.4456029318E+00, 9.2820316448E-02, 8.9070235786E-02, 4.3959890312E-01],
	[7.3250000000E+03, 3.3535148370E+00, 6.4443018329E+00, 9.3014921971E-02, 8.9251180381E-02, 4.3979086113E-01],
	[7.3300000000E+03, 3.3563518303E+00, 6.4430018842E+00, 9.3209801430E-02, 8.9432358071E-02, 4.3998275588E-01],
	[7.3350000000E+03, 3.3591892866E+00, 6.4417030839E+00, 9.3404955020E-02, 8.9613768957E-02, 4.4017458752E-01],
	[7.3400000000E+03, 3.3620322533E+00, 6.4404222128E+00, 9.3600382937E-02, 8.9795420002E-02, 4.4036635622E-01],
	[7.3450000000E+03, 3.3648761823E+00, 6.4391441113E+00, 9.3796085379E-02, 8.9977305166E-02, 4.4055806215E-01],
	[7.3500000000E+03, 3.3677205792E+00, 6.4378671331E+00, 9.3992062541E-02, 9.0159423878E-02, 4.4074970546E-01],
	[7.3550000000E+03, 3.3705654437E+00, 6.4365912762E+00, 9.4188314620E-02, 9.0341776239E-02, 4.4094128631E-01],
	[7.3600000000E+03, 3.3734107757E+00, 6.4353165389E+00, 9.4384841811E-02, 9.0524362350E-02, 4.4113280488E-01],
	[7.3650000000E+03, 3.3762565749E+00, 6.4340429195E+00, 9.4581644313E-02, 9.0707182312E-02, 4.4132426132E-01],
	[7.3700000000E+03, 3.3791028410E+00, 6.4327704163E+00, 9.4778722320E-02, 9.0890236224E-02, 4.4151565580E-01],
	[7.3750000000E+03, 3.3819495739E+00, 6.4314990275E+00, 9.4976076029E-02, 9.1073524187E-02, 4.4170698847E-01],
	[7.3800000000E+03, 3.3847967732E+00, 6.4302287514E+00, 9.5173705637E-02, 9.1257046300E-02, 4.4189825950E-01],
	[7.3850000000E+03, 3.3876444387E+00, 6.4289595863E+00, 9.5371611339E-02, 9.1440802663E-02, 4.4208946906E-01],
	[7.3900000000E+03, 3.3904925702E+00, 6.4276915304E+00, 9.5569793333E-02, 9.1624793375E-02, 4.4228061730E-01],
	[7.3950000000E+03, 3.3933411674E+00, 6.4264245821E+00, 9.5768251815E-02, 9.1809018537E-02, 4.4247170438E-01],
	[7.4000000000E+03, 3.3961902302E+00, 6.4251587395E+00, 9.5966986980E-02, 9.1993478247E-02, 4.4266273047E-01],
	[7.4050000000E+03, 3.3990397582E+00, 6.4238940010E+00, 9.6165999026E-02, 9.2178172604E-02, 4.4285369573E-01],
	[7.4100000000E+03, 3.4018897512E+00, 6.4226303650E+00, 9.6365288149E-02, 9.2363101708E-02, 4.4304460031E-01],
	[7.4150000000E+03, 3.4047402091E+00, 6.4213678296E+00, 9.6564854545E-02, 9.2548265657E-02, 4.4323544439E-01],
	[7.4200000000E+03, 3.4075911315E+00, 6.4201063932E+00, 9.6764698411E-02, 9.2733664549E-02, 4.4342622811E-01],
	[7.4250000000E+03, 3.4104425182E+00, 6.4188460541E+00, 9.6964819943E-02, 9.2919298484E-02, 4.4361695164E-01],
	[7.4300000000E+03, 3.4132943690E+00, 6.4175868105E+00, 9.7165219337E-02, 9.3105167560E-02, 4.4380761514E-01],
	[7.4350000000E+03, 3.4161466836E+00, 6.4163286609E+00, 9.7365896790E-02, 9.3291271874E-02, 4.4399821877E-01],
	[7.4400000000E+03, 3.4189994619E+00, 6.4150716035E+00, 9.7566852498E-02, 9.3477611525E-02, 4.4418876270E-01],
	[7.4450000000E+03, 3.4218527035E+00, 6.4138156367E+00, 9.7768086658E-02, 9.3664186611E-02, 4.4437924707E-01],
	[7.4500000000E+03, 3.4247064082E+00, 6.4125607587E+00, 9.7969599466E-02, 9.3850997229E-02, 4.4456967205E-01],
	[7.4550000000E+03, 3.4275621406E+00, 6.4113121400E+00, 9.8171391119E-02, 9.4038045767E-02, 4.4476003780E-01],
	[7.4600000000E+03, 3.4304221213E+00, 6.4100770961E+00, 9.8373461812E-02, 9.4225335603E-02, 4.4495034448E-01],
	[7.4650000000E+03, 3.4332825697E+00, 6.4088431174E+00, 9.8575811743E-02, 9.4412861315E-02, 4.4514059225E-01],
	[7.4700000000E+03, 3.4361434856E+00, 6.4076102023E+00, 9.8778441107E-02, 9.4600623001E-02, 4.4533078126E-01],
	[7.4750000000E+03, 3.4390048688E+00, 6.4063783490E+00, 9.8981350102E-02, 9.4788620758E-02, 4.4552091168E-01],
	[7.4800000000E+03, 3.4418667191E+00, 6.4051475560E+00, 9.9184538923E-02, 9.4976854683E-02, 4.4571098366E-01],
	[7.4850000000E+03, 3.4447290361E+00, 6.4039178218E+00, 9.9388007768E-02, 9.5165324873E-02, 4.4590099736E-01],
	[7.4900000000E+03, 3.4475918198E+00, 6.4026891445E+00, 9.9591756832E-02, 9.5354031424E-02, 4.4609095294E-01],
	[7.4950000000E+03, 3.4504550697E+00, 6.4014615227E+00, 9.9795786312E-02, 9.5542974433E-02, 4.4628085056E-01],
	[7.5000000000E+03, 3.4533187858E+00, 6.4002349548E+00, 1.0000009640E-01, 9.5732153996E-02, 4.4647069038E-01],
	[7.5050000000E+03, 3.4561829677E+00, 6.3990094390E+00, 1.0020468731E-01, 9.5921570210E-02, 4.4666047255E-01],
	[7.5100000000E+03, 3.4590476153E+00, 6.3977849739E+00, 1.0040955921E-01, 9.6111223170E-02, 4.4685019724E-01],
	[7.5150000000E+03, 3.4619127282E+00, 6.3965615578E+00, 1.0061471232E-01, 9.6301112972E-02, 4.4703986459E-01],
	[7.5200000000E+03, 3.4647783063E+00, 6.3953391891E+00, 1.0082014683E-01, 9.6491239712E-02, 4.4722947477E-01],
	[7.5250000000E+03, 3.4676443494E+00, 6.3941178663E+00, 1.0102586293E-01, 9.6681603486E-02, 4.4741902794E-01],
	[7.5300000000E+03, 3.4705108571E+00, 6.3928975877E+00, 1.0123186082E-01, 9.6872204389E-02, 4.4760852424E-01],
	[7.5350000000E+03, 3.4733778294E+00, 6.3916783518E+00, 1.0143814070E-01, 9.7063042516E-02, 4.4779796385E-01],
	[7.5400000000E+03, 3.4762452658E+00, 6.3904601569E+00, 1.0164470277E-01, 9.7254117962E-02, 4.4798734691E-01],
	[7.5450000000E+03, 3.4791131662E+00, 6.3892430016E+00, 1.0185154721E-01, 9.7445430822E-02, 4.4817667358E-01],
	[7.5500000000E+03, 3.4819815304E+00, 6.3880268841E+00, 1.0205867423E-01, 9.7636981192E-02, 4.4836594402E-01],
	[7.5550000000E+03, 3.4848503582E+00, 6.3868118031E+00, 1.0226608403E-01, 9.7828769165E-02, 4.4855515838E-01],
	[7.5600000000E+03, 3.4877196492E+00, 6.3855977568E+00, 1.0247377680E-01, 9.8020794835E-02, 4.4874431683E-01],
	[7.5650000000E+03, 3.4905894033E+00, 6.3843847437E+00, 1.0268175273E-01, 9.8213058299E-02, 4.4893341951E-01],
	[7.5700000000E+03, 3.4934596202E+00, 6.3831727623E+00, 1.0289001202E-01, 9.8405559648E-02, 4.4912246658E-01],
	[7.5750000000E+03, 3.4963318160E+00, 6.3819667958E+00, 1.0309855488E-01, 9.8598301374E-02, 4.4931145821E-01],
	[7.5800000000E+03, 3.4992081134E+00, 6.3807738004E+00, 1.0330738149E-01, 9.8791286952E-02, 4.4950039453E-01],
	[7.5850000000E+03, 3.5020848780E+00, 6.3795818144E+00, 1.0351649205E-01, 9.8984510752E-02, 4.4968927572E-01],
	[7.5900000000E+03, 3.5049621096E+00, 6.3783908364E+00, 1.0372588677E-01, 9.9177972867E-02, 4.4987810192E-01],
	[7.5950000000E+03, 3.5078398079E+00, 6.3772008647E+00, 1.0393556582E-01, 9.9371673390E-02, 4.5006687330E-01],
	[7.6000000000E+03, 3.5107179727E+00, 6.3760118980E+00, 1.0414552942E-01, 9.9565612415E-02, 4.5025558999E-01],
	[7.6050000000E+03, 3.5135966038E+00, 6.3748239348E+00, 1.0435577776E-01, 9.9759790035E-02, 4.5044425217E-01],
	[7.6100000000E+03, 3.5164757010E+00, 6.3736369734E+00, 1.0456631104E-01, 9.9954206343E-02, 4.5063285998E-01],
	[7.6150000000E+03, 3.5193552640E+00, 6.3724510124E+00, 1.0477712944E-01, 1.0014886143E-01, 4.5082141359E-01],
	[7.6200000000E+03, 3.5222352926E+00, 6.3712660503E+00, 1.0498823318E-01, 1.0034375539E-01, 4.5100991313E-01],
	[7.6250000000E+03, 3.5251157865E+00, 6.3700820857E+00, 1.0519962244E-01, 1.0053888832E-01, 4.5119835878E-01],
	[7.6300000000E+03, 3.5279967456E+00, 6.3688991169E+00, 1.0541129742E-01, 1.0073426031E-01, 4.5138675068E-01],
	[7.6350000000E+03, 3.5308781696E+00, 6.3677171426E+00, 1.0562325831E-01, 1.0092987145E-01, 4.5157508898E-01],
	[7.6400000000E+03, 3.5337600582E+00, 6.3665361612E+00, 1.0583550533E-01, 1.0112572183E-01, 4.5176337385E-01],
	[7.6450000000E+03, 3.5366424113E+00, 6.3653561713E+00, 1.0604803865E-01, 1.0132181155E-01, 4.5195160543E-01],
	[7.6500000000E+03, 3.5395252286E+00, 6.3641771713E+00, 1.0626085848E-01, 1.0151814069E-01, 4.5213978388E-01],
	[7.6550000000E+03, 3.5424085099E+00, 6.3629991599E+00, 1.0647396501E-01, 1.0171470935E-01, 4.5232790935E-01],
	[7.6600000000E+03, 3.5452922549E+00, 6.3618221354E+00, 1.0668735845E-01, 1.0191151762E-01, 4.5251598200E-01],
	[7.6650000000E+03, 3.5481764635E+00, 6.3606460965E+00, 1.0690103898E-01, 1.0210856559E-01, 4.5270400198E-01],
	[7.6700000000E+03, 3.5510611353E+00, 6.3594710418E+00, 1.0711500681E-01, 1.0230585336E-01, 4.5289196944E-01],
	[7.6750000000E+03, 3.5539462703E+00, 6.3582969696E+00, 1.0732926212E-01, 1.0250338100E-01, 4.5307988453E-01],
	[7.6800000000E+03, 3.5568318680E+00, 6.3571238786E+00, 1.0754380512E-01, 1.0270114863E-01, 4.5326774742E-01],
	[7.6850000000E+03, 3.5597179284E+00, 6.3559517673E+00, 1.0775863601E-01, 1.0289915631E-01, 4.5345555824E-01],
	[7.6900000000E+03, 3.5626044512E+00, 6.3547806342E+00, 1.0797375497E-01, 1.0309740415E-01, 4.5364331716E-01],
	[7.6950000000E+03, 3.5654914362E+00, 6.3536104780E+00, 1.0818916222E-01, 1.0329589224E-01, 4.5383102433E-01],
	[7.7000000000E+03, 3.5683833924E+00, 6.3524560528E+00, 1.0840485793E-01, 1.0349462837E-01, 4.5401867989E-01],
	[7.7050000000E+03, 3.5712762631E+00, 6.3513040525E+00, 1.0862084232E-01, 1.0369360575E-01, 4.5420628401E-01],
	[7.7100000000E+03, 3.5741696001E+00, 6.3501530083E+00, 1.0883711557E-01, 1.0389282369E-01, 4.5439383683E-01],
	[7.7150000000E+03, 3.5770634032E+00, 6.3490029186E+00, 1.0905367788E-01, 1.0409228230E-01, 4.5458133851E-01],
	[7.7200000000E+03, 3.5799576721E+00, 6.3478537822E+00, 1.0927052945E-01, 1.0429198165E-01, 4.5476878919E-01],
	[7.7250000000E+03, 3.5828524067E+00, 6.3467055976E+00, 1.0948767048E-01, 1.0449192185E-01, 4.5495618904E-01],
	[7.7300000000E+03, 3.5857476066E+00, 6.3455583634E+00, 1.0970510116E-01, 1.0469210297E-01, 4.5514353816E-01],
	[7.7350000000E+03, 3.5886432717E+00, 6.3444120782E+00, 1.0992282169E-01, 1.0489252511E-01, 4.5533083666E-01],
	[7.7400000000E+03, 3.5915394017E+00, 6.3432667405E+00, 1.1014083227E-01, 1.0509318836E-01, 4.5551808466E-01],
	[7.7450000000E+03, 3.5944359965E+00, 6.3421223491E+00, 1.1035913309E-01, 1.0529409281E-01, 4.5570528227E-01],
	[7.7500000000E+03, 3.5973330557E+00, 6.3409789026E+00, 1.1057772435E-01, 1.0549523854E-01, 4.5589242961E-01],
	[7.7550000000E+03, 3.6002305791E+00, 6.3398363994E+00, 1.1079660624E-01, 1.0569662564E-01, 4.5607952680E-01],
	[7.7600000000E+03, 3.6031285666E+00, 6.3386948383E+00, 1.1101577896E-01, 1.0589825420E-01, 4.5626657395E-01],
	[7.7650000000E+03, 3.6060270179E+00, 6.3375542178E+00, 1.1123524272E-01, 1.0610012432E-01, 4.5645357117E-01],
	[7.7700000000E+03, 3.6089259328E+00, 6.3364145366E+00, 1.1145499770E-01, 1.0630223607E-01, 4.5664051858E-01],
	[7.7750000000E+03, 3.6118253111E+00, 6.3352757933E+00, 1.1167504410E-01, 1.0650458955E-01, 4.5682741629E-01],
	[7.7800000000E+03, 3.6147251525E+00, 6.3341379866E+00, 1.1189538212E-01, 1.0670718484E-01, 4.5701426443E-01],
	[7.7850000000E+03, 3.6176254568E+00, 6.3330011150E+00, 1.1211601195E-01, 1.0691002203E-01, 4.5720106310E-01],
	[7.7900000000E+03, 3.6205262238E+00, 6.3318651771E+00, 1.1233693380E-01, 1.0711310121E-01, 4.5738781242E-01],
	[7.7950000000E+03, 3.6234274532E+00, 6.3307301717E+00, 1.1255814786E-01, 1.0731642247E-01, 4.5757451250E-01],
	[7.8000000000E+03, 3.6263291449E+00, 6.3295960974E+00, 1.1277965432E-01, 1.0751998589E-01, 4.5776116347E-01],
	[7.8050000000E+03, 3.6292312986E+00, 6.3284629528E+00, 1.1300145338E-01, 1.0772379157E-01, 4.5794776543E-01],
	[7.8100000000E+03, 3.6321339141E+00, 6.3273307365E+00, 1.1322354524E-01, 1.0792783957E-01, 4.5813431849E-01],
	[7.8150000000E+03, 3.6350369912E+00, 6.3261994472E+00, 1.1344593010E-01, 1.0813213001E-01, 4.5832082278E-01],
	[7.8200000000E+03, 3.6379411593E+00, 6.3250711399E+00, 1.1366860814E-01, 1.0833666411E-01, 4.5850727841E-01],
	[7.8250000000E+03, 3.6408499195E+00, 6.3239572322E+00, 1.1389157958E-01, 1.0854144846E-01, 4.5869368548E-01],
	[7.8300000000E+03, 3.6437591452E+00, 6.3228442321E+00, 1.1411484460E-01, 1.0874647554E-01, 4.5888004413E-01],
	[7.8350000000E+03, 3.6466688362E+00, 6.3217321381E+00, 1.1433840340E-01, 1.0895174545E-01, 4.5906635445E-01],
	[7.8400000000E+03, 3.6495789921E+00, 6.3206209490E+00, 1.1456225618E-01, 1.0915725828E-01, 4.5925261657E-01],
	[7.8450000000E+03, 3.6524896129E+00, 6.3195106634E+00, 1.1478640314E-01, 1.0936301409E-01, 4.5943883059E-01],
	[7.8500000000E+03, 3.6554006982E+00, 6.3184012802E+00, 1.1501084447E-01, 1.0956901299E-01, 4.5962499664E-01],
	[7.8550000000E+03, 3.6583122479E+00, 6.3172927979E+00, 1.1523558036E-01, 1.0977525506E-01, 4.5981111482E-01],
	[7.8600000000E+03, 3.6612242618E+00, 6.3161852152E+00, 1.1546061103E-01, 1.0998174038E-01, 4.5999718525E-01],
	[7.8650000000E+03, 3.6641367395E+00, 6.3150785309E+00, 1.1568593665E-01, 1.1018846904E-01, 4.6018320805E-01],
	[7.8700000000E+03, 3.6670496809E+00, 6.3139727436E+00, 1.1591155743E-01, 1.1039544112E-01, 4.6036918333E-01],
	[7.8750000000E+03, 3.6699630858E+00, 6.3128678521E+00, 1.1613747357E-01, 1.1060265670E-01, 4.6055511119E-01],
	[7.8800000000E+03, 3.6728769540E+00, 6.3117638551E+00, 1.1636368525E-01, 1.1081011589E-01, 4.6074099176E-01],
	[7.8850000000E+03, 3.6757912852E+00, 6.3106607512E+00, 1.1659019269E-01, 1.1101781874E-01, 4.6092682515E-01],
	[7.8900000000E+03, 3.6787060792E+00, 6.3095585392E+00, 1.1681699607E-01, 1.1122576536E-01, 4.6111261147E-01],
	[7.8950000000E+03, 3.6816213358E+00, 6.3084572177E+00, 1.1704409559E-01, 1.1143395583E-01, 4.6129835084E-01],
	[7.9000000000E+03, 3.6845370547E+00, 6.3073567856E+00, 1.1727149145E-01, 1.1164239022E-01, 4.6148404336E-01],
	[7.9050000000E+03, 3.6874532358E+00, 6.3062572416E+00, 1.1749918385E-01, 1.1185106863E-01, 4.6166968916E-01],
	[7.9100000000E+03, 3.6903698789E+00, 6.3051585842E+00, 1.1772717298E-01, 1.1205999113E-01, 4.6185528834E-01],
	[7.9150000000E+03, 3.6932869836E+00, 6.3040608124E+00, 1.1795545904E-01, 1.1226915782E-01, 4.6204084101E-01],
	[7.9200000000E+03, 3.6962045498E+00, 6.3029639248E+00, 1.1818404222E-01, 1.1247856877E-01, 4.6222634730E-01],
	[7.9250000000E+03, 3.6991225774E+00, 6.3018679200E+00, 1.1841292272E-01, 1.1268822407E-01, 4.6241180732E-01],
	[7.9300000000E+03, 3.7020410659E+00, 6.3007727970E+00, 1.1864210075E-01, 1.1289812379E-01, 4.6259722117E-01],
	[7.9350000000E+03, 3.7049600154E+00, 6.2996785544E+00, 1.1887157648E-01, 1.1310826803E-01, 4.6278258897E-01],
	[7.9400000000E+03, 3.7078794254E+00, 6.2985851909E+00, 1.1910135013E-01, 1.1331865687E-01, 4.6296791084E-01],
	[7.9450000000E+03, 3.7107992958E+00, 6.2974927053E+00, 1.1933142189E-01, 1.1352929039E-01, 4.6315318688E-01],
	[7.9500000000E+03, 3.7137239925E+00, 6.2964153161E+00, 1.1956179196E-01, 1.1374017740E-01, 4.6333841720E-01],
	[7.9550000000E+03, 3.7166493533E+00, 6.2953394397E+00, 1.1979246052E-01, 1.1395130971E-01, 4.6352360193E-01],
	[7.9600000000E+03, 3.7195751782E+00, 6.2942644230E+00, 1.2002342779E-01, 1.1416268700E-01, 4.6370874118E-01],
	[7.9650000000E+03, 3.7225014670E+00, 6.2931902647E+00, 1.2025469395E-01, 1.1437430935E-01, 4.6389383505E-01],
	[7.9700000000E+03, 3.7254282194E+00, 6.2921169636E+00, 1.2048625920E-01, 1.1458617686E-01, 4.6407888366E-01],
	[7.9750000000E+03, 3.7283554352E+00, 6.2910445186E+00, 1.2071812375E-01, 1.1479828959E-01, 4.6426388712E-01],
	[7.9800000000E+03, 3.7312831142E+00, 6.2899729283E+00, 1.2095028778E-01, 1.1501064762E-01, 4.6444884554E-01],
	[7.9850000000E+03, 3.7342112562E+00, 6.2889021916E+00, 1.2118275149E-01, 1.1522325105E-01, 4.6463375904E-01],
	[7.9900000000E+03, 3.7371398610E+00, 6.2878323073E+00, 1.2141551508E-01, 1.1543609996E-01, 4.6481862773E-01],
	[7.9950000000E+03, 3.7400689283E+00, 6.2867632741E+00, 1.2164857875E-01, 1.1564919441E-01, 4.6500345172E-01],
	[8.0000000000E+03, 3.7429984579E+00, 6.2856950909E+00, 1.2188194269E-01, 1.1586253450E-01, 4.6518823112E-01],
	[8.0050000000E+03, 3.7459284496E+00, 6.2846277564E+00, 1.2211696111E-01, 1.1607734370E-01, 4.6537296604E-01],
	[8.0100000000E+03, 3.7488589033E+00, 6.2835612694E+00, 1.2235228455E-01, 1.1629240226E-01, 4.6555765661E-01],
	[8.0150000000E+03, 3.7517898186E+00, 6.2824956287E+00, 1.2258791319E-01, 1.1650771025E-01, 4.6574230292E-01],
	[8.0200000000E+03, 3.7547211954E+00, 6.2814308332E+00, 1.2282384724E-01, 1.1672326776E-01, 4.6592690509E-01],
	[8.0250000000E+03, 3.7576530334E+00, 6.2803668816E+00, 1.2306008690E-01, 1.1693907487E-01, 4.6611146323E-01],
	[8.0300000000E+03, 3.7605853325E+00, 6.2793037727E+00, 1.2329663238E-01, 1.1715513167E-01, 4.6629597746E-01],
	[8.0350000000E+03, 3.7635180924E+00, 6.2782415054E+00, 1.2353348388E-01, 1.1737143824E-01, 4.6648044789E-01],
	[8.0400000000E+03, 3.7664513129E+00, 6.2771800784E+00, 1.2377064160E-01, 1.1758799467E-01, 4.6666487462E-01],
	[8.0450000000E+03, 3.7693849938E+00, 6.2761194906E+00, 1.2400810574E-01, 1.1780480103E-01, 4.6684925777E-01],
	[8.0500000000E+03, 3.7723191349E+00, 6.2750597408E+00, 1.2424587651E-01, 1.1802185740E-01, 4.6703359745E-01],
	[8.0550000000E+03, 3.7752537359E+00, 6.2740008277E+00, 1.2448395412E-01, 1.1823916388E-01, 4.6721789378E-01],
	[8.0600000000E+03, 3.7781887967E+00, 6.2729427503E+00, 1.2472233875E-01, 1.1845672054E-01, 4.6740214686E-01],
	[8.0650000000E+03, 3.7811243171E+00, 6.2718855074E+00, 1.2496103063E-01, 1.1867452747E-01, 4.6758635681E-01],
	[8.0700000000E+03, 3.7840602968E+00, 6.2708290977E+00, 1.2520002994E-01, 1.1889258474E-01, 4.6777052373E-01],
	[8.0750000000E+03, 3.7869984064E+00, 6.2697788738E+00, 1.2543933690E-01, 1.1911089602E-01, 4.6795464774E-01],
	[8.0800000000E+03, 3.7899397655E+00, 6.2687384039E+00, 1.2567895170E-01, 1.1932946384E-01, 4.6813872895E-01],
	[8.0850000000E+03, 3.7928815875E+00, 6.2676987502E+00, 1.2591887455E-01, 1.1954828231E-01, 4.6832276748E-01],
	[8.0900000000E+03, 3.7958238721E+00, 6.2666599115E+00, 1.2615910566E-01, 1.1976735151E-01, 4.6850676342E-01],
	[8.0950000000E+03, 3.7987666191E+00, 6.2656218867E+00, 1.2639964522E-01, 1.1998667153E-01, 4.6869071690E-01],
	[8.1000000000E+03, 3.8017098284E+00, 6.2645846746E+00, 1.2664049343E-01, 1.2020624244E-01, 4.6887462802E-01],
	[8.1050000000E+03, 3.8046534996E+00, 6.2635482741E+00, 1.2688165051E-01, 1.2042606432E-01, 4.6905849690E-01],
	[8.1100000000E+03, 3.8075976326E+00, 6.2625126841E+00, 1.2712311665E-01, 1.2064613726E-01, 4.6924232365E-01],
	[8.1150000000E+03, 3.8105422272E+00, 6.2614779034E+00, 1.2736489206E-01, 1.2086646134E-01, 4.6942610837E-01],
	[8.1200000000E+03, 3.8134872832E+00, 6.2604439309E+00, 1.2760697694E-01, 1.2108703664E-01, 4.6960985118E-01],
	[8.1250000000E+03, 3.8164328003E+00, 6.2594107655E+00, 1.2784937149E-01, 1.2130786323E-01, 4.6979355219E-01],
	[8.1300000000E+03, 3.8193787783E+00, 6.2583784060E+00, 1.2809207592E-01, 1.2152894120E-01, 4.6997721151E-01],
	[8.1350000000E+03, 3.8223252170E+00, 6.2573468514E+00, 1.2833509043E-01, 1.2175027063E-01, 4.7016082926E-01],
	[8.1400000000E+03, 3.8252721163E+00, 6.2563161004E+00, 1.2857841522E-01, 1.2197185159E-01, 4.7034440553E-01],
	[8.1450000000E+03, 3.8282194758E+00, 6.2552861520E+00, 1.2882205049E-01, 1.2219368417E-01, 4.7052794044E-01],
	[8.1500000000E+03, 3.8311672955E+00, 6.2542570051E+00, 1.2906599646E-01, 1.2241576845E-01, 4.7071143404E-01],
	[8.1550000000E+03, 3.8341155750E+00, 6.2532286585E+00, 1.2931025331E-01, 1.2263810450E-01, 4.7089488642E-01],
	[8.1600000000E+03, 3.8370643142E+00, 6.2522011112E+00, 1.2955482126E-01, 1.2286069241E-01, 4.7107829766E-01],
	[8.1650000000E+03, 3.8400135129E+00, 6.2511743620E+00, 1.2979970051E-01, 1.2308353225E-01, 4.7126166783E-01],
	[8.1700000000E+03, 3.8429631708E+00, 6.2501484098E+00, 1.3004489126E-01, 1.2330662410E-01, 4.7144499701E-01],
	[8.1750000000E+03, 3.8459132877E+00, 6.2491232536E+00, 1.3029039371E-01, 1.2352996804E-01, 4.7162828529E-01],
	[8.1800000000E+03, 3.8488638635E+00, 6.2480988921E+00, 1.3053620807E-01, 1.2375356415E-01, 4.7181153273E-01],
	[8.1850000000E+03, 3.8518148979E+00, 6.2470753243E+00, 1.3078233454E-01, 1.2397741250E-01, 4.7199473943E-01],
	[8.1900000000E+03, 3.8547663907E+00, 6.2460525492E+00, 1.3102877332E-01, 1.2420151318E-01, 4.7217790546E-01],
	[8.1950000000E+03, 3.8577183417E+00, 6.2450305656E+00, 1.3127552462E-01, 1.2442586626E-01, 4.7236103090E-01],
	[8.2000000000E+03, 3.8606707507E+00, 6.2440093723E+00, 1.3152258864E-01, 1.2465047183E-01, 4.7254411583E-01],
	[8.2050000000E+03, 3.8636253060E+00, 6.2429942168E+00, 1.3176996558E-01, 1.2487533381E-01, 4.7272716033E-01],
	[8.2100000000E+03, 3.8665830594E+00, 6.2419883501E+00, 1.3201765565E-01, 1.2510045473E-01, 4.7291016448E-01],
	[8.2150000000E+03, 3.8695412742E+00, 6.2409832578E+00, 1.3226565905E-01, 1.2532582843E-01, 4.7309312836E-01],
	[8.2200000000E+03, 3.8724999503E+00, 6.2399789387E+00, 1.3251397597E-01, 1.2555145497E-01, 4.7327605204E-01],
	[8.2250000000E+03, 3.8754590874E+00, 6.2389753918E+00, 1.3276260664E-01, 1.2577733445E-01, 4.7345893561E-01],
	[8.2300000000E+03, 3.8784186854E+00, 6.2379726160E+00, 1.3301155124E-01, 1.2600346692E-01, 4.7364177914E-01],
	[8.2350000000E+03, 3.8813787439E+00, 6.2369706103E+00, 1.3326080998E-01, 1.2622985248E-01, 4.7382458273E-01],
	[8.2400000000E+03, 3.8843392628E+00, 6.2359693736E+00, 1.3351038307E-01, 1.2645649120E-01, 4.7400734643E-01],
	[8.2450000000E+03, 3.8873002420E+00, 6.2349689048E+00, 1.3376027071E-01, 1.2668338315E-01, 4.7419007034E-01],
	[8.2500000000E+03, 3.8902616811E+00, 6.2339692029E+00, 1.3401047309E-01, 1.2691052840E-01, 4.7437275453E-01],
	[8.2550000000E+03, 3.8932235800E+00, 6.2329702669E+00, 1.3426099044E-01, 1.2713792704E-01, 4.7455539908E-01],
	[8.2600000000E+03, 3.8961859384E+00, 6.2319720957E+00, 1.3451182293E-01, 1.2736557915E-01, 4.7473800408E-01],
	[8.2650000000E+03, 3.8991487563E+00, 6.2309746882E+00, 1.3476297079E-01, 1.2759348479E-01, 4.7492056959E-01],
	[8.2700000000E+03, 3.9021120333E+00, 6.2299780434E+00, 1.3501443422E-01, 1.2782164404E-01, 4.7510309571E-01],
	[8.2750000000E+03, 3.9050757692E+00, 6.2289821602E+00, 1.3526621341E-01, 1.2805005697E-01, 4.7528558250E-01],
	[8.2800000000E+03, 3.9080399639E+00, 6.2279870377E+00, 1.3551830857E-01, 1.2827872367E-01, 4.7546803005E-01],
	[8.2850000000E+03, 3.9110046171E+00, 6.2269926747E+00, 1.3577071990E-01, 1.2850764421E-01, 4.7565043844E-01],
	[8.2900000000E+03, 3.9139697286E+00, 6.2259990703E+00, 1.3602344761E-01, 1.2873681865E-01, 4.7583280774E-01],
	[8.2950000000E+03, 3.9169352983E+00, 6.2250062233E+00, 1.3627649190E-01, 1.2896624708E-01, 4.7601513804E-01],
	[8.3000000000E+03, 3.9199013259E+00, 6.2240141329E+00, 1.3652985297E-01, 1.2919592957E-01, 4.7619742942E-01],
	[8.3050000000E+03, 3.9228678112E+00, 6.2230227978E+00, 1.3678353103E-01, 1.2942586620E-01, 4.7637968195E-01],
	[8.3100000000E+03, 3.9258347540E+00, 6.2220322172E+00, 1.3703752628E-01, 1.2965605703E-01, 4.7656189571E-01],
	[8.3150000000E+03, 3.9288021542E+00, 6.2210423900E+00, 1.3729183892E-01, 1.2988650214E-01, 4.7674407078E-01],
	[8.3200000000E+03, 3.9317700114E+00, 6.2200533151E+00, 1.3754646916E-01, 1.3011720161E-01, 4.7692620725E-01],
	[8.3250000000E+03, 3.9347383255E+00, 6.2190649915E+00, 1.3780141720E-01, 1.3034815551E-01, 4.7710830519E-01],
	[8.3300000000E+03, 3.9377070963E+00, 6.2180774182E+00, 1.3805668324E-01, 1.3057936391E-01, 4.7729036467E-01],
	[8.3350000000E+03, 3.9406763236E+00, 6.2170905942E+00, 1.3831226748E-01, 1.3081082688E-01, 4.7747238578E-01],
	[8.3400000000E+03, 3.9436502714E+00, 6.2161173615E+00, 1.3856817014E-01, 1.3104255491E-01, 4.7765436860E-01],
	[8.3450000000E+03, 3.9466248121E+00, 6.2151452647E+00, 1.3882439140E-01, 1.3127453806E-01, 4.7783631321E-01],
	[8.3500000000E+03, 3.9495998127E+00, 6.2141739021E+00, 1.3908093148E-01, 1.3150677606E-01, 4.7801821968E-01],
	[8.3550000000E+03, 3.9525752729E+00, 6.2132032726E+00, 1.3933779058E-01, 1.3173926899E-01, 4.7820008810E-01],
	[8.3600000000E+03, 3.9555511927E+00, 6.2122333753E+00, 1.3959496891E-01, 1.3197201692E-01, 4.7838191854E-01],
	[8.3650000000E+03, 3.9585275716E+00, 6.2112642092E+00, 1.3985246665E-01, 1.3220501993E-01, 4.7856371108E-01],
	[8.3700000000E+03, 3.9615044097E+00, 6.2102957732E+00, 1.4011028403E-01, 1.3243827808E-01, 4.7874546581E-01],
	[8.3750000000E+03, 3.9644817065E+00, 6.2093280665E+00, 1.4036842124E-01, 1.3267179145E-01, 4.7892718279E-01],
	[8.3800000000E+03, 3.9674594620E+00, 6.2083610880E+00, 1.4062687848E-01, 1.3290556011E-01, 4.7910886212E-01],
	[8.3850000000E+03, 3.9704376760E+00, 6.2073948367E+00, 1.4088565596E-01, 1.3313958413E-01, 4.7929050386E-01],
	[8.3900000000E+03, 3.9734163482E+00, 6.2064293117E+00, 1.4114475389E-01, 1.3337386358E-01, 4.7947210810E-01],
	[8.3950000000E+03, 3.9763954784E+00, 6.2054645119E+00, 1.4140417246E-01, 1.3360839853E-01, 4.7965367492E-01],
	[8.4000000000E+03, 3.9793750665E+00, 6.2045004365E+00, 1.4166391187E-01, 1.3384318906E-01, 4.7983520439E-01],
	[8.4050000000E+03, 3.9823551122E+00, 6.2035370843E+00, 1.4192397234E-01, 1.3407823523E-01, 4.8001669659E-01],
	[8.4100000000E+03, 3.9853356154E+00, 6.2025744546E+00, 1.4218435407E-01, 1.3431353712E-01, 4.8019815161E-01],
	[8.4150000000E+03, 3.9883165757E+00, 6.2016125462E+00, 1.4244505725E-01, 1.3454909480E-01, 4.8037956953E-01],
	[8.4200000000E+03, 3.9912979931E+00, 6.2006513582E+00, 1.4270608209E-01, 1.3478490833E-01, 4.8056095041E-01],
	[8.4250000000E+03, 3.9942798673E+00, 6.1996908897E+00, 1.4296742880E-01, 1.3502097778E-01, 4.8074229434E-01],
	[8.4300000000E+03, 3.9972621982E+00, 6.1987311397E+00, 1.4322909758E-01, 1.3525730323E-01, 4.8092360141E-01],
	[8.4350000000E+03, 4.0002449854E+00, 6.1977721072E+00, 1.4349108863E-01, 1.3549388475E-01, 4.8110487168E-01],
	[8.4400000000E+03, 4.0032282289E+00, 6.1968137912E+00, 1.4375340215E-01, 1.3573072240E-01, 4.8128610523E-01],
	[8.4450000000E+03, 4.0062119284E+00, 6.1958561909E+00, 1.4401603836E-01, 1.3596781626E-01, 4.8146730216E-01],
	[8.4500000000E+03, 4.0091960837E+00, 6.1948993052E+00, 1.4427899744E-01, 1.3620516638E-01, 4.8164846252E-01],
	[8.4550000000E+03, 4.0121806947E+00, 6.1939431331E+00, 1.4454227961E-01, 1.3644277285E-01, 4.8182958642E-01],
	[8.4600000000E+03, 4.0151657610E+00, 6.1929876738E+00, 1.4480588507E-01, 1.3668063574E-01, 4.8201067391E-01],
	[8.4650000000E+03, 4.0181512826E+00, 6.1920329263E+00, 1.4506981402E-01, 1.3691875510E-01, 4.8219172508E-01],
	[8.4700000000E+03, 4.0211378391E+00, 6.1910805838E+00, 1.4533406667E-01, 1.3715713251E-01, 4.8237274002E-01],
	[8.4750000000E+03, 4.0241286377E+00, 6.1901400040E+00, 1.4559864321E-01, 1.3739577641E-01, 4.8255371879E-01],
	[8.4800000000E+03, 4.0271198949E+00, 6.1892001218E+00, 1.4586354386E-01, 1.3763467706E-01, 4.8273466148E-01],
	[8.4850000000E+03, 4.0301116104E+00, 6.1882609361E+00, 1.4612876881E-01, 1.3787383453E-01, 4.8291556817E-01],
	[8.4900000000E+03, 4.0331037840E+00, 6.1873224462E+00, 1.4639467521E-01, 1.3811356658E-01, 4.8309643893E-01],
	[8.4950000000E+03, 4.0360964156E+00, 6.1863846509E+00, 1.4666092880E-01, 1.3835357549E-01, 4.8327727385E-01],
	[8.5000000000E+03, 4.0390895049E+00, 6.1854475495E+00, 1.4692750865E-01, 1.3859384251E-01, 4.8345807300E-01],
	[8.5050000000E+03, 4.0420830517E+00, 6.1845111410E+00, 1.4719441496E-01, 1.3883436770E-01, 4.8363883647E-01],
	[8.5100000000E+03, 4.0450770559E+00, 6.1835754244E+00, 1.4746164795E-01, 1.3907515115E-01, 4.8381956432E-01],
	[8.5150000000E+03, 4.0480715172E+00, 6.1826403990E+00, 1.4772920782E-01, 1.3931619290E-01, 4.8400025664E-01],
	[8.5200000000E+03, 4.0510664354E+00, 6.1817060636E+00, 1.4799709477E-01, 1.3955749305E-01, 4.8418091351E-01],
	[8.5250000000E+03, 4.0540618104E+00, 6.1807724175E+00, 1.4826530901E-01, 1.3979905164E-01, 4.8436153501E-01],
	[8.5300000000E+03, 4.0570576419E+00, 6.1798394598E+00, 1.4853385074E-01, 1.4004086875E-01, 4.8454212122E-01],
	[8.5350000000E+03, 4.0600539298E+00, 6.1789071894E+00, 1.4880272018E-01, 1.4028294445E-01, 4.8472267221E-01],
	[8.5400000000E+03, 4.0630506738E+00, 6.1779756055E+00, 1.4907191752E-01, 1.4052527880E-01, 4.8490318806E-01],
	[8.5450000000E+03, 4.0660478738E+00, 6.1770447073E+00, 1.4934144298E-01, 1.4076787187E-01, 4.8508366883E-01],
	[8.5500000000E+03, 4.0690455295E+00, 6.1761144937E+00, 1.4961129675E-01, 1.4101072373E-01, 4.8526411455E-01],
	[8.5550000000E+03, 4.0720436407E+00, 6.1751849639E+00, 1.4988147905E-01, 1.4125383445E-01, 4.8544452529E-01],
	[8.5600000000E+03, 4.0750422074E+00, 6.1742561170E+00, 1.5015199008E-01, 1.4149720409E-01, 4.8562490109E-01],
	[8.5650000000E+03, 4.0780412292E+00, 6.1733279520E+00, 1.5042283004E-01, 1.4174083272E-01, 4.8580524200E-01],
	[8.5700000000E+03, 4.0810407059E+00, 6.1724004682E+00, 1.5069399915E-01, 1.4198472040E-01, 4.8598554809E-01],
	[8.5750000000E+03, 4.0840406374E+00, 6.1714736645E+00, 1.5096549761E-01, 1.4222886720E-01, 4.8616581940E-01],
	[8.5800000000E+03, 4.0870410235E+00, 6.1705475402E+00, 1.5123732561E-01, 1.4247327319E-01, 4.8634605598E-01],
	[8.5850000000E+03, 4.0900418639E+00, 6.1696220942E+00, 1.5150948338E-01, 1.4271793843E-01, 4.8652625789E-01],
	[8.5900000000E+03, 4.0930431586E+00, 6.1686973258E+00, 1.5178197112E-01, 1.4296286299E-01, 4.8670642518E-01],
	[8.5950000000E+03, 4.0960449072E+00, 6.1677732339E+00, 1.5205478902E-01, 1.4320804694E-01, 4.8688655791E-01],
	[8.6000000000E+03, 4.0990471096E+00, 6.1668498178E+00, 1.5232793730E-01, 1.4345349033E-01, 4.8706665612E-01],
	[8.6050000000E+03, 4.1020497656E+00, 6.1659270766E+00, 1.5260141617E-01, 1.4369919324E-01, 4.8724671987E-01],
	[8.6100000000E+03, 4.1050566205E+00, 6.1650156087E+00, 1.5287522582E-01, 1.4394516611E-01, 4.8742674921E-01],
	[8.6150000000E+03, 4.1080645223E+00, 6.1641064740E+00, 1.5314936647E-01, 1.4419140033E-01, 4.8760674420E-01],
	[8.6200000000E+03, 4.1110728811E+00, 6.1631980007E+00, 1.5342383831E-01, 1.4443789432E-01, 4.8778670489E-01],
	[8.6250000000E+03, 4.1140816964E+00, 6.1622901880E+00, 1.5369864157E-01, 1.4468464815E-01, 4.8796663133E-01],
	[8.6300000000E+03, 4.1170909682E+00, 6.1613830351E+00, 1.5397377644E-01, 1.4493166190E-01, 4.8814652357E-01],
	[8.6350000000E+03, 4.1201006962E+00, 6.1604765410E+00, 1.5424924312E-01, 1.4517893561E-01, 4.8832638167E-01],
	[8.6400000000E+03, 4.1231108803E+00, 6.1595707049E+00, 1.5452504183E-01, 1.4542646935E-01, 4.8850620568E-01],
	[8.6450000000E+03, 4.1261215203E+00, 6.1586655259E+00, 1.5480117277E-01, 1.4567426320E-01, 4.8868599565E-01],
	[8.6500000000E+03, 4.1291326159E+00, 6.1577610032E+00, 1.5507763615E-01, 1.4592231721E-01, 4.8886575165E-01],
	[8.6550000000E+03, 4.1321441670E+00, 6.1568571359E+00, 1.5535443217E-01, 1.4617063144E-01, 4.8904547371E-01],
	[8.6600000000E+03, 4.1351561733E+00, 6.1559539232E+00, 1.5563156103E-01, 1.4641920596E-01, 4.8922516189E-01],
	[8.6650000000E+03, 4.1381686348E+00, 6.1550513643E+00, 1.5590902295E-01, 1.4666804084E-01, 4.8940481625E-01],
	[8.6700000000E+03, 4.1411815511E+00, 6.1541494582E+00, 1.5618681813E-01, 1.4691713613E-01, 4.8958443684E-01],
	[8.6750000000E+03, 4.1441949221E+00, 6.1532482041E+00, 1.5646494678E-01, 1.4716649189E-01, 4.8976402372E-01],
	[8.6800000000E+03, 4.1472087477E+00, 6.1523476012E+00, 1.5674340910E-01, 1.4741610820E-01, 4.8994357692E-01],
	[8.6850000000E+03, 4.1502230275E+00, 6.1514476486E+00, 1.5702220529E-01, 1.4766598511E-01, 4.9012309652E-01],
	[8.6900000000E+03, 4.1532377614E+00, 6.1505483455E+00, 1.5730133557E-01, 1.4791612268E-01, 4.9030258256E-01],
	[8.6950000000E+03, 4.1562529493E+00, 6.1496496911E+00, 1.5758080014E-01, 1.4816652098E-01, 4.9048203510E-01],
	[8.7000000000E+03, 4.1592685909E+00, 6.1487516845E+00, 1.5786059921E-01, 1.4841718007E-01, 4.9066145418E-01],
	[8.7050000000E+03, 4.1622846860E+00, 6.1478543248E+00, 1.5814073297E-01, 1.4866810001E-01, 4.9084083987E-01],
	[8.7100000000E+03, 4.1653012345E+00, 6.1469576113E+00, 1.5842120165E-01, 1.4891928086E-01, 4.9102019221E-01],
	[8.7150000000E+03, 4.1683182362E+00, 6.1460615430E+00, 1.5870200544E-01, 1.4917072268E-01, 4.9119951126E-01],
	[8.7200000000E+03, 4.1713356907E+00, 6.1451661192E+00, 1.5898314454E-01, 1.4942242553E-01, 4.9137879707E-01],
	[8.7250000000E+03, 4.1743535981E+00, 6.1442713391E+00, 1.5926461918E-01, 1.4967438948E-01, 4.9155804970E-01],
	[8.7300000000E+03, 4.1773719580E+00, 6.1433772017E+00, 1.5954642954E-01, 1.4992661458E-01, 4.9173726920E-01],
	[8.7350000000E+03, 4.1803907704E+00, 6.1424837063E+00, 1.5982857585E-01, 1.5017910090E-01, 4.9191645562E-01],
	[8.7400000000E+03, 4.1834100349E+00, 6.1415908521E+00, 1.6011105829E-01, 1.5043184850E-01, 4.9209560902E-01],
	[8.7450000000E+03, 4.1864304224E+00, 6.1407004794E+00, 1.6039387709E-01, 1.5068485940E-01, 4.9227472944E-01],
	[8.7500000000E+03, 4.1894548964E+00, 6.1398207071E+00, 1.6067703245E-01, 1.5093814246E-01, 4.9245381695E-01],
	[8.7550000000E+03, 4.1924798258E+00, 6.1389415634E+00, 1.6096052456E-01, 1.5119168704E-01, 4.9263287160E-01],
	[8.7600000000E+03, 4.1955052103E+00, 6.1380630473E+00, 1.6124435364E-01, 1.5144549320E-01, 4.9281189343E-01],
	[8.7650000000E+03, 4.1985310498E+00, 6.1371851582E+00, 1.6152851990E-01, 1.5169956102E-01, 4.9299088251E-01],
	[8.7700000000E+03, 4.2015573441E+00, 6.1363078952E+00, 1.6181302354E-01, 1.5195389054E-01, 4.9316983888E-01],
	[8.7750000000E+03, 4.2045840930E+00, 6.1354312575E+00, 1.6209786477E-01, 1.5220848182E-01, 4.9334876261E-01],
	[8.7800000000E+03, 4.2076112964E+00, 6.1345552442E+00, 1.6238304378E-01, 1.5246333493E-01, 4.9352765374E-01],
	[8.7850000000E+03, 4.2106389540E+00, 6.1336798547E+00, 1.6266856080E-01, 1.5271844992E-01, 4.9370651233E-01],
	[8.7900000000E+03, 4.2136670656E+00, 6.1328050880E+00, 1.6295441602E-01, 1.5297382686E-01, 4.9388533842E-01],
	[8.7950000000E+03, 4.2166956310E+00, 6.1319309435E+00, 1.6324060965E-01, 1.5322946579E-01, 4.9406413209E-01],
	[8.8000000000E+03, 4.2197246501E+00, 6.1310574203E+00, 1.6352714190E-01, 1.5348536678E-01, 4.9424289337E-01],
	[8.8050000000E+03, 4.2227541227E+00, 6.1301845176E+00, 1.6381401297E-01, 1.5374152989E-01, 4.9442162232E-01],
	[8.8100000000E+03, 4.2257840485E+00, 6.1293122346E+00, 1.6410122307E-01, 1.5399795518E-01, 4.9460031901E-01],
	[8.8150000000E+03, 4.2288144275E+00, 6.1284405705E+00, 1.6438877241E-01, 1.5425464269E-01, 4.9477898347E-01],
	[8.8200000000E+03, 4.2318452593E+00, 6.1275695245E+00, 1.6467666118E-01, 1.5451159250E-01, 4.9495761576E-01],
	[8.8250000000E+03, 4.2348765438E+00, 6.1266990959E+00, 1.6496488961E-01, 1.5476880465E-01, 4.9513621594E-01],
	[8.8300000000E+03, 4.2379082809E+00, 6.1258292839E+00, 1.6525345788E-01, 1.5502627921E-01, 4.9531478406E-01],
	[8.8350000000E+03, 4.2409404703E+00, 6.1249600877E+00, 1.6554236622E-01, 1.5528401622E-01, 4.9549332018E-01],
	[8.8400000000E+03, 4.2439731118E+00, 6.1240915064E+00, 1.6583161483E-01, 1.5554201576E-01, 4.9567182434E-01],
	[8.8450000000E+03, 4.2470062053E+00, 6.1232235393E+00, 1.6612120390E-01, 1.5580027787E-01, 4.9585029661E-01],
	[8.8500000000E+03, 4.2500397505E+00, 6.1223561857E+00, 1.6641113366E-01, 1.5605880261E-01, 4.9602873704E-01],
	[8.8550000000E+03, 4.2530737473E+00, 6.1214894447E+00, 1.6670140430E-01, 1.5631759003E-01, 4.9620714567E-01],
	[8.8600000000E+03, 4.2561081956E+00, 6.1206233156E+00, 1.6699201603E-01, 1.5657664020E-01, 4.9638552257E-01],
	[8.8650000000E+03, 4.2591430950E+00, 6.1197577976E+00, 1.6728296905E-01, 1.5683595317E-01, 4.9656386779E-01],
	[8.8700000000E+03, 4.2621784454E+00, 6.1188928899E+00, 1.6757426358E-01, 1.5709552899E-01, 4.9674218137E-01],
	[8.8750000000E+03, 4.2652142467E+00, 6.1180285918E+00, 1.6786589982E-01, 1.5735536772E-01, 4.9692046339E-01],
	[8.8800000000E+03, 4.2682504985E+00, 6.1171649024E+00, 1.6815787797E-01, 1.5761546942E-01, 4.9709871388E-01],
	[8.8850000000E+03, 4.2712872091E+00, 6.1163018429E+00, 1.6845019825E-01, 1.5787583416E-01, 4.9727693291E-01],
	[8.8900000000E+03, 4.2743286358E+00, 6.1154507217E+00, 1.6874286085E-01, 1.5813647540E-01, 4.9745512053E-01],
	[8.8950000000E+03, 4.2773705163E+00, 6.1146001974E+00, 1.6903586599E-01, 1.5839737983E-01, 4.9763327678E-01],
	[8.9000000000E+03, 4.2804128503E+00, 6.1137502693E+00, 1.6932921387E-01, 1.5865854753E-01, 4.9781140174E-01],
	[8.9050000000E+03, 4.2834556377E+00, 6.1129009366E+00, 1.6962290470E-01, 1.5891997854E-01, 4.9798949544E-01],
	[8.9100000000E+03, 4.2864988783E+00, 6.1120521985E+00, 1.6991693867E-01, 1.5918167292E-01, 4.9816755795E-01],
	[8.9150000000E+03, 4.2895425719E+00, 6.1112040543E+00, 1.7021131601E-01, 1.5944363072E-01, 4.9834558931E-01],
	[8.9200000000E+03, 4.2925867184E+00, 6.1103565032E+00, 1.7050603691E-01, 1.5970585200E-01, 4.9852358959E-01],
	[8.9250000000E+03, 4.2956313174E+00, 6.1095095446E+00, 1.7080110159E-01, 1.5996833680E-01, 4.9870155880E-01],
	[8.9300000000E+03, 4.2986763689E+00, 6.1086631776E+00, 1.7109651024E-01, 1.6023108519E-01, 4.9887949699E-01],
	[8.9350000000E+03, 4.3017218727E+00, 6.1078174015E+00, 1.7139226307E-01, 1.6049409722E-01, 4.9905740417E-01],
	[8.9400000000E+03, 4.3047678285E+00, 6.1069722156E+00, 1.7168836030E-01, 1.6075737294E-01, 4.9923528039E-01],
	[8.9450000000E+03, 4.3078142362E+00, 6.1061276191E+00, 1.7198480212E-01, 1.6102091240E-01, 4.9941312568E-01],
	[8.9500000000E+03, 4.3108610957E+00, 6.1052836113E+00, 1.7228158875E-01, 1.6128471566E-01, 4.9959094006E-01],
	[8.9550000000E+03, 4.3139084066E+00, 6.1044401914E+00, 1.7257872038E-01, 1.6154878276E-01, 4.9976872358E-01],
	[8.9600000000E+03, 4.3169561689E+00, 6.1035973587E+00, 1.7287619724E-01, 1.6181311377E-01, 4.9994647626E-01],
	[8.9650000000E+03, 4.3200043823E+00, 6.1027551125E+00, 1.7317401951E-01, 1.6207770873E-01, 5.0012419813E-01],
	[8.9700000000E+03, 4.3230530467E+00, 6.1019134521E+00, 1.7347218741E-01, 1.6234256769E-01, 5.0030188924E-01],
	[8.9750000000E+03, 4.3261021618E+00, 6.1010723766E+00, 1.7377070114E-01, 1.6260769071E-01, 5.0047954961E-01],
	[8.9800000000E+03, 4.3291517276E+00, 6.1002318855E+00, 1.7406956092E-01, 1.6287307784E-01, 5.0065717928E-01],
	[8.9850000000E+03, 4.3322017437E+00, 6.0993919778E+00, 1.7436876694E-01, 1.6313872913E-01, 5.0083477828E-01],
	[8.9900000000E+03, 4.3352522101E+00, 6.0985526530E+00, 1.7466831942E-01, 1.6340464464E-01, 5.0101234664E-01],
	[8.9950000000E+03, 4.3383031265E+00, 6.0977139102E+00, 1.7496821856E-01, 1.6367082440E-01, 5.0118988440E-01],
	[9.0000000000E+03, 4.3413544928E+00, 6.0968757488E+00, 1.7526846456E-01, 1.6393726848E-01, 5.0136739159E-01],
	[9.0050000000E+03, 4.3444063088E+00, 6.0960381681E+00, 1.7557049247E-01, 1.6420523201E-01, 5.0154486824E-01],
	[9.0100000000E+03, 4.3474585742E+00, 6.0952011672E+00, 1.7587287179E-01, 1.6447346312E-01, 5.0172231438E-01],
	[9.0150000000E+03, 4.3505112890E+00, 6.0943647455E+00, 1.7617560273E-01, 1.6474196187E-01, 5.0189973006E-01],
	[9.0200000000E+03, 4.3535644528E+00, 6.0935289023E+00, 1.7647868549E-01, 1.6501072830E-01, 5.0207711529E-01],
	[9.0250000000E+03, 4.3566180656E+00, 6.0926936368E+00, 1.7678212030E-01, 1.6527976247E-01, 5.0225447013E-01],
	[9.0300000000E+03, 4.3596738141E+00, 6.0918632625E+00, 1.7708590736E-01, 1.6554907005E-01, 5.0243179459E-01],
	[9.0350000000E+03, 4.3627326009E+00, 6.0910400749E+00, 1.7739004689E-01, 1.6581865415E-01, 5.0260908871E-01],
	[9.0400000000E+03, 4.3657918398E+00, 6.0902174539E+00, 1.7769453910E-01, 1.6608850622E-01, 5.0278635253E-01],
	[9.0450000000E+03, 4.3688515305E+00, 6.0893953987E+00, 1.7799938419E-01, 1.6635862631E-01, 5.0296358608E-01],
	[9.0500000000E+03, 4.3719116728E+00, 6.0885739088E+00, 1.7830458238E-01, 1.6662901448E-01, 5.0314078940E-01],
	[9.0550000000E+03, 4.3749722666E+00, 6.0877529832E+00, 1.7861013389E-01, 1.6689967078E-01, 5.0331796251E-01],
	[9.0600000000E+03, 4.3780333117E+00, 6.0869326215E+00, 1.7891603892E-01, 1.6717059525E-01, 5.0349510545E-01],
	[9.0650000000E+03, 4.3810948079E+00, 6.0861128228E+00, 1.7922229769E-01, 1.6744178796E-01, 5.0367221826E-01],
	[9.0700000000E+03, 4.3841567550E+00, 6.0852935865E+00, 1.7952891040E-01, 1.6771324895E-01, 5.0384930096E-01],
	[9.0750000000E+03, 4.3872191529E+00, 6.0844749119E+00, 1.7983587727E-01, 1.6798497826E-01, 5.0402635359E-01],
	[9.0800000000E+03, 4.3902820013E+00, 6.0836567983E+00, 1.8014319851E-01, 1.6825697596E-01, 5.0420337619E-01],
	[9.0850000000E+03, 4.3933453001E+00, 6.0828392449E+00, 1.8045087434E-01, 1.6852924209E-01, 5.0438036879E-01],
	[9.0900000000E+03, 4.3964090490E+00, 6.0820222512E+00, 1.8075890496E-01, 1.6880177670E-01, 5.0455733142E-01],
	[9.0950000000E+03, 4.3994732480E+00, 6.0812058163E+00, 1.8106729059E-01, 1.6907457985E-01, 5.0473426412E-01],
	[9.1000000000E+03, 4.4025378968E+00, 6.0803899397E+00, 1.8137603143E-01, 1.6934765157E-01, 5.0491116692E-01],
	[9.1050000000E+03, 4.4056029953E+00, 6.0795746206E+00, 1.8168512771E-01, 1.6962099192E-01, 5.0508803985E-01],
	[9.1100000000E+03, 4.4086685432E+00, 6.0787598584E+00, 1.8199457963E-01, 1.6989460096E-01, 5.0526488295E-01],
	[9.1150000000E+03, 4.4117345404E+00, 6.0779456523E+00, 1.8230438740E-01, 1.7016847872E-01, 5.0544169626E-01],
	[9.1200000000E+03, 4.4148009867E+00, 6.0771320017E+00, 1.8261455123E-01, 1.7044262526E-01, 5.0561847980E-01],
	[9.1250000000E+03, 4.4178678820E+00, 6.0763189059E+00, 1.8292507135E-01, 1.7071704062E-01, 5.0579523361E-01],
	[9.1300000000E+03, 4.4209352260E+00, 6.0755063642E+00, 1.8323594795E-01, 1.7099172486E-01, 5.0597195773E-01],
	[9.1350000000E+03, 4.4240030185E+00, 6.0746943759E+00, 1.8354718125E-01, 1.7126667802E-01, 5.0614865218E-01],
	[9.1400000000E+03, 4.4270712595E+00, 6.0738829404E+00, 1.8385877147E-01, 1.7154190015E-01, 5.0632531701E-01],
	[9.1450000000E+03, 4.4301399486E+00, 6.0730720569E+00, 1.8417071881E-01, 1.7181739129E-01, 5.0650195224E-01],
	[9.1500000000E+03, 4.4332090858E+00, 6.0722617249E+00, 1.8448302349E-01, 1.7209315151E-01, 5.0667855792E-01],
	[9.1550000000E+03, 4.4362786708E+00, 6.0714519435E+00, 1.8479568572E-01, 1.7236918083E-01, 5.0685513407E-01],
	[9.1600000000E+03, 4.4393487035E+00, 6.0706427122E+00, 1.8510870570E-01, 1.7264547932E-01, 5.0703168073E-01],
	[9.1650000000E+03, 4.4424191836E+00, 6.0698340303E+00, 1.8542208366E-01, 1.7292204701E-01, 5.0720819794E-01],
	[9.1700000000E+03, 4.4454901111E+00, 6.0690258971E+00, 1.8573581981E-01, 1.7319888396E-01, 5.0738468572E-01],
	[9.1750000000E+03, 4.4485629073E+00, 6.0682217592E+00, 1.8604991435E-01, 1.7347599518E-01, 5.0756114412E-01],
	[9.1800000000E+03, 4.4516390802E+00, 6.0674252615E+00, 1.8636436749E-01, 1.7375338606E-01, 5.0773757316E-01],
	[9.1850000000E+03, 4.4547157035E+00, 6.0666293021E+00, 1.8667917946E-01, 1.7403104642E-01, 5.0791397288E-01],
	[9.1900000000E+03, 4.4577927770E+00, 6.0658338801E+00, 1.8699435046E-01, 1.7430897629E-01, 5.0809034333E-01],
	[9.1950000000E+03, 4.4608703005E+00, 6.0650389950E+00, 1.8730988071E-01, 1.7458717574E-01, 5.0826668452E-01],
	[9.2000000000E+03, 4.4639482740E+00, 6.0642446461E+00, 1.8762577040E-01, 1.7486564480E-01, 5.0844299650E-01],
	[9.2050000000E+03, 4.4670266971E+00, 6.0634508328E+00, 1.8794201977E-01, 1.7514438351E-01, 5.0861927929E-01],
	[9.2100000000E+03, 4.4701055698E+00, 6.0626575543E+00, 1.8825862902E-01, 1.7542339194E-01, 5.0879553294E-01],
	[9.2150000000E+03, 4.4731848918E+00, 6.0618648101E+00, 1.8857559836E-01, 1.7570267011E-01, 5.0897175748E-01],
	[9.2200000000E+03, 4.4762646629E+00, 6.0610725995E+00, 1.8889292800E-01, 1.7598221808E-01, 5.0914795295E-01],
	[9.2250000000E+03, 4.4793448830E+00, 6.0602809218E+00, 1.8921061816E-01, 1.7626203588E-01, 5.0932411937E-01],
	[9.2300000000E+03, 4.4824255520E+00, 6.0594897765E+00, 1.8952866905E-01, 1.7654212357E-01, 5.0950025679E-01],
	[9.2350000000E+03, 4.4855066695E+00, 6.0586991628E+00, 1.8984708087E-01, 1.7682248119E-01, 5.0967636523E-01],
	[9.2400000000E+03, 4.4885882355E+00, 6.0579090800E+00, 1.9016585385E-01, 1.7710310879E-01, 5.0985244474E-01],
	[9.2450000000E+03, 4.4916702498E+00, 6.0571195277E+00, 1.9048498819E-01, 1.7738400640E-01, 5.1002849534E-01],
	[9.2500000000E+03, 4.4947527122E+00, 6.0563305051E+00, 1.9080448411E-01, 1.7766517407E-01, 5.1020451708E-01],
	[9.2550000000E+03, 4.4978356225E+00, 6.0555420115E+00, 1.9112434181E-01, 1.7794661185E-01, 5.1038050998E-01],
	[9.2600000000E+03, 4.5009189805E+00, 6.0547540465E+00, 1.9144456152E-01, 1.7822831978E-01, 5.1055647408E-01],
	[9.2650000000E+03, 4.5040027861E+00, 6.0539666092E+00, 1.9176514344E-01, 1.7851029789E-01, 5.1073240943E-01],
	[9.2700000000E+03, 4.5070870391E+00, 6.0531796990E+00, 1.9208608778E-01, 1.7879254625E-01, 5.1090831604E-01],
	[9.2750000000E+03, 4.5101717392E+00, 6.0523933154E+00, 1.9240739476E-01, 1.7907506487E-01, 5.1108419396E-01],
	[9.2800000000E+03, 4.5132568865E+00, 6.0516074577E+00, 1.9272906458E-01, 1.7935785383E-01, 5.1126004322E-01],
	[9.2850000000E+03, 4.5163424805E+00, 6.0508221252E+00, 1.9305109747E-01, 1.7964091314E-01, 5.1143586386E-01],
	[9.2900000000E+03, 4.5194285213E+00, 6.0500373174E+00, 1.9337349362E-01, 1.7992424286E-01, 5.1161165589E-01],
	[9.2950000000E+03, 4.5225150086E+00, 6.0492530336E+00, 1.9369625327E-01, 1.8020784302E-01, 5.1178741932E-01],
	[9.3000000000E+03, 4.5256019421E+00, 6.0484692731E+00, 1.9401937661E-01, 1.8049171368E-01, 5.1196315417E-01],
	[9.3050000000E+03, 4.5286893219E+00, 6.0476860353E+00, 1.9434286385E-01, 1.8077585486E-01, 5.1213886045E-01],
	[9.3100000000E+03, 4.5317771476E+00, 6.0469033197E+00, 1.9466671522E-01, 1.8106026662E-01, 5.1231453820E-01],
	[9.3150000000E+03, 4.5348654191E+00, 6.0461211255E+00, 1.9499093092E-01, 1.8134494899E-01, 5.1249018741E-01],
	[9.3200000000E+03, 4.5379541363E+00, 6.0453394521E+00, 1.9531551117E-01, 1.8162990201E-01, 5.1266580812E-01],
	[9.3250000000E+03, 4.5410468080E+00, 6.0445663480E+00, 1.9564045617E-01, 1.8191513865E-01, 5.1284140033E-01],
	[9.3300000000E+03, 4.5441408547E+00, 6.0437958810E+00, 1.9596576614E-01, 1.8220064952E-01, 5.1301696408E-01],
	[9.3350000000E+03, 4.5472353501E+00, 6.0430259250E+00, 1.9629144130E-01, 1.8248643125E-01, 5.1319249936E-01],
	[9.3400000000E+03, 4.5503302941E+00, 6.0422564793E+00, 1.9661748184E-01, 1.8277248389E-01, 5.1336800621E-01],
	[9.3450000000E+03, 4.5534256865E+00, 6.0414875433E+00, 1.9694388800E-01, 1.8305880746E-01, 5.1354348464E-01],
	[9.3500000000E+03, 4.5565215271E+00, 6.0407191163E+00, 1.9727065997E-01, 1.8334540203E-01, 5.1371893467E-01],
	[9.3550000000E+03, 4.5596178158E+00, 6.0399511979E+00, 1.9759779797E-01, 1.8363226761E-01, 5.1389435632E-01],
	[9.3600000000E+03, 4.5627145524E+00, 6.0391837873E+00, 1.9792530221E-01, 1.8391940426E-01, 5.1406974961E-01],
	[9.3650000000E+03, 4.5658117367E+00, 6.0384168839E+00, 1.9825317291E-01, 1.8420681202E-01, 5.1424511454E-01],
	[9.3700000000E+03, 4.5689093686E+00, 6.0376504872E+00, 1.9858141027E-01, 1.8449449092E-01, 5.1442045115E-01],
	[9.3750000000E+03, 4.5720074478E+00, 6.0368845966E+00, 1.9891001452E-01, 1.8478244100E-01, 5.1459575945E-01],
	[9.3800000000E+03, 4.5751059742E+00, 6.0361192114E+00, 1.9923898585E-01, 1.8507066230E-01, 5.1477103946E-01],
	[9.3850000000E+03, 4.5782049476E+00, 6.0353543310E+00, 1.9956832449E-01, 1.8535915486E-01, 5.1494629119E-01],
	[9.3900000000E+03, 4.5813043679E+00, 6.0345899549E+00, 1.9989803064E-01, 1.8564791871E-01, 5.1512151467E-01],
	[9.3950000000E+03, 4.5844042349E+00, 6.0338260824E+00, 2.0022810452E-01, 1.8593695391E-01, 5.1529670992E-01],
	[9.4000000000E+03, 4.5875045483E+00, 6.0330627129E+00, 2.0055854634E-01, 1.8622626048E-01, 5.1547187694E-01],
	[9.4050000000E+03, 4.5906053081E+00, 6.0322998459E+00, 2.0088935631E-01, 1.8651583846E-01, 5.1564701577E-01],
	[9.4100000000E+03, 4.5937065140E+00, 6.0315374808E+00, 2.0122053465E-01, 1.8680568789E-01, 5.1582212642E-01],
	[9.4150000000E+03, 4.5968081659E+00, 6.0307756168E+00, 2.0155208157E-01, 1.8709580881E-01, 5.1599720891E-01],
	[9.4200000000E+03, 4.5999102636E+00, 6.0300142536E+00, 2.0188399727E-01, 1.8738620126E-01, 5.1617226325E-01],
	[9.4250000000E+03, 4.6030128069E+00, 6.0292533904E+00, 2.0221628197E-01, 1.8767686527E-01, 5.1634728947E-01],
	[9.4300000000E+03, 4.6061157957E+00, 6.0284930266E+00, 2.0254893589E-01, 1.8796780088E-01, 5.1652228758E-01],
	[9.4350000000E+03, 4.6092192298E+00, 6.0277331617E+00, 2.0288195924E-01, 1.8825900812E-01, 5.1669725761E-01],
	[9.4400000000E+03, 4.6123231090E+00, 6.0269737951E+00, 2.0321535222E-01, 1.8855048704E-01, 5.1687219957E-01],
	[9.4450000000E+03, 4.6154274332E+00, 6.0262149262E+00, 2.0354911505E-01, 1.8884223766E-01, 5.1704711348E-01],
	[9.4500000000E+03, 4.6185322021E+00, 6.0254565544E+00, 2.0388324795E-01, 1.8913426003E-01, 5.1722199936E-01],
	[9.4550000000E+03, 4.6216374156E+00, 6.0246986791E+00, 2.0421775112E-01, 1.8942655418E-01, 5.1739685723E-01],
	[9.4600000000E+03, 4.6247430736E+00, 6.0239412997E+00, 2.0455262478E-01, 1.8971912015E-01, 5.1757168711E-01],
	[9.4650000000E+03, 4.6278491758E+00, 6.0231844157E+00, 2.0488786913E-01, 1.9001195797E-01, 5.1774648902E-01],
	[9.4700000000E+03, 4.6309557221E+00, 6.0224280264E+00, 2.0522348440E-01, 1.9030506768E-01, 5.1792126297E-01],
	[9.4750000000E+03, 4.6340662391E+00, 6.0216797860E+00, 2.0555947080E-01, 1.9059846294E-01, 5.1809600899E-01],
	[9.4800000000E+03, 4.6371781983E+00, 6.0209341924E+00, 2.0589582853E-01, 1.9089213409E-01, 5.1827072710E-01],
	[9.4850000000E+03, 4.6402906047E+00, 6.0201890842E+00, 2.0623255781E-01, 1.9118607733E-01, 5.1844541730E-01],
	[9.4900000000E+03, 4.6434034582E+00, 6.0194444608E+00, 2.0656977174E-01, 1.9148038968E-01, 5.1862007963E-01],
	[9.4950000000E+03, 4.6465167587E+00, 6.0187003216E+00, 2.0690742326E-01, 1.9177503051E-01, 5.1879471411E-01],
	[9.5000000000E+03, 4.6496305059E+00, 6.0179566662E+00, 2.0724544750E-01, 1.9206994393E-01, 5.1896932075E-01],
	[9.5050000000E+03, 4.6527446996E+00, 6.0172134938E+00, 2.0758384469E-01, 1.9236512999E-01, 5.1914389956E-01],
	[9.5100000000E+03, 4.6558593398E+00, 6.0164708040E+00, 2.0792261504E-01, 1.9266058871E-01, 5.1931845058E-01],
	[9.5150000000E+03, 4.6589744262E+00, 6.0157285961E+00, 2.0826175875E-01, 1.9295632012E-01, 5.1949297382E-01],
	[9.5200000000E+03, 4.6620899586E+00, 6.0149868697E+00, 2.0860127604E-01, 1.9325232427E-01, 5.1966746930E-01],
	[9.5250000000E+03, 4.6652059369E+00, 6.0142456241E+00, 2.0894116713E-01, 1.9354860118E-01, 5.1984193704E-01],
	[9.5300000000E+03, 4.6683223610E+00, 6.0135048587E+00, 2.0928143223E-01, 1.9384515089E-01, 5.2001637706E-01],
	[9.5350000000E+03, 4.6714392306E+00, 6.0127645731E+00, 2.0962207155E-01, 1.9414197344E-01, 5.2019078937E-01],
	[9.5400000000E+03, 4.6745565455E+00, 6.0120247666E+00, 2.0996308530E-01, 1.9443906884E-01, 5.2036517401E-01],
	[9.5450000000E+03, 4.6776743057E+00, 6.0112854388E+00, 2.1030447370E-01, 1.9473643715E-01, 5.2053953098E-01],
	[9.5500000000E+03, 4.6807925109E+00, 6.0105465889E+00, 2.1064623697E-01, 1.9503407839E-01, 5.2071386032E-01],
	[9.5550000000E+03, 4.6839111610E+00, 6.0098082166E+00, 2.1098837531E-01, 1.9533199259E-01, 5.2088816202E-01],
	[9.5600000000E+03, 4.6870302558E+00, 6.0090703211E+00, 2.1133088893E-01, 1.9563017978E-01, 5.2106243613E-01],
	[9.5650000000E+03, 4.6901497951E+00, 6.0083329020E+00, 2.1167377806E-01, 1.9592864000E-01, 5.2123668266E-01],
	[9.5700000000E+03, 4.6932697787E+00, 6.0075959587E+00, 2.1201704290E-01, 1.9622737329E-01, 5.2141090162E-01],
	[9.5750000000E+03, 4.6963902066E+00, 6.0068594907E+00, 2.1236068367E-01, 1.9652637966E-01, 5.2158509304E-01],
	[9.5800000000E+03, 4.6995110785E+00, 6.0061234973E+00, 2.1270470058E-01, 1.9682565916E-01, 5.2175925693E-01],
	[9.5850000000E+03, 4.7026323942E+00, 6.0053879781E+00, 2.1304909384E-01, 1.9712521180E-01, 5.2193339333E-01],
	[9.5900000000E+03, 4.7057541536E+00, 6.0046529324E+00, 2.1339386367E-01, 1.9742503764E-01, 5.2210750224E-01],
	[9.5950000000E+03, 4.7088763566E+00, 6.0039183598E+00, 2.1373901029E-01, 1.9772513669E-01, 5.2228158369E-01],
	[9.6000000000E+03, 4.7119990029E+00, 6.0031842597E+00, 2.1408453389E-01, 1.9802550899E-01, 5.2245563770E-01],
	[9.6050000000E+03, 4.7151220923E+00, 6.0024506315E+00, 2.1443043471E-01, 1.9832615456E-01, 5.2262966428E-01],
	[9.6100000000E+03, 4.7182456248E+00, 6.0017174747E+00, 2.1477671294E-01, 1.9862707344E-01, 5.2280366347E-01],
	[9.6150000000E+03, 4.7213696001E+00, 6.0009847887E+00, 2.1512336881E-01, 1.9892826566E-01, 5.2297763527E-01],
	[9.6200000000E+03, 4.7244940181E+00, 6.0002525730E+00, 2.1547040253E-01, 1.9922973125E-01, 5.2315157971E-01],
	[9.6250000000E+03, 4.7276201946E+00, 5.9995235308E+00, 2.1581781430E-01, 1.9953147556E-01, 5.2332549681E-01],
	[9.6300000000E+03, 4.7307501082E+00, 5.9988017174E+00, 2.1616560436E-01, 1.9983350672E-01, 5.2349938659E-01],
	[9.6350000000E+03, 4.7338804677E+00, 5.9980803655E+00, 2.1651377290E-01, 2.0013581142E-01, 5.2367324908E-01],
	[9.6400000000E+03, 4.7370112728E+00, 5.9973594744E+00, 2.1686232014E-01, 2.0043838970E-01, 5.2384708441E-01],
	[9.6450000000E+03, 4.7401425236E+00, 5.9966390438E+00, 2.1721124629E-01, 2.0074124159E-01, 5.2402089265E-01],
	[9.6500000000E+03, 4.7432742197E+00, 5.9959190730E+00, 2.1756055158E-01, 2.0104436712E-01, 5.2419467378E-01],
	[9.6550000000E+03, 4.7464063610E+00, 5.9951995616E+00, 2.1791023620E-01, 2.0134776632E-01, 5.2436842780E-01],
	[9.6600000000E+03, 4.7495389473E+00, 5.9944805089E+00, 2.1826030038E-01, 2.0165143921E-01, 5.2454215472E-01],
	[9.6650000000E+03, 4.7526719785E+00, 5.9937619145E+00, 2.1861074433E-01, 2.0195538583E-01, 5.2471585454E-01],
	[9.6700000000E+03, 4.7558054544E+00, 5.9930437778E+00, 2.1896156825E-01, 2.0225960619E-01, 5.2488952726E-01],
	[9.6750000000E+03, 4.7589393749E+00, 5.9923260983E+00, 2.1931277238E-01, 2.0256410034E-01, 5.2506317287E-01],
	[9.6800000000E+03, 4.7620737397E+00, 5.9916088755E+00, 2.1966435691E-01, 2.0286886830E-01, 5.2523679138E-01],
	[9.6850000000E+03, 4.7652085488E+00, 5.9908921089E+00, 2.2001632206E-01, 2.0317391008E-01, 5.2541038279E-01],
	[9.6900000000E+03, 4.7683438018E+00, 5.9901757979E+00, 2.2036866805E-01, 2.0347922574E-01, 5.2558394710E-01],
	[9.6950000000E+03, 4.7714794988E+00, 5.9894599419E+00, 2.2072139509E-01, 2.0378481528E-01, 5.2575748430E-01],
	[9.7000000000E+03, 4.7746156395E+00, 5.9887445406E+00, 2.2107450339E-01, 2.0409067873E-01, 5.2593099441E-01],
	[9.7050000000E+03, 4.7777522236E+00, 5.9880295933E+00, 2.2142799316E-01, 2.0439681613E-01, 5.2610447742E-01],
	[9.7100000000E+03, 4.7808892512E+00, 5.9873150995E+00, 2.2178186463E-01, 2.0470322750E-01, 5.2627793333E-01],
	[9.7150000000E+03, 4.7840267220E+00, 5.9866010587E+00, 2.2213611800E-01, 2.0500991287E-01, 5.2645136215E-01],
	[9.7200000000E+03, 4.7871646358E+00, 5.9858874705E+00, 2.2249075348E-01, 2.0531687225E-01, 5.2662476387E-01],
	[9.7250000000E+03, 4.7903029925E+00, 5.9851743342E+00, 2.2284577129E-01, 2.0562410568E-01, 5.2679813849E-01],
	[9.7300000000E+03, 4.7934417919E+00, 5.9844616493E+00, 2.2320117165E-01, 2.0593161319E-01, 5.2697148603E-01],
	[9.7350000000E+03, 4.7965810339E+00, 5.9837494154E+00, 2.2355695476E-01, 2.0623939479E-01, 5.2714480647E-01],
	[9.7400000000E+03, 4.7997207183E+00, 5.9830376319E+00, 2.2391312085E-01, 2.0654745052E-01, 5.2731809981E-01],
	[9.7450000000E+03, 4.8028608448E+00, 5.9823262983E+00, 2.2426967011E-01, 2.0685578040E-01, 5.2749136607E-01],
	[9.7500000000E+03, 4.8060014134E+00, 5.9816154141E+00, 2.2462660278E-01, 2.0716438445E-01, 5.2766460524E-01],
	[9.7550000000E+03, 4.8091424239E+00, 5.9809049787E+00, 2.2498391905E-01, 2.0747326269E-01, 5.2783781732E-01],
	[9.7600000000E+03, 4.8122838762E+00, 5.9801949918E+00, 2.2534161915E-01, 2.0778241516E-01, 5.2801100232E-01],
	[9.7650000000E+03, 4.8154257700E+00, 5.9794854526E+00, 2.2569970329E-01, 2.0809184188E-01, 5.2818416023E-01],
	[9.7700000000E+03, 4.8185681051E+00, 5.9787763608E+00, 2.2605817168E-01, 2.0840154287E-01, 5.2835729106E-01],
	[9.7750000000E+03, 4.8217108816E+00, 5.9780677159E+00, 2.2641702453E-01, 2.0871151815E-01, 5.2853039481E-01],
	[9.7800000000E+03, 4.8248555093E+00, 5.9773622586E+00, 2.2677626206E-01, 2.0902177375E-01, 5.2870347147E-01],
	[9.7850000000E+03, 4.8280038666E+00, 5.9766636310E+00, 2.2713588449E-01, 2.0933231773E-01, 5.2887652106E-01],
	[9.7900000000E+03, 4.8311526684E+00, 5.9759654418E+00, 2.2749589202E-01, 2.0964313618E-01, 5.2904954357E-01],
	[9.7950000000E+03, 4.8343019145E+00, 5.9752676907E+00, 2.2785628487E-01, 2.0995422911E-01, 5.2922253901E-01],
	[9.8000000000E+03, 4.8374516047E+00, 5.9745703770E+00, 2.2821706325E-01, 2.1026559656E-01, 5.2939550738E-01],
	[9.8050000000E+03, 4.8406017389E+00, 5.9738735003E+00, 2.2857822738E-01, 2.1057723854E-01, 5.2956844867E-01],
	[9.8100000000E+03, 4.8437523169E+00, 5.9731770602E+00, 2.2893977748E-01, 2.1088915508E-01, 5.2974136289E-01],
	[9.8150000000E+03, 4.8469033386E+00, 5.9724810560E+00, 2.2930171374E-01, 2.1120134619E-01, 5.2991425005E-01],
	[9.8200000000E+03, 4.8500548037E+00, 5.9717854873E+00, 2.2966403639E-01, 2.1151381191E-01, 5.3008711014E-01],
	[9.8250000000E+03, 4.8532067121E+00, 5.9710903537E+00, 2.3002674565E-01, 2.1182655224E-01, 5.3025994317E-01],
	[9.8300000000E+03, 4.8563590637E+00, 5.9703956546E+00, 2.3038984171E-01, 2.1213956723E-01, 5.3043274914E-01],
	[9.8350000000E+03, 4.8595118583E+00, 5.9697013895E+00, 2.3075332481E-01, 2.1245285688E-01, 5.3060552805E-01],
	[9.8400000000E+03, 4.8626650957E+00, 5.9690075579E+00, 2.3111719515E-01, 2.1276642121E-01, 5.3077827990E-01],
	[9.8450000000E+03, 4.8658187758E+00, 5.9683141594E+00, 2.3148145295E-01, 2.1308026026E-01, 5.3095100470E-01],
	[9.8500000000E+03, 4.8689728983E+00, 5.9676211935E+00, 2.3184609841E-01, 2.1339437404E-01, 5.3112370244E-01],
	[9.8550000000E+03, 4.8721274632E+00, 5.9669286596E+00, 2.3221113176E-01, 2.1370876256E-01, 5.3129637314E-01],
	[9.8600000000E+03, 4.8752824703E+00, 5.9662365573E+00, 2.3257655320E-01, 2.1402342586E-01, 5.3146901679E-01],
	[9.8650000000E+03, 4.8784379194E+00, 5.9655448861E+00, 2.3294236296E-01, 2.1433836395E-01, 5.3164163339E-01],
	[9.8700000000E+03, 4.8815938104E+00, 5.9648536454E+00, 2.3330856124E-01, 2.1465357685E-01, 5.3181422295E-01],
	[9.8750000000E+03, 4.8847501430E+00, 5.9641628350E+00, 2.3367514826E-01, 2.1496906458E-01, 5.3198678548E-01],
	[9.8800000000E+03, 4.8879069172E+00, 5.9634724541E+00, 2.3404212423E-01, 2.1528482716E-01, 5.3215932096E-01],
	[9.8850000000E+03, 4.8910641327E+00, 5.9627825024E+00, 2.3440948937E-01, 2.1560086462E-01, 5.3233182941E-01],
	[9.8900000000E+03, 4.8942217895E+00, 5.9620929793E+00, 2.3477724388E-01, 2.1591717696E-01, 5.3250431083E-01],
	[9.8950000000E+03, 4.8973798873E+00, 5.9614038845E+00, 2.3514538799E-01, 2.1623376422E-01, 5.3267676522E-01],
	[9.9000000000E+03, 4.9005384259E+00, 5.9607152173E+00, 2.3551392191E-01, 2.1655062640E-01, 5.3284919258E-01],
	[9.9050000000E+03, 4.9036974053E+00, 5.9600269774E+00, 2.3588284584E-01, 2.1686776353E-01, 5.3302159292E-01],
	[9.9100000000E+03, 4.9068568253E+00, 5.9593391642E+00, 2.3625216001E-01, 2.1718517562E-01, 5.3319396623E-01],
	[9.9150000000E+03, 4.9100166856E+00, 5.9586517772E+00, 2.3662186463E-01, 2.1750286270E-01, 5.3336631253E-01],
	[9.9200000000E+03, 4.9131769862E+00, 5.9579648161E+00, 2.3699195991E-01, 2.1782082478E-01, 5.3353863182E-01],
	[9.9250000000E+03, 4.9163377269E+00, 5.9572782802E+00, 2.3736244607E-01, 2.1813906188E-01, 5.3371092409E-01],
	[9.9300000000E+03, 4.9194989075E+00, 5.9565921692E+00, 2.3773332331E-01, 2.1845757402E-01, 5.3388318936E-01],
	[9.9350000000E+03, 4.9226605278E+00, 5.9559064825E+00, 2.3810459186E-01, 2.1877636122E-01, 5.3405542762E-01],
	[9.9400000000E+03, 4.9258265010E+00, 5.9552284056E+00, 2.3847625193E-01, 2.1909544095E-01, 5.3422763888E-01],
	[9.9450000000E+03, 4.9289937985E+00, 5.9545523647E+00, 2.3884830373E-01, 2.1941479980E-01, 5.3439982314E-01],
	[9.9500000000E+03, 4.9321615389E+00, 5.9538767403E+00, 2.3922074747E-01, 2.1973443386E-01, 5.3457198040E-01],
	[9.9550000000E+03, 4.9353297223E+00, 5.9532015320E+00, 2.3959358337E-01, 2.2005434316E-01, 5.3474411067E-01],
	[9.9600000000E+03, 4.9384983483E+00, 5.9525267392E+00, 2.3996681164E-01, 2.2037452769E-01, 5.3491621395E-01],
	[9.9650000000E+03, 4.9416674169E+00, 5.9518523615E+00, 2.4034043250E-01, 2.2069498749E-01, 5.3508829025E-01],
	[9.9700000000E+03, 4.9448369279E+00, 5.9511783984E+00, 2.4071444616E-01, 2.2101572256E-01, 5.3526033956E-01],
	[9.9750000000E+03, 4.9480068811E+00, 5.9505048495E+00, 2.4108885283E-01, 2.2133673293E-01, 5.3543236190E-01],
	[9.9800000000E+03, 4.9511772763E+00, 5.9498317143E+00, 2.4146365274E-01, 2.2165801861E-01, 5.3560435726E-01],
	[9.9850000000E+03, 4.9543481135E+00, 5.9491589924E+00, 2.4183884608E-01, 2.2197957961E-01, 5.3577632565E-01],
	[9.9900000000E+03, 4.9575193924E+00, 5.9484866832E+00, 2.4221443308E-01, 2.2230141595E-01, 5.3594826707E-01],
	[9.9950000000E+03, 4.9606911129E+00, 5.9478147864E+00, 2.4259041395E-01, 2.2262352765E-01, 5.3612018152E-01],
	[1.0000000000E+04, 4.9638632748E+00, 5.9471433014E+00, 2.4296678890E-01, 2.2294591472E-01, 5.3629206902E-01],
	[1.0005000000E+04, 4.9670358779E+00, 5.9464722279E+00, 2.4334549196E-01, 2.2327020509E-01, 5.3646392956E-01],
	[1.0010000000E+04, 4.9702089222E+00, 5.9458015652E+00, 2.4372459454E-01, 2.2359477440E-01, 5.3663576315E-01],
	[1.0015000000E+04, 4.9733824074E+00, 5.9451313131E+00, 2.4410409687E-01, 2.2391962266E-01, 5.3680756978E-01],
	[1.0020000000E+04, 4.9765563334E+00, 5.9444614711E+00, 2.4448399916E-01, 2.2424474991E-01, 5.3697934947E-01],
	[1.0025000000E+04, 4.9797307001E+00, 5.9437920386E+00, 2.4486430163E-01, 2.2457015614E-01, 5.3715110223E-01],
	[1.0030000000E+04, 4.9829055072E+00, 5.9431230152E+00, 2.4524500451E-01, 2.2489584138E-01, 5.3732282804E-01],
	[1.0035000000E+04, 4.9860807546E+00, 5.9424544006E+00, 2.4562610801E-01, 2.2522180564E-01, 5.3749452692E-01],
	[1.0040000000E+04, 4.9892564422E+00, 5.9417861941E+00, 2.4600761234E-01, 2.2554804895E-01, 5.3766619887E-01],
	[1.0045000000E+04, 4.9924325697E+00, 5.9411183954E+00, 2.4638951774E-01, 2.2587457130E-01, 5.3783784390E-01],
	[1.0050000000E+04, 4.9956091371E+00, 5.9404510041E+00, 2.4677182443E-01, 2.2620137272E-01, 5.3800946201E-01],
	[1.0055000000E+04, 4.9987861442E+00, 5.9397840196E+00, 2.4715453261E-01, 2.2652845322E-01, 5.3818105320E-01],
	[1.0060000000E+04, 5.0019635908E+00, 5.9391174415E+00, 2.4753764251E-01, 2.2685581282E-01, 5.3835261748E-01],
	[1.0065000000E+04, 5.0051414767E+00, 5.9384512694E+00, 2.4792115435E-01, 2.2718345153E-01, 5.3852415485E-01],
	[1.0070000000E+04, 5.0083198019E+00, 5.9377855028E+00, 2.4830506836E-01, 2.2751136936E-01, 5.3869566531E-01],
	[1.0075000000E+04, 5.0114985661E+00, 5.9371201413E+00, 2.4868938474E-01, 2.2783956633E-01, 5.3886714888E-01],
	[1.0080000000E+04, 5.0146777692E+00, 5.9364551844E+00, 2.4907410373E-01, 2.2816804245E-01, 5.3903860556E-01],
	[1.0085000000E+04, 5.0178574111E+00, 5.9357906317E+00, 2.4945922553E-01, 2.2849679773E-01, 5.3921003534E-01],
	[1.0090000000E+04, 5.0210374915E+00, 5.9351264827E+00, 2.4984475038E-01, 2.2882583219E-01, 5.3938143824E-01],
	[1.0095000000E+04, 5.0242180103E+00, 5.9344627370E+00, 2.5023067848E-01, 2.2915514584E-01, 5.3955281426E-01],
	[1.0100000000E+04, 5.0274031084E+00, 5.9338064581E+00, 2.5061701007E-01, 2.2948475789E-01, 5.3972416340E-01],
	[1.0105000000E+04, 5.0305895253E+00, 5.9331520721E+00, 2.5100374535E-01, 2.2981465331E-01, 5.3989548567E-01],
	[1.0110000000E+04, 5.0337763839E+00, 5.9324980820E+00, 2.5139088456E-01, 2.3014482808E-01, 5.4006678107E-01],
	[1.0115000000E+04, 5.0369636842E+00, 5.9318444873E+00, 2.5177842790E-01, 2.3047528220E-01, 5.4023804961E-01],
	[1.0120000000E+04, 5.0401514260E+00, 5.9311912875E+00, 2.5216637561E-01, 2.3080601568E-01, 5.4040929129E-01],
	[1.0125000000E+04, 5.0433396092E+00, 5.9305384822E+00, 2.5255472789E-01, 2.3113702853E-01, 5.4058050612E-01],
	[1.0130000000E+04, 5.0465282336E+00, 5.9298860710E+00, 2.5294348497E-01, 2.3146832077E-01, 5.4075169411E-01],
	[1.0135000000E+04, 5.0497172989E+00, 5.9292340535E+00, 2.5333264707E-01, 2.3179989241E-01, 5.4092285525E-01],
	[1.0140000000E+04, 5.0529068052E+00, 5.9285824292E+00, 2.5372221442E-01, 2.3213174346E-01, 5.4109398955E-01],
	[1.0145000000E+04, 5.0560967522E+00, 5.9279311977E+00, 2.5411218722E-01, 2.3246387393E-01, 5.4126509702E-01],
	[1.0150000000E+04, 5.0592871398E+00, 5.9272803586E+00, 2.5450256570E-01, 2.3279628383E-01, 5.4143617766E-01],
	[1.0155000000E+04, 5.0624779677E+00, 5.9266299114E+00, 2.5489335007E-01, 2.3312897317E-01, 5.4160723149E-01],
	[1.0160000000E+04, 5.0656692359E+00, 5.9259798557E+00, 2.5528454057E-01, 2.3346194196E-01, 5.4177825849E-01],
	[1.0165000000E+04, 5.0688609442E+00, 5.9253301911E+00, 2.5567613741E-01, 2.3379519021E-01, 5.4194925868E-01],
	[1.0170000000E+04, 5.0720530925E+00, 5.9246809172E+00, 2.5606814081E-01, 2.3412871794E-01, 5.4212023206E-01],
	[1.0175000000E+04, 5.0752456805E+00, 5.9240320334E+00, 2.5646055098E-01, 2.3446252514E-01, 5.4229117865E-01],
	[1.0180000000E+04, 5.0784387082E+00, 5.9233835395E+00, 2.5685336816E-01, 2.3479661184E-01, 5.4246209843E-01],
	[1.0185000000E+04, 5.0816321754E+00, 5.9227354349E+00, 2.5724659255E-01, 2.3513097803E-01, 5.4263299143E-01],
	[1.0190000000E+04, 5.0848260818E+00, 5.9220877193E+00, 2.5764022439E-01, 2.3546562374E-01, 5.4280385764E-01],
	[1.0195000000E+04, 5.0880204274E+00, 5.9214403922E+00, 2.5803426388E-01, 2.3580054896E-01, 5.4297469707E-01],
	[1.0200000000E+04, 5.0912152121E+00, 5.9207934533E+00, 2.5842871125E-01, 2.3613575371E-01, 5.4314550972E-01],
	[1.0205000000E+04, 5.0944104356E+00, 5.9201469019E+00, 2.5882356673E-01, 2.3647123799E-01, 5.4331629561E-01],
	[1.0210000000E+04, 5.0976060978E+00, 5.9195007379E+00, 2.5921883052E-01, 2.3680700181E-01, 5.4348705473E-01],
	[1.0215000000E+04, 5.1008021985E+00, 5.9188549607E+00, 2.5961450285E-01, 2.3714304519E-01, 5.4365778710E-01],
	[1.0220000000E+04, 5.1039987376E+00, 5.9182095699E+00, 2.6001058394E-01, 2.3747936812E-01, 5.4382849271E-01],
	[1.0225000000E+04, 5.1071957150E+00, 5.9175645650E+00, 2.6040707402E-01, 2.3781597062E-01, 5.4399917158E-01],
	[1.0230000000E+04, 5.1103931304E+00, 5.9169199458E+00, 2.6080397329E-01, 2.3815285270E-01, 5.4416982370E-01],
	[1.0235000000E+04, 5.1135909838E+00, 5.9162757117E+00, 2.6120128198E-01, 2.3849001435E-01, 5.4434044909E-01],
	[1.0240000000E+04, 5.1167892749E+00, 5.9156318624E+00, 2.6159900032E-01, 2.3882745559E-01, 5.4451104776E-01],
	[1.0245000000E+04, 5.1199880037E+00, 5.9149883973E+00, 2.6199712851E-01, 2.3916517643E-01, 5.4468161969E-01],
	[1.0250000000E+04, 5.1231871699E+00, 5.9143453162E+00, 2.6239566678E-01, 2.3950317686E-01, 5.4485216491E-01],
	[1.0255000000E+04, 5.1263867734E+00, 5.9137026186E+00, 2.6279461536E-01, 2.3984145690E-01, 5.4502268342E-01],
	[1.0260000000E+04, 5.1295885190E+00, 5.9130629784E+00, 2.6319397446E-01, 2.4018002471E-01, 5.4519317523E-01],
	[1.0265000000E+04, 5.1327943394E+00, 5.9124294194E+00, 2.6359374429E-01, 2.4051888959E-01, 5.4536364033E-01],
	[1.0270000000E+04, 5.1360006007E+00, 5.9117962368E+00, 2.6399392509E-01, 2.4085803421E-01, 5.4553407874E-01],
	[1.0275000000E+04, 5.1392073028E+00, 5.9111634302E+00, 2.6439451707E-01, 2.4119745858E-01, 5.4570449046E-01],
	[1.0280000000E+04, 5.1424144455E+00, 5.9105309991E+00, 2.6479552045E-01, 2.4153716271E-01, 5.4587487551E-01],
	[1.0285000000E+04, 5.1456220287E+00, 5.9098989432E+00, 2.6519693546E-01, 2.4187714660E-01, 5.4604523387E-01],
	[1.0290000000E+04, 5.1488300521E+00, 5.9092672620E+00, 2.6559876231E-01, 2.4221741026E-01, 5.4621556557E-01],
	[1.0295000000E+04, 5.1520385158E+00, 5.9086359551E+00, 2.6600100121E-01, 2.4255795368E-01, 5.4638587061E-01],
	[1.0300000000E+04, 5.1552474194E+00, 5.9080050221E+00, 2.6640365241E-01, 2.4289877688E-01, 5.4655614898E-01],
	[1.0305000000E+04, 5.1584567628E+00, 5.9073744627E+00, 2.6680671610E-01, 2.4323987987E-01, 5.4672640064E-01],
	[1.0310000000E+04, 5.1616665459E+00, 5.9067442764E+00, 2.6721019252E-01, 2.4358126263E-01, 5.4689662556E-01],
	[1.0315000000E+04, 5.1648767686E+00, 5.9061144629E+00, 2.6761408188E-01, 2.4392292518E-01, 5.4706682372E-01],
	[1.0320000000E+04, 5.1680874307E+00, 5.9054850216E+00, 2.6801838441E-01, 2.4426486753E-01, 5.4723699511E-01],
	[1.0325000000E+04, 5.1712985320E+00, 5.9048559523E+00, 2.6842310031E-01, 2.4460708967E-01, 5.4740713971E-01],
	[1.0330000000E+04, 5.1745100723E+00, 5.9042272545E+00, 2.6882822983E-01, 2.4494959161E-01, 5.4757725752E-01],
	[1.0335000000E+04, 5.1777220516E+00, 5.9035989278E+00, 2.6923377317E-01, 2.4529237335E-01, 5.4774734852E-01],
	[1.0340000000E+04, 5.1809344697E+00, 5.9029709718E+00, 2.6963973055E-01, 2.4563543489E-01, 5.4791741269E-01],
	[1.0345000000E+04, 5.1841473263E+00, 5.9023433862E+00, 2.7004610220E-01, 2.4597877624E-01, 5.4808745004E-01],
	[1.0350000000E+04, 5.1873606215E+00, 5.9017161705E+00, 2.7045288833E-01, 2.4632239741E-01, 5.4825746053E-01],
	[1.0355000000E+04, 5.1905743549E+00, 5.9010893243E+00, 2.7086008917E-01, 2.4666629838E-01, 5.4842744417E-01],
	[1.0360000000E+04, 5.1937885266E+00, 5.9004628473E+00, 2.7126770494E-01, 2.4701047917E-01, 5.4859740094E-01],
	[1.0365000000E+04, 5.1970031362E+00, 5.8998367390E+00, 2.7167573585E-01, 2.4735493977E-01, 5.4876733083E-01],
	[1.0370000000E+04, 5.2002181837E+00, 5.8992109991E+00, 2.7208418213E-01, 2.4769968019E-01, 5.4893723381E-01],
	[1.0375000000E+04, 5.2034336689E+00, 5.8985856271E+00, 2.7249304400E-01, 2.4804470044E-01, 5.4910710990E-01],
	[1.0380000000E+04, 5.2066495916E+00, 5.8979606227E+00, 2.7290232167E-01, 2.4839000050E-01, 5.4927695906E-01],
	[1.0385000000E+04, 5.2098659518E+00, 5.8973359854E+00, 2.7331201537E-01, 2.4873558038E-01, 5.4944678129E-01],
	[1.0390000000E+04, 5.2130827492E+00, 5.8967117149E+00, 2.7372212532E-01, 2.4908144008E-01, 5.4961657658E-01],
	[1.0395000000E+04, 5.2162999837E+00, 5.8960878108E+00, 2.7413265174E-01, 2.4942757961E-01, 5.4978634491E-01],
	[1.0400000000E+04, 5.2195176552E+00, 5.8954642727E+00, 2.7454359485E-01, 2.4977399896E-01, 5.4995608627E-01],
	[1.0405000000E+04, 5.2227357635E+00, 5.8948411002E+00, 2.7495495487E-01, 2.5012069814E-01, 5.5012580065E-01],
	[1.0410000000E+04, 5.2259543084E+00, 5.8942182928E+00, 2.7536673202E-01, 2.5046767713E-01, 5.5029548805E-01],
	[1.0415000000E+04, 5.2291732899E+00, 5.8935958504E+00, 2.7577892652E-01, 2.5081493595E-01, 5.5046514844E-01],
	[1.0420000000E+04, 5.2323927076E+00, 5.8929737723E+00, 2.7619153859E-01, 2.5116247459E-01, 5.5063478181E-01],
	[1.0425000000E+04, 5.2356142054E+00, 5.8923544356E+00, 2.7660456845E-01, 2.5151030118E-01, 5.5080438816E-01],
	[1.0430000000E+04, 5.2388401666E+00, 5.8917412794E+00, 2.7701801633E-01, 2.5185842756E-01, 5.5097396747E-01],
	[1.0435000000E+04, 5.2420665680E+00, 5.8911284808E+00, 2.7743188243E-01, 2.5220683390E-01, 5.5114351974E-01],
	[1.0440000000E+04, 5.2452934094E+00, 5.8905160395E+00, 2.7784616699E-01, 2.5255552017E-01, 5.5131304494E-01],
	[1.0445000000E+04, 5.2485206906E+00, 5.8899039551E+00, 2.7826087022E-01, 2.5290448640E-01, 5.5148254307E-01],
	[1.0450000000E+04, 5.2517484116E+00, 5.8892922271E+00, 2.7867599235E-01, 2.5325373257E-01, 5.5165201412E-01],
	[1.0455000000E+04, 5.2549765721E+00, 5.8886808553E+00, 2.7909153359E-01, 2.5360325868E-01, 5.5182145807E-01],
	[1.0460000000E+04, 5.2582051720E+00, 5.8880698392E+00, 2.7950749416E-01, 2.5395306474E-01, 5.5199087491E-01],
	[1.0465000000E+04, 5.2614342111E+00, 5.8874591784E+00, 2.7992387429E-01, 2.5430315073E-01, 5.5216026464E-01],
	[1.0470000000E+04, 5.2646636894E+00, 5.8868488726E+00, 2.8034067420E-01, 2.5465351666E-01, 5.5232962724E-01],
	[1.0475000000E+04, 5.2678936066E+00, 5.8862389215E+00, 2.8075789410E-01, 2.5500416252E-01, 5.5249896271E-01],
	[1.0480000000E+04, 5.2711239627E+00, 5.8856293245E+00, 2.8117553422E-01, 2.5535508832E-01, 5.5266827102E-01],
	[1.0485000000E+04, 5.2743547574E+00, 5.8850200815E+00, 2.8159359478E-01, 2.5570629404E-01, 5.5283755217E-01],
	[1.0490000000E+04, 5.2775859906E+00, 5.8844111919E+00, 2.8201207599E-01, 2.5605777969E-01, 5.5300680614E-01],
	[1.0495000000E+04, 5.2808176621E+00, 5.8838026554E+00, 2.8243097809E-01, 2.5640954526E-01, 5.5317603294E-01],
	[1.0500000000E+04, 5.2840497719E+00, 5.8831944716E+00, 2.8285030128E-01, 2.5676159075E-01, 5.5334523254E-01],
	[1.0505000000E+04, 5.2872823197E+00, 5.8825866402E+00, 2.8327004579E-01, 2.5711391615E-01, 5.5351440493E-01],
	[1.0510000000E+04, 5.2905153054E+00, 5.8819791608E+00, 2.8369021185E-01, 2.5746652146E-01, 5.5368355011E-01],
	[1.0515000000E+04, 5.2937487289E+00, 5.8813720331E+00, 2.8411079966E-01, 2.5781940668E-01, 5.5385266807E-01],
	[1.0520000000E+04, 5.2969825900E+00, 5.8807652565E+00, 2.8453180945E-01, 2.5817257180E-01, 5.5402175878E-01],
	[1.0525000000E+04, 5.3002168885E+00, 5.8801588309E+00, 2.8495324145E-01, 2.5852601682E-01, 5.5419082225E-01],
	[1.0530000000E+04, 5.3034516244E+00, 5.8795527557E+00, 2.8537509587E-01, 2.5887974173E-01, 5.5435985847E-01],
	[1.0535000000E+04, 5.3066867974E+00, 5.8789470307E+00, 2.8579737294E-01, 2.5923374653E-01, 5.5452886741E-01],
	[1.0540000000E+04, 5.3099224075E+00, 5.8783416555E+00, 2.8622007286E-01, 2.5958803121E-01, 5.5469784907E-01],
	[1.0545000000E+04, 5.3131584544E+00, 5.8777366297E+00, 2.8664319588E-01, 2.5994259576E-01, 5.5486680345E-01],
	[1.0550000000E+04, 5.3163949380E+00, 5.8771319529E+00, 2.8706674219E-01, 2.6029744018E-01, 5.5503573052E-01],
	[1.0555000000E+04, 5.3196318582E+00, 5.8765276248E+00, 2.8749071204E-01, 2.6065256447E-01, 5.5520463029E-01],
	[1.0560000000E+04, 5.3228692149E+00, 5.8759236450E+00, 2.8791510563E-01, 2.6100796862E-01, 5.5537350273E-01],
	[1.0565000000E+04, 5.3261070078E+00, 5.8753200131E+00, 2.8833992319E-01, 2.6136365262E-01, 5.5554234785E-01],
	[1.0570000000E+04, 5.3293452368E+00, 5.8747167288E+00, 2.8876516493E-01, 2.6171961646E-01, 5.5571116562E-01],
	[1.0575000000E+04, 5.3325839018E+00, 5.8741137917E+00, 2.8919083109E-01, 2.6207586014E-01, 5.5587995605E-01],
	[1.0580000000E+04, 5.3358230027E+00, 5.8735112015E+00, 2.8961692187E-01, 2.6243238366E-01, 5.5604871911E-01],
	[1.0585000000E+04, 5.3390625392E+00, 5.8729089578E+00, 2.9004343751E-01, 2.6278918699E-01, 5.5621745481E-01],
	[1.0590000000E+04, 5.3423025112E+00, 5.8723070601E+00, 2.9047037821E-01, 2.6314627015E-01, 5.5638616312E-01],
	[1.0595000000E+04, 5.3455472934E+00, 5.8717113560E+00, 2.9089774421E-01, 2.6350365551E-01, 5.5655484404E-01],
	[1.0600000000E+04, 5.3487941409E+00, 5.8711181665E+00, 2.9132553572E-01, 2.6386132913E-01, 5.5672349757E-01],
	[1.0605000000E+04, 5.3520414279E+00, 5.8705253166E+00, 2.9175375296E-01, 2.6421928268E-01, 5.5689212368E-01],
	[1.0610000000E+04, 5.3552891544E+00, 5.8699328060E+00, 2.9218239616E-01, 2.6457751616E-01, 5.5706072238E-01],
	[1.0615000000E+04, 5.3585373201E+00, 5.8693406343E+00, 2.9261146553E-01, 2.6493602954E-01, 5.5722929364E-01],
	[1.0620000000E+04, 5.3617859249E+00, 5.8687488012E+00, 2.9304096129E-01, 2.6529482284E-01, 5.5739783747E-01],
	[1.0625000000E+04, 5.3650349687E+00, 5.8681573063E+00, 2.9347088368E-01, 2.6565389603E-01, 5.5756635384E-01],
	[1.0630000000E+04, 5.3682844512E+00, 5.8675661492E+00, 2.9390123289E-01, 2.6601324911E-01, 5.5773484276E-01],
	[1.0635000000E+04, 5.3715343725E+00, 5.8669753297E+00, 2.9433200917E-01, 2.6637288207E-01, 5.5790330421E-01],
	[1.0640000000E+04, 5.3747847322E+00, 5.8663848473E+00, 2.9476321273E-01, 2.6673279490E-01, 5.5807173819E-01],
	[1.0645000000E+04, 5.3780355303E+00, 5.8657947017E+00, 2.9519484378E-01, 2.6709298760E-01, 5.5824014468E-01],
	[1.0650000000E+04, 5.3812867667E+00, 5.8652048926E+00, 2.9562690256E-01, 2.6745346014E-01, 5.5840852367E-01],
	[1.0655000000E+04, 5.3845384411E+00, 5.8646154196E+00, 2.9605938928E-01, 2.6781421252E-01, 5.5857687516E-01],
	[1.0660000000E+04, 5.3877905534E+00, 5.8640262823E+00, 2.9649230415E-01, 2.6817524474E-01, 5.5874519913E-01],
	[1.0665000000E+04, 5.3910431035E+00, 5.8634374804E+00, 2.9692564742E-01, 2.6853655678E-01, 5.5891349559E-01],
	[1.0670000000E+04, 5.3942960913E+00, 5.8628490136E+00, 2.9735941928E-01, 2.6889814863E-01, 5.5908176450E-01],
	[1.0675000000E+04, 5.3975495165E+00, 5.8622608815E+00, 2.9779361997E-01, 2.6926002027E-01, 5.5925000588E-01],
	[1.0680000000E+04, 5.4008033791E+00, 5.8616730838E+00, 2.9822824970E-01, 2.6962217171E-01, 5.5941821971E-01],
	[1.0685000000E+04, 5.4040576789E+00, 5.8610856201E+00, 2.9866330870E-01, 2.6998460292E-01, 5.5958640597E-01],
	[1.0690000000E+04, 5.4073124157E+00, 5.8604984900E+00, 2.9909879719E-01, 2.7034731390E-01, 5.5975456467E-01],
	[1.0695000000E+04, 5.4105675895E+00, 5.8599116933E+00, 2.9953471539E-01, 2.7071030464E-01, 5.5992269579E-01],
	[1.0700000000E+04, 5.4138232000E+00, 5.8593252296E+00, 2.9997106351E-01, 2.7107357511E-01, 5.6009079932E-01],
	[1.0705000000E+04, 5.4170792471E+00, 5.8587390985E+00, 3.0040784179E-01, 2.7143712532E-01, 5.6025887526E-01],
	[1.0710000000E+04, 5.4203357307E+00, 5.8581532997E+00, 3.0084505043E-01, 2.7180095524E-01, 5.6042692360E-01],
	[1.0715000000E+04, 5.4235926506E+00, 5.8575678328E+00, 3.0128268967E-01, 2.7216506487E-01, 5.6059494432E-01],
	[1.0720000000E+04, 5.4268500066E+00, 5.8569826976E+00, 3.0172075972E-01, 2.7252945420E-01, 5.6076293742E-01],
	[1.0725000000E+04, 5.4301077987E+00, 5.8563978936E+00, 3.0215926080E-01, 2.7289412320E-01, 5.6093090289E-01],
	[1.0730000000E+04, 5.4333660267E+00, 5.8558134205E+00, 3.0259819314E-01, 2.7325907187E-01, 5.6109884072E-01],
	[1.0735000000E+04, 5.4366246905E+00, 5.8552292781E+00, 3.0303755695E-01, 2.7362430019E-01, 5.6126675091E-01],
	[1.0740000000E+04, 5.4398837898E+00, 5.8546454658E+00, 3.0347735246E-01, 2.7398980816E-01, 5.6143463344E-01],
	[1.0745000000E+04, 5.4431433246E+00, 5.8540619835E+00, 3.0391757989E-01, 2.7435559574E-01, 5.6160248830E-01],
	[1.0750000000E+04, 5.4464032947E+00, 5.8534788307E+00, 3.0435823945E-01, 2.7472166295E-01, 5.6177031550E-01],
	[1.0755000000E+04, 5.4496637000E+00, 5.8528960071E+00, 3.0479933138E-01, 2.7508800974E-01, 5.6193811501E-01],
	[1.0760000000E+04, 5.4529245402E+00, 5.8523135125E+00, 3.0524085588E-01, 2.7545463613E-01, 5.6210588683E-01],
	[1.0765000000E+04, 5.4561897923E+00, 5.8517362746E+00, 3.0568281319E-01, 2.7582156319E-01, 5.6227363096E-01],
	[1.0770000000E+04, 5.4594578414E+00, 5.8511622835E+00, 3.0612520351E-01, 2.7618878245E-01, 5.6244134738E-01],
	[1.0775000000E+04, 5.4627263297E+00, 5.8505886151E+00, 3.0656802708E-01, 2.7655628139E-01, 5.6260903608E-01],
	[1.0780000000E+04, 5.4659952571E+00, 5.8500152691E+00, 3.0701128412E-01, 2.7692406001E-01, 5.6277669707E-01],
	[1.0785000000E+04, 5.4692646235E+00, 5.8494422450E+00, 3.0745497484E-01, 2.7729211828E-01, 5.6294433032E-01],
	[1.0790000000E+04, 5.4725344286E+00, 5.8488695427E+00, 3.0789909947E-01, 2.7766045620E-01, 5.6311193584E-01],
	[1.0795000000E+04, 5.4758046724E+00, 5.8482971617E+00, 3.0834365822E-01, 2.7802907374E-01, 5.6327951361E-01],
	[1.0800000000E+04, 5.4790753547E+00, 5.8477251017E+00, 3.0878865133E-01, 2.7839797088E-01, 5.6344706362E-01],
	[1.0805000000E+04, 5.4823464754E+00, 5.8471533625E+00, 3.0923407900E-01, 2.7876714763E-01, 5.6361458588E-01],
	[1.0810000000E+04, 5.4856180343E+00, 5.8465819436E+00, 3.0967994147E-01, 2.7913660395E-01, 5.6378208036E-01],
	[1.0815000000E+04, 5.4888900312E+00, 5.8460108447E+00, 3.1012623894E-01, 2.7950633983E-01, 5.6394954707E-01],
	[1.0820000000E+04, 5.4921624661E+00, 5.8454400656E+00, 3.1057297165E-01, 2.7987635526E-01, 5.6411698599E-01],
	[1.0825000000E+04, 5.4954353387E+00, 5.8448696058E+00, 3.1102013981E-01, 2.8024665021E-01, 5.6428439712E-01],
	[1.0830000000E+04, 5.4987086490E+00, 5.8442994652E+00, 3.1146774365E-01, 2.8061722468E-01, 5.6445178045E-01],
	[1.0835000000E+04, 5.5019823968E+00, 5.8437296432E+00, 3.1191578339E-01, 2.8098807864E-01, 5.6461913597E-01],
	[1.0840000000E+04, 5.5052565819E+00, 5.8431601397E+00, 3.1236425924E-01, 2.8135921207E-01, 5.6478646368E-01],
	[1.0845000000E+04, 5.5085312043E+00, 5.8425909543E+00, 3.1281317143E-01, 2.8173062496E-01, 5.6495376356E-01],
	[1.0850000000E+04, 5.5118062637E+00, 5.8420220866E+00, 3.1326252018E-01, 2.8210231729E-01, 5.6512103561E-01],
	[1.0855000000E+04, 5.5150817600E+00, 5.8414535363E+00, 3.1371230571E-01, 2.8247428905E-01, 5.6528827982E-01],
	[1.0860000000E+04, 5.5183576931E+00, 5.8408853032E+00, 3.1416252824E-01, 2.8284654020E-01, 5.6545549619E-01],
	[1.0865000000E+04, 5.5216340629E+00, 5.8403173869E+00, 3.1461318800E-01, 2.8321907075E-01, 5.6562268470E-01],
	[1.0870000000E+04, 5.5249108691E+00, 5.8397497871E+00, 3.1506428520E-01, 2.8359188065E-01, 5.6578984536E-01],
	[1.0875000000E+04, 5.5281881117E+00, 5.8391825034E+00, 3.1551582006E-01, 2.8396496991E-01, 5.6595697814E-01],
	[1.0880000000E+04, 5.5314657905E+00, 5.8386155355E+00, 3.1596779282E-01, 2.8433833849E-01, 5.6612408305E-01],
	[1.0885000000E+04, 5.5347439053E+00, 5.8380488831E+00, 3.1642020368E-01, 2.8471198638E-01, 5.6629116008E-01],
	[1.0890000000E+04, 5.5380224561E+00, 5.8374825460E+00, 3.1687305287E-01, 2.8508591356E-01, 5.6645820922E-01],
	[1.0895000000E+04, 5.5413014427E+00, 5.8369165236E+00, 3.1732634060E-01, 2.8546012001E-01, 5.6662523046E-01],
	[1.0900000000E+04, 5.5445808649E+00, 5.8363508159E+00, 3.1778006712E-01, 2.8583460571E-01, 5.6679222380E-01],
	[1.0905000000E+04, 5.5478607226E+00, 5.8357854224E+00, 3.1823423262E-01, 2.8620937064E-01, 5.6695918923E-01],
	[1.0910000000E+04, 5.5511410157E+00, 5.8352203427E+00, 3.1868883734E-01, 2.8658441477E-01, 5.6712612675E-01],
	[1.0915000000E+04, 5.5544217439E+00, 5.8346555767E+00, 3.1914388149E-01, 2.8695973810E-01, 5.6729303633E-01],
	[1.0920000000E+04, 5.5577029073E+00, 5.8340911240E+00, 3.1959936530E-01, 2.8733534058E-01, 5.6745991799E-01],
	[1.0925000000E+04, 5.5609845056E+00, 5.8335269842E+00, 3.2005528899E-01, 2.8771122222E-01, 5.6762677171E-01],
	[1.0930000000E+04, 5.5642665386E+00, 5.8329631570E+00, 3.2051165277E-01, 2.8808738297E-01, 5.6779359744E-01],
	[1.0935000000E+04, 5.5675490063E+00, 5.8323996422E+00, 3.2096845688E-01, 2.8846382283E-01, 5.6796039515E-01],
	[1.0940000000E+04, 5.5708384323E+00, 5.8318439495E+00, 3.2142570153E-01, 2.8884057773E-01, 5.6812716483E-01],
	[1.0945000000E+04, 5.5741284479E+00, 5.8312887367E+00, 3.2188338694E-01, 2.8921761268E-01, 5.6829390646E-01],
	[1.0950000000E+04, 5.5774189025E+00, 5.8307338304E+00, 3.2234151333E-01, 2.8959492681E-01, 5.6846062001E-01],
	[1.0955000000E+04, 5.5807097960E+00, 5.8301792301E+00, 3.2280008093E-01, 2.8997252012E-01, 5.6862730547E-01],
	[1.0960000000E+04, 5.5840011283E+00, 5.8296249357E+00, 3.2325908996E-01, 2.9035039258E-01, 5.6879396282E-01],
	[1.0965000000E+04, 5.5872928992E+00, 5.8290709467E+00, 3.2371854064E-01, 2.9072854417E-01, 5.6896059204E-01],
	[1.0970000000E+04, 5.5905851086E+00, 5.8285172628E+00, 3.2417843318E-01, 2.9110697486E-01, 5.6912719310E-01],
	[1.0975000000E+04, 5.5938777563E+00, 5.8279638839E+00, 3.2463876782E-01, 2.9148568464E-01, 5.6929376599E-01],
	[1.0980000000E+04, 5.5971708422E+00, 5.8274108095E+00, 3.2509954477E-01, 2.9186467347E-01, 5.6946031070E-01],
	[1.0985000000E+04, 5.6004643662E+00, 5.8268580393E+00, 3.2556076425E-01, 2.9224394133E-01, 5.6962682719E-01],
	[1.0990000000E+04, 5.6037583281E+00, 5.8263055731E+00, 3.2602242648E-01, 2.9262348821E-01, 5.6979331545E-01],
	[1.0995000000E+04, 5.6070527278E+00, 5.8257534106E+00, 3.2648453169E-01, 2.9300331408E-01, 5.6995977547E-01],
	[1.1000000000E+04, 5.6103475651E+00, 5.8252015513E+00, 3.2694708010E-01, 2.9338341891E-01, 5.7012620722E-01],
	[1.1005000000E+04, 5.6136428399E+00, 5.8246499951E+00, 3.2741007193E-01, 2.9376380268E-01, 5.7029261068E-01],
	[1.1010000000E+04, 5.6169385520E+00, 5.8240987416E+00, 3.2787350740E-01, 2.9414446536E-01, 5.7045898584E-01],
	[1.1015000000E+04, 5.6202347014E+00, 5.8235477906E+00, 3.2833738673E-01, 2.9452540694E-01, 5.7062533268E-01],
	[1.1020000000E+04, 5.6235312878E+00, 5.8229971416E+00, 3.2880171015E-01, 2.9490662738E-01, 5.7079165117E-01],
	[1.1025000000E+04, 5.6268283111E+00, 5.8224467945E+00, 3.2926647787E-01, 2.9528812666E-01, 5.7095794130E-01],
	[1.1030000000E+04, 5.6301257713E+00, 5.8218967489E+00, 3.2973169011E-01, 2.9566990476E-01, 5.7112420305E-01],
	[1.1035000000E+04, 5.6334236681E+00, 5.8213470045E+00, 3.3019734710E-01, 2.9605196165E-01, 5.7129043641E-01],
	[1.1040000000E+04, 5.6367220014E+00, 5.8207975610E+00, 3.3066344906E-01, 2.9643429730E-01, 5.7145664134E-01],
	[1.1045000000E+04, 5.6400207711E+00, 5.8202484181E+00, 3.3112999622E-01, 2.9681691168E-01, 5.7162281784E-01],
	[1.1050000000E+04, 5.6433199770E+00, 5.8196995755E+00, 3.3159698878E-01, 2.9719980479E-01, 5.7178896589E-01],
	[1.1055000000E+04, 5.6466196189E+00, 5.8191510329E+00, 3.3206442698E-01, 2.9758297657E-01, 5.7195508546E-01],
	[1.1060000000E+04, 5.6499196969E+00, 5.8186027901E+00, 3.3253231103E-01, 2.9796642702E-01, 5.7212117654E-01],
	[1.1065000000E+04, 5.6532202106E+00, 5.8180548466E+00, 3.3300064115E-01, 2.9835015609E-01, 5.7228723910E-01],
	[1.1070000000E+04, 5.6565211600E+00, 5.8175072023E+00, 3.3346941758E-01, 2.9873416378E-01, 5.7245327315E-01],
	[1.1075000000E+04, 5.6598225450E+00, 5.8169598568E+00, 3.3393864052E-01, 2.9911845004E-01, 5.7261927864E-01],
	[1.1080000000E+04, 5.6631243653E+00, 5.8164128098E+00, 3.3440831021E-01, 2.9950301485E-01, 5.7278525557E-01],
	[1.1085000000E+04, 5.6664266209E+00, 5.8158660610E+00, 3.3487842686E-01, 2.9988785818E-01, 5.7295120392E-01],
	[1.1090000000E+04, 5.6697293116E+00, 5.8153196101E+00, 3.3534899069E-01, 3.0027298001E-01, 5.7311712366E-01],
	[1.1095000000E+04, 5.6730324373E+00, 5.8147734569E+00, 3.3582000192E-01, 3.0065838031E-01, 5.7328301479E-01],
	[1.1100000000E+04, 5.6763359979E+00, 5.8142276009E+00, 3.3629146079E-01, 3.0104405905E-01, 5.7344887728E-01],
	[1.1105000000E+04, 5.6796399931E+00, 5.8136820421E+00, 3.3676336750E-01, 3.0143001619E-01, 5.7361471111E-01],
	[1.1110000000E+04, 5.6829444229E+00, 5.8131367799E+00, 3.3723572228E-01, 3.0181625172E-01, 5.7378051628E-01],
	[1.1115000000E+04, 5.6862546841E+00, 5.8125976005E+00, 3.3770852535E-01, 3.0220279648E-01, 5.7394629275E-01],
	[1.1120000000E+04, 5.6895670020E+00, 5.8120604475E+00, 3.3818177694E-01, 3.0258962898E-01, 5.7411204051E-01],
	[1.1125000000E+04, 5.6928797590E+00, 5.8115235855E+00, 3.3865547726E-01, 3.0297673993E-01, 5.7427775954E-01],
	[1.1130000000E+04, 5.6961929550E+00, 5.8109870144E+00, 3.3912962653E-01, 3.0336412932E-01, 5.7444344983E-01],
	[1.1135000000E+04, 5.6995065899E+00, 5.8104507338E+00, 3.3960422499E-01, 3.0375179712E-01, 5.7460911136E-01],
	[1.1140000000E+04, 5.7028206635E+00, 5.8099147434E+00, 3.4007927284E-01, 3.0413974329E-01, 5.7477474411E-01],
	[1.1145000000E+04, 5.7061351758E+00, 5.8093790429E+00, 3.4055477032E-01, 3.0452796780E-01, 5.7494034807E-01],
	[1.1150000000E+04, 5.7094501264E+00, 5.8088436320E+00, 3.4103071763E-01, 3.0491647063E-01, 5.7510592320E-01],
	[1.1155000000E+04, 5.7127655154E+00, 5.8083085105E+00, 3.4150711501E-01, 3.0530525174E-01, 5.7527146951E-01],
	[1.1160000000E+04, 5.7160813426E+00, 5.8077736781E+00, 3.4198396268E-01, 3.0569431111E-01, 5.7543698697E-01],
	[1.1165000000E+04, 5.7193976078E+00, 5.8072391345E+00, 3.4246126085E-01, 3.0608364870E-01, 5.7560247556E-01],
	[1.1170000000E+04, 5.7227143109E+00, 5.8067048793E+00, 3.4293900976E-01, 3.0647326448E-01, 5.7576793526E-01],
	[1.1175000000E+04, 5.7260314518E+00, 5.8061709124E+00, 3.4341720961E-01, 3.0686315843E-01, 5.7593336607E-01],
	[1.1180000000E+04, 5.7293490303E+00, 5.8056372334E+00, 3.4389586064E-01, 3.0725333050E-01, 5.7609876796E-01],
	[1.1185000000E+04, 5.7326670463E+00, 5.8051038420E+00, 3.4437782736E-01, 3.0764606654E-01, 5.7626414091E-01],
	[1.1190000000E+04, 5.7359854997E+00, 5.8045707380E+00, 3.4486043564E-01, 3.0803923108E-01, 5.7642948491E-01],
	[1.1195000000E+04, 5.7393043902E+00, 5.8040379210E+00, 3.4534350309E-01, 3.0843267830E-01, 5.7659479994E-01],
	[1.1200000000E+04, 5.7426237178E+00, 5.8035053909E+00, 3.4582702995E-01, 3.0882640818E-01, 5.7676008598E-01],
	[1.1205000000E+04, 5.7459434824E+00, 5.8029731473E+00, 3.4631101644E-01, 3.0922042068E-01, 5.7692534302E-01],
	[1.1210000000E+04, 5.7492636838E+00, 5.8024411899E+00, 3.4679546280E-01, 3.0961471579E-01, 5.7709057103E-01],
	[1.1215000000E+04, 5.7525843218E+00, 5.8019095184E+00, 3.4728036924E-01, 3.1000929346E-01, 5.7725577002E-01],
	[1.1220000000E+04, 5.7559053963E+00, 5.8013781326E+00, 3.4776573602E-01, 3.1040415366E-01, 5.7742093994E-01],
	[1.1225000000E+04, 5.7592269073E+00, 5.8008470322E+00, 3.4825156334E-01, 3.1079929636E-01, 5.7758608080E-01],
	[1.1230000000E+04, 5.7625488545E+00, 5.8003162169E+00, 3.4873785145E-01, 3.1119472154E-01, 5.7775119257E-01],
	[1.1235000000E+04, 5.7658712378E+00, 5.7997856865E+00, 3.4922460057E-01, 3.1159042915E-01, 5.7791627523E-01],
	[1.1240000000E+04, 5.7691940570E+00, 5.7992554406E+00, 3.4971181094E-01, 3.1198641916E-01, 5.7808132877E-01],
	[1.1245000000E+04, 5.7725173122E+00, 5.7987254789E+00, 3.5019948277E-01, 3.1238269155E-01, 5.7824635318E-01],
	[1.1250000000E+04, 5.7758410030E+00, 5.7981958012E+00, 3.5068761631E-01, 3.1277924628E-01, 5.7841134843E-01],
	[1.1255000000E+04, 5.7791651294E+00, 5.7976664073E+00, 3.5117621179E-01, 3.1317608331E-01, 5.7857631451E-01],
	[1.1260000000E+04, 5.7824896912E+00, 5.7971372968E+00, 3.5166526943E-01, 3.1357320261E-01, 5.7874125141E-01],
	[1.1265000000E+04, 5.7858146883E+00, 5.7966084694E+00, 3.5215478946E-01, 3.1397060415E-01, 5.7890615910E-01],
	[1.1270000000E+04, 5.7891401205E+00, 5.7960799249E+00, 3.5264477211E-01, 3.1436828790E-01, 5.7907103757E-01],
	[1.1275000000E+04, 5.7924659878E+00, 5.7955516630E+00, 3.5313521761E-01, 3.1476625382E-01, 5.7923588681E-01],
	[1.1280000000E+04, 5.7957922900E+00, 5.7950236835E+00, 3.5362612620E-01, 3.1516450188E-01, 5.7940070679E-01],
	[1.1285000000E+04, 5.7991190269E+00, 5.7944959859E+00, 3.5411749810E-01, 3.1556303203E-01, 5.7956549751E-01],
	[1.1290000000E+04, 5.8024461984E+00, 5.7939685702E+00, 3.5460933355E-01, 3.1596184426E-01, 5.7973025894E-01],
	[1.1295000000E+04, 5.8057811239E+00, 5.7934487563E+00, 3.5510163277E-01, 3.1636098207E-01, 5.7989499107E-01],
	[1.1300000000E+04, 5.8091165296E+00, 5.7929292597E+00, 3.5559439599E-01, 3.1676040231E-01, 5.8005969389E-01],
	[1.1305000000E+04, 5.8124523746E+00, 5.7924100395E+00, 3.5608762344E-01, 3.1716010469E-01, 5.8022436737E-01],
	[1.1310000000E+04, 5.8157886589E+00, 5.7918910954E+00, 3.5658131536E-01, 3.1756008918E-01, 5.8038901151E-01],
	[1.1315000000E+04, 5.8191253823E+00, 5.7913724271E+00, 3.5707547196E-01, 3.1796035574E-01, 5.8055362628E-01],
	[1.1320000000E+04, 5.8224625448E+00, 5.7908540344E+00, 3.5757009350E-01, 3.1836090434E-01, 5.8071821167E-01],
	[1.1325000000E+04, 5.8258001460E+00, 5.7903359170E+00, 3.5806518018E-01, 3.1876173494E-01, 5.8088276767E-01],
	[1.1330000000E+04, 5.8291381860E+00, 5.7898180745E+00, 3.5856073225E-01, 3.1916284750E-01, 5.8104729426E-01],
	[1.1335000000E+04, 5.8324766645E+00, 5.7893005069E+00, 3.5905674994E-01, 3.1956424199E-01, 5.8121179141E-01],
	[1.1340000000E+04, 5.8358155815E+00, 5.7887832137E+00, 3.5955323346E-01, 3.1996591838E-01, 5.8137625913E-01],
	[1.1345000000E+04, 5.8391549368E+00, 5.7882661948E+00, 3.6005018306E-01, 3.2036787662E-01, 5.8154069739E-01],
	[1.1350000000E+04, 5.8424947302E+00, 5.7877494498E+00, 3.6054759897E-01, 3.2077011667E-01, 5.8170510617E-01],
	[1.1355000000E+04, 5.8458349617E+00, 5.7872329785E+00, 3.6104548141E-01, 3.2117263851E-01, 5.8186948547E-01],
	[1.1360000000E+04, 5.8491756311E+00, 5.7867167807E+00, 3.6154383061E-01, 3.2157544209E-01, 5.8203383526E-01],
	[1.1365000000E+04, 5.8525167382E+00, 5.7862008560E+00, 3.6204264681E-01, 3.2197852738E-01, 5.8219815553E-01],
	[1.1370000000E+04, 5.8558582830E+00, 5.7856852042E+00, 3.6254193023E-01, 3.2238189434E-01, 5.8236244627E-01],
	[1.1375000000E+04, 5.8592002653E+00, 5.7851698250E+00, 3.6304168111E-01, 3.2278554293E-01, 5.8252670745E-01],
	[1.1380000000E+04, 5.8625426849E+00, 5.7846547182E+00, 3.6354189967E-01, 3.2318947310E-01, 5.8269093907E-01],
	[1.1385000000E+04, 5.8658855417E+00, 5.7841398835E+00, 3.6404258615E-01, 3.2359368484E-01, 5.8285514111E-01],
	[1.1390000000E+04, 5.8692288357E+00, 5.7836253206E+00, 3.6454374077E-01, 3.2399817808E-01, 5.8301931356E-01],
	[1.1395000000E+04, 5.8725725665E+00, 5.7831110294E+00, 3.6504536377E-01, 3.2440295281E-01, 5.8318345639E-01],
	[1.1400000000E+04, 5.8759167342E+00, 5.7825970094E+00, 3.6554745537E-01, 3.2480800897E-01, 5.8334756959E-01],
	[1.1405000000E+04, 5.8792613386E+00, 5.7820832605E+00, 3.6605001582E-01, 3.2521334653E-01, 5.8351165316E-01],
	[1.1410000000E+04, 5.8826063795E+00, 5.7815697824E+00, 3.6655304532E-01, 3.2561896544E-01, 5.8367570707E-01],
	[1.1415000000E+04, 5.8859518569E+00, 5.7810565749E+00, 3.6705654413E-01, 3.2602486567E-01, 5.8383973130E-01],
	[1.1420000000E+04, 5.8892977705E+00, 5.7805436376E+00, 3.6756051246E-01, 3.2643104719E-01, 5.8400372585E-01],
	[1.1425000000E+04, 5.8926441203E+00, 5.7800309703E+00, 3.6806495055E-01, 3.2683750994E-01, 5.8416769071E-01],
	[1.1430000000E+04, 5.8959909061E+00, 5.7795185727E+00, 3.6856985862E-01, 3.2724425388E-01, 5.8433162584E-01],
	[1.1435000000E+04, 5.8993381277E+00, 5.7790064447E+00, 3.6907523692E-01, 3.2765127899E-01, 5.8449553124E-01],
	[1.1440000000E+04, 5.9026857851E+00, 5.7784945859E+00, 3.6958108566E-01, 3.2805858520E-01, 5.8465940690E-01],
	[1.1445000000E+04, 5.9060338781E+00, 5.7779829960E+00, 3.7008740508E-01, 3.2846617250E-01, 5.8482325280E-01],
	[1.1450000000E+04, 5.9093824066E+00, 5.7774716749E+00, 3.7059419541E-01, 3.2887404083E-01, 5.8498706893E-01],
	[1.1455000000E+04, 5.9127313704E+00, 5.7769606222E+00, 3.7110145688E-01, 3.2928219014E-01, 5.8515085527E-01],
	[1.1460000000E+04, 5.9160807695E+00, 5.7764498377E+00, 3.7160918972E-01, 3.2969062041E-01, 5.8531461180E-01],
	[1.1465000000E+04, 5.9194306036E+00, 5.7759393212E+00, 3.7211739416E-01, 3.3009933159E-01, 5.8547833851E-01],
	[1.1470000000E+04, 5.9227808727E+00, 5.7754290724E+00, 3.7262607044E-01, 3.3050832363E-01, 5.8564203540E-01],
	[1.1475000000E+04, 5.9261365374E+00, 5.7749237293E+00, 3.7313521877E-01, 3.3091762720E-01, 5.8580570244E-01],
	[1.1480000000E+04, 5.9294953876E+00, 5.7744212176E+00, 3.7364483939E-01, 3.3132722870E-01, 5.8596933961E-01],
	[1.1485000000E+04, 5.9328546777E+00, 5.7739189685E+00, 3.7415493254E-01, 3.3173711113E-01, 5.8613294691E-01],
	[1.1490000000E+04, 5.9362144076E+00, 5.7734169816E+00, 3.7466549843E-01, 3.3214727445E-01, 5.8629652433E-01],
	[1.1495000000E+04, 5.9395745771E+00, 5.7729152567E+00, 3.7517653731E-01, 3.3255771861E-01, 5.8646007183E-01],
	[1.1500000000E+04, 5.9429351862E+00, 5.7724137935E+00, 3.7568804941E-01, 3.3296844358E-01, 5.8662358942E-01],
	[1.1505000000E+04, 5.9462962346E+00, 5.7719125919E+00, 3.7620003494E-01, 3.3337944930E-01, 5.8678707708E-01],
	[1.1510000000E+04, 5.9496577222E+00, 5.7714116516E+00, 3.7671249415E-01, 3.3379073574E-01, 5.8695053480E-01],
	[1.1515000000E+04, 5.9530196490E+00, 5.7709109722E+00, 3.7722542727E-01, 3.3420230285E-01, 5.8711396255E-01],
	[1.1520000000E+04, 5.9563820147E+00, 5.7704105536E+00, 3.7773883452E-01, 3.3461415059E-01, 5.8727736031E-01],
	[1.1525000000E+04, 5.9597448193E+00, 5.7699103956E+00, 3.7825271614E-01, 3.3502627891E-01, 5.8744072804E-01],
	[1.1530000000E+04, 5.9631080626E+00, 5.7694104978E+00, 3.7876707235E-01, 3.3543868777E-01, 5.8760406573E-01],
	[1.1535000000E+04, 5.9664717444E+00, 5.7689108600E+00, 3.7928190339E-01, 3.3585137713E-01, 5.8776737334E-01],
	[1.1540000000E+04, 5.9698358647E+00, 5.7684114820E+00, 3.7979720948E-01, 3.3626434693E-01, 5.8793065086E-01],
	[1.1545000000E+04, 5.9732004234E+00, 5.7679123635E+00, 3.8031299087E-01, 3.3667759714E-01, 5.8809389827E-01],
	[1.1550000000E+04, 5.9765654201E+00, 5.7674135043E+00, 3.8082924777E-01, 3.3709112771E-01, 5.8825711553E-01],
	[1.1555000000E+04, 5.9799308550E+00, 5.7669149041E+00, 3.8134598042E-01, 3.3750493859E-01, 5.8842030263E-01],
	[1.1560000000E+04, 5.9832967277E+00, 5.7664165627E+00, 3.8186318905E-01, 3.3791902974E-01, 5.8858345955E-01],
	[1.1565000000E+04, 5.9866630382E+00, 5.7659184798E+00, 3.8238087389E-01, 3.3833340111E-01, 5.8874658626E-01],
	[1.1570000000E+04, 5.9900297864E+00, 5.7654206552E+00, 3.8289903517E-01, 3.3874805266E-01, 5.8890968274E-01],
	[1.1575000000E+04, 5.9933969721E+00, 5.7649230886E+00, 3.8341767313E-01, 3.3916298434E-01, 5.8907274896E-01],
	[1.1580000000E+04, 5.9967645951E+00, 5.7644257799E+00, 3.8393678798E-01, 3.3957819610E-01, 5.8923578492E-01],
	[1.1585000000E+04, 6.0001326555E+00, 5.7639287287E+00, 3.8445637997E-01, 3.3999368790E-01, 5.8939879057E-01],
	[1.1590000000E+04, 6.0035011529E+00, 5.7634319348E+00, 3.8497644932E-01, 3.4040945968E-01, 5.8956176591E-01],
	[1.1595000000E+04, 6.0068700873E+00, 5.7629353980E+00, 3.8549699626E-01, 3.4082551141E-01, 5.8972471091E-01],
	[1.1600000000E+04, 6.0102394586E+00, 5.7624391180E+00, 3.8601802103E-01, 3.4124184303E-01, 5.8988762554E-01],
	[1.1605000000E+04, 6.0136092666E+00, 5.7619430946E+00, 3.8653952385E-01, 3.4165845450E-01, 5.9005050979E-01],
	[1.1610000000E+04, 6.0169795111E+00, 5.7614473275E+00, 3.8706150496E-01, 3.4207534577E-01, 5.9021336362E-01],
	[1.1615000000E+04, 6.0203501922E+00, 5.7609518165E+00, 3.8758396458E-01, 3.4249251679E-01, 5.9037618703E-01],
	[1.1620000000E+04, 6.0237213096E+00, 5.7604565613E+00, 3.8810690296E-01, 3.4290996751E-01, 5.9053897999E-01],
	[1.1625000000E+04, 6.0270928631E+00, 5.7599615618E+00, 3.8863032031E-01, 3.4332769789E-01, 5.9070174248E-01],
	[1.1630000000E+04, 6.0304648528E+00, 5.7594668176E+00, 3.8915421686E-01, 3.4374570787E-01, 5.9086447447E-01],
	[1.1635000000E+04, 6.0338372783E+00, 5.7589723286E+00, 3.8967859286E-01, 3.4416399741E-01, 5.9102717594E-01],
	[1.1640000000E+04, 6.0372101397E+00, 5.7584780944E+00, 3.9020344853E-01, 3.4458256645E-01, 5.9118984688E-01],
	[1.1645000000E+04, 6.0405834367E+00, 5.7579841149E+00, 3.9072878410E-01, 3.4500141495E-01, 5.9135248725E-01],
	[1.1650000000E+04, 6.0439571693E+00, 5.7574903898E+00, 3.9125459980E-01, 3.4542054286E-01, 5.9151509704E-01],
	[1.1655000000E+04, 6.0473313373E+00, 5.7569969188E+00, 3.9178089586E-01, 3.4583995013E-01, 5.9167767623E-01],
	[1.1660000000E+04, 6.0507116435E+00, 5.7565086936E+00, 3.9230767252E-01, 3.4625967345E-01, 5.9184022480E-01],
	[1.1665000000E+04, 6.0540947457E+00, 5.7560227806E+00, 3.9283493000E-01, 3.4667969137E-01, 5.9200274271E-01],
	[1.1670000000E+04, 6.0574782884E+00, 5.7555371169E+00, 3.9336266853E-01, 3.4709998871E-01, 5.9216522996E-01],
	[1.1675000000E+04, 6.0608622715E+00, 5.7550517022E+00, 3.9389088835E-01, 3.4752056541E-01, 5.9232768652E-01],
	[1.1680000000E+04, 6.0642466950E+00, 5.7545665362E+00, 3.9441958969E-01, 3.4794142142E-01, 5.9249011237E-01],
	[1.1685000000E+04, 6.0676315586E+00, 5.7540816188E+00, 3.9494877277E-01, 3.4836255669E-01, 5.9265250749E-01],
	[1.1690000000E+04, 6.0710168622E+00, 5.7535969496E+00, 3.9547843783E-01, 3.4878397118E-01, 5.9281487186E-01],
	[1.1695000000E+04, 6.0744026058E+00, 5.7531125285E+00, 3.9600858510E-01, 3.4920566482E-01, 5.9297720545E-01],
	[1.1700000000E+04, 6.0777887891E+00, 5.7526283553E+00, 3.9653921481E-01, 3.4962763757E-01, 5.9313950825E-01],
	[1.1705000000E+04, 6.0811754121E+00, 5.7521444296E+00, 3.9707032720E-01, 3.5004988937E-01, 5.9330178023E-01],
	[1.1710000000E+04, 6.0845624746E+00, 5.7516607512E+00, 3.9760192248E-01, 3.5047242018E-01, 5.9346402137E-01],
	[1.1715000000E+04, 6.0879499764E+00, 5.7511773200E+00, 3.9813400089E-01, 3.5089522995E-01, 5.9362623165E-01],
	[1.1720000000E+04, 6.0913379176E+00, 5.7506941357E+00, 3.9866656267E-01, 3.5131831861E-01, 5.9378841106E-01],
	[1.1725000000E+04, 6.0947262978E+00, 5.7502111981E+00, 3.9919960804E-01, 3.5174168612E-01, 5.9395055957E-01],
	[1.1730000000E+04, 6.0981151170E+00, 5.7497285068E+00, 3.9973313724E-01, 3.5216533243E-01, 5.9411267715E-01],
	[1.1735000000E+04, 6.1015043751E+00, 5.7492460618E+00, 4.0026715049E-01, 3.5258925747E-01, 5.9427476380E-01],
	[1.1740000000E+04, 6.1048940720E+00, 5.7487638628E+00, 4.0080164803E-01, 3.5301346121E-01, 5.9443681948E-01],
	[1.1745000000E+04, 6.1082842074E+00, 5.7482819094E+00, 4.0133663009E-01, 3.5343794358E-01, 5.9459884418E-01],
	[1.1750000000E+04, 6.1116747813E+00, 5.7478002016E+00, 4.0187209690E-01, 3.5386270454E-01, 5.9476083787E-01],
	[1.1755000000E+04, 6.1150657935E+00, 5.7473187391E+00, 4.0240804868E-01, 3.5428774402E-01, 5.9492280055E-01],
	[1.1760000000E+04, 6.1184572440E+00, 5.7468375216E+00, 4.0294448568E-01, 3.5471306198E-01, 5.9508473217E-01],
	[1.1765000000E+04, 6.1218491325E+00, 5.7463565490E+00, 4.0348140812E-01, 3.5513865836E-01, 5.9524663274E-01],
	[1.1770000000E+04, 6.1252414590E+00, 5.7458758209E+00, 4.0401881623E-01, 3.5556453311E-01, 5.9540850222E-01],
	[1.1775000000E+04, 6.1286342233E+00, 5.7453953372E+00, 4.0455671025E-01, 3.5599068617E-01, 5.9557034059E-01],
	[1.1780000000E+04, 6.1320274253E+00, 5.7449150977E+00, 4.0509509040E-01, 3.5641711749E-01, 5.9573214784E-01],
	[1.1785000000E+04, 6.1354210649E+00, 5.7444351020E+00, 4.0563395692E-01, 3.5684382700E-01, 5.9589392394E-01],
	[1.1790000000E+04, 6.1388151419E+00, 5.7439553500E+00, 4.0617331003E-01, 3.5727081467E-01, 5.9605566888E-01],
	[1.1795000000E+04, 6.1422096562E+00, 5.7434758415E+00, 4.0671314997E-01, 3.5769808042E-01, 5.9621738263E-01],
	[1.1800000000E+04, 6.1456046077E+00, 5.7429965763E+00, 4.0725347697E-01, 3.5812562421E-01, 5.9637906517E-01],
	[1.1805000000E+04, 6.1489999962E+00, 5.7425175540E+00, 4.0779429126E-01, 3.5855344599E-01, 5.9654071649E-01],
	[1.1810000000E+04, 6.1523958217E+00, 5.7420387745E+00, 4.0833559307E-01, 3.5898154568E-01, 5.9670233656E-01],
	[1.1815000000E+04, 6.1557920839E+00, 5.7415602375E+00, 4.0887738264E-01, 3.5940992324E-01, 5.9686392537E-01],
	[1.1820000000E+04, 6.1591887828E+00, 5.7410819429E+00, 4.0941966019E-01, 3.5983857862E-01, 5.9702548289E-01],
	[1.1825000000E+04, 6.1625859182E+00, 5.7406038904E+00, 4.0996242595E-01, 3.6026751174E-01, 5.9718700910E-01],
	[1.1830000000E+04, 6.1659834901E+00, 5.7401260797E+00, 4.1050568016E-01, 3.6069672257E-01, 5.9734850399E-01],
	[1.1835000000E+04, 6.1693814982E+00, 5.7396485107E+00, 4.1104942304E-01, 3.6112621103E-01, 5.9750996753E-01],
	[1.1840000000E+04, 6.1727799424E+00, 5.7391711831E+00, 4.1159365483E-01, 3.6155597708E-01, 5.9767139971E-01],
	[1.1845000000E+04, 6.1761803119E+00, 5.7386953193E+00, 4.1213837576E-01, 3.6198603064E-01, 5.9783280050E-01],
	[1.1850000000E+04, 6.1795880441E+00, 5.7382253781E+00, 4.1268358606E-01, 3.6241640818E-01, 5.9799416989E-01],
	[1.1855000000E+04, 6.1829962178E+00, 5.7377556736E+00, 4.1322928597E-01, 3.6284706336E-01, 5.9815550786E-01],
	[1.1860000000E+04, 6.1864048328E+00, 5.7372862056E+00, 4.1377547570E-01, 3.6327799610E-01, 5.9831681438E-01],
	[1.1865000000E+04, 6.1898138891E+00, 5.7368169739E+00, 4.1432215550E-01, 3.6370920635E-01, 5.9847808944E-01],
	[1.1870000000E+04, 6.1932233864E+00, 5.7363479782E+00, 4.1486932560E-01, 3.6414069406E-01, 5.9863933302E-01],
	[1.1875000000E+04, 6.1966333247E+00, 5.7358792183E+00, 4.1541698622E-01, 3.6457245916E-01, 5.9880054510E-01],
	[1.1880000000E+04, 6.2000437039E+00, 5.7354106940E+00, 4.1596513759E-01, 3.6500450160E-01, 5.9896172566E-01],
	[1.1885000000E+04, 6.2034545237E+00, 5.7349424052E+00, 4.1651377996E-01, 3.6543682131E-01, 5.9912287467E-01],
	[1.1890000000E+04, 6.2068657842E+00, 5.7344743515E+00, 4.1706291355E-01, 3.6586941825E-01, 5.9928399213E-01],
	[1.1895000000E+04, 6.2102774851E+00, 5.7340065328E+00, 4.1761253858E-01, 3.6630229234E-01, 5.9944507801E-01],
	[1.1900000000E+04, 6.2136896263E+00, 5.7335389488E+00, 4.1816265530E-01, 3.6673544353E-01, 5.9960613230E-01],
	[1.1905000000E+04, 6.2171022077E+00, 5.7330715993E+00, 4.1871326393E-01, 3.6716887176E-01, 5.9976715496E-01],
	[1.1910000000E+04, 6.2205152292E+00, 5.7326044842E+00, 4.1926436471E-01, 3.6760257697E-01, 5.9992814600E-01],
	[1.1915000000E+04, 6.2239286906E+00, 5.7321376032E+00, 4.1981595787E-01, 3.6803655909E-01, 6.0008910537E-01],
	[1.1920000000E+04, 6.2273425918E+00, 5.7316709560E+00, 4.2036804363E-01, 3.6847081808E-01, 6.0025003308E-01],
	[1.1925000000E+04, 6.2307569327E+00, 5.7312045425E+00, 4.2092062223E-01, 3.6890535387E-01, 6.0041092909E-01],
	[1.1930000000E+04, 6.2341717132E+00, 5.7307383625E+00, 4.2147369390E-01, 3.6934016639E-01, 6.0057179340E-01],
	[1.1935000000E+04, 6.2375869331E+00, 5.7302724156E+00, 4.2202725887E-01, 3.6977525559E-01, 6.0073262597E-01],
	[1.1940000000E+04, 6.2410025923E+00, 5.7298067019E+00, 4.2258131737E-01, 3.7021062141E-01, 6.0089342680E-01],
	[1.1945000000E+04, 6.2444186907E+00, 5.7293412209E+00, 4.2313586964E-01, 3.7064626378E-01, 6.0105419586E-01],
	[1.1950000000E+04, 6.2478352281E+00, 5.7288759725E+00, 4.2369091591E-01, 3.7108218264E-01, 6.0121493313E-01],
	[1.1955000000E+04, 6.2512522044E+00, 5.7284109565E+00, 4.2424645640E-01, 3.7151837794E-01, 6.0137563860E-01],
	[1.1960000000E+04, 6.2546696195E+00, 5.7279461726E+00, 4.2480249135E-01, 3.7195484960E-01, 6.0153631225E-01],
	[1.1965000000E+04, 6.2580874733E+00, 5.7274816208E+00, 4.2535902098E-01, 3.7239159757E-01, 6.0169695406E-01],
	[1.1970000000E+04, 6.2615057657E+00, 5.7270173006E+00, 4.2591604554E-01, 3.7282862178E-01, 6.0185756401E-01],
	[1.1975000000E+04, 6.2649244964E+00, 5.7265532120E+00, 4.2647356526E-01, 3.7326592218E-01, 6.0201814208E-01],
	[1.1980000000E+04, 6.2683436654E+00, 5.7260893547E+00, 4.2703158035E-01, 3.7370349869E-01, 6.0217868826E-01],
	[1.1985000000E+04, 6.2717632726E+00, 5.7256257285E+00, 4.2759009106E-01, 3.7414135126E-01, 6.0233920252E-01],
	[1.1990000000E+04, 6.2751833178E+00, 5.7251623332E+00, 4.2814909762E-01, 3.7457947982E-01, 6.0249968485E-01],
	[1.1995000000E+04, 6.2786038009E+00, 5.7246991686E+00, 4.2870860025E-01, 3.7501788431E-01, 6.0266013523E-01],
	[1.2000000000E+04, 6.2820247218E+00, 5.7242362345E+00, 4.2926859920E-01, 3.7545656466E-01, 6.0282055365E-01],
	[1.2005000000E+04, 6.2854460803E+00, 5.7237735306E+00, 4.2982909469E-01, 3.7589552082E-01, 6.0298094007E-01],
	[1.2010000000E+04, 6.2888678764E+00, 5.7233110568E+00, 4.3039008694E-01, 3.7633475271E-01, 6.0314129449E-01],
	[1.2015000000E+04, 6.2922901098E+00, 5.7228488128E+00, 4.3095157621E-01, 3.7677426027E-01, 6.0330161689E-01],
	[1.2020000000E+04, 6.2957127806E+00, 5.7223867984E+00, 4.3151356271E-01, 3.7721404344E-01, 6.0346190725E-01],
	[1.2025000000E+04, 6.2991358884E+00, 5.7219250135E+00, 4.3207604667E-01, 3.7765410216E-01, 6.0362216555E-01],
	[1.2030000000E+04, 6.3025594333E+00, 5.7214634577E+00, 4.3263902833E-01, 3.7809443635E-01, 6.0378239177E-01],
	[1.2035000000E+04, 6.3059837852E+00, 5.7210024163E+00, 4.3320250793E-01, 3.7853504854E-01, 6.0394258590E-01],
	[1.2040000000E+04, 6.3094169779E+00, 5.7205480780E+00, 4.3376648568E-01, 3.7897599481E-01, 6.0410274792E-01],
	[1.2045000000E+04, 6.3128506132E+00, 5.7200939644E+00, 4.3433096183E-01, 3.7941721661E-01, 6.0426287781E-01],
	[1.2050000000E+04, 6.3162846909E+00, 5.7196400753E+00, 4.3489593660E-01, 3.7985871384E-01, 6.0442297556E-01],
	[1.2055000000E+04, 6.3197192109E+00, 5.7191864105E+00, 4.3546141023E-01, 3.8030048646E-01, 6.0458304114E-01],
	[1.2060000000E+04, 6.3231541730E+00, 5.7187329698E+00, 4.3602738295E-01, 3.8074253440E-01, 6.0474307453E-01],
	[1.2065000000E+04, 6.3265895772E+00, 5.7182797529E+00, 4.3659385499E-01, 3.8118485758E-01, 6.0490307573E-01],
	[1.2070000000E+04, 6.3300254232E+00, 5.7178267598E+00, 4.3716082657E-01, 3.8162745595E-01, 6.0506304471E-01],
	[1.2075000000E+04, 6.3334617110E+00, 5.7173739901E+00, 4.3772829794E-01, 3.8207032943E-01, 6.0522298146E-01],
	[1.2080000000E+04, 6.3368984405E+00, 5.7169214437E+00, 4.3829626933E-01, 3.8251347797E-01, 6.0538288594E-01],
	[1.2085000000E+04, 6.3403356115E+00, 5.7164691203E+00, 4.3886474096E-01, 3.8295690148E-01, 6.0554275814E-01],
	[1.2090000000E+04, 6.3437732239E+00, 5.7160170199E+00, 4.3943371306E-01, 3.8340059991E-01, 6.0570259803E-01],
	[1.2095000000E+04, 6.3472112776E+00, 5.7155651421E+00, 4.4000318588E-01, 3.8384457320E-01, 6.0586240557E-01],
	[1.2100000000E+04, 6.3506497724E+00, 5.7151134867E+00, 4.4057315964E-01, 3.8428882126E-01, 6.0602218076E-01],
	[1.2105000000E+04, 6.3540887083E+00, 5.7146620536E+00, 4.4114363456E-01, 3.8473334403E-01, 6.0618192356E-01],
	[1.2110000000E+04, 6.3575280850E+00, 5.7142108426E+00, 4.4171461090E-01, 3.8517814145E-01, 6.0634163395E-01],
	[1.2115000000E+04, 6.3609679025E+00, 5.7137598535E+00, 4.4228608887E-01, 3.8562321345E-01, 6.0650131190E-01],
	[1.2120000000E+04, 6.3644081607E+00, 5.7133090860E+00, 4.4285806870E-01, 3.8606855996E-01, 6.0666095741E-01],
	[1.2125000000E+04, 6.3678488593E+00, 5.7128585400E+00, 4.4343055064E-01, 3.8651418091E-01, 6.0682057043E-01],
	[1.2130000000E+04, 6.3712899984E+00, 5.7124082152E+00, 4.4400353490E-01, 3.8696007623E-01, 6.0698015095E-01],
	[1.2135000000E+04, 6.3747315777E+00, 5.7119581115E+00, 4.4457702173E-01, 3.8740624585E-01, 6.0713969894E-01],
	[1.2140000000E+04, 6.3781735972E+00, 5.7115082287E+00, 4.4515101135E-01, 3.8785268971E-01, 6.0729921439E-01],
	[1.2145000000E+04, 6.3816160567E+00, 5.7110585665E+00, 4.4572550400E-01, 3.8829940773E-01, 6.0745869726E-01],
	[1.2150000000E+04, 6.3850589561E+00, 5.7106091248E+00, 4.4630049991E-01, 3.8874639984E-01, 6.0761814754E-01],
	[1.2155000000E+04, 6.3885022952E+00, 5.7101599033E+00, 4.4687599930E-01, 3.8919366598E-01, 6.0777756520E-01],
	[1.2160000000E+04, 6.3919460740E+00, 5.7097109020E+00, 4.4745200242E-01, 3.8964120607E-01, 6.0793695022E-01],
	[1.2165000000E+04, 6.3953902923E+00, 5.7092621205E+00, 4.4802850949E-01, 3.9008902005E-01, 6.0809630258E-01],
	[1.2170000000E+04, 6.3988349500E+00, 5.7088135586E+00, 4.4860552075E-01, 3.9053710784E-01, 6.0825562225E-01],
	[1.2175000000E+04, 6.4022800470E+00, 5.7083652162E+00, 4.4918303642E-01, 3.9098546938E-01, 6.0841490921E-01],
	[1.2180000000E+04, 6.4057255831E+00, 5.7079170931E+00, 4.4976105674E-01, 3.9143410459E-01, 6.0857416344E-01],
	[1.2185000000E+04, 6.4091715582E+00, 5.7074691891E+00, 4.5033958194E-01, 3.9188301340E-01, 6.0873338491E-01],
	[1.2190000000E+04, 6.4126179723E+00, 5.7070215040E+00, 4.5091861225E-01, 3.9233219574E-01, 6.0889257361E-01],
	[1.2195000000E+04, 6.4160648251E+00, 5.7065740375E+00, 4.5149814790E-01, 3.9278165154E-01, 6.0905172950E-01],
	[1.2200000000E+04, 6.4195121165E+00, 5.7061267896E+00, 4.5207818914E-01, 3.9323138072E-01, 6.0921085257E-01],
	[1.2205000000E+04, 6.4229598465E+00, 5.7056797599E+00, 4.5265873617E-01, 3.9368138323E-01, 6.0936994280E-01],
	[1.2210000000E+04, 6.4264080149E+00, 5.7052329483E+00, 4.5323978925E-01, 3.9413165897E-01, 6.0952900016E-01],
	[1.2215000000E+04, 6.4298566216E+00, 5.7047863547E+00, 4.5382134860E-01, 3.9458220788E-01, 6.0968802463E-01],
	[1.2220000000E+04, 6.4333056664E+00, 5.7043399787E+00, 4.5440341445E-01, 3.9503302990E-01, 6.0984701618E-01],
	[1.2225000000E+04, 6.4367551492E+00, 5.7038938202E+00, 4.5498598704E-01, 3.9548412493E-01, 6.1000597481E-01],
	[1.2230000000E+04, 6.4402077505E+00, 5.7034498215E+00, 4.5556906660E-01, 3.9593551242E-01, 6.1016490047E-01],
	[1.2235000000E+04, 6.4436672475E+00, 5.7030107144E+00, 4.5615265335E-01, 3.9638721987E-01, 6.1032379315E-01],
	[1.2240000000E+04, 6.4471271882E+00, 5.7025718205E+00, 4.5673674753E-01, 3.9683920037E-01, 6.1048265284E-01],
	[1.2245000000E+04, 6.4505875725E+00, 5.7021331396E+00, 4.5732134938E-01, 3.9729145385E-01, 6.1064147950E-01],
	[1.2250000000E+04, 6.4540484003E+00, 5.7016946715E+00, 4.5790645912E-01, 3.9774398023E-01, 6.1080027312E-01],
	[1.2255000000E+04, 6.4575096714E+00, 5.7012564160E+00, 4.5849207699E-01, 3.9819677945E-01, 6.1095903366E-01],
	[1.2260000000E+04, 6.4609713858E+00, 5.7008183730E+00, 4.5907820322E-01, 3.9864985142E-01, 6.1111776112E-01],
	[1.2265000000E+04, 6.4644335433E+00, 5.7003805422E+00, 4.5966483803E-01, 3.9910319607E-01, 6.1127645547E-01],
	[1.2270000000E+04, 6.4678961437E+00, 5.6999429234E+00, 4.6025198167E-01, 3.9955681333E-01, 6.1143511668E-01],
	[1.2275000000E+04, 6.4713591870E+00, 5.6995055166E+00, 4.6083963437E-01, 4.0001070313E-01, 6.1159374474E-01],
	[1.2280000000E+04, 6.4748226730E+00, 5.6990683214E+00, 4.6142779635E-01, 4.0046486538E-01, 6.1175233963E-01],
	[1.2285000000E+04, 6.4782866017E+00, 5.6986313377E+00, 4.6201646784E-01, 4.0091930002E-01, 6.1191090131E-01],
	[1.2290000000E+04, 6.4817509728E+00, 5.6981945653E+00, 4.6260564909E-01, 4.0137400697E-01, 6.1206942978E-01],
	[1.2295000000E+04, 6.4852157863E+00, 5.6977580040E+00, 4.6319534033E-01, 4.0182898615E-01, 6.1222792500E-01],
	[1.2300000000E+04, 6.4886810420E+00, 5.6973216537E+00, 4.6378554177E-01, 4.0228423750E-01, 6.1238638696E-01],
	[1.2305000000E+04, 6.4921467398E+00, 5.6968855141E+00, 4.6437625366E-01, 4.0273976092E-01, 6.1254481564E-01],
	[1.2310000000E+04, 6.4956128796E+00, 5.6964495850E+00, 4.6496747623E-01, 4.0319555636E-01, 6.1270321101E-01],
	[1.2315000000E+04, 6.4990794613E+00, 5.6960138663E+00, 4.6555920972E-01, 4.0365162372E-01, 6.1286157306E-01],
	[1.2320000000E+04, 6.5025464847E+00, 5.6955783578E+00, 4.6615145434E-01, 4.0410796295E-01, 6.1301990175E-01],
	[1.2325000000E+04, 6.5060139498E+00, 5.6951430592E+00, 4.6674421034E-01, 4.0456457395E-01, 6.1317819708E-01],
	[1.2330000000E+04, 6.5094818563E+00, 5.6947079705E+00, 4.6733747795E-01, 4.0502145665E-01, 6.1333645902E-01],
	[1.2335000000E+04, 6.5129502042E+00, 5.6942730914E+00, 4.6793125739E-01, 4.0547861098E-01, 6.1349468754E-01],
	[1.2340000000E+04, 6.5164189934E+00, 5.6938384217E+00, 4.6852554891E-01, 4.0593603686E-01, 6.1365288263E-01],
	[1.2345000000E+04, 6.5198882237E+00, 5.6934039613E+00, 4.6912035273E-01, 4.0639373421E-01, 6.1381104427E-01],
	[1.2350000000E+04, 6.5233578950E+00, 5.6929697099E+00, 4.6971566908E-01, 4.0685170295E-01, 6.1396917243E-01],
	[1.2355000000E+04, 6.5268280072E+00, 5.6925356674E+00, 4.7031149820E-01, 4.0730994301E-01, 6.1412726709E-01],
	[1.2360000000E+04, 6.5302985601E+00, 5.6921018336E+00, 4.7090784033E-01, 4.0776845431E-01, 6.1428532824E-01],
	[1.2365000000E+04, 6.5337695537E+00, 5.6916682083E+00, 4.7150469568E-01, 4.0822723677E-01, 6.1444335586E-01],
	[1.2370000000E+04, 6.5372409878E+00, 5.6912347914E+00, 4.7210206450E-01, 4.0868629031E-01, 6.1460134991E-01],
	[1.2375000000E+04, 6.5407128623E+00, 5.6908015825E+00, 4.7269994701E-01, 4.0914561486E-01, 6.1475931038E-01],
	[1.2380000000E+04, 6.5441851771E+00, 5.6903685816E+00, 4.7329834345E-01, 4.0960521033E-01, 6.1491723725E-01],
	[1.2385000000E+04, 6.5476579320E+00, 5.6899357885E+00, 4.7389725405E-01, 4.1006507664E-01, 6.1507513051E-01],
	[1.2390000000E+04, 6.5511311270E+00, 5.6895032030E+00, 4.7449667905E-01, 4.1052521372E-01, 6.1523299012E-01],
	[1.2395000000E+04, 6.5546047618E+00, 5.6890708249E+00, 4.7509661867E-01, 4.1098562150E-01, 6.1539081607E-01],
	[1.2400000000E+04, 6.5580788364E+00, 5.6886386540E+00, 4.7569707314E-01, 4.1144629987E-01, 6.1554860834E-01],
	[1.2405000000E+04, 6.5615533508E+00, 5.6882066901E+00, 4.7629804271E-01, 4.1190724878E-01, 6.1570636690E-01],
	[1.2410000000E+04, 6.5650283046E+00, 5.6877749331E+00, 4.7689952760E-01, 4.1236846814E-01, 6.1586409174E-01],
	[1.2415000000E+04, 6.5685036979E+00, 5.6873433828E+00, 4.7750152804E-01, 4.1282995786E-01, 6.1602178284E-01],
	[1.2420000000E+04, 6.5719795304E+00, 5.6869120389E+00, 4.7810404427E-01, 4.1329171788E-01, 6.1617944018E-01],
	[1.2425000000E+04, 6.5754558022E+00, 5.6864809014E+00, 4.7870707651E-01, 4.1375374810E-01, 6.1633706373E-01],
	[1.2430000000E+04, 6.5789412696E+00, 5.6860559396E+00, 4.7931062501E-01, 4.1421611483E-01, 6.1649465348E-01],
	[1.2435000000E+04, 6.5824279342E+00, 5.6856316930E+00, 4.7991468999E-01, 4.1467875757E-01, 6.1665220940E-01],
	[1.2440000000E+04, 6.5859150437E+00, 5.6852076486E+00, 4.8051927168E-01, 4.1514167053E-01, 6.1680973148E-01],
	[1.2445000000E+04, 6.5894025982E+00, 5.6847838062E+00, 4.8112437033E-01, 4.1560485363E-01, 6.1696721969E-01],
	[1.2450000000E+04, 6.5928905975E+00, 5.6843601657E+00, 4.8172998615E-01, 4.1606830679E-01, 6.1712467402E-01],
	[1.2455000000E+04, 6.5963790415E+00, 5.6839367268E+00, 4.8233611938E-01, 4.1653202993E-01, 6.1728209444E-01],
	[1.2460000000E+04, 6.5998679301E+00, 5.6835134893E+00, 4.8294277026E-01, 4.1699602298E-01, 6.1743948094E-01],
	[1.2465000000E+04, 6.6033572631E+00, 5.6830904532E+00, 4.8354993902E-01, 4.1746028584E-01, 6.1759683350E-01],
	[1.2470000000E+04, 6.6068470404E+00, 5.6826676182E+00, 4.8415762588E-01, 4.1792481843E-01, 6.1775415209E-01],
	[1.2475000000E+04, 6.6103372619E+00, 5.6822449842E+00, 4.8476583109E-01, 4.1838962068E-01, 6.1791143670E-01],
	[1.2480000000E+04, 6.6138279275E+00, 5.6818225509E+00, 4.8537455487E-01, 4.1885469250E-01, 6.1806868731E-01],
	[1.2485000000E+04, 6.6173190370E+00, 5.6814003182E+00, 4.8598379745E-01, 4.1932003381E-01, 6.1822590389E-01],
	[1.2490000000E+04, 6.6208105904E+00, 5.6809782860E+00, 4.8659355908E-01, 4.1978564452E-01, 6.1838308643E-01],
	[1.2495000000E+04, 6.6243025875E+00, 5.6805564539E+00, 4.8720383997E-01, 4.2025152456E-01, 6.1854023491E-01],
	[1.2500000000E+04, 6.6277950282E+00, 5.6801348220E+00, 4.8781464037E-01, 4.2071767383E-01, 6.1869734931E-01],
	[1.2505000000E+04, 6.6312879124E+00, 5.6797133899E+00, 4.8842766376E-01, 4.2118535882E-01, 6.1885442960E-01],
	[1.2510000000E+04, 6.6347812399E+00, 5.6792921576E+00, 4.8904121070E-01, 4.2165331482E-01, 6.1901147578E-01],
	[1.2515000000E+04, 6.6382750106E+00, 5.6788711248E+00, 4.8965528143E-01, 4.2212154174E-01, 6.1916848781E-01],
	[1.2520000000E+04, 6.6417692244E+00, 5.6784502914E+00, 4.9026987618E-01, 4.2259003949E-01, 6.1932546569E-01],
	[1.2525000000E+04, 6.6452638813E+00, 5.6780296572E+00, 4.9088499519E-01, 4.2305880799E-01, 6.1948240938E-01],
	[1.2530000000E+04, 6.6487589810E+00, 5.6776092220E+00, 4.9150063870E-01, 4.2352784716E-01, 6.1963931888E-01],
	[1.2535000000E+04, 6.6522545234E+00, 5.6771889857E+00, 4.9211680693E-01, 4.2399715691E-01, 6.1979619417E-01],
	[1.2540000000E+04, 6.6557505085E+00, 5.6767689480E+00, 4.9273350014E-01, 4.2446673717E-01, 6.1995303521E-01],
	[1.2545000000E+04, 6.6592469360E+00, 5.6763491089E+00, 4.9335071854E-01, 4.2493658783E-01, 6.2010984200E-01],
	[1.2550000000E+04, 6.6627438060E+00, 5.6759294680E+00, 4.9396846239E-01, 4.2540670882E-01, 6.2026661452E-01],
	[1.2555000000E+04, 6.6662411182E+00, 5.6755100254E+00, 4.9458673191E-01, 4.2587710005E-01, 6.2042335275E-01],
	[1.2560000000E+04, 6.6697388726E+00, 5.6750907807E+00, 4.9520552734E-01, 4.2634776144E-01, 6.2058005666E-01],
	[1.2565000000E+04, 6.6732370690E+00, 5.6746717338E+00, 4.9582484891E-01, 4.2681869290E-01, 6.2073672624E-01],
	[1.2570000000E+04, 6.6767357072E+00, 5.6742528846E+00, 4.9644469687E-01, 4.2728989435E-01, 6.2089336147E-01],
	[1.2575000000E+04, 6.6802347873E+00, 5.6738342328E+00, 4.9706507145E-01, 4.2776136569E-01, 6.2104996234E-01],
	[1.2580000000E+04, 6.6837343090E+00, 5.6734157784E+00, 4.9768597289E-01, 4.2823310684E-01, 6.2120652882E-01],
	[1.2585000000E+04, 6.6872342723E+00, 5.6729975211E+00, 4.9830740141E-01, 4.2870511772E-01, 6.2136306089E-01],
	[1.2590000000E+04, 6.6907346770E+00, 5.6725794607E+00, 4.9892935726E-01, 4.2917739824E-01, 6.2151955853E-01],
	[1.2595000000E+04, 6.6942355230E+00, 5.6721615971E+00, 4.9955184067E-01, 4.2964994831E-01, 6.2167602174E-01],
	[1.2600000000E+04, 6.6977368102E+00, 5.6717439301E+00, 5.0017485188E-01, 4.3012276784E-01, 6.2183245048E-01],
	[1.2605000000E+04, 6.7012385385E+00, 5.6713264596E+00, 5.0079839113E-01, 4.3059585675E-01, 6.2198884474E-01],
	[1.2610000000E+04, 6.7047407077E+00, 5.6709091854E+00, 5.0142245864E-01, 4.3106921495E-01, 6.2214520451E-01],
	[1.2615000000E+04, 6.7082433177E+00, 5.6704921072E+00, 5.0204705467E-01, 4.3154284234E-01, 6.2230152976E-01],
	[1.2620000000E+04, 6.7117463684E+00, 5.6700752250E+00, 5.0267217943E-01, 4.3201673885E-01, 6.2245782054E-01],
	[1.2625000000E+04, 6.7152498597E+00, 5.6696585386E+00, 5.0329783318E-01, 4.3249090439E-01, 6.2261407685E-01],
	[1.2630000000E+04, 6.7187629027E+00, 5.6692478878E+00, 5.0392401614E-01, 4.3296541076E-01, 6.2277029865E-01],
	[1.2635000000E+04, 6.7222772439E+00, 5.6688379751E+00, 5.0455072855E-01, 4.3344019296E-01, 6.2292648592E-01],
	[1.2640000000E+04, 6.7257920318E+00, 5.6684282542E+00, 5.0517797065E-01, 4.3391524419E-01, 6.2308263864E-01],
	[1.2645000000E+04, 6.7293072663E+00, 5.6680187249E+00, 5.0580574267E-01, 4.3439056437E-01, 6.2323875679E-01],
	[1.2650000000E+04, 6.7328229472E+00, 5.6676093871E+00, 5.0643404485E-01, 4.3486615341E-01, 6.2339484033E-01],
	[1.2655000000E+04, 6.7363390744E+00, 5.6672002406E+00, 5.0706287743E-01, 4.3534201121E-01, 6.2355088924E-01],
	[1.2660000000E+04, 6.7398556479E+00, 5.6667912853E+00, 5.0769224064E-01, 4.3581813769E-01, 6.2370690350E-01],
	[1.2665000000E+04, 6.7433726674E+00, 5.6663825209E+00, 5.0832213472E-01, 4.3629453277E-01, 6.2386288309E-01],
	[1.2670000000E+04, 6.7468901330E+00, 5.6659739473E+00, 5.0895255990E-01, 4.3677119634E-01, 6.2401882797E-01],
	[1.2675000000E+04, 6.7504080443E+00, 5.6655655644E+00, 5.0958351642E-01, 4.3724812832E-01, 6.2417473813E-01],
	[1.2680000000E+04, 6.7539264014E+00, 5.6651573719E+00, 5.1021500452E-01, 4.3772532862E-01, 6.2433061354E-01],
	[1.2685000000E+04, 6.7574452042E+00, 5.6647493698E+00, 5.1084702443E-01, 4.3820279715E-01, 6.2448645417E-01],
	[1.2690000000E+04, 6.7609644524E+00, 5.6643415579E+00, 5.1147957639E-01, 4.3868053382E-01, 6.2464226001E-01],
	[1.2695000000E+04, 6.7644841460E+00, 5.6639339359E+00, 5.1211266064E-01, 4.3915853854E-01, 6.2479803102E-01],
	[1.2700000000E+04, 6.7680042849E+00, 5.6635265038E+00, 5.1274627740E-01, 4.3963681122E-01, 6.2495376719E-01],
	[1.2705000000E+04, 6.7715248689E+00, 5.6631192613E+00, 5.1338042693E-01, 4.4011535176E-01, 6.2510946848E-01],
	[1.2710000000E+04, 6.7750458979E+00, 5.6627122083E+00, 5.1401510944E-01, 4.4059416008E-01, 6.2526513488E-01],
	[1.2715000000E+04, 6.7785673718E+00, 5.6623053447E+00, 5.1465032519E-01, 4.4107323608E-01, 6.2542076636E-01],
	[1.2720000000E+04, 6.7820892905E+00, 5.6618986702E+00, 5.1528607441E-01, 4.4155257967E-01, 6.2557636290E-01],
	[1.2725000000E+04, 6.7856116539E+00, 5.6614921848E+00, 5.1592235733E-01, 4.4203219076E-01, 6.2573192447E-01],
	[1.2730000000E+04, 6.7891344618E+00, 5.6610858882E+00, 5.1655917418E-01, 4.4251206926E-01, 6.2588745105E-01],
	[1.2735000000E+04, 6.7926577141E+00, 5.6606797803E+00, 5.1719652521E-01, 4.4299221508E-01, 6.2604294261E-01],
	[1.2740000000E+04, 6.7961814107E+00, 5.6602738609E+00, 5.1783441066E-01, 4.4347262812E-01, 6.2619839914E-01],
	[1.2745000000E+04, 6.7997055516E+00, 5.6598681299E+00, 5.1847283075E-01, 4.4395330829E-01, 6.2635382060E-01],
	[1.2750000000E+04, 6.8032301365E+00, 5.6594625872E+00, 5.1911178573E-01, 4.4443425550E-01, 6.2650920697E-01],
	[1.2755000000E+04, 6.8067551653E+00, 5.6590572324E+00, 5.1975127582E-01, 4.4491546966E-01, 6.2666455824E-01],
	[1.2760000000E+04, 6.8102806380E+00, 5.6586520656E+00, 5.2039130128E-01, 4.4539695066E-01, 6.2681987438E-01],
	[1.2765000000E+04, 6.8138065544E+00, 5.6582470864E+00, 5.2103186232E-01, 4.4587869842E-01, 6.2697515535E-01],
	[1.2770000000E+04, 6.8173329144E+00, 5.6578422949E+00, 5.2167295920E-01, 4.4636071285E-01, 6.2713040115E-01],
	[1.2775000000E+04, 6.8208597179E+00, 5.6574376907E+00, 5.2231459214E-01, 4.4684299385E-01, 6.2728561174E-01],
	[1.2780000000E+04, 6.8243869648E+00, 5.6570332738E+00, 5.2295676139E-01, 4.4732554132E-01, 6.2744078711E-01],
	[1.2785000000E+04, 6.8279146549E+00, 5.6566290439E+00, 5.2359946717E-01, 4.4780835518E-01, 6.2759592723E-01],
	[1.2790000000E+04, 6.8314427881E+00, 5.6562250010E+00, 5.2424270973E-01, 4.4829143532E-01, 6.2775103207E-01],
	[1.2795000000E+04, 6.8349713643E+00, 5.6558211449E+00, 5.2488648930E-01, 4.4877478166E-01, 6.2790610162E-01],
	[1.2800000000E+04, 6.8385003835E+00, 5.6554174753E+00, 5.2553080612E-01, 4.4925839410E-01, 6.2806113584E-01],
	[1.2805000000E+04, 6.8420298454E+00, 5.6550139922E+00, 5.2617566043E-01, 4.4974227254E-01, 6.2821613473E-01],
	[1.2810000000E+04, 6.8455597499E+00, 5.6546106954E+00, 5.2682105245E-01, 4.5022641688E-01, 6.2837109825E-01],
	[1.2815000000E+04, 6.8490900970E+00, 5.6542075848E+00, 5.2746698244E-01, 4.5071082704E-01, 6.2852602638E-01],
	[1.2820000000E+04, 6.8526208865E+00, 5.6538046601E+00, 5.2811345062E-01, 4.5119550291E-01, 6.2868091910E-01],
	[1.2825000000E+04, 6.8561521184E+00, 5.6534019212E+00, 5.2876045722E-01, 4.5168044441E-01, 6.2883577638E-01],
	[1.2830000000E+04, 6.8596865588E+00, 5.6530010364E+00, 5.2940800250E-01, 4.5216567412E-01, 6.2899059821E-01],
	[1.2835000000E+04, 6.8632291552E+00, 5.6526049847E+00, 5.3005608668E-01, 4.5265123270E-01, 6.2914538456E-01],
	[1.2840000000E+04, 6.8667722002E+00, 5.6522091150E+00, 5.3070471000E-01, 4.5313705690E-01, 6.2930013540E-01],
	[1.2845000000E+04, 6.8703156938E+00, 5.6518134272E+00, 5.3135387269E-01, 4.5362314664E-01, 6.2945485072E-01],
	[1.2850000000E+04, 6.8738596358E+00, 5.6514179210E+00, 5.3200357500E-01, 4.5410950180E-01, 6.2960953049E-01],
	[1.2855000000E+04, 6.8774040262E+00, 5.6510225963E+00, 5.3265381716E-01, 4.5459612231E-01, 6.2976417469E-01],
	[1.2860000000E+04, 6.8809488647E+00, 5.6506274531E+00, 5.3330459940E-01, 4.5508300806E-01, 6.2991878330E-01],
	[1.2865000000E+04, 6.8844941514E+00, 5.6502324910E+00, 5.3395592197E-01, 4.5557015895E-01, 6.3007335630E-01],
	[1.2870000000E+04, 6.8880398860E+00, 5.6498377100E+00, 5.3460778510E-01, 4.5605757488E-01, 6.3022789365E-01],
	[1.2875000000E+04, 6.8915860684E+00, 5.6494431099E+00, 5.3526018902E-01, 4.5654525577E-01, 6.3038239535E-01],
	[1.2880000000E+04, 6.8951326986E+00, 5.6490486906E+00, 5.3591313398E-01, 4.5703320151E-01, 6.3053686136E-01],
	[1.2885000000E+04, 6.8986797764E+00, 5.6486544518E+00, 5.3656662020E-01, 4.5752141200E-01, 6.3069129168E-01],
	[1.2890000000E+04, 6.9022273017E+00, 5.6482603935E+00, 5.3722064793E-01, 4.5800988715E-01, 6.3084568626E-01],
	[1.2895000000E+04, 6.9057752744E+00, 5.6478665156E+00, 5.3787521740E-01, 4.5849862686E-01, 6.3100004509E-01],
	[1.2900000000E+04, 6.9093236943E+00, 5.6474728177E+00, 5.3853032886E-01, 4.5898763103E-01, 6.3115436816E-01],
	[1.2905000000E+04, 6.9128725614E+00, 5.6470792999E+00, 5.3918598252E-01, 4.5947689956E-01, 6.3130865543E-01],
	[1.2910000000E+04, 6.9164218756E+00, 5.6466859619E+00, 5.3984217864E-01, 4.5996643235E-01, 6.3146290689E-01],
	[1.2915000000E+04, 6.9199716366E+00, 5.6462928036E+00, 5.4049891745E-01, 4.6045622931E-01, 6.3161712251E-01],
	[1.2920000000E+04, 6.9235218444E+00, 5.6458998248E+00, 5.4115619919E-01, 4.6094629033E-01, 6.3177130228E-01],
	[1.2925000000E+04, 6.9270724990E+00, 5.6455070254E+00, 5.4181402408E-01, 4.6143661531E-01, 6.3192544616E-01],
	[1.2930000000E+04, 6.9306236001E+00, 5.6451144053E+00, 5.4247239238E-01, 4.6192720417E-01, 6.3207955414E-01],
	[1.2935000000E+04, 6.9341751476E+00, 5.6447219642E+00, 5.4313130431E-01, 4.6241805678E-01, 6.3223362620E-01],
	[1.2940000000E+04, 6.9377271414E+00, 5.6443297021E+00, 5.4379076012E-01, 4.6290917307E-01, 6.3238766231E-01],
	[1.2945000000E+04, 6.9412795815E+00, 5.6439376187E+00, 5.4445076003E-01, 4.6340055292E-01, 6.3254166246E-01],
	[1.2950000000E+04, 6.9448324677E+00, 5.6435457140E+00, 5.4511130429E-01, 4.6389219624E-01, 6.3269562662E-01],
	[1.2955000000E+04, 6.9483857999E+00, 5.6431539878E+00, 5.4577239313E-01, 4.6438410292E-01, 6.3284955477E-01],
	[1.2960000000E+04, 6.9519395779E+00, 5.6427624399E+00, 5.4643402679E-01, 4.6487627287E-01, 6.3300344689E-01],
	[1.2965000000E+04, 6.9554938016E+00, 5.6423710702E+00, 5.4709620551E-01, 4.6536870598E-01, 6.3315730296E-01],
	[1.2970000000E+04, 6.9590484711E+00, 5.6419798785E+00, 5.4775892952E-01, 4.6586140215E-01, 6.3331112295E-01],
	[1.2975000000E+04, 6.9626035860E+00, 5.6415888647E+00, 5.4842219906E-01, 4.6635436129E-01, 6.3346490685E-01],
	[1.2980000000E+04, 6.9661591463E+00, 5.6411980286E+00, 5.4908601437E-01, 4.6684758328E-01, 6.3361865463E-01],
	[1.2985000000E+04, 6.9697151519E+00, 5.6408073702E+00, 5.4975037568E-01, 4.6734106804E-01, 6.3377236628E-01],
	[1.2990000000E+04, 6.9732716027E+00, 5.6404168891E+00, 5.5041528323E-01, 4.6783481545E-01, 6.3392604177E-01],
	[1.2995000000E+04, 6.9768284985E+00, 5.6400265854E+00, 5.5108073726E-01, 4.6832882542E-01, 6.3407968107E-01],
	[1.3000000000E+04, 6.9803858393E+00, 5.6396364587E+00, 5.5174673800E-01, 4.6882309783E-01, 6.3423328418E-01],
	[1.3005000000E+04, 6.9839436249E+00, 5.6392465091E+00, 5.5241328569E-01, 4.6931763260E-01, 6.3438685107E-01],
	[1.3010000000E+04, 6.9875018552E+00, 5.6388567363E+00, 5.5308038057E-01, 4.6981242962E-01, 6.3454038171E-01],
	[1.3015000000E+04, 6.9910605301E+00, 5.6384671402E+00, 5.5374802288E-01, 4.7030748878E-01, 6.3469387609E-01],
	[1.3020000000E+04, 6.9946196495E+00, 5.6380777207E+00, 5.5441621284E-01, 4.7080280998E-01, 6.3484733419E-01],
	[1.3025000000E+04, 6.9981792132E+00, 5.6376884775E+00, 5.5508495071E-01, 4.7129839312E-01, 6.3500075599E-01],
	[1.3030000000E+04, 7.0017392212E+00, 5.6372994106E+00, 5.5575423671E-01, 4.7179423809E-01, 6.3515414145E-01],
	[1.3035000000E+04, 7.0052996733E+00, 5.6369105198E+00, 5.5642407108E-01, 4.7229034480E-01, 6.3530749058E-01],
	[1.3040000000E+04, 7.0088711215E+00, 5.6365277994E+00, 5.5709445406E-01, 4.7278680332E-01, 6.3546080333E-01],
	[1.3045000000E+04, 7.0124434690E+00, 5.6361455065E+00, 5.5776538588E-01, 4.7328352751E-01, 6.3561407970E-01],
	[1.3050000000E+04, 7.0160162673E+00, 5.6357633860E+00, 5.5843686679E-01, 4.7378051343E-01, 6.3576731967E-01],
	[1.3055000000E+04, 7.0195895163E+00, 5.6353814377E+00, 5.5910889702E-01, 4.7427776098E-01, 6.3592052320E-01],
	[1.3060000000E+04, 7.0231632157E+00, 5.6349996616E+00, 5.5978147680E-01, 4.7477527006E-01, 6.3607369029E-01],
	[1.3065000000E+04, 7.0267373656E+00, 5.6346180575E+00, 5.6045460638E-01, 4.7527304056E-01, 6.3622682091E-01],
	[1.3070000000E+04, 7.0303119658E+00, 5.6342366252E+00, 5.6112828599E-01, 4.7577107238E-01, 6.3637991504E-01],
	[1.3075000000E+04, 7.0338870162E+00, 5.6338553646E+00, 5.6180251587E-01, 4.7626936541E-01, 6.3653297266E-01],
	[1.3080000000E+04, 7.0374625166E+00, 5.6334742755E+00, 5.6247729625E-01, 4.7676791955E-01, 6.3668599375E-01],
	[1.3085000000E+04, 7.0410384670E+00, 5.6330933579E+00, 5.6315262737E-01, 4.7726673469E-01, 6.3683897829E-01],
	[1.3090000000E+04, 7.0446148672E+00, 5.6327126115E+00, 5.6382850947E-01, 4.7776581073E-01, 6.3699192626E-01],
	[1.3095000000E+04, 7.0481917172E+00, 5.6323320363E+00, 5.6450494279E-01, 4.7826514756E-01, 6.3714483765E-01],
	[1.3100000000E+04, 7.0517690168E+00, 5.6319516320E+00, 5.6518192755E-01, 4.7876474508E-01, 6.3729771242E-01],
	[1.3105000000E+04, 7.0553467658E+00, 5.6315713986E+00, 5.6585946401E-01, 4.7926460318E-01, 6.3745055057E-01],
	[1.3110000000E+04, 7.0589249643E+00, 5.6311913359E+00, 5.6653755240E-01, 4.7976472176E-01, 6.3760335207E-01],
	[1.3115000000E+04, 7.0625036120E+00, 5.6308114437E+00, 5.6721619295E-01, 4.8026510071E-01, 6.3775611689E-01],
	[1.3120000000E+04, 7.0660827088E+00, 5.6304317220E+00, 5.6789538590E-01, 4.8076573991E-01, 6.3790884503E-01],
	[1.3125000000E+04, 7.0696622547E+00, 5.6300521705E+00, 5.6857513148E-01, 4.8126663928E-01, 6.3806153647E-01],
	[1.3130000000E+04, 7.0732422495E+00, 5.6296727892E+00, 5.6925542994E-01, 4.8176779869E-01, 6.3821419117E-01],
	[1.3135000000E+04, 7.0768226931E+00, 5.6292935779E+00, 5.6993628152E-01, 4.8226921805E-01, 6.3836680912E-01],
	[1.3140000000E+04, 7.0804035854E+00, 5.6289145364E+00, 5.7061768644E-01, 4.8277089724E-01, 6.3851939031E-01],
	[1.3145000000E+04, 7.0839849263E+00, 5.6285356646E+00, 5.7129964495E-01, 4.8327283616E-01, 6.3867193472E-01],
	[1.3150000000E+04, 7.0875667156E+00, 5.6281569624E+00, 5.7198215729E-01, 4.8377503470E-01, 6.3882444231E-01],
	[1.3155000000E+04, 7.0911489533E+00, 5.6277784297E+00, 5.7266522368E-01, 4.8427749276E-01, 6.3897691308E-01],
	[1.3160000000E+04, 7.0947316392E+00, 5.6274000662E+00, 5.7334884437E-01, 4.8478021022E-01, 6.3912934701E-01],
	[1.3165000000E+04, 7.0983147732E+00, 5.6270218719E+00, 5.7403301960E-01, 4.8528318697E-01, 6.3928174407E-01],
	[1.3170000000E+04, 7.1018983552E+00, 5.6266438466E+00, 5.7471774959E-01, 4.8578642292E-01, 6.3943410425E-01],
	[1.3175000000E+04, 7.1054823851E+00, 5.6262659901E+00, 5.7540303460E-01, 4.8628991794E-01, 6.3958642752E-01],
	[1.3180000000E+04, 7.1090668628E+00, 5.6258883024E+00, 5.7608887485E-01, 4.8679367194E-01, 6.3973871388E-01],
	[1.3185000000E+04, 7.1126517882E+00, 5.6255107833E+00, 5.7677527059E-01, 4.8729768480E-01, 6.3989096329E-01],
	[1.3190000000E+04, 7.1162371610E+00, 5.6251334327E+00, 5.7746222205E-01, 4.8780195642E-01, 6.4004317574E-01],
	[1.3195000000E+04, 7.1198229814E+00, 5.6247562503E+00, 5.7814972946E-01, 4.8830648668E-01, 6.4019535122E-01],
	[1.3200000000E+04, 7.1234092490E+00, 5.6243792361E+00, 5.7883779308E-01, 4.8881127547E-01, 6.4034748970E-01],
	[1.3205000000E+04, 7.1269959639E+00, 5.6240023900E+00, 5.7952641312E-01, 4.8931632269E-01, 6.4049959115E-01],
	[1.3210000000E+04, 7.1305831258E+00, 5.6236257118E+00, 5.8021558983E-01, 4.8982162823E-01, 6.4065165558E-01],
	[1.3215000000E+04, 7.1341707348E+00, 5.6232492013E+00, 5.8090532345E-01, 4.9032719198E-01, 6.4080368295E-01],
	[1.3220000000E+04, 7.1377587905E+00, 5.6228728585E+00, 5.8159561422E-01, 4.9083301382E-01, 6.4095567325E-01],
	[1.3225000000E+04, 7.1413472931E+00, 5.6224966831E+00, 5.8228646236E-01, 4.9133909364E-01, 6.4110762645E-01],
	[1.3230000000E+04, 7.1449362423E+00, 5.6221206751E+00, 5.8297786813E-01, 4.9184543134E-01, 6.4125954254E-01],
	[1.3235000000E+04, 7.1485256380E+00, 5.6217448343E+00, 5.8366983175E-01, 4.9235202681E-01, 6.4141142151E-01],
	[1.3240000000E+04, 7.1521154801E+00, 5.6213691605E+00, 5.8436235346E-01, 4.9285887993E-01, 6.4156326333E-01],
	[1.3245000000E+04, 7.1557057685E+00, 5.6209936537E+00, 5.8505543350E-01, 4.9336599059E-01, 6.4171506798E-01],
	[1.3250000000E+04, 7.1593079100E+00, 5.6206244304E+00, 5.8574907211E-01, 4.9387346019E-01, 6.4186683544E-01],
	[1.3255000000E+04, 7.1629106269E+00, 5.6202554360E+00, 5.8644326953E-01, 4.9438118853E-01, 6.4201856571E-01],
	[1.3260000000E+04, 7.1665137969E+00, 5.6198866050E+00, 5.8713802599E-01, 4.9488917441E-01, 6.4217025875E-01],
	[1.3265000000E+04, 7.1701174200E+00, 5.6195179373E+00, 5.8783334173E-01, 4.9539741772E-01, 6.4232191455E-01],
	[1.3270000000E+04, 7.1737214961E+00, 5.6191494326E+00, 5.8852921699E-01, 4.9590591836E-01, 6.4247353309E-01],
	[1.3275000000E+04, 7.1773260250E+00, 5.6187810910E+00, 5.8922565200E-01, 4.9641467620E-01, 6.4262511436E-01],
	[1.3280000000E+04, 7.1809310067E+00, 5.6184129121E+00, 5.8992264700E-01, 4.9692369114E-01, 6.4277665833E-01],
	[1.3285000000E+04, 7.1845364410E+00, 5.6180448960E+00, 5.9062020224E-01, 4.9743296307E-01, 6.4292816499E-01],
	[1.3290000000E+04, 7.1881423278E+00, 5.6176770425E+00, 5.9131831794E-01, 4.9794249186E-01, 6.4307963432E-01],
	[1.3295000000E+04, 7.1917486670E+00, 5.6173093513E+00, 5.9201699434E-01, 4.9845227742E-01, 6.4323106630E-01],
	[1.3300000000E+04, 7.1953554585E+00, 5.6169418225E+00, 5.9271623169E-01, 4.9896231963E-01, 6.4338246092E-01],
	[1.3305000000E+04, 7.1989627021E+00, 5.6165744559E+00, 5.9341603021E-01, 4.9947261837E-01, 6.4353381814E-01],
	[1.3310000000E+04, 7.2025703978E+00, 5.6162072513E+00, 5.9411639015E-01, 4.9998317353E-01, 6.4368513797E-01],
	[1.3315000000E+04, 7.2061785455E+00, 5.6158402087E+00, 5.9481731175E-01, 5.0049398500E-01, 6.4383642038E-01],
	[1.3320000000E+04, 7.2097871449E+00, 5.6154733278E+00, 5.9551879524E-01, 5.0100505267E-01, 6.4398766535E-01],
	[1.3325000000E+04, 7.2133961961E+00, 5.6151066085E+00, 5.9622084085E-01, 5.0151637642E-01, 6.4413887286E-01],
	[1.3330000000E+04, 7.2170056989E+00, 5.6147400508E+00, 5.9692344884E-01, 5.0202795614E-01, 6.4429004290E-01],
	[1.3335000000E+04, 7.2206156532E+00, 5.6143736545E+00, 5.9762661942E-01, 5.0253979171E-01, 6.4444117545E-01],
	[1.3340000000E+04, 7.2242260589E+00, 5.6140074194E+00, 5.9833035285E-01, 5.0305188302E-01, 6.4459227049E-01],
	[1.3345000000E+04, 7.2278369158E+00, 5.6136413454E+00, 5.9903464935E-01, 5.0356422996E-01, 6.4474332800E-01],
	[1.3350000000E+04, 7.2314482239E+00, 5.6132754324E+00, 5.9973950918E-01, 5.0407683241E-01, 6.4489434797E-01],
	[1.3355000000E+04, 7.2350599830E+00, 5.6129096803E+00, 6.0044493255E-01, 5.0458969025E-01, 6.4504533038E-01],
	[1.3360000000E+04, 7.2386721931E+00, 5.6125440889E+00, 6.0115091972E-01, 5.0510280338E-01, 6.4519627521E-01],
	[1.3365000000E+04, 7.2422848539E+00, 5.6121786581E+00, 6.0185747092E-01, 5.0561617168E-01, 6.4534718244E-01],
	[1.3370000000E+04, 7.2458979655E+00, 5.6118133878E+00, 6.0256458638E-01, 5.0612979502E-01, 6.4549805206E-01],
	[1.3375000000E+04, 7.2495115277E+00, 5.6114482778E+00, 6.0327226635E-01, 5.0664367331E-01, 6.4564888405E-01],
	[1.3380000000E+04, 7.2531255403E+00, 5.6110833280E+00, 6.0398051106E-01, 5.0715780641E-01, 6.4579967839E-01],
	[1.3385000000E+04, 7.2567400033E+00, 5.6107185383E+00, 6.0468932074E-01, 5.0767219422E-01, 6.4595043507E-01],
	[1.3390000000E+04, 7.2603549166E+00, 5.6103539085E+00, 6.0539869565E-01, 5.0818683662E-01, 6.4610115406E-01],
	[1.3395000000E+04, 7.2639702799E+00, 5.6099894385E+00, 6.0610863601E-01, 5.0870173350E-01, 6.4625183536E-01],
	[1.3400000000E+04, 7.2675860934E+00, 5.6096251283E+00, 6.0681914206E-01, 5.0921688473E-01, 6.4640247894E-01],
	[1.3405000000E+04, 7.2712023567E+00, 5.6092609776E+00, 6.0753021404E-01, 5.0973229020E-01, 6.4655308479E-01],
	[1.3410000000E+04, 7.2748190699E+00, 5.6088969863E+00, 6.0824185219E-01, 5.1024794979E-01, 6.4670365288E-01],
	[1.3415000000E+04, 7.2784362327E+00, 5.6085331543E+00, 6.0895405674E-01, 5.1076386339E-01, 6.4685418321E-01],
	[1.3420000000E+04, 7.2820538451E+00, 5.6081694815E+00, 6.0966682793E-01, 5.1128003089E-01, 6.4700467576E-01],
	[1.3425000000E+04, 7.2856719070E+00, 5.6078059677E+00, 6.1038016601E-01, 5.1179645215E-01, 6.4715513051E-01],
	[1.3430000000E+04, 7.2892904183E+00, 5.6074426128E+00, 6.1109407120E-01, 5.1231312707E-01, 6.4730554743E-01],
	[1.3435000000E+04, 7.2929093787E+00, 5.6070794167E+00, 6.1180854375E-01, 5.1283005553E-01, 6.4745592653E-01],
	[1.3440000000E+04, 7.2965287884E+00, 5.6067163793E+00, 6.1252358389E-01, 5.1334723740E-01, 6.4760626777E-01],
	[1.3445000000E+04, 7.3001486470E+00, 5.6063535004E+00, 6.1323919187E-01, 5.1386467258E-01, 6.4775657115E-01],
	[1.3450000000E+04, 7.3037689546E+00, 5.6059907799E+00, 6.1395536791E-01, 5.1438236095E-01, 6.4790683665E-01],
	[1.3455000000E+04, 7.3073897110E+00, 5.6056282176E+00, 6.1467211225E-01, 5.1490030238E-01, 6.4805706424E-01],
	[1.3460000000E+04, 7.3110150643E+00, 5.6052679173E+00, 6.1538942514E-01, 5.1541853516E-01, 6.4820725392E-01],
	[1.3465000000E+04, 7.3146487839E+00, 5.6049117858E+00, 6.1610730682E-01, 5.1593709427E-01, 6.4835740566E-01],
	[1.3470000000E+04, 7.3182829594E+00, 5.6045558090E+00, 6.1682575751E-01, 5.1645590644E-01, 6.4850751946E-01],
	[1.3475000000E+04, 7.3219175907E+00, 5.6041999870E+00, 6.1754477746E-01, 5.1697497155E-01, 6.4865759528E-01],
	[1.3480000000E+04, 7.3255526777E+00, 5.6038443196E+00, 6.1826436690E-01, 5.1749428950E-01, 6.4880763313E-01],
	[1.3485000000E+04, 7.3291882204E+00, 5.6034888067E+00, 6.1898452608E-01, 5.1801386015E-01, 6.4895763298E-01],
	[1.3490000000E+04, 7.3328242186E+00, 5.6031334480E+00, 6.1970525523E-01, 5.1853368340E-01, 6.4910759482E-01],
	[1.3495000000E+04, 7.3364606722E+00, 5.6027782436E+00, 6.2042655458E-01, 5.1905375912E-01, 6.4925751862E-01],
	[1.3500000000E+04, 7.3400975810E+00, 5.6024231933E+00, 6.2114842439E-01, 5.1957408718E-01, 6.4940740438E-01],
	[1.3505000000E+04, 7.3437349451E+00, 5.6020682969E+00, 6.2187086487E-01, 5.2009466749E-01, 6.4955725207E-01],
	[1.3510000000E+04, 7.3473727642E+00, 5.6017135544E+00, 6.2259387628E-01, 5.2061549990E-01, 6.4970706169E-01],
	[1.3515000000E+04, 7.3510110382E+00, 5.6013589656E+00, 6.2331745885E-01, 5.2113658430E-01, 6.4985683321E-01],
	[1.3520000000E+04, 7.3546497671E+00, 5.6010045304E+00, 6.2404161281E-01, 5.2165792058E-01, 6.5000656663E-01],
	[1.3525000000E+04, 7.3582889507E+00, 5.6006502486E+00, 6.2476633841E-01, 5.2217950861E-01, 6.5015626191E-01],
	[1.3530000000E+04, 7.3619285889E+00, 5.6002961202E+00, 6.2549163588E-01, 5.2270134828E-01, 6.5030591906E-01],
	[1.3535000000E+04, 7.3655686817E+00, 5.5999421450E+00, 6.2621750547E-01, 5.2322343945E-01, 6.5045553804E-01],
	[1.3540000000E+04, 7.3692092288E+00, 5.5995883230E+00, 6.2694394740E-01, 5.2374578201E-01, 6.5060511886E-01],
	[1.3545000000E+04, 7.3728502302E+00, 5.5992346539E+00, 6.2767096192E-01, 5.2426837585E-01, 6.5075466148E-01],
	[1.3550000000E+04, 7.3764916858E+00, 5.5988811376E+00, 6.2839854926E-01, 5.2479122083E-01, 6.5090416590E-01],
	[1.3555000000E+04, 7.3801335954E+00, 5.5985277741E+00, 6.2912670967E-01, 5.2531431684E-01, 6.5105363210E-01],
	[1.3560000000E+04, 7.3837759590E+00, 5.5981745632E+00, 6.2985544338E-01, 5.2583766375E-01, 6.5120306006E-01],
	[1.3565000000E+04, 7.3874187764E+00, 5.5978215048E+00, 6.3058475062E-01, 5.2636126145E-01, 6.5135244977E-01],
	[1.3570000000E+04, 7.3910620475E+00, 5.5974685987E+00, 6.3131463164E-01, 5.2688510981E-01, 6.5150180122E-01],
	[1.3575000000E+04, 7.3947057723E+00, 5.5971158449E+00, 6.3204508668E-01, 5.2740920871E-01, 6.5165111438E-01],
	[1.3580000000E+04, 7.3983499505E+00, 5.5967632432E+00, 6.3277611596E-01, 5.2793355803E-01, 6.5180038925E-01],
	[1.3585000000E+04, 7.4019945822E+00, 5.5964107935E+00, 6.3350771974E-01, 5.2845815764E-01, 6.5194962580E-01],
	[1.3590000000E+04, 7.4056396671E+00, 5.5960584957E+00, 6.3423989824E-01, 5.2898300742E-01, 6.5209882403E-01],
	[1.3595000000E+04, 7.4092852053E+00, 5.5957063497E+00, 6.3497265172E-01, 5.2950810726E-01, 6.5224798391E-01],
	[1.3600000000E+04, 7.4129311964E+00, 5.5953543553E+00, 6.3570598039E-01, 5.3003345702E-01, 6.5239710543E-01],
	[1.3605000000E+04, 7.4165776406E+00, 5.5950025124E+00, 6.3643988451E-01, 5.3055905659E-01, 6.5254618858E-01],
	[1.3610000000E+04, 7.4202245376E+00, 5.5946508209E+00, 6.3717436430E-01, 5.3108490583E-01, 6.5269523334E-01],
	[1.3615000000E+04, 7.4238718873E+00, 5.5942992806E+00, 6.3790942002E-01, 5.3161100464E-01, 6.5284423970E-01],
	[1.3620000000E+04, 7.4275196896E+00, 5.5939478916E+00, 6.3864505189E-01, 5.3213735287E-01, 6.5299320764E-01],
	[1.3625000000E+04, 7.4311679445E+00, 5.5935966535E+00, 6.3938126015E-01, 5.3266395042E-01, 6.5314213714E-01],
	[1.3630000000E+04, 7.4348166517E+00, 5.5932455664E+00, 6.4011804505E-01, 5.3319079715E-01, 6.5329102817E-01],
	[1.3635000000E+04, 7.4384658112E+00, 5.5928946300E+00, 6.4085540682E-01, 5.3371789295E-01, 6.5343988069E-01],
	[1.3640000000E+04, 7.4421154230E+00, 5.5925438444E+00, 6.4159334569E-01, 5.3424523768E-01, 6.5358869469E-01],
	[1.3645000000E+04, 7.4457654868E+00, 5.5921932093E+00, 6.4233186191E-01, 5.3477283122E-01, 6.5373747014E-01],
	[1.3650000000E+04, 7.4494160025E+00, 5.5918427246E+00, 6.4307095572E-01, 5.3530067345E-01, 6.5388620701E-01],
	[1.3655000000E+04, 7.4530669702E+00, 5.5914923902E+00, 6.4381062735E-01, 5.3582876424E-01, 6.5403490530E-01],
	[1.3660000000E+04, 7.4567183895E+00, 5.5911422061E+00, 6.4455087704E-01, 5.3635710347E-01, 6.5418356498E-01],
	[1.3665000000E+04, 7.4603702605E+00, 5.5907921720E+00, 6.4529170502E-01, 5.3688569102E-01, 6.5433218604E-01],
	[1.3670000000E+04, 7.4640225830E+00, 5.5904422878E+00, 6.4603311155E-01, 5.3741452675E-01, 6.5448076844E-01],
	[1.3675000000E+04, 7.4676755075E+00, 5.5900926258E+00, 6.4677509685E-01, 5.3794361199E-01, 6.5462931217E-01],
	[1.3680000000E+04, 7.4713413368E+00, 5.5897490909E+00, 6.4751766116E-01, 5.3847306533E-01, 6.5477781721E-01],
	[1.3685000000E+04, 7.4750076249E+00, 5.5894057026E+00, 6.4826080472E-01, 5.3900276686E-01, 6.5492628355E-01],
	[1.3690000000E+04, 7.4786743719E+00, 5.5890624609E+00, 6.4900452777E-01, 5.3953271644E-01, 6.5507471115E-01],
	[1.3695000000E+04, 7.4823415776E+00, 5.5887193655E+00, 6.4975049272E-01, 5.4006406231E-01, 6.5522310000E-01],
	[1.3700000000E+04, 7.4860092419E+00, 5.5883764165E+00, 6.5049975555E-01, 5.4059753235E-01, 6.5537145008E-01],
	[1.3705000000E+04, 7.4896773647E+00, 5.5880336136E+00, 6.5124960722E-01, 5.4113125404E-01, 6.5551976138E-01],
	[1.3710000000E+04, 7.4933459459E+00, 5.5876909568E+00, 6.5200004797E-01, 5.4166522725E-01, 6.5566803386E-01],
	[1.3715000000E+04, 7.4970149854E+00, 5.5873484459E+00, 6.5275107805E-01, 5.4219945186E-01, 6.5581626751E-01],
	[1.3720000000E+04, 7.5006844830E+00, 5.5870060808E+00, 6.5350269770E-01, 5.4273392774E-01, 6.5596446232E-01],
	[1.3725000000E+04, 7.5043544387E+00, 5.5866638615E+00, 6.5425490718E-01, 5.4326865476E-01, 6.5611261825E-01],
	[1.3730000000E+04, 7.5080248524E+00, 5.5863217878E+00, 6.5500770672E-01, 5.4380363279E-01, 6.5626073530E-01],
	[1.3735000000E+04, 7.5116957238E+00, 5.5859798595E+00, 6.5576109657E-01, 5.4433886171E-01, 6.5640881344E-01],
	[1.3740000000E+04, 7.5153670531E+00, 5.5856380766E+00, 6.5651507699E-01, 5.4487434138E-01, 6.5655685265E-01],
	[1.3745000000E+04, 7.5190388399E+00, 5.5852964390E+00, 6.5726964821E-01, 5.4541007169E-01, 6.5670485291E-01],
	[1.3750000000E+04, 7.5227110842E+00, 5.5849549465E+00, 6.5802481048E-01, 5.4594605249E-01, 6.5685281421E-01],
	[1.3755000000E+04, 7.5263837860E+00, 5.5846135990E+00, 6.5878056405E-01, 5.4648228366E-01, 6.5700073652E-01],
	[1.3760000000E+04, 7.5300569450E+00, 5.5842723964E+00, 6.5953690916E-01, 5.4701876507E-01, 6.5714861983E-01],
	[1.3765000000E+04, 7.5337305612E+00, 5.5839313387E+00, 6.6029384607E-01, 5.4755549660E-01, 6.5729646411E-01],
	[1.3770000000E+04, 7.5374046345E+00, 5.5835904256E+00, 6.6105137501E-01, 5.4809247811E-01, 6.5744426935E-01],
	[1.3775000000E+04, 7.5410791648E+00, 5.5832496571E+00, 6.6180949623E-01, 5.4862970947E-01, 6.5759203553E-01],
	[1.3780000000E+04, 7.5447541519E+00, 5.5829090330E+00, 6.6256820998E-01, 5.4916719056E-01, 6.5773976263E-01],
	[1.3785000000E+04, 7.5484295957E+00, 5.5825685533E+00, 6.6332751651E-01, 5.4970492124E-01, 6.5788745062E-01],
	[1.3790000000E+04, 7.5521054962E+00, 5.5822282178E+00, 6.6408741606E-01, 5.5024290139E-01, 6.5803509950E-01],
	[1.3795000000E+04, 7.5557818533E+00, 5.5818880264E+00, 6.6484790888E-01, 5.5078113086E-01, 6.5818270923E-01],
	[1.3800000000E+04, 7.5594586667E+00, 5.5815479790E+00, 6.6560899521E-01, 5.5131960954E-01, 6.5833027981E-01],
	[1.3805000000E+04, 7.5631359364E+00, 5.5812080755E+00, 6.6637067530E-01, 5.5185833730E-01, 6.5847781121E-01],
	[1.3810000000E+04, 7.5668136624E+00, 5.5808683158E+00, 6.6713294939E-01, 5.5239731399E-01, 6.5862530342E-01],
	[1.3815000000E+04, 7.5704918444E+00, 5.5805286997E+00, 6.6789581774E-01, 5.5293653949E-01, 6.5877275642E-01],
	[1.3820000000E+04, 7.5741704825E+00, 5.5801892272E+00, 6.6865928059E-01, 5.5347601368E-01, 6.5892017018E-01],
	[1.3825000000E+04, 7.5778495764E+00, 5.5798498982E+00, 6.6942333819E-01, 5.5401573641E-01, 6.5906754469E-01],
	[1.3830000000E+04, 7.5815291260E+00, 5.5795107124E+00, 6.7018799077E-01, 5.5455570756E-01, 6.5921487993E-01],
	[1.3835000000E+04, 7.5852091314E+00, 5.5791716699E+00, 6.7095323859E-01, 5.5509592699E-01, 6.5936217588E-01],
	[1.3840000000E+04, 7.5888895923E+00, 5.5788327704E+00, 6.7171908190E-01, 5.5563639458E-01, 6.5950943252E-01],
	[1.3845000000E+04, 7.5925705086E+00, 5.5784940140E+00, 6.7248552094E-01, 5.5617711018E-01, 6.5965664984E-01],
	[1.3850000000E+04, 7.5962518802E+00, 5.5781554004E+00, 6.7325255596E-01, 5.5671807368E-01, 6.5980382782E-01],
	[1.3855000000E+04, 7.5999337071E+00, 5.5778169296E+00, 6.7402018720E-01, 5.5725928493E-01, 6.5995096644E-01],
	[1.3860000000E+04, 7.6036159891E+00, 5.5774786015E+00, 6.7478841491E-01, 5.5780074380E-01, 6.6009806567E-01],
	[1.3865000000E+04, 7.6072987261E+00, 5.5771404158E+00, 6.7555723933E-01, 5.5834245017E-01, 6.6024512551E-01],
	[1.3870000000E+04, 7.6109819181E+00, 5.5768023727E+00, 6.7632666072E-01, 5.5888440389E-01, 6.6039214593E-01],
	[1.3875000000E+04, 7.6146655648E+00, 5.5764644718E+00, 6.7709667932E-01, 5.5942660484E-01, 6.6053912692E-01],
	[1.3880000000E+04, 7.6183496662E+00, 5.5761267131E+00, 6.7786729538E-01, 5.5996905288E-01, 6.6068606845E-01],
	[1.3885000000E+04, 7.6220342222E+00, 5.5757890966E+00, 6.7863850913E-01, 5.6051174787E-01, 6.6083297051E-01],
	[1.3890000000E+04, 7.6257192326E+00, 5.5754516220E+00, 6.7941032084E-01, 5.6105468970E-01, 6.6097983309E-01],
	[1.3895000000E+04, 7.6294046974E+00, 5.5751142893E+00, 6.8018273074E-01, 5.6159787821E-01, 6.6112665615E-01],
	[1.3900000000E+04, 7.6331035354E+00, 5.5747829773E+00, 6.8095573908E-01, 5.6214144312E-01, 6.6127343970E-01],
	[1.3905000000E+04, 7.6368030674E+00, 5.5744519096E+00, 6.8172934611E-01, 5.6268525719E-01, 6.6142018370E-01],
	[1.3910000000E+04, 7.6405030614E+00, 5.5741209806E+00, 6.8250355207E-01, 5.6322931794E-01, 6.6156688814E-01],
	[1.3915000000E+04, 7.6442035174E+00, 5.5737901902E+00, 6.8327835722E-01, 5.6377362525E-01, 6.6171355301E-01],
	[1.3920000000E+04, 7.6479044351E+00, 5.5734595382E+00, 6.8405376179E-01, 5.6431817899E-01, 6.6186017828E-01],
	[1.3925000000E+04, 7.6516058146E+00, 5.5731290246E+00, 6.8482976604E-01, 5.6486297901E-01, 6.6200676394E-01],
	[1.3930000000E+04, 7.6553076557E+00, 5.5727986493E+00, 6.8560637021E-01, 5.6540802519E-01, 6.6215330996E-01],
	[1.3935000000E+04, 7.6590099582E+00, 5.5724684120E+00, 6.8638357455E-01, 5.6595331739E-01, 6.6229981634E-01],
	[1.3940000000E+04, 7.6627127222E+00, 5.5721383128E+00, 6.8716137930E-01, 5.6649885548E-01, 6.6244628306E-01],
	[1.3945000000E+04, 7.6664159474E+00, 5.5718083516E+00, 6.8793978471E-01, 5.6704463931E-01, 6.6259271009E-01],
	[1.3950000000E+04, 7.6701196338E+00, 5.5714785281E+00, 6.8871879103E-01, 5.6759066876E-01, 6.6273909742E-01],
	[1.3955000000E+04, 7.6738237813E+00, 5.5711488424E+00, 6.8949839850E-01, 5.6813694369E-01, 6.6288544504E-01],
	[1.3960000000E+04, 7.6775283897E+00, 5.5708192942E+00, 6.9027860737E-01, 5.6868346396E-01, 6.6303175292E-01],
	[1.3965000000E+04, 7.6812334589E+00, 5.5704898836E+00, 6.9105941789E-01, 5.6923022944E-01, 6.6317802105E-01],
	[1.3970000000E+04, 7.6849389889E+00, 5.5701606103E+00, 6.9184083031E-01, 5.6977723999E-01, 6.6332424941E-01],
	[1.3975000000E+04, 7.6886449795E+00, 5.5698314743E+00, 6.9262284486E-01, 5.7032449549E-01, 6.6347043798E-01],
	[1.3980000000E+04, 7.6923514307E+00, 5.5695024755E+00, 6.9340546180E-01, 5.7087199578E-01, 6.6361658675E-01],
	[1.3985000000E+04, 7.6960583422E+00, 5.5691736138E+00, 6.9418868138E-01, 5.7141974073E-01, 6.6376269571E-01],
	[1.3990000000E+04, 7.6997657141E+00, 5.5688448890E+00, 6.9497250384E-01, 5.7196773022E-01, 6.6390876482E-01],
	[1.3995000000E+04, 7.7034735461E+00, 5.5685163011E+00, 6.9575692942E-01, 5.7251596409E-01, 6.6405479408E-01],
	[1.4000000000E+04, 7.7071818383E+00, 5.5681878499E+00, 6.9654195838E-01, 5.7306444222E-01, 6.6420078347E-01],
	[1.4005000000E+04, 7.7108905904E+00, 5.5678595354E+00, 6.9732759096E-01, 5.7361316447E-01, 6.6434673298E-01],
	[1.4010000000E+04, 7.7145998024E+00, 5.5675313574E+00, 6.9811382740E-01, 5.7416213070E-01, 6.6449264258E-01],
	[1.4015000000E+04, 7.7183094742E+00, 5.5672033159E+00, 6.9890066796E-01, 5.7471134077E-01, 6.6463851226E-01],
	[1.4020000000E+04, 7.7220196057E+00, 5.5668754107E+00, 6.9968811288E-01, 5.7526079455E-01, 6.6478434200E-01],
	[1.4025000000E+04, 7.7257301967E+00, 5.5665476417E+00, 7.0047616241E-01, 5.7581049189E-01, 6.6493013179E-01],
	[1.4030000000E+04, 7.7294412471E+00, 5.5662200088E+00, 7.0126481680E-01, 5.7636043266E-01, 6.6507588161E-01],
	[1.4035000000E+04, 7.7331527569E+00, 5.5658925120E+00, 7.0205407628E-01, 5.7691061673E-01, 6.6522159144E-01],
	[1.4040000000E+04, 7.7368647260E+00, 5.5655651510E+00, 7.0284394111E-01, 5.7746104395E-01, 6.6536726127E-01],
	[1.4045000000E+04, 7.7405771541E+00, 5.5652379259E+00, 7.0363441154E-01, 5.7801171419E-01, 6.6551289108E-01],
	[1.4050000000E+04, 7.7442900413E+00, 5.5649108364E+00, 7.0442548781E-01, 5.7856262730E-01, 6.6565848085E-01],
	[1.4055000000E+04, 7.7480033874E+00, 5.5645838826E+00, 7.0521717017E-01, 5.7911378315E-01, 6.6580403057E-01],
	[1.4060000000E+04, 7.7517171923E+00, 5.5642570642E+00, 7.0600945887E-01, 5.7966518160E-01, 6.6594954022E-01],
	[1.4065000000E+04, 7.7554314559E+00, 5.5639303813E+00, 7.0680235415E-01, 5.8021682251E-01, 6.6609500979E-01],
	[1.4070000000E+04, 7.7591461781E+00, 5.5636038336E+00, 7.0759585625E-01, 5.8076870575E-01, 6.6624043926E-01],
	[1.4075000000E+04, 7.7628613588E+00, 5.5632774211E+00, 7.0838996544E-01, 5.8132083116E-01, 6.6638582861E-01],
	[1.4080000000E+04, 7.7665769979E+00, 5.5629511436E+00, 7.0918468194E-01, 5.8187319862E-01, 6.6653117782E-01],
	[1.4085000000E+04, 7.7702930953E+00, 5.5626250012E+00, 7.0998000602E-01, 5.8242580798E-01, 6.6667648689E-01],
	[1.4090000000E+04, 7.7740096508E+00, 5.5622989936E+00, 7.1077593791E-01, 5.8297865910E-01, 6.6682175579E-01],
	[1.4095000000E+04, 7.7777266644E+00, 5.5619731207E+00, 7.1157247787E-01, 5.8353175185E-01, 6.6696698452E-01],
	[1.4100000000E+04, 7.7814441360E+00, 5.5616473825E+00, 7.1236962614E-01, 5.8408508608E-01, 6.6711217304E-01],
	[1.4105000000E+04, 7.7851620654E+00, 5.5613217789E+00, 7.1316738297E-01, 5.8463866165E-01, 6.6725732136E-01],
	[1.4110000000E+04, 7.7888804525E+00, 5.5609963098E+00, 7.1396574860E-01, 5.8519247842E-01, 6.6740242944E-01],
	[1.4115000000E+04, 7.7925992973E+00, 5.5606709749E+00, 7.1476472328E-01, 5.8574653626E-01, 6.6754749728E-01],
	[1.4120000000E+04, 7.7963219424E+00, 5.5603472189E+00, 7.1556430726E-01, 5.8630086998E-01, 6.6769252486E-01],
	[1.4125000000E+04, 7.8000554088E+00, 5.5600280716E+00, 7.1636450079E-01, 5.8685555309E-01, 6.6783751217E-01],
	[1.4130000000E+04, 7.8037893407E+00, 5.5597090556E+00, 7.1716530411E-01, 5.8741047727E-01, 6.6798245919E-01],
	[1.4135000000E+04, 7.8075237381E+00, 5.5593901707E+00, 7.1796671747E-01, 5.8796564237E-01, 6.6812736590E-01],
	[1.4140000000E+04, 7.8112586009E+00, 5.5590714169E+00, 7.1876874112E-01, 5.8852104826E-01, 6.6827223229E-01],
	[1.4145000000E+04, 7.8149939289E+00, 5.5587527941E+00, 7.1957137530E-01, 5.8907669478E-01, 6.6841705834E-01],
	[1.4150000000E+04, 7.8187297221E+00, 5.5584343021E+00, 7.2037462027E-01, 5.8963258181E-01, 6.6856184404E-01],
	[1.4155000000E+04, 7.8224659803E+00, 5.5581159409E+00, 7.2117847626E-01, 5.9018870919E-01, 6.6870658937E-01],
	[1.4160000000E+04, 7.8262027034E+00, 5.5577977103E+00, 7.2198294352E-01, 5.9074507679E-01, 6.6885129432E-01],
	[1.4165000000E+04, 7.8299398913E+00, 5.5574796103E+00, 7.2278802231E-01, 5.9130168447E-01, 6.6899595887E-01],
	[1.4170000000E+04, 7.8336775440E+00, 5.5571616408E+00, 7.2359371287E-01, 5.9185853208E-01, 6.6914058301E-01],
	[1.4175000000E+04, 7.8374156613E+00, 5.5568438016E+00, 7.2440001545E-01, 5.9241561948E-01, 6.6928516672E-01],
	[1.4180000000E+04, 7.8411542431E+00, 5.5565260927E+00, 7.2520693029E-01, 5.9297294653E-01, 6.6942970998E-01],
	[1.4185000000E+04, 7.8448932892E+00, 5.5562085139E+00, 7.2601445763E-01, 5.9353051308E-01, 6.6957421279E-01],
	[1.4190000000E+04, 7.8486327997E+00, 5.5558910652E+00, 7.2682259774E-01, 5.9408831901E-01, 6.6971867512E-01],
	[1.4195000000E+04, 7.8523727744E+00, 5.5555737465E+00, 7.2763135086E-01, 5.9464636415E-01, 6.6986309697E-01],
	[1.4200000000E+04, 7.8561132131E+00, 5.5552565576E+00, 7.2844071722E-01, 5.9520464837E-01, 6.7000747831E-01],
	[1.4205000000E+04, 7.8598541158E+00, 5.5549394985E+00, 7.2925069708E-01, 5.9576317152E-01, 6.7015181914E-01],
	[1.4210000000E+04, 7.8635954824E+00, 5.5546225691E+00, 7.3006129070E-01, 5.9632193347E-01, 6.7029611943E-01],
	[1.4215000000E+04, 7.8673373127E+00, 5.5543057692E+00, 7.3087249830E-01, 5.9688093407E-01, 6.7044037918E-01],
	[1.4220000000E+04, 7.8710796067E+00, 5.5539890989E+00, 7.3168432015E-01, 5.9744017317E-01, 6.7058459836E-01],
	[1.4225000000E+04, 7.8748223643E+00, 5.5536725578E+00, 7.3249675648E-01, 5.9799965064E-01, 6.7072877696E-01],
	[1.4230000000E+04, 7.8785655853E+00, 5.5533561461E+00, 7.3330980755E-01, 5.9855936632E-01, 6.7087291498E-01],
	[1.4235000000E+04, 7.8823092696E+00, 5.5530398635E+00, 7.3412347361E-01, 5.9911932008E-01, 6.7101701239E-01],
	[1.4240000000E+04, 7.8860534172E+00, 5.5527237100E+00, 7.3493775489E-01, 5.9967951176E-01, 6.7116106918E-01],
	[1.4245000000E+04, 7.8897980279E+00, 5.5524076855E+00, 7.3575265165E-01, 6.0023994123E-01, 6.7130508533E-01],
	[1.4250000000E+04, 7.8935431016E+00, 5.5520917899E+00, 7.3656816414E-01, 6.0080060835E-01, 6.7144906083E-01],
	[1.4255000000E+04, 7.8972886383E+00, 5.5517760231E+00, 7.3738429260E-01, 6.0136151296E-01, 6.7159299567E-01],
	[1.4260000000E+04, 7.9010346377E+00, 5.5514603849E+00, 7.3820103727E-01, 6.0192265492E-01, 6.7173688984E-01],
	[1.4265000000E+04, 7.9047810999E+00, 5.5511448753E+00, 7.3901839842E-01, 6.0248403408E-01, 6.7188074331E-01],
	[1.4270000000E+04, 7.9085280247E+00, 5.5508294943E+00, 7.3983637628E-01, 6.0304565031E-01, 6.7202455607E-01],
	[1.4275000000E+04, 7.9122754119E+00, 5.5505142416E+00, 7.4065497110E-01, 6.0360750346E-01, 6.7216832812E-01],
	[1.4280000000E+04, 7.9160232616E+00, 5.5501991172E+00, 7.4147418312E-01, 6.0416959337E-01, 6.7231205942E-01],
	[1.4285000000E+04, 7.9197715736E+00, 5.5498841210E+00, 7.4229401261E-01, 6.0473191991E-01, 6.7245574999E-01],
	[1.4290000000E+04, 7.9235203477E+00, 5.5495692529E+00, 7.4311445980E-01, 6.0529448293E-01, 6.7259939978E-01],
	[1.4295000000E+04, 7.9272695839E+00, 5.5492545129E+00, 7.4393552493E-01, 6.0585728229E-01, 6.7274300881E-01],
	[1.4300000000E+04, 7.9310192821E+00, 5.5489399007E+00, 7.4475720827E-01, 6.0642031783E-01, 6.7288657704E-01],
	[1.4305000000E+04, 7.9347694422E+00, 5.5486254163E+00, 7.4557951005E-01, 6.0698358941E-01, 6.7303010446E-01],
	[1.4310000000E+04, 7.9385200640E+00, 5.5483110597E+00, 7.4640243053E-01, 6.0754709688E-01, 6.7317359107E-01],
	[1.4315000000E+04, 7.9422711475E+00, 5.5479968307E+00, 7.4722596994E-01, 6.0811084011E-01, 6.7331703685E-01],
	[1.4320000000E+04, 7.9460226926E+00, 5.5476827292E+00, 7.4805012855E-01, 6.0867481893E-01, 6.7346044178E-01],
	[1.4325000000E+04, 7.9497746991E+00, 5.5473687551E+00, 7.4887490659E-01, 6.0923903321E-01, 6.7360380585E-01],
	[1.4330000000E+04, 7.9535271669E+00, 5.5470549084E+00, 7.4970030431E-01, 6.0980348280E-01, 6.7374712905E-01],
	[1.4335000000E+04, 7.9572800960E+00, 5.5467411889E+00, 7.5052632196E-01, 6.1036816754E-01, 6.7389041136E-01],
	[1.4340000000E+04, 7.9610334862E+00, 5.5464275965E+00, 7.5135295979E-01, 6.1093308730E-01, 6.7403365277E-01],
	[1.4345000000E+04, 7.9647873375E+00, 5.5461141312E+00, 7.5218021805E-01, 6.1149824193E-01, 6.7417685327E-01],
	[1.4350000000E+04, 7.9685528520E+00, 5.5458053918E+00, 7.5300809698E-01, 6.1206375338E-01, 6.7432001284E-01],
	[1.4355000000E+04, 7.9723218969E+00, 5.5454980340E+00, 7.5383659683E-01, 6.1262953318E-01, 6.7446313147E-01],
	[1.4360000000E+04, 7.9760914110E+00, 5.5451908003E+00, 7.5466571784E-01, 6.1319554785E-01, 6.7460620915E-01],
	[1.4365000000E+04, 7.9798613942E+00, 5.5448836905E+00, 7.5549546028E-01, 6.1376179725E-01, 6.7474924585E-01],
	[1.4370000000E+04, 7.9836318464E+00, 5.5445767046E+00, 7.5632582437E-01, 6.1432828122E-01, 6.7489224158E-01],
	[1.4375000000E+04, 7.9874027675E+00, 5.5442698424E+00, 7.5715681038E-01, 6.1489499962E-01, 6.7503519632E-01],
	[1.4380000000E+04, 7.9911741575E+00, 5.5439631040E+00, 7.5798841854E-01, 6.1546195230E-01, 6.7517811004E-01],
	[1.4385000000E+04, 7.9949460161E+00, 5.5436564891E+00, 7.5882064911E-01, 6.1602913911E-01, 6.7532098275E-01],
	[1.4390000000E+04, 7.9987183433E+00, 5.5433499978E+00, 7.5965350234E-01, 6.1659655991E-01, 6.7546381443E-01],
	[1.4395000000E+04, 8.0024911390E+00, 5.5430436299E+00, 7.6048697846E-01, 6.1716421454E-01, 6.7560660506E-01],
	[1.4400000000E+04, 8.0062644031E+00, 5.5427373853E+00, 7.6132107773E-01, 6.1773210286E-01, 6.7574935463E-01],
	[1.4405000000E+04, 8.0100381354E+00, 5.5424312639E+00, 7.6215580040E-01, 6.1830022472E-01, 6.7589206312E-01],
	[1.4410000000E+04, 8.0138123359E+00, 5.5421252657E+00, 7.6299114671E-01, 6.1886857996E-01, 6.7603473053E-01],
	[1.4415000000E+04, 8.0175870045E+00, 5.5418193905E+00, 7.6382711692E-01, 6.1943716845E-01, 6.7617735685E-01],
	[1.4420000000E+04, 8.0213621411E+00, 5.5415136382E+00, 7.6466371126E-01, 6.2000599003E-01, 6.7631994205E-01],
	[1.4425000000E+04, 8.0251377455E+00, 5.5412080088E+00, 7.6550092999E-01, 6.2057504455E-01, 6.7646248613E-01],
	[1.4430000000E+04, 8.0289138177E+00, 5.5409025022E+00, 7.6633877336E-01, 6.2114433186E-01, 6.7660498908E-01],
	[1.4435000000E+04, 8.0326903575E+00, 5.5405971183E+00, 7.6717724160E-01, 6.2171385181E-01, 6.7674745087E-01],
	[1.4440000000E+04, 8.0364673649E+00, 5.5402918569E+00, 7.6801633498E-01, 6.2228360426E-01, 6.7688987151E-01],
	[1.4445000000E+04, 8.0402448397E+00, 5.5399867180E+00, 7.6885605374E-01, 6.2285358905E-01, 6.7703225097E-01],
	[1.4450000000E+04, 8.0440227818E+00, 5.5396817015E+00, 7.6969639812E-01, 6.2342380603E-01, 6.7717458924E-01],
	[1.4455000000E+04, 8.0478011912E+00, 5.5393768074E+00, 7.7053736837E-01, 6.2399425506E-01, 6.7731688632E-01],
	[1.4460000000E+04, 8.0515800677E+00, 5.5390720354E+00, 7.7137896474E-01, 6.2456493597E-01, 6.7745914218E-01],
	[1.4465000000E+04, 8.0553594112E+00, 5.5387673856E+00, 7.7222118749E-01, 6.2513584863E-01, 6.7760135682E-01],
	[1.4470000000E+04, 8.0591392217E+00, 5.5384628578E+00, 7.7306403684E-01, 6.2570699287E-01, 6.7774353022E-01],
	[1.4475000000E+04, 8.0629194990E+00, 5.5381584520E+00, 7.7390751307E-01, 6.2627836856E-01, 6.7788566238E-01],
	[1.4480000000E+04, 8.0667002430E+00, 5.5378541680E+00, 7.7475161640E-01, 6.2684997553E-01, 6.7802775327E-01],
	[1.4485000000E+04, 8.0704814536E+00, 5.5375500058E+00, 7.7559634710E-01, 6.2742181364E-01, 6.7816980289E-01],
	[1.4490000000E+04, 8.0742631307E+00, 5.5372459652E+00, 7.7644170540E-01, 6.2799388273E-01, 6.7831181122E-01],
	[1.4495000000E+04, 8.0780452742E+00, 5.5369420462E+00, 7.7728769156E-01, 6.2856618266E-01, 6.7845377826E-01],
	[1.4500000000E+04, 8.0818278840E+00, 5.5366382487E+00, 7.7813430582E-01, 6.2913871327E-01, 6.7859570399E-01],
	[1.4505000000E+04, 8.0856109600E+00, 5.5363345726E+00, 7.7898154843E-01, 6.2971147442E-01, 6.7873758840E-01],
	[1.4510000000E+04, 8.0893945021E+00, 5.5360310179E+00, 7.7982941964E-01, 6.3028446594E-01, 6.7887943147E-01],
	[1.4515000000E+04, 8.0931785102E+00, 5.5357275843E+00, 7.8067791970E-01, 6.3085768768E-01, 6.7902123320E-01],
	[1.4520000000E+04, 8.0969629842E+00, 5.5354242719E+00, 7.8152704886E-01, 6.3143113950E-01, 6.7916299357E-01],
	[1.4525000000E+04, 8.1007479240E+00, 5.5351210805E+00, 7.8237680735E-01, 6.3200482124E-01, 6.7930471257E-01],
	[1.4530000000E+04, 8.1045333295E+00, 5.5348180100E+00, 7.8322719544E-01, 6.3257873275E-01, 6.7944639020E-01],
	[1.4535000000E+04, 8.1083192005E+00, 5.5345150605E+00, 7.8407821336E-01, 6.3315287388E-01, 6.7958802642E-01],
	[1.4540000000E+04, 8.1121055370E+00, 5.5342122317E+00, 7.8492986138E-01, 6.3372724447E-01, 6.7972962125E-01],
	[1.4545000000E+04, 8.1158923389E+00, 5.5339095235E+00, 7.8578213972E-01, 6.3430184437E-01, 6.7987117466E-01],
	[1.4550000000E+04, 8.1196796061E+00, 5.5336069360E+00, 7.8663504865E-01, 6.3487667343E-01, 6.8001268664E-01],
	[1.4555000000E+04, 8.1234673384E+00, 5.5333044689E+00, 7.8748858841E-01, 6.3545173149E-01, 6.8015415718E-01],
	[1.4560000000E+04, 8.1272555358E+00, 5.5330021223E+00, 7.8834275924E-01, 6.3602701840E-01, 6.8029558627E-01],
	[1.4565000000E+04, 8.1310441982E+00, 5.5326998960E+00, 7.8919756141E-01, 6.3660253400E-01, 6.8043697389E-01],
	[1.4570000000E+04, 8.1348333254E+00, 5.5323977899E+00, 7.9005299514E-01, 6.3717827815E-01, 6.8057832004E-01],
	[1.4575000000E+04, 8.1386229174E+00, 5.5320958040E+00, 7.9090906070E-01, 6.3775425069E-01, 6.8071962467E-01],
	[1.4580000000E+04, 8.1424217968E+00, 5.5317973843E+00, 7.9176575833E-01, 6.3833055158E-01, 6.8086088779E-01],
	[1.4585000000E+04, 8.1462271561E+00, 5.5315014293E+00, 7.9262308828E-01, 6.3890714909E-01, 6.8100210937E-01],
	[1.4590000000E+04, 8.1500329885E+00, 5.5312055915E+00, 7.9348105079E-01, 6.3948397501E-01, 6.8114328939E-01],
	[1.4595000000E+04, 8.1538392941E+00, 5.5309098709E+00, 7.9433964612E-01, 6.4006102917E-01, 6.8128442785E-01],
	[1.4600000000E+04, 8.1576460726E+00, 5.5306142675E+00, 7.9519887451E-01, 6.4063831143E-01, 6.8142552473E-01],
	[1.4605000000E+04, 8.1614533240E+00, 5.5303187810E+00, 7.9605873621E-01, 6.4121582162E-01, 6.8156658001E-01],
	[1.4610000000E+04, 8.1652610483E+00, 5.5300234115E+00, 7.9691923147E-01, 6.4179355960E-01, 6.8170759368E-01],
	[1.4615000000E+04, 8.1690692452E+00, 5.5297281588E+00, 7.9778036054E-01, 6.4237152521E-01, 6.8184856572E-01],
	[1.4620000000E+04, 8.1728779146E+00, 5.5294330228E+00, 7.9864212366E-01, 6.4294971829E-01, 6.8198949612E-01],
	[1.4625000000E+04, 8.1766870566E+00, 5.5291380035E+00, 7.9950452108E-01, 6.4352813869E-01, 6.8213038486E-01],
	[1.4630000000E+04, 8.1804966709E+00, 5.5288431008E+00, 8.0036755306E-01, 6.4410678625E-01, 6.8227123193E-01],
	[1.4635000000E+04, 8.1843067575E+00, 5.5285483145E+00, 8.0123121983E-01, 6.4468566083E-01, 6.8241203732E-01],
	[1.4640000000E+04, 8.1881173162E+00, 5.5282536447E+00, 8.0209552165E-01, 6.4526476226E-01, 6.8255280100E-01],
	[1.4645000000E+04, 8.1919283470E+00, 5.5279590912E+00, 8.0296045877E-01, 6.4584409038E-01, 6.8269352297E-01],
	[1.4650000000E+04, 8.1957398498E+00, 5.5276646539E+00, 8.0382603143E-01, 6.4642364505E-01, 6.8283420321E-01],
	[1.4655000000E+04, 8.1995518245E+00, 5.5273703328E+00, 8.0469223988E-01, 6.4700342611E-01, 6.8297484170E-01],
	[1.4660000000E+04, 8.2033642709E+00, 5.5270761278E+00, 8.0555908437E-01, 6.4758343340E-01, 6.8311543844E-01],
	[1.4665000000E+04, 8.2071771889E+00, 5.5267820387E+00, 8.0642656515E-01, 6.4816366677E-01, 6.8325599340E-01],
	[1.4670000000E+04, 8.2109905785E+00, 5.5264880655E+00, 8.0729468247E-01, 6.4874412606E-01, 6.8339650657E-01],
	[1.4675000000E+04, 8.2148044396E+00, 5.5261942081E+00, 8.0816343657E-01, 6.4932481111E-01, 6.8353697794E-01],
	[1.4680000000E+04, 8.2186187719E+00, 5.5259004664E+00, 8.0903282770E-01, 6.4990572176E-01, 6.8367740749E-01],
	[1.4685000000E+04, 8.2224335756E+00, 5.5256068404E+00, 8.0990285612E-01, 6.5048685787E-01, 6.8381779521E-01],
	[1.4690000000E+04, 8.2262488504E+00, 5.5253133299E+00, 8.1077352206E-01, 6.5106821927E-01, 6.8395814109E-01],
	[1.4695000000E+04, 8.2300645962E+00, 5.5250199349E+00, 8.1164482578E-01, 6.5164980581E-01, 6.8409844510E-01],
	[1.4700000000E+04, 8.2338808129E+00, 5.5247266553E+00, 8.1251676753E-01, 6.5223161733E-01, 6.8423870725E-01],
	[1.4705000000E+04, 8.2376975005E+00, 5.5244334910E+00, 8.1338934755E-01, 6.5281365367E-01, 6.8437892750E-01],
	[1.4710000000E+04, 8.2415146588E+00, 5.5241404418E+00, 8.1426256610E-01, 6.5339591468E-01, 6.8451910586E-01],
	[1.4715000000E+04, 8.2453322878E+00, 5.5238475079E+00, 8.1513642341E-01, 6.5397840019E-01, 6.8465924230E-01],
	[1.4720000000E+04, 8.2491503873E+00, 5.5235546889E+00, 8.1601091975E-01, 6.5456111006E-01, 6.8479933681E-01],
	[1.4725000000E+04, 8.2529689572E+00, 5.5232619849E+00, 8.1688605535E-01, 6.5514404412E-01, 6.8493938937E-01],
	[1.4730000000E+04, 8.2567879974E+00, 5.5229693958E+00, 8.1776183046E-01, 6.5572720221E-01, 6.8507939998E-01],
	[1.4735000000E+04, 8.2606075079E+00, 5.5226769215E+00, 8.1863824534E-01, 6.5631058419E-01, 6.8521936862E-01],
	[1.4740000000E+04, 8.2644274885E+00, 5.5223845619E+00, 8.1951530024E-01, 6.5689418988E-01, 6.8535929527E-01],
	[1.4745000000E+04, 8.2682479391E+00, 5.5220923169E+00, 8.2039299539E-01, 6.5747801913E-01, 6.8549917993E-01],
	[1.4750000000E+04, 8.2720688596E+00, 5.5218001865E+00, 8.2127133105E-01, 6.5806207178E-01, 6.8563902258E-01],
	[1.4755000000E+04, 8.2758902499E+00, 5.5215081705E+00, 8.2215030748E-01, 6.5864634768E-01, 6.8577882319E-01],
	[1.4760000000E+04, 8.2797121100E+00, 5.5212162689E+00, 8.2302992490E-01, 6.5923084666E-01, 6.8591858177E-01],
	[1.4765000000E+04, 8.2835344396E+00, 5.5209244816E+00, 8.2391018358E-01, 6.5981556857E-01, 6.8605829830E-01],
	[1.4770000000E+04, 8.2873572388E+00, 5.5206328085E+00, 8.2479108377E-01, 6.6040051325E-01, 6.8619797276E-01],
	[1.4775000000E+04, 8.2911805074E+00, 5.5203412495E+00, 8.2567262570E-01, 6.6098568053E-01, 6.8633760515E-01],
	[1.4780000000E+04, 8.2950042453E+00, 5.5200498046E+00, 8.2655480964E-01, 6.6157107027E-01, 6.8647719544E-01],
	[1.4785000000E+04, 8.2988284524E+00, 5.5197584736E+00, 8.2743763582E-01, 6.6215668229E-01, 6.8661674362E-01],
	[1.4790000000E+04, 8.3026531287E+00, 5.5194672564E+00, 8.2832110450E-01, 6.6274251644E-01, 6.8675624969E-01],
	[1.4795000000E+04, 8.3064782739E+00, 5.5191761531E+00, 8.2920521593E-01, 6.6332857256E-01, 6.8689571362E-01],
	[1.4800000000E+04, 8.3103038880E+00, 5.5188851635E+00, 8.3008997034E-01, 6.6391485050E-01, 6.8703513541E-01],
	[1.4805000000E+04, 8.3141299710E+00, 5.5185942875E+00, 8.3097536800E-01, 6.6450135008E-01, 6.8717451504E-01],
	[1.4810000000E+04, 8.3179565226E+00, 5.5183035251E+00, 8.3186140915E-01, 6.6508807116E-01, 6.8731385250E-01],
	[1.4815000000E+04, 8.3217937238E+00, 5.5180166627E+00, 8.3274809405E-01, 6.6567513381E-01, 6.8745314778E-01],
	[1.4820000000E+04, 8.3256366262E+00, 5.5177318552E+00, 8.3363542292E-01, 6.6626247977E-01, 6.8759240086E-01],
	[1.4825000000E+04, 8.3294800060E+00, 5.5174471584E+00, 8.3452339604E-01, 6.6685004724E-01, 6.8773161173E-01],
	[1.4830000000E+04, 8.3333238631E+00, 5.5171625723E+00, 8.3541201364E-01, 6.6743783606E-01, 6.8787078037E-01],
	[1.4835000000E+04, 8.3371681974E+00, 5.5168780968E+00, 8.3630127597E-01, 6.6802584607E-01, 6.8800990678E-01],
	[1.4840000000E+04, 8.3410130088E+00, 5.5165937318E+00, 8.3719118328E-01, 6.6861407710E-01, 6.8814899095E-01],
	[1.4845000000E+04, 8.3448582972E+00, 5.5163094772E+00, 8.3808173583E-01, 6.6920252900E-01, 6.8828803285E-01],
	[1.4850000000E+04, 8.3487040625E+00, 5.5160253331E+00, 8.3897293385E-01, 6.6979120161E-01, 6.8842703248E-01],
	[1.4855000000E+04, 8.3525503045E+00, 5.5157412992E+00, 8.3986477760E-01, 6.7038009476E-01, 6.8856598982E-01],
	[1.4860000000E+04, 8.3563970233E+00, 5.5154573755E+00, 8.4075726733E-01, 6.7096920830E-01, 6.8870490486E-01],
	[1.4865000000E+04, 8.3602442186E+00, 5.5151735619E+00, 8.4165040328E-01, 6.7155854206E-01, 6.8884377759E-01],
	[1.4870000000E+04, 8.3640918905E+00, 5.5148898584E+00, 8.4254418571E-01, 6.7214809589E-01, 6.8898260800E-01],
	[1.4875000000E+04, 8.3679400387E+00, 5.5146062649E+00, 8.4343861485E-01, 6.7273786962E-01, 6.8912139607E-01],
	[1.4880000000E+04, 8.3717886632E+00, 5.5143227812E+00, 8.4433369097E-01, 6.7332786309E-01, 6.8926014180E-01],
	[1.4885000000E+04, 8.3756377639E+00, 5.5140394073E+00, 8.4522941431E-01, 6.7391807614E-01, 6.8939884516E-01],
	[1.4890000000E+04, 8.3794873406E+00, 5.5137561432E+00, 8.4612578512E-01, 6.7450850860E-01, 6.8953750615E-01],
	[1.4895000000E+04, 8.3833373934E+00, 5.5134729887E+00, 8.4702280364E-01, 6.7509916033E-01, 6.8967612475E-01],
	[1.4900000000E+04, 8.3871879220E+00, 5.5131899438E+00, 8.4792047013E-01, 6.7569003114E-01, 6.8981470096E-01],
	[1.4905000000E+04, 8.3910389264E+00, 5.5129070084E+00, 8.4881878484E-01, 6.7628112089E-01, 6.8995323476E-01],
	[1.4910000000E+04, 8.3948904065E+00, 5.5126241824E+00, 8.4971774800E-01, 6.7687242940E-01, 6.9009172614E-01],
	[1.4915000000E+04, 8.3987423622E+00, 5.5123414657E+00, 8.5061735988E-01, 6.7746395653E-01, 6.9023017508E-01],
	[1.4920000000E+04, 8.4025947933E+00, 5.5120588582E+00, 8.5151762072E-01, 6.7805570210E-01, 6.9036858158E-01],
	[1.4925000000E+04, 8.4064476998E+00, 5.5117763600E+00, 8.5241853077E-01, 6.7864766594E-01, 6.9050694562E-01],
	[1.4930000000E+04, 8.4103010816E+00, 5.5114939708E+00, 8.5332009028E-01, 6.7923984791E-01, 6.9064526719E-01],
	[1.4935000000E+04, 8.4141549386E+00, 5.5112116906E+00, 8.5422229949E-01, 6.7983224784E-01, 6.9078354628E-01],
	[1.4940000000E+04, 8.4180092706E+00, 5.5109295194E+00, 8.5512515866E-01, 6.8042486556E-01, 6.9092178288E-01],
	[1.4945000000E+04, 8.4218640777E+00, 5.5106474571E+00, 8.5602866803E-01, 6.8101770090E-01, 6.9105997697E-01],
	[1.4950000000E+04, 8.4257193595E+00, 5.5103655035E+00, 8.5693282786E-01, 6.8161075372E-01, 6.9119812855E-01],
	[1.4955000000E+04, 8.4295751162E+00, 5.5100836586E+00, 8.5783763839E-01, 6.8220402384E-01, 6.9133623760E-01],
	[1.4960000000E+04, 8.4334313475E+00, 5.5098019224E+00, 8.5874309987E-01, 6.8279751110E-01, 6.9147430411E-01],
	[1.4965000000E+04, 8.4372880535E+00, 5.5095202947E+00, 8.5964921254E-01, 6.8339121533E-01, 6.9161232807E-01],
	[1.4970000000E+04, 8.4411452338E+00, 5.5092387754E+00, 8.6055597667E-01, 6.8398513638E-01, 6.9175030946E-01],
	[1.4975000000E+04, 8.4450028886E+00, 5.5089573646E+00, 8.6146339250E-01, 6.8457927407E-01, 6.9188824828E-01],
	[1.4980000000E+04, 8.4488610176E+00, 5.5086760620E+00, 8.6237146027E-01, 6.8517362825E-01, 6.9202614452E-01],
	[1.4985000000E+04, 8.4527196208E+00, 5.5083948677E+00, 8.6328018024E-01, 6.8576819875E-01, 6.9216399816E-01],
	[1.4990000000E+04, 8.4565786981E+00, 5.5081137816E+00, 8.6418955265E-01, 6.8636298540E-01, 6.9230180919E-01],
	[1.4995000000E+04, 8.4604382493E+00, 5.5078328035E+00, 8.6509957775E-01, 6.8695798805E-01, 6.9243957761E-01],
	[1.5000000000E+04, 8.4642982744E+00, 5.5075519335E+00, 8.6601025580E-01, 6.8755320652E-01, 6.9257730339E-01],
	[1.5005000000E+04, 8.4681587733E+00, 5.5072711713E+00, 8.6692457924E-01, 6.8815052602E-01, 6.9271498653E-01],
	[1.5010000000E+04, 8.4720197459E+00, 5.5069905170E+00, 8.6783956152E-01, 6.8874806301E-01, 6.9285262702E-01],
	[1.5015000000E+04, 8.4758811920E+00, 5.5067099705E+00, 8.6875520288E-01, 6.8934581732E-01, 6.9299022484E-01],
	[1.5020000000E+04, 8.4797431116E+00, 5.5064295317E+00, 8.6967150359E-01, 6.8994378878E-01, 6.9312777999E-01],
	[1.5025000000E+04, 8.4836055046E+00, 5.5061492004E+00, 8.7058846389E-01, 6.9054197723E-01, 6.9326529246E-01],
	[1.5030000000E+04, 8.4874683709E+00, 5.5058689767E+00, 8.7150608403E-01, 6.9114038251E-01, 6.9340276222E-01],
	[1.5035000000E+04, 8.4913317103E+00, 5.5055888605E+00, 8.7242436427E-01, 6.9173900444E-01, 6.9354018928E-01],
	[1.5040000000E+04, 8.4951955228E+00, 5.5053088517E+00, 8.7334330487E-01, 6.9233784285E-01, 6.9367757362E-01],
	[1.5045000000E+04, 8.4990598083E+00, 5.5050289501E+00, 8.7426290608E-01, 6.9293689759E-01, 6.9381491523E-01],
	[1.5050000000E+04, 8.5029245666E+00, 5.5047491558E+00, 8.7518316814E-01, 6.9353616848E-01, 6.9395221411E-01],
	[1.5055000000E+04, 8.5068052936E+00, 5.5044749745E+00, 8.7610409133E-01, 6.9413584609E-01, 6.9408947023E-01],
	[1.5060000000E+04, 8.5106869618E+00, 5.5042010611E+00, 8.7702567587E-01, 6.9473574569E-01, 6.9422668359E-01],
	[1.5065000000E+04, 8.5145691118E+00, 5.5039272522E+00, 8.7794792204E-01, 6.9533586147E-01, 6.9436385417E-01],
	[1.5070000000E+04, 8.5184517435E+00, 5.5036535478E+00, 8.7887083009E-01, 6.9593619326E-01, 6.9450098198E-01],
	[1.5075000000E+04, 8.5223348568E+00, 5.5033799478E+00, 8.7979440026E-01, 6.9653674089E-01, 6.9463806699E-01],
	[1.5080000000E+04, 8.5262184516E+00, 5.5031064521E+00, 8.8071863282E-01, 6.9713750420E-01, 6.9477510920E-01],
	[1.5085000000E+04, 8.5301025278E+00, 5.5028330607E+00, 8.8164352801E-01, 6.9773848302E-01, 6.9491210859E-01],
	[1.5090000000E+04, 8.5339870853E+00, 5.5025597735E+00, 8.8256908610E-01, 6.9833967719E-01, 6.9504906516E-01],
	[1.5095000000E+04, 8.5378721240E+00, 5.5022865903E+00, 8.8349530732E-01, 6.9894108652E-01, 6.9518597889E-01],
	[1.5100000000E+04, 8.5417576438E+00, 5.5020135112E+00, 8.8442219194E-01, 6.9954271087E-01, 6.9532284978E-01],
	[1.5105000000E+04, 8.5456436447E+00, 5.5017405360E+00, 8.8534974022E-01, 7.0014455005E-01, 6.9545967782E-01],
	[1.5110000000E+04, 8.5495301264E+00, 5.5014676647E+00, 8.8627795239E-01, 7.0074660391E-01, 6.9559646299E-01],
	[1.5115000000E+04, 8.5534170890E+00, 5.5011948973E+00, 8.8720682873E-01, 7.0134887227E-01, 6.9573320528E-01],
	[1.5120000000E+04, 8.5573045323E+00, 5.5009222335E+00, 8.8813636947E-01, 7.0195135496E-01, 6.9586990469E-01],
	[1.5125000000E+04, 8.5611924562E+00, 5.5006496734E+00, 8.8906657488E-01, 7.0255405182E-01, 6.9600656120E-01],
	[1.5130000000E+04, 8.5650808606E+00, 5.5003772169E+00, 8.8999744521E-01, 7.0315696267E-01, 6.9614317480E-01],
	[1.5135000000E+04, 8.5689697454E+00, 5.5001048640E+00, 8.9092898072E-01, 7.0376008736E-01, 6.9627974549E-01],
	[1.5140000000E+04, 8.5728591105E+00, 5.4998326144E+00, 8.9186118165E-01, 7.0436342570E-01, 6.9641627325E-01],
	[1.5145000000E+04, 8.5767489558E+00, 5.4995604682E+00, 8.9279404826E-01, 7.0496697754E-01, 6.9655275808E-01],
	[1.5150000000E+04, 8.5806392813E+00, 5.4992884253E+00, 8.9372758080E-01, 7.0557074270E-01, 6.9668919996E-01],
	[1.5155000000E+04, 8.5845300867E+00, 5.4990164857E+00, 8.9466177953E-01, 7.0617472101E-01, 6.9682559889E-01],
	[1.5160000000E+04, 8.5884213721E+00, 5.4987446491E+00, 8.9559664470E-01, 7.0677891231E-01, 6.9696195485E-01],
	[1.5165000000E+04, 8.5923131373E+00, 5.4984729157E+00, 8.9653217657E-01, 7.0738331642E-01, 6.9709826784E-01],
	[1.5170000000E+04, 8.5962053822E+00, 5.4982012852E+00, 8.9746837539E-01, 7.0798793317E-01, 6.9723453784E-01],
	[1.5175000000E+04, 8.6000981067E+00, 5.4979297577E+00, 8.9840524141E-01, 7.0859276240E-01, 6.9737076485E-01],
	[1.5180000000E+04, 8.6039913108E+00, 5.4976583330E+00, 8.9934277489E-01, 7.0919780394E-01, 6.9750694885E-01],
	[1.5185000000E+04, 8.6078849942E+00, 5.4973870111E+00, 9.0028097607E-01, 7.0980305761E-01, 6.9764308985E-01],
	[1.5190000000E+04, 8.6117791570E+00, 5.4971157920E+00, 9.0121984523E-01, 7.1040852324E-01, 6.9777918781E-01],
	[1.5195000000E+04, 8.6156737990E+00, 5.4968446754E+00, 9.0215938260E-01, 7.1101420067E-01, 6.9791524275E-01],
	[1.5200000000E+04, 8.6195689202E+00, 5.4965736614E+00, 9.0309958844E-01, 7.1162008973E-01, 6.9805125465E-01],
	[1.5205000000E+04, 8.6234645203E+00, 5.4963027499E+00, 9.0404046301E-01, 7.1222619024E-01, 6.9818722349E-01],
	[1.5210000000E+04, 8.6273605994E+00, 5.4960319408E+00, 9.0498200656E-01, 7.1283250203E-01, 6.9832314927E-01],
	[1.5215000000E+04, 8.6312571573E+00, 5.4957612341E+00, 9.0592421934E-01, 7.1343902493E-01, 6.9845903199E-01],
	[1.5220000000E+04, 8.6351541940E+00, 5.4954906296E+00, 9.0686710161E-01, 7.1404575878E-01, 6.9859487162E-01],
	[1.5225000000E+04, 8.6390517092E+00, 5.4952201274E+00, 9.0781065362E-01, 7.1465270340E-01, 6.9873066817E-01],
	[1.5230000000E+04, 8.6429497030E+00, 5.4949497273E+00, 9.0875487563E-01, 7.1525985862E-01, 6.9886642162E-01],
	[1.5235000000E+04, 8.6468481753E+00, 5.4946794292E+00, 9.0969976789E-01, 7.1586722426E-01, 6.9900213196E-01],
	[1.5240000000E+04, 8.6507471259E+00, 5.4944092331E+00, 9.1064533065E-01, 7.1647480017E-01, 6.9913779919E-01],
	[1.5245000000E+04, 8.6546465547E+00, 5.4941391389E+00, 9.1159156417E-01, 7.1708258616E-01, 6.9927342330E-01],
	[1.5250000000E+04, 8.6585464616E+00, 5.4938691466E+00, 9.1253846870E-01, 7.1769058206E-01, 6.9940900427E-01],
	[1.5255000000E+04, 8.6624468466E+00, 5.4935992560E+00, 9.1348604450E-01, 7.1829878771E-01, 6.9954454210E-01],
	[1.5260000000E+04, 8.6663477096E+00, 5.4933294671E+00, 9.1443429182E-01, 7.1890720293E-01, 6.9968003678E-01],
	[1.5265000000E+04, 8.6702490503E+00, 5.4930597799E+00, 9.1538321091E-01, 7.1951582755E-01, 6.9981548830E-01],
	[1.5270000000E+04, 8.6741508689E+00, 5.4927901942E+00, 9.1633280203E-01, 7.2012466139E-01, 6.9995089665E-01],
	[1.5275000000E+04, 8.6780531650E+00, 5.4925207100E+00, 9.1728306543E-01, 7.2073370429E-01, 7.0008626182E-01],
	[1.5280000000E+04, 8.6819559388E+00, 5.4922513272E+00, 9.1823400136E-01, 7.2134295607E-01, 7.0022158381E-01],
	[1.5285000000E+04, 8.6858591899E+00, 5.4919820457E+00, 9.1918561009E-01, 7.2195241656E-01, 7.0035686260E-01],
	[1.5290000000E+04, 8.6897629185E+00, 5.4917128655E+00, 9.2013789186E-01, 7.2256208559E-01, 7.0049209819E-01],
	[1.5295000000E+04, 8.6936755678E+00, 5.4914466705E+00, 9.2109084693E-01, 7.2317207142E-01, 7.0062729057E-01],
	[1.5300000000E+04, 8.6975966901E+00, 5.4911833033E+00, 9.2204447555E-01, 7.2378236846E-01, 7.0076243972E-01],
	[1.5305000000E+04, 8.7015182988E+00, 5.4909200348E+00, 9.2299877798E-01, 7.2439287407E-01, 7.0089754565E-01],
	[1.5310000000E+04, 8.7054403939E+00, 5.4906568648E+00, 9.2395375446E-01, 7.2500358808E-01, 7.0103260834E-01],
	[1.5315000000E+04, 8.7093629753E+00, 5.4903937935E+00, 9.2490940527E-01, 7.2561451031E-01, 7.0116762779E-01],
	[1.5320000000E+04, 8.7132860429E+00, 5.4901308206E+00, 9.2586573064E-01, 7.2622564059E-01, 7.0130260398E-01],
	[1.5325000000E+04, 8.7172095965E+00, 5.4898679461E+00, 9.2682273083E-01, 7.2683697875E-01, 7.0143753691E-01],
	[1.5330000000E+04, 8.7211336362E+00, 5.4896051699E+00, 9.2778040610E-01, 7.2744852462E-01, 7.0157242657E-01],
	[1.5335000000E+04, 8.7250581617E+00, 5.4893424920E+00, 9.2873875671E-01, 7.2806027802E-01, 7.0170727295E-01],
	[1.5340000000E+04, 8.7289831730E+00, 5.4890799123E+00, 9.2969778290E-01, 7.2867223878E-01, 7.0184207604E-01],
	[1.5345000000E+04, 8.7329086701E+00, 5.4888174308E+00, 9.3065748493E-01, 7.2928440673E-01, 7.0197683584E-01],
	[1.5350000000E+04, 8.7368346527E+00, 5.4885550473E+00, 9.3161786305E-01, 7.2989678169E-01, 7.0211155233E-01],
	[1.5355000000E+04, 8.7407611208E+00, 5.4882927617E+00, 9.3257891752E-01, 7.3050936350E-01, 7.0224622551E-01],
	[1.5360000000E+04, 8.7446880743E+00, 5.4880305741E+00, 9.3354064859E-01, 7.3112215197E-01, 7.0238085538E-01],
	[1.5365000000E+04, 8.7486155131E+00, 5.4877684844E+00, 9.3450305652E-01, 7.3173514693E-01, 7.0251544191E-01],
	[1.5370000000E+04, 8.7525434371E+00, 5.4875064924E+00, 9.3546614157E-01, 7.3234834821E-01, 7.0264998511E-01],
	[1.5375000000E+04, 8.7564718463E+00, 5.4872445982E+00, 9.3642990397E-01, 7.3296175564E-01, 7.0278448497E-01],
	[1.5380000000E+04, 8.7604007404E+00, 5.4869828016E+00, 9.3739434400E-01, 7.3357536904E-01, 7.0291894148E-01],
	[1.5385000000E+04, 8.7643301194E+00, 5.4867211025E+00, 9.3835946190E-01, 7.3418918823E-01, 7.0305335463E-01],
	[1.5390000000E+04, 8.7682599833E+00, 5.4864595010E+00, 9.3932525793E-01, 7.3480321305E-01, 7.0318772441E-01],
	[1.5395000000E+04, 8.7721903318E+00, 5.4861979970E+00, 9.4029173234E-01, 7.3541744332E-01, 7.0332205081E-01],
	[1.5400000000E+04, 8.7761211650E+00, 5.4859365903E+00, 9.4125888539E-01, 7.3603187885E-01, 7.0345633384E-01],
	[1.5405000000E+04, 8.7800524827E+00, 5.4856752809E+00, 9.4222671733E-01, 7.3664651949E-01, 7.0359057348E-01],
	[1.5410000000E+04, 8.7839842848E+00, 5.4854140688E+00, 9.4319522842E-01, 7.3726136505E-01, 7.0372476971E-01],
	[1.5415000000E+04, 8.7879165712E+00, 5.4851529538E+00, 9.4416441891E-01, 7.3787641536E-01, 7.0385892255E-01],
	[1.5420000000E+04, 8.7918493419E+00, 5.4848919359E+00, 9.4513428905E-01, 7.3849167025E-01, 7.0399303197E-01],
	[1.5425000000E+04, 8.7957825967E+00, 5.4846310151E+00, 9.4610483910E-01, 7.3910712953E-01, 7.0412709797E-01],
	[1.5430000000E+04, 8.7997163355E+00, 5.4843701912E+00, 9.4707606931E-01, 7.3972279304E-01, 7.0426112055E-01],
	[1.5435000000E+04, 8.8036505583E+00, 5.4841094643E+00, 9.4804797994E-01, 7.4033866059E-01, 7.0439509969E-01],
	[1.5440000000E+04, 8.8075852648E+00, 5.4838488342E+00, 9.4902057125E-01, 7.4095473202E-01, 7.0452903539E-01],
	[1.5445000000E+04, 8.8115204552E+00, 5.4835883008E+00, 9.4999384348E-01, 7.4157100714E-01, 7.0466292764E-01],
	[1.5450000000E+04, 8.8154561291E+00, 5.4833278642E+00, 9.5096779689E-01, 7.4218748579E-01, 7.0479677643E-01],
	[1.5455000000E+04, 8.8193922866E+00, 5.4830675241E+00, 9.5194243173E-01, 7.4280416778E-01, 7.0493058175E-01],
	[1.5460000000E+04, 8.8233289276E+00, 5.4828072807E+00, 9.5291774827E-01, 7.4342105294E-01, 7.0506434359E-01],
	[1.5465000000E+04, 8.8272660519E+00, 5.4825471337E+00, 9.5389374675E-01, 7.4403814109E-01, 7.0519806194E-01],
	[1.5470000000E+04, 8.8312036595E+00, 5.4822870832E+00, 9.5487042743E-01, 7.4465543206E-01, 7.0533173678E-01],
	[1.5475000000E+04, 8.8351417502E+00, 5.4820271291E+00, 9.5584779057E-01, 7.4527292567E-01, 7.0546536811E-01],
	[1.5480000000E+04, 8.8390803240E+00, 5.4817672712E+00, 9.5682583641E-01, 7.4589062175E-01, 7.0559895592E-01],
	[1.5485000000E+04, 8.8430193807E+00, 5.4815075096E+00, 9.5780456521E-01, 7.4650852011E-01, 7.0573250019E-01],
	[1.5490000000E+04, 8.8469589203E+00, 5.4812478441E+00, 9.5878397723E-01, 7.4712662059E-01, 7.0586600092E-01],
	[1.5495000000E+04, 8.8508989427E+00, 5.4809882747E+00, 9.5976407273E-01, 7.4774492300E-01, 7.0599945810E-01],
	[1.5500000000E+04, 8.8548394478E+00, 5.4807288014E+00, 9.6074485195E-01, 7.4836342717E-01, 7.0613287172E-01],
	[1.5505000000E+04, 8.8587804354E+00, 5.4804694240E+00, 9.6172631515E-01, 7.4898213291E-01, 7.0626624176E-01],
	[1.5510000000E+04, 8.8627219055E+00, 5.4802101426E+00, 9.6270846258E-01, 7.4960104006E-01, 7.0639956822E-01],
	[1.5515000000E+04, 8.8666638580E+00, 5.4799509569E+00, 9.6369129451E-01, 7.5022014844E-01, 7.0653285109E-01],
	[1.5520000000E+04, 8.8706062928E+00, 5.4796918671E+00, 9.6467481118E-01, 7.5083945787E-01, 7.0666609036E-01],
	[1.5525000000E+04, 8.8745492097E+00, 5.4794328729E+00, 9.6565901285E-01, 7.5145896816E-01, 7.0679928602E-01],
	[1.5530000000E+04, 8.8784926088E+00, 5.4791739744E+00, 9.6664389978E-01, 7.5207867916E-01, 7.0693243806E-01],
	[1.5535000000E+04, 8.8824364898E+00, 5.4789151714E+00, 9.6762947221E-01, 7.5269859066E-01, 7.0706554647E-01],
	[1.5540000000E+04, 8.8863855255E+00, 5.4786579996E+00, 9.6861573041E-01, 7.5331876512E-01, 7.0719861124E-01],
	[1.5545000000E+04, 8.8903472831E+00, 5.4784049426E+00, 9.6960267462E-01, 7.5393930405E-01, 7.0733163236E-01],
	[1.5550000000E+04, 8.8943095320E+00, 5.4781519786E+00, 9.7059030511E-01, 7.5456004353E-01, 7.0746460982E-01],
	[1.5555000000E+04, 8.8982722721E+00, 5.4778991076E+00, 9.7157862212E-01, 7.5518098339E-01, 7.0759754362E-01],
	[1.5560000000E+04, 8.9022355034E+00, 5.4776463296E+00, 9.7256762592E-01, 7.5580212346E-01, 7.0773043374E-01],
	[1.5565000000E+04, 8.9061992257E+00, 5.4773936444E+00, 9.7355731675E-01, 7.5642346355E-01, 7.0786328017E-01],
	[1.5570000000E+04, 8.9101634389E+00, 5.4771410521E+00, 9.7454769488E-01, 7.5704500348E-01, 7.0799608291E-01],
	[1.5575000000E+04, 8.9141281429E+00, 5.4768885525E+00, 9.7553876055E-01, 7.5766674309E-01, 7.0812884195E-01],
	[1.5580000000E+04, 8.9180933376E+00, 5.4766361455E+00, 9.7653051402E-01, 7.5828868219E-01, 7.0826155728E-01],
	[1.5585000000E+04, 8.9220590230E+00, 5.4763838312E+00, 9.7752295555E-01, 7.5891082061E-01, 7.0839422888E-01],
	[1.5590000000E+04, 8.9260251989E+00, 5.4761316095E+00, 9.7851608539E-01, 7.5953315816E-01, 7.0852685675E-01],
	[1.5595000000E+04, 8.9299918653E+00, 5.4758794802E+00, 9.7950990379E-01, 7.6015569466E-01, 7.0865944088E-01],
	[1.5600000000E+04, 8.9339590220E+00, 5.4756274433E+00, 9.8050441101E-01, 7.6077842995E-01, 7.0879198127E-01],
	[1.5605000000E+04, 8.9379266689E+00, 5.4753754989E+00, 9.8149960731E-01, 7.6140136383E-01, 7.0892447789E-01],
	[1.5610000000E+04, 8.9418948060E+00, 5.4751236467E+00, 9.8249549294E-01, 7.6202449614E-01, 7.0905693075E-01],
	[1.5615000000E+04, 8.9458634331E+00, 5.4748718867E+00, 9.8349206815E-01, 7.6264782668E-01, 7.0918933984E-01],
	[1.5620000000E+04, 8.9498325502E+00, 5.4746202190E+00, 9.8448933321E-01, 7.6327135530E-01, 7.0932170514E-01],
	[1.5625000000E+04, 8.9538021572E+00, 5.4743686433E+00, 9.8548728836E-01, 7.6389508179E-01, 7.0945402665E-01],
	[1.5630000000E+04, 8.9577722539E+00, 5.4741171597E+00, 9.8648593385E-01, 7.6451900599E-01, 7.0958630436E-01],
	[1.5635000000E+04, 8.9617428403E+00, 5.4738657680E+00, 9.8748526995E-01, 7.6514312772E-01, 7.0971853826E-01],
	[1.5640000000E+04, 8.9657139162E+00, 5.4736144683E+00, 9.8848529691E-01, 7.6576744679E-01, 7.0985072835E-01],
	[1.5645000000E+04, 8.9696854816E+00, 5.4733632605E+00, 9.8948601499E-01, 7.6639196304E-01, 7.0998287460E-01],
	[1.5650000000E+04, 8.9736575364E+00, 5.4731121444E+00, 9.9048742443E-01, 7.6701667627E-01, 7.1011497703E-01],
	[1.5655000000E+04, 8.9776300805E+00, 5.4728611201E+00, 9.9148952549E-01, 7.6764158630E-01, 7.1024703561E-01],
	[1.5660000000E+04, 8.9816031138E+00, 5.4726101874E+00, 9.9249231844E-01, 7.6826669297E-01, 7.1037905034E-01],
	[1.5665000000E+04, 8.9855766362E+00, 5.4723593464E+00, 9.9349580352E-01, 7.6889199609E-01, 7.1051102121E-01],
	[1.5670000000E+04, 8.9895506475E+00, 5.4721085969E+00, 9.9449998098E-01, 7.6951749547E-01, 7.1064294821E-01],
	[1.5675000000E+04, 8.9935251478E+00, 5.4718579388E+00, 9.9550485109E-01, 7.7014319094E-01, 7.1077483133E-01],
	[1.5680000000E+04, 8.9975001368E+00, 5.4716073722E+00, 9.9651041410E-01, 7.7076908232E-01, 7.1090667058E-01],
	[1.5685000000E+04, 9.0014756146E+00, 5.4713568970E+00, 9.9751667026E-01, 7.7139516943E-01, 7.1103846593E-01],
	[1.5690000000E+04, 9.0054515810E+00, 5.4711065130E+00, 9.9852361984E-01, 7.7202145209E-01, 7.1117021738E-01],
	[1.5695000000E+04, 9.0094280358E+00, 5.4708562203E+00, 9.9953126307E-01, 7.7264793011E-01, 7.1130192492E-01],
	[1.5700000000E+04, 9.0134049791E+00, 5.4706060187E+00, 1.0005396002E+00, 7.7327460332E-01, 7.1143358854E-01],
	[1.5705000000E+04, 9.0173824108E+00, 5.4703559082E+00, 1.0015486315E+00, 7.7390147153E-01, 7.1156520824E-01],
	[1.5710000000E+04, 9.0213603306E+00, 5.4701058888E+00, 1.0025583573E+00, 7.7452853457E-01, 7.1169678401E-01],
	[1.5715000000E+04, 9.0253387386E+00, 5.4698559604E+00, 1.0035687777E+00, 7.7515579226E-01, 7.1182831584E-01],
	[1.5720000000E+04, 9.0293176346E+00, 5.4696061229E+00, 1.0045798931E+00, 7.7578324441E-01, 7.1195980373E-01],
	[1.5725000000E+04, 9.0332970186E+00, 5.4693563762E+00, 1.0055917037E+00, 7.7641089084E-01, 7.1209124766E-01],
	[1.5730000000E+04, 9.0372768904E+00, 5.4691067204E+00, 1.0066042097E+00, 7.7703873136E-01, 7.1222264762E-01],
	[1.5735000000E+04, 9.0412572500E+00, 5.4688571553E+00, 1.0076174114E+00, 7.7766676581E-01, 7.1235400362E-01],
	[1.5740000000E+04, 9.0452380972E+00, 5.4686076808E+00, 1.0086313091E+00, 7.7829499400E-01, 7.1248531563E-01],
	[1.5745000000E+04, 9.0492194320E+00, 5.4683582970E+00, 1.0096459030E+00, 7.7892341574E-01, 7.1261658366E-01],
	[1.5750000000E+04, 9.0532012543E+00, 5.4681090037E+00, 1.0106611934E+00, 7.7955203086E-01, 7.1274780770E-01],
	[1.5755000000E+04, 9.0571835639E+00, 5.4678598009E+00, 1.0116771805E+00, 7.8018083917E-01, 7.1287898774E-01],
	[1.5760000000E+04, 9.0611663608E+00, 5.4676106885E+00, 1.0126938645E+00, 7.8080984050E-01, 7.1301012377E-01],
	[1.5765000000E+04, 9.0651496448E+00, 5.4673616665E+00, 1.0137112459E+00, 7.8143903465E-01, 7.1314121578E-01],
	[1.5770000000E+04, 9.0691334160E+00, 5.4671127348E+00, 1.0147293247E+00, 7.8206842145E-01, 7.1327226377E-01],
	[1.5775000000E+04, 9.0731176742E+00, 5.4668638933E+00, 1.0157481012E+00, 7.8269800071E-01, 7.1340326773E-01],
	[1.5780000000E+04, 9.0771024192E+00, 5.4666151420E+00, 1.0167675757E+00, 7.8332777225E-01, 7.1353422765E-01],
	[1.5785000000E+04, 9.0810876511E+00, 5.4663664809E+00, 1.0177877485E+00, 7.8395773590E-01, 7.1366514353E-01],
	[1.5790000000E+04, 9.0850776518E+00, 5.4661192644E+00, 1.0188086198E+00, 7.8458795131E-01, 7.1379601536E-01],
	[1.5795000000E+04, 9.0890812522E+00, 5.4658762825E+00, 1.0198301899E+00, 7.8521854200E-01, 7.1392684313E-01],
	[1.5800000000E+04, 9.0930853488E+00, 5.4656333884E+00, 1.0208524590E+00, 7.8584932484E-01, 7.1405762683E-01],
	[1.5805000000E+04, 9.0970899416E+00, 5.4653905819E+00, 1.0218754274E+00, 7.8648029966E-01, 7.1418836646E-01],
	[1.5810000000E+04, 9.1010950306E+00, 5.4651478630E+00, 1.0228990953E+00, 7.8711146626E-01, 7.1431906201E-01],
	[1.5815000000E+04, 9.1051006155E+00, 5.4649052316E+00, 1.0239234630E+00, 7.8774282448E-01, 7.1444971347E-01],
	[1.5820000000E+04, 9.1091066964E+00, 5.4646626877E+00, 1.0249485307E+00, 7.8837437411E-01, 7.1458032084E-01],
	[1.5825000000E+04, 9.1131132731E+00, 5.4644202312E+00, 1.0259742988E+00, 7.8900611499E-01, 7.1471088411E-01],
	[1.5830000000E+04, 9.1171203456E+00, 5.4641778620E+00, 1.0270007673E+00, 7.8963804693E-01, 7.1484140327E-01],
	[1.5835000000E+04, 9.1211279136E+00, 5.4639355801E+00, 1.0280279367E+00, 7.9027016974E-01, 7.1497187832E-01],
	[1.5840000000E+04, 9.1251359772E+00, 5.4636933855E+00, 1.0290558072E+00, 7.9090248325E-01, 7.1510230925E-01],
	[1.5845000000E+04, 9.1291445363E+00, 5.4634512780E+00, 1.0300843790E+00, 7.9153498726E-01, 7.1523269605E-01],
	[1.5850000000E+04, 9.1331535907E+00, 5.4632092576E+00, 1.0311136523E+00, 7.9216768161E-01, 7.1536303871E-01],
	[1.5855000000E+04, 9.1371631403E+00, 5.4629673243E+00, 1.0321436275E+00, 7.9280056610E-01, 7.1549333723E-01],
	[1.5860000000E+04, 9.1411731852E+00, 5.4627254779E+00, 1.0331743048E+00, 7.9343364055E-01, 7.1562359161E-01],
	[1.5865000000E+04, 9.1451837250E+00, 5.4624837185E+00, 1.0342056844E+00, 7.9406690478E-01, 7.1575380183E-01],
	[1.5870000000E+04, 9.1491947599E+00, 5.4622420460E+00, 1.0352377666E+00, 7.9470035861E-01, 7.1588396790E-01],
	[1.5875000000E+04, 9.1532062896E+00, 5.4620004603E+00, 1.0362705516E+00, 7.9533400184E-01, 7.1601408979E-01],
	[1.5880000000E+04, 9.1572183141E+00, 5.4617589613E+00, 1.0373040398E+00, 7.9596783430E-01, 7.1614416751E-01],
	[1.5885000000E+04, 9.1612308332E+00, 5.4615175491E+00, 1.0383382313E+00, 7.9660185581E-01, 7.1627420106E-01],
	[1.5890000000E+04, 9.1652438470E+00, 5.4612762235E+00, 1.0393731265E+00, 7.9723606618E-01, 7.1640419041E-01],
	[1.5895000000E+04, 9.1692573552E+00, 5.4610349845E+00, 1.0404087255E+00, 7.9787046522E-01, 7.1653413558E-01],
	[1.5900000000E+04, 9.1732713579E+00, 5.4607938319E+00, 1.0414450286E+00, 7.9850505276E-01, 7.1666403654E-01],
	[1.5905000000E+04, 9.1772858549E+00, 5.4605527659E+00, 1.0424820362E+00, 7.9913982860E-01, 7.1679389331E-01],
	[1.5910000000E+04, 9.1813008460E+00, 5.4603117863E+00, 1.0435197483E+00, 7.9977479257E-01, 7.1692370586E-01],
	[1.5915000000E+04, 9.1853163313E+00, 5.4600708930E+00, 1.0445581654E+00, 8.0040994448E-01, 7.1705347419E-01],
	[1.5920000000E+04, 9.1893323106E+00, 5.4598300860E+00, 1.0455972876E+00, 8.0104528414E-01, 7.1718319831E-01],
	[1.5925000000E+04, 9.1933487838E+00, 5.4595893653E+00, 1.0466371152E+00, 8.0168081138E-01, 7.1731287819E-01],
	[1.5930000000E+04, 9.1973657509E+00, 5.4593487307E+00, 1.0476776485E+00, 8.0231652600E-01, 7.1744251384E-01],
	[1.5935000000E+04, 9.2013832117E+00, 5.4591081822E+00, 1.0487188877E+00, 8.0295242782E-01, 7.1757210525E-01],
	[1.5940000000E+04, 9.2054011661E+00, 5.4588677198E+00, 1.0497608331E+00, 8.0358851666E-01, 7.1770165241E-01],
	[1.5945000000E+04, 9.2094196141E+00, 5.4586273434E+00, 1.0508034849E+00, 8.0422479233E-01, 7.1783115532E-01],
	[1.5950000000E+04, 9.2134385556E+00, 5.4583870530E+00, 1.0518468434E+00, 8.0486125465E-01, 7.1796061397E-01],
	[1.5955000000E+04, 9.2174579904E+00, 5.4581468484E+00, 1.0528909088E+00, 8.0549790343E-01, 7.1809002836E-01],
	[1.5960000000E+04, 9.2214779185E+00, 5.4579067297E+00, 1.0539356814E+00, 8.0613473848E-01, 7.1821939848E-01],
	[1.5965000000E+04, 9.2254983397E+00, 5.4576666967E+00, 1.0549811615E+00, 8.0677175963E-01, 7.1834872432E-01],
	[1.5970000000E+04, 9.2295192541E+00, 5.4574267494E+00, 1.0560273493E+00, 8.0740896669E-01, 7.1847800588E-01],
	[1.5975000000E+04, 9.2335406614E+00, 5.4571868879E+00, 1.0570742450E+00, 8.0804635946E-01, 7.1860724316E-01],
	[1.5980000000E+04, 9.2375625616E+00, 5.4569471119E+00, 1.0581218490E+00, 8.0868393777E-01, 7.1873643614E-01],
	[1.5985000000E+04, 9.2415849546E+00, 5.4567074214E+00, 1.0591701614E+00, 8.0932170143E-01, 7.1886558483E-01],
	[1.5990000000E+04, 9.2456078403E+00, 5.4564678164E+00, 1.0602191826E+00, 8.0995965026E-01, 7.1899468921E-01],
	[1.5995000000E+04, 9.2496312186E+00, 5.4562282969E+00, 1.0612689127E+00, 8.1059778406E-01, 7.1912374928E-01],
	[1.6000000000E+04, 9.2536550894E+00, 5.4559888627E+00, 1.0623193521E+00, 8.1123610266E-01, 7.1925276504E-01],
	[1.6005000000E+04, 9.2576794527E+00, 5.4557495139E+00, 1.0633705010E+00, 8.1187460586E-01, 7.1938173649E-01],
	[1.6010000000E+04, 9.2617043083E+00, 5.4555102503E+00, 1.0644223596E+00, 8.1251329349E-01, 7.1951066360E-01],
	[1.6015000000E+04, 9.2657296561E+00, 5.4552710719E+00, 1.0654749283E+00, 8.1315216535E-01, 7.1963954639E-01],
	[1.6020000000E+04, 9.2697554961E+00, 5.4550319786E+00, 1.0665282072E+00, 8.1379122125E-01, 7.1976838485E-01],
	[1.6025000000E+04, 9.2737818281E+00, 5.4547929705E+00, 1.0675821966E+00, 8.1443046102E-01, 7.1989717896E-01],
	[1.6030000000E+04, 9.2778086520E+00, 5.4545540473E+00, 1.0686368968E+00, 8.1506988446E-01, 7.2002592873E-01],
	[1.6035000000E+04, 9.2818359679E+00, 5.4543152091E+00, 1.0696923080E+00, 8.1570949140E-01, 7.2015463415E-01],
	[1.6040000000E+04, 9.2858637755E+00, 5.4540764559E+00, 1.0707484305E+00, 8.1634928163E-01, 7.2028329521E-01],
	[1.6045000000E+04, 9.2898994182E+00, 5.4538400239E+00, 1.0718052646E+00, 8.1698936196E-01, 7.2041191191E-01],
	[1.6050000000E+04, 9.2939460955E+00, 5.4536068840E+00, 1.0728628105E+00, 8.1762977916E-01, 7.2054048425E-01],
	[1.6055000000E+04, 9.2979932743E+00, 5.4533738266E+00, 1.0739210684E+00, 8.1827037972E-01, 7.2066901221E-01],
	[1.6060000000E+04, 9.3020409544E+00, 5.4531408517E+00, 1.0749800386E+00, 8.1891116346E-01, 7.2079749581E-01],
	[1.6065000000E+04, 9.3060891358E+00, 5.4529079593E+00, 1.0760397214E+00, 8.1955213020E-01, 7.2092593502E-01],
	[1.6070000000E+04, 9.3101378184E+00, 5.4526751493E+00, 1.0771001170E+00, 8.2019327975E-01, 7.2105432985E-01],
	[1.6075000000E+04, 9.3141870020E+00, 5.4524424217E+00, 1.0781612257E+00, 8.2083461192E-01, 7.2118268028E-01],
	[1.6080000000E+04, 9.3182366866E+00, 5.4522097764E+00, 1.0792230477E+00, 8.2147612652E-01, 7.2131098633E-01],
	[1.6085000000E+04, 9.3222868722E+00, 5.4519772133E+00, 1.0802855833E+00, 8.2211782338E-01, 7.2143924797E-01],
	[1.6090000000E+04, 9.3263375585E+00, 5.4517447324E+00, 1.0813488328E+00, 8.2275970230E-01, 7.2156746521E-01],
	[1.6095000000E+04, 9.3303887455E+00, 5.4515123337E+00, 1.0824127963E+00, 8.2340176309E-01, 7.2169563805E-01],
	[1.6100000000E+04, 9.3344404332E+00, 5.4512800170E+00, 1.0834774742E+00, 8.2404400557E-01, 7.2182376647E-01],
	[1.6105000000E+04, 9.3384926213E+00, 5.4510477824E+00, 1.0845428668E+00, 8.2468642956E-01, 7.2195185047E-01],
	[1.6110000000E+04, 9.3425453099E+00, 5.4508156298E+00, 1.0856089741E+00, 8.2532903485E-01, 7.2207989005E-01],
	[1.6115000000E+04, 9.3465984988E+00, 5.4505835591E+00, 1.0866757967E+00, 8.2597182128E-01, 7.2220788521E-01],
	[1.6120000000E+04, 9.3506521880E+00, 5.4503515702E+00, 1.0877433346E+00, 8.2661478864E-01, 7.2233583593E-01],
	[1.6125000000E+04, 9.3547063773E+00, 5.4501196632E+00, 1.0888115881E+00, 8.2725793675E-01, 7.2246374222E-01],
	[1.6130000000E+04, 9.3587610667E+00, 5.4498878379E+00, 1.0898805575E+00, 8.2790126543E-01, 7.2259160407E-01],
	[1.6135000000E+04, 9.3628162560E+00, 5.4496560943E+00, 1.0909502431E+00, 8.2854477449E-01, 7.2271942148E-01],
	[1.6140000000E+04, 9.3668719451E+00, 5.4494244324E+00, 1.0920206451E+00, 8.2918846373E-01, 7.2284719444E-01],
	[1.6145000000E+04, 9.3709281341E+00, 5.4491928521E+00, 1.0930917637E+00, 8.2983233298E-01, 7.2297492295E-01],
	[1.6150000000E+04, 9.3749848227E+00, 5.4489613534E+00, 1.0941635993E+00, 8.3047638204E-01, 7.2310260700E-01],
	[1.6155000000E+04, 9.3790420109E+00, 5.4487299361E+00, 1.0952361520E+00, 8.3112061072E-01, 7.2323024659E-01],
	[1.6160000000E+04, 9.3830996986E+00, 5.4484986002E+00, 1.0963094222E+00, 8.3176501885E-01, 7.2335784172E-01],
	[1.6165000000E+04, 9.3871578857E+00, 5.4482673458E+00, 1.0973834100E+00, 8.3240960622E-01, 7.2348539238E-01],
	[1.6170000000E+04, 9.3912165721E+00, 5.4480361727E+00, 1.0984581158E+00, 8.3305437265E-01, 7.2361289856E-01],
	[1.6175000000E+04, 9.3952757577E+00, 5.4478050808E+00, 1.0995335398E+00, 8.3369931795E-01, 7.2374036027E-01],
	[1.6180000000E+04, 9.3993354425E+00, 5.4475740702E+00, 1.1006096822E+00, 8.3434444194E-01, 7.2386777750E-01],
	[1.6185000000E+04, 9.4033956262E+00, 5.4473431407E+00, 1.1016865433E+00, 8.3498974443E-01, 7.2399515025E-01],
	[1.6190000000E+04, 9.4074563089E+00, 5.4471122924E+00, 1.1027641235E+00, 8.3563522522E-01, 7.2412247851E-01],
	[1.6195000000E+04, 9.4115174905E+00, 5.4468815251E+00, 1.1038424228E+00, 8.3628088413E-01, 7.2424976227E-01],
	[1.6200000000E+04, 9.4155791708E+00, 5.4466508388E+00, 1.1049214416E+00, 8.3692672097E-01, 7.2437700154E-01],
	[1.6205000000E+04, 9.4196413497E+00, 5.4464202335E+00, 1.1060011801E+00, 8.3757273555E-01, 7.2450419631E-01],
	[1.6210000000E+04, 9.4237040272E+00, 5.4461897090E+00, 1.1070816387E+00, 8.3821892769E-01, 7.2463134658E-01],
	[1.6215000000E+04, 9.4277672032E+00, 5.4459592655E+00, 1.1081628174E+00, 8.3886529719E-01, 7.2475845234E-01],
	[1.6220000000E+04, 9.4318308775E+00, 5.4457289027E+00, 1.1092447167E+00, 8.3951184386E-01, 7.2488551359E-01],
	[1.6225000000E+04, 9.4358950502E+00, 5.4454986206E+00, 1.1103273367E+00, 8.4015856751E-01, 7.2501253033E-01],
	[1.6230000000E+04, 9.4399597210E+00, 5.4452684193E+00, 1.1114106778E+00, 8.4080546797E-01, 7.2513950255E-01],
	[1.6235000000E+04, 9.4440248899E+00, 5.4450382986E+00, 1.1124947401E+00, 8.4145254502E-01, 7.2526643025E-01],
	[1.6240000000E+04, 9.4480905569E+00, 5.4448082584E+00, 1.1135795240E+00, 8.4209979850E-01, 7.2539331342E-01],
	[1.6245000000E+04, 9.4521567217E+00, 5.4445782988E+00, 1.1146650296E+00, 8.4274722820E-01, 7.2552015207E-01],
	[1.6250000000E+04, 9.4562233844E+00, 5.4443484197E+00, 1.1157512573E+00, 8.4339483394E-01, 7.2564694619E-01],
	[1.6255000000E+04, 9.4602905448E+00, 5.4441186210E+00, 1.1168382072E+00, 8.4404261553E-01, 7.2577369577E-01],
	[1.6260000000E+04, 9.4643582028E+00, 5.4438889026E+00, 1.1179258797E+00, 8.4469057278E-01, 7.2590040081E-01],
	[1.6265000000E+04, 9.4684263584E+00, 5.4436592646E+00, 1.1190142751E+00, 8.4533870550E-01, 7.2602706132E-01],
	[1.6270000000E+04, 9.4724950115E+00, 5.4434297068E+00, 1.1201033935E+00, 8.4598701349E-01, 7.2615367727E-01],
	[1.6275000000E+04, 9.4765641619E+00, 5.4432002293E+00, 1.1211932352E+00, 8.4663549658E-01, 7.2628024869E-01],
	[1.6280000000E+04, 9.4806338096E+00, 5.4429708319E+00, 1.1222838005E+00, 8.4728415456E-01, 7.2640677555E-01],
	[1.6285000000E+04, 9.4847039544E+00, 5.4427415146E+00, 1.1233750896E+00, 8.4793298726E-01, 7.2653325785E-01],
	[1.6290000000E+04, 9.4887745964E+00, 5.4425122774E+00, 1.1244671028E+00, 8.4858199447E-01, 7.2665969565E-01],
	[1.6295000000E+04, 9.4928457353E+00, 5.4422831201E+00, 1.1255598403E+00, 8.4923117601E-01, 7.2678608892E-01],
	[1.6300000000E+04, 9.4969173712E+00, 5.4420540429E+00, 1.1266533025E+00, 8.4988053169E-01, 7.2691243768E-01],
	[1.6305000000E+04, 9.5010034123E+00, 5.4418291246E+00, 1.1277474895E+00, 8.5053027242E-01, 7.2703874192E-01],
	[1.6310000000E+04, 9.5050944286E+00, 5.4416055951E+00, 1.1288424016E+00, 8.5118025532E-01, 7.2716500162E-01],
	[1.6315000000E+04, 9.5091859517E+00, 5.4413821433E+00, 1.1299380391E+00, 8.5183041244E-01, 7.2729121679E-01],
	[1.6320000000E+04, 9.5132779814E+00, 5.4411587692E+00, 1.1310344023E+00, 8.5248074359E-01, 7.2741738741E-01],
	[1.6325000000E+04, 9.5173705178E+00, 5.4409354727E+00, 1.1321314913E+00, 8.5313124857E-01, 7.2754351348E-01],
	[1.6330000000E+04, 9.5214635606E+00, 5.4407122537E+00, 1.1332293065E+00, 8.5378192721E-01, 7.2766959500E-01],
	[1.6335000000E+04, 9.5255571099E+00, 5.4404891121E+00, 1.1343278480E+00, 8.5443277930E-01, 7.2779563196E-01],
	[1.6340000000E+04, 9.5296511655E+00, 5.4402660481E+00, 1.1354271162E+00, 8.5508380466E-01, 7.2792162434E-01],
	[1.6345000000E+04, 9.5337457273E+00, 5.4400430614E+00, 1.1365271113E+00, 8.5573500310E-01, 7.2804757216E-01],
	[1.6350000000E+04, 9.5378407952E+00, 5.4398201520E+00, 1.1376278336E+00, 8.5638637442E-01, 7.2817347539E-01],
	[1.6355000000E+04, 9.5419363692E+00, 5.4395973200E+00, 1.1387292833E+00, 8.5703791844E-01, 7.2829933404E-01],
	[1.6360000000E+04, 9.5460324491E+00, 5.4393745651E+00, 1.1398314607E+00, 8.5768963497E-01, 7.2842514810E-01],
	[1.6365000000E+04, 9.5501290349E+00, 5.4391518875E+00, 1.1409343660E+00, 8.5834152381E-01, 7.2855091756E-01],
	[1.6370000000E+04, 9.5542261264E+00, 5.4389292870E+00, 1.1420379995E+00, 8.5899358478E-01, 7.2867664242E-01],
	[1.6375000000E+04, 9.5583237237E+00, 5.4387067636E+00, 1.1431423615E+00, 8.5964581768E-01, 7.2880232267E-01],
	[1.6380000000E+04, 9.5624218265E+00, 5.4384843172E+00, 1.1442474522E+00, 8.6029822232E-01, 7.2892795830E-01],
	[1.6385000000E+04, 9.5665204348E+00, 5.4382619478E+00, 1.1453532718E+00, 8.6095079851E-01, 7.2905354932E-01],
	[1.6390000000E+04, 9.5706195484E+00, 5.4380396553E+00, 1.1464598206E+00, 8.6160354607E-01, 7.2917909571E-01],
	[1.6395000000E+04, 9.5747191674E+00, 5.4378174398E+00, 1.1475670990E+00, 8.6225646479E-01, 7.2930459747E-01],
	[1.6400000000E+04, 9.5788192916E+00, 5.4375953010E+00, 1.1486751070E+00, 8.6290955449E-01, 7.2943005459E-01],
	[1.6405000000E+04, 9.5829199210E+00, 5.4373732391E+00, 1.1497838451E+00, 8.6356281498E-01, 7.2955546708E-01],
	[1.6410000000E+04, 9.5870210553E+00, 5.4371512539E+00, 1.1508933134E+00, 8.6421624606E-01, 7.2968083491E-01],
	[1.6415000000E+04, 9.5911226946E+00, 5.4369293453E+00, 1.1520035121E+00, 8.6486984755E-01, 7.2980615809E-01],
	[1.6420000000E+04, 9.5952248387E+00, 5.4367075134E+00, 1.1531144417E+00, 8.6552361925E-01, 7.2993143662E-01],
	[1.6425000000E+04, 9.5993274876E+00, 5.4364857581E+00, 1.1542261023E+00, 8.6617756097E-01, 7.3005667048E-01],
	[1.6430000000E+04, 9.6034306412E+00, 5.4362640793E+00, 1.1553384941E+00, 8.6683167251E-01, 7.3018185967E-01],
	[1.6435000000E+04, 9.6075342993E+00, 5.4360424770E+00, 1.1564516175E+00, 8.6748595370E-01, 7.3030700420E-01],
	[1.6440000000E+04, 9.6116384619E+00, 5.4358209512E+00, 1.1575654726E+00, 8.6814040433E-01, 7.3043210404E-01],
	[1.6445000000E+04, 9.6157431289E+00, 5.4355995017E+00, 1.1586800598E+00, 8.6879502421E-01, 7.3055715920E-01],
	[1.6450000000E+04, 9.6198483002E+00, 5.4353781286E+00, 1.1597953793E+00, 8.6944981316E-01, 7.3068216967E-01],
	[1.6455000000E+04, 9.6239539757E+00, 5.4351568318E+00, 1.1609114313E+00, 8.7010477098E-01, 7.3080713544E-01],
	[1.6460000000E+04, 9.6280601553E+00, 5.4349356112E+00, 1.1620282162E+00, 8.7075989747E-01, 7.3093205652E-01],
	[1.6465000000E+04, 9.6321668390E+00, 5.4347144667E+00, 1.1631457341E+00, 8.7141519245E-01, 7.3105693290E-01],
	[1.6470000000E+04, 9.6362740265E+00, 5.4344933985E+00, 1.1642639853E+00, 8.7207065572E-01, 7.3118176457E-01],
	[1.6475000000E+04, 9.6403817180E+00, 5.4342724063E+00, 1.1653829702E+00, 8.7272628709E-01, 7.3130655152E-01],
	[1.6480000000E+04, 9.6444899131E+00, 5.4340514901E+00, 1.1665026888E+00, 8.7338208637E-01, 7.3143129376E-01],
	[1.6485000000E+04, 9.6485986119E+00, 5.4338306500E+00, 1.1676231416E+00, 8.7403805336E-01, 7.3155599127E-01],
	[1.6490000000E+04, 9.6527078143E+00, 5.4336098858E+00, 1.1687443287E+00, 8.7469418788E-01, 7.3168064406E-01],
	[1.6495000000E+04, 9.6568175202E+00, 5.4333891975E+00, 1.1698662504E+00, 8.7535048973E-01, 7.3180525212E-01],
	[1.6500000000E+04, 9.6609277294E+00, 5.4331685850E+00, 1.1709889070E+00, 8.7600695871E-01, 7.3192981544E-01],
	[1.6505000000E+04, 9.6650384420E+00, 5.4329480483E+00, 1.1721122987E+00, 8.7666359465E-01, 7.3205433401E-01],
	[1.6510000000E+04, 9.6691496577E+00, 5.4327275874E+00, 1.1732364258E+00, 8.7732039733E-01, 7.3217880785E-01],
	[1.6515000000E+04, 9.6732613766E+00, 5.4325072022E+00, 1.1743612885E+00, 8.7797736657E-01, 7.3230323693E-01],
	[1.6520000000E+04, 9.6773735985E+00, 5.4322868926E+00, 1.1754868871E+00, 8.7863450218E-01, 7.3242762126E-01],
	[1.6525000000E+04, 9.6814863233E+00, 5.4320666586E+00, 1.1766132219E+00, 8.7929180397E-01, 7.3255196083E-01],
	[1.6530000000E+04, 9.6855995509E+00, 5.4318465002E+00, 1.1777402930E+00, 8.7994927173E-01, 7.3267625564E-01],
	[1.6535000000E+04, 9.6897132813E+00, 5.4316264173E+00, 1.1788681009E+00, 8.8060690528E-01, 7.3280050568E-01],
	[1.6540000000E+04, 9.6938275144E+00, 5.4314064098E+00, 1.1799966456E+00, 8.8126470442E-01, 7.3292471095E-01],
	[1.6545000000E+04, 9.6979422500E+00, 5.4311864777E+00, 1.1811259275E+00, 8.8192266897E-01, 7.3304887144E-01],
	[1.6550000000E+04, 9.7020574881E+00, 5.4309666210E+00, 1.1822559469E+00, 8.8258079872E-01, 7.3317298715E-01],
	[1.6555000000E+04, 9.7061732286E+00, 5.4307468396E+00, 1.1833867040E+00, 8.8323909349E-01, 7.3329705808E-01],
	[1.6560000000E+04, 9.7102894714E+00, 5.4305271335E+00, 1.1845181990E+00, 8.8389755307E-01, 7.3342108422E-01],
	[1.6565000000E+04, 9.7144113391E+00, 5.4303089504E+00, 1.1856504322E+00, 8.8455625818E-01, 7.3354506557E-01],
	[1.6570000000E+04, 9.7185474726E+00, 5.4300947293E+00, 1.1867834038E+00, 8.8521534537E-01, 7.3366900212E-01],
	[1.6575000000E+04, 9.7226841185E+00, 5.4298805814E+00, 1.1879171142E+00, 8.8587459749E-01, 7.3379289387E-01],
	[1.6580000000E+04, 9.7268212766E+00, 5.4296665065E+00, 1.1890515636E+00, 8.8653401433E-01, 7.3391674082E-01],
	[1.6585000000E+04, 9.7309589470E+00, 5.4294525046E+00, 1.1901867521E+00, 8.8719359570E-01, 7.3404054296E-01],
	[1.6590000000E+04, 9.7350971294E+00, 5.4292385756E+00, 1.1913226802E+00, 8.8785334141E-01, 7.3416430028E-01],
	[1.6595000000E+04, 9.7392358239E+00, 5.4290247195E+00, 1.1924593481E+00, 8.8851325126E-01, 7.3428801280E-01],
	[1.6600000000E+04, 9.7433750302E+00, 5.4288109363E+00, 1.1935967559E+00, 8.8917332506E-01, 7.3441168049E-01],
	[1.6605000000E+04, 9.7475147484E+00, 5.4285972258E+00, 1.1947349040E+00, 8.8983356261E-01, 7.3453530336E-01],
	[1.6610000000E+04, 9.7516549783E+00, 5.4283835881E+00, 1.1958737926E+00, 8.9049396373E-01, 7.3465888140E-01],
	[1.6615000000E+04, 9.7557957199E+00, 5.4281700231E+00, 1.1970134220E+00, 8.9115452822E-01, 7.3478241461E-01],
	[1.6620000000E+04, 9.7599369730E+00, 5.4279565308E+00, 1.1981537924E+00, 8.9181525589E-01, 7.3490590299E-01],
	[1.6625000000E+04, 9.7640787375E+00, 5.4277431111E+00, 1.1992949041E+00, 8.9247614654E-01, 7.3502934653E-01],
	[1.6630000000E+04, 9.7682210134E+00, 5.4275297639E+00, 1.2004367573E+00, 8.9313719998E-01, 7.3515274523E-01],
	[1.6635000000E+04, 9.7723638006E+00, 5.4273164893E+00, 1.2015793524E+00, 8.9379841601E-01, 7.3527609908E-01],
	[1.6640000000E+04, 9.7765070990E+00, 5.4271032871E+00, 1.2027226895E+00, 8.9445979444E-01, 7.3539940809E-01],
	[1.6645000000E+04, 9.7806509085E+00, 5.4268901573E+00, 1.2038667689E+00, 8.9512133508E-01, 7.3552267224E-01],
	[1.6650000000E+04, 9.7847952290E+00, 5.4266771000E+00, 1.2050115909E+00, 8.9578303773E-01, 7.3564589154E-01],
	[1.6655000000E+04, 9.7889400604E+00, 5.4264641149E+00, 1.2061571557E+00, 8.9644490220E-01, 7.3576906599E-01],
	[1.6660000000E+04, 9.7930854026E+00, 5.4262512022E+00, 1.2073034636E+00, 8.9710692829E-01, 7.3589219557E-01],
	[1.6665000000E+04, 9.7972312555E+00, 5.4260383617E+00, 1.2084505149E+00, 8.9776911581E-01, 7.3601528028E-01],
	[1.6670000000E+04, 9.8013776191E+00, 5.4258255933E+00, 1.2095983097E+00, 8.9843146457E-01, 7.3613832013E-01],
	[1.6675000000E+04, 9.8055244932E+00, 5.4256128972E+00, 1.2107468485E+00, 8.9909397437E-01, 7.3626131511E-01],
	[1.6680000000E+04, 9.8096718778E+00, 5.4254002731E+00, 1.2118961313E+00, 8.9975664502E-01, 7.3638426521E-01],
	[1.6685000000E+04, 9.8138197728E+00, 5.4251877211E+00, 1.2130461585E+00, 9.0041947632E-01, 7.3650717044E-01],
	[1.6690000000E+04, 9.8179681781E+00, 5.4249752411E+00, 1.2141969303E+00, 9.0108246808E-01, 7.3663003079E-01],
	[1.6695000000E+04, 9.8221170935E+00, 5.4247628330E+00, 1.2153484471E+00, 9.0174562010E-01, 7.3675284625E-01],
	[1.6700000000E+04, 9.8262665191E+00, 5.4245504969E+00, 1.2165007090E+00, 9.0240893219E-01, 7.3687561683E-01],
	[1.6705000000E+04, 9.8304164546E+00, 5.4243382327E+00, 1.2176537162E+00, 9.0307240415E-01, 7.3699834252E-01],
	[1.6710000000E+04, 9.8345669001E+00, 5.4241260402E+00, 1.2188074692E+00, 9.0373603580E-01, 7.3712102332E-01],
	[1.6715000000E+04, 9.8387178554E+00, 5.4239139196E+00, 1.2199619680E+00, 9.0439982692E-01, 7.3724365922E-01],
	[1.6720000000E+04, 9.8428693205E+00, 5.4237018707E+00, 1.2211172131E+00, 9.0506377734E-01, 7.3736625022E-01],
	[1.6725000000E+04, 9.8470212952E+00, 5.4234898935E+00, 1.2222732045E+00, 9.0572788685E-01, 7.3748879633E-01],
	[1.6730000000E+04, 9.8511737794E+00, 5.4232779879E+00, 1.2234299427E+00, 9.0639215526E-01, 7.3761129753E-01],
	[1.6735000000E+04, 9.8553267732E+00, 5.4230661539E+00, 1.2245874278E+00, 9.0705658237E-01, 7.3773375383E-01],
	[1.6740000000E+04, 9.8594802763E+00, 5.4228543915E+00, 1.2257456601E+00, 9.0772116799E-01, 7.3785616522E-01],
	[1.6745000000E+04, 9.8636342887E+00, 5.4226427006E+00, 1.2269046398E+00, 9.0838591193E-01, 7.3797853170E-01],
	[1.6750000000E+04, 9.8677888103E+00, 5.4224310811E+00, 1.2280643673E+00, 9.0905081399E-01, 7.3810085326E-01],
	[1.6755000000E+04, 9.8719438410E+00, 5.4222195330E+00, 1.2292248427E+00, 9.0971587396E-01, 7.3822312991E-01],
	[1.6760000000E+04, 9.8760993808E+00, 5.4220080564E+00, 1.2303860664E+00, 9.1038109167E-01, 7.3834536164E-01],
	[1.6765000000E+04, 9.8802554295E+00, 5.4217966510E+00, 1.2315480386E+00, 9.1104646691E-01, 7.3846754845E-01],
	[1.6770000000E+04, 9.8844119870E+00, 5.4215853169E+00, 1.2327107595E+00, 9.1171199948E-01, 7.3858969034E-01],
	[1.6775000000E+04, 9.8885690533E+00, 5.4213740541E+00, 1.2338742294E+00, 9.1237768920E-01, 7.3871178730E-01],
	[1.6780000000E+04, 9.8927266282E+00, 5.4211628625E+00, 1.2350384486E+00, 9.1304353586E-01, 7.3883383934E-01],
	[1.6785000000E+04, 9.8968847118E+00, 5.4209517419E+00, 1.2362034173E+00, 9.1370953927E-01, 7.3895584644E-01],
	[1.6790000000E+04, 9.9010433038E+00, 5.4207406925E+00, 1.2373691358E+00, 9.1437569923E-01, 7.3907780862E-01],
	[1.6795000000E+04, 9.9052024042E+00, 5.4205297142E+00, 1.2385356043E+00, 9.1504201556E-01, 7.3919972586E-01],
	[1.6800000000E+04, 9.9093620129E+00, 5.4203188068E+00, 1.2397028231E+00, 9.1570848804E-01, 7.3932159816E-01],
	[1.6805000000E+04, 9.9135221298E+00, 5.4201079705E+00, 1.2408707925E+00, 9.1637511650E-01, 7.3944342552E-01],
	[1.6810000000E+04, 9.9176827549E+00, 5.4198972050E+00, 1.2420395127E+00, 9.1704190072E-01, 7.3956520795E-01],
	[1.6815000000E+04, 9.9218438880E+00, 5.4196865104E+00, 1.2432089839E+00, 9.1770884052E-01, 7.3968694543E-01],
	[1.6820000000E+04, 9.9260055291E+00, 5.4194758866E+00, 1.2443792064E+00, 9.1837593569E-01, 7.3980863796E-01],
	[1.6825000000E+04, 9.9301676780E+00, 5.4192653337E+00, 1.2455501806E+00, 9.1904318605E-01, 7.3993028555E-01],
	[1.6830000000E+04, 9.9343303347E+00, 5.4190548514E+00, 1.2467219065E+00, 9.1971059139E-01, 7.4005188819E-01],
	[1.6835000000E+04, 9.9385117484E+00, 5.4188494093E+00, 1.2478943846E+00, 9.2037845139E-01, 7.4017344588E-01],
	[1.6840000000E+04, 9.9426948260E+00, 5.4186443479E+00, 1.2490676150E+00, 9.2104648550E-01, 7.4029495862E-01],
	[1.6845000000E+04, 9.9468784216E+00, 5.4184393553E+00, 1.2502415980E+00, 9.2171467471E-01, 7.4041642641E-01],
	[1.6850000000E+04, 9.9510625352E+00, 5.4182344312E+00, 1.2514163339E+00, 9.2238301883E-01, 7.4053784924E-01],
	[1.6855000000E+04, 9.9552471667E+00, 5.4180295756E+00, 1.2525918229E+00, 9.2305151765E-01, 7.4065922711E-01],
	[1.6860000000E+04, 9.9594323159E+00, 5.4178247886E+00, 1.2537680653E+00, 9.2372017098E-01, 7.4078056002E-01],
	[1.6865000000E+04, 9.9636179828E+00, 5.4176200700E+00, 1.2549450613E+00, 9.2438897864E-01, 7.4090184797E-01],
	[1.6870000000E+04, 9.9678041673E+00, 5.4174154198E+00, 1.2561228113E+00, 9.2505794041E-01, 7.4102309096E-01],
	[1.6875000000E+04, 9.9719908692E+00, 5.4172108380E+00, 1.2573013153E+00, 9.2572705611E-01, 7.4114428899E-01],
	[1.6880000000E+04, 9.9761780886E+00, 5.4170063246E+00, 1.2584805738E+00, 9.2639632553E-01, 7.4126544205E-01],
	[1.6885000000E+04, 9.9803658253E+00, 5.4168018794E+00, 1.2596605870E+00, 9.2706574849E-01, 7.4138655014E-01],
	[1.6890000000E+04, 9.9845540792E+00, 5.4165975025E+00, 1.2608413551E+00, 9.2773532478E-01, 7.4150761327E-01],
	[1.6895000000E+04, 9.9887428503E+00, 5.4163931938E+00, 1.2620228783E+00, 9.2840505422E-01, 7.4162863142E-01],
	[1.6900000000E+04, 9.9929321384E+00, 5.4161889532E+00, 1.2632051571E+00, 9.2907493659E-01, 7.4174960460E-01],
	[1.6905000000E+04, 9.9971219435E+00, 5.4159847807E+00, 1.2643881915E+00, 9.2974497172E-01, 7.4187053282E-01],
	[1.6910000000E+04, 1.0001312265E+01, 5.4157806763E+00, 1.2655719818E+00, 9.3041515940E-01, 7.4199141605E-01],
	[1.6915000000E+04, 1.0005503104E+01, 5.4155766400E+00, 1.2667565284E+00, 9.3108549942E-01, 7.4211225432E-01],
	[1.6920000000E+04, 1.0009694460E+01, 5.4153726716E+00, 1.2679418315E+00, 9.3175599161E-01, 7.4223304760E-01],
	[1.6925000000E+04, 1.0013886332E+01, 5.4151687712E+00, 1.2691278913E+00, 9.3242663576E-01, 7.4235379591E-01],
	[1.6930000000E+04, 1.0018078720E+01, 5.4149649387E+00, 1.2703147081E+00, 9.3309743167E-01, 7.4247449924E-01],
	[1.6935000000E+04, 1.0022271625E+01, 5.4147611740E+00, 1.2715022821E+00, 9.3376837915E-01, 7.4259515759E-01],
	[1.6940000000E+04, 1.0026465046E+01, 5.4145574772E+00, 1.2726906136E+00, 9.3443947800E-01, 7.4271577096E-01],
	[1.6945000000E+04, 1.0030658984E+01, 5.4143538481E+00, 1.2738797029E+00, 9.3511072803E-01, 7.4283633935E-01],
	[1.6950000000E+04, 1.0034853438E+01, 5.4141502867E+00, 1.2750695502E+00, 9.3578212903E-01, 7.4295686275E-01],
	[1.6955000000E+04, 1.0039048408E+01, 5.4139467931E+00, 1.2762601558E+00, 9.3645368082E-01, 7.4307734117E-01],
	[1.6960000000E+04, 1.0043243893E+01, 5.4137433671E+00, 1.2774515199E+00, 9.3712538318E-01, 7.4319777461E-01],
	[1.6965000000E+04, 1.0047439895E+01, 5.4135400087E+00, 1.2786436428E+00, 9.3779723594E-01, 7.4331816306E-01],
	[1.6970000000E+04, 1.0051636412E+01, 5.4133367178E+00, 1.2798365248E+00, 9.3846923888E-01, 7.4343850652E-01],
	[1.6975000000E+04, 1.0055833446E+01, 5.4131334945E+00, 1.2810301660E+00, 9.3914139181E-01, 7.4355880500E-01],
	[1.6980000000E+04, 1.0060030994E+01, 5.4129303387E+00, 1.2822245669E+00, 9.3981369454E-01, 7.4367905849E-01],
	[1.6985000000E+04, 1.0064229059E+01, 5.4127272503E+00, 1.2834197275E+00, 9.4048614687E-01, 7.4379926699E-01],
	[1.6990000000E+04, 1.0068427639E+01, 5.4125242292E+00, 1.2846156483E+00, 9.4115874860E-01, 7.4391943050E-01],
	[1.6995000000E+04, 1.0072626734E+01, 5.4123212756E+00, 1.2858123293E+00, 9.4183149953E-01, 7.4403954902E-01],
	[1.7000000000E+04, 1.0076826344E+01, 5.4121183892E+00, 1.2870097710E+00, 9.4250439947E-01, 7.4415962255E-01],
	[1.7005000000E+04, 1.0081026470E+01, 5.4119155701E+00, 1.2882079736E+00, 9.4317744821E-01, 7.4427965109E-01],
	[1.7010000000E+04, 1.0085227111E+01, 5.4117128182E+00, 1.2894069372E+00, 9.4385064557E-01, 7.4439963463E-01],
	[1.7015000000E+04, 1.0089428266E+01, 5.4115101335E+00, 1.2906066622E+00, 9.4452399134E-01, 7.4451957319E-01],
	[1.7020000000E+04, 1.0093629937E+01, 5.4113075160E+00, 1.2918071488E+00, 9.4519748533E-01, 7.4463946675E-01],
	[1.7025000000E+04, 1.0097832122E+01, 5.4111049655E+00, 1.2930083974E+00, 9.4587112734E-01, 7.4475931532E-01],
	[1.7030000000E+04, 1.0102034823E+01, 5.4109024821E+00, 1.2942104080E+00, 9.4654491716E-01, 7.4487911889E-01],
	[1.7035000000E+04, 1.0106238038E+01, 5.4107000658E+00, 1.2954131811E+00, 9.4721885461E-01, 7.4499887747E-01],
	[1.7040000000E+04, 1.0110441767E+01, 5.4104977163E+00, 1.2966167168E+00, 9.4789293949E-01, 7.4511859105E-01],
	[1.7045000000E+04, 1.0114646011E+01, 5.4102954339E+00, 1.2978210155E+00, 9.4856717159E-01, 7.4523825964E-01],
	[1.7050000000E+04, 1.0118850769E+01, 5.4100932183E+00, 1.2990260773E+00, 9.4924155073E-01, 7.4535788324E-01],
	[1.7055000000E+04, 1.0123056042E+01, 5.4098910695E+00, 1.3002319026E+00, 9.4991607669E-01, 7.4547746184E-01],
	[1.7060000000E+04, 1.0127261829E+01, 5.4096889876E+00, 1.3014384915E+00, 9.5059074929E-01, 7.4559699545E-01],
	[1.7065000000E+04, 1.0131468130E+01, 5.4094869724E+00, 1.3026458444E+00, 9.5126556833E-01, 7.4571648405E-01],
	[1.7070000000E+04, 1.0135674945E+01, 5.4092850239E+00, 1.3038539615E+00, 9.5194053360E-01, 7.4583592767E-01],
	[1.7075000000E+04, 1.0139882274E+01, 5.4090831422E+00, 1.3050628431E+00, 9.5261564491E-01, 7.4595532629E-01],
	[1.7080000000E+04, 1.0144090117E+01, 5.4088813270E+00, 1.3062724894E+00, 9.5329090207E-01, 7.4607467991E-01],
	[1.7085000000E+04, 1.0148298473E+01, 5.4086795785E+00, 1.3074829007E+00, 9.5396630487E-01, 7.4619398853E-01],
	[1.7090000000E+04, 1.0152507343E+01, 5.4084778965E+00, 1.3086940772E+00, 9.5464185312E-01, 7.4631325216E-01],
	[1.7095000000E+04, 1.0156716727E+01, 5.4082762810E+00, 1.3099060192E+00, 9.5531754661E-01, 7.4643247080E-01],
	[1.7100000000E+04, 1.0160926625E+01, 5.4080747320E+00, 1.3111187270E+00, 9.5599338515E-01, 7.4655164444E-01],
	[1.7105000000E+04, 1.0165152010E+01, 5.4078771808E+00, 1.3123322008E+00, 9.5666962421E-01, 7.4667077308E-01],
	[1.7110000000E+04, 1.0169382858E+01, 5.4076809913E+00, 1.3135464408E+00, 9.5734609290E-01, 7.4678985673E-01],
	[1.7115000000E+04, 1.0173614230E+01, 5.4074848662E+00, 1.3147614474E+00, 9.5802270677E-01, 7.4690889538E-01],
	[1.7120000000E+04, 1.0177846126E+01, 5.4072888055E+00, 1.3159772208E+00, 9.5869946562E-01, 7.4702788904E-01],
	[1.7125000000E+04, 1.0182078546E+01, 5.4070928091E+00, 1.3171937612E+00, 9.5937636927E-01, 7.4714683770E-01],
	[1.7130000000E+04, 1.0186311490E+01, 5.4068968771E+00, 1.3184110689E+00, 9.6005341750E-01, 7.4726574137E-01],
	[1.7135000000E+04, 1.0190544957E+01, 5.4067010093E+00, 1.3196291442E+00, 9.6073061012E-01, 7.4738460005E-01],
	[1.7140000000E+04, 1.0194778947E+01, 5.4065052058E+00, 1.3208479873E+00, 9.6140794694E-01, 7.4750341373E-01],
	[1.7145000000E+04, 1.0199013461E+01, 5.4063094665E+00, 1.3220675985E+00, 9.6208542775E-01, 7.4762218242E-01],
	[1.7150000000E+04, 1.0203248499E+01, 5.4061137914E+00, 1.3232879781E+00, 9.6276305235E-01, 7.4774090611E-01],
	[1.7155000000E+04, 1.0207484059E+01, 5.4059181803E+00, 1.3245091262E+00, 9.6344082056E-01, 7.4785958482E-01],
	[1.7160000000E+04, 1.0211720143E+01, 5.4057226334E+00, 1.3257310431E+00, 9.6411873216E-01, 7.4797821853E-01],
	[1.7165000000E+04, 1.0215956750E+01, 5.4055271504E+00, 1.3269537292E+00, 9.6479678697E-01, 7.4809680725E-01],
	[1.7170000000E+04, 1.0220193880E+01, 5.4053317315E+00, 1.3281771847E+00, 9.6547498478E-01, 7.4821535098E-01],
	[1.7175000000E+04, 1.0224431533E+01, 5.4051363765E+00, 1.3294014098E+00, 9.6615332540E-01, 7.4833384972E-01],
	[1.7180000000E+04, 1.0228669708E+01, 5.4049410855E+00, 1.3306264047E+00, 9.6683180862E-01, 7.4845230347E-01],
	[1.7185000000E+04, 1.0232908407E+01, 5.4047458584E+00, 1.3318521698E+00, 9.6751043425E-01, 7.4857071223E-01],
	[1.7190000000E+04, 1.0237147628E+01, 5.4045506950E+00, 1.3330787053E+00, 9.6818920210E-01, 7.4868907601E-01],
	[1.7195000000E+04, 1.0241387372E+01, 5.4043555955E+00, 1.3343060115E+00, 9.6886811195E-01, 7.4880739480E-01],
	[1.7200000000E+04, 1.0245627638E+01, 5.4041605598E+00, 1.3355340886E+00, 9.6954716362E-01, 7.4892566860E-01],
	[1.7205000000E+04, 1.0249868426E+01, 5.4039655877E+00, 1.3367629369E+00, 9.7022635690E-01, 7.4904389741E-01],
	[1.7210000000E+04, 1.0254109737E+01, 5.4037706794E+00, 1.3379925566E+00, 9.7090569160E-01, 7.4916208125E-01],
	[1.7215000000E+04, 1.0258351570E+01, 5.4035758347E+00, 1.3392229480E+00, 9.7158516752E-01, 7.4928022009E-01],
	[1.7220000000E+04, 1.0262593925E+01, 5.4033810536E+00, 1.3404541113E+00, 9.7226478446E-01, 7.4939831396E-01],
	[1.7225000000E+04, 1.0266836802E+01, 5.4031863361E+00, 1.3416860469E+00, 9.7294454222E-01, 7.4951636284E-01],
	[1.7230000000E+04, 1.0271080201E+01, 5.4029916821E+00, 1.3429187549E+00, 9.7362444059E-01, 7.4963436675E-01],
	[1.7235000000E+04, 1.0275324122E+01, 5.4027970916E+00, 1.3441522357E+00, 9.7430447939E-01, 7.4975232567E-01],
	[1.7240000000E+04, 1.0279568565E+01, 5.4026025645E+00, 1.3453864894E+00, 9.7498465842E-01, 7.4987023961E-01],
	[1.7245000000E+04, 1.0283813529E+01, 5.4024081009E+00, 1.3466215164E+00, 9.7566497747E-01, 7.4998810858E-01],
	[1.7250000000E+04, 1.0288059015E+01, 5.4022137006E+00, 1.3478573169E+00, 9.7634543635E-01, 7.5010593257E-01],
	[1.7255000000E+04, 1.0292305023E+01, 5.4020193636E+00, 1.3490938911E+00, 9.7702603485E-01, 7.5022371159E-01],
	[1.7260000000E+04, 1.0296551552E+01, 5.4018250900E+00, 1.3503312394E+00, 9.7770677278E-01, 7.5034144563E-01],
	[1.7265000000E+04, 1.0300798602E+01, 5.4016308796E+00, 1.3515693619E+00, 9.7838764994E-01, 7.5045913470E-01],
	[1.7270000000E+04, 1.0305046173E+01, 5.4014367324E+00, 1.3528082590E+00, 9.7906866613E-01, 7.5057677880E-01],
	[1.7275000000E+04, 1.0309294266E+01, 5.4012426484E+00, 1.3540479309E+00, 9.7974982116E-01, 7.5069437793E-01],
	[1.7280000000E+04, 1.0313542880E+01, 5.4010486275E+00, 1.3552883778E+00, 9.8043111481E-01, 7.5081193208E-01],
	[1.7285000000E+04, 1.0317792015E+01, 5.4008546698E+00, 1.3565296000E+00, 9.8111254690E-01, 7.5092944128E-01],
	[1.7290000000E+04, 1.0322041670E+01, 5.4006607750E+00, 1.3577715978E+00, 9.8179411722E-01, 7.5104690550E-01],
	[1.7295000000E+04, 1.0326291847E+01, 5.4004669434E+00, 1.3590143714E+00, 9.8247582558E-01, 7.5116432476E-01],
	[1.7300000000E+04, 1.0330542544E+01, 5.4002731746E+00, 1.3602579212E+00, 9.8315767177E-01, 7.5128169906E-01],
	[1.7305000000E+04, 1.0334793762E+01, 5.4000794689E+00, 1.3615022472E+00, 9.8383965559E-01, 7.5139902840E-01],
	[1.7310000000E+04, 1.0339045500E+01, 5.3998858260E+00, 1.3627473499E+00, 9.8452177686E-01, 7.5151631278E-01],
	[1.7315000000E+04, 1.0343297759E+01, 5.3996922460E+00, 1.3639932294E+00, 9.8520403536E-01, 7.5163355220E-01],
	[1.7320000000E+04, 1.0347550538E+01, 5.3994987289E+00, 1.3652398860E+00, 9.8588643090E-01, 7.5175074666E-01],
	[1.7325000000E+04, 1.0351803838E+01, 5.3993052745E+00, 1.3664873201E+00, 9.8656896327E-01, 7.5186789617E-01],
	[1.7330000000E+04, 1.0356057658E+01, 5.3991118829E+00, 1.3677355317E+00, 9.8725163229E-01, 7.5198500072E-01],
	[1.7335000000E+04, 1.0360311998E+01, 5.3989185539E+00, 1.3689845213E+00, 9.8793443775E-01, 7.5210206032E-01],
	[1.7340000000E+04, 1.0364566857E+01, 5.3987252877E+00, 1.3702342890E+00, 9.8861737944E-01, 7.5221907497E-01],
	[1.7345000000E+04, 1.0368822237E+01, 5.3985320841E+00, 1.3714848351E+00, 9.8930045718E-01, 7.5233604468E-01],
	[1.7350000000E+04, 1.0373078137E+01, 5.3983389431E+00, 1.3727361599E+00, 9.8998367075E-01, 7.5245296944E-01],
	[1.7355000000E+04, 1.0377334557E+01, 5.3981458647E+00, 1.3739882636E+00, 9.9066701997E-01, 7.5256984925E-01],
	[1.7360000000E+04, 1.0381591496E+01, 5.3979528487E+00, 1.3752411465E+00, 9.9135050463E-01, 7.5268668412E-01],
	[1.7365000000E+04, 1.0385848955E+01, 5.3977598953E+00, 1.3764948089E+00, 9.9203412453E-01, 7.5280347405E-01],
	[1.7370000000E+04, 1.0390106933E+01, 5.3975670043E+00, 1.3777492509E+00, 9.9271787947E-01, 7.5292021904E-01],
	[1.7375000000E+04, 1.0394365431E+01, 5.3973741757E+00, 1.3790044729E+00, 9.9340176926E-01, 7.5303691910E-01],
	[1.7380000000E+04, 1.0398638561E+01, 5.3971849835E+00, 1.3802604752E+00, 9.9408604391E-01, 7.5315357422E-01],
	[1.7385000000E+04, 1.0402918543E+01, 5.3969974532E+00, 1.3815172579E+00, 9.9477056575E-01, 7.5327018440E-01],
	[1.7390000000E+04, 1.0407199056E+01, 5.3968099834E+00, 1.3827748214E+00, 9.9545522259E-01, 7.5338674966E-01],
	[1.7395000000E+04, 1.0411480098E+01, 5.3966225740E+00, 1.3840331658E+00, 9.9614001422E-01, 7.5350326999E-01],
	[1.7400000000E+04, 1.0415761670E+01, 5.3964352249E+00, 1.3852922916E+00, 9.9682494045E-01, 7.5361974539E-01],
	[1.7405000000E+04, 1.0420043772E+01, 5.3962479362E+00, 1.3865521988E+00, 9.9751000107E-01, 7.5373617587E-01],
	[1.7410000000E+04, 1.0424326403E+01, 5.3960607078E+00, 1.3878128878E+00, 9.9819519590E-01, 7.5385256142E-01],
	[1.7415000000E+04, 1.0428609564E+01, 5.3958735396E+00, 1.3890743588E+00, 9.9888052472E-01, 7.5396890206E-01],
	[1.7420000000E+04, 1.0432893255E+01, 5.3956864316E+00, 1.3903366122E+00, 9.9956598735E-01, 7.5408519778E-01],
	[1.7425000000E+04, 1.0437177475E+01, 5.3954993839E+00, 1.3915996481E+00, 1.0002515836E+00, 7.5420144858E-01],
	[1.7430000000E+04, 1.0441462225E+01, 5.3953123962E+00, 1.3928634668E+00, 1.0009373132E+00, 7.5431765447E-01],
	[1.7435000000E+04, 1.0445747504E+01, 5.3951254687E+00, 1.3941280685E+00, 1.0016231760E+00, 7.5443381545E-01],
	[1.7440000000E+04, 1.0450033312E+01, 5.3949386013E+00, 1.3953934536E+00, 1.0023091718E+00, 7.5454993153E-01],
	[1.7445000000E+04, 1.0454319649E+01, 5.3947517939E+00, 1.3966596223E+00, 1.0029953005E+00, 7.5466600269E-01],
	[1.7450000000E+04, 1.0458606516E+01, 5.3945650465E+00, 1.3979265748E+00, 1.0036815617E+00, 7.5478202896E-01],
	[1.7455000000E+04, 1.0462893911E+01, 5.3943783590E+00, 1.3991943114E+00, 1.0043679553E+00, 7.5489801032E-01],
	[1.7460000000E+04, 1.0467181835E+01, 5.3941917315E+00, 1.4004628324E+00, 1.0050544812E+00, 7.5501394678E-01],
	[1.7465000000E+04, 1.0471470288E+01, 5.3940051639E+00, 1.4017321380E+00, 1.0057411390E+00, 7.5512983835E-01],
	[1.7470000000E+04, 1.0475759270E+01, 5.3938186561E+00, 1.4030022285E+00, 1.0064279286E+00, 7.5524568503E-01],
	[1.7475000000E+04, 1.0480048780E+01, 5.3936322081E+00, 1.4042731041E+00, 1.0071148499E+00, 7.5536148681E-01],
	[1.7480000000E+04, 1.0484338819E+01, 5.3934458200E+00, 1.4055447651E+00, 1.0078019025E+00, 7.5547724371E-01],
	[1.7485000000E+04, 1.0488629386E+01, 5.3932594915E+00, 1.4068172118E+00, 1.0084890864E+00, 7.5559295573E-01],
	[1.7490000000E+04, 1.0492920481E+01, 5.3930732228E+00, 1.4080904444E+00, 1.0091764012E+00, 7.5570862286E-01],
	[1.7495000000E+04, 1.0497212105E+01, 5.3928870138E+00, 1.4093644632E+00, 1.0098638469E+00, 7.5582424511E-01],
	[1.7500000000E+04, 1.0501504257E+01, 5.3927008644E+00, 1.4106392684E+00, 1.0105514232E+00, 7.5593982248E-01],
	[1.7505000000E+04, 1.0505796937E+01, 5.3925147745E+00, 1.4119254268E+00, 1.0112445502E+00, 7.5605535498E-01],
	[1.7510000000E+04, 1.0510090145E+01, 5.3923287443E+00, 1.4132123886E+00, 1.0119378109E+00, 7.5617084261E-01],
	[1.7515000000E+04, 1.0514383881E+01, 5.3921427736E+00, 1.4145001539E+00, 1.0126312050E+00, 7.5628628538E-01],
	[1.7520000000E+04, 1.0518678145E+01, 5.3919568624E+00, 1.4157887230E+00, 1.0133247325E+00, 7.5640168327E-01],
	[1.7525000000E+04, 1.0522972936E+01, 5.3917710106E+00, 1.4170780962E+00, 1.0140183931E+00, 7.5651703631E-01],
	[1.7530000000E+04, 1.0527268255E+01, 5.3915852182E+00, 1.4183682737E+00, 1.0147121865E+00, 7.5663234448E-01],
	[1.7535000000E+04, 1.0531564102E+01, 5.3913994853E+00, 1.4196592558E+00, 1.0154061126E+00, 7.5674760780E-01],
	[1.7540000000E+04, 1.0535860476E+01, 5.3912138117E+00, 1.4209510428E+00, 1.0161001712E+00, 7.5686282626E-01],
	[1.7545000000E+04, 1.0540157378E+01, 5.3910281974E+00, 1.4222436350E+00, 1.0167943621E+00, 7.5697799988E-01],
	[1.7550000000E+04, 1.0544454807E+01, 5.3908426423E+00, 1.4235370326E+00, 1.0174886850E+00, 7.5709312864E-01],
	[1.7555000000E+04, 1.0548752763E+01, 5.3906571466E+00, 1.4248312360E+00, 1.0181831398E+00, 7.5720821257E-01],
	[1.7560000000E+04, 1.0553051247E+01, 5.3904717100E+00, 1.4261262453E+00, 1.0188777262E+00, 7.5732325165E-01],
	[1.7565000000E+04, 1.0557350257E+01, 5.3902863326E+00, 1.4274220608E+00, 1.0195724441E+00, 7.5743824589E-01],
	[1.7570000000E+04, 1.0561649795E+01, 5.3901010143E+00, 1.4287186828E+00, 1.0202672932E+00, 7.5755319530E-01],
	[1.7575000000E+04, 1.0565949859E+01, 5.3899157551E+00, 1.4300161116E+00, 1.0209622733E+00, 7.5766809988E-01],
	[1.7580000000E+04, 1.0570250450E+01, 5.3897305550E+00, 1.4313143475E+00, 1.0216573843E+00, 7.5778295963E-01],
	[1.7585000000E+04, 1.0574551568E+01, 5.3895454139E+00, 1.4326133907E+00, 1.0223526259E+00, 7.5789777456E-01],
	[1.7590000000E+04, 1.0578853212E+01, 5.3893603318E+00, 1.4339132415E+00, 1.0230479980E+00, 7.5801254466E-01],
	[1.7595000000E+04, 1.0583155383E+01, 5.3891753087E+00, 1.4352139002E+00, 1.0237435002E+00, 7.5812726995E-01],
	[1.7600000000E+04, 1.0587458081E+01, 5.3889903445E+00, 1.4365153670E+00, 1.0244391325E+00, 7.5824195042E-01],
	[1.7605000000E+04, 1.0591761305E+01, 5.3888054391E+00, 1.4378176422E+00, 1.0251348946E+00, 7.5835658608E-01],
	[1.7610000000E+04, 1.0596065055E+01, 5.3886205927E+00, 1.4391207261E+00, 1.0258307863E+00, 7.5847117693E-01],
	[1.7615000000E+04, 1.0600369331E+01, 5.3884358050E+00, 1.4404246189E+00, 1.0265268073E+00, 7.5858572298E-01],
	[1.7620000000E+04, 1.0604674133E+01, 5.3882510761E+00, 1.4417293210E+00, 1.0272229576E+00, 7.5870022422E-01],
	[1.7625000000E+04, 1.0608979462E+01, 5.3880664059E+00, 1.4430348325E+00, 1.0279192369E+00, 7.5881468067E-01],
	[1.7630000000E+04, 1.0613285316E+01, 5.3878817945E+00, 1.4443411538E+00, 1.0286156449E+00, 7.5892909233E-01],
	[1.7635000000E+04, 1.0617591697E+01, 5.3876972417E+00, 1.4456482851E+00, 1.0293121815E+00, 7.5904345920E-01],
	[1.7640000000E+04, 1.0621898603E+01, 5.3875127476E+00, 1.4469562268E+00, 1.0300088465E+00, 7.5915778128E-01],
	[1.7645000000E+04, 1.0626206035E+01, 5.3873283121E+00, 1.4482649790E+00, 1.0307056397E+00, 7.5927205858E-01],
	[1.7650000000E+04, 1.0630513992E+01, 5.3871439351E+00, 1.4495745421E+00, 1.0314025608E+00, 7.5938629109E-01],
	[1.7655000000E+04, 1.0634822475E+01, 5.3869596167E+00, 1.4508849162E+00, 1.0320996097E+00, 7.5950047884E-01],
	[1.7660000000E+04, 1.0639146977E+01, 5.3867791583E+00, 1.4521961018E+00, 1.0327970719E+00, 7.5961462181E-01],
	[1.7665000000E+04, 1.0643477378E+01, 5.3866000728E+00, 1.4535080990E+00, 1.0334947610E+00, 7.5972872001E-01],
	[1.7670000000E+04, 1.0647808315E+01, 5.3864210439E+00, 1.4548209082E+00, 1.0341925781E+00, 7.5984277345E-01],
	[1.7675000000E+04, 1.0652139788E+01, 5.3862420717E+00, 1.4561345295E+00, 1.0348905229E+00, 7.5995678213E-01],
	[1.7680000000E+04, 1.0656471797E+01, 5.3860631559E+00, 1.4574489633E+00, 1.0355885952E+00, 7.6007074605E-01],
	[1.7685000000E+04, 1.0660804342E+01, 5.3858842968E+00, 1.4587642099E+00, 1.0362867948E+00, 7.6018466523E-01],
	[1.7690000000E+04, 1.0665137423E+01, 5.3857054941E+00, 1.4600802695E+00, 1.0369851215E+00, 7.6029853965E-01],
	[1.7695000000E+04, 1.0669471040E+01, 5.3855267479E+00, 1.4613971423E+00, 1.0376835751E+00, 7.6041236933E-01],
	[1.7700000000E+04, 1.0673805193E+01, 5.3853480581E+00, 1.4627148288E+00, 1.0383821554E+00, 7.6052615426E-01],
	[1.7705000000E+04, 1.0678139882E+01, 5.3851694247E+00, 1.4640333290E+00, 1.0390808622E+00, 7.6063989446E-01],
	[1.7710000000E+04, 1.0682475106E+01, 5.3849908477E+00, 1.4653526433E+00, 1.0397796953E+00, 7.6075358993E-01],
	[1.7715000000E+04, 1.0686810866E+01, 5.3848123270E+00, 1.4666727720E+00, 1.0404786545E+00, 7.6086724067E-01],
	[1.7720000000E+04, 1.0691147161E+01, 5.3846338626E+00, 1.4679937154E+00, 1.0411777395E+00, 7.6098084669E-01],
	[1.7725000000E+04, 1.0695483992E+01, 5.3844554545E+00, 1.4693154736E+00, 1.0418769502E+00, 7.6109440799E-01],
	[1.7730000000E+04, 1.0699821358E+01, 5.3842771026E+00, 1.4706380471E+00, 1.0425762864E+00, 7.6120792457E-01],
	[1.7735000000E+04, 1.0704159259E+01, 5.3840988069E+00, 1.4719614359E+00, 1.0432757479E+00, 7.6132139644E-01],
	[1.7740000000E+04, 1.0708497695E+01, 5.3839205673E+00, 1.4732856405E+00, 1.0439753344E+00, 7.6143482360E-01],
	[1.7745000000E+04, 1.0712836666E+01, 5.3837423839E+00, 1.4746106611E+00, 1.0446750457E+00, 7.6154820606E-01],
	[1.7750000000E+04, 1.0717176172E+01, 5.3835642566E+00, 1.4759364980E+00, 1.0453748817E+00, 7.6166154381E-01],
	[1.7755000000E+04, 1.0721516213E+01, 5.3833861853E+00, 1.4772631514E+00, 1.0460748422E+00, 7.6177483688E-01],
	[1.7760000000E+04, 1.0725856789E+01, 5.3832081701E+00, 1.4785906216E+00, 1.0467749269E+00, 7.6188808525E-01],
	[1.7765000000E+04, 1.0730197899E+01, 5.3830302108E+00, 1.4799189089E+00, 1.0474751356E+00, 7.6200128894E-01],
	[1.7770000000E+04, 1.0734539545E+01, 5.3828523075E+00, 1.4812480136E+00, 1.0481754681E+00, 7.6211444795E-01],
	[1.7775000000E+04, 1.0738881724E+01, 5.3826744602E+00, 1.4825779358E+00, 1.0488759243E+00, 7.6222756228E-01],
	[1.7780000000E+04, 1.0743224438E+01, 5.3824966687E+00, 1.4839086760E+00, 1.0495765038E+00, 7.6234063193E-01],
	[1.7785000000E+04, 1.0747567687E+01, 5.3823189331E+00, 1.4852402343E+00, 1.0502772066E+00, 7.6245365692E-01],
	[1.7790000000E+04, 1.0751911469E+01, 5.3821412533E+00, 1.4865726111E+00, 1.0509780324E+00, 7.6256663725E-01],
	[1.7795000000E+04, 1.0756255786E+01, 5.3819636294E+00, 1.4879058065E+00, 1.0516789810E+00, 7.6267957291E-01],
	[1.7800000000E+04, 1.0760600637E+01, 5.3817860611E+00, 1.4892398210E+00, 1.0523800522E+00, 7.6279246392E-01],
	[1.7805000000E+04, 1.0764946022E+01, 5.3816085486E+00, 1.4905746546E+00, 1.0530812458E+00, 7.6290531028E-01],
	[1.7810000000E+04, 1.0769291941E+01, 5.3814310918E+00, 1.4919103079E+00, 1.0537825615E+00, 7.6301811200E-01],
	[1.7815000000E+04, 1.0773638394E+01, 5.3812536907E+00, 1.4932467809E+00, 1.0544839992E+00, 7.6313086907E-01],
	[1.7820000000E+04, 1.0777985380E+01, 5.3810763452E+00, 1.4945840739E+00, 1.0551855588E+00, 7.6324358151E-01],
	[1.7825000000E+04, 1.0782332900E+01, 5.3808990553E+00, 1.4959221873E+00, 1.0558872398E+00, 7.6335624932E-01],
	[1.7830000000E+04, 1.0786680954E+01, 5.3807218209E+00, 1.4972611213E+00, 1.0565890423E+00, 7.6346887250E-01],
	[1.7835000000E+04, 1.0791029541E+01, 5.3805446421E+00, 1.4986008762E+00, 1.0572909659E+00, 7.6358145106E-01],
	[1.7840000000E+04, 1.0795378662E+01, 5.3803675188E+00, 1.4999414522E+00, 1.0579930104E+00, 7.6369398501E-01],
	[1.7845000000E+04, 1.0799728316E+01, 5.3801904509E+00, 1.5012828497E+00, 1.0586951757E+00, 7.6380647439E-01],
	[1.7850000000E+04, 1.0804078503E+01, 5.3800134385E+00, 1.5026250688E+00, 1.0593974616E+00, 7.6391891923E-01],
	[1.7855000000E+04, 1.0808429224E+01, 5.3798364815E+00, 1.5039681099E+00, 1.0600998677E+00, 7.6403131951E-01],
	[1.7860000000E+04, 1.0812780478E+01, 5.3796595798E+00, 1.5053119732E+00, 1.0608023940E+00, 7.6414367525E-01],
	[1.7865000000E+04, 1.0817132264E+01, 5.3794827335E+00, 1.5066566591E+00, 1.0615050403E+00, 7.6425598644E-01],
	[1.7870000000E+04, 1.0821484584E+01, 5.3793059424E+00, 1.5080021677E+00, 1.0622078062E+00, 7.6436825308E-01],
	[1.7875000000E+04, 1.0825837436E+01, 5.3791292067E+00, 1.5093484994E+00, 1.0629106917E+00, 7.6448047518E-01],
	[1.7880000000E+04, 1.0830190821E+01, 5.3789525261E+00, 1.5106956543E+00, 1.0636136964E+00, 7.6459265274E-01],
	[1.7885000000E+04, 1.0834544739E+01, 5.3787759008E+00, 1.5120436329E+00, 1.0643168203E+00, 7.6470478576E-01],
	[1.7890000000E+04, 1.0838899189E+01, 5.3785993306E+00, 1.5133924354E+00, 1.0650200631E+00, 7.6481687425E-01],
	[1.7895000000E+04, 1.0843254172E+01, 5.3784228156E+00, 1.5147420619E+00, 1.0657234245E+00, 7.6492891820E-01],
	[1.7900000000E+04, 1.0847609687E+01, 5.3782463557E+00, 1.5160925129E+00, 1.0664269045E+00, 7.6504091761E-01],
	[1.7905000000E+04, 1.0851965735E+01, 5.3780699508E+00, 1.5174437886E+00, 1.0671305027E+00, 7.6515287250E-01],
	[1.7910000000E+04, 1.0856322315E+01, 5.3778936010E+00, 1.5187958892E+00, 1.0678342190E+00, 7.6526478286E-01],
	[1.7915000000E+04, 1.0860679427E+01, 5.3777173062E+00, 1.5201488150E+00, 1.0685380531E+00, 7.6537664869E-01],
	[1.7920000000E+04, 1.0865037071E+01, 5.3775410663E+00, 1.5215025663E+00, 1.0692420050E+00, 7.6548846999E-01],
	[1.7925000000E+04, 1.0869395247E+01, 5.3773648814E+00, 1.5228571434E+00, 1.0699460743E+00, 7.6560024677E-01],
	[1.7930000000E+04, 1.0873753955E+01, 5.3771887515E+00, 1.5242125465E+00, 1.0706502608E+00, 7.6571197904E-01],
	[1.7935000000E+04, 1.0878113195E+01, 5.3770126763E+00, 1.5255687759E+00, 1.0713545644E+00, 7.6582366678E-01],
	[1.7940000000E+04, 1.0882472966E+01, 5.3768366561E+00, 1.5269258319E+00, 1.0720589848E+00, 7.6593531001E-01],
	[1.7945000000E+04, 1.0886852222E+01, 5.3766652130E+00, 1.5282837148E+00, 1.0727638859E+00, 7.6604690873E-01],
	[1.7950000000E+04, 1.0891234257E+01, 5.3764943570E+00, 1.5296424247E+00, 1.0734689472E+00, 7.6615846293E-01],
	[1.7955000000E+04, 1.0895616835E+01, 5.3763235540E+00, 1.5310019621E+00, 1.0741741255E+00, 7.6626997263E-01],
	[1.7960000000E+04, 1.0899999955E+01, 5.3761528039E+00, 1.5323623271E+00, 1.0748794207E+00, 7.6638143782E-01],
	[1.7965000000E+04, 1.0904383618E+01, 5.3759821068E+00, 1.5337235201E+00, 1.0755848324E+00, 7.6649285851E-01],
	[1.7970000000E+04, 1.0908767823E+01, 5.3758114626E+00, 1.5350855413E+00, 1.0762903606E+00, 7.6660423470E-01],
	[1.7975000000E+04, 1.0913152570E+01, 5.3756408713E+00, 1.5364483909E+00, 1.0769960049E+00, 7.6671556639E-01],
	[1.7980000000E+04, 1.0917537860E+01, 5.3754703329E+00, 1.5378120693E+00, 1.0777017653E+00, 7.6682685358E-01],
	[1.7985000000E+04, 1.0921923691E+01, 5.3752998473E+00, 1.5391765768E+00, 1.0784076415E+00, 7.6693809628E-01],
	[1.7990000000E+04, 1.0926310065E+01, 5.3751294145E+00, 1.5405419135E+00, 1.0791136332E+00, 7.6704929449E-01],
	[1.7995000000E+04, 1.0930696981E+01, 5.3749590344E+00, 1.5419080798E+00, 1.0798197404E+00, 7.6716044822E-01],
	[1.8000000000E+04, 1.0935084438E+01, 5.3747887071E+00, 1.5432750759E+00, 1.0805259627E+00, 7.6727155745E-01],
	[1.8005000000E+04, 1.0939472437E+01, 5.3746184325E+00, 1.5446429021E+00, 1.0812323000E+00, 7.6738262221E-01],
	[1.8010000000E+04, 1.0943860978E+01, 5.3744482105E+00, 1.5460115588E+00, 1.0819387521E+00, 7.6749364249E-01],
	[1.8015000000E+04, 1.0948250061E+01, 5.3742780412E+00, 1.5473810460E+00, 1.0826453187E+00, 7.6760461829E-01],
	[1.8020000000E+04, 1.0952639685E+01, 5.3741079245E+00, 1.5487513642E+00, 1.0833519997E+00, 7.6771554961E-01],
	[1.8025000000E+04, 1.0957029850E+01, 5.3739378604E+00, 1.5501225136E+00, 1.0840587949E+00, 7.6782643647E-01],
	[1.8030000000E+04, 1.0961420557E+01, 5.3737678489E+00, 1.5514944945E+00, 1.0847657040E+00, 7.6793727885E-01],
	[1.8035000000E+04, 1.0965811805E+01, 5.3735978898E+00, 1.5528673071E+00, 1.0854727268E+00, 7.6804807677E-01],
	[1.8040000000E+04, 1.0970203595E+01, 5.3734279832E+00, 1.5542409518E+00, 1.0861798632E+00, 7.6815883023E-01],
	[1.8045000000E+04, 1.0974595925E+01, 5.3732581291E+00, 1.5556154287E+00, 1.0868871130E+00, 7.6826953923E-01],
	[1.8050000000E+04, 1.0978988796E+01, 5.3730883274E+00, 1.5569907381E+00, 1.0875944758E+00, 7.6838020378E-01],
	[1.8055000000E+04, 1.0983382209E+01, 5.3729185781E+00, 1.5583668804E+00, 1.0883019516E+00, 7.6849082387E-01],
	[1.8060000000E+04, 1.0987776162E+01, 5.3727488812E+00, 1.5597438558E+00, 1.0890095401E+00, 7.6860139951E-01],
	[1.8065000000E+04, 1.0992170656E+01, 5.3725792366E+00, 1.5611216646E+00, 1.0897172411E+00, 7.6871193071E-01],
	[1.8070000000E+04, 1.0996565691E+01, 5.3724096443E+00, 1.5625003070E+00, 1.0904250544E+00, 7.6882241746E-01],
	[1.8075000000E+04, 1.1000961266E+01, 5.3722401043E+00, 1.5638797833E+00, 1.0911329798E+00, 7.6893285977E-01],
	[1.8080000000E+04, 1.1005357382E+01, 5.3720706165E+00, 1.5652600939E+00, 1.0918410171E+00, 7.6904325764E-01],
	[1.8085000000E+04, 1.1009754038E+01, 5.3719011809E+00, 1.5666412389E+00, 1.0925491660E+00, 7.6915361108E-01],
	[1.8090000000E+04, 1.1014151235E+01, 5.3717317975E+00, 1.5680232186E+00, 1.0932574265E+00, 7.6926392009E-01],
	[1.8095000000E+04, 1.1018548971E+01, 5.3715624663E+00, 1.5694060333E+00, 1.0939657983E+00, 7.6937418468E-01],
	[1.8100000000E+04, 1.1022947249E+01, 5.3713931872E+00, 1.5707896833E+00, 1.0946742811E+00, 7.6948440483E-01],
	[1.8105000000E+04, 1.1027346066E+01, 5.3712239601E+00, 1.5721741688E+00, 1.0953828748E+00, 7.6959458057E-01],
	[1.8110000000E+04, 1.1031745423E+01, 5.3710547851E+00, 1.5735594902E+00, 1.0960915792E+00, 7.6970471190E-01],
	[1.8115000000E+04, 1.1036145320E+01, 5.3708856622E+00, 1.5749456477E+00, 1.0968003940E+00, 7.6981479880E-01],
	[1.8120000000E+04, 1.1040545757E+01, 5.3707165912E+00, 1.5763326415E+00, 1.0975093190E+00, 7.6992484130E-01],
	[1.8125000000E+04, 1.1044946734E+01, 5.3705475722E+00, 1.5777204719E+00, 1.0982183542E+00, 7.7003483939E-01],
	[1.8130000000E+04, 1.1049348250E+01, 5.3703786052E+00, 1.5791091393E+00, 1.0989274991E+00, 7.7014479308E-01],
	[1.8135000000E+04, 1.1053750306E+01, 5.3702096900E+00, 1.5804986439E+00, 1.0996367537E+00, 7.7025470237E-01],
	[1.8140000000E+04, 1.1058152902E+01, 5.3700408268E+00, 1.5818889859E+00, 1.1003461177E+00, 7.7036456727E-01],
	[1.8145000000E+04, 1.1062556037E+01, 5.3698720153E+00, 1.5832801656E+00, 1.1010555910E+00, 7.7047438777E-01],
	[1.8150000000E+04, 1.1066959711E+01, 5.3697032557E+00, 1.5846721833E+00, 1.1017651732E+00, 7.7058416388E-01],
	[1.8155000000E+04, 1.1071363925E+01, 5.3695345479E+00, 1.5860650393E+00, 1.1024748643E+00, 7.7069389561E-01],
	[1.8160000000E+04, 1.1075768678E+01, 5.3693658918E+00, 1.5874587339E+00, 1.1031846640E+00, 7.7080358296E-01],
	[1.8165000000E+04, 1.1080173970E+01, 5.3691972875E+00, 1.5888532672E+00, 1.1038945721E+00, 7.7091322593E-01],
	[1.8170000000E+04, 1.1084579801E+01, 5.3690287348E+00, 1.5902486397E+00, 1.1046045884E+00, 7.7102282453E-01],
	[1.8175000000E+04, 1.1088986171E+01, 5.3688602338E+00, 1.5916448515E+00, 1.1053147127E+00, 7.7113237876E-01],
	[1.8180000000E+04, 1.1093393080E+01, 5.3686917845E+00, 1.5930419029E+00, 1.1060249447E+00, 7.7124188862E-01],
	[1.8185000000E+04, 1.1097800528E+01, 5.3685233867E+00, 1.5944397942E+00, 1.1067352844E+00, 7.7135135412E-01],
	[1.8190000000E+04, 1.1102208514E+01, 5.3683550406E+00, 1.5958385257E+00, 1.1074457314E+00, 7.7146077526E-01],
	[1.8195000000E+04, 1.1106617039E+01, 5.3681867459E+00, 1.5972380977E+00, 1.1081562856E+00, 7.7157015205E-01],
	[1.8200000000E+04, 1.1111026103E+01, 5.3680185028E+00, 1.5986385104E+00, 1.1088669467E+00, 7.7167948449E-01],
	[1.8205000000E+04, 1.1115435705E+01, 5.3678503112E+00, 1.6000397640E+00, 1.1095777147E+00, 7.7178877259E-01],
	[1.8210000000E+04, 1.1119845845E+01, 5.3676821710E+00, 1.6014418590E+00, 1.1102885891E+00, 7.7189801634E-01],
	[1.8215000000E+04, 1.1124256524E+01, 5.3675140823E+00, 1.6028447954E+00, 1.1109995699E+00, 7.7200721576E-01],
	[1.8220000000E+04, 1.1128667740E+01, 5.3673460449E+00, 1.6042485737E+00, 1.1117106569E+00, 7.7211637084E-01],
	[1.8225000000E+04, 1.1133079495E+01, 5.3671780589E+00, 1.6056531941E+00, 1.1124218498E+00, 7.7222548159E-01],
	[1.8230000000E+04, 1.1137494603E+01, 5.3670107778E+00, 1.6070586568E+00, 1.1131332047E+00, 7.7233454802E-01],
	[1.8235000000E+04, 1.1141928961E+01, 5.3668478900E+00, 1.6084649621E+00, 1.1138450392E+00, 7.7244357012E-01],
	[1.8240000000E+04, 1.1146363867E+01, 5.3666850519E+00, 1.6098721103E+00, 1.1145569798E+00, 7.7255254791E-01],
	[1.8245000000E+04, 1.1150799323E+01, 5.3665222632E+00, 1.6112801018E+00, 1.1152690264E+00, 7.7266148139E-01],
	[1.8250000000E+04, 1.1155235327E+01, 5.3663595241E+00, 1.6126889366E+00, 1.1159811787E+00, 7.7277037056E-01],
	[1.8255000000E+04, 1.1159671881E+01, 5.3661968346E+00, 1.6140986152E+00, 1.1166934366E+00, 7.7287921543E-01],
	[1.8260000000E+04, 1.1164108983E+01, 5.3660341945E+00, 1.6155091377E+00, 1.1174057998E+00, 7.7298801599E-01],
	[1.8265000000E+04, 1.1168546633E+01, 5.3658716039E+00, 1.6169205045E+00, 1.1181182681E+00, 7.7309677226E-01],
	[1.8270000000E+04, 1.1172984832E+01, 5.3657090627E+00, 1.6183327159E+00, 1.1188308413E+00, 7.7320548424E-01],
	[1.8275000000E+04, 1.1177423580E+01, 5.3655465709E+00, 1.6197457720E+00, 1.1195435192E+00, 7.7331415194E-01],
	[1.8280000000E+04, 1.1181862876E+01, 5.3653841284E+00, 1.6211596733E+00, 1.1202563016E+00, 7.7342277535E-01],
	[1.8285000000E+04, 1.1186302721E+01, 5.3652217353E+00, 1.6225744198E+00, 1.1209691884E+00, 7.7353135449E-01],
	[1.8290000000E+04, 1.1190743113E+01, 5.3650593915E+00, 1.6239900120E+00, 1.1216821792E+00, 7.7363988935E-01],
	[1.8295000000E+04, 1.1195184054E+01, 5.3648970971E+00, 1.6254064501E+00, 1.1223952739E+00, 7.7374837994E-01],
	[1.8300000000E+04, 1.1199625543E+01, 5.3647348518E+00, 1.6268237344E+00, 1.1231084723E+00, 7.7385682628E-01],
	[1.8305000000E+04, 1.1204067580E+01, 5.3645726558E+00, 1.6282418651E+00, 1.1238217742E+00, 7.7396522835E-01],
	[1.8310000000E+04, 1.1208510165E+01, 5.3644105090E+00, 1.6296608425E+00, 1.1245351794E+00, 7.7407358617E-01],
	[1.8315000000E+04, 1.1212953298E+01, 5.3642484114E+00, 1.6310806669E+00, 1.1252486876E+00, 7.7418189974E-01],
	[1.8320000000E+04, 1.1217396978E+01, 5.3640863629E+00, 1.6325013386E+00, 1.1259622987E+00, 7.7429016906E-01],
	[1.8325000000E+04, 1.1221841207E+01, 5.3639243635E+00, 1.6339228578E+00, 1.1266760124E+00, 7.7439839415E-01],
	[1.8330000000E+04, 1.1226285982E+01, 5.3637624132E+00, 1.6353452248E+00, 1.1273898286E+00, 7.7450657500E-01],
	[1.8335000000E+04, 1.1230731306E+01, 5.3636005119E+00, 1.6367684399E+00, 1.1281037471E+00, 7.7461471161E-01],
	[1.8340000000E+04, 1.1235177176E+01, 5.3634386597E+00, 1.6381925033E+00, 1.1288177676E+00, 7.7472280401E-01],
	[1.8345000000E+04, 1.1239623594E+01, 5.3632768565E+00, 1.6396174153E+00, 1.1295318899E+00, 7.7483085218E-01],
	[1.8350000000E+04, 1.1244070560E+01, 5.3631151023E+00, 1.6410431763E+00, 1.1302461139E+00, 7.7493885614E-01],
	[1.8355000000E+04, 1.1248518072E+01, 5.3629533970E+00, 1.6424697864E+00, 1.1309604393E+00, 7.7504681588E-01],
	[1.8360000000E+04, 1.1252966132E+01, 5.3627917406E+00, 1.6438972459E+00, 1.1316748659E+00, 7.7515473142E-01],
	[1.8365000000E+04, 1.1257414738E+01, 5.3626301332E+00, 1.6453255551E+00, 1.1323893936E+00, 7.7526260276E-01],
	[1.8370000000E+04, 1.1261863892E+01, 5.3624685745E+00, 1.6467547144E+00, 1.1331040220E+00, 7.7537042991E-01],
	[1.8375000000E+04, 1.1266313592E+01, 5.3623070647E+00, 1.6481847239E+00, 1.1338187511E+00, 7.7547821286E-01],
	[1.8380000000E+04, 1.1270763840E+01, 5.3621456038E+00, 1.6496155839E+00, 1.1345335806E+00, 7.7558595163E-01],
	[1.8385000000E+04, 1.1275214633E+01, 5.3619841915E+00, 1.6510472947E+00, 1.1352485103E+00, 7.7569364621E-01],
	[1.8390000000E+04, 1.1279665974E+01, 5.3618228281E+00, 1.6524798566E+00, 1.1359635400E+00, 7.7580129663E-01],
	[1.8395000000E+04, 1.1284117861E+01, 5.3616615134E+00, 1.6539132699E+00, 1.1366786694E+00, 7.7590890287E-01],
	[1.8400000000E+04, 1.1288570294E+01, 5.3615002473E+00, 1.6553475347E+00, 1.1373938985E+00, 7.7601646494E-01],
	[1.8405000000E+04, 1.1293023274E+01, 5.3613390299E+00, 1.6567826515E+00, 1.1381092269E+00, 7.7612398286E-01],
	[1.8410000000E+04, 1.1297476800E+01, 5.3611778612E+00, 1.6582186204E+00, 1.1388246546E+00, 7.7623145662E-01],
	[1.8415000000E+04, 1.1301930873E+01, 5.3610167410E+00, 1.6596554418E+00, 1.1395401811E+00, 7.7633888623E-01],
	[1.8420000000E+04, 1.1306385491E+01, 5.3608556695E+00, 1.6610931158E+00, 1.1402558065E+00, 7.7644627170E-01],
	[1.8425000000E+04, 1.1310840656E+01, 5.3606946465E+00, 1.6625316429E+00, 1.1409715304E+00, 7.7655361302E-01],
	[1.8430000000E+04, 1.1315296366E+01, 5.3605336720E+00, 1.6639710232E+00, 1.1416873527E+00, 7.7666091022E-01],
	[1.8435000000E+04, 1.1319752623E+01, 5.3603727460E+00, 1.6654112571E+00, 1.1424032731E+00, 7.7676816328E-01],
	[1.8440000000E+04, 1.1324209425E+01, 5.3602118685E+00, 1.6668523447E+00, 1.1431192915E+00, 7.7687537223E-01],
	[1.8445000000E+04, 1.1328666773E+01, 5.3600510395E+00, 1.6682942865E+00, 1.1438354076E+00, 7.7698253706E-01],
	[1.8450000000E+04, 1.1333124666E+01, 5.3598902588E+00, 1.6697370825E+00, 1.1445516213E+00, 7.7708965777E-01],
	[1.8455000000E+04, 1.1337583105E+01, 5.3597295266E+00, 1.6711807332E+00, 1.1452679322E+00, 7.7719673438E-01],
	[1.8460000000E+04, 1.1342042090E+01, 5.3595688427E+00, 1.6726252388E+00, 1.1459843404E+00, 7.7730376689E-01],
	[1.8465000000E+04, 1.1346501620E+01, 5.3594082071E+00, 1.6740705996E+00, 1.1467008454E+00, 7.7741075530E-01],
	[1.8470000000E+04, 1.1350961695E+01, 5.3592476198E+00, 1.6755168158E+00, 1.1474174471E+00, 7.7751769962E-01],
	[1.8475000000E+04, 1.1355422315E+01, 5.3590870808E+00, 1.6769638877E+00, 1.1481341454E+00, 7.7762459986E-01],
	[1.8480000000E+04, 1.1359883481E+01, 5.3589265901E+00, 1.6784118156E+00, 1.1488509400E+00, 7.7773145602E-01],
	[1.8485000000E+04, 1.1364345192E+01, 5.3587661476E+00, 1.6798605997E+00, 1.1495678307E+00, 7.7783826811E-01],
	[1.8490000000E+04, 1.1368807447E+01, 5.3586057532E+00, 1.6813102404E+00, 1.1502848173E+00, 7.7794503613E-01],
	[1.8495000000E+04, 1.1373270248E+01, 5.3584454071E+00, 1.6827607379E+00, 1.1510018995E+00, 7.7805176009E-01],
	[1.8500000000E+04, 1.1377733593E+01, 5.3582851091E+00, 1.6842120925E+00, 1.1517190773E+00, 7.7815844000E-01],
	[1.8505000000E+04, 1.1382197483E+01, 5.3581248591E+00, 1.6856643044E+00, 1.1524363503E+00, 7.7826507585E-01],
	[1.8510000000E+04, 1.1386661918E+01, 5.3579646573E+00, 1.6871173740E+00, 1.1531537185E+00, 7.7837166766E-01],
	[1.8515000000E+04, 1.1391126898E+01, 5.3578045035E+00, 1.6885713014E+00, 1.1538711815E+00, 7.7847821544E-01],
	[1.8520000000E+04, 1.1395592421E+01, 5.3576443978E+00, 1.6900260871E+00, 1.1545887392E+00, 7.7858471918E-01],
	[1.8525000000E+04, 1.1400068050E+01, 5.3574864987E+00, 1.6914817311E+00, 1.1553065899E+00, 7.7869117889E-01],
	[1.8530000000E+04, 1.1404556533E+01, 5.3573314244E+00, 1.6929382339E+00, 1.1560247910E+00, 7.7879759458E-01],
	[1.8535000000E+04, 1.1409045572E+01, 5.3571763964E+00, 1.6943955957E+00, 1.1567430870E+00, 7.7890396626E-01],
	[1.8540000000E+04, 1.1413535166E+01, 5.3570214148E+00, 1.6958538167E+00, 1.1574614777E+00, 7.7901029393E-01],
	[1.8545000000E+04, 1.1418025316E+01, 5.3568664794E+00, 1.6973128973E+00, 1.1581799629E+00, 7.7911657760E-01],
	[1.8550000000E+04, 1.1422516021E+01, 5.3567115902E+00, 1.6987728376E+00, 1.1588985424E+00, 7.7922281727E-01],
	[1.8555000000E+04, 1.1427007281E+01, 5.3565567473E+00, 1.7002336381E+00, 1.1596172160E+00, 7.7932901295E-01],
	[1.8560000000E+04, 1.1431499097E+01, 5.3564019505E+00, 1.7016952989E+00, 1.1603359834E+00, 7.7943516465E-01],
	[1.8565000000E+04, 1.1435991467E+01, 5.3562472000E+00, 1.7031578203E+00, 1.1610548445E+00, 7.7954127237E-01],
	[1.8570000000E+04, 1.1440484392E+01, 5.3560924955E+00, 1.7046212027E+00, 1.1617737992E+00, 7.7964733610E-01],
	[1.8575000000E+04, 1.1444977873E+01, 5.3559378372E+00, 1.7060854462E+00, 1.1624928470E+00, 7.7975335582E-01],
	[1.8580000000E+04, 1.1449471908E+01, 5.3557832250E+00, 1.7075505512E+00, 1.1632119880E+00, 7.7985933153E-01],
	[1.8585000000E+04, 1.1453966497E+01, 5.3556286588E+00, 1.7090165178E+00, 1.1639312218E+00, 7.7996526324E-01],
	[1.8590000000E+04, 1.1458461642E+01, 5.3554741387E+00, 1.7104833465E+00, 1.1646505482E+00, 7.8007115097E-01],
	[1.8595000000E+04, 1.1462957341E+01, 5.3553196646E+00, 1.7119510375E+00, 1.1653699671E+00, 7.8017699472E-01],
	[1.8600000000E+04, 1.1467453594E+01, 5.3551652364E+00, 1.7134195910E+00, 1.1660894783E+00, 7.8028279450E-01],
	[1.8605000000E+04, 1.1471950402E+01, 5.3550108543E+00, 1.7148890073E+00, 1.1668090815E+00, 7.8038855032E-01],
	[1.8610000000E+04, 1.1476447764E+01, 5.3548565180E+00, 1.7163592866E+00, 1.1675287765E+00, 7.8049426218E-01],
	[1.8615000000E+04, 1.1480945681E+01, 5.3547022277E+00, 1.7178304294E+00, 1.1682485632E+00, 7.8059993011E-01],
	[1.8620000000E+04, 1.1485444151E+01, 5.3545479832E+00, 1.7193024358E+00, 1.1689684413E+00, 7.8070555411E-01],
	[1.8625000000E+04, 1.1489943176E+01, 5.3543937846E+00, 1.7207753061E+00, 1.1696884106E+00, 7.8081113418E-01],
	[1.8630000000E+04, 1.1494442755E+01, 5.3542396319E+00, 1.7222490405E+00, 1.1704084710E+00, 7.8091667034E-01],
	[1.8635000000E+04, 1.1498942887E+01, 5.3540855249E+00, 1.7237236395E+00, 1.1711286221E+00, 7.8102216259E-01],
	[1.8640000000E+04, 1.1503443574E+01, 5.3539314637E+00, 1.7251991031E+00, 1.1718488639E+00, 7.8112761095E-01],
	[1.8645000000E+04, 1.1507944814E+01, 5.3537774483E+00, 1.7266754318E+00, 1.1725691961E+00, 7.8123301543E-01],
	[1.8650000000E+04, 1.1512446608E+01, 5.3536234786E+00, 1.7281526257E+00, 1.1732896186E+00, 7.8133837603E-01],
	[1.8655000000E+04, 1.1516948955E+01, 5.3534695546E+00, 1.7296306852E+00, 1.1740101310E+00, 7.8144369276E-01],
	[1.8660000000E+04, 1.1521451856E+01, 5.3533156762E+00, 1.7311096105E+00, 1.1747307332E+00, 7.8154896563E-01],
	[1.8665000000E+04, 1.1525955310E+01, 5.3531618435E+00, 1.7325894019E+00, 1.1754514250E+00, 7.8165419466E-01],
	[1.8670000000E+04, 1.1530459318E+01, 5.3530080564E+00, 1.7340700596E+00, 1.1761722062E+00, 7.8175937985E-01],
	[1.8675000000E+04, 1.1534963879E+01, 5.3528543150E+00, 1.7355515840E+00, 1.1768930766E+00, 7.8186452121E-01],
	[1.8680000000E+04, 1.1539468993E+01, 5.3527006191E+00, 1.7370339753E+00, 1.1776140360E+00, 7.8196961875E-01],
	[1.8685000000E+04, 1.1543974661E+01, 5.3525469687E+00, 1.7385172338E+00, 1.1783350842E+00, 7.8207467248E-01],
	[1.8690000000E+04, 1.1548480881E+01, 5.3523933639E+00, 1.7400013598E+00, 1.1790562210E+00, 7.8217968241E-01],
	[1.8695000000E+04, 1.1552987654E+01, 5.3522398045E+00, 1.7414863535E+00, 1.1797774461E+00, 7.8228464854E-01],
	[1.8700000000E+04, 1.1557494981E+01, 5.3520862907E+00, 1.7429722152E+00, 1.1804987594E+00, 7.8238957090E-01],
	[1.8705000000E+04, 1.1562002860E+01, 5.3519328222E+00, 1.7444589452E+00, 1.1812201606E+00, 7.8249444949E-01],
	[1.8710000000E+04, 1.1566511291E+01, 5.3517793992E+00, 1.7459465976E+00, 1.1819416744E+00, 7.8259928431E-01],
	[1.8715000000E+04, 1.1571020276E+01, 5.3516260216E+00, 1.7474352235E+00, 1.1826633236E+00, 7.8270407538E-01],
	[1.8720000000E+04, 1.1575529812E+01, 5.3514726893E+00, 1.7489247189E+00, 1.1833850602E+00, 7.8280882271E-01],
	[1.8725000000E+04, 1.1580039902E+01, 5.3513194024E+00, 1.7504150838E+00, 1.1841068840E+00, 7.8291352630E-01],
	[1.8730000000E+04, 1.1584550544E+01, 5.3511661608E+00, 1.7519063186E+00, 1.1848287948E+00, 7.8301818617E-01],
	[1.8735000000E+04, 1.1589061738E+01, 5.3510129645E+00, 1.7533984236E+00, 1.1855507924E+00, 7.8312280233E-01],
	[1.8740000000E+04, 1.1593573484E+01, 5.3508598134E+00, 1.7548913990E+00, 1.1862728766E+00, 7.8322737478E-01],
	[1.8745000000E+04, 1.1598085782E+01, 5.3507067076E+00, 1.7563852452E+00, 1.1869950472E+00, 7.8333190354E-01],
	[1.8750000000E+04, 1.1602598633E+01, 5.3505536470E+00, 1.7578799623E+00, 1.1877173039E+00, 7.8343638862E-01],
	[1.8755000000E+04, 1.1607112035E+01, 5.3504006316E+00, 1.7593755507E+00, 1.1884396466E+00, 7.8354083001E-01],
	[1.8760000000E+04, 1.1611625990E+01, 5.3502476613E+00, 1.7608720106E+00, 1.1891620751E+00, 7.8364522775E-01],
	[1.8765000000E+04, 1.1616140496E+01, 5.3500947362E+00, 1.7623693423E+00, 1.1898845891E+00, 7.8374958183E-01],
	[1.8770000000E+04, 1.1620655554E+01, 5.3499418562E+00, 1.7638675461E+00, 1.1906071885E+00, 7.8385389226E-01],
	[1.8775000000E+04, 1.1625171164E+01, 5.3497890213E+00, 1.7653666222E+00, 1.1913298730E+00, 7.8395815906E-01],
	[1.8780000000E+04, 1.1629687325E+01, 5.3496362314E+00, 1.7668665710E+00, 1.1920526425E+00, 7.8406238223E-01],
	[1.8785000000E+04, 1.1634204038E+01, 5.3494834866E+00, 1.7683673927E+00, 1.1927754968E+00, 7.8416656178E-01],
	[1.8790000000E+04, 1.1638721302E+01, 5.3493307868E+00, 1.7698690875E+00, 1.1934984356E+00, 7.8427069773E-01],
	[1.8795000000E+04, 1.1643239118E+01, 5.3491781319E+00, 1.7713716558E+00, 1.1942214588E+00, 7.8437479009E-01],
	[1.8800000000E+04, 1.1647757485E+01, 5.3490255221E+00, 1.7728750979E+00, 1.1949445660E+00, 7.8447883885E-01],
	[1.8805000000E+04, 1.1652276403E+01, 5.3488729571E+00, 1.7743794139E+00, 1.1956677573E+00, 7.8458284404E-01],
	[1.8810000000E+04, 1.1656795872E+01, 5.3487204371E+00, 1.7758846042E+00, 1.1963910322E+00, 7.8468680567E-01],
	[1.8815000000E+04, 1.1661315892E+01, 5.3485679620E+00, 1.7773906690E+00, 1.1971143907E+00, 7.8479072374E-01],
	[1.8820000000E+04, 1.1665836464E+01, 5.3484155317E+00, 1.7788976087E+00, 1.1978378325E+00, 7.8489459826E-01],
	[1.8825000000E+04, 1.1670375330E+01, 5.3482670427E+00, 1.7804054235E+00, 1.1985617403E+00, 7.8499842924E-01],
	[1.8830000000E+04, 1.1674919224E+01, 5.3481195782E+00, 1.7819141136E+00, 1.1992858282E+00, 7.8510221670E-01],
	[1.8835000000E+04, 1.1679463681E+01, 5.3479721569E+00, 1.7834236793E+00, 1.2000099996E+00, 7.8520596064E-01],
	[1.8840000000E+04, 1.1684008700E+01, 5.3478247789E+00, 1.7849341210E+00, 1.2007342545E+00, 7.8530966108E-01],
	[1.8845000000E+04, 1.1688554281E+01, 5.3476774439E+00, 1.7864454389E+00, 1.2014585925E+00, 7.8541331802E-01],
	[1.8850000000E+04, 1.1693100424E+01, 5.3475301522E+00, 1.7879576332E+00, 1.2021830134E+00, 7.8551693148E-01],
	[1.8855000000E+04, 1.1697647128E+01, 5.3473829035E+00, 1.7894707043E+00, 1.2029075172E+00, 7.8562050145E-01],
	[1.8860000000E+04, 1.1702194394E+01, 5.3472356979E+00, 1.7909846523E+00, 1.2036321035E+00, 7.8572402797E-01],
	[1.8865000000E+04, 1.1706742222E+01, 5.3470885355E+00, 1.7924994777E+00, 1.2043567722E+00, 7.8582751102E-01],
	[1.8870000000E+04, 1.1711290611E+01, 5.3469414160E+00, 1.7940151806E+00, 1.2050815230E+00, 7.8593095063E-01],
	[1.8875000000E+04, 1.1715839562E+01, 5.3467943396E+00, 1.7955317614E+00, 1.2058063558E+00, 7.8603434681E-01],
	[1.8880000000E+04, 1.1720389074E+01, 5.3466473062E+00, 1.7970492202E+00, 1.2065312704E+00, 7.8613769956E-01],
	[1.8885000000E+04, 1.1724939147E+01, 5.3465003157E+00, 1.7985675575E+00, 1.2072562665E+00, 7.8624100890E-01],
	[1.8890000000E+04, 1.1729489782E+01, 5.3463533682E+00, 1.8000867734E+00, 1.2079813439E+00, 7.8634427483E-01],
	[1.8895000000E+04, 1.1734040978E+01, 5.3462064637E+00, 1.8016068682E+00, 1.2087065026E+00, 7.8644749737E-01],
	[1.8900000000E+04, 1.1738592734E+01, 5.3460596020E+00, 1.8031278422E+00, 1.2094317421E+00, 7.8655067652E-01],
	[1.8905000000E+04, 1.1743145052E+01, 5.3459127832E+00, 1.8046496958E+00, 1.2101570624E+00, 7.8665381230E-01],
	[1.8910000000E+04, 1.1747697930E+01, 5.3457660073E+00, 1.8061724290E+00, 1.2108824633E+00, 7.8675690472E-01],
	[1.8915000000E+04, 1.1752251370E+01, 5.3456192742E+00, 1.8076960423E+00, 1.2116079444E+00, 7.8685995378E-01],
	[1.8920000000E+04, 1.1756805370E+01, 5.3454725839E+00, 1.8092205359E+00, 1.2123335058E+00, 7.8696295950E-01],
	[1.8925000000E+04, 1.1761359931E+01, 5.3453259364E+00, 1.8107459101E+00, 1.2130591470E+00, 7.8706592188E-01],
	[1.8930000000E+04, 1.1765915052E+01, 5.3451793317E+00, 1.8122721651E+00, 1.2137848680E+00, 7.8716884095E-01],
	[1.8935000000E+04, 1.1770470734E+01, 5.3450327697E+00, 1.8137993012E+00, 1.2145106685E+00, 7.8727171670E-01],
	[1.8940000000E+04, 1.1775026976E+01, 5.3448862504E+00, 1.8153273187E+00, 1.2152365484E+00, 7.8737454915E-01],
	[1.8945000000E+04, 1.1779583778E+01, 5.3447397738E+00, 1.8168562179E+00, 1.2159625073E+00, 7.8747733832E-01],
	[1.8950000000E+04, 1.1784141141E+01, 5.3445933399E+00, 1.8183859991E+00, 1.2166885452E+00, 7.8758008420E-01],
	[1.8955000000E+04, 1.1788699064E+01, 5.3444469486E+00, 1.8199166625E+00, 1.2174146618E+00, 7.8768278681E-01],
	[1.8960000000E+04, 1.1793257547E+01, 5.3443005999E+00, 1.8214482083E+00, 1.2181408570E+00, 7.8778544616E-01],
	[1.8965000000E+04, 1.1797816590E+01, 5.3441542938E+00, 1.8229806370E+00, 1.2188671304E+00, 7.8788806226E-01],
	[1.8970000000E+04, 1.1802376193E+01, 5.3440080303E+00, 1.8245139486E+00, 1.2195934820E+00, 7.8799063512E-01],
	[1.8975000000E+04, 1.1806936356E+01, 5.3438618094E+00, 1.8260481436E+00, 1.2203199115E+00, 7.8809316476E-01],
	[1.8980000000E+04, 1.1811497079E+01, 5.3437156309E+00, 1.8275832222E+00, 1.2210464187E+00, 7.8819565117E-01],
	[1.8985000000E+04, 1.1816058361E+01, 5.3435694950E+00, 1.8291191847E+00, 1.2217730034E+00, 7.8829809438E-01],
	[1.8990000000E+04, 1.1820620203E+01, 5.3434234016E+00, 1.8306560312E+00, 1.2224996654E+00, 7.8840049440E-01],
	[1.8995000000E+04, 1.1825182604E+01, 5.3432773506E+00, 1.8321937622E+00, 1.2232264045E+00, 7.8850285122E-01],
	[1.9000000000E+04, 1.1829745565E+01, 5.3431313420E+00, 1.8337323779E+00, 1.2239532205E+00, 7.8860516488E-01],
	[1.9005000000E+04, 1.1834309086E+01, 5.3429853758E+00, 1.8352718786E+00, 1.2246801132E+00, 7.8870743536E-01],
	[1.9010000000E+04, 1.1838873165E+01, 5.3428394520E+00, 1.8368122645E+00, 1.2254070824E+00, 7.8880966270E-01],
	[1.9015000000E+04, 1.1843437804E+01, 5.3426935706E+00, 1.8383535359E+00, 1.2261341279E+00, 7.8891184689E-01],
	[1.9020000000E+04, 1.1848003002E+01, 5.3425477315E+00, 1.8398956931E+00, 1.2268612496E+00, 7.8901398795E-01],
	[1.9025000000E+04, 1.1852568759E+01, 5.3424019347E+00, 1.8414387363E+00, 1.2275884471E+00, 7.8911608588E-01],
	[1.9030000000E+04, 1.1857135075E+01, 5.3422561803E+00, 1.8429826659E+00, 1.2283157203E+00, 7.8921814071E-01],
	[1.9035000000E+04, 1.1861701950E+01, 5.3421104680E+00, 1.8445274821E+00, 1.2290430689E+00, 7.8932015243E-01],
	[1.9040000000E+04, 1.1866269384E+01, 5.3419647981E+00, 1.8460731852E+00, 1.2297704929E+00, 7.8942212106E-01],
	[1.9045000000E+04, 1.1870837377E+01, 5.3418191703E+00, 1.8476197755E+00, 1.2304979920E+00, 7.8952404662E-01],
	[1.9050000000E+04, 1.1875405928E+01, 5.3416735847E+00, 1.8491672531E+00, 1.2312255659E+00, 7.8962592910E-01],
	[1.9055000000E+04, 1.1879975038E+01, 5.3415280414E+00, 1.8507156185E+00, 1.2319532146E+00, 7.8972776853E-01],
	[1.9060000000E+04, 1.1884544706E+01, 5.3413825401E+00, 1.8522648719E+00, 1.2326809377E+00, 7.8982956491E-01],
	[1.9065000000E+04, 1.1889114933E+01, 5.3412370810E+00, 1.8538150135E+00, 1.2334087351E+00, 7.8993131825E-01],
	[1.9070000000E+04, 1.1893685718E+01, 5.3410916640E+00, 1.8553660437E+00, 1.2341366066E+00, 7.9003302857E-01],
	[1.9075000000E+04, 1.1898257062E+01, 5.3409462891E+00, 1.8569179626E+00, 1.2348645519E+00, 7.9013469588E-01],
	[1.9080000000E+04, 1.1902828963E+01, 5.3408009562E+00, 1.8584707707E+00, 1.2355925709E+00, 7.9023632018E-01],
	[1.9085000000E+04, 1.1907401423E+01, 5.3406556653E+00, 1.8600244681E+00, 1.2363206634E+00, 7.9033790149E-01],
	[1.9090000000E+04, 1.1911974441E+01, 5.3405104165E+00, 1.8615790551E+00, 1.2370488292E+00, 7.9043943981E-01],
	[1.9095000000E+04, 1.1916548017E+01, 5.3403652097E+00, 1.8631345320E+00, 1.2377770681E+00, 7.9054093517E-01],
	[1.9100000000E+04, 1.1921122151E+01, 5.3402200448E+00, 1.8646908991E+00, 1.2385053798E+00, 7.9064238757E-01],
	[1.9105000000E+04, 1.1925696842E+01, 5.3400749218E+00, 1.8662481567E+00, 1.2392337642E+00, 7.9074379701E-01],
	[1.9110000000E+04, 1.1930272092E+01, 5.3399298408E+00, 1.8678063050E+00, 1.2399622211E+00, 7.9084516352E-01],
	[1.9115000000E+04, 1.1934847899E+01, 5.3397848017E+00, 1.8693653443E+00, 1.2406907502E+00, 7.9094648710E-01],
	[1.9120000000E+04, 1.1939424263E+01, 5.3396398044E+00, 1.8709252749E+00, 1.2414193514E+00, 7.9104776776E-01],
	[1.9125000000E+04, 1.1944005705E+01, 5.3394958147E+00, 1.8724860970E+00, 1.2421481256E+00, 7.9114900552E-01],
	[1.9130000000E+04, 1.1948605754E+01, 5.3393557202E+00, 1.8740478109E+00, 1.2428773757E+00, 7.9125020039E-01],
	[1.9135000000E+04, 1.1953206371E+01, 5.3392156661E+00, 1.8756104170E+00, 1.2436066982E+00, 7.9135135237E-01],
	[1.9140000000E+04, 1.1957807556E+01, 5.3390756522E+00, 1.8771739154E+00, 1.2443360928E+00, 7.9145246148E-01],
	[1.9145000000E+04, 1.1962409311E+01, 5.3389356785E+00, 1.8787383065E+00, 1.2450655593E+00, 7.9155352772E-01],
	[1.9150000000E+04, 1.1967011634E+01, 5.3387957450E+00, 1.8803035905E+00, 1.2457950976E+00, 7.9165455112E-01],
	[1.9155000000E+04, 1.1971614525E+01, 5.3386558518E+00, 1.8818697677E+00, 1.2465247074E+00, 7.9175553168E-01],
	[1.9160000000E+04, 1.1976217985E+01, 5.3385159987E+00, 1.8834368384E+00, 1.2472543886E+00, 7.9185646941E-01],
	[1.9165000000E+04, 1.1980822013E+01, 5.3383761858E+00, 1.8850048028E+00, 1.2479841409E+00, 7.9195736432E-01],
	[1.9170000000E+04, 1.1985426609E+01, 5.3382364130E+00, 1.8865736613E+00, 1.2487139642E+00, 7.9205821643E-01],
	[1.9175000000E+04, 1.1990031774E+01, 5.3380966803E+00, 1.8881434140E+00, 1.2494438582E+00, 7.9215902574E-01],
	[1.9180000000E+04, 1.1994637507E+01, 5.3379569877E+00, 1.8897140613E+00, 1.2501738227E+00, 7.9225979227E-01],
	[1.9185000000E+04, 1.1999243807E+01, 5.3378173352E+00, 1.8912856035E+00, 1.2509038575E+00, 7.9236051602E-01],
	[1.9190000000E+04, 1.2003850676E+01, 5.3376777227E+00, 1.8928580408E+00, 1.2516339625E+00, 7.9246119702E-01],
	[1.9195000000E+04, 1.2008458112E+01, 5.3375381503E+00, 1.8944313735E+00, 1.2523641375E+00, 7.9256183526E-01],
	[1.9200000000E+04, 1.2013066116E+01, 5.3373986178E+00, 1.8960056019E+00, 1.2530943822E+00, 7.9266243077E-01],
	[1.9205000000E+04, 1.2017674688E+01, 5.3372591253E+00, 1.8975807262E+00, 1.2538246964E+00, 7.9276298354E-01],
	[1.9210000000E+04, 1.2022283828E+01, 5.3371196728E+00, 1.8991567468E+00, 1.2545550799E+00, 7.9286349361E-01],
	[1.9215000000E+04, 1.2026893535E+01, 5.3369802602E+00, 1.9007336638E+00, 1.2552855326E+00, 7.9296396096E-01],
	[1.9220000000E+04, 1.2031503809E+01, 5.3368408875E+00, 1.9023114776E+00, 1.2560160542E+00, 7.9306438562E-01],
	[1.9225000000E+04, 1.2036114651E+01, 5.3367015548E+00, 1.9038901885E+00, 1.2567466446E+00, 7.9316476760E-01],
	[1.9230000000E+04, 1.2040726060E+01, 5.3365622618E+00, 1.9054697967E+00, 1.2574773035E+00, 7.9326510691E-01],
	[1.9235000000E+04, 1.2045338037E+01, 5.3364230088E+00, 1.9070503025E+00, 1.2582080307E+00, 7.9336540356E-01],
	[1.9240000000E+04, 1.2049950580E+01, 5.3362837955E+00, 1.9086317061E+00, 1.2589388261E+00, 7.9346565756E-01],
	[1.9245000000E+04, 1.2054563691E+01, 5.3361446221E+00, 1.9102140079E+00, 1.2596696894E+00, 7.9356586892E-01],
	[1.9250000000E+04, 1.2059177368E+01, 5.3360054884E+00, 1.9117972082E+00, 1.2604006204E+00, 7.9366603766E-01],
	[1.9255000000E+04, 1.2063791613E+01, 5.3358663945E+00, 1.9133813071E+00, 1.2611316190E+00, 7.9376616378E-01],
	[1.9260000000E+04, 1.2068406424E+01, 5.3357273403E+00, 1.9149663050E+00, 1.2618626849E+00, 7.9386624730E-01],
	[1.9265000000E+04, 1.2073021803E+01, 5.3355883259E+00, 1.9165522022E+00, 1.2625938180E+00, 7.9396628822E-01],
	[1.9270000000E+04, 1.2077637747E+01, 5.3354493512E+00, 1.9181389988E+00, 1.2633250180E+00, 7.9406628655E-01],
	[1.9275000000E+04, 1.2082254259E+01, 5.3353104161E+00, 1.9197266953E+00, 1.2640562847E+00, 7.9416624224E-01],
	[1.9280000000E+04, 1.2086871337E+01, 5.3351715207E+00, 1.9213152918E+00, 1.2647876180E+00, 7.9426615530E-01],
	[1.9285000000E+04, 1.2091488981E+01, 5.3350326649E+00, 1.9229047887E+00, 1.2655190176E+00, 7.9436602572E-01],
	[1.9290000000E+04, 1.2096107192E+01, 5.3348938487E+00, 1.9244951862E+00, 1.2662504833E+00, 7.9446585351E-01],
	[1.9295000000E+04, 1.2100725969E+01, 5.3347550721E+00, 1.9260864846E+00, 1.2669820150E+00, 7.9456563868E-01],
	[1.9300000000E+04, 1.2105345312E+01, 5.3346163350E+00, 1.9276786842E+00, 1.2677136125E+00, 7.9466538124E-01],
	[1.9305000000E+04, 1.2109965222E+01, 5.3344776376E+00, 1.9292717853E+00, 1.2684452754E+00, 7.9476508119E-01],
	[1.9310000000E+04, 1.2114585697E+01, 5.3343389796E+00, 1.9308657880E+00, 1.2691770037E+00, 7.9486473853E-01],
	[1.9315000000E+04, 1.2119206739E+01, 5.3342003611E+00, 1.9324606928E+00, 1.2699087972E+00, 7.9496435327E-01],
	[1.9320000000E+04, 1.2123828346E+01, 5.3340617821E+00, 1.9340564998E+00, 1.2706406556E+00, 7.9506392541E-01],
	[1.9325000000E+04, 1.2128450519E+01, 5.3339232426E+00, 1.9356532094E+00, 1.2713725787E+00, 7.9516345497E-01],
	[1.9330000000E+04, 1.2133073258E+01, 5.3337847425E+00, 1.9372508218E+00, 1.2721045664E+00, 7.9526294195E-01],
	[1.9335000000E+04, 1.2137696563E+01, 5.3336462819E+00, 1.9388493373E+00, 1.2728366184E+00, 7.9536238635E-01],
	[1.9340000000E+04, 1.2142320433E+01, 5.3335078606E+00, 1.9404487561E+00, 1.2735687346E+00, 7.9546178818E-01],
	[1.9345000000E+04, 1.2146944869E+01, 5.3333694787E+00, 1.9420490786E+00, 1.2743009147E+00, 7.9556114745E-01],
	[1.9350000000E+04, 1.2151569870E+01, 5.3332311361E+00, 1.9436503051E+00, 1.2750331586E+00, 7.9566046415E-01],
	[1.9355000000E+04, 1.2156195437E+01, 5.3330928329E+00, 1.9452524357E+00, 1.2757654660E+00, 7.9575973831E-01],
	[1.9360000000E+04, 1.2160821569E+01, 5.3329545690E+00, 1.9468554709E+00, 1.2764978368E+00, 7.9585896992E-01],
	[1.9365000000E+04, 1.2165448266E+01, 5.3328163443E+00, 1.9484594107E+00, 1.2772302707E+00, 7.9595815898E-01],
	[1.9370000000E+04, 1.2170075528E+01, 5.3326781590E+00, 1.9500642556E+00, 1.2779627676E+00, 7.9605730551E-01],
	[1.9375000000E+04, 1.2174703355E+01, 5.3325400129E+00, 1.9516700058E+00, 1.2786953272E+00, 7.9615640951E-01],
	[1.9380000000E+04, 1.2179331747E+01, 5.3324019060E+00, 1.9532766616E+00, 1.2794279494E+00, 7.9625547099E-01],
	[1.9385000000E+04, 1.2183960705E+01, 5.3322638383E+00, 1.9548842232E+00, 1.2801606339E+00, 7.9635448995E-01],
	[1.9390000000E+04, 1.2188590227E+01, 5.3321258098E+00, 1.9564926910E+00, 1.2808933806E+00, 7.9645346640E-01],
	[1.9395000000E+04, 1.2193220313E+01, 5.3319878204E+00, 1.9581020651E+00, 1.2816261892E+00, 7.9655240035E-01],
	[1.9400000000E+04, 1.2197850965E+01, 5.3318498702E+00, 1.9597123459E+00, 1.2823590596E+00, 7.9665129180E-01],
	[1.9405000000E+04, 1.2202482181E+01, 5.3317119591E+00, 1.9613235337E+00, 1.2830919916E+00, 7.9675014075E-01],
	[1.9410000000E+04, 1.2207113962E+01, 5.3315740871E+00, 1.9629356287E+00, 1.2838249849E+00, 7.9684894722E-01],
	[1.9415000000E+04, 1.2211746307E+01, 5.3314362542E+00, 1.9645486312E+00, 1.2845580394E+00, 7.9694771121E-01],
	[1.9420000000E+04, 1.2216379216E+01, 5.3312984603E+00, 1.9661625415E+00, 1.2852911548E+00, 7.9704643272E-01],
	[1.9425000000E+04, 1.2221012690E+01, 5.3311607055E+00, 1.9677773599E+00, 1.2860243311E+00, 7.9714511177E-01],
	[1.9430000000E+04, 1.2225646728E+01, 5.3310229896E+00, 1.9693930865E+00, 1.2867575678E+00, 7.9724374835E-01],
	[1.9435000000E+04, 1.2230295687E+01, 5.3308882954E+00, 1.9710097218E+00, 1.2874911981E+00, 7.9734234248E-01],
	[1.9440000000E+04, 1.2234953787E+01, 5.3307554189E+00, 1.9726272660E+00, 1.2882250880E+00, 7.9744089416E-01],
	[1.9445000000E+04, 1.2239612463E+01, 5.3306225799E+00, 1.9742457193E+00, 1.2889590387E+00, 7.9753940340E-01],
	[1.9450000000E+04, 1.2244271714E+01, 5.3304897783E+00, 1.9758650820E+00, 1.2896930502E+00, 7.9763787021E-01],
	[1.9455000000E+04, 1.2248931540E+01, 5.3303570141E+00, 1.9774853545E+00, 1.2904271221E+00, 7.9773629458E-01],
	[1.9460000000E+04, 1.2253591942E+01, 5.3302242874E+00, 1.9791065369E+00, 1.2911612543E+00, 7.9783467653E-01],
	[1.9465000000E+04, 1.2258252919E+01, 5.3300915981E+00, 1.9807286296E+00, 1.2918954465E+00, 7.9793301607E-01],
	[1.9470000000E+04, 1.2262914471E+01, 5.3299589462E+00, 1.9823516328E+00, 1.2926296987E+00, 7.9803131319E-01],
	[1.9475000000E+04, 1.2267576598E+01, 5.3298263316E+00, 1.9839755468E+00, 1.2933640105E+00, 7.9812956792E-01],
	[1.9480000000E+04, 1.2272239300E+01, 5.3296937544E+00, 1.9856003720E+00, 1.2940983818E+00, 7.9822778024E-01],
	[1.9485000000E+04, 1.2276902577E+01, 5.3295612145E+00, 1.9872261084E+00, 1.2948328124E+00, 7.9832595018E-01],
	[1.9490000000E+04, 1.2281566429E+01, 5.3294287118E+00, 1.9888527565E+00, 1.2955673021E+00, 7.9842407773E-01],
	[1.9495000000E+04, 1.2286230855E+01, 5.3292962465E+00, 1.9904803166E+00, 1.2963018507E+00, 7.9852216290E-01],
	[1.9500000000E+04, 1.2290895857E+01, 5.3291638185E+00, 1.9921087888E+00, 1.2970364579E+00, 7.9862020571E-01],
	[1.9505000000E+04, 1.2295561432E+01, 5.3290314276E+00, 1.9937381734E+00, 1.2977711237E+00, 7.9871820615E-01],
	[1.9510000000E+04, 1.2300227583E+01, 5.3288990740E+00, 1.9953684708E+00, 1.2985058478E+00, 7.9881616424E-01],
	[1.9515000000E+04, 1.2304894307E+01, 5.3287667576E+00, 1.9969996812E+00, 1.2992406299E+00, 7.9891407997E-01],
	[1.9520000000E+04, 1.2309561607E+01, 5.3286344784E+00, 1.9986318049E+00, 1.2999754700E+00, 7.9901195336E-01],
	[1.9525000000E+04, 1.2314229480E+01, 5.3285022363E+00, 2.0002648422E+00, 1.3007103678E+00, 7.9910978442E-01],
	[1.9530000000E+04, 1.2318897927E+01, 5.3283700314E+00, 2.0018987933E+00, 1.3014453231E+00, 7.9920757315E-01],
	[1.9535000000E+04, 1.2323566949E+01, 5.3282378636E+00, 2.0035336585E+00, 1.3021803357E+00, 7.9930531955E-01],
	[1.9540000000E+04, 1.2328236545E+01, 5.3281057329E+00, 2.0051694381E+00, 1.3029154054E+00, 7.9940302364E-01],
	[1.9545000000E+04, 1.2332906715E+01, 5.3279736393E+00, 2.0068061324E+00, 1.3036505321E+00, 7.9950068542E-01],
	[1.9550000000E+04, 1.2337577458E+01, 5.3278415827E+00, 2.0084437416E+00, 1.3043857155E+00, 7.9959830490E-01],
	[1.9555000000E+04, 1.2342248776E+01, 5.3277095632E+00, 2.0100822661E+00, 1.3051209553E+00, 7.9969588208E-01],
	[1.9560000000E+04, 1.2346920667E+01, 5.3275775807E+00, 2.0117217060E+00, 1.3058562516E+00, 7.9979341698E-01],
	[1.9565000000E+04, 1.2351593132E+01, 5.3274456352E+00, 2.0133620617E+00, 1.3065916039E+00, 7.9989090959E-01],
	[1.9570000000E+04, 1.2356266170E+01, 5.3273137267E+00, 2.0150033334E+00, 1.3073270122E+00, 7.9998835993E-01],
	[1.9575000000E+04, 1.2360939782E+01, 5.3271818552E+00, 2.0166455215E+00, 1.3080624763E+00, 8.0008576801E-01],
	[1.9580000000E+04, 1.2365613968E+01, 5.3270500206E+00, 2.0182886262E+00, 1.3087979958E+00, 8.0018313382E-01],
	[1.9585000000E+04, 1.2370288727E+01, 5.3269182229E+00, 2.0199326477E+00, 1.3095335707E+00, 8.0028045738E-01],
	[1.9590000000E+04, 1.2374964059E+01, 5.3267864621E+00, 2.0215775864E+00, 1.3102692008E+00, 8.0037773870E-01],
	[1.9595000000E+04, 1.2379639964E+01, 5.3266547382E+00, 2.0232234425E+00, 1.3110048858E+00, 8.0047497778E-01],
	[1.9600000000E+04, 1.2384316442E+01, 5.3265230512E+00, 2.0248702163E+00, 1.3117406256E+00, 8.0057217463E-01],
	[1.9605000000E+04, 1.2388993494E+01, 5.3263914010E+00, 2.0265179081E+00, 1.3124764199E+00, 8.0066932925E-01],
	[1.9610000000E+04, 1.2393671118E+01, 5.3262597876E+00, 2.0281665181E+00, 1.3132122686E+00, 8.0076644166E-01],
	[1.9615000000E+04, 1.2398349316E+01, 5.3261282111E+00, 2.0298160466E+00, 1.3139481715E+00, 8.0086351186E-01],
	[1.9620000000E+04, 1.2403028086E+01, 5.3259966713E+00, 2.0314664940E+00, 1.3146841283E+00, 8.0096053986E-01],
	[1.9625000000E+04, 1.2407707429E+01, 5.3258651683E+00, 2.0331178604E+00, 1.3154201389E+00, 8.0105752567E-01],
	[1.9630000000E+04, 1.2412387345E+01, 5.3257337020E+00, 2.0347701462E+00, 1.3161562031E+00, 8.0115446928E-01],
	[1.9635000000E+04, 1.2417067833E+01, 5.3256022725E+00, 2.0364233516E+00, 1.3168923207E+00, 8.0125137072E-01],
	[1.9640000000E+04, 1.2421748894E+01, 5.3254708796E+00, 2.0380774770E+00, 1.3176284914E+00, 8.0134822999E-01],
	[1.9645000000E+04, 1.2426430527E+01, 5.3253395235E+00, 2.0397325225E+00, 1.3183647151E+00, 8.0144504709E-01],
	[1.9650000000E+04, 1.2431112733E+01, 5.3252082040E+00, 2.0413884884E+00, 1.3191009917E+00, 8.0154182203E-01],
	[1.9655000000E+04, 1.2435795511E+01, 5.3250769212E+00, 2.0430453751E+00, 1.3198373208E+00, 8.0163855482E-01],
	[1.9660000000E+04, 1.2440478861E+01, 5.3249456750E+00, 2.0447031828E+00, 1.3205737023E+00, 8.0173524547E-01],
	[1.9665000000E+04, 1.2445162783E+01, 5.3248144654E+00, 2.0463619118E+00, 1.3213101361E+00, 8.0183189399E-01],
	[1.9670000000E+04, 1.2449847278E+01, 5.3246832924E+00, 2.0480215624E+00, 1.3220466218E+00, 8.0192850038E-01],
	[1.9675000000E+04, 1.2454532344E+01, 5.3245521559E+00, 2.0496821348E+00, 1.3227831594E+00, 8.0202506465E-01],
	[1.9680000000E+04, 1.2459217983E+01, 5.3244210560E+00, 2.0513436293E+00, 1.3235197485E+00, 8.0212158681E-01],
	[1.9685000000E+04, 1.2463904193E+01, 5.3242899927E+00, 2.0530060461E+00, 1.3242563891E+00, 8.0221806686E-01],
	[1.9690000000E+04, 1.2468590975E+01, 5.3241589658E+00, 2.0546693857E+00, 1.3249930809E+00, 8.0231450482E-01],
	[1.9695000000E+04, 1.2473278328E+01, 5.3240279755E+00, 2.0563336482E+00, 1.3257298238E+00, 8.0241090069E-01],
	[1.9700000000E+04, 1.2477966254E+01, 5.3238970216E+00, 2.0579988339E+00, 1.3264666175E+00, 8.0250725447E-01],
	[1.9705000000E+04, 1.2482654751E+01, 5.3237661041E+00, 2.0596649431E+00, 1.3272034618E+00, 8.0260356619E-01],
	[1.9710000000E+04, 1.2487343819E+01, 5.3236352231E+00, 2.0613319761E+00, 1.3279403565E+00, 8.0269983584E-01],
	[1.9715000000E+04, 1.2492033459E+01, 5.3235043786E+00, 2.0629999331E+00, 1.3286773016E+00, 8.0279606342E-01],
	[1.9720000000E+04, 1.2496723670E+01, 5.3233735704E+00, 2.0646688145E+00, 1.3294142966E+00, 8.0289224896E-01],
	[1.9725000000E+04, 1.2501414452E+01, 5.3232427986E+00, 2.0663386204E+00, 1.3301513416E+00, 8.0298839246E-01],
	[1.9730000000E+04, 1.2506105806E+01, 5.3231120631E+00, 2.0680093512E+00, 1.3308884361E+00, 8.0308449393E-01],
	[1.9735000000E+04, 1.2510797730E+01, 5.3229813640E+00, 2.0696810072E+00, 1.3316255802E+00, 8.0318055336E-01],
	[1.9740000000E+04, 1.2515490226E+01, 5.3228507012E+00, 2.0713535886E+00, 1.3323627735E+00, 8.0327657078E-01],
	[1.9745000000E+04, 1.2520184712E+01, 5.3227203615E+00, 2.0730270957E+00, 1.3331000500E+00, 8.0337254619E-01],
	[1.9750000000E+04, 1.2524901643E+01, 5.3225944771E+00, 2.0747015287E+00, 1.3338379010E+00, 8.0346847959E-01],
	[1.9755000000E+04, 1.2529619158E+01, 5.3224686275E+00, 2.0763768881E+00, 1.3345758017E+00, 8.0356437100E-01],
	[1.9760000000E+04, 1.2534337254E+01, 5.3223428127E+00, 2.0780531739E+00, 1.3353137517E+00, 8.0366022042E-01],
	[1.9765000000E+04, 1.2539055933E+01, 5.3222170327E+00, 2.0797303866E+00, 1.3360517509E+00, 8.0375602787E-01],
	[1.9770000000E+04, 1.2543775194E+01, 5.3220912875E+00, 2.0814085263E+00, 1.3367897992E+00, 8.0385179334E-01],
	[1.9775000000E+04, 1.2548495037E+01, 5.3219655771E+00, 2.0830875934E+00, 1.3375278962E+00, 8.0394751685E-01],
	[1.9780000000E+04, 1.2553215462E+01, 5.3218399014E+00, 2.0847675881E+00, 1.3382660419E+00, 8.0404319841E-01],
	[1.9785000000E+04, 1.2557936469E+01, 5.3217142604E+00, 2.0864485108E+00, 1.3390042361E+00, 8.0413883802E-01],
	[1.9790000000E+04, 1.2562658058E+01, 5.3215886542E+00, 2.0881303616E+00, 1.3397424784E+00, 8.0423443569E-01],
	[1.9795000000E+04, 1.2567380228E+01, 5.3214630826E+00, 2.0898131409E+00, 1.3404807689E+00, 8.0432999143E-01],
	[1.9800000000E+04, 1.2572102981E+01, 5.3213375458E+00, 2.0914968490E+00, 1.3412191071E+00, 8.0442550525E-01],
	[1.9805000000E+04, 1.2576826315E+01, 5.3212120436E+00, 2.0931814860E+00, 1.3419574930E+00, 8.0452097716E-01],
	[1.9810000000E+04, 1.2581550230E+01, 5.3210865760E+00, 2.0948670523E+00, 1.3426959264E+00, 8.0461640716E-01],
	[1.9815000000E+04, 1.2586274727E+01, 5.3209611430E+00, 2.0965535483E+00, 1.3434344071E+00, 8.0471179526E-01],
	[1.9820000000E+04, 1.2590999806E+01, 5.3208357447E+00, 2.0982409740E+00, 1.3441729348E+00, 8.0480714148E-01],
	[1.9825000000E+04, 1.2595725466E+01, 5.3207103809E+00, 2.0999293299E+00, 1.3449115094E+00, 8.0490244581E-01],
	[1.9830000000E+04, 1.2600451707E+01, 5.3205850517E+00, 2.1016186162E+00, 1.3456501307E+00, 8.0499770828E-01],
	[1.9835000000E+04, 1.2605178529E+01, 5.3204597571E+00, 2.1033088331E+00, 1.3463887985E+00, 8.0509292888E-01],
	[1.9840000000E+04, 1.2609905933E+01, 5.3203344970E+00, 2.1049999810E+00, 1.3471275126E+00, 8.0518810762E-01],
	[1.9845000000E+04, 1.2614633917E+01, 5.3202092714E+00, 2.1066920601E+00, 1.3478662727E+00, 8.0528324451E-01],
	[1.9850000000E+04, 1.2619362483E+01, 5.3200840803E+00, 2.1083850708E+00, 1.3486050788E+00, 8.0537833957E-01],
	[1.9855000000E+04, 1.2624091629E+01, 5.3199589236E+00, 2.1100790132E+00, 1.3493439307E+00, 8.0547339280E-01],
	[1.9860000000E+04, 1.2628821356E+01, 5.3198338014E+00, 2.1117738876E+00, 1.3500828280E+00, 8.0556840421E-01],
	[1.9865000000E+04, 1.2633551664E+01, 5.3197087137E+00, 2.1134696944E+00, 1.3508217707E+00, 8.0566337380E-01],
	[1.9870000000E+04, 1.2638282553E+01, 5.3195836604E+00, 2.1151664338E+00, 1.3515607585E+00, 8.0575830159E-01],
	[1.9875000000E+04, 1.2643014022E+01, 5.3194586415E+00, 2.1168641061E+00, 1.3522997912E+00, 8.0585318758E-01],
	[1.9880000000E+04, 1.2647746072E+01, 5.3193336569E+00, 2.1185627116E+00, 1.3530388687E+00, 8.0594803178E-01],
	[1.9885000000E+04, 1.2652478702E+01, 5.3192087068E+00, 2.1202622505E+00, 1.3537779908E+00, 8.0604283421E-01],
	[1.9890000000E+04, 1.2657211913E+01, 5.3190837909E+00, 2.1219627231E+00, 1.3545171572E+00, 8.0613759486E-01],
	[1.9895000000E+04, 1.2661945704E+01, 5.3189589094E+00, 2.1236641296E+00, 1.3552563678E+00, 8.0623231376E-01],
	[1.9900000000E+04, 1.2666680075E+01, 5.3188340623E+00, 2.1253664705E+00, 1.3559956224E+00, 8.0632699090E-01],
	[1.9905000000E+04, 1.2671415026E+01, 5.3187092494E+00, 2.1270697459E+00, 1.3567349208E+00, 8.0642162629E-01],
	[1.9910000000E+04, 1.2676150557E+01, 5.3185844708E+00, 2.1287739561E+00, 1.3574742627E+00, 8.0651621995E-01],
	[1.9915000000E+04, 1.2680886668E+01, 5.3184597264E+00, 2.1304791014E+00, 1.3582136481E+00, 8.0661077189E-01],
	[1.9920000000E+04, 1.2685623360E+01, 5.3183350163E+00, 2.1321851821E+00, 1.3589530767E+00, 8.0670528210E-01],
	[1.9925000000E+04, 1.2690360631E+01, 5.3182103404E+00, 2.1338921985E+00, 1.3596925482E+00, 8.0679975061E-01],
	[1.9930000000E+04, 1.2695098482E+01, 5.3180856987E+00, 2.1356001507E+00, 1.3604320626E+00, 8.0689417741E-01],
	[1.9935000000E+04, 1.2699836912E+01, 5.3179610912E+00, 2.1373090392E+00, 1.3611716197E+00, 8.0698856253E-01],
	[1.9940000000E+04, 1.2704575922E+01, 5.3178365179E+00, 2.1390188641E+00, 1.3619112191E+00, 8.0708290596E-01],
	[1.9945000000E+04, 1.2709315512E+01, 5.3177119787E+00, 2.1407296258E+00, 1.3626508608E+00, 8.0717720771E-01],
	[1.9950000000E+04, 1.2714055681E+01, 5.3175874737E+00, 2.1424413246E+00, 1.3633905446E+00, 8.0727146780E-01],
	[1.9955000000E+04, 1.2718796430E+01, 5.3174630027E+00, 2.1441539606E+00, 1.3641302702E+00, 8.0736568624E-01],
	[1.9960000000E+04, 1.2723537758E+01, 5.3173385659E+00, 2.1458675342E+00, 1.3648700375E+00, 8.0745986302E-01],
	[1.9965000000E+04, 1.2728279665E+01, 5.3172141631E+00, 2.1475820457E+00, 1.3656098463E+00, 8.0755399817E-01],
	[1.9970000000E+04, 1.2733022152E+01, 5.3170897945E+00, 2.1492974953E+00, 1.3663496963E+00, 8.0764809169E-01],
	[1.9975000000E+04, 1.2737765217E+01, 5.3169654598E+00, 2.1510138834E+00, 1.3670895874E+00, 8.0774214359E-01],
	[1.9980000000E+04, 1.2742508862E+01, 5.3168411592E+00, 2.1527312101E+00, 1.3678295194E+00, 8.0783615388E-01],
	[1.9985000000E+04, 1.2747253085E+01, 5.3167168925E+00, 2.1544494758E+00, 1.3685694922E+00, 8.0793012256E-01],
	[1.9990000000E+04, 1.2751997888E+01, 5.3165926599E+00, 2.1561686807E+00, 1.3693095054E+00, 8.0802404965E-01],
	[1.9995000000E+04, 1.2756743269E+01, 5.3164684612E+00, 2.1578888252E+00, 1.3700495590E+00, 8.0811793516E-01],
	[2.0000000000E+04, 1.2761489229E+01, 5.3163442965E+00, 2.1596099095E+00, 1.3707896527E+00, 8.0821177909E-01],
	[2.0005000000E+04, 1.2766235767E+01, 5.3162201658E+00, 2.1613356347E+00, 1.3715312766E+00, 8.0830558145E-01],
	[2.0010000000E+04, 1.2770982884E+01, 5.3160960689E+00, 2.1630623054E+00, 1.3722729408E+00, 8.0839934226E-01],
	[2.0015000000E+04, 1.2775730580E+01, 5.3159720060E+00, 2.1647899220E+00, 1.3730146451E+00, 8.0849306152E-01],
	[2.0020000000E+04, 1.2780478854E+01, 5.3158479769E+00, 2.1665184846E+00, 1.3737563893E+00, 8.0858673924E-01],
	[2.0025000000E+04, 1.2785227707E+01, 5.3157239817E+00, 2.1682479935E+00, 1.3744981733E+00, 8.0868037543E-01],
	[2.0030000000E+04, 1.2789977137E+01, 5.3156000203E+00, 2.1699784491E+00, 1.3752399967E+00, 8.0877397011E-01],
	[2.0035000000E+04, 1.2794727146E+01, 5.3154760928E+00, 2.1717098516E+00, 1.3759818594E+00, 8.0886752327E-01],
	[2.0040000000E+04, 1.2799477734E+01, 5.3153521991E+00, 2.1734422013E+00, 1.3767237613E+00, 8.0896103493E-01],
	[2.0045000000E+04, 1.2804228899E+01, 5.3152283392E+00, 2.1751754985E+00, 1.3774657022E+00, 8.0905450509E-01],
	[2.0050000000E+04, 1.2808980642E+01, 5.3151045130E+00, 2.1769097434E+00, 1.3782076817E+00, 8.0914793378E-01],
	[2.0055000000E+04, 1.2813732963E+01, 5.3149807206E+00, 2.1786449364E+00, 1.3789496999E+00, 8.0924132099E-01],
	[2.0060000000E+04, 1.2818485862E+01, 5.3148569620E+00, 2.1803810777E+00, 1.3796917564E+00, 8.0933466673E-01],
	[2.0065000000E+04, 1.2823250857E+01, 5.3147355066E+00, 2.1821181675E+00, 1.3804341376E+00, 8.0942797102E-01],
	[2.0070000000E+04, 1.2828028504E+01, 5.3146164612E+00, 2.1838562063E+00, 1.3811768577E+00, 8.0952123386E-01],
	[2.0075000000E+04, 1.2832806739E+01, 5.3144974481E+00, 2.1855951942E+00, 1.3819196165E+00, 8.0961445527E-01],
	[2.0080000000E+04, 1.2837585564E+01, 5.3143784673E+00, 2.1873351316E+00, 1.3826624139E+00, 8.0970763525E-01],
	[2.0085000000E+04, 1.2842364978E+01, 5.3142595188E+00, 2.1890760186E+00, 1.3834052496E+00, 8.0980077382E-01],
	[2.0090000000E+04, 1.2847144981E+01, 5.3141406025E+00, 2.1908178557E+00, 1.3841481234E+00, 8.0989387097E-01],
	[2.0095000000E+04, 1.2851925574E+01, 5.3140217185E+00, 2.1925606430E+00, 1.3848910351E+00, 8.0998692673E-01],
	[2.0100000000E+04, 1.2856706755E+01, 5.3139028668E+00, 2.1943043809E+00, 1.3856339846E+00, 8.1007994110E-01],
	[2.0105000000E+04, 1.2861488524E+01, 5.3137840472E+00, 2.1960490697E+00, 1.3863769717E+00, 8.1017291409E-01],
	[2.0110000000E+04, 1.2866270883E+01, 5.3136652599E+00, 2.1977947095E+00, 1.3871199962E+00, 8.1026584570E-01],
	[2.0115000000E+04, 1.2871053830E+01, 5.3135465047E+00, 2.1995413008E+00, 1.3878630578E+00, 8.1035873596E-01],
	[2.0120000000E+04, 1.2875837366E+01, 5.3134277817E+00, 2.2012888437E+00, 1.3886061564E+00, 8.1045158487E-01],
	[2.0125000000E+04, 1.2880621491E+01, 5.3133090909E+00, 2.2030373386E+00, 1.3893492918E+00, 8.1054439244E-01],
	[2.0130000000E+04, 1.2885406204E+01, 5.3131904322E+00, 2.2047867858E+00, 1.3900924638E+00, 8.1063715867E-01],
	[2.0135000000E+04, 1.2890191505E+01, 5.3130718056E+00, 2.2065371854E+00, 1.3908356722E+00, 8.1072988359E-01],
	[2.0140000000E+04, 1.2894977394E+01, 5.3129532111E+00, 2.2082885379E+00, 1.3915789169E+00, 8.1082256719E-01],
	[2.0145000000E+04, 1.2899763872E+01, 5.3128346488E+00, 2.2100408434E+00, 1.3923221976E+00, 8.1091520949E-01],
	[2.0150000000E+04, 1.2904550938E+01, 5.3127161184E+00, 2.2117941024E+00, 1.3930655141E+00, 8.1100781049E-01],
	[2.0155000000E+04, 1.2909338592E+01, 5.3125976202E+00, 2.2135483149E+00, 1.3938088662E+00, 8.1110037022E-01],
	[2.0160000000E+04, 1.2914126835E+01, 5.3124791539E+00, 2.2153034814E+00, 1.3945522539E+00, 8.1119288867E-01],
	[2.0165000000E+04, 1.2918915665E+01, 5.3123607197E+00, 2.2170596021E+00, 1.3952956768E+00, 8.1128536585E-01],
	[2.0170000000E+04, 1.2923705083E+01, 5.3122423175E+00, 2.2188166772E+00, 1.3960391347E+00, 8.1137780179E-01],
	[2.0175000000E+04, 1.2928495088E+01, 5.3121239472E+00, 2.2205747072E+00, 1.3967826276E+00, 8.1147019648E-01],
	[2.0180000000E+04, 1.2933285682E+01, 5.3120056090E+00, 2.2223336921E+00, 1.3975261552E+00, 8.1156254993E-01],
	[2.0185000000E+04, 1.2938076863E+01, 5.3118873027E+00, 2.2240936324E+00, 1.3982697172E+00, 8.1165486216E-01],
	[2.0190000000E+04, 1.2942868632E+01, 5.3117690283E+00, 2.2258545283E+00, 1.3990133136E+00, 8.1174713318E-01],
	[2.0195000000E+04, 1.2947660988E+01, 5.3116507858E+00, 2.2276163801E+00, 1.3997569441E+00, 8.1183936299E-01],
	[2.0200000000E+04, 1.2952453932E+01, 5.3115325753E+00, 2.2293791881E+00, 1.4005006086E+00, 8.1193155161E-01],
	[2.0205000000E+04, 1.2957247463E+01, 5.3114143966E+00, 2.2311429525E+00, 1.4012443067E+00, 8.1202369905E-01],
	[2.0210000000E+04, 1.2962041581E+01, 5.3112962498E+00, 2.2329076737E+00, 1.4019880385E+00, 8.1211580531E-01],
	[2.0215000000E+04, 1.2966836287E+01, 5.3111781349E+00, 2.2346733518E+00, 1.4027318036E+00, 8.1220787040E-01],
	[2.0220000000E+04, 1.2971631579E+01, 5.3110600518E+00, 2.2364399872E+00, 1.4034756019E+00, 8.1229989434E-01],
	[2.0225000000E+04, 1.2976427459E+01, 5.3109420005E+00, 2.2382075803E+00, 1.4042194331E+00, 8.1239187714E-01],
	[2.0230000000E+04, 1.2981223926E+01, 5.3108239810E+00, 2.2399761311E+00, 1.4049632972E+00, 8.1248381880E-01],
	[2.0235000000E+04, 1.2986020979E+01, 5.3107059933E+00, 2.2417456401E+00, 1.4057071938E+00, 8.1257571934E-01],
	[2.0240000000E+04, 1.2990818620E+01, 5.3105880374E+00, 2.2435161075E+00, 1.4064511229E+00, 8.1266757876E-01],
	[2.0245000000E+04, 1.2995616847E+01, 5.3104701132E+00, 2.2452875336E+00, 1.4071950842E+00, 8.1275939708E-01],
	[2.0250000000E+04, 1.3000415661E+01, 5.3103522208E+00, 2.2470599187E+00, 1.4079390776E+00, 8.1285117430E-01],
	[2.0255000000E+04, 1.3005215062E+01, 5.3102343601E+00, 2.2488332630E+00, 1.4086831027E+00, 8.1294291044E-01],
	[2.0260000000E+04, 1.3010015049E+01, 5.3101165311E+00, 2.2506075669E+00, 1.4094271596E+00, 8.1303460551E-01],
	[2.0265000000E+04, 1.3014815622E+01, 5.3099987338E+00, 2.2523828306E+00, 1.4101712479E+00, 8.1312625951E-01],
	[2.0270000000E+04, 1.3019616782E+01, 5.3098809681E+00, 2.2541590543E+00, 1.4109153675E+00, 8.1321787246E-01],
	[2.0275000000E+04, 1.3024418529E+01, 5.3097632341E+00, 2.2559362385E+00, 1.4116595181E+00, 8.1330944436E-01],
	[2.0280000000E+04, 1.3029220861E+01, 5.3096455318E+00, 2.2577143833E+00, 1.4124036997E+00, 8.1340097523E-01],
	[2.0285000000E+04, 1.3034023780E+01, 5.3095278611E+00, 2.2594934891E+00, 1.4131479120E+00, 8.1349246508E-01],
	[2.0290000000E+04, 1.3038827285E+01, 5.3094102219E+00, 2.2612735561E+00, 1.4138921548E+00, 8.1358391392E-01],
	[2.0295000000E+04, 1.3043631376E+01, 5.3092926144E+00, 2.2630545845E+00, 1.4146364279E+00, 8.1367532175E-01],
	[2.0300000000E+04, 1.3048436053E+01, 5.3091750385E+00, 2.2648365748E+00, 1.4153807311E+00, 8.1376668859E-01],
	[2.0305000000E+04, 1.3053241316E+01, 5.3090574941E+00, 2.2666195271E+00, 1.4161250644E+00, 8.1385801445E-01],
	[2.0310000000E+04, 1.3058047165E+01, 5.3089399812E+00, 2.2684034418E+00, 1.4168694273E+00, 8.1394929934E-01],
	[2.0315000000E+04, 1.3062853599E+01, 5.3088224999E+00, 2.2701883191E+00, 1.4176138199E+00, 8.1404054327E-01],
	[2.0320000000E+04, 1.3067660619E+01, 5.3087050501E+00, 2.2719741593E+00, 1.4183582418E+00, 8.1413174625E-01],
	[2.0325000000E+04, 1.3072468225E+01, 5.3085876318E+00, 2.2737609626E+00, 1.4191026930E+00, 8.1422290828E-01],
	[2.0330000000E+04, 1.3077276416E+01, 5.3084702450E+00, 2.2755487295E+00, 1.4198471731E+00, 8.1431402939E-01],
	[2.0335000000E+04, 1.3082085193E+01, 5.3083528896E+00, 2.2773374601E+00, 1.4205916821E+00, 8.1440510958E-01],
	[2.0340000000E+04, 1.3086894555E+01, 5.3082355657E+00, 2.2791271547E+00, 1.4213362197E+00, 8.1449614885E-01],
	[2.0345000000E+04, 1.3091704502E+01, 5.3081182732E+00, 2.2809178136E+00, 1.4220807858E+00, 8.1458714723E-01],
	[2.0350000000E+04, 1.3096515035E+01, 5.3080010121E+00, 2.2827094372E+00, 1.4228253801E+00, 8.1467810472E-01],
	[2.0355000000E+04, 1.3101326153E+01, 5.3078837824E+00, 2.2845020256E+00, 1.4235700024E+00, 8.1476902134E-01],
	[2.0360000000E+04, 1.3106137856E+01, 5.3077665841E+00, 2.2862955791E+00, 1.4243146527E+00, 8.1485989708E-01],
	[2.0365000000E+04, 1.3110950144E+01, 5.3076494171E+00, 2.2880900981E+00, 1.4250593306E+00, 8.1495073197E-01],
	[2.0370000000E+04, 1.3115763017E+01, 5.3075322815E+00, 2.2898855828E+00, 1.4258040360E+00, 8.1504152602E-01],
	[2.0375000000E+04, 1.3120576474E+01, 5.3074151773E+00, 2.2916820335E+00, 1.4265487688E+00, 8.1513227922E-01],
	[2.0380000000E+04, 1.3125390517E+01, 5.3072981043E+00, 2.2934794504E+00, 1.4272935287E+00, 8.1522299161E-01],
	[2.0385000000E+04, 1.3130205144E+01, 5.3071810627E+00, 2.2952778340E+00, 1.4280383155E+00, 8.1531366318E-01],
	[2.0390000000E+04, 1.3135041506E+01, 5.3070681393E+00, 2.2970771843E+00, 1.4287836755E+00, 8.1540429394E-01],
	[2.0395000000E+04, 1.3139881013E+01, 5.3069557386E+00, 2.2988775018E+00, 1.4295291289E+00, 8.1549488391E-01],
	[2.0400000000E+04, 1.3144721117E+01, 5.3068433678E+00, 2.3006787867E+00, 1.4302746096E+00, 8.1558543310E-01],
	[2.0405000000E+04, 1.3149561816E+01, 5.3067310269E+00, 2.3024810393E+00, 1.4310201174E+00, 8.1567594152E-01],
	[2.0410000000E+04, 1.3154403111E+01, 5.3066187159E+00, 2.3042842598E+00, 1.4317656521E+00, 8.1576640918E-01],
	[2.0415000000E+04, 1.3159245002E+01, 5.3065064349E+00, 2.3060884486E+00, 1.4325112136E+00, 8.1585683609E-01],
	[2.0420000000E+04, 1.3164087489E+01, 5.3063941837E+00, 2.3078936059E+00, 1.4332568017E+00, 8.1594722225E-01],
	[2.0425000000E+04, 1.3168930572E+01, 5.3062819623E+00, 2.3096997320E+00, 1.4340024161E+00, 8.1603756769E-01],
	[2.0430000000E+04, 1.3173774250E+01, 5.3061697708E+00, 2.3115068272E+00, 1.4347480567E+00, 8.1612787241E-01],
	[2.0435000000E+04, 1.3178618524E+01, 5.3060576091E+00, 2.3133148917E+00, 1.4354937233E+00, 8.1621813642E-01],
	[2.0440000000E+04, 1.3183463393E+01, 5.3059454772E+00, 2.3151239259E+00, 1.4362394158E+00, 8.1630835974E-01],
	[2.0445000000E+04, 1.3188308858E+01, 5.3058333751E+00, 2.3169339301E+00, 1.4369851338E+00, 8.1639854237E-01],
	[2.0450000000E+04, 1.3193154919E+01, 5.3057213028E+00, 2.3187449044E+00, 1.4377308773E+00, 8.1648868433E-01],
	[2.0455000000E+04, 1.3198001575E+01, 5.3056092603E+00, 2.3205568493E+00, 1.4384766461E+00, 8.1657878562E-01],
	[2.0460000000E+04, 1.3202848825E+01, 5.3054972475E+00, 2.3223697649E+00, 1.4392224399E+00, 8.1666884626E-01],
	[2.0465000000E+04, 1.3207696672E+01, 5.3053852644E+00, 2.3241836516E+00, 1.4399682586E+00, 8.1675886625E-01],
	[2.0470000000E+04, 1.3212545113E+01, 5.3052733111E+00, 2.3259985096E+00, 1.4407141020E+00, 8.1684884562E-01],
	[2.0475000000E+04, 1.3217394149E+01, 5.3051613874E+00, 2.3278143392E+00, 1.4414599699E+00, 8.1693878436E-01],
	[2.0480000000E+04, 1.3222243780E+01, 5.3050494935E+00, 2.3296311408E+00, 1.4422058621E+00, 8.1702868250E-01],
	[2.0485000000E+04, 1.3227094007E+01, 5.3049376292E+00, 2.3314489145E+00, 1.4429517785E+00, 8.1711854003E-01],
	[2.0490000000E+04, 1.3231944828E+01, 5.3048257946E+00, 2.3332676606E+00, 1.4436977188E+00, 8.1720835698E-01],
	[2.0495000000E+04, 1.3236796243E+01, 5.3047139896E+00, 2.3350873795E+00, 1.4444436829E+00, 8.1729813336E-01],
	[2.0500000000E+04, 1.3241648254E+01, 5.3046022143E+00, 2.3369080715E+00, 1.4451896706E+00, 8.1738786916E-01],
	[2.0505000000E+04, 1.3246500859E+01, 5.3044904686E+00, 2.3387297367E+00, 1.4459356816E+00, 8.1747756441E-01],
	[2.0510000000E+04, 1.3251354058E+01, 5.3043787524E+00, 2.3405523756E+00, 1.4466817159E+00, 8.1756721912E-01],
	[2.0515000000E+04, 1.3256207852E+01, 5.3042670659E+00, 2.3423759883E+00, 1.4474277731E+00, 8.1765683330E-01],
	[2.0520000000E+04, 1.3261062241E+01, 5.3041554089E+00, 2.3442005751E+00, 1.4481738533E+00, 8.1774640695E-01],
	[2.0525000000E+04, 1.3265917223E+01, 5.3040437815E+00, 2.3460261364E+00, 1.4489199560E+00, 8.1783594010E-01],
	[2.0530000000E+04, 1.3270772800E+01, 5.3039321836E+00, 2.3478526724E+00, 1.4496660813E+00, 8.1792543274E-01],
	[2.0535000000E+04, 1.3275628971E+01, 5.3038206152E+00, 2.3496801834E+00, 1.4504122288E+00, 8.1801488490E-01],
	[2.0540000000E+04, 1.3280485737E+01, 5.3037090764E+00, 2.3515086696E+00, 1.4511583984E+00, 8.1810429658E-01],
	[2.0545000000E+04, 1.3285343096E+01, 5.3035975670E+00, 2.3533381314E+00, 1.4519045899E+00, 8.1819366779E-01],
	[2.0550000000E+04, 1.3290201049E+01, 5.3034860871E+00, 2.3551685691E+00, 1.4526508031E+00, 8.1828299855E-01],
	[2.0555000000E+04, 1.3295059596E+01, 5.3033746367E+00, 2.3569999829E+00, 1.4533970378E+00, 8.1837228886E-01],
	[2.0560000000E+04, 1.3299918737E+01, 5.3032632157E+00, 2.3588323731E+00, 1.4541432940E+00, 8.1846153875E-01],
	[2.0565000000E+04, 1.3304778472E+01, 5.3031518242E+00, 2.3606657399E+00, 1.4548895713E+00, 8.1855074821E-01],
	[2.0570000000E+04, 1.3309638800E+01, 5.3030404621E+00, 2.3625000837E+00, 1.4556358695E+00, 8.1863991726E-01],
	[2.0575000000E+04, 1.3314499722E+01, 5.3029291294E+00, 2.3643354048E+00, 1.4563821886E+00, 8.1872904591E-01],
	[2.0580000000E+04, 1.3319361237E+01, 5.3028178260E+00, 2.3661717034E+00, 1.4571285283E+00, 8.1881813418E-01],
	[2.0585000000E+04, 1.3324223346E+01, 5.3027065521E+00, 2.3680089798E+00, 1.4578748884E+00, 8.1890718207E-01],
	[2.0590000000E+04, 1.3329086049E+01, 5.3025953075E+00, 2.3698472343E+00, 1.4586212687E+00, 8.1899618960E-01],
	[2.0595000000E+04, 1.3333949344E+01, 5.3024840922E+00, 2.3716864671E+00, 1.4593676691E+00, 8.1908515677E-01],
	[2.0600000000E+04, 1.3338813233E+01, 5.3023729063E+00, 2.3735266787E+00, 1.4601140894E+00, 8.1917408357E-01],
	[2.0605000000E+04, 1.3343677715E+01, 5.3022617497E+00, 2.3753678691E+00, 1.4608605293E+00, 8.1926296990E-01],
	[2.0610000000E+04, 1.3348542790E+01, 5.3021506224E+00, 2.3772100388E+00, 1.4616069888E+00, 8.1935181574E-01],
	[2.0615000000E+04, 1.3353408458E+01, 5.3020395243E+00, 2.3790531879E+00, 1.4623534676E+00, 8.1944062112E-01],
	[2.0620000000E+04, 1.3358274719E+01, 5.3019284556E+00, 2.3808973169E+00, 1.4630999655E+00, 8.1952938606E-01],
	[2.0625000000E+04, 1.3363141573E+01, 5.3018174161E+00, 2.3827424259E+00, 1.4638464824E+00, 8.1961811055E-01],
	[2.0630000000E+04, 1.3368009020E+01, 5.3017064058E+00, 2.3845885152E+00, 1.4645930181E+00, 8.1970679463E-01],
	[2.0635000000E+04, 1.3372877059E+01, 5.3015954248E+00, 2.3864355852E+00, 1.4653395723E+00, 8.1979543829E-01],
	[2.0640000000E+04, 1.3377745691E+01, 5.3014844730E+00, 2.3882836360E+00, 1.4660861449E+00, 8.1988404156E-01],
	[2.0645000000E+04, 1.3382614916E+01, 5.3013735503E+00, 2.3901326681E+00, 1.4668327358E+00, 8.1997260446E-01],
	[2.0650000000E+04, 1.3387484733E+01, 5.3012626569E+00, 2.3919826816E+00, 1.4675793447E+00, 8.2006112698E-01],
	[2.0655000000E+04, 1.3392355143E+01, 5.3011517926E+00, 2.3938336769E+00, 1.4683259714E+00, 8.2014960916E-01],
	[2.0660000000E+04, 1.3397226145E+01, 5.3010409575E+00, 2.3956856542E+00, 1.4690726158E+00, 8.2023805100E-01],
	[2.0665000000E+04, 1.3402097739E+01, 5.3009301515E+00, 2.3975386138E+00, 1.4698192777E+00, 8.2032645251E-01],
	[2.0670000000E+04, 1.3406969926E+01, 5.3008193746E+00, 2.3993925560E+00, 1.4705659568E+00, 8.2041481372E-01],
	[2.0675000000E+04, 1.3411842705E+01, 5.3007086268E+00, 2.4012474811E+00, 1.4713126531E+00, 8.2050313463E-01],
	[2.0680000000E+04, 1.3416716076E+01, 5.3005979081E+00, 2.4031033894E+00, 1.4720593664E+00, 8.2059141526E-01],
	[2.0685000000E+04, 1.3421590039E+01, 5.3004872186E+00, 2.4049602811E+00, 1.4728060963E+00, 8.2067965563E-01],
	[2.0690000000E+04, 1.3426464594E+01, 5.3003765580E+00, 2.4068181565E+00, 1.4735528429E+00, 8.2076785574E-01],
	[2.0695000000E+04, 1.3431339740E+01, 5.3002659265E+00, 2.4086770159E+00, 1.4742996058E+00, 8.2085601561E-01],
	[2.0700000000E+04, 1.3436215479E+01, 5.3001553241E+00, 2.4105368596E+00, 1.4750463849E+00, 8.2094413527E-01],
	[2.0705000000E+04, 1.3441091809E+01, 5.3000447507E+00, 2.4123976879E+00, 1.4757931800E+00, 8.2103221471E-01],
	[2.0710000000E+04, 1.3445968731E+01, 5.2999342062E+00, 2.4142595010E+00, 1.4765399910E+00, 8.2112025396E-01],
	[2.0715000000E+04, 1.3450852347E+01, 5.2998248487E+00, 2.4161222993E+00, 1.4772869812E+00, 8.2120825302E-01],
	[2.0720000000E+04, 1.3455754247E+01, 5.2997188746E+00, 2.4179860829E+00, 1.4780344614E+00, 8.2129621192E-01],
	[2.0725000000E+04, 1.3460656749E+01, 5.2996129282E+00, 2.4198508523E+00, 1.4787819579E+00, 8.2138413067E-01],
	[2.0730000000E+04, 1.3465559854E+01, 5.2995070094E+00, 2.4217166076E+00, 1.4795294704E+00, 8.2147200928E-01],
	[2.0735000000E+04, 1.3470463563E+01, 5.2994011184E+00, 2.4235833492E+00, 1.4802769988E+00, 8.2155984777E-01],
	[2.0740000000E+04, 1.3475367874E+01, 5.2992952549E+00, 2.4254510774E+00, 1.4810245429E+00, 8.2164764614E-01],
	[2.0745000000E+04, 1.3480272788E+01, 5.2991894191E+00, 2.4273197923E+00, 1.4817721025E+00, 8.2173540443E-01],
	[2.0750000000E+04, 1.3485178304E+01, 5.2990836110E+00, 2.4291894944E+00, 1.4825196774E+00, 8.2182312263E-01],
	[2.0755000000E+04, 1.3490084423E+01, 5.2989778304E+00, 2.4310601838E+00, 1.4832672674E+00, 8.2191080076E-01],
	[2.0760000000E+04, 1.3494991144E+01, 5.2988720774E+00, 2.4329318609E+00, 1.4840148723E+00, 8.2199843885E-01],
	[2.0765000000E+04, 1.3499898468E+01, 5.2987663520E+00, 2.4348045260E+00, 1.4847624921E+00, 8.2208603689E-01],
	[2.0770000000E+04, 1.3504806395E+01, 5.2986606542E+00, 2.4366781793E+00, 1.4855101264E+00, 8.2217359491E-01],
	[2.0775000000E+04, 1.3509714923E+01, 5.2985549839E+00, 2.4385528211E+00, 1.4862577751E+00, 8.2226111293E-01],
	[2.0780000000E+04, 1.3514624054E+01, 5.2984493411E+00, 2.4404284517E+00, 1.4870054381E+00, 8.2234859095E-01],
	[2.0785000000E+04, 1.3519533787E+01, 5.2983437259E+00, 2.4423050714E+00, 1.4877531151E+00, 8.2243602898E-01],
	[2.0790000000E+04, 1.3524444122E+01, 5.2982381382E+00, 2.4441826804E+00, 1.4885008060E+00, 8.2252342706E-01],
	[2.0795000000E+04, 1.3529355059E+01, 5.2981325779E+00, 2.4460612791E+00, 1.4892485105E+00, 8.2261078518E-01],
	[2.0800000000E+04, 1.3534266598E+01, 5.2980270452E+00, 2.4479408677E+00, 1.4899962286E+00, 8.2269810336E-01],
	[2.0805000000E+04, 1.3539178739E+01, 5.2979215399E+00, 2.4498214465E+00, 1.4907439600E+00, 8.2278538162E-01],
	[2.0810000000E+04, 1.3544091482E+01, 5.2978160621E+00, 2.4517030158E+00, 1.4914917045E+00, 8.2287261998E-01],
	[2.0815000000E+04, 1.3549004826E+01, 5.2977106117E+00, 2.4535855759E+00, 1.4922394619E+00, 8.2295981844E-01],
	[2.0820000000E+04, 1.3553918772E+01, 5.2976051887E+00, 2.4554691270E+00, 1.4929872322E+00, 8.2304697702E-01],
	[2.0825000000E+04, 1.3558833320E+01, 5.2974997932E+00, 2.4573536695E+00, 1.4937350150E+00, 8.2313409573E-01],
	[2.0830000000E+04, 1.3563748469E+01, 5.2973944250E+00, 2.4592392035E+00, 1.4944828102E+00, 8.2322117459E-01],
	[2.0835000000E+04, 1.3568664219E+01, 5.2972890842E+00, 2.4611257295E+00, 1.4952306177E+00, 8.2330821362E-01],
	[2.0840000000E+04, 1.3573580571E+01, 5.2971837708E+00, 2.4630132476E+00, 1.4959784373E+00, 8.2339521283E-01],
	[2.0845000000E+04, 1.3578497525E+01, 5.2970784848E+00, 2.4649017582E+00, 1.4967262687E+00, 8.2348217223E-01],
	[2.0850000000E+04, 1.3583415079E+01, 5.2969732261E+00, 2.4667912616E+00, 1.4974741118E+00, 8.2356909184E-01],
	[2.0855000000E+04, 1.3588333235E+01, 5.2968679947E+00, 2.4686817580E+00, 1.4982219664E+00, 8.2365597166E-01],
	[2.0860000000E+04, 1.3593251991E+01, 5.2967627907E+00, 2.4705732477E+00, 1.4989698323E+00, 8.2374281173E-01],
	[2.0865000000E+04, 1.3598171349E+01, 5.2966576139E+00, 2.4724657309E+00, 1.4997177094E+00, 8.2382961204E-01],
	[2.0870000000E+04, 1.3603091308E+01, 5.2965524645E+00, 2.4743592081E+00, 1.5004655975E+00, 8.2391637262E-01],
	[2.0875000000E+04, 1.3608011867E+01, 5.2964473423E+00, 2.4762536794E+00, 1.5012134963E+00, 8.2400309348E-01],
	[2.0880000000E+04, 1.3612933028E+01, 5.2963422473E+00, 2.4781491451E+00, 1.5019614058E+00, 8.2408977464E-01],
	[2.0885000000E+04, 1.3617854789E+01, 5.2962371797E+00, 2.4800456056E+00, 1.5027093257E+00, 8.2417641610E-01],
	[2.0890000000E+04, 1.3622777151E+01, 5.2961321392E+00, 2.4819430610E+00, 1.5034572558E+00, 8.2426301789E-01],
	[2.0895000000E+04, 1.3627700113E+01, 5.2960271260E+00, 2.4838415118E+00, 1.5042051961E+00, 8.2434958001E-01],
	[2.0900000000E+04, 1.3632623676E+01, 5.2959221400E+00, 2.4857409581E+00, 1.5049531462E+00, 8.2443610249E-01],
	[2.0905000000E+04, 1.3637547839E+01, 5.2958171812E+00, 2.4876414002E+00, 1.5057011060E+00, 8.2452258533E-01],
	[2.0910000000E+04, 1.3642472603E+01, 5.2957122495E+00, 2.4895428385E+00, 1.5064490754E+00, 8.2460902856E-01],
	[2.0915000000E+04, 1.3647397967E+01, 5.2956073450E+00, 2.4914452732E+00, 1.5071970541E+00, 8.2469543218E-01],
	[2.0920000000E+04, 1.3652323932E+01, 5.2955024677E+00, 2.4933487046E+00, 1.5079450419E+00, 8.2478179621E-01],
	[2.0925000000E+04, 1.3657250496E+01, 5.2953976175E+00, 2.4952531330E+00, 1.5086930388E+00, 8.2486812067E-01],
	[2.0930000000E+04, 1.3662177661E+01, 5.2952927945E+00, 2.4971585586E+00, 1.5094410445E+00, 8.2495440556E-01],
	[2.0935000000E+04, 1.3667105425E+01, 5.2951879985E+00, 2.4990649818E+00, 1.5101890588E+00, 8.2504065091E-01],
	[2.0940000000E+04, 1.3672033790E+01, 5.2950832297E+00, 2.5009724028E+00, 1.5109370816E+00, 8.2512685673E-01],
	[2.0945000000E+04, 1.3676962754E+01, 5.2949784879E+00, 2.5028808219E+00, 1.5116851127E+00, 8.2521302303E-01],
	[2.0950000000E+04, 1.3681892319E+01, 5.2948737732E+00, 2.5047902394E+00, 1.5124331519E+00, 8.2529914983E-01],
	[2.0955000000E+04, 1.3686822483E+01, 5.2947690856E+00, 2.5067006556E+00, 1.5131811990E+00, 8.2538523715E-01],
	[2.0960000000E+04, 1.3691753246E+01, 5.2946644250E+00, 2.5086120707E+00, 1.5139292538E+00, 8.2547128499E-01],
	[2.0965000000E+04, 1.3696684610E+01, 5.2945597915E+00, 2.5105244850E+00, 1.5146773162E+00, 8.2555729337E-01],
	[2.0970000000E+04, 1.3701616573E+01, 5.2944551850E+00, 2.5124378989E+00, 1.5154253860E+00, 8.2564326231E-01],
	[2.0975000000E+04, 1.3706549135E+01, 5.2943506054E+00, 2.5143523126E+00, 1.5161734629E+00, 8.2572919182E-01],
	[2.0980000000E+04, 1.3711482297E+01, 5.2942460529E+00, 2.5162677263E+00, 1.5169215469E+00, 8.2581508191E-01],
	[2.0985000000E+04, 1.3716416058E+01, 5.2941415273E+00, 2.5181841404E+00, 1.5176696378E+00, 8.2590093261E-01],
	[2.0990000000E+04, 1.3721350418E+01, 5.2940370287E+00, 2.5201015552E+00, 1.5184177353E+00, 8.2598674392E-01],
	[2.0995000000E+04, 1.3726285378E+01, 5.2939325571E+00, 2.5220199709E+00, 1.5191658394E+00, 8.2607251586E-01],
	[2.1000000000E+04, 1.3731220936E+01, 5.2938281124E+00, 2.5239393878E+00, 1.5199139497E+00, 8.2615824845E-01],
	[2.1005000000E+04, 1.3736157094E+01, 5.2937236946E+00, 2.5258598062E+00, 1.5206620662E+00, 8.2624394169E-01],
	[2.1010000000E+04, 1.3741093851E+01, 5.2936193037E+00, 2.5277812264E+00, 1.5214101886E+00, 8.2632959561E-01],
	[2.1015000000E+04, 1.3746031206E+01, 5.2935149398E+00, 2.5297036486E+00, 1.5221583169E+00, 8.2641521021E-01],
	[2.1020000000E+04, 1.3750969161E+01, 5.2934106027E+00, 2.5316270732E+00, 1.5229064507E+00, 8.2650078552E-01],
	[2.1025000000E+04, 1.3755907714E+01, 5.2933062925E+00, 2.5335515004E+00, 1.5236545899E+00, 8.2658632155E-01],
	[2.1030000000E+04, 1.3760846866E+01, 5.2932020091E+00, 2.5354769306E+00, 1.5244027344E+00, 8.2667181831E-01],
	[2.1035000000E+04, 1.3765786616E+01, 5.2930977526E+00, 2.5374033639E+00, 1.5251508840E+00, 8.2675727582E-01],
	[2.1040000000E+04, 1.3770726966E+01, 5.2929935229E+00, 2.5393308007E+00, 1.5258990385E+00, 8.2684269409E-01],
	[2.1045000000E+04, 1.3775667913E+01, 5.2928893201E+00, 2.5412592412E+00, 1.5266471976E+00, 8.2692807313E-01],
	[2.1050000000E+04, 1.3780622930E+01, 5.2927876524E+00, 2.5431886858E+00, 1.5273957357E+00, 8.2701341297E-01],
	[2.1055000000E+04, 1.3785588966E+01, 5.2926879495E+00, 2.5451191347E+00, 1.5281445683E+00, 8.2709871361E-01],
	[2.1060000000E+04, 1.3790555612E+01, 5.2925882721E+00, 2.5470505882E+00, 1.5288934060E+00, 8.2718397508E-01],
	[2.1065000000E+04, 1.3795522868E+01, 5.2924886202E+00, 2.5489830465E+00, 1.5296422487E+00, 8.2726919737E-01],
	[2.1070000000E+04, 1.3800490733E+01, 5.2923889939E+00, 2.5509165101E+00, 1.5303910962E+00, 8.2735438052E-01],
	[2.1075000000E+04, 1.3805459208E+01, 5.2922893931E+00, 2.5528509791E+00, 1.5311399482E+00, 8.2743952454E-01],
	[2.1080000000E+04, 1.3810428293E+01, 5.2921898178E+00, 2.5547864538E+00, 1.5318888047E+00, 8.2752462943E-01],
	[2.1085000000E+04, 1.3815397987E+01, 5.2920902680E+00, 2.5567229346E+00, 1.5326376654E+00, 8.2760969522E-01],
	[2.1090000000E+04, 1.3820368290E+01, 5.2919907436E+00, 2.5586604217E+00, 1.5333865302E+00, 8.2769472192E-01],
	[2.1095000000E+04, 1.3825339203E+01, 5.2918912448E+00, 2.5605989153E+00, 1.5341353989E+00, 8.2777970954E-01],
	[2.1100000000E+04, 1.3830310724E+01, 5.2917917714E+00, 2.5625384158E+00, 1.5348842713E+00, 8.2786465810E-01],
	[2.1105000000E+04, 1.3835282855E+01, 5.2916923234E+00, 2.5644789234E+00, 1.5356331473E+00, 8.2794956762E-01],
	[2.1110000000E+04, 1.3840255595E+01, 5.2915929008E+00, 2.5664204385E+00, 1.5363820266E+00, 8.2803443810E-01],
	[2.1115000000E+04, 1.3845228944E+01, 5.2914935037E+00, 2.5683629613E+00, 1.5371309092E+00, 8.2811926957E-01],
	[2.1120000000E+04, 1.3850202902E+01, 5.2913941319E+00, 2.5703064921E+00, 1.5378797947E+00, 8.2820406203E-01],
	[2.1125000000E+04, 1.3855177469E+01, 5.2912947856E+00, 2.5722510312E+00, 1.5386286831E+00, 8.2828881551E-01],
	[2.1130000000E+04, 1.3860152645E+01, 5.2911954646E+00, 2.5741965788E+00, 1.5393775741E+00, 8.2837353002E-01],
	[2.1135000000E+04, 1.3865128429E+01, 5.2910961690E+00, 2.5761431352E+00, 1.5401264677E+00, 8.2845820557E-01],
	[2.1140000000E+04, 1.3870104823E+01, 5.2909968987E+00, 2.5780907008E+00, 1.5408753635E+00, 8.2854284217E-01],
	[2.1145000000E+04, 1.3875081824E+01, 5.2908976538E+00, 2.5800392758E+00, 1.5416242615E+00, 8.2862743985E-01],
	[2.1150000000E+04, 1.3880059434E+01, 5.2907984341E+00, 2.5819888605E+00, 1.5423731615E+00, 8.2871199861E-01],
	[2.1155000000E+04, 1.3885037653E+01, 5.2906992399E+00, 2.5839394552E+00, 1.5431220632E+00, 8.2879651848E-01],
	[2.1160000000E+04, 1.3890016480E+01, 5.2906000709E+00, 2.5858910601E+00, 1.5438709666E+00, 8.2888099946E-01],
	[2.1165000000E+04, 1.3894995915E+01, 5.2905009272E+00, 2.5878436756E+00, 1.5446198714E+00, 8.2896544158E-01],
	[2.1170000000E+04, 1.3899975959E+01, 5.2904018087E+00, 2.5897973019E+00, 1.5453687775E+00, 8.2904984484E-01],
	[2.1175000000E+04, 1.3904956611E+01, 5.2903027156E+00, 2.5917519393E+00, 1.5461176846E+00, 8.2913420926E-01],
	[2.1180000000E+04, 1.3909937871E+01, 5.2902036477E+00, 2.5937075881E+00, 1.5468665927E+00, 8.2921853486E-01],
	[2.1185000000E+04, 1.3914919739E+01, 5.2901046050E+00, 2.5956642485E+00, 1.5476155015E+00, 8.2930282165E-01],
	[2.1190000000E+04, 1.3919902215E+01, 5.2900055876E+00, 2.5976219210E+00, 1.5483644109E+00, 8.2938706964E-01],
	[2.1195000000E+04, 1.3924885298E+01, 5.2899065953E+00, 2.5995806056E+00, 1.5491133206E+00, 8.2947127886E-01],
	[2.1200000000E+04, 1.3929868990E+01, 5.2898076283E+00, 2.6015403028E+00, 1.5498622306E+00, 8.2955544931E-01],
	[2.1205000000E+04, 1.3934853289E+01, 5.2897086865E+00, 2.6035010128E+00, 1.5506111406E+00, 8.2963958102E-01],
	[2.1210000000E+04, 1.3939838197E+01, 5.2896097698E+00, 2.6054627358E+00, 1.5513600505E+00, 8.2972367398E-01],
	[2.1215000000E+04, 1.3944823711E+01, 5.2895108783E+00, 2.6074254723E+00, 1.5521089601E+00, 8.2980772823E-01],
	[2.1220000000E+04, 1.3949809834E+01, 5.2894120119E+00, 2.6093892223E+00, 1.5528578691E+00, 8.2989174378E-01],
	[2.1225000000E+04, 1.3954796563E+01, 5.2893131707E+00, 2.6113539864E+00, 1.5536067776E+00, 8.2997572063E-01],
	[2.1230000000E+04, 1.3959783900E+01, 5.2892143547E+00, 2.6133197646E+00, 1.5543556852E+00, 8.3005965881E-01],
	[2.1235000000E+04, 1.3964771845E+01, 5.2891155637E+00, 2.6152865573E+00, 1.5551045918E+00, 8.3014355831E-01],
	[2.1240000000E+04, 1.3969760397E+01, 5.2890167978E+00, 2.6172543649E+00, 1.5558534972E+00, 8.3022741912E-01],
	[2.1245000000E+04, 1.3974749556E+01, 5.2889180571E+00, 2.6192231875E+00, 1.5566024013E+00, 8.3031124125E-01],
	[2.1250000000E+04, 1.3979739322E+01, 5.2888193414E+00, 2.6211930254E+00, 1.5573513038E+00, 8.3039502470E-01],
	[2.1255000000E+04, 1.3984729695E+01, 5.2887206508E+00, 2.6231638790E+00, 1.5581002047E+00, 8.3047876949E-01],
	[2.1260000000E+04, 1.3989720675E+01, 5.2886219852E+00, 2.6251357485E+00, 1.5588491037E+00, 8.3056247562E-01],
	[2.1265000000E+04, 1.3994712263E+01, 5.2885233447E+00, 2.6271086342E+00, 1.5595980006E+00, 8.3064614311E-01],
	[2.1270000000E+04, 1.3999704457E+01, 5.2884247292E+00, 2.6290825363E+00, 1.5603468953E+00, 8.3072977197E-01],
	[2.1275000000E+04, 1.4004697257E+01, 5.2883261387E+00, 2.6310574553E+00, 1.5610957877E+00, 8.3081336220E-01],
	[2.1280000000E+04, 1.4009690665E+01, 5.2882275732E+00, 2.6330333913E+00, 1.5618446774E+00, 8.3089691382E-01],
	[2.1285000000E+04, 1.4014684679E+01, 5.2881290327E+00, 2.6350103446E+00, 1.5625935645E+00, 8.3098042684E-01],
	[2.1290000000E+04, 1.4019679300E+01, 5.2880305172E+00, 2.6369883155E+00, 1.5633424486E+00, 8.3106390127E-01],
	[2.1295000000E+04, 1.4024674527E+01, 5.2879320267E+00, 2.6389673044E+00, 1.5640913296E+00, 8.3114733711E-01],
	[2.1300000000E+04, 1.4029670361E+01, 5.2878335611E+00, 2.6409473114E+00, 1.5648402074E+00, 8.3123073439E-01],
	[2.1305000000E+04, 1.4034666801E+01, 5.2877351205E+00, 2.6429283369E+00, 1.5655890817E+00, 8.3131409310E-01],
	[2.1310000000E+04, 1.4039663848E+01, 5.2876367048E+00, 2.6449103811E+00, 1.5663379525E+00, 8.3139741327E-01],
	[2.1315000000E+04, 1.4044661501E+01, 5.2875383140E+00, 2.6468934444E+00, 1.5670868195E+00, 8.3148069489E-01],
	[2.1320000000E+04, 1.4049659759E+01, 5.2874399481E+00, 2.6488775269E+00, 1.5678356825E+00, 8.3156393798E-01],
	[2.1325000000E+04, 1.4054658624E+01, 5.2873416072E+00, 2.6508626291E+00, 1.5685845414E+00, 8.3164714256E-01],
	[2.1330000000E+04, 1.4059658095E+01, 5.2872432911E+00, 2.6528487512E+00, 1.5693333960E+00, 8.3173030863E-01],
	[2.1335000000E+04, 1.4064658172E+01, 5.2871449998E+00, 2.6548358934E+00, 1.5700822462E+00, 8.3181343620E-01],
	[2.1340000000E+04, 1.4069658855E+01, 5.2870467335E+00, 2.6568240561E+00, 1.5708310917E+00, 8.3189652528E-01],
	[2.1345000000E+04, 1.4074660144E+01, 5.2869484920E+00, 2.6588132395E+00, 1.5715799324E+00, 8.3197957589E-01],
	[2.1350000000E+04, 1.4079662039E+01, 5.2868502753E+00, 2.6608034439E+00, 1.5723287681E+00, 8.3206258803E-01],
	[2.1355000000E+04, 1.4084664539E+01, 5.2867520834E+00, 2.6627946696E+00, 1.5730775987E+00, 8.3214556172E-01],
	[2.1360000000E+04, 1.4089667645E+01, 5.2866539164E+00, 2.6647869169E+00, 1.5738264240E+00, 8.3222849696E-01],
	[2.1365000000E+04, 1.4094671356E+01, 5.2865557741E+00, 2.6667801860E+00, 1.5745752438E+00, 8.3231139377E-01],
	[2.1370000000E+04, 1.4099675673E+01, 5.2864576567E+00, 2.6687744773E+00, 1.5753240579E+00, 8.3239425215E-01],
	[2.1375000000E+04, 1.4104680595E+01, 5.2863595640E+00, 2.6707697910E+00, 1.5760728661E+00, 8.3247707212E-01],
	[2.1380000000E+04, 1.4109686123E+01, 5.2862614960E+00, 2.6727661275E+00, 1.5768216684E+00, 8.3255985369E-01],
	[2.1385000000E+04, 1.4114692256E+01, 5.2861634529E+00, 2.6747634869E+00, 1.5775704645E+00, 8.3264259687E-01],
	[2.1390000000E+04, 1.4119718127E+01, 5.2860689311E+00, 2.6767618696E+00, 1.5783198050E+00, 8.3272530167E-01],
	[2.1395000000E+04, 1.4124749462E+01, 5.2859753189E+00, 2.6787612759E+00, 1.5790692794E+00, 8.3280796809E-01],
	[2.1400000000E+04, 1.4129781413E+01, 5.2858817303E+00, 2.6807617060E+00, 1.5798187481E+00, 8.3289059616E-01],
	[2.1405000000E+04, 1.4134813981E+01, 5.2857881653E+00, 2.6827631603E+00, 1.5805682109E+00, 8.3297318588E-01],
	[2.1410000000E+04, 1.4139847165E+01, 5.2856946237E+00, 2.6847656390E+00, 1.5813176676E+00, 8.3305573726E-01],
	[2.1415000000E+04, 1.4144880965E+01, 5.2856011056E+00, 2.6867691424E+00, 1.5820671180E+00, 8.3313825032E-01],
	[2.1420000000E+04, 1.4149915382E+01, 5.2855076110E+00, 2.6887736707E+00, 1.5828165620E+00, 8.3322072506E-01],
	[2.1425000000E+04, 1.4154950414E+01, 5.2854141399E+00, 2.6907792243E+00, 1.5835659995E+00, 8.3330316150E-01],
	[2.1430000000E+04, 1.4159986063E+01, 5.2853206923E+00, 2.6927858035E+00, 1.5843154301E+00, 8.3338555964E-01],
	[2.1435000000E+04, 1.4165022328E+01, 5.2852272681E+00, 2.6947934085E+00, 1.5850648538E+00, 8.3346791949E-01],
	[2.1440000000E+04, 1.4170059209E+01, 5.2851338673E+00, 2.6968020396E+00, 1.5858142704E+00, 8.3355024108E-01],
	[2.1445000000E+04, 1.4175096706E+01, 5.2850404900E+00, 2.6988116971E+00, 1.5865636798E+00, 8.3363252440E-01],
	[2.1450000000E+04, 1.4180134819E+01, 5.2849471361E+00, 2.7008223813E+00, 1.5873130817E+00, 8.3371476947E-01],
	[2.1455000000E+04, 1.4185173547E+01, 5.2848538056E+00, 2.7028340924E+00, 1.5880624760E+00, 8.3379697631E-01],
	[2.1460000000E+04, 1.4190212891E+01, 5.2847604985E+00, 2.7048468308E+00, 1.5888118625E+00, 8.3387914491E-01],
	[2.1465000000E+04, 1.4195252851E+01, 5.2846672148E+00, 2.7068605968E+00, 1.5895612410E+00, 8.3396127530E-01],
	[2.1470000000E+04, 1.4200293426E+01, 5.2845739545E+00, 2.7088753905E+00, 1.5903106114E+00, 8.3404336748E-01],
	[2.1475000000E+04, 1.4205334617E+01, 5.2844807175E+00, 2.7108912124E+00, 1.5910599736E+00, 8.3412542146E-01],
	[2.1480000000E+04, 1.4210376423E+01, 5.2843875038E+00, 2.7129080626E+00, 1.5918093272E+00, 8.3420743726E-01],
	[2.1485000000E+04, 1.4215418845E+01, 5.2842943135E+00, 2.7149259415E+00, 1.5925586723E+00, 8.3428941489E-01],
	[2.1490000000E+04, 1.4220461882E+01, 5.2842011466E+00, 2.7169448494E+00, 1.5933080085E+00, 8.3437135435E-01],
	[2.1495000000E+04, 1.4225505534E+01, 5.2841080029E+00, 2.7189647864E+00, 1.5940573358E+00, 8.3445325566E-01],
	[2.1500000000E+04, 1.4230549801E+01, 5.2840148826E+00, 2.7209857530E+00, 1.5948066539E+00, 8.3453511883E-01],
	[2.1505000000E+04, 1.4235594684E+01, 5.2839217855E+00, 2.7230077494E+00, 1.5955559627E+00, 8.3461694388E-01],
	[2.1510000000E+04, 1.4240640181E+01, 5.2838287118E+00, 2.7250307759E+00, 1.5963052621E+00, 8.3469873080E-01],
	[2.1515000000E+04, 1.4245686294E+01, 5.2837356613E+00, 2.7270548328E+00, 1.5970545518E+00, 8.3478047962E-01],
	[2.1520000000E+04, 1.4250733021E+01, 5.2836426340E+00, 2.7290799203E+00, 1.5978038316E+00, 8.3486219034E-01],
	[2.1525000000E+04, 1.4255780363E+01, 5.2835496300E+00, 2.7311060387E+00, 1.5985531015E+00, 8.3494386297E-01],
	[2.1530000000E+04, 1.4260828320E+01, 5.2834566493E+00, 2.7331331884E+00, 1.5993023613E+00, 8.3502549753E-01],
	[2.1535000000E+04, 1.4265876891E+01, 5.2833636918E+00, 2.7351613695E+00, 1.6000516107E+00, 8.3510709403E-01],
	[2.1540000000E+04, 1.4270926077E+01, 5.2832707575E+00, 2.7371905825E+00, 1.6008008497E+00, 8.3518865248E-01],
	[2.1545000000E+04, 1.4275975878E+01, 5.2831778464E+00, 2.7392208275E+00, 1.6015500780E+00, 8.3527017289E-01],
	[2.1550000000E+04, 1.4281026293E+01, 5.2830849584E+00, 2.7412521049E+00, 1.6022992955E+00, 8.3535165526E-01],
	[2.1555000000E+04, 1.4286077323E+01, 5.2829920937E+00, 2.7432844149E+00, 1.6030485019E+00, 8.3543309962E-01],
	[2.1560000000E+04, 1.4291128967E+01, 5.2828992522E+00, 2.7453177578E+00, 1.6037976973E+00, 8.3551450598E-01],
	[2.1565000000E+04, 1.4296181225E+01, 5.2828064338E+00, 2.7473521339E+00, 1.6045468813E+00, 8.3559587434E-01],
	[2.1570000000E+04, 1.4301234097E+01, 5.2827136385E+00, 2.7493875435E+00, 1.6052960538E+00, 8.3567720471E-01],
	[2.1575000000E+04, 1.4306287584E+01, 5.2826208664E+00, 2.7514239869E+00, 1.6060452146E+00, 8.3575849712E-01],
	[2.1580000000E+04, 1.4311341684E+01, 5.2825281174E+00, 2.7534614644E+00, 1.6067943636E+00, 8.3583975156E-01],
	[2.1585000000E+04, 1.4316396399E+01, 5.2824353915E+00, 2.7554999762E+00, 1.6075435006E+00, 8.3592096805E-01],
	[2.1590000000E+04, 1.4321451727E+01, 5.2823426888E+00, 2.7575395226E+00, 1.6082926255E+00, 8.3600214660E-01],
	[2.1595000000E+04, 1.4326507670E+01, 5.2822500091E+00, 2.7595801039E+00, 1.6090417380E+00, 8.3608328723E-01],
	[2.1600000000E+04, 1.4331564226E+01, 5.2821573525E+00, 2.7616217204E+00, 1.6097908380E+00, 8.3616438994E-01],
	[2.1605000000E+04, 1.4336621396E+01, 5.2820647190E+00, 2.7636643724E+00, 1.6105399253E+00, 8.3624545475E-01],
	[2.1610000000E+04, 1.4341679180E+01, 5.2819721085E+00, 2.7657080602E+00, 1.6112889999E+00, 8.3632648166E-01],
	[2.1615000000E+04, 1.4346737577E+01, 5.2818795211E+00, 2.7677527840E+00, 1.6120380614E+00, 8.3640747069E-01],
	[2.1620000000E+04, 1.4351796588E+01, 5.2817869567E+00, 2.7697985441E+00, 1.6127871097E+00, 8.3648842185E-01],
	[2.1625000000E+04, 1.4356856212E+01, 5.2816944153E+00, 2.7718453408E+00, 1.6135361447E+00, 8.3656933516E-01],
	[2.1630000000E+04, 1.4361916449E+01, 5.2816018970E+00, 2.7738931744E+00, 1.6142851663E+00, 8.3665021061E-01],
	[2.1635000000E+04, 1.4366977300E+01, 5.2815094017E+00, 2.7759420452E+00, 1.6150341741E+00, 8.3673104823E-01],
	[2.1640000000E+04, 1.4372038764E+01, 5.2814169293E+00, 2.7779919535E+00, 1.6157831681E+00, 8.3681184803E-01],
	[2.1645000000E+04, 1.4377100842E+01, 5.2813244800E+00, 2.7800428995E+00, 1.6165321481E+00, 8.3689261001E-01],
	[2.1650000000E+04, 1.4382163532E+01, 5.2812320536E+00, 2.7820948835E+00, 1.6172811140E+00, 8.3697333420E-01],
	[2.1655000000E+04, 1.4387226836E+01, 5.2811396502E+00, 2.7841479059E+00, 1.6180300655E+00, 8.3705402059E-01],
	[2.1660000000E+04, 1.4392290752E+01, 5.2810472697E+00, 2.7862019669E+00, 1.6187790025E+00, 8.3713466920E-01],
	[2.1665000000E+04, 1.4397355282E+01, 5.2809549121E+00, 2.7882570667E+00, 1.6195279249E+00, 8.3721528005E-01],
	[2.1670000000E+04, 1.4402420424E+01, 5.2808625775E+00, 2.7903132057E+00, 1.6202768324E+00, 8.3729585315E-01],
	[2.1675000000E+04, 1.4407486179E+01, 5.2807702658E+00, 2.7923703842E+00, 1.6210257250E+00, 8.3737638850E-01],
	[2.1680000000E+04, 1.4412552547E+01, 5.2806779770E+00, 2.7944286023E+00, 1.6217746023E+00, 8.3745688612E-01],
	[2.1685000000E+04, 1.4417619528E+01, 5.2805857111E+00, 2.7964878605E+00, 1.6225234644E+00, 8.3753734601E-01],
	[2.1690000000E+04, 1.4422687121E+01, 5.2804934681E+00, 2.7985481591E+00, 1.6232723109E+00, 8.3761776820E-01],
	[2.1695000000E+04, 1.4427755326E+01, 5.2804012480E+00, 2.8006094982E+00, 1.6240211418E+00, 8.3769815270E-01],
	[2.1700000000E+04, 1.4432824144E+01, 5.2803090507E+00, 2.8026718781E+00, 1.6247699569E+00, 8.3777849951E-01],
	[2.1705000000E+04, 1.4437893575E+01, 5.2802168763E+00, 2.8047352992E+00, 1.6255187560E+00, 8.3785880864E-01],
	[2.1710000000E+04, 1.4442963618E+01, 5.2801247247E+00, 2.8067997618E+00, 1.6262675389E+00, 8.3793908012E-01],
	[2.1715000000E+04, 1.4448034273E+01, 5.2800325959E+00, 2.8088652661E+00, 1.6270163055E+00, 8.3801931394E-01],
	[2.1720000000E+04, 1.4453105540E+01, 5.2799404900E+00, 2.8109318124E+00, 1.6277650557E+00, 8.3809951012E-01],
	[2.1725000000E+04, 1.4458177419E+01, 5.2798484068E+00, 2.8129994010E+00, 1.6285137891E+00, 8.3817966868E-01],
	[2.1730000000E+04, 1.4463249911E+01, 5.2797563465E+00, 2.8150680321E+00, 1.6292625058E+00, 8.3825978963E-01],
	[2.1735000000E+04, 1.4468345667E+01, 5.2796683720E+00, 2.8171377061E+00, 1.6300118803E+00, 8.3833987297E-01],
	[2.1740000000E+04, 1.4473443475E+01, 5.2795806754E+00, 2.8192084233E+00, 1.6307612811E+00, 8.3841991872E-01],
	[2.1745000000E+04, 1.4478541906E+01, 5.2794930003E+00, 2.8212801839E+00, 1.6315106656E+00, 8.3849992689E-01],
	[2.1750000000E+04, 1.4483640960E+01, 5.2794053469E+00, 2.8233529882E+00, 1.6322600335E+00, 8.3857989749E-01],
	[2.1755000000E+04, 1.4488740637E+01, 5.2793177150E+00, 2.8254268365E+00, 1.6330093848E+00, 8.3865983054E-01],
	[2.1760000000E+04, 1.4493840938E+01, 5.2792301048E+00, 2.8275017290E+00, 1.6337587192E+00, 8.3873972604E-01],
	[2.1765000000E+04, 1.4498941861E+01, 5.2791425161E+00, 2.8295776662E+00, 1.6345080366E+00, 8.3881958401E-01],
	[2.1770000000E+04, 1.4504043407E+01, 5.2790549491E+00, 2.8316546482E+00, 1.6352573369E+00, 8.3889940446E-01],
	[2.1775000000E+04, 1.4509145576E+01, 5.2789674035E+00, 2.8337326753E+00, 1.6360066197E+00, 8.3897918740E-01],
	[2.1780000000E+04, 1.4514248368E+01, 5.2788798796E+00, 2.8358117478E+00, 1.6367558851E+00, 8.3905893285E-01],
	[2.1785000000E+04, 1.4519351782E+01, 5.2787923771E+00, 2.8378918661E+00, 1.6375051329E+00, 8.3913864081E-01],
	[2.1790000000E+04, 1.4524455819E+01, 5.2787048962E+00, 2.8399730303E+00, 1.6382543628E+00, 8.3921831130E-01],
	[2.1795000000E+04, 1.4529560479E+01, 5.2786174368E+00, 2.8420552408E+00, 1.6390035747E+00, 8.3929794433E-01],
	[2.1800000000E+04, 1.4534665761E+01, 5.2785299990E+00, 2.8441384978E+00, 1.6397527684E+00, 8.3937753990E-01],
	[2.1805000000E+04, 1.4539771666E+01, 5.2784425826E+00, 2.8462228017E+00, 1.6405019439E+00, 8.3945709805E-01],
	[2.1810000000E+04, 1.4544878193E+01, 5.2783551877E+00, 2.8483081527E+00, 1.6412511008E+00, 8.3953661876E-01],
	[2.1815000000E+04, 1.4549985342E+01, 5.2782678143E+00, 2.8503945511E+00, 1.6420002392E+00, 8.3961610207E-01],
	[2.1820000000E+04, 1.4555093114E+01, 5.2781804624E+00, 2.8524819972E+00, 1.6427493587E+00, 8.3969554797E-01],
	[2.1825000000E+04, 1.4560201507E+01, 5.2780931319E+00, 2.8545704913E+00, 1.6434984592E+00, 8.3977495648E-01],
	[2.1830000000E+04, 1.4565310523E+01, 5.2780058229E+00, 2.8566600337E+00, 1.6442475406E+00, 8.3985432762E-01],
	[2.1835000000E+04, 1.4570420161E+01, 5.2779185353E+00, 2.8587506245E+00, 1.6449966027E+00, 8.3993366139E-01],
	[2.1840000000E+04, 1.4575530421E+01, 5.2778312691E+00, 2.8608422643E+00, 1.6457456454E+00, 8.4001295781E-01],
	[2.1845000000E+04, 1.4580641302E+01, 5.2777440244E+00, 2.8629349531E+00, 1.6464946684E+00, 8.4009221689E-01],
	[2.1850000000E+04, 1.4585752806E+01, 5.2776568011E+00, 2.8650286913E+00, 1.6472436716E+00, 8.4017143865E-01],
	[2.1855000000E+04, 1.4590864931E+01, 5.2775695991E+00, 2.8671234792E+00, 1.6479926550E+00, 8.4025062312E-01],
	[2.1860000000E+04, 1.4595977678E+01, 5.2774824186E+00, 2.8692193171E+00, 1.6487416182E+00, 8.4032977031E-01],
	[2.1865000000E+04, 1.4601091047E+01, 5.2773952594E+00, 2.8713162052E+00, 1.6494905611E+00, 8.4040888024E-01],
	[2.1870000000E+04, 1.4606205037E+01, 5.2773081216E+00, 2.8734141439E+00, 1.6502394836E+00, 8.4048795292E-01],
	[2.1875000000E+04, 1.4611319649E+01, 5.2772210052E+00, 2.8755131334E+00, 1.6509883855E+00, 8.4056698835E-01],
	[2.1880000000E+04, 1.4616434882E+01, 5.2771339101E+00, 2.8776131739E+00, 1.6517372666E+00, 8.4064598655E-01],
	[2.1885000000E+04, 1.4621550736E+01, 5.2770468364E+00, 2.8797142659E+00, 1.6524861269E+00, 8.4072494752E-01],
	[2.1890000000E+04, 1.4626667212E+01, 5.2769597839E+00, 2.8818164096E+00, 1.6532349660E+00, 8.4080387129E-01],
	[2.1895000000E+04, 1.4631784309E+01, 5.2768727528E+00, 2.8839196052E+00, 1.6539837840E+00, 8.4088275785E-01],
	[2.1900000000E+04, 1.4636902027E+01, 5.2767857430E+00, 2.8860238530E+00, 1.6547325805E+00, 8.4096160721E-01],
	[2.1905000000E+04, 1.4642020366E+01, 5.2766987545E+00, 2.8881291534E+00, 1.6554813554E+00, 8.4104041940E-01],
	[2.1910000000E+04, 1.4647139327E+01, 5.2766117873E+00, 2.8902355066E+00, 1.6562301087E+00, 8.4111919442E-01],
	[2.1915000000E+04, 1.4652258908E+01, 5.2765248414E+00, 2.8923429128E+00, 1.6569788400E+00, 8.4119793228E-01],
	[2.1920000000E+04, 1.4657379110E+01, 5.2764379167E+00, 2.8944513725E+00, 1.6577275493E+00, 8.4127663299E-01],
	[2.1925000000E+04, 1.4662499933E+01, 5.2763510133E+00, 2.8965608858E+00, 1.6584762364E+00, 8.4135529656E-01],
	[2.1930000000E+04, 1.4667621377E+01, 5.2762641311E+00, 2.8986714531E+00, 1.6592249012E+00, 8.4143392300E-01],
	[2.1935000000E+04, 1.4672743442E+01, 5.2761772702E+00, 2.9007830746E+00, 1.6599735434E+00, 8.4151251232E-01],
	[2.1940000000E+04, 1.4677866127E+01, 5.2760904305E+00, 2.9028957506E+00, 1.6607221629E+00, 8.4159106454E-01],
	[2.1945000000E+04, 1.4682989432E+01, 5.2760036120E+00, 2.9050094815E+00, 1.6614707596E+00, 8.4166957966E-01],
	[2.1950000000E+04, 1.4688113359E+01, 5.2759168147E+00, 2.9071242674E+00, 1.6622193332E+00, 8.4174805770E-01],
	[2.1955000000E+04, 1.4693237905E+01, 5.2758300386E+00, 2.9092401087E+00, 1.6629678837E+00, 8.4182649866E-01],
	[2.1960000000E+04, 1.4698363072E+01, 5.2757432837E+00, 2.9113570056E+00, 1.6637164109E+00, 8.4190490255E-01],
	[2.1965000000E+04, 1.4703488860E+01, 5.2756565500E+00, 2.9134749585E+00, 1.6644649146E+00, 8.4198326940E-01],
	[2.1970000000E+04, 1.4708615267E+01, 5.2755698374E+00, 2.9155939676E+00, 1.6652133946E+00, 8.4206159920E-01],
	[2.1975000000E+04, 1.4713742295E+01, 5.2754831460E+00, 2.9177140332E+00, 1.6659618508E+00, 8.4213989197E-01],
	[2.1980000000E+04, 1.4718869943E+01, 5.2753964758E+00, 2.9198351557E+00, 1.6667102831E+00, 8.4221814772E-01],
	[2.1985000000E+04, 1.4723998211E+01, 5.2753098267E+00, 2.9219573352E+00, 1.6674586912E+00, 8.4229636646E-01],
	[2.1990000000E+04, 1.4729127098E+01, 5.2752231987E+00, 2.9240805720E+00, 1.6682070750E+00, 8.4237454820E-01],
	[2.1995000000E+04, 1.4734256606E+01, 5.2751365918E+00, 2.9262048665E+00, 1.6689554344E+00, 8.4245269295E-01],
	[2.2000000000E+04, 1.4739386734E+01, 5.2750500061E+00, 2.9283302190E+00, 1.6697037692E+00, 8.4253080072E-01],
	[2.2005000000E+04, 1.4744517481E+01, 5.2749634414E+00, 2.9304566297E+00, 1.6704520792E+00, 8.4260887153E-01],
	[2.2010000000E+04, 1.4749648848E+01, 5.2748768978E+00, 2.9325840988E+00, 1.6712003643E+00, 8.4268690538E-01],
	[2.2015000000E+04, 1.4754780835E+01, 5.2747903753E+00, 2.9347126268E+00, 1.6719486243E+00, 8.4276490228E-01],
	[2.2020000000E+04, 1.4759913441E+01, 5.2747038739E+00, 2.9368422138E+00, 1.6726968591E+00, 8.4284286226E-01],
	[2.2025000000E+04, 1.4765046667E+01, 5.2746173935E+00, 2.9389728602E+00, 1.6734450684E+00, 8.4292078530E-01],
	[2.2030000000E+04, 1.4770180513E+01, 5.2745309342E+00, 2.9411045663E+00, 1.6741932522E+00, 8.4299867144E-01],
	[2.2035000000E+04, 1.4775314977E+01, 5.2744444959E+00, 2.9432373322E+00, 1.6749414103E+00, 8.4307652067E-01],
	[2.2040000000E+04, 1.4780450061E+01, 5.2743580786E+00, 2.9453711584E+00, 1.6756895425E+00, 8.4315433302E-01],
	[2.2045000000E+04, 1.4785585765E+01, 5.2742716824E+00, 2.9475060451E+00, 1.6764376486E+00, 8.4323210848E-01],
	[2.2050000000E+04, 1.4790722087E+01, 5.2741853071E+00, 2.9496419925E+00, 1.6771857286E+00, 8.4330984708E-01],
	[2.2055000000E+04, 1.4795859028E+01, 5.2740989529E+00, 2.9517790010E+00, 1.6779337822E+00, 8.4338754882E-01],
	[2.2060000000E+04, 1.4800996589E+01, 5.2740126196E+00, 2.9539170709E+00, 1.6786818093E+00, 8.4346521371E-01],
	[2.2065000000E+04, 1.4806134769E+01, 5.2739263074E+00, 2.9560562024E+00, 1.6794298097E+00, 8.4354284177E-01],
	[2.2070000000E+04, 1.4811273567E+01, 5.2738400160E+00, 2.9581963959E+00, 1.6801777833E+00, 8.4362043301E-01],
	[2.2075000000E+04, 1.4816412985E+01, 5.2737537457E+00, 2.9603376515E+00, 1.6809257299E+00, 8.4369798743E-01],
	[2.2080000000E+04, 1.4821553021E+01, 5.2736674963E+00, 2.9624799697E+00, 1.6816736493E+00, 8.4377550505E-01],
	[2.2085000000E+04, 1.4826717256E+01, 5.2735854187E+00, 2.9646233506E+00, 1.6824222676E+00, 8.4385298588E-01],
	[2.2090000000E+04, 1.4831882725E+01, 5.2735034670E+00, 2.9667677945E+00, 1.6831708779E+00, 8.4393042992E-01],
	[2.2095000000E+04, 1.4837048824E+01, 5.2734215352E+00, 2.9689133019E+00, 1.6839194615E+00, 8.4400783721E-01],
	[2.2100000000E+04, 1.4842215552E+01, 5.2733396232E+00, 2.9710598728E+00, 1.6846680183E+00, 8.4408520773E-01],
	[2.2105000000E+04, 1.4847382910E+01, 5.2732577310E+00, 2.9732075077E+00, 1.6854165482E+00, 8.4416254150E-01],
	[2.2110000000E+04, 1.4852550898E+01, 5.2731758586E+00, 2.9753562067E+00, 1.6861650508E+00, 8.4423983855E-01],
	[2.2115000000E+04, 1.4857719516E+01, 5.2730940060E+00, 2.9775059703E+00, 1.6869135263E+00, 8.4431709886E-01],
	[2.2120000000E+04, 1.4862888763E+01, 5.2730121731E+00, 2.9796567986E+00, 1.6876619742E+00, 8.4439432247E-01],
	[2.2125000000E+04, 1.4868058640E+01, 5.2729303601E+00, 2.9818086920E+00, 1.6884103945E+00, 8.4447150937E-01],
	[2.2130000000E+04, 1.4873229146E+01, 5.2728485667E+00, 2.9839616507E+00, 1.6891587871E+00, 8.4454865959E-01],
	[2.2135000000E+04, 1.4878400282E+01, 5.2727667931E+00, 2.9861156751E+00, 1.6899071518E+00, 8.4462577312E-01],
	[2.2140000000E+04, 1.4883572047E+01, 5.2726850393E+00, 2.9882707653E+00, 1.6906554884E+00, 8.4470284999E-01],
	[2.2145000000E+04, 1.4888744441E+01, 5.2726033052E+00, 2.9904269218E+00, 1.6914037967E+00, 8.4477989020E-01],
	[2.2150000000E+04, 1.4893917464E+01, 5.2725215908E+00, 2.9925841447E+00, 1.6921520767E+00, 8.4485689377E-01],
	[2.2155000000E+04, 1.4899091117E+01, 5.2724398961E+00, 2.9947424344E+00, 1.6929003281E+00, 8.4493386070E-01],
	[2.2160000000E+04, 1.4904265398E+01, 5.2723582211E+00, 2.9969017912E+00, 1.6936485508E+00, 8.4501079101E-01],
	[2.2165000000E+04, 1.4909440309E+01, 5.2722765658E+00, 2.9990622153E+00, 1.6943967447E+00, 8.4508768471E-01],
	[2.2170000000E+04, 1.4914615849E+01, 5.2721949302E+00, 3.0012237070E+00, 1.6951449095E+00, 8.4516454181E-01],
	[2.2175000000E+04, 1.4919792017E+01, 5.2721133142E+00, 3.0033862666E+00, 1.6958930452E+00, 8.4524136232E-01],
	[2.2180000000E+04, 1.4924968814E+01, 5.2720317180E+00, 3.0055498944E+00, 1.6966411515E+00, 8.4531814625E-01],
	[2.2185000000E+04, 1.4930146240E+01, 5.2719501413E+00, 3.0077145907E+00, 1.6973892284E+00, 8.4539489362E-01],
	[2.2190000000E+04, 1.4935324295E+01, 5.2718685844E+00, 3.0098803558E+00, 1.6981372756E+00, 8.4547160443E-01],
	[2.2195000000E+04, 1.4940502978E+01, 5.2717870470E+00, 3.0120471899E+00, 1.6988852930E+00, 8.4554827871E-01],
	[2.2200000000E+04, 1.4945682290E+01, 5.2717055293E+00, 3.0142150933E+00, 1.6996332805E+00, 8.4562491645E-01],
	[2.2205000000E+04, 1.4950862231E+01, 5.2716240312E+00, 3.0163840664E+00, 1.7003812379E+00, 8.4570151767E-01],
	[2.2210000000E+04, 1.4956042799E+01, 5.2715425527E+00, 3.0185541093E+00, 1.7011291650E+00, 8.4577808238E-01],
	[2.2215000000E+04, 1.4961223997E+01, 5.2714610938E+00, 3.0207252224E+00, 1.7018770617E+00, 8.4585461060E-01],
	[2.2220000000E+04, 1.4966405822E+01, 5.2713796545E+00, 3.0228974061E+00, 1.7026249278E+00, 8.4593110233E-01],
	[2.2225000000E+04, 1.4971588276E+01, 5.2712982348E+00, 3.0250706604E+00, 1.7033727633E+00, 8.4600755759E-01],
	[2.2230000000E+04, 1.4976771358E+01, 5.2712168346E+00, 3.0272449859E+00, 1.7041205678E+00, 8.4608397638E-01],
	[2.2235000000E+04, 1.4981955067E+01, 5.2711354541E+00, 3.0294203826E+00, 1.7048683413E+00, 8.4616035873E-01],
	[2.2240000000E+04, 1.4987139405E+01, 5.2710540930E+00, 3.0315968510E+00, 1.7056160836E+00, 8.4623670463E-01],
	[2.2245000000E+04, 1.4992324371E+01, 5.2709727515E+00, 3.0337743912E+00, 1.7063637946E+00, 8.4631301411E-01],
	[2.2250000000E+04, 1.4997509965E+01, 5.2708914296E+00, 3.0359530037E+00, 1.7071114741E+00, 8.4638928717E-01],
	[2.2255000000E+04, 1.5002696187E+01, 5.2708101272E+00, 3.0381326886E+00, 1.7078591219E+00, 8.4646552383E-01],
	[2.2260000000E+04, 1.5007883036E+01, 5.2707288443E+00, 3.0403134463E+00, 1.7086067379E+00, 8.4654172410E-01],
	[2.2265000000E+04, 1.5013070513E+01, 5.2706475809E+00, 3.0424952770E+00, 1.7093543220E+00, 8.4661788798E-01],
	[2.2270000000E+04, 1.5018258618E+01, 5.2705663370E+00, 3.0446781810E+00, 1.7101018739E+00, 8.4669401550E-01],
	[2.2275000000E+04, 1.5023447350E+01, 5.2704851126E+00, 3.0468621587E+00, 1.7108493936E+00, 8.4677010666E-01],
	[2.2280000000E+04, 1.5028636710E+01, 5.2704039076E+00, 3.0490472102E+00, 1.7115968809E+00, 8.4684616147E-01],
	[2.2285000000E+04, 1.5033826698E+01, 5.2703227222E+00, 3.0512333359E+00, 1.7123443356E+00, 8.4692217994E-01],
	[2.2290000000E+04, 1.5039017312E+01, 5.2702415562E+00, 3.0534205361E+00, 1.7130917575E+00, 8.4699816210E-01],
	[2.2295000000E+04, 1.5044208554E+01, 5.2701604097E+00, 3.0556088111E+00, 1.7138391466E+00, 8.4707410794E-01],
	[2.2300000000E+04, 1.5049400423E+01, 5.2700792826E+00, 3.0577981611E+00, 1.7145865026E+00, 8.4715001749E-01],
	[2.2305000000E+04, 1.5054592920E+01, 5.2699981749E+00, 3.0599885864E+00, 1.7153338255E+00, 8.4722589074E-01],
	[2.2310000000E+04, 1.5059786043E+01, 5.2699170867E+00, 3.0621800873E+00, 1.7160811150E+00, 8.4730172772E-01],
	[2.2315000000E+04, 1.5064979794E+01, 5.2698360179E+00, 3.0643726641E+00, 1.7168283710E+00, 8.4737752844E-01],
	[2.2320000000E+04, 1.5070174172E+01, 5.2697549685E+00, 3.0665663171E+00, 1.7175755934E+00, 8.4745329291E-01],
	[2.2325000000E+04, 1.5075369176E+01, 5.2696739385E+00, 3.0687610466E+00, 1.7183227820E+00, 8.4752902113E-01],
	[2.2330000000E+04, 1.5080564807E+01, 5.2695929279E+00, 3.0709568528E+00, 1.7190699366E+00, 8.4760471313E-01],
	[2.2335000000E+04, 1.5085761066E+01, 5.2695119367E+00, 3.0731537361E+00, 1.7198170571E+00, 8.4768036891E-01],
	[2.2340000000E+04, 1.5090957950E+01, 5.2694309648E+00, 3.0753516966E+00, 1.7205641434E+00, 8.4775598848E-01],
	[2.2345000000E+04, 1.5096155462E+01, 5.2693500123E+00, 3.0775507348E+00, 1.7213111952E+00, 8.4783157186E-01],
	[2.2350000000E+04, 1.5101353600E+01, 5.2692690792E+00, 3.0797508509E+00, 1.7220582125E+00, 8.4790711906E-01],
	[2.2355000000E+04, 1.5106552365E+01, 5.2691881654E+00, 3.0819520451E+00, 1.7228051951E+00, 8.4798263009E-01],
	[2.2360000000E+04, 1.5111751756E+01, 5.2691072710E+00, 3.0841543178E+00, 1.7235521428E+00, 8.4805810496E-01],
	[2.2365000000E+04, 1.5116951774E+01, 5.2690263959E+00, 3.0863683376E+00, 1.7243023853E+00, 8.4813354369E-01],
	[2.2370000000E+04, 1.5122152418E+01, 5.2689455401E+00, 3.0885851871E+00, 1.7250531351E+00, 8.4820894629E-01],
	[2.2375000000E+04, 1.5127353688E+01, 5.2688647036E+00, 3.0908031310E+00, 1.7258038498E+00, 8.4828431276E-01],
	[2.2380000000E+04, 1.5132555584E+01, 5.2687838864E+00, 3.0930221695E+00, 1.7265545294E+00, 8.4835964312E-01],
	[2.2385000000E+04, 1.5137758107E+01, 5.2687030885E+00, 3.0952423029E+00, 1.7273051737E+00, 8.4843493738E-01],
	[2.2390000000E+04, 1.5142961255E+01, 5.2686223099E+00, 3.0974635316E+00, 1.7280557825E+00, 8.4851019556E-01],
	[2.2395000000E+04, 1.5148165030E+01, 5.2685415506E+00, 3.0996858558E+00, 1.7288063558E+00, 8.4858541767E-01],
	[2.2400000000E+04, 1.5153369431E+01, 5.2684608105E+00, 3.1019092759E+00, 1.7295568932E+00, 8.4866060371E-01],
	[2.2405000000E+04, 1.5158574457E+01, 5.2683800897E+00, 3.1041337921E+00, 1.7303073947E+00, 8.4873575370E-01],
	[2.2410000000E+04, 1.5163780110E+01, 5.2682993881E+00, 3.1063594047E+00, 1.7310578601E+00, 8.4881086765E-01],
	[2.2415000000E+04, 1.5168986388E+01, 5.2682187058E+00, 3.1085861140E+00, 1.7318082893E+00, 8.4888594558E-01],
	[2.2420000000E+04, 1.5174193291E+01, 5.2681380427E+00, 3.1108139203E+00, 1.7325586821E+00, 8.4896098750E-01],
	[2.2425000000E+04, 1.5179400821E+01, 5.2680573988E+00, 3.1130428239E+00, 1.7333090384E+00, 8.4903599341E-01],
	[2.2430000000E+04, 1.5184608976E+01, 5.2679767742E+00, 3.1152728251E+00, 1.7340593579E+00, 8.4911096333E-01],
	[2.2435000000E+04, 1.5189817756E+01, 5.2678961687E+00, 3.1175039242E+00, 1.7348096407E+00, 8.4918589728E-01],
	[2.2440000000E+04, 1.5195048611E+01, 5.2678192878E+00, 3.1197361215E+00, 1.7355605684E+00, 8.4926079526E-01],
	[2.2445000000E+04, 1.5200282941E+01, 5.2677429156E+00, 3.1219694172E+00, 1.7363115502E+00, 8.4933565728E-01],
	[2.2450000000E+04, 1.5205517908E+01, 5.2676665616E+00, 3.1242038118E+00, 1.7370624956E+00, 8.4941048337E-01],
	[2.2455000000E+04, 1.5210753512E+01, 5.2675902257E+00, 3.1264393053E+00, 1.7378134046E+00, 8.4948527352E-01],
	[2.2460000000E+04, 1.5215989752E+01, 5.2675139078E+00, 3.1286758983E+00, 1.7385642769E+00, 8.4956002776E-01],
	[2.2465000000E+04, 1.5221226628E+01, 5.2674376081E+00, 3.1309135909E+00, 1.7393151123E+00, 8.4963474609E-01],
	[2.2470000000E+04, 1.5226464141E+01, 5.2673613265E+00, 3.1331523834E+00, 1.7400659109E+00, 8.4970942853E-01],
	[2.2475000000E+04, 1.5231702290E+01, 5.2672850629E+00, 3.1353922762E+00, 1.7408166723E+00, 8.4978407509E-01],
	[2.2480000000E+04, 1.5236941075E+01, 5.2672088174E+00, 3.1376332695E+00, 1.7415673964E+00, 8.4985868578E-01],
	[2.2485000000E+04, 1.5242180497E+01, 5.2671325900E+00, 3.1398753637E+00, 1.7423180831E+00, 8.4993326061E-01],
	[2.2490000000E+04, 1.5247420554E+01, 5.2670563806E+00, 3.1421185589E+00, 1.7430687323E+00, 8.5000779960E-01],
	[2.2495000000E+04, 1.5252661248E+01, 5.2669801892E+00, 3.1443628556E+00, 1.7438193437E+00, 8.5008230276E-01],
	[2.2500000000E+04, 1.5257902577E+01, 5.2669040159E+00, 3.1466082540E+00, 1.7445699173E+00, 8.5015677009E-01],
	[2.2505000000E+04, 1.5263144542E+01, 5.2668278607E+00, 3.1488547544E+00, 1.7453204528E+00, 8.5023120162E-01],
	[2.2510000000E+04, 1.5268387144E+01, 5.2667517234E+00, 3.1511023571E+00, 1.7460709502E+00, 8.5030559736E-01],
	[2.2515000000E+04, 1.5273630381E+01, 5.2666756041E+00, 3.1533510624E+00, 1.7468214093E+00, 8.5037995731E-01],
	[2.2520000000E+04, 1.5278874253E+01, 5.2665995029E+00, 3.1556008706E+00, 1.7475718298E+00, 8.5045428149E-01],
	[2.2525000000E+04, 1.5284118761E+01, 5.2665234196E+00, 3.1578517820E+00, 1.7483222118E+00, 8.5052856991E-01],
	[2.2530000000E+04, 1.5289363905E+01, 5.2664473544E+00, 3.1601037969E+00, 1.7490725549E+00, 8.5060282259E-01],
	[2.2535000000E+04, 1.5294609684E+01, 5.2663713071E+00, 3.1623569155E+00, 1.7498228591E+00, 8.5067703953E-01],
	[2.2540000000E+04, 1.5299856099E+01, 5.2662952777E+00, 3.1646111382E+00, 1.7505731243E+00, 8.5075122075E-01],
	[2.2545000000E+04, 1.5305103149E+01, 5.2662192664E+00, 3.1668664652E+00, 1.7513233502E+00, 8.5082536626E-01],
	[2.2550000000E+04, 1.5310350835E+01, 5.2661432730E+00, 3.1691228970E+00, 1.7520735367E+00, 8.5089947608E-01],
	[2.2555000000E+04, 1.5315599155E+01, 5.2660672975E+00, 3.1713804336E+00, 1.7528236837E+00, 8.5097355021E-01],
	[2.2560000000E+04, 1.5320848111E+01, 5.2659913400E+00, 3.1736390755E+00, 1.7535737910E+00, 8.5104758866E-01],
	[2.2565000000E+04, 1.5326097702E+01, 5.2659154004E+00, 3.1758988230E+00, 1.7543238584E+00, 8.5112159146E-01],
	[2.2570000000E+04, 1.5331347928E+01, 5.2658394787E+00, 3.1781596763E+00, 1.7550738859E+00, 8.5119555861E-01],
	[2.2575000000E+04, 1.5336598789E+01, 5.2657635749E+00, 3.1804216357E+00, 1.7558238732E+00, 8.5126949013E-01],
	[2.2580000000E+04, 1.5341850285E+01, 5.2656876890E+00, 3.1826847015E+00, 1.7565738203E+00, 8.5134338602E-01],
	[2.2585000000E+04, 1.5347102416E+01, 5.2656118211E+00, 3.1849488740E+00, 1.7573237269E+00, 8.5141724630E-01],
	[2.2590000000E+04, 1.5352355181E+01, 5.2655359710E+00, 3.1872141536E+00, 1.7580735929E+00, 8.5149107099E-01],
	[2.2595000000E+04, 1.5357608582E+01, 5.2654601388E+00, 3.1894805405E+00, 1.7588234181E+00, 8.5156486009E-01],
	[2.2600000000E+04, 1.5362862617E+01, 5.2653843244E+00, 3.1917480349E+00, 1.7595732025E+00, 8.5163861361E-01],
	[2.2605000000E+04, 1.5368117286E+01, 5.2653085280E+00, 3.1940166373E+00, 1.7603229459E+00, 8.5171233158E-01],
	[2.2610000000E+04, 1.5373372591E+01, 5.2652327493E+00, 3.1962863479E+00, 1.7610726480E+00, 8.5178601399E-01],
	[2.2615000000E+04, 1.5378628529E+01, 5.2651569886E+00, 3.1985571669E+00, 1.7618223089E+00, 8.5185966088E-01],
	[2.2620000000E+04, 1.5383885102E+01, 5.2650812456E+00, 3.2008290947E+00, 1.7625719282E+00, 8.5193327224E-01],
	[2.2625000000E+04, 1.5389142310E+01, 5.2650055205E+00, 3.2031021316E+00, 1.7633215059E+00, 8.5200684808E-01],
	[2.2630000000E+04, 1.5394400151E+01, 5.2649298132E+00, 3.2053762779E+00, 1.7640710418E+00, 8.5208038843E-01],
	[2.2635000000E+04, 1.5399658627E+01, 5.2648541238E+00, 3.2076515338E+00, 1.7648205358E+00, 8.5215389330E-01],
	[2.2640000000E+04, 1.5404917737E+01, 5.2647784521E+00, 3.2099278997E+00, 1.7655699877E+00, 8.5222736269E-01],
	[2.2645000000E+04, 1.5410177482E+01, 5.2647027982E+00, 3.2122053758E+00, 1.7663193973E+00, 8.5230079662E-01],
	[2.2650000000E+04, 1.5415437860E+01, 5.2646271622E+00, 3.2144839625E+00, 1.7670687646E+00, 8.5237419511E-01],
	[2.2655000000E+04, 1.5420698872E+01, 5.2645515439E+00, 3.2167636600E+00, 1.7678180894E+00, 8.5244755816E-01],
	[2.2660000000E+04, 1.5425960518E+01, 5.2644759433E+00, 3.2190444686E+00, 1.7685673714E+00, 8.5252088578E-01],
	[2.2665000000E+04, 1.5431222798E+01, 5.2644003606E+00, 3.2213263887E+00, 1.7693166107E+00, 8.5259417800E-01],
	[2.2670000000E+04, 1.5436485712E+01, 5.2643247956E+00, 3.2236094205E+00, 1.7700658069E+00, 8.5266743482E-01],
	[2.2675000000E+04, 1.5441749259E+01, 5.2642492483E+00, 3.2258935644E+00, 1.7708149601E+00, 8.5274065625E-01],
	[2.2680000000E+04, 1.5447013440E+01, 5.2641737188E+00, 3.2281788205E+00, 1.7715640700E+00, 8.5281384231E-01],
	[2.2685000000E+04, 1.5452278255E+01, 5.2640982070E+00, 3.2304651893E+00, 1.7723131364E+00, 8.5288699301E-01],
	[2.2690000000E+04, 1.5457543703E+01, 5.2640227130E+00, 3.2327526709E+00, 1.7730621593E+00, 8.5296010837E-01],
	[2.2695000000E+04, 1.5462809785E+01, 5.2639472366E+00, 3.2350412658E+00, 1.7738111385E+00, 8.5303318839E-01],
	[2.2700000000E+04, 1.5468076500E+01, 5.2638717780E+00, 3.2373309742E+00, 1.7745600738E+00, 8.5310623308E-01],
	[2.2705000000E+04, 1.5473343848E+01, 5.2637963371E+00, 3.2396217963E+00, 1.7753089650E+00, 8.5317924247E-01],
	[2.2710000000E+04, 1.5478611830E+01, 5.2637209138E+00, 3.2419137325E+00, 1.7760578122E+00, 8.5325221657E-01],
	[2.2715000000E+04, 1.5483880445E+01, 5.2636455083E+00, 3.2442067831E+00, 1.7768066150E+00, 8.5332515537E-01],
	[2.2720000000E+04, 1.5489149693E+01, 5.2635701204E+00, 3.2465009484E+00, 1.7775553734E+00, 8.5339805891E-01],
	[2.2725000000E+04, 1.5494419574E+01, 5.2634947502E+00, 3.2487962287E+00, 1.7783040872E+00, 8.5347092719E-01],
	[2.2730000000E+04, 1.5499690088E+01, 5.2634193976E+00, 3.2510926242E+00, 1.7790527562E+00, 8.5354376023E-01],
	[2.2735000000E+04, 1.5504961235E+01, 5.2633440627E+00, 3.2533901353E+00, 1.7798013803E+00, 8.5361655803E-01],
	[2.2740000000E+04, 1.5510233015E+01, 5.2632687455E+00, 3.2556887622E+00, 1.7805499594E+00, 8.5368932061E-01],
	[2.2745000000E+04, 1.5515505428E+01, 5.2631934459E+00, 3.2579885053E+00, 1.7812984933E+00, 8.5376204798E-01],
	[2.2750000000E+04, 1.5520778474E+01, 5.2631181639E+00, 3.2602893648E+00, 1.7820469818E+00, 8.5383474016E-01],
	[2.2755000000E+04, 1.5526052152E+01, 5.2630428995E+00, 3.2625913410E+00, 1.7827954249E+00, 8.5390739716E-01],
	[2.2760000000E+04, 1.5531326463E+01, 5.2629676528E+00, 3.2648944343E+00, 1.7835438224E+00, 8.5398001899E-01],
	[2.2765000000E+04, 1.5536601406E+01, 5.2628924236E+00, 3.2671986449E+00, 1.7842921740E+00, 8.5405260566E-01],
	[2.2770000000E+04, 1.5541876982E+01, 5.2628172120E+00, 3.2695039732E+00, 1.7850404798E+00, 8.5412515719E-01],
	[2.2775000000E+04, 1.5547153191E+01, 5.2627420181E+00, 3.2718104193E+00, 1.7857887395E+00, 8.5419767359E-01],
	[2.2780000000E+04, 1.5552430032E+01, 5.2626668417E+00, 3.2741179837E+00, 1.7865369530E+00, 8.5427015487E-01],
	[2.2785000000E+04, 1.5557707505E+01, 5.2625916829E+00, 3.2764266666E+00, 1.7872851201E+00, 8.5434260104E-01],
	[2.2790000000E+04, 1.5562985610E+01, 5.2625165416E+00, 3.2787364682E+00, 1.7880332407E+00, 8.5441501212E-01],
	[2.2795000000E+04, 1.5568264348E+01, 5.2624414179E+00, 3.2810473890E+00, 1.7887813146E+00, 8.5448738813E-01],
	[2.2800000000E+04, 1.5573559492E+01, 5.2623689861E+00, 3.2833594292E+00, 1.7895298593E+00, 8.5455972907E-01],
	[2.2805000000E+04, 1.5578863898E+01, 5.2622980327E+00, 3.2856725890E+00, 1.7902786407E+00, 8.5463203495E-01],
	[2.2810000000E+04, 1.5584168947E+01, 5.2622270958E+00, 3.2879868689E+00, 1.7910273760E+00, 8.5470430579E-01],
	[2.2815000000E+04, 1.5589474640E+01, 5.2621561753E+00, 3.2903022690E+00, 1.7917760650E+00, 8.5477654161E-01],
	[2.2820000000E+04, 1.5594780976E+01, 5.2620852714E+00, 3.2926187897E+00, 1.7925247076E+00, 8.5484874241E-01],
	[2.2825000000E+04, 1.5600087954E+01, 5.2620143840E+00, 3.2949364312E+00, 1.7932733036E+00, 8.5492090820E-01],
	[2.2830000000E+04, 1.5605395576E+01, 5.2619435130E+00, 3.2972551939E+00, 1.7940218529E+00, 8.5499303901E-01],
	[2.2835000000E+04, 1.5610703841E+01, 5.2618726586E+00, 3.2995750781E+00, 1.7947703554E+00, 8.5506513485E-01],
	[2.2840000000E+04, 1.5616012748E+01, 5.2618018205E+00, 3.3018960840E+00, 1.7955188108E+00, 8.5513719571E-01],
	[2.2845000000E+04, 1.5621322299E+01, 5.2617309990E+00, 3.3042182120E+00, 1.7962672192E+00, 8.5520922163E-01],
	[2.2850000000E+04, 1.5626632492E+01, 5.2616601939E+00, 3.3065414623E+00, 1.7970155802E+00, 8.5528121261E-01],
	[2.2855000000E+04, 1.5631943327E+01, 5.2615894052E+00, 3.3088658353E+00, 1.7977638938E+00, 8.5535316867E-01],
	[2.2860000000E+04, 1.5637254806E+01, 5.2615186330E+00, 3.3111913312E+00, 1.7985121598E+00, 8.5542508982E-01],
	[2.2865000000E+04, 1.5642566927E+01, 5.2614478772E+00, 3.3135179503E+00, 1.7992603780E+00, 8.5549697606E-01],
	[2.2870000000E+04, 1.5647879690E+01, 5.2613771378E+00, 3.3158456930E+00, 1.8000085485E+00, 8.5556882742E-01],
	[2.2875000000E+04, 1.5653193096E+01, 5.2613064149E+00, 3.3181745594E+00, 1.8007566709E+00, 8.5564064391E-01],
	[2.2880000000E+04, 1.5658507144E+01, 5.2612357083E+00, 3.3205045500E+00, 1.8015047451E+00, 8.5571242554E-01],
	[2.2885000000E+04, 1.5663821834E+01, 5.2611650182E+00, 3.3228356650E+00, 1.8022527711E+00, 8.5578417232E-01],
	[2.2890000000E+04, 1.5669137167E+01, 5.2610943444E+00, 3.3251679047E+00, 1.8030007486E+00, 8.5585588427E-01],
	[2.2895000000E+04, 1.5674453142E+01, 5.2610236871E+00, 3.3275012694E+00, 1.8037486775E+00, 8.5592756140E-01],
	[2.2900000000E+04, 1.5679769759E+01, 5.2609530461E+00, 3.3298357594E+00, 1.8044965577E+00, 8.5599920372E-01],
	[2.2905000000E+04, 1.5685087018E+01, 5.2608824215E+00, 3.3321713750E+00, 1.8052443891E+00, 8.5607081125E-01],
	[2.2910000000E+04, 1.5690404919E+01, 5.2608118132E+00, 3.3345081165E+00, 1.8059921714E+00, 8.5614238399E-01],
	[2.2915000000E+04, 1.5695723462E+01, 5.2607412213E+00, 3.3368459841E+00, 1.8067399045E+00, 8.5621392197E-01],
	[2.2920000000E+04, 1.5701042646E+01, 5.2606706457E+00, 3.3391849783E+00, 1.8074875884E+00, 8.5628542519E-01],
	[2.2925000000E+04, 1.5706362473E+01, 5.2606000865E+00, 3.3415250992E+00, 1.8082352228E+00, 8.5635689367E-01],
	[2.2930000000E+04, 1.5711682941E+01, 5.2605295436E+00, 3.3438663471E+00, 1.8089828076E+00, 8.5642832742E-01],
	[2.2935000000E+04, 1.5717004051E+01, 5.2604590171E+00, 3.3462087225E+00, 1.8097303427E+00, 8.5649972645E-01],
	[2.2940000000E+04, 1.5722325803E+01, 5.2603885068E+00, 3.3485522255E+00, 1.8104778279E+00, 8.5657109078E-01],
	[2.2945000000E+04, 1.5727648196E+01, 5.2603180129E+00, 3.3508968564E+00, 1.8112252631E+00, 8.5664242043E-01],
	[2.2950000000E+04, 1.5732971231E+01, 5.2602475353E+00, 3.3532426156E+00, 1.8119726482E+00, 8.5671371539E-01],
	[2.2955000000E+04, 1.5738294907E+01, 5.2601770740E+00, 3.3555895034E+00, 1.8127199829E+00, 8.5678497569E-01],
	[2.2960000000E+04, 1.5743619224E+01, 5.2601066289E+00, 3.3579375200E+00, 1.8134672673E+00, 8.5685620134E-01],
	[2.2965000000E+04, 1.5748944183E+01, 5.2600362002E+00, 3.3602866657E+00, 1.8142145010E+00, 8.5692739235E-01],
	[2.2970000000E+04, 1.5754269783E+01, 5.2599657877E+00, 3.3626369408E+00, 1.8149616840E+00, 8.5699854874E-01],
	[2.2975000000E+04, 1.5759596024E+01, 5.2598953915E+00, 3.3649883457E+00, 1.8157088161E+00, 8.5706967052E-01],
	[2.2980000000E+04, 1.5764922906E+01, 5.2598250116E+00, 3.3673408806E+00, 1.8164558972E+00, 8.5714075770E-01],
	[2.2985000000E+04, 1.5770250429E+01, 5.2597546479E+00, 3.3696945458E+00, 1.8172029272E+00, 8.5721181030E-01],
	[2.2990000000E+04, 1.5775578593E+01, 5.2596843004E+00, 3.3720493416E+00, 1.8179499059E+00, 8.5728282832E-01],
	[2.2995000000E+04, 1.5780907398E+01, 5.2596139692E+00, 3.3744052684E+00, 1.8186968331E+00, 8.5735381179E-01],
	[2.3000000000E+04, 1.5786236844E+01, 5.2595436542E+00, 3.3767623263E+00, 1.8194437088E+00, 8.5742476071E-01],
	[2.3005000000E+04, 1.5791566931E+01, 5.2594733555E+00, 3.3791205158E+00, 1.8201905327E+00, 8.5749567510E-01],
	[2.3010000000E+04, 1.5796897659E+01, 5.2594030729E+00, 3.3814798370E+00, 1.8209373048E+00, 8.5756655497E-01],
	[2.3015000000E+04, 1.5802229027E+01, 5.2593328066E+00, 3.3838402903E+00, 1.8216840249E+00, 8.5763740033E-01],
	[2.3020000000E+04, 1.5807561036E+01, 5.2592625565E+00, 3.3862018760E+00, 1.8224306929E+00, 8.5770821121E-01],
	[2.3025000000E+04, 1.5812893685E+01, 5.2591923225E+00, 3.3885645944E+00, 1.8231773085E+00, 8.5777898760E-01],
	[2.3030000000E+04, 1.5818226975E+01, 5.2591221048E+00, 3.3909284458E+00, 1.8239238718E+00, 8.5784972953E-01],
	[2.3035000000E+04, 1.5823560905E+01, 5.2590519032E+00, 3.3932934305E+00, 1.8246703825E+00, 8.5792043700E-01],
	[2.3040000000E+04, 1.5828895476E+01, 5.2589817178E+00, 3.3956595487E+00, 1.8254168405E+00, 8.5799111003E-01],
	[2.3045000000E+04, 1.5834230687E+01, 5.2589115486E+00, 3.3980268008E+00, 1.8261632456E+00, 8.5806174863E-01],
	[2.3050000000E+04, 1.5839566538E+01, 5.2588413955E+00, 3.4003951870E+00, 1.8269095978E+00, 8.5813235281E-01],
	[2.3055000000E+04, 1.5844903029E+01, 5.2587712586E+00, 3.4027647077E+00, 1.8276558968E+00, 8.5820292258E-01],
	[2.3060000000E+04, 1.5850240161E+01, 5.2587011378E+00, 3.4051353631E+00, 1.8284021426E+00, 8.5827345795E-01],
	[2.3065000000E+04, 1.5855577932E+01, 5.2586310332E+00, 3.4075071536E+00, 1.8291483350E+00, 8.5834395893E-01],
	[2.3070000000E+04, 1.5860916344E+01, 5.2585609447E+00, 3.4098800795E+00, 1.8298944738E+00, 8.5841442554E-01],
	[2.3075000000E+04, 1.5866255395E+01, 5.2584908723E+00, 3.4122541409E+00, 1.8306405589E+00, 8.5848485779E-01],
	[2.3080000000E+04, 1.5871595086E+01, 5.2584208160E+00, 3.4146293383E+00, 1.8313865903E+00, 8.5855525568E-01],
	[2.3085000000E+04, 1.5876935418E+01, 5.2583507759E+00, 3.4170056720E+00, 1.8321325676E+00, 8.5862561923E-01],
	[2.3090000000E+04, 1.5882276388E+01, 5.2582807518E+00, 3.4193831421E+00, 1.8328784909E+00, 8.5869594846E-01],
	[2.3095000000E+04, 1.5887617999E+01, 5.2582107439E+00, 3.4217617491E+00, 1.8336243599E+00, 8.5876624336E-01],
	[2.3100000000E+04, 1.5892960249E+01, 5.2581407520E+00, 3.4241414932E+00, 1.8343701746E+00, 8.5883650397E-01],
	[2.3105000000E+04, 1.5898303139E+01, 5.2580707762E+00, 3.4265223748E+00, 1.8351159347E+00, 8.5890673027E-01],
	[2.3110000000E+04, 1.5903646668E+01, 5.2580008165E+00, 3.4289043940E+00, 1.8358616401E+00, 8.5897692230E-01],
	[2.3115000000E+04, 1.5908990836E+01, 5.2579308728E+00, 3.4312875512E+00, 1.8366072908E+00, 8.5904708005E-01],
	[2.3120000000E+04, 1.5914335644E+01, 5.2578609452E+00, 3.4336718467E+00, 1.8373528865E+00, 8.5911720354E-01],
	[2.3125000000E+04, 1.5919681092E+01, 5.2577910337E+00, 3.4360572809E+00, 1.8380984272E+00, 8.5918729279E-01],
	[2.3130000000E+04, 1.5925027178E+01, 5.2577211381E+00, 3.4384438539E+00, 1.8388439126E+00, 8.5925734779E-01],
	[2.3135000000E+04, 1.5930373904E+01, 5.2576512587E+00, 3.4408315661E+00, 1.8395893427E+00, 8.5932736858E-01],
	[2.3140000000E+04, 1.5935721269E+01, 5.2575813952E+00, 3.4432204178E+00, 1.8403347173E+00, 8.5939735515E-01],
	[2.3145000000E+04, 1.5941069273E+01, 5.2575115478E+00, 3.4456104092E+00, 1.8410800363E+00, 8.5946730752E-01],
	[2.3150000000E+04, 1.5946417916E+01, 5.2574417164E+00, 3.4480015408E+00, 1.8418252995E+00, 8.5953722569E-01],
	[2.3155000000E+04, 1.5951767197E+01, 5.2573719010E+00, 3.4503938127E+00, 1.8425705068E+00, 8.5960710970E-01],
	[2.3160000000E+04, 1.5957117118E+01, 5.2573021016E+00, 3.4527872253E+00, 1.8433156581E+00, 8.5967695953E-01],
	[2.3165000000E+04, 1.5962473735E+01, 5.2572333262E+00, 3.4551817788E+00, 1.8440609581E+00, 8.5974677521E-01],
	[2.3170000000E+04, 1.5967849444E+01, 5.2571676354E+00, 3.4575774736E+00, 1.8448068261E+00, 8.5981655674E-01],
	[2.3175000000E+04, 1.5973225803E+01, 5.2571019596E+00, 3.4599743100E+00, 1.8455526386E+00, 8.5988630415E-01],
	[2.3180000000E+04, 1.5978602811E+01, 5.2570362988E+00, 3.4623722882E+00, 1.8462983955E+00, 8.5995601743E-01],
	[2.3185000000E+04, 1.5983980470E+01, 5.2569706530E+00, 3.4647714086E+00, 1.8470440967E+00, 8.6002569660E-01],
	[2.3190000000E+04, 1.5989358777E+01, 5.2569050221E+00, 3.4671716714E+00, 1.8477897419E+00, 8.6009534168E-01],
	[2.3195000000E+04, 1.5994737735E+01, 5.2568394063E+00, 3.4695730769E+00, 1.8485353311E+00, 8.6016495268E-01],
	[2.3200000000E+04, 1.6000117342E+01, 5.2567738053E+00, 3.4719756255E+00, 1.8492808640E+00, 8.6023452960E-01],
	[2.3205000000E+04, 1.6005497599E+01, 5.2567082194E+00, 3.4743793174E+00, 1.8500263407E+00, 8.6030407246E-01],
	[2.3210000000E+04, 1.6010878505E+01, 5.2566426484E+00, 3.4767841529E+00, 1.8507717609E+00, 8.6037358127E-01],
	[2.3215000000E+04, 1.6016260060E+01, 5.2565770923E+00, 3.4791901324E+00, 1.8515171245E+00, 8.6044305605E-01],
	[2.3220000000E+04, 1.6021642265E+01, 5.2565115511E+00, 3.4815972560E+00, 1.8522624314E+00, 8.6051249680E-01],
	[2.3225000000E+04, 1.6027025119E+01, 5.2564460249E+00, 3.4840055242E+00, 1.8530076814E+00, 8.6058190353E-01],
	[2.3230000000E+04, 1.6032408622E+01, 5.2563805136E+00, 3.4864149372E+00, 1.8537528743E+00, 8.6065127626E-01],
	[2.3235000000E+04, 1.6037792774E+01, 5.2563150173E+00, 3.4888254953E+00, 1.8544980102E+00, 8.6072061500E-01],
	[2.3240000000E+04, 1.6043177575E+01, 5.2562495358E+00, 3.4912371988E+00, 1.8552430888E+00, 8.6078991977E-01],
	[2.3245000000E+04, 1.6048563026E+01, 5.2561840692E+00, 3.4936500480E+00, 1.8559881099E+00, 8.6085919057E-01],
	[2.3250000000E+04, 1.6053949125E+01, 5.2561186176E+00, 3.4960640433E+00, 1.8567330735E+00, 8.6092842741E-01],
	[2.3255000000E+04, 1.6059335873E+01, 5.2560531808E+00, 3.4984791848E+00, 1.8574779794E+00, 8.6099763031E-01],
	[2.3260000000E+04, 1.6064723270E+01, 5.2559877589E+00, 3.5008954728E+00, 1.8582228275E+00, 8.6106679928E-01],
	[2.3265000000E+04, 1.6070111316E+01, 5.2559223519E+00, 3.5033129078E+00, 1.8589676177E+00, 8.6113593433E-01],
	[2.3270000000E+04, 1.6075500010E+01, 5.2558569597E+00, 3.5057314900E+00, 1.8597123497E+00, 8.6120503548E-01],
	[2.3275000000E+04, 1.6080889354E+01, 5.2557915825E+00, 3.5081512196E+00, 1.8604570235E+00, 8.6127410273E-01],
	[2.3280000000E+04, 1.6086279345E+01, 5.2557262200E+00, 3.5105720970E+00, 1.8612016390E+00, 8.6134313609E-01],
	[2.3285000000E+04, 1.6091669985E+01, 5.2556608724E+00, 3.5129941225E+00, 1.8619461960E+00, 8.6141213559E-01],
	[2.3290000000E+04, 1.6097061274E+01, 5.2555955397E+00, 3.5154172963E+00, 1.8626906943E+00, 8.6148110122E-01],
	[2.3295000000E+04, 1.6102453211E+01, 5.2555302218E+00, 3.5178416188E+00, 1.8634351338E+00, 8.6155003301E-01],
	[2.3300000000E+04, 1.6107845796E+01, 5.2554649187E+00, 3.5202670902E+00, 1.8641795145E+00, 8.6161893097E-01],
	[2.3305000000E+04, 1.6113239030E+01, 5.2553996305E+00, 3.5226937110E+00, 1.8649238361E+00, 8.6168779510E-01],
	[2.3310000000E+04, 1.6118632912E+01, 5.2553343570E+00, 3.5251214812E+00, 1.8656680985E+00, 8.6175662542E-01],
	[2.3315000000E+04, 1.6124027442E+01, 5.2552690984E+00, 3.5275504013E+00, 1.8664123017E+00, 8.6182542194E-01],
	[2.3320000000E+04, 1.6129422620E+01, 5.2552038546E+00, 3.5299804716E+00, 1.8671564453E+00, 8.6189418467E-01],
	[2.3325000000E+04, 1.6134818446E+01, 5.2551386256E+00, 3.5324116922E+00, 1.8679005295E+00, 8.6196291363E-01],
	[2.3330000000E+04, 1.6140214920E+01, 5.2550734113E+00, 3.5348440637E+00, 1.8686445539E+00, 8.6203160883E-01],
	[2.3335000000E+04, 1.6145612042E+01, 5.2550082119E+00, 3.5372775861E+00, 1.8693885184E+00, 8.6210027028E-01],
	[2.3340000000E+04, 1.6151009812E+01, 5.2549430272E+00, 3.5397122599E+00, 1.8701324230E+00, 8.6216889798E-01],
	[2.3345000000E+04, 1.6156408229E+01, 5.2548778573E+00, 3.5421480853E+00, 1.8708762674E+00, 8.6223749196E-01],
	[2.3350000000E+04, 1.6161807295E+01, 5.2548127022E+00, 3.5445850626E+00, 1.8716200517E+00, 8.6230605223E-01],
	[2.3355000000E+04, 1.6167207008E+01, 5.2547475618E+00, 3.5470231922E+00, 1.8723637755E+00, 8.6237457879E-01],
	[2.3360000000E+04, 1.6172607368E+01, 5.2546824362E+00, 3.5494624742E+00, 1.8731074388E+00, 8.6244307167E-01],
	[2.3365000000E+04, 1.6178008376E+01, 5.2546173253E+00, 3.5519029091E+00, 1.8738510415E+00, 8.6251153086E-01],
	[2.3370000000E+04, 1.6183410032E+01, 5.2545522292E+00, 3.5543444971E+00, 1.8745945834E+00, 8.6257995639E-01],
	[2.3375000000E+04, 1.6188812335E+01, 5.2544871478E+00, 3.5567872384E+00, 1.8753380644E+00, 8.6264834827E-01],
	[2.3380000000E+04, 1.6194215285E+01, 5.2544220811E+00, 3.5592311335E+00, 1.8760814843E+00, 8.6271670650E-01],
	[2.3385000000E+04, 1.6199618883E+01, 5.2543570291E+00, 3.5616761826E+00, 1.8768248431E+00, 8.6278503111E-01],
	[2.3390000000E+04, 1.6205023128E+01, 5.2542919918E+00, 3.5641223860E+00, 1.8775681405E+00, 8.6285332210E-01],
	[2.3395000000E+04, 1.6210428020E+01, 5.2542269693E+00, 3.5665697439E+00, 1.8783113765E+00, 8.6292157948E-01],
	[2.3400000000E+04, 1.6215833559E+01, 5.2541619615E+00, 3.5690182567E+00, 1.8790545510E+00, 8.6298980327E-01],
	[2.3405000000E+04, 1.6221239745E+01, 5.2540969683E+00, 3.5714679248E+00, 1.8797976637E+00, 8.6305799348E-01],
	[2.3410000000E+04, 1.6226646579E+01, 5.2540319898E+00, 3.5739187483E+00, 1.8805407146E+00, 8.6312615012E-01],
	[2.3415000000E+04, 1.6232054059E+01, 5.2539670260E+00, 3.5763707275E+00, 1.8812837034E+00, 8.6319427320E-01],
	[2.3420000000E+04, 1.6237462186E+01, 5.2539020769E+00, 3.5788238629E+00, 1.8820266302E+00, 8.6326236274E-01],
	[2.3425000000E+04, 1.6242870959E+01, 5.2538371425E+00, 3.5812781546E+00, 1.8827694948E+00, 8.6333041875E-01],
	[2.3430000000E+04, 1.6248280380E+01, 5.2537722227E+00, 3.5837336030E+00, 1.8835122970E+00, 8.6339844124E-01],
	[2.3435000000E+04, 1.6253690447E+01, 5.2537073176E+00, 3.5861902083E+00, 1.8842550366E+00, 8.6346643022E-01],
	[2.3440000000E+04, 1.6259101161E+01, 5.2536424271E+00, 3.5886479709E+00, 1.8849977137E+00, 8.6353438571E-01],
	[2.3445000000E+04, 1.6264512522E+01, 5.2535775512E+00, 3.5911068910E+00, 1.8857403279E+00, 8.6360230772E-01],
	[2.3450000000E+04, 1.6269924528E+01, 5.2535126900E+00, 3.5935669690E+00, 1.8864828793E+00, 8.6367019625E-01],
	[2.3455000000E+04, 1.6275337182E+01, 5.2534478435E+00, 3.5960282052E+00, 1.8872253677E+00, 8.6373805133E-01],
	[2.3460000000E+04, 1.6280750482E+01, 5.2533830115E+00, 3.5984905998E+00, 1.8879677928E+00, 8.6380587296E-01],
	[2.3465000000E+04, 1.6286164428E+01, 5.2533181942E+00, 3.6009541531E+00, 1.8887101547E+00, 8.6387366116E-01],
	[2.3470000000E+04, 1.6291579020E+01, 5.2532533914E+00, 3.6034188655E+00, 1.8894524532E+00, 8.6394141594E-01],
	[2.3475000000E+04, 1.6296994259E+01, 5.2531886033E+00, 3.6058847372E+00, 1.8901946881E+00, 8.6400913731E-01],
	[2.3480000000E+04, 1.6302410143E+01, 5.2531238298E+00, 3.6083517685E+00, 1.8909368593E+00, 8.6407682528E-01],
	[2.3485000000E+04, 1.6307826674E+01, 5.2530590708E+00, 3.6108199597E+00, 1.8916789667E+00, 8.6414447987E-01],
	[2.3490000000E+04, 1.6313243851E+01, 5.2529943265E+00, 3.6132893112E+00, 1.8924210102E+00, 8.6421210109E-01],
	[2.3495000000E+04, 1.6318661674E+01, 5.2529295967E+00, 3.6157598232E+00, 1.8931629896E+00, 8.6427968895E-01],
	[2.3500000000E+04, 1.6324080142E+01, 5.2528648815E+00, 3.6182314960E+00, 1.8939049047E+00, 8.6434724346E-01],
	[2.3505000000E+04, 1.6329499257E+01, 5.2528001808E+00, 3.6207043300E+00, 1.8946467556E+00, 8.6441476464E-01],
	[2.3510000000E+04, 1.6334919017E+01, 5.2527354948E+00, 3.6231783253E+00, 1.8953885419E+00, 8.6448225249E-01],
	[2.3515000000E+04, 1.6340339423E+01, 5.2526708232E+00, 3.6256534824E+00, 1.8961302637E+00, 8.6454970704E-01],
	[2.3520000000E+04, 1.6345760475E+01, 5.2526061662E+00, 3.6281298014E+00, 1.8968719207E+00, 8.6461712829E-01],
	[2.3525000000E+04, 1.6351182172E+01, 5.2525415238E+00, 3.6306072828E+00, 1.8976135129E+00, 8.6468451626E-01],
	[2.3530000000E+04, 1.6356604515E+01, 5.2524768959E+00, 3.6330859267E+00, 1.8983550401E+00, 8.6475187095E-01],
	[2.3535000000E+04, 1.6362027503E+01, 5.2524122825E+00, 3.6355657336E+00, 1.8990965021E+00, 8.6481919239E-01],
	[2.3540000000E+04, 1.6367467538E+01, 5.2523503612E+00, 3.6380467036E+00, 1.8998384703E+00, 8.6488648057E-01],
	[2.3545000000E+04, 1.6372916446E+01, 5.2522897952E+00, 3.6405288372E+00, 1.9005806600E+00, 8.6495373553E-01],
	[2.3550000000E+04, 1.6378366010E+01, 5.2522292427E+00, 3.6430121345E+00, 1.9013227852E+00, 8.6502095726E-01],
	[2.3555000000E+04, 1.6383816230E+01, 5.2521687038E+00, 3.6454965959E+00, 1.9020648458E+00, 8.6508814578E-01],
	[2.3560000000E+04, 1.6389267107E+01, 5.2521081784E+00, 3.6479822217E+00, 1.9028068415E+00, 8.6515530110E-01],
	[2.3565000000E+04, 1.6394718640E+01, 5.2520476666E+00, 3.6504690121E+00, 1.9035487722E+00, 8.6522242324E-01],
	[2.3570000000E+04, 1.6400170830E+01, 5.2519871683E+00, 3.6529569675E+00, 1.9042906379E+00, 8.6528951221E-01],
	[2.3575000000E+04, 1.6405623675E+01, 5.2519266835E+00, 3.6554460882E+00, 1.9050324384E+00, 8.6535656802E-01],
	[2.3580000000E+04, 1.6411077176E+01, 5.2518662123E+00, 3.6579363745E+00, 1.9057741736E+00, 8.6542359068E-01],
	[2.3585000000E+04, 1.6416531334E+01, 5.2518057545E+00, 3.6604278266E+00, 1.9065158433E+00, 8.6549058021E-01],
	[2.3590000000E+04, 1.6421986147E+01, 5.2517453103E+00, 3.6629204449E+00, 1.9072574474E+00, 8.6555753662E-01],
	[2.3595000000E+04, 1.6427441616E+01, 5.2516848796E+00, 3.6654142297E+00, 1.9079989858E+00, 8.6562445992E-01],
	[2.3600000000E+04, 1.6432897741E+01, 5.2516244624E+00, 3.6679091811E+00, 1.9087404583E+00, 8.6569135012E-01],
	[2.3605000000E+04, 1.6438354522E+01, 5.2515640587E+00, 3.6704052997E+00, 1.9094818649E+00, 8.6575820723E-01],
	[2.3610000000E+04, 1.6443811959E+01, 5.2515036684E+00, 3.6729025856E+00, 1.9102232053E+00, 8.6582503128E-01],
	[2.3615000000E+04, 1.6449270051E+01, 5.2514432917E+00, 3.6754010391E+00, 1.9109644796E+00, 8.6589182227E-01],
	[2.3620000000E+04, 1.6454728798E+01, 5.2513829284E+00, 3.6779006606E+00, 1.9117056874E+00, 8.6595858021E-01],
	[2.3625000000E+04, 1.6460188202E+01, 5.2513225786E+00, 3.6804014504E+00, 1.9124468288E+00, 8.6602530512E-01],
	[2.3630000000E+04, 1.6465648260E+01, 5.2512622423E+00, 3.6829034086E+00, 1.9131879036E+00, 8.6609199700E-01],
	[2.3635000000E+04, 1.6471108974E+01, 5.2512019194E+00, 3.6854065357E+00, 1.9139289116E+00, 8.6615865588E-01],
	[2.3640000000E+04, 1.6476570344E+01, 5.2511416100E+00, 3.6879108319E+00, 1.9146698528E+00, 8.6622528177E-01],
	[2.3645000000E+04, 1.6482032369E+01, 5.2510813140E+00, 3.6904162976E+00, 1.9154107269E+00, 8.6629187467E-01],
	[2.3650000000E+04, 1.6487495048E+01, 5.2510210315E+00, 3.6929229330E+00, 1.9161515340E+00, 8.6635843460E-01],
	[2.3655000000E+04, 1.6492958383E+01, 5.2509607624E+00, 3.6954307384E+00, 1.9168922738E+00, 8.6642496157E-01],
	[2.3660000000E+04, 1.6498422374E+01, 5.2509005067E+00, 3.6979397141E+00, 1.9176329462E+00, 8.6649145560E-01],
	[2.3665000000E+04, 1.6503887019E+01, 5.2508402644E+00, 3.7004498604E+00, 1.9183735511E+00, 8.6655791669E-01],
	[2.3670000000E+04, 1.6509352319E+01, 5.2507800356E+00, 3.7029611777E+00, 1.9191140884E+00, 8.6662434487E-01],
	[2.3675000000E+04, 1.6514818274E+01, 5.2507198202E+00, 3.7054736661E+00, 1.9198545579E+00, 8.6669074014E-01],
	[2.3680000000E+04, 1.6520284884E+01, 5.2506596182E+00, 3.7079873261E+00, 1.9205949595E+00, 8.6675710252E-01],
	[2.3685000000E+04, 1.6525752149E+01, 5.2505994296E+00, 3.7105021579E+00, 1.9213352931E+00, 8.6682343201E-01],
	[2.3690000000E+04, 1.6531220068E+01, 5.2505392543E+00, 3.7130181617E+00, 1.9220755586E+00, 8.6688972864E-01],
	[2.3695000000E+04, 1.6536688642E+01, 5.2504790925E+00, 3.7155353380E+00, 1.9228157558E+00, 8.6695599241E-01],
	[2.3700000000E+04, 1.6542157871E+01, 5.2504189441E+00, 3.7180536870E+00, 1.9235558846E+00, 8.6702222334E-01],
	[2.3705000000E+04, 1.6547627755E+01, 5.2503588090E+00, 3.7205732089E+00, 1.9242959450E+00, 8.6708842143E-01],
	[2.3710000000E+04, 1.6553098292E+01, 5.2502986873E+00, 3.7230939042E+00, 1.9250359366E+00, 8.6715458671E-01],
	[2.3715000000E+04, 1.6558569485E+01, 5.2502385790E+00, 3.7256157730E+00, 1.9257758595E+00, 8.6722071919E-01],
	[2.3720000000E+04, 1.6564041331E+01, 5.2501784840E+00, 3.7281388157E+00, 1.9265157135E+00, 8.6728681887E-01],
	[2.3725000000E+04, 1.6569513832E+01, 5.2501184024E+00, 3.7306630326E+00, 1.9272554985E+00, 8.6735288578E-01],
	[2.3730000000E+04, 1.6574986987E+01, 5.2500583341E+00, 3.7331884240E+00, 1.9279952144E+00, 8.6741891992E-01],
	[2.3735000000E+04, 1.6580460797E+01, 5.2499982792E+00, 3.7357149902E+00, 1.9287348609E+00, 8.6748492130E-01],
	[2.3740000000E+04, 1.6585935260E+01, 5.2499382376E+00, 3.7382427314E+00, 1.9294744381E+00, 8.6755088995E-01],
	[2.3745000000E+04, 1.6591410378E+01, 5.2498782093E+00, 3.7407716480E+00, 1.9302139458E+00, 8.6761682587E-01],
	[2.3750000000E+04, 1.6596886150E+01, 5.2498181944E+00, 3.7433017403E+00, 1.9309533838E+00, 8.6768272907E-01],
	[2.3755000000E+04, 1.6602362575E+01, 5.2497581927E+00, 3.7458330086E+00, 1.9316927520E+00, 8.6774859957E-01],
	[2.3760000000E+04, 1.6607839655E+01, 5.2496982044E+00, 3.7483654531E+00, 1.9324320504E+00, 8.6781443738E-01],
	[2.3765000000E+04, 1.6613317388E+01, 5.2496382294E+00, 3.7508990741E+00, 1.9331712787E+00, 8.6788024251E-01],
	[2.3770000000E+04, 1.6618795775E+01, 5.2495782678E+00, 3.7534338721E+00, 1.9339104369E+00, 8.6794601498E-01],
	[2.3775000000E+04, 1.6624274816E+01, 5.2495183194E+00, 3.7559698471E+00, 1.9346495248E+00, 8.6801175480E-01],
	[2.3780000000E+04, 1.6629754511E+01, 5.2494583842E+00, 3.7585069997E+00, 1.9353885423E+00, 8.6807746199E-01],
	[2.3785000000E+04, 1.6635234859E+01, 5.2493984624E+00, 3.7610453300E+00, 1.9361274893E+00, 8.6814313654E-01],
	[2.3790000000E+04, 1.6640715861E+01, 5.2493385539E+00, 3.7635848383E+00, 1.9368663657E+00, 8.6820877849E-01],
	[2.3795000000E+04, 1.6646197516E+01, 5.2492786586E+00, 3.7661255250E+00, 1.9376051713E+00, 8.6827438784E-01],
	[2.3800000000E+04, 1.6651679824E+01, 5.2492187766E+00, 3.7686673903E+00, 1.9383439060E+00, 8.6833996460E-01],
	[2.3805000000E+04, 1.6657162786E+01, 5.2491589079E+00, 3.7712104346E+00, 1.9390825697E+00, 8.6840550878E-01],
	[2.3810000000E+04, 1.6662646402E+01, 5.2490990524E+00, 3.7737546581E+00, 1.9398211622E+00, 8.6847102041E-01],
	[2.3815000000E+04, 1.6668130670E+01, 5.2490392101E+00, 3.7763000611E+00, 1.9405596835E+00, 8.6853649949E-01],
	[2.3820000000E+04, 1.6673615592E+01, 5.2489793811E+00, 3.7788466440E+00, 1.9412981334E+00, 8.6860194603E-01],
	[2.3825000000E+04, 1.6679101167E+01, 5.2489195654E+00, 3.7813944069E+00, 1.9420365118E+00, 8.6866736006E-01],
	[2.3830000000E+04, 1.6684587395E+01, 5.2488597629E+00, 3.7839433504E+00, 1.9427748186E+00, 8.6873274157E-01],
	[2.3835000000E+04, 1.6690074276E+01, 5.2487999736E+00, 3.7864934745E+00, 1.9435130536E+00, 8.6879809059E-01],
	[2.3840000000E+04, 1.6695561810E+01, 5.2487401975E+00, 3.7890447797E+00, 1.9442512167E+00, 8.6886340713E-01],
	[2.3845000000E+04, 1.6701049996E+01, 5.2486804347E+00, 3.7915972662E+00, 1.9449893078E+00, 8.6892869120E-01],
	[2.3850000000E+04, 1.6706538836E+01, 5.2486206850E+00, 3.7941509343E+00, 1.9457273269E+00, 8.6899394281E-01],
	[2.3855000000E+04, 1.6712028328E+01, 5.2485609486E+00, 3.7967057843E+00, 1.9464652736E+00, 8.6905916197E-01],
	[2.3860000000E+04, 1.6717518473E+01, 5.2485012253E+00, 3.7992618166E+00, 1.9472031480E+00, 8.6912434871E-01],
	[2.3865000000E+04, 1.6723009271E+01, 5.2484415153E+00, 3.8018190313E+00, 1.9479409499E+00, 8.6918950303E-01],
	[2.3870000000E+04, 1.6728500721E+01, 5.2483818184E+00, 3.8043774289E+00, 1.9486786792E+00, 8.6925462494E-01],
	[2.3875000000E+04, 1.6733992824E+01, 5.2483221348E+00, 3.8069370095E+00, 1.9494163357E+00, 8.6931971446E-01],
	[2.3880000000E+04, 1.6739485580E+01, 5.2482624643E+00, 3.8094977736E+00, 1.9501539194E+00, 8.6938477161E-01],
	[2.3885000000E+04, 1.6744978987E+01, 5.2482028069E+00, 3.8120597214E+00, 1.9508914301E+00, 8.6944979639E-01],
	[2.3890000000E+04, 1.6750473048E+01, 5.2481431628E+00, 3.8146228531E+00, 1.9516288677E+00, 8.6951478881E-01],
	[2.3895000000E+04, 1.6755967760E+01, 5.2480835318E+00, 3.8171871692E+00, 1.9523662321E+00, 8.6957974890E-01],
	[2.3900000000E+04, 1.6761463125E+01, 5.2480239139E+00, 3.8197526698E+00, 1.9531035232E+00, 8.6964467666E-01],
	[2.3905000000E+04, 1.6766959141E+01, 5.2479643092E+00, 3.8223193554E+00, 1.9538407407E+00, 8.6970957210E-01],
	[2.3910000000E+04, 1.6772455810E+01, 5.2479047177E+00, 3.8248872261E+00, 1.9545778847E+00, 8.6977443525E-01],
	[2.3915000000E+04, 1.6777953131E+01, 5.2478451392E+00, 3.8274562823E+00, 1.9553149550E+00, 8.6983926611E-01],
	[2.3920000000E+04, 1.6783472986E+01, 5.2477890786E+00, 3.8300265243E+00, 1.9560527355E+00, 8.6990406469E-01],
	[2.3925000000E+04, 1.6788996358E+01, 5.2477334877E+00, 3.8325979524E+00, 1.9567905454E+00, 8.6996883102E-01],
	[2.3930000000E+04, 1.6794520394E+01, 5.2476779090E+00, 3.8351705669E+00, 1.9575282821E+00, 8.7003356509E-01],
	[2.3935000000E+04, 1.6800045092E+01, 5.2476223425E+00, 3.8377443680E+00, 1.9582659455E+00, 8.7009826693E-01],
	[2.3940000000E+04, 1.6805570453E+01, 5.2475667882E+00, 3.8403193562E+00, 1.9590035356E+00, 8.7016293655E-01],
	[2.3945000000E+04, 1.6811096477E+01, 5.2475112460E+00, 3.8428955316E+00, 1.9597410522E+00, 8.7022757396E-01],
	[2.3950000000E+04, 1.6816623164E+01, 5.2474557161E+00, 3.8454728945E+00, 1.9604784952E+00, 8.7029217917E-01],
	[2.3955000000E+04, 1.6822150513E+01, 5.2474001983E+00, 3.8480514454E+00, 1.9612158644E+00, 8.7035675221E-01],
	[2.3960000000E+04, 1.6827678525E+01, 5.2473446928E+00, 3.8506311844E+00, 1.9619531598E+00, 8.7042129307E-01],
	[2.3965000000E+04, 1.6833207200E+01, 5.2472891993E+00, 3.8532121118E+00, 1.9626903812E+00, 8.7048580178E-01],
	[2.3970000000E+04, 1.6838736537E+01, 5.2472337181E+00, 3.8557942281E+00, 1.9634275285E+00, 8.7055027834E-01],
	[2.3975000000E+04, 1.6844266536E+01, 5.2471782490E+00, 3.8583775334E+00, 1.9641646016E+00, 8.7061472277E-01],
	[2.3980000000E+04, 1.6849797198E+01, 5.2471227920E+00, 3.8609620280E+00, 1.9649016003E+00, 8.7067913509E-01],
	[2.3985000000E+04, 1.6855328522E+01, 5.2470673473E+00, 3.8635477123E+00, 1.9656385246E+00, 8.7074351530E-01],
	[2.3990000000E+04, 1.6860860509E+01, 5.2470119146E+00, 3.8661345866E+00, 1.9663753743E+00, 8.7080786342E-01],
	[2.3995000000E+04, 1.6866393157E+01, 5.2469564941E+00, 3.8687226511E+00, 1.9671121494E+00, 8.7087217947E-01],
	[2.4000000000E+04, 1.6871926468E+01, 5.2469010857E+00, 3.8713119062E+00, 1.9678488496E+00, 8.7093646345E-01],
	[2.4005000000E+04, 1.6877460441E+01, 5.2468456895E+00, 3.8739023521E+00, 1.9685854748E+00, 8.7100071538E-01],
	[2.4010000000E+04, 1.6882995076E+01, 5.2467903053E+00, 3.8764939891E+00, 1.9693220250E+00, 8.7106493528E-01],
	[2.4015000000E+04, 1.6888530373E+01, 5.2467349333E+00, 3.8790868176E+00, 1.9700585001E+00, 8.7112912314E-01],
	[2.4020000000E+04, 1.6894066331E+01, 5.2466795734E+00, 3.8816808379E+00, 1.9707948998E+00, 8.7119327900E-01],
	[2.4025000000E+04, 1.6899602952E+01, 5.2466242256E+00, 3.8842760501E+00, 1.9715312241E+00, 8.7125740286E-01],
	[2.4030000000E+04, 1.6905140234E+01, 5.2465688899E+00, 3.8868724547E+00, 1.9722674729E+00, 8.7132149473E-01],
	[2.4035000000E+04, 1.6910678178E+01, 5.2465135663E+00, 3.8894700520E+00, 1.9730036461E+00, 8.7138555464E-01],
	[2.4040000000E+04, 1.6916216784E+01, 5.2464582548E+00, 3.8920688422E+00, 1.9737397435E+00, 8.7144958258E-01],
	[2.4045000000E+04, 1.6921756051E+01, 5.2464029554E+00, 3.8946688256E+00, 1.9744757649E+00, 8.7151357858E-01],
	[2.4050000000E+04, 1.6927295980E+01, 5.2463476680E+00, 3.8972700025E+00, 1.9752117104E+00, 8.7157754265E-01],
	[2.4055000000E+04, 1.6932836571E+01, 5.2462923928E+00, 3.8998723733E+00, 1.9759475798E+00, 8.7164147480E-01],
	[2.4060000000E+04, 1.6938377822E+01, 5.2462371296E+00, 3.9024759382E+00, 1.9766833729E+00, 8.7170537504E-01],
	[2.4065000000E+04, 1.6943919736E+01, 5.2461818784E+00, 3.9050806975E+00, 1.9774190896E+00, 8.7176924339E-01],
	[2.4070000000E+04, 1.6949462310E+01, 5.2461266394E+00, 3.9076866516E+00, 1.9781547299E+00, 8.7183307986E-01],
	[2.4075000000E+04, 1.6955005546E+01, 5.2460714123E+00, 3.9102938007E+00, 1.9788902936E+00, 8.7189688447E-01],
	[2.4080000000E+04, 1.6960549443E+01, 5.2460161974E+00, 3.9129021450E+00, 1.9796257805E+00, 8.7196065722E-01],
	[2.4085000000E+04, 1.6966094001E+01, 5.2459609945E+00, 3.9155116850E+00, 1.9803611906E+00, 8.7202439814E-01],
	[2.4090000000E+04, 1.6971639220E+01, 5.2459058036E+00, 3.9181224210E+00, 1.9810965238E+00, 8.7208810722E-01],
	[2.4095000000E+04, 1.6977185100E+01, 5.2458506247E+00, 3.9207343531E+00, 1.9818317799E+00, 8.7215178450E-01],
	[2.4100000000E+04, 1.6982731642E+01, 5.2457954579E+00, 3.9233474817E+00, 1.9825669588E+00, 8.7221542998E-01],
	[2.4105000000E+04, 1.6988278844E+01, 5.2457403031E+00, 3.9259618072E+00, 1.9833020604E+00, 8.7227904367E-01],
	[2.4110000000E+04, 1.6993826707E+01, 5.2456851603E+00, 3.9285773297E+00, 1.9840370846E+00, 8.7234262559E-01],
	[2.4115000000E+04, 1.6999375230E+01, 5.2456300296E+00, 3.9311940497E+00, 1.9847720312E+00, 8.7240617575E-01],
	[2.4120000000E+04, 1.7004924415E+01, 5.2455749108E+00, 3.9338119673E+00, 1.9855069002E+00, 8.7246969416E-01],
	[2.4125000000E+04, 1.7010474260E+01, 5.2455198041E+00, 3.9364310830E+00, 1.9862416915E+00, 8.7253318084E-01],
	[2.4130000000E+04, 1.7016024766E+01, 5.2454647093E+00, 3.9390513969E+00, 1.9869764048E+00, 8.7259663580E-01],
	[2.4135000000E+04, 1.7021575932E+01, 5.2454096266E+00, 3.9416729095E+00, 1.9877110401E+00, 8.7266005906E-01],
	[2.4140000000E+04, 1.7027127759E+01, 5.2453545558E+00, 3.9442956209E+00, 1.9884455973E+00, 8.7272345062E-01],
	[2.4145000000E+04, 1.7032680246E+01, 5.2452994970E+00, 3.9469195316E+00, 1.9891800763E+00, 8.7278681050E-01],
	[2.4150000000E+04, 1.7038233393E+01, 5.2452444502E+00, 3.9495446417E+00, 1.9899144769E+00, 8.7285013872E-01],
	[2.4155000000E+04, 1.7043787201E+01, 5.2451894154E+00, 3.9521709517E+00, 1.9906487990E+00, 8.7291343527E-01],
	[2.4160000000E+04, 1.7049341670E+01, 5.2451343925E+00, 3.9547984617E+00, 1.9913830426E+00, 8.7297670013E-01],
	[2.4165000000E+04, 1.7054896798E+01, 5.2450793816E+00, 3.9574271721E+00, 1.9921172074E+00, 8.7303993330E-01],
	[2.4170000000E+04, 1.7060452587E+01, 5.2450243827E+00, 3.9600570832E+00, 1.9928512935E+00, 8.7310313478E-01],
	[2.4175000000E+04, 1.7066009035E+01, 5.2449693957E+00, 3.9626881953E+00, 1.9935853006E+00, 8.7316630460E-01],
	[2.4180000000E+04, 1.7071566144E+01, 5.2449144206E+00, 3.9653205086E+00, 1.9943192286E+00, 8.7322944277E-01],
	[2.4185000000E+04, 1.7077123913E+01, 5.2448594575E+00, 3.9679540236E+00, 1.9950530775E+00, 8.7329254930E-01],
	[2.4190000000E+04, 1.7082682341E+01, 5.2448045064E+00, 3.9705887404E+00, 1.9957868471E+00, 8.7335562420E-01],
	[2.4195000000E+04, 1.7088241430E+01, 5.2447495671E+00, 3.9732246594E+00, 1.9965205373E+00, 8.7341866748E-01],
	[2.4200000000E+04, 1.7093801178E+01, 5.2446946398E+00, 3.9758617808E+00, 1.9972541479E+00, 8.7348167916E-01],
	[2.4205000000E+04, 1.7099361586E+01, 5.2446397244E+00, 3.9785001051E+00, 1.9979876790E+00, 8.7354465925E-01],
	[2.4210000000E+04, 1.7104922653E+01, 5.2445848210E+00, 3.9811396324E+00, 1.9987211303E+00, 8.7360760777E-01],
	[2.4215000000E+04, 1.7110484381E+01, 5.2445299294E+00, 3.9837803631E+00, 1.9994545018E+00, 8.7367052473E-01],
	[2.4220000000E+04, 1.7116046768E+01, 5.2444750498E+00, 3.9864222974E+00, 2.0001877933E+00, 8.7373341013E-01],
	[2.4225000000E+04, 1.7121609814E+01, 5.2444201820E+00, 3.9890654358E+00, 2.0009210047E+00, 8.7379626399E-01],
	[2.4230000000E+04, 1.7127173520E+01, 5.2443653262E+00, 3.9917097784E+00, 2.0016541359E+00, 8.7385908634E-01],
	[2.4235000000E+04, 1.7132737885E+01, 5.2443104822E+00, 3.9943553255E+00, 2.0023871867E+00, 8.7392187717E-01],
	[2.4240000000E+04, 1.7138302910E+01, 5.2442556502E+00, 3.9970020775E+00, 2.0031201572E+00, 8.7398463650E-01],
	[2.4245000000E+04, 1.7143868593E+01, 5.2442008300E+00, 3.9996500347E+00, 2.0038530471E+00, 8.7404736434E-01],
	[2.4250000000E+04, 1.7149434936E+01, 5.2441460217E+00, 4.0022991973E+00, 2.0045858563E+00, 8.7411006072E-01],
	[2.4255000000E+04, 1.7155001939E+01, 5.2440912253E+00, 4.0049495657E+00, 2.0053185848E+00, 8.7417272563E-01],
	[2.4260000000E+04, 1.7160569600E+01, 5.2440364407E+00, 4.0076011402E+00, 2.0060512324E+00, 8.7423535910E-01],
	[2.4265000000E+04, 1.7166137920E+01, 5.2439816680E+00, 4.0102539210E+00, 2.0067837990E+00, 8.7429796113E-01],
	[2.4270000000E+04, 1.7171706900E+01, 5.2439269071E+00, 4.0129079085E+00, 2.0075162844E+00, 8.7436053174E-01],
	[2.4275000000E+04, 1.7177276538E+01, 5.2438721581E+00, 4.0155631029E+00, 2.0082486887E+00, 8.7442307094E-01],
	[2.4280000000E+04, 1.7182846835E+01, 5.2438174210E+00, 4.0182195046E+00, 2.0089810116E+00, 8.7448557875E-01],
	[2.4285000000E+04, 1.7188417791E+01, 5.2437626957E+00, 4.0208771138E+00, 2.0097132530E+00, 8.7454805518E-01],
	[2.4290000000E+04, 1.7193989406E+01, 5.2437079822E+00, 4.0235359308E+00, 2.0104454129E+00, 8.7461050024E-01],
	[2.4295000000E+04, 1.7199561679E+01, 5.2436532806E+00, 4.0261959561E+00, 2.0111774911E+00, 8.7467291394E-01],
	[2.4300000000E+04, 1.7205134611E+01, 5.2435985908E+00, 4.0288571897E+00, 2.0119094875E+00, 8.7473529630E-01],
	[2.4305000000E+04, 1.7210730148E+01, 5.2435473616E+00, 4.0315196321E+00, 2.0126422102E+00, 8.7479764732E-01],
	[2.4310000000E+04, 1.7216329264E+01, 5.2434966008E+00, 4.0341832836E+00, 2.0133749589E+00, 8.7485996704E-01],
	[2.4315000000E+04, 1.7221929049E+01, 5.2434458510E+00, 4.0368481443E+00, 2.0141076265E+00, 8.7492225544E-01],
	[2.4320000000E+04, 1.7227529504E+01, 5.2433951120E+00, 4.0395142148E+00, 2.0148402127E+00, 8.7498451256E-01],
	[2.4325000000E+04, 1.7233130628E+01, 5.2433443840E+00, 4.0421814951E+00, 2.0155727175E+00, 8.7504673840E-01],
	[2.4330000000E+04, 1.7238732422E+01, 5.2432936670E+00, 4.0448499857E+00, 2.0163051408E+00, 8.7510893297E-01],
	[2.4335000000E+04, 1.7244334885E+01, 5.2432429608E+00, 4.0475196869E+00, 2.0170374825E+00, 8.7517109630E-01],
	[2.4340000000E+04, 1.7249938017E+01, 5.2431922655E+00, 4.0501905988E+00, 2.0177697423E+00, 8.7523322838E-01],
	[2.4345000000E+04, 1.7255541818E+01, 5.2431415812E+00, 4.0528627220E+00, 2.0185019203E+00, 8.7529532924E-01],
	[2.4350000000E+04, 1.7261146288E+01, 5.2430909077E+00, 4.0555360565E+00, 2.0192340163E+00, 8.7535739888E-01],
	[2.4355000000E+04, 1.7266751428E+01, 5.2430402452E+00, 4.0582106028E+00, 2.0199660303E+00, 8.7541943733E-01],
	[2.4360000000E+04, 1.7272357236E+01, 5.2429895935E+00, 4.0608863611E+00, 2.0206979620E+00, 8.7548144459E-01],
	[2.4365000000E+04, 1.7277963713E+01, 5.2429389527E+00, 4.0635633317E+00, 2.0214298114E+00, 8.7554342067E-01],
	[2.4370000000E+04, 1.7283570859E+01, 5.2428883228E+00, 4.0662415149E+00, 2.0221615783E+00, 8.7560536560E-01],
	[2.4375000000E+04, 1.7289178674E+01, 5.2428377037E+00, 4.0689209111E+00, 2.0228932627E+00, 8.7566727938E-01],
	[2.4380000000E+04, 1.7294787158E+01, 5.2427870956E+00, 4.0716015205E+00, 2.0236248645E+00, 8.7572916202E-01],
	[2.4385000000E+04, 1.7300396310E+01, 5.2427364983E+00, 4.0742833435E+00, 2.0243563835E+00, 8.7579101354E-01],
	[2.4390000000E+04, 1.7306006131E+01, 5.2426859118E+00, 4.0769663802E+00, 2.0250878196E+00, 8.7585283396E-01],
	[2.4395000000E+04, 1.7311616621E+01, 5.2426353363E+00, 4.0796506311E+00, 2.0258191727E+00, 8.7591462328E-01],
	[2.4400000000E+04, 1.7317227779E+01, 5.2425847715E+00, 4.0823360964E+00, 2.0265504427E+00, 8.7597638152E-01],
	[2.4405000000E+04, 1.7322839605E+01, 5.2425342177E+00, 4.0850227764E+00, 2.0272816295E+00, 8.7603810868E-01],
	[2.4410000000E+04, 1.7328452100E+01, 5.2424836746E+00, 4.0877106714E+00, 2.0280127330E+00, 8.7609980480E-01],
	[2.4415000000E+04, 1.7334065263E+01, 5.2424331424E+00, 4.0903997818E+00, 2.0287437531E+00, 8.7616146987E-01],
	[2.4420000000E+04, 1.7339679095E+01, 5.2423826211E+00, 4.0930901077E+00, 2.0294746896E+00, 8.7622310391E-01],
	[2.4425000000E+04, 1.7345293595E+01, 5.2423321105E+00, 4.0957816496E+00, 2.0302055425E+00, 8.7628470694E-01],
	[2.4430000000E+04, 1.7350908763E+01, 5.2422816108E+00, 4.0984744077E+00, 2.0309363116E+00, 8.7634627896E-01],
	[2.4435000000E+04, 1.7356524599E+01, 5.2422311219E+00, 4.1011683823E+00, 2.0316669968E+00, 8.7640782000E-01],
	[2.4440000000E+04, 1.7362141103E+01, 5.2421806439E+00, 4.1038635737E+00, 2.0323975980E+00, 8.7646933005E-01],
	[2.4445000000E+04, 1.7367758275E+01, 5.2421301766E+00, 4.1065599822E+00, 2.0331281152E+00, 8.7653080915E-01],
	[2.4450000000E+04, 1.7373376115E+01, 5.2420797202E+00, 4.1092576082E+00, 2.0338585481E+00, 8.7659225729E-01],
	[2.4455000000E+04, 1.7378994623E+01, 5.2420292745E+00, 4.1119564518E+00, 2.0345888967E+00, 8.7665367450E-01],
	[2.4460000000E+04, 1.7384613798E+01, 5.2419788397E+00, 4.1146565134E+00, 2.0353191609E+00, 8.7671506078E-01],
	[2.4465000000E+04, 1.7390233642E+01, 5.2419284156E+00, 4.1173577934E+00, 2.0360493406E+00, 8.7677641615E-01],
	[2.4470000000E+04, 1.7395854153E+01, 5.2418780024E+00, 4.1200602919E+00, 2.0367794356E+00, 8.7683774063E-01],
	[2.4475000000E+04, 1.7401475332E+01, 5.2418275999E+00, 4.1227640094E+00, 2.0375094459E+00, 8.7689903422E-01],
	[2.4480000000E+04, 1.7407097179E+01, 5.2417772082E+00, 4.1254689461E+00, 2.0382393713E+00, 8.7696029693E-01],
	[2.4485000000E+04, 1.7412719693E+01, 5.2417268272E+00, 4.1281751022E+00, 2.0389692118E+00, 8.7702152879E-01],
	[2.4490000000E+04, 1.7418342874E+01, 5.2416764571E+00, 4.1308824782E+00, 2.0396989671E+00, 8.7708272981E-01],
	[2.4495000000E+04, 1.7423966723E+01, 5.2416260977E+00, 4.1335910743E+00, 2.0404286373E+00, 8.7714389999E-01],
	[2.4500000000E+04, 1.7429591239E+01, 5.2415757491E+00, 4.1363008907E+00, 2.0411582222E+00, 8.7720503936E-01],
	[2.4505000000E+04, 1.7435216423E+01, 5.2415254112E+00, 4.1390119279E+00, 2.0418877217E+00, 8.7726614792E-01],
	[2.4510000000E+04, 1.7440842274E+01, 5.2414750841E+00, 4.1417241861E+00, 2.0426171356E+00, 8.7732722569E-01],
	[2.4515000000E+04, 1.7446468792E+01, 5.2414247677E+00, 4.1444376655E+00, 2.0433464640E+00, 8.7738827268E-01],
	[2.4520000000E+04, 1.7452095977E+01, 5.2413744621E+00, 4.1471523666E+00, 2.0440757066E+00, 8.7744928890E-01],
	[2.4525000000E+04, 1.7457723830E+01, 5.2413241672E+00, 4.1498682895E+00, 2.0448048633E+00, 8.7751027438E-01],
	[2.4530000000E+04, 1.7463352349E+01, 5.2412738831E+00, 4.1525854347E+00, 2.0455339342E+00, 8.7757122911E-01],
	[2.4535000000E+04, 1.7468981535E+01, 5.2412236097E+00, 4.1553038023E+00, 2.0462629189E+00, 8.7763215312E-01],
	[2.4540000000E+04, 1.7474611389E+01, 5.2411733470E+00, 4.1580233927E+00, 2.0469918175E+00, 8.7769304641E-01],
	[2.4545000000E+04, 1.7480241909E+01, 5.2411230950E+00, 4.1607442062E+00, 2.0477206299E+00, 8.7775390901E-01],
	[2.4550000000E+04, 1.7485873096E+01, 5.2410728537E+00, 4.1634662431E+00, 2.0484493558E+00, 8.7781474092E-01],
	[2.4555000000E+04, 1.7491504949E+01, 5.2410226232E+00, 4.1661895037E+00, 2.0491779953E+00, 8.7787554216E-01],
	[2.4560000000E+04, 1.7497137470E+01, 5.2409724034E+00, 4.1689139883E+00, 2.0499065482E+00, 8.7793631273E-01],
	[2.4565000000E+04, 1.7502770656E+01, 5.2409221943E+00, 4.1716396972E+00, 2.0506350143E+00, 8.7799705267E-01],
	[2.4570000000E+04, 1.7508404510E+01, 5.2408719958E+00, 4.1743666306E+00, 2.0513633937E+00, 8.7805776197E-01],
	[2.4575000000E+04, 1.7514039030E+01, 5.2408218081E+00, 4.1770947890E+00, 2.0520916861E+00, 8.7811844065E-01],
	[2.4580000000E+04, 1.7519674217E+01, 5.2407716311E+00, 4.1798241725E+00, 2.0528198916E+00, 8.7817908872E-01],
	[2.4585000000E+04, 1.7525310069E+01, 5.2407214647E+00, 4.1825547815E+00, 2.0535480099E+00, 8.7823970620E-01],
	[2.4590000000E+04, 1.7530946589E+01, 5.2406713090E+00, 4.1852866163E+00, 2.0542760409E+00, 8.7830029310E-01],
	[2.4595000000E+04, 1.7536583774E+01, 5.2406211640E+00, 4.1880196772E+00, 2.0550039846E+00, 8.7836084943E-01],
	[2.4600000000E+04, 1.7542221626E+01, 5.2405710297E+00, 4.1907539645E+00, 2.0557318409E+00, 8.7842137521E-01],
	[2.4605000000E+04, 1.7547860144E+01, 5.2405209061E+00, 4.1934894785E+00, 2.0564596096E+00, 8.7848187046E-01],
	[2.4610000000E+04, 1.7553499328E+01, 5.2404707931E+00, 4.1962262194E+00, 2.0571872906E+00, 8.7854233517E-01],
	[2.4615000000E+04, 1.7559139178E+01, 5.2404206907E+00, 4.1989641876E+00, 2.0579148839E+00, 8.7860276937E-01],
	[2.4620000000E+04, 1.7564779694E+01, 5.2403705991E+00, 4.2017033834E+00, 2.0586423893E+00, 8.7866317308E-01],
	[2.4625000000E+04, 1.7570420877E+01, 5.2403205180E+00, 4.2044438071E+00, 2.0593698067E+00, 8.7872354629E-01],
	[2.4630000000E+04, 1.7576062725E+01, 5.2402704477E+00, 4.2071854589E+00, 2.0600971360E+00, 8.7878388903E-01],
	[2.4635000000E+04, 1.7581705238E+01, 5.2402203879E+00, 4.2099283392E+00, 2.0608243772E+00, 8.7884420132E-01],
	[2.4640000000E+04, 1.7587348418E+01, 5.2401703388E+00, 4.2126724483E+00, 2.0615515300E+00, 8.7890448315E-01],
	[2.4645000000E+04, 1.7592992263E+01, 5.2401203003E+00, 4.2154177865E+00, 2.0622785944E+00, 8.7896473455E-01],
	[2.4650000000E+04, 1.7598636774E+01, 5.2400702725E+00, 4.2181643541E+00, 2.0630055703E+00, 8.7902495554E-01],
	[2.4655000000E+04, 1.7604281951E+01, 5.2400202553E+00, 4.2209121513E+00, 2.0637324576E+00, 8.7908514611E-01],
	[2.4660000000E+04, 1.7609927793E+01, 5.2399702487E+00, 4.2236611785E+00, 2.0644592562E+00, 8.7914530630E-01],
	[2.4665000000E+04, 1.7615574301E+01, 5.2399202527E+00, 4.2264114360E+00, 2.0651859660E+00, 8.7920543610E-01],
	[2.4670000000E+04, 1.7621221474E+01, 5.2398702673E+00, 4.2291629241E+00, 2.0659125868E+00, 8.7926553554E-01],
	[2.4675000000E+04, 1.7626869312E+01, 5.2398202926E+00, 4.2319156430E+00, 2.0666391186E+00, 8.7932560462E-01],
	[2.4680000000E+04, 1.7632517816E+01, 5.2397703284E+00, 4.2346695931E+00, 2.0673655612E+00, 8.7938564337E-01],
	[2.4685000000E+04, 1.7638166985E+01, 5.2397203749E+00, 4.2374247747E+00, 2.0680919146E+00, 8.7944565179E-01],
	[2.4690000000E+04, 1.7643816820E+01, 5.2396704319E+00, 4.2401811880E+00, 2.0688181787E+00, 8.7950562989E-01],
	[2.4695000000E+04, 1.7649483345E+01, 5.2396229707E+00, 4.2429388335E+00, 2.0695449591E+00, 8.7956557770E-01],
	[2.4700000000E+04, 1.7655159495E+01, 5.2395768996E+00, 4.2456977113E+00, 2.0702719892E+00, 8.7962549522E-01],
	[2.4705000000E+04, 1.7660836322E+01, 5.2395308382E+00, 4.2484578217E+00, 2.0709989305E+00, 8.7968538247E-01],
	[2.4710000000E+04, 1.7666513824E+01, 5.2394847865E+00, 4.2512191652E+00, 2.0717257829E+00, 8.7974523945E-01],
	[2.4715000000E+04, 1.7672192002E+01, 5.2394387446E+00, 4.2539817419E+00, 2.0724525465E+00, 8.7980506620E-01],
	[2.4720000000E+04, 1.7677870856E+01, 5.2393927124E+00, 4.2567455521E+00, 2.0731792209E+00, 8.7986486271E-01],
	[2.4725000000E+04, 1.7683550386E+01, 5.2393466899E+00, 4.2595105963E+00, 2.0739058062E+00, 8.7992462900E-01],
	[2.4730000000E+04, 1.7689230592E+01, 5.2393006771E+00, 4.2622768746E+00, 2.0746323023E+00, 8.7998436508E-01],
	[2.4735000000E+04, 1.7694911473E+01, 5.2392546740E+00, 4.2650443874E+00, 2.0753587090E+00, 8.8004407097E-01],
	[2.4740000000E+04, 1.7700593030E+01, 5.2392086807E+00, 4.2678131349E+00, 2.0760850262E+00, 8.8010374669E-01],
	[2.4745000000E+04, 1.7706275262E+01, 5.2391626970E+00, 4.2705831175E+00, 2.0768112539E+00, 8.8016339223E-01],
	[2.4750000000E+04, 1.7711958170E+01, 5.2391167230E+00, 4.2733543355E+00, 2.0775373918E+00, 8.8022300763E-01],
	[2.4755000000E+04, 1.7717641754E+01, 5.2390707587E+00, 4.2761267891E+00, 2.0782634400E+00, 8.8028259289E-01],
	[2.4760000000E+04, 1.7723326013E+01, 5.2390248041E+00, 4.2789004788E+00, 2.0789893984E+00, 8.8034214802E-01],
	[2.4765000000E+04, 1.7729010947E+01, 5.2389788592E+00, 4.2816754046E+00, 2.0797152667E+00, 8.8040167304E-01],
	[2.4770000000E+04, 1.7734696556E+01, 5.2389329239E+00, 4.2844515671E+00, 2.0804410449E+00, 8.8046116796E-01],
	[2.4775000000E+04, 1.7740382841E+01, 5.2388869984E+00, 4.2872289664E+00, 2.0811667330E+00, 8.8052063280E-01],
	[2.4780000000E+04, 1.7746069801E+01, 5.2388410824E+00, 4.2900076029E+00, 2.0818923307E+00, 8.8058006756E-01],
	[2.4785000000E+04, 1.7751757436E+01, 5.2387951762E+00, 4.2927874768E+00, 2.0826178381E+00, 8.8063947227E-01],
	[2.4790000000E+04, 1.7757445746E+01, 5.2387492796E+00, 4.2955685885E+00, 2.0833432550E+00, 8.8069884693E-01],
	[2.4795000000E+04, 1.7763134731E+01, 5.2387033927E+00, 4.2983509383E+00, 2.0840685812E+00, 8.8075819156E-01],
	[2.4800000000E+04, 1.7768824391E+01, 5.2386575155E+00, 4.3011345264E+00, 2.0847938168E+00, 8.8081750618E-01],
	[2.4805000000E+04, 1.7774514726E+01, 5.2386116478E+00, 4.3039193532E+00, 2.0855189615E+00, 8.8087679078E-01],
	[2.4810000000E+04, 1.7780205736E+01, 5.2385657899E+00, 4.3067054189E+00, 2.0862440154E+00, 8.8093604540E-01],
	[2.4815000000E+04, 1.7785897420E+01, 5.2385199415E+00, 4.3094927240E+00, 2.0869689782E+00, 8.8099527004E-01],
	[2.4820000000E+04, 1.7791589779E+01, 5.2384741029E+00, 4.3122812685E+00, 2.0876938499E+00, 8.8105446472E-01],
	[2.4825000000E+04, 1.7797282813E+01, 5.2384282738E+00, 4.3150710530E+00, 2.0884186304E+00, 8.8111362945E-01],
	[2.4830000000E+04, 1.7802976522E+01, 5.2383824544E+00, 4.3178620776E+00, 2.0891433196E+00, 8.8117276424E-01],
	[2.4835000000E+04, 1.7808670905E+01, 5.2383366446E+00, 4.3206543427E+00, 2.0898679174E+00, 8.8123186910E-01],
	[2.4840000000E+04, 1.7814365963E+01, 5.2382908444E+00, 4.3234478485E+00, 2.0905924237E+00, 8.8129094406E-01],
	[2.4845000000E+04, 1.7820061695E+01, 5.2382450539E+00, 4.3262425954E+00, 2.0913168383E+00, 8.8134998912E-01],
	[2.4850000000E+04, 1.7825758101E+01, 5.2381992729E+00, 4.3290385837E+00, 2.0920411612E+00, 8.8140900430E-01],
	[2.4855000000E+04, 1.7831455182E+01, 5.2381535016E+00, 4.3318358136E+00, 2.0927653923E+00, 8.8146798960E-01],
	[2.4860000000E+04, 1.7837152937E+01, 5.2381077399E+00, 4.3346342855E+00, 2.0934895314E+00, 8.8152694505E-01],
	[2.4865000000E+04, 1.7842851366E+01, 5.2380619877E+00, 4.3374339996E+00, 2.0942135786E+00, 8.8158587066E-01],
	[2.4870000000E+04, 1.7848550470E+01, 5.2380162452E+00, 4.3402349563E+00, 2.0949375336E+00, 8.8164476644E-01],
	[2.4875000000E+04, 1.7854250247E+01, 5.2379705123E+00, 4.3430371559E+00, 2.0956613964E+00, 8.8170363240E-01],
	[2.4880000000E+04, 1.7859950699E+01, 5.2379247890E+00, 4.3458405986E+00, 2.0963851668E+00, 8.8176246857E-01],
	[2.4885000000E+04, 1.7865651825E+01, 5.2378790752E+00, 4.3486452848E+00, 2.0971088448E+00, 8.8182127494E-01],
	[2.4890000000E+04, 1.7871353624E+01, 5.2378333710E+00, 4.3514512147E+00, 2.0978324303E+00, 8.8188005154E-01],
	[2.4895000000E+04, 1.7877056098E+01, 5.2377876765E+00, 4.3542583888E+00, 2.0985559232E+00, 8.8193879837E-01],
	[2.4900000000E+04, 1.7882759245E+01, 5.2377419914E+00, 4.3570668071E+00, 2.0992793233E+00, 8.8199751546E-01],
	[2.4905000000E+04, 1.7888463066E+01, 5.2376963160E+00, 4.3598764702E+00, 2.1000026306E+00, 8.8205620281E-01],
	[2.4910000000E+04, 1.7894167561E+01, 5.2376506501E+00, 4.3626873782E+00, 2.1007258450E+00, 8.8211486045E-01],
	[2.4915000000E+04, 1.7899872729E+01, 5.2376049938E+00, 4.3654995314E+00, 2.1014489664E+00, 8.8217348837E-01],
	[2.4920000000E+04, 1.7905578571E+01, 5.2375593471E+00, 4.3683129302E+00, 2.1021719946E+00, 8.8223208660E-01],
	[2.4925000000E+04, 1.7911285087E+01, 5.2375137099E+00, 4.3711275749E+00, 2.1028949296E+00, 8.8229065515E-01],
	[2.4930000000E+04, 1.7916992276E+01, 5.2374680822E+00, 4.3739434657E+00, 2.1036177712E+00, 8.8234919404E-01],
	[2.4935000000E+04, 1.7922700139E+01, 5.2374224641E+00, 4.3767606030E+00, 2.1043405194E+00, 8.8240770327E-01],
	[2.4940000000E+04, 1.7928408674E+01, 5.2373768556E+00, 4.3795789871E+00, 2.1050631741E+00, 8.8246618286E-01],
	[2.4945000000E+04, 1.7934117884E+01, 5.2373312566E+00, 4.3823986182E+00, 2.1057857352E+00, 8.8252463282E-01],
	[2.4950000000E+04, 1.7939827766E+01, 5.2372856671E+00, 4.3852194967E+00, 2.1065082025E+00, 8.8258305317E-01],
	[2.4955000000E+04, 1.7945538322E+01, 5.2372400871E+00, 4.3880416229E+00, 2.1072305761E+00, 8.8264144392E-01],
	[2.4960000000E+04, 1.7951249551E+01, 5.2371945167E+00, 4.3908649970E+00, 2.1079528557E+00, 8.8269980509E-01],
	[2.4965000000E+04, 1.7956961453E+01, 5.2371489558E+00, 4.3936896193E+00, 2.1086750412E+00, 8.8275813668E-01],
	[2.4970000000E+04, 1.7962674028E+01, 5.2371034044E+00, 4.3965154903E+00, 2.1093971327E+00, 8.8281643872E-01],
	[2.4975000000E+04, 1.7968387276E+01, 5.2370578626E+00, 4.3993426101E+00, 2.1101191299E+00, 8.8287471120E-01],
	[2.4980000000E+04, 1.7974101197E+01, 5.2370123302E+00, 4.4021709790E+00, 2.1108410328E+00, 8.8293295416E-01],
	[2.4985000000E+04, 1.7979815791E+01, 5.2369668074E+00, 4.4050005975E+00, 2.1115628413E+00, 8.8299116760E-01],
	[2.4990000000E+04, 1.7985531058E+01, 5.2369212941E+00, 4.4078314656E+00, 2.1122845552E+00, 8.8304935154E-01],
	[2.4995000000E+04, 1.7991246998E+01, 5.2368757902E+00, 4.4106635839E+00, 2.1130061746E+00, 8.8310750598E-01],
	[2.5000000000E+04, 1.7996963610E+01, 5.2368302959E+00, 4.4134969525E+00, 2.1137276992E+00, 8.8316563095E-01],
	[2.5005000000E+04, 1.8002680895E+01, 5.2367848111E+00, 4.4163414308E+00, 2.1144513890E+00, 8.8322372645E-01],
	[2.5010000000E+04, 1.8008398852E+01, 5.2367393357E+00, 4.4191871711E+00, 2.1151749838E+00, 8.8328179251E-01],
	[2.5015000000E+04, 1.8014117483E+01, 5.2366938699E+00, 4.4220341737E+00, 2.1158984832E+00, 8.8333982912E-01],
	[2.5020000000E+04, 1.8019836785E+01, 5.2366484135E+00, 4.4248824389E+00, 2.1166218874E+00, 8.8339783631E-01],
	[2.5025000000E+04, 1.8025556760E+01, 5.2366029666E+00, 4.4277319669E+00, 2.1173451962E+00, 8.8345581410E-01],
	[2.5030000000E+04, 1.8031277408E+01, 5.2365575291E+00, 4.4305827581E+00, 2.1180684095E+00, 8.8351376249E-01],
	[2.5035000000E+04, 1.8036998727E+01, 5.2365121012E+00, 4.4334348128E+00, 2.1187915271E+00, 8.8357168149E-01],
	[2.5040000000E+04, 1.8042720719E+01, 5.2364666827E+00, 4.4362881314E+00, 2.1195145491E+00, 8.8362957113E-01],
	[2.5045000000E+04, 1.8048443384E+01, 5.2364212736E+00, 4.4391427140E+00, 2.1202374752E+00, 8.8368743141E-01],
	[2.5050000000E+04, 1.8054166720E+01, 5.2363758741E+00, 4.4419985611E+00, 2.1209603055E+00, 8.8374526235E-01],
	[2.5055000000E+04, 1.8059890729E+01, 5.2363304839E+00, 4.4448556728E+00, 2.1216830397E+00, 8.8380306396E-01],
	[2.5060000000E+04, 1.8065615409E+01, 5.2362851033E+00, 4.4477140496E+00, 2.1224056779E+00, 8.8386083625E-01],
	[2.5065000000E+04, 1.8071340762E+01, 5.2362397320E+00, 4.4505736918E+00, 2.1231282198E+00, 8.8391857925E-01],
	[2.5070000000E+04, 1.8077066787E+01, 5.2361943703E+00, 4.4534345996E+00, 2.1238506655E+00, 8.8397629296E-01],
	[2.5075000000E+04, 1.8082793483E+01, 5.2361490179E+00, 4.4562967733E+00, 2.1245730147E+00, 8.8403397739E-01],
	[2.5080000000E+04, 1.8088520851E+01, 5.2361036750E+00, 4.4591602132E+00, 2.1252952675E+00, 8.8409163256E-01],
	[2.5085000000E+04, 1.8094248891E+01, 5.2360583415E+00, 4.4620249198E+00, 2.1260174237E+00, 8.8414925849E-01],
	[2.5090000000E+04, 1.8099981125E+01, 5.2360135513E+00, 4.4648908932E+00, 2.1267396199E+00, 8.8420685519E-01],
	[2.5095000000E+04, 1.8105735527E+01, 5.2359720282E+00, 4.4677581337E+00, 2.1274625540E+00, 8.8426442266E-01],
	[2.5100000000E+04, 1.8111490612E+01, 5.2359305136E+00, 4.4706266418E+00, 2.1281853922E+00, 8.8432196093E-01],
	[2.5105000000E+04, 1.8117246379E+01, 5.2358890077E+00, 4.4734964176E+00, 2.1289081344E+00, 8.8437947001E-01],
	[2.5110000000E+04, 1.8123002828E+01, 5.2358475104E+00, 4.4763674615E+00, 2.1296307804E+00, 8.8443694990E-01],
	[2.5115000000E+04, 1.8128759960E+01, 5.2358060216E+00, 4.4792397739E+00, 2.1303533301E+00, 8.8449440064E-01],
	[2.5120000000E+04, 1.8134517775E+01, 5.2357645414E+00, 4.4821133549E+00, 2.1310757835E+00, 8.8455182222E-01],
	[2.5125000000E+04, 1.8140276271E+01, 5.2357230699E+00, 4.4849882049E+00, 2.1317981404E+00, 8.8460921466E-01],
	[2.5130000000E+04, 1.8146035450E+01, 5.2356816069E+00, 4.4878643242E+00, 2.1325204008E+00, 8.8466657798E-01],
	[2.5135000000E+04, 1.8151795311E+01, 5.2356401524E+00, 4.4907417132E+00, 2.1332425646E+00, 8.8472391219E-01],
	[2.5140000000E+04, 1.8157555853E+01, 5.2355987066E+00, 4.4936203721E+00, 2.1339646316E+00, 8.8478121730E-01],
	[2.5145000000E+04, 1.8163317078E+01, 5.2355572693E+00, 4.4965003012E+00, 2.1346866018E+00, 8.8483849333E-01],
	[2.5150000000E+04, 1.8169078985E+01, 5.2355158406E+00, 4.4993815009E+00, 2.1354084750E+00, 8.8489574029E-01],
	[2.5155000000E+04, 1.8174841574E+01, 5.2354744204E+00, 4.5022639714E+00, 2.1361302512E+00, 8.8495295819E-01],
	[2.5160000000E+04, 1.8180604844E+01, 5.2354330088E+00, 4.5051477131E+00, 2.1368519303E+00, 8.8501014705E-01],
	[2.5165000000E+04, 1.8186368796E+01, 5.2353916058E+00, 4.5080327262E+00, 2.1375735122E+00, 8.8506730688E-01],
	[2.5170000000E+04, 1.8192133430E+01, 5.2353502113E+00, 4.5109190111E+00, 2.1382949968E+00, 8.8512443770E-01],
	[2.5175000000E+04, 1.8197898746E+01, 5.2353088254E+00, 4.5138065680E+00, 2.1390163840E+00, 8.8518153951E-01],
	[2.5180000000E+04, 1.8203664743E+01, 5.2352674480E+00, 4.5166953974E+00, 2.1397376736E+00, 8.8523861234E-01],
	[2.5185000000E+04, 1.8209431422E+01, 5.2352260792E+00, 4.5195854994E+00, 2.1404588657E+00, 8.8529565619E-01],
	[2.5190000000E+04, 1.8215198783E+01, 5.2351847189E+00, 4.5224768744E+00, 2.1411799600E+00, 8.8535267108E-01],
	[2.5195000000E+04, 1.8220966825E+01, 5.2351433671E+00, 4.5253695227E+00, 2.1419009566E+00, 8.8540965702E-01],
	[2.5200000000E+04, 1.8226735548E+01, 5.2351020239E+00, 4.5282634447E+00, 2.1426218553E+00, 8.8546661403E-01],
	[2.5205000000E+04, 1.8232504952E+01, 5.2350606892E+00, 4.5311586405E+00, 2.1433426560E+00, 8.8552354212E-01],
	[2.5210000000E+04, 1.8238275038E+01, 5.2350193630E+00, 4.5340551105E+00, 2.1440633586E+00, 8.8558044130E-01],
	[2.5215000000E+04, 1.8244045806E+01, 5.2349780453E+00, 4.5369528551E+00, 2.1447839631E+00, 8.8563731159E-01],
	[2.5220000000E+04, 1.8249817254E+01, 5.2349367362E+00, 4.5398518745E+00, 2.1455044693E+00, 8.8569415300E-01],
	[2.5225000000E+04, 1.8255589383E+01, 5.2348954355E+00, 4.5427521691E+00, 2.1462248771E+00, 8.8575096555E-01],
	[2.5230000000E+04, 1.8261362194E+01, 5.2348541434E+00, 4.5456537391E+00, 2.1469451865E+00, 8.8580774928E-01],
	[2.5235000000E+04, 1.8267135685E+01, 5.2348128598E+00, 4.5485565848E+00, 2.1476653973E+00, 8.8586450433E-01],
	[2.5240000000E+04, 1.8272909858E+01, 5.2347715847E+00, 4.5514607066E+00, 2.1483855095E+00, 8.8592123070E-01],
	[2.5245000000E+04, 1.8278684711E+01, 5.2347303181E+00, 4.5543661047E+00, 2.1491055229E+00, 8.8597792841E-01],
	[2.5250000000E+04, 1.8284460246E+01, 5.2346890600E+00, 4.5572727796E+00, 2.1498254376E+00, 8.8603459747E-01],
	[2.5255000000E+04, 1.8290236461E+01, 5.2346478104E+00, 4.5601807314E+00, 2.1505452532E+00, 8.8609123789E-01],
	[2.5260000000E+04, 1.8296013357E+01, 5.2346065693E+00, 4.5630899605E+00, 2.1512649699E+00, 8.8614784969E-01],
	[2.5265000000E+04, 1.8301790933E+01, 5.2345653366E+00, 4.5660004672E+00, 2.1519845875E+00, 8.8620443286E-01],
	[2.5270000000E+04, 1.8307569190E+01, 5.2345241125E+00, 4.5689122517E+00, 2.1527041058E+00, 8.8626098744E-01],
	[2.5275000000E+04, 1.8313348128E+01, 5.2344828968E+00, 4.5718253145E+00, 2.1534235248E+00, 8.8631751342E-01],
	[2.5280000000E+04, 1.8319127746E+01, 5.2344416896E+00, 4.5747396558E+00, 2.1541428445E+00, 8.8637401082E-01],
	[2.5285000000E+04, 1.8324908045E+01, 5.2344004909E+00, 4.5776552759E+00, 2.1548620647E+00, 8.8643047965E-01],
	[2.5290000000E+04, 1.8330689024E+01, 5.2343593007E+00, 4.5805721752E+00, 2.1555811852E+00, 8.8648691992E-01],
	[2.5295000000E+04, 1.8336470684E+01, 5.2343181189E+00, 4.5834903538E+00, 2.1563002061E+00, 8.8654333165E-01],
	[2.5300000000E+04, 1.8342253024E+01, 5.2342769456E+00, 4.5864098122E+00, 2.1570191273E+00, 8.8659971484E-01],
	[2.5305000000E+04, 1.8348036044E+01, 5.2342357807E+00, 4.5893305507E+00, 2.1577379485E+00, 8.8665606951E-01],
	[2.5310000000E+04, 1.8353819744E+01, 5.2341946243E+00, 4.5922525695E+00, 2.1584566699E+00, 8.8671239567E-01],
	[2.5315000000E+04, 1.8359604125E+01, 5.2341534764E+00, 4.5951758689E+00, 2.1591752911E+00, 8.8676869333E-01],
	[2.5320000000E+04, 1.8365389185E+01, 5.2341123369E+00, 4.5981004494E+00, 2.1598938123E+00, 8.8682496249E-01],
	[2.5325000000E+04, 1.8371174926E+01, 5.2340712058E+00, 4.6010263110E+00, 2.1606122332E+00, 8.8688120319E-01],
	[2.5330000000E+04, 1.8376961347E+01, 5.2340300832E+00, 4.6039534543E+00, 2.1613305538E+00, 8.8693741542E-01],
	[2.5335000000E+04, 1.8382748447E+01, 5.2339889690E+00, 4.6068818795E+00, 2.1620487739E+00, 8.8699359919E-01],
	[2.5340000000E+04, 1.8388536227E+01, 5.2339478633E+00, 4.6098115868E+00, 2.1627668936E+00, 8.8704975452E-01],
	[2.5345000000E+04, 1.8394324688E+01, 5.2339067660E+00, 4.6127425767E+00, 2.1634849126E+00, 8.8710588143E-01],
	[2.5350000000E+04, 1.8400113828E+01, 5.2338656771E+00, 4.6156748493E+00, 2.1642028310E+00, 8.8716197991E-01],
	[2.5355000000E+04, 1.8405903647E+01, 5.2338245967E+00, 4.6186084051E+00, 2.1649206486E+00, 8.8721804999E-01],
	[2.5360000000E+04, 1.8411694147E+01, 5.2337835247E+00, 4.6215432443E+00, 2.1656383653E+00, 8.8727409167E-01],
	[2.5365000000E+04, 1.8417485326E+01, 5.2337424611E+00, 4.6244793672E+00, 2.1663559810E+00, 8.8733010498E-01],
	[2.5370000000E+04, 1.8423277184E+01, 5.2337014059E+00, 4.6274167741E+00, 2.1670734957E+00, 8.8738608990E-01],
	[2.5375000000E+04, 1.8429069722E+01, 5.2336603591E+00, 4.6303554654E+00, 2.1677909092E+00, 8.8744204647E-01],
	[2.5380000000E+04, 1.8434862940E+01, 5.2336193207E+00, 4.6332954413E+00, 2.1685082215E+00, 8.8749797470E-01],
	[2.5385000000E+04, 1.8440656837E+01, 5.2335782908E+00, 4.6362367022E+00, 2.1692254324E+00, 8.8755387458E-01],
	[2.5390000000E+04, 1.8446451413E+01, 5.2335372692E+00, 4.6391792484E+00, 2.1699425419E+00, 8.8760974614E-01],
	[2.5395000000E+04, 1.8452246668E+01, 5.2334962560E+00, 4.6421230801E+00, 2.1706595499E+00, 8.8766558939E-01],
	[2.5400000000E+04, 1.8458042603E+01, 5.2334552513E+00, 4.6450681977E+00, 2.1713764563E+00, 8.8772140434E-01],
	[2.5405000000E+04, 1.8463839217E+01, 5.2334142549E+00, 4.6480146014E+00, 2.1720932610E+00, 8.8777719099E-01],
	[2.5410000000E+04, 1.8469636510E+01, 5.2333732669E+00, 4.6509622917E+00, 2.1728099639E+00, 8.8783294937E-01],
	[2.5415000000E+04, 1.8475434482E+01, 5.2333322873E+00, 4.6539112687E+00, 2.1735265650E+00, 8.8788867949E-01],
	[2.5420000000E+04, 1.8481233133E+01, 5.2332913161E+00, 4.6568615329E+00, 2.1742430640E+00, 8.8794438134E-01],
	[2.5425000000E+04, 1.8487032463E+01, 5.2332503533E+00, 4.6598130845E+00, 2.1749594610E+00, 8.8800005496E-01],
	[2.5430000000E+04, 1.8492832472E+01, 5.2332093988E+00, 4.6627659237E+00, 2.1756757559E+00, 8.8805570035E-01],
	[2.5435000000E+04, 1.8498633160E+01, 5.2331684527E+00, 4.6657200510E+00, 2.1763919485E+00, 8.8811131752E-01],
	[2.5440000000E+04, 1.8504434526E+01, 5.2331275150E+00, 4.6686754667E+00, 2.1771080387E+00, 8.8816690648E-01],
	[2.5445000000E+04, 1.8510236572E+01, 5.2330865857E+00, 4.6716321710E+00, 2.1778240266E+00, 8.8822246724E-01],
	[2.5450000000E+04, 1.8516039296E+01, 5.2330456647E+00, 4.6745901642E+00, 2.1785399119E+00, 8.8827799982E-01],
	[2.5455000000E+04, 1.8521842698E+01, 5.2330047520E+00, 4.6775494467E+00, 2.1792556947E+00, 8.8833350423E-01],
	[2.5460000000E+04, 1.8527646779E+01, 5.2329638478E+00, 4.6805100187E+00, 2.1799713747E+00, 8.8838898048E-01],
	[2.5465000000E+04, 1.8533451539E+01, 5.2329229518E+00, 4.6834718806E+00, 2.1806869520E+00, 8.8844442859E-01],
	[2.5470000000E+04, 1.8539256977E+01, 5.2328820643E+00, 4.6864350327E+00, 2.1814024264E+00, 8.8849984855E-01],
	[2.5475000000E+04, 1.8545063094E+01, 5.2328411850E+00, 4.6893994752E+00, 2.1821177978E+00, 8.8855524039E-01],
	[2.5480000000E+04, 1.8550869889E+01, 5.2328003141E+00, 4.6923652086E+00, 2.1828330662E+00, 8.8861060412E-01],
	[2.5485000000E+04, 1.8556677362E+01, 5.2327594516E+00, 4.6953322330E+00, 2.1835482315E+00, 8.8866593975E-01],
	[2.5490000000E+04, 1.8562485514E+01, 5.2327185974E+00, 4.6983005489E+00, 2.1842632935E+00, 8.8872124729E-01],
	[2.5495000000E+04, 1.8568303299E+01, 5.2326790916E+00, 4.7012701564E+00, 2.1849786099E+00, 8.8877652675E-01],
	[2.5500000000E+04, 1.8574137686E+01, 5.2326419752E+00, 4.7042410560E+00, 2.1856944591E+00, 8.8883177815E-01],
	[2.5505000000E+04, 1.8579972762E+01, 5.2326048664E+00, 4.7072132479E+00, 2.1864102058E+00, 8.8888700149E-01],
	[2.5510000000E+04, 1.8585808527E+01, 5.2325677651E+00, 4.7101867324E+00, 2.1871258498E+00, 8.8894219679E-01],
	[2.5515000000E+04, 1.8591644981E+01, 5.2325306713E+00, 4.7131615099E+00, 2.1878413909E+00, 8.8899736407E-01],
	[2.5520000000E+04, 1.8597482123E+01, 5.2324935850E+00, 4.7161375806E+00, 2.1885568293E+00, 8.8905250332E-01],
	[2.5525000000E+04, 1.8603319953E+01, 5.2324565063E+00, 4.7191149449E+00, 2.1892721647E+00, 8.8910761457E-01],
	[2.5530000000E+04, 1.8609158473E+01, 5.2324194352E+00, 4.7220936030E+00, 2.1899873970E+00, 8.8916269783E-01],
	[2.5535000000E+04, 1.8614997680E+01, 5.2323823715E+00, 4.7250735553E+00, 2.1907025262E+00, 8.8921775310E-01],
	[2.5540000000E+04, 1.8620837577E+01, 5.2323453153E+00, 4.7280548020E+00, 2.1914175522E+00, 8.8927278040E-01],
	[2.5545000000E+04, 1.8626678161E+01, 5.2323082667E+00, 4.7310373436E+00, 2.1921324749E+00, 8.8932777974E-01],
	[2.5550000000E+04, 1.8632519434E+01, 5.2322712256E+00, 4.7340211802E+00, 2.1928472943E+00, 8.8938275114E-01],
	[2.5555000000E+04, 1.8638361395E+01, 5.2322341920E+00, 4.7370063123E+00, 2.1935620101E+00, 8.8943769460E-01],
	[2.5560000000E+04, 1.8644204045E+01, 5.2321971659E+00, 4.7399927400E+00, 2.1942766224E+00, 8.8949261014E-01],
	[2.5565000000E+04, 1.8650047382E+01, 5.2321601473E+00, 4.7429804638E+00, 2.1949911310E+00, 8.8954749777E-01],
	[2.5570000000E+04, 1.8655891408E+01, 5.2321231362E+00, 4.7459694839E+00, 2.1957055359E+00, 8.8960235750E-01],
	[2.5575000000E+04, 1.8661736121E+01, 5.2320861326E+00, 4.7489598006E+00, 2.1964198369E+00, 8.8965718935E-01],
	[2.5580000000E+04, 1.8667581523E+01, 5.2320491365E+00, 4.7519514142E+00, 2.1971340341E+00, 8.8971199332E-01],
	[2.5585000000E+04, 1.8673427613E+01, 5.2320121479E+00, 4.7549443251E+00, 2.1978481272E+00, 8.8976676942E-01],
	[2.5590000000E+04, 1.8679274390E+01, 5.2319751668E+00, 4.7579385335E+00, 2.1985621163E+00, 8.8982151768E-01],
	[2.5595000000E+04, 1.8685121856E+01, 5.2319381932E+00, 4.7609340398E+00, 2.1992760012E+00, 8.8987623809E-01],
	[2.5600000000E+04, 1.8690970009E+01, 5.2319012270E+00, 4.7639308443E+00, 2.1999897818E+00, 8.8993093068E-01],
	[2.5605000000E+04, 1.8696818850E+01, 5.2318642684E+00, 4.7669289472E+00, 2.2007034580E+00, 8.8998559546E-01],
	[2.5610000000E+04, 1.8702668379E+01, 5.2318273172E+00, 4.7699283489E+00, 2.2014170299E+00, 8.9004023243E-01],
	[2.5615000000E+04, 1.8708518595E+01, 5.2317903735E+00, 4.7729290497E+00, 2.2021304972E+00, 8.9009484160E-01],
	[2.5620000000E+04, 1.8714369499E+01, 5.2317534372E+00, 4.7759310499E+00, 2.2028438599E+00, 8.9014942300E-01],
	[2.5625000000E+04, 1.8720221090E+01, 5.2317165085E+00, 4.7789343498E+00, 2.2035571179E+00, 8.9020397663E-01],
	[2.5630000000E+04, 1.8726073369E+01, 5.2316795871E+00, 4.7819389497E+00, 2.2042702711E+00, 8.9025850251E-01],
	[2.5635000000E+04, 1.8731926335E+01, 5.2316426733E+00, 4.7849448499E+00, 2.2049833195E+00, 8.9031300064E-01],
	[2.5640000000E+04, 1.8737779989E+01, 5.2316057669E+00, 4.7879520507E+00, 2.2056962629E+00, 8.9036747105E-01],
	[2.5645000000E+04, 1.8743634330E+01, 5.2315688680E+00, 4.7909605525E+00, 2.2064091012E+00, 8.9042191373E-01],
	[2.5650000000E+04, 1.8749489358E+01, 5.2315319765E+00, 4.7939703555E+00, 2.2071218344E+00, 8.9047632870E-01],
	[2.5655000000E+04, 1.8755345073E+01, 5.2314950925E+00, 4.7969814601E+00, 2.2078344625E+00, 8.9053071598E-01],
	[2.5660000000E+04, 1.8761201476E+01, 5.2314582159E+00, 4.7999938665E+00, 2.2085469852E+00, 8.9058507558E-01],
	[2.5665000000E+04, 1.8767058566E+01, 5.2314213468E+00, 4.8030075750E+00, 2.2092594025E+00, 8.9063940750E-01],
	[2.5670000000E+04, 1.8772916342E+01, 5.2313844851E+00, 4.8060225861E+00, 2.2099717144E+00, 8.9069371177E-01],
	[2.5675000000E+04, 1.8778774806E+01, 5.2313476308E+00, 4.8090388999E+00, 2.2106839207E+00, 8.9074798839E-01],
	[2.5680000000E+04, 1.8784633957E+01, 5.2313107840E+00, 4.8120565168E+00, 2.2113960214E+00, 8.9080223737E-01],
	[2.5685000000E+04, 1.8790493794E+01, 5.2312739446E+00, 4.8150754371E+00, 2.2121080163E+00, 8.9085645873E-01],
	[2.5690000000E+04, 1.8796354318E+01, 5.2312371127E+00, 4.8180956611E+00, 2.2128199055E+00, 8.9091065248E-01],
	[2.5695000000E+04, 1.8802215530E+01, 5.2312002881E+00, 4.8211171891E+00, 2.2135316887E+00, 8.9096481862E-01],
	[2.5700000000E+04, 1.8808077427E+01, 5.2311634710E+00, 4.8241400215E+00, 2.2142433660E+00, 8.9101895719E-01],
	[2.5705000000E+04, 1.8813940012E+01, 5.2311266614E+00, 4.8271641584E+00, 2.2149549372E+00, 8.9107306817E-01],
	[2.5710000000E+04, 1.8819803283E+01, 5.2310898591E+00, 4.8301896003E+00, 2.2156664023E+00, 8.9112715159E-01],
	[2.5715000000E+04, 1.8825667241E+01, 5.2310530643E+00, 4.8332163474E+00, 2.2163777611E+00, 8.9118120747E-01],
	[2.5720000000E+04, 1.8831531885E+01, 5.2310162768E+00, 4.8362444001E+00, 2.2170890136E+00, 8.9123523580E-01],
	[2.5725000000E+04, 1.8837397216E+01, 5.2309794968E+00, 4.8392737586E+00, 2.2178001597E+00, 8.9128923661E-01],
	[2.5730000000E+04, 1.8843263233E+01, 5.2309427242E+00, 4.8423044233E+00, 2.2185111993E+00, 8.9134320990E-01],
	[2.5735000000E+04, 1.8849129936E+01, 5.2309059590E+00, 4.8453363945E+00, 2.2192221324E+00, 8.9139715568E-01],
	[2.5740000000E+04, 1.8854997326E+01, 5.2308692011E+00, 4.8483696724E+00, 2.2199329588E+00, 8.9145107398E-01],
	[2.5745000000E+04, 1.8860865402E+01, 5.2308324507E+00, 4.8514042575E+00, 2.2206436784E+00, 8.9150496480E-01],
	[2.5750000000E+04, 1.8866734164E+01, 5.2307957077E+00, 4.8544401499E+00, 2.2213542913E+00, 8.9155882815E-01],
	[2.5755000000E+04, 1.8872603613E+01, 5.2307589721E+00, 4.8574773500E+00, 2.2220647972E+00, 8.9161266405E-01],
	[2.5760000000E+04, 1.8878473747E+01, 5.2307222438E+00, 4.8605158581E+00, 2.2227751961E+00, 8.9166647251E-01],
	[2.5765000000E+04, 1.8884344568E+01, 5.2306855230E+00, 4.8635556746E+00, 2.2234854880E+00, 8.9172025353E-01],
	[2.5770000000E+04, 1.8890216074E+01, 5.2306488095E+00, 4.8665967997E+00, 2.2241956727E+00, 8.9177400714E-01],
	[2.5775000000E+04, 1.8896088266E+01, 5.2306121034E+00, 4.8696392337E+00, 2.2249057502E+00, 8.9182773334E-01],
	[2.5780000000E+04, 1.8901961145E+01, 5.2305754047E+00, 4.8726829769E+00, 2.2256157203E+00, 8.9188143215E-01],
	[2.5785000000E+04, 1.8907834709E+01, 5.2305387134E+00, 4.8757280297E+00, 2.2263255831E+00, 8.9193510357E-01],
	[2.5790000000E+04, 1.8913708959E+01, 5.2305020294E+00, 4.8787743924E+00, 2.2270353383E+00, 8.9198874763E-01],
	[2.5795000000E+04, 1.8919583894E+01, 5.2304653528E+00, 4.8818220652E+00, 2.2277449860E+00, 8.9204236432E-01],
	[2.5800000000E+04, 1.8925459515E+01, 5.2304286836E+00, 4.8848710485E+00, 2.2284545260E+00, 8.9209595367E-01],
	[2.5805000000E+04, 1.8931335822E+01, 5.2303920217E+00, 4.8879213426E+00, 2.2291639583E+00, 8.9214951569E-01],
	[2.5810000000E+04, 1.8937212815E+01, 5.2303553672E+00, 4.8909729478E+00, 2.2298732828E+00, 8.9220305039E-01],
	[2.5815000000E+04, 1.8943090492E+01, 5.2303187200E+00, 4.8940258643E+00, 2.2305824994E+00, 8.9225655778E-01],
	[2.5820000000E+04, 1.8948968856E+01, 5.2302820802E+00, 4.8970800926E+00, 2.2312916080E+00, 8.9231003787E-01],
	[2.5825000000E+04, 1.8954847905E+01, 5.2302454478E+00, 4.9001356329E+00, 2.2320006085E+00, 8.9236349067E-01],
	[2.5830000000E+04, 1.8960727639E+01, 5.2302088227E+00, 4.9031924855E+00, 2.2327095008E+00, 8.9241691621E-01],
	[2.5835000000E+04, 1.8966608058E+01, 5.2301722049E+00, 4.9062506507E+00, 2.2334182850E+00, 8.9247031448E-01],
	[2.5840000000E+04, 1.8972489163E+01, 5.2301355945E+00, 4.9093101289E+00, 2.2341269608E+00, 8.9252368550E-01],
	[2.5845000000E+04, 1.8978370953E+01, 5.2300989914E+00, 4.9123709203E+00, 2.2348355282E+00, 8.9257702929E-01],
	[2.5850000000E+04, 1.8984253428E+01, 5.2300623957E+00, 4.9154330253E+00, 2.2355439872E+00, 8.9263034586E-01],
	[2.5855000000E+04, 1.8990136588E+01, 5.2300258073E+00, 4.9184964441E+00, 2.2362523376E+00, 8.9268363521E-01],
	[2.5860000000E+04, 1.8996020433E+01, 5.2299892262E+00, 4.9215611771E+00, 2.2369605793E+00, 8.9273689736E-01],
	[2.5865000000E+04, 1.9001904963E+01, 5.2299526525E+00, 4.9246272246E+00, 2.2376687124E+00, 8.9279013232E-01],
	[2.5870000000E+04, 1.9007790178E+01, 5.2299160860E+00, 4.9276945868E+00, 2.2383767366E+00, 8.9284334011E-01],
	[2.5875000000E+04, 1.9013676078E+01, 5.2298795269E+00, 4.9307632642E+00, 2.2390846520E+00, 8.9289652074E-01],
	[2.5880000000E+04, 1.9019562662E+01, 5.2298429752E+00, 4.9338332570E+00, 2.2397924583E+00, 8.9294967421E-01],
	[2.5885000000E+04, 1.9025449932E+01, 5.2298064307E+00, 4.9369045654E+00, 2.2405001557E+00, 8.9300280055E-01],
	[2.5890000000E+04, 1.9031337886E+01, 5.2297698936E+00, 4.9399771899E+00, 2.2412077439E+00, 8.9305589975E-01],
	[2.5895000000E+04, 1.9037226525E+01, 5.2297333637E+00, 4.9430511308E+00, 2.2419152229E+00, 8.9310897185E-01],
	[2.5900000000E+04, 1.9043115848E+01, 5.2296968412E+00, 4.9461263882E+00, 2.2426225926E+00, 8.9316201684E-01],
	[2.5905000000E+04, 1.9049012747E+01, 5.2296613445E+00, 4.9492029626E+00, 2.2433301359E+00, 8.9321503474E-01],
	[2.5910000000E+04, 1.9054928151E+01, 5.2296284877E+00, 4.9522808542E+00, 2.2440383019E+00, 8.9326802556E-01],
	[2.5915000000E+04, 1.9060844250E+01, 5.2295956375E+00, 4.9553600635E+00, 2.2447463593E+00, 8.9332098932E-01],
	[2.5920000000E+04, 1.9066761043E+01, 5.2295627938E+00, 4.9584405905E+00, 2.2454543079E+00, 8.9337392603E-01],
	[2.5925000000E+04, 1.9072678532E+01, 5.2295299567E+00, 4.9615224358E+00, 2.2461621478E+00, 8.9342683569E-01],
	[2.5930000000E+04, 1.9078596715E+01, 5.2294971261E+00, 4.9646055995E+00, 2.2468698787E+00, 8.9347971832E-01],
	[2.5935000000E+04, 1.9084515594E+01, 5.2294643021E+00, 4.9676900820E+00, 2.2475775007E+00, 8.9353257394E-01],
	[2.5940000000E+04, 1.9090435167E+01, 5.2294314845E+00, 4.9707758837E+00, 2.2482850136E+00, 8.9358540255E-01],
	[2.5945000000E+04, 1.9096355434E+01, 5.2293986735E+00, 4.9738630047E+00, 2.2489924174E+00, 8.9363820417E-01],
	[2.5950000000E+04, 1.9102276396E+01, 5.2293658691E+00, 4.9769514455E+00, 2.2496997119E+00, 8.9369097881E-01],
	[2.5955000000E+04, 1.9108198053E+01, 5.2293330711E+00, 4.9800412063E+00, 2.2504068972E+00, 8.9374372648E-01],
	[2.5960000000E+04, 1.9114120405E+01, 5.2293002797E+00, 4.9831322874E+00, 2.2511139731E+00, 8.9379644719E-01],
	[2.5965000000E+04, 1.9120043451E+01, 5.2292674948E+00, 4.9862246891E+00, 2.2518209396E+00, 8.9384914096E-01],
	[2.5970000000E+04, 1.9125967191E+01, 5.2292347165E+00, 4.9893184118E+00, 2.2525277965E+00, 8.9390180780E-01],
	[2.5975000000E+04, 1.9131891625E+01, 5.2292019446E+00, 4.9924134558E+00, 2.2532345439E+00, 8.9395444772E-01],
	[2.5980000000E+04, 1.9137816754E+01, 5.2291691793E+00, 4.9955098213E+00, 2.2539411815E+00, 8.9400706074E-01],
	[2.5985000000E+04, 1.9143742578E+01, 5.2291364204E+00, 4.9986075088E+00, 2.2546477094E+00, 8.9405964686E-01],
	[2.5990000000E+04, 1.9149669095E+01, 5.2291036681E+00, 5.0017065184E+00, 2.2553541274E+00, 8.9411220609E-01],
	[2.5995000000E+04, 1.9155596307E+01, 5.2290709223E+00, 5.0048068505E+00, 2.2560604355E+00, 8.9416473846E-01],
	[2.6000000000E+04, 1.9161524212E+01, 5.2290381830E+00, 5.0079085053E+00, 2.2567666336E+00, 8.9421724397E-01],
	[2.6005000000E+04, 1.9167452812E+01, 5.2290054501E+00, 5.0110114833E+00, 2.2574727216E+00, 8.9426972263E-01],
	[2.6010000000E+04, 1.9173382106E+01, 5.2289727238E+00, 5.0141157848E+00, 2.2581786994E+00, 8.9432217446E-01],
	[2.6015000000E+04, 1.9179312093E+01, 5.2289400040E+00, 5.0172214099E+00, 2.2588845671E+00, 8.9437459947E-01],
	[2.6020000000E+04, 1.9185242775E+01, 5.2289072907E+00, 5.0203283591E+00, 2.2595903244E+00, 8.9442699767E-01],
	[2.6025000000E+04, 1.9191174150E+01, 5.2288745838E+00, 5.0234366326E+00, 2.2602959712E+00, 8.9447936907E-01],
	[2.6030000000E+04, 1.9197106220E+01, 5.2288418835E+00, 5.0265462308E+00, 2.2610015077E+00, 8.9453171369E-01],
	[2.6035000000E+04, 1.9203038983E+01, 5.2288091896E+00, 5.0296571539E+00, 2.2617069335E+00, 8.9458403153E-01],
	[2.6040000000E+04, 1.9208972439E+01, 5.2287765022E+00, 5.0327694024E+00, 2.2624122488E+00, 8.9463632262E-01],
	[2.6045000000E+04, 1.9214906590E+01, 5.2287438213E+00, 5.0358829763E+00, 2.2631174533E+00, 8.9468858696E-01],
	[2.6050000000E+04, 1.9220841433E+01, 5.2287111469E+00, 5.0389978762E+00, 2.2638225470E+00, 8.9474082456E-01],
	[2.6055000000E+04, 1.9226776971E+01, 5.2286784789E+00, 5.0421141023E+00, 2.2645275299E+00, 8.9479303544E-01],
	[2.6060000000E+04, 1.9232713202E+01, 5.2286458174E+00, 5.0452316549E+00, 2.2652324019E+00, 8.9484521961E-01],
	[2.6065000000E+04, 1.9238650126E+01, 5.2286131624E+00, 5.0483505342E+00, 2.2659371628E+00, 8.9489737708E-01],
	[2.6070000000E+04, 1.9244587744E+01, 5.2285805139E+00, 5.0514707407E+00, 2.2666418126E+00, 8.9494950787E-01],
	[2.6075000000E+04, 1.9250526055E+01, 5.2285478718E+00, 5.0545922747E+00, 2.2673463512E+00, 8.9500161198E-01],
	[2.6080000000E+04, 1.9256465059E+01, 5.2285152362E+00, 5.0577151364E+00, 2.2680507786E+00, 8.9505368943E-01],
	[2.6085000000E+04, 1.9262404756E+01, 5.2284826070E+00, 5.0608393261E+00, 2.2687550947E+00, 8.9510574023E-01],
	[2.6090000000E+04, 1.9268345147E+01, 5.2284499843E+00, 5.0639648441E+00, 2.2694592993E+00, 8.9515776439E-01],
	[2.6095000000E+04, 1.9274286231E+01, 5.2284173681E+00, 5.0670916909E+00, 2.2701633925E+00, 8.9520976193E-01],
	[2.6100000000E+04, 1.9280228008E+01, 5.2283847583E+00, 5.0702198666E+00, 2.2708673741E+00, 8.9526173286E-01],
	[2.6105000000E+04, 1.9286170478E+01, 5.2283521549E+00, 5.0733493716E+00, 2.2715712441E+00, 8.9531367718E-01],
	[2.6110000000E+04, 1.9292113640E+01, 5.2283195580E+00, 5.0764802062E+00, 2.2722750023E+00, 8.9536559492E-01],
	[2.6115000000E+04, 1.9298057496E+01, 5.2282869676E+00, 5.0796123707E+00, 2.2729786488E+00, 8.9541748608E-01],
	[2.6120000000E+04, 1.9304002045E+01, 5.2282543836E+00, 5.0827458653E+00, 2.2736821834E+00, 8.9546935068E-01],
	[2.6125000000E+04, 1.9309947286E+01, 5.2282218060E+00, 5.0858806906E+00, 2.2743856061E+00, 8.9552118873E-01],
	[2.6130000000E+04, 1.9315893220E+01, 5.2281892349E+00, 5.0890168466E+00, 2.2750889167E+00, 8.9557300024E-01],
	[2.6135000000E+04, 1.9321839847E+01, 5.2281566702E+00, 5.0921543337E+00, 2.2757921153E+00, 8.9562478523E-01],
	[2.6140000000E+04, 1.9327787166E+01, 5.2281241119E+00, 5.0952931524E+00, 2.2764952016E+00, 8.9567654370E-01],
	[2.6145000000E+04, 1.9333735179E+01, 5.2280915601E+00, 5.0984333027E+00, 2.2771981758E+00, 8.9572827567E-01],
	[2.6150000000E+04, 1.9339683883E+01, 5.2280590147E+00, 5.1015747851E+00, 2.2779010376E+00, 8.9577998115E-01],
	[2.6155000000E+04, 1.9345633280E+01, 5.2280264757E+00, 5.1047175999E+00, 2.2786037870E+00, 8.9583166015E-01],
	[2.6160000000E+04, 1.9351583370E+01, 5.2279939431E+00, 5.1078617474E+00, 2.2793064239E+00, 8.9588331269E-01],
	[2.6165000000E+04, 1.9357534152E+01, 5.2279614170E+00, 5.1110072278E+00, 2.2800089483E+00, 8.9593493877E-01],
	[2.6170000000E+04, 1.9363485626E+01, 5.2279288973E+00, 5.1141540416E+00, 2.2807113600E+00, 8.9598653842E-01],
	[2.6175000000E+04, 1.9369437793E+01, 5.2278963840E+00, 5.1173021889E+00, 2.2814136591E+00, 8.9603811164E-01],
	[2.6180000000E+04, 1.9375390651E+01, 5.2278638771E+00, 5.1204516702E+00, 2.2821158454E+00, 8.9608965844E-01],
	[2.6185000000E+04, 1.9381344202E+01, 5.2278313766E+00, 5.1236024857E+00, 2.2828179188E+00, 8.9614117884E-01],
	[2.6190000000E+04, 1.9387298445E+01, 5.2277988825E+00, 5.1267546357E+00, 2.2835198793E+00, 8.9619267285E-01],
	[2.6195000000E+04, 1.9393253381E+01, 5.2277663948E+00, 5.1299081206E+00, 2.2842217268E+00, 8.9624414048E-01],
	[2.6200000000E+04, 1.9399209008E+01, 5.2277339136E+00, 5.1330629406E+00, 2.2849234612E+00, 8.9629558174E-01],
	[2.6205000000E+04, 1.9405165327E+01, 5.2277014387E+00, 5.1362190960E+00, 2.2856250825E+00, 8.9634699666E-01],
	[2.6210000000E+04, 1.9411122338E+01, 5.2276689702E+00, 5.1393765873E+00, 2.2863265905E+00, 8.9639838523E-01],
	[2.6215000000E+04, 1.9417080041E+01, 5.2276365081E+00, 5.1425354146E+00, 2.2870279853E+00, 8.9644974747E-01],
	[2.6220000000E+04, 1.9423038436E+01, 5.2276040524E+00, 5.1456955783E+00, 2.2877292666E+00, 8.9650108339E-01],
	[2.6225000000E+04, 1.9428997523E+01, 5.2275716031E+00, 5.1488570786E+00, 2.2884304345E+00, 8.9655239301E-01],
	[2.6230000000E+04, 1.9434957301E+01, 5.2275391602E+00, 5.1520199160E+00, 2.2891314889E+00, 8.9660367634E-01],
	[2.6235000000E+04, 1.9440917771E+01, 5.2275067237E+00, 5.1551840907E+00, 2.2898324297E+00, 8.9665493339E-01],
	[2.6240000000E+04, 1.9446878932E+01, 5.2274742936E+00, 5.1583496030E+00, 2.2905332569E+00, 8.9670616417E-01],
	[2.6245000000E+04, 1.9452840786E+01, 5.2274418698E+00, 5.1615164533E+00, 2.2912339702E+00, 8.9675736870E-01],
	[2.6250000000E+04, 1.9458803330E+01, 5.2274094524E+00, 5.1646846418E+00, 2.2919345698E+00, 8.9680854699E-01],
	[2.6255000000E+04, 1.9464766566E+01, 5.2273770414E+00, 5.1678541688E+00, 2.2926350555E+00, 8.9685969904E-01],
	[2.6260000000E+04, 1.9470730494E+01, 5.2273446368E+00, 5.1710250347E+00, 2.2933354272E+00, 8.9691082488E-01],
	[2.6265000000E+04, 1.9476695113E+01, 5.2273122385E+00, 5.1741972398E+00, 2.2940356848E+00, 8.9696192451E-01],
	[2.6270000000E+04, 1.9482660423E+01, 5.2272798466E+00, 5.1773707843E+00, 2.2947358284E+00, 8.9701299794E-01],
	[2.6275000000E+04, 1.9488626424E+01, 5.2272474611E+00, 5.1805456686E+00, 2.2954358577E+00, 8.9706404519E-01],
	[2.6280000000E+04, 1.9494593117E+01, 5.2272150819E+00, 5.1837218930E+00, 2.2961357728E+00, 8.9711506627E-01],
	[2.6285000000E+04, 1.9500560501E+01, 5.2271827091E+00, 5.1868994578E+00, 2.2968355736E+00, 8.9716606118E-01],
	[2.6290000000E+04, 1.9506528576E+01, 5.2271503426E+00, 5.1900783633E+00, 2.2975352600E+00, 8.9721702995E-01],
	[2.6295000000E+04, 1.9512497341E+01, 5.2271179825E+00, 5.1932586099E+00, 2.2982348318E+00, 8.9726797257E-01],
	[2.6300000000E+04, 1.9518466798E+01, 5.2270856288E+00, 5.1964401977E+00, 2.2989342892E+00, 8.9731888907E-01],
	[2.6305000000E+04, 1.9524436946E+01, 5.2270532814E+00, 5.1996231273E+00, 2.2996336319E+00, 8.9736977945E-01],
	[2.6310000000E+04, 1.9530407785E+01, 5.2270209404E+00, 5.2028073987E+00, 2.3003328599E+00, 8.9742064372E-01],
	[2.6315000000E+04, 1.9536379315E+01, 5.2269886057E+00, 5.2059930124E+00, 2.3010319731E+00, 8.9747148190E-01],
	[2.6320000000E+04, 1.9542351535E+01, 5.2269562773E+00, 5.2091799687E+00, 2.3017309715E+00, 8.9752229399E-01],
	[2.6325000000E+04, 1.9548345950E+01, 5.2269270951E+00, 5.2123682679E+00, 2.3024307625E+00, 8.9757308002E-01],
	[2.6330000000E+04, 1.9554344099E+01, 5.2268983616E+00, 5.2155579102E+00, 2.3031305674E+00, 8.9762383998E-01],
	[2.6335000000E+04, 1.9560342949E+01, 5.2268696337E+00, 5.2187488960E+00, 2.3038302581E+00, 8.9767457389E-01],
	[2.6340000000E+04, 1.9566342501E+01, 5.2268409114E+00, 5.2219412257E+00, 2.3045298345E+00, 8.9772528177E-01],
	[2.6345000000E+04, 1.9572342753E+01, 5.2268121947E+00, 5.2251348994E+00, 2.3052292966E+00, 8.9777596362E-01],
	[2.6350000000E+04, 1.9578343706E+01, 5.2267834836E+00, 5.2283299176E+00, 2.3059286442E+00, 8.9782661945E-01],
	[2.6355000000E+04, 1.9584345359E+01, 5.2267547782E+00, 5.2315262805E+00, 2.3066278774E+00, 8.9787724928E-01],
	[2.6360000000E+04, 1.9590347714E+01, 5.2267260783E+00, 5.2347239884E+00, 2.3073269960E+00, 8.9792785311E-01],
	[2.6365000000E+04, 1.9596350769E+01, 5.2266973840E+00, 5.2379230417E+00, 2.3080260000E+00, 8.9797843097E-01],
	[2.6370000000E+04, 1.9602354525E+01, 5.2266686954E+00, 5.2411234407E+00, 2.3087248892E+00, 8.9802898285E-01],
	[2.6375000000E+04, 1.9608358981E+01, 5.2266400123E+00, 5.2443251856E+00, 2.3094236637E+00, 8.9807950877E-01],
	[2.6380000000E+04, 1.9614364138E+01, 5.2266113348E+00, 5.2475282768E+00, 2.3101223234E+00, 8.9813000875E-01],
	[2.6385000000E+04, 1.9620369995E+01, 5.2265826629E+00, 5.2507327146E+00, 2.3108208681E+00, 8.9818048279E-01],
	[2.6390000000E+04, 1.9626376553E+01, 5.2265539966E+00, 5.2539384992E+00, 2.3115192979E+00, 8.9823093091E-01],
	[2.6395000000E+04, 1.9632383811E+01, 5.2265253359E+00, 5.2571456311E+00, 2.3122176126E+00, 8.9828135311E-01],
	[2.6400000000E+04, 1.9638391770E+01, 5.2264966808E+00, 5.2603541105E+00, 2.3129158121E+00, 8.9833174941E-01],
	[2.6405000000E+04, 1.9644400429E+01, 5.2264680312E+00, 5.2635639378E+00, 2.3136138965E+00, 8.9838211982E-01],
	[2.6410000000E+04, 1.9650409788E+01, 5.2264393873E+00, 5.2667751131E+00, 2.3143118656E+00, 8.9843246435E-01],
	[2.6415000000E+04, 1.9656419847E+01, 5.2264107489E+00, 5.2699876369E+00, 2.3150097193E+00, 8.9848278301E-01],
	[2.6420000000E+04, 1.9662430607E+01, 5.2263821161E+00, 5.2732015095E+00, 2.3157074576E+00, 8.9853307582E-01],
	[2.6425000000E+04, 1.9668442066E+01, 5.2263534889E+00, 5.2764167311E+00, 2.3164050804E+00, 8.9858334278E-01],
	[2.6430000000E+04, 1.9674454226E+01, 5.2263248672E+00, 5.2796333021E+00, 2.3171025877E+00, 8.9863358390E-01],
	[2.6435000000E+04, 1.9680467085E+01, 5.2262962511E+00, 5.2828512227E+00, 2.3177999794E+00, 8.9868379920E-01],
	[2.6440000000E+04, 1.9686480645E+01, 5.2262676406E+00, 5.2860704934E+00, 2.3184972553E+00, 8.9873398869E-01],
	[2.6445000000E+04, 1.9692494904E+01, 5.2262390356E+00, 5.2892911144E+00, 2.3191944155E+00, 8.9878415239E-01],
	[2.6450000000E+04, 1.9698509863E+01, 5.2262104363E+00, 5.2925130859E+00, 2.3198914599E+00, 8.9883429029E-01],
	[2.6455000000E+04, 1.9704525522E+01, 5.2261818424E+00, 5.2957364084E+00, 2.3205883883E+00, 8.9888440241E-01],
	[2.6460000000E+04, 1.9710541881E+01, 5.2261532542E+00, 5.2989610821E+00, 2.3212852008E+00, 8.9893448877E-01],
	[2.6465000000E+04, 1.9716558939E+01, 5.2261246715E+00, 5.3021871074E+00, 2.3219818972E+00, 8.9898454938E-01],
	[2.6470000000E+04, 1.9722576697E+01, 5.2260960943E+00, 5.3054144845E+00, 2.3226784775E+00, 8.9903458424E-01],
	[2.6475000000E+04, 1.9728595155E+01, 5.2260675227E+00, 5.3086432137E+00, 2.3233749417E+00, 8.9908459337E-01],
	[2.6480000000E+04, 1.9734614312E+01, 5.2260389567E+00, 5.3118732955E+00, 2.3240712895E+00, 8.9913457678E-01],
	[2.6485000000E+04, 1.9740634168E+01, 5.2260103962E+00, 5.3151047300E+00, 2.3247675211E+00, 8.9918453448E-01],
	[2.6490000000E+04, 1.9746654724E+01, 5.2259818412E+00, 5.3183375175E+00, 2.3254636362E+00, 8.9923446649E-01],
	[2.6495000000E+04, 1.9752675980E+01, 5.2259532918E+00, 5.3215716585E+00, 2.3261596349E+00, 8.9928437281E-01],
	[2.6500000000E+04, 1.9758697934E+01, 5.2259247480E+00, 5.3248071532E+00, 2.3268555171E+00, 8.9933425345E-01],
	[2.6505000000E+04, 1.9764720588E+01, 5.2258962097E+00, 5.3280440019E+00, 2.3275512826E+00, 8.9938410843E-01],
	[2.6510000000E+04, 1.9770743941E+01, 5.2258676769E+00, 5.3312822049E+00, 2.3282469315E+00, 8.9943393776E-01],
	[2.6515000000E+04, 1.9776767994E+01, 5.2258391496E+00, 5.3345217626E+00, 2.3289424636E+00, 8.9948374145E-01],
	[2.6520000000E+04, 1.9782792745E+01, 5.2258106279E+00, 5.3377626752E+00, 2.3296378790E+00, 8.9953351951E-01],
	[2.6525000000E+04, 1.9788818196E+01, 5.2257821118E+00, 5.3410049431E+00, 2.3303331774E+00, 8.9958327195E-01],
	[2.6530000000E+04, 1.9794844345E+01, 5.2257536011E+00, 5.3442485665E+00, 2.3310283589E+00, 8.9963299879E-01],
	[2.6535000000E+04, 1.9800871193E+01, 5.2257250960E+00, 5.3474935458E+00, 2.3317234234E+00, 8.9968270003E-01],
	[2.6540000000E+04, 1.9806898741E+01, 5.2256965964E+00, 5.3507398813E+00, 2.3324183708E+00, 8.9973237569E-01],
	[2.6545000000E+04, 1.9812926987E+01, 5.2256681023E+00, 5.3539875732E+00, 2.3331132011E+00, 8.9978202578E-01],
	[2.6550000000E+04, 1.9818955932E+01, 5.2256396138E+00, 5.3572366220E+00, 2.3338079142E+00, 8.9983165031E-01],
	[2.6555000000E+04, 1.9824985576E+01, 5.2256111308E+00, 5.3604870279E+00, 2.3345025099E+00, 8.9988124929E-01],
	[2.6560000000E+04, 1.9831015919E+01, 5.2255826533E+00, 5.3637387912E+00, 2.3351969883E+00, 8.9993082273E-01],
	[2.6565000000E+04, 1.9837046960E+01, 5.2255541813E+00, 5.3669919122E+00, 2.3358913493E+00, 8.9998037065E-01],
	[2.6570000000E+04, 1.9843078700E+01, 5.2255257148E+00, 5.3702463913E+00, 2.3365855928E+00, 9.0002989305E-01],
	[2.6575000000E+04, 1.9849111138E+01, 5.2254972538E+00, 5.3735022287E+00, 2.3372797187E+00, 9.0007938995E-01],
	[2.6580000000E+04, 1.9855144275E+01, 5.2254687984E+00, 5.3767594248E+00, 2.3379737270E+00, 9.0012886136E-01],
	[2.6585000000E+04, 1.9861178110E+01, 5.2254403484E+00, 5.3800179799E+00, 2.3386676176E+00, 9.0017830729E-01],
	[2.6590000000E+04, 1.9867212644E+01, 5.2254119040E+00, 5.3832778942E+00, 2.3393613905E+00, 9.0022772776E-01],
	[2.6595000000E+04, 1.9873247876E+01, 5.2253834650E+00, 5.3865391681E+00, 2.3400550455E+00, 9.0027712276E-01],
	[2.6600000000E+04, 1.9879283807E+01, 5.2253550316E+00, 5.3898018020E+00, 2.3407485826E+00, 9.0032649232E-01],
	[2.6605000000E+04, 1.9885320435E+01, 5.2253266037E+00, 5.3930657960E+00, 2.3414420018E+00, 9.0037583645E-01],
	[2.6610000000E+04, 1.9891357762E+01, 5.2252981812E+00, 5.3963311506E+00, 2.3421353029E+00, 9.0042515515E-01],
	[2.6615000000E+04, 1.9897395787E+01, 5.2252697643E+00, 5.3995978660E+00, 2.3428284860E+00, 9.0047444844E-01],
	[2.6620000000E+04, 1.9903434510E+01, 5.2252413528E+00, 5.4028659425E+00, 2.3435215509E+00, 9.0052371634E-01],
	[2.6625000000E+04, 1.9909473931E+01, 5.2252129468E+00, 5.4061353805E+00, 2.3442144975E+00, 9.0057295884E-01],
	[2.6630000000E+04, 1.9915514051E+01, 5.2251845464E+00, 5.4094061802E+00, 2.3449073259E+00, 9.0062217598E-01],
	[2.6635000000E+04, 1.9921554868E+01, 5.2251561514E+00, 5.4126783420E+00, 2.3456000358E+00, 9.0067136774E-01],
	[2.6640000000E+04, 1.9927596383E+01, 5.2251277619E+00, 5.4159518662E+00, 2.3462926274E+00, 9.0072053415E-01],
	[2.6645000000E+04, 1.9933638596E+01, 5.2250993778E+00, 5.4192267531E+00, 2.3469851005E+00, 9.0076967523E-01],
	[2.6650000000E+04, 1.9939681507E+01, 5.2250709993E+00, 5.4225030029E+00, 2.3476774550E+00, 9.0081879097E-01],
	[2.6655000000E+04, 1.9945725115E+01, 5.2250426262E+00, 5.4257806161E+00, 2.3483696908E+00, 9.0086788139E-01],
	[2.6660000000E+04, 1.9951769421E+01, 5.2250142586E+00, 5.4290595929E+00, 2.3490618080E+00, 9.0091694650E-01],
	[2.6665000000E+04, 1.9957814425E+01, 5.2249858965E+00, 5.4323399337E+00, 2.3497538064E+00, 9.0096598633E-01],
	[2.6670000000E+04, 1.9963860127E+01, 5.2249575399E+00, 5.4356216386E+00, 2.3504456860E+00, 9.0101500086E-01],
	[2.6675000000E+04, 1.9969906526E+01, 5.2249291887E+00, 5.4389047082E+00, 2.3511374467E+00, 9.0106399013E-01],
	[2.6680000000E+04, 1.9975953622E+01, 5.2249008430E+00, 5.4421891425E+00, 2.3518290884E+00, 9.0111295413E-01],
	[2.6685000000E+04, 1.9982001416E+01, 5.2248725027E+00, 5.4454749421E+00, 2.3525206111E+00, 9.0116189288E-01],
	[2.6690000000E+04, 1.9988049907E+01, 5.2248441679E+00, 5.4487621071E+00, 2.3532120148E+00, 9.0121080640E-01],
	[2.6695000000E+04, 1.9994099096E+01, 5.2248158386E+00, 5.4520506379E+00, 2.3539032992E+00, 9.0125969469E-01],
	[2.6700000000E+04, 2.0000148982E+01, 5.2247875148E+00, 5.4553405349E+00, 2.3545944645E+00, 9.0130855777E-01],
	[2.6705000000E+04, 2.0006199565E+01, 5.2247591964E+00, 5.4586317982E+00, 2.3552855105E+00, 9.0135739564E-01],
	[2.6710000000E+04, 2.0012250846E+01, 5.2247308834E+00, 5.4619244282E+00, 2.3559764371E+00, 9.0140620832E-01],
	[2.6715000000E+04, 2.0018302823E+01, 5.2247025759E+00, 5.4652184253E+00, 2.3566672443E+00, 9.0145499582E-01],
	[2.6720000000E+04, 2.0024355498E+01, 5.2246742739E+00, 5.4685137897E+00, 2.3573579320E+00, 9.0150375815E-01],
	[2.6725000000E+04, 2.0030408870E+01, 5.2246459773E+00, 5.4718105218E+00, 2.3580485002E+00, 9.0155249533E-01],
	[2.6730000000E+04, 2.0036462939E+01, 5.2246176861E+00, 5.4751086218E+00, 2.3587389487E+00, 9.0160120736E-01],
	[2.6735000000E+04, 2.0042517704E+01, 5.2245894004E+00, 5.4784080901E+00, 2.3594292776E+00, 9.0164989426E-01],
	[2.6740000000E+04, 2.0048573167E+01, 5.2245611202E+00, 5.4817089270E+00, 2.3601194868E+00, 9.0169855604E-01],
	[2.6745000000E+04, 2.0054632521E+01, 5.2245333064E+00, 5.4850111328E+00, 2.3608097145E+00, 9.0174719270E-01],
	[2.6750000000E+04, 2.0060713744E+01, 5.2245085526E+00, 5.4883147077E+00, 2.3615007400E+00, 9.0179580427E-01],
	[2.6755000000E+04, 2.0066795673E+01, 5.2244838035E+00, 5.4916196522E+00, 2.3621916464E+00, 9.0184439075E-01],
	[2.6760000000E+04, 2.0072878310E+01, 5.2244590592E+00, 5.4949259665E+00, 2.3628824336E+00, 9.0189295215E-01],
	[2.6765000000E+04, 2.0078961653E+01, 5.2244343197E+00, 5.4982336510E+00, 2.3635731015E+00, 9.0194148849E-01],
	[2.6770000000E+04, 2.0085045703E+01, 5.2244095848E+00, 5.5015427059E+00, 2.3642636503E+00, 9.0198999978E-01],
	[2.6775000000E+04, 2.0091130460E+01, 5.2243848547E+00, 5.5048531315E+00, 2.3649540796E+00, 9.0203848602E-01],
	[2.6780000000E+04, 2.0097215924E+01, 5.2243601294E+00, 5.5081649282E+00, 2.3656443895E+00, 9.0208694724E-01],
	[2.6785000000E+04, 2.0103302094E+01, 5.2243354087E+00, 5.5114780962E+00, 2.3663345800E+00, 9.0213538344E-01],
	[2.6790000000E+04, 2.0109388971E+01, 5.2243106928E+00, 5.5147926360E+00, 2.3670246509E+00, 9.0218379464E-01],
	[2.6795000000E+04, 2.0115476554E+01, 5.2242859817E+00, 5.5181085477E+00, 2.3677146023E+00, 9.0223218083E-01],
	[2.6800000000E+04, 2.0121564844E+01, 5.2242612752E+00, 5.5214258318E+00, 2.3684044339E+00, 9.0228054205E-01],
	[2.6805000000E+04, 2.0127653841E+01, 5.2242365735E+00, 5.5247444885E+00, 2.3690941458E+00, 9.0232887830E-01],
	[2.6810000000E+04, 2.0133743543E+01, 5.2242118765E+00, 5.5280645180E+00, 2.3697837380E+00, 9.0237718958E-01],
	[2.6815000000E+04, 2.0139833952E+01, 5.2241871842E+00, 5.5313859209E+00, 2.3704732102E+00, 9.0242547592E-01],
	[2.6820000000E+04, 2.0145925068E+01, 5.2241624967E+00, 5.5347086972E+00, 2.3711625626E+00, 9.0247373732E-01],
	[2.6825000000E+04, 2.0152016889E+01, 5.2241378138E+00, 5.5380328475E+00, 2.3718517949E+00, 9.0252197380E-01],
	[2.6830000000E+04, 2.0158109417E+01, 5.2241131357E+00, 5.5413583718E+00, 2.3725409073E+00, 9.0257018536E-01],
	[2.6835000000E+04, 2.0164202651E+01, 5.2240884623E+00, 5.5446852707E+00, 2.3732298995E+00, 9.0261837202E-01],
	[2.6840000000E+04, 2.0170296591E+01, 5.2240637936E+00, 5.5480135444E+00, 2.3739187715E+00, 9.0266653379E-01],
	[2.6845000000E+04, 2.0176391237E+01, 5.2240391297E+00, 5.5513431931E+00, 2.3746075233E+00, 9.0271467069E-01],
	[2.6850000000E+04, 2.0182486589E+01, 5.2240144704E+00, 5.5546742173E+00, 2.3752961548E+00, 9.0276278272E-01],
	[2.6855000000E+04, 2.0188582647E+01, 5.2239898158E+00, 5.5580066171E+00, 2.3759846659E+00, 9.0281086989E-01],
	[2.6860000000E+04, 2.0194679411E+01, 5.2239651660E+00, 5.5613403930E+00, 2.3766730566E+00, 9.0285893222E-01],
	[2.6865000000E+04, 2.0200776880E+01, 5.2239405208E+00, 5.5646755453E+00, 2.3773613269E+00, 9.0290696971E-01],
	[2.6870000000E+04, 2.0206875056E+01, 5.2239158804E+00, 5.5680120742E+00, 2.3780494766E+00, 9.0295498239E-01],
	[2.6875000000E+04, 2.0212973937E+01, 5.2238912446E+00, 5.5713499800E+00, 2.3787375056E+00, 9.0300297026E-01],
	[2.6880000000E+04, 2.0219073524E+01, 5.2238666136E+00, 5.5746892632E+00, 2.3794254140E+00, 9.0305093333E-01],
	[2.6885000000E+04, 2.0225173817E+01, 5.2238419873E+00, 5.5780299239E+00, 2.3801132017E+00, 9.0309887162E-01],
	[2.6890000000E+04, 2.0231274815E+01, 5.2238173656E+00, 5.5813719625E+00, 2.3808008685E+00, 9.0314678513E-01],
	[2.6895000000E+04, 2.0237376518E+01, 5.2237927486E+00, 5.5847153793E+00, 2.3814884145E+00, 9.0319467389E-01],
	[2.6900000000E+04, 2.0243478928E+01, 5.2237681364E+00, 5.5880601746E+00, 2.3821758396E+00, 9.0324253789E-01],
	[2.6905000000E+04, 2.0249582042E+01, 5.2237435288E+00, 5.5914063487E+00, 2.3828631437E+00, 9.0329037715E-01],
	[2.6910000000E+04, 2.0255685862E+01, 5.2237189259E+00, 5.5947539020E+00, 2.3835503268E+00, 9.0333819169E-01],
	[2.6915000000E+04, 2.0261790388E+01, 5.2236943277E+00, 5.5981028347E+00, 2.3842373887E+00, 9.0338598151E-01],
	[2.6920000000E+04, 2.0267895618E+01, 5.2236697342E+00, 5.6014531472E+00, 2.3849243295E+00, 9.0343374663E-01],
	[2.6925000000E+04, 2.0274001554E+01, 5.2236451454E+00, 5.6048048397E+00, 2.3856111491E+00, 9.0348148706E-01],
	[2.6930000000E+04, 2.0280108195E+01, 5.2236205612E+00, 5.6081579126E+00, 2.3862978474E+00, 9.0352920280E-01],
	[2.6935000000E+04, 2.0286215542E+01, 5.2235959817E+00, 5.6115123662E+00, 2.3869844243E+00, 9.0357689388E-01],
	[2.6940000000E+04, 2.0292323593E+01, 5.2235714070E+00, 5.6148682008E+00, 2.3876708798E+00, 9.0362456030E-01],
	[2.6945000000E+04, 2.0298432350E+01, 5.2235468368E+00, 5.6182254167E+00, 2.3883572138E+00, 9.0367220208E-01],
	[2.6950000000E+04, 2.0304541811E+01, 5.2235222714E+00, 5.6215840142E+00, 2.3890434263E+00, 9.0371981922E-01],
	[2.6955000000E+04, 2.0310651977E+01, 5.2234977106E+00, 5.6249439937E+00, 2.3897295173E+00, 9.0376741174E-01],
	[2.6960000000E+04, 2.0316762849E+01, 5.2234731545E+00, 5.6283053554E+00, 2.3904154865E+00, 9.0381497965E-01],
	[2.6965000000E+04, 2.0322874425E+01, 5.2234486031E+00, 5.6316680996E+00, 2.3911013341E+00, 9.0386252296E-01],
	[2.6970000000E+04, 2.0328986706E+01, 5.2234240563E+00, 5.6350322267E+00, 2.3917870598E+00, 9.0391004169E-01],
	[2.6975000000E+04, 2.0335099691E+01, 5.2233995142E+00, 5.6383977370E+00, 2.3924726638E+00, 9.0395753584E-01],
	[2.6980000000E+04, 2.0341213382E+01, 5.2233749768E+00, 5.6417646308E+00, 2.3931581458E+00, 9.0400500542E-01],
	[2.6985000000E+04, 2.0347327777E+01, 5.2233504440E+00, 5.6451329083E+00, 2.3938435059E+00, 9.0405245046E-01],
	[2.6990000000E+04, 2.0353442876E+01, 5.2233259159E+00, 5.6485025700E+00, 2.3945287439E+00, 9.0409987096E-01],
	[2.6995000000E+04, 2.0359558681E+01, 5.2233013925E+00, 5.6518736161E+00, 2.3952138599E+00, 9.0414726692E-01],
	[2.7000000000E+04, 2.0365675189E+01, 5.2232768737E+00, 5.6552460469E+00, 2.3958988538E+00, 9.0419463837E-01],
	[2.7005000000E+04, 2.0371792403E+01, 5.2232523595E+00, 5.6586198627E+00, 2.3965837254E+00, 9.0424198532E-01],
	[2.7010000000E+04, 2.0377910320E+01, 5.2232278500E+00, 5.6619950639E+00, 2.3972684748E+00, 9.0428930777E-01],
	[2.7015000000E+04, 2.0384028942E+01, 5.2232033452E+00, 5.6653716507E+00, 2.3979531019E+00, 9.0433660574E-01],
	[2.7020000000E+04, 2.0390148268E+01, 5.2231788450E+00, 5.6687496236E+00, 2.3986376066E+00, 9.0438387924E-01],
	[2.7025000000E+04, 2.0396268299E+01, 5.2231543495E+00, 5.6721289827E+00, 2.3993219889E+00, 9.0443112828E-01],
	[2.7030000000E+04, 2.0402389033E+01, 5.2231298586E+00, 5.6755097284E+00, 2.4000062487E+00, 9.0447835288E-01],
	[2.7035000000E+04, 2.0408510472E+01, 5.2231053724E+00, 5.6788918609E+00, 2.4006903859E+00, 9.0452555304E-01],
	[2.7040000000E+04, 2.0414632615E+01, 5.2230808908E+00, 5.6822753807E+00, 2.4013744005E+00, 9.0457272878E-01],
	[2.7045000000E+04, 2.0420755462E+01, 5.2230564138E+00, 5.6856602881E+00, 2.4020582925E+00, 9.0461988010E-01],
	[2.7050000000E+04, 2.0426879013E+01, 5.2230319415E+00, 5.6890465832E+00, 2.4027420617E+00, 9.0466700703E-01],
	[2.7055000000E+04, 2.0433003268E+01, 5.2230074738E+00, 5.6924342665E+00, 2.4034257081E+00, 9.0471410957E-01],
	[2.7060000000E+04, 2.0439128227E+01, 5.2229830107E+00, 5.6958233383E+00, 2.4041092317E+00, 9.0476118773E-01],
	[2.7065000000E+04, 2.0445253890E+01, 5.2229585523E+00, 5.6992137988E+00, 2.4047926324E+00, 9.0480824153E-01],
	[2.7070000000E+04, 2.0451380257E+01, 5.2229340985E+00, 5.7026056485E+00, 2.4054759101E+00, 9.0485527098E-01],
	[2.7075000000E+04, 2.0457507327E+01, 5.2229096494E+00, 5.7059988875E+00, 2.4061590648E+00, 9.0490227608E-01],
	[2.7080000000E+04, 2.0463635101E+01, 5.2228852049E+00, 5.7093935162E+00, 2.4068420964E+00, 9.0494925686E-01],
	[2.7085000000E+04, 2.0469763579E+01, 5.2228607650E+00, 5.7127895349E+00, 2.4075250049E+00, 9.0499621331E-01],
	[2.7090000000E+04, 2.0475892760E+01, 5.2228363297E+00, 5.7161869439E+00, 2.4082077901E+00, 9.0504314547E-01],
	[2.7095000000E+04, 2.0482022645E+01, 5.2228118991E+00, 5.7195857436E+00, 2.4088904521E+00, 9.0509005332E-01],
	[2.7100000000E+04, 2.0488153234E+01, 5.2227874730E+00, 5.7229859342E+00, 2.4095729908E+00, 9.0513693690E-01],
	[2.7105000000E+04, 2.0494284526E+01, 5.2227630516E+00, 5.7263875161E+00, 2.4102554062E+00, 9.0518379620E-01],
	[2.7110000000E+04, 2.0500416521E+01, 5.2227386349E+00, 5.7297904895E+00, 2.4109376980E+00, 9.0523063124E-01],
	[2.7115000000E+04, 2.0506549220E+01, 5.2227142227E+00, 5.7331948548E+00, 2.4116198665E+00, 9.0527744204E-01],
	[2.7120000000E+04, 2.0512682622E+01, 5.2226898151E+00, 5.7366006123E+00, 2.4123019113E+00, 9.0532422860E-01],
	[2.7125000000E+04, 2.0518816727E+01, 5.2226654122E+00, 5.7400077623E+00, 2.4129838326E+00, 9.0537099094E-01],
	[2.7130000000E+04, 2.0524951536E+01, 5.2226410139E+00, 5.7434163051E+00, 2.4136656302E+00, 9.0541772907E-01],
	[2.7135000000E+04, 2.0531087048E+01, 5.2226166202E+00, 5.7468262411E+00, 2.4143473040E+00, 9.0546444299E-01],
	[2.7140000000E+04, 2.0537223262E+01, 5.2225922311E+00, 5.7502375704E+00, 2.4150288541E+00, 9.0551113273E-01],
	[2.7145000000E+04, 2.0543360180E+01, 5.2225678466E+00, 5.7536502935E+00, 2.4157102804E+00, 9.0555779829E-01],
	[2.7150000000E+04, 2.0549497801E+01, 5.2225434667E+00, 5.7570644107E+00, 2.4163915828E+00, 9.0560443968E-01],
	[2.7155000000E+04, 2.0555636125E+01, 5.2225190914E+00, 5.7604799222E+00, 2.4170727612E+00, 9.0565105692E-01],
	[2.7160000000E+04, 2.0561775152E+01, 5.2224947207E+00, 5.7638968284E+00, 2.4177538156E+00, 9.0569765002E-01],
	[2.7165000000E+04, 2.0567914882E+01, 5.2224703546E+00, 5.7673151296E+00, 2.4184347460E+00, 9.0574421899E-01],
	[2.7170000000E+04, 2.0574055315E+01, 5.2224459931E+00, 5.7707348261E+00, 2.4191155522E+00, 9.0579076383E-01],
	[2.7175000000E+04, 2.0580196973E+01, 5.2224217108E+00, 5.7741559183E+00, 2.4197962575E+00, 9.0583728458E-01],
	[2.7180000000E+04, 2.0586363000E+01, 5.2224008085E+00, 5.7775784063E+00, 2.4204778909E+00, 9.0588378123E-01],
	[2.7185000000E+04, 2.0592529740E+01, 5.2223799101E+00, 5.7810022906E+00, 2.4211594008E+00, 9.0593025379E-01],
	[2.7190000000E+04, 2.0598697192E+01, 5.2223590156E+00, 5.7844275714E+00, 2.4218407871E+00, 9.0597670228E-01],
	[2.7195000000E+04, 2.0604865358E+01, 5.2223381251E+00, 5.7878542490E+00, 2.4225220499E+00, 9.0602312672E-01],
	[2.7200000000E+04, 2.0611034235E+01, 5.2223172385E+00, 5.7912823239E+00, 2.4232031890E+00, 9.0606952710E-01],
	[2.7205000000E+04, 2.0617203825E+01, 5.2222963558E+00, 5.7947117962E+00, 2.4238842044E+00, 9.0611590345E-01],
	[2.7210000000E+04, 2.0623374128E+01, 5.2222754770E+00, 5.7981426663E+00, 2.4245650961E+00, 9.0616225578E-01],
	[2.7215000000E+04, 2.0629545143E+01, 5.2222546022E+00, 5.8015749345E+00, 2.4252458640E+00, 9.0620858409E-01],
	[2.7220000000E+04, 2.0635716870E+01, 5.2222337312E+00, 5.8050086011E+00, 2.4259265080E+00, 9.0625488840E-01],
	[2.7225000000E+04, 2.0641889310E+01, 5.2222128642E+00, 5.8084436665E+00, 2.4266070281E+00, 9.0630116872E-01],
	[2.7230000000E+04, 2.0648062461E+01, 5.2221920011E+00, 5.8118801308E+00, 2.4272874242E+00, 9.0634742506E-01],
	[2.7235000000E+04, 2.0654236326E+01, 5.2221711419E+00, 5.8153179946E+00, 2.4279676963E+00, 9.0639365744E-01],
	[2.7240000000E+04, 2.0660410902E+01, 5.2221502866E+00, 5.8187572579E+00, 2.4286478443E+00, 9.0643986586E-01],
	[2.7245000000E+04, 2.0666586190E+01, 5.2221294353E+00, 5.8221979213E+00, 2.4293278681E+00, 9.0648605035E-01],
	[2.7250000000E+04, 2.0672762191E+01, 5.2221085878E+00, 5.8256399849E+00, 2.4300077678E+00, 9.0653221090E-01],
	[2.7255000000E+04, 2.0678938903E+01, 5.2220877443E+00, 5.8290834491E+00, 2.4306875432E+00, 9.0657834753E-01],
	[2.7260000000E+04, 2.0685116328E+01, 5.2220669046E+00, 5.8325283143E+00, 2.4313671943E+00, 9.0662446025E-01],
	[2.7265000000E+04, 2.0691294464E+01, 5.2220460689E+00, 5.8359745806E+00, 2.4320467210E+00, 9.0667054907E-01],
	[2.7270000000E+04, 2.0697473312E+01, 5.2220252371E+00, 5.8394222485E+00, 2.4327261233E+00, 9.0671661400E-01],
	[2.7275000000E+04, 2.0703652872E+01, 5.2220044091E+00, 5.8428713182E+00, 2.4334054012E+00, 9.0676265506E-01],
	[2.7280000000E+04, 2.0709833144E+01, 5.2219835851E+00, 5.8463217900E+00, 2.4340845545E+00, 9.0680867225E-01],
	[2.7285000000E+04, 2.0716014128E+01, 5.2219627650E+00, 5.8497736643E+00, 2.4347635832E+00, 9.0685466559E-01],
	[2.7290000000E+04, 2.0722195823E+01, 5.2219419487E+00, 5.8532269414E+00, 2.4354424873E+00, 9.0690063508E-01],
	[2.7295000000E+04, 2.0728378230E+01, 5.2219211364E+00, 5.8566816216E+00, 2.4361212666E+00, 9.0694658074E-01],
	[2.7300000000E+04, 2.0734561348E+01, 5.2219003280E+00, 5.8601377052E+00, 2.4367999213E+00, 9.0699250257E-01],
	[2.7305000000E+04, 2.0740745178E+01, 5.2218795234E+00, 5.8635951924E+00, 2.4374784511E+00, 9.0703840060E-01],
	[2.7310000000E+04, 2.0746929720E+01, 5.2218587228E+00, 5.8670540837E+00, 2.4381568561E+00, 9.0708427482E-01],
	[2.7315000000E+04, 2.0753114973E+01, 5.2218379260E+00, 5.8705143793E+00, 2.4388351361E+00, 9.0713012525E-01],
	[2.7320000000E+04, 2.0759300937E+01, 5.2218171331E+00, 5.8739760796E+00, 2.4395132912E+00, 9.0717595190E-01],
	[2.7325000000E+04, 2.0765487613E+01, 5.2217963441E+00, 5.8774391848E+00, 2.4401913213E+00, 9.0722175478E-01],
	[2.7330000000E+04, 2.0771675000E+01, 5.2217755590E+00, 5.8809036953E+00, 2.4408692263E+00, 9.0726753390E-01],
	[2.7335000000E+04, 2.0777863098E+01, 5.2217547778E+00, 5.8843696113E+00, 2.4415470062E+00, 9.0731328927E-01],
	[2.7340000000E+04, 2.0784051907E+01, 5.2217340005E+00, 5.8878369332E+00, 2.4422246609E+00, 9.0735902091E-01],
	[2.7345000000E+04, 2.0790241428E+01, 5.2217132270E+00, 5.8913056614E+00, 2.4429021903E+00, 9.0740472882E-01],
	[2.7350000000E+04, 2.0796431660E+01, 5.2216924575E+00, 5.8947757960E+00, 2.4435795945E+00, 9.0745041302E-01],
	[2.7355000000E+04, 2.0802622602E+01, 5.2216716918E+00, 5.8982473375E+00, 2.4442568733E+00, 9.0749607351E-01],
	[2.7360000000E+04, 2.0808814256E+01, 5.2216509300E+00, 5.9017202861E+00, 2.4449340267E+00, 9.0754171031E-01],
	[2.7365000000E+04, 2.0815006621E+01, 5.2216301720E+00, 5.9051946421E+00, 2.4456110546E+00, 9.0758732343E-01],
	[2.7370000000E+04, 2.0821199696E+01, 5.2216094180E+00, 5.9086704059E+00, 2.4462879571E+00, 9.0763291287E-01],
	[2.7375000000E+04, 2.0827393483E+01, 5.2215886678E+00, 5.9121475778E+00, 2.4469647340E+00, 9.0767847866E-01],
	[2.7380000000E+04, 2.0833587980E+01, 5.2215679215E+00, 5.9156261580E+00, 2.4476413853E+00, 9.0772402079E-01],
	[2.7385000000E+04, 2.0839783188E+01, 5.2215471790E+00, 5.9191061470E+00, 2.4483179109E+00, 9.0776953929E-01],
	[2.7390000000E+04, 2.0845979107E+01, 5.2215264404E+00, 5.9225881696E+00, 2.4489944176E+00, 9.0781503415E-01],
	[2.7395000000E+04, 2.0852175736E+01, 5.2215057057E+00, 5.9260717784E+00, 2.4496708286E+00, 9.0786050540E-01],
	[2.7400000000E+04, 2.0858373076E+01, 5.2214849749E+00, 5.9295567977E+00, 2.4503471138E+00, 9.0790595304E-01],
	[2.7405000000E+04, 2.0864571126E+01, 5.2214642479E+00, 5.9330432277E+00, 2.4510232731E+00, 9.0795137709E-01],
	[2.7410000000E+04, 2.0870769888E+01, 5.2214435248E+00, 5.9365310689E+00, 2.4516993064E+00, 9.0799677755E-01],
	[2.7415000000E+04, 2.0876969359E+01, 5.2214228055E+00, 5.9400203214E+00, 2.4523752137E+00, 9.0804215444E-01],
	[2.7420000000E+04, 2.0883169541E+01, 5.2214020902E+00, 5.9435109857E+00, 2.4530509950E+00, 9.0808750776E-01],
	[2.7425000000E+04, 2.0889370433E+01, 5.2213813786E+00, 5.9470030619E+00, 2.4537266501E+00, 9.0813283753E-01],
	[2.7430000000E+04, 2.0895572036E+01, 5.2213606710E+00, 5.9504965506E+00, 2.4544021791E+00, 9.0817814376E-01],
	[2.7435000000E+04, 2.0901774349E+01, 5.2213399671E+00, 5.9539914518E+00, 2.4550775818E+00, 9.0822342646E-01],
	[2.7440000000E+04, 2.0907977372E+01, 5.2213192672E+00, 5.9574877660E+00, 2.4557528583E+00, 9.0826868564E-01],
	[2.7445000000E+04, 2.0914181106E+01, 5.2212985711E+00, 5.9609854935E+00, 2.4564280084E+00, 9.0831392131E-01],
	[2.7450000000E+04, 2.0920385549E+01, 5.2212778788E+00, 5.9644846346E+00, 2.4571030322E+00, 9.0835913348E-01],
	[2.7455000000E+04, 2.0926590703E+01, 5.2212571904E+00, 5.9679851896E+00, 2.4577779295E+00, 9.0840432216E-01],
	[2.7460000000E+04, 2.0932796566E+01, 5.2212365058E+00, 5.9714871588E+00, 2.4584527004E+00, 9.0844948737E-01],
	[2.7465000000E+04, 2.0939003140E+01, 5.2212158251E+00, 5.9749905425E+00, 2.4591273447E+00, 9.0849462911E-01],
	[2.7470000000E+04, 2.0945210424E+01, 5.2211951483E+00, 5.9784953410E+00, 2.4598018624E+00, 9.0853974740E-01],
	[2.7475000000E+04, 2.0951418417E+01, 5.2211744753E+00, 5.9820015547E+00, 2.4604762535E+00, 9.0858484224E-01],
	[2.7480000000E+04, 2.0957627120E+01, 5.2211538061E+00, 5.9855091839E+00, 2.4611505179E+00, 9.0862991366E-01],
	[2.7485000000E+04, 2.0963836533E+01, 5.2211331408E+00, 5.9890182288E+00, 2.4618246556E+00, 9.0867496165E-01],
	[2.7490000000E+04, 2.0970046656E+01, 5.2211124793E+00, 5.9925286898E+00, 2.4624986665E+00, 9.0871998622E-01],
	[2.7495000000E+04, 2.0976257489E+01, 5.2210918216E+00, 5.9960405672E+00, 2.4631725506E+00, 9.0876498740E-01],
	[2.7500000000E+04, 2.0982469031E+01, 5.2210711678E+00, 5.9995538613E+00, 2.4638463077E+00, 9.0880996519E-01],
	[2.7505000000E+04, 2.0988681283E+01, 5.2210505178E+00, 6.0030685724E+00, 2.4645199379E+00, 9.0885491960E-01],
	[2.7510000000E+04, 2.0994894244E+01, 5.2210298717E+00, 6.0065847008E+00, 2.4651934411E+00, 9.0889985065E-01],
	[2.7515000000E+04, 2.1001107915E+01, 5.2210092294E+00, 6.0101022469E+00, 2.4658668173E+00, 9.0894475833E-01],
	[2.7520000000E+04, 2.1007322296E+01, 5.2209885909E+00, 6.0136212110E+00, 2.4665400664E+00, 9.0898964267E-01],
	[2.7525000000E+04, 2.1013537385E+01, 5.2209679563E+00, 6.0171415933E+00, 2.4672131883E+00, 9.0903450368E-01],
	[2.7530000000E+04, 2.1019753184E+01, 5.2209473254E+00, 6.0206633942E+00, 2.4678861830E+00, 9.0907934136E-01],
	[2.7535000000E+04, 2.1025969693E+01, 5.2209266985E+00, 6.0241866140E+00, 2.4685590505E+00, 9.0912415573E-01],
	[2.7540000000E+04, 2.1032186911E+01, 5.2209060753E+00, 6.0277112530E+00, 2.4692317907E+00, 9.0916894680E-01],
	[2.7545000000E+04, 2.1038404838E+01, 5.2208854560E+00, 6.0312373116E+00, 2.4699044035E+00, 9.0921371458E-01],
	[2.7550000000E+04, 2.1044623474E+01, 5.2208648405E+00, 6.0347647899E+00, 2.4705768889E+00, 9.0925845908E-01],
	[2.7555000000E+04, 2.1050842819E+01, 5.2208442288E+00, 6.0382936884E+00, 2.4712492469E+00, 9.0930318030E-01],
	[2.7560000000E+04, 2.1057062873E+01, 5.2208236209E+00, 6.0418240074E+00, 2.4719214774E+00, 9.0934787827E-01],
	[2.7565000000E+04, 2.1063283637E+01, 5.2208030169E+00, 6.0453557471E+00, 2.4725935803E+00, 9.0939255300E-01],
	[2.7570000000E+04, 2.1069505109E+01, 5.2207824166E+00, 6.0488889079E+00, 2.4732655556E+00, 9.0943720448E-01],
	[2.7575000000E+04, 2.1075727290E+01, 5.2207618202E+00, 6.0524234901E+00, 2.4739374033E+00, 9.0948183274E-01],
	[2.7580000000E+04, 2.1081950181E+01, 5.2207412276E+00, 6.0559594940E+00, 2.4746091233E+00, 9.0952643779E-01],
	[2.7585000000E+04, 2.1088173780E+01, 5.2207206388E+00, 6.0594969200E+00, 2.4752807155E+00, 9.0957101963E-01],
	[2.7590000000E+04, 2.1094398088E+01, 5.2207000539E+00, 6.0630357682E+00, 2.4759521799E+00, 9.0961557828E-01],
	[2.7595000000E+04, 2.1100623104E+01, 5.2206794727E+00, 6.0665760391E+00, 2.4766235165E+00, 9.0966011375E-01],
	[2.7600000000E+04, 2.1106848829E+01, 5.2206588954E+00, 6.0701177330E+00, 2.4772947252E+00, 9.0970462605E-01],
	[2.7605000000E+04, 2.1113075263E+01, 5.2206383218E+00, 6.0736608501E+00, 2.4779658059E+00, 9.0974911519E-01],
	[2.7610000000E+04, 2.1119302406E+01, 5.2206177521E+00, 6.0772053908E+00, 2.4786367587E+00, 9.0979358118E-01],
	[2.7615000000E+04, 2.1125542881E+01, 5.2205989667E+00, 6.0807513554E+00, 2.4793081588E+00, 9.0983802403E-01],
	[2.7620000000E+04, 2.1131795455E+01, 5.2205817900E+00, 6.0842987443E+00, 2.4799799503E+00, 9.0988244375E-01],
	[2.7625000000E+04, 2.1138048747E+01, 5.2205646164E+00, 6.0878475576E+00, 2.4806516144E+00, 9.0992684036E-01],
	[2.7630000000E+04, 2.1144302757E+01, 5.2205474460E+00, 6.0913977958E+00, 2.4813231512E+00, 9.0997121386E-01],
	[2.7635000000E+04, 2.1150557485E+01, 5.2205302787E+00, 6.0949494591E+00, 2.4819945605E+00, 9.1001556427E-01],
	[2.7640000000E+04, 2.1156812931E+01, 5.2205131146E+00, 6.0985025479E+00, 2.4826658423E+00, 9.1005989160E-01],
	[2.7645000000E+04, 2.1163069096E+01, 5.2204959537E+00, 6.1020570624E+00, 2.4833369966E+00, 9.1010419585E-01],
	[2.7650000000E+04, 2.1169325978E+01, 5.2204787960E+00, 6.1056130030E+00, 2.4840080232E+00, 9.1014847705E-01],
	[2.7655000000E+04, 2.1175583579E+01, 5.2204616413E+00, 6.1091703700E+00, 2.4846789223E+00, 9.1019273519E-01],
	[2.7660000000E+04, 2.1181841898E+01, 5.2204444899E+00, 6.1127291638E+00, 2.4853496936E+00, 9.1023697029E-01],
	[2.7665000000E+04, 2.1188100934E+01, 5.2204273416E+00, 6.1162893845E+00, 2.4860203372E+00, 9.1028118237E-01],
	[2.7670000000E+04, 2.1194360688E+01, 5.2204101965E+00, 6.1198510326E+00, 2.4866908530E+00, 9.1032537143E-01],
	[2.7675000000E+04, 2.1200621161E+01, 5.2203930545E+00, 6.1234141083E+00, 2.4873612410E+00, 9.1036953748E-01],
	[2.7680000000E+04, 2.1206882351E+01, 5.2203759156E+00, 6.1269786120E+00, 2.4880315011E+00, 9.1041368054E-01],
	[2.7685000000E+04, 2.1213144258E+01, 5.2203587800E+00, 6.1305445440E+00, 2.4887016333E+00, 9.1045780061E-01],
	[2.7690000000E+04, 2.1219406883E+01, 5.2203416474E+00, 6.1341119046E+00, 2.4893716374E+00, 9.1050189771E-01],
	[2.7695000000E+04, 2.1225670226E+01, 5.2203245181E+00, 6.1376806940E+00, 2.4900415136E+00, 9.1054597184E-01],
	[2.7700000000E+04, 2.1231934287E+01, 5.2203073918E+00, 6.1412509127E+00, 2.4907112617E+00, 9.1059002303E-01],
	[2.7705000000E+04, 2.1238199065E+01, 5.2202902687E+00, 6.1448225609E+00, 2.4913808816E+00, 9.1063405127E-01],
	[2.7710000000E+04, 2.1244464561E+01, 5.2202731488E+00, 6.1483956389E+00, 2.4920503734E+00, 9.1067805659E-01],
	[2.7715000000E+04, 2.1250730774E+01, 5.2202560320E+00, 6.1519701470E+00, 2.4927197369E+00, 9.1072203899E-01],
	[2.7720000000E+04, 2.1256997704E+01, 5.2202389184E+00, 6.1555460857E+00, 2.4933889722E+00, 9.1076599848E-01],
	[2.7725000000E+04, 2.1263265352E+01, 5.2202218079E+00, 6.1591234551E+00, 2.4940580792E+00, 9.1080993507E-01],
	[2.7730000000E+04, 2.1269533717E+01, 5.2202047005E+00, 6.1627022556E+00, 2.4947270578E+00, 9.1085384878E-01],
	[2.7735000000E+04, 2.1275802799E+01, 5.2201875963E+00, 6.1662824875E+00, 2.4953959080E+00, 9.1089773961E-01],
	[2.7740000000E+04, 2.1282072599E+01, 5.2201704952E+00, 6.1698641511E+00, 2.4960646298E+00, 9.1094160758E-01],
	[2.7745000000E+04, 2.1288343115E+01, 5.2201533972E+00, 6.1734472467E+00, 2.4967332230E+00, 9.1098545270E-01],
	[2.7750000000E+04, 2.1294614349E+01, 5.2201363024E+00, 6.1770317747E+00, 2.4974016877E+00, 9.1102927497E-01],
	[2.7755000000E+04, 2.1300886300E+01, 5.2201192108E+00, 6.1806177353E+00, 2.4980700238E+00, 9.1107307442E-01],
	[2.7760000000E+04, 2.1307158968E+01, 5.2201021222E+00, 6.1842051289E+00, 2.4987382312E+00, 9.1111685104E-01],
	[2.7765000000E+04, 2.1313432353E+01, 5.2200850368E+00, 6.1877939558E+00, 2.4994063100E+00, 9.1116060486E-01],
	[2.7770000000E+04, 2.1319706454E+01, 5.2200679545E+00, 6.1913842163E+00, 2.5000742600E+00, 9.1120433588E-01],
	[2.7775000000E+04, 2.1325981273E+01, 5.2200508754E+00, 6.1949759106E+00, 2.5007420812E+00, 9.1124804411E-01],
	[2.7780000000E+04, 2.1332256809E+01, 5.2200337994E+00, 6.1985690392E+00, 2.5014097736E+00, 9.1129172957E-01],
	[2.7785000000E+04, 2.1338533061E+01, 5.2200167265E+00, 6.2021636023E+00, 2.5020773371E+00, 9.1133539226E-01],
	[2.7790000000E+04, 2.1344810030E+01, 5.2199996568E+00, 6.2057596003E+00, 2.5027447717E+00, 9.1137903220E-01],
	[2.7795000000E+04, 2.1351087715E+01, 5.2199825901E+00, 6.2093570334E+00, 2.5034120773E+00, 9.1142264940E-01],
	[2.7800000000E+04, 2.1357366118E+01, 5.2199655266E+00, 6.2129559020E+00, 2.5040792539E+00, 9.1146624387E-01],
	[2.7805000000E+04, 2.1363645237E+01, 5.2199484662E+00, 6.2165562064E+00, 2.5047463015E+00, 9.1150981561E-01],
	[2.7810000000E+04, 2.1369925072E+01, 5.2199314090E+00, 6.2201579468E+00, 2.5054132199E+00, 9.1155336465E-01],
	[2.7815000000E+04, 2.1376205624E+01, 5.2199143549E+00, 6.2237611237E+00, 2.5060800091E+00, 9.1159689099E-01],
	[2.7820000000E+04, 2.1382486892E+01, 5.2198973038E+00, 6.2273657373E+00, 2.5067466692E+00, 9.1164039464E-01],
	[2.7825000000E+04, 2.1388768877E+01, 5.2198802560E+00, 6.2309717879E+00, 2.5074132000E+00, 9.1168387561E-01],
	[2.7830000000E+04, 2.1395051578E+01, 5.2198632112E+00, 6.2345792759E+00, 2.5080796015E+00, 9.1172733392E-01],
	[2.7835000000E+04, 2.1401334996E+01, 5.2198461695E+00, 6.2381882016E+00, 2.5087458737E+00, 9.1177076957E-01],
	[2.7840000000E+04, 2.1407619130E+01, 5.2198291310E+00, 6.2417985652E+00, 2.5094120165E+00, 9.1181418258E-01],
	[2.7845000000E+04, 2.1413903980E+01, 5.2198120956E+00, 6.2454103671E+00, 2.5100780299E+00, 9.1185757296E-01],
	[2.7850000000E+04, 2.1420189546E+01, 5.2197950633E+00, 6.2490236076E+00, 2.5107439137E+00, 9.1190094072E-01],
	[2.7855000000E+04, 2.1426475828E+01, 5.2197780341E+00, 6.2526382870E+00, 2.5114096681E+00, 9.1194428587E-01],
	[2.7860000000E+04, 2.1432762826E+01, 5.2197610080E+00, 6.2562544056E+00, 2.5120752929E+00, 9.1198760842E-01],
	[2.7865000000E+04, 2.1439050540E+01, 5.2197439850E+00, 6.2598719638E+00, 2.5127407881E+00, 9.1203090838E-01],
	[2.7870000000E+04, 2.1445338971E+01, 5.2197269651E+00, 6.2634909618E+00, 2.5134061536E+00, 9.1207418576E-01],
	[2.7875000000E+04, 2.1451628117E+01, 5.2197099484E+00, 6.2671114000E+00, 2.5140713894E+00, 9.1211744057E-01],
	[2.7880000000E+04, 2.1457917979E+01, 5.2196929347E+00, 6.2707332787E+00, 2.5147364955E+00, 9.1216067284E-01],
	[2.7885000000E+04, 2.1464208557E+01, 5.2196759242E+00, 6.2743565982E+00, 2.5154014718E+00, 9.1220388255E-01],
	[2.7890000000E+04, 2.1470499851E+01, 5.2196589168E+00, 6.2779813588E+00, 2.5160663182E+00, 9.1224706974E-01],
	[2.7895000000E+04, 2.1476791860E+01, 5.2196419124E+00, 6.2816075608E+00, 2.5167310348E+00, 9.1229023440E-01],
	[2.7900000000E+04, 2.1483084586E+01, 5.2196249112E+00, 6.2852352045E+00, 2.5173956214E+00, 9.1233337655E-01],
	[2.7905000000E+04, 2.1489378027E+01, 5.2196079131E+00, 6.2888642903E+00, 2.5180600780E+00, 9.1237649620E-01],
	[2.7910000000E+04, 2.1495672183E+01, 5.2195909181E+00, 6.2924948184E+00, 2.5187244047E+00, 9.1241959336E-01],
	[2.7915000000E+04, 2.1501967055E+01, 5.2195739261E+00, 6.2961267892E+00, 2.5193886013E+00, 9.1246266805E-01],
	[2.7920000000E+04, 2.1508262643E+01, 5.2195569373E+00, 6.2997602030E+00, 2.5200526677E+00, 9.1250572027E-01],
	[2.7925000000E+04, 2.1514558946E+01, 5.2195399516E+00, 6.3033950601E+00, 2.5207166041E+00, 9.1254875003E-01],
	[2.7930000000E+04, 2.1520855964E+01, 5.2195229689E+00, 6.3070313608E+00, 2.5213804102E+00, 9.1259175734E-01],
	[2.7935000000E+04, 2.1527153698E+01, 5.2195059894E+00, 6.3106691055E+00, 2.5220440861E+00, 9.1263474223E-01],
	[2.7940000000E+04, 2.1533452147E+01, 5.2194890130E+00, 6.3143082943E+00, 2.5227076317E+00, 9.1267770469E-01],
	[2.7945000000E+04, 2.1539751311E+01, 5.2194720396E+00, 6.3179489278E+00, 2.5233710470E+00, 9.1272064474E-01],
	[2.7950000000E+04, 2.1546051191E+01, 5.2194550693E+00, 6.3215910061E+00, 2.5240343319E+00, 9.1276356238E-01],
	[2.7955000000E+04, 2.1552351786E+01, 5.2194381022E+00, 6.3252345295E+00, 2.5246974864E+00, 9.1280645764E-01],
	[2.7960000000E+04, 2.1558653096E+01, 5.2194211381E+00, 6.3288794985E+00, 2.5253605105E+00, 9.1284933052E-01],
	[2.7965000000E+04, 2.1564955121E+01, 5.2194041771E+00, 6.3325259133E+00, 2.5260234041E+00, 9.1289218103E-01],
	[2.7970000000E+04, 2.1571257861E+01, 5.2193872192E+00, 6.3361737741E+00, 2.5266861671E+00, 9.1293500919E-01],
	[2.7975000000E+04, 2.1577561316E+01, 5.2193702644E+00, 6.3398230815E+00, 2.5273487995E+00, 9.1297781500E-01],
	[2.7980000000E+04, 2.1583865486E+01, 5.2193533127E+00, 6.3434738355E+00, 2.5280113013E+00, 9.1302059848E-01],
	[2.7985000000E+04, 2.1590170371E+01, 5.2193363640E+00, 6.3471260367E+00, 2.5286736724E+00, 9.1306335963E-01],
	[2.7990000000E+04, 2.1596475971E+01, 5.2193194184E+00, 6.3507796852E+00, 2.5293359128E+00, 9.1310609847E-01],
	[2.7995000000E+04, 2.1602782285E+01, 5.2193024760E+00, 6.3544347813E+00, 2.5299980225E+00, 9.1314881501E-01],
	[2.8000000000E+04, 2.1609089315E+01, 5.2192855366E+00, 6.3580913255E+00, 2.5306600013E+00, 9.1319150926E-01],
	[2.8005000000E+04, 2.1615397059E+01, 5.2192686002E+00, 6.3617493180E+00, 2.5313218493E+00, 9.1323418123E-01],
	[2.8010000000E+04, 2.1621705518E+01, 5.2192516670E+00, 6.3654087592E+00, 2.5319835664E+00, 9.1327683093E-01],
	[2.8015000000E+04, 2.1628014691E+01, 5.2192347368E+00, 6.3690696492E+00, 2.5326451526E+00, 9.1331945837E-01],
	[2.8020000000E+04, 2.1634324579E+01, 5.2192178097E+00, 6.3727319886E+00, 2.5333066078E+00, 9.1336206357E-01],
	[2.8025000000E+04, 2.1640635182E+01, 5.2192008857E+00, 6.3763957774E+00, 2.5339679320E+00, 9.1340464653E-01],
	[2.8030000000E+04, 2.1646946499E+01, 5.2191839648E+00, 6.3800610162E+00, 2.5346291251E+00, 9.1344720727E-01],
	[2.8035000000E+04, 2.1653258530E+01, 5.2191670469E+00, 6.3837277052E+00, 2.5352901871E+00, 9.1348974580E-01],
	[2.8040000000E+04, 2.1659571276E+01, 5.2191501321E+00, 6.3873958447E+00, 2.5359511180E+00, 9.1353226212E-01],
	[2.8045000000E+04, 2.1665884736E+01, 5.2191332204E+00, 6.3910654350E+00, 2.5366119177E+00, 9.1357475626E-01],
	[2.8050000000E+04, 2.1672198910E+01, 5.2191163117E+00, 6.3947364764E+00, 2.5372725862E+00, 9.1361722821E-01],
	[2.8055000000E+04, 2.1678513799E+01, 5.2190994061E+00, 6.3984089693E+00, 2.5379331234E+00, 9.1365967800E-01],
	[2.8060000000E+04, 2.1684844210E+01, 5.2190845690E+00, 6.4020829139E+00, 2.5385942209E+00, 9.1370210563E-01],
	[2.8065000000E+04, 2.1691184358E+01, 5.2190709920E+00, 6.4057583106E+00, 2.5392556087E+00, 9.1374451111E-01],
	[2.8070000000E+04, 2.1697525230E+01, 5.2190574174E+00, 6.4094351598E+00, 2.5399168659E+00, 9.1378689445E-01],
	[2.8075000000E+04, 2.1703866826E+01, 5.2190438453E+00, 6.4131134616E+00, 2.5405779925E+00, 9.1382925567E-01],
	[2.8080000000E+04, 2.1710209145E+01, 5.2190302756E+00, 6.4167932164E+00, 2.5412389883E+00, 9.1387159478E-01],
	[2.8085000000E+04, 2.1716552188E+01, 5.2190167084E+00, 6.4204744246E+00, 2.5418998534E+00, 9.1391391179E-01],
	[2.8090000000E+04, 2.1722895955E+01, 5.2190031436E+00, 6.4241570864E+00, 2.5425605877E+00, 9.1395620670E-01],
	[2.8095000000E+04, 2.1729240445E+01, 5.2189895813E+00, 6.4278412021E+00, 2.5432211912E+00, 9.1399847953E-01],
	[2.8100000000E+04, 2.1735585658E+01, 5.2189760214E+00, 6.4315267722E+00, 2.5438816638E+00, 9.1404073030E-01],
	[2.8105000000E+04, 2.1741931595E+01, 5.2189624640E+00, 6.4352137968E+00, 2.5445420055E+00, 9.1408295901E-01],
	[2.8110000000E+04, 2.1748278256E+01, 5.2189489090E+00, 6.4389022763E+00, 2.5452022162E+00, 9.1412516566E-01],
	[2.8115000000E+04, 2.1754625640E+01, 5.2189353565E+00, 6.4425922111E+00, 2.5458622960E+00, 9.1416735029E-01],
	[2.8120000000E+04, 2.1760973747E+01, 5.2189218064E+00, 6.4462836014E+00, 2.5465222447E+00, 9.1420951289E-01],
	[2.8125000000E+04, 2.1767322577E+01, 5.2189082588E+00, 6.4499764475E+00, 2.5471820623E+00, 9.1425165347E-01],
	[2.8130000000E+04, 2.1773672131E+01, 5.2188947136E+00, 6.4536707497E+00, 2.5478417488E+00, 9.1429377205E-01],
	[2.8135000000E+04, 2.1780022408E+01, 5.2188811708E+00, 6.4573665085E+00, 2.5485013041E+00, 9.1433586864E-01],
	[2.8140000000E+04, 2.1786373407E+01, 5.2188676305E+00, 6.4610637240E+00, 2.5491607283E+00, 9.1437794325E-01],
	[2.8145000000E+04, 2.1792725130E+01, 5.2188540926E+00, 6.4647623966E+00, 2.5498200212E+00, 9.1441999589E-01],
	[2.8150000000E+04, 2.1799077576E+01, 5.2188405572E+00, 6.4684625266E+00, 2.5504791828E+00, 9.1446202657E-01],
	[2.8155000000E+04, 2.1805430745E+01, 5.2188270242E+00, 6.4721641144E+00, 2.5511382131E+00, 9.1450403530E-01],
	[2.8160000000E+04, 2.1811784637E+01, 5.2188134936E+00, 6.4758671601E+00, 2.5517971120E+00, 9.1454602209E-01],
	[2.8165000000E+04, 2.1818139252E+01, 5.2187999655E+00, 6.4795716643E+00, 2.5524558795E+00, 9.1458798696E-01],
	[2.8170000000E+04, 2.1824494590E+01, 5.2187864398E+00, 6.4832776271E+00, 2.5531145156E+00, 9.1462992992E-01],
	[2.8175000000E+04, 2.1830850650E+01, 5.2187729166E+00, 6.4869850489E+00, 2.5537730202E+00, 9.1467185097E-01],
	[2.8180000000E+04, 2.1837207434E+01, 5.2187593958E+00, 6.4906939299E+00, 2.5544313932E+00, 9.1471375013E-01],
	[2.8185000000E+04, 2.1843564939E+01, 5.2187458774E+00, 6.4944042706E+00, 2.5550896347E+00, 9.1475562741E-01],
	[2.8190000000E+04, 2.1849923168E+01, 5.2187323614E+00, 6.4981160712E+00, 2.5557477446E+00, 9.1479748282E-01],
	[2.8195000000E+04, 2.1856282119E+01, 5.2187188479E+00, 6.5018293320E+00, 2.5564057228E+00, 9.1483931636E-01],
	[2.8200000000E+04, 2.1862641793E+01, 5.2187053368E+00, 6.5055440534E+00, 2.5570635694E+00, 9.1488112807E-01],
	[2.8205000000E+04, 2.1869002189E+01, 5.2186918282E+00, 6.5092602357E+00, 2.5577212842E+00, 9.1492291793E-01],
	[2.8210000000E+04, 2.1875363308E+01, 5.2186783220E+00, 6.5129778791E+00, 2.5583788672E+00, 9.1496468596E-01],
	[2.8215000000E+04, 2.1881725149E+01, 5.2186648182E+00, 6.5166969840E+00, 2.5590363185E+00, 9.1500643218E-01],
	[2.8220000000E+04, 2.1888087713E+01, 5.2186513168E+00, 6.5204175507E+00, 2.5596936379E+00, 9.1504815660E-01],
	[2.8225000000E+04, 2.1894450999E+01, 5.2186378178E+00, 6.5241395796E+00, 2.5603508254E+00, 9.1508985921E-01],
	[2.8230000000E+04, 2.1900815007E+01, 5.2186243213E+00, 6.5278630709E+00, 2.5610078810E+00, 9.1513154005E-01],
	[2.8235000000E+04, 2.1907179738E+01, 5.2186108272E+00, 6.5315880249E+00, 2.5616648046E+00, 9.1517319910E-01],
	[2.8240000000E+04, 2.1913545190E+01, 5.2185973356E+00, 6.5353144420E+00, 2.5623215962E+00, 9.1521483639E-01],
	[2.8245000000E+04, 2.1919911365E+01, 5.2185838463E+00, 6.5390423224E+00, 2.5629782558E+00, 9.1525645192E-01],
	[2.8250000000E+04, 2.1926278262E+01, 5.2185703595E+00, 6.5427716666E+00, 2.5636347833E+00, 9.1529804571E-01],
	[2.8255000000E+04, 2.1932645881E+01, 5.2185568751E+00, 6.5465024747E+00, 2.5642911787E+00, 9.1533961777E-01],
	[2.8260000000E+04, 2.1939014222E+01, 5.2185433931E+00, 6.5502347472E+00, 2.5649474419E+00, 9.1538116810E-01],
	[2.8265000000E+04, 2.1945383285E+01, 5.2185299136E+00, 6.5539684843E+00, 2.5656035729E+00, 9.1542269671E-01],
	[2.8270000000E+04, 2.1951753070E+01, 5.2185164364E+00, 6.5577036863E+00, 2.5662595717E+00, 9.1546420362E-01],
	[2.8275000000E+04, 2.1958123577E+01, 5.2185029617E+00, 6.5614403536E+00, 2.5669154382E+00, 9.1550568884E-01],
	[2.8280000000E+04, 2.1964494806E+01, 5.2184894894E+00, 6.5651784865E+00, 2.5675711723E+00, 9.1554715237E-01],
	[2.8285000000E+04, 2.1970866756E+01, 5.2184760195E+00, 6.5689180852E+00, 2.5682267742E+00, 9.1558859423E-01],
	[2.8290000000E+04, 2.1977239428E+01, 5.2184625521E+00, 6.5726591502E+00, 2.5688822436E+00, 9.1563001442E-01],
	[2.8295000000E+04, 2.1983612822E+01, 5.2184490870E+00, 6.5764016817E+00, 2.5695375806E+00, 9.1567141297E-01],
	[2.8300000000E+04, 2.1989986938E+01, 5.2184356244E+00, 6.5801456800E+00, 2.5701927851E+00, 9.1571278987E-01],
	[2.8305000000E+04, 2.1996361775E+01, 5.2184221641E+00, 6.5838911454E+00, 2.5708478571E+00, 9.1575414513E-01],
	[2.8310000000E+04, 2.2002737334E+01, 5.2184087063E+00, 6.5876380784E+00, 2.5715027966E+00, 9.1579547878E-01],
	[2.8315000000E+04, 2.2009113614E+01, 5.2183952509E+00, 6.5913864790E+00, 2.5721576035E+00, 9.1583679081E-01],
	[2.8320000000E+04, 2.2015490616E+01, 5.2183817979E+00, 6.5951363478E+00, 2.5728122777E+00, 9.1587808124E-01],
	[2.8325000000E+04, 2.2021868339E+01, 5.2183683473E+00, 6.5988876850E+00, 2.5734668193E+00, 9.1591935008E-01],
	[2.8330000000E+04, 2.2028246783E+01, 5.2183548992E+00, 6.6026404909E+00, 2.5741212283E+00, 9.1596059733E-01],
	[2.8335000000E+04, 2.2034625949E+01, 5.2183414534E+00, 6.6063947658E+00, 2.5747755044E+00, 9.1600182302E-01],
	[2.8340000000E+04, 2.2041005836E+01, 5.2183280100E+00, 6.6101505101E+00, 2.5754296478E+00, 9.1604302714E-01],
	[2.8345000000E+04, 2.2047386444E+01, 5.2183145691E+00, 6.6139077240E+00, 2.5760836584E+00, 9.1608420972E-01],
	[2.8350000000E+04, 2.2053767774E+01, 5.2183011305E+00, 6.6176664079E+00, 2.5767375361E+00, 9.1612537075E-01],
	[2.8355000000E+04, 2.2060149825E+01, 5.2182876944E+00, 6.6214265620E+00, 2.5773912809E+00, 9.1616651026E-01],
	[2.8360000000E+04, 2.2066532596E+01, 5.2182742606E+00, 6.6251881868E+00, 2.5780448929E+00, 9.1620762824E-01],
	[2.8365000000E+04, 2.2072916089E+01, 5.2182608293E+00, 6.6289512825E+00, 2.5786983718E+00, 9.1624872471E-01],
	[2.8370000000E+04, 2.2079300303E+01, 5.2182474004E+00, 6.6327158494E+00, 2.5793517178E+00, 9.1628979969E-01],
	[2.8375000000E+04, 2.2085685238E+01, 5.2182339738E+00, 6.6364818879E+00, 2.5800049307E+00, 9.1633085317E-01],
	[2.8380000000E+04, 2.2092070894E+01, 5.2182205497E+00, 6.6402493982E+00, 2.5806580105E+00, 9.1637188518E-01],
	[2.8385000000E+04, 2.2098457270E+01, 5.2182071280E+00, 6.6440183807E+00, 2.5813109572E+00, 9.1641289572E-01],
	[2.8390000000E+04, 2.2104844368E+01, 5.2181937086E+00, 6.6477888357E+00, 2.5819637708E+00, 9.1645388480E-01],
	[2.8395000000E+04, 2.2111232186E+01, 5.2181802917E+00, 6.6515607635E+00, 2.5826164512E+00, 9.1649485243E-01],
	[2.8400000000E+04, 2.2117620725E+01, 5.2181668771E+00, 6.6553341644E+00, 2.5832689984E+00, 9.1653579863E-01],
	[2.8405000000E+04, 2.2124009985E+01, 5.2181534650E+00, 6.6591090387E+00, 2.5839214123E+00, 9.1657672339E-01],
	[2.8410000000E+04, 2.2130399965E+01, 5.2181400552E+00, 6.6628853868E+00, 2.5845736929E+00, 9.1661762674E-01],
	[2.8415000000E+04, 2.2136790666E+01, 5.2181266479E+00, 6.6666632090E+00, 2.5852258402E+00, 9.1665850869E-01],
	[2.8420000000E+04, 2.2143182087E+01, 5.2181132429E+00, 6.6704425055E+00, 2.5858778541E+00, 9.1669936923E-01],
	[2.8425000000E+04, 2.2149574229E+01, 5.2180998404E+00, 6.6742232767E+00, 2.5865297346E+00, 9.1674020839E-01],
	[2.8430000000E+04, 2.2155967092E+01, 5.2180864402E+00, 6.6780055229E+00, 2.5871814817E+00, 9.1678102618E-01],
	[2.8435000000E+04, 2.2162360675E+01, 5.2180730424E+00, 6.6817892444E+00, 2.5878330952E+00, 9.1682182259E-01],
	[2.8440000000E+04, 2.2168754978E+01, 5.2180596470E+00, 6.6855744415E+00, 2.5884845753E+00, 9.1686259766E-01],
	[2.8445000000E+04, 2.2175150002E+01, 5.2180462540E+00, 6.6893611146E+00, 2.5891359218E+00, 9.1690335137E-01],
	[2.8450000000E+04, 2.2181545745E+01, 5.2180328634E+00, 6.6931492640E+00, 2.5897871348E+00, 9.1694408376E-01],
	[2.8455000000E+04, 2.2187942209E+01, 5.2180194751E+00, 6.6969388899E+00, 2.5904382141E+00, 9.1698479482E-01],
	[2.8460000000E+04, 2.2194339394E+01, 5.2180060893E+00, 6.7007299927E+00, 2.5910891597E+00, 9.1702548456E-01],
	[2.8465000000E+04, 2.2200737298E+01, 5.2179927058E+00, 6.7045225727E+00, 2.5917399717E+00, 9.1706615300E-01],
	[2.8470000000E+04, 2.2207135923E+01, 5.2179793247E+00, 6.7083166303E+00, 2.5923906499E+00, 9.1710680014E-01],
	[2.8475000000E+04, 2.2213535267E+01, 5.2179659460E+00, 6.7121121656E+00, 2.5930411944E+00, 9.1714742601E-01],
	[2.8480000000E+04, 2.2219935332E+01, 5.2179525697E+00, 6.7159091792E+00, 2.5936916051E+00, 9.1718803060E-01],
	[2.8485000000E+04, 2.2226336116E+01, 5.2179391958E+00, 6.7197076711E+00, 2.5943418819E+00, 9.1722861392E-01],
	[2.8490000000E+04, 2.2232737621E+01, 5.2179258243E+00, 6.7235076419E+00, 2.5949920248E+00, 9.1726917600E-01],
	[2.8495000000E+04, 2.2239139845E+01, 5.2179124551E+00, 6.7273090917E+00, 2.5956420339E+00, 9.1730971683E-01],
	[2.8500000000E+04, 2.2245542789E+01, 5.2178990883E+00, 6.7311120210E+00, 2.5962919090E+00, 9.1735023643E-01],
	[2.8505000000E+04, 2.2251946453E+01, 5.2178857239E+00, 6.7349164300E+00, 2.5969416501E+00, 9.1739073481E-01],
	[2.8510000000E+04, 2.2258357597E+01, 5.2178732947E+00, 6.7387223190E+00, 2.5975915805E+00, 9.1743121198E-01],
	[2.8515000000E+04, 2.2264786340E+01, 5.2178631961E+00, 6.7425296883E+00, 2.5982421842E+00, 9.1747166794E-01],
	[2.8520000000E+04, 2.2271215813E+01, 5.2178530993E+00, 6.7463385384E+00, 2.5988926546E+00, 9.1751210272E-01],
	[2.8525000000E+04, 2.2277646015E+01, 5.2178430043E+00, 6.7501488694E+00, 2.5995429916E+00, 9.1755251631E-01],
	[2.8530000000E+04, 2.2284076946E+01, 5.2178329111E+00, 6.7539606817E+00, 2.6001931952E+00, 9.1759290874E-01],
	[2.8535000000E+04, 2.2290508606E+01, 5.2178228196E+00, 6.7577739756E+00, 2.6008432653E+00, 9.1763328000E-01],
	[2.8540000000E+04, 2.2296940995E+01, 5.2178127300E+00, 6.7615887514E+00, 2.6014932020E+00, 9.1767363012E-01],
	[2.8545000000E+04, 2.2303374112E+01, 5.2178026421E+00, 6.7654050095E+00, 2.6021430052E+00, 9.1771395910E-01],
	[2.8550000000E+04, 2.2309807959E+01, 5.2177925560E+00, 6.7692227501E+00, 2.6027926749E+00, 9.1775426695E-01],
	[2.8555000000E+04, 2.2316242534E+01, 5.2177824717E+00, 6.7730419736E+00, 2.6034422109E+00, 9.1779455368E-01],
	[2.8560000000E+04, 2.2322677839E+01, 5.2177723892E+00, 6.7768626802E+00, 2.6040916134E+00, 9.1783481930E-01],
	[2.8565000000E+04, 2.2329113871E+01, 5.2177623085E+00, 6.7806848704E+00, 2.6047408822E+00, 9.1787506382E-01],
	[2.8570000000E+04, 2.2335550633E+01, 5.2177522296E+00, 6.7845085444E+00, 2.6053900173E+00, 9.1791528726E-01],
	[2.8575000000E+04, 2.2341988123E+01, 5.2177421524E+00, 6.7883337025E+00, 2.6060390187E+00, 9.1795548962E-01],
	[2.8580000000E+04, 2.2348426342E+01, 5.2177320770E+00, 6.7921603450E+00, 2.6066878864E+00, 9.1799567091E-01],
	[2.8585000000E+04, 2.2354865289E+01, 5.2177220035E+00, 6.7959884723E+00, 2.6073366203E+00, 9.1803583115E-01],
	[2.8590000000E+04, 2.2361304965E+01, 5.2177119317E+00, 6.7998180847E+00, 2.6079852203E+00, 9.1807597034E-01],
	[2.8595000000E+04, 2.2367745370E+01, 5.2177018616E+00, 6.8036491824E+00, 2.6086336865E+00, 9.1811608849E-01],
	[2.8600000000E+04, 2.2374186502E+01, 5.2176917934E+00, 6.8074817659E+00, 2.6092820188E+00, 9.1815618562E-01],
	[2.8605000000E+04, 2.2380628363E+01, 5.2176817269E+00, 6.8113158353E+00, 2.6099302172E+00, 9.1819626173E-01],
	[2.8610000000E+04, 2.2387070953E+01, 5.2176716622E+00, 6.8151513911E+00, 2.6105782817E+00, 9.1823631684E-01],
	[2.8615000000E+04, 2.2393514270E+01, 5.2176615993E+00, 6.8189884336E+00, 2.6112262122E+00, 9.1827635095E-01],
	[2.8620000000E+04, 2.2399958316E+01, 5.2176515382E+00, 6.8228269630E+00, 2.6118740086E+00, 9.1831636408E-01],
	[2.8625000000E+04, 2.2406403090E+01, 5.2176414788E+00, 6.8266669796E+00, 2.6125216710E+00, 9.1835635624E-01],
	[2.8630000000E+04, 2.2412848593E+01, 5.2176314212E+00, 6.8305084839E+00, 2.6131691993E+00, 9.1839632743E-01],
	[2.8635000000E+04, 2.2419294823E+01, 5.2176213654E+00, 6.8343514761E+00, 2.6138165934E+00, 9.1843627767E-01],
	[2.8640000000E+04, 2.2425741781E+01, 5.2176113114E+00, 6.8381959565E+00, 2.6144638534E+00, 9.1847620697E-01],
	[2.8645000000E+04, 2.2432189467E+01, 5.2176012591E+00, 6.8420419254E+00, 2.6151109793E+00, 9.1851611533E-01],
	[2.8650000000E+04, 2.2438637882E+01, 5.2175912087E+00, 6.8458893832E+00, 2.6157579709E+00, 9.1855600277E-01],
	[2.8655000000E+04, 2.2445087024E+01, 5.2175811600E+00, 6.8497383301E+00, 2.6164048282E+00, 9.1859586930E-01],
	[2.8660000000E+04, 2.2451536894E+01, 5.2175711130E+00, 6.8535887665E+00, 2.6170515513E+00, 9.1863571493E-01],
	[2.8665000000E+04, 2.2457987492E+01, 5.2175610679E+00, 6.8574406927E+00, 2.6176981400E+00, 9.1867553967E-01],
	[2.8670000000E+04, 2.2464438818E+01, 5.2175510245E+00, 6.8612941090E+00, 2.6183445944E+00, 9.1871534352E-01],
	[2.8675000000E+04, 2.2470890871E+01, 5.2175409828E+00, 6.8651490158E+00, 2.6189909144E+00, 9.1875512651E-01],
	[2.8680000000E+04, 2.2477343652E+01, 5.2175309430E+00, 6.8690054133E+00, 2.6196370999E+00, 9.1879488863E-01],
	[2.8685000000E+04, 2.2483797161E+01, 5.2175209049E+00, 6.8728633018E+00, 2.6202831510E+00, 9.1883462991E-01],
	[2.8690000000E+04, 2.2490251397E+01, 5.2175108686E+00, 6.8767226817E+00, 2.6209290677E+00, 9.1887435034E-01],
	[2.8695000000E+04, 2.2496706361E+01, 5.2175008341E+00, 6.8805835533E+00, 2.6215748498E+00, 9.1891404995E-01],
	[2.8700000000E+04, 2.2503162053E+01, 5.2174908013E+00, 6.8844459169E+00, 2.6222204973E+00, 9.1895372874E-01],
	[2.8705000000E+04, 2.2509618471E+01, 5.2174807703E+00, 6.8883097728E+00, 2.6228660103E+00, 9.1899338672E-01],
	[2.8710000000E+04, 2.2516075618E+01, 5.2174707410E+00, 6.8921751213E+00, 2.6235113887E+00, 9.1903302390E-01],
	[2.8715000000E+04, 2.2522533491E+01, 5.2174607135E+00, 6.8960419628E+00, 2.6241566324E+00, 9.1907264029E-01],
	[2.8720000000E+04, 2.2528992092E+01, 5.2174506878E+00, 6.8999102975E+00, 2.6248017414E+00, 9.1911223591E-01],
	[2.8725000000E+04, 2.2535451421E+01, 5.2174406639E+00, 6.9037801258E+00, 2.6254467157E+00, 9.1915181076E-01],
	[2.8730000000E+04, 2.2541911476E+01, 5.2174306417E+00, 6.9076514480E+00, 2.6260915553E+00, 9.1919136485E-01],
	[2.8735000000E+04, 2.2548372259E+01, 5.2174206213E+00, 6.9115242644E+00, 2.6267362601E+00, 9.1923089820E-01],
	[2.8740000000E+04, 2.2554833769E+01, 5.2174106026E+00, 6.9153985753E+00, 2.6273808300E+00, 9.1927041081E-01],
	[2.8745000000E+04, 2.2561296006E+01, 5.2174005857E+00, 6.9192743811E+00, 2.6280252652E+00, 9.1930990269E-01],
	[2.8750000000E+04, 2.2567758970E+01, 5.2173905706E+00, 6.9231516820E+00, 2.6286695654E+00, 9.1934937386E-01],
	[2.8755000000E+04, 2.2574222661E+01, 5.2173805572E+00, 6.9270304784E+00, 2.6293137308E+00, 9.1938882432E-01],
	[2.8760000000E+04, 2.2580687079E+01, 5.2173705456E+00, 6.9309107705E+00, 2.6299577612E+00, 9.1942825409E-01],
	[2.8765000000E+04, 2.2587152224E+01, 5.2173605358E+00, 6.9347925588E+00, 2.6306016567E+00, 9.1946766318E-01],
	[2.8770000000E+04, 2.2593618096E+01, 5.2173505277E+00, 6.9386758434E+00, 2.6312454171E+00, 9.1950705159E-01],
	[2.8775000000E+04, 2.2600084694E+01, 5.2173405213E+00, 6.9425606248E+00, 2.6318890426E+00, 9.1954641934E-01],
	[2.8780000000E+04, 2.2606552020E+01, 5.2173305167E+00, 6.9464469032E+00, 2.6325325329E+00, 9.1958576643E-01],
	[2.8785000000E+04, 2.2613020072E+01, 5.2173205139E+00, 6.9503346790E+00, 2.6331758882E+00, 9.1962509288E-01],
	[2.8790000000E+04, 2.2619488851E+01, 5.2173105129E+00, 6.9542239525E+00, 2.6338191083E+00, 9.1966439870E-01],
	[2.8795000000E+04, 2.2625958357E+01, 5.2173005135E+00, 6.9581147239E+00, 2.6344621933E+00, 9.1970368390E-01],
	[2.8800000000E+04, 2.2632428589E+01, 5.2172905160E+00, 6.9620069937E+00, 2.6351051431E+00, 9.1974294848E-01],
	[2.8805000000E+04, 2.2638899548E+01, 5.2172805202E+00, 6.9659007620E+00, 2.6357479577E+00, 9.1978219246E-01],
	[2.8810000000E+04, 2.2645371233E+01, 5.2172705261E+00, 6.9697960293E+00, 2.6363906370E+00, 9.1982141586E-01],
	[2.8815000000E+04, 2.2651843645E+01, 5.2172605339E+00, 6.9736927959E+00, 2.6370331811E+00, 9.1986061867E-01],
	[2.8820000000E+04, 2.2658316783E+01, 5.2172505433E+00, 6.9775910620E+00, 2.6376755898E+00, 9.1989980091E-01],
	[2.8825000000E+04, 2.2664790648E+01, 5.2172405545E+00, 6.9814908280E+00, 2.6383178632E+00, 9.1993896259E-01],
	[2.8830000000E+04, 2.2671265239E+01, 5.2172305675E+00, 6.9853920941E+00, 2.6389600013E+00, 9.1997810372E-01],
	[2.8835000000E+04, 2.2677740556E+01, 5.2172205822E+00, 6.9892948608E+00, 2.6396020039E+00, 9.2001722431E-01],
	[2.8840000000E+04, 2.2684216599E+01, 5.2172105987E+00, 6.9931991283E+00, 2.6402438711E+00, 9.2005632437E-01],
	[2.8845000000E+04, 2.2690693369E+01, 5.2172006169E+00, 6.9971048970E+00, 2.6408856028E+00, 9.2009540392E-01],
	[2.8850000000E+04, 2.2697170865E+01, 5.2171906369E+00, 7.0010121671E+00, 2.6415271991E+00, 9.2013446295E-01],
	[2.8855000000E+04, 2.2703649087E+01, 5.2171806586E+00, 7.0049209390E+00, 2.6421686598E+00, 9.2017350149E-01],
	[2.8860000000E+04, 2.2710128035E+01, 5.2171706820E+00, 7.0088312130E+00, 2.6428099849E+00, 9.2021251954E-01],
	[2.8865000000E+04, 2.2716607710E+01, 5.2171607072E+00, 7.0127429893E+00, 2.6434511745E+00, 9.2025151711E-01],
	[2.8870000000E+04, 2.2723088110E+01, 5.2171507342E+00, 7.0166562684E+00, 2.6440922285E+00, 9.2029049422E-01],
	[2.8875000000E+04, 2.2729569236E+01, 5.2171407629E+00, 7.0205710505E+00, 2.6447331468E+00, 9.2032945087E-01],
	[2.8880000000E+04, 2.2736051088E+01, 5.2171307933E+00, 7.0244873360E+00, 2.6453739294E+00, 9.2036838707E-01],
	[2.8885000000E+04, 2.2742533666E+01, 5.2171208255E+00, 7.0284051251E+00, 2.6460145763E+00, 9.2040730284E-01],
	[2.8890000000E+04, 2.2749016969E+01, 5.2171108595E+00, 7.0323244182E+00, 2.6466550875E+00, 9.2044619818E-01],
	[2.8895000000E+04, 2.2755500999E+01, 5.2171008952E+00, 7.0362452156E+00, 2.6472954630E+00, 9.2048507310E-01],
	[2.8900000000E+04, 2.2761985754E+01, 5.2170909326E+00, 7.0401675177E+00, 2.6479357026E+00, 9.2052392763E-01],
	[2.8905000000E+04, 2.2768471235E+01, 5.2170809717E+00, 7.0440913246E+00, 2.6485758064E+00, 9.2056276175E-01],
	[2.8910000000E+04, 2.2774957441E+01, 5.2170710127E+00, 7.0480166368E+00, 2.6492157744E+00, 9.2060157550E-01],
	[2.8915000000E+04, 2.2781444373E+01, 5.2170610553E+00, 7.0519434545E+00, 2.6498556065E+00, 9.2064036887E-01],
	[2.8920000000E+04, 2.2787932031E+01, 5.2170510997E+00, 7.0558717781E+00, 2.6504953027E+00, 9.2067914187E-01],
	[2.8925000000E+04, 2.2794420414E+01, 5.2170411458E+00, 7.0598016079E+00, 2.6511348629E+00, 9.2071789452E-01],
	[2.8930000000E+04, 2.2800909523E+01, 5.2170311937E+00, 7.0637329442E+00, 2.6517742872E+00, 9.2075662683E-01],
	[2.8935000000E+04, 2.2807399357E+01, 5.2170212433E+00, 7.0676657873E+00, 2.6524135754E+00, 9.2079533881E-01],
	[2.8940000000E+04, 2.2813889916E+01, 5.2170112946E+00, 7.0716001376E+00, 2.6530527277E+00, 9.2083403047E-01],
	[2.8945000000E+04, 2.2820381201E+01, 5.2170013477E+00, 7.0755359953E+00, 2.6536917439E+00, 9.2087270181E-01],
	[2.8950000000E+04, 2.2826873211E+01, 5.2169914026E+00, 7.0794733608E+00, 2.6543306240E+00, 9.2091135286E-01],
	[2.8955000000E+04, 2.2833365946E+01, 5.2169814591E+00, 7.0834122343E+00, 2.6549693679E+00, 9.2094998361E-01],
	[2.8960000000E+04, 2.2839859407E+01, 5.2169715174E+00, 7.0873526163E+00, 2.6556079758E+00, 9.2098859408E-01],
	[2.8965000000E+04, 2.2846353592E+01, 5.2169615774E+00, 7.0912945069E+00, 2.6562464474E+00, 9.2102718428E-01],
	[2.8970000000E+04, 2.2852860135E+01, 5.2169532275E+00, 7.0952379066E+00, 2.6568853521E+00, 9.2106575422E-01],
	[2.8975000000E+04, 2.2859379222E+01, 5.2169464917E+00, 7.0991828157E+00, 2.6575246990E+00, 9.2110430391E-01],
	[2.8980000000E+04, 2.2865899042E+01, 5.2169397570E+00, 7.1031292343E+00, 2.6581639104E+00, 9.2114283337E-01],
	[2.8985000000E+04, 2.2872419597E+01, 5.2169330235E+00, 7.1070771630E+00, 2.6588029862E+00, 9.2118134259E-01],
	[2.8990000000E+04, 2.2878940886E+01, 5.2169262912E+00, 7.1110266020E+00, 2.6594419264E+00, 9.2121983160E-01],
	[2.8995000000E+04, 2.2885462910E+01, 5.2169195600E+00, 7.1149775515E+00, 2.6600807310E+00, 9.2125830040E-01],
	[2.9000000000E+04, 2.2891985667E+01, 5.2169128301E+00, 7.1189300120E+00, 2.6607194000E+00, 9.2129674899E-01],
	[2.9005000000E+04, 2.2898509159E+01, 5.2169061012E+00, 7.1228839837E+00, 2.6613579333E+00, 9.2133517741E-01],
	[2.9010000000E+04, 2.2905033384E+01, 5.2168993736E+00, 7.1268394670E+00, 2.6619963309E+00, 9.2137358564E-01],
	[2.9015000000E+04, 2.2911558344E+01, 5.2168926471E+00, 7.1307964622E+00, 2.6626345927E+00, 9.2141197371E-01],
	[2.9020000000E+04, 2.2918084037E+01, 5.2168859218E+00, 7.1347549695E+00, 2.6632727188E+00, 9.2145034162E-01],
	[2.9025000000E+04, 2.2924610465E+01, 5.2168791977E+00, 7.1387149893E+00, 2.6639107092E+00, 9.2148868939E-01],
	[2.9030000000E+04, 2.2931137626E+01, 5.2168724747E+00, 7.1426765220E+00, 2.6645485637E+00, 9.2152701702E-01],
	[2.9035000000E+04, 2.2937665522E+01, 5.2168657529E+00, 7.1466395678E+00, 2.6651862823E+00, 9.2156532453E-01],
	[2.9040000000E+04, 2.2944194151E+01, 5.2168590322E+00, 7.1506041270E+00, 2.6658238651E+00, 9.2160361192E-01],
	[2.9045000000E+04, 2.2950723514E+01, 5.2168523128E+00, 7.1545702000E+00, 2.6664613120E+00, 9.2164187920E-01],
	[2.9050000000E+04, 2.2957253610E+01, 5.2168455944E+00, 7.1585377871E+00, 2.6670986230E+00, 9.2168012639E-01],
	[2.9055000000E+04, 2.2963784440E+01, 5.2168388773E+00, 7.1625068885E+00, 2.6677357980E+00, 9.2171835350E-01],
	[2.9060000000E+04, 2.2970316004E+01, 5.2168321613E+00, 7.1664775047E+00, 2.6683728370E+00, 9.2175656053E-01],
	[2.9065000000E+04, 2.2976848301E+01, 5.2168254465E+00, 7.1704496359E+00, 2.6690097401E+00, 9.2179474750E-01],
	[2.9070000000E+04, 2.2983381332E+01, 5.2168187328E+00, 7.1744232825E+00, 2.6696465071E+00, 9.2183291442E-01],
	[2.9075000000E+04, 2.2989915097E+01, 5.2168120204E+00, 7.1783984447E+00, 2.6702831380E+00, 9.2187106130E-01],
	[2.9080000000E+04, 2.2996449595E+01, 5.2168053090E+00, 7.1823751229E+00, 2.6709196328E+00, 9.2190918814E-01],
	[2.9085000000E+04, 2.3002984826E+01, 5.2167985989E+00, 7.1863533173E+00, 2.6715559915E+00, 9.2194729496E-01],
	[2.9090000000E+04, 2.3009520790E+01, 5.2167918899E+00, 7.1903330284E+00, 2.6721922141E+00, 9.2198538177E-01],
	[2.9095000000E+04, 2.3016057488E+01, 5.2167851820E+00, 7.1943142564E+00, 2.6728283005E+00, 9.2202344858E-01],
	[2.9100000000E+04, 2.3022594920E+01, 5.2167784753E+00, 7.1982970017E+00, 2.6734642507E+00, 9.2206149540E-01],
	[2.9105000000E+04, 2.3029133084E+01, 5.2167717698E+00, 7.2022812645E+00, 2.6741000647E+00, 9.2209952223E-01],
	[2.9110000000E+04, 2.3035671982E+01, 5.2167650654E+00, 7.2062670451E+00, 2.6747357424E+00, 9.2213752910E-01],
	[2.9115000000E+04, 2.3042211612E+01, 5.2167583622E+00, 7.2102543440E+00, 2.6753712839E+00, 9.2217551601E-01],
	[2.9120000000E+04, 2.3048751976E+01, 5.2167516602E+00, 7.2142431614E+00, 2.6760066890E+00, 9.2221348296E-01],
	[2.9125000000E+04, 2.3055293073E+01, 5.2167449593E+00, 7.2182334975E+00, 2.6766419578E+00, 9.2225142998E-01],
	[2.9130000000E+04, 2.3061834903E+01, 5.2167382596E+00, 7.2222253528E+00, 2.6772770903E+00, 9.2228935707E-01],
	[2.9135000000E+04, 2.3068377466E+01, 5.2167315610E+00, 7.2262187276E+00, 2.6779120863E+00, 9.2232726427E-01],
	[2.9140000000E+04, 2.3074920761E+01, 5.2167248636E+00, 7.2302136221E+00, 2.6785469460E+00, 9.2236515158E-01],
	[2.9145000000E+04, 2.3081464790E+01, 5.2167181674E+00, 7.2342100367E+00, 2.6791816692E+00, 9.2240301903E-01],
	[2.9150000000E+04, 2.3088009552E+01, 5.2167114723E+00, 7.2382079717E+00, 2.6798162559E+00, 9.2244086662E-01],
	[2.9155000000E+04, 2.3094555046E+01, 5.2167047784E+00, 7.2422074275E+00, 2.6804507062E+00, 9.2247869436E-01],
	[2.9160000000E+04, 2.3101101273E+01, 5.2166980856E+00, 7.2462084042E+00, 2.6810850199E+00, 9.2251650225E-01],
	[2.9165000000E+04, 2.3107648233E+01, 5.2166913940E+00, 7.2502109023E+00, 2.6817191971E+00, 9.2255429032E-01],
	[2.9170000000E+04, 2.3114195925E+01, 5.2166847035E+00, 7.2542149221E+00, 2.6823532377E+00, 9.2259205856E-01],
	[2.9175000000E+04, 2.3120744350E+01, 5.2166780142E+00, 7.2582204638E+00, 2.6829871417E+00, 9.2262980699E-01],
	[2.9180000000E+04, 2.3127293507E+01, 5.2166713260E+00, 7.2622275279E+00, 2.6836209091E+00, 9.2266753561E-01],
	[2.9185000000E+04, 2.3133843398E+01, 5.2166646390E+00, 7.2662361145E+00, 2.6842545399E+00, 9.2270524444E-01],
	[2.9190000000E+04, 2.3140394020E+01, 5.2166579532E+00, 7.2702462241E+00, 2.6848880340E+00, 9.2274293348E-01],
	[2.9195000000E+04, 2.3146945375E+01, 5.2166512685E+00, 7.2742578569E+00, 2.6855213914E+00, 9.2278060275E-01],
	[2.9200000000E+04, 2.3153497463E+01, 5.2166445849E+00, 7.2782710133E+00, 2.6861546120E+00, 9.2281825225E-01],
	[2.9205000000E+04, 2.3160050282E+01, 5.2166379026E+00, 7.2822856935E+00, 2.6867876959E+00, 9.2285588198E-01],
	[2.9210000000E+04, 2.3166603834E+01, 5.2166312213E+00, 7.2863018980E+00, 2.6874206430E+00, 9.2289349197E-01],
	[2.9215000000E+04, 2.3173158119E+01, 5.2166245412E+00, 7.2903196269E+00, 2.6880534533E+00, 9.2293108222E-01],
	[2.9220000000E+04, 2.3179713135E+01, 5.2166178623E+00, 7.2943388807E+00, 2.6886861268E+00, 9.2296865274E-01],
	[2.9225000000E+04, 2.3186268884E+01, 5.2166111845E+00, 7.2983596596E+00, 2.6893186635E+00, 9.2300620354E-01],
	[2.9230000000E+04, 2.3192825365E+01, 5.2166045079E+00, 7.3023819640E+00, 2.6899510632E+00, 9.2304373463E-01],
	[2.9235000000E+04, 2.3199382578E+01, 5.2165978324E+00, 7.3064057942E+00, 2.6905833261E+00, 9.2308124601E-01],
	[2.9240000000E+04, 2.3205940523E+01, 5.2165911581E+00, 7.3104311504E+00, 2.6912154520E+00, 9.2311873770E-01],
	[2.9245000000E+04, 2.3212499200E+01, 5.2165844849E+00, 7.3144580330E+00, 2.6918474410E+00, 9.2315620970E-01],
	[2.9250000000E+04, 2.3219058609E+01, 5.2165778129E+00, 7.3184864424E+00, 2.6924792930E+00, 9.2319366203E-01],
	[2.9255000000E+04, 2.3225618750E+01, 5.2165711420E+00, 7.3225163788E+00, 2.6931110080E+00, 9.2323109469E-01],
	[2.9260000000E+04, 2.3232179622E+01, 5.2165644723E+00, 7.3265478425E+00, 2.6937425860E+00, 9.2326850769E-01],
	[2.9265000000E+04, 2.3238741227E+01, 5.2165578037E+00, 7.3305808340E+00, 2.6943740269E+00, 9.2330590105E-01],
	[2.9270000000E+04, 2.3245303563E+01, 5.2165511363E+00, 7.3346153534E+00, 2.6950053307E+00, 9.2334327476E-01],
	[2.9275000000E+04, 2.3251866631E+01, 5.2165444700E+00, 7.3386514011E+00, 2.6956364975E+00, 9.2338062885E-01],
	[2.9280000000E+04, 2.3258430431E+01, 5.2165378048E+00, 7.3426889774E+00, 2.6962675271E+00, 9.2341796332E-01],
	[2.9285000000E+04, 2.3264994963E+01, 5.2165311408E+00, 7.3467280827E+00, 2.6968984196E+00, 9.2345527817E-01],
	[2.9290000000E+04, 2.3271560226E+01, 5.2165244780E+00, 7.3507687172E+00, 2.6975291748E+00, 9.2349257343E-01],
	[2.9295000000E+04, 2.3278126221E+01, 5.2165178163E+00, 7.3548108813E+00, 2.6981597929E+00, 9.2352984909E-01],
	[2.9300000000E+04, 2.3284692947E+01, 5.2165111557E+00, 7.3588545753E+00, 2.6987902738E+00, 9.2356710517E-01],
	[2.9305000000E+04, 2.3291260404E+01, 5.2165044963E+00, 7.3628997995E+00, 2.6994206174E+00, 9.2360434167E-01],
	[2.9310000000E+04, 2.3297828594E+01, 5.2164978380E+00, 7.3669465541E+00, 2.7000508237E+00, 9.2364155861E-01],
	[2.9315000000E+04, 2.3304397514E+01, 5.2164911809E+00, 7.3709948397E+00, 2.7006808928E+00, 9.2367875600E-01],
	[2.9320000000E+04, 2.3310967166E+01, 5.2164845249E+00, 7.3750446563E+00, 2.7013108245E+00, 9.2371593384E-01],
	[2.9325000000E+04, 2.3317537549E+01, 5.2164778701E+00, 7.3790960045E+00, 2.7019406189E+00, 9.2375309214E-01],
	[2.9330000000E+04, 2.3324108664E+01, 5.2164712164E+00, 7.3831488844E+00, 2.7025702759E+00, 9.2379023091E-01],
	[2.9335000000E+04, 2.3330680509E+01, 5.2164645639E+00, 7.3872032964E+00, 2.7031997955E+00, 9.2382735016E-01],
	[2.9340000000E+04, 2.3337253086E+01, 5.2164579125E+00, 7.3912592409E+00, 2.7038291777E+00, 9.2386444991E-01],
	[2.9345000000E+04, 2.3343826394E+01, 5.2164512622E+00, 7.3953167180E+00, 2.7044584225E+00, 9.2390153016E-01],
	[2.9350000000E+04, 2.3350400433E+01, 5.2164446131E+00, 7.3993757283E+00, 2.7050875297E+00, 9.2393859091E-01],
	[2.9355000000E+04, 2.3356975203E+01, 5.2164379651E+00, 7.4034362719E+00, 2.7057164996E+00, 9.2397563218E-01],
	[2.9360000000E+04, 2.3363550704E+01, 5.2164313182E+00, 7.4074983491E+00, 2.7063453319E+00, 9.2401265398E-01],
	[2.9365000000E+04, 2.3370126937E+01, 5.2164246725E+00, 7.4115619604E+00, 2.7069740266E+00, 9.2404965632E-01],
	[2.9370000000E+04, 2.3376703900E+01, 5.2164180280E+00, 7.4156271060E+00, 2.7076025838E+00, 9.2408663920E-01],
	[2.9375000000E+04, 2.3383281593E+01, 5.2164113846E+00, 7.4196937862E+00, 2.7082310034E+00, 9.2412360264E-01],
	[2.9380000000E+04, 2.3389860018E+01, 5.2164047423E+00, 7.4237620013E+00, 2.7088592855E+00, 9.2416054665E-01],
	[2.9385000000E+04, 2.3396439174E+01, 5.2163981011E+00, 7.4278317518E+00, 2.7094874299E+00, 9.2419747123E-01],
	[2.9390000000E+04, 2.3403019060E+01, 5.2163914611E+00, 7.4319030378E+00, 2.7101154366E+00, 9.2423437639E-01],
	[2.9395000000E+04, 2.3409599677E+01, 5.2163848223E+00, 7.4359758597E+00, 2.7107433057E+00, 9.2427126214E-01],
	[2.9400000000E+04, 2.3416181025E+01, 5.2163781845E+00, 7.4400502178E+00, 2.7113710371E+00, 9.2430812850E-01],
	[2.9405000000E+04, 2.3422763103E+01, 5.2163715479E+00, 7.4441261124E+00, 2.7119986307E+00, 9.2434497547E-01],
	[2.9410000000E+04, 2.3429345912E+01, 5.2163649125E+00, 7.4482035439E+00, 2.7126260866E+00, 9.2438180305E-01],
	[2.9415000000E+04, 2.3435929451E+01, 5.2163582781E+00, 7.4522825126E+00, 2.7132534048E+00, 9.2441861127E-01],
	[2.9420000000E+04, 2.3442513721E+01, 5.2163516450E+00, 7.4563630187E+00, 2.7138805851E+00, 9.2445540013E-01],
	[2.9425000000E+04, 2.3449098721E+01, 5.2163450129E+00, 7.4604450627E+00, 2.7145076277E+00, 9.2449216963E-01],
	[2.9430000000E+04, 2.3455684452E+01, 5.2163383820E+00, 7.4645286447E+00, 2.7151345324E+00, 9.2452891980E-01],
	[2.9435000000E+04, 2.3462276228E+01, 5.2163324707E+00, 7.4686137652E+00, 2.7157615652E+00, 9.2456565063E-01],
	[2.9440000000E+04, 2.3468886672E+01, 5.2163289839E+00, 7.4727004244E+00, 2.7163893578E+00, 9.2460236213E-01],
	[2.9445000000E+04, 2.3475497855E+01, 5.2163254976E+00, 7.4767886227E+00, 2.7170170132E+00, 9.2463905432E-01],
	[2.9450000000E+04, 2.3482109777E+01, 5.2163220120E+00, 7.4808783604E+00, 2.7176445313E+00, 9.2467572721E-01],
	[2.9455000000E+04, 2.3488722438E+01, 5.2163185270E+00, 7.4849696378E+00, 2.7182719122E+00, 9.2471238080E-01],
	[2.9460000000E+04, 2.3495335839E+01, 5.2163150425E+00, 7.4890624552E+00, 2.7188991559E+00, 9.2474901511E-01],
	[2.9465000000E+04, 2.3501949979E+01, 5.2163115587E+00, 7.4931568129E+00, 2.7195262622E+00, 9.2478563013E-01],
	[2.9470000000E+04, 2.3508564858E+01, 5.2163080754E+00, 7.4972527112E+00, 2.7201532313E+00, 9.2482222589E-01],
	[2.9475000000E+04, 2.3515180476E+01, 5.2163045927E+00, 7.5013501506E+00, 2.7207800630E+00, 9.2485880239E-01],
	[2.9480000000E+04, 2.3521796834E+01, 5.2163011107E+00, 7.5054491312E+00, 2.7214067573E+00, 9.2489535964E-01],
	[2.9485000000E+04, 2.3528413930E+01, 5.2162976292E+00, 7.5095496534E+00, 2.7220333143E+00, 9.2493189765E-01],
	[2.9490000000E+04, 2.3535031766E+01, 5.2162941483E+00, 7.5136517175E+00, 2.7226597339E+00, 9.2496841643E-01],
	[2.9495000000E+04, 2.3541650340E+01, 5.2162906680E+00, 7.5177553238E+00, 2.7232860161E+00, 9.2500491599E-01],
	[2.9500000000E+04, 2.3548269654E+01, 5.2162871883E+00, 7.5218604727E+00, 2.7239121608E+00, 9.2504139634E-01],
	[2.9505000000E+04, 2.3554889706E+01, 5.2162837092E+00, 7.5259671645E+00, 2.7245381681E+00, 9.2507785748E-01],
	[2.9510000000E+04, 2.3561510497E+01, 5.2162802307E+00, 7.5300753994E+00, 2.7251640379E+00, 9.2511429943E-01],
	[2.9515000000E+04, 2.3568132027E+01, 5.2162767527E+00, 7.5341851779E+00, 2.7257897702E+00, 9.2515072220E-01],
	[2.9520000000E+04, 2.3574754296E+01, 5.2162732754E+00, 7.5382965001E+00, 2.7264153649E+00, 9.2518712579E-01],
	[2.9525000000E+04, 2.3581377303E+01, 5.2162697987E+00, 7.5424093665E+00, 2.7270408221E+00, 9.2522351022E-01],
	[2.9530000000E+04, 2.3588001049E+01, 5.2162663225E+00, 7.5465237774E+00, 2.7276661417E+00, 9.2525987548E-01],
	[2.9535000000E+04, 2.3594625534E+01, 5.2162628469E+00, 7.5506397330E+00, 2.7282913238E+00, 9.2529622161E-01],
	[2.9540000000E+04, 2.3601250757E+01, 5.2162593720E+00, 7.5547572337E+00, 2.7289163682E+00, 9.2533254859E-01],
	[2.9545000000E+04, 2.3607876719E+01, 5.2162558976E+00, 7.5588762797E+00, 2.7295412750E+00, 9.2536885645E-01],
	[2.9550000000E+04, 2.3614503419E+01, 5.2162524238E+00, 7.5629968715E+00, 2.7301660441E+00, 9.2540514519E-01],
	[2.9555000000E+04, 2.3621130858E+01, 5.2162489506E+00, 7.5671190094E+00, 2.7307906756E+00, 9.2544141482E-01],
	[2.9560000000E+04, 2.3627759035E+01, 5.2162454780E+00, 7.5712426936E+00, 2.7314151693E+00, 9.2547766534E-01],
	[2.9565000000E+04, 2.3634387951E+01, 5.2162420060E+00, 7.5753679244E+00, 2.7320395254E+00, 9.2551389678E-01],
	[2.9570000000E+04, 2.3641017605E+01, 5.2162385345E+00, 7.5794947023E+00, 2.7326637437E+00, 9.2555010914E-01],
	[2.9575000000E+04, 2.3647647997E+01, 5.2162350637E+00, 7.5836230274E+00, 2.7332878242E+00, 9.2558630242E-01],
	[2.9580000000E+04, 2.3654279127E+01, 5.2162315934E+00, 7.5877529001E+00, 2.7339117669E+00, 9.2562247664E-01],
	[2.9585000000E+04, 2.3660910996E+01, 5.2162281238E+00, 7.5918843208E+00, 2.7345355719E+00, 9.2565863181E-01],
	[2.9590000000E+04, 2.3667543603E+01, 5.2162246547E+00, 7.5960172898E+00, 2.7351592390E+00, 9.2569476793E-01],
	[2.9595000000E+04, 2.3674176948E+01, 5.2162211862E+00, 7.6001518073E+00, 2.7357827683E+00, 9.2573088502E-01],
	[2.9600000000E+04, 2.3680811031E+01, 5.2162177183E+00, 7.6042878737E+00, 2.7364061597E+00, 9.2576698308E-01],
	[2.9605000000E+04, 2.3687445852E+01, 5.2162142510E+00, 7.6084254893E+00, 2.7370294132E+00, 9.2580306213E-01],
	[2.9610000000E+04, 2.3694081411E+01, 5.2162107843E+00, 7.6125646544E+00, 2.7376525288E+00, 9.2583912216E-01],
	[2.9615000000E+04, 2.3700717708E+01, 5.2162073181E+00, 7.6167053694E+00, 2.7382755065E+00, 9.2587516321E-01],
	[2.9620000000E+04, 2.3707354743E+01, 5.2162038526E+00, 7.6208476345E+00, 2.7388983463E+00, 9.2591118526E-01],
	[2.9625000000E+04, 2.3713992515E+01, 5.2162003876E+00, 7.6249914501E+00, 2.7395210481E+00, 9.2594718833E-01],
	[2.9630000000E+04, 2.3720631026E+01, 5.2161969233E+00, 7.6291368164E+00, 2.7401436119E+00, 9.2598317244E-01],
	[2.9635000000E+04, 2.3727270274E+01, 5.2161934595E+00, 7.6332837339E+00, 2.7407660376E+00, 9.2601913758E-01],
	[2.9640000000E+04, 2.3733910260E+01, 5.2161899963E+00, 7.6374322028E+00, 2.7413883254E+00, 9.2605508378E-01],
	[2.9645000000E+04, 2.3740550984E+01, 5.2161865336E+00, 7.6415822235E+00, 2.7420104751E+00, 9.2609101103E-01],
	[2.9650000000E+04, 2.3747192446E+01, 5.2161830716E+00, 7.6457337962E+00, 2.7426324867E+00, 9.2612691935E-01],
	[2.9655000000E+04, 2.3753834645E+01, 5.2161796102E+00, 7.6498869212E+00, 2.7432543603E+00, 9.2616280875E-01],
	[2.9660000000E+04, 2.3760477581E+01, 5.2161761493E+00, 7.6540415990E+00, 2.7438760957E+00, 9.2619867923E-01],
	[2.9665000000E+04, 2.3767121255E+01, 5.2161726891E+00, 7.6581978298E+00, 2.7444976931E+00, 9.2623453081E-01],
	[2.9670000000E+04, 2.3773765667E+01, 5.2161692294E+00, 7.6623556139E+00, 2.7451191522E+00, 9.2627036350E-01],
	[2.9675000000E+04, 2.3780410816E+01, 5.2161657703E+00, 7.6665149516E+00, 2.7457404732E+00, 9.2630617730E-01],
	[2.9680000000E+04, 2.3787056702E+01, 5.2161623118E+00, 7.6706758433E+00, 2.7463616561E+00, 9.2634197222E-01],
	[2.9685000000E+04, 2.3793703326E+01, 5.2161588538E+00, 7.6748382893E+00, 2.7469827007E+00, 9.2637774828E-01],
	[2.9690000000E+04, 2.3800350687E+01, 5.2161553965E+00, 7.6790022898E+00, 2.7476036071E+00, 9.2641350548E-01],
	[2.9695000000E+04, 2.3806998786E+01, 5.2161519397E+00, 7.6831678453E+00, 2.7482243752E+00, 9.2644924383E-01],
	[2.9700000000E+04, 2.3813647621E+01, 5.2161484835E+00, 7.6873349560E+00, 2.7488450051E+00, 9.2648496334E-01],
	[2.9705000000E+04, 2.3820297194E+01, 5.2161450279E+00, 7.6915036223E+00, 2.7494654967E+00, 9.2652066403E-01],
	[2.9710000000E+04, 2.3826947504E+01, 5.2161415729E+00, 7.6956738444E+00, 2.7500858500E+00, 9.2655634589E-01],
	[2.9715000000E+04, 2.3833598551E+01, 5.2161381185E+00, 7.6998456227E+00, 2.7507060649E+00, 9.2659200894E-01],
	[2.9720000000E+04, 2.3840250335E+01, 5.2161346647E+00, 7.7040189575E+00, 2.7513261416E+00, 9.2662765320E-01],
	[2.9725000000E+04, 2.3846902856E+01, 5.2161312114E+00, 7.7081938491E+00, 2.7519460798E+00, 9.2666327866E-01],
	[2.9730000000E+04, 2.3853556114E+01, 5.2161277587E+00, 7.7123702978E+00, 2.7525658797E+00, 9.2669888534E-01],
	[2.9735000000E+04, 2.3860210109E+01, 5.2161243066E+00, 7.7165483040E+00, 2.7531855412E+00, 9.2673447324E-01],
	[2.9740000000E+04, 2.3866864841E+01, 5.2161208551E+00, 7.7207278680E+00, 2.7538050643E+00, 9.2677004238E-01],
	[2.9745000000E+04, 2.3873520310E+01, 5.2161174042E+00, 7.7249089900E+00, 2.7544244489E+00, 9.2680559277E-01],
	[2.9750000000E+04, 2.3880176516E+01, 5.2161139539E+00, 7.7290916705E+00, 2.7550436951E+00, 9.2684112441E-01],
	[2.9755000000E+04, 2.3886833458E+01, 5.2161105041E+00, 7.7332759096E+00, 2.7556628029E+00, 9.2687663732E-01],
	[2.9760000000E+04, 2.3893491137E+01, 5.2161070549E+00, 7.7374617078E+00, 2.7562817721E+00, 9.2691213150E-01],
	[2.9765000000E+04, 2.3900149553E+01, 5.2161036063E+00, 7.7416490654E+00, 2.7569006028E+00, 9.2694760696E-01],
	[2.9770000000E+04, 2.3906808705E+01, 5.2161001583E+00, 7.7458379826E+00, 2.7575192950E+00, 9.2698306372E-01],
	[2.9775000000E+04, 2.3913468594E+01, 5.2160967109E+00, 7.7500284598E+00, 2.7581378486E+00, 9.2701850177E-01],
	[2.9780000000E+04, 2.3920129219E+01, 5.2160932640E+00, 7.7542204973E+00, 2.7587562637E+00, 9.2705392114E-01],
	[2.9785000000E+04, 2.3926790581E+01, 5.2160898177E+00, 7.7584140955E+00, 2.7593745402E+00, 9.2708932183E-01],
	[2.9790000000E+04, 2.3933452680E+01, 5.2160863720E+00, 7.7626092545E+00, 2.7599926781E+00, 9.2712470385E-01],
	[2.9795000000E+04, 2.3940115515E+01, 5.2160829269E+00, 7.7668059749E+00, 2.7606106774E+00, 9.2716006721E-01],
	[2.9800000000E+04, 2.3946779086E+01, 5.2160794824E+00, 7.7710042568E+00, 2.7612285380E+00, 9.2719541192E-01],
	[2.9805000000E+04, 2.3953443394E+01, 5.2160760385E+00, 7.7752041006E+00, 2.7618462600E+00, 9.2723073798E-01],
	[2.9810000000E+04, 2.3960108437E+01, 5.2160725951E+00, 7.7794055066E+00, 2.7624638433E+00, 9.2726604541E-01],
	[2.9815000000E+04, 2.3966774218E+01, 5.2160691523E+00, 7.7836084751E+00, 2.7630812879E+00, 9.2730133422E-01],
	[2.9820000000E+04, 2.3973440734E+01, 5.2160657101E+00, 7.7878130065E+00, 2.7636985938E+00, 9.2733660442E-01],
	[2.9825000000E+04, 2.3980107986E+01, 5.2160622684E+00, 7.7920191011E+00, 2.7643157610E+00, 9.2737185601E-01],
	[2.9830000000E+04, 2.3986775975E+01, 5.2160588274E+00, 7.7962267591E+00, 2.7649327895E+00, 9.2740708901E-01],
	[2.9835000000E+04, 2.3993444700E+01, 5.2160553869E+00, 7.8004359809E+00, 2.7655496791E+00, 9.2744230342E-01],
	[2.9840000000E+04, 2.4000114161E+01, 5.2160519470E+00, 7.8046467669E+00, 2.7661664300E+00, 9.2747749925E-01],
	[2.9845000000E+04, 2.4006784357E+01, 5.2160485077E+00, 7.8088591172E+00, 2.7667830421E+00, 9.2751267652E-01],
	[2.9850000000E+04, 2.4013455290E+01, 5.2160450690E+00, 7.8130730324E+00, 2.7673995154E+00, 9.2754783523E-01],
	[2.9855000000E+04, 2.4020126959E+01, 5.2160416308E+00, 7.8172885126E+00, 2.7680158499E+00, 9.2758297539E-01],
	[2.9860000000E+04, 2.4026799363E+01, 5.2160381932E+00, 7.8215055581E+00, 2.7686320455E+00, 9.2761809701E-01],
	[2.9865000000E+04, 2.4033472504E+01, 5.2160347562E+00, 7.8257241694E+00, 2.7692481022E+00, 9.2765320010E-01],
	[2.9870000000E+04, 2.4040146380E+01, 5.2160313198E+00, 7.8299443467E+00, 2.7698640201E+00, 9.2768828468E-01],
	[2.9875000000E+04, 2.4046820992E+01, 5.2160278839E+00, 7.8341660903E+00, 2.7704797990E+00, 9.2772335074E-01],
	[2.9880000000E+04, 2.4053496339E+01, 5.2160244487E+00, 7.8383894006E+00, 2.7710954391E+00, 9.2775839830E-01],
	[2.9885000000E+04, 2.4060172423E+01, 5.2160210140E+00, 7.8426142779E+00, 2.7717109402E+00, 9.2779342737E-01],
	[2.9890000000E+04, 2.4066849242E+01, 5.2160175798E+00, 7.8468407225E+00, 2.7723263023E+00, 9.2782843795E-01],
	[2.9895000000E+04, 2.4073526796E+01, 5.2160141463E+00, 7.8510687346E+00, 2.7729415255E+00, 9.2786343006E-01],
	[2.9900000000E+04, 2.4080205086E+01, 5.2160107133E+00, 7.8552983147E+00, 2.7735566097E+00, 9.2789840371E-01],
	[2.9905000000E+04, 2.4086884112E+01, 5.2160072809E+00, 7.8595294631E+00, 2.7741715549E+00, 9.2793335891E-01],
	[2.9910000000E+04, 2.4093574467E+01, 5.2160052665E+00, 7.8637621799E+00, 2.7747869027E+00, 9.2796829566E-01],
	[2.9915000000E+04, 2.4100278018E+01, 5.2160049184E+00, 7.8679964657E+00, 2.7754027487E+00, 9.2800321397E-01],
	[2.9920000000E+04, 2.4106982314E+01, 5.2160045704E+00, 7.8722323207E+00, 2.7760184562E+00, 9.2803811386E-01],
	[2.9925000000E+04, 2.4113687354E+01, 5.2160042224E+00, 7.8764697452E+00, 2.7766340255E+00, 9.2807299533E-01],
	[2.9930000000E+04, 2.4120393138E+01, 5.2160038745E+00, 7.8807087395E+00, 2.7772494563E+00, 9.2810785839E-01],
	[2.9935000000E+04, 2.4127099667E+01, 5.2160035267E+00, 7.8849493040E+00, 2.7778647486E+00, 9.2814270305E-01],
	[2.9940000000E+04, 2.4133806939E+01, 5.2160031789E+00, 7.8891914389E+00, 2.7784799026E+00, 9.2817752933E-01],
	[2.9945000000E+04, 2.4140514956E+01, 5.2160028311E+00, 7.8934351446E+00, 2.7790949180E+00, 9.2821233723E-01],
	[2.9950000000E+04, 2.4147223717E+01, 5.2160024835E+00, 7.8976804215E+00, 2.7797097950E+00, 9.2824712675E-01],
	[2.9955000000E+04, 2.4153933221E+01, 5.2160021358E+00, 7.9019272697E+00, 2.7803245336E+00, 9.2828189792E-01],
	[2.9960000000E+04, 2.4160643470E+01, 5.2160017883E+00, 7.9061756897E+00, 2.7809391336E+00, 9.2831665073E-01],
	[2.9965000000E+04, 2.4167354463E+01, 5.2160014408E+00, 7.9104256817E+00, 2.7815535951E+00, 9.2835138520E-01],
	[2.9970000000E+04, 2.4174066200E+01, 5.2160010933E+00, 7.9146772462E+00, 2.7821679180E+00, 9.2838610134E-01],
	[2.9975000000E+04, 2.4180778680E+01, 5.2160007459E+00, 7.9189303833E+00, 2.7827821024E+00, 9.2842079916E-01],
	[2.9980000000E+04, 2.4187491904E+01, 5.2160003986E+00, 7.9231850934E+00, 2.7833961482E+00, 9.2845547866E-01],
	[2.9985000000E+04, 2.4194205872E+01, 5.2160000514E+00, 7.9274413768E+00, 2.7840100555E+00, 9.2849013986E-01],
	[2.9990000000E+04, 2.4200920584E+01, 5.2159997041E+00, 7.9316992339E+00, 2.7846238241E+00, 9.2852478276E-01],
	[2.9995000000E+04, 2.4207636040E+01, 5.2159993570E+00, 7.9359586650E+00, 2.7852374541E+00, 9.2855940738E-01],
	[3.0000000000E+04, 2.4214352239E+01, 5.2159990099E+00, 7.9402196703E+00, 2.7858509455E+00, 9.2859401372E-01],
	[3.0005000000E+04, 2.4221069182E+01, 5.2159986629E+00, 7.9445065569E+00, 2.7864672884E+00, 9.2862860179E-01],
	[3.0010000000E+04, 2.4227786868E+01, 5.2159983159E+00, 7.9487950406E+00, 2.7870834916E+00, 9.2866317161E-01],
	[3.0015000000E+04, 2.4234505298E+01, 5.2159979690E+00, 7.9530851217E+00, 2.7876995550E+00, 9.2869772317E-01],
	[3.0020000000E+04, 2.4241224471E+01, 5.2159976221E+00, 7.9573768005E+00, 2.7883154787E+00, 9.2873225650E-01],
	[3.0025000000E+04, 2.4247944388E+01, 5.2159972753E+00, 7.9616700773E+00, 2.7889312625E+00, 9.2876677160E-01],
	[3.0030000000E+04, 2.4254665048E+01, 5.2159969285E+00, 7.9659649525E+00, 2.7895469066E+00, 9.2880126848E-01],
	[3.0035000000E+04, 2.4261386452E+01, 5.2159965818E+00, 7.9702614265E+00, 2.7901624109E+00, 9.2883574715E-01],
	[3.0040000000E+04, 2.4268108599E+01, 5.2159962352E+00, 7.9745594995E+00, 2.7907777753E+00, 9.2887020762E-01],
	[3.0045000000E+04, 2.4274831489E+01, 5.2159958886E+00, 7.9788591718E+00, 2.7913929998E+00, 9.2890464989E-01],
	[3.0050000000E+04, 2.4281555123E+01, 5.2159955421E+00, 7.9831604438E+00, 2.7920080845E+00, 9.2893907398E-01],
	[3.0055000000E+04, 2.4288279499E+01, 5.2159951957E+00, 7.9874633159E+00, 2.7926230293E+00, 9.2897347990E-01],
	[3.0060000000E+04, 2.4295004619E+01, 5.2159948493E+00, 7.9917677883E+00, 2.7932378342E+00, 9.2900786766E-01],
	[3.0065000000E+04, 2.4301730482E+01, 5.2159945029E+00, 7.9960738614E+00, 2.7938524992E+00, 9.2904223726E-01],
	[3.0070000000E+04, 2.4308457088E+01, 5.2159941566E+00, 8.0003815354E+00, 2.7944670243E+00, 9.2907658872E-01],
	[3.0075000000E+04, 2.4315184437E+01, 5.2159938104E+00, 8.0046908108E+00, 2.7950814094E+00, 9.2911092204E-01],
	[3.0080000000E+04, 2.4321912529E+01, 5.2159934642E+00, 8.0090016879E+00, 2.7956956545E+00, 9.2914523723E-01],
	[3.0085000000E+04, 2.4328641364E+01, 5.2159931181E+00, 8.0133141669E+00, 2.7963097597E+00, 9.2917953431E-01],
	[3.0090000000E+04, 2.4335370942E+01, 5.2159927721E+00, 8.0176282483E+00, 2.7969237249E+00, 9.2921381328E-01],
	[3.0095000000E+04, 2.4342101262E+01, 5.2159924261E+00, 8.0219439323E+00, 2.7975375500E+00, 9.2924807415E-01],
	[3.0100000000E+04, 2.4348832326E+01, 5.2159920801E+00, 8.0262612192E+00, 2.7981512352E+00, 9.2928231693E-01],
	[3.0105000000E+04, 2.4355564132E+01, 5.2159917342E+00, 8.0305801095E+00, 2.7987647803E+00, 9.2931654163E-01],
	[3.0110000000E+04, 2.4362296681E+01, 5.2159913884E+00, 8.0349006033E+00, 2.7993781853E+00, 9.2935074826E-01],
	[3.0115000000E+04, 2.4369029973E+01, 5.2159910426E+00, 8.0392227012E+00, 2.7999914503E+00, 9.2938493684E-01],
	[3.0120000000E+04, 2.4375764007E+01, 5.2159906969E+00, 8.0435464033E+00, 2.8006045752E+00, 9.2941910736E-01],
	[3.0125000000E+04, 2.4382498785E+01, 5.2159903513E+00, 8.0478717100E+00, 2.8012175600E+00, 9.2945325983E-01],
	[3.0130000000E+04, 2.4389234304E+01, 5.2159900057E+00, 8.0521986216E+00, 2.8018304047E+00, 9.2948739428E-01],
	[3.0135000000E+04, 2.4395970566E+01, 5.2159896601E+00, 8.0565271385E+00, 2.8024431093E+00, 9.2952151070E-01],
	[3.0140000000E+04, 2.4402707571E+01, 5.2159893147E+00, 8.0608572609E+00, 2.8030556737E+00, 9.2955560911E-01],
	[3.0145000000E+04, 2.4409445318E+01, 5.2159889692E+00, 8.0651889893E+00, 2.8036680979E+00, 9.2958968951E-01],
	[3.0150000000E+04, 2.4416183807E+01, 5.2159886239E+00, 8.0695223240E+00, 2.8042803820E+00, 9.2962375192E-01],
	[3.0155000000E+04, 2.4422923039E+01, 5.2159882785E+00, 8.0738572652E+00, 2.8048925259E+00, 9.2965779635E-01],
	[3.0160000000E+04, 2.4429663013E+01, 5.2159879333E+00, 8.0781938133E+00, 2.8055045296E+00, 9.2969182279E-01],
	[3.0165000000E+04, 2.4436403730E+01, 5.2159875881E+00, 8.0825319686E+00, 2.8061163931E+00, 9.2972583127E-01],
	[3.0170000000E+04, 2.4443145189E+01, 5.2159872430E+00, 8.0868717314E+00, 2.8067281164E+00, 9.2975982179E-01],
	[3.0175000000E+04, 2.4449887390E+01, 5.2159868979E+00, 8.0912131022E+00, 2.8073396994E+00, 9.2979379437E-01],
	[3.0180000000E+04, 2.4456630333E+01, 5.2159865529E+00, 8.0955560812E+00, 2.8079511421E+00, 9.2982774900E-01],
	[3.0185000000E+04, 2.4463374018E+01, 5.2159862079E+00, 8.0999006686E+00, 2.8085624446E+00, 9.2986168570E-01],
	[3.0190000000E+04, 2.4470118445E+01, 5.2159858630E+00, 8.1042468650E+00, 2.8091736068E+00, 9.2989560449E-01],
	[3.0195000000E+04, 2.4476863614E+01, 5.2159855181E+00, 8.1085946705E+00, 2.8097846287E+00, 9.2992950536E-01],
	[3.0200000000E+04, 2.4483609526E+01, 5.2159851733E+00, 8.1129440856E+00, 2.8103955102E+00, 9.2996338833E-01],
	[3.0205000000E+04, 2.4490356179E+01, 5.2159848286E+00, 8.1172951105E+00, 2.8110062515E+00, 9.2999725341E-01],
	[3.0210000000E+04, 2.4497103574E+01, 5.2159844839E+00, 8.1216477456E+00, 2.8116168524E+00, 9.3003110061E-01],
	[3.0215000000E+04, 2.4503851711E+01, 5.2159841393E+00, 8.1260019912E+00, 2.8122273129E+00, 9.3006492993E-01],
	[3.0220000000E+04, 2.4510600590E+01, 5.2159837947E+00, 8.1303578476E+00, 2.8128376331E+00, 9.3009874139E-01],
	[3.0225000000E+04, 2.4517350211E+01, 5.2159834502E+00, 8.1347153152E+00, 2.8134478128E+00, 9.3013253500E-01],
	[3.0230000000E+04, 2.4524100573E+01, 5.2159831058E+00, 8.1390743943E+00, 2.8140578522E+00, 9.3016631076E-01],
	[3.0235000000E+04, 2.4530851677E+01, 5.2159827614E+00, 8.1434350851E+00, 2.8146677512E+00, 9.3020006868E-01],
	[3.0240000000E+04, 2.4537603523E+01, 5.2159824170E+00, 8.1477973881E+00, 2.8152775097E+00, 9.3023380877E-01],
	[3.0245000000E+04, 2.4544356111E+01, 5.2159820727E+00, 8.1521613036E+00, 2.8158871278E+00, 9.3026753105E-01],
	[3.0250000000E+04, 2.4551109440E+01, 5.2159817285E+00, 8.1565268319E+00, 2.8164966055E+00, 9.3030123552E-01],
	[3.0255000000E+04, 2.4557863510E+01, 5.2159813843E+00, 8.1608939733E+00, 2.8171059427E+00, 9.3033492220E-01],
	[3.0260000000E+04, 2.4564618322E+01, 5.2159810402E+00, 8.1652627282E+00, 2.8177151394E+00, 9.3036859108E-01],
	[3.0265000000E+04, 2.4571373876E+01, 5.2159806962E+00, 8.1696330968E+00, 2.8183241956E+00, 9.3040224218E-01],
	[3.0270000000E+04, 2.4578130171E+01, 5.2159803522E+00, 8.1740050795E+00, 2.8189331113E+00, 9.3043587551E-01],
	[3.0275000000E+04, 2.4584887207E+01, 5.2159800082E+00, 8.1783786767E+00, 2.8195418865E+00, 9.3046949109E-01],
	[3.0280000000E+04, 2.4591644985E+01, 5.2159796644E+00, 8.1827538887E+00, 2.8201505211E+00, 9.3050308890E-01],
	[3.0285000000E+04, 2.4598403504E+01, 5.2159793205E+00, 8.1871307157E+00, 2.8207590152E+00, 9.3053666898E-01],
	[3.0290000000E+04, 2.4605162764E+01, 5.2159789768E+00, 8.1915091582E+00, 2.8213673688E+00, 9.3057023132E-01],
	[3.0295000000E+04, 2.4611922765E+01, 5.2159786330E+00, 8.1958892164E+00, 2.8219755817E+00, 9.3060377594E-01],
	[3.0300000000E+04, 2.4618683508E+01, 5.2159782894E+00, 8.2002708906E+00, 2.8225836541E+00, 9.3063730285E-01],
	[3.0305000000E+04, 2.4625444992E+01, 5.2159779458E+00, 8.2046541813E+00, 2.8231915859E+00, 9.3067081205E-01],
	[3.0310000000E+04, 2.4632207216E+01, 5.2159776022E+00, 8.2090390888E+00, 2.8237993771E+00, 9.3070430355E-01],
	[3.0315000000E+04, 2.4638970182E+01, 5.2159772588E+00, 8.2134256132E+00, 2.8244070277E+00, 9.3073777737E-01],
	[3.0320000000E+04, 2.4645733889E+01, 5.2159769153E+00, 8.2178137551E+00, 2.8250145376E+00, 9.3077123351E-01],
	[3.0325000000E+04, 2.4652498337E+01, 5.2159765720E+00, 8.2222035147E+00, 2.8256219069E+00, 9.3080467198E-01],
	[3.0330000000E+04, 2.4659263526E+01, 5.2159762286E+00, 8.2265948923E+00, 2.8262291355E+00, 9.3083809280E-01],
	[3.0335000000E+04, 2.4666029455E+01, 5.2159758854E+00, 8.2309878883E+00, 2.8268362235E+00, 9.3087149596E-01],
	[3.0340000000E+04, 2.4672796126E+01, 5.2159755422E+00, 8.2353825030E+00, 2.8274431707E+00, 9.3090488149E-01],
	[3.0345000000E+04, 2.4679563537E+01, 5.2159751990E+00, 8.2397787367E+00, 2.8280499773E+00, 9.3093824938E-01],
	[3.0350000000E+04, 2.4686331689E+01, 5.2159748559E+00, 8.2441765898E+00, 2.8286566431E+00, 9.3097159966E-01],
	[3.0355000000E+04, 2.4693100582E+01, 5.2159745129E+00, 8.2485760626E+00, 2.8292631683E+00, 9.3100493232E-01],
	[3.0360000000E+04, 2.4699870216E+01, 5.2159741699E+00, 8.2529771553E+00, 2.8298695527E+00, 9.3103824738E-01],
	[3.0365000000E+04, 2.4706640590E+01, 5.2159738270E+00, 8.2573798685E+00, 2.8304757963E+00, 9.3107154484E-01],
	[3.0370000000E+04, 2.4713411704E+01, 5.2159734841E+00, 8.2617842023E+00, 2.8310818992E+00, 9.3110482473E-01],
	[3.0375000000E+04, 2.4720183560E+01, 5.2159731413E+00, 8.2661901570E+00, 2.8316878613E+00, 9.3113808703E-01],
	[3.0380000000E+04, 2.4726956156E+01, 5.2159727986E+00, 8.2705977332E+00, 2.8322936827E+00, 9.3117133178E-01],
	[3.0385000000E+04, 2.4733729492E+01, 5.2159724559E+00, 8.2750069309E+00, 2.8328993632E+00, 9.3120455896E-01],
	[3.0390000000E+04, 2.4740507339E+01, 5.2159726116E+00, 8.2794177507E+00, 2.8335050995E+00, 9.3123776861E-01],
	[3.0395000000E+04, 2.4747305016E+01, 5.2159752894E+00, 8.2838301927E+00, 2.8341116900E+00, 9.3127096071E-01],
	[3.0400000000E+04, 2.4754103442E+01, 5.2159779668E+00, 8.2882442574E+00, 2.8347181403E+00, 9.3130413528E-01],
	[3.0405000000E+04, 2.4760902616E+01, 5.2159806437E+00, 8.2926599451E+00, 2.8353244504E+00, 9.3133729234E-01],
	[3.0410000000E+04, 2.4767702540E+01, 5.2159833202E+00, 8.2970772560E+00, 2.8359306204E+00, 9.3137043189E-01],
	[3.0415000000E+04, 2.4774503213E+01, 5.2159859962E+00, 8.3014961906E+00, 2.8365366501E+00, 9.3140355394E-01],
	[3.0420000000E+04, 2.4781304635E+01, 5.2159886718E+00, 8.3059167491E+00, 2.8371425397E+00, 9.3143665850E-01],
	[3.0425000000E+04, 2.4788106805E+01, 5.2159913470E+00, 8.3103389319E+00, 2.8377482889E+00, 9.3146974557E-01],
	[3.0430000000E+04, 2.4794909725E+01, 5.2159940217E+00, 8.3147627394E+00, 2.8383538980E+00, 9.3150281518E-01],
	[3.0435000000E+04, 2.4801713393E+01, 5.2159966960E+00, 8.3191881717E+00, 2.8389593668E+00, 9.3153586732E-01],
	[3.0440000000E+04, 2.4808517811E+01, 5.2159993698E+00, 8.3236152293E+00, 2.8395646953E+00, 9.3156890201E-01],
	[3.0445000000E+04, 2.4815322977E+01, 5.2160020433E+00, 8.3280439125E+00, 2.8401698836E+00, 9.3160191925E-01],
	[3.0450000000E+04, 2.4822128891E+01, 5.2160047162E+00, 8.3324742217E+00, 2.8407749315E+00, 9.3163491906E-01],
	[3.0455000000E+04, 2.4828935555E+01, 5.2160073888E+00, 8.3369061571E+00, 2.8413798392E+00, 9.3166790145E-01],
	[3.0460000000E+04, 2.4835742967E+01, 5.2160100609E+00, 8.3413397190E+00, 2.8419846065E+00, 9.3170086641E-01],
	[3.0465000000E+04, 2.4842551128E+01, 5.2160127325E+00, 8.3457749079E+00, 2.8425892336E+00, 9.3173381398E-01],
	[3.0470000000E+04, 2.4849360037E+01, 5.2160154037E+00, 8.3502117240E+00, 2.8431937203E+00, 9.3176674414E-01],
	[3.0475000000E+04, 2.4856169695E+01, 5.2160180745E+00, 8.3546501676E+00, 2.8437980666E+00, 9.3179965692E-01],
	[3.0480000000E+04, 2.4862980101E+01, 5.2160207449E+00, 8.3590902392E+00, 2.8444022726E+00, 9.3183255232E-01],
	[3.0485000000E+04, 2.4869791255E+01, 5.2160234148E+00, 8.3635319390E+00, 2.8450063382E+00, 9.3186543034E-01],
	[3.0490000000E+04, 2.4876603159E+01, 5.2160260843E+00, 8.3679752673E+00, 2.8456102635E+00, 9.3189829101E-01],
	[3.0495000000E+04, 2.4883415810E+01, 5.2160287533E+00, 8.3724202245E+00, 2.8462140483E+00, 9.3193113433E-01],
	[3.0500000000E+04, 2.4890229210E+01, 5.2160314219E+00, 8.3768668109E+00, 2.8468176928E+00, 9.3196396030E-01],
	[3.0505000000E+04, 2.4897043358E+01, 5.2160340901E+00, 8.3813150268E+00, 2.8474211969E+00, 9.3199676895E-01],
	[3.0510000000E+04, 2.4903858254E+01, 5.2160367578E+00, 8.3857648726E+00, 2.8480245605E+00, 9.3202956027E-01],
	[3.0515000000E+04, 2.4910673899E+01, 5.2160394251E+00, 8.3902163486E+00, 2.8486277837E+00, 9.3206233427E-01],
	[3.0520000000E+04, 2.4917490291E+01, 5.2160420920E+00, 8.3946694551E+00, 2.8492308664E+00, 9.3209509098E-01],
	[3.0525000000E+04, 2.4924307432E+01, 5.2160447584E+00, 8.3991241925E+00, 2.8498338087E+00, 9.3212783038E-01],
	[3.0530000000E+04, 2.4931125321E+01, 5.2160474244E+00, 8.4035805610E+00, 2.8504366106E+00, 9.3216055251E-01],
	[3.0535000000E+04, 2.4937943958E+01, 5.2160500899E+00, 8.4080385610E+00, 2.8510392719E+00, 9.3219325735E-01],
	[3.0540000000E+04, 2.4944763342E+01, 5.2160527551E+00, 8.4124981929E+00, 2.8516417928E+00, 9.3222594493E-01],
	[3.0545000000E+04, 2.4951583475E+01, 5.2160554198E+00, 8.4169594569E+00, 2.8522441732E+00, 9.3225861525E-01],
	[3.0550000000E+04, 2.4958404356E+01, 5.2160580840E+00, 8.4214223535E+00, 2.8528464131E+00, 9.3229126832E-01],
	[3.0555000000E+04, 2.4965225985E+01, 5.2160607478E+00, 8.4258868828E+00, 2.8534485125E+00, 9.3232390415E-01],
	[3.0560000000E+04, 2.4972048361E+01, 5.2160634112E+00, 8.4303530453E+00, 2.8540504713E+00, 9.3235652275E-01],
	[3.0565000000E+04, 2.4978871485E+01, 5.2160660741E+00, 8.4348208413E+00, 2.8546522896E+00, 9.3238912413E-01],
	[3.0570000000E+04, 2.4985695357E+01, 5.2160687367E+00, 8.4392902710E+00, 2.8552539674E+00, 9.3242170830E-01],
	[3.0575000000E+04, 2.4992519977E+01, 5.2160713987E+00, 8.4437613349E+00, 2.8558555046E+00, 9.3245427527E-01],
	[3.0580000000E+04, 2.4999345344E+01, 5.2160740604E+00, 8.4482340333E+00, 2.8564569012E+00, 9.3248682504E-01],
	[3.0585000000E+04, 2.5006171459E+01, 5.2160767216E+00, 8.4527083664E+00, 2.8570581573E+00, 9.3251935763E-01],
	[3.0590000000E+04, 2.5012998322E+01, 5.2160793824E+00, 8.4571843347E+00, 2.8576592727E+00, 9.3255187305E-01],
	[3.0595000000E+04, 2.5019825932E+01, 5.2160820427E+00, 8.4616619384E+00, 2.8582602476E+00, 9.3258437130E-01],
	[3.0600000000E+04, 2.5026654290E+01, 5.2160847026E+00, 8.4661411779E+00, 2.8588610819E+00, 9.3261685239E-01],
	[3.0605000000E+04, 2.5033483395E+01, 5.2160873621E+00, 8.4706220535E+00, 2.8594617756E+00, 9.3264931634E-01],
	[3.0610000000E+04, 2.5040313247E+01, 5.2160900211E+00, 8.4751045656E+00, 2.8600623286E+00, 9.3268176315E-01],
	[3.0615000000E+04, 2.5047143847E+01, 5.2160926797E+00, 8.4795887144E+00, 2.8606627410E+00, 9.3271419283E-01],
	[3.0620000000E+04, 2.5053975194E+01, 5.2160953379E+00, 8.4840745003E+00, 2.8612630128E+00, 9.3274660540E-01],
	[3.0625000000E+04, 2.5060807289E+01, 5.2160979957E+00, 8.4885619236E+00, 2.8618631439E+00, 9.3277900085E-01],
	[3.0630000000E+04, 2.5067640131E+01, 5.2161006530E+00, 8.4930509846E+00, 2.8624631343E+00, 9.3281137921E-01],
	[3.0635000000E+04, 2.5074473720E+01, 5.2161033099E+00, 8.4975416838E+00, 2.8630629841E+00, 9.3284374047E-01],
	[3.0640000000E+04, 2.5081308056E+01, 5.2161059663E+00, 8.5020340213E+00, 2.8636626932E+00, 9.3287608465E-01],
	[3.0645000000E+04, 2.5088143140E+01, 5.2161086223E+00, 8.5065279976E+00, 2.8642622616E+00, 9.3290841176E-01],
	[3.0650000000E+04, 2.5094978970E+01, 5.2161112779E+00, 8.5110236130E+00, 2.8648616893E+00, 9.3294072180E-01],
	[3.0655000000E+04, 2.5101815548E+01, 5.2161139331E+00, 8.5155208677E+00, 2.8654609763E+00, 9.3297301480E-01],
	[3.0660000000E+04, 2.5108652872E+01, 5.2161165878E+00, 8.5200197622E+00, 2.8660601225E+00, 9.3300529074E-01],
	[3.0665000000E+04, 2.5115490944E+01, 5.2161192421E+00, 8.5245202967E+00, 2.8666591281E+00, 9.3303754965E-01],
	[3.0670000000E+04, 2.5122329763E+01, 5.2161218959E+00, 8.5290224716E+00, 2.8672579929E+00, 9.3306979154E-01],
	[3.0675000000E+04, 2.5129169328E+01, 5.2161245494E+00, 8.5335262872E+00, 2.8678567170E+00, 9.3310201641E-01],
	[3.0680000000E+04, 2.5136009640E+01, 5.2161272024E+00, 8.5380317438E+00, 2.8684553003E+00, 9.3313422427E-01],
	[3.0685000000E+04, 2.5142850700E+01, 5.2161298549E+00, 8.5425388418E+00, 2.8690537428E+00, 9.3316641513E-01],
	[3.0690000000E+04, 2.5149692506E+01, 5.2161325070E+00, 8.5470475815E+00, 2.8696520446E+00, 9.3319858900E-01],
	[3.0695000000E+04, 2.5156535058E+01, 5.2161351588E+00, 8.5515579632E+00, 2.8702502056E+00, 9.3323074589E-01],
	[3.0700000000E+04, 2.5163378358E+01, 5.2161378100E+00, 8.5560699873E+00, 2.8708482258E+00, 9.3326288581E-01],
	[3.0705000000E+04, 2.5170222404E+01, 5.2161404609E+00, 8.5605836541E+00, 2.8714461052E+00, 9.3329500877E-01],
	[3.0710000000E+04, 2.5177067196E+01, 5.2161431113E+00, 8.5650989638E+00, 2.8720438438E+00, 9.3332711478E-01],
	[3.0715000000E+04, 2.5183912736E+01, 5.2161457613E+00, 8.5696159170E+00, 2.8726414416E+00, 9.3335920384E-01],
	[3.0720000000E+04, 2.5190759022E+01, 5.2161484108E+00, 8.5741345137E+00, 2.8732388986E+00, 9.3339127598E-01],
	[3.0725000000E+04, 2.5197606054E+01, 5.2161510599E+00, 8.5786547545E+00, 2.8738362147E+00, 9.3342333118E-01],
	[3.0730000000E+04, 2.5204453833E+01, 5.2161537086E+00, 8.5831766396E+00, 2.8744333901E+00, 9.3345536947E-01],
	[3.0735000000E+04, 2.5211302358E+01, 5.2161563569E+00, 8.5877001694E+00, 2.8750304245E+00, 9.3348739086E-01],
	[3.0740000000E+04, 2.5218151629E+01, 5.2161590047E+00, 8.5922253441E+00, 2.8756273181E+00, 9.3351939534E-01],
	[3.0745000000E+04, 2.5225001647E+01, 5.2161616521E+00, 8.5967521642E+00, 2.8762240708E+00, 9.3355138294E-01],
	[3.0750000000E+04, 2.5231852412E+01, 5.2161642991E+00, 8.6012806299E+00, 2.8768206827E+00, 9.3358335366E-01],
	[3.0755000000E+04, 2.5238703922E+01, 5.2161669456E+00, 8.6058107416E+00, 2.8774171537E+00, 9.3361530752E-01],
	[3.0760000000E+04, 2.5245556179E+01, 5.2161695918E+00, 8.6103424995E+00, 2.8780134838E+00, 9.3364724451E-01],
	[3.0765000000E+04, 2.5252409182E+01, 5.2161722374E+00, 8.6148759041E+00, 2.8786096730E+00, 9.3367916465E-01],
	[3.0770000000E+04, 2.5259262931E+01, 5.2161748827E+00, 8.6194109557E+00, 2.8792057213E+00, 9.3371106795E-01],
	[3.0775000000E+04, 2.5266117426E+01, 5.2161775275E+00, 8.6239476546E+00, 2.8798016287E+00, 9.3374295441E-01],
	[3.0780000000E+04, 2.5272972667E+01, 5.2161801719E+00, 8.6284860010E+00, 2.8803973951E+00, 9.3377482406E-01],
	[3.0785000000E+04, 2.5279828655E+01, 5.2161828159E+00, 8.6330259954E+00, 2.8809930207E+00, 9.3380667689E-01],
	[3.0790000000E+04, 2.5286685388E+01, 5.2161854595E+00, 8.6375676381E+00, 2.8815885053E+00, 9.3383851291E-01],
	[3.0795000000E+04, 2.5293542867E+01, 5.2161881026E+00, 8.6421109294E+00, 2.8821838489E+00, 9.3387033214E-01],
	[3.0800000000E+04, 2.5300401092E+01, 5.2161907453E+00, 8.6466558697E+00, 2.8827790516E+00, 9.3390213458E-01],
	[3.0805000000E+04, 2.5307260063E+01, 5.2161933875E+00, 8.6512024592E+00, 2.8833741134E+00, 9.3393392025E-01],
	[3.0810000000E+04, 2.5314119780E+01, 5.2161960294E+00, 8.6557506983E+00, 2.8839690341E+00, 9.3396568914E-01],
	[3.0815000000E+04, 2.5320980243E+01, 5.2161986708E+00, 8.6603005873E+00, 2.8845638140E+00, 9.3399744128E-01],
	[3.0820000000E+04, 2.5327841451E+01, 5.2162013117E+00, 8.6648521265E+00, 2.8851584528E+00, 9.3402917667E-01],
	[3.0825000000E+04, 2.5334703405E+01, 5.2162039523E+00, 8.6694053164E+00, 2.8857529506E+00, 9.3406089532E-01],
	[3.0830000000E+04, 2.5341566105E+01, 5.2162065924E+00, 8.6739601571E+00, 2.8863473075E+00, 9.3409259723E-01],
	[3.0835000000E+04, 2.5348429550E+01, 5.2162092321E+00, 8.6785166491E+00, 2.8869415233E+00, 9.3412428243E-01],
	[3.0840000000E+04, 2.5355293741E+01, 5.2162118714E+00, 8.6830747927E+00, 2.8875355982E+00, 9.3415595091E-01],
	[3.0845000000E+04, 2.5362158677E+01, 5.2162145102E+00, 8.6876345881E+00, 2.8881295320E+00, 9.3418760269E-01],
	[3.0850000000E+04, 2.5369024359E+01, 5.2162171487E+00, 8.6921960358E+00, 2.8887233248E+00, 9.3421923777E-01],
	[3.0855000000E+04, 2.5375890787E+01, 5.2162197867E+00, 8.6967591360E+00, 2.8893169766E+00, 9.3425085617E-01],
	[3.0860000000E+04, 2.5382757960E+01, 5.2162224242E+00, 8.7013238891E+00, 2.8899104873E+00, 9.3428245789E-01],
	[3.0865000000E+04, 2.5389625878E+01, 5.2162250614E+00, 8.7058902955E+00, 2.8905038570E+00, 9.3431404295E-01],
	[3.0870000000E+04, 2.5396494541E+01, 5.2162276981E+00, 8.7104583554E+00, 2.8910970856E+00, 9.3434561135E-01],
	[3.0875000000E+04, 2.5403363950E+01, 5.2162303344E+00, 8.7150280691E+00, 2.8916901732E+00, 9.3437716309E-01],
	[3.0880000000E+04, 2.5410241359E+01, 5.2162339167E+00, 8.7195994371E+00, 2.8922835047E+00, 9.3440869820E-01],
	[3.0885000000E+04, 2.5417134926E+01, 5.2162395085E+00, 8.7241724596E+00, 2.8928775132E+00, 9.3444021668E-01],
	[3.0890000000E+04, 2.5424029248E+01, 5.2162450994E+00, 8.7287471369E+00, 2.8934713812E+00, 9.3447171854E-01],
	[3.0895000000E+04, 2.5430924322E+01, 5.2162506893E+00, 8.7333234694E+00, 2.8940651088E+00, 9.3450320379E-01],
	[3.0900000000E+04, 2.5437820151E+01, 5.2162562784E+00, 8.7379014575E+00, 2.8946586959E+00, 9.3453467243E-01],
	[3.0905000000E+04, 2.5444716733E+01, 5.2162618666E+00, 8.7424811014E+00, 2.8952521425E+00, 9.3456612447E-01],
	[3.0910000000E+04, 2.5451614069E+01, 5.2162674539E+00, 8.7470624015E+00, 2.8958454487E+00, 9.3459755993E-01],
	[3.0915000000E+04, 2.5458512159E+01, 5.2162730402E+00, 8.7516453581E+00, 2.8964386144E+00, 9.3462897880E-01],
	[3.0920000000E+04, 2.5465411002E+01, 5.2162786257E+00, 8.7562299715E+00, 2.8970316396E+00, 9.3466038110E-01],
	[3.0925000000E+04, 2.5472310598E+01, 5.2162842103E+00, 8.7608162421E+00, 2.8976245243E+00, 9.3469176684E-01],
	[3.0930000000E+04, 2.5479210948E+01, 5.2162897940E+00, 8.7654041702E+00, 2.8982172685E+00, 9.3472313602E-01],
	[3.0935000000E+04, 2.5486112052E+01, 5.2162953768E+00, 8.7699937561E+00, 2.8988098722E+00, 9.3475448865E-01],
	[3.0940000000E+04, 2.5493013909E+01, 5.2163009587E+00, 8.7745850002E+00, 2.8994023354E+00, 9.3478582474E-01],
	[3.0945000000E+04, 2.5499916519E+01, 5.2163065397E+00, 8.7791779028E+00, 2.8999946581E+00, 9.3481714430E-01],
	[3.0950000000E+04, 2.5506819882E+01, 5.2163121198E+00, 8.7837724641E+00, 2.9005868403E+00, 9.3484844733E-01],
	[3.0955000000E+04, 2.5513723999E+01, 5.2163176990E+00, 8.7883686847E+00, 2.9011788819E+00, 9.3487973385E-01],
	[3.0960000000E+04, 2.5520628869E+01, 5.2163232773E+00, 8.7929665646E+00, 2.9017707830E+00, 9.3491100386E-01],
	[3.0965000000E+04, 2.5527534492E+01, 5.2163288547E+00, 8.7975661044E+00, 2.9023625435E+00, 9.3494225737E-01],
	[3.0970000000E+04, 2.5534440869E+01, 5.2163344312E+00, 8.8021673044E+00, 2.9029541635E+00, 9.3497349438E-01],
	[3.0975000000E+04, 2.5541347998E+01, 5.2163400068E+00, 8.8067701648E+00, 2.9035456429E+00, 9.3500471491E-01],
	[3.0980000000E+04, 2.5548255881E+01, 5.2163455816E+00, 8.8113746859E+00, 2.9041369818E+00, 9.3503591897E-01],
	[3.0985000000E+04, 2.5555164517E+01, 5.2163511554E+00, 8.8159808682E+00, 2.9047281801E+00, 9.3506710655E-01],
	[3.0990000000E+04, 2.5562073905E+01, 5.2163567284E+00, 8.8205887120E+00, 2.9053192378E+00, 9.3509827768E-01],
	[3.0995000000E+04, 2.5568984047E+01, 5.2163623004E+00, 8.8251982175E+00, 2.9059101550E+00, 9.3512943236E-01],
	[3.1000000000E+04, 2.5575894941E+01, 5.2163678716E+00, 8.8298093852E+00, 2.9065009315E+00, 9.3516057059E-01],
	[3.1005000000E+04, 2.5582806589E+01, 5.2163734418E+00, 8.8344222153E+00, 2.9070915675E+00, 9.3519169238E-01],
	[3.1010000000E+04, 2.5589718989E+01, 5.2163790112E+00, 8.8390367081E+00, 2.9076820629E+00, 9.3522279775E-01],
	[3.1015000000E+04, 2.5596632142E+01, 5.2163845797E+00, 8.8436528641E+00, 2.9082724177E+00, 9.3525388670E-01],
	[3.1020000000E+04, 2.5603546048E+01, 5.2163901473E+00, 8.8482706835E+00, 2.9088626318E+00, 9.3528495923E-01],
	[3.1025000000E+04, 2.5610460707E+01, 5.2163957140E+00, 8.8528901666E+00, 2.9094527054E+00, 9.3531601537E-01],
	[3.1030000000E+04, 2.5617376118E+01, 5.2164012798E+00, 8.8575113138E+00, 2.9100426383E+00, 9.3534705510E-01],
	[3.1035000000E+04, 2.5624292282E+01, 5.2164068447E+00, 8.8621341255E+00, 2.9106324306E+00, 9.3537807845E-01],
	[3.1040000000E+04, 2.5631209198E+01, 5.2164124087E+00, 8.8667586019E+00, 2.9112220823E+00, 9.3540908542E-01],
	[3.1045000000E+04, 2.5638126867E+01, 5.2164179719E+00, 8.8713847434E+00, 2.9118115934E+00, 9.3544007602E-01],
	[3.1050000000E+04, 2.5645045289E+01, 5.2164235341E+00, 8.8760125502E+00, 2.9124009638E+00, 9.3547105026E-01],
	[3.1055000000E+04, 2.5651964463E+01, 5.2164290955E+00, 8.8806420228E+00, 2.9129901935E+00, 9.3550200814E-01],
	[3.1060000000E+04, 2.5658884389E+01, 5.2164346559E+00, 8.8852731615E+00, 2.9135792826E+00, 9.3553294967E-01],
	[3.1065000000E+04, 2.5665805068E+01, 5.2164402155E+00, 8.8899059666E+00, 2.9141682311E+00, 9.3556387487E-01],
	[3.1070000000E+04, 2.5672726500E+01, 5.2164457742E+00, 8.8945404384E+00, 2.9147570389E+00, 9.3559478373E-01],
	[3.1075000000E+04, 2.5679648683E+01, 5.2164513320E+00, 8.8991765773E+00, 2.9153457060E+00, 9.3562567628E-01],
	[3.1080000000E+04, 2.5686571619E+01, 5.2164568889E+00, 8.9038143835E+00, 2.9159342325E+00, 9.3565655250E-01],
	[3.1085000000E+04, 2.5693495308E+01, 5.2164624449E+00, 8.9084538575E+00, 2.9165226183E+00, 9.3568741242E-01],
	[3.1090000000E+04, 2.5700419748E+01, 5.2164680001E+00, 8.9130949995E+00, 2.9171108634E+00, 9.3571825605E-01],
	[3.1095000000E+04, 2.5707344941E+01, 5.2164735543E+00, 8.9177378099E+00, 2.9176989678E+00, 9.3574908338E-01],
	[3.1100000000E+04, 2.5714270885E+01, 5.2164791077E+00, 8.9223822890E+00, 2.9182869315E+00, 9.3577989443E-01],
	[3.1105000000E+04, 2.5721197582E+01, 5.2164846602E+00, 8.9270284371E+00, 2.9188747545E+00, 9.3581068920E-01],
	[3.1110000000E+04, 2.5728125031E+01, 5.2164902118E+00, 8.9316762546E+00, 2.9194624369E+00, 9.3584146771E-01],
	[3.1115000000E+04, 2.5735053232E+01, 5.2164957625E+00, 8.9363257418E+00, 2.9200499785E+00, 9.3587222997E-01],
	[3.1120000000E+04, 2.5741982185E+01, 5.2165013123E+00, 8.9409768990E+00, 2.9206373794E+00, 9.3590297597E-01],
	[3.1125000000E+04, 2.5748911890E+01, 5.2165068612E+00, 8.9456297266E+00, 2.9212246396E+00, 9.3593370573E-01],
	[3.1130000000E+04, 2.5755842346E+01, 5.2165124093E+00, 8.9502842248E+00, 2.9218117591E+00, 9.3596441925E-01],
	[3.1135000000E+04, 2.5762773555E+01, 5.2165179564E+00, 8.9549403941E+00, 2.9223987379E+00, 9.3599511655E-01],
	[3.1140000000E+04, 2.5769705515E+01, 5.2165235027E+00, 8.9595982347E+00, 2.9229855759E+00, 9.3602579764E-01],
	[3.1145000000E+04, 2.5776638228E+01, 5.2165290481E+00, 8.9642577470E+00, 2.9235722732E+00, 9.3605646251E-01],
	[3.1150000000E+04, 2.5783571692E+01, 5.2165345926E+00, 8.9689189313E+00, 2.9241588298E+00, 9.3608711118E-01],
	[3.1155000000E+04, 2.5790505907E+01, 5.2165401362E+00, 8.9735817879E+00, 2.9247452456E+00, 9.3611774366E-01],
	[3.1160000000E+04, 2.5797440875E+01, 5.2165456790E+00, 8.9782463172E+00, 2.9253315207E+00, 9.3614835996E-01],
	[3.1165000000E+04, 2.5804376593E+01, 5.2165512208E+00, 8.9829125194E+00, 2.9259176551E+00, 9.3617896008E-01],
	[3.1170000000E+04, 2.5811313064E+01, 5.2165567618E+00, 8.9875803951E+00, 2.9265036486E+00, 9.3620954402E-01],
	[3.1175000000E+04, 2.5818250286E+01, 5.2165623019E+00, 8.9922499443E+00, 2.9270895015E+00, 9.3624011181E-01],
	[3.1180000000E+04, 2.5825188260E+01, 5.2165678411E+00, 8.9969211676E+00, 2.9276752136E+00, 9.3627066345E-01],
	[3.1185000000E+04, 2.5832126985E+01, 5.2165733794E+00, 9.0015940651E+00, 2.9282607849E+00, 9.3630119894E-01],
	[3.1190000000E+04, 2.5839066461E+01, 5.2165789169E+00, 9.0062686373E+00, 2.9288462154E+00, 9.3633171829E-01],
	[3.1195000000E+04, 2.5846006689E+01, 5.2165844534E+00, 9.0109448845E+00, 2.9294315052E+00, 9.3636222152E-01],
	[3.1200000000E+04, 2.5852947668E+01, 5.2165899891E+00, 9.0156228070E+00, 2.9300166542E+00, 9.3639270862E-01],
	[3.1205000000E+04, 2.5859889399E+01, 5.2165955239E+00, 9.0203024051E+00, 2.9306016624E+00, 9.3642317962E-01],
	[3.1210000000E+04, 2.5866831881E+01, 5.2166010578E+00, 9.0249836792E+00, 2.9311865298E+00, 9.3645363451E-01],
	[3.1215000000E+04, 2.5873775114E+01, 5.2166065908E+00, 9.0296666296E+00, 2.9317712565E+00, 9.3648407330E-01],
	[3.1220000000E+04, 2.5880719098E+01, 5.2166121230E+00, 9.0343512566E+00, 2.9323558423E+00, 9.3651449601E-01],
	[3.1225000000E+04, 2.5887663833E+01, 5.2166176543E+00, 9.0390375605E+00, 2.9329402874E+00, 9.3654490263E-01],
	[3.1230000000E+04, 2.5894609320E+01, 5.2166231847E+00, 9.0437255418E+00, 2.9335245917E+00, 9.3657529318E-01],
	[3.1235000000E+04, 2.5901555558E+01, 5.2166287142E+00, 9.0484152007E+00, 2.9341087552E+00, 9.3660566768E-01],
	[3.1240000000E+04, 2.5908502546E+01, 5.2166342428E+00, 9.0531065375E+00, 2.9346927778E+00, 9.3663602611E-01],
	[3.1245000000E+04, 2.5915450286E+01, 5.2166397706E+00, 9.0577995525E+00, 2.9352766597E+00, 9.3666636850E-01],
	[3.1250000000E+04, 2.5922398776E+01, 5.2166452975E+00, 9.0624942462E+00, 2.9358604007E+00, 9.3669669485E-01],
	[3.1255000000E+04, 2.5929348018E+01, 5.2166508235E+00, 9.0671906189E+00, 2.9364440010E+00, 9.3672700516E-01],
	[3.1260000000E+04, 2.5936298010E+01, 5.2166563486E+00, 9.0718886708E+00, 2.9370274604E+00, 9.3675729946E-01],
	[3.1265000000E+04, 2.5943248754E+01, 5.2166618728E+00, 9.0765884023E+00, 2.9376107790E+00, 9.3678757774E-01],
	[3.1270000000E+04, 2.5950200248E+01, 5.2166673962E+00, 9.0812898137E+00, 2.9381939568E+00, 9.3681784001E-01],
	[3.1275000000E+04, 2.5957152493E+01, 5.2166729187E+00, 9.0859929054E+00, 2.9387769937E+00, 9.3684808629E-01],
	[3.1280000000E+04, 2.5964105488E+01, 5.2166784403E+00, 9.0906976776E+00, 2.9393598898E+00, 9.3687831657E-01],
	[3.1285000000E+04, 2.5971059234E+01, 5.2166839611E+00, 9.0954041308E+00, 2.9399426451E+00, 9.3690853087E-01],
	[3.1290000000E+04, 2.5978013731E+01, 5.2166894809E+00, 9.1001122652E+00, 2.9405252596E+00, 9.3693872920E-01],
	[3.1295000000E+04, 2.5984968979E+01, 5.2166949999E+00, 9.1048220813E+00, 2.9411077332E+00, 9.3696891156E-01],
	[3.1300000000E+04, 2.5991924977E+01, 5.2167005180E+00, 9.1095335792E+00, 2.9416900660E+00, 9.3699907796E-01],
	[3.1305000000E+04, 2.5998881725E+01, 5.2167060352E+00, 9.1142467593E+00, 2.9422722579E+00, 9.3702922841E-01],
	[3.1310000000E+04, 2.6005839225E+01, 5.2167115516E+00, 9.1189616221E+00, 2.9428543090E+00, 9.3705936292E-01],
	[3.1315000000E+04, 2.6012797474E+01, 5.2167170671E+00, 9.1236781677E+00, 2.9434362193E+00, 9.3708948150E-01],
	[3.1320000000E+04, 2.6019756474E+01, 5.2167225817E+00, 9.1283963966E+00, 2.9440179886E+00, 9.3711958415E-01],
	[3.1325000000E+04, 2.6026716225E+01, 5.2167280954E+00, 9.1331163090E+00, 2.9445996172E+00, 9.3714967089E-01],
	[3.1330000000E+04, 2.6033676725E+01, 5.2167336083E+00, 9.1378379053E+00, 2.9451811049E+00, 9.3717974171E-01],
	[3.1335000000E+04, 2.6040637976E+01, 5.2167391203E+00, 9.1425611858E+00, 2.9457624517E+00, 9.3720979663E-01],
	[3.1340000000E+04, 2.6047599978E+01, 5.2167446314E+00, 9.1472861509E+00, 2.9463436576E+00, 9.3723983566E-01],
	[3.1345000000E+04, 2.6054562729E+01, 5.2167501416E+00, 9.1520128009E+00, 2.9469247227E+00, 9.3726985881E-01],
	[3.1350000000E+04, 2.6061526231E+01, 5.2167556510E+00, 9.1567411361E+00, 2.9475056470E+00, 9.3729986608E-01],
	[3.1355000000E+04, 2.6068490483E+01, 5.2167611595E+00, 9.1614711568E+00, 2.9480864303E+00, 9.3732985748E-01],
	[3.1360000000E+04, 2.6075455484E+01, 5.2167666671E+00, 9.1662028634E+00, 2.9486670728E+00, 9.3735983301E-01],
	[3.1365000000E+04, 2.6082421236E+01, 5.2167721739E+00, 9.1709362562E+00, 2.9492475744E+00, 9.3738979270E-01],
	[3.1370000000E+04, 2.6089387738E+01, 5.2167776797E+00, 9.1756713356E+00, 2.9498279352E+00, 9.3741973654E-01],
	[3.1375000000E+04, 2.6096354991E+01, 5.2167831847E+00, 9.1804081018E+00, 2.9504081551E+00, 9.3744966454E-01],
	[3.1380000000E+04, 2.6103343215E+01, 5.2167912937E+00, 9.1851465552E+00, 2.9509893260E+00, 9.3747957672E-01],
	[3.1385000000E+04, 2.6110334442E+01, 5.2167996905E+00, 9.1898866961E+00, 2.9515704778E+00, 9.3750947308E-01],
	[3.1390000000E+04, 2.6117326427E+01, 5.2168080859E+00, 9.1946285249E+00, 2.9521514894E+00, 9.3753935362E-01],
	[3.1395000000E+04, 2.6124319171E+01, 5.2168164800E+00, 9.1993720419E+00, 2.9527323607E+00, 9.3756921836E-01],
	[3.1400000000E+04, 2.6131312673E+01, 5.2168248728E+00, 9.2041172473E+00, 2.9533130917E+00, 9.3759906730E-01],
	[3.1405000000E+04, 2.6138306933E+01, 5.2168332643E+00, 9.2088641417E+00, 2.9538936824E+00, 9.3762890046E-01],
	[3.1410000000E+04, 2.6145301951E+01, 5.2168416545E+00, 9.2136127252E+00, 2.9544741328E+00, 9.3765871784E-01],
	[3.1415000000E+04, 2.6152297727E+01, 5.2168500433E+00, 9.2183629982E+00, 2.9550544430E+00, 9.3768851944E-01],
	[3.1420000000E+04, 2.6159294262E+01, 5.2168584308E+00, 9.2231149611E+00, 2.9556346128E+00, 9.3771830528E-01],
	[3.1425000000E+04, 2.6166291554E+01, 5.2168668170E+00, 9.2278686141E+00, 2.9562146424E+00, 9.3774807537E-01],
	[3.1430000000E+04, 2.6173289605E+01, 5.2168752019E+00, 9.2326239577E+00, 2.9567945316E+00, 9.3777782971E-01],
	[3.1435000000E+04, 2.6180288413E+01, 5.2168835854E+00, 9.2373809921E+00, 2.9573742806E+00, 9.3780756831E-01],
	[3.1440000000E+04, 2.6187287979E+01, 5.2168919677E+00, 9.2421397176E+00, 2.9579538893E+00, 9.3783729118E-01],
	[3.1445000000E+04, 2.6194288304E+01, 5.2169003486E+00, 9.2469001346E+00, 2.9585333577E+00, 9.3786699833E-01],
	[3.1450000000E+04, 2.6201289386E+01, 5.2169087282E+00, 9.2516622435E+00, 2.9591126857E+00, 9.3789668976E-01],
	[3.1455000000E+04, 2.6208291226E+01, 5.2169171065E+00, 9.2564260445E+00, 2.9596918735E+00, 9.3792636548E-01],
	[3.1460000000E+04, 2.6215293823E+01, 5.2169254834E+00, 9.2611915380E+00, 2.9602709210E+00, 9.3795602551E-01],
	[3.1465000000E+04, 2.6222297179E+01, 5.2169338591E+00, 9.2659587243E+00, 2.9608498281E+00, 9.3798566985E-01],
	[3.1470000000E+04, 2.6229301292E+01, 5.2169422334E+00, 9.2707276038E+00, 2.9614285950E+00, 9.3801529850E-01],
	[3.1475000000E+04, 2.6236306162E+01, 5.2169506064E+00, 9.2754981767E+00, 2.9620072215E+00, 9.3804491148E-01],
	[3.1480000000E+04, 2.6243311791E+01, 5.2169589781E+00, 9.2802704435E+00, 2.9625857078E+00, 9.3807450879E-01],
	[3.1485000000E+04, 2.6250318177E+01, 5.2169673484E+00, 9.2850444044E+00, 2.9631640537E+00, 9.3810409045E-01],
	[3.1490000000E+04, 2.6257325320E+01, 5.2169757175E+00, 9.2898200597E+00, 2.9637422593E+00, 9.3813365645E-01],
	[3.1495000000E+04, 2.6264333221E+01, 5.2169840852E+00, 9.2945974099E+00, 2.9643203246E+00, 9.3816320682E-01],
	[3.1500000000E+04, 2.6271341879E+01, 5.2169924517E+00, 9.2993764552E+00, 2.9648982496E+00, 9.3819274155E-01],
	[3.1505000000E+04, 2.6278351295E+01, 5.2170008168E+00, 9.3041571959E+00, 2.9654760343E+00, 9.3822226065E-01],
	[3.1510000000E+04, 2.6285361468E+01, 5.2170091806E+00, 9.3089396325E+00, 2.9660536786E+00, 9.3825176414E-01],
	[3.1515000000E+04, 2.6292372399E+01, 5.2170175431E+00, 9.3137237651E+00, 2.9666311827E+00, 9.3828125202E-01],
	[3.1520000000E+04, 2.6299384087E+01, 5.2170259042E+00, 9.3185095942E+00, 2.9672085464E+00, 9.3831072430E-01],
	[3.1525000000E+04, 2.6306396532E+01, 5.2170342641E+00, 9.3232971202E+00, 2.9677857698E+00, 9.3834018098E-01],
	[3.1530000000E+04, 2.6313409734E+01, 5.2170426226E+00, 9.3280863432E+00, 2.9683628528E+00, 9.3836962208E-01],
	[3.1535000000E+04, 2.6320423694E+01, 5.2170509799E+00, 9.3328772637E+00, 2.9689397956E+00, 9.3839904760E-01],
	[3.1540000000E+04, 2.6327438411E+01, 5.2170593358E+00, 9.3376698819E+00, 2.9695165980E+00, 9.3842845755E-01],
	[3.1545000000E+04, 2.6334453885E+01, 5.2170676904E+00, 9.3424641983E+00, 2.9700932601E+00, 9.3845785195E-01],
	[3.1550000000E+04, 2.6341470115E+01, 5.2170760437E+00, 9.3472602131E+00, 2.9706697819E+00, 9.3848723079E-01],
	[3.1555000000E+04, 2.6348487103E+01, 5.2170843957E+00, 9.3520579266E+00, 2.9712461634E+00, 9.3851659408E-01],
	[3.1560000000E+04, 2.6355504848E+01, 5.2170927464E+00, 9.3568573393E+00, 2.9718224045E+00, 9.3854594184E-01],
	[3.1565000000E+04, 2.6362523350E+01, 5.2171010957E+00, 9.3616584514E+00, 2.9723985053E+00, 9.3857527407E-01],
	[3.1570000000E+04, 2.6369542609E+01, 5.2171094438E+00, 9.3664612633E+00, 2.9729744658E+00, 9.3860459078E-01],
	[3.1575000000E+04, 2.6376562625E+01, 5.2171177906E+00, 9.3712657753E+00, 2.9735502860E+00, 9.3863389198E-01],
	[3.1580000000E+04, 2.6383583397E+01, 5.2171261360E+00, 9.3760719877E+00, 2.9741259658E+00, 9.3866317768E-01],
	[3.1585000000E+04, 2.6390604927E+01, 5.2171344801E+00, 9.3808799008E+00, 2.9747015053E+00, 9.3869244788E-01],
	[3.1590000000E+04, 2.6397627213E+01, 5.2171428230E+00, 9.3856895150E+00, 2.9752769044E+00, 9.3872170259E-01],
	[3.1595000000E+04, 2.6404650256E+01, 5.2171511645E+00, 9.3905008307E+00, 2.9758521633E+00, 9.3875094182E-01],
	[3.1600000000E+04, 2.6411674056E+01, 5.2171595047E+00, 9.3953138481E+00, 2.9764272818E+00, 9.3878016558E-01],
	[3.1605000000E+04, 2.6418698612E+01, 5.2171678436E+00, 9.4001285676E+00, 2.9770022600E+00, 9.3880937388E-01],
	[3.1610000000E+04, 2.6425723925E+01, 5.2171761812E+00, 9.4049449895E+00, 2.9775770978E+00, 9.3883856672E-01],
	[3.1615000000E+04, 2.6432749994E+01, 5.2171845175E+00, 9.4097631141E+00, 2.9781517954E+00, 9.3886774411E-01],
	[3.1620000000E+04, 2.6439776820E+01, 5.2171928525E+00, 9.4145829418E+00, 2.9787263525E+00, 9.3889690607E-01],
	[3.1625000000E+04, 2.6446804403E+01, 5.2172011862E+00, 9.4194044730E+00, 2.9793007694E+00, 9.3892605259E-01],
	[3.1630000000E+04, 2.6453832742E+01, 5.2172095186E+00, 9.4242277078E+00, 2.9798750459E+00, 9.3895518370E-01],
	[3.1635000000E+04, 2.6460861837E+01, 5.2172178497E+00, 9.4290526467E+00, 2.9804491821E+00, 9.3898429938E-01],
	[3.1640000000E+04, 2.6467891689E+01, 5.2172261794E+00, 9.4338792901E+00, 2.9810231780E+00, 9.3901339966E-01],
	[3.1645000000E+04, 2.6474922297E+01, 5.2172345079E+00, 9.4387076381E+00, 2.9815970336E+00, 9.3904248454E-01],
	[3.1650000000E+04, 2.6481953661E+01, 5.2172428351E+00, 9.4435376912E+00, 2.9821707488E+00, 9.3907155403E-01],
	[3.1655000000E+04, 2.6488985782E+01, 5.2172511609E+00, 9.4483694497E+00, 2.9827443237E+00, 9.3910060814E-01],
	[3.1660000000E+04, 2.6496018659E+01, 5.2172594855E+00, 9.4532029140E+00, 2.9833177582E+00, 9.3912964688E-01],
	[3.1665000000E+04, 2.6503052292E+01, 5.2172678088E+00, 9.4580380842E+00, 2.9838910524E+00, 9.3915867024E-01],
	[3.1670000000E+04, 2.6510086682E+01, 5.2172761307E+00, 9.4628749609E+00, 2.9844642063E+00, 9.3918767825E-01],
	[3.1675000000E+04, 2.6517121827E+01, 5.2172844514E+00, 9.4677135443E+00, 2.9850372199E+00, 9.3921667091E-01],
	[3.1680000000E+04, 2.6524157729E+01, 5.2172927708E+00, 9.4725538347E+00, 2.9856100932E+00, 9.3924564823E-01],
	[3.1685000000E+04, 2.6531194386E+01, 5.2173010888E+00, 9.4773958325E+00, 2.9861828261E+00, 9.3927461021E-01],
	[3.1690000000E+04, 2.6538231800E+01, 5.2173094056E+00, 9.4822395380E+00, 2.9867554187E+00, 9.3930355687E-01],
	[3.1695000000E+04, 2.6545269969E+01, 5.2173177211E+00, 9.4870849516E+00, 2.9873278709E+00, 9.3933248821E-01],
	[3.1700000000E+04, 2.6552308895E+01, 5.2173260352E+00, 9.4919320735E+00, 2.9879001829E+00, 9.3936140424E-01],
	[3.1705000000E+04, 2.6559348576E+01, 5.2173343481E+00, 9.4967809042E+00, 2.9884723545E+00, 9.3939030497E-01],
	[3.1710000000E+04, 2.6566389014E+01, 5.2173426597E+00, 9.5016314438E+00, 2.9890443858E+00, 9.3941919041E-01],
	[3.1715000000E+04, 2.6573430207E+01, 5.2173509700E+00, 9.5064836929E+00, 2.9896162767E+00, 9.3944806056E-01],
	[3.1720000000E+04, 2.6580472155E+01, 5.2173592789E+00, 9.5113376516E+00, 2.9901880274E+00, 9.3947691543E-01],
	[3.1725000000E+04, 2.6587514860E+01, 5.2173675866E+00, 9.5161933204E+00, 2.9907596377E+00, 9.3950575504E-01],
	[3.1730000000E+04, 2.6594558320E+01, 5.2173758930E+00, 9.5210506995E+00, 2.9913311077E+00, 9.3953457938E-01],
	[3.1735000000E+04, 2.6601602536E+01, 5.2173841981E+00, 9.5259097893E+00, 2.9919024374E+00, 9.3956338847E-01],
	[3.1740000000E+04, 2.6608647508E+01, 5.2173925019E+00, 9.5307705901E+00, 2.9924736268E+00, 9.3959218231E-01],
	[3.1745000000E+04, 2.6615693235E+01, 5.2174008044E+00, 9.5356331023E+00, 2.9930446758E+00, 9.3962096092E-01],
	[3.1750000000E+04, 2.6622739718E+01, 5.2174091056E+00, 9.5404973262E+00, 2.9936155845E+00, 9.3964972430E-01],
	[3.1755000000E+04, 2.6629786956E+01, 5.2174174055E+00, 9.5453632621E+00, 2.9941863529E+00, 9.3967847246E-01],
	[3.1760000000E+04, 2.6636834950E+01, 5.2174257041E+00, 9.5502309103E+00, 2.9947569810E+00, 9.3970720541E-01],
	[3.1765000000E+04, 2.6643883699E+01, 5.2174340015E+00, 9.5551002713E+00, 2.9953274688E+00, 9.3973592315E-01],
	[3.1770000000E+04, 2.6650933204E+01, 5.2174422975E+00, 9.5599713452E+00, 2.9958978163E+00, 9.3976462569E-01],
	[3.1775000000E+04, 2.6657983464E+01, 5.2174505922E+00, 9.5648441325E+00, 2.9964680235E+00, 9.3979331305E-01],
	[3.1780000000E+04, 2.6665034479E+01, 5.2174588857E+00, 9.5697186334E+00, 2.9970380903E+00, 9.3982198523E-01],
	[3.1785000000E+04, 2.6672086249E+01, 5.2174671779E+00, 9.5745948484E+00, 2.9976080169E+00, 9.3985064223E-01],
	[3.1790000000E+04, 2.6679138775E+01, 5.2174754687E+00, 9.5794727777E+00, 2.9981778031E+00, 9.3987928407E-01],
	[3.1795000000E+04, 2.6686192056E+01, 5.2174837583E+00, 9.5843524216E+00, 2.9987474490E+00, 9.3990791076E-01],
	[3.1800000000E+04, 2.6693246092E+01, 5.2174920466E+00, 9.5892337806E+00, 2.9993169547E+00, 9.3993652229E-01],
	[3.1805000000E+04, 2.6700300884E+01, 5.2175003336E+00, 9.5941168549E+00, 2.9998863200E+00, 9.3996511869E-01],
	[3.1810000000E+04, 2.6707356430E+01, 5.2175086193E+00, 9.5990016448E+00, 3.0004555450E+00, 9.3999369995E-01],
	[3.1815000000E+04, 2.6714412732E+01, 5.2175169037E+00, 9.6038881508E+00, 3.0010246297E+00, 9.4002226609E-01],
	[3.1820000000E+04, 2.6721469788E+01, 5.2175251868E+00, 9.6087763730E+00, 3.0015935742E+00, 9.4005081712E-01],
	[3.1825000000E+04, 2.6728527600E+01, 5.2175334687E+00, 9.6136663120E+00, 3.0021623783E+00, 9.4007935304E-01],
	[3.1830000000E+04, 2.6735586166E+01, 5.2175417492E+00, 9.6185579679E+00, 3.0027310421E+00, 9.4010787385E-01],
	[3.1835000000E+04, 2.6742645487E+01, 5.2175500285E+00, 9.6234513411E+00, 3.0032995657E+00, 9.4013637958E-01],
	[3.1840000000E+04, 2.6749705564E+01, 5.2175583065E+00, 9.6283464320E+00, 3.0038679489E+00, 9.4016487022E-01],
	[3.1845000000E+04, 2.6756766395E+01, 5.2175665831E+00, 9.6332432409E+00, 3.0044361919E+00, 9.4019334579E-01],
	[3.1850000000E+04, 2.6763827980E+01, 5.2175748586E+00, 9.6381417681E+00, 3.0050042946E+00, 9.4022180629E-01],
	[3.1855000000E+04, 2.6770890321E+01, 5.2175831327E+00, 9.6430420139E+00, 3.0055722570E+00, 9.4025025173E-01],
	[3.1860000000E+04, 2.6777953416E+01, 5.2175914055E+00, 9.6479439787E+00, 3.0061400791E+00, 9.4027868212E-01],
	[3.1865000000E+04, 2.6785017266E+01, 5.2175996771E+00, 9.6528476629E+00, 3.0067077609E+00, 9.4030709747E-01],
	[3.1870000000E+04, 2.6792081871E+01, 5.2176079473E+00, 9.6577530666E+00, 3.0072753025E+00, 9.4033549778E-01],
	[3.1875000000E+04, 2.6799147230E+01, 5.2176162163E+00, 9.6626601904E+00, 3.0078427037E+00, 9.4036388307E-01],
	[3.1880000000E+04, 2.6806213344E+01, 5.2176244840E+00, 9.6675690344E+00, 3.0084099647E+00, 9.4039225333E-01],
	[3.1885000000E+04, 2.6813299794E+01, 5.2176352419E+00, 9.6724795991E+00, 3.0089781607E+00, 9.4042060859E-01],
	[3.1890000000E+04, 2.6820389689E+01, 5.2176463394E+00, 9.6773918847E+00, 3.0095463642E+00, 9.4044894884E-01],
	[3.1895000000E+04, 2.6827480347E+01, 5.2176574352E+00, 9.6823058917E+00, 3.0101144280E+00, 9.4047727410E-01],
	[3.1900000000E+04, 2.6834571768E+01, 5.2176685292E+00, 9.6872216203E+00, 3.0106823521E+00, 9.4050558437E-01],
	[3.1905000000E+04, 2.6841663951E+01, 5.2176796216E+00, 9.6921390708E+00, 3.0112501366E+00, 9.4053387966E-01],
	[3.1910000000E+04, 2.6848756896E+01, 5.2176907122E+00, 9.6970582436E+00, 3.0118177813E+00, 9.4056215998E-01],
	[3.1915000000E+04, 2.6855850605E+01, 5.2177018012E+00, 9.7019791391E+00, 3.0123852864E+00, 9.4059042534E-01],
	[3.1920000000E+04, 2.6862945076E+01, 5.2177128884E+00, 9.7069017575E+00, 3.0129526518E+00, 9.4061867575E-01],
	[3.1925000000E+04, 2.6870040309E+01, 5.2177239739E+00, 9.7118260992E+00, 3.0135198775E+00, 9.4064691121E-01],
	[3.1930000000E+04, 2.6877136305E+01, 5.2177350577E+00, 9.7167521646E+00, 3.0140869636E+00, 9.4067513172E-01],
	[3.1935000000E+04, 2.6884233063E+01, 5.2177461397E+00, 9.7216799538E+00, 3.0146539100E+00, 9.4070333731E-01],
	[3.1940000000E+04, 2.6891330583E+01, 5.2177572201E+00, 9.7266094674E+00, 3.0152207167E+00, 9.4073152798E-01],
	[3.1945000000E+04, 2.6898428866E+01, 5.2177682988E+00, 9.7315407056E+00, 3.0157873837E+00, 9.4075970373E-01],
	[3.1950000000E+04, 2.6905527911E+01, 5.2177793757E+00, 9.7364736687E+00, 3.0163539111E+00, 9.4078786458E-01],
	[3.1955000000E+04, 2.6912627719E+01, 5.2177904509E+00, 9.7414083572E+00, 3.0169202988E+00, 9.4081601053E-01],
	[3.1960000000E+04, 2.6919728289E+01, 5.2178015244E+00, 9.7463447712E+00, 3.0174865469E+00, 9.4084414159E-01],
	[3.1965000000E+04, 2.6926829621E+01, 5.2178125963E+00, 9.7512829112E+00, 3.0180526553E+00, 9.4087225776E-01],
	[3.1970000000E+04, 2.6933931715E+01, 5.2178236664E+00, 9.7562227774E+00, 3.0186186241E+00, 9.4090035906E-01],
	[3.1975000000E+04, 2.6941034571E+01, 5.2178347348E+00, 9.7611643703E+00, 3.0191844532E+00, 9.4092844550E-01],
	[3.1980000000E+04, 2.6948138189E+01, 5.2178458015E+00, 9.7661076901E+00, 3.0197501426E+00, 9.4095651708E-01],
	[3.1985000000E+04, 2.6955242569E+01, 5.2178568664E+00, 9.7710527372E+00, 3.0203156924E+00, 9.4098457380E-01],
	[3.1990000000E+04, 2.6962347712E+01, 5.2178679297E+00, 9.7759995118E+00, 3.0208811026E+00, 9.4101261569E-01],
	[3.1995000000E+04, 2.6969453616E+01, 5.2178789913E+00, 9.7809480145E+00, 3.0214463731E+00, 9.4104064274E-01],
	[3.2000000000E+04, 2.6976560282E+01, 5.2178900512E+00, 9.7858982453E+00, 3.0220115040E+00, 9.4106865497E-01],
	[3.2005000000E+04, 2.6983667710E+01, 5.2179011093E+00, 9.7908502048E+00, 3.0225764953E+00, 9.4109665238E-01],
	[3.2010000000E+04, 2.6990775900E+01, 5.2179121658E+00, 9.7958038932E+00, 3.0231413469E+00, 9.4112463497E-01],
	[3.2015000000E+04, 2.6997884852E+01, 5.2179232205E+00, 9.8007593109E+00, 3.0237060589E+00, 9.4115260277E-01],
	[3.2020000000E+04, 2.7004994565E+01, 5.2179342736E+00, 9.8057164582E+00, 3.0242706313E+00, 9.4118055577E-01],
	[3.2025000000E+04, 2.7012105041E+01, 5.2179453249E+00, 9.8106753354E+00, 3.0248350641E+00, 9.4120849399E-01],
	[3.2030000000E+04, 2.7019216278E+01, 5.2179563746E+00, 9.8156359428E+00, 3.0253993572E+00, 9.4123641743E-01],
	[3.2035000000E+04, 2.7026328276E+01, 5.2179674225E+00, 9.8205982809E+00, 3.0259635107E+00, 9.4126432610E-01],
	[3.2040000000E+04, 2.7033441037E+01, 5.2179784688E+00, 9.8255623499E+00, 3.0265275247E+00, 9.4129222001E-01],
	[3.2045000000E+04, 2.7040554559E+01, 5.2179895133E+00, 9.8305281501E+00, 3.0270913990E+00, 9.4132009916E-01],
	[3.2050000000E+04, 2.7047668842E+01, 5.2180005562E+00, 9.8354956819E+00, 3.0276551337E+00, 9.4134796357E-01],
	[3.2055000000E+04, 2.7054783887E+01, 5.2180115973E+00, 9.8404649457E+00, 3.0282187288E+00, 9.4137581324E-01],
	[3.2060000000E+04, 2.7061899694E+01, 5.2180226368E+00, 9.8454359416E+00, 3.0287821843E+00, 9.4140364818E-01],
	[3.2065000000E+04, 2.7069016262E+01, 5.2180336745E+00, 9.8504086702E+00, 3.0293455002E+00, 9.4143146840E-01],
	[3.2070000000E+04, 2.7076133591E+01, 5.2180447106E+00, 9.8553831317E+00, 3.0299086765E+00, 9.4145927390E-01],
	[3.2075000000E+04, 2.7083251682E+01, 5.2180557449E+00, 9.8603593264E+00, 3.0304717132E+00, 9.4148706470E-01],
	[3.2080000000E+04, 2.7090370534E+01, 5.2180667776E+00, 9.8653372548E+00, 3.0310346103E+00, 9.4151484081E-01],
	[3.2085000000E+04, 2.7097490147E+01, 5.2180778085E+00, 9.8703169170E+00, 3.0315973679E+00, 9.4154260222E-01],
	[3.2090000000E+04, 2.7104610522E+01, 5.2180888378E+00, 9.8752983135E+00, 3.0321599859E+00, 9.4157034895E-01],
	[3.2095000000E+04, 2.7111731657E+01, 5.2180998654E+00, 9.8802814445E+00, 3.0327224643E+00, 9.4159808101E-01],
	[3.2100000000E+04, 2.7118853554E+01, 5.2181108913E+00, 9.8852663105E+00, 3.0332848031E+00, 9.4162579840E-01],
	[3.2105000000E+04, 2.7125976213E+01, 5.2181219154E+00, 9.8902529117E+00, 3.0338470024E+00, 9.4165350113E-01],
	[3.2110000000E+04, 2.7133099632E+01, 5.2181329379E+00, 9.8952412485E+00, 3.0344090621E+00, 9.4168118922E-01],
	[3.2115000000E+04, 2.7140223812E+01, 5.2181439587E+00, 9.9002313211E+00, 3.0349709823E+00, 9.4170886266E-01],
	[3.2120000000E+04, 2.7147348754E+01, 5.2181549778E+00, 9.9052231300E+00, 3.0355327629E+00, 9.4173652147E-01],
	[3.2125000000E+04, 2.7154474456E+01, 5.2181659952E+00, 9.9102166755E+00, 3.0360944039E+00, 9.4176416565E-01],
	[3.2130000000E+04, 2.7161600919E+01, 5.2181770110E+00, 9.9152119579E+00, 3.0366559054E+00, 9.4179179522E-01],
	[3.2135000000E+04, 2.7168728144E+01, 5.2181880250E+00, 9.9202089775E+00, 3.0372172674E+00, 9.4181941017E-01],
	[3.2140000000E+04, 2.7175856129E+01, 5.2181990373E+00, 9.9252077347E+00, 3.0377784898E+00, 9.4184701053E-01],
	[3.2145000000E+04, 2.7182984875E+01, 5.2182100480E+00, 9.9302082298E+00, 3.0383395727E+00, 9.4187459629E-01],
	[3.2150000000E+04, 2.7190114382E+01, 5.2182210569E+00, 9.9352104631E+00, 3.0389005161E+00, 9.4190216746E-01],
	[3.2155000000E+04, 2.7197244649E+01, 5.2182320642E+00, 9.9402144350E+00, 3.0394613199E+00, 9.4192972406E-01],
	[3.2160000000E+04, 2.7204375677E+01, 5.2182430698E+00, 9.9452201458E+00, 3.0400219842E+00, 9.4195726609E-01],
	[3.2165000000E+04, 2.7211507466E+01, 5.2182540737E+00, 9.9502275958E+00, 3.0405825090E+00, 9.4198479356E-01],
	[3.2170000000E+04, 2.7218640016E+01, 5.2182650759E+00, 9.9552367853E+00, 3.0411428943E+00, 9.4201230647E-01],
	[3.2175000000E+04, 2.7225773327E+01, 5.2182760764E+00, 9.9602477148E+00, 3.0417031401E+00, 9.4203980483E-01],
	[3.2180000000E+04, 2.7232907397E+01, 5.2182870753E+00, 9.9652603845E+00, 3.0422632463E+00, 9.4206728866E-01],
	[3.2185000000E+04, 2.7240042229E+01, 5.2182980724E+00, 9.9702747947E+00, 3.0428232131E+00, 9.4209475796E-01],
	[3.2190000000E+04, 2.7247177821E+01, 5.2183090679E+00, 9.9752909458E+00, 3.0433830404E+00, 9.4212221274E-01],
	[3.2195000000E+04, 2.7254314173E+01, 5.2183200617E+00, 9.9803088382E+00, 3.0439427282E+00, 9.4214965300E-01],
	[3.2200000000E+04, 2.7261451286E+01, 5.2183310538E+00, 9.9853284721E+00, 3.0445022765E+00, 9.4217707876E-01],
	[3.2205000000E+04, 2.7268589160E+01, 5.2183420442E+00, 9.9903498479E+00, 3.0450616853E+00, 9.4220449002E-01],
	[3.2210000000E+04, 2.7275727793E+01, 5.2183530329E+00, 9.9953729659E+00, 3.0456209546E+00, 9.4223188679E-01],
	[3.2215000000E+04, 2.7282867187E+01, 5.2183640199E+00, 1.0000397826E+01, 3.0461800845E+00, 9.4225926907E-01],
	[3.2220000000E+04, 2.7290007342E+01, 5.2183750053E+00, 1.0005424430E+01, 3.0467390749E+00, 9.4228663689E-01],
	[3.2225000000E+04, 2.7297148256E+01, 5.2183859890E+00, 1.0010452777E+01, 3.0472979258E+00, 9.4231399023E-01],
	[3.2230000000E+04, 2.7304289931E+01, 5.2183969710E+00, 1.0015482867E+01, 3.0478566373E+00, 9.4234132912E-01],
	[3.2235000000E+04, 2.7311432366E+01, 5.2184079513E+00, 1.0020514701E+01, 3.0484152093E+00, 9.4236865356E-01],
	[3.2240000000E+04, 2.7318575561E+01, 5.2184189300E+00, 1.0025548279E+01, 3.0489736418E+00, 9.4239596356E-01],
	[3.2245000000E+04, 2.7325719516E+01, 5.2184299069E+00, 1.0030583602E+01, 3.0495319350E+00, 9.4242325912E-01],
	[3.2250000000E+04, 2.7332864232E+01, 5.2184408822E+00, 1.0035620670E+01, 3.0500900887E+00, 9.4245054026E-01],
	[3.2255000000E+04, 2.7340009707E+01, 5.2184518558E+00, 1.0040659483E+01, 3.0506481029E+00, 9.4247780697E-01],
	[3.2260000000E+04, 2.7347155942E+01, 5.2184628277E+00, 1.0045700041E+01, 3.0512059777E+00, 9.4250505928E-01],
	[3.2265000000E+04, 2.7354302938E+01, 5.2184737980E+00, 1.0050742345E+01, 3.0517637131E+00, 9.4253229719E-01],
	[3.2270000000E+04, 2.7361450693E+01, 5.2184847666E+00, 1.0055786396E+01, 3.0523213091E+00, 9.4255952070E-01],
	[3.2275000000E+04, 2.7368599208E+01, 5.2184957335E+00, 1.0060832193E+01, 3.0528787657E+00, 9.4258672982E-01],
	[3.2280000000E+04, 2.7375748483E+01, 5.2185066987E+00, 1.0065879737E+01, 3.0534360828E+00, 9.4261392456E-01],
	[3.2285000000E+04, 2.7382898518E+01, 5.2185176622E+00, 1.0070929028E+01, 3.0539932606E+00, 9.4264110494E-01],
	[3.2290000000E+04, 2.7390049312E+01, 5.2185286241E+00, 1.0075980067E+01, 3.0545502989E+00, 9.4266827095E-01],
	[3.2295000000E+04, 2.7397200867E+01, 5.2185395843E+00, 1.0081032854E+01, 3.0551071979E+00, 9.4269542261E-01],
	[3.2300000000E+04, 2.7404353181E+01, 5.2185505428E+00, 1.0086087388E+01, 3.0556639575E+00, 9.4272255992E-01],
	[3.2305000000E+04, 2.7411506254E+01, 5.2185614997E+00, 1.0091143672E+01, 3.0562205777E+00, 9.4274968289E-01],
	[3.2310000000E+04, 2.7418660088E+01, 5.2185724548E+00, 1.0096201704E+01, 3.0567770585E+00, 9.4277679153E-01],
	[3.2315000000E+04, 2.7425814681E+01, 5.2185834083E+00, 1.0101261485E+01, 3.0573333999E+00, 9.4280388584E-01],
	[3.2320000000E+04, 2.7432970033E+01, 5.2185943602E+00, 1.0106323016E+01, 3.0578896020E+00, 9.4283096584E-01],
	[3.2325000000E+04, 2.7440126145E+01, 5.2186053103E+00, 1.0111386297E+01, 3.0584456647E+00, 9.4285803154E-01],
	[3.2330000000E+04, 2.7447283016E+01, 5.2186162588E+00, 1.0116451328E+01, 3.0590015881E+00, 9.4288508293E-01],
	[3.2335000000E+04, 2.7454440647E+01, 5.2186272057E+00, 1.0121518110E+01, 3.0595573721E+00, 9.4291212004E-01],
	[3.2340000000E+04, 2.7461599038E+01, 5.2186381508E+00, 1.0126586642E+01, 3.0601130167E+00, 9.4293914286E-01],
	[3.2345000000E+04, 2.7468758187E+01, 5.2186490943E+00, 1.0131656926E+01, 3.0606685221E+00, 9.4296615140E-01],
	[3.2350000000E+04, 2.7475918096E+01, 5.2186600361E+00, 1.0136728961E+01, 3.0612238881E+00, 9.4299314568E-01],
	[3.2355000000E+04, 2.7483078765E+01, 5.2186709763E+00, 1.0141802748E+01, 3.0617791147E+00, 9.4302012569E-01],
	[3.2360000000E+04, 2.7490240192E+01, 5.2186819147E+00, 1.0146878287E+01, 3.0623342021E+00, 9.4304709146E-01],
	[3.2365000000E+04, 2.7497402379E+01, 5.2186928515E+00, 1.0151955579E+01, 3.0628891501E+00, 9.4307404298E-01],
	[3.2370000000E+04, 2.7504565325E+01, 5.2187037867E+00, 1.0157034623E+01, 3.0634439589E+00, 9.4310098027E-01],
	[3.2375000000E+04, 2.7511729030E+01, 5.2187147202E+00, 1.0162115421E+01, 3.0639986283E+00, 9.4312790332E-01],
	[3.2380000000E+04, 2.7518893494E+01, 5.2187256520E+00, 1.0167197972E+01, 3.0645531584E+00, 9.4315481216E-01],
	[3.2385000000E+04, 2.7526058718E+01, 5.2187365821E+00, 1.0172282278E+01, 3.0651075492E+00, 9.4318170679E-01],
	[3.2390000000E+04, 2.7533224700E+01, 5.2187475106E+00, 1.0177368337E+01, 3.0656618008E+00, 9.4320858721E-01],
	[3.2395000000E+04, 2.7540396572E+01, 5.2187590826E+00, 1.0182456151E+01, 3.0662161994E+00, 9.4323545343E-01],
	[3.2400000000E+04, 2.7547586132E+01, 5.2187727806E+00, 1.0187545719E+01, 3.0667714034E+00, 9.4326230547E-01],
	[3.2405000000E+04, 2.7554776458E+01, 5.2187864766E+00, 1.0192638201E+01, 3.0673265734E+00, 9.4328914332E-01],
	[3.2410000000E+04, 2.7561967551E+01, 5.2188001704E+00, 1.0197735733E+01, 3.0678819029E+00, 9.4331596700E-01],
	[3.2415000000E+04, 2.7569159411E+01, 5.2188138622E+00, 1.0202835026E+01, 3.0684370936E+00, 9.4334277652E-01],
	[3.2420000000E+04, 2.7576352039E+01, 5.2188275519E+00, 1.0207936079E+01, 3.0689921455E+00, 9.4336957188E-01],
	[3.2425000000E+04, 2.7583545433E+01, 5.2188412395E+00, 1.0213038892E+01, 3.0695470585E+00, 9.4339635309E-01],
	[3.2430000000E+04, 2.7590739594E+01, 5.2188549251E+00, 1.0218143466E+01, 3.0701018326E+00, 9.4342312016E-01],
	[3.2435000000E+04, 2.7597934521E+01, 5.2188686086E+00, 1.0223249802E+01, 3.0706564680E+00, 9.4344987310E-01],
	[3.2440000000E+04, 2.7605130216E+01, 5.2188822900E+00, 1.0228357899E+01, 3.0712109645E+00, 9.4347661191E-01],
	[3.2445000000E+04, 2.7612326677E+01, 5.2188959693E+00, 1.0233467759E+01, 3.0717653223E+00, 9.4350333660E-01],
	[3.2450000000E+04, 2.7619523905E+01, 5.2189096465E+00, 1.0238579380E+01, 3.0723195412E+00, 9.4353004719E-01],
	[3.2455000000E+04, 2.7626721899E+01, 5.2189233217E+00, 1.0243692764E+01, 3.0728736213E+00, 9.4355674367E-01],
	[3.2460000000E+04, 2.7633920660E+01, 5.2189369948E+00, 1.0248807912E+01, 3.0734275626E+00, 9.4358342605E-01],
	[3.2465000000E+04, 2.7641120188E+01, 5.2189506659E+00, 1.0253924822E+01, 3.0739813652E+00, 9.4361009436E-01],
	[3.2470000000E+04, 2.7648320482E+01, 5.2189643349E+00, 1.0259043496E+01, 3.0745350290E+00, 9.4363674858E-01],
	[3.2475000000E+04, 2.7655521543E+01, 5.2189780018E+00, 1.0264163934E+01, 3.0750885540E+00, 9.4366338873E-01],
	[3.2480000000E+04, 2.7662723370E+01, 5.2189916666E+00, 1.0269286136E+01, 3.0756419402E+00, 9.4369001482E-01],
	[3.2485000000E+04, 2.7669925964E+01, 5.2190053294E+00, 1.0274410103E+01, 3.0761951877E+00, 9.4371662686E-01],
	[3.2490000000E+04, 2.7677129324E+01, 5.2190189901E+00, 1.0279535835E+01, 3.0767482964E+00, 9.4374322485E-01],
	[3.2495000000E+04, 2.7684333451E+01, 5.2190326487E+00, 1.0284663333E+01, 3.0773012664E+00, 9.4376980880E-01],
	[3.2500000000E+04, 2.7691538343E+01, 5.2190463053E+00, 1.0289792595E+01, 3.0778540976E+00, 9.4379637872E-01],
	[3.2505000000E+04, 2.7698744003E+01, 5.2190599598E+00, 1.0294923624E+01, 3.0784067901E+00, 9.4382293462E-01],
	[3.2510000000E+04, 2.7705950428E+01, 5.2190736123E+00, 1.0300056419E+01, 3.0789593439E+00, 9.4384947650E-01],
	[3.2515000000E+04, 2.7713157619E+01, 5.2190872626E+00, 1.0305190981E+01, 3.0795117589E+00, 9.4387600437E-01],
	[3.2520000000E+04, 2.7720365577E+01, 5.2191009110E+00, 1.0310327310E+01, 3.0800640352E+00, 9.4390251824E-01],
	[3.2525000000E+04, 2.7727574301E+01, 5.2191145572E+00, 1.0315465406E+01, 3.0806161729E+00, 9.4392901813E-01],
	[3.2530000000E+04, 2.7734783791E+01, 5.2191282014E+00, 1.0320605270E+01, 3.0811681718E+00, 9.4395550402E-01],
	[3.2535000000E+04, 2.7741994047E+01, 5.2191418435E+00, 1.0325746902E+01, 3.0817200320E+00, 9.4398197595E-01],
	[3.2540000000E+04, 2.7749205069E+01, 5.2191554836E+00, 1.0330890302E+01, 3.0822717536E+00, 9.4400843390E-01],
	[3.2545000000E+04, 2.7756416857E+01, 5.2191691216E+00, 1.0336035470E+01, 3.0828233364E+00, 9.4403487789E-01],
	[3.2550000000E+04, 2.7763629411E+01, 5.2191827576E+00, 1.0341182408E+01, 3.0833747806E+00, 9.4406130794E-01],
	[3.2555000000E+04, 2.7770842731E+01, 5.2191963915E+00, 1.0346331115E+01, 3.0839260861E+00, 9.4408772403E-01],
	[3.2560000000E+04, 2.7778056817E+01, 5.2192100233E+00, 1.0351481592E+01, 3.0844772530E+00, 9.4411412619E-01],
	[3.2565000000E+04, 2.7785271669E+01, 5.2192236531E+00, 1.0356633838E+01, 3.0850282812E+00, 9.4414051442E-01],
	[3.2570000000E+04, 2.7792487287E+01, 5.2192372808E+00, 1.0361787855E+01, 3.0855791708E+00, 9.4416688873E-01],
	[3.2575000000E+04, 2.7799703670E+01, 5.2192509064E+00, 1.0366943643E+01, 3.0861299217E+00, 9.4419324912E-01],
	[3.2580000000E+04, 2.7806920819E+01, 5.2192645301E+00, 1.0372101201E+01, 3.0866805340E+00, 9.4421959561E-01],
	[3.2585000000E+04, 2.7814138734E+01, 5.2192781516E+00, 1.0377260531E+01, 3.0872310077E+00, 9.4424592819E-01],
	[3.2590000000E+04, 2.7821357415E+01, 5.2192917711E+00, 1.0382421633E+01, 3.0877813427E+00, 9.4427224688E-01],
	[3.2595000000E+04, 2.7828576861E+01, 5.2193053885E+00, 1.0387584507E+01, 3.0883315392E+00, 9.4429855168E-01],
	[3.2600000000E+04, 2.7835797072E+01, 5.2193190039E+00, 1.0392749153E+01, 3.0888815970E+00, 9.4432484260E-01],
	[3.2605000000E+04, 2.7843018050E+01, 5.2193326173E+00, 1.0397915571E+01, 3.0894315163E+00, 9.4435111964E-01],
	[3.2610000000E+04, 2.7850239793E+01, 5.2193462286E+00, 1.0403083763E+01, 3.0899812969E+00, 9.4437738282E-01],
	[3.2615000000E+04, 2.7857462301E+01, 5.2193598378E+00, 1.0408253728E+01, 3.0905309390E+00, 9.4440363214E-01],
	[3.2620000000E+04, 2.7864685575E+01, 5.2193734450E+00, 1.0413425467E+01, 3.0910804425E+00, 9.4442986761E-01],
	[3.2625000000E+04, 2.7871909614E+01, 5.2193870501E+00, 1.0418598979E+01, 3.0916298075E+00, 9.4445608923E-01],
	[3.2630000000E+04, 2.7879134418E+01, 5.2194006532E+00, 1.0423774266E+01, 3.0921790338E+00, 9.4448229701E-01],
	[3.2635000000E+04, 2.7886359988E+01, 5.2194142542E+00, 1.0428951328E+01, 3.0927281217E+00, 9.4450849096E-01],
	[3.2640000000E+04, 2.7893586324E+01, 5.2194278532E+00, 1.0434130165E+01, 3.0932770710E+00, 9.4453467109E-01],
	[3.2645000000E+04, 2.7900813424E+01, 5.2194414502E+00, 1.0439310777E+01, 3.0938258817E+00, 9.4456083740E-01],
	[3.2650000000E+04, 2.7908041290E+01, 5.2194550450E+00, 1.0444493165E+01, 3.0943745539E+00, 9.4458698989E-01],
	[3.2655000000E+04, 2.7915269921E+01, 5.2194686379E+00, 1.0449677328E+01, 3.0949230876E+00, 9.4461312859E-01],
	[3.2660000000E+04, 2.7922499317E+01, 5.2194822287E+00, 1.0454863269E+01, 3.0954714828E+00, 9.4463925348E-01],
	[3.2665000000E+04, 2.7929729478E+01, 5.2194958174E+00, 1.0460050985E+01, 3.0960197395E+00, 9.4466536459E-01],
	[3.2670000000E+04, 2.7936960405E+01, 5.2195094042E+00, 1.0465240479E+01, 3.0965678577E+00, 9.4469146191E-01],
	[3.2675000000E+04, 2.7944192096E+01, 5.2195229888E+00, 1.0470431751E+01, 3.0971158374E+00, 9.4471754546E-01],
	[3.2680000000E+04, 2.7951424553E+01, 5.2195365714E+00, 1.0475624800E+01, 3.0976636786E+00, 9.4474361524E-01],
	[3.2685000000E+04, 2.7958657774E+01, 5.2195501520E+00, 1.0480819627E+01, 3.0982113814E+00, 9.4476967126E-01],
	[3.2690000000E+04, 2.7965891760E+01, 5.2195637306E+00, 1.0486016232E+01, 3.0987589456E+00, 9.4479571352E-01],
	[3.2695000000E+04, 2.7973126512E+01, 5.2195773071E+00, 1.0491214616E+01, 3.0993063714E+00, 9.4482174203E-01],
	[3.2700000000E+04, 2.7980362028E+01, 5.2195908815E+00, 1.0496414779E+01, 3.0998536588E+00, 9.4484775680E-01],
	[3.2705000000E+04, 2.7987598309E+01, 5.2196044539E+00, 1.0501616722E+01, 3.1004008077E+00, 9.4487375784E-01],
	[3.2710000000E+04, 2.7994835355E+01, 5.2196180243E+00, 1.0506820444E+01, 3.1009478182E+00, 9.4489974516E-01],
	[3.2715000000E+04, 2.8002073165E+01, 5.2196315927E+00, 1.0512025946E+01, 3.1014946903E+00, 9.4492571875E-01],
	[3.2720000000E+04, 2.8009311741E+01, 5.2196451590E+00, 1.0517233229E+01, 3.1020414239E+00, 9.4495167863E-01],
	[3.2725000000E+04, 2.8016551081E+01, 5.2196587232E+00, 1.0522442292E+01, 3.1025880192E+00, 9.4497762480E-01],
	[3.2730000000E+04, 2.8023791185E+01, 5.2196722854E+00, 1.0527653137E+01, 3.1031344760E+00, 9.4500355728E-01],
	[3.2735000000E+04, 2.8031032055E+01, 5.2196858456E+00, 1.0532865762E+01, 3.1036807945E+00, 9.4502947606E-01],
	[3.2740000000E+04, 2.8038273689E+01, 5.2196994038E+00, 1.0538080170E+01, 3.1042269745E+00, 9.4505538116E-01],
	[3.2745000000E+04, 2.8045516087E+01, 5.2197129599E+00, 1.0543296359E+01, 3.1047730162E+00, 9.4508127258E-01],
	[3.2750000000E+04, 2.8052759250E+01, 5.2197265140E+00, 1.0548514331E+01, 3.1053189195E+00, 9.4510715033E-01],
	[3.2755000000E+04, 2.8060003178E+01, 5.2197400660E+00, 1.0553734086E+01, 3.1058646845E+00, 9.4513301441E-01],
	[3.2760000000E+04, 2.8067247869E+01, 5.2197536160E+00, 1.0558955624E+01, 3.1064103111E+00, 9.4515886484E-01],
	[3.2765000000E+04, 2.8074493326E+01, 5.2197671640E+00, 1.0564178945E+01, 3.1069557993E+00, 9.4518470162E-01],
	[3.2770000000E+04, 2.8081739547E+01, 5.2197807100E+00, 1.0569404050E+01, 3.1075011493E+00, 9.4521052475E-01],
	[3.2775000000E+04, 2.8088986532E+01, 5.2197942539E+00, 1.0574630939E+01, 3.1080463609E+00, 9.4523633425E-01],
	[3.2780000000E+04, 2.8096234281E+01, 5.2198077958E+00, 1.0579859613E+01, 3.1085914341E+00, 9.4526213012E-01],
	[3.2785000000E+04, 2.8103482794E+01, 5.2198213356E+00, 1.0585090071E+01, 3.1091363691E+00, 9.4528791237E-01],
	[3.2790000000E+04, 2.8110732072E+01, 5.2198348735E+00, 1.0590322314E+01, 3.1096811658E+00, 9.4531368100E-01],
	[3.2795000000E+04, 2.8117982114E+01, 5.2198484093E+00, 1.0595556343E+01, 3.1102258241E+00, 9.4533943603E-01],
	[3.2800000000E+04, 2.8125232921E+01, 5.2198619430E+00, 1.0600792157E+01, 3.1107703442E+00, 9.4536517745E-01],
	[3.2805000000E+04, 2.8132484491E+01, 5.2198754748E+00, 1.0606029758E+01, 3.1113147261E+00, 9.4539090528E-01],
	[3.2810000000E+04, 2.8139736825E+01, 5.2198890045E+00, 1.0611269145E+01, 3.1118589696E+00, 9.4541661952E-01],
	[3.2815000000E+04, 2.8146989924E+01, 5.2199025322E+00, 1.0616510318E+01, 3.1124030749E+00, 9.4544232019E-01],
	[3.2820000000E+04, 2.8154243786E+01, 5.2199160579E+00, 1.0621753279E+01, 3.1129470420E+00, 9.4546800728E-01],
	[3.2825000000E+04, 2.8161498413E+01, 5.2199295815E+00, 1.0626998027E+01, 3.1134908708E+00, 9.4549368080E-01],
	[3.2830000000E+04, 2.8168753803E+01, 5.2199431031E+00, 1.0632244563E+01, 3.1140345613E+00, 9.4551934077E-01],
	[3.2835000000E+04, 2.8176009957E+01, 5.2199566227E+00, 1.0637492887E+01, 3.1145781137E+00, 9.4554498718E-01],
	[3.2840000000E+04, 2.8183266875E+01, 5.2199701403E+00, 1.0642743000E+01, 3.1151215278E+00, 9.4557062005E-01],
	[3.2845000000E+04, 2.8190524557E+01, 5.2199836558E+00, 1.0647994901E+01, 3.1156648038E+00, 9.4559623937E-01],
	[3.2850000000E+04, 2.8197783003E+01, 5.2199971693E+00, 1.0653248591E+01, 3.1162079415E+00, 9.4562184517E-01],
	[3.2855000000E+04, 2.8205042213E+01, 5.2200106808E+00, 1.0658504071E+01, 3.1167509411E+00, 9.4564743745E-01],
	[3.2860000000E+04, 2.8212302186E+01, 5.2200241903E+00, 1.0663761341E+01, 3.1172938025E+00, 9.4567301620E-01],
	[3.2865000000E+04, 2.8219562923E+01, 5.2200376978E+00, 1.0669020401E+01, 3.1178365257E+00, 9.4569858145E-01],
	[3.2870000000E+04, 2.8226824424E+01, 5.2200512032E+00, 1.0674281251E+01, 3.1183791107E+00, 9.4572413320E-01],
	[3.2875000000E+04, 2.8234086688E+01, 5.2200647066E+00, 1.0679543892E+01, 3.1189215576E+00, 9.4574967144E-01],
	[3.2880000000E+04, 2.8241349716E+01, 5.2200782080E+00, 1.0684808324E+01, 3.1194638664E+00, 9.4577519620E-01],
	[3.2885000000E+04, 2.8248613507E+01, 5.2200917074E+00, 1.0690074548E+01, 3.1200060370E+00, 9.4580070748E-01],
	[3.2890000000E+04, 2.8255878062E+01, 5.2201052047E+00, 1.0695342563E+01, 3.1205480695E+00, 9.4582620528E-01],
	[3.2895000000E+04, 2.8263143380E+01, 5.2201187001E+00, 1.0700612370E+01, 3.1210899639E+00, 9.4585168961E-01],
	[3.2900000000E+04, 2.8270409462E+01, 5.2201321934E+00, 1.0705883970E+01, 3.1216317202E+00, 9.4587716048E-01],
	[3.2905000000E+04, 2.8277676307E+01, 5.2201456847E+00, 1.0711157363E+01, 3.1221733384E+00, 9.4590261790E-01],
	[3.2910000000E+04, 2.8284943916E+01, 5.2201591740E+00, 1.0716432549E+01, 3.1227148186E+00, 9.4592806187E-01],
	[3.2915000000E+04, 2.8292212288E+01, 5.2201726613E+00, 1.0721709528E+01, 3.1232561606E+00, 9.4595349240E-01],
	[3.2920000000E+04, 2.8299501810E+01, 5.2201886801E+00, 1.0726988302E+01, 3.1237985202E+00, 9.4597890950E-01],
	[3.2925000000E+04, 2.8306793560E+01, 5.2202048775E+00, 1.0732268869E+01, 3.1243408249E+00, 9.4600431317E-01],
	[3.2930000000E+04, 2.8314086080E+01, 5.2202210724E+00, 1.0737551231E+01, 3.1248829920E+00, 9.4602970342E-01],
	[3.2935000000E+04, 2.8321379372E+01, 5.2202372649E+00, 1.0742835387E+01, 3.1254250216E+00, 9.4605508026E-01],
	[3.2940000000E+04, 2.8328673435E+01, 5.2202534551E+00, 1.0748121339E+01, 3.1259669137E+00, 9.4608044370E-01],
	[3.2945000000E+04, 2.8335968269E+01, 5.2202696428E+00, 1.0753409086E+01, 3.1265086683E+00, 9.4610579373E-01],
	[3.2950000000E+04, 2.8343263874E+01, 5.2202858281E+00, 1.0758698629E+01, 3.1270502854E+00, 9.4613113038E-01],
	[3.2955000000E+04, 2.8350560250E+01, 5.2203020110E+00, 1.0763989969E+01, 3.1275917650E+00, 9.4615645364E-01],
	[3.2960000000E+04, 2.8357857397E+01, 5.2203181915E+00, 1.0769283104E+01, 3.1281331072E+00, 9.4618176352E-01],
	[3.2965000000E+04, 2.8365155315E+01, 5.2203343696E+00, 1.0774578037E+01, 3.1286743120E+00, 9.4620706003E-01],
	[3.2970000000E+04, 2.8372454003E+01, 5.2203505453E+00, 1.0779874767E+01, 3.1292153793E+00, 9.4623234318E-01],
	[3.2975000000E+04, 2.8379753463E+01, 5.2203667186E+00, 1.0785173294E+01, 3.1297563091E+00, 9.4625761297E-01],
	[3.2980000000E+04, 2.8387053693E+01, 5.2203828895E+00, 1.0790473619E+01, 3.1302971016E+00, 9.4628286942E-01],
	[3.2985000000E+04, 2.8394354694E+01, 5.2203990580E+00, 1.0795775742E+01, 3.1308377566E+00, 9.4630811252E-01],
	[3.2990000000E+04, 2.8401656466E+01, 5.2204152241E+00, 1.0801079664E+01, 3.1313782742E+00, 9.4633334229E-01],
	[3.2995000000E+04, 2.8408959008E+01, 5.2204313878E+00, 1.0806385385E+01, 3.1319186545E+00, 9.4635855872E-01],
	[3.3000000000E+04, 2.8416262321E+01, 5.2204475491E+00, 1.0811692905E+01, 3.1324588973E+00, 9.4638376184E-01],
	[3.3005000000E+04, 2.8423566405E+01, 5.2204637080E+00, 1.0817002224E+01, 3.1329990028E+00, 9.4640895164E-01],
	[3.3010000000E+04, 2.8430871259E+01, 5.2204798645E+00, 1.0822313343E+01, 3.1335389709E+00, 9.4643412813E-01],
	[3.3015000000E+04, 2.8438176884E+01, 5.2204960186E+00, 1.0827626263E+01, 3.1340788017E+00, 9.4645929133E-01],
	[3.3020000000E+04, 2.8445483280E+01, 5.2205121703E+00, 1.0832940982E+01, 3.1346184951E+00, 9.4648444123E-01],
	[3.3025000000E+04, 2.8452790445E+01, 5.2205283196E+00, 1.0838257503E+01, 3.1351580511E+00, 9.4650957784E-01],
	[3.3030000000E+04, 2.8460098382E+01, 5.2205444665E+00, 1.0843575825E+01, 3.1356974699E+00, 9.4653470117E-01],
	[3.3035000000E+04, 2.8467407088E+01, 5.2205606110E+00, 1.0848895949E+01, 3.1362367513E+00, 9.4655981124E-01],
	[3.3040000000E+04, 2.8474716565E+01, 5.2205767532E+00, 1.0854217874E+01, 3.1367758954E+00, 9.4658490803E-01],
	[3.3045000000E+04, 2.8482026812E+01, 5.2205928929E+00, 1.0859541602E+01, 3.1373149023E+00, 9.4660999157E-01],
	[3.3050000000E+04, 2.8489337830E+01, 5.2206090302E+00, 1.0864867132E+01, 3.1378537718E+00, 9.4663506185E-01],
	[3.3055000000E+04, 2.8496649618E+01, 5.2206251652E+00, 1.0870194465E+01, 3.1383925041E+00, 9.4666011890E-01],
	[3.3060000000E+04, 2.8503962176E+01, 5.2206412978E+00, 1.0875523601E+01, 3.1389310991E+00, 9.4668516270E-01],
	[3.3065000000E+04, 2.8511275504E+01, 5.2206574279E+00, 1.0880854541E+01, 3.1394695569E+00, 9.4671019327E-01],
	[3.3070000000E+04, 2.8518589603E+01, 5.2206735557E+00, 1.0886187285E+01, 3.1400078774E+00, 9.4673521062E-01],
	[3.3075000000E+04, 2.8525904471E+01, 5.2206896811E+00, 1.0891521833E+01, 3.1405460606E+00, 9.4676021475E-01],
	[3.3080000000E+04, 2.8533220110E+01, 5.2207058041E+00, 1.0896858185E+01, 3.1410841067E+00, 9.4678520567E-01],
	[3.3085000000E+04, 2.8540536519E+01, 5.2207219247E+00, 1.0902196342E+01, 3.1416220155E+00, 9.4681018339E-01],
	[3.3090000000E+04, 2.8547853697E+01, 5.2207380429E+00, 1.0907536305E+01, 3.1421597872E+00, 9.4683514792E-01],
	[3.3095000000E+04, 2.8555171646E+01, 5.2207541588E+00, 1.0912878073E+01, 3.1426974216E+00, 9.4686009925E-01],
	[3.3100000000E+04, 2.8562490365E+01, 5.2207702723E+00, 1.0918221647E+01, 3.1432349189E+00, 9.4688503741E-01],
	[3.3105000000E+04, 2.8569809853E+01, 5.2207863833E+00, 1.0923567028E+01, 3.1437722790E+00, 9.4690996238E-01],
	[3.3110000000E+04, 2.8577130112E+01, 5.2208024920E+00, 1.0928914215E+01, 3.1443095019E+00, 9.4693487419E-01],
	[3.3115000000E+04, 2.8584451140E+01, 5.2208185983E+00, 1.0934263208E+01, 3.1448465877E+00, 9.4695977284E-01],
	[3.3120000000E+04, 2.8591772938E+01, 5.2208347023E+00, 1.0939614010E+01, 3.1453835363E+00, 9.4698465834E-01],
	[3.3125000000E+04, 2.8599095506E+01, 5.2208508038E+00, 1.0944966618E+01, 3.1459203478E+00, 9.4700953069E-01],
	[3.3130000000E+04, 2.8606418843E+01, 5.2208669030E+00, 1.0950321035E+01, 3.1464570222E+00, 9.4703438989E-01],
	[3.3135000000E+04, 2.8613742951E+01, 5.2208829998E+00, 1.0955677260E+01, 3.1469935595E+00, 9.4705923597E-01],
	[3.3140000000E+04, 2.8621067827E+01, 5.2208990942E+00, 1.0961035293E+01, 3.1475299596E+00, 9.4708406892E-01],
	[3.3145000000E+04, 2.8628393474E+01, 5.2209151862E+00, 1.0966395136E+01, 3.1480662227E+00, 9.4710888875E-01],
	[3.3150000000E+04, 2.8635719890E+01, 5.2209312758E+00, 1.0971756787E+01, 3.1486023487E+00, 9.4713369547E-01],
	[3.3155000000E+04, 2.8643047076E+01, 5.2209473631E+00, 1.0977120249E+01, 3.1491383377E+00, 9.4715848908E-01],
	[3.3160000000E+04, 2.8650375031E+01, 5.2209634480E+00, 1.0982485520E+01, 3.1496741896E+00, 9.4718326959E-01],
	[3.3165000000E+04, 2.8657703756E+01, 5.2209795305E+00, 1.0987852601E+01, 3.1502099044E+00, 9.4720803701E-01],
	[3.3170000000E+04, 2.8665033250E+01, 5.2209956107E+00, 1.0993221493E+01, 3.1507454822E+00, 9.4723279135E-01],
	[3.3175000000E+04, 2.8672363513E+01, 5.2210116885E+00, 1.0998592196E+01, 3.1512809230E+00, 9.4725753261E-01],
	[3.3180000000E+04, 2.8679694546E+01, 5.2210277639E+00, 1.1003964711E+01, 3.1518162268E+00, 9.4728226080E-01],
	[3.3185000000E+04, 2.8687026348E+01, 5.2210438369E+00, 1.1009339037E+01, 3.1523513936E+00, 9.4730697593E-01],
	[3.3190000000E+04, 2.8694358920E+01, 5.2210599075E+00, 1.1014715175E+01, 3.1528864234E+00, 9.4733167800E-01],
	[3.3195000000E+04, 2.8701692261E+01, 5.2210759758E+00, 1.1020093125E+01, 3.1534213162E+00, 9.4735636702E-01],
	[3.3200000000E+04, 2.8709026371E+01, 5.2210920417E+00, 1.1025472888E+01, 3.1539560721E+00, 9.4738104300E-01],
	[3.3205000000E+04, 2.8716361250E+01, 5.2211081053E+00, 1.1030854464E+01, 3.1544906909E+00, 9.4740570594E-01],
	[3.3210000000E+04, 2.8723696899E+01, 5.2211241664E+00, 1.1036237853E+01, 3.1550251729E+00, 9.4743035586E-01],
	[3.3215000000E+04, 2.8731033316E+01, 5.2211402253E+00, 1.1041623056E+01, 3.1555595179E+00, 9.4745499275E-01],
	[3.3220000000E+04, 2.8738370503E+01, 5.2211562817E+00, 1.1047010073E+01, 3.1560937260E+00, 9.4747961663E-01],
	[3.3225000000E+04, 2.8745708458E+01, 5.2211723358E+00, 1.1052398904E+01, 3.1566277972E+00, 9.4750422750E-01],
	[3.3230000000E+04, 2.8753047183E+01, 5.2211883875E+00, 1.1057789549E+01, 3.1571617314E+00, 9.4752882537E-01],
	[3.3235000000E+04, 2.8760386677E+01, 5.2212044368E+00, 1.1063182010E+01, 3.1576955288E+00, 9.4755341024E-01],
	[3.3240000000E+04, 2.8767726940E+01, 5.2212204838E+00, 1.1068576286E+01, 3.1582291893E+00, 9.4757798213E-01],
	[3.3245000000E+04, 2.8775067971E+01, 5.2212365284E+00, 1.1073972378E+01, 3.1587627130E+00, 9.4760254104E-01],
	[3.3250000000E+04, 2.8782409772E+01, 5.2212525706E+00, 1.1079370286E+01, 3.1592960998E+00, 9.4762708698E-01],
	[3.3255000000E+04, 2.8789752341E+01, 5.2212686105E+00, 1.1084770010E+01, 3.1598293497E+00, 9.4765161995E-01],
	[3.3260000000E+04, 2.8797095679E+01, 5.2212846480E+00, 1.1090171551E+01, 3.1603624628E+00, 9.4767613996E-01],
	[3.3265000000E+04, 2.8804439786E+01, 5.2213006832E+00, 1.1095574908E+01, 3.1608954391E+00, 9.4770064701E-01],
	[3.3270000000E+04, 2.8811784662E+01, 5.2213167160E+00, 1.1100980083E+01, 3.1614282786E+00, 9.4772514113E-01],
	[3.3275000000E+04, 2.8819130306E+01, 5.2213327464E+00, 1.1106387076E+01, 3.1619609812E+00, 9.4774962230E-01],
	[3.3280000000E+04, 2.8826476719E+01, 5.2213487745E+00, 1.1111795887E+01, 3.1624935471E+00, 9.4777409054E-01],
	[3.3285000000E+04, 2.8833823901E+01, 5.2213648002E+00, 1.1117206516E+01, 3.1630259763E+00, 9.4779854586E-01],
	[3.3290000000E+04, 2.8841171851E+01, 5.2213808236E+00, 1.1122618964E+01, 3.1635582686E+00, 9.4782298826E-01],
	[3.3295000000E+04, 2.8848520570E+01, 5.2213968446E+00, 1.1128033231E+01, 3.1640904242E+00, 9.4784741775E-01],
	[3.3300000000E+04, 2.8855870058E+01, 5.2214128632E+00, 1.1133449317E+01, 3.1646224431E+00, 9.4787183434E-01],
	[3.3305000000E+04, 2.8863220314E+01, 5.2214288795E+00, 1.1138867223E+01, 3.1651543252E+00, 9.4789623803E-01],
	[3.3310000000E+04, 2.8870571338E+01, 5.2214448935E+00, 1.1144286949E+01, 3.1656860706E+00, 9.4792062883E-01],
	[3.3315000000E+04, 2.8877923131E+01, 5.2214609050E+00, 1.1149708496E+01, 3.1662176793E+00, 9.4794500675E-01],
	[3.3320000000E+04, 2.8885275692E+01, 5.2214769143E+00, 1.1155131863E+01, 3.1667491514E+00, 9.4796937179E-01],
	[3.3325000000E+04, 2.8892629022E+01, 5.2214929211E+00, 1.1160557051E+01, 3.1672804867E+00, 9.4799372396E-01],
	[3.3330000000E+04, 2.8899983120E+01, 5.2215089257E+00, 1.1165984061E+01, 3.1678116854E+00, 9.4801806327E-01],
	[3.3335000000E+04, 2.8907337986E+01, 5.2215249278E+00, 1.1171412892E+01, 3.1683427474E+00, 9.4804238973E-01],
	[3.3340000000E+04, 2.8914693620E+01, 5.2215409276E+00, 1.1176843545E+01, 3.1688736728E+00, 9.4806670334E-01],
	[3.3345000000E+04, 2.8922050023E+01, 5.2215569251E+00, 1.1182276021E+01, 3.1694044615E+00, 9.4809100411E-01],
	[3.3350000000E+04, 2.8929407194E+01, 5.2215729202E+00, 1.1187710319E+01, 3.1699351136E+00, 9.4811529204E-01],
	[3.3355000000E+04, 2.8936765133E+01, 5.2215889130E+00, 1.1193146441E+01, 3.1704656291E+00, 9.4813956714E-01],
	[3.3360000000E+04, 2.8944123840E+01, 5.2216049034E+00, 1.1198584386E+01, 3.1709960080E+00, 9.4816382943E-01],
	[3.3365000000E+04, 2.8951483315E+01, 5.2216208915E+00, 1.1204024155E+01, 3.1715262503E+00, 9.4818807890E-01],
	[3.3370000000E+04, 2.8958843558E+01, 5.2216368772E+00, 1.1209465747E+01, 3.1720563561E+00, 9.4821231556E-01],
	[3.3375000000E+04, 2.8966204569E+01, 5.2216528606E+00, 1.1214909165E+01, 3.1725863253E+00, 9.4823653943E-01],
	[3.3380000000E+04, 2.8973566349E+01, 5.2216688416E+00, 1.1220354407E+01, 3.1731161579E+00, 9.4826075050E-01],
	[3.3385000000E+04, 2.8980928896E+01, 5.2216848203E+00, 1.1225801474E+01, 3.1736458540E+00, 9.4828494879E-01],
	[3.3390000000E+04, 2.8988292211E+01, 5.2217007967E+00, 1.1231250366E+01, 3.1741754136E+00, 9.4830913430E-01],
	[3.3395000000E+04, 2.8995656294E+01, 5.2217167707E+00, 1.1236701084E+01, 3.1747048366E+00, 9.4833330703E-01],
	[3.3400000000E+04, 2.9003021145E+01, 5.2217327424E+00, 1.1242153629E+01, 3.1752341232E+00, 9.4835746700E-01],
	[3.3405000000E+04, 2.9010386763E+01, 5.2217487117E+00, 1.1247608000E+01, 3.1757632733E+00, 9.4838161421E-01],
	[3.3410000000E+04, 2.9017753150E+01, 5.2217646787E+00, 1.1253064197E+01, 3.1762922869E+00, 9.4840574868E-01],
	[3.3415000000E+04, 2.9025120304E+01, 5.2217806433E+00, 1.1258522222E+01, 3.1768211640E+00, 9.4842987039E-01],
	[3.3420000000E+04, 2.9032488225E+01, 5.2217966056E+00, 1.1263982074E+01, 3.1773499047E+00, 9.4845397937E-01],
	[3.3425000000E+04, 2.9039856915E+01, 5.2218125656E+00, 1.1269443754E+01, 3.1778785089E+00, 9.4847807562E-01],
	[3.3430000000E+04, 2.9047226372E+01, 5.2218285232E+00, 1.1274907262E+01, 3.1784069767E+00, 9.4850215915E-01],
	[3.3435000000E+04, 2.9054596596E+01, 5.2218444785E+00, 1.1280372598E+01, 3.1789353081E+00, 9.4852622996E-01],
	[3.3440000000E+04, 2.9061967589E+01, 5.2218604314E+00, 1.1285839764E+01, 3.1794635031E+00, 9.4855028806E-01],
	[3.3445000000E+04, 2.9069339348E+01, 5.2218763820E+00, 1.1291308758E+01, 3.1799915618E+00, 9.4857433345E-01],
	[3.3450000000E+04, 2.9076732525E+01, 5.2218948678E+00, 1.1296779582E+01, 3.1805206724E+00, 9.4859836615E-01],
	[3.3455000000E+04, 2.9084127452E+01, 5.2219134706E+00, 1.1302252236E+01, 3.1810497033E+00, 9.4862238617E-01],
	[3.3460000000E+04, 2.9091523154E+01, 5.2219320708E+00, 1.1307726720E+01, 3.1815785983E+00, 9.4864639350E-01],
	[3.3465000000E+04, 2.9098919631E+01, 5.2219506682E+00, 1.1313203034E+01, 3.1821073575E+00, 9.4867038815E-01],
	[3.3470000000E+04, 2.9106316883E+01, 5.2219692629E+00, 1.1318681179E+01, 3.1826359809E+00, 9.4869437014E-01],
	[3.3475000000E+04, 2.9113714910E+01, 5.2219878550E+00, 1.1324161156E+01, 3.1831644685E+00, 9.4871833946E-01],
	[3.3480000000E+04, 2.9121113713E+01, 5.2220064443E+00, 1.1329642964E+01, 3.1836928202E+00, 9.4874229613E-01],
	[3.3485000000E+04, 2.9128513290E+01, 5.2220250308E+00, 1.1335126603E+01, 3.1842210362E+00, 9.4876624015E-01],
	[3.3490000000E+04, 2.9135913642E+01, 5.2220436147E+00, 1.1340612075E+01, 3.1847491164E+00, 9.4879017154E-01],
	[3.3495000000E+04, 2.9143314769E+01, 5.2220621959E+00, 1.1346099379E+01, 3.1852770609E+00, 9.4881409028E-01],
	[3.3500000000E+04, 2.9150716671E+01, 5.2220807744E+00, 1.1351588517E+01, 3.1858048696E+00, 9.4883799641E-01],
	[3.3505000000E+04, 2.9158119348E+01, 5.2220993501E+00, 1.1357079487E+01, 3.1863325425E+00, 9.4886188991E-01],
	[3.3510000000E+04, 2.9165522800E+01, 5.2221179232E+00, 1.1362572291E+01, 3.1868600798E+00, 9.4888577080E-01],
	[3.3515000000E+04, 2.9172927026E+01, 5.2221364935E+00, 1.1368066929E+01, 3.1873874813E+00, 9.4890963908E-01],
	[3.3520000000E+04, 2.9180332027E+01, 5.2221550612E+00, 1.1373563401E+01, 3.1879147471E+00, 9.4893349476E-01],
	[3.3525000000E+04, 2.9187737803E+01, 5.2221736261E+00, 1.1379061707E+01, 3.1884418773E+00, 9.4895733785E-01],
	[3.3530000000E+04, 2.9195144354E+01, 5.2221921883E+00, 1.1384561849E+01, 3.1889688718E+00, 9.4898116836E-01],
	[3.3535000000E+04, 2.9202551679E+01, 5.2222107479E+00, 1.1390063825E+01, 3.1894957306E+00, 9.4900498628E-01],
	[3.3540000000E+04, 2.9209959779E+01, 5.2222293047E+00, 1.1395567637E+01, 3.1900224538E+00, 9.4902879164E-01],
	[3.3545000000E+04, 2.9217368654E+01, 5.2222478588E+00, 1.1401073285E+01, 3.1905490413E+00, 9.4905258443E-01],
	[3.3550000000E+04, 2.9224778303E+01, 5.2222664103E+00, 1.1406580770E+01, 3.1910754932E+00, 9.4907636466E-01],
	[3.3555000000E+04, 2.9232188726E+01, 5.2222849590E+00, 1.1412090090E+01, 3.1916018095E+00, 9.4910013234E-01],
	[3.3560000000E+04, 2.9239599924E+01, 5.2223035050E+00, 1.1417601248E+01, 3.1921279902E+00, 9.4912388747E-01],
	[3.3565000000E+04, 2.9247011897E+01, 5.2223220484E+00, 1.1423114243E+01, 3.1926540354E+00, 9.4914763007E-01],
	[3.3570000000E+04, 2.9254424644E+01, 5.2223405890E+00, 1.1428629075E+01, 3.1931799450E+00, 9.4917136014E-01],
	[3.3575000000E+04, 2.9261838165E+01, 5.2223591270E+00, 1.1434145746E+01, 3.1937057190E+00, 9.4919507768E-01],
	[3.3580000000E+04, 2.9269252460E+01, 5.2223776622E+00, 1.1439664254E+01, 3.1942313574E+00, 9.4921878271E-01],
	[3.3585000000E+04, 2.9276667530E+01, 5.2223961948E+00, 1.1445184601E+01, 3.1947568604E+00, 9.4924247523E-01],
	[3.3590000000E+04, 2.9284083374E+01, 5.2224147247E+00, 1.1450706788E+01, 3.1952822278E+00, 9.4926615524E-01],
	[3.3595000000E+04, 2.9291499993E+01, 5.2224332518E+00, 1.1456230813E+01, 3.1958074597E+00, 9.4928982276E-01],
	[3.3600000000E+04, 2.9298917385E+01, 5.2224517763E+00, 1.1461756678E+01, 3.1963325562E+00, 9.4931347779E-01],
	[3.3605000000E+04, 2.9306335552E+01, 5.2224702981E+00, 1.1467284383E+01, 3.1968575171E+00, 9.4933712034E-01],
	[3.3610000000E+04, 2.9313754493E+01, 5.2224888172E+00, 1.1472813928E+01, 3.1973823426E+00, 9.4936075041E-01],
	[3.3615000000E+04, 2.9321174208E+01, 5.2225073336E+00, 1.1478345314E+01, 3.1979070327E+00, 9.4938436801E-01],
	[3.3620000000E+04, 2.9328594697E+01, 5.2225258474E+00, 1.1483878540E+01, 3.1984315873E+00, 9.4940797315E-01],
	[3.3625000000E+04, 2.9336015960E+01, 5.2225443584E+00, 1.1489413608E+01, 3.1989560065E+00, 9.4943156584E-01],
	[3.3630000000E+04, 2.9343437997E+01, 5.2225628667E+00, 1.1494950518E+01, 3.1994802903E+00, 9.4945514608E-01],
	[3.3635000000E+04, 2.9350860808E+01, 5.2225813724E+00, 1.1500489269E+01, 3.2000044386E+00, 9.4947871387E-01],
	[3.3640000000E+04, 2.9358284393E+01, 5.2225998754E+00, 1.1506029863E+01, 3.2005284516E+00, 9.4950226924E-01],
	[3.3645000000E+04, 2.9365708752E+01, 5.2226183757E+00, 1.1511572300E+01, 3.2010523293E+00, 9.4952581217E-01],
	[3.3650000000E+04, 2.9373133885E+01, 5.2226368733E+00, 1.1517116579E+01, 3.2015760715E+00, 9.4954934268E-01],
	[3.3655000000E+04, 2.9380559791E+01, 5.2226553682E+00, 1.1522662702E+01, 3.2020996785E+00, 9.4957286078E-01],
	[3.3660000000E+04, 2.9387986472E+01, 5.2226738605E+00, 1.1528210668E+01, 3.2026231501E+00, 9.4959636648E-01],
	[3.3665000000E+04, 2.9395413926E+01, 5.2226923500E+00, 1.1533760478E+01, 3.2031464863E+00, 9.4961985977E-01],
	[3.3670000000E+04, 2.9402842153E+01, 5.2227108369E+00, 1.1539312133E+01, 3.2036696873E+00, 9.4964334067E-01],
	[3.3675000000E+04, 2.9410271155E+01, 5.2227293211E+00, 1.1544865632E+01, 3.2041927530E+00, 9.4966680918E-01],
	[3.3680000000E+04, 2.9417700930E+01, 5.2227478027E+00, 1.1550420977E+01, 3.2047156834E+00, 9.4969026531E-01],
	[3.3685000000E+04, 2.9425131479E+01, 5.2227662815E+00, 1.1555978166E+01, 3.2052384786E+00, 9.4971370908E-01],
	[3.3690000000E+04, 2.9432562801E+01, 5.2227847577E+00, 1.1561537202E+01, 3.2057611385E+00, 9.4973714047E-01],
	[3.3695000000E+04, 2.9439994897E+01, 5.2228032312E+00, 1.1567098083E+01, 3.2062836632E+00, 9.4976055951E-01],
	[3.3700000000E+04, 2.9447427766E+01, 5.2228217020E+00, 1.1572660811E+01, 3.2068060526E+00, 9.4978396619E-01],
	[3.3705000000E+04, 2.9454861409E+01, 5.2228401701E+00, 1.1578225385E+01, 3.2073283069E+00, 9.4980736053E-01],
	[3.3710000000E+04, 2.9462295826E+01, 5.2228586356E+00, 1.1583791806E+01, 3.2078504259E+00, 9.4983074253E-01],
	[3.3715000000E+04, 2.9469731015E+01, 5.2228770984E+00, 1.1589360075E+01, 3.2083724098E+00, 9.4985411219E-01],
	[3.3720000000E+04, 2.9477166978E+01, 5.2228955585E+00, 1.1594930191E+01, 3.2088942585E+00, 9.4987746954E-01],
	[3.3725000000E+04, 2.9484603715E+01, 5.2229140160E+00, 1.1600502156E+01, 3.2094159721E+00, 9.4990081456E-01],
	[3.3730000000E+04, 2.9492041225E+01, 5.2229324708E+00, 1.1606075968E+01, 3.2099375505E+00, 9.4992414727E-01],
	[3.3735000000E+04, 2.9499479508E+01, 5.2229509229E+00, 1.1611651630E+01, 3.2104589938E+00, 9.4994746768E-01],
	[3.3740000000E+04, 2.9506918564E+01, 5.2229693723E+00, 1.1617229140E+01, 3.2109803020E+00, 9.4997077579E-01],
	[3.3745000000E+04, 2.9514358393E+01, 5.2229878191E+00, 1.1622808500E+01, 3.2115014751E+00, 9.4999407161E-01],
	[3.3750000000E+04, 2.9521798996E+01, 5.2230062632E+00, 1.1628389710E+01, 3.2120225131E+00, 9.5001735515E-01],
	[3.3755000000E+04, 2.9529240372E+01, 5.2230247046E+00, 1.1633972770E+01, 3.2125434160E+00, 9.5004062641E-01],
	[3.3760000000E+04, 2.9536682521E+01, 5.2230431434E+00, 1.1639557680E+01, 3.2130641839E+00, 9.5006388540E-01],
	[3.3765000000E+04, 2.9544125443E+01, 5.2230615795E+00, 1.1645144440E+01, 3.2135848168E+00, 9.5008713212E-01],
	[3.3770000000E+04, 2.9551569138E+01, 5.2230800130E+00, 1.1650733052E+01, 3.2141053146E+00, 9.5011036659E-01],
	[3.3775000000E+04, 2.9559013606E+01, 5.2230984437E+00, 1.1656323516E+01, 3.2146256774E+00, 9.5013358881E-01],
	[3.3780000000E+04, 2.9566458847E+01, 5.2231168718E+00, 1.1661915831E+01, 3.2151459053E+00, 9.5015679879E-01],
	[3.3785000000E+04, 2.9573904861E+01, 5.2231352973E+00, 1.1667509998E+01, 3.2156659981E+00, 9.5017999653E-01],
	[3.3790000000E+04, 2.9581351647E+01, 5.2231537201E+00, 1.1673106017E+01, 3.2161859560E+00, 9.5020318204E-01],
	[3.3795000000E+04, 2.9588799207E+01, 5.2231721402E+00, 1.1678703889E+01, 3.2167057789E+00, 9.5022635532E-01],
	[3.3800000000E+04, 2.9596247539E+01, 5.2231905577E+00, 1.1684303615E+01, 3.2172254669E+00, 9.5024951639E-01],
	[3.3805000000E+04, 2.9603696645E+01, 5.2232089725E+00, 1.1689905194E+01, 3.2177450199E+00, 9.5027266526E-01],
	[3.3810000000E+04, 2.9611146523E+01, 5.2232273846E+00, 1.1695508626E+01, 3.2182644381E+00, 9.5029580192E-01],
	[3.3815000000E+04, 2.9618597174E+01, 5.2232457941E+00, 1.1701113913E+01, 3.2187837213E+00, 9.5031892638E-01],
	[3.3820000000E+04, 2.9626048597E+01, 5.2232642010E+00, 1.1706721054E+01, 3.2193028697E+00, 9.5034203866E-01],
	[3.3825000000E+04, 2.9633500793E+01, 5.2232826051E+00, 1.1712330050E+01, 3.2198218832E+00, 9.5036513875E-01],
	[3.3830000000E+04, 2.9640953762E+01, 5.2233010067E+00, 1.1717940901E+01, 3.2203407618E+00, 9.5038822667E-01],
	[3.3835000000E+04, 2.9648407503E+01, 5.2233194055E+00, 1.1723553608E+01, 3.2208595056E+00, 9.5041130242E-01],
	[3.3840000000E+04, 2.9655862017E+01, 5.2233378018E+00, 1.1729168170E+01, 3.2213781146E+00, 9.5043436601E-01],
	[3.3845000000E+04, 2.9663317304E+01, 5.2233561953E+00, 1.1734784588E+01, 3.2218965888E+00, 9.5045741745E-01],
	[3.3850000000E+04, 2.9670773362E+01, 5.2233745862E+00, 1.1740402863E+01, 3.2224149282E+00, 9.5048045673E-01],
	[3.3855000000E+04, 2.9678230194E+01, 5.2233929745E+00, 1.1746022995E+01, 3.2229331328E+00, 9.5050348388E-01],
	[3.3860000000E+04, 2.9685687798E+01, 5.2234113601E+00, 1.1751644984E+01, 3.2234512026E+00, 9.5052649889E-01],
	[3.3865000000E+04, 2.9693146174E+01, 5.2234297431E+00, 1.1757268830E+01, 3.2239691377E+00, 9.5054950177E-01],
	[3.3870000000E+04, 2.9700605322E+01, 5.2234481234E+00, 1.1762894534E+01, 3.2244869380E+00, 9.5057249254E-01],
	[3.3875000000E+04, 2.9708065243E+01, 5.2234665010E+00, 1.1768522097E+01, 3.2250046037E+00, 9.5059547119E-01],
	[3.3880000000E+04, 2.9715525936E+01, 5.2234848760E+00, 1.1774151518E+01, 3.2255221346E+00, 9.5061843773E-01],
	[3.3885000000E+04, 2.9722987402E+01, 5.2235032484E+00, 1.1779782797E+01, 3.2260395308E+00, 9.5064139217E-01],
	[3.3890000000E+04, 2.9730449639E+01, 5.2235216181E+00, 1.1785415936E+01, 3.2265567923E+00, 9.5066433452E-01],
	[3.3895000000E+04, 2.9737912649E+01, 5.2235399852E+00, 1.1791050934E+01, 3.2270739192E+00, 9.5068726478E-01],
	[3.3900000000E+04, 2.9745376431E+01, 5.2235583496E+00, 1.1796687793E+01, 3.2275909114E+00, 9.5071018296E-01],
	[3.3905000000E+04, 2.9752840985E+01, 5.2235767114E+00, 1.1802326511E+01, 3.2281077690E+00, 9.5073308907E-01],
	[3.3910000000E+04, 2.9760306311E+01, 5.2235950705E+00, 1.1807967090E+01, 3.2286244920E+00, 9.5075598311E-01],
	[3.3915000000E+04, 2.9767772409E+01, 5.2236134270E+00, 1.1813609530E+01, 3.2291410804E+00, 9.5077886509E-01],
	[3.3920000000E+04, 2.9775239279E+01, 5.2236317809E+00, 1.1819253831E+01, 3.2296575342E+00, 9.5080173502E-01],
	[3.3925000000E+04, 2.9782706922E+01, 5.2236501321E+00, 1.1824899994E+01, 3.2301738534E+00, 9.5082459290E-01],
	[3.3930000000E+04, 2.9790175336E+01, 5.2236684807E+00, 1.1830548018E+01, 3.2306900381E+00, 9.5084743874E-01],
	[3.3935000000E+04, 2.9797644522E+01, 5.2236868266E+00, 1.1836197905E+01, 3.2312060882E+00, 9.5087027255E-01],
	[3.3940000000E+04, 2.9805114480E+01, 5.2237051699E+00, 1.1841849654E+01, 3.2317220038E+00, 9.5089309433E-01],
	[3.3945000000E+04, 2.9812585209E+01, 5.2237235106E+00, 1.1847503266E+01, 3.2322377848E+00, 9.5091590410E-01],
	[3.3950000000E+04, 2.9820056711E+01, 5.2237418486E+00, 1.1853158742E+01, 3.2327534314E+00, 9.5093870185E-01],
	[3.3955000000E+04, 2.9827528984E+01, 5.2237601840E+00, 1.1858816081E+01, 3.2332689435E+00, 9.5096148759E-01],
	[3.3960000000E+04, 2.9835002029E+01, 5.2237785168E+00, 1.1864475283E+01, 3.2337843211E+00, 9.5098426134E-01],
	[3.3965000000E+04, 2.9842475846E+01, 5.2237968469E+00, 1.1870136351E+01, 3.2342995643E+00, 9.5100702309E-01],
	[3.3970000000E+04, 2.9849950434E+01, 5.2238151744E+00, 1.1875799282E+01, 3.2348146730E+00, 9.5102977286E-01],
	[3.3975000000E+04, 2.9857425794E+01, 5.2238334992E+00, 1.1881464079E+01, 3.2353296473E+00, 9.5105251065E-01],
	[3.3980000000E+04, 2.9864901926E+01, 5.2238518214E+00, 1.1887130741E+01, 3.2358444873E+00, 9.5107523647E-01],
	[3.3985000000E+04, 2.9872384615E+01, 5.2238708445E+00, 1.1892799268E+01, 3.2363595307E+00, 9.5109795032E-01],
	[3.3990000000E+04, 2.9879883692E+01, 5.2238917627E+00, 1.1898469662E+01, 3.2368753518E+00, 9.5112065222E-01],
	[3.3995000000E+04, 2.9887383547E+01, 5.2239126779E+00, 1.1904141921E+01, 3.2373910390E+00, 9.5114334216E-01],
	[3.4000000000E+04, 2.9894884182E+01, 5.2239335902E+00, 1.1909816048E+01, 3.2379065923E+00, 9.5116602016E-01],
	[3.4005000000E+04, 2.9902385596E+01, 5.2239544994E+00, 1.1915492041E+01, 3.2384220118E+00, 9.5118868622E-01],
	[3.4010000000E+04, 2.9909887788E+01, 5.2239754056E+00, 1.1921169902E+01, 3.2389372974E+00, 9.5121134034E-01],
	[3.4015000000E+04, 2.9917390760E+01, 5.2239963089E+00, 1.1926849630E+01, 3.2394524493E+00, 9.5123398255E-01],
	[3.4020000000E+04, 2.9924894511E+01, 5.2240172092E+00, 1.1932531226E+01, 3.2399674673E+00, 9.5125661283E-01],
	[3.4025000000E+04, 2.9932399040E+01, 5.2240381065E+00, 1.1938214691E+01, 3.2404823515E+00, 9.5127923120E-01],
	[3.4030000000E+04, 2.9939904348E+01, 5.2240590008E+00, 1.1943900024E+01, 3.2409971020E+00, 9.5130183767E-01],
	[3.4035000000E+04, 2.9947410435E+01, 5.2240798921E+00, 1.1949587226E+01, 3.2415117187E+00, 9.5132443224E-01],
	[3.4040000000E+04, 2.9954917301E+01, 5.2241007804E+00, 1.1955276297E+01, 3.2420262016E+00, 9.5134701492E-01],
	[3.4045000000E+04, 2.9962424946E+01, 5.2241216658E+00, 1.1960967239E+01, 3.2425405508E+00, 9.5136958571E-01],
	[3.4050000000E+04, 2.9969933369E+01, 5.2241425481E+00, 1.1966660050E+01, 3.2430547663E+00, 9.5139214463E-01],
	[3.4055000000E+04, 2.9977442571E+01, 5.2241634275E+00, 1.1972354731E+01, 3.2435688481E+00, 9.5141469167E-01],
	[3.4060000000E+04, 2.9984952552E+01, 5.2241843039E+00, 1.1978051283E+01, 3.2440827962E+00, 9.5143722685E-01],
	[3.4065000000E+04, 2.9992463311E+01, 5.2242051773E+00, 1.1983749707E+01, 3.2445966107E+00, 9.5145975017E-01],
	[3.4070000000E+04, 2.9999974849E+01, 5.2242260477E+00, 1.1989450001E+01, 3.2451102914E+00, 9.5148226165E-01],
	[3.4075000000E+04, 3.0007487165E+01, 5.2242469152E+00, 1.1995152167E+01, 3.2456238386E+00, 9.5150476127E-01],
	[3.4080000000E+04, 3.0015000260E+01, 5.2242677797E+00, 1.2000856206E+01, 3.2461372521E+00, 9.5152724906E-01],
	[3.4085000000E+04, 3.0022514133E+01, 5.2242886412E+00, 1.2006562116E+01, 3.2466505320E+00, 9.5154972502E-01],
	[3.4090000000E+04, 3.0030028785E+01, 5.2243094997E+00, 1.2012269900E+01, 3.2471636784E+00, 9.5157218915E-01],
	[3.4095000000E+04, 3.0037544216E+01, 5.2243303552E+00, 1.2017979556E+01, 3.2476766911E+00, 9.5159464147E-01],
	[3.4100000000E+04, 3.0045060424E+01, 5.2243512078E+00, 1.2023691086E+01, 3.2481895703E+00, 9.5161708198E-01],
	[3.4105000000E+04, 3.0052577411E+01, 5.2243720574E+00, 1.2029404489E+01, 3.2487023159E+00, 9.5163951068E-01],
	[3.4110000000E+04, 3.0060095176E+01, 5.2243929040E+00, 1.2035119767E+01, 3.2492149280E+00, 9.5166192758E-01],
	[3.4115000000E+04, 3.0067613720E+01, 5.2244137477E+00, 1.2040836919E+01, 3.2497274066E+00, 9.5168433270E-01],
	[3.4120000000E+04, 3.0075133042E+01, 5.2244345884E+00, 1.2046555945E+01, 3.2502397517E+00, 9.5170672602E-01],
	[3.4125000000E+04, 3.0082653142E+01, 5.2244554261E+00, 1.2052276847E+01, 3.2507519634E+00, 9.5172910758E-01],
	[3.4130000000E+04, 3.0090174020E+01, 5.2244762608E+00, 1.2057999624E+01, 3.2512640415E+00, 9.5175147736E-01],
	[3.4135000000E+04, 3.0097695676E+01, 5.2244970926E+00, 1.2063724277E+01, 3.2517759862E+00, 9.5177383537E-01],
	[3.4140000000E+04, 3.0105218110E+01, 5.2245179214E+00, 1.2069450806E+01, 3.2522877975E+00, 9.5179618163E-01],
	[3.4145000000E+04, 3.0112741323E+01, 5.2245387472E+00, 1.2075179212E+01, 3.2527994753E+00, 9.5181851614E-01],
	[3.4150000000E+04, 3.0120265313E+01, 5.2245595701E+00, 1.2080909494E+01, 3.2533110198E+00, 9.5184083891E-01],
	[3.4155000000E+04, 3.0127790082E+01, 5.2245803900E+00, 1.2086641653E+01, 3.2538224308E+00, 9.5186314993E-01],
	[3.4160000000E+04, 3.0135315629E+01, 5.2246012069E+00, 1.2092375690E+01, 3.2543337085E+00, 9.5188544923E-01],
	[3.4165000000E+04, 3.0142841953E+01, 5.2246220209E+00, 1.2098111605E+01, 3.2548448528E+00, 9.5190773680E-01],
	[3.4170000000E+04, 3.0150369055E+01, 5.2246428319E+00, 1.2103849398E+01, 3.2553558638E+00, 9.5193001265E-01],
	[3.4175000000E+04, 3.0157896936E+01, 5.2246636400E+00, 1.2109589069E+01, 3.2558667415E+00, 9.5195227679E-01],
	[3.4180000000E+04, 3.0165425594E+01, 5.2246844450E+00, 1.2115330619E+01, 3.2563774858E+00, 9.5197452922E-01],
	[3.4185000000E+04, 3.0172955029E+01, 5.2247052472E+00, 1.2121074048E+01, 3.2568880969E+00, 9.5199676995E-01],
	[3.4190000000E+04, 3.0180485243E+01, 5.2247260463E+00, 1.2126819356E+01, 3.2573985747E+00, 9.5201899898E-01],
	[3.4195000000E+04, 3.0188016235E+01, 5.2247468426E+00, 1.2132566545E+01, 3.2579089192E+00, 9.5204121632E-01],
	[3.4200000000E+04, 3.0195548004E+01, 5.2247676358E+00, 1.2138315613E+01, 3.2584191305E+00, 9.5206342198E-01],
	[3.4205000000E+04, 3.0203080550E+01, 5.2247884261E+00, 1.2144066563E+01, 3.2589292085E+00, 9.5208561596E-01],
	[3.4210000000E+04, 3.0210613875E+01, 5.2248092134E+00, 1.2149819392E+01, 3.2594391534E+00, 9.5210779827E-01],
	[3.4215000000E+04, 3.0218147977E+01, 5.2248299978E+00, 1.2155574104E+01, 3.2599489650E+00, 9.5212996892E-01],
	[3.4220000000E+04, 3.0225682856E+01, 5.2248507793E+00, 1.2161330696E+01, 3.2604586435E+00, 9.5215212790E-01],
	[3.4225000000E+04, 3.0233218514E+01, 5.2248715577E+00, 1.2167089171E+01, 3.2609681888E+00, 9.5217427524E-01],
	[3.4230000000E+04, 3.0240754948E+01, 5.2248923332E+00, 1.2172849527E+01, 3.2614776009E+00, 9.5219641092E-01],
	[3.4235000000E+04, 3.0248292160E+01, 5.2249131058E+00, 1.2178611766E+01, 3.2619868799E+00, 9.5221853496E-01],
	[3.4240000000E+04, 3.0255830150E+01, 5.2249338754E+00, 1.2184375889E+01, 3.2624960258E+00, 9.5224064737E-01],
	[3.4245000000E+04, 3.0263368917E+01, 5.2249546421E+00, 1.2190141894E+01, 3.2630050387E+00, 9.5226274815E-01],
	[3.4250000000E+04, 3.0270908461E+01, 5.2249754058E+00, 1.2195909783E+01, 3.2635139184E+00, 9.5228483730E-01],
	[3.4255000000E+04, 3.0278448783E+01, 5.2249961666E+00, 1.2201679555E+01, 3.2640226651E+00, 9.5230691484E-01],
	[3.4260000000E+04, 3.0285989882E+01, 5.2250169244E+00, 1.2207451212E+01, 3.2645312787E+00, 9.5232898077E-01],
	[3.4265000000E+04, 3.0293531758E+01, 5.2250376793E+00, 1.2213224754E+01, 3.2650397592E+00, 9.5235103509E-01],
	[3.4270000000E+04, 3.0301074412E+01, 5.2250584312E+00, 1.2219000180E+01, 3.2655481068E+00, 9.5237307781E-01],
	[3.4275000000E+04, 3.0308617842E+01, 5.2250791802E+00, 1.2224777492E+01, 3.2660563214E+00, 9.5239510894E-01],
	[3.4280000000E+04, 3.0316162050E+01, 5.2250999263E+00, 1.2230556689E+01, 3.2665644030E+00, 9.5241712848E-01],
	[3.4285000000E+04, 3.0323707035E+01, 5.2251206694E+00, 1.2236337772E+01, 3.2670723516E+00, 9.5243913644E-01],
	[3.4290000000E+04, 3.0331252797E+01, 5.2251414095E+00, 1.2242120741E+01, 3.2675801672E+00, 9.5246113283E-01],
	[3.4295000000E+04, 3.0338799336E+01, 5.2251621467E+00, 1.2247905597E+01, 3.2680878500E+00, 9.5248311764E-01],
	[3.4300000000E+04, 3.0346346653E+01, 5.2251828810E+00, 1.2253692340E+01, 3.2685953998E+00, 9.5250509090E-01],
	[3.4305000000E+04, 3.0353894746E+01, 5.2252036123E+00, 1.2259480970E+01, 3.2691028167E+00, 9.5252705259E-01],
	[3.4310000000E+04, 3.0361443616E+01, 5.2252243407E+00, 1.2265271488E+01, 3.2696101007E+00, 9.5254900274E-01],
	[3.4315000000E+04, 3.0368993263E+01, 5.2252450662E+00, 1.2271063894E+01, 3.2701172519E+00, 9.5257094134E-01],
	[3.4320000000E+04, 3.0376543687E+01, 5.2252657887E+00, 1.2276858188E+01, 3.2706242702E+00, 9.5259286840E-01],
	[3.4325000000E+04, 3.0384094888E+01, 5.2252865083E+00, 1.2282654371E+01, 3.2711311557E+00, 9.5261478393E-01],
	[3.4330000000E+04, 3.0391646866E+01, 5.2253072249E+00, 1.2288452442E+01, 3.2716379083E+00, 9.5263668793E-01],
	[3.4335000000E+04, 3.0399199621E+01, 5.2253279386E+00, 1.2294252403E+01, 3.2721445282E+00, 9.5265858041E-01],
	[3.4340000000E+04, 3.0406753152E+01, 5.2253486494E+00, 1.2300054254E+01, 3.2726510153E+00, 9.5268046137E-01],
	[3.4345000000E+04, 3.0414307460E+01, 5.2253693573E+00, 1.2305857994E+01, 3.2731573696E+00, 9.5270233083E-01],
	[3.4350000000E+04, 3.0421862545E+01, 5.2253900622E+00, 1.2311663625E+01, 3.2736635911E+00, 9.5272418878E-01],
	[3.4355000000E+04, 3.0429418406E+01, 5.2254107642E+00, 1.2317471147E+01, 3.2741696800E+00, 9.5274603524E-01],
	[3.4360000000E+04, 3.0436975045E+01, 5.2254314632E+00, 1.2323280559E+01, 3.2746756361E+00, 9.5276787020E-01],
	[3.4365000000E+04, 3.0444532459E+01, 5.2254521593E+00, 1.2329091863E+01, 3.2751814595E+00, 9.5278969368E-01],
	[3.4370000000E+04, 3.0452090651E+01, 5.2254728525E+00, 1.2334905059E+01, 3.2756871502E+00, 9.5281150568E-01],
	[3.4375000000E+04, 3.0459649619E+01, 5.2254935428E+00, 1.2340720146E+01, 3.2761927082E+00, 9.5283330621E-01],
	[3.4380000000E+04, 3.0467209363E+01, 5.2255142301E+00, 1.2346537126E+01, 3.2766981337E+00, 9.5285509527E-01],
	[3.4385000000E+04, 3.0474769884E+01, 5.2255349145E+00, 1.2352355999E+01, 3.2772034264E+00, 9.5287687287E-01],
	[3.4390000000E+04, 3.0482331181E+01, 5.2255555960E+00, 1.2358176765E+01, 3.2777085866E+00, 9.5289863901E-01],
	[3.4395000000E+04, 3.0489893255E+01, 5.2255762746E+00, 1.2363999424E+01, 3.2782136142E+00, 9.5292039371E-01],
	[3.4400000000E+04, 3.0497456105E+01, 5.2255969502E+00, 1.2369823977E+01, 3.2787185091E+00, 9.5294213696E-01],
	[3.4405000000E+04, 3.0505019731E+01, 5.2256176229E+00, 1.2375650424E+01, 3.2792232716E+00, 9.5296386878E-01],
	[3.4410000000E+04, 3.0512584134E+01, 5.2256382927E+00, 1.2381478765E+01, 3.2797279014E+00, 9.5298558917E-01],
	[3.4415000000E+04, 3.0520149313E+01, 5.2256589596E+00, 1.2387309001E+01, 3.2802323988E+00, 9.5300729813E-01],
	[3.4420000000E+04, 3.0527715268E+01, 5.2256796235E+00, 1.2393141132E+01, 3.2807367636E+00, 9.5302899567E-01],
	[3.4425000000E+04, 3.0535282000E+01, 5.2257002845E+00, 1.2398975158E+01, 3.2812409959E+00, 9.5305068180E-01],
	[3.4430000000E+04, 3.0542849507E+01, 5.2257209426E+00, 1.2404811081E+01, 3.2817450958E+00, 9.5307235652E-01],
	[3.4435000000E+04, 3.0550417791E+01, 5.2257415978E+00, 1.2410648899E+01, 3.2822490632E+00, 9.5309401984E-01],
	[3.4440000000E+04, 3.0557986851E+01, 5.2257622501E+00, 1.2416488614E+01, 3.2827528981E+00, 9.5311567177E-01],
	[3.4445000000E+04, 3.0565556687E+01, 5.2257828994E+00, 1.2422330225E+01, 3.2832566006E+00, 9.5313731231E-01],
	[3.4450000000E+04, 3.0573127299E+01, 5.2258035459E+00, 1.2428173734E+01, 3.2837601708E+00, 9.5315894146E-01],
	[3.4455000000E+04, 3.0580698687E+01, 5.2258241894E+00, 1.2434019140E+01, 3.2842636085E+00, 9.5318055924E-01],
	[3.4460000000E+04, 3.0588270851E+01, 5.2258448300E+00, 1.2439866444E+01, 3.2847669138E+00, 9.5320216565E-01],
	[3.4465000000E+04, 3.0595843791E+01, 5.2258654677E+00, 1.2445715646E+01, 3.2852700868E+00, 9.5322376069E-01],
	[3.4470000000E+04, 3.0603417507E+01, 5.2258861025E+00, 1.2451566746E+01, 3.2857731275E+00, 9.5324534438E-01],
	[3.4475000000E+04, 3.0610991998E+01, 5.2259067344E+00, 1.2457419745E+01, 3.2862760358E+00, 9.5326691671E-01],
	[3.4480000000E+04, 3.0618567266E+01, 5.2259273633E+00, 1.2463274644E+01, 3.2867788118E+00, 9.5328847769E-01],
	[3.4485000000E+04, 3.0626143309E+01, 5.2259479894E+00, 1.2469131442E+01, 3.2872814555E+00, 9.5331002734E-01],
	[3.4490000000E+04, 3.0633720128E+01, 5.2259686125E+00, 1.2474990139E+01, 3.2877839670E+00, 9.5333156565E-01],
	[3.4495000000E+04, 3.0641297723E+01, 5.2259892328E+00, 1.2480850737E+01, 3.2882863462E+00, 9.5335309263E-01],
	[3.4500000000E+04, 3.0648876094E+01, 5.2260098501E+00, 1.2486713236E+01, 3.2887885932E+00, 9.5337460828E-01],
	[3.4505000000E+04, 3.0656455240E+01, 5.2260304645E+00, 1.2492577635E+01, 3.2892907079E+00, 9.5339611262E-01],
	[3.4510000000E+04, 3.0664035162E+01, 5.2260510760E+00, 1.2498443935E+01, 3.2897926905E+00, 9.5341760565E-01],
	[3.4515000000E+04, 3.0671615860E+01, 5.2260716847E+00, 1.2504312137E+01, 3.2902945408E+00, 9.5343908738E-01],
	[3.4520000000E+04, 3.0679197333E+01, 5.2260922904E+00, 1.2510182241E+01, 3.2907962590E+00, 9.5346055781E-01],
	[3.4525000000E+04, 3.0686779582E+01, 5.2261128932E+00, 1.2516054247E+01, 3.2912978451E+00, 9.5348201694E-01],
	[3.4530000000E+04, 3.0694362606E+01, 5.2261334931E+00, 1.2521928155E+01, 3.2917992990E+00, 9.5350346479E-01],
	[3.4535000000E+04, 3.0701964447E+01, 5.2261562606E+00, 1.2527803967E+01, 3.2923016897E+00, 9.5352490135E-01],
	[3.4540000000E+04, 3.0709570197E+01, 5.2261794011E+00, 1.2533681681E+01, 3.2928041339E+00, 9.5354632664E-01],
	[3.4545000000E+04, 3.0717176730E+01, 5.2262025383E+00, 1.2539561299E+01, 3.2933064465E+00, 9.5356774067E-01],
	[3.4550000000E+04, 3.0724784046E+01, 5.2262256723E+00, 1.2545442821E+01, 3.2938086275E+00, 9.5358914342E-01],
	[3.4555000000E+04, 3.0732392144E+01, 5.2262488030E+00, 1.2551326248E+01, 3.2943106769E+00, 9.5361053493E-01],
	[3.4560000000E+04, 3.0740001026E+01, 5.2262719305E+00, 1.2557211579E+01, 3.2948125948E+00, 9.5363191518E-01],
	[3.4565000000E+04, 3.0747610689E+01, 5.2262950548E+00, 1.2563098814E+01, 3.2953143811E+00, 9.5365328419E-01],
	[3.4570000000E+04, 3.0755221136E+01, 5.2263181758E+00, 1.2568987955E+01, 3.2958160358E+00, 9.5367464195E-01],
	[3.4575000000E+04, 3.0762832365E+01, 5.2263412936E+00, 1.2574879002E+01, 3.2963175590E+00, 9.5369598849E-01],
	[3.4580000000E+04, 3.0770444377E+01, 5.2263644081E+00, 1.2580771955E+01, 3.2968189508E+00, 9.5371732380E-01],
	[3.4585000000E+04, 3.0778057171E+01, 5.2263875194E+00, 1.2586666813E+01, 3.2973202110E+00, 9.5373864788E-01],
	[3.4590000000E+04, 3.0785670748E+01, 5.2264106274E+00, 1.2592563579E+01, 3.2978213398E+00, 9.5375996076E-01],
	[3.4595000000E+04, 3.0793285107E+01, 5.2264337322E+00, 1.2598462251E+01, 3.2983223371E+00, 9.5378126242E-01],
	[3.4600000000E+04, 3.0800900249E+01, 5.2264568338E+00, 1.2604362831E+01, 3.2988232030E+00, 9.5380255288E-01],
	[3.4605000000E+04, 3.0808516173E+01, 5.2264799321E+00, 1.2610265318E+01, 3.2993239375E+00, 9.5382383214E-01],
	[3.4610000000E+04, 3.0816132880E+01, 5.2265030272E+00, 1.2616169713E+01, 3.2998245406E+00, 9.5384510022E-01],
	[3.4615000000E+04, 3.0823750369E+01, 5.2265261191E+00, 1.2622076017E+01, 3.3003250123E+00, 9.5386635710E-01],
	[3.4620000000E+04, 3.0831368641E+01, 5.2265492077E+00, 1.2627984229E+01, 3.3008253527E+00, 9.5388760281E-01],
	[3.4625000000E+04, 3.0838987694E+01, 5.2265722931E+00, 1.2633894351E+01, 3.3013255617E+00, 9.5390883735E-01],
	[3.4630000000E+04, 3.0846607530E+01, 5.2265953753E+00, 1.2639806381E+01, 3.3018256394E+00, 9.5393006072E-01],
	[3.4635000000E+04, 3.0854228148E+01, 5.2266184542E+00, 1.2645720321E+01, 3.3023255858E+00, 9.5395127292E-01],
	[3.4640000000E+04, 3.0861849549E+01, 5.2266415299E+00, 1.2651636172E+01, 3.3028254009E+00, 9.5397247398E-01],
	[3.4645000000E+04, 3.0869471731E+01, 5.2266646024E+00, 1.2657553932E+01, 3.3033250847E+00, 9.5399366388E-01],
	[3.4650000000E+04, 3.0877094696E+01, 5.2266876716E+00, 1.2663473603E+01, 3.3038246373E+00, 9.5401484264E-01],
	[3.4655000000E+04, 3.0884718443E+01, 5.2267107377E+00, 1.2669395186E+01, 3.3043240586E+00, 9.5403601026E-01],
	[3.4660000000E+04, 3.0892342971E+01, 5.2267338005E+00, 1.2675318679E+01, 3.3048233487E+00, 9.5405716675E-01],
	[3.4665000000E+04, 3.0899968282E+01, 5.2267568600E+00, 1.2681244085E+01, 3.3053225076E+00, 9.5407831212E-01],
	[3.4670000000E+04, 3.0907594375E+01, 5.2267799164E+00, 1.2687171402E+01, 3.3058215354E+00, 9.5409944637E-01],
	[3.4675000000E+04, 3.0915221250E+01, 5.2268029695E+00, 1.2693100632E+01, 3.3063204320E+00, 9.5412056950E-01],
	[3.4680000000E+04, 3.0922848907E+01, 5.2268260194E+00, 1.2699031775E+01, 3.3068191974E+00, 9.5414168153E-01],
	[3.4685000000E+04, 3.0930477346E+01, 5.2268490661E+00, 1.2704964830E+01, 3.3073178317E+00, 9.5416278245E-01],
	[3.4690000000E+04, 3.0938106566E+01, 5.2268721095E+00, 1.2710899799E+01, 3.3078163349E+00, 9.5418387228E-01],
	[3.4695000000E+04, 3.0945736569E+01, 5.2268951498E+00, 1.2716836682E+01, 3.3083147070E+00, 9.5420495102E-01],
	[3.4700000000E+04, 3.0953367353E+01, 5.2269181868E+00, 1.2722775479E+01, 3.3088129481E+00, 9.5422601868E-01],
	[3.4705000000E+04, 3.0960998919E+01, 5.2269412206E+00, 1.2728716190E+01, 3.3093110580E+00, 9.5424707526E-01],
	[3.4710000000E+04, 3.0968631267E+01, 5.2269642512E+00, 1.2734658816E+01, 3.3098090370E+00, 9.5426812077E-01],
	[3.4715000000E+04, 3.0976264396E+01, 5.2269872786E+00, 1.2740603357E+01, 3.3103068849E+00, 9.5428915521E-01],
	[3.4720000000E+04, 3.0983898308E+01, 5.2270103027E+00, 1.2746549814E+01, 3.3108046018E+00, 9.5431017859E-01],
	[3.4725000000E+04, 3.0991533001E+01, 5.2270333237E+00, 1.2752498186E+01, 3.3113021878E+00, 9.5433119092E-01],
	[3.4730000000E+04, 3.0999168475E+01, 5.2270563414E+00, 1.2758448475E+01, 3.3117996428E+00, 9.5435219220E-01],
	[3.4735000000E+04, 3.1006804731E+01, 5.2270793559E+00, 1.2764400680E+01, 3.3122969668E+00, 9.5437318244E-01],
	[3.4740000000E+04, 3.1014441769E+01, 5.2271023672E+00, 1.2770354801E+01, 3.3127941599E+00, 9.5439416165E-01],
	[3.4745000000E+04, 3.1022079588E+01, 5.2271253753E+00, 1.2776310840E+01, 3.3132912221E+00, 9.5441512982E-01],
	[3.4750000000E+04, 3.1029718188E+01, 5.2271483802E+00, 1.2782268797E+01, 3.3137881534E+00, 9.5443608697E-01],
	[3.4755000000E+04, 3.1037357570E+01, 5.2271713819E+00, 1.2788228671E+01, 3.3142849539E+00, 9.5445703310E-01],
	[3.4760000000E+04, 3.1044997734E+01, 5.2271943804E+00, 1.2794190463E+01, 3.3147816234E+00, 9.5447796822E-01],
	[3.4765000000E+04, 3.1052638679E+01, 5.2272173756E+00, 1.2800154174E+01, 3.3152781622E+00, 9.5449889234E-01],
	[3.4770000000E+04, 3.1060280405E+01, 5.2272403677E+00, 1.2806119804E+01, 3.3157745701E+00, 9.5451980545E-01],
	[3.4775000000E+04, 3.1067922913E+01, 5.2272633565E+00, 1.2812087353E+01, 3.3162708473E+00, 9.5454070758E-01],
	[3.4780000000E+04, 3.1075566201E+01, 5.2272863422E+00, 1.2818056821E+01, 3.3167669936E+00, 9.5456159871E-01],
	[3.4785000000E+04, 3.1083210272E+01, 5.2273093246E+00, 1.2824028210E+01, 3.3172630092E+00, 9.5458247886E-01],
	[3.4790000000E+04, 3.1090855123E+01, 5.2273323039E+00, 1.2830001518E+01, 3.3177588941E+00, 9.5460334803E-01],
	[3.4795000000E+04, 3.1098500755E+01, 5.2273552799E+00, 1.2835976747E+01, 3.3182546482E+00, 9.5462420624E-01],
	[3.4800000000E+04, 3.1106147169E+01, 5.2273782527E+00, 1.2841953897E+01, 3.3187502716E+00, 9.5464505348E-01],
	[3.4805000000E+04, 3.1113794364E+01, 5.2274012224E+00, 1.2847932968E+01, 3.3192457643E+00, 9.5466588976E-01],
	[3.4810000000E+04, 3.1121442340E+01, 5.2274241888E+00, 1.2853913961E+01, 3.3197411264E+00, 9.5468671509E-01],
	[3.4815000000E+04, 3.1129091097E+01, 5.2274471521E+00, 1.2859896876E+01, 3.3202363578E+00, 9.5470752947E-01],
	[3.4820000000E+04, 3.1136740635E+01, 5.2274701121E+00, 1.2865881713E+01, 3.3207314586E+00, 9.5472833291E-01],
	[3.4825000000E+04, 3.1144390954E+01, 5.2274930690E+00, 1.2871868472E+01, 3.3212264287E+00, 9.5474912542E-01],
	[3.4830000000E+04, 3.1152042054E+01, 5.2275160226E+00, 1.2877857154E+01, 3.3217212683E+00, 9.5476990700E-01],
	[3.4835000000E+04, 3.1159693935E+01, 5.2275389731E+00, 1.2883847760E+01, 3.3222159773E+00, 9.5479067765E-01],
	[3.4840000000E+04, 3.1167346597E+01, 5.2275619204E+00, 1.2889840289E+01, 3.3227105557E+00, 9.5481143739E-01],
	[3.4845000000E+04, 3.1175000039E+01, 5.2275848644E+00, 1.2895834743E+01, 3.3232050036E+00, 9.5483218622E-01],
	[3.4850000000E+04, 3.1182654263E+01, 5.2276078053E+00, 1.2901831120E+01, 3.3236993210E+00, 9.5485292415E-01],
	[3.4855000000E+04, 3.1190309267E+01, 5.2276307430E+00, 1.2907829422E+01, 3.3241935079E+00, 9.5487365117E-01],
	[3.4860000000E+04, 3.1197965052E+01, 5.2276536775E+00, 1.2913829649E+01, 3.3246875643E+00, 9.5489436730E-01],
	[3.4865000000E+04, 3.1205621618E+01, 5.2276766089E+00, 1.2919831802E+01, 3.3251814902E+00, 9.5491507255E-01],
	[3.4870000000E+04, 3.1213278965E+01, 5.2276995370E+00, 1.2925835880E+01, 3.3256752857E+00, 9.5493576691E-01],
	[3.4875000000E+04, 3.1220937092E+01, 5.2277224619E+00, 1.2931841884E+01, 3.3261689508E+00, 9.5495645040E-01],
	[3.4880000000E+04, 3.1228596000E+01, 5.2277453837E+00, 1.2937849814E+01, 3.3266624854E+00, 9.5497712302E-01],
	[3.4885000000E+04, 3.1236255688E+01, 5.2277683023E+00, 1.2943859671E+01, 3.3271558897E+00, 9.5499778477E-01],
	[3.4890000000E+04, 3.1243916158E+01, 5.2277912176E+00, 1.2949871455E+01, 3.3276491636E+00, 9.5501843567E-01],
	[3.4895000000E+04, 3.1251577407E+01, 5.2278141298E+00, 1.2955885166E+01, 3.3281423071E+00, 9.5503907572E-01],
	[3.4900000000E+04, 3.1259239437E+01, 5.2278370389E+00, 1.2961900805E+01, 3.3286353203E+00, 9.5505970492E-01],
	[3.4905000000E+04, 3.1266902248E+01, 5.2278599447E+00, 1.2967918373E+01, 3.3291282032E+00, 9.5508032328E-01],
	[3.4910000000E+04, 3.1274565839E+01, 5.2278828474E+00, 1.2973937868E+01, 3.3296209558E+00, 9.5510093081E-01],
	[3.4915000000E+04, 3.1282230211E+01, 5.2279057469E+00, 1.2979959292E+01, 3.3301135781E+00, 9.5512152751E-01],
	[3.4920000000E+04, 3.1289895362E+01, 5.2279286432E+00, 1.2985982645E+01, 3.3306060702E+00, 9.5514211339E-01],
	[3.4925000000E+04, 3.1297561295E+01, 5.2279515363E+00, 1.2992007928E+01, 3.3310984321E+00, 9.5516268845E-01],
	[3.4930000000E+04, 3.1305228007E+01, 5.2279744262E+00, 1.2998035140E+01, 3.3315906637E+00, 9.5518325270E-01],
	[3.4935000000E+04, 3.1312895500E+01, 5.2279973130E+00, 1.3004064283E+01, 3.3320827651E+00, 9.5520380615E-01],
	[3.4940000000E+04, 3.1320563773E+01, 5.2280201966E+00, 1.3010095355E+01, 3.3325747363E+00, 9.5522434880E-01],
	[3.4945000000E+04, 3.1328232826E+01, 5.2280430770E+00, 1.3016128359E+01, 3.3330665774E+00, 9.5524488066E-01],
	[3.4950000000E+04, 3.1335902660E+01, 5.2280659543E+00, 1.3022163294E+01, 3.3335582883E+00, 9.5526540173E-01],
	[3.4955000000E+04, 3.1343573274E+01, 5.2280888283E+00, 1.3028200160E+01, 3.3340498692E+00, 9.5528591202E-01],
	[3.4960000000E+04, 3.1351244667E+01, 5.2281116992E+00, 1.3034238958E+01, 3.3345413199E+00, 9.5530641154E-01],
	[3.4965000000E+04, 3.1358916841E+01, 5.2281345670E+00, 1.3040279688E+01, 3.3350326405E+00, 9.5532690028E-01],
	[3.4970000000E+04, 3.1366589795E+01, 5.2281574315E+00, 1.3046322350E+01, 3.3355238311E+00, 9.5534737827E-01],
	[3.4975000000E+04, 3.1374263529E+01, 5.2281802929E+00, 1.3052366945E+01, 3.3360148916E+00, 9.5536784550E-01],
	[3.4980000000E+04, 3.1381938043E+01, 5.2282031512E+00, 1.3058413473E+01, 3.3365058221E+00, 9.5538830197E-01],
	[3.4985000000E+04, 3.1389613337E+01, 5.2282260062E+00, 1.3064461935E+01, 3.3369966226E+00, 9.5540874770E-01],
	[3.4990000000E+04, 3.1397289411E+01, 5.2282488581E+00, 1.3070512331E+01, 3.3374872930E+00, 9.5542918270E-01],
	[3.4995000000E+04, 3.1404966265E+01, 5.2282717068E+00, 1.3076564661E+01, 3.3379778336E+00, 9.5544960696E-01],
	[3.5000000000E+04, 3.1412643899E+01, 5.2282945524E+00, 1.3082618925E+01, 3.3384682441E+00, 9.5547002049E-01],
	[3.5005000000E+04, 3.1420322312E+01, 5.2283173948E+00, 1.3088684456E+01, 3.3389591321E+00, 9.5549042330E-01],
	[3.5010000000E+04, 3.1428001505E+01, 5.2283402340E+00, 1.3094751930E+01, 3.3394498899E+00, 9.5551081540E-01],
	[3.5015000000E+04, 3.1435681479E+01, 5.2283630701E+00, 1.3100821347E+01, 3.3399405175E+00, 9.5553119678E-01],
	[3.5020000000E+04, 3.1443362231E+01, 5.2283859030E+00, 1.3106892708E+01, 3.3404310149E+00, 9.5555156746E-01],
	[3.5025000000E+04, 3.1451043764E+01, 5.2284087328E+00, 1.3112966011E+01, 3.3409213822E+00, 9.5557192745E-01],
	[3.5030000000E+04, 3.1458726076E+01, 5.2284315594E+00, 1.3119041259E+01, 3.3414116194E+00, 9.5559227674E-01],
	[3.5035000000E+04, 3.1466409168E+01, 5.2284543828E+00, 1.3125118451E+01, 3.3419017265E+00, 9.5561261535E-01],
	[3.5040000000E+04, 3.1474093039E+01, 5.2284772031E+00, 1.3131197588E+01, 3.3423917035E+00, 9.5563294327E-01],
	[3.5045000000E+04, 3.1481777690E+01, 5.2285000202E+00, 1.3137278670E+01, 3.3428815504E+00, 9.5565326052E-01],
	[3.5050000000E+04, 3.1489463121E+01, 5.2285228342E+00, 1.3143361697E+01, 3.3433712673E+00, 9.5567356711E-01],
	[3.5055000000E+04, 3.1497149331E+01, 5.2285456450E+00, 1.3149446669E+01, 3.3438608542E+00, 9.5569386303E-01],
	[3.5060000000E+04, 3.1504836321E+01, 5.2285684526E+00, 1.3155533588E+01, 3.3443503111E+00, 9.5571414829E-01],
	[3.5065000000E+04, 3.1512524090E+01, 5.2285912571E+00, 1.3161622453E+01, 3.3448396380E+00, 9.5573442291E-01],
	[3.5070000000E+04, 3.1520212638E+01, 5.2286140585E+00, 1.3167713265E+01, 3.3453288349E+00, 9.5575468688E-01],
	[3.5075000000E+04, 3.1527901966E+01, 5.2286368567E+00, 1.3173806023E+01, 3.3458179019E+00, 9.5577494021E-01],
	[3.5080000000E+04, 3.1535592073E+01, 5.2286596517E+00, 1.3179900730E+01, 3.3463068389E+00, 9.5579518290E-01],
	[3.5085000000E+04, 3.1543282960E+01, 5.2286824437E+00, 1.3185997384E+01, 3.3467956461E+00, 9.5581541497E-01],
	[3.5090000000E+04, 3.1550988714E+01, 5.2287069092E+00, 1.3192095986E+01, 3.3472851691E+00, 9.5583563642E-01],
	[3.5095000000E+04, 3.1558702106E+01, 5.2287321871E+00, 1.3198196536E+01, 3.3477749741E+00, 9.5585584725E-01],
	[3.5100000000E+04, 3.1566416285E+01, 5.2287574614E+00, 1.3204299035E+01, 3.3482646496E+00, 9.5587604748E-01],
	[3.5105000000E+04, 3.1574131251E+01, 5.2287827323E+00, 1.3210403483E+01, 3.3487541958E+00, 9.5589623710E-01],
	[3.5110000000E+04, 3.1581847003E+01, 5.2288079998E+00, 1.3216509881E+01, 3.3492436125E+00, 9.5591641612E-01],
	[3.5115000000E+04, 3.1589563541E+01, 5.2288332637E+00, 1.3222618228E+01, 3.3497329000E+00, 9.5593658455E-01],
	[3.5120000000E+04, 3.1597280865E+01, 5.2288585242E+00, 1.3228728526E+01, 3.3502220580E+00, 9.5595674239E-01],
	[3.5125000000E+04, 3.1604998976E+01, 5.2288837812E+00, 1.3234840774E+01, 3.3507110868E+00, 9.5597688966E-01],
	[3.5130000000E+04, 3.1612717873E+01, 5.2289090347E+00, 1.3240954973E+01, 3.3511999863E+00, 9.5599702634E-01],
	[3.5135000000E+04, 3.1620437557E+01, 5.2289342847E+00, 1.3247071123E+01, 3.3516887565E+00, 9.5601715246E-01],
	[3.5140000000E+04, 3.1628158026E+01, 5.2289595313E+00, 1.3253189225E+01, 3.3521773974E+00, 9.5603726802E-01],
	[3.5145000000E+04, 3.1635879282E+01, 5.2289847744E+00, 1.3259309278E+01, 3.3526659091E+00, 9.5605737302E-01],
	[3.5150000000E+04, 3.1643601324E+01, 5.2290100141E+00, 1.3265431284E+01, 3.3531542916E+00, 9.5607746747E-01],
	[3.5155000000E+04, 3.1651324152E+01, 5.2290352502E+00, 1.3271555242E+01, 3.3536425449E+00, 9.5609755138E-01],
	[3.5160000000E+04, 3.1659047766E+01, 5.2290604829E+00, 1.3277681153E+01, 3.3541306690E+00, 9.5611762475E-01],
	[3.5165000000E+04, 3.1666772167E+01, 5.2290857122E+00, 1.3283809017E+01, 3.3546186639E+00, 9.5613768758E-01],
	[3.5170000000E+04, 3.1674497353E+01, 5.2291109380E+00, 1.3289938835E+01, 3.3551065297E+00, 9.5615773988E-01],
	[3.5175000000E+04, 3.1682223325E+01, 5.2291361603E+00, 1.3296070607E+01, 3.3555942664E+00, 9.5617778167E-01],
	[3.5180000000E+04, 3.1689950083E+01, 5.2291613791E+00, 1.3302204333E+01, 3.3560818740E+00, 9.5619781294E-01],
	[3.5185000000E+04, 3.1697677627E+01, 5.2291865945E+00, 1.3308340013E+01, 3.3565693525E+00, 9.5621783369E-01],
	[3.5190000000E+04, 3.1705405957E+01, 5.2292118064E+00, 1.3314477649E+01, 3.3570567019E+00, 9.5623784395E-01],
	[3.5195000000E+04, 3.1713135073E+01, 5.2292370149E+00, 1.3320617240E+01, 3.3575439223E+00, 9.5625784370E-01],
	[3.5200000000E+04, 3.1720864975E+01, 5.2292622199E+00, 1.3326758786E+01, 3.3580310137E+00, 9.5627783297E-01],
	[3.5205000000E+04, 3.1728595662E+01, 5.2292874214E+00, 1.3332902289E+01, 3.3585179761E+00, 9.5629781174E-01],
	[3.5210000000E+04, 3.1736327136E+01, 5.2293126195E+00, 1.3339047747E+01, 3.3590048095E+00, 9.5631778004E-01],
	[3.5215000000E+04, 3.1744059395E+01, 5.2293378141E+00, 1.3345195163E+01, 3.3594915139E+00, 9.5633773786E-01],
	[3.5220000000E+04, 3.1751792439E+01, 5.2293630053E+00, 1.3351344535E+01, 3.3599780894E+00, 9.5635768521E-01],
	[3.5225000000E+04, 3.1759526270E+01, 5.2293881930E+00, 1.3357495865E+01, 3.3604645359E+00, 9.5637762210E-01],
	[3.5230000000E+04, 3.1767260886E+01, 5.2294133773E+00, 1.3363649152E+01, 3.3609508536E+00, 9.5639754853E-01],
	[3.5235000000E+04, 3.1774996287E+01, 5.2294385581E+00, 1.3369804398E+01, 3.3614370424E+00, 9.5641746451E-01],
	[3.5240000000E+04, 3.1782732475E+01, 5.2294637355E+00, 1.3375961602E+01, 3.3619231023E+00, 9.5643737005E-01],
	[3.5245000000E+04, 3.1790469447E+01, 5.2294889094E+00, 1.3382120764E+01, 3.3624090334E+00, 9.5645726514E-01],
	[3.5250000000E+04, 3.1798207206E+01, 5.2295140798E+00, 1.3388281886E+01, 3.3628948356E+00, 9.5647714980E-01],
	[3.5255000000E+04, 3.1805945749E+01, 5.2295392468E+00, 1.3394444967E+01, 3.3633805091E+00, 9.5649702403E-01],
	[3.5260000000E+04, 3.1813685079E+01, 5.2295644104E+00, 1.3400610008E+01, 3.3638660538E+00, 9.5651688784E-01],
	[3.5265000000E+04, 3.1821425193E+01, 5.2295895705E+00, 1.3406777009E+01, 3.3643514697E+00, 9.5653674124E-01],
	[3.5270000000E+04, 3.1829166093E+01, 5.2296147272E+00, 1.3412945970E+01, 3.3648367569E+00, 9.5655658422E-01],
	[3.5275000000E+04, 3.1836907779E+01, 5.2296398804E+00, 1.3419116892E+01, 3.3653219153E+00, 9.5657641680E-01],
	[3.5280000000E+04, 3.1844650249E+01, 5.2296650302E+00, 1.3425289776E+01, 3.3658069451E+00, 9.5659623898E-01],
	[3.5285000000E+04, 3.1852393505E+01, 5.2296901765E+00, 1.3431464621E+01, 3.3662918461E+00, 9.5661605076E-01],
	[3.5290000000E+04, 3.1860137547E+01, 5.2297153194E+00, 1.3437641427E+01, 3.3667766185E+00, 9.5663585216E-01],
	[3.5295000000E+04, 3.1867882373E+01, 5.2297404589E+00, 1.3443820196E+01, 3.3672612623E+00, 9.5665564317E-01],
	[3.5300000000E+04, 3.1875627985E+01, 5.2297655949E+00, 1.3450000927E+01, 3.3677457774E+00, 9.5667542382E-01],
	[3.5305000000E+04, 3.1883374382E+01, 5.2297907275E+00, 1.3456183621E+01, 3.3682301640E+00, 9.5669519409E-01],
	[3.5310000000E+04, 3.1891121564E+01, 5.2298158566E+00, 1.3462368279E+01, 3.3687144219E+00, 9.5671495399E-01],
	[3.5315000000E+04, 3.1898869531E+01, 5.2298409823E+00, 1.3468554899E+01, 3.3691985513E+00, 9.5673470354E-01],
	[3.5320000000E+04, 3.1906618283E+01, 5.2298661046E+00, 1.3474743484E+01, 3.3696825522E+00, 9.5675444274E-01],
	[3.5325000000E+04, 3.1914367820E+01, 5.2298912234E+00, 1.3480934033E+01, 3.3701664245E+00, 9.5677417158E-01],
	[3.5330000000E+04, 3.1922118142E+01, 5.2299163388E+00, 1.3487126547E+01, 3.3706501684E+00, 9.5679389009E-01],
	[3.5335000000E+04, 3.1929869249E+01, 5.2299414508E+00, 1.3493321025E+01, 3.3711337837E+00, 9.5681359826E-01],
	[3.5340000000E+04, 3.1937621142E+01, 5.2299665593E+00, 1.3499517469E+01, 3.3716172706E+00, 9.5683329611E-01],
	[3.5345000000E+04, 3.1945373819E+01, 5.2299916644E+00, 1.3505715878E+01, 3.3721006291E+00, 9.5685298363E-01],
	[3.5350000000E+04, 3.1953127280E+01, 5.2300167660E+00, 1.3511916253E+01, 3.3725838591E+00, 9.5687266083E-01],
	[3.5355000000E+04, 3.1960881527E+01, 5.2300418643E+00, 1.3518118595E+01, 3.3730669608E+00, 9.5689232772E-01],
	[3.5360000000E+04, 3.1968636559E+01, 5.2300669591E+00, 1.3524322903E+01, 3.3735499340E+00, 9.5691198430E-01],
	[3.5365000000E+04, 3.1976392375E+01, 5.2300920505E+00, 1.3530529178E+01, 3.3740327790E+00, 9.5693163059E-01],
	[3.5370000000E+04, 3.1984148976E+01, 5.2301171384E+00, 1.3536737421E+01, 3.3745154955E+00, 9.5695126657E-01],
	[3.5375000000E+04, 3.1991906362E+01, 5.2301422229E+00, 1.3542947631E+01, 3.3749980838E+00, 9.5697089227E-01],
	[3.5380000000E+04, 3.1999664533E+01, 5.2301673040E+00, 1.3549159809E+01, 3.3754805438E+00, 9.5699050769E-01],
	[3.5385000000E+04, 3.2007423488E+01, 5.2301923817E+00, 1.3555373955E+01, 3.3759628755E+00, 9.5701011283E-01],
	[3.5390000000E+04, 3.2015183228E+01, 5.2302174560E+00, 1.3561590071E+01, 3.3764450789E+00, 9.5702970770E-01],
	[3.5395000000E+04, 3.2022943752E+01, 5.2302425268E+00, 1.3567808155E+01, 3.3769271541E+00, 9.5704929230E-01],
	[3.5400000000E+04, 3.2030705061E+01, 5.2302675942E+00, 1.3574028208E+01, 3.3774091011E+00, 9.5706886664E-01],
	[3.5405000000E+04, 3.2038467155E+01, 5.2302926582E+00, 1.3580250232E+01, 3.3778909199E+00, 9.5708843073E-01],
	[3.5410000000E+04, 3.2046230033E+01, 5.2303177188E+00, 1.3586474225E+01, 3.3783726105E+00, 9.5710798457E-01],
	[3.5415000000E+04, 3.2053993695E+01, 5.2303427759E+00, 1.3592700189E+01, 3.3788541730E+00, 9.5712752817E-01],
	[3.5420000000E+04, 3.2061758142E+01, 5.2303678296E+00, 1.3598928124E+01, 3.3793356073E+00, 9.5714706153E-01],
	[3.5425000000E+04, 3.2069523374E+01, 5.2303928800E+00, 1.3605158029E+01, 3.3798169135E+00, 9.5716658466E-01],
	[3.5430000000E+04, 3.2077289389E+01, 5.2304179269E+00, 1.3611389906E+01, 3.3802980917E+00, 9.5718609757E-01],
	[3.5435000000E+04, 3.2085056189E+01, 5.2304429704E+00, 1.3617623755E+01, 3.3807791417E+00, 9.5720560025E-01],
	[3.5440000000E+04, 3.2092823774E+01, 5.2304680104E+00, 1.3623859577E+01, 3.3812600638E+00, 9.5722509272E-01],
	[3.5445000000E+04, 3.2100592143E+01, 5.2304930471E+00, 1.3630097370E+01, 3.3817408577E+00, 9.5724457499E-01],
	[3.5450000000E+04, 3.2108361295E+01, 5.2305180803E+00, 1.3636337137E+01, 3.3822215237E+00, 9.5726404705E-01],
	[3.5455000000E+04, 3.2116131233E+01, 5.2305431102E+00, 1.3642578876E+01, 3.3827020617E+00, 9.5728350891E-01],
	[3.5460000000E+04, 3.2123901954E+01, 5.2305681366E+00, 1.3648822589E+01, 3.3831824718E+00, 9.5730296059E-01],
	[3.5465000000E+04, 3.2131673459E+01, 5.2305931596E+00, 1.3655068276E+01, 3.3836627539E+00, 9.5732240208E-01],
	[3.5470000000E+04, 3.2139445749E+01, 5.2306181792E+00, 1.3661315937E+01, 3.3841429080E+00, 9.5734183339E-01],
	[3.5475000000E+04, 3.2147218823E+01, 5.2306431954E+00, 1.3667565573E+01, 3.3846229343E+00, 9.5736125452E-01],
	[3.5480000000E+04, 3.2154992681E+01, 5.2306682082E+00, 1.3673817184E+01, 3.3851028327E+00, 9.5738066549E-01],
	[3.5485000000E+04, 3.2162767322E+01, 5.2306932176E+00, 1.3680070770E+01, 3.3855826032E+00, 9.5740006630E-01],
	[3.5490000000E+04, 3.2170542748E+01, 5.2307182236E+00, 1.3686326331E+01, 3.3860622458E+00, 9.5741945695E-01],
	[3.5495000000E+04, 3.2178318958E+01, 5.2307432262E+00, 1.3692583868E+01, 3.3865417607E+00, 9.5743883745E-01],
	[3.5500000000E+04, 3.2186095952E+01, 5.2307682254E+00, 1.3698843382E+01, 3.3870211477E+00, 9.5745820781E-01],
	[3.5505000000E+04, 3.2193873729E+01, 5.2307932212E+00, 1.3705104872E+01, 3.3875004070E+00, 9.5747756803E-01],
	[3.5510000000E+04, 3.2201652291E+01, 5.2308182136E+00, 1.3711368340E+01, 3.3879795385E+00, 9.5749691811E-01],
	[3.5515000000E+04, 3.2209431636E+01, 5.2308432026E+00, 1.3717633784E+01, 3.3884585423E+00, 9.5751625807E-01],
	[3.5520000000E+04, 3.2217211765E+01, 5.2308681881E+00, 1.3723901206E+01, 3.3889374184E+00, 9.5753558791E-01],
	[3.5525000000E+04, 3.2224992678E+01, 5.2308931703E+00, 1.3730170606E+01, 3.3894161668E+00, 9.5755490763E-01],
	[3.5530000000E+04, 3.2232774375E+01, 5.2309181491E+00, 1.3736441985E+01, 3.3898947875E+00, 9.5757421723E-01],
	[3.5535000000E+04, 3.2240556855E+01, 5.2309431245E+00, 1.3742715342E+01, 3.3903732805E+00, 9.5759351674E-01],
	[3.5540000000E+04, 3.2248340120E+01, 5.2309680965E+00, 1.3748990678E+01, 3.3908516459E+00, 9.5761280615E-01],
	[3.5545000000E+04, 3.2256124167E+01, 5.2309930651E+00, 1.3755267994E+01, 3.3913298837E+00, 9.5763208546E-01],
	[3.5550000000E+04, 3.2263908999E+01, 5.2310180303E+00, 1.3761547289E+01, 3.3918079939E+00, 9.5765135469E-01],
	[3.5555000000E+04, 3.2271694614E+01, 5.2310429922E+00, 1.3767828564E+01, 3.3922859766E+00, 9.5767061383E-01],
	[3.5560000000E+04, 3.2279481012E+01, 5.2310679506E+00, 1.3774111820E+01, 3.3927638317E+00, 9.5768986290E-01],
	[3.5565000000E+04, 3.2287268194E+01, 5.2310929056E+00, 1.3780397057E+01, 3.3932415592E+00, 9.5770910190E-01],
	[3.5570000000E+04, 3.2295056160E+01, 5.2311178573E+00, 1.3786684274E+01, 3.3937191593E+00, 9.5772833083E-01],
	[3.5575000000E+04, 3.2302844909E+01, 5.2311428055E+00, 1.3792973473E+01, 3.3941966319E+00, 9.5774754971E-01],
	[3.5580000000E+04, 3.2310634441E+01, 5.2311677504E+00, 1.3799264654E+01, 3.3946739770E+00, 9.5776675853E-01],
	[3.5585000000E+04, 3.2318424757E+01, 5.2311926919E+00, 1.3805557817E+01, 3.3951511947E+00, 9.5778595731E-01],
	[3.5590000000E+04, 3.2326215856E+01, 5.2312176300E+00, 1.3811852963E+01, 3.3956282849E+00, 9.5780514604E-01],
	[3.5595000000E+04, 3.2334007739E+01, 5.2312425647E+00, 1.3818150091E+01, 3.3961052478E+00, 9.5782432474E-01],
	[3.5600000000E+04, 3.2341800405E+01, 5.2312674961E+00, 1.3824449202E+01, 3.3965820833E+00, 9.5784349341E-01],
	[3.5605000000E+04, 3.2349593854E+01, 5.2312924240E+00, 1.3830750297E+01, 3.3970587914E+00, 9.5786265205E-01],
	[3.5610000000E+04, 3.2357388086E+01, 5.2313173486E+00, 1.3837053376E+01, 3.3975353722E+00, 9.5788180068E-01],
	[3.5615000000E+04, 3.2365183102E+01, 5.2313422698E+00, 1.3843358439E+01, 3.3980118257E+00, 9.5790093929E-01],
	[3.5620000000E+04, 3.2372978901E+01, 5.2313671876E+00, 1.3849665486E+01, 3.3984881518E+00, 9.5792006789E-01],
	[3.5625000000E+04, 3.2380775483E+01, 5.2313921020E+00, 1.3855974519E+01, 3.3989643507E+00, 9.5793918650E-01],
	[3.5630000000E+04, 3.2388572848E+01, 5.2314170131E+00, 1.3862285536E+01, 3.3994404224E+00, 9.5795829510E-01],
	[3.5635000000E+04, 3.2396370996E+01, 5.2314419208E+00, 1.3868598539E+01, 3.3999163668E+00, 9.5797739372E-01],
	[3.5640000000E+04, 3.2404169927E+01, 5.2314668251E+00, 1.3874913529E+01, 3.4003921840E+00, 9.5799648236E-01],
	[3.5645000000E+04, 3.2411969641E+01, 5.2314917260E+00, 1.3881230504E+01, 3.4008678741E+00, 9.5801556101E-01],
	[3.5650000000E+04, 3.2419770139E+01, 5.2315166236E+00, 1.3887549466E+01, 3.4013434369E+00, 9.5803462969E-01],
	[3.5655000000E+04, 3.2427586005E+01, 5.2315432323E+00, 1.3893870415E+01, 3.4018197581E+00, 9.5805368840E-01],
	[3.5660000000E+04, 3.2435408813E+01, 5.2315705605E+00, 1.3900193351E+01, 3.4022963260E+00, 9.5807273716E-01],
	[3.5665000000E+04, 3.2443232411E+01, 5.2315978851E+00, 1.3906518275E+01, 3.4027727672E+00, 9.5809177595E-01],
	[3.5670000000E+04, 3.2451056798E+01, 5.2316252061E+00, 1.3912845187E+01, 3.4032490818E+00, 9.5811080480E-01],
	[3.5675000000E+04, 3.2458881976E+01, 5.2316525233E+00, 1.3919174087E+01, 3.4037252697E+00, 9.5812982370E-01],
	[3.5680000000E+04, 3.2466707944E+01, 5.2316798368E+00, 1.3925504976E+01, 3.4042013310E+00, 9.5814883267E-01],
	[3.5685000000E+04, 3.2474534701E+01, 5.2317071467E+00, 1.3931837853E+01, 3.4046772657E+00, 9.5816783172E-01],
	[3.5690000000E+04, 3.2482362249E+01, 5.2317344529E+00, 1.3938172721E+01, 3.4051530737E+00, 9.5818682086E-01],
	[3.5695000000E+04, 3.2490190586E+01, 5.2317617554E+00, 1.3944509578E+01, 3.4056287552E+00, 9.5820580009E-01],
	[3.5700000000E+04, 3.2498019713E+01, 5.2317890542E+00, 1.3950848425E+01, 3.4061043102E+00, 9.5822476941E-01],
	[3.5705000000E+04, 3.2505849629E+01, 5.2318163493E+00, 1.3957189262E+01, 3.4065797387E+00, 9.5824372884E-01],
	[3.5710000000E+04, 3.2513680336E+01, 5.2318436408E+00, 1.3963532090E+01, 3.4070550406E+00, 9.5826267837E-01],
	[3.5715000000E+04, 3.2521511832E+01, 5.2318709285E+00, 1.3969876909E+01, 3.4075302161E+00, 9.5828161802E-01],
	[3.5720000000E+04, 3.2529344117E+01, 5.2318982126E+00, 1.3976223720E+01, 3.4080052651E+00, 9.5830054778E-01],
	[3.5725000000E+04, 3.2537177193E+01, 5.2319254930E+00, 1.3982572522E+01, 3.4084801876E+00, 9.5831946766E-01],
	[3.5730000000E+04, 3.2545011057E+01, 5.2319527698E+00, 1.3988923317E+01, 3.4089549838E+00, 9.5833837767E-01],
	[3.5735000000E+04, 3.2552845712E+01, 5.2319800428E+00, 1.3995276104E+01, 3.4094296535E+00, 9.5835727781E-01],
	[3.5740000000E+04, 3.2560681156E+01, 5.2320073122E+00, 1.4001630884E+01, 3.4099041969E+00, 9.5837616809E-01],
	[3.5745000000E+04, 3.2568517389E+01, 5.2320345780E+00, 1.4007987657E+01, 3.4103786139E+00, 9.5839504851E-01],
	[3.5750000000E+04, 3.2576354412E+01, 5.2320618400E+00, 1.4014346423E+01, 3.4108529046E+00, 9.5841391908E-01],
	[3.5755000000E+04, 3.2584192225E+01, 5.2320890984E+00, 1.4020707184E+01, 3.4113270690E+00, 9.5843277980E-01],
	[3.5760000000E+04, 3.2592030826E+01, 5.2321163531E+00, 1.4027069938E+01, 3.4118011071E+00, 9.5845163067E-01],
	[3.5765000000E+04, 3.2599870217E+01, 5.2321436041E+00, 1.4033434687E+01, 3.4122750189E+00, 9.5847047171E-01],
	[3.5770000000E+04, 3.2607710398E+01, 5.2321708515E+00, 1.4039801431E+01, 3.4127488045E+00, 9.5848930291E-01],
	[3.5775000000E+04, 3.2615551368E+01, 5.2321980952E+00, 1.4046170170E+01, 3.4132224638E+00, 9.5850812429E-01],
	[3.5780000000E+04, 3.2623393127E+01, 5.2322253353E+00, 1.4052540905E+01, 3.4136959970E+00, 9.5852693584E-01],
	[3.5785000000E+04, 3.2631235675E+01, 5.2322525716E+00, 1.4058913636E+01, 3.4141694039E+00, 9.5854573757E-01],
	[3.5790000000E+04, 3.2639079012E+01, 5.2322798044E+00, 1.4065288363E+01, 3.4146426848E+00, 9.5856452949E-01],
	[3.5795000000E+04, 3.2646923139E+01, 5.2323070334E+00, 1.4071665086E+01, 3.4151158394E+00, 9.5858331160E-01],
	[3.5800000000E+04, 3.2654768055E+01, 5.2323342588E+00, 1.4078043807E+01, 3.4155888680E+00, 9.5860208391E-01],
	[3.5805000000E+04, 3.2662613760E+01, 5.2323614805E+00, 1.4084424525E+01, 3.4160617704E+00, 9.5862084642E-01],
	[3.5810000000E+04, 3.2670460254E+01, 5.2323886986E+00, 1.4090807240E+01, 3.4165345468E+00, 9.5863959914E-01],
	[3.5815000000E+04, 3.2678307537E+01, 5.2324159130E+00, 1.4097191953E+01, 3.4170071972E+00, 9.5865834207E-01],
	[3.5820000000E+04, 3.2686155609E+01, 5.2324431238E+00, 1.4103578665E+01, 3.4174797215E+00, 9.5867707521E-01],
	[3.5825000000E+04, 3.2694004470E+01, 5.2324703308E+00, 1.4109967376E+01, 3.4179521198E+00, 9.5869579858E-01],
	[3.5830000000E+04, 3.2701854121E+01, 5.2324975343E+00, 1.4116358085E+01, 3.4184243921E+00, 9.5871451217E-01],
	[3.5835000000E+04, 3.2709704560E+01, 5.2325247341E+00, 1.4122750794E+01, 3.4188965384E+00, 9.5873321600E-01],
	[3.5840000000E+04, 3.2717555788E+01, 5.2325519302E+00, 1.4129145502E+01, 3.4193685588E+00, 9.5875191006E-01],
	[3.5845000000E+04, 3.2725407804E+01, 5.2325791227E+00, 1.4135542211E+01, 3.4198404533E+00, 9.5877059436E-01],
	[3.5850000000E+04, 3.2733260610E+01, 5.2326063115E+00, 1.4141940920E+01, 3.4203122219E+00, 9.5878926891E-01],
	[3.5855000000E+04, 3.2741114205E+01, 5.2326334967E+00, 1.4148341630E+01, 3.4207838646E+00, 9.5880793372E-01],
	[3.5860000000E+04, 3.2748968588E+01, 5.2326606782E+00, 1.4154744341E+01, 3.4212553814E+00, 9.5882658878E-01],
	[3.5865000000E+04, 3.2756823760E+01, 5.2326878561E+00, 1.4161149053E+01, 3.4217267725E+00, 9.5884523410E-01],
	[3.5870000000E+04, 3.2764679721E+01, 5.2327150303E+00, 1.4167555767E+01, 3.4221980377E+00, 9.5886386968E-01],
	[3.5875000000E+04, 3.2772536470E+01, 5.2327422009E+00, 1.4173964483E+01, 3.4226691771E+00, 9.5888249554E-01],
	[3.5880000000E+04, 3.2780394008E+01, 5.2327693679E+00, 1.4180375202E+01, 3.4231401907E+00, 9.5890111168E-01],
	[3.5885000000E+04, 3.2788252335E+01, 5.2327965312E+00, 1.4186787923E+01, 3.4236110786E+00, 9.5891971809E-01],
	[3.5890000000E+04, 3.2796111450E+01, 5.2328236908E+00, 1.4193202648E+01, 3.4240818408E+00, 9.5893831480E-01],
	[3.5895000000E+04, 3.2803971354E+01, 5.2328508468E+00, 1.4199619376E+01, 3.4245524772E+00, 9.5895690179E-01],
	[3.5900000000E+04, 3.2811832047E+01, 5.2328779992E+00, 1.4206038108E+01, 3.4250229880E+00, 9.5897547909E-01],
	[3.5905000000E+04, 3.2819693527E+01, 5.2329051479E+00, 1.4212458844E+01, 3.4254933731E+00, 9.5899404668E-01],
	[3.5910000000E+04, 3.2827555797E+01, 5.2329322930E+00, 1.4218881585E+01, 3.4259636326E+00, 9.5901260458E-01],
	[3.5915000000E+04, 3.2835418855E+01, 5.2329594345E+00, 1.4225306331E+01, 3.4264337665E+00, 9.5903115279E-01],
	[3.5920000000E+04, 3.2843282701E+01, 5.2329865723E+00, 1.4231733082E+01, 3.4269037748E+00, 9.5904969132E-01],
	[3.5925000000E+04, 3.2851147336E+01, 5.2330137064E+00, 1.4238161838E+01, 3.4273736575E+00, 9.5906822017E-01],
	[3.5930000000E+04, 3.2859012759E+01, 5.2330408370E+00, 1.4244592600E+01, 3.4278434146E+00, 9.5908673935E-01],
	[3.5935000000E+04, 3.2866878970E+01, 5.2330679639E+00, 1.4251025369E+01, 3.4283130462E+00, 9.5910524886E-01],
	[3.5940000000E+04, 3.2874745970E+01, 5.2330950872E+00, 1.4257460144E+01, 3.4287825524E+00, 9.5912374871E-01],
	[3.5945000000E+04, 3.2882613758E+01, 5.2331222068E+00, 1.4263896927E+01, 3.4292519330E+00, 9.5914223890E-01],
	[3.5950000000E+04, 3.2890482334E+01, 5.2331493228E+00, 1.4270335716E+01, 3.4297211882E+00, 9.5916071943E-01],
	[3.5955000000E+04, 3.2898351698E+01, 5.2331764352E+00, 1.4276776513E+01, 3.4301903179E+00, 9.5917919032E-01],
	[3.5960000000E+04, 3.2906221851E+01, 5.2332035439E+00, 1.4283219319E+01, 3.4306593222E+00, 9.5919765156E-01],
	[3.5965000000E+04, 3.2914092791E+01, 5.2332306491E+00, 1.4289664132E+01, 3.4311282011E+00, 9.5921610316E-01],
	[3.5970000000E+04, 3.2921964520E+01, 5.2332577505E+00, 1.4296110954E+01, 3.4315969547E+00, 9.5923454513E-01],
	[3.5975000000E+04, 3.2929837037E+01, 5.2332848484E+00, 1.4302559786E+01, 3.4320655829E+00, 9.5925297748E-01],
	[3.5980000000E+04, 3.2937710342E+01, 5.2333119426E+00, 1.4309010626E+01, 3.4325340857E+00, 9.5927140020E-01],
	[3.5985000000E+04, 3.2945584435E+01, 5.2333390333E+00, 1.4315463477E+01, 3.4330024633E+00, 9.5928981330E-01],
	[3.5990000000E+04, 3.2953459315E+01, 5.2333661203E+00, 1.4321918337E+01, 3.4334707155E+00, 9.5930821679E-01],
	[3.5995000000E+04, 3.2961334984E+01, 5.2333932036E+00, 1.4328375208E+01, 3.4339388425E+00, 9.5932661067E-01],
	[3.6000000000E+04, 3.2969211441E+01, 5.2334202834E+00, 1.4334834090E+01, 3.4344068443E+00, 9.5934499494E-01],
	[3.6005000000E+04, 3.2977088686E+01, 5.2334473595E+00, 1.4341294982E+01, 3.4348747209E+00, 9.5936336962E-01],
	[3.6010000000E+04, 3.2984966718E+01, 5.2334744320E+00, 1.4347757886E+01, 3.4353424722E+00, 9.5938173470E-01],
	[3.6015000000E+04, 3.2992845538E+01, 5.2335015009E+00, 1.4354222802E+01, 3.4358100984E+00, 9.5940009020E-01],
	[3.6020000000E+04, 3.3000725147E+01, 5.2335285662E+00, 1.4360689731E+01, 3.4362775994E+00, 9.5941843611E-01],
	[3.6025000000E+04, 3.3008605542E+01, 5.2335556278E+00, 1.4367158671E+01, 3.4367449753E+00, 9.5943677245E-01],
	[3.6030000000E+04, 3.3016486726E+01, 5.2335826858E+00, 1.4373629625E+01, 3.4372122261E+00, 9.5945509921E-01],
	[3.6035000000E+04, 3.3024368698E+01, 5.2336097403E+00, 1.4380102591E+01, 3.4376793518E+00, 9.5947341640E-01],
	[3.6040000000E+04, 3.3032251457E+01, 5.2336367911E+00, 1.4386577571E+01, 3.4381463524E+00, 9.5949172403E-01],
	[3.6045000000E+04, 3.3040135003E+01, 5.2336638383E+00, 1.4393054565E+01, 3.4386132280E+00, 9.5951002210E-01],
	[3.6050000000E+04, 3.3048019338E+01, 5.2336908818E+00, 1.4399533574E+01, 3.4390799786E+00, 9.5952831062E-01],
	[3.6055000000E+04, 3.3055904459E+01, 5.2337179218E+00, 1.4406014596E+01, 3.4395466042E+00, 9.5954658959E-01],
	[3.6060000000E+04, 3.3063790369E+01, 5.2337449582E+00, 1.4412497634E+01, 3.4400131048E+00, 9.5956485902E-01],
	[3.6065000000E+04, 3.3071677066E+01, 5.2337719909E+00, 1.4418982687E+01, 3.4404794804E+00, 9.5958311890E-01],
	[3.6070000000E+04, 3.3079564550E+01, 5.2337990201E+00, 1.4425469756E+01, 3.4409457311E+00, 9.5960136926E-01],
	[3.6075000000E+04, 3.3087452822E+01, 5.2338260456E+00, 1.4431958840E+01, 3.4414118569E+00, 9.5961961008E-01],
	[3.6080000000E+04, 3.3095341882E+01, 5.2338530676E+00, 1.4438449941E+01, 3.4418778579E+00, 9.5963784139E-01],
	[3.6085000000E+04, 3.3103231728E+01, 5.2338800859E+00, 1.4444943058E+01, 3.4423437339E+00, 9.5965606317E-01],
	[3.6090000000E+04, 3.3111122363E+01, 5.2339071006E+00, 1.4451438193E+01, 3.4428094852E+00, 9.5967427544E-01],
	[3.6095000000E+04, 3.3119013784E+01, 5.2339341117E+00, 1.4457935344E+01, 3.4432751116E+00, 9.5969247820E-01],
	[3.6100000000E+04, 3.3126905993E+01, 5.2339611192E+00, 1.4464434514E+01, 3.4437406132E+00, 9.5971067146E-01],
	[3.6105000000E+04, 3.3134798989E+01, 5.2339881232E+00, 1.4470935701E+01, 3.4442059901E+00, 9.5972885522E-01],
	[3.6110000000E+04, 3.3142692772E+01, 5.2340151235E+00, 1.4477438907E+01, 3.4446712421E+00, 9.5974702948E-01],
	[3.6115000000E+04, 3.3150587343E+01, 5.2340421202E+00, 1.4483944132E+01, 3.4451363695E+00, 9.5976519426E-01],
	[3.6120000000E+04, 3.3158482701E+01, 5.2340691133E+00, 1.4490451375E+01, 3.4456013722E+00, 9.5978334956E-01],
	[3.6125000000E+04, 3.3166378846E+01, 5.2340961028E+00, 1.4496960638E+01, 3.4460662502E+00, 9.5980149537E-01],
	[3.6130000000E+04, 3.3174275778E+01, 5.2341230888E+00, 1.4503471921E+01, 3.4465310035E+00, 9.5981963171E-01],
	[3.6135000000E+04, 3.3182173497E+01, 5.2341500711E+00, 1.4509985224E+01, 3.4469956322E+00, 9.5983775859E-01],
	[3.6140000000E+04, 3.3190072003E+01, 5.2341770498E+00, 1.4516500547E+01, 3.4474601362E+00, 9.5985587600E-01],
	[3.6145000000E+04, 3.3197971296E+01, 5.2342040250E+00, 1.4523017891E+01, 3.4479245157E+00, 9.5987398395E-01],
	[3.6150000000E+04, 3.3205871376E+01, 5.2342309965E+00, 1.4529537256E+01, 3.4483887706E+00, 9.5989208244E-01],
	[3.6155000000E+04, 3.3213772244E+01, 5.2342579645E+00, 1.4536058643E+01, 3.4488529010E+00, 9.5991017149E-01],
	[3.6160000000E+04, 3.3221673898E+01, 5.2342849289E+00, 1.4542582051E+01, 3.4493169068E+00, 9.5992825110E-01],
	[3.6165000000E+04, 3.3229576339E+01, 5.2343118896E+00, 1.4549107482E+01, 3.4497807881E+00, 9.5994632126E-01],
	[3.6170000000E+04, 3.3237479567E+01, 5.2343388468E+00, 1.4555634935E+01, 3.4502445450E+00, 9.5996438199E-01],
	[3.6175000000E+04, 3.3245383582E+01, 5.2343658004E+00, 1.4562164411E+01, 3.4507081774E+00, 9.5998243330E-01],
	[3.6180000000E+04, 3.3253288383E+01, 5.2343927505E+00, 1.4568695910E+01, 3.4511716853E+00, 9.6000047518E-01],
	[3.6185000000E+04, 3.3261193972E+01, 5.2344196969E+00, 1.4575229433E+01, 3.4516350689E+00, 9.6001850764E-01],
	[3.6190000000E+04, 3.3269100347E+01, 5.2344466397E+00, 1.4581764979E+01, 3.4520983280E+00, 9.6003653069E-01],
	[3.6195000000E+04, 3.3277007509E+01, 5.2344735790E+00, 1.4588302550E+01, 3.4525614628E+00, 9.6005454432E-01],
	[3.6200000000E+04, 3.3284915458E+01, 5.2345005147E+00, 1.4594842146E+01, 3.4530244733E+00, 9.6007254856E-01],
	[3.6205000000E+04, 3.3292824193E+01, 5.2345274468E+00, 1.4601383766E+01, 3.4534873594E+00, 9.6009054339E-01],
	[3.6210000000E+04, 3.3300733715E+01, 5.2345543753E+00, 1.4607927412E+01, 3.4539501213E+00, 9.6010852884E-01],
	[3.6215000000E+04, 3.3308644024E+01, 5.2345813003E+00, 1.4614473083E+01, 3.4544127588E+00, 9.6012650489E-01],
	[3.6220000000E+04, 3.3316555119E+01, 5.2346082216E+00, 1.4621020780E+01, 3.4548752721E+00, 9.6014447156E-01],
	[3.6225000000E+04, 3.3324467001E+01, 5.2346351394E+00, 1.4627570504E+01, 3.4553376612E+00, 9.6016242885E-01],
	[3.6230000000E+04, 3.3332398464E+01, 5.2346642355E+00, 1.4634122254E+01, 3.4558010790E+00, 9.6018037676E-01],
	[3.6235000000E+04, 3.3340332460E+01, 5.2346935297E+00, 1.4640676032E+01, 3.4562644798E+00, 9.6019831531E-01],
	[3.6240000000E+04, 3.3348267250E+01, 5.2347228201E+00, 1.4647231836E+01, 3.4567277568E+00, 9.6021624449E-01],
	[3.6245000000E+04, 3.3356202834E+01, 5.2347521066E+00, 1.4653789668E+01, 3.4571909100E+00, 9.6023416432E-01],
	[3.6250000000E+04, 3.3364139210E+01, 5.2347813892E+00, 1.4660349529E+01, 3.4576539395E+00, 9.6025207478E-01],
	[3.6255000000E+04, 3.3372076380E+01, 5.2348106679E+00, 1.4666911418E+01, 3.4581168453E+00, 9.6026997590E-01],
	[3.6260000000E+04, 3.3380014343E+01, 5.2348399428E+00, 1.4673475335E+01, 3.4585796274E+00, 9.6028786768E-01],
	[3.6265000000E+04, 3.3387953100E+01, 5.2348692138E+00, 1.4680041282E+01, 3.4590422859E+00, 9.6030575012E-01],
	[3.6270000000E+04, 3.3395892650E+01, 5.2348984809E+00, 1.4686609258E+01, 3.4595048207E+00, 9.6032362322E-01],
	[3.6275000000E+04, 3.3403832993E+01, 5.2349277442E+00, 1.4693179264E+01, 3.4599672319E+00, 9.6034148699E-01],
	[3.6280000000E+04, 3.3411774129E+01, 5.2349570036E+00, 1.4699751299E+01, 3.4604295195E+00, 9.6035934144E-01],
	[3.6285000000E+04, 3.3419716058E+01, 5.2349862591E+00, 1.4706325366E+01, 3.4608916835E+00, 9.6037718657E-01],
	[3.6290000000E+04, 3.3427658780E+01, 5.2350155107E+00, 1.4712901463E+01, 3.4613537240E+00, 9.6039502239E-01],
	[3.6295000000E+04, 3.3435602295E+01, 5.2350447585E+00, 1.4719479591E+01, 3.4618156409E+00, 9.6041284889E-01],
	[3.6300000000E+04, 3.3443546604E+01, 5.2350740024E+00, 1.4726059751E+01, 3.4622774343E+00, 9.6043066609E-01],
	[3.6305000000E+04, 3.3451491705E+01, 5.2351032424E+00, 1.4732641943E+01, 3.4627391043E+00, 9.6044847399E-01],
	[3.6310000000E+04, 3.3459437599E+01, 5.2351324786E+00, 1.4739226167E+01, 3.4632006508E+00, 9.6046627260E-01],
	[3.6315000000E+04, 3.3467384286E+01, 5.2351617110E+00, 1.4745812424E+01, 3.4636620739E+00, 9.6048406192E-01],
	[3.6320000000E+04, 3.3475331767E+01, 5.2351909394E+00, 1.4752400713E+01, 3.4641233735E+00, 9.6050184195E-01],
	[3.6325000000E+04, 3.3483280040E+01, 5.2352201640E+00, 1.4758991035E+01, 3.4645845498E+00, 9.6051961270E-01],
	[3.6330000000E+04, 3.3491229105E+01, 5.2352493848E+00, 1.4765583392E+01, 3.4650456026E+00, 9.6053737418E-01],
	[3.6335000000E+04, 3.3499178964E+01, 5.2352786016E+00, 1.4772177782E+01, 3.4655065322E+00, 9.6055512639E-01],
	[3.6340000000E+04, 3.3507129616E+01, 5.2353078147E+00, 1.4778774206E+01, 3.4659673384E+00, 9.6057286934E-01],
	[3.6345000000E+04, 3.3515081060E+01, 5.2353370238E+00, 1.4785372665E+01, 3.4664280213E+00, 9.6059060302E-01],
	[3.6350000000E+04, 3.3523033297E+01, 5.2353662292E+00, 1.4791973159E+01, 3.4668885810E+00, 9.6060832745E-01],
	[3.6355000000E+04, 3.3530986326E+01, 5.2353954306E+00, 1.4798575689E+01, 3.4673490174E+00, 9.6062604263E-01],
	[3.6360000000E+04, 3.3538940149E+01, 5.2354246282E+00, 1.4805180254E+01, 3.4678093305E+00, 9.6064374856E-01],
	[3.6365000000E+04, 3.3546894764E+01, 5.2354538220E+00, 1.4811786855E+01, 3.4682695205E+00, 9.6066144526E-01],
	[3.6370000000E+04, 3.3554850171E+01, 5.2354830119E+00, 1.4818395492E+01, 3.4687295872E+00, 9.6067913272E-01],
	[3.6375000000E+04, 3.3562806371E+01, 5.2355121979E+00, 1.4825006166E+01, 3.4691895308E+00, 9.6069681095E-01],
	[3.6380000000E+04, 3.3570763364E+01, 5.2355413801E+00, 1.4831618877E+01, 3.4696493513E+00, 9.6071447995E-01],
	[3.6385000000E+04, 3.3578721149E+01, 5.2355705585E+00, 1.4838233626E+01, 3.4701090486E+00, 9.6073213973E-01],
	[3.6390000000E+04, 3.3586679727E+01, 5.2355997330E+00, 1.4844850412E+01, 3.4705686229E+00, 9.6074979030E-01],
	[3.6395000000E+04, 3.3594639097E+01, 5.2356289037E+00, 1.4851469236E+01, 3.4710280741E+00, 9.6076743166E-01],
	[3.6400000000E+04, 3.3602599260E+01, 5.2356580705E+00, 1.4858090099E+01, 3.4714874022E+00, 9.6078506381E-01],
	[3.6405000000E+04, 3.3610560215E+01, 5.2356872335E+00, 1.4864713000E+01, 3.4719466073E+00, 9.6080268677E-01],
	[3.6410000000E+04, 3.3618521962E+01, 5.2357163926E+00, 1.4871337941E+01, 3.4724056894E+00, 9.6082030052E-01],
	[3.6415000000E+04, 3.3626484502E+01, 5.2357455479E+00, 1.4877964921E+01, 3.4728646486E+00, 9.6083790509E-01],
	[3.6420000000E+04, 3.3634447834E+01, 5.2357746994E+00, 1.4884593941E+01, 3.4733234847E+00, 9.6085550047E-01],
	[3.6425000000E+04, 3.3642411958E+01, 5.2358038470E+00, 1.4891225001E+01, 3.4737821980E+00, 9.6087308667E-01],
	[3.6430000000E+04, 3.3650376874E+01, 5.2358329907E+00, 1.4897858102E+01, 3.4742407883E+00, 9.6089066369E-01],
	[3.6435000000E+04, 3.3658342583E+01, 5.2358621307E+00, 1.4904493243E+01, 3.4746992558E+00, 9.6090823155E-01],
	[3.6440000000E+04, 3.3666309084E+01, 5.2358912668E+00, 1.4911130426E+01, 3.4751576004E+00, 9.6092579024E-01],
	[3.6445000000E+04, 3.3674276377E+01, 5.2359203990E+00, 1.4917769650E+01, 3.4756158221E+00, 9.6094333976E-01],
	[3.6450000000E+04, 3.3682244462E+01, 5.2359495275E+00, 1.4924410916E+01, 3.4760739210E+00, 9.6096088014E-01],
	[3.6455000000E+04, 3.3690213340E+01, 5.2359786521E+00, 1.4931054224E+01, 3.4765318972E+00, 9.6097841136E-01],
	[3.6460000000E+04, 3.3698183009E+01, 5.2360077728E+00, 1.4937699575E+01, 3.4769897505E+00, 9.6099593343E-01],
	[3.6465000000E+04, 3.3706153470E+01, 5.2360368898E+00, 1.4944346969E+01, 3.4774474811E+00, 9.6101344636E-01],
	[3.6470000000E+04, 3.3714124724E+01, 5.2360660029E+00, 1.4950996406E+01, 3.4779050890E+00, 9.6103095016E-01],
	[3.6475000000E+04, 3.3722096769E+01, 5.2360951122E+00, 1.4957647887E+01, 3.4783625742E+00, 9.6104844483E-01],
	[3.6480000000E+04, 3.3730069607E+01, 5.2361242176E+00, 1.4964301412E+01, 3.4788199367E+00, 9.6106593037E-01],
	[3.6485000000E+04, 3.3738043236E+01, 5.2361533192E+00, 1.4970956981E+01, 3.4792771766E+00, 9.6108340678E-01],
	[3.6490000000E+04, 3.3746017657E+01, 5.2361824170E+00, 1.4977614595E+01, 3.4797342938E+00, 9.6110087409E-01],
	[3.6495000000E+04, 3.3753992870E+01, 5.2362115110E+00, 1.4984274254E+01, 3.4801912884E+00, 9.6111833228E-01],
	[3.6500000000E+04, 3.3761968875E+01, 5.2362406011E+00, 1.4990935958E+01, 3.4806481605E+00, 9.6113578136E-01],
	[3.6505000000E+04, 3.3769945672E+01, 5.2362696874E+00, 1.4997599708E+01, 3.4811049099E+00, 9.6115322134E-01],
	[3.6510000000E+04, 3.3777923260E+01, 5.2362987699E+00, 1.5004265503E+01, 3.4815615368E+00, 9.6117065223E-01],
	[3.6515000000E+04, 3.3785901640E+01, 5.2363278486E+00, 1.5010933346E+01, 3.4820180413E+00, 9.6118807402E-01],
	[3.6520000000E+04, 3.3793880812E+01, 5.2363569235E+00, 1.5017603235E+01, 3.4824744232E+00, 9.6120548673E-01],
	[3.6525000000E+04, 3.3801860775E+01, 5.2363859945E+00, 1.5024275171E+01, 3.4829306826E+00, 9.6122289035E-01],
	[3.6530000000E+04, 3.3809841531E+01, 5.2364150617E+00, 1.5030949155E+01, 3.4833868196E+00, 9.6124028490E-01],
	[3.6535000000E+04, 3.3817823077E+01, 5.2364441251E+00, 1.5037625186E+01, 3.4838428342E+00, 9.6125767038E-01],
	[3.6540000000E+04, 3.3825805416E+01, 5.2364731847E+00, 1.5044303265E+01, 3.4842987264E+00, 9.6127504678E-01],
	[3.6545000000E+04, 3.3833788546E+01, 5.2365022405E+00, 1.5050983393E+01, 3.4847544962E+00, 9.6129241413E-01],
	[3.6550000000E+04, 3.3841772467E+01, 5.2365312924E+00, 1.5057665570E+01, 3.4852101437E+00, 9.6130977242E-01],
	[3.6555000000E+04, 3.3849757180E+01, 5.2365603406E+00, 1.5064349796E+01, 3.4856656688E+00, 9.6132712166E-01],
	[3.6560000000E+04, 3.3857742685E+01, 5.2365893849E+00, 1.5071036072E+01, 3.4861210716E+00, 9.6134446185E-01],
	[3.6565000000E+04, 3.3865728981E+01, 5.2366184254E+00, 1.5077724397E+01, 3.4865763521E+00, 9.6136179299E-01],
	[3.6570000000E+04, 3.3873716068E+01, 5.2366474622E+00, 1.5084414773E+01, 3.4870315104E+00, 9.6137911510E-01],
	[3.6575000000E+04, 3.3881703947E+01, 5.2366764951E+00, 1.5091107199E+01, 3.4874865465E+00, 9.6139642818E-01],
	[3.6580000000E+04, 3.3889692617E+01, 5.2367055242E+00, 1.5097801676E+01, 3.4879414603E+00, 9.6141373223E-01],
	[3.6585000000E+04, 3.3897682078E+01, 5.2367345494E+00, 1.5104498204E+01, 3.4883962519E+00, 9.6143102725E-01],
	[3.6590000000E+04, 3.3905672331E+01, 5.2367635709E+00, 1.5111196784E+01, 3.4888509214E+00, 9.6144831326E-01],
	[3.6595000000E+04, 3.3913663375E+01, 5.2367925886E+00, 1.5117897416E+01, 3.4893054687E+00, 9.6146559026E-01],
	[3.6600000000E+04, 3.3921655210E+01, 5.2368216025E+00, 1.5124600100E+01, 3.4897598939E+00, 9.6148285824E-01],
	[3.6605000000E+04, 3.3929647836E+01, 5.2368506126E+00, 1.5131304837E+01, 3.4902141971E+00, 9.6150011723E-01],
	[3.6610000000E+04, 3.3937641254E+01, 5.2368796188E+00, 1.5138011626E+01, 3.4906683781E+00, 9.6151736721E-01],
	[3.6615000000E+04, 3.3945635462E+01, 5.2369086213E+00, 1.5144720469E+01, 3.4911224371E+00, 9.6153460820E-01],
	[3.6620000000E+04, 3.3953630462E+01, 5.2369376200E+00, 1.5151431366E+01, 3.4915763741E+00, 9.6155184021E-01],
	[3.6625000000E+04, 3.3961626253E+01, 5.2369666148E+00, 1.5158144317E+01, 3.4920301890E+00, 9.6156906322E-01],
	[3.6630000000E+04, 3.3969622835E+01, 5.2369956059E+00, 1.5164859322E+01, 3.4924838820E+00, 9.6158627727E-01],
	[3.6635000000E+04, 3.3977620208E+01, 5.2370245932E+00, 1.5171576382E+01, 3.4929374531E+00, 9.6160348233E-01],
	[3.6640000000E+04, 3.3985618372E+01, 5.2370535767E+00, 1.5178295497E+01, 3.4933909022E+00, 9.6162067843E-01],
	[3.6645000000E+04, 3.3993617327E+01, 5.2370825564E+00, 1.5185016667E+01, 3.4938442294E+00, 9.6163786557E-01],
	[3.6650000000E+04, 3.4001617073E+01, 5.2371115323E+00, 1.5191739894E+01, 3.4942974347E+00, 9.6165504374E-01],
	[3.6655000000E+04, 3.4009617609E+01, 5.2371405044E+00, 1.5198465176E+01, 3.4947505182E+00, 9.6167221296E-01],
	[3.6660000000E+04, 3.4017618937E+01, 5.2371694727E+00, 1.5205192515E+01, 3.4952034798E+00, 9.6168937323E-01],
	[3.6665000000E+04, 3.4025621055E+01, 5.2371984372E+00, 1.5211921910E+01, 3.4956563196E+00, 9.6170652456E-01],
	[3.6670000000E+04, 3.4033623965E+01, 5.2372273979E+00, 1.5218653363E+01, 3.4961090376E+00, 9.6172366695E-01],
	[3.6675000000E+04, 3.4041627665E+01, 5.2372563549E+00, 1.5225386873E+01, 3.4965616339E+00, 9.6174080040E-01],
	[3.6680000000E+04, 3.4049632156E+01, 5.2372853080E+00, 1.5232122441E+01, 3.4970141084E+00, 9.6175792493E-01],
	[3.6685000000E+04, 3.4057637437E+01, 5.2373142574E+00, 1.5238860067E+01, 3.4974664612E+00, 9.6177504052E-01],
	[3.6690000000E+04, 3.4065643509E+01, 5.2373432030E+00, 1.5245599752E+01, 3.4979186923E+00, 9.6179214720E-01],
	[3.6695000000E+04, 3.4073650372E+01, 5.2373721448E+00, 1.5252341495E+01, 3.4983708017E+00, 9.6180924497E-01],
	[3.6700000000E+04, 3.4081658026E+01, 5.2374010828E+00, 1.5259085298E+01, 3.4988227895E+00, 9.6182633382E-01],
	[3.6705000000E+04, 3.4089666470E+01, 5.2374300170E+00, 1.5265831161E+01, 3.4992746556E+00, 9.6184341377E-01],
	[3.6710000000E+04, 3.4097675705E+01, 5.2374589475E+00, 1.5272579083E+01, 3.4997264002E+00, 9.6186048482E-01],
	[3.6715000000E+04, 3.4105685730E+01, 5.2374878741E+00, 1.5279329066E+01, 3.5001780232E+00, 9.6187754697E-01],
	[3.6720000000E+04, 3.4113696546E+01, 5.2375167970E+00, 1.5286081109E+01, 3.5006295246E+00, 9.6189460023E-01],
	[3.6725000000E+04, 3.4121708152E+01, 5.2375457161E+00, 1.5292835213E+01, 3.5010809045E+00, 9.6191164461E-01],
	[3.6730000000E+04, 3.4129720549E+01, 5.2375746315E+00, 1.5299591378E+01, 3.5015321629E+00, 9.6192868010E-01],
	[3.6735000000E+04, 3.4137733736E+01, 5.2376035430E+00, 1.5306349606E+01, 3.5019832998E+00, 9.6194570672E-01],
	[3.6740000000E+04, 3.4145747714E+01, 5.2376324508E+00, 1.5313109895E+01, 3.5024343153E+00, 9.6196272447E-01],
	[3.6745000000E+04, 3.4153762482E+01, 5.2376613548E+00, 1.5319872246E+01, 3.5028852093E+00, 9.6197973336E-01],
	[3.6750000000E+04, 3.4161778040E+01, 5.2376902551E+00, 1.5326636661E+01, 3.5033359819E+00, 9.6199673338E-01],
	[3.6755000000E+04, 3.4169794389E+01, 5.2377191515E+00, 1.5333403138E+01, 3.5037866331E+00, 9.6201372454E-01],
	[3.6760000000E+04, 3.4177811528E+01, 5.2377480442E+00, 1.5340171678E+01, 3.5042371630E+00, 9.6203070686E-01],
	[3.6765000000E+04, 3.4185829457E+01, 5.2377769332E+00, 1.5346942283E+01, 3.5046875715E+00, 9.6204768032E-01],
	[3.6770000000E+04, 3.4193848176E+01, 5.2378058183E+00, 1.5353714951E+01, 3.5051378587E+00, 9.6206464495E-01],
	[3.6775000000E+04, 3.4201867686E+01, 5.2378346997E+00, 1.5360489684E+01, 3.5055880246E+00, 9.6208160074E-01],
	[3.6780000000E+04, 3.4209887985E+01, 5.2378635773E+00, 1.5367266482E+01, 3.5060380693E+00, 9.6209854769E-01],
	[3.6785000000E+04, 3.4217909075E+01, 5.2378924512E+00, 1.5374045345E+01, 3.5064879927E+00, 9.6211548582E-01],
	[3.6790000000E+04, 3.4225930955E+01, 5.2379213212E+00, 1.5380826273E+01, 3.5069377948E+00, 9.6213241513E-01],
	[3.6795000000E+04, 3.4233953625E+01, 5.2379501876E+00, 1.5387609267E+01, 3.5073874758E+00, 9.6214933562E-01],
	[3.6800000000E+04, 3.4241977085E+01, 5.2379790501E+00, 1.5394394328E+01, 3.5078370357E+00, 9.6216624729E-01],
	[3.6805000000E+04, 3.4250001335E+01, 5.2380079089E+00, 1.5401181455E+01, 3.5082864743E+00, 9.6218315016E-01],
	[3.6810000000E+04, 3.4258032051E+01, 5.2380374150E+00, 1.5407970648E+01, 3.5087361435E+00, 9.6220004423E-01],
	[3.6815000000E+04, 3.4266078208E+01, 5.2380685975E+00, 1.5414761909E+01, 3.5091865995E+00, 9.6221692950E-01],
	[3.6820000000E+04, 3.4274125162E+01, 5.2380997759E+00, 1.5421555238E+01, 3.5096369348E+00, 9.6223380597E-01],
	[3.6825000000E+04, 3.4282172913E+01, 5.2381309502E+00, 1.5428350634E+01, 3.5100871493E+00, 9.6225067366E-01],
	[3.6830000000E+04, 3.4290221460E+01, 5.2381621206E+00, 1.5435148099E+01, 3.5105372432E+00, 9.6226753256E-01],
	[3.6835000000E+04, 3.4298270804E+01, 5.2381932868E+00, 1.5441947632E+01, 3.5109872165E+00, 9.6228438269E-01],
	[3.6840000000E+04, 3.4306320944E+01, 5.2382244491E+00, 1.5448749234E+01, 3.5114370691E+00, 9.6230122404E-01],
	[3.6845000000E+04, 3.4314371881E+01, 5.2382556073E+00, 1.5455552906E+01, 3.5118868012E+00, 9.6231805662E-01],
	[3.6850000000E+04, 3.4322423615E+01, 5.2382867614E+00, 1.5462358647E+01, 3.5123364127E+00, 9.6233488044E-01],
	[3.6855000000E+04, 3.4330476145E+01, 5.2383179115E+00, 1.5469166458E+01, 3.5127859036E+00, 9.6235169550E-01],
	[3.6860000000E+04, 3.4338529471E+01, 5.2383490576E+00, 1.5475976339E+01, 3.5132352740E+00, 9.6236850180E-01],
	[3.6865000000E+04, 3.4346583594E+01, 5.2383801996E+00, 1.5482788292E+01, 3.5136845239E+00, 9.6238529936E-01],
	[3.6870000000E+04, 3.4354638514E+01, 5.2384113376E+00, 1.5489602315E+01, 3.5141336533E+00, 9.6240208817E-01],
	[3.6875000000E+04, 3.4362694230E+01, 5.2384424715E+00, 1.5496418409E+01, 3.5145826623E+00, 9.6241886824E-01],
	[3.6880000000E+04, 3.4370750742E+01, 5.2384736014E+00, 1.5503236576E+01, 3.5150315508E+00, 9.6243563958E-01],
	[3.6885000000E+04, 3.4378808050E+01, 5.2385047273E+00, 1.5510056814E+01, 3.5154803190E+00, 9.6245240219E-01],
	[3.6890000000E+04, 3.4386866155E+01, 5.2385358492E+00, 1.5516879125E+01, 3.5159289668E+00, 9.6246915607E-01],
	[3.6895000000E+04, 3.4394925056E+01, 5.2385669670E+00, 1.5523703508E+01, 3.5163774942E+00, 9.6248590123E-01],
	[3.6900000000E+04, 3.4402984753E+01, 5.2385980807E+00, 1.5530529965E+01, 3.5168259012E+00, 9.6250263768E-01],
	[3.6905000000E+04, 3.4411045246E+01, 5.2386291905E+00, 1.5537358495E+01, 3.5172741880E+00, 9.6251936541E-01],
	[3.6910000000E+04, 3.4419106536E+01, 5.2386602962E+00, 1.5544189099E+01, 3.5177223545E+00, 9.6253608444E-01],
	[3.6915000000E+04, 3.4427168622E+01, 5.2386913979E+00, 1.5551021777E+01, 3.5181704007E+00, 9.6255279477E-01],
	[3.6920000000E+04, 3.4435231504E+01, 5.2387224956E+00, 1.5557856530E+01, 3.5186183267E+00, 9.6256949640E-01],
	[3.6925000000E+04, 3.4443295182E+01, 5.2387535892E+00, 1.5564693358E+01, 3.5190661324E+00, 9.6258618935E-01],
	[3.6930000000E+04, 3.4451359656E+01, 5.2387846788E+00, 1.5571532260E+01, 3.5195138180E+00, 9.6260287360E-01],
	[3.6935000000E+04, 3.4459424926E+01, 5.2388157644E+00, 1.5578373239E+01, 3.5199613834E+00, 9.6261954917E-01],
	[3.6940000000E+04, 3.4467490992E+01, 5.2388468459E+00, 1.5585216293E+01, 3.5204088287E+00, 9.6263621607E-01],
	[3.6945000000E+04, 3.4475557854E+01, 5.2388779235E+00, 1.5592061423E+01, 3.5208561538E+00, 9.6265287429E-01],
	[3.6950000000E+04, 3.4483625512E+01, 5.2389089970E+00, 1.5598908630E+01, 3.5213033589E+00, 9.6266952385E-01],
	[3.6955000000E+04, 3.4491693965E+01, 5.2389400665E+00, 1.5605757914E+01, 3.5217504439E+00, 9.6268616475E-01],
	[3.6960000000E+04, 3.4499763215E+01, 5.2389711320E+00, 1.5612609275E+01, 3.5221974088E+00, 9.6270279699E-01],
	[3.6965000000E+04, 3.4507833261E+01, 5.2390021934E+00, 1.5619462714E+01, 3.5226442537E+00, 9.6271942057E-01],
	[3.6970000000E+04, 3.4515904102E+01, 5.2390332509E+00, 1.5626318231E+01, 3.5230909786E+00, 9.6273603551E-01],
	[3.6975000000E+04, 3.4523975739E+01, 5.2390643043E+00, 1.5633175826E+01, 3.5235375836E+00, 9.6275264180E-01],
	[3.6980000000E+04, 3.4532048172E+01, 5.2390953537E+00, 1.5640035500E+01, 3.5239840686E+00, 9.6276923946E-01],
	[3.6985000000E+04, 3.4540121401E+01, 5.2391263991E+00, 1.5646897253E+01, 3.5244304336E+00, 9.6278582848E-01],
	[3.6990000000E+04, 3.4548195425E+01, 5.2391574405E+00, 1.5653761085E+01, 3.5248766788E+00, 9.6280240888E-01],
	[3.6995000000E+04, 3.4556270246E+01, 5.2391884779E+00, 1.5660626997E+01, 3.5253228041E+00, 9.6281898065E-01],
	[3.7000000000E+04, 3.4564345861E+01, 5.2392195112E+00, 1.5667494989E+01, 3.5257688095E+00, 9.6283554380E-01],
	[3.7005000000E+04, 3.4572422273E+01, 5.2392505406E+00, 1.5674365061E+01, 3.5262146951E+00, 9.6285209834E-01],
	[3.7010000000E+04, 3.4580499480E+01, 5.2392815659E+00, 1.5681237215E+01, 3.5266604609E+00, 9.6286864427E-01],
	[3.7015000000E+04, 3.4588577482E+01, 5.2393125872E+00, 1.5688111449E+01, 3.5271061070E+00, 9.6288518159E-01],
	[3.7020000000E+04, 3.4596656280E+01, 5.2393436046E+00, 1.5694987765E+01, 3.5275516332E+00, 9.6290171031E-01],
	[3.7025000000E+04, 3.4604735874E+01, 5.2393746179E+00, 1.5701866162E+01, 3.5279970397E+00, 9.6291823044E-01],
	[3.7030000000E+04, 3.4612816263E+01, 5.2394056272E+00, 1.5708746642E+01, 3.5284423266E+00, 9.6293474198E-01],
	[3.7035000000E+04, 3.4620897447E+01, 5.2394366325E+00, 1.5715629204E+01, 3.5288874937E+00, 9.6295124494E-01],
	[3.7040000000E+04, 3.4628979427E+01, 5.2394676338E+00, 1.5722513849E+01, 3.5293325412E+00, 9.6296773931E-01],
	[3.7045000000E+04, 3.4637062202E+01, 5.2394986312E+00, 1.5729400578E+01, 3.5297774690E+00, 9.6298422511E-01],
	[3.7050000000E+04, 3.4645145773E+01, 5.2395296245E+00, 1.5736289389E+01, 3.5302222772E+00, 9.6300070234E-01],
	[3.7055000000E+04, 3.4653230139E+01, 5.2395606138E+00, 1.5743180285E+01, 3.5306669658E+00, 9.6301717100E-01],
	[3.7060000000E+04, 3.4661315300E+01, 5.2395915991E+00, 1.5750073265E+01, 3.5311115349E+00, 9.6303363110E-01],
	[3.7065000000E+04, 3.4669401257E+01, 5.2396225804E+00, 1.5756968330E+01, 3.5315559844E+00, 9.6305008265E-01],
	[3.7070000000E+04, 3.4677488008E+01, 5.2396535577E+00, 1.5763865479E+01, 3.5320003144E+00, 9.6306652564E-01],
	[3.7075000000E+04, 3.4685575555E+01, 5.2396845311E+00, 1.5770764714E+01, 3.5324445250E+00, 9.6308296008E-01],
	[3.7080000000E+04, 3.4693663898E+01, 5.2397155004E+00, 1.5777666034E+01, 3.5328886160E+00, 9.6309938599E-01],
	[3.7085000000E+04, 3.4701753035E+01, 5.2397464657E+00, 1.5784569441E+01, 3.5333325876E+00, 9.6311580335E-01],
	[3.7090000000E+04, 3.4709842967E+01, 5.2397774271E+00, 1.5791474933E+01, 3.5337764398E+00, 9.6313221219E-01],
	[3.7095000000E+04, 3.4717933695E+01, 5.2398083845E+00, 1.5798382513E+01, 3.5342201726E+00, 9.6314861249E-01],
	[3.7100000000E+04, 3.4726025218E+01, 5.2398393378E+00, 1.5805292179E+01, 3.5346637860E+00, 9.6316500428E-01],
	[3.7105000000E+04, 3.4734117535E+01, 5.2398702872E+00, 1.5812203933E+01, 3.5351072801E+00, 9.6318138754E-01],
	[3.7110000000E+04, 3.4742210648E+01, 5.2399012326E+00, 1.5819117774E+01, 3.5355506549E+00, 9.6319776230E-01],
	[3.7115000000E+04, 3.4750304556E+01, 5.2399321740E+00, 1.5826033704E+01, 3.5359939103E+00, 9.6321412854E-01],
	[3.7120000000E+04, 3.4758399258E+01, 5.2399631114E+00, 1.5832951722E+01, 3.5364370465E+00, 9.6323048628E-01],
	[3.7125000000E+04, 3.4766494756E+01, 5.2399940449E+00, 1.5839871829E+01, 3.5368800634E+00, 9.6324683552E-01],
	[3.7130000000E+04, 3.4774591048E+01, 5.2400249743E+00, 1.5846794024E+01, 3.5373229611E+00, 9.6326317627E-01],
	[3.7135000000E+04, 3.4782688135E+01, 5.2400558998E+00, 1.5853718310E+01, 3.5377657396E+00, 9.6327950853E-01],
	[3.7140000000E+04, 3.4790786017E+01, 5.2400868213E+00, 1.5860644685E+01, 3.5382083990E+00, 9.6329583230E-01],
	[3.7145000000E+04, 3.4798884694E+01, 5.2401177388E+00, 1.5867573150E+01, 3.5386509391E+00, 9.6331214759E-01],
	[3.7150000000E+04, 3.4806984166E+01, 5.2401486523E+00, 1.5874503706E+01, 3.5390933602E+00, 9.6332845441E-01],
	[3.7155000000E+04, 3.4815084432E+01, 5.2401795619E+00, 1.5881436352E+01, 3.5395356621E+00, 9.6334475276E-01],
	[3.7160000000E+04, 3.4823185494E+01, 5.2402104675E+00, 1.5888371090E+01, 3.5399778450E+00, 9.6336104264E-01],
	[3.7165000000E+04, 3.4831287349E+01, 5.2402413691E+00, 1.5895307919E+01, 3.5404199088E+00, 9.6337732406E-01],
	[3.7170000000E+04, 3.4839390000E+01, 5.2402722667E+00, 1.5902246841E+01, 3.5408618536E+00, 9.6339359703E-01],
	[3.7175000000E+04, 3.4847493445E+01, 5.2403031603E+00, 1.5909187854E+01, 3.5413036794E+00, 9.6340986155E-01],
	[3.7180000000E+04, 3.4855597685E+01, 5.2403340500E+00, 1.5916130960E+01, 3.5417453862E+00, 9.6342611761E-01],
	[3.7185000000E+04, 3.4863702719E+01, 5.2403649357E+00, 1.5923076159E+01, 3.5421869740E+00, 9.6344236524E-01],
	[3.7190000000E+04, 3.4871808548E+01, 5.2403958175E+00, 1.5930023451E+01, 3.5426284429E+00, 9.6345860443E-01],
	[3.7195000000E+04, 3.4879915171E+01, 5.2404266952E+00, 1.5936972837E+01, 3.5430697929E+00, 9.6347483519E-01],
	[3.7200000000E+04, 3.4888022589E+01, 5.2404575690E+00, 1.5943924317E+01, 3.5435110240E+00, 9.6349105752E-01],
	[3.7205000000E+04, 3.4896130802E+01, 5.2404884389E+00, 1.5950877892E+01, 3.5439521362E+00, 9.6350727143E-01],
	[3.7210000000E+04, 3.4904239808E+01, 5.2405193047E+00, 1.5957833560E+01, 3.5443931297E+00, 9.6352347691E-01],
	[3.7215000000E+04, 3.4912349610E+01, 5.2405501666E+00, 1.5964791324E+01, 3.5448340043E+00, 9.6353967399E-01],
	[3.7220000000E+04, 3.4920460205E+01, 5.2405810246E+00, 1.5971751184E+01, 3.5452747601E+00, 9.6355586266E-01],
	[3.7225000000E+04, 3.4928571595E+01, 5.2406118785E+00, 1.5978713139E+01, 3.5457153971E+00, 9.6357204292E-01],
	[3.7230000000E+04, 3.4936683779E+01, 5.2406427285E+00, 1.5985677190E+01, 3.5461559155E+00, 9.6358821479E-01],
	[3.7235000000E+04, 3.4944796758E+01, 5.2406735746E+00, 1.5992643337E+01, 3.5465963151E+00, 9.6360437826E-01],
	[3.7240000000E+04, 3.4952910530E+01, 5.2407044167E+00, 1.5999611582E+01, 3.5470365960E+00, 9.6362053334E-01],
	[3.7245000000E+04, 3.4961025097E+01, 5.2407352548E+00, 1.6006581923E+01, 3.5474767582E+00, 9.6363668004E-01],
	[3.7250000000E+04, 3.4969140458E+01, 5.2407660890E+00, 1.6013554362E+01, 3.5479168019E+00, 9.6365281836E-01],
	[3.7255000000E+04, 3.4977256614E+01, 5.2407969192E+00, 1.6020528898E+01, 3.5483567269E+00, 9.6366894830E-01],
	[3.7260000000E+04, 3.4985373563E+01, 5.2408277454E+00, 1.6027505533E+01, 3.5487965333E+00, 9.6368506987E-01],
	[3.7265000000E+04, 3.4993491307E+01, 5.2408585677E+00, 1.6034484267E+01, 3.5492362211E+00, 9.6370118308E-01],
	[3.7270000000E+04, 3.5001609844E+01, 5.2408893861E+00, 1.6041465099E+01, 3.5496757904E+00, 9.6371728793E-01],
	[3.7275000000E+04, 3.5009729176E+01, 5.2409202005E+00, 1.6048448030E+01, 3.5501152412E+00, 9.6373338442E-01],
	[3.7280000000E+04, 3.5017849302E+01, 5.2409510109E+00, 1.6055433061E+01, 3.5505545735E+00, 9.6374947255E-01],
	[3.7285000000E+04, 3.5025970222E+01, 5.2409818174E+00, 1.6062420192E+01, 3.5509937873E+00, 9.6376555235E-01],
	[3.7290000000E+04, 3.5034091935E+01, 5.2410126200E+00, 1.6069409423E+01, 3.5514328827E+00, 9.6378162380E-01],
	[3.7295000000E+04, 3.5042214443E+01, 5.2410434185E+00, 1.6076400755E+01, 3.5518718597E+00, 9.6379768691E-01],
	[3.7300000000E+04, 3.5050337745E+01, 5.2410742132E+00, 1.6083394187E+01, 3.5523107182E+00, 9.6381374169E-01],
	[3.7305000000E+04, 3.5058461840E+01, 5.2411050039E+00, 1.6090389721E+01, 3.5527494584E+00, 9.6382978814E-01],
	[3.7310000000E+04, 3.5066586729E+01, 5.2411357906E+00, 1.6097387357E+01, 3.5531880803E+00, 9.6384582627E-01],
	[3.7315000000E+04, 3.5074712412E+01, 5.2411665734E+00, 1.6104387094E+01, 3.5536265838E+00, 9.6386185608E-01],
	[3.7320000000E+04, 3.5082838889E+01, 5.2411973523E+00, 1.6111388934E+01, 3.5540649691E+00, 9.6387787758E-01],
	[3.7325000000E+04, 3.5090966160E+01, 5.2412281272E+00, 1.6118392877E+01, 3.5545032360E+00, 9.6389389076E-01],
	[3.7330000000E+04, 3.5099094224E+01, 5.2412588982E+00, 1.6125398922E+01, 3.5549413848E+00, 9.6390989565E-01],
	[3.7335000000E+04, 3.5107223082E+01, 5.2412896653E+00, 1.6132407071E+01, 3.5553794153E+00, 9.6392589223E-01],
	[3.7340000000E+04, 3.5115352734E+01, 5.2413204284E+00, 1.6139417324E+01, 3.5558173276E+00, 9.6394188052E-01],
	[3.7345000000E+04, 3.5123483180E+01, 5.2413511875E+00, 1.6146429681E+01, 3.5562551217E+00, 9.6395786052E-01],
	[3.7350000000E+04, 3.5131614419E+01, 5.2413819427E+00, 1.6153444142E+01, 3.5566927977E+00, 9.6397383223E-01],
	[3.7355000000E+04, 3.5139746451E+01, 5.2414126940E+00, 1.6160460708E+01, 3.5571303556E+00, 9.6398979567E-01],
	[3.7360000000E+04, 3.5147879278E+01, 5.2414434414E+00, 1.6167479379E+01, 3.5575677953E+00, 9.6400575083E-01],
	[3.7365000000E+04, 3.5156012897E+01, 5.2414741848E+00, 1.6174500156E+01, 3.5580051170E+00, 9.6402169771E-01],
	[3.7370000000E+04, 3.5164147311E+01, 5.2415049243E+00, 1.6181523038E+01, 3.5584423207E+00, 9.6403763633E-01],
	[3.7375000000E+04, 3.5172282517E+01, 5.2415356598E+00, 1.6188548027E+01, 3.5588794063E+00, 9.6405356669E-01],
	[3.7380000000E+04, 3.5180418518E+01, 5.2415663914E+00, 1.6195575122E+01, 3.5593163739E+00, 9.6406948879E-01],
	[3.7385000000E+04, 3.5188555311E+01, 5.2415971191E+00, 1.6202604324E+01, 3.5597532236E+00, 9.6408540264E-01],
	[3.7390000000E+04, 3.5196692898E+01, 5.2416278429E+00, 1.6209635633E+01, 3.5601899553E+00, 9.6410130824E-01],
	[3.7395000000E+04, 3.5204831279E+01, 5.2416585627E+00, 1.6216669049E+01, 3.5606265690E+00, 9.6411720560E-01],
	[3.7400000000E+04, 3.5212970452E+01, 5.2416892786E+00, 1.6223704574E+01, 3.5610630649E+00, 9.6413309472E-01],
	[3.7405000000E+04, 3.5221125813E+01, 5.2417217360E+00, 1.6230742207E+01, 3.5615004061E+00, 9.6414897561E-01],
	[3.7410000000E+04, 3.5229286687E+01, 5.2417547237E+00, 1.6237781948E+01, 3.5619379246E+00, 9.6416484826E-01],
	[3.7415000000E+04, 3.5237448361E+01, 5.2417877071E+00, 1.6244823799E+01, 3.5623753257E+00, 9.6418071270E-01],
	[3.7420000000E+04, 3.5245610835E+01, 5.2418206864E+00, 1.6251867759E+01, 3.5628126093E+00, 9.6419656891E-01],
	[3.7425000000E+04, 3.5253774109E+01, 5.2418536614E+00, 1.6258913828E+01, 3.5632497755E+00, 9.6421241691E-01],
	[3.7430000000E+04, 3.5261938182E+01, 5.2418866323E+00, 1.6265962007E+01, 3.5636868243E+00, 9.6422825670E-01],
	[3.7435000000E+04, 3.5270103056E+01, 5.2419195990E+00, 1.6273012297E+01, 3.5641237557E+00, 9.6424408828E-01],
	[3.7440000000E+04, 3.5278268729E+01, 5.2419525614E+00, 1.6280064698E+01, 3.5645605697E+00, 9.6425991166E-01],
	[3.7445000000E+04, 3.5286435201E+01, 5.2419855197E+00, 1.6287119209E+01, 3.5649972664E+00, 9.6427572685E-01],
	[3.7450000000E+04, 3.5294602474E+01, 5.2420184738E+00, 1.6294175832E+01, 3.5654338457E+00, 9.6429153384E-01],
	[3.7455000000E+04, 3.5302770545E+01, 5.2420514237E+00, 1.6301234567E+01, 3.5658703078E+00, 9.6430733265E-01],
	[3.7460000000E+04, 3.5310939417E+01, 5.2420843694E+00, 1.6308295414E+01, 3.5663066526E+00, 9.6432312328E-01],
	[3.7465000000E+04, 3.5319109088E+01, 5.2421173109E+00, 1.6315358373E+01, 3.5667428802E+00, 9.6433890573E-01],
	[3.7470000000E+04, 3.5327279559E+01, 5.2421502482E+00, 1.6322423445E+01, 3.5671789906E+00, 9.6435468000E-01],
	[3.7475000000E+04, 3.5335450829E+01, 5.2421831814E+00, 1.6329490630E+01, 3.5676149837E+00, 9.6437044611E-01],
	[3.7480000000E+04, 3.5343622899E+01, 5.2422161103E+00, 1.6336559928E+01, 3.5680508598E+00, 9.6438620406E-01],
	[3.7485000000E+04, 3.5351795768E+01, 5.2422490351E+00, 1.6343631341E+01, 3.5684866186E+00, 9.6440195384E-01],
	[3.7490000000E+04, 3.5359969437E+01, 5.2422819557E+00, 1.6350704867E+01, 3.5689222604E+00, 9.6441769547E-01],
	[3.7495000000E+04, 3.5368143905E+01, 5.2423148721E+00, 1.6357780509E+01, 3.5693577850E+00, 9.6443342896E-01],
	[3.7500000000E+04, 3.5376319172E+01, 5.2423477843E+00, 1.6364858265E+01, 3.5697931926E+00, 9.6444915429E-01],
	[3.7505000000E+04, 3.5384495239E+01, 5.2423806923E+00, 1.6371938136E+01, 3.5702284832E+00, 9.6446487149E-01],
	[3.7510000000E+04, 3.5392672105E+01, 5.2424135962E+00, 1.6379020123E+01, 3.5706636567E+00, 9.6448058055E-01],
	[3.7515000000E+04, 3.5400849770E+01, 5.2424464958E+00, 1.6386104226E+01, 3.5710987133E+00, 9.6449628149E-01],
	[3.7520000000E+04, 3.5409028235E+01, 5.2424793913E+00, 1.6393190445E+01, 3.5715336529E+00, 9.6451197429E-01],
	[3.7525000000E+04, 3.5417207499E+01, 5.2425122826E+00, 1.6400278780E+01, 3.5719684755E+00, 9.6452765898E-01],
	[3.7530000000E+04, 3.5425387562E+01, 5.2425451698E+00, 1.6407369233E+01, 3.5724031812E+00, 9.6454333554E-01],
	[3.7535000000E+04, 3.5433568424E+01, 5.2425780527E+00, 1.6414461803E+01, 3.5728377701E+00, 9.6455900400E-01],
	[3.7540000000E+04, 3.5441750086E+01, 5.2426109315E+00, 1.6421556490E+01, 3.5732722420E+00, 9.6457466435E-01],
	[3.7545000000E+04, 3.5449932546E+01, 5.2426438061E+00, 1.6428653296E+01, 3.5737065972E+00, 9.6459031659E-01],
	[3.7550000000E+04, 3.5458115806E+01, 5.2426766766E+00, 1.6435752220E+01, 3.5741408355E+00, 9.6460596074E-01],
	[3.7555000000E+04, 3.5466299865E+01, 5.2427095429E+00, 1.6442853263E+01, 3.5745749570E+00, 9.6462159679E-01],
	[3.7560000000E+04, 3.5474484722E+01, 5.2427424050E+00, 1.6449956425E+01, 3.5750089617E+00, 9.6463722476E-01],
	[3.7565000000E+04, 3.5482670379E+01, 5.2427752629E+00, 1.6457061706E+01, 3.5754428497E+00, 9.6465284464E-01],
	[3.7570000000E+04, 3.5490856835E+01, 5.2428081167E+00, 1.6464169107E+01, 3.5758766210E+00, 9.6466845644E-01],
	[3.7575000000E+04, 3.5499044090E+01, 5.2428409663E+00, 1.6471278628E+01, 3.5763102755E+00, 9.6468406016E-01],
	[3.7580000000E+04, 3.5507232143E+01, 5.2428738117E+00, 1.6478390270E+01, 3.5767438135E+00, 9.6469965582E-01],
	[3.7585000000E+04, 3.5515420996E+01, 5.2429066530E+00, 1.6485504032E+01, 3.5771772347E+00, 9.6471524341E-01],
	[3.7590000000E+04, 3.5523610647E+01, 5.2429394901E+00, 1.6492619916E+01, 3.5776105394E+00, 9.6473082294E-01],
	[3.7595000000E+04, 3.5531801098E+01, 5.2429723231E+00, 1.6499737921E+01, 3.5780437274E+00, 9.6474639441E-01],
	[3.7600000000E+04, 3.5539992347E+01, 5.2430051518E+00, 1.6506858048E+01, 3.5784767989E+00, 9.6476195783E-01],
	[3.7605000000E+04, 3.5548184395E+01, 5.2430379765E+00, 1.6513980297E+01, 3.5789097538E+00, 9.6477751321E-01],
	[3.7610000000E+04, 3.5556377241E+01, 5.2430707969E+00, 1.6521104668E+01, 3.5793425922E+00, 9.6479306054E-01],
	[3.7615000000E+04, 3.5564570887E+01, 5.2431036133E+00, 1.6528231163E+01, 3.5797753142E+00, 9.6480859983E-01],
	[3.7620000000E+04, 3.5572765331E+01, 5.2431364254E+00, 1.6535359781E+01, 3.5802079196E+00, 9.6482413109E-01],
	[3.7625000000E+04, 3.5580960573E+01, 5.2431692334E+00, 1.6542490522E+01, 3.5806404086E+00, 9.6483965432E-01],
	[3.7630000000E+04, 3.5589156615E+01, 5.2432020373E+00, 1.6549623388E+01, 3.5810727812E+00, 9.6485516953E-01],
	[3.7635000000E+04, 3.5597353455E+01, 5.2432348370E+00, 1.6556758377E+01, 3.5815050374E+00, 9.6487067671E-01],
	[3.7640000000E+04, 3.5605551093E+01, 5.2432676325E+00, 1.6563895492E+01, 3.5819371772E+00, 9.6488617589E-01],
	[3.7645000000E+04, 3.5613749531E+01, 5.2433004239E+00, 1.6571034731E+01, 3.5823692007E+00, 9.6490166705E-01],
	[3.7650000000E+04, 3.5621948766E+01, 5.2433332111E+00, 1.6578176096E+01, 3.5828011078E+00, 9.6491715021E-01],
	[3.7655000000E+04, 3.5630148800E+01, 5.2433659942E+00, 1.6585319586E+01, 3.5832328987E+00, 9.6493262536E-01],
	[3.7660000000E+04, 3.5638349633E+01, 5.2433987732E+00, 1.6592465202E+01, 3.5836645732E+00, 9.6494809252E-01],
	[3.7665000000E+04, 3.5646551264E+01, 5.2434315480E+00, 1.6599612945E+01, 3.5840961316E+00, 9.6496355169E-01],
	[3.7670000000E+04, 3.5654753694E+01, 5.2434643186E+00, 1.6606762815E+01, 3.5845275737E+00, 9.6497900287E-01],
	[3.7675000000E+04, 3.5662956922E+01, 5.2434970851E+00, 1.6613914811E+01, 3.5849588996E+00, 9.6499444607E-01],
	[3.7680000000E+04, 3.5671160948E+01, 5.2435298475E+00, 1.6621068935E+01, 3.5853901093E+00, 9.6500988129E-01],
	[3.7685000000E+04, 3.5679365772E+01, 5.2435626057E+00, 1.6628225187E+01, 3.5858212029E+00, 9.6502530854E-01],
	[3.7690000000E+04, 3.5687571395E+01, 5.2435953598E+00, 1.6635383567E+01, 3.5862521804E+00, 9.6504072781E-01],
	[3.7695000000E+04, 3.5695777817E+01, 5.2436281097E+00, 1.6642544076E+01, 3.5866830418E+00, 9.6505613913E-01],
	[3.7700000000E+04, 3.5703985036E+01, 5.2436608555E+00, 1.6649706713E+01, 3.5871137871E+00, 9.6507154248E-01],
	[3.7705000000E+04, 3.5712193054E+01, 5.2436935972E+00, 1.6656871480E+01, 3.5875444163E+00, 9.6508693788E-01],
	[3.7710000000E+04, 3.5720401870E+01, 5.2437263347E+00, 1.6664038376E+01, 3.5879749296E+00, 9.6510232533E-01],
	[3.7715000000E+04, 3.5728611484E+01, 5.2437590681E+00, 1.6671207402E+01, 3.5884053268E+00, 9.6511770483E-01],
	[3.7720000000E+04, 3.5736821896E+01, 5.2437917974E+00, 1.6678378558E+01, 3.5888356081E+00, 9.6513307640E-01],
	[3.7725000000E+04, 3.5745033106E+01, 5.2438245225E+00, 1.6685551845E+01, 3.5892657734E+00, 9.6514844002E-01],
	[3.7730000000E+04, 3.5753245114E+01, 5.2438572435E+00, 1.6692727262E+01, 3.5896958228E+00, 9.6516379571E-01],
	[3.7735000000E+04, 3.5761457921E+01, 5.2438899603E+00, 1.6699904811E+01, 3.5901257563E+00, 9.6517914348E-01],
	[3.7740000000E+04, 3.5769671525E+01, 5.2439226730E+00, 1.6707084492E+01, 3.5905555739E+00, 9.6519448332E-01],
	[3.7745000000E+04, 3.5777885928E+01, 5.2439553816E+00, 1.6714266304E+01, 3.5909852757E+00, 9.6520981525E-01],
	[3.7750000000E+04, 3.5786101128E+01, 5.2439880861E+00, 1.6721450249E+01, 3.5914148617E+00, 9.6522513926E-01],
	[3.7755000000E+04, 3.5794317126E+01, 5.2440207864E+00, 1.6728636327E+01, 3.5918443318E+00, 9.6524045536E-01],
	[3.7760000000E+04, 3.5802533922E+01, 5.2440534826E+00, 1.6735824538E+01, 3.5922736862E+00, 9.6525576356E-01],
	[3.7765000000E+04, 3.5810751517E+01, 5.2440861747E+00, 1.6743014882E+01, 3.5927029249E+00, 9.6527106386E-01],
	[3.7770000000E+04, 3.5818969908E+01, 5.2441188627E+00, 1.6750207359E+01, 3.5931320478E+00, 9.6528635626E-01],
	[3.7775000000E+04, 3.5827189098E+01, 5.2441515465E+00, 1.6757401971E+01, 3.5935610550E+00, 9.6530164077E-01],
	[3.7780000000E+04, 3.5835409086E+01, 5.2441842263E+00, 1.6764598717E+01, 3.5939899466E+00, 9.6531691739E-01],
	[3.7785000000E+04, 3.5843629871E+01, 5.2442169018E+00, 1.6771797598E+01, 3.5944187225E+00, 9.6533218614E-01],
	[3.7790000000E+04, 3.5851851454E+01, 5.2442495733E+00, 1.6778998614E+01, 3.5948473828E+00, 9.6534744700E-01],
	[3.7795000000E+04, 3.5860073835E+01, 5.2442822407E+00, 1.6786201766E+01, 3.5952759275E+00, 9.6536270000E-01],
	[3.7800000000E+04, 3.5868297014E+01, 5.2443149039E+00, 1.6793407053E+01, 3.5957043566E+00, 9.6537794512E-01],
	[3.7805000000E+04, 3.5876520990E+01, 5.2443475630E+00, 1.6800614477E+01, 3.5961326702E+00, 9.6539318238E-01],
	[3.7810000000E+04, 3.5884745764E+01, 5.2443802180E+00, 1.6807824037E+01, 3.5965608683E+00, 9.6540841178E-01],
	[3.7815000000E+04, 3.5892971335E+01, 5.2444128689E+00, 1.6815035734E+01, 3.5969889508E+00, 9.6542363333E-01],
	[3.7820000000E+04, 3.5901197704E+01, 5.2444455157E+00, 1.6822249568E+01, 3.5974169179E+00, 9.6543884703E-01],
	[3.7825000000E+04, 3.5909424870E+01, 5.2444781584E+00, 1.6829465540E+01, 3.5978447696E+00, 9.6545405288E-01],
	[3.7830000000E+04, 3.5917652834E+01, 5.2445107969E+00, 1.6836683650E+01, 3.5982725058E+00, 9.6546925090E-01],
	[3.7835000000E+04, 3.5925881596E+01, 5.2445434314E+00, 1.6843903897E+01, 3.5987001267E+00, 9.6548444107E-01],
	[3.7840000000E+04, 3.5934111155E+01, 5.2445760617E+00, 1.6851126284E+01, 3.5991276321E+00, 9.6549962342E-01],
	[3.7845000000E+04, 3.5942341511E+01, 5.2446086879E+00, 1.6858350809E+01, 3.5995550223E+00, 9.6551479793E-01],
	[3.7850000000E+04, 3.5950572665E+01, 5.2446413101E+00, 1.6865577474E+01, 3.5999822971E+00, 9.6552996463E-01],
	[3.7855000000E+04, 3.5958804616E+01, 5.2446739281E+00, 1.6872806279E+01, 3.6004094566E+00, 9.6554512351E-01],
	[3.7860000000E+04, 3.5967037365E+01, 5.2447065420E+00, 1.6880037223E+01, 3.6008365008E+00, 9.6556027457E-01],
	[3.7865000000E+04, 3.5975270911E+01, 5.2447391518E+00, 1.6887270308E+01, 3.6012634298E+00, 9.6557541782E-01],
	[3.7870000000E+04, 3.5983505254E+01, 5.2447717575E+00, 1.6894505534E+01, 3.6016902436E+00, 9.6559055327E-01],
	[3.7875000000E+04, 3.5991740394E+01, 5.2448043591E+00, 1.6901742900E+01, 3.6021169422E+00, 9.6560568092E-01],
	[3.7880000000E+04, 3.5999976332E+01, 5.2448369566E+00, 1.6908982408E+01, 3.6025435256E+00, 9.6562080078E-01],
	[3.7885000000E+04, 3.6008213067E+01, 5.2448695500E+00, 1.6916224058E+01, 3.6029699939E+00, 9.6563591284E-01],
	[3.7890000000E+04, 3.6016450599E+01, 5.2449021393E+00, 1.6923467850E+01, 3.6033963471E+00, 9.6565101712E-01],
	[3.7895000000E+04, 3.6024688928E+01, 5.2449347245E+00, 1.6930713785E+01, 3.6038225851E+00, 9.6566611362E-01],
	[3.7900000000E+04, 3.6032928054E+01, 5.2449673056E+00, 1.6937961862E+01, 3.6042487081E+00, 9.6568120233E-01],
	[3.7905000000E+04, 3.6041167977E+01, 5.2449998826E+00, 1.6945212082E+01, 3.6046747161E+00, 9.6569628328E-01],
	[3.7910000000E+04, 3.6049408698E+01, 5.2450324555E+00, 1.6952464446E+01, 3.6051006091E+00, 9.6571135646E-01],
	[3.7915000000E+04, 3.6057650215E+01, 5.2450650243E+00, 1.6959718954E+01, 3.6055263870E+00, 9.6572642187E-01],
	[3.7920000000E+04, 3.6065892530E+01, 5.2450975890E+00, 1.6966975606E+01, 3.6059520500E+00, 9.6574147953E-01],
	[3.7925000000E+04, 3.6074135641E+01, 5.2451301497E+00, 1.6974234402E+01, 3.6063775981E+00, 9.6575652943E-01],
	[3.7930000000E+04, 3.6082379550E+01, 5.2451627062E+00, 1.6981495343E+01, 3.6068030312E+00, 9.6577157157E-01],
	[3.7935000000E+04, 3.6090624255E+01, 5.2451952587E+00, 1.6988758430E+01, 3.6072283495E+00, 9.6578660598E-01],
	[3.7940000000E+04, 3.6098869757E+01, 5.2452278070E+00, 1.6996023662E+01, 3.6076535528E+00, 9.6580163264E-01],
	[3.7945000000E+04, 3.6107116057E+01, 5.2452603513E+00, 1.7003291040E+01, 3.6080786414E+00, 9.6581665157E-01],
	[3.7950000000E+04, 3.6115363153E+01, 5.2452928915E+00, 1.7010560565E+01, 3.6085036151E+00, 9.6583166276E-01],
	[3.7955000000E+04, 3.6123611045E+01, 5.2453254276E+00, 1.7017832236E+01, 3.6089284741E+00, 9.6584666623E-01],
	[3.7960000000E+04, 3.6131859735E+01, 5.2453579596E+00, 1.7025106054E+01, 3.6093532183E+00, 9.6586166197E-01],
	[3.7965000000E+04, 3.6140109221E+01, 5.2453904876E+00, 1.7032382020E+01, 3.6097778477E+00, 9.6587665000E-01],
	[3.7970000000E+04, 3.6148359504E+01, 5.2454230114E+00, 1.7039660133E+01, 3.6102023624E+00, 9.6589163031E-01],
	[3.7975000000E+04, 3.6156610584E+01, 5.2454555312E+00, 1.7046940394E+01, 3.6106267625E+00, 9.6590660291E-01],
	[3.7980000000E+04, 3.6164862461E+01, 5.2454880469E+00, 1.7054222804E+01, 3.6110510479E+00, 9.6592156780E-01],
	[3.7985000000E+04, 3.6173115134E+01, 5.2455205585E+00, 1.7061507362E+01, 3.6114752186E+00, 9.6593652500E-01],
	[3.7990000000E+04, 3.6181368603E+01, 5.2455530661E+00, 1.7068794070E+01, 3.6118992747E+00, 9.6595147449E-01],
	[3.7995000000E+04, 3.6189622870E+01, 5.2455855696E+00, 1.7076082927E+01, 3.6123232163E+00, 9.6596641630E-01],
	[3.8000000000E+04, 3.6197877933E+01, 5.2456180689E+00, 1.7083373934E+01, 3.6127470433E+00, 9.6598135042E-01],
	[3.8005000000E+04, 3.6206140631E+01, 5.2456513312E+00, 1.7090667091E+01, 3.6131711877E+00, 9.6599627686E-01],
	[3.8010000000E+04, 3.6214417175E+01, 5.2456860518E+00, 1.7097962398E+01, 3.6135960417E+00, 9.6601119562E-01],
	[3.8015000000E+04, 3.6222694522E+01, 5.2457207682E+00, 1.7105259856E+01, 3.6140207815E+00, 9.6602610670E-01],
	[3.8020000000E+04, 3.6230972672E+01, 5.2457554802E+00, 1.7112559466E+01, 3.6144454072E+00, 9.6604101012E-01],
	[3.8025000000E+04, 3.6239251625E+01, 5.2457901878E+00, 1.7119861227E+01, 3.6148699188E+00, 9.6605590587E-01],
	[3.8030000000E+04, 3.6247531381E+01, 5.2458248911E+00, 1.7127165140E+01, 3.6152943163E+00, 9.6607079396E-01],
	[3.8035000000E+04, 3.6255811939E+01, 5.2458595901E+00, 1.7134471205E+01, 3.6157185997E+00, 9.6608567439E-01],
	[3.8040000000E+04, 3.6264093300E+01, 5.2458942848E+00, 1.7141779423E+01, 3.6161427691E+00, 9.6610054717E-01],
	[3.8045000000E+04, 3.6272375464E+01, 5.2459289751E+00, 1.7149089794E+01, 3.6165668245E+00, 9.6611541231E-01],
	[3.8050000000E+04, 3.6280658431E+01, 5.2459636611E+00, 1.7156402318E+01, 3.6169907659E+00, 9.6613026980E-01],
	[3.8055000000E+04, 3.6288942200E+01, 5.2459983428E+00, 1.7163716995E+01, 3.6174145933E+00, 9.6614511966E-01],
	[3.8060000000E+04, 3.6297226772E+01, 5.2460330201E+00, 1.7171033827E+01, 3.6178383068E+00, 9.6615996188E-01],
	[3.8065000000E+04, 3.6305512147E+01, 5.2460676931E+00, 1.7178352813E+01, 3.6182619064E+00, 9.6617479647E-01],
	[3.8070000000E+04, 3.6313798325E+01, 5.2461023618E+00, 1.7185673954E+01, 3.6186853920E+00, 9.6618962344E-01],
	[3.8075000000E+04, 3.6322085305E+01, 5.2461370262E+00, 1.7192997249E+01, 3.6191087639E+00, 9.6620444279E-01],
	[3.8080000000E+04, 3.6330373087E+01, 5.2461716862E+00, 1.7200322701E+01, 3.6195320219E+00, 9.6621925452E-01],
	[3.8085000000E+04, 3.6338661673E+01, 5.2462063419E+00, 1.7207650308E+01, 3.6199551661E+00, 9.6623405864E-01],
	[3.8090000000E+04, 3.6346951060E+01, 5.2462409933E+00, 1.7214980071E+01, 3.6203781965E+00, 9.6624885516E-01],
	[3.8095000000E+04, 3.6355241251E+01, 5.2462756404E+00, 1.7222311990E+01, 3.6208011131E+00, 9.6626364407E-01],
	[3.8100000000E+04, 3.6363532243E+01, 5.2463102832E+00, 1.7229646066E+01, 3.6212239160E+00, 9.6627842538E-01],
	[3.8105000000E+04, 3.6371824038E+01, 5.2463449216E+00, 1.7236982300E+01, 3.6216466052E+00, 9.6629319910E-01],
	[3.8110000000E+04, 3.6380116636E+01, 5.2463795557E+00, 1.7244320691E+01, 3.6220691807E+00, 9.6630796523E-01],
	[3.8115000000E+04, 3.6388410036E+01, 5.2464141855E+00, 1.7251661239E+01, 3.6224916426E+00, 9.6632272378E-01],
	[3.8120000000E+04, 3.6396704238E+01, 5.2464488110E+00, 1.7259003946E+01, 3.6229139908E+00, 9.6633747474E-01],
	[3.8125000000E+04, 3.6404999243E+01, 5.2464834322E+00, 1.7266348812E+01, 3.6233362254E+00, 9.6635221813E-01],
	[3.8130000000E+04, 3.6413295050E+01, 5.2465180491E+00, 1.7273695836E+01, 3.6237583465E+00, 9.6636695395E-01],
	[3.8135000000E+04, 3.6421591659E+01, 5.2465526617E+00, 1.7281045020E+01, 3.6241803540E+00, 9.6638168221E-01],
	[3.8140000000E+04, 3.6429889071E+01, 5.2465872699E+00, 1.7288396363E+01, 3.6246022479E+00, 9.6639640290E-01],
	[3.8145000000E+04, 3.6438187284E+01, 5.2466218739E+00, 1.7295749866E+01, 3.6250240283E+00, 9.6641111603E-01],
	[3.8150000000E+04, 3.6446486300E+01, 5.2466564735E+00, 1.7303105530E+01, 3.6254456953E+00, 9.6642582160E-01],
	[3.8155000000E+04, 3.6454786118E+01, 5.2466910688E+00, 1.7310463354E+01, 3.6258672488E+00, 9.6644051963E-01],
	[3.8160000000E+04, 3.6463086739E+01, 5.2467256599E+00, 1.7317823339E+01, 3.6262886889E+00, 9.6645521012E-01],
	[3.8165000000E+04, 3.6471388161E+01, 5.2467602466E+00, 1.7325185486E+01, 3.6267100156E+00, 9.6646989306E-01],
	[3.8170000000E+04, 3.6479690385E+01, 5.2467948290E+00, 1.7332549794E+01, 3.6271312288E+00, 9.6648456847E-01],
	[3.8175000000E+04, 3.6487993412E+01, 5.2468294071E+00, 1.7339916264E+01, 3.6275523288E+00, 9.6649923635E-01],
	[3.8180000000E+04, 3.6496297240E+01, 5.2468639809E+00, 1.7347284897E+01, 3.6279733154E+00, 9.6651389669E-01],
	[3.8185000000E+04, 3.6504601871E+01, 5.2468985504E+00, 1.7354655692E+01, 3.6283941887E+00, 9.6652854952E-01],
	[3.8190000000E+04, 3.6512907303E+01, 5.2469331157E+00, 1.7362028650E+01, 3.6288149487E+00, 9.6654319483E-01],
	[3.8195000000E+04, 3.6521213538E+01, 5.2469676766E+00, 1.7369403772E+01, 3.6292355955E+00, 9.6655783262E-01],
	[3.8200000000E+04, 3.6529520574E+01, 5.2470022332E+00, 1.7376781058E+01, 3.6296561290E+00, 9.6657246291E-01],
	[3.8205000000E+04, 3.6537828412E+01, 5.2470367855E+00, 1.7384160508E+01, 3.6300765494E+00, 9.6658708569E-01],
	[3.8210000000E+04, 3.6546137052E+01, 5.2470713336E+00, 1.7391542122E+01, 3.6304968566E+00, 9.6660170097E-01],
	[3.8215000000E+04, 3.6554446494E+01, 5.2471058773E+00, 1.7398925902E+01, 3.6309170506E+00, 9.6661630875E-01],
	[3.8220000000E+04, 3.6562756738E+01, 5.2471404168E+00, 1.7406311846E+01, 3.6313371315E+00, 9.6663090904E-01],
	[3.8225000000E+04, 3.6571067784E+01, 5.2471749519E+00, 1.7413699956E+01, 3.6317570993E+00, 9.6664550185E-01],
	[3.8230000000E+04, 3.6579379631E+01, 5.2472094828E+00, 1.7421090232E+01, 3.6321769540E+00, 9.6666008717E-01],
	[3.8235000000E+04, 3.6587692280E+01, 5.2472440094E+00, 1.7428482674E+01, 3.6325966957E+00, 9.6667466501E-01],
	[3.8240000000E+04, 3.6596005731E+01, 5.2472785317E+00, 1.7435877283E+01, 3.6330163243E+00, 9.6668923538E-01],
	[3.8245000000E+04, 3.6604319983E+01, 5.2473130497E+00, 1.7443274058E+01, 3.6334358399E+00, 9.6670379827E-01],
	[3.8250000000E+04, 3.6612635037E+01, 5.2473475634E+00, 1.7450673001E+01, 3.6338552426E+00, 9.6671835371E-01],
	[3.8255000000E+04, 3.6620950893E+01, 5.2473820728E+00, 1.7458074112E+01, 3.6342745323E+00, 9.6673290168E-01],
	[3.8260000000E+04, 3.6629267550E+01, 5.2474165780E+00, 1.7465477390E+01, 3.6346937092E+00, 9.6674744219E-01],
	[3.8265000000E+04, 3.6637585009E+01, 5.2474510789E+00, 1.7472882837E+01, 3.6351127731E+00, 9.6676197525E-01],
	[3.8270000000E+04, 3.6645903269E+01, 5.2474855754E+00, 1.7480290453E+01, 3.6355317241E+00, 9.6677650087E-01],
	[3.8275000000E+04, 3.6654222331E+01, 5.2475200678E+00, 1.7487700238E+01, 3.6359505623E+00, 9.6679101904E-01],
	[3.8280000000E+04, 3.6662542194E+01, 5.2475545558E+00, 1.7495112192E+01, 3.6363692877E+00, 9.6680552977E-01],
	[3.8285000000E+04, 3.6670862859E+01, 5.2475890395E+00, 1.7502526316E+01, 3.6367879002E+00, 9.6682003307E-01],
	[3.8290000000E+04, 3.6679184325E+01, 5.2476235190E+00, 1.7509942610E+01, 3.6372064001E+00, 9.6683452893E-01],
	[3.8295000000E+04, 3.6687506593E+01, 5.2476579942E+00, 1.7517361074E+01, 3.6376247871E+00, 9.6684901737E-01],
	[3.8300000000E+04, 3.6695829662E+01, 5.2476924651E+00, 1.7524781709E+01, 3.6380430615E+00, 9.6686349839E-01],
	[3.8305000000E+04, 3.6704153532E+01, 5.2477269318E+00, 1.7532204516E+01, 3.6384612231E+00, 9.6687797199E-01],
	[3.8310000000E+04, 3.6712478204E+01, 5.2477613942E+00, 1.7539629494E+01, 3.6388792721E+00, 9.6689243818E-01],
	[3.8315000000E+04, 3.6720803676E+01, 5.2477958523E+00, 1.7547056643E+01, 3.6392972085E+00, 9.6690689696E-01],
	[3.8320000000E+04, 3.6729129951E+01, 5.2478303061E+00, 1.7554485965E+01, 3.6397150322E+00, 9.6692134833E-01],
	[3.8325000000E+04, 3.6737457026E+01, 5.2478647557E+00, 1.7561917460E+01, 3.6401327433E+00, 9.6693579231E-01],
	[3.8330000000E+04, 3.6745784903E+01, 5.2478992010E+00, 1.7569351127E+01, 3.6405503419E+00, 9.6695022889E-01],
	[3.8335000000E+04, 3.6754113580E+01, 5.2479336420E+00, 1.7576786968E+01, 3.6409678279E+00, 9.6696465808E-01],
	[3.8340000000E+04, 3.6762443059E+01, 5.2479680788E+00, 1.7584224982E+01, 3.6413852015E+00, 9.6697907988E-01],
	[3.8345000000E+04, 3.6770773339E+01, 5.2480025113E+00, 1.7591665171E+01, 3.6418024625E+00, 9.6699349430E-01],
	[3.8350000000E+04, 3.6779104420E+01, 5.2480369396E+00, 1.7599107533E+01, 3.6422196111E+00, 9.6700790134E-01],
	[3.8355000000E+04, 3.6787436303E+01, 5.2480713635E+00, 1.7606552070E+01, 3.6426366472E+00, 9.6702230100E-01],
	[3.8360000000E+04, 3.6795768986E+01, 5.2481057833E+00, 1.7613998782E+01, 3.6430535709E+00, 9.6703669330E-01],
	[3.8365000000E+04, 3.6804102470E+01, 5.2481401987E+00, 1.7621447670E+01, 3.6434703823E+00, 9.6705107823E-01],
	[3.8370000000E+04, 3.6812436755E+01, 5.2481746099E+00, 1.7628898733E+01, 3.6438870813E+00, 9.6706545580E-01],
	[3.8375000000E+04, 3.6820771842E+01, 5.2482090168E+00, 1.7636351973E+01, 3.6443036679E+00, 9.6707982602E-01],
	[3.8380000000E+04, 3.6829107729E+01, 5.2482434195E+00, 1.7643807388E+01, 3.6447201422E+00, 9.6709418888E-01],
	[3.8385000000E+04, 3.6837444417E+01, 5.2482778180E+00, 1.7651264981E+01, 3.6451365043E+00, 9.6710854440E-01],
	[3.8390000000E+04, 3.6845781906E+01, 5.2483122121E+00, 1.7658724750E+01, 3.6455527541E+00, 9.6712289257E-01],
	[3.8395000000E+04, 3.6854120196E+01, 5.2483466020E+00, 1.7666186698E+01, 3.6459688916E+00, 9.6713723340E-01],
	[3.8400000000E+04, 3.6862459286E+01, 5.2483809877E+00, 1.7673650822E+01, 3.6463849170E+00, 9.6715156690E-01],
	[3.8405000000E+04, 3.6870799178E+01, 5.2484153691E+00, 1.7681117125E+01, 3.6468008302E+00, 9.6716589307E-01],
	[3.8410000000E+04, 3.6879139870E+01, 5.2484497463E+00, 1.7688585607E+01, 3.6472166312E+00, 9.6718021191E-01],
	[3.8415000000E+04, 3.6887481363E+01, 5.2484841192E+00, 1.7696056267E+01, 3.6476323201E+00, 9.6719452343E-01],
	[3.8420000000E+04, 3.6895823656E+01, 5.2485184879E+00, 1.7703529107E+01, 3.6480478968E+00, 9.6720882763E-01],
	[3.8425000000E+04, 3.6904166750E+01, 5.2485528523E+00, 1.7711004126E+01, 3.6484633615E+00, 9.6722312452E-01],
	[3.8430000000E+04, 3.6912510645E+01, 5.2485872124E+00, 1.7718481325E+01, 3.6488787142E+00, 9.6723741409E-01],
	[3.8435000000E+04, 3.6920855341E+01, 5.2486215684E+00, 1.7725960705E+01, 3.6492939548E+00, 9.6725169637E-01],
	[3.8440000000E+04, 3.6929200837E+01, 5.2486559200E+00, 1.7733442265E+01, 3.6497090834E+00, 9.6726597134E-01],
	[3.8445000000E+04, 3.6937547134E+01, 5.2486902675E+00, 1.7740926006E+01, 3.6501241001E+00, 9.6728023902E-01],
	[3.8450000000E+04, 3.6945894231E+01, 5.2487246107E+00, 1.7748411928E+01, 3.6505390048E+00, 9.6729449941E-01],
	[3.8455000000E+04, 3.6954242129E+01, 5.2487589496E+00, 1.7755900032E+01, 3.6509537976E+00, 9.6730875251E-01],
	[3.8460000000E+04, 3.6962590827E+01, 5.2487932843E+00, 1.7763390318E+01, 3.6513684784E+00, 9.6732299833E-01],
	[3.8465000000E+04, 3.6970940326E+01, 5.2488276148E+00, 1.7770882786E+01, 3.6517830474E+00, 9.6733723686E-01],
	[3.8470000000E+04, 3.6979290625E+01, 5.2488619411E+00, 1.7778377437E+01, 3.6521975046E+00, 9.6735146813E-01],
	[3.8475000000E+04, 3.6987641725E+01, 5.2488962631E+00, 1.7785874272E+01, 3.6526118499E+00, 9.6736569212E-01],
	[3.8480000000E+04, 3.6995993625E+01, 5.2489305808E+00, 1.7793373289E+01, 3.6530260834E+00, 9.6737990885E-01],
	[3.8485000000E+04, 3.7004346325E+01, 5.2489648944E+00, 1.7800874490E+01, 3.6534402052E+00, 9.6739411831E-01],
	[3.8490000000E+04, 3.7012699826E+01, 5.2489992037E+00, 1.7808377876E+01, 3.6538542152E+00, 9.6740832052E-01],
	[3.8495000000E+04, 3.7021054127E+01, 5.2490335087E+00, 1.7815883446E+01, 3.6542681135E+00, 9.6742251548E-01],
	[3.8500000000E+04, 3.7029409228E+01, 5.2490678095E+00, 1.7823391201E+01, 3.6546819001E+00, 9.6743670319E-01],
	[3.8505000000E+04, 3.7037765130E+01, 5.2491021062E+00, 1.7830901141E+01, 3.6550955750E+00, 9.6745088365E-01],
	[3.8510000000E+04, 3.7046121831E+01, 5.2491363985E+00, 1.7838413266E+01, 3.6555091383E+00, 9.6746505687E-01],
	[3.8515000000E+04, 3.7054479333E+01, 5.2491706867E+00, 1.7845927577E+01, 3.6559225900E+00, 9.6747922286E-01],
	[3.8520000000E+04, 3.7062837635E+01, 5.2492049706E+00, 1.7853444075E+01, 3.6563359301E+00, 9.6749338161E-01],
	[3.8525000000E+04, 3.7071196738E+01, 5.2492392503E+00, 1.7860962759E+01, 3.6567491586E+00, 9.6750753314E-01],
	[3.8530000000E+04, 3.7079556640E+01, 5.2492735258E+00, 1.7868483630E+01, 3.6571622756E+00, 9.6752167745E-01],
	[3.8535000000E+04, 3.7087917342E+01, 5.2493077970E+00, 1.7876006688E+01, 3.6575752811E+00, 9.6753581453E-01],
	[3.8540000000E+04, 3.7096278845E+01, 5.2493420640E+00, 1.7883531934E+01, 3.6579881750E+00, 9.6754994444E-01],
	[3.8545000000E+04, 3.7104641147E+01, 5.2493763268E+00, 1.7891059368E+01, 3.6584009575E+00, 9.6756406718E-01],
	[3.8550000000E+04, 3.7113004250E+01, 5.2494105854E+00, 1.7898588991E+01, 3.6588136286E+00, 9.6757818277E-01],
	[3.8555000000E+04, 3.7121368152E+01, 5.2494448398E+00, 1.7906120802E+01, 3.6592261883E+00, 9.6759229120E-01],
	[3.8560000000E+04, 3.7129732855E+01, 5.2494790899E+00, 1.7913654802E+01, 3.6596386366E+00, 9.6760639248E-01],
	[3.8565000000E+04, 3.7138098357E+01, 5.2495133358E+00, 1.7921190991E+01, 3.6600509735E+00, 9.6762048661E-01],
	[3.8570000000E+04, 3.7146464660E+01, 5.2495475775E+00, 1.7928729370E+01, 3.6604631991E+00, 9.6763457360E-01],
	[3.8575000000E+04, 3.7154831762E+01, 5.2495818150E+00, 1.7936269940E+01, 3.6608753134E+00, 9.6764865344E-01],
	[3.8580000000E+04, 3.7163199664E+01, 5.2496160483E+00, 1.7943812699E+01, 3.6612873164E+00, 9.6766272615E-01],
	[3.8585000000E+04, 3.7171568365E+01, 5.2496502774E+00, 1.7951357650E+01, 3.6616992081E+00, 9.6767679173E-01],
	[3.8590000000E+04, 3.7179937867E+01, 5.2496845022E+00, 1.7958904791E+01, 3.6621109886E+00, 9.6769085018E-01],
	[3.8595000000E+04, 3.7188308168E+01, 5.2497187229E+00, 1.7966454124E+01, 3.6625226579E+00, 9.6770490150E-01],
	[3.8600000000E+04, 3.7196679269E+01, 5.2497529393E+00, 1.7974005649E+01, 3.6629342161E+00, 9.6771894569E-01],
	[3.8605000000E+04, 3.7205051170E+01, 5.2497871515E+00, 1.7981559366E+01, 3.6633456631E+00, 9.6773298277E-01],
	[3.8610000000E+04, 3.7213423870E+01, 5.2498213595E+00, 1.7989115276E+01, 3.6637569989E+00, 9.6774701274E-01],
	[3.8615000000E+04, 3.7221797370E+01, 5.2498555633E+00, 1.7996673379E+01, 3.6641682237E+00, 9.6776103559E-01],
	[3.8620000000E+04, 3.7230191007E+01, 5.2498919078E+00, 1.8004233674E+01, 3.6645805698E+00, 9.6777505133E-01],
	[3.8625000000E+04, 3.7238585769E+01, 5.2499282833E+00, 1.8011796164E+01, 3.6649928255E+00, 9.6778905997E-01],
	[3.8630000000E+04, 3.7246981336E+01, 5.2499646543E+00, 1.8019360847E+01, 3.6654049705E+00, 9.6780306151E-01],
	[3.8635000000E+04, 3.7255377709E+01, 5.2500010208E+00, 1.8026927725E+01, 3.6658170047E+00, 9.6781705596E-01],
	[3.8640000000E+04, 3.7263774888E+01, 5.2500373829E+00, 1.8034496797E+01, 3.6662289284E+00, 9.6783104331E-01],
	[3.8645000000E+04, 3.7272172873E+01, 5.2500737406E+00, 1.8042068065E+01, 3.6666407413E+00, 9.6784502357E-01],
	[3.8650000000E+04, 3.7280571664E+01, 5.2501100938E+00, 1.8049641527E+01, 3.6670524437E+00, 9.6785899674E-01],
	[3.8655000000E+04, 3.7288971261E+01, 5.2501464425E+00, 1.8057217186E+01, 3.6674640354E+00, 9.6787296284E-01],
	[3.8660000000E+04, 3.7297371663E+01, 5.2501827868E+00, 1.8064795040E+01, 3.6678755166E+00, 9.6788692185E-01],
	[3.8665000000E+04, 3.7305772871E+01, 5.2502191266E+00, 1.8072375091E+01, 3.6682868872E+00, 9.6790087379E-01],
	[3.8670000000E+04, 3.7314174884E+01, 5.2502554620E+00, 1.8079957338E+01, 3.6686981474E+00, 9.6791481865E-01],
	[3.8675000000E+04, 3.7322577703E+01, 5.2502917930E+00, 1.8087541783E+01, 3.6691092970E+00, 9.6792875645E-01],
	[3.8680000000E+04, 3.7330981328E+01, 5.2503281195E+00, 1.8095128425E+01, 3.6695203361E+00, 9.6794268719E-01],
	[3.8685000000E+04, 3.7339385758E+01, 5.2503644415E+00, 1.8102717265E+01, 3.6699312649E+00, 9.6795661086E-01],
	[3.8690000000E+04, 3.7347790994E+01, 5.2504007591E+00, 1.8110308303E+01, 3.6703420832E+00, 9.6797052748E-01],
	[3.8695000000E+04, 3.7356197035E+01, 5.2504370723E+00, 1.8117901540E+01, 3.6707527911E+00, 9.6798443705E-01],
	[3.8700000000E+04, 3.7364603882E+01, 5.2504733810E+00, 1.8125496975E+01, 3.6711633886E+00, 9.6799833956E-01],
	[3.8705000000E+04, 3.7373011535E+01, 5.2505096853E+00, 1.8133094610E+01, 3.6715738758E+00, 9.6801223503E-01],
	[3.8710000000E+04, 3.7381419993E+01, 5.2505459852E+00, 1.8140694444E+01, 3.6719842527E+00, 9.6802612346E-01],
	[3.8715000000E+04, 3.7389829256E+01, 5.2505822806E+00, 1.8148296479E+01, 3.6723945193E+00, 9.6804000485E-01],
	[3.8720000000E+04, 3.7398239324E+01, 5.2506185716E+00, 1.8155900713E+01, 3.6728046756E+00, 9.6805387920E-01],
	[3.8725000000E+04, 3.7406650198E+01, 5.2506548581E+00, 1.8163507148E+01, 3.6732147218E+00, 9.6806774652E-01],
	[3.8730000000E+04, 3.7415061878E+01, 5.2506911402E+00, 1.8171115784E+01, 3.6736246576E+00, 9.6808160682E-01],
	[3.8735000000E+04, 3.7423474362E+01, 5.2507274179E+00, 1.8178726622E+01, 3.6740344834E+00, 9.6809546009E-01],
	[3.8740000000E+04, 3.7431887652E+01, 5.2507636911E+00, 1.8186339661E+01, 3.6744441989E+00, 9.6810930634E-01],
	[3.8745000000E+04, 3.7440301747E+01, 5.2507999600E+00, 1.8193954902E+01, 3.6748538043E+00, 9.6812314557E-01],
	[3.8750000000E+04, 3.7448716648E+01, 5.2508362243E+00, 1.8201572345E+01, 3.6752632996E+00, 9.6813697779E-01],
	[3.8755000000E+04, 3.7457132353E+01, 5.2508724843E+00, 1.8209191991E+01, 3.6756726849E+00, 9.6815080301E-01],
	[3.8760000000E+04, 3.7465548864E+01, 5.2509087398E+00, 1.8216813841E+01, 3.6760819600E+00, 9.6816462121E-01],
	[3.8765000000E+04, 3.7473966180E+01, 5.2509449909E+00, 1.8224437893E+01, 3.6764911252E+00, 9.6817843241E-01],
	[3.8770000000E+04, 3.7482384301E+01, 5.2509812376E+00, 1.8232064150E+01, 3.6769001803E+00, 9.6819223662E-01],
	[3.8775000000E+04, 3.7490803227E+01, 5.2510174799E+00, 1.8239692610E+01, 3.6773091255E+00, 9.6820603383E-01],
	[3.8780000000E+04, 3.7499222958E+01, 5.2510537177E+00, 1.8247323276E+01, 3.6777179607E+00, 9.6821982405E-01],
	[3.8785000000E+04, 3.7507643495E+01, 5.2510899511E+00, 1.8254956145E+01, 3.6781266859E+00, 9.6823360728E-01],
	[3.8790000000E+04, 3.7516064836E+01, 5.2511261801E+00, 1.8262591221E+01, 3.6785353013E+00, 9.6824738352E-01],
	[3.8795000000E+04, 3.7524486982E+01, 5.2511624046E+00, 1.8270228501E+01, 3.6789438068E+00, 9.6826115279E-01],
	[3.8800000000E+04, 3.7532909933E+01, 5.2511986248E+00, 1.8277867988E+01, 3.6793522024E+00, 9.6827491508E-01],
	[3.8805000000E+04, 3.7541333690E+01, 5.2512348405E+00, 1.8285509681E+01, 3.6797604883E+00, 9.6828867039E-01],
	[3.8810000000E+04, 3.7549758251E+01, 5.2512710518E+00, 1.8293153580E+01, 3.6801686643E+00, 9.6830241874E-01],
	[3.8815000000E+04, 3.7558183617E+01, 5.2513072587E+00, 1.8300799686E+01, 3.6805767305E+00, 9.6831616012E-01],
	[3.8820000000E+04, 3.7566609787E+01, 5.2513434612E+00, 1.8308448000E+01, 3.6809846870E+00, 9.6832989454E-01],
	[3.8825000000E+04, 3.7575036763E+01, 5.2513796593E+00, 1.8316098521E+01, 3.6813925338E+00, 9.6834362200E-01],
	[3.8830000000E+04, 3.7583464543E+01, 5.2514158529E+00, 1.8323751250E+01, 3.6818002709E+00, 9.6835734250E-01],
	[3.8835000000E+04, 3.7591893129E+01, 5.2514520422E+00, 1.8331406188E+01, 3.6822078983E+00, 9.6837105605E-01],
	[3.8840000000E+04, 3.7600322519E+01, 5.2514882270E+00, 1.8339063334E+01, 3.6826154161E+00, 9.6838476266E-01],
	[3.8845000000E+04, 3.7608752713E+01, 5.2515244075E+00, 1.8346722690E+01, 3.6830228242E+00, 9.6839846232E-01],
	[3.8850000000E+04, 3.7617183713E+01, 5.2515605835E+00, 1.8354384254E+01, 3.6834301228E+00, 9.6841215504E-01],
	[3.8855000000E+04, 3.7625615517E+01, 5.2515967551E+00, 1.8362048029E+01, 3.6838373118E+00, 9.6842584082E-01],
	[3.8860000000E+04, 3.7634048125E+01, 5.2516329223E+00, 1.8369714014E+01, 3.6842443912E+00, 9.6843951967E-01],
	[3.8865000000E+04, 3.7642481538E+01, 5.2516690851E+00, 1.8377382209E+01, 3.6846513611E+00, 9.6845319159E-01],
	[3.8870000000E+04, 3.7650915756E+01, 5.2517052435E+00, 1.8385052614E+01, 3.6850582216E+00, 9.6846685659E-01],
	[3.8875000000E+04, 3.7659350779E+01, 5.2517413975E+00, 1.8392725232E+01, 3.6854649726E+00, 9.6848051466E-01],
	[3.8880000000E+04, 3.7667786606E+01, 5.2517775471E+00, 1.8400400060E+01, 3.6858716141E+00, 9.6849416581E-01],
	[3.8885000000E+04, 3.7676223237E+01, 5.2518136923E+00, 1.8408077101E+01, 3.6862781462E+00, 9.6850781005E-01],
	[3.8890000000E+04, 3.7684660673E+01, 5.2518498331E+00, 1.8415756353E+01, 3.6866845690E+00, 9.6852144738E-01],
	[3.8895000000E+04, 3.7693098913E+01, 5.2518859695E+00, 1.8423437818E+01, 3.6870908823E+00, 9.6853507779E-01],
	[3.8900000000E+04, 3.7701537958E+01, 5.2519221015E+00, 1.8431121496E+01, 3.6874970864E+00, 9.6854870131E-01],
	[3.8905000000E+04, 3.7709977807E+01, 5.2519582292E+00, 1.8438807388E+01, 3.6879031811E+00, 9.6856231792E-01],
	[3.8910000000E+04, 3.7718418461E+01, 5.2519943524E+00, 1.8446495493E+01, 3.6883091666E+00, 9.6857592764E-01],
	[3.8915000000E+04, 3.7726859919E+01, 5.2520304712E+00, 1.8454185812E+01, 3.6887150427E+00, 9.6858953046E-01],
	[3.8920000000E+04, 3.7735302181E+01, 5.2520665856E+00, 1.8461878345E+01, 3.6891208097E+00, 9.6860312639E-01],
	[3.8925000000E+04, 3.7743745248E+01, 5.2521026957E+00, 1.8469573093E+01, 3.6895264675E+00, 9.6861671544E-01],
	[3.8930000000E+04, 3.7752189119E+01, 5.2521388013E+00, 1.8477270056E+01, 3.6899320160E+00, 9.6863029760E-01],
	[3.8935000000E+04, 3.7760633794E+01, 5.2521749026E+00, 1.8484969235E+01, 3.6903374555E+00, 9.6864387289E-01],
	[3.8940000000E+04, 3.7769079273E+01, 5.2522109995E+00, 1.8492670629E+01, 3.6907427857E+00, 9.6865744130E-01],
	[3.8945000000E+04, 3.7777525556E+01, 5.2522470920E+00, 1.8500374239E+01, 3.6911480069E+00, 9.6867100284E-01],
	[3.8950000000E+04, 3.7785972644E+01, 5.2522831801E+00, 1.8508080066E+01, 3.6915531190E+00, 9.6868455751E-01],
	[3.8955000000E+04, 3.7794420536E+01, 5.2523192638E+00, 1.8515788109E+01, 3.6919581221E+00, 9.6869810531E-01],
	[3.8960000000E+04, 3.7802869231E+01, 5.2523553431E+00, 1.8523498370E+01, 3.6923630161E+00, 9.6871164625E-01],
	[3.8965000000E+04, 3.7811318731E+01, 5.2523914181E+00, 1.8531210848E+01, 3.6927678012E+00, 9.6872518034E-01],
	[3.8970000000E+04, 3.7819769035E+01, 5.2524274886E+00, 1.8538925544E+01, 3.6931724772E+00, 9.6873870757E-01],
	[3.8975000000E+04, 3.7828220143E+01, 5.2524635548E+00, 1.8546642458E+01, 3.6935770444E+00, 9.6875222796E-01],
	[3.8980000000E+04, 3.7836672055E+01, 5.2524996166E+00, 1.8554361590E+01, 3.6939815025E+00, 9.6876574149E-01],
	[3.8985000000E+04, 3.7845124771E+01, 5.2525356741E+00, 1.8562082942E+01, 3.6943858518E+00, 9.6877924819E-01],
	[3.8990000000E+04, 3.7853578291E+01, 5.2525717271E+00, 1.8569806513E+01, 3.6947900923E+00, 9.6879274804E-01],
	[3.8995000000E+04, 3.7862032615E+01, 5.2526077758E+00, 1.8577532303E+01, 3.6951942238E+00, 9.6880624106E-01],
	[3.9000000000E+04, 3.7870487743E+01, 5.2526438201E+00, 1.8585260313E+01, 3.6955982466E+00, 9.6881972725E-01],
	[3.9005000000E+04, 3.7878943674E+01, 5.2526798601E+00, 1.8592990544E+01, 3.6960021606E+00, 9.6883320660E-01],
	[3.9010000000E+04, 3.7887400410E+01, 5.2527158956E+00, 1.8600722995E+01, 3.6964059658E+00, 9.6884667914E-01],
	[3.9015000000E+04, 3.7895857949E+01, 5.2527519268E+00, 1.8608457668E+01, 3.6968096623E+00, 9.6886014485E-01],
	[3.9020000000E+04, 3.7904316292E+01, 5.2527879536E+00, 1.8616194561E+01, 3.6972132500E+00, 9.6887360374E-01],
	[3.9025000000E+04, 3.7912775439E+01, 5.2528239761E+00, 1.8623933677E+01, 3.6976167291E+00, 9.6888705582E-01],
	[3.9030000000E+04, 3.7921235389E+01, 5.2528599942E+00, 1.8631675014E+01, 3.6980200995E+00, 9.6890050109E-01],
	[3.9035000000E+04, 3.7929696143E+01, 5.2528960079E+00, 1.8639418574E+01, 3.6984233612E+00, 9.6891393955E-01],
	[3.9040000000E+04, 3.7938157701E+01, 5.2529320173E+00, 1.8647164357E+01, 3.6988265144E+00, 9.6892737121E-01],
	[3.9045000000E+04, 3.7946620063E+01, 5.2529680222E+00, 1.8654912362E+01, 3.6992295589E+00, 9.6894079607E-01],
	[3.9050000000E+04, 3.7955083228E+01, 5.2530040229E+00, 1.8662662592E+01, 3.6996324949E+00, 9.6895421414E-01],
	[3.9055000000E+04, 3.7963547197E+01, 5.2530400191E+00, 1.8670415045E+01, 3.7000353224E+00, 9.6896762541E-01],
	[3.9060000000E+04, 3.7972011969E+01, 5.2530760110E+00, 1.8678169722E+01, 3.7004380414E+00, 9.6898102989E-01],
	[3.9065000000E+04, 3.7980477545E+01, 5.2531119986E+00, 1.8685926624E+01, 3.7008406519E+00, 9.6899442759E-01],
	[3.9070000000E+04, 3.7988943925E+01, 5.2531479817E+00, 1.8693685750E+01, 3.7012431539E+00, 9.6900781850E-01],
	[3.9075000000E+04, 3.7997411107E+01, 5.2531839606E+00, 1.8701447102E+01, 3.7016455475E+00, 9.6902120264E-01],
	[3.9080000000E+04, 3.8005879094E+01, 5.2532199350E+00, 1.8709210680E+01, 3.7020478327E+00, 9.6903458000E-01],
	[3.9085000000E+04, 3.8014347884E+01, 5.2532559051E+00, 1.8716976483E+01, 3.7024500095E+00, 9.6904795059E-01],
	[3.9090000000E+04, 3.8022817477E+01, 5.2532918709E+00, 1.8724744513E+01, 3.7028520780E+00, 9.6906131442E-01],
	[3.9095000000E+04, 3.8031287873E+01, 5.2533278323E+00, 1.8732514769E+01, 3.7032540381E+00, 9.6907467148E-01],
	[3.9100000000E+04, 3.8039759073E+01, 5.2533637893E+00, 1.8740287252E+01, 3.7036558899E+00, 9.6908802178E-01],
	[3.9105000000E+04, 3.8048231077E+01, 5.2533997420E+00, 1.8748061963E+01, 3.7040576335E+00, 9.6910136532E-01],
	[3.9110000000E+04, 3.8056703883E+01, 5.2534356904E+00, 1.8755838901E+01, 3.7044592688E+00, 9.6911470211E-01],
	[3.9115000000E+04, 3.8065177493E+01, 5.2534716344E+00, 1.8763618067E+01, 3.7048607959E+00, 9.6912803215E-01],
	[3.9120000000E+04, 3.8073651906E+01, 5.2535075740E+00, 1.8771399462E+01, 3.7052622148E+00, 9.6914135545E-01],
	[3.9125000000E+04, 3.8082127123E+01, 5.2535435093E+00, 1.8779183086E+01, 3.7056635255E+00, 9.6915467200E-01],
	[3.9130000000E+04, 3.8090603142E+01, 5.2535794403E+00, 1.8786968938E+01, 3.7060647281E+00, 9.6916798182E-01],
	[3.9135000000E+04, 3.8099079965E+01, 5.2536153669E+00, 1.8794757020E+01, 3.7064658226E+00, 9.6918128490E-01],
	[3.9140000000E+04, 3.8107557591E+01, 5.2536512891E+00, 1.8802547332E+01, 3.7068668089E+00, 9.6919458125E-01],
	[3.9145000000E+04, 3.8116036020E+01, 5.2536872071E+00, 1.8810339874E+01, 3.7072676872E+00, 9.6920787087E-01],
	[3.9150000000E+04, 3.8124515252E+01, 5.2537231206E+00, 1.8818134647E+01, 3.7076684575E+00, 9.6922115376E-01],
	[3.9155000000E+04, 3.8132995287E+01, 5.2537590299E+00, 1.8825931650E+01, 3.7080691197E+00, 9.6923442994E-01],
	[3.9160000000E+04, 3.8141476125E+01, 5.2537949348E+00, 1.8833730885E+01, 3.7084696740E+00, 9.6924769940E-01],
	[3.9165000000E+04, 3.8149957767E+01, 5.2538308353E+00, 1.8841532351E+01, 3.7088701203E+00, 9.6926096214E-01],
	[3.9170000000E+04, 3.8158440211E+01, 5.2538667315E+00, 1.8849336049E+01, 3.7092704586E+00, 9.6927421818E-01],
	[3.9175000000E+04, 3.8166923458E+01, 5.2539026234E+00, 1.8857141980E+01, 3.7096706891E+00, 9.6928746751E-01],
	[3.9180000000E+04, 3.8175407508E+01, 5.2539385110E+00, 1.8864950143E+01, 3.7100708117E+00, 9.6930071013E-01],
	[3.9185000000E+04, 3.8183892361E+01, 5.2539743942E+00, 1.8872760539E+01, 3.7104708264E+00, 9.6931394606E-01],
	[3.9190000000E+04, 3.8192378017E+01, 5.2540102731E+00, 1.8880573168E+01, 3.7108707332E+00, 9.6932717529E-01],
	[3.9195000000E+04, 3.8200864476E+01, 5.2540461476E+00, 1.8888388031E+01, 3.7112705323E+00, 9.6934039783E-01],
	[3.9200000000E+04, 3.8209351737E+01, 5.2540820178E+00, 1.8896205128E+01, 3.7116702236E+00, 9.6935361368E-01],
	[3.9205000000E+04, 3.8217839802E+01, 5.2541178837E+00, 1.8904024459E+01, 3.7120698071E+00, 9.6936682285E-01],
	[3.9210000000E+04, 3.8226328669E+01, 5.2541537453E+00, 1.8911846025E+01, 3.7124692829E+00, 9.6938002533E-01],
	[3.9215000000E+04, 3.8234818339E+01, 5.2541896025E+00, 1.8919669827E+01, 3.7128686510E+00, 9.6939322114E-01],
	[3.9220000000E+04, 3.8243308812E+01, 5.2542254554E+00, 1.8927495863E+01, 3.7132679114E+00, 9.6940641027E-01],
	[3.9225000000E+04, 3.8251800087E+01, 5.2542613040E+00, 1.8935324136E+01, 3.7136670642E+00, 9.6941959273E-01],
	[3.9230000000E+04, 3.8260292165E+01, 5.2542971482E+00, 1.8943154644E+01, 3.7140661093E+00, 9.6943276853E-01],
	[3.9235000000E+04, 3.8268785046E+01, 5.2543329882E+00, 1.8950987390E+01, 3.7144650469E+00, 9.6944593766E-01],
	[3.9240000000E+04, 3.8277291423E+01, 5.2543702177E+00, 1.8958822371E+01, 3.7148646931E+00, 9.6945910013E-01],
	[3.9245000000E+04, 3.8285805332E+01, 5.2544081810E+00, 1.8966659591E+01, 3.7152646645E+00, 9.6947225594E-01],
	[3.9250000000E+04, 3.8294320050E+01, 5.2544461397E+00, 1.8974499047E+01, 3.7156645286E+00, 9.6948540511E-01],
	[3.9255000000E+04, 3.8302835577E+01, 5.2544840939E+00, 1.8982340742E+01, 3.7160642855E+00, 9.6949854762E-01],
	[3.9260000000E+04, 3.8311351912E+01, 5.2545220436E+00, 1.8990184675E+01, 3.7164639353E+00, 9.6951168349E-01],
	[3.9265000000E+04, 3.8319869057E+01, 5.2545599887E+00, 1.8998030846E+01, 3.7168634778E+00, 9.6952481271E-01],
	[3.9270000000E+04, 3.8328387009E+01, 5.2545979292E+00, 1.9005879257E+01, 3.7172629133E+00, 9.6953793530E-01],
	[3.9275000000E+04, 3.8336905770E+01, 5.2546358652E+00, 1.9013729907E+01, 3.7176622416E+00, 9.6955105125E-01],
	[3.9280000000E+04, 3.8345425340E+01, 5.2546737966E+00, 1.9021582796E+01, 3.7180614628E+00, 9.6956416057E-01],
	[3.9285000000E+04, 3.8353945719E+01, 5.2547117234E+00, 1.9029437925E+01, 3.7184605770E+00, 9.6957726327E-01],
	[3.9290000000E+04, 3.8362466905E+01, 5.2547496457E+00, 1.9037295295E+01, 3.7188595841E+00, 9.6959035933E-01],
	[3.9295000000E+04, 3.8370988901E+01, 5.2547875635E+00, 1.9045154906E+01, 3.7192584843E+00, 9.6960344878E-01],
	[3.9300000000E+04, 3.8379511705E+01, 5.2548254767E+00, 1.9053016757E+01, 3.7196572774E+00, 9.6961653161E-01],
	[3.9305000000E+04, 3.8388035317E+01, 5.2548633853E+00, 1.9060880851E+01, 3.7200559636E+00, 9.6962960783E-01],
	[3.9310000000E+04, 3.8396559737E+01, 5.2549012894E+00, 1.9068747185E+01, 3.7204545429E+00, 9.6964267744E-01],
	[3.9315000000E+04, 3.8405084966E+01, 5.2549391890E+00, 1.9076615762E+01, 3.7208530153E+00, 9.6965574044E-01],
	[3.9320000000E+04, 3.8413611004E+01, 5.2549770840E+00, 1.9084486582E+01, 3.7212513808E+00, 9.6966879684E-01],
	[3.9325000000E+04, 3.8422137849E+01, 5.2550149745E+00, 1.9092359644E+01, 3.7216496394E+00, 9.6968184663E-01],
	[3.9330000000E+04, 3.8430665503E+01, 5.2550528604E+00, 1.9100234950E+01, 3.7220477912E+00, 9.6969488984E-01],
	[3.9335000000E+04, 3.8439193966E+01, 5.2550907418E+00, 1.9108112499E+01, 3.7224458362E+00, 9.6970792645E-01],
	[3.9340000000E+04, 3.8447723236E+01, 5.2551286186E+00, 1.9115992292E+01, 3.7228437745E+00, 9.6972095647E-01],
	[3.9345000000E+04, 3.8456253315E+01, 5.2551664909E+00, 1.9123874329E+01, 3.7232416059E+00, 9.6973397991E-01],
	[3.9350000000E+04, 3.8464784202E+01, 5.2552043587E+00, 1.9131758611E+01, 3.7236393307E+00, 9.6974699676E-01],
	[3.9355000000E+04, 3.8473315897E+01, 5.2552422219E+00, 1.9139645137E+01, 3.7240369488E+00, 9.6976000704E-01],
	[3.9360000000E+04, 3.8481848400E+01, 5.2552800806E+00, 1.9147533909E+01, 3.7244344602E+00, 9.6977301074E-01],
	[3.9365000000E+04, 3.8490381712E+01, 5.2553179347E+00, 1.9155424927E+01, 3.7248318649E+00, 9.6978600787E-01],
	[3.9370000000E+04, 3.8498915831E+01, 5.2553557843E+00, 1.9163318191E+01, 3.7252291631E+00, 9.6979899844E-01],
	[3.9375000000E+04, 3.8507450759E+01, 5.2553936294E+00, 1.9171213701E+01, 3.7256263546E+00, 9.6981198244E-01],
	[3.9380000000E+04, 3.8515986494E+01, 5.2554314699E+00, 1.9179111458E+01, 3.7260234396E+00, 9.6982495988E-01],
	[3.9385000000E+04, 3.8524523038E+01, 5.2554693059E+00, 1.9187011462E+01, 3.7264204180E+00, 9.6983793076E-01],
	[3.9390000000E+04, 3.8533060389E+01, 5.2555071374E+00, 1.9194913713E+01, 3.7268172899E+00, 9.6985089509E-01],
	[3.9395000000E+04, 3.8541598549E+01, 5.2555449644E+00, 1.9202818212E+01, 3.7272140553E+00, 9.6986385287E-01],
	[3.9400000000E+04, 3.8550137516E+01, 5.2555827868E+00, 1.9210724959E+01, 3.7276107143E+00, 9.6987680410E-01],
	[3.9405000000E+04, 3.8558677292E+01, 5.2556206047E+00, 1.9218633955E+01, 3.7280072668E+00, 9.6988974879E-01],
	[3.9410000000E+04, 3.8567217875E+01, 5.2556584180E+00, 1.9226545199E+01, 3.7284037129E+00, 9.6990268695E-01],
	[3.9415000000E+04, 3.8575759266E+01, 5.2556962269E+00, 1.9234458693E+01, 3.7288000527E+00, 9.6991561856E-01],
	[3.9420000000E+04, 3.8584301465E+01, 5.2557340312E+00, 1.9242374436E+01, 3.7291962860E+00, 9.6992854365E-01],
	[3.9425000000E+04, 3.8592844472E+01, 5.2557718310E+00, 1.9250292429E+01, 3.7295924130E+00, 9.6994146220E-01],
	[3.9430000000E+04, 3.8601388286E+01, 5.2558096263E+00, 1.9258212673E+01, 3.7299884338E+00, 9.6995437424E-01],
	[3.9435000000E+04, 3.8609932908E+01, 5.2558474170E+00, 1.9266135167E+01, 3.7303843482E+00, 9.6996727975E-01],
	[3.9440000000E+04, 3.8618478338E+01, 5.2558852032E+00, 1.9274059912E+01, 3.7307801564E+00, 9.6998017874E-01],
	[3.9445000000E+04, 3.8627024576E+01, 5.2559229850E+00, 1.9281986908E+01, 3.7311758583E+00, 9.6999307122E-01],
	[3.9450000000E+04, 3.8635571621E+01, 5.2559607622E+00, 1.9289916156E+01, 3.7315714541E+00, 9.7000595718E-01],
	[3.9455000000E+04, 3.8644119474E+01, 5.2559985348E+00, 1.9297847656E+01, 3.7319669437E+00, 9.7001883664E-01],
	[3.9460000000E+04, 3.8652668135E+01, 5.2560363030E+00, 1.9305781408E+01, 3.7323623271E+00, 9.7003170960E-01],
	[3.9465000000E+04, 3.8661217603E+01, 5.2560740667E+00, 1.9313717413E+01, 3.7327576044E+00, 9.7004457605E-01],
	[3.9470000000E+04, 3.8669767879E+01, 5.2561118258E+00, 1.9321655671E+01, 3.7331527755E+00, 9.7005743601E-01],
	[3.9475000000E+04, 3.8678318962E+01, 5.2561495804E+00, 1.9329596182E+01, 3.7335478407E+00, 9.7007028948E-01],
	[3.9480000000E+04, 3.8686870853E+01, 5.2561873305E+00, 1.9337538948E+01, 3.7339427997E+00, 9.7008313646E-01],
	[3.9485000000E+04, 3.8695423551E+01, 5.2562250761E+00, 1.9345483967E+01, 3.7343376528E+00, 9.7009597695E-01],
	[3.9490000000E+04, 3.8703977057E+01, 5.2562628172E+00, 1.9353431241E+01, 3.7347323998E+00, 9.7010881095E-01],
	[3.9495000000E+04, 3.8712531371E+01, 5.2563005538E+00, 1.9361380769E+01, 3.7351270409E+00, 9.7012163848E-01],
	[3.9500000000E+04, 3.8721086491E+01, 5.2563382859E+00, 1.9369332553E+01, 3.7355215760E+00, 9.7013445954E-01],
	[3.9505000000E+04, 3.8729642419E+01, 5.2563760135E+00, 1.9377286593E+01, 3.7359160052E+00, 9.7014727412E-01],
	[3.9510000000E+04, 3.8738199155E+01, 5.2564137366E+00, 1.9385242888E+01, 3.7363103285E+00, 9.7016008223E-01],
	[3.9515000000E+04, 3.8746756697E+01, 5.2564514552E+00, 1.9393201439E+01, 3.7367045460E+00, 9.7017288388E-01],
	[3.9520000000E+04, 3.8755315047E+01, 5.2564891692E+00, 1.9401162247E+01, 3.7370986576E+00, 9.7018567906E-01],
	[3.9525000000E+04, 3.8763874205E+01, 5.2565268788E+00, 1.9409125312E+01, 3.7374926633E+00, 9.7019846779E-01],
	[3.9530000000E+04, 3.8772434169E+01, 5.2565645839E+00, 1.9417090635E+01, 3.7378865633E+00, 9.7021125007E-01],
	[3.9535000000E+04, 3.8780994941E+01, 5.2566022844E+00, 1.9425058215E+01, 3.7382803576E+00, 9.7022402589E-01],
	[3.9540000000E+04, 3.8789556520E+01, 5.2566399805E+00, 1.9433028053E+01, 3.7386740461E+00, 9.7023679526E-01],
	[3.9545000000E+04, 3.8798118907E+01, 5.2566776721E+00, 1.9441000149E+01, 3.7390676288E+00, 9.7024955820E-01],
	[3.9550000000E+04, 3.8806682100E+01, 5.2567153592E+00, 1.9448974504E+01, 3.7394611059E+00, 9.7026231469E-01],
	[3.9555000000E+04, 3.8815246100E+01, 5.2567530418E+00, 1.9456951118E+01, 3.7398544774E+00, 9.7027506474E-01],
	[3.9560000000E+04, 3.8823810908E+01, 5.2567907199E+00, 1.9464929992E+01, 3.7402477432E+00, 9.7028780836E-01],
	[3.9565000000E+04, 3.8832376523E+01, 5.2568283935E+00, 1.9472911125E+01, 3.7406409034E+00, 9.7030054555E-01],
	[3.9570000000E+04, 3.8840942944E+01, 5.2568660626E+00, 1.9480894518E+01, 3.7410339580E+00, 9.7031327632E-01],
	[3.9575000000E+04, 3.8849510173E+01, 5.2569037272E+00, 1.9488880172E+01, 3.7414269070E+00, 9.7032600066E-01],
	[3.9580000000E+04, 3.8858078209E+01, 5.2569413873E+00, 1.9496868087E+01, 3.7418197505E+00, 9.7033871858E-01],
	[3.9585000000E+04, 3.8866647052E+01, 5.2569790430E+00, 1.9504858263E+01, 3.7422124886E+00, 9.7035143009E-01],
	[3.9590000000E+04, 3.8875216701E+01, 5.2570166942E+00, 1.9512850700E+01, 3.7426051211E+00, 9.7036413518E-01],
	[3.9595000000E+04, 3.8883787158E+01, 5.2570543408E+00, 1.9520845400E+01, 3.7429976482E+00, 9.7037683387E-01],
	[3.9600000000E+04, 3.8892358421E+01, 5.2570919830E+00, 1.9528842361E+01, 3.7433900698E+00, 9.7038952615E-01],
	[3.9605000000E+04, 3.8900930492E+01, 5.2571296207E+00, 1.9536841585E+01, 3.7437823861E+00, 9.7040221203E-01],
	[3.9610000000E+04, 3.8909503369E+01, 5.2571672540E+00, 1.9544843072E+01, 3.7441745970E+00, 9.7041489151E-01],
	[3.9615000000E+04, 3.8918077053E+01, 5.2572048827E+00, 1.9552846823E+01, 3.7445667025E+00, 9.7042756460E-01],
	[3.9620000000E+04, 3.8926651544E+01, 5.2572425070E+00, 1.9560852837E+01, 3.7449587027E+00, 9.7044023129E-01],
	[3.9625000000E+04, 3.8935226841E+01, 5.2572801268E+00, 1.9568861115E+01, 3.7453505977E+00, 9.7045289160E-01],
	[3.9630000000E+04, 3.8943802946E+01, 5.2573177421E+00, 1.9576871657E+01, 3.7457423873E+00, 9.7046554552E-01],
	[3.9635000000E+04, 3.8952379857E+01, 5.2573553529E+00, 1.9584884464E+01, 3.7461340717E+00, 9.7047819306E-01],
	[3.9640000000E+04, 3.8960957574E+01, 5.2573929593E+00, 1.9592899537E+01, 3.7465256509E+00, 9.7049083422E-01],
	[3.9645000000E+04, 3.8969536099E+01, 5.2574305612E+00, 1.9600916874E+01, 3.7469171249E+00, 9.7050346901E-01],
	[3.9650000000E+04, 3.8978115430E+01, 5.2574681586E+00, 1.9608936478E+01, 3.7473084937E+00, 9.7051609743E-01],
	[3.9655000000E+04, 3.8986695567E+01, 5.2575057515E+00, 1.9616958347E+01, 3.7476997574E+00, 9.7052871949E-01],
	[3.9660000000E+04, 3.8995276511E+01, 5.2575433400E+00, 1.9624982483E+01, 3.7480909159E+00, 9.7054133517E-01],
	[3.9665000000E+04, 3.9003858262E+01, 5.2575809240E+00, 1.9633008886E+01, 3.7484819694E+00, 9.7055394450E-01],
	[3.9670000000E+04, 3.9012440819E+01, 5.2576185035E+00, 1.9641037556E+01, 3.7488729178E+00, 9.7056654748E-01],
	[3.9675000000E+04, 3.9021024183E+01, 5.2576560786E+00, 1.9649068493E+01, 3.7492637612E+00, 9.7057914410E-01],
	[3.9680000000E+04, 3.9029608353E+01, 5.2576936492E+00, 1.9657101699E+01, 3.7496544996E+00, 9.7059173437E-01],
	[3.9685000000E+04, 3.9038193330E+01, 5.2577312153E+00, 1.9665137172E+01, 3.7500451330E+00, 9.7060431829E-01],
	[3.9690000000E+04, 3.9046779113E+01, 5.2577687770E+00, 1.9673174915E+01, 3.7504356614E+00, 9.7061689588E-01],
	[3.9695000000E+04, 3.9055365703E+01, 5.2578063342E+00, 1.9681214926E+01, 3.7508260849E+00, 9.7062946712E-01],
	[3.9700000000E+04, 3.9063953099E+01, 5.2578438869E+00, 1.9689257206E+01, 3.7512164034E+00, 9.7064203203E-01],
	[3.9705000000E+04, 3.9072541301E+01, 5.2578814352E+00, 1.9697301756E+01, 3.7516066171E+00, 9.7065459060E-01],
	[3.9710000000E+04, 3.9081130310E+01, 5.2579189790E+00, 1.9705348577E+01, 3.7519967260E+00, 9.7066714285E-01],
	[3.9715000000E+04, 3.9089720125E+01, 5.2579565184E+00, 1.9713397667E+01, 3.7523867300E+00, 9.7067968877E-01],
	[3.9720000000E+04, 3.9098310746E+01, 5.2579940533E+00, 1.9721449028E+01, 3.7527766292E+00, 9.7069222837E-01],
	[3.9725000000E+04, 3.9106902173E+01, 5.2580315837E+00, 1.9729502661E+01, 3.7531664237E+00, 9.7070476166E-01],
	[3.9730000000E+04, 3.9115494407E+01, 5.2580691097E+00, 1.9737558564E+01, 3.7535561133E+00, 9.7071728862E-01],
	[3.9735000000E+04, 3.9124087447E+01, 5.2581066312E+00, 1.9745616740E+01, 3.7539456983E+00, 9.7072980928E-01],
	[3.9740000000E+04, 3.9132681293E+01, 5.2581441483E+00, 1.9753677187E+01, 3.7543351786E+00, 9.7074232363E-01],
	[3.9745000000E+04, 3.9141275945E+01, 5.2581816610E+00, 1.9761739908E+01, 3.7547245542E+00, 9.7075483167E-01],
	[3.9750000000E+04, 3.9149871403E+01, 5.2582191691E+00, 1.9769804901E+01, 3.7551138251E+00, 9.7076733342E-01],
	[3.9755000000E+04, 3.9158467667E+01, 5.2582566729E+00, 1.9777872167E+01, 3.7555029914E+00, 9.7077982886E-01],
	[3.9760000000E+04, 3.9167064738E+01, 5.2582941721E+00, 1.9785941706E+01, 3.7558920531E+00, 9.7079231802E-01],
	[3.9765000000E+04, 3.9175662614E+01, 5.2583316670E+00, 1.9794013520E+01, 3.7562810103E+00, 9.7080480088E-01],
	[3.9770000000E+04, 3.9184261297E+01, 5.2583691574E+00, 1.9802087608E+01, 3.7566698629E+00, 9.7081727746E-01],
	[3.9775000000E+04, 3.9192860785E+01, 5.2584066433E+00, 1.9810163970E+01, 3.7570586110E+00, 9.7082974775E-01],
	[3.9780000000E+04, 3.9201461080E+01, 5.2584441248E+00, 1.9818242607E+01, 3.7574472546E+00, 9.7084221176E-01],
	[3.9785000000E+04, 3.9210062180E+01, 5.2584816018E+00, 1.9826323520E+01, 3.7578357938E+00, 9.7085466950E-01],
	[3.9790000000E+04, 3.9218664086E+01, 5.2585190744E+00, 1.9834406709E+01, 3.7582242285E+00, 9.7086712096E-01],
	[3.9795000000E+04, 3.9227266798E+01, 5.2585565426E+00, 1.9842492173E+01, 3.7586125587E+00, 9.7087956615E-01],
	[3.9800000000E+04, 3.9235870316E+01, 5.2585940063E+00, 1.9850579914E+01, 3.7590007847E+00, 9.7089200508E-01],
	[3.9805000000E+04, 3.9244474640E+01, 5.2586314656E+00, 1.9858669931E+01, 3.7593889062E+00, 9.7090443774E-01],
	[3.9810000000E+04, 3.9253079770E+01, 5.2586689205E+00, 1.9866762226E+01, 3.7597769234E+00, 9.7091686415E-01],
	[3.9815000000E+04, 3.9261685705E+01, 5.2587063709E+00, 1.9874856797E+01, 3.7601648363E+00, 9.7092928430E-01],
	[3.9820000000E+04, 3.9270292447E+01, 5.2587438169E+00, 1.9882953647E+01, 3.7605526449E+00, 9.7094169819E-01],
	[3.9825000000E+04, 3.9278899994E+01, 5.2587812584E+00, 1.9891052775E+01, 3.7609403493E+00, 9.7095410584E-01],
	[3.9830000000E+04, 3.9287508346E+01, 5.2588186955E+00, 1.9899154181E+01, 3.7613279494E+00, 9.7096650725E-01],
	[3.9835000000E+04, 3.9296117505E+01, 5.2588561282E+00, 1.9907257867E+01, 3.7617154453E+00, 9.7097890241E-01],
	[3.9840000000E+04, 3.9304727469E+01, 5.2588935564E+00, 1.9915363831E+01, 3.7621028371E+00, 9.7099129133E-01],
	[3.9845000000E+04, 3.9313338238E+01, 5.2589309802E+00, 1.9923472075E+01, 3.7624901247E+00, 9.7100367402E-01],
	[3.9850000000E+04, 3.9321949813E+01, 5.2589683996E+00, 1.9931582599E+01, 3.7628773081E+00, 9.7101605047E-01],
	[3.9855000000E+04, 3.9330562194E+01, 5.2590058146E+00, 1.9939695403E+01, 3.7632643875E+00, 9.7102842070E-01],
	[3.9860000000E+04, 3.9339175380E+01, 5.2590432251E+00, 1.9947810488E+01, 3.7636513628E+00, 9.7104078470E-01],
	[3.9865000000E+04, 3.9347789372E+01, 5.2590806312E+00, 1.9955927853E+01, 3.7640382340E+00, 9.7105314248E-01],
	[3.9870000000E+04, 3.9356410352E+01, 5.2591187046E+00, 1.9964047500E+01, 3.7644254020E+00, 9.7106549405E-01],
	[3.9875000000E+04, 3.9365045150E+01, 5.2591581872E+00, 1.9972169429E+01, 3.7648133095E+00, 9.7107783940E-01],
	[3.9880000000E+04, 3.9373680759E+01, 5.2591976651E+00, 1.9980293640E+01, 3.7652011132E+00, 9.7109017853E-01],
	[3.9885000000E+04, 3.9382317180E+01, 5.2592371384E+00, 1.9988420133E+01, 3.7655888133E+00, 9.7110251147E-01],
	[3.9890000000E+04, 3.9390954413E+01, 5.2592766070E+00, 1.9996548908E+01, 3.7659764098E+00, 9.7111483819E-01],
	[3.9895000000E+04, 3.9399592457E+01, 5.2593160710E+00, 2.0004679967E+01, 3.7663639026E+00, 9.7112715872E-01],
	[3.9900000000E+04, 3.9408231312E+01, 5.2593555303E+00, 2.0012813310E+01, 3.7667512918E+00, 9.7113947305E-01],
	[3.9905000000E+04, 3.9416870978E+01, 5.2593949850E+00, 2.0020948936E+01, 3.7671385774E+00, 9.7115178118E-01],
	[3.9910000000E+04, 3.9425511456E+01, 5.2594344350E+00, 2.0029086846E+01, 3.7675257595E+00, 9.7116408313E-01],
	[3.9915000000E+04, 3.9434152745E+01, 5.2594738804E+00, 2.0037227041E+01, 3.7679128380E+00, 9.7117637889E-01],
	[3.9920000000E+04, 3.9442794846E+01, 5.2595133211E+00, 2.0045369520E+01, 3.7682998131E+00, 9.7118866846E-01],
	[3.9925000000E+04, 3.9451437757E+01, 5.2595527572E+00, 2.0053514285E+01, 3.7686866847E+00, 9.7120095185E-01],
	[3.9930000000E+04, 3.9460081480E+01, 5.2595921886E+00, 2.0061661335E+01, 3.7690734528E+00, 9.7121322907E-01],
	[3.9935000000E+04, 3.9468726014E+01, 5.2596316154E+00, 2.0069810672E+01, 3.7694601175E+00, 9.7122550012E-01],
	[3.9940000000E+04, 3.9477371359E+01, 5.2596710376E+00, 2.0077962294E+01, 3.7698466788E+00, 9.7123776499E-01],
	[3.9945000000E+04, 3.9486017515E+01, 5.2597104551E+00, 2.0086116203E+01, 3.7702331367E+00, 9.7125002370E-01],
	[3.9950000000E+04, 3.9494664482E+01, 5.2597498680E+00, 2.0094272399E+01, 3.7706194913E+00, 9.7126227625E-01],
	[3.9955000000E+04, 3.9503312261E+01, 5.2597892762E+00, 2.0102430883E+01, 3.7710057426E+00, 9.7127452263E-01],
	[3.9960000000E+04, 3.9511960850E+01, 5.2598286798E+00, 2.0110591654E+01, 3.7713918906E+00, 9.7128676286E-01],
	[3.9965000000E+04, 3.9520610251E+01, 5.2598680788E+00, 2.0118754713E+01, 3.7717779353E+00, 9.7129899694E-01],
	[3.9970000000E+04, 3.9529260462E+01, 5.2599074731E+00, 2.0126920061E+01, 3.7721638768E+00, 9.7131122487E-01],
	[3.9975000000E+04, 3.9537911484E+01, 5.2599468628E+00, 2.0135087697E+01, 3.7725497150E+00, 9.7132344665E-01],
	[3.9980000000E+04, 3.9546563318E+01, 5.2599862479E+00, 2.0143257623E+01, 3.7729354501E+00, 9.7133566229E-01],
	[3.9985000000E+04, 3.9555215962E+01, 5.2600256283E+00, 2.0151429837E+01, 3.7733210820E+00, 9.7134787179E-01],
	[3.9990000000E+04, 3.9563869417E+01, 5.2600650042E+00, 2.0159604342E+01, 3.7737066108E+00, 9.7136007516E-01],
	[3.9995000000E+04, 3.9572523683E+01, 5.2601043754E+00, 2.0167781137E+01, 3.7740920364E+00, 9.7137227239E-01],
	[4.0000000000E+04, 3.9581178760E+01, 5.2601437419E+00, 2.0175960222E+01, 3.7744773590E+00, 9.7138446350E-01],
	[4.0005000000E+04, 3.9589834648E+01, 5.2601831038E+00, 2.0184171267E+01, 3.7748636162E+00, 9.7139664848E-01],
	[4.0010000000E+04, 3.9598491346E+01, 5.2602224612E+00, 2.0192384623E+01, 3.7752497698E+00, 9.7140882733E-01],
	[4.0015000000E+04, 3.9607148855E+01, 5.2602618138E+00, 2.0200600292E+01, 3.7756358199E+00, 9.7142100007E-01],
	[4.0020000000E+04, 3.9615807175E+01, 5.2603011619E+00, 2.0208818274E+01, 3.7760217665E+00, 9.7143316670E-01],
	[4.0025000000E+04, 3.9624466306E+01, 5.2603405053E+00, 2.0217038569E+01, 3.7764076096E+00, 9.7144532721E-01],
	[4.0030000000E+04, 3.9633126247E+01, 5.2603798442E+00, 2.0225261177E+01, 3.7767933492E+00, 9.7145748161E-01],
	[4.0035000000E+04, 3.9641786999E+01, 5.2604191784E+00, 2.0233486099E+01, 3.7771789854E+00, 9.7146962991E-01],
	[4.0040000000E+04, 3.9650448562E+01, 5.2604585079E+00, 2.0241713335E+01, 3.7775645182E+00, 9.7148177211E-01],
	[4.0045000000E+04, 3.9659110935E+01, 5.2604978329E+00, 2.0249942886E+01, 3.7779499476E+00, 9.7149390821E-01],
	[4.0050000000E+04, 3.9667774119E+01, 5.2605371533E+00, 2.0258174752E+01, 3.7783352736E+00, 9.7150603821E-01],
	[4.0055000000E+04, 3.9676438114E+01, 5.2605764690E+00, 2.0266408932E+01, 3.7787204963E+00, 9.7151816213E-01],
	[4.0060000000E+04, 3.9685102919E+01, 5.2606157801E+00, 2.0274645429E+01, 3.7791056157E+00, 9.7153027995E-01],
	[4.0065000000E+04, 3.9693768534E+01, 5.2606550866E+00, 2.0282884241E+01, 3.7794906318E+00, 9.7154239169E-01],
	[4.0070000000E+04, 3.9702434960E+01, 5.2606943885E+00, 2.0291125370E+01, 3.7798755446E+00, 9.7155449735E-01],
	[4.0075000000E+04, 3.9711102197E+01, 5.2607336858E+00, 2.0299368815E+01, 3.7802603542E+00, 9.7156659694E-01],
	[4.0080000000E+04, 3.9719770243E+01, 5.2607729785E+00, 2.0307614578E+01, 3.7806450606E+00, 9.7157869044E-01],
	[4.0085000000E+04, 3.9728439101E+01, 5.2608122666E+00, 2.0315862658E+01, 3.7810296639E+00, 9.7159077788E-01],
	[4.0090000000E+04, 3.9737108768E+01, 5.2608515500E+00, 2.0324113055E+01, 3.7814141639E+00, 9.7160285925E-01],
	[4.0095000000E+04, 3.9745779246E+01, 5.2608908289E+00, 2.0332365771E+01, 3.7817985609E+00, 9.7161493456E-01],
	[4.0100000000E+04, 3.9754450535E+01, 5.2609301031E+00, 2.0340620805E+01, 3.7821828547E+00, 9.7162700380E-01],
	[4.0105000000E+04, 3.9763122634E+01, 5.2609693728E+00, 2.0348878159E+01, 3.7825670455E+00, 9.7163906699E-01],
	[4.0110000000E+04, 3.9771795543E+01, 5.2610086378E+00, 2.0357137831E+01, 3.7829511332E+00, 9.7165112412E-01],
	[4.0115000000E+04, 3.9780469262E+01, 5.2610478983E+00, 2.0365399823E+01, 3.7833351179E+00, 9.7166317521E-01],
	[4.0120000000E+04, 3.9789143791E+01, 5.2610871541E+00, 2.0373664135E+01, 3.7837189996E+00, 9.7167522024E-01],
	[4.0125000000E+04, 3.9797819131E+01, 5.2611264054E+00, 2.0381930767E+01, 3.7841027784E+00, 9.7168725923E-01],
	[4.0130000000E+04, 3.9806495281E+01, 5.2611656520E+00, 2.0390199720E+01, 3.7844864542E+00, 9.7169929218E-01],
	[4.0135000000E+04, 3.9815172241E+01, 5.2612048941E+00, 2.0398470994E+01, 3.7848700270E+00, 9.7171131910E-01],
	[4.0140000000E+04, 3.9823850011E+01, 5.2612441315E+00, 2.0406744589E+01, 3.7852534970E+00, 9.7172333998E-01],
	[4.0145000000E+04, 3.9832528591E+01, 5.2612833644E+00, 2.0415020506E+01, 3.7856368641E+00, 9.7173535483E-01],
	[4.0150000000E+04, 3.9841207981E+01, 5.2613225927E+00, 2.0423298745E+01, 3.7860201284E+00, 9.7174736365E-01],
	[4.0155000000E+04, 3.9849888182E+01, 5.2613618163E+00, 2.0431579306E+01, 3.7864032899E+00, 9.7175936645E-01],
	[4.0160000000E+04, 3.9858569192E+01, 5.2614010354E+00, 2.0439862191E+01, 3.7867863485E+00, 9.7177136323E-01],
	[4.0165000000E+04, 3.9867251013E+01, 5.2614402499E+00, 2.0448147398E+01, 3.7871693044E+00, 9.7178335400E-01],
	[4.0170000000E+04, 3.9875933643E+01, 5.2614794598E+00, 2.0456434929E+01, 3.7875521576E+00, 9.7179533874E-01],
	[4.0175000000E+04, 3.9884617084E+01, 5.2615186651E+00, 2.0464724784E+01, 3.7879349081E+00, 9.7180731748E-01],
	[4.0180000000E+04, 3.9893301334E+01, 5.2615578659E+00, 2.0473016964E+01, 3.7883175559E+00, 9.7181929022E-01],
	[4.0185000000E+04, 3.9901986394E+01, 5.2615970620E+00, 2.0481311468E+01, 3.7887001010E+00, 9.7183125695E-01],
	[4.0190000000E+04, 3.9910672264E+01, 5.2616362536E+00, 2.0489608296E+01, 3.7890825435E+00, 9.7184321767E-01],
	[4.0195000000E+04, 3.9919358944E+01, 5.2616754405E+00, 2.0497907451E+01, 3.7894648834E+00, 9.7185517241E-01],
	[4.0200000000E+04, 3.9928046434E+01, 5.2617146229E+00, 2.0506208931E+01, 3.7898471207E+00, 9.7186712115E-01],
	[4.0205000000E+04, 3.9936734733E+01, 5.2617538007E+00, 2.0514512737E+01, 3.7902292554E+00, 9.7187906390E-01],
	[4.0210000000E+04, 3.9945423843E+01, 5.2617929740E+00, 2.0522818869E+01, 3.7906112876E+00, 9.7189100066E-01],
	[4.0215000000E+04, 3.9954113762E+01, 5.2618321426E+00, 2.0531127329E+01, 3.7909932174E+00, 9.7190293144E-01],
	[4.0220000000E+04, 3.9962804491E+01, 5.2618713067E+00, 2.0539438115E+01, 3.7913750446E+00, 9.7191485624E-01],
	[4.0225000000E+04, 3.9971496029E+01, 5.2619104662E+00, 2.0547751229E+01, 3.7917567694E+00, 9.7192677506E-01],
	[4.0230000000E+04, 3.9980188377E+01, 5.2619496211E+00, 2.0556066671E+01, 3.7921383918E+00, 9.7193868791E-01],
	[4.0235000000E+04, 3.9988881535E+01, 5.2619887715E+00, 2.0564384441E+01, 3.7925199118E+00, 9.7195059479E-01],
	[4.0240000000E+04, 3.9997575503E+01, 5.2620279172E+00, 2.0572704540E+01, 3.7929013294E+00, 9.7196249571E-01],
	[4.0245000000E+04, 4.0006270280E+01, 5.2620670584E+00, 2.0581026967E+01, 3.7932826446E+00, 9.7197439066E-01],
	[4.0250000000E+04, 4.0014965867E+01, 5.2621061951E+00, 2.0589351724E+01, 3.7936638576E+00, 9.7198627965E-01],
	[4.0255000000E+04, 4.0023662263E+01, 5.2621453271E+00, 2.0597678811E+01, 3.7940449682E+00, 9.7199816269E-01],
	[4.0260000000E+04, 4.0032359469E+01, 5.2621844546E+00, 2.0606008228E+01, 3.7944259766E+00, 9.7201003977E-01],
	[4.0265000000E+04, 4.0041057484E+01, 5.2622235775E+00, 2.0614339975E+01, 3.7948068827E+00, 9.7202191090E-01],
	[4.0270000000E+04, 4.0049756309E+01, 5.2622626959E+00, 2.0622674053E+01, 3.7951876867E+00, 9.7203377609E-01],
	[4.0275000000E+04, 4.0058455943E+01, 5.2623018097E+00, 2.0631010462E+01, 3.7955683884E+00, 9.7204563533E-01],
	[4.0280000000E+04, 4.0067156386E+01, 5.2623409189E+00, 2.0639349202E+01, 3.7959489880E+00, 9.7205748863E-01],
	[4.0285000000E+04, 4.0075857639E+01, 5.2623800236E+00, 2.0647690274E+01, 3.7963294854E+00, 9.7206933600E-01],
	[4.0290000000E+04, 4.0084559702E+01, 5.2624191237E+00, 2.0656033679E+01, 3.7967098807E+00, 9.7208117743E-01],
	[4.0295000000E+04, 4.0093262574E+01, 5.2624582192E+00, 2.0664379416E+01, 3.7970901740E+00, 9.7209301294E-01],
	[4.0300000000E+04, 4.0101966255E+01, 5.2624973102E+00, 2.0672727486E+01, 3.7974703652E+00, 9.7210484252E-01],
	[4.0305000000E+04, 4.0110670745E+01, 5.2625363966E+00, 2.0681077890E+01, 3.7978504543E+00, 9.7211666617E-01],
	[4.0310000000E+04, 4.0119376045E+01, 5.2625754784E+00, 2.0689430627E+01, 3.7982304415E+00, 9.7212848391E-01],
	[4.0315000000E+04, 4.0128082154E+01, 5.2626145557E+00, 2.0697785698E+01, 3.7986103266E+00, 9.7214029573E-01],
	[4.0320000000E+04, 4.0136789072E+01, 5.2626536285E+00, 2.0706143103E+01, 3.7989901099E+00, 9.7215210164E-01],
	[4.0325000000E+04, 4.0145496799E+01, 5.2626926967E+00, 2.0714502844E+01, 3.7993697911E+00, 9.7216390163E-01],
	[4.0330000000E+04, 4.0154205336E+01, 5.2627317603E+00, 2.0722864919E+01, 3.7997493705E+00, 9.7217569572E-01],
	[4.0335000000E+04, 4.0162914681E+01, 5.2627708194E+00, 2.0731229330E+01, 3.8001288480E+00, 9.7218748391E-01],
	[4.0340000000E+04, 4.0171624836E+01, 5.2628098739E+00, 2.0739596076E+01, 3.8005082237E+00, 9.7219926620E-01],
	[4.0345000000E+04, 4.0180335800E+01, 5.2628489239E+00, 2.0747965159E+01, 3.8008874975E+00, 9.7221104259E-01],
	[4.0350000000E+04, 4.0189047573E+01, 5.2628879693E+00, 2.0756336579E+01, 3.8012666696E+00, 9.7222281309E-01],
	[4.0355000000E+04, 4.0197760155E+01, 5.2629270102E+00, 2.0764710335E+01, 3.8016457398E+00, 9.7223457770E-01],
	[4.0360000000E+04, 4.0206473546E+01, 5.2629660465E+00, 2.0773086429E+01, 3.8020247083E+00, 9.7224633642E-01],
	[4.0365000000E+04, 4.0215187746E+01, 5.2630050783E+00, 2.0781464860E+01, 3.8024035751E+00, 9.7225808926E-01],
	[4.0370000000E+04, 4.0223902755E+01, 5.2630441056E+00, 2.0789845629E+01, 3.8027823402E+00, 9.7226983622E-01],
	[4.0375000000E+04, 4.0232618573E+01, 5.2630831283E+00, 2.0798228736E+01, 3.8031610037E+00, 9.7228157731E-01],
	[4.0380000000E+04, 4.0241335200E+01, 5.2631221464E+00, 2.0806614183E+01, 3.8035395655E+00, 9.7229331252E-01],
	[4.0385000000E+04, 4.0250052635E+01, 5.2631611600E+00, 2.0815001968E+01, 3.8039180256E+00, 9.7230504186E-01],
	[4.0390000000E+04, 4.0258770880E+01, 5.2632001691E+00, 2.0823392093E+01, 3.8042963842E+00, 9.7231676533E-01],
	[4.0395000000E+04, 4.0267489933E+01, 5.2632391736E+00, 2.0831784558E+01, 3.8046746413E+00, 9.7232848295E-01],
	[4.0400000000E+04, 4.0276209796E+01, 5.2632781736E+00, 2.0840179362E+01, 3.8050527968E+00, 9.7234019470E-01],
	[4.0405000000E+04, 4.0284930467E+01, 5.2633171691E+00, 2.0848576508E+01, 3.8054308507E+00, 9.7235190059E-01],
	[4.0410000000E+04, 4.0293651947E+01, 5.2633561600E+00, 2.0856975994E+01, 3.8058088032E+00, 9.7236360063E-01],
	[4.0415000000E+04, 4.0302374235E+01, 5.2633951464E+00, 2.0865377821E+01, 3.8061866543E+00, 9.7237529483E-01],
	[4.0420000000E+04, 4.0311097333E+01, 5.2634341282E+00, 2.0873781990E+01, 3.8065644039E+00, 9.7238698317E-01],
	[4.0425000000E+04, 4.0319821239E+01, 5.2634731056E+00, 2.0882188502E+01, 3.8069420521E+00, 9.7239866568E-01],
	[4.0430000000E+04, 4.0328545953E+01, 5.2635120784E+00, 2.0890597355E+01, 3.8073195989E+00, 9.7241034234E-01],
	[4.0435000000E+04, 4.0337271477E+01, 5.2635510466E+00, 2.0899008551E+01, 3.8076970443E+00, 9.7242201316E-01],
	[4.0440000000E+04, 4.0345997809E+01, 5.2635900103E+00, 2.0907422090E+01, 3.8080743885E+00, 9.7243367816E-01],
	[4.0445000000E+04, 4.0354724949E+01, 5.2636289695E+00, 2.0915837973E+01, 3.8084516313E+00, 9.7244533732E-01],
	[4.0450000000E+04, 4.0363452898E+01, 5.2636679242E+00, 2.0924256199E+01, 3.8088287729E+00, 9.7245699065E-01],
	[4.0455000000E+04, 4.0372181656E+01, 5.2637068743E+00, 2.0932676770E+01, 3.8092058132E+00, 9.7246863817E-01],
	[4.0460000000E+04, 4.0380911222E+01, 5.2637458200E+00, 2.0941099685E+01, 3.8095827522E+00, 9.7248027986E-01],
	[4.0465000000E+04, 4.0389641597E+01, 5.2637847610E+00, 2.0949524945E+01, 3.8099595901E+00, 9.7249191573E-01],
	[4.0470000000E+04, 4.0398372780E+01, 5.2638236976E+00, 2.0957952550E+01, 3.8103363268E+00, 9.7250354579E-01],
	[4.0475000000E+04, 4.0407104772E+01, 5.2638626297E+00, 2.0966382500E+01, 3.8107129624E+00, 9.7251517005E-01],
	[4.0480000000E+04, 4.0415837572E+01, 5.2639015572E+00, 2.0974814797E+01, 3.8110894968E+00, 9.7252678849E-01],
	[4.0485000000E+04, 4.0424571180E+01, 5.2639404802E+00, 2.0983249440E+01, 3.8114659302E+00, 9.7253840113E-01],
	[4.0490000000E+04, 4.0433305597E+01, 5.2639793987E+00, 2.0991686430E+01, 3.8118422625E+00, 9.7255000797E-01],
	[4.0495000000E+04, 4.0442040822E+01, 5.2640183126E+00, 2.1000125766E+01, 3.8122184937E+00, 9.7256160901E-01],
	[4.0500000000E+04, 4.0450776856E+01, 5.2640572221E+00, 2.1008567451E+01, 3.8125946239E+00, 9.7257320426E-01],
	[4.0505000000E+04, 4.0459513698E+01, 5.2640961270E+00, 2.1017011482E+01, 3.8129706532E+00, 9.7258479372E-01],
	[4.0510000000E+04, 4.0468251348E+01, 5.2641350275E+00, 2.1025457862E+01, 3.8133465814E+00, 9.7259637739E-01],
	[4.0515000000E+04, 4.0477008077E+01, 5.2641758766E+00, 2.1033906591E+01, 3.8137235961E+00, 9.7260795528E-01],
	[4.0520000000E+04, 4.0485766446E+01, 5.2642168093E+00, 2.1042357668E+01, 3.8141005638E+00, 9.7261952738E-01],
	[4.0525000000E+04, 4.0494525629E+01, 5.2642577373E+00, 2.1050811095E+01, 3.8144774309E+00, 9.7263109371E-01],
	[4.0530000000E+04, 4.0503285626E+01, 5.2642986606E+00, 2.1059266871E+01, 3.8148541973E+00, 9.7264265427E-01],
	[4.0535000000E+04, 4.0512046437E+01, 5.2643395791E+00, 2.1067724997E+01, 3.8152308632E+00, 9.7265420905E-01],
	[4.0540000000E+04, 4.0520808062E+01, 5.2643804929E+00, 2.1076185473E+01, 3.8156074285E+00, 9.7266575807E-01],
	[4.0545000000E+04, 4.0529570501E+01, 5.2644214020E+00, 2.1084648300E+01, 3.8159838933E+00, 9.7267730132E-01],
	[4.0550000000E+04, 4.0538333754E+01, 5.2644623063E+00, 2.1093113478E+01, 3.8163602575E+00, 9.7268883881E-01],
	[4.0555000000E+04, 4.0547097821E+01, 5.2645032059E+00, 2.1101581008E+01, 3.8167365213E+00, 9.7270037054E-01],
	[4.0560000000E+04, 4.0555862702E+01, 5.2645441008E+00, 2.1110050889E+01, 3.8171126846E+00, 9.7271189652E-01],
	[4.0565000000E+04, 4.0564628397E+01, 5.2645849910E+00, 2.1118523122E+01, 3.8174887475E+00, 9.7272341675E-01],
	[4.0570000000E+04, 4.0573394906E+01, 5.2646258764E+00, 2.1126997708E+01, 3.8178647100E+00, 9.7273493123E-01],
	[4.0575000000E+04, 4.0582162228E+01, 5.2646667572E+00, 2.1135474646E+01, 3.8182405721E+00, 9.7274643996E-01],
	[4.0580000000E+04, 4.0590930364E+01, 5.2647076332E+00, 2.1143953938E+01, 3.8186163338E+00, 9.7275794295E-01],
	[4.0585000000E+04, 4.0599699315E+01, 5.2647485044E+00, 2.1152435583E+01, 3.8189919952E+00, 9.7276944021E-01],
	[4.0590000000E+04, 4.0608469079E+01, 5.2647893710E+00, 2.1160919583E+01, 3.8193675563E+00, 9.7278093173E-01],
	[4.0595000000E+04, 4.0617239656E+01, 5.2648302329E+00, 2.1169405936E+01, 3.8197430172E+00, 9.7279241751E-01],
	[4.0600000000E+04, 4.0626011048E+01, 5.2648710900E+00, 2.1177894644E+01, 3.8201183778E+00, 9.7280389757E-01],
	[4.0605000000E+04, 4.0634783253E+01, 5.2649119424E+00, 2.1186385707E+01, 3.8204936381E+00, 9.7281537191E-01],
	[4.0610000000E+04, 4.0643556272E+01, 5.2649527901E+00, 2.1194879126E+01, 3.8208687983E+00, 9.7282684052E-01],
	[4.0615000000E+04, 4.0652330104E+01, 5.2649936331E+00, 2.1203374900E+01, 3.8212438583E+00, 9.7283830341E-01],
	[4.0620000000E+04, 4.0661104750E+01, 5.2650344714E+00, 2.1211873030E+01, 3.8216188181E+00, 9.7284976059E-01],
	[4.0625000000E+04, 4.0669880210E+01, 5.2650753050E+00, 2.1220373517E+01, 3.8219936779E+00, 9.7286121206E-01],
	[4.0630000000E+04, 4.0678656483E+01, 5.2651161338E+00, 2.1228876361E+01, 3.8223684375E+00, 9.7287265781E-01],
	[4.0635000000E+04, 4.0687433570E+01, 5.2651569580E+00, 2.1237381562E+01, 3.8227430971E+00, 9.7288409786E-01],
	[4.0640000000E+04, 4.0696211470E+01, 5.2651977775E+00, 2.1245889120E+01, 3.8231176566E+00, 9.7289553221E-01],
	[4.0645000000E+04, 4.0704990184E+01, 5.2652385922E+00, 2.1254399036E+01, 3.8234921161E+00, 9.7290696086E-01],
	[4.0650000000E+04, 4.0713769711E+01, 5.2652794022E+00, 2.1262911310E+01, 3.8238664756E+00, 9.7291838381E-01],
	[4.0655000000E+04, 4.0722550052E+01, 5.2653202076E+00, 2.1271425943E+01, 3.8242407352E+00, 9.7292980108E-01],
	[4.0660000000E+04, 4.0731331206E+01, 5.2653610082E+00, 2.1279942935E+01, 3.8246148948E+00, 9.7294121265E-01],
	[4.0665000000E+04, 4.0740113174E+01, 5.2654018042E+00, 2.1288462287E+01, 3.8249889545E+00, 9.7295261853E-01],
	[4.0670000000E+04, 4.0748895955E+01, 5.2654425954E+00, 2.1296983998E+01, 3.8253629143E+00, 9.7296401873E-01],
	[4.0675000000E+04, 4.0757679549E+01, 5.2654833819E+00, 2.1305508069E+01, 3.8257367742E+00, 9.7297541325E-01],
	[4.0680000000E+04, 4.0766463956E+01, 5.2655241638E+00, 2.1314034501E+01, 3.8261105343E+00, 9.7298680210E-01],
	[4.0685000000E+04, 4.0775249177E+01, 5.2655649409E+00, 2.1322563293E+01, 3.8264841946E+00, 9.7299818527E-01],
	[4.0690000000E+04, 4.0784035212E+01, 5.2656057134E+00, 2.1331094447E+01, 3.8268577551E+00, 9.7300956277E-01],
	[4.0695000000E+04, 4.0792822059E+01, 5.2656464811E+00, 2.1339627962E+01, 3.8272312159E+00, 9.7302093461E-01],
	[4.0700000000E+04, 4.0801609720E+01, 5.2656872442E+00, 2.1348163839E+01, 3.8276045769E+00, 9.7303230078E-01],
	[4.0705000000E+04, 4.0810398194E+01, 5.2657280025E+00, 2.1356702078E+01, 3.8279778383E+00, 9.7304366129E-01],
	[4.0710000000E+04, 4.0819187481E+01, 5.2657687562E+00, 2.1365242680E+01, 3.8283509999E+00, 9.7305501615E-01],
	[4.0715000000E+04, 4.0827977581E+01, 5.2658095052E+00, 2.1373785644E+01, 3.8287240619E+00, 9.7306636535E-01],
	[4.0720000000E+04, 4.0836768494E+01, 5.2658502495E+00, 2.1382330973E+01, 3.8290970242E+00, 9.7307770890E-01],
	[4.0725000000E+04, 4.0845560221E+01, 5.2658909891E+00, 2.1390878664E+01, 3.8294698870E+00, 9.7308904680E-01],
	[4.0730000000E+04, 4.0854352760E+01, 5.2659317240E+00, 2.1399428720E+01, 3.8298426502E+00, 9.7310037905E-01],
	[4.0735000000E+04, 4.0863146113E+01, 5.2659724543E+00, 2.1407981140E+01, 3.8302153138E+00, 9.7311170567E-01],
	[4.0740000000E+04, 4.0871940279E+01, 5.2660131798E+00, 2.1416535926E+01, 3.8305878779E+00, 9.7312302665E-01],
	[4.0745000000E+04, 4.0880735257E+01, 5.2660539007E+00, 2.1425093076E+01, 3.8309603425E+00, 9.7313434199E-01],
	[4.0750000000E+04, 4.0889531049E+01, 5.2660946169E+00, 2.1433652591E+01, 3.8313327076E+00, 9.7314565171E-01],
	[4.0755000000E+04, 4.0898327654E+01, 5.2661353284E+00, 2.1442214473E+01, 3.8317049733E+00, 9.7315695579E-01],
	[4.0760000000E+04, 4.0907125071E+01, 5.2661760353E+00, 2.1450778721E+01, 3.8320771396E+00, 9.7316825425E-01],
	[4.0765000000E+04, 4.0915923302E+01, 5.2662167374E+00, 2.1459345335E+01, 3.8324492064E+00, 9.7317954709E-01],
	[4.0770000000E+04, 4.0924722345E+01, 5.2662574349E+00, 2.1467914316E+01, 3.8328211739E+00, 9.7319083431E-01],
	[4.0775000000E+04, 4.0933522201E+01, 5.2662981277E+00, 2.1476485665E+01, 3.8331930421E+00, 9.7320211591E-01],
	[4.0780000000E+04, 4.0942322870E+01, 5.2663388158E+00, 2.1485059381E+01, 3.8335648109E+00, 9.7321339190E-01],
	[4.0785000000E+04, 4.0951124352E+01, 5.2663794993E+00, 2.1493635466E+01, 3.8339364804E+00, 9.7322466228E-01],
	[4.0790000000E+04, 4.0959926647E+01, 5.2664201780E+00, 2.1502213919E+01, 3.8343080507E+00, 9.7323592706E-01],
	[4.0795000000E+04, 4.0968729754E+01, 5.2664608521E+00, 2.1510794740E+01, 3.8346795217E+00, 9.7324718624E-01],
	[4.0800000000E+04, 4.0977533674E+01, 5.2665015216E+00, 2.1519377931E+01, 3.8350508935E+00, 9.7325843981E-01],
	[4.0805000000E+04, 4.0986338407E+01, 5.2665421863E+00, 2.1527963491E+01, 3.8354221662E+00, 9.7326968779E-01],
	[4.0810000000E+04, 4.0995143953E+01, 5.2665828464E+00, 2.1536551421E+01, 3.8357933396E+00, 9.7328093018E-01],
	[4.0815000000E+04, 4.1003950311E+01, 5.2666235019E+00, 2.1545141721E+01, 3.8361644140E+00, 9.7329216697E-01],
	[4.0820000000E+04, 4.1012757482E+01, 5.2666641526E+00, 2.1553734392E+01, 3.8365353892E+00, 9.7330339818E-01],
	[4.0825000000E+04, 4.1021565465E+01, 5.2667047987E+00, 2.1562329434E+01, 3.8369062653E+00, 9.7331462381E-01],
	[4.0830000000E+04, 4.1030374261E+01, 5.2667454402E+00, 2.1570926847E+01, 3.8372770424E+00, 9.7332584385E-01],
	[4.0835000000E+04, 4.1039183870E+01, 5.2667860769E+00, 2.1579526631E+01, 3.8376477204E+00, 9.7333705832E-01],
	[4.0840000000E+04, 4.1047994291E+01, 5.2668267090E+00, 2.1588128788E+01, 3.8380182995E+00, 9.7334826722E-01],
	[4.0845000000E+04, 4.1056805524E+01, 5.2668673365E+00, 2.1596733317E+01, 3.8383887795E+00, 9.7335947054E-01],
	[4.0850000000E+04, 4.1065617571E+01, 5.2669079593E+00, 2.1605340219E+01, 3.8387591606E+00, 9.7337066830E-01],
	[4.0855000000E+04, 4.1074430429E+01, 5.2669485774E+00, 2.1613949494E+01, 3.8391294428E+00, 9.7338186049E-01],
	[4.0860000000E+04, 4.1083244100E+01, 5.2669891909E+00, 2.1622561143E+01, 3.8394996260E+00, 9.7339304713E-01],
	[4.0865000000E+04, 4.1092058584E+01, 5.2670297997E+00, 2.1631175165E+01, 3.8398697104E+00, 9.7340422820E-01],
	[4.0870000000E+04, 4.1100873880E+01, 5.2670704038E+00, 2.1639791561E+01, 3.8402396959E+00, 9.7341540372E-01],
	[4.0875000000E+04, 4.1109689988E+01, 5.2671110033E+00, 2.1648410332E+01, 3.8406095826E+00, 9.7342657369E-01],
	[4.0880000000E+04, 4.1118506908E+01, 5.2671515982E+00, 2.1657031478E+01, 3.8409793705E+00, 9.7343773811E-01],
	[4.0885000000E+04, 4.1127324641E+01, 5.2671921884E+00, 2.1665655000E+01, 3.8413490597E+00, 9.7344889698E-01],
	[4.0890000000E+04, 4.1136143187E+01, 5.2672327739E+00, 2.1674280897E+01, 3.8417186500E+00, 9.7346005032E-01],
	[4.0895000000E+04, 4.1144962544E+01, 5.2672733548E+00, 2.1682909170E+01, 3.8420881417E+00, 9.7347119811E-01],
	[4.0900000000E+04, 4.1153782714E+01, 5.2673139311E+00, 2.1691539819E+01, 3.8424575346E+00, 9.7348234037E-01],
	[4.0905000000E+04, 4.1162603696E+01, 5.2673545027E+00, 2.1700172845E+01, 3.8428268289E+00, 9.7349347709E-01],
	[4.0910000000E+04, 4.1171425490E+01, 5.2673950697E+00, 2.1708808248E+01, 3.8431960246E+00, 9.7350460829E-01],
	[4.0915000000E+04, 4.1180248096E+01, 5.2674356320E+00, 2.1717446029E+01, 3.8435651216E+00, 9.7351573396E-01],
	[4.0920000000E+04, 4.1189071515E+01, 5.2674761896E+00, 2.1726086187E+01, 3.8439341200E+00, 9.7352685411E-01],
	[4.0925000000E+04, 4.1197895745E+01, 5.2675167427E+00, 2.1734728724E+01, 3.8443030199E+00, 9.7353796874E-01],
	[4.0930000000E+04, 4.1206720788E+01, 5.2675572910E+00, 2.1743373639E+01, 3.8446718212E+00, 9.7354907785E-01],
	[4.0935000000E+04, 4.1215546643E+01, 5.2675978348E+00, 2.1752020933E+01, 3.8450405240E+00, 9.7356018145E-01],
	[4.0940000000E+04, 4.1224373310E+01, 5.2676383739E+00, 2.1760670607E+01, 3.8454091283E+00, 9.7357127953E-01],
	[4.0945000000E+04, 4.1233200788E+01, 5.2676789083E+00, 2.1769322660E+01, 3.8457776341E+00, 9.7358237211E-01],
	[4.0950000000E+04, 4.1242029079E+01, 5.2677194382E+00, 2.1777977093E+01, 3.8461460415E+00, 9.7359345919E-01],
	[4.0955000000E+04, 4.1250858182E+01, 5.2677599633E+00, 2.1786633906E+01, 3.8465143505E+00, 9.7360454077E-01],
	[4.0960000000E+04, 4.1259688097E+01, 5.2678004839E+00, 2.1795293101E+01, 3.8468825611E+00, 9.7361561684E-01],
	[4.0965000000E+04, 4.1268518824E+01, 5.2678409998E+00, 2.1803954676E+01, 3.8472506734E+00, 9.7362668743E-01],
	[4.0970000000E+04, 4.1277350362E+01, 5.2678815111E+00, 2.1812618632E+01, 3.8476186873E+00, 9.7363775252E-01],
	[4.0975000000E+04, 4.1286182713E+01, 5.2679220178E+00, 2.1821284971E+01, 3.8479866029E+00, 9.7364881212E-01],
	[4.0980000000E+04, 4.1295015875E+01, 5.2679625198E+00, 2.1829953692E+01, 3.8483544202E+00, 9.7365986624E-01],
	[4.0985000000E+04, 4.1303849849E+01, 5.2680030172E+00, 2.1838624795E+01, 3.8487221393E+00, 9.7367091488E-01],
	[4.0990000000E+04, 4.1312684635E+01, 5.2680435099E+00, 2.1847298281E+01, 3.8490897601E+00, 9.7368195804E-01],
	[4.0995000000E+04, 4.1321520233E+01, 5.2680839981E+00, 2.1855974151E+01, 3.8494572827E+00, 9.7369299572E-01],
	[4.1000000000E+04, 4.1330356642E+01, 5.2681244816E+00, 2.1864652404E+01, 3.8498247071E+00, 9.7370402793E-01],
	[4.1005000000E+04, 4.1339193864E+01, 5.2681649604E+00, 2.1873333041E+01, 3.8501920334E+00, 9.7371505467E-01],
	[4.1010000000E+04, 4.1348031897E+01, 5.2682054347E+00, 2.1882016062E+01, 3.8505592616E+00, 9.7372607595E-01],
	[4.1015000000E+04, 4.1356870741E+01, 5.2682459043E+00, 2.1890701468E+01, 3.8509263916E+00, 9.7373709176E-01],
	[4.1020000000E+04, 4.1365710398E+01, 5.2682863693E+00, 2.1899389260E+01, 3.8512934236E+00, 9.7374810211E-01],
	[4.1025000000E+04, 4.1374550866E+01, 5.2683268297E+00, 2.1908079436E+01, 3.8516603575E+00, 9.7375910700E-01],
	[4.1030000000E+04, 4.1383392145E+01, 5.2683672855E+00, 2.1916771999E+01, 3.8520271934E+00, 9.7377010645E-01],
	[4.1035000000E+04, 4.1392234236E+01, 5.2684077367E+00, 2.1925466947E+01, 3.8523939313E+00, 9.7378110044E-01],
	[4.1040000000E+04, 4.1401077139E+01, 5.2684481832E+00, 2.1934164283E+01, 3.8527605713E+00, 9.7379208898E-01],
	[4.1045000000E+04, 4.1409920853E+01, 5.2684886251E+00, 2.1942864005E+01, 3.8531271132E+00, 9.7380307208E-01],
	[4.1050000000E+04, 4.1418765379E+01, 5.2685290624E+00, 2.1951566114E+01, 3.8534935573E+00, 9.7381404974E-01],
	[4.1055000000E+04, 4.1427610716E+01, 5.2685694951E+00, 2.1960270611E+01, 3.8538599035E+00, 9.7382502196E-01],
	[4.1060000000E+04, 4.1436456865E+01, 5.2686099232E+00, 2.1968977496E+01, 3.8542261518E+00, 9.7383598874E-01],
	[4.1065000000E+04, 4.1445303825E+01, 5.2686503466E+00, 2.1977686769E+01, 3.8545923022E+00, 9.7384695010E-01],
	[4.1070000000E+04, 4.1454151597E+01, 5.2686907655E+00, 2.1986398431E+01, 3.8549583548E+00, 9.7385790602E-01],
	[4.1075000000E+04, 4.1463000180E+01, 5.2687311797E+00, 2.1995112482E+01, 3.8553243097E+00, 9.7386885652E-01],
	[4.1080000000E+04, 4.1471849574E+01, 5.2687715893E+00, 2.2003828923E+01, 3.8556901667E+00, 9.7387980160E-01],
	[4.1085000000E+04, 4.1480699780E+01, 5.2688119944E+00, 2.2012547753E+01, 3.8560559261E+00, 9.7389074126E-01],
	[4.1090000000E+04, 4.1489550797E+01, 5.2688523948E+00, 2.2021268974E+01, 3.8564215877E+00, 9.7390167550E-01],
	[4.1095000000E+04, 4.1498402625E+01, 5.2688927906E+00, 2.2029992585E+01, 3.8567871516E+00, 9.7391260433E-01],
	[4.1100000000E+04, 4.1507255264E+01, 5.2689331818E+00, 2.2038718587E+01, 3.8571526179E+00, 9.7392352775E-01],
	[4.1105000000E+04, 4.1516108715E+01, 5.2689735684E+00, 2.2047446980E+01, 3.8575179865E+00, 9.7393444576E-01],
	[4.1110000000E+04, 4.1524962977E+01, 5.2690139504E+00, 2.2056177765E+01, 3.8578832575E+00, 9.7394535837E-01],
	[4.1115000000E+04, 4.1533818050E+01, 5.2690543278E+00, 2.2064910942E+01, 3.8582484309E+00, 9.7395626558E-01],
	[4.1120000000E+04, 4.1542673935E+01, 5.2690947005E+00, 2.2073646511E+01, 3.8586135068E+00, 9.7396716739E-01],
	[4.1125000000E+04, 4.1551530630E+01, 5.2691350687E+00, 2.2082384473E+01, 3.8589784851E+00, 9.7397806380E-01],
	[4.1130000000E+04, 4.1560388137E+01, 5.2691754323E+00, 2.2091124828E+01, 3.8593433659E+00, 9.7398895483E-01],
	[4.1135000000E+04, 4.1569246455E+01, 5.2692157913E+00, 2.2099867576E+01, 3.8597081493E+00, 9.7399984046E-01],
	[4.1140000000E+04, 4.1578105584E+01, 5.2692561457E+00, 2.2108612718E+01, 3.8600728351E+00, 9.7401072072E-01],
	[4.1145000000E+04, 4.1586965523E+01, 5.2692964955E+00, 2.2117360254E+01, 3.8604374236E+00, 9.7402159559E-01],
	[4.1150000000E+04, 4.1595826274E+01, 5.2693368407E+00, 2.2126110185E+01, 3.8608019146E+00, 9.7403246508E-01],
	[4.1155000000E+04, 4.1604687836E+01, 5.2693771814E+00, 2.2134862511E+01, 3.8611663083E+00, 9.7404332919E-01],
	[4.1160000000E+04, 4.1613550209E+01, 5.2694175174E+00, 2.2143617232E+01, 3.8615306046E+00, 9.7405418794E-01],
	[4.1165000000E+04, 4.1622423396E+01, 5.2694588984E+00, 2.2152374348E+01, 3.8618954534E+00, 9.7406504131E-01],
	[4.1170000000E+04, 4.1631306453E+01, 5.2695012246E+00, 2.2161133861E+01, 3.8622607933E+00, 9.7407588932E-01],
	[4.1175000000E+04, 4.1640190327E+01, 5.2695435460E+00, 2.2169895770E+01, 3.8626260362E+00, 9.7408673196E-01],
	[4.1180000000E+04, 4.1649075017E+01, 5.2695858626E+00, 2.2178660075E+01, 3.8629911820E+00, 9.7409756924E-01],
	[4.1185000000E+04, 4.1657960524E+01, 5.2696281744E+00, 2.2187426778E+01, 3.8633562308E+00, 9.7410840117E-01],
	[4.1190000000E+04, 4.1666846847E+01, 5.2696704814E+00, 2.2196195878E+01, 3.8637211827E+00, 9.7411922774E-01],
	[4.1195000000E+04, 4.1675733987E+01, 5.2697127836E+00, 2.2204967376E+01, 3.8640860376E+00, 9.7413004896E-01],
	[4.1200000000E+04, 4.1684621944E+01, 5.2697550810E+00, 2.2213741272E+01, 3.8644507956E+00, 9.7414086483E-01],
	[4.1205000000E+04, 4.1693510717E+01, 5.2697973737E+00, 2.2222517567E+01, 3.8648154568E+00, 9.7415167536E-01],
	[4.1210000000E+04, 4.1702400307E+01, 5.2698396615E+00, 2.2231296260E+01, 3.8651800210E+00, 9.7416248054E-01],
	[4.1215000000E+04, 4.1711290713E+01, 5.2698819446E+00, 2.2240077353E+01, 3.8655444884E+00, 9.7417328038E-01],
	[4.1220000000E+04, 4.1720181936E+01, 5.2699242228E+00, 2.2248860845E+01, 3.8659088590E+00, 9.7418407488E-01],
	[4.1225000000E+04, 4.1729073976E+01, 5.2699664963E+00, 2.2257646737E+01, 3.8662731328E+00, 9.7419486404E-01],
	[4.1230000000E+04, 4.1737966831E+01, 5.2700087650E+00, 2.2266435030E+01, 3.8666373098E+00, 9.7420564787E-01],
	[4.1235000000E+04, 4.1746860504E+01, 5.2700510288E+00, 2.2275225723E+01, 3.8670013901E+00, 9.7421642637E-01],
	[4.1240000000E+04, 4.1755754992E+01, 5.2700932879E+00, 2.2284018818E+01, 3.8673653737E+00, 9.7422719954E-01],
	[4.1245000000E+04, 4.1764650297E+01, 5.2701355423E+00, 2.2292814313E+01, 3.8677292606E+00, 9.7423796738E-01],
	[4.1250000000E+04, 4.1773546419E+01, 5.2701777918E+00, 2.2301612211E+01, 3.8680930509E+00, 9.7424872990E-01],
	[4.1255000000E+04, 4.1782443356E+01, 5.2702200366E+00, 2.2310412511E+01, 3.8684567445E+00, 9.7425948710E-01],
	[4.1260000000E+04, 4.1791341110E+01, 5.2702622765E+00, 2.2319215213E+01, 3.8688203415E+00, 9.7427023899E-01],
	[4.1265000000E+04, 4.1800239680E+01, 5.2703045117E+00, 2.2328020318E+01, 3.8691838419E+00, 9.7428098556E-01],
	[4.1270000000E+04, 4.1809139067E+01, 5.2703467421E+00, 2.2336827826E+01, 3.8695472457E+00, 9.7429172682E-01],
	[4.1275000000E+04, 4.1818039270E+01, 5.2703889678E+00, 2.2345637738E+01, 3.8699105530E+00, 9.7430246277E-01],
	[4.1280000000E+04, 4.1826940289E+01, 5.2704311886E+00, 2.2354450054E+01, 3.8702737638E+00, 9.7431319342E-01],
	[4.1285000000E+04, 4.1835842124E+01, 5.2704734047E+00, 2.2363264775E+01, 3.8706368781E+00, 9.7432391876E-01],
	[4.1290000000E+04, 4.1844744775E+01, 5.2705156160E+00, 2.2372081899E+01, 3.8709998960E+00, 9.7433463880E-01],
	[4.1295000000E+04, 4.1853648243E+01, 5.2705578226E+00, 2.2380901429E+01, 3.8713628175E+00, 9.7434535354E-01],
	[4.1300000000E+04, 4.1862552526E+01, 5.2706000244E+00, 2.2389723365E+01, 3.8717256425E+00, 9.7435606299E-01],
	[4.1305000000E+04, 4.1871457626E+01, 5.2706422213E+00, 2.2398547706E+01, 3.8720883711E+00, 9.7436676714E-01],
	[4.1310000000E+04, 4.1880363542E+01, 5.2706844136E+00, 2.2407374454E+01, 3.8724510034E+00, 9.7437746601E-01],
	[4.1315000000E+04, 4.1889270273E+01, 5.2707266010E+00, 2.2416203607E+01, 3.8728135394E+00, 9.7438815958E-01],
	[4.1320000000E+04, 4.1898177821E+01, 5.2707687837E+00, 2.2425035168E+01, 3.8731759791E+00, 9.7439884788E-01],
	[4.1325000000E+04, 4.1907086185E+01, 5.2708109616E+00, 2.2433869136E+01, 3.8735383225E+00, 9.7440953089E-01],
	[4.1330000000E+04, 4.1915995365E+01, 5.2708531348E+00, 2.2442705512E+01, 3.8739005696E+00, 9.7442020862E-01],
	[4.1335000000E+04, 4.1924905360E+01, 5.2708953032E+00, 2.2451544295E+01, 3.8742627205E+00, 9.7443088108E-01],
	[4.1340000000E+04, 4.1933816172E+01, 5.2709374668E+00, 2.2460385487E+01, 3.8746247752E+00, 9.7444154827E-01],
	[4.1345000000E+04, 4.1942727799E+01, 5.2709796257E+00, 2.2469229088E+01, 3.8749867337E+00, 9.7445221018E-01],
	[4.1350000000E+04, 4.1951640243E+01, 5.2710217798E+00, 2.2478075098E+01, 3.8753485961E+00, 9.7446286683E-01],
	[4.1355000000E+04, 4.1960553502E+01, 5.2710639291E+00, 2.2486923517E+01, 3.8757103624E+00, 9.7447351821E-01],
	[4.1360000000E+04, 4.1969467577E+01, 5.2711060737E+00, 2.2495774346E+01, 3.8760720326E+00, 9.7448416433E-01],
	[4.1365000000E+04, 4.1978382468E+01, 5.2711482136E+00, 2.2504627585E+01, 3.8764336066E+00, 9.7449480519E-01],
	[4.1370000000E+04, 4.1987298175E+01, 5.2711903486E+00, 2.2513483234E+01, 3.8767950847E+00, 9.7450544079E-01],
	[4.1375000000E+04, 4.1996214697E+01, 5.2712324790E+00, 2.2522341294E+01, 3.8771564667E+00, 9.7451607114E-01],
	[4.1380000000E+04, 4.2005132035E+01, 5.2712746045E+00, 2.2531201766E+01, 3.8775177527E+00, 9.7452669623E-01],
	[4.1385000000E+04, 4.2014050189E+01, 5.2713167253E+00, 2.2540064649E+01, 3.8778789428E+00, 9.7453731608E-01],
	[4.1390000000E+04, 4.2022969159E+01, 5.2713588414E+00, 2.2548929945E+01, 3.8782400369E+00, 9.7454793068E-01],
	[4.1395000000E+04, 4.2031888944E+01, 5.2714009527E+00, 2.2557797652E+01, 3.8786010351E+00, 9.7455854004E-01],
	[4.1400000000E+04, 4.2040809545E+01, 5.2714430593E+00, 2.2566667772E+01, 3.8789619374E+00, 9.7456914416E-01],
	[4.1405000000E+04, 4.2049730961E+01, 5.2714851611E+00, 2.2575540306E+01, 3.8793227438E+00, 9.7457974304E-01],
	[4.1410000000E+04, 4.2058653193E+01, 5.2715272581E+00, 2.2584415252E+01, 3.8796834544E+00, 9.7459033669E-01],
	[4.1415000000E+04, 4.2067576241E+01, 5.2715693504E+00, 2.2593292613E+01, 3.8800440692E+00, 9.7460092510E-01],
	[4.1420000000E+04, 4.2076500104E+01, 5.2716114380E+00, 2.2602172388E+01, 3.8804045882E+00, 9.7461150828E-01],
	[4.1425000000E+04, 4.2085424782E+01, 5.2716535208E+00, 2.2611054577E+01, 3.8807650114E+00, 9.7462208624E-01],
	[4.1430000000E+04, 4.2094350276E+01, 5.2716955989E+00, 2.2619939181E+01, 3.8811253389E+00, 9.7463265897E-01],
	[4.1435000000E+04, 4.2103276586E+01, 5.2717376723E+00, 2.2628826200E+01, 3.8814855706E+00, 9.7464322649E-01],
	[4.1440000000E+04, 4.2112203711E+01, 5.2717797409E+00, 2.2637715635E+01, 3.8818457067E+00, 9.7465378878E-01],
	[4.1445000000E+04, 4.2121131651E+01, 5.2718218047E+00, 2.2646607486E+01, 3.8822057471E+00, 9.7466434586E-01],
	[4.1450000000E+04, 4.2130060407E+01, 5.2718638638E+00, 2.2655501753E+01, 3.8825656919E+00, 9.7467489772E-01],
	[4.1455000000E+04, 4.2138989978E+01, 5.2719059182E+00, 2.2664398437E+01, 3.8829255410E+00, 9.7468544437E-01],
	[4.1460000000E+04, 4.2147920365E+01, 5.2719479679E+00, 2.2673297538E+01, 3.8832852946E+00, 9.7469598582E-01],
	[4.1465000000E+04, 4.2156851567E+01, 5.2719900128E+00, 2.2682199056E+01, 3.8836449526E+00, 9.7470652206E-01],
	[4.1470000000E+04, 4.2165783584E+01, 5.2720320529E+00, 2.2691102992E+01, 3.8840045151E+00, 9.7471705310E-01],
	[4.1475000000E+04, 4.2174716417E+01, 5.2720740884E+00, 2.2700009347E+01, 3.8843639821E+00, 9.7472757893E-01],
	[4.1480000000E+04, 4.2183650064E+01, 5.2721161191E+00, 2.2708918119E+01, 3.8847233535E+00, 9.7473809958E-01],
	[4.1485000000E+04, 4.2192584527E+01, 5.2721581451E+00, 2.2717829311E+01, 3.8850826296E+00, 9.7474861502E-01],
	[4.1490000000E+04, 4.2201519805E+01, 5.2722001663E+00, 2.2726742922E+01, 3.8854418101E+00, 9.7475912528E-01],
	[4.1495000000E+04, 4.2210455899E+01, 5.2722421829E+00, 2.2735658953E+01, 3.8858008953E+00, 9.7476963035E-01],
	[4.1500000000E+04, 4.2219392807E+01, 5.2722841946E+00, 2.2744577403E+01, 3.8861598851E+00, 9.7478013023E-01],
	[4.1505000000E+04, 4.2228330531E+01, 5.2723262017E+00, 2.2753498274E+01, 3.8865187796E+00, 9.7479062493E-01],
	[4.1510000000E+04, 4.2237269070E+01, 5.2723682041E+00, 2.2762421566E+01, 3.8868775787E+00, 9.7480111444E-01],
	[4.1515000000E+04, 4.2246208423E+01, 5.2724102017E+00, 2.2771347278E+01, 3.8872362825E+00, 9.7481159878E-01],
	[4.1520000000E+04, 4.2255148592E+01, 5.2724521946E+00, 2.2780275412E+01, 3.8875948910E+00, 9.7482207795E-01],
	[4.1525000000E+04, 4.2264089576E+01, 5.2724941827E+00, 2.2789205968E+01, 3.8879534043E+00, 9.7483255194E-01],
	[4.1530000000E+04, 4.2273031375E+01, 5.2725361662E+00, 2.2798138946E+01, 3.8883118223E+00, 9.7484302076E-01],
	[4.1535000000E+04, 4.2281973989E+01, 5.2725781449E+00, 2.2807074347E+01, 3.8886701452E+00, 9.7485348441E-01],
	[4.1540000000E+04, 4.2290917418E+01, 5.2726201189E+00, 2.2816012170E+01, 3.8890283728E+00, 9.7486394290E-01],
	[4.1545000000E+04, 4.2299861662E+01, 5.2726620882E+00, 2.2824952417E+01, 3.8893865053E+00, 9.7487439623E-01],
	[4.1550000000E+04, 4.2308806720E+01, 5.2727040528E+00, 2.2833895087E+01, 3.8897445427E+00, 9.7488484440E-01],
	[4.1555000000E+04, 4.2317752594E+01, 5.2727460127E+00, 2.2842840181E+01, 3.8901024850E+00, 9.7489528742E-01],
	[4.1560000000E+04, 4.2326699282E+01, 5.2727879678E+00, 2.2851787700E+01, 3.8904603322E+00, 9.7490572528E-01],
	[4.1565000000E+04, 4.2335646786E+01, 5.2728299182E+00, 2.2860737643E+01, 3.8908180844E+00, 9.7491615799E-01],
	[4.1570000000E+04, 4.2344595104E+01, 5.2728718640E+00, 2.2869690011E+01, 3.8911757415E+00, 9.7492658555E-01],
	[4.1575000000E+04, 4.2353544237E+01, 5.2729138050E+00, 2.2878644805E+01, 3.8915333036E+00, 9.7493700796E-01],
	[4.1580000000E+04, 4.2362494185E+01, 5.2729557413E+00, 2.2887602024E+01, 3.8918907708E+00, 9.7494742524E-01],
	[4.1585000000E+04, 4.2371444947E+01, 5.2729976729E+00, 2.2896561670E+01, 3.8922481430E+00, 9.7495783737E-01],
	[4.1590000000E+04, 4.2380396524E+01, 5.2730395997E+00, 2.2905523742E+01, 3.8926054203E+00, 9.7496824437E-01],
	[4.1595000000E+04, 4.2389348916E+01, 5.2730815219E+00, 2.2914488241E+01, 3.8929626027E+00, 9.7497864623E-01],
	[4.1600000000E+04, 4.2398302123E+01, 5.2731234394E+00, 2.2923455168E+01, 3.8933196902E+00, 9.7498904296E-01],
	[4.1605000000E+04, 4.2407256144E+01, 5.2731653521E+00, 2.2932424522E+01, 3.8936766829E+00, 9.7499943456E-01],
	[4.1610000000E+04, 4.2416210980E+01, 5.2732072602E+00, 2.2941396304E+01, 3.8940335807E+00, 9.7500982104E-01],
	[4.1615000000E+04, 4.2425166631E+01, 5.2732491636E+00, 2.2950370514E+01, 3.8943903838E+00, 9.7502020239E-01],
	[4.1620000000E+04, 4.2434123096E+01, 5.2732910622E+00, 2.2959347153E+01, 3.8947470920E+00, 9.7503057862E-01],
	[4.1625000000E+04, 4.2443080375E+01, 5.2733329562E+00, 2.2968326221E+01, 3.8951037056E+00, 9.7504094973E-01],
	[4.1630000000E+04, 4.2452038470E+01, 5.2733748454E+00, 2.2977307719E+01, 3.8954602244E+00, 9.7505131572E-01],
	[4.1635000000E+04, 4.2460997378E+01, 5.2734167300E+00, 2.2986291646E+01, 3.8958166485E+00, 9.7506167661E-01],
	[4.1640000000E+04, 4.2469957101E+01, 5.2734586099E+00, 2.2995278003E+01, 3.8961729780E+00, 9.7507203238E-01],
	[4.1645000000E+04, 4.2478917639E+01, 5.2735004850E+00, 2.3004266791E+01, 3.8965292128E+00, 9.7508238304E-01],
	[4.1650000000E+04, 4.2487878991E+01, 5.2735423555E+00, 2.3013258010E+01, 3.8968853530E+00, 9.7509272860E-01],
	[4.1655000000E+04, 4.2496841158E+01, 5.2735842213E+00, 2.3022251660E+01, 3.8972413987E+00, 9.7510306906E-01],
	[4.1660000000E+04, 4.2505804139E+01, 5.2736260824E+00, 2.3031247742E+01, 3.8975973497E+00, 9.7511340442E-01],
	[4.1665000000E+04, 4.2514767934E+01, 5.2736679387E+00, 2.3040246256E+01, 3.8979532062E+00, 9.7512373468E-01],
	[4.1670000000E+04, 4.2523732543E+01, 5.2737097904E+00, 2.3049247202E+01, 3.8983089682E+00, 9.7513405985E-01],
	[4.1675000000E+04, 4.2532697967E+01, 5.2737516375E+00, 2.3058250581E+01, 3.8986646357E+00, 9.7514437993E-01],
	[4.1680000000E+04, 4.2541664206E+01, 5.2737934798E+00, 2.3067256393E+01, 3.8990202088E+00, 9.7515469491E-01],
	[4.1685000000E+04, 4.2550631258E+01, 5.2738353174E+00, 2.3076264638E+01, 3.8993756874E+00, 9.7516500482E-01],
	[4.1690000000E+04, 4.2559599125E+01, 5.2738771504E+00, 2.3085275317E+01, 3.8997310716E+00, 9.7517530963E-01],
	[4.1695000000E+04, 4.2568567806E+01, 5.2739189786E+00, 2.3094288430E+01, 3.9000863614E+00, 9.7518560937E-01],
	[4.1700000000E+04, 4.2577537301E+01, 5.2739608022E+00, 2.3103303978E+01, 3.9004415568E+00, 9.7519590403E-01],
	[4.1705000000E+04, 4.2586507611E+01, 5.2740026211E+00, 2.3112321961E+01, 3.9007966579E+00, 9.7520619362E-01],
	[4.1710000000E+04, 4.2595478734E+01, 5.2740444353E+00, 2.3121342379E+01, 3.9011516647E+00, 9.7521647813E-01],
	[4.1715000000E+04, 4.2604450672E+01, 5.2740862449E+00, 2.3130365233E+01, 3.9015065772E+00, 9.7522675757E-01],
	[4.1720000000E+04, 4.2613423424E+01, 5.2741280497E+00, 2.3139390522E+01, 3.9018613955E+00, 9.7523703195E-01],
	[4.1725000000E+04, 4.2622396990E+01, 5.2741698499E+00, 2.3148418248E+01, 3.9022161195E+00, 9.7524730126E-01],
	[4.1730000000E+04, 4.2631371369E+01, 5.2742116454E+00, 2.3157448411E+01, 3.9025707493E+00, 9.7525756551E-01],
	[4.1735000000E+04, 4.2640346563E+01, 5.2742534362E+00, 2.3166481011E+01, 3.9029252849E+00, 9.7526782470E-01],
	[4.1740000000E+04, 4.2649322571E+01, 5.2742952224E+00, 2.3175516048E+01, 3.9032797264E+00, 9.7527807883E-01],
	[4.1745000000E+04, 4.2658299393E+01, 5.2743370039E+00, 2.3184553523E+01, 3.9036340737E+00, 9.7528832791E-01],
	[4.1750000000E+04, 4.2667277029E+01, 5.2743787807E+00, 2.3193593436E+01, 3.9039883269E+00, 9.7529857194E-01],
	[4.1755000000E+04, 4.2676255479E+01, 5.2744205528E+00, 2.3202635788E+01, 3.9043424861E+00, 9.7530881092E-01],
	[4.1760000000E+04, 4.2685234743E+01, 5.2744623203E+00, 2.3211680579E+01, 3.9046965512E+00, 9.7531904486E-01],
	[4.1765000000E+04, 4.2694214821E+01, 5.2745040830E+00, 2.3220727809E+01, 3.9050505222E+00, 9.7532927375E-01],
	[4.1770000000E+04, 4.2703195712E+01, 5.2745458412E+00, 2.3229777478E+01, 3.9054043993E+00, 9.7533949760E-01],
	[4.1775000000E+04, 4.2712177418E+01, 5.2745875946E+00, 2.3238829588E+01, 3.9057581824E+00, 9.7534971641E-01],
	[4.1780000000E+04, 4.2721159937E+01, 5.2746293434E+00, 2.3247884138E+01, 3.9061118715E+00, 9.7535993019E-01],
	[4.1785000000E+04, 4.2730143270E+01, 5.2746710875E+00, 2.3256941129E+01, 3.9064654667E+00, 9.7537013894E-01],
	[4.1790000000E+04, 4.2739127417E+01, 5.2747128270E+00, 2.3266000560E+01, 3.9068189680E+00, 9.7538034266E-01],
	[4.1795000000E+04, 4.2748112378E+01, 5.2747545618E+00, 2.3275062434E+01, 3.9071723754E+00, 9.7539054135E-01],
	[4.1800000000E+04, 4.2757098152E+01, 5.2747962919E+00, 2.3284126749E+01, 3.9075256889E+00, 9.7540073501E-01],
	[4.1805000000E+04, 4.2766084740E+01, 5.2748380174E+00, 2.3293193506E+01, 3.9078789087E+00, 9.7541092366E-01],
	[4.1810000000E+04, 4.2775072142E+01, 5.2748797382E+00, 2.3302262706E+01, 3.9082320346E+00, 9.7542110728E-01],
	[4.1815000000E+04, 4.2784060357E+01, 5.2749214543E+00, 2.3311334348E+01, 3.9085850668E+00, 9.7543128589E-01],
	[4.1820000000E+04, 4.2793049386E+01, 5.2749631658E+00, 2.3320408434E+01, 3.9089380052E+00, 9.7544145949E-01],
	[4.1825000000E+04, 4.2802039229E+01, 5.2750048727E+00, 2.3329484964E+01, 3.9092908498E+00, 9.7545162807E-01],
	[4.1830000000E+04, 4.2811048776E+01, 5.2750485199E+00, 2.3338563938E+01, 3.9096448268E+00, 9.7546179165E-01],
	[4.1835000000E+04, 4.2820059270E+01, 5.2750921756E+00, 2.3347645356E+01, 3.9099987187E+00, 9.7547195022E-01],
	[4.1840000000E+04, 4.2829070584E+01, 5.2751358263E+00, 2.3356729218E+01, 3.9103525171E+00, 9.7548210379E-01],
	[4.1845000000E+04, 4.2838082717E+01, 5.2751794723E+00, 2.3365815526E+01, 3.9107062222E+00, 9.7549225236E-01],
	[4.1850000000E+04, 4.2847095669E+01, 5.2752231133E+00, 2.3374904280E+01, 3.9110598338E+00, 9.7550239593E-01],
	[4.1855000000E+04, 4.2856109441E+01, 5.2752667496E+00, 2.3383995479E+01, 3.9114133521E+00, 9.7551253450E-01],
	[4.1860000000E+04, 4.2865124031E+01, 5.2753103809E+00, 2.3393089124E+01, 3.9117667770E+00, 9.7552266809E-01],
	[4.1865000000E+04, 4.2874139441E+01, 5.2753540074E+00, 2.3402185216E+01, 3.9121201086E+00, 9.7553279668E-01],
	[4.1870000000E+04, 4.2883155670E+01, 5.2753976291E+00, 2.3411283755E+01, 3.9124733470E+00, 9.7554292029E-01],
	[4.1875000000E+04, 4.2892172718E+01, 5.2754412459E+00, 2.3420384741E+01, 3.9128264921E+00, 9.7555303891E-01],
	[4.1880000000E+04, 4.2901190585E+01, 5.2754848579E+00, 2.3429488175E+01, 3.9131795439E+00, 9.7556315255E-01],
	[4.1885000000E+04, 4.2910209271E+01, 5.2755284650E+00, 2.3438594057E+01, 3.9135325026E+00, 9.7557326121E-01],
	[4.1890000000E+04, 4.2919228776E+01, 5.2755720673E+00, 2.3447702387E+01, 3.9138853681E+00, 9.7558336490E-01],
	[4.1895000000E+04, 4.2928249100E+01, 5.2756156647E+00, 2.3456813166E+01, 3.9142381404E+00, 9.7559346361E-01],
	[4.1900000000E+04, 4.2937270243E+01, 5.2756592573E+00, 2.3465926394E+01, 3.9145908196E+00, 9.7560355735E-01],
	[4.1905000000E+04, 4.2946292205E+01, 5.2757028451E+00, 2.3475042072E+01, 3.9149434056E+00, 9.7561364613E-01],
	[4.1910000000E+04, 4.2955314986E+01, 5.2757464280E+00, 2.3484160199E+01, 3.9152958986E+00, 9.7562372993E-01],
	[4.1915000000E+04, 4.2964338586E+01, 5.2757900060E+00, 2.3493280777E+01, 3.9156482986E+00, 9.7563380878E-01],
	[4.1920000000E+04, 4.2973363005E+01, 5.2758335793E+00, 2.3502403805E+01, 3.9160006055E+00, 9.7564388266E-01],
	[4.1925000000E+04, 4.2982388243E+01, 5.2758771477E+00, 2.3511529284E+01, 3.9163528194E+00, 9.7565395159E-01],
	[4.1930000000E+04, 4.2991414299E+01, 5.2759207112E+00, 2.3520657215E+01, 3.9167049403E+00, 9.7566401556E-01],
	[4.1935000000E+04, 4.3000441175E+01, 5.2759642700E+00, 2.3529787597E+01, 3.9170569683E+00, 9.7567407458E-01],
	[4.1940000000E+04, 4.3009468869E+01, 5.2760078238E+00, 2.3538920431E+01, 3.9174089033E+00, 9.7568412865E-01],
	[4.1945000000E+04, 4.3018497382E+01, 5.2760513729E+00, 2.3548055717E+01, 3.9177607455E+00, 9.7569417778E-01],
	[4.1950000000E+04, 4.3027526713E+01, 5.2760949171E+00, 2.3557193457E+01, 3.9181124947E+00, 9.7570422195E-01],
	[4.1955000000E+04, 4.3036556864E+01, 5.2761384565E+00, 2.3566333649E+01, 3.9184641511E+00, 9.7571426119E-01],
	[4.1960000000E+04, 4.3045587833E+01, 5.2761819911E+00, 2.3575476295E+01, 3.9188157147E+00, 9.7572429549E-01],
	[4.1965000000E+04, 4.3054619621E+01, 5.2762255208E+00, 2.3584621395E+01, 3.9191671854E+00, 9.7573432485E-01],
	[4.1970000000E+04, 4.3063652227E+01, 5.2762690457E+00, 2.3593768949E+01, 3.9195185634E+00, 9.7574434928E-01],
	[4.1975000000E+04, 4.3072685652E+01, 5.2763125658E+00, 2.3602918958E+01, 3.9198698487E+00, 9.7575436878E-01],
	[4.1980000000E+04, 4.3081719896E+01, 5.2763560811E+00, 2.3612071421E+01, 3.9202210412E+00, 9.7576438334E-01],
	[4.1985000000E+04, 4.3090754958E+01, 5.2763995915E+00, 2.3621226340E+01, 3.9205721410E+00, 9.7577439299E-01],
	[4.1990000000E+04, 4.3099790839E+01, 5.2764430971E+00, 2.3630383714E+01, 3.9209231481E+00, 9.7578439771E-01],
	[4.1995000000E+04, 4.3108827539E+01, 5.2764865979E+00, 2.3639543545E+01, 3.9212740626E+00, 9.7579439750E-01],
	[4.2000000000E+04, 4.3117865057E+01, 5.2765300939E+00, 2.3648705832E+01, 3.9216248844E+00, 9.7580439239E-01],
	[4.2005000000E+04, 4.3126903393E+01, 5.2765735851E+00, 2.3657870576E+01, 3.9219756137E+00, 9.7581438235E-01],
	[4.2010000000E+04, 4.3135942548E+01, 5.2766170714E+00, 2.3667037777E+01, 3.9223262503E+00, 9.7582436740E-01],
	[4.2015000000E+04, 4.3144982521E+01, 5.2766605529E+00, 2.3676207435E+01, 3.9226767945E+00, 9.7583434755E-01],
	[4.2020000000E+04, 4.3154023313E+01, 5.2767040296E+00, 2.3685379552E+01, 3.9230272460E+00, 9.7584432278E-01],
	[4.2025000000E+04, 4.3163064923E+01, 5.2767475015E+00, 2.3694554126E+01, 3.9233776051E+00, 9.7585429312E-01],
	[4.2030000000E+04, 4.3172107352E+01, 5.2767909686E+00, 2.3703731159E+01, 3.9237278717E+00, 9.7586425854E-01],
	[4.2035000000E+04, 4.3181150598E+01, 5.2768344308E+00, 2.3712910651E+01, 3.9240780459E+00, 9.7587421907E-01],
	[4.2040000000E+04, 4.3190194664E+01, 5.2768778883E+00, 2.3722092603E+01, 3.9244281276E+00, 9.7588417471E-01],
	[4.2045000000E+04, 4.3199239547E+01, 5.2769213409E+00, 2.3731277014E+01, 3.9247781170E+00, 9.7589412545E-01],
	[4.2050000000E+04, 4.3208285249E+01, 5.2769647888E+00, 2.3740463885E+01, 3.9251280139E+00, 9.7590407129E-01],
	[4.2055000000E+04, 4.3217331769E+01, 5.2770082318E+00, 2.3749653217E+01, 3.9254778185E+00, 9.7591401225E-01],
	[4.2060000000E+04, 4.3226379107E+01, 5.2770516700E+00, 2.3758845009E+01, 3.9258275308E+00, 9.7592394833E-01],
	[4.2065000000E+04, 4.3235427264E+01, 5.2770951034E+00, 2.3768039263E+01, 3.9261771508E+00, 9.7593387952E-01],
	[4.2070000000E+04, 4.3244476239E+01, 5.2771385320E+00, 2.3777235978E+01, 3.9265266785E+00, 9.7594380582E-01],
	[4.2075000000E+04, 4.3253526031E+01, 5.2771819558E+00, 2.3786435155E+01, 3.9268761140E+00, 9.7595372725E-01],
	[4.2080000000E+04, 4.3262576643E+01, 5.2772253748E+00, 2.3795636794E+01, 3.9272254572E+00, 9.7596364381E-01],
	[4.2085000000E+04, 4.3271628072E+01, 5.2772687890E+00, 2.3804840896E+01, 3.9275747082E+00, 9.7597355549E-01],
	[4.2090000000E+04, 4.3280680319E+01, 5.2773121984E+00, 2.3814047461E+01, 3.9279238671E+00, 9.7598346230E-01],
	[4.2095000000E+04, 4.3289733384E+01, 5.2773556030E+00, 2.3823256489E+01, 3.9282729338E+00, 9.7599336424E-01],
	[4.2100000000E+04, 4.3298787268E+01, 5.2773990028E+00, 2.3832467981E+01, 3.9286219084E+00, 9.7600326132E-01],
	[4.2105000000E+04, 4.3307841969E+01, 5.2774423978E+00, 2.3841681937E+01, 3.9289707909E+00, 9.7601315353E-01],
	[4.2110000000E+04, 4.3316897488E+01, 5.2774857880E+00, 2.3850898358E+01, 3.9293195813E+00, 9.7602304089E-01],
	[4.2115000000E+04, 4.3325953826E+01, 5.2775291734E+00, 2.3860117243E+01, 3.9296682797E+00, 9.7603292339E-01],
	[4.2120000000E+04, 4.3335010981E+01, 5.2775725540E+00, 2.3869338593E+01, 3.9300168860E+00, 9.7604280103E-01],
	[4.2125000000E+04, 4.3344068954E+01, 5.2776159298E+00, 2.3878562409E+01, 3.9303654004E+00, 9.7605267382E-01],
	[4.2130000000E+04, 4.3353127746E+01, 5.2776593009E+00, 2.3887788691E+01, 3.9307138227E+00, 9.7606254176E-01],
	[4.2135000000E+04, 4.3362187355E+01, 5.2777026671E+00, 2.3897017439E+01, 3.9310621532E+00, 9.7607240486E-01],
	[4.2140000000E+04, 4.3371247782E+01, 5.2777460286E+00, 2.3906248654E+01, 3.9314103917E+00, 9.7608226311E-01],
	[4.2145000000E+04, 4.3380309026E+01, 5.2777893852E+00, 2.3915482336E+01, 3.9317585383E+00, 9.7609211652E-01],
	[4.2150000000E+04, 4.3389371089E+01, 5.2778327371E+00, 2.3924718485E+01, 3.9321065930E+00, 9.7610196509E-01],
	[4.2155000000E+04, 4.3398433970E+01, 5.2778760842E+00, 2.3933957102E+01, 3.9324545559E+00, 9.7611180883E-01],
	[4.2160000000E+04, 4.3407497668E+01, 5.2779194265E+00, 2.3943198187E+01, 3.9328024269E+00, 9.7612164773E-01],
	[4.2165000000E+04, 4.3416562184E+01, 5.2779627640E+00, 2.3952441740E+01, 3.9331502062E+00, 9.7613148180E-01],
	[4.2170000000E+04, 4.3425627517E+01, 5.2780060967E+00, 2.3961687763E+01, 3.9334978937E+00, 9.7614131104E-01],
	[4.2175000000E+04, 4.3434693669E+01, 5.2780494247E+00, 2.3970936254E+01, 3.9338454894E+00, 9.7615113545E-01],
	[4.2180000000E+04, 4.3443760638E+01, 5.2780927479E+00, 2.3980187215E+01, 3.9341929935E+00, 9.7616095504E-01],
	[4.2185000000E+04, 4.3452828424E+01, 5.2781360663E+00, 2.3989440646E+01, 3.9345404058E+00, 9.7617076981E-01],
	[4.2190000000E+04, 4.3461897029E+01, 5.2781793799E+00, 2.3998696547E+01, 3.9348877264E+00, 9.7618057977E-01],
	[4.2195000000E+04, 4.3470966451E+01, 5.2782226887E+00, 2.4007954919E+01, 3.9352349555E+00, 9.7619038491E-01],
	[4.2200000000E+04, 4.3480036690E+01, 5.2782659928E+00, 2.4017215762E+01, 3.9355820928E+00, 9.7620018523E-01],
	[4.2205000000E+04, 4.3489107747E+01, 5.2783092921E+00, 2.4026479076E+01, 3.9359291386E+00, 9.7620998075E-01],
	[4.2210000000E+04, 4.3498179622E+01, 5.2783525866E+00, 2.4035744863E+01, 3.9362760929E+00, 9.7621977145E-01],
	[4.2215000000E+04, 4.3507252314E+01, 5.2783958763E+00, 2.4045013121E+01, 3.9366229555E+00, 9.7622955736E-01],
	[4.2220000000E+04, 4.3516325824E+01, 5.2784391613E+00, 2.4054283851E+01, 3.9369697267E+00, 9.7623933846E-01],
	[4.2225000000E+04, 4.3525400151E+01, 5.2784824415E+00, 2.4063557055E+01, 3.9373164063E+00, 9.7624911476E-01],
	[4.2230000000E+04, 4.3534475296E+01, 5.2785257169E+00, 2.4072832731E+01, 3.9376629945E+00, 9.7625888626E-01],
	[4.2235000000E+04, 4.3543551258E+01, 5.2785689875E+00, 2.4082110882E+01, 3.9380094913E+00, 9.7626865297E-01],
	[4.2240000000E+04, 4.3552628037E+01, 5.2786122534E+00, 2.4091391506E+01, 3.9383558966E+00, 9.7627841488E-01],
	[4.2245000000E+04, 4.3561705634E+01, 5.2786555146E+00, 2.4100674604E+01, 3.9387022105E+00, 9.7628817201E-01],
	[4.2250000000E+04, 4.3570784048E+01, 5.2786987709E+00, 2.4109960178E+01, 3.9390484331E+00, 9.7629792435E-01],
	[4.2255000000E+04, 4.3579863279E+01, 5.2787420225E+00, 2.4119248226E+01, 3.9393945643E+00, 9.7630767191E-01],
	[4.2260000000E+04, 4.3588943328E+01, 5.2787852693E+00, 2.4128538749E+01, 3.9397406042E+00, 9.7631741468E-01],
	[4.2265000000E+04, 4.3598024194E+01, 5.2788285114E+00, 2.4137831749E+01, 3.9400865527E+00, 9.7632715268E-01],
	[4.2270000000E+04, 4.3607105878E+01, 5.2788717487E+00, 2.4147127224E+01, 3.9404324101E+00, 9.7633688590E-01],
	[4.2275000000E+04, 4.3616188378E+01, 5.2789149813E+00, 2.4156425176E+01, 3.9407781761E+00, 9.7634661435E-01],
	[4.2280000000E+04, 4.3625271696E+01, 5.2789582090E+00, 2.4165725605E+01, 3.9411238510E+00, 9.7635633802E-01],
	[4.2285000000E+04, 4.3634355831E+01, 5.2790014321E+00, 2.4175028511E+01, 3.9414694347E+00, 9.7636605693E-01],
	[4.2290000000E+04, 4.3643440783E+01, 5.2790446503E+00, 2.4184333895E+01, 3.9418149272E+00, 9.7637577107E-01],
	[4.2295000000E+04, 4.3652526552E+01, 5.2790878639E+00, 2.4193641757E+01, 3.9421603285E+00, 9.7638548045E-01],
	[4.2300000000E+04, 4.3661613139E+01, 5.2791310726E+00, 2.4202952097E+01, 3.9425056387E+00, 9.7639518506E-01],
	[4.2305000000E+04, 4.3670700542E+01, 5.2791742766E+00, 2.4212264916E+01, 3.9428508579E+00, 9.7640488492E-01],
	[4.2310000000E+04, 4.3679788763E+01, 5.2792174759E+00, 2.4221580213E+01, 3.9431959859E+00, 9.7641458002E-01],
	[4.2315000000E+04, 4.3688877801E+01, 5.2792606704E+00, 2.4230897991E+01, 3.9435410229E+00, 9.7642427037E-01],
	[4.2320000000E+04, 4.3697967655E+01, 5.2793038601E+00, 2.4240218248E+01, 3.9438859689E+00, 9.7643395597E-01],
	[4.2325000000E+04, 4.3707058327E+01, 5.2793470452E+00, 2.4249540985E+01, 3.9442308239E+00, 9.7644363682E-01],
	[4.2330000000E+04, 4.3716149816E+01, 5.2793902254E+00, 2.4258866202E+01, 3.9445755880E+00, 9.7645331293E-01],
	[4.2335000000E+04, 4.3725242121E+01, 5.2794334009E+00, 2.4268193901E+01, 3.9449202610E+00, 9.7646298429E-01],
	[4.2340000000E+04, 4.3734335244E+01, 5.2794765717E+00, 2.4277524081E+01, 3.9452648432E+00, 9.7647265092E-01],
	[4.2345000000E+04, 4.3743429183E+01, 5.2795197377E+00, 2.4286856742E+01, 3.9456093345E+00, 9.7648231280E-01],
	[4.2350000000E+04, 4.3752523940E+01, 5.2795628990E+00, 2.4296191886E+01, 3.9459537349E+00, 9.7649196995E-01],
	[4.2355000000E+04, 4.3761619513E+01, 5.2796060555E+00, 2.4305529511E+01, 3.9462980445E+00, 9.7650162237E-01],
	[4.2360000000E+04, 4.3770715903E+01, 5.2796492073E+00, 2.4314869620E+01, 3.9466422632E+00, 9.7651127006E-01],
	[4.2365000000E+04, 4.3779813110E+01, 5.2796923544E+00, 2.4324212211E+01, 3.9469863911E+00, 9.7652091302E-01],
	[4.2370000000E+04, 4.3788911134E+01, 5.2797354967E+00, 2.4333557286E+01, 3.9473304283E+00, 9.7653055126E-01],
	[4.2375000000E+04, 4.3798009974E+01, 5.2797786342E+00, 2.4342904845E+01, 3.9476743747E+00, 9.7654018478E-01],
	[4.2380000000E+04, 4.3807109632E+01, 5.2798217671E+00, 2.4352254888E+01, 3.9480182305E+00, 9.7654981357E-01],
	[4.2385000000E+04, 4.3816210106E+01, 5.2798648952E+00, 2.4361607416E+01, 3.9483619955E+00, 9.7655943765E-01],
	[4.2390000000E+04, 4.3825311397E+01, 5.2799080185E+00, 2.4370962428E+01, 3.9487056698E+00, 9.7656905702E-01],
	[4.2395000000E+04, 4.3834413504E+01, 5.2799511372E+00, 2.4380319926E+01, 3.9490492535E+00, 9.7657867167E-01],
	[4.2400000000E+04, 4.3843516428E+01, 5.2799942511E+00, 2.4389679909E+01, 3.9493927466E+00, 9.7658828161E-01],
	[4.2405000000E+04, 4.3852620169E+01, 5.2800373602E+00, 2.4399042379E+01, 3.9497361491E+00, 9.7659788685E-01],
	[4.2410000000E+04, 4.3861724726E+01, 5.2800804647E+00, 2.4408407335E+01, 3.9500794610E+00, 9.7660748739E-01],
	[4.2415000000E+04, 4.3870830100E+01, 5.2801235644E+00, 2.4417774777E+01, 3.9504226824E+00, 9.7661708322E-01],
	[4.2420000000E+04, 4.3879936290E+01, 5.2801666594E+00, 2.4427144707E+01, 3.9507658132E+00, 9.7662667435E-01],
	[4.2425000000E+04, 4.3889043298E+01, 5.2802097496E+00, 2.4436517124E+01, 3.9511088536E+00, 9.7663626079E-01],
	[4.2430000000E+04, 4.3898151121E+01, 5.2802528351E+00, 2.4445892029E+01, 3.9514518035E+00, 9.7664584253E-01],
	[4.2435000000E+04, 4.3907259761E+01, 5.2802959159E+00, 2.4455269422E+01, 3.9517946629E+00, 9.7665541958E-01],
	[4.2440000000E+04, 4.3916369218E+01, 5.2803389920E+00, 2.4464649303E+01, 3.9521374320E+00, 9.7666499195E-01],
	[4.2445000000E+04, 4.3925479491E+01, 5.2803820633E+00, 2.4474031674E+01, 3.9524801106E+00, 9.7667455963E-01],
	[4.2450000000E+04, 4.3934590580E+01, 5.2804251300E+00, 2.4483416534E+01, 3.9528226989E+00, 9.7668412262E-01],
	[4.2455000000E+04, 4.3943702486E+01, 5.2804681919E+00, 2.4492803883E+01, 3.9531651968E+00, 9.7669368094E-01],
	[4.2460000000E+04, 4.3952815208E+01, 5.2805112491E+00, 2.4502193723E+01, 3.9535076044E+00, 9.7670323457E-01],
	[4.2465000000E+04, 4.3961928747E+01, 5.2805543015E+00, 2.4511586053E+01, 3.9538499217E+00, 9.7671278353E-01],
	[4.2470000000E+04, 4.3971043102E+01, 5.2805973493E+00, 2.4520980874E+01, 3.9541921487E+00, 9.7672232782E-01],
	[4.2475000000E+04, 4.3980158273E+01, 5.2806403923E+00, 2.4530378186E+01, 3.9545342855E+00, 9.7673186743E-01],
	[4.2480000000E+04, 4.3989274261E+01, 5.2806834306E+00, 2.4539777989E+01, 3.9548763321E+00, 9.7674140238E-01],
	[4.2485000000E+04, 4.3998391064E+01, 5.2807264642E+00, 2.4549180284E+01, 3.9552182884E+00, 9.7675093266E-01],
	[4.2490000000E+04, 4.4007508685E+01, 5.2807694931E+00, 2.4558585072E+01, 3.9555601546E+00, 9.7676045828E-01],
	[4.2495000000E+04, 4.4016627121E+01, 5.2808125173E+00, 2.4567992352E+01, 3.9559019307E+00, 9.7676997924E-01],
	[4.2500000000E+04, 4.4025752598E+01, 5.2808561660E+00, 2.4577402125E+01, 3.9562440200E+00, 9.7677949554E-01],
	[4.2505000000E+04, 4.4034891645E+01, 5.2809010987E+00, 2.4586814391E+01, 3.9565868458E+00, 9.7678900719E-01],
	[4.2510000000E+04, 4.4044031513E+01, 5.2809460265E+00, 2.4596229151E+01, 3.9569295816E+00, 9.7679851418E-01],
	[4.2515000000E+04, 4.4053172204E+01, 5.2809909494E+00, 2.4605646406E+01, 3.9572722276E+00, 9.7680801653E-01],
	[4.2520000000E+04, 4.4062313716E+01, 5.2810358674E+00, 2.4615066154E+01, 3.9576147838E+00, 9.7681751422E-01],
	[4.2525000000E+04, 4.4071456050E+01, 5.2810807805E+00, 2.4624488397E+01, 3.9579572502E+00, 9.7682700727E-01],
	[4.2530000000E+04, 4.4080599206E+01, 5.2811256887E+00, 2.4633913136E+01, 3.9582996268E+00, 9.7683649568E-01],
	[4.2535000000E+04, 4.4089743183E+01, 5.2811705920E+00, 2.4643340370E+01, 3.9586419137E+00, 9.7684597945E-01],
	[4.2540000000E+04, 4.4098887982E+01, 5.2812154905E+00, 2.4652770100E+01, 3.9589841109E+00, 9.7685545858E-01],
	[4.2545000000E+04, 4.4108033603E+01, 5.2812603840E+00, 2.4662202326E+01, 3.9593262183E+00, 9.7686493308E-01],
	[4.2550000000E+04, 4.4117180045E+01, 5.2813052726E+00, 2.4671637049E+01, 3.9596682361E+00, 9.7687440294E-01],
	[4.2555000000E+04, 4.4126327309E+01, 5.2813501563E+00, 2.4681074268E+01, 3.9600101642E+00, 9.7688386818E-01],
	[4.2560000000E+04, 4.4135475395E+01, 5.2813950352E+00, 2.4690513985E+01, 3.9603520027E+00, 9.7689332878E-01],
	[4.2565000000E+04, 4.4144624302E+01, 5.2814399091E+00, 2.4699956200E+01, 3.9606937516E+00, 9.7690278476E-01],
	[4.2570000000E+04, 4.4153774030E+01, 5.2814847782E+00, 2.4709400913E+01, 3.9610354110E+00, 9.7691223612E-01],
	[4.2575000000E+04, 4.4162924580E+01, 5.2815296424E+00, 2.4718848125E+01, 3.9613769808E+00, 9.7692168287E-01],
	[4.2580000000E+04, 4.4172075952E+01, 5.2815745016E+00, 2.4728297835E+01, 3.9617184610E+00, 9.7693112499E-01],
	[4.2585000000E+04, 4.4181228144E+01, 5.2816193560E+00, 2.4737750044E+01, 3.9620598518E+00, 9.7694056250E-01],
	[4.2590000000E+04, 4.4190381159E+01, 5.2816642056E+00, 2.4747204753E+01, 3.9624011531E+00, 9.7694999539E-01],
	[4.2595000000E+04, 4.4199534995E+01, 5.2817090502E+00, 2.4756661962E+01, 3.9627423649E+00, 9.7695942368E-01],
	[4.2600000000E+04, 4.4208689652E+01, 5.2817538899E+00, 2.4766121671E+01, 3.9630834873E+00, 9.7696884736E-01],
	[4.2605000000E+04, 4.4217845130E+01, 5.2817987248E+00, 2.4775583881E+01, 3.9634245203E+00, 9.7697826644E-01],
	[4.2610000000E+04, 4.4227001430E+01, 5.2818435548E+00, 2.4785048591E+01, 3.9637654640E+00, 9.7698768091E-01],
	[4.2615000000E+04, 4.4236158551E+01, 5.2818883799E+00, 2.4794515803E+01, 3.9641063183E+00, 9.7699709079E-01],
	[4.2620000000E+04, 4.4245316494E+01, 5.2819332001E+00, 2.4803985517E+01, 3.9644470832E+00, 9.7700649607E-01],
	[4.2625000000E+04, 4.4254475258E+01, 5.2819780155E+00, 2.4813457733E+01, 3.9647877589E+00, 9.7701589675E-01],
	[4.2630000000E+04, 4.4263634843E+01, 5.2820228259E+00, 2.4822932452E+01, 3.9651283453E+00, 9.7702529284E-01],
	[4.2635000000E+04, 4.4272795249E+01, 5.2820676315E+00, 2.4832409673E+01, 3.9654688424E+00, 9.7703468435E-01],
	[4.2640000000E+04, 4.4281956476E+01, 5.2821124323E+00, 2.4841889398E+01, 3.9658092503E+00, 9.7704407126E-01],
	[4.2645000000E+04, 4.4291118525E+01, 5.2821572281E+00, 2.4851371626E+01, 3.9661495690E+00, 9.7705345360E-01],
	[4.2650000000E+04, 4.4300281394E+01, 5.2822020191E+00, 2.4860856358E+01, 3.9664897985E+00, 9.7706283135E-01],
	[4.2655000000E+04, 4.4309445085E+01, 5.2822468052E+00, 2.4870343594E+01, 3.9668299389E+00, 9.7707220452E-01],
	[4.2660000000E+04, 4.4318609597E+01, 5.2822915864E+00, 2.4879833335E+01, 3.9671699901E+00, 9.7708157311E-01],
	[4.2665000000E+04, 4.4327774930E+01, 5.2823363628E+00, 2.4889325581E+01, 3.9675099522E+00, 9.7709093714E-01],
	[4.2670000000E+04, 4.4336941085E+01, 5.2823811343E+00, 2.4898820333E+01, 3.9678498253E+00, 9.7710029659E-01],
	[4.2675000000E+04, 4.4346108060E+01, 5.2824259009E+00, 2.4908317590E+01, 3.9681896093E+00, 9.7710965147E-01],
	[4.2680000000E+04, 4.4355275856E+01, 5.2824706627E+00, 2.4917817353E+01, 3.9685293042E+00, 9.7711900178E-01],
	[4.2685000000E+04, 4.4364444473E+01, 5.2825154196E+00, 2.4927319623E+01, 3.9688689102E+00, 9.7712834753E-01],
	[4.2690000000E+04, 4.4373613911E+01, 5.2825601716E+00, 2.4936824400E+01, 3.9692084272E+00, 9.7713768872E-01],
	[4.2695000000E+04, 4.4382784171E+01, 5.2826049188E+00, 2.4946331684E+01, 3.9695478552E+00, 9.7714702535E-01],
	[4.2700000000E+04, 4.4391955251E+01, 5.2826496611E+00, 2.4955841476E+01, 3.9698871943E+00, 9.7715635743E-01],
	[4.2705000000E+04, 4.4401127152E+01, 5.2826943986E+00, 2.4965353775E+01, 3.9702264445E+00, 9.7716568495E-01],
	[4.2710000000E+04, 4.4410299874E+01, 5.2827391312E+00, 2.4974868583E+01, 3.9705656058E+00, 9.7717500791E-01],
	[4.2715000000E+04, 4.4419473416E+01, 5.2827838589E+00, 2.4984385900E+01, 3.9709046782E+00, 9.7718432633E-01],
	[4.2720000000E+04, 4.4428647780E+01, 5.2828285818E+00, 2.4993905726E+01, 3.9712436618E+00, 9.7719364021E-01],
	[4.2725000000E+04, 4.4437822964E+01, 5.2828732998E+00, 2.5003428061E+01, 3.9715825567E+00, 9.7720294954E-01],
	[4.2730000000E+04, 4.4446998969E+01, 5.2829180130E+00, 2.5012952906E+01, 3.9719213627E+00, 9.7721225433E-01],
	[4.2735000000E+04, 4.4456175795E+01, 5.2829627213E+00, 2.5022480261E+01, 3.9722600799E+00, 9.7722155458E-01],
	[4.2740000000E+04, 4.4465353442E+01, 5.2830074248E+00, 2.5032010127E+01, 3.9725987085E+00, 9.7723085029E-01],
	[4.2745000000E+04, 4.4474531909E+01, 5.2830521234E+00, 2.5041542503E+01, 3.9729372483E+00, 9.7724014147E-01],
	[4.2750000000E+04, 4.4483711198E+01, 5.2830968172E+00, 2.5051077391E+01, 3.9732756994E+00, 9.7724942812E-01],
	[4.2755000000E+04, 4.4492891306E+01, 5.2831415061E+00, 2.5060614791E+01, 3.9736140619E+00, 9.7725871024E-01],
	[4.2760000000E+04, 4.4502072236E+01, 5.2831861902E+00, 2.5070154702E+01, 3.9739523357E+00, 9.7726798783E-01],
	[4.2765000000E+04, 4.4511253986E+01, 5.2832308694E+00, 2.5079697126E+01, 3.9742905210E+00, 9.7727726090E-01],
	[4.2770000000E+04, 4.4520436557E+01, 5.2832755438E+00, 2.5089242063E+01, 3.9746286176E+00, 9.7728652945E-01],
	[4.2775000000E+04, 4.4529619948E+01, 5.2833202133E+00, 2.5098789512E+01, 3.9749666257E+00, 9.7729579348E-01],
	[4.2780000000E+04, 4.4538804160E+01, 5.2833648780E+00, 2.5108339475E+01, 3.9753045452E+00, 9.7730505299E-01],
	[4.2785000000E+04, 4.4547989192E+01, 5.2834095378E+00, 2.5117891952E+01, 3.9756423763E+00, 9.7731430799E-01],
	[4.2790000000E+04, 4.4557175045E+01, 5.2834541928E+00, 2.5127446944E+01, 3.9759801188E+00, 9.7732355848E-01],
	[4.2795000000E+04, 4.4566361719E+01, 5.2834988430E+00, 2.5137004449E+01, 3.9763177729E+00, 9.7733280446E-01],
	[4.2800000000E+04, 4.4575549213E+01, 5.2835434883E+00, 2.5146564470E+01, 3.9766553385E+00, 9.7734204594E-01],
	[4.2805000000E+04, 4.4584737527E+01, 5.2835881288E+00, 2.5156127006E+01, 3.9769928158E+00, 9.7735128291E-01],
	[4.2810000000E+04, 4.4593926662E+01, 5.2836327645E+00, 2.5165692058E+01, 3.9773302046E+00, 9.7736051537E-01],
	[4.2815000000E+04, 4.4603116617E+01, 5.2836773953E+00, 2.5175259626E+01, 3.9776675051E+00, 9.7736974334E-01],
	[4.2820000000E+04, 4.4612307393E+01, 5.2837220213E+00, 2.5184829710E+01, 3.9780047172E+00, 9.7737896682E-01],
	[4.2825000000E+04, 4.4621498989E+01, 5.2837666424E+00, 2.5194402311E+01, 3.9783418410E+00, 9.7738818580E-01],
	[4.2830000000E+04, 4.4630691405E+01, 5.2838112587E+00, 2.5203977429E+01, 3.9786788766E+00, 9.7739740029E-01],
	[4.2835000000E+04, 4.4639884642E+01, 5.2838558702E+00, 2.5213555064E+01, 3.9790158238E+00, 9.7740661029E-01],
	[4.2840000000E+04, 4.4649078699E+01, 5.2839004769E+00, 2.5223135218E+01, 3.9793526829E+00, 9.7741581580E-01],
	[4.2845000000E+04, 4.4658273576E+01, 5.2839450787E+00, 2.5232717889E+01, 3.9796894537E+00, 9.7742501683E-01],
	[4.2850000000E+04, 4.4667469274E+01, 5.2839896757E+00, 2.5242303080E+01, 3.9800261363E+00, 9.7743421338E-01],
	[4.2855000000E+04, 4.4676665791E+01, 5.2840342678E+00, 2.5251890789E+01, 3.9803627307E+00, 9.7744340545E-01],
	[4.2860000000E+04, 4.4685863129E+01, 5.2840788552E+00, 2.5261481017E+01, 3.9806992370E+00, 9.7745259304E-01],
	[4.2865000000E+04, 4.4695061287E+01, 5.2841234377E+00, 2.5271073766E+01, 3.9810356552E+00, 9.7746177616E-01],
	[4.2870000000E+04, 4.4704260266E+01, 5.2841680154E+00, 2.5280669034E+01, 3.9813719853E+00, 9.7747095481E-01],
	[4.2875000000E+04, 4.4713460064E+01, 5.2842125882E+00, 2.5290266823E+01, 3.9817082273E+00, 9.7748012899E-01],
	[4.2880000000E+04, 4.4722660683E+01, 5.2842571563E+00, 2.5299867132E+01, 3.9820443813E+00, 9.7748929870E-01],
	[4.2885000000E+04, 4.4731862121E+01, 5.2843017195E+00, 2.5309469963E+01, 3.9823804472E+00, 9.7749846395E-01],
	[4.2890000000E+04, 4.4741064380E+01, 5.2843462779E+00, 2.5319075315E+01, 3.9827164252E+00, 9.7750762474E-01],
	[4.2895000000E+04, 4.4750267459E+01, 5.2843908315E+00, 2.5328683190E+01, 3.9830523152E+00, 9.7751678106E-01],
	[4.2900000000E+04, 4.4759471357E+01, 5.2844353803E+00, 2.5338293586E+01, 3.9833881172E+00, 9.7752593294E-01],
	[4.2905000000E+04, 4.4768676076E+01, 5.2844799242E+00, 2.5347906505E+01, 3.9837238313E+00, 9.7753508035E-01],
	[4.2910000000E+04, 4.4777881615E+01, 5.2845244634E+00, 2.5357521947E+01, 3.9840594575E+00, 9.7754422332E-01],
	[4.2915000000E+04, 4.4787087974E+01, 5.2845689977E+00, 2.5367139913E+01, 3.9843949959E+00, 9.7755336184E-01],
	[4.2920000000E+04, 4.4796295152E+01, 5.2846135272E+00, 2.5376760402E+01, 3.9847304464E+00, 9.7756249591E-01],
	[4.2925000000E+04, 4.4805503151E+01, 5.2846580519E+00, 2.5386383415E+01, 3.9850658090E+00, 9.7757162553E-01],
	[4.2930000000E+04, 4.4814711969E+01, 5.2847025718E+00, 2.5396008953E+01, 3.9854010839E+00, 9.7758075072E-01],
	[4.2935000000E+04, 4.4823921608E+01, 5.2847470869E+00, 2.5405637016E+01, 3.9857362710E+00, 9.7758987146E-01],
	[4.2940000000E+04, 4.4833132066E+01, 5.2847915972E+00, 2.5415267604E+01, 3.9860713704E+00, 9.7759898777E-01],
	[4.2945000000E+04, 4.4842343344E+01, 5.2848361026E+00, 2.5424900717E+01, 3.9864063820E+00, 9.7760809965E-01],
	[4.2950000000E+04, 4.4851555442E+01, 5.2848806033E+00, 2.5434536356E+01, 3.9867413059E+00, 9.7761720709E-01],
	[4.2955000000E+04, 4.4860768359E+01, 5.2849250991E+00, 2.5444174522E+01, 3.9870761421E+00, 9.7762631010E-01],
	[4.2960000000E+04, 4.4869982097E+01, 5.2849695902E+00, 2.5453815214E+01, 3.9874108907E+00, 9.7763540869E-01],
	[4.2965000000E+04, 4.4879196654E+01, 5.2850140764E+00, 2.5463458434E+01, 3.9877455517E+00, 9.7764450285E-01],
	[4.2970000000E+04, 4.4888412030E+01, 5.2850585578E+00, 2.5473104180E+01, 3.9880801250E+00, 9.7765359259E-01],
	[4.2975000000E+04, 4.4897628227E+01, 5.2851030345E+00, 2.5482752455E+01, 3.9884146108E+00, 9.7766267791E-01],
	[4.2980000000E+04, 4.4906845243E+01, 5.2851475063E+00, 2.5492403258E+01, 3.9887490090E+00, 9.7767175882E-01],
	[4.2985000000E+04, 4.4916063079E+01, 5.2851919734E+00, 2.5502056589E+01, 3.9890833197E+00, 9.7768083531E-01],
	[4.2990000000E+04, 4.4925281734E+01, 5.2852364356E+00, 2.5511712449E+01, 3.9894175429E+00, 9.7768990738E-01],
	[4.2995000000E+04, 4.4934501209E+01, 5.2852808930E+00, 2.5521370838E+01, 3.9897516786E+00, 9.7769897505E-01],
	[4.3000000000E+04, 4.4943721504E+01, 5.2853253457E+00, 2.5531031757E+01, 3.9900857269E+00, 9.7770803831E-01],
	[4.3005000000E+04, 4.4952942618E+01, 5.2853697935E+00, 2.5540695206E+01, 3.9904196877E+00, 9.7771709716E-01],
	[4.3010000000E+04, 4.4962164552E+01, 5.2854142366E+00, 2.5550361185E+01, 3.9907535611E+00, 9.7772615162E-01],
	[4.3015000000E+04, 4.4971387305E+01, 5.2854586749E+00, 2.5560029695E+01, 3.9910873471E+00, 9.7773520167E-01],
	[4.3020000000E+04, 4.4980610878E+01, 5.2855031084E+00, 2.5569700736E+01, 3.9914210458E+00, 9.7774424733E-01],
	[4.3025000000E+04, 4.4989835270E+01, 5.2855475370E+00, 2.5579374309E+01, 3.9917546572E+00, 9.7775328859E-01],
	[4.3030000000E+04, 4.4999060481E+01, 5.2855919609E+00, 2.5589050413E+01, 3.9920881812E+00, 9.7776232546E-01],
	[4.3035000000E+04, 4.5008286512E+01, 5.2856363800E+00, 2.5598729050E+01, 3.9924216179E+00, 9.7777135793E-01],
	[4.3040000000E+04, 4.5017513363E+01, 5.2856807944E+00, 2.5608410219E+01, 3.9927549674E+00, 9.7778038603E-01],
	[4.3045000000E+04, 4.5026741033E+01, 5.2857252039E+00, 2.5618093921E+01, 3.9930882296E+00, 9.7778940973E-01],
	[4.3050000000E+04, 4.5035969522E+01, 5.2857696086E+00, 2.5627780156E+01, 3.9934214047E+00, 9.7779842905E-01],
	[4.3055000000E+04, 4.5045198830E+01, 5.2858140086E+00, 2.5637468925E+01, 3.9937544925E+00, 9.7780744400E-01],
	[4.3060000000E+04, 4.5054428958E+01, 5.2858584038E+00, 2.5647160227E+01, 3.9940874932E+00, 9.7781645456E-01],
	[4.3065000000E+04, 4.5063659905E+01, 5.2859027942E+00, 2.5656854065E+01, 3.9944204067E+00, 9.7782546075E-01],
	[4.3070000000E+04, 4.5072891671E+01, 5.2859471798E+00, 2.5666550437E+01, 3.9947532332E+00, 9.7783446257E-01],
	[4.3075000000E+04, 4.5082124257E+01, 5.2859915606E+00, 2.5676249344E+01, 3.9950859725E+00, 9.7784346001E-01],
	[4.3080000000E+04, 4.5091357662E+01, 5.2860359367E+00, 2.5685950786E+01, 3.9954186248E+00, 9.7785245309E-01],
	[4.3085000000E+04, 4.5100591886E+01, 5.2860803080E+00, 2.5695654765E+01, 3.9957511900E+00, 9.7786144181E-01],
	[4.3090000000E+04, 4.5109826929E+01, 5.2861246745E+00, 2.5705361280E+01, 3.9960836682E+00, 9.7787042615E-01],
	[4.3095000000E+04, 4.5119062791E+01, 5.2861690362E+00, 2.5715070331E+01, 3.9964160595E+00, 9.7787940614E-01],
	[4.3100000000E+04, 4.5128299473E+01, 5.2862133932E+00, 2.5724781919E+01, 3.9967483637E+00, 9.7788838177E-01],
	[4.3105000000E+04, 4.5137536973E+01, 5.2862577454E+00, 2.5734496044E+01, 3.9970805810E+00, 9.7789735305E-01],
	[4.3110000000E+04, 4.5146775293E+01, 5.2863020928E+00, 2.5744212708E+01, 3.9974127114E+00, 9.7790631997E-01],
	[4.3115000000E+04, 4.5156014431E+01, 5.2863464354E+00, 2.5753931909E+01, 3.9977447549E+00, 9.7791528254E-01],
	[4.3120000000E+04, 4.5165254389E+01, 5.2863907733E+00, 2.5763653649E+01, 3.9980767116E+00, 9.7792424076E-01],
	[4.3125000000E+04, 4.5174495166E+01, 5.2864351064E+00, 2.5773377927E+01, 3.9984085814E+00, 9.7793319464E-01],
	[4.3130000000E+04, 4.5183736762E+01, 5.2864794347E+00, 2.5783104745E+01, 3.9987403643E+00, 9.7794214417E-01],
	[4.3135000000E+04, 4.5192979176E+01, 5.2865237583E+00, 2.5792834102E+01, 3.9990720605E+00, 9.7795108936E-01],
	[4.3140000000E+04, 4.5202222410E+01, 5.2865680771E+00, 2.5802565999E+01, 3.9994036699E+00, 9.7796003021E-01],
	[4.3145000000E+04, 4.5211466463E+01, 5.2866123911E+00, 2.5812300436E+01, 3.9997351925E+00, 9.7796896672E-01],
	[4.3150000000E+04, 4.5220711334E+01, 5.2866567004E+00, 2.5822037414E+01, 4.0000666285E+00, 9.7797789891E-01],
	[4.3155000000E+04, 4.5229957024E+01, 5.2867010049E+00, 2.5831776933E+01, 4.0003979777E+00, 9.7798682676E-01],
	[4.3160000000E+04, 4.5239203534E+01, 5.2867453046E+00, 2.5841518993E+01, 4.0007292402E+00, 9.7799575028E-01],
	[4.3165000000E+04, 4.5248450862E+01, 5.2867895996E+00, 2.5851263595E+01, 4.0010604161E+00, 9.7800466947E-01],
	[4.3170000000E+04, 4.5257699009E+01, 5.2868338898E+00, 2.5861010739E+01, 4.0013915054E+00, 9.7801358434E-01],
	[4.3175000000E+04, 4.5266947974E+01, 5.2868781753E+00, 2.5870760426E+01, 4.0017225081E+00, 9.7802249489E-01],
	[4.3180000000E+04, 4.5276197759E+01, 5.2869224560E+00, 2.5880512655E+01, 4.0020534242E+00, 9.7803140111E-01],
	[4.3185000000E+04, 4.5285457730E+01, 5.2869676617E+00, 2.5890267428E+01, 4.0023848597E+00, 9.7804030303E-01],
	[4.3190000000E+04, 4.5294728086E+01, 5.2870138114E+00, 2.5900024744E+01, 4.0027168274E+00, 9.7804920062E-01],
	[4.3195000000E+04, 4.5303999266E+01, 5.2870599562E+00, 2.5909784604E+01, 4.0030487087E+00, 9.7805809391E-01],
	[4.3200000000E+04, 4.5313271270E+01, 5.2871060960E+00, 2.5919547008E+01, 4.0033805037E+00, 9.7806698288E-01],
	[4.3205000000E+04, 4.5322544099E+01, 5.2871522309E+00, 2.5929311957E+01, 4.0037122125E+00, 9.7807586755E-01],
	[4.3210000000E+04, 4.5331817751E+01, 5.2871983608E+00, 2.5939079451E+01, 4.0040438350E+00, 9.7808474791E-01],
	[4.3215000000E+04, 4.5341092228E+01, 5.2872444858E+00, 2.5948849491E+01, 4.0043753713E+00, 9.7809362397E-01],
	[4.3220000000E+04, 4.5350367529E+01, 5.2872906059E+00, 2.5958622076E+01, 4.0047068214E+00, 9.7810249573E-01],
	[4.3225000000E+04, 4.5359643654E+01, 5.2873367210E+00, 2.5968397207E+01, 4.0050381853E+00, 9.7811136319E-01],
	[4.3230000000E+04, 4.5368920603E+01, 5.2873828313E+00, 2.5978174885E+01, 4.0053694631E+00, 9.7812022635E-01],
	[4.3235000000E+04, 4.5378198376E+01, 5.2874289365E+00, 2.5987955110E+01, 4.0057006548E+00, 9.7812908523E-01],
	[4.3240000000E+04, 4.5387476974E+01, 5.2874750369E+00, 2.5997737882E+01, 4.0060317603E+00, 9.7813793981E-01],
	[4.3245000000E+04, 4.5396756395E+01, 5.2875211323E+00, 2.6007523201E+01, 4.0063627798E+00, 9.7814679010E-01],
	[4.3250000000E+04, 4.5406036640E+01, 5.2875672228E+00, 2.6017311069E+01, 4.0066937132E+00, 9.7815563611E-01],
	[4.3255000000E+04, 4.5415317709E+01, 5.2876133084E+00, 2.6027101485E+01, 4.0070245606E+00, 9.7816447784E-01],
	[4.3260000000E+04, 4.5424599603E+01, 5.2876593890E+00, 2.6036894449E+01, 4.0073553220E+00, 9.7817331528E-01],
	[4.3265000000E+04, 4.5433882320E+01, 5.2877054648E+00, 2.6046689963E+01, 4.0076859974E+00, 9.7818214845E-01],
	[4.3270000000E+04, 4.5443165861E+01, 5.2877515356E+00, 2.6056488026E+01, 4.0080165868E+00, 9.7819097734E-01],
	[4.3275000000E+04, 4.5452450226E+01, 5.2877976014E+00, 2.6066288639E+01, 4.0083470903E+00, 9.7819980195E-01],
	[4.3280000000E+04, 4.5461735415E+01, 5.2878436624E+00, 2.6076091802E+01, 4.0086775079E+00, 9.7820862230E-01],
	[4.3285000000E+04, 4.5471021428E+01, 5.2878897184E+00, 2.6085897516E+01, 4.0090078396E+00, 9.7821743838E-01],
	[4.3290000000E+04, 4.5480308265E+01, 5.2879357695E+00, 2.6095705780E+01, 4.0093380855E+00, 9.7822625018E-01],
	[4.3295000000E+04, 4.5489595925E+01, 5.2879818157E+00, 2.6105516596E+01, 4.0096682455E+00, 9.7823505773E-01],
	[4.3300000000E+04, 4.5498884409E+01, 5.2880278570E+00, 2.6115329964E+01, 4.0099983197E+00, 9.7824386101E-01],
	[4.3305000000E+04, 4.5508173717E+01, 5.2880738934E+00, 2.6125145883E+01, 4.0103283081E+00, 9.7825266004E-01],
	[4.3310000000E+04, 4.5517463849E+01, 5.2881199248E+00, 2.6134964355E+01, 4.0106582108E+00, 9.7826145480E-01],
	[4.3315000000E+04, 4.5526754804E+01, 5.2881659514E+00, 2.6144785380E+01, 4.0109880277E+00, 9.7827024532E-01],
	[4.3320000000E+04, 4.5536046584E+01, 5.2882119730E+00, 2.6154608957E+01, 4.0113177589E+00, 9.7827903158E-01],
	[4.3325000000E+04, 4.5545339186E+01, 5.2882579897E+00, 2.6164435089E+01, 4.0116474045E+00, 9.7828781359E-01],
	[4.3330000000E+04, 4.5554632613E+01, 5.2883040015E+00, 2.6174263774E+01, 4.0119769643E+00, 9.7829659135E-01],
	[4.3335000000E+04, 4.5563926863E+01, 5.2883500084E+00, 2.6184095013E+01, 4.0123064385E+00, 9.7830536487E-01],
	[4.3340000000E+04, 4.5573221937E+01, 5.2883960104E+00, 2.6193928807E+01, 4.0126358271E+00, 9.7831413414E-01],
	[4.3345000000E+04, 4.5582517834E+01, 5.2884420075E+00, 2.6203765156E+01, 4.0129651301E+00, 9.7832289918E-01],
	[4.3350000000E+04, 4.5591814555E+01, 5.2884879997E+00, 2.6213604060E+01, 4.0132943475E+00, 9.7833165997E-01],
	[4.3355000000E+04, 4.5601112099E+01, 5.2885339870E+00, 2.6223445520E+01, 4.0136234794E+00, 9.7834041654E-01],
	[4.3360000000E+04, 4.5610410467E+01, 5.2885799693E+00, 2.6233289536E+01, 4.0139525257E+00, 9.7834916886E-01],
	[4.3365000000E+04, 4.5619709659E+01, 5.2886259468E+00, 2.6243136108E+01, 4.0142814866E+00, 9.7835791696E-01],
	[4.3370000000E+04, 4.5629009674E+01, 5.2886719194E+00, 2.6252985237E+01, 4.0146103620E+00, 9.7836666083E-01],
	[4.3375000000E+04, 4.5638310512E+01, 5.2887178870E+00, 2.6262836924E+01, 4.0149391519E+00, 9.7837540048E-01],
	[4.3380000000E+04, 4.5647612174E+01, 5.2887638498E+00, 2.6272691167E+01, 4.0152678564E+00, 9.7838413589E-01],
	[4.3385000000E+04, 4.5656914659E+01, 5.2888098077E+00, 2.6282547969E+01, 4.0155964755E+00, 9.7839286709E-01],
	[4.3390000000E+04, 4.5666217968E+01, 5.2888557606E+00, 2.6292407329E+01, 4.0159250092E+00, 9.7840159407E-01],
	[4.3395000000E+04, 4.5675522100E+01, 5.2889017087E+00, 2.6302269248E+01, 4.0162534576E+00, 9.7841031684E-01],
	[4.3400000000E+04, 4.5684827056E+01, 5.2889476519E+00, 2.6312133725E+01, 4.0165818206E+00, 9.7841903538E-01],
	[4.3405000000E+04, 4.5694132834E+01, 5.2889935902E+00, 2.6322000762E+01, 4.0169100984E+00, 9.7842774972E-01],
	[4.3410000000E+04, 4.5703439436E+01, 5.2890395236E+00, 2.6331870359E+01, 4.0172382908E+00, 9.7843645985E-01],
	[4.3415000000E+04, 4.5712746862E+01, 5.2890854521E+00, 2.6341742516E+01, 4.0175663980E+00, 9.7844516577E-01],
	[4.3420000000E+04, 4.5722055110E+01, 5.2891313757E+00, 2.6351617233E+01, 4.0178944200E+00, 9.7845386749E-01],
	[4.3425000000E+04, 4.5731364182E+01, 5.2891772944E+00, 2.6361494512E+01, 4.0182223567E+00, 9.7846256500E-01],
	[4.3430000000E+04, 4.5740674077E+01, 5.2892232083E+00, 2.6371374351E+01, 4.0185502083E+00, 9.7847125831E-01],
	[4.3435000000E+04, 4.5749984795E+01, 5.2892691172E+00, 2.6381256752E+01, 4.0188779747E+00, 9.7847994743E-01],
	[4.3440000000E+04, 4.5759296337E+01, 5.2893150213E+00, 2.6391141715E+01, 4.0192056560E+00, 9.7848863235E-01],
	[4.3445000000E+04, 4.5768608701E+01, 5.2893609205E+00, 2.6401029240E+01, 4.0195332521E+00, 9.7849731308E-01],
	[4.3450000000E+04, 4.5777921889E+01, 5.2894068147E+00, 2.6410919328E+01, 4.0198607632E+00, 9.7850598962E-01],
	[4.3455000000E+04, 4.5787235900E+01, 5.2894527042E+00, 2.6420811979E+01, 4.0201881892E+00, 9.7851466197E-01],
	[4.3460000000E+04, 4.5796550734E+01, 5.2894985887E+00, 2.6430707193E+01, 4.0205155302E+00, 9.7852333013E-01],
	[4.3465000000E+04, 4.5805866391E+01, 5.2895444683E+00, 2.6440604972E+01, 4.0208427861E+00, 9.7853199411E-01],
	[4.3470000000E+04, 4.5815182871E+01, 5.2895903431E+00, 2.6450505314E+01, 4.0211699571E+00, 9.7854065391E-01],
	[4.3475000000E+04, 4.5824500174E+01, 5.2896362130E+00, 2.6460408221E+01, 4.0214970431E+00, 9.7854930953E-01],
	[4.3480000000E+04, 4.5833818300E+01, 5.2896820780E+00, 2.6470313692E+01, 4.0218240441E+00, 9.7855796098E-01],
	[4.3485000000E+04, 4.5843137249E+01, 5.2897279381E+00, 2.6480221729E+01, 4.0221509602E+00, 9.7856660825E-01],
	[4.3490000000E+04, 4.5852457021E+01, 5.2897737934E+00, 2.6490132332E+01, 4.0224777914E+00, 9.7857525134E-01],
	[4.3495000000E+04, 4.5861777615E+01, 5.2898196438E+00, 2.6500045501E+01, 4.0228045378E+00, 9.7858389027E-01],
	[4.3500000000E+04, 4.5871099033E+01, 5.2898654893E+00, 2.6509961236E+01, 4.0231311993E+00, 9.7859252504E-01],
	[4.3505000000E+04, 4.5880421274E+01, 5.2899113299E+00, 2.6519879537E+01, 4.0234577760E+00, 9.7860115563E-01],
	[4.3510000000E+04, 4.5889744337E+01, 5.2899571657E+00, 2.6529800406E+01, 4.0237842678E+00, 9.7860978207E-01],
	[4.3515000000E+04, 4.5899068224E+01, 5.2900029966E+00, 2.6539723842E+01, 4.0241106749E+00, 9.7861840434E-01],
	[4.3520000000E+04, 4.5908392933E+01, 5.2900488227E+00, 2.6549649846E+01, 4.0244369973E+00, 9.7862702246E-01],
	[4.3525000000E+04, 4.5917718465E+01, 5.2900946438E+00, 2.6559578419E+01, 4.0247632349E+00, 9.7863563643E-01],
	[4.3530000000E+04, 4.5927044820E+01, 5.2901404601E+00, 2.6569509559E+01, 4.0250893878E+00, 9.7864424624E-01],
	[4.3535000000E+04, 4.5936371997E+01, 5.2901862715E+00, 2.6579443269E+01, 4.0254154560E+00, 9.7865285190E-01],
	[4.3540000000E+04, 4.5945699998E+01, 5.2902320781E+00, 2.6589379548E+01, 4.0257414396E+00, 9.7866145341E-01],
	[4.3545000000E+04, 4.5955028820E+01, 5.2902778798E+00, 2.6599318397E+01, 4.0260673385E+00, 9.7867005077E-01],
	[4.3550000000E+04, 4.5964358466E+01, 5.2903236767E+00, 2.6609259816E+01, 4.0263931529E+00, 9.7867864399E-01],
	[4.3555000000E+04, 4.5973688934E+01, 5.2903694686E+00, 2.6619203805E+01, 4.0267188826E+00, 9.7868723307E-01],
	[4.3560000000E+04, 4.5983020225E+01, 5.2904152558E+00, 2.6629150365E+01, 4.0270445278E+00, 9.7869581802E-01],
	[4.3565000000E+04, 4.5992352339E+01, 5.2904610380E+00, 2.6639099496E+01, 4.0273700884E+00, 9.7870439882E-01],
	[4.3570000000E+04, 4.6001685275E+01, 5.2905068154E+00, 2.6649051199E+01, 4.0276955646E+00, 9.7871297549E-01],
	[4.3575000000E+04, 4.6011019034E+01, 5.2905525880E+00, 2.6659005473E+01, 4.0280209562E+00, 9.7872154803E-01],
	[4.3580000000E+04, 4.6020353615E+01, 5.2905983557E+00, 2.6668962320E+01, 4.0283462634E+00, 9.7873011644E-01],
	[4.3585000000E+04, 4.6029689019E+01, 5.2906441185E+00, 2.6678921740E+01, 4.0286714861E+00, 9.7873868073E-01],
	[4.3590000000E+04, 4.6039025246E+01, 5.2906898765E+00, 2.6688883732E+01, 4.0289966244E+00, 9.7874724088E-01],
	[4.3595000000E+04, 4.6048362295E+01, 5.2907356296E+00, 2.6698848298E+01, 4.0293216783E+00, 9.7875579692E-01],
	[4.3600000000E+04, 4.6057700166E+01, 5.2907813779E+00, 2.6708815437E+01, 4.0296466479E+00, 9.7876434883E-01],
	[4.3605000000E+04, 4.6067038860E+01, 5.2908271213E+00, 2.6718785151E+01, 4.0299715331E+00, 9.7877289663E-01],
	[4.3610000000E+04, 4.6076378376E+01, 5.2908728599E+00, 2.6728757439E+01, 4.0302963340E+00, 9.7878144031E-01],
	[4.3615000000E+04, 4.6085718715E+01, 5.2909185936E+00, 2.6738732302E+01, 4.0306210506E+00, 9.7878997988E-01],
	[4.3620000000E+04, 4.6095059876E+01, 5.2909643225E+00, 2.6748709740E+01, 4.0309456829E+00, 9.7879851534E-01],
	[4.3625000000E+04, 4.6104401859E+01, 5.2910100465E+00, 2.6758689753E+01, 4.0312702310E+00, 9.7880704669E-01],
	[4.3630000000E+04, 4.6113744665E+01, 5.2910557657E+00, 2.6768672343E+01, 4.0315946948E+00, 9.7881557393E-01],
	[4.3635000000E+04, 4.6123088293E+01, 5.2911014801E+00, 2.6778657509E+01, 4.0319190744E+00, 9.7882409707E-01],
	[4.3640000000E+04, 4.6132432743E+01, 5.2911471896E+00, 2.6788645251E+01, 4.0322433699E+00, 9.7883261611E-01],
	[4.3645000000E+04, 4.6141778016E+01, 5.2911928942E+00, 2.6798635571E+01, 4.0325675812E+00, 9.7884113104E-01],
	[4.3650000000E+04, 4.6151124111E+01, 5.2912385941E+00, 2.6808628468E+01, 4.0328917084E+00, 9.7884964188E-01],
	[4.3655000000E+04, 4.6160471028E+01, 5.2912842890E+00, 2.6818623943E+01, 4.0332157514E+00, 9.7885814863E-01],
	[4.3660000000E+04, 4.6169818767E+01, 5.2913299792E+00, 2.6828621996E+01, 4.0335397104E+00, 9.7886665128E-01],
	[4.3665000000E+04, 4.6179167329E+01, 5.2913756645E+00, 2.6838622627E+01, 4.0338635853E+00, 9.7887514985E-01],
	[4.3670000000E+04, 4.6188516712E+01, 5.2914213450E+00, 2.6848625837E+01, 4.0341873762E+00, 9.7888364432E-01],
	[4.3675000000E+04, 4.6197866918E+01, 5.2914670206E+00, 2.6858631627E+01, 4.0345110831E+00, 9.7889213472E-01],
	[4.3680000000E+04, 4.6207217946E+01, 5.2915126914E+00, 2.6868639996E+01, 4.0348347060E+00, 9.7890062102E-01],
	[4.3685000000E+04, 4.6216569796E+01, 5.2915583573E+00, 2.6878650945E+01, 4.0351582449E+00, 9.7890910325E-01],
	[4.3690000000E+04, 4.6225922468E+01, 5.2916040185E+00, 2.6888664474E+01, 4.0354816999E+00, 9.7891758140E-01],
	[4.3695000000E+04, 4.6235275963E+01, 5.2916496748E+00, 2.6898680585E+01, 4.0358050710E+00, 9.7892605547E-01],
	[4.3700000000E+04, 4.6244630279E+01, 5.2916953262E+00, 2.6908699276E+01, 4.0361283581E+00, 9.7893452547E-01],
	[4.3705000000E+04, 4.6253985417E+01, 5.2917409729E+00, 2.6918720549E+01, 4.0364515614E+00, 9.7894299139E-01],
	[4.3710000000E+04, 4.6263341377E+01, 5.2917866147E+00, 2.6928744403E+01, 4.0367746809E+00, 9.7895145324E-01],
	[4.3715000000E+04, 4.6272698159E+01, 5.2918322517E+00, 2.6938770840E+01, 4.0370977166E+00, 9.7895991103E-01],
	[4.3720000000E+04, 4.6282055764E+01, 5.2918778838E+00, 2.6948799859E+01, 4.0374206684E+00, 9.7896836475E-01],
	[4.3725000000E+04, 4.6291414190E+01, 5.2919235112E+00, 2.6958831462E+01, 4.0377435365E+00, 9.7897681440E-01],
	[4.3730000000E+04, 4.6300773438E+01, 5.2919691337E+00, 2.6968865647E+01, 4.0380663208E+00, 9.7898525999E-01],
	[4.3735000000E+04, 4.6310133507E+01, 5.2920147514E+00, 2.6978902416E+01, 4.0383890214E+00, 9.7899370152E-01],
	[4.3740000000E+04, 4.6319494399E+01, 5.2920603642E+00, 2.6988941770E+01, 4.0387116383E+00, 9.7900213899E-01],
	[4.3745000000E+04, 4.6328856113E+01, 5.2921059723E+00, 2.6998983707E+01, 4.0390341715E+00, 9.7901057240E-01],
	[4.3750000000E+04, 4.6338218648E+01, 5.2921515755E+00, 2.7009028230E+01, 4.0393566211E+00, 9.7901900176E-01],
	[4.3755000000E+04, 4.6347582005E+01, 5.2921971739E+00, 2.7019075337E+01, 4.0396789870E+00, 9.7902742707E-01],
	[4.3760000000E+04, 4.6356946184E+01, 5.2922427675E+00, 2.7029125031E+01, 4.0400012694E+00, 9.7903584833E-01],
	[4.3765000000E+04, 4.6366311185E+01, 5.2922883563E+00, 2.7039177310E+01, 4.0403234681E+00, 9.7904426554E-01],
	[4.3770000000E+04, 4.6375677007E+01, 5.2923339402E+00, 2.7049232175E+01, 4.0406455833E+00, 9.7905267870E-01],
	[4.3775000000E+04, 4.6385043651E+01, 5.2923795194E+00, 2.7059289627E+01, 4.0409676150E+00, 9.7906108782E-01],
	[4.3780000000E+04, 4.6394411117E+01, 5.2924250937E+00, 2.7069349665E+01, 4.0412895631E+00, 9.7906949290E-01],
	[4.3785000000E+04, 4.6403779405E+01, 5.2924706632E+00, 2.7079412292E+01, 4.0416114278E+00, 9.7907789394E-01],
	[4.3790000000E+04, 4.6413148514E+01, 5.2925162279E+00, 2.7089477506E+01, 4.0419332089E+00, 9.7908629094E-01],
	[4.3795000000E+04, 4.6422518444E+01, 5.2925617878E+00, 2.7099545308E+01, 4.0422549067E+00, 9.7909468391E-01],
	[4.3800000000E+04, 4.6431889197E+01, 5.2926073429E+00, 2.7109615698E+01, 4.0425765210E+00, 9.7910307284E-01],
	[4.3805000000E+04, 4.6441260771E+01, 5.2926528932E+00, 2.7119688677E+01, 4.0428980520E+00, 9.7911145774E-01],
	[4.3810000000E+04, 4.6450633166E+01, 5.2926984387E+00, 2.7129764246E+01, 4.0432194996E+00, 9.7911983861E-01],
	[4.3815000000E+04, 4.6460006383E+01, 5.2927439793E+00, 2.7139842404E+01, 4.0435408638E+00, 9.7912821545E-01],
	[4.3820000000E+04, 4.6469380422E+01, 5.2927895152E+00, 2.7149923152E+01, 4.0438621447E+00, 9.7913658827E-01],
	[4.3825000000E+04, 4.6478755282E+01, 5.2928350463E+00, 2.7160006490E+01, 4.0441833423E+00, 9.7914495707E-01],
	[4.3830000000E+04, 4.6488130963E+01, 5.2928805725E+00, 2.7170092419E+01, 4.0445044567E+00, 9.7915332184E-01],
	[4.3835000000E+04, 4.6497507466E+01, 5.2929260940E+00, 2.7180180939E+01, 4.0448254878E+00, 9.7916168260E-01],
	[4.3840000000E+04, 4.6506884790E+01, 5.2929716106E+00, 2.7190272051E+01, 4.0451464356E+00, 9.7917003934E-01],
	[4.3845000000E+04, 4.6516262936E+01, 5.2930171225E+00, 2.7200365754E+01, 4.0454673003E+00, 9.7917839206E-01],
	[4.3850000000E+04, 4.6525641903E+01, 5.2930626295E+00, 2.7210462049E+01, 4.0457880818E+00, 9.7918674078E-01],
	[4.3855000000E+04, 4.6535021692E+01, 5.2931081318E+00, 2.7220560937E+01, 4.0461087801E+00, 9.7919508548E-01],
	[4.3860000000E+04, 4.6544402302E+01, 5.2931536292E+00, 2.7230662418E+01, 4.0464293953E+00, 9.7920342617E-01],
	[4.3865000000E+04, 4.6553783733E+01, 5.2931991219E+00, 2.7240766492E+01, 4.0467499274E+00, 9.7921176285E-01],
	[4.3870000000E+04, 4.6563165985E+01, 5.2932446098E+00, 2.7250873160E+01, 4.0470703764E+00, 9.7922009554E-01],
	[4.3875000000E+04, 4.6572549059E+01, 5.2932900929E+00, 2.7260982421E+01, 4.0473907424E+00, 9.7922842422E-01],
	[4.3880000000E+04, 4.6581941619E+01, 5.2933364156E+00, 2.7271094277E+01, 4.0477115845E+00, 9.7923674890E-01],
	[4.3885000000E+04, 4.6591345220E+01, 5.2933837290E+00, 2.7281208728E+01, 4.0480330030E+00, 9.7924506958E-01],
	[4.3890000000E+04, 4.6600749648E+01, 5.2934310374E+00, 2.7291325774E+01, 4.0483543387E+00, 9.7925338626E-01],
	[4.3895000000E+04, 4.6610154903E+01, 5.2934783409E+00, 2.7301445415E+01, 4.0486755916E+00, 9.7926169895E-01],
	[4.3900000000E+04, 4.6619560984E+01, 5.2935256394E+00, 2.7311567652E+01, 4.0489967618E+00, 9.7927000765E-01],
	[4.3905000000E+04, 4.6628967893E+01, 5.2935729330E+00, 2.7321692485E+01, 4.0493178492E+00, 9.7927831236E-01],
	[4.3910000000E+04, 4.6638375627E+01, 5.2936202215E+00, 2.7331819915E+01, 4.0496388539E+00, 9.7928661308E-01],
	[4.3915000000E+04, 4.6647784188E+01, 5.2936675052E+00, 2.7341949942E+01, 4.0499597759E+00, 9.7929490982E-01],
	[4.3920000000E+04, 4.6657193576E+01, 5.2937147838E+00, 2.7352082566E+01, 4.0502806152E+00, 9.7930320257E-01],
	[4.3925000000E+04, 4.6666603790E+01, 5.2937620575E+00, 2.7362217788E+01, 4.0506013718E+00, 9.7931149134E-01],
	[4.3930000000E+04, 4.6676014831E+01, 5.2938093263E+00, 2.7372355608E+01, 4.0509220458E+00, 9.7931977613E-01],
	[4.3935000000E+04, 4.6685426698E+01, 5.2938565901E+00, 2.7382496026E+01, 4.0512426373E+00, 9.7932805694E-01],
	[4.3940000000E+04, 4.6694839392E+01, 5.2939038489E+00, 2.7392639043E+01, 4.0515631461E+00, 9.7933633378E-01],
	[4.3945000000E+04, 4.6704252912E+01, 5.2939511028E+00, 2.7402784660E+01, 4.0518835724E+00, 9.7934460664E-01],
	[4.3950000000E+04, 4.6713667259E+01, 5.2939983517E+00, 2.7412932875E+01, 4.0522039161E+00, 9.7935287554E-01],
	[4.3955000000E+04, 4.6723082431E+01, 5.2940455956E+00, 2.7423083691E+01, 4.0525241773E+00, 9.7936114046E-01],
	[4.3960000000E+04, 4.6732498431E+01, 5.2940928346E+00, 2.7433237107E+01, 4.0528443561E+00, 9.7936940142E-01],
	[4.3965000000E+04, 4.6741915256E+01, 5.2941400687E+00, 2.7443393124E+01, 4.0531644524E+00, 9.7937765841E-01],
	[4.3970000000E+04, 4.6751332908E+01, 5.2941872978E+00, 2.7453551741E+01, 4.0534844662E+00, 9.7938591144E-01],
	[4.3975000000E+04, 4.6760751387E+01, 5.2942345220E+00, 2.7463712960E+01, 4.0538043976E+00, 9.7939416051E-01],
	[4.3980000000E+04, 4.6770170691E+01, 5.2942817412E+00, 2.7473876781E+01, 4.0541242466E+00, 9.7940240561E-01],
	[4.3985000000E+04, 4.6779590822E+01, 5.2943289555E+00, 2.7484043203E+01, 4.0544440133E+00, 9.7941064677E-01],
	[4.3990000000E+04, 4.6789011779E+01, 5.2943761648E+00, 2.7494212229E+01, 4.0547636976E+00, 9.7941888396E-01],
	[4.3995000000E+04, 4.6798433562E+01, 5.2944233692E+00, 2.7504383857E+01, 4.0550832996E+00, 9.7942711721E-01],
	[4.4000000000E+04, 4.6807856172E+01, 5.2944705686E+00, 2.7514558088E+01, 4.0554028193E+00, 9.7943534650E-01],
	[4.4005000000E+04, 4.6817279607E+01, 5.2945177631E+00, 2.7524734923E+01, 4.0557222567E+00, 9.7944357185E-01],
	[4.4010000000E+04, 4.6826703869E+01, 5.2945649526E+00, 2.7534914362E+01, 4.0560416118E+00, 9.7945179325E-01],
	[4.4015000000E+04, 4.6836128957E+01, 5.2946121372E+00, 2.7545096405E+01, 4.0563608847E+00, 9.7946001070E-01],
	[4.4020000000E+04, 4.6845554871E+01, 5.2946593169E+00, 2.7555281053E+01, 4.0566800755E+00, 9.7946822421E-01],
	[4.4025000000E+04, 4.6854981611E+01, 5.2947064916E+00, 2.7565468306E+01, 4.0569991840E+00, 9.7947643378E-01],
	[4.4030000000E+04, 4.6864409178E+01, 5.2947536614E+00, 2.7575658164E+01, 4.0573182104E+00, 9.7948463941E-01],
	[4.4035000000E+04, 4.6873837570E+01, 5.2948008263E+00, 2.7585850628E+01, 4.0576371546E+00, 9.7949284111E-01],
	[4.4040000000E+04, 4.6883266788E+01, 5.2948479862E+00, 2.7596045698E+01, 4.0579560167E+00, 9.7950103887E-01],
	[4.4045000000E+04, 4.6892696833E+01, 5.2948951412E+00, 2.7606243375E+01, 4.0582747968E+00, 9.7950923270E-01],
	[4.4050000000E+04, 4.6902127703E+01, 5.2949422913E+00, 2.7616443659E+01, 4.0585934947E+00, 9.7951742260E-01],
	[4.4055000000E+04, 4.6911559399E+01, 5.2949894364E+00, 2.7626646550E+01, 4.0589121107E+00, 9.7952560858E-01],
	[4.4060000000E+04, 4.6920991921E+01, 5.2950365766E+00, 2.7636852049E+01, 4.0592306446E+00, 9.7953379062E-01],
	[4.4065000000E+04, 4.6930425269E+01, 5.2950837118E+00, 2.7647060155E+01, 4.0595490965E+00, 9.7954196874E-01],
	[4.4070000000E+04, 4.6939859443E+01, 5.2951308422E+00, 2.7657270870E+01, 4.0598674664E+00, 9.7955014294E-01],
	[4.4075000000E+04, 4.6949294443E+01, 5.2951779676E+00, 2.7667484194E+01, 4.0601857544E+00, 9.7955831322E-01],
	[4.4080000000E+04, 4.6958730269E+01, 5.2952250881E+00, 2.7677700127E+01, 4.0605039605E+00, 9.7956647959E-01],
	[4.4085000000E+04, 4.6968166921E+01, 5.2952722036E+00, 2.7687918669E+01, 4.0608220847E+00, 9.7957464203E-01],
	[4.4090000000E+04, 4.6977604398E+01, 5.2953193143E+00, 2.7698139822E+01, 4.0611401270E+00, 9.7958280056E-01],
	[4.4095000000E+04, 4.6987042701E+01, 5.2953664200E+00, 2.7708363584E+01, 4.0614580874E+00, 9.7959095519E-01],
	[4.4100000000E+04, 4.6996481830E+01, 5.2954135207E+00, 2.7718589957E+01, 4.0617759660E+00, 9.7959910590E-01],
	[4.4105000000E+04, 4.7005921785E+01, 5.2954606166E+00, 2.7728818941E+01, 4.0620937628E+00, 9.7960725270E-01],
	[4.4110000000E+04, 4.7015362565E+01, 5.2955077076E+00, 2.7739050537E+01, 4.0624114778E+00, 9.7961539560E-01],
	[4.4115000000E+04, 4.7024804171E+01, 5.2955547936E+00, 2.7749284744E+01, 4.0627291111E+00, 9.7962353459E-01],
	[4.4120000000E+04, 4.7034246603E+01, 5.2956018747E+00, 2.7759521563E+01, 4.0630466626E+00, 9.7963166969E-01],
	[4.4125000000E+04, 4.7043689861E+01, 5.2956489509E+00, 2.7769760995E+01, 4.0633641324E+00, 9.7963980088E-01],
	[4.4130000000E+04, 4.7053133944E+01, 5.2956960222E+00, 2.7780003039E+01, 4.0636815205E+00, 9.7964792818E-01],
	[4.4135000000E+04, 4.7062578853E+01, 5.2957430885E+00, 2.7790247697E+01, 4.0639988269E+00, 9.7965605158E-01],
	[4.4140000000E+04, 4.7072024587E+01, 5.2957901500E+00, 2.7800494968E+01, 4.0643160517E+00, 9.7966417109E-01],
	[4.4145000000E+04, 4.7081471147E+01, 5.2958372065E+00, 2.7810744853E+01, 4.0646331949E+00, 9.7967228670E-01],
	[4.4150000000E+04, 4.7090918532E+01, 5.2958842581E+00, 2.7820997352E+01, 4.0649502565E+00, 9.7968039843E-01],
	[4.4155000000E+04, 4.7100366743E+01, 5.2959313048E+00, 2.7831252466E+01, 4.0652672365E+00, 9.7968850627E-01],
	[4.4160000000E+04, 4.7109815780E+01, 5.2959783466E+00, 2.7841510195E+01, 4.0655841349E+00, 9.7969661023E-01],
	[4.4165000000E+04, 4.7119265642E+01, 5.2960253835E+00, 2.7851770540E+01, 4.0659009519E+00, 9.7970471030E-01],
	[4.4170000000E+04, 4.7128716329E+01, 5.2960724155E+00, 2.7862033500E+01, 4.0662176873E+00, 9.7971280649E-01],
	[4.4175000000E+04, 4.7138167842E+01, 5.2961194426E+00, 2.7872299076E+01, 4.0665343412E+00, 9.7972089880E-01],
	[4.4180000000E+04, 4.7147620181E+01, 5.2961664648E+00, 2.7882567269E+01, 4.0668509137E+00, 9.7972898724E-01],
	[4.4185000000E+04, 4.7157073345E+01, 5.2962134821E+00, 2.7892838079E+01, 4.0671674047E+00, 9.7973707180E-01],
	[4.4190000000E+04, 4.7166527334E+01, 5.2962604944E+00, 2.7903111506E+01, 4.0674838144E+00, 9.7974515249E-01],
	[4.4195000000E+04, 4.7175982148E+01, 5.2963075019E+00, 2.7913387550E+01, 4.0678001426E+00, 9.7975322930E-01],
	[4.4200000000E+04, 4.7185437788E+01, 5.2963545045E+00, 2.7923666213E+01, 4.0681163895E+00, 9.7976130225E-01],
	[4.4205000000E+04, 4.7194894253E+01, 5.2964015021E+00, 2.7933947494E+01, 4.0684325551E+00, 9.7976937133E-01],
	[4.4210000000E+04, 4.7204351544E+01, 5.2964484949E+00, 2.7944231394E+01, 4.0687486393E+00, 9.7977743655E-01],
	[4.4215000000E+04, 4.7213809660E+01, 5.2964954828E+00, 2.7954517912E+01, 4.0690646422E+00, 9.7978549790E-01],
	[4.4220000000E+04, 4.7223268601E+01, 5.2965424658E+00, 2.7964807051E+01, 4.0693805639E+00, 9.7979355539E-01],
	[4.4225000000E+04, 4.7232728367E+01, 5.2965894438E+00, 2.7975098809E+01, 4.0696964043E+00, 9.7980160903E-01],
	[4.4230000000E+04, 4.7242188958E+01, 5.2966364170E+00, 2.7985393187E+01, 4.0700121635E+00, 9.7980965881E-01],
	[4.4235000000E+04, 4.7251650375E+01, 5.2966833853E+00, 2.7995690186E+01, 4.0703278415E+00, 9.7981770473E-01],
	[4.4240000000E+04, 4.7261112617E+01, 5.2967303487E+00, 2.8005989805E+01, 4.0706434383E+00, 9.7982574680E-01],
	[4.4245000000E+04, 4.7270575684E+01, 5.2967773072E+00, 2.8016292046E+01, 4.0709589540E+00, 9.7983378502E-01],
	[4.4250000000E+04, 4.7280039576E+01, 5.2968242609E+00, 2.8026596909E+01, 4.0712743885E+00, 9.7984181939E-01],
	[4.4255000000E+04, 4.7289504293E+01, 5.2968712096E+00, 2.8036904394E+01, 4.0715897419E+00, 9.7984984991E-01],
	[4.4260000000E+04, 4.7298969836E+01, 5.2969181534E+00, 2.8047214501E+01, 4.0719050142E+00, 9.7985787660E-01],
	[4.4265000000E+04, 4.7308436203E+01, 5.2969650924E+00, 2.8057527231E+01, 4.0722202055E+00, 9.7986589943E-01],
	[4.4270000000E+04, 4.7317903396E+01, 5.2970120265E+00, 2.8067842584E+01, 4.0725353158E+00, 9.7987391843E-01],
	[4.4275000000E+04, 4.7327371413E+01, 5.2970589556E+00, 2.8078160561E+01, 4.0728503450E+00, 9.7988193359E-01],
	[4.4280000000E+04, 4.7336840255E+01, 5.2971058799E+00, 2.8088481161E+01, 4.0731652932E+00, 9.7988994491E-01],
	[4.4285000000E+04, 4.7346309923E+01, 5.2971527994E+00, 2.8098804386E+01, 4.0734801605E+00, 9.7989795240E-01],
	[4.4290000000E+04, 4.7355780415E+01, 5.2971997139E+00, 2.8109130236E+01, 4.0737949468E+00, 9.7990595606E-01],
	[4.4295000000E+04, 4.7365251733E+01, 5.2972466236E+00, 2.8119458710E+01, 4.0741096522E+00, 9.7991395588E-01],
	[4.4300000000E+04, 4.7374723875E+01, 5.2972935283E+00, 2.8129789810E+01, 4.0744242767E+00, 9.7992195188E-01],
	[4.4305000000E+04, 4.7384196842E+01, 5.2973404282E+00, 2.8140123536E+01, 4.0747388203E+00, 9.7992994405E-01],
	[4.4310000000E+04, 4.7393670634E+01, 5.2973873233E+00, 2.8150459887E+01, 4.0750532831E+00, 9.7993793240E-01],
	[4.4315000000E+04, 4.7403145251E+01, 5.2974342134E+00, 2.8160798866E+01, 4.0753676650E+00, 9.7994591692E-01],
	[4.4320000000E+04, 4.7412620693E+01, 5.2974810987E+00, 2.8171140471E+01, 4.0756819661E+00, 9.7995389763E-01],
	[4.4325000000E+04, 4.7422096959E+01, 5.2975279791E+00, 2.8181484703E+01, 4.0759961865E+00, 9.7996187451E-01],
	[4.4330000000E+04, 4.7431574051E+01, 5.2975748546E+00, 2.8191831563E+01, 4.0763103261E+00, 9.7996984758E-01],
	[4.4335000000E+04, 4.7441051967E+01, 5.2976217252E+00, 2.8202181050E+01, 4.0766243849E+00, 9.7997781684E-01],
	[4.4340000000E+04, 4.7450530708E+01, 5.2976685910E+00, 2.8212533167E+01, 4.0769383631E+00, 9.7998578228E-01],
	[4.4345000000E+04, 4.7460010273E+01, 5.2977154519E+00, 2.8222887911E+01, 4.0772522605E+00, 9.7999374392E-01],
	[4.4350000000E+04, 4.7469490663E+01, 5.2977623080E+00, 2.8233245285E+01, 4.0775660773E+00, 9.8000170174E-01],
	[4.4355000000E+04, 4.7478971878E+01, 5.2978091591E+00, 2.8243605289E+01, 4.0778798134E+00, 9.8000965576E-01],
	[4.4360000000E+04, 4.7488453918E+01, 5.2978560054E+00, 2.8253967922E+01, 4.0781934690E+00, 9.8001760598E-01],
	[4.4365000000E+04, 4.7497936782E+01, 5.2979028469E+00, 2.8264333185E+01, 4.0785070439E+00, 9.8002555239E-01],
	[4.4370000000E+04, 4.7507420471E+01, 5.2979496835E+00, 2.8274701079E+01, 4.0788205382E+00, 9.8003349501E-01],
	[4.4375000000E+04, 4.7516904985E+01, 5.2979965152E+00, 2.8285071604E+01, 4.0791339521E+00, 9.8004143382E-01],
	[4.4380000000E+04, 4.7526390323E+01, 5.2980433420E+00, 2.8295444760E+01, 4.0794472853E+00, 9.8004936884E-01],
	[4.4385000000E+04, 4.7535876485E+01, 5.2980901640E+00, 2.8305820548E+01, 4.0797605381E+00, 9.8005730007E-01],
	[4.4390000000E+04, 4.7545363472E+01, 5.2981369811E+00, 2.8316198968E+01, 4.0800737104E+00, 9.8006522750E-01],
	[4.4395000000E+04, 4.7554851284E+01, 5.2981837934E+00, 2.8326580020E+01, 4.0803868022E+00, 9.8007315114E-01],
	[4.4400000000E+04, 4.7564339920E+01, 5.2982306008E+00, 2.8336963705E+01, 4.0806998136E+00, 9.8008107100E-01],
	[4.4405000000E+04, 4.7573829381E+01, 5.2982774034E+00, 2.8347350023E+01, 4.0810127446E+00, 9.8008898707E-01],
	[4.4410000000E+04, 4.7583319666E+01, 5.2983242011E+00, 2.8357738974E+01, 4.0813255952E+00, 9.8009689935E-01],
	[4.4415000000E+04, 4.7592810775E+01, 5.2983709939E+00, 2.8368130560E+01, 4.0816383654E+00, 9.8010480786E-01],
	[4.4420000000E+04, 4.7602302709E+01, 5.2984177819E+00, 2.8378524780E+01, 4.0819510553E+00, 9.8011271258E-01],
	[4.4425000000E+04, 4.7611795468E+01, 5.2984645650E+00, 2.8388921634E+01, 4.0822636649E+00, 9.8012061353E-01],
	[4.4430000000E+04, 4.7621289050E+01, 5.2985113433E+00, 2.8399321123E+01, 4.0825761942E+00, 9.8012851070E-01],
	[4.4435000000E+04, 4.7630783457E+01, 5.2985581167E+00, 2.8409723248E+01, 4.0828886432E+00, 9.8013640409E-01],
	[4.4440000000E+04, 4.7640278689E+01, 5.2986048853E+00, 2.8420128008E+01, 4.0832010119E+00, 9.8014429372E-01],
	[4.4445000000E+04, 4.7649774744E+01, 5.2986516490E+00, 2.8430535405E+01, 4.0835133004E+00, 9.8015217957E-01],
	[4.4450000000E+04, 4.7659271624E+01, 5.2986984079E+00, 2.8440945438E+01, 4.0838255088E+00, 9.8016006166E-01],
	[4.4455000000E+04, 4.7668769328E+01, 5.2987451620E+00, 2.8451358108E+01, 4.0841376369E+00, 9.8016793998E-01],
	[4.4460000000E+04, 4.7678267857E+01, 5.2987919111E+00, 2.8461773415E+01, 4.0844496849E+00, 9.8017581453E-01],
	[4.4465000000E+04, 4.7687767209E+01, 5.2988386555E+00, 2.8472191359E+01, 4.0847616527E+00, 9.8018368533E-01],
	[4.4470000000E+04, 4.7697267386E+01, 5.2988853950E+00, 2.8482611942E+01, 4.0850735405E+00, 9.8019155236E-01],
	[4.4475000000E+04, 4.7706768387E+01, 5.2989321296E+00, 2.8493035163E+01, 4.0853853481E+00, 9.8019941564E-01],
	[4.4480000000E+04, 4.7716270212E+01, 5.2989788595E+00, 2.8503461022E+01, 4.0856970757E+00, 9.8020727516E-01],
	[4.4485000000E+04, 4.7725772862E+01, 5.2990255844E+00, 2.8513889521E+01, 4.0860087233E+00, 9.8021513093E-01],
	[4.4490000000E+04, 4.7735276335E+01, 5.2990723046E+00, 2.8524320659E+01, 4.0863202908E+00, 9.8022298294E-01],
	[4.4495000000E+04, 4.7744780632E+01, 5.2991190199E+00, 2.8534754437E+01, 4.0866317783E+00, 9.8023083121E-01],
	[4.4500000000E+04, 4.7754285754E+01, 5.2991657303E+00, 2.8545190855E+01, 4.0869431859E+00, 9.8023867572E-01],
	[4.4505000000E+04, 4.7763791700E+01, 5.2992124360E+00, 2.8555629913E+01, 4.0872545135E+00, 9.8024651649E-01],
	[4.4510000000E+04, 4.7773298469E+01, 5.2992591367E+00, 2.8566071613E+01, 4.0875657612E+00, 9.8025435352E-01],
	[4.4515000000E+04, 4.7782806063E+01, 5.2993058327E+00, 2.8576515954E+01, 4.0878769290E+00, 9.8026218680E-01],
	[4.4520000000E+04, 4.7792314480E+01, 5.2993525238E+00, 2.8586962936E+01, 4.0881880169E+00, 9.8027001635E-01],
	[4.4525000000E+04, 4.7801823722E+01, 5.2993992101E+00, 2.8597412560E+01, 4.0884990249E+00, 9.8027784216E-01],
	[4.4530000000E+04, 4.7811333787E+01, 5.2994458916E+00, 2.8607864827E+01, 4.0888099531E+00, 9.8028566423E-01],
	[4.4535000000E+04, 4.7820844677E+01, 5.2994925682E+00, 2.8618319737E+01, 4.0891208015E+00, 9.8029348256E-01],
	[4.4540000000E+04, 4.7830356390E+01, 5.2995392400E+00, 2.8628777289E+01, 4.0894315701E+00, 9.8030129717E-01],
	[4.4545000000E+04, 4.7839868927E+01, 5.2995859070E+00, 2.8639237486E+01, 4.0897422590E+00, 9.8030910804E-01],
	[4.4550000000E+04, 4.7849382288E+01, 5.2996325691E+00, 2.8649700326E+01, 4.0900528681E+00, 9.8031691519E-01],
	[4.4555000000E+04, 4.7858896473E+01, 5.2996792264E+00, 2.8660165810E+01, 4.0903633975E+00, 9.8032471861E-01],
	[4.4560000000E+04, 4.7868411482E+01, 5.2997258789E+00, 2.8670633939E+01, 4.0906738471E+00, 9.8033251831E-01],
	[4.4565000000E+04, 4.7877927315E+01, 5.2997725266E+00, 2.8681104713E+01, 4.0909842172E+00, 9.8034031428E-01],
	[4.4570000000E+04, 4.7887443971E+01, 5.2998191694E+00, 2.8691578132E+01, 4.0912945075E+00, 9.8034810654E-01],
	[4.4575000000E+04, 4.7896961451E+01, 5.2998658075E+00, 2.8702054197E+01, 4.0916047183E+00, 9.8035589507E-01],
	[4.4580000000E+04, 4.7906479755E+01, 5.2999124407E+00, 2.8712532908E+01, 4.0919148494E+00, 9.8036367989E-01],
	[4.4585000000E+04, 4.7916002359E+01, 5.2999594019E+00, 2.8723014265E+01, 4.0922251247E+00, 9.8037146100E-01],
	[4.4590000000E+04, 4.7925541144E+01, 5.3000078276E+00, 2.8733498270E+01, 4.0925363086E+00, 9.8037923839E-01],
	[4.4595000000E+04, 4.7935080759E+01, 5.3000562484E+00, 2.8743984921E+01, 4.0928474132E+00, 9.8038701208E-01],
	[4.4600000000E+04, 4.7944621202E+01, 5.3001046641E+00, 2.8754474220E+01, 4.0931584383E+00, 9.8039478205E-01],
	[4.4605000000E+04, 4.7954162474E+01, 5.3001530749E+00, 2.8764966167E+01, 4.0934693842E+00, 9.8040254832E-01],
	[4.4610000000E+04, 4.7963704575E+01, 5.3002014807E+00, 2.8775460763E+01, 4.0937802507E+00, 9.8041031089E-01],
	[4.4615000000E+04, 4.7973247505E+01, 5.3002498815E+00, 2.8785958007E+01, 4.0940910380E+00, 9.8041806975E-01],
	[4.4620000000E+04, 4.7982791264E+01, 5.3002982774E+00, 2.8796457900E+01, 4.0944017460E+00, 9.8042582491E-01],
	[4.4625000000E+04, 4.7992335852E+01, 5.3003466682E+00, 2.8806960442E+01, 4.0947123747E+00, 9.8043357637E-01],
	[4.4630000000E+04, 4.8001881269E+01, 5.3003950541E+00, 2.8817465634E+01, 4.0950229243E+00, 9.8044132414E-01],
	[4.4635000000E+04, 4.8011427515E+01, 5.3004434350E+00, 2.8827973477E+01, 4.0953333946E+00, 9.8044906822E-01],
	[4.4640000000E+04, 4.8020974589E+01, 5.3004918109E+00, 2.8838483970E+01, 4.0956437858E+00, 9.8045680860E-01],
	[4.4645000000E+04, 4.8030522493E+01, 5.3005401819E+00, 2.8848997114E+01, 4.0959540978E+00, 9.8046454529E-01],
	[4.4650000000E+04, 4.8040071225E+01, 5.3005885479E+00, 2.8859512909E+01, 4.0962643307E+00, 9.8047227829E-01],
	[4.4655000000E+04, 4.8049620786E+01, 5.3006369088E+00, 2.8870031356E+01, 4.0965744845E+00, 9.8048000760E-01],
	[4.4660000000E+04, 4.8059171176E+01, 5.3006852649E+00, 2.8880552454E+01, 4.0968845592E+00, 9.8048773324E-01],
	[4.4665000000E+04, 4.8068722394E+01, 5.3007336159E+00, 2.8891076206E+01, 4.0971945549E+00, 9.8049545518E-01],
	[4.4670000000E+04, 4.8078274442E+01, 5.3007819620E+00, 2.8901602610E+01, 4.0975044715E+00, 9.8050317345E-01],
	[4.4675000000E+04, 4.8087827318E+01, 5.3008303031E+00, 2.8912131667E+01, 4.0978143091E+00, 9.8051088804E-01],
	[4.4680000000E+04, 4.8097381022E+01, 5.3008786392E+00, 2.8922663377E+01, 4.0981240677E+00, 9.8051859896E-01],
	[4.4685000000E+04, 4.8106935556E+01, 5.3009269704E+00, 2.8933197742E+01, 4.0984337474E+00, 9.8052630619E-01],
	[4.4690000000E+04, 4.8116490918E+01, 5.3009752966E+00, 2.8943734760E+01, 4.0987433481E+00, 9.8053400976E-01],
	[4.4695000000E+04, 4.8126047108E+01, 5.3010236178E+00, 2.8954274434E+01, 4.0990528699E+00, 9.8054170965E-01],
	[4.4700000000E+04, 4.8135604128E+01, 5.3010719341E+00, 2.8964816762E+01, 4.0993623128E+00, 9.8054940588E-01],
	[4.4705000000E+04, 4.8145161976E+01, 5.3011202454E+00, 2.8975361745E+01, 4.0996716768E+00, 9.8055709844E-01],
	[4.4710000000E+04, 4.8154720652E+01, 5.3011685518E+00, 2.8985909385E+01, 4.0999809620E+00, 9.8056478733E-01],
	[4.4715000000E+04, 4.8164280157E+01, 5.3012168532E+00, 2.8996459680E+01, 4.1002901683E+00, 9.8057247257E-01],
	[4.4720000000E+04, 4.8173840490E+01, 5.3012651496E+00, 2.9007012632E+01, 4.1005992958E+00, 9.8058015414E-01],
	[4.4725000000E+04, 4.8183401652E+01, 5.3013134410E+00, 2.9017568241E+01, 4.1009083446E+00, 9.8058783205E-01],
	[4.4730000000E+04, 4.8192963643E+01, 5.3013617275E+00, 2.9028126506E+01, 4.1012173145E+00, 9.8059550630E-01],
	[4.4735000000E+04, 4.8202526462E+01, 5.3014100091E+00, 2.9038687430E+01, 4.1015262058E+00, 9.8060317690E-01],
	[4.4740000000E+04, 4.8212090109E+01, 5.3014582857E+00, 2.9049251011E+01, 4.1018350183E+00, 9.8061084385E-01],
	[4.4745000000E+04, 4.8221654585E+01, 5.3015065573E+00, 2.9059817251E+01, 4.1021437522E+00, 9.8061850715E-01],
	[4.4750000000E+04, 4.8231219889E+01, 5.3015548240E+00, 2.9070386149E+01, 4.1024524073E+00, 9.8062616679E-01],
	[4.4755000000E+04, 4.8240786022E+01, 5.3016030857E+00, 2.9080957707E+01, 4.1027609838E+00, 9.8063382279E-01],
	[4.4760000000E+04, 4.8250352982E+01, 5.3016513425E+00, 2.9091531924E+01, 4.1030694817E+00, 9.8064147515E-01],
	[4.4765000000E+04, 4.8259920772E+01, 5.3016995943E+00, 2.9102108800E+01, 4.1033779010E+00, 9.8064912386E-01],
	[4.4770000000E+04, 4.8269489389E+01, 5.3017478412E+00, 2.9112688337E+01, 4.1036862417E+00, 9.8065676893E-01],
	[4.4775000000E+04, 4.8279058835E+01, 5.3017960831E+00, 2.9123270535E+01, 4.1039945039E+00, 9.8066441036E-01],
	[4.4780000000E+04, 4.8288629109E+01, 5.3018443201E+00, 2.9133855393E+01, 4.1043026875E+00, 9.8067204815E-01],
	[4.4785000000E+04, 4.8298200212E+01, 5.3018925521E+00, 2.9144442912E+01, 4.1046107926E+00, 9.8067968231E-01],
	[4.4790000000E+04, 4.8307772142E+01, 5.3019407792E+00, 2.9155033094E+01, 4.1049188192E+00, 9.8068731283E-01],
	[4.4795000000E+04, 4.8317344901E+01, 5.3019890013E+00, 2.9165625937E+01, 4.1052267674E+00, 9.8069493973E-01],
	[4.4800000000E+04, 4.8326918488E+01, 5.3020372185E+00, 2.9176221442E+01, 4.1055346371E+00, 9.8070256299E-01],
	[4.4805000000E+04, 4.8336492903E+01, 5.3020854308E+00, 2.9186819611E+01, 4.1058424284E+00, 9.8071018263E-01],
	[4.4810000000E+04, 4.8346068147E+01, 5.3021336381E+00, 2.9197420442E+01, 4.1061501413E+00, 9.8071779864E-01],
	[4.4815000000E+04, 4.8355644218E+01, 5.3021818405E+00, 2.9208023937E+01, 4.1064577758E+00, 9.8072541102E-01],
	[4.4820000000E+04, 4.8365221118E+01, 5.3022300379E+00, 2.9218630096E+01, 4.1067653320E+00, 9.8073301979E-01],
	[4.4825000000E+04, 4.8374798845E+01, 5.3022782304E+00, 2.9229238919E+01, 4.1070728098E+00, 9.8074062493E-01],
	[4.4830000000E+04, 4.8384377401E+01, 5.3023264180E+00, 2.9239850407E+01, 4.1073802093E+00, 9.8074822646E-01],
	[4.4835000000E+04, 4.8393956785E+01, 5.3023746006E+00, 2.9250464559E+01, 4.1076875306E+00, 9.8075582437E-01],
	[4.4840000000E+04, 4.8403536997E+01, 5.3024227783E+00, 2.9261081377E+01, 4.1079947736E+00, 9.8076341867E-01],
	[4.4845000000E+04, 4.8413118036E+01, 5.3024709510E+00, 2.9271700861E+01, 4.1083019383E+00, 9.8077100935E-01],
	[4.4850000000E+04, 4.8422699904E+01, 5.3025191188E+00, 2.9282323011E+01, 4.1086090248E+00, 9.8077859643E-01],
	[4.4855000000E+04, 4.8432282600E+01, 5.3025672817E+00, 2.9292947827E+01, 4.1089160332E+00, 9.8078617989E-01],
	[4.4860000000E+04, 4.8441866124E+01, 5.3026154397E+00, 2.9303575310E+01, 4.1092229633E+00, 9.8079375975E-01],
	[4.4865000000E+04, 4.8451450475E+01, 5.3026635927E+00, 2.9314205461E+01, 4.1095298153E+00, 9.8080133601E-01],
	[4.4870000000E+04, 4.8461035655E+01, 5.3027117408E+00, 2.9324838279E+01, 4.1098365892E+00, 9.8080890866E-01],
	[4.4875000000E+04, 4.8470621662E+01, 5.3027598839E+00, 2.9335473764E+01, 4.1101432850E+00, 9.8081647772E-01],
	[4.4880000000E+04, 4.8480208497E+01, 5.3028080222E+00, 2.9346111919E+01, 4.1104499027E+00, 9.8082404317E-01],
	[4.4885000000E+04, 4.8489796160E+01, 5.3028561555E+00, 2.9356752742E+01, 4.1107564423E+00, 9.8083160503E-01],
	[4.4890000000E+04, 4.8499384651E+01, 5.3029042839E+00, 2.9367396234E+01, 4.1110629039E+00, 9.8083916329E-01],
	[4.4895000000E+04, 4.8508973970E+01, 5.3029524074E+00, 2.9378042395E+01, 4.1113692875E+00, 9.8084671797E-01],
	[4.4900000000E+04, 4.8518564116E+01, 5.3030005259E+00, 2.9388691226E+01, 4.1116755931E+00, 9.8085426905E-01],
	[4.4905000000E+04, 4.8528155091E+01, 5.3030486395E+00, 2.9399342727E+01, 4.1119818208E+00, 9.8086181654E-01],
	[4.4910000000E+04, 4.8537746893E+01, 5.3030967482E+00, 2.9409996899E+01, 4.1122879705E+00, 9.8086936044E-01],
	[4.4915000000E+04, 4.8547339522E+01, 5.3031448520E+00, 2.9420653742E+01, 4.1125940422E+00, 9.8087690076E-01],
	[4.4920000000E+04, 4.8556932980E+01, 5.3031929509E+00, 2.9431313256E+01, 4.1129000361E+00, 9.8088443750E-01],
	[4.4925000000E+04, 4.8566527265E+01, 5.3032410448E+00, 2.9441975442E+01, 4.1132059521E+00, 9.8089197066E-01],
	[4.4930000000E+04, 4.8576122377E+01, 5.3032891338E+00, 2.9452640300E+01, 4.1135117902E+00, 9.8089950024E-01],
	[4.4935000000E+04, 4.8585718318E+01, 5.3033372180E+00, 2.9463307830E+01, 4.1138175505E+00, 9.8090702624E-01],
	[4.4940000000E+04, 4.8595315086E+01, 5.3033852971E+00, 2.9473978033E+01, 4.1141232330E+00, 9.8091454866E-01],
	[4.4945000000E+04, 4.8604912681E+01, 5.3034333714E+00, 2.9484650909E+01, 4.1144288377E+00, 9.8092206751E-01],
	[4.4950000000E+04, 4.8614511104E+01, 5.3034814408E+00, 2.9495326458E+01, 4.1147343647E+00, 9.8092958279E-01],
	[4.4955000000E+04, 4.8624110355E+01, 5.3035295053E+00, 2.9506004682E+01, 4.1150398139E+00, 9.8093709450E-01],
	[4.4960000000E+04, 4.8633710433E+01, 5.3035775648E+00, 2.9516685580E+01, 4.1153451853E+00, 9.8094460265E-01],
	[4.4965000000E+04, 4.8643311339E+01, 5.3036256195E+00, 2.9527369152E+01, 4.1156504791E+00, 9.8095210722E-01],
	[4.4970000000E+04, 4.8652913072E+01, 5.3036736692E+00, 2.9538055399E+01, 4.1159556952E+00, 9.8095960824E-01],
	[4.4975000000E+04, 4.8662515632E+01, 5.3037217140E+00, 2.9548744322E+01, 4.1162608337E+00, 9.8096710569E-01],
	[4.4980000000E+04, 4.8672119020E+01, 5.3037697540E+00, 2.9559435920E+01, 4.1165658945E+00, 9.8097459958E-01],
	[4.4985000000E+04, 4.8681723236E+01, 5.3038177890E+00, 2.9570130195E+01, 4.1168708777E+00, 9.8098208992E-01],
	[4.4990000000E+04, 4.8691328279E+01, 5.3038658191E+00, 2.9580827146E+01, 4.1171757833E+00, 9.8098957670E-01],
	[4.4995000000E+04, 4.8700934149E+01, 5.3039138443E+00, 2.9591526774E+01, 4.1174806114E+00, 9.8099705992E-01],
	[4.5000000000E+04, 4.8710540846E+01, 5.3039618646E+00, 2.9602229079E+01, 4.1177853620E+00, 9.8100453959E-01],
	[4.5005000000E+04, 4.8720148371E+01, 5.3040098800E+00, 2.9612953983E+01, 4.1180904202E+00, 9.8101201572E-01],
	[4.5010000000E+04, 4.8729756724E+01, 5.3040578905E+00, 2.9623681577E+01, 4.1183954008E+00, 9.8101948829E-01],
	[4.5015000000E+04, 4.8739365903E+01, 5.3041058962E+00, 2.9634411862E+01, 4.1187003037E+00, 9.8102695732E-01],
	[4.5020000000E+04, 4.8748975910E+01, 5.3041538969E+00, 2.9645144838E+01, 4.1190051289E+00, 9.8103442280E-01],
	[4.5025000000E+04, 4.8758586744E+01, 5.3042018927E+00, 2.9655880505E+01, 4.1193098765E+00, 9.8104188474E-01],
	[4.5030000000E+04, 4.8768198406E+01, 5.3042498836E+00, 2.9666618864E+01, 4.1196145465E+00, 9.8104934314E-01],
	[4.5035000000E+04, 4.8777810894E+01, 5.3042978696E+00, 2.9677359915E+01, 4.1199191389E+00, 9.8105679801E-01],
	[4.5040000000E+04, 4.8787424210E+01, 5.3043458508E+00, 2.9688103659E+01, 4.1202236538E+00, 9.8106424933E-01],
	[4.5045000000E+04, 4.8797038353E+01, 5.3043938270E+00, 2.9698850096E+01, 4.1205280911E+00, 9.8107169712E-01],
	[4.5050000000E+04, 4.8806653323E+01, 5.3044417984E+00, 2.9709599226E+01, 4.1208324508E+00, 9.8107914138E-01],
	[4.5055000000E+04, 4.8816269120E+01, 5.3044897648E+00, 2.9720351050E+01, 4.1211367331E+00, 9.8108658211E-01],
	[4.5060000000E+04, 4.8825885744E+01, 5.3045377264E+00, 2.9731105567E+01, 4.1214409379E+00, 9.8109401930E-01],
	[4.5065000000E+04, 4.8835503196E+01, 5.3045856831E+00, 2.9741862780E+01, 4.1217450653E+00, 9.8110145297E-01],
	[4.5070000000E+04, 4.8845121474E+01, 5.3046336349E+00, 2.9752622686E+01, 4.1220491152E+00, 9.8110888312E-01],
	[4.5075000000E+04, 4.8854740580E+01, 5.3046815818E+00, 2.9763385289E+01, 4.1223530877E+00, 9.8111630974E-01],
	[4.5080000000E+04, 4.8864360512E+01, 5.3047295238E+00, 2.9774150586E+01, 4.1226569829E+00, 9.8112373284E-01],
	[4.5085000000E+04, 4.8873981272E+01, 5.3047774610E+00, 2.9784918580E+01, 4.1229608007E+00, 9.8113115242E-01],
	[4.5090000000E+04, 4.8883602859E+01, 5.3048253932E+00, 2.9795689270E+01, 4.1232645411E+00, 9.8113856848E-01],
	[4.5095000000E+04, 4.8893225272E+01, 5.3048733206E+00, 2.9806462656E+01, 4.1235682042E+00, 9.8114598103E-01],
	[4.5100000000E+04, 4.8902848513E+01, 5.3049212431E+00, 2.9817238740E+01, 4.1238717901E+00, 9.8115339006E-01],
	[4.5105000000E+04, 4.8912472580E+01, 5.3049691607E+00, 2.9828017521E+01, 4.1241752986E+00, 9.8116079558E-01],
	[4.5110000000E+04, 4.8922097474E+01, 5.3050170735E+00, 2.9838798999E+01, 4.1244787299E+00, 9.8116819759E-01],
	[4.5115000000E+04, 4.8931723196E+01, 5.3050649813E+00, 2.9849583176E+01, 4.1247820840E+00, 9.8117559610E-01],
	[4.5120000000E+04, 4.8941349744E+01, 5.3051128843E+00, 2.9860370052E+01, 4.1250853609E+00, 9.8118299109E-01],
	[4.5125000000E+04, 4.8950977119E+01, 5.3051607824E+00, 2.9871159626E+01, 4.1253885606E+00, 9.8119038259E-01],
	[4.5130000000E+04, 4.8960605320E+01, 5.3052086756E+00, 2.9881951900E+01, 4.1256916831E+00, 9.8119777058E-01],
	[4.5135000000E+04, 4.8970234349E+01, 5.3052565640E+00, 2.9892746873E+01, 4.1259947285E+00, 9.8120515507E-01],
	[4.5140000000E+04, 4.8979864204E+01, 5.3053044475E+00, 2.9903544547E+01, 4.1262976968E+00, 9.8121253606E-01],
	[4.5145000000E+04, 4.8989494886E+01, 5.3053523261E+00, 2.9914344920E+01, 4.1266005880E+00, 9.8121991355E-01],
	[4.5150000000E+04, 4.8999126395E+01, 5.3054001999E+00, 2.9925147995E+01, 4.1269034021E+00, 9.8122728755E-01],
	[4.5155000000E+04, 4.9008758731E+01, 5.3054480687E+00, 2.9935953771E+01, 4.1272061392E+00, 9.8123465806E-01],
	[4.5160000000E+04, 4.9018391893E+01, 5.3054959327E+00, 2.9946762248E+01, 4.1275087993E+00, 9.8124202507E-01],
	[4.5165000000E+04, 4.9028025882E+01, 5.3055437919E+00, 2.9957573427E+01, 4.1278113823E+00, 9.8124938860E-01],
	[4.5170000000E+04, 4.9037660698E+01, 5.3055916462E+00, 2.9968387309E+01, 4.1281138884E+00, 9.8125674864E-01],
	[4.5175000000E+04, 4.9047296340E+01, 5.3056394956E+00, 2.9979203893E+01, 4.1284163175E+00, 9.8126410519E-01],
	[4.5180000000E+04, 4.9056932809E+01, 5.3056873401E+00, 2.9990023180E+01, 4.1287186697E+00, 9.8127145826E-01],
	[4.5185000000E+04, 4.9066570104E+01, 5.3057351798E+00, 3.0000845171E+01, 4.1290209450E+00, 9.8127880785E-01],
	[4.5190000000E+04, 4.9076208226E+01, 5.3057830146E+00, 3.0011669865E+01, 4.1293231434E+00, 9.8128615396E-01],
	[4.5195000000E+04, 4.9085847175E+01, 5.3058308446E+00, 3.0022497264E+01, 4.1296252649E+00, 9.8129349659E-01],
	[4.5200000000E+04, 4.9095486950E+01, 5.3058786697E+00, 3.0033327367E+01, 4.1299273095E+00, 9.8130083575E-01],
	[4.5205000000E+04, 4.9105127551E+01, 5.3059264899E+00, 3.0044160175E+01, 4.1302292774E+00, 9.8130817143E-01],
	[4.5210000000E+04, 4.9114768980E+01, 5.3059743053E+00, 3.0054995688E+01, 4.1305311684E+00, 9.8131550364E-01],
	[4.5215000000E+04, 4.9124411234E+01, 5.3060221158E+00, 3.0065833907E+01, 4.1308329827E+00, 9.8132283238E-01],
	[4.5220000000E+04, 4.9134054315E+01, 5.3060699215E+00, 3.0076674832E+01, 4.1311347202E+00, 9.8133015765E-01],
	[4.5225000000E+04, 4.9143698223E+01, 5.3061177223E+00, 3.0087518463E+01, 4.1314363810E+00, 9.8133747946E-01],
	[4.5230000000E+04, 4.9153342957E+01, 5.3061655182E+00, 3.0098364802E+01, 4.1317379651E+00, 9.8134479780E-01],
	[4.5235000000E+04, 4.9162988517E+01, 5.3062133094E+00, 3.0109213847E+01, 4.1320394724E+00, 9.8135211268E-01],
	[4.5240000000E+04, 4.9172634904E+01, 5.3062610956E+00, 3.0120065600E+01, 4.1323409031E+00, 9.8135942409E-01],
	[4.5245000000E+04, 4.9182282117E+01, 5.3063088770E+00, 3.0130920061E+01, 4.1326422572E+00, 9.8136673205E-01],
	[4.5250000000E+04, 4.9191930156E+01, 5.3063566536E+00, 3.0141777230E+01, 4.1329435347E+00, 9.8137403655E-01],
	[4.5255000000E+04, 4.9201579022E+01, 5.3064044253E+00, 3.0152637108E+01, 4.1332447355E+00, 9.8138133760E-01],
	[4.5260000000E+04, 4.9211228714E+01, 5.3064521921E+00, 3.0163499694E+01, 4.1335458598E+00, 9.8138863519E-01],
	[4.5265000000E+04, 4.9220879232E+01, 5.3064999541E+00, 3.0174364991E+01, 4.1338469075E+00, 9.8139592933E-01],
	[4.5270000000E+04, 4.9230530576E+01, 5.3065477113E+00, 3.0185232997E+01, 4.1341478787E+00, 9.8140322002E-01],
	[4.5275000000E+04, 4.9240182747E+01, 5.3065954636E+00, 3.0196103713E+01, 4.1344487734E+00, 9.8141050727E-01],
	[4.5280000000E+04, 4.9249835744E+01, 5.3066432111E+00, 3.0206977140E+01, 4.1347495916E+00, 9.8141779107E-01],
	[4.5285000000E+04, 4.9259489567E+01, 5.3066909537E+00, 3.0217853277E+01, 4.1350503333E+00, 9.8142507142E-01],
	[4.5290000000E+04, 4.9269144216E+01, 5.3067386915E+00, 3.0228732126E+01, 4.1353509986E+00, 9.8143234833E-01],
	[4.5295000000E+04, 4.9278799692E+01, 5.3067864245E+00, 3.0239613687E+01, 4.1356515875E+00, 9.8143962181E-01],
	[4.5300000000E+04, 4.9288455993E+01, 5.3068341526E+00, 3.0250497959E+01, 4.1359520999E+00, 9.8144689184E-01],
	[4.5305000000E+04, 4.9298125097E+01, 5.3068829986E+00, 3.0261384945E+01, 4.1362533024E+00, 9.8145415844E-01],
	[4.5310000000E+04, 4.9307801884E+01, 5.3069324820E+00, 3.0272274642E+01, 4.1365548671E+00, 9.8146142160E-01],
	[4.5315000000E+04, 4.9317479502E+01, 5.3069819604E+00, 3.0283167053E+01, 4.1368563556E+00, 9.8146868133E-01],
	[4.5320000000E+04, 4.9327157951E+01, 5.3070314339E+00, 3.0294062178E+01, 4.1371577679E+00, 9.8147593763E-01],
	[4.5325000000E+04, 4.9336837232E+01, 5.3070809023E+00, 3.0304960016E+01, 4.1374591041E+00, 9.8148319051E-01],
	[4.5330000000E+04, 4.9346517344E+01, 5.3071303657E+00, 3.0315860569E+01, 4.1377603642E+00, 9.8149043995E-01],
	[4.5335000000E+04, 4.9356198288E+01, 5.3071798242E+00, 3.0326763837E+01, 4.1380615482E+00, 9.8149768597E-01],
	[4.5340000000E+04, 4.9365880062E+01, 5.3072292776E+00, 3.0337669819E+01, 4.1383626561E+00, 9.8150492857E-01],
	[4.5345000000E+04, 4.9375562668E+01, 5.3072787261E+00, 3.0348578517E+01, 4.1386636879E+00, 9.8151216774E-01],
	[4.5350000000E+04, 4.9385246106E+01, 5.3073281695E+00, 3.0359489931E+01, 4.1389646438E+00, 9.8151940350E-01],
	[4.5355000000E+04, 4.9394930374E+01, 5.3073776080E+00, 3.0370404061E+01, 4.1392655236E+00, 9.8152663583E-01],
	[4.5360000000E+04, 4.9404615474E+01, 5.3074270415E+00, 3.0381320907E+01, 4.1395663274E+00, 9.8153386476E-01],
	[4.5365000000E+04, 4.9414301404E+01, 5.3074764700E+00, 3.0392240470E+01, 4.1398670553E+00, 9.8154109026E-01],
	[4.5370000000E+04, 4.9423988166E+01, 5.3075258935E+00, 3.0403162751E+01, 4.1401677072E+00, 9.8154831236E-01],
	[4.5375000000E+04, 4.9433675759E+01, 5.3075753120E+00, 3.0414087749E+01, 4.1404682833E+00, 9.8155553105E-01],
	[4.5380000000E+04, 4.9443364183E+01, 5.3076247255E+00, 3.0425015466E+01, 4.1407687834E+00, 9.8156274632E-01],
	[4.5385000000E+04, 4.9453053438E+01, 5.3076741341E+00, 3.0435945900E+01, 4.1410692076E+00, 9.8156995819E-01],
	[4.5390000000E+04, 4.9462743525E+01, 5.3077235377E+00, 3.0446879054E+01, 4.1413695560E+00, 9.8157716666E-01],
	[4.5395000000E+04, 4.9472434442E+01, 5.3077729362E+00, 3.0457814927E+01, 4.1416698286E+00, 9.8158437172E-01],
	[4.5400000000E+04, 4.9482126190E+01, 5.3078223298E+00, 3.0468753519E+01, 4.1419700253E+00, 9.8159157339E-01],
	[4.5405000000E+04, 4.9491818770E+01, 5.3078717185E+00, 3.0479694831E+01, 4.1422701463E+00, 9.8159877165E-01],
	[4.5410000000E+04, 4.9501512180E+01, 5.3079211021E+00, 3.0490638864E+01, 4.1425701915E+00, 9.8160596652E-01],
	[4.5415000000E+04, 4.9511206421E+01, 5.3079704808E+00, 3.0501585617E+01, 4.1428701609E+00, 9.8161315799E-01],
	[4.5420000000E+04, 4.9520901493E+01, 5.3080198545E+00, 3.0512535091E+01, 4.1431700547E+00, 9.8162034607E-01],
	[4.5425000000E+04, 4.9530597397E+01, 5.3080692232E+00, 3.0523487287E+01, 4.1434698727E+00, 9.8162753075E-01],
	[4.5430000000E+04, 4.9540294131E+01, 5.3081185869E+00, 3.0534442204E+01, 4.1437696151E+00, 9.8163471205E-01],
	[4.5435000000E+04, 4.9549991696E+01, 5.3081679457E+00, 3.0545399844E+01, 4.1440692818E+00, 9.8164188996E-01],
	[4.5440000000E+04, 4.9559690091E+01, 5.3082172995E+00, 3.0556360206E+01, 4.1443688729E+00, 9.8164906448E-01],
	[4.5445000000E+04, 4.9569389318E+01, 5.3082666483E+00, 3.0567323291E+01, 4.1446683883E+00, 9.8165623562E-01],
	[4.5450000000E+04, 4.9579089376E+01, 5.3083159922E+00, 3.0578289100E+01, 4.1449678282E+00, 9.8166340337E-01],
	[4.5455000000E+04, 4.9588790264E+01, 5.3083653311E+00, 3.0589257632E+01, 4.1452671925E+00, 9.8167056775E-01],
	[4.5460000000E+04, 4.9598491983E+01, 5.3084146650E+00, 3.0600228888E+01, 4.1455664813E+00, 9.8167772875E-01],
	[4.5465000000E+04, 4.9608194533E+01, 5.3084639939E+00, 3.0611202869E+01, 4.1458656945E+00, 9.8168488637E-01],
	[4.5470000000E+04, 4.9617897913E+01, 5.3085133179E+00, 3.0622179574E+01, 4.1461648323E+00, 9.8169204061E-01],
	[4.5475000000E+04, 4.9627602125E+01, 5.3085626369E+00, 3.0633159005E+01, 4.1464638946E+00, 9.8169919148E-01],
	[4.5480000000E+04, 4.9637307166E+01, 5.3086119510E+00, 3.0644141161E+01, 4.1467628814E+00, 9.8170633899E-01],
	[4.5485000000E+04, 4.9647013039E+01, 5.3086612600E+00, 3.0655126043E+01, 4.1470617928E+00, 9.8171348312E-01],
	[4.5490000000E+04, 4.9656719742E+01, 5.3087105642E+00, 3.0666113651E+01, 4.1473606287E+00, 9.8172062388E-01],
	[4.5495000000E+04, 4.9666427276E+01, 5.3087598633E+00, 3.0677103986E+01, 4.1476593893E+00, 9.8172776128E-01],
	[4.5500000000E+04, 4.9676135641E+01, 5.3088091575E+00, 3.0688097048E+01, 4.1479580745E+00, 9.8173489531E-01],
	[4.5505000000E+04, 4.9685844836E+01, 5.3088584468E+00, 3.0699092838E+01, 4.1482566844E+00, 9.8174202599E-01],
	[4.5510000000E+04, 4.9695554862E+01, 5.3089077311E+00, 3.0710091355E+01, 4.1485552189E+00, 9.8174915330E-01],
	[4.5515000000E+04, 4.9705265718E+01, 5.3089570104E+00, 3.0721092601E+01, 4.1488536782E+00, 9.8175627725E-01],
	[4.5520000000E+04, 4.9714977405E+01, 5.3090062848E+00, 3.0732096575E+01, 4.1491520622E+00, 9.8176339785E-01],
	[4.5525000000E+04, 4.9724689922E+01, 5.3090555542E+00, 3.0743103278E+01, 4.1494503709E+00, 9.8177051509E-01],
	[4.5530000000E+04, 4.9734403270E+01, 5.3091048187E+00, 3.0754112710E+01, 4.1497486043E+00, 9.8177762898E-01],
	[4.5535000000E+04, 4.9744117449E+01, 5.3091540782E+00, 3.0765124872E+01, 4.1500467626E+00, 9.8178473952E-01],
	[4.5540000000E+04, 4.9753832458E+01, 5.3092033327E+00, 3.0776139764E+01, 4.1503448457E+00, 9.8179184671E-01],
	[4.5545000000E+04, 4.9763548297E+01, 5.3092525824E+00, 3.0787157387E+01, 4.1506428536E+00, 9.8179895055E-01],
	[4.5550000000E+04, 4.9773264966E+01, 5.3093018270E+00, 3.0798177740E+01, 4.1509407863E+00, 9.8180605105E-01],
	[4.5555000000E+04, 4.9782982467E+01, 5.3093510667E+00, 3.0809200825E+01, 4.1512386439E+00, 9.8181314820E-01],
	[4.5560000000E+04, 4.9792700797E+01, 5.3094003015E+00, 3.0820226641E+01, 4.1515364265E+00, 9.8182024201E-01],
	[4.5565000000E+04, 4.9802419958E+01, 5.3094495313E+00, 3.0831255189E+01, 4.1518341339E+00, 9.8182733249E-01],
	[4.5570000000E+04, 4.9812139949E+01, 5.3094987562E+00, 3.0842286469E+01, 4.1521317663E+00, 9.8183441962E-01],
	[4.5575000000E+04, 4.9821860770E+01, 5.3095479761E+00, 3.0853320483E+01, 4.1524293236E+00, 9.8184150342E-01],
	[4.5580000000E+04, 4.9831582422E+01, 5.3095971911E+00, 3.0864357229E+01, 4.1527268059E+00, 9.8184858388E-01],
	[4.5585000000E+04, 4.9841304904E+01, 5.3096464011E+00, 3.0875396708E+01, 4.1530242133E+00, 9.8185566101E-01],
	[4.5590000000E+04, 4.9851028216E+01, 5.3096956062E+00, 3.0886438922E+01, 4.1533215456E+00, 9.8186273481E-01],
	[4.5595000000E+04, 4.9860752359E+01, 5.3097448064E+00, 3.0897483869E+01, 4.1536188030E+00, 9.8186980528E-01],
	[4.5600000000E+04, 4.9870477332E+01, 5.3097940016E+00, 3.0908531551E+01, 4.1539159855E+00, 9.8187687242E-01],
	[4.5605000000E+04, 4.9880203135E+01, 5.3098431919E+00, 3.0919581969E+01, 4.1542130931E+00, 9.8188393624E-01],
	[4.5610000000E+04, 4.9889929768E+01, 5.3098923773E+00, 3.0930635121E+01, 4.1545101258E+00, 9.8189099673E-01],
	[4.5615000000E+04, 4.9899657231E+01, 5.3099415577E+00, 3.0941691009E+01, 4.1548070836E+00, 9.8189805390E-01],
	[4.5620000000E+04, 4.9909385524E+01, 5.3099907331E+00, 3.0952749634E+01, 4.1551039666E+00, 9.8190510775E-01],
	[4.5625000000E+04, 4.9919114648E+01, 5.3100399037E+00, 3.0963810994E+01, 4.1554007748E+00, 9.8191215829E-01],
	[4.5630000000E+04, 4.9928844602E+01, 5.3100890693E+00, 3.0974875092E+01, 4.1556975082E+00, 9.8191920551E-01],
	[4.5635000000E+04, 4.9938575385E+01, 5.3101382300E+00, 3.0985941926E+01, 4.1559941668E+00, 9.8192624941E-01],
	[4.5640000000E+04, 4.9948306999E+01, 5.3101873857E+00, 3.0997011499E+01, 4.1562907506E+00, 9.8193329000E-01],
	[4.5645000000E+04, 4.9958039443E+01, 5.3102365365E+00, 3.1008083809E+01, 4.1565872597E+00, 9.8194032728E-01],
	[4.5650000000E+04, 4.9967772717E+01, 5.3102856824E+00, 3.1019158858E+01, 4.1568836941E+00, 9.8194736125E-01],
	[4.5655000000E+04, 4.9977506820E+01, 5.3103348234E+00, 3.1030236645E+01, 4.1571800538E+00, 9.8195439192E-01],
	[4.5660000000E+04, 4.9987241754E+01, 5.3103839594E+00, 3.1041317171E+01, 4.1574763389E+00, 9.8196141927E-01],
	[4.5665000000E+04, 4.9996977518E+01, 5.3104330905E+00, 3.1052400437E+01, 4.1577725493E+00, 9.8196844333E-01],
	[4.5670000000E+04, 5.0006714111E+01, 5.3104822167E+00, 3.1063486443E+01, 4.1580686851E+00, 9.8197546408E-01],
	[4.5675000000E+04, 5.0016451535E+01, 5.3105313380E+00, 3.1074575189E+01, 4.1583647463E+00, 9.8198248154E-01],
	[4.5680000000E+04, 5.0026189788E+01, 5.3105804543E+00, 3.1085666675E+01, 4.1586607329E+00, 9.8198949569E-01],
	[4.5685000000E+04, 5.0035928872E+01, 5.3106295657E+00, 3.1096760903E+01, 4.1589566449E+00, 9.8199650655E-01],
	[4.5690000000E+04, 5.0045668785E+01, 5.3106786722E+00, 3.1107857872E+01, 4.1592524825E+00, 9.8200351412E-01],
	[4.5695000000E+04, 5.0055409528E+01, 5.3107277738E+00, 3.1118957582E+01, 4.1595482455E+00, 9.8201051839E-01],
	[4.5700000000E+04, 5.0065151101E+01, 5.3107768704E+00, 3.1130060035E+01, 4.1598439340E+00, 9.8201751937E-01],
	[4.5705000000E+04, 5.0074893503E+01, 5.3108259622E+00, 3.1141165230E+01, 4.1601395480E+00, 9.8202451706E-01],
	[4.5710000000E+04, 5.0084636736E+01, 5.3108750490E+00, 3.1152273168E+01, 4.1604350876E+00, 9.8203151147E-01],
	[4.5715000000E+04, 5.0094380798E+01, 5.3109241309E+00, 3.1163383849E+01, 4.1607305528E+00, 9.8203850259E-01],
	[4.5720000000E+04, 5.0104125690E+01, 5.3109732079E+00, 3.1174497274E+01, 4.1610259436E+00, 9.8204549042E-01],
	[4.5725000000E+04, 5.0113871412E+01, 5.3110222800E+00, 3.1185613442E+01, 4.1613212600E+00, 9.8205247498E-01],
	[4.5730000000E+04, 5.0123617963E+01, 5.3110713471E+00, 3.1196732355E+01, 4.1616165020E+00, 9.8205945625E-01],
	[4.5735000000E+04, 5.0133365344E+01, 5.3111204094E+00, 3.1207854013E+01, 4.1619116697E+00, 9.8206643425E-01],
	[4.5740000000E+04, 5.0143113554E+01, 5.3111694667E+00, 3.1218978416E+01, 4.1622067631E+00, 9.8207340897E-01],
	[4.5745000000E+04, 5.0152862595E+01, 5.3112185192E+00, 3.1230105565E+01, 4.1625017821E+00, 9.8208038041E-01],
	[4.5750000000E+04, 5.0162612465E+01, 5.3112675667E+00, 3.1241235459E+01, 4.1627967269E+00, 9.8208734858E-01],
	[4.5755000000E+04, 5.0172363164E+01, 5.3113166093E+00, 3.1252368099E+01, 4.1630915975E+00, 9.8209431349E-01],
	[4.5760000000E+04, 5.0182114693E+01, 5.3113656470E+00, 3.1263503486E+01, 4.1633863938E+00, 9.8210127512E-01],
	[4.5765000000E+04, 5.0191867052E+01, 5.3114146798E+00, 3.1274641620E+01, 4.1636811160E+00, 9.8210823348E-01],
	[4.5770000000E+04, 5.0201620240E+01, 5.3114637077E+00, 3.1285782502E+01, 4.1639757639E+00, 9.8211518858E-01],
	[4.5775000000E+04, 5.0211374257E+01, 5.3115127307E+00, 3.1296926131E+01, 4.1642703377E+00, 9.8212214042E-01],
	[4.5780000000E+04, 5.0221129104E+01, 5.3115617488E+00, 3.1308072508E+01, 4.1645648373E+00, 9.8212908899E-01],
	[4.5785000000E+04, 5.0230884781E+01, 5.3116107620E+00, 3.1319221634E+01, 4.1648592628E+00, 9.8213603430E-01],
	[4.5790000000E+04, 5.0240641287E+01, 5.3116597703E+00, 3.1330373508E+01, 4.1651536142E+00, 9.8214297636E-01],
	[4.5795000000E+04, 5.0250398623E+01, 5.3117087737E+00, 3.1341528132E+01, 4.1654478915E+00, 9.8214991516E-01],
	[4.5800000000E+04, 5.0260156787E+01, 5.3117577722E+00, 3.1352685506E+01, 4.1657420948E+00, 9.8215685070E-01],
	[4.5805000000E+04, 5.0269915782E+01, 5.3118067658E+00, 3.1363845629E+01, 4.1660362241E+00, 9.8216378299E-01],
	[4.5810000000E+04, 5.0279675605E+01, 5.3118557545E+00, 3.1375008503E+01, 4.1663302793E+00, 9.8217071203E-01],
	[4.5815000000E+04, 5.0289436258E+01, 5.3119047384E+00, 3.1386174128E+01, 4.1666242605E+00, 9.8217763782E-01],
	[4.5820000000E+04, 5.0299197741E+01, 5.3119537173E+00, 3.1397342503E+01, 4.1669181678E+00, 9.8218456036E-01],
	[4.5825000000E+04, 5.0308960052E+01, 5.3120026913E+00, 3.1408513630E+01, 4.1672120011E+00, 9.8219147966E-01],
	[4.5830000000E+04, 5.0318723193E+01, 5.3120516604E+00, 3.1419687509E+01, 4.1675057605E+00, 9.8219839571E-01],
	[4.5835000000E+04, 5.0328487163E+01, 5.3121006247E+00, 3.1430864141E+01, 4.1677994460E+00, 9.8220530852E-01],
	[4.5840000000E+04, 5.0338251963E+01, 5.3121495840E+00, 3.1442043525E+01, 4.1680930577E+00, 9.8221221809E-01],
	[4.5845000000E+04, 5.0348017592E+01, 5.3121985385E+00, 3.1453225662E+01, 4.1683865954E+00, 9.8221912442E-01],
	[4.5850000000E+04, 5.0357784050E+01, 5.3122474881E+00, 3.1464410552E+01, 4.1686800593E+00, 9.8222602752E-01],
	[4.5855000000E+04, 5.0367551337E+01, 5.3122964328E+00, 3.1475598196E+01, 4.1689734494E+00, 9.8223292738E-01],
	[4.5860000000E+04, 5.0377319453E+01, 5.3123453726E+00, 3.1486788594E+01, 4.1692667657E+00, 9.8223982400E-01],
	[4.5865000000E+04, 5.0387088398E+01, 5.3123943075E+00, 3.1497981747E+01, 4.1695600083E+00, 9.8224671740E-01],
	[4.5870000000E+04, 5.0396858173E+01, 5.3124432375E+00, 3.1509177654E+01, 4.1698531771E+00, 9.8225360756E-01],
	[4.5875000000E+04, 5.0406628777E+01, 5.3124921627E+00, 3.1520376317E+01, 4.1701462721E+00, 9.8226049450E-01],
	[4.5880000000E+04, 5.0416400209E+01, 5.3125410829E+00, 3.1531577736E+01, 4.1704392935E+00, 9.8226737821E-01],
	[4.5885000000E+04, 5.0426172471E+01, 5.3125899983E+00, 3.1542781910E+01, 4.1707322411E+00, 9.8227425869E-01],
	[4.5890000000E+04, 5.0435945562E+01, 5.3126389088E+00, 3.1553988841E+01, 4.1710251151E+00, 9.8228113595E-01],
	[4.5895000000E+04, 5.0445719482E+01, 5.3126878145E+00, 3.1565198529E+01, 4.1713179155E+00, 9.8228801000E-01],
	[4.5900000000E+04, 5.0455494231E+01, 5.3127367152E+00, 3.1576410974E+01, 4.1716106422E+00, 9.8229488082E-01],
	[4.5905000000E+04, 5.0465269809E+01, 5.3127856111E+00, 3.1587626176E+01, 4.1719032953E+00, 9.8230174842E-01],
	[4.5910000000E+04, 5.0475046216E+01, 5.3128345021E+00, 3.1598844136E+01, 4.1721958749E+00, 9.8230861281E-01],
	[4.5915000000E+04, 5.0484823451E+01, 5.3128833882E+00, 3.1610064855E+01, 4.1724883809E+00, 9.8231547399E-01],
	[4.5920000000E+04, 5.0494601516E+01, 5.3129322695E+00, 3.1621288332E+01, 4.1727808133E+00, 9.8232233195E-01],
	[4.5925000000E+04, 5.0504380410E+01, 5.3129811459E+00, 3.1632514568E+01, 4.1730731723E+00, 9.8232918671E-01],
	[4.5930000000E+04, 5.0514160132E+01, 5.3130300174E+00, 3.1643743563E+01, 4.1733654577E+00, 9.8233603825E-01],
	[4.5935000000E+04, 5.0523940684E+01, 5.3130788840E+00, 3.1654975319E+01, 4.1736576697E+00, 9.8234288659E-01],
	[4.5940000000E+04, 5.0533722064E+01, 5.3131277458E+00, 3.1666209834E+01, 4.1739498083E+00, 9.8234973173E-01],
	[4.5945000000E+04, 5.0543504273E+01, 5.3131766027E+00, 3.1677447110E+01, 4.1742418734E+00, 9.8235657366E-01],
	[4.5950000000E+04, 5.0553287311E+01, 5.3132254547E+00, 3.1688687147E+01, 4.1745338651E+00, 9.8236341239E-01],
	[4.5955000000E+04, 5.0563071178E+01, 5.3132743019E+00, 3.1699929945E+01, 4.1748257834E+00, 9.8237024792E-01],
	[4.5960000000E+04, 5.0572855873E+01, 5.3133231442E+00, 3.1711175505E+01, 4.1751176283E+00, 9.8237708025E-01],
	[4.5965000000E+04, 5.0582641398E+01, 5.3133719817E+00, 3.1722423827E+01, 4.1754094000E+00, 9.8238390938E-01],
	[4.5970000000E+04, 5.0592427751E+01, 5.3134208142E+00, 3.1733674912E+01, 4.1757010983E+00, 9.8239073532E-01],
	[4.5975000000E+04, 5.0602214932E+01, 5.3134696419E+00, 3.1744928759E+01, 4.1759927233E+00, 9.8239755807E-01],
	[4.5980000000E+04, 5.0612002943E+01, 5.3135184648E+00, 3.1756185369E+01, 4.1762842750E+00, 9.8240437763E-01],
	[4.5985000000E+04, 5.0621791782E+01, 5.3135672828E+00, 3.1767444743E+01, 4.1765757534E+00, 9.8241119400E-01],
	[4.5990000000E+04, 5.0631581449E+01, 5.3136160959E+00, 3.1778706881E+01, 4.1768671587E+00, 9.8241800718E-01],
	[4.5995000000E+04, 5.0641371946E+01, 5.3136649042E+00, 3.1789971783E+01, 4.1771584907E+00, 9.8242481718E-01],
	[4.6000000000E+04, 5.0651163271E+01, 5.3137137076E+00, 3.1801239449E+01, 4.1774497495E+00, 9.8243162399E-01],
	[4.6005000000E+04, 5.0660955424E+01, 5.3137625062E+00, 3.1812509881E+01, 4.1777409352E+00, 9.8243842762E-01],
	[4.6010000000E+04, 5.0670748406E+01, 5.3138112999E+00, 3.1823783078E+01, 4.1780320477E+00, 9.8244522807E-01],
	[4.6015000000E+04, 5.0680542217E+01, 5.3138600887E+00, 3.1835059041E+01, 4.1783230871E+00, 9.8245202534E-01],
	[4.6020000000E+04, 5.0690336856E+01, 5.3139088727E+00, 3.1846337770E+01, 4.1786140534E+00, 9.8245881944E-01],
	[4.6025000000E+04, 5.0700132324E+01, 5.3139576519E+00, 3.1857619266E+01, 4.1789049466E+00, 9.8246561036E-01],
	[4.6030000000E+04, 5.0709928620E+01, 5.3140064262E+00, 3.1868903529E+01, 4.1791957668E+00, 9.8247239810E-01],
	[4.6035000000E+04, 5.0719740411E+01, 5.3140565379E+00, 3.1880190559E+01, 4.1794874438E+00, 9.8247918268E-01],
	[4.6040000000E+04, 5.0729557255E+01, 5.3141070310E+00, 3.1891480357E+01, 4.1797793155E+00, 9.8248596409E-01],
	[4.6045000000E+04, 5.0739374932E+01, 5.3141575191E+00, 3.1902772922E+01, 4.1800711144E+00, 9.8249274232E-01],
	[4.6050000000E+04, 5.0749193444E+01, 5.3142080021E+00, 3.1914068256E+01, 4.1803628404E+00, 9.8249951739E-01],
	[4.6055000000E+04, 5.0759012789E+01, 5.3142584802E+00, 3.1925366359E+01, 4.1806544936E+00, 9.8250628930E-01],
	[4.6060000000E+04, 5.0768832967E+01, 5.3143089532E+00, 3.1936667232E+01, 4.1809460740E+00, 9.8251305805E-01],
	[4.6065000000E+04, 5.0778653979E+01, 5.3143594213E+00, 3.1947970873E+01, 4.1812375816E+00, 9.8251982363E-01],
	[4.6070000000E+04, 5.0788475825E+01, 5.3144098843E+00, 3.1959277285E+01, 4.1815290165E+00, 9.8252658605E-01],
	[4.6075000000E+04, 5.0798298505E+01, 5.3144603424E+00, 3.1970586467E+01, 4.1818203787E+00, 9.8253334531E-01],
	[4.6080000000E+04, 5.0808122017E+01, 5.3145107954E+00, 3.1981898420E+01, 4.1821116681E+00, 9.8254010142E-01],
	[4.6085000000E+04, 5.0817946364E+01, 5.3145612435E+00, 3.1993213144E+01, 4.1824028848E+00, 9.8254685437E-01],
	[4.6090000000E+04, 5.0827771544E+01, 5.3146116866E+00, 3.2004530639E+01, 4.1826940289E+00, 9.8255360417E-01],
	[4.6095000000E+04, 5.0837597557E+01, 5.3146621247E+00, 3.2015850906E+01, 4.1829851003E+00, 9.8256035082E-01],
	[4.6100000000E+04, 5.0847424404E+01, 5.3147125577E+00, 3.2027173945E+01, 4.1832760991E+00, 9.8256709431E-01],
	[4.6105000000E+04, 5.0857252084E+01, 5.3147629858E+00, 3.2038499757E+01, 4.1835670253E+00, 9.8257383466E-01],
	[4.6110000000E+04, 5.0867080598E+01, 5.3148134089E+00, 3.2049828342E+01, 4.1838578789E+00, 9.8258057186E-01],
	[4.6115000000E+04, 5.0876909945E+01, 5.3148638271E+00, 3.2061159700E+01, 4.1841486599E+00, 9.8258730591E-01],
	[4.6120000000E+04, 5.0886740126E+01, 5.3149142402E+00, 3.2072493832E+01, 4.1844393684E+00, 9.8259403682E-01],
	[4.6125000000E+04, 5.0896571140E+01, 5.3149646483E+00, 3.2083830738E+01, 4.1847300044E+00, 9.8260076459E-01],
	[4.6130000000E+04, 5.0906402987E+01, 5.3150150515E+00, 3.2095170419E+01, 4.1850205679E+00, 9.8260748921E-01],
	[4.6135000000E+04, 5.0916235668E+01, 5.3150654497E+00, 3.2106512874E+01, 4.1853110589E+00, 9.8261421070E-01],
	[4.6140000000E+04, 5.0926069182E+01, 5.3151158428E+00, 3.2117858104E+01, 4.1856014774E+00, 9.8262092905E-01],
	[4.6145000000E+04, 5.0935903529E+01, 5.3151662310E+00, 3.2129206111E+01, 4.1858918235E+00, 9.8262764426E-01],
	[4.6150000000E+04, 5.0945738709E+01, 5.3152166143E+00, 3.2140556893E+01, 4.1861820972E+00, 9.8263435634E-01],
	[4.6155000000E+04, 5.0955574723E+01, 5.3152669925E+00, 3.2151910451E+01, 4.1864722985E+00, 9.8264106528E-01],
	[4.6160000000E+04, 5.0965411570E+01, 5.3153173658E+00, 3.2163266786E+01, 4.1867624274E+00, 9.8264777110E-01],
	[4.6165000000E+04, 5.0975249250E+01, 5.3153677340E+00, 3.2174625899E+01, 4.1870524840E+00, 9.8265447378E-01],
	[4.6170000000E+04, 5.0985087764E+01, 5.3154180973E+00, 3.2185987788E+01, 4.1873424683E+00, 9.8266117334E-01],
	[4.6175000000E+04, 5.0994927110E+01, 5.3154684557E+00, 3.2197352456E+01, 4.1876323802E+00, 9.8266786977E-01],
	[4.6180000000E+04, 5.1004767290E+01, 5.3155188090E+00, 3.2208719902E+01, 4.1879222199E+00, 9.8267456307E-01],
	[4.6185000000E+04, 5.1014608303E+01, 5.3155691574E+00, 3.2220090127E+01, 4.1882119872E+00, 9.8268125326E-01],
	[4.6190000000E+04, 5.1024450149E+01, 5.3156195008E+00, 3.2231463130E+01, 4.1885016824E+00, 9.8268794032E-01],
	[4.6195000000E+04, 5.1034292828E+01, 5.3156698392E+00, 3.2242838913E+01, 4.1887913053E+00, 9.8269462426E-01],
	[4.6200000000E+04, 5.1044136340E+01, 5.3157201727E+00, 3.2254217476E+01, 4.1890808560E+00, 9.8270130508E-01],
	[4.6205000000E+04, 5.1053980685E+01, 5.3157705012E+00, 3.2265598818E+01, 4.1893703346E+00, 9.8270798278E-01],
	[4.6210000000E+04, 5.1063825863E+01, 5.3158208247E+00, 3.2276982942E+01, 4.1896597410E+00, 9.8271465737E-01],
	[4.6215000000E+04, 5.1073671875E+01, 5.3158711432E+00, 3.2288369846E+01, 4.1899490752E+00, 9.8272132885E-01],
	[4.6220000000E+04, 5.1083518719E+01, 5.3159214568E+00, 3.2299759531E+01, 4.1902383373E+00, 9.8272799721E-01],
	[4.6225000000E+04, 5.1093366396E+01, 5.3159717654E+00, 3.2311151998E+01, 4.1905275274E+00, 9.8273466246E-01],
	[4.6230000000E+04, 5.1103214906E+01, 5.3160220691E+00, 3.2322547247E+01, 4.1908166453E+00, 9.8274132461E-01],
	[4.6235000000E+04, 5.1113064249E+01, 5.3160723678E+00, 3.2333945279E+01, 4.1911056912E+00, 9.8274798364E-01],
	[4.6240000000E+04, 5.1122914425E+01, 5.3161226615E+00, 3.2345346093E+01, 4.1913946651E+00, 9.8275463957E-01],
	[4.6245000000E+04, 5.1132765434E+01, 5.3161729503E+00, 3.2356749690E+01, 4.1916835670E+00, 9.8276129240E-01],
	[4.6250000000E+04, 5.1142617276E+01, 5.3162232341E+00, 3.2368156071E+01, 4.1919723968E+00, 9.8276794213E-01],
	[4.6255000000E+04, 5.1152469950E+01, 5.3162735129E+00, 3.2379565236E+01, 4.1922611547E+00, 9.8277458875E-01],
	[4.6260000000E+04, 5.1162323458E+01, 5.3163237868E+00, 3.2390977185E+01, 4.1925498407E+00, 9.8278123227E-01],
	[4.6265000000E+04, 5.1172177798E+01, 5.3163740557E+00, 3.2402391918E+01, 4.1928384547E+00, 9.8278787270E-01],
	[4.6270000000E+04, 5.1182032971E+01, 5.3164243197E+00, 3.2413809437E+01, 4.1931269968E+00, 9.8279451003E-01],
	[4.6275000000E+04, 5.1191888977E+01, 5.3164745787E+00, 3.2425229741E+01, 4.1934154671E+00, 9.8280114426E-01],
	[4.6280000000E+04, 5.1201745816E+01, 5.3165248327E+00, 3.2436652831E+01, 4.1937038655E+00, 9.8280777541E-01],
	[4.6285000000E+04, 5.1211603487E+01, 5.3165750818E+00, 3.2448078707E+01, 4.1939921920E+00, 9.8281440346E-01],
	[4.6290000000E+04, 5.1221461991E+01, 5.3166253260E+00, 3.2459507370E+01, 4.1942804467E+00, 9.8282102842E-01],
	[4.6295000000E+04, 5.1231321328E+01, 5.3166755652E+00, 3.2470938819E+01, 4.1945686297E+00, 9.8282765029E-01],
	[4.6300000000E+04, 5.1241181497E+01, 5.3167257994E+00, 3.2482373056E+01, 4.1948567408E+00, 9.8283426907E-01],
	[4.6305000000E+04, 5.1251042500E+01, 5.3167760287E+00, 3.2493810080E+01, 4.1951447802E+00, 9.8284088478E-01],
	[4.6310000000E+04, 5.1260904334E+01, 5.3168262531E+00, 3.2505249893E+01, 4.1954327478E+00, 9.8284749739E-01],
	[4.6315000000E+04, 5.1270767002E+01, 5.3168764725E+00, 3.2516692494E+01, 4.1957206438E+00, 9.8285410693E-01],
	[4.6320000000E+04, 5.1280630502E+01, 5.3169266869E+00, 3.2528137884E+01, 4.1960084680E+00, 9.8286071338E-01],
	[4.6325000000E+04, 5.1290494834E+01, 5.3169768964E+00, 3.2539586062E+01, 4.1962962206E+00, 9.8286731676E-01],
	[4.6330000000E+04, 5.1300360000E+01, 5.3170271010E+00, 3.2551037031E+01, 4.1965839015E+00, 9.8287391706E-01],
	[4.6335000000E+04, 5.1310225997E+01, 5.3170773006E+00, 3.2562490789E+01, 4.1968715108E+00, 9.8288051428E-01],
	[4.6340000000E+04, 5.1320092827E+01, 5.3171274953E+00, 3.2573947338E+01, 4.1971590485E+00, 9.8288710843E-01],
	[4.6345000000E+04, 5.1329960490E+01, 5.3171776850E+00, 3.2585406677E+01, 4.1974465146E+00, 9.8289369951E-01],
	[4.6350000000E+04, 5.1339828985E+01, 5.3172278698E+00, 3.2596868808E+01, 4.1977339091E+00, 9.8290028751E-01],
	[4.6355000000E+04, 5.1349698313E+01, 5.3172780496E+00, 3.2608333730E+01, 4.1980212321E+00, 9.8290687245E-01],
	[4.6360000000E+04, 5.1359568473E+01, 5.3173282245E+00, 3.2619801443E+01, 4.1983084835E+00, 9.8291345432E-01],
	[4.6365000000E+04, 5.1369439466E+01, 5.3173783945E+00, 3.2631271949E+01, 4.1985956635E+00, 9.8292003312E-01],
	[4.6370000000E+04, 5.1379311291E+01, 5.3174285595E+00, 3.2642745248E+01, 4.1988827720E+00, 9.8292660886E-01],
	[4.6375000000E+04, 5.1389183948E+01, 5.3174787196E+00, 3.2654221339E+01, 4.1991698090E+00, 9.8293318154E-01],
	[4.6380000000E+04, 5.1399057438E+01, 5.3175288748E+00, 3.2665700224E+01, 4.1994567745E+00, 9.8293975115E-01],
	[4.6385000000E+04, 5.1408931760E+01, 5.3175790250E+00, 3.2677181902E+01, 4.1997436687E+00, 9.8294631771E-01],
	[4.6390000000E+04, 5.1418806914E+01, 5.3176291703E+00, 3.2688666375E+01, 4.2000304915E+00, 9.8295288120E-01],
	[4.6395000000E+04, 5.1428682901E+01, 5.3176793107E+00, 3.2700153642E+01, 4.2003172428E+00, 9.8295944164E-01],
	[4.6400000000E+04, 5.1438559720E+01, 5.3177294461E+00, 3.2711643704E+01, 4.2006039228E+00, 9.8296599903E-01],
	[4.6405000000E+04, 5.1448437371E+01, 5.3177795766E+00, 3.2723136561E+01, 4.2008905315E+00, 9.8297255336E-01],
	[4.6410000000E+04, 5.1458315854E+01, 5.3178297022E+00, 3.2734632213E+01, 4.2011770689E+00, 9.8297910464E-01],
	[4.6415000000E+04, 5.1468195170E+01, 5.3178798229E+00, 3.2746130662E+01, 4.2014635350E+00, 9.8298565286E-01],
	[4.6420000000E+04, 5.1478075318E+01, 5.3179299386E+00, 3.2757631907E+01, 4.2017499298E+00, 9.8299219804E-01],
	[4.6425000000E+04, 5.1487956298E+01, 5.3179800494E+00, 3.2769135949E+01, 4.2020362534E+00, 9.8299874018E-01],
	[4.6430000000E+04, 5.1497838111E+01, 5.3180301553E+00, 3.2780642787E+01, 4.2023225057E+00, 9.8300527926E-01],
	[4.6435000000E+04, 5.1507720755E+01, 5.3180802562E+00, 3.2792152424E+01, 4.2026086868E+00, 9.8301181531E-01],
	[4.6440000000E+04, 5.1517604232E+01, 5.3181303523E+00, 3.2803664858E+01, 4.2028947967E+00, 9.8301834831E-01],
	[4.6445000000E+04, 5.1527488540E+01, 5.3181804434E+00, 3.2815180090E+01, 4.2031808355E+00, 9.8302487827E-01],
	[4.6450000000E+04, 5.1537373681E+01, 5.3182305295E+00, 3.2826698121E+01, 4.2034668031E+00, 9.8303140519E-01],
	[4.6455000000E+04, 5.1547259654E+01, 5.3182806108E+00, 3.2838218951E+01, 4.2037526996E+00, 9.8303792907E-01],
	[4.6460000000E+04, 5.1557146459E+01, 5.3183306872E+00, 3.2849742580E+01, 4.2040385250E+00, 9.8304444992E-01],
	[4.6465000000E+04, 5.1567034096E+01, 5.3183807586E+00, 3.2861269009E+01, 4.2043242793E+00, 9.8305096773E-01],
	[4.6470000000E+04, 5.1576922565E+01, 5.3184308251E+00, 3.2872798239E+01, 4.2046099625E+00, 9.8305748251E-01],
	[4.6475000000E+04, 5.1586811866E+01, 5.3184808867E+00, 3.2884330268E+01, 4.2048955747E+00, 9.8306399425E-01],
	[4.6480000000E+04, 5.1596701999E+01, 5.3185309434E+00, 3.2895865099E+01, 4.2051811159E+00, 9.8307050297E-01],
	[4.6485000000E+04, 5.1606592964E+01, 5.3185809952E+00, 3.2907402731E+01, 4.2054665861E+00, 9.8307700866E-01],
	[4.6490000000E+04, 5.1616484761E+01, 5.3186310420E+00, 3.2918943164E+01, 4.2057519853E+00, 9.8308351132E-01],
	[4.6495000000E+04, 5.1626377389E+01, 5.3186810840E+00, 3.2930486400E+01, 4.2060373136E+00, 9.8309001096E-01],
	[4.6500000000E+04, 5.1636270850E+01, 5.3187311210E+00, 3.2942032437E+01, 4.2063225709E+00, 9.8309650757E-01],
	[4.6505000000E+04, 5.1646165143E+01, 5.3187811531E+00, 3.2953581278E+01, 4.2066077573E+00, 9.8310300116E-01],
	[4.6510000000E+04, 5.1656060267E+01, 5.3188311804E+00, 3.2965132922E+01, 4.2068928728E+00, 9.8310949173E-01],
	[4.6515000000E+04, 5.1665956223E+01, 5.3188812027E+00, 3.2976687369E+01, 4.2071779174E+00, 9.8311597929E-01],
	[4.6520000000E+04, 5.1675853011E+01, 5.3189312201E+00, 3.2988244620E+01, 4.2074628912E+00, 9.8312246382E-01],
	[4.6525000000E+04, 5.1685750631E+01, 5.3189812326E+00, 3.2999804676E+01, 4.2077477942E+00, 9.8312894534E-01],
	[4.6530000000E+04, 5.1695649083E+01, 5.3190312402E+00, 3.3011367536E+01, 4.2080326263E+00, 9.8313542384E-01],
	[4.6535000000E+04, 5.1705548366E+01, 5.3190812429E+00, 3.3022933201E+01, 4.2083173876E+00, 9.8314189933E-01],
	[4.6540000000E+04, 5.1715448481E+01, 5.3191312406E+00, 3.3034501672E+01, 4.2086020782E+00, 9.8314837181E-01],
	[4.6545000000E+04, 5.1725349428E+01, 5.3191812335E+00, 3.3046072948E+01, 4.2088866981E+00, 9.8315484128E-01],
	[4.6550000000E+04, 5.1735251207E+01, 5.3192312215E+00, 3.3057647031E+01, 4.2091712472E+00, 9.8316130775E-01],
	[4.6555000000E+04, 5.1745153817E+01, 5.3192812046E+00, 3.3069223920E+01, 4.2094557256E+00, 9.8316777120E-01],
	[4.6560000000E+04, 5.1755057259E+01, 5.3193311828E+00, 3.3080803616E+01, 4.2097401333E+00, 9.8317423165E-01],
	[4.6565000000E+04, 5.1764961533E+01, 5.3193811561E+00, 3.3092386119E+01, 4.2100244703E+00, 9.8318068910E-01],
	[4.6570000000E+04, 5.1774866638E+01, 5.3194311245E+00, 3.3103971430E+01, 4.2103087367E+00, 9.8318714355E-01],
	[4.6575000000E+04, 5.1784772575E+01, 5.3194810880E+00, 3.3115559549E+01, 4.2105929325E+00, 9.8319359499E-01],
	[4.6580000000E+04, 5.1794679343E+01, 5.3195310466E+00, 3.3127150476E+01, 4.2108770577E+00, 9.8320004344E-01],
	[4.6585000000E+04, 5.1804586943E+01, 5.3195810003E+00, 3.3138744213E+01, 4.2111611123E+00, 9.8320648889E-01],
	[4.6590000000E+04, 5.1814495375E+01, 5.3196309491E+00, 3.3150340758E+01, 4.2114450963E+00, 9.8321293135E-01],
	[4.6595000000E+04, 5.1824404638E+01, 5.3196808931E+00, 3.3161940113E+01, 4.2117290098E+00, 9.8321937081E-01],
	[4.6600000000E+04, 5.1834314732E+01, 5.3197308321E+00, 3.3173542278E+01, 4.2120128528E+00, 9.8322580728E-01],
	[4.6605000000E+04, 5.1844225658E+01, 5.3197807663E+00, 3.3185147253E+01, 4.2122966253E+00, 9.8323224075E-01],
	[4.6610000000E+04, 5.1854137416E+01, 5.3198306955E+00, 3.3196755039E+01, 4.2125803273E+00, 9.8323867124E-01],
	[4.6615000000E+04, 5.1864050005E+01, 5.3198806199E+00, 3.3208365636E+01, 4.2128639589E+00, 9.8324509874E-01],
	[4.6620000000E+04, 5.1873963425E+01, 5.3199305394E+00, 3.3219979045E+01, 4.2131475200E+00, 9.8325152326E-01],
	[4.6625000000E+04, 5.1883877677E+01, 5.3199804540E+00, 3.3231595265E+01, 4.2134310107E+00, 9.8325794478E-01],
	[4.6630000000E+04, 5.1893792760E+01, 5.3200303637E+00, 3.3243214298E+01, 4.2137144310E+00, 9.8326436333E-01],
	[4.6635000000E+04, 5.1903708675E+01, 5.3200802686E+00, 3.3254836143E+01, 4.2139977810E+00, 9.8327077890E-01],
	[4.6640000000E+04, 5.1913625421E+01, 5.3201301685E+00, 3.3266460801E+01, 4.2142810606E+00, 9.8327719148E-01],
	[4.6645000000E+04, 5.1923542998E+01, 5.3201800636E+00, 3.3278088272E+01, 4.2145642698E+00, 9.8328360109E-01],
	[4.6650000000E+04, 5.1933461406E+01, 5.3202299538E+00, 3.3289718558E+01, 4.2148474088E+00, 9.8329000771E-01],
	[4.6655000000E+04, 5.1943380646E+01, 5.3202798391E+00, 3.3301351657E+01, 4.2151304774E+00, 9.8329641137E-01],
	[4.6660000000E+04, 5.1953300717E+01, 5.3203297195E+00, 3.3312987571E+01, 4.2154134758E+00, 9.8330281205E-01],
	[4.6665000000E+04, 5.1963221620E+01, 5.3203795951E+00, 3.3324626299E+01, 4.2156964040E+00, 9.8330920976E-01],
	[4.6670000000E+04, 5.1973143353E+01, 5.3204294658E+00, 3.3336267843E+01, 4.2159792619E+00, 9.8331560449E-01],
	[4.6675000000E+04, 5.1983065918E+01, 5.3204793316E+00, 3.3347912203E+01, 4.2162620496E+00, 9.8332199626E-01],
	[4.6680000000E+04, 5.1992989314E+01, 5.3205291925E+00, 3.3359559378E+01, 4.2165447671E+00, 9.8332838506E-01],
	[4.6685000000E+04, 5.2002913542E+01, 5.3205790486E+00, 3.3371209370E+01, 4.2168274145E+00, 9.8333477089E-01],
	[4.6690000000E+04, 5.2012838600E+01, 5.3206288998E+00, 3.3382862178E+01, 4.2171099917E+00, 9.8334115376E-01],
	[4.6695000000E+04, 5.2022764490E+01, 5.3206787461E+00, 3.3394517804E+01, 4.2173924988E+00, 9.8334753367E-01],
	[4.6700000000E+04, 5.2032691210E+01, 5.3207285875E+00, 3.3406176247E+01, 4.2176749358E+00, 9.8335391062E-01],
	[4.6705000000E+04, 5.2042618762E+01, 5.3207784241E+00, 3.3417837508E+01, 4.2179573027E+00, 9.8336028460E-01],
	[4.6710000000E+04, 5.2052547145E+01, 5.3208282558E+00, 3.3429501588E+01, 4.2182395996E+00, 9.8336665563E-01],
	[4.6715000000E+04, 5.2062476359E+01, 5.3208780827E+00, 3.3441168486E+01, 4.2185218264E+00, 9.8337302370E-01],
	[4.6720000000E+04, 5.2072406404E+01, 5.3209279046E+00, 3.3452838203E+01, 4.2188039832E+00, 9.8337938881E-01],
	[4.6725000000E+04, 5.2082337280E+01, 5.3209777217E+00, 3.3464510739E+01, 4.2190860700E+00, 9.8338575097E-01],
	[4.6730000000E+04, 5.2092268987E+01, 5.3210275340E+00, 3.3476186095E+01, 4.2193680868E+00, 9.8339211018E-01],
	[4.6735000000E+04, 5.2102201524E+01, 5.3210773414E+00, 3.3487864272E+01, 4.2196500336E+00, 9.8339846644E-01],
	[4.6740000000E+04, 5.2112134893E+01, 5.3211271439E+00, 3.3499545268E+01, 4.2199319106E+00, 9.8340481975E-01],
	[4.6745000000E+04, 5.2122069093E+01, 5.3211769415E+00, 3.3511229086E+01, 4.2202137176E+00, 9.8341117011E-01],
	[4.6750000000E+04, 5.2132004124E+01, 5.3212267343E+00, 3.3522915725E+01, 4.2204954547E+00, 9.8341751753E-01],
	[4.6755000000E+04, 5.2141939986E+01, 5.3212765223E+00, 3.3534605186E+01, 4.2207771219E+00, 9.8342386200E-01],
	[4.6760000000E+04, 5.2151876678E+01, 5.3213263054E+00, 3.3546297469E+01, 4.2210587193E+00, 9.8343020352E-01],
	[4.6765000000E+04, 5.2161814202E+01, 5.3213760836E+00, 3.3557992574E+01, 4.2213402469E+00, 9.8343654211E-01],
	[4.6770000000E+04, 5.2171752556E+01, 5.3214258570E+00, 3.3569690502E+01, 4.2216217046E+00, 9.8344287776E-01],
	[4.6775000000E+04, 5.2181702519E+01, 5.3214765885E+00, 3.3581391253E+01, 4.2219037693E+00, 9.8344921046E-01],
	[4.6780000000E+04, 5.2191661486E+01, 5.3215280449E+00, 3.3593094827E+01, 4.2221862771E+00, 9.8345554024E-01],
	[4.6785000000E+04, 5.2201621288E+01, 5.3215794963E+00, 3.3604801226E+01, 4.2224687154E+00, 9.8346186707E-01],
	[4.6790000000E+04, 5.2211581926E+01, 5.3216309427E+00, 3.3616510449E+01, 4.2227510840E+00, 9.8346819097E-01],
	[4.6795000000E+04, 5.2221543400E+01, 5.3216823841E+00, 3.3628222496E+01, 4.2230333830E+00, 9.8347451194E-01],
	[4.6800000000E+04, 5.2231505710E+01, 5.3217338206E+00, 3.3639937369E+01, 4.2233156125E+00, 9.8348082998E-01],
	[4.6805000000E+04, 5.2241468856E+01, 5.3217852520E+00, 3.3651655067E+01, 4.2235977724E+00, 9.8348714509E-01],
	[4.6810000000E+04, 5.2251432838E+01, 5.3218366784E+00, 3.3663375591E+01, 4.2238798628E+00, 9.8349345728E-01],
	[4.6815000000E+04, 5.2261397656E+01, 5.3218880998E+00, 3.3675098941E+01, 4.2241618837E+00, 9.8349976653E-01],
	[4.6820000000E+04, 5.2271363309E+01, 5.3219395162E+00, 3.3686825118E+01, 4.2244438351E+00, 9.8350607287E-01],
	[4.6825000000E+04, 5.2281329799E+01, 5.3219909277E+00, 3.3698554122E+01, 4.2247257171E+00, 9.8351237627E-01],
	[4.6830000000E+04, 5.2291297124E+01, 5.3220423341E+00, 3.3710285953E+01, 4.2250075296E+00, 9.8351867676E-01],
	[4.6835000000E+04, 5.2301265285E+01, 5.3220937355E+00, 3.3722020611E+01, 4.2252892727E+00, 9.8352497433E-01],
	[4.6840000000E+04, 5.2311234282E+01, 5.3221451320E+00, 3.3733758098E+01, 4.2255709463E+00, 9.8353126898E-01],
	[4.6845000000E+04, 5.2321204114E+01, 5.3221965235E+00, 3.3745498413E+01, 4.2258525506E+00, 9.8353756071E-01],
	[4.6850000000E+04, 5.2331174783E+01, 5.3222479099E+00, 3.3757241557E+01, 4.2261340856E+00, 9.8354384953E-01],
	[4.6855000000E+04, 5.2341146287E+01, 5.3222992914E+00, 3.3768987531E+01, 4.2264155512E+00, 9.8355013543E-01],
	[4.6860000000E+04, 5.2351118627E+01, 5.3223506679E+00, 3.3780736334E+01, 4.2266969475E+00, 9.8355641842E-01],
	[4.6865000000E+04, 5.2361091802E+01, 5.3224020395E+00, 3.3792487967E+01, 4.2269782745E+00, 9.8356269850E-01],
	[4.6870000000E+04, 5.2371065813E+01, 5.3224534060E+00, 3.3804242430E+01, 4.2272595322E+00, 9.8356897567E-01],
	[4.6875000000E+04, 5.2381040660E+01, 5.3225047675E+00, 3.3815999724E+01, 4.2275407206E+00, 9.8357524993E-01],
	[4.6880000000E+04, 5.2391016342E+01, 5.3225561241E+00, 3.3827759849E+01, 4.2278218398E+00, 9.8358152129E-01],
	[4.6885000000E+04, 5.2400992860E+01, 5.3226074757E+00, 3.3839522806E+01, 4.2281028898E+00, 9.8358778974E-01],
	[4.6890000000E+04, 5.2410970214E+01, 5.3226588223E+00, 3.3851288594E+01, 4.2283838706E+00, 9.8359405529E-01],
	[4.6895000000E+04, 5.2420948403E+01, 5.3227101639E+00, 3.3863057215E+01, 4.2286647822E+00, 9.8360031794E-01],
	[4.6900000000E+04, 5.2430927428E+01, 5.3227615006E+00, 3.3874828668E+01, 4.2289456247E+00, 9.8360657768E-01],
	[4.6905000000E+04, 5.2440907288E+01, 5.3228128322E+00, 3.3886602955E+01, 4.2292263980E+00, 9.8361283453E-01],
	[4.6910000000E+04, 5.2450887984E+01, 5.3228641589E+00, 3.3898380075E+01, 4.2295071023E+00, 9.8361908848E-01],
	[4.6915000000E+04, 5.2460869515E+01, 5.3229154806E+00, 3.3910160028E+01, 4.2297877374E+00, 9.8362533954E-01],
	[4.6920000000E+04, 5.2470851882E+01, 5.3229667974E+00, 3.3921942816E+01, 4.2300683034E+00, 9.8363158770E-01],
	[4.6925000000E+04, 5.2480835084E+01, 5.3230181091E+00, 3.3933728438E+01, 4.2303488004E+00, 9.8363783297E-01],
	[4.6930000000E+04, 5.2490819121E+01, 5.3230694159E+00, 3.3945516895E+01, 4.2306292284E+00, 9.8364407535E-01],
	[4.6935000000E+04, 5.2500803995E+01, 5.3231207178E+00, 3.3957308188E+01, 4.2309095873E+00, 9.8365031484E-01],
	[4.6940000000E+04, 5.2510789703E+01, 5.3231720146E+00, 3.3969102316E+01, 4.2311898773E+00, 9.8365655144E-01],
	[4.6945000000E+04, 5.2520776247E+01, 5.3232233065E+00, 3.3980899280E+01, 4.2314700983E+00, 9.8366278515E-01],
	[4.6950000000E+04, 5.2530763626E+01, 5.3232745934E+00, 3.3992699081E+01, 4.2317502503E+00, 9.8366901598E-01],
	[4.6955000000E+04, 5.2540751840E+01, 5.3233258754E+00, 3.4004501718E+01, 4.2320303334E+00, 9.8367524393E-01],
	[4.6960000000E+04, 5.2550740890E+01, 5.3233771523E+00, 3.4016307193E+01, 4.2323103476E+00, 9.8368146899E-01],
	[4.6965000000E+04, 5.2560730775E+01, 5.3234284244E+00, 3.4028115505E+01, 4.2325902929E+00, 9.8368769117E-01],
	[4.6970000000E+04, 5.2570721496E+01, 5.3234796914E+00, 3.4039926655E+01, 4.2328701693E+00, 9.8369391048E-01],
	[4.6975000000E+04, 5.2580713051E+01, 5.3235309535E+00, 3.4051740643E+01, 4.2331499769E+00, 9.8370012691E-01],
	[4.6980000000E+04, 5.2590705442E+01, 5.3235822106E+00, 3.4063557470E+01, 4.2334297157E+00, 9.8370634046E-01],
	[4.6985000000E+04, 5.2600698668E+01, 5.3236334628E+00, 3.4075377136E+01, 4.2337093856E+00, 9.8371255113E-01],
	[4.6990000000E+04, 5.2610692730E+01, 5.3236847100E+00, 3.4087199642E+01, 4.2339889868E+00, 9.8371875894E-01],
	[4.6995000000E+04, 5.2620687626E+01, 5.3237359522E+00, 3.4099024987E+01, 4.2342685192E+00, 9.8372496387E-01],
	[4.7000000000E+04, 5.2630683358E+01, 5.3237871895E+00, 3.4110853172E+01, 4.2345479828E+00, 9.8373116593E-01],
	[4.7005000000E+04, 5.2640679925E+01, 5.3238384218E+00, 3.4122684199E+01, 4.2348273777E+00, 9.8373736513E-01],
	[4.7010000000E+04, 5.2650677327E+01, 5.3238896492E+00, 3.4134518066E+01, 4.2351067040E+00, 9.8374356146E-01],
	[4.7015000000E+04, 5.2660675564E+01, 5.3239408716E+00, 3.4146354774E+01, 4.2353859615E+00, 9.8374975492E-01],
	[4.7020000000E+04, 5.2670674636E+01, 5.3239920891E+00, 3.4158194324E+01, 4.2356651503E+00, 9.8375594552E-01],
	[4.7025000000E+04, 5.2680674543E+01, 5.3240433016E+00, 3.4170036716E+01, 4.2359442705E+00, 9.8376213325E-01],
	[4.7030000000E+04, 5.2690675286E+01, 5.3240945091E+00, 3.4181881951E+01, 4.2362233221E+00, 9.8376831813E-01],
	[4.7035000000E+04, 5.2700676863E+01, 5.3241457117E+00, 3.4193730029E+01, 4.2365023051E+00, 9.8377450015E-01],
	[4.7040000000E+04, 5.2710679275E+01, 5.3241969094E+00, 3.4205580950E+01, 4.2367812195E+00, 9.8378067931E-01],
	[4.7045000000E+04, 5.2720682523E+01, 5.3242481021E+00, 3.4217434714E+01, 4.2370600653E+00, 9.8378685561E-01],
	[4.7050000000E+04, 5.2730686605E+01, 5.3242992899E+00, 3.4229291322E+01, 4.2373388426E+00, 9.8379302906E-01],
	[4.7055000000E+04, 5.2740691522E+01, 5.3243504727E+00, 3.4241150775E+01, 4.2376175514E+00, 9.8379919965E-01],
	[4.7060000000E+04, 5.2750697274E+01, 5.3244016505E+00, 3.4253013073E+01, 4.2378961916E+00, 9.8380536739E-01],
	[4.7065000000E+04, 5.2760703862E+01, 5.3244528234E+00, 3.4264878215E+01, 4.2381747634E+00, 9.8381153229E-01],
	[4.7070000000E+04, 5.2770711284E+01, 5.3245039914E+00, 3.4276746203E+01, 4.2384532667E+00, 9.8381769433E-01],
	[4.7075000000E+04, 5.2780719541E+01, 5.3245551544E+00, 3.4288617037E+01, 4.2387317016E+00, 9.8382385353E-01],
	[4.7080000000E+04, 5.2790728632E+01, 5.3246063125E+00, 3.4300490718E+01, 4.2390100681E+00, 9.8383000988E-01],
	[4.7085000000E+04, 5.2800738559E+01, 5.3246574657E+00, 3.4312367245E+01, 4.2392883661E+00, 9.8383616338E-01],
	[4.7090000000E+04, 5.2810749320E+01, 5.3247086139E+00, 3.4324246619E+01, 4.2395665958E+00, 9.8384231405E-01],
	[4.7095000000E+04, 5.2820760917E+01, 5.3247597571E+00, 3.4336128840E+01, 4.2398447571E+00, 9.8384846187E-01],
	[4.7100000000E+04, 5.2830773348E+01, 5.3248108955E+00, 3.4348013909E+01, 4.2401228500E+00, 9.8385460685E-01],
	[4.7105000000E+04, 5.2840786614E+01, 5.3248620289E+00, 3.4359901827E+01, 4.2404008747E+00, 9.8386074900E-01],
	[4.7110000000E+04, 5.2850800714E+01, 5.3249131573E+00, 3.4371792592E+01, 4.2406788310E+00, 9.8386688831E-01],
	[4.7115000000E+04, 5.2860815650E+01, 5.3249642808E+00, 3.4383686207E+01, 4.2409567191E+00, 9.8387302478E-01],
	[4.7120000000E+04, 5.2870831420E+01, 5.3250153994E+00, 3.4395582671E+01, 4.2412345389E+00, 9.8387915842E-01],
	[4.7125000000E+04, 5.2880848024E+01, 5.3250665131E+00, 3.4407481985E+01, 4.2415122904E+00, 9.8388528923E-01],
	[4.7130000000E+04, 5.2890865464E+01, 5.3251176218E+00, 3.4419384149E+01, 4.2417899737E+00, 9.8389141720E-01],
	[4.7135000000E+04, 5.2900883738E+01, 5.3251687256E+00, 3.4431289163E+01, 4.2420675889E+00, 9.8389754235E-01],
	[4.7140000000E+04, 5.2910902846E+01, 5.3252198244E+00, 3.4443197028E+01, 4.2423451358E+00, 9.8390366467E-01],
	[4.7145000000E+04, 5.2920922790E+01, 5.3252709183E+00, 3.4455107744E+01, 4.2426226146E+00, 9.8390978416E-01],
	[4.7150000000E+04, 5.2930943568E+01, 5.3253220073E+00, 3.4467021312E+01, 4.2429000253E+00, 9.8391590083E-01],
	[4.7155000000E+04, 5.2940965180E+01, 5.3253730914E+00, 3.4478937731E+01, 4.2431773678E+00, 9.8392201468E-01],
	[4.7160000000E+04, 5.2950987627E+01, 5.3254241706E+00, 3.4490857004E+01, 4.2434546423E+00, 9.8392812570E-01],
	[4.7165000000E+04, 5.2961010909E+01, 5.3254752448E+00, 3.4502779128E+01, 4.2437318486E+00, 9.8393423390E-01],
	[4.7170000000E+04, 5.2971035025E+01, 5.3255263141E+00, 3.4514704106E+01, 4.2440089869E+00, 9.8394033929E-01],
	[4.7175000000E+04, 5.2981059975E+01, 5.3255773784E+00, 3.4526631937E+01, 4.2442860572E+00, 9.8394644185E-01],
	[4.7180000000E+04, 5.2991085760E+01, 5.3256284379E+00, 3.4538562622E+01, 4.2445630595E+00, 9.8395254160E-01],
	[4.7185000000E+04, 5.3001112380E+01, 5.3256794924E+00, 3.4550496162E+01, 4.2448399937E+00, 9.8395863854E-01],
	[4.7190000000E+04, 5.3011139834E+01, 5.3257305420E+00, 3.4562432556E+01, 4.2451168600E+00, 9.8396473266E-01],
	[4.7195000000E+04, 5.3021168122E+01, 5.3257815867E+00, 3.4574371805E+01, 4.2453936583E+00, 9.8397082398E-01],
	[4.7200000000E+04, 5.3031197245E+01, 5.3258326265E+00, 3.4586313909E+01, 4.2456703887E+00, 9.8397691248E-01],
	[4.7205000000E+04, 5.3041227202E+01, 5.3258836613E+00, 3.4598258869E+01, 4.2459470511E+00, 9.8398299817E-01],
	[4.7210000000E+04, 5.3051257994E+01, 5.3259346913E+00, 3.4610206685E+01, 4.2462236457E+00, 9.8398908106E-01],
	[4.7215000000E+04, 5.3061289620E+01, 5.3259857163E+00, 3.4622157358E+01, 4.2465001724E+00, 9.8399516114E-01],
	[4.7220000000E+04, 5.3071322080E+01, 5.3260367364E+00, 3.4634110887E+01, 4.2467766312E+00, 9.8400123842E-01],
	[4.7225000000E+04, 5.3081355375E+01, 5.3260877516E+00, 3.4646067274E+01, 4.2470530222E+00, 9.8400731290E-01],
	[4.7230000000E+04, 5.3091389503E+01, 5.3261387619E+00, 3.4658026518E+01, 4.2473293454E+00, 9.8401338457E-01],
	[4.7235000000E+04, 5.3101424466E+01, 5.3261897672E+00, 3.4669988621E+01, 4.2476056008E+00, 9.8401945345E-01],
	[4.7240000000E+04, 5.3111460264E+01, 5.3262407677E+00, 3.4681953581E+01, 4.2478817884E+00, 9.8402551952E-01],
	[4.7245000000E+04, 5.3121496896E+01, 5.3262917632E+00, 3.4693921401E+01, 4.2481579082E+00, 9.8403158280E-01],
	[4.7250000000E+04, 5.3131534361E+01, 5.3263427539E+00, 3.4705892080E+01, 4.2484339603E+00, 9.8403764329E-01],
	[4.7255000000E+04, 5.3141572661E+01, 5.3263937396E+00, 3.4717865618E+01, 4.2487099447E+00, 9.8404370098E-01],
	[4.7260000000E+04, 5.3151611796E+01, 5.3264447204E+00, 3.4729842016E+01, 4.2489858614E+00, 9.8404975588E-01],
	[4.7265000000E+04, 5.3161651764E+01, 5.3264956964E+00, 3.4741821274E+01, 4.2492617104E+00, 9.8405580799E-01],
	[4.7270000000E+04, 5.3171692567E+01, 5.3265466674E+00, 3.4753803394E+01, 4.2495374918E+00, 9.8406185731E-01],
	[4.7275000000E+04, 5.3181734203E+01, 5.3265976335E+00, 3.4765788374E+01, 4.2498132055E+00, 9.8406790384E-01],
	[4.7280000000E+04, 5.3191776674E+01, 5.3266485947E+00, 3.4777776215E+01, 4.2500888517E+00, 9.8407394759E-01],
	[4.7285000000E+04, 5.3201819979E+01, 5.3266995510E+00, 3.4789766919E+01, 4.2503644302E+00, 9.8407998855E-01],
	[4.7290000000E+04, 5.3211864118E+01, 5.3267505024E+00, 3.4801760484E+01, 4.2506399411E+00, 9.8408602673E-01],
	[4.7295000000E+04, 5.3221909091E+01, 5.3268014489E+00, 3.4813756912E+01, 4.2509153845E+00, 9.8409206213E-01],
	[4.7300000000E+04, 5.3231954898E+01, 5.3268523905E+00, 3.4825756203E+01, 4.2511907604E+00, 9.8409809474E-01],
	[4.7305000000E+04, 5.3242001539E+01, 5.3269033272E+00, 3.4837758357E+01, 4.2514660687E+00, 9.8410412458E-01],
	[4.7310000000E+04, 5.3252049014E+01, 5.3269542591E+00, 3.4849763376E+01, 4.2517413096E+00, 9.8411015164E-01],
	[4.7315000000E+04, 5.3262097322E+01, 5.3270051860E+00, 3.4861771258E+01, 4.2520164829E+00, 9.8411617593E-01],
	[4.7320000000E+04, 5.3272146465E+01, 5.3270561080E+00, 3.4873782004E+01, 4.2522915888E+00, 9.8412219744E-01],
	[4.7325000000E+04, 5.3282196442E+01, 5.3271070251E+00, 3.4885795616E+01, 4.2525666273E+00, 9.8412821618E-01],
	[4.7330000000E+04, 5.3292247253E+01, 5.3271579374E+00, 3.4897812092E+01, 4.2528415984E+00, 9.8413423214E-01],
	[4.7335000000E+04, 5.3302298898E+01, 5.3272088447E+00, 3.4909831434E+01, 4.2531165021E+00, 9.8414024534E-01],
	[4.7340000000E+04, 5.3312351376E+01, 5.3272597472E+00, 3.4921853643E+01, 4.2533913384E+00, 9.8414625577E-01],
	[4.7345000000E+04, 5.3322404688E+01, 5.3273106447E+00, 3.4933878717E+01, 4.2536661073E+00, 9.8415226343E-01],
	[4.7350000000E+04, 5.3332458835E+01, 5.3273615374E+00, 3.4945906658E+01, 4.2539408089E+00, 9.8415826832E-01],
	[4.7355000000E+04, 5.3342513815E+01, 5.3274124252E+00, 3.4957937467E+01, 4.2542154432E+00, 9.8416427045E-01],
	[4.7360000000E+04, 5.3352569629E+01, 5.3274633081E+00, 3.4969971143E+01, 4.2544900102E+00, 9.8417026982E-01],
	[4.7365000000E+04, 5.3362626276E+01, 5.3275141861E+00, 3.4982007686E+01, 4.2547645099E+00, 9.8417626643E-01],
	[4.7370000000E+04, 5.3372683758E+01, 5.3275650593E+00, 3.4994047098E+01, 4.2550389424E+00, 9.8418226028E-01],
	[4.7375000000E+04, 5.3382742073E+01, 5.3276159275E+00, 3.5006089379E+01, 4.2553133076E+00, 9.8418825137E-01],
	[4.7380000000E+04, 5.3392801222E+01, 5.3276667909E+00, 3.5018134529E+01, 4.2555876056E+00, 9.8419423970E-01],
	[4.7385000000E+04, 5.3402861204E+01, 5.3277176494E+00, 3.5030182548E+01, 4.2558618364E+00, 9.8420022528E-01],
	[4.7390000000E+04, 5.3412922020E+01, 5.3277685030E+00, 3.5042233437E+01, 4.2561360001E+00, 9.8420620810E-01],
	[4.7395000000E+04, 5.3422983670E+01, 5.3278193517E+00, 3.5054287195E+01, 4.2564100966E+00, 9.8421218817E-01],
	[4.7400000000E+04, 5.3433046154E+01, 5.3278701955E+00, 3.5066343825E+01, 4.2566841259E+00, 9.8421816549E-01],
	[4.7405000000E+04, 5.3443109471E+01, 5.3279210345E+00, 3.5078403325E+01, 4.2569580882E+00, 9.8422414006E-01],
	[4.7410000000E+04, 5.3453173622E+01, 5.3279718686E+00, 3.5090465697E+01, 4.2572319833E+00, 9.8423011189E-01],
	[4.7415000000E+04, 5.3463238606E+01, 5.3280226978E+00, 3.5102530940E+01, 4.2575058114E+00, 9.8423608096E-01],
	[4.7420000000E+04, 5.3473304424E+01, 5.3280735222E+00, 3.5114599056E+01, 4.2577795724E+00, 9.8424204729E-01],
	[4.7425000000E+04, 5.3483371076E+01, 5.3281243416E+00, 3.5126670043E+01, 4.2580532664E+00, 9.8424801088E-01],
	[4.7430000000E+04, 5.3493438561E+01, 5.3281751562E+00, 3.5138743904E+01, 4.2583268933E+00, 9.8425397173E-01],
	[4.7435000000E+04, 5.3503506879E+01, 5.3282259659E+00, 3.5150820638E+01, 4.2586004533E+00, 9.8425992983E-01],
	[4.7440000000E+04, 5.3513576032E+01, 5.3282767708E+00, 3.5162900245E+01, 4.2588739463E+00, 9.8426588520E-01],
	[4.7445000000E+04, 5.3523646017E+01, 5.3283275708E+00, 3.5174982726E+01, 4.2591473723E+00, 9.8427183783E-01],
	[4.7450000000E+04, 5.3533716836E+01, 5.3283783659E+00, 3.5187068082E+01, 4.2594207314E+00, 9.8427778772E-01],
	[4.7455000000E+04, 5.3543788489E+01, 5.3284291561E+00, 3.5199156312E+01, 4.2596940236E+00, 9.8428373488E-01],
	[4.7460000000E+04, 5.3553860975E+01, 5.3284799415E+00, 3.5211247418E+01, 4.2599672489E+00, 9.8428967930E-01],
	[4.7465000000E+04, 5.3563934294E+01, 5.3285307220E+00, 3.5223341399E+01, 4.2602404073E+00, 9.8429562099E-01],
	[4.7470000000E+04, 5.3574008447E+01, 5.3285814977E+00, 3.5235438255E+01, 4.2605134988E+00, 9.8430155995E-01],
	[4.7475000000E+04, 5.3584083433E+01, 5.3286322684E+00, 3.5247537988E+01, 4.2607865236E+00, 9.8430749619E-01],
	[4.7480000000E+04, 5.3594159252E+01, 5.3286830344E+00, 3.5259640598E+01, 4.2610594815E+00, 9.8431342969E-01],
	[4.7485000000E+04, 5.3604235905E+01, 5.3287337954E+00, 3.5271746084E+01, 4.2613323726E+00, 9.8431936047E-01],
	[4.7490000000E+04, 5.3614313391E+01, 5.3287845516E+00, 3.5283854448E+01, 4.2616051969E+00, 9.8432528853E-01],
	[4.7495000000E+04, 5.3624391710E+01, 5.3288353029E+00, 3.5295965689E+01, 4.2618779545E+00, 9.8433121386E-01],
	[4.7500000000E+04, 5.3634470863E+01, 5.3288860494E+00, 3.5308079809E+01, 4.2621506453E+00, 9.8433713647E-01],
	[4.7505000000E+04, 5.3644550849E+01, 5.3289367910E+00, 3.5320196807E+01, 4.2624232694E+00, 9.8434305635E-01],
	[4.7510000000E+04, 5.3654631668E+01, 5.3289875278E+00, 3.5332316684E+01, 4.2626958268E+00, 9.8434897353E-01],
	[4.7515000000E+04, 5.3664713320E+01, 5.3290382597E+00, 3.5344439441E+01, 4.2629683176E+00, 9.8435488798E-01],
	[4.7520000000E+04, 5.3674795806E+01, 5.3290889867E+00, 3.5356565077E+01, 4.2632407417E+00, 9.8436079971E-01],
	[4.7525000000E+04, 5.3684879124E+01, 5.3291397089E+00, 3.5368693593E+01, 4.2635130991E+00, 9.8436670874E-01],
	[4.7530000000E+04, 5.3694981813E+01, 5.3291920431E+00, 3.5380824989E+01, 4.2637865418E+00, 9.8437261505E-01],
	[4.7535000000E+04, 5.3705085811E+01, 5.3292444133E+00, 3.5392959266E+01, 4.2640599473E+00, 9.8437851864E-01],
	[4.7540000000E+04, 5.3715190646E+01, 5.3292967785E+00, 3.5405096424E+01, 4.2643332862E+00, 9.8438441953E-01],
	[4.7545000000E+04, 5.3725296320E+01, 5.3293491387E+00, 3.5417236464E+01, 4.2646065587E+00, 9.8439031771E-01],
	[4.7550000000E+04, 5.3735402833E+01, 5.3294014939E+00, 3.5429379386E+01, 4.2648797648E+00, 9.8439621318E-01],
	[4.7555000000E+04, 5.3745510183E+01, 5.3294538442E+00, 3.5441525190E+01, 4.2651529045E+00, 9.8440210595E-01],
	[4.7560000000E+04, 5.3755618372E+01, 5.3295061894E+00, 3.5453673877E+01, 4.2654259778E+00, 9.8440799601E-01],
	[4.7565000000E+04, 5.3765727398E+01, 5.3295585296E+00, 3.5465825446E+01, 4.2656989847E+00, 9.8441388337E-01],
	[4.7570000000E+04, 5.3775837263E+01, 5.3296108649E+00, 3.5477979899E+01, 4.2659719253E+00, 9.8441976802E-01],
	[4.7575000000E+04, 5.3785947966E+01, 5.3296631952E+00, 3.5490137236E+01, 4.2662447996E+00, 9.8442564998E-01],
	[4.7580000000E+04, 5.3796059507E+01, 5.3297155205E+00, 3.5502297458E+01, 4.2665176075E+00, 9.8443152924E-01],
	[4.7585000000E+04, 5.3806171887E+01, 5.3297678408E+00, 3.5514460563E+01, 4.2667903492E+00, 9.8443740580E-01],
	[4.7590000000E+04, 5.3816285104E+01, 5.3298201561E+00, 3.5526626554E+01, 4.2670630246E+00, 9.8444327967E-01],
	[4.7595000000E+04, 5.3826399159E+01, 5.3298724664E+00, 3.5538795430E+01, 4.2673356337E+00, 9.8444915084E-01],
	[4.7600000000E+04, 5.3836514053E+01, 5.3299247718E+00, 3.5550967192E+01, 4.2676081766E+00, 9.8445501931E-01],
	[4.7605000000E+04, 5.3846629784E+01, 5.3299770721E+00, 3.5563141840E+01, 4.2678806533E+00, 9.8446088510E-01],
	[4.7610000000E+04, 5.3856746354E+01, 5.3300293675E+00, 3.5575319374E+01, 4.2681530638E+00, 9.8446674820E-01],
	[4.7615000000E+04, 5.3866863761E+01, 5.3300816580E+00, 3.5587499795E+01, 4.2684254082E+00, 9.8447260861E-01],
	[4.7620000000E+04, 5.3876982007E+01, 5.3301339434E+00, 3.5599683104E+01, 4.2686976863E+00, 9.8447846633E-01],
	[4.7625000000E+04, 5.3887101090E+01, 5.3301862239E+00, 3.5611869300E+01, 4.2689698984E+00, 9.8448432136E-01],
	[4.7630000000E+04, 5.3897221012E+01, 5.3302384993E+00, 3.5624058384E+01, 4.2692420443E+00, 9.8449017371E-01],
	[4.7635000000E+04, 5.3907341771E+01, 5.3302907698E+00, 3.5636250356E+01, 4.2695141242E+00, 9.8449602338E-01],
	[4.7640000000E+04, 5.3917463368E+01, 5.3303430354E+00, 3.5648445217E+01, 4.2697861380E+00, 9.8450187037E-01],
	[4.7645000000E+04, 5.3927585803E+01, 5.3303952959E+00, 3.5660642967E+01, 4.2700580857E+00, 9.8450771468E-01],
	[4.7650000000E+04, 5.3937709076E+01, 5.3304475515E+00, 3.5672843607E+01, 4.2703299674E+00, 9.8451355630E-01],
	[4.7655000000E+04, 5.3947833187E+01, 5.3304998022E+00, 3.5685047137E+01, 4.2706017831E+00, 9.8451939526E-01],
	[4.7660000000E+04, 5.3957958135E+01, 5.3305520478E+00, 3.5697253557E+01, 4.2708735327E+00, 9.8452523153E-01],
	[4.7665000000E+04, 5.3968083922E+01, 5.3306042885E+00, 3.5709462867E+01, 4.2711452165E+00, 9.8453106513E-01],
	[4.7670000000E+04, 5.3978210546E+01, 5.3306565242E+00, 3.5721675069E+01, 4.2714168342E+00, 9.8453689606E-01],
	[4.7675000000E+04, 5.3988338008E+01, 5.3307087549E+00, 3.5733890162E+01, 4.2716883860E+00, 9.8454272432E-01],
	[4.7680000000E+04, 5.3998466308E+01, 5.3307609807E+00, 3.5746108147E+01, 4.2719598719E+00, 9.8454854991E-01],
	[4.7685000000E+04, 5.4008595445E+01, 5.3308132015E+00, 3.5758329023E+01, 4.2722312919E+00, 9.8455437283E-01],
	[4.7690000000E+04, 5.4018725420E+01, 5.3308654174E+00, 3.5770552793E+01, 4.2725026461E+00, 9.8456019308E-01],
	[4.7695000000E+04, 5.4028856233E+01, 5.3309176283E+00, 3.5782779455E+01, 4.2727739343E+00, 9.8456601066E-01],
	[4.7700000000E+04, 5.4038987883E+01, 5.3309698342E+00, 3.5795009011E+01, 4.2730451568E+00, 9.8457182559E-01],
	[4.7705000000E+04, 5.4049120372E+01, 5.3310220352E+00, 3.5807241461E+01, 4.2733163134E+00, 9.8457763785E-01],
	[4.7710000000E+04, 5.4059253697E+01, 5.3310742312E+00, 3.5819476804E+01, 4.2735874042E+00, 9.8458344744E-01],
	[4.7715000000E+04, 5.4069387861E+01, 5.3311264222E+00, 3.5831715042E+01, 4.2738584293E+00, 9.8458925438E-01],
	[4.7720000000E+04, 5.4079522862E+01, 5.3311786083E+00, 3.5843956175E+01, 4.2741293885E+00, 9.8459505866E-01],
	[4.7725000000E+04, 5.4089658700E+01, 5.3312307895E+00, 3.5856200203E+01, 4.2744002821E+00, 9.8460086028E-01],
	[4.7730000000E+04, 5.4099795376E+01, 5.3312829656E+00, 3.5868447126E+01, 4.2746711099E+00, 9.8460665925E-01],
	[4.7735000000E+04, 5.4109932890E+01, 5.3313351369E+00, 3.5880696946E+01, 4.2749418720E+00, 9.8461245556E-01],
	[4.7740000000E+04, 5.4120071241E+01, 5.3313873031E+00, 3.5892949662E+01, 4.2752125685E+00, 9.8461824922E-01],
	[4.7745000000E+04, 5.4130210430E+01, 5.3314394644E+00, 3.5905205274E+01, 4.2754831992E+00, 9.8462404023E-01],
	[4.7750000000E+04, 5.4140350456E+01, 5.3314916208E+00, 3.5917463784E+01, 4.2757537644E+00, 9.8462982859E-01],
	[4.7755000000E+04, 5.4150491320E+01, 5.3315437722E+00, 3.5929725191E+01, 4.2760242639E+00, 9.8463561430E-01],
	[4.7760000000E+04, 5.4160633021E+01, 5.3315959187E+00, 3.5941989497E+01, 4.2762946978E+00, 9.8464139736E-01],
	[4.7765000000E+04, 5.4170775560E+01, 5.3316480602E+00, 3.5954256700E+01, 4.2765650661E+00, 9.8464717778E-01],
	[4.7770000000E+04, 5.4180918936E+01, 5.3317001968E+00, 3.5966526802E+01, 4.2768353689E+00, 9.8465295555E-01],
	[4.7775000000E+04, 5.4191063149E+01, 5.3317523284E+00, 3.5978799803E+01, 4.2771056061E+00, 9.8465873068E-01],
	[4.7780000000E+04, 5.4201208200E+01, 5.3318044551E+00, 3.5991075703E+01, 4.2773757778E+00, 9.8466450317E-01],
	[4.7785000000E+04, 5.4211354088E+01, 5.3318565768E+00, 3.6003354503E+01, 4.2776458840E+00, 9.8467027301E-01],
	[4.7790000000E+04, 5.4221500813E+01, 5.3319086936E+00, 3.6015636204E+01, 4.2779159247E+00, 9.8467604022E-01],
	[4.7795000000E+04, 5.4231648376E+01, 5.3319608054E+00, 3.6027920805E+01, 4.2781858999E+00, 9.8468180479E-01],
	[4.7800000000E+04, 5.4241796776E+01, 5.3320129123E+00, 3.6040208306E+01, 4.2784558097E+00, 9.8468756673E-01],
	[4.7805000000E+04, 5.4251946014E+01, 5.3320650143E+00, 3.6052498709E+01, 4.2787256540E+00, 9.8469332603E-01],
	[4.7810000000E+04, 5.4262096088E+01, 5.3321171113E+00, 3.6064792014E+01, 4.2789954330E+00, 9.8469908270E-01],
	[4.7815000000E+04, 5.4272247000E+01, 5.3321692034E+00, 3.6077088221E+01, 4.2792651466E+00, 9.8470483674E-01],
	[4.7820000000E+04, 5.4282398749E+01, 5.3322212905E+00, 3.6089387330E+01, 4.2795347947E+00, 9.8471058814E-01],
	[4.7825000000E+04, 5.4292551336E+01, 5.3322733727E+00, 3.6101689342E+01, 4.2798043776E+00, 9.8471633692E-01],
	[4.7830000000E+04, 5.4302704759E+01, 5.3323254500E+00, 3.6113994257E+01, 4.2800738951E+00, 9.8472208307E-01],
	[4.7835000000E+04, 5.4312859020E+01, 5.3323775223E+00, 3.6126302076E+01, 4.2803433473E+00, 9.8472782660E-01],
	[4.7840000000E+04, 5.4323014118E+01, 5.3324295897E+00, 3.6138612799E+01, 4.2806127342E+00, 9.8473356750E-01],
	[4.7845000000E+04, 5.4333170053E+01, 5.3324816522E+00, 3.6150926426E+01, 4.2808820558E+00, 9.8473930577E-01],
	[4.7850000000E+04, 5.4343326825E+01, 5.3325337097E+00, 3.6163242958E+01, 4.2811513122E+00, 9.8474504143E-01],
	[4.7855000000E+04, 5.4353484434E+01, 5.3325857623E+00, 3.6175562394E+01, 4.2814205034E+00, 9.8475077446E-01],
	[4.7860000000E+04, 5.4363642880E+01, 5.3326378100E+00, 3.6187884737E+01, 4.2816896293E+00, 9.8475650488E-01],
	[4.7865000000E+04, 5.4373802164E+01, 5.3326898527E+00, 3.6200209985E+01, 4.2819586900E+00, 9.8476223268E-01],
	[4.7870000000E+04, 5.4383962284E+01, 5.3327418905E+00, 3.6212538139E+01, 4.2822276856E+00, 9.8476795786E-01],
	[4.7875000000E+04, 5.4394123242E+01, 5.3327939234E+00, 3.6224869200E+01, 4.2824966160E+00, 9.8477368043E-01],
	[4.7880000000E+04, 5.4404285036E+01, 5.3328459514E+00, 3.6237203169E+01, 4.2827654813E+00, 9.8477940038E-01],
	[4.7885000000E+04, 5.4414447667E+01, 5.3328979744E+00, 3.6249540044E+01, 4.2830342814E+00, 9.8478511772E-01],
	[4.7890000000E+04, 5.4424611136E+01, 5.3329499925E+00, 3.6261879827E+01, 4.2833030165E+00, 9.8479083246E-01],
	[4.7895000000E+04, 5.4434775441E+01, 5.3330020057E+00, 3.6274222518E+01, 4.2835716865E+00, 9.8479654458E-01],
	[4.7900000000E+04, 5.4444940583E+01, 5.3330540140E+00, 3.6286568118E+01, 4.2838402914E+00, 9.8480225409E-01],
	[4.7905000000E+04, 5.4455106563E+01, 5.3331060173E+00, 3.6298916627E+01, 4.2841088313E+00, 9.8480796100E-01],
	[4.7910000000E+04, 5.4465273379E+01, 5.3331580157E+00, 3.6311268045E+01, 4.2843773061E+00, 9.8481366531E-01],
	[4.7915000000E+04, 5.4475441032E+01, 5.3332100092E+00, 3.6323622373E+01, 4.2846457160E+00, 9.8481936701E-01],
	[4.7920000000E+04, 5.4485609522E+01, 5.3332619978E+00, 3.6335979610E+01, 4.2849140609E+00, 9.8482506610E-01],
	[4.7925000000E+04, 5.4495778848E+01, 5.3333139815E+00, 3.6348339759E+01, 4.2851823408E+00, 9.8483076260E-01],
	[4.7930000000E+04, 5.4505949012E+01, 5.3333659602E+00, 3.6360702818E+01, 4.2854505558E+00, 9.8483645650E-01],
	[4.7935000000E+04, 5.4516120012E+01, 5.3334179341E+00, 3.6373068788E+01, 4.2857187058E+00, 9.8484214780E-01],
	[4.7940000000E+04, 5.4526291849E+01, 5.3334699030E+00, 3.6385437669E+01, 4.2859867910E+00, 9.8484783650E-01],
	[4.7945000000E+04, 5.4536464523E+01, 5.3335218670E+00, 3.6397809463E+01, 4.2862548112E+00, 9.8485352261E-01],
	[4.7950000000E+04, 5.4546638034E+01, 5.3335738261E+00, 3.6410184169E+01, 4.2865227666E+00, 9.8485920613E-01],
	[4.7955000000E+04, 5.4556812381E+01, 5.3336257803E+00, 3.6422561788E+01, 4.2867906572E+00, 9.8486488705E-01],
	[4.7960000000E+04, 5.4566987565E+01, 5.3336777295E+00, 3.6434942319E+01, 4.2870584829E+00, 9.8487056538E-01],
	[4.7965000000E+04, 5.4577163586E+01, 5.3337296739E+00, 3.6447325764E+01, 4.2873262438E+00, 9.8487624112E-01],
	[4.7970000000E+04, 5.4587340443E+01, 5.3337816133E+00, 3.6459712123E+01, 4.2875939399E+00, 9.8488191427E-01],
	[4.7975000000E+04, 5.4597518137E+01, 5.3338335479E+00, 3.6472101397E+01, 4.2878615713E+00, 9.8488758484E-01],
	[4.7980000000E+04, 5.4607696668E+01, 5.3338854775E+00, 3.6484493585E+01, 4.2881291379E+00, 9.8489325282E-01],
	[4.7985000000E+04, 5.4617876035E+01, 5.3339374023E+00, 3.6496888687E+01, 4.2883966398E+00, 9.8489891822E-01],
	[4.7990000000E+04, 5.4628056239E+01, 5.3339893221E+00, 3.6509286706E+01, 4.2886640769E+00, 9.8490458104E-01],
	[4.7995000000E+04, 5.4638237280E+01, 5.3340412370E+00, 3.6521687640E+01, 4.2889314494E+00, 9.8491024127E-01],
	[4.8000000000E+04, 5.4648419157E+01, 5.3340931470E+00, 3.6534091490E+01, 4.2891987572E+00, 9.8491589892E-01],
	[4.8005000000E+04, 5.4658601871E+01, 5.3341450521E+00, 3.6546498256E+01, 4.2894660003E+00, 9.8492155400E-01],
	[4.8010000000E+04, 5.4668785421E+01, 5.3341969524E+00, 3.6558907940E+01, 4.2897331788E+00, 9.8492720650E-01],
	[4.8015000000E+04, 5.4678969807E+01, 5.3342488477E+00, 3.6571320541E+01, 4.2900002927E+00, 9.8493285642E-01],
	[4.8020000000E+04, 5.4689155031E+01, 5.3343007381E+00, 3.6583736059E+01, 4.2902673420E+00, 9.8493850377E-01],
	[4.8025000000E+04, 5.4699341090E+01, 5.3343526236E+00, 3.6596154495E+01, 4.2905343268E+00, 9.8494414854E-01],
	[4.8030000000E+04, 5.4709527986E+01, 5.3344045042E+00, 3.6608575850E+01, 4.2908012469E+00, 9.8494979075E-01],
	[4.8035000000E+04, 5.4719715719E+01, 5.3344563800E+00, 3.6621000124E+01, 4.2910681026E+00, 9.8495543038E-01],
	[4.8040000000E+04, 5.4729904288E+01, 5.3345082508E+00, 3.6633427317E+01, 4.2913348937E+00, 9.8496106745E-01],
	[4.8045000000E+04, 5.4740093693E+01, 5.3345601167E+00, 3.6645857429E+01, 4.2916016203E+00, 9.8496670194E-01],
	[4.8050000000E+04, 5.4750283935E+01, 5.3346119778E+00, 3.6658290461E+01, 4.2918682824E+00, 9.8497233388E-01],
	[4.8055000000E+04, 5.4760475013E+01, 5.3346638339E+00, 3.6670726414E+01, 4.2921348801E+00, 9.8497796324E-01],
	[4.8060000000E+04, 5.4770666927E+01, 5.3347156852E+00, 3.6683165287E+01, 4.2924014133E+00, 9.8498359005E-01],
	[4.8065000000E+04, 5.4780859678E+01, 5.3347675316E+00, 3.6695607082E+01, 4.2926678821E+00, 9.8498921429E-01],
	[4.8070000000E+04, 5.4791053265E+01, 5.3348193731E+00, 3.6708051798E+01, 4.2929342865E+00, 9.8499483597E-01],
	[4.8075000000E+04, 5.4801247689E+01, 5.3348712096E+00, 3.6720499435E+01, 4.2932006265E+00, 9.8500045509E-01],
	[4.8080000000E+04, 5.4811442948E+01, 5.3349230414E+00, 3.6732949995E+01, 4.2934669022E+00, 9.8500607166E-01],
	[4.8085000000E+04, 5.4821639044E+01, 5.3349748682E+00, 3.6745403478E+01, 4.2937331135E+00, 9.8501168567E-01],
	[4.8090000000E+04, 5.4831835976E+01, 5.3350266901E+00, 3.6757859883E+01, 4.2939992604E+00, 9.8501729712E-01],
	[4.8095000000E+04, 5.4842033745E+01, 5.3350785072E+00, 3.6770319212E+01, 4.2942653431E+00, 9.8502290602E-01],
	[4.8100000000E+04, 5.4852232349E+01, 5.3351303193E+00, 3.6782781465E+01, 4.2945313615E+00, 9.8502851237E-01],
	[4.8105000000E+04, 5.4862431790E+01, 5.3351821266E+00, 3.6795246641E+01, 4.2947973156E+00, 9.8503411616E-01],
	[4.8110000000E+04, 5.4872632067E+01, 5.3352339290E+00, 3.6807714743E+01, 4.2950632055E+00, 9.8503971741E-01],
	[4.8115000000E+04, 5.4882833180E+01, 5.3352857265E+00, 3.6820185769E+01, 4.2953290311E+00, 9.8504531611E-01],
	[4.8120000000E+04, 5.4893035129E+01, 5.3353375192E+00, 3.6832659720E+01, 4.2955947925E+00, 9.8505091226E-01],
	[4.8125000000E+04, 5.4903237914E+01, 5.3353893069E+00, 3.6845136597E+01, 4.2958604897E+00, 9.8505650587E-01],
	[4.8130000000E+04, 5.4913441536E+01, 5.3354410898E+00, 3.6857616400E+01, 4.2961261228E+00, 9.8506209693E-01],
	[4.8135000000E+04, 5.4923645993E+01, 5.3354928678E+00, 3.6870099129E+01, 4.2963916917E+00, 9.8506768545E-01],
	[4.8140000000E+04, 5.4933851287E+01, 5.3355446410E+00, 3.6882584786E+01, 4.2966571964E+00, 9.8507327143E-01],
	[4.8145000000E+04, 5.4944057416E+01, 5.3355964092E+00, 3.6895073369E+01, 4.2969226371E+00, 9.8507885487E-01],
	[4.8150000000E+04, 5.4954264382E+01, 5.3356481726E+00, 3.6907564880E+01, 4.2971880136E+00, 9.8508443577E-01],
	[4.8155000000E+04, 5.4964472183E+01, 5.3356999311E+00, 3.6920059319E+01, 4.2974533261E+00, 9.8509001414E-01],
	[4.8160000000E+04, 5.4974680821E+01, 5.3357516848E+00, 3.6932556686E+01, 4.2977185745E+00, 9.8509558996E-01],
	[4.8165000000E+04, 5.4984890294E+01, 5.3358034335E+00, 3.6945056982E+01, 4.2979837589E+00, 9.8510116326E-01],
	[4.8170000000E+04, 5.4995100603E+01, 5.3358551774E+00, 3.6957560207E+01, 4.2982488792E+00, 9.8510673402E-01],
	[4.8175000000E+04, 5.5005311749E+01, 5.3359069165E+00, 3.6970066361E+01, 4.2985139356E+00, 9.8511230225E-01],
	[4.8180000000E+04, 5.5015523730E+01, 5.3359586506E+00, 3.6982575446E+01, 4.2987789280E+00, 9.8511786795E-01],
	[4.8185000000E+04, 5.5025736547E+01, 5.3360103799E+00, 3.6995087460E+01, 4.2990438564E+00, 9.8512343112E-01],
	[4.8190000000E+04, 5.5035950200E+01, 5.3360621044E+00, 3.7007602405E+01, 4.2993087208E+00, 9.8512899176E-01],
	[4.8195000000E+04, 5.5046164689E+01, 5.3361138239E+00, 3.7020120281E+01, 4.2995735214E+00, 9.8513454987E-01],
	[4.8200000000E+04, 5.5056380013E+01, 5.3361655386E+00, 3.7032641089E+01, 4.2998382580E+00, 9.8514010547E-01],
	[4.8205000000E+04, 5.5066596174E+01, 5.3362172485E+00, 3.7045164828E+01, 4.3001029307E+00, 9.8514565853E-01],
	[4.8210000000E+04, 5.5076813170E+01, 5.3362689534E+00, 3.7057691499E+01, 4.3003675396E+00, 9.8515120908E-01],
	[4.8215000000E+04, 5.5087031002E+01, 5.3363206536E+00, 3.7070221103E+01, 4.3006320846E+00, 9.8515675710E-01],
	[4.8220000000E+04, 5.5097249670E+01, 5.3363723488E+00, 3.7082753639E+01, 4.3008965658E+00, 9.8516230261E-01],
	[4.8225000000E+04, 5.5107469173E+01, 5.3364240392E+00, 3.7095289109E+01, 4.3011609832E+00, 9.8516784560E-01],
	[4.8230000000E+04, 5.5117689513E+01, 5.3364757247E+00, 3.7107827513E+01, 4.3014253368E+00, 9.8517338607E-01],
	[4.8235000000E+04, 5.5127910688E+01, 5.3365274054E+00, 3.7120368850E+01, 4.3016896266E+00, 9.8517892402E-01],
	[4.8240000000E+04, 5.5138132698E+01, 5.3365790812E+00, 3.7132913122E+01, 4.3019538527E+00, 9.8518445946E-01],
	[4.8245000000E+04, 5.5148355545E+01, 5.3366307522E+00, 3.7145460329E+01, 4.3022180150E+00, 9.8518999239E-01],
	[4.8250000000E+04, 5.5158579227E+01, 5.3366824183E+00, 3.7158010471E+01, 4.3024821136E+00, 9.8519552281E-01],
	[4.8255000000E+04, 5.5168803744E+01, 5.3367340796E+00, 3.7170563549E+01, 4.3027461485E+00, 9.8520105072E-01],
	[4.8260000000E+04, 5.5179029097E+01, 5.3367857360E+00, 3.7183119562E+01, 4.3030101198E+00, 9.8520657612E-01],
	[4.8265000000E+04, 5.5189255286E+01, 5.3368373875E+00, 3.7195678512E+01, 4.3032740273E+00, 9.8521209901E-01],
	[4.8270000000E+04, 5.5199482310E+01, 5.3368890342E+00, 3.7208240398E+01, 4.3035378713E+00, 9.8521761939E-01],
	[4.8275000000E+04, 5.5209710170E+01, 5.3369406761E+00, 3.7220805222E+01, 4.3038016516E+00, 9.8522313728E-01],
	[4.8280000000E+04, 5.5219938866E+01, 5.3369923131E+00, 3.7233372983E+01, 4.3040653683E+00, 9.8522865265E-01],
	[4.8285000000E+04, 5.5230168397E+01, 5.3370439452E+00, 3.7245943682E+01, 4.3043290214E+00, 9.8523416553E-01],
	[4.8290000000E+04, 5.5240398763E+01, 5.3370955726E+00, 3.7258517319E+01, 4.3045926110E+00, 9.8523967591E-01],
	[4.8295000000E+04, 5.5250648218E+01, 5.3371487493E+00, 3.7271093894E+01, 4.3048572590E+00, 9.8524518378E-01],
	[4.8300000000E+04, 5.5260899327E+01, 5.3372019904E+00, 3.7283673409E+01, 4.3051218936E+00, 9.8525068916E-01],
	[4.8305000000E+04, 5.5271151277E+01, 5.3372552265E+00, 3.7296255863E+01, 4.3053864649E+00, 9.8525619204E-01],
	[4.8310000000E+04, 5.5281404068E+01, 5.3373084576E+00, 3.7308841257E+01, 4.3056509727E+00, 9.8526169243E-01],
	[4.8315000000E+04, 5.5291657699E+01, 5.3373616837E+00, 3.7321429590E+01, 4.3059154171E+00, 9.8526719033E-01],
	[4.8320000000E+04, 5.5301912170E+01, 5.3374149049E+00, 3.7334020865E+01, 4.3061797983E+00, 9.8527268573E-01],
	[4.8325000000E+04, 5.5312167482E+01, 5.3374681211E+00, 3.7346615080E+01, 4.3064441160E+00, 9.8527817863E-01],
	[4.8330000000E+04, 5.5322423634E+01, 5.3375213323E+00, 3.7359212236E+01, 4.3067083705E+00, 9.8528366905E-01],
	[4.8335000000E+04, 5.5332680627E+01, 5.3375745385E+00, 3.7371812335E+01, 4.3069725617E+00, 9.8528915698E-01],
	[4.8340000000E+04, 5.5342938460E+01, 5.3376277398E+00, 3.7384415375E+01, 4.3072366896E+00, 9.8529464242E-01],
	[4.8345000000E+04, 5.5353197133E+01, 5.3376809360E+00, 3.7397021357E+01, 4.3075007543E+00, 9.8530012538E-01],
	[4.8350000000E+04, 5.5363456647E+01, 5.3377341274E+00, 3.7409630283E+01, 4.3077647557E+00, 9.8530560585E-01],
	[4.8355000000E+04, 5.5373717002E+01, 5.3377873137E+00, 3.7422242151E+01, 4.3080286939E+00, 9.8531108383E-01],
	[4.8360000000E+04, 5.5383978196E+01, 5.3378404951E+00, 3.7434856963E+01, 4.3082925689E+00, 9.8531655933E-01],
	[4.8365000000E+04, 5.5394240231E+01, 5.3378936715E+00, 3.7447474720E+01, 4.3085563807E+00, 9.8532203235E-01],
	[4.8370000000E+04, 5.5404503106E+01, 5.3379468429E+00, 3.7460095420E+01, 4.3088201294E+00, 9.8532750289E-01],
	[4.8375000000E+04, 5.5414766822E+01, 5.3380000094E+00, 3.7472719065E+01, 4.3090838149E+00, 9.8533297095E-01],
	[4.8380000000E+04, 5.5425031378E+01, 5.3380531709E+00, 3.7485345655E+01, 4.3093474373E+00, 9.8533843653E-01],
	[4.8385000000E+04, 5.5435296774E+01, 5.3381063274E+00, 3.7497975191E+01, 4.3096109966E+00, 9.8534389964E-01],
	[4.8390000000E+04, 5.5445563010E+01, 5.3381594790E+00, 3.7510607672E+01, 4.3098744929E+00, 9.8534936027E-01],
	[4.8395000000E+04, 5.5455830087E+01, 5.3382126256E+00, 3.7523243100E+01, 4.3101379260E+00, 9.8535481842E-01],
	[4.8400000000E+04, 5.5466098003E+01, 5.3382657673E+00, 3.7535881474E+01, 4.3104012961E+00, 9.8536027411E-01],
	[4.8405000000E+04, 5.5476366760E+01, 5.3383189040E+00, 3.7548522795E+01, 4.3106646032E+00, 9.8536572732E-01],
	[4.8410000000E+04, 5.5486636357E+01, 5.3383720357E+00, 3.7561167064E+01, 4.3109278473E+00, 9.8537117806E-01],
	[4.8415000000E+04, 5.5496906794E+01, 5.3384251625E+00, 3.7573814281E+01, 4.3111910283E+00, 9.8537662633E-01],
	[4.8420000000E+04, 5.5507178072E+01, 5.3384782843E+00, 3.7586464445E+01, 4.3114541464E+00, 9.8538207213E-01],
	[4.8425000000E+04, 5.5517450189E+01, 5.3385314012E+00, 3.7599117558E+01, 4.3117172016E+00, 9.8538751547E-01],
	[4.8430000000E+04, 5.5527723147E+01, 5.3385845131E+00, 3.7611773620E+01, 4.3119801938E+00, 9.8539295634E-01],
	[4.8435000000E+04, 5.5537996944E+01, 5.3386376200E+00, 3.7624432631E+01, 4.3122431231E+00, 9.8539839474E-01],
	[4.8440000000E+04, 5.5548271582E+01, 5.3386907220E+00, 3.7637094592E+01, 4.3125059895E+00, 9.8540383069E-01],
	[4.8445000000E+04, 5.5558547060E+01, 5.3387438191E+00, 3.7649759503E+01, 4.3127687930E+00, 9.8540926417E-01],
	[4.8450000000E+04, 5.5568823377E+01, 5.3387969112E+00, 3.7662427364E+01, 4.3130315337E+00, 9.8541469519E-01],
	[4.8455000000E+04, 5.5579100535E+01, 5.3388499983E+00, 3.7675098177E+01, 4.3132942115E+00, 9.8542012375E-01],
	[4.8460000000E+04, 5.5589378533E+01, 5.3389030805E+00, 3.7687771940E+01, 4.3135568265E+00, 9.8542554986E-01],
	[4.8465000000E+04, 5.5599657370E+01, 5.3389561578E+00, 3.7700448655E+01, 4.3138193788E+00, 9.8543097350E-01],
	[4.8470000000E+04, 5.5609937048E+01, 5.3390092301E+00, 3.7713128322E+01, 4.3140818682E+00, 9.8543639469E-01],
	[4.8475000000E+04, 5.5620217565E+01, 5.3390622974E+00, 3.7725810941E+01, 4.3143442948E+00, 9.8544181343E-01],
	[4.8480000000E+04, 5.5630498923E+01, 5.3391153598E+00, 3.7738496513E+01, 4.3146066587E+00, 9.8544722971E-01],
	[4.8485000000E+04, 5.5640781120E+01, 5.3391684173E+00, 3.7751185038E+01, 4.3148689599E+00, 9.8545264355E-01],
	[4.8490000000E+04, 5.5651064157E+01, 5.3392214698E+00, 3.7763876516E+01, 4.3151311984E+00, 9.8545805493E-01],
	[4.8495000000E+04, 5.5661348034E+01, 5.3392745173E+00, 3.7776570948E+01, 4.3153933741E+00, 9.8546346386E-01],
	[4.8500000000E+04, 5.5671632751E+01, 5.3393275600E+00, 3.7789268335E+01, 4.3156554872E+00, 9.8546887034E-01],
	[4.8505000000E+04, 5.5681918308E+01, 5.3393805977E+00, 3.7801968676E+01, 4.3159175377E+00, 9.8547427438E-01],
	[4.8510000000E+04, 5.5692204704E+01, 5.3394336304E+00, 3.7814671972E+01, 4.3161795255E+00, 9.8547967597E-01],
	[4.8515000000E+04, 5.5702491941E+01, 5.3394866582E+00, 3.7827378224E+01, 4.3164414507E+00, 9.8548507512E-01],
	[4.8520000000E+04, 5.5712780017E+01, 5.3395396811E+00, 3.7840087431E+01, 4.3167033133E+00, 9.8549047182E-01],
	[4.8525000000E+04, 5.5723068932E+01, 5.3395926990E+00, 3.7852799594E+01, 4.3169651133E+00, 9.8549586608E-01],
	[4.8530000000E+04, 5.5733358688E+01, 5.3396457120E+00, 3.7865514714E+01, 4.3172268508E+00, 9.8550125790E-01],
	[4.8535000000E+04, 5.5743649283E+01, 5.3396987201E+00, 3.7878232791E+01, 4.3174885257E+00, 9.8550664728E-01],
	[4.8540000000E+04, 5.5753940718E+01, 5.3397517232E+00, 3.7890953825E+01, 4.3177501381E+00, 9.8551203422E-01],
	[4.8545000000E+04, 5.5764232993E+01, 5.3398047214E+00, 3.7903677817E+01, 4.3180116880E+00, 9.8551741873E-01],
	[4.8550000000E+04, 5.5774526107E+01, 5.3398577147E+00, 3.7916404767E+01, 4.3182731754E+00, 9.8552280080E-01],
	[4.8555000000E+04, 5.5784820061E+01, 5.3399107030E+00, 3.7929134675E+01, 4.3185346003E+00, 9.8552818044E-01],
	[4.8560000000E+04, 5.5795114854E+01, 5.3399636864E+00, 3.7941867543E+01, 4.3187959628E+00, 9.8553355764E-01],
	[4.8565000000E+04, 5.5805410487E+01, 5.3400166648E+00, 3.7954603369E+01, 4.3190572629E+00, 9.8553893241E-01],
	[4.8570000000E+04, 5.5815706960E+01, 5.3400696384E+00, 3.7967342155E+01, 4.3193185005E+00, 9.8554430475E-01],
	[4.8575000000E+04, 5.5826004272E+01, 5.3401226070E+00, 3.7980083901E+01, 4.3195796758E+00, 9.8554967465E-01],
	[4.8580000000E+04, 5.5836302424E+01, 5.3401755707E+00, 3.7992828607E+01, 4.3198407887E+00, 9.8555504214E-01],
	[4.8585000000E+04, 5.5846601416E+01, 5.3402285294E+00, 3.8005576274E+01, 4.3201018392E+00, 9.8556040719E-01],
	[4.8590000000E+04, 5.5856901246E+01, 5.3402814833E+00, 3.8018326902E+01, 4.3203628274E+00, 9.8556576982E-01],
	[4.8595000000E+04, 5.5867201917E+01, 5.3403344322E+00, 3.8031080491E+01, 4.3206237532E+00, 9.8557113002E-01],
	[4.8600000000E+04, 5.5877503427E+01, 5.3403873762E+00, 3.8043837043E+01, 4.3208846168E+00, 9.8557648780E-01],
	[4.8605000000E+04, 5.5887805776E+01, 5.3404403152E+00, 3.8056596556E+01, 4.3211454181E+00, 9.8558184316E-01],
	[4.8610000000E+04, 5.5898108965E+01, 5.3404932494E+00, 3.8069359033E+01, 4.3214061571E+00, 9.8558719609E-01],
	[4.8615000000E+04, 5.5908412993E+01, 5.3405461786E+00, 3.8082124472E+01, 4.3216668339E+00, 9.8559254661E-01],
	[4.8620000000E+04, 5.5918717860E+01, 5.3405991029E+00, 3.8094892875E+01, 4.3219274485E+00, 9.8559789470E-01],
	[4.8625000000E+04, 5.5929023567E+01, 5.3406520223E+00, 3.8107664241E+01, 4.3221880008E+00, 9.8560324038E-01],
	[4.8630000000E+04, 5.5939330114E+01, 5.3407049368E+00, 3.8120438572E+01, 4.3224484910E+00, 9.8560858365E-01],
	[4.8635000000E+04, 5.5949637499E+01, 5.3407578463E+00, 3.8133215867E+01, 4.3227089189E+00, 9.8561392450E-01],
	[4.8640000000E+04, 5.5959945724E+01, 5.3408107510E+00, 3.8145996127E+01, 4.3229692848E+00, 9.8561926293E-01],
	[4.8645000000E+04, 5.5970254789E+01, 5.3408636507E+00, 3.8158779352E+01, 4.3232295885E+00, 9.8562459896E-01],
	[4.8650000000E+04, 5.5980564692E+01, 5.3409165455E+00, 3.8171565543E+01, 4.3234898301E+00, 9.8562993257E-01],
	[4.8655000000E+04, 5.5990875435E+01, 5.3409694354E+00, 3.8184354701E+01, 4.3237500096E+00, 9.8563526377E-01],
	[4.8660000000E+04, 5.6001187017E+01, 5.3410223204E+00, 3.8197146824E+01, 4.3240101270E+00, 9.8564059256E-01],
	[4.8665000000E+04, 5.6011499439E+01, 5.3410752005E+00, 3.8209941915E+01, 4.3242701823E+00, 9.8564591895E-01],
	[4.8670000000E+04, 5.6021812699E+01, 5.3411280757E+00, 3.8222739972E+01, 4.3245301757E+00, 9.8565124293E-01],
	[4.8675000000E+04, 5.6032126799E+01, 5.3411809459E+00, 3.8235540998E+01, 4.3247901070E+00, 9.8565656450E-01],
	[4.8680000000E+04, 5.6042441738E+01, 5.3412338113E+00, 3.8248344991E+01, 4.3250499763E+00, 9.8566188367E-01],
	[4.8685000000E+04, 5.6052757516E+01, 5.3412866717E+00, 3.8261151952E+01, 4.3253097836E+00, 9.8566720044E-01],
	[4.8690000000E+04, 5.6063074134E+01, 5.3413395273E+00, 3.8273961883E+01, 4.3255695289E+00, 9.8567251480E-01],
	[4.8695000000E+04, 5.6073391590E+01, 5.3413923779E+00, 3.8286774782E+01, 4.3258292123E+00, 9.8567782677E-01],
	[4.8700000000E+04, 5.6083709886E+01, 5.3414452237E+00, 3.8299590651E+01, 4.3260888338E+00, 9.8568313633E-01],
	[4.8705000000E+04, 5.6094029021E+01, 5.3414980645E+00, 3.8312409490E+01, 4.3263483933E+00, 9.8568844350E-01],
	[4.8710000000E+04, 5.6104348994E+01, 5.3415509004E+00, 3.8325231299E+01, 4.3266078910E+00, 9.8569374828E-01],
	[4.8715000000E+04, 5.6114669807E+01, 5.3416037314E+00, 3.8338056079E+01, 4.3268673268E+00, 9.8569905065E-01],
	[4.8720000000E+04, 5.6124991459E+01, 5.3416565576E+00, 3.8350883830E+01, 4.3271267007E+00, 9.8570435063E-01],
	[4.8725000000E+04, 5.6135313950E+01, 5.3417093788E+00, 3.8363714552E+01, 4.3273860128E+00, 9.8570964822E-01],
	[4.8730000000E+04, 5.6145637280E+01, 5.3417621951E+00, 3.8376548246E+01, 4.3276452631E+00, 9.8571494342E-01],
	[4.8735000000E+04, 5.6155961449E+01, 5.3418150066E+00, 3.8389384912E+01, 4.3279044515E+00, 9.8572023623E-01],
	[4.8740000000E+04, 5.6166286457E+01, 5.3418678131E+00, 3.8402224551E+01, 4.3281635782E+00, 9.8572552665E-01],
	[4.8745000000E+04, 5.6176612304E+01, 5.3419206148E+00, 3.8415067162E+01, 4.3284226432E+00, 9.8573081468E-01],
	[4.8750000000E+04, 5.6186938990E+01, 5.3419734115E+00, 3.8427912748E+01, 4.3286816464E+00, 9.8573610032E-01],
	[4.8755000000E+04, 5.6197266514E+01, 5.3420262034E+00, 3.8440761306E+01, 4.3289405878E+00, 9.8574138358E-01],
	[4.8760000000E+04, 5.6207594878E+01, 5.3420789903E+00, 3.8453612839E+01, 4.3291994676E+00, 9.8574666445E-01],
	[4.8765000000E+04, 5.6217924081E+01, 5.3421317724E+00, 3.8466467346E+01, 4.3294582856E+00, 9.8575194294E-01],
	[4.8770000000E+04, 5.6228254122E+01, 5.3421845496E+00, 3.8479324829E+01, 4.3297170420E+00, 9.8575721905E-01],
	[4.8775000000E+04, 5.6238585002E+01, 5.3422373219E+00, 3.8492185286E+01, 4.3299757368E+00, 9.8576249278E-01],
	[4.8780000000E+04, 5.6248916721E+01, 5.3422900893E+00, 3.8505048719E+01, 4.3302343699E+00, 9.8576776412E-01],
	[4.8785000000E+04, 5.6259249279E+01, 5.3423428518E+00, 3.8517915128E+01, 4.3304929414E+00, 9.8577303309E-01],
	[4.8790000000E+04, 5.6269582676E+01, 5.3423956095E+00, 3.8530784513E+01, 4.3307514512E+00, 9.8577829969E-01],
	[4.8795000000E+04, 5.6279916911E+01, 5.3424483622E+00, 3.8543656876E+01, 4.3310098996E+00, 9.8578356390E-01],
	[4.8800000000E+04, 5.6290251986E+01, 5.3425011101E+00, 3.8556532215E+01, 4.3312682863E+00, 9.8578882574E-01],
	[4.8805000000E+04, 5.6300587899E+01, 5.3425538531E+00, 3.8569410532E+01, 4.3315266115E+00, 9.8579408521E-01],
	[4.8810000000E+04, 5.6310924650E+01, 5.3426065912E+00, 3.8582291826E+01, 4.3317848752E+00, 9.8579934231E-01],
	[4.8815000000E+04, 5.6321262241E+01, 5.3426593244E+00, 3.8595176099E+01, 4.3320430774E+00, 9.8580459703E-01],
	[4.8820000000E+04, 5.6331600670E+01, 5.3427120527E+00, 3.8608063351E+01, 4.3323012181E+00, 9.8580984939E-01],
	[4.8825000000E+04, 5.6341939938E+01, 5.3427647762E+00, 3.8620953582E+01, 4.3325592973E+00, 9.8581509937E-01],
	[4.8830000000E+04, 5.6352280044E+01, 5.3428174947E+00, 3.8633846792E+01, 4.3328173151E+00, 9.8582034699E-01],
	[4.8835000000E+04, 5.6362620989E+01, 5.3428702084E+00, 3.8646742982E+01, 4.3330752714E+00, 9.8582559225E-01],
	[4.8840000000E+04, 5.6372962773E+01, 5.3429229173E+00, 3.8659642152E+01, 4.3333331663E+00, 9.8583083513E-01],
	[4.8845000000E+04, 5.6383305395E+01, 5.3429756212E+00, 3.8672544303E+01, 4.3335909999E+00, 9.8583607566E-01],
	[4.8850000000E+04, 5.6393648856E+01, 5.3430283203E+00, 3.8685449435E+01, 4.3338487720E+00, 9.8584131382E-01],
	[4.8855000000E+04, 5.6403993155E+01, 5.3430810145E+00, 3.8698357548E+01, 4.3341064828E+00, 9.8584654962E-01],
	[4.8860000000E+04, 5.6414338293E+01, 5.3431337038E+00, 3.8711268643E+01, 4.3343641323E+00, 9.8585178306E-01],
	[4.8865000000E+04, 5.6424684270E+01, 5.3431863883E+00, 3.8724182720E+01, 4.3346217204E+00, 9.8585701414E-01],
	[4.8870000000E+04, 5.6435031085E+01, 5.3432390678E+00, 3.8737099780E+01, 4.3348792472E+00, 9.8586224286E-01],
	[4.8875000000E+04, 5.6445378738E+01, 5.3432917426E+00, 3.8750019822E+01, 4.3351367127E+00, 9.8586746923E-01],
	[4.8880000000E+04, 5.6455727230E+01, 5.3433444124E+00, 3.8762942848E+01, 4.3353941170E+00, 9.8587269324E-01],
	[4.8885000000E+04, 5.6466076561E+01, 5.3433970774E+00, 3.8775868857E+01, 4.3356514600E+00, 9.8587791490E-01],
	[4.8890000000E+04, 5.6476426729E+01, 5.3434497375E+00, 3.8788797850E+01, 4.3359087418E+00, 9.8588313420E-01],
	[4.8895000000E+04, 5.6486777737E+01, 5.3435023927E+00, 3.8801729828E+01, 4.3361659624E+00, 9.8588835115E-01],
	[4.8900000000E+04, 5.6497129582E+01, 5.3435550431E+00, 3.8814664790E+01, 4.3364231218E+00, 9.8589356575E-01],
	[4.8905000000E+04, 5.6507482267E+01, 5.3436076886E+00, 3.8827602738E+01, 4.3366802200E+00, 9.8589877801E-01],
	[4.8910000000E+04, 5.6517835789E+01, 5.3436603293E+00, 3.8840543671E+01, 4.3369372571E+00, 9.8590398791E-01],
	[4.8915000000E+04, 5.6528190150E+01, 5.3437129650E+00, 3.8853487591E+01, 4.3371942330E+00, 9.8590919547E-01],
	[4.8920000000E+04, 5.6538545349E+01, 5.3437655960E+00, 3.8866434496E+01, 4.3374511478E+00, 9.8591440068E-01],
	[4.8925000000E+04, 5.6548901386E+01, 5.3438182220E+00, 3.8879384388E+01, 4.3377080015E+00, 9.8591960355E-01],
	[4.8930000000E+04, 5.6559258262E+01, 5.3438708432E+00, 3.8892337268E+01, 4.3379647941E+00, 9.8592480407E-01],
	[4.8935000000E+04, 5.6569615976E+01, 5.3439234596E+00, 3.8905293134E+01, 4.3382215256E+00, 9.8593000225E-01],
	[4.8940000000E+04, 5.6579974528E+01, 5.3439760711E+00, 3.8918251989E+01, 4.3384781961E+00, 9.8593519809E-01],
	[4.8945000000E+04, 5.6590333919E+01, 5.3440286777E+00, 3.8931213832E+01, 4.3387348056E+00, 9.8594039159E-01],
	[4.8950000000E+04, 5.6600694148E+01, 5.3440812795E+00, 3.8944178663E+01, 4.3389913540E+00, 9.8594558275E-01],
	[4.8955000000E+04, 5.6611055215E+01, 5.3441338764E+00, 3.8957146484E+01, 4.3392478415E+00, 9.8595077158E-01],
	[4.8960000000E+04, 5.6621417120E+01, 5.3441864684E+00, 3.8970117294E+01, 4.3395042679E+00, 9.8595595807E-01],
	[4.8965000000E+04, 5.6631779863E+01, 5.3442390557E+00, 3.8983091093E+01, 4.3397606335E+00, 9.8596114222E-01],
	[4.8970000000E+04, 5.6642143445E+01, 5.3442916380E+00, 3.8996067883E+01, 4.3400169381E+00, 9.8596632404E-01],
	[4.8975000000E+04, 5.6652507864E+01, 5.3443442155E+00, 3.9009047663E+01, 4.3402731817E+00, 9.8597150353E-01],
	[4.8980000000E+04, 5.6662873122E+01, 5.3443967882E+00, 3.9022030434E+01, 4.3405293645E+00, 9.8597668068E-01],
	[4.8985000000E+04, 5.6673239218E+01, 5.3444493560E+00, 3.9035016197E+01, 4.3407854864E+00, 9.8598185551E-01],
	[4.8990000000E+04, 5.6683606152E+01, 5.3445019189E+00, 3.9048004951E+01, 4.3410415474E+00, 9.8598702801E-01],
	[4.8995000000E+04, 5.6693973924E+01, 5.3445544770E+00, 3.9060996697E+01, 4.3412975475E+00, 9.8599219818E-01],
	[4.9000000000E+04, 5.6704342534E+01, 5.3446070303E+00, 3.9073991436E+01, 4.3415534869E+00, 9.8599736602E-01],
	[4.9005000000E+04, 5.6714711982E+01, 5.3446595787E+00, 3.9086989167E+01, 4.3418093654E+00, 9.8600253153E-01],
	[4.9010000000E+04, 5.6725082268E+01, 5.3447121223E+00, 3.9099989892E+01, 4.3420651831E+00, 9.8600769473E-01],
	[4.9015000000E+04, 5.6735453392E+01, 5.3447646610E+00, 3.9112993610E+01, 4.3423209401E+00, 9.8601285560E-01],
	[4.9020000000E+04, 5.6745825354E+01, 5.3448171949E+00, 3.9126000323E+01, 4.3425766363E+00, 9.8601801415E-01],
	[4.9025000000E+04, 5.6756198154E+01, 5.3448697240E+00, 3.9139010029E+01, 4.3428322717E+00, 9.8602317037E-01],
	[4.9030000000E+04, 5.6766571792E+01, 5.3449222482E+00, 3.9152022730E+01, 4.3430878465E+00, 9.8602832428E-01],
	[4.9035000000E+04, 5.6776946268E+01, 5.3449747675E+00, 3.9165038427E+01, 4.3433433605E+00, 9.8603347587E-01],
	[4.9040000000E+04, 5.6787321582E+01, 5.3450272821E+00, 3.9178057119E+01, 4.3435988138E+00, 9.8603862514E-01],
	[4.9045000000E+04, 5.6797697733E+01, 5.3450797918E+00, 3.9191078807E+01, 4.3438542065E+00, 9.8604377210E-01],
	[4.9050000000E+04, 5.6808074723E+01, 5.3451322966E+00, 3.9204103491E+01, 4.3441095386E+00, 9.8604891674E-01],
	[4.9055000000E+04, 5.6818452550E+01, 5.3451847966E+00, 3.9217131172E+01, 4.3443648100E+00, 9.8605405907E-01],
	[4.9060000000E+04, 5.6828831215E+01, 5.3452372918E+00, 3.9230161849E+01, 4.3446200208E+00, 9.8605919909E-01],
	[4.9065000000E+04, 5.6839210718E+01, 5.3452897821E+00, 3.9243195525E+01, 4.3448751710E+00, 9.8606433679E-01],
	[4.9070000000E+04, 5.6849600162E+01, 5.3453430245E+00, 3.9256232198E+01, 4.3451308139E+00, 9.8606947219E-01],
	[4.9075000000E+04, 5.6860000469E+01, 5.3453970952E+00, 3.9269271869E+01, 4.3453870054E+00, 9.8607460528E-01],
	[4.9080000000E+04, 5.6870401619E+01, 5.3454511608E+00, 3.9282314538E+01, 4.3456431365E+00, 9.8607973606E-01],
	[4.9085000000E+04, 5.6880803612E+01, 5.3455052216E+00, 3.9295360207E+01, 4.3458992072E+00, 9.8608486453E-01],
	[4.9090000000E+04, 5.6891206447E+01, 5.3455592774E+00, 3.9308408875E+01, 4.3461552174E+00, 9.8608999070E-01],
	[4.9095000000E+04, 5.6901610126E+01, 5.3456133282E+00, 3.9321460543E+01, 4.3464111673E+00, 9.8609511456E-01],
	[4.9100000000E+04, 5.6912014647E+01, 5.3456673740E+00, 3.9334515211E+01, 4.3466670568E+00, 9.8610023612E-01],
	[4.9105000000E+04, 5.6922420010E+01, 5.3457214149E+00, 3.9347572879E+01, 4.3469228859E+00, 9.8610535538E-01],
	[4.9110000000E+04, 5.6932826217E+01, 5.3457754509E+00, 3.9360633548E+01, 4.3471786547E+00, 9.8611047234E-01],
	[4.9115000000E+04, 5.6943233266E+01, 5.3458294819E+00, 3.9373697218E+01, 4.3474343632E+00, 9.8611558700E-01],
	[4.9120000000E+04, 5.6953641158E+01, 5.3458835079E+00, 3.9386763890E+01, 4.3476900114E+00, 9.8612069936E-01],
	[4.9125000000E+04, 5.6964049892E+01, 5.3459375290E+00, 3.9399833564E+01, 4.3479455993E+00, 9.8612580943E-01],
	[4.9130000000E+04, 5.6974459469E+01, 5.3459915451E+00, 3.9412906241E+01, 4.3482011269E+00, 9.8613091719E-01],
	[4.9135000000E+04, 5.6984869889E+01, 5.3460455563E+00, 3.9425981920E+01, 4.3484565943E+00, 9.8613602267E-01],
	[4.9140000000E+04, 5.6995281151E+01, 5.3460995625E+00, 3.9439060602E+01, 4.3487120014E+00, 9.8614112585E-01],
	[4.9145000000E+04, 5.7005693256E+01, 5.3461535638E+00, 3.9452142288E+01, 4.3489673484E+00, 9.8614622674E-01],
	[4.9150000000E+04, 5.7016106203E+01, 5.3462075601E+00, 3.9465226978E+01, 4.3492226351E+00, 9.8615132534E-01],
	[4.9155000000E+04, 5.7026519993E+01, 5.3462615515E+00, 3.9478314672E+01, 4.3494778617E+00, 9.8615642165E-01],
	[4.9160000000E+04, 5.7036934625E+01, 5.3463155380E+00, 3.9491405371E+01, 4.3497330281E+00, 9.8616151567E-01],
	[4.9165000000E+04, 5.7047350100E+01, 5.3463695194E+00, 3.9504499075E+01, 4.3499881343E+00, 9.8616660740E-01],
	[4.9170000000E+04, 5.7057766418E+01, 5.3464234960E+00, 3.9517595784E+01, 4.3502431805E+00, 9.8617169684E-01],
	[4.9175000000E+04, 5.7068183578E+01, 5.3464774676E+00, 3.9530695499E+01, 4.3504981665E+00, 9.8617678401E-01],
	[4.9180000000E+04, 5.7078601580E+01, 5.3465314343E+00, 3.9543798221E+01, 4.3507530925E+00, 9.8618186888E-01],
	[4.9185000000E+04, 5.7089020425E+01, 5.3465853960E+00, 3.9556903948E+01, 4.3510079584E+00, 9.8618695148E-01],
	[4.9190000000E+04, 5.7099440112E+01, 5.3466393528E+00, 3.9570012683E+01, 4.3512627642E+00, 9.8619203179E-01],
	[4.9195000000E+04, 5.7109860642E+01, 5.3466933046E+00, 3.9583124426E+01, 4.3515175100E+00, 9.8619710982E-01],
	[4.9200000000E+04, 5.7120282014E+01, 5.3467472515E+00, 3.9596239176E+01, 4.3517721958E+00, 9.8620218558E-01],
	[4.9205000000E+04, 5.7130704228E+01, 5.3468011935E+00, 3.9609356934E+01, 4.3520268216E+00, 9.8620725905E-01],
	[4.9210000000E+04, 5.7141127285E+01, 5.3468551305E+00, 3.9622477701E+01, 4.3522813874E+00, 9.8621233025E-01],
	[4.9215000000E+04, 5.7151551184E+01, 5.3469090626E+00, 3.9635601476E+01, 4.3525358932E+00, 9.8621739917E-01],
	[4.9220000000E+04, 5.7161975925E+01, 5.3469629897E+00, 3.9648728261E+01, 4.3527903391E+00, 9.8622246582E-01],
	[4.9225000000E+04, 5.7172401509E+01, 5.3470169119E+00, 3.9661858056E+01, 4.3530447251E+00, 9.8622753020E-01],
	[4.9230000000E+04, 5.7182827935E+01, 5.3470708292E+00, 3.9674990860E+01, 4.3532990512E+00, 9.8623259230E-01],
	[4.9235000000E+04, 5.7193255203E+01, 5.3471247416E+00, 3.9688126675E+01, 4.3535533173E+00, 9.8623765213E-01],
	[4.9240000000E+04, 5.7203683313E+01, 5.3471786490E+00, 3.9701265501E+01, 4.3538075236E+00, 9.8624270969E-01],
	[4.9245000000E+04, 5.7214112266E+01, 5.3472325515E+00, 3.9714407338E+01, 4.3540616701E+00, 9.8624776499E-01],
	[4.9250000000E+04, 5.7224542061E+01, 5.3472864491E+00, 3.9727552187E+01, 4.3543157567E+00, 9.8625281801E-01],
	[4.9255000000E+04, 5.7234972698E+01, 5.3473403417E+00, 3.9740700047E+01, 4.3545697835E+00, 9.8625786877E-01],
	[4.9260000000E+04, 5.7245404177E+01, 5.3473942294E+00, 3.9753850920E+01, 4.3548237505E+00, 9.8626291727E-01],
	[4.9265000000E+04, 5.7255836499E+01, 5.3474481122E+00, 3.9767004806E+01, 4.3550776577E+00, 9.8626796350E-01],
	[4.9270000000E+04, 5.7266269662E+01, 5.3475019900E+00, 3.9780161705E+01, 4.3553315052E+00, 9.8627300747E-01],
	[4.9275000000E+04, 5.7276703668E+01, 5.3475558630E+00, 3.9793321617E+01, 4.3555852929E+00, 9.8627804917E-01],
	[4.9280000000E+04, 5.7287138515E+01, 5.3476097310E+00, 3.9806484543E+01, 4.3558390208E+00, 9.8628308862E-01],
	[4.9285000000E+04, 5.7297574205E+01, 5.3476635941E+00, 3.9819650483E+01, 4.3560926891E+00, 9.8628812580E-01],
	[4.9290000000E+04, 5.7308010737E+01, 5.3477174522E+00, 3.9832819438E+01, 4.3563462977E+00, 9.8629316073E-01],
	[4.9295000000E+04, 5.7318448111E+01, 5.3477713055E+00, 3.9845991408E+01, 4.3565998466E+00, 9.8629819340E-01],
	[4.9300000000E+04, 5.7328886327E+01, 5.3478251538E+00, 3.9859166394E+01, 4.3568533358E+00, 9.8630322382E-01],
	[4.9305000000E+04, 5.7339325385E+01, 5.3478789972E+00, 3.9872344395E+01, 4.3571067654E+00, 9.8630825198E-01],
	[4.9310000000E+04, 5.7349765285E+01, 5.3479328357E+00, 3.9885525412E+01, 4.3573601354E+00, 9.8631327789E-01],
	[4.9315000000E+04, 5.7360206027E+01, 5.3479866692E+00, 3.9898709446E+01, 4.3576134457E+00, 9.8631830154E-01],
	[4.9320000000E+04, 5.7370647611E+01, 5.3480404979E+00, 3.9911896497E+01, 4.3578666965E+00, 9.8632332295E-01],
	[4.9325000000E+04, 5.7381090037E+01, 5.3480943216E+00, 3.9925086566E+01, 4.3581198877E+00, 9.8632834210E-01],
	[4.9330000000E+04, 5.7391533305E+01, 5.3481481405E+00, 3.9938279652E+01, 4.3583730194E+00, 9.8633335901E-01],
	[4.9335000000E+04, 5.7401977415E+01, 5.3482019544E+00, 3.9951475756E+01, 4.3586260915E+00, 9.8633837367E-01],
	[4.9340000000E+04, 5.7412422366E+01, 5.3482557634E+00, 3.9964674878E+01, 4.3588791041E+00, 9.8634338608E-01],
	[4.9345000000E+04, 5.7422868160E+01, 5.3483095675E+00, 3.9977877019E+01, 4.3591320572E+00, 9.8634839625E-01],
	[4.9350000000E+04, 5.7433314795E+01, 5.3483633666E+00, 3.9991082180E+01, 4.3593849508E+00, 9.8635340417E-01],
	[4.9355000000E+04, 5.7443762273E+01, 5.3484171609E+00, 4.0004290360E+01, 4.3596377850E+00, 9.8635840985E-01],
	[4.9360000000E+04, 5.7454210592E+01, 5.3484709503E+00, 4.0017501561E+01, 4.3598905597E+00, 9.8636341329E-01],
	[4.9365000000E+04, 5.7464659753E+01, 5.3485247347E+00, 4.0030715781E+01, 4.3601432750E+00, 9.8636841448E-01],
	[4.9370000000E+04, 5.7475109755E+01, 5.3485785143E+00, 4.0043933023E+01, 4.3603959309E+00, 9.8637341344E-01],
	[4.9375000000E+04, 5.7485560600E+01, 5.3486322889E+00, 4.0057153285E+01, 4.3606485274E+00, 9.8637841016E-01],
	[4.9380000000E+04, 5.7496012286E+01, 5.3486860586E+00, 4.0070376569E+01, 4.3609010645E+00, 9.8638340464E-01],
	[4.9385000000E+04, 5.7506464814E+01, 5.3487398235E+00, 4.0083602875E+01, 4.3611535423E+00, 9.8638839689E-01],
	[4.9390000000E+04, 5.7516918183E+01, 5.3487935834E+00, 4.0096832204E+01, 4.3614059607E+00, 9.8639338690E-01],
	[4.9395000000E+04, 5.7527372395E+01, 5.3488473384E+00, 4.0110064555E+01, 4.3616583198E+00, 9.8639837467E-01],
	[4.9400000000E+04, 5.7537827448E+01, 5.3489010885E+00, 4.0123299929E+01, 4.3619106196E+00, 9.8640336022E-01],
	[4.9405000000E+04, 5.7548283342E+01, 5.3489548338E+00, 4.0136538326E+01, 4.3621628601E+00, 9.8640834353E-01],
	[4.9410000000E+04, 5.7558740079E+01, 5.3490085741E+00, 4.0149779748E+01, 4.3624150414E+00, 9.8641332462E-01],
	[4.9415000000E+04, 5.7569197657E+01, 5.3490623095E+00, 4.0163024193E+01, 4.3626671634E+00, 9.8641830347E-01],
	[4.9420000000E+04, 5.7579656076E+01, 5.3491160400E+00, 4.0176271664E+01, 4.3629192261E+00, 9.8642328010E-01],
	[4.9425000000E+04, 5.7590115338E+01, 5.3491697657E+00, 4.0189522159E+01, 4.3631712297E+00, 9.8642825450E-01],
	[4.9430000000E+04, 5.7600575440E+01, 5.3492234864E+00, 4.0202775679E+01, 4.3634231740E+00, 9.8643322667E-01],
	[4.9435000000E+04, 5.7611036385E+01, 5.3492772023E+00, 4.0216032226E+01, 4.3636750592E+00, 9.8643819662E-01],
	[4.9440000000E+04, 5.7621498171E+01, 5.3493309132E+00, 4.0229291798E+01, 4.3639268852E+00, 9.8644316435E-01],
	[4.9445000000E+04, 5.7631960798E+01, 5.3493846193E+00, 4.0242554397E+01, 4.3641786521E+00, 9.8644812985E-01],
	[4.9450000000E+04, 5.7642424267E+01, 5.3494383204E+00, 4.0255820023E+01, 4.3644303598E+00, 9.8645309313E-01],
	[4.9455000000E+04, 5.7652888577E+01, 5.3494920167E+00, 4.0269088676E+01, 4.3646820085E+00, 9.8645805420E-01],
	[4.9460000000E+04, 5.7663353729E+01, 5.3495457081E+00, 4.0282360357E+01, 4.3649335980E+00, 9.8646301304E-01],
	[4.9465000000E+04, 5.7673819723E+01, 5.3495993946E+00, 4.0295635066E+01, 4.3651851285E+00, 9.8646796967E-01],
	[4.9470000000E+04, 5.7684286557E+01, 5.3496530762E+00, 4.0308912803E+01, 4.3654365999E+00, 9.8647292408E-01],
	[4.9475000000E+04, 5.7694754234E+01, 5.3497067529E+00, 4.0322193570E+01, 4.3656880123E+00, 9.8647787627E-01],
	[4.9480000000E+04, 5.7705222751E+01, 5.3497604248E+00, 4.0335477365E+01, 4.3659393656E+00, 9.8648282626E-01],
	[4.9485000000E+04, 5.7715692110E+01, 5.3498140917E+00, 4.0348764190E+01, 4.3661906600E+00, 9.8648777402E-01],
	[4.9490000000E+04, 5.7726162311E+01, 5.3498677538E+00, 4.0362054045E+01, 4.3664418954E+00, 9.8649271958E-01],
	[4.9495000000E+04, 5.7736633352E+01, 5.3499214110E+00, 4.0375346930E+01, 4.3666930718E+00, 9.8649766293E-01],
	[4.9500000000E+04, 5.7747105235E+01, 5.3499750633E+00, 4.0388642846E+01, 4.3669441892E+00, 9.8650260406E-01],
	[4.9505000000E+04, 5.7757577960E+01, 5.3500287107E+00, 4.0401941793E+01, 4.3671952477E+00, 9.8650754299E-01],
	[4.9510000000E+04, 5.7768051526E+01, 5.3500823532E+00, 4.0415243772E+01, 4.3674462473E+00, 9.8651247971E-01],
	[4.9515000000E+04, 5.7778525933E+01, 5.3501359909E+00, 4.0428548783E+01, 4.3676971880E+00, 9.8651741423E-01],
	[4.9520000000E+04, 5.7789001181E+01, 5.3501896237E+00, 4.0441856826E+01, 4.3679480699E+00, 9.8652234654E-01],
	[4.9525000000E+04, 5.7799477270E+01, 5.3502432516E+00, 4.0455167901E+01, 4.3681988928E+00, 9.8652727664E-01],
	[4.9530000000E+04, 5.7809954201E+01, 5.3502968746E+00, 4.0468482010E+01, 4.3684496569E+00, 9.8653220455E-01],
	[4.9535000000E+04, 5.7820431973E+01, 5.3503504928E+00, 4.0481799152E+01, 4.3687003622E+00, 9.8653713025E-01],
	[4.9540000000E+04, 5.7830910586E+01, 5.3504041061E+00, 4.0495119327E+01, 4.3689510087E+00, 9.8654205375E-01],
	[4.9545000000E+04, 5.7841390040E+01, 5.3504577145E+00, 4.0508442537E+01, 4.3692015964E+00, 9.8654697505E-01],
	[4.9550000000E+04, 5.7851870336E+01, 5.3505113180E+00, 4.0521768782E+01, 4.3694521253E+00, 9.8655189416E-01],
	[4.9555000000E+04, 5.7862351473E+01, 5.3505649167E+00, 4.0535098061E+01, 4.3697025955E+00, 9.8655681107E-01],
	[4.9560000000E+04, 5.7872833450E+01, 5.3506185105E+00, 4.0548430376E+01, 4.3699530069E+00, 9.8656172578E-01],
	[4.9565000000E+04, 5.7883316269E+01, 5.3506720994E+00, 4.0561765727E+01, 4.3702033596E+00, 9.8656663830E-01],
	[4.9570000000E+04, 5.7893799929E+01, 5.3507256834E+00, 4.0575104114E+01, 4.3704536536E+00, 9.8657154862E-01],
	[4.9575000000E+04, 5.7904284430E+01, 5.3507792626E+00, 4.0588445537E+01, 4.3707038889E+00, 9.8657645675E-01],
	[4.9580000000E+04, 5.7914769772E+01, 5.3508328369E+00, 4.0601789997E+01, 4.3709540656E+00, 9.8658136269E-01],
	[4.9585000000E+04, 5.7925255956E+01, 5.3508864064E+00, 4.0615137494E+01, 4.3712041835E+00, 9.8658626644E-01],
	[4.9590000000E+04, 5.7935742980E+01, 5.3509399710E+00, 4.0628488029E+01, 4.3714542429E+00, 9.8659116801E-01],
	[4.9595000000E+04, 5.7946230845E+01, 5.3509935307E+00, 4.0641841602E+01, 4.3717042436E+00, 9.8659606738E-01],
	[4.9600000000E+04, 5.7956719551E+01, 5.3510470856E+00, 4.0655198214E+01, 4.3719541858E+00, 9.8660096457E-01],
	[4.9605000000E+04, 5.7967209098E+01, 5.3511006356E+00, 4.0668557864E+01, 4.3722040693E+00, 9.8660585957E-01],
	[4.9610000000E+04, 5.7977699486E+01, 5.3511541807E+00, 4.0681920553E+01, 4.3724538943E+00, 9.8661075238E-01],
	[4.9615000000E+04, 5.7988190715E+01, 5.3512077210E+00, 4.0695286282E+01, 4.3727036608E+00, 9.8661564302E-01],
	[4.9620000000E+04, 5.7998682785E+01, 5.3512612564E+00, 4.0708655051E+01, 4.3729533687E+00, 9.8662053147E-01],
	[4.9625000000E+04, 5.8009175696E+01, 5.3513147869E+00, 4.0722026860E+01, 4.3732030181E+00, 9.8662541774E-01],
	[4.9630000000E+04, 5.8019669448E+01, 5.3513683126E+00, 4.0735401710E+01, 4.3734526090E+00, 9.8663030183E-01],
	[4.9635000000E+04, 5.8030164040E+01, 5.3514218335E+00, 4.0748779601E+01, 4.3737021415E+00, 9.8663518375E-01],
	[4.9640000000E+04, 5.8040659474E+01, 5.3514753495E+00, 4.0762160534E+01, 4.3739516155E+00, 9.8664006348E-01],
	[4.9645000000E+04, 5.8051155748E+01, 5.3515288606E+00, 4.0775544508E+01, 4.3742010310E+00, 9.8664494104E-01],
	[4.9650000000E+04, 5.8061652863E+01, 5.3515823669E+00, 4.0788931525E+01, 4.3744503881E+00, 9.8664981642E-01],
	[4.9655000000E+04, 5.8072150819E+01, 5.3516358683E+00, 4.0802321584E+01, 4.3746996868E+00, 9.8665468963E-01],
	[4.9660000000E+04, 5.8082649616E+01, 5.3516893648E+00, 4.0815714686E+01, 4.3749489271E+00, 9.8665956067E-01],
	[4.9665000000E+04, 5.8093149253E+01, 5.3517428566E+00, 4.0829110832E+01, 4.3751981091E+00, 9.8666442953E-01],
	[4.9670000000E+04, 5.8103649732E+01, 5.3517963434E+00, 4.0842510021E+01, 4.3754472327E+00, 9.8666929623E-01],
	[4.9675000000E+04, 5.8114151050E+01, 5.3518498255E+00, 4.0855912255E+01, 4.3756962979E+00, 9.8667416075E-01],
	[4.9680000000E+04, 5.8124653210E+01, 5.3519033026E+00, 4.0869317533E+01, 4.3759453049E+00, 9.8667902310E-01],
	[4.9685000000E+04, 5.8135156210E+01, 5.3519567749E+00, 4.0882725856E+01, 4.3761942535E+00, 9.8668388329E-01],
	[4.9690000000E+04, 5.8145660051E+01, 5.3520102424E+00, 4.0896137225E+01, 4.3764431438E+00, 9.8668874131E-01],
	[4.9695000000E+04, 5.8156164733E+01, 5.3520637050E+00, 4.0909551639E+01, 4.3766919759E+00, 9.8669359717E-01],
	[4.9700000000E+04, 5.8166670255E+01, 5.3521171628E+00, 4.0922969099E+01, 4.3769407498E+00, 9.8669845086E-01],
	[4.9705000000E+04, 5.8177176618E+01, 5.3521706158E+00, 4.0936389606E+01, 4.3771894654E+00, 9.8670330239E-01],
	[4.9710000000E+04, 5.8187683822E+01, 5.3522240639E+00, 4.0949813159E+01, 4.3774381228E+00, 9.8670815176E-01],
	[4.9715000000E+04, 5.8198191866E+01, 5.3522775071E+00, 4.0963239760E+01, 4.3776867219E+00, 9.8671299897E-01],
	[4.9720000000E+04, 5.8208700751E+01, 5.3523309455E+00, 4.0976669409E+01, 4.3779352630E+00, 9.8671784402E-01],
	[4.9725000000E+04, 5.8219210476E+01, 5.3523843791E+00, 4.0990102105E+01, 4.3781837458E+00, 9.8672268691E-01],
	[4.9730000000E+04, 5.8229721042E+01, 5.3524378079E+00, 4.1003537850E+01, 4.3784321705E+00, 9.8672752764E-01],
	[4.9735000000E+04, 5.8240232448E+01, 5.3524912318E+00, 4.1016976643E+01, 4.3786805371E+00, 9.8673236622E-01],
	[4.9740000000E+04, 5.8250744695E+01, 5.3525446508E+00, 4.1030418486E+01, 4.3789288455E+00, 9.8673720264E-01],
	[4.9745000000E+04, 5.8261257782E+01, 5.3525980650E+00, 4.1043863378E+01, 4.3791770959E+00, 9.8674203691E-01],
	[4.9750000000E+04, 5.8271771710E+01, 5.3526514744E+00, 4.1057311321E+01, 4.3794252882E+00, 9.8674686902E-01],
	[4.9755000000E+04, 5.8282286478E+01, 5.3527048790E+00, 4.1070762313E+01, 4.3796734224E+00, 9.8675169898E-01],
	[4.9760000000E+04, 5.8292802087E+01, 5.3527582787E+00, 4.1084216356E+01, 4.3799214986E+00, 9.8675652680E-01],
	[4.9765000000E+04, 5.8303318536E+01, 5.3528116736E+00, 4.1097673451E+01, 4.3801695168E+00, 9.8676135246E-01],
	[4.9770000000E+04, 5.8313835826E+01, 5.3528650636E+00, 4.1111133596E+01, 4.3804174770E+00, 9.8676617597E-01],
	[4.9775000000E+04, 5.8324353956E+01, 5.3529184489E+00, 4.1124596794E+01, 4.3806653791E+00, 9.8677099734E-01],
	[4.9780000000E+04, 5.8334872926E+01, 5.3529718293E+00, 4.1138063044E+01, 4.3809132233E+00, 9.8677581657E-01],
	[4.9785000000E+04, 5.8345392736E+01, 5.3530252048E+00, 4.1151532346E+01, 4.3811610096E+00, 9.8678063364E-01],
	[4.9790000000E+04, 5.8355913387E+01, 5.3530785756E+00, 4.1165004702E+01, 4.3814087379E+00, 9.8678544858E-01],
	[4.9795000000E+04, 5.8366434879E+01, 5.3531319415E+00, 4.1178480110E+01, 4.3816564083E+00, 9.8679026137E-01],
	[4.9800000000E+04, 5.8376957210E+01, 5.3531853025E+00, 4.1191958573E+01, 4.3819040208E+00, 9.8679507202E-01],
	[4.9805000000E+04, 5.8387480382E+01, 5.3532386588E+00, 4.1205440090E+01, 4.3821515754E+00, 9.8679988053E-01],
	[4.9810000000E+04, 5.8398004394E+01, 5.3532920102E+00, 4.1218924661E+01, 4.3823990721E+00, 9.8680468690E-01],
	[4.9815000000E+04, 5.8408529246E+01, 5.3533453568E+00, 4.1232412287E+01, 4.3826465110E+00, 9.8680949113E-01],
	[4.9820000000E+04, 5.8419054939E+01, 5.3533986986E+00, 4.1245902969E+01, 4.3828938921E+00, 9.8681429322E-01],
	[4.9825000000E+04, 5.8429581472E+01, 5.3534520356E+00, 4.1259396706E+01, 4.3831412153E+00, 9.8681909318E-01],
	[4.9830000000E+04, 5.8440108845E+01, 5.3535053677E+00, 4.1272893499E+01, 4.3833884807E+00, 9.8682389100E-01],
	[4.9835000000E+04, 5.8450637058E+01, 5.3535586951E+00, 4.1286393349E+01, 4.3836356884E+00, 9.8682868669E-01],
	[4.9840000000E+04, 5.8461166111E+01, 5.3536120176E+00, 4.1299896255E+01, 4.3838828383E+00, 9.8683348025E-01],
	[4.9845000000E+04, 5.8471696005E+01, 5.3536653353E+00, 4.1313402219E+01, 4.3841299304E+00, 9.8683827168E-01],
	[4.9850000000E+04, 5.8482226738E+01, 5.3537186481E+00, 4.1326911241E+01, 4.3843769648E+00, 9.8684306097E-01],
	[4.9855000000E+04, 5.8492758312E+01, 5.3537719562E+00, 4.1340423320E+01, 4.3846239415E+00, 9.8684784814E-01],
	[4.9860000000E+04, 5.8503300158E+01, 5.3538260251E+00, 4.1353938458E+01, 4.3848714272E+00, 9.8685263318E-01],
	[4.9865000000E+04, 5.8513852603E+01, 5.3538808810E+00, 4.1367456654E+01, 4.3851194411E+00, 9.8685741609E-01],
	[4.9870000000E+04, 5.8524405894E+01, 5.3539357319E+00, 4.1380977910E+01, 4.3853673975E+00, 9.8686219688E-01],
	[4.9875000000E+04, 5.8534960029E+01, 5.3539905779E+00, 4.1394502225E+01, 4.3856152963E+00, 9.8686697554E-01],
	[4.9880000000E+04, 5.8545515009E+01, 5.3540454189E+00, 4.1408029600E+01, 4.3858631376E+00, 9.8687175207E-01],
	[4.9885000000E+04, 5.8556070834E+01, 5.3541002550E+00, 4.1421560035E+01, 4.3861109213E+00, 9.8687652649E-01],
	[4.9890000000E+04, 5.8566627505E+01, 5.3541550862E+00, 4.1435093531E+01, 4.3863586476E+00, 9.8688129878E-01],
	[4.9895000000E+04, 5.8577185020E+01, 5.3542099124E+00, 4.1448630089E+01, 4.3866063163E+00, 9.8688606895E-01],
	[4.9900000000E+04, 5.8587743380E+01, 5.3542647337E+00, 4.1462169707E+01, 4.3868539276E+00, 9.8689083701E-01],
	[4.9905000000E+04, 5.8598302585E+01, 5.3543195501E+00, 4.1475712387E+01, 4.3871014814E+00, 9.8689560294E-01],
	[4.9910000000E+04, 5.8608862635E+01, 5.3543743616E+00, 4.1489258130E+01, 4.3873489778E+00, 9.8690036676E-01],
	[4.9915000000E+04, 5.8619423530E+01, 5.3544291681E+00, 4.1502806935E+01, 4.3875964168E+00, 9.8690512846E-01],
	[4.9920000000E+04, 5.8629985270E+01, 5.3544839697E+00, 4.1516358804E+01, 4.3878437983E+00, 9.8690988805E-01],
	[4.9925000000E+04, 5.8640547855E+01, 5.3545387663E+00, 4.1529913735E+01, 4.3880911225E+00, 9.8691464553E-01],
	[4.9930000000E+04, 5.8651111284E+01, 5.3545935581E+00, 4.1543471730E+01, 4.3883383893E+00, 9.8691940089E-01],
	[4.9935000000E+04, 5.8661675558E+01, 5.3546483449E+00, 4.1557032790E+01, 4.3885855988E+00, 9.8692415414E-01],
	[4.9940000000E+04, 5.8672240677E+01, 5.3547031268E+00, 4.1570596914E+01, 4.3888327509E+00, 9.8692890528E-01],
	[4.9945000000E+04, 5.8682806641E+01, 5.3547579037E+00, 4.1584164103E+01, 4.3890798457E+00, 9.8693365431E-01],
	[4.9950000000E+04, 5.8693373450E+01, 5.3548126757E+00, 4.1597734357E+01, 4.3893268832E+00, 9.8693840123E-01],
	[4.9955000000E+04, 5.8703941103E+01, 5.3548674429E+00, 4.1611307677E+01, 4.3895738634E+00, 9.8694314604E-01],
	[4.9960000000E+04, 5.8714509602E+01, 5.3549222051E+00, 4.1624884063E+01, 4.3898207863E+00, 9.8694788875E-01],
	[4.9965000000E+04, 5.8725078945E+01, 5.3549769623E+00, 4.1638463515E+01, 4.3900676520E+00, 9.8695262936E-01],
	[4.9970000000E+04, 5.8735649132E+01, 5.3550317147E+00, 4.1652046034E+01, 4.3903144605E+00, 9.8695736786E-01],
	[4.9975000000E+04, 5.8746220164E+01, 5.3550864621E+00, 4.1665631621E+01, 4.3905612117E+00, 9.8696210425E-01],
	[4.9980000000E+04, 5.8756792041E+01, 5.3551412046E+00, 4.1679220275E+01, 4.3908079057E+00, 9.8696683855E-01],
	[4.9985000000E+04, 5.8767364763E+01, 5.3551959422E+00, 4.1692811997E+01, 4.3910545426E+00, 9.8697157075E-01],
	[4.9990000000E+04, 5.8777938329E+01, 5.3552506749E+00, 4.1706406787E+01, 4.3913011223E+00, 9.8697630084E-01],
	[4.9995000000E+04, 5.8788512740E+01, 5.3553054027E+00, 4.1720004646E+01, 4.3915476448E+00, 9.8698102884E-01],
	[5.0000000000E+04, 5.8799087996E+01, 5.3553601255E+00, 4.1733605574E+01, 4.3917941103E+00, 9.8698575474E-01],
	[5.0005000000E+04, 5.8809664096E+01, 5.3554148435E+00, 4.1747232802E+01, 4.3920407757E+00, 9.8699047854E-01],
	[5.0010000000E+04, 5.8820241040E+01, 5.3554695565E+00, 4.1760863114E+01, 4.3922873839E+00, 9.8699520025E-01],
	[5.0015000000E+04, 5.8830818830E+01, 5.3555242646E+00, 4.1774496509E+01, 4.3925339348E+00, 9.8699991987E-01],
	[5.0020000000E+04, 5.8841397463E+01, 5.3555789678E+00, 4.1788132988E+01, 4.3927804286E+00, 9.8700463739E-01],
	[5.0025000000E+04, 5.8851976