import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

connective_Woodard_MFP = np.array([
	[5.0000000000E+03, 1.7396537733E+00, 7.2535965166E+00, 2.2865031451E-02, 2.2498404833E-02, 3.4288517487E-01],
	[5.0050000000E+03, 1.7416357730E+00, 7.2499601232E+00, 2.2934050678E-02, 2.2565523094E-02, 3.4314298239E-01],
	[5.0100000000E+03, 1.7436180483E+00, 7.2463291810E+00, 2.3003208816E-02, 2.2632772205E-02, 3.4340051192E-01],
	[5.0150000000E+03, 1.7456005991E+00, 7.2427036764E+00, 2.3072506005E-02, 2.2700152279E-02, 3.4365776409E-01],
	[5.0200000000E+03, 1.7475834251E+00, 7.2390835959E+00, 2.3141942386E-02, 2.2767663428E-02, 3.4391473951E-01],
	[5.0250000000E+03, 1.7495665261E+00, 7.2354689259E+00, 2.3211518097E-02, 2.2835305765E-02, 3.4417143881E-01],
	[5.0300000000E+03, 1.7515499019E+00, 7.2318596531E+00, 2.3281233280E-02, 2.2903079403E-02, 3.4442786260E-01],
	[5.0350000000E+03, 1.7535335521E+00, 7.2282557639E+00, 2.3351088073E-02, 2.2970984456E-02, 3.4468401149E-01],
	[5.0400000000E+03, 1.7555174767E+00, 7.2246572451E+00, 2.3421082616E-02, 2.3039021035E-02, 3.4493988610E-01],
	[5.0450000000E+03, 1.7575016753E+00, 7.2210640833E+00, 2.3491217050E-02, 2.3107189254E-02, 3.4519548704E-01],
	[5.0500000000E+03, 1.7594861477E+00, 7.2174762653E+00, 2.3561491515E-02, 2.3175489226E-02, 3.4545081490E-01],
	[5.0550000000E+03, 1.7614708936E+00, 7.2138937777E+00, 2.3631906150E-02, 2.3243921062E-02, 3.4570587036E-01],
	[5.0600000000E+03, 1.7634559129E+00, 7.2103166075E+00, 2.3702461095E-02, 2.3312484876E-02, 3.4596065415E-01],
	[5.0650000000E+03, 1.7654412054E+00, 7.2067447415E+00, 2.3773156490E-02, 2.3381180779E-02, 3.4621516694E-01],
	[5.0700000000E+03, 1.7674267707E+00, 7.2031781667E+00, 2.3843992475E-02, 2.3450008885E-02, 3.4646940942E-01],
	[5.0750000000E+03, 1.7694126086E+00, 7.1996168698E+00, 2.3914969189E-02, 2.3518969305E-02, 3.4672338228E-01],
	[5.0800000000E+03, 1.7713987190E+00, 7.1960608381E+00, 2.3986086774E-02, 2.3588062152E-02, 3.4697708620E-01],
	[5.0850000000E+03, 1.7733973895E+00, 7.1925606929E+00, 2.4057345368E-02, 2.3657290273E-02, 3.4723052185E-01],
	[5.0900000000E+03, 1.7753975409E+00, 7.1890705978E+00, 2.4128745111E-02, 2.3726651337E-02, 3.4748368990E-01],
	[5.0950000000E+03, 1.7773979811E+00, 7.1855856203E+00, 2.4200286144E-02, 2.3796145191E-02, 3.4773659104E-01],
	[5.1000000000E+03, 1.7793987098E+00, 7.1821057481E+00, 2.4271968606E-02, 2.3865771948E-02, 3.4798922593E-01],
	[5.1050000000E+03, 1.7813997268E+00, 7.1786309686E+00, 2.4343792638E-02, 2.3935531720E-02, 3.4824159523E-01],
	[5.1100000000E+03, 1.7834010318E+00, 7.1751612695E+00, 2.4415758378E-02, 2.4005424619E-02, 3.4849369961E-01],
	[5.1150000000E+03, 1.7854026246E+00, 7.1716966382E+00, 2.4487865967E-02, 2.4075450756E-02, 3.4874553974E-01],
	[5.1200000000E+03, 1.7874045050E+00, 7.1682370626E+00, 2.4560115544E-02, 2.4145610245E-02, 3.4899711627E-01],
	[5.1250000000E+03, 1.7894066727E+00, 7.1647825302E+00, 2.4632507251E-02, 2.4215903196E-02, 3.4924842986E-01],
	[5.1300000000E+03, 1.7914091274E+00, 7.1613330288E+00, 2.4705041226E-02, 2.4286329722E-02, 3.4949948117E-01],
	[5.1350000000E+03, 1.7934118690E+00, 7.1578885462E+00, 2.4777717609E-02, 2.4356889933E-02, 3.4975027085E-01],
	[5.1400000000E+03, 1.7954148972E+00, 7.1544490703E+00, 2.4850536541E-02, 2.4427583942E-02, 3.5000079954E-01],
	[5.1450000000E+03, 1.7974182117E+00, 7.1510145888E+00, 2.4923498160E-02, 2.4498411860E-02, 3.5025106790E-01],
	[5.1500000000E+03, 1.7994218124E+00, 7.1475850897E+00, 2.4996602608E-02, 2.4569373798E-02, 3.5050107657E-01],
	[5.1550000000E+03, 1.8014256989E+00, 7.1441605610E+00, 2.5069850024E-02, 2.4640469869E-02, 3.5075082620E-01],
	[5.1600000000E+03, 1.8034298711E+00, 7.1407409905E+00, 2.5143240547E-02, 2.4711700182E-02, 3.5100031742E-01],
	[5.1650000000E+03, 1.8054415809E+00, 7.1373561102E+00, 2.5216774318E-02, 2.4783066576E-02, 3.5124955087E-01],
	[5.1700000000E+03, 1.8074594300E+00, 7.1340000413E+00, 2.5290451477E-02, 2.4854568846E-02, 3.5149852719E-01],
	[5.1750000000E+03, 1.8094775804E+00, 7.1306487924E+00, 2.5364272163E-02, 2.4926205722E-02, 3.5174724702E-01],
	[5.1800000000E+03, 1.8114960321E+00, 7.1273023518E+00, 2.5438236516E-02, 2.4997977313E-02, 3.5199571098E-01],
	[5.1850000000E+03, 1.8135147846E+00, 7.1239607080E+00, 2.5512344676E-02, 2.5069883732E-02, 3.5224391970E-01],
	[5.1900000000E+03, 1.8155338379E+00, 7.1206238495E+00, 2.5586596784E-02, 2.5141925090E-02, 3.5249187381E-01],
	[5.1950000000E+03, 1.8175531916E+00, 7.1172917649E+00, 2.5660992978E-02, 2.5214101497E-02, 3.5273957394E-01],
	[5.2000000000E+03, 1.8195728454E+00, 7.1139644428E+00, 2.5735533399E-02, 2.5286413064E-02, 3.5298702070E-01],
	[5.2050000000E+03, 1.8215927993E+00, 7.1106418718E+00, 2.5810218187E-02, 2.5358859903E-02, 3.5323421472E-01],
	[5.2100000000E+03, 1.8236130528E+00, 7.1073240405E+00, 2.5885047481E-02, 2.5431442123E-02, 3.5348115662E-01],
	[5.2150000000E+03, 1.8256336058E+00, 7.1040109377E+00, 2.5960021422E-02, 2.5504159837E-02, 3.5372784700E-01],
	[5.2200000000E+03, 1.8276544580E+00, 7.1007025520E+00, 2.6035140149E-02, 2.5577013153E-02, 3.5397428649E-01],
	[5.2250000000E+03, 1.8296756092E+00, 7.0973988724E+00, 2.6110403802E-02, 2.5650002184E-02, 3.5422047569E-01],
	[5.2300000000E+03, 1.8316970591E+00, 7.0940998875E+00, 2.6185812521E-02, 2.5723127040E-02, 3.5446641522E-01],
	[5.2350000000E+03, 1.8337188076E+00, 7.0908055862E+00, 2.6261366446E-02, 2.5796387830E-02, 3.5471210568E-01],
	[5.2400000000E+03, 1.8357408542E+00, 7.0875159574E+00, 2.6337065717E-02, 2.5869784666E-02, 3.5495754767E-01],
	[5.2450000000E+03, 1.8377631989E+00, 7.0842309901E+00, 2.6412910474E-02, 2.5943317657E-02, 3.5520274180E-01],
	[5.2500000000E+03, 1.8397977004E+00, 7.0809990701E+00, 2.6488900856E-02, 2.6016989940E-02, 3.5544768867E-01],
	[5.2550000000E+03, 1.8418333678E+00, 7.0777751766E+00, 2.6565037003E-02, 2.6090798844E-02, 3.5569238887E-01],
	[5.2600000000E+03, 1.8438693484E+00, 7.0745558148E+00, 2.6641319056E-02, 2.6164744263E-02, 3.5593684301E-01],
	[5.2650000000E+03, 1.8459056419E+00, 7.0713409740E+00, 2.6717747154E-02, 2.6238826307E-02, 3.5618105167E-01],
	[5.2700000000E+03, 1.8479422481E+00, 7.0681306437E+00, 2.6794321436E-02, 2.6313045087E-02, 3.5642501546E-01],
	[5.2750000000E+03, 1.8499791669E+00, 7.0649248131E+00, 2.6871042044E-02, 2.6387400712E-02, 3.5666873495E-01],
	[5.2800000000E+03, 1.8520163978E+00, 7.0617234717E+00, 2.6947909116E-02, 2.6461893293E-02, 3.5691221074E-01],
	[5.2850000000E+03, 1.8540539407E+00, 7.0585266091E+00, 2.7024922793E-02, 2.6536522939E-02, 3.5715544341E-01],
	[5.2900000000E+03, 1.8560917953E+00, 7.0553342147E+00, 2.7102083215E-02, 2.6611289761E-02, 3.5739843355E-01],
	[5.2950000000E+03, 1.8581299614E+00, 7.0521462781E+00, 2.7179390520E-02, 2.6686193867E-02, 3.5764118173E-01],
	[5.3000000000E+03, 1.8601684387E+00, 7.0489627887E+00, 2.7256844850E-02, 2.6761235369E-02, 3.5788368855E-01],
	[5.3050000000E+03, 1.8622072270E+00, 7.0457837364E+00, 2.7334446344E-02, 2.6836414375E-02, 3.5812595457E-01],
	[5.3100000000E+03, 1.8642463260E+00, 7.0426091106E+00, 2.7412195142E-02, 2.6911730994E-02, 3.5836798037E-01],
	[5.3150000000E+03, 1.8662857355E+00, 7.0394389010E+00, 2.7490091384E-02, 2.6987185337E-02, 3.5860976652E-01],
	[5.3200000000E+03, 1.8683254553E+00, 7.0362730975E+00, 2.7568135210E-02, 2.7062777514E-02, 3.5885131360E-01],
	[5.3250000000E+03, 1.8703654850E+00, 7.0331116896E+00, 2.7646326759E-02, 2.7138507632E-02, 3.5909262216E-01],
	[5.3300000000E+03, 1.8724063710E+00, 7.0299568927E+00, 2.7724666171E-02, 2.7214375950E-02, 3.5933369242E-01],
	[5.3350000000E+03, 1.8744593480E+00, 7.0268543740E+00, 2.7803153587E-02, 2.7290385651E-02, 3.5957452493E-01],
	[5.3400000000E+03, 1.8765126497E+00, 7.0237561289E+00, 2.7881789145E-02, 2.7366533651E-02, 3.5981512033E-01],
	[5.3450000000E+03, 1.8785662757E+00, 7.0206621477E+00, 2.7960572987E-02, 2.7442820059E-02, 3.6005547927E-01],
	[5.3500000000E+03, 1.8806202259E+00, 7.0175724203E+00, 2.8039505252E-02, 2.7519244985E-02, 3.6029560239E-01],
	[5.3550000000E+03, 1.8826745000E+00, 7.0144869371E+00, 2.8118586079E-02, 2.7595808538E-02, 3.6053549035E-01],
	[5.3600000000E+03, 1.8847290976E+00, 7.0114056881E+00, 2.8197815609E-02, 2.7672510827E-02, 3.6077514377E-01],
	[5.3650000000E+03, 1.8867840187E+00, 7.0083286638E+00, 2.8277193981E-02, 2.7749351960E-02, 3.6101456331E-01],
	[5.3700000000E+03, 1.8888392629E+00, 7.0052558543E+00, 2.8356721336E-02, 2.7826332047E-02, 3.6125374959E-01],
	[5.3750000000E+03, 1.8908948299E+00, 7.0021872499E+00, 2.8436397813E-02, 2.7903451197E-02, 3.6149270324E-01],
	[5.3800000000E+03, 1.8929507196E+00, 6.9991228410E+00, 2.8516223552E-02, 2.7980709518E-02, 3.6173142491E-01],
	[5.3850000000E+03, 1.8950069317E+00, 6.9960626180E+00, 2.8596198693E-02, 2.8058107118E-02, 3.6196991521E-01],
	[5.3900000000E+03, 1.8970634659E+00, 6.9930065713E+00, 2.8676323375E-02, 2.8135644108E-02, 3.6220817478E-01],
	[5.3950000000E+03, 1.8991203219E+00, 6.9899546913E+00, 2.8756597739E-02, 2.8213320594E-02, 3.6244620424E-01],
	[5.4000000000E+03, 1.9011774996E+00, 6.9869069684E+00, 2.8837021925E-02, 2.8291136685E-02, 3.6268400420E-01],
	[5.4050000000E+03, 1.9032349987E+00, 6.9838633932E+00, 2.8917596072E-02, 2.8369092491E-02, 3.6292157530E-01],
	[5.4100000000E+03, 1.9052928189E+00, 6.9808239563E+00, 2.8998320320E-02, 2.8447188118E-02, 3.6315891814E-01],
	[5.4150000000E+03, 1.9073509600E+00, 6.9777886480E+00, 2.9079194809E-02, 2.8525423676E-02, 3.6339603335E-01],
	[5.4200000000E+03, 1.9094199762E+00, 6.9748002887E+00, 2.9160219679E-02, 2.8603802361E-02, 3.6363292153E-01],
	[5.4250000000E+03, 1.9114907129E+00, 6.9718215827E+00, 2.9241395070E-02, 2.8682321627E-02, 3.6386958330E-01],
	[5.4300000000E+03, 1.9135617844E+00, 6.9688468911E+00, 2.9322721122E-02, 2.8760981177E-02, 3.6410601926E-01],
	[5.4350000000E+03, 1.9156331907E+00, 6.9658762048E+00, 2.9404197974E-02, 2.8839781121E-02, 3.6434223002E-01],
	[5.4400000000E+03, 1.9177049314E+00, 6.9629095148E+00, 2.9485825766E-02, 2.8918721566E-02, 3.6457821618E-01],
	[5.4450000000E+03, 1.9197770063E+00, 6.9599468120E+00, 2.9567604638E-02, 2.8997802619E-02, 3.6481397834E-01],
	[5.4500000000E+03, 1.9218494151E+00, 6.9569880875E+00, 2.9649534731E-02, 2.9077024390E-02, 3.6504951711E-01],
	[5.4550000000E+03, 1.9239221576E+00, 6.9540333321E+00, 2.9731616183E-02, 2.9156386985E-02, 3.6528483307E-01],
	[5.4600000000E+03, 1.9259952335E+00, 6.9510825371E+00, 2.9813849136E-02, 2.9235890513E-02, 3.6551992684E-01],
	[5.4650000000E+03, 1.9280686426E+00, 6.9481356934E+00, 2.9896233727E-02, 2.9315535080E-02, 3.6575479899E-01],
	[5.4700000000E+03, 1.9301423846E+00, 6.9451927921E+00, 2.9978770099E-02, 2.9395320796E-02, 3.6598945011E-01],
	[5.4750000000E+03, 1.9322164593E+00, 6.9422538244E+00, 3.0061458389E-02, 2.9475247766E-02, 3.6622388081E-01],
	[5.4800000000E+03, 1.9342908664E+00, 6.9393187814E+00, 3.0144617340E-02, 2.9555622372E-02, 3.6645809165E-01],
	[5.4850000000E+03, 1.9363656056E+00, 6.9363876544E+00, 3.0228187041E-02, 2.9636386926E-02, 3.6669208324E-01],
	[5.4900000000E+03, 1.9384406768E+00, 6.9334604345E+00, 3.0311911734E-02, 2.9717295520E-02, 3.6692585614E-01],
	[5.4950000000E+03, 1.9405160797E+00, 6.9305371129E+00, 3.0395791565E-02, 2.9798348268E-02, 3.6715941094E-01],
	[5.5000000000E+03, 1.9425918140E+00, 6.9276176810E+00, 3.0479826680E-02, 2.9879545279E-02, 3.6739274821E-01],
	[5.5050000000E+03, 1.9446730451E+00, 6.9247230804E+00, 3.0564017224E-02, 2.9960888284E-02, 3.6762586854E-01],
	[5.5100000000E+03, 1.9467610024E+00, 6.9218581880E+00, 3.0648363342E-02, 3.0042377800E-02, 3.6785877250E-01],
	[5.5150000000E+03, 1.9488493047E+00, 6.9189970778E+00, 3.0732865179E-02, 3.0124011945E-02, 3.6809146065E-01],
	[5.5200000000E+03, 1.9509379515E+00, 6.9161397414E+00, 3.0817522881E-02, 3.0205790831E-02, 3.6832393357E-01],
	[5.5250000000E+03, 1.9530269428E+00, 6.9132861703E+00, 3.0902336592E-02, 3.0287714570E-02, 3.6855619182E-01],
	[5.5300000000E+03, 1.9551162782E+00, 6.9104363563E+00, 3.0987306459E-02, 3.0369783272E-02, 3.6878823597E-01],
	[5.5350000000E+03, 1.9572059575E+00, 6.9075902909E+00, 3.1072432626E-02, 3.0451997049E-02, 3.6902006659E-01],
	[5.5400000000E+03, 1.9592959804E+00, 6.9047479660E+00, 3.1157715238E-02, 3.0534356013E-02, 3.6925168423E-01],
	[5.5450000000E+03, 1.9613863468E+00, 6.9019093731E+00, 3.1243154441E-02, 3.0616860274E-02, 3.6948308945E-01],
	[5.5500000000E+03, 1.9634770562E+00, 6.8990745041E+00, 3.1328750380E-02, 3.0699509943E-02, 3.6971428282E-01],
	[5.5550000000E+03, 1.9655681085E+00, 6.8962433506E+00, 3.1414503201E-02, 3.0782305131E-02, 3.6994526489E-01],
	[5.5600000000E+03, 1.9676595035E+00, 6.8934159046E+00, 3.1500413048E-02, 3.0865245949E-02, 3.7017603620E-01],
	[5.5650000000E+03, 1.9697512408E+00, 6.8905921578E+00, 3.1586480067E-02, 3.0948332508E-02, 3.7040659732E-01],
	[5.5700000000E+03, 1.9718433202E+00, 6.8877721020E+00, 3.1672704403E-02, 3.1031564919E-02, 3.7063694880E-01],
	[5.5750000000E+03, 1.9739357415E+00, 6.8849557291E+00, 3.1759086201E-02, 3.1114943292E-02, 3.7086709117E-01],
	[5.5800000000E+03, 1.9760285044E+00, 6.8821430311E+00, 3.1845625607E-02, 3.1198467738E-02, 3.7109702499E-01],
	[5.5850000000E+03, 1.9781216087E+00, 6.8793339998E+00, 3.1932322767E-02, 3.1282138367E-02, 3.7132675081E-01],
	[5.5900000000E+03, 1.9802150541E+00, 6.8765286271E+00, 3.2019177824E-02, 3.1365955290E-02, 3.7155626915E-01],
	[5.5950000000E+03, 1.9823169887E+00, 6.8737599379E+00, 3.2106190925E-02, 3.1449921359E-02, 3.7178558057E-01],
	[5.6000000000E+03, 1.9844222921E+00, 6.8710070533E+00, 3.2193362215E-02, 3.1534034985E-02, 3.7201468560E-01],
	[5.6050000000E+03, 1.9865279496E+00, 6.8682577266E+00, 3.2280691839E-02, 3.1618295268E-02, 3.7224358478E-01],
	[5.6100000000E+03, 1.9886339609E+00, 6.8655119500E+00, 3.2368179942E-02, 3.1702702317E-02, 3.7247227865E-01],
	[5.6150000000E+03, 1.9907403257E+00, 6.8627697157E+00, 3.2455826670E-02, 3.1787256243E-02, 3.7270076772E-01],
	[5.6200000000E+03, 1.9928470438E+00, 6.8600310161E+00, 3.2543632168E-02, 3.1871957156E-02, 3.7292905255E-01],
	[5.6250000000E+03, 1.9949541148E+00, 6.8572958435E+00, 3.2631596581E-02, 3.1956805166E-02, 3.7315713365E-01],
	[5.6300000000E+03, 1.9970615386E+00, 6.8545641901E+00, 3.2719720055E-02, 3.2041800383E-02, 3.7338501156E-01],
	[5.6350000000E+03, 1.9991693149E+00, 6.8518360484E+00, 3.2808002735E-02, 3.2126942916E-02, 3.7361268680E-01],
	[5.6400000000E+03, 2.0012774435E+00, 6.8491114106E+00, 3.2896444766E-02, 3.2212232877E-02, 3.7384015989E-01],
	[5.6450000000E+03, 2.0033859240E+00, 6.8463902693E+00, 3.2985046293E-02, 3.2297670374E-02, 3.7406743135E-01],
	[5.6500000000E+03, 2.0054947563E+00, 6.8436726168E+00, 3.3073807463E-02, 3.2383255517E-02, 3.7429450171E-01],
	[5.6550000000E+03, 2.0076039401E+00, 6.8409584455E+00, 3.3162728419E-02, 3.2468988416E-02, 3.7452137149E-01],
	[5.6600000000E+03, 2.0097134751E+00, 6.8382477480E+00, 3.3251809308E-02, 3.2554869180E-02, 3.7474804120E-01],
	[5.6650000000E+03, 2.0118233611E+00, 6.8355405168E+00, 3.3341050274E-02, 3.2640897918E-02, 3.7497451135E-01],
	[5.6700000000E+03, 2.0139335978E+00, 6.8328367442E+00, 3.3430451464E-02, 3.2727074741E-02, 3.7520078246E-01],
	[5.6750000000E+03, 2.0160441850E+00, 6.8301364230E+00, 3.3520013022E-02, 3.2813399758E-02, 3.7542685505E-01],
	[5.6800000000E+03, 2.0181551224E+00, 6.8274395456E+00, 3.3609735094E-02, 3.2899873076E-02, 3.7565272961E-01],
	[5.6850000000E+03, 2.0202742458E+00, 6.8247779133E+00, 3.3699617824E-02, 3.2986497639E-02, 3.7587840667E-01],
	[5.6900000000E+03, 2.0223966698E+00, 6.8221315802E+00, 3.3789661359E-02, 3.3073271813E-02, 3.7610388672E-01],
	[5.6950000000E+03, 2.0245194564E+00, 6.8194885964E+00, 3.3879865844E-02, 3.3160194649E-02, 3.7632917027E-01],
	[5.7000000000E+03, 2.0266426054E+00, 6.8168489545E+00, 3.3970231424E-02, 3.3247266257E-02, 3.7655425782E-01],
	[5.7050000000E+03, 2.0287661164E+00, 6.8142126475E+00, 3.4060758244E-02, 3.3334486745E-02, 3.7677914988E-01],
	[5.7100000000E+03, 2.0308899892E+00, 6.8115796682E+00, 3.4151446450E-02, 3.3421856223E-02, 3.7700384694E-01],
	[5.7150000000E+03, 2.0330142235E+00, 6.8089500095E+00, 3.4242296187E-02, 3.3509374798E-02, 3.7722834951E-01],
	[5.7200000000E+03, 2.0351388191E+00, 6.8063236643E+00, 3.4333307600E-02, 3.3597042581E-02, 3.7745265808E-01],
	[5.7250000000E+03, 2.0372637758E+00, 6.8037006256E+00, 3.4424480835E-02, 3.3684859679E-02, 3.7767677314E-01],
	[5.7300000000E+03, 2.0393890933E+00, 6.8010808863E+00, 3.4515816036E-02, 3.3772826202E-02, 3.7790069519E-01],
	[5.7350000000E+03, 2.0415147713E+00, 6.7984644394E+00, 3.4607313351E-02, 3.3860942257E-02, 3.7812442471E-01],
	[5.7400000000E+03, 2.0436408096E+00, 6.7958512779E+00, 3.4698972923E-02, 3.3949207954E-02, 3.7834796221E-01],
	[5.7450000000E+03, 2.0457672079E+00, 6.7932413948E+00, 3.4790794898E-02, 3.4037623400E-02, 3.7857130817E-01],
	[5.7500000000E+03, 2.0478939659E+00, 6.7906347832E+00, 3.4882779421E-02, 3.4126188704E-02, 3.7879446306E-01],
	[5.7550000000E+03, 2.0500210835E+00, 6.7880314360E+00, 3.4974926639E-02, 3.4214903975E-02, 3.7901742739E-01],
	[5.7600000000E+03, 2.0521485604E+00, 6.7854313464E+00, 3.5067236695E-02, 3.4303769320E-02, 3.7924020163E-01],
	[5.7650000000E+03, 2.0542763963E+00, 6.7828345076E+00, 3.5159709736E-02, 3.4392784847E-02, 3.7946278627E-01],
	[5.7700000000E+03, 2.0564045909E+00, 6.7802409125E+00, 3.5252345907E-02, 3.4481950665E-02, 3.7968518178E-01],
	[5.7750000000E+03, 2.0585376582E+00, 6.7776689367E+00, 3.5345145353E-02, 3.4571268632E-02, 3.7990738865E-01],
	[5.7800000000E+03, 2.0606769618E+00, 6.7751240421E+00, 3.5438108219E-02, 3.4660739407E-02, 3.8012940735E-01],
	[5.7850000000E+03, 2.0628166360E+00, 6.7725823023E+00, 3.5531234652E-02, 3.4750360829E-02, 3.8035123836E-01],
	[5.7900000000E+03, 2.0649566805E+00, 6.7700437107E+00, 3.5624524796E-02, 3.4840133006E-02, 3.8057288215E-01],
	[5.7950000000E+03, 2.0670970950E+00, 6.7675082607E+00, 3.5717978796E-02, 3.4930056046E-02, 3.8079433920E-01],
	[5.8000000000E+03, 2.0692378792E+00, 6.7649759456E+00, 3.5811596799E-02, 3.5020130056E-02, 3.8101560997E-01],
	[5.8050000000E+03, 2.0713790330E+00, 6.7624467591E+00, 3.5905378949E-02, 3.5110355144E-02, 3.8123669494E-01],
	[5.8100000000E+03, 2.0735205561E+00, 6.7599206944E+00, 3.5999325392E-02, 3.5200731418E-02, 3.8145759457E-01],
	[5.8150000000E+03, 2.0756624482E+00, 6.7573977450E+00, 3.6093436273E-02, 3.5291258985E-02, 3.8167830934E-01],
	[5.8200000000E+03, 2.0778047090E+00, 6.7548779044E+00, 3.6187711738E-02, 3.5381937952E-02, 3.8189883970E-01],
	[5.8250000000E+03, 2.0799473384E+00, 6.7523611662E+00, 3.6282151931E-02, 3.5472768428E-02, 3.8211918612E-01],
	[5.8300000000E+03, 2.0820903360E+00, 6.7498475238E+00, 3.6376756999E-02, 3.5563750518E-02, 3.8233934907E-01],
	[5.8350000000E+03, 2.0842337016E+00, 6.7473369708E+00, 3.6471527087E-02, 3.5654884330E-02, 3.8255932908E-01],
	[5.8400000000E+03, 2.0863774349E+00, 6.7448295008E+00, 3.6566462340E-02, 3.5746169972E-02, 3.8277912689E-01],
	[5.8450000000E+03, 2.0885215358E+00, 6.7423251073E+00, 3.6661562903E-02, 3.5837607550E-02, 3.8299874303E-01],
	[5.8500000000E+03, 2.0906660039E+00, 6.7398237839E+00, 3.6756828922E-02, 3.5929197171E-02, 3.8321817801E-01],
	[5.8550000000E+03, 2.0928108390E+00, 6.7373255242E+00, 3.6852260543E-02, 3.6020938942E-02, 3.8343743233E-01],
	[5.8600000000E+03, 2.0949560408E+00, 6.7348303219E+00, 3.6947857910E-02, 3.6112832970E-02, 3.8365650651E-01],
	[5.8650000000E+03, 2.0971016092E+00, 6.7323381707E+00, 3.7043621170E-02, 3.6204879362E-02, 3.8387540103E-01],
	[5.8700000000E+03, 2.0992560165E+00, 6.7298836963E+00, 3.7139550466E-02, 3.6297081763E-02, 3.8409411642E-01],
	[5.8750000000E+03, 2.1014123217E+00, 6.7274384168E+00, 3.7235645946E-02, 3.6389437409E-02, 3.8431265316E-01],
	[5.8800000000E+03, 2.1035690046E+00, 6.7249961049E+00, 3.7331907754E-02, 3.6481945770E-02, 3.8453101175E-01],
	[5.8850000000E+03, 2.1057260650E+00, 6.7225567544E+00, 3.7428336036E-02, 3.6574606956E-02, 3.8474919270E-01],
	[5.8900000000E+03, 2.1078835025E+00, 6.7201203593E+00, 3.7524930937E-02, 3.6667421071E-02, 3.8496719650E-01],
	[5.8950000000E+03, 2.1100413170E+00, 6.7176869133E+00, 3.7621692603E-02, 3.6760388222E-02, 3.8518502364E-01],
	[5.9000000000E+03, 2.1121995082E+00, 6.7152564106E+00, 3.7718621178E-02, 3.6853508516E-02, 3.8540267462E-01],
	[5.9050000000E+03, 2.1143580758E+00, 6.7128288450E+00, 3.7815716809E-02, 3.6946782059E-02, 3.8562014992E-01],
	[5.9100000000E+03, 2.1165170196E+00, 6.7104042105E+00, 3.7912979641E-02, 3.7040208956E-02, 3.8583745004E-01],
	[5.9150000000E+03, 2.1186763393E+00, 6.7079825011E+00, 3.8010409819E-02, 3.7133789315E-02, 3.8605457546E-01],
	[5.9200000000E+03, 2.1208360347E+00, 6.7055637107E+00, 3.8108007488E-02, 3.7227523240E-02, 3.8627152666E-01],
	[5.9250000000E+03, 2.1229961056E+00, 6.7031478335E+00, 3.8205772795E-02, 3.7321410838E-02, 3.8648830414E-01],
	[5.9300000000E+03, 2.1251565516E+00, 6.7007348634E+00, 3.8303705884E-02, 3.7415452214E-02, 3.8670490836E-01],
	[5.9350000000E+03, 2.1273173725E+00, 6.6983247946E+00, 3.8401806901E-02, 3.7509647475E-02, 3.8692133983E-01],
	[5.9400000000E+03, 2.1294785681E+00, 6.6959176209E+00, 3.8500075991E-02, 3.7603996726E-02, 3.8713759900E-01],
	[5.9450000000E+03, 2.1316401381E+00, 6.6935133367E+00, 3.8598513300E-02, 3.7698500072E-02, 3.8735368637E-01],
	[5.9500000000E+03, 2.1338020822E+00, 6.6911119359E+00, 3.8697118974E-02, 3.7793157619E-02, 3.8756960240E-01],
	[5.9550000000E+03, 2.1359644003E+00, 6.6887134127E+00, 3.8795893157E-02, 3.7887969473E-02, 3.8778534757E-01],
	[5.9600000000E+03, 2.1381270921E+00, 6.6863177613E+00, 3.8894835995E-02, 3.7982935738E-02, 3.8800092236E-01],
	[5.9650000000E+03, 2.1402993923E+00, 6.6839629305E+00, 3.8993947633E-02, 3.8078060675E-02, 3.8821632723E-01],
	[5.9700000000E+03, 2.1424724449E+00, 6.6816124128E+00, 3.9093228218E-02, 3.8173340434E-02, 3.8843156265E-01],
	[5.9750000000E+03, 2.1446458818E+00, 6.6792646884E+00, 3.9192677894E-02, 3.8268774954E-02, 3.8864662910E-01],
	[5.9800000000E+03, 2.1468197028E+00, 6.6769197518E+00, 3.9292296807E-02, 3.8364364342E-02, 3.8886152704E-01],
	[5.9850000000E+03, 2.1489939076E+00, 6.6745775971E+00, 3.9392085102E-02, 3.8460108701E-02, 3.8907625693E-01],
	[5.9900000000E+03, 2.1511684960E+00, 6.6722382189E+00, 3.9492042925E-02, 3.8556008137E-02, 3.8929081924E-01],
	[5.9950000000E+03, 2.1533434676E+00, 6.6699016116E+00, 3.9592170422E-02, 3.8652062756E-02, 3.8950521443E-01],
	[6.0000000000E+03, 2.1555188224E+00, 6.6675677694E+00, 3.9692467736E-02, 3.8748272661E-02, 3.8971944296E-01],
	[6.0050000000E+03, 2.1576945599E+00, 6.6652366870E+00, 3.9793476112E-02, 3.8845153572E-02, 3.8993350529E-01],
	[6.0100000000E+03, 2.1598706800E+00, 6.6629083586E+00, 3.9894656923E-02, 3.8942192104E-02, 3.9014740187E-01],
	[6.0150000000E+03, 2.1620471824E+00, 6.6605827788E+00, 3.9996010319E-02, 3.9039388365E-02, 3.9036113317E-01],
	[6.0200000000E+03, 2.1642240668E+00, 6.6582599421E+00, 4.0097536451E-02, 3.9136742463E-02, 3.9057469964E-01],
	[6.0250000000E+03, 2.1664013331E+00, 6.6559398429E+00, 4.0199235468E-02, 3.9234254507E-02, 3.9078810172E-01],
	[6.0300000000E+03, 2.1685789809E+00, 6.6536224757E+00, 4.0301107520E-02, 3.9331924604E-02, 3.9100133988E-01],
	[6.0350000000E+03, 2.1707570100E+00, 6.6513078351E+00, 4.0403152758E-02, 3.9429752861E-02, 3.9121441457E-01],
	[6.0400000000E+03, 2.1729354201E+00, 6.6489959156E+00, 4.0505371330E-02, 3.9527739387E-02, 3.9142732622E-01],
	[6.0450000000E+03, 2.1751142111E+00, 6.6466867117E+00, 4.0607763388E-02, 3.9625884290E-02, 3.9164007530E-01],
	[6.0500000000E+03, 2.1772933826E+00, 6.6443802180E+00, 4.0710329081E-02, 3.9724187676E-02, 3.9185266224E-01],
	[6.0550000000E+03, 2.1794729344E+00, 6.6420764292E+00, 4.0813068560E-02, 3.9822649654E-02, 3.9206508749E-01],
	[6.0600000000E+03, 2.1816600057E+00, 6.6398047121E+00, 4.0915981973E-02, 3.9921273783E-02, 3.9227735149E-01],
	[6.0650000000E+03, 2.1838495812E+00, 6.6375443387E+00, 4.1019069472E-02, 4.0020057772E-02, 3.9248945469E-01],
	[6.0700000000E+03, 2.1860395473E+00, 6.6352865966E+00, 4.1122331205E-02, 4.0119000710E-02, 3.9270139752E-01],
	[6.0750000000E+03, 2.1882299035E+00, 6.6330314805E+00, 4.1225767324E-02, 4.0218102704E-02, 3.9291318043E-01],
	[6.0800000000E+03, 2.1904206497E+00, 6.6307789851E+00, 4.1329377979E-02, 4.0317363862E-02, 3.9312480385E-01],
	[6.0850000000E+03, 2.1926117856E+00, 6.6285291054E+00, 4.1433163318E-02, 4.0416784290E-02, 3.9333626821E-01],
	[6.0900000000E+03, 2.1948033109E+00, 6.6262818361E+00, 4.1537123493E-02, 4.0516364096E-02, 3.9354757396E-01],
	[6.0950000000E+03, 2.1969952254E+00, 6.6240371720E+00, 4.1641258653E-02, 4.0616103386E-02, 3.9375872153E-01],
	[6.1000000000E+03, 2.1991875289E+00, 6.6217951080E+00, 4.1745568948E-02, 4.0716002268E-02, 3.9396971135E-01],
	[6.1050000000E+03, 2.2013802211E+00, 6.6195556390E+00, 4.1850054528E-02, 4.0816060849E-02, 3.9418054384E-01],
	[6.1100000000E+03, 2.2035733017E+00, 6.6173187598E+00, 4.1954715544E-02, 4.0916279234E-02, 3.9439121945E-01],
	[6.1150000000E+03, 2.2057667706E+00, 6.6150844653E+00, 4.2059552146E-02, 4.1016657532E-02, 3.9460173859E-01],
	[6.1200000000E+03, 2.2079606273E+00, 6.6128527505E+00, 4.2164564482E-02, 4.1117195847E-02, 3.9481210170E-01],
	[6.1250000000E+03, 2.2101548718E+00, 6.6106236101E+00, 4.2269752705E-02, 4.1217894288E-02, 3.9502230919E-01],
	[6.1300000000E+03, 2.2123495038E+00, 6.6083970393E+00, 4.2375116963E-02, 4.1318752960E-02, 3.9523236150E-01],
	[6.1350000000E+03, 2.2145445229E+00, 6.6061730328E+00, 4.2480657406E-02, 4.1419771969E-02, 3.9544225905E-01],
	[6.1400000000E+03, 2.2167399290E+00, 6.6039515858E+00, 4.2586374185E-02, 4.1520951423E-02, 3.9565200226E-01],
	[6.1450000000E+03, 2.2189357219E+00, 6.6017326931E+00, 4.2692267450E-02, 4.1622291426E-02, 3.9586159155E-01],
	[6.1500000000E+03, 2.2211319011E+00, 6.5995163497E+00, 4.2798337351E-02, 4.1723792085E-02, 3.9607102733E-01],
	[6.1550000000E+03, 2.2233309011E+00, 6.5973125400E+00, 4.2904584038E-02, 4.1825454770E-02, 3.9628031004E-01],
	[6.1600000000E+03, 2.2255367979E+00, 6.5951379250E+00, 4.3011007660E-02, 4.1927281720E-02, 3.9648944007E-01],
	[6.1650000000E+03, 2.2277430909E+00, 6.5929657903E+00, 4.3117608369E-02, 4.2029269680E-02, 3.9669841786E-01],
	[6.1700000000E+03, 2.2299497798E+00, 6.5907961310E+00, 4.3224386314E-02, 4.2131418755E-02, 3.9690724380E-01],
	[6.1750000000E+03, 2.2321568644E+00, 6.5886289425E+00, 4.3331341645E-02, 4.2233729053E-02, 3.9711591833E-01],
	[6.1800000000E+03, 2.2343643444E+00, 6.5864642198E+00, 4.3438474513E-02, 4.2336200678E-02, 3.9732444184E-01],
	[6.1850000000E+03, 2.2365722196E+00, 6.5843019581E+00, 4.3545785067E-02, 4.2438833736E-02, 3.9753281474E-01],
	[6.1900000000E+03, 2.2387804896E+00, 6.5821421527E+00, 4.3653273458E-02, 4.2541628333E-02, 3.9774103746E-01],
	[6.1950000000E+03, 2.2409891544E+00, 6.5799847989E+00, 4.3760939835E-02, 4.2644584574E-02, 3.9794911038E-01],
	[6.2000000000E+03, 2.2431982135E+00, 6.5778298917E+00, 4.3868784349E-02, 4.2747702565E-02, 3.9815703393E-01],
	[6.2050000000E+03, 2.2454076669E+00, 6.5756774266E+00, 4.3976807150E-02, 4.2850982410E-02, 3.9836480851E-01],
	[6.2100000000E+03, 2.2476175141E+00, 6.5735273987E+00, 4.4085008389E-02, 4.2954424216E-02, 3.9857243452E-01],
	[6.2150000000E+03, 2.2498277550E+00, 6.5713798033E+00, 4.4193388214E-02, 4.3058028087E-02, 3.9877991236E-01],
	[6.2200000000E+03, 2.2520383894E+00, 6.5692346358E+00, 4.4301946777E-02, 4.3161794128E-02, 3.9898724244E-01],
	[6.2250000000E+03, 2.2542494169E+00, 6.5670918915E+00, 4.4410684227E-02, 4.3265722444E-02, 3.9919442516E-01],
	[6.2300000000E+03, 2.2564608374E+00, 6.5649515656E+00, 4.4519600715E-02, 4.3369813141E-02, 3.9940146091E-01],
	[6.2350000000E+03, 2.2586726505E+00, 6.5628136535E+00, 4.4628696390E-02, 4.3474066322E-02, 3.9960835010E-01],
	[6.2400000000E+03, 2.2608848561E+00, 6.5606781505E+00, 4.4737971404E-02, 4.3578482093E-02, 3.9981509313E-01],
	[6.2450000000E+03, 2.2630974539E+00, 6.5585450520E+00, 4.4847425905E-02, 4.3683060558E-02, 4.0002169038E-01],
	[6.2500000000E+03, 2.2653104437E+00, 6.5564143535E+00, 4.4957060045E-02, 4.3787801822E-02, 4.0022814225E-01],
	[6.2550000000E+03, 2.2675277873E+00, 6.5543022692E+00, 4.5066873973E-02, 4.3892708202E-02, 4.0043444914E-01],
	[6.2600000000E+03, 2.2697501938E+00, 6.5522116316E+00, 4.5176867839E-02, 4.3997780219E-02, 4.0064061145E-01],
	[6.2650000000E+03, 2.2719730015E+00, 6.5501233293E+00, 4.5287041795E-02, 4.4103015386E-02, 4.0084662955E-01],
	[6.2700000000E+03, 2.2741962102E+00, 6.5480373578E+00, 4.5397395989E-02, 4.4208413806E-02, 4.0105250385E-01],
	[6.2750000000E+03, 2.2764198196E+00, 6.5459537125E+00, 4.5507930572E-02, 4.4313975584E-02, 4.0125823473E-01],
	[6.2800000000E+03, 2.2786438295E+00, 6.5438723891E+00, 4.5618645695E-02, 4.4419700824E-02, 4.0146382258E-01],
	[6.2850000000E+03, 2.2808682395E+00, 6.5417933831E+00, 4.5729541507E-02, 4.4525589629E-02, 4.0166926779E-01],
	[6.2900000000E+03, 2.2830930495E+00, 6.5397166901E+00, 4.5840618158E-02, 4.4631642105E-02, 4.0187457074E-01],
	[6.2950000000E+03, 2.2853182592E+00, 6.5376423057E+00, 4.5951875800E-02, 4.4737858354E-02, 4.0207973182E-01],
	[6.3000000000E+03, 2.2875438684E+00, 6.5355702256E+00, 4.6063314581E-02, 4.4844238481E-02, 4.0228475141E-01],
	[6.3050000000E+03, 2.2897698769E+00, 6.5335004452E+00, 4.6174934653E-02, 4.4950782589E-02, 4.0248963003E-01],
	[6.3100000000E+03, 2.2919962843E+00, 6.5314329602E+00, 4.6286736165E-02, 4.5057490783E-02, 4.0269436811E-01],
	[6.3150000000E+03, 2.2942230904E+00, 6.5293677664E+00, 4.6398719268E-02, 4.5164363165E-02, 4.0289896605E-01],
	[6.3200000000E+03, 2.2964502950E+00, 6.5273048593E+00, 4.6510884112E-02, 4.5271399840E-02, 4.0310342424E-01],
	[6.3250000000E+03, 2.2986778979E+00, 6.5252442345E+00, 4.6623230847E-02, 4.5378600910E-02, 4.0330774307E-01],
	[6.3300000000E+03, 2.3009058988E+00, 6.5231858878E+00, 4.6735759623E-02, 4.5485966479E-02, 4.0351192294E-01],
	[6.3350000000E+03, 2.3031342974E+00, 6.5211298149E+00, 4.6848470591E-02, 4.5593496651E-02, 4.0371596423E-01],
	[6.3400000000E+03, 2.3053630936E+00, 6.5190760114E+00, 4.6961363900E-02, 4.5701191527E-02, 4.0391986733E-01],
	[6.3450000000E+03, 2.3075922870E+00, 6.5170244731E+00, 4.7074439702E-02, 4.5809051212E-02, 4.0412363263E-01],
	[6.3500000000E+03, 2.3098218775E+00, 6.5149751956E+00, 4.7187698146E-02, 4.5917075809E-02, 4.0432726051E-01],
	[6.3550000000E+03, 2.3120545848E+00, 6.5129393029E+00, 4.7301139382E-02, 4.6025267053E-02, 4.0453075136E-01],
	[6.3600000000E+03, 2.3142932855E+00, 6.5109285023E+00, 4.7414763561E-02, 4.6133626797E-02, 4.0473410556E-01],
	[6.3650000000E+03, 2.3165323921E+00, 6.5089199020E+00, 4.7528570833E-02, 4.6242151798E-02, 4.0493732350E-01],
	[6.3700000000E+03, 2.3187719042E+00, 6.5069134979E+00, 4.7642561349E-02, 4.6350842160E-02, 4.0514040556E-01],
	[6.3750000000E+03, 2.3210118216E+00, 6.5049092857E+00, 4.7756735258E-02, 4.6459697986E-02, 4.0534335211E-01],
	[6.3800000000E+03, 2.3232521442E+00, 6.5029072615E+00, 4.7871092711E-02, 4.6568719376E-02, 4.0554616353E-01],
	[6.3850000000E+03, 2.3254928716E+00, 6.5009074211E+00, 4.7985633858E-02, 4.6677906436E-02, 4.0574884021E-01],
	[6.3900000000E+03, 2.3277340036E+00, 6.4989097604E+00, 4.8100358849E-02, 4.6787259265E-02, 4.0595138252E-01],
	[6.3950000000E+03, 2.3299755399E+00, 6.4969142754E+00, 4.8215267835E-02, 4.6896777968E-02, 4.0615379083E-01],
	[6.4000000000E+03, 2.3322174804E+00, 6.4949209619E+00, 4.8330360966E-02, 4.7006462647E-02, 4.0635606553E-01],
	[6.4050000000E+03, 2.3344598248E+00, 6.4929298159E+00, 4.8445638392E-02, 4.7116313402E-02, 4.0655820698E-01],
	[6.4100000000E+03, 2.3367025727E+00, 6.4909408335E+00, 4.8561100264E-02, 4.7226330337E-02, 4.0676021556E-01],
	[6.4150000000E+03, 2.3389457241E+00, 6.4889540104E+00, 4.8676746731E-02, 4.7336513554E-02, 4.0696209164E-01],
	[6.4200000000E+03, 2.3411892786E+00, 6.4869693428E+00, 4.8792577945E-02, 4.7446863155E-02, 4.0716383559E-01],
	[6.4250000000E+03, 2.3434332360E+00, 6.4849868266E+00, 4.8908594055E-02, 4.7557379240E-02, 4.0736544777E-01],
	[6.4300000000E+03, 2.3456775961E+00, 6.4830064577E+00, 4.9024795211E-02, 4.7668061913E-02, 4.0756692857E-01],
	[6.4350000000E+03, 2.3479223586E+00, 6.4810282323E+00, 4.9141181565E-02, 4.7778911274E-02, 4.0776827834E-01],
	[6.4400000000E+03, 2.3501675233E+00, 6.4790521463E+00, 4.9257753266E-02, 4.7889927425E-02, 4.0796949745E-01],
	[6.4450000000E+03, 2.3524130899E+00, 6.4770781957E+00, 4.9374510465E-02, 4.8001110468E-02, 4.0817058626E-01],
	[6.4500000000E+03, 2.3546590582E+00, 6.4751063766E+00, 4.9491453312E-02, 4.8112460504E-02, 4.0837154515E-01],
	[6.4550000000E+03, 2.3569054280E+00, 6.4731366851E+00, 4.9608581957E-02, 4.8223977635E-02, 4.0857237447E-01],
	[6.4600000000E+03, 2.3591591653E+00, 6.4711976192E+00, 4.9725896551E-02, 4.8335666475E-02, 4.0877307459E-01],
	[6.4650000000E+03, 2.3614143420E+00, 6.4692648447E+00, 4.9843397244E-02, 4.8447523316E-02, 4.0897364587E-01],
	[6.4700000000E+03, 2.3636699284E+00, 6.4673341410E+00, 4.9961084186E-02, 4.8559547592E-02, 4.0917408866E-01],
	[6.4750000000E+03, 2.3659259245E+00, 6.4654055044E+00, 5.0078957527E-02, 4.8671739407E-02, 4.0937440333E-01],
	[6.4800000000E+03, 2.3681823299E+00, 6.4634789309E+00, 5.0197017419E-02, 4.8784098860E-02, 4.0957459024E-01],
	[6.4850000000E+03, 2.3704391443E+00, 6.4615544168E+00, 5.0315281870E-02, 4.8896642918E-02, 4.0977464974E-01],
	[6.4900000000E+03, 2.3726963676E+00, 6.4596319583E+00, 5.0433736353E-02, 4.9009357817E-02, 4.0997458219E-01],
	[6.4950000000E+03, 2.3749539995E+00, 6.4577115517E+00, 5.0552377923E-02, 4.9122240735E-02, 4.1017438794E-01],
	[6.5000000000E+03, 2.3772120398E+00, 6.4557931931E+00, 5.0671206730E-02, 4.9235291770E-02, 4.1037406735E-01],
	[6.5050000000E+03, 2.3794704882E+00, 6.4538768789E+00, 5.0790222924E-02, 4.9348511026E-02, 4.1057362077E-01],
	[6.5100000000E+03, 2.3817293444E+00, 6.4519626052E+00, 5.0909426657E-02, 4.9461898601E-02, 4.1077304856E-01],
	[6.5150000000E+03, 2.3839886083E+00, 6.4500503683E+00, 5.1028818078E-02, 4.9575454596E-02, 4.1097235106E-01],
	[6.5200000000E+03, 2.3862482796E+00, 6.4481401646E+00, 5.1148397339E-02, 4.9689179112E-02, 4.1117152863E-01],
	[6.5250000000E+03, 2.3885083581E+00, 6.4462319902E+00, 5.1268164590E-02, 4.9803072249E-02, 4.1137058161E-01],
	[6.5300000000E+03, 2.3907688435E+00, 6.4443258415E+00, 5.1388119981E-02, 4.9917134107E-02, 4.1156951036E-01],
	[6.5350000000E+03, 2.3930297355E+00, 6.4424217148E+00, 5.1508263663E-02, 5.0031364787E-02, 4.1176831522E-01],
	[6.5400000000E+03, 2.3952910340E+00, 6.4405196063E+00, 5.1628595786E-02, 5.0145764388E-02, 4.1196699654E-01],
	[6.5450000000E+03, 2.3975527388E+00, 6.4386195125E+00, 5.1749116502E-02, 5.0260333011E-02, 4.1216555466E-01],
	[6.5500000000E+03, 2.3998148494E+00, 6.4367214296E+00, 5.1869825960E-02, 5.0375070755E-02, 4.1236398993E-01],
	[6.5550000000E+03, 2.4020773659E+00, 6.4348253539E+00, 5.1990724312E-02, 5.0489977720E-02, 4.1256230270E-01],
	[6.5600000000E+03, 2.4043409461E+00, 6.4329339845E+00, 5.2111811707E-02, 5.0605054464E-02, 4.1276049330E-01],
	[6.5650000000E+03, 2.4066119519E+00, 6.4310733940E+00, 5.2233088296E-02, 5.0720305540E-02, 4.1295856208E-01],
	[6.5700000000E+03, 2.4088833713E+00, 6.4292147575E+00, 5.2354554231E-02, 5.0835726176E-02, 4.1315650938E-01],
	[6.5750000000E+03, 2.4111552041E+00, 6.4273580714E+00, 5.2476209660E-02, 5.0951316470E-02, 4.1335433554E-01],
	[6.5800000000E+03, 2.4134274501E+00, 6.4255033324E+00, 5.2598054736E-02, 5.1067076523E-02, 4.1355204090E-01],
	[6.5850000000E+03, 2.4157001091E+00, 6.4236505368E+00, 5.2720089609E-02, 5.1183006433E-02, 4.1374962579E-01],
	[6.5900000000E+03, 2.4179731807E+00, 6.4217996812E+00, 5.2842314429E-02, 5.1299106300E-02, 4.1394709057E-01],
	[6.5950000000E+03, 2.4202466647E+00, 6.4199507619E+00, 5.2964729347E-02, 5.1415376224E-02, 4.1414443555E-01],
	[6.6000000000E+03, 2.4225205610E+00, 6.4181037757E+00, 5.3087334513E-02, 5.1531816302E-02, 4.1434166108E-01],
	[6.6050000000E+03, 2.4247948692E+00, 6.4162587189E+00, 5.3210130079E-02, 5.1648426635E-02, 4.1453876750E-01],
	[6.6100000000E+03, 2.4270695892E+00, 6.4144155881E+00, 5.3333116194E-02, 5.1765207322E-02, 4.1473575513E-01],
	[6.6150000000E+03, 2.4293447206E+00, 6.4125743798E+00, 5.3456293009E-02, 5.1882158460E-02, 4.1493262431E-01],
	[6.6200000000E+03, 2.4316202634E+00, 6.4107350906E+00, 5.3579660676E-02, 5.1999280149E-02, 4.1512937538E-01],
	[6.6250000000E+03, 2.4338962171E+00, 6.4088977170E+00, 5.3703219344E-02, 5.2116572487E-02, 4.1532600866E-01],
	[6.6300000000E+03, 2.4361725817E+00, 6.4070622557E+00, 5.3826969164E-02, 5.2234035574E-02, 4.1552252448E-01],
	[6.6350000000E+03, 2.4384493568E+00, 6.4052287030E+00, 5.3950910287E-02, 5.2351669507E-02, 4.1571892318E-01],
	[6.6400000000E+03, 2.4407265422E+00, 6.4033970557E+00, 5.4075042864E-02, 5.2469474385E-02, 4.1591520509E-01],
	[6.6450000000E+03, 2.4430041377E+00, 6.4015673104E+00, 5.4199367044E-02, 5.2587450306E-02, 4.1611137052E-01],
	[6.6500000000E+03, 2.4452821430E+00, 6.3997394635E+00, 5.4323882980E-02, 5.2705597368E-02, 4.1630741982E-01],
	[6.6550000000E+03, 2.4475605580E+00, 6.3979135118E+00, 5.4448590820E-02, 5.2823915670E-02, 4.1650335330E-01],
	[6.6600000000E+03, 2.4498393823E+00, 6.3960894518E+00, 5.4573490717E-02, 5.2942405309E-02, 4.1669917130E-01],
	[6.6650000000E+03, 2.4521186158E+00, 6.3942672801E+00, 5.4698582821E-02, 5.3061066383E-02, 4.1689487413E-01],
	[6.6700000000E+03, 2.4544053630E+00, 6.3924762549E+00, 5.4823867282E-02, 5.3179904351E-02, 4.1709046212E-01],
	[6.6750000000E+03, 2.4566927789E+00, 6.3906881098E+00, 5.4949344251E-02, 5.3298914180E-02, 4.1728593560E-01],
	[6.6800000000E+03, 2.4589806114E+00, 6.3889018033E+00, 5.5075013879E-02, 5.3418095777E-02, 4.1748129488E-01],
	[6.6850000000E+03, 2.4612688603E+00, 6.3871173321E+00, 5.5200876316E-02, 5.3537449241E-02, 4.1767654029E-01],
	[6.6900000000E+03, 2.4635575253E+00, 6.3853346930E+00, 5.5326931713E-02, 5.3656974670E-02, 4.1787167216E-01],
	[6.6950000000E+03, 2.4658466062E+00, 6.3835538826E+00, 5.5453180221E-02, 5.3776672160E-02, 4.1806669079E-01],
	[6.7000000000E+03, 2.4681361028E+00, 6.3817748978E+00, 5.5579621990E-02, 5.3896541809E-02, 4.1826159651E-01],
	[6.7050000000E+03, 2.4704260148E+00, 6.3799977353E+00, 5.5706257172E-02, 5.4016583715E-02, 4.1845638963E-01],
	[6.7100000000E+03, 2.4727163421E+00, 6.3782223919E+00, 5.5833085916E-02, 5.4136797974E-02, 4.1865107048E-01],
	[6.7150000000E+03, 2.4750070843E+00, 6.3764488644E+00, 5.5960108373E-02, 5.4257184685E-02, 4.1884563937E-01],
	[6.7200000000E+03, 2.4772982412E+00, 6.3746771496E+00, 5.6087324695E-02, 5.4377743943E-02, 4.1904009663E-01],
	[6.7250000000E+03, 2.4795898127E+00, 6.3729072442E+00, 5.6214735032E-02, 5.4498475847E-02, 4.1923444255E-01],
	[6.7300000000E+03, 2.4818817984E+00, 6.3711391452E+00, 5.6342339535E-02, 5.4619380492E-02, 4.1942867746E-01],
	[6.7350000000E+03, 2.4841741982E+00, 6.3693728492E+00, 5.6470138354E-02, 5.4740457975E-02, 4.1962280168E-01],
	[6.7400000000E+03, 2.4864670117E+00, 6.3676083532E+00, 5.6598131639E-02, 5.4861708394E-02, 4.1981681556E-01],
	[6.7450000000E+03, 2.4887602388E+00, 6.3658456539E+00, 5.6726319543E-02, 5.4983131844E-02, 4.2001071944E-01],
	[6.7500000000E+03, 2.4910538793E+00, 6.3640847483E+00, 5.6854702215E-02, 5.5104728423E-02, 4.2020451362E-01],
	[6.7550000000E+03, 2.4933479329E+00, 6.3623256330E+00, 5.6983279806E-02, 5.5226498226E-02, 4.2039819841E-01],
	[6.7600000000E+03, 2.4956423993E+00, 6.3605683051E+00, 5.7112052468E-02, 5.5348441351E-02, 4.2059177409E-01],
	[6.7650000000E+03, 2.4979372784E+00, 6.3588127614E+00, 5.7241020349E-02, 5.5470557892E-02, 4.2078524099E-01],
	[6.7700000000E+03, 2.5002325699E+00, 6.3570589987E+00, 5.7370183603E-02, 5.5592847947E-02, 4.2097859939E-01],
	[6.7750000000E+03, 2.5025318297E+00, 6.3553217608E+00, 5.7499542378E-02, 5.5715314507E-02, 4.2117184959E-01],
	[6.7800000000E+03, 2.5048349831E+00, 6.3536006833E+00, 5.7629096827E-02, 5.5837957633E-02, 4.2136499191E-01],
	[6.7850000000E+03, 2.5071385560E+00, 6.3518813400E+00, 5.7758847099E-02, 5.5960774602E-02, 4.2155802663E-01],
	[6.7900000000E+03, 2.5094425481E+00, 6.3501637281E+00, 5.7888793345E-02, 5.6083765509E-02, 4.2175095405E-01],
	[6.7950000000E+03, 2.5117469591E+00, 6.3484478445E+00, 5.8018935717E-02, 5.6206930450E-02, 4.2194377447E-01],
	[6.8000000000E+03, 2.5140517889E+00, 6.3467336861E+00, 5.8149274365E-02, 5.6330269520E-02, 4.2213648819E-01],
	[6.8050000000E+03, 2.5163570373E+00, 6.3450212501E+00, 5.8279809439E-02, 5.6453782815E-02, 4.2232909550E-01],
	[6.8100000000E+03, 2.5186627039E+00, 6.3433105333E+00, 5.8410541091E-02, 5.6577470431E-02, 4.2252159669E-01],
	[6.8150000000E+03, 2.5209687886E+00, 6.3416015328E+00, 5.8541469471E-02, 5.6701332463E-02, 4.2271399207E-01],
	[6.8200000000E+03, 2.5232752911E+00, 6.3398942457E+00, 5.8672594730E-02, 5.6825369007E-02, 4.2290628192E-01],
	[6.8250000000E+03, 2.5255822112E+00, 6.3381886689E+00, 5.8803917019E-02, 5.6949580157E-02, 4.2309846654E-01],
	[6.8300000000E+03, 2.5278895487E+00, 6.3364847994E+00, 5.8935436488E-02, 5.7073966009E-02, 4.2329054622E-01],
	[6.8350000000E+03, 2.5301973033E+00, 6.3347826344E+00, 5.9067153289E-02, 5.7198526658E-02, 4.2348252125E-01],
	[6.8400000000E+03, 2.5325054748E+00, 6.3330821709E+00, 5.9199067572E-02, 5.7323262198E-02, 4.2367439192E-01],
	[6.8450000000E+03, 2.5348140630E+00, 6.3313834059E+00, 5.9331179488E-02, 5.7448172725E-02, 4.2386615852E-01],
	[6.8500000000E+03, 2.5371230677E+00, 6.3296863365E+00, 5.9463489188E-02, 5.7573258334E-02, 4.2405782134E-01],
	[6.8550000000E+03, 2.5394324885E+00, 6.3279909598E+00, 5.9595996822E-02, 5.7698519118E-02, 4.2424938067E-01],
	[6.8600000000E+03, 2.5417423254E+00, 6.3262972729E+00, 5.9728702542E-02, 5.7823955173E-02, 4.2444083680E-01],
	[6.8650000000E+03, 2.5440525780E+00, 6.3246052727E+00, 5.9861606498E-02, 5.7949566593E-02, 4.2463219002E-01],
	[6.8700000000E+03, 2.5463632461E+00, 6.3229149565E+00, 5.9994708841E-02, 5.8075353472E-02, 4.2482344060E-01],
	[6.8750000000E+03, 2.5486743296E+00, 6.3212263214E+00, 6.0128009722E-02, 5.8201315905E-02, 4.2501458884E-01],
	[6.8800000000E+03, 2.5509858281E+00, 6.3195393643E+00, 6.0261509291E-02, 5.8327453986E-02, 4.2520563503E-01],
	[6.8850000000E+03, 2.5533024381E+00, 6.3178737217E+00, 6.0395207700E-02, 5.8453771951E-02, 4.2539657944E-01],
	[6.8900000000E+03, 2.5556214798E+00, 6.3162181303E+00, 6.0529105099E-02, 5.8580267562E-02, 4.2558742236E-01],
	[6.8950000000E+03, 2.5579409432E+00, 6.3145641732E+00, 6.0663201640E-02, 5.8706939144E-02, 4.2577816408E-01],
	[6.9000000000E+03, 2.5602608281E+00, 6.3129118477E+00, 6.0797497472E-02, 5.8833786791E-02, 4.2596880487E-01],
	[6.9050000000E+03, 2.5625811342E+00, 6.3112611510E+00, 6.0931992747E-02, 5.8960810599E-02, 4.2615934502E-01],
	[6.9100000000E+03, 2.5649018613E+00, 6.3096120803E+00, 6.1066687616E-02, 5.9088010659E-02, 4.2634978481E-01],
	[6.9150000000E+03, 2.5672230091E+00, 6.3079646329E+00, 6.1201582230E-02, 5.9215387066E-02, 4.2654012452E-01],
	[6.9200000000E+03, 2.5695445775E+00, 6.3063188059E+00, 6.1336676739E-02, 5.9342939914E-02, 4.2673036443E-01],
	[6.9250000000E+03, 2.5718665662E+00, 6.3046745966E+00, 6.1471971294E-02, 5.9470669296E-02, 4.2692050482E-01],
	[6.9300000000E+03, 2.5741889751E+00, 6.3030320023E+00, 6.1607466046E-02, 5.9598575305E-02, 4.2711054597E-01],
	[6.9350000000E+03, 2.5765118037E+00, 6.3013910202E+00, 6.1743161147E-02, 5.9726658035E-02, 4.2730048815E-01],
	[6.9400000000E+03, 2.5788350520E+00, 6.2997516475E+00, 6.1879056746E-02, 5.9854917579E-02, 4.2749033165E-01],
	[6.9450000000E+03, 2.5811587198E+00, 6.2981138816E+00, 6.2015152995E-02, 5.9983354029E-02, 4.2768007674E-01],
	[6.9500000000E+03, 2.5834828067E+00, 6.2964777196E+00, 6.2151450044E-02, 6.0111967479E-02, 4.2786972370E-01],
	[6.9550000000E+03, 2.5858073125E+00, 6.2948431589E+00, 6.2287948045E-02, 6.0240758022E-02, 4.2805927280E-01],
	[6.9600000000E+03, 2.5881322371E+00, 6.2932101967E+00, 6.2424647148E-02, 6.0369725750E-02, 4.2824872431E-01],
	[6.9650000000E+03, 2.5904575802E+00, 6.2915788304E+00, 6.2561547505E-02, 6.0498870757E-02, 4.2843807852E-01],
	[6.9700000000E+03, 2.5927833416E+00, 6.2899490572E+00, 6.2698649266E-02, 6.0628193134E-02, 4.2862733569E-01],
	[6.9750000000E+03, 2.5951095210E+00, 6.2883208745E+00, 6.2835952581E-02, 6.0757692975E-02, 4.2881649610E-01],
	[6.9800000000E+03, 2.5974361183E+00, 6.2866942795E+00, 6.2973457603E-02, 6.0887370371E-02, 4.2900556002E-01],
	[6.9850000000E+03, 2.5997631332E+00, 6.2850692696E+00, 6.3111164482E-02, 6.1017225415E-02, 4.2919452773E-01],
	[6.9900000000E+03, 2.6020905654E+00, 6.2834458420E+00, 6.3249073368E-02, 6.1147258199E-02, 4.2938339949E-01],
	[6.9950000000E+03, 2.6044218916E+00, 6.2818386586E+00, 6.3387184413E-02, 6.1277472135E-02, 4.2957217557E-01],
	[7.0000000000E+03, 2.6067565586E+00, 6.2802453364E+00, 6.3525497767E-02, 6.1407866816E-02, 4.2976085625E-01],
	[7.0050000000E+03, 2.6090916491E+00, 6.2786535555E+00, 6.3665342013E-02, 6.1539680759E-02, 4.2994944179E-01],
	[7.0100000000E+03, 2.6114271630E+00, 6.2770633134E+00, 6.3805393760E-02, 6.1671677153E-02, 4.3013793247E-01],
	[7.0150000000E+03, 2.6137631000E+00, 6.2754746075E+00, 6.3945653170E-02, 6.1803856094E-02, 4.3032632855E-01],
	[7.0200000000E+03, 2.6160994599E+00, 6.2738874352E+00, 6.4086120400E-02, 6.1936217681E-02, 4.3051463030E-01],
	[7.0250000000E+03, 2.6184362426E+00, 6.2723017940E+00, 6.4226795609E-02, 6.2068762009E-02, 4.3070283799E-01],
	[7.0300000000E+03, 2.6207734476E+00, 6.2707176813E+00, 6.4367678957E-02, 6.2201489178E-02, 4.3089095187E-01],
	[7.0350000000E+03, 2.6231110750E+00, 6.2691350945E+00, 6.4508770603E-02, 6.2334399283E-02, 4.3107897223E-01],
	[7.0400000000E+03, 2.6254491243E+00, 6.2675540311E+00, 6.4650070706E-02, 6.2467492421E-02, 4.3126689933E-01],
	[7.0450000000E+03, 2.6277875954E+00, 6.2659744885E+00, 6.4791579424E-02, 6.2600768691E-02, 4.3145473342E-01],
	[7.0500000000E+03, 2.6301264881E+00, 6.2643964642E+00, 6.4933296917E-02, 6.2734228188E-02, 4.3164247478E-01],
	[7.0550000000E+03, 2.6324658021E+00, 6.2628199557E+00, 6.5075223344E-02, 6.2867871009E-02, 4.3183012366E-01],
	[7.0600000000E+03, 2.6348055373E+00, 6.2612449604E+00, 6.5217358864E-02, 6.3001697252E-02, 4.3201768034E-01],
	[7.0650000000E+03, 2.6371456933E+00, 6.2596714758E+00, 6.5359703636E-02, 6.3135707011E-02, 4.3220514507E-01],
	[7.0700000000E+03, 2.6394862700E+00, 6.2580994994E+00, 6.5502257819E-02, 6.3269900385E-02, 4.3239251812E-01],
	[7.0750000000E+03, 2.6418272672E+00, 6.2565290287E+00, 6.5645021572E-02, 6.3404277469E-02, 4.3257979974E-01],
	[7.0800000000E+03, 2.6441686846E+00, 6.2549600611E+00, 6.5787995054E-02, 6.3538838359E-02, 4.3276699021E-01],
	[7.0850000000E+03, 2.6465105220E+00, 6.2533925943E+00, 6.5931178425E-02, 6.3673583152E-02, 4.3295408977E-01],
	[7.0900000000E+03, 2.6488527793E+00, 6.2518266256E+00, 6.6074571844E-02, 6.3808511943E-02, 4.3314109869E-01],
	[7.0950000000E+03, 2.6511954560E+00, 6.2502621526E+00, 6.6218175469E-02, 6.3943624829E-02, 4.3332801723E-01],
	[7.1000000000E+03, 2.6535385522E+00, 6.2486991728E+00, 6.6361989460E-02, 6.4078921905E-02, 4.3351484565E-01],
	[7.1050000000E+03, 2.6558822547E+00, 6.2471384719E+00, 6.6506013975E-02, 6.4214403460E-02, 4.3370158421E-01],
	[7.1100000000E+03, 2.6582323501E+00, 6.2456043760E+00, 6.6650249175E-02, 6.4350075565E-02, 4.3388823316E-01],
	[7.1150000000E+03, 2.6605828709E+00, 6.2440717349E+00, 6.6794695218E-02, 6.4485932191E-02, 4.3407479275E-01],
	[7.1200000000E+03, 2.6629338166E+00, 6.2425405461E+00, 6.6939352264E-02, 6.4621973434E-02, 4.3426126326E-01],
	[7.1250000000E+03, 2.6652851871E+00, 6.2410108073E+00, 6.7084220471E-02, 6.4758199390E-02, 4.3444764493E-01],
	[7.1300000000E+03, 2.6676369822E+00, 6.2394825162E+00, 6.7229299999E-02, 6.4894610153E-02, 4.3463393802E-01],
	[7.1350000000E+03, 2.6699892017E+00, 6.2379556702E+00, 6.7374591006E-02, 6.5031205820E-02, 4.3482014279E-01],
	[7.1400000000E+03, 2.6723418452E+00, 6.2364302671E+00, 6.7520093653E-02, 6.5167986484E-02, 4.3500625948E-01],
	[7.1450000000E+03, 2.6746949127E+00, 6.2349063044E+00, 6.7665808098E-02, 6.5304952242E-02, 4.3519228837E-01],
	[7.1500000000E+03, 2.6770484039E+00, 6.2333837799E+00, 6.7811734501E-02, 6.5442103188E-02, 4.3537822970E-01],
	[7.1550000000E+03, 2.6794023185E+00, 6.2318626910E+00, 6.7957873020E-02, 6.5579439416E-02, 4.3556408373E-01],
	[7.1600000000E+03, 2.6817566564E+00, 6.2303430356E+00, 6.8104223815E-02, 6.5716961023E-02, 4.3574985069E-01],
	[7.1650000000E+03, 2.6841114173E+00, 6.2288248111E+00, 6.8250787046E-02, 6.5854668102E-02, 4.3593553080E-01],
	[7.1700000000E+03, 2.6864666010E+00, 6.2273080154E+00, 6.8397562870E-02, 6.5992560748E-02, 4.3612112431E-01],
	[7.1750000000E+03, 2.6888222073E+00, 6.2257926460E+00, 6.8544551449E-02, 6.6130639055E-02, 4.3630663144E-01],
	[7.1800000000E+03, 2.6911782360E+00, 6.2242787006E+00, 6.8691752940E-02, 6.6268903118E-02, 4.3649205244E-01],
	[7.1850000000E+03, 2.6935346868E+00, 6.2227661768E+00, 6.8839167503E-02, 6.6407353031E-02, 4.3667738752E-01],
	[7.1900000000E+03, 2.6958915596E+00, 6.2212550724E+00, 6.8986795298E-02, 6.6545988888E-02, 4.3686263693E-01],
	[7.1950000000E+03, 2.6982488541E+00, 6.2197453851E+00, 6.9134636483E-02, 6.6684810783E-02, 4.3704780090E-01],
	[7.2000000000E+03, 2.7006065700E+00, 6.2182371125E+00, 6.9282691219E-02, 6.6823818809E-02, 4.3723287965E-01],
	[7.2050000000E+03, 2.7029647073E+00, 6.2167302523E+00, 6.9430959663E-02, 6.6963013062E-02, 4.3741787342E-01],
	[7.2100000000E+03, 2.7053232656E+00, 6.2152248023E+00, 6.9579441977E-02, 6.7102393634E-02, 4.3760278244E-01],
	[7.2150000000E+03, 2.7076822448E+00, 6.2137207600E+00, 6.9728138317E-02, 6.7241960618E-02, 4.3778760694E-01],
	[7.2200000000E+03, 2.7100425645E+00, 6.2122219740E+00, 6.9877048845E-02, 6.7381715132E-02, 4.3797234714E-01],
	[7.2250000000E+03, 2.7124083335E+00, 6.2107456104E+00, 7.0026173720E-02, 6.7521661852E-02, 4.3815700327E-01],
	[7.2300000000E+03, 2.7147745289E+00, 6.2092706187E+00, 7.0175513100E-02, 6.7661795311E-02, 4.3834157557E-01],
	[7.2350000000E+03, 2.7171411506E+00, 6.2077969966E+00, 7.0325067145E-02, 6.7802115602E-02, 4.3852606426E-01],
	[7.2400000000E+03, 2.7195081983E+00, 6.2063247420E+00, 7.0474836015E-02, 6.7942622818E-02, 4.3871046956E-01],
	[7.2450000000E+03, 2.7218756718E+00, 6.2048538525E+00, 7.0624819869E-02, 6.8083317053E-02, 4.3889479171E-01],
	[7.2500000000E+03, 2.7242435709E+00, 6.2033843260E+00, 7.0775018865E-02, 6.8224198398E-02, 4.3907903093E-01],
	[7.2550000000E+03, 2.7266118953E+00, 6.2019161604E+00, 7.0925433164E-02, 6.8365266948E-02, 4.3926318745E-01],
	[7.2600000000E+03, 2.7289806449E+00, 6.2004493533E+00, 7.1076062925E-02, 6.8506522795E-02, 4.3944726149E-01],
	[7.2650000000E+03, 2.7313498194E+00, 6.1989839026E+00, 7.1226908307E-02, 6.8647966031E-02, 4.3963125328E-01],
	[7.2700000000E+03, 2.7337194186E+00, 6.1975198061E+00, 7.1377969470E-02, 6.8789596750E-02, 4.3981516304E-01],
	[7.2750000000E+03, 2.7360894422E+00, 6.1960570617E+00, 7.1529246572E-02, 6.8931415044E-02, 4.3999899099E-01],
	[7.2800000000E+03, 2.7384598902E+00, 6.1945956672E+00, 7.1680739774E-02, 6.9073421005E-02, 4.4018273737E-01],
	[7.2850000000E+03, 2.7408307622E+00, 6.1931356203E+00, 7.1832449235E-02, 6.9215614726E-02, 4.4036640239E-01],
	[7.2900000000E+03, 2.7432020580E+00, 6.1916769189E+00, 7.1984375114E-02, 6.9357996298E-02, 4.4054998628E-01],
	[7.2950000000E+03, 2.7455737775E+00, 6.1902195609E+00, 7.2136517570E-02, 6.9500565814E-02, 4.4073348926E-01],
	[7.3000000000E+03, 2.7479459204E+00, 6.1887635442E+00, 7.2288876763E-02, 6.9643323365E-02, 4.4091691154E-01],
	[7.3050000000E+03, 2.7503184865E+00, 6.1873088664E+00, 7.2441452853E-02, 6.9786269044E-02, 4.4110025337E-01],
	[7.3100000000E+03, 2.7526914756E+00, 6.1858555256E+00, 7.2594245999E-02, 6.9929402943E-02, 4.4128351494E-01],
	[7.3150000000E+03, 2.7550648874E+00, 6.1844035195E+00, 7.2747256360E-02, 7.0072725152E-02, 4.4146669649E-01],
	[7.3200000000E+03, 2.7574387218E+00, 6.1829528461E+00, 7.2900484095E-02, 7.0216235764E-02, 4.4164979824E-01],
	[7.3250000000E+03, 2.7598129786E+00, 6.1815035031E+00, 7.3053929365E-02, 7.0359934870E-02, 4.4183282040E-01],
	[7.3300000000E+03, 2.7621876575E+00, 6.1800554886E+00, 7.3207592328E-02, 7.0503822561E-02, 4.4201576320E-01],
	[7.3350000000E+03, 2.7645627583E+00, 6.1786088002E+00, 7.3361473145E-02, 7.0647898928E-02, 4.4219862685E-01],
	[7.3400000000E+03, 2.7669435021E+00, 6.1771851843E+00, 7.3515571974E-02, 7.0792170337E-02, 4.4238141158E-01],
	[7.3450000000E+03, 2.7693251845E+00, 6.1757649946E+00, 7.3669888976E-02, 7.0936631264E-02, 4.4256411759E-01],
	[7.3500000000E+03, 2.7717072942E+00, 6.1743460976E+00, 7.3824424308E-02, 7.1081281187E-02, 4.4274674512E-01],
	[7.3550000000E+03, 2.7740898309E+00, 6.1729284911E+00, 7.3979178132E-02, 7.1226120197E-02, 4.4292929438E-01],
	[7.3600000000E+03, 2.7764727943E+00, 6.1715121731E+00, 7.4134150607E-02, 7.1371148384E-02, 4.4311176558E-01],
	[7.3650000000E+03, 2.7788561844E+00, 6.1700971416E+00, 7.4289341892E-02, 7.1516365841E-02, 4.4329415894E-01],
	[7.3700000000E+03, 2.7812400008E+00, 6.1686833946E+00, 7.4444752146E-02, 7.1661772657E-02, 4.4347647468E-01],
	[7.3750000000E+03, 2.7836242434E+00, 6.1672709299E+00, 7.4600381529E-02, 7.1807368922E-02, 4.4365871301E-01],
	[7.3800000000E+03, 2.7860089120E+00, 6.1658597456E+00, 7.4756230201E-02, 7.1953154728E-02, 4.4384087416E-01],
	[7.3850000000E+03, 2.7883940063E+00, 6.1644498396E+00, 7.4912298322E-02, 7.2099130165E-02, 4.4402295833E-01],
	[7.3900000000E+03, 2.7907795261E+00, 6.1630412100E+00, 7.5068586050E-02, 7.2245295322E-02, 4.4420496573E-01],
	[7.3950000000E+03, 2.7931654712E+00, 6.1616338547E+00, 7.5225093545E-02, 7.2391650291E-02, 4.4438689660E-01],
	[7.4000000000E+03, 2.7955518414E+00, 6.1602277716E+00, 7.5381820967E-02, 7.2538195160E-02, 4.4456875113E-01],
	[7.4050000000E+03, 2.7979386365E+00, 6.1588229588E+00, 7.5538768476E-02, 7.2684930020E-02, 4.4475052954E-01],
	[7.4100000000E+03, 2.8003258563E+00, 6.1574194143E+00, 7.5695936231E-02, 7.2831854960E-02, 4.4493223205E-01],
	[7.4150000000E+03, 2.8027135005E+00, 6.1560171361E+00, 7.5853324391E-02, 7.2978970070E-02, 4.4511385887E-01],
	[7.4200000000E+03, 2.8051015690E+00, 6.1546161222E+00, 7.6010933116E-02, 7.3126275441E-02, 4.4529541021E-01],
	[7.4250000000E+03, 2.8074900615E+00, 6.1532163705E+00, 7.6168762567E-02, 7.3273771160E-02, 4.4547688629E-01],
	[7.4300000000E+03, 2.8098789779E+00, 6.1518178792E+00, 7.6326812901E-02, 7.3421457318E-02, 4.4565828731E-01],
	[7.4350000000E+03, 2.8122683179E+00, 6.1504206461E+00, 7.6485084280E-02, 7.3569334003E-02, 4.4583961348E-01],
	[7.4400000000E+03, 2.8146580813E+00, 6.1490246694E+00, 7.6643576863E-02, 7.3717401306E-02, 4.4602086503E-01],
	[7.4450000000E+03, 2.8170482679E+00, 6.1476299471E+00, 7.6802290808E-02, 7.3865659314E-02, 4.4620204215E-01],
	[7.4500000000E+03, 2.8194388775E+00, 6.1462364772E+00, 7.6961226277E-02, 7.4014108117E-02, 4.4638314507E-01],
	[7.4550000000E+03, 2.8218315237E+00, 6.1448509660E+00, 7.7120383428E-02, 7.4162749895E-02, 4.4656417398E-01],
	[7.4600000000E+03, 2.8242284969E+00, 6.1434829010E+00, 7.7279762421E-02, 7.4311587732E-02, 4.4674512910E-01],
	[7.4650000000E+03, 2.8266258981E+00, 6.1421160569E+00, 7.7439363416E-02, 7.4460616678E-02, 4.4692601065E-01],
	[7.4700000000E+03, 2.8290237271E+00, 6.1407504319E+00, 7.7599186572E-02, 7.4609836821E-02, 4.4710681882E-01],
	[7.4750000000E+03, 2.8314219837E+00, 6.1393860239E+00, 7.7759232050E-02, 7.4759248249E-02, 4.4728755382E-01],
	[7.4800000000E+03, 2.8338206677E+00, 6.1380228311E+00, 7.7919500008E-02, 7.4908851052E-02, 4.4746821587E-01],
	[7.4850000000E+03, 2.8362197789E+00, 6.1366608516E+00, 7.8079990607E-02, 7.5058645317E-02, 4.4764880517E-01],
	[7.4900000000E+03, 2.8386193171E+00, 6.1353000836E+00, 7.8240704006E-02, 7.5208631132E-02, 4.4782932194E-01],
	[7.4950000000E+03, 2.8410192820E+00, 6.1339405250E+00, 7.8401640365E-02, 7.5358808586E-02, 4.4800976637E-01],
	[7.5000000000E+03, 2.8434196735E+00, 6.1325821741E+00, 7.8562799844E-02, 7.5509177767E-02, 4.4819013868E-01],
	[7.5050000000E+03, 2.8458204914E+00, 6.1312250290E+00, 7.8724182602E-02, 7.5659738762E-02, 4.4837043906E-01],
	[7.5100000000E+03, 2.8482217353E+00, 6.1298690878E+00, 7.8885788799E-02, 7.5810491659E-02, 4.4855066774E-01],
	[7.5150000000E+03, 2.8506234053E+00, 6.1285143486E+00, 7.9047618594E-02, 7.5961436547E-02, 4.4873082490E-01],
	[7.5200000000E+03, 2.8530255009E+00, 6.1271608096E+00, 7.9209672148E-02, 7.6112573511E-02, 4.4891091077E-01],
	[7.5250000000E+03, 2.8554280220E+00, 6.1258084688E+00, 7.9371949621E-02, 7.6263902641E-02, 4.4909092554E-01],
	[7.5300000000E+03, 2.8578309685E+00, 6.1244573245E+00, 7.9534451171E-02, 7.6415424022E-02, 4.4927086942E-01],
	[7.5350000000E+03, 2.8602343401E+00, 6.1231073749E+00, 7.9697176959E-02, 7.6567137743E-02, 4.4945074261E-01],
	[7.5400000000E+03, 2.8626381365E+00, 6.1217586179E+00, 7.9860127144E-02, 7.6719043890E-02, 4.4963054529E-01],
	[7.5450000000E+03, 2.8650423577E+00, 6.1204110519E+00, 8.0023301886E-02, 7.6871142551E-02, 4.4981027765E-01],
	[7.5500000000E+03, 2.8674470033E+00, 6.1190646749E+00, 8.0186701346E-02, 7.7023433812E-02, 4.4998993986E-01],
	[7.5550000000E+03, 2.8698520732E+00, 6.1177194852E+00, 8.0350325682E-02, 7.7175917760E-02, 4.5016953211E-01],
	[7.5600000000E+03, 2.8722575671E+00, 6.1163754808E+00, 8.0514175055E-02, 7.7328594481E-02, 4.5034905458E-01],
	[7.5650000000E+03, 2.8746634850E+00, 6.1150326601E+00, 8.0678249624E-02, 7.7481464063E-02, 4.5052850746E-01],
	[7.5700000000E+03, 2.8770698264E+00, 6.1136910210E+00, 8.0842549549E-02, 7.7634526591E-02, 4.5070789091E-01],
	[7.5750000000E+03, 2.8794781501E+00, 6.1123570334E+00, 8.1007074990E-02, 7.7787784337E-02, 4.5088720513E-01],
	[7.5800000000E+03, 2.8818906383E+00, 6.1110397270E+00, 8.1171826107E-02, 7.7941240475E-02, 4.5106645028E-01],
	[7.5850000000E+03, 2.8843035549E+00, 6.1097235729E+00, 8.1336803060E-02, 7.8094889868E-02, 4.5124562656E-01],
	[7.5900000000E+03, 2.8867168997E+00, 6.1084085694E+00, 8.1502006007E-02, 7.8248732600E-02, 4.5142473414E-01],
	[7.5950000000E+03, 2.8891306725E+00, 6.1070947145E+00, 8.1667435110E-02, 7.8402768759E-02, 4.5160377320E-01],
	[7.6000000000E+03, 2.8915448731E+00, 6.1057820066E+00, 8.1833090528E-02, 7.8556998430E-02, 4.5178274391E-01],
	[7.6050000000E+03, 2.8939595013E+00, 6.1044704440E+00, 8.1998972421E-02, 7.8711421699E-02, 4.5196164646E-01],
	[7.6100000000E+03, 2.8963745568E+00, 6.1031600248E+00, 8.2165080949E-02, 7.8866038651E-02, 4.5214048103E-01],
	[7.6150000000E+03, 2.8987900395E+00, 6.1018507474E+00, 8.2331416271E-02, 7.9020849373E-02, 4.5231924780E-01],
	[7.6200000000E+03, 2.9012059492E+00, 6.1005426099E+00, 8.2497978548E-02, 7.9175853950E-02, 4.5249794693E-01],
	[7.6250000000E+03, 2.9036222857E+00, 6.0992356107E+00, 8.2664767939E-02, 7.9331052466E-02, 4.5267657861E-01],
	[7.6300000000E+03, 2.9060390487E+00, 6.0979297480E+00, 8.2831784605E-02, 7.9486445008E-02, 4.5285514302E-01],
	[7.6350000000E+03, 2.9084562381E+00, 6.0966250200E+00, 8.2999028704E-02, 7.9642031660E-02, 4.5303364033E-01],
	[7.6400000000E+03, 2.9108738536E+00, 6.0953214252E+00, 8.3166500398E-02, 7.9797812508E-02, 4.5321207072E-01],
	[7.6450000000E+03, 2.9132918951E+00, 6.0940189616E+00, 8.3334199845E-02, 7.9953787637E-02, 4.5339043437E-01],
	[7.6500000000E+03, 2.9157103623E+00, 6.0927176276E+00, 8.3502127206E-02, 8.0109957130E-02, 4.5356873144E-01],
	[7.6550000000E+03, 2.9181292550E+00, 6.0914174216E+00, 8.3670282641E-02, 8.0266321073E-02, 4.5374696213E-01],
	[7.6600000000E+03, 2.9205485731E+00, 6.0901183417E+00, 8.3838666310E-02, 8.0422879551E-02, 4.5392512660E-01],
	[7.6650000000E+03, 2.9229683164E+00, 6.0888203862E+00, 8.4007278372E-02, 8.0579632648E-02, 4.5410322503E-01],
	[7.6700000000E+03, 2.9253884845E+00, 6.0875235535E+00, 8.4176118987E-02, 8.0736580448E-02, 4.5428125759E-01],
	[7.6750000000E+03, 2.9278090774E+00, 6.0862278419E+00, 8.4345188316E-02, 8.0893723035E-02, 4.5445922445E-01],
	[7.6800000000E+03, 2.9302300948E+00, 6.0849332496E+00, 8.4514486519E-02, 8.1051060494E-02, 4.5463712581E-01],
	[7.6850000000E+03, 2.9326515365E+00, 6.0836397750E+00, 8.4684013755E-02, 8.1208592909E-02, 4.5481496182E-01],
	[7.6900000000E+03, 2.9350734024E+00, 6.0823474164E+00, 8.4853770184E-02, 8.1366320363E-02, 4.5499273266E-01],
	[7.6950000000E+03, 2.9374956922E+00, 6.0810561720E+00, 8.5023755966E-02, 8.1524242940E-02, 4.5517043850E-01],
	[7.7000000000E+03, 2.9399230249E+00, 6.0797852160E+00, 8.5193971262E-02, 8.1682367751E-02, 4.5534807952E-01],
	[7.7050000000E+03, 2.9423512451E+00, 6.0785172554E+00, 8.5364416231E-02, 8.1840688599E-02, 4.5552565590E-01],
	[7.7100000000E+03, 2.9447798937E+00, 6.0772503816E+00, 8.5535091033E-02, 8.1999204871E-02, 4.5570316780E-01],
	[7.7150000000E+03, 2.9472089705E+00, 6.0759845928E+00, 8.5705995828E-02, 8.2157916650E-02, 4.5588061539E-01],
	[7.7200000000E+03, 2.9496384753E+00, 6.0747198875E+00, 8.5877130776E-02, 8.2316824020E-02, 4.5605799886E-01],
	[7.7250000000E+03, 2.9520684078E+00, 6.0734562640E+00, 8.6048496038E-02, 8.2475927065E-02, 4.5623531837E-01],
	[7.7300000000E+03, 2.9544987680E+00, 6.0721937208E+00, 8.6220091773E-02, 8.2635225866E-02, 4.5641257409E-01],
	[7.7350000000E+03, 2.9569295556E+00, 6.0709322561E+00, 8.6391918141E-02, 8.2794720509E-02, 4.5658976620E-01],
	[7.7400000000E+03, 2.9593607703E+00, 6.0696718684E+00, 8.6563975302E-02, 8.2954411074E-02, 4.5676689486E-01],
	[7.7450000000E+03, 2.9617924120E+00, 6.0684125561E+00, 8.6736263417E-02, 8.3114297646E-02, 4.5694396025E-01],
	[7.7500000000E+03, 2.9642244806E+00, 6.0671543175E+00, 8.6908782645E-02, 8.3274380307E-02, 4.5712096254E-01],
	[7.7550000000E+03, 2.9666569757E+00, 6.0658971510E+00, 8.7081533147E-02, 8.3434659139E-02, 4.5729790191E-01],
	[7.7600000000E+03, 2.9690898971E+00, 6.0646410551E+00, 8.7254515082E-02, 8.3595134224E-02, 4.5747477851E-01],
	[7.7650000000E+03, 2.9715232448E+00, 6.0633860281E+00, 8.7427728610E-02, 8.3755805647E-02, 4.5765159252E-01],
	[7.7700000000E+03, 2.9739570185E+00, 6.0621320685E+00, 8.7601173892E-02, 8.3916673487E-02, 4.5782834411E-01],
	[7.7750000000E+03, 2.9763912179E+00, 6.0608791746E+00, 8.7774851088E-02, 8.4077737828E-02, 4.5800503346E-01],
	[7.7800000000E+03, 2.9788258429E+00, 6.0596273448E+00, 8.7948760357E-02, 8.4238998752E-02, 4.5818166072E-01],
	[7.7850000000E+03, 2.9812608933E+00, 6.0583765777E+00, 8.8122901861E-02, 8.4400456340E-02, 4.5835822607E-01],
	[7.7900000000E+03, 2.9836963689E+00, 6.0571268715E+00, 8.8297275758E-02, 8.4562110675E-02, 4.5853472968E-01],
	[7.7950000000E+03, 2.9861322695E+00, 6.0558782247E+00, 8.8471882209E-02, 8.4723961837E-02, 4.5871117172E-01],
	[7.8000000000E+03, 2.9885685949E+00, 6.0546306357E+00, 8.8646721374E-02, 8.4886009909E-02, 4.5888755235E-01],
	[7.8050000000E+03, 2.9910053449E+00, 6.0533841030E+00, 8.8821793414E-02, 8.5048254972E-02, 4.5906387175E-01],
	[7.8100000000E+03, 2.9934425192E+00, 6.0521386249E+00, 8.8997098488E-02, 8.5210697107E-02, 4.5924013008E-01],
	[7.8150000000E+03, 2.9958801178E+00, 6.0508942000E+00, 8.9172636756E-02, 8.5373336395E-02, 4.5941632751E-01],
	[7.8200000000E+03, 2.9983187828E+00, 6.0496535022E+00, 8.9348408379E-02, 8.5536173976E-02, 4.5959246421E-01],
	[7.8250000000E+03, 3.0007620867E+00, 6.0484313856E+00, 8.9524413517E-02, 8.5699215836E-02, 4.5976854034E-01],
	[7.8300000000E+03, 3.0032058190E+00, 6.0472102964E+00, 8.9700652330E-02, 8.5862455143E-02, 4.5994455608E-01],
	[7.8350000000E+03, 3.0056499795E+00, 6.0459902330E+00, 8.9877124978E-02, 8.6025891979E-02, 4.6012051158E-01],
	[7.8400000000E+03, 3.0080945680E+00, 6.0447711938E+00, 9.0053831620E-02, 8.6189526424E-02, 4.6029640702E-01],
	[7.8450000000E+03, 3.0105395843E+00, 6.0435531774E+00, 9.0230772419E-02, 8.6353358559E-02, 4.6047224257E-01],
	[7.8500000000E+03, 3.0129850282E+00, 6.0423361822E+00, 9.0407947533E-02, 8.6517388464E-02, 4.6064801838E-01],
	[7.8550000000E+03, 3.0154308996E+00, 6.0411202068E+00, 9.0585357123E-02, 8.6681616220E-02, 4.6082373463E-01],
	[7.8600000000E+03, 3.0178771981E+00, 6.0399052496E+00, 9.0763001348E-02, 8.6846041907E-02, 4.6099939148E-01],
	[7.8650000000E+03, 3.0203239237E+00, 6.0386913091E+00, 9.0940880370E-02, 8.7010665606E-02, 4.6117498909E-01],
	[7.8700000000E+03, 3.0227710761E+00, 6.0374783839E+00, 9.1118994348E-02, 8.7175487396E-02, 4.6135052764E-01],
	[7.8750000000E+03, 3.0252186551E+00, 6.0362664725E+00, 9.1297343443E-02, 8.7340507357E-02, 4.6152600729E-01],
	[7.8800000000E+03, 3.0276666605E+00, 6.0350555733E+00, 9.1475927814E-02, 8.7505725570E-02, 4.6170142820E-01],
	[7.8850000000E+03, 3.0301150922E+00, 6.0338456848E+00, 9.1654747622E-02, 8.7671142114E-02, 4.6187679053E-01],
	[7.8900000000E+03, 3.0325639499E+00, 6.0326368057E+00, 9.1833803028E-02, 8.7836757069E-02, 4.6205209446E-01],
	[7.8950000000E+03, 3.0350132334E+00, 6.0314289344E+00, 9.2013094191E-02, 8.8002570513E-02, 4.6222734014E-01],
	[7.9000000000E+03, 3.0374629426E+00, 6.0302220694E+00, 9.2192621271E-02, 8.8168582528E-02, 4.6240252775E-01],
	[7.9050000000E+03, 3.0399130772E+00, 6.0290162093E+00, 9.2372384430E-02, 8.8334793191E-02, 4.6257765740E-01],
	[7.9100000000E+03, 3.0423636371E+00, 6.0278113525E+00, 9.2552383826E-02, 8.8501202582E-02, 4.6275272926E-01],
	[7.9150000000E+03, 3.0448146220E+00, 6.0266074977E+00, 9.2732619621E-02, 8.8667810780E-02, 4.6292774347E-01],
	[7.9200000000E+03, 3.0472660318E+00, 6.0254046433E+00, 9.2913091975E-02, 8.8834617864E-02, 4.6310270015E-01],
	[7.9250000000E+03, 3.0497178663E+00, 6.0242027879E+00, 9.3093801048E-02, 8.9001623913E-02, 4.6327759946E-01],
	[7.9300000000E+03, 3.0521701252E+00, 6.0230019301E+00, 9.3274747000E-02, 8.9168829005E-02, 4.6345244153E-01],
	[7.9350000000E+03, 3.0546228084E+00, 6.0218020683E+00, 9.3455929991E-02, 8.9336233219E-02, 4.6362722650E-01],
	[7.9400000000E+03, 3.0570759157E+00, 6.0206032011E+00, 9.3637350182E-02, 8.9503836634E-02, 4.6380195453E-01],
	[7.9450000000E+03, 3.0595294469E+00, 6.0194053271E+00, 9.3819007733E-02, 8.9671639328E-02, 4.6397662573E-01],
	[7.9500000000E+03, 3.0619878357E+00, 6.0182269648E+00, 9.4000902805E-02, 8.9839649322E-02, 4.6415124026E-01],
	[7.9550000000E+03, 3.0644468556E+00, 6.0170504219E+00, 9.4183035558E-02, 9.0007859166E-02, 4.6432579826E-01],
	[7.9600000000E+03, 3.0669063034E+00, 6.0158748482E+00, 9.4365406151E-02, 9.0176268577E-02, 4.6450029986E-01],
	[7.9650000000E+03, 3.0693661788E+00, 6.0147002420E+00, 9.4548014746E-02, 9.0344877630E-02, 4.6467474520E-01],
	[7.9700000000E+03, 3.0718264816E+00, 6.0135266021E+00, 9.4730861502E-02, 9.0513686405E-02, 4.6484913443E-01],
	[7.9750000000E+03, 3.0742872116E+00, 6.0123539271E+00, 9.4913946581E-02, 9.0682694980E-02, 4.6502346767E-01],
	[7.9800000000E+03, 3.0767483688E+00, 6.0111822155E+00, 9.5097270142E-02, 9.0851903431E-02, 4.6519774508E-01],
	[7.9850000000E+03, 3.0792099527E+00, 6.0100114660E+00, 9.5280832346E-02, 9.1021311837E-02, 4.6537196679E-01],
	[7.9900000000E+03, 3.0816719634E+00, 6.0088416772E+00, 9.5464633352E-02, 9.1190920275E-02, 4.6554613294E-01],
	[7.9950000000E+03, 3.0841344005E+00, 6.0076728476E+00, 9.5648673322E-02, 9.1360728822E-02, 4.6572024366E-01],
	[8.0000000000E+03, 3.0865972639E+00, 6.0065049759E+00, 9.5832952416E-02, 9.1530737555E-02, 4.6589429910E-01],
	[8.0050000000E+03, 3.0890605534E+00, 6.0053380607E+00, 9.6018439202E-02, 9.1701829846E-02, 4.6606829940E-01],
	[8.0100000000E+03, 3.0915242688E+00, 6.0041721007E+00, 9.6204168568E-02, 9.1873125104E-02, 4.6624224468E-01],
	[8.0150000000E+03, 3.0939884099E+00, 6.0030070944E+00, 9.6390140679E-02, 9.2044623409E-02, 4.6641613509E-01],
	[8.0200000000E+03, 3.0964529766E+00, 6.0018430405E+00, 9.6576355702E-02, 9.2216324841E-02, 4.6658997077E-01],
	[8.0250000000E+03, 3.0989179685E+00, 6.0006799376E+00, 9.6762813800E-02, 9.2388229479E-02, 4.6676375186E-01],
	[8.0300000000E+03, 3.1013833856E+00, 5.9995177843E+00, 9.6949515139E-02, 9.2560337402E-02, 4.6693747848E-01],
	[8.0350000000E+03, 3.1038492276E+00, 5.9983565793E+00, 9.7136459884E-02, 9.2732648690E-02, 4.6711115079E-01],
	[8.0400000000E+03, 3.1063154943E+00, 5.9971963212E+00, 9.7323648200E-02, 9.2905163422E-02, 4.6728476891E-01],
	[8.0450000000E+03, 3.1087821856E+00, 5.9960370087E+00, 9.7511080251E-02, 9.3077881675E-02, 4.6745833298E-01],
	[8.0500000000E+03, 3.1112493013E+00, 5.9948786403E+00, 9.7698756203E-02, 9.3250803530E-02, 4.6763184314E-01],
	[8.0550000000E+03, 3.1137168411E+00, 5.9937212148E+00, 9.7886676221E-02, 9.3423929064E-02, 4.6780529953E-01],
	[8.0600000000E+03, 3.1161848050E+00, 5.9925647308E+00, 9.8074840469E-02, 9.3597258357E-02, 4.6797870227E-01],
	[8.0650000000E+03, 3.1186531926E+00, 5.9914091869E+00, 9.8263249114E-02, 9.3770791486E-02, 4.6815205152E-01],
	[8.0700000000E+03, 3.1211220038E+00, 5.9902545817E+00, 9.8451902319E-02, 9.3944528530E-02, 4.6832534740E-01],
	[8.0750000000E+03, 3.1235929166E+00, 5.9891078743E+00, 9.8640800251E-02, 9.4118472810E-02, 4.6849859005E-01],
	[8.0800000000E+03, 3.1260670557E+00, 5.9879737031E+00, 9.8829943073E-02, 9.4292626607E-02, 4.6867177961E-01],
	[8.0850000000E+03, 3.1285416221E+00, 5.9868404480E+00, 9.9019330952E-02, 9.4466984608E-02, 4.6884491621E-01],
	[8.0900000000E+03, 3.1310166157E+00, 5.9857081079E+00, 9.9208964052E-02, 9.4641546890E-02, 4.6901799998E-01],
	[8.0950000000E+03, 3.1334920362E+00, 5.9845766814E+00, 9.9398842538E-02, 9.4816313531E-02, 4.6919103107E-01],
	[8.1000000000E+03, 3.1359678835E+00, 5.9834461672E+00, 9.9588966576E-02, 9.4991284608E-02, 4.6936400961E-01],
	[8.1050000000E+03, 3.1384441574E+00, 5.9823165639E+00, 9.9779336330E-02, 9.5166460199E-02, 4.6953693572E-01],
	[8.1100000000E+03, 3.1409208577E+00, 5.9811878704E+00, 9.9969951966E-02, 9.5341840382E-02, 4.6970980956E-01],
	[8.1150000000E+03, 3.1433979842E+00, 5.9800600853E+00, 1.0016081365E-01, 9.5517425234E-02, 4.6988263125E-01],
	[8.1200000000E+03, 3.1458755367E+00, 5.9789332072E+00, 1.0035192154E-01, 9.5693214833E-02, 4.7005540092E-01],
	[8.1250000000E+03, 3.1483535150E+00, 5.9778072351E+00, 1.0054327581E-01, 9.5869209254E-02, 4.7022811871E-01],
	[8.1300000000E+03, 3.1508319190E+00, 5.9766821674E+00, 1.0073487663E-01, 9.6045408576E-02, 4.7040078476E-01],
	[8.1350000000E+03, 3.1533107485E+00, 5.9755580030E+00, 1.0092672415E-01, 9.6221812875E-02, 4.7057339920E-01],
	[8.1400000000E+03, 3.1557900032E+00, 5.9744347406E+00, 1.0111881854E-01, 9.6398422227E-02, 4.7074596217E-01],
	[8.1450000000E+03, 3.1582696829E+00, 5.9733123789E+00, 1.0131115998E-01, 9.6575236711E-02, 4.7091847379E-01],
	[8.1500000000E+03, 3.1607497876E+00, 5.9721909167E+00, 1.0150374861E-01, 9.6752256401E-02, 4.7109093420E-01],
	[8.1550000000E+03, 3.1632303169E+00, 5.9710703526E+00, 1.0169658461E-01, 9.6929481374E-02, 4.7126334353E-01],
	[8.1600000000E+03, 3.1657112708E+00, 5.9699506854E+00, 1.0188966815E-01, 9.7106911707E-02, 4.7143570193E-01],
	[8.1650000000E+03, 3.1681926490E+00, 5.9688319138E+00, 1.0208299938E-01, 9.7284547475E-02, 4.7160800951E-01],
	[8.1700000000E+03, 3.1706744513E+00, 5.9677140365E+00, 1.0227657848E-01, 9.7462388755E-02, 4.7178026642E-01],
	[8.1750000000E+03, 3.1731566776E+00, 5.9665970524E+00, 1.0247040561E-01, 9.7640435622E-02, 4.7195247279E-01],
	[8.1800000000E+03, 3.1756393276E+00, 5.9654809601E+00, 1.0266448093E-01, 9.7818688153E-02, 4.7212462874E-01],
	[8.1850000000E+03, 3.1781224012E+00, 5.9643657584E+00, 1.0285880461E-01, 9.7997146422E-02, 4.7229673442E-01],
	[8.1900000000E+03, 3.1806058982E+00, 5.9632514460E+00, 1.0305337682E-01, 9.8175810506E-02, 4.7246878996E-01],
	[8.1950000000E+03, 3.1830898184E+00, 5.9621380217E+00, 1.0324819771E-01, 9.8354680479E-02, 4.7264079548E-01],
	[8.2000000000E+03, 3.1855741616E+00, 5.9610254842E+00, 1.0344326746E-01, 9.8533756417E-02, 4.7281275113E-01],
	[8.2050000000E+03, 3.1880605958E+00, 5.9599206259E+00, 1.0363858623E-01, 9.8713041857E-02, 4.7298465702E-01],
	[8.2100000000E+03, 3.1905501603E+00, 5.9588276551E+00, 1.0383415419E-01, 9.8892539066E-02, 4.7315651330E-01],
	[8.2150000000E+03, 3.1930401513E+00, 5.9577355500E+00, 1.0402997150E-01, 9.9072242521E-02, 4.7332832010E-01],
	[8.2200000000E+03, 3.1955305688E+00, 5.9566443094E+00, 1.0422603832E-01, 9.9252152296E-02, 4.7350007755E-01],
	[8.2250000000E+03, 3.1980214126E+00, 5.9555539320E+00, 1.0442235483E-01, 9.9432268466E-02, 4.7367178577E-01],
	[8.2300000000E+03, 3.2005126824E+00, 5.9544644167E+00, 1.0461892118E-01, 9.9612591107E-02, 4.7384344491E-01],
	[8.2350000000E+03, 3.2030043780E+00, 5.9533757622E+00, 1.0481573755E-01, 9.9793120292E-02, 4.7401505509E-01],
	[8.2400000000E+03, 3.2054964994E+00, 5.9522879674E+00, 1.0501280409E-01, 9.9973856096E-02, 4.7418661645E-01],
	[8.2450000000E+03, 3.2079890462E+00, 5.9512010310E+00, 1.0521012098E-01, 1.0015479859E-01, 4.7435812911E-01],
	[8.2500000000E+03, 3.2104820184E+00, 5.9501149519E+00, 1.0540768837E-01, 1.0033594786E-01, 4.7452959326E-01],
	[8.2550000000E+03, 3.2129754157E+00, 5.9490297288E+00, 1.0560550644E-01, 1.0051730396E-01, 4.7470100925E-01],
	[8.2600000000E+03, 3.2154692379E+00, 5.9479453607E+00, 1.0580357535E-01, 1.0069886699E-01, 4.7487237721E-01],
	[8.2650000000E+03, 3.2179634849E+00, 5.9468618461E+00, 1.0600189526E-01, 1.0088063700E-01, 4.7504369722E-01],
	[8.2700000000E+03, 3.2204581564E+00, 5.9457791841E+00, 1.0620046634E-01, 1.0106261407E-01, 4.7521496941E-01],
	[8.2750000000E+03, 3.2229532524E+00, 5.9446973734E+00, 1.0639928875E-01, 1.0124479828E-01, 4.7538619385E-01],
	[8.2800000000E+03, 3.2254487725E+00, 5.9436164127E+00, 1.0659836267E-01, 1.0142718970E-01, 4.7555737065E-01],
	[8.2850000000E+03, 3.2279447167E+00, 5.9425363011E+00, 1.0679768826E-01, 1.0160978840E-01, 4.7572849992E-01],
	[8.2900000000E+03, 3.2304410847E+00, 5.9414570371E+00, 1.0699726567E-01, 1.0179259446E-01, 4.7589958174E-01],
	[8.2950000000E+03, 3.2329378763E+00, 5.9403786198E+00, 1.0719709508E-01, 1.0197560795E-01, 4.7607061622E-01],
	[8.3000000000E+03, 3.2354350915E+00, 5.9393010479E+00, 1.0739717665E-01, 1.0215882894E-01, 4.7624160345E-01],
	[8.3050000000E+03, 3.2379327299E+00, 5.9382243202E+00, 1.0759751056E-01, 1.0234225751E-01, 4.7641254354E-01],
	[8.3100000000E+03, 3.2404307914E+00, 5.9371484355E+00, 1.0779809695E-01, 1.0252589372E-01, 4.7658343658E-01],
	[8.3150000000E+03, 3.2429292758E+00, 5.9360733928E+00, 1.0799893600E-01, 1.0270973766E-01, 4.7675428267E-01],
	[8.3200000000E+03, 3.2454281830E+00, 5.9349991908E+00, 1.0820002788E-01, 1.0289378938E-01, 4.7692508192E-01],
	[8.3250000000E+03, 3.2479275127E+00, 5.9339258284E+00, 1.0840137275E-01, 1.0307804897E-01, 4.7709583440E-01],
	[8.3300000000E+03, 3.2504272648E+00, 5.9328533044E+00, 1.0860297077E-01, 1.0326251650E-01, 4.7726654024E-01],
	[8.3350000000E+03, 3.2529274391E+00, 5.9317816177E+00, 1.0880482211E-01, 1.0344719204E-01, 4.7743719952E-01],
	[8.3400000000E+03, 3.2554321757E+00, 5.9307273159E+00, 1.0900692694E-01, 1.0363208490E-01, 4.7760781234E-01],
	[8.3450000000E+03, 3.2579374673E+00, 5.9296743492E+00, 1.0920928542E-01, 1.0381718626E-01, 4.7777837880E-01],
	[8.3500000000E+03, 3.2604431845E+00, 5.9286222000E+00, 1.0941189772E-01, 1.0400249591E-01, 4.7794889900E-01],
	[8.3550000000E+03, 3.2629493271E+00, 5.9275708671E+00, 1.0961476400E-01, 1.0418801391E-01, 4.7811937303E-01],
	[8.3600000000E+03, 3.2654558950E+00, 5.9265203495E+00, 1.0981788442E-01, 1.0437374033E-01, 4.7828980099E-01],
	[8.3650000000E+03, 3.2679628881E+00, 5.9254706460E+00, 1.1002125917E-01, 1.0455967526E-01, 4.7846018299E-01],
	[8.3700000000E+03, 3.2704703060E+00, 5.9244217555E+00, 1.1022488839E-01, 1.0474581874E-01, 4.7863051911E-01],
	[8.3750000000E+03, 3.2729781487E+00, 5.9233736769E+00, 1.1042877225E-01, 1.0493217087E-01, 4.7880080946E-01],
	[8.3800000000E+03, 3.2754864160E+00, 5.9223264090E+00, 1.1063291093E-01, 1.0511873171E-01, 4.7897105413E-01],
	[8.3850000000E+03, 3.2779951076E+00, 5.9212799509E+00, 1.1083730458E-01, 1.0530550133E-01, 4.7914125322E-01],
	[8.3900000000E+03, 3.2805042234E+00, 5.9202343013E+00, 1.1104195337E-01, 1.0549247980E-01, 4.7931140683E-01],
	[8.3950000000E+03, 3.2830137632E+00, 5.9191894591E+00, 1.1124685747E-01, 1.0567966720E-01, 4.7948151506E-01],
	[8.4000000000E+03, 3.2855237269E+00, 5.9181454234E+00, 1.1145201704E-01, 1.0586706359E-01, 4.7965157799E-01],
	[8.4050000000E+03, 3.2880341142E+00, 5.9171021928E+00, 1.1165743225E-01, 1.0605466904E-01, 4.7982159573E-01],
	[8.4100000000E+03, 3.2905449250E+00, 5.9160597664E+00, 1.1186310326E-01, 1.0624248362E-01, 4.7999156838E-01],
	[8.4150000000E+03, 3.2930561590E+00, 5.9150181431E+00, 1.1206903025E-01, 1.0643050741E-01, 4.8016149603E-01],
	[8.4200000000E+03, 3.2955678162E+00, 5.9139773217E+00, 1.1227521336E-01, 1.0661874048E-01, 4.8033137878E-01],
	[8.4250000000E+03, 3.2980798963E+00, 5.9129373012E+00, 1.1248165278E-01, 1.0680718288E-01, 4.8050121673E-01],
	[8.4300000000E+03, 3.3005923991E+00, 5.9118980805E+00, 1.1268834867E-01, 1.0699583470E-01, 4.8067100997E-01],
	[8.4350000000E+03, 3.3031053245E+00, 5.9108596584E+00, 1.1289530118E-01, 1.0718469601E-01, 4.8084075859E-01],
	[8.4400000000E+03, 3.3056186723E+00, 5.9098220339E+00, 1.1310251050E-01, 1.0737376687E-01, 4.8101046270E-01],
	[8.4450000000E+03, 3.3081324423E+00, 5.9087852060E+00, 1.1330997677E-01, 1.0756304735E-01, 4.8118012240E-01],
	[8.4500000000E+03, 3.3106466344E+00, 5.9077491735E+00, 1.1351770018E-01, 1.0775253752E-01, 4.8134973777E-01],
	[8.4550000000E+03, 3.3131612483E+00, 5.9067139353E+00, 1.1372568088E-01, 1.0794223745E-01, 4.8151930892E-01],
	[8.4600000000E+03, 3.3156762838E+00, 5.9056794904E+00, 1.1393391904E-01, 1.0813214721E-01, 4.8168883593E-01],
	[8.4650000000E+03, 3.3181917409E+00, 5.9046458377E+00, 1.1414241483E-01, 1.0832226687E-01, 4.8185831892E-01],
	[8.4700000000E+03, 3.3207081722E+00, 5.9036151489E+00, 1.1435116841E-01, 1.0851259782E-01, 4.8202775797E-01],
	[8.4750000000E+03, 3.3232286362E+00, 5.9025994256E+00, 1.1456017994E-01, 1.0870314749E-01, 4.8219715317E-01],
	[8.4800000000E+03, 3.3257495251E+00, 5.9015844760E+00, 1.1476944960E-01, 1.0889390732E-01, 4.8236650463E-01],
	[8.4850000000E+03, 3.3282708386E+00, 5.9005702990E+00, 1.1497897755E-01, 1.0908487739E-01, 4.8253581245E-01],
	[8.4900000000E+03, 3.3307925765E+00, 5.8995568937E+00, 1.1518884803E-01, 1.0927613342E-01, 4.8270507671E-01],
	[8.4950000000E+03, 3.3333147387E+00, 5.8985442588E+00, 1.1539898240E-01, 1.0946760455E-01, 4.8287429751E-01],
	[8.5000000000E+03, 3.3358373251E+00, 5.8975323934E+00, 1.1560937587E-01, 1.0965928636E-01, 4.8304347495E-01],
	[8.5050000000E+03, 3.3383603353E+00, 5.8965212966E+00, 1.1582002859E-01, 1.0985117893E-01, 4.8321260912E-01],
	[8.5100000000E+03, 3.3408837693E+00, 5.8955109671E+00, 1.1603094072E-01, 1.1004328231E-01, 4.8338170012E-01],
	[8.5150000000E+03, 3.3434076269E+00, 5.8945014041E+00, 1.1624211244E-01, 1.1023559659E-01, 4.8355074805E-01],
	[8.5200000000E+03, 3.3459319078E+00, 5.8934926064E+00, 1.1645354391E-01, 1.1042812182E-01, 4.8371975300E-01],
	[8.5250000000E+03, 3.3484566120E+00, 5.8924845730E+00, 1.1666523530E-01, 1.1062085808E-01, 4.8388871506E-01],
	[8.5300000000E+03, 3.3509817391E+00, 5.8914773030E+00, 1.1687718677E-01, 1.1081380543E-01, 4.8405763433E-01],
	[8.5350000000E+03, 3.3535072892E+00, 5.8904707953E+00, 1.1708939850E-01, 1.1100696394E-01, 4.8422651091E-01],
	[8.5400000000E+03, 3.3560332619E+00, 5.8894650488E+00, 1.1730187063E-01, 1.1120033367E-01, 4.8439534489E-01],
	[8.5450000000E+03, 3.3585596571E+00, 5.8884600626E+00, 1.1751460336E-01, 1.1139391470E-01, 4.8456413637E-01],
	[8.5500000000E+03, 3.3610864747E+00, 5.8874558355E+00, 1.1772759683E-01, 1.1158770709E-01, 4.8473288544E-01],
	[8.5550000000E+03, 3.3636137144E+00, 5.8864523667E+00, 1.1794085121E-01, 1.1178171091E-01, 4.8490159219E-01],
	[8.5600000000E+03, 3.3661413760E+00, 5.8854496551E+00, 1.1815436668E-01, 1.1197592623E-01, 4.8507025673E-01],
	[8.5650000000E+03, 3.3686694595E+00, 5.8844476997E+00, 1.1836814339E-01, 1.1217035310E-01, 4.8523887914E-01],
	[8.5700000000E+03, 3.3711979646E+00, 5.8834464995E+00, 1.1858218152E-01, 1.1236499161E-01, 4.8540745952E-01],
	[8.5750000000E+03, 3.3737268911E+00, 5.8824460534E+00, 1.1879648123E-01, 1.1255984181E-01, 4.8557599797E-01],
	[8.5800000000E+03, 3.3762562389E+00, 5.8814463604E+00, 1.1901104269E-01, 1.1275490377E-01, 4.8574449458E-01],
	[8.5850000000E+03, 3.3787860078E+00, 5.8804474196E+00, 1.1922586606E-01, 1.1295017756E-01, 4.8591294944E-01],
	[8.5900000000E+03, 3.3813161976E+00, 5.8794492299E+00, 1.1944095151E-01, 1.1314566325E-01, 4.8608136265E-01],
	[8.5950000000E+03, 3.3838468082E+00, 5.8784517904E+00, 1.1965629920E-01, 1.1334136089E-01, 4.8624973431E-01],
	[8.6000000000E+03, 3.3863778393E+00, 5.8774551000E+00, 1.1987190931E-01, 1.1353727056E-01, 4.8641806451E-01],
	[8.6050000000E+03, 3.3889092908E+00, 5.8764591578E+00, 1.2008778200E-01, 1.1373339232E-01, 4.8658635333E-01],
	[8.6100000000E+03, 3.3914446676E+00, 5.8754774911E+00, 1.2030391743E-01, 1.1392973528E-01, 4.8675460089E-01],
	[8.6150000000E+03, 3.3939810202E+00, 5.8744986888E+00, 1.2052031578E-01, 1.1412629194E-01, 4.8692280726E-01],
	[8.6200000000E+03, 3.3965177963E+00, 5.8735206174E+00, 1.2073697720E-01, 1.1432306096E-01, 4.8709097255E-01],
	[8.6250000000E+03, 3.3990549959E+00, 5.8725432758E+00, 1.2095390186E-01, 1.1452004238E-01, 4.8725909685E-01],
	[8.6300000000E+03, 3.4015926187E+00, 5.8715666631E+00, 1.2117108994E-01, 1.1471723629E-01, 4.8742718026E-01],
	[8.6350000000E+03, 3.4041306645E+00, 5.8705907783E+00, 1.2138854160E-01, 1.1491464274E-01, 4.8759522286E-01],
	[8.6400000000E+03, 3.4066691332E+00, 5.8696156205E+00, 1.2160625700E-01, 1.1511226180E-01, 4.8776322475E-01],
	[8.6450000000E+03, 3.4092080247E+00, 5.8686411887E+00, 1.2182423631E-01, 1.1531009354E-01, 4.8793118603E-01],
	[8.6500000000E+03, 3.4117473386E+00, 5.8676674820E+00, 1.2204247969E-01, 1.1550813801E-01, 4.8809910679E-01],
	[8.6550000000E+03, 3.4142870749E+00, 5.8666944993E+00, 1.2226098732E-01, 1.1570639529E-01, 4.8826698712E-01],
	[8.6600000000E+03, 3.4168272334E+00, 5.8657222398E+00, 1.2247975936E-01, 1.1590486544E-01, 4.8843482712E-01],
	[8.6650000000E+03, 3.4193678139E+00, 5.8647507025E+00, 1.2269879597E-01, 1.1610354852E-01, 4.8860262688E-01],
	[8.6700000000E+03, 3.4219088162E+00, 5.8637798864E+00, 1.2291809733E-01, 1.1630244460E-01, 4.8877038649E-01],
	[8.6750000000E+03, 3.4244502402E+00, 5.8628097905E+00, 1.2313766360E-01, 1.1650155373E-01, 4.8893810605E-01],
	[8.6800000000E+03, 3.4269920857E+00, 5.8618404140E+00, 1.2335749494E-01, 1.1670087600E-01, 4.8910578565E-01],
	[8.6850000000E+03, 3.4295343525E+00, 5.8608717558E+00, 1.2357759153E-01, 1.1690041145E-01, 4.8927342538E-01],
	[8.6900000000E+03, 3.4320770404E+00, 5.8599038151E+00, 1.2379795352E-01, 1.1710016015E-01, 4.8944102535E-01],
	[8.6950000000E+03, 3.4346201493E+00, 5.8589365909E+00, 1.2401858109E-01, 1.1730012217E-01, 4.8960858563E-01],
	[8.7000000000E+03, 3.4371636790E+00, 5.8579700822E+00, 1.2423947440E-01, 1.1750029756E-01, 4.8977610633E-01],
	[8.7050000000E+03, 3.4397076293E+00, 5.8570042882E+00, 1.2446063362E-01, 1.1770068640E-01, 4.8994358754E-01],
	[8.7100000000E+03, 3.4422520001E+00, 5.8560392078E+00, 1.2468205892E-01, 1.1790128875E-01, 4.9011102935E-01],
	[8.7150000000E+03, 3.4447967912E+00, 5.8550748401E+00, 1.2490375045E-01, 1.1810210466E-01, 4.9027843185E-01],
	[8.7200000000E+03, 3.4473420023E+00, 5.8541111842E+00, 1.2512570840E-01, 1.1830313421E-01, 4.9044579514E-01],
	[8.7250000000E+03, 3.4498876334E+00, 5.8531482392E+00, 1.2534793292E-01, 1.1850437744E-01, 4.9061311931E-01],
	[8.7300000000E+03, 3.4524336843E+00, 5.8521860041E+00, 1.2557042418E-01, 1.1870583444E-01, 4.9078040445E-01],
	[8.7350000000E+03, 3.4549801548E+00, 5.8512244780E+00, 1.2579318235E-01, 1.1890750525E-01, 4.9094765066E-01],
	[8.7400000000E+03, 3.4575270446E+00, 5.8502636600E+00, 1.2601620759E-01, 1.1910938995E-01, 4.9111485803E-01],
	[8.7450000000E+03, 3.4600749695E+00, 5.8493058875E+00, 1.2623950008E-01, 1.1931149029E-01, 4.9128202665E-01],
	[8.7500000000E+03, 3.4626266485E+00, 5.8483614711E+00, 1.2646305997E-01, 1.1951381390E-01, 4.9144915662E-01],
	[8.7550000000E+03, 3.4651787500E+00, 5.8474177465E+00, 1.2668688744E-01, 1.1971635165E-01, 4.9161624802E-01],
	[8.7600000000E+03, 3.4677312738E+00, 5.8464747129E+00, 1.2691098264E-01, 1.1991910358E-01, 4.9178330095E-01],
	[8.7650000000E+03, 3.4702842197E+00, 5.8455323693E+00, 1.2713534576E-01, 1.2012206977E-01, 4.9195031551E-01],
	[8.7700000000E+03, 3.4728375876E+00, 5.8445907150E+00, 1.2735997695E-01, 1.2032525028E-01, 4.9211729178E-01],
	[8.7750000000E+03, 3.4753913773E+00, 5.8436497488E+00, 1.2758487638E-01, 1.2052864516E-01, 4.9228422986E-01],
	[8.7800000000E+03, 3.4779455886E+00, 5.8427094701E+00, 1.2781004422E-01, 1.2073225449E-01, 4.9245112984E-01],
	[8.7850000000E+03, 3.4805002213E+00, 5.8417698778E+00, 1.2803548064E-01, 1.2093607831E-01, 4.9261799181E-01],
	[8.7900000000E+03, 3.4830552753E+00, 5.8408309712E+00, 1.2826118579E-01, 1.2114011669E-01, 4.9278481587E-01],
	[8.7950000000E+03, 3.4856107504E+00, 5.8398927492E+00, 1.2848715985E-01, 1.2134436970E-01, 4.9295160210E-01],
	[8.8000000000E+03, 3.4881666464E+00, 5.8389552110E+00, 1.2871340299E-01, 1.2154883739E-01, 4.9311835061E-01],
	[8.8050000000E+03, 3.4907229632E+00, 5.8380183558E+00, 1.2893991537E-01, 1.2175351983E-01, 4.9328506147E-01],
	[8.8100000000E+03, 3.4932797006E+00, 5.8370821826E+00, 1.2916669716E-01, 1.2195841706E-01, 4.9345173479E-01],
	[8.8150000000E+03, 3.4958368585E+00, 5.8361466906E+00, 1.2939374852E-01, 1.2216352917E-01, 4.9361837066E-01],
	[8.8200000000E+03, 3.4983944366E+00, 5.8352118788E+00, 1.2962106962E-01, 1.2236885620E-01, 4.9378496916E-01],
	[8.8250000000E+03, 3.5009524347E+00, 5.8342777464E+00, 1.2984866063E-01, 1.2257439821E-01, 4.9395153040E-01],
	[8.8300000000E+03, 3.5035108528E+00, 5.8333442926E+00, 1.3007652172E-01, 1.2278015527E-01, 4.9411805446E-01],
	[8.8350000000E+03, 3.5060696907E+00, 5.8324115164E+00, 1.3030465305E-01, 1.2298612744E-01, 4.9428454143E-01],
	[8.8400000000E+03, 3.5086289481E+00, 5.8314794170E+00, 1.3053305479E-01, 1.2319231477E-01, 4.9445099141E-01],
	[8.8450000000E+03, 3.5111886249E+00, 5.8305479934E+00, 1.3076172710E-01, 1.2339871733E-01, 4.9461740449E-01],
	[8.8500000000E+03, 3.5137487210E+00, 5.8296172449E+00, 1.3099067015E-01, 1.2360533517E-01, 4.9478378075E-01],
	[8.8550000000E+03, 3.5163092362E+00, 5.8286871705E+00, 1.3121988411E-01, 1.2381216836E-01, 4.9495012030E-01],
	[8.8600000000E+03, 3.5188701702E+00, 5.8277577694E+00, 1.3144936915E-01, 1.2401921695E-01, 4.9511642323E-01],
	[8.8650000000E+03, 3.5214315230E+00, 5.8268290407E+00, 1.3167912543E-01, 1.2422648100E-01, 4.9528268961E-01],
	[8.8700000000E+03, 3.5239932944E+00, 5.8259009836E+00, 1.3190915313E-01, 1.2443396057E-01, 4.9544891956E-01],
	[8.8750000000E+03, 3.5265554842E+00, 5.8249735972E+00, 1.3213945239E-01, 1.2464165572E-01, 4.9561511315E-01],
	[8.8800000000E+03, 3.5291180922E+00, 5.8240468805E+00, 1.3237002340E-01, 1.2484956652E-01, 4.9578127049E-01],
	[8.8850000000E+03, 3.5316811256E+00, 5.8231208605E+00, 1.3260086632E-01, 1.2505769303E-01, 4.9594739165E-01],
	[8.8900000000E+03, 3.5342484117E+00, 5.8222098243E+00, 1.3283198132E-01, 1.2526604674E-01, 4.9611347674E-01],
	[8.8950000000E+03, 3.5368161189E+00, 5.8212994427E+00, 1.3306336856E-01, 1.2547461633E-01, 4.9627952584E-01],
	[8.9000000000E+03, 3.5393842470E+00, 5.8203897150E+00, 1.3329502821E-01, 1.2568340186E-01, 4.9644553905E-01],
	[8.9050000000E+03, 3.5419527960E+00, 5.8194806402E+00, 1.3352696043E-01, 1.2589240339E-01, 4.9661151646E-01],
	[8.9100000000E+03, 3.5445217657E+00, 5.8185722176E+00, 1.3375916541E-01, 1.2610162097E-01, 4.9677745815E-01],
	[8.9150000000E+03, 3.5470911558E+00, 5.8176644463E+00, 1.3399164329E-01, 1.2631105466E-01, 4.9694336411E-01],
	[8.9200000000E+03, 3.5496609662E+00, 5.8167573255E+00, 1.3422439425E-01, 1.2652070452E-01, 4.9710923440E-01],
	[8.9250000000E+03, 3.5522311968E+00, 5.8158508544E+00, 1.3445741845E-01, 1.2673057061E-01, 4.9727506907E-01],
	[8.9300000000E+03, 3.5548018474E+00, 5.8149450321E+00, 1.3469071607E-01, 1.2694065299E-01, 4.9744086818E-01],
	[8.9350000000E+03, 3.5573729178E+00, 5.8140398578E+00, 1.3492428727E-01, 1.2715095170E-01, 4.9760663177E-01],
	[8.9400000000E+03, 3.5599444078E+00, 5.8131353307E+00, 1.3515813221E-01, 1.2736146682E-01, 4.9777235992E-01],
	[8.9450000000E+03, 3.5625163173E+00, 5.8122314499E+00, 1.3539225106E-01, 1.2757219840E-01, 4.9793805267E-01],
	[8.9500000000E+03, 3.5650886461E+00, 5.8113282146E+00, 1.3562664399E-01, 1.2778314648E-01, 4.9810371009E-01],
	[8.9550000000E+03, 3.5676613941E+00, 5.8104256241E+00, 1.3586131117E-01, 1.2799431114E-01, 4.9826933222E-01],
	[8.9600000000E+03, 3.5702345611E+00, 5.8095236774E+00, 1.3609625277E-01, 1.2820569243E-01, 4.9843491913E-01],
	[8.9650000000E+03, 3.5728081469E+00, 5.8086223739E+00, 1.3633146894E-01, 1.2841729040E-01, 4.9860047086E-01],
	[8.9700000000E+03, 3.5753821513E+00, 5.8077217125E+00, 1.3656695986E-01, 1.2862910511E-01, 4.9876598749E-01],
	[8.9750000000E+03, 3.5779565742E+00, 5.8068216926E+00, 1.3680272569E-01, 1.2884113662E-01, 4.9893146906E-01],
	[8.9800000000E+03, 3.5805314155E+00, 5.8059223134E+00, 1.3703876661E-01, 1.2905338499E-01, 4.9909691563E-01],
	[8.9850000000E+03, 3.5831066749E+00, 5.8050235739E+00, 1.3727508277E-01, 1.2926585026E-01, 4.9926232726E-01],
	[8.9900000000E+03, 3.5856823522E+00, 5.8041254734E+00, 1.3751167435E-01, 1.2947853249E-01, 4.9942770400E-01],
	[8.9950000000E+03, 3.5882584475E+00, 5.8032280112E+00, 1.3774854152E-01, 1.2969143175E-01, 4.9959304591E-01],
	[9.0000000000E+03, 3.5908349604E+00, 5.8023311863E+00, 1.3798568443E-01, 1.2990454809E-01, 4.9975835305E-01],
	[9.0050000000E+03, 3.5934118907E+00, 5.8014349980E+00, 1.3822447568E-01, 1.3011909774E-01, 4.9992362547E-01],
	[9.0100000000E+03, 3.5959892385E+00, 5.8005394454E+00, 1.3846354698E-01, 1.3033386772E-01, 5.0008886323E-01],
	[9.0150000000E+03, 3.5985670034E+00, 5.7996445279E+00, 1.3870289851E-01, 1.3054885808E-01, 5.0025406639E-01],
	[9.0200000000E+03, 3.6011451853E+00, 5.7987502445E+00, 1.3894253044E-01, 1.3076406887E-01, 5.0041923500E-01],
	[9.0250000000E+03, 3.6037237840E+00, 5.7978565944E+00, 1.3918244294E-01, 1.3097950016E-01, 5.0058436911E-01],
	[9.0300000000E+03, 3.6063042825E+00, 5.7969689983E+00, 1.3942263617E-01, 1.3119515674E-01, 5.0074946879E-01],
	[9.0350000000E+03, 3.6088874744E+00, 5.7960903405E+00, 1.3966311033E-01, 1.3141104125E-01, 5.0091453410E-01],
	[9.0400000000E+03, 3.6114710860E+00, 5.7952123019E+00, 1.3990386556E-01, 1.3162714649E-01, 5.0107956508E-01],
	[9.0450000000E+03, 3.6140551170E+00, 5.7943348817E+00, 1.4014490206E-01, 1.3184347252E-01, 5.0124456179E-01],
	[9.0500000000E+03, 3.6166395674E+00, 5.7934580792E+00, 1.4038621999E-01, 1.3206001941E-01, 5.0140952429E-01],
	[9.0550000000E+03, 3.6192244369E+00, 5.7925818935E+00, 1.4062781952E-01, 1.3227678719E-01, 5.0157445264E-01],
	[9.0600000000E+03, 3.6218097254E+00, 5.7917063239E+00, 1.4086970083E-01, 1.3249377594E-01, 5.0173934689E-01],
	[9.0650000000E+03, 3.6243954328E+00, 5.7908313696E+00, 1.4111186408E-01, 1.3271098571E-01, 5.0190420710E-01],
	[9.0700000000E+03, 3.6269815588E+00, 5.7899570299E+00, 1.4135430946E-01, 1.3292841655E-01, 5.0206903333E-01],
	[9.0750000000E+03, 3.6295681034E+00, 5.7890833039E+00, 1.4159703713E-01, 1.3314606853E-01, 5.0223382563E-01],
	[9.0800000000E+03, 3.6321550662E+00, 5.7882101909E+00, 1.4184004726E-01, 1.3336394169E-01, 5.0239858405E-01],
	[9.0850000000E+03, 3.6347424473E+00, 5.7873376901E+00, 1.4208334003E-01, 1.3358203609E-01, 5.0256330866E-01],
	[9.0900000000E+03, 3.6373302464E+00, 5.7864658008E+00, 1.4232691561E-01, 1.3380035179E-01, 5.0272799952E-01],
	[9.0950000000E+03, 3.6399184633E+00, 5.7855945222E+00, 1.4257077417E-01, 1.3401888885E-01, 5.0289265666E-01],
	[9.1000000000E+03, 3.6425070979E+00, 5.7847238536E+00, 1.4281491589E-01, 1.3423764732E-01, 5.0305728016E-01],
	[9.1050000000E+03, 3.6450961500E+00, 5.7838537941E+00, 1.4305934093E-01, 1.3445662725E-01, 5.0322187007E-01],
	[9.1100000000E+03, 3.6476856196E+00, 5.7829843430E+00, 1.4330404947E-01, 1.3467582871E-01, 5.0338642645E-01],
	[9.1150000000E+03, 3.6502755063E+00, 5.7821154996E+00, 1.4354904168E-01, 1.3489525174E-01, 5.0355094934E-01],
	[9.1200000000E+03, 3.6528658101E+00, 5.7812472631E+00, 1.4379431774E-01, 1.3511489640E-01, 5.0371543882E-01],
	[9.1250000000E+03, 3.6554565307E+00, 5.7803796328E+00, 1.4403987781E-01, 1.3533476275E-01, 5.0387989493E-01],
	[9.1300000000E+03, 3.6580476681E+00, 5.7795126078E+00, 1.4428572208E-01, 1.3555485084E-01, 5.0404431773E-01],
	[9.1350000000E+03, 3.6606392220E+00, 5.7786461875E+00, 1.4453185070E-01, 1.3577516073E-01, 5.0420870727E-01],
	[9.1400000000E+03, 3.6632311923E+00, 5.7777803710E+00, 1.4477826386E-01, 1.3599569246E-01, 5.0437306362E-01],
	[9.1450000000E+03, 3.6658235789E+00, 5.7769151577E+00, 1.4502496172E-01, 1.3621644610E-01, 5.0453738683E-01],
	[9.1500000000E+03, 3.6684163816E+00, 5.7760505467E+00, 1.4527194447E-01, 1.3643742170E-01, 5.0470167696E-01],
	[9.1550000000E+03, 3.6710096001E+00, 5.7751865374E+00, 1.4551921226E-01, 1.3665861931E-01, 5.0486593405E-01],
	[9.1600000000E+03, 3.6736032345E+00, 5.7743231290E+00, 1.4576676528E-01, 1.3688003898E-01, 5.0503015817E-01],
	[9.1650000000E+03, 3.6761972844E+00, 5.7734603207E+00, 1.4601460369E-01, 1.3710168078E-01, 5.0519434938E-01],
	[9.1700000000E+03, 3.6787917497E+00, 5.7725981118E+00, 1.4626272768E-01, 1.3732354474E-01, 5.0535850773E-01],
	[9.1750000000E+03, 3.6813878504E+00, 5.7717408096E+00, 1.4651113740E-01, 1.3754563509E-01, 5.0552263327E-01],
	[9.1800000000E+03, 3.6839868804E+00, 5.7708929688E+00, 1.4675983304E-01, 1.3776795630E-01, 5.0568672606E-01],
	[9.1850000000E+03, 3.6865863286E+00, 5.7700457142E+00, 1.4700881476E-01, 1.3799049992E-01, 5.0585078617E-01],
	[9.1900000000E+03, 3.6891861949E+00, 5.7691990449E+00, 1.4725808274E-01, 1.3821326599E-01, 5.0601481363E-01],
	[9.1950000000E+03, 3.6917864790E+00, 5.7683529603E+00, 1.4750763716E-01, 1.3843625458E-01, 5.0617880852E-01],
	[9.2000000000E+03, 3.6943871808E+00, 5.7675074596E+00, 1.4775747818E-01, 1.3865946572E-01, 5.0634277089E-01],
	[9.2050000000E+03, 3.6969883002E+00, 5.7666625422E+00, 1.4800760597E-01, 1.3888289948E-01, 5.0650670079E-01],
	[9.2100000000E+03, 3.6995898370E+00, 5.7658182072E+00, 1.4825802072E-01, 1.3910655591E-01, 5.0667059827E-01],
	[9.2150000000E+03, 3.7021917910E+00, 5.7649744540E+00, 1.4850872259E-01, 1.3933043506E-01, 5.0683446341E-01],
	[9.2200000000E+03, 3.7047941620E+00, 5.7641312819E+00, 1.4875971175E-01, 1.3955453698E-01, 5.0699829624E-01],
	[9.2250000000E+03, 3.7073969500E+00, 5.7632886901E+00, 1.4901098837E-01, 1.3977886173E-01, 5.0716209683E-01],
	[9.2300000000E+03, 3.7100001547E+00, 5.7624466780E+00, 1.4926255264E-01, 1.4000340935E-01, 5.0732586524E-01],
	[9.2350000000E+03, 3.7126037760E+00, 5.7616052448E+00, 1.4951440472E-01, 1.4022817990E-01, 5.0748960152E-01],
	[9.2400000000E+03, 3.7152078137E+00, 5.7607643898E+00, 1.4976654479E-01, 1.4045317344E-01, 5.0765330572E-01],
	[9.2450000000E+03, 3.7178122678E+00, 5.7599241123E+00, 1.5001897301E-01, 1.4067839000E-01, 5.0781697790E-01],
	[9.2500000000E+03, 3.7204171379E+00, 5.7590844116E+00, 1.5027168956E-01, 1.4090382965E-01, 5.0798061812E-01],
	[9.2550000000E+03, 3.7230224239E+00, 5.7582452869E+00, 1.5052469462E-01, 1.4112949243E-01, 5.0814422644E-01],
	[9.2600000000E+03, 3.7256281258E+00, 5.7574067377E+00, 1.5077798835E-01, 1.4135537839E-01, 5.0830780290E-01],
	[9.2650000000E+03, 3.7282342433E+00, 5.7565687631E+00, 1.5103157093E-01, 1.4158148760E-01, 5.0847134757E-01],
	[9.2700000000E+03, 3.7308407763E+00, 5.7557313625E+00, 1.5128544254E-01, 1.4180782009E-01, 5.0863486051E-01],
	[9.2750000000E+03, 3.7334477246E+00, 5.7548945352E+00, 1.5153960333E-01, 1.4203437592E-01, 5.0879834176E-01],
	[9.2800000000E+03, 3.7360550881E+00, 5.7540582804E+00, 1.5179405349E-01, 1.4226115514E-01, 5.0896179139E-01],
	[9.2850000000E+03, 3.7386628666E+00, 5.7532225975E+00, 1.5204879319E-01, 1.4248815780E-01, 5.0912520944E-01],
	[9.2900000000E+03, 3.7412710599E+00, 5.7523874858E+00, 1.5230382261E-01, 1.4271538395E-01, 5.0928859599E-01],
	[9.2950000000E+03, 3.7438796679E+00, 5.7515529445E+00, 1.5255914191E-01, 1.4294283364E-01, 5.0945195107E-01],
	[9.3000000000E+03, 3.7464886905E+00, 5.7507189730E+00, 1.5281475126E-01, 1.4317050692E-01, 5.0961527476E-01],
	[9.3050000000E+03, 3.7490981274E+00, 5.7498855706E+00, 1.5307065085E-01, 1.4339840384E-01, 5.0977856710E-01],
	[9.3100000000E+03, 3.7517079786E+00, 5.7490527365E+00, 1.5332684084E-01, 1.4362652445E-01, 5.0994182815E-01],
	[9.3150000000E+03, 3.7543182438E+00, 5.7482204702E+00, 1.5358332140E-01, 1.4385486879E-01, 5.1010505796E-01],
	[9.3200000000E+03, 3.7569289229E+00, 5.7473887709E+00, 1.5384009271E-01, 1.4408343693E-01, 5.1026825660E-01],
	[9.3250000000E+03, 3.7595429552E+00, 5.7465676389E+00, 1.5409715495E-01, 1.4431223954E-01, 5.1043142412E-01],
	[9.3300000000E+03, 3.7621581799E+00, 5.7457497033E+00, 1.5435450828E-01, 1.4454126892E-01, 5.1059456058E-01],
	[9.3350000000E+03, 3.7647738212E+00, 5.7449323223E+00, 1.5461215288E-01, 1.4477052230E-01, 5.1075766602E-01],
	[9.3400000000E+03, 3.7673898790E+00, 5.7441154951E+00, 1.5487008891E-01, 1.4499999974E-01, 5.1092074051E-01],
	[9.3450000000E+03, 3.7700063530E+00, 5.7432992211E+00, 1.5512831656E-01, 1.4522970128E-01, 5.1108378410E-01],
	[9.3500000000E+03, 3.7726232432E+00, 5.7424834997E+00, 1.5538683600E-01, 1.4545962699E-01, 5.1124679686E-01],
	[9.3550000000E+03, 3.7752405494E+00, 5.7416683302E+00, 1.5564564739E-01, 1.4568977689E-01, 5.1140977882E-01],
	[9.3600000000E+03, 3.7778582714E+00, 5.7408537118E+00, 1.5590475092E-01, 1.4592015105E-01, 5.1157273006E-01],
	[9.3650000000E+03, 3.7804764091E+00, 5.7400396440E+00, 1.5616414674E-01, 1.4615074951E-01, 5.1173565062E-01],
	[9.3700000000E+03, 3.7830949623E+00, 5.7392261260E+00, 1.5642383505E-01, 1.4638157232E-01, 5.1189854057E-01],
	[9.3750000000E+03, 3.7857139308E+00, 5.7384131572E+00, 1.5668381601E-01, 1.4661261953E-01, 5.1206139996E-01],
	[9.3800000000E+03, 3.7883333146E+00, 5.7376007370E+00, 1.5694408979E-01, 1.4684389118E-01, 5.1222422884E-01],
	[9.3850000000E+03, 3.7909531134E+00, 5.7367888646E+00, 1.5720465656E-01, 1.4707538733E-01, 5.1238702727E-01],
	[9.3900000000E+03, 3.7935733271E+00, 5.7359775394E+00, 1.5746551651E-01, 1.4730710801E-01, 5.1254979531E-01],
	[9.3950000000E+03, 3.7961939555E+00, 5.7351667608E+00, 1.5772666979E-01, 1.4753905329E-01, 5.1271253301E-01],
	[9.4000000000E+03, 3.7988149985E+00, 5.7343565281E+00, 1.5798811659E-01, 1.4777122320E-01, 5.1287524043E-01],
	[9.4050000000E+03, 3.8014364560E+00, 5.7335468406E+00, 1.5824985708E-01, 1.4800361779E-01, 5.1303791762E-01],
	[9.4100000000E+03, 3.8040583277E+00, 5.7327376977E+00, 1.5851189143E-01, 1.4823623711E-01, 5.1320056464E-01],
	[9.4150000000E+03, 3.8066806135E+00, 5.7319290987E+00, 1.5877421981E-01, 1.4846908121E-01, 5.1336318156E-01],
	[9.4200000000E+03, 3.8093033133E+00, 5.7311210430E+00, 1.5903684240E-01, 1.4870215013E-01, 5.1352576841E-01],
	[9.4250000000E+03, 3.8119264269E+00, 5.7303135299E+00, 1.5929975937E-01, 1.4893544392E-01, 5.1368832526E-01],
	[9.4300000000E+03, 3.8145499542E+00, 5.7295065587E+00, 1.5956297089E-01, 1.4916896263E-01, 5.1385085217E-01],
	[9.4350000000E+03, 3.8171738949E+00, 5.7287001289E+00, 1.5982647714E-01, 1.4940270629E-01, 5.1401334918E-01],
	[9.4400000000E+03, 3.8197982490E+00, 5.7278942397E+00, 1.6009027829E-01, 1.4963667497E-01, 5.1417581637E-01],
	[9.4450000000E+03, 3.8224230163E+00, 5.7270888906E+00, 1.6035437451E-01, 1.4987086870E-01, 5.1433825377E-01],
	[9.4500000000E+03, 3.8250481967E+00, 5.7262840808E+00, 1.6061876597E-01, 1.5010528753E-01, 5.1450066145E-01],
	[9.4550000000E+03, 3.8276737899E+00, 5.7254798097E+00, 1.6088345285E-01, 1.5033993151E-01, 5.1466303947E-01],
	[9.4600000000E+03, 3.8302997959E+00, 5.7246760768E+00, 1.6114843532E-01, 1.5057480068E-01, 5.1482538788E-01],
	[9.4650000000E+03, 3.8329262144E+00, 5.7238728812E+00, 1.6141371355E-01, 1.5080989509E-01, 5.1498770673E-01],
	[9.4700000000E+03, 3.8355530453E+00, 5.7230702224E+00, 1.6167928773E-01, 1.5104521477E-01, 5.1514999608E-01],
	[9.4750000000E+03, 3.8381831725E+00, 5.7222775548E+00, 1.6194515801E-01, 1.5128077088E-01, 5.1531225600E-01],
	[9.4800000000E+03, 3.8408145283E+00, 5.7214880819E+00, 1.6221132457E-01, 1.5151655555E-01, 5.1547448652E-01],
	[9.4850000000E+03, 3.8434462992E+00, 5.7206991342E+00, 1.6247778759E-01, 1.5175256571E-01, 5.1563668772E-01],
	[9.4900000000E+03, 3.8460784850E+00, 5.7199107109E+00, 1.6274454724E-01, 1.5198880141E-01, 5.1579885964E-01],
	[9.4950000000E+03, 3.8487110856E+00, 5.7191228115E+00, 1.6301160370E-01, 1.5222526270E-01, 5.1596100234E-01],
	[9.5000000000E+03, 3.8513441008E+00, 5.7183354353E+00, 1.6327895713E-01, 1.5246194961E-01, 5.1612311588E-01],
	[9.5050000000E+03, 3.8539775305E+00, 5.7175485818E+00, 1.6354660770E-01, 1.5269886219E-01, 5.1628520032E-01],
	[9.5100000000E+03, 3.8566113745E+00, 5.7167622503E+00, 1.6381455560E-01, 1.5293600049E-01, 5.1644725570E-01],
	[9.5150000000E+03, 3.8592456327E+00, 5.7159764401E+00, 1.6408280100E-01, 1.5317336455E-01, 5.1660928209E-01],
	[9.5200000000E+03, 3.8618803049E+00, 5.7151911507E+00, 1.6435134406E-01, 1.5341095441E-01, 5.1677127954E-01],
	[9.5250000000E+03, 3.8645153909E+00, 5.7144063814E+00, 1.6462018496E-01, 1.5364877012E-01, 5.1693324810E-01],
	[9.5300000000E+03, 3.8671508906E+00, 5.7136221316E+00, 1.6488932388E-01, 1.5388681171E-01, 5.1709518776E-01],
	[9.5350000000E+03, 3.8697868039E+00, 5.7128384007E+00, 1.6515876099E-01, 1.5412507925E-01, 5.1725709853E-01],
	[9.5400000000E+03, 3.8724231306E+00, 5.7120551881E+00, 1.6542849645E-01, 1.5436357276E-01, 5.1741898045E-01],
	[9.5450000000E+03, 3.8750598705E+00, 5.7112724932E+00, 1.6569853046E-01, 1.5460229229E-01, 5.1758083354E-01],
	[9.5500000000E+03, 3.8776970236E+00, 5.7104903154E+00, 1.6596886316E-01, 1.5484123789E-01, 5.1774265784E-01],
	[9.5550000000E+03, 3.8803345895E+00, 5.7097086540E+00, 1.6623949475E-01, 1.5508040960E-01, 5.1790445338E-01],
	[9.5600000000E+03, 3.8829725683E+00, 5.7089275084E+00, 1.6651042540E-01, 1.5531980745E-01, 5.1806622018E-01],
	[9.5650000000E+03, 3.8856109597E+00, 5.7081468781E+00, 1.6678165527E-01, 1.5555943150E-01, 5.1822795827E-01],
	[9.5700000000E+03, 3.8882497636E+00, 5.7073667624E+00, 1.6705318454E-01, 1.5579928179E-01, 5.1838966768E-01],
	[9.5750000000E+03, 3.8908889799E+00, 5.7065871607E+00, 1.6732501338E-01, 1.5603935835E-01, 5.1855134845E-01],
	[9.5800000000E+03, 3.8935286083E+00, 5.7058080724E+00, 1.6759714198E-01, 1.5627966123E-01, 5.1871300061E-01],
	[9.5850000000E+03, 3.8961686488E+00, 5.7050294969E+00, 1.6786957049E-01, 1.5652019047E-01, 5.1887462417E-01],
	[9.5900000000E+03, 3.8988091012E+00, 5.7042514335E+00, 1.6814229909E-01, 1.5676094612E-01, 5.1903621918E-01],
	[9.5950000000E+03, 3.9014499653E+00, 5.7034738818E+00, 1.6841532796E-01, 1.5700192821E-01, 5.1919778566E-01],
	[9.6000000000E+03, 3.9040912409E+00, 5.7026968411E+00, 1.6868865728E-01, 1.5724313679E-01, 5.1935932364E-01],
	[9.6050000000E+03, 3.9067329281E+00, 5.7019203107E+00, 1.6896228720E-01, 1.5748457189E-01, 5.1952083315E-01],
	[9.6100000000E+03, 3.9093750265E+00, 5.7011442902E+00, 1.6923621791E-01, 1.5772623357E-01, 5.1968231423E-01],
	[9.6150000000E+03, 3.9120175360E+00, 5.7003687788E+00, 1.6951044959E-01, 1.5796812186E-01, 5.1984376690E-01],
	[9.6200000000E+03, 3.9146604566E+00, 5.6995937760E+00, 1.6978498239E-01, 1.5821023680E-01, 5.2000519119E-01],
	[9.6250000000E+03, 3.9173048385E+00, 5.6988226003E+00, 1.7005981650E-01, 1.5845258272E-01, 5.2016658713E-01],
	[9.6300000000E+03, 3.9199522617E+00, 5.6980602304E+00, 1.7033495210E-01, 1.5869516614E-01, 5.2032795475E-01],
	[9.6350000000E+03, 3.9226000984E+00, 5.6972983581E+00, 1.7061038934E-01, 1.5893797641E-01, 5.2048929408E-01],
	[9.6400000000E+03, 3.9252483486E+00, 5.6965369829E+00, 1.7088612842E-01, 1.5918101358E-01, 5.2065060516E-01],
	[9.6450000000E+03, 3.9278970121E+00, 5.6957761041E+00, 1.7116216949E-01, 1.5942427768E-01, 5.2081188801E-01],
	[9.6500000000E+03, 3.9305460887E+00, 5.6950157212E+00, 1.7143851274E-01, 1.5966776876E-01, 5.2097314266E-01],
	[9.6550000000E+03, 3.9331955784E+00, 5.6942558336E+00, 1.7171515833E-01, 1.5991148685E-01, 5.2113436914E-01],
	[9.6600000000E+03, 3.9358454808E+00, 5.6934964408E+00, 1.7199210645E-01, 1.6015543199E-01, 5.2129556748E-01],
	[9.6650000000E+03, 3.9384957960E+00, 5.6927375421E+00, 1.7226935726E-01, 1.6039960423E-01, 5.2145673771E-01],
	[9.6700000000E+03, 3.9411465237E+00, 5.6919791370E+00, 1.7254691093E-01, 1.6064400360E-01, 5.2161787987E-01],
	[9.6750000000E+03, 3.9437976638E+00, 5.6912212249E+00, 1.7282476765E-01, 1.6088863015E-01, 5.2177899397E-01],
	[9.6800000000E+03, 3.9464492162E+00, 5.6904638052E+00, 1.7310292758E-01, 1.6113348391E-01, 5.2194008006E-01],
	[9.6850000000E+03, 3.9491011807E+00, 5.6897068774E+00, 1.7338139090E-01, 1.6137856492E-01, 5.2210113816E-01],
	[9.6900000000E+03, 3.9517535571E+00, 5.6889504409E+00, 1.7366015778E-01, 1.6162387322E-01, 5.2226216831E-01],
	[9.6950000000E+03, 3.9544063453E+00, 5.6881944950E+00, 1.7393922840E-01, 1.6186940885E-01, 5.2242317052E-01],
	[9.7000000000E+03, 3.9570595452E+00, 5.6874390393E+00, 1.7421860292E-01, 1.6211517185E-01, 5.2258414484E-01],
	[9.7050000000E+03, 3.9597131565E+00, 5.6866840732E+00, 1.7449828153E-01, 1.6236116226E-01, 5.2274509129E-01],
	[9.7100000000E+03, 3.9623671793E+00, 5.6859295960E+00, 1.7477826439E-01, 1.6260738011E-01, 5.2290600991E-01],
	[9.7150000000E+03, 3.9650216132E+00, 5.6851756073E+00, 1.7505855168E-01, 1.6285382545E-01, 5.2306690072E-01],
	[9.7200000000E+03, 3.9676764582E+00, 5.6844221065E+00, 1.7533914357E-01, 1.6310049831E-01, 5.2322776375E-01],
	[9.7250000000E+03, 3.9703317141E+00, 5.6836690929E+00, 1.7562004024E-01, 1.6334739874E-01, 5.2338859903E-01],
	[9.7300000000E+03, 3.9729873808E+00, 5.6829165661E+00, 1.7590124185E-01, 1.6359452676E-01, 5.2354940660E-01],
	[9.7350000000E+03, 3.9756434581E+00, 5.6821645254E+00, 1.7618274859E-01, 1.6384188242E-01, 5.2371018649E-01],
	[9.7400000000E+03, 3.9782999459E+00, 5.6814129703E+00, 1.7646456063E-01, 1.6408946575E-01, 5.2387093872E-01],
	[9.7450000000E+03, 3.9809568440E+00, 5.6806619003E+00, 1.7674667814E-01, 1.6433727679E-01, 5.2403166332E-01],
	[9.7500000000E+03, 3.9836141523E+00, 5.6799113148E+00, 1.7702910129E-01, 1.6458531559E-01, 5.2419236033E-01],
	[9.7550000000E+03, 3.9862718706E+00, 5.6791612131E+00, 1.7731183025E-01, 1.6483358216E-01, 5.2435302978E-01],
	[9.7600000000E+03, 3.9889299988E+00, 5.6784115948E+00, 1.7759486521E-01, 1.6508207657E-01, 5.2451367169E-01],
	[9.7650000000E+03, 3.9915885367E+00, 5.6776624593E+00, 1.7787820633E-01, 1.6533079883E-01, 5.2467428610E-01],
	[9.7700000000E+03, 3.9942474842E+00, 5.6769138061E+00, 1.7816185380E-01, 1.6557974899E-01, 5.2483487304E-01],
	[9.7750000000E+03, 3.9969068412E+00, 5.6761656345E+00, 1.7844580777E-01, 1.6582892708E-01, 5.2499543254E-01],
	[9.7800000000E+03, 3.9995677068E+00, 5.6754212883E+00, 1.7873006842E-01, 1.6607833790E-01, 5.2515596462E-01],
	[9.7850000000E+03, 4.0022315453E+00, 5.6746852101E+00, 1.7901463594E-01, 1.6632798787E-01, 5.2531646933E-01],
	[9.7900000000E+03, 4.0048957959E+00, 5.6739496033E+00, 1.7929951049E-01, 1.6657786596E-01, 5.2547694668E-01],
	[9.7950000000E+03, 4.0075604583E+00, 5.6732144674E+00, 1.7958469225E-01, 1.6682797222E-01, 5.2563739671E-01],
	[9.8000000000E+03, 4.0102255325E+00, 5.6724798018E+00, 1.7987018138E-01, 1.6707830666E-01, 5.2579781946E-01],
	[9.8050000000E+03, 4.0128910181E+00, 5.6717456060E+00, 1.8015597807E-01, 1.6732886934E-01, 5.2595821494E-01],
	[9.8100000000E+03, 4.0155569153E+00, 5.6710118795E+00, 1.8044208249E-01, 1.6757966029E-01, 5.2611858320E-01],
	[9.8150000000E+03, 4.0182232236E+00, 5.6702786217E+00, 1.8072849480E-01, 1.6783067954E-01, 5.2627892426E-01],
	[9.8200000000E+03, 4.0208899431E+00, 5.6695458321E+00, 1.8101521520E-01, 1.6808192713E-01, 5.2643923815E-01],
	[9.8250000000E+03, 4.0235570736E+00, 5.6688135101E+00, 1.8130224384E-01, 1.6833340309E-01, 5.2659952491E-01],
	[9.8300000000E+03, 4.0262246150E+00, 5.6680816553E+00, 1.8158958090E-01, 1.6858510746E-01, 5.2675978456E-01],
	[9.8350000000E+03, 4.0288925670E+00, 5.6673502670E+00, 1.8187722656E-01, 1.6883704028E-01, 5.2692001713E-01],
	[9.8400000000E+03, 4.0315609295E+00, 5.6666193447E+00, 1.8216518098E-01, 1.6908920157E-01, 5.2708022266E-01],
	[9.8450000000E+03, 4.0342297025E+00, 5.6658888880E+00, 1.8245344436E-01, 1.6934159138E-01, 5.2724040118E-01],
	[9.8500000000E+03, 4.0368988857E+00, 5.6651588962E+00, 1.8274201684E-01, 1.6959420973E-01, 5.2740055272E-01],
	[9.8550000000E+03, 4.0395684790E+00, 5.6644293688E+00, 1.8303089862E-01, 1.6984705667E-01, 5.2756067730E-01],
	[9.8600000000E+03, 4.0422384822E+00, 5.6637003054E+00, 1.8332008987E-01, 1.7010013222E-01, 5.2772077496E-01],
	[9.8650000000E+03, 4.0449088953E+00, 5.6629717054E+00, 1.8360959075E-01, 1.7035343642E-01, 5.2788084574E-01],
	[9.8700000000E+03, 4.0475797181E+00, 5.6622435682E+00, 1.8389940144E-01, 1.7060696931E-01, 5.2804088965E-01],
	[9.8750000000E+03, 4.0502509504E+00, 5.6615158933E+00, 1.8418952212E-01, 1.7086073091E-01, 5.2820090673E-01],
	[9.8800000000E+03, 4.0529225920E+00, 5.6607886802E+00, 1.8447995296E-01, 1.7111472127E-01, 5.2836089702E-01],
	[9.8850000000E+03, 4.0555946429E+00, 5.6600619284E+00, 1.8477069414E-01, 1.7136894041E-01, 5.2852086054E-01],
	[9.8900000000E+03, 4.0582671029E+00, 5.6593356373E+00, 1.8506174582E-01, 1.7162338837E-01, 5.2868079732E-01],
	[9.8950000000E+03, 4.0609399719E+00, 5.6586098065E+00, 1.8535310818E-01, 1.7187806518E-01, 5.2884070740E-01],
	[9.9000000000E+03, 4.0636132496E+00, 5.6578844353E+00, 1.8564478140E-01, 1.7213297087E-01, 5.2900059080E-01],
	[9.9050000000E+03, 4.0662869360E+00, 5.6571595233E+00, 1.8593676565E-01, 1.7238810548E-01, 5.2916044756E-01],
	[9.9100000000E+03, 4.0689610309E+00, 5.6564350700E+00, 1.8622906110E-01, 1.7264346904E-01, 5.2932027771E-01],
	[9.9150000000E+03, 4.0716355342E+00, 5.6557110748E+00, 1.8652166792E-01, 1.7289906159E-01, 5.2948008128E-01],
	[9.9200000000E+03, 4.0743104458E+00, 5.6549875372E+00, 1.8681458630E-01, 1.7315488315E-01, 5.2963985829E-01],
	[9.9250000000E+03, 4.0769857654E+00, 5.6542644566E+00, 1.8710781640E-01, 1.7341093375E-01, 5.2979960879E-01],
	[9.9300000000E+03, 4.0796614929E+00, 5.6535418327E+00, 1.8740135840E-01, 1.7366721344E-01, 5.2995933280E-01],
	[9.9350000000E+03, 4.0823376283E+00, 5.6528196648E+00, 1.8769521247E-01, 1.7392372223E-01, 5.3011903035E-01],
	[9.9400000000E+03, 4.0850171503E+00, 5.6521066605E+00, 1.8798937879E-01, 1.7418047386E-01, 5.3027870148E-01],
	[9.9450000000E+03, 4.0876977535E+00, 5.6513960653E+00, 1.8828385753E-01, 1.7443745782E-01, 5.3043834621E-01],
	[9.9500000000E+03, 4.0903787670E+00, 5.6506859165E+00, 1.8857864886E-01, 1.7469467106E-01, 5.3059796457E-01],
	[9.9550000000E+03, 4.0930601907E+00, 5.6499762136E+00, 1.8887375296E-01, 1.7495211363E-01, 5.3075755661E-01],
	[9.9600000000E+03, 4.0957420244E+00, 5.6492669562E+00, 1.8916917001E-01, 1.7520978556E-01, 5.3091712234E-01],
	[9.9650000000E+03, 4.0984242680E+00, 5.6485581437E+00, 1.8946490016E-01, 1.7546768687E-01, 5.3107666180E-01],
	[9.9700000000E+03, 4.1011069214E+00, 5.6478497756E+00, 1.8976094361E-01, 1.7572581759E-01, 5.3123617502E-01],
	[9.9750000000E+03, 4.1037899843E+00, 5.6471418514E+00, 1.9005730052E-01, 1.7598417776E-01, 5.3139566203E-01],
	[9.9800000000E+03, 4.1064734568E+00, 5.6464343707E+00, 1.9035397107E-01, 1.7624276741E-01, 5.3155512287E-01],
	[9.9850000000E+03, 4.1091573385E+00, 5.6457273329E+00, 1.9065095544E-01, 1.7650158656E-01, 5.3171455756E-01],
	[9.9900000000E+03, 4.1118416294E+00, 5.6450207376E+00, 1.9094825378E-01, 1.7676063526E-01, 5.3187396613E-01],
	[9.9950000000E+03, 4.1145263293E+00, 5.6443145842E+00, 1.9124586629E-01, 1.7701991352E-01, 5.3203334862E-01],
	[1.0000000000E+04, 4.1172114382E+00, 5.6436088722E+00, 1.9154379313E-01, 1.7727942138E-01, 5.3219270506E-01],
	[1.0005000000E+04, 4.1198969558E+00, 5.6429036011E+00, 1.9184350542E-01, 1.7754041865E-01, 5.3235203548E-01],
	[1.0010000000E+04, 4.1225828820E+00, 5.6421987705E+00, 1.9214353630E-01, 1.7780164846E-01, 5.3251133991E-01],
	[1.0015000000E+04, 4.1252692166E+00, 5.6414943798E+00, 1.9244388593E-01, 1.7806311084E-01, 5.3267061838E-01],
	[1.0020000000E+04, 4.1279559596E+00, 5.6407904286E+00, 1.9274455452E-01, 1.7832480582E-01, 5.3282987092E-01],
	[1.0025000000E+04, 4.1306431108E+00, 5.6400869163E+00, 1.9304554222E-01, 1.7858673343E-01, 5.3298909757E-01],
	[1.0030000000E+04, 4.1333306700E+00, 5.6393838426E+00, 1.9334684922E-01, 1.7884889370E-01, 5.3314829835E-01],
	[1.0035000000E+04, 4.1360186371E+00, 5.6386812067E+00, 1.9364847571E-01, 1.7911128667E-01, 5.3330747330E-01],
	[1.0040000000E+04, 4.1387070119E+00, 5.6379790084E+00, 1.9395042185E-01, 1.7937391236E-01, 5.3346662245E-01],
	[1.0045000000E+04, 4.1413957944E+00, 5.6372772471E+00, 1.9425268783E-01, 1.7963677080E-01, 5.3362574583E-01],
	[1.0050000000E+04, 4.1440849844E+00, 5.6365759222E+00, 1.9455527382E-01, 1.7989986203E-01, 5.3378484347E-01],
	[1.0055000000E+04, 4.1467745816E+00, 5.6358750334E+00, 1.9485818002E-01, 1.8016318607E-01, 5.3394391541E-01],
	[1.0060000000E+04, 4.1494645861E+00, 5.6351745801E+00, 1.9516140658E-01, 1.8042674296E-01, 5.3410296166E-01],
	[1.0065000000E+04, 4.1521549976E+00, 5.6344745619E+00, 1.9546495370E-01, 1.8069053272E-01, 5.3426198228E-01],
	[1.0070000000E+04, 4.1548458161E+00, 5.6337749782E+00, 1.9576882155E-01, 1.8095455539E-01, 5.3442097728E-01],
	[1.0075000000E+04, 4.1575370413E+00, 5.6330758286E+00, 1.9607301030E-01, 1.8121881099E-01, 5.3457994669E-01],
	[1.0080000000E+04, 4.1602286731E+00, 5.6323771126E+00, 1.9637752015E-01, 1.8148329956E-01, 5.3473889056E-01],
	[1.0085000000E+04, 4.1629207114E+00, 5.6316788296E+00, 1.9668235127E-01, 1.8174802112E-01, 5.3489780891E-01],
	[1.0090000000E+04, 4.1656131561E+00, 5.6309809793E+00, 1.9698750384E-01, 1.8201297570E-01, 5.3505670178E-01],
	[1.0095000000E+04, 4.1683060070E+00, 5.6302835612E+00, 1.9729297803E-01, 1.8227816333E-01, 5.3521556919E-01],
	[1.0100000000E+04, 4.1710023427E+00, 5.6295950678E+00, 1.9759877402E-01, 1.8254359887E-01, 5.3537441117E-01],
	[1.0105000000E+04, 4.1736997390E+00, 5.6289087975E+00, 1.9790489200E-01, 1.8280927074E-01, 5.3553322774E-01],
	[1.0110000000E+04, 4.1763975441E+00, 5.6282229503E+00, 1.9821133215E-01, 1.8307517584E-01, 5.3569201888E-01],
	[1.0115000000E+04, 4.1790957578E+00, 5.6275375256E+00, 1.9851809463E-01, 1.8334131419E-01, 5.3585078460E-01],
	[1.0120000000E+04, 4.1817943801E+00, 5.6268525232E+00, 1.9882517964E-01, 1.8360768583E-01, 5.3600952492E-01],
	[1.0125000000E+04, 4.1844934106E+00, 5.6261679424E+00, 1.9913258735E-01, 1.8387429077E-01, 5.3616823984E-01],
	[1.0130000000E+04, 4.1871928494E+00, 5.6254837828E+00, 1.9944031794E-01, 1.8414112906E-01, 5.3632692938E-01],
	[1.0135000000E+04, 4.1898926962E+00, 5.6248000439E+00, 1.9974837158E-01, 1.8440820072E-01, 5.3648559354E-01],
	[1.0140000000E+04, 4.1925929510E+00, 5.6241167254E+00, 2.0005674847E-01, 1.8467550577E-01, 5.3664423235E-01],
	[1.0145000000E+04, 4.1952936135E+00, 5.6234338266E+00, 2.0036544877E-01, 1.8494304425E-01, 5.3680284582E-01],
	[1.0150000000E+04, 4.1979946837E+00, 5.6227513472E+00, 2.0067447266E-01, 1.8521081618E-01, 5.3696143395E-01],
	[1.0155000000E+04, 4.2006961614E+00, 5.6220692867E+00, 2.0098382033E-01, 1.8547882158E-01, 5.3711999675E-01],
	[1.0160000000E+04, 4.2033980464E+00, 5.6213876445E+00, 2.0129349195E-01, 1.8574706049E-01, 5.3727853425E-01],
	[1.0165000000E+04, 4.2061003387E+00, 5.6207064204E+00, 2.0160348771E-01, 1.8601553294E-01, 5.3743704646E-01],
	[1.0170000000E+04, 4.2088030381E+00, 5.6200256137E+00, 2.0191380778E-01, 1.8628423894E-01, 5.3759553337E-01],
	[1.0175000000E+04, 4.2115061444E+00, 5.6193452241E+00, 2.0222445234E-01, 1.8655317853E-01, 5.3775399502E-01],
	[1.0180000000E+04, 4.2142096575E+00, 5.6186652510E+00, 2.0253542157E-01, 1.8682235173E-01, 5.3791243141E-01],
	[1.0185000000E+04, 4.2169135773E+00, 5.6179856941E+00, 2.0284671565E-01, 1.8709175858E-01, 5.3807084255E-01],
	[1.0190000000E+04, 4.2196179037E+00, 5.6173065528E+00, 2.0315833476E-01, 1.8736139908E-01, 5.3822922845E-01],
	[1.0195000000E+04, 4.2223226364E+00, 5.6166278267E+00, 2.0347027907E-01, 1.8763127328E-01, 5.3838758914E-01],
	[1.0200000000E+04, 4.2250277754E+00, 5.6159495153E+00, 2.0378254878E-01, 1.8790138120E-01, 5.3854592461E-01],
	[1.0205000000E+04, 4.2277333205E+00, 5.6152716182E+00, 2.0409514404E-01, 1.8817172286E-01, 5.3870423489E-01],
	[1.0210000000E+04, 4.2304392716E+00, 5.6145941350E+00, 2.0440806506E-01, 1.8844229828E-01, 5.3886251998E-01],
	[1.0215000000E+04, 4.2331456285E+00, 5.6139170651E+00, 2.0472131200E-01, 1.8871310750E-01, 5.3902077990E-01],
	[1.0220000000E+04, 4.2358523912E+00, 5.6132404081E+00, 2.0503488504E-01, 1.8898415054E-01, 5.3917901466E-01],
	[1.0225000000E+04, 4.2385595594E+00, 5.6125641636E+00, 2.0534878437E-01, 1.8925542743E-01, 5.3933722428E-01],
	[1.0230000000E+04, 4.2412671330E+00, 5.6118883311E+00, 2.0566301015E-01, 1.8952693818E-01, 5.3949540876E-01],
	[1.0235000000E+04, 4.2439751119E+00, 5.6112129102E+00, 2.0597756258E-01, 1.8979868283E-01, 5.3965356812E-01],
	[1.0240000000E+04, 4.2466834960E+00, 5.6105379004E+00, 2.0629244183E-01, 1.9007066140E-01, 5.3981170237E-01],
	[1.0245000000E+04, 4.2493922851E+00, 5.6098633012E+00, 2.0660764808E-01, 1.9034287391E-01, 5.3996981153E-01],
	[1.0250000000E+04, 4.2521014791E+00, 5.6091891122E+00, 2.0692318151E-01, 1.9061532039E-01, 5.4012789560E-01],
	[1.0255000000E+04, 4.2548110778E+00, 5.6085153330E+00, 2.0723904230E-01, 1.9088800086E-01, 5.4028595461E-01],
	[1.0260000000E+04, 4.2575223211E+00, 5.6078451504E+00, 2.0755523062E-01, 1.9116092155E-01, 5.4044398856E-01],
	[1.0265000000E+04, 4.2602366147E+00, 5.6071821682E+00, 2.0787174666E-01, 1.9143408957E-01, 5.4060199746E-01],
	[1.0270000000E+04, 4.2629513158E+00, 5.6065195872E+00, 2.0818859060E-01, 1.9170749174E-01, 5.4075998134E-01],
	[1.0275000000E+04, 4.2656664241E+00, 5.6058574068E+00, 2.0850576262E-01, 1.9198112810E-01, 5.4091794020E-01],
	[1.0280000000E+04, 4.2683819395E+00, 5.6051956268E+00, 2.0882326289E-01, 1.9225499866E-01, 5.4107587405E-01],
	[1.0285000000E+04, 4.2710978618E+00, 5.6045342467E+00, 2.0914109159E-01, 1.9252910345E-01, 5.4123378291E-01],
	[1.0290000000E+04, 4.2738141911E+00, 5.6038732660E+00, 2.0945924891E-01, 1.9280344250E-01, 5.4139166679E-01],
	[1.0295000000E+04, 4.2765309270E+00, 5.6032126843E+00, 2.0977773502E-01, 1.9307801582E-01, 5.4154952571E-01],
	[1.0300000000E+04, 4.2792480695E+00, 5.6025525011E+00, 2.1009655010E-01, 1.9335282343E-01, 5.4170735967E-01],
	[1.0305000000E+04, 4.2819656184E+00, 5.6018927161E+00, 2.1041569434E-01, 1.9362786537E-01, 5.4186516869E-01],
	[1.0310000000E+04, 4.2846835736E+00, 5.6012333287E+00, 2.1073516791E-01, 1.9390314165E-01, 5.4202295279E-01],
	[1.0315000000E+04, 4.2874019350E+00, 5.6005743387E+00, 2.1105497099E-01, 1.9417865230E-01, 5.4218071198E-01],
	[1.0320000000E+04, 4.2901207024E+00, 5.5999157454E+00, 2.1137510375E-01, 1.9445439733E-01, 5.4233844626E-01],
	[1.0325000000E+04, 4.2928398757E+00, 5.5992575486E+00, 2.1169556639E-01, 1.9473037678E-01, 5.4249615566E-01],
	[1.0330000000E+04, 4.2955594547E+00, 5.5985997477E+00, 2.1201635908E-01, 1.9500659065E-01, 5.4265384019E-01],
	[1.0335000000E+04, 4.2982794393E+00, 5.5979423423E+00, 2.1233748199E-01, 1.9528303899E-01, 5.4281149986E-01],
	[1.0340000000E+04, 4.3009998294E+00, 5.5972853321E+00, 2.1265893532E-01, 1.9555972179E-01, 5.4296913468E-01],
	[1.0345000000E+04, 4.3037206249E+00, 5.5966287166E+00, 2.1298071923E-01, 1.9583663910E-01, 5.4312674467E-01],
	[1.0350000000E+04, 4.3064418256E+00, 5.5959724953E+00, 2.1330283391E-01, 1.9611379092E-01, 5.4328432983E-01],
	[1.0355000000E+04, 4.3091634313E+00, 5.5953166678E+00, 2.1362527953E-01, 1.9639117729E-01, 5.4344189020E-01],
	[1.0360000000E+04, 4.3118854419E+00, 5.5946612337E+00, 2.1394805628E-01, 1.9666879821E-01, 5.4359942576E-01],
	[1.0365000000E+04, 4.3146078574E+00, 5.5940061926E+00, 2.1427116434E-01, 1.9694665372E-01, 5.4375693656E-01],
	[1.0370000000E+04, 4.3173306775E+00, 5.5933515441E+00, 2.1459460388E-01, 1.9722474383E-01, 5.4391442258E-01],
	[1.0375000000E+04, 4.3200539022E+00, 5.5926972877E+00, 2.1491837508E-01, 1.9750306857E-01, 5.4407188385E-01],
	[1.0380000000E+04, 4.3227775312E+00, 5.5920434230E+00, 2.1524247813E-01, 1.9778162794E-01, 5.4422932039E-01],
	[1.0385000000E+04, 4.3255015646E+00, 5.5913899495E+00, 2.1556691321E-01, 1.9806042199E-01, 5.4438673220E-01],
	[1.0390000000E+04, 4.3282260020E+00, 5.5907368669E+00, 2.1589168048E-01, 1.9833945071E-01, 5.4454411929E-01],
	[1.0395000000E+04, 4.3309508434E+00, 5.5900841748E+00, 2.1621678014E-01, 1.9861871414E-01, 5.4470148170E-01],
	[1.0400000000E+04, 4.3336760887E+00, 5.5894318727E+00, 2.1654221236E-01, 1.9889821230E-01, 5.4485881941E-01],
	[1.0405000000E+04, 4.3364017377E+00, 5.5887799601E+00, 2.1686797733E-01, 1.9917794519E-01, 5.4501613246E-01],
	[1.0410000000E+04, 4.3391277903E+00, 5.5881284368E+00, 2.1719407521E-01, 1.9945791285E-01, 5.4517342085E-01],
	[1.0415000000E+04, 4.3418542463E+00, 5.5874773021E+00, 2.1752050620E-01, 1.9973811529E-01, 5.4533068460E-01],
	[1.0420000000E+04, 4.3445811057E+00, 5.5868265559E+00, 2.1784727046E-01, 2.0001855254E-01, 5.4548792372E-01],
	[1.0425000000E+04, 4.3473095401E+00, 5.5861790056E+00, 2.1817436819E-01, 2.0029923070E-01, 5.4564513822E-01],
	[1.0430000000E+04, 4.3500412488E+00, 5.5855387139E+00, 2.1850179956E-01, 2.0058015869E-01, 5.4580232812E-01],
	[1.0435000000E+04, 4.3527733636E+00, 5.5848988024E+00, 2.1882956475E-01, 2.0086132164E-01, 5.4595949344E-01],
	[1.0440000000E+04, 4.3555058842E+00, 5.5842592707E+00, 2.1915766393E-01, 2.0114271957E-01, 5.4611663418E-01],
	[1.0445000000E+04, 4.3582388107E+00, 5.5836201184E+00, 2.1948609730E-01, 2.0142435250E-01, 5.4627375036E-01],
	[1.0450000000E+04, 4.3609721428E+00, 5.5829813451E+00, 2.1981486502E-01, 2.0170622044E-01, 5.4643084200E-01],
	[1.0455000000E+04, 4.3637058804E+00, 5.5823429503E+00, 2.2014396729E-01, 2.0198832340E-01, 5.4658790910E-01],
	[1.0460000000E+04, 4.3664400235E+00, 5.5817049338E+00, 2.2047340427E-01, 2.0227066142E-01, 5.4674495169E-01],
	[1.0465000000E+04, 4.3691745717E+00, 5.5810672950E+00, 2.2080317615E-01, 2.0255323451E-01, 5.4690196978E-01],
	[1.0470000000E+04, 4.3719095251E+00, 5.5804300336E+00, 2.2113328310E-01, 2.0283604268E-01, 5.4705896337E-01],
	[1.0475000000E+04, 4.3746448835E+00, 5.5797931491E+00, 2.2146372532E-01, 2.0311908596E-01, 5.4721593249E-01],
	[1.0480000000E+04, 4.3773806467E+00, 5.5791566413E+00, 2.2179450297E-01, 2.0340236436E-01, 5.4737287715E-01],
	[1.0485000000E+04, 4.3801168146E+00, 5.5785205095E+00, 2.2212561623E-01, 2.0368587789E-01, 5.4752979736E-01],
	[1.0490000000E+04, 4.3828533871E+00, 5.5778847536E+00, 2.2245706530E-01, 2.0396962658E-01, 5.4768669314E-01],
	[1.0495000000E+04, 4.3855903640E+00, 5.5772493730E+00, 2.2278885034E-01, 2.0425361044E-01, 5.4784356450E-01],
	[1.0500000000E+04, 4.3883277453E+00, 5.5766143673E+00, 2.2312097153E-01, 2.0453782949E-01, 5.4800041146E-01],
	[1.0505000000E+04, 4.3910655308E+00, 5.5759797363E+00, 2.2345342907E-01, 2.0482228375E-01, 5.4815723402E-01],
	[1.0510000000E+04, 4.3938037203E+00, 5.5753454793E+00, 2.2378622312E-01, 2.0510697323E-01, 5.4831403221E-01],
	[1.0515000000E+04, 4.3965423137E+00, 5.5747115962E+00, 2.2411935386E-01, 2.0539189794E-01, 5.4847080604E-01],
	[1.0520000000E+04, 4.3992813109E+00, 5.5740780864E+00, 2.2445282148E-01, 2.0567705791E-01, 5.4862755552E-01],
	[1.0525000000E+04, 4.4020207118E+00, 5.5734449496E+00, 2.2478662615E-01, 2.0596245315E-01, 5.4878428066E-01],
	[1.0530000000E+04, 4.4047605162E+00, 5.5728121853E+00, 2.2512076806E-01, 2.0624808368E-01, 5.4894098149E-01],
	[1.0535000000E+04, 4.4075007239E+00, 5.5721797932E+00, 2.2545524739E-01, 2.0653394951E-01, 5.4909765802E-01],
	[1.0540000000E+04, 4.4102413350E+00, 5.5715477729E+00, 2.2579006431E-01, 2.0682005066E-01, 5.4925431025E-01],
	[1.0545000000E+04, 4.4129823491E+00, 5.5709161240E+00, 2.2612521900E-01, 2.0710638714E-01, 5.4941093821E-01],
	[1.0550000000E+04, 4.4157237663E+00, 5.5702848461E+00, 2.2646071165E-01, 2.0739295896E-01, 5.4956754191E-01],
	[1.0555000000E+04, 4.4184655863E+00, 5.5696539388E+00, 2.2679654243E-01, 2.0767976616E-01, 5.4972412136E-01],
	[1.0560000000E+04, 4.4212078090E+00, 5.5690234016E+00, 2.2713271153E-01, 2.0796680872E-01, 5.4988067658E-01],
	[1.0565000000E+04, 4.4239504343E+00, 5.5683932343E+00, 2.2746921912E-01, 2.0825408668E-01, 5.5003720758E-01],
	[1.0570000000E+04, 4.4266934621E+00, 5.5677634364E+00, 2.2780606538E-01, 2.0854160005E-01, 5.5019371438E-01],
	[1.0575000000E+04, 4.4294368923E+00, 5.5671340075E+00, 2.2814325050E-01, 2.0882934884E-01, 5.5035019700E-01],
	[1.0580000000E+04, 4.4321807246E+00, 5.5665049473E+00, 2.2848077466E-01, 2.0911733307E-01, 5.5050665543E-01],
	[1.0585000000E+04, 4.4349249590E+00, 5.5658762553E+00, 2.2881863803E-01, 2.0940555274E-01, 5.5066308971E-01],
	[1.0590000000E+04, 4.4376695954E+00, 5.5652479312E+00, 2.2915684079E-01, 2.0969400788E-01, 5.5081949985E-01],
	[1.0595000000E+04, 4.4404176958E+00, 5.5646268202E+00, 2.2949538312E-01, 2.0998271509E-01, 5.5097588585E-01],
	[1.0600000000E+04, 4.4431673391E+00, 5.5640086155E+00, 2.2983426521E-01, 2.1027166406E-01, 5.5113224774E-01],
	[1.0605000000E+04, 4.4459173871E+00, 5.5633907709E+00, 2.3017348724E-01, 2.1056084863E-01, 5.5128858554E-01],
	[1.0610000000E+04, 4.4486678398E+00, 5.5627732862E+00, 2.3051304937E-01, 2.1085026883E-01, 5.5144489924E-01],
	[1.0615000000E+04, 4.4514186970E+00, 5.5621561608E+00, 2.3085295180E-01, 2.1113992467E-01, 5.5160118888E-01],
	[1.0620000000E+04, 4.4541699585E+00, 5.5615393945E+00, 2.3119319471E-01, 2.1142981616E-01, 5.5175745446E-01],
	[1.0625000000E+04, 4.4569216243E+00, 5.5609229868E+00, 2.3153377827E-01, 2.1171994331E-01, 5.5191369600E-01],
	[1.0630000000E+04, 4.4596736942E+00, 5.5603069374E+00, 2.3187470266E-01, 2.1201030613E-01, 5.5206991351E-01],
	[1.0635000000E+04, 4.4624261681E+00, 5.5596912460E+00, 2.3221596807E-01, 2.1230090465E-01, 5.5222610701E-01],
	[1.0640000000E+04, 4.4651790458E+00, 5.5590759120E+00, 2.3255757467E-01, 2.1259173887E-01, 5.5238227652E-01],
	[1.0645000000E+04, 4.4679323272E+00, 5.5584609352E+00, 2.3289952265E-01, 2.1288280880E-01, 5.5253842204E-01],
	[1.0650000000E+04, 4.4706860123E+00, 5.5578463151E+00, 2.3324181218E-01, 2.1317411446E-01, 5.5269454359E-01],
	[1.0655000000E+04, 4.4734401007E+00, 5.5572320515E+00, 2.3358444344E-01, 2.1346565586E-01, 5.5285064115E-01],
	[1.0660000000E+04, 4.4761945925E+00, 5.5566181439E+00, 2.3392741662E-01, 2.1375743301E-01, 5.5300671471E-01],
	[1.0665000000E+04, 4.4789494875E+00, 5.5560045919E+00, 2.3427073189E-01, 2.1404944592E-01, 5.5316276427E-01],
	[1.0670000000E+04, 4.4817047856E+00, 5.5553913953E+00, 2.3461438944E-01, 2.1434169460E-01, 5.5331878985E-01],
	[1.0675000000E+04, 4.4844604866E+00, 5.5547785535E+00, 2.3495838945E-01, 2.1463417907E-01, 5.5347479142E-01],
	[1.0680000000E+04, 4.4872165904E+00, 5.5541660662E+00, 2.3530273208E-01, 2.1492689934E-01, 5.5363076900E-01],
	[1.0685000000E+04, 4.4899730969E+00, 5.5535539332E+00, 2.3564741754E-01, 2.1521985541E-01, 5.5378672259E-01],
	[1.0690000000E+04, 4.4927300059E+00, 5.5529421539E+00, 2.3599244599E-01, 2.1551304730E-01, 5.5394265219E-01],
	[1.0695000000E+04, 4.4954873173E+00, 5.5523307280E+00, 2.3633781761E-01, 2.1580647502E-01, 5.5409855779E-01],
	[1.0700000000E+04, 4.4982450310E+00, 5.5517196552E+00, 2.3668353259E-01, 2.1610013858E-01, 5.5425443941E-01],
	[1.0705000000E+04, 4.5010031469E+00, 5.5511089351E+00, 2.3702959111E-01, 2.1639403799E-01, 5.5441029703E-01],
	[1.0710000000E+04, 4.5037616648E+00, 5.5504985673E+00, 2.3737599334E-01, 2.1668817326E-01, 5.5456613067E-01],
	[1.0715000000E+04, 4.5065205846E+00, 5.5498885515E+00, 2.3772273947E-01, 2.1698254440E-01, 5.5472194031E-01],
	[1.0720000000E+04, 4.5092799062E+00, 5.5492788872E+00, 2.3806982967E-01, 2.1727715143E-01, 5.5487772597E-01],
	[1.0725000000E+04, 4.5120396294E+00, 5.5486695742E+00, 2.3841726413E-01, 2.1757199434E-01, 5.5503348764E-01],
	[1.0730000000E+04, 4.5147997542E+00, 5.5480606120E+00, 2.3876504303E-01, 2.1786707315E-01, 5.5518922532E-01],
	[1.0735000000E+04, 4.5175602803E+00, 5.5474520003E+00, 2.3911316654E-01, 2.1816238787E-01, 5.5534493902E-01],
	[1.0740000000E+04, 4.5203212077E+00, 5.5468437387E+00, 2.3946163486E-01, 2.1845793851E-01, 5.5550062874E-01],
	[1.0745000000E+04, 4.5230825362E+00, 5.5462358269E+00, 2.3981044815E-01, 2.1875372508E-01, 5.5565629447E-01],
	[1.0750000000E+04, 4.5258442657E+00, 5.5456282645E+00, 2.4015960660E-01, 2.1904974758E-01, 5.5581193622E-01],
	[1.0755000000E+04, 4.5286063960E+00, 5.5450210511E+00, 2.4050911038E-01, 2.1934600603E-01, 5.5596755399E-01],
	[1.0760000000E+04, 4.5313689271E+00, 5.5444141864E+00, 2.4085895969E-01, 2.1964250044E-01, 5.5612314778E-01],
	[1.0765000000E+04, 4.5341345963E+00, 5.5438133869E+00, 2.4120915469E-01, 2.1993924625E-01, 5.5627871759E-01],
	[1.0770000000E+04, 4.5369022922E+00, 5.5432163208E+00, 2.4155969558E-01, 2.2023623727E-01, 5.5643426342E-01],
	[1.0775000000E+04, 4.5396703917E+00, 5.5426195962E+00, 2.4191058252E-01, 2.2053346439E-01, 5.5658978528E-01],
	[1.0780000000E+04, 4.5424388948E+00, 5.5420232125E+00, 2.4226181570E-01, 2.2083092760E-01, 5.5674528316E-01],
	[1.0785000000E+04, 4.5452078012E+00, 5.5414271696E+00, 2.4261339531E-01, 2.2112862693E-01, 5.5690075707E-01],
	[1.0790000000E+04, 4.5479771109E+00, 5.5408314670E+00, 2.4296532151E-01, 2.2142656237E-01, 5.5705620701E-01],
	[1.0795000000E+04, 4.5507468238E+00, 5.5402361043E+00, 2.4331759450E-01, 2.2172473393E-01, 5.5721163297E-01],
	[1.0800000000E+04, 4.5535169396E+00, 5.5396410813E+00, 2.4367021444E-01, 2.2202314163E-01, 5.5736703497E-01],
	[1.0805000000E+04, 4.5562874584E+00, 5.5390463975E+00, 2.4402318153E-01, 2.2232178546E-01, 5.5752241300E-01],
	[1.0810000000E+04, 4.5590583799E+00, 5.5384520527E+00, 2.4437649594E-01, 2.2262066544E-01, 5.5767776706E-01],
	[1.0815000000E+04, 4.5618297040E+00, 5.5378580465E+00, 2.4473015785E-01, 2.2291978157E-01, 5.5783309716E-01],
	[1.0820000000E+04, 4.5646014306E+00, 5.5372643784E+00, 2.4508416745E-01, 2.2321913386E-01, 5.5798840329E-01],
	[1.0825000000E+04, 4.5673735596E+00, 5.5366710482E+00, 2.4543852491E-01, 2.2351872232E-01, 5.5814368546E-01],
	[1.0830000000E+04, 4.5701460908E+00, 5.5360780556E+00, 2.4579323041E-01, 2.2381854696E-01, 5.5829894367E-01],
	[1.0835000000E+04, 4.5729190242E+00, 5.5354854001E+00, 2.4614828414E-01, 2.2411860777E-01, 5.5845417793E-01],
	[1.0840000000E+04, 4.5756923595E+00, 5.5348930815E+00, 2.4650368627E-01, 2.2441890477E-01, 5.5860938822E-01],
	[1.0845000000E+04, 4.5784660967E+00, 5.5343010993E+00, 2.4685943699E-01, 2.2471943796E-01, 5.5876457456E-01],
	[1.0850000000E+04, 4.5812402356E+00, 5.5337094533E+00, 2.4721553647E-01, 2.2502020735E-01, 5.5891973695E-01],
	[1.0855000000E+04, 4.5840147761E+00, 5.5331181431E+00, 2.4757198490E-01, 2.2532121295E-01, 5.5907487538E-01],
	[1.0860000000E+04, 4.5867897182E+00, 5.5325271683E+00, 2.4792878245E-01, 2.2562245475E-01, 5.5922998987E-01],
	[1.0865000000E+04, 4.5895650615E+00, 5.5319365287E+00, 2.4828592932E-01, 2.2592393277E-01, 5.5938508041E-01],
	[1.0870000000E+04, 4.5923408061E+00, 5.5313462237E+00, 2.4864342567E-01, 2.2622564701E-01, 5.5954014700E-01],
	[1.0875000000E+04, 4.5951169518E+00, 5.5307562532E+00, 2.4900127169E-01, 2.2652759748E-01, 5.5969518964E-01],
	[1.0880000000E+04, 4.5978934985E+00, 5.5301666168E+00, 2.4935946755E-01, 2.2682978418E-01, 5.5985020835E-01],
	[1.0885000000E+04, 4.6006704460E+00, 5.5295773141E+00, 2.4971801345E-01, 2.2713220711E-01, 5.6000520311E-01],
	[1.0890000000E+04, 4.6034477942E+00, 5.5289883448E+00, 2.5007690955E-01, 2.2743486629E-01, 5.6016017394E-01],
	[1.0895000000E+04, 4.6062255430E+00, 5.5283997085E+00, 2.5043615605E-01, 2.2773776171E-01, 5.6031512083E-01],
	[1.0900000000E+04, 4.6090036923E+00, 5.5278114049E+00, 2.5079575312E-01, 2.2804089338E-01, 5.6047004378E-01],
	[1.0905000000E+04, 4.6117822420E+00, 5.5272234337E+00, 2.5115570094E-01, 2.2834426130E-01, 5.6062494280E-01],
	[1.0910000000E+04, 4.6145611918E+00, 5.5266357946E+00, 2.5151599969E-01, 2.2864786548E-01, 5.6077981790E-01],
	[1.0915000000E+04, 4.6173405417E+00, 5.5260484871E+00, 2.5187664955E-01, 2.2895170592E-01, 5.6093466906E-01],
	[1.0920000000E+04, 4.6201202917E+00, 5.5254615109E+00, 2.5223765071E-01, 2.2925578263E-01, 5.6108949630E-01],
	[1.0925000000E+04, 4.6229004414E+00, 5.5248748658E+00, 2.5259900334E-01, 2.2956009561E-01, 5.6124429961E-01],
	[1.0930000000E+04, 4.6256809909E+00, 5.5242885513E+00, 2.5296070762E-01, 2.2986464485E-01, 5.6139907901E-01],
	[1.0935000000E+04, 4.6284619399E+00, 5.5237025671E+00, 2.5332276374E-01, 2.3016943038E-01, 5.6155383448E-01],
	[1.0940000000E+04, 4.6312477102E+00, 5.5231255449E+00, 2.5368517188E-01, 2.3047447816E-01, 5.6170856604E-01],
	[1.0945000000E+04, 4.6340339851E+00, 5.5225490457E+00, 2.5404793221E-01, 2.3077976294E-01, 5.6186327368E-01],
	[1.0950000000E+04, 4.6368206626E+00, 5.5219728699E+00, 2.5441104492E-01, 2.3108528413E-01, 5.6201795741E-01],
	[1.0955000000E+04, 4.6396077425E+00, 5.5213970172E+00, 2.5477451019E-01, 2.3139104172E-01, 5.6217261723E-01],
	[1.0960000000E+04, 4.6423952248E+00, 5.5208214873E+00, 2.5513832820E-01, 2.3169703571E-01, 5.6232725315E-01],
	[1.0965000000E+04, 4.6451831093E+00, 5.5202462799E+00, 2.5550249912E-01, 2.3200326612E-01, 5.6248186515E-01],
	[1.0970000000E+04, 4.6479713959E+00, 5.5196713945E+00, 2.5586702315E-01, 2.3230973294E-01, 5.6263645326E-01],
	[1.0975000000E+04, 4.6507600844E+00, 5.5190968310E+00, 2.5623190045E-01, 2.3261643618E-01, 5.6279101747E-01],
	[1.0980000000E+04, 4.6535491747E+00, 5.5185225889E+00, 2.5659713122E-01, 2.3292337584E-01, 5.6294555778E-01],
	[1.0985000000E+04, 4.6563386668E+00, 5.5179486680E+00, 2.5696271563E-01, 2.3323055191E-01, 5.6310007419E-01],
	[1.0990000000E+04, 4.6591285604E+00, 5.5173750679E+00, 2.5732865386E-01, 2.3353796441E-01, 5.6325456672E-01],
	[1.0995000000E+04, 4.6619188555E+00, 5.5168017882E+00, 2.5769494610E-01, 2.3384561332E-01, 5.6340903535E-01],
	[1.1000000000E+04, 4.6647095520E+00, 5.5162288288E+00, 2.5806159252E-01, 2.3415349867E-01, 5.6356348010E-01],
	[1.1005000000E+04, 4.6675006496E+00, 5.5156561892E+00, 2.5842859330E-01, 2.3446162043E-01, 5.6371790096E-01],
	[1.1010000000E+04, 4.6702921483E+00, 5.5150838691E+00, 2.5879594863E-01, 2.3476997862E-01, 5.6387229794E-01],
	[1.1015000000E+04, 4.6730840480E+00, 5.5145118682E+00, 2.5916365869E-01, 2.3507857324E-01, 5.6402667105E-01],
	[1.1020000000E+04, 4.6758763485E+00, 5.5139401861E+00, 2.5953172366E-01, 2.3538740429E-01, 5.6418102028E-01],
	[1.1025000000E+04, 4.6786690497E+00, 5.5133688227E+00, 2.5990014371E-01, 2.3569647177E-01, 5.6433534563E-01],
	[1.1030000000E+04, 4.6814621514E+00, 5.5127977774E+00, 2.6026891903E-01, 2.3600577567E-01, 5.6448964712E-01],
	[1.1035000000E+04, 4.6842556537E+00, 5.5122270501E+00, 2.6063804980E-01, 2.3631531601E-01, 5.6464392474E-01],
	[1.1040000000E+04, 4.6870495563E+00, 5.5116566403E+00, 2.6100753621E-01, 2.3662509277E-01, 5.6479817849E-01],
	[1.1045000000E+04, 4.6898438591E+00, 5.5110865478E+00, 2.6137737842E-01, 2.3693510596E-01, 5.6495240838E-01],
	[1.1050000000E+04, 4.6926385619E+00, 5.5105167723E+00, 2.6174757663E-01, 2.3724535558E-01, 5.6510661442E-01],
	[1.1055000000E+04, 4.6954336648E+00, 5.5099473134E+00, 2.6211813101E-01, 2.3755584163E-01, 5.6526079660E-01],
	[1.1060000000E+04, 4.6982291675E+00, 5.5093781707E+00, 2.6248904174E-01, 2.3786656411E-01, 5.6541495492E-01],
	[1.1065000000E+04, 4.7010250698E+00, 5.5088093441E+00, 2.6286030901E-01, 2.3817752301E-01, 5.6556908940E-01],
	[1.1070000000E+04, 4.7038213718E+00, 5.5082408332E+00, 2.6323193300E-01, 2.3848871834E-01, 5.6572320004E-01],
	[1.1075000000E+04, 4.7066180733E+00, 5.5076726376E+00, 2.6360391388E-01, 2.3880015010E-01, 5.6587728682E-01],
	[1.1080000000E+04, 4.7094151741E+00, 5.5071047570E+00, 2.6397625184E-01, 2.3911181828E-01, 5.6603134977E-01],
	[1.1085000000E+04, 4.7122126741E+00, 5.5065371912E+00, 2.6434894706E-01, 2.3942372288E-01, 5.6618538889E-01],
	[1.1090000000E+04, 4.7150105732E+00, 5.5059699397E+00, 2.6472199972E-01, 2.3973586390E-01, 5.6633940417E-01],
	[1.1095000000E+04, 4.7178088713E+00, 5.5054030024E+00, 2.6509541000E-01, 2.4004824134E-01, 5.6649339562E-01],
	[1.1100000000E+04, 4.7206075683E+00, 5.5048363788E+00, 2.6546917808E-01, 2.4036085520E-01, 5.6664736324E-01],
	[1.1105000000E+04, 4.7234066639E+00, 5.5042700686E+00, 2.6584330415E-01, 2.4067370547E-01, 5.6680130704E-01],
	[1.1110000000E+04, 4.7262061582E+00, 5.5037040717E+00, 2.6621778837E-01, 2.4098679215E-01, 5.6695522702E-01],
	[1.1115000000E+04, 4.7290096572E+00, 5.5031449764E+00, 2.6659263095E-01, 2.4130013731E-01, 5.6710912318E-01],
	[1.1120000000E+04, 4.7318146386E+00, 5.5025881640E+00, 2.6696783204E-01, 2.4161372559E-01, 5.6726299553E-01],
	[1.1125000000E+04, 4.7346200217E+00, 5.5020316581E+00, 2.6734339185E-01, 2.4192755040E-01, 5.6741684407E-01],
	[1.1130000000E+04, 4.7374258063E+00, 5.5014754585E+00, 2.6771931054E-01, 2.4224161175E-01, 5.6757066880E-01],
	[1.1135000000E+04, 4.7402319924E+00, 5.5009195650E+00, 2.6809558830E-01, 2.4255590961E-01, 5.6772446973E-01],
	[1.1140000000E+04, 4.7430385798E+00, 5.5003639771E+00, 2.6847222531E-01, 2.4287044400E-01, 5.6787824686E-01],
	[1.1145000000E+04, 4.7458455684E+00, 5.4998086946E+00, 2.6884922175E-01, 2.4318521491E-01, 5.6803200020E-01],
	[1.1150000000E+04, 4.7486529581E+00, 5.4992537172E+00, 2.6922657780E-01, 2.4350022233E-01, 5.6818572974E-01],
	[1.1155000000E+04, 4.7514607487E+00, 5.4986990446E+00, 2.6960429364E-01, 2.4381546627E-01, 5.6833943549E-01],
	[1.1160000000E+04, 4.7542689401E+00, 5.4981446764E+00, 2.6998236946E-01, 2.4413094671E-01, 5.6849311746E-01],
	[1.1165000000E+04, 4.7570775323E+00, 5.4975906124E+00, 2.7036080543E-01, 2.4444666366E-01, 5.6864677564E-01],
	[1.1170000000E+04, 4.7598865250E+00, 5.4970368523E+00, 2.7073960174E-01, 2.4476261712E-01, 5.6880041004E-01],
	[1.1175000000E+04, 4.7626959182E+00, 5.4964833957E+00, 2.7111875857E-01, 2.4507880707E-01, 5.6895402064E-01],
	[1.1180000000E+04, 4.7655057117E+00, 5.4959302425E+00, 2.7149827609E-01, 2.4539523351E-01, 5.6910760742E-01],
	[1.1185000000E+04, 4.7683159054E+00, 5.4953773921E+00, 2.7188039532E-01, 2.4571372669E-01, 5.6926117038E-01],
	[1.1190000000E+04, 4.7711264993E+00, 5.4948248444E+00, 2.7226302408E-01, 2.4603257680E-01, 5.6941470952E-01],
	[1.1195000000E+04, 4.7739374931E+00, 5.4942725991E+00, 2.7264601969E-01, 2.4635166712E-01, 5.6956822482E-01],
	[1.1200000000E+04, 4.7767488867E+00, 5.4937206559E+00, 2.7302938234E-01, 2.4667099765E-01, 5.6972171628E-01],
	[1.1205000000E+04, 4.7795606801E+00, 5.4931690144E+00, 2.7341311222E-01, 2.4699056837E-01, 5.6987518388E-01],
	[1.1210000000E+04, 4.7823728731E+00, 5.4926176743E+00, 2.7379720952E-01, 2.4731037929E-01, 5.7002862764E-01],
	[1.1215000000E+04, 4.7851854656E+00, 5.4920666355E+00, 2.7418167441E-01, 2.4763043041E-01, 5.7018204753E-01],
	[1.1220000000E+04, 4.7879984574E+00, 5.4915158974E+00, 2.7456650710E-01, 2.4795072171E-01, 5.7033544355E-01],
	[1.1225000000E+04, 4.7908118485E+00, 5.4909654600E+00, 2.7495170776E-01, 2.4827125320E-01, 5.7048881569E-01],
	[1.1230000000E+04, 4.7936256387E+00, 5.4904153228E+00, 2.7533727658E-01, 2.4859202487E-01, 5.7064216395E-01],
	[1.1235000000E+04, 4.7964398279E+00, 5.4898654856E+00, 2.7572321376E-01, 2.4891303671E-01, 5.7079548833E-01],
	[1.1240000000E+04, 4.7992544159E+00, 5.4893159480E+00, 2.7610951947E-01, 2.4923428873E-01, 5.7094878880E-01],
	[1.1245000000E+04, 4.8020694028E+00, 5.4887667098E+00, 2.7649619391E-01, 2.4955578091E-01, 5.7110206537E-01],
	[1.1250000000E+04, 4.8048847882E+00, 5.4882177707E+00, 2.7688323726E-01, 2.4987751325E-01, 5.7125531803E-01],
	[1.1255000000E+04, 4.8077005722E+00, 5.4876691304E+00, 2.7727064970E-01, 2.5019948574E-01, 5.7140854678E-01],
	[1.1260000000E+04, 4.8105167546E+00, 5.4871207886E+00, 2.7765843144E-01, 2.5052169838E-01, 5.7156175160E-01],
	[1.1265000000E+04, 4.8133333353E+00, 5.4865727449E+00, 2.7804658265E-01, 2.5084415117E-01, 5.7171493249E-01],
	[1.1270000000E+04, 4.8161503141E+00, 5.4860249992E+00, 2.7843510352E-01, 2.5116684409E-01, 5.7186808945E-01],
	[1.1275000000E+04, 4.8189676909E+00, 5.4854775511E+00, 2.7882399424E-01, 2.5148977714E-01, 5.7202122246E-01],
	[1.1280000000E+04, 4.8217854657E+00, 5.4849304002E+00, 2.7921325500E-01, 2.5181295032E-01, 5.7217433153E-01],
	[1.1285000000E+04, 4.8246036382E+00, 5.4843835464E+00, 2.7960288597E-01, 2.5213636361E-01, 5.7232741664E-01],
	[1.1290000000E+04, 4.8274222085E+00, 5.4838369893E+00, 2.7999288736E-01, 2.5246001702E-01, 5.7248047778E-01],
	[1.1295000000E+04, 4.8302460026E+00, 5.4832989863E+00, 2.8038325935E-01, 2.5278394130E-01, 5.7263351496E-01],
	[1.1300000000E+04, 4.8330702245E+00, 5.4827613199E+00, 2.8077400212E-01, 2.5310810598E-01, 5.7278652817E-01],
	[1.1305000000E+04, 4.8358948472E+00, 5.4822239441E+00, 2.8116511587E-01, 2.5343251089E-01, 5.7293951739E-01],
	[1.1310000000E+04, 4.8387198706E+00, 5.4816868585E+00, 2.8155660078E-01, 2.5375715601E-01, 5.7309248263E-01],
	[1.1315000000E+04, 4.8415452947E+00, 5.4811500629E+00, 2.8194845703E-01, 2.5408204134E-01, 5.7324542387E-01],
	[1.1320000000E+04, 4.8443711192E+00, 5.4806135570E+00, 2.8234068482E-01, 2.5440716687E-01, 5.7339834111E-01],
	[1.1325000000E+04, 4.8471973440E+00, 5.4800773405E+00, 2.8273328433E-01, 2.5473253260E-01, 5.7355123435E-01],
	[1.1330000000E+04, 4.8500239691E+00, 5.4795414131E+00, 2.8312625575E-01, 2.5505813852E-01, 5.7370410358E-01],
	[1.1335000000E+04, 4.8528509943E+00, 5.4790057745E+00, 2.8351959926E-01, 2.5538398461E-01, 5.7385694879E-01],
	[1.1340000000E+04, 4.8556784195E+00, 5.4784704245E+00, 2.8391331507E-01, 2.5571007088E-01, 5.7400976998E-01],
	[1.1345000000E+04, 4.8585062445E+00, 5.4779353627E+00, 2.8430740334E-01, 2.5603639731E-01, 5.7416256713E-01],
	[1.1350000000E+04, 4.8613344694E+00, 5.4774005889E+00, 2.8470186427E-01, 2.5636296389E-01, 5.7431534025E-01],
	[1.1355000000E+04, 4.8641630938E+00, 5.4768661029E+00, 2.8509669805E-01, 2.5668977062E-01, 5.7446808933E-01],
	[1.1360000000E+04, 4.8669921178E+00, 5.4763319042E+00, 2.8549190487E-01, 2.5701681749E-01, 5.7462081437E-01],
	[1.1365000000E+04, 4.8698215411E+00, 5.4757979927E+00, 2.8588748490E-01, 2.5734410449E-01, 5.7477351535E-01],
	[1.1370000000E+04, 4.8726513638E+00, 5.4752643681E+00, 2.8628343835E-01, 2.5767163160E-01, 5.7492619227E-01],
	[1.1375000000E+04, 4.8754815856E+00, 5.4747310300E+00, 2.8667976539E-01, 2.5799939883E-01, 5.7507884512E-01],
	[1.1380000000E+04, 4.8783122064E+00, 5.4741979782E+00, 2.8707646622E-01, 2.5832740616E-01, 5.7523147391E-01],
	[1.1385000000E+04, 4.8811432261E+00, 5.4736652125E+00, 2.8747354102E-01, 2.5865565358E-01, 5.7538407862E-01],
	[1.1390000000E+04, 4.8839746447E+00, 5.4731327325E+00, 2.8787098998E-01, 2.5898414108E-01, 5.7553665924E-01],
	[1.1395000000E+04, 4.8868064619E+00, 5.4726005379E+00, 2.8826881329E-01, 2.5931286866E-01, 5.7568921578E-01],
	[1.1400000000E+04, 4.8896386777E+00, 5.4720686286E+00, 2.8866701113E-01, 2.5964183629E-01, 5.7584174823E-01],
	[1.1405000000E+04, 4.8924712919E+00, 5.4715370041E+00, 2.8906558369E-01, 2.5997104398E-01, 5.7599425658E-01],
	[1.1410000000E+04, 4.8953043045E+00, 5.4710056643E+00, 2.8946453117E-01, 2.6030049171E-01, 5.7614674082E-01],
	[1.1415000000E+04, 4.8981377152E+00, 5.4704746089E+00, 2.8986385374E-01, 2.6063017947E-01, 5.7629920096E-01],
	[1.1420000000E+04, 4.9009715241E+00, 5.4699438375E+00, 2.9026355160E-01, 2.6096010725E-01, 5.7645163698E-01],
	[1.1425000000E+04, 4.9038057309E+00, 5.4694133499E+00, 2.9066362493E-01, 2.6129027504E-01, 5.7660404888E-01],
	[1.1430000000E+04, 4.9066403355E+00, 5.4688831458E+00, 2.9106407392E-01, 2.6162068283E-01, 5.7675643665E-01],
	[1.1435000000E+04, 4.9094753379E+00, 5.4683532250E+00, 2.9146489876E-01, 2.6195133060E-01, 5.7690880029E-01],
	[1.1440000000E+04, 4.9123107379E+00, 5.4678235872E+00, 2.9186609963E-01, 2.6228221835E-01, 5.7706113980E-01],
	[1.1445000000E+04, 4.9151465354E+00, 5.4672942320E+00, 2.9226767673E-01, 2.6261334607E-01, 5.7721345516E-01],
	[1.1450000000E+04, 4.9179827303E+00, 5.4667651593E+00, 2.9266963024E-01, 2.6294471373E-01, 5.7736574638E-01],
	[1.1455000000E+04, 4.9208193224E+00, 5.4662363687E+00, 2.9307196035E-01, 2.6327632134E-01, 5.7751801344E-01],
	[1.1460000000E+04, 4.9236563117E+00, 5.4657078600E+00, 2.9347466724E-01, 2.6360816888E-01, 5.7767025635E-01],
	[1.1465000000E+04, 4.9264936980E+00, 5.4651796330E+00, 2.9387775111E-01, 2.6394025633E-01, 5.7782247509E-01],
	[1.1470000000E+04, 4.9293314812E+00, 5.4646516872E+00, 2.9428121214E-01, 2.6427258368E-01, 5.7797466966E-01],
	[1.1475000000E+04, 4.9321728923E+00, 5.4641292050E+00, 2.9468505053E-01, 2.6460517238E-01, 5.7812684007E-01],
	[1.1480000000E+04, 4.9350164918E+00, 5.4636098686E+00, 2.9508926644E-01, 2.6493801295E-01, 5.7827898629E-01],
	[1.1485000000E+04, 4.9378604914E+00, 5.4630908076E+00, 2.9549386009E-01, 2.6527109353E-01, 5.7843110833E-01],
	[1.1490000000E+04, 4.9407048910E+00, 5.4625720218E+00, 2.9589883165E-01, 2.6560441409E-01, 5.7858320618E-01],
	[1.1495000000E+04, 4.9435496906E+00, 5.4620535109E+00, 2.9630418131E-01, 2.6593797464E-01, 5.7873527984E-01],
	[1.1500000000E+04, 4.9463948899E+00, 5.4615352747E+00, 2.9670990925E-01, 2.6627177516E-01, 5.7888732930E-01],
	[1.1505000000E+04, 4.9492404889E+00, 5.4610173130E+00, 2.9711601568E-01, 2.6660581562E-01, 5.7903935456E-01],
	[1.1510000000E+04, 4.9520864875E+00, 5.4604996253E+00, 2.9752250077E-01, 2.6694009603E-01, 5.7919135561E-01],
	[1.1515000000E+04, 4.9549328856E+00, 5.4599822116E+00, 2.9792936471E-01, 2.6727461637E-01, 5.7934333245E-01],
	[1.1520000000E+04, 4.9577796829E+00, 5.4594650715E+00, 2.9833660769E-01, 2.6760937662E-01, 5.7949528507E-01],
	[1.1525000000E+04, 4.9606268795E+00, 5.4589482047E+00, 2.9874422990E-01, 2.6794437676E-01, 5.7964721347E-01],
	[1.1530000000E+04, 4.9634744751E+00, 5.4584316110E+00, 2.9915223153E-01, 2.6827961679E-01, 5.7979911764E-01],
	[1.1535000000E+04, 4.9663224697E+00, 5.4579152902E+00, 2.9956061275E-01, 2.6861509670E-01, 5.7995099758E-01],
	[1.1540000000E+04, 4.9691708632E+00, 5.4573992419E+00, 2.9996937378E-01, 2.6895081646E-01, 5.8010285329E-01],
	[1.1545000000E+04, 4.9720196554E+00, 5.4568834659E+00, 3.0037851478E-01, 2.6928677605E-01, 5.8025468475E-01],
	[1.1550000000E+04, 4.9748688463E+00, 5.4563679619E+00, 3.0078803594E-01, 2.6962297548E-01, 5.8040649196E-01],
	[1.1555000000E+04, 4.9777184356E+00, 5.4558527298E+00, 3.0119793747E-01, 2.6995941472E-01, 5.8055827493E-01],
	[1.1560000000E+04, 4.9805684234E+00, 5.4553377691E+00, 3.0160821953E-01, 2.7029609375E-01, 5.8071003364E-01],
	[1.1565000000E+04, 4.9834188094E+00, 5.4548230797E+00, 3.0201888233E-01, 2.7063301257E-01, 5.8086176810E-01],
	[1.1570000000E+04, 4.9862695935E+00, 5.4543086614E+00, 3.0242992605E-01, 2.7097017115E-01, 5.8101347828E-01],
	[1.1575000000E+04, 4.9891207757E+00, 5.4537945137E+00, 3.0284135087E-01, 2.7130756948E-01, 5.8116516420E-01],
	[1.1580000000E+04, 4.9919723558E+00, 5.4532806366E+00, 3.0325315699E-01, 2.7164520755E-01, 5.8131682585E-01],
	[1.1585000000E+04, 4.9948243338E+00, 5.4527670296E+00, 3.0366534459E-01, 2.7198308533E-01, 5.8146846322E-01],
	[1.1590000000E+04, 4.9976767094E+00, 5.4522536926E+00, 3.0407791387E-01, 2.7232120282E-01, 5.8162007631E-01],
	[1.1595000000E+04, 5.0005294826E+00, 5.4517406254E+00, 3.0449086500E-01, 2.7265955999E-01, 5.8177166511E-01],
	[1.1600000000E+04, 5.0033826532E+00, 5.4512278275E+00, 3.0490419818E-01, 2.7299815683E-01, 5.8192322963E-01],
	[1.1605000000E+04, 5.0062362212E+00, 5.4507152989E+00, 3.0531791360E-01, 2.7333699332E-01, 5.8207476985E-01],
	[1.1610000000E+04, 5.0090901865E+00, 5.4502030392E+00, 3.0573201143E-01, 2.7367606945E-01, 5.8222628577E-01],
	[1.1615000000E+04, 5.0119445488E+00, 5.4496910481E+00, 3.0614649188E-01, 2.7401538520E-01, 5.8237777738E-01],
	[1.1620000000E+04, 5.0147993081E+00, 5.4491793255E+00, 3.0656135513E-01, 2.7435494055E-01, 5.8252924469E-01],
	[1.1625000000E+04, 5.0176544643E+00, 5.4486678711E+00, 3.0697660137E-01, 2.7469473548E-01, 5.8268068769E-01],
	[1.1630000000E+04, 5.0205100173E+00, 5.4481566845E+00, 3.0739223078E-01, 2.7503476998E-01, 5.8283210638E-01],
	[1.1635000000E+04, 5.0233659669E+00, 5.4476457656E+00, 3.0780824356E-01, 2.7537504403E-01, 5.8298350074E-01],
	[1.1640000000E+04, 5.0262223130E+00, 5.4471351142E+00, 3.0822463989E-01, 2.7571555761E-01, 5.8313487079E-01],
	[1.1645000000E+04, 5.0290790556E+00, 5.4466247298E+00, 3.0864141995E-01, 2.7605631070E-01, 5.8328621650E-01],
	[1.1650000000E+04, 5.0319361945E+00, 5.4461146123E+00, 3.0905858395E-01, 2.7639730329E-01, 5.8343753788E-01],
	[1.1655000000E+04, 5.0347937295E+00, 5.4456047615E+00, 3.0947613206E-01, 2.7673853536E-01, 5.8358883493E-01],
	[1.1660000000E+04, 5.0376553327E+00, 5.4451007008E+00, 3.0989406448E-01, 2.7708003229E-01, 5.8374010764E-01],
	[1.1665000000E+04, 5.0405188519E+00, 5.4445991841E+00, 3.1031238139E-01, 2.7742177929E-01, 5.8389135600E-01],
	[1.1670000000E+04, 5.0433827706E+00, 5.4440979285E+00, 3.1073108298E-01, 2.7776376586E-01, 5.8404257998E-01],
	[1.1675000000E+04, 5.0462470888E+00, 5.4435969337E+00, 3.1115016943E-01, 2.7810599197E-01, 5.8419377955E-01],
	[1.1680000000E+04, 5.0491118062E+00, 5.4430961995E+00, 3.1156964095E-01, 2.7844845762E-01, 5.8434495471E-01],
	[1.1685000000E+04, 5.0519769228E+00, 5.4425957257E+00, 3.1198949771E-01, 2.7879116278E-01, 5.8449610544E-01],
	[1.1690000000E+04, 5.0548424384E+00, 5.4420955120E+00, 3.1240973990E-01, 2.7913410743E-01, 5.8464723173E-01],
	[1.1695000000E+04, 5.0577083530E+00, 5.4415955581E+00, 3.1283036772E-01, 2.7947729156E-01, 5.8479833356E-01],
	[1.1700000000E+04, 5.0605746663E+00, 5.4410958638E+00, 3.1325138135E-01, 2.7982071514E-01, 5.8494941093E-01],
	[1.1705000000E+04, 5.0634413784E+00, 5.4405964288E+00, 3.1367278097E-01, 2.8016437815E-01, 5.8510046382E-01],
	[1.1710000000E+04, 5.0663084891E+00, 5.4400972530E+00, 3.1409456678E-01, 2.8050828058E-01, 5.8525149223E-01],
	[1.1715000000E+04, 5.0691759982E+00, 5.4395983360E+00, 3.1451673897E-01, 2.8085242240E-01, 5.8540249613E-01],
	[1.1720000000E+04, 5.0720439057E+00, 5.4390996777E+00, 3.1493929772E-01, 2.8119680359E-01, 5.8555347552E-01],
	[1.1725000000E+04, 5.0749122115E+00, 5.4386012777E+00, 3.1536224322E-01, 2.8154142414E-01, 5.8570443038E-01],
	[1.1730000000E+04, 5.0777809153E+00, 5.4381031359E+00, 3.1578557565E-01, 2.8188628402E-01, 5.8585536071E-01],
	[1.1735000000E+04, 5.0806500172E+00, 5.4376052519E+00, 3.1620929522E-01, 2.8223138322E-01, 5.8600626648E-01],
	[1.1740000000E+04, 5.0835195170E+00, 5.4371076256E+00, 3.1663340211E-01, 2.8257672170E-01, 5.8615714770E-01],
	[1.1745000000E+04, 5.0863894146E+00, 5.4366102567E+00, 3.1705789649E-01, 2.8292229946E-01, 5.8630800435E-01],
	[1.1750000000E+04, 5.0892597098E+00, 5.4361131450E+00, 3.1748277858E-01, 2.8326811646E-01, 5.8645883641E-01],
	[1.1755000000E+04, 5.0921304026E+00, 5.4356162902E+00, 3.1790804854E-01, 2.8361417270E-01, 5.8660964387E-01],
	[1.1760000000E+04, 5.0950014929E+00, 5.4351196920E+00, 3.1833370657E-01, 2.8396046813E-01, 5.8676042673E-01],
	[1.1765000000E+04, 5.0978729804E+00, 5.4346233503E+00, 3.1875975286E-01, 2.8430700276E-01, 5.8691118496E-01],
	[1.1770000000E+04, 5.1007448652E+00, 5.4341272648E+00, 3.1918618760E-01, 2.8465377654E-01, 5.8706191857E-01],
	[1.1775000000E+04, 5.1036171471E+00, 5.4336314352E+00, 3.1961301097E-01, 2.8500078946E-01, 5.8721262754E-01],
	[1.1780000000E+04, 5.1064898260E+00, 5.4331358614E+00, 3.2004022317E-01, 2.8534804151E-01, 5.8736331185E-01],
	[1.1785000000E+04, 5.1093629017E+00, 5.4326405430E+00, 3.2046782437E-01, 2.8569553265E-01, 5.8751397149E-01],
	[1.1790000000E+04, 5.1122363742E+00, 5.4321454798E+00, 3.2089581478E-01, 2.8604326286E-01, 5.8766460646E-01],
	[1.1795000000E+04, 5.1151102434E+00, 5.4316506717E+00, 3.2132419457E-01, 2.8639123212E-01, 5.8781521674E-01],
	[1.1800000000E+04, 5.1179845091E+00, 5.4311561183E+00, 3.2175296395E-01, 2.8673944041E-01, 5.8796580232E-01],
	[1.1805000000E+04, 5.1208591712E+00, 5.4306618194E+00, 3.2218212309E-01, 2.8708788770E-01, 5.8811636319E-01],
	[1.1810000000E+04, 5.1237342296E+00, 5.4301677748E+00, 3.2261167218E-01, 2.8743657397E-01, 5.8826689933E-01],
	[1.1815000000E+04, 5.1266096842E+00, 5.4296739842E+00, 3.2304161141E-01, 2.8778549920E-01, 5.8841741075E-01],
	[1.1820000000E+04, 5.1294855349E+00, 5.4291804474E+00, 3.2347194098E-01, 2.8813466337E-01, 5.8856789742E-01],
	[1.1825000000E+04, 5.1323617816E+00, 5.4286871641E+00, 3.2390266106E-01, 2.8848406644E-01, 5.8871835933E-01],
	[1.1830000000E+04, 5.1352384241E+00, 5.4281941342E+00, 3.2433377186E-01, 2.8883370841E-01, 5.8886879647E-01],
	[1.1835000000E+04, 5.1381154624E+00, 5.4277013574E+00, 3.2476527355E-01, 2.8918358923E-01, 5.8901920884E-01],
	[1.1840000000E+04, 5.1409928963E+00, 5.4272088334E+00, 3.2519716632E-01, 2.8953370889E-01, 5.8916959642E-01],
	[1.1845000000E+04, 5.1438716743E+00, 5.4267179018E+00, 3.2562945037E-01, 2.8988407420E-01, 5.8931995919E-01],
	[1.1850000000E+04, 5.1467552602E+00, 5.4262334482E+00, 3.2606212588E-01, 2.9023471017E-01, 5.8947029716E-01],
	[1.1855000000E+04, 5.1496392452E+00, 5.4257492423E+00, 3.2649519305E-01, 2.9058558506E-01, 5.8962061030E-01],
	[1.1860000000E+04, 5.1525236291E+00, 5.4252652837E+00, 3.2692865205E-01, 2.9093669884E-01, 5.8977089861E-01],
	[1.1865000000E+04, 5.1554084117E+00, 5.4247815723E+00, 3.2736250308E-01, 2.9128805150E-01, 5.8992116208E-01],
	[1.1870000000E+04, 5.1582935931E+00, 5.4242981077E+00, 3.2779674632E-01, 2.9163964299E-01, 5.9007140069E-01],
	[1.1875000000E+04, 5.1611791731E+00, 5.4238148898E+00, 3.2823138197E-01, 2.9199147331E-01, 5.9022161443E-01],
	[1.1880000000E+04, 5.1640651515E+00, 5.4233319184E+00, 3.2866641022E-01, 2.9234354243E-01, 5.9037180330E-01],
	[1.1885000000E+04, 5.1669515283E+00, 5.4228491931E+00, 3.2910183125E-01, 2.9269585031E-01, 5.9052196728E-01],
	[1.1890000000E+04, 5.1698383033E+00, 5.4223667138E+00, 3.2953764524E-01, 2.9304839694E-01, 5.9067210636E-01],
	[1.1895000000E+04, 5.1727254764E+00, 5.4218844803E+00, 3.2997385240E-01, 2.9340118228E-01, 5.9082222053E-01],
	[1.1900000000E+04, 5.1756130476E+00, 5.4214024923E+00, 3.3041045291E-01, 2.9375420632E-01, 5.9097230979E-01],
	[1.1905000000E+04, 5.1785010167E+00, 5.4209207496E+00, 3.3084744695E-01, 2.9410746902E-01, 5.9112237411E-01],
	[1.1910000000E+04, 5.1813893835E+00, 5.4204392520E+00, 3.3128483472E-01, 2.9446097036E-01, 5.9127241349E-01],
	[1.1915000000E+04, 5.1842781481E+00, 5.4199579992E+00, 3.3172261641E-01, 2.9481471032E-01, 5.9142242792E-01],
	[1.1920000000E+04, 5.1871673102E+00, 5.4194769910E+00, 3.3216079220E-01, 2.9516868886E-01, 5.9157241739E-01],
	[1.1925000000E+04, 5.1900568697E+00, 5.4189962272E+00, 3.3259936228E-01, 2.9552290596E-01, 5.9172238188E-01],
	[1.1930000000E+04, 5.1929468266E+00, 5.4185157075E+00, 3.3303832684E-01, 2.9587736160E-01, 5.9187232140E-01],
	[1.1935000000E+04, 5.1958371807E+00, 5.4180354318E+00, 3.3347768607E-01, 2.9623205574E-01, 5.9202223592E-01],
	[1.1940000000E+04, 5.1987279320E+00, 5.4175553998E+00, 3.3391744016E-01, 2.9658698835E-01, 5.9217212543E-01],
	[1.1945000000E+04, 5.2016190802E+00, 5.4170756113E+00, 3.3435758929E-01, 2.9694215942E-01, 5.9232198993E-01],
	[1.1950000000E+04, 5.2045106254E+00, 5.4165960660E+00, 3.3479813366E-01, 2.9729756891E-01, 5.9247182941E-01],
	[1.1955000000E+04, 5.2074025673E+00, 5.4161167638E+00, 3.3523907346E-01, 2.9765321680E-01, 5.9262164385E-01],
	[1.1960000000E+04, 5.2102949059E+00, 5.4156377043E+00, 3.3568040887E-01, 2.9800910305E-01, 5.9277143325E-01],
	[1.1965000000E+04, 5.2131876411E+00, 5.4151588875E+00, 3.3612214008E-01, 2.9836522765E-01, 5.9292119759E-01],
	[1.1970000000E+04, 5.2160807727E+00, 5.4146803130E+00, 3.3656426728E-01, 2.9872159055E-01, 5.9307093687E-01],
	[1.1975000000E+04, 5.2189743006E+00, 5.4142019806E+00, 3.3700679067E-01, 2.9907819174E-01, 5.9322065107E-01],
	[1.1980000000E+04, 5.2218682248E+00, 5.4137238901E+00, 3.3744971042E-01, 2.9943503117E-01, 5.9337034019E-01],
	[1.1985000000E+04, 5.2247625451E+00, 5.4132460414E+00, 3.3789302672E-01, 2.9979210884E-01, 5.9352000421E-01],
	[1.1990000000E+04, 5.2276572614E+00, 5.4127684340E+00, 3.3833673978E-01, 3.0014942470E-01, 5.9366964312E-01],
	[1.1995000000E+04, 5.2305523736E+00, 5.4122910680E+00, 3.3878084977E-01, 3.0050697873E-01, 5.9381925692E-01],
	[1.2000000000E+04, 5.2334478816E+00, 5.4118139429E+00, 3.3922535689E-01, 3.0086477089E-01, 5.9396884559E-01],
	[1.2005000000E+04, 5.2363437852E+00, 5.4113370587E+00, 3.3967026131E-01, 3.0122280116E-01, 5.9411840913E-01],
	[1.2010000000E+04, 5.2392400844E+00, 5.4108604150E+00, 3.4011556324E-01, 3.0158106951E-01, 5.9426794752E-01],
	[1.2015000000E+04, 5.2421367791E+00, 5.4103840116E+00, 3.4056126286E-01, 3.0193957591E-01, 5.9441746076E-01],
	[1.2020000000E+04, 5.2450338691E+00, 5.4099078484E+00, 3.4100736036E-01, 3.0229832033E-01, 5.9456694883E-01],
	[1.2025000000E+04, 5.2479313543E+00, 5.4094319252E+00, 3.4145385593E-01, 3.0265730273E-01, 5.9471641173E-01],
	[1.2030000000E+04, 5.2508292346E+00, 5.4089562415E+00, 3.4190074976E-01, 3.0301652310E-01, 5.9486584944E-01],
	[1.2035000000E+04, 5.2537277434E+00, 5.4084811070E+00, 3.4234804203E-01, 3.0337598314E-01, 5.9501526195E-01],
	[1.2040000000E+04, 5.2566319470E+00, 5.4080132361E+00, 3.4279573294E-01, 3.0373572094E-01, 5.9516464927E-01],
	[1.2045000000E+04, 5.2595365492E+00, 5.4075455999E+00, 3.4324382268E-01, 3.0409569677E-01, 5.9531401137E-01],
	[1.2050000000E+04, 5.2624415500E+00, 5.4070781982E+00, 3.4369231142E-01, 3.0445591059E-01, 5.9546334824E-01],
	[1.2055000000E+04, 5.2653469491E+00, 5.4066110307E+00, 3.4414119937E-01, 3.0481636239E-01, 5.9561265988E-01],
	[1.2060000000E+04, 5.2682527464E+00, 5.4061440974E+00, 3.4459048672E-01, 3.0517705212E-01, 5.9576194628E-01],
	[1.2065000000E+04, 5.2711589419E+00, 5.4056773979E+00, 3.4504017364E-01, 3.0553797976E-01, 5.9591120743E-01],
	[1.2070000000E+04, 5.2740655355E+00, 5.4052109320E+00, 3.4549026033E-01, 3.0589914527E-01, 5.9606044331E-01],
	[1.2075000000E+04, 5.2769725270E+00, 5.4047446995E+00, 3.4594074698E-01, 3.0626054863E-01, 5.9620965393E-01],
	[1.2080000000E+04, 5.2798799163E+00, 5.4042787003E+00, 3.4639163378E-01, 3.0662218979E-01, 5.9635883926E-01],
	[1.2085000000E+04, 5.2827877034E+00, 5.4038129340E+00, 3.4684292091E-01, 3.0698406874E-01, 5.9650799930E-01],
	[1.2090000000E+04, 5.2856958880E+00, 5.4033474006E+00, 3.4729460858E-01, 3.0734618543E-01, 5.9665713405E-01],
	[1.2095000000E+04, 5.2886044702E+00, 5.4028820997E+00, 3.4774669695E-01, 3.0770853984E-01, 5.9680624348E-01],
	[1.2100000000E+04, 5.2915134497E+00, 5.4024170311E+00, 3.4819918623E-01, 3.0807113194E-01, 5.9695532760E-01],
	[1.2105000000E+04, 5.2944228265E+00, 5.4019521947E+00, 3.4865207661E-01, 3.0843396168E-01, 5.9710438639E-01],
	[1.2110000000E+04, 5.2973326004E+00, 5.4014875902E+00, 3.4910536826E-01, 3.0879702904E-01, 5.9725341984E-01],
	[1.2115000000E+04, 5.3002427714E+00, 5.4010232175E+00, 3.4955906139E-01, 3.0916033398E-01, 5.9740242795E-01],
	[1.2120000000E+04, 5.3031533394E+00, 5.4005590763E+00, 3.5001315618E-01, 3.0952387648E-01, 5.9755141070E-01],
	[1.2125000000E+04, 5.3060643042E+00, 5.4000951663E+00, 3.5046765282E-01, 3.0988765650E-01, 5.9770036809E-01],
	[1.2130000000E+04, 5.3089756657E+00, 5.3996314875E+00, 3.5092255149E-01, 3.1025167400E-01, 5.9784930010E-01],
	[1.2135000000E+04, 5.3118874238E+00, 5.3991680395E+00, 3.5137785240E-01, 3.1061592895E-01, 5.9799820673E-01],
	[1.2140000000E+04, 5.3147995785E+00, 5.3987048222E+00, 3.5183355572E-01, 3.1098042133E-01, 5.9814708797E-01],
	[1.2145000000E+04, 5.3177121295E+00, 5.3982418354E+00, 3.5228966165E-01, 3.1134515108E-01, 5.9829594381E-01],
	[1.2150000000E+04, 5.3206250768E+00, 5.3977790788E+00, 3.5274617037E-01, 3.1171011819E-01, 5.9844477424E-01],
	[1.2155000000E+04, 5.3235384203E+00, 5.3973165522E+00, 3.5320308208E-01, 3.1207532261E-01, 5.9859357925E-01],
	[1.2160000000E+04, 5.3264521599E+00, 5.3968542555E+00, 3.5366039696E-01, 3.1244076432E-01, 5.9874235884E-01],
	[1.2165000000E+04, 5.3293662954E+00, 5.3963921884E+00, 3.5411811521E-01, 3.1280644327E-01, 5.9889111299E-01],
	[1.2170000000E+04, 5.3322808268E+00, 5.3959303507E+00, 3.5457623701E-01, 3.1317235943E-01, 5.9903984169E-01],
	[1.2175000000E+04, 5.3351957539E+00, 5.3954687422E+00, 3.5503476255E-01, 3.1353851278E-01, 5.9918854494E-01],
	[1.2180000000E+04, 5.3381110767E+00, 5.3950073627E+00, 3.5549369202E-01, 3.1390490326E-01, 5.9933722273E-01],
	[1.2185000000E+04, 5.3410267950E+00, 5.3945462121E+00, 3.5595302562E-01, 3.1427153086E-01, 5.9948587504E-01],
	[1.2190000000E+04, 5.3439429087E+00, 5.3940852900E+00, 3.5641276352E-01, 3.1463839552E-01, 5.9963450188E-01],
	[1.2195000000E+04, 5.3468594177E+00, 5.3936245962E+00, 3.5687290592E-01, 3.1500549723E-01, 5.9978310322E-01],
	[1.2200000000E+04, 5.3497763219E+00, 5.3931641307E+00, 3.5733345301E-01, 3.1537283593E-01, 5.9993167907E-01],
	[1.2205000000E+04, 5.3526936212E+00, 5.3927038931E+00, 3.5779440497E-01, 3.1574041160E-01, 6.0008022942E-01],
	[1.2210000000E+04, 5.3556113154E+00, 5.3922438832E+00, 3.5825576201E-01, 3.1610822420E-01, 6.0022875424E-01],
	[1.2215000000E+04, 5.3585294046E+00, 5.3917841009E+00, 3.5871752430E-01, 3.1647627369E-01, 6.0037725355E-01],
	[1.2220000000E+04, 5.3614478885E+00, 5.3913245460E+00, 3.5917969203E-01, 3.1684456004E-01, 6.0052572732E-01],
	[1.2225000000E+04, 5.3643667671E+00, 5.3908652182E+00, 3.5964226540E-01, 3.1721308321E-01, 6.0067417555E-01],
	[1.2230000000E+04, 5.3672877148E+00, 5.3904082038E+00, 3.6010524460E-01, 3.1758185626E-01, 6.0082259824E-01],
	[1.2235000000E+04, 5.3702130914E+00, 5.3899564370E+00, 3.6056862981E-01, 3.1795089773E-01, 6.0097099536E-01],
	[1.2240000000E+04, 5.3731388662E+00, 5.3895048926E+00, 3.6103242122E-01, 3.1832017608E-01, 6.0111936692E-01],
	[1.2245000000E+04, 5.3760650391E+00, 5.3890535705E+00, 3.6149661902E-01, 3.1868969128E-01, 6.0126771291E-01],
	[1.2250000000E+04, 5.3789916100E+00, 5.3886024704E+00, 3.6196122341E-01, 3.1905944328E-01, 6.0141603331E-01],
	[1.2255000000E+04, 5.3819185788E+00, 5.3881515921E+00, 3.6242623457E-01, 3.1942943205E-01, 6.0156432813E-01],
	[1.2260000000E+04, 5.3848459454E+00, 5.3877009354E+00, 3.6289165268E-01, 3.1979965756E-01, 6.0171259734E-01],
	[1.2265000000E+04, 5.3877737096E+00, 5.3872505001E+00, 3.6335747795E-01, 3.2017011976E-01, 6.0186084095E-01],
	[1.2270000000E+04, 5.3907018714E+00, 5.3868002861E+00, 3.6382371056E-01, 3.2054081862E-01, 6.0200905894E-01],
	[1.2275000000E+04, 5.3936304307E+00, 5.3863502931E+00, 3.6429035070E-01, 3.2091175411E-01, 6.0215725131E-01],
	[1.2280000000E+04, 5.3965593873E+00, 5.3859005209E+00, 3.6475739855E-01, 3.2128292617E-01, 6.0230541804E-01],
	[1.2285000000E+04, 5.3994887412E+00, 5.3854509694E+00, 3.6522485431E-01, 3.2165433478E-01, 6.0245355914E-01],
	[1.2290000000E+04, 5.4024184922E+00, 5.3850016383E+00, 3.6569271818E-01, 3.2202597989E-01, 6.0260167459E-01],
	[1.2295000000E+04, 5.4053486402E+00, 5.3845525274E+00, 3.6616099032E-01, 3.2239786148E-01, 6.0274976438E-01],
	[1.2300000000E+04, 5.4082791851E+00, 5.3841036365E+00, 3.6662967095E-01, 3.2276997949E-01, 6.0289782850E-01],
	[1.2305000000E+04, 5.4112101269E+00, 5.3836549655E+00, 3.6709876024E-01, 3.2314233389E-01, 6.0304586696E-01],
	[1.2310000000E+04, 5.4141414653E+00, 5.3832065142E+00, 3.6756825839E-01, 3.2351492464E-01, 6.0319387973E-01],
	[1.2315000000E+04, 5.4170732003E+00, 5.3827582823E+00, 3.6803816558E-01, 3.2388775170E-01, 6.0334186682E-01],
	[1.2320000000E+04, 5.4200053319E+00, 5.3823102696E+00, 3.6850848200E-01, 3.2426081504E-01, 6.0348982821E-01],
	[1.2325000000E+04, 5.4229378598E+00, 5.3818624760E+00, 3.6897920785E-01, 3.2463411461E-01, 6.0363776389E-01],
	[1.2330000000E+04, 5.4258707839E+00, 5.3814149012E+00, 3.6945034332E-01, 3.2500765037E-01, 6.0378567387E-01],
	[1.2335000000E+04, 5.4288041043E+00, 5.3809675451E+00, 3.6992188859E-01, 3.2538142229E-01, 6.0393355812E-01],
	[1.2340000000E+04, 5.4317378207E+00, 5.3805204075E+00, 3.7039384385E-01, 3.2575543032E-01, 6.0408141665E-01],
	[1.2345000000E+04, 5.4346719330E+00, 5.3800734881E+00, 3.7086620929E-01, 3.2612967442E-01, 6.0422924944E-01],
	[1.2350000000E+04, 5.4376064412E+00, 5.3796267868E+00, 3.7133898511E-01, 3.2650415456E-01, 6.0437705649E-01],
	[1.2355000000E+04, 5.4405413451E+00, 5.3791803034E+00, 3.7181217148E-01, 3.2687887069E-01, 6.0452483778E-01],
	[1.2360000000E+04, 5.4434766447E+00, 5.3787340377E+00, 3.7228576861E-01, 3.2725382277E-01, 6.0467259332E-01],
	[1.2365000000E+04, 5.4464123398E+00, 5.3782879894E+00, 3.7275977668E-01, 3.2762901077E-01, 6.0482032309E-01],
	[1.2370000000E+04, 5.4493484303E+00, 5.3778421585E+00, 3.7323419589E-01, 3.2800443463E-01, 6.0496802709E-01],
	[1.2375000000E+04, 5.4522849161E+00, 5.3773965447E+00, 3.7370902641E-01, 3.2838009432E-01, 6.0511570531E-01],
	[1.2380000000E+04, 5.4552217971E+00, 5.3769511477E+00, 3.7418426844E-01, 3.2875598980E-01, 6.0526335774E-01],
	[1.2385000000E+04, 5.4581590732E+00, 5.3765059675E+00, 3.7465992217E-01, 3.2913212103E-01, 6.0541098437E-01],
	[1.2390000000E+04, 5.4610967443E+00, 5.3760610039E+00, 3.7513598779E-01, 3.2950848796E-01, 6.0555858520E-01],
	[1.2395000000E+04, 5.4640348103E+00, 5.3756162565E+00, 3.7561246549E-01, 3.2988509055E-01, 6.0570616021E-01],
	[1.2400000000E+04, 5.4669732710E+00, 5.3751717253E+00, 3.7608935546E-01, 3.3026192877E-01, 6.0585370941E-01],
	[1.2405000000E+04, 5.4699121265E+00, 5.3747274101E+00, 3.7656665789E-01, 3.3063900256E-01, 6.0600123278E-01],
	[1.2410000000E+04, 5.4728513765E+00, 5.3742833106E+00, 3.7704437297E-01, 3.3101631189E-01, 6.0614873032E-01],
	[1.2415000000E+04, 5.4757910209E+00, 5.3738394266E+00, 3.7752250089E-01, 3.3139385672E-01, 6.0629620201E-01],
	[1.2420000000E+04, 5.4787310597E+00, 5.3733957581E+00, 3.7800104183E-01, 3.3177163699E-01, 6.0644364786E-01],
	[1.2425000000E+04, 5.4816714928E+00, 5.3729523047E+00, 3.7847999599E-01, 3.3214965268E-01, 6.0659106785E-01],
	[1.2430000000E+04, 5.4846177464E+00, 5.3725154146E+00, 3.7895936356E-01, 3.3252794799E-01, 6.0673846198E-01],
	[1.2435000000E+04, 5.4875648639E+00, 5.3720792807E+00, 3.7943914472E-01, 3.3290648261E-01, 6.0688583024E-01],
	[1.2440000000E+04, 5.4905123793E+00, 5.3716433576E+00, 3.7991933968E-01, 3.3328525268E-01, 6.0703317262E-01],
	[1.2445000000E+04, 5.4934602925E+00, 5.3712076450E+00, 3.8039994861E-01, 3.3366425817E-01, 6.0718048912E-01],
	[1.2450000000E+04, 5.4964086033E+00, 5.3707721428E+00, 3.8088097171E-01, 3.3404349904E-01, 6.0732777973E-01],
	[1.2455000000E+04, 5.4993573117E+00, 5.3703368507E+00, 3.8136240916E-01, 3.3442297523E-01, 6.0747504443E-01],
	[1.2460000000E+04, 5.5023064176E+00, 5.3699017686E+00, 3.8184426116E-01, 3.3480268671E-01, 6.0762228323E-01],
	[1.2465000000E+04, 5.5052559208E+00, 5.3694668962E+00, 3.8232652790E-01, 3.3518263344E-01, 6.0776949612E-01],
	[1.2470000000E+04, 5.5082058213E+00, 5.3690322335E+00, 3.8280920956E-01, 3.3556281536E-01, 6.0791668308E-01],
	[1.2475000000E+04, 5.5111561189E+00, 5.3685977802E+00, 3.8329230634E-01, 3.3594323244E-01, 6.0806384412E-01],
	[1.2480000000E+04, 5.5141068136E+00, 5.3681635361E+00, 3.8377581842E-01, 3.3632388463E-01, 6.0821097923E-01],
	[1.2485000000E+04, 5.5170579052E+00, 5.3677295010E+00, 3.8425974600E-01, 3.3670477189E-01, 6.0835808839E-01],
	[1.2490000000E+04, 5.5200093936E+00, 5.3672956748E+00, 3.8474408927E-01, 3.3708589417E-01, 6.0850517161E-01],
	[1.2495000000E+04, 5.5229612787E+00, 5.3668620573E+00, 3.8522884841E-01, 3.3746725142E-01, 6.0865222887E-01],
	[1.2500000000E+04, 5.5259135605E+00, 5.3664286483E+00, 3.8571402362E-01, 3.3784884361E-01, 6.0879926017E-01],
	[1.2505000000E+04, 5.5288662388E+00, 5.3659954476E+00, 3.8620074152E-01, 3.3823153468E-01, 6.0894626550E-01],
	[1.2510000000E+04, 5.5318193134E+00, 5.3655624550E+00, 3.8668787832E-01, 3.3861446202E-01, 6.0909324486E-01],
	[1.2515000000E+04, 5.5347727844E+00, 5.3651296704E+00, 3.8717543419E-01, 3.3899762558E-01, 6.0924019823E-01],
	[1.2520000000E+04, 5.5377266515E+00, 5.3646970935E+00, 3.8766340934E-01, 3.3938102532E-01, 6.0938712561E-01],
	[1.2525000000E+04, 5.5406809148E+00, 5.3642647242E+00, 3.8815180395E-01, 3.3976466119E-01, 6.0953402700E-01],
	[1.2530000000E+04, 5.5436355740E+00, 5.3638325622E+00, 3.8864061821E-01, 3.4014853315E-01, 6.0968090239E-01],
	[1.2535000000E+04, 5.5465906291E+00, 5.3634006075E+00, 3.8912985233E-01, 3.4053264116E-01, 6.0982775176E-01],
	[1.2540000000E+04, 5.5495460800E+00, 5.3629688599E+00, 3.8961950649E-01, 3.4091698515E-01, 6.0997457513E-01],
	[1.2545000000E+04, 5.5525019266E+00, 5.3625373190E+00, 3.9010958088E-01, 3.4130156510E-01, 6.1012137246E-01],
	[1.2550000000E+04, 5.5554581687E+00, 5.3621059849E+00, 3.9060007571E-01, 3.4168638095E-01, 6.1026814377E-01],
	[1.2555000000E+04, 5.5584148063E+00, 5.3616748572E+00, 3.9109099115E-01, 3.4207143266E-01, 6.1041488905E-01],
	[1.2560000000E+04, 5.5613718392E+00, 5.3612439358E+00, 3.9158232740E-01, 3.4245672018E-01, 6.1056160828E-01],
	[1.2565000000E+04, 5.5643292674E+00, 5.3608132206E+00, 3.9207408466E-01, 3.4284224346E-01, 6.1070830146E-01],
	[1.2570000000E+04, 5.5672870907E+00, 5.3603827113E+00, 3.9256626312E-01, 3.4322800245E-01, 6.1085496859E-01],
	[1.2575000000E+04, 5.5702453091E+00, 5.3599524077E+00, 3.9305886296E-01, 3.4361399711E-01, 6.1100160966E-01],
	[1.2580000000E+04, 5.5732039224E+00, 5.3595223098E+00, 3.9355188439E-01, 3.4400022740E-01, 6.1114822466E-01],
	[1.2585000000E+04, 5.5761629306E+00, 5.3590924172E+00, 3.9404532759E-01, 3.4438669326E-01, 6.1129481358E-01],
	[1.2590000000E+04, 5.5791223334E+00, 5.3586627299E+00, 3.9453919276E-01, 3.4477339465E-01, 6.1144137642E-01],
	[1.2595000000E+04, 5.5820821309E+00, 5.3582332476E+00, 3.9503348010E-01, 3.4516033151E-01, 6.1158791318E-01],
	[1.2600000000E+04, 5.5850423229E+00, 5.3578039702E+00, 3.9552818978E-01, 3.4554750380E-01, 6.1173442392E-01],
	[1.2605000000E+04, 5.5880029094E+00, 5.3573748975E+00, 3.9602332201E-01, 3.4593491148E-01, 6.1188090909E-01],
	[1.2610000000E+04, 5.5909638901E+00, 5.3569460292E+00, 3.9651887698E-01, 3.4632255449E-01, 6.1202736876E-01],
	[1.2615000000E+04, 5.5939252651E+00, 5.3565173653E+00, 3.9701485488E-01, 3.4671043278E-01, 6.1217380291E-01],
	[1.2620000000E+04, 5.5968870341E+00, 5.3560889056E+00, 3.9751125590E-01, 3.4709854632E-01, 6.1232021152E-01],
	[1.2625000000E+04, 5.5998491972E+00, 5.3556606498E+00, 3.9800808024E-01, 3.4748689504E-01, 6.1246659458E-01],
	[1.2630000000E+04, 5.6028174153E+00, 5.3552387607E+00, 3.9850532808E-01, 3.4787552672E-01, 6.1261295205E-01],
	[1.2635000000E+04, 5.6057865603E+00, 5.3548176477E+00, 3.9900299963E-01, 3.4826439816E-01, 6.1275928393E-01],
	[1.2640000000E+04, 5.6087561030E+00, 5.3543967345E+00, 3.9950109507E-01, 3.4865350482E-01, 6.1290559018E-01],
	[1.2645000000E+04, 5.6117260435E+00, 5.3539760207E+00, 3.9999961460E-01, 3.4904284667E-01, 6.1305187080E-01],
	[1.2650000000E+04, 5.6146963816E+00, 5.3535555064E+00, 4.0049855841E-01, 3.4943242366E-01, 6.1319812576E-01],
	[1.2655000000E+04, 5.6176671171E+00, 5.3531351912E+00, 4.0099792669E-01, 3.4982223573E-01, 6.1334435505E-01],
	[1.2660000000E+04, 5.6206382500E+00, 5.3527150750E+00, 4.0149771963E-01, 3.5021228283E-01, 6.1349055864E-01],
	[1.2665000000E+04, 5.6236097802E+00, 5.3522951577E+00, 4.0199793744E-01, 3.5060256492E-01, 6.1363673651E-01],
	[1.2670000000E+04, 5.6265817076E+00, 5.3518754390E+00, 4.0249858029E-01, 3.5099308195E-01, 6.1378288865E-01],
	[1.2675000000E+04, 5.6295540320E+00, 5.3514559189E+00, 4.0299964839E-01, 3.5138383386E-01, 6.1392901503E-01],
	[1.2680000000E+04, 5.6325267534E+00, 5.3510365971E+00, 4.0350114192E-01, 3.5177482061E-01, 6.1407511564E-01],
	[1.2685000000E+04, 5.6354998716E+00, 5.3506174734E+00, 4.0400306108E-01, 3.5216604215E-01, 6.1422119046E-01],
	[1.2690000000E+04, 5.6384733866E+00, 5.3501985477E+00, 4.0450540607E-01, 3.5255749841E-01, 6.1436723946E-01],
	[1.2695000000E+04, 5.6414472983E+00, 5.3497798198E+00, 4.0500817706E-01, 3.5294918936E-01, 6.1451326263E-01],
	[1.2700000000E+04, 5.6444216065E+00, 5.3493612895E+00, 4.0551137427E-01, 3.5334111495E-01, 6.1465925996E-01],
	[1.2705000000E+04, 5.6473963111E+00, 5.3489429567E+00, 4.0601499788E-01, 3.5373327511E-01, 6.1480523141E-01],
	[1.2710000000E+04, 5.6503714121E+00, 5.3485248213E+00, 4.0651904807E-01, 3.5412566981E-01, 6.1495117697E-01],
	[1.2715000000E+04, 5.6533469093E+00, 5.3481068829E+00, 4.0702352506E-01, 3.5451829898E-01, 6.1509709663E-01],
	[1.2720000000E+04, 5.6563228027E+00, 5.3476891415E+00, 4.0752842902E-01, 3.5491116258E-01, 6.1524299036E-01],
	[1.2725000000E+04, 5.6592990920E+00, 5.3472715969E+00, 4.0803376015E-01, 3.5530426056E-01, 6.1538885815E-01],
	[1.2730000000E+04, 5.6622757774E+00, 5.3468542488E+00, 4.0853951865E-01, 3.5569759286E-01, 6.1553469997E-01],
	[1.2735000000E+04, 5.6652528585E+00, 5.3464370973E+00, 4.0904570471E-01, 3.5609115943E-01, 6.1568051581E-01],
	[1.2740000000E+04, 5.6682303354E+00, 5.3460201420E+00, 4.0955231852E-01, 3.5648496022E-01, 6.1582630564E-01],
	[1.2745000000E+04, 5.6712082079E+00, 5.3456033828E+00, 4.1005936027E-01, 3.5687899518E-01, 6.1597206946E-01],
	[1.2750000000E+04, 5.6741864759E+00, 5.3451868196E+00, 4.1056683015E-01, 3.5727326425E-01, 6.1611780723E-01],
	[1.2755000000E+04, 5.6771651393E+00, 5.3447704521E+00, 4.1107472837E-01, 3.5766776739E-01, 6.1626351895E-01],
	[1.2760000000E+04, 5.6801441980E+00, 5.3443542802E+00, 4.1158305510E-01, 3.5806250453E-01, 6.1640920459E-01],
	[1.2765000000E+04, 5.6831236520E+00, 5.3439383038E+00, 4.1209181055E-01, 3.5845747563E-01, 6.1655486414E-01],
	[1.2770000000E+04, 5.6861035010E+00, 5.3435225226E+00, 4.1260099491E-01, 3.5885268063E-01, 6.1670049757E-01],
	[1.2775000000E+04, 5.6890837451E+00, 5.3431069365E+00, 4.1311060837E-01, 3.5924811948E-01, 6.1684610487E-01],
	[1.2780000000E+04, 5.6920643840E+00, 5.3426915453E+00, 4.1362065113E-01, 3.5964379212E-01, 6.1699168602E-01],
	[1.2785000000E+04, 5.6950454178E+00, 5.3422763489E+00, 4.1413112337E-01, 3.6003969851E-01, 6.1713724100E-01],
	[1.2790000000E+04, 5.6980268463E+00, 5.3418613471E+00, 4.1464202529E-01, 3.6043583858E-01, 6.1728276979E-01],
	[1.2795000000E+04, 5.7010086693E+00, 5.3414465397E+00, 4.1515335709E-01, 3.6083221229E-01, 6.1742827238E-01],
	[1.2800000000E+04, 5.7039908869E+00, 5.3410319266E+00, 4.1566511895E-01, 3.6122881957E-01, 6.1757374874E-01],
	[1.2805000000E+04, 5.7069734988E+00, 5.3406175075E+00, 4.1617731107E-01, 3.6162566038E-01, 6.1771919886E-01],
	[1.2810000000E+04, 5.7099565051E+00, 5.3402032824E+00, 4.1668993364E-01, 3.6202273466E-01, 6.1786462272E-01],
	[1.2815000000E+04, 5.7129399055E+00, 5.3397892511E+00, 4.1720298686E-01, 3.6242004236E-01, 6.1801002030E-01],
	[1.2820000000E+04, 5.7159237000E+00, 5.3393754133E+00, 4.1771647091E-01, 3.6281758342E-01, 6.1815539158E-01],
	[1.2825000000E+04, 5.7189078885E+00, 5.3389617690E+00, 4.1823038600E-01, 3.6321535778E-01, 6.1830073654E-01],
	[1.2830000000E+04, 5.7218942060E+00, 5.3385500682E+00, 4.1874473231E-01, 3.6361338053E-01, 6.1844605518E-01],
	[1.2835000000E+04, 5.7248857554E+00, 5.3381434359E+00, 4.1925951004E-01, 3.6401167875E-01, 6.1859134746E-01],
	[1.2840000000E+04, 5.7278777028E+00, 5.3377369930E+00, 4.1977471938E-01, 3.6441021031E-01, 6.1873661337E-01],
	[1.2845000000E+04, 5.7308700481E+00, 5.3373307392E+00, 4.2029036052E-01, 3.6480897517E-01, 6.1888185289E-01],
	[1.2850000000E+04, 5.7338627911E+00, 5.3369246744E+00, 4.2080643366E-01, 3.6520797326E-01, 6.1902706601E-01],
	[1.2855000000E+04, 5.7368559319E+00, 5.3365187985E+00, 4.2132293899E-01, 3.6560720454E-01, 6.1917225271E-01],
	[1.2860000000E+04, 5.7398494702E+00, 5.3361131113E+00, 4.2183987671E-01, 3.6600666893E-01, 6.1931741296E-01],
	[1.2865000000E+04, 5.7428434059E+00, 5.3357076126E+00, 4.2235724700E-01, 3.6640636639E-01, 6.1946254675E-01],
	[1.2870000000E+04, 5.7458377391E+00, 5.3353023022E+00, 4.2287505006E-01, 3.6680629687E-01, 6.1960765407E-01],
	[1.2875000000E+04, 5.7488324695E+00, 5.3348971801E+00, 4.2339328609E-01, 3.6720646030E-01, 6.1975273489E-01],
	[1.2880000000E+04, 5.7518275971E+00, 5.3344922460E+00, 4.2391195527E-01, 3.6760685663E-01, 6.1989778921E-01],
	[1.2885000000E+04, 5.7548231217E+00, 5.3340874998E+00, 4.2443105779E-01, 3.6800748580E-01, 6.2004281699E-01],
	[1.2890000000E+04, 5.7578190433E+00, 5.3336829413E+00, 4.2495059387E-01, 3.6840834775E-01, 6.2018781822E-01],
	[1.2895000000E+04, 5.7608153618E+00, 5.3332785704E+00, 4.2547056367E-01, 3.6880944244E-01, 6.2033279289E-01],
	[1.2900000000E+04, 5.7638120770E+00, 5.3328743868E+00, 4.2599096741E-01, 3.6921076979E-01, 6.2047774097E-01],
	[1.2905000000E+04, 5.7668091889E+00, 5.3324703906E+00, 4.2651180527E-01, 3.6961232976E-01, 6.2062266245E-01],
	[1.2910000000E+04, 5.7698066974E+00, 5.3320665814E+00, 4.2703307745E-01, 3.7001412229E-01, 6.2076755732E-01],
	[1.2915000000E+04, 5.7728046023E+00, 5.3316629591E+00, 4.2755478413E-01, 3.7041614732E-01, 6.2091242555E-01],
	[1.2920000000E+04, 5.7758029036E+00, 5.3312595236E+00, 4.2807692552E-01, 3.7081840478E-01, 6.2105726713E-01],
	[1.2925000000E+04, 5.7788016011E+00, 5.3308562747E+00, 4.2859950180E-01, 3.7122089463E-01, 6.2120208204E-01],
	[1.2930000000E+04, 5.7818006948E+00, 5.3304532122E+00, 4.2912251317E-01, 3.7162361681E-01, 6.2134687026E-01],
	[1.2935000000E+04, 5.7848001845E+00, 5.3300503361E+00, 4.2964595982E-01, 3.7202657125E-01, 6.2149163178E-01],
	[1.2940000000E+04, 5.7878000702E+00, 5.3296476460E+00, 4.3016984195E-01, 3.7242975791E-01, 6.2163636657E-01],
	[1.2945000000E+04, 5.7908003518E+00, 5.3292451420E+00, 4.3069415975E-01, 3.7283317671E-01, 6.2178107463E-01],
	[1.2950000000E+04, 5.7938010291E+00, 5.3288428237E+00, 4.3121891341E-01, 3.7323682760E-01, 6.2192575593E-01],
	[1.2955000000E+04, 5.7968021020E+00, 5.3284406912E+00, 4.3174410313E-01, 3.7364071053E-01, 6.2207041045E-01],
	[1.2960000000E+04, 5.7998035705E+00, 5.3280387441E+00, 4.3226972909E-01, 3.7404482543E-01, 6.2221503819E-01],
	[1.2965000000E+04, 5.8028054345E+00, 5.3276369824E+00, 4.3279579150E-01, 3.7444917225E-01, 6.2235963911E-01],
	[1.2970000000E+04, 5.8058076938E+00, 5.3272354058E+00, 4.3332229054E-01, 3.7485375092E-01, 6.2250421322E-01],
	[1.2975000000E+04, 5.8088103483E+00, 5.3268340143E+00, 4.3384922642E-01, 3.7525856138E-01, 6.2264876048E-01],
	[1.2980000000E+04, 5.8118133981E+00, 5.3264328077E+00, 4.3437659931E-01, 3.7566360359E-01, 6.2279328088E-01],
	[1.2985000000E+04, 5.8148168428E+00, 5.3260317858E+00, 4.3490440942E-01, 3.7606887746E-01, 6.2293777441E-01],
	[1.2990000000E+04, 5.8178206825E+00, 5.3256309484E+00, 4.3543265695E-01, 3.7647438296E-01, 6.2308224104E-01],
	[1.2995000000E+04, 5.8208249171E+00, 5.3252302955E+00, 4.3596134207E-01, 3.7688012001E-01, 6.2322668077E-01],
	[1.3000000000E+04, 5.8238295464E+00, 5.3248298268E+00, 4.3649046499E-01, 3.7728608855E-01, 6.2337109357E-01],
	[1.3005000000E+04, 5.8268345703E+00, 5.3244295422E+00, 4.3702002590E-01, 3.7769228854E-01, 6.2351547942E-01],
	[1.3010000000E+04, 5.8298399888E+00, 5.3240294415E+00, 4.3755002500E-01, 3.7809871989E-01, 6.2365983832E-01],
	[1.3015000000E+04, 5.8328458018E+00, 5.3236295246E+00, 4.3808046247E-01, 3.7850538256E-01, 6.2380417024E-01],
	[1.3020000000E+04, 5.8358520090E+00, 5.3232297914E+00, 4.3861133851E-01, 3.7891227648E-01, 6.2394847517E-01],
	[1.3025000000E+04, 5.8388586106E+00, 5.3228302416E+00, 4.3914265332E-01, 3.7931940160E-01, 6.2409275309E-01],
	[1.3030000000E+04, 5.8418656063E+00, 5.3224308752E+00, 4.3967440708E-01, 3.7972675784E-01, 6.2423700398E-01],
	[1.3035000000E+04, 5.8448729960E+00, 5.3220316919E+00, 4.4020660000E-01, 3.8013434515E-01, 6.2438122783E-01],
	[1.3040000000E+04, 5.8478874556E+00, 5.3216389434E+00, 4.4073923226E-01, 3.8054222371E-01, 6.2452542462E-01],
	[1.3045000000E+04, 5.8509025972E+00, 5.3212466402E+00, 4.4127230405E-01, 3.8095033599E-01, 6.2466959433E-01],
	[1.3050000000E+04, 5.8539181371E+00, 5.3208545162E+00, 4.4180581558E-01, 3.8135867937E-01, 6.2481373696E-01],
	[1.3055000000E+04, 5.8569340752E+00, 5.3204625713E+00, 4.4233976704E-01, 3.8176725380E-01, 6.2495785247E-01],
	[1.3060000000E+04, 5.8599504112E+00, 5.3200708053E+00, 4.4287415861E-01, 3.8217605920E-01, 6.2510194086E-01],
	[1.3065000000E+04, 5.8629671453E+00, 5.3196792182E+00, 4.4340899050E-01, 3.8258509553E-01, 6.2524600211E-01],
	[1.3070000000E+04, 5.8659842772E+00, 5.3192878096E+00, 4.4394426289E-01, 3.8299436271E-01, 6.2539003620E-01],
	[1.3075000000E+04, 5.8690018068E+00, 5.3188965796E+00, 4.4447997599E-01, 3.8340386068E-01, 6.2553404312E-01],
	[1.3080000000E+04, 5.8720197341E+00, 5.3185055279E+00, 4.4501612998E-01, 3.8381358939E-01, 6.2567802284E-01],
	[1.3085000000E+04, 5.8750380589E+00, 5.3181146544E+00, 4.4555272505E-01, 3.8422354876E-01, 6.2582197537E-01],
	[1.3090000000E+04, 5.8780567812E+00, 5.3177239589E+00, 4.4608976140E-01, 3.8463373874E-01, 6.2596590066E-01],
	[1.3095000000E+04, 5.8810759009E+00, 5.3173334413E+00, 4.4662723923E-01, 3.8504415927E-01, 6.2610979872E-01],
	[1.3100000000E+04, 5.8840954178E+00, 5.3169431015E+00, 4.4716515873E-01, 3.8545481027E-01, 6.2625366953E-01],
	[1.3105000000E+04, 5.8871153318E+00, 5.3165529392E+00, 4.4770352009E-01, 3.8586569169E-01, 6.2639751307E-01],
	[1.3110000000E+04, 5.8901356429E+00, 5.3161629544E+00, 4.4824232351E-01, 3.8627680346E-01, 6.2654132932E-01],
	[1.3115000000E+04, 5.8931563510E+00, 5.3157731469E+00, 4.4878156917E-01, 3.8668814552E-01, 6.2668511826E-01],
	[1.3120000000E+04, 5.8961774559E+00, 5.3153835166E+00, 4.4932125728E-01, 3.8709971781E-01, 6.2682887989E-01],
	[1.3125000000E+04, 5.8991989576E+00, 5.3149940632E+00, 4.4986138802E-01, 3.8751152026E-01, 6.2697261419E-01],
	[1.3130000000E+04, 5.9022208559E+00, 5.3146047867E+00, 4.5040196160E-01, 3.8792355281E-01, 6.2711632113E-01],
	[1.3135000000E+04, 5.9052431508E+00, 5.3142156870E+00, 4.5094297820E-01, 3.8833581539E-01, 6.2726000071E-01],
	[1.3140000000E+04, 5.9082658422E+00, 5.3138267637E+00, 4.5148443801E-01, 3.8874830794E-01, 6.2740365291E-01],
	[1.3145000000E+04, 5.9112889299E+00, 5.3134380169E+00, 4.5202634124E-01, 3.8916103040E-01, 6.2754727771E-01],
	[1.3150000000E+04, 5.9143124139E+00, 5.3130494463E+00, 4.5256868808E-01, 3.8957398269E-01, 6.2769087509E-01],
	[1.3155000000E+04, 5.9173362940E+00, 5.3126610519E+00, 4.5311147871E-01, 3.8998716476E-01, 6.2783444505E-01],
	[1.3160000000E+04, 5.9203605702E+00, 5.3122728334E+00, 4.5365471334E-01, 3.9040057654E-01, 6.2797798756E-01],
	[1.3165000000E+04, 5.9233852424E+00, 5.3118847908E+00, 4.5419839216E-01, 3.9081421796E-01, 6.2812150262E-01],
	[1.3170000000E+04, 5.9264103104E+00, 5.3114969238E+00, 4.5474251535E-01, 3.9122808897E-01, 6.2826499019E-01],
	[1.3175000000E+04, 5.9294357742E+00, 5.3111092324E+00, 4.5528708312E-01, 3.9164218948E-01, 6.2840845028E-01],
	[1.3180000000E+04, 5.9324616337E+00, 5.3107217163E+00, 4.5583209566E-01, 3.9205651945E-01, 6.2855188286E-01],
	[1.3185000000E+04, 5.9354878887E+00, 5.3103343755E+00, 4.5637755316E-01, 3.9247107880E-01, 6.2869528792E-01],
	[1.3190000000E+04, 5.9385145392E+00, 5.3099472098E+00, 4.5692345582E-01, 3.9288586746E-01, 6.2883866544E-01],
	[1.3195000000E+04, 5.9415415851E+00, 5.3095602190E+00, 4.5746980383E-01, 3.9330088538E-01, 6.2898201541E-01],
	[1.3200000000E+04, 5.9445690263E+00, 5.3091734031E+00, 4.5801659738E-01, 3.9371613247E-01, 6.2912533780E-01],
	[1.3205000000E+04, 5.9475968627E+00, 5.3087867618E+00, 4.5856383667E-01, 3.9413160869E-01, 6.2926863262E-01],
	[1.3210000000E+04, 5.9506250941E+00, 5.3084002950E+00, 4.5911152189E-01, 3.9454731396E-01, 6.2941189984E-01],
	[1.3215000000E+04, 5.9536537205E+00, 5.3080140026E+00, 4.5965965324E-01, 3.9496324821E-01, 6.2955513944E-01],
	[1.3220000000E+04, 5.9566827418E+00, 5.3076278844E+00, 4.6020823091E-01, 3.9537941137E-01, 6.2969835141E-01],
	[1.3225000000E+04, 5.9597121579E+00, 5.3072419402E+00, 4.6075725509E-01, 3.9579580339E-01, 6.2984153574E-01],
	[1.3230000000E+04, 5.9627419687E+00, 5.3068561701E+00, 4.6130672598E-01, 3.9621242419E-01, 6.2998469241E-01],
	[1.3235000000E+04, 5.9657721741E+00, 5.3064705737E+00, 4.6185664377E-01, 3.9662927371E-01, 6.3012782140E-01],
	[1.3240000000E+04, 5.9688027739E+00, 5.3060851509E+00, 4.6240700866E-01, 3.9704635187E-01, 6.3027092271E-01],
	[1.3245000000E+04, 5.9718337682E+00, 5.3056999017E+00, 4.6295782083E-01, 3.9746365861E-01, 6.3041399631E-01],
	[1.3250000000E+04, 5.9748724307E+00, 5.3053211684E+00, 4.6350908049E-01, 3.9788126180E-01, 6.3055704219E-01],
	[1.3255000000E+04, 5.9779115700E+00, 5.3049426728E+00, 4.6406078783E-01, 3.9829909439E-01, 6.3070006033E-01],
	[1.3260000000E+04, 5.9809511080E+00, 5.3045643470E+00, 4.6461294304E-01, 3.9871715559E-01, 6.3084305073E-01],
	[1.3265000000E+04, 5.9839910448E+00, 5.3041861908E+00, 4.6516554631E-01, 3.9913544533E-01, 6.3098601336E-01],
	[1.3270000000E+04, 5.9870313801E+00, 5.3038082041E+00, 4.6571859785E-01, 3.9955396355E-01, 6.3112894821E-01],
	[1.3275000000E+04, 5.9900721140E+00, 5.3034303866E+00, 4.6627209784E-01, 3.9997271018E-01, 6.3127185527E-01],
	[1.3280000000E+04, 5.9931132463E+00, 5.3030527384E+00, 4.6682604647E-01, 4.0039168514E-01, 6.3141473451E-01],
	[1.3285000000E+04, 5.9961547768E+00, 5.3026752592E+00, 4.6738044395E-01, 4.0081088838E-01, 6.3155758594E-01],
	[1.3290000000E+04, 5.9991967056E+00, 5.3022979488E+00, 4.6793529047E-01, 4.0123031981E-01, 6.3170040952E-01],
	[1.3295000000E+04, 6.0022390325E+00, 5.3019208073E+00, 4.6849058621E-01, 4.0164997938E-01, 6.3184320525E-01],
	[1.3300000000E+04, 6.0052817574E+00, 5.3015438343E+00, 4.6904633138E-01, 4.0206986700E-01, 6.3198597312E-01],
	[1.3305000000E+04, 6.0083248803E+00, 5.3011670298E+00, 4.6960252617E-01, 4.0248998263E-01, 6.3212871310E-01],
	[1.3310000000E+04, 6.0113684009E+00, 5.3007903937E+00, 4.7015917077E-01, 4.0291032617E-01, 6.3227142518E-01],
	[1.3315000000E+04, 6.0144123193E+00, 5.3004139258E+00, 4.7071626537E-01, 4.0333089758E-01, 6.3241410935E-01],
	[1.3320000000E+04, 6.0174566353E+00, 5.3000376259E+00, 4.7127381018E-01, 4.0375169676E-01, 6.3255676560E-01],
	[1.3325000000E+04, 6.0205013488E+00, 5.2996614940E+00, 4.7183180538E-01, 4.0417272367E-01, 6.3269939390E-01],
	[1.3330000000E+04, 6.0235464597E+00, 5.2992855299E+00, 4.7239025117E-01, 4.0459397821E-01, 6.3284199425E-01],
	[1.3335000000E+04, 6.0265919680E+00, 5.2989097334E+00, 4.7294914775E-01, 4.0501546034E-01, 6.3298456664E-01],
	[1.3340000000E+04, 6.0296378735E+00, 5.2985341044E+00, 4.7350849530E-01, 4.0543716997E-01, 6.3312711103E-01],
	[1.3345000000E+04, 6.0326841762E+00, 5.2981586428E+00, 4.7406829402E-01, 4.0585910703E-01, 6.3326962743E-01],
	[1.3350000000E+04, 6.0357308759E+00, 5.2977833485E+00, 4.7462854411E-01, 4.0628127145E-01, 6.3341211582E-01],
	[1.3355000000E+04, 6.0387779726E+00, 5.2974082212E+00, 4.7518924576E-01, 4.0670366317E-01, 6.3355457617E-01],
	[1.3360000000E+04, 6.0418254661E+00, 5.2970332609E+00, 4.7575039916E-01, 4.0712628212E-01, 6.3369700849E-01],
	[1.3365000000E+04, 6.0448733563E+00, 5.2966584675E+00, 4.7631200451E-01, 4.0754912821E-01, 6.3383941275E-01],
	[1.3370000000E+04, 6.0479216432E+00, 5.2962838407E+00, 4.7687406201E-01, 4.0797220138E-01, 6.3398178895E-01],
	[1.3375000000E+04, 6.0509703267E+00, 5.2959093805E+00, 4.7743657184E-01, 4.0839550157E-01, 6.3412413705E-01],
	[1.3380000000E+04, 6.0540194066E+00, 5.2955350867E+00, 4.7799953420E-01, 4.0881902869E-01, 6.3426645707E-01],
	[1.3385000000E+04, 6.0570688829E+00, 5.2951609592E+00, 4.7856294929E-01, 4.0924278267E-01, 6.3440874896E-01],
	[1.3390000000E+04, 6.0601187554E+00, 5.2947869978E+00, 4.7912681730E-01, 4.0966676345E-01, 6.3455101274E-01],
	[1.3395000000E+04, 6.0631690241E+00, 5.2944132025E+00, 4.7969113842E-01, 4.1009097095E-01, 6.3469324837E-01],
	[1.3400000000E+04, 6.0662196889E+00, 5.2940395730E+00, 4.8025591285E-01, 4.1051540510E-01, 6.3483545585E-01],
	[1.3405000000E+04, 6.0692707497E+00, 5.2936661093E+00, 4.8082114079E-01, 4.1094006582E-01, 6.3497763516E-01],
	[1.3410000000E+04, 6.0723222063E+00, 5.2932928111E+00, 4.8138682242E-01, 4.1136495305E-01, 6.3511978629E-01],
	[1.3415000000E+04, 6.0753740588E+00, 5.2929196785E+00, 4.8195295794E-01, 4.1179006671E-01, 6.3526190923E-01],
	[1.3420000000E+04, 6.0784263069E+00, 5.2925467112E+00, 4.8251954755E-01, 4.1221540674E-01, 6.3540400395E-01],
	[1.3425000000E+04, 6.0814789506E+00, 5.2921739090E+00, 4.8308659144E-01, 4.1264097304E-01, 6.3554607045E-01],
	[1.3430000000E+04, 6.0845319899E+00, 5.2918012720E+00, 4.8365408980E-01, 4.1306676556E-01, 6.3568810872E-01],
	[1.3435000000E+04, 6.0875854245E+00, 5.2914287999E+00, 4.8422204283E-01, 4.1349278423E-01, 6.3583011873E-01],
	[1.3440000000E+04, 6.0906392544E+00, 5.2910564925E+00, 4.8479045073E-01, 4.1391902895E-01, 6.3597210048E-01],
	[1.3445000000E+04, 6.0936934795E+00, 5.2906843499E+00, 4.8535931368E-01, 4.1434549967E-01, 6.3611405395E-01],
	[1.3450000000E+04, 6.0967480998E+00, 5.2903123717E+00, 4.8592863189E-01, 4.1477219631E-01, 6.3625597913E-01],
	[1.3455000000E+04, 6.0998031151E+00, 5.2899405580E+00, 4.8649840554E-01, 4.1519911880E-01, 6.3639787601E-01],
	[1.3460000000E+04, 6.1028611898E+00, 5.2895710776E+00, 4.8706863483E-01, 4.1562629280E-01, 6.3653974456E-01],
	[1.3465000000E+04, 6.1059247449E+00, 5.2892058965E+00, 4.8763931996E-01, 4.1605374179E-01, 6.3668158479E-01],
	[1.3470000000E+04, 6.1089886997E+00, 5.2888408763E+00, 4.8821046112E-01, 4.1648141665E-01, 6.3682339666E-01],
	[1.3475000000E+04, 6.1120530540E+00, 5.2884760166E+00, 4.8878205851E-01, 4.1690931731E-01, 6.3696518014E-01],
	[1.3480000000E+04, 6.1151178077E+00, 5.2881113175E+00, 4.8935411231E-01, 4.1733744369E-01, 6.3710693520E-01],
	[1.3485000000E+04, 6.1181829607E+00, 5.2877467788E+00, 4.8992662272E-01, 4.1776579572E-01, 6.3724866183E-01],
	[1.3490000000E+04, 6.1212485130E+00, 5.2873824003E+00, 4.9049958995E-01, 4.1819437333E-01, 6.3739036001E-01],
	[1.3495000000E+04, 6.1243144644E+00, 5.2870181820E+00, 4.9107301417E-01, 4.1862317644E-01, 6.3753202971E-01],
	[1.3500000000E+04, 6.1273808149E+00, 5.2866541236E+00, 4.9164689560E-01, 4.1905220498E-01, 6.3767367092E-01],
	[1.3505000000E+04, 6.1304475643E+00, 5.2862902251E+00, 4.9222123441E-01, 4.1948145887E-01, 6.3781528362E-01],
	[1.3510000000E+04, 6.1335147125E+00, 5.2859264864E+00, 4.9279603081E-01, 4.1991093803E-01, 6.3795686779E-01],
	[1.3515000000E+04, 6.1365822596E+00, 5.2855629072E+00, 4.9337128499E-01, 4.2034064239E-01, 6.3809842340E-01],
	[1.3520000000E+04, 6.1396502052E+00, 5.2851994876E+00, 4.9394699715E-01, 4.2077057188E-01, 6.3823995044E-01],
	[1.3525000000E+04, 6.1427185495E+00, 5.2848362272E+00, 4.9452316747E-01, 4.2120072642E-01, 6.3838144889E-01],
	[1.3530000000E+04, 6.1457872922E+00, 5.2844731261E+00, 4.9509979616E-01, 4.2163110593E-01, 6.3852291874E-01],
	[1.3535000000E+04, 6.1488564333E+00, 5.2841101841E+00, 4.9567688341E-01, 4.2206171035E-01, 6.3866435995E-01],
	[1.3540000000E+04, 6.1519259726E+00, 5.2837474011E+00, 4.9625442941E-01, 4.2249253958E-01, 6.3880577252E-01],
	[1.3545000000E+04, 6.1549959101E+00, 5.2833847769E+00, 4.9683243436E-01, 4.2292359356E-01, 6.3894715642E-01],
	[1.3550000000E+04, 6.1580662458E+00, 5.2830223114E+00, 4.9741089846E-01, 4.2335487221E-01, 6.3908851164E-01],
	[1.3555000000E+04, 6.1611369794E+00, 5.2826600045E+00, 4.9798982189E-01, 4.2378637545E-01, 6.3922983815E-01],
	[1.3560000000E+04, 6.1642081109E+00, 5.2822978560E+00, 4.9856920485E-01, 4.2421810321E-01, 6.3937113593E-01],
	[1.3565000000E+04, 6.1672796402E+00, 5.2819358659E+00, 4.9914904754E-01, 4.2465005541E-01, 6.3951240498E-01],
	[1.3570000000E+04, 6.1703515672E+00, 5.2815740339E+00, 4.9972935015E-01, 4.2508223197E-01, 6.3965364526E-01],
	[1.3575000000E+04, 6.1734238919E+00, 5.2812123601E+00, 5.0031011287E-01, 4.2551463281E-01, 6.3979485676E-01],
	[1.3580000000E+04, 6.1764966140E+00, 5.2808508441E+00, 5.0089133591E-01, 4.2594725787E-01, 6.3993603946E-01],
	[1.3585000000E+04, 6.1795697336E+00, 5.2804894860E+00, 5.0147301945E-01, 4.2638010705E-01, 6.4007719334E-01],
	[1.3590000000E+04, 6.1826432505E+00, 5.2801282856E+00, 5.0205516369E-01, 4.2681318029E-01, 6.4021831839E-01],
	[1.3595000000E+04, 6.1857171646E+00, 5.2797672427E+00, 5.0263776883E-01, 4.2724647750E-01, 6.4035941458E-01],
	[1.3600000000E+04, 6.1887914758E+00, 5.2794063573E+00, 5.0322083506E-01, 4.2767999862E-01, 6.4050048189E-01],
	[1.3605000000E+04, 6.1918661841E+00, 5.2790456292E+00, 5.0380436257E-01, 4.2811374355E-01, 6.4064152032E-01],
	[1.3610000000E+04, 6.1949412894E+00, 5.2786850582E+00, 5.0438835156E-01, 4.2854771222E-01, 6.4078252983E-01],
	[1.3615000000E+04, 6.1980167915E+00, 5.2783246443E+00, 5.0497280222E-01, 4.2898190456E-01, 6.4092351041E-01],
	[1.3620000000E+04, 6.2010926903E+00, 5.2779643874E+00, 5.0555771475E-01, 4.2941632048E-01, 6.4106446204E-01],
	[1.3625000000E+04, 6.2041689858E+00, 5.2776042872E+00, 5.0614308934E-01, 4.2985095990E-01, 6.4120538470E-01],
	[1.3630000000E+04, 6.2072456779E+00, 5.2772443437E+00, 5.0672892620E-01, 4.3028582276E-01, 6.4134627838E-01],
	[1.3635000000E+04, 6.2103227665E+00, 5.2768845568E+00, 5.0731522550E-01, 4.3072090896E-01, 6.4148714305E-01],
	[1.3640000000E+04, 6.2134002514E+00, 5.2765249263E+00, 5.0790198746E-01, 4.3115621843E-01, 6.4162797871E-01],
	[1.3645000000E+04, 6.2164781327E+00, 5.2761654521E+00, 5.0848921225E-01, 4.3159175109E-01, 6.4176878532E-01],
	[1.3650000000E+04, 6.2195564101E+00, 5.2758061341E+00, 5.0907690008E-01, 4.3202750687E-01, 6.4190956287E-01],
	[1.3655000000E+04, 6.2226350836E+00, 5.2754469721E+00, 5.0966505115E-01, 4.3246348567E-01, 6.4205031134E-01],
	[1.3660000000E+04, 6.2257141531E+00, 5.2750879661E+00, 5.1025366564E-01, 4.3289968742E-01, 6.4219103072E-01],
	[1.3665000000E+04, 6.2287936185E+00, 5.2747291158E+00, 5.1084274376E-01, 4.3333611205E-01, 6.4233172098E-01],
	[1.3670000000E+04, 6.2318734798E+00, 5.2743704213E+00, 5.1143228569E-01, 4.3377275947E-01, 6.4247238212E-01],
	[1.3675000000E+04, 6.2349538341E+00, 5.2740119564E+00, 5.1202229163E-01, 4.3420963057E-01, 6.4261301410E-01],
	[1.3680000000E+04, 6.2380426364E+00, 5.2736597751E+00, 5.1261276178E-01, 4.3464680503E-01, 6.4275361691E-01],
	[1.3685000000E+04, 6.2411318394E+00, 5.2733077461E+00, 5.1320369633E-01, 4.3508420230E-01, 6.4289419054E-01],
	[1.3690000000E+04, 6.2442214428E+00, 5.2729558692E+00, 5.1379509547E-01, 4.3552182231E-01, 6.4303473497E-01],
	[1.3695000000E+04, 6.2473114467E+00, 5.2726041442E+00, 5.1438825867E-01, 4.3596059826E-01, 6.4317525017E-01],
	[1.3700000000E+04, 6.2504018509E+00, 5.2722525710E+00, 5.1498401129E-01, 4.3640112178E-01, 6.4331573613E-01],
	[1.3705000000E+04, 6.2534926554E+00, 5.2719011496E+00, 5.1558023573E-01, 4.3684187111E-01, 6.4345619283E-01],
	[1.3710000000E+04, 6.2565838600E+00, 5.2715498797E+00, 5.1617693219E-01, 4.3728284619E-01, 6.4359662026E-01],
	[1.3715000000E+04, 6.2596754647E+00, 5.2711987613E+00, 5.1677410088E-01, 4.3772404691E-01, 6.4373701840E-01],
	[1.3720000000E+04, 6.2627674693E+00, 5.2708477943E+00, 5.1737174200E-01, 4.3816547321E-01, 6.4387738722E-01],
	[1.3725000000E+04, 6.2658598737E+00, 5.2704969786E+00, 5.1796985574E-01, 4.3860712500E-01, 6.4401772671E-01],
	[1.3730000000E+04, 6.2689526780E+00, 5.2701463139E+00, 5.1856844231E-01, 4.3904900220E-01, 6.4415803686E-01],
	[1.3735000000E+04, 6.2720458819E+00, 5.2697958002E+00, 5.1916750191E-01, 4.3949110473E-01, 6.4429831765E-01],
	[1.3740000000E+04, 6.2751394854E+00, 5.2694454374E+00, 5.1976703474E-01, 4.3993343250E-01, 6.4443856905E-01],
	[1.3745000000E+04, 6.2782334884E+00, 5.2690952254E+00, 5.2036704101E-01, 4.4037598544E-01, 6.4457879105E-01],
	[1.3750000000E+04, 6.2813278907E+00, 5.2687451640E+00, 5.2096752090E-01, 4.4081876346E-01, 6.4471898364E-01],
	[1.3755000000E+04, 6.2844226924E+00, 5.2683952531E+00, 5.2156847463E-01, 4.4126176647E-01, 6.4485914679E-01],
	[1.3760000000E+04, 6.2875178933E+00, 5.2680454926E+00, 5.2216990239E-01, 4.4170499440E-01, 6.4499928049E-01],
	[1.3765000000E+04, 6.2906134932E+00, 5.2676958824E+00, 5.2277180439E-01, 4.4214844716E-01, 6.4513938472E-01],
	[1.3770000000E+04, 6.2937094922E+00, 5.2673464224E+00, 5.2337418082E-01, 4.4259212467E-01, 6.4527945946E-01],
	[1.3775000000E+04, 6.2968058901E+00, 5.2669971124E+00, 5.2397703189E-01, 4.4303602684E-01, 6.4541950470E-01],
	[1.3780000000E+04, 6.2999026869E+00, 5.2666479523E+00, 5.2458035780E-01, 4.4348015360E-01, 6.4555952042E-01],
	[1.3785000000E+04, 6.3029998824E+00, 5.2662989420E+00, 5.2518415875E-01, 4.4392450485E-01, 6.4569950660E-01],
	[1.3790000000E+04, 6.3060974765E+00, 5.2659500814E+00, 5.2578843494E-01, 4.4436908052E-01, 6.4583946323E-01],
	[1.3795000000E+04, 6.3091954692E+00, 5.2656013704E+00, 5.2639318657E-01, 4.4481388053E-01, 6.4597939028E-01],
	[1.3800000000E+04, 6.3122938603E+00, 5.2652528088E+00, 5.2699841384E-01, 4.4525890477E-01, 6.4611928774E-01],
	[1.3805000000E+04, 6.3153926498E+00, 5.2649043965E+00, 5.2760411695E-01, 4.4570415319E-01, 6.4625915559E-01],
	[1.3810000000E+04, 6.3184918376E+00, 5.2645561334E+00, 5.2821029611E-01, 4.4614962568E-01, 6.4639899382E-01],
	[1.3815000000E+04, 6.3215914236E+00, 5.2642080195E+00, 5.2881695151E-01, 4.4659532216E-01, 6.4653880241E-01],
	[1.3820000000E+04, 6.3246914076E+00, 5.2638600545E+00, 5.2942408336E-01, 4.4704124255E-01, 6.4667858134E-01],
	[1.3825000000E+04, 6.3277917896E+00, 5.2635122384E+00, 5.3003169186E-01, 4.4748738677E-01, 6.4681833060E-01],
	[1.3830000000E+04, 6.3308925696E+00, 5.2631645710E+00, 5.3063977721E-01, 4.4793375473E-01, 6.4695805017E-01],
	[1.3835000000E+04, 6.3339937473E+00, 5.2628170522E+00, 5.3124833961E-01, 4.4838034635E-01, 6.4709774002E-01],
	[1.3840000000E+04, 6.3370953227E+00, 5.2624696819E+00, 5.3185737926E-01, 4.4882716153E-01, 6.4723740015E-01],
	[1.3845000000E+04, 6.3401972958E+00, 5.2621224601E+00, 5.3246689636E-01, 4.4927420020E-01, 6.4737703054E-01],
	[1.3850000000E+04, 6.3432996664E+00, 5.2617753865E+00, 5.3307689111E-01, 4.4972146226E-01, 6.4751663117E-01],
	[1.3855000000E+04, 6.3464024344E+00, 5.2614284610E+00, 5.3368736372E-01, 4.5016894764E-01, 6.4765620202E-01],
	[1.3860000000E+04, 6.3495055998E+00, 5.2610816836E+00, 5.3429831438E-01, 4.5061665625E-01, 6.4779574308E-01],
	[1.3865000000E+04, 6.3526091624E+00, 5.2607350541E+00, 5.3490974331E-01, 4.5106458800E-01, 6.4793525433E-01],
	[1.3870000000E+04, 6.3557131222E+00, 5.2603885724E+00, 5.3552165069E-01, 4.5151274280E-01, 6.4807473575E-01],
	[1.3875000000E+04, 6.3588174791E+00, 5.2600422384E+00, 5.3613403673E-01, 4.5196112057E-01, 6.4821418733E-01],
	[1.3880000000E+04, 6.3619222329E+00, 5.2596960520E+00, 5.3674690163E-01, 4.5240972122E-01, 6.4835360905E-01],
	[1.3885000000E+04, 6.3650273836E+00, 5.2593500130E+00, 5.3736024559E-01, 4.5285854467E-01, 6.4849300090E-01],
	[1.3890000000E+04, 6.3681329311E+00, 5.2590041214E+00, 5.3797406882E-01, 4.5330759083E-01, 6.4863236286E-01],
	[1.3895000000E+04, 6.3712388753E+00, 5.2586583770E+00, 5.3858837151E-01, 4.5375685961E-01, 6.4877169490E-01],
	[1.3900000000E+04, 6.3743536208E+00, 5.2583187734E+00, 5.3920315387E-01, 4.5420643832E-01, 6.4891099702E-01],
	[1.3905000000E+04, 6.3774689190E+00, 5.2579794215E+00, 5.3981841609E-01, 4.5465624132E-01, 6.4905026921E-01],
	[1.3910000000E+04, 6.3805846188E+00, 5.2576402135E+00, 5.4043415838E-01, 4.5510626698E-01, 6.4918951143E-01],
	[1.3915000000E+04, 6.3837007203E+00, 5.2573011492E+00, 5.4105038095E-01, 4.5555651519E-01, 6.4932872368E-01],
	[1.3920000000E+04, 6.3868172232E+00, 5.2569622287E+00, 5.4166708398E-01, 4.5600698587E-01, 6.4946790594E-01],
	[1.3925000000E+04, 6.3899341276E+00, 5.2566234516E+00, 5.4228426769E-01, 4.5645767893E-01, 6.4960705819E-01],
	[1.3930000000E+04, 6.3930514333E+00, 5.2562848180E+00, 5.4290193227E-01, 4.5690859429E-01, 6.4974618042E-01],
	[1.3935000000E+04, 6.3961691402E+00, 5.2559463278E+00, 5.4352007792E-01, 4.5735973186E-01, 6.4988527262E-01],
	[1.3940000000E+04, 6.3992872482E+00, 5.2556079807E+00, 5.4413870486E-01, 4.5781109154E-01, 6.5002433475E-01],
	[1.3945000000E+04, 6.4024057573E+00, 5.2552697768E+00, 5.4475781327E-01, 4.5826267327E-01, 6.5016336682E-01],
	[1.3950000000E+04, 6.4055246674E+00, 5.2549317159E+00, 5.4537740336E-01, 4.5871447693E-01, 6.5030236880E-01],
	[1.3955000000E+04, 6.4086439783E+00, 5.2545937978E+00, 5.4599747533E-01, 4.5916650245E-01, 6.5044134068E-01],
	[1.3960000000E+04, 6.4117636900E+00, 5.2542560225E+00, 5.4661802938E-01, 4.5961874974E-01, 6.5058028244E-01],
	[1.3965000000E+04, 6.4148838024E+00, 5.2539183899E+00, 5.4723906572E-01, 4.6007121871E-01, 6.5071919407E-01],
	[1.3970000000E+04, 6.4180043153E+00, 5.2535808998E+00, 5.4786058455E-01, 4.6052390926E-01, 6.5085807554E-01],
	[1.3975000000E+04, 6.4211252288E+00, 5.2532435522E+00, 5.4848258606E-01, 4.6097682132E-01, 6.5099692685E-01],
	[1.3980000000E+04, 6.4242465426E+00, 5.2529063468E+00, 5.4910507045E-01, 4.6142995480E-01, 6.5113574798E-01],
	[1.3985000000E+04, 6.4273682567E+00, 5.2525692837E+00, 5.4972803794E-01, 4.6188330959E-01, 6.5127453891E-01],
	[1.3990000000E+04, 6.4304903711E+00, 5.2522323627E+00, 5.5035148872E-01, 4.6233688562E-01, 6.5141329963E-01],
	[1.3995000000E+04, 6.4336128856E+00, 5.2518955837E+00, 5.5097542299E-01, 4.6279068280E-01, 6.5155203012E-01],
	[1.4000000000E+04, 6.4367358001E+00, 5.2515589466E+00, 5.5159984096E-01, 4.6324470103E-01, 6.5169073036E-01],
	[1.4005000000E+04, 6.4398591146E+00, 5.2512224512E+00, 5.5222474282E-01, 4.6369894022E-01, 6.5182940034E-01],
	[1.4010000000E+04, 6.4429828289E+00, 5.2508860976E+00, 5.5285012878E-01, 4.6415340029E-01, 6.5196804005E-01],
	[1.4015000000E+04, 6.4461069430E+00, 5.2505498854E+00, 5.5347599904E-01, 4.6460808115E-01, 6.5210664946E-01],
	[1.4020000000E+04, 6.4492314567E+00, 5.2502138147E+00, 5.5410235380E-01, 4.6506298270E-01, 6.5224522857E-01],
	[1.4025000000E+04, 6.4523563701E+00, 5.2498778854E+00, 5.5472919327E-01, 4.6551810486E-01, 6.5238377736E-01],
	[1.4030000000E+04, 6.4554816829E+00, 5.2495420972E+00, 5.5535651763E-01, 4.6597344753E-01, 6.5252229581E-01],
	[1.4035000000E+04, 6.4586073951E+00, 5.2492064502E+00, 5.5598432710E-01, 4.6642901063E-01, 6.5266078390E-01],
	[1.4040000000E+04, 6.4617335066E+00, 5.2488709442E+00, 5.5661262188E-01, 4.6688479406E-01, 6.5279924163E-01],
	[1.4045000000E+04, 6.4648600173E+00, 5.2485355790E+00, 5.5724140217E-01, 4.6734079773E-01, 6.5293766897E-01],
	[1.4050000000E+04, 6.4679869271E+00, 5.2482003547E+00, 5.5787066816E-01, 4.6779702155E-01, 6.5307606592E-01],
	[1.4055000000E+04, 6.4711142360E+00, 5.2478652710E+00, 5.5850042007E-01, 4.6825346543E-01, 6.5321443245E-01],
	[1.4060000000E+04, 6.4742419438E+00, 5.2475303279E+00, 5.5913065810E-01, 4.6871012928E-01, 6.5335276855E-01],
	[1.4065000000E+04, 6.4773700504E+00, 5.2471955252E+00, 5.5976138243E-01, 4.6916701301E-01, 6.5349107420E-01],
	[1.4070000000E+04, 6.4804985558E+00, 5.2468608629E+00, 5.6039259329E-01, 4.6962411652E-01, 6.5362934940E-01],
	[1.4075000000E+04, 6.4836274599E+00, 5.2465263409E+00, 5.6102429086E-01, 4.7008143973E-01, 6.5376759412E-01],
	[1.4080000000E+04, 6.4867567625E+00, 5.2461919589E+00, 5.6165647535E-01, 4.7053898254E-01, 6.5390580835E-01],
	[1.4085000000E+04, 6.4898864636E+00, 5.2458577170E+00, 5.6228914697E-01, 4.7099674486E-01, 6.5404399207E-01],
	[1.4090000000E+04, 6.4930165631E+00, 5.2455236150E+00, 5.6292230591E-01, 4.7145472659E-01, 6.5418214528E-01],
	[1.4095000000E+04, 6.4961470610E+00, 5.2451896528E+00, 5.6355595238E-01, 4.7191292765E-01, 6.5432026795E-01],
	[1.4100000000E+04, 6.4992779570E+00, 5.2448558304E+00, 5.6419008657E-01, 4.7237134795E-01, 6.5445836007E-01],
	[1.4105000000E+04, 6.5024092511E+00, 5.2445221475E+00, 5.6482470869E-01, 4.7282998738E-01, 6.5459642162E-01],
	[1.4110000000E+04, 6.5055409433E+00, 5.2441886040E+00, 5.6545981894E-01, 4.7328884586E-01, 6.5473445260E-01],
	[1.4115000000E+04, 6.5086730334E+00, 5.2438552000E+00, 5.6609541753E-01, 4.7374792329E-01, 6.5487245298E-01],
	[1.4120000000E+04, 6.5118077084E+00, 5.2435233998E+00, 5.6673150465E-01, 4.7420724316E-01, 6.5501042275E-01],
	[1.4125000000E+04, 6.5149495620E+00, 5.2431962756E+00, 5.6736808051E-01, 4.7466685505E-01, 6.5514836190E-01],
	[1.4130000000E+04, 6.5180918187E+00, 5.2428692877E+00, 5.6800514530E-01, 4.7512668591E-01, 6.5528627040E-01],
	[1.4135000000E+04, 6.5212344785E+00, 5.2425424358E+00, 5.6864269923E-01, 4.7558673566E-01, 6.5542414826E-01],
	[1.4140000000E+04, 6.5243775412E+00, 5.2422157198E+00, 5.6928074251E-01, 4.7604700419E-01, 6.5556199545E-01],
	[1.4145000000E+04, 6.5275210068E+00, 5.2418891397E+00, 5.6991927533E-01, 4.7650749142E-01, 6.5569981195E-01],
	[1.4150000000E+04, 6.5306648751E+00, 5.2415626954E+00, 5.7055829790E-01, 4.7696819725E-01, 6.5583759776E-01],
	[1.4155000000E+04, 6.5338091461E+00, 5.2412363867E+00, 5.7119781041E-01, 4.7742912159E-01, 6.5597535285E-01],
	[1.4160000000E+04, 6.5369538197E+00, 5.2409102136E+00, 5.7183781307E-01, 4.7789026434E-01, 6.5611307722E-01],
	[1.4165000000E+04, 6.5400988958E+00, 5.2405841759E+00, 5.7247830609E-01, 4.7835162542E-01, 6.5625077085E-01],
	[1.4170000000E+04, 6.5432443743E+00, 5.2402582735E+00, 5.7311928965E-01, 4.7881320472E-01, 6.5638843372E-01],
	[1.4175000000E+04, 6.5463902551E+00, 5.2399325064E+00, 5.7376076398E-01, 4.7927500215E-01, 6.5652606583E-01],
	[1.4180000000E+04, 6.5495365381E+00, 5.2396068744E+00, 5.7440272926E-01, 4.7973701762E-01, 6.5666366714E-01],
	[1.4185000000E+04, 6.5526832233E+00, 5.2392813774E+00, 5.7504518569E-01, 4.8019925104E-01, 6.5680123767E-01],
	[1.4190000000E+04, 6.5558303105E+00, 5.2389560154E+00, 5.7568813349E-01, 4.8066170230E-01, 6.5693877737E-01],
	[1.4195000000E+04, 6.5589777997E+00, 5.2386307881E+00, 5.7633157286E-01, 4.8112437131E-01, 6.5707628626E-01],
	[1.4200000000E+04, 6.5621256907E+00, 5.2383056956E+00, 5.7697550398E-01, 4.8158725799E-01, 6.5721376430E-01],
	[1.4205000000E+04, 6.5652739835E+00, 5.2379807377E+00, 5.7761992708E-01, 4.8205036223E-01, 6.5735121148E-01],
	[1.4210000000E+04, 6.5684226780E+00, 5.2376559143E+00, 5.7826484234E-01, 4.8251368393E-01, 6.5748862780E-01],
	[1.4215000000E+04, 6.5715717740E+00, 5.2373312253E+00, 5.7891024998E-01, 4.8297722301E-01, 6.5762601323E-01],
	[1.4220000000E+04, 6.5747212716E+00, 5.2370066707E+00, 5.7955615018E-01, 4.8344097937E-01, 6.5776336777E-01],
	[1.4225000000E+04, 6.5778711706E+00, 5.2366822502E+00, 5.8020254317E-01, 4.8390495290E-01, 6.5790069139E-01],
	[1.4230000000E+04, 6.5810214709E+00, 5.2363579638E+00, 5.8084942912E-01, 4.8436914353E-01, 6.5803798409E-01],
	[1.4235000000E+04, 6.5841721724E+00, 5.2360338114E+00, 5.8149680826E-01, 4.8483355114E-01, 6.5817524585E-01],
	[1.4240000000E+04, 6.5873232751E+00, 5.2357097929E+00, 5.8214468078E-01, 4.8529817565E-01, 6.5831247665E-01],
	[1.4245000000E+04, 6.5904747788E+00, 5.2353859082E+00, 5.8279304689E-01, 4.8576301695E-01, 6.5844967649E-01],
	[1.4250000000E+04, 6.5936266835E+00, 5.2350621572E+00, 5.8344190678E-01, 4.8622807496E-01, 6.5858684535E-01],
	[1.4255000000E+04, 6.5967789891E+00, 5.2347385398E+00, 5.8409126065E-01, 4.8669334956E-01, 6.5872398321E-01],
	[1.4260000000E+04, 6.5999316954E+00, 5.2344150558E+00, 5.8474110872E-01, 4.8715884068E-01, 6.5886109006E-01],
	[1.4265000000E+04, 6.6030848024E+00, 5.2340917053E+00, 5.8539145118E-01, 4.8762454821E-01, 6.5899816589E-01],
	[1.4270000000E+04, 6.6062383101E+00, 5.2337684880E+00, 5.8604228823E-01, 4.8809047205E-01, 6.5913521068E-01],
	[1.4275000000E+04, 6.6093922182E+00, 5.2334454039E+00, 5.8669362008E-01, 4.8855661211E-01, 6.5927222442E-01],
	[1.4280000000E+04, 6.6125465268E+00, 5.2331224529E+00, 5.8734544692E-01, 4.8902296828E-01, 6.5940920710E-01],
	[1.4285000000E+04, 6.6157012357E+00, 5.2327996348E+00, 5.8799776897E-01, 4.8948954048E-01, 6.5954615871E-01],
	[1.4290000000E+04, 6.6188563449E+00, 5.2324769497E+00, 5.8865058642E-01, 4.8995632861E-01, 6.5968307921E-01],
	[1.4295000000E+04, 6.6220118542E+00, 5.2321543973E+00, 5.8930389948E-01, 4.9042333255E-01, 6.5981996858E-01],
	[1.4300000000E+04, 6.6251677636E+00, 5.2318319775E+00, 5.8995770834E-01, 4.9089055223E-01, 6.5995682681E-01],
	[1.4305000000E+04, 6.6283240730E+00, 5.2315096904E+00, 5.9061201321E-01, 4.9135798754E-01, 6.6009365387E-01],
	[1.4310000000E+04, 6.6314807822E+00, 5.2311875357E+00, 5.9126681429E-01, 4.9182563838E-01, 6.6023044976E-01],
	[1.4315000000E+04, 6.6346378913E+00, 5.2308655134E+00, 5.9192211179E-01, 4.9229350466E-01, 6.6036721445E-01],
	[1.4320000000E+04, 6.6377954001E+00, 5.2305436234E+00, 5.9257790590E-01, 4.9276158627E-01, 6.6050394793E-01],
	[1.4325000000E+04, 6.6409533085E+00, 5.2302218655E+00, 5.9323419683E-01, 4.9322988312E-01, 6.6064065017E-01],
	[1.4330000000E+04, 6.6441116164E+00, 5.2299002397E+00, 5.9389098479E-01, 4.9369839511E-01, 6.6077732117E-01],
	[1.4335000000E+04, 6.6472703237E+00, 5.2295787459E+00, 5.9454826996E-01, 4.9416712213E-01, 6.6091396090E-01],
	[1.4340000000E+04, 6.6504294305E+00, 5.2292573839E+00, 5.9520605256E-01, 4.9463606410E-01, 6.6105056934E-01],
	[1.4345000000E+04, 6.6535889364E+00, 5.2289361538E+00, 5.9586433279E-01, 4.9510522091E-01, 6.6118714648E-01],
	[1.4350000000E+04, 6.6567562095E+00, 5.2286196928E+00, 5.9652311085E-01, 4.9557467496E-01, 6.6132369230E-01],
	[1.4355000000E+04, 6.6599259006E+00, 5.2283046286E+00, 5.9718238694E-01, 4.9604436648E-01, 6.6146020679E-01],
	[1.4360000000E+04, 6.6630959964E+00, 5.2279896931E+00, 5.9784216126E-01, 4.9651427287E-01, 6.6159668992E-01],
	[1.4365000000E+04, 6.6662664967E+00, 5.2276748861E+00, 5.9850243403E-01, 4.9698439402E-01, 6.6173314168E-01],
	[1.4370000000E+04, 6.6694374015E+00, 5.2273602077E+00, 5.9916320543E-01, 4.9745472983E-01, 6.6186956205E-01],
	[1.4375000000E+04, 6.6726087107E+00, 5.2270456577E+00, 5.9982447567E-01, 4.9792528021E-01, 6.6200595102E-01],
	[1.4380000000E+04, 6.6757804242E+00, 5.2267312359E+00, 6.0048624496E-01, 4.9839604506E-01, 6.6214230857E-01],
	[1.4385000000E+04, 6.6789525419E+00, 5.2264169424E+00, 6.0114851349E-01, 4.9886702427E-01, 6.6227863467E-01],
	[1.4390000000E+04, 6.6821250637E+00, 5.2261027770E+00, 6.0181128147E-01, 4.9933821774E-01, 6.6241492932E-01],
	[1.4395000000E+04, 6.6852979895E+00, 5.2257887397E+00, 6.0247454911E-01, 4.9980962538E-01, 6.6255119250E-01],
	[1.4400000000E+04, 6.6884713193E+00, 5.2254748302E+00, 6.0313831660E-01, 5.0028124708E-01, 6.6268742418E-01],
	[1.4405000000E+04, 6.6916450529E+00, 5.2251610486E+00, 6.0380258414E-01, 5.0075308275E-01, 6.6282362436E-01],
	[1.4410000000E+04, 6.6948191902E+00, 5.2248473946E+00, 6.0446735194E-01, 5.0122513228E-01, 6.6295979302E-01],
	[1.4415000000E+04, 6.6979937313E+00, 5.2245338684E+00, 6.0513262021E-01, 5.0169739557E-01, 6.6309593013E-01],
	[1.4420000000E+04, 6.7011686759E+00, 5.2242204696E+00, 6.0579838914E-01, 5.0216987253E-01, 6.6323203568E-01],
	[1.4425000000E+04, 6.7043440241E+00, 5.2239071983E+00, 6.0646465893E-01, 5.0264256305E-01, 6.6336810967E-01],
	[1.4430000000E+04, 6.7075197756E+00, 5.2235940544E+00, 6.0713142979E-01, 5.0311546703E-01, 6.6350415206E-01],
	[1.4435000000E+04, 6.7106959304E+00, 5.2232810377E+00, 6.0779870193E-01, 5.0358858437E-01, 6.6364016284E-01],
	[1.4440000000E+04, 6.7138724885E+00, 5.2229681481E+00, 6.0846647554E-01, 5.0406191497E-01, 6.6377614199E-01],
	[1.4445000000E+04, 6.7170494498E+00, 5.2226553856E+00, 6.0913475082E-01, 5.0453545872E-01, 6.6391208951E-01],
	[1.4450000000E+04, 6.7202268140E+00, 5.2223427500E+00, 6.0980352798E-01, 5.0500921553E-01, 6.6404800537E-01],
	[1.4455000000E+04, 6.7234045813E+00, 5.2220302414E+00, 6.1047280723E-01, 5.0548318529E-01, 6.6418388955E-01],
	[1.4460000000E+04, 6.7265827514E+00, 5.2217178595E+00, 6.1114258876E-01, 5.0595736791E-01, 6.6431974205E-01],
	[1.4465000000E+04, 6.7297613243E+00, 5.2214056042E+00, 6.1181287277E-01, 5.0643176327E-01, 6.6445556283E-01],
	[1.4470000000E+04, 6.7329402999E+00, 5.2210934756E+00, 6.1248365948E-01, 5.0690637128E-01, 6.6459135190E-01],
	[1.4475000000E+04, 6.7361196781E+00, 5.2207814734E+00, 6.1315494907E-01, 5.0738119183E-01, 6.6472710922E-01],
	[1.4480000000E+04, 6.7392994588E+00, 5.2204695976E+00, 6.1382674177E-01, 5.0785622483E-01, 6.6486283479E-01],
	[1.4485000000E+04, 6.7424796420E+00, 5.2201578481E+00, 6.1449903775E-01, 5.0833147017E-01, 6.6499852858E-01],
	[1.4490000000E+04, 6.7456602275E+00, 5.2198462248E+00, 6.1517183724E-01, 5.0880692775E-01, 6.6513419059E-01],
	[1.4495000000E+04, 6.7488412153E+00, 5.2195347276E+00, 6.1584514043E-01, 5.0928259746E-01, 6.6526982079E-01],
	[1.4500000000E+04, 6.7520226052E+00, 5.2192233565E+00, 6.1651894753E-01, 5.0975847920E-01, 6.6540541917E-01],
	[1.4505000000E+04, 6.7552043973E+00, 5.2189121112E+00, 6.1719325873E-01, 5.1023457287E-01, 6.6554098571E-01],
	[1.4510000000E+04, 6.7583865913E+00, 5.2186009918E+00, 6.1786807425E-01, 5.1071087836E-01, 6.6567652040E-01],
	[1.4515000000E+04, 6.7615691872E+00, 5.2182899981E+00, 6.1854339427E-01, 5.1118739558E-01, 6.6581202322E-01],
	[1.4520000000E+04, 6.7647521850E+00, 5.2179791300E+00, 6.1921921902E-01, 5.1166412441E-01, 6.6594749416E-01],
	[1.4525000000E+04, 6.7679355845E+00, 5.2176683874E+00, 6.1989554868E-01, 5.1214106476E-01, 6.6608293319E-01],
	[1.4530000000E+04, 6.7711193856E+00, 5.2173577704E+00, 6.2057238346E-01, 5.1261821652E-01, 6.6621834031E-01],
	[1.4535000000E+04, 6.7743035883E+00, 5.2170472786E+00, 6.2124972357E-01, 5.1309557959E-01, 6.6635371549E-01],
	[1.4540000000E+04, 6.7774881925E+00, 5.2167369121E+00, 6.2192756920E-01, 5.1357315386E-01, 6.6648905873E-01],
	[1.4545000000E+04, 6.7806731980E+00, 5.2164266708E+00, 6.2260592056E-01, 5.1405093923E-01, 6.6662437000E-01],
	[1.4550000000E+04, 6.7838586048E+00, 5.2161165546E+00, 6.2328477786E-01, 5.1452893559E-01, 6.6675964929E-01],
	[1.4555000000E+04, 6.7870444129E+00, 5.2158065633E+00, 6.2396414129E-01, 5.1500714284E-01, 6.6689489658E-01],
	[1.4560000000E+04, 6.7902306220E+00, 5.2154966969E+00, 6.2464401106E-01, 5.1548556088E-01, 6.6703011186E-01],
	[1.4565000000E+04, 6.7934172322E+00, 5.2151869553E+00, 6.2532438737E-01, 5.1596418960E-01, 6.6716529512E-01],
	[1.4570000000E+04, 6.7966042434E+00, 5.2148773384E+00, 6.2600527042E-01, 5.1644302889E-01, 6.6730044633E-01],
	[1.4575000000E+04, 6.7997916554E+00, 5.2145678462E+00, 6.2668666042E-01, 5.1692207865E-01, 6.6743556548E-01],
	[1.4580000000E+04, 6.8029852994E+00, 5.2142619347E+00, 6.2736855757E-01, 5.1740140654E-01, 6.6757065256E-01],
	[1.4585000000E+04, 6.8061833198E+00, 5.2139584992E+00, 6.2805096207E-01, 5.1788099110E-01, 6.6770570754E-01],
	[1.4590000000E+04, 6.8093817466E+00, 5.2136551854E+00, 6.2873387413E-01, 5.1836078616E-01, 6.6784073042E-01],
	[1.4595000000E+04, 6.8125805798E+00, 5.2133519931E+00, 6.2941729394E-01, 5.1884079160E-01, 6.6797572118E-01],
	[1.4600000000E+04, 6.8157798192E+00, 5.2130489224E+00, 6.3010122172E-01, 5.1932100732E-01, 6.6811067981E-01],
	[1.4605000000E+04, 6.8189794648E+00, 5.2127459730E+00, 6.3078565766E-01, 5.1980143322E-01, 6.6824560628E-01],
	[1.4610000000E+04, 6.8221795165E+00, 5.2124431448E+00, 6.3147060196E-01, 5.2028206919E-01, 6.6838050059E-01],
	[1.4615000000E+04, 6.8253799742E+00, 5.2121404379E+00, 6.3215605484E-01, 5.2076291512E-01, 6.6851536271E-01],
	[1.4620000000E+04, 6.8285808378E+00, 5.2118378522E+00, 6.3284201649E-01, 5.2124397091E-01, 6.6865019264E-01],
	[1.4625000000E+04, 6.8317821073E+00, 5.2115353874E+00, 6.3352848711E-01, 5.2172523646E-01, 6.6878499035E-01],
	[1.4630000000E+04, 6.8349837824E+00, 5.2112330436E+00, 6.3421546691E-01, 5.2220671165E-01, 6.6891975584E-01],
	[1.4635000000E+04, 6.8381858632E+00, 5.2109308206E+00, 6.3490295609E-01, 5.2268839639E-01, 6.6905448908E-01],
	[1.4640000000E+04, 6.8413883496E+00, 5.2106287183E+00, 6.3559095486E-01, 5.2317029056E-01, 6.6918919007E-01],
	[1.4645000000E+04, 6.8445912415E+00, 5.2103267368E+00, 6.3627946341E-01, 5.2365239405E-01, 6.6932385878E-01],
	[1.4650000000E+04, 6.8477945387E+00, 5.2100248758E+00, 6.3696848196E-01, 5.2413470677E-01, 6.6945849520E-01],
	[1.4655000000E+04, 6.8509982412E+00, 5.2097231352E+00, 6.3765801070E-01, 5.2461722860E-01, 6.6959309932E-01],
	[1.4660000000E+04, 6.8542023490E+00, 5.2094215151E+00, 6.3834804983E-01, 5.2509995945E-01, 6.6972767112E-01],
	[1.4665000000E+04, 6.8574068619E+00, 5.2091200153E+00, 6.3903859956E-01, 5.2558289919E-01, 6.6986221059E-01],
	[1.4670000000E+04, 6.8606117798E+00, 5.2088186357E+00, 6.3972966010E-01, 5.2606604773E-01, 6.6999671771E-01],
	[1.4675000000E+04, 6.8638171026E+00, 5.2085173763E+00, 6.4042123164E-01, 5.2654940495E-01, 6.7013119247E-01],
	[1.4680000000E+04, 6.8670228304E+00, 5.2082162369E+00, 6.4111331439E-01, 5.2703297075E-01, 6.7026563485E-01],
	[1.4685000000E+04, 6.8702289629E+00, 5.2079152174E+00, 6.4180590855E-01, 5.2751674503E-01, 6.7040004484E-01],
	[1.4690000000E+04, 6.8734355001E+00, 5.2076143178E+00, 6.4249901433E-01, 5.2800072767E-01, 6.7053442242E-01],
	[1.4695000000E+04, 6.8766424419E+00, 5.2073135380E+00, 6.4319263192E-01, 5.2848491856E-01, 6.7066876759E-01],
	[1.4700000000E+04, 6.8798497882E+00, 5.2070128778E+00, 6.4388676154E-01, 5.2896931761E-01, 6.7080308031E-01],
	[1.4705000000E+04, 6.8830575390E+00, 5.2067123373E+00, 6.4458140338E-01, 5.2945392469E-01, 6.7093736058E-01],
	[1.4710000000E+04, 6.8862656941E+00, 5.2064119163E+00, 6.4527655765E-01, 5.2993873971E-01, 6.7107160839E-01],
	[1.4715000000E+04, 6.8894742534E+00, 5.2061116147E+00, 6.4597222454E-01, 5.3042376255E-01, 6.7120582372E-01],
	[1.4720000000E+04, 6.8926832170E+00, 5.2058114324E+00, 6.4666840427E-01, 5.3090899311E-01, 6.7134000655E-01],
	[1.4725000000E+04, 6.8958925846E+00, 5.2055113694E+00, 6.4736509704E-01, 5.3139443128E-01, 6.7147415687E-01],
	[1.4730000000E+04, 6.8991023562E+00, 5.2052114255E+00, 6.4806230305E-01, 5.3188007694E-01, 6.7160827467E-01],
	[1.4735000000E+04, 6.9023125317E+00, 5.2049116007E+00, 6.4876002250E-01, 5.3236592999E-01, 6.7174235994E-01],
	[1.4740000000E+04, 6.9055231111E+00, 5.2046118949E+00, 6.4945825560E-01, 5.3285199033E-01, 6.7187641265E-01],
	[1.4745000000E+04, 6.9087340942E+00, 5.2043123080E+00, 6.5015700254E-01, 5.3333825783E-01, 6.7201043279E-01],
	[1.4750000000E+04, 6.9119454810E+00, 5.2040128399E+00, 6.5085626354E-01, 5.3382473240E-01, 6.7214442036E-01],
	[1.4755000000E+04, 6.9151572713E+00, 5.2037134905E+00, 6.5155603880E-01, 5.3431141392E-01, 6.7227837532E-01],
	[1.4760000000E+04, 6.9183694651E+00, 5.2034142597E+00, 6.5225632851E-01, 5.3479830228E-01, 6.7241229768E-01],
	[1.4765000000E+04, 6.9215820623E+00, 5.2031151475E+00, 6.5295713289E-01, 5.3528539738E-01, 6.7254618742E-01],
	[1.4770000000E+04, 6.9247950628E+00, 5.2028161538E+00, 6.5365845213E-01, 5.3577269910E-01, 6.7268004452E-01],
	[1.4775000000E+04, 6.9280084666E+00, 5.2025172784E+00, 6.5436028644E-01, 5.3626020734E-01, 6.7281386896E-01],
	[1.4780000000E+04, 6.9312222734E+00, 5.2022185213E+00, 6.5506263602E-01, 5.3674792198E-01, 6.7294766075E-01],
	[1.4785000000E+04, 6.9344364834E+00, 5.2019198824E+00, 6.5576550108E-01, 5.3723584291E-01, 6.7308141985E-01],
	[1.4790000000E+04, 6.9376510963E+00, 5.2016213616E+00, 6.5646888182E-01, 5.3772397003E-01, 6.7321514625E-01],
	[1.4795000000E+04, 6.9408661121E+00, 5.2013229589E+00, 6.5717277844E-01, 5.3821230322E-01, 6.7334883995E-01],
	[1.4800000000E+04, 6.9440815306E+00, 5.2010246741E+00, 6.5787719115E-01, 5.3870084238E-01, 6.7348250093E-01],
	[1.4805000000E+04, 6.9472973519E+00, 5.2007265071E+00, 6.5858212014E-01, 5.3918958739E-01, 6.7361612918E-01],
	[1.4810000000E+04, 6.9505135758E+00, 5.2004284579E+00, 6.5928756563E-01, 5.3967853813E-01, 6.7374972467E-01],
	[1.4815000000E+04, 6.9537369619E+00, 5.2001343039E+00, 6.5999352781E-01, 5.4016777606E-01, 6.7388328740E-01],
	[1.4820000000E+04, 6.9569642246E+00, 5.1998422042E+00, 6.6070000689E-01, 5.4065726166E-01, 6.7401681735E-01],
	[1.4825000000E+04, 6.9601918957E+00, 5.1995502193E+00, 6.6140700308E-01, 5.4114695302E-01, 6.7415031452E-01],
	[1.4830000000E+04, 6.9634199752E+00, 5.1992583494E+00, 6.6211451657E-01, 5.4163685003E-01, 6.7428377888E-01],
	[1.4835000000E+04, 6.9666484629E+00, 5.1989665941E+00, 6.6282254756E-01, 5.4212695259E-01, 6.7441721042E-01],
	[1.4840000000E+04, 6.9698773587E+00, 5.1986749536E+00, 6.6353109628E-01, 5.4261726058E-01, 6.7455060913E-01],
	[1.4845000000E+04, 6.9731066625E+00, 5.1983834277E+00, 6.6424016290E-01, 5.4310777388E-01, 6.7468397499E-01],
	[1.4850000000E+04, 6.9763363743E+00, 5.1980920163E+00, 6.6494974765E-01, 5.4359849240E-01, 6.7481730800E-01],
	[1.4855000000E+04, 6.9795664940E+00, 5.1978007193E+00, 6.6565985072E-01, 5.4408941601E-01, 6.7495060813E-01],
	[1.4860000000E+04, 6.9827970215E+00, 5.1975095366E+00, 6.6637047232E-01, 5.4458054461E-01, 6.7508387538E-01],
	[1.4865000000E+04, 6.9860279567E+00, 5.1972184682E+00, 6.6708161264E-01, 5.4507187809E-01, 6.7521710973E-01],
	[1.4870000000E+04, 6.9892592995E+00, 5.1969275140E+00, 6.6779327190E-01, 5.4556341632E-01, 6.7535031117E-01],
	[1.4875000000E+04, 6.9924910499E+00, 5.1966366739E+00, 6.6850545030E-01, 5.4605515921E-01, 6.7548347968E-01],
	[1.4880000000E+04, 6.9957232077E+00, 5.1963459478E+00, 6.6921814804E-01, 5.4654710663E-01, 6.7561661525E-01],
	[1.4885000000E+04, 6.9989557728E+00, 5.1960553357E+00, 6.6993136532E-01, 5.4703925848E-01, 6.7574971787E-01],
	[1.4890000000E+04, 7.0021887453E+00, 5.1957648374E+00, 6.7064510235E-01, 5.4753161465E-01, 6.7588278752E-01],
	[1.4895000000E+04, 7.0054221249E+00, 5.1954744528E+00, 6.7135935933E-01, 5.4802417501E-01, 6.7601582420E-01],
	[1.4900000000E+04, 7.0086559117E+00, 5.1951841820E+00, 6.7207413646E-01, 5.4851693946E-01, 6.7614882788E-01],
	[1.4905000000E+04, 7.0118901054E+00, 5.1948940247E+00, 6.7278943396E-01, 5.4900990789E-01, 6.7628179856E-01],
	[1.4910000000E+04, 7.0151247061E+00, 5.1946039809E+00, 6.7350525201E-01, 5.4950308018E-01, 6.7641473622E-01],
	[1.4915000000E+04, 7.0183597137E+00, 5.1943140506E+00, 6.7422159083E-01, 5.4999645622E-01, 6.7654764085E-01],
	[1.4920000000E+04, 7.0215951280E+00, 5.1940242336E+00, 6.7493845062E-01, 5.5049003590E-01, 6.7668051243E-01],
	[1.4925000000E+04, 7.0248309490E+00, 5.1937345300E+00, 6.7565583158E-01, 5.5098381910E-01, 6.7681335095E-01],
	[1.4930000000E+04, 7.0280671766E+00, 5.1934449394E+00, 6.7637373392E-01, 5.5147780571E-01, 6.7694615641E-01],
	[1.4935000000E+04, 7.0313038107E+00, 5.1931554620E+00, 6.7709215783E-01, 5.5197199562E-01, 6.7707892878E-01],
	[1.4940000000E+04, 7.0345408512E+00, 5.1928660977E+00, 6.7781110353E-01, 5.5246638871E-01, 6.7721166805E-01],
	[1.4945000000E+04, 7.0377782981E+00, 5.1925768462E+00, 6.7853057122E-01, 5.5296098487E-01, 6.7734437422E-01],
	[1.4950000000E+04, 7.0410161512E+00, 5.1922877076E+00, 6.7925056110E-01, 5.5345578398E-01, 6.7747704726E-01],
	[1.4955000000E+04, 7.0442544105E+00, 5.1919986818E+00, 6.7997107337E-01, 5.5395078594E-01, 6.7760968717E-01],
	[1.4960000000E+04, 7.0474930759E+00, 5.1917097687E+00, 6.8069210824E-01, 5.5444599062E-01, 6.7774229393E-01],
	[1.4965000000E+04, 7.0507321473E+00, 5.1914209682E+00, 6.8141366591E-01, 5.5494139792E-01, 6.7787486753E-01],
	[1.4970000000E+04, 7.0539716246E+00, 5.1911322803E+00, 6.8213574659E-01, 5.5543700771E-01, 6.7800740796E-01],
	[1.4975000000E+04, 7.0572115078E+00, 5.1908437048E+00, 6.8285835048E-01, 5.5593281989E-01, 6.7813991520E-01],
	[1.4980000000E+04, 7.0604517966E+00, 5.1905552416E+00, 6.8358147778E-01, 5.5642883434E-01, 6.7827238924E-01],
	[1.4985000000E+04, 7.0636924912E+00, 5.1902668908E+00, 6.8430512869E-01, 5.5692505094E-01, 6.7840483008E-01],
	[1.4990000000E+04, 7.0669335913E+00, 5.1899786521E+00, 6.8502930343E-01, 5.5742146958E-01, 6.7853723769E-01],
	[1.4995000000E+04, 7.0701750969E+00, 5.1896905256E+00, 6.8575400219E-01, 5.5791809015E-01, 6.7866961206E-01],
	[1.5000000000E+04, 7.0734170079E+00, 5.1894025112E+00, 6.8647922518E-01, 5.5841491252E-01, 6.7880195318E-01],
	[1.5005000000E+04, 7.0766593243E+00, 5.1891146087E+00, 6.8720731523E-01, 5.5891348618E-01, 6.7893426105E-01],
	[1.5010000000E+04, 7.0799020459E+00, 5.1888268180E+00, 6.8793593414E-01, 5.5941226318E-01, 6.7906653564E-01],
	[1.5015000000E+04, 7.0831451726E+00, 5.1885391392E+00, 6.8866508213E-01, 5.5991124341E-01, 6.7919877694E-01],
	[1.5020000000E+04, 7.0863887044E+00, 5.1882515721E+00, 6.8939475941E-01, 5.6041042674E-01, 6.7933098495E-01],
	[1.5025000000E+04, 7.0896326412E+00, 5.1879641167E+00, 6.9012496617E-01, 5.6090981306E-01, 6.7946315964E-01],
	[1.5030000000E+04, 7.0928769829E+00, 5.1876767728E+00, 6.9085570264E-01, 5.6140940226E-01, 6.7959530102E-01],
	[1.5035000000E+04, 7.0961217295E+00, 5.1873895404E+00, 6.9158696901E-01, 5.6190919422E-01, 6.7972740905E-01],
	[1.5040000000E+04, 7.0993668807E+00, 5.1871024194E+00, 6.9231876549E-01, 5.6240918882E-01, 6.7985948375E-01],
	[1.5045000000E+04, 7.1026124366E+00, 5.1868154097E+00, 6.9305109230E-01, 5.6290938595E-01, 6.7999152508E-01],
	[1.5050000000E+04, 7.1058583971E+00, 5.1865285113E+00, 6.9378394963E-01, 5.6340978548E-01, 6.8012353304E-01],
	[1.5055000000E+04, 7.1091151248E+00, 5.1862471906E+00, 6.9451733770E-01, 5.6391051714E-01, 6.8025550762E-01],
	[1.5060000000E+04, 7.1123725702E+00, 5.1859661407E+00, 6.9525125671E-01, 5.6441145519E-01, 6.8038744880E-01],
	[1.5065000000E+04, 7.1156304261E+00, 5.1856851993E+00, 6.9598570688E-01, 5.6491259567E-01, 6.8051935656E-01],
	[1.5070000000E+04, 7.1188886925E+00, 5.1854043663E+00, 6.9672068840E-01, 5.6541393847E-01, 6.8065123089E-01],
	[1.5075000000E+04, 7.1221473693E+00, 5.1851236417E+00, 6.9745620148E-01, 5.6591548347E-01, 6.8078307177E-01],
	[1.5080000000E+04, 7.1254064563E+00, 5.1848430254E+00, 6.9819224634E-01, 5.6641723055E-01, 6.8091487918E-01],
	[1.5085000000E+04, 7.1286659535E+00, 5.1845625173E+00, 6.9892882318E-01, 5.6691917959E-01, 6.8104665312E-01],
	[1.5090000000E+04, 7.1319258609E+00, 5.1842821173E+00, 6.9966593221E-01, 5.6742133048E-01, 6.8117839356E-01],
	[1.5095000000E+04, 7.1351861782E+00, 5.1840018253E+00, 7.0040357363E-01, 5.6792368310E-01, 6.8131010050E-01],
	[1.5100000000E+04, 7.1384469055E+00, 5.1837216414E+00, 7.0114174766E-01, 5.6842623733E-01, 6.8144177391E-01],
	[1.5105000000E+04, 7.1417080427E+00, 5.1834415653E+00, 7.0188045450E-01, 5.6892899305E-01, 6.8157341378E-01],
	[1.5110000000E+04, 7.1449695896E+00, 5.1831615970E+00, 7.0261969436E-01, 5.6943195014E-01, 6.8170502010E-01],
	[1.5115000000E+04, 7.1482315462E+00, 5.1828817365E+00, 7.0335946744E-01, 5.6993510849E-01, 6.8183659285E-01],
	[1.5120000000E+04, 7.1514939124E+00, 5.1826019837E+00, 7.0409977396E-01, 5.7043846798E-01, 6.8196813202E-01],
	[1.5125000000E+04, 7.1547566881E+00, 5.1823223384E+00, 7.0484061411E-01, 5.7094202849E-01, 6.8209963760E-01],
	[1.5130000000E+04, 7.1580198733E+00, 5.1820428007E+00, 7.0558198812E-01, 5.7144578990E-01, 6.8223110956E-01],
	[1.5135000000E+04, 7.1612834678E+00, 5.1817633704E+00, 7.0632389618E-01, 5.7194975210E-01, 6.8236254790E-01],
	[1.5140000000E+04, 7.1645474716E+00, 5.1814840474E+00, 7.0706633851E-01, 5.7245391496E-01, 6.8249395259E-01],
	[1.5145000000E+04, 7.1678118846E+00, 5.1812048317E+00, 7.0780931531E-01, 5.7295827836E-01, 6.8262532363E-01],
	[1.5150000000E+04, 7.1710767067E+00, 5.1809257233E+00, 7.0855282679E-01, 5.7346284219E-01, 6.8275666100E-01],
	[1.5155000000E+04, 7.1743419377E+00, 5.1806467219E+00, 7.0929687315E-01, 5.7396760632E-01, 6.8288796469E-01],
	[1.5160000000E+04, 7.1776075778E+00, 5.1803678276E+00, 7.1004145462E-01, 5.7447257064E-01, 6.8301923467E-01],
	[1.5165000000E+04, 7.1808736266E+00, 5.1800890403E+00, 7.1078657138E-01, 5.7497773503E-01, 6.8315047095E-01],
	[1.5170000000E+04, 7.1841400843E+00, 5.1798103599E+00, 7.1153222365E-01, 5.7548309937E-01, 6.8328167350E-01],
	[1.5175000000E+04, 7.1874069506E+00, 5.1795317863E+00, 7.1227841165E-01, 5.7598866354E-01, 6.8341284230E-01],
	[1.5180000000E+04, 7.1906742255E+00, 5.1792533195E+00, 7.1302513556E-01, 5.7649442741E-01, 6.8354397736E-01],
	[1.5185000000E+04, 7.1939419089E+00, 5.1789749593E+00, 7.1377239562E-01, 5.7700039087E-01, 6.8367507864E-01],
	[1.5190000000E+04, 7.1972100008E+00, 5.1786967057E+00, 7.1452019201E-01, 5.7750655381E-01, 6.8380614614E-01],
	[1.5195000000E+04, 7.2004785010E+00, 5.1784185587E+00, 7.1526852495E-01, 5.7801291609E-01, 6.8393717984E-01],
	[1.5200000000E+04, 7.2037474095E+00, 5.1781405180E+00, 7.1601739465E-01, 5.7851947760E-01, 6.8406817972E-01],
	[1.5205000000E+04, 7.2070167261E+00, 5.1778625838E+00, 7.1676680131E-01, 5.7902623822E-01, 6.8419914578E-01],
	[1.5210000000E+04, 7.2102864509E+00, 5.1775847558E+00, 7.1751674515E-01, 5.7953319782E-01, 6.8433007801E-01],
	[1.5215000000E+04, 7.2135565836E+00, 5.1773070341E+00, 7.1826722637E-01, 5.8004035629E-01, 6.8446097637E-01],
	[1.5220000000E+04, 7.2168271243E+00, 5.1770294185E+00, 7.1901824517E-01, 5.8054771351E-01, 6.8459184087E-01],
	[1.5225000000E+04, 7.2200980729E+00, 5.1767519089E+00, 7.1976980178E-01, 5.8105526935E-01, 6.8472267149E-01],
	[1.5230000000E+04, 7.2233694292E+00, 5.1764745054E+00, 7.2052189638E-01, 5.8156302370E-01, 6.8485346821E-01],
	[1.5235000000E+04, 7.2266411932E+00, 5.1761972077E+00, 7.2127452920E-01, 5.8207097643E-01, 6.8498423103E-01],
	[1.5240000000E+04, 7.2299133647E+00, 5.1759200159E+00, 7.2202770044E-01, 5.8257912742E-01, 6.8511495992E-01],
	[1.5245000000E+04, 7.2331859439E+00, 5.1756429299E+00, 7.2278141030E-01, 5.8308747655E-01, 6.8524565487E-01],
	[1.5250000000E+04, 7.2364589304E+00, 5.1753659496E+00, 7.2353565900E-01, 5.8359602370E-01, 6.8537631587E-01],
	[1.5255000000E+04, 7.2397323243E+00, 5.1750890748E+00, 7.2429044675E-01, 5.8410476875E-01, 6.8550694291E-01],
	[1.5260000000E+04, 7.2430061254E+00, 5.1748123056E+00, 7.2504577374E-01, 5.8461371157E-01, 6.8563753597E-01],
	[1.5265000000E+04, 7.2462803338E+00, 5.1745356419E+00, 7.2580164020E-01, 5.8512285205E-01, 6.8576809504E-01],
	[1.5270000000E+04, 7.2495549492E+00, 5.1742590836E+00, 7.2655804632E-01, 5.8563219006E-01, 6.8589862010E-01],
	[1.5275000000E+04, 7.2528299717E+00, 5.1739826306E+00, 7.2731499232E-01, 5.8614172548E-01, 6.8602911115E-01],
	[1.5280000000E+04, 7.2561054011E+00, 5.1737062828E+00, 7.2807247840E-01, 5.8665145818E-01, 6.8615956816E-01],
	[1.5285000000E+04, 7.2593812373E+00, 5.1734300402E+00, 7.2883050477E-01, 5.8716138805E-01, 6.8628999113E-01],
	[1.5290000000E+04, 7.2626574803E+00, 5.1731539026E+00, 7.2958907164E-01, 5.8767151496E-01, 6.8642038004E-01],
	[1.5295000000E+04, 7.2659398504E+00, 5.1728807238E+00, 7.3034817922E-01, 5.8818191317E-01, 6.8655073488E-01],
	[1.5300000000E+04, 7.2692280441E+00, 5.1726103479E+00, 7.3110782772E-01, 5.8869257886E-01, 6.8668105563E-01],
	[1.5305000000E+04, 7.2725166508E+00, 5.1723400746E+00, 7.3186801734E-01, 5.8920344161E-01, 6.8681134228E-01],
	[1.5310000000E+04, 7.2758056703E+00, 5.1720699036E+00, 7.3262874829E-01, 5.8971450131E-01, 6.8694159482E-01],
	[1.5315000000E+04, 7.2790951026E+00, 5.1717998350E+00, 7.3339002078E-01, 5.9022575784E-01, 6.8707181324E-01],
	[1.5320000000E+04, 7.2823849475E+00, 5.1715298686E+00, 7.3415183501E-01, 5.9073721107E-01, 6.8720199752E-01],
	[1.5325000000E+04, 7.2856752051E+00, 5.1712600044E+00, 7.3491419121E-01, 5.9124886089E-01, 6.8733214765E-01],
	[1.5330000000E+04, 7.2889658752E+00, 5.1709902423E+00, 7.3567708956E-01, 5.9176070716E-01, 6.8746226361E-01],
	[1.5335000000E+04, 7.2922569578E+00, 5.1707205822E+00, 7.3644053029E-01, 5.9227274977E-01, 6.8759234539E-01],
	[1.5340000000E+04, 7.2955484527E+00, 5.1704510241E+00, 7.3720451360E-01, 5.9278498859E-01, 6.8772239299E-01],
	[1.5345000000E+04, 7.2988403599E+00, 5.1701815679E+00, 7.3796903970E-01, 5.9329742350E-01, 6.8785240638E-01],
	[1.5350000000E+04, 7.3021326793E+00, 5.1699122135E+00, 7.3873410879E-01, 5.9381005438E-01, 6.8798238555E-01],
	[1.5355000000E+04, 7.3054254108E+00, 5.1696429609E+00, 7.3949972109E-01, 5.9432288110E-01, 6.8811233050E-01],
	[1.5360000000E+04, 7.3087185543E+00, 5.1693738099E+00, 7.4026587680E-01, 5.9483590353E-01, 6.8824224120E-01],
	[1.5365000000E+04, 7.3120121098E+00, 5.1691047606E+00, 7.4103257613E-01, 5.9534912157E-01, 6.8837211765E-01],
	[1.5370000000E+04, 7.3153060772E+00, 5.1688358128E+00, 7.4179981929E-01, 5.9586253507E-01, 6.8850195983E-01],
	[1.5375000000E+04, 7.3186004563E+00, 5.1685669664E+00, 7.4256760648E-01, 5.9637614392E-01, 6.8863176773E-01],
	[1.5380000000E+04, 7.3218952471E+00, 5.1682982214E+00, 7.4333593793E-01, 5.9688994799E-01, 6.8876154134E-01],
	[1.5385000000E+04, 7.3251904496E+00, 5.1680295778E+00, 7.4410481382E-01, 5.9740394716E-01, 6.8889128064E-01],
	[1.5390000000E+04, 7.3284860636E+00, 5.1677610354E+00, 7.4487423438E-01, 5.9791814131E-01, 6.8902098562E-01],
	[1.5395000000E+04, 7.3317820890E+00, 5.1674925942E+00, 7.4564419981E-01, 5.9843253031E-01, 6.8915065627E-01],
	[1.5400000000E+04, 7.3350785258E+00, 5.1672242541E+00, 7.4641471032E-01, 5.9894711403E-01, 6.8928029258E-01],
	[1.5405000000E+04, 7.3383753739E+00, 5.1669560150E+00, 7.4718576611E-01, 5.9946189235E-01, 6.8940989453E-01],
	[1.5410000000E+04, 7.3416726332E+00, 5.1666878769E+00, 7.4795736740E-01, 5.9997686515E-01, 6.8953946211E-01],
	[1.5415000000E+04, 7.3449703037E+00, 5.1664198397E+00, 7.4872951439E-01, 6.0049203230E-01, 6.8966899531E-01],
	[1.5420000000E+04, 7.3482683851E+00, 5.1661519033E+00, 7.4950220729E-01, 6.0100739368E-01, 6.8979849412E-01],
	[1.5425000000E+04, 7.3515668776E+00, 5.1658840677E+00, 7.5027544632E-01, 6.0152294915E-01, 6.8992795852E-01],
	[1.5430000000E+04, 7.3548657809E+00, 5.1656163328E+00, 7.5104923167E-01, 6.0203869861E-01, 6.9005738851E-01],
	[1.5435000000E+04, 7.3581650950E+00, 5.1653486984E+00, 7.5182356356E-01, 6.0255464191E-01, 6.9018678406E-01],
	[1.5440000000E+04, 7.3614648198E+00, 5.1650811646E+00, 7.5259844219E-01, 6.0307077894E-01, 6.9031614517E-01],
	[1.5445000000E+04, 7.3647649553E+00, 5.1648137313E+00, 7.5337386778E-01, 6.0358710957E-01, 6.9044547182E-01],
	[1.5450000000E+04, 7.3680655013E+00, 5.1645463984E+00, 7.5414984053E-01, 6.0410363367E-01, 6.9057476401E-01],
	[1.5455000000E+04, 7.3713664577E+00, 5.1642791658E+00, 7.5492636065E-01, 6.0462035112E-01, 6.9070402172E-01],
	[1.5460000000E+04, 7.3746678246E+00, 5.1640120335E+00, 7.5570342834E-01, 6.0513726179E-01, 6.9083324493E-01],
	[1.5465000000E+04, 7.3779696018E+00, 5.1637450014E+00, 7.5648104383E-01, 6.0565436556E-01, 6.9096243365E-01],
	[1.5470000000E+04, 7.3812717891E+00, 5.1634780694E+00, 7.5725920731E-01, 6.0617166230E-01, 6.9109158784E-01],
	[1.5475000000E+04, 7.3845743867E+00, 5.1632112374E+00, 7.5803791899E-01, 6.0668915188E-01, 6.9122070751E-01],
	[1.5480000000E+04, 7.3878773943E+00, 5.1629445055E+00, 7.5881717909E-01, 6.0720683418E-01, 6.9134979264E-01],
	[1.5485000000E+04, 7.3911808118E+00, 5.1626778734E+00, 7.5959698780E-01, 6.0772470907E-01, 6.9147884322E-01],
	[1.5490000000E+04, 7.3944846393E+00, 5.1624113412E+00, 7.6037734535E-01, 6.0824277642E-01, 6.9160785924E-01],
	[1.5495000000E+04, 7.3977888766E+00, 5.1621449087E+00, 7.6115825193E-01, 6.0876103611E-01, 6.9173684067E-01],
	[1.5500000000E+04, 7.4010935236E+00, 5.1618785760E+00, 7.6193970776E-01, 6.0927948801E-01, 6.9186578753E-01],
	[1.5505000000E+04, 7.4043985803E+00, 5.1616123429E+00, 7.6272171304E-01, 6.0979813200E-01, 6.9199469978E-01],
	[1.5510000000E+04, 7.4077040465E+00, 5.1613462094E+00, 7.6350426799E-01, 6.1031696794E-01, 6.9212357742E-01],
	[1.5515000000E+04, 7.4110099222E+00, 5.1610801753E+00, 7.6428737281E-01, 6.1083599571E-01, 6.9225242044E-01],
	[1.5520000000E+04, 7.4143162074E+00, 5.1608142407E+00, 7.6507102771E-01, 6.1135521518E-01, 6.9238122882E-01],
	[1.5525000000E+04, 7.4176229018E+00, 5.1605484054E+00, 7.6585523290E-01, 6.1187462623E-01, 6.9251000256E-01],
	[1.5530000000E+04, 7.4209300055E+00, 5.1602826695E+00, 7.6663998858E-01, 6.1239422872E-01, 6.9263874164E-01],
	[1.5535000000E+04, 7.4242375184E+00, 5.1600170327E+00, 7.6742529497E-01, 6.1291402253E-01, 6.9276744606E-01],
	[1.5540000000E+04, 7.4275486476E+00, 5.1597530098E+00, 7.6821115228E-01, 6.1343405082E-01, 6.9289611579E-01],
	[1.5545000000E+04, 7.4308685870E+00, 5.1594930504E+00, 7.6899756071E-01, 6.1395438378E-01, 6.9302475083E-01],
	[1.5550000000E+04, 7.4341889421E+00, 5.1592331876E+00, 7.6978452047E-01, 6.1447490808E-01, 6.9315335116E-01],
	[1.5555000000E+04, 7.4375097126E+00, 5.1589734214E+00, 7.7057203177E-01, 6.1499562362E-01, 6.9328191678E-01],
	[1.5560000000E+04, 7.4408308984E+00, 5.1587137519E+00, 7.7136009482E-01, 6.1551653025E-01, 6.9341044768E-01],
	[1.5565000000E+04, 7.4441524996E+00, 5.1584541788E+00, 7.7214870982E-01, 6.1603762785E-01, 6.9353894384E-01],
	[1.5570000000E+04, 7.4474745160E+00, 5.1581947021E+00, 7.7293787700E-01, 6.1655891630E-01, 6.9366740524E-01],
	[1.5575000000E+04, 7.4507969475E+00, 5.1579353218E+00, 7.7372759655E-01, 6.1708039546E-01, 6.9379583189E-01],
	[1.5580000000E+04, 7.4541197941E+00, 5.1576760378E+00, 7.7451786868E-01, 6.1760206521E-01, 6.9392422377E-01],
	[1.5585000000E+04, 7.4574430556E+00, 5.1574168500E+00, 7.7530869360E-01, 6.1812392542E-01, 6.9405258086E-01],
	[1.5590000000E+04, 7.4607667320E+00, 5.1571577583E+00, 7.7610007153E-01, 6.1864597596E-01, 6.9418090316E-01],
	[1.5595000000E+04, 7.4640908233E+00, 5.1568987628E+00, 7.7689200267E-01, 6.1916821671E-01, 6.9430919065E-01],
	[1.5600000000E+04, 7.4674153292E+00, 5.1566398633E+00, 7.7768448722E-01, 6.1969064752E-01, 6.9443744333E-01],
	[1.5605000000E+04, 7.4707402499E+00, 5.1563810597E+00, 7.7847752540E-01, 6.2021326829E-01, 6.9456566117E-01],
	[1.5610000000E+04, 7.4740655850E+00, 5.1561223521E+00, 7.7927111742E-01, 6.2073607887E-01, 6.9469384418E-01],
	[1.5615000000E+04, 7.4773913347E+00, 5.1558637402E+00, 7.8006526348E-01, 6.2125907913E-01, 6.9482199235E-01],
	[1.5620000000E+04, 7.4807174988E+00, 5.1556052241E+00, 7.8085996379E-01, 6.2178226896E-01, 6.9495010565E-01],
	[1.5625000000E+04, 7.4840440772E+00, 5.1553468037E+00, 7.8165521857E-01, 6.2230564821E-01, 6.9507818408E-01],
	[1.5630000000E+04, 7.4873710698E+00, 5.1550884790E+00, 7.8245102802E-01, 6.2282921676E-01, 6.9520622762E-01],
	[1.5635000000E+04, 7.4906984766E+00, 5.1548302498E+00, 7.8324739235E-01, 6.2335297449E-01, 6.9533423628E-01],
	[1.5640000000E+04, 7.4940262975E+00, 5.1545721161E+00, 7.8404431177E-01, 6.2387692126E-01, 6.9546221002E-01],
	[1.5645000000E+04, 7.4973545324E+00, 5.1543140778E+00, 7.8484178648E-01, 6.2440105693E-01, 6.9559014886E-01],
	[1.5650000000E+04, 7.5006831812E+00, 5.1540561349E+00, 7.8563981670E-01, 6.2492538140E-01, 6.9571805277E-01],
	[1.5655000000E+04, 7.5040122438E+00, 5.1537982873E+00, 7.8643840264E-01, 6.2544989451E-01, 6.9584592174E-01],
	[1.5660000000E+04, 7.5073417202E+00, 5.1535405349E+00, 7.8723754450E-01, 6.2597459614E-01, 6.9597375577E-01],
	[1.5665000000E+04, 7.5106716102E+00, 5.1532828777E+00, 7.8803724249E-01, 6.2649948617E-01, 6.9610155483E-01],
	[1.5670000000E+04, 7.5140019139E+00, 5.1530253156E+00, 7.8883749683E-01, 6.2702456446E-01, 6.9622931893E-01],
	[1.5675000000E+04, 7.5173326311E+00, 5.1527678486E+00, 7.8963830771E-01, 6.2754983089E-01, 6.9635704805E-01],
	[1.5680000000E+04, 7.5206637617E+00, 5.1525104765E+00, 7.9043967536E-01, 6.2807528531E-01, 6.9648474218E-01],
	[1.5685000000E+04, 7.5239953056E+00, 5.1522531993E+00, 7.9124159997E-01, 6.2860092761E-01, 6.9661240132E-01],
	[1.5690000000E+04, 7.5273272629E+00, 5.1519960170E+00, 7.9204408176E-01, 6.2912675765E-01, 6.9674002544E-01],
	[1.5695000000E+04, 7.5306596333E+00, 5.1517389294E+00, 7.9284712094E-01, 6.2965277530E-01, 6.9686761454E-01],
	[1.5700000000E+04, 7.5339924168E+00, 5.1514819365E+00, 7.9365071772E-01, 6.3017898042E-01, 6.9699516860E-01],
	[1.5705000000E+04, 7.5373256134E+00, 5.1512250383E+00, 7.9445487229E-01, 6.3070537290E-01, 6.9712268763E-01],
	[1.5710000000E+04, 7.5406592229E+00, 5.1509682347E+00, 7.9525958488E-01, 6.3123195260E-01, 6.9725017161E-01],
	[1.5715000000E+04, 7.5439932453E+00, 5.1507115256E+00, 7.9606485570E-01, 6.3175871938E-01, 6.9737762052E-01],
	[1.5720000000E+04, 7.5473276805E+00, 5.1504549109E+00, 7.9687068494E-01, 6.3228567311E-01, 6.9750503436E-01],
	[1.5725000000E+04, 7.5506625284E+00, 5.1501983906E+00, 7.9767707283E-01, 6.3281281368E-01, 6.9763241311E-01],
	[1.5730000000E+04, 7.5539977889E+00, 5.1499419647E+00, 7.9848401956E-01, 6.3334014093E-01, 6.9775975678E-01],
	[1.5735000000E+04, 7.5573334620E+00, 5.1496856330E+00, 7.9929152535E-01, 6.3386765475E-01, 6.9788706534E-01],
	[1.5740000000E+04, 7.5606695476E+00, 5.1494293955E+00, 8.0009959041E-01, 6.3439535499E-01, 6.9801433878E-01],
	[1.5745000000E+04, 7.5640060455E+00, 5.1491732521E+00, 8.0090821495E-01, 6.3492324154E-01, 6.9814157711E-01],
	[1.5750000000E+04, 7.5673429557E+00, 5.1489172028E+00, 8.0171739917E-01, 6.3545131425E-01, 6.9826878030E-01],
	[1.5755000000E+04, 7.5706802782E+00, 5.1486612474E+00, 8.0252714329E-01, 6.3597957299E-01, 6.9839594834E-01],
	[1.5760000000E+04, 7.5740180128E+00, 5.1484053861E+00, 8.0333744751E-01, 6.3650801764E-01, 6.9852308124E-01],
	[1.5765000000E+04, 7.5773561595E+00, 5.1481496185E+00, 8.0414831204E-01, 6.3703664806E-01, 6.9865017896E-01],
	[1.5770000000E+04, 7.5806947182E+00, 5.1478939448E+00, 8.0495973710E-01, 6.3756546411E-01, 6.9877724152E-01],
	[1.5775000000E+04, 7.5840336888E+00, 5.1476383649E+00, 8.0577172288E-01, 6.3809446567E-01, 6.9890426889E-01],
	[1.5780000000E+04, 7.5873730712E+00, 5.1473828786E+00, 8.0658426961E-01, 6.3862365261E-01, 6.9903126107E-01],
	[1.5785000000E+04, 7.5907128654E+00, 5.1471274859E+00, 8.0739737749E-01, 6.3915302478E-01, 6.9915821805E-01],
	[1.5790000000E+04, 7.5940560468E+00, 5.1468735187E+00, 8.0821104672E-01, 6.3968262375E-01, 6.9928513981E-01],
	[1.5795000000E+04, 7.5974087516E+00, 5.1466237200E+00, 8.0902527752E-01, 6.4021253556E-01, 6.9941202635E-01],
	[1.5800000000E+04, 7.6007618747E+00, 5.1463740125E+00, 8.0984007010E-01, 6.4074263265E-01, 6.9953887765E-01],
	[1.5805000000E+04, 7.6041154160E+00, 5.1461243962E+00, 8.1065542467E-01, 6.4127291490E-01, 6.9966569370E-01],
	[1.5810000000E+04, 7.6074693755E+00, 5.1458748709E+00, 8.1147134143E-01, 6.4180338216E-01, 6.9979247448E-01],
	[1.5815000000E+04, 7.6108237531E+00, 5.1456254366E+00, 8.1228782059E-01, 6.4233403430E-01, 6.9991921999E-01],
	[1.5820000000E+04, 7.6141785487E+00, 5.1453760932E+00, 8.1310486237E-01, 6.4286487120E-01, 7.0004593021E-01],
	[1.5825000000E+04, 7.6175337622E+00, 5.1451268407E+00, 8.1392246697E-01, 6.4339589272E-01, 7.0017260514E-01],
	[1.5830000000E+04, 7.6208893936E+00, 5.1448776790E+00, 8.1474063460E-01, 6.4392709872E-01, 7.0029924475E-01],
	[1.5835000000E+04, 7.6242454428E+00, 5.1446286081E+00, 8.1555936548E-01, 6.4445848908E-01, 7.0042584904E-01],
	[1.5840000000E+04, 7.6276019097E+00, 5.1443796278E+00, 8.1637865980E-01, 6.4499006366E-01, 7.0055241800E-01],
	[1.5845000000E+04, 7.6309587942E+00, 5.1441307382E+00, 8.1719851779E-01, 6.4552182233E-01, 7.0067895160E-01],
	[1.5850000000E+04, 7.6343160962E+00, 5.1438819391E+00, 8.1801893964E-01, 6.4605376495E-01, 7.0080544985E-01],
	[1.5855000000E+04, 7.6376738156E+00, 5.1436332305E+00, 8.1883992558E-01, 6.4658589138E-01, 7.0093191273E-01],
	[1.5860000000E+04, 7.6410319525E+00, 5.1433846124E+00, 8.1966147580E-01, 6.4711820151E-01, 7.0105834023E-01],
	[1.5865000000E+04, 7.6443905066E+00, 5.1431360846E+00, 8.2048359052E-01, 6.4765069519E-01, 7.0118473233E-01],
	[1.5870000000E+04, 7.6477494780E+00, 5.1428876472E+00, 8.2130626994E-01, 6.4818337229E-01, 7.0131108903E-01],
	[1.5875000000E+04, 7.6511088665E+00, 5.1426393000E+00, 8.2212951428E-01, 6.4871623267E-01, 7.0143741032E-01],
	[1.5880000000E+04, 7.6544686720E+00, 5.1423910430E+00, 8.2295332375E-01, 6.4924927620E-01, 7.0156369617E-01],
	[1.5885000000E+04, 7.6578288945E+00, 5.1421428762E+00, 8.2377769855E-01, 6.4978250275E-01, 7.0168994658E-01],
	[1.5890000000E+04, 7.6611895340E+00, 5.1418947994E+00, 8.2460263890E-01, 6.5031591219E-01, 7.0181616155E-01],
	[1.5895000000E+04, 7.6645505902E+00, 5.1416468126E+00, 8.2542814499E-01, 6.5084950437E-01, 7.0194234105E-01],
	[1.5900000000E+04, 7.6679120632E+00, 5.1413989158E+00, 8.2625421706E-01, 6.5138327917E-01, 7.0206848508E-01],
	[1.5905000000E+04, 7.6712739528E+00, 5.1411511089E+00, 8.2708085529E-01, 6.5191723645E-01, 7.0219459362E-01],
	[1.5910000000E+04, 7.6746362590E+00, 5.1409033918E+00, 8.2790805990E-01, 6.5245137607E-01, 7.0232066666E-01],
	[1.5915000000E+04, 7.6779989817E+00, 5.1406557644E+00, 8.2873583111E-01, 6.5298569790E-01, 7.0244670420E-01],
	[1.5920000000E+04, 7.6813621209E+00, 5.1404082268E+00, 8.2956416912E-01, 6.5352020181E-01, 7.0257270622E-01],
	[1.5925000000E+04, 7.6847256764E+00, 5.1401607788E+00, 8.3039307414E-01, 6.5405488766E-01, 7.0269867270E-01],
	[1.5930000000E+04, 7.6880896481E+00, 5.1399134204E+00, 8.3122254637E-01, 6.5458975531E-01, 7.0282460365E-01],
	[1.5935000000E+04, 7.6914540360E+00, 5.1396661515E+00, 8.3205258604E-01, 6.5512480464E-01, 7.0295049904E-01],
	[1.5940000000E+04, 7.6948188400E+00, 5.1394189721E+00, 8.3288319334E-01, 6.5566003550E-01, 7.0307635887E-01],
	[1.5945000000E+04, 7.6981840601E+00, 5.1391718821E+00, 8.3371436850E-01, 6.5619544776E-01, 7.0320218313E-01],
	[1.5950000000E+04, 7.7015496961E+00, 5.1389248815E+00, 8.3454611171E-01, 6.5673104129E-01, 7.0332797180E-01],
	[1.5955000000E+04, 7.7049157480E+00, 5.1386779701E+00, 8.3537842318E-01, 6.5726681594E-01, 7.0345372487E-01],
	[1.5960000000E+04, 7.7082822156E+00, 5.1384311479E+00, 8.3621130314E-01, 6.5780277159E-01, 7.0357944234E-01],
	[1.5965000000E+04, 7.7116490990E+00, 5.1381844149E+00, 8.3704475178E-01, 6.5833890810E-01, 7.0370512418E-01],
	[1.5970000000E+04, 7.7150163980E+00, 5.1379377710E+00, 8.3787876931E-01, 6.5887522532E-01, 7.0383077040E-01],
	[1.5975000000E+04, 7.7183841125E+00, 5.1376912162E+00, 8.3871335595E-01, 6.5941172314E-01, 7.0395638097E-01],
	[1.5980000000E+04, 7.7217522425E+00, 5.1374447503E+00, 8.3954851191E-01, 6.5994840140E-01, 7.0408195590E-01],
	[1.5985000000E+04, 7.7251207879E+00, 5.1371983734E+00, 8.4038423739E-01, 6.6048525998E-01, 7.0420749516E-01],
	[1.5990000000E+04, 7.7284897487E+00, 5.1369520853E+00, 8.4122053260E-01, 6.6102229874E-01, 7.0433299875E-01],
	[1.5995000000E+04, 7.7318591246E+00, 5.1367058860E+00, 8.4205739776E-01, 6.6155951754E-01, 7.0445846666E-01],
	[1.6000000000E+04, 7.7352289157E+00, 5.1364597755E+00, 8.4289483307E-01, 6.6209691624E-01, 7.0458389888E-01],
	[1.6005000000E+04, 7.7385991219E+00, 5.1362137536E+00, 8.4373283875E-01, 6.6263449471E-01, 7.0470929539E-01],
	[1.6010000000E+04, 7.7419697431E+00, 5.1359678204E+00, 8.4457141500E-01, 6.6317225281E-01, 7.0483465618E-01],
	[1.6015000000E+04, 7.7453407792E+00, 5.1357219758E+00, 8.4541056203E-01, 6.6371019041E-01, 7.0495998125E-01],
	[1.6020000000E+04, 7.7487122302E+00, 5.1354762196E+00, 8.4625028005E-01, 6.6424830737E-01, 7.0508527058E-01],
	[1.6025000000E+04, 7.7520840959E+00, 5.1352305519E+00, 8.4709056927E-01, 6.6478660355E-01, 7.0521052417E-01],
	[1.6030000000E+04, 7.7554563763E+00, 5.1349849726E+00, 8.4793142991E-01, 6.6532507881E-01, 7.0533574200E-01],
	[1.6035000000E+04, 7.7588290714E+00, 5.1347394816E+00, 8.4877286216E-01, 6.6586373302E-01, 7.0546092406E-01],
	[1.6040000000E+04, 7.7622021809E+00, 5.1344940788E+00, 8.4961486625E-01, 6.6640256605E-01, 7.0558607034E-01],
	[1.6045000000E+04, 7.7655808673E+00, 5.1342509564E+00, 8.5045744238E-01, 6.6694165281E-01, 7.0571118084E-01],
	[1.6050000000E+04, 7.7689673796E+00, 5.1340110656E+00, 8.5130059076E-01, 6.6748102613E-01, 7.0583625553E-01],
	[1.6055000000E+04, 7.7723543133E+00, 5.1337712607E+00, 8.5214431160E-01, 6.6802057832E-01, 7.0596129442E-01],
	[1.6060000000E+04, 7.7757416682E+00, 5.1335315417E+00, 8.5298860510E-01, 6.6856030923E-01, 7.0608629749E-01],
	[1.6065000000E+04, 7.7791294442E+00, 5.1332919085E+00, 8.5383347149E-01, 6.6910021873E-01, 7.0621126473E-01],
	[1.6070000000E+04, 7.7825176414E+00, 5.1330523610E+00, 8.5467891097E-01, 6.6964030667E-01, 7.0633619613E-01],
	[1.6075000000E+04, 7.7859062595E+00, 5.1328128993E+00, 8.5552492374E-01, 6.7018057293E-01, 7.0646109169E-01],
	[1.6080000000E+04, 7.7892952986E+00, 5.1325735232E+00, 8.5637151003E-01, 6.7072101736E-01, 7.0658595138E-01],
	[1.6085000000E+04, 7.7926847585E+00, 5.1323342326E+00, 8.5721867003E-01, 6.7126163983E-01, 7.0671077520E-01],
	[1.6090000000E+04, 7.7960746392E+00, 5.1320950276E+00, 8.5806640397E-01, 6.7180244020E-01, 7.0683556315E-01],
	[1.6095000000E+04, 7.7994649405E+00, 5.1318559081E+00, 8.5891471204E-01, 6.7234341833E-01, 7.0696031520E-01],
	[1.6100000000E+04, 7.8028556625E+00, 5.1316168739E+00, 8.5976359446E-01, 6.7288457409E-01, 7.0708503136E-01],
	[1.6105000000E+04, 7.8062468050E+00, 5.1313779251E+00, 8.6061305144E-01, 6.7342590733E-01, 7.0720971161E-01],
	[1.6110000000E+04, 7.8096383680E+00, 5.1311390616E+00, 8.6146308318E-01, 6.7396741791E-01, 7.0733435593E-01],
	[1.6115000000E+04, 7.8130303513E+00, 5.1309002834E+00, 8.6231368991E-01, 6.7450910571E-01, 7.0745896433E-01],
	[1.6120000000E+04, 7.8164227550E+00, 5.1306615903E+00, 8.6316487182E-01, 6.7505097058E-01, 7.0758353679E-01],
	[1.6125000000E+04, 7.8198155788E+00, 5.1304229823E+00, 8.6401662913E-01, 6.7559301238E-01, 7.0770807330E-01],
	[1.6130000000E+04, 7.8232088228E+00, 5.1301844594E+00, 8.6486896205E-01, 6.7613523098E-01, 7.0783257386E-01],
	[1.6135000000E+04, 7.8266024869E+00, 5.1299460215E+00, 8.6572187078E-01, 6.7667762624E-01, 7.0795703845E-01],
	[1.6140000000E+04, 7.8299965710E+00, 5.1297076686E+00, 8.6657535555E-01, 6.7722019801E-01, 7.0808146705E-01],
	[1.6145000000E+04, 7.8333910749E+00, 5.1294694006E+00, 8.6742941655E-01, 6.7776294616E-01, 7.0820585968E-01],
	[1.6150000000E+04, 7.8367859987E+00, 5.1292312174E+00, 8.6828405400E-01, 6.7830587055E-01, 7.0833021630E-01],
	[1.6155000000E+04, 7.8401813422E+00, 5.1289931190E+00, 8.6913926810E-01, 6.7884897105E-01, 7.0845453692E-01],
	[1.6160000000E+04, 7.8435771054E+00, 5.1287551053E+00, 8.6999505908E-01, 6.7939224750E-01, 7.0857882153E-01],
	[1.6165000000E+04, 7.8469732882E+00, 5.1285171763E+00, 8.7085142713E-01, 6.7993569978E-01, 7.0870307010E-01],
	[1.6170000000E+04, 7.8503698905E+00, 5.1282793319E+00, 8.7170837247E-01, 6.8047932775E-01, 7.0882728265E-01],
	[1.6175000000E+04, 7.8537669123E+00, 5.1280415721E+00, 8.7256589531E-01, 6.8102313126E-01, 7.0895145915E-01],
	[1.6180000000E+04, 7.8571643534E+00, 5.1278038968E+00, 8.7342399585E-01, 6.8156711018E-01, 7.0907559960E-01],
	[1.6185000000E+04, 7.8605622138E+00, 5.1275663059E+00, 8.7428267431E-01, 6.8211126436E-01, 7.0919970398E-01],
	[1.6190000000E+04, 7.8639604934E+00, 5.1273287994E+00, 8.7514193090E-01, 6.8265559367E-01, 7.0932377230E-01],
	[1.6195000000E+04, 7.8673591921E+00, 5.1270913772E+00, 8.7600176583E-01, 6.8320009797E-01, 7.0944780453E-01],
	[1.6200000000E+04, 7.8707583099E+00, 5.1268540394E+00, 8.7686217930E-01, 6.8374477711E-01, 7.0957180067E-01],
	[1.6205000000E+04, 7.8741578466E+00, 5.1266167857E+00, 8.7772317154E-01, 6.8428963097E-01, 7.0969576071E-01],
	[1.6210000000E+04, 7.8775578023E+00, 5.1263796162E+00, 8.7858474274E-01, 6.8483465939E-01, 7.0981968465E-01],
	[1.6215000000E+04, 7.8809581767E+00, 5.1261425308E+00, 8.7944689312E-01, 6.8537986224E-01, 7.0994357246E-01],
	[1.6220000000E+04, 7.8843589699E+00, 5.1259055295E+00, 8.8030962289E-01, 6.8592523938E-01, 7.1006742415E-01],
	[1.6225000000E+04, 7.8877601818E+00, 5.1256686122E+00, 8.8117293225E-01, 6.8647079066E-01, 7.1019123971E-01],
	[1.6230000000E+04, 7.8911618122E+00, 5.1254317788E+00, 8.8203682143E-01, 6.8701651596E-01, 7.1031501912E-01],
	[1.6235000000E+04, 7.8945638612E+00, 5.1251950293E+00, 8.8290129062E-01, 6.8756241512E-01, 7.1043876237E-01],
	[1.6240000000E+04, 7.8979663285E+00, 5.1249583637E+00, 8.8376634005E-01, 6.8810848800E-01, 7.1056246947E-01],
	[1.6245000000E+04, 7.9013692143E+00, 5.1247217818E+00, 8.8463196991E-01, 6.8865473448E-01, 7.1068614039E-01],
	[1.6250000000E+04, 7.9047725183E+00, 5.1244852836E+00, 8.8549818042E-01, 6.8920115440E-01, 7.1080977513E-01],
	[1.6255000000E+04, 7.9081762405E+00, 5.1242488691E+00, 8.8636497179E-01, 6.8974774762E-01, 7.1093337368E-01],
	[1.6260000000E+04, 7.9115803808E+00, 5.1240125383E+00, 8.8723234423E-01, 6.9029451401E-01, 7.1105693603E-01],
	[1.6265000000E+04, 7.9149849391E+00, 5.1237762909E+00, 8.8810029795E-01, 6.9084145343E-01, 7.1118046218E-01],
	[1.6270000000E+04, 7.9183899155E+00, 5.1235401271E+00, 8.8896883316E-01, 6.9138856572E-01, 7.1130395211E-01],
	[1.6275000000E+04, 7.9217953097E+00, 5.1233040467E+00, 8.8983795007E-01, 6.9193585076E-01, 7.1142740581E-01],
	[1.6280000000E+04, 7.9252011217E+00, 5.1230680498E+00, 8.9070764889E-01, 6.9248330840E-01, 7.1155082329E-01],
	[1.6285000000E+04, 7.9286073514E+00, 5.1228321361E+00, 8.9157792984E-01, 6.9303093849E-01, 7.1167420452E-01],
	[1.6290000000E+04, 7.9320139988E+00, 5.1225963057E+00, 8.9244879311E-01, 6.9357874091E-01, 7.1179754950E-01],
	[1.6295000000E+04, 7.9354210638E+00, 5.1223605586E+00, 8.9332023893E-01, 6.9412671550E-01, 7.1192085823E-01],
	[1.6300000000E+04, 7.9388285463E+00, 5.1221248946E+00, 8.9419226749E-01, 6.9467486212E-01, 7.1204413068E-01],
	[1.6305000000E+04, 7.9422463319E+00, 5.1218932996E+00, 8.9506487902E-01, 6.9522332983E-01, 7.1216736686E-01],
	[1.6310000000E+04, 7.9456677179E+00, 5.1216630667E+00, 8.9593807373E-01, 6.9577201765E-01, 7.1229056676E-01],
	[1.6315000000E+04, 7.9490895284E+00, 5.1214329147E+00, 8.9681185181E-01, 6.9632087756E-01, 7.1241373036E-01],
	[1.6320000000E+04, 7.9525117633E+00, 5.1212028435E+00, 8.9768621349E-01, 6.9686990943E-01, 7.1253685766E-01],
	[1.6325000000E+04, 7.9559344225E+00, 5.1209728532E+00, 8.9856115897E-01, 6.9741911311E-01, 7.1265994866E-01],
	[1.6330000000E+04, 7.9593575061E+00, 5.1207429436E+00, 8.9943668847E-01, 6.9796848845E-01, 7.1278300333E-01],
	[1.6335000000E+04, 7.9627810138E+00, 5.1205131147E+00, 9.0031280218E-01, 6.9851803533E-01, 7.1290602168E-01],
	[1.6340000000E+04, 7.9662049456E+00, 5.1202833664E+00, 9.0118950034E-01, 6.9906775360E-01, 7.1302900370E-01],
	[1.6345000000E+04, 7.9696293014E+00, 5.1200536988E+00, 9.0206678314E-01, 6.9961764311E-01, 7.1315194937E-01],
	[1.6350000000E+04, 7.9730540812E+00, 5.1198241117E+00, 9.0294465079E-01, 7.0016770373E-01, 7.1327485869E-01],
	[1.6355000000E+04, 7.9764792849E+00, 5.1195946051E+00, 9.0382310351E-01, 7.0071793530E-01, 7.1339773166E-01],
	[1.6360000000E+04, 7.9799049124E+00, 5.1193651789E+00, 9.0470214151E-01, 7.0126833770E-01, 7.1352056825E-01],
	[1.6365000000E+04, 7.9833309636E+00, 5.1191358331E+00, 9.0558176499E-01, 7.0181891077E-01, 7.1364336847E-01],
	[1.6370000000E+04, 7.9867574384E+00, 5.1189065676E+00, 9.0646197417E-01, 7.0236965438E-01, 7.1376613231E-01],
	[1.6375000000E+04, 7.9901843369E+00, 5.1186773825E+00, 9.0734276926E-01, 7.0292056838E-01, 7.1388885976E-01],
	[1.6380000000E+04, 7.9936116588E+00, 5.1184482775E+00, 9.0822415047E-01, 7.0347165264E-01, 7.1401155081E-01],
	[1.6385000000E+04, 7.9970394041E+00, 5.1182192527E+00, 9.0910611800E-01, 7.0402290700E-01, 7.1413420545E-01],
	[1.6390000000E+04, 8.0004675728E+00, 5.1179903080E+00, 9.0998867208E-01, 7.0457433133E-01, 7.1425682368E-01],
	[1.6395000000E+04, 8.0038961647E+00, 5.1177614434E+00, 9.1087181290E-01, 7.0512592548E-01, 7.1437940548E-01],
	[1.6400000000E+04, 8.0073251798E+00, 5.1175326589E+00, 9.1175554069E-01, 7.0567768931E-01, 7.1450195086E-01],
	[1.6405000000E+04, 8.0107546181E+00, 5.1173039542E+00, 9.1263985564E-01, 7.0622962267E-01, 7.1462445980E-01],
	[1.6410000000E+04, 8.0141844793E+00, 5.1170753295E+00, 9.1352475798E-01, 7.0678172543E-01, 7.1474693229E-01],
	[1.6415000000E+04, 8.0176147636E+00, 5.1168467847E+00, 9.1441024791E-01, 7.0733399745E-01, 7.1486936832E-01],
	[1.6420000000E+04, 8.0210454707E+00, 5.1166183197E+00, 9.1529632564E-01, 7.0788643857E-01, 7.1499176790E-01],
	[1.6425000000E+04, 8.0244766005E+00, 5.1163899344E+00, 9.1618299138E-01, 7.0843904866E-01, 7.1511413100E-01],
	[1.6430000000E+04, 8.0279081532E+00, 5.1161616288E+00, 9.1707024535E-01, 7.0899182757E-01, 7.1523645763E-01],
	[1.6435000000E+04, 8.0313401284E+00, 5.1159334029E+00, 9.1795808775E-01, 7.0954477516E-01, 7.1535874777E-01],
	[1.6440000000E+04, 8.0347725263E+00, 5.1157052565E+00, 9.1884651879E-01, 7.1009789128E-01, 7.1548100143E-01],
	[1.6445000000E+04, 8.0382053466E+00, 5.1154771897E+00, 9.1973553870E-01, 7.1065117579E-01, 7.1560321858E-01],
	[1.6450000000E+04, 8.0416385894E+00, 5.1152492025E+00, 9.2062514766E-01, 7.1120462856E-01, 7.1572539922E-01],
	[1.6455000000E+04, 8.0450722545E+00, 5.1150212946E+00, 9.2151534591E-01, 7.1175824943E-01, 7.1584754335E-01],
	[1.6460000000E+04, 8.0485063419E+00, 5.1147934661E+00, 9.2240613364E-01, 7.1231203826E-01, 7.1596965096E-01],
	[1.6465000000E+04, 8.0519408514E+00, 5.1145657170E+00, 9.2329751107E-01, 7.1286599490E-01, 7.1609172204E-01],
	[1.6470000000E+04, 8.0553757831E+00, 5.1143380472E+00, 9.2418947840E-01, 7.1342011922E-01, 7.1621375658E-01],
	[1.6475000000E+04, 8.0588111368E+00, 5.1141104566E+00, 9.2508203586E-01, 7.1397441107E-01, 7.1633575458E-01],
	[1.6480000000E+04, 8.0622469125E+00, 5.1138829452E+00, 9.2597518365E-01, 7.1452887030E-01, 7.1645771603E-01],
	[1.6485000000E+04, 8.0656831100E+00, 5.1136555129E+00, 9.2686892198E-01, 7.1508349678E-01, 7.1657964092E-01],
	[1.6490000000E+04, 8.0691197294E+00, 5.1134281597E+00, 9.2776325106E-01, 7.1563829035E-01, 7.1670152924E-01],
	[1.6495000000E+04, 8.0725567705E+00, 5.1132008856E+00, 9.2865817110E-01, 7.1619325087E-01, 7.1682338099E-01],
	[1.6500000000E+04, 8.0759942332E+00, 5.1129736904E+00, 9.2955368231E-01, 7.1674837820E-01, 7.1694519620E-01],
	[1.6505000000E+04, 8.0794321176E+00, 5.1127465741E+00, 9.3044978491E-01, 7.1730367220E-01, 7.1706697487E-01],
	[1.6510000000E+04, 8.0828704234E+00, 5.1125195367E+00, 9.3134647910E-01, 7.1785913271E-01, 7.1718871700E-01],
	[1.6515000000E+04, 8.0863091507E+00, 5.1122925782E+00, 9.3224376510E-01, 7.1841475960E-01, 7.1731042257E-01],
	[1.6520000000E+04, 8.0897482993E+00, 5.1120656984E+00, 9.3314164311E-01, 7.1897055271E-01, 7.1743209158E-01],
	[1.6525000000E+04, 8.0931878692E+00, 5.1118388973E+00, 9.3404011335E-01, 7.1952651192E-01, 7.1755372402E-01],
	[1.6530000000E+04, 8.0966278603E+00, 5.1116121749E+00, 9.3493917603E-01, 7.2008263706E-01, 7.1767531987E-01],
	[1.6535000000E+04, 8.1000682725E+00, 5.1113855311E+00, 9.3583883136E-01, 7.2063892799E-01, 7.1779687913E-01],
	[1.6540000000E+04, 8.1035091057E+00, 5.1111589659E+00, 9.3673907954E-01, 7.2119538457E-01, 7.1791840178E-01],
	[1.6545000000E+04, 8.1069503600E+00, 5.1109324792E+00, 9.3763992080E-01, 7.2175200666E-01, 7.1803988782E-01],
	[1.6550000000E+04, 8.1103920351E+00, 5.1107060710E+00, 9.3854135534E-01, 7.2230879411E-01, 7.1816133723E-01],
	[1.6555000000E+04, 8.1138341311E+00, 5.1104797412E+00, 9.3944338336E-01, 7.2286574677E-01, 7.1828275002E-01],
	[1.6560000000E+04, 8.1172766478E+00, 5.1102534898E+00, 9.4034600510E-01, 7.2342286450E-01, 7.1840412616E-01],
	[1.6565000000E+04, 8.1207232643E+00, 5.1100287271E+00, 9.4124922074E-01, 7.2398020471E-01, 7.1852546564E-01],
	[1.6570000000E+04, 8.1241801867E+00, 5.1098078292E+00, 9.4215303051E-01, 7.2453786458E-01, 7.1864676847E-01],
	[1.6575000000E+04, 8.1276375370E+00, 5.1095870075E+00, 9.4305743461E-01, 7.2509568959E-01, 7.1876803462E-01],
	[1.6580000000E+04, 8.1310953152E+00, 5.1093662619E+00, 9.4396243327E-01, 7.2565367959E-01, 7.1888926409E-01],
	[1.6585000000E+04, 8.1345535212E+00, 5.1091455924E+00, 9.4486802667E-01, 7.2621183444E-01, 7.1901045688E-01],
	[1.6590000000E+04, 8.1380121549E+00, 5.1089249990E+00, 9.4577421505E-01, 7.2677015399E-01, 7.1913161296E-01],
	[1.6595000000E+04, 8.1414712162E+00, 5.1087044815E+00, 9.4668099860E-01, 7.2732863811E-01, 7.1925273233E-01],
	[1.6600000000E+04, 8.1449307051E+00, 5.1084840400E+00, 9.4758837755E-01, 7.2788728663E-01, 7.1937381498E-01],
	[1.6605000000E+04, 8.1483906215E+00, 5.1082636745E+00, 9.4849635210E-01, 7.2844609942E-01, 7.1949486090E-01],
	[1.6610000000E+04, 8.1518509653E+00, 5.1080433847E+00, 9.4940492245E-01, 7.2900507633E-01, 7.1961587009E-01],
	[1.6615000000E+04, 8.1553117365E+00, 5.1078231707E+00, 9.5031408884E-01, 7.2956421722E-01, 7.1973684252E-01],
	[1.6620000000E+04, 8.1587729349E+00, 5.1076030325E+00, 9.5122385145E-01, 7.3012352194E-01, 7.1985777821E-01],
	[1.6625000000E+04, 8.1622345605E+00, 5.1073829700E+00, 9.5213421051E-01, 7.3068299034E-01, 7.1997867712E-01],
	[1.6630000000E+04, 8.1656966132E+00, 5.1071629832E+00, 9.5304516623E-01, 7.3124262228E-01, 7.2009953926E-01],
	[1.6635000000E+04, 8.1691590930E+00, 5.1069430719E+00, 9.5395671881E-01, 7.3180241761E-01, 7.2022036462E-01],
	[1.6640000000E+04, 8.1726219997E+00, 5.1067232362E+00, 9.5486886847E-01, 7.3236237618E-01, 7.2034115318E-01],
	[1.6645000000E+04, 8.1760853333E+00, 5.1065034760E+00, 9.5578161542E-01, 7.3292249785E-01, 7.2046190494E-01],
	[1.6650000000E+04, 8.1795490937E+00, 5.1062837913E+00, 9.5669495987E-01, 7.3348278248E-01, 7.2058261990E-01],
	[1.6655000000E+04, 8.1830132808E+00, 5.1060641820E+00, 9.5760890203E-01, 7.3404322991E-01, 7.2070329803E-01],
	[1.6660000000E+04, 8.1864778946E+00, 5.1058446480E+00, 9.5852344212E-01, 7.3460384001E-01, 7.2082393933E-01],
	[1.6665000000E+04, 8.1899429350E+00, 5.1056251894E+00, 9.5943858034E-01, 7.3516461261E-01, 7.2094454379E-01],
	[1.6670000000E+04, 8.1934084019E+00, 5.1054058060E+00, 9.6035431690E-01, 7.3572554759E-01, 7.2106511141E-01],
	[1.6675000000E+04, 8.1968742952E+00, 5.1051864978E+00, 9.6127065202E-01, 7.3628664478E-01, 7.2118564217E-01],
	[1.6680000000E+04, 8.2003406149E+00, 5.1049672648E+00, 9.6218758590E-01, 7.3684790405E-01, 7.2130613606E-01],
	[1.6685000000E+04, 8.2038073608E+00, 5.1047481069E+00, 9.6310511877E-01, 7.3740932524E-01, 7.2142659308E-01],
	[1.6690000000E+04, 8.2072745330E+00, 5.1045290241E+00, 9.6402325082E-01, 7.3797090822E-01, 7.2154701322E-01],
	[1.6695000000E+04, 8.2107421313E+00, 5.1043100163E+00, 9.6494198227E-01, 7.3853265282E-01, 7.2166739647E-01],
	[1.6700000000E+04, 8.2142101556E+00, 5.1040910834E+00, 9.6586131334E-01, 7.3909455891E-01, 7.2178774282E-01],
	[1.6705000000E+04, 8.2176786059E+00, 5.1038722255E+00, 9.6678124422E-01, 7.3965662634E-01, 7.2190805227E-01],
	[1.6710000000E+04, 8.2211474821E+00, 5.1036534425E+00, 9.6770177514E-01, 7.4021885496E-01, 7.2202832479E-01],
	[1.6715000000E+04, 8.2246167842E+00, 5.1034347343E+00, 9.6862290631E-01, 7.4078124463E-01, 7.2214856039E-01],
	[1.6720000000E+04, 8.2280865120E+00, 5.1032161009E+00, 9.6954463793E-01, 7.4134379519E-01, 7.2226875906E-01],
	[1.6725000000E+04, 8.2315566655E+00, 5.1029975422E+00, 9.7046697022E-01, 7.4190650650E-01, 7.2238892078E-01],
	[1.6730000000E+04, 8.2350272446E+00, 5.1027790582E+00, 9.7138990339E-01, 7.4246937841E-01, 7.2250904555E-01],
	[1.6735000000E+04, 8.2384982492E+00, 5.1025606488E+00, 9.7231343765E-01, 7.4303241078E-01, 7.2262913337E-01],
	[1.6740000000E+04, 8.2419696792E+00, 5.1023423141E+00, 9.7323757321E-01, 7.4359560345E-01, 7.2274918421E-01],
	[1.6745000000E+04, 8.2454415347E+00, 5.1021240538E+00, 9.7416231028E-01, 7.4415895628E-01, 7.2286919808E-01],
	[1.6750000000E+04, 8.2489138154E+00, 5.1019058681E+00, 9.7508764908E-01, 7.4472246912E-01, 7.2298917497E-01],
	[1.6755000000E+04, 8.2523865214E+00, 5.1016877568E+00, 9.7601358981E-01, 7.4528614182E-01, 7.2310911486E-01],
	[1.6760000000E+04, 8.2558596525E+00, 5.1014697199E+00, 9.7694013269E-01, 7.4584997424E-01, 7.2322901776E-01],
	[1.6765000000E+04, 8.2593332087E+00, 5.1012517574E+00, 9.7786727792E-01, 7.4641396622E-01, 7.2334888364E-01],
	[1.6770000000E+04, 8.2628071900E+00, 5.1010338692E+00, 9.7879502573E-01, 7.4697811762E-01, 7.2346871251E-01],
	[1.6775000000E+04, 8.2662815961E+00, 5.1008160552E+00, 9.7972337631E-01, 7.4754242830E-01, 7.2358850435E-01],
	[1.6780000000E+04, 8.2697564271E+00, 5.1005983154E+00, 9.8065232989E-01, 7.4810689809E-01, 7.2370825916E-01],
	[1.6785000000E+04, 8.2732316829E+00, 5.1003806498E+00, 9.8158188667E-01, 7.4867152686E-01, 7.2382797693E-01],
	[1.6790000000E+04, 8.2767073634E+00, 5.1001630583E+00, 9.8251204686E-01, 7.4923631445E-01, 7.2394765765E-01],
	[1.6795000000E+04, 8.2801834685E+00, 5.0999455409E+00, 9.8344281068E-01, 7.4980126072E-01, 7.2406730131E-01],
	[1.6800000000E+04, 8.2836599981E+00, 5.0997280975E+00, 9.8437417834E-01, 7.5036636552E-01, 7.2418690791E-01],
	[1.6805000000E+04, 8.2871369523E+00, 5.0995107280E+00, 9.8530615005E-01, 7.5093162870E-01, 7.2430647743E-01],
	[1.6810000000E+04, 8.2906143308E+00, 5.0992934325E+00, 9.8623872601E-01, 7.5149705011E-01, 7.2442600987E-01],
	[1.6815000000E+04, 8.2940921337E+00, 5.0990762109E+00, 9.8717190645E-01, 7.5206262960E-01, 7.2454550523E-01],
	[1.6820000000E+04, 8.2975703609E+00, 5.0988590631E+00, 9.8810569157E-01, 7.5262836702E-01, 7.2466496349E-01],
	[1.6825000000E+04, 8.3010490122E+00, 5.0986419891E+00, 9.8904008159E-01, 7.5319426223E-01, 7.2478438464E-01],
	[1.6830000000E+04, 8.3045280877E+00, 5.0984249888E+00, 9.8997507671E-01, 7.5376031507E-01, 7.2490376868E-01],
	[1.6835000000E+04, 8.3080208242E+00, 5.0982128888E+00, 9.9091067715E-01, 7.5432674018E-01, 7.2502311560E-01],
	[1.6840000000E+04, 8.3115148235E+00, 5.0980011636E+00, 9.9184688312E-01, 7.5489333664E-01, 7.2514242539E-01],
	[1.6845000000E+04, 8.3150092543E+00, 5.0977895101E+00, 9.9278369482E-01, 7.5546009081E-01, 7.2526169805E-01],
	[1.6850000000E+04, 8.3185041166E+00, 5.0975779281E+00, 9.9372111248E-01, 7.5602700255E-01, 7.2538093357E-01],
	[1.6855000000E+04, 8.3219994102E+00, 5.0973664178E+00, 9.9465913631E-01, 7.5659407171E-01, 7.2550013194E-01],
	[1.6860000000E+04, 8.3254951351E+00, 5.0971549789E+00, 9.9559776651E-01, 7.5716129815E-01, 7.2561929314E-01],
	[1.6865000000E+04, 8.3289912913E+00, 5.0969436115E+00, 9.9653700329E-01, 7.5772868170E-01, 7.2573841719E-01],
	[1.6870000000E+04, 8.3324878785E+00, 5.0967323155E+00, 9.9747684687E-01, 7.5829622223E-01, 7.2585750406E-01],
	[1.6875000000E+04, 8.3359848969E+00, 5.0965210909E+00, 9.9841729746E-01, 7.5886391959E-01, 7.2597655375E-01],
	[1.6880000000E+04, 8.3394823462E+00, 5.0963099376E+00, 9.9935835528E-01, 7.5943177362E-01, 7.2609556625E-01],
	[1.6885000000E+04, 8.3429802265E+00, 5.0960988555E+00, 1.0003000205E+00, 7.5999978417E-01, 7.2621454156E-01],
	[1.6890000000E+04, 8.3464785376E+00, 5.0958878448E+00, 1.0012422934E+00, 7.6056795110E-01, 7.2633347967E-01],
	[1.6895000000E+04, 8.3499772794E+00, 5.0956769052E+00, 1.0021851742E+00, 7.6113627426E-01, 7.2645238056E-01],
	[1.6900000000E+04, 8.3534764520E+00, 5.0954660367E+00, 1.0031286630E+00, 7.6170475350E-01, 7.2657124424E-01],
	[1.6905000000E+04, 8.3569760552E+00, 5.0952552394E+00, 1.0040727601E+00, 7.6227338866E-01, 7.2669007070E-01],
	[1.6910000000E+04, 8.3604760889E+00, 5.0950445131E+00, 1.0050174656E+00, 7.6284217961E-01, 7.2680885993E-01],
	[1.6915000000E+04, 8.3639765531E+00, 5.0948338578E+00, 1.0059627799E+00, 7.6341112618E-01, 7.2692761191E-01],
	[1.6920000000E+04, 8.3674774477E+00, 5.0946232735E+00, 1.0069087031E+00, 7.6398022823E-01, 7.2704632666E-01],
	[1.6925000000E+04, 8.3709787726E+00, 5.0944127601E+00, 1.0078552355E+00, 7.6454948561E-01, 7.2716500415E-01],
	[1.6930000000E+04, 8.3744805278E+00, 5.0942023176E+00, 1.0088023771E+00, 7.6511889817E-01, 7.2728364438E-01],
	[1.6935000000E+04, 8.3779827131E+00, 5.0939919459E+00, 1.0097501283E+00, 7.6568846576E-01, 7.2740224734E-01],
	[1.6940000000E+04, 8.3814853286E+00, 5.0937816450E+00, 1.0106984893E+00, 7.6625818823E-01, 7.2752081304E-01],
	[1.6945000000E+04, 8.3849883740E+00, 5.0935714148E+00, 1.0116474602E+00, 7.6682806543E-01, 7.2763934145E-01],
	[1.6950000000E+04, 8.3884918495E+00, 5.0933612554E+00, 1.0125970414E+00, 7.6739809721E-01, 7.2775783257E-01],
	[1.6955000000E+04, 8.3919957548E+00, 5.0931511665E+00, 1.0135472329E+00, 7.6796828341E-01, 7.2787628640E-01],
	[1.6960000000E+04, 8.3955000899E+00, 5.0929411483E+00, 1.0144980350E+00, 7.6853862390E-01, 7.2799470293E-01],
	[1.6965000000E+04, 8.3990048547E+00, 5.0927312007E+00, 1.0154494480E+00, 7.6910911851E-01, 7.2811308216E-01],
	[1.6970000000E+04, 8.4025100492E+00, 5.0925213236E+00, 1.0164014719E+00, 7.6967976710E-01, 7.2823142407E-01],
	[1.6975000000E+04, 8.4060156733E+00, 5.0923115169E+00, 1.0173541072E+00, 7.7025056952E-01, 7.2834972865E-01],
	[1.6980000000E+04, 8.4095217268E+00, 5.0921017807E+00, 1.0183073538E+00, 7.7082152561E-01, 7.2846799591E-01],
	[1.6985000000E+04, 8.4130282099E+00, 5.0918921149E+00, 1.0192612122E+00, 7.7139263523E-01, 7.2858622584E-01],
	[1.6990000000E+04, 8.4165351222E+00, 5.0916825194E+00, 1.0202156824E+00, 7.7196389822E-01, 7.2870441843E-01],
	[1.6995000000E+04, 8.4200424639E+00, 5.0914729942E+00, 1.0211707647E+00, 7.7253531444E-01, 7.2882257366E-01],
	[1.7000000000E+04, 8.4235502348E+00, 5.0912635392E+00, 1.0221264593E+00, 7.7310688374E-01, 7.2894069155E-01],
	[1.7005000000E+04, 8.4270584348E+00, 5.0910541545E+00, 1.0230827665E+00, 7.7367860595E-01, 7.2905877207E-01],
	[1.7010000000E+04, 8.4305670639E+00, 5.0908448399E+00, 1.0240396863E+00, 7.7425048094E-01, 7.2917681523E-01],
	[1.7015000000E+04, 8.4340761219E+00, 5.0906355955E+00, 1.0249972191E+00, 7.7482250855E-01, 7.2929482101E-01],
	[1.7020000000E+04, 8.4375856089E+00, 5.0904264211E+00, 1.0259553651E+00, 7.7539468862E-01, 7.2941278941E-01],
	[1.7025000000E+04, 8.4410955248E+00, 5.0902173168E+00, 1.0269141244E+00, 7.7596702102E-01, 7.2953072043E-01],
	[1.7030000000E+04, 8.4446058694E+00, 5.0900082824E+00, 1.0278734972E+00, 7.7653950558E-01, 7.2964861406E-01],
	[1.7035000000E+04, 8.4481166427E+00, 5.0897993180E+00, 1.0288334839E+00, 7.7711214216E-01, 7.2976647028E-01],
	[1.7040000000E+04, 8.4516278446E+00, 5.0895904235E+00, 1.0297940845E+00, 7.7768493060E-01, 7.2988428910E-01],
	[1.7045000000E+04, 8.4551394751E+00, 5.0893815988E+00, 1.0307552994E+00, 7.7825787075E-01, 7.3000207051E-01],
	[1.7050000000E+04, 8.4586515340E+00, 5.0891728440E+00, 1.0317171287E+00, 7.7883096247E-01, 7.3011981451E-01],
	[1.7055000000E+04, 8.4621640214E+00, 5.0889641589E+00, 1.0326795726E+00, 7.7940420559E-01, 7.3023752107E-01],
	[1.7060000000E+04, 8.4656769371E+00, 5.0887555435E+00, 1.0336426314E+00, 7.7997759997E-01, 7.3035519021E-01],
	[1.7065000000E+04, 8.4691902810E+00, 5.0885469979E+00, 1.0346063052E+00, 7.8055114546E-01, 7.3047282192E-01],
	[1.7070000000E+04, 8.4727040532E+00, 5.0883385218E+00, 1.0355705943E+00, 7.8112484191E-01, 7.3059041618E-01],
	[1.7075000000E+04, 8.4762182534E+00, 5.0881301154E+00, 1.0365354988E+00, 7.8169868915E-01, 7.3070797299E-01],
	[1.7080000000E+04, 8.4797328817E+00, 5.0879217785E+00, 1.0375010191E+00, 7.8227268705E-01, 7.3082549235E-01],
	[1.7085000000E+04, 8.4832479379E+00, 5.0877135111E+00, 1.0384671553E+00, 7.8284683545E-01, 7.3094297425E-01],
	[1.7090000000E+04, 8.4867634221E+00, 5.0875053132E+00, 1.0394339075E+00, 7.8342113419E-01, 7.3106041868E-01],
	[1.7095000000E+04, 8.4902793340E+00, 5.0872971847E+00, 1.0404012762E+00, 7.8399558313E-01, 7.3117782564E-01],
	[1.7100000000E+04, 8.4937956737E+00, 5.0870891256E+00, 1.0413692613E+00, 7.8457018211E-01, 7.3129519512E-01],
	[1.7105000000E+04, 8.4973234054E+00, 5.0868849428E+00, 1.0423378632E+00, 7.8514511528E-01, 7.3141252712E-01],
	[1.7110000000E+04, 8.5008551886E+00, 5.0866820836E+00, 1.0433070821E+00, 7.8572025948E-01, 7.3152982164E-01],
	[1.7115000000E+04, 8.5043874072E+00, 5.0864792918E+00, 1.0442769181E+00, 7.8629555381E-01, 7.3164707865E-01],
	[1.7120000000E+04, 8.5079200611E+00, 5.0862765673E+00, 1.0452473715E+00, 7.8687099814E-01, 7.3176429817E-01],
	[1.7125000000E+04, 8.5114531502E+00, 5.0860739101E+00, 1.0462184426E+00, 7.8744659230E-01, 7.3188148017E-01],
	[1.7130000000E+04, 8.5149866744E+00, 5.0858713201E+00, 1.0471901314E+00, 7.8802233614E-01, 7.3199862467E-01],
	[1.7135000000E+04, 8.5185206337E+00, 5.0856687972E+00, 1.0481624383E+00, 7.8859822951E-01, 7.3211573165E-01],
	[1.7140000000E+04, 8.5220550279E+00, 5.0854663416E+00, 1.0491353634E+00, 7.8917427226E-01, 7.3223280110E-01],
	[1.7145000000E+04, 8.5255898571E+00, 5.0852639530E+00, 1.0501089069E+00, 7.8975046424E-01, 7.3234983303E-01],
	[1.7150000000E+04, 8.5291251212E+00, 5.0850616315E+00, 1.0510830692E+00, 7.9032680529E-01, 7.3246682742E-01],
	[1.7155000000E+04, 8.5326608200E+00, 5.0848593771E+00, 1.0520578503E+00, 7.9090329527E-01, 7.3258378427E-01],
	[1.7160000000E+04, 8.5361969535E+00, 5.0846571896E+00, 1.0530332504E+00, 7.9147993401E-01, 7.3270070358E-01],
	[1.7165000000E+04, 8.5397335216E+00, 5.0844550690E+00, 1.0540092699E+00, 7.9205672137E-01, 7.3281758533E-01],
	[1.7170000000E+04, 8.5432705243E+00, 5.0842530154E+00, 1.0549859089E+00, 7.9263365720E-01, 7.3293442953E-01],
	[1.7175000000E+04, 8.5468079614E+00, 5.0840510286E+00, 1.0559631676E+00, 7.9321074134E-01, 7.3305123617E-01],
	[1.7180000000E+04, 8.5503458330E+00, 5.0838491086E+00, 1.0569410462E+00, 7.9378797364E-01, 7.3316800524E-01],
	[1.7185000000E+04, 8.5538841389E+00, 5.0836472554E+00, 1.0579195450E+00, 7.9436535394E-01, 7.3328473673E-01],
	[1.7190000000E+04, 8.5574228790E+00, 5.0834454689E+00, 1.0588986642E+00, 7.9494288210E-01, 7.3340143065E-01],
	[1.7195000000E+04, 8.5609620533E+00, 5.0832437491E+00, 1.0598784039E+00, 7.9552055796E-01, 7.3351808699E-01],
	[1.7200000000E+04, 8.5645016618E+00, 5.0830420960E+00, 1.0608587644E+00, 7.9609838137E-01, 7.3363470574E-01],
	[1.7205000000E+04, 8.5680417043E+00, 5.0828405095E+00, 1.0618397459E+00, 7.9667635217E-01, 7.3375128689E-01],
	[1.7210000000E+04, 8.5715821807E+00, 5.0826389895E+00, 1.0628213486E+00, 7.9725447022E-01, 7.3386783045E-01],
	[1.7215000000E+04, 8.5751230910E+00, 5.0824375361E+00, 1.0638035727E+00, 7.9783273535E-01, 7.3398433640E-01],
	[1.7220000000E+04, 8.5786644352E+00, 5.0822361491E+00, 1.0647864185E+00, 7.9841114742E-01, 7.3410080475E-01],
	[1.7225000000E+04, 8.5822062131E+00, 5.0820348286E+00, 1.0657698861E+00, 7.9898970628E-01, 7.3421723548E-01],
	[1.7230000000E+04, 8.5857484247E+00, 5.0818335745E+00, 1.0667539757E+00, 7.9956841176E-01, 7.3433362859E-01],
	[1.7235000000E+04, 8.5892910699E+00, 5.0816323868E+00, 1.0677386876E+00, 8.0014726372E-01, 7.3444998408E-01],
	[1.7240000000E+04, 8.5928341486E+00, 5.0814312654E+00, 1.0687240221E+00, 8.0072626201E-01, 7.3456630194E-01],
	[1.7245000000E+04, 8.5963776608E+00, 5.0812302102E+00, 1.0697099792E+00, 8.0130540646E-01, 7.3468258217E-01],
	[1.7250000000E+04, 8.5999216063E+00, 5.0810292213E+00, 1.0706965592E+00, 8.0188469693E-01, 7.3479882476E-01],
	[1.7255000000E+04, 8.6034659852E+00, 5.0808282986E+00, 1.0716837623E+00, 8.0246413326E-01, 7.3491502970E-01],
	[1.7260000000E+04, 8.6070107973E+00, 5.0806274420E+00, 1.0726715888E+00, 8.0304371530E-01, 7.3503119700E-01],
	[1.7265000000E+04, 8.6105560426E+00, 5.0804266516E+00, 1.0736600388E+00, 8.0362344290E-01, 7.3514732665E-01],
	[1.7270000000E+04, 8.6141017210E+00, 5.0802259272E+00, 1.0746491125E+00, 8.0420331590E-01, 7.3526341863E-01],
	[1.7275000000E+04, 8.6176478323E+00, 5.0800252689E+00, 1.0756388102E+00, 8.0478333414E-01, 7.3537947296E-01],
	[1.7280000000E+04, 8.6211943767E+00, 5.0798246765E+00, 1.0766291321E+00, 8.0536349748E-01, 7.3549548962E-01],
	[1.7285000000E+04, 8.6247413539E+00, 5.0796241501E+00, 1.0776200784E+00, 8.0594380576E-01, 7.3561146860E-01],
	[1.7290000000E+04, 8.6282887639E+00, 5.0794236896E+00, 1.0786116494E+00, 8.0652425883E-01, 7.3572740991E-01],
	[1.7295000000E+04, 8.6318366067E+00, 5.0792232950E+00, 1.0796038451E+00, 8.0710485653E-01, 7.3584331354E-01],
	[1.7300000000E+04, 8.6353848821E+00, 5.0790229662E+00, 1.0805966658E+00, 8.0768559871E-01, 7.3595917948E-01],
	[1.7305000000E+04, 8.6389335901E+00, 5.0788227032E+00, 1.0815901118E+00, 8.0826648521E-01, 7.3607500774E-01],
	[1.7310000000E+04, 8.6424827306E+00, 5.0786225059E+00, 1.0825841833E+00, 8.0884751588E-01, 7.3619079830E-01],
	[1.7315000000E+04, 8.6460323035E+00, 5.0784223744E+00, 1.0835788804E+00, 8.0942869056E-01, 7.3630655116E-01],
	[1.7320000000E+04, 8.6495823088E+00, 5.0782223085E+00, 1.0845742034E+00, 8.1001000911E-01, 7.3642226631E-01],
	[1.7325000000E+04, 8.6531327465E+00, 5.0780223082E+00, 1.0855701525E+00, 8.1059147136E-01, 7.3653794376E-01],
	[1.7330000000E+04, 8.6566836163E+00, 5.0778223736E+00, 1.0865667279E+00, 8.1117307717E-01, 7.3665358350E-01],
	[1.7335000000E+04, 8.6602349183E+00, 5.0776225044E+00, 1.0875639298E+00, 8.1175482637E-01, 7.3676918552E-01],
	[1.7340000000E+04, 8.6637866524E+00, 5.0774227008E+00, 1.0885617585E+00, 8.1233671882E-01, 7.3688474982E-01],
	[1.7345000000E+04, 8.6673388185E+00, 5.0772229627E+00, 1.0895602140E+00, 8.1291875436E-01, 7.3700027639E-01],
	[1.7350000000E+04, 8.6708914165E+00, 5.0770232899E+00, 1.0905592968E+00, 8.1350093283E-01, 7.3711576524E-01],
	[1.7355000000E+04, 8.6744444464E+00, 5.0768236826E+00, 1.0915590069E+00, 8.1408325408E-01, 7.3723121635E-01],
	[1.7360000000E+04, 8.6779979081E+00, 5.0766241406E+00, 1.0925593446E+00, 8.1466571796E-01, 7.3734662972E-01],
	[1.7365000000E+04, 8.6815518015E+00, 5.0764246639E+00, 1.0935603101E+00, 8.1524832430E-01, 7.3746200536E-01],
	[1.7370000000E+04, 8.6851061265E+00, 5.0762252524E+00, 1.0945619036E+00, 8.1583107296E-01, 7.3757734324E-01],
	[1.7375000000E+04, 8.6886608832E+00, 5.0760259062E+00, 1.0955641253E+00, 8.1641396378E-01, 7.3769264338E-01],
	[1.7380000000E+04, 8.6922264965E+00, 5.0758300762E+00, 1.0965669754E+00, 8.1699717812E-01, 7.3780790576E-01],
	[1.7385000000E+04, 8.6957972186E+00, 5.0756358559E+00, 1.0975704542E+00, 8.1758061611E-01, 7.3792313038E-01],
	[1.7390000000E+04, 8.6993683802E+00, 5.0754416988E+00, 1.0985745619E+00, 8.1816419637E-01, 7.3803831725E-01],
	[1.7395000000E+04, 8.7029399810E+00, 5.0752476051E+00, 1.0995792986E+00, 8.1874791875E-01, 7.3815346634E-01],
	[1.7400000000E+04, 8.7065120212E+00, 5.0750535745E+00, 1.1005846646E+00, 8.1933178309E-01, 7.3826857767E-01],
	[1.7405000000E+04, 8.7100845005E+00, 5.0748596071E+00, 1.1015906600E+00, 8.1991578924E-01, 7.3838365122E-01],
	[1.7410000000E+04, 8.7136574189E+00, 5.0746657028E+00, 1.1025972852E+00, 8.2049993704E-01, 7.3849868699E-01],
	[1.7415000000E+04, 8.7172307763E+00, 5.0744718616E+00, 1.1036045404E+00, 8.2108422634E-01, 7.3861368498E-01],
	[1.7420000000E+04, 8.7208045727E+00, 5.0742780834E+00, 1.1046124256E+00, 8.2166865698E-01, 7.3872864519E-01],
	[1.7425000000E+04, 8.7243788080E+00, 5.0740843682E+00, 1.1056209412E+00, 8.2225322881E-01, 7.3884356761E-01],
	[1.7430000000E+04, 8.7279534821E+00, 5.0738907161E+00, 1.1066300873E+00, 8.2283794167E-01, 7.3895845223E-01],
	[1.7435000000E+04, 8.7315285950E+00, 5.0736971268E+00, 1.1076398643E+00, 8.2342279541E-01, 7.3907329906E-01],
	[1.7440000000E+04, 8.7351041465E+00, 5.0735036004E+00, 1.1086502722E+00, 8.2400778987E-01, 7.3918810809E-01],
	[1.7445000000E+04, 8.7386801366E+00, 5.0733101369E+00, 1.1096613113E+00, 8.2459292491E-01, 7.3930287931E-01],
	[1.7450000000E+04, 8.7422565653E+00, 5.0731167362E+00, 1.1106729818E+00, 8.2517820035E-01, 7.3941761272E-01],
	[1.7455000000E+04, 8.7458334324E+00, 5.0729233983E+00, 1.1116852839E+00, 8.2576361605E-01, 7.3953230833E-01],
	[1.7460000000E+04, 8.7494107379E+00, 5.0727301231E+00, 1.1126982179E+00, 8.2634917186E-01, 7.3964696612E-01],
	[1.7465000000E+04, 8.7529884817E+00, 5.0725369107E+00, 1.1137117839E+00, 8.2693486761E-01, 7.3976158609E-01],
	[1.7470000000E+04, 8.7565666638E+00, 5.0723437609E+00, 1.1147259822E+00, 8.2752070315E-01, 7.3987616823E-01],
	[1.7475000000E+04, 8.7601452840E+00, 5.0721506737E+00, 1.1157408129E+00, 8.2810667832E-01, 7.3999071256E-01],
	[1.7480000000E+04, 8.7637243423E+00, 5.0719576491E+00, 1.1167562763E+00, 8.2869279298E-01, 7.4010521905E-01],
	[1.7485000000E+04, 8.7673038387E+00, 5.0717646870E+00, 1.1177723727E+00, 8.2927904697E-01, 7.4021968771E-01],
	[1.7490000000E+04, 8.7708837730E+00, 5.0715717875E+00, 1.1187891021E+00, 8.2986544012E-01, 7.4033411854E-01],
	[1.7495000000E+04, 8.7744641452E+00, 5.0713789504E+00, 1.1198064649E+00, 8.3045197228E-01, 7.4044851153E-01],
	[1.7500000000E+04, 8.7780449552E+00, 5.0711861757E+00, 1.1208244612E+00, 8.3103864331E-01, 7.4056286667E-01],
	[1.7505000000E+04, 8.7816262029E+00, 5.0709934635E+00, 1.1218513763E+00, 8.3163000594E-01, 7.4067718397E-01],
	[1.7510000000E+04, 8.7852078883E+00, 5.0708008136E+00, 1.1228789382E+00, 8.3222151043E-01, 7.4079146342E-01],
	[1.7515000000E+04, 8.7887900113E+00, 5.0706082260E+00, 1.1239071471E+00, 8.3281315662E-01, 7.4090570502E-01],
	[1.7520000000E+04, 8.7923725718E+00, 5.0704157007E+00, 1.1249360032E+00, 8.3340494436E-01, 7.4101990877E-01],
	[1.7525000000E+04, 8.7959555698E+00, 5.0702232377E+00, 1.1259655067E+00, 8.3399687348E-01, 7.4113407465E-01],
	[1.7530000000E+04, 8.7995390052E+00, 5.0700308369E+00, 1.1269956578E+00, 8.3458894383E-01, 7.4124820267E-01],
	[1.7535000000E+04, 8.8031228779E+00, 5.0698384982E+00, 1.1280264567E+00, 8.3518115525E-01, 7.4136229283E-01],
	[1.7540000000E+04, 8.8067071878E+00, 5.0696462217E+00, 1.1290579038E+00, 8.3577350757E-01, 7.4147634512E-01],
	[1.7545000000E+04, 8.8102919349E+00, 5.0694540072E+00, 1.1300899991E+00, 8.3636600063E-01, 7.4159035954E-01],
	[1.7550000000E+04, 8.8138771190E+00, 5.0692618548E+00, 1.1311227430E+00, 8.3695863429E-01, 7.4170433609E-01],
	[1.7555000000E+04, 8.8174627403E+00, 5.0690697644E+00, 1.1321561356E+00, 8.3755140837E-01, 7.4181827476E-01],
	[1.7560000000E+04, 8.8210487984E+00, 5.0688777360E+00, 1.1331901772E+00, 8.3814432272E-01, 7.4193217555E-01],
	[1.7565000000E+04, 8.8246352935E+00, 5.0686857696E+00, 1.1342248680E+00, 8.3873737718E-01, 7.4204603846E-01],
	[1.7570000000E+04, 8.8282222253E+00, 5.0684938650E+00, 1.1352602082E+00, 8.3933057159E-01, 7.4215986348E-01],
	[1.7575000000E+04, 8.8318095939E+00, 5.0683020223E+00, 1.1362961980E+00, 8.3992390578E-01, 7.4227365061E-01],
	[1.7580000000E+04, 8.8353973992E+00, 5.0681102415E+00, 1.1373328377E+00, 8.4051737961E-01, 7.4238739985E-01],
	[1.7585000000E+04, 8.8389856411E+00, 5.0679185224E+00, 1.1383701275E+00, 8.4111099290E-01, 7.4250111120E-01],
	[1.7590000000E+04, 8.8425743195E+00, 5.0677268651E+00, 1.1394080676E+00, 8.4170474551E-01, 7.4261478465E-01],
	[1.7595000000E+04, 8.8461634343E+00, 5.0675352695E+00, 1.1404466581E+00, 8.4229863726E-01, 7.4272842020E-01],
	[1.7600000000E+04, 8.8497529856E+00, 5.0673437356E+00, 1.1414858995E+00, 8.4289266800E-01, 7.4284201785E-01],
	[1.7605000000E+04, 8.8533429731E+00, 5.0671522633E+00, 1.1425257918E+00, 8.4348683757E-01, 7.4295557759E-01],
	[1.7610000000E+04, 8.8569333969E+00, 5.0669608526E+00, 1.1435663353E+00, 8.4408114582E-01, 7.4306909943E-01],
	[1.7615000000E+04, 8.8605242569E+00, 5.0667695035E+00, 1.1446075302E+00, 8.4467559257E-01, 7.4318258335E-01],
	[1.7620000000E+04, 8.8641155530E+00, 5.0665782159E+00, 1.1456493767E+00, 8.4527017766E-01, 7.4329602936E-01],
	[1.7625000000E+04, 8.8677072851E+00, 5.0663869898E+00, 1.1466918751E+00, 8.4586490095E-01, 7.4340943746E-01],
	[1.7630000000E+04, 8.8712994532E+00, 5.0661958252E+00, 1.1477350256E+00, 8.4645976226E-01, 7.4352280764E-01],
	[1.7635000000E+04, 8.8748920571E+00, 5.0660047220E+00, 1.1487788284E+00, 8.4705476145E-01, 7.4363613989E-01],
	[1.7640000000E+04, 8.8784850969E+00, 5.0658136802E+00, 1.1498232837E+00, 8.4764989834E-01, 7.4374943423E-01],
	[1.7645000000E+04, 8.8820785724E+00, 5.0656226997E+00, 1.1508683917E+00, 8.4824517277E-01, 7.4386269064E-01],
	[1.7650000000E+04, 8.8856724836E+00, 5.0654317805E+00, 1.1519141527E+00, 8.4884058459E-01, 7.4397590912E-01],
	[1.7655000000E+04, 8.8892668305E+00, 5.0652409226E+00, 1.1529605669E+00, 8.4943613364E-01, 7.4408908967E-01],
	[1.7660000000E+04, 8.8928731260E+00, 5.0650537894E+00, 1.1540076346E+00, 8.5003202813E-01, 7.4420223228E-01],
	[1.7665000000E+04, 8.8964838496E+00, 5.0648679841E+00, 1.1550553558E+00, 8.5062813217E-01, 7.4431533697E-01],
	[1.7670000000E+04, 8.9000950167E+00, 5.0646822381E+00, 1.1561037309E+00, 8.5122437356E-01, 7.4442840371E-01],
	[1.7675000000E+04, 8.9037066273E+00, 5.0644965516E+00, 1.1571527601E+00, 8.5182075214E-01, 7.4454143251E-01],
	[1.7680000000E+04, 8.9073186814E+00, 5.0643109243E+00, 1.1582024436E+00, 8.5241726775E-01, 7.4465442338E-01],
	[1.7685000000E+04, 8.9109311788E+00, 5.0641253564E+00, 1.1592527817E+00, 8.5301392022E-01, 7.4476737630E-01],
	[1.7690000000E+04, 8.9145441195E+00, 5.0639398477E+00, 1.1603037744E+00, 8.5361070940E-01, 7.4488029127E-01],
	[1.7695000000E+04, 8.9181575034E+00, 5.0637543982E+00, 1.1613554222E+00, 8.5420763512E-01, 7.4499316829E-01],
	[1.7700000000E+04, 8.9217713304E+00, 5.0635690079E+00, 1.1624077251E+00, 8.5480469722E-01, 7.4510600736E-01],
	[1.7705000000E+04, 8.9253856005E+00, 5.0633836767E+00, 1.1634606835E+00, 8.5540189555E-01, 7.4521880848E-01],
	[1.7710000000E+04, 8.9290003136E+00, 5.0631984047E+00, 1.1645142975E+00, 8.5599922995E-01, 7.4533157165E-01],
	[1.7715000000E+04, 8.9326154697E+00, 5.0630131917E+00, 1.1655685673E+00, 8.5659670024E-01, 7.4544429685E-01],
	[1.7720000000E+04, 8.9362310686E+00, 5.0628280378E+00, 1.1666234933E+00, 8.5719430628E-01, 7.4555698410E-01],
	[1.7725000000E+04, 8.9398471102E+00, 5.0626429428E+00, 1.1676790755E+00, 8.5779204790E-01, 7.4566963339E-01],
	[1.7730000000E+04, 8.9434635946E+00, 5.0624579069E+00, 1.1687353143E+00, 8.5838992494E-01, 7.4578224471E-01],
	[1.7735000000E+04, 8.9470805216E+00, 5.0622729299E+00, 1.1697922098E+00, 8.5898793724E-01, 7.4589481807E-01],
	[1.7740000000E+04, 8.9506978912E+00, 5.0620880118E+00, 1.1708497623E+00, 8.5958608463E-01, 7.4600735347E-01],
	[1.7745000000E+04, 8.9543157033E+00, 5.0619031525E+00, 1.1719079720E+00, 8.6018436697E-01, 7.4611985089E-01],
	[1.7750000000E+04, 8.9579339579E+00, 5.0617183521E+00, 1.1729668391E+00, 8.6078278408E-01, 7.4623231034E-01],
	[1.7755000000E+04, 8.9615526548E+00, 5.0615336104E+00, 1.1740263639E+00, 8.6138133581E-01, 7.4634473182E-01],
	[1.7760000000E+04, 8.9651717940E+00, 5.0613489276E+00, 1.1750865465E+00, 8.6198002199E-01, 7.4645711533E-01],
	[1.7765000000E+04, 8.9687913754E+00, 5.0611643034E+00, 1.1761473872E+00, 8.6257884247E-01, 7.4656946086E-01],
	[1.7770000000E+04, 8.9724113989E+00, 5.0609797379E+00, 1.1772088862E+00, 8.6317779708E-01, 7.4668176841E-01],
	[1.7775000000E+04, 8.9760318646E+00, 5.0607952311E+00, 1.1782710438E+00, 8.6377688565E-01, 7.4679403799E-01],
	[1.7780000000E+04, 8.9796527722E+00, 5.0606107829E+00, 1.1793338601E+00, 8.6437610804E-01, 7.4690626958E-01],
	[1.7785000000E+04, 8.9832741218E+00, 5.0604263933E+00, 1.1803973354E+00, 8.6497546408E-01, 7.4701846319E-01],
	[1.7790000000E+04, 8.9868959133E+00, 5.0602420622E+00, 1.1814614698E+00, 8.6557495361E-01, 7.4713061881E-01],
	[1.7795000000E+04, 8.9905181465E+00, 5.0600577897E+00, 1.1825262638E+00, 8.6617457646E-01, 7.4724273645E-01],
	[1.7800000000E+04, 8.9941408215E+00, 5.0598735756E+00, 1.1835917173E+00, 8.6677433247E-01, 7.4735481610E-01],
	[1.7805000000E+04, 8.9977639381E+00, 5.0596894200E+00, 1.1846578307E+00, 8.6737422149E-01, 7.4746685776E-01],
	[1.7810000000E+04, 9.0013874964E+00, 5.0595053227E+00, 1.1857246042E+00, 8.6797424335E-01, 7.4757886143E-01],
	[1.7815000000E+04, 9.0050114961E+00, 5.0593212839E+00, 1.1867920381E+00, 8.6857439789E-01, 7.4769082711E-01],
	[1.7820000000E+04, 9.0086359373E+00, 5.0591373033E+00, 1.1878601324E+00, 8.6917468495E-01, 7.4780275478E-01],
	[1.7825000000E+04, 9.0122608199E+00, 5.0589533811E+00, 1.1889288875E+00, 8.6977510436E-01, 7.4791464439E-01],
	[1.7830000000E+04, 9.0158861438E+00, 5.0587695172E+00, 1.1899983036E+00, 8.7037565597E-01, 7.4802649594E-01],
	[1.7835000000E+04, 9.0195119089E+00, 5.0585857114E+00, 1.1910683810E+00, 8.7097633961E-01, 7.4813830944E-01],
	[1.7840000000E+04, 9.0231381151E+00, 5.0584019639E+00, 1.1921391197E+00, 8.7157715512E-01, 7.4825008487E-01],
	[1.7845000000E+04, 9.0267647625E+00, 5.0582182746E+00, 1.1932105201E+00, 8.7217810235E-01, 7.4836182224E-01],
	[1.7850000000E+04, 9.0303918509E+00, 5.0580346433E+00, 1.1942825824E+00, 8.7277918112E-01, 7.4847352154E-01],
	[1.7855000000E+04, 9.0340193803E+00, 5.0578510702E+00, 1.1953553067E+00, 8.7338039127E-01, 7.4858518276E-01],
	[1.7860000000E+04, 9.0376473505E+00, 5.0576675551E+00, 1.1964286934E+00, 8.7398173265E-01, 7.4869680590E-01],
	[1.7865000000E+04, 9.0412757616E+00, 5.0574840981E+00, 1.1975027426E+00, 8.7458320509E-01, 7.4880839097E-01],
	[1.7870000000E+04, 9.0449046134E+00, 5.0573006990E+00, 1.1985774546E+00, 8.7518480843E-01, 7.4891993795E-01],
	[1.7875000000E+04, 9.0485339059E+00, 5.0571173579E+00, 1.1996528296E+00, 8.7578654251E-01, 7.4903144684E-01],
	[1.7880000000E+04, 9.0521636390E+00, 5.0569340747E+00, 1.2007288678E+00, 8.7638840716E-01, 7.4914291764E-01],
	[1.7885000000E+04, 9.0557938126E+00, 5.0567508494E+00, 1.2018055694E+00, 8.7699040223E-01, 7.4925435035E-01],
	[1.7890000000E+04, 9.0594244267E+00, 5.0565676819E+00, 1.2028829347E+00, 8.7759252755E-01, 7.4936574495E-01],
	[1.7895000000E+04, 9.0630554812E+00, 5.0563845723E+00, 1.2039609639E+00, 8.7819478295E-01, 7.4947710146E-01],
	[1.7900000000E+04, 9.0666869760E+00, 5.0562015205E+00, 1.2050396571E+00, 8.7879716829E-01, 7.4958841987E-01],
	[1.7905000000E+04, 9.0703189111E+00, 5.0560185264E+00, 1.2061190147E+00, 8.7939968338E-01, 7.4969970016E-01],
	[1.7910000000E+04, 9.0739512864E+00, 5.0558355900E+00, 1.2071990369E+00, 8.8000232808E-01, 7.4981094235E-01],
	[1.7915000000E+04, 9.0775841018E+00, 5.0556527113E+00, 1.2082797238E+00, 8.8060510222E-01, 7.4992214642E-01],
	[1.7920000000E+04, 9.0812173573E+00, 5.0554698902E+00, 1.2093610757E+00, 8.8120800563E-01, 7.5003331238E-01],
	[1.7925000000E+04, 9.0848510527E+00, 5.0552871268E+00, 1.2104430928E+00, 8.8181103816E-01, 7.5014444021E-01],
	[1.7930000000E+04, 9.0884851880E+00, 5.0551044209E+00, 1.2115257754E+00, 8.8241419964E-01, 7.5025552993E-01],
	[1.7935000000E+04, 9.0921197632E+00, 5.0549217726E+00, 1.2126091236E+00, 8.8301748991E-01, 7.5036658152E-01],
	[1.7940000000E+04, 9.0957547782E+00, 5.0547391818E+00, 1.2136931377E+00, 8.8362090881E-01, 7.5047759497E-01],
	[1.7945000000E+04, 9.0994043684E+00, 5.0545610013E+00, 1.2147778180E+00, 8.8422472286E-01, 7.5058857030E-01],
	[1.7950000000E+04, 9.1030560748E+00, 5.0543833905E+00, 1.2158631645E+00, 8.8482869728E-01, 7.5069950749E-01],
	[1.7955000000E+04, 9.1067082290E+00, 5.0542058354E+00, 1.2169491777E+00, 8.8543280046E-01, 7.5081040655E-01],
	[1.7960000000E+04, 9.1103608309E+00, 5.0540283360E+00, 1.2180358576E+00, 8.8603703224E-01, 7.5092126746E-01],
	[1.7965000000E+04, 9.1140138805E+00, 5.0538508922E+00, 1.2191232045E+00, 8.8664139246E-01, 7.5103209024E-01],
	[1.7970000000E+04, 9.1176673777E+00, 5.0536735041E+00, 1.2202112186E+00, 8.8724588096E-01, 7.5114287486E-01],
	[1.7975000000E+04, 9.1213213224E+00, 5.0534961715E+00, 1.2212999002E+00, 8.8785049756E-01, 7.5125362134E-01],
	[1.7980000000E+04, 9.1249757146E+00, 5.0533188944E+00, 1.2223892495E+00, 8.8845524212E-01, 7.5136432967E-01],
	[1.7985000000E+04, 9.1286305543E+00, 5.0531416729E+00, 1.2234792666E+00, 8.8906011446E-01, 7.5147499984E-01],
	[1.7990000000E+04, 9.1322858412E+00, 5.0529645068E+00, 1.2245699519E+00, 8.8966511443E-01, 7.5158563185E-01],
	[1.7995000000E+04, 9.1359415754E+00, 5.0527873962E+00, 1.2256613055E+00, 8.9027024186E-01, 7.5169622571E-01],
	[1.8000000000E+04, 9.1395977568E+00, 5.0526103410E+00, 1.2267533277E+00, 8.9087549658E-01, 7.5180678140E-01],
	[1.8005000000E+04, 9.1432543853E+00, 5.0524333412E+00, 1.2278460187E+00, 8.9148087845E-01, 7.5191729893E-01],
	[1.8010000000E+04, 9.1469114608E+00, 5.0522563967E+00, 1.2289393787E+00, 8.9208638729E-01, 7.5202777829E-01],
	[1.8015000000E+04, 9.1505689834E+00, 5.0520795075E+00, 1.2300334079E+00, 8.9269202294E-01, 7.5213821948E-01],
	[1.8020000000E+04, 9.1542269528E+00, 5.0519026736E+00, 1.2311281066E+00, 8.9329778524E-01, 7.5224862250E-01],
	[1.8025000000E+04, 9.1578853691E+00, 5.0517258949E+00, 1.2322234749E+00, 8.9390367403E-01, 7.5235898735E-01],
	[1.8030000000E+04, 9.1615442322E+00, 5.0515491715E+00, 1.2333195132E+00, 8.9450968914E-01, 7.5246931402E-01],
	[1.8035000000E+04, 9.1652035420E+00, 5.0513725032E+00, 1.2344162216E+00, 8.9511583041E-01, 7.5257960251E-01],
	[1.8040000000E+04, 9.1688632984E+00, 5.0511958901E+00, 1.2355136003E+00, 8.9572209768E-01, 7.5268985282E-01],
	[1.8045000000E+04, 9.1725235014E+00, 5.0510193321E+00, 1.2366116497E+00, 8.9632849078E-01, 7.5280006494E-01],
	[1.8050000000E+04, 9.1761841508E+00, 5.0508428292E+00, 1.2377103698E+00, 8.9693500955E-01, 7.5291023888E-01],
	[1.8055000000E+04, 9.1798452467E+00, 5.0506663813E+00, 1.2388097609E+00, 8.9754165384E-01, 7.5302037463E-01],
	[1.8060000000E+04, 9.1835067890E+00, 5.0504899885E+00, 1.2399098233E+00, 8.9814842347E-01, 7.5313047218E-01],
	[1.8065000000E+04, 9.1871687775E+00, 5.0503136506E+00, 1.2410105572E+00, 8.9875531828E-01, 7.5324053155E-01],
	[1.8070000000E+04, 9.1908312123E+00, 5.0501373677E+00, 1.2421119628E+00, 8.9936233811E-01, 7.5335055272E-01],
	[1.8075000000E+04, 9.1944940932E+00, 5.0499611397E+00, 1.2432140402E+00, 8.9996948279E-01, 7.5346053569E-01],
	[1.8080000000E+04, 9.1981574202E+00, 5.0497849666E+00, 1.2443167898E+00, 9.0057675217E-01, 7.5357048047E-01],
	[1.8085000000E+04, 9.2018211932E+00, 5.0496088484E+00, 1.2454202118E+00, 9.0118414608E-01, 7.5368038704E-01],
	[1.8090000000E+04, 9.2054854121E+00, 5.0494327850E+00, 1.2465243064E+00, 9.0179166436E-01, 7.5379025541E-01],
	[1.8095000000E+04, 9.2091500769E+00, 5.0492567764E+00, 1.2476290737E+00, 9.0239930684E-01, 7.5390008557E-01],
	[1.8100000000E+04, 9.2128151876E+00, 5.0490808225E+00, 1.2487345141E+00, 9.0300707336E-01, 7.5400987752E-01],
	[1.8105000000E+04, 9.2164807439E+00, 5.0489049234E+00, 1.2498406278E+00, 9.0361496376E-01, 7.5411963127E-01],
	[1.8110000000E+04, 9.2201467459E+00, 5.0487290789E+00, 1.2509474149E+00, 9.0422297787E-01, 7.5422934681E-01],
	[1.8115000000E+04, 9.2238131936E+00, 5.0485532892E+00, 1.2520548758E+00, 9.0483111553E-01, 7.5433902413E-01],
	[1.8120000000E+04, 9.2274800867E+00, 5.0483775540E+00, 1.2531630106E+00, 9.0543937657E-01, 7.5444866323E-01],
	[1.8125000000E+04, 9.2311474253E+00, 5.0482018735E+00, 1.2542718195E+00, 9.0604776084E-01, 7.5455826412E-01],
	[1.8130000000E+04, 9.2348152093E+00, 5.0480262475E+00, 1.2553813028E+00, 9.0665626817E-01, 7.5466782679E-01],
	[1.8135000000E+04, 9.2384834387E+00, 5.0478506761E+00, 1.2564914607E+00, 9.0726489839E-01, 7.5477735124E-01],
	[1.8140000000E+04, 9.2421521132E+00, 5.0476751592E+00, 1.2576022934E+00, 9.0787365135E-01, 7.5488683747E-01],
	[1.8145000000E+04, 9.2458212330E+00, 5.0474996967E+00, 1.2587138011E+00, 9.0848252687E-01, 7.5499628547E-01],
	[1.8150000000E+04, 9.2494907979E+00, 5.0473242887E+00, 1.2598259842E+00, 9.0909152480E-01, 7.5510569525E-01],
	[1.8155000000E+04, 9.2531608078E+00, 5.0471489351E+00, 1.2609388427E+00, 9.0970064498E-01, 7.5521506680E-01],
	[1.8160000000E+04, 9.2568312627E+00, 5.0469736358E+00, 1.2620523769E+00, 9.1030988723E-01, 7.5532440012E-01],
	[1.8165000000E+04, 9.2605021626E+00, 5.0467983909E+00, 1.2631665871E+00, 9.1091925139E-01, 7.5543369521E-01],
	[1.8170000000E+04, 9.2641735072E+00, 5.0466232004E+00, 1.2642814735E+00, 9.1152873730E-01, 7.5554295207E-01],
	[1.8175000000E+04, 9.2678452967E+00, 5.0464480641E+00, 1.2653970362E+00, 9.1213834480E-01, 7.5565217069E-01],
	[1.8180000000E+04, 9.2715175308E+00, 5.0462729820E+00, 1.2665132755E+00, 9.1274807372E-01, 7.5576135108E-01],
	[1.8185000000E+04, 9.2751902096E+00, 5.0460979542E+00, 1.2676301917E+00, 9.1335792390E-01, 7.5587049324E-01],
	[1.8190000000E+04, 9.2788633329E+00, 5.0459229806E+00, 1.2687477849E+00, 9.1396789517E-01, 7.5597959715E-01],
	[1.8195000000E+04, 9.2825369008E+00, 5.0457480611E+00, 1.2698660555E+00, 9.1457798738E-01, 7.5608866282E-01],
	[1.8200000000E+04, 9.2862109131E+00, 5.0455731957E+00, 1.2709850035E+00, 9.1518820035E-01, 7.5619769026E-01],
	[1.8205000000E+04, 9.2898853697E+00, 5.0453983844E+00, 1.2721046292E+00, 9.1579853392E-01, 7.5630667945E-01],
	[1.8210000000E+04, 9.2935602706E+00, 5.0452236272E+00, 1.2732249329E+00, 9.1640898793E-01, 7.5641563040E-01],
	[1.8215000000E+04, 9.2972356158E+00, 5.0450489240E+00, 1.2743459148E+00, 9.1701956222E-01, 7.5652454310E-01],
	[1.8220000000E+04, 9.3009114051E+00, 5.0448742748E+00, 1.2754675751E+00, 9.1763025662E-01, 7.5663341755E-01],
	[1.8225000000E+04, 9.3045876385E+00, 5.0446996796E+00, 1.2765899140E+00, 9.1824107096E-01, 7.5674225376E-01],
	[1.8230000000E+04, 9.3082664229E+00, 5.0445257666E+00, 1.2777129317E+00, 9.1885204646E-01, 7.5685105172E-01],
	[1.8235000000E+04, 9.3119596567E+00, 5.0443560818E+00, 1.2788366286E+00, 9.1946341690E-01, 7.5695981143E-01],
	[1.8240000000E+04, 9.3156533427E+00, 5.0441864493E+00, 1.2799610047E+00, 9.2007490743E-01, 7.5706853289E-01],
	[1.8245000000E+04, 9.3193474809E+00, 5.0440168689E+00, 1.2810860603E+00, 9.2068651789E-01, 7.5717721610E-01],
	[1.8250000000E+04, 9.3230420712E+00, 5.0438473407E+00, 1.2822117957E+00, 9.2129824812E-01, 7.5728586105E-01],
	[1.8255000000E+04, 9.3267371135E+00, 5.0436778646E+00, 1.2833382111E+00, 9.2191009796E-01, 7.5739446775E-01],
	[1.8260000000E+04, 9.3304326077E+00, 5.0435084406E+00, 1.2844653066E+00, 9.2252206723E-01, 7.5750303619E-01],
	[1.8265000000E+04, 9.3341285538E+00, 5.0433390687E+00, 1.2855930826E+00, 9.2313415578E-01, 7.5761156638E-01],
	[1.8270000000E+04, 9.3378249517E+00, 5.0431697489E+00, 1.2867215392E+00, 9.2374636345E-01, 7.5772005831E-01],
	[1.8275000000E+04, 9.3415218014E+00, 5.0430004811E+00, 1.2878506766E+00, 9.2435869006E-01, 7.5782851198E-01],
	[1.8280000000E+04, 9.3452191027E+00, 5.0428312652E+00, 1.2889804952E+00, 9.2497113546E-01, 7.5793692739E-01],
	[1.8285000000E+04, 9.3489168556E+00, 5.0426621013E+00, 1.2901109950E+00, 9.2558369947E-01, 7.5804530454E-01],
	[1.8290000000E+04, 9.3526150601E+00, 5.0424929893E+00, 1.2912421764E+00, 9.2619638195E-01, 7.5815364343E-01],
	[1.8295000000E+04, 9.3563137160E+00, 5.0423239292E+00, 1.2923740396E+00, 9.2680918271E-01, 7.5826194406E-01],
	[1.8300000000E+04, 9.3600128234E+00, 5.0421549210E+00, 1.2935065847E+00, 9.2742210161E-01, 7.5837020643E-01],
	[1.8305000000E+04, 9.3637123821E+00, 5.0419859646E+00, 1.2946398120E+00, 9.2803513847E-01, 7.5847843053E-01],
	[1.8310000000E+04, 9.3674123920E+00, 5.0418170601E+00, 1.2957737218E+00, 9.2864829313E-01, 7.5858661637E-01],
	[1.8315000000E+04, 9.3711128531E+00, 5.0416482073E+00, 1.2969083142E+00, 9.2926156542E-01, 7.5869476394E-01],
	[1.8320000000E+04, 9.3748137654E+00, 5.0414794062E+00, 1.2980435895E+00, 9.2987495519E-01, 7.5880287325E-01],
	[1.8325000000E+04, 9.3785151287E+00, 5.0413106568E+00, 1.2991795479E+00, 9.3048846226E-01, 7.5891094429E-01],
	[1.8330000000E+04, 9.3822169430E+00, 5.0411419592E+00, 1.3003161897E+00, 9.3110208648E-01, 7.5901897706E-01],
	[1.8335000000E+04, 9.3859192082E+00, 5.0409733132E+00, 1.3014535149E+00, 9.3171582767E-01, 7.5912697157E-01],
	[1.8340000000E+04, 9.3896219242E+00, 5.0408047188E+00, 1.3025915240E+00, 9.3232968568E-01, 7.5923492780E-01],
	[1.8345000000E+04, 9.3933250911E+00, 5.0406361760E+00, 1.3037302171E+00, 9.3294366034E-01, 7.5934284577E-01],
	[1.8350000000E+04, 9.3970287087E+00, 5.0404676847E+00, 1.3048695943E+00, 9.3355775149E-01, 7.5945072547E-01],
	[1.8355000000E+04, 9.4007327769E+00, 5.0402992450E+00, 1.3060096561E+00, 9.3417195896E-01, 7.5955856690E-01],
	[1.8360000000E+04, 9.4044372957E+00, 5.0401308568E+00, 1.3071504025E+00, 9.3478628258E-01, 7.5966637006E-01],
	[1.8365000000E+04, 9.4081422650E+00, 5.0399625201E+00, 1.3082918338E+00, 9.3540072220E-01, 7.5977413495E-01],
	[1.8370000000E+04, 9.4118476848E+00, 5.0397942348E+00, 1.3094339502E+00, 9.3601527765E-01, 7.5988186156E-01],
	[1.8375000000E+04, 9.4155535550E+00, 5.0396260010E+00, 1.3105767519E+00, 9.3662994875E-01, 7.5998954991E-01],
	[1.8380000000E+04, 9.4192598754E+00, 5.0394578185E+00, 1.3117202393E+00, 9.3724473536E-01, 7.6009719998E-01],
	[1.8385000000E+04, 9.4229666461E+00, 5.0392896874E+00, 1.3128644124E+00, 9.3785963731E-01, 7.6020481178E-01],
	[1.8390000000E+04, 9.4266738670E+00, 5.0391216076E+00, 1.3140092715E+00, 9.3847465442E-01, 7.6031238531E-01],
	[1.8395000000E+04, 9.4303815380E+00, 5.0389535791E+00, 1.3151548169E+00, 9.3908978654E-01, 7.6041992056E-01],
	[1.8400000000E+04, 9.4340896590E+00, 5.0387856018E+00, 1.3163010487E+00, 9.3970503349E-01, 7.6052741755E-01],
	[1.8405000000E+04, 9.4377982300E+00, 5.0386176758E+00, 1.3174479672E+00, 9.4032039513E-01, 7.6063487625E-01],
	[1.8410000000E+04, 9.4415072509E+00, 5.0384498011E+00, 1.3185955727E+00, 9.4093587127E-01, 7.6074229669E-01],
	[1.8415000000E+04, 9.4452167216E+00, 5.0382819774E+00, 1.3197438653E+00, 9.4155146177E-01, 7.6084967885E-01],
	[1.8420000000E+04, 9.4489266421E+00, 5.0381142050E+00, 1.3208928452E+00, 9.4216716644E-01, 7.6095702274E-01],
	[1.8425000000E+04, 9.4526370123E+00, 5.0379464836E+00, 1.3220425127E+00, 9.4278298513E-01, 7.6106432835E-01],
	[1.8430000000E+04, 9.4563478321E+00, 5.0377788134E+00, 1.3231928681E+00, 9.4339891768E-01, 7.6117159569E-01],
	[1.8435000000E+04, 9.4600591015E+00, 5.0376111942E+00, 1.3243439114E+00, 9.4401496391E-01, 7.6127882475E-01],
	[1.8440000000E+04, 9.4637708204E+00, 5.0374436260E+00, 1.3254956430E+00, 9.4463112366E-01, 7.6138601554E-01],
	[1.8445000000E+04, 9.4674829888E+00, 5.0372761089E+00, 1.3266480632E+00, 9.4524739678E-01, 7.6149316794E-01],
	[1.8450000000E+04, 9.4711956065E+00, 5.0371086427E+00, 1.3278011720E+00, 9.4586378308E-01, 7.6160028168E-01],
	[1.8455000000E+04, 9.4749086735E+00, 5.0369412274E+00, 1.3289549697E+00, 9.4648028241E-01, 7.6170735678E-01],
	[1.8460000000E+04, 9.4786221897E+00, 5.0367738631E+00, 1.3301094566E+00, 9.4709689461E-01, 7.6181439325E-01],
	[1.8465000000E+04, 9.4823361551E+00, 5.0366065497E+00, 1.3312646329E+00, 9.4771361950E-01, 7.6192139110E-01],
	[1.8470000000E+04, 9.4860505695E+00, 5.0364392871E+00, 1.3324204988E+00, 9.4833045693E-01, 7.6202835035E-01],
	[1.8475000000E+04, 9.4897654330E+00, 5.0362720753E+00, 1.3335770545E+00, 9.4894740673E-01, 7.6213527100E-01],
	[1.8480000000E+04, 9.4934807455E+00, 5.0361049143E+00, 1.3347343003E+00, 9.4956446873E-01, 7.6224215308E-01],
	[1.8485000000E+04, 9.4971965068E+00, 5.0359378041E+00, 1.3358922363E+00, 9.5018164276E-01, 7.6234899658E-01],
	[1.8490000000E+04, 9.5009127170E+00, 5.0357707447E+00, 1.3370508629E+00, 9.5079892867E-01, 7.6245580153E-01],
	[1.8495000000E+04, 9.5046293760E+00, 5.0356037359E+00, 1.3382101802E+00, 9.5141632629E-01, 7.6256256793E-01],
	[1.8500000000E+04, 9.5083464836E+00, 5.0354367778E+00, 1.3393701884E+00, 9.5203383545E-01, 7.6266929581E-01],
	[1.8505000000E+04, 9.5120640398E+00, 5.0352698704E+00, 1.3405308878E+00, 9.5265145599E-01, 7.6277598516E-01],
	[1.8510000000E+04, 9.5157820447E+00, 5.0351030136E+00, 1.3416922786E+00, 9.5326918774E-01, 7.6288263601E-01],
	[1.8515000000E+04, 9.5195004980E+00, 5.0349362074E+00, 1.3428543611E+00, 9.5388703054E-01, 7.6298924836E-01],
	[1.8520000000E+04, 9.5232193997E+00, 5.0347694518E+00, 1.3440171353E+00, 9.5450498422E-01, 7.6309582224E-01],
	[1.8525000000E+04, 9.5269459301E+00, 5.0346048195E+00, 1.3451806017E+00, 9.5512319540E-01, 7.6320235764E-01],
	[1.8530000000E+04, 9.5306821553E+00, 5.0344429042E+00, 1.3463447603E+00, 9.5574170648E-01, 7.6330885458E-01],
	[1.8535000000E+04, 9.5344188372E+00, 5.0342810377E+00, 1.3475096115E+00, 9.5636032861E-01, 7.6341531308E-01],
	[1.8540000000E+04, 9.5381559757E+00, 5.0341192202E+00, 1.3486751554E+00, 9.5697906162E-01, 7.6352173315E-01],
	[1.8545000000E+04, 9.5418935706E+00, 5.0339574514E+00, 1.3498413923E+00, 9.5759790535E-01, 7.6362811479E-01],
	[1.8550000000E+04, 9.5456316220E+00, 5.0337957315E+00, 1.3510083224E+00, 9.5821685963E-01, 7.6373445803E-01],
	[1.8555000000E+04, 9.5493701297E+00, 5.0336340603E+00, 1.3521759459E+00, 9.5883592430E-01, 7.6384076288E-01],
	[1.8560000000E+04, 9.5531090938E+00, 5.0334724379E+00, 1.3533442631E+00, 9.5945509920E-01, 7.6394702934E-01],
	[1.8565000000E+04, 9.5568485141E+00, 5.0333108642E+00, 1.3545132741E+00, 9.6007438415E-01, 7.6405325743E-01],
	[1.8570000000E+04, 9.5605883905E+00, 5.0331493392E+00, 1.3556829793E+00, 9.6069377900E-01, 7.6415944716E-01],
	[1.8575000000E+04, 9.5643287231E+00, 5.0329878629E+00, 1.3568533787E+00, 9.6131328357E-01, 7.6426559854E-01],
	[1.8580000000E+04, 9.5680695117E+00, 5.0328264352E+00, 1.3580244727E+00, 9.6193289771E-01, 7.6437171159E-01],
	[1.8585000000E+04, 9.5718107562E+00, 5.0326650561E+00, 1.3591962614E+00, 9.6255262125E-01, 7.6447778632E-01],
	[1.8590000000E+04, 9.5755524567E+00, 5.0325037257E+00, 1.3603687452E+00, 9.6317245402E-01, 7.6458382275E-01],
	[1.8595000000E+04, 9.5792946130E+00, 5.0323424437E+00, 1.3615419242E+00, 9.6379239586E-01, 7.6468982087E-01],
	[1.8600000000E+04, 9.5830372250E+00, 5.0321812103E+00, 1.3627157986E+00, 9.6441244661E-01, 7.6479578071E-01],
	[1.8605000000E+04, 9.5867802928E+00, 5.0320200254E+00, 1.3638903686E+00, 9.6503260609E-01, 7.6490170228E-01],
	[1.8610000000E+04, 9.5905238162E+00, 5.0318588890E+00, 1.3650656346E+00, 9.6565287414E-01, 7.6500758559E-01],
	[1.8615000000E+04, 9.5942677951E+00, 5.0316978010E+00, 1.3662415967E+00, 9.6627325061E-01, 7.6511343065E-01],
	[1.8620000000E+04, 9.5980122296E+00, 5.0315367614E+00, 1.3674182551E+00, 9.6689373532E-01, 7.6521923748E-01],
	[1.8625000000E+04, 9.6017571195E+00, 5.0313757702E+00, 1.3685956101E+00, 9.6751432810E-01, 7.6532500608E-01],
	[1.8630000000E+04, 9.6055024647E+00, 5.0312148274E+00, 1.3697736619E+00, 9.6813502880E-01, 7.6543073648E-01],
	[1.8635000000E+04, 9.6092482653E+00, 5.0310539329E+00, 1.3709524107E+00, 9.6875583725E-01, 7.6553642868E-01],
	[1.8640000000E+04, 9.6129945210E+00, 5.0308930867E+00, 1.3721318567E+00, 9.6937675328E-01, 7.6564208269E-01],
	[1.8645000000E+04, 9.6167412320E+00, 5.0307322888E+00, 1.3733120002E+00, 9.6999777672E-01, 7.6574769853E-01],
	[1.8650000000E+04, 9.6204883980E+00, 5.0305715392E+00, 1.3744928414E+00, 9.7061890742E-01, 7.6585327621E-01],
	[1.8655000000E+04, 9.6242360191E+00, 5.0304108377E+00, 1.3756743806E+00, 9.7124014521E-01, 7.6595881574E-01],
	[1.8660000000E+04, 9.6279840951E+00, 5.0302501845E+00, 1.3768566178E+00, 9.7186148991E-01, 7.6606431714E-01],
	[1.8665000000E+04, 9.6317326260E+00, 5.0300895795E+00, 1.3780395534E+00, 9.7248294138E-01, 7.6616978041E-01],
	[1.8670000000E+04, 9.6354816117E+00, 5.0299290225E+00, 1.3792231876E+00, 9.7310449943E-01, 7.6627520557E-01],
	[1.8675000000E+04, 9.6392310523E+00, 5.0297685138E+00, 1.3804075207E+00, 9.7372616391E-01, 7.6638059263E-01],
	[1.8680000000E+04, 9.6429809475E+00, 5.0296080530E+00, 1.3815925527E+00, 9.7434793466E-01, 7.6648594161E-01],
	[1.8685000000E+04, 9.6467312973E+00, 5.0294476404E+00, 1.3827782840E+00, 9.7496981149E-01, 7.6659125251E-01],
	[1.8690000000E+04, 9.6504821017E+00, 5.0292872758E+00, 1.3839647149E+00, 9.7559179426E-01, 7.6669652535E-01],
	[1.8695000000E+04, 9.6542333606E+00, 5.0291269592E+00, 1.3851518454E+00, 9.7621388279E-01, 7.6680176015E-01],
	[1.8700000000E+04, 9.6579850739E+00, 5.0289666906E+00, 1.3863396759E+00, 9.7683607692E-01, 7.6690695690E-01],
	[1.8705000000E+04, 9.6617372416E+00, 5.0288064699E+00, 1.3875282065E+00, 9.7745837648E-01, 7.6701211564E-01],
	[1.8710000000E+04, 9.6654898636E+00, 5.0286462971E+00, 1.3887174375E+00, 9.7808078132E-01, 7.6711723636E-01],
	[1.8715000000E+04, 9.6692429398E+00, 5.0284861723E+00, 1.3899073691E+00, 9.7870329125E-01, 7.6722231908E-01],
	[1.8720000000E+04, 9.6729964702E+00, 5.0283260953E+00, 1.3910980016E+00, 9.7932590612E-01, 7.6732736381E-01],
	[1.8725000000E+04, 9.6767504547E+00, 5.0281660662E+00, 1.3922893352E+00, 9.7994862576E-01, 7.6743237057E-01],
	[1.8730000000E+04, 9.6805048932E+00, 5.0280060848E+00, 1.3934813700E+00, 9.8057145001E-01, 7.6753733937E-01],
	[1.8735000000E+04, 9.6842597857E+00, 5.0278461513E+00, 1.3946741063E+00, 9.8119437871E-01, 7.6764227022E-01],
	[1.8740000000E+04, 9.6880151321E+00, 5.0276862655E+00, 1.3958675444E+00, 9.8181741167E-01, 7.6774716313E-01],
	[1.8745000000E+04, 9.6917709323E+00, 5.0275264275E+00, 1.3970616844E+00, 9.8244054875E-01, 7.6785201811E-01],
	[1.8750000000E+04, 9.6955271863E+00, 5.0273666372E+00, 1.3982565267E+00, 9.8306378977E-01, 7.6795683518E-01],
	[1.8755000000E+04, 9.6992838939E+00, 5.0272068945E+00, 1.3994520713E+00, 9.8368713457E-01, 7.6806161436E-01],
	[1.8760000000E+04, 9.7030410553E+00, 5.0270471996E+00, 1.4006483186E+00, 9.8431058298E-01, 7.6816635564E-01],
	[1.8765000000E+04, 9.7067986701E+00, 5.0268875522E+00, 1.4018452688E+00, 9.8493413484E-01, 7.6827105905E-01],
	[1.8770000000E+04, 9.7105567385E+00, 5.0267279524E+00, 1.4030429220E+00, 9.8555778998E-01, 7.6837572460E-01],
	[1.8775000000E+04, 9.7143152603E+00, 5.0265684003E+00, 1.4042412785E+00, 9.8618154824E-01, 7.6848035229E-01],
	[1.8780000000E+04, 9.7180742355E+00, 5.0264088956E+00, 1.4054403386E+00, 9.8680540944E-01, 7.6858494215E-01],
	[1.8785000000E+04, 9.7218336640E+00, 5.0262494385E+00, 1.4066401025E+00, 9.8742937344E-01, 7.6868949418E-01],
	[1.8790000000E+04, 9.7255935458E+00, 5.0260900289E+00, 1.4078405703E+00, 9.8805344005E-01, 7.6879400840E-01],
	[1.8795000000E+04, 9.7293538807E+00, 5.0259306667E+00, 1.4090417424E+00, 9.8867760912E-01, 7.6889848481E-01],
	[1.8800000000E+04, 9.7331146687E+00, 5.0257713520E+00, 1.4102436189E+00, 9.8930188047E-01, 7.6900292344E-01],
	[1.8805000000E+04, 9.7368759097E+00, 5.0256120847E+00, 1.4114462001E+00, 9.8992625395E-01, 7.6910732430E-01],
	[1.8810000000E+04, 9.7406376037E+00, 5.0254528648E+00, 1.4126494861E+00, 9.9055072938E-01, 7.6921168738E-01],
	[1.8815000000E+04, 9.7443997507E+00, 5.0252936922E+00, 1.4138534773E+00, 9.9117530660E-01, 7.6931601272E-01],
	[1.8820000000E+04, 9.7481623505E+00, 5.0251345670E+00, 1.4150581738E+00, 9.9179998545E-01, 7.6942030032E-01],
	[1.8825000000E+04, 9.7519387755E+00, 5.0249792263E+00, 1.4162635759E+00, 9.9242505003E-01, 7.6952455019E-01],
	[1.8830000000E+04, 9.7557190279E+00, 5.0248248726E+00, 1.4174696838E+00, 9.9305028808E-01, 7.6962876235E-01],
	[1.8835000000E+04, 9.7594997415E+00, 5.0246705646E+00, 1.4186764976E+00, 9.9367562794E-01, 7.6973293680E-01],
	[1.8840000000E+04, 9.7632809161E+00, 5.0245163022E+00, 1.4198840178E+00, 9.9430106945E-01, 7.6983707357E-01],
	[1.8845000000E+04, 9.7670625518E+00, 5.0243620856E+00, 1.4210922444E+00, 9.9492661243E-01, 7.6994117266E-01],
	[1.8850000000E+04, 9.7708446484E+00, 5.0242079145E+00, 1.4223011777E+00, 9.9555225672E-01, 7.7004523409E-01],
	[1.8855000000E+04, 9.7746272059E+00, 5.0240537891E+00, 1.4235108179E+00, 9.9617800216E-01, 7.7014925786E-01],
	[1.8860000000E+04, 9.7784102242E+00, 5.0238997093E+00, 1.4247211652E+00, 9.9680384858E-01, 7.7025324399E-01],
	[1.8865000000E+04, 9.7821937033E+00, 5.0237456751E+00, 1.4259322199E+00, 9.9742979582E-01, 7.7035719250E-01],
	[1.8870000000E+04, 9.7859776430E+00, 5.0235916864E+00, 1.4271439822E+00, 9.9805584371E-01, 7.7046110339E-01],
	[1.8875000000E+04, 9.7897620434E+00, 5.0234377432E+00, 1.4283564524E+00, 9.9868199208E-01, 7.7056497668E-01],
	[1.8880000000E+04, 9.7935469043E+00, 5.0232838455E+00, 1.4295696305E+00, 9.9930824077E-01, 7.7066881238E-01],
	[1.8885000000E+04, 9.7973322257E+00, 5.0231299932E+00, 1.4307835170E+00, 9.9993458961E-01, 7.7077261050E-01],
	[1.8890000000E+04, 9.8011180075E+00, 5.0229761864E+00, 1.4319981119E+00, 1.0005610384E+00, 7.7087637105E-01],
	[1.8895000000E+04, 9.8049042497E+00, 5.0228224250E+00, 1.4332134156E+00, 1.0011875871E+00, 7.7098009406E-01],
	[1.8900000000E+04, 9.8086909521E+00, 5.0226687090E+00, 1.4344294282E+00, 1.0018142354E+00, 7.7108377952E-01],
	[1.8905000000E+04, 9.8124781148E+00, 5.0225150384E+00, 1.4356461500E+00, 1.0024409832E+00, 7.7118742745E-01],
	[1.8910000000E+04, 9.8162657377E+00, 5.0223614131E+00, 1.4368635811E+00, 1.0030678304E+00, 7.7129103787E-01],
	[1.8915000000E+04, 9.8200538206E+00, 5.0222078331E+00, 1.4380817219E+00, 1.0036947766E+00, 7.7139461079E-01],
	[1.8920000000E+04, 9.8238423636E+00, 5.0220542984E+00, 1.4393005726E+00, 1.0043218219E+00, 7.7149814622E-01],
	[1.8925000000E+04, 9.8276313665E+00, 5.0219008090E+00, 1.4405201333E+00, 1.0049489661E+00, 7.7160164416E-01],
	[1.8930000000E+04, 9.8314208293E+00, 5.0217473648E+00, 1.4417404043E+00, 1.0055762088E+00, 7.7170510464E-01],
	[1.8935000000E+04, 9.8352107519E+00, 5.0215939658E+00, 1.4429613858E+00, 1.0062035501E+00, 7.7180852767E-01],
	[1.8940000000E+04, 9.8390011343E+00, 5.0214406120E+00, 1.4441830781E+00, 1.0068309897E+00, 7.7191191326E-01],
	[1.8945000000E+04, 9.8427919764E+00, 5.0212873033E+00, 1.4454054814E+00, 1.0074585275E+00, 7.7201526142E-01],
	[1.8950000000E+04, 9.8465832782E+00, 5.0211340398E+00, 1.4466285958E+00, 1.0080861633E+00, 7.7211857216E-01],
	[1.8955000000E+04, 9.8503750394E+00, 5.0209808214E+00, 1.4478524217E+00, 1.0087138969E+00, 7.7222184550E-01],
	[1.8960000000E+04, 9.8541672602E+00, 5.0208276481E+00, 1.4490769593E+00, 1.0093417282E+00, 7.7232508144E-01],
	[1.8965000000E+04, 9.8579599405E+00, 5.0206745198E+00, 1.4503022087E+00, 1.0099696570E+00, 7.7242828001E-01],
	[1.8970000000E+04, 9.8617530801E+00, 5.0205214366E+00, 1.4515281702E+00, 1.0105976832E+00, 7.7253144121E-01],
	[1.8975000000E+04, 9.8655466790E+00, 5.0203683984E+00, 1.4527548440E+00, 1.0112258065E+00, 7.7263456506E-01],
	[1.8980000000E+04, 9.8693407371E+00, 5.0202154052E+00, 1.4539822304E+00, 1.0118540268E+00, 7.7273765157E-01],
	[1.8985000000E+04, 9.8731352544E+00, 5.0200624569E+00, 1.4552103296E+00, 1.0124823440E+00, 7.7284070074E-01],
	[1.8990000000E+04, 9.8769302308E+00, 5.0199095536E+00, 1.4564391418E+00, 1.0131107579E+00, 7.7294371260E-01],
	[1.8995000000E+04, 9.8807256663E+00, 5.0197566951E+00, 1.4576686672E+00, 1.0137392682E+00, 7.7304668716E-01],
	[1.9000000000E+04, 9.8845215607E+00, 5.0196038816E+00, 1.4588989061E+00, 1.0143678749E+00, 7.7314962442E-01],
	[1.9005000000E+04, 9.8883179141E+00, 5.0194511129E+00, 1.4601298586E+00, 1.0149965778E+00, 7.7325252440E-01],
	[1.9010000000E+04, 9.8921147263E+00, 5.0192983891E+00, 1.4613615251E+00, 1.0156253767E+00, 7.7335538712E-01],
	[1.9015000000E+04, 9.8959119972E+00, 5.0191457100E+00, 1.4625939057E+00, 1.0162542715E+00, 7.7345821258E-01],
	[1.9020000000E+04, 9.8997097269E+00, 5.0189930758E+00, 1.4638270006E+00, 1.0168832619E+00, 7.7356100080E-01],
	[1.9025000000E+04, 9.9035079153E+00, 5.0188404863E+00, 1.4650608102E+00, 1.0175123479E+00, 7.7366375179E-01],
	[1.9030000000E+04, 9.9073065622E+00, 5.0186879415E+00, 1.4662953345E+00, 1.0181415292E+00, 7.7376646556E-01],
	[1.9035000000E+04, 9.9111056676E+00, 5.0185354414E+00, 1.4675305739E+00, 1.0187708057E+00, 7.7386914213E-01],
	[1.9040000000E+04, 9.9149052315E+00, 5.0183829861E+00, 1.4687665286E+00, 1.0194001772E+00, 7.7397178151E-01],
	[1.9045000000E+04, 9.9187052538E+00, 5.0182305754E+00, 1.4700031987E+00, 1.0200296436E+00, 7.7407438370E-01],
	[1.9050000000E+04, 9.9225057344E+00, 5.0180782093E+00, 1.4712405845E+00, 1.0206592046E+00, 7.7417694873E-01],
	[1.9055000000E+04, 9.9263066733E+00, 5.0179258878E+00, 1.4724786863E+00, 1.0212888602E+00, 7.7427947662E-01],
	[1.9060000000E+04, 9.9301080704E+00, 5.0177736109E+00, 1.4737175043E+00, 1.0219186102E+00, 7.7438196736E-01],
	[1.9065000000E+04, 9.9339099256E+00, 5.0176213786E+00, 1.4749570386E+00, 1.0225484543E+00, 7.7448442096E-01],
	[1.9070000000E+04, 9.9377122388E+00, 5.0174691908E+00, 1.4761972896E+00, 1.0231783925E+00, 7.7458683741E-01],
	[1.9075000000E+04, 9.9415150101E+00, 5.0173170476E+00, 1.4774382574E+00, 1.0238084245E+00, 7.7468921671E-01],
	[1.9080000000E+04, 9.9453182393E+00, 5.0171649488E+00, 1.4786799422E+00, 1.0244385503E+00, 7.7479155886E-01],
	[1.9085000000E+04, 9.9491219263E+00, 5.0170128945E+00, 1.4799223444E+00, 1.0250687695E+00, 7.7489386386E-01],
	[1.9090000000E+04, 9.9529260712E+00, 5.0168608846E+00, 1.4811654641E+00, 1.0256990821E+00, 7.7499613171E-01],
	[1.9095000000E+04, 9.9567306738E+00, 5.0167089191E+00, 1.4824093015E+00, 1.0263294880E+00, 7.7509836241E-01],
	[1.9100000000E+04, 9.9605357341E+00, 5.0165569980E+00, 1.4836538569E+00, 1.0269599868E+00, 7.7520055596E-01],
	[1.9105000000E+04, 9.9643412520E+00, 5.0164051213E+00, 1.4848991305E+00, 1.0275905785E+00, 7.7530271235E-01],
	[1.9110000000E+04, 9.9681472275E+00, 5.0162532889E+00, 1.4861451225E+00, 1.0282212630E+00, 7.7540483159E-01],
	[1.9115000000E+04, 9.9719536604E+00, 5.0161015009E+00, 1.4873918331E+00, 1.0288520399E+00, 7.7550691368E-01],
	[1.9120000000E+04, 9.9757605507E+00, 5.0159497571E+00, 1.4886392627E+00, 1.0294829092E+00, 7.7560895861E-01],
	[1.9125000000E+04, 9.9795713162E+00, 5.0157989827E+00, 1.4898874113E+00, 1.0301139462E+00, 7.7571096639E-01],
	[1.9130000000E+04, 9.9833961860E+00, 5.0156519444E+00, 1.4911362793E+00, 1.0307453767E+00, 7.7581293701E-01],
	[1.9135000000E+04, 9.9872215215E+00, 5.0155049487E+00, 1.4923858668E+00, 1.0313768998E+00, 7.7591487048E-01],
	[1.9140000000E+04, 9.9910473228E+00, 5.0153579958E+00, 1.4936361741E+00, 1.0320085154E+00, 7.7601676679E-01],
	[1.9145000000E+04, 9.9948735898E+00, 5.0152110856E+00, 1.4948872014E+00, 1.0326402231E+00, 7.7611862595E-01],
	[1.9150000000E+04, 9.9987003225E+00, 5.0150642181E+00, 1.4961389489E+00, 1.0332720229E+00, 7.7622044794E-01],
	[1.9155000000E+04, 1.0002527521E+01, 5.0149173931E+00, 1.4973914169E+00, 1.0339039146E+00, 7.7632223278E-01],
	[1.9160000000E+04, 1.0006355184E+01, 5.0147706108E+00, 1.4986446056E+00, 1.0345358981E+00, 7.7642398047E-01],
	[1.9165000000E+04, 1.0010183313E+01, 5.0146238711E+00, 1.4998985152E+00, 1.0351679732E+00, 7.7652569099E-01],
	[1.9170000000E+04, 1.0014011908E+01, 5.0144771740E+00, 1.5011531459E+00, 1.0358001396E+00, 7.7662736436E-01],
	[1.9175000000E+04, 1.0017840967E+01, 5.0143305194E+00, 1.5024084980E+00, 1.0364323974E+00, 7.7672900056E-01],
	[1.9180000000E+04, 1.0021670492E+01, 5.0141839074E+00, 1.5036645716E+00, 1.0370647461E+00, 7.7683059961E-01],
	[1.9185000000E+04, 1.0025500482E+01, 5.0140373378E+00, 1.5049213671E+00, 1.0376971859E+00, 7.7693216150E-01],
	[1.9190000000E+04, 1.0029330938E+01, 5.0138908107E+00, 1.5061788846E+00, 1.0383297163E+00, 7.7703368623E-01],
	[1.9195000000E+04, 1.0033161858E+01, 5.0137443261E+00, 1.5074371244E+00, 1.0389623374E+00, 7.7713517380E-01],
	[1.9200000000E+04, 1.0036993243E+01, 5.0135978839E+00, 1.5086960867E+00, 1.0395950489E+00, 7.7723662421E-01],
	[1.9205000000E+04, 1.0040825093E+01, 5.0134514841E+00, 1.5099557717E+00, 1.0402278506E+00, 7.7733803747E-01],
	[1.9210000000E+04, 1.0044657408E+01, 5.0133051267E+00, 1.5112161796E+00, 1.0408607424E+00, 7.7743941356E-01],
	[1.9215000000E+04, 1.0048490188E+01, 5.0131588116E+00, 1.5124773107E+00, 1.0414937241E+00, 7.7754075249E-01],
	[1.9220000000E+04, 1.0052323432E+01, 5.0130125389E+00, 1.5137391652E+00, 1.0421267956E+00, 7.7764205427E-01],
	[1.9225000000E+04, 1.0056157141E+01, 5.0128663085E+00, 1.5150017433E+00, 1.0427599567E+00, 7.7774331888E-01],
	[1.9230000000E+04, 1.0059991315E+01, 5.0127201204E+00, 1.5162650453E+00, 1.0433932073E+00, 7.7784454634E-01],
	[1.9235000000E+04, 1.0063825953E+01, 5.0125739745E+00, 1.5175290713E+00, 1.0440265471E+00, 7.7794573664E-01],
	[1.9240000000E+04, 1.0067661056E+01, 5.0124278709E+00, 1.5187938217E+00, 1.0446599760E+00, 7.7804688977E-01],
	[1.9245000000E+04, 1.0071496623E+01, 5.0122818095E+00, 1.5200592965E+00, 1.0452934938E+00, 7.7814800575E-01],
	[1.9250000000E+04, 1.0075332654E+01, 5.0121357904E+00, 1.5213254961E+00, 1.0459271004E+00, 7.7824908457E-01],
	[1.9255000000E+04, 1.0079169149E+01, 5.0119898134E+00, 1.5225924207E+00, 1.0465607956E+00, 7.7835012623E-01],
	[1.9260000000E+04, 1.0083006109E+01, 5.0118438785E+00, 1.5238600705E+00, 1.0471945792E+00, 7.7845113074E-01],
	[1.9265000000E+04, 1.0086843533E+01, 5.0116979858E+00, 1.5251284458E+00, 1.0478284511E+00, 7.7855209808E-01],
	[1.9270000000E+04, 1.0090681421E+01, 5.0115521351E+00, 1.5263975467E+00, 1.0484624111E+00, 7.7865302827E-01],
	[1.9275000000E+04, 1.0094519773E+01, 5.0114063266E+00, 1.5276673734E+00, 1.0490964591E+00, 7.7875392130E-01],
	[1.9280000000E+04, 1.0098358589E+01, 5.0112605601E+00, 1.5289379263E+00, 1.0497305948E+00, 7.7885477717E-01],
	[1.9285000000E+04, 1.0102197868E+01, 5.0111148357E+00, 1.5302092055E+00, 1.0503648181E+00, 7.7895559588E-01],
	[1.9290000000E+04, 1.0106037612E+01, 5.0109691532E+00, 1.5314812113E+00, 1.0509991289E+00, 7.7905637744E-01],
	[1.9295000000E+04, 1.0109877819E+01, 5.0108235128E+00, 1.5327539439E+00, 1.0516335270E+00, 7.7915712185E-01],
	[1.9300000000E+04, 1.0113718490E+01, 5.0106779143E+00, 1.5340274035E+00, 1.0522680122E+00, 7.7925782909E-01],
	[1.9305000000E+04, 1.0117559625E+01, 5.0105323578E+00, 1.5353015903E+00, 1.0529025843E+00, 7.7935849919E-01],
	[1.9310000000E+04, 1.0121401223E+01, 5.0103868432E+00, 1.5365765046E+00, 1.0535372432E+00, 7.7945913212E-01],
	[1.9315000000E+04, 1.0125243285E+01, 5.0102413705E+00, 1.5378521466E+00, 1.0541719887E+00, 7.7955972791E-01],
	[1.9320000000E+04, 1.0129085810E+01, 5.0100959396E+00, 1.5391285165E+00, 1.0548068207E+00, 7.7966028654E-01],
	[1.9325000000E+04, 1.0132928798E+01, 5.0099505506E+00, 1.5404056146E+00, 1.0554417390E+00, 7.7976080802E-01],
	[1.9330000000E+04, 1.0136772250E+01, 5.0098052035E+00, 1.5416834410E+00, 1.0560767434E+00, 7.7986129234E-01],
	[1.9335000000E+04, 1.0140616165E+01, 5.0096598981E+00, 1.5429619961E+00, 1.0567118337E+00, 7.7996173952E-01],
	[1.9340000000E+04, 1.0144460543E+01, 5.0095146345E+00, 1.5442412799E+00, 1.0573470099E+00, 7.8006214954E-01],
	[1.9345000000E+04, 1.0148305384E+01, 5.0093694127E+00, 1.5455212928E+00, 1.0579822716E+00, 7.8016252241E-01],
	[1.9350000000E+04, 1.0152150688E+01, 5.0092242327E+00, 1.5468020350E+00, 1.0586176189E+00, 7.8026285813E-01],
	[1.9355000000E+04, 1.0155996455E+01, 5.0090790943E+00, 1.5480835067E+00, 1.0592530514E+00, 7.8036315671E-01],
	[1.9360000000E+04, 1.0159842685E+01, 5.0089339977E+00, 1.5493657082E+00, 1.0598885690E+00, 7.8046341814E-01],
	[1.9365000000E+04, 1.0163689378E+01, 5.0087889427E+00, 1.5506486396E+00, 1.0605241717E+00, 7.8056364242E-01],
	[1.9370000000E+04, 1.0167536534E+01, 5.0086439293E+00, 1.5519323011E+00, 1.0611598591E+00, 7.8066382955E-01],
	[1.9375000000E+04, 1.0171384152E+01, 5.0084989576E+00, 1.5532166931E+00, 1.0617956311E+00, 7.8076397954E-01],
	[1.9380000000E+04, 1.0175232233E+01, 5.0083540275E+00, 1.5545018158E+00, 1.0624314877E+00, 7.8086409238E-01],
	[1.9385000000E+04, 1.0179080777E+01, 5.0082091389E+00, 1.5557876692E+00, 1.0630674285E+00, 7.8096416808E-01],
	[1.9390000000E+04, 1.0182929783E+01, 5.0080642920E+00, 1.5570742538E+00, 1.0637034535E+00, 7.8106420663E-01],
	[1.9395000000E+04, 1.0186779252E+01, 5.0079194865E+00, 1.5583615697E+00, 1.0643395624E+00, 7.8116420805E-01],
	[1.9400000000E+04, 1.0190629183E+01, 5.0077747226E+00, 1.5596496172E+00, 1.0649757552E+00, 7.8126417232E-01],
	[1.9405000000E+04, 1.0194479576E+01, 5.0076300001E+00, 1.5609383964E+00, 1.0656120316E+00, 7.8136409946E-01],
	[1.9410000000E+04, 1.0198330432E+01, 5.0074853191E+00, 1.5622279076E+00, 1.0662483914E+00, 7.8146398945E-01],
	[1.9415000000E+04, 1.0202181750E+01, 5.0073406796E+00, 1.5635181510E+00, 1.0668848346E+00, 7.8156384231E-01],
	[1.9420000000E+04, 1.0206033530E+01, 5.0071960815E+00, 1.5648091269E+00, 1.0675213609E+00, 7.8166365803E-01],
	[1.9425000000E+04, 1.0209885772E+01, 5.0070515248E+00, 1.5661008355E+00, 1.0681579703E+00, 7.8176343661E-01],
	[1.9430000000E+04, 1.0213738476E+01, 5.0069070094E+00, 1.5673932770E+00, 1.0687946624E+00, 7.8186317806E-01],
	[1.9435000000E+04, 1.0217602533E+01, 5.0067653897E+00, 1.5686864516E+00, 1.0694316867E+00, 7.8196288238E-01],
	[1.9440000000E+04, 1.0221473558E+01, 5.0066255134E+00, 1.5699803595E+00, 1.0700689430E+00, 7.8206254957E-01],
	[1.9445000000E+04, 1.0225345053E+01, 5.0064856770E+00, 1.5712750011E+00, 1.0707062823E+00, 7.8216217962E-01],
	[1.9450000000E+04, 1.0229217019E+01, 5.0063458804E+00, 1.5725703764E+00, 1.0713437045E+00, 7.8226177255E-01],
	[1.9455000000E+04, 1.0233089455E+01, 5.0062061237E+00, 1.5738664858E+00, 1.0719812094E+00, 7.8236132834E-01],
	[1.9460000000E+04, 1.0236962362E+01, 5.0060664068E+00, 1.5751633295E+00, 1.0726187969E+00, 7.8246084701E-01],
	[1.9465000000E+04, 1.0240835738E+01, 5.0059267297E+00, 1.5764609076E+00, 1.0732564667E+00, 7.8256032856E-01],
	[1.9470000000E+04, 1.0244709585E+01, 5.0057870923E+00, 1.5777592205E+00, 1.0738942187E+00, 7.8265977298E-01],
	[1.9475000000E+04, 1.0248583902E+01, 5.0056474947E+00, 1.5790582683E+00, 1.0745320528E+00, 7.8275918027E-01],
	[1.9480000000E+04, 1.0252458689E+01, 5.0055079369E+00, 1.5803580513E+00, 1.0751699688E+00, 7.8285855045E-01],
	[1.9485000000E+04, 1.0256333946E+01, 5.0053684187E+00, 1.5816585696E+00, 1.0758079664E+00, 7.8295788350E-01],
	[1.9490000000E+04, 1.0260209673E+01, 5.0052289402E+00, 1.5829598236E+00, 1.0764460457E+00, 7.8305717944E-01],
	[1.9495000000E+04, 1.0264085870E+01, 5.0050895014E+00, 1.5842618135E+00, 1.0770842063E+00, 7.8315643826E-01],
	[1.9500000000E+04, 1.0267962536E+01, 5.0049501022E+00, 1.5855645394E+00, 1.0777224481E+00, 7.8325565996E-01],
	[1.9505000000E+04, 1.0271839673E+01, 5.0048107426E+00, 1.5868680016E+00, 1.0783607711E+00, 7.8335484455E-01],
	[1.9510000000E+04, 1.0275717279E+01, 5.0046714227E+00, 1.5881722004E+00, 1.0789991749E+00, 7.8345399203E-01],
	[1.9515000000E+04, 1.0279595354E+01, 5.0045321423E+00, 1.5894771359E+00, 1.0796376594E+00, 7.8355310239E-01],
	[1.9520000000E+04, 1.0283473899E+01, 5.0043929015E+00, 1.5907828084E+00, 1.0802762245E+00, 7.8365217565E-01],
	[1.9525000000E+04, 1.0287352914E+01, 5.0042537002E+00, 1.5920892182E+00, 1.0809148700E+00, 7.8375121180E-01],
	[1.9530000000E+04, 1.0291232398E+01, 5.0041145384E+00, 1.5933963653E+00, 1.0815535957E+00, 7.8385021084E-01],
	[1.9535000000E+04, 1.0295112352E+01, 5.0039754161E+00, 1.5947042502E+00, 1.0821924015E+00, 7.8394917278E-01],
	[1.9540000000E+04, 1.0298992774E+01, 5.0038363333E+00, 1.5960128729E+00, 1.0828312872E+00, 7.8404809762E-01],
	[1.9545000000E+04, 1.0302873666E+01, 5.0036972899E+00, 1.5973222337E+00, 1.0834702527E+00, 7.8414698535E-01],
	[1.9550000000E+04, 1.0306755027E+01, 5.0035582860E+00, 1.5986323329E+00, 1.0841092977E+00, 7.8424583599E-01],
	[1.9555000000E+04, 1.0310636857E+01, 5.0034193214E+00, 1.5999431707E+00, 1.0847484222E+00, 7.8434464952E-01],
	[1.9560000000E+04, 1.0314519157E+01, 5.0032803963E+00, 1.6012547472E+00, 1.0853876259E+00, 7.8444342597E-01],
	[1.9565000000E+04, 1.0318401925E+01, 5.0031415105E+00, 1.6025670628E+00, 1.0860269086E+00, 7.8454216531E-01],
	[1.9570000000E+04, 1.0322285162E+01, 5.0030026641E+00, 1.6038801176E+00, 1.0866662703E+00, 7.8464086757E-01],
	[1.9575000000E+04, 1.0326168868E+01, 5.0028638569E+00, 1.6051939120E+00, 1.0873057108E+00, 7.8473953274E-01],
	[1.9580000000E+04, 1.0330053043E+01, 5.0027250891E+00, 1.6065084460E+00, 1.0879452298E+00, 7.8483816081E-01],
	[1.9585000000E+04, 1.0333937686E+01, 5.0025863606E+00, 1.6078237200E+00, 1.0885848273E+00, 7.8493675180E-01],
	[1.9590000000E+04, 1.0337822798E+01, 5.0024476713E+00, 1.6091397341E+00, 1.0892245030E+00, 7.8503530571E-01],
	[1.9595000000E+04, 1.0341708379E+01, 5.0023090212E+00, 1.6104564886E+00, 1.0898642568E+00, 7.8513382254E-01],
	[1.9600000000E+04, 1.0345594428E+01, 5.0021704104E+00, 1.6117739837E+00, 1.0905040886E+00, 7.8523230228E-01],
	[1.9605000000E+04, 1.0349480946E+01, 5.0020318388E+00, 1.6130922197E+00, 1.0911439981E+00, 7.8533074495E-01],
	[1.9610000000E+04, 1.0353367932E+01, 5.0018933063E+00, 1.6144111968E+00, 1.0917839852E+00, 7.8542915054E-01],
	[1.9615000000E+04, 1.0357255387E+01, 5.0017548130E+00, 1.6157309151E+00, 1.0924240498E+00, 7.8552751905E-01],
	[1.9620000000E+04, 1.0361143309E+01, 5.0016163588E+00, 1.6170513750E+00, 1.0930641916E+00, 7.8562585050E-01],
	[1.9625000000E+04, 1.0365031700E+01, 5.0014779437E+00, 1.6183725766E+00, 1.0937044106E+00, 7.8572414487E-01],
	[1.9630000000E+04, 1.0368920559E+01, 5.0013395678E+00, 1.6196945202E+00, 1.0943447064E+00, 7.8582240218E-01],
	[1.9635000000E+04, 1.0372809887E+01, 5.0012012309E+00, 1.6210172060E+00, 1.0949850791E+00, 7.8592062242E-01],
	[1.9640000000E+04, 1.0376699682E+01, 5.0010629330E+00, 1.6223406342E+00, 1.0956255284E+00, 7.8601880560E-01],
	[1.9645000000E+04, 1.0380589945E+01, 5.0009246742E+00, 1.6236648051E+00, 1.0962660541E+00, 7.8611695171E-01],
	[1.9650000000E+04, 1.0384480676E+01, 5.0007864543E+00, 1.6249897189E+00, 1.0969066561E+00, 7.8621506077E-01],
	[1.9655000000E+04, 1.0388371875E+01, 5.0006482735E+00, 1.6263153758E+00, 1.0975473343E+00, 7.8631313277E-01],
	[1.9660000000E+04, 1.0392263542E+01, 5.0005101316E+00, 1.6276417761E+00, 1.0981880884E+00, 7.8641116772E-01],
	[1.9665000000E+04, 1.0396155676E+01, 5.0003720286E+00, 1.6289689199E+00, 1.0988289183E+00, 7.8650916561E-01],
	[1.9670000000E+04, 1.0400048278E+01, 5.0002339646E+00, 1.6302968075E+00, 1.0994698238E+00, 7.8660712646E-01],
	[1.9675000000E+04, 1.0403941348E+01, 5.0000959395E+00, 1.6316254391E+00, 1.1001108048E+00, 7.8670505026E-01],
	[1.9680000000E+04, 1.0407834885E+01, 4.9999579533E+00, 1.6329548150E+00, 1.1007518610E+00, 7.8680293701E-01],
	[1.9685000000E+04, 1.0411728890E+01, 4.9998200059E+00, 1.6342849353E+00, 1.1013929925E+00, 7.8690078672E-01],
	[1.9690000000E+04, 1.0415623362E+01, 4.9996820974E+00, 1.6356158004E+00, 1.1020341988E+00, 7.8699859939E-01],
	[1.9695000000E+04, 1.0419518301E+01, 4.9995442276E+00, 1.6369474104E+00, 1.1026754800E+00, 7.8709637502E-01],
	[1.9700000000E+04, 1.0423413708E+01, 4.9994063967E+00, 1.6382797655E+00, 1.1033168359E+00, 7.8719411362E-01],
	[1.9705000000E+04, 1.0427309582E+01, 4.9992686046E+00, 1.6396128661E+00, 1.1039582662E+00, 7.8729181518E-01],
	[1.9710000000E+04, 1.0431205923E+01, 4.9991308512E+00, 1.6409467122E+00, 1.1045997708E+00, 7.8738947972E-01],
	[1.9715000000E+04, 1.0435102731E+01, 4.9989931365E+00, 1.6422813042E+00, 1.1052413496E+00, 7.8748710723E-01],
	[1.9720000000E+04, 1.0439000006E+01, 4.9988554606E+00, 1.6436166423E+00, 1.1058830024E+00, 7.8758469771E-01],
	[1.9725000000E+04, 1.0442897748E+01, 4.9987178233E+00, 1.6449527266E+00, 1.1065247290E+00, 7.8768225117E-01],
	[1.9730000000E+04, 1.0446795957E+01, 4.9985802248E+00, 1.6462895575E+00, 1.1071665292E+00, 7.8777976761E-01],
	[1.9735000000E+04, 1.0450694633E+01, 4.9984426648E+00, 1.6476271351E+00, 1.1078084029E+00, 7.8787724703E-01],
	[1.9740000000E+04, 1.0454593776E+01, 4.9983051435E+00, 1.6489654597E+00, 1.1084503500E+00, 7.8797468944E-01],
	[1.9745000000E+04, 1.0458494465E+01, 4.9981679351E+00, 1.6503045315E+00, 1.1090923959E+00, 7.8807209484E-01],
	[1.9750000000E+04, 1.0462412267E+01, 4.9980349891E+00, 1.6516443508E+00, 1.1097349103E+00, 7.8816946323E-01],
	[1.9755000000E+04, 1.0466330545E+01, 4.9979020804E+00, 1.6529849177E+00, 1.1103774983E+00, 7.8826679461E-01],
	[1.9760000000E+04, 1.0470249297E+01, 4.9977692088E+00, 1.6543262325E+00, 1.1110201597E+00, 7.8836408899E-01],
	[1.9765000000E+04, 1.0474168525E+01, 4.9976363744E+00, 1.6556682954E+00, 1.1116628944E+00, 7.8846134637E-01],
	[1.9770000000E+04, 1.0478088228E+01, 4.9975035771E+00, 1.6570111066E+00, 1.1123057021E+00, 7.8855856676E-01],
	[1.9775000000E+04, 1.0482008406E+01, 4.9973708169E+00, 1.6583546664E+00, 1.1129485827E+00, 7.8865575014E-01],
	[1.9780000000E+04, 1.0485929059E+01, 4.9972380938E+00, 1.6596989750E+00, 1.1135915361E+00, 7.8875289654E-01],
	[1.9785000000E+04, 1.0489850187E+01, 4.9971054077E+00, 1.6610440327E+00, 1.1142345621E+00, 7.8885000594E-01],
	[1.9790000000E+04, 1.0493771790E+01, 4.9969727588E+00, 1.6623898396E+00, 1.1148776605E+00, 7.8894707836E-01],
	[1.9795000000E+04, 1.0497693868E+01, 4.9968401468E+00, 1.6637363959E+00, 1.1155208311E+00, 7.8904411380E-01],
	[1.9800000000E+04, 1.0501616421E+01, 4.9967075719E+00, 1.6650837020E+00, 1.1161640739E+00, 7.8914111226E-01],
	[1.9805000000E+04, 1.0505539448E+01, 4.9965750339E+00, 1.6664317580E+00, 1.1168073886E+00, 7.8923807374E-01],
	[1.9810000000E+04, 1.0509462950E+01, 4.9964425329E+00, 1.6677805642E+00, 1.1174507750E+00, 7.8933499824E-01],
	[1.9815000000E+04, 1.0513386927E+01, 4.9963100689E+00, 1.6691301207E+00, 1.1180942330E+00, 7.8943188578E-01],
	[1.9820000000E+04, 1.0517311378E+01, 4.9961776418E+00, 1.6704804279E+00, 1.1187377625E+00, 7.8952873634E-01],
	[1.9825000000E+04, 1.0521236303E+01, 4.9960452516E+00, 1.6718314859E+00, 1.1193813633E+00, 7.8962554994E-01],
	[1.9830000000E+04, 1.0525161703E+01, 4.9959128983E+00, 1.6731832950E+00, 1.1200250352E+00, 7.8972232658E-01],
	[1.9835000000E+04, 1.0529087578E+01, 4.9957805819E+00, 1.6745358554E+00, 1.1206687780E+00, 7.8981906626E-01],
	[1.9840000000E+04, 1.0533013926E+01, 4.9956483023E+00, 1.6758891673E+00, 1.1213125916E+00, 7.8991576898E-01],
	[1.9845000000E+04, 1.0536940749E+01, 4.9955160596E+00, 1.6772432309E+00, 1.1219564758E+00, 7.9001243475E-01],
	[1.9850000000E+04, 1.0540868046E+01, 4.9953838536E+00, 1.6785980466E+00, 1.1226004305E+00, 7.9010906358E-01],
	[1.9855000000E+04, 1.0544795817E+01, 4.9952516845E+00, 1.6799536144E+00, 1.1232444555E+00, 7.9020565545E-01],
	[1.9860000000E+04, 1.0548724062E+01, 4.9951195521E+00, 1.6813099347E+00, 1.1238885506E+00, 7.9030221039E-01],
	[1.9865000000E+04, 1.0552652782E+01, 4.9949874565E+00, 1.6826670077E+00, 1.1245327157E+00, 7.9039872838E-01],
	[1.9870000000E+04, 1.0556581975E+01, 4.9948553977E+00, 1.6840248335E+00, 1.1251769506E+00, 7.9049520944E-01],
	[1.9875000000E+04, 1.0560511642E+01, 4.9947233755E+00, 1.6853834125E+00, 1.1258212551E+00, 7.9059165356E-01],
	[1.9880000000E+04, 1.0564441782E+01, 4.9945913901E+00, 1.6867427448E+00, 1.1264656292E+00, 7.9068806076E-01],
	[1.9885000000E+04, 1.0568372397E+01, 4.9944594413E+00, 1.6881028307E+00, 1.1271100725E+00, 7.9078443102E-01],
	[1.9890000000E+04, 1.0572303485E+01, 4.9943275292E+00, 1.6894636704E+00, 1.1277545850E+00, 7.9088076437E-01],
	[1.9895000000E+04, 1.0576235046E+01, 4.9941956537E+00, 1.6908252641E+00, 1.1283991664E+00, 7.9097706079E-01],
	[1.9900000000E+04, 1.0580167082E+01, 4.9940638149E+00, 1.6921876121E+00, 1.1290438167E+00, 7.9107332030E-01],
	[1.9905000000E+04, 1.0584099590E+01, 4.9939320126E+00, 1.6935507146E+00, 1.1296885357E+00, 7.9116954290E-01],
	[1.9910000000E+04, 1.0588032572E+01, 4.9938002469E+00, 1.6949145717E+00, 1.1303333231E+00, 7.9126572859E-01],
	[1.9915000000E+04, 1.0591966028E+01, 4.9936685178E+00, 1.6962791839E+00, 1.1309781789E+00, 7.9136187737E-01],
	[1.9920000000E+04, 1.0595899957E+01, 4.9935368253E+00, 1.6976445512E+00, 1.1316231029E+00, 7.9145798925E-01],
	[1.9925000000E+04, 1.0599834359E+01, 4.9934051692E+00, 1.6990106738E+00, 1.1322680949E+00, 7.9155406423E-01],
	[1.9930000000E+04, 1.0603769234E+01, 4.9932735497E+00, 1.7003775522E+00, 1.1329131547E+00, 7.9165010231E-01],
	[1.9935000000E+04, 1.0607704582E+01, 4.9931419666E+00, 1.7017451863E+00, 1.1335582822E+00, 7.9174610351E-01],
	[1.9940000000E+04, 1.0611640403E+01, 4.9930104200E+00, 1.7031135766E+00, 1.1342034772E+00, 7.9184206781E-01],
	[1.9945000000E+04, 1.0615576698E+01, 4.9928789099E+00, 1.7044827231E+00, 1.1348487396E+00, 7.9193799524E-01],
	[1.9950000000E+04, 1.0619513465E+01, 4.9927474361E+00, 1.7058526262E+00, 1.1354940691E+00, 7.9203388578E-01],
	[1.9955000000E+04, 1.0623450705E+01, 4.9926159988E+00, 1.7072232861E+00, 1.1361394657E+00, 7.9212973944E-01],
	[1.9960000000E+04, 1.0627388418E+01, 4.9924845979E+00, 1.7085947029E+00, 1.1367849292E+00, 7.9222555623E-01],
	[1.9965000000E+04, 1.0631326603E+01, 4.9923532333E+00, 1.7099668770E+00, 1.1374304593E+00, 7.9232133615E-01],
	[1.9970000000E+04, 1.0635265262E+01, 4.9922219051E+00, 1.7113398085E+00, 1.1380760560E+00, 7.9241707921E-01],
	[1.9975000000E+04, 1.0639204393E+01, 4.9920906133E+00, 1.7127134977E+00, 1.1387217191E+00, 7.9251278540E-01],
	[1.9980000000E+04, 1.0643143996E+01, 4.9919593577E+00, 1.7140879447E+00, 1.1393674484E+00, 7.9260845473E-01],
	[1.9985000000E+04, 1.0647084072E+01, 4.9918281384E+00, 1.7154631500E+00, 1.1400132438E+00, 7.9270408721E-01],
	[1.9990000000E+04, 1.0651024620E+01, 4.9916969554E+00, 1.7168391135E+00, 1.1406591050E+00, 7.9279968284E-01],
	[1.9995000000E+04, 1.0654965641E+01, 4.9915658087E+00, 1.7182158357E+00, 1.1413050320E+00, 7.9289524162E-01],
	[2.0000000000E+04, 1.0658907134E+01, 4.9914346982E+00, 1.7195933167E+00, 1.1419510245E+00, 7.9299076356E-01],
	[2.0005000000E+04, 1.0662849099E+01, 4.9913036239E+00, 1.7209735446E+00, 1.1425979587E+00, 7.9308624866E-01],
	[2.0010000000E+04, 1.0666791537E+01, 4.9911725858E+00, 1.7223545345E+00, 1.1432449585E+00, 7.9318169692E-01],
	[2.0015000000E+04, 1.0670734446E+01, 4.9910415838E+00, 1.7237362867E+00, 1.1438920238E+00, 7.9327710835E-01],
	[2.0020000000E+04, 1.0674677828E+01, 4.9909106181E+00, 1.7251188014E+00, 1.1445391543E+00, 7.9337248296E-01],
	[2.0025000000E+04, 1.0678621682E+01, 4.9907796885E+00, 1.7265020788E+00, 1.1451863500E+00, 7.9346782074E-01],
	[2.0030000000E+04, 1.0682566007E+01, 4.9906487950E+00, 1.7278861191E+00, 1.1458336107E+00, 7.9356312170E-01],
	[2.0035000000E+04, 1.0686510805E+01, 4.9905179376E+00, 1.7292709226E+00, 1.1464809362E+00, 7.9365838585E-01],
	[2.0040000000E+04, 1.0690456074E+01, 4.9903871163E+00, 1.7306564894E+00, 1.1471283263E+00, 7.9375361318E-01],
	[2.0045000000E+04, 1.0694401815E+01, 4.9902563310E+00, 1.7320428200E+00, 1.1477757809E+00, 7.9384880371E-01],
	[2.0050000000E+04, 1.0698348028E+01, 4.9901255818E+00, 1.7334299144E+00, 1.1484232998E+00, 7.9394395743E-01],
	[2.0055000000E+04, 1.0702294712E+01, 4.9899948686E+00, 1.7348177728E+00, 1.1490708828E+00, 7.9403907436E-01],
	[2.0060000000E+04, 1.0706241868E+01, 4.9898641914E+00, 1.7362063956E+00, 1.1497185299E+00, 7.9413415448E-01],
	[2.0065000000E+04, 1.0710198299E+01, 4.9897357181E+00, 1.7375957829E+00, 1.1503664576E+00, 7.9422919782E-01],
	[2.0070000000E+04, 1.0714164431E+01, 4.9896095505E+00, 1.7389859351E+00, 1.1510146765E+00, 7.9432420437E-01],
	[2.0075000000E+04, 1.0718131043E+01, 4.9894834176E+00, 1.7403768522E+00, 1.1516629598E+00, 7.9441917414E-01],
	[2.0080000000E+04, 1.0722098135E+01, 4.9893573192E+00, 1.7417685346E+00, 1.1523113071E+00, 7.9451410713E-01],
	[2.0085000000E+04, 1.0726065707E+01, 4.9892312554E+00, 1.7431609824E+00, 1.1529597183E+00, 7.9460900335E-01],
	[2.0090000000E+04, 1.0730033759E+01, 4.9891052262E+00, 1.7445541959E+00, 1.1536081933E+00, 7.9470386279E-01],
	[2.0095000000E+04, 1.0734002292E+01, 4.9889792315E+00, 1.7459481754E+00, 1.1542567319E+00, 7.9479868547E-01],
	[2.0100000000E+04, 1.0737971304E+01, 4.9888532714E+00, 1.7473429210E+00, 1.1549053339E+00, 7.9489347139E-01],
	[2.0105000000E+04, 1.0741940796E+01, 4.9887273457E+00, 1.7487384330E+00, 1.1555539992E+00, 7.9498822055E-01],
	[2.0110000000E+04, 1.0745910767E+01, 4.9886014546E+00, 1.7501347117E+00, 1.1562027276E+00, 7.9508293296E-01],
	[2.0115000000E+04, 1.0749881219E+01, 4.9884755979E+00, 1.7515317571E+00, 1.1568515189E+00, 7.9517760862E-01],
	[2.0120000000E+04, 1.0753852150E+01, 4.9883497756E+00, 1.7529295697E+00, 1.1575003730E+00, 7.9527224754E-01],
	[2.0125000000E+04, 1.0757823560E+01, 4.9882239879E+00, 1.7543281496E+00, 1.1581492898E+00, 7.9536684971E-01],
	[2.0130000000E+04, 1.0761795451E+01, 4.9880982345E+00, 1.7557274970E+00, 1.1587982689E+00, 7.9546141515E-01],
	[2.0135000000E+04, 1.0765767820E+01, 4.9879725155E+00, 1.7571276121E+00, 1.1594473104E+00, 7.9555594386E-01],
	[2.0140000000E+04, 1.0769740669E+01, 4.9878468309E+00, 1.7585284953E+00, 1.1600964141E+00, 7.9565043585E-01],
	[2.0145000000E+04, 1.0773713998E+01, 4.9877211807E+00, 1.7599301467E+00, 1.1607455797E+00, 7.9574489111E-01],
	[2.0150000000E+04, 1.0777687806E+01, 4.9875955648E+00, 1.7613325666E+00, 1.1613948071E+00, 7.9583930965E-01],
	[2.0155000000E+04, 1.0781662093E+01, 4.9874699833E+00, 1.7627357551E+00, 1.1620440961E+00, 7.9593369148E-01],
	[2.0160000000E+04, 1.0785636859E+01, 4.9873444360E+00, 1.7641397126E+00, 1.1626934466E+00, 7.9602803660E-01],
	[2.0165000000E+04, 1.0789612104E+01, 4.9872189231E+00, 1.7655444392E+00, 1.1633428585E+00, 7.9612234502E-01],
	[2.0170000000E+04, 1.0793587828E+01, 4.9870934444E+00, 1.7669499352E+00, 1.1639923315E+00, 7.9621661674E-01],
	[2.0175000000E+04, 1.0797564032E+01, 4.9869680000E+00, 1.7683562008E+00, 1.1646418655E+00, 7.9631085176E-01],
	[2.0180000000E+04, 1.0801540714E+01, 4.9868425898E+00, 1.7697632363E+00, 1.1652914603E+00, 7.9640505010E-01],
	[2.0185000000E+04, 1.0805517875E+01, 4.9867172139E+00, 1.7711710418E+00, 1.1659411158E+00, 7.9649921175E-01],
	[2.0190000000E+04, 1.0809495515E+01, 4.9865918721E+00, 1.7725796176E+00, 1.1665908318E+00, 7.9659333671E-01],
	[2.0195000000E+04, 1.0813473633E+01, 4.9864665646E+00, 1.7739889639E+00, 1.1672406081E+00, 7.9668742501E-01],
	[2.0200000000E+04, 1.0817452231E+01, 4.9863412912E+00, 1.7753990811E+00, 1.1678904447E+00, 7.9678147663E-01],
	[2.0205000000E+04, 1.0821431307E+01, 4.9862160519E+00, 1.7768099691E+00, 1.1685403412E+00, 7.9687549157E-01],
	[2.0210000000E+04, 1.0825410861E+01, 4.9860908468E+00, 1.7782216285E+00, 1.1691902976E+00, 7.9696946982E-01],
	[2.0215000000E+04, 1.0829390894E+01, 4.9859656758E+00, 1.7796340592E+00, 1.1698403137E+00, 7.9706341138E-01],
	[2.0220000000E+04, 1.0833371405E+01, 4.9858405389E+00, 1.7810472617E+00, 1.1704903894E+00, 7.9715731625E-01],
	[2.0225000000E+04, 1.0837352395E+01, 4.9857154361E+00, 1.7824612360E+00, 1.1711405244E+00, 7.9725118444E-01],
	[2.0230000000E+04, 1.0841333863E+01, 4.9855903674E+00, 1.7838759825E+00, 1.1717907186E+00, 7.9734501594E-01],
	[2.0235000000E+04, 1.0845315810E+01, 4.9854653326E+00, 1.7852915014E+00, 1.1724409719E+00, 7.9743881077E-01],
	[2.0240000000E+04, 1.0849298234E+01, 4.9853403320E+00, 1.7867077929E+00, 1.1730912840E+00, 7.9753256893E-01],
	[2.0245000000E+04, 1.0853281137E+01, 4.9852153653E+00, 1.7881248572E+00, 1.1737416549E+00, 7.9762629041E-01],
	[2.0250000000E+04, 1.0857264518E+01, 4.9850904326E+00, 1.7895426946E+00, 1.1743920844E+00, 7.9771997523E-01],
	[2.0255000000E+04, 1.0861248377E+01, 4.9849655339E+00, 1.7909613052E+00, 1.1750425722E+00, 7.9781362338E-01],
	[2.0260000000E+04, 1.0865232713E+01, 4.9848406691E+00, 1.7923806894E+00, 1.1756931183E+00, 7.9790723488E-01],
	[2.0265000000E+04, 1.0869217528E+01, 4.9847158383E+00, 1.7938008474E+00, 1.1763437224E+00, 7.9800080971E-01],
	[2.0270000000E+04, 1.0873202820E+01, 4.9845910414E+00, 1.7952217793E+00, 1.1769943845E+00, 7.9809434789E-01],
	[2.0275000000E+04, 1.0877188591E+01, 4.9844662784E+00, 1.7966434854E+00, 1.1776451043E+00, 7.9818784943E-01],
	[2.0280000000E+04, 1.0881174839E+01, 4.9843415493E+00, 1.7980659660E+00, 1.1782958817E+00, 7.9828131431E-01],
	[2.0285000000E+04, 1.0885161564E+01, 4.9842168541E+00, 1.7994892213E+00, 1.1789467165E+00, 7.9837474255E-01],
	[2.0290000000E+04, 1.0889148767E+01, 4.9840921927E+00, 1.8009132514E+00, 1.1795976086E+00, 7.9846813416E-01],
	[2.0295000000E+04, 1.0893136448E+01, 4.9839675651E+00, 1.8023380567E+00, 1.1802485578E+00, 7.9856148913E-01],
	[2.0300000000E+04, 1.0897124606E+01, 4.9838429714E+00, 1.8037636374E+00, 1.1808995640E+00, 7.9865480746E-01],
	[2.0305000000E+04, 1.0901113242E+01, 4.9837184114E+00, 1.8051899937E+00, 1.1815506269E+00, 7.9874808917E-01],
	[2.0310000000E+04, 1.0905102355E+01, 4.9835938853E+00, 1.8066171258E+00, 1.1822017464E+00, 7.9884133425E-01],
	[2.0315000000E+04, 1.0909091945E+01, 4.9834693929E+00, 1.8080450339E+00, 1.1828529224E+00, 7.9893454271E-01],
	[2.0320000000E+04, 1.0913082013E+01, 4.9833449342E+00, 1.8094737183E+00, 1.1835041547E+00, 7.9902771456E-01],
	[2.0325000000E+04, 1.0917072557E+01, 4.9832205093E+00, 1.8109031793E+00, 1.1841554432E+00, 7.9912084979E-01],
	[2.0330000000E+04, 1.0921063579E+01, 4.9830961180E+00, 1.8123334170E+00, 1.1848067876E+00, 7.9921394841E-01],
	[2.0335000000E+04, 1.0925055078E+01, 4.9829717605E+00, 1.8137644317E+00, 1.1854581878E+00, 7.9930701043E-01],
	[2.0340000000E+04, 1.0929047053E+01, 4.9828474367E+00, 1.8151962236E+00, 1.1861096437E+00, 7.9940003584E-01],
	[2.0345000000E+04, 1.0933039506E+01, 4.9827231465E+00, 1.8166287929E+00, 1.1867611550E+00, 7.9949302466E-01],
	[2.0350000000E+04, 1.0937032436E+01, 4.9825988899E+00, 1.8180621399E+00, 1.1874127217E+00, 7.9958597688E-01],
	[2.0355000000E+04, 1.0941025842E+01, 4.9824746670E+00, 1.8194962648E+00, 1.1880643435E+00, 7.9967889251E-01],
	[2.0360000000E+04, 1.0945019725E+01, 4.9823504777E+00, 1.8209311679E+00, 1.1887160204E+00, 7.9977177155E-01],
	[2.0365000000E+04, 1.0949014085E+01, 4.9822263220E+00, 1.8223668493E+00, 1.1893677521E+00, 7.9986461401E-01],
	[2.0370000000E+04, 1.0953008921E+01, 4.9821021998E+00, 1.8238033092E+00, 1.1900195384E+00, 7.9995741989E-01],
	[2.0375000000E+04, 1.0957004234E+01, 4.9819781112E+00, 1.8252405481E+00, 1.1906713793E+00, 8.0005018920E-01],
	[2.0380000000E+04, 1.0961000024E+01, 4.9818540561E+00, 1.8266785659E+00, 1.1913232746E+00, 8.0014292194E-01],
	[2.0385000000E+04, 1.0964996290E+01, 4.9817300346E+00, 1.8281173631E+00, 1.1919752240E+00, 8.0023561811E-01],
	[2.0390000000E+04, 1.0969009321E+01, 4.9816099512E+00, 1.8295569398E+00, 1.1926276438E+00, 8.0032827772E-01],
	[2.0395000000E+04, 1.0973024801E+01, 4.9814903706E+00, 1.8309972962E+00, 1.1932801685E+00, 8.0042090077E-01],
	[2.0400000000E+04, 1.0977040766E+01, 4.9813708223E+00, 1.8324384326E+00, 1.1939327476E+00, 8.0051348726E-01],
	[2.0405000000E+04, 1.0981057216E+01, 4.9812513061E+00, 1.8338803492E+00, 1.1945853810E+00, 8.0060603720E-01],
	[2.0410000000E+04, 1.0985074151E+01, 4.9811318221E+00, 1.8353230462E+00, 1.1952380685E+00, 8.0069855060E-01],
	[2.0415000000E+04, 1.0989091571E+01, 4.9810123702E+00, 1.8367665239E+00, 1.1958908101E+00, 8.0079102746E-01],
	[2.0420000000E+04, 1.0993109476E+01, 4.9808929504E+00, 1.8382107825E+00, 1.1965436055E+00, 8.0088346778E-01],
	[2.0425000000E+04, 1.0997127865E+01, 4.9807735627E+00, 1.8396558223E+00, 1.1971964545E+00, 8.0097587156E-01],
	[2.0430000000E+04, 1.1001146740E+01, 4.9806542071E+00, 1.8411016434E+00, 1.1978493571E+00, 8.0106823881E-01],
	[2.0435000000E+04, 1.1005166099E+01, 4.9805348836E+00, 1.8425482461E+00, 1.1985023130E+00, 8.0116056954E-01],
	[2.0440000000E+04, 1.1009185942E+01, 4.9804155921E+00, 1.8439956306E+00, 1.1991553221E+00, 8.0125286375E-01],
	[2.0445000000E+04, 1.1013206271E+01, 4.9802963326E+00, 1.8454437971E+00, 1.1998083842E+00, 8.0134512144E-01],
	[2.0450000000E+04, 1.1017227083E+01, 4.9801771052E+00, 1.8468927460E+00, 1.2004614992E+00, 8.0143734262E-01],
	[2.0455000000E+04, 1.1021248381E+01, 4.9800579098E+00, 1.8483424773E+00, 1.2011146669E+00, 8.0152952729E-01],
	[2.0460000000E+04, 1.1025270162E+01, 4.9799387463E+00, 1.8497929915E+00, 1.2017678872E+00, 8.0162167546E-01],
	[2.0465000000E+04, 1.1029292428E+01, 4.9798196148E+00, 1.8512442885E+00, 1.2024211598E+00, 8.0171378713E-01],
	[2.0470000000E+04, 1.1033315179E+01, 4.9797005153E+00, 1.8526963688E+00, 1.2030744847E+00, 8.0180586230E-01],
	[2.0475000000E+04, 1.1037338413E+01, 4.9795814477E+00, 1.8541492326E+00, 1.2037278616E+00, 8.0189790098E-01],
	[2.0480000000E+04, 1.1041362132E+01, 4.9794624120E+00, 1.8556028800E+00, 1.2043812905E+00, 8.0198990318E-01],
	[2.0485000000E+04, 1.1045386335E+01, 4.9793434083E+00, 1.8570573113E+00, 1.2050347711E+00, 8.0208186889E-01],
	[2.0490000000E+04, 1.1049411021E+01, 4.9792244364E+00, 1.8585125267E+00, 1.2056883032E+00, 8.0217379813E-01],
	[2.0495000000E+04, 1.1053436192E+01, 4.9791054964E+00, 1.8599685265E+00, 1.2063418868E+00, 8.0226569089E-01],
	[2.0500000000E+04, 1.1057461847E+01, 4.9789865882E+00, 1.8614253109E+00, 1.2069955217E+00, 8.0235754719E-01],
	[2.0505000000E+04, 1.1061487985E+01, 4.9788677119E+00, 1.8628828801E+00, 1.2076492077E+00, 8.0244936702E-01],
	[2.0510000000E+04, 1.1065514608E+01, 4.9787488674E+00, 1.8643412343E+00, 1.2083029446E+00, 8.0254115040E-01],
	[2.0515000000E+04, 1.1069541714E+01, 4.9786300547E+00, 1.8658003739E+00, 1.2089567323E+00, 8.0263289731E-01],
	[2.0520000000E+04, 1.1073569303E+01, 4.9785112738E+00, 1.8672602989E+00, 1.2096105706E+00, 8.0272460778E-01],
	[2.0525000000E+04, 1.1077597377E+01, 4.9783925246E+00, 1.8687210097E+00, 1.2102644594E+00, 8.0281628181E-01],
	[2.0530000000E+04, 1.1081625934E+01, 4.9782738072E+00, 1.8701825065E+00, 1.2109183984E+00, 8.0290791939E-01],
	[2.0535000000E+04, 1.1085654974E+01, 4.9781551216E+00, 1.8716447895E+00, 1.2115723877E+00, 8.0299952054E-01],
	[2.0540000000E+04, 1.1089684498E+01, 4.9780364677E+00, 1.8731078589E+00, 1.2122264269E+00, 8.0309108525E-01],
	[2.0545000000E+04, 1.1093714505E+01, 4.9779178454E+00, 1.8745717150E+00, 1.2128805159E+00, 8.0318261354E-01],
	[2.0550000000E+04, 1.1097744996E+01, 4.9777992549E+00, 1.8760363580E+00, 1.2135346546E+00, 8.0327410541E-01],
	[2.0555000000E+04, 1.1101775970E+01, 4.9776806961E+00, 1.8775017882E+00, 1.2141888428E+00, 8.0336556086E-01],
	[2.0560000000E+04, 1.1105807427E+01, 4.9775621689E+00, 1.8789680056E+00, 1.2148430804E+00, 8.0345697989E-01],
	[2.0565000000E+04, 1.1109839367E+01, 4.9774436733E+00, 1.8804350107E+00, 1.2154973671E+00, 8.0354836252E-01],
	[2.0570000000E+04, 1.1113871790E+01, 4.9773252094E+00, 1.8819028037E+00, 1.2161517029E+00, 8.0363970875E-01],
	[2.0575000000E+04, 1.1117904696E+01, 4.9772067771E+00, 1.8833713846E+00, 1.2168060875E+00, 8.0373101858E-01],
	[2.0580000000E+04, 1.1121938085E+01, 4.9770883764E+00, 1.8848407539E+00, 1.2174605208E+00, 8.0382229202E-01],
	[2.0585000000E+04, 1.1125971958E+01, 4.9769700072E+00, 1.8863109117E+00, 1.2181150027E+00, 8.0391352907E-01],
	[2.0590000000E+04, 1.1130006313E+01, 4.9768516697E+00, 1.8877818582E+00, 1.2187695330E+00, 8.0400472973E-01],
	[2.0595000000E+04, 1.1134041150E+01, 4.9767333636E+00, 1.8892535937E+00, 1.2194241115E+00, 8.0409589402E-01],
	[2.0600000000E+04, 1.1138076471E+01, 4.9766150891E+00, 1.8907261184E+00, 1.2200787380E+00, 8.0418702193E-01],
	[2.0605000000E+04, 1.1142112274E+01, 4.9764968461E+00, 1.8921994326E+00, 1.2207334125E+00, 8.0427811347E-01],
	[2.0610000000E+04, 1.1146148560E+01, 4.9763786346E+00, 1.8936735364E+00, 1.2213881347E+00, 8.0436916866E-01],
	[2.0615000000E+04, 1.1150185328E+01, 4.9762604546E+00, 1.8951484301E+00, 1.2220429045E+00, 8.0446018748E-01],
	[2.0620000000E+04, 1.1154222579E+01, 4.9761423061E+00, 1.8966241140E+00, 1.2226977218E+00, 8.0455116995E-01],
	[2.0625000000E+04, 1.1158260312E+01, 4.9760241890E+00, 1.8981005883E+00, 1.2233525863E+00, 8.0464211607E-01],
	[2.0630000000E+04, 1.1162298527E+01, 4.9759061033E+00, 1.8995778531E+00, 1.2240074979E+00, 8.0473302585E-01],
	[2.0635000000E+04, 1.1166337225E+01, 4.9757880491E+00, 1.9010559088E+00, 1.2246624565E+00, 8.0482389928E-01],
	[2.0640000000E+04, 1.1170376405E+01, 4.9756700263E+00, 1.9025347555E+00, 1.2253174618E+00, 8.0491473639E-01],
	[2.0645000000E+04, 1.1174416068E+01, 4.9755520348E+00, 1.9040143935E+00, 1.2259725138E+00, 8.0500553717E-01],
	[2.0650000000E+04, 1.1178456212E+01, 4.9754340747E+00, 1.9054948231E+00, 1.2266276123E+00, 8.0509630162E-01],
	[2.0655000000E+04, 1.1182496839E+01, 4.9753161460E+00, 1.9069760444E+00, 1.2272827571E+00, 8.0518702976E-01],
	[2.0660000000E+04, 1.1186537947E+01, 4.9751982486E+00, 1.9084580577E+00, 1.2279379480E+00, 8.0527772158E-01],
	[2.0665000000E+04, 1.1190579538E+01, 4.9750803825E+00, 1.9099408632E+00, 1.2285931850E+00, 8.0536837710E-01],
	[2.0670000000E+04, 1.1194621610E+01, 4.9749625478E+00, 1.9114244611E+00, 1.2292484678E+00, 8.0545899632E-01],
	[2.0675000000E+04, 1.1198664164E+01, 4.9748447443E+00, 1.9129088518E+00, 1.2299037962E+00, 8.0554957923E-01],
	[2.0680000000E+04, 1.1202707200E+01, 4.9747269721E+00, 1.9143940353E+00, 1.2305591702E+00, 8.0564012586E-01],
	[2.0685000000E+04, 1.1206750718E+01, 4.9746092311E+00, 1.9158800120E+00, 1.2312145895E+00, 8.0573063620E-01],
	[2.0690000000E+04, 1.1210794717E+01, 4.9744915214E+00, 1.9173667820E+00, 1.2318700541E+00, 8.0582111026E-01],
	[2.0695000000E+04, 1.1214839198E+01, 4.9743738430E+00, 1.9188543457E+00, 1.2325255637E+00, 8.0591154804E-01],
	[2.0700000000E+04, 1.1218884161E+01, 4.9742561957E+00, 1.9203427032E+00, 1.2331811181E+00, 8.0600194955E-01],
	[2.0705000000E+04, 1.1222929605E+01, 4.9741385796E+00, 1.9218318548E+00, 1.2338367173E+00, 8.0609231480E-01],
	[2.0710000000E+04, 1.1226975530E+01, 4.9740209948E+00, 1.9233218006E+00, 1.2344923611E+00, 8.0618264379E-01],
	[2.0715000000E+04, 1.1231026675E+01, 4.9739045476E+00, 1.9248125410E+00, 1.2351481748E+00, 8.0627293652E-01],
	[2.0720000000E+04, 1.1235092036E+01, 4.9737913373E+00, 1.9263040762E+00, 1.2358043970E+00, 8.0636319300E-01],
	[2.0725000000E+04, 1.1239157887E+01, 4.9736781569E+00, 1.9277964063E+00, 1.2364606641E+00, 8.0645341324E-01],
	[2.0730000000E+04, 1.1243224229E+01, 4.9735650064E+00, 1.9292895317E+00, 1.2371169759E+00, 8.0654359725E-01],
	[2.0735000000E+04, 1.1247291060E+01, 4.9734518858E+00, 1.9307834525E+00, 1.2377733323E+00, 8.0663374502E-01],
	[2.0740000000E+04, 1.1251358381E+01, 4.9733387950E+00, 1.9322781690E+00, 1.2384297330E+00, 8.0672385656E-01],
	[2.0745000000E+04, 1.1255426192E+01, 4.9732257340E+00, 1.9337736815E+00, 1.2390861780E+00, 8.0681393188E-01],
	[2.0750000000E+04, 1.1259494493E+01, 4.9731127029E+00, 1.9352699901E+00, 1.2397426670E+00, 8.0690397099E-01],
	[2.0755000000E+04, 1.1263563284E+01, 4.9729997015E+00, 1.9367670950E+00, 1.2403992000E+00, 8.0699397388E-01],
	[2.0760000000E+04, 1.1267632565E+01, 4.9728867300E+00, 1.9382649966E+00, 1.2410557767E+00, 8.0708394054E-01],
	[2.0765000000E+04, 1.1271702335E+01, 4.9727737882E+00, 1.9397636950E+00, 1.2417123970E+00, 8.0717387095E-01],
	[2.0770000000E+04, 1.1275772595E+01, 4.9726608762E+00, 1.9412631905E+00, 1.2423690608E+00, 8.0726376513E-01],
	[2.0775000000E+04, 1.1279843344E+01, 4.9725479939E+00, 1.9427634833E+00, 1.2430257678E+00, 8.0735362309E-01],
	[2.0780000000E+04, 1.1283914583E+01, 4.9724351413E+00, 1.9442645737E+00, 1.2436825180E+00, 8.0744344483E-01],
	[2.0785000000E+04, 1.1287986311E+01, 4.9723223184E+00, 1.9457664618E+00, 1.2443393111E+00, 8.0753323037E-01],
	[2.0790000000E+04, 1.1292058528E+01, 4.9722095253E+00, 1.9472691479E+00, 1.2449961471E+00, 8.0762297973E-01],
	[2.0795000000E+04, 1.1296131235E+01, 4.9720967618E+00, 1.9487726322E+00, 1.2456530257E+00, 8.0771269290E-01],
	[2.0800000000E+04, 1.1300204431E+01, 4.9719840280E+00, 1.9502769150E+00, 1.2463099467E+00, 8.0780236991E-01],
	[2.0805000000E+04, 1.1304278117E+01, 4.9718713238E+00, 1.9517819965E+00, 1.2469669102E+00, 8.0789201076E-01],
	[2.0810000000E+04, 1.1308352291E+01, 4.9717586493E+00, 1.9532878770E+00, 1.2476239158E+00, 8.0798161547E-01],
	[2.0815000000E+04, 1.1312426954E+01, 4.9716460044E+00, 1.9547945566E+00, 1.2482809634E+00, 8.0807118404E-01],
	[2.0820000000E+04, 1.1316502107E+01, 4.9715333891E+00, 1.9563020355E+00, 1.2489380529E+00, 8.0816071650E-01],
	[2.0825000000E+04, 1.1320577748E+01, 4.9714208034E+00, 1.9578103141E+00, 1.2495951841E+00, 8.0825021284E-01],
	[2.0830000000E+04, 1.1324653878E+01, 4.9713082473E+00, 1.9593193926E+00, 1.2502523568E+00, 8.0833967309E-01],
	[2.0835000000E+04, 1.1328730497E+01, 4.9711957207E+00, 1.9608292712E+00, 1.2509095710E+00, 8.0842909724E-01],
	[2.0840000000E+04, 1.1332807605E+01, 4.9710832237E+00, 1.9623399500E+00, 1.2515668263E+00, 8.0851848533E-01],
	[2.0845000000E+04, 1.1336885202E+01, 4.9709707562E+00, 1.9638514294E+00, 1.2522241228E+00, 8.0860783735E-01],
	[2.0850000000E+04, 1.1340963287E+01, 4.9708583183E+00, 1.9653637096E+00, 1.2528814601E+00, 8.0869715331E-01],
	[2.0855000000E+04, 1.1345041861E+01, 4.9707459098E+00, 1.9668767908E+00, 1.2535388383E+00, 8.0878643324E-01],
	[2.0860000000E+04, 1.1349120923E+01, 4.9706335308E+00, 1.9683906733E+00, 1.2541962570E+00, 8.0887567713E-01],
	[2.0865000000E+04, 1.1353200474E+01, 4.9705211813E+00, 1.9699053572E+00, 1.2548537162E+00, 8.0896488501E-01],
	[2.0870000000E+04, 1.1357280513E+01, 4.9704088613E+00, 1.9714208428E+00, 1.2555112156E+00, 8.0905405688E-01],
	[2.0875000000E+04, 1.1361361041E+01, 4.9702965707E+00, 1.9729371304E+00, 1.2561687552E+00, 8.0914319275E-01],
	[2.0880000000E+04, 1.1365442057E+01, 4.9701843095E+00, 1.9744542201E+00, 1.2568263348E+00, 8.0923229264E-01],
	[2.0885000000E+04, 1.1369523561E+01, 4.9700720778E+00, 1.9759721123E+00, 1.2574839542E+00, 8.0932135656E-01],
	[2.0890000000E+04, 1.1373605553E+01, 4.9699598754E+00, 1.9774908071E+00, 1.2581416133E+00, 8.0941038451E-01],
	[2.0895000000E+04, 1.1377688034E+01, 4.9698477024E+00, 1.9790103047E+00, 1.2587993118E+00, 8.0949937652E-01],
	[2.0900000000E+04, 1.1381771002E+01, 4.9697355588E+00, 1.9805306055E+00, 1.2594570497E+00, 8.0958833259E-01],
	[2.0905000000E+04, 1.1385854459E+01, 4.9696234446E+00, 1.9820517095E+00, 1.2601148268E+00, 8.0967725273E-01],
	[2.0910000000E+04, 1.1389938403E+01, 4.9695113597E+00, 1.9835736172E+00, 1.2607726430E+00, 8.0976613696E-01],
	[2.0915000000E+04, 1.1394022836E+01, 4.9693993041E+00, 1.9850963286E+00, 1.2614304980E+00, 8.0985498528E-01],
	[2.0920000000E+04, 1.1398107756E+01, 4.9692872778E+00, 1.9866198440E+00, 1.2620883917E+00, 8.0994379771E-01],
	[2.0925000000E+04, 1.1402193164E+01, 4.9691752808E+00, 1.9881441638E+00, 1.2627463240E+00, 8.1003257426E-01],
	[2.0930000000E+04, 1.1406279060E+01, 4.9690633131E+00, 1.9896692879E+00, 1.2634042947E+00, 8.1012131494E-01],
	[2.0935000000E+04, 1.1410365443E+01, 4.9689513747E+00, 1.9911952169E+00, 1.2640623037E+00, 8.1021001976E-01],
	[2.0940000000E+04, 1.1414452314E+01, 4.9688394655E+00, 1.9927219507E+00, 1.2647203507E+00, 8.1029868874E-01],
	[2.0945000000E+04, 1.1418539672E+01, 4.9687275856E+00, 1.9942494898E+00, 1.2653784357E+00, 8.1038732188E-01],
	[2.0950000000E+04, 1.1422627518E+01, 4.9686157349E+00, 1.9957778343E+00, 1.2660365585E+00, 8.1047591920E-01],
	[2.0955000000E+04, 1.1426715852E+01, 4.9685039134E+00, 1.9973069844E+00, 1.2666947189E+00, 8.1056448071E-01],
	[2.0960000000E+04, 1.1430804673E+01, 4.9683921210E+00, 1.9988369404E+00, 1.2673529167E+00, 8.1065300642E-01],
	[2.0965000000E+04, 1.1434893981E+01, 4.9682803579E+00, 2.0003677025E+00, 1.2680111519E+00, 8.1074149633E-01],
	[2.0970000000E+04, 1.1438983776E+01, 4.9681686239E+00, 2.0018992709E+00, 1.2686694242E+00, 8.1082995048E-01],
	[2.0975000000E+04, 1.1443074059E+01, 4.9680569191E+00, 2.0034316460E+00, 1.2693277336E+00, 8.1091836885E-01],
	[2.0980000000E+04, 1.1447164828E+01, 4.9679452434E+00, 2.0049648278E+00, 1.2699860797E+00, 8.1100675148E-01],
	[2.0985000000E+04, 1.1451256085E+01, 4.9678335969E+00, 2.0064988167E+00, 1.2706444626E+00, 8.1109509836E-01],
	[2.0990000000E+04, 1.1455347829E+01, 4.9677219794E+00, 2.0080336128E+00, 1.2713028820E+00, 8.1118340951E-01],
	[2.0995000000E+04, 1.1459440059E+01, 4.9676103911E+00, 2.0095692165E+00, 1.2719613378E+00, 8.1127168494E-01],
	[2.1000000000E+04, 1.1463532777E+01, 4.9674988318E+00, 2.0111056279E+00, 1.2726198297E+00, 8.1135992466E-01],
	[2.1005000000E+04, 1.1467625982E+01, 4.9673873015E+00, 2.0126428472E+00, 1.2732783578E+00, 8.1144812869E-01],
	[2.1010000000E+04, 1.1471719673E+01, 4.9672758004E+00, 2.0141808748E+00, 1.2739369217E+00, 8.1153629703E-01],
	[2.1015000000E+04, 1.1475813851E+01, 4.9671643282E+00, 2.0157197108E+00, 1.2745955214E+00, 8.1162442970E-01],
	[2.1020000000E+04, 1.1479908515E+01, 4.9670528851E+00, 2.0172593554E+00, 1.2752541567E+00, 8.1171252671E-01],
	[2.1025000000E+04, 1.1484003667E+01, 4.9669414710E+00, 2.0187998090E+00, 1.2759128275E+00, 8.1180058807E-01],
	[2.1030000000E+04, 1.1488099304E+01, 4.9668300859E+00, 2.0203410717E+00, 1.2765715335E+00, 8.1188861379E-01],
	[2.1035000000E+04, 1.1492195429E+01, 4.9667187297E+00, 2.0218831437E+00, 1.2772302746E+00, 8.1197660389E-01],
	[2.1040000000E+04, 1.1496292040E+01, 4.9666074025E+00, 2.0234260253E+00, 1.2778890508E+00, 8.1206455837E-01],
	[2.1045000000E+04, 1.1500389137E+01, 4.9664961043E+00, 2.0249697168E+00, 1.2785478617E+00, 8.1215247724E-01],
	[2.1050000000E+04, 1.1504497262E+01, 4.9663872329E+00, 2.0265142183E+00, 1.2792069967E+00, 8.1224036053E-01],
	[2.1055000000E+04, 1.1508614029E+01, 4.9662802430E+00, 2.0280595301E+00, 1.2798663906E+00, 8.1232820823E-01],
	[2.1060000000E+04, 1.1512731292E+01, 4.9661732808E+00, 2.0296056524E+00, 1.2805258196E+00, 8.1241602037E-01],
	[2.1065000000E+04, 1.1516849050E+01, 4.9660663463E+00, 2.0311525855E+00, 1.2811852835E+00, 8.1250379695E-01],
	[2.1070000000E+04, 1.1520967302E+01, 4.9659594395E+00, 2.0327003295E+00, 1.2818447823E+00, 8.1259153799E-01],
	[2.1075000000E+04, 1.1525086050E+01, 4.9658525603E+00, 2.0342488848E+00, 1.2825043158E+00, 8.1267924349E-01],
	[2.1080000000E+04, 1.1529205292E+01, 4.9657457088E+00, 2.0357982515E+00, 1.2831638837E+00, 8.1276691347E-01],
	[2.1085000000E+04, 1.1533325029E+01, 4.9656388850E+00, 2.0373484299E+00, 1.2838234860E+00, 8.1285454794E-01],
	[2.1090000000E+04, 1.1537445261E+01, 4.9655320887E+00, 2.0388994202E+00, 1.2844831226E+00, 8.1294214691E-01],
	[2.1095000000E+04, 1.1541565988E+01, 4.9654253201E+00, 2.0404512227E+00, 1.2851427931E+00, 8.1302971040E-01],
	[2.1100000000E+04, 1.1545687209E+01, 4.9653185791E+00, 2.0420038375E+00, 1.2858024976E+00, 8.1311723841E-01],
	[2.1105000000E+04, 1.1549808925E+01, 4.9652118657E+00, 2.0435572650E+00, 1.2864622358E+00, 8.1320473095E-01],
	[2.1110000000E+04, 1.1553931135E+01, 4.9651051798E+00, 2.0451115052E+00, 1.2871220076E+00, 8.1329218805E-01],
	[2.1115000000E+04, 1.1558053840E+01, 4.9649985215E+00, 2.0466665586E+00, 1.2877818128E+00, 8.1337960970E-01],
	[2.1120000000E+04, 1.1562177040E+01, 4.9648918907E+00, 2.0482224253E+00, 1.2884416513E+00, 8.1346699593E-01],
	[2.1125000000E+04, 1.1566300733E+01, 4.9647852875E+00, 2.0497791055E+00, 1.2891015229E+00, 8.1355434674E-01],
	[2.1130000000E+04, 1.1570424921E+01, 4.9646787118E+00, 2.0513365995E+00, 1.2897614274E+00, 8.1364166214E-01],
	[2.1135000000E+04, 1.1574549604E+01, 4.9645721636E+00, 2.0528949074E+00, 1.2904213648E+00, 8.1372894215E-01],
	[2.1140000000E+04, 1.1578674780E+01, 4.9644656428E+00, 2.0544540297E+00, 1.2910813348E+00, 8.1381618678E-01],
	[2.1145000000E+04, 1.1582800451E+01, 4.9643591496E+00, 2.0560139664E+00, 1.2917413374E+00, 8.1390339604E-01],
	[2.1150000000E+04, 1.1586926615E+01, 4.9642526838E+00, 2.0575747177E+00, 1.2924013723E+00, 8.1399056994E-01],
	[2.1155000000E+04, 1.1591053274E+01, 4.9641462455E+00, 2.0591362841E+00, 1.2930614393E+00, 8.1407770849E-01],
	[2.1160000000E+04, 1.1595180426E+01, 4.9640398346E+00, 2.0606986655E+00, 1.2937215384E+00, 8.1416481171E-01],
	[2.1165000000E+04, 1.1599308073E+01, 4.9639334511E+00, 2.0622618624E+00, 1.2943816694E+00, 8.1425187961E-01],
	[2.1170000000E+04, 1.1603436213E+01, 4.9638270950E+00, 2.0638258749E+00, 1.2950418321E+00, 8.1433891219E-01],
	[2.1175000000E+04, 1.1607564847E+01, 4.9637207663E+00, 2.0653907033E+00, 1.2957020264E+00, 8.1442590948E-01],
	[2.1180000000E+04, 1.1611693975E+01, 4.9636144650E+00, 2.0669563478E+00, 1.2963622521E+00, 8.1451287147E-01],
	[2.1185000000E+04, 1.1615823597E+01, 4.9635081911E+00, 2.0685228086E+00, 1.2970225091E+00, 8.1459979819E-01],
	[2.1190000000E+04, 1.1619953712E+01, 4.9634019445E+00, 2.0700900859E+00, 1.2976827972E+00, 8.1468668965E-01],
	[2.1195000000E+04, 1.1624084321E+01, 4.9632957253E+00, 2.0716581801E+00, 1.2983431163E+00, 8.1477354585E-01],
	[2.1200000000E+04, 1.1628215423E+01, 4.9631895334E+00, 2.0732270913E+00, 1.2990034661E+00, 8.1486036681E-01],
	[2.1205000000E+04, 1.1632347018E+01, 4.9630833688E+00, 2.0747968197E+00, 1.2996638466E+00, 8.1494715255E-01],
	[2.1210000000E+04, 1.1636479107E+01, 4.9629772315E+00, 2.0763673656E+00, 1.3003242576E+00, 8.1503390306E-01],
	[2.1215000000E+04, 1.1640611690E+01, 4.9628711215E+00, 2.0779387293E+00, 1.3009846990E+00, 8.1512061837E-01],
	[2.1220000000E+04, 1.1644744765E+01, 4.9627650388E+00, 2.0795109109E+00, 1.3016451705E+00, 8.1520729848E-01],
	[2.1225000000E+04, 1.1648878334E+01, 4.9626589833E+00, 2.0810839106E+00, 1.3023056721E+00, 8.1529394342E-01],
	[2.1230000000E+04, 1.1653012396E+01, 4.9625529550E+00, 2.0826577288E+00, 1.3029662035E+00, 8.1538055318E-01],
	[2.1235000000E+04, 1.1657146951E+01, 4.9624469541E+00, 2.0842323657E+00, 1.3036267647E+00, 8.1546712778E-01],
	[2.1240000000E+04, 1.1661281999E+01, 4.9623409803E+00, 2.0858078214E+00, 1.3042873555E+00, 8.1555366724E-01],
	[2.1245000000E+04, 1.1665417540E+01, 4.9622350337E+00, 2.0873840963E+00, 1.3049479756E+00, 8.1564017156E-01],
	[2.1250000000E+04, 1.1669553574E+01, 4.9621291143E+00, 2.0889611905E+00, 1.3056086251E+00, 8.1572664076E-01],
	[2.1255000000E+04, 1.1673690101E+01, 4.9620232221E+00, 2.0905391043E+00, 1.3062693036E+00, 8.1581307484E-01],
	[2.1260000000E+04, 1.1677827121E+01, 4.9619173571E+00, 2.0921178379E+00, 1.3069300111E+00, 8.1589947383E-01],
	[2.1265000000E+04, 1.1681964633E+01, 4.9618115192E+00, 2.0936973915E+00, 1.3075907475E+00, 8.1598583772E-01],
	[2.1270000000E+04, 1.1686102638E+01, 4.9617057085E+00, 2.0952777655E+00, 1.3082515124E+00, 8.1607216655E-01],
	[2.1275000000E+04, 1.1690241136E+01, 4.9615999249E+00, 2.0968589599E+00, 1.3089123059E+00, 8.1615846030E-01],
	[2.1280000000E+04, 1.1694380126E+01, 4.9614941684E+00, 2.0984409751E+00, 1.3095731277E+00, 8.1624471901E-01],
	[2.1285000000E+04, 1.1698519609E+01, 4.9613884390E+00, 2.1000238113E+00, 1.3102339777E+00, 8.1633094267E-01],
	[2.1290000000E+04, 1.1702659584E+01, 4.9612827366E+00, 2.1016074686E+00, 1.3108948558E+00, 8.1641713130E-01],
	[2.1295000000E+04, 1.1706800052E+01, 4.9611770614E+00, 2.1031919474E+00, 1.3115557618E+00, 8.1650328492E-01],
	[2.1300000000E+04, 1.1710941012E+01, 4.9610714132E+00, 2.1047772479E+00, 1.3122166954E+00, 8.1658940344E-01],
	[2.1305000000E+04, 1.1715082464E+01, 4.9609657921E+00, 2.1063633703E+00, 1.3128776567E+00, 8.1667548683E-01],
	[2.1310000000E+04, 1.1719224409E+01, 4.9608601980E+00, 2.1079503149E+00, 1.3135386454E+00, 8.1676153511E-01],
	[2.1315000000E+04, 1.1723366846E+01, 4.9607546309E+00, 2.1095380818E+00, 1.3141996614E+00, 8.1684754828E-01],
	[2.1320000000E+04, 1.1727509774E+01, 4.9606490908E+00, 2.1111266713E+00, 1.3148607045E+00, 8.1693352634E-01],
	[2.1325000000E+04, 1.1731653195E+01, 4.9605435777E+00, 2.1127160837E+00, 1.3155217745E+00, 8.1701946930E-01],
	[2.1330000000E+04, 1.1735797108E+01, 4.9604380916E+00, 2.1143063191E+00, 1.3161828714E+00, 8.1710537717E-01],
	[2.1335000000E+04, 1.1739941513E+01, 4.9603326325E+00, 2.1158973778E+00, 1.3168439950E+00, 8.1719124994E-01],
	[2.1340000000E+04, 1.1744086410E+01, 4.9602272003E+00, 2.1174892601E+00, 1.3175051450E+00, 8.1727708762E-01],
	[2.1345000000E+04, 1.1748231799E+01, 4.9601217950E+00, 2.1190819662E+00, 1.3181663214E+00, 8.1736289022E-01],
	[2.1350000000E+04, 1.1752377679E+01, 4.9600164167E+00, 2.1206754962E+00, 1.3188275241E+00, 8.1744865775E-01],
	[2.1355000000E+04, 1.1756524051E+01, 4.9599110653E+00, 2.1222698505E+00, 1.3194887527E+00, 8.1753439020E-01],
	[2.1360000000E+04, 1.1760670915E+01, 4.9598057408E+00, 2.1238650292E+00, 1.3201500073E+00, 8.1762008759E-01],
	[2.1365000000E+04, 1.1764818270E+01, 4.9597004432E+00, 2.1254610327E+00, 1.3208112877E+00, 8.1770574992E-01],
	[2.1370000000E+04, 1.1768966117E+01, 4.9595951725E+00, 2.1270578611E+00, 1.3214725936E+00, 8.1779137719E-01],
	[2.1375000000E+04, 1.1773114456E+01, 4.9594899286E+00, 2.1286555146E+00, 1.3221339250E+00, 8.1787696941E-01],
	[2.1380000000E+04, 1.1777263286E+01, 4.9593847115E+00, 2.1302539936E+00, 1.3227952817E+00, 8.1796252658E-01],
	[2.1385000000E+04, 1.1781412607E+01, 4.9592795213E+00, 2.1318532982E+00, 1.3234566635E+00, 8.1804804872E-01],
	[2.1390000000E+04, 1.1785577513E+01, 4.9591777016E+00, 2.1334534286E+00, 1.3241184992E+00, 8.1813353582E-01],
	[2.1395000000E+04, 1.1789746743E+01, 4.9590767549E+00, 2.1350543851E+00, 1.3247804691E+00, 8.1821898789E-01],
	[2.1400000000E+04, 1.1793916473E+01, 4.9589758338E+00, 2.1366561680E+00, 1.3254424645E+00, 8.1830440494E-01],
	[2.1405000000E+04, 1.1798086703E+01, 4.9588749384E+00, 2.1382587775E+00, 1.3261044853E+00, 8.1838978696E-01],
	[2.1410000000E+04, 1.1802257434E+01, 4.9587740686E+00, 2.1398622137E+00, 1.3267665312E+00, 8.1847513398E-01],
	[2.1415000000E+04, 1.1806428664E+01, 4.9586732244E+00, 2.1414664770E+00, 1.3274286021E+00, 8.1856044598E-01],
	[2.1420000000E+04, 1.1810600394E+01, 4.9585724057E+00, 2.1430715675E+00, 1.3280906979E+00, 8.1864572299E-01],
	[2.1425000000E+04, 1.1814772624E+01, 4.9584716127E+00, 2.1446774855E+00, 1.3287528184E+00, 8.1873096499E-01],
	[2.1430000000E+04, 1.1818945354E+01, 4.9583708452E+00, 2.1462842313E+00, 1.3294149635E+00, 8.1881617201E-01],
	[2.1435000000E+04, 1.1823118583E+01, 4.9582701033E+00, 2.1478918050E+00, 1.3300771331E+00, 8.1890134403E-01],
	[2.1440000000E+04, 1.1827292312E+01, 4.9581693869E+00, 2.1495002069E+00, 1.3307393268E+00, 8.1898648108E-01],
	[2.1445000000E+04, 1.1831466541E+01, 4.9580686961E+00, 2.1511094372E+00, 1.3314015447E+00, 8.1907158315E-01],
	[2.1450000000E+04, 1.1835641270E+01, 4.9579680307E+00, 2.1527194962E+00, 1.3320637866E+00, 8.1915665025E-01],
	[2.1455000000E+04, 1.1839816498E+01, 4.9578673909E+00, 2.1543303841E+00, 1.3327260523E+00, 8.1924168239E-01],
	[2.1460000000E+04, 1.1843992225E+01, 4.9577667766E+00, 2.1559421011E+00, 1.3333883416E+00, 8.1932667957E-01],
	[2.1465000000E+04, 1.1848168452E+01, 4.9576661877E+00, 2.1575546475E+00, 1.3340506545E+00, 8.1941164180E-01],
	[2.1470000000E+04, 1.1852345178E+01, 4.9575656244E+00, 2.1591680235E+00, 1.3347129907E+00, 8.1949656908E-01],
	[2.1475000000E+04, 1.1856522403E+01, 4.9574650864E+00, 2.1607822293E+00, 1.3353753501E+00, 8.1958146141E-01],
	[2.1480000000E+04, 1.1860700128E+01, 4.9573645739E+00, 2.1623972651E+00, 1.3360377326E+00, 8.1966631881E-01],
	[2.1485000000E+04, 1.1864878352E+01, 4.9572640869E+00, 2.1640131313E+00, 1.3367001379E+00, 8.1975114128E-01],
	[2.1490000000E+04, 1.1869057075E+01, 4.9571636253E+00, 2.1656298280E+00, 1.3373625661E+00, 8.1983592883E-01],
	[2.1495000000E+04, 1.1873236297E+01, 4.9570631890E+00, 2.1672473554E+00, 1.3380250168E+00, 8.1992068145E-01],
	[2.1500000000E+04, 1.1877416018E+01, 4.9569627782E+00, 2.1688657138E+00, 1.3386874900E+00, 8.2000539916E-01],
	[2.1505000000E+04, 1.1881596238E+01, 4.9568623928E+00, 2.1704849034E+00, 1.3393499855E+00, 8.2009008197E-01],
	[2.1510000000E+04, 1.1885776957E+01, 4.9567620327E+00, 2.1721049245E+00, 1.3400125032E+00, 8.2017472987E-01],
	[2.1515000000E+04, 1.1889958175E+01, 4.9566616980E+00, 2.1737257773E+00, 1.3406750429E+00, 8.2025934288E-01],
	[2.1520000000E+04, 1.1894139891E+01, 4.9565613886E+00, 2.1753474621E+00, 1.3413376044E+00, 8.2034392099E-01],
	[2.1525000000E+04, 1.1898322106E+01, 4.9564611045E+00, 2.1769699789E+00, 1.3420001876E+00, 8.2042846422E-01],
	[2.1530000000E+04, 1.1902504820E+01, 4.9563608458E+00, 2.1785933282E+00, 1.3426627924E+00, 8.2051297258E-01],
	[2.1535000000E+04, 1.1906688033E+01, 4.9562606124E+00, 2.1802175101E+00, 1.3433254185E+00, 8.2059744606E-01],
	[2.1540000000E+04, 1.1910871744E+01, 4.9561604043E+00, 2.1818425248E+00, 1.3439880660E+00, 8.2068188467E-01],
	[2.1545000000E+04, 1.1915055954E+01, 4.9560602214E+00, 2.1834683726E+00, 1.3446507345E+00, 8.2076628842E-01],
	[2.1550000000E+04, 1.1919240662E+01, 4.9559600639E+00, 2.1850950538E+00, 1.3453134240E+00, 8.2085065731E-01],
	[2.1555000000E+04, 1.1923425868E+01, 4.9558599316E+00, 2.1867225685E+00, 1.3459761342E+00, 8.2093499136E-01],
	[2.1560000000E+04, 1.1927611573E+01, 4.9557598245E+00, 2.1883509170E+00, 1.3466388652E+00, 8.2101929056E-01],
	[2.1565000000E+04, 1.1931797776E+01, 4.9556597427E+00, 2.1899800995E+00, 1.3473016166E+00, 8.2110355493E-01],
	[2.1570000000E+04, 1.1935984477E+01, 4.9555596861E+00, 2.1916101163E+00, 1.3479643884E+00, 8.2118778446E-01],
	[2.1575000000E+04, 1.1940171677E+01, 4.9554596547E+00, 2.1932409675E+00, 1.3486271804E+00, 8.2127197917E-01],
	[2.1580000000E+04, 1.1944359374E+01, 4.9553596485E+00, 2.1948726535E+00, 1.3492899924E+00, 8.2135613906E-01],
	[2.1585000000E+04, 1.1948547570E+01, 4.9552596675E+00, 2.1965051745E+00, 1.3499528243E+00, 8.2144026414E-01],
	[2.1590000000E+04, 1.1952736264E+01, 4.9551597116E+00, 2.1981385306E+00, 1.3506156760E+00, 8.2152435441E-01],
	[2.1595000000E+04, 1.1956925455E+01, 4.9550597810E+00, 2.1997727221E+00, 1.3512785473E+00, 8.2160840987E-01],
	[2.1600000000E+04, 1.1961115145E+01, 4.9549598754E+00, 2.2014077493E+00, 1.3519414381E+00, 8.2169243055E-01],
	[2.1605000000E+04, 1.1965305332E+01, 4.9548599951E+00, 2.2030436124E+00, 1.3526043481E+00, 8.2177641643E-01],
	[2.1610000000E+04, 1.1969496017E+01, 4.9547601398E+00, 2.2046803116E+00, 1.3532672773E+00, 8.2186036753E-01],
	[2.1615000000E+04, 1.1973687200E+01, 4.9546603096E+00, 2.2063178472E+00, 1.3539302255E+00, 8.2194428385E-01],
	[2.1620000000E+04, 1.1977878880E+01, 4.9545605046E+00, 2.2079562194E+00, 1.3545931926E+00, 8.2202816540E-01],
	[2.1625000000E+04, 1.1982071058E+01, 4.9544607246E+00, 2.2095954283E+00, 1.3552561783E+00, 8.2211201219E-01],
	[2.1630000000E+04, 1.1986263734E+01, 4.9543609698E+00, 2.2112354744E+00, 1.3559191826E+00, 8.2219582422E-01],
	[2.1635000000E+04, 1.1990456907E+01, 4.9542612399E+00, 2.2128763577E+00, 1.3565822054E+00, 8.2227960150E-01],
	[2.1640000000E+04, 1.1994650577E+01, 4.9541615352E+00, 2.2145180786E+00, 1.3572452464E+00, 8.2236334403E-01],
	[2.1645000000E+04, 1.1998844745E+01, 4.9540618555E+00, 2.2161606372E+00, 1.3579083054E+00, 8.2244705182E-01],
	[2.1650000000E+04, 1.2003039410E+01, 4.9539622008E+00, 2.2178040337E+00, 1.3585713825E+00, 8.2253072488E-01],
	[2.1655000000E+04, 1.2007234573E+01, 4.9538625711E+00, 2.2194482686E+00, 1.3592344774E+00, 8.2261436321E-01],
	[2.1660000000E+04, 1.2011430232E+01, 4.9537629664E+00, 2.2210933418E+00, 1.3598975899E+00, 8.2269796683E-01],
	[2.1665000000E+04, 1.2015626389E+01, 4.9536633867E+00, 2.2227392538E+00, 1.3605607199E+00, 8.2278153572E-01],
	[2.1670000000E+04, 1.2019823043E+01, 4.9535638320E+00, 2.2243860047E+00, 1.3612238673E+00, 8.2286506991E-01],
	[2.1675000000E+04, 1.2024020194E+01, 4.9534643023E+00, 2.2260335947E+00, 1.3618870319E+00, 8.2294856940E-01],
	[2.1680000000E+04, 1.2028217842E+01, 4.9533647975E+00, 2.2276820241E+00, 1.3625502136E+00, 8.2303203419E-01],
	[2.1685000000E+04, 1.2032415987E+01, 4.9532653177E+00, 2.2293312932E+00, 1.3632134122E+00, 8.2311546429E-01],
	[2.1690000000E+04, 1.2036614629E+01, 4.9531658628E+00, 2.2309814021E+00, 1.3638766276E+00, 8.2319885971E-01],
	[2.1695000000E+04, 1.2040813767E+01, 4.9530664328E+00, 2.2326323511E+00, 1.3645398596E+00, 8.2328222046E-01],
	[2.1700000000E+04, 1.2045013403E+01, 4.9529670277E+00, 2.2342841404E+00, 1.3652031080E+00, 8.2336554653E-01],
	[2.1705000000E+04, 1.2049213535E+01, 4.9528676475E+00, 2.2359367703E+00, 1.3658663728E+00, 8.2344883794E-01],
	[2.1710000000E+04, 1.2053414163E+01, 4.9527682922E+00, 2.2375902409E+00, 1.3665296538E+00, 8.2353209470E-01],
	[2.1715000000E+04, 1.2057615289E+01, 4.9526689618E+00, 2.2392445526E+00, 1.3671929508E+00, 8.2361531680E-01],
	[2.1720000000E+04, 1.2061816911E+01, 4.9525696562E+00, 2.2408997056E+00, 1.3678562636E+00, 8.2369850426E-01],
	[2.1725000000E+04, 1.2066019029E+01, 4.9524703755E+00, 2.2425557000E+00, 1.3685195922E+00, 8.2378165709E-01],
	[2.1730000000E+04, 1.2070221644E+01, 4.9523711196E+00, 2.2442125362E+00, 1.3691829364E+00, 8.2386477528E-01],
	[2.1735000000E+04, 1.2074442769E+01, 4.9522757751E+00, 2.2458702143E+00, 1.3698468252E+00, 8.2394785885E-01],
	[2.1740000000E+04, 1.2078665535E+01, 4.9521806992E+00, 2.2475287346E+00, 1.3705107635E+00, 8.2403090780E-01],
	[2.1745000000E+04, 1.2082888806E+01, 4.9520856471E+00, 2.2491880974E+00, 1.3711747177E+00, 8.2411392214E-01],
	[2.1750000000E+04, 1.2087112582E+01, 4.9519906186E+00, 2.2508483028E+00, 1.3718386877E+00, 8.2419690188E-01],
	[2.1755000000E+04, 1.2091336863E+01, 4.9518956138E+00, 2.2525093511E+00, 1.3725026733E+00, 8.2427984702E-01],
	[2.1760000000E+04, 1.2095561649E+01, 4.9518006327E+00, 2.2541712425E+00, 1.3731666744E+00, 8.2436275757E-01],
	[2.1765000000E+04, 1.2099786940E+01, 4.9517056751E+00, 2.2558339773E+00, 1.3738306909E+00, 8.2444563353E-01],
	[2.1770000000E+04, 1.2104012736E+01, 4.9516107413E+00, 2.2574975557E+00, 1.3744947226E+00, 8.2452847492E-01],
	[2.1775000000E+04, 1.2108239038E+01, 4.9515158310E+00, 2.2591619779E+00, 1.3751587693E+00, 8.2461128173E-01],
	[2.1780000000E+04, 1.2112465843E+01, 4.9514209444E+00, 2.2608272442E+00, 1.3758228310E+00, 8.2469405398E-01],
	[2.1785000000E+04, 1.2116693154E+01, 4.9513260813E+00, 2.2624933547E+00, 1.3764869074E+00, 8.2477679168E-01],
	[2.1790000000E+04, 1.2120920970E+01, 4.9512312418E+00, 2.2641603098E+00, 1.3771509984E+00, 8.2485949482E-01],
	[2.1795000000E+04, 1.2125149290E+01, 4.9511364260E+00, 2.2658281097E+00, 1.3778151039E+00, 8.2494216342E-01],
	[2.1800000000E+04, 1.2129378114E+01, 4.9510416336E+00, 2.2674967545E+00, 1.3784792237E+00, 8.2502479748E-01],
	[2.1805000000E+04, 1.2133607444E+01, 4.9509468649E+00, 2.2691662446E+00, 1.3791433576E+00, 8.2510739702E-01],
	[2.1810000000E+04, 1.2137837277E+01, 4.9508521196E+00, 2.2708365802E+00, 1.3798075056E+00, 8.2518996202E-01],
	[2.1815000000E+04, 1.2142067615E+01, 4.9507573979E+00, 2.2725077614E+00, 1.3804716675E+00, 8.2527249252E-01],
	[2.1820000000E+04, 1.2146298458E+01, 4.9506626998E+00, 2.2741797886E+00, 1.3811358431E+00, 8.2535498850E-01],
	[2.1825000000E+04, 1.2150529805E+01, 4.9505680251E+00, 2.2758526619E+00, 1.3818000322E+00, 8.2543744998E-01],
	[2.1830000000E+04, 1.2154761656E+01, 4.9504733739E+00, 2.2775263817E+00, 1.3824642349E+00, 8.2551987696E-01],
	[2.1835000000E+04, 1.2158994012E+01, 4.9503787462E+00, 2.2792009481E+00, 1.3831284508E+00, 8.2560226946E-01],
	[2.1840000000E+04, 1.2163226871E+01, 4.9502841420E+00, 2.2808763613E+00, 1.3837926798E+00, 8.2568462747E-01],
	[2.1845000000E+04, 1.2167460235E+01, 4.9501895613E+00, 2.2825526216E+00, 1.3844569219E+00, 8.2576695101E-01],
	[2.1850000000E+04, 1.2171694103E+01, 4.9500950040E+00, 2.2842297293E+00, 1.3851211767E+00, 8.2584924007E-01],
	[2.1855000000E+04, 1.2175928474E+01, 4.9500004701E+00, 2.2859076846E+00, 1.3857854443E+00, 8.2593149468E-01],
	[2.1860000000E+04, 1.2180163350E+01, 4.9499059597E+00, 2.2875864876E+00, 1.3864497245E+00, 8.2601371484E-01],
	[2.1865000000E+04, 1.2184398730E+01, 4.9498114727E+00, 2.2892661387E+00, 1.3871140171E+00, 8.2609590054E-01],
	[2.1870000000E+04, 1.2188634613E+01, 4.9497170091E+00, 2.2909466381E+00, 1.3877783219E+00, 8.2617805181E-01],
	[2.1875000000E+04, 1.2192871000E+01, 4.9496225689E+00, 2.2926279859E+00, 1.3884426388E+00, 8.2626016864E-01],
	[2.1880000000E+04, 1.2197107891E+01, 4.9495281521E+00, 2.2943101825E+00, 1.3891069678E+00, 8.2634225105E-01],
	[2.1885000000E+04, 1.2201345286E+01, 4.9494337586E+00, 2.2959932281E+00, 1.3897713085E+00, 8.2642429903E-01],
	[2.1890000000E+04, 1.2205583184E+01, 4.9493393885E+00, 2.2976771229E+00, 1.3904356609E+00, 8.2650631261E-01],
	[2.1895000000E+04, 1.2209821586E+01, 4.9492450418E+00, 2.2993618671E+00, 1.3911000249E+00, 8.2658829178E-01],
	[2.1900000000E+04, 1.2214060491E+01, 4.9491507184E+00, 2.3010474610E+00, 1.3917644002E+00, 8.2667023655E-01],
	[2.1905000000E+04, 1.2218299900E+01, 4.9490564184E+00, 2.3027339048E+00, 1.3924287868E+00, 8.2675214693E-01],
	[2.1910000000E+04, 1.2222539812E+01, 4.9489621416E+00, 2.3044211988E+00, 1.3930931845E+00, 8.2683402293E-01],
	[2.1915000000E+04, 1.2226780227E+01, 4.9488678882E+00, 2.3061093431E+00, 1.3937575931E+00, 8.2691586455E-01],
	[2.1920000000E+04, 1.2231021146E+01, 4.9487736580E+00, 2.3077983380E+00, 1.3944220126E+00, 8.2699767180E-01],
	[2.1925000000E+04, 1.2235262568E+01, 4.9486794512E+00, 2.3094881838E+00, 1.3950864426E+00, 8.2707944469E-01],
	[2.1930000000E+04, 1.2239504493E+01, 4.9485852676E+00, 2.3111788806E+00, 1.3957508833E+00, 8.2716118323E-01],
	[2.1935000000E+04, 1.2243746921E+01, 4.9484911073E+00, 2.3128704288E+00, 1.3964153342E+00, 8.2724288742E-01],
	[2.1940000000E+04, 1.2247989852E+01, 4.9483969702E+00, 2.3145628285E+00, 1.3970797954E+00, 8.2732455726E-01],
	[2.1945000000E+04, 1.2252233287E+01, 4.9483028564E+00, 2.3162560800E+00, 1.3977442667E+00, 8.2740619278E-01],
	[2.1950000000E+04, 1.2256477224E+01, 4.9482087658E+00, 2.3179501835E+00, 1.3984087479E+00, 8.2748779397E-01],
	[2.1955000000E+04, 1.2260721664E+01, 4.9481146984E+00, 2.3196451393E+00, 1.3990732389E+00, 8.2756936084E-01],
	[2.1960000000E+04, 1.2264966607E+01, 4.9480206543E+00, 2.3213409475E+00, 1.3997377395E+00, 8.2765089340E-01],
	[2.1965000000E+04, 1.2269212053E+01, 4.9479266333E+00, 2.3230376084E+00, 1.4004022496E+00, 8.2773239165E-01],
	[2.1970000000E+04, 1.2273458001E+01, 4.9478326355E+00, 2.3247351224E+00, 1.4010667691E+00, 8.2781385561E-01],
	[2.1975000000E+04, 1.2277704453E+01, 4.9477386609E+00, 2.3264334894E+00, 1.4017312978E+00, 8.2789528528E-01],
	[2.1980000000E+04, 1.2281951406E+01, 4.9476447095E+00, 2.3281327099E+00, 1.4023958355E+00, 8.2797668067E-01],
	[2.1985000000E+04, 1.2286198863E+01, 4.9475507812E+00, 2.3298327841E+00, 1.4030603822E+00, 8.2805804178E-01],
	[2.1990000000E+04, 1.2290446822E+01, 4.9474568760E+00, 2.3315337122E+00, 1.4037249376E+00, 8.2813936863E-01],
	[2.1995000000E+04, 1.2294695283E+01, 4.9473629940E+00, 2.3332354943E+00, 1.4043895017E+00, 8.2822066122E-01],
	[2.2000000000E+04, 1.2298944247E+01, 4.9472691351E+00, 2.3349381308E+00, 1.4050540742E+00, 8.2830191955E-01],
	[2.2005000000E+04, 1.2303193713E+01, 4.9471752993E+00, 2.3366416220E+00, 1.4057186551E+00, 8.2838314364E-01],
	[2.2010000000E+04, 1.2307443681E+01, 4.9470814867E+00, 2.3383459679E+00, 1.4063832442E+00, 8.2846433350E-01],
	[2.2015000000E+04, 1.2311694152E+01, 4.9469876971E+00, 2.3400511689E+00, 1.4070478413E+00, 8.2854548912E-01],
	[2.2020000000E+04, 1.2315945125E+01, 4.9468939305E+00, 2.3417572252E+00, 1.4077124463E+00, 8.2862661052E-01],
	[2.2025000000E+04, 1.2320196600E+01, 4.9468001871E+00, 2.3434641370E+00, 1.4083770590E+00, 8.2870769770E-01],
	[2.2030000000E+04, 1.2324448577E+01, 4.9467064667E+00, 2.3451719046E+00, 1.4090416794E+00, 8.2878875068E-01],
	[2.2035000000E+04, 1.2328701056E+01, 4.9466127693E+00, 2.3468805282E+00, 1.4097063073E+00, 8.2886976946E-01],
	[2.2040000000E+04, 1.2332954037E+01, 4.9465190950E+00, 2.3485900080E+00, 1.4103709425E+00, 8.2895075405E-01],
	[2.2045000000E+04, 1.2337207520E+01, 4.9464254437E+00, 2.3503003442E+00, 1.4110355848E+00, 8.2903170445E-01],
	[2.2050000000E+04, 1.2341461505E+01, 4.9463318154E+00, 2.3520115372E+00, 1.4117002342E+00, 8.2911262068E-01],
	[2.2055000000E+04, 1.2345715991E+01, 4.9462382101E+00, 2.3537235871E+00, 1.4123648905E+00, 8.2919350273E-01],
	[2.2060000000E+04, 1.2349970979E+01, 4.9461446278E+00, 2.3554364941E+00, 1.4130295535E+00, 8.2927435063E-01],
	[2.2065000000E+04, 1.2354226470E+01, 4.9460510684E+00, 2.3571502586E+00, 1.4136942232E+00, 8.2935516437E-01],
	[2.2070000000E+04, 1.2358482461E+01, 4.9459575321E+00, 2.3588648807E+00, 1.4143588993E+00, 8.2943594396E-01],
	[2.2075000000E+04, 1.2362738954E+01, 4.9458640187E+00, 2.3605803607E+00, 1.4150235817E+00, 8.2951668941E-01],
	[2.2080000000E+04, 1.2366995949E+01, 4.9457705282E+00, 2.3622966988E+00, 1.4156882703E+00, 8.2959740074E-01],
	[2.2085000000E+04, 1.2371272347E+01, 4.9456810323E+00, 2.3640138952E+00, 1.4163535384E+00, 8.2967807794E-01],
	[2.2090000000E+04, 1.2375549739E+01, 4.9455916598E+00, 2.3657319501E+00, 1.4170188278E+00, 8.2975872102E-01],
	[2.2095000000E+04, 1.2379827641E+01, 4.9455023092E+00, 2.3674508639E+00, 1.4176841238E+00, 8.2983933000E-01],
	[2.2100000000E+04, 1.2384106053E+01, 4.9454129803E+00, 2.3691706368E+00, 1.4183494262E+00, 8.2991990487E-01],
	[2.2105000000E+04, 1.2388384976E+01, 4.9453236733E+00, 2.3708912689E+00, 1.4190147349E+00, 8.3000044565E-01],
	[2.2110000000E+04, 1.2392664409E+01, 4.9452343882E+00, 2.3726127605E+00, 1.4196800497E+00, 8.3008095235E-01],
	[2.2115000000E+04, 1.2396944352E+01, 4.9451451248E+00, 2.3743351119E+00, 1.4203453705E+00, 8.3016142497E-01],
	[2.2120000000E+04, 1.2401224805E+01, 4.9450558832E+00, 2.3760583232E+00, 1.4210106971E+00, 8.3024186352E-01],
	[2.2125000000E+04, 1.2405505768E+01, 4.9449666634E+00, 2.3777823948E+00, 1.4216760294E+00, 8.3032226801E-01],
	[2.2130000000E+04, 1.2409787241E+01, 4.9448774653E+00, 2.3795073268E+00, 1.4223413672E+00, 8.3040263845E-01],
	[2.2135000000E+04, 1.2414069223E+01, 4.9447882890E+00, 2.3812331195E+00, 1.4230067105E+00, 8.3048297484E-01],
	[2.2140000000E+04, 1.2418351716E+01, 4.9446991345E+00, 2.3829597731E+00, 1.4236720590E+00, 8.3056327719E-01],
	[2.2145000000E+04, 1.2422634719E+01, 4.9446100017E+00, 2.3846872878E+00, 1.4243374127E+00, 8.3064354552E-01],
	[2.2150000000E+04, 1.2426918231E+01, 4.9445208906E+00, 2.3864156640E+00, 1.4250027713E+00, 8.3072377982E-01],
	[2.2155000000E+04, 1.2431202253E+01, 4.9444318013E+00, 2.3881449017E+00, 1.4256681347E+00, 8.3080398010E-01],
	[2.2160000000E+04, 1.2435486785E+01, 4.9443427336E+00, 2.3898750013E+00, 1.4263335029E+00, 8.3088414638E-01],
	[2.2165000000E+04, 1.2439771826E+01, 4.9442536877E+00, 2.3916059631E+00, 1.4269988756E+00, 8.3096427866E-01],
	[2.2170000000E+04, 1.2444057377E+01, 4.9441646634E+00, 2.3933377871E+00, 1.4276642527E+00, 8.3104437695E-01],
	[2.2175000000E+04, 1.2448343437E+01, 4.9440756609E+00, 2.3950704737E+00, 1.4283296340E+00, 8.3112444126E-01],
	[2.2180000000E+04, 1.2452630006E+01, 4.9439866799E+00, 2.3968040231E+00, 1.4289950195E+00, 8.3120447159E-01],
	[2.2185000000E+04, 1.2456917085E+01, 4.9438977207E+00, 2.3985384355E+00, 1.4296604090E+00, 8.3128446796E-01],
	[2.2190000000E+04, 1.2461204674E+01, 4.9438087831E+00, 2.4002737112E+00, 1.4303258023E+00, 8.3136443036E-01],
	[2.2195000000E+04, 1.2465492771E+01, 4.9437198671E+00, 2.4020098503E+00, 1.4309911993E+00, 8.3144435882E-01],
	[2.2200000000E+04, 1.2469781378E+01, 4.9436309728E+00, 2.4037468532E+00, 1.4316565999E+00, 8.3152425333E-01],
	[2.2205000000E+04, 1.2474070494E+01, 4.9435421000E+00, 2.4054847201E+00, 1.4323220038E+00, 8.3160411391E-01],
	[2.2210000000E+04, 1.2478360119E+01, 4.9434532489E+00, 2.4072234512E+00, 1.4329874111E+00, 8.3168394057E-01],
	[2.2215000000E+04, 1.2482650253E+01, 4.9433644194E+00, 2.4089630467E+00, 1.4336528215E+00, 8.3176373330E-01],
	[2.2220000000E+04, 1.2486940896E+01, 4.9432756115E+00, 2.4107035069E+00, 1.4343182348E+00, 8.3184349212E-01],
	[2.2225000000E+04, 1.2491232049E+01, 4.9431868251E+00, 2.4124448319E+00, 1.4349836510E+00, 8.3192321704E-01],
	[2.2230000000E+04, 1.2495523709E+01, 4.9430980603E+00, 2.4141870222E+00, 1.4356490699E+00, 8.3200290807E-01],
	[2.2235000000E+04, 1.2499815879E+01, 4.9430093171E+00, 2.4159300778E+00, 1.4363144914E+00, 8.3208256521E-01],
	[2.2240000000E+04, 1.2504108558E+01, 4.9429205954E+00, 2.4176739990E+00, 1.4369799153E+00, 8.3216218847E-01],
	[2.2245000000E+04, 1.2508401745E+01, 4.9428318952E+00, 2.4194187860E+00, 1.4376453415E+00, 8.3224177786E-01],
	[2.2250000000E+04, 1.2512695441E+01, 4.9427432166E+00, 2.4211644392E+00, 1.4383107698E+00, 8.3232133339E-01],
	[2.2255000000E+04, 1.2516989645E+01, 4.9426545595E+00, 2.4229109586E+00, 1.4389762001E+00, 8.3240085507E-01],
	[2.2260000000E+04, 1.2521284358E+01, 4.9425659239E+00, 2.4246583446E+00, 1.4396416322E+00, 8.3248034290E-01],
	[2.2265000000E+04, 1.2525579580E+01, 4.9424773098E+00, 2.4264065974E+00, 1.4403070661E+00, 8.3255979690E-01],
	[2.2270000000E+04, 1.2529875310E+01, 4.9423887172E+00, 2.4281557171E+00, 1.4409725015E+00, 8.3263921706E-01],
	[2.2275000000E+04, 1.2534171548E+01, 4.9423001460E+00, 2.4299057042E+00, 1.4416379384E+00, 8.3271860341E-01],
	[2.2280000000E+04, 1.2538468295E+01, 4.9422115963E+00, 2.4316565587E+00, 1.4423033766E+00, 8.3279795594E-01],
	[2.2285000000E+04, 1.2542765550E+01, 4.9421230681E+00, 2.4334082810E+00, 1.4429688159E+00, 8.3287727466E-01],
	[2.2290000000E+04, 1.2547063314E+01, 4.9420345613E+00, 2.4351608712E+00, 1.4436342562E+00, 8.3295655960E-01],
	[2.2295000000E+04, 1.2551361585E+01, 4.9419460760E+00, 2.4369143296E+00, 1.4442996974E+00, 8.3303581074E-01],
	[2.2300000000E+04, 1.2555660365E+01, 4.9418576120E+00, 2.4386686564E+00, 1.4449651393E+00, 8.3311502810E-01],
	[2.2305000000E+04, 1.2559959652E+01, 4.9417691695E+00, 2.4404238519E+00, 1.4456305818E+00, 8.3319421170E-01],
	[2.2310000000E+04, 1.2564259448E+01, 4.9416807484E+00, 2.4421799163E+00, 1.4462960247E+00, 8.3327336152E-01],
	[2.2315000000E+04, 1.2568559752E+01, 4.9415923487E+00, 2.4439368498E+00, 1.4469614680E+00, 8.3335247760E-01],
	[2.2320000000E+04, 1.2572860563E+01, 4.9415039704E+00, 2.4456946527E+00, 1.4476269114E+00, 8.3343155993E-01],
	[2.2325000000E+04, 1.2577161882E+01, 4.9414156135E+00, 2.4474533251E+00, 1.4482923548E+00, 8.3351060852E-01],
	[2.2330000000E+04, 1.2581463710E+01, 4.9413272779E+00, 2.4492128674E+00, 1.4489577982E+00, 8.3358962338E-01],
	[2.2335000000E+04, 1.2585766045E+01, 4.9412389637E+00, 2.4509732798E+00, 1.4496232412E+00, 8.3366860452E-01],
	[2.2340000000E+04, 1.2590068887E+01, 4.9411506708E+00, 2.4527345625E+00, 1.4502886839E+00, 8.3374755195E-01],
	[2.2345000000E+04, 1.2594372238E+01, 4.9410623993E+00, 2.4544967158E+00, 1.4509541260E+00, 8.3382646567E-01],
	[2.2350000000E+04, 1.2598676095E+01, 4.9409741491E+00, 2.4562597398E+00, 1.4516195675E+00, 8.3390534568E-01],
	[2.2355000000E+04, 1.2602980461E+01, 4.9408859202E+00, 2.4580236348E+00, 1.4522850081E+00, 8.3398419201E-01],
	[2.2360000000E+04, 1.2607285334E+01, 4.9407977126E+00, 2.4597884010E+00, 1.4529504478E+00, 8.3406300464E-01],
	[2.2365000000E+04, 1.2611590714E+01, 4.9407095263E+00, 2.4615641324E+00, 1.4536194063E+00, 8.3414178360E-01],
	[2.2370000000E+04, 1.2615896602E+01, 4.9406213613E+00, 2.4633423919E+00, 1.4542889371E+00, 8.3422052888E-01],
	[2.2375000000E+04, 1.2620202997E+01, 4.9405332176E+00, 2.4651215376E+00, 1.4549584673E+00, 8.3429924050E-01],
	[2.2380000000E+04, 1.2624509899E+01, 4.9404450951E+00, 2.4669015697E+00, 1.4556279967E+00, 8.3437791846E-01],
	[2.2385000000E+04, 1.2628817309E+01, 4.9403569939E+00, 2.4686824886E+00, 1.4562975251E+00, 8.3445656277E-01],
	[2.2390000000E+04, 1.2633125225E+01, 4.9402689139E+00, 2.4704642945E+00, 1.4569670524E+00, 8.3453517343E-01],
	[2.2395000000E+04, 1.2637433649E+01, 4.9401808552E+00, 2.4722469875E+00, 1.4576365785E+00, 8.3461375045E-01],
	[2.2400000000E+04, 1.2641742580E+01, 4.9400928177E+00, 2.4740305680E+00, 1.4583061032E+00, 8.3469229384E-01],
	[2.2405000000E+04, 1.2646052018E+01, 4.9400048014E+00, 2.4758150361E+00, 1.4589756264E+00, 8.3477080361E-01],
	[2.2410000000E+04, 1.2650361962E+01, 4.9399168064E+00, 2.4776003922E+00, 1.4596451479E+00, 8.3484927976E-01],
	[2.2415000000E+04, 1.2654672414E+01, 4.9398288325E+00, 2.4793866365E+00, 1.4603146675E+00, 8.3492772230E-01],
	[2.2420000000E+04, 1.2658983373E+01, 4.9397408798E+00, 2.4811737692E+00, 1.4609841853E+00, 8.3500613123E-01],
	[2.2425000000E+04, 1.2663294838E+01, 4.9396529483E+00, 2.4829617905E+00, 1.4616537009E+00, 8.3508450658E-01],
	[2.2430000000E+04, 1.2667606810E+01, 4.9395650380E+00, 2.4847507007E+00, 1.4623232143E+00, 8.3516284833E-01],
	[2.2435000000E+04, 1.2671919288E+01, 4.9394771488E+00, 2.4865405001E+00, 1.4629927253E+00, 8.3524115650E-01],
	[2.2440000000E+04, 1.2676249604E+01, 4.9393928272E+00, 2.4883311889E+00, 1.4636627762E+00, 8.3531943110E-01],
	[2.2445000000E+04, 1.2680582729E+01, 4.9393089952E+00, 2.4901227673E+00, 1.4643328971E+00, 8.3539767213E-01],
	[2.2450000000E+04, 1.2684916370E+01, 4.9392251834E+00, 2.4919152355E+00, 1.4650030160E+00, 8.3547587960E-01],
	[2.2455000000E+04, 1.2689250527E+01, 4.9391413917E+00, 2.4937085939E+00, 1.4656731328E+00, 8.3555405351E-01],
	[2.2460000000E+04, 1.2693585198E+01, 4.9390576200E+00, 2.4955028427E+00, 1.4663432473E+00, 8.3563219388E-01],
	[2.2465000000E+04, 1.2697920385E+01, 4.9389738684E+00, 2.4972979820E+00, 1.4670133594E+00, 8.3571030072E-01],
	[2.2470000000E+04, 1.2702256088E+01, 4.9388901369E+00, 2.4990940122E+00, 1.4676834689E+00, 8.3578837402E-01],
	[2.2475000000E+04, 1.2706592306E+01, 4.9388064254E+00, 2.5008909335E+00, 1.4683535758E+00, 8.3586641380E-01],
	[2.2480000000E+04, 1.2710929039E+01, 4.9387227339E+00, 2.5026887461E+00, 1.4690236798E+00, 8.3594442006E-01],
	[2.2485000000E+04, 1.2715266287E+01, 4.9386390625E+00, 2.5044874503E+00, 1.4696937809E+00, 8.3602239281E-01],
	[2.2490000000E+04, 1.2719604050E+01, 4.9385554111E+00, 2.5062870463E+00, 1.4703638788E+00, 8.3610033207E-01],
	[2.2495000000E+04, 1.2723942328E+01, 4.9384717797E+00, 2.5080875344E+00, 1.4710339735E+00, 8.3617823782E-01],
	[2.2500000000E+04, 1.2728281121E+01, 4.9383881683E+00, 2.5098889147E+00, 1.4717040648E+00, 8.3625611009E-01],
	[2.2505000000E+04, 1.2732620429E+01, 4.9383045769E+00, 2.5116911877E+00, 1.4723741525E+00, 8.3633394888E-01],
	[2.2510000000E+04, 1.2736960252E+01, 4.9382210055E+00, 2.5134943534E+00, 1.4730442366E+00, 8.3641175420E-01],
	[2.2515000000E+04, 1.2741300590E+01, 4.9381374541E+00, 2.5152984121E+00, 1.4737143169E+00, 8.3648952605E-01],
	[2.2520000000E+04, 1.2745641443E+01, 4.9380539226E+00, 2.5171033642E+00, 1.4743843932E+00, 8.3656726445E-01],
	[2.2525000000E+04, 1.2749982810E+01, 4.9379704111E+00, 2.5189092097E+00, 1.4750544654E+00, 8.3664496939E-01],
	[2.2530000000E+04, 1.2754324692E+01, 4.9378869195E+00, 2.5207159490E+00, 1.4757245334E+00, 8.3672264090E-01],
	[2.2535000000E+04, 1.2758667089E+01, 4.9378034479E+00, 2.5225235824E+00, 1.4763945969E+00, 8.3680027896E-01],
	[2.2540000000E+04, 1.2763010000E+01, 4.9377199962E+00, 2.5243321100E+00, 1.4770646560E+00, 8.3687788360E-01],
	[2.2545000000E+04, 1.2767353426E+01, 4.9376365644E+00, 2.5261415320E+00, 1.4777347104E+00, 8.3695545482E-01],
	[2.2550000000E+04, 1.2771697366E+01, 4.9375531526E+00, 2.5279518489E+00, 1.4784047601E+00, 8.3703299263E-01],
	[2.2555000000E+04, 1.2776041821E+01, 4.9374697606E+00, 2.5297630607E+00, 1.4790748047E+00, 8.3711049703E-01],
	[2.2560000000E+04, 1.2780386790E+01, 4.9373863885E+00, 2.5315751677E+00, 1.4797448443E+00, 8.3718796804E-01],
	[2.2565000000E+04, 1.2784732273E+01, 4.9373030363E+00, 2.5333881702E+00, 1.4804148787E+00, 8.3726540565E-01],
	[2.2570000000E+04, 1.2789078271E+01, 4.9372197040E+00, 2.5352020684E+00, 1.4810849077E+00, 8.3734280988E-01],
	[2.2575000000E+04, 1.2793424783E+01, 4.9371363916E+00, 2.5370168626E+00, 1.4817549313E+00, 8.3742018074E-01],
	[2.2580000000E+04, 1.2797771809E+01, 4.9370530990E+00, 2.5388325530E+00, 1.4824249492E+00, 8.3749751823E-01],
	[2.2585000000E+04, 1.2802119349E+01, 4.9369698262E+00, 2.5406491398E+00, 1.4830949613E+00, 8.3757482236E-01],
	[2.2590000000E+04, 1.2806467403E+01, 4.9368865733E+00, 2.5424666233E+00, 1.4837649675E+00, 8.3765209314E-01],
	[2.2595000000E+04, 1.2810815971E+01, 4.9368033402E+00, 2.5442850038E+00, 1.4844349676E+00, 8.3772933057E-01],
	[2.2600000000E+04, 1.2815165052E+01, 4.9367201270E+00, 2.5461042814E+00, 1.4851049615E+00, 8.3780653467E-01],
	[2.2605000000E+04, 1.2819514648E+01, 4.9366369335E+00, 2.5479244564E+00, 1.4857749492E+00, 8.3788370544E-01],
	[2.2610000000E+04, 1.2823864758E+01, 4.9365537599E+00, 2.5497455291E+00, 1.4864449303E+00, 8.3796084289E-01],
	[2.2615000000E+04, 1.2828215381E+01, 4.9364706060E+00, 2.5515674997E+00, 1.4871149048E+00, 8.3803794702E-01],
	[2.2620000000E+04, 1.2832566519E+01, 4.9363874719E+00, 2.5533903685E+00, 1.4877848726E+00, 8.3811501785E-01],
	[2.2625000000E+04, 1.2836918169E+01, 4.9363043576E+00, 2.5552141356E+00, 1.4884548335E+00, 8.3819205538E-01],
	[2.2630000000E+04, 1.2841270334E+01, 4.9362212631E+00, 2.5570388014E+00, 1.4891247873E+00, 8.3826905962E-01],
	[2.2635000000E+04, 1.2845623012E+01, 4.9361381883E+00, 2.5588643661E+00, 1.4897947340E+00, 8.3834603057E-01],
	[2.2640000000E+04, 1.2849976203E+01, 4.9360551333E+00, 2.5606908299E+00, 1.4904646733E+00, 8.3842296825E-01],
	[2.2645000000E+04, 1.2854329908E+01, 4.9359720980E+00, 2.5625181930E+00, 1.4911346053E+00, 8.3849987267E-01],
	[2.2650000000E+04, 1.2858684127E+01, 4.9358890824E+00, 2.5643464558E+00, 1.4918045296E+00, 8.3857674382E-01],
	[2.2655000000E+04, 1.2863038858E+01, 4.9358060865E+00, 2.5661756184E+00, 1.4924744462E+00, 8.3865358173E-01],
	[2.2660000000E+04, 1.2867394103E+01, 4.9357231104E+00, 2.5680056812E+00, 1.4931443550E+00, 8.3873038639E-01],
	[2.2665000000E+04, 1.2871749861E+01, 4.9356401540E+00, 2.5698366442E+00, 1.4938142557E+00, 8.3880715781E-01],
	[2.2670000000E+04, 1.2876106133E+01, 4.9355572172E+00, 2.5716685079E+00, 1.4944841483E+00, 8.3888389601E-01],
	[2.2675000000E+04, 1.2880462917E+01, 4.9354743001E+00, 2.5735012724E+00, 1.4951540326E+00, 8.3896060099E-01],
	[2.2680000000E+04, 1.2884820215E+01, 4.9353914028E+00, 2.5753349379E+00, 1.4958239086E+00, 8.3903727275E-01],
	[2.2685000000E+04, 1.2889178026E+01, 4.9353085250E+00, 2.5771695048E+00, 1.4964937759E+00, 8.3911391132E-01],
	[2.2690000000E+04, 1.2893536350E+01, 4.9352256670E+00, 2.5790049733E+00, 1.4971636346E+00, 8.3919051668E-01],
	[2.2695000000E+04, 1.2897895186E+01, 4.9351428285E+00, 2.5808413435E+00, 1.4978334844E+00, 8.3926708886E-01],
	[2.2700000000E+04, 1.2902254536E+01, 4.9350600098E+00, 2.5826786158E+00, 1.4985033253E+00, 8.3934362785E-01],
	[2.2705000000E+04, 1.2906614398E+01, 4.9349772106E+00, 2.5845167904E+00, 1.4991731570E+00, 8.3942013368E-01],
	[2.2710000000E+04, 1.2910974773E+01, 4.9348944311E+00, 2.5863558675E+00, 1.4998429795E+00, 8.3949660634E-01],
	[2.2715000000E+04, 1.2915335661E+01, 4.9348116711E+00, 2.5881958475E+00, 1.5005127927E+00, 8.3957304584E-01],
	[2.2720000000E+04, 1.2919697061E+01, 4.9347289308E+00, 2.5900367304E+00, 1.5011825963E+00, 8.3964945220E-01],
	[2.2725000000E+04, 1.2924058974E+01, 4.9346462101E+00, 2.5918785166E+00, 1.5018523902E+00, 8.3972582541E-01],
	[2.2730000000E+04, 1.2928421400E+01, 4.9345635090E+00, 2.5937212063E+00, 1.5025221744E+00, 8.3980216550E-01],
	[2.2735000000E+04, 1.2932784338E+01, 4.9344808274E+00, 2.5955647998E+00, 1.5031919486E+00, 8.3987847246E-01],
	[2.2740000000E+04, 1.2937147789E+01, 4.9343981654E+00, 2.5974092973E+00, 1.5038617128E+00, 8.3995474630E-01],
	[2.2745000000E+04, 1.2941511752E+01, 4.9343155230E+00, 2.5992546990E+00, 1.5045314667E+00, 8.4003098704E-01],
	[2.2750000000E+04, 1.2945876227E+01, 4.9342329001E+00, 2.6011010052E+00, 1.5052012103E+00, 8.4010719467E-01],
	[2.2755000000E+04, 1.2950241215E+01, 4.9341502967E+00, 2.6029482162E+00, 1.5058709434E+00, 8.4018336921E-01],
	[2.2760000000E+04, 1.2954606715E+01, 4.9340677129E+00, 2.6047963321E+00, 1.5065406659E+00, 8.4025951067E-01],
	[2.2765000000E+04, 1.2958972727E+01, 4.9339851486E+00, 2.6066453532E+00, 1.5072103777E+00, 8.4033561906E-01],
	[2.2770000000E+04, 1.2963339251E+01, 4.9339026038E+00, 2.6084952798E+00, 1.5078800785E+00, 8.4041169438E-01],
	[2.2775000000E+04, 1.2967706287E+01, 4.9338200785E+00, 2.6103461121E+00, 1.5085497683E+00, 8.4048773663E-01],
	[2.2780000000E+04, 1.2972073835E+01, 4.9337375727E+00, 2.6121978504E+00, 1.5092194470E+00, 8.4056374584E-01],
	[2.2785000000E+04, 1.2976441896E+01, 4.9336550864E+00, 2.6140504949E+00, 1.5098891143E+00, 8.4063972201E-01],
	[2.2790000000E+04, 1.2980810468E+01, 4.9335726196E+00, 2.6159040458E+00, 1.5105587702E+00, 8.4071566514E-01],
	[2.2795000000E+04, 1.2985179552E+01, 4.9334901723E+00, 2.6177585034E+00, 1.5112284146E+00, 8.4079157524E-01],
	[2.2800000000E+04, 1.2989561995E+01, 4.9334103048E+00, 2.6196138679E+00, 1.5118984617E+00, 8.4086745233E-01],
	[2.2805000000E+04, 1.2993951980E+01, 4.9333318553E+00, 2.6214701396E+00, 1.5125687242E+00, 8.4094329640E-01],
	[2.2810000000E+04, 1.2998342485E+01, 4.9332534243E+00, 2.6233273187E+00, 1.5132389756E+00, 8.4101910748E-01],
	[2.2815000000E+04, 1.3002733510E+01, 4.9331750117E+00, 2.6251854055E+00, 1.5139092156E+00, 8.4109488556E-01],
	[2.2820000000E+04, 1.3007125057E+01, 4.9330966175E+00, 2.6270444001E+00, 1.5145794442E+00, 8.4117063065E-01],
	[2.2825000000E+04, 1.3011517124E+01, 4.9330182417E+00, 2.6289043030E+00, 1.5152496613E+00, 8.4124634277E-01],
	[2.2830000000E+04, 1.3015909711E+01, 4.9329398844E+00, 2.6307651142E+00, 1.5159198666E+00, 8.4132202192E-01],
	[2.2835000000E+04, 1.3020302819E+01, 4.9328615455E+00, 2.6326268340E+00, 1.5165900602E+00, 8.4139766811E-01],
	[2.2840000000E+04, 1.3024696448E+01, 4.9327832249E+00, 2.6344894628E+00, 1.5172602417E+00, 8.4147328135E-01],
	[2.2845000000E+04, 1.3029090596E+01, 4.9327049228E+00, 2.6363530006E+00, 1.5179304111E+00, 8.4154886165E-01],
	[2.2850000000E+04, 1.3033485266E+01, 4.9326266390E+00, 2.6382174479E+00, 1.5186005683E+00, 8.4162440901E-01],
	[2.2855000000E+04, 1.3037880455E+01, 4.9325483736E+00, 2.6400828047E+00, 1.5192707131E+00, 8.4169992345E-01],
	[2.2860000000E+04, 1.3042276165E+01, 4.9324701265E+00, 2.6419490714E+00, 1.5199408453E+00, 8.4177540496E-01],
	[2.2865000000E+04, 1.3046672395E+01, 4.9323918978E+00, 2.6438162482E+00, 1.5206109649E+00, 8.4185085357E-01],
	[2.2870000000E+04, 1.3051069145E+01, 4.9323136875E+00, 2.6456843354E+00, 1.5212810718E+00, 8.4192626928E-01],
	[2.2875000000E+04, 1.3055466415E+01, 4.9322354955E+00, 2.6475533331E+00, 1.5219511657E+00, 8.4200165209E-01],
	[2.2880000000E+04, 1.3059864205E+01, 4.9321573218E+00, 2.6494232417E+00, 1.5226212465E+00, 8.4207700202E-01],
	[2.2885000000E+04, 1.3064262515E+01, 4.9320791664E+00, 2.6512940614E+00, 1.5232913142E+00, 8.4215231907E-01],
	[2.2890000000E+04, 1.3068661345E+01, 4.9320010294E+00, 2.6531657924E+00, 1.5239613685E+00, 8.4222760325E-01],
	[2.2895000000E+04, 1.3073060695E+01, 4.9319229106E+00, 2.6550384349E+00, 1.5246314093E+00, 8.4230285458E-01],
	[2.2900000000E+04, 1.3077460565E+01, 4.9318448102E+00, 2.6569119893E+00, 1.5253014366E+00, 8.4237807306E-01],
	[2.2905000000E+04, 1.3081860954E+01, 4.9317667280E+00, 2.6587864557E+00, 1.5259714501E+00, 8.4245325869E-01],
	[2.2910000000E+04, 1.3086261864E+01, 4.9316886641E+00, 2.6606618345E+00, 1.5266414497E+00, 8.4252841149E-01],
	[2.2915000000E+04, 1.3090663293E+01, 4.9316106185E+00, 2.6625381257E+00, 1.5273114353E+00, 8.4260353147E-01],
	[2.2920000000E+04, 1.3095065241E+01, 4.9315325912E+00, 2.6644153298E+00, 1.5279814068E+00, 8.4267861863E-01],
	[2.2925000000E+04, 1.3099467709E+01, 4.9314545821E+00, 2.6662934469E+00, 1.5286513641E+00, 8.4275367298E-01],
	[2.2930000000E+04, 1.3103870697E+01, 4.9313765912E+00, 2.6681724773E+00, 1.5293213069E+00, 8.4282869453E-01],
	[2.2935000000E+04, 1.3108274204E+01, 4.9312986186E+00, 2.6700524212E+00, 1.5299912351E+00, 8.4290368329E-01],
	[2.2940000000E+04, 1.3112678230E+01, 4.9312206642E+00, 2.6719332789E+00, 1.5306611487E+00, 8.4297863927E-01],
	[2.2945000000E+04, 1.3117082776E+01, 4.9311427280E+00, 2.6738150505E+00, 1.5313310475E+00, 8.4305356248E-01],
	[2.2950000000E+04, 1.3121487841E+01, 4.9310648101E+00, 2.6756977365E+00, 1.5320009313E+00, 8.4312845292E-01],
	[2.2955000000E+04, 1.3125893426E+01, 4.9309869103E+00, 2.6775813369E+00, 1.5326708001E+00, 8.4320331061E-01],
	[2.2960000000E+04, 1.3130299529E+01, 4.9309090288E+00, 2.6794658521E+00, 1.5333406536E+00, 8.4327813555E-01],
	[2.2965000000E+04, 1.3134706152E+01, 4.9308311654E+00, 2.6813512823E+00, 1.5340104918E+00, 8.4335292775E-01],
	[2.2970000000E+04, 1.3139113294E+01, 4.9307533202E+00, 2.6832376277E+00, 1.5346803145E+00, 8.4342768722E-01],
	[2.2975000000E+04, 1.3143520955E+01, 4.9306754932E+00, 2.6851248886E+00, 1.5353501216E+00, 8.4350241397E-01],
	[2.2980000000E+04, 1.3147929134E+01, 4.9305976844E+00, 2.6870130652E+00, 1.5360199129E+00, 8.4357710800E-01],
	[2.2985000000E+04, 1.3152337833E+01, 4.9305198937E+00, 2.6889021578E+00, 1.5366896884E+00, 8.4365176933E-01],
	[2.2990000000E+04, 1.3156747051E+01, 4.9304421212E+00, 2.6907921665E+00, 1.5373594478E+00, 8.4372639797E-01],
	[2.2995000000E+04, 1.3161156787E+01, 4.9303643667E+00, 2.6926830918E+00, 1.5380291911E+00, 8.4380099392E-01],
	[2.3000000000E+04, 1.3165567043E+01, 4.9302866305E+00, 2.6945749337E+00, 1.5386989181E+00, 8.4387555720E-01],
	[2.3005000000E+04, 1.3169977817E+01, 4.9302089123E+00, 2.6964676926E+00, 1.5393686287E+00, 8.4395008780E-01],
	[2.3010000000E+04, 1.3174389109E+01, 4.9301312123E+00, 2.6983613687E+00, 1.5400383227E+00, 8.4402458575E-01],
	[2.3015000000E+04, 1.3178800921E+01, 4.9300535303E+00, 2.7002559622E+00, 1.5407080000E+00, 8.4409905104E-01],
	[2.3020000000E+04, 1.3183213251E+01, 4.9299758665E+00, 2.7021514734E+00, 1.5413776606E+00, 8.4417348369E-01],
	[2.3025000000E+04, 1.3187626099E+01, 4.9298982208E+00, 2.7040479026E+00, 1.5420473041E+00, 8.4424788371E-01],
	[2.3030000000E+04, 1.3192039466E+01, 4.9298205931E+00, 2.7059452499E+00, 1.5427169306E+00, 8.4432225110E-01],
	[2.3035000000E+04, 1.3196453351E+01, 4.9297429835E+00, 2.7078435156E+00, 1.5433865399E+00, 8.4439658588E-01],
	[2.3040000000E+04, 1.3200867755E+01, 4.9296653920E+00, 2.7097426999E+00, 1.5440561318E+00, 8.4447088805E-01],
	[2.3045000000E+04, 1.3205282677E+01, 4.9295878185E+00, 2.7116428032E+00, 1.5447257062E+00, 8.4454515762E-01],
	[2.3050000000E+04, 1.3209698117E+01, 4.9295102631E+00, 2.7135438256E+00, 1.5453952631E+00, 8.4461939460E-01],
	[2.3055000000E+04, 1.3214114076E+01, 4.9294327257E+00, 2.7154457674E+00, 1.5460648021E+00, 8.4469359900E-01],
	[2.3060000000E+04, 1.3218530552E+01, 4.9293552064E+00, 2.7173486289E+00, 1.5467343233E+00, 8.4476777083E-01],
	[2.3065000000E+04, 1.3222947547E+01, 4.9292777051E+00, 2.7192524102E+00, 1.5474038265E+00, 8.4484191010E-01],
	[2.3070000000E+04, 1.3227365060E+01, 4.9292002218E+00, 2.7211571116E+00, 1.5480733116E+00, 8.4491601681E-01],
	[2.3075000000E+04, 1.3231783091E+01, 4.9291227565E+00, 2.7230627335E+00, 1.5487427783E+00, 8.4499009098E-01],
	[2.3080000000E+04, 1.3236201639E+01, 4.9290453092E+00, 2.7249692759E+00, 1.5494122267E+00, 8.4506413262E-01],
	[2.3085000000E+04, 1.3240620706E+01, 4.9289678799E+00, 2.7268767392E+00, 1.5500816565E+00, 8.4513814172E-01],
	[2.3090000000E+04, 1.3245040291E+01, 4.9288904686E+00, 2.7287851236E+00, 1.5507510676E+00, 8.4521211831E-01],
	[2.3095000000E+04, 1.3249460393E+01, 4.9288130752E+00, 2.7306944294E+00, 1.5514204599E+00, 8.4528606239E-01],
	[2.3100000000E+04, 1.3253881013E+01, 4.9287356999E+00, 2.7326046567E+00, 1.5520898333E+00, 8.4535997397E-01],
	[2.3105000000E+04, 1.3258302151E+01, 4.9286583425E+00, 2.7345158059E+00, 1.5527591876E+00, 8.4543385306E-01],
	[2.3110000000E+04, 1.3262723806E+01, 4.9285810030E+00, 2.7364278772E+00, 1.5534285227E+00, 8.4550769967E-01],
	[2.3115000000E+04, 1.3267145979E+01, 4.9285036815E+00, 2.7383408708E+00, 1.5540978385E+00, 8.4558151380E-01],
	[2.3120000000E+04, 1.3271568670E+01, 4.9284263779E+00, 2.7402547870E+00, 1.5547671348E+00, 8.4565529547E-01],
	[2.3125000000E+04, 1.3275991878E+01, 4.9283490923E+00, 2.7421696260E+00, 1.5554364115E+00, 8.4572904469E-01],
	[2.3130000000E+04, 1.3280415604E+01, 4.9282718245E+00, 2.7440853880E+00, 1.5561056685E+00, 8.4580276146E-01],
	[2.3135000000E+04, 1.3284839847E+01, 4.9281945747E+00, 2.7460020734E+00, 1.5567749056E+00, 8.4587644579E-01],
	[2.3140000000E+04, 1.3289264607E+01, 4.9281173428E+00, 2.7479196823E+00, 1.5574441227E+00, 8.4595009770E-01],
	[2.3145000000E+04, 1.3293689884E+01, 4.9280401288E+00, 2.7498382150E+00, 1.5581133197E+00, 8.4602371719E-01],
	[2.3150000000E+04, 1.3298115679E+01, 4.9279629327E+00, 2.7517576718E+00, 1.5587824964E+00, 8.4609730427E-01],
	[2.3155000000E+04, 1.3302541991E+01, 4.9278857544E+00, 2.7536780528E+00, 1.5594516528E+00, 8.4617085895E-01],
	[2.3160000000E+04, 1.3306968820E+01, 4.9278085941E+00, 2.7555993584E+00, 1.5601207886E+00, 8.4624438124E-01],
	[2.3165000000E+04, 1.3311401140E+01, 4.9277324169E+00, 2.7575215888E+00, 1.5607900690E+00, 8.4631787114E-01],
	[2.3170000000E+04, 1.3315849126E+01, 4.9276591963E+00, 2.7594447442E+00, 1.5614598323E+00, 8.4639132868E-01],
	[2.3175000000E+04, 1.3320297638E+01, 4.9275859926E+00, 2.7613688248E+00, 1.5621295754E+00, 8.4646475385E-01],
	[2.3180000000E+04, 1.3324746677E+01, 4.9275128058E+00, 2.7632938310E+00, 1.5627992984E+00, 8.4653814666E-01],
	[2.3185000000E+04, 1.3329196241E+01, 4.9274396358E+00, 2.7652197629E+00, 1.5634690009E+00, 8.4661150713E-01],
	[2.3190000000E+04, 1.3333646331E+01, 4.9273664827E+00, 2.7671466209E+00, 1.5641386831E+00, 8.4668483527E-01],
	[2.3195000000E+04, 1.3338096947E+01, 4.9272933465E+00, 2.7690744050E+00, 1.5648083446E+00, 8.4675813108E-01],
	[2.3200000000E+04, 1.3342548089E+01, 4.9272202271E+00, 2.7710031157E+00, 1.5654779854E+00, 8.4683139457E-01],
	[2.3205000000E+04, 1.3346999756E+01, 4.9271471246E+00, 2.7729327531E+00, 1.5661476053E+00, 8.4690462575E-01],
	[2.3210000000E+04, 1.3351451949E+01, 4.9270740389E+00, 2.7748633175E+00, 1.5668172042E+00, 8.4697782464E-01],
	[2.3215000000E+04, 1.3355904668E+01, 4.9270009700E+00, 2.7767948091E+00, 1.5674867820E+00, 8.4705099123E-01],
	[2.3220000000E+04, 1.3360357913E+01, 4.9269279179E+00, 2.7787272282E+00, 1.5681563386E+00, 8.4712412555E-01],
	[2.3225000000E+04, 1.3364811683E+01, 4.9268548827E+00, 2.7806605750E+00, 1.5688258738E+00, 8.4719722759E-01],
	[2.3230000000E+04, 1.3369265978E+01, 4.9267818643E+00, 2.7825948498E+00, 1.5694953874E+00, 8.4727029737E-01],
	[2.3235000000E+04, 1.3373720799E+01, 4.9267088626E+00, 2.7845300528E+00, 1.5701648794E+00, 8.4734333490E-01],
	[2.3240000000E+04, 1.3378176145E+01, 4.9266358778E+00, 2.7864661842E+00, 1.5708343497E+00, 8.4741634018E-01],
	[2.3245000000E+04, 1.3382632017E+01, 4.9265629097E+00, 2.7884032443E+00, 1.5715037980E+00, 8.4748931324E-01],
	[2.3250000000E+04, 1.3387088414E+01, 4.9264899584E+00, 2.7903412334E+00, 1.5721732243E+00, 8.4756225406E-01],
	[2.3255000000E+04, 1.3391545336E+01, 4.9264170239E+00, 2.7922801517E+00, 1.5728426284E+00, 8.4763516268E-01],
	[2.3260000000E+04, 1.3396002783E+01, 4.9263441061E+00, 2.7942199994E+00, 1.5735120103E+00, 8.4770803908E-01],
	[2.3265000000E+04, 1.3400460756E+01, 4.9262712051E+00, 2.7961607767E+00, 1.5741813697E+00, 8.4778088329E-01],
	[2.3270000000E+04, 1.3404919253E+01, 4.9261983208E+00, 2.7981024840E+00, 1.5748507066E+00, 8.4785369531E-01],
	[2.3275000000E+04, 1.3409378276E+01, 4.9261254532E+00, 2.8000451215E+00, 1.5755200208E+00, 8.4792647516E-01],
	[2.3280000000E+04, 1.3413837823E+01, 4.9260526024E+00, 2.8019886894E+00, 1.5761893122E+00, 8.4799922284E-01],
	[2.3285000000E+04, 1.3418297896E+01, 4.9259797683E+00, 2.8039331879E+00, 1.5768585806E+00, 8.4807193835E-01],
	[2.3290000000E+04, 1.3422758493E+01, 4.9259069510E+00, 2.8058786174E+00, 1.5775278260E+00, 8.4814462172E-01],
	[2.3295000000E+04, 1.3427219615E+01, 4.9258341503E+00, 2.8078249780E+00, 1.5781970482E+00, 8.4821727295E-01],
	[2.3300000000E+04, 1.3431681262E+01, 4.9257613663E+00, 2.8097722700E+00, 1.5788662471E+00, 8.4828989205E-01],
	[2.3305000000E+04, 1.3436143434E+01, 4.9256885990E+00, 2.8117204936E+00, 1.5795354225E+00, 8.4836247903E-01],
	[2.3310000000E+04, 1.3440606130E+01, 4.9256158485E+00, 2.8136696492E+00, 1.5802045743E+00, 8.4843503389E-01],
	[2.3315000000E+04, 1.3445069351E+01, 4.9255431145E+00, 2.8156197368E+00, 1.5808737025E+00, 8.4850755665E-01],
	[2.3320000000E+04, 1.3449533097E+01, 4.9254703973E+00, 2.8175707569E+00, 1.5815428067E+00, 8.4858004732E-01],
	[2.3325000000E+04, 1.3453997367E+01, 4.9253976967E+00, 2.8195227095E+00, 1.5822118871E+00, 8.4865250591E-01],
	[2.3330000000E+04, 1.3458462161E+01, 4.9253250128E+00, 2.8214755950E+00, 1.5828809433E+00, 8.4872493242E-01],
	[2.3335000000E+04, 1.3462927480E+01, 4.9252523455E+00, 2.8234294137E+00, 1.5835499753E+00, 8.4879732687E-01],
	[2.3340000000E+04, 1.3467393323E+01, 4.9251796949E+00, 2.8253841657E+00, 1.5842189829E+00, 8.4886968926E-01],
	[2.3345000000E+04, 1.3471859691E+01, 4.9251070609E+00, 2.8273398513E+00, 1.5848879661E+00, 8.4894201960E-01],
	[2.3350000000E+04, 1.3476326583E+01, 4.9250344435E+00, 2.8292964707E+00, 1.5855569246E+00, 8.4901431790E-01],
	[2.3355000000E+04, 1.3480793999E+01, 4.9249618427E+00, 2.8312540242E+00, 1.5862258584E+00, 8.4908658416E-01],
	[2.3360000000E+04, 1.3485261939E+01, 4.9248892586E+00, 2.8332125121E+00, 1.5868947674E+00, 8.4915881840E-01],
	[2.3365000000E+04, 1.3489730404E+01, 4.9248166910E+00, 2.8351719346E+00, 1.5875636514E+00, 8.4923102062E-01],
	[2.3370000000E+04, 1.3494199392E+01, 4.9247441401E+00, 2.8371322919E+00, 1.5882325102E+00, 8.4930319084E-01],
	[2.3375000000E+04, 1.3498668905E+01, 4.9246716057E+00, 2.8390935843E+00, 1.5889013438E+00, 8.4937532905E-01],
	[2.3380000000E+04, 1.3503138941E+01, 4.9245990880E+00, 2.8410558119E+00, 1.5895701520E+00, 8.4944743527E-01],
	[2.3385000000E+04, 1.3507609501E+01, 4.9245265867E+00, 2.8430189752E+00, 1.5902389347E+00, 8.4951950950E-01],
	[2.3390000000E+04, 1.3512080586E+01, 4.9244541021E+00, 2.8449830743E+00, 1.5909076918E+00, 8.4959155176E-01],
	[2.3395000000E+04, 1.3516552194E+01, 4.9243816340E+00, 2.8469481094E+00, 1.5915764231E+00, 8.4966356205E-01],
	[2.3400000000E+04, 1.3521024325E+01, 4.9243091825E+00, 2.8489140808E+00, 1.5922451286E+00, 8.4973554039E-01],
	[2.3405000000E+04, 1.3525496981E+01, 4.9242367475E+00, 2.8508809888E+00, 1.5929138080E+00, 8.4980748677E-01],
	[2.3410000000E+04, 1.3529970160E+01, 4.9241643291E+00, 2.8528488336E+00, 1.5935824613E+00, 8.4987940121E-01],
	[2.3415000000E+04, 1.3534443863E+01, 4.9240919272E+00, 2.8548176154E+00, 1.5942510883E+00, 8.4995128371E-01],
	[2.3420000000E+04, 1.3538918089E+01, 4.9240195418E+00, 2.8567873345E+00, 1.5949196889E+00, 8.5002313429E-01],
	[2.3425000000E+04, 1.3543392839E+01, 4.9239471729E+00, 2.8587579911E+00, 1.5955882630E+00, 8.5009495296E-01],
	[2.3430000000E+04, 1.3547868112E+01, 4.9238748206E+00, 2.8607295856E+00, 1.5962568105E+00, 8.5016673971E-01],
	[2.3435000000E+04, 1.3552343909E+01, 4.9238024847E+00, 2.8627021180E+00, 1.5969253312E+00, 8.5023849456E-01],
	[2.3440000000E+04, 1.3556820229E+01, 4.9237301653E+00, 2.8646755887E+00, 1.5975938250E+00, 8.5031021752E-01],
	[2.3445000000E+04, 1.3561297072E+01, 4.9236578624E+00, 2.8666499979E+00, 1.5982622917E+00, 8.5038190860E-01],
	[2.3450000000E+04, 1.3565774439E+01, 4.9235855760E+00, 2.8686253459E+00, 1.5989307313E+00, 8.5045356780E-01],
	[2.3455000000E+04, 1.3570252328E+01, 4.9235133061E+00, 2.8706016328E+00, 1.5995991437E+00, 8.5052519513E-01],
	[2.3460000000E+04, 1.3574730741E+01, 4.9234410526E+00, 2.8725788591E+00, 1.6002675286E+00, 8.5059679060E-01],
	[2.3465000000E+04, 1.3579209677E+01, 4.9233688156E+00, 2.8745570248E+00, 1.6009358860E+00, 8.5066835423E-01],
	[2.3470000000E+04, 1.3583689136E+01, 4.9232965951E+00, 2.8765361302E+00, 1.6016042157E+00, 8.5073988601E-01],
	[2.3475000000E+04, 1.3588169118E+01, 4.9232243910E+00, 2.8785161757E+00, 1.6022725176E+00, 8.5081138596E-01],
	[2.3480000000E+04, 1.3592649624E+01, 4.9231522033E+00, 2.8804971614E+00, 1.6029407916E+00, 8.5088285409E-01],
	[2.3485000000E+04, 1.3597130651E+01, 4.9230800320E+00, 2.8824790875E+00, 1.6036090376E+00, 8.5095429040E-01],
	[2.3490000000E+04, 1.3601612202E+01, 4.9230078772E+00, 2.8844619544E+00, 1.6042772555E+00, 8.5102569490E-01],
	[2.3495000000E+04, 1.3606094276E+01, 4.9229357388E+00, 2.8864457623E+00, 1.6049454450E+00, 8.5109706760E-01],
	[2.3500000000E+04, 1.3610576872E+01, 4.9228636168E+00, 2.8884305113E+00, 1.6056136061E+00, 8.5116840851E-01],
	[2.3505000000E+04, 1.3615059991E+01, 4.9227915112E+00, 2.8904162018E+00, 1.6062817387E+00, 8.5123971764E-01],
	[2.3510000000E+04, 1.3619543633E+01, 4.9227194220E+00, 2.8924028341E+00, 1.6069498426E+00, 8.5131099500E-01],
	[2.3515000000E+04, 1.3624027797E+01, 4.9226473491E+00, 2.8943904083E+00, 1.6076179177E+00, 8.5138224059E-01],
	[2.3520000000E+04, 1.3628512484E+01, 4.9225752927E+00, 2.8963789247E+00, 1.6082859639E+00, 8.5145345443E-01],
	[2.3525000000E+04, 1.3632997693E+01, 4.9225032526E+00, 2.8983683835E+00, 1.6089539811E+00, 8.5152463652E-01],
	[2.3530000000E+04, 1.3637483425E+01, 4.9224312289E+00, 2.9003587850E+00, 1.6096219691E+00, 8.5159578687E-01],
	[2.3535000000E+04, 1.3641969679E+01, 4.9223592215E+00, 2.9023501295E+00, 1.6102899278E+00, 8.5166690549E-01],
	[2.3540000000E+04, 1.3646470030E+01, 4.9222897955E+00, 2.9043424171E+00, 1.6109583210E+00, 8.5173799239E-01],
	[2.3545000000E+04, 1.3650977710E+01, 4.9222216702E+00, 2.9063356482E+00, 1.6116269177E+00, 8.5180904758E-01],
	[2.3550000000E+04, 1.3655485923E+01, 4.9221535603E+00, 2.9083298229E+00, 1.6122954856E+00, 8.5188007106E-01],
	[2.3555000000E+04, 1.3659994666E+01, 4.9220854658E+00, 2.9103249415E+00, 1.6129640246E+00, 8.5195106284E-01],
	[2.3560000000E+04, 1.3664503941E+01, 4.9220173867E+00, 2.9123210044E+00, 1.6136325345E+00, 8.5202202294E-01],
	[2.3565000000E+04, 1.3669013747E+01, 4.9219493229E+00, 2.9143180116E+00, 1.6143010151E+00, 8.5209295137E-01],
	[2.3570000000E+04, 1.3673524084E+01, 4.9218812746E+00, 2.9163159635E+00, 1.6149694665E+00, 8.5216384812E-01],
	[2.3575000000E+04, 1.3678034952E+01, 4.9218132416E+00, 2.9183148603E+00, 1.6156378883E+00, 8.5223471321E-01],
	[2.3580000000E+04, 1.3682546352E+01, 4.9217452240E+00, 2.9203147022E+00, 1.6163062806E+00, 8.5230554665E-01],
	[2.3585000000E+04, 1.3687058282E+01, 4.9216772218E+00, 2.9223154896E+00, 1.6169746432E+00, 8.5237634845E-01],
	[2.3590000000E+04, 1.3691570743E+01, 4.9216092349E+00, 2.9243172225E+00, 1.6176429759E+00, 8.5244711862E-01],
	[2.3595000000E+04, 1.3696083736E+01, 4.9215412634E+00, 2.9263199014E+00, 1.6183112787E+00, 8.5251785716E-01],
	[2.3600000000E+04, 1.3700597258E+01, 4.9214733072E+00, 2.9283235264E+00, 1.6189795514E+00, 8.5258856408E-01],
	[2.3605000000E+04, 1.3705111312E+01, 4.9214053663E+00, 2.9303280977E+00, 1.6196477939E+00, 8.5265923939E-01],
	[2.3610000000E+04, 1.3709625897E+01, 4.9213374408E+00, 2.9323336157E+00, 1.6203160061E+00, 8.5272988311E-01],
	[2.3615000000E+04, 1.3714141012E+01, 4.9212695306E+00, 2.9343400806E+00, 1.6209841878E+00, 8.5280049523E-01],
	[2.3620000000E+04, 1.3718656658E+01, 4.9212016357E+00, 2.9363474926E+00, 1.6216523390E+00, 8.5287107578E-01],
	[2.3625000000E+04, 1.3723172834E+01, 4.9211337561E+00, 2.9383558519E+00, 1.6223204594E+00, 8.5294162475E-01],
	[2.3630000000E+04, 1.3727689541E+01, 4.9210658918E+00, 2.9403651589E+00, 1.6229885490E+00, 8.5301214216E-01],
	[2.3635000000E+04, 1.3732206779E+01, 4.9209980428E+00, 2.9423754137E+00, 1.6236566077E+00, 8.5308262802E-01],
	[2.3640000000E+04, 1.3736724547E+01, 4.9209302091E+00, 2.9443866166E+00, 1.6243246353E+00, 8.5315308233E-01],
	[2.3645000000E+04, 1.3741242845E+01, 4.9208623906E+00, 2.9463987678E+00, 1.6249926317E+00, 8.5322350510E-01],
	[2.3650000000E+04, 1.3745761674E+01, 4.9207945875E+00, 2.9484118677E+00, 1.6256605968E+00, 8.5329389634E-01],
	[2.3655000000E+04, 1.3750281033E+01, 4.9207267996E+00, 2.9504259164E+00, 1.6263285305E+00, 8.5336425607E-01],
	[2.3660000000E+04, 1.3754800922E+01, 4.9206590270E+00, 2.9524409141E+00, 1.6269964326E+00, 8.5343458429E-01],
	[2.3665000000E+04, 1.3759321342E+01, 4.9205912696E+00, 2.9544568612E+00, 1.6276643030E+00, 8.5350488100E-01],
	[2.3670000000E+04, 1.3763842292E+01, 4.9205235275E+00, 2.9564737579E+00, 1.6283321416E+00, 8.5357514623E-01],
	[2.3675000000E+04, 1.3768363771E+01, 4.9204558006E+00, 2.9584916044E+00, 1.6289999483E+00, 8.5364537997E-01],
	[2.3680000000E+04, 1.3772885781E+01, 4.9203880889E+00, 2.9605104010E+00, 1.6296677229E+00, 8.5371558223E-01],
	[2.3685000000E+04, 1.3777408321E+01, 4.9203203925E+00, 2.9625301479E+00, 1.6303354653E+00, 8.5378575304E-01],
	[2.3690000000E+04, 1.3781931391E+01, 4.9202527113E+00, 2.9645508453E+00, 1.6310031755E+00, 8.5385589238E-01],
	[2.3695000000E+04, 1.3786454990E+01, 4.9201850453E+00, 2.9665724935E+00, 1.6316708532E+00, 8.5392600028E-01],
	[2.3700000000E+04, 1.3790979120E+01, 4.9201173945E+00, 2.9685950928E+00, 1.6323384983E+00, 8.5399607675E-01],
	[2.3705000000E+04, 1.3795503779E+01, 4.9200497589E+00, 2.9706186434E+00, 1.6330061108E+00, 8.5406612178E-01],
	[2.3710000000E+04, 1.3800028968E+01, 4.9199821385E+00, 2.9726431456E+00, 1.6336736905E+00, 8.5413613539E-01],
	[2.3715000000E+04, 1.3804554687E+01, 4.9199145333E+00, 2.9746685995E+00, 1.6343412373E+00, 8.5420611760E-01],
	[2.3720000000E+04, 1.3809080935E+01, 4.9198469433E+00, 2.9766950055E+00, 1.6350087511E+00, 8.5427606840E-01],
	[2.3725000000E+04, 1.3813607713E+01, 4.9197793684E+00, 2.9787223638E+00, 1.6356762317E+00, 8.5434598781E-01],
	[2.3730000000E+04, 1.3818135021E+01, 4.9197118088E+00, 2.9807506746E+00, 1.6363436790E+00, 8.5441587583E-01],
	[2.3735000000E+04, 1.3822662858E+01, 4.9196442642E+00, 2.9827799382E+00, 1.6370110929E+00, 8.5448573249E-01],
	[2.3740000000E+04, 1.3827191224E+01, 4.9195767349E+00, 2.9848101547E+00, 1.6376784733E+00, 8.5455555777E-01],
	[2.3745000000E+04, 1.3831720120E+01, 4.9195092207E+00, 2.9868413246E+00, 1.6383458201E+00, 8.5462535171E-01],
	[2.3750000000E+04, 1.3836249545E+01, 4.9194417216E+00, 2.9888734480E+00, 1.6390131331E+00, 8.5469511429E-01],
	[2.3755000000E+04, 1.3840779500E+01, 4.9193742376E+00, 2.9909065251E+00, 1.6396804122E+00, 8.5476484554E-01],
	[2.3760000000E+04, 1.3845309984E+01, 4.9193067688E+00, 2.9929405563E+00, 1.6403476573E+00, 8.5483454546E-01],
	[2.3765000000E+04, 1.3849840997E+01, 4.9192393151E+00, 2.9949755417E+00, 1.6410148683E+00, 8.5490421406E-01],
	[2.3770000000E+04, 1.3854372539E+01, 4.9191718766E+00, 2.9970114816E+00, 1.6416820450E+00, 8.5497385135E-01],
	[2.3775000000E+04, 1.3858904610E+01, 4.9191044531E+00, 2.9990483763E+00, 1.6423491873E+00, 8.5504345734E-01],
	[2.3780000000E+04, 1.3863437210E+01, 4.9190370447E+00, 3.0010862259E+00, 1.6430162951E+00, 8.5511303204E-01],
	[2.3785000000E+04, 1.3867970340E+01, 4.9189696515E+00, 3.0031250308E+00, 1.6436833684E+00, 8.5518257545E-01],
	[2.3790000000E+04, 1.3872503998E+01, 4.9189022733E+00, 3.0051647912E+00, 1.6443504069E+00, 8.5525208760E-01],
	[2.3795000000E+04, 1.3877038185E+01, 4.9188349102E+00, 3.0072055073E+00, 1.6450174105E+00, 8.5532156848E-01],
	[2.3800000000E+04, 1.3881572901E+01, 4.9187675621E+00, 3.0092471794E+00, 1.6456843792E+00, 8.5539101810E-01],
	[2.3805000000E+04, 1.3886108146E+01, 4.9187002292E+00, 3.0112898077E+00, 1.6463513127E+00, 8.5546043648E-01],
	[2.3810000000E+04, 1.3890643920E+01, 4.9186329113E+00, 3.0133333925E+00, 1.6470182111E+00, 8.5552982362E-01],
	[2.3815000000E+04, 1.3895180222E+01, 4.9185656085E+00, 3.0153779340E+00, 1.6476850740E+00, 8.5559917954E-01],
	[2.3820000000E+04, 1.3899717053E+01, 4.9184983207E+00, 3.0174234325E+00, 1.6483519016E+00, 8.5566850424E-01],
	[2.3825000000E+04, 1.3904254413E+01, 4.9184310479E+00, 3.0194698882E+00, 1.6490186935E+00, 8.5573779774E-01],
	[2.3830000000E+04, 1.3908792301E+01, 4.9183637902E+00, 3.0215173013E+00, 1.6496854498E+00, 8.5580706003E-01],
	[2.3835000000E+04, 1.3913330717E+01, 4.9182965475E+00, 3.0235656722E+00, 1.6503521702E+00, 8.5587629113E-01],
	[2.3840000000E+04, 1.3917869662E+01, 4.9182293199E+00, 3.0256150010E+00, 1.6510188547E+00, 8.5594549106E-01],
	[2.3845000000E+04, 1.3922409136E+01, 4.9181621073E+00, 3.0276652880E+00, 1.6516855031E+00, 8.5601465981E-01],
	[2.3850000000E+04, 1.3926949138E+01, 4.9180949096E+00, 3.0297165334E+00, 1.6523521153E+00, 8.5608379741E-01],
	[2.3855000000E+04, 1.3931489668E+01, 4.9180277270E+00, 3.0317687376E+00, 1.6530186913E+00, 8.5615290385E-01],
	[2.3860000000E+04, 1.3936030727E+01, 4.9179605594E+00, 3.0338219006E+00, 1.6536852308E+00, 8.5622197915E-01],
	[2.3865000000E+04, 1.3940572313E+01, 4.9178934067E+00, 3.0358760229E+00, 1.6543517338E+00, 8.5629102331E-01],
	[2.3870000000E+04, 1.3945114428E+01, 4.9178262691E+00, 3.0379311046E+00, 1.6550182001E+00, 8.5636003636E-01],
	[2.3875000000E+04, 1.3949657071E+01, 4.9177591464E+00, 3.0399871459E+00, 1.6556846296E+00, 8.5642901828E-01],
	[2.3880000000E+04, 1.3954200242E+01, 4.9176920387E+00, 3.0420441472E+00, 1.6563510222E+00, 8.5649796911E-01],
	[2.3885000000E+04, 1.3958743941E+01, 4.9176249460E+00, 3.0441021087E+00, 1.6570173778E+00, 8.5656688884E-01],
	[2.3890000000E+04, 1.3963288169E+01, 4.9175578682E+00, 3.0461610306E+00, 1.6576836963E+00, 8.5663577748E-01],
	[2.3895000000E+04, 1.3967832924E+01, 4.9174908054E+00, 3.0482209131E+00, 1.6583499775E+00, 8.5670463505E-01],
	[2.3900000000E+04, 1.3972378206E+01, 4.9174237575E+00, 3.0502817566E+00, 1.6590162213E+00, 8.5677346155E-01],
	[2.3905000000E+04, 1.3976924017E+01, 4.9173567246E+00, 3.0523435612E+00, 1.6596824276E+00, 8.5684225699E-01],
	[2.3910000000E+04, 1.3981470355E+01, 4.9172897065E+00, 3.0544063272E+00, 1.6603485963E+00, 8.5691102138E-01],
	[2.3915000000E+04, 1.3986017222E+01, 4.9172227035E+00, 3.0564700548E+00, 1.6610147273E+00, 8.5697975474E-01],
	[2.3920000000E+04, 1.3990582869E+01, 4.9171590736E+00, 3.0585347444E+00, 1.6616814614E+00, 8.5704845707E-01],
	[2.3925000000E+04, 1.3995151435E+01, 4.9170958961E+00, 3.0606003961E+00, 1.6623482420E+00, 8.5711712838E-01],
	[2.3930000000E+04, 1.3999720538E+01, 4.9170327327E+00, 3.0626670102E+00, 1.6630149853E+00, 8.5718576868E-01],
	[2.3935000000E+04, 1.4004290177E+01, 4.9169695832E+00, 3.0647345869E+00, 1.6636816913E+00, 8.5725437798E-01],
	[2.3940000000E+04, 1.4008860353E+01, 4.9169064478E+00, 3.0668031266E+00, 1.6643483597E+00, 8.5732295628E-01],
	[2.3945000000E+04, 1.4013431066E+01, 4.9168433264E+00, 3.0688726293E+00, 1.6650149906E+00, 8.5739150361E-01],
	[2.3950000000E+04, 1.4018002315E+01, 4.9167802189E+00, 3.0709430954E+00, 1.6656815837E+00, 8.5746001997E-01],
	[2.3955000000E+04, 1.4022574101E+01, 4.9167171254E+00, 3.0730145252E+00, 1.6663481389E+00, 8.5752850536E-01],
	[2.3960000000E+04, 1.4027146423E+01, 4.9166540459E+00, 3.0750869188E+00, 1.6670146562E+00, 8.5759695980E-01],
	[2.3965000000E+04, 1.4031719281E+01, 4.9165909804E+00, 3.0771602765E+00, 1.6676811354E+00, 8.5766538330E-01],
	[2.3970000000E+04, 1.4036292676E+01, 4.9165279289E+00, 3.0792345986E+00, 1.6683475764E+00, 8.5773377587E-01],
	[2.3975000000E+04, 1.4040866607E+01, 4.9164648913E+00, 3.0813098853E+00, 1.6690139790E+00, 8.5780213751E-01],
	[2.3980000000E+04, 1.4045441074E+01, 4.9164018676E+00, 3.0833861369E+00, 1.6696803433E+00, 8.5787046824E-01],
	[2.3985000000E+04, 1.4050016077E+01, 4.9163388579E+00, 3.0854633536E+00, 1.6703466689E+00, 8.5793876806E-01],
	[2.3990000000E+04, 1.4054591617E+01, 4.9162758622E+00, 3.0875415356E+00, 1.6710129559E+00, 8.5800703699E-01],
	[2.3995000000E+04, 1.4059167692E+01, 4.9162128804E+00, 3.0896206832E+00, 1.6716792041E+00, 8.5807527504E-01],
	[2.4000000000E+04, 1.4063744304E+01, 4.9161499125E+00, 3.0917007967E+00, 1.6723454133E+00, 8.5814348221E-01],
	[2.4005000000E+04, 1.4068321451E+01, 4.9160869585E+00, 3.0937818763E+00, 1.6730115835E+00, 8.5821165851E-01],
	[2.4010000000E+04, 1.4072899135E+01, 4.9160240184E+00, 3.0958639222E+00, 1.6736777146E+00, 8.5827980396E-01],
	[2.4015000000E+04, 1.4077477354E+01, 4.9159610923E+00, 3.0979469347E+00, 1.6743438064E+00, 8.5834791856E-01],
	[2.4020000000E+04, 1.4082056109E+01, 4.9158981801E+00, 3.1000309140E+00, 1.6750098589E+00, 8.5841600233E-01],
	[2.4025000000E+04, 1.4086635400E+01, 4.9158352817E+00, 3.1021158604E+00, 1.6756758718E+00, 8.5848405527E-01],
	[2.4030000000E+04, 1.4091215227E+01, 4.9157723973E+00, 3.1042017741E+00, 1.6763418451E+00, 8.5855207739E-01],
	[2.4035000000E+04, 1.4095795589E+01, 4.9157095267E+00, 3.1062886554E+00, 1.6770077787E+00, 8.5862006871E-01],
	[2.4040000000E+04, 1.4100376487E+01, 4.9156466701E+00, 3.1083765046E+00, 1.6776736724E+00, 8.5868802923E-01],
	[2.4045000000E+04, 1.4104957921E+01, 4.9155838273E+00, 3.1104653218E+00, 1.6783395262E+00, 8.5875595896E-01],
	[2.4050000000E+04, 1.4109539890E+01, 4.9155209983E+00, 3.1125551073E+00, 1.6790053398E+00, 8.5882385791E-01],
	[2.4055000000E+04, 1.4114122395E+01, 4.9154581833E+00, 3.1146458613E+00, 1.6796711133E+00, 8.5889172610E-01],
	[2.4060000000E+04, 1.4118705435E+01, 4.9153953821E+00, 3.1167375842E+00, 1.6803368464E+00, 8.5895956352E-01],
	[2.4065000000E+04, 1.4123289010E+01, 4.9153325947E+00, 3.1188302762E+00, 1.6810025391E+00, 8.5902737020E-01],
	[2.4070000000E+04, 1.4127873121E+01, 4.9152698212E+00, 3.1209239374E+00, 1.6816681913E+00, 8.5909514614E-01],
	[2.4075000000E+04, 1.4132457767E+01, 4.9152070615E+00, 3.1230185682E+00, 1.6823338028E+00, 8.5916289135E-01],
	[2.4080000000E+04, 1.4137042948E+01, 4.9151443157E+00, 3.1251141688E+00, 1.6829993735E+00, 8.5923060585E-01],
	[2.4085000000E+04, 1.4141628665E+01, 4.9150815837E+00, 3.1272107394E+00, 1.6836649033E+00, 8.5929828963E-01],
	[2.4090000000E+04, 1.4146214916E+01, 4.9150188655E+00, 3.1293082803E+00, 1.6843303920E+00, 8.5936594271E-01],
	[2.4095000000E+04, 1.4150801703E+01, 4.9149561611E+00, 3.1314067918E+00, 1.6849958397E+00, 8.5943356511E-01],
	[2.4100000000E+04, 1.4155389025E+01, 4.9148934706E+00, 3.1335062741E+00, 1.6856612461E+00, 8.5950115682E-01],
	[2.4105000000E+04, 1.4159976882E+01, 4.9148307938E+00, 3.1356067273E+00, 1.6863266111E+00, 8.5956871786E-01],
	[2.4110000000E+04, 1.4164565273E+01, 4.9147681309E+00, 3.1377081519E+00, 1.6869919347E+00, 8.5963624825E-01],
	[2.4115000000E+04, 1.4169154200E+01, 4.9147054817E+00, 3.1398105480E+00, 1.6876572166E+00, 8.5970374798E-01],
	[2.4120000000E+04, 1.4173743662E+01, 4.9146428463E+00, 3.1419139158E+00, 1.6883224569E+00, 8.5977121708E-01],
	[2.4125000000E+04, 1.4178333658E+01, 4.9145802247E+00, 3.1440182557E+00, 1.6889876553E+00, 8.5983865554E-01],
	[2.4130000000E+04, 1.4182924189E+01, 4.9145176169E+00, 3.1461235679E+00, 1.6896528117E+00, 8.5990606339E-01],
	[2.4135000000E+04, 1.4187515255E+01, 4.9144550229E+00, 3.1482298525E+00, 1.6903179261E+00, 8.5997344062E-01],
	[2.4140000000E+04, 1.4192106855E+01, 4.9143924426E+00, 3.1503371100E+00, 1.6909829984E+00, 8.6004078725E-01],
	[2.4145000000E+04, 1.4196698990E+01, 4.9143298761E+00, 3.1524453404E+00, 1.6916480283E+00, 8.6010810330E-01],
	[2.4150000000E+04, 1.4201291660E+01, 4.9142673233E+00, 3.1545545441E+00, 1.6923130159E+00, 8.6017538876E-01],
	[2.4155000000E+04, 1.4205884864E+01, 4.9142047842E+00, 3.1566647213E+00, 1.6929779609E+00, 8.6024264365E-01],
	[2.4160000000E+04, 1.4210478603E+01, 4.9141422589E+00, 3.1587758723E+00, 1.6936428633E+00, 8.6030986798E-01],
	[2.4165000000E+04, 1.4215072876E+01, 4.9140797474E+00, 3.1608879972E+00, 1.6943077229E+00, 8.6037706176E-01],
	[2.4170000000E+04, 1.4219667683E+01, 4.9140172495E+00, 3.1630010964E+00, 1.6949725397E+00, 8.6044422500E-01],
	[2.4175000000E+04, 1.4224263025E+01, 4.9139547654E+00, 3.1651151701E+00, 1.6956373134E+00, 8.6051135771E-01],
	[2.4180000000E+04, 1.4228858901E+01, 4.9138922950E+00, 3.1672302185E+00, 1.6963020441E+00, 8.6057845990E-01],
	[2.4185000000E+04, 1.4233455311E+01, 4.9138298384E+00, 3.1693462420E+00, 1.6969667316E+00, 8.6064553158E-01],
	[2.4190000000E+04, 1.4238052255E+01, 4.9137673954E+00, 3.1714632406E+00, 1.6976313758E+00, 8.6071257276E-01],
	[2.4195000000E+04, 1.4242649734E+01, 4.9137049661E+00, 3.1735812147E+00, 1.6982959765E+00, 8.6077958344E-01],
	[2.4200000000E+04, 1.4247247746E+01, 4.9136425505E+00, 3.1757001646E+00, 1.6989605337E+00, 8.6084656365E-01],
	[2.4205000000E+04, 1.4251846293E+01, 4.9135801486E+00, 3.1778200905E+00, 1.6996250472E+00, 8.6091351339E-01],
	[2.4210000000E+04, 1.4256445373E+01, 4.9135177604E+00, 3.1799409925E+00, 1.7002895169E+00, 8.6098043266E-01],
	[2.4215000000E+04, 1.4261044988E+01, 4.9134553858E+00, 3.1820628711E+00, 1.7009539427E+00, 8.6104732149E-01],
	[2.4220000000E+04, 1.4265645136E+01, 4.9133930250E+00, 3.1841857263E+00, 1.7016183246E+00, 8.6111417987E-01],
	[2.4225000000E+04, 1.4270245819E+01, 4.9133306778E+00, 3.1863095586E+00, 1.7022826623E+00, 8.6118100783E-01],
	[2.4230000000E+04, 1.4274847035E+01, 4.9132683442E+00, 3.1884343680E+00, 1.7029469557E+00, 8.6124780536E-01],
	[2.4235000000E+04, 1.4279448784E+01, 4.9132060243E+00, 3.1905601549E+00, 1.7036112048E+00, 8.6131457248E-01],
	[2.4240000000E+04, 1.4284051068E+01, 4.9131437180E+00, 3.1926869195E+00, 1.7042754095E+00, 8.6138130921E-01],
	[2.4245000000E+04, 1.4288653885E+01, 4.9130814254E+00, 3.1948146621E+00, 1.7049395696E+00, 8.6144801554E-01],
	[2.4250000000E+04, 1.4293257236E+01, 4.9130191465E+00, 3.1969433829E+00, 1.7056036850E+00, 8.6151469150E-01],
	[2.4255000000E+04, 1.4297861120E+01, 4.9129568811E+00, 3.1990730821E+00, 1.7062677555E+00, 8.6158133708E-01],
	[2.4260000000E+04, 1.4302465538E+01, 4.9128946294E+00, 3.2012037600E+00, 1.7069317812E+00, 8.6164795231E-01],
	[2.4265000000E+04, 1.4307070489E+01, 4.9128323913E+00, 3.2033354169E+00, 1.7075957618E+00, 8.6171453718E-01],
	[2.4270000000E+04, 1.4311675974E+01, 4.9127701668E+00, 3.2054680530E+00, 1.7082596973E+00, 8.6178109172E-01],
	[2.4275000000E+04, 1.4316281991E+01, 4.9127079559E+00, 3.2076016685E+00, 1.7089235875E+00, 8.6184761593E-01],
	[2.4280000000E+04, 1.4320888543E+01, 4.9126457586E+00, 3.2097362637E+00, 1.7095874324E+00, 8.6191410982E-01],
	[2.4285000000E+04, 1.4325495627E+01, 4.9125835749E+00, 3.2118718388E+00, 1.7102512318E+00, 8.6198057340E-01],
	[2.4290000000E+04, 1.4330103245E+01, 4.9125214048E+00, 3.2140083941E+00, 1.7109149855E+00, 8.6204700668E-01],
	[2.4295000000E+04, 1.4334711396E+01, 4.9124592482E+00, 3.2161459299E+00, 1.7115786936E+00, 8.6211340966E-01],
	[2.4300000000E+04, 1.4339320080E+01, 4.9123971053E+00, 3.2182844463E+00, 1.7122423558E+00, 8.6217978237E-01],
	[2.4305000000E+04, 1.4343947751E+01, 4.9123382816E+00, 3.2204239436E+00, 1.7129066372E+00, 8.6224612480E-01],
	[2.4310000000E+04, 1.4348578412E+01, 4.9122799092E+00, 3.2225644222E+00, 1.7135709616E+00, 8.6231243696E-01],
	[2.4315000000E+04, 1.4353209615E+01, 4.9122215494E+00, 3.2247058821E+00, 1.7142352406E+00, 8.6237871887E-01],
	[2.4320000000E+04, 1.4357841359E+01, 4.9121632023E+00, 3.2268483237E+00, 1.7148994742E+00, 8.6244497054E-01],
	[2.4325000000E+04, 1.4362473646E+01, 4.9121048679E+00, 3.2289917473E+00, 1.7155636623E+00, 8.6251119196E-01],
	[2.4330000000E+04, 1.4367106475E+01, 4.9120465462E+00, 3.2311361530E+00, 1.7162278047E+00, 8.6257738316E-01],
	[2.4335000000E+04, 1.4371739846E+01, 4.9119882372E+00, 3.2332815411E+00, 1.7168919013E+00, 8.6264354413E-01],
	[2.4340000000E+04, 1.4376373759E+01, 4.9119299409E+00, 3.2354279118E+00, 1.7175559520E+00, 8.6270967490E-01],
	[2.4345000000E+04, 1.4381008213E+01, 4.9118716572E+00, 3.2375752655E+00, 1.7182199567E+00, 8.6277577546E-01],
	[2.4350000000E+04, 1.4385643209E+01, 4.9118133862E+00, 3.2397236024E+00, 1.7188839153E+00, 8.6284184583E-01],
	[2.4355000000E+04, 1.4390278747E+01, 4.9117551278E+00, 3.2418729226E+00, 1.7195478277E+00, 8.6290788602E-01],
	[2.4360000000E+04, 1.4394914827E+01, 4.9116968821E+00, 3.2440232265E+00, 1.7202116937E+00, 8.6297389603E-01],
	[2.4365000000E+04, 1.4399551449E+01, 4.9116386490E+00, 3.2461745143E+00, 1.7208755133E+00, 8.6303987588E-01],
	[2.4370000000E+04, 1.4404188612E+01, 4.9115804286E+00, 3.2483267862E+00, 1.7215392864E+00, 8.6310582557E-01],
	[2.4375000000E+04, 1.4408826316E+01, 4.9115222208E+00, 3.2504800425E+00, 1.7222030128E+00, 8.6317174512E-01],
	[2.4380000000E+04, 1.4413464562E+01, 4.9114640256E+00, 3.2526342835E+00, 1.7228666923E+00, 8.6323763452E-01],
	[2.4385000000E+04, 1.4418103350E+01, 4.9114058430E+00, 3.2547895093E+00, 1.7235303250E+00, 8.6330349380E-01],
	[2.4390000000E+04, 1.4422742679E+01, 4.9113476731E+00, 3.2569457203E+00, 1.7241939107E+00, 8.6336932296E-01],
	[2.4395000000E+04, 1.4427382549E+01, 4.9112895158E+00, 3.2591029167E+00, 1.7248574493E+00, 8.6343512201E-01],
	[2.4400000000E+04, 1.4432022961E+01, 4.9112313711E+00, 3.2612610987E+00, 1.7255209407E+00, 8.6350089095E-01],
	[2.4405000000E+04, 1.4436663914E+01, 4.9111732389E+00, 3.2634202666E+00, 1.7261843847E+00, 8.6356662981E-01],
	[2.4410000000E+04, 1.4441305408E+01, 4.9111151194E+00, 3.2655804206E+00, 1.7268477813E+00, 8.6363233858E-01],
	[2.4415000000E+04, 1.4445947444E+01, 4.9110570125E+00, 3.2677415610E+00, 1.7275111303E+00, 8.6369801728E-01],
	[2.4420000000E+04, 1.4450590020E+01, 4.9109989182E+00, 3.2699036880E+00, 1.7281744317E+00, 8.6376366591E-01],
	[2.4425000000E+04, 1.4455233138E+01, 4.9109408364E+00, 3.2720668019E+00, 1.7288376852E+00, 8.6382928449E-01],
	[2.4430000000E+04, 1.4459876796E+01, 4.9108827672E+00, 3.2742309029E+00, 1.7295008909E+00, 8.6389487302E-01],
	[2.4435000000E+04, 1.4464520996E+01, 4.9108247106E+00, 3.2763959913E+00, 1.7301640486E+00, 8.6396043152E-01],
	[2.4440000000E+04, 1.4469165736E+01, 4.9107666666E+00, 3.2785620673E+00, 1.7308271582E+00, 8.6402595999E-01],
	[2.4445000000E+04, 1.4473811018E+01, 4.9107086351E+00, 3.2807291312E+00, 1.7314902195E+00, 8.6409145844E-01],
	[2.4450000000E+04, 1.4478456840E+01, 4.9106506161E+00, 3.2828971831E+00, 1.7321532325E+00, 8.6415692688E-01],
	[2.4455000000E+04, 1.4483103203E+01, 4.9105926098E+00, 3.2850662235E+00, 1.7328161971E+00, 8.6422236532E-01],
	[2.4460000000E+04, 1.4487750107E+01, 4.9105346159E+00, 3.2872362524E+00, 1.7334791131E+00, 8.6428777377E-01],
	[2.4465000000E+04, 1.4492397552E+01, 4.9104766346E+00, 3.2894072702E+00, 1.7341419805E+00, 8.6435315224E-01],
	[2.4470000000E+04, 1.4497045537E+01, 4.9104186658E+00, 3.2915792771E+00, 1.7348047991E+00, 8.6441850074E-01],
	[2.4475000000E+04, 1.4501694063E+01, 4.9103607096E+00, 3.2937522733E+00, 1.7354675688E+00, 8.6448381928E-01],
	[2.4480000000E+04, 1.4506343129E+01, 4.9103027659E+00, 3.2959262591E+00, 1.7361302895E+00, 8.6454910787E-01],
	[2.4485000000E+04, 1.4510992736E+01, 4.9102448347E+00, 3.2981012348E+00, 1.7367929612E+00, 8.6461436651E-01],
	[2.4490000000E+04, 1.4515642883E+01, 4.9101869160E+00, 3.3002772006E+00, 1.7374555836E+00, 8.6467959521E-01],
	[2.4495000000E+04, 1.4520293571E+01, 4.9101290098E+00, 3.3024541567E+00, 1.7381181567E+00, 8.6474479400E-01],
	[2.4500000000E+04, 1.4524944799E+01, 4.9100711161E+00, 3.3046321034E+00, 1.7387806804E+00, 8.6480996286E-01],
	[2.4505000000E+04, 1.4529596567E+01, 4.9100132349E+00, 3.3068110410E+00, 1.7394431545E+00, 8.6487510182E-01],
	[2.4510000000E+04, 1.4534248876E+01, 4.9099553662E+00, 3.3089909696E+00, 1.7401055790E+00, 8.6494021089E-01],
	[2.4515000000E+04, 1.4538901725E+01, 4.9098975100E+00, 3.3111718896E+00, 1.7407679537E+00, 8.6500529006E-01],
	[2.4520000000E+04, 1.4543555114E+01, 4.9098396663E+00, 3.3133538012E+00, 1.7414302786E+00, 8.6507033936E-01],
	[2.4525000000E+04, 1.4548209043E+01, 4.9097818351E+00, 3.3155367045E+00, 1.7420925535E+00, 8.6513535879E-01],
	[2.4530000000E+04, 1.4552863512E+01, 4.9097240163E+00, 3.3177206000E+00, 1.7427547783E+00, 8.6520034837E-01],
	[2.4535000000E+04, 1.4557518522E+01, 4.9096662099E+00, 3.3199054878E+00, 1.7434169529E+00, 8.6526530809E-01],
	[2.4540000000E+04, 1.4562174071E+01, 4.9096084161E+00, 3.3220913682E+00, 1.7440790772E+00, 8.6533023797E-01],
	[2.4545000000E+04, 1.4566830160E+01, 4.9095506347E+00, 3.3242782414E+00, 1.7447411511E+00, 8.6539513802E-01],
	[2.4550000000E+04, 1.4571486789E+01, 4.9094928657E+00, 3.3264661076E+00, 1.7454031745E+00, 8.6546000826E-01],
	[2.4555000000E+04, 1.4576143958E+01, 4.9094351092E+00, 3.3286549672E+00, 1.7460651473E+00, 8.6552484868E-01],
	[2.4560000000E+04, 1.4580801667E+01, 4.9093773651E+00, 3.3308448203E+00, 1.7467270693E+00, 8.6558965929E-01],
	[2.4565000000E+04, 1.4585459916E+01, 4.9093196335E+00, 3.3330356673E+00, 1.7473889405E+00, 8.6565444012E-01],
	[2.4570000000E+04, 1.4590118704E+01, 4.9092619143E+00, 3.3352275083E+00, 1.7480507608E+00, 8.6571919116E-01],
	[2.4575000000E+04, 1.4594778032E+01, 4.9092042075E+00, 3.3374203437E+00, 1.7487125300E+00, 8.6578391243E-01],
	[2.4580000000E+04, 1.4599437899E+01, 4.9091465131E+00, 3.3396141736E+00, 1.7493742480E+00, 8.6584860394E-01],
	[2.4585000000E+04, 1.4604098307E+01, 4.9090888312E+00, 3.3418089983E+00, 1.7500359147E+00, 8.6591326569E-01],
	[2.4590000000E+04, 1.4608759253E+01, 4.9090311616E+00, 3.3440048180E+00, 1.7506975301E+00, 8.6597789770E-01],
	[2.4595000000E+04, 1.4613420739E+01, 4.9089735045E+00, 3.3462016331E+00, 1.7513590940E+00, 8.6604249997E-01],
	[2.4600000000E+04, 1.4618082765E+01, 4.9089158597E+00, 3.3483994437E+00, 1.7520206063E+00, 8.6610707251E-01],
	[2.4605000000E+04, 1.4622745330E+01, 4.9088582274E+00, 3.3505982502E+00, 1.7526820668E+00, 8.6617161534E-01],
	[2.4610000000E+04, 1.4627408434E+01, 4.9088006074E+00, 3.3527980526E+00, 1.7533434756E+00, 8.6623612847E-01],
	[2.4615000000E+04, 1.4632072077E+01, 4.9087429998E+00, 3.3549988514E+00, 1.7540048324E+00, 8.6630061189E-01],
	[2.4620000000E+04, 1.4636736260E+01, 4.9086854046E+00, 3.3572006467E+00, 1.7546661373E+00, 8.6636506563E-01],
	[2.4625000000E+04, 1.4641400982E+01, 4.9086278217E+00, 3.3594034388E+00, 1.7553273899E+00, 8.6642948970E-01],
	[2.4630000000E+04, 1.4646066243E+01, 4.9085702513E+00, 3.3616072280E+00, 1.7559885904E+00, 8.6649388409E-01],
	[2.4635000000E+04, 1.4650732043E+01, 4.9085126931E+00, 3.3638120144E+00, 1.7566497385E+00, 8.6655824883E-01],
	[2.4640000000E+04, 1.4655398382E+01, 4.9084551474E+00, 3.3660177984E+00, 1.7573108341E+00, 8.6662258391E-01],
	[2.4645000000E+04, 1.4660065260E+01, 4.9083976140E+00, 3.3682245802E+00, 1.7579718772E+00, 8.6668688936E-01],
	[2.4650000000E+04, 1.4664732677E+01, 4.9083400929E+00, 3.3704323600E+00, 1.7586328676E+00, 8.6675116518E-01],
	[2.4655000000E+04, 1.4669400633E+01, 4.9082825842E+00, 3.3726411381E+00, 1.7592938052E+00, 8.6681541138E-01],
	[2.4660000000E+04, 1.4674069128E+01, 4.9082250878E+00, 3.3748509147E+00, 1.7599546899E+00, 8.6687962797E-01],
	[2.4665000000E+04, 1.4678738162E+01, 4.9081676037E+00, 3.3770616901E+00, 1.7606155217E+00, 8.6694381496E-01],
	[2.4670000000E+04, 1.4683407734E+01, 4.9081101320E+00, 3.3792734646E+00, 1.7612763003E+00, 8.6700797236E-01],
	[2.4675000000E+04, 1.4688077845E+01, 4.9080526726E+00, 3.3814862383E+00, 1.7619370258E+00, 8.6707210018E-01],
	[2.4680000000E+04, 1.4692748495E+01, 4.9079952255E+00, 3.3837000115E+00, 1.7625976979E+00, 8.6713619842E-01],
	[2.4685000000E+04, 1.4697419683E+01, 4.9079377907E+00, 3.3859147845E+00, 1.7632583167E+00, 8.6720026711E-01],
	[2.4690000000E+04, 1.4702091410E+01, 4.9078803682E+00, 3.3881305576E+00, 1.7639188819E+00, 8.6726430625E-01],
	[2.4695000000E+04, 1.4706777260E+01, 4.9078253273E+00, 3.3903473309E+00, 1.7645798953E+00, 8.6732831584E-01],
	[2.4700000000E+04, 1.4711471243E+01, 4.9077716215E+00, 3.3925651047E+00, 1.7652411360E+00, 8.6739229590E-01],
	[2.4705000000E+04, 1.4716165774E+01, 4.9077179270E+00, 3.3947838793E+00, 1.7659023236E+00, 8.6745624644E-01],
	[2.4710000000E+04, 1.4720860852E+01, 4.9076642440E+00, 3.3970036549E+00, 1.7665634582E+00, 8.6752016746E-01],
	[2.4715000000E+04, 1.4725556478E+01, 4.9076105725E+00, 3.3992244318E+00, 1.7672245395E+00, 8.6758405899E-01],
	[2.4720000000E+04, 1.4730252651E+01, 4.9075569124E+00, 3.4014462102E+00, 1.7678855675E+00, 8.6764792102E-01],
	[2.4725000000E+04, 1.4734949371E+01, 4.9075032637E+00, 3.4036689904E+00, 1.7685465421E+00, 8.6771175356E-01],
	[2.4730000000E+04, 1.4739646639E+01, 4.9074496265E+00, 3.4058927725E+00, 1.7692074631E+00, 8.6777555664E-01],
	[2.4735000000E+04, 1.4744344455E+01, 4.9073960007E+00, 3.4081175570E+00, 1.7698683305E+00, 8.6783933025E-01],
	[2.4740000000E+04, 1.4749042818E+01, 4.9073423864E+00, 3.4103433439E+00, 1.7705291442E+00, 8.6790307441E-01],
	[2.4745000000E+04, 1.4753741727E+01, 4.9072887834E+00, 3.4125701336E+00, 1.7711899040E+00, 8.6796678912E-01],
	[2.4750000000E+04, 1.4758441185E+01, 4.9072351919E+00, 3.4147979263E+00, 1.7718506098E+00, 8.6803047440E-01],
	[2.4755000000E+04, 1.4763141189E+01, 4.9071816118E+00, 3.4170267223E+00, 1.7725112615E+00, 8.6809413025E-01],
	[2.4760000000E+04, 1.4767841740E+01, 4.9071280431E+00, 3.4192565217E+00, 1.7731718591E+00, 8.6815775669E-01],
	[2.4765000000E+04, 1.4772542839E+01, 4.9070744858E+00, 3.4214873249E+00, 1.7738324025E+00, 8.6822135373E-01],
	[2.4770000000E+04, 1.4777244484E+01, 4.9070209398E+00, 3.4237191321E+00, 1.7744928914E+00, 8.6828492137E-01],
	[2.4775000000E+04, 1.4781946677E+01, 4.9069674053E+00, 3.4259519436E+00, 1.7751533259E+00, 8.6834845963E-01],
	[2.4780000000E+04, 1.4786649416E+01, 4.9069138822E+00, 3.4281857595E+00, 1.7758137057E+00, 8.6841196851E-01],
	[2.4785000000E+04, 1.4791352702E+01, 4.9068603704E+00, 3.4304205802E+00, 1.7764740309E+00, 8.6847544803E-01],
	[2.4790000000E+04, 1.4796056536E+01, 4.9068068701E+00, 3.4326564059E+00, 1.7771343013E+00, 8.6853889819E-01],
	[2.4795000000E+04, 1.4800760915E+01, 4.9067533810E+00, 3.4348932369E+00, 1.7777945168E+00, 8.6860231901E-01],
	[2.4800000000E+04, 1.4805465842E+01, 4.9066999034E+00, 3.4371310733E+00, 1.7784546773E+00, 8.6866571049E-01],
	[2.4805000000E+04, 1.4810171315E+01, 4.9066464371E+00, 3.4393699155E+00, 1.7791147826E+00, 8.6872907265E-01],
	[2.4810000000E+04, 1.4814877335E+01, 4.9065929822E+00, 3.4416097636E+00, 1.7797748328E+00, 8.6879240549E-01],
	[2.4815000000E+04, 1.4819583902E+01, 4.9065395387E+00, 3.4438506180E+00, 1.7804348276E+00, 8.6885570903E-01],
	[2.4820000000E+04, 1.4824291015E+01, 4.9064861065E+00, 3.4460924789E+00, 1.7810947670E+00, 8.6891898327E-01],
	[2.4825000000E+04, 1.4828998675E+01, 4.9064326856E+00, 3.4483353465E+00, 1.7817546509E+00, 8.6898222823E-01],
	[2.4830000000E+04, 1.4833706881E+01, 4.9063792761E+00, 3.4505792211E+00, 1.7824144792E+00, 8.6904544391E-01],
	[2.4835000000E+04, 1.4838415633E+01, 4.9063258779E+00, 3.4528241029E+00, 1.7830742517E+00, 8.6910863033E-01],
	[2.4840000000E+04, 1.4843124932E+01, 4.9062724910E+00, 3.4550699923E+00, 1.7837339684E+00, 8.6917178749E-01],
	[2.4845000000E+04, 1.4847834777E+01, 4.9062191155E+00, 3.4573168893E+00, 1.7843936291E+00, 8.6923491541E-01],
	[2.4850000000E+04, 1.4852545169E+01, 4.9061657513E+00, 3.4595647943E+00, 1.7850532338E+00, 8.6929801409E-01],
	[2.4855000000E+04, 1.4857256106E+01, 4.9061123984E+00, 3.4618137076E+00, 1.7857127824E+00, 8.6936108354E-01],
	[2.4860000000E+04, 1.4861967590E+01, 4.9060590568E+00, 3.4640636293E+00, 1.7863722747E+00, 8.6942412378E-01],
	[2.4865000000E+04, 1.4866679620E+01, 4.9060057265E+00, 3.4663145598E+00, 1.7870317106E+00, 8.6948713482E-01],
	[2.4870000000E+04, 1.4871392196E+01, 4.9059524075E+00, 3.4685664992E+00, 1.7876910901E+00, 8.6955011666E-01],
	[2.4875000000E+04, 1.4876105318E+01, 4.9058990998E+00, 3.4708194478E+00, 1.7883504130E+00, 8.6961306931E-01],
	[2.4880000000E+04, 1.4880818986E+01, 4.9058458035E+00, 3.4730734060E+00, 1.7890096793E+00, 8.6967599279E-01],
	[2.4885000000E+04, 1.4885533200E+01, 4.9057925184E+00, 3.4753283738E+00, 1.7896688888E+00, 8.6973888710E-01],
	[2.4890000000E+04, 1.4890247960E+01, 4.9057392445E+00, 3.4775843516E+00, 1.7903280414E+00, 8.6980175226E-01],
	[2.4895000000E+04, 1.4894963266E+01, 4.9056859820E+00, 3.4798413396E+00, 1.7909871370E+00, 8.6986458828E-01],
	[2.4900000000E+04, 1.4899679118E+01, 4.9056327307E+00, 3.4820993381E+00, 1.7916461756E+00, 8.6992739516E-01],
	[2.4905000000E+04, 1.4904395515E+01, 4.9055794908E+00, 3.4843583474E+00, 1.7923051570E+00, 8.6999017291E-01],
	[2.4910000000E+04, 1.4909112458E+01, 4.9055262620E+00, 3.4866183675E+00, 1.7929640811E+00, 8.7005292155E-01],
	[2.4915000000E+04, 1.4913829947E+01, 4.9054730446E+00, 3.4888793989E+00, 1.7936229479E+00, 8.7011564109E-01],
	[2.4920000000E+04, 1.4918547981E+01, 4.9054198384E+00, 3.4911414418E+00, 1.7942817571E+00, 8.7017833153E-01],
	[2.4925000000E+04, 1.4923266561E+01, 4.9053666434E+00, 3.4934044964E+00, 1.7949405088E+00, 8.7024099289E-01],
	[2.4930000000E+04, 1.4927985687E+01, 4.9053134597E+00, 3.4956685629E+00, 1.7955992027E+00, 8.7030362517E-01],
	[2.4935000000E+04, 1.4932705357E+01, 4.9052602872E+00, 3.4979336416E+00, 1.7962578389E+00, 8.7036622839E-01],
	[2.4940000000E+04, 1.4937425574E+01, 4.9052071260E+00, 3.5001997328E+00, 1.7969164172E+00, 8.7042880256E-01],
	[2.4945000000E+04, 1.4942146336E+01, 4.9051539760E+00, 3.5024668368E+00, 1.7975749375E+00, 8.7049134768E-01],
	[2.4950000000E+04, 1.4946867643E+01, 4.9051008372E+00, 3.5047349536E+00, 1.7982333997E+00, 8.7055386377E-01],
	[2.4955000000E+04, 1.4951589495E+01, 4.9050477097E+00, 3.5070040837E+00, 1.7988918037E+00, 8.7061635083E-01],
	[2.4960000000E+04, 1.4956311893E+01, 4.9049945933E+00, 3.5092742272E+00, 1.7995501494E+00, 8.7067880888E-01],
	[2.4965000000E+04, 1.4961034836E+01, 4.9049414882E+00, 3.5115453845E+00, 1.8002084367E+00, 8.7074123793E-01],
	[2.4970000000E+04, 1.4965758324E+01, 4.9048883943E+00, 3.5138175557E+00, 1.8008666655E+00, 8.7080363799E-01],
	[2.4975000000E+04, 1.4970482357E+01, 4.9048353116E+00, 3.5160907410E+00, 1.8015248357E+00, 8.7086600906E-01],
	[2.4980000000E+04, 1.4975206935E+01, 4.9047822401E+00, 3.5183649409E+00, 1.8021829472E+00, 8.7092835116E-01],
	[2.4985000000E+04, 1.4979932058E+01, 4.9047291798E+00, 3.5206401554E+00, 1.8028409998E+00, 8.7099066430E-01],
	[2.4990000000E+04, 1.4984657726E+01, 4.9046761307E+00, 3.5229163849E+00, 1.8034989936E+00, 8.7105294849E-01],
	[2.4995000000E+04, 1.4989383939E+01, 4.9046230928E+00, 3.5251936296E+00, 1.8041569284E+00, 8.7111520374E-01],
	[2.5000000000E+04, 1.4994110697E+01, 4.9045700661E+00, 3.5274718897E+00, 1.8048148040E+00, 8.7117743005E-01],
	[2.5005000000E+04, 1.4998838000E+01, 4.9045170505E+00, 3.5297563413E+00, 1.8054739746E+00, 8.7123962744E-01],
	[2.5010000000E+04, 1.5003565848E+01, 4.9044640461E+00, 3.5320418145E+00, 1.8061330858E+00, 8.7130179593E-01],
	[2.5015000000E+04, 1.5008294240E+01, 4.9044110529E+00, 3.5343283096E+00, 1.8067921376E+00, 8.7136393551E-01],
	[2.5020000000E+04, 1.5013023177E+01, 4.9043580708E+00, 3.5366158269E+00, 1.8074511298E+00, 8.7142604620E-01],
	[2.5025000000E+04, 1.5017752659E+01, 4.9043050999E+00, 3.5389043666E+00, 1.8081100624E+00, 8.7148812801E-01],
	[2.5030000000E+04, 1.5022482685E+01, 4.9042521402E+00, 3.5411939289E+00, 1.8087689353E+00, 8.7155018095E-01],
	[2.5035000000E+04, 1.5027213256E+01, 4.9041991916E+00, 3.5434845142E+00, 1.8094277482E+00, 8.7161220503E-01],
	[2.5040000000E+04, 1.5031944371E+01, 4.9041462541E+00, 3.5457761227E+00, 1.8100865013E+00, 8.7167420026E-01],
	[2.5045000000E+04, 1.5036676031E+01, 4.9040933278E+00, 3.5480687546E+00, 1.8107451942E+00, 8.7173616665E-01],
	[2.5050000000E+04, 1.5041408235E+01, 4.9040404126E+00, 3.5503624102E+00, 1.8114038271E+00, 8.7179810421E-01],
	[2.5055000000E+04, 1.5046140984E+01, 4.9039875086E+00, 3.5526570897E+00, 1.8120623996E+00, 8.7186001296E-01],
	[2.5060000000E+04, 1.5050874277E+01, 4.9039346157E+00, 3.5549527934E+00, 1.8127209119E+00, 8.7192189290E-01],
	[2.5065000000E+04, 1.5055608114E+01, 4.9038817339E+00, 3.5572495215E+00, 1.8133793636E+00, 8.7198374404E-01],
	[2.5070000000E+04, 1.5060342495E+01, 4.9038288632E+00, 3.5595472743E+00, 1.8140377548E+00, 8.7204556639E-01],
	[2.5075000000E+04, 1.5065077421E+01, 4.9037760036E+00, 3.5618460521E+00, 1.8146960854E+00, 8.7210735996E-01],
	[2.5080000000E+04, 1.5069812891E+01, 4.9037231552E+00, 3.5641458551E+00, 1.8153543552E+00, 8.7216912477E-01],
	[2.5085000000E+04, 1.5074548905E+01, 4.9036703178E+00, 3.5664466835E+00, 1.8160125641E+00, 8.7223086082E-01],
	[2.5090000000E+04, 1.5079288466E+01, 4.9036180037E+00, 3.5687485376E+00, 1.8166708260E+00, 8.7229256813E-01],
	[2.5095000000E+04, 1.5084046910E+01, 4.9035688255E+00, 3.5710514176E+00, 1.8173297223E+00, 8.7235424669E-01],
	[2.5100000000E+04, 1.5088805906E+01, 4.9035196576E+00, 3.5733553239E+00, 1.8179885582E+00, 8.7241589654E-01],
	[2.5105000000E+04, 1.5093565456E+01, 4.9034705000E+00, 3.5756602566E+00, 1.8186473338E+00, 8.7247751767E-01],
	[2.5110000000E+04, 1.5098325558E+01, 4.9034213527E+00, 3.5779662160E+00, 1.8193060488E+00, 8.7253911009E-01],
	[2.5115000000E+04, 1.5103086214E+01, 4.9033722157E+00, 3.5802732024E+00, 1.8199647032E+00, 8.7260067382E-01],
	[2.5120000000E+04, 1.5107847422E+01, 4.9033230890E+00, 3.5825812160E+00, 1.8206232969E+00, 8.7266220887E-01],
	[2.5125000000E+04, 1.5112609184E+01, 4.9032739725E+00, 3.5848902570E+00, 1.8212818297E+00, 8.7272371524E-01],
	[2.5130000000E+04, 1.5117371498E+01, 4.9032248663E+00, 3.5872003258E+00, 1.8219403016E+00, 8.7278519295E-01],
	[2.5135000000E+04, 1.5122134365E+01, 4.9031757703E+00, 3.5895114225E+00, 1.8225987124E+00, 8.7284664201E-01],
	[2.5140000000E+04, 1.5126897785E+01, 4.9031266846E+00, 3.5918235475E+00, 1.8232570622E+00, 8.7290806242E-01],
	[2.5145000000E+04, 1.5131661758E+01, 4.9030776092E+00, 3.5941367009E+00, 1.8239153507E+00, 8.7296945420E-01],
	[2.5150000000E+04, 1.5136426283E+01, 4.9030285440E+00, 3.5964508831E+00, 1.8245735779E+00, 8.7303081737E-01],
	[2.5155000000E+04, 1.5141191361E+01, 4.9029794890E+00, 3.5987660942E+00, 1.8252317436E+00, 8.7309215192E-01],
	[2.5160000000E+04, 1.5145956992E+01, 4.9029304443E+00, 3.6010823346E+00, 1.8258898479E+00, 8.7315345787E-01],
	[2.5165000000E+04, 1.5150723175E+01, 4.9028814098E+00, 3.6033996044E+00, 1.8265478905E+00, 8.7321473523E-01],
	[2.5170000000E+04, 1.5155489911E+01, 4.9028323856E+00, 3.6057179040E+00, 1.8272058714E+00, 8.7327598401E-01],
	[2.5175000000E+04, 1.5160257199E+01, 4.9027833716E+00, 3.6080372336E+00, 1.8278637904E+00, 8.7333720422E-01],
	[2.5180000000E+04, 1.5165025039E+01, 4.9027343678E+00, 3.6103575934E+00, 1.8285216476E+00, 8.7339839587E-01],
	[2.5185000000E+04, 1.5169793432E+01, 4.9026853742E+00, 3.6126789838E+00, 1.8291794427E+00, 8.7345955898E-01],
	[2.5190000000E+04, 1.5174562377E+01, 4.9026363908E+00, 3.6150014048E+00, 1.8298371757E+00, 8.7352069355E-01],
	[2.5195000000E+04, 1.5179331875E+01, 4.9025874177E+00, 3.6173248569E+00, 1.8304948465E+00, 8.7358179959E-01],
	[2.5200000000E+04, 1.5184101924E+01, 4.9025384547E+00, 3.6196493402E+00, 1.8311524550E+00, 8.7364287713E-01],
	[2.5205000000E+04, 1.5188872526E+01, 4.9024895020E+00, 3.6219748550E+00, 1.8318100010E+00, 8.7370392622E-01],
	[2.5210000000E+04, 1.5193643680E+01, 4.9024405595E+00, 3.6243014016E+00, 1.8324674846E+00, 8.7376494685E-01],
	[2.5215000000E+04, 1.5198415386E+01, 4.9023916271E+00, 3.6266289802E+00, 1.8331249055E+00, 8.7382593904E-01],
	[2.5220000000E+04, 1.5203187644E+01, 4.9023427050E+00, 3.6289575910E+00, 1.8337822638E+00, 8.7388690280E-01],
	[2.5225000000E+04, 1.5207960454E+01, 4.9022937930E+00, 3.6312872344E+00, 1.8344395592E+00, 8.7394783813E-01],
	[2.5230000000E+04, 1.5212733817E+01, 4.9022448912E+00, 3.6336179105E+00, 1.8350967917E+00, 8.7400874504E-01],
	[2.5235000000E+04, 1.5217507730E+01, 4.9021959996E+00, 3.6359496197E+00, 1.8357539613E+00, 8.7406962355E-01],
	[2.5240000000E+04, 1.5222282196E+01, 4.9021471182E+00, 3.6382823621E+00, 1.8364110677E+00, 8.7413047366E-01],
	[2.5245000000E+04, 1.5227057214E+01, 4.9020982469E+00, 3.6406161380E+00, 1.8370681109E+00, 8.7419129538E-01],
	[2.5250000000E+04, 1.5231832783E+01, 4.9020493858E+00, 3.6429509478E+00, 1.8377250908E+00, 8.7425208871E-01],
	[2.5255000000E+04, 1.5236608905E+01, 4.9020005349E+00, 3.6452867915E+00, 1.8383820074E+00, 8.7431285368E-01],
	[2.5260000000E+04, 1.5241385577E+01, 4.9019516941E+00, 3.6476236696E+00, 1.8390388605E+00, 8.7437359028E-01],
	[2.5265000000E+04, 1.5246162802E+01, 4.9019028635E+00, 3.6499615821E+00, 1.8396956499E+00, 8.7443429853E-01],
	[2.5270000000E+04, 1.5250940578E+01, 4.9018540430E+00, 3.6523005295E+00, 1.8403523757E+00, 8.7449497843E-01],
	[2.5275000000E+04, 1.5255718905E+01, 4.9018052326E+00, 3.6546405119E+00, 1.8410090377E+00, 8.7455562999E-01],
	[2.5280000000E+04, 1.5260497784E+01, 4.9017564325E+00, 3.6569815296E+00, 1.8416656359E+00, 8.7461625323E-01],
	[2.5285000000E+04, 1.5265277215E+01, 4.9017076424E+00, 3.6593235828E+00, 1.8423221700E+00, 8.7467684815E-01],
	[2.5290000000E+04, 1.5270057197E+01, 4.9016588625E+00, 3.6616666719E+00, 1.8429786401E+00, 8.7473741475E-01],
	[2.5295000000E+04, 1.5274837730E+01, 4.9016100927E+00, 3.6640107970E+00, 1.8436350460E+00, 8.7479795306E-01],
	[2.5300000000E+04, 1.5279618815E+01, 4.9015613330E+00, 3.6663559584E+00, 1.8442913877E+00, 8.7485846307E-01],
	[2.5305000000E+04, 1.5284400451E+01, 4.9015125835E+00, 3.6687021564E+00, 1.8449476650E+00, 8.7491894480E-01],
	[2.5310000000E+04, 1.5289182638E+01, 4.9014638440E+00, 3.6710493911E+00, 1.8456038778E+00, 8.7497939826E-01],
	[2.5315000000E+04, 1.5293965376E+01, 4.9014151147E+00, 3.6733976630E+00, 1.8462600261E+00, 8.7503982345E-01],
	[2.5320000000E+04, 1.5298748666E+01, 4.9013663955E+00, 3.6757469721E+00, 1.8469161097E+00, 8.7510022038E-01],
	[2.5325000000E+04, 1.5303532506E+01, 4.9013176864E+00, 3.6780973188E+00, 1.8475721286E+00, 8.7516058907E-01],
	[2.5330000000E+04, 1.5308316898E+01, 4.9012689874E+00, 3.6804487034E+00, 1.8482280826E+00, 8.7522092952E-01],
	[2.5335000000E+04, 1.5313101840E+01, 4.9012202984E+00, 3.6828011260E+00, 1.8488839717E+00, 8.7528124174E-01],
	[2.5340000000E+04, 1.5317887334E+01, 4.9011716196E+00, 3.6851545870E+00, 1.8495397958E+00, 8.7534152574E-01],
	[2.5345000000E+04, 1.5322673378E+01, 4.9011229509E+00, 3.6875090865E+00, 1.8501955547E+00, 8.7540178153E-01],
	[2.5350000000E+04, 1.5327459973E+01, 4.9010742922E+00, 3.6898646248E+00, 1.8508512484E+00, 8.7546200911E-01],
	[2.5355000000E+04, 1.5332247119E+01, 4.9010256437E+00, 3.6922212023E+00, 1.8515068768E+00, 8.7552220851E-01],
	[2.5360000000E+04, 1.5337034816E+01, 4.9009770052E+00, 3.6945788191E+00, 1.8521624398E+00, 8.7558237972E-01],
	[2.5365000000E+04, 1.5341823064E+01, 4.9009283767E+00, 3.6969374755E+00, 1.8528179373E+00, 8.7564252275E-01],
	[2.5370000000E+04, 1.5346611862E+01, 4.9008797584E+00, 3.6992971717E+00, 1.8534733691E+00, 8.7570263762E-01],
	[2.5375000000E+04, 1.5351401211E+01, 4.9008311501E+00, 3.7016579080E+00, 1.8541287352E+00, 8.7576272433E-01],
	[2.5380000000E+04, 1.5356191110E+01, 4.9007825518E+00, 3.7040196847E+00, 1.8547840356E+00, 8.7582278289E-01],
	[2.5385000000E+04, 1.5360981561E+01, 4.9007339637E+00, 3.7063825020E+00, 1.8554392700E+00, 8.7588281332E-01],
	[2.5390000000E+04, 1.5365772561E+01, 4.9006853855E+00, 3.7087463601E+00, 1.8560944385E+00, 8.7594281561E-01],
	[2.5395000000E+04, 1.5370564112E+01, 4.9006368174E+00, 3.7111112594E+00, 1.8567495409E+00, 8.7600278979E-01],
	[2.5400000000E+04, 1.5375356213E+01, 4.9005882594E+00, 3.7134772000E+00, 1.8574045770E+00, 8.7606273585E-01],
	[2.5405000000E+04, 1.5380148865E+01, 4.9005397114E+00, 3.7158441822E+00, 1.8580595470E+00, 8.7612265381E-01],
	[2.5410000000E+04, 1.5384942067E+01, 4.9004911734E+00, 3.7182122063E+00, 1.8587144505E+00, 8.7618254368E-01],
	[2.5415000000E+04, 1.5389735820E+01, 4.9004426455E+00, 3.7205812725E+00, 1.8593692876E+00, 8.7624240547E-01],
	[2.5420000000E+04, 1.5394530122E+01, 4.9003941276E+00, 3.7229513811E+00, 1.8600240581E+00, 8.7630223918E-01],
	[2.5425000000E+04, 1.5399324975E+01, 4.9003456197E+00, 3.7253225323E+00, 1.8606787620E+00, 8.7636204482E-01],
	[2.5430000000E+04, 1.5404120378E+01, 4.9002971218E+00, 3.7276947265E+00, 1.8613333991E+00, 8.7642182241E-01],
	[2.5435000000E+04, 1.5408916331E+01, 4.9002486340E+00, 3.7300679637E+00, 1.8619879693E+00, 8.7648157195E-01],
	[2.5440000000E+04, 1.5413712834E+01, 4.9002001561E+00, 3.7324422443E+00, 1.8626424727E+00, 8.7654129346E-01],
	[2.5445000000E+04, 1.5418509887E+01, 4.9001516883E+00, 3.7348175686E+00, 1.8632969090E+00, 8.7660098693E-01],
	[2.5450000000E+04, 1.5423307490E+01, 4.9001032304E+00, 3.7371939368E+00, 1.8639512782E+00, 8.7666065239E-01],
	[2.5455000000E+04, 1.5428105643E+01, 4.9000547826E+00, 3.7395713491E+00, 1.8646055801E+00, 8.7672028984E-01],
	[2.5460000000E+04, 1.5432904346E+01, 4.9000063447E+00, 3.7419498058E+00, 1.8652598148E+00, 8.7677989928E-01],
	[2.5465000000E+04, 1.5437703598E+01, 4.8999579169E+00, 3.7443293072E+00, 1.8659139820E+00, 8.7683948074E-01],
	[2.5470000000E+04, 1.5442503401E+01, 4.8999094990E+00, 3.7467098534E+00, 1.8665680817E+00, 8.7689903421E-01],
	[2.5475000000E+04, 1.5447303753E+01, 4.8998610911E+00, 3.7490914449E+00, 1.8672221139E+00, 8.7695855971E-01],
	[2.5480000000E+04, 1.5452104655E+01, 4.8998126932E+00, 3.7514740817E+00, 1.8678760783E+00, 8.7701805724E-01],
	[2.5485000000E+04, 1.5456906106E+01, 4.8997643053E+00, 3.7538577642E+00, 1.8685299750E+00, 8.7707752682E-01],
	[2.5490000000E+04, 1.5461708107E+01, 4.8997159273E+00, 3.7562424927E+00, 1.8691838038E+00, 8.7713696846E-01],
	[2.5495000000E+04, 1.5466518319E+01, 4.8996688460E+00, 3.7586282673E+00, 1.8698378639E+00, 8.7719638216E-01],
	[2.5500000000E+04, 1.5471342703E+01, 4.8996240606E+00, 3.7610150883E+00, 1.8704923886E+00, 8.7725576793E-01],
	[2.5505000000E+04, 1.5476167645E+01, 4.8995792845E+00, 3.7634029560E+00, 1.8711468460E+00, 8.7731512579E-01],
	[2.5510000000E+04, 1.5480993145E+01, 4.8995345176E+00, 3.7657918706E+00, 1.8718012359E+00, 8.7737445574E-01],
	[2.5515000000E+04, 1.5485819204E+01, 4.8994897598E+00, 3.7681818325E+00, 1.8724555583E+00, 8.7743375779E-01],
	[2.5520000000E+04, 1.5490645821E+01, 4.8994450112E+00, 3.7705728417E+00, 1.8731098131E+00, 8.7749303195E-01],
	[2.5525000000E+04, 1.5495472997E+01, 4.8994002718E+00, 3.7729648987E+00, 1.8737640001E+00, 8.7755227823E-01],
	[2.5530000000E+04, 1.5500300731E+01, 4.8993555415E+00, 3.7753580036E+00, 1.8744181194E+00, 8.7761149664E-01],
	[2.5535000000E+04, 1.5505129023E+01, 4.8993108204E+00, 3.7777521567E+00, 1.8750721707E+00, 8.7767068719E-01],
	[2.5540000000E+04, 1.5509957873E+01, 4.8992661085E+00, 3.7801473583E+00, 1.8757261541E+00, 8.7772984989E-01],
	[2.5545000000E+04, 1.5514787282E+01, 4.8992214058E+00, 3.7825436085E+00, 1.8763800694E+00, 8.7778898475E-01],
	[2.5550000000E+04, 1.5519617249E+01, 4.8991767122E+00, 3.7849409078E+00, 1.8770339165E+00, 8.7784809177E-01],
	[2.5555000000E+04, 1.5524447774E+01, 4.8991320277E+00, 3.7873392562E+00, 1.8776876953E+00, 8.7790717097E-01],
	[2.5560000000E+04, 1.5529278857E+01, 4.8990873524E+00, 3.7897386541E+00, 1.8783414058E+00, 8.7796622236E-01],
	[2.5565000000E+04, 1.5534110497E+01, 4.8990426863E+00, 3.7921391017E+00, 1.8789950478E+00, 8.7802524594E-01],
	[2.5570000000E+04, 1.5538942696E+01, 4.8989980293E+00, 3.7945405993E+00, 1.8796486213E+00, 8.7808424173E-01],
	[2.5575000000E+04, 1.5543775453E+01, 4.8989533814E+00, 3.7969431472E+00, 1.8803021262E+00, 8.7814320973E-01],
	[2.5580000000E+04, 1.5548608768E+01, 4.8989087427E+00, 3.7993467455E+00, 1.8809555623E+00, 8.7820214996E-01],
	[2.5585000000E+04, 1.5553442640E+01, 4.8988641130E+00, 3.8017513945E+00, 1.8816089296E+00, 8.7826106242E-01],
	[2.5590000000E+04, 1.5558277070E+01, 4.8988194926E+00, 3.8041570945E+00, 1.8822622280E+00, 8.7831994712E-01],
	[2.5595000000E+04, 1.5563112058E+01, 4.8987748812E+00, 3.8065638458E+00, 1.8829154574E+00, 8.7837880407E-01],
	[2.5600000000E+04, 1.5567947604E+01, 4.8987302790E+00, 3.8089716485E+00, 1.8835686177E+00, 8.7843763329E-01],
	[2.5605000000E+04, 1.5572783707E+01, 4.8986856859E+00, 3.8113805030E+00, 1.8842217088E+00, 8.7849643478E-01],
	[2.5610000000E+04, 1.5577620368E+01, 4.8986411019E+00, 3.8137904095E+00, 1.8848747306E+00, 8.7855520854E-01],
	[2.5615000000E+04, 1.5582457586E+01, 4.8985965270E+00, 3.8162013683E+00, 1.8855276830E+00, 8.7861395460E-01],
	[2.5620000000E+04, 1.5587295362E+01, 4.8985519612E+00, 3.8186133796E+00, 1.8861805660E+00, 8.7867267296E-01],
	[2.5625000000E+04, 1.5592133695E+01, 4.8985074045E+00, 3.8210264436E+00, 1.8868333795E+00, 8.7873136363E-01],
	[2.5630000000E+04, 1.5596972586E+01, 4.8984628569E+00, 3.8234405606E+00, 1.8874861233E+00, 8.7879002662E-01],
	[2.5635000000E+04, 1.5601812034E+01, 4.8984183184E+00, 3.8258557309E+00, 1.8881387973E+00, 8.7884866193E-01],
	[2.5640000000E+04, 1.5606652040E+01, 4.8983737890E+00, 3.8282719548E+00, 1.8887914016E+00, 8.7890726959E-01],
	[2.5645000000E+04, 1.5611492603E+01, 4.8983292687E+00, 3.8306892324E+00, 1.8894439359E+00, 8.7896584959E-01],
	[2.5650000000E+04, 1.5616333723E+01, 4.8982847575E+00, 3.8331075640E+00, 1.8900964002E+00, 8.7902440195E-01],
	[2.5655000000E+04, 1.5621175400E+01, 4.8982402553E+00, 3.8355269499E+00, 1.8907487944E+00, 8.7908292667E-01],
	[2.5660000000E+04, 1.5626017634E+01, 4.8981957622E+00, 3.8379473904E+00, 1.8914011184E+00, 8.7914142378E-01],
	[2.5665000000E+04, 1.5630860426E+01, 4.8981512782E+00, 3.8403688856E+00, 1.8920533721E+00, 8.7919989327E-01],
	[2.5670000000E+04, 1.5635703774E+01, 4.8981068033E+00, 3.8427914359E+00, 1.8927055555E+00, 8.7925833515E-01],
	[2.5675000000E+04, 1.5640547680E+01, 4.8980623374E+00, 3.8452150415E+00, 1.8933576684E+00, 8.7931674944E-01],
	[2.5680000000E+04, 1.5645392142E+01, 4.8980178806E+00, 3.8476397026E+00, 1.8940097108E+00, 8.7937513614E-01],
	[2.5685000000E+04, 1.5650237162E+01, 4.8979734329E+00, 3.8500654195E+00, 1.8946616825E+00, 8.7943349527E-01],
	[2.5690000000E+04, 1.5655082738E+01, 4.8979289942E+00, 3.8524921925E+00, 1.8953135835E+00, 8.7949182684E-01],
	[2.5695000000E+04, 1.5659928871E+01, 4.8978845645E+00, 3.8549200218E+00, 1.8959654136E+00, 8.7955013084E-01],
	[2.5700000000E+04, 1.5664775561E+01, 4.8978401439E+00, 3.8573489077E+00, 1.8966171729E+00, 8.7960840730E-01],
	[2.5705000000E+04, 1.5669622808E+01, 4.8977957324E+00, 3.8597788504E+00, 1.8972688611E+00, 8.7966665623E-01],
	[2.5710000000E+04, 1.5674470611E+01, 4.8977513299E+00, 3.8622098502E+00, 1.8979204783E+00, 8.7972487763E-01],
	[2.5715000000E+04, 1.5679318971E+01, 4.8977069364E+00, 3.8646419073E+00, 1.8985720243E+00, 8.7978307150E-01],
	[2.5720000000E+04, 1.5684167888E+01, 4.8976625520E+00, 3.8670750219E+00, 1.8992234990E+00, 8.7984123788E-01],
	[2.5725000000E+04, 1.5689017361E+01, 4.8976181766E+00, 3.8695091944E+00, 1.8998749023E+00, 8.7989937675E-01],
	[2.5730000000E+04, 1.5693867391E+01, 4.8975738102E+00, 3.8719444250E+00, 1.9005262342E+00, 8.7995748813E-01],
	[2.5735000000E+04, 1.5698717977E+01, 4.8975294528E+00, 3.8743807140E+00, 1.9011774946E+00, 8.8001557204E-01],
	[2.5740000000E+04, 1.5703569120E+01, 4.8974851045E+00, 3.8768180615E+00, 1.9018286833E+00, 8.8007362848E-01],
	[2.5745000000E+04, 1.5708420819E+01, 4.8974407652E+00, 3.8792564679E+00, 1.9024798003E+00, 8.8013165746E-01],
	[2.5750000000E+04, 1.5713273075E+01, 4.8973964348E+00, 3.8816959333E+00, 1.9031308455E+00, 8.8018965898E-01],
	[2.5755000000E+04, 1.5718125886E+01, 4.8973521135E+00, 3.8841364582E+00, 1.9037818188E+00, 8.8024763307E-01],
	[2.5760000000E+04, 1.5722979254E+01, 4.8973078012E+00, 3.8865780426E+00, 1.9044327202E+00, 8.8030557973E-01],
	[2.5765000000E+04, 1.5727833179E+01, 4.8972634979E+00, 3.8890206869E+00, 1.9050835494E+00, 8.8036349897E-01],
	[2.5770000000E+04, 1.5732687659E+01, 4.8972192036E+00, 3.8914643914E+00, 1.9057343065E+00, 8.8042139080E-01],
	[2.5775000000E+04, 1.5737542696E+01, 4.8971749183E+00, 3.8939091562E+00, 1.9063849913E+00, 8.8047925523E-01],
	[2.5780000000E+04, 1.5742398288E+01, 4.8971306420E+00, 3.8963549816E+00, 1.9070356038E+00, 8.8053709226E-01],
	[2.5785000000E+04, 1.5747254437E+01, 4.8970863747E+00, 3.8988018679E+00, 1.9076861439E+00, 8.8059490192E-01],
	[2.5790000000E+04, 1.5752111142E+01, 4.8970421163E+00, 3.9012498154E+00, 1.9083366115E+00, 8.8065268420E-01],
	[2.5795000000E+04, 1.5756968402E+01, 4.8969978669E+00, 3.9036988242E+00, 1.9089870064E+00, 8.8071043912E-01],
	[2.5800000000E+04, 1.5761826219E+01, 4.8969536266E+00, 3.9061488947E+00, 1.9096373287E+00, 8.8076816669E-01],
	[2.5805000000E+04, 1.5766684591E+01, 4.8969093951E+00, 3.9086000270E+00, 1.9102875781E+00, 8.8082586692E-01],
	[2.5810000000E+04, 1.5771543519E+01, 4.8968651727E+00, 3.9110522216E+00, 1.9109377547E+00, 8.8088353982E-01],
	[2.5815000000E+04, 1.5776403003E+01, 4.8968209592E+00, 3.9135054785E+00, 1.9115878584E+00, 8.8094118539E-01],
	[2.5820000000E+04, 1.5781263043E+01, 4.8967767547E+00, 3.9159597981E+00, 1.9122378890E+00, 8.8099880366E-01],
	[2.5825000000E+04, 1.5786123639E+01, 4.8967325591E+00, 3.9184151806E+00, 1.9128878464E+00, 8.8105639461E-01],
	[2.5830000000E+04, 1.5790984790E+01, 4.8966883725E+00, 3.9208716262E+00, 1.9135377307E+00, 8.8111395828E-01],
	[2.5835000000E+04, 1.5795846496E+01, 4.8966441948E+00, 3.9233291353E+00, 1.9141875416E+00, 8.8117149466E-01],
	[2.5840000000E+04, 1.5800708759E+01, 4.8966000261E+00, 3.9257877080E+00, 1.9148372791E+00, 8.8122900377E-01],
	[2.5845000000E+04, 1.5805571576E+01, 4.8965558663E+00, 3.9282473447E+00, 1.9154869432E+00, 8.8128648562E-01],
	[2.5850000000E+04, 1.5810434950E+01, 4.8965117155E+00, 3.9307080456E+00, 1.9161365336E+00, 8.8134394022E-01],
	[2.5855000000E+04, 1.5815298878E+01, 4.8964675736E+00, 3.9331698109E+00, 1.9167860505E+00, 8.8140136757E-01],
	[2.5860000000E+04, 1.5820163362E+01, 4.8964234407E+00, 3.9356326409E+00, 1.9174354935E+00, 8.8145876768E-01],
	[2.5865000000E+04, 1.5825028402E+01, 4.8963793166E+00, 3.9380965358E+00, 1.9180848628E+00, 8.8151614058E-01],
	[2.5870000000E+04, 1.5829893996E+01, 4.8963352015E+00, 3.9405614959E+00, 1.9187341581E+00, 8.8157348626E-01],
	[2.5875000000E+04, 1.5834760146E+01, 4.8962910954E+00, 3.9430275215E+00, 1.9193833794E+00, 8.8163080473E-01],
	[2.5880000000E+04, 1.5839626851E+01, 4.8962469981E+00, 3.9454946128E+00, 1.9200325266E+00, 8.8168809601E-01],
	[2.5885000000E+04, 1.5844494112E+01, 4.8962029097E+00, 3.9479627700E+00, 1.9206815996E+00, 8.8174536011E-01],
	[2.5890000000E+04, 1.5849361927E+01, 4.8961588303E+00, 3.9504319935E+00, 1.9213305984E+00, 8.8180259703E-01],
	[2.5895000000E+04, 1.5854230298E+01, 4.8961147598E+00, 3.9529022834E+00, 1.9219795228E+00, 8.8185980679E-01],
	[2.5900000000E+04, 1.5859099223E+01, 4.8960706982E+00, 3.9553736401E+00, 1.9226283727E+00, 8.8191698940E-01],
	[2.5905000000E+04, 1.5863974613E+01, 4.8960276242E+00, 3.9578460637E+00, 1.9232773860E+00, 8.8197414486E-01],
	[2.5910000000E+04, 1.5868865841E+01, 4.8959870892E+00, 3.9603195546E+00, 1.9239269403E+00, 8.8203127319E-01],
	[2.5915000000E+04, 1.5873757633E+01, 4.8959465623E+00, 3.9627941129E+00, 1.9245764206E+00, 8.8208837439E-01],
	[2.5920000000E+04, 1.5878649988E+01, 4.8959060436E+00, 3.9652697390E+00, 1.9252258270E+00, 8.8214544848E-01],
	[2.5925000000E+04, 1.5883542908E+01, 4.8958655330E+00, 3.9677464331E+00, 1.9258751593E+00, 8.8220249546E-01],
	[2.5930000000E+04, 1.5888436391E+01, 4.8958250306E+00, 3.9702241954E+00, 1.9265244174E+00, 8.8225951535E-01],
	[2.5935000000E+04, 1.5893330438E+01, 4.8957845363E+00, 3.9727030262E+00, 1.9271736013E+00, 8.8231650816E-01],
	[2.5940000000E+04, 1.5898225048E+01, 4.8957440502E+00, 3.9751829258E+00, 1.9278227109E+00, 8.8237347389E-01],
	[2.5945000000E+04, 1.5903120222E+01, 4.8957035722E+00, 3.9776638944E+00, 1.9284717461E+00, 8.8243041256E-01],
	[2.5950000000E+04, 1.5908015960E+01, 4.8956631023E+00, 3.9801459323E+00, 1.9291207067E+00, 8.8248732417E-01],
	[2.5955000000E+04, 1.5912912261E+01, 4.8956226406E+00, 3.9826290397E+00, 1.9297695928E+00, 8.8254420874E-01],
	[2.5960000000E+04, 1.5917809125E+01, 4.8955821870E+00, 3.9851132168E+00, 1.9304184042E+00, 8.8260106627E-01],
	[2.5965000000E+04, 1.5922706553E+01, 4.8955417415E+00, 3.9875984640E+00, 1.9310671408E+00, 8.8265789678E-01],
	[2.5970000000E+04, 1.5927604544E+01, 4.8955013041E+00, 3.9900847815E+00, 1.9317158026E+00, 8.8271470028E-01],
	[2.5975000000E+04, 1.5932503099E+01, 4.8954608749E+00, 3.9925721695E+00, 1.9323643895E+00, 8.8277147677E-01],
	[2.5980000000E+04, 1.5937402217E+01, 4.8954204537E+00, 3.9950606283E+00, 1.9330129013E+00, 8.8282822626E-01],
	[2.5985000000E+04, 1.5942301898E+01, 4.8953800407E+00, 3.9975501581E+00, 1.9336613381E+00, 8.8288494878E-01],
	[2.5990000000E+04, 1.5947202142E+01, 4.8953396358E+00, 4.0000407592E+00, 1.9343096997E+00, 8.8294164432E-01],
	[2.5995000000E+04, 1.5952102949E+01, 4.8952992390E+00, 4.0025324319E+00, 1.9349579860E+00, 8.8299831289E-01],
	[2.6000000000E+04, 1.5957004320E+01, 4.8952588503E+00, 4.0050251764E+00, 1.9356061969E+00, 8.8305495451E-01],
	[2.6005000000E+04, 1.5961906253E+01, 4.8952184697E+00, 4.0075189930E+00, 1.9362543324E+00, 8.8311156919E-01],
	[2.6010000000E+04, 1.5966808750E+01, 4.8951780972E+00, 4.0100138818E+00, 1.9369023924E+00, 8.8316815693E-01],
	[2.6015000000E+04, 1.5971711809E+01, 4.8951377328E+00, 4.0125098433E+00, 1.9375503768E+00, 8.8322471775E-01],
	[2.6020000000E+04, 1.5976615432E+01, 4.8950973765E+00, 4.0150068776E+00, 1.9381982855E+00, 8.8328125166E-01],
	[2.6025000000E+04, 1.5981519617E+01, 4.8950570282E+00, 4.0175049849E+00, 1.9388461184E+00, 8.8333775866E-01],
	[2.6030000000E+04, 1.5986424365E+01, 4.8950166881E+00, 4.0200041656E+00, 1.9394938754E+00, 8.8339423877E-01],
	[2.6035000000E+04, 1.5991329676E+01, 4.8949763560E+00, 4.0225044199E+00, 1.9401415565E+00, 8.8345069199E-01],
	[2.6040000000E+04, 1.5996235550E+01, 4.8949360320E+00, 4.0250057480E+00, 1.9407891616E+00, 8.8350711835E-01],
	[2.6045000000E+04, 1.6001141987E+01, 4.8948957161E+00, 4.0275081502E+00, 1.9414366905E+00, 8.8356351784E-01],
	[2.6050000000E+04, 1.6006048986E+01, 4.8948554082E+00, 4.0300116268E+00, 1.9420841433E+00, 8.8361989047E-01],
	[2.6055000000E+04, 1.6010956548E+01, 4.8948151085E+00, 4.0325161780E+00, 1.9427315198E+00, 8.8367623627E-01],
	[2.6060000000E+04, 1.6015864672E+01, 4.8947748167E+00, 4.0350218040E+00, 1.9433788199E+00, 8.8373255523E-01],
	[2.6065000000E+04, 1.6020773359E+01, 4.8947345331E+00, 4.0375285052E+00, 1.9440260435E+00, 8.8378884737E-01],
	[2.6070000000E+04, 1.6025682608E+01, 4.8946942575E+00, 4.0400362817E+00, 1.9446731906E+00, 8.8384511270E-01],
	[2.6075000000E+04, 1.6030592420E+01, 4.8946539899E+00, 4.0425451339E+00, 1.9453202611E+00, 8.8390135122E-01],
	[2.6080000000E+04, 1.6035502794E+01, 4.8946137305E+00, 4.0450550619E+00, 1.9459672549E+00, 8.8395756296E-01],
	[2.6085000000E+04, 1.6040413731E+01, 4.8945734790E+00, 4.0475660661E+00, 1.9466141719E+00, 8.8401374791E-01],
	[2.6090000000E+04, 1.6045325229E+01, 4.8945332356E+00, 4.0500781466E+00, 1.9472610120E+00, 8.8406990609E-01],
	[2.6095000000E+04, 1.6050237291E+01, 4.8944930003E+00, 4.0525913038E+00, 1.9479077752E+00, 8.8412603751E-01],
	[2.6100000000E+04, 1.6055149914E+01, 4.8944527730E+00, 4.0551055379E+00, 1.9485544613E+00, 8.8418214217E-01],
	[2.6105000000E+04, 1.6060063100E+01, 4.8944125537E+00, 4.0576208492E+00, 1.9492010703E+00, 8.8423822010E-01],
	[2.6110000000E+04, 1.6064976847E+01, 4.8943723424E+00, 4.0601372379E+00, 1.9498476021E+00, 8.8429427130E-01],
	[2.6115000000E+04, 1.6069891157E+01, 4.8943321392E+00, 4.0626547042E+00, 1.9504940567E+00, 8.8435029577E-01],
	[2.6120000000E+04, 1.6074806029E+01, 4.8942919440E+00, 4.0651732484E+00, 1.9511404338E+00, 8.8440629354E-01],
	[2.6125000000E+04, 1.6079721463E+01, 4.8942517569E+00, 4.0676928708E+00, 1.9517867335E+00, 8.8446226460E-01],
	[2.6130000000E+04, 1.6084637459E+01, 4.8942115777E+00, 4.0702135717E+00, 1.9524329557E+00, 8.8451820897E-01],
	[2.6135000000E+04, 1.6089554017E+01, 4.8941714066E+00, 4.0727353512E+00, 1.9530791002E+00, 8.8457412667E-01],
	[2.6140000000E+04, 1.6094471136E+01, 4.8941312435E+00, 4.0752582096E+00, 1.9537251671E+00, 8.8463001769E-01],
	[2.6145000000E+04, 1.6099388818E+01, 4.8940910884E+00, 4.0777821473E+00, 1.9543711561E+00, 8.8468588206E-01],
	[2.6150000000E+04, 1.6104307061E+01, 4.8940509413E+00, 4.0803071644E+00, 1.9550170673E+00, 8.8474171978E-01],
	[2.6155000000E+04, 1.6109225866E+01, 4.8940108022E+00, 4.0828332612E+00, 1.9556629006E+00, 8.8479753086E-01],
	[2.6160000000E+04, 1.6114145233E+01, 4.8939706711E+00, 4.0853604379E+00, 1.9563086558E+00, 8.8485331531E-01],
	[2.6165000000E+04, 1.6119065161E+01, 4.8939305480E+00, 4.0878886948E+00, 1.9569543329E+00, 8.8490907314E-01],
	[2.6170000000E+04, 1.6123985651E+01, 4.8938904329E+00, 4.0904180323E+00, 1.9575999318E+00, 8.8496480436E-01],
	[2.6175000000E+04, 1.6128906703E+01, 4.8938503258E+00, 4.0929484504E+00, 1.9582454524E+00, 8.8502050899E-01],
	[2.6180000000E+04, 1.6133828316E+01, 4.8938102267E+00, 4.0954799495E+00, 1.9588908946E+00, 8.8507618703E-01],
	[2.6185000000E+04, 1.6138750491E+01, 4.8937701356E+00, 4.0980125298E+00, 1.9595362585E+00, 8.8513183849E-01],
	[2.6190000000E+04, 1.6143673227E+01, 4.8937300524E+00, 4.1005461917E+00, 1.9601815438E+00, 8.8518746338E-01],
	[2.6195000000E+04, 1.6148596525E+01, 4.8936899773E+00, 4.1030809352E+00, 1.9608267505E+00, 8.8524306172E-01],
	[2.6200000000E+04, 1.6153520384E+01, 4.8936499101E+00, 4.1056167608E+00, 1.9614718785E+00, 8.8529863351E-01],
	[2.6205000000E+04, 1.6158444804E+01, 4.8936098509E+00, 4.1081536686E+00, 1.9621169277E+00, 8.8535417877E-01],
	[2.6210000000E+04, 1.6163369785E+01, 4.8935697996E+00, 4.1106916589E+00, 1.9627618981E+00, 8.8540969750E-01],
	[2.6215000000E+04, 1.6168295328E+01, 4.8935297564E+00, 4.1132307319E+00, 1.9634067895E+00, 8.8546518972E-01],
	[2.6220000000E+04, 1.6173221432E+01, 4.8934897211E+00, 4.1157708880E+00, 1.9640516020E+00, 8.8552065543E-01],
	[2.6225000000E+04, 1.6178148097E+01, 4.8934496937E+00, 4.1183121273E+00, 1.9646963353E+00, 8.8557609464E-01],
	[2.6230000000E+04, 1.6183075323E+01, 4.8934096743E+00, 4.1208544502E+00, 1.9653409895E+00, 8.8563150737E-01],
	[2.6235000000E+04, 1.6188003111E+01, 4.8933696629E+00, 4.1233978568E+00, 1.9659855644E+00, 8.8568689363E-01],
	[2.6240000000E+04, 1.6192931459E+01, 4.8933296594E+00, 4.1259423475E+00, 1.9666300600E+00, 8.8574225343E-01],
	[2.6245000000E+04, 1.6197860368E+01, 4.8932896639E+00, 4.1284879224E+00, 1.9672744761E+00, 8.8579758677E-01],
	[2.6250000000E+04, 1.6202789838E+01, 4.8932496763E+00, 4.1310345819E+00, 1.9679188128E+00, 8.8585289366E-01],
	[2.6255000000E+04, 1.6207719870E+01, 4.8932096966E+00, 4.1335823262E+00, 1.9685630698E+00, 8.8590817413E-01],
	[2.6260000000E+04, 1.6212650462E+01, 4.8931697249E+00, 4.1361311555E+00, 1.9692072472E+00, 8.8596342817E-01],
	[2.6265000000E+04, 1.6217581614E+01, 4.8931297612E+00, 4.1386810702E+00, 1.9698513449E+00, 8.8601865580E-01],
	[2.6270000000E+04, 1.6222513328E+01, 4.8930898053E+00, 4.1412320704E+00, 1.9704953627E+00, 8.8607385703E-01],
	[2.6275000000E+04, 1.6227445602E+01, 4.8930498574E+00, 4.1437841564E+00, 1.9711393007E+00, 8.8612903187E-01],
	[2.6280000000E+04, 1.6232378437E+01, 4.8930099174E+00, 4.1463373285E+00, 1.9717831586E+00, 8.8618418033E-01],
	[2.6285000000E+04, 1.6237311833E+01, 4.8929699854E+00, 4.1488915870E+00, 1.9724269365E+00, 8.8623930241E-01],
	[2.6290000000E+04, 1.6242245789E+01, 4.8929300612E+00, 4.1514469320E+00, 1.9730706343E+00, 8.8629439814E-01],
	[2.6295000000E+04, 1.6247180305E+01, 4.8928901450E+00, 4.1540033638E+00, 1.9737142518E+00, 8.8634946752E-01],
	[2.6300000000E+04, 1.6252115383E+01, 4.8928502367E+00, 4.1565608827E+00, 1.9743577890E+00, 8.8640451056E-01],
	[2.6305000000E+04, 1.6257051020E+01, 4.8928103363E+00, 4.1591194890E+00, 1.9750012459E+00, 8.8645952727E-01],
	[2.6310000000E+04, 1.6261987218E+01, 4.8927704439E+00, 4.1616791829E+00, 1.9756446222E+00, 8.8651451766E-01],
	[2.6315000000E+04, 1.6266923977E+01, 4.8927305593E+00, 4.1642399646E+00, 1.9762879181E+00, 8.8656948174E-01],
	[2.6320000000E+04, 1.6271861296E+01, 4.8926906826E+00, 4.1668018345E+00, 1.9769311333E+00, 8.8662441953E-01],
	[2.6325000000E+04, 1.6276817664E+01, 4.8926538341E+00, 4.1693647927E+00, 1.9775750341E+00, 8.8667933102E-01],
	[2.6330000000E+04, 1.6281777210E+01, 4.8926174190E+00, 4.1719288396E+00, 1.9782189631E+00, 8.8673421625E-01],
	[2.6335000000E+04, 1.6286737325E+01, 4.8925810110E+00, 4.1744939753E+00, 1.9788628119E+00, 8.8678907520E-01],
	[2.6340000000E+04, 1.6291698009E+01, 4.8925446102E+00, 4.1770602001E+00, 1.9795065806E+00, 8.8684390790E-01],
	[2.6345000000E+04, 1.6296659262E+01, 4.8925082166E+00, 4.1796275144E+00, 1.9801502691E+00, 8.8689871435E-01],
	[2.6350000000E+04, 1.6301621084E+01, 4.8924718302E+00, 4.1821959182E+00, 1.9807938773E+00, 8.8695349457E-01],
	[2.6355000000E+04, 1.6306583474E+01, 4.8924354509E+00, 4.1847654120E+00, 1.9814374051E+00, 8.8700824857E-01],
	[2.6360000000E+04, 1.6311546434E+01, 4.8923990788E+00, 4.1873359960E+00, 1.9820808524E+00, 8.8706297635E-01],
	[2.6365000000E+04, 1.6316509962E+01, 4.8923627139E+00, 4.1899076703E+00, 1.9827242192E+00, 8.8711767793E-01],
	[2.6370000000E+04, 1.6321474059E+01, 4.8923263561E+00, 4.1924804353E+00, 1.9833675053E+00, 8.8717235331E-01],
	[2.6375000000E+04, 1.6326438724E+01, 4.8922900056E+00, 4.1950542912E+00, 1.9840107108E+00, 8.8722700251E-01],
	[2.6380000000E+04, 1.6331403959E+01, 4.8922536621E+00, 4.1976292383E+00, 1.9846538354E+00, 8.8728162554E-01],
	[2.6385000000E+04, 1.6336369762E+01, 4.8922173259E+00, 4.2002052768E+00, 1.9852968792E+00, 8.8733622241E-01],
	[2.6390000000E+04, 1.6341336133E+01, 4.8921809967E+00, 4.2027824071E+00, 1.9859398421E+00, 8.8739079312E-01],
	[2.6395000000E+04, 1.6346303073E+01, 4.8921446748E+00, 4.2053606292E+00, 1.9865827239E+00, 8.8744533770E-01],
	[2.6400000000E+04, 1.6351270581E+01, 4.8921083600E+00, 4.2079399436E+00, 1.9872255247E+00, 8.8749985614E-01],
	[2.6405000000E+04, 1.6356238658E+01, 4.8920720523E+00, 4.2105203504E+00, 1.9878682442E+00, 8.8755434847E-01],
	[2.6410000000E+04, 1.6361207303E+01, 4.8920357518E+00, 4.2131018499E+00, 1.9885108825E+00, 8.8760881468E-01],
	[2.6415000000E+04, 1.6366176517E+01, 4.8919994584E+00, 4.2156844423E+00, 1.9891534395E+00, 8.8766325480E-01],
	[2.6420000000E+04, 1.6371146299E+01, 4.8919631722E+00, 4.2182681280E+00, 1.9897959151E+00, 8.8771766883E-01],
	[2.6425000000E+04, 1.6376116649E+01, 4.8919268930E+00, 4.2208529071E+00, 1.9904383091E+00, 8.8777205678E-01],
	[2.6430000000E+04, 1.6381087567E+01, 4.8918906211E+00, 4.2234387800E+00, 1.9910806217E+00, 8.8782641866E-01],
	[2.6435000000E+04, 1.6386059054E+01, 4.8918543562E+00, 4.2260257469E+00, 1.9917228525E+00, 8.8788075449E-01],
	[2.6440000000E+04, 1.6391031108E+01, 4.8918180985E+00, 4.2286138080E+00, 1.9923650016E+00, 8.8793506427E-01],
	[2.6445000000E+04, 1.6396003731E+01, 4.8917818479E+00, 4.2312029636E+00, 1.9930070690E+00, 8.8798934801E-01],
	[2.6450000000E+04, 1.6400976922E+01, 4.8917456044E+00, 4.2337932139E+00, 1.9936490544E+00, 8.8804360573E-01],
	[2.6455000000E+04, 1.6405950681E+01, 4.8917093681E+00, 4.2363845593E+00, 1.9942909579E+00, 8.8809783744E-01],
	[2.6460000000E+04, 1.6410925007E+01, 4.8916731389E+00, 4.2389769999E+00, 1.9949327794E+00, 8.8815204314E-01],
	[2.6465000000E+04, 1.6415899902E+01, 4.8916369167E+00, 4.2415705360E+00, 1.9955745188E+00, 8.8820622285E-01],
	[2.6470000000E+04, 1.6420875364E+01, 4.8916007017E+00, 4.2441651679E+00, 1.9962161759E+00, 8.8826037657E-01],
	[2.6475000000E+04, 1.6425851395E+01, 4.8915644938E+00, 4.2467608958E+00, 1.9968577508E+00, 8.8831450432E-01],
	[2.6480000000E+04, 1.6430827993E+01, 4.8915282930E+00, 4.2493577200E+00, 1.9974992434E+00, 8.8836860611E-01],
	[2.6485000000E+04, 1.6435805159E+01, 4.8914920993E+00, 4.2519556407E+00, 1.9981406535E+00, 8.8842268195E-01],
	[2.6490000000E+04, 1.6440782893E+01, 4.8914559127E+00, 4.2545546582E+00, 1.9987819812E+00, 8.8847673185E-01],
	[2.6495000000E+04, 1.6445761194E+01, 4.8914197332E+00, 4.2571547728E+00, 1.9994232262E+00, 8.8853075581E-01],
	[2.6500000000E+04, 1.6450740063E+01, 4.8913835608E+00, 4.2597559847E+00, 2.0000643887E+00, 8.8858475386E-01],
	[2.6505000000E+04, 1.6455719499E+01, 4.8913473955E+00, 4.2623582941E+00, 2.0007054683E+00, 8.8863872600E-01],
	[2.6510000000E+04, 1.6460699503E+01, 4.8913112373E+00, 4.2649617013E+00, 2.0013464652E+00, 8.8869267224E-01],
	[2.6515000000E+04, 1.6465680075E+01, 4.8912750862E+00, 4.2675662067E+00, 2.0019873792E+00, 8.8874659259E-01],
	[2.6520000000E+04, 1.6470661214E+01, 4.8912389421E+00, 4.2701718103E+00, 2.0026282103E+00, 8.8880048707E-01],
	[2.6525000000E+04, 1.6475642920E+01, 4.8912028052E+00, 4.2727785125E+00, 2.0032689583E+00, 8.8885435567E-01],
	[2.6530000000E+04, 1.6480625194E+01, 4.8911666753E+00, 4.2753863136E+00, 2.0039096232E+00, 8.8890819842E-01],
	[2.6535000000E+04, 1.6485608035E+01, 4.8911305524E+00, 4.2779952137E+00, 2.0045502049E+00, 8.8896201533E-01],
	[2.6540000000E+04, 1.6490591443E+01, 4.8910944367E+00, 4.2806052132E+00, 2.0051907033E+00, 8.8901580640E-01],
	[2.6545000000E+04, 1.6495575419E+01, 4.8910583280E+00, 4.2832163123E+00, 2.0058311184E+00, 8.8906957165E-01],
	[2.6550000000E+04, 1.6500559962E+01, 4.8910222264E+00, 4.2858285113E+00, 2.0064714501E+00, 8.8912331108E-01],
	[2.6555000000E+04, 1.6505545072E+01, 4.8909861319E+00, 4.2884418103E+00, 2.0071116983E+00, 8.8917702471E-01],
	[2.6560000000E+04, 1.6510530749E+01, 4.8909500444E+00, 4.2910562098E+00, 2.0077518630E+00, 8.8923071255E-01],
	[2.6565000000E+04, 1.6515516993E+01, 4.8909139640E+00, 4.2936717099E+00, 2.0083919440E+00, 8.8928437460E-01],
	[2.6570000000E+04, 1.6520503804E+01, 4.8908778906E+00, 4.2962883108E+00, 2.0090319412E+00, 8.8933801088E-01],
	[2.6575000000E+04, 1.6525491182E+01, 4.8908418243E+00, 4.2989060129E+00, 2.0096718547E+00, 8.8939162141E-01],
	[2.6580000000E+04, 1.6530479127E+01, 4.8908057650E+00, 4.3015248164E+00, 2.0103116843E+00, 8.8944520618E-01],
	[2.6585000000E+04, 1.6535467639E+01, 4.8907697128E+00, 4.3041447215E+00, 2.0109514300E+00, 8.8949876521E-01],
	[2.6590000000E+04, 1.6540456718E+01, 4.8907336676E+00, 4.3067657285E+00, 2.0115910916E+00, 8.8955229851E-01],
	[2.6595000000E+04, 1.6545446364E+01, 4.8906976295E+00, 4.3093878377E+00, 2.0122306692E+00, 8.8960580610E-01],
	[2.6600000000E+04, 1.6550436576E+01, 4.8906615984E+00, 4.3120110493E+00, 2.0128701626E+00, 8.8965928798E-01],
	[2.6605000000E+04, 1.6555427355E+01, 4.8906255744E+00, 4.3146353636E+00, 2.0135095717E+00, 8.8971274416E-01],
	[2.6610000000E+04, 1.6560418701E+01, 4.8905895574E+00, 4.3172607808E+00, 2.0141488965E+00, 8.8976617465E-01],
	[2.6615000000E+04, 1.6565410614E+01, 4.8905535474E+00, 4.3198873012E+00, 2.0147881369E+00, 8.8981957947E-01],
	[2.6620000000E+04, 1.6570403093E+01, 4.8905175445E+00, 4.3225149250E+00, 2.0154272929E+00, 8.8987295863E-01],
	[2.6625000000E+04, 1.6575396139E+01, 4.8904815485E+00, 4.3251436525E+00, 2.0160663643E+00, 8.8992631213E-01],
	[2.6630000000E+04, 1.6580389751E+01, 4.8904455596E+00, 4.3277734840E+00, 2.0167053510E+00, 8.8997963998E-01],
	[2.6635000000E+04, 1.6585383930E+01, 4.8904095778E+00, 4.3304044196E+00, 2.0173442531E+00, 8.9003294221E-01],
	[2.6640000000E+04, 1.6590378675E+01, 4.8903736029E+00, 4.3330364598E+00, 2.0179830704E+00, 8.9008621881E-01],
	[2.6645000000E+04, 1.6595373986E+01, 4.8903376350E+00, 4.3356696046E+00, 2.0186218029E+00, 8.9013946980E-01],
	[2.6650000000E+04, 1.6600369864E+01, 4.8903016742E+00, 4.3383038545E+00, 2.0192604504E+00, 8.9019269518E-01],
	[2.6655000000E+04, 1.6605366308E+01, 4.8902657204E+00, 4.3409392095E+00, 2.0198990130E+00, 8.9024589498E-01],
	[2.6660000000E+04, 1.6610363319E+01, 4.8902297736E+00, 4.3435756700E+00, 2.0205374904E+00, 8.9029906920E-01],
	[2.6665000000E+04, 1.6615360896E+01, 4.8901938338E+00, 4.3462132363E+00, 2.0211758828E+00, 8.9035221785E-01],
	[2.6670000000E+04, 1.6620359038E+01, 4.8901579010E+00, 4.3488519086E+00, 2.0218141899E+00, 8.9040534094E-01],
	[2.6675000000E+04, 1.6625357747E+01, 4.8901219752E+00, 4.3514916871E+00, 2.0224524117E+00, 8.9045843848E-01],
	[2.6680000000E+04, 1.6630357023E+01, 4.8900860564E+00, 4.3541325722E+00, 2.0230905482E+00, 8.9051151049E-01],
	[2.6685000000E+04, 1.6635356864E+01, 4.8900501446E+00, 4.3567745640E+00, 2.0237285992E+00, 8.9056455697E-01],
	[2.6690000000E+04, 1.6640357271E+01, 4.8900142397E+00, 4.3594176628E+00, 2.0243665648E+00, 8.9061757793E-01],
	[2.6695000000E+04, 1.6645358244E+01, 4.8899783419E+00, 4.3620618689E+00, 2.0250044447E+00, 8.9067057339E-01],
	[2.6700000000E+04, 1.6650359783E+01, 4.8899424511E+00, 4.3647071825E+00, 2.0256422390E+00, 8.9072354336E-01],
	[2.6705000000E+04, 1.6655361888E+01, 4.8899065672E+00, 4.3673536039E+00, 2.0262799475E+00, 8.9077648784E-01],
	[2.6710000000E+04, 1.6660364559E+01, 4.8898706903E+00, 4.3700011334E+00, 2.0269175702E+00, 8.9082940685E-01],
	[2.6715000000E+04, 1.6665367796E+01, 4.8898348204E+00, 4.3726497711E+00, 2.0275551071E+00, 8.9088230040E-01],
	[2.6720000000E+04, 1.6670371598E+01, 4.8897989575E+00, 4.3752995174E+00, 2.0281925580E+00, 8.9093516849E-01],
	[2.6725000000E+04, 1.6675375967E+01, 4.8897631015E+00, 4.3779503726E+00, 2.0288299229E+00, 8.9098801115E-01],
	[2.6730000000E+04, 1.6680380900E+01, 4.8897272526E+00, 4.3806023368E+00, 2.0294672016E+00, 8.9104082838E-01],
	[2.6735000000E+04, 1.6685386400E+01, 4.8896914105E+00, 4.3832554103E+00, 2.0301043942E+00, 8.9109362018E-01],
	[2.6740000000E+04, 1.6690392465E+01, 4.8896555755E+00, 4.3859095934E+00, 2.0307415006E+00, 8.9114638658E-01],
	[2.6745000000E+04, 1.6695401850E+01, 4.8896201913E+00, 4.3885648863E+00, 2.0313786380E+00, 8.9119912758E-01],
	[2.6750000000E+04, 1.6700430053E+01, 4.8895877551E+00, 4.3912212893E+00, 2.0320164674E+00, 8.9125184319E-01],
	[2.6755000000E+04, 1.6705458831E+01, 4.8895553252E+00, 4.3938788027E+00, 2.0326542110E+00, 8.9130453343E-01],
	[2.6760000000E+04, 1.6710488183E+01, 4.8895229015E+00, 4.3965374267E+00, 2.0332918688E+00, 8.9135719830E-01],
	[2.6765000000E+04, 1.6715518109E+01, 4.8894904842E+00, 4.3991971615E+00, 2.0339294409E+00, 8.9140983782E-01],
	[2.6770000000E+04, 1.6720548609E+01, 4.8894580730E+00, 4.4018580075E+00, 2.0345669270E+00, 8.9146245199E-01],
	[2.6775000000E+04, 1.6725579683E+01, 4.8894256682E+00, 4.4045199648E+00, 2.0352043271E+00, 8.9151504083E-01],
	[2.6780000000E+04, 1.6730611331E+01, 4.8893932696E+00, 4.4071830338E+00, 2.0358416412E+00, 8.9156760435E-01],
	[2.6785000000E+04, 1.6735643552E+01, 4.8893608773E+00, 4.4098472146E+00, 2.0364788692E+00, 8.9162014256E-01],
	[2.6790000000E+04, 1.6740676348E+01, 4.8893284912E+00, 4.4125125076E+00, 2.0371160110E+00, 8.9167265546E-01],
	[2.6795000000E+04, 1.6745709718E+01, 4.8892961114E+00, 4.4151789130E+00, 2.0377530665E+00, 8.9172514308E-01],
	[2.6800000000E+04, 1.6750743661E+01, 4.8892637379E+00, 4.4178464310E+00, 2.0383900357E+00, 8.9177760541E-01],
	[2.6805000000E+04, 1.6755778178E+01, 4.8892313706E+00, 4.4205150620E+00, 2.0390269185E+00, 8.9183004248E-01],
	[2.6810000000E+04, 1.6760813269E+01, 4.8891990096E+00, 4.4231848061E+00, 2.0396637148E+00, 8.9188245428E-01],
	[2.6815000000E+04, 1.6765848933E+01, 4.8891666548E+00, 4.4258556636E+00, 2.0403004245E+00, 8.9193484085E-01],
	[2.6820000000E+04, 1.6770885172E+01, 4.8891343062E+00, 4.4285276348E+00, 2.0409370476E+00, 8.9198720217E-01],
	[2.6825000000E+04, 1.6775921983E+01, 4.8891019639E+00, 4.4312007199E+00, 2.0415735840E+00, 8.9203953827E-01],
	[2.6830000000E+04, 1.6780959369E+01, 4.8890696279E+00, 4.4338749193E+00, 2.0422100337E+00, 8.9209184915E-01],
	[2.6835000000E+04, 1.6785997327E+01, 4.8890372981E+00, 4.4365502330E+00, 2.0428463965E+00, 8.9214413483E-01],
	[2.6840000000E+04, 1.6791035860E+01, 4.8890049745E+00, 4.4392266615E+00, 2.0434826723E+00, 8.9219639532E-01],
	[2.6845000000E+04, 1.6796074965E+01, 4.8889726571E+00, 4.4419042050E+00, 2.0441188612E+00, 8.9224863062E-01],
	[2.6850000000E+04, 1.6801114644E+01, 4.8889403460E+00, 4.4445828636E+00, 2.0447549631E+00, 8.9230084076E-01],
	[2.6855000000E+04, 1.6806154897E+01, 4.8889080411E+00, 4.4472626377E+00, 2.0453909778E+00, 8.9235302573E-01],
	[2.6860000000E+04, 1.6811195722E+01, 4.8888757425E+00, 4.4499435276E+00, 2.0460269054E+00, 8.9240518555E-01],
	[2.6865000000E+04, 1.6816237121E+01, 4.8888434501E+00, 4.4526255334E+00, 2.0466627456E+00, 8.9245732023E-01],
	[2.6870000000E+04, 1.6821279093E+01, 4.8888111638E+00, 4.4553086555E+00, 2.0472984985E+00, 8.9250942978E-01],
	[2.6875000000E+04, 1.6826321638E+01, 4.8887788839E+00, 4.4579928941E+00, 2.0479341640E+00, 8.9256151422E-01],
	[2.6880000000E+04, 1.6831364757E+01, 4.8887466101E+00, 4.4606782494E+00, 2.0485697421E+00, 8.9261357355E-01],
	[2.6885000000E+04, 1.6836408448E+01, 4.8887143425E+00, 4.4633647218E+00, 2.0492052325E+00, 8.9266560778E-01],
	[2.6890000000E+04, 1.6841452713E+01, 4.8886820812E+00, 4.4660523114E+00, 2.0498406354E+00, 8.9271761693E-01],
	[2.6895000000E+04, 1.6846497551E+01, 4.8886498261E+00, 4.4687410185E+00, 2.0504759506E+00, 8.9276960100E-01],
	[2.6900000000E+04, 1.6851542961E+01, 4.8886175771E+00, 4.4714308434E+00, 2.0511111780E+00, 8.9282156001E-01],
	[2.6905000000E+04, 1.6856588944E+01, 4.8885853344E+00, 4.4741217863E+00, 2.0517463175E+00, 8.9287349396E-01],
	[2.6910000000E+04, 1.6861635501E+01, 4.8885530979E+00, 4.4768138476E+00, 2.0523813692E+00, 8.9292540288E-01],
	[2.6915000000E+04, 1.6866682630E+01, 4.8885208676E+00, 4.4795070274E+00, 2.0530163329E+00, 8.9297728676E-01],
	[2.6920000000E+04, 1.6871730332E+01, 4.8884886435E+00, 4.4822013259E+00, 2.0536512085E+00, 8.9302914562E-01],
	[2.6925000000E+04, 1.6876778607E+01, 4.8884564256E+00, 4.4848967436E+00, 2.0542859960E+00, 8.9308097947E-01],
	[2.6930000000E+04, 1.6881827454E+01, 4.8884242139E+00, 4.4875932806E+00, 2.0549206954E+00, 8.9313278832E-01],
	[2.6935000000E+04, 1.6886876874E+01, 4.8883920083E+00, 4.4902909371E+00, 2.0555553065E+00, 8.9318457219E-01],
	[2.6940000000E+04, 1.6891926867E+01, 4.8883598090E+00, 4.4929897135E+00, 2.0561898292E+00, 8.9323633107E-01],
	[2.6945000000E+04, 1.6896977432E+01, 4.8883276158E+00, 4.4956896099E+00, 2.0568242636E+00, 8.9328806499E-01],
	[2.6950000000E+04, 1.6902028570E+01, 4.8882954289E+00, 4.4983906267E+00, 2.0574586095E+00, 8.9333977394E-01],
	[2.6955000000E+04, 1.6907080281E+01, 4.8882632481E+00, 4.5010927641E+00, 2.0580928668E+00, 8.9339145794E-01],
	[2.6960000000E+04, 1.6912132564E+01, 4.8882310735E+00, 4.5037960224E+00, 2.0587270356E+00, 8.9344311699E-01],
	[2.6965000000E+04, 1.6917185419E+01, 4.8881989051E+00, 4.5065004017E+00, 2.0593611157E+00, 8.9349475111E-01],
	[2.6970000000E+04, 1.6922238847E+01, 4.8881667428E+00, 4.5092059025E+00, 2.0599951071E+00, 8.9354636030E-01],
	[2.6975000000E+04, 1.6927292847E+01, 4.8881345868E+00, 4.5119125248E+00, 2.0606290096E+00, 8.9359794457E-01],
	[2.6980000000E+04, 1.6932347419E+01, 4.8881024369E+00, 4.5146202691E+00, 2.0612628232E+00, 8.9364950394E-01],
	[2.6985000000E+04, 1.6937402563E+01, 4.8880702931E+00, 4.5173291354E+00, 2.0618965480E+00, 8.9370103841E-01],
	[2.6990000000E+04, 1.6942458280E+01, 4.8880381556E+00, 4.5200391242E+00, 2.0625301836E+00, 8.9375254798E-01],
	[2.6995000000E+04, 1.6947514569E+01, 4.8880060242E+00, 4.5227502356E+00, 2.0631637302E+00, 8.9380403268E-01],
	[2.7000000000E+04, 1.6952571430E+01, 4.8879738989E+00, 4.5254624700E+00, 2.0637971877E+00, 8.9385549251E-01],
	[2.7005000000E+04, 1.6957628864E+01, 4.8879417798E+00, 4.5281758275E+00, 2.0644305559E+00, 8.9390692747E-01],
	[2.7010000000E+04, 1.6962686869E+01, 4.8879096669E+00, 4.5308903084E+00, 2.0650638348E+00, 8.9395833758E-01],
	[2.7015000000E+04, 1.6967745446E+01, 4.8878775602E+00, 4.5336059130E+00, 2.0656970244E+00, 8.9400972285E-01],
	[2.7020000000E+04, 1.6972804595E+01, 4.8878454595E+00, 4.5363226415E+00, 2.0663301245E+00, 8.9406108328E-01],
	[2.7025000000E+04, 1.6977864317E+01, 4.8878133651E+00, 4.5390404943E+00, 2.0669631351E+00, 8.9411241889E-01],
	[2.7030000000E+04, 1.6982924610E+01, 4.8877812768E+00, 4.5417594715E+00, 2.0675960562E+00, 8.9416372968E-01],
	[2.7035000000E+04, 1.6987985475E+01, 4.8877491946E+00, 4.5444795733E+00, 2.0682288876E+00, 8.9421501566E-01],
	[2.7040000000E+04, 1.6993046911E+01, 4.8877171186E+00, 4.5472008002E+00, 2.0688616293E+00, 8.9426627684E-01],
	[2.7045000000E+04, 1.6998108920E+01, 4.8876850487E+00, 4.5499231522E+00, 2.0694942812E+00, 8.9431751324E-01],
	[2.7050000000E+04, 1.7003171500E+01, 4.8876529849E+00, 4.5526466298E+00, 2.0701268433E+00, 8.9436872485E-01],
	[2.7055000000E+04, 1.7008234652E+01, 4.8876209273E+00, 4.5553712331E+00, 2.0707593155E+00, 8.9441991170E-01],
	[2.7060000000E+04, 1.7013298376E+01, 4.8875888758E+00, 4.5580969623E+00, 2.0713916977E+00, 8.9447107378E-01],
	[2.7065000000E+04, 1.7018362671E+01, 4.8875568305E+00, 4.5608238178E+00, 2.0720239899E+00, 8.9452221112E-01],
	[2.7070000000E+04, 1.7023427538E+01, 4.8875247913E+00, 4.5635517998E+00, 2.0726561919E+00, 8.9457332371E-01],
	[2.7075000000E+04, 1.7028492976E+01, 4.8874927582E+00, 4.5662809086E+00, 2.0732883038E+00, 8.9462441156E-01],
	[2.7080000000E+04, 1.7033558986E+01, 4.8874607312E+00, 4.5690111444E+00, 2.0739203254E+00, 8.9467547469E-01],
	[2.7085000000E+04, 1.7038625567E+01, 4.8874287104E+00, 4.5717425074E+00, 2.0745522567E+00, 8.9472651311E-01],
	[2.7090000000E+04, 1.7043692719E+01, 4.8873966957E+00, 4.5744749980E+00, 2.0751840977E+00, 8.9477752682E-01],
	[2.7095000000E+04, 1.7048760443E+01, 4.8873646871E+00, 4.5772086164E+00, 2.0758158481E+00, 8.9482851584E-01],
	[2.7100000000E+04, 1.7053828738E+01, 4.8873326846E+00, 4.5799433628E+00, 2.0764475081E+00, 8.9487948017E-01],
	[2.7105000000E+04, 1.7058897605E+01, 4.8873006882E+00, 4.5826792375E+00, 2.0770790774E+00, 8.9493041982E-01],
	[2.7110000000E+04, 1.7063967043E+01, 4.8872686980E+00, 4.5854162408E+00, 2.0777105561E+00, 8.9498133480E-01],
	[2.7115000000E+04, 1.7069037052E+01, 4.8872367138E+00, 4.5881543729E+00, 2.0783419441E+00, 8.9503222512E-01],
	[2.7120000000E+04, 1.7074107632E+01, 4.8872047358E+00, 4.5908936340E+00, 2.0789732413E+00, 8.9508309079E-01],
	[2.7125000000E+04, 1.7079178783E+01, 4.8871727638E+00, 4.5936340245E+00, 2.0796044477E+00, 8.9513393182E-01],
	[2.7130000000E+04, 1.7084250505E+01, 4.8871407980E+00, 4.5963755445E+00, 2.0802355631E+00, 8.9518474822E-01],
	[2.7135000000E+04, 1.7089322799E+01, 4.8871088382E+00, 4.5991181945E+00, 2.0808665875E+00, 8.9523554000E-01],
	[2.7140000000E+04, 1.7094395663E+01, 4.8870768846E+00, 4.6018619745E+00, 2.0814975209E+00, 8.9528630717E-01],
	[2.7145000000E+04, 1.7099469098E+01, 4.8870449371E+00, 4.6046068848E+00, 2.0821283632E+00, 8.9533704973E-01],
	[2.7150000000E+04, 1.7104543104E+01, 4.8870129956E+00, 4.6073529258E+00, 2.0827591142E+00, 8.9538776770E-01],
	[2.7155000000E+04, 1.7109617681E+01, 4.8869810602E+00, 4.6101000976E+00, 2.0833897741E+00, 8.9543846108E-01],
	[2.7160000000E+04, 1.7114692829E+01, 4.8869491310E+00, 4.6128484006E+00, 2.0840203426E+00, 8.9548912989E-01],
	[2.7165000000E+04, 1.7119768548E+01, 4.8869172078E+00, 4.6155978349E+00, 2.0846508197E+00, 8.9553977413E-01],
	[2.7170000000E+04, 1.7124844837E+01, 4.8868852907E+00, 4.6183484009E+00, 2.0852812053E+00, 8.9559039382E-01],
	[2.7175000000E+04, 1.7129922149E+01, 4.8868534516E+00, 4.6211000988E+00, 2.0859115193E+00, 8.9564098895E-01],
	[2.7180000000E+04, 1.7135020492E+01, 4.8868248716E+00, 4.6238529288E+00, 2.0865426381E+00, 8.9569155955E-01],
	[2.7185000000E+04, 1.7140119414E+01, 4.8867962970E+00, 4.6266068913E+00, 2.0871736660E+00, 8.9574210563E-01],
	[2.7190000000E+04, 1.7145218916E+01, 4.8867677278E+00, 4.6293619864E+00, 2.0878046029E+00, 8.9579262718E-01],
	[2.7195000000E+04, 1.7150318996E+01, 4.8867391641E+00, 4.6321182144E+00, 2.0884354489E+00, 8.9584312422E-01],
	[2.7200000000E+04, 1.7155419655E+01, 4.8867106058E+00, 4.6348755757E+00, 2.0890662037E+00, 8.9589359676E-01],
	[2.7205000000E+04, 1.7160520894E+01, 4.8866820528E+00, 4.6376340703E+00, 2.0896968674E+00, 8.9594404482E-01],
	[2.7210000000E+04, 1.7165622711E+01, 4.8866535054E+00, 4.6403936987E+00, 2.0903274399E+00, 8.9599446839E-01],
	[2.7215000000E+04, 1.7170725108E+01, 4.8866249633E+00, 4.6431544610E+00, 2.0909579211E+00, 8.9604486748E-01],
	[2.7220000000E+04, 1.7175828083E+01, 4.8865964266E+00, 4.6459163575E+00, 2.0915883110E+00, 8.9609524212E-01],
	[2.7225000000E+04, 1.7180931637E+01, 4.8865678953E+00, 4.6486793885E+00, 2.0922186094E+00, 8.9614559230E-01],
	[2.7230000000E+04, 1.7186035770E+01, 4.8865393695E+00, 4.6514435542E+00, 2.0928488163E+00, 8.9619591804E-01],
	[2.7235000000E+04, 1.7191140482E+01, 4.8865108490E+00, 4.6542088549E+00, 2.0934789317E+00, 8.9624621934E-01],
	[2.7240000000E+04, 1.7196245773E+01, 4.8864823340E+00, 4.6569752908E+00, 2.0941089555E+00, 8.9629649622E-01],
	[2.7245000000E+04, 1.7201351642E+01, 4.8864538243E+00, 4.6597428622E+00, 2.0947388876E+00, 8.9634674869E-01],
	[2.7250000000E+04, 1.7206458090E+01, 4.8864253201E+00, 4.6625115694E+00, 2.0953687280E+00, 8.9639697674E-01],
	[2.7255000000E+04, 1.7211565116E+01, 4.8863968212E+00, 4.6652814126E+00, 2.0959984766E+00, 8.9644718040E-01],
	[2.7260000000E+04, 1.7216672721E+01, 4.8863683278E+00, 4.6680523920E+00, 2.0966281333E+00, 8.9649735968E-01],
	[2.7265000000E+04, 1.7221780905E+01, 4.8863398397E+00, 4.6708245080E+00, 2.0972576980E+00, 8.9654751457E-01],
	[2.7270000000E+04, 1.7226889667E+01, 4.8863113570E+00, 4.6735977608E+00, 2.0978871708E+00, 8.9659764510E-01],
	[2.7275000000E+04, 1.7231999008E+01, 4.8862828797E+00, 4.6763721506E+00, 2.0985165515E+00, 8.9664775127E-01],
	[2.7280000000E+04, 1.7237108927E+01, 4.8862544078E+00, 4.6791476777E+00, 2.0991458400E+00, 8.9669783309E-01],
	[2.7285000000E+04, 1.7242219424E+01, 4.8862259413E+00, 4.6819243423E+00, 2.0997750364E+00, 8.9674789057E-01],
	[2.7290000000E+04, 1.7247330500E+01, 4.8861974801E+00, 4.6847021448E+00, 2.1004041405E+00, 8.9679792372E-01],
	[2.7295000000E+04, 1.7252442154E+01, 4.8861690244E+00, 4.6874810853E+00, 2.1010331523E+00, 8.9684793255E-01],
	[2.7300000000E+04, 1.7257554386E+01, 4.8861405740E+00, 4.6902611641E+00, 2.1016620717E+00, 8.9689791707E-01],
	[2.7305000000E+04, 1.7262667197E+01, 4.8861121290E+00, 4.6930423815E+00, 2.1022908986E+00, 8.9694787728E-01],
	[2.7310000000E+04, 1.7267780586E+01, 4.8860836893E+00, 4.6958247378E+00, 2.1029196330E+00, 8.9699781320E-01],
	[2.7315000000E+04, 1.7272894552E+01, 4.8860552551E+00, 4.6986082332E+00, 2.1035482749E+00, 8.9704772485E-01],
	[2.7320000000E+04, 1.7278009097E+01, 4.8860268262E+00, 4.7013928679E+00, 2.1041768241E+00, 8.9709761221E-01],
	[2.7325000000E+04, 1.7283124220E+01, 4.8859984027E+00, 4.7041786422E+00, 2.1048052806E+00, 8.9714747532E-01],
	[2.7330000000E+04, 1.7288239921E+01, 4.8859699845E+00, 4.7069655564E+00, 2.1054336443E+00, 8.9719731417E-01],
	[2.7335000000E+04, 1.7293356200E+01, 4.8859415717E+00, 4.7097536107E+00, 2.1060619151E+00, 8.9724712877E-01],
	[2.7340000000E+04, 1.7298473057E+01, 4.8859131643E+00, 4.7125428055E+00, 2.1066900931E+00, 8.9729691914E-01],
	[2.7345000000E+04, 1.7303590492E+01, 4.8858847622E+00, 4.7153331408E+00, 2.1073181781E+00, 8.9734668529E-01],
	[2.7350000000E+04, 1.7308708505E+01, 4.8858563655E+00, 4.7181246170E+00, 2.1079461701E+00, 8.9739642722E-01],
	[2.7355000000E+04, 1.7313827095E+01, 4.8858279741E+00, 4.7209172344E+00, 2.1085740690E+00, 8.9744614494E-01],
	[2.7360000000E+04, 1.7318946263E+01, 4.8857995881E+00, 4.7237109933E+00, 2.1092018747E+00, 8.9749583847E-01],
	[2.7365000000E+04, 1.7324066009E+01, 4.8857712075E+00, 4.7265058937E+00, 2.1098295873E+00, 8.9754550781E-01],
	[2.7370000000E+04, 1.7329186333E+01, 4.8857428322E+00, 4.7293019361E+00, 2.1104572065E+00, 8.9759515297E-01],
	[2.7375000000E+04, 1.7334307234E+01, 4.8857144622E+00, 4.7320991207E+00, 2.1110847324E+00, 8.9764477396E-01],
	[2.7380000000E+04, 1.7339428713E+01, 4.8856860976E+00, 4.7348974478E+00, 2.1117121649E+00, 8.9769437079E-01],
	[2.7385000000E+04, 1.7344550770E+01, 4.8856577383E+00, 4.7376969175E+00, 2.1123395039E+00, 8.9774394348E-01],
	[2.7390000000E+04, 1.7349673404E+01, 4.8856293844E+00, 4.7404988356E+00, 2.1129670088E+00, 8.9779349203E-01],
	[2.7395000000E+04, 1.7354796615E+01, 4.8856010358E+00, 4.7433022668E+00, 2.1135944931E+00, 8.9784301644E-01],
	[2.7400000000E+04, 1.7359920404E+01, 4.8855726926E+00, 4.7461068431E+00, 2.1142218838E+00, 8.9789251674E-01],
	[2.7405000000E+04, 1.7365044770E+01, 4.8855443547E+00, 4.7489125650E+00, 2.1148491807E+00, 8.9794199293E-01],
	[2.7410000000E+04, 1.7370169714E+01, 4.8855160221E+00, 4.7517194326E+00, 2.1154763837E+00, 8.9799144501E-01],
	[2.7415000000E+04, 1.7375295235E+01, 4.8854876948E+00, 4.7545274462E+00, 2.1161034929E+00, 8.9804087301E-01],
	[2.7420000000E+04, 1.7380421334E+01, 4.8854593729E+00, 4.7573366061E+00, 2.1167305082E+00, 8.9809027692E-01],
	[2.7425000000E+04, 1.7385548009E+01, 4.8854310563E+00, 4.7601469126E+00, 2.1173574294E+00, 8.9813965676E-01],
	[2.7430000000E+04, 1.7390675262E+01, 4.8854027451E+00, 4.7629583658E+00, 2.1179842565E+00, 8.9818901254E-01],
	[2.7435000000E+04, 1.7395803092E+01, 4.8853744391E+00, 4.7657709661E+00, 2.1186109895E+00, 8.9823834426E-01],
	[2.7440000000E+04, 1.7400931499E+01, 4.8853461385E+00, 4.7685847137E+00, 2.1192376283E+00, 8.9828765195E-01],
	[2.7445000000E+04, 1.7406060483E+01, 4.8853178432E+00, 4.7713996088E+00, 2.1198641729E+00, 8.9833693560E-01],
	[2.7450000000E+04, 1.7411190044E+01, 4.8852895533E+00, 4.7742156518E+00, 2.1204906231E+00, 8.9838619522E-01],
	[2.7455000000E+04, 1.7416320183E+01, 4.8852612686E+00, 4.7770328428E+00, 2.1211169790E+00, 8.9843543083E-01],
	[2.7460000000E+04, 1.7421450898E+01, 4.8852329893E+00, 4.7798511822E+00, 2.1217432403E+00, 8.9848464244E-01],
	[2.7465000000E+04, 1.7426582190E+01, 4.8852047152E+00, 4.7826706702E+00, 2.1223694072E+00, 8.9853383005E-01],
	[2.7470000000E+04, 1.7431714059E+01, 4.8851764465E+00, 4.7854913071E+00, 2.1229954795E+00, 8.9858299368E-01],
	[2.7475000000E+04, 1.7436846505E+01, 4.8851481831E+00, 4.7883130930E+00, 2.1236214572E+00, 8.9863213333E-01],
	[2.7480000000E+04, 1.7441979528E+01, 4.8851199250E+00, 4.7911360284E+00, 2.1242473402E+00, 8.9868124902E-01],
	[2.7485000000E+04, 1.7447113127E+01, 4.8850916722E+00, 4.7939601134E+00, 2.1248731284E+00, 8.9873034075E-01],
	[2.7490000000E+04, 1.7452247303E+01, 4.8850634247E+00, 4.7967853482E+00, 2.1254988218E+00, 8.9877940853E-01],
	[2.7495000000E+04, 1.7457382056E+01, 4.8850351825E+00, 4.7996117333E+00, 2.1261244203E+00, 8.9882845238E-01],
	[2.7500000000E+04, 1.7462517385E+01, 4.8850069456E+00, 4.8024392687E+00, 2.1267499239E+00, 8.9887747230E-01],
	[2.7505000000E+04, 1.7467653292E+01, 4.8849787140E+00, 4.8052679548E+00, 2.1273753324E+00, 8.9892646830E-01],
	[2.7510000000E+04, 1.7472789774E+01, 4.8849504877E+00, 4.8080977918E+00, 2.1280006460E+00, 8.9897544040E-01],
	[2.7515000000E+04, 1.7477926833E+01, 4.8849222667E+00, 4.8109287800E+00, 2.1286258643E+00, 8.9902438860E-01],
	[2.7520000000E+04, 1.7483064469E+01, 4.8848940509E+00, 4.8137609197E+00, 2.1292509875E+00, 8.9907331291E-01],
	[2.7525000000E+04, 1.7488202681E+01, 4.8848658405E+00, 4.8165942110E+00, 2.1298760155E+00, 8.9912221334E-01],
	[2.7530000000E+04, 1.7493341470E+01, 4.8848376353E+00, 4.8194286544E+00, 2.1305009481E+00, 8.9917108990E-01],
	[2.7535000000E+04, 1.7498480834E+01, 4.8848094355E+00, 4.8222642499E+00, 2.1311257854E+00, 8.9921994260E-01],
	[2.7540000000E+04, 1.7503620776E+01, 4.8847812409E+00, 4.8251009979E+00, 2.1317505272E+00, 8.9926877146E-01],
	[2.7545000000E+04, 1.7508761293E+01, 4.8847530516E+00, 4.8279388987E+00, 2.1323751736E+00, 8.9931757647E-01],
	[2.7550000000E+04, 1.7513902387E+01, 4.8847248676E+00, 4.8307779524E+00, 2.1329997244E+00, 8.9936635766E-01],
	[2.7555000000E+04, 1.7519044057E+01, 4.8846966888E+00, 4.8336181594E+00, 2.1336241796E+00, 8.9941511502E-01],
	[2.7560000000E+04, 1.7524186303E+01, 4.8846685154E+00, 4.8364595199E+00, 2.1342485391E+00, 8.9946384858E-01],
	[2.7565000000E+04, 1.7529329125E+01, 4.8846403472E+00, 4.8393020342E+00, 2.1348728029E+00, 8.9951255833E-01],
	[2.7570000000E+04, 1.7534472523E+01, 4.8846121842E+00, 4.8421457026E+00, 2.1354969709E+00, 8.9956124430E-01],
	[2.7575000000E+04, 1.7539616498E+01, 4.8845840266E+00, 4.8449905252E+00, 2.1361210430E+00, 8.9960990648E-01],
	[2.7580000000E+04, 1.7544761048E+01, 4.8845558742E+00, 4.8478365023E+00, 2.1367450192E+00, 8.9965854489E-01],
	[2.7585000000E+04, 1.7549906174E+01, 4.8845277271E+00, 4.8506836343E+00, 2.1373688995E+00, 8.9970715954E-01],
	[2.7590000000E+04, 1.7555051877E+01, 4.8844995852E+00, 4.8535319213E+00, 2.1379926837E+00, 8.9975575044E-01],
	[2.7595000000E+04, 1.7560198155E+01, 4.8844714486E+00, 4.8563813637E+00, 2.1386163718E+00, 8.9980431760E-01],
	[2.7600000000E+04, 1.7565345009E+01, 4.8844433173E+00, 4.8592319616E+00, 2.1392399638E+00, 8.9985286102E-01],
	[2.7605000000E+04, 1.7570492438E+01, 4.8844151912E+00, 4.8620837154E+00, 2.1398634595E+00, 8.9990138072E-01],
	[2.7610000000E+04, 1.7575640444E+01, 4.8843870704E+00, 4.8649366253E+00, 2.1404868590E+00, 8.9994987671E-01],
	[2.7615000000E+04, 1.7580799971E+01, 4.8843606725E+00, 4.8677906915E+00, 2.1411106546E+00, 8.9999834900E-01],
	[2.7620000000E+04, 1.7585969949E+01, 4.8843358280E+00, 4.8706459144E+00, 2.1417347983E+00, 9.0004679759E-01],
	[2.7625000000E+04, 1.7591140510E+01, 4.8843109881E+00, 4.8735022941E+00, 2.1423588463E+00, 9.0009522251E-01],
	[2.7630000000E+04, 1.7596311656E+01, 4.8842861529E+00, 4.8763598310E+00, 2.1429827985E+00, 9.0014362374E-01],
	[2.7635000000E+04, 1.7601483386E+01, 4.8842613222E+00, 4.8792185253E+00, 2.1436066549E+00, 9.0019200132E-01],
	[2.7640000000E+04, 1.7606655700E+01, 4.8842364962E+00, 4.8820783772E+00, 2.1442304154E+00, 9.0024035524E-01],
	[2.7645000000E+04, 1.7611828597E+01, 4.8842116748E+00, 4.8849393871E+00, 2.1448540800E+00, 9.0028868551E-01],
	[2.7650000000E+04, 1.7617002079E+01, 4.8841868580E+00, 4.8878015551E+00, 2.1454776486E+00, 9.0033699216E-01],
	[2.7655000000E+04, 1.7622176144E+01, 4.8841620459E+00, 4.8906648815E+00, 2.1461011211E+00, 9.0038527517E-01],
	[2.7660000000E+04, 1.7627350793E+01, 4.8841372383E+00, 4.8935293667E+00, 2.1467244975E+00, 9.0043353458E-01],
	[2.7665000000E+04, 1.7632526026E+01, 4.8841124354E+00, 4.8963950107E+00, 2.1473477777E+00, 9.0048177038E-01],
	[2.7670000000E+04, 1.7637701843E+01, 4.8840876370E+00, 4.8992618140E+00, 2.1479709617E+00, 9.0052998258E-01],
	[2.7675000000E+04, 1.7642878244E+01, 4.8840628433E+00, 4.9021297768E+00, 2.1485940493E+00, 9.0057817120E-01],
	[2.7680000000E+04, 1.7648055228E+01, 4.8840380542E+00, 4.9049988993E+00, 2.1492170407E+00, 9.0062633624E-01],
	[2.7685000000E+04, 1.7653232795E+01, 4.8840132697E+00, 4.9078691817E+00, 2.1498399356E+00, 9.0067447772E-01],
	[2.7690000000E+04, 1.7658410947E+01, 4.8839884897E+00, 4.9107406245E+00, 2.1504627340E+00, 9.0072259565E-01],
	[2.7695000000E+04, 1.7663589681E+01, 4.8839637144E+00, 4.9136132277E+00, 2.1510854359E+00, 9.0077069003E-01],
	[2.7700000000E+04, 1.7668769000E+01, 4.8839389437E+00, 4.9164869917E+00, 2.1517080413E+00, 9.0081876087E-01],
	[2.7705000000E+04, 1.7673948901E+01, 4.8839141776E+00, 4.9193619166E+00, 2.1523305499E+00, 9.0086680818E-01],
	[2.7710000000E+04, 1.7679129387E+01, 4.8838894160E+00, 4.9222380029E+00, 2.1529529619E+00, 9.0091483199E-01],
	[2.7715000000E+04, 1.7684310455E+01, 4.8838646591E+00, 4.9251152507E+00, 2.1535752771E+00, 9.0096283228E-01],
	[2.7720000000E+04, 1.7689492107E+01, 4.8838399067E+00, 4.9279936604E+00, 2.1541974955E+00, 9.0101080908E-01],
	[2.7725000000E+04, 1.7694674342E+01, 4.8838151590E+00, 4.9308732320E+00, 2.1548196170E+00, 9.0105876239E-01],
	[2.7730000000E+04, 1.7699857161E+01, 4.8837904158E+00, 4.9337539660E+00, 2.1554416415E+00, 9.0110669223E-01],
	[2.7735000000E+04, 1.7705040563E+01, 4.8837656772E+00, 4.9366358626E+00, 2.1560635691E+00, 9.0115459859E-01],
	[2.7740000000E+04, 1.7710224547E+01, 4.8837409432E+00, 4.9395189220E+00, 2.1566853996E+00, 9.0120248151E-01],
	[2.7745000000E+04, 1.7715409115E+01, 4.8837162138E+00, 4.9424031445E+00, 2.1573071330E+00, 9.0125034097E-01],
	[2.7750000000E+04, 1.7720594267E+01, 4.8836914890E+00, 4.9452885303E+00, 2.1579287692E+00, 9.0129817700E-01],
	[2.7755000000E+04, 1.7725780001E+01, 4.8836667687E+00, 4.9481750798E+00, 2.1585503082E+00, 9.0134598960E-01],
	[2.7760000000E+04, 1.7730966318E+01, 4.8836420530E+00, 4.9510627931E+00, 2.1591717499E+00, 9.0139377878E-01],
	[2.7765000000E+04, 1.7736153218E+01, 4.8836173419E+00, 4.9539516706E+00, 2.1597930943E+00, 9.0144154456E-01],
	[2.7770000000E+04, 1.7741340701E+01, 4.8835926354E+00, 4.9568417124E+00, 2.1604143412E+00, 9.0148928694E-01],
	[2.7775000000E+04, 1.7746528767E+01, 4.8835679335E+00, 4.9597329189E+00, 2.1610354907E+00, 9.0153700593E-01],
	[2.7780000000E+04, 1.7751717416E+01, 4.8835432361E+00, 4.9626252903E+00, 2.1616565427E+00, 9.0158470155E-01],
	[2.7785000000E+04, 1.7756906648E+01, 4.8835185433E+00, 4.9655188269E+00, 2.1622774971E+00, 9.0163237379E-01],
	[2.7790000000E+04, 1.7762096462E+01, 4.8834938550E+00, 4.9684135289E+00, 2.1628983539E+00, 9.0168002268E-01],
	[2.7795000000E+04, 1.7767286860E+01, 4.8834691713E+00, 4.9713093966E+00, 2.1635191130E+00, 9.0172764822E-01],
	[2.7800000000E+04, 1.7772477840E+01, 4.8834444922E+00, 4.9742064302E+00, 2.1641397744E+00, 9.0177525043E-01],
	[2.7805000000E+04, 1.7777669402E+01, 4.8834198177E+00, 4.9771046301E+00, 2.1647603379E+00, 9.0182282930E-01],
	[2.7810000000E+04, 1.7782861548E+01, 4.8833951477E+00, 4.9800039964E+00, 2.1653808036E+00, 9.0187038486E-01],
	[2.7815000000E+04, 1.7788054275E+01, 4.8833704823E+00, 4.9829045294E+00, 2.1660011714E+00, 9.0191791711E-01],
	[2.7820000000E+04, 1.7793247586E+01, 4.8833458214E+00, 4.9858062294E+00, 2.1666214412E+00, 9.0196542606E-01],
	[2.7825000000E+04, 1.7798441479E+01, 4.8833211651E+00, 4.9887090966E+00, 2.1672416130E+00, 9.0201291172E-01],
	[2.7830000000E+04, 1.7803635954E+01, 4.8832965133E+00, 4.9916131314E+00, 2.1678616867E+00, 9.0206037411E-01],
	[2.7835000000E+04, 1.7808831012E+01, 4.8832718661E+00, 4.9945183339E+00, 2.1684816623E+00, 9.0210781322E-01],
	[2.7840000000E+04, 1.7814026652E+01, 4.8832472234E+00, 4.9974247044E+00, 2.1691015397E+00, 9.0215522908E-01],
	[2.7845000000E+04, 1.7819222875E+01, 4.8832225853E+00, 5.0003322432E+00, 2.1697213188E+00, 9.0220262169E-01],
	[2.7850000000E+04, 1.7824419680E+01, 4.8831979518E+00, 5.0032409505E+00, 2.1703409996E+00, 9.0224999106E-01],
	[2.7855000000E+04, 1.7829617067E+01, 4.8831733228E+00, 5.0061508267E+00, 2.1709605820E+00, 9.0229733720E-01],
	[2.7860000000E+04, 1.7834815036E+01, 4.8831486983E+00, 5.0090618719E+00, 2.1715800660E+00, 9.0234466013E-01],
	[2.7865000000E+04, 1.7840013588E+01, 4.8831240784E+00, 5.0119740864E+00, 2.1721994516E+00, 9.0239195984E-01],
	[2.7870000000E+04, 1.7845212721E+01, 4.8830994630E+00, 5.0148874705E+00, 2.1728187386E+00, 9.0243923636E-01],
	[2.7875000000E+04, 1.7850412437E+01, 4.8830748521E+00, 5.0178020244E+00, 2.1734379270E+00, 9.0248648969E-01],
	[2.7880000000E+04, 1.7855612735E+01, 4.8830502458E+00, 5.0207177484E+00, 2.1740570168E+00, 9.0253371984E-01],
	[2.7885000000E+04, 1.7860813615E+01, 4.8830256441E+00, 5.0236346428E+00, 2.1746760078E+00, 9.0258092682E-01],
	[2.7890000000E+04, 1.7866015077E+01, 4.8830010468E+00, 5.0265527077E+00, 2.1752949001E+00, 9.0262811064E-01],
	[2.7895000000E+04, 1.7871217121E+01, 4.8829764541E+00, 5.0294719436E+00, 2.1759136936E+00, 9.0267527131E-01],
	[2.7900000000E+04, 1.7876419747E+01, 4.8829518660E+00, 5.0323923506E+00, 2.1765323883E+00, 9.0272240884E-01],
	[2.7905000000E+04, 1.7881622955E+01, 4.8829272823E+00, 5.0353139290E+00, 2.1771509840E+00, 9.0276952325E-01],
	[2.7910000000E+04, 1.7886826744E+01, 4.8829027032E+00, 5.0382366790E+00, 2.1777694807E+00, 9.0281661453E-01],
	[2.7915000000E+04, 1.7892031116E+01, 4.8828781286E+00, 5.0411606009E+00, 2.1783878784E+00, 9.0286368271E-01],
	[2.7920000000E+04, 1.7897236069E+01, 4.8828535586E+00, 5.0440856950E+00, 2.1790061770E+00, 9.0291072779E-01],
	[2.7925000000E+04, 1.7902441604E+01, 4.8828289930E+00, 5.0470119616E+00, 2.1796243765E+00, 9.0295774978E-01],
	[2.7930000000E+04, 1.7907647720E+01, 4.8828044320E+00, 5.0499394008E+00, 2.1802424767E+00, 9.0300474869E-01],
	[2.7935000000E+04, 1.7912854418E+01, 4.8827798755E+00, 5.0528680130E+00, 2.1808604778E+00, 9.0305172453E-01],
	[2.7940000000E+04, 1.7918061698E+01, 4.8827553236E+00, 5.0557977983E+00, 2.1814783795E+00, 9.0309867731E-01],
	[2.7945000000E+04, 1.7923269560E+01, 4.8827307761E+00, 5.0587287572E+00, 2.1820961818E+00, 9.0314560705E-01],
	[2.7950000000E+04, 1.7928478003E+01, 4.8827062332E+00, 5.0616608898E+00, 2.1827138847E+00, 9.0319251374E-01],
	[2.7955000000E+04, 1.7933687027E+01, 4.8826816947E+00, 5.0645941963E+00, 2.1833314882E+00, 9.0323939741E-01],
	[2.7960000000E+04, 1.7938896633E+01, 4.8826571608E+00, 5.0675286771E+00, 2.1839489921E+00, 9.0328625805E-01],
	[2.7965000000E+04, 1.7944106820E+01, 4.8826326314E+00, 5.0704643325E+00, 2.1845663964E+00, 9.0333309569E-01],
	[2.7970000000E+04, 1.7949317589E+01, 4.8826081065E+00, 5.0734011625E+00, 2.1851837011E+00, 9.0337991033E-01],
	[2.7975000000E+04, 1.7954528939E+01, 4.8825835861E+00, 5.0763391676E+00, 2.1858009061E+00, 9.0342670198E-01],
	[2.7980000000E+04, 1.7959740870E+01, 4.8825590702E+00, 5.0792783480E+00, 2.1864180114E+00, 9.0347347065E-01],
	[2.7985000000E+04, 1.7964953382E+01, 4.8825345588E+00, 5.0822187040E+00, 2.1870350168E+00, 9.0352021635E-01],
	[2.7990000000E+04, 1.7970166476E+01, 4.8825100519E+00, 5.0851602357E+00, 2.1876519225E+00, 9.0356693910E-01],
	[2.7995000000E+04, 1.7975380151E+01, 4.8824855496E+00, 5.0881029435E+00, 2.1882687282E+00, 9.0361363889E-01],
	[2.8000000000E+04, 1.7980594407E+01, 4.8824610517E+00, 5.0910468276E+00, 2.1888854339E+00, 9.0366031575E-01],
	[2.8005000000E+04, 1.7985809244E+01, 4.8824365583E+00, 5.0939918884E+00, 2.1895020396E+00, 9.0370696968E-01],
	[2.8010000000E+04, 1.7991024663E+01, 4.8824120694E+00, 5.0969381259E+00, 2.1901185453E+00, 9.0375360069E-01],
	[2.8015000000E+04, 1.7996240662E+01, 4.8823875850E+00, 5.0998855406E+00, 2.1907349508E+00, 9.0380020879E-01],
	[2.8020000000E+04, 1.8001457242E+01, 4.8823631051E+00, 5.1028341326E+00, 2.1913512562E+00, 9.0384679399E-01],
	[2.8025000000E+04, 1.8006674403E+01, 4.8823386297E+00, 5.1057839022E+00, 2.1919674613E+00, 9.0389335630E-01],
	[2.8030000000E+04, 1.8011892145E+01, 4.8823141588E+00, 5.1087348497E+00, 2.1925835661E+00, 9.0393989574E-01],
	[2.8035000000E+04, 1.8017110468E+01, 4.8822896923E+00, 5.1116869754E+00, 2.1931995706E+00, 9.0398641230E-01],
	[2.8040000000E+04, 1.8022329372E+01, 4.8822652304E+00, 5.1146402795E+00, 2.1938154747E+00, 9.0403290601E-01],
	[2.8045000000E+04, 1.8027548857E+01, 4.8822407729E+00, 5.1175947622E+00, 2.1944312784E+00, 9.0407937687E-01],
	[2.8050000000E+04, 1.8032768922E+01, 4.8822163199E+00, 5.1205504238E+00, 2.1950469815E+00, 9.0412582489E-01],
	[2.8055000000E+04, 1.8037989568E+01, 4.8821918714E+00, 5.1235072647E+00, 2.1956625842E+00, 9.0417225009E-01],
	[2.8060000000E+04, 1.8043223672E+01, 4.8821694218E+00, 5.1264652849E+00, 2.1962786806E+00, 9.0421865246E-01],
	[2.8065000000E+04, 1.8048466203E+01, 4.8821481904E+00, 5.1294244849E+00, 2.1968950388E+00, 9.0426503203E-01],
	[2.8070000000E+04, 1.8053709323E+01, 4.8821269630E+00, 5.1323848648E+00, 2.1975112971E+00, 9.0431138880E-01],
	[2.8075000000E+04, 1.8058953032E+01, 4.8821057394E+00, 5.1353464250E+00, 2.1981274553E+00, 9.0435772278E-01],
	[2.8080000000E+04, 1.8064197329E+01, 4.8820845196E+00, 5.1383091656E+00, 2.1987435135E+00, 9.0440403398E-01],
	[2.8085000000E+04, 1.8069442216E+01, 4.8820633038E+00, 5.1412730870E+00, 2.1993594715E+00, 9.0445032241E-01],
	[2.8090000000E+04, 1.8074687691E+01, 4.8820420918E+00, 5.1442381893E+00, 2.1999753293E+00, 9.0449658809E-01],
	[2.8095000000E+04, 1.8079933755E+01, 4.8820208837E+00, 5.1472044730E+00, 2.2005910868E+00, 9.0454283102E-01],
	[2.8100000000E+04, 1.8085180408E+01, 4.8819996794E+00, 5.1501719381E+00, 2.2012067441E+00, 9.0458905121E-01],
	[2.8105000000E+04, 1.8090427649E+01, 4.8819784790E+00, 5.1531405850E+00, 2.2018223010E+00, 9.0463524868E-01],
	[2.8110000000E+04, 1.8095675479E+01, 4.8819572825E+00, 5.1561104140E+00, 2.2024377575E+00, 9.0468142342E-01],
	[2.8115000000E+04, 1.8100923898E+01, 4.8819360898E+00, 5.1590814252E+00, 2.2030531136E+00, 9.0472757546E-01],
	[2.8120000000E+04, 1.8106172905E+01, 4.8819149010E+00, 5.1620536191E+00, 2.2036683692E+00, 9.0477370480E-01],
	[2.8125000000E+04, 1.8111422500E+01, 4.8818937161E+00, 5.1650269957E+00, 2.2042835242E+00, 9.0481981146E-01],
	[2.8130000000E+04, 1.8116672684E+01, 4.8818725350E+00, 5.1680015554E+00, 2.2048985785E+00, 9.0486589543E-01],
	[2.8135000000E+04, 1.8121923457E+01, 4.8818513577E+00, 5.1709772985E+00, 2.2055135323E+00, 9.0491195674E-01],
	[2.8140000000E+04, 1.8127174817E+01, 4.8818301844E+00, 5.1739542251E+00, 2.2061283853E+00, 9.0495799540E-01],
	[2.8145000000E+04, 1.8132426766E+01, 4.8818090148E+00, 5.1769323357E+00, 2.2067431375E+00, 9.0500401140E-01],
	[2.8150000000E+04, 1.8137679304E+01, 4.8817878492E+00, 5.1799116303E+00, 2.2073577889E+00, 9.0505000477E-01],
	[2.8155000000E+04, 1.8142932429E+01, 4.8817666873E+00, 5.1828921093E+00, 2.2079723394E+00, 9.0509597551E-01],
	[2.8160000000E+04, 1.8148186143E+01, 4.8817455294E+00, 5.1858737730E+00, 2.2085867890E+00, 9.0514192364E-01],
	[2.8165000000E+04, 1.8153440445E+01, 4.8817243752E+00, 5.1888566215E+00, 2.2092011377E+00, 9.0518784916E-01],
	[2.8170000000E+04, 1.8158695336E+01, 4.8817032250E+00, 5.1918406552E+00, 2.2098153853E+00, 9.0523375208E-01],
	[2.8175000000E+04, 1.8163950814E+01, 4.8816820785E+00, 5.1948258743E+00, 2.2104295318E+00, 9.0527963242E-01],
	[2.8180000000E+04, 1.8169206880E+01, 4.8816609359E+00, 5.1978122791E+00, 2.2110435772E+00, 9.0532549018E-01],
	[2.8185000000E+04, 1.8174463535E+01, 4.8816397972E+00, 5.2007998699E+00, 2.2116575214E+00, 9.0537132537E-01],
	[2.8190000000E+04, 1.8179720777E+01, 4.8816186623E+00, 5.2037886468E+00, 2.2122713644E+00, 9.0541713801E-01],
	[2.8195000000E+04, 1.8184978607E+01, 4.8815975312E+00, 5.2067786102E+00, 2.2128851061E+00, 9.0546292810E-01],
	[2.8200000000E+04, 1.8190237026E+01, 4.8815764040E+00, 5.2097697604E+00, 2.2134987465E+00, 9.0550869566E-01],
	[2.8205000000E+04, 1.8195496032E+01, 4.8815552806E+00, 5.2127620975E+00, 2.2141122855E+00, 9.0555444069E-01],
	[2.8210000000E+04, 1.8200755626E+01, 4.8815341611E+00, 5.2157556218E+00, 2.2147257230E+00, 9.0560016321E-01],
	[2.8215000000E+04, 1.8206015808E+01, 4.8815130453E+00, 5.2187503336E+00, 2.2153390590E+00, 9.0564586322E-01],
	[2.8220000000E+04, 1.8211276577E+01, 4.8814919335E+00, 5.2217462333E+00, 2.2159522935E+00, 9.0569154073E-01],
	[2.8225000000E+04, 1.8216537934E+01, 4.8814708254E+00, 5.2247433209E+00, 2.2165654265E+00, 9.0573719576E-01],
	[2.8230000000E+04, 1.8221799879E+01, 4.8814497212E+00, 5.2277415968E+00, 2.2171784577E+00, 9.0578282831E-01],
	[2.8235000000E+04, 1.8227062412E+01, 4.8814286208E+00, 5.2307410612E+00, 2.2177913873E+00, 9.0582843840E-01],
	[2.8240000000E+04, 1.8232325532E+01, 4.8814075242E+00, 5.2337417145E+00, 2.2184042151E+00, 9.0587402603E-01],
	[2.8245000000E+04, 1.8237589240E+01, 4.8813864315E+00, 5.2367435568E+00, 2.2190169412E+00, 9.0591959122E-01],
	[2.8250000000E+04, 1.8242853535E+01, 4.8813653425E+00, 5.2397465884E+00, 2.2196295654E+00, 9.0596513398E-01],
	[2.8255000000E+04, 1.8248118418E+01, 4.8813442575E+00, 5.2427508096E+00, 2.2202420877E+00, 9.0601065431E-01],
	[2.8260000000E+04, 1.8253383888E+01, 4.8813231762E+00, 5.2457562206E+00, 2.2208545080E+00, 9.0605615222E-01],
	[2.8265000000E+04, 1.8258649946E+01, 4.8813020987E+00, 5.2487628218E+00, 2.2214668264E+00, 9.0610162773E-01],
	[2.8270000000E+04, 1.8263916591E+01, 4.8812810251E+00, 5.2517706133E+00, 2.2220790427E+00, 9.0614708085E-01],
	[2.8275000000E+04, 1.8269183823E+01, 4.8812599553E+00, 5.2547795954E+00, 2.2226911569E+00, 9.0619251158E-01],
	[2.8280000000E+04, 1.8274451642E+01, 4.8812388893E+00, 5.2577897685E+00, 2.2233031689E+00, 9.0623791994E-01],
	[2.8285000000E+04, 1.8279720049E+01, 4.8812178271E+00, 5.2608011326E+00, 2.2239150788E+00, 9.0628330594E-01],
	[2.8290000000E+04, 1.8284989043E+01, 4.8811967687E+00, 5.2638136882E+00, 2.2245268864E+00, 9.0632866958E-01],
	[2.8295000000E+04, 1.8290258625E+01, 4.8811757142E+00, 5.2668274354E+00, 2.2251385918E+00, 9.0637401088E-01],
	[2.8300000000E+04, 1.8295528793E+01, 4.8811546634E+00, 5.2698423746E+00, 2.2257501947E+00, 9.0641932984E-01],
	[2.8305000000E+04, 1.8300799549E+01, 4.8811336165E+00, 5.2728585059E+00, 2.2263616953E+00, 9.0646462648E-01],
	[2.8310000000E+04, 1.8306070891E+01, 4.8811125734E+00, 5.2758758297E+00, 2.2269730934E+00, 9.0650990081E-01],
	[2.8315000000E+04, 1.8311342821E+01, 4.8810915340E+00, 5.2788943461E+00, 2.2275843891E+00, 9.0655515284E-01],
	[2.8320000000E+04, 1.8316615337E+01, 4.8810704985E+00, 5.2819140556E+00, 2.2281955822E+00, 9.0660038257E-01],
	[2.8325000000E+04, 1.8321888441E+01, 4.8810494668E+00, 5.2849349583E+00, 2.2288066727E+00, 9.0664559002E-01],
	[2.8330000000E+04, 1.8327162131E+01, 4.8810284389E+00, 5.2879570544E+00, 2.2294176605E+00, 9.0669077520E-01],
	[2.8335000000E+04, 1.8332436409E+01, 4.8810074148E+00, 5.2909803443E+00, 2.2300285457E+00, 9.0673593811E-01],
	[2.8340000000E+04, 1.8337711273E+01, 4.8809863945E+00, 5.2940048282E+00, 2.2306393281E+00, 9.0678107878E-01],
	[2.8345000000E+04, 1.8342986724E+01, 4.8809653780E+00, 5.2970305064E+00, 2.2312500077E+00, 9.0682619720E-01],
	[2.8350000000E+04, 1.8348262762E+01, 4.8809443653E+00, 5.3000573791E+00, 2.2318605845E+00, 9.0687129339E-01],
	[2.8355000000E+04, 1.8353539386E+01, 4.8809233564E+00, 5.3030854466E+00, 2.2324710584E+00, 9.0691636736E-01],
	[2.8360000000E+04, 1.8358816597E+01, 4.8809023512E+00, 5.3061147092E+00, 2.2330814294E+00, 9.0696141911E-01],
	[2.8365000000E+04, 1.8364094395E+01, 4.8808813499E+00, 5.3091451670E+00, 2.2336916973E+00, 9.0700644867E-01],
	[2.8370000000E+04, 1.8369372780E+01, 4.8808603524E+00, 5.3121768204E+00, 2.2343018623E+00, 9.0705145603E-01],
	[2.8375000000E+04, 1.8374651750E+01, 4.8808393586E+00, 5.3152096697E+00, 2.2349119241E+00, 9.0709644121E-01],
	[2.8380000000E+04, 1.8379931308E+01, 4.8808183687E+00, 5.3182437150E+00, 2.2355218828E+00, 9.0714140422E-01],
	[2.8385000000E+04, 1.8385211452E+01, 4.8807973825E+00, 5.3212789567E+00, 2.2361317384E+00, 9.0718634507E-01],
	[2.8390000000E+04, 1.8390492182E+01, 4.8807764001E+00, 5.3243153950E+00, 2.2367414907E+00, 9.0723126377E-01],
	[2.8395000000E+04, 1.8395773499E+01, 4.8807554215E+00, 5.3273530302E+00, 2.2373511397E+00, 9.0727616033E-01],
	[2.8400000000E+04, 1.8401055403E+01, 4.8807344467E+00, 5.3303918625E+00, 2.2379606854E+00, 9.0732103476E-01],
	[2.8405000000E+04, 1.8406337892E+01, 4.8807134757E+00, 5.3334318922E+00, 2.2385701277E+00, 9.0736588707E-01],
	[2.8410000000E+04, 1.8411620968E+01, 4.8806925085E+00, 5.3364731196E+00, 2.2391794666E+00, 9.0741071727E-01],
	[2.8415000000E+04, 1.8416904630E+01, 4.8806715450E+00, 5.3395155448E+00, 2.2397887020E+00, 9.0745552537E-01],
	[2.8420000000E+04, 1.8422188879E+01, 4.8806505853E+00, 5.3425591683E+00, 2.2403978339E+00, 9.0750031137E-01],
	[2.8425000000E+04, 1.8427473713E+01, 4.8806296294E+00, 5.3456039902E+00, 2.2410068622E+00, 9.0754507530E-01],
	[2.8430000000E+04, 1.8432759134E+01, 4.8806086772E+00, 5.3486500107E+00, 2.2416157869E+00, 9.0758981716E-01],
	[2.8435000000E+04, 1.8438045141E+01, 4.8805877289E+00, 5.3516972303E+00, 2.2422246080E+00, 9.0763453697E-01],
	[2.8440000000E+04, 1.8443331733E+01, 4.8805667843E+00, 5.3547456490E+00, 2.2428333253E+00, 9.0767923472E-01],
	[2.8445000000E+04, 1.8448618912E+01, 4.8805458435E+00, 5.3577952673E+00, 2.2434419389E+00, 9.0772391043E-01],
	[2.8450000000E+04, 1.8453906677E+01, 4.8805249064E+00, 5.3608460852E+00, 2.2440504486E+00, 9.0776856412E-01],
	[2.8455000000E+04, 1.8459195028E+01, 4.8805039732E+00, 5.3638981032E+00, 2.2446588545E+00, 9.0781319578E-01],
	[2.8460000000E+04, 1.8464483965E+01, 4.8804830436E+00, 5.3669513214E+00, 2.2452671566E+00, 9.0785780544E-01],
	[2.8465000000E+04, 1.8469773488E+01, 4.8804621179E+00, 5.3700057401E+00, 2.2458753546E+00, 9.0790239310E-01],
	[2.8470000000E+04, 1.8475063596E+01, 4.8804411959E+00, 5.3730613597E+00, 2.2464834487E+00, 9.0794695877E-01],
	[2.8475000000E+04, 1.8480354291E+01, 4.8804202777E+00, 5.3761181802E+00, 2.2470914387E+00, 9.0799150246E-01],
	[2.8480000000E+04, 1.8485645571E+01, 4.8803993633E+00, 5.3791762021E+00, 2.2476993246E+00, 9.0803602419E-01],
	[2.8485000000E+04, 1.8490937437E+01, 4.8803784526E+00, 5.3822354255E+00, 2.2483071064E+00, 9.0808052396E-01],
	[2.8490000000E+04, 1.8496229888E+01, 4.8803575456E+00, 5.3852958508E+00, 2.2489147839E+00, 9.0812500178E-01],
	[2.8495000000E+04, 1.8501522925E+01, 4.8803366425E+00, 5.3883574781E+00, 2.2495223573E+00, 9.0816945766E-01],
	[2.8500000000E+04, 1.8506816548E+01, 4.8803157430E+00, 5.3914203078E+00, 2.2501298264E+00, 9.0821389162E-01],
	[2.8505000000E+04, 1.8512110757E+01, 4.8802948474E+00, 5.3944843401E+00, 2.2507371911E+00, 9.0825830366E-01],
	[2.8510000000E+04, 1.8517411447E+01, 4.8802748571E+00, 5.3975495753E+00, 2.2513447305E+00, 9.0830269379E-01],
	[2.8515000000E+04, 1.8522727448E+01, 4.8802571210E+00, 5.4006160136E+00, 2.2519528625E+00, 9.0834706203E-01],
	[2.8520000000E+04, 1.8528044042E+01, 4.8802393880E+00, 5.4036836552E+00, 2.2525608908E+00, 9.0839140838E-01],
	[2.8525000000E+04, 1.8533361230E+01, 4.8802216582E+00, 5.4067525006E+00, 2.2531688152E+00, 9.0843573286E-01],
	[2.8530000000E+04, 1.8538679012E+01, 4.8802039316E+00, 5.4098225498E+00, 2.2537766358E+00, 9.0848003547E-01],
	[2.8535000000E+04, 1.8543997387E+01, 4.8801862082E+00, 5.4128938032E+00, 2.2543843526E+00, 9.0852431622E-01],
	[2.8540000000E+04, 1.8549316356E+01, 4.8801684879E+00, 5.4159662610E+00, 2.2549919653E+00, 9.0856857513E-01],
	[2.8545000000E+04, 1.8554635918E+01, 4.8801507708E+00, 5.4190399236E+00, 2.2555994741E+00, 9.0861281220E-01],
	[2.8550000000E+04, 1.8559956074E+01, 4.8801330569E+00, 5.4221147911E+00, 2.2562068788E+00, 9.0865702745E-01],
	[2.8555000000E+04, 1.8565276823E+01, 4.8801153461E+00, 5.4251908638E+00, 2.2568141795E+00, 9.0870122088E-01],
	[2.8560000000E+04, 1.8570598166E+01, 4.8800976385E+00, 5.4282681419E+00, 2.2574213760E+00, 9.0874539251E-01],
	[2.8565000000E+04, 1.8575920101E+01, 4.8800799341E+00, 5.4313466258E+00, 2.2580284684E+00, 9.0878954234E-01],
	[2.8570000000E+04, 1.8581242630E+01, 4.8800622328E+00, 5.4344263158E+00, 2.2586354565E+00, 9.0883367039E-01],
	[2.8575000000E+04, 1.8586565753E+01, 4.8800445347E+00, 5.4375072119E+00, 2.2592423404E+00, 9.0887777667E-01],
	[2.8580000000E+04, 1.8591889468E+01, 4.8800268397E+00, 5.4405893146E+00, 2.2598491199E+00, 9.0892186117E-01],
	[2.8585000000E+04, 1.8597213777E+01, 4.8800091479E+00, 5.4436726241E+00, 2.2604557951E+00, 9.0896592391E-01],
	[2.8590000000E+04, 1.8602538679E+01, 4.8799914593E+00, 5.4467571406E+00, 2.2610623659E+00, 9.0900996491E-01],
	[2.8595000000E+04, 1.8607864174E+01, 4.8799737738E+00, 5.4498428644E+00, 2.2616688323E+00, 9.0905398416E-01],
	[2.8600000000E+04, 1.8613190262E+01, 4.8799560915E+00, 5.4529297957E+00, 2.2622751941E+00, 9.0909798168E-01],
	[2.8605000000E+04, 1.8618516943E+01, 4.8799384123E+00, 5.4560179349E+00, 2.2628814514E+00, 9.0914195748E-01],
	[2.8610000000E+04, 1.8623844217E+01, 4.8799207363E+00, 5.4591072822E+00, 2.2634876041E+00, 9.0918591156E-01],
	[2.8615000000E+04, 1.8629172083E+01, 4.8799030635E+00, 5.4621978378E+00, 2.2640936522E+00, 9.0922984393E-01],
	[2.8620000000E+04, 1.8634500543E+01, 4.8798853938E+00, 5.4652896021E+00, 2.2646995956E+00, 9.0927375460E-01],
	[2.8625000000E+04, 1.8639829596E+01, 4.8798677272E+00, 5.4683825752E+00, 2.2653054343E+00, 9.0931764359E-01],
	[2.8630000000E+04, 1.8645159242E+01, 4.8798500638E+00, 5.4714767574E+00, 2.2659111682E+00, 9.0936151090E-01],
	[2.8635000000E+04, 1.8650489480E+01, 4.8798324035E+00, 5.4745721490E+00, 2.2665167973E+00, 9.0940535653E-01],
	[2.8640000000E+04, 1.8655820311E+01, 4.8798147464E+00, 5.4776687503E+00, 2.2671223215E+00, 9.0944918051E-01],
	[2.8645000000E+04, 1.8661151735E+01, 4.8797970925E+00, 5.4807665614E+00, 2.2677277408E+00, 9.0949298283E-01],
	[2.8650000000E+04, 1.8666483751E+01, 4.8797794416E+00, 5.4838655828E+00, 2.2683330552E+00, 9.0953676350E-01],
	[2.8655000000E+04, 1.8671816360E+01, 4.8797617940E+00, 5.4869658146E+00, 2.2689382646E+00, 9.0958052254E-01],
	[2.8660000000E+04, 1.8677149562E+01, 4.8797441494E+00, 5.4900672571E+00, 2.2695433689E+00, 9.0962425995E-01],
	[2.8665000000E+04, 1.8682483357E+01, 4.8797265080E+00, 5.4931699105E+00, 2.2701483682E+00, 9.0966797575E-01],
	[2.8670000000E+04, 1.8687817743E+01, 4.8797088698E+00, 5.4962737751E+00, 2.2707532623E+00, 9.0971166993E-01],
	[2.8675000000E+04, 1.8693152723E+01, 4.8796912347E+00, 5.4993788513E+00, 2.2713580513E+00, 9.0975534251E-01],
	[2.8680000000E+04, 1.8698488295E+01, 4.8796736027E+00, 5.5024851391E+00, 2.2719627350E+00, 9.0979899351E-01],
	[2.8685000000E+04, 1.8703824459E+01, 4.8796559739E+00, 5.5055926390E+00, 2.2725673135E+00, 9.0984262292E-01],
	[2.8690000000E+04, 1.8709161215E+01, 4.8796383482E+00, 5.5087013511E+00, 2.2731717866E+00, 9.0988623076E-01],
	[2.8695000000E+04, 1.8714498564E+01, 4.8796207256E+00, 5.5118112758E+00, 2.2737761544E+00, 9.0992981703E-01],
	[2.8700000000E+04, 1.8719836506E+01, 4.8796031062E+00, 5.5149224132E+00, 2.2743804168E+00, 9.0997338174E-01],
	[2.8705000000E+04, 1.8725175039E+01, 4.8795854899E+00, 5.5180347637E+00, 2.2749845738E+00, 9.1001692491E-01],
	[2.8710000000E+04, 1.8730514165E+01, 4.8795678767E+00, 5.5211483275E+00, 2.2755886253E+00, 9.1006044654E-01],
	[2.8715000000E+04, 1.8735853883E+01, 4.8795502667E+00, 5.5242631049E+00, 2.2761925712E+00, 9.1010394664E-01],
	[2.8720000000E+04, 1.8741194193E+01, 4.8795326598E+00, 5.5273790961E+00, 2.2767964116E+00, 9.1014742523E-01],
	[2.8725000000E+04, 1.8746535095E+01, 4.8795150560E+00, 5.5304963013E+00, 2.2774001464E+00, 9.1019088230E-01],
	[2.8730000000E+04, 1.8751876590E+01, 4.8794974553E+00, 5.5336147210E+00, 2.2780037755E+00, 9.1023431786E-01],
	[2.8735000000E+04, 1.8757218676E+01, 4.8794798578E+00, 5.5367343552E+00, 2.2786072989E+00, 9.1027773194E-01],
	[2.8740000000E+04, 1.8762561354E+01, 4.8794622634E+00, 5.5398552043E+00, 2.2792107165E+00, 9.1032112453E-01],
	[2.8745000000E+04, 1.8767904625E+01, 4.8794446722E+00, 5.5429772686E+00, 2.2798140283E+00, 9.1036449564E-01],
	[2.8750000000E+04, 1.8773248487E+01, 4.8794270840E+00, 5.5461005482E+00, 2.2804172343E+00, 9.1040784529E-01],
	[2.8755000000E+04, 1.8778592941E+01, 4.8794094990E+00, 5.5492250435E+00, 2.2810203345E+00, 9.1045117348E-01],
	[2.8760000000E+04, 1.8783937987E+01, 4.8793919171E+00, 5.5523507548E+00, 2.2816233287E+00, 9.1049448022E-01],
	[2.8765000000E+04, 1.8789283625E+01, 4.8793743383E+00, 5.5554776822E+00, 2.2822262169E+00, 9.1053776552E-01],
	[2.8770000000E+04, 1.8794629855E+01, 4.8793567626E+00, 5.5586058260E+00, 2.2828289991E+00, 9.1058102939E-01],
	[2.8775000000E+04, 1.8799976676E+01, 4.8793391901E+00, 5.5617351866E+00, 2.2834316753E+00, 9.1062427183E-01],
	[2.8780000000E+04, 1.8805324089E+01, 4.8793216206E+00, 5.5648657641E+00, 2.2840342453E+00, 9.1066749287E-01],
	[2.8785000000E+04, 1.8810672094E+01, 4.8793040543E+00, 5.5679975588E+00, 2.2846367093E+00, 9.1071069250E-01],
	[2.8790000000E+04, 1.8816020690E+01, 4.8792864911E+00, 5.5711305710E+00, 2.2852390670E+00, 9.1075387073E-01],
	[2.8795000000E+04, 1.8821369878E+01, 4.8792689310E+00, 5.5742648010E+00, 2.2858413185E+00, 9.1079702758E-01],
	[2.8800000000E+04, 1.8826719658E+01, 4.8792513740E+00, 5.5774002490E+00, 2.2864434638E+00, 9.1084016305E-01],
	[2.8805000000E+04, 1.8832070029E+01, 4.8792338201E+00, 5.5805369152E+00, 2.2870455027E+00, 9.1088327716E-01],
	[2.8810000000E+04, 1.8837420992E+01, 4.8792162694E+00, 5.5836748000E+00, 2.2876474353E+00, 9.1092636990E-01],
	[2.8815000000E+04, 1.8842772546E+01, 4.8791987217E+00, 5.5868139036E+00, 2.2882492614E+00, 9.1096944130E-01],
	[2.8820000000E+04, 1.8848124691E+01, 4.8791811772E+00, 5.5899542263E+00, 2.2888509812E+00, 9.1101249135E-01],
	[2.8825000000E+04, 1.8853477428E+01, 4.8791636358E+00, 5.5930957682E+00, 2.2894525944E+00, 9.1105552007E-01],
	[2.8830000000E+04, 1.8858830756E+01, 4.8791460974E+00, 5.5962385297E+00, 2.2900541011E+00, 9.1109852746E-01],
	[2.8835000000E+04, 1.8864184676E+01, 4.8791285622E+00, 5.5993825111E+00, 2.2906555013E+00, 9.1114151355E-01],
	[2.8840000000E+04, 1.8869539186E+01, 4.8791110301E+00, 5.6025277126E+00, 2.2912567948E+00, 9.1118447832E-01],
	[2.8845000000E+04, 1.8874894288E+01, 4.8790935011E+00, 5.6056741344E+00, 2.2918579817E+00, 9.1122742181E-01],
	[2.8850000000E+04, 1.8880249981E+01, 4.8790759751E+00, 5.6088217769E+00, 2.2924590618E+00, 9.1127034400E-01],
	[2.8855000000E+04, 1.8885606266E+01, 4.8790584523E+00, 5.6119706402E+00, 2.2930600353E+00, 9.1131324491E-01],
	[2.8860000000E+04, 1.8890963141E+01, 4.8790409326E+00, 5.6151207247E+00, 2.2936609019E+00, 9.1135612456E-01],
	[2.8865000000E+04, 1.8896320607E+01, 4.8790234160E+00, 5.6182720306E+00, 2.2942616618E+00, 9.1139898295E-01],
	[2.8870000000E+04, 1.8901678665E+01, 4.8790059024E+00, 5.6214245582E+00, 2.2948623147E+00, 9.1144182008E-01],
	[2.8875000000E+04, 1.8907037314E+01, 4.8789883920E+00, 5.6245783077E+00, 2.2954628608E+00, 9.1148463597E-01],
	[2.8880000000E+04, 1.8912396553E+01, 4.8789708847E+00, 5.6277332794E+00, 2.2960632999E+00, 9.1152743063E-01],
	[2.8885000000E+04, 1.8917756383E+01, 4.8789533804E+00, 5.6308894735E+00, 2.2966636320E+00, 9.1157020406E-01],
	[2.8890000000E+04, 1.8923116805E+01, 4.8789358793E+00, 5.6340468904E+00, 2.2972638571E+00, 9.1161295628E-01],
	[2.8895000000E+04, 1.8928477817E+01, 4.8789183812E+00, 5.6372055303E+00, 2.2978639751E+00, 9.1165568730E-01],
	[2.8900000000E+04, 1.8933839420E+01, 4.8789008863E+00, 5.6403653934E+00, 2.2984639860E+00, 9.1169839711E-01],
	[2.8905000000E+04, 1.8939201613E+01, 4.8788833944E+00, 5.6435264799E+00, 2.2990638897E+00, 9.1174108574E-01],
	[2.8910000000E+04, 1.8944564398E+01, 4.8788659056E+00, 5.6466887903E+00, 2.2996636862E+00, 9.1178375319E-01],
	[2.8915000000E+04, 1.8949927773E+01, 4.8788484199E+00, 5.6498523247E+00, 2.3002633755E+00, 9.1182639947E-01],
	[2.8920000000E+04, 1.8955291739E+01, 4.8788309373E+00, 5.6530170833E+00, 2.3008629575E+00, 9.1186902459E-01],
	[2.8925000000E+04, 1.8960656295E+01, 4.8788134577E+00, 5.6561830665E+00, 2.3014624322E+00, 9.1191162855E-01],
	[2.8930000000E+04, 1.8966021443E+01, 4.8787959813E+00, 5.6593502746E+00, 2.3020617995E+00, 9.1195421138E-01],
	[2.8935000000E+04, 1.8971387180E+01, 4.8787785079E+00, 5.6625187077E+00, 2.3026610594E+00, 9.1199677307E-01],
	[2.8940000000E+04, 1.8976753508E+01, 4.8787610376E+00, 5.6656883661E+00, 2.3032602119E+00, 9.1203931363E-01],
	[2.8945000000E+04, 1.8982120427E+01, 4.8787435704E+00, 5.6688592501E+00, 2.3038592568E+00, 9.1208183308E-01],
	[2.8950000000E+04, 1.8987487936E+01, 4.8787261063E+00, 5.6720313600E+00, 2.3044581943E+00, 9.1212433143E-01],
	[2.8955000000E+04, 1.8992856036E+01, 4.8787086453E+00, 5.6752046960E+00, 2.3050570241E+00, 9.1216680867E-01],
	[2.8960000000E+04, 1.8998224725E+01, 4.8786911873E+00, 5.6783792583E+00, 2.3056557464E+00, 9.1220926483E-01],
	[2.8965000000E+04, 1.9003594006E+01, 4.8786737324E+00, 5.6815550473E+00, 2.3062543610E+00, 9.1225169991E-01],
	[2.8970000000E+04, 1.9008974055E+01, 4.8786578173E+00, 5.6847320633E+00, 2.3068533614E+00, 9.1229411391E-01],
	[2.8975000000E+04, 1.9014365038E+01, 4.8786434653E+00, 5.6879103063E+00, 2.3074527557E+00, 9.1233650686E-01],
	[2.8980000000E+04, 1.9019756618E+01, 4.8786291157E+00, 5.6910897769E+00, 2.3080520429E+00, 9.1237887875E-01],
	[2.8985000000E+04, 1.9025148797E+01, 4.8786147687E+00, 5.6942704751E+00, 2.3086512230E+00, 9.1242122960E-01],
	[2.8990000000E+04, 1.9030541574E+01, 4.8786004242E+00, 5.6974524012E+00, 2.3092502959E+00, 9.1246355942E-01],
	[2.8995000000E+04, 1.9035934949E+01, 4.8785860823E+00, 5.7006355556E+00, 2.3098492616E+00, 9.1250586821E-01],
	[2.9000000000E+04, 1.9041328922E+01, 4.8785717428E+00, 5.7038199384E+00, 2.3104481201E+00, 9.1254815599E-01],
	[2.9005000000E+04, 1.9046723494E+01, 4.8785574059E+00, 5.7070055500E+00, 2.3110468713E+00, 9.1259042276E-01],
	[2.9010000000E+04, 1.9052118663E+01, 4.8785430714E+00, 5.7101923905E+00, 2.3116455151E+00, 9.1263266853E-01],
	[2.9015000000E+04, 1.9057514431E+01, 4.8785287395E+00, 5.7133804604E+00, 2.3122440516E+00, 9.1267489332E-01],
	[2.9020000000E+04, 1.9062910796E+01, 4.8785144101E+00, 5.7165697597E+00, 2.3128424807E+00, 9.1271709712E-01],
	[2.9025000000E+04, 1.9068307760E+01, 4.8785000832E+00, 5.7197602888E+00, 2.3134408024E+00, 9.1275927996E-01],
	[2.9030000000E+04, 1.9073705321E+01, 4.8784857588E+00, 5.7229520480E+00, 2.3140390166E+00, 9.1280144183E-01],
	[2.9035000000E+04, 1.9079103481E+01, 4.8784714369E+00, 5.7261450375E+00, 2.3146371232E+00, 9.1284358275E-01],
	[2.9040000000E+04, 1.9084502238E+01, 4.8784571176E+00, 5.7293392575E+00, 2.3152351223E+00, 9.1288570273E-01],
	[2.9045000000E+04, 1.9089901593E+01, 4.8784428007E+00, 5.7325347084E+00, 2.3158330138E+00, 9.1292780178E-01],
	[2.9050000000E+04, 1.9095301546E+01, 4.8784284863E+00, 5.7357313904E+00, 2.3164307976E+00, 9.1296987990E-01],
	[2.9055000000E+04, 1.9100702096E+01, 4.8784141745E+00, 5.7389293037E+00, 2.3170284737E+00, 9.1301193710E-01],
	[2.9060000000E+04, 1.9106103245E+01, 4.8783998651E+00, 5.7421284487E+00, 2.3176260422E+00, 9.1305397340E-01],
	[2.9065000000E+04, 1.9111504990E+01, 4.8783855583E+00, 5.7453288255E+00, 2.3182235028E+00, 9.1309598880E-01],
	[2.9070000000E+04, 1.9116907334E+01, 4.8783712540E+00, 5.7485304344E+00, 2.3188208557E+00, 9.1313798332E-01],
	[2.9075000000E+04, 1.9122310275E+01, 4.8783569521E+00, 5.7517332758E+00, 2.3194181007E+00, 9.1317995695E-01],
	[2.9080000000E+04, 1.9127713814E+01, 4.8783426528E+00, 5.7549373498E+00, 2.3200152378E+00, 9.1322190972E-01],
	[2.9085000000E+04, 1.9133117950E+01, 4.8783283559E+00, 5.7581426568E+00, 2.3206122670E+00, 9.1326384162E-01],
	[2.9090000000E+04, 1.9138522684E+01, 4.8783140616E+00, 5.7613491969E+00, 2.3212091883E+00, 9.1330575267E-01],
	[2.9095000000E+04, 1.9143928015E+01, 4.8782997698E+00, 5.7645569705E+00, 2.3218060015E+00, 9.1334764288E-01],
	[2.9100000000E+04, 1.9149333944E+01, 4.8782854804E+00, 5.7677659778E+00, 2.3224027067E+00, 9.1338951226E-01],
	[2.9105000000E+04, 1.9154740470E+01, 4.8782711936E+00, 5.7709762191E+00, 2.3229993038E+00, 9.1343136081E-01],
	[2.9110000000E+04, 1.9160147593E+01, 4.8782569092E+00, 5.7741876946E+00, 2.3235957928E+00, 9.1347318855E-01],
	[2.9115000000E+04, 1.9165555313E+01, 4.8782426274E+00, 5.7774004047E+00, 2.3241921737E+00, 9.1351499549E-01],
	[2.9120000000E+04, 1.9170963631E+01, 4.8782283480E+00, 5.7806143494E+00, 2.3247884463E+00, 9.1355678162E-01],
	[2.9125000000E+04, 1.9176372546E+01, 4.8782140712E+00, 5.7838295292E+00, 2.3253846107E+00, 9.1359854697E-01],
	[2.9130000000E+04, 1.9181782059E+01, 4.8781997968E+00, 5.7870459443E+00, 2.3259806669E+00, 9.1364029154E-01],
	[2.9135000000E+04, 1.9187192168E+01, 4.8781855249E+00, 5.7902635949E+00, 2.3265766147E+00, 9.1368201534E-01],
	[2.9140000000E+04, 1.9192602875E+01, 4.8781712555E+00, 5.7934824814E+00, 2.3271724542E+00, 9.1372371838E-01],
	[2.9145000000E+04, 1.9198014178E+01, 4.8781569886E+00, 5.7967026039E+00, 2.3277681853E+00, 9.1376540067E-01],
	[2.9150000000E+04, 1.9203426079E+01, 4.8781427242E+00, 5.7999239627E+00, 2.3283638079E+00, 9.1380706222E-01],
	[2.9155000000E+04, 1.9208838577E+01, 4.8781284623E+00, 5.8031465582E+00, 2.3289593221E+00, 9.1384870304E-01],
	[2.9160000000E+04, 1.9214251672E+01, 4.8781142028E+00, 5.8063703905E+00, 2.3295547278E+00, 9.1389032313E-01],
	[2.9165000000E+04, 1.9219665363E+01, 4.8780999459E+00, 5.8095954599E+00, 2.3301500250E+00, 9.1393192251E-01],
	[2.9170000000E+04, 1.9225079652E+01, 4.8780856914E+00, 5.8128217667E+00, 2.3307452135E+00, 9.1397350119E-01],
	[2.9175000000E+04, 1.9230494537E+01, 4.8780714394E+00, 5.8160493111E+00, 2.3313402935E+00, 9.1401505917E-01],
	[2.9180000000E+04, 1.9235910019E+01, 4.8780571900E+00, 5.8192780934E+00, 2.3319352647E+00, 9.1405659646E-01],
	[2.9185000000E+04, 1.9241326098E+01, 4.8780429429E+00, 5.8225081140E+00, 2.3325301273E+00, 9.1409811307E-01],
	[2.9190000000E+04, 1.9246742774E+01, 4.8780286984E+00, 5.8257393729E+00, 2.3331248812E+00, 9.1413960902E-01],
	[2.9195000000E+04, 1.9252160047E+01, 4.8780144564E+00, 5.8289718705E+00, 2.3337195263E+00, 9.1418108431E-01],
	[2.9200000000E+04, 1.9257577916E+01, 4.8780002168E+00, 5.8322056071E+00, 2.3343140625E+00, 9.1422253895E-01],
	[2.9205000000E+04, 1.9262996382E+01, 4.8779859797E+00, 5.8354405829E+00, 2.3349084899E+00, 9.1426397295E-01],
	[2.9210000000E+04, 1.9268415444E+01, 4.8779717451E+00, 5.8386767982E+00, 2.3355028085E+00, 9.1430538631E-01],
	[2.9215000000E+04, 1.9273835103E+01, 4.8779575130E+00, 5.8419142532E+00, 2.3360970181E+00, 9.1434677906E-01],
	[2.9220000000E+04, 1.9279255359E+01, 4.8779432833E+00, 5.8451529483E+00, 2.3366911187E+00, 9.1438815119E-01],
	[2.9225000000E+04, 1.9284676211E+01, 4.8779290561E+00, 5.8483928836E+00, 2.3372851104E+00, 9.1442950272E-01],
	[2.9230000000E+04, 1.9290097659E+01, 4.8779148314E+00, 5.8516340594E+00, 2.3378789930E+00, 9.1447083365E-01],
	[2.9235000000E+04, 1.9295519704E+01, 4.8779006092E+00, 5.8548764760E+00, 2.3384727665E+00, 9.1451214400E-01],
	[2.9240000000E+04, 1.9300942346E+01, 4.8778863894E+00, 5.8581201337E+00, 2.3390664310E+00, 9.1455343377E-01],
	[2.9245000000E+04, 1.9306365583E+01, 4.8778721722E+00, 5.8613650327E+00, 2.3396599862E+00, 9.1459470298E-01],
	[2.9250000000E+04, 1.9311789417E+01, 4.8778579573E+00, 5.8646111732E+00, 2.3402534323E+00, 9.1463595163E-01],
	[2.9255000000E+04, 1.9317213848E+01, 4.8778437450E+00, 5.8678585556E+00, 2.3408467692E+00, 9.1467717973E-01],
	[2.9260000000E+04, 1.9322638874E+01, 4.8778295351E+00, 5.8711071801E+00, 2.3414399968E+00, 9.1471838729E-01],
	[2.9265000000E+04, 1.9328064497E+01, 4.8778153277E+00, 5.8743570470E+00, 2.3420331151E+00, 9.1475957432E-01],
	[2.9270000000E+04, 1.9333490716E+01, 4.8778011228E+00, 5.8776081565E+00, 2.3426261241E+00, 9.1480074083E-01],
	[2.9275000000E+04, 1.9338917531E+01, 4.8777869203E+00, 5.8808605089E+00, 2.3432190237E+00, 9.1484188682E-01],
	[2.9280000000E+04, 1.9344344942E+01, 4.8777727204E+00, 5.8841141044E+00, 2.3438118139E+00, 9.1488301232E-01],
	[2.9285000000E+04, 1.9349772949E+01, 4.8777585228E+00, 5.8873689434E+00, 2.3444044946E+00, 9.1492411732E-01],
	[2.9290000000E+04, 1.9355201552E+01, 4.8777443278E+00, 5.8906250260E+00, 2.3449970659E+00, 9.1496520184E-01],
	[2.9295000000E+04, 1.9360630752E+01, 4.8777301352E+00, 5.8938823526E+00, 2.3455895276E+00, 9.1500626589E-01],
	[2.9300000000E+04, 1.9366060547E+01, 4.8777159450E+00, 5.8971409233E+00, 2.3461818798E+00, 9.1504730946E-01],
	[2.9305000000E+04, 1.9371490938E+01, 4.8777017573E+00, 5.9004007386E+00, 2.3467741224E+00, 9.1508833259E-01],
	[2.9310000000E+04, 1.9376921925E+01, 4.8776875721E+00, 5.9036617985E+00, 2.3473662554E+00, 9.1512933526E-01],
	[2.9315000000E+04, 1.9382353508E+01, 4.8776733894E+00, 5.9069241035E+00, 2.3479582787E+00, 9.1517031750E-01],
	[2.9320000000E+04, 1.9387785687E+01, 4.8776592091E+00, 5.9101876537E+00, 2.3485501923E+00, 9.1521127931E-01],
	[2.9325000000E+04, 1.9393218461E+01, 4.8776450312E+00, 5.9134524494E+00, 2.3491419962E+00, 9.1525222070E-01],
	[2.9330000000E+04, 1.9398651831E+01, 4.8776308559E+00, 5.9167184909E+00, 2.3497336903E+00, 9.1529314168E-01],
	[2.9335000000E+04, 1.9404085797E+01, 4.8776166830E+00, 5.9199857784E+00, 2.3503252745E+00, 9.1533404226E-01],
	[2.9340000000E+04, 1.9409520359E+01, 4.8776025125E+00, 5.9232543122E+00, 2.3509167490E+00, 9.1537492245E-01],
	[2.9345000000E+04, 1.9414955516E+01, 4.8775883445E+00, 5.9265240926E+00, 2.3515081135E+00, 9.1541578226E-01],
	[2.9350000000E+04, 1.9420391268E+01, 4.8775741789E+00, 5.9297951198E+00, 2.3520993682E+00, 9.1545662169E-01],
	[2.9355000000E+04, 1.9425827617E+01, 4.8775600158E+00, 5.9330673942E+00, 2.3526905129E+00, 9.1549744076E-01],
	[2.9360000000E+04, 1.9431264561E+01, 4.8775458552E+00, 5.9363409158E+00, 2.3532815476E+00, 9.1553823948E-01],
	[2.9365000000E+04, 1.9436702100E+01, 4.8775316970E+00, 5.9396156851E+00, 2.3538724722E+00, 9.1557901785E-01],
	[2.9370000000E+04, 1.9442140235E+01, 4.8775175413E+00, 5.9428917022E+00, 2.3544632868E+00, 9.1561977588E-01],
	[2.9375000000E+04, 1.9447578965E+01, 4.8775033880E+00, 5.9461689675E+00, 2.3550539913E+00, 9.1566051359E-01],
	[2.9380000000E+04, 1.9453018290E+01, 4.8774892371E+00, 5.9494474812E+00, 2.3556445857E+00, 9.1570123098E-01],
	[2.9385000000E+04, 1.9458458211E+01, 4.8774750888E+00, 5.9527272436E+00, 2.3562350699E+00, 9.1574192806E-01],
	[2.9390000000E+04, 1.9463898727E+01, 4.8774609428E+00, 5.9560082549E+00, 2.3568254439E+00, 9.1578260485E-01],
	[2.9395000000E+04, 1.9469339839E+01, 4.8774467993E+00, 5.9592905153E+00, 2.3574157077E+00, 9.1582326134E-01],
	[2.9400000000E+04, 1.9474781546E+01, 4.8774326583E+00, 5.9625740253E+00, 2.3580058612E+00, 9.1586389755E-01],
	[2.9405000000E+04, 1.9480223848E+01, 4.8774185197E+00, 5.9658587849E+00, 2.3585959044E+00, 9.1590451350E-01],
	[2.9410000000E+04, 1.9485666745E+01, 4.8774043835E+00, 5.9691447945E+00, 2.3591858372E+00, 9.1594510918E-01],
	[2.9415000000E+04, 1.9491110237E+01, 4.8773902498E+00, 5.9724320544E+00, 2.3597756597E+00, 9.1598568461E-01],
	[2.9420000000E+04, 1.9496554324E+01, 4.8773761185E+00, 5.9757205647E+00, 2.3603653717E+00, 9.1602623979E-01],
	[2.9425000000E+04, 1.9501999006E+01, 4.8773619897E+00, 5.9790103259E+00, 2.3609549733E+00, 9.1606677474E-01],
	[2.9430000000E+04, 1.9507444284E+01, 4.8773478633E+00, 5.9823013380E+00, 2.3615444644E+00, 9.1610728947E-01],
	[2.9435000000E+04, 1.9512894823E+01, 4.8773344352E+00, 5.9855936015E+00, 2.3621340766E+00, 9.1614778398E-01],
	[2.9440000000E+04, 1.9518361706E+01, 4.8773233565E+00, 5.9888871165E+00, 2.3627243599E+00, 9.1618825828E-01],
	[2.9445000000E+04, 1.9523829191E+01, 4.8773122797E+00, 5.9921818833E+00, 2.3633145333E+00, 9.1622871239E-01],
	[2.9450000000E+04, 1.9529297280E+01, 4.8773012047E+00, 5.9954779022E+00, 2.3639045968E+00, 9.1626914631E-01],
	[2.9455000000E+04, 1.9534765971E+01, 4.8772901317E+00, 5.9987751734E+00, 2.3644945503E+00, 9.1630956005E-01],
	[2.9460000000E+04, 1.9540235265E+01, 4.8772790606E+00, 6.0020736972E+00, 2.3650843937E+00, 9.1634995363E-01],
	[2.9465000000E+04, 1.9545705161E+01, 4.8772679914E+00, 6.0053734740E+00, 2.3656741271E+00, 9.1639032704E-01],
	[2.9470000000E+04, 1.9551175661E+01, 4.8772569241E+00, 6.0086745038E+00, 2.3662637504E+00, 9.1643068030E-01],
	[2.9475000000E+04, 1.9556646763E+01, 4.8772458587E+00, 6.0119767870E+00, 2.3668532636E+00, 9.1647101342E-01],
	[2.9480000000E+04, 1.9562118467E+01, 4.8772347952E+00, 6.0152803239E+00, 2.3674426667E+00, 9.1651132641E-01],
	[2.9485000000E+04, 1.9567590774E+01, 4.8772237336E+00, 6.0185851147E+00, 2.3680319595E+00, 9.1655161928E-01],
	[2.9490000000E+04, 1.9573063684E+01, 4.8772126739E+00, 6.0218911597E+00, 2.3686211421E+00, 9.1659189203E-01],
	[2.9495000000E+04, 1.9578537196E+01, 4.8772016161E+00, 6.0251984592E+00, 2.3692102145E+00, 9.1663214468E-01],
	[2.9500000000E+04, 1.9584011311E+01, 4.8771905602E+00, 6.0285070133E+00, 2.3697991766E+00, 9.1667237724E-01],
	[2.9505000000E+04, 1.9589486028E+01, 4.8771795062E+00, 6.0318168224E+00, 2.3703880283E+00, 9.1671258971E-01],
	[2.9510000000E+04, 1.9594961347E+01, 4.8771684541E+00, 6.0351278868E+00, 2.3709767697E+00, 9.1675278210E-01],
	[2.9515000000E+04, 1.9600437269E+01, 4.8771574039E+00, 6.0384402066E+00, 2.3715654007E+00, 9.1679295443E-01],
	[2.9520000000E+04, 1.9605913793E+01, 4.8771463556E+00, 6.0417537822E+00, 2.3721539212E+00, 9.1683310670E-01],
	[2.9525000000E+04, 1.9611390920E+01, 4.8771353092E+00, 6.0450686138E+00, 2.3727423313E+00, 9.1687323892E-01],
	[2.9530000000E+04, 1.9616868648E+01, 4.8771242647E+00, 6.0483847017E+00, 2.3733306309E+00, 9.1691335110E-01],
	[2.9535000000E+04, 1.9622346979E+01, 4.8771132221E+00, 6.0517020462E+00, 2.3739188199E+00, 9.1695344325E-01],
	[2.9540000000E+04, 1.9627825912E+01, 4.8771021814E+00, 6.0550206474E+00, 2.3745068984E+00, 9.1699351539E-01],
	[2.9545000000E+04, 1.9633305447E+01, 4.8770911426E+00, 6.0583405058E+00, 2.3750948663E+00, 9.1703356751E-01],
	[2.9550000000E+04, 1.9638785584E+01, 4.8770801056E+00, 6.0616616215E+00, 2.3756827235E+00, 9.1707359963E-01],
	[2.9555000000E+04, 1.9644266324E+01, 4.8770690706E+00, 6.0649839947E+00, 2.3762704701E+00, 9.1711361175E-01],
	[2.9560000000E+04, 1.9649747665E+01, 4.8770580374E+00, 6.0683076259E+00, 2.3768581060E+00, 9.1715360390E-01],
	[2.9565000000E+04, 1.9655229608E+01, 4.8770470062E+00, 6.0716325151E+00, 2.3774456311E+00, 9.1719357607E-01],
	[2.9570000000E+04, 1.9660712154E+01, 4.8770359768E+00, 6.0749586628E+00, 2.3780330455E+00, 9.1723352827E-01],
	[2.9575000000E+04, 1.9666195301E+01, 4.8770249493E+00, 6.0782860691E+00, 2.3786203491E+00, 9.1727346052E-01],
	[2.9580000000E+04, 1.9671679050E+01, 4.8770139237E+00, 6.0816147343E+00, 2.3792075418E+00, 9.1731337283E-01],
	[2.9585000000E+04, 1.9677163401E+01, 4.8770029000E+00, 6.0849446587E+00, 2.3797946237E+00, 9.1735326520E-01],
	[2.9590000000E+04, 1.9682648354E+01, 4.8769918782E+00, 6.0882758425E+00, 2.3803815946E+00, 9.1739313764E-01],
	[2.9595000000E+04, 1.9688133908E+01, 4.8769808583E+00, 6.0916082861E+00, 2.3809684547E+00, 9.1743299016E-01],
	[2.9600000000E+04, 1.9693620065E+01, 4.8769698402E+00, 6.0949419896E+00, 2.3815552037E+00, 9.1747282277E-01],
	[2.9605000000E+04, 1.9699106823E+01, 4.8769588241E+00, 6.0982769533E+00, 2.3821418418E+00, 9.1751263549E-01],
	[2.9610000000E+04, 1.9704594182E+01, 4.8769478098E+00, 6.1016131775E+00, 2.3827283688E+00, 9.1755242831E-01],
	[2.9615000000E+04, 1.9710082144E+01, 4.8769367974E+00, 6.1049506625E+00, 2.3833147848E+00, 9.1759220126E-01],
	[2.9620000000E+04, 1.9715570707E+01, 4.8769257869E+00, 6.1082894085E+00, 2.3839010897E+00, 9.1763195433E-01],
	[2.9625000000E+04, 1.9721059871E+01, 4.8769147783E+00, 6.1116294158E+00, 2.3844872834E+00, 9.1767168754E-01],
	[2.9630000000E+04, 1.9726549637E+01, 4.8769037716E+00, 6.1149706846E+00, 2.3850733660E+00, 9.1771140090E-01],
	[2.9635000000E+04, 1.9732040005E+01, 4.8768927667E+00, 6.1183132153E+00, 2.3856593374E+00, 9.1775109441E-01],
	[2.9640000000E+04, 1.9737530973E+01, 4.8768817637E+00, 6.1216570080E+00, 2.3862451975E+00, 9.1779076809E-01],
	[2.9645000000E+04, 1.9743022544E+01, 4.8768707626E+00, 6.1250020630E+00, 2.3868309464E+00, 9.1783042195E-01],
	[2.9650000000E+04, 1.9748514716E+01, 4.8768597634E+00, 6.1283483807E+00, 2.3874165840E+00, 9.1787005599E-01],
	[2.9655000000E+04, 1.9754007489E+01, 4.8768487661E+00, 6.1316959612E+00, 2.3880021102E+00, 9.1790967022E-01],
	[2.9660000000E+04, 1.9759500863E+01, 4.8768377707E+00, 6.1350448048E+00, 2.3885875251E+00, 9.1794926466E-01],
	[2.9665000000E+04, 1.9764994839E+01, 4.8768267771E+00, 6.1383949118E+00, 2.3891728286E+00, 9.1798883931E-01],
	[2.9670000000E+04, 1.9770489416E+01, 4.8768157854E+00, 6.1417462825E+00, 2.3897580207E+00, 9.1802839418E-01],
	[2.9675000000E+04, 1.9775984594E+01, 4.8768047956E+00, 6.1450989170E+00, 2.3903431014E+00, 9.1806792928E-01],
	[2.9680000000E+04, 1.9781480374E+01, 4.8767938076E+00, 6.1484528158E+00, 2.3909280705E+00, 9.1810744462E-01],
	[2.9685000000E+04, 1.9786976754E+01, 4.8767828215E+00, 6.1518079790E+00, 2.3915129281E+00, 9.1814694022E-01],
	[2.9690000000E+04, 1.9792473736E+01, 4.8767718374E+00, 6.1551644069E+00, 2.3920976742E+00, 9.1818641607E-01],
	[2.9695000000E+04, 1.9797971318E+01, 4.8767608550E+00, 6.1585220997E+00, 2.3926823087E+00, 9.1822587219E-01],
	[2.9700000000E+04, 1.9803469502E+01, 4.8767498746E+00, 6.1618810578E+00, 2.3932668316E+00, 9.1826530859E-01],
	[2.9705000000E+04, 1.9808968287E+01, 4.8767388960E+00, 6.1652412814E+00, 2.3938512428E+00, 9.1830472527E-01],
	[2.9710000000E+04, 1.9814467672E+01, 4.8767279193E+00, 6.1686027708E+00, 2.3944355423E+00, 9.1834412225E-01],
	[2.9715000000E+04, 1.9819967659E+01, 4.8767169445E+00, 6.1719655261E+00, 2.3950197302E+00, 9.1838349954E-01],
	[2.9720000000E+04, 1.9825468246E+01, 4.8767059715E+00, 6.1753295478E+00, 2.3956038063E+00, 9.1842285714E-01],
	[2.9725000000E+04, 1.9830969435E+01, 4.8766950004E+00, 6.1786948360E+00, 2.3961877706E+00, 9.1846219507E-01],
	[2.9730000000E+04, 1.9836471224E+01, 4.8766840312E+00, 6.1820613910E+00, 2.3967716231E+00, 9.1850151333E-01],
	[2.9735000000E+04, 1.9841973614E+01, 4.8766730639E+00, 6.1854292130E+00, 2.3973553638E+00, 9.1854081193E-01],
	[2.9740000000E+04, 1.9847476605E+01, 4.8766620984E+00, 6.1887983024E+00, 2.3979389926E+00, 9.1858009089E-01],
	[2.9745000000E+04, 1.9852980196E+01, 4.8766511348E+00, 6.1921686595E+00, 2.3985225095E+00, 9.1861935021E-01],
	[2.9750000000E+04, 1.9858484388E+01, 4.8766401731E+00, 6.1955402843E+00, 2.3991059145E+00, 9.1865858989E-01],
	[2.9755000000E+04, 1.9863989181E+01, 4.8766292132E+00, 6.1989131773E+00, 2.3996892075E+00, 9.1869780996E-01],
	[2.9760000000E+04, 1.9869494574E+01, 4.8766182552E+00, 6.2022873387E+00, 2.4002723885E+00, 9.1873701042E-01],
	[2.9765000000E+04, 1.9875000568E+01, 4.8766072990E+00, 6.2056627688E+00, 2.4008554575E+00, 9.1877619128E-01],
	[2.9770000000E+04, 1.9880507163E+01, 4.8765963447E+00, 6.2090394677E+00, 2.4014384144E+00, 9.1881535255E-01],
	[2.9775000000E+04, 1.9886014358E+01, 4.8765853923E+00, 6.2124174359E+00, 2.4020212593E+00, 9.1885449423E-01],
	[2.9780000000E+04, 1.9891522153E+01, 4.8765744418E+00, 6.2157966734E+00, 2.4026039920E+00, 9.1889361634E-01],
	[2.9785000000E+04, 1.9897030549E+01, 4.8765634931E+00, 6.2191771807E+00, 2.4031866126E+00, 9.1893271889E-01],
	[2.9790000000E+04, 1.9902539545E+01, 4.8765525463E+00, 6.2225589580E+00, 2.4037691211E+00, 9.1897180188E-01],
	[2.9795000000E+04, 1.9908049142E+01, 4.8765416013E+00, 6.2259420055E+00, 2.4043515173E+00, 9.1901086533E-01],
	[2.9800000000E+04, 1.9913559339E+01, 4.8765306582E+00, 6.2293263235E+00, 2.4049338012E+00, 9.1904990924E-01],
	[2.9805000000E+04, 1.9919070136E+01, 4.8765197170E+00, 6.2327119122E+00, 2.4055159729E+00, 9.1908893363E-01],
	[2.9810000000E+04, 1.9924581533E+01, 4.8765087776E+00, 6.2360987720E+00, 2.4060980323E+00, 9.1912793849E-01],
	[2.9815000000E+04, 1.9930093531E+01, 4.8764978400E+00, 6.2394869031E+00, 2.4066799794E+00, 9.1916692386E-01],
	[2.9820000000E+04, 1.9935606129E+01, 4.8764869044E+00, 6.2428763057E+00, 2.4072618141E+00, 9.1920588972E-01],
	[2.9825000000E+04, 1.9941119327E+01, 4.8764759706E+00, 6.2462669801E+00, 2.4078435364E+00, 9.1924483609E-01],
	[2.9830000000E+04, 1.9946633125E+01, 4.8764650386E+00, 6.2496589266E+00, 2.4084251463E+00, 9.1928376299E-01],
	[2.9835000000E+04, 1.9952147523E+01, 4.8764541085E+00, 6.2530521455E+00, 2.4090066437E+00, 9.1932267041E-01],
	[2.9840000000E+04, 1.9957662521E+01, 4.8764431803E+00, 6.2564466369E+00, 2.4095880287E+00, 9.1936155838E-01],
	[2.9845000000E+04, 1.9963178120E+01, 4.8764322539E+00, 6.2598424013E+00, 2.4101693011E+00, 9.1940042689E-01],
	[2.9850000000E+04, 1.9968694318E+01, 4.8764213294E+00, 6.2632394387E+00, 2.4107504610E+00, 9.1943927596E-01],
	[2.9855000000E+04, 1.9974211116E+01, 4.8764104067E+00, 6.2666377496E+00, 2.4113315084E+00, 9.1947810559E-01],
	[2.9860000000E+04, 1.9979728514E+01, 4.8763994859E+00, 6.2700373341E+00, 2.4119124431E+00, 9.1951691581E-01],
	[2.9865000000E+04, 1.9985246512E+01, 4.8763885669E+00, 6.2734381925E+00, 2.4124932652E+00, 9.1955570660E-01],
	[2.9870000000E+04, 1.9990765110E+01, 4.8763776498E+00, 6.2768403252E+00, 2.4130739746E+00, 9.1959447800E-01],
	[2.9875000000E+04, 1.9996284307E+01, 4.8763667346E+00, 6.2802437322E+00, 2.4136545714E+00, 9.1963323000E-01],
	[2.9880000000E+04, 2.0001804105E+01, 4.8763558211E+00, 6.2836484140E+00, 2.4142350554E+00, 9.1967196261E-01],
	[2.9885000000E+04, 2.0007324502E+01, 4.8763449096E+00, 6.2870543708E+00, 2.4148154267E+00, 9.1971067584E-01],
	[2.9890000000E+04, 2.0012845499E+01, 4.8763339999E+00, 6.2904616028E+00, 2.4153956852E+00, 9.1974936971E-01],
	[2.9895000000E+04, 2.0018367095E+01, 4.8763230920E+00, 6.2938701103E+00, 2.4159758308E+00, 9.1978804422E-01],
	[2.9900000000E+04, 2.0023889291E+01, 4.8763121860E+00, 6.2972798936E+00, 2.4165558637E+00, 9.1982669938E-01],
	[2.9905000000E+04, 2.0029412087E+01, 4.8763012818E+00, 6.3006909529E+00, 2.4171357837E+00, 9.1986533520E-01],
	[2.9910000000E+04, 2.0034944812E+01, 4.8762917535E+00, 6.3041032885E+00, 2.4177160644E+00, 9.1990395169E-01],
	[2.9915000000E+04, 2.0040489110E+01, 4.8762838419E+00, 6.3075169007E+00, 2.4182967894E+00, 9.1994254886E-01],
	[2.9920000000E+04, 2.0046034015E+01, 4.8762759317E+00, 6.3109317897E+00, 2.4188774022E+00, 9.1998112672E-01],
	[2.9925000000E+04, 2.0051579528E+01, 4.8762680228E+00, 6.3143479558E+00, 2.4194579026E+00, 9.2001968527E-01],
	[2.9930000000E+04, 2.0057125648E+01, 4.8762601152E+00, 6.3177653992E+00, 2.4200382907E+00, 9.2005822454E-01],
	[2.9935000000E+04, 2.0062672375E+01, 4.8762522089E+00, 6.3211841202E+00, 2.4206185663E+00, 9.2009674452E-01],
	[2.9940000000E+04, 2.0068219709E+01, 4.8762443040E+00, 6.3246041192E+00, 2.4211987296E+00, 9.2013524522E-01],
	[2.9945000000E+04, 2.0073767650E+01, 4.8762364004E+00, 6.3280253962E+00, 2.4217787804E+00, 9.2017372666E-01],
	[2.9950000000E+04, 2.0079316199E+01, 4.8762284981E+00, 6.3314479517E+00, 2.4223587187E+00, 9.2021218885E-01],
	[2.9955000000E+04, 2.0084865354E+01, 4.8762205972E+00, 6.3348717859E+00, 2.4229385446E+00, 9.2025063179E-01],
	[2.9960000000E+04, 2.0090415117E+01, 4.8762126976E+00, 6.3382968989E+00, 2.4235182579E+00, 9.2028905549E-01],
	[2.9965000000E+04, 2.0095965486E+01, 4.8762047994E+00, 6.3417232912E+00, 2.4240978586E+00, 9.2032745996E-01],
	[2.9970000000E+04, 2.0101516463E+01, 4.8761969024E+00, 6.3451509630E+00, 2.4246773468E+00, 9.2036584522E-01],
	[2.9975000000E+04, 2.0107068046E+01, 4.8761890068E+00, 6.3485799144E+00, 2.4252567223E+00, 9.2040421126E-01],
	[2.9980000000E+04, 2.0112620236E+01, 4.8761811126E+00, 6.3520101459E+00, 2.4258359852E+00, 9.2044255811E-01],
	[2.9985000000E+04, 2.0118173033E+01, 4.8761732196E+00, 6.3554416576E+00, 2.4264151354E+00, 9.2048088577E-01],
	[2.9990000000E+04, 2.0123726437E+01, 4.8761653280E+00, 6.3588744498E+00, 2.4269941729E+00, 9.2051919425E-01],
	[2.9995000000E+04, 2.0129280448E+01, 4.8761574377E+00, 6.3623085228E+00, 2.4275730976E+00, 9.2055748355E-01],
	[3.0000000000E+04, 2.0134835065E+01, 4.8761495488E+00, 6.3657438769E+00, 2.4281519096E+00, 9.2059575370E-01],
	[3.0005000000E+04, 2.0140390290E+01, 4.8761416611E+00, 6.3691996759E+00, 2.4287333954E+00, 9.2063400469E-01],
	[3.0010000000E+04, 2.0145946120E+01, 4.8761337748E+00, 6.3726567740E+00, 2.4293147675E+00, 9.2067223653E-01],
	[3.0015000000E+04, 2.0151502558E+01, 4.8761258899E+00, 6.3761151714E+00, 2.4298960260E+00, 9.2071044925E-01],
	[3.0020000000E+04, 2.0157059602E+01, 4.8761180062E+00, 6.3795748684E+00, 2.4304771707E+00, 9.2074864283E-01],
	[3.0025000000E+04, 2.0162617252E+01, 4.8761101239E+00, 6.3830358653E+00, 2.4310582018E+00, 9.2078681731E-01],
	[3.0030000000E+04, 2.0168175510E+01, 4.8761022429E+00, 6.3864981623E+00, 2.4316391190E+00, 9.2082497267E-01],
	[3.0035000000E+04, 2.0173734373E+01, 4.8760943632E+00, 6.3899617597E+00, 2.4322199225E+00, 9.2086310894E-01],
	[3.0040000000E+04, 2.0179293843E+01, 4.8760864849E+00, 6.3934266578E+00, 2.4328006121E+00, 9.2090122612E-01],
	[3.0045000000E+04, 2.0184853920E+01, 4.8760786078E+00, 6.3968928568E+00, 2.4333811879E+00, 9.2093932423E-01],
	[3.0050000000E+04, 2.0190414603E+01, 4.8760707321E+00, 6.4003603570E+00, 2.4339616498E+00, 9.2097740326E-01],
	[3.0055000000E+04, 2.0195975892E+01, 4.8760628577E+00, 6.4038291588E+00, 2.4345419978E+00, 9.2101546324E-01],
	[3.0060000000E+04, 2.0201537788E+01, 4.8760549847E+00, 6.4072992623E+00, 2.4351222318E+00, 9.2105350416E-01],
	[3.0065000000E+04, 2.0207100289E+01, 4.8760471130E+00, 6.4107706678E+00, 2.4357023519E+00, 9.2109152605E-01],
	[3.0070000000E+04, 2.0212663398E+01, 4.8760392425E+00, 6.4142433756E+00, 2.4362823580E+00, 9.2112952890E-01],
	[3.0075000000E+04, 2.0218227112E+01, 4.8760313734E+00, 6.4177173860E+00, 2.4368622501E+00, 9.2116751273E-01],
	[3.0080000000E+04, 2.0223791432E+01, 4.8760235057E+00, 6.4211926993E+00, 2.4374420281E+00, 9.2120547755E-01],
	[3.0085000000E+04, 2.0229356359E+01, 4.8760156392E+00, 6.4246693156E+00, 2.4380216921E+00, 9.2124342336E-01],
	[3.0090000000E+04, 2.0234921892E+01, 4.8760077741E+00, 6.4281472354E+00, 2.4386012419E+00, 9.2128135018E-01],
	[3.0095000000E+04, 2.0240488031E+01, 4.8759999103E+00, 6.4316264588E+00, 2.4391806776E+00, 9.2131925802E-01],
	[3.0100000000E+04, 2.0246054776E+01, 4.8759920478E+00, 6.4351069862E+00, 2.4397599992E+00, 9.2135714688E-01],
	[3.0105000000E+04, 2.0251622127E+01, 4.8759841866E+00, 6.4385888177E+00, 2.4403392066E+00, 9.2139501677E-01],
	[3.0110000000E+04, 2.0257190084E+01, 4.8759763268E+00, 6.4420719538E+00, 2.4409182997E+00, 9.2143286771E-01],
	[3.0115000000E+04, 2.0262758646E+01, 4.8759684682E+00, 6.4455563945E+00, 2.4414972786E+00, 9.2147069970E-01],
	[3.0120000000E+04, 2.0268327815E+01, 4.8759606110E+00, 6.4490421403E+00, 2.4420761432E+00, 9.2150851275E-01],
	[3.0125000000E+04, 2.0273897590E+01, 4.8759527551E+00, 6.4525291914E+00, 2.4426548936E+00, 9.2154630687E-01],
	[3.0130000000E+04, 2.0279467970E+01, 4.8759449005E+00, 6.4560175481E+00, 2.4432335296E+00, 9.2158408206E-01],
	[3.0135000000E+04, 2.0285038956E+01, 4.8759370472E+00, 6.4595072105E+00, 2.4438120512E+00, 9.2162183834E-01],
	[3.0140000000E+04, 2.0290610548E+01, 4.8759291953E+00, 6.4629981791E+00, 2.4443904585E+00, 9.2165957571E-01],
	[3.0145000000E+04, 2.0296182746E+01, 4.8759213447E+00, 6.4664904541E+00, 2.4449687513E+00, 9.2169729418E-01],
	[3.0150000000E+04, 2.0301755550E+01, 4.8759134953E+00, 6.4699840357E+00, 2.4455469297E+00, 9.2173499376E-01],
	[3.0155000000E+04, 2.0307328959E+01, 4.8759056473E+00, 6.4734789242E+00, 2.4461249937E+00, 9.2177267446E-01],
	[3.0160000000E+04, 2.0312902974E+01, 4.8758978006E+00, 6.4769751200E+00, 2.4467029431E+00, 9.2181033628E-01],
	[3.0165000000E+04, 2.0318477594E+01, 4.8758899552E+00, 6.4804726232E+00, 2.4472807781E+00, 9.2184797924E-01],
	[3.0170000000E+04, 2.0324052820E+01, 4.8758821112E+00, 6.4839714341E+00, 2.4478584985E+00, 9.2188560334E-01],
	[3.0175000000E+04, 2.0329628651E+01, 4.8758742684E+00, 6.4874715530E+00, 2.4484361043E+00, 9.2192320859E-01],
	[3.0180000000E+04, 2.0335205088E+01, 4.8758664270E+00, 6.4909729802E+00, 2.4490135955E+00, 9.2196079500E-01],
	[3.0185000000E+04, 2.0340782130E+01, 4.8758585868E+00, 6.4944757160E+00, 2.4495909721E+00, 9.2199836258E-01],
	[3.0190000000E+04, 2.0346359778E+01, 4.8758507480E+00, 6.4979797606E+00, 2.4501682340E+00, 9.2203591133E-01],
	[3.0195000000E+04, 2.0351938031E+01, 4.8758429105E+00, 6.5014851142E+00, 2.4507453813E+00, 9.2207344126E-01],
	[3.0200000000E+04, 2.0357516890E+01, 4.8758350743E+00, 6.5049917773E+00, 2.4513224138E+00, 9.2211095239E-01],
	[3.0205000000E+04, 2.0363096354E+01, 4.8758272394E+00, 6.5084997500E+00, 2.4518993316E+00, 9.2214844471E-01],
	[3.0210000000E+04, 2.0368676423E+01, 4.8758194058E+00, 6.5120090325E+00, 2.4524761347E+00, 9.2218591825E-01],
	[3.0215000000E+04, 2.0374257097E+01, 4.8758115735E+00, 6.5155196253E+00, 2.4530528229E+00, 9.2222337300E-01],
	[3.0220000000E+04, 2.0379838377E+01, 4.8758037426E+00, 6.5190315285E+00, 2.4536293964E+00, 9.2226080897E-01],
	[3.0225000000E+04, 2.0385420262E+01, 4.8757959129E+00, 6.5225447425E+00, 2.4542058550E+00, 9.2229822618E-01],
	[3.0230000000E+04, 2.0391002752E+01, 4.8757880846E+00, 6.5260592674E+00, 2.4547821987E+00, 9.2233562463E-01],
	[3.0235000000E+04, 2.0396585847E+01, 4.8757802575E+00, 6.5295751036E+00, 2.4553584275E+00, 9.2237300433E-01],
	[3.0240000000E+04, 2.0402169547E+01, 4.8757724318E+00, 6.5330922514E+00, 2.4559345414E+00, 9.2241036528E-01],
	[3.0245000000E+04, 2.0407753852E+01, 4.8757646073E+00, 6.5366107110E+00, 2.4565105404E+00, 9.2244770750E-01],
	[3.0250000000E+04, 2.0413338762E+01, 4.8757567842E+00, 6.5401304826E+00, 2.4570864244E+00, 9.2248503100E-01],
	[3.0255000000E+04, 2.0418924277E+01, 4.8757489624E+00, 6.5436515666E+00, 2.4576621934E+00, 9.2252233578E-01],
	[3.0260000000E+04, 2.0424510397E+01, 4.8757411419E+00, 6.5471739632E+00, 2.4582378474E+00, 9.2255962185E-01],
	[3.0265000000E+04, 2.0430097122E+01, 4.8757333227E+00, 6.5506976728E+00, 2.4588133863E+00, 9.2259688922E-01],
	[3.0270000000E+04, 2.0435684452E+01, 4.8757255048E+00, 6.5542226955E+00, 2.4593888101E+00, 9.2263413789E-01],
	[3.0275000000E+04, 2.0441272387E+01, 4.8757176882E+00, 6.5577490316E+00, 2.4599641189E+00, 9.2267136788E-01],
	[3.0280000000E+04, 2.0446860926E+01, 4.8757098729E+00, 6.5612766815E+00, 2.4605393125E+00, 9.2270857920E-01],
	[3.0285000000E+04, 2.0452450070E+01, 4.8757020589E+00, 6.5648056453E+00, 2.4611143909E+00, 9.2274577185E-01],
	[3.0290000000E+04, 2.0458039819E+01, 4.8756942462E+00, 6.5683359234E+00, 2.4616893542E+00, 9.2278294584E-01],
	[3.0295000000E+04, 2.0463630173E+01, 4.8756864348E+00, 6.5718675161E+00, 2.4622642023E+00, 9.2282010117E-01],
	[3.0300000000E+04, 2.0469221131E+01, 4.8756786247E+00, 6.5754004235E+00, 2.4628389351E+00, 9.2285723787E-01],
	[3.0305000000E+04, 2.0474812694E+01, 4.8756708159E+00, 6.5789346461E+00, 2.4634135527E+00, 9.2289435593E-01],
	[3.0310000000E+04, 2.0480404862E+01, 4.8756630084E+00, 6.5824701839E+00, 2.4639880550E+00, 9.2293145536E-01],
	[3.0315000000E+04, 2.0485997634E+01, 4.8756552023E+00, 6.5860070374E+00, 2.4645624419E+00, 9.2296853618E-01],
	[3.0320000000E+04, 2.0491591010E+01, 4.8756473974E+00, 6.5895452068E+00, 2.4651367136E+00, 9.2300559838E-01],
	[3.0325000000E+04, 2.0497184991E+01, 4.8756395938E+00, 6.5930846923E+00, 2.4657108699E+00, 9.2304264199E-01],
	[3.0330000000E+04, 2.0502779577E+01, 4.8756317915E+00, 6.5966254943E+00, 2.4662849108E+00, 9.2307966700E-01],
	[3.0335000000E+04, 2.0508374767E+01, 4.8756239905E+00, 6.6001676130E+00, 2.4668588363E+00, 9.2311667343E-01],
	[3.0340000000E+04, 2.0513970561E+01, 4.8756161908E+00, 6.6037110487E+00, 2.4674326463E+00, 9.2315366128E-01],
	[3.0345000000E+04, 2.0519566960E+01, 4.8756083924E+00, 6.6072558016E+00, 2.4680063409E+00, 9.2319063056E-01],
	[3.0350000000E+04, 2.0525163963E+01, 4.8756005953E+00, 6.6108018720E+00, 2.4685799200E+00, 9.2322758128E-01],
	[3.0355000000E+04, 2.0530761571E+01, 4.8755927995E+00, 6.6143492602E+00, 2.4691533836E+00, 9.2326451345E-01],
	[3.0360000000E+04, 2.0536359782E+01, 4.8755850050E+00, 6.6178979666E+00, 2.4697267317E+00, 9.2330142708E-01],
	[3.0365000000E+04, 2.0541958598E+01, 4.8755772118E+00, 6.6214479912E+00, 2.4702999642E+00, 9.2333832218E-01],
	[3.0370000000E+04, 2.0547558018E+01, 4.8755694199E+00, 6.6249993345E+00, 2.4708730811E+00, 9.2337519874E-01],
	[3.0375000000E+04, 2.0553158042E+01, 4.8755616293E+00, 6.6285519966E+00, 2.4714460824E+00, 9.2341205679E-01],
	[3.0380000000E+04, 2.0558758670E+01, 4.8755538400E+00, 6.6321059779E+00, 2.4720189681E+00, 9.2344889633E-01],
	[3.0385000000E+04, 2.0564359903E+01, 4.8755460520E+00, 6.6356612786E+00, 2.4725917381E+00, 9.2348571737E-01],
	[3.0390000000E+04, 2.0569965059E+01, 4.8755387488E+00, 6.6392178991E+00, 2.4731645649E+00, 9.2352251991E-01],
	[3.0395000000E+04, 2.0575587628E+01, 4.8755338939E+00, 6.6427758395E+00, 2.4737381489E+00, 9.2355930398E-01],
	[3.0400000000E+04, 2.0581210808E+01, 4.8755290398E+00, 6.6463351001E+00, 2.4743116179E+00, 9.2359606956E-01],
	[3.0405000000E+04, 2.0586834600E+01, 4.8755241865E+00, 6.6498956813E+00, 2.4748849717E+00, 9.2363281667E-01],
	[3.0410000000E+04, 2.0592459003E+01, 4.8755193340E+00, 6.6534575832E+00, 2.4754582104E+00, 9.2366954533E-01],
	[3.0415000000E+04, 2.0598084018E+01, 4.8755144823E+00, 6.6570208062E+00, 2.4760313339E+00, 9.2370625554E-01],
	[3.0420000000E+04, 2.0603709644E+01, 4.8755096314E+00, 6.6605853506E+00, 2.4766043422E+00, 9.2374294730E-01],
	[3.0425000000E+04, 2.0609335882E+01, 4.8755047813E+00, 6.6641512165E+00, 2.4771772353E+00, 9.2377962062E-01],
	[3.0430000000E+04, 2.0614962732E+01, 4.8754999320E+00, 6.6677184044E+00, 2.4777500131E+00, 9.2381627553E-01],
	[3.0435000000E+04, 2.0620590192E+01, 4.8754950835E+00, 6.6712869144E+00, 2.4783226757E+00, 9.2385291201E-01],
	[3.0440000000E+04, 2.0626218264E+01, 4.8754902358E+00, 6.6748567468E+00, 2.4788952230E+00, 9.2388953008E-01],
	[3.0445000000E+04, 2.0631846948E+01, 4.8754853889E+00, 6.6784279019E+00, 2.4794676550E+00, 9.2392612975E-01],
	[3.0450000000E+04, 2.0637476243E+01, 4.8754805428E+00, 6.6820003800E+00, 2.4800399717E+00, 9.2396271103E-01],
	[3.0455000000E+04, 2.0643106149E+01, 4.8754756976E+00, 6.6855741813E+00, 2.4806121730E+00, 9.2399927393E-01],
	[3.0460000000E+04, 2.0648736666E+01, 4.8754708531E+00, 6.6891493061E+00, 2.4811842589E+00, 9.2403581845E-01],
	[3.0465000000E+04, 2.0654367794E+01, 4.8754660094E+00, 6.6927257547E+00, 2.4817562294E+00, 9.2407234460E-01],
	[3.0470000000E+04, 2.0659999534E+01, 4.8754611665E+00, 6.6963035274E+00, 2.4823280845E+00, 9.2410885239E-01],
	[3.0475000000E+04, 2.0665631885E+01, 4.8754563244E+00, 6.6998826244E+00, 2.4828998241E+00, 9.2414534183E-01],
	[3.0480000000E+04, 2.0671264847E+01, 4.8754514831E+00, 6.7034630460E+00, 2.4834714482E+00, 9.2418181293E-01],
	[3.0485000000E+04, 2.0676898420E+01, 4.8754466426E+00, 6.7070447925E+00, 2.4840429568E+00, 9.2421826569E-01],
	[3.0490000000E+04, 2.0682532604E+01, 4.8754418030E+00, 6.7106278641E+00, 2.4846143499E+00, 9.2425470013E-01],
	[3.0495000000E+04, 2.0688167399E+01, 4.8754369641E+00, 6.7142122612E+00, 2.4851856274E+00, 9.2429111625E-01],
	[3.0500000000E+04, 2.0693802805E+01, 4.8754321260E+00, 6.7177979839E+00, 2.4857567894E+00, 9.2432751406E-01],
	[3.0505000000E+04, 2.0699438821E+01, 4.8754272887E+00, 6.7213850326E+00, 2.4863278358E+00, 9.2436389357E-01],
	[3.0510000000E+04, 2.0705075449E+01, 4.8754224522E+00, 6.7249734076E+00, 2.4868987665E+00, 9.2440025478E-01],
	[3.0515000000E+04, 2.0710712688E+01, 4.8754176165E+00, 6.7285631090E+00, 2.4874695816E+00, 9.2443659772E-01],
	[3.0520000000E+04, 2.0716350537E+01, 4.8754127816E+00, 6.7321541373E+00, 2.4880402810E+00, 9.2447292237E-01],
	[3.0525000000E+04, 2.0721988998E+01, 4.8754079475E+00, 6.7357464925E+00, 2.4886108647E+00, 9.2450922876E-01],
	[3.0530000000E+04, 2.0727628069E+01, 4.8754031142E+00, 6.7393401752E+00, 2.4891813327E+00, 9.2454551689E-01],
	[3.0535000000E+04, 2.0733267750E+01, 4.8753982817E+00, 6.7429351854E+00, 2.4897516850E+00, 9.2458178677E-01],
	[3.0540000000E+04, 2.0738908043E+01, 4.8753934499E+00, 6.7465315235E+00, 2.4903219215E+00, 9.2461803841E-01],
	[3.0545000000E+04, 2.0744548946E+01, 4.8753886190E+00, 6.7501291897E+00, 2.4908920422E+00, 9.2465427182E-01],
	[3.0550000000E+04, 2.0750190460E+01, 4.8753837889E+00, 6.7537281843E+00, 2.4914620472E+00, 9.2469048700E-01],
	[3.0555000000E+04, 2.0755832584E+01, 4.8753789596E+00, 6.7573285077E+00, 2.4920319362E+00, 9.2472668396E-01],
	[3.0560000000E+04, 2.0761475319E+01, 4.8753741310E+00, 6.7609301600E+00, 2.4926017095E+00, 9.2476286271E-01],
	[3.0565000000E+04, 2.0767118664E+01, 4.8753693033E+00, 6.7645331415E+00, 2.4931713668E+00, 9.2479902327E-01],
	[3.0570000000E+04, 2.0772762620E+01, 4.8753644763E+00, 6.7681374526E+00, 2.4937409083E+00, 9.2483516563E-01],
	[3.0575000000E+04, 2.0778407186E+01, 4.8753596502E+00, 6.7717430934E+00, 2.4943103338E+00, 9.2487128981E-01],
	[3.0580000000E+04, 2.0784052363E+01, 4.8753548248E+00, 6.7753500642E+00, 2.4948796434E+00, 9.2490739581E-01],
	[3.0585000000E+04, 2.0789698150E+01, 4.8753500003E+00, 6.7789583655E+00, 2.4954488370E+00, 9.2494348365E-01],
	[3.0590000000E+04, 2.0795344548E+01, 4.8753451765E+00, 6.7825679972E+00, 2.4960179146E+00, 9.2497955333E-01],
	[3.0595000000E+04, 2.0800991556E+01, 4.8753403535E+00, 6.7861789599E+00, 2.4965868762E+00, 9.2501560485E-01],
	[3.0600000000E+04, 2.0806639174E+01, 4.8753355313E+00, 6.7897912537E+00, 2.4971557217E+00, 9.2505163824E-01],
	[3.0605000000E+04, 2.0812287402E+01, 4.8753307099E+00, 6.7934048790E+00, 2.4977244512E+00, 9.2508765350E-01],
	[3.0610000000E+04, 2.0817936241E+01, 4.8753258893E+00, 6.7970198359E+00, 2.4982930647E+00, 9.2512365063E-01],
	[3.0615000000E+04, 2.0823585690E+01, 4.8753210695E+00, 6.8006361248E+00, 2.4988615620E+00, 9.2515962964E-01],
	[3.0620000000E+04, 2.0829235749E+01, 4.8753162505E+00, 6.8042537459E+00, 2.4994299432E+00, 9.2519559055E-01],
	[3.0625000000E+04, 2.0834886418E+01, 4.8753114323E+00, 6.8078726995E+00, 2.4999982082E+00, 9.2523153335E-01],
	[3.0630000000E+04, 2.0840537697E+01, 4.8753066149E+00, 6.8114929859E+00, 2.5005663571E+00, 9.2526745807E-01],
	[3.0635000000E+04, 2.0846189586E+01, 4.8753017982E+00, 6.8151146053E+00, 2.5011343898E+00, 9.2530336470E-01],
	[3.0640000000E+04, 2.0851842085E+01, 4.8752969824E+00, 6.8187375581E+00, 2.5017023063E+00, 9.2533925326E-01],
	[3.0645000000E+04, 2.0857495195E+01, 4.8752921673E+00, 6.8223618445E+00, 2.5022701065E+00, 9.2537512375E-01],
	[3.0650000000E+04, 2.0863148914E+01, 4.8752873530E+00, 6.8259874647E+00, 2.5028377905E+00, 9.2541097619E-01],
	[3.0655000000E+04, 2.0868803243E+01, 4.8752825395E+00, 6.8296144191E+00, 2.5034053581E+00, 9.2544681057E-01],
	[3.0660000000E+04, 2.0874458182E+01, 4.8752777269E+00, 6.8332427079E+00, 2.5039728095E+00, 9.2548262692E-01],
	[3.0665000000E+04, 2.0880113731E+01, 4.8752729150E+00, 6.8368723314E+00, 2.5045401446E+00, 9.2551842524E-01],
	[3.0670000000E+04, 2.0885769889E+01, 4.8752681038E+00, 6.8405032899E+00, 2.5051073633E+00, 9.2555420553E-01],
	[3.0675000000E+04, 2.0891426658E+01, 4.8752632935E+00, 6.8441355836E+00, 2.5056744657E+00, 9.2558996780E-01],
	[3.0680000000E+04, 2.0897084036E+01, 4.8752584840E+00, 6.8477692127E+00, 2.5062414516E+00, 9.2562571207E-01],
	[3.0685000000E+04, 2.0902742024E+01, 4.8752536752E+00, 6.8514041777E+00, 2.5068083212E+00, 9.2566143834E-01],
	[3.0690000000E+04, 2.0908400621E+01, 4.8752488673E+00, 6.8550404788E+00, 2.5073750743E+00, 9.2569714662E-01],
	[3.0695000000E+04, 2.0914059829E+01, 4.8752440601E+00, 6.8586781161E+00, 2.5079417110E+00, 9.2573283692E-01],
	[3.0700000000E+04, 2.0919719645E+01, 4.8752392537E+00, 6.8623170901E+00, 2.5085082312E+00, 9.2576850925E-01],
	[3.0705000000E+04, 2.0925380072E+01, 4.8752344481E+00, 6.8659574009E+00, 2.5090746348E+00, 9.2580416361E-01],
	[3.0710000000E+04, 2.0931041108E+01, 4.8752296433E+00, 6.8695990489E+00, 2.5096409220E+00, 9.2583980001E-01],
	[3.0715000000E+04, 2.0936702753E+01, 4.8752248393E+00, 6.8732420342E+00, 2.5102070927E+00, 9.2587541847E-01],
	[3.0720000000E+04, 2.0942365008E+01, 4.8752200361E+00, 6.8768863573E+00, 2.5107731467E+00, 9.2591101899E-01],
	[3.0725000000E+04, 2.0948027873E+01, 4.8752152336E+00, 6.8805320184E+00, 2.5113390842E+00, 9.2594660157E-01],
	[3.0730000000E+04, 2.0953691347E+01, 4.8752104320E+00, 6.8841790176E+00, 2.5119049051E+00, 9.2598216624E-01],
	[3.0735000000E+04, 2.0959355430E+01, 4.8752056311E+00, 6.8878273554E+00, 2.5124706094E+00, 9.2601771299E-01],
	[3.0740000000E+04, 2.0965020122E+01, 4.8752008310E+00, 6.8914770320E+00, 2.5130361970E+00, 9.2605324183E-01],
	[3.0745000000E+04, 2.0970685424E+01, 4.8751960317E+00, 6.8951280476E+00, 2.5136016680E+00, 9.2608875278E-01],
	[3.0750000000E+04, 2.0976351335E+01, 4.8751912332E+00, 6.8987804026E+00, 2.5141670222E+00, 9.2612424584E-01],
	[3.0755000000E+04, 2.0982017856E+01, 4.8751864355E+00, 6.9024340971E+00, 2.5147322598E+00, 9.2615972101E-01],
	[3.0760000000E+04, 2.0987684985E+01, 4.8751816385E+00, 6.9060891316E+00, 2.5152973806E+00, 9.2619517832E-01],
	[3.0765000000E+04, 2.0993352724E+01, 4.8751768423E+00, 6.9097455061E+00, 2.5158623847E+00, 9.2623061776E-01],
	[3.0770000000E+04, 2.0999021072E+01, 4.8751720470E+00, 6.9134032211E+00, 2.5164272720E+00, 9.2626603935E-01],
	[3.0775000000E+04, 2.1004690029E+01, 4.8751672524E+00, 6.9170622768E+00, 2.5169920425E+00, 9.2630144309E-01],
	[3.0780000000E+04, 2.1010359595E+01, 4.8751624586E+00, 6.9207226735E+00, 2.5175566963E+00, 9.2633682899E-01],
	[3.0785000000E+04, 2.1016029770E+01, 4.8751576655E+00, 6.9243844114E+00, 2.5181212331E+00, 9.2637219707E-01],
	[3.0790000000E+04, 2.1021700554E+01, 4.8751528733E+00, 6.9280474908E+00, 2.5186856532E+00, 9.2640754732E-01],
	[3.0795000000E+04, 2.1027371947E+01, 4.8751480818E+00, 6.9317119120E+00, 2.5192499563E+00, 9.2644287976E-01],
	[3.0800000000E+04, 2.1033043949E+01, 4.8751432911E+00, 6.9353776752E+00, 2.5198141426E+00, 9.2647819439E-01],
	[3.0805000000E+04, 2.1038716560E+01, 4.8751385012E+00, 6.9390447808E+00, 2.5203782120E+00, 9.2651349123E-01],
	[3.0810000000E+04, 2.1044389780E+01, 4.8751337121E+00, 6.9427132290E+00, 2.5209421644E+00, 9.2654877028E-01],
	[3.0815000000E+04, 2.1050063609E+01, 4.8751289238E+00, 6.9463830201E+00, 2.5215059998E+00, 9.2658403155E-01],
	[3.0820000000E+04, 2.1055738047E+01, 4.8751241362E+00, 6.9500541543E+00, 2.5220697183E+00, 9.2661927505E-01],
	[3.0825000000E+04, 2.1061413093E+01, 4.8751193495E+00, 6.9537266319E+00, 2.5226333198E+00, 9.2665450079E-01],
	[3.0830000000E+04, 2.1067088748E+01, 4.8751145635E+00, 6.9574004533E+00, 2.5231968043E+00, 9.2668970878E-01],
	[3.0835000000E+04, 2.1072765012E+01, 4.8751097783E+00, 6.9610756186E+00, 2.5237601718E+00, 9.2672489902E-01],
	[3.0840000000E+04, 2.1078441884E+01, 4.8751049938E+00, 6.9647521281E+00, 2.5243234222E+00, 9.2676007152E-01],
	[3.0845000000E+04, 2.1084119365E+01, 4.8751002102E+00, 6.9684299822E+00, 2.5248865555E+00, 9.2679522629E-01],
	[3.0850000000E+04, 2.1089797455E+01, 4.8750954273E+00, 6.9721091811E+00, 2.5254495718E+00, 9.2683036335E-01],
	[3.0855000000E+04, 2.1095476153E+01, 4.8750906452E+00, 6.9757897250E+00, 2.5260124709E+00, 9.2686548269E-01],
	[3.0860000000E+04, 2.1101155460E+01, 4.8750858639E+00, 6.9794716142E+00, 2.5265752529E+00, 9.2690058433E-01],
	[3.0865000000E+04, 2.1106835375E+01, 4.8750810834E+00, 6.9831548491E+00, 2.5271379177E+00, 9.2693566828E-01],
	[3.0870000000E+04, 2.1112515899E+01, 4.8750763036E+00, 6.9868394299E+00, 2.5277004654E+00, 9.2697073454E-01],
	[3.0875000000E+04, 2.1118197031E+01, 4.8750715247E+00, 6.9905253568E+00, 2.5282628959E+00, 9.2700578312E-01],
	[3.0880000000E+04, 2.1123885149E+01, 4.8750676656E+00, 6.9942126301E+00, 2.5288255478E+00, 9.2704081403E-01],
	[3.0885000000E+04, 2.1129587425E+01, 4.8750657589E+00, 6.9979012502E+00, 2.5293888023E+00, 9.2707582728E-01],
	[3.0890000000E+04, 2.1135290318E+01, 4.8750638525E+00, 7.0015912172E+00, 2.5299519402E+00, 9.2711082288E-01],
	[3.0895000000E+04, 2.1140993825E+01, 4.8750619464E+00, 7.0052825315E+00, 2.5305149614E+00, 9.2714580084E-01],
	[3.0900000000E+04, 2.1146697949E+01, 4.8750600406E+00, 7.0089751933E+00, 2.5310778659E+00, 9.2718076116E-01],
	[3.0905000000E+04, 2.1152402689E+01, 4.8750581351E+00, 7.0126692029E+00, 2.5316406538E+00, 9.2721570385E-01],
	[3.0910000000E+04, 2.1158108044E+01, 4.8750562300E+00, 7.0163645605E+00, 2.5322033249E+00, 9.2725062892E-01],
	[3.0915000000E+04, 2.1163814015E+01, 4.8750543251E+00, 7.0200612665E+00, 2.5327658793E+00, 9.2728553639E-01],
	[3.0920000000E+04, 2.1169520601E+01, 4.8750524206E+00, 7.0237593211E+00, 2.5333283169E+00, 9.2732042625E-01],
	[3.0925000000E+04, 2.1175227803E+01, 4.8750505164E+00, 7.0274587247E+00, 2.5338906378E+00, 9.2735529852E-01],
	[3.0930000000E+04, 2.1180935621E+01, 4.8750486124E+00, 7.0311594773E+00, 2.5344528419E+00, 9.2739015320E-01],
	[3.0935000000E+04, 2.1186644054E+01, 4.8750467088E+00, 7.0348615794E+00, 2.5350149292E+00, 9.2742499031E-01],
	[3.0940000000E+04, 2.1192353103E+01, 4.8750448055E+00, 7.0385650313E+00, 2.5355768997E+00, 9.2745980985E-01],
	[3.0945000000E+04, 2.1198062767E+01, 4.8750429025E+00, 7.0422698331E+00, 2.5361387533E+00, 9.2749461183E-01],
	[3.0950000000E+04, 2.1203773047E+01, 4.8750409998E+00, 7.0459759851E+00, 2.5367004901E+00, 9.2752939626E-01],
	[3.0955000000E+04, 2.1209483942E+01, 4.8750390975E+00, 7.0496834877E+00, 2.5372621100E+00, 9.2756416315E-01],
	[3.0960000000E+04, 2.1215195453E+01, 4.8750371954E+00, 7.0533923411E+00, 2.5378236129E+00, 9.2759891250E-01],
	[3.0965000000E+04, 2.1220907579E+01, 4.8750352936E+00, 7.0571025456E+00, 2.5383849990E+00, 9.2763364433E-01],
	[3.0970000000E+04, 2.1226620320E+01, 4.8750333922E+00, 7.0608141014E+00, 2.5389462681E+00, 9.2766835864E-01],
	[3.0975000000E+04, 2.1232333677E+01, 4.8750314910E+00, 7.0645270089E+00, 2.5395074203E+00, 9.2770305545E-01],
	[3.0980000000E+04, 2.1238047648E+01, 4.8750295902E+00, 7.0682412682E+00, 2.5400684555E+00, 9.2773773475E-01],
	[3.0985000000E+04, 2.1243762235E+01, 4.8750276896E+00, 7.0719568798E+00, 2.5406293736E+00, 9.2777239656E-01],
	[3.0990000000E+04, 2.1249477437E+01, 4.8750257894E+00, 7.0756738437E+00, 2.5411901748E+00, 9.2780704089E-01],
	[3.0995000000E+04, 2.1255193255E+01, 4.8750238895E+00, 7.0793921604E+00, 2.5417508590E+00, 9.2784166774E-01],
	[3.1000000000E+04, 2.1260909687E+01, 4.8750219899E+00, 7.0831118301E+00, 2.5423114261E+00, 9.2787627713E-01],
	[3.1005000000E+04, 2.1266626735E+01, 4.8750200906E+00, 7.0868328530E+00, 2.5428718761E+00, 9.2791086905E-01],
	[3.1010000000E+04, 2.1272344397E+01, 4.8750181916E+00, 7.0905552295E+00, 2.5434322090E+00, 9.2794544353E-01],
	[3.1015000000E+04, 2.1278062675E+01, 4.8750162929E+00, 7.0942789598E+00, 2.5439924249E+00, 9.2798000057E-01],
	[3.1020000000E+04, 2.1283781568E+01, 4.8750143945E+00, 7.0980040442E+00, 2.5445525236E+00, 9.2801454018E-01],
	[3.1025000000E+04, 2.1289501075E+01, 4.8750124964E+00, 7.1017304829E+00, 2.5451125051E+00, 9.2804906236E-01],
	[3.1030000000E+04, 2.1295221198E+01, 4.8750105986E+00, 7.1054582763E+00, 2.5456723696E+00, 9.2808356712E-01],
	[3.1035000000E+04, 2.1300941935E+01, 4.8750087012E+00, 7.1091874246E+00, 2.5462321168E+00, 9.2811805448E-01],
	[3.1040000000E+04, 2.1306663288E+01, 4.8750068040E+00, 7.1129179280E+00, 2.5467917468E+00, 9.2815252444E-01],
	[3.1045000000E+04, 2.1312385255E+01, 4.8750049072E+00, 7.1166497869E+00, 2.5473512596E+00, 9.2818697701E-01],
	[3.1050000000E+04, 2.1318107837E+01, 4.8750030106E+00, 7.1203830016E+00, 2.5479106552E+00, 9.2822141220E-01],
	[3.1055000000E+04, 2.1323831033E+01, 4.8750011144E+00, 7.1241175722E+00, 2.5484699336E+00, 9.2825583002E-01],
	[3.1060000000E+04, 2.1329554845E+01, 4.8749992184E+00, 7.1278534991E+00, 2.5490290946E+00, 9.2829023047E-01],
	[3.1065000000E+04, 2.1335279271E+01, 4.8749973228E+00, 7.1315907826E+00, 2.5495881384E+00, 9.2832461356E-01],
	[3.1070000000E+04, 2.1341004311E+01, 4.8749954275E+00, 7.1353294229E+00, 2.5501470649E+00, 9.2835897931E-01],
	[3.1075000000E+04, 2.1346729967E+01, 4.8749935325E+00, 7.1390694203E+00, 2.5507058741E+00, 9.2839332771E-01],
	[3.1080000000E+04, 2.1352456237E+01, 4.8749916378E+00, 7.1428107750E+00, 2.5512645659E+00, 9.2842765879E-01],
	[3.1085000000E+04, 2.1358183121E+01, 4.8749897434E+00, 7.1465534874E+00, 2.5518231403E+00, 9.2846197254E-01],
	[3.1090000000E+04, 2.1363910620E+01, 4.8749878493E+00, 7.1502975578E+00, 2.5523815974E+00, 9.2849626898E-01],
	[3.1095000000E+04, 2.1369638734E+01, 4.8749859555E+00, 7.1540429863E+00, 2.5529399371E+00, 9.2853054812E-01],
	[3.1100000000E+04, 2.1375367462E+01, 4.8749840620E+00, 7.1577897733E+00, 2.5534981594E+00, 9.2856480995E-01],
	[3.1105000000E+04, 2.1381096804E+01, 4.8749821688E+00, 7.1615379190E+00, 2.5540562643E+00, 9.2859905450E-01],
	[3.1110000000E+04, 2.1386826761E+01, 4.8749802759E+00, 7.1652874237E+00, 2.5546142517E+00, 9.2863328177E-01],
	[3.1115000000E+04, 2.1392557332E+01, 4.8749783833E+00, 7.1690382877E+00, 2.5551721217E+00, 9.2866749176E-01],
	[3.1120000000E+04, 2.1398288518E+01, 4.8749764911E+00, 7.1727905113E+00, 2.5557298742E+00, 9.2870168450E-01],
	[3.1125000000E+04, 2.1404020318E+01, 4.8749745991E+00, 7.1765440947E+00, 2.5562875091E+00, 9.2873585998E-01],
	[3.1130000000E+04, 2.1409752732E+01, 4.8749727074E+00, 7.1802990382E+00, 2.5568450266E+00, 9.2877001821E-01],
	[3.1135000000E+04, 2.1415485760E+01, 4.8749708161E+00, 7.1840553421E+00, 2.5574024266E+00, 9.2880415920E-01],
	[3.1140000000E+04, 2.1421219403E+01, 4.8749689250E+00, 7.1878130067E+00, 2.5579597090E+00, 9.2883828296E-01],
	[3.1145000000E+04, 2.1426953659E+01, 4.8749670343E+00, 7.1915720322E+00, 2.5585168738E+00, 9.2887238951E-01],
	[3.1150000000E+04, 2.1432688530E+01, 4.8749651439E+00, 7.1953324189E+00, 2.5590739211E+00, 9.2890647884E-01],
	[3.1155000000E+04, 2.1438424015E+01, 4.8749632537E+00, 7.1990941670E+00, 2.5596308507E+00, 9.2894055097E-01],
	[3.1160000000E+04, 2.1444160114E+01, 4.8749613639E+00, 7.2028572769E+00, 2.5601876628E+00, 9.2897460590E-01],
	[3.1165000000E+04, 2.1449896827E+01, 4.8749594744E+00, 7.2066217489E+00, 2.5607443572E+00, 9.2900864364E-01],
	[3.1170000000E+04, 2.1455634154E+01, 4.8749575851E+00, 7.2103875831E+00, 2.5613009339E+00, 9.2904266421E-01],
	[3.1175000000E+04, 2.1461372096E+01, 4.8749556962E+00, 7.2141547799E+00, 2.5618573930E+00, 9.2907666760E-01],
	[3.1180000000E+04, 2.1467110651E+01, 4.8749538076E+00, 7.2179233396E+00, 2.5624137344E+00, 9.2911065383E-01],
	[3.1185000000E+04, 2.1472849819E+01, 4.8749519193E+00, 7.2216932624E+00, 2.5629699582E+00, 9.2914462291E-01],
	[3.1190000000E+04, 2.1478589602E+01, 4.8749500313E+00, 7.2254645486E+00, 2.5635260642E+00, 9.2917857485E-01],
	[3.1195000000E+04, 2.1484329999E+01, 4.8749481435E+00, 7.2292371984E+00, 2.5640820524E+00, 9.2921250965E-01],
	[3.1200000000E+04, 2.1490071009E+01, 4.8749462561E+00, 7.2330112122E+00, 2.5646379230E+00, 9.2924642732E-01],
	[3.1205000000E+04, 2.1495812633E+01, 4.8749443690E+00, 7.2367865902E+00, 2.5651936757E+00, 9.2928032787E-01],
	[3.1210000000E+04, 2.1501554871E+01, 4.8749424822E+00, 7.2405633327E+00, 2.5657493107E+00, 9.2931421131E-01],
	[3.1215000000E+04, 2.1507297723E+01, 4.8749405957E+00, 7.2443414400E+00, 2.5663048279E+00, 9.2934807765E-01],
	[3.1220000000E+04, 2.1513041188E+01, 4.8749387096E+00, 7.2481209123E+00, 2.5668602273E+00, 9.2938192689E-01],
	[3.1225000000E+04, 2.1518785267E+01, 4.8749368237E+00, 7.2519017499E+00, 2.5674155088E+00, 9.2941575905E-01],
	[3.1230000000E+04, 2.1524529960E+01, 4.8749349381E+00, 7.2556839531E+00, 2.5679706725E+00, 9.2944957413E-01],
	[3.1235000000E+04, 2.1530275266E+01, 4.8749330528E+00, 7.2594675221E+00, 2.5685257184E+00, 9.2948337214E-01],
	[3.1240000000E+04, 2.1536021186E+01, 4.8749311678E+00, 7.2632524573E+00, 2.5690806463E+00, 9.2951715309E-01],
	[3.1245000000E+04, 2.1541767719E+01, 4.8749292831E+00, 7.2670387589E+00, 2.5696354564E+00, 9.2955091699E-01],
	[3.1250000000E+04, 2.1547514866E+01, 4.8749273988E+00, 7.2708264272E+00, 2.5701901486E+00, 9.2958466385E-01],
	[3.1255000000E+04, 2.1553262626E+01, 4.8749255147E+00, 7.2746154625E+00, 2.5707447228E+00, 9.2961839367E-01],
	[3.1260000000E+04, 2.1559010999E+01, 4.8749236309E+00, 7.2784058650E+00, 2.5712991791E+00, 9.2965210647E-01],
	[3.1265000000E+04, 2.1564759986E+01, 4.8749217474E+00, 7.2821976349E+00, 2.5718535174E+00, 9.2968580224E-01],
	[3.1270000000E+04, 2.1570509587E+01, 4.8749198643E+00, 7.2859907727E+00, 2.5724077378E+00, 9.2971948101E-01],
	[3.1275000000E+04, 2.1576259800E+01, 4.8749179814E+00, 7.2897852785E+00, 2.5729618402E+00, 9.2975314278E-01],
	[3.1280000000E+04, 2.1582010627E+01, 4.8749160988E+00, 7.2935811527E+00, 2.5735158246E+00, 9.2978678755E-01],
	[3.1285000000E+04, 2.1587762067E+01, 4.8749142166E+00, 7.2973783954E+00, 2.5740696909E+00, 9.2982041534E-01],
	[3.1290000000E+04, 2.1593514121E+01, 4.8749123346E+00, 7.3011770071E+00, 2.5746234393E+00, 9.2985402616E-01],
	[3.1295000000E+04, 2.1599266787E+01, 4.8749104529E+00, 7.3049769878E+00, 2.5751770695E+00, 9.2988762000E-01],
	[3.1300000000E+04, 2.1605020067E+01, 4.8749085716E+00, 7.3087783380E+00, 2.5757305817E+00, 9.2992119689E-01],
	[3.1305000000E+04, 2.1610773960E+01, 4.8749066905E+00, 7.3125810579E+00, 2.5762839759E+00, 9.2995475683E-01],
	[3.1310000000E+04, 2.1616528466E+01, 4.8749048098E+00, 7.3163851478E+00, 2.5768372519E+00, 9.2998829982E-01],
	[3.1315000000E+04, 2.1622283585E+01, 4.8749029293E+00, 7.3201906079E+00, 2.5773904098E+00, 9.3002182589E-01],
	[3.1320000000E+04, 2.1628039317E+01, 4.8749010491E+00, 7.3239974386E+00, 2.5779434496E+00, 9.3005533502E-01],
	[3.1325000000E+04, 2.1633795662E+01, 4.8748991693E+00, 7.3278056400E+00, 2.5784963713E+00, 9.3008882724E-01],
	[3.1330000000E+04, 2.1639552619E+01, 4.8748972897E+00, 7.3316152125E+00, 2.5790491748E+00, 9.3012230255E-01],
	[3.1335000000E+04, 2.1645310190E+01, 4.8748954105E+00, 7.3354261564E+00, 2.5796018601E+00, 9.3015576097E-01],
	[3.1340000000E+04, 2.1651068374E+01, 4.8748935315E+00, 7.3392384718E+00, 2.5801544272E+00, 9.3018920249E-01],
	[3.1345000000E+04, 2.1656827171E+01, 4.8748916529E+00, 7.3430521592E+00, 2.5807068761E+00, 9.3022262713E-01],
	[3.1350000000E+04, 2.1662586580E+01, 4.8748897745E+00, 7.3468672188E+00, 2.5812592069E+00, 9.3025603489E-01],
	[3.1355000000E+04, 2.1668346603E+01, 4.8748878965E+00, 7.3506836507E+00, 2.5818114193E+00, 9.3028942579E-01],
	[3.1360000000E+04, 2.1674107238E+01, 4.8748860187E+00, 7.3545014554E+00, 2.5823635136E+00, 9.3032279983E-01],
	[3.1365000000E+04, 2.1679868485E+01, 4.8748841413E+00, 7.3583206331E+00, 2.5829154895E+00, 9.3035615702E-01],
	[3.1370000000E+04, 2.1685630346E+01, 4.8748822641E+00, 7.3621411840E+00, 2.5834673472E+00, 9.3038949737E-01],
	[3.1375000000E+04, 2.1691392819E+01, 4.8748803873E+00, 7.3659631085E+00, 2.5840190866E+00, 9.3042282089E-01],
	[3.1380000000E+04, 2.1697173652E+01, 4.8748810422E+00, 7.3697864068E+00, 2.5845716711E+00, 9.3045612758E-01],
	[3.1385000000E+04, 2.1702957075E+01, 4.8748819779E+00, 7.3736110792E+00, 2.5851242448E+00, 9.3048941746E-01],
	[3.1390000000E+04, 2.1708741118E+01, 4.8748829136E+00, 7.3774371260E+00, 2.5856767008E+00, 9.3052269054E-01],
	[3.1395000000E+04, 2.1714525781E+01, 4.8748838490E+00, 7.3812645474E+00, 2.5862290390E+00, 9.3055594681E-01],
	[3.1400000000E+04, 2.1720311063E+01, 4.8748847844E+00, 7.3850933437E+00, 2.5867812594E+00, 9.3058918630E-01],
	[3.1405000000E+04, 2.1726096966E+01, 4.8748857195E+00, 7.3889235151E+00, 2.5873333620E+00, 9.3062240900E-01],
	[3.1410000000E+04, 2.1731883488E+01, 4.8748866546E+00, 7.3927550621E+00, 2.5878853469E+00, 9.3065561493E-01],
	[3.1415000000E+04, 2.1737670630E+01, 4.8748875894E+00, 7.3965879848E+00, 2.5884372139E+00, 9.3068880409E-01],
	[3.1420000000E+04, 2.1743458392E+01, 4.8748885242E+00, 7.4004222835E+00, 2.5889889631E+00, 9.3072197650E-01],
	[3.1425000000E+04, 2.1749246773E+01, 4.8748894587E+00, 7.4042579584E+00, 2.5895405944E+00, 9.3075513216E-01],
	[3.1430000000E+04, 2.1755035774E+01, 4.8748903932E+00, 7.4080950100E+00, 2.5900921079E+00, 9.3078827108E-01],
	[3.1435000000E+04, 2.1760825395E+01, 4.8748913274E+00, 7.4119334383E+00, 2.5906435036E+00, 9.3082139327E-01],
	[3.1440000000E+04, 2.1766615635E+01, 4.8748922616E+00, 7.4157732438E+00, 2.5911947813E+00, 9.3085449874E-01],
	[3.1445000000E+04, 2.1772406495E+01, 4.8748931956E+00, 7.4196144267E+00, 2.5917459411E+00, 9.3088758750E-01],
	[3.1450000000E+04, 2.1778197975E+01, 4.8748941294E+00, 7.4234569872E+00, 2.5922969831E+00, 9.3092065955E-01],
	[3.1455000000E+04, 2.1783990074E+01, 4.8748950631E+00, 7.4273009256E+00, 2.5928479071E+00, 9.3095371490E-01],
	[3.1460000000E+04, 2.1789782792E+01, 4.8748959966E+00, 7.4311462422E+00, 2.5933987131E+00, 9.3098675356E-01],
	[3.1465000000E+04, 2.1795576130E+01, 4.8748969300E+00, 7.4349929374E+00, 2.5939494012E+00, 9.3101977554E-01],
	[3.1470000000E+04, 2.1801370087E+01, 4.8748978633E+00, 7.4388410112E+00, 2.5944999713E+00, 9.3105278085E-01],
	[3.1475000000E+04, 2.1807164664E+01, 4.8748987964E+00, 7.4426904642E+00, 2.5950504235E+00, 9.3108576950E-01],
	[3.1480000000E+04, 2.1812959860E+01, 4.8748997293E+00, 7.4465412964E+00, 2.5956007576E+00, 9.3111874149E-01],
	[3.1485000000E+04, 2.1818755675E+01, 4.8749006621E+00, 7.4503935082E+00, 2.5961509738E+00, 9.3115169684E-01],
	[3.1490000000E+04, 2.1824552109E+01, 4.8749015948E+00, 7.4542470998E+00, 2.5967010719E+00, 9.3118463554E-01],
	[3.1495000000E+04, 2.1830349163E+01, 4.8749025273E+00, 7.4581020716E+00, 2.5972510519E+00, 9.3121755762E-01],
	[3.1500000000E+04, 2.1836146836E+01, 4.8749034596E+00, 7.4619584237E+00, 2.5978009140E+00, 9.3125046307E-01],
	[3.1505000000E+04, 2.1841945128E+01, 4.8749043918E+00, 7.4658161566E+00, 2.5983506579E+00, 9.3128335192E-01],
	[3.1510000000E+04, 2.1847744039E+01, 4.8749053239E+00, 7.4696752704E+00, 2.5989002838E+00, 9.3131622416E-01],
	[3.1515000000E+04, 2.1853543570E+01, 4.8749062558E+00, 7.4735357654E+00, 2.5994497915E+00, 9.3134907980E-01],
	[3.1520000000E+04, 2.1859343719E+01, 4.8749071876E+00, 7.4773976419E+00, 2.5999991812E+00, 9.3138191885E-01],
	[3.1525000000E+04, 2.1865144488E+01, 4.8749081192E+00, 7.4812609002E+00, 2.6005484527E+00, 9.3141474133E-01],
	[3.1530000000E+04, 2.1870945875E+01, 4.8749090507E+00, 7.4851255406E+00, 2.6010976061E+00, 9.3144754723E-01],
	[3.1535000000E+04, 2.1876747882E+01, 4.8749099820E+00, 7.4889915633E+00, 2.6016466414E+00, 9.3148033657E-01],
	[3.1540000000E+04, 2.1882550507E+01, 4.8749109132E+00, 7.4928589685E+00, 2.6021955585E+00, 9.3151310936E-01],
	[3.1545000000E+04, 2.1888353752E+01, 4.8749118442E+00, 7.4967277567E+00, 2.6027443574E+00, 9.3154586560E-01],
	[3.1550000000E+04, 2.1894157615E+01, 4.8749127751E+00, 7.5005979280E+00, 2.6032930382E+00, 9.3157860531E-01],
	[3.1555000000E+04, 2.1899962097E+01, 4.8749137058E+00, 7.5044694827E+00, 2.6038416007E+00, 9.3161132848E-01],
	[3.1560000000E+04, 2.1905767198E+01, 4.8749146364E+00, 7.5083424211E+00, 2.6043900450E+00, 9.3164403514E-01],
	[3.1565000000E+04, 2.1911572918E+01, 4.8749155668E+00, 7.5122167435E+00, 2.6049383711E+00, 9.3167672528E-01],
	[3.1570000000E+04, 2.1917379257E+01, 4.8749164971E+00, 7.5160924502E+00, 2.6054865789E+00, 9.3170939892E-01],
	[3.1575000000E+04, 2.1923186214E+01, 4.8749174273E+00, 7.5199695413E+00, 2.6060346685E+00, 9.3174205607E-01],
	[3.1580000000E+04, 2.1928993790E+01, 4.8749183573E+00, 7.5238480173E+00, 2.6065826399E+00, 9.3177469673E-01],
	[3.1585000000E+04, 2.1934801985E+01, 4.8749192871E+00, 7.5277278783E+00, 2.6071304929E+00, 9.3180732091E-01],
	[3.1590000000E+04, 2.1940610798E+01, 4.8749202168E+00, 7.5316091247E+00, 2.6076782277E+00, 9.3183992861E-01],
	[3.1595000000E+04, 2.1946420230E+01, 4.8749211464E+00, 7.5354917567E+00, 2.6082258441E+00, 9.3187251986E-01],
	[3.1600000000E+04, 2.1952230280E+01, 4.8749220758E+00, 7.5393757746E+00, 2.6087733422E+00, 9.3190509465E-01],
	[3.1605000000E+04, 2.1958040949E+01, 4.8749230051E+00, 7.5432611787E+00, 2.6093207220E+00, 9.3193765299E-01],
	[3.1610000000E+04, 2.1963852237E+01, 4.8749239342E+00, 7.5471479692E+00, 2.6098679835E+00, 9.3197019488E-01],
	[3.1615000000E+04, 2.1969664143E+01, 4.8749248631E+00, 7.5510361465E+00, 2.6104151266E+00, 9.3200272035E-01],
	[3.1620000000E+04, 2.1975476667E+01, 4.8749257920E+00, 7.5549257107E+00, 2.6109621513E+00, 9.3203522939E-01],
	[3.1625000000E+04, 2.1981289810E+01, 4.8749267206E+00, 7.5588166622E+00, 2.6115090576E+00, 9.3206772201E-01],
	[3.1630000000E+04, 2.1987103571E+01, 4.8749276492E+00, 7.5627090013E+00, 2.6120558456E+00, 9.3210019821E-01],
	[3.1635000000E+04, 2.1992917950E+01, 4.8749285776E+00, 7.5666027282E+00, 2.6126025151E+00, 9.3213265802E-01],
	[3.1640000000E+04, 2.1998732948E+01, 4.8749295058E+00, 7.5704978431E+00, 2.6131490663E+00, 9.3216510143E-01],
	[3.1645000000E+04, 2.2004548564E+01, 4.8749304339E+00, 7.5743943465E+00, 2.6136954990E+00, 9.3219752844E-01],
	[3.1650000000E+04, 2.2010364799E+01, 4.8749313618E+00, 7.5782922385E+00, 2.6142418132E+00, 9.3222993908E-01],
	[3.1655000000E+04, 2.2016181651E+01, 4.8749322896E+00, 7.5821915194E+00, 2.6147880090E+00, 9.3226233335E-01],
	[3.1660000000E+04, 2.2021999122E+01, 4.8749332173E+00, 7.5860921895E+00, 2.6153340863E+00, 9.3229471124E-01],
	[3.1665000000E+04, 2.2027817211E+01, 4.8749341448E+00, 7.5899942491E+00, 2.6158800452E+00, 9.3232707278E-01],
	[3.1670000000E+04, 2.2033635918E+01, 4.8749350721E+00, 7.5938976984E+00, 2.6164258855E+00, 9.3235941797E-01],
	[3.1675000000E+04, 2.2039455243E+01, 4.8749359993E+00, 7.5978025378E+00, 2.6169716074E+00, 9.3239174682E-01],
	[3.1680000000E+04, 2.2045275186E+01, 4.8749369264E+00, 7.6017087674E+00, 2.6175172107E+00, 9.3242405933E-01],
	[3.1685000000E+04, 2.2051095748E+01, 4.8749378533E+00, 7.6056163877E+00, 2.6180626955E+00, 9.3245635551E-01],
	[3.1690000000E+04, 2.2056916927E+01, 4.8749387801E+00, 7.6095253987E+00, 2.6186080618E+00, 9.3248863537E-01],
	[3.1695000000E+04, 2.2062738724E+01, 4.8749397067E+00, 7.6134358009E+00, 2.6191533095E+00, 9.3252089891E-01],
	[3.1700000000E+04, 2.2068561139E+01, 4.8749406332E+00, 7.6173475945E+00, 2.6196984386E+00, 9.3255314615E-01],
	[3.1705000000E+04, 2.2074384172E+01, 4.8749415595E+00, 7.6212607797E+00, 2.6202434492E+00, 9.3258537710E-01],
	[3.1710000000E+04, 2.2080207823E+01, 4.8749424857E+00, 7.6251753569E+00, 2.6207883412E+00, 9.3261759175E-01],
	[3.1715000000E+04, 2.2086032092E+01, 4.8749434118E+00, 7.6290913264E+00, 2.6213331145E+00, 9.3264979012E-01],
	[3.1720000000E+04, 2.2091856978E+01, 4.8749443377E+00, 7.6330086883E+00, 2.6218777693E+00, 9.3268197221E-01],
	[3.1725000000E+04, 2.2097682482E+01, 4.8749452634E+00, 7.6369274430E+00, 2.6224223054E+00, 9.3271413804E-01],
	[3.1730000000E+04, 2.2103508604E+01, 4.8749461890E+00, 7.6408475907E+00, 2.6229667230E+00, 9.3274628760E-01],
	[3.1735000000E+04, 2.2109335344E+01, 4.8749471145E+00, 7.6447691318E+00, 2.6235110218E+00, 9.3277842091E-01],
	[3.1740000000E+04, 2.2115162701E+01, 4.8749480398E+00, 7.6486920665E+00, 2.6240552020E+00, 9.3281053798E-01],
	[3.1745000000E+04, 2.2120990677E+01, 4.8749489650E+00, 7.6526163950E+00, 2.6245992636E+00, 9.3284263881E-01],
	[3.1750000000E+04, 2.2126819269E+01, 4.8749498900E+00, 7.6565421177E+00, 2.6251432064E+00, 9.3287472340E-01],
	[3.1755000000E+04, 2.2132648479E+01, 4.8749508149E+00, 7.6604692348E+00, 2.6256870306E+00, 9.3290679178E-01],
	[3.1760000000E+04, 2.2138478307E+01, 4.8749517396E+00, 7.6643977466E+00, 2.6262307360E+00, 9.3293884394E-01],
	[3.1765000000E+04, 2.2144308752E+01, 4.8749526642E+00, 7.6683276534E+00, 2.6267743228E+00, 9.3297087989E-01],
	[3.1770000000E+04, 2.2150139815E+01, 4.8749535886E+00, 7.6722589554E+00, 2.6273177908E+00, 9.3300289964E-01],
	[3.1775000000E+04, 2.2155971495E+01, 4.8749545129E+00, 7.6761916529E+00, 2.6278611401E+00, 9.3303490320E-01],
	[3.1780000000E+04, 2.2161803793E+01, 4.8749554371E+00, 7.6801257463E+00, 2.6284043706E+00, 9.3306689058E-01],
	[3.1785000000E+04, 2.2167636708E+01, 4.8749563611E+00, 7.6840612357E+00, 2.6289474824E+00, 9.3309886177E-01],
	[3.1790000000E+04, 2.2173470240E+01, 4.8749572850E+00, 7.6879981215E+00, 2.6294904754E+00, 9.3313081680E-01],
	[3.1795000000E+04, 2.2179304390E+01, 4.8749582087E+00, 7.6919364039E+00, 2.6300333496E+00, 9.3316275567E-01],
	[3.1800000000E+04, 2.2185139157E+01, 4.8749591322E+00, 7.6958760832E+00, 2.6305761050E+00, 9.3319467838E-01],
	[3.1805000000E+04, 2.2190974541E+01, 4.8749600557E+00, 7.6998171597E+00, 2.6311187416E+00, 9.3322658494E-01],
	[3.1810000000E+04, 2.2196810543E+01, 4.8749609790E+00, 7.7037596336E+00, 2.6316612594E+00, 9.3325847537E-01],
	[3.1815000000E+04, 2.2202647162E+01, 4.8749619021E+00, 7.7077035052E+00, 2.6322036584E+00, 9.3329034966E-01],
	[3.1820000000E+04, 2.2208484397E+01, 4.8749628251E+00, 7.7116487749E+00, 2.6327459386E+00, 9.3332220783E-01],
	[3.1825000000E+04, 2.2214322250E+01, 4.8749637479E+00, 7.7155954428E+00, 2.6332880999E+00, 9.3335404988E-01],
	[3.1830000000E+04, 2.2220160720E+01, 4.8749646706E+00, 7.7195435093E+00, 2.6338301423E+00, 9.3338587582E-01],
	[3.1835000000E+04, 2.2225999808E+01, 4.8749655932E+00, 7.7234929746E+00, 2.6343720659E+00, 9.3341768566E-01],
	[3.1840000000E+04, 2.2231839512E+01, 4.8749665156E+00, 7.7274438390E+00, 2.6349138706E+00, 9.3344947940E-01],
	[3.1845000000E+04, 2.2237679833E+01, 4.8749674379E+00, 7.7313961028E+00, 2.6354555564E+00, 9.3348125706E-01],
	[3.1850000000E+04, 2.2243520771E+01, 4.8749683600E+00, 7.7353497663E+00, 2.6359971233E+00, 9.3351301864E-01],
	[3.1855000000E+04, 2.2249362326E+01, 4.8749692820E+00, 7.7393048296E+00, 2.6365385713E+00, 9.3354476415E-01],
	[3.1860000000E+04, 2.2255204498E+01, 4.8749702038E+00, 7.7432612932E+00, 2.6370799004E+00, 9.3357649360E-01],
	[3.1865000000E+04, 2.2261047287E+01, 4.8749711255E+00, 7.7472191573E+00, 2.6376211105E+00, 9.3360820699E-01],
	[3.1870000000E+04, 2.2266890693E+01, 4.8749720470E+00, 7.7511784221E+00, 2.6381622017E+00, 9.3363990433E-01],
	[3.1875000000E+04, 2.2272734716E+01, 4.8749729684E+00, 7.7551390879E+00, 2.6387031740E+00, 9.3367158563E-01],
	[3.1880000000E+04, 2.2278579355E+01, 4.8749738897E+00, 7.7591011551E+00, 2.6392440273E+00, 9.3370325089E-01],
	[3.1885000000E+04, 2.2284441767E+01, 4.8749772342E+00, 7.7630646238E+00, 2.6397857129E+00, 9.3373490013E-01],
	[3.1890000000E+04, 2.2290307152E+01, 4.8749809100E+00, 7.7670294944E+00, 2.6403274104E+00, 9.3376653335E-01],
	[3.1895000000E+04, 2.2296173162E+01, 4.8749845853E+00, 7.7709957672E+00, 2.6408689895E+00, 9.3379815057E-01],
	[3.1900000000E+04, 2.2302039795E+01, 4.8749882600E+00, 7.7749634423E+00, 2.6414104501E+00, 9.3382975177E-01],
	[3.1905000000E+04, 2.2307907052E+01, 4.8749919342E+00, 7.7789325201E+00, 2.6419517924E+00, 9.3386133699E-01],
	[3.1910000000E+04, 2.2313774932E+01, 4.8749956078E+00, 7.7829030009E+00, 2.6424930161E+00, 9.3389290621E-01],
	[3.1915000000E+04, 2.2319643437E+01, 4.8749992808E+00, 7.7868748849E+00, 2.6430341214E+00, 9.3392445945E-01],
	[3.1920000000E+04, 2.2325512565E+01, 4.8750029532E+00, 7.7908481724E+00, 2.6435751082E+00, 9.3395599673E-01],
	[3.1925000000E+04, 2.2331382317E+01, 4.8750066251E+00, 7.7948228637E+00, 2.6441159766E+00, 9.3398751803E-01],
	[3.1930000000E+04, 2.2337252692E+01, 4.8750102963E+00, 7.7987989591E+00, 2.6446567265E+00, 9.3401902338E-01],
	[3.1935000000E+04, 2.2343123692E+01, 4.8750139671E+00, 7.8027764588E+00, 2.6451973578E+00, 9.3405051278E-01],
	[3.1940000000E+04, 2.2348995314E+01, 4.8750176372E+00, 7.8067553632E+00, 2.6457378707E+00, 9.3408198623E-01],
	[3.1945000000E+04, 2.2354867561E+01, 4.8750213068E+00, 7.8107356724E+00, 2.6462782650E+00, 9.3411344375E-01],
	[3.1950000000E+04, 2.2360740431E+01, 4.8750249758E+00, 7.8147173867E+00, 2.6468185408E+00, 9.3414488535E-01],
	[3.1955000000E+04, 2.2366613924E+01, 4.8750286442E+00, 7.8187005066E+00, 2.6473586980E+00, 9.3417631102E-01],
	[3.1960000000E+04, 2.2372488041E+01, 4.8750323121E+00, 7.8226850321E+00, 2.6478987367E+00, 9.3420772078E-01],
	[3.1965000000E+04, 2.2378362781E+01, 4.8750359793E+00, 7.8266709636E+00, 2.6484386569E+00, 9.3423911464E-01],
	[3.1970000000E+04, 2.2384238145E+01, 4.8750396461E+00, 7.8306583014E+00, 2.6489784585E+00, 9.3427049260E-01],
	[3.1975000000E+04, 2.2390114132E+01, 4.8750433122E+00, 7.8346470457E+00, 2.6495181415E+00, 9.3430185467E-01],
	[3.1980000000E+04, 2.2395990742E+01, 4.8750469778E+00, 7.8386371969E+00, 2.6500577059E+00, 9.3433320086E-01],
	[3.1985000000E+04, 2.2401867976E+01, 4.8750506428E+00, 7.8426287551E+00, 2.6505971517E+00, 9.3436453118E-01],
	[3.1990000000E+04, 2.2407745833E+01, 4.8750543072E+00, 7.8466217207E+00, 2.6511364789E+00, 9.3439584563E-01],
	[3.1995000000E+04, 2.2413624314E+01, 4.8750579711E+00, 7.8506160940E+00, 2.6516756875E+00, 9.3442714422E-01],
	[3.2000000000E+04, 2.2419503417E+01, 4.8750616344E+00, 7.8546118752E+00, 2.6522147774E+00, 9.3445842696E-01],
	[3.2005000000E+04, 2.2425383144E+01, 4.8750652971E+00, 7.8586090646E+00, 2.6527537487E+00, 9.3448969385E-01],
	[3.2010000000E+04, 2.2431263494E+01, 4.8750689593E+00, 7.8626076624E+00, 2.6532926014E+00, 9.3452094491E-01],
	[3.2015000000E+04, 2.2437144467E+01, 4.8750726208E+00, 7.8666076690E+00, 2.6538313354E+00, 9.3455218014E-01],
	[3.2020000000E+04, 2.2443026063E+01, 4.8750762819E+00, 7.8706090846E+00, 2.6543699508E+00, 9.3458339955E-01],
	[3.2025000000E+04, 2.2448908282E+01, 4.8750799423E+00, 7.8746119095E+00, 2.6549084475E+00, 9.3461460315E-01],
	[3.2030000000E+04, 2.2454791124E+01, 4.8750836022E+00, 7.8786161440E+00, 2.6554468255E+00, 9.3464579094E-01],
	[3.2035000000E+04, 2.2460674589E+01, 4.8750872615E+00, 7.8826217884E+00, 2.6559850848E+00, 9.3467696293E-01],
	[3.2040000000E+04, 2.2466558678E+01, 4.8750909202E+00, 7.8866288429E+00, 2.6565232254E+00, 9.3470811913E-01],
	[3.2045000000E+04, 2.2472443389E+01, 4.8750945784E+00, 7.8906373077E+00, 2.6570612473E+00, 9.3473925955E-01],
	[3.2050000000E+04, 2.2478328723E+01, 4.8750982360E+00, 7.8946471833E+00, 2.6575991505E+00, 9.3477038420E-01],
	[3.2055000000E+04, 2.2484214680E+01, 4.8751018930E+00, 7.8986584698E+00, 2.6581369350E+00, 9.3480149307E-01],
	[3.2060000000E+04, 2.2490101260E+01, 4.8751055495E+00, 7.9026711675E+00, 2.6586746007E+00, 9.3483258619E-01],
	[3.2065000000E+04, 2.2495988462E+01, 4.8751092054E+00, 7.9066852768E+00, 2.6592121477E+00, 9.3486366355E-01],
	[3.2070000000E+04, 2.2501876288E+01, 4.8751128608E+00, 7.9107007978E+00, 2.6597495759E+00, 9.3489472517E-01],
	[3.2075000000E+04, 2.2507764736E+01, 4.8751165155E+00, 7.9147177309E+00, 2.6602868854E+00, 9.3492577105E-01],
	[3.2080000000E+04, 2.2513653806E+01, 4.8751201697E+00, 7.9187360763E+00, 2.6608240761E+00, 9.3495680120E-01],
	[3.2085000000E+04, 2.2519543500E+01, 4.8751238234E+00, 7.9227558344E+00, 2.6613611480E+00, 9.3498781563E-01],
	[3.2090000000E+04, 2.2525433816E+01, 4.8751274764E+00, 7.9267770053E+00, 2.6618981011E+00, 9.3501881435E-01],
	[3.2095000000E+04, 2.2531324755E+01, 4.8751311289E+00, 7.9307995894E+00, 2.6624349354E+00, 9.3504979736E-01],
	[3.2100000000E+04, 2.2537216316E+01, 4.8751347809E+00, 7.9348235869E+00, 2.6629716510E+00, 9.3508076467E-01],
	[3.2105000000E+04, 2.2543108500E+01, 4.8751384322E+00, 7.9388489981E+00, 2.6635082477E+00, 9.3511171628E-01],
	[3.2110000000E+04, 2.2549001307E+01, 4.8751420830E+00, 7.9428758233E+00, 2.6640447256E+00, 9.3514265222E-01],
	[3.2115000000E+04, 2.2554894736E+01, 4.8751457333E+00, 7.9469040628E+00, 2.6645810846E+00, 9.3517357248E-01],
	[3.2120000000E+04, 2.2560788788E+01, 4.8751493829E+00, 7.9509337168E+00, 2.6651173248E+00, 9.3520447706E-01],
	[3.2125000000E+04, 2.2566683461E+01, 4.8751530321E+00, 7.9549647857E+00, 2.6656534462E+00, 9.3523536599E-01],
	[3.2130000000E+04, 2.2572578758E+01, 4.8751566806E+00, 7.9589972696E+00, 2.6661894487E+00, 9.3526623926E-01],
	[3.2135000000E+04, 2.2578474677E+01, 4.8751603286E+00, 7.9630311689E+00, 2.6667253324E+00, 9.3529709689E-01],
	[3.2140000000E+04, 2.2584371218E+01, 4.8751639760E+00, 7.9670664839E+00, 2.6672610971E+00, 9.3532793888E-01],
	[3.2145000000E+04, 2.2590268381E+01, 4.8751676228E+00, 7.9711032148E+00, 2.6677967430E+00, 9.3535876524E-01],
	[3.2150000000E+04, 2.2596166167E+01, 4.8751712691E+00, 7.9751413618E+00, 2.6683322700E+00, 9.3538957597E-01],
	[3.2155000000E+04, 2.2602064575E+01, 4.8751749148E+00, 7.9791809254E+00, 2.6688676782E+00, 9.3542037109E-01],
	[3.2160000000E+04, 2.2607963605E+01, 4.8751785600E+00, 7.9832219057E+00, 2.6694029674E+00, 9.3545115061E-01],
	[3.2165000000E+04, 2.2613863257E+01, 4.8751822046E+00, 7.9872643030E+00, 2.6699381377E+00, 9.3548191452E-01],
	[3.2170000000E+04, 2.2619763532E+01, 4.8751858486E+00, 7.9913081176E+00, 2.6704731890E+00, 9.3551266284E-01],
	[3.2175000000E+04, 2.2625664428E+01, 4.8751894921E+00, 7.9953533498E+00, 2.6710081215E+00, 9.3554339557E-01],
	[3.2180000000E+04, 2.2631565947E+01, 4.8751931350E+00, 7.9993999999E+00, 2.6715429350E+00, 9.3557411273E-01],
	[3.2185000000E+04, 2.2637468088E+01, 4.8751967773E+00, 8.0034480681E+00, 2.6720776296E+00, 9.3560481431E-01],
	[3.2190000000E+04, 2.2643370851E+01, 4.8752004191E+00, 8.0074975547E+00, 2.6726122052E+00, 9.3563550034E-01],
	[3.2195000000E+04, 2.2649274236E+01, 4.8752040603E+00, 8.0115484599E+00, 2.6731466618E+00, 9.3566617080E-01],
	[3.2200000000E+04, 2.2655178243E+01, 4.8752077009E+00, 8.0156007842E+00, 2.6736809995E+00, 9.3569682573E-01],
	[3.2205000000E+04, 2.2661082871E+01, 4.8752113410E+00, 8.0196545276E+00, 2.6742152182E+00, 9.3572746511E-01],
	[3.2210000000E+04, 2.2666988122E+01, 4.8752149805E+00, 8.0237096906E+00, 2.6747493179E+00, 9.3575808896E-01],
	[3.2215000000E+04, 2.2672893995E+01, 4.8752186195E+00, 8.0277662734E+00, 2.6752832987E+00, 9.3578869729E-01],
	[3.2220000000E+04, 2.2678800489E+01, 4.8752222579E+00, 8.0318242762E+00, 2.6758171604E+00, 9.3581929010E-01],
	[3.2225000000E+04, 2.2684707605E+01, 4.8752258957E+00, 8.0358836994E+00, 2.6763509032E+00, 9.3584986740E-01],
	[3.2230000000E+04, 2.2690615343E+01, 4.8752295330E+00, 8.0399445432E+00, 2.6768845269E+00, 9.3588042920E-01],
	[3.2235000000E+04, 2.2696523703E+01, 4.8752331697E+00, 8.0440068078E+00, 2.6774180316E+00, 9.3591097550E-01],
	[3.2240000000E+04, 2.2702432685E+01, 4.8752368059E+00, 8.0480704937E+00, 2.6779514173E+00, 9.3594150632E-01],
	[3.2245000000E+04, 2.2708342288E+01, 4.8752404415E+00, 8.0521356010E+00, 2.6784846839E+00, 9.3597202166E-01],
	[3.2250000000E+04, 2.2714252513E+01, 4.8752440765E+00, 8.0562021300E+00, 2.6790178315E+00, 9.3600252153E-01],
	[3.2255000000E+04, 2.2720163359E+01, 4.8752477110E+00, 8.0602700810E+00, 2.6795508600E+00, 9.3603300594E-01],
	[3.2260000000E+04, 2.2726074828E+01, 4.8752513449E+00, 8.0643394543E+00, 2.6800837695E+00, 9.3606347489E-01],
	[3.2265000000E+04, 2.2731986917E+01, 4.8752549782E+00, 8.0684102501E+00, 2.6806165600E+00, 9.3609392839E-01],
	[3.2270000000E+04, 2.2737899628E+01, 4.8752586110E+00, 8.0724824688E+00, 2.6811492313E+00, 9.3612436645E-01],
	[3.2275000000E+04, 2.2743812961E+01, 4.8752622432E+00, 8.0765561105E+00, 2.6816817836E+00, 9.3615478908E-01],
	[3.2280000000E+04, 2.2749726915E+01, 4.8752658749E+00, 8.0806311757E+00, 2.6822142168E+00, 9.3618519629E-01],
	[3.2285000000E+04, 2.2755641491E+01, 4.8752695060E+00, 8.0847076645E+00, 2.6827465309E+00, 9.3621558807E-01],
	[3.2290000000E+04, 2.2761556688E+01, 4.8752731366E+00, 8.0887855772E+00, 2.6832787259E+00, 9.3624596445E-01],
	[3.2295000000E+04, 2.2767472507E+01, 4.8752767665E+00, 8.0928649141E+00, 2.6838108018E+00, 9.3627632542E-01],
	[3.2300000000E+04, 2.2773388947E+01, 4.8752803960E+00, 8.0969456755E+00, 2.6843427586E+00, 9.3630667100E-01],
	[3.2305000000E+04, 2.2779306008E+01, 4.8752840248E+00, 8.1010278617E+00, 2.6848745963E+00, 9.3633700119E-01],
	[3.2310000000E+04, 2.2785223690E+01, 4.8752876532E+00, 8.1051114729E+00, 2.6854063148E+00, 9.3636731601E-01],
	[3.2315000000E+04, 2.2791141994E+01, 4.8752912809E+00, 8.1091965095E+00, 2.6859379142E+00, 9.3639761545E-01],
	[3.2320000000E+04, 2.2797060919E+01, 4.8752949081E+00, 8.1132829716E+00, 2.6864693945E+00, 9.3642789952E-01],
	[3.2325000000E+04, 2.2802980465E+01, 4.8752985347E+00, 8.1173708596E+00, 2.6870007556E+00, 9.3645816824E-01],
	[3.2330000000E+04, 2.2808900632E+01, 4.8753021608E+00, 8.1214601737E+00, 2.6875319976E+00, 9.3648842161E-01],
	[3.2335000000E+04, 2.2814821421E+01, 4.8753057863E+00, 8.1255509142E+00, 2.6880631204E+00, 9.3651865964E-01],
	[3.2340000000E+04, 2.2820742830E+01, 4.8753094113E+00, 8.1296430815E+00, 2.6885941240E+00, 9.3654888233E-01],
	[3.2345000000E+04, 2.2826664861E+01, 4.8753130357E+00, 8.1337366757E+00, 2.6891250085E+00, 9.3657908970E-01],
	[3.2350000000E+04, 2.2832587513E+01, 4.8753166595E+00, 8.1378316971E+00, 2.6896557738E+00, 9.3660928175E-01],
	[3.2355000000E+04, 2.2838510785E+01, 4.8753202828E+00, 8.1419281461E+00, 2.6901864199E+00, 9.3663945848E-01],
	[3.2360000000E+04, 2.2844434679E+01, 4.8753239056E+00, 8.1460260229E+00, 2.6907169468E+00, 9.3666961992E-01],
	[3.2365000000E+04, 2.2850359194E+01, 4.8753275277E+00, 8.1501253278E+00, 2.6912473546E+00, 9.3669976606E-01],
	[3.2370000000E+04, 2.2856284329E+01, 4.8753311494E+00, 8.1542260610E+00, 2.6917776431E+00, 9.3672989691E-01],
	[3.2375000000E+04, 2.2862210086E+01, 4.8753347704E+00, 8.1583282228E+00, 2.6923078124E+00, 9.3676001247E-01],
	[3.2380000000E+04, 2.2868136463E+01, 4.8753383909E+00, 8.1624318136E+00, 2.6928378625E+00, 9.3679011277E-01],
	[3.2385000000E+04, 2.2874063461E+01, 4.8753420109E+00, 8.1665368335E+00, 2.6933677933E+00, 9.3682019780E-01],
	[3.2390000000E+04, 2.2879991080E+01, 4.8753456303E+00, 8.1706432829E+00, 2.6938976050E+00, 9.3685026757E-01],
	[3.2395000000E+04, 2.2885923807E+01, 4.8753498772E+00, 8.1747511620E+00, 2.6944275514E+00, 9.3688032209E-01],
	[3.2400000000E+04, 2.2891871958E+01, 4.8753561948E+00, 8.1788604712E+00, 2.6949582168E+00, 9.3691036137E-01],
	[3.2405000000E+04, 2.2897820738E+01, 4.8753625114E+00, 8.1829716867E+00, 2.6954888151E+00, 9.3694038542E-01],
	[3.2410000000E+04, 2.2903770144E+01, 4.8753688270E+00, 8.1870856889E+00, 2.6960194417E+00, 9.3697039423E-01],
	[3.2415000000E+04, 2.2909720179E+01, 4.8753751417E+00, 8.1912011235E+00, 2.6965499496E+00, 9.3700038783E-01],
	[3.2420000000E+04, 2.2915670841E+01, 4.8753814554E+00, 8.1953179910E+00, 2.6970803387E+00, 9.3703036622E-01],
	[3.2425000000E+04, 2.2921622131E+01, 4.8753877682E+00, 8.1994362914E+00, 2.6976106090E+00, 9.3706032940E-01],
	[3.2430000000E+04, 2.2927574048E+01, 4.8753940800E+00, 8.2035560252E+00, 2.6981407605E+00, 9.3709027738E-01],
	[3.2435000000E+04, 2.2933526593E+01, 4.8754003908E+00, 8.2076771927E+00, 2.6986707931E+00, 9.3712021017E-01],
	[3.2440000000E+04, 2.2939479765E+01, 4.8754067006E+00, 8.2117997940E+00, 2.6992007070E+00, 9.3715012778E-01],
	[3.2445000000E+04, 2.2945433565E+01, 4.8754130095E+00, 8.2159238294E+00, 2.6997305021E+00, 9.3718003022E-01],
	[3.2450000000E+04, 2.2951387992E+01, 4.8754193174E+00, 8.2200492993E+00, 2.7002601784E+00, 9.3720991749E-01],
	[3.2455000000E+04, 2.2957343047E+01, 4.8754256244E+00, 8.2241762039E+00, 2.7007897359E+00, 9.3723978960E-01],
	[3.2460000000E+04, 2.2963298729E+01, 4.8754319304E+00, 8.2283045435E+00, 2.7013191745E+00, 9.3726964656E-01],
	[3.2465000000E+04, 2.2969255039E+01, 4.8754382354E+00, 8.2324343184E+00, 2.7018484943E+00, 9.3729948838E-01],
	[3.2470000000E+04, 2.2975211976E+01, 4.8754445395E+00, 8.2365655288E+00, 2.7023776952E+00, 9.3732931506E-01],
	[3.2475000000E+04, 2.2981169540E+01, 4.8754508426E+00, 8.2406981751E+00, 2.7029067773E+00, 9.3735912661E-01],
	[3.2480000000E+04, 2.2987127732E+01, 4.8754571448E+00, 8.2448322574E+00, 2.7034357406E+00, 9.3738892304E-01],
	[3.2485000000E+04, 2.2993086550E+01, 4.8754634459E+00, 8.2489677762E+00, 2.7039645850E+00, 9.3741870435E-01],
	[3.2490000000E+04, 2.2999045996E+01, 4.8754697462E+00, 8.2531047316E+00, 2.7044933105E+00, 9.3744847056E-01],
	[3.2495000000E+04, 2.3005006069E+01, 4.8754760454E+00, 8.2572431239E+00, 2.7050219172E+00, 9.3747822167E-01],
	[3.2500000000E+04, 2.3010966770E+01, 4.8754823437E+00, 8.2613829534E+00, 2.7055504050E+00, 9.3750795770E-01],
	[3.2505000000E+04, 2.3016928097E+01, 4.8754886411E+00, 8.2655242205E+00, 2.7060787740E+00, 9.3753767863E-01],
	[3.2510000000E+04, 2.3022890052E+01, 4.8754949375E+00, 8.2696669253E+00, 2.7066070240E+00, 9.3756738450E-01],
	[3.2515000000E+04, 2.3028852633E+01, 4.8755012329E+00, 8.2738110681E+00, 2.7071351552E+00, 9.3759707529E-01],
	[3.2520000000E+04, 2.3034815842E+01, 4.8755075273E+00, 8.2779566493E+00, 2.7076631674E+00, 9.3762675103E-01],
	[3.2525000000E+04, 2.3040779678E+01, 4.8755138208E+00, 8.2821036690E+00, 2.7081910608E+00, 9.3765641171E-01],
	[3.2530000000E+04, 2.3046744140E+01, 4.8755201134E+00, 8.2862521277E+00, 2.7087188353E+00, 9.3768605734E-01],
	[3.2535000000E+04, 2.3052709230E+01, 4.8755264050E+00, 8.2904020255E+00, 2.7092464908E+00, 9.3771568794E-01],
	[3.2540000000E+04, 2.3058674946E+01, 4.8755326956E+00, 8.2945533627E+00, 2.7097740275E+00, 9.3774530351E-01],
	[3.2545000000E+04, 2.3064641290E+01, 4.8755389853E+00, 8.2987061397E+00, 2.7103014452E+00, 9.3777490406E-01],
	[3.2550000000E+04, 2.3070608260E+01, 4.8755452740E+00, 8.3028603566E+00, 2.7108287440E+00, 9.3780448959E-01],
	[3.2555000000E+04, 2.3076575857E+01, 4.8755515617E+00, 8.3070160138E+00, 2.7113559239E+00, 9.3783406012E-01],
	[3.2560000000E+04, 2.3082544081E+01, 4.8755578485E+00, 8.3111731116E+00, 2.7118829848E+00, 9.3786361564E-01],
	[3.2565000000E+04, 2.3088512931E+01, 4.8755641343E+00, 8.3153316501E+00, 2.7124099268E+00, 9.3789315618E-01],
	[3.2570000000E+04, 2.3094482409E+01, 4.8755704192E+00, 8.3194916298E+00, 2.7129367499E+00, 9.3792268172E-01],
	[3.2575000000E+04, 2.3100452513E+01, 4.8755767031E+00, 8.3236530509E+00, 2.7134634540E+00, 9.3795219230E-01],
	[3.2580000000E+04, 2.3106423243E+01, 4.8755829861E+00, 8.3278159136E+00, 2.7139900391E+00, 9.3798168790E-01],
	[3.2585000000E+04, 2.3112394601E+01, 4.8755892681E+00, 8.3319802182E+00, 2.7145165053E+00, 9.3801116854E-01],
	[3.2590000000E+04, 2.3118366585E+01, 4.8755955492E+00, 8.3361459651E+00, 2.7150428525E+00, 9.3804063423E-01],
	[3.2595000000E+04, 2.3124339195E+01, 4.8756018293E+00, 8.3403131544E+00, 2.7155690808E+00, 9.3807008497E-01],
	[3.2600000000E+04, 2.3130312432E+01, 4.8756081084E+00, 8.3444817865E+00, 2.7160951901E+00, 9.3809952077E-01],
	[3.2605000000E+04, 2.3136286296E+01, 4.8756143866E+00, 8.3486518616E+00, 2.7166211804E+00, 9.3812894164E-01],
	[3.2610000000E+04, 2.3142260786E+01, 4.8756206638E+00, 8.3528233801E+00, 2.7171470517E+00, 9.3815834759E-01],
	[3.2615000000E+04, 2.3148235902E+01, 4.8756269401E+00, 8.3569963422E+00, 2.7176728040E+00, 9.3818773862E-01],
	[3.2620000000E+04, 2.3154211645E+01, 4.8756332154E+00, 8.3611707481E+00, 2.7181984374E+00, 9.3821711474E-01],
	[3.2625000000E+04, 2.3160188015E+01, 4.8756394898E+00, 8.3653465982E+00, 2.7187239517E+00, 9.3824647596E-01],
	[3.2630000000E+04, 2.3166165010E+01, 4.8756457632E+00, 8.3695238927E+00, 2.7192493471E+00, 9.3827582229E-01],
	[3.2635000000E+04, 2.3172142632E+01, 4.8756520357E+00, 8.3737026320E+00, 2.7197746234E+00, 9.3830515373E-01],
	[3.2640000000E+04, 2.3178120881E+01, 4.8756583072E+00, 8.3778828162E+00, 2.7202997808E+00, 9.3833447029E-01],
	[3.2645000000E+04, 2.3184099755E+01, 4.8756645777E+00, 8.3820644457E+00, 2.7208248191E+00, 9.3836377199E-01],
	[3.2650000000E+04, 2.3190079256E+01, 4.8756708473E+00, 8.3862475207E+00, 2.7213497384E+00, 9.3839305881E-01],
	[3.2655000000E+04, 2.3196059383E+01, 4.8756771160E+00, 8.3904320416E+00, 2.7218745387E+00, 9.3842233079E-01],
	[3.2660000000E+04, 2.3202040137E+01, 4.8756833837E+00, 8.3946180085E+00, 2.7223992199E+00, 9.3845158792E-01],
	[3.2665000000E+04, 2.3208021516E+01, 4.8756896505E+00, 8.3988054218E+00, 2.7229237822E+00, 9.3848083020E-01],
	[3.2670000000E+04, 2.3214003522E+01, 4.8756959163E+00, 8.4029942818E+00, 2.7234482254E+00, 9.3851005765E-01],
	[3.2675000000E+04, 2.3219986153E+01, 4.8757021811E+00, 8.4071845888E+00, 2.7239725495E+00, 9.3853927028E-01],
	[3.2680000000E+04, 2.3225969411E+01, 4.8757084450E+00, 8.4113763429E+00, 2.7244967546E+00, 9.3856846809E-01],
	[3.2685000000E+04, 2.3231953295E+01, 4.8757147080E+00, 8.4155695445E+00, 2.7250208407E+00, 9.3859765109E-01],
	[3.2690000000E+04, 2.3237937805E+01, 4.8757209700E+00, 8.4197641939E+00, 2.7255448077E+00, 9.3862681929E-01],
	[3.2695000000E+04, 2.3243922940E+01, 4.8757272310E+00, 8.4239602913E+00, 2.7260686556E+00, 9.3865597269E-01],
	[3.2700000000E+04, 2.3249908702E+01, 4.8757334911E+00, 8.4281578371E+00, 2.7265923845E+00, 9.3868511131E-01],
	[3.2705000000E+04, 2.3255895090E+01, 4.8757397502E+00, 8.4323568314E+00, 2.7271159944E+00, 9.3871423514E-01],
	[3.2710000000E+04, 2.3261882103E+01, 4.8757460085E+00, 8.4365572747E+00, 2.7276394851E+00, 9.3874334421E-01],
	[3.2715000000E+04, 2.3267869742E+01, 4.8757522657E+00, 8.4407591671E+00, 2.7281628568E+00, 9.3877243850E-01],
	[3.2720000000E+04, 2.3273858008E+01, 4.8757585220E+00, 8.4449625089E+00, 2.7286861095E+00, 9.3880151805E-01],
	[3.2725000000E+04, 2.3279846899E+01, 4.8757647774E+00, 8.4491673004E+00, 2.7292092430E+00, 9.3883058284E-01],
	[3.2730000000E+04, 2.3285836415E+01, 4.8757710318E+00, 8.4533735420E+00, 2.7297322575E+00, 9.3885963289E-01],
	[3.2735000000E+04, 2.3291826558E+01, 4.8757772852E+00, 8.4575812338E+00, 2.7302551528E+00, 9.3888866820E-01],
	[3.2740000000E+04, 2.3297817326E+01, 4.8757835378E+00, 8.4617903761E+00, 2.7307779291E+00, 9.3891768879E-01],
	[3.2745000000E+04, 2.3303808720E+01, 4.8757897893E+00, 8.4660009693E+00, 2.7313005863E+00, 9.3894669466E-01],
	[3.2750000000E+04, 2.3309800739E+01, 4.8757960399E+00, 8.4702130135E+00, 2.7318231244E+00, 9.3897568582E-01],
	[3.2755000000E+04, 2.3315793384E+01, 4.8758022896E+00, 8.4744265092E+00, 2.7323455434E+00, 9.3900466227E-01],
	[3.2760000000E+04, 2.3321786655E+01, 4.8758085383E+00, 8.4786414565E+00, 2.7328678433E+00, 9.3903362403E-01],
	[3.2765000000E+04, 2.3327780551E+01, 4.8758147861E+00, 8.4828578558E+00, 2.7333900241E+00, 9.3906257110E-01],
	[3.2770000000E+04, 2.3333775073E+01, 4.8758210330E+00, 8.4870757072E+00, 2.7339120858E+00, 9.3909150348E-01],
	[3.2775000000E+04, 2.3339770220E+01, 4.8758272789E+00, 8.4912950112E+00, 2.7344340284E+00, 9.3912042120E-01],
	[3.2780000000E+04, 2.3345765992E+01, 4.8758335238E+00, 8.4955157679E+00, 2.7349558518E+00, 9.3914932424E-01],
	[3.2785000000E+04, 2.3351762391E+01, 4.8758397678E+00, 8.4997379777E+00, 2.7354775562E+00, 9.3917821263E-01],
	[3.2790000000E+04, 2.3357759414E+01, 4.8758460109E+00, 8.5039616408E+00, 2.7359991414E+00, 9.3920708636E-01],
	[3.2795000000E+04, 2.3363757063E+01, 4.8758522530E+00, 8.5081867575E+00, 2.7365206074E+00, 9.3923594546E-01],
	[3.2800000000E+04, 2.3369755337E+01, 4.8758584942E+00, 8.5124133281E+00, 2.7370419544E+00, 9.3926478991E-01],
	[3.2805000000E+04, 2.3375754237E+01, 4.8758647344E+00, 8.5166413528E+00, 2.7375631822E+00, 9.3929361974E-01],
	[3.2810000000E+04, 2.3381753761E+01, 4.8758709737E+00, 8.5208708320E+00, 2.7380842909E+00, 9.3932243494E-01],
	[3.2815000000E+04, 2.3387753911E+01, 4.8758772120E+00, 8.5251017660E+00, 2.7386052805E+00, 9.3935123554E-01],
	[3.2820000000E+04, 2.3393754687E+01, 4.8758834494E+00, 8.5293341549E+00, 2.7391261509E+00, 9.3938002152E-01],
	[3.2825000000E+04, 2.3399756087E+01, 4.8758896859E+00, 8.5335679991E+00, 2.7396469021E+00, 9.3940879291E-01],
	[3.2830000000E+04, 2.3405758113E+01, 4.8758959214E+00, 8.5378032988E+00, 2.7401675342E+00, 9.3943754971E-01],
	[3.2835000000E+04, 2.3411760763E+01, 4.8759021560E+00, 8.5420400544E+00, 2.7406880472E+00, 9.3946629192E-01],
	[3.2840000000E+04, 2.3417764039E+01, 4.8759083896E+00, 8.5462782661E+00, 2.7412084410E+00, 9.3949501956E-01],
	[3.2845000000E+04, 2.3423767940E+01, 4.8759146223E+00, 8.5505179341E+00, 2.7417287157E+00, 9.3952373263E-01],
	[3.2850000000E+04, 2.3429772466E+01, 4.8759208540E+00, 8.5547590589E+00, 2.7422488712E+00, 9.3955243114E-01],
	[3.2855000000E+04, 2.3435777617E+01, 4.8759270849E+00, 8.5590016405E+00, 2.7427689075E+00, 9.3958111509E-01],
	[3.2860000000E+04, 2.3441783393E+01, 4.8759333147E+00, 8.5632456794E+00, 2.7432888247E+00, 9.3960978450E-01],
	[3.2865000000E+04, 2.3447789793E+01, 4.8759395437E+00, 8.5674911758E+00, 2.7438086227E+00, 9.3963843937E-01],
	[3.2870000000E+04, 2.3453796819E+01, 4.8759457717E+00, 8.5717381300E+00, 2.7443283015E+00, 9.3966707971E-01],
	[3.2875000000E+04, 2.3459804470E+01, 4.8759519987E+00, 8.5759865423E+00, 2.7448478612E+00, 9.3969570553E-01],
	[3.2880000000E+04, 2.3465812745E+01, 4.8759582248E+00, 8.5802364128E+00, 2.7453673016E+00, 9.3972431683E-01],
	[3.2885000000E+04, 2.3471821646E+01, 4.8759644500E+00, 8.5844877420E+00, 2.7458866229E+00, 9.3975291363E-01],
	[3.2890000000E+04, 2.3477831171E+01, 4.8759706742E+00, 8.5887405301E+00, 2.7464058251E+00, 9.3978149592E-01],
	[3.2895000000E+04, 2.3483841321E+01, 4.8759768975E+00, 8.5929947774E+00, 2.7469249080E+00, 9.3981006372E-01],
	[3.2900000000E+04, 2.3489852095E+01, 4.8759831199E+00, 8.5972504841E+00, 2.7474438718E+00, 9.3983861704E-01],
	[3.2905000000E+04, 2.3495863495E+01, 4.8759893413E+00, 8.6015076505E+00, 2.7479627164E+00, 9.3986715587E-01],
	[3.2910000000E+04, 2.3501875519E+01, 4.8759955618E+00, 8.6057662769E+00, 2.7484814417E+00, 9.3989568024E-01],
	[3.2915000000E+04, 2.3507888167E+01, 4.8760017813E+00, 8.6100263637E+00, 2.7490000479E+00, 9.3992419014E-01],
	[3.2920000000E+04, 2.3513919236E+01, 4.8760104684E+00, 8.6142879109E+00, 2.7495195631E+00, 9.3995268559E-01],
	[3.2925000000E+04, 2.3519952207E+01, 4.8760193304E+00, 8.6185509191E+00, 2.7500390331E+00, 9.3998116659E-01],
	[3.2930000000E+04, 2.3525985810E+01, 4.8760281911E+00, 8.6228153883E+00, 2.7505583844E+00, 9.4000963315E-01],
	[3.2935000000E+04, 2.3532020044E+01, 4.8760370505E+00, 8.6270813190E+00, 2.7510776170E+00, 9.4003808528E-01],
	[3.2940000000E+04, 2.3538054909E+01, 4.8760459086E+00, 8.6313487113E+00, 2.7515967309E+00, 9.4006652298E-01],
	[3.2945000000E+04, 2.3544090406E+01, 4.8760547653E+00, 8.6356175656E+00, 2.7521157262E+00, 9.4009494627E-01],
	[3.2950000000E+04, 2.3550126534E+01, 4.8760636207E+00, 8.6398878821E+00, 2.7526346028E+00, 9.4012335514E-01],
	[3.2955000000E+04, 2.3556163294E+01, 4.8760724748E+00, 8.6441596611E+00, 2.7531533607E+00, 9.4015174961E-01],
	[3.2960000000E+04, 2.3562200684E+01, 4.8760813275E+00, 8.6484329029E+00, 2.7536719999E+00, 9.4018012969E-01],
	[3.2965000000E+04, 2.3568238706E+01, 4.8760901789E+00, 8.6527076078E+00, 2.7541905204E+00, 9.4020849538E-01],
	[3.2970000000E+04, 2.3574277359E+01, 4.8760990290E+00, 8.6569837760E+00, 2.7547089223E+00, 9.4023684668E-01],
	[3.2975000000E+04, 2.3580316643E+01, 4.8761078778E+00, 8.6612614079E+00, 2.7552272054E+00, 9.4026518362E-01],
	[3.2980000000E+04, 2.3586356558E+01, 4.8761167252E+00, 8.6655405036E+00, 2.7557453699E+00, 9.4029350619E-01],
	[3.2985000000E+04, 2.3592397105E+01, 4.8761255714E+00, 8.6698210636E+00, 2.7562634157E+00, 9.4032181440E-01],
	[3.2990000000E+04, 2.3598438282E+01, 4.8761344161E+00, 8.6741030880E+00, 2.7567813427E+00, 9.4035010826E-01],
	[3.2995000000E+04, 2.3604480091E+01, 4.8761432596E+00, 8.6783865771E+00, 2.7572991511E+00, 9.4037838778E-01],
	[3.3000000000E+04, 2.3610522530E+01, 4.8761521018E+00, 8.6826715313E+00, 2.7578168408E+00, 9.4040665296E-01],
	[3.3005000000E+04, 2.3616565601E+01, 4.8761609426E+00, 8.6869579508E+00, 2.7583344118E+00, 9.4043490381E-01],
	[3.3010000000E+04, 2.3622609302E+01, 4.8761697821E+00, 8.6912458358E+00, 2.7588518640E+00, 9.4046314034E-01],
	[3.3015000000E+04, 2.3628653634E+01, 4.8761786202E+00, 8.6955351867E+00, 2.7593691976E+00, 9.4049136255E-01],
	[3.3020000000E+04, 2.3634698598E+01, 4.8761874571E+00, 8.6998260037E+00, 2.7598864124E+00, 9.4051957045E-01],
	[3.3025000000E+04, 2.3640744192E+01, 4.8761962926E+00, 8.7041182872E+00, 2.7604035086E+00, 9.4054776405E-01],
	[3.3030000000E+04, 2.3646790417E+01, 4.8762051268E+00, 8.7084120373E+00, 2.7609204860E+00, 9.4057594335E-01],
	[3.3035000000E+04, 2.3652837273E+01, 4.8762139597E+00, 8.7127072544E+00, 2.7614373447E+00, 9.4060410836E-01],
	[3.3040000000E+04, 2.3658884759E+01, 4.8762227913E+00, 8.7170039387E+00, 2.7619540847E+00, 9.4063225909E-01],
	[3.3045000000E+04, 2.3664932876E+01, 4.8762316215E+00, 8.7213020906E+00, 2.7624707060E+00, 9.4066039555E-01],
	[3.3050000000E+04, 2.3670981624E+01, 4.8762404504E+00, 8.7256017103E+00, 2.7629872086E+00, 9.4068851773E-01],
	[3.3055000000E+04, 2.3677031003E+01, 4.8762492781E+00, 8.7299027981E+00, 2.7635035924E+00, 9.4071662565E-01],
	[3.3060000000E+04, 2.3683081012E+01, 4.8762581043E+00, 8.7342053542E+00, 2.7640198576E+00, 9.4074471932E-01],
	[3.3065000000E+04, 2.3689131652E+01, 4.8762669293E+00, 8.7385093790E+00, 2.7645360040E+00, 9.4077279873E-01],
	[3.3070000000E+04, 2.3695182923E+01, 4.8762757530E+00, 8.7428148727E+00, 2.7650520316E+00, 9.4080086391E-01],
	[3.3075000000E+04, 2.3701234824E+01, 4.8762845753E+00, 8.7471218355E+00, 2.7655679406E+00, 9.4082891485E-01],
	[3.3080000000E+04, 2.3707287356E+01, 4.8762933963E+00, 8.7514302679E+00, 2.7660837308E+00, 9.4085695156E-01],
	[3.3085000000E+04, 2.3713340518E+01, 4.8763022160E+00, 8.7557401700E+00, 2.7665994023E+00, 9.4088497405E-01],
	[3.3090000000E+04, 2.3719394311E+01, 4.8763110344E+00, 8.7600515422E+00, 2.7671149551E+00, 9.4091298232E-01],
	[3.3095000000E+04, 2.3725448734E+01, 4.8763198514E+00, 8.7643643847E+00, 2.7676303892E+00, 9.4094097639E-01],
	[3.3100000000E+04, 2.3731503787E+01, 4.8763286672E+00, 8.7686786977E+00, 2.7681457045E+00, 9.4096895625E-01],
	[3.3105000000E+04, 2.3737559471E+01, 4.8763374816E+00, 8.7729944817E+00, 2.7686609011E+00, 9.4099692192E-01],
	[3.3110000000E+04, 2.3743615785E+01, 4.8763462947E+00, 8.7773117368E+00, 2.7691759789E+00, 9.4102487340E-01],
	[3.3115000000E+04, 2.3749672730E+01, 4.8763551065E+00, 8.7816304633E+00, 2.7696909380E+00, 9.4105281071E-01],
	[3.3120000000E+04, 2.3755730305E+01, 4.8763639170E+00, 8.7859506615E+00, 2.7702057784E+00, 9.4108073383E-01],
	[3.3125000000E+04, 2.3761788510E+01, 4.8763727262E+00, 8.7902723317E+00, 2.7707205001E+00, 9.4110864280E-01],
	[3.3130000000E+04, 2.3767847345E+01, 4.8763815340E+00, 8.7945954742E+00, 2.7712351030E+00, 9.4113653760E-01],
	[3.3135000000E+04, 2.3773906811E+01, 4.8763903406E+00, 8.7989200892E+00, 2.7717495872E+00, 9.4116441824E-01],
	[3.3140000000E+04, 2.3779966907E+01, 4.8763991458E+00, 8.8032461771E+00, 2.7722639526E+00, 9.4119228474E-01],
	[3.3145000000E+04, 2.3786027633E+01, 4.8764079497E+00, 8.8075737380E+00, 2.7727781993E+00, 9.4122013710E-01],
	[3.3150000000E+04, 2.3792088989E+01, 4.8764167523E+00, 8.8119027724E+00, 2.7732923272E+00, 9.4124797533E-01],
	[3.3155000000E+04, 2.3798150975E+01, 4.8764255536E+00, 8.8162332804E+00, 2.7738063364E+00, 9.4127579943E-01],
	[3.3160000000E+04, 2.3804213591E+01, 4.8764343536E+00, 8.8205652623E+00, 2.7743202269E+00, 9.4130360941E-01],
	[3.3165000000E+04, 2.3810276838E+01, 4.8764431523E+00, 8.8248987185E+00, 2.7748339986E+00, 9.4133140527E-01],
	[3.3170000000E+04, 2.3816340714E+01, 4.8764519497E+00, 8.8292336491E+00, 2.7753476516E+00, 9.4135918704E-01],
	[3.3175000000E+04, 2.3822405220E+01, 4.8764607457E+00, 8.8335700545E+00, 2.7758611858E+00, 9.4138695470E-01],
	[3.3180000000E+04, 2.3828470356E+01, 4.8764695405E+00, 8.8379079350E+00, 2.7763746013E+00, 9.4141470827E-01],
	[3.3185000000E+04, 2.3834536122E+01, 4.8764783339E+00, 8.8422472908E+00, 2.7768878981E+00, 9.4144244775E-01],
	[3.3190000000E+04, 2.3840602518E+01, 4.8764871260E+00, 8.8465881223E+00, 2.7774010761E+00, 9.4147017316E-01],
	[3.3195000000E+04, 2.3846669544E+01, 4.8764959168E+00, 8.8509304296E+00, 2.7779141353E+00, 9.4149788449E-01],
	[3.3200000000E+04, 2.3852737200E+01, 4.8765047063E+00, 8.8552742131E+00, 2.7784270758E+00, 9.4152558176E-01],
	[3.3205000000E+04, 2.3858805485E+01, 4.8765134945E+00, 8.8596194730E+00, 2.7789398976E+00, 9.4155326497E-01],
	[3.3210000000E+04, 2.3864874401E+01, 4.8765222814E+00, 8.8639662097E+00, 2.7794526006E+00, 9.4158093412E-01],
	[3.3215000000E+04, 2.3870943946E+01, 4.8765310670E+00, 8.8683144234E+00, 2.7799651848E+00, 9.4160858924E-01],
	[3.3220000000E+04, 2.3877014120E+01, 4.8765398513E+00, 8.8726641144E+00, 2.7804776503E+00, 9.4163623031E-01],
	[3.3225000000E+04, 2.3883084925E+01, 4.8765486343E+00, 8.8770152829E+00, 2.7809899971E+00, 9.4166385736E-01],
	[3.3230000000E+04, 2.3889156359E+01, 4.8765574159E+00, 8.8813679293E+00, 2.7815022251E+00, 9.4169147038E-01],
	[3.3235000000E+04, 2.3895228423E+01, 4.8765661963E+00, 8.8857220538E+00, 2.7820143344E+00, 9.4171906938E-01],
	[3.3240000000E+04, 2.3901301116E+01, 4.8765749754E+00, 8.8900776567E+00, 2.7825263249E+00, 9.4174665437E-01],
	[3.3245000000E+04, 2.3907374439E+01, 4.8765837531E+00, 8.8944347383E+00, 2.7830381966E+00, 9.4177422536E-01],
	[3.3250000000E+04, 2.3913448391E+01, 4.8765925296E+00, 8.8987932988E+00, 2.7835499496E+00, 9.4180178235E-01],
	[3.3255000000E+04, 2.3919522973E+01, 4.8766013047E+00, 8.9031533386E+00, 2.7840615839E+00, 9.4182932535E-01],
	[3.3260000000E+04, 2.3925598184E+01, 4.8766100785E+00, 8.9075148579E+00, 2.7845730994E+00, 9.4185685436E-01],
	[3.3265000000E+04, 2.3931674025E+01, 4.8766188511E+00, 8.9118778571E+00, 2.7850844962E+00, 9.4188436940E-01],
	[3.3270000000E+04, 2.3937750495E+01, 4.8766276223E+00, 8.9162423363E+00, 2.7855957742E+00, 9.4191187047E-01],
	[3.3275000000E+04, 2.3943827595E+01, 4.8766363922E+00, 8.9206082958E+00, 2.7861069334E+00, 9.4193935758E-01],
	[3.3280000000E+04, 2.3949905324E+01, 4.8766451609E+00, 8.9249757360E+00, 2.7866179739E+00, 9.4196683073E-01],
	[3.3285000000E+04, 2.3955983682E+01, 4.8766539282E+00, 8.9293446571E+00, 2.7871288957E+00, 9.4199428993E-01],
	[3.3290000000E+04, 2.3962062669E+01, 4.8766626942E+00, 8.9337150594E+00, 2.7876396987E+00, 9.4202173519E-01],
	[3.3295000000E+04, 2.3968142286E+01, 4.8766714590E+00, 8.9380869432E+00, 2.7881503830E+00, 9.4204916651E-01],
	[3.3300000000E+04, 2.3974222532E+01, 4.8766802224E+00, 8.9424603087E+00, 2.7886609485E+00, 9.4207658391E-01],
	[3.3305000000E+04, 2.3980303408E+01, 4.8766889845E+00, 8.9468351563E+00, 2.7891713952E+00, 9.4210398738E-01],
	[3.3310000000E+04, 2.3986384912E+01, 4.8766977453E+00, 8.9512114861E+00, 2.7896817232E+00, 9.4213137693E-01],
	[3.3315000000E+04, 2.3992467046E+01, 4.8767065049E+00, 8.9555892986E+00, 2.7901919325E+00, 9.4215875258E-01],
	[3.3320000000E+04, 2.3998549808E+01, 4.8767152631E+00, 8.9599685939E+00, 2.7907020230E+00, 9.4218611433E-01],
	[3.3325000000E+04, 2.4004633200E+01, 4.8767240200E+00, 8.9643493724E+00, 2.7912119948E+00, 9.4221346218E-01],
	[3.3330000000E+04, 2.4010717221E+01, 4.8767327757E+00, 8.9687316343E+00, 2.7917218478E+00, 9.4224079614E-01],
	[3.3335000000E+04, 2.4016801871E+01, 4.8767415300E+00, 8.9731153800E+00, 2.7922315821E+00, 9.4226811622E-01],
	[3.3340000000E+04, 2.4022887150E+01, 4.8767502830E+00, 8.9775006096E+00, 2.7927411976E+00, 9.4229542243E-01],
	[3.3345000000E+04, 2.4028973058E+01, 4.8767590348E+00, 8.9818873235E+00, 2.7932506944E+00, 9.4232271477E-01],
	[3.3350000000E+04, 2.4035059595E+01, 4.8767677852E+00, 8.9862755219E+00, 2.7937600724E+00, 9.4234999325E-01],
	[3.3355000000E+04, 2.4041146760E+01, 4.8767765344E+00, 8.9906652051E+00, 2.7942693317E+00, 9.4237725787E-01],
	[3.3360000000E+04, 2.4047234555E+01, 4.8767852822E+00, 8.9950563735E+00, 2.7947784722E+00, 9.4240450865E-01],
	[3.3365000000E+04, 2.4053322979E+01, 4.8767940288E+00, 8.9994490272E+00, 2.7952874940E+00, 9.4243174558E-01],
	[3.3370000000E+04, 2.4059412031E+01, 4.8768027740E+00, 9.0038431666E+00, 2.7957963971E+00, 9.4245896869E-01],
	[3.3375000000E+04, 2.4065501712E+01, 4.8768115180E+00, 9.0082387920E+00, 2.7963051814E+00, 9.4248617796E-01],
	[3.3380000000E+04, 2.4071592022E+01, 4.8768202607E+00, 9.0126359036E+00, 2.7968138469E+00, 9.4251337342E-01],
	[3.3385000000E+04, 2.4077682961E+01, 4.8768290021E+00, 9.0170345016E+00, 2.7973223938E+00, 9.4254055506E-01],
	[3.3390000000E+04, 2.4083774528E+01, 4.8768377421E+00, 9.0214345865E+00, 2.7978308219E+00, 9.4256772290E-01],
	[3.3395000000E+04, 2.4089866724E+01, 4.8768464809E+00, 9.0258361584E+00, 2.7983391312E+00, 9.4259487694E-01],
	[3.3400000000E+04, 2.4095959549E+01, 4.8768552184E+00, 9.0302392177E+00, 2.7988473218E+00, 9.4262201718E-01],
	[3.3405000000E+04, 2.4102053002E+01, 4.8768639546E+00, 9.0346437645E+00, 2.7993553937E+00, 9.4264914364E-01],
	[3.3410000000E+04, 2.4108147084E+01, 4.8768726896E+00, 9.0390497993E+00, 2.7998633468E+00, 9.4267625632E-01],
	[3.3415000000E+04, 2.4114241794E+01, 4.8768814232E+00, 9.0434573223E+00, 2.8003711812E+00, 9.4270335522E-01],
	[3.3420000000E+04, 2.4120337133E+01, 4.8768901555E+00, 9.0478663337E+00, 2.8008788969E+00, 9.4273044037E-01],
	[3.3425000000E+04, 2.4126433101E+01, 4.8768988866E+00, 9.0522768338E+00, 2.8013864938E+00, 9.4275751175E-01],
	[3.3430000000E+04, 2.4132529697E+01, 4.8769076163E+00, 9.0566888230E+00, 2.8018939720E+00, 9.4278456938E-01],
	[3.3435000000E+04, 2.4138626921E+01, 4.8769163448E+00, 9.0611023015E+00, 2.8024013315E+00, 9.4281161327E-01],
	[3.3440000000E+04, 2.4144724774E+01, 4.8769250719E+00, 9.0655172695E+00, 2.8029085722E+00, 9.4283864341E-01],
	[3.3445000000E+04, 2.4150823256E+01, 4.8769337978E+00, 9.0699337274E+00, 2.8034156942E+00, 9.4286565983E-01],
	[3.3450000000E+04, 2.4156940355E+01, 4.8769449969E+00, 9.0743516754E+00, 2.8039237578E+00, 9.4289266252E-01],
	[3.3455000000E+04, 2.4163058938E+01, 4.8769563111E+00, 9.0787711139E+00, 2.8044317532E+00, 9.4291965150E-01],
	[3.3460000000E+04, 2.4169178157E+01, 4.8769676237E+00, 9.0831920430E+00, 2.8049396304E+00, 9.4294662676E-01],
	[3.3465000000E+04, 2.4175298010E+01, 4.8769789346E+00, 9.0876144632E+00, 2.8054473894E+00, 9.4297358832E-01],
	[3.3470000000E+04, 2.4181418498E+01, 4.8769902438E+00, 9.0920383745E+00, 2.8059550301E+00, 9.4300053618E-01],
	[3.3475000000E+04, 2.4187539621E+01, 4.8770015514E+00, 9.0964637774E+00, 2.8064625527E+00, 9.4302747035E-01],
	[3.3480000000E+04, 2.4193661380E+01, 4.8770128573E+00, 9.1008906721E+00, 2.8069699570E+00, 9.4305439084E-01],
	[3.3485000000E+04, 2.4199783773E+01, 4.8770241615E+00, 9.1053190590E+00, 2.8074772431E+00, 9.4308129765E-01],
	[3.3490000000E+04, 2.4205906800E+01, 4.8770354641E+00, 9.1097489381E+00, 2.8079844110E+00, 9.4310819079E-01],
	[3.3495000000E+04, 2.4212030463E+01, 4.8770467650E+00, 9.1141803100E+00, 2.8084914607E+00, 9.4313507027E-01],
	[3.3500000000E+04, 2.4218154761E+01, 4.8770580643E+00, 9.1186131747E+00, 2.8089983922E+00, 9.4316193609E-01],
	[3.3505000000E+04, 2.4224279693E+01, 4.8770693619E+00, 9.1230475327E+00, 2.8095052054E+00, 9.4318878826E-01],
	[3.3510000000E+04, 2.4230405260E+01, 4.8770806578E+00, 9.1274833842E+00, 2.8100119005E+00, 9.4321562678E-01],
	[3.3515000000E+04, 2.4236531461E+01, 4.8770919521E+00, 9.1319207294E+00, 2.8105184773E+00, 9.4324245168E-01],
	[3.3520000000E+04, 2.4242658298E+01, 4.8771032448E+00, 9.1363595687E+00, 2.8110249360E+00, 9.4326926294E-01],
	[3.3525000000E+04, 2.4248785768E+01, 4.8771145357E+00, 9.1407999023E+00, 2.8115312764E+00, 9.4329606058E-01],
	[3.3530000000E+04, 2.4254913874E+01, 4.8771258250E+00, 9.1452417305E+00, 2.8120374987E+00, 9.4332284460E-01],
	[3.3535000000E+04, 2.4261042614E+01, 4.8771371127E+00, 9.1496850536E+00, 2.8125436027E+00, 9.4334961502E-01],
	[3.3540000000E+04, 2.4267171989E+01, 4.8771483987E+00, 9.1541298719E+00, 2.8130495886E+00, 9.4337637183E-01],
	[3.3545000000E+04, 2.4273301998E+01, 4.8771596830E+00, 9.1585761857E+00, 2.8135554562E+00, 9.4340311505E-01],
	[3.3550000000E+04, 2.4279432642E+01, 4.8771709657E+00, 9.1630239951E+00, 2.8140612057E+00, 9.4342984468E-01],
	[3.3555000000E+04, 2.4285563920E+01, 4.8771822467E+00, 9.1674733006E+00, 2.8145668370E+00, 9.4345656073E-01],
	[3.3560000000E+04, 2.4291695832E+01, 4.8771935261E+00, 9.1719241023E+00, 2.8150723500E+00, 9.4348326320E-01],
	[3.3565000000E+04, 2.4297828379E+01, 4.8772048038E+00, 9.1763764007E+00, 2.8155777449E+00, 9.4350995211E-01],
	[3.3570000000E+04, 2.4303961561E+01, 4.8772160799E+00, 9.1808301958E+00, 2.8160830216E+00, 9.4353662745E-01],
	[3.3575000000E+04, 2.4310095376E+01, 4.8772273543E+00, 9.1852854881E+00, 2.8165881801E+00, 9.4356328924E-01],
	[3.3580000000E+04, 2.4316229826E+01, 4.8772386270E+00, 9.1897422778E+00, 2.8170932204E+00, 9.4358993749E-01],
	[3.3585000000E+04, 2.4322364911E+01, 4.8772498982E+00, 9.1942005652E+00, 2.8175981426E+00, 9.4361657219E-01],
	[3.3590000000E+04, 2.4328500629E+01, 4.8772611676E+00, 9.1986603506E+00, 2.8181029465E+00, 9.4364319336E-01],
	[3.3595000000E+04, 2.4334636982E+01, 4.8772724354E+00, 9.2031216342E+00, 2.8186076323E+00, 9.4366980100E-01],
	[3.3600000000E+04, 2.4340773969E+01, 4.8772837016E+00, 9.2075844163E+00, 2.8191121999E+00, 9.4369639512E-01],
	[3.3605000000E+04, 2.4346911590E+01, 4.8772949661E+00, 9.2120486973E+00, 2.8196166494E+00, 9.4372297572E-01],
	[3.3610000000E+04, 2.4353049846E+01, 4.8773062289E+00, 9.2165144773E+00, 2.8201209806E+00, 9.4374954282E-01],
	[3.3615000000E+04, 2.4359188735E+01, 4.8773174901E+00, 9.2209817567E+00, 2.8206251937E+00, 9.4377609642E-01],
	[3.3620000000E+04, 2.4365328259E+01, 4.8773287497E+00, 9.2254505357E+00, 2.8211292887E+00, 9.4380263653E-01],
	[3.3625000000E+04, 2.4371468416E+01, 4.8773400076E+00, 9.2299208147E+00, 2.8216332654E+00, 9.4382916315E-01],
	[3.3630000000E+04, 2.4377609208E+01, 4.8773512638E+00, 9.2343925938E+00, 2.8221371240E+00, 9.4385567629E-01],
	[3.3635000000E+04, 2.4383750634E+01, 4.8773625184E+00, 9.2388658735E+00, 2.8226408644E+00, 9.4388217596E-01],
	[3.3640000000E+04, 2.4389892693E+01, 4.8773737714E+00, 9.2433406539E+00, 2.8231444867E+00, 9.4390866217E-01],
	[3.3645000000E+04, 2.4396035387E+01, 4.8773850227E+00, 9.2478169354E+00, 2.8236479908E+00, 9.4393513491E-01],
	[3.3650000000E+04, 2.4402178714E+01, 4.8773962724E+00, 9.2522947182E+00, 2.8241513768E+00, 9.4396159420E-01],
	[3.3655000000E+04, 2.4408322676E+01, 4.8774075204E+00, 9.2567740026E+00, 2.8246546446E+00, 9.4398804005E-01],
	[3.3660000000E+04, 2.4414467271E+01, 4.8774187668E+00, 9.2612547888E+00, 2.8251577943E+00, 9.4401447245E-01],
	[3.3665000000E+04, 2.4420612500E+01, 4.8774300115E+00, 9.2657370773E+00, 2.8256608258E+00, 9.4404089143E-01],
	[3.3670000000E+04, 2.4426758363E+01, 4.8774412546E+00, 9.2702208682E+00, 2.8261637391E+00, 9.4406729698E-01],
	[3.3675000000E+04, 2.4432904860E+01, 4.8774524961E+00, 9.2747061618E+00, 2.8266665344E+00, 9.4409368911E-01],
	[3.3680000000E+04, 2.4439051990E+01, 4.8774637359E+00, 9.2791929584E+00, 2.8271692114E+00, 9.4412006783E-01],
	[3.3685000000E+04, 2.4445199754E+01, 4.8774749740E+00, 9.2836812583E+00, 2.8276717704E+00, 9.4414643315E-01],
	[3.3690000000E+04, 2.4451348152E+01, 4.8774862106E+00, 9.2881710618E+00, 2.8281742112E+00, 9.4417278506E-01],
	[3.3695000000E+04, 2.4457497183E+01, 4.8774974454E+00, 9.2926623691E+00, 2.8286765339E+00, 9.4419912359E-01],
	[3.3700000000E+04, 2.4463646848E+01, 4.8775086787E+00, 9.2971551806E+00, 2.8291787384E+00, 9.4422544873E-01],
	[3.3705000000E+04, 2.4469797147E+01, 4.8775199103E+00, 9.3016494964E+00, 2.8296808248E+00, 9.4425176050E-01],
	[3.3710000000E+04, 2.4475948079E+01, 4.8775311402E+00, 9.3061453170E+00, 2.8301827931E+00, 9.4427805889E-01],
	[3.3715000000E+04, 2.4482099645E+01, 4.8775423685E+00, 9.3106426425E+00, 2.8306846433E+00, 9.4430434392E-01],
	[3.3720000000E+04, 2.4488251844E+01, 4.8775535952E+00, 9.3151414732E+00, 2.8311863753E+00, 9.4433061559E-01],
	[3.3725000000E+04, 2.4494404677E+01, 4.8775648203E+00, 9.3196418095E+00, 2.8316879893E+00, 9.4435687391E-01],
	[3.3730000000E+04, 2.4500558144E+01, 4.8775760437E+00, 9.3241436516E+00, 2.8321894851E+00, 9.4438311889E-01],
	[3.3735000000E+04, 2.4506712243E+01, 4.8775872654E+00, 9.3286469997E+00, 2.8326908628E+00, 9.4440935054E-01],
	[3.3740000000E+04, 2.4512866976E+01, 4.8775984855E+00, 9.3331518543E+00, 2.8331921224E+00, 9.4443556885E-01],
	[3.3745000000E+04, 2.4519022343E+01, 4.8776097040E+00, 9.3376582155E+00, 2.8336932639E+00, 9.4446177384E-01],
	[3.3750000000E+04, 2.4525178342E+01, 4.8776209209E+00, 9.3421660836E+00, 2.8341942873E+00, 9.4448796551E-01],
	[3.3755000000E+04, 2.4531334976E+01, 4.8776321361E+00, 9.3466754589E+00, 2.8346951926E+00, 9.4451414387E-01],
	[3.3760000000E+04, 2.4537492242E+01, 4.8776433497E+00, 9.3511863417E+00, 2.8351959798E+00, 9.4454030893E-01],
	[3.3765000000E+04, 2.4543650142E+01, 4.8776545616E+00, 9.3556987323E+00, 2.8356966489E+00, 9.4456646069E-01],
	[3.3770000000E+04, 2.4549808674E+01, 4.8776657719E+00, 9.3602126309E+00, 2.8361971999E+00, 9.4459259917E-01],
	[3.3775000000E+04, 2.4555967841E+01, 4.8776769806E+00, 9.3647280378E+00, 2.8366976329E+00, 9.4461872436E-01],
	[3.3780000000E+04, 2.4562127640E+01, 4.8776881877E+00, 9.3692449534E+00, 2.8371979477E+00, 9.4464483628E-01],
	[3.3785000000E+04, 2.4568288072E+01, 4.8776993931E+00, 9.3737633778E+00, 2.8376981445E+00, 9.4467093492E-01],
	[3.3790000000E+04, 2.4574449138E+01, 4.8777105968E+00, 9.3782833114E+00, 2.8381982231E+00, 9.4469702031E-01],
	[3.3795000000E+04, 2.4580610836E+01, 4.8777217990E+00, 9.3828047545E+00, 2.8386981838E+00, 9.4472309244E-01],
	[3.3800000000E+04, 2.4586773168E+01, 4.8777329995E+00, 9.3873277073E+00, 2.8391980263E+00, 9.4474915132E-01],
	[3.3805000000E+04, 2.4592936132E+01, 4.8777441984E+00, 9.3918521701E+00, 2.8396977508E+00, 9.4477519696E-01],
	[3.3810000000E+04, 2.4599099730E+01, 4.8777553956E+00, 9.3963781432E+00, 2.8401973572E+00, 9.4480122936E-01],
	[3.3815000000E+04, 2.4605263961E+01, 4.8777665913E+00, 9.4009056268E+00, 2.8406968455E+00, 9.4482724854E-01],
	[3.3820000000E+04, 2.4611428824E+01, 4.8777777853E+00, 9.4054346213E+00, 2.8411962158E+00, 9.4485325450E-01],
	[3.3825000000E+04, 2.4617594321E+01, 4.8777889776E+00, 9.4099651270E+00, 2.8416954680E+00, 9.4487924724E-01],
	[3.3830000000E+04, 2.4623760450E+01, 4.8778001684E+00, 9.4144971440E+00, 2.8421946022E+00, 9.4490522677E-01],
	[3.3835000000E+04, 2.4629927212E+01, 4.8778113575E+00, 9.4190306728E+00, 2.8426936184E+00, 9.4493119310E-01],
	[3.3840000000E+04, 2.4636094607E+01, 4.8778225450E+00, 9.4235657135E+00, 2.8431925164E+00, 9.4495714624E-01],
	[3.3845000000E+04, 2.4642262635E+01, 4.8778337308E+00, 9.4281022664E+00, 2.8436912965E+00, 9.4498308619E-01],
	[3.3850000000E+04, 2.4648431296E+01, 4.8778449150E+00, 9.4326403319E+00, 2.8441899585E+00, 9.4500901295E-01],
	[3.3855000000E+04, 2.4654600589E+01, 4.8778560976E+00, 9.4371799102E+00, 2.8446885025E+00, 9.4503492655E-01],
	[3.3860000000E+04, 2.4660770515E+01, 4.8778672786E+00, 9.4417210017E+00, 2.8451869284E+00, 9.4506082697E-01],
	[3.3865000000E+04, 2.4666941074E+01, 4.8778784580E+00, 9.4462636064E+00, 2.8456852364E+00, 9.4508671424E-01],
	[3.3870000000E+04, 2.4673112265E+01, 4.8778896357E+00, 9.4508077249E+00, 2.8461834263E+00, 9.4511258835E-01],
	[3.3875000000E+04, 2.4679284089E+01, 4.8779008118E+00, 9.4553533572E+00, 2.8466814981E+00, 9.4513844932E-01],
	[3.3880000000E+04, 2.4685456546E+01, 4.8779119863E+00, 9.4599005038E+00, 2.8471794520E+00, 9.4516429715E-01],
	[3.3885000000E+04, 2.4691629635E+01, 4.8779231591E+00, 9.4644491649E+00, 2.8476772879E+00, 9.4519013184E-01],
	[3.3890000000E+04, 2.4697803357E+01, 4.8779343303E+00, 9.4689993407E+00, 2.8481750057E+00, 9.4521595340E-01],
	[3.3895000000E+04, 2.4703977711E+01, 4.8779454999E+00, 9.4735510316E+00, 2.8486726055E+00, 9.4524176185E-01],
	[3.3900000000E+04, 2.4710152698E+01, 4.8779566679E+00, 9.4781042379E+00, 2.8491700874E+00, 9.4526755718E-01],
	[3.3905000000E+04, 2.4716328317E+01, 4.8779678343E+00, 9.4826589598E+00, 2.8496674512E+00, 9.4529333941E-01],
	[3.3910000000E+04, 2.4722504569E+01, 4.8779789990E+00, 9.4872151975E+00, 2.8501646971E+00, 9.4531910854E-01],
	[3.3915000000E+04, 2.4728681453E+01, 4.8779901622E+00, 9.4917729515E+00, 2.8506618249E+00, 9.4534486457E-01],
	[3.3920000000E+04, 2.4734858969E+01, 4.8780013237E+00, 9.4963322219E+00, 2.8511588348E+00, 9.4537060752E-01],
	[3.3925000000E+04, 2.4741037118E+01, 4.8780124835E+00, 9.5008930090E+00, 2.8516557267E+00, 9.4539633739E-01],
	[3.3930000000E+04, 2.4747215899E+01, 4.8780236418E+00, 9.5054553132E+00, 2.8521525006E+00, 9.4542205418E-01],
	[3.3935000000E+04, 2.4753395312E+01, 4.8780347984E+00, 9.5100191346E+00, 2.8526491566E+00, 9.4544775791E-01],
	[3.3940000000E+04, 2.4759575358E+01, 4.8780459535E+00, 9.5145844736E+00, 2.8531456946E+00, 9.4547344858E-01],
	[3.3945000000E+04, 2.4765756036E+01, 4.8780571069E+00, 9.5191513305E+00, 2.8536421146E+00, 9.4549912620E-01],
	[3.3950000000E+04, 2.4771937346E+01, 4.8780682587E+00, 9.5237197056E+00, 2.8541384166E+00, 9.4552479078E-01],
	[3.3955000000E+04, 2.4778119288E+01, 4.8780794088E+00, 9.5282895991E+00, 2.8546346008E+00, 9.4555044231E-01],
	[3.3960000000E+04, 2.4784301862E+01, 4.8780905574E+00, 9.5328610112E+00, 2.8551306669E+00, 9.4557608081E-01],
	[3.3965000000E+04, 2.4790485069E+01, 4.8781017043E+00, 9.5374339424E+00, 2.8556266151E+00, 9.4560170629E-01],
	[3.3970000000E+04, 2.4796668907E+01, 4.8781128497E+00, 9.5420083928E+00, 2.8561224454E+00, 9.4562731875E-01],
	[3.3975000000E+04, 2.4802853378E+01, 4.8781239934E+00, 9.5465843628E+00, 2.8566181577E+00, 9.4565291820E-01],
	[3.3980000000E+04, 2.4809038480E+01, 4.8781351355E+00, 9.5511618525E+00, 2.8571137521E+00, 9.4567850464E-01],
	[3.3985000000E+04, 2.4815229245E+01, 4.8781469625E+00, 9.5557408624E+00, 2.8576095308E+00, 9.4570407808E-01],
	[3.3990000000E+04, 2.4821434219E+01, 4.8781606403E+00, 9.5603213927E+00, 2.8581060077E+00, 9.4572963854E-01],
	[3.3995000000E+04, 2.4827639831E+01, 4.8781743161E+00, 9.5649034437E+00, 2.8586023671E+00, 9.4575518601E-01],
	[3.4000000000E+04, 2.4833846081E+01, 4.8781879899E+00, 9.5694870156E+00, 2.8590986091E+00, 9.4578072050E-01],
	[3.4005000000E+04, 2.4840052970E+01, 4.8782016618E+00, 9.5740721087E+00, 2.8595947336E+00, 9.4580624201E-01],
	[3.4010000000E+04, 2.4846260498E+01, 4.8782153316E+00, 9.5786587233E+00, 2.8600907408E+00, 9.4583175057E-01],
	[3.4015000000E+04, 2.4852468663E+01, 4.8782289995E+00, 9.5832468598E+00, 2.8605866305E+00, 9.4585724616E-01],
	[3.4020000000E+04, 2.4858677468E+01, 4.8782426655E+00, 9.5878365183E+00, 2.8610824028E+00, 9.4588272881E-01],
	[3.4025000000E+04, 2.4864886910E+01, 4.8782563294E+00, 9.5924276991E+00, 2.8615780576E+00, 9.4590819851E-01],
	[3.4030000000E+04, 2.4871096991E+01, 4.8782699914E+00, 9.5970204026E+00, 2.8620735951E+00, 9.4593365527E-01],
	[3.4035000000E+04, 2.4877307710E+01, 4.8782836514E+00, 9.6016146290E+00, 2.8625690152E+00, 9.4595909911E-01],
	[3.4040000000E+04, 2.4883519067E+01, 4.8782973095E+00, 9.6062103786E+00, 2.8630643179E+00, 9.4598453002E-01],
	[3.4045000000E+04, 2.4889731063E+01, 4.8783109656E+00, 9.6108076517E+00, 2.8635595031E+00, 9.4600994801E-01],
	[3.4050000000E+04, 2.4895943696E+01, 4.8783246197E+00, 9.6154064485E+00, 2.8640545710E+00, 9.4603535309E-01],
	[3.4055000000E+04, 2.4902156968E+01, 4.8783382718E+00, 9.6200067694E+00, 2.8645495215E+00, 9.4606074527E-01],
	[3.4060000000E+04, 2.4908370878E+01, 4.8783519220E+00, 9.6246086145E+00, 2.8650443546E+00, 9.4608612455E-01],
	[3.4065000000E+04, 2.4914585426E+01, 4.8783655702E+00, 9.6292119843E+00, 2.8655390704E+00, 9.4611149094E-01],
	[3.4070000000E+04, 2.4920800612E+01, 4.8783792165E+00, 9.6338168790E+00, 2.8660336688E+00, 9.4613684444E-01],
	[3.4075000000E+04, 2.4927016436E+01, 4.8783928608E+00, 9.6384232988E+00, 2.8665281498E+00, 9.4616218507E-01],
	[3.4080000000E+04, 2.4933232899E+01, 4.8784065031E+00, 9.6430312441E+00, 2.8670225134E+00, 9.4618751283E-01],
	[3.4085000000E+04, 2.4939449999E+01, 4.8784201435E+00, 9.6476407150E+00, 2.8675167597E+00, 9.4621282772E-01],
	[3.4090000000E+04, 2.4945667737E+01, 4.8784337819E+00, 9.6522517120E+00, 2.8680108887E+00, 9.4623812976E-01],
	[3.4095000000E+04, 2.4951886113E+01, 4.8784474183E+00, 9.6568642353E+00, 2.8685049002E+00, 9.4626341895E-01],
	[3.4100000000E+04, 2.4958105127E+01, 4.8784610528E+00, 9.6614782851E+00, 2.8689987945E+00, 9.4628869530E-01],
	[3.4105000000E+04, 2.4964324779E+01, 4.8784746853E+00, 9.6660938618E+00, 2.8694925714E+00, 9.4631395880E-01],
	[3.4110000000E+04, 2.4970545068E+01, 4.8784883159E+00, 9.6707109656E+00, 2.8699862310E+00, 9.4633920948E-01],
	[3.4115000000E+04, 2.4976765996E+01, 4.8785019445E+00, 9.6753295968E+00, 2.8704797732E+00, 9.4636444734E-01],
	[3.4120000000E+04, 2.4982987561E+01, 4.8785155711E+00, 9.6799497557E+00, 2.8709731982E+00, 9.4638967238E-01],
	[3.4125000000E+04, 2.4989209764E+01, 4.8785291958E+00, 9.6845714426E+00, 2.8714665058E+00, 9.4641488461E-01],
	[3.4130000000E+04, 2.4995432605E+01, 4.8785428185E+00, 9.6891946577E+00, 2.8719596961E+00, 9.4644008403E-01],
	[3.4135000000E+04, 2.5001656084E+01, 4.8785564393E+00, 9.6938194013E+00, 2.8724527690E+00, 9.4646527067E-01],
	[3.4140000000E+04, 2.5007880200E+01, 4.8785700581E+00, 9.6984456738E+00, 2.8729457247E+00, 9.4649044451E-01],
	[3.4145000000E+04, 2.5014104954E+01, 4.8785836749E+00, 9.7030734754E+00, 2.8734385631E+00, 9.4651560556E-01],
	[3.4150000000E+04, 2.5020330345E+01, 4.8785972898E+00, 9.7077028063E+00, 2.8739312842E+00, 9.4654075385E-01],
	[3.4155000000E+04, 2.5026556374E+01, 4.8786109028E+00, 9.7123336669E+00, 2.8744238880E+00, 9.4656588936E-01],
	[3.4160000000E+04, 2.5032783041E+01, 4.8786245137E+00, 9.7169660574E+00, 2.8749163745E+00, 9.4659101211E-01],
	[3.4165000000E+04, 2.5039010345E+01, 4.8786381228E+00, 9.7215999781E+00, 2.8754087438E+00, 9.4661612210E-01],
	[3.4170000000E+04, 2.5045238287E+01, 4.8786517298E+00, 9.7262354294E+00, 2.8759009958E+00, 9.4664121935E-01],
	[3.4175000000E+04, 2.5051466866E+01, 4.8786653350E+00, 9.7308724114E+00, 2.8763931305E+00, 9.4666630385E-01],
	[3.4180000000E+04, 2.5057696082E+01, 4.8786789381E+00, 9.7355109245E+00, 2.8768851479E+00, 9.4669137562E-01],
	[3.4185000000E+04, 2.5063925936E+01, 4.8786925394E+00, 9.7401509689E+00, 2.8773770481E+00, 9.4671643465E-01],
	[3.4190000000E+04, 2.5070156428E+01, 4.8787061386E+00, 9.7447925449E+00, 2.8778688310E+00, 9.4674148097E-01],
	[3.4195000000E+04, 2.5076387557E+01, 4.8787197359E+00, 9.7494356529E+00, 2.8783604967E+00, 9.4676651457E-01],
	[3.4200000000E+04, 2.5082619323E+01, 4.8787333313E+00, 9.7540802930E+00, 2.8788520452E+00, 9.4679153546E-01],
	[3.4205000000E+04, 2.5088851726E+01, 4.8787469247E+00, 9.7587264656E+00, 2.8793434764E+00, 9.4681654364E-01],
	[3.4210000000E+04, 2.5095084767E+01, 4.8787605162E+00, 9.7633741709E+00, 2.8798347904E+00, 9.4684153913E-01],
	[3.4215000000E+04, 2.5101318445E+01, 4.8787741057E+00, 9.7680234093E+00, 2.8803259871E+00, 9.4686652194E-01],
	[3.4220000000E+04, 2.5107552760E+01, 4.8787876933E+00, 9.7726741810E+00, 2.8808170667E+00, 9.4689149206E-01],
	[3.4225000000E+04, 2.5113787713E+01, 4.8788012789E+00, 9.7773264862E+00, 2.8813080290E+00, 9.4691644950E-01],
	[3.4230000000E+04, 2.5120023302E+01, 4.8788148626E+00, 9.7819803254E+00, 2.8817988741E+00, 9.4694139428E-01],
	[3.4235000000E+04, 2.5126259529E+01, 4.8788284443E+00, 9.7866356987E+00, 2.8822896021E+00, 9.4696632639E-01],
	[3.4240000000E+04, 2.5132496393E+01, 4.8788420241E+00, 9.7912926064E+00, 2.8827802128E+00, 9.4699124585E-01],
	[3.4245000000E+04, 2.5138733894E+01, 4.8788556019E+00, 9.7959510488E+00, 2.8832707063E+00, 9.4701615266E-01],
	[3.4250000000E+04, 2.5144972032E+01, 4.8788691778E+00, 9.8006110263E+00, 2.8837610827E+00, 9.4704104683E-01],
	[3.4255000000E+04, 2.5151210807E+01, 4.8788827518E+00, 9.8052725390E+00, 2.8842513418E+00, 9.4706592836E-01],
	[3.4260000000E+04, 2.5157450219E+01, 4.8788963238E+00, 9.8099355873E+00, 2.8847414838E+00, 9.4709079726E-01],
	[3.4265000000E+04, 2.5163690268E+01, 4.8789098939E+00, 9.8146001714E+00, 2.8852315087E+00, 9.4711565354E-01],
	[3.4270000000E+04, 2.5169930954E+01, 4.8789234620E+00, 9.8192662916E+00, 2.8857214163E+00, 9.4714049721E-01],
	[3.4275000000E+04, 2.5176172277E+01, 4.8789370282E+00, 9.8239339482E+00, 2.8862112068E+00, 9.4716532827E-01],
	[3.4280000000E+04, 2.5182414237E+01, 4.8789505924E+00, 9.8286031416E+00, 2.8867008802E+00, 9.4719014672E-01],
	[3.4285000000E+04, 2.5188656834E+01, 4.8789641547E+00, 9.8332738718E+00, 2.8871904364E+00, 9.4721495258E-01],
	[3.4290000000E+04, 2.5194900067E+01, 4.8789777151E+00, 9.8379461394E+00, 2.8876798755E+00, 9.4723974585E-01],
	[3.4295000000E+04, 2.5201143937E+01, 4.8789912735E+00, 9.8426199444E+00, 2.8881691974E+00, 9.4726452654E-01],
	[3.4300000000E+04, 2.5207388445E+01, 4.8790048300E+00, 9.8472952873E+00, 2.8886584022E+00, 9.4728929466E-01],
	[3.4305000000E+04, 2.5213633588E+01, 4.8790183845E+00, 9.8519721683E+00, 2.8891474899E+00, 9.4731405020E-01],
	[3.4310000000E+04, 2.5219879369E+01, 4.8790319371E+00, 9.8566505876E+00, 2.8896364605E+00, 9.4733879318E-01],
	[3.4315000000E+04, 2.5226125786E+01, 4.8790454878E+00, 9.8613305456E+00, 2.8901253140E+00, 9.4736352361E-01],
	[3.4320000000E+04, 2.5232372840E+01, 4.8790590365E+00, 9.8660120425E+00, 2.8906140504E+00, 9.4738824149E-01],
	[3.4325000000E+04, 2.5238620531E+01, 4.8790725833E+00, 9.8706950786E+00, 2.8911026696E+00, 9.4741294683E-01],
	[3.4330000000E+04, 2.5244868858E+01, 4.8790861282E+00, 9.8753796543E+00, 2.8915911718E+00, 9.4743763963E-01],
	[3.4335000000E+04, 2.5251117822E+01, 4.8790996711E+00, 9.8800657697E+00, 2.8920795569E+00, 9.4746231990E-01],
	[3.4340000000E+04, 2.5257367422E+01, 4.8791132121E+00, 9.8847534251E+00, 2.8925678249E+00, 9.4748698765E-01],
	[3.4345000000E+04, 2.5263617659E+01, 4.8791267511E+00, 9.8894426209E+00, 2.8930559759E+00, 9.4751164289E-01],
	[3.4350000000E+04, 2.5269868533E+01, 4.8791402883E+00, 9.8941333574E+00, 2.8935440098E+00, 9.4753628561E-01],
	[3.4355000000E+04, 2.5276120043E+01, 4.8791538234E+00, 9.8988256347E+00, 2.8940319266E+00, 9.4756091583E-01],
	[3.4360000000E+04, 2.5282372189E+01, 4.8791673567E+00, 9.9035194532E+00, 2.8945197263E+00, 9.4758553355E-01],
	[3.4365000000E+04, 2.5288624972E+01, 4.8791808880E+00, 9.9082148132E+00, 2.8950074091E+00, 9.4761013878E-01],
	[3.4370000000E+04, 2.5294878391E+01, 4.8791944174E+00, 9.9129117149E+00, 2.8954949747E+00, 9.4763473152E-01],
	[3.4375000000E+04, 2.5301132446E+01, 4.8792079449E+00, 9.9176101587E+00, 2.8959824234E+00, 9.4765931178E-01],
	[3.4380000000E+04, 2.5307387138E+01, 4.8792214704E+00, 9.9223101448E+00, 2.8964697550E+00, 9.4768387957E-01],
	[3.4385000000E+04, 2.5313642466E+01, 4.8792349940E+00, 9.9270116735E+00, 2.8969569696E+00, 9.4770843489E-01],
	[3.4390000000E+04, 2.5319898431E+01, 4.8792485157E+00, 9.9317147450E+00, 2.8974440672E+00, 9.4773297775E-01],
	[3.4395000000E+04, 2.5326155032E+01, 4.8792620354E+00, 9.9364193597E+00, 2.8979310477E+00, 9.4775750815E-01],
	[3.4400000000E+04, 2.5332412269E+01, 4.8792755533E+00, 9.9411255178E+00, 2.8984179113E+00, 9.4778202610E-01],
	[3.4405000000E+04, 2.5338670142E+01, 4.8792890692E+00, 9.9458332197E+00, 2.8989046579E+00, 9.4780653161E-01],
	[3.4410000000E+04, 2.5344928651E+01, 4.8793025831E+00, 9.9505424656E+00, 2.8993912875E+00, 9.4783102469E-01],
	[3.4415000000E+04, 2.5351187796E+01, 4.8793160952E+00, 9.9552532557E+00, 2.8998778001E+00, 9.4785550533E-01],
	[3.4420000000E+04, 2.5357447578E+01, 4.8793296053E+00, 9.9599655904E+00, 2.9003641957E+00, 9.4787997354E-01],
	[3.4425000000E+04, 2.5363707996E+01, 4.8793431135E+00, 9.9646794699E+00, 2.9008504744E+00, 9.4790442934E-01],
	[3.4430000000E+04, 2.5369969049E+01, 4.8793566197E+00, 9.9693948946E+00, 2.9013366360E+00, 9.4792887272E-01],
	[3.4435000000E+04, 2.5376230739E+01, 4.8793701241E+00, 9.9741118647E+00, 2.9018226808E+00, 9.4795330369E-01],
	[3.4440000000E+04, 2.5382493065E+01, 4.8793836265E+00, 9.9788303805E+00, 2.9023086086E+00, 9.4797772227E-01],
	[3.4445000000E+04, 2.5388756027E+01, 4.8793971270E+00, 9.9835504422E+00, 2.9027944194E+00, 9.4800212845E-01],
	[3.4450000000E+04, 2.5395019624E+01, 4.8794106256E+00, 9.9882720502E+00, 2.9032801133E+00, 9.4802652224E-01],
	[3.4455000000E+04, 2.5401283858E+01, 4.8794241222E+00, 9.9929952047E+00, 2.9037656903E+00, 9.4805090364E-01],
	[3.4460000000E+04, 2.5407548727E+01, 4.8794376169E+00, 9.9977199061E+00, 2.9042511504E+00, 9.4807527267E-01],
	[3.4465000000E+04, 2.5413814233E+01, 4.8794511098E+00, 1.0002446155E+01, 2.9047364935E+00, 9.4809962933E-01],
	[3.4470000000E+04, 2.5420080374E+01, 4.8794646006E+00, 1.0007173950E+01, 2.9052217197E+00, 9.4812397363E-01],
	[3.4475000000E+04, 2.5426347151E+01, 4.8794780896E+00, 1.0011903294E+01, 2.9057068291E+00, 9.4814830557E-01],
	[3.4480000000E+04, 2.5432614564E+01, 4.8794915767E+00, 1.0016634185E+01, 2.9061918215E+00, 9.4817262515E-01],
	[3.4485000000E+04, 2.5438882612E+01, 4.8795050618E+00, 1.0021366625E+01, 2.9066766971E+00, 9.4819693239E-01],
	[3.4490000000E+04, 2.5445151297E+01, 4.8795185450E+00, 1.0026100613E+01, 2.9071614557E+00, 9.4822122729E-01],
	[3.4495000000E+04, 2.5451420617E+01, 4.8795320263E+00, 1.0030836150E+01, 2.9076460975E+00, 9.4824550985E-01],
	[3.4500000000E+04, 2.5457690572E+01, 4.8795455057E+00, 1.0035573236E+01, 2.9081306225E+00, 9.4826978009E-01],
	[3.4505000000E+04, 2.5463961163E+01, 4.8795589832E+00, 1.0040311871E+01, 2.9086150305E+00, 9.4829403800E-01],
	[3.4510000000E+04, 2.5470232390E+01, 4.8795724587E+00, 1.0045052056E+01, 2.9090993217E+00, 9.4831828360E-01],
	[3.4515000000E+04, 2.5476504253E+01, 4.8795859323E+00, 1.0049793791E+01, 2.9095834961E+00, 9.4834251689E-01],
	[3.4520000000E+04, 2.5482776751E+01, 4.8795994041E+00, 1.0054537076E+01, 2.9100675536E+00, 9.4836673787E-01],
	[3.4525000000E+04, 2.5489049884E+01, 4.8796128739E+00, 1.0059281912E+01, 2.9105514943E+00, 9.4839094656E-01],
	[3.4530000000E+04, 2.5495323654E+01, 4.8796263418E+00, 1.0064028298E+01, 2.9110353182E+00, 9.4841514295E-01],
	[3.4535000000E+04, 2.5501613711E+01, 4.8796419282E+00, 1.0068776236E+01, 2.9115199842E+00, 9.4843932706E-01],
	[3.4540000000E+04, 2.5507907122E+01, 4.8796578798E+00, 1.0073525724E+01, 2.9120047000E+00, 9.4846349889E-01],
	[3.4545000000E+04, 2.5514201174E+01, 4.8796738291E+00, 1.0078276765E+01, 2.9124892994E+00, 9.4848765845E-01],
	[3.4550000000E+04, 2.5520495869E+01, 4.8796897762E+00, 1.0083029357E+01, 2.9129737825E+00, 9.4851180574E-01],
	[3.4555000000E+04, 2.5526791205E+01, 4.8797057211E+00, 1.0087783501E+01, 2.9134581493E+00, 9.4853594077E-01],
	[3.4560000000E+04, 2.5533087183E+01, 4.8797216637E+00, 1.0092539198E+01, 2.9139423997E+00, 9.4856006354E-01],
	[3.4565000000E+04, 2.5539383803E+01, 4.8797376040E+00, 1.0097296448E+01, 2.9144265339E+00, 9.4858417406E-01],
	[3.4570000000E+04, 2.5545681064E+01, 4.8797535421E+00, 1.0102055250E+01, 2.9149105517E+00, 9.4860827235E-01],
	[3.4575000000E+04, 2.5551978967E+01, 4.8797694779E+00, 1.0106815606E+01, 2.9153944532E+00, 9.4863235839E-01],
	[3.4580000000E+04, 2.5558277512E+01, 4.8797854115E+00, 1.0111577516E+01, 2.9158782385E+00, 9.4865643221E-01],
	[3.4585000000E+04, 2.5564576698E+01, 4.8798013428E+00, 1.0116340979E+01, 2.9163619074E+00, 9.4868049379E-01],
	[3.4590000000E+04, 2.5570876526E+01, 4.8798172719E+00, 1.0121105996E+01, 2.9168454601E+00, 9.4870454317E-01],
	[3.4595000000E+04, 2.5577176996E+01, 4.8798331987E+00, 1.0125872568E+01, 2.9173288965E+00, 9.4872858032E-01],
	[3.4600000000E+04, 2.5583478107E+01, 4.8798491233E+00, 1.0130640695E+01, 2.9178122167E+00, 9.4875260528E-01],
	[3.4605000000E+04, 2.5589779859E+01, 4.8798650456E+00, 1.0135410377E+01, 2.9182954206E+00, 9.4877661803E-01],
	[3.4610000000E+04, 2.5596082253E+01, 4.8798809657E+00, 1.0140181613E+01, 2.9187785083E+00, 9.4880061858E-01],
	[3.4615000000E+04, 2.5602385288E+01, 4.8798968835E+00, 1.0144954406E+01, 2.9192614797E+00, 9.4882460695E-01],
	[3.4620000000E+04, 2.5608688965E+01, 4.8799127991E+00, 1.0149728754E+01, 2.9197443349E+00, 9.4884858314E-01],
	[3.4625000000E+04, 2.5614993283E+01, 4.8799287124E+00, 1.0154504658E+01, 2.9202270738E+00, 9.4887254715E-01],
	[3.4630000000E+04, 2.5621298242E+01, 4.8799446235E+00, 1.0159282119E+01, 2.9207096966E+00, 9.4889649899E-01],
	[3.4635000000E+04, 2.5627603843E+01, 4.8799605323E+00, 1.0164061137E+01, 2.9211922031E+00, 9.4892043867E-01],
	[3.4640000000E+04, 2.5633910085E+01, 4.8799764389E+00, 1.0168841711E+01, 2.9216745935E+00, 9.4894436619E-01],
	[3.4645000000E+04, 2.5640216968E+01, 4.8799923433E+00, 1.0173623843E+01, 2.9221568676E+00, 9.4896828156E-01],
	[3.4650000000E+04, 2.5646524493E+01, 4.8800082454E+00, 1.0178407532E+01, 2.9226390255E+00, 9.4899218478E-01],
	[3.4655000000E+04, 2.5652832658E+01, 4.8800241453E+00, 1.0183192779E+01, 2.9231210673E+00, 9.4901607586E-01],
	[3.4660000000E+04, 2.5659141465E+01, 4.8800400429E+00, 1.0187979584E+01, 2.9236029929E+00, 9.4903995481E-01],
	[3.4665000000E+04, 2.5665450913E+01, 4.8800559383E+00, 1.0192767947E+01, 2.9240848024E+00, 9.4906382163E-01],
	[3.4670000000E+04, 2.5671761003E+01, 4.8800718314E+00, 1.0197557869E+01, 2.9245664957E+00, 9.4908767634E-01],
	[3.4675000000E+04, 2.5678071733E+01, 4.8800877223E+00, 1.0202349350E+01, 2.9250480728E+00, 9.4911151892E-01],
	[3.4680000000E+04, 2.5684383104E+01, 4.8801036110E+00, 1.0207142391E+01, 2.9255295338E+00, 9.4913534940E-01],
	[3.4685000000E+04, 2.5690695117E+01, 4.8801194974E+00, 1.0211936990E+01, 2.9260108786E+00, 9.4915916777E-01],
	[3.4690000000E+04, 2.5697007770E+01, 4.8801353816E+00, 1.0216733150E+01, 2.9264921074E+00, 9.4918297405E-01],
	[3.4695000000E+04, 2.5703321065E+01, 4.8801512636E+00, 1.0221530869E+01, 2.9269732200E+00, 9.4920676823E-01],
	[3.4700000000E+04, 2.5709635000E+01, 4.8801671433E+00, 1.0226330149E+01, 2.9274542165E+00, 9.4923055033E-01],
	[3.4705000000E+04, 2.5715949576E+01, 4.8801830207E+00, 1.0231130990E+01, 2.9279350969E+00, 9.4925432035E-01],
	[3.4710000000E+04, 2.5722264794E+01, 4.8801988960E+00, 1.0235933391E+01, 2.9284158612E+00, 9.4927807830E-01],
	[3.4715000000E+04, 2.5728580652E+01, 4.8802147690E+00, 1.0240737354E+01, 2.9288965095E+00, 9.4930182419E-01],
	[3.4720000000E+04, 2.5734897151E+01, 4.8802306398E+00, 1.0245542878E+01, 2.9293770416E+00, 9.4932555801E-01],
	[3.4725000000E+04, 2.5741214291E+01, 4.8802465083E+00, 1.0250349964E+01, 2.9298574577E+00, 9.4934927978E-01],
	[3.4730000000E+04, 2.5747532071E+01, 4.8802623746E+00, 1.0255158612E+01, 2.9303377577E+00, 9.4937298950E-01],
	[3.4735000000E+04, 2.5753850493E+01, 4.8802782387E+00, 1.0259968822E+01, 2.9308179417E+00, 9.4939668717E-01],
	[3.4740000000E+04, 2.5760169555E+01, 4.8802941005E+00, 1.0264780595E+01, 2.9312980096E+00, 9.4942037281E-01],
	[3.4745000000E+04, 2.5766489258E+01, 4.8803099601E+00, 1.0269593931E+01, 2.9317779615E+00, 9.4944404642E-01],
	[3.4750000000E+04, 2.5772809601E+01, 4.8803258175E+00, 1.0274408830E+01, 2.9322577974E+00, 9.4946770801E-01],
	[3.4755000000E+04, 2.5779130585E+01, 4.8803416727E+00, 1.0279225292E+01, 2.9327375172E+00, 9.4949135758E-01],
	[3.4760000000E+04, 2.5785452210E+01, 4.8803575256E+00, 1.0284043318E+01, 2.9332171210E+00, 9.4951499513E-01],
	[3.4765000000E+04, 2.5791774476E+01, 4.8803733763E+00, 1.0288862908E+01, 2.9336966089E+00, 9.4953862069E-01],
	[3.4770000000E+04, 2.5798097382E+01, 4.8803892247E+00, 1.0293684063E+01, 2.9341759807E+00, 9.4956223424E-01],
	[3.4775000000E+04, 2.5804420928E+01, 4.8804050710E+00, 1.0298506782E+01, 2.9346552365E+00, 9.4958583579E-01],
	[3.4780000000E+04, 2.5810745116E+01, 4.8804209150E+00, 1.0303331066E+01, 2.9351343764E+00, 9.4960942536E-01],
	[3.4785000000E+04, 2.5817069943E+01, 4.8804367567E+00, 1.0308156915E+01, 2.9356134002E+00, 9.4963300295E-01],
	[3.4790000000E+04, 2.5823395411E+01, 4.8804525963E+00, 1.0312984329E+01, 2.9360923081E+00, 9.4965656856E-01],
	[3.4795000000E+04, 2.5829721520E+01, 4.8804684336E+00, 1.0317813309E+01, 2.9365711001E+00, 9.4968012221E-01],
	[3.4800000000E+04, 2.5836048269E+01, 4.8804842687E+00, 1.0322643856E+01, 2.9370497761E+00, 9.4970366389E-01],
	[3.4805000000E+04, 2.5842375658E+01, 4.8805001016E+00, 1.0327475968E+01, 2.9375283362E+00, 9.4972719361E-01],
	[3.4810000000E+04, 2.5848703688E+01, 4.8805159323E+00, 1.0332309647E+01, 2.9380067803E+00, 9.4975071138E-01],
	[3.4815000000E+04, 2.5855032358E+01, 4.8805317607E+00, 1.0337144893E+01, 2.9384851086E+00, 9.4977421720E-01],
	[3.4820000000E+04, 2.5861361669E+01, 4.8805475869E+00, 1.0341981706E+01, 2.9389633209E+00, 9.4979771109E-01],
	[3.4825000000E+04, 2.5867691619E+01, 4.8805634109E+00, 1.0346820086E+01, 2.9394414173E+00, 9.4982119304E-01],
	[3.4830000000E+04, 2.5874022210E+01, 4.8805792327E+00, 1.0351660034E+01, 2.9399193978E+00, 9.4984466307E-01],
	[3.4835000000E+04, 2.5880353442E+01, 4.8805950523E+00, 1.0356501550E+01, 2.9403972624E+00, 9.4986812118E-01],
	[3.4840000000E+04, 2.5886685313E+01, 4.8806108696E+00, 1.0361344634E+01, 2.9408750111E+00, 9.4989156737E-01],
	[3.4845000000E+04, 2.5893017824E+01, 4.8806266847E+00, 1.0366189287E+01, 2.9413526440E+00, 9.4991500165E-01],
	[3.4850000000E+04, 2.5899350976E+01, 4.8806424976E+00, 1.0371035509E+01, 2.9418301610E+00, 9.4993842403E-01],
	[3.4855000000E+04, 2.5905684768E+01, 4.8806583083E+00, 1.0375883299E+01, 2.9423075622E+00, 9.4996183451E-01],
	[3.4860000000E+04, 2.5912019200E+01, 4.8806741168E+00, 1.0380732659E+01, 2.9427848475E+00, 9.4998523310E-01],
	[3.4865000000E+04, 2.5918354272E+01, 4.8806899230E+00, 1.0385583589E+01, 2.9432620169E+00, 9.5000861981E-01],
	[3.4870000000E+04, 2.5924689984E+01, 4.8807057270E+00, 1.0390436089E+01, 2.9437390706E+00, 9.5003199464E-01],
	[3.4875000000E+04, 2.5931026336E+01, 4.8807215289E+00, 1.0395290159E+01, 2.9442160084E+00, 9.5005535760E-01],
	[3.4880000000E+04, 2.5937363328E+01, 4.8807373285E+00, 1.0400145799E+01, 2.9446928304E+00, 9.5007870869E-01],
	[3.4885000000E+04, 2.5943700960E+01, 4.8807531259E+00, 1.0405003010E+01, 2.9451695366E+00, 9.5010204792E-01],
	[3.4890000000E+04, 2.5950039232E+01, 4.8807689210E+00, 1.0409861793E+01, 2.9456461270E+00, 9.5012537529E-01],
	[3.4895000000E+04, 2.5956378144E+01, 4.8807847140E+00, 1.0414722146E+01, 2.9461226017E+00, 9.5014869082E-01],
	[3.4900000000E+04, 2.5962717696E+01, 4.8808005048E+00, 1.0419584071E+01, 2.9465989605E+00, 9.5017199451E-01],
	[3.4905000000E+04, 2.5969057887E+01, 4.8808162933E+00, 1.0424447569E+01, 2.9470752036E+00, 9.5019528636E-01],
	[3.4910000000E+04, 2.5975398719E+01, 4.8808320796E+00, 1.0429312638E+01, 2.9475513310E+00, 9.5021856638E-01],
	[3.4915000000E+04, 2.5981740190E+01, 4.8808478638E+00, 1.0434179280E+01, 2.9480273426E+00, 9.5024183457E-01],
	[3.4920000000E+04, 2.5988082301E+01, 4.8808636457E+00, 1.0439047495E+01, 2.9485032384E+00, 9.5026509095E-01],
	[3.4925000000E+04, 2.5994425051E+01, 4.8808794254E+00, 1.0443917282E+01, 2.9489790185E+00, 9.5028833551E-01],
	[3.4930000000E+04, 2.6000768442E+01, 4.8808952029E+00, 1.0448788643E+01, 2.9494546829E+00, 9.5031156827E-01],
	[3.4935000000E+04, 2.6007112472E+01, 4.8809109782E+00, 1.0453661578E+01, 2.9499302316E+00, 9.5033478923E-01],
	[3.4940000000E+04, 2.6013457142E+01, 4.8809267512E+00, 1.0458536087E+01, 2.9504056646E+00, 9.5035799840E-01],
	[3.4945000000E+04, 2.6019802451E+01, 4.8809425221E+00, 1.0463412169E+01, 2.9508809819E+00, 9.5038119578E-01],
	[3.4950000000E+04, 2.6026148400E+01, 4.8809582908E+00, 1.0468289827E+01, 2.9513561835E+00, 9.5040438138E-01],
	[3.4955000000E+04, 2.6032494989E+01, 4.8809740573E+00, 1.0473169059E+01, 2.9518312694E+00, 9.5042755520E-01],
	[3.4960000000E+04, 2.6038842217E+01, 4.8809898215E+00, 1.0478049866E+01, 2.9523062396E+00, 9.5045071725E-01],
	[3.4965000000E+04, 2.6045190084E+01, 4.8810055836E+00, 1.0482932248E+01, 2.9527810942E+00, 9.5047386754E-01],
	[3.4970000000E+04, 2.6051538592E+01, 4.8810213434E+00, 1.0487816206E+01, 2.9532558332E+00, 9.5049700607E-01],
	[3.4975000000E+04, 2.6057887738E+01, 4.8810371011E+00, 1.0492701740E+01, 2.9537304565E+00, 9.5052013285E-01],
	[3.4980000000E+04, 2.6064237524E+01, 4.8810528565E+00, 1.0497588850E+01, 2.9542049642E+00, 9.5054324789E-01],
	[3.4985000000E+04, 2.6070587950E+01, 4.8810686098E+00, 1.0502477536E+01, 2.9546793562E+00, 9.5056635118E-01],
	[3.4990000000E+04, 2.6076939015E+01, 4.8810843608E+00, 1.0507367799E+01, 2.9551536327E+00, 9.5058944274E-01],
	[3.4995000000E+04, 2.6083290719E+01, 4.8811001097E+00, 1.0512259639E+01, 2.9556277935E+00, 9.5061252258E-01],
	[3.5000000000E+04, 2.6089643063E+01, 4.8811158563E+00, 1.0517153057E+01, 2.9561018388E+00, 9.5063559069E-01],
	[3.5005000000E+04, 2.6095996045E+01, 4.8811316008E+00, 1.0522055183E+01, 2.9565763314E+00, 9.5065864709E-01],
	[3.5010000000E+04, 2.6102349668E+01, 4.8811473431E+00, 1.0526958892E+01, 2.9570507083E+00, 9.5068169178E-01],
	[3.5015000000E+04, 2.6108703929E+01, 4.8811630831E+00, 1.0531864186E+01, 2.9575249694E+00, 9.5070472477E-01],
	[3.5020000000E+04, 2.6115058830E+01, 4.8811788210E+00, 1.0536771064E+01, 2.9579991147E+00, 9.5072774606E-01],
	[3.5025000000E+04, 2.6121414370E+01, 4.8811945566E+00, 1.0541679526E+01, 2.9584731442E+00, 9.5075075566E-01],
	[3.5030000000E+04, 2.6127770549E+01, 4.8812102901E+00, 1.0546589572E+01, 2.9589470579E+00, 9.5077375357E-01],
	[3.5035000000E+04, 2.6134127367E+01, 4.8812260214E+00, 1.0551501204E+01, 2.9594208559E+00, 9.5079673981E-01],
	[3.5040000000E+04, 2.6140484824E+01, 4.8812417505E+00, 1.0556414421E+01, 2.9598945381E+00, 9.5081971437E-01],
	[3.5045000000E+04, 2.6146842921E+01, 4.8812574773E+00, 1.0561329224E+01, 2.9603681046E+00, 9.5084267726E-01],
	[3.5050000000E+04, 2.6153201656E+01, 4.8812732020E+00, 1.0566245612E+01, 2.9608415553E+00, 9.5086562850E-01],
	[3.5055000000E+04, 2.6159561031E+01, 4.8812889245E+00, 1.0571163587E+01, 2.9613148903E+00, 9.5088856808E-01],
	[3.5060000000E+04, 2.6165921044E+01, 4.8813046449E+00, 1.0576083148E+01, 2.9617881096E+00, 9.5091149601E-01],
	[3.5065000000E+04, 2.6172281697E+01, 4.8813203630E+00, 1.0581004296E+01, 2.9622612132E+00, 9.5093441230E-01],
	[3.5070000000E+04, 2.6178642988E+01, 4.8813360789E+00, 1.0585927030E+01, 2.9627342011E+00, 9.5095731695E-01],
	[3.5075000000E+04, 2.6185004919E+01, 4.8813517926E+00, 1.0590851353E+01, 2.9632070733E+00, 9.5098020997E-01],
	[3.5080000000E+04, 2.6191367488E+01, 4.8813675042E+00, 1.0595777262E+01, 2.9636798298E+00, 9.5100309137E-01],
	[3.5085000000E+04, 2.6197730696E+01, 4.8813832135E+00, 1.0600704760E+01, 2.9641524706E+00, 9.5102596115E-01],
	[3.5090000000E+04, 2.6204106745E+01, 4.8814005601E+00, 1.0605633845E+01, 2.9646257567E+00, 9.5104881932E-01],
	[3.5095000000E+04, 2.6210489373E+01, 4.8814187017E+00, 1.0610564519E+01, 2.9650992976E+00, 9.5107166588E-01],
	[3.5100000000E+04, 2.6216872646E+01, 4.8814368407E+00, 1.0615496782E+01, 2.9655727233E+00, 9.5109450084E-01],
	[3.5105000000E+04, 2.6223256564E+01, 4.8814549773E+00, 1.0620430634E+01, 2.9660460338E+00, 9.5111732420E-01],
	[3.5110000000E+04, 2.6229641128E+01, 4.8814731113E+00, 1.0625366075E+01, 2.9665192292E+00, 9.5114013598E-01],
	[3.5115000000E+04, 2.6236026336E+01, 4.8814912428E+00, 1.0630303105E+01, 2.9669923093E+00, 9.5116293617E-01],
	[3.5120000000E+04, 2.6242412189E+01, 4.8815093718E+00, 1.0635241726E+01, 2.9674652744E+00, 9.5118572479E-01],
	[3.5125000000E+04, 2.6248798687E+01, 4.8815274983E+00, 1.0640181936E+01, 2.9679381242E+00, 9.5120850184E-01],
	[3.5130000000E+04, 2.6255185830E+01, 4.8815456223E+00, 1.0645123737E+01, 2.9684108590E+00, 9.5123126732E-01],
	[3.5135000000E+04, 2.6261573618E+01, 4.8815637438E+00, 1.0650067129E+01, 2.9688834786E+00, 9.5125402125E-01],
	[3.5140000000E+04, 2.6267962050E+01, 4.8815818627E+00, 1.0655012112E+01, 2.9693559830E+00, 9.5127676362E-01],
	[3.5145000000E+04, 2.6274351128E+01, 4.8815999792E+00, 1.0659958685E+01, 2.9698283724E+00, 9.5129949444E-01],
	[3.5150000000E+04, 2.6280740850E+01, 4.8816180931E+00, 1.0664906851E+01, 2.9703006467E+00, 9.5132221373E-01],
	[3.5155000000E+04, 2.6287131217E+01, 4.8816362045E+00, 1.0669856608E+01, 2.9707728059E+00, 9.5134492148E-01],
	[3.5160000000E+04, 2.6293522228E+01, 4.8816543135E+00, 1.0674807958E+01, 2.9712448500E+00, 9.5136761771E-01],
	[3.5165000000E+04, 2.6299913885E+01, 4.8816724199E+00, 1.0679760900E+01, 2.9717167790E+00, 9.5139030241E-01],
	[3.5170000000E+04, 2.6306306186E+01, 4.8816905238E+00, 1.0684715434E+01, 2.9721885929E+00, 9.5141297559E-01],
	[3.5175000000E+04, 2.6312699131E+01, 4.8817086252E+00, 1.0689671562E+01, 2.9726602919E+00, 9.5143563727E-01],
	[3.5180000000E+04, 2.6319092722E+01, 4.8817267241E+00, 1.0694629283E+01, 2.9731318757E+00, 9.5145828744E-01],
	[3.5185000000E+04, 2.6325486956E+01, 4.8817448204E+00, 1.0699588597E+01, 2.9736033446E+00, 9.5148092611E-01],
	[3.5190000000E+04, 2.6331881836E+01, 4.8817629143E+00, 1.0704549505E+01, 2.9740746984E+00, 9.5150355330E-01],
	[3.5195000000E+04, 2.6338277360E+01, 4.8817810057E+00, 1.0709512008E+01, 2.9745459372E+00, 9.5152616899E-01],
	[3.5200000000E+04, 2.6344673528E+01, 4.8817990946E+00, 1.0714476105E+01, 2.9750170610E+00, 9.5154877321E-01],
	[3.5205000000E+04, 2.6351070341E+01, 4.8818171809E+00, 1.0719441796E+01, 2.9754880698E+00, 9.5157136595E-01],
	[3.5210000000E+04, 2.6357467798E+01, 4.8818352648E+00, 1.0724409083E+01, 2.9759589636E+00, 9.5159394722E-01],
	[3.5215000000E+04, 2.6363865900E+01, 4.8818533462E+00, 1.0729377964E+01, 2.9764297425E+00, 9.5161651703E-01],
	[3.5220000000E+04, 2.6370264646E+01, 4.8818714251E+00, 1.0734348442E+01, 2.9769004064E+00, 9.5163907538E-01],
	[3.5225000000E+04, 2.6376664037E+01, 4.8818895014E+00, 1.0739320515E+01, 2.9773709553E+00, 9.5166162229E-01],
	[3.5230000000E+04, 2.6383064071E+01, 4.8819075753E+00, 1.0744294184E+01, 2.9778413893E+00, 9.5168415775E-01],
	[3.5235000000E+04, 2.6389464751E+01, 4.8819256467E+00, 1.0749269450E+01, 2.9783117084E+00, 9.5170668177E-01],
	[3.5240000000E+04, 2.6395866074E+01, 4.8819437155E+00, 1.0754246312E+01, 2.9787819125E+00, 9.5172919436E-01],
	[3.5245000000E+04, 2.6402268042E+01, 4.8819617819E+00, 1.0759224771E+01, 2.9792520018E+00, 9.5175169553E-01],
	[3.5250000000E+04, 2.6408670654E+01, 4.8819798458E+00, 1.0764204828E+01, 2.9797219761E+00, 9.5177418527E-01],
	[3.5255000000E+04, 2.6415073910E+01, 4.8819979072E+00, 1.0769186482E+01, 2.9801918356E+00, 9.5179666360E-01],
	[3.5260000000E+04, 2.6421477810E+01, 4.8820159661E+00, 1.0774169734E+01, 2.9806615801E+00, 9.5181913052E-01],
	[3.5265000000E+04, 2.6427882355E+01, 4.8820340225E+00, 1.0779154584E+01, 2.9811312098E+00, 9.5184158604E-01],
	[3.5270000000E+04, 2.6434287543E+01, 4.8820520764E+00, 1.0784141033E+01, 2.9816007247E+00, 9.5186403017E-01],
	[3.5275000000E+04, 2.6440693376E+01, 4.8820701278E+00, 1.0789129080E+01, 2.9820701247E+00, 9.5188646290E-01],
	[3.5280000000E+04, 2.6447099853E+01, 4.8820881767E+00, 1.0794118726E+01, 2.9825394098E+00, 9.5190888425E-01],
	[3.5285000000E+04, 2.6453506974E+01, 4.8821062232E+00, 1.0799109972E+01, 2.9830085801E+00, 9.5193129422E-01],
	[3.5290000000E+04, 2.6459914739E+01, 4.8821242671E+00, 1.0804102817E+01, 2.9834776357E+00, 9.5195369282E-01],
	[3.5295000000E+04, 2.6466323148E+01, 4.8821423086E+00, 1.0809097262E+01, 2.9839465764E+00, 9.5197608005E-01],
	[3.5300000000E+04, 2.6472732201E+01, 4.8821603475E+00, 1.0814093307E+01, 2.9844154023E+00, 9.5199845593E-01],
	[3.5305000000E+04, 2.6479141897E+01, 4.8821783840E+00, 1.0819090952E+01, 2.9848841134E+00, 9.5202082045E-01],
	[3.5310000000E+04, 2.6485552238E+01, 4.8821964180E+00, 1.0824090198E+01, 2.9853527097E+00, 9.5204317362E-01],
	[3.5315000000E+04, 2.6491963223E+01, 4.8822144495E+00, 1.0829091045E+01, 2.9858211913E+00, 9.5206551544E-01],
	[3.5320000000E+04, 2.6498374851E+01, 4.8822324785E+00, 1.0834093494E+01, 2.9862895581E+00, 9.5208784594E-01],
	[3.5325000000E+04, 2.6504787124E+01, 4.8822505050E+00, 1.0839097544E+01, 2.9867578102E+00, 9.5211016510E-01],
	[3.5330000000E+04, 2.6511200040E+01, 4.8822685291E+00, 1.0844103195E+01, 2.9872259475E+00, 9.5213247294E-01],
	[3.5335000000E+04, 2.6517613600E+01, 4.8822865506E+00, 1.0849110449E+01, 2.9876939701E+00, 9.5215476946E-01],
	[3.5340000000E+04, 2.6524027803E+01, 4.8823045697E+00, 1.0854119305E+01, 2.9881618780E+00, 9.5217705466E-01],
	[3.5345000000E+04, 2.6530442651E+01, 4.8823225863E+00, 1.0859129764E+01, 2.9886296712E+00, 9.5219932856E-01],
	[3.5350000000E+04, 2.6536858142E+01, 4.8823406004E+00, 1.0864141826E+01, 2.9890973497E+00, 9.5222159116E-01],
	[3.5355000000E+04, 2.6543274277E+01, 4.8823586120E+00, 1.0869155491E+01, 2.9895649136E+00, 9.5224384247E-01],
	[3.5360000000E+04, 2.6549691055E+01, 4.8823766212E+00, 1.0874170760E+01, 2.9900323627E+00, 9.5226608249E-01],
	[3.5365000000E+04, 2.6556108477E+01, 4.8823946278E+00, 1.0879187633E+01, 2.9904996972E+00, 9.5228831122E-01],
	[3.5370000000E+04, 2.6562526543E+01, 4.8824126320E+00, 1.0884206109E+01, 2.9909669171E+00, 9.5231052868E-01],
	[3.5375000000E+04, 2.6568945252E+01, 4.8824306337E+00, 1.0889226190E+01, 2.9914340223E+00, 9.5233273487E-01],
	[3.5380000000E+04, 2.6575364605E+01, 4.8824486330E+00, 1.0894247876E+01, 2.9919010129E+00, 9.5235492979E-01],
	[3.5385000000E+04, 2.6581784602E+01, 4.8824666297E+00, 1.0899271167E+01, 2.9923678888E+00, 9.5237711346E-01],
	[3.5390000000E+04, 2.6588205241E+01, 4.8824846240E+00, 1.0904296063E+01, 2.9928346502E+00, 9.5239928587E-01],
	[3.5395000000E+04, 2.6594626525E+01, 4.8825026158E+00, 1.0909322565E+01, 2.9933012970E+00, 9.5242144704E-01],
	[3.5400000000E+04, 2.6601048451E+01, 4.8825206051E+00, 1.0914350672E+01, 2.9937678292E+00, 9.5244359696E-01],
	[3.5405000000E+04, 2.6607471022E+01, 4.8825385920E+00, 1.0919380386E+01, 2.9942342468E+00, 9.5246573565E-01],
	[3.5410000000E+04, 2.6613894235E+01, 4.8825565764E+00, 1.0924411706E+01, 2.9947005498E+00, 9.5248786311E-01],
	[3.5415000000E+04, 2.6620318092E+01, 4.8825745583E+00, 1.0929444632E+01, 2.9951667383E+00, 9.5250997935E-01],
	[3.5420000000E+04, 2.6626742592E+01, 4.8825925377E+00, 1.0934479166E+01, 2.9956328123E+00, 9.5253208437E-01],
	[3.5425000000E+04, 2.6633167736E+01, 4.8826105147E+00, 1.0939515307E+01, 2.9960987717E+00, 9.5255417818E-01],
	[3.5430000000E+04, 2.6639593523E+01, 4.8826284892E+00, 1.0944553055E+01, 2.9965646166E+00, 9.5257626079E-01],
	[3.5435000000E+04, 2.6646019953E+01, 4.8826464612E+00, 1.0949592411E+01, 2.9970303470E+00, 9.5259833220E-01],
	[3.5440000000E+04, 2.6652447026E+01, 4.8826644308E+00, 1.0954633376E+01, 2.9974959629E+00, 9.5262039241E-01],
	[3.5445000000E+04, 2.6658874743E+01, 4.8826823978E+00, 1.0959675948E+01, 2.9979614644E+00, 9.5264244144E-01],
	[3.5450000000E+04, 2.6665303102E+01, 4.8827003625E+00, 1.0964720130E+01, 2.9984268513E+00, 9.5266447928E-01],
	[3.5455000000E+04, 2.6671732105E+01, 4.8827183246E+00, 1.0969765920E+01, 2.9988921238E+00, 9.5268650595E-01],
	[3.5460000000E+04, 2.6678161751E+01, 4.8827362843E+00, 1.0974813320E+01, 2.9993572819E+00, 9.5270852145E-01],
	[3.5465000000E+04, 2.6684592040E+01, 4.8827542415E+00, 1.0979862329E+01, 2.9998223254E+00, 9.5273052579E-01],
	[3.5470000000E+04, 2.6691022973E+01, 4.8827721962E+00, 1.0984912949E+01, 3.0002872546E+00, 9.5275251897E-01],
	[3.5475000000E+04, 2.6697454548E+01, 4.8827901485E+00, 1.0989965178E+01, 3.0007520694E+00, 9.5277450100E-01],
	[3.5480000000E+04, 2.6703886766E+01, 4.8828080983E+00, 1.0995019017E+01, 3.0012167697E+00, 9.5279647189E-01],
	[3.5485000000E+04, 2.6710319627E+01, 4.8828260457E+00, 1.1000074468E+01, 3.0016813557E+00, 9.5281843163E-01],
	[3.5490000000E+04, 2.6716753131E+01, 4.8828439906E+00, 1.1005131529E+01, 3.0021458272E+00, 9.5284038024E-01],
	[3.5495000000E+04, 2.6723187279E+01, 4.8828619330E+00, 1.1010190202E+01, 3.0026101844E+00, 9.5286231772E-01],
	[3.5500000000E+04, 2.6729622069E+01, 4.8828798730E+00, 1.1015250486E+01, 3.0030744273E+00, 9.5288424408E-01],
	[3.5505000000E+04, 2.6736057502E+01, 4.8828978105E+00, 1.1020312382E+01, 3.0035385557E+00, 9.5290615933E-01],
	[3.5510000000E+04, 2.6742493577E+01, 4.8829157456E+00, 1.1025375890E+01, 3.0040025699E+00, 9.5292806347E-01],
	[3.5515000000E+04, 2.6748930296E+01, 4.8829336782E+00, 1.1030441010E+01, 3.0044664697E+00, 9.5294995650E-01],
	[3.5520000000E+04, 2.6755367657E+01, 4.8829516083E+00, 1.1035507744E+01, 3.0049302552E+00, 9.5297183843E-01],
	[3.5525000000E+04, 2.6761805662E+01, 4.8829695360E+00, 1.1040576090E+01, 3.0053939264E+00, 9.5299370927E-01],
	[3.5530000000E+04, 2.6768244309E+01, 4.8829874612E+00, 1.1045646049E+01, 3.0058574833E+00, 9.5301556903E-01],
	[3.5535000000E+04, 2.6774683598E+01, 4.8830053839E+00, 1.1050717622E+01, 3.0063209259E+00, 9.5303741770E-01],
	[3.5540000000E+04, 2.6781123531E+01, 4.8830233042E+00, 1.1055790809E+01, 3.0067842543E+00, 9.5305925530E-01],
	[3.5545000000E+04, 2.6787564106E+01, 4.8830412221E+00, 1.1060865610E+01, 3.0072474684E+00, 9.5308108184E-01],
	[3.5550000000E+04, 2.6794005324E+01, 4.8830591375E+00, 1.1065942026E+01, 3.0077105682E+00, 9.5310289731E-01],
	[3.5555000000E+04, 2.6800447184E+01, 4.8830770504E+00, 1.1071020056E+01, 3.0081735538E+00, 9.5312470172E-01],
	[3.5560000000E+04, 2.6806889687E+01, 4.8830949609E+00, 1.1076099701E+01, 3.0086364252E+00, 9.5314649508E-01],
	[3.5565000000E+04, 2.6813332833E+01, 4.8831128689E+00, 1.1081180961E+01, 3.0090991824E+00, 9.5316827740E-01],
	[3.5570000000E+04, 2.6819776621E+01, 4.8831307745E+00, 1.1086263837E+01, 3.0095618253E+00, 9.5319004868E-01],
	[3.5575000000E+04, 2.6826221051E+01, 4.8831486777E+00, 1.1091348329E+01, 3.0100243541E+00, 9.5321180893E-01],
	[3.5580000000E+04, 2.6832666124E+01, 4.8831665783E+00, 1.1096434437E+01, 3.0104867687E+00, 9.5323355815E-01],
	[3.5585000000E+04, 2.6839111840E+01, 4.8831844766E+00, 1.1101522161E+01, 3.0109490692E+00, 9.5325529635E-01],
	[3.5590000000E+04, 2.6845558198E+01, 4.8832023724E+00, 1.1106611502E+01, 3.0114112555E+00, 9.5327702353E-01],
	[3.5595000000E+04, 2.6852005198E+01, 4.8832202657E+00, 1.1111702460E+01, 3.0118733276E+00, 9.5329873971E-01],
	[3.5600000000E+04, 2.6858452841E+01, 4.8832381566E+00, 1.1116795035E+01, 3.0123352856E+00, 9.5332044488E-01],
	[3.5605000000E+04, 2.6864901126E+01, 4.8832560450E+00, 1.1121889228E+01, 3.0127971295E+00, 9.5334213905E-01],
	[3.5610000000E+04, 2.6871350054E+01, 4.8832739310E+00, 1.1126985039E+01, 3.0132588593E+00, 9.5336382223E-01],
	[3.5615000000E+04, 2.6877799624E+01, 4.8832918146E+00, 1.1132082467E+01, 3.0137204750E+00, 9.5338549443E-01],
	[3.5620000000E+04, 2.6884249836E+01, 4.8833096957E+00, 1.1137181515E+01, 3.0141819766E+00, 9.5340715565E-01],
	[3.5625000000E+04, 2.6890700690E+01, 4.8833275743E+00, 1.1142282181E+01, 3.0146433641E+00, 9.5342880589E-01],
	[3.5630000000E+04, 2.6897152187E+01, 4.8833454505E+00, 1.1147384465E+01, 3.0151046376E+00, 9.5345044517E-01],
	[3.5635000000E+04, 2.6903604326E+01, 4.8833633243E+00, 1.1152488370E+01, 3.0155657970E+00, 9.5347207349E-01],
	[3.5640000000E+04, 2.6910057107E+01, 4.8833811956E+00, 1.1157593893E+01, 3.0160268424E+00, 9.5349369088E-01],
	[3.5645000000E+04, 2.6916510530E+01, 4.8833990645E+00, 1.1162701037E+01, 3.0164877738E+00, 9.5351529735E-01],
	[3.5650000000E+04, 2.6922964595E+01, 4.8834169310E+00, 1.1167809801E+01, 3.0169485911E+00, 9.5353689290E-01],
	[3.5655000000E+04, 2.6929431928E+01, 4.8834364720E+00, 1.1172920185E+01, 3.0174100933E+00, 9.5355847754E-01],
	[3.5660000000E+04, 2.6935905235E+01, 4.8834567179E+00, 1.1178032190E+01, 3.0178718187E+00, 9.5358005126E-01],
	[3.5665000000E+04, 2.6942379190E+01, 4.8834769609E+00, 1.1183145816E+01, 3.0183334307E+00, 9.5360161409E-01],
	[3.5670000000E+04, 2.6948853793E+01, 4.8834972012E+00, 1.1188261063E+01, 3.0187949290E+00, 9.5362316602E-01],
	[3.5675000000E+04, 2.6955329044E+01, 4.8835174388E+00, 1.1193377931E+01, 3.0192563139E+00, 9.5364470706E-01],
	[3.5680000000E+04, 2.6961804943E+01, 4.8835376736E+00, 1.1198496422E+01, 3.0197175852E+00, 9.5366623720E-01],
	[3.5685000000E+04, 2.6968281490E+01, 4.8835579056E+00, 1.1203616535E+01, 3.0201787430E+00, 9.5368775647E-01],
	[3.5690000000E+04, 2.6974758685E+01, 4.8835781349E+00, 1.1208738270E+01, 3.0206397873E+00, 9.5370926486E-01],
	[3.5695000000E+04, 2.6981236528E+01, 4.8835983615E+00, 1.1213861628E+01, 3.0211007181E+00, 9.5373076238E-01],
	[3.5700000000E+04, 2.6987715019E+01, 4.8836185852E+00, 1.1218986608E+01, 3.0215615355E+00, 9.5375224903E-01],
	[3.5705000000E+04, 2.6994194159E+01, 4.8836388063E+00, 1.1224113213E+01, 3.0220222394E+00, 9.5377372482E-01],
	[3.5710000000E+04, 2.7000673945E+01, 4.8836590246E+00, 1.1229241440E+01, 3.0224828298E+00, 9.5379518975E-01],
	[3.5715000000E+04, 2.7007154380E+01, 4.8836792401E+00, 1.1234371292E+01, 3.0229433068E+00, 9.5381664383E-01],
	[3.5720000000E+04, 2.7013635463E+01, 4.8836994530E+00, 1.1239502768E+01, 3.0234036704E+00, 9.5383808707E-01],
	[3.5725000000E+04, 2.7020117194E+01, 4.8837196630E+00, 1.1244635868E+01, 3.0238639206E+00, 9.5385951946E-01],
	[3.5730000000E+04, 2.7026599572E+01, 4.8837398703E+00, 1.1249770593E+01, 3.0243240573E+00, 9.5388094102E-01],
	[3.5735000000E+04, 2.7033082598E+01, 4.8837600749E+00, 1.1254906942E+01, 3.0247840807E+00, 9.5390235174E-01],
	[3.5740000000E+04, 2.7039566272E+01, 4.8837802767E+00, 1.1260044918E+01, 3.0252439907E+00, 9.5392375164E-01],
	[3.5745000000E+04, 2.7046050594E+01, 4.8838004758E+00, 1.1265184518E+01, 3.0257037873E+00, 9.5394514072E-01],
	[3.5750000000E+04, 2.7052535563E+01, 4.8838206722E+00, 1.1270325745E+01, 3.0261634706E+00, 9.5396651899E-01],
	[3.5755000000E+04, 2.7059021180E+01, 4.8838408658E+00, 1.1275468598E+01, 3.0266230405E+00, 9.5398788644E-01],
	[3.5760000000E+04, 2.7065507445E+01, 4.8838610566E+00, 1.1280613077E+01, 3.0270824971E+00, 9.5400924309E-01],
	[3.5765000000E+04, 2.7071994357E+01, 4.8838812448E+00, 1.1285759183E+01, 3.0275418404E+00, 9.5403058894E-01],
	[3.5770000000E+04, 2.7078481917E+01, 4.8839014301E+00, 1.1290906916E+01, 3.0280010704E+00, 9.5405192399E-01],
	[3.5775000000E+04, 2.7084970125E+01, 4.8839216128E+00, 1.1296056276E+01, 3.0284601870E+00, 9.5407324826E-01],
	[3.5780000000E+04, 2.7091458980E+01, 4.8839417927E+00, 1.1301207264E+01, 3.0289191904E+00, 9.5409456174E-01],
	[3.5785000000E+04, 2.7097948482E+01, 4.8839619699E+00, 1.1306359879E+01, 3.0293780806E+00, 9.5411586444E-01],
	[3.5790000000E+04, 2.7104438632E+01, 4.8839821443E+00, 1.1311514123E+01, 3.0298368575E+00, 9.5413715636E-01],
	[3.5795000000E+04, 2.7110929430E+01, 4.8840023160E+00, 1.1316669995E+01, 3.0302955211E+00, 9.5415843752E-01],
	[3.5800000000E+04, 2.7117420875E+01, 4.8840224850E+00, 1.1321827496E+01, 3.0307540715E+00, 9.5417970791E-01],
	[3.5805000000E+04, 2.7123912967E+01, 4.8840426512E+00, 1.1326986626E+01, 3.0312125087E+00, 9.5420096754E-01],
	[3.5810000000E+04, 2.7130405707E+01, 4.8840628147E+00, 1.1332147386E+01, 3.0316708327E+00, 9.5422221642E-01],
	[3.5815000000E+04, 2.7136899094E+01, 4.8840829755E+00, 1.1337309774E+01, 3.0321290435E+00, 9.5424345455E-01],
	[3.5820000000E+04, 2.7143393129E+01, 4.8841031335E+00, 1.1342473793E+01, 3.0325871411E+00, 9.5426468194E-01],
	[3.5825000000E+04, 2.7149887811E+01, 4.8841232888E+00, 1.1347639442E+01, 3.0330451255E+00, 9.5428589859E-01],
	[3.5830000000E+04, 2.7156383140E+01, 4.8841434414E+00, 1.1352806722E+01, 3.0335029968E+00, 9.5430710451E-01],
	[3.5835000000E+04, 2.7162879117E+01, 4.8841635913E+00, 1.1357975632E+01, 3.0339607549E+00, 9.5432829969E-01],
	[3.5840000000E+04, 2.7169375740E+01, 4.8841837384E+00, 1.1363146173E+01, 3.0344183999E+00, 9.5434948416E-01],
	[3.5845000000E+04, 2.7175873011E+01, 4.8842038828E+00, 1.1368318345E+01, 3.0348759318E+00, 9.5437065791E-01],
	[3.5850000000E+04, 2.7182370929E+01, 4.8842240245E+00, 1.1373492149E+01, 3.0353333505E+00, 9.5439182094E-01],
	[3.5855000000E+04, 2.7188869494E+01, 4.8842441634E+00, 1.1378667585E+01, 3.0357906562E+00, 9.5441297327E-01],
	[3.5860000000E+04, 2.7195368707E+01, 4.8842642996E+00, 1.1383844653E+01, 3.0362478488E+00, 9.5443411489E-01],
	[3.5865000000E+04, 2.7201868566E+01, 4.8842844331E+00, 1.1389023354E+01, 3.0367049283E+00, 9.5445524582E-01],
	[3.5870000000E+04, 2.7208369073E+01, 4.8843045639E+00, 1.1394203687E+01, 3.0371618948E+00, 9.5447636606E-01],
	[3.5875000000E+04, 2.7214870227E+01, 4.8843246919E+00, 1.1399385653E+01, 3.0376187482E+00, 9.5449747560E-01],
	[3.5880000000E+04, 2.7221372027E+01, 4.8843448173E+00, 1.1404569253E+01, 3.0380754886E+00, 9.5451857447E-01],
	[3.5885000000E+04, 2.7227874475E+01, 4.8843649399E+00, 1.1409754486E+01, 3.0385321160E+00, 9.5453966266E-01],
	[3.5890000000E+04, 2.7234377570E+01, 4.8843850597E+00, 1.1414941353E+01, 3.0389886303E+00, 9.5456074018E-01],
	[3.5895000000E+04, 2.7240881311E+01, 4.8844051769E+00, 1.1420129855E+01, 3.0394450317E+00, 9.5458180703E-01],
	[3.5900000000E+04, 2.7247385700E+01, 4.8844252914E+00, 1.1425319990E+01, 3.0399013201E+00, 9.5460286323E-01],
	[3.5905000000E+04, 2.7253890736E+01, 4.8844454031E+00, 1.1430511761E+01, 3.0403574955E+00, 9.5462390876E-01],
	[3.5910000000E+04, 2.7260396418E+01, 4.8844655121E+00, 1.1435705166E+01, 3.0408135580E+00, 9.5464494365E-01],
	[3.5915000000E+04, 2.7266902747E+01, 4.8844856184E+00, 1.1440900207E+01, 3.0412695075E+00, 9.5466596789E-01],
	[3.5920000000E+04, 2.7273409723E+01, 4.8845057219E+00, 1.1446096884E+01, 3.0417253441E+00, 9.5468698148E-01],
	[3.5925000000E+04, 2.7279917346E+01, 4.8845258228E+00, 1.1451295196E+01, 3.0421810678E+00, 9.5470798445E-01],
	[3.5930000000E+04, 2.7286425616E+01, 4.8845459209E+00, 1.1456495145E+01, 3.0426366785E+00, 9.5472897678E-01],
	[3.5935000000E+04, 2.7292934532E+01, 4.8845660164E+00, 1.1461696730E+01, 3.0430921764E+00, 9.5474995849E-01],
	[3.5940000000E+04, 2.7299444095E+01, 4.8845861091E+00, 1.1466899952E+01, 3.0435475614E+00, 9.5477092958E-01],
	[3.5945000000E+04, 2.7305954305E+01, 4.8846061991E+00, 1.1472104810E+01, 3.0440028335E+00, 9.5479189005E-01],
	[3.5950000000E+04, 2.7312465162E+01, 4.8846262864E+00, 1.1477311307E+01, 3.0444579928E+00, 9.5481283992E-01],
	[3.5955000000E+04, 2.7318976665E+01, 4.8846463710E+00, 1.1482519440E+01, 3.0449130393E+00, 9.5483377917E-01],
	[3.5960000000E+04, 2.7325488815E+01, 4.8846664528E+00, 1.1487729212E+01, 3.0453679729E+00, 9.5485470784E-01],
	[3.5965000000E+04, 2.7332001611E+01, 4.8846865320E+00, 1.1492940622E+01, 3.0458227937E+00, 9.5487562590E-01],
	[3.5970000000E+04, 2.7338515054E+01, 4.8847066085E+00, 1.1498153670E+01, 3.0462775017E+00, 9.5489653338E-01],
	[3.5975000000E+04, 2.7345029143E+01, 4.8847266822E+00, 1.1503368357E+01, 3.0467320969E+00, 9.5491743027E-01],
	[3.5980000000E+04, 2.7351543879E+01, 4.8847467532E+00, 1.1508584683E+01, 3.0471865793E+00, 9.5493831659E-01],
	[3.5985000000E+04, 2.7358059262E+01, 4.8847668216E+00, 1.1513802649E+01, 3.0476409490E+00, 9.5495919233E-01],
	[3.5990000000E+04, 2.7364575291E+01, 4.8847868872E+00, 1.1519022254E+01, 3.0480952059E+00, 9.5498005750E-01],
	[3.5995000000E+04, 2.7371091966E+01, 4.8848069501E+00, 1.1524243499E+01, 3.0485493501E+00, 9.5500091211E-01],
	[3.6000000000E+04, 2.7377609288E+01, 4.8848270103E+00, 1.1529466384E+01, 3.0490033815E+00, 9.5502175616E-01],
	[3.6005000000E+04, 2.7384127257E+01, 4.8848470678E+00, 1.1534690910E+01, 3.0494573003E+00, 9.5504258966E-01],
	[3.6010000000E+04, 2.7390645871E+01, 4.8848671227E+00, 1.1539917077E+01, 3.0499111063E+00, 9.5506341262E-01],
	[3.6015000000E+04, 2.7397165132E+01, 4.8848871748E+00, 1.1545144884E+01, 3.0503647997E+00, 9.5508422502E-01],
	[3.6020000000E+04, 2.7403685039E+01, 4.8849072242E+00, 1.1550374333E+01, 3.0508183804E+00, 9.5510502690E-01],
	[3.6025000000E+04, 2.7410205593E+01, 4.8849272709E+00, 1.1555605424E+01, 3.0512718484E+00, 9.5512581824E-01],
	[3.6030000000E+04, 2.7416726793E+01, 4.8849473149E+00, 1.1560838156E+01, 3.0517252038E+00, 9.5514659905E-01],
	[3.6035000000E+04, 2.7423248639E+01, 4.8849673562E+00, 1.1566072531E+01, 3.0521784466E+00, 9.5516736934E-01],
	[3.6040000000E+04, 2.7429771131E+01, 4.8849873948E+00, 1.1571308548E+01, 3.0526315767E+00, 9.5518812911E-01],
	[3.6045000000E+04, 2.7436294270E+01, 4.8850074307E+00, 1.1576546208E+01, 3.0530845943E+00, 9.5520887837E-01],
	[3.6050000000E+04, 2.7442818054E+01, 4.8850274639E+00, 1.1581785511E+01, 3.0535374992E+00, 9.5522961713E-01],
	[3.6055000000E+04, 2.7449342485E+01, 4.8850474944E+00, 1.1587026457E+01, 3.0539902916E+00, 9.5525034538E-01],
	[3.6060000000E+04, 2.7455867562E+01, 4.8850675223E+00, 1.1592269048E+01, 3.0544429714E+00, 9.5527106314E-01],
	[3.6065000000E+04, 2.7462393285E+01, 4.8850875474E+00, 1.1597513282E+01, 3.0548955386E+00, 9.5529177041E-01],
	[3.6070000000E+04, 2.7468919654E+01, 4.8851075698E+00, 1.1602759160E+01, 3.0553479933E+00, 9.5531246719E-01],
	[3.6075000000E+04, 2.7475446669E+01, 4.8851275896E+00, 1.1608006682E+01, 3.0558003355E+00, 9.5533315349E-01],
	[3.6080000000E+04, 2.7481974330E+01, 4.8851476066E+00, 1.1613255850E+01, 3.0562525652E+00, 9.5535382932E-01],
	[3.6085000000E+04, 2.7488502637E+01, 4.8851676210E+00, 1.1618506662E+01, 3.0567046824E+00, 9.5537449467E-01],
	[3.6090000000E+04, 2.7495031590E+01, 4.8851876326E+00, 1.1623759120E+01, 3.0571566871E+00, 9.5539514956E-01],
	[3.6095000000E+04, 2.7501561189E+01, 4.8852076416E+00, 1.1629013224E+01, 3.0576085793E+00, 9.5541579399E-01],
	[3.6100000000E+04, 2.7508091434E+01, 4.8852276479E+00, 1.1634268974E+01, 3.0580603591E+00, 9.5543642797E-01],
	[3.6105000000E+04, 2.7514622325E+01, 4.8852476515E+00, 1.1639526369E+01, 3.0585120264E+00, 9.5545705149E-01],
	[3.6110000000E+04, 2.7521153861E+01, 4.8852676524E+00, 1.1644785412E+01, 3.0589635813E+00, 9.5547766457E-01],
	[3.6115000000E+04, 2.7527686044E+01, 4.8852876506E+00, 1.1650046101E+01, 3.0594150237E+00, 9.5549826722E-01],
	[3.6120000000E+04, 2.7534218872E+01, 4.8853076461E+00, 1.1655308437E+01, 3.0598663538E+00, 9.5551885942E-01],
	[3.6125000000E+04, 2.7540752346E+01, 4.8853276390E+00, 1.1660572420E+01, 3.0603175715E+00, 9.5553944120E-01],
	[3.6130000000E+04, 2.7547286466E+01, 4.8853476291E+00, 1.1665838052E+01, 3.0607686768E+00, 9.5556001256E-01],
	[3.6135000000E+04, 2.7553821231E+01, 4.8853676166E+00, 1.1671105331E+01, 3.0612196697E+00, 9.5558057349E-01],
	[3.6140000000E+04, 2.7560356642E+01, 4.8853876014E+00, 1.1676374258E+01, 3.0616705503E+00, 9.5560112401E-01],
	[3.6145000000E+04, 2.7566892699E+01, 4.8854075835E+00, 1.1681644834E+01, 3.0621213186E+00, 9.5562166413E-01],
	[3.6150000000E+04, 2.7573429402E+01, 4.8854275630E+00, 1.1686917059E+01, 3.0625719745E+00, 9.5564219384E-01],
	[3.6155000000E+04, 2.7579966750E+01, 4.8854475397E+00, 1.1692190933E+01, 3.0630225181E+00, 9.5566271315E-01],
	[3.6160000000E+04, 2.7586504744E+01, 4.8854675138E+00, 1.1697466456E+01, 3.0634729494E+00, 9.5568322207E-01],
	[3.6165000000E+04, 2.7593043383E+01, 4.8854874852E+00, 1.1702743629E+01, 3.0639232685E+00, 9.5570372060E-01],
	[3.6170000000E+04, 2.7599582668E+01, 4.8855074539E+00, 1.1708022452E+01, 3.0643734752E+00, 9.5572420875E-01],
	[3.6175000000E+04, 2.7606122598E+01, 4.8855274199E+00, 1.1713302925E+01, 3.0648235698E+00, 9.5574468652E-01],
	[3.6180000000E+04, 2.7612663174E+01, 4.8855473832E+00, 1.1718585049E+01, 3.0652735520E+00, 9.5576515392E-01],
	[3.6185000000E+04, 2.7619204395E+01, 4.8855673439E+00, 1.1723868823E+01, 3.0657234221E+00, 9.5578561095E-01],
	[3.6190000000E+04, 2.7625746262E+01, 4.8855873019E+00, 1.1729154249E+01, 3.0661731799E+00, 9.5580605762E-01],
	[3.6195000000E+04, 2.7632288774E+01, 4.8856072572E+00, 1.1734441326E+01, 3.0666228256E+00, 9.5582649393E-01],
	[3.6200000000E+04, 2.7638831932E+01, 4.8856272099E+00, 1.1739730055E+01, 3.0670723590E+00, 9.5584691990E-01],
	[3.6205000000E+04, 2.7645375735E+01, 4.8856471599E+00, 1.1745020435E+01, 3.0675217803E+00, 9.5586733551E-01],
	[3.6210000000E+04, 2.7651920183E+01, 4.8856671071E+00, 1.1750312468E+01, 3.0679710894E+00, 9.5588774078E-01],
	[3.6215000000E+04, 2.7658465277E+01, 4.8856870518E+00, 1.1755606154E+01, 3.0684202864E+00, 9.5590813572E-01],
	[3.6220000000E+04, 2.7665011016E+01, 4.8857069937E+00, 1.1760901492E+01, 3.0688693712E+00, 9.5592852033E-01],
	[3.6225000000E+04, 2.7671557400E+01, 4.8857269330E+00, 1.1766198484E+01, 3.0693183440E+00, 9.5594889461E-01],
	[3.6230000000E+04, 2.7678120693E+01, 4.8857490048E+00, 1.1771497129E+01, 3.0697682476E+00, 9.5596925857E-01],
	[3.6235000000E+04, 2.7684686143E+01, 4.8857712714E+00, 1.1776797427E+01, 3.0702181361E+00, 9.5598961221E-01],
	[3.6240000000E+04, 2.7691252245E+01, 4.8857935350E+00, 1.1782099380E+01, 3.0706679129E+00, 9.5600995554E-01],
	[3.6245000000E+04, 2.7697818997E+01, 4.8858157956E+00, 1.1787402987E+01, 3.0711175780E+00, 9.5603028857E-01],
	[3.6250000000E+04, 2.7704386401E+01, 4.8858380533E+00, 1.1792708248E+01, 3.0715671315E+00, 9.5605061130E-01],
	[3.6255000000E+04, 2.7710954455E+01, 4.8858603079E+00, 1.1798015164E+01, 3.0720165733E+00, 9.5607092373E-01],
	[3.6260000000E+04, 2.7717523161E+01, 4.8858825597E+00, 1.1803323736E+01, 3.0724659036E+00, 9.5609122588E-01],
	[3.6265000000E+04, 2.7724092518E+01, 4.8859048084E+00, 1.1808633962E+01, 3.0729151222E+00, 9.5611151773E-01],
	[3.6270000000E+04, 2.7730662525E+01, 4.8859270542E+00, 1.1813945845E+01, 3.0733642292E+00, 9.5613179931E-01],
	[3.6275000000E+04, 2.7737233184E+01, 4.8859492970E+00, 1.1819259384E+01, 3.0738132247E+00, 9.5615207062E-01],
	[3.6280000000E+04, 2.7743804494E+01, 4.8859715369E+00, 1.1824574578E+01, 3.0742621086E+00, 9.5617233165E-01],
	[3.6285000000E+04, 2.7750376454E+01, 4.8859937738E+00, 1.1829891430E+01, 3.0747108809E+00, 9.5619258242E-01],
	[3.6290000000E+04, 2.7756949066E+01, 4.8860160077E+00, 1.1835209938E+01, 3.0751595417E+00, 9.5621282294E-01],
	[3.6295000000E+04, 2.7763522328E+01, 4.8860382387E+00, 1.1840530103E+01, 3.0756080910E+00, 9.5623305320E-01],
	[3.6300000000E+04, 2.7770096241E+01, 4.8860604667E+00, 1.1845851926E+01, 3.0760565288E+00, 9.5625327321E-01],
	[3.6305000000E+04, 2.7776670805E+01, 4.8860826917E+00, 1.1851175407E+01, 3.0765048550E+00, 9.5627348297E-01],
	[3.6310000000E+04, 2.7783246020E+01, 4.8861049138E+00, 1.1856500546E+01, 3.0769530698E+00, 9.5629368250E-01],
	[3.6315000000E+04, 2.7789821886E+01, 4.8861271330E+00, 1.1861827342E+01, 3.0774011731E+00, 9.5631387180E-01],
	[3.6320000000E+04, 2.7796398402E+01, 4.8861493491E+00, 1.1867155798E+01, 3.0778491650E+00, 9.5633405086E-01],
	[3.6325000000E+04, 2.7802975569E+01, 4.8861715623E+00, 1.1872485912E+01, 3.0782970454E+00, 9.5635421971E-01],
	[3.6330000000E+04, 2.7809553387E+01, 4.8861937726E+00, 1.1877817686E+01, 3.0787448144E+00, 9.5637437833E-01],
	[3.6335000000E+04, 2.7816131856E+01, 4.8862159799E+00, 1.1883151119E+01, 3.0791924720E+00, 9.5639452675E-01],
	[3.6340000000E+04, 2.7822710975E+01, 4.8862381843E+00, 1.1888486212E+01, 3.0796400182E+00, 9.5641466496E-01],
	[3.6345000000E+04, 2.7829290745E+01, 4.8862603857E+00, 1.1893822964E+01, 3.0800874530E+00, 9.5643479296E-01],
	[3.6350000000E+04, 2.7835871165E+01, 4.8862825841E+00, 1.1899161377E+01, 3.0805347764E+00, 9.5645491077E-01],
	[3.6355000000E+04, 2.7842452236E+01, 4.8863047796E+00, 1.1904501451E+01, 3.0809819885E+00, 9.5647501838E-01],
	[3.6360000000E+04, 2.7849033957E+01, 4.8863269721E+00, 1.1909843186E+01, 3.0814290892E+00, 9.5649511581E-01],
	[3.6365000000E+04, 2.7855616329E+01, 4.8863491617E+00, 1.1915186581E+01, 3.0818760786E+00, 9.5651520306E-01],
	[3.6370000000E+04, 2.7862199352E+01, 4.8863713483E+00, 1.1920531638E+01, 3.0823229567E+00, 9.5653528013E-01],
	[3.6375000000E+04, 2.7868783025E+01, 4.8863935320E+00, 1.1925878357E+01, 3.0827697235E+00, 9.5655534703E-01],
	[3.6380000000E+04, 2.7875367348E+01, 4.8864157128E+00, 1.1931226738E+01, 3.0832163790E+00, 9.5657540376E-01],
	[3.6385000000E+04, 2.7881952322E+01, 4.8864378906E+00, 1.1936576782E+01, 3.0836629232E+00, 9.5659545033E-01],
	[3.6390000000E+04, 2.7888537947E+01, 4.8864600654E+00, 1.1941928488E+01, 3.0841093562E+00, 9.5661548675E-01],
	[3.6395000000E+04, 2.7895124221E+01, 4.8864822373E+00, 1.1947281857E+01, 3.0845556780E+00, 9.5663551302E-01],
	[3.6400000000E+04, 2.7901711146E+01, 4.8865044062E+00, 1.1952636889E+01, 3.0850018885E+00, 9.5665552913E-01],
	[3.6405000000E+04, 2.7908298722E+01, 4.8865265723E+00, 1.1957993584E+01, 3.0854479878E+00, 9.5667553511E-01],
	[3.6410000000E+04, 2.7914886947E+01, 4.8865487353E+00, 1.1963351943E+01, 3.0858939759E+00, 9.5669553096E-01],
	[3.6415000000E+04, 2.7921475823E+01, 4.8865708954E+00, 1.1968711967E+01, 3.0863398528E+00, 9.5671551667E-01],
	[3.6420000000E+04, 2.7928065349E+01, 4.8865930526E+00, 1.1974073654E+01, 3.0867856185E+00, 9.5673549226E-01],
	[3.6425000000E+04, 2.7934655526E+01, 4.8866152069E+00, 1.1979437007E+01, 3.0872312731E+00, 9.5675545773E-01],
	[3.6430000000E+04, 2.7941246353E+01, 4.8866373582E+00, 1.1984802024E+01, 3.0876768165E+00, 9.5677541308E-01],
	[3.6435000000E+04, 2.7947837829E+01, 4.8866595065E+00, 1.1990168706E+01, 3.0881222488E+00, 9.5679535833E-01],
	[3.6440000000E+04, 2.7954429956E+01, 4.8866816519E+00, 1.1995537054E+01, 3.0885675700E+00, 9.5681529347E-01],
	[3.6445000000E+04, 2.7961022733E+01, 4.8867037944E+00, 1.2000907068E+01, 3.0890127801E+00, 9.5683521851E-01],
	[3.6450000000E+04, 2.7967616160E+01, 4.8867259340E+00, 1.2006278748E+01, 3.0894578791E+00, 9.5685513345E-01],
	[3.6455000000E+04, 2.7974210238E+01, 4.8867480706E+00, 1.2011652094E+01, 3.0899028671E+00, 9.5687503831E-01],
	[3.6460000000E+04, 2.7980804965E+01, 4.8867702042E+00, 1.2017027107E+01, 3.0903477440E+00, 9.5689493309E-01],
	[3.6465000000E+04, 2.7987400342E+01, 4.8867923350E+00, 1.2022403787E+01, 3.0907925098E+00, 9.5691481778E-01],
	[3.6470000000E+04, 2.7993996370E+01, 4.8868144628E+00, 1.2027782134E+01, 3.0912371646E+00, 9.5693469240E-01],
	[3.6475000000E+04, 2.8000593047E+01, 4.8868365876E+00, 1.2033162148E+01, 3.0916817084E+00, 9.5695455695E-01],
	[3.6480000000E+04, 2.8007190374E+01, 4.8868587096E+00, 1.2038543830E+01, 3.0921261412E+00, 9.5697441144E-01],
	[3.6485000000E+04, 2.8013788351E+01, 4.8868808286E+00, 1.2043927181E+01, 3.0925704631E+00, 9.5699425587E-01],
	[3.6490000000E+04, 2.8020386978E+01, 4.8869029447E+00, 1.2049312199E+01, 3.0930146739E+00, 9.5701409025E-01],
	[3.6495000000E+04, 2.8026986255E+01, 4.8869250578E+00, 1.2054698887E+01, 3.0934587738E+00, 9.5703391458E-01],
	[3.6500000000E+04, 2.8033586182E+01, 4.8869471680E+00, 1.2060087243E+01, 3.0939027628E+00, 9.5705372887E-01],
	[3.6505000000E+04, 2.8040186759E+01, 4.8869692753E+00, 1.2065477269E+01, 3.0943466408E+00, 9.5707353312E-01],
	[3.6510000000E+04, 2.8046787985E+01, 4.8869913797E+00, 1.2070868964E+01, 3.0947904080E+00, 9.5709332734E-01],
	[3.6515000000E+04, 2.8053389861E+01, 4.8870134811E+00, 1.2076262329E+01, 3.0952340642E+00, 9.5711311153E-01],
	[3.6520000000E+04, 2.8059992387E+01, 4.8870355796E+00, 1.2081657364E+01, 3.0956776095E+00, 9.5713288569E-01],
	[3.6525000000E+04, 2.8066595563E+01, 4.8870576752E+00, 1.2087054069E+01, 3.0961210440E+00, 9.5715264984E-01],
	[3.6530000000E+04, 2.8073199388E+01, 4.8870797678E+00, 1.2092452445E+01, 3.0965643677E+00, 9.5717240398E-01],
	[3.6535000000E+04, 2.8079803863E+01, 4.8871018576E+00, 1.2097852493E+01, 3.0970075805E+00, 9.5719214811E-01],
	[3.6540000000E+04, 2.8086408988E+01, 4.8871239444E+00, 1.2103254211E+01, 3.0974506824E+00, 9.5721188224E-01],
	[3.6545000000E+04, 2.8093014762E+01, 4.8871460283E+00, 1.2108657601E+01, 3.0978936736E+00, 9.5723160638E-01],
	[3.6550000000E+04, 2.8099621186E+01, 4.8871681092E+00, 1.2114062662E+01, 3.0983365540E+00, 9.5725132052E-01],
	[3.6555000000E+04, 2.8106228260E+01, 4.8871901873E+00, 1.2119469396E+01, 3.0987793236E+00, 9.5727102468E-01],
	[3.6560000000E+04, 2.8112835983E+01, 4.8872122624E+00, 1.2124877802E+01, 3.0992219824E+00, 9.5729071885E-01],
	[3.6565000000E+04, 2.8119444355E+01, 4.8872343346E+00, 1.2130287881E+01, 3.0996645305E+00, 9.5731040305E-01],
	[3.6570000000E+04, 2.8126053377E+01, 4.8872564039E+00, 1.2135699633E+01, 3.1001069678E+00, 9.5733007727E-01],
	[3.6575000000E+04, 2.8132663049E+01, 4.8872784703E+00, 1.2141113058E+01, 3.1005492945E+00, 9.5734974154E-01],
	[3.6580000000E+04, 2.8139273370E+01, 4.8873005337E+00, 1.2146528157E+01, 3.1009915104E+00, 9.5736939584E-01],
	[3.6585000000E+04, 2.8145884340E+01, 4.8873225943E+00, 1.2151944930E+01, 3.1014336156E+00, 9.5738904018E-01],
	[3.6590000000E+04, 2.8152495960E+01, 4.8873446519E+00, 1.2157363377E+01, 3.1018756102E+00, 9.5740867458E-01],
	[3.6595000000E+04, 2.8159108229E+01, 4.8873667066E+00, 1.2162783498E+01, 3.1023174941E+00, 9.5742829903E-01],
	[3.6600000000E+04, 2.8165721148E+01, 4.8873887584E+00, 1.2168205294E+01, 3.1027592674E+00, 9.5744791354E-01],
	[3.6605000000E+04, 2.8172334716E+01, 4.8874108073E+00, 1.2173628764E+01, 3.1032009300E+00, 9.5746751811E-01],
	[3.6610000000E+04, 2.8178948933E+01, 4.8874328532E+00, 1.2179053911E+01, 3.1036424820E+00, 9.5748711275E-01],
	[3.6615000000E+04, 2.8185563799E+01, 4.8874548963E+00, 1.2184480732E+01, 3.1040839234E+00, 9.5750669747E-01],
	[3.6620000000E+04, 2.8192179315E+01, 4.8874769364E+00, 1.2189909230E+01, 3.1045252543E+00, 9.5752627227E-01],
	[3.6625000000E+04, 2.8198795480E+01, 4.8874989737E+00, 1.2195339404E+01, 3.1049664745E+00, 9.5754583716E-01],
	[3.6630000000E+04, 2.8205412294E+01, 4.8875210080E+00, 1.2200771254E+01, 3.1054075843E+00, 9.5756539213E-01],
	[3.6635000000E+04, 2.8212029757E+01, 4.8875430394E+00, 1.2206204781E+01, 3.1058485834E+00, 9.5758493720E-01],
	[3.6640000000E+04, 2.8218647870E+01, 4.8875650679E+00, 1.2211639985E+01, 3.1062894721E+00, 9.5760447238E-01],
	[3.6645000000E+04, 2.8225266631E+01, 4.8875870935E+00, 1.2217076866E+01, 3.1067302502E+00, 9.5762399765E-01],
	[3.6650000000E+04, 2.8231886042E+01, 4.8876091162E+00, 1.2222515425E+01, 3.1071709179E+00, 9.5764351304E-01],
	[3.6655000000E+04, 2.8238506102E+01, 4.8876311360E+00, 1.2227955662E+01, 3.1076114750E+00, 9.5766301855E-01],
	[3.6660000000E+04, 2.8245126810E+01, 4.8876531529E+00, 1.2233397577E+01, 3.1080519217E+00, 9.5768251418E-01],
	[3.6665000000E+04, 2.8251748168E+01, 4.8876751669E+00, 1.2238841170E+01, 3.1084922580E+00, 9.5770199993E-01],
	[3.6670000000E+04, 2.8258370175E+01, 4.8876971780E+00, 1.2244286442E+01, 3.1089324838E+00, 9.5772147581E-01],
	[3.6675000000E+04, 2.8264992831E+01, 4.8877191862E+00, 1.2249733393E+01, 3.1093725992E+00, 9.5774094183E-01],
	[3.6680000000E+04, 2.8271616136E+01, 4.8877411914E+00, 1.2255182024E+01, 3.1098126042E+00, 9.5776039800E-01],
	[3.6685000000E+04, 2.8278240089E+01, 4.8877631938E+00, 1.2260632334E+01, 3.1102524988E+00, 9.5777984431E-01],
	[3.6690000000E+04, 2.8284864692E+01, 4.8877851933E+00, 1.2266084324E+01, 3.1106922830E+00, 9.5779928077E-01],
	[3.6695000000E+04, 2.8291489943E+01, 4.8878071899E+00, 1.2271537994E+01, 3.1111319569E+00, 9.5781870738E-01],
	[3.6700000000E+04, 2.8298115844E+01, 4.8878291836E+00, 1.2276993345E+01, 3.1115715204E+00, 9.5783812417E-01],
	[3.6705000000E+04, 2.8304742393E+01, 4.8878511744E+00, 1.2282450376E+01, 3.1120109737E+00, 9.5785753111E-01],
	[3.6710000000E+04, 2.8311369591E+01, 4.8878731622E+00, 1.2287909089E+01, 3.1124503165E+00, 9.5787692823E-01],
	[3.6715000000E+04, 2.8317997437E+01, 4.8878951472E+00, 1.2293369483E+01, 3.1128895491E+00, 9.5789631553E-01],
	[3.6720000000E+04, 2.8324625933E+01, 4.8879171293E+00, 1.2298831558E+01, 3.1133286715E+00, 9.5791569301E-01],
	[3.6725000000E+04, 2.8331255077E+01, 4.8879391085E+00, 1.2304295315E+01, 3.1137676835E+00, 9.5793506068E-01],
	[3.6730000000E+04, 2.8337884870E+01, 4.8879610849E+00, 1.2309760755E+01, 3.1142065853E+00, 9.5795441854E-01],
	[3.6735000000E+04, 2.8344515311E+01, 4.8879830583E+00, 1.2315227877E+01, 3.1146453769E+00, 9.5797376660E-01],
	[3.6740000000E+04, 2.8351146402E+01, 4.8880050288E+00, 1.2320696682E+01, 3.1150840582E+00, 9.5799310486E-01],
	[3.6745000000E+04, 2.8357778141E+01, 4.8880269964E+00, 1.2326167170E+01, 3.1155226294E+00, 9.5801243333E-01],
	[3.6750000000E+04, 2.8364410528E+01, 4.8880489612E+00, 1.2331639341E+01, 3.1159610903E+00, 9.5803175201E-01],
	[3.6755000000E+04, 2.8371043564E+01, 4.8880709230E+00, 1.2337113196E+01, 3.1163994411E+00, 9.5805106091E-01],
	[3.6760000000E+04, 2.8377677249E+01, 4.8880928820E+00, 1.2342588735E+01, 3.1168376817E+00, 9.5807036004E-01],
	[3.6765000000E+04, 2.8384311582E+01, 4.8881148381E+00, 1.2348065958E+01, 3.1172758122E+00, 9.5808964939E-01],
	[3.6770000000E+04, 2.8390946563E+01, 4.8881367913E+00, 1.2353544866E+01, 3.1177138325E+00, 9.5810892898E-01],
	[3.6775000000E+04, 2.8397582193E+01, 4.8881587416E+00, 1.2359025459E+01, 3.1181517427E+00, 9.5812819880E-01],
	[3.6780000000E+04, 2.8404218472E+01, 4.8881806890E+00, 1.2364507736E+01, 3.1185895429E+00, 9.5814745887E-01],
	[3.6785000000E+04, 2.8410855399E+01, 4.8882026335E+00, 1.2369991699E+01, 3.1190272329E+00, 9.5816670919E-01],
	[3.6790000000E+04, 2.8417492974E+01, 4.8882245752E+00, 1.2375477348E+01, 3.1194648129E+00, 9.5818594977E-01],
	[3.6795000000E+04, 2.8424131198E+01, 4.8882465140E+00, 1.2380964682E+01, 3.1199022828E+00, 9.5820518060E-01],
	[3.6800000000E+04, 2.8430770070E+01, 4.8882684499E+00, 1.2386453703E+01, 3.1203396427E+00, 9.5822440169E-01],
	[3.6805000000E+04, 2.8437409591E+01, 4.8882903829E+00, 1.2391944411E+01, 3.1207768926E+00, 9.5824361306E-01],
	[3.6810000000E+04, 2.8444054668E+01, 4.8883129504E+00, 1.2397436805E+01, 3.1212143515E+00, 9.5826281470E-01],
	[3.6815000000E+04, 2.8450713069E+01, 4.8883371600E+00, 1.2402930886E+01, 3.1216525239E+00, 9.5828200662E-01],
	[3.6820000000E+04, 2.8457372124E+01, 4.8883613665E+00, 1.2408426655E+01, 3.1220905867E+00, 9.5830118882E-01],
	[3.6825000000E+04, 2.8464031832E+01, 4.8883855698E+00, 1.2413924111E+01, 3.1225285399E+00, 9.5832036131E-01],
	[3.6830000000E+04, 2.8470692195E+01, 4.8884097700E+00, 1.2419423256E+01, 3.1229663835E+00, 9.5833952410E-01],
	[3.6835000000E+04, 2.8477353212E+01, 4.8884339669E+00, 1.2424924088E+01, 3.1234041177E+00, 9.5835867719E-01],
	[3.6840000000E+04, 2.8484014882E+01, 4.8884581608E+00, 1.2430426610E+01, 3.1238417422E+00, 9.5837782058E-01],
	[3.6845000000E+04, 2.8490677207E+01, 4.8884823514E+00, 1.2435930820E+01, 3.1242792573E+00, 9.5839695428E-01],
	[3.6850000000E+04, 2.8497340186E+01, 4.8885065389E+00, 1.2441436719E+01, 3.1247166628E+00, 9.5841607830E-01],
	[3.6855000000E+04, 2.8504003818E+01, 4.8885307232E+00, 1.2446944308E+01, 3.1251539589E+00, 9.5843519264E-01],
	[3.6860000000E+04, 2.8510668105E+01, 4.8885549044E+00, 1.2452453586E+01, 3.1255911455E+00, 9.5845429730E-01],
	[3.6865000000E+04, 2.8517333045E+01, 4.8885790824E+00, 1.2457964554E+01, 3.1260282226E+00, 9.5847339229E-01],
	[3.6870000000E+04, 2.8523998639E+01, 4.8886032572E+00, 1.2463477213E+01, 3.1264651903E+00, 9.5849247762E-01],
	[3.6875000000E+04, 2.8530664887E+01, 4.8886274289E+00, 1.2468991562E+01, 3.1269020486E+00, 9.5851155329E-01],
	[3.6880000000E+04, 2.8537331789E+01, 4.8886515974E+00, 1.2474507602E+01, 3.1273387975E+00, 9.5853061931E-01],
	[3.6885000000E+04, 2.8543999344E+01, 4.8886757628E+00, 1.2480025334E+01, 3.1277754369E+00, 9.5854967567E-01],
	[3.6890000000E+04, 2.8550667553E+01, 4.8886999250E+00, 1.2485544756E+01, 3.1282119670E+00, 9.5856872239E-01],
	[3.6895000000E+04, 2.8557336416E+01, 4.8887240841E+00, 1.2491065871E+01, 3.1286483877E+00, 9.5858775948E-01],
	[3.6900000000E+04, 2.8564005933E+01, 4.8887482400E+00, 1.2496588677E+01, 3.1290846991E+00, 9.5860678693E-01],
	[3.6905000000E+04, 2.8570676103E+01, 4.8887723927E+00, 1.2502113176E+01, 3.1295209012E+00, 9.5862580474E-01],
	[3.6910000000E+04, 2.8577346927E+01, 4.8887965423E+00, 1.2507639367E+01, 3.1299569939E+00, 9.5864481294E-01],
	[3.6915000000E+04, 2.8584018405E+01, 4.8888206888E+00, 1.2513167252E+01, 3.1303929773E+00, 9.5866381152E-01],
	[3.6920000000E+04, 2.8590690536E+01, 4.8888448321E+00, 1.2518696829E+01, 3.1308288515E+00, 9.5868280048E-01],
	[3.6925000000E+04, 2.8597363321E+01, 4.8888689722E+00, 1.2524228100E+01, 3.1312646164E+00, 9.5870177983E-01],
	[3.6930000000E+04, 2.8604036759E+01, 4.8888931092E+00, 1.2529761065E+01, 3.1317002720E+00, 9.5872074958E-01],
	[3.6935000000E+04, 2.8610710851E+01, 4.8889172431E+00, 1.2535295724E+01, 3.1321358184E+00, 9.5873970973E-01],
	[3.6940000000E+04, 2.8617385596E+01, 4.8889413738E+00, 1.2540832077E+01, 3.1325712555E+00, 9.5875866029E-01],
	[3.6945000000E+04, 2.8624060995E+01, 4.8889655013E+00, 1.2546370124E+01, 3.1330065835E+00, 9.5877760126E-01],
	[3.6950000000E+04, 2.8630737047E+01, 4.8889896257E+00, 1.2551909867E+01, 3.1334418023E+00, 9.5879653265E-01],
	[3.6955000000E+04, 2.8637413753E+01, 4.8890137470E+00, 1.2557451305E+01, 3.1338769119E+00, 9.5881545445E-01],
	[3.6960000000E+04, 2.8644091112E+01, 4.8890378651E+00, 1.2562994438E+01, 3.1343119123E+00, 9.5883436669E-01],
	[3.6965000000E+04, 2.8650769125E+01, 4.8890619801E+00, 1.2568539267E+01, 3.1347468036E+00, 9.5885326935E-01],
	[3.6970000000E+04, 2.8657447790E+01, 4.8890860919E+00, 1.2574085792E+01, 3.1351815858E+00, 9.5887216246E-01],
	[3.6975000000E+04, 2.8664127109E+01, 4.8891102006E+00, 1.2579634014E+01, 3.1356162588E+00, 9.5889104600E-01],
	[3.6980000000E+04, 2.8670807082E+01, 4.8891343062E+00, 1.2585183932E+01, 3.1360508228E+00, 9.5890992000E-01],
	[3.6985000000E+04, 2.8677487708E+01, 4.8891584086E+00, 1.2590735547E+01, 3.1364852777E+00, 9.5892878444E-01],
	[3.6990000000E+04, 2.8684168987E+01, 4.8891825078E+00, 1.2596288859E+01, 3.1369196235E+00, 9.5894763934E-01],
	[3.6995000000E+04, 2.8690850919E+01, 4.8892066040E+00, 1.2601843869E+01, 3.1373538603E+00, 9.5896648470E-01],
	[3.7000000000E+04, 2.8697533504E+01, 4.8892306970E+00, 1.2607400577E+01, 3.1377879880E+00, 9.5898532053E-01],
	[3.7005000000E+04, 2.8704216743E+01, 4.8892547868E+00, 1.2612958983E+01, 3.1382220067E+00, 9.5900414684E-01],
	[3.7010000000E+04, 2.8710900635E+01, 4.8892788735E+00, 1.2618519087E+01, 3.1386559164E+00, 9.5902296362E-01],
	[3.7015000000E+04, 2.8717585179E+01, 4.8893029571E+00, 1.2624080889E+01, 3.1390897172E+00, 9.5904177088E-01],
	[3.7020000000E+04, 2.8724270377E+01, 4.8893270376E+00, 1.2629644391E+01, 3.1395234089E+00, 9.5906056863E-01],
	[3.7025000000E+04, 2.8730956228E+01, 4.8893511149E+00, 1.2635209592E+01, 3.1399569918E+00, 9.5907935687E-01],
	[3.7030000000E+04, 2.8737642733E+01, 4.8893751891E+00, 1.2640776493E+01, 3.1403904656E+00, 9.5909813561E-01],
	[3.7035000000E+04, 2.8744329890E+01, 4.8893992601E+00, 1.2646345093E+01, 3.1408238306E+00, 9.5911690485E-01],
	[3.7040000000E+04, 2.8751017700E+01, 4.8894233280E+00, 1.2651915393E+01, 3.1412570867E+00, 9.5913566460E-01],
	[3.7045000000E+04, 2.8757706163E+01, 4.8894473928E+00, 1.2657487394E+01, 3.1416902338E+00, 9.5915441487E-01],
	[3.7050000000E+04, 2.8764395279E+01, 4.8894714545E+00, 1.2663061096E+01, 3.1421232721E+00, 9.5917315565E-01],
	[3.7055000000E+04, 2.8771085048E+01, 4.8894955130E+00, 1.2668636498E+01, 3.1425562016E+00, 9.5919188695E-01],
	[3.7060000000E+04, 2.8777775470E+01, 4.8895195684E+00, 1.2674213602E+01, 3.1429890222E+00, 9.5921060878E-01],
	[3.7065000000E+04, 2.8784466545E+01, 4.8895436207E+00, 1.2679792408E+01, 3.1434217339E+00, 9.5922932114E-01],
	[3.7070000000E+04, 2.8791158273E+01, 4.8895676699E+00, 1.2685372915E+01, 3.1438543369E+00, 9.5924802405E-01],
	[3.7075000000E+04, 2.8797850653E+01, 4.8895917159E+00, 1.2690955124E+01, 3.1442868311E+00, 9.5926671749E-01],
	[3.7080000000E+04, 2.8804543687E+01, 4.8896157588E+00, 1.2696539036E+01, 3.1447192165E+00, 9.5928540148E-01],
	[3.7085000000E+04, 2.8811237373E+01, 4.8896397986E+00, 1.2702124650E+01, 3.1451514931E+00, 9.5930407603E-01],
	[3.7090000000E+04, 2.8817931712E+01, 4.8896638352E+00, 1.2707711968E+01, 3.1455836610E+00, 9.5932274113E-01],
	[3.7095000000E+04, 2.8824626703E+01, 4.8896878688E+00, 1.2713300989E+01, 3.1460157202E+00, 9.5934139680E-01],
	[3.7100000000E+04, 2.8831322348E+01, 4.8897118992E+00, 1.2718891713E+01, 3.1464476706E+00, 9.5936004303E-01],
	[3.7105000000E+04, 2.8838018645E+01, 4.8897359265E+00, 1.2724484141E+01, 3.1468795124E+00, 9.5937867984E-01],
	[3.7110000000E+04, 2.8844715595E+01, 4.8897599506E+00, 1.2730078274E+01, 3.1473112455E+00, 9.5939730723E-01],
	[3.7115000000E+04, 2.8851413197E+01, 4.8897839717E+00, 1.2735674111E+01, 3.1477428699E+00, 9.5941592520E-01],
	[3.7120000000E+04, 2.8858111452E+01, 4.8898079896E+00, 1.2741271652E+01, 3.1481743857E+00, 9.5943453375E-01],
	[3.7125000000E+04, 2.8864810360E+01, 4.8898320044E+00, 1.2746870899E+01, 3.1486057928E+00, 9.5945313291E-01],
	[3.7130000000E+04, 2.8871509920E+01, 4.8898560161E+00, 1.2752471851E+01, 3.1490370914E+00, 9.5947172265E-01],
	[3.7135000000E+04, 2.8878210133E+01, 4.8898800247E+00, 1.2758074509E+01, 3.1494682813E+00, 9.5949030301E-01],
	[3.7140000000E+04, 2.8884910998E+01, 4.8899040302E+00, 1.2763678872E+01, 3.1498993627E+00, 9.5950887397E-01],
	[3.7145000000E+04, 2.8891612516E+01, 4.8899280326E+00, 1.2769284942E+01, 3.1503303355E+00, 9.5952743554E-01],
	[3.7150000000E+04, 2.8898314686E+01, 4.8899520318E+00, 1.2774892718E+01, 3.1507611997E+00, 9.5954598773E-01],
	[3.7155000000E+04, 2.8905017508E+01, 4.8899760279E+00, 1.2780502201E+01, 3.1511919554E+00, 9.5956453055E-01],
	[3.7160000000E+04, 2.8911720984E+01, 4.8900000210E+00, 1.2786113391E+01, 3.1516226026E+00, 9.5958306399E-01],
	[3.7165000000E+04, 2.8918425111E+01, 4.8900240109E+00, 1.2791726288E+01, 3.1520531413E+00, 9.5960158807E-01],
	[3.7170000000E+04, 2.8925129891E+01, 4.8900479977E+00, 1.2797340893E+01, 3.1524835715E+00, 9.5962010279E-01],
	[3.7175000000E+04, 2.8931835323E+01, 4.8900719814E+00, 1.2802957206E+01, 3.1529138932E+00, 9.5963860815E-01],
	[3.7180000000E+04, 2.8938541408E+01, 4.8900959620E+00, 1.2808575227E+01, 3.1533441065E+00, 9.5965710415E-01],
	[3.7185000000E+04, 2.8945248145E+01, 4.8901199394E+00, 1.2814194957E+01, 3.1537742114E+00, 9.5967559081E-01],
	[3.7190000000E+04, 2.8951955534E+01, 4.8901439138E+00, 1.2819816395E+01, 3.1542042078E+00, 9.5969406813E-01],
	[3.7195000000E+04, 2.8958663575E+01, 4.8901678851E+00, 1.2825439543E+01, 3.1546340959E+00, 9.5971253612E-01],
	[3.7200000000E+04, 2.8965372269E+01, 4.8901918532E+00, 1.2831064400E+01, 3.1550638755E+00, 9.5973099477E-01],
	[3.7205000000E+04, 2.8972081615E+01, 4.8902158183E+00, 1.2836690966E+01, 3.1554935468E+00, 9.5974944410E-01],
	[3.7210000000E+04, 2.8978791613E+01, 4.8902397803E+00, 1.2842319243E+01, 3.1559231098E+00, 9.5976788410E-01],
	[3.7215000000E+04, 2.8985502263E+01, 4.8902637391E+00, 1.2847949229E+01, 3.1563525644E+00, 9.5978631479E-01],
	[3.7220000000E+04, 2.8992213565E+01, 4.8902876949E+00, 1.2853580927E+01, 3.1567819106E+00, 9.5980473616E-01],
	[3.7225000000E+04, 2.8998925520E+01, 4.8903116475E+00, 1.2859214335E+01, 3.1572111486E+00, 9.5982314823E-01],
	[3.7230000000E+04, 2.9005638126E+01, 4.8903355971E+00, 1.2864849454E+01, 3.1576402783E+00, 9.5984155100E-01],
	[3.7235000000E+04, 2.9012351385E+01, 4.8903595435E+00, 1.2870486284E+01, 3.1580692997E+00, 9.5985994447E-01],
	[3.7240000000E+04, 2.9019065295E+01, 4.8903834869E+00, 1.2876124827E+01, 3.1584982129E+00, 9.5987832865E-01],
	[3.7245000000E+04, 2.9025779858E+01, 4.8904074271E+00, 1.2881765081E+01, 3.1589270178E+00, 9.5989670355E-01],
	[3.7250000000E+04, 2.9032495072E+01, 4.8904313643E+00, 1.2887407047E+01, 3.1593557146E+00, 9.5991506916E-01],
	[3.7255000000E+04, 2.9039210939E+01, 4.8904552984E+00, 1.2893050726E+01, 3.1597843031E+00, 9.5993342550E-01],
	[3.7260000000E+04, 2.9045927458E+01, 4.8904792293E+00, 1.2898696118E+01, 3.1602127834E+00, 9.5995177256E-01],
	[3.7265000000E+04, 2.9052644628E+01, 4.8905031572E+00, 1.2904343223E+01, 3.1606411556E+00, 9.5997011036E-01],
	[3.7270000000E+04, 2.9059362450E+01, 4.8905270820E+00, 1.2909992042E+01, 3.1610694196E+00, 9.5998843890E-01],
	[3.7275000000E+04, 2.9066080925E+01, 4.8905510037E+00, 1.2915642574E+01, 3.1614975754E+00, 9.6000675818E-01],
	[3.7280000000E+04, 2.9072800051E+01, 4.8905749223E+00, 1.2921294820E+01, 3.1619256232E+00, 9.6002506820E-01],
	[3.7285000000E+04, 2.9079519828E+01, 4.8905988378E+00, 1.2926948781E+01, 3.1623535628E+00, 9.6004336899E-01],
	[3.7290000000E+04, 2.9086240258E+01, 4.8906227502E+00, 1.2932604456E+01, 3.1627813944E+00, 9.6006166053E-01],
	[3.7295000000E+04, 2.9092961339E+01, 4.8906466595E+00, 1.2938261845E+01, 3.1632091179E+00, 9.6007994283E-01],
	[3.7300000000E+04, 2.9099683073E+01, 4.8906705658E+00, 1.2943920951E+01, 3.1636367333E+00, 9.6009821590E-01],
	[3.7305000000E+04, 2.9106405458E+01, 4.8906944689E+00, 1.2949581771E+01, 3.1640642407E+00, 9.6011647975E-01],
	[3.7310000000E+04, 2.9113128494E+01, 4.8907183690E+00, 1.2955244307E+01, 3.1644916401E+00, 9.6013473437E-01],
	[3.7315000000E+04, 2.9119852182E+01, 4.8907422660E+00, 1.2960908560E+01, 3.1649189315E+00, 9.6015297978E-01],
	[3.7320000000E+04, 2.9126576522E+01, 4.8907661599E+00, 1.2966574528E+01, 3.1653461148E+00, 9.6017121598E-01],
	[3.7325000000E+04, 2.9133301514E+01, 4.8907900507E+00, 1.2972242214E+01, 3.1657731903E+00, 9.6018944297E-01],
	[3.7330000000E+04, 2.9140027157E+01, 4.8908139384E+00, 1.2977911616E+01, 3.1662001577E+00, 9.6020766076E-01],
	[3.7335000000E+04, 2.9146753452E+01, 4.8908378231E+00, 1.2983582735E+01, 3.1666270173E+00, 9.6022586935E-01],
	[3.7340000000E+04, 2.9153480398E+01, 4.8908617046E+00, 1.2989255572E+01, 3.1670537689E+00, 9.6024406875E-01],
	[3.7345000000E+04, 2.9160207996E+01, 4.8908855831E+00, 1.2994930126E+01, 3.1674804126E+00, 9.6026225896E-01],
	[3.7350000000E+04, 2.9166936245E+01, 4.8909094585E+00, 1.3000606399E+01, 3.1679069484E+00, 9.6028043999E-01],
	[3.7355000000E+04, 2.9173665146E+01, 4.8909333308E+00, 1.3006284390E+01, 3.1683333764E+00, 9.6029861185E-01],
	[3.7360000000E+04, 2.9180394698E+01, 4.8909572001E+00, 1.3011964100E+01, 3.1687596965E+00, 9.6031677453E-01],
	[3.7365000000E+04, 2.9187124902E+01, 4.8909810662E+00, 1.3017645528E+01, 3.1691859087E+00, 9.6033492804E-01],
	[3.7370000000E+04, 2.9193855757E+01, 4.8910049293E+00, 1.3023328676E+01, 3.1696120132E+00, 9.6035307240E-01],
	[3.7375000000E+04, 2.9200587263E+01, 4.8910287893E+00, 1.3029013543E+01, 3.1700380098E+00, 9.6037120759E-01],
	[3.7380000000E+04, 2.9207319421E+01, 4.8910526463E+00, 1.3034700130E+01, 3.1704638987E+00, 9.6038933364E-01],
	[3.7385000000E+04, 2.9214052230E+01, 4.8910765001E+00, 1.3040388437E+01, 3.1708896798E+00, 9.6040745054E-01],
	[3.7390000000E+04, 2.9220785691E+01, 4.8911003509E+00, 1.3046078465E+01, 3.1713153532E+00, 9.6042555829E-01],
	[3.7395000000E+04, 2.9227519803E+01, 4.8911241986E+00, 1.3051770213E+01, 3.1717409188E+00, 9.6044365691E-01],
	[3.7400000000E+04, 2.9234254566E+01, 4.8911480433E+00, 1.3057463682E+01, 3.1721663767E+00, 9.6046174640E-01],
	[3.7405000000E+04, 2.9241003291E+01, 4.8911735945E+00, 1.3063158873E+01, 3.1725926029E+00, 9.6047982676E-01],
	[3.7410000000E+04, 2.9247756749E+01, 4.8911996660E+00, 1.3068855785E+01, 3.1730189900E+00, 9.6049789799E-01],
	[3.7415000000E+04, 2.9254510864E+01, 4.8912257341E+00, 1.3074554419E+01, 3.1734452698E+00, 9.6051596011E-01],
	[3.7420000000E+04, 2.9261265636E+01, 4.8912517989E+00, 1.3080254774E+01, 3.1738714423E+00, 9.6053401312E-01],
	[3.7425000000E+04, 2.9268021065E+01, 4.8912778604E+00, 1.3085956853E+01, 3.1742975075E+00, 9.6055205702E-01],
	[3.7430000000E+04, 2.9274777150E+01, 4.8913039185E+00, 1.3091660654E+01, 3.1747234654E+00, 9.6057009182E-01],
	[3.7435000000E+04, 2.9281533893E+01, 4.8913299732E+00, 1.3097366178E+01, 3.1751493162E+00, 9.6058811752E-01],
	[3.7440000000E+04, 2.9288291292E+01, 4.8913560246E+00, 1.3103073425E+01, 3.1755750597E+00, 9.6060613413E-01],
	[3.7445000000E+04, 2.9295049348E+01, 4.8913820727E+00, 1.3108782396E+01, 3.1760006960E+00, 9.6062414165E-01],
	[3.7450000000E+04, 2.9301808060E+01, 4.8914081175E+00, 1.3114493090E+01, 3.1764262251E+00, 9.6064214009E-01],
	[3.7455000000E+04, 2.9308567429E+01, 4.8914341589E+00, 1.3120205509E+01, 3.1768516470E+00, 9.6066012945E-01],
	[3.7460000000E+04, 2.9315327455E+01, 4.8914601969E+00, 1.3125919652E+01, 3.1772769618E+00, 9.6067810973E-01],
	[3.7465000000E+04, 2.9322088138E+01, 4.8914862316E+00, 1.3131635520E+01, 3.1777021694E+00, 9.6069608095E-01],
	[3.7470000000E+04, 2.9328849477E+01, 4.8915122630E+00, 1.3137353113E+01, 3.1781272699E+00, 9.6071404311E-01],
	[3.7475000000E+04, 2.9335611473E+01, 4.8915382911E+00, 1.3143072432E+01, 3.1785522633E+00, 9.6073199621E-01],
	[3.7480000000E+04, 2.9342374125E+01, 4.8915643158E+00, 1.3148793476E+01, 3.1789771496E+00, 9.6074994026E-01],
	[3.7485000000E+04, 2.9349137434E+01, 4.8915903372E+00, 1.3154516245E+01, 3.1794019289E+00, 9.6076787525E-01],
	[3.7490000000E+04, 2.9355901400E+01, 4.8916163552E+00, 1.3160240741E+01, 3.1798266010E+00, 9.6078580121E-01],
	[3.7495000000E+04, 2.9362666022E+01, 4.8916423700E+00, 1.3165966964E+01, 3.1802511662E+00, 9.6080371812E-01],
	[3.7500000000E+04, 2.9369431300E+01, 4.8916683814E+00, 1.3171694913E+01, 3.1806756243E+00, 9.6082162601E-01],
	[3.7505000000E+04, 2.9376197235E+01, 4.8916943894E+00, 1.3177424589E+01, 3.1810999754E+00, 9.6083952486E-01],
	[3.7510000000E+04, 2.9382963826E+01, 4.8917203942E+00, 1.3183155993E+01, 3.1815242196E+00, 9.6085741469E-01],
	[3.7515000000E+04, 2.9389731074E+01, 4.8917463956E+00, 1.3188889124E+01, 3.1819483567E+00, 9.6087529551E-01],
	[3.7520000000E+04, 2.9396498978E+01, 4.8917723936E+00, 1.3194623983E+01, 3.1823723870E+00, 9.6089316731E-01],
	[3.7525000000E+04, 2.9403267539E+01, 4.8917983884E+00, 1.3200360570E+01, 3.1827963102E+00, 9.6091103010E-01],
	[3.7530000000E+04, 2.9410036755E+01, 4.8918243798E+00, 1.3206098886E+01, 3.1832201266E+00, 9.6092888388E-01],
	[3.7535000000E+04, 2.9416806629E+01, 4.8918503679E+00, 1.3211838931E+01, 3.1836438361E+00, 9.6094672867E-01],
	[3.7540000000E+04, 2.9423577158E+01, 4.8918763527E+00, 1.3217580704E+01, 3.1840674386E+00, 9.6096456447E-01],
	[3.7545000000E+04, 2.9430348344E+01, 4.8919023342E+00, 1.3223324207E+01, 3.1844909343E+00, 9.6098239127E-01],
	[3.7550000000E+04, 2.9437120186E+01, 4.8919283123E+00, 1.3229069440E+01, 3.1849143232E+00, 9.6100020909E-01],
	[3.7555000000E+04, 2.9443892684E+01, 4.8919542871E+00, 1.3234816403E+01, 3.1853376052E+00, 9.6101801793E-01],
	[3.7560000000E+04, 2.9450665838E+01, 4.8919802586E+00, 1.3240565095E+01, 3.1857607804E+00, 9.6103581780E-01],
	[3.7565000000E+04, 2.9457439649E+01, 4.8920062268E+00, 1.3246315519E+01, 3.1861838488E+00, 9.6105360870E-01],
	[3.7570000000E+04, 2.9464214116E+01, 4.8920321916E+00, 1.3252067673E+01, 3.1866068105E+00, 9.6107139064E-01],
	[3.7575000000E+04, 2.9470989238E+01, 4.8920581532E+00, 1.3257821558E+01, 3.1870296653E+00, 9.6108916361E-01],
	[3.7580000000E+04, 2.9477765017E+01, 4.8920841114E+00, 1.3263577175E+01, 3.1874524134E+00, 9.6110692763E-01],
	[3.7585000000E+04, 2.9484541452E+01, 4.8921100663E+00, 1.3269334523E+01, 3.1878750548E+00, 9.6112468270E-01],
	[3.7590000000E+04, 2.9491318543E+01, 4.8921360179E+00, 1.3275093604E+01, 3.1882975895E+00, 9.6114242883E-01],
	[3.7595000000E+04, 2.9498096291E+01, 4.8921619662E+00, 1.3280854416E+01, 3.1887200175E+00, 9.6116016601E-01],
	[3.7600000000E+04, 2.9504874694E+01, 4.8921879111E+00, 1.3286616962E+01, 3.1891423388E+00, 9.6117789426E-01],
	[3.7605000000E+04, 2.9511653753E+01, 4.8922138528E+00, 1.3292381240E+01, 3.1895645534E+00, 9.6119561358E-01],
	[3.7610000000E+04, 2.9518433468E+01, 4.8922397911E+00, 1.3298147251E+01, 3.1899866614E+00, 9.6121332398E-01],
	[3.7615000000E+04, 2.9525213839E+01, 4.8922657262E+00, 1.3303914995E+01, 3.1904086628E+00, 9.6123102545E-01],
	[3.7620000000E+04, 2.9531994866E+01, 4.8922916579E+00, 1.3309684474E+01, 3.1908305575E+00, 9.6124871801E-01],
	[3.7625000000E+04, 2.9538776548E+01, 4.8923175863E+00, 1.3315455686E+01, 3.1912523457E+00, 9.6126640166E-01],
	[3.7630000000E+04, 2.9545558887E+01, 4.8923435114E+00, 1.3321228633E+01, 3.1916740273E+00, 9.6128407641E-01],
	[3.7635000000E+04, 2.9552341882E+01, 4.8923694332E+00, 1.3327003314E+01, 3.1920956023E+00, 9.6130174225E-01],
	[3.7640000000E+04, 2.9559125532E+01, 4.8923953517E+00, 1.3332779730E+01, 3.1925170708E+00, 9.6131939920E-01],
	[3.7645000000E+04, 2.9565909838E+01, 4.8924212669E+00, 1.3338557881E+01, 3.1929384328E+00, 9.6133704725E-01],
	[3.7650000000E+04, 2.9572694800E+01, 4.8924471787E+00, 1.3344337768E+01, 3.1933596882E+00, 9.6135468642E-01],
	[3.7655000000E+04, 2.9579480417E+01, 4.8924730873E+00, 1.3350119391E+01, 3.1937808372E+00, 9.6137231671E-01],
	[3.7660000000E+04, 2.9586266691E+01, 4.8924989926E+00, 1.3355902749E+01, 3.1942018797E+00, 9.6138993812E-01],
	[3.7665000000E+04, 2.9593053620E+01, 4.8925248946E+00, 1.3361687844E+01, 3.1946228158E+00, 9.6140755067E-01],
	[3.7670000000E+04, 2.9599841205E+01, 4.8925507932E+00, 1.3367474675E+01, 3.1950436454E+00, 9.6142515434E-01],
	[3.7675000000E+04, 2.9606629445E+01, 4.8925766886E+00, 1.3373263244E+01, 3.1954643686E+00, 9.6144274915E-01],
	[3.7680000000E+04, 2.9613418341E+01, 4.8926025807E+00, 1.3379053549E+01, 3.1958849854E+00, 9.6146033511E-01],
	[3.7685000000E+04, 2.9620207892E+01, 4.8926284694E+00, 1.3384845592E+01, 3.1963054958E+00, 9.6147791221E-01],
	[3.7690000000E+04, 2.9626998100E+01, 4.8926543549E+00, 1.3390639373E+01, 3.1967258998E+00, 9.6149548047E-01],
	[3.7695000000E+04, 2.9633788962E+01, 4.8926802371E+00, 1.3396434892E+01, 3.1971461975E+00, 9.6151303989E-01],
	[3.7700000000E+04, 2.9640580481E+01, 4.8927061160E+00, 1.3402232150E+01, 3.1975663889E+00, 9.6153059046E-01],
	[3.7705000000E+04, 2.9647372654E+01, 4.8927319916E+00, 1.3408031145E+01, 3.1979864739E+00, 9.6154813221E-01],
	[3.7710000000E+04, 2.9654165484E+01, 4.8927578639E+00, 1.3413831880E+01, 3.1984064527E+00, 9.6156566513E-01],
	[3.7715000000E+04, 2.9660958968E+01, 4.8927837329E+00, 1.3419634354E+01, 3.1988263252E+00, 9.6158318922E-01],
	[3.7720000000E+04, 2.9667753109E+01, 4.8928095986E+00, 1.3425438568E+01, 3.1992460914E+00, 9.6160070450E-01],
	[3.7725000000E+04, 2.9674547904E+01, 4.8928354610E+00, 1.3431244522E+01, 3.1996657514E+00, 9.6161821096E-01],
	[3.7730000000E+04, 2.9681343355E+01, 4.8928613201E+00, 1.3437052215E+01, 3.2000853051E+00, 9.6163570862E-01],
	[3.7735000000E+04, 2.9688139461E+01, 4.8928871759E+00, 1.3442861649E+01, 3.2005047526E+00, 9.6165319747E-01],
	[3.7740000000E+04, 2.9694936223E+01, 4.8929130285E+00, 1.3448672824E+01, 3.2009240940E+00, 9.6167067753E-01],
	[3.7745000000E+04, 2.9701733640E+01, 4.8929388777E+00, 1.3454485739E+01, 3.2013433292E+00, 9.6168814879E-01],
	[3.7750000000E+04, 2.9708531712E+01, 4.8929647237E+00, 1.3460300396E+01, 3.2017624582E+00, 9.6170561126E-01],
	[3.7755000000E+04, 2.9715330440E+01, 4.8929905664E+00, 1.3466116795E+01, 3.2021814811E+00, 9.6172306495E-01],
	[3.7760000000E+04, 2.9722129823E+01, 4.8930164058E+00, 1.3471934935E+01, 3.2026003978E+00, 9.6174050986E-01],
	[3.7765000000E+04, 2.9728929861E+01, 4.8930422419E+00, 1.3477754818E+01, 3.2030192085E+00, 9.6175794599E-01],
	[3.7770000000E+04, 2.9735730554E+01, 4.8930680747E+00, 1.3483576443E+01, 3.2034379130E+00, 9.6177537336E-01],
	[3.7775000000E+04, 2.9742531902E+01, 4.8930939043E+00, 1.3489399810E+01, 3.2038565115E+00, 9.6179279196E-01],
	[3.7780000000E+04, 2.9749333906E+01, 4.8931197305E+00, 1.3495224921E+01, 3.2042750040E+00, 9.6181020180E-01],
	[3.7785000000E+04, 2.9756136565E+01, 4.8931455535E+00, 1.3501051775E+01, 3.2046933904E+00, 9.6182760289E-01],
	[3.7790000000E+04, 2.9762939878E+01, 4.8931713732E+00, 1.3506880372E+01, 3.2051116708E+00, 9.6184499522E-01],
	[3.7795000000E+04, 2.9769743847E+01, 4.8931971896E+00, 1.3512710714E+01, 3.2055298452E+00, 9.6186237882E-01],
	[3.7800000000E+04, 2.9776548471E+01, 4.8932230028E+00, 1.3518542799E+01, 3.2059479136E+00, 9.6187975367E-01],
	[3.7805000000E+04, 2.9783353750E+01, 4.8932488126E+00, 1.3524376629E+01, 3.2063658761E+00, 9.6189711978E-01],
	[3.7810000000E+04, 2.9790159684E+01, 4.8932746192E+00, 1.3530212204E+01, 3.2067837326E+00, 9.6191447717E-01],
	[3.7815000000E+04, 2.9796966273E+01, 4.8933004225E+00, 1.3536049524E+01, 3.2072014832E+00, 9.6193182583E-01],
	[3.7820000000E+04, 2.9803773517E+01, 4.8933262226E+00, 1.3541888589E+01, 3.2076191279E+00, 9.6194916577E-01],
	[3.7825000000E+04, 2.9810581416E+01, 4.8933520193E+00, 1.3547729400E+01, 3.2080366667E+00, 9.6196649699E-01],
	[3.7830000000E+04, 2.9817389970E+01, 4.8933778128E+00, 1.3553571957E+01, 3.2084540996E+00, 9.6198381950E-01],
	[3.7835000000E+04, 2.9824199179E+01, 4.8934036030E+00, 1.3559416259E+01, 3.2088714267E+00, 9.6200113331E-01],
	[3.7840000000E+04, 2.9831009042E+01, 4.8934293900E+00, 1.3565262309E+01, 3.2092886479E+00, 9.6201843841E-01],
	[3.7845000000E+04, 2.9837819561E+01, 4.8934551736E+00, 1.3571110105E+01, 3.2097057633E+00, 9.6203573482E-01],
	[3.7850000000E+04, 2.9844630734E+01, 4.8934809540E+00, 1.3576959648E+01, 3.2101227729E+00, 9.6205302253E-01],
	[3.7855000000E+04, 2.9851442562E+01, 4.8935067312E+00, 1.3582810939E+01, 3.2105396768E+00, 9.6207030156E-01],
	[3.7860000000E+04, 2.9858255045E+01, 4.8935325050E+00, 1.3588663977E+01, 3.2109564748E+00, 9.6208757190E-01],
	[3.7865000000E+04, 2.9865068182E+01, 4.8935582756E+00, 1.3594518764E+01, 3.2113731671E+00, 9.6210483357E-01],
	[3.7870000000E+04, 2.9871881975E+01, 4.8935840429E+00, 1.3600375298E+01, 3.2117897537E+00, 9.6212208656E-01],
	[3.7875000000E+04, 2.9878696422E+01, 4.8936098070E+00, 1.3606233581E+01, 3.2122062346E+00, 9.6213933089E-01],
	[3.7880000000E+04, 2.9885511523E+01, 4.8936355678E+00, 1.3612093613E+01, 3.2126226097E+00, 9.6215656655E-01],
	[3.7885000000E+04, 2.9892327280E+01, 4.8936613253E+00, 1.3617955394E+01, 3.2130388792E+00, 9.6217379356E-01],
	[3.7890000000E+04, 2.9899143691E+01, 4.8936870796E+00, 1.3623818925E+01, 3.2134550430E+00, 9.6219101191E-01],
	[3.7895000000E+04, 2.9905960756E+01, 4.8937128306E+00, 1.3629684205E+01, 3.2138711012E+00, 9.6220822161E-01],
	[3.7900000000E+04, 2.9912778477E+01, 4.8937385783E+00, 1.3635551235E+01, 3.2142870538E+00, 9.6222542267E-01],
	[3.7905000000E+04, 2.9919596851E+01, 4.8937643228E+00, 1.3641420015E+01, 3.2147029008E+00, 9.6224261509E-01],
	[3.7910000000E+04, 2.9926415881E+01, 4.8937900640E+00, 1.3647290546E+01, 3.2151186421E+00, 9.6225979888E-01],
	[3.7915000000E+04, 2.9933235565E+01, 4.8938158020E+00, 1.3653162828E+01, 3.2155342779E+00, 9.6227697404E-01],
	[3.7920000000E+04, 2.9940055903E+01, 4.8938415367E+00, 1.3659036861E+01, 3.2159498082E+00, 9.6229414057E-01],
	[3.7925000000E+04, 2.9946876896E+01, 4.8938672681E+00, 1.3664912645E+01, 3.2163652329E+00, 9.6231129848E-01],
	[3.7930000000E+04, 2.9953698543E+01, 4.8938929963E+00, 1.3670790181E+01, 3.2167805521E+00, 9.6232844778E-01],
	[3.7935000000E+04, 2.9960520845E+01, 4.8939187212E+00, 1.3676669470E+01, 3.2171957658E+00, 9.6234558846E-01],
	[3.7940000000E+04, 2.9967343801E+01, 4.8939444429E+00, 1.3682550510E+01, 3.2176108740E+00, 9.6236272054E-01],
	[3.7945000000E+04, 2.9974167411E+01, 4.8939701613E+00, 1.3688433303E+01, 3.2180258768E+00, 9.6237984402E-01],
	[3.7950000000E+04, 2.9980991676E+01, 4.8939958765E+00, 1.3694317849E+01, 3.2184407741E+00, 9.6239695891E-01],
	[3.7955000000E+04, 2.9987816595E+01, 4.8940215884E+00, 1.3700204148E+01, 3.2188555660E+00, 9.6241406520E-01],
	[3.7960000000E+04, 2.9994642168E+01, 4.8940472971E+00, 1.3706092201E+01, 3.2192702525E+00, 9.6243116291E-01],
	[3.7965000000E+04, 3.0001468396E+01, 4.8940730025E+00, 1.3711982007E+01, 3.2196848336E+00, 9.6244825203E-01],
	[3.7970000000E+04, 3.0008295278E+01, 4.8940987047E+00, 1.3717873568E+01, 3.2200993093E+00, 9.6246533258E-01],
	[3.7975000000E+04, 3.0015122814E+01, 4.8941244036E+00, 1.3723766883E+01, 3.2205136797E+00, 9.6248240456E-01],
	[3.7980000000E+04, 3.0021951005E+01, 4.8941500992E+00, 1.3729661952E+01, 3.2209279447E+00, 9.6249946797E-01],
	[3.7985000000E+04, 3.0028779849E+01, 4.8941757916E+00, 1.3735558777E+01, 3.2213421044E+00, 9.6251652281E-01],
	[3.7990000000E+04, 3.0035609348E+01, 4.8942014808E+00, 1.3741457356E+01, 3.2217561588E+00, 9.6253356910E-01],
	[3.7995000000E+04, 3.0042439501E+01, 4.8942271667E+00, 1.3747357691E+01, 3.2221701080E+00, 9.6255060684E-01],
	[3.8000000000E+04, 3.0049270308E+01, 4.8942528494E+00, 1.3753259782E+01, 3.2225839518E+00, 9.6256763603E-01],
	[3.8005000000E+04, 3.0056107681E+01, 4.8942792805E+00, 1.3759163629E+01, 3.2229980844E+00, 9.6258465667E-01],
	[3.8010000000E+04, 3.0062956987E+01, 4.8943071415E+00, 1.3765069233E+01, 3.2234128632E+00, 9.6260166878E-01],
	[3.8015000000E+04, 3.0069806953E+01, 4.8943349991E+00, 1.3770976593E+01, 3.2238275372E+00, 9.6261867235E-01],
	[3.8020000000E+04, 3.0076657578E+01, 4.8943628532E+00, 1.3776885710E+01, 3.2242421062E+00, 9.6263566739E-01],
	[3.8025000000E+04, 3.0083508863E+01, 4.8943907037E+00, 1.3782796584E+01, 3.2246565705E+00, 9.6265265391E-01],
	[3.8030000000E+04, 3.0090360808E+01, 4.8944185508E+00, 1.3788709216E+01, 3.2250709300E+00, 9.6266963191E-01],
	[3.8035000000E+04, 3.0097213412E+01, 4.8944463944E+00, 1.3794623606E+01, 3.2254851846E+00, 9.6268660139E-01],
	[3.8040000000E+04, 3.0104066675E+01, 4.8944742344E+00, 1.3800539754E+01, 3.2258993345E+00, 9.6270356237E-01],
	[3.8045000000E+04, 3.0110920598E+01, 4.8945020710E+00, 1.3806457660E+01, 3.2263133796E+00, 9.6272051483E-01],
	[3.8050000000E+04, 3.0117775180E+01, 4.8945299040E+00, 1.3812377325E+01, 3.2267273199E+00, 9.6273745880E-01],
	[3.8055000000E+04, 3.0124630422E+01, 4.8945577336E+00, 1.3818298749E+01, 3.2271411555E+00, 9.6275439427E-01],
	[3.8060000000E+04, 3.0131486323E+01, 4.8945855596E+00, 1.3824221933E+01, 3.2275548865E+00, 9.6277132126E-01],
	[3.8065000000E+04, 3.0138342884E+01, 4.8946133822E+00, 1.3830146875E+01, 3.2279685127E+00, 9.6278823975E-01],
	[3.8070000000E+04, 3.0145200104E+01, 4.8946412013E+00, 1.3836073578E+01, 3.2283820342E+00, 9.6280514976E-01],
	[3.8075000000E+04, 3.0152057983E+01, 4.8946690168E+00, 1.3842002041E+01, 3.2287954511E+00, 9.6282205130E-01],
	[3.8080000000E+04, 3.0158916522E+01, 4.8946968289E+00, 1.3847932265E+01, 3.2292087634E+00, 9.6283894436E-01],
	[3.8085000000E+04, 3.0165775720E+01, 4.8947246375E+00, 1.3853864249E+01, 3.2296219710E+00, 9.6285582896E-01],
	[3.8090000000E+04, 3.0172635577E+01, 4.8947524426E+00, 1.3859797994E+01, 3.2300350741E+00, 9.6287270509E-01],
	[3.8095000000E+04, 3.0179496093E+01, 4.8947802442E+00, 1.3865733501E+01, 3.2304480725E+00, 9.6288957277E-01],
	[3.8100000000E+04, 3.0186357269E+01, 4.8948080423E+00, 1.3871670769E+01, 3.2308609664E+00, 9.6290643199E-01],
	[3.8105000000E+04, 3.0193219103E+01, 4.8948358369E+00, 1.3877609799E+01, 3.2312737558E+00, 9.6292328276E-01],
	[3.8110000000E+04, 3.0200081597E+01, 4.8948636280E+00, 1.3883550591E+01, 3.2316864406E+00, 9.6294012508E-01],
	[3.8115000000E+04, 3.0206944750E+01, 4.8948914157E+00, 1.3889493146E+01, 3.2320990209E+00, 9.6295695895E-01],
	[3.8120000000E+04, 3.0213808563E+01, 4.8949191998E+00, 1.3895437464E+01, 3.2325114967E+00, 9.6297378439E-01],
	[3.8125000000E+04, 3.0220673034E+01, 4.8949469805E+00, 1.3901383544E+01, 3.2329238681E+00, 9.6299060139E-01],
	[3.8130000000E+04, 3.0227538164E+01, 4.8949747577E+00, 1.3907331389E+01, 3.2333361349E+00, 9.6300740996E-01],
	[3.8135000000E+04, 3.0234403954E+01, 4.8950025313E+00, 1.3913280996E+01, 3.2337482974E+00, 9.6302421010E-01],
	[3.8140000000E+04, 3.0241270402E+01, 4.8950303016E+00, 1.3919232368E+01, 3.2341603554E+00, 9.6304100182E-01],
	[3.8145000000E+04, 3.0248137510E+01, 4.8950580683E+00, 1.3925185504E+01, 3.2345723090E+00, 9.6305778512E-01],
	[3.8150000000E+04, 3.0255005276E+01, 4.8950858315E+00, 1.3931140405E+01, 3.2349841583E+00, 9.6307456000E-01],
	[3.8155000000E+04, 3.0261873702E+01, 4.8951135913E+00, 1.3937097070E+01, 3.2353959032E+00, 9.6309132648E-01],
	[3.8160000000E+04, 3.0268742786E+01, 4.8951413476E+00, 1.3943055500E+01, 3.2358075437E+00, 9.6310808454E-01],
	[3.8165000000E+04, 3.0275612529E+01, 4.8951691004E+00, 1.3949015696E+01, 3.2362190799E+00, 9.6312483421E-01],
	[3.8170000000E+04, 3.0282482931E+01, 4.8951968497E+00, 1.3954977658E+01, 3.2366305118E+00, 9.6314157547E-01],
	[3.8175000000E+04, 3.0289353993E+01, 4.8952245956E+00, 1.3960941385E+01, 3.2370418394E+00, 9.6315830834E-01],
	[3.8180000000E+04, 3.0296225712E+01, 4.8952523379E+00, 1.3966906879E+01, 3.2374530627E+00, 9.6317503282E-01],
	[3.8185000000E+04, 3.0303098091E+01, 4.8952800768E+00, 1.3972874140E+01, 3.2378641818E+00, 9.6319174891E-01],
	[3.8190000000E+04, 3.0309971129E+01, 4.8953078123E+00, 1.3978843167E+01, 3.2382751967E+00, 9.6320845662E-01],
	[3.8195000000E+04, 3.0316844825E+01, 4.8953355442E+00, 1.3984813962E+01, 3.2386861073E+00, 9.6322515595E-01],
	[3.8200000000E+04, 3.0323719180E+01, 4.8953632727E+00, 1.3990786523E+01, 3.2390969137E+00, 9.6324184691E-01],
	[3.8205000000E+04, 3.0330594194E+01, 4.8953909977E+00, 1.3996760853E+01, 3.2395076159E+00, 9.6325852950E-01],
	[3.8210000000E+04, 3.0337469866E+01, 4.8954187192E+00, 1.4002736951E+01, 3.2399182140E+00, 9.6327520372E-01],
	[3.8215000000E+04, 3.0344346197E+01, 4.8954464373E+00, 1.4008714817E+01, 3.2403287080E+00, 9.6329186958E-01],
	[3.8220000000E+04, 3.0351223187E+01, 4.8954741519E+00, 1.4014694452E+01, 3.2407390978E+00, 9.6330852708E-01],
	[3.8225000000E+04, 3.0358100836E+01, 4.8955018630E+00, 1.4020675855E+01, 3.2411493835E+00, 9.6332517623E-01],
	[3.8230000000E+04, 3.0364979143E+01, 4.8955295707E+00, 1.4026659028E+01, 3.2415595651E+00, 9.6334181703E-01],
	[3.8235000000E+04, 3.0371858108E+01, 4.8955572749E+00, 1.4032643970E+01, 3.2419696426E+00, 9.6335844948E-01],
	[3.8240000000E+04, 3.0378737733E+01, 4.8955849756E+00, 1.4038630682E+01, 3.2423796161E+00, 9.6337507359E-01],
	[3.8245000000E+04, 3.0385618015E+01, 4.8956126728E+00, 1.4044619164E+01, 3.2427894855E+00, 9.6339168937E-01],
	[3.8250000000E+04, 3.0392498957E+01, 4.8956403666E+00, 1.4050609417E+01, 3.2431992509E+00, 9.6340829681E-01],
	[3.8255000000E+04, 3.0399380557E+01, 4.8956680570E+00, 1.4056601440E+01, 3.2436089124E+00, 9.6342489592E-01],
	[3.8260000000E+04, 3.0406262815E+01, 4.8956957438E+00, 1.4062595234E+01, 3.2440184698E+00, 9.6344148671E-01],
	[3.8265000000E+04, 3.0413145732E+01, 4.8957234272E+00, 1.4068590800E+01, 3.2444279233E+00, 9.6345806917E-01],
	[3.8270000000E+04, 3.0420029307E+01, 4.8957511072E+00, 1.4074588137E+01, 3.2448372729E+00, 9.6347464332E-01],
	[3.8275000000E+04, 3.0426913540E+01, 4.8957787837E+00, 1.4080587245E+01, 3.2452465185E+00, 9.6349120916E-01],
	[3.8280000000E+04, 3.0433798432E+01, 4.8958064567E+00, 1.4086588126E+01, 3.2456556602E+00, 9.6350776669E-01],
	[3.8285000000E+04, 3.0440683983E+01, 4.8958341263E+00, 1.4092590779E+01, 3.2460646980E+00, 9.6352431591E-01],
	[3.8290000000E+04, 3.0447570191E+01, 4.8958617924E+00, 1.4098595205E+01, 3.2464736320E+00, 9.6354085683E-01],
	[3.8295000000E+04, 3.0454457058E+01, 4.8958894550E+00, 1.4104601404E+01, 3.2468824621E+00, 9.6355738946E-01],
	[3.8300000000E+04, 3.0461344584E+01, 4.8959171142E+00, 1.4110609377E+01, 3.2472911884E+00, 9.6357391379E-01],
	[3.8305000000E+04, 3.0468232767E+01, 4.8959447700E+00, 1.4116619122E+01, 3.2476998109E+00, 9.6359042984E-01],
	[3.8310000000E+04, 3.0475121609E+01, 4.8959724223E+00, 1.4122630642E+01, 3.2481083295E+00, 9.6360693760E-01],
	[3.8315000000E+04, 3.0482011109E+01, 4.8960000711E+00, 1.4128643936E+01, 3.2485167444E+00, 9.6362343708E-01],
	[3.8320000000E+04, 3.0488901267E+01, 4.8960277165E+00, 1.4134659004E+01, 3.2489250556E+00, 9.6363992829E-01],
	[3.8325000000E+04, 3.0495792084E+01, 4.8960553585E+00, 1.4140675847E+01, 3.2493332630E+00, 9.6365641122E-01],
	[3.8330000000E+04, 3.0502683558E+01, 4.8960829970E+00, 1.4146694465E+01, 3.2497413666E+00, 9.6367288588E-01],
	[3.8335000000E+04, 3.0509575691E+01, 4.8961106320E+00, 1.4152714859E+01, 3.2501493666E+00, 9.6368935229E-01],
	[3.8340000000E+04, 3.0516468482E+01, 4.8961382636E+00, 1.4158737028E+01, 3.2505572629E+00, 9.6370581043E-01],
	[3.8345000000E+04, 3.0523361930E+01, 4.8961658917E+00, 1.4164760973E+01, 3.2509650555E+00, 9.6372226032E-01],
	[3.8350000000E+04, 3.0530256037E+01, 4.8961935164E+00, 1.4170786694E+01, 3.2513727445E+00, 9.6373870195E-01],
	[3.8355000000E+04, 3.0537150802E+01, 4.8962211377E+00, 1.4176814191E+01, 3.2517803299E+00, 9.6375513534E-01],
	[3.8360000000E+04, 3.0544046225E+01, 4.8962487555E+00, 1.4182843466E+01, 3.2521878116E+00, 9.6377156049E-01],
	[3.8365000000E+04, 3.0550942306E+01, 4.8962763699E+00, 1.4188874517E+01, 3.2525951898E+00, 9.6378797739E-01],
	[3.8370000000E+04, 3.0557839045E+01, 4.8963039808E+00, 1.4194907346E+01, 3.2530024643E+00, 9.6380438606E-01],
	[3.8375000000E+04, 3.0564736442E+01, 4.8963315883E+00, 1.4200941953E+01, 3.2534096354E+00, 9.6382078650E-01],
	[3.8380000000E+04, 3.0571634497E+01, 4.8963591923E+00, 1.4206978337E+01, 3.2538167029E+00, 9.6383717872E-01],
	[3.8385000000E+04, 3.0578533210E+01, 4.8963867929E+00, 1.4213016500E+01, 3.2542236668E+00, 9.6385356271E-01],
	[3.8390000000E+04, 3.0585432580E+01, 4.8964143900E+00, 1.4219056441E+01, 3.2546305273E+00, 9.6386993848E-01],
	[3.8395000000E+04, 3.0592332609E+01, 4.8964419838E+00, 1.4225098161E+01, 3.2550372843E+00, 9.6388630604E-01],
	[3.8400000000E+04, 3.0599233295E+01, 4.8964695740E+00, 1.4231141660E+01, 3.2554439379E+00, 9.6390266538E-01],
	[3.8405000000E+04, 3.0606134639E+01, 4.8964971609E+00, 1.4237186939E+01, 3.2558504880E+00, 9.6391901653E-01],
	[3.8410000000E+04, 3.0613036641E+01, 4.8965247443E+00, 1.4243233997E+01, 3.2562569346E+00, 9.6393535946E-01],
	[3.8415000000E+04, 3.0619939301E+01, 4.8965523243E+00, 1.4249282835E+01, 3.2566632779E+00, 9.6395169420E-01],
	[3.8420000000E+04, 3.0626842618E+01, 4.8965799008E+00, 1.4255333454E+01, 3.2570695178E+00, 9.6396802075E-01],
	[3.8425000000E+04, 3.0633746593E+01, 4.8966074739E+00, 1.4261385853E+01, 3.2574756543E+00, 9.6398433911E-01],
	[3.8430000000E+04, 3.0640651226E+01, 4.8966350436E+00, 1.4267440033E+01, 3.2578816875E+00, 9.6400064928E-01],
	[3.8435000000E+04, 3.0647556516E+01, 4.8966626098E+00, 1.4273495994E+01, 3.2582876173E+00, 9.6401695127E-01],
	[3.8440000000E+04, 3.0654462464E+01, 4.8966901726E+00, 1.4279553737E+01, 3.2586934439E+00, 9.6403324508E-01],
	[3.8445000000E+04, 3.0661369070E+01, 4.8967177320E+00, 1.4285613261E+01, 3.2590991671E+00, 9.6404953071E-01],
	[3.8450000000E+04, 3.0668276334E+01, 4.8967452880E+00, 1.4291674568E+01, 3.2595047871E+00, 9.6406580818E-01],
	[3.8455000000E+04, 3.0675184254E+01, 4.8967728405E+00, 1.4297737657E+01, 3.2599103038E+00, 9.6408207748E-01],
	[3.8460000000E+04, 3.0682092833E+01, 4.8968003896E+00, 1.4303802528E+01, 3.2603157173E+00, 9.6409833862E-01],
	[3.8465000000E+04, 3.0689002069E+01, 4.8968279353E+00, 1.4309869182E+01, 3.2607210275E+00, 9.6411459161E-01],
	[3.8470000000E+04, 3.0695911963E+01, 4.8968554775E+00, 1.4315937620E+01, 3.2611262346E+00, 9.6413083644E-01],
	[3.8475000000E+04, 3.0702822514E+01, 4.8968830163E+00, 1.4322007841E+01, 3.2615313385E+00, 9.6414707312E-01],
	[3.8480000000E+04, 3.0709733722E+01, 4.8969105517E+00, 1.4328079845E+01, 3.2619363392E+00, 9.6416330165E-01],
	[3.8485000000E+04, 3.0716645588E+01, 4.8969380837E+00, 1.4334153634E+01, 3.2623412368E+00, 9.6417952205E-01],
	[3.8490000000E+04, 3.0723558111E+01, 4.8969656123E+00, 1.4340229208E+01, 3.2627460313E+00, 9.6419573431E-01],
	[3.8495000000E+04, 3.0730471292E+01, 4.8969931374E+00, 1.4346306565E+01, 3.2631507227E+00, 9.6421193843E-01],
	[3.8500000000E+04, 3.0737385130E+01, 4.8970206591E+00, 1.4352385708E+01, 3.2635553109E+00, 9.6422813443E-01],
	[3.8505000000E+04, 3.0744299626E+01, 4.8970481774E+00, 1.4358466636E+01, 3.2639597961E+00, 9.6424432230E-01],
	[3.8510000000E+04, 3.0751214778E+01, 4.8970756923E+00, 1.4364549350E+01, 3.2643641783E+00, 9.6426050205E-01],
	[3.8515000000E+04, 3.0758130589E+01, 4.8971032037E+00, 1.4370633849E+01, 3.2647684575E+00, 9.6427667369E-01],
	[3.8520000000E+04, 3.0765047056E+01, 4.8971307118E+00, 1.4376720135E+01, 3.2651726336E+00, 9.6429283721E-01],
	[3.8525000000E+04, 3.0771964181E+01, 4.8971582164E+00, 1.4382808207E+01, 3.2655767067E+00, 9.6430899262E-01],
	[3.8530000000E+04, 3.0778881962E+01, 4.8971857176E+00, 1.4388898066E+01, 3.2659806769E+00, 9.6432513993E-01],
	[3.8535000000E+04, 3.0785800402E+01, 4.8972132154E+00, 1.4394989711E+01, 3.2663845441E+00, 9.6434127914E-01],
	[3.8540000000E+04, 3.0792719498E+01, 4.8972407098E+00, 1.4401083144E+01, 3.2667883084E+00, 9.6435741026E-01],
	[3.8545000000E+04, 3.0799639251E+01, 4.8972682007E+00, 1.4407178365E+01, 3.2671919698E+00, 9.6437353328E-01],
	[3.8550000000E+04, 3.0806559662E+01, 4.8972956883E+00, 1.4413275373E+01, 3.2675955282E+00, 9.6438964821E-01],
	[3.8555000000E+04, 3.0813480730E+01, 4.8973231725E+00, 1.4419374170E+01, 3.2679989838E+00, 9.6440575506E-01],
	[3.8560000000E+04, 3.0820402455E+01, 4.8973506532E+00, 1.4425474755E+01, 3.2684023366E+00, 9.6442185383E-01],
	[3.8565000000E+04, 3.0827324836E+01, 4.8973781305E+00, 1.4431577129E+01, 3.2688055865E+00, 9.6443794453E-01],
	[3.8570000000E+04, 3.0834247875E+01, 4.8974056044E+00, 1.4437681292E+01, 3.2692087336E+00, 9.6445402715E-01],
	[3.8575000000E+04, 3.0841171571E+01, 4.8974330749E+00, 1.4443787244E+01, 3.2696117778E+00, 9.6447010171E-01],
	[3.8580000000E+04, 3.0848095924E+01, 4.8974605421E+00, 1.4449894986E+01, 3.2700147193E+00, 9.6448616820E-01],
	[3.8585000000E+04, 3.0855020934E+01, 4.8974880058E+00, 1.4456004518E+01, 3.2704175581E+00, 9.6450222663E-01],
	[3.8590000000E+04, 3.0861946601E+01, 4.8975154660E+00, 1.4462115840E+01, 3.2708202941E+00, 9.6451827701E-01],
	[3.8595000000E+04, 3.0868872925E+01, 4.8975429229E+00, 1.4468228952E+01, 3.2712229273E+00, 9.6453431934E-01],
	[3.8600000000E+04, 3.0875799906E+01, 4.8975703764E+00, 1.4474343856E+01, 3.2716254579E+00, 9.6455035362E-01],
	[3.8605000000E+04, 3.0882727544E+01, 4.8975978265E+00, 1.4480460550E+01, 3.2720278858E+00, 9.6456637986E-01],
	[3.8610000000E+04, 3.0889655838E+01, 4.8976252732E+00, 1.4486579036E+01, 3.2724302110E+00, 9.6458239805E-01],
	[3.8615000000E+04, 3.0896584790E+01, 4.8976527165E+00, 1.4492699313E+01, 3.2728324336E+00, 9.6459840822E-01],
	[3.8620000000E+04, 3.0903531106E+01, 4.8976822595E+00, 1.4498821383E+01, 3.2732356803E+00, 9.6461441035E-01],
	[3.8625000000E+04, 3.0910478360E+01, 4.8977118336E+00, 1.4504945244E+01, 3.2736388434E+00, 9.6463040446E-01],
	[3.8630000000E+04, 3.0917426277E+01, 4.8977414040E+00, 1.4511070898E+01, 3.2740419041E+00, 9.6464639054E-01],
	[3.8635000000E+04, 3.0924374855E+01, 4.8977709708E+00, 1.4517198346E+01, 3.2744448627E+00, 9.6466236860E-01],
	[3.8640000000E+04, 3.0931324096E+01, 4.8978005339E+00, 1.4523327586E+01, 3.2748477190E+00, 9.6467833865E-01],
	[3.8645000000E+04, 3.0938273999E+01, 4.8978300934E+00, 1.4529458619E+01, 3.2752504730E+00, 9.6469430069E-01],
	[3.8650000000E+04, 3.0945224564E+01, 4.8978596492E+00, 1.4535591447E+01, 3.2756531249E+00, 9.6471025473E-01],
	[3.8655000000E+04, 3.0952175792E+01, 4.8978892014E+00, 1.4541726068E+01, 3.2760556746E+00, 9.6472620076E-01],
	[3.8660000000E+04, 3.0959127681E+01, 4.8979187500E+00, 1.4547862484E+01, 3.2764581222E+00, 9.6474213879E-01],
	[3.8665000000E+04, 3.0966080232E+01, 4.8979482949E+00, 1.4554000694E+01, 3.2768604676E+00, 9.6475806883E-01],
	[3.8670000000E+04, 3.0973033446E+01, 4.8979778362E+00, 1.4560140699E+01, 3.2772627108E+00, 9.6477399088E-01],
	[3.8675000000E+04, 3.0979987321E+01, 4.8980073738E+00, 1.4566282499E+01, 3.2776648520E+00, 9.6478990494E-01],
	[3.8680000000E+04, 3.0986941858E+01, 4.8980369078E+00, 1.4572426095E+01, 3.2780668911E+00, 9.6480581102E-01],
	[3.8685000000E+04, 3.0993897058E+01, 4.8980664381E+00, 1.4578571487E+01, 3.2784688281E+00, 9.6482170913E-01],
	[3.8690000000E+04, 3.1000852919E+01, 4.8980959648E+00, 1.4584718674E+01, 3.2788706631E+00, 9.6483759926E-01],
	[3.8695000000E+04, 3.1007809442E+01, 4.8981254879E+00, 1.4590867658E+01, 3.2792723961E+00, 9.6485348142E-01],
	[3.8700000000E+04, 3.1014766627E+01, 4.8981550073E+00, 1.4597018439E+01, 3.2796740270E+00, 9.6486935561E-01],
	[3.8705000000E+04, 3.1021724474E+01, 4.8981845231E+00, 1.4603171017E+01, 3.2800755560E+00, 9.6488522184E-01],
	[3.8710000000E+04, 3.1028682983E+01, 4.8982140353E+00, 1.4609325391E+01, 3.2804769830E+00, 9.6490108012E-01],
	[3.8715000000E+04, 3.1035642153E+01, 4.8982435438E+00, 1.4615481564E+01, 3.2808783080E+00, 9.6491693044E-01],
	[3.8720000000E+04, 3.1042601986E+01, 4.8982730487E+00, 1.4621639534E+01, 3.2812795311E+00, 9.6493277281E-01],
	[3.8725000000E+04, 3.1049562480E+01, 4.8983025500E+00, 1.4627799302E+01, 3.2816806523E+00, 9.6494860724E-01],
	[3.8730000000E+04, 3.1056523636E+01, 4.8983320476E+00, 1.4633960869E+01, 3.2820816716E+00, 9.6496443373E-01],
	[3.8735000000E+04, 3.1063485453E+01, 4.8983615416E+00, 1.4640124234E+01, 3.2824825891E+00, 9.6498025228E-01],
	[3.8740000000E+04, 3.1070447933E+01, 4.8983910320E+00, 1.4646289398E+01, 3.2828834046E+00, 9.6499606289E-01],
	[3.8745000000E+04, 3.1077411074E+01, 4.8984205187E+00, 1.4652456362E+01, 3.2832841184E+00, 9.6501186558E-01],
	[3.8750000000E+04, 3.1084374877E+01, 4.8984500018E+00, 1.4658625125E+01, 3.2836847303E+00, 9.6502766034E-01],
	[3.8755000000E+04, 3.1091339341E+01, 4.8984794813E+00, 1.4664795688E+01, 3.2840852404E+00, 9.6504344718E-01],
	[3.8760000000E+04, 3.1098304467E+01, 4.8985089572E+00, 1.4670968051E+01, 3.2844856488E+00, 9.6505922611E-01],
	[3.8765000000E+04, 3.1105270255E+01, 4.8985384294E+00, 1.4677142215E+01, 3.2848859553E+00, 9.6507499712E-01],
	[3.8770000000E+04, 3.1112236704E+01, 4.8985678980E+00, 1.4683318179E+01, 3.2852861602E+00, 9.6509076022E-01],
	[3.8775000000E+04, 3.1119203814E+01, 4.8985973630E+00, 1.4689495944E+01, 3.2856862633E+00, 9.6510651542E-01],
	[3.8780000000E+04, 3.1126171587E+01, 4.8986268244E+00, 1.4695675511E+01, 3.2860862647E+00, 9.6512226272E-01],
	[3.8785000000E+04, 3.1133140021E+01, 4.8986562821E+00, 1.4701856879E+01, 3.2864861645E+00, 9.6513800212E-01],
	[3.8790000000E+04, 3.1140109116E+01, 4.8986857363E+00, 1.4708040050E+01, 3.2868859625E+00, 9.6515373363E-01],
	[3.8795000000E+04, 3.1147078873E+01, 4.8987151868E+00, 1.4714225022E+01, 3.2872856590E+00, 9.6516945725E-01],
	[3.8800000000E+04, 3.1154049291E+01, 4.8987446337E+00, 1.4720411797E+01, 3.2876852538E+00, 9.6518517298E-01],
	[3.8805000000E+04, 3.1161020370E+01, 4.8987740769E+00, 1.4726600375E+01, 3.2880847470E+00, 9.6520088084E-01],
	[3.8810000000E+04, 3.1167992111E+01, 4.8988035166E+00, 1.4732790755E+01, 3.2884841386E+00, 9.6521658082E-01],
	[3.8815000000E+04, 3.1174964514E+01, 4.8988329526E+00, 1.4738982940E+01, 3.2888834286E+00, 9.6523227293E-01],
	[3.8820000000E+04, 3.1181937577E+01, 4.8988623851E+00, 1.4745176927E+01, 3.2892826171E+00, 9.6524795717E-01],
	[3.8825000000E+04, 3.1188911302E+01, 4.8988918139E+00, 1.4751372719E+01, 3.2896817041E+00, 9.6526363354E-01],
	[3.8830000000E+04, 3.1195885689E+01, 4.8989212391E+00, 1.4757570315E+01, 3.2900806895E+00, 9.6527930206E-01],
	[3.8835000000E+04, 3.1202860736E+01, 4.8989506607E+00, 1.4763769716E+01, 3.2904795735E+00, 9.6529496272E-01],
	[3.8840000000E+04, 3.1209836445E+01, 4.8989800786E+00, 1.4769970921E+01, 3.2908783560E+00, 9.6531061552E-01],
	[3.8845000000E+04, 3.1216812815E+01, 4.8990094930E+00, 1.4776173932E+01, 3.2912770370E+00, 9.6532626048E-01],
	[3.8850000000E+04, 3.1223789847E+01, 4.8990389038E+00, 1.4782378747E+01, 3.2916756166E+00, 9.6534189760E-01],
	[3.8855000000E+04, 3.1230767539E+01, 4.8990683109E+00, 1.4788585369E+01, 3.2920740948E+00, 9.6535752688E-01],
	[3.8860000000E+04, 3.1237745893E+01, 4.8990977144E+00, 1.4794793797E+01, 3.2924724716E+00, 9.6537314832E-01],
	[3.8865000000E+04, 3.1244724908E+01, 4.8991271144E+00, 1.4801004031E+01, 3.2928707470E+00, 9.6538876193E-01],
	[3.8870000000E+04, 3.1251704584E+01, 4.8991565107E+00, 1.4807216071E+01, 3.2932689210E+00, 9.6540436771E-01],
	[3.8875000000E+04, 3.1258684921E+01, 4.8991859034E+00, 1.4813429919E+01, 3.2936669938E+00, 9.6541996567E-01],
	[3.8880000000E+04, 3.1265665919E+01, 4.8992152925E+00, 1.4819645573E+01, 3.2940649652E+00, 9.6543555580E-01],
	[3.8885000000E+04, 3.1272647578E+01, 4.8992446781E+00, 1.4825863035E+01, 3.2944628353E+00, 9.6545113813E-01],
	[3.8890000000E+04, 3.1279629899E+01, 4.8992740600E+00, 1.4832082305E+01, 3.2948606041E+00, 9.6546671264E-01],
	[3.8895000000E+04, 3.1286612880E+01, 4.8993034383E+00, 1.4838303383E+01, 3.2952582716E+00, 9.6548227934E-01],
	[3.8900000000E+04, 3.1293596522E+01, 4.8993328130E+00, 1.4844526269E+01, 3.2956558380E+00, 9.6549783824E-01],
	[3.8905000000E+04, 3.1300580825E+01, 4.8993621841E+00, 1.4850750964E+01, 3.2960533031E+00, 9.6551338934E-01],
	[3.8910000000E+04, 3.1307565790E+01, 4.8993915516E+00, 1.4856977468E+01, 3.2964506669E+00, 9.6552893265E-01],
	[3.8915000000E+04, 3.1314551415E+01, 4.8994209156E+00, 1.4863205781E+01, 3.2968479297E+00, 9.6554446817E-01],
	[3.8920000000E+04, 3.1321537701E+01, 4.8994502759E+00, 1.4869435903E+01, 3.2972450912E+00, 9.6555999589E-01],
	[3.8925000000E+04, 3.1328524648E+01, 4.8994796326E+00, 1.4875667836E+01, 3.2976421516E+00, 9.6557551584E-01],
	[3.8930000000E+04, 3.1335512255E+01, 4.8995089857E+00, 1.4881901578E+01, 3.2980391109E+00, 9.6559102801E-01],
	[3.8935000000E+04, 3.1342500524E+01, 4.8995383353E+00, 1.4888137131E+01, 3.2984359691E+00, 9.6560653240E-01],
	[3.8940000000E+04, 3.1349489454E+01, 4.8995676812E+00, 1.4894374494E+01, 3.2988327262E+00, 9.6562202902E-01],
	[3.8945000000E+04, 3.1356479044E+01, 4.8995970236E+00, 1.4900613669E+01, 3.2992293822E+00, 9.6563751787E-01],
	[3.8950000000E+04, 3.1363469295E+01, 4.8996263623E+00, 1.4906854655E+01, 3.2996259371E+00, 9.6565299896E-01],
	[3.8955000000E+04, 3.1370460206E+01, 4.8996556975E+00, 1.4913097452E+01, 3.3000223911E+00, 9.6566847229E-01],
	[3.8960000000E+04, 3.1377451779E+01, 4.8996850291E+00, 1.4919342061E+01, 3.3004187440E+00, 9.6568393787E-01],
	[3.8965000000E+04, 3.1384444012E+01, 4.8997143571E+00, 1.4925588483E+01, 3.3008149960E+00, 9.6569939569E-01],
	[3.8970000000E+04, 3.1391436906E+01, 4.8997436815E+00, 1.4931836716E+01, 3.3012111469E+00, 9.6571484577E-01],
	[3.8975000000E+04, 3.1398430460E+01, 4.8997730023E+00, 1.4938086763E+01, 3.3016071970E+00, 9.6573028811E-01],
	[3.8980000000E+04, 3.1405424676E+01, 4.8998023195E+00, 1.4944338623E+01, 3.3020031461E+00, 9.6574572271E-01],
	[3.8985000000E+04, 3.1412419551E+01, 4.8998316332E+00, 1.4950592295E+01, 3.3023989943E+00, 9.6576114957E-01],
	[3.8990000000E+04, 3.1419415088E+01, 4.8998609432E+00, 1.4956847782E+01, 3.3027947415E+00, 9.6577656870E-01],
	[3.8995000000E+04, 3.1426411285E+01, 4.8998902497E+00, 1.4963105082E+01, 3.3031903880E+00, 9.6579198011E-01],
	[3.9000000000E+04, 3.1433408142E+01, 4.8999195526E+00, 1.4969364197E+01, 3.3035859335E+00, 9.6580738379E-01],
	[3.9005000000E+04, 3.1440405660E+01, 4.8999488519E+00, 1.4975625126E+01, 3.3039813783E+00, 9.6582277976E-01],
	[3.9010000000E+04, 3.1447403838E+01, 4.8999781477E+00, 1.4981887870E+01, 3.3043767222E+00, 9.6583816801E-01],
	[3.9015000000E+04, 3.1454402677E+01, 4.9000074398E+00, 1.4988152429E+01, 3.3047719653E+00, 9.6585354855E-01],
	[3.9020000000E+04, 3.1461402177E+01, 4.9000367284E+00, 1.4994418803E+01, 3.3051671076E+00, 9.6586892138E-01],
	[3.9025000000E+04, 3.1468402337E+01, 4.9000660134E+00, 1.5000686993E+01, 3.3055621492E+00, 9.6588428652E-01],
	[3.9030000000E+04, 3.1475403157E+01, 4.9000952948E+00, 1.5006956999E+01, 3.3059570901E+00, 9.6589964395E-01],
	[3.9035000000E+04, 3.1482404637E+01, 4.9001245727E+00, 1.5013228822E+01, 3.3063519302E+00, 9.6591499369E-01],
	[3.9040000000E+04, 3.1489406779E+01, 4.9001538469E+00, 1.5019502460E+01, 3.3067466696E+00, 9.6593033574E-01],
	[3.9045000000E+04, 3.1496409580E+01, 4.9001831176E+00, 1.5025777916E+01, 3.3071413084E+00, 9.6594567010E-01],
	[3.9050000000E+04, 3.1503413042E+01, 4.9002123848E+00, 1.5032055189E+01, 3.3075358465E+00, 9.6596099678E-01],
	[3.9055000000E+04, 3.1510417164E+01, 4.9002416483E+00, 1.5038334279E+01, 3.3079302840E+00, 9.6597631578E-01],
	[3.9060000000E+04, 3.1517421946E+01, 4.9002709083E+00, 1.5044615187E+01, 3.3083246208E+00, 9.6599162711E-01],
	[3.9065000000E+04, 3.1524427388E+01, 4.9003001647E+00, 1.5050897913E+01, 3.3087188571E+00, 9.6600693076E-01],
	[3.9070000000E+04, 3.1531433491E+01, 4.9003294176E+00, 1.5057182457E+01, 3.3091129927E+00, 9.6602222675E-01],
	[3.9075000000E+04, 3.1538440254E+01, 4.9003586668E+00, 1.5063468820E+01, 3.3095070278E+00, 9.6603751508E-01],
	[3.9080000000E+04, 3.1545447677E+01, 4.9003879125E+00, 1.5069757002E+01, 3.3099009624E+00, 9.6605279575E-01],
	[3.9085000000E+04, 3.1552455760E+01, 4.9004171547E+00, 1.5076047003E+01, 3.3102947964E+00, 9.6606806877E-01],
	[3.9090000000E+04, 3.1559464504E+01, 4.9004463932E+00, 1.5082338823E+01, 3.3106885300E+00, 9.6608333414E-01],
	[3.9095000000E+04, 3.1566473907E+01, 4.9004756282E+00, 1.5088632463E+01, 3.3110821630E+00, 9.6609859186E-01],
	[3.9100000000E+04, 3.1573483971E+01, 4.9005048597E+00, 1.5094927923E+01, 3.3114756956E+00, 9.6611384194E-01],
	[3.9105000000E+04, 3.1580494695E+01, 4.9005340876E+00, 1.5101225204E+01, 3.3118691277E+00, 9.6612908438E-01],
	[3.9110000000E+04, 3.1587506079E+01, 4.9005633119E+00, 1.5107524305E+01, 3.3122624595E+00, 9.6614431918E-01],
	[3.9115000000E+04, 3.1594518123E+01, 4.9005925326E+00, 1.5113825227E+01, 3.3126556908E+00, 9.6615954636E-01],
	[3.9120000000E+04, 3.1601530826E+01, 4.9006217498E+00, 1.5120127971E+01, 3.3130488217E+00, 9.6617476591E-01],
	[3.9125000000E+04, 3.1608544190E+01, 4.9006509635E+00, 1.5126432536E+01, 3.3134418523E+00, 9.6618997784E-01],
	[3.9130000000E+04, 3.1615558214E+01, 4.9006801735E+00, 1.5132738923E+01, 3.3138347825E+00, 9.6620518215E-01],
	[3.9135000000E+04, 3.1622572898E+01, 4.9007093800E+00, 1.5139047131E+01, 3.3142276124E+00, 9.6622037885E-01],
	[3.9140000000E+04, 3.1629588241E+01, 4.9007385830E+00, 1.5145357163E+01, 3.3146203420E+00, 9.6623556793E-01],
	[3.9145000000E+04, 3.1636604245E+01, 4.9007677824E+00, 1.5151669017E+01, 3.3150129713E+00, 9.6625074941E-01],
	[3.9150000000E+04, 3.1643620909E+01, 4.9007969782E+00, 1.5157982694E+01, 3.3154055004E+00, 9.6626592329E-01],
	[3.9155000000E+04, 3.1650638232E+01, 4.9008261705E+00, 1.5164298194E+01, 3.3157979292E+00, 9.6628108957E-01],
	[3.9160000000E+04, 3.1657656215E+01, 4.9008553593E+00, 1.5170615518E+01, 3.3161902577E+00, 9.6629624826E-01],
	[3.9165000000E+04, 3.1664674858E+01, 4.9008845445E+00, 1.5176934666E+01, 3.3165824861E+00, 9.6631139935E-01],
	[3.9170000000E+04, 3.1671694161E+01, 4.9009137261E+00, 1.5183255637E+01, 3.3169746143E+00, 9.6632654287E-01],
	[3.9175000000E+04, 3.1678714123E+01, 4.9009429042E+00, 1.5189578434E+01, 3.3173666423E+00, 9.6634167879E-01],
	[3.9180000000E+04, 3.1685734745E+01, 4.9009720787E+00, 1.5195903055E+01, 3.3177585701E+00, 9.6635680715E-01],
	[3.9185000000E+04, 3.1692756027E+01, 4.9010012497E+00, 1.5202229501E+01, 3.3181503978E+00, 9.6637192792E-01],
	[3.9190000000E+04, 3.1699777969E+01, 4.9010304171E+00, 1.5208557773E+01, 3.3185421255E+00, 9.6638704113E-01],
	[3.9195000000E+04, 3.1706800570E+01, 4.9010595810E+00, 1.5214887870E+01, 3.3189337530E+00, 9.6640214677E-01],
	[3.9200000000E+04, 3.1713823831E+01, 4.9010887414E+00, 1.5221219793E+01, 3.3193252804E+00, 9.6641724485E-01],
	[3.9205000000E+04, 3.1720847752E+01, 4.9011178982E+00, 1.5227553542E+01, 3.3197167078E+00, 9.6643233537E-01],
	[3.9210000000E+04, 3.1727872332E+01, 4.9011470514E+00, 1.5233889118E+01, 3.3201080352E+00, 9.6644741834E-01],
	[3.9215000000E+04, 3.1734897572E+01, 4.9011762011E+00, 1.5240226521E+01, 3.3204992626E+00, 9.6646249376E-01],
	[3.9220000000E+04, 3.1741923471E+01, 4.9012053473E+00, 1.5246565750E+01, 3.3208903900E+00, 9.6647756163E-01],
	[3.9225000000E+04, 3.1748950030E+01, 4.9012344899E+00, 1.5252906808E+01, 3.3212814174E+00, 9.6649262196E-01],
	[3.9230000000E+04, 3.1755977249E+01, 4.9012636290E+00, 1.5259249692E+01, 3.3216723448E+00, 9.6650767475E-01],
	[3.9235000000E+04, 3.1763005127E+01, 4.9012927645E+00, 1.5265594405E+01, 3.3220631723E+00, 9.6652272001E-01],
	[3.9240000000E+04, 3.1770044628E+01, 4.9013232639E+00, 1.5271940946E+01, 3.3224546482E+00, 9.6653775773E-01],
	[3.9245000000E+04, 3.1777090601E+01, 4.9013544840E+00, 1.5278289316E+01, 3.3228464208E+00, 9.6655278794E-01],
	[3.9250000000E+04, 3.1784137239E+01, 4.9013857002E+00, 1.5284639514E+01, 3.3232380938E+00, 9.6656781061E-01],
	[3.9255000000E+04, 3.1791184542E+01, 4.9014169127E+00, 1.5290991542E+01, 3.3236296672E+00, 9.6658282578E-01],
	[3.9260000000E+04, 3.1798232509E+01, 4.9014481214E+00, 1.5297345399E+01, 3.3240211412E+00, 9.6659783342E-01],
	[3.9265000000E+04, 3.1805281141E+01, 4.9014793264E+00, 1.5303701086E+01, 3.3244125156E+00, 9.6661283356E-01],
	[3.9270000000E+04, 3.1812330437E+01, 4.9015105275E+00, 1.5310058603E+01, 3.3248037905E+00, 9.6662782619E-01],
	[3.9275000000E+04, 3.1819380399E+01, 4.9015417249E+00, 1.5316417950E+01, 3.3251949659E+00, 9.6664281132E-01],
	[3.9280000000E+04, 3.1826431024E+01, 4.9015729185E+00, 1.5322779128E+01, 3.3255860419E+00, 9.6665778895E-01],
	[3.9285000000E+04, 3.1833482315E+01, 4.9016041084E+00, 1.5329142137E+01, 3.3259770185E+00, 9.6667275909E-01],
	[3.9290000000E+04, 3.1840534269E+01, 4.9016352944E+00, 1.5335506977E+01, 3.3263678956E+00, 9.6668772174E-01],
	[3.9295000000E+04, 3.1847586889E+01, 4.9016664767E+00, 1.5341873648E+01, 3.3267586734E+00, 9.6670267690E-01],
	[3.9300000000E+04, 3.1854640173E+01, 4.9016976553E+00, 1.5348242151E+01, 3.3271493517E+00, 9.6671762458E-01],
	[3.9305000000E+04, 3.1861694121E+01, 4.9017288300E+00, 1.5354612487E+01, 3.3275399307E+00, 9.6673256478E-01],
	[3.9310000000E+04, 3.1868748734E+01, 4.9017600010E+00, 1.5360984655E+01, 3.3279304104E+00, 9.6674749751E-01],
	[3.9315000000E+04, 3.1875804011E+01, 4.9017911683E+00, 1.5367358655E+01, 3.3283207908E+00, 9.6676242276E-01],
	[3.9320000000E+04, 3.1882859953E+01, 4.9018223317E+00, 1.5373734488E+01, 3.3287110718E+00, 9.6677734055E-01],
	[3.9325000000E+04, 3.1889916559E+01, 4.9018534914E+00, 1.5380112155E+01, 3.3291012536E+00, 9.6679225088E-01],
	[3.9330000000E+04, 3.1896973829E+01, 4.9018846474E+00, 1.5386491655E+01, 3.3294913361E+00, 9.6680715375E-01],
	[3.9335000000E+04, 3.1904031764E+01, 4.9019157995E+00, 1.5392872989E+01, 3.3298813194E+00, 9.6682204917E-01],
	[3.9340000000E+04, 3.1911090363E+01, 4.9019469479E+00, 1.5399256158E+01, 3.3302712035E+00, 9.6683693713E-01],
	[3.9345000000E+04, 3.1918149627E+01, 4.9019780926E+00, 1.5405641160E+01, 3.3306609884E+00, 9.6685181765E-01],
	[3.9350000000E+04, 3.1925209555E+01, 4.9020092335E+00, 1.5412027998E+01, 3.3310506740E+00, 9.6686669073E-01],
	[3.9355000000E+04, 3.1932270147E+01, 4.9020403706E+00, 1.5418416670E+01, 3.3314402606E+00, 9.6688155636E-01],
	[3.9360000000E+04, 3.1939331403E+01, 4.9020715040E+00, 1.5424807178E+01, 3.3318297480E+00, 9.6689641457E-01],
	[3.9365000000E+04, 3.1946393323E+01, 4.9021026336E+00, 1.5431199521E+01, 3.3322191362E+00, 9.6691126534E-01],
	[3.9370000000E+04, 3.1953455908E+01, 4.9021337595E+00, 1.5437593701E+01, 3.3326084254E+00, 9.6692610869E-01],
	[3.9375000000E+04, 3.1960519157E+01, 4.9021648816E+00, 1.5443989716E+01, 3.3329976155E+00, 9.6694094461E-01],
	[3.9380000000E+04, 3.1967583070E+01, 4.9021959999E+00, 1.5450387568E+01, 3.3333867066E+00, 9.6695577312E-01],
	[3.9385000000E+04, 3.1974647647E+01, 4.9022271145E+00, 1.5456787257E+01, 3.3337756985E+00, 9.6697059421E-01],
	[3.9390000000E+04, 3.1981712888E+01, 4.9022582254E+00, 1.5463188783E+01, 3.3341645915E+00, 9.6698540789E-01],
	[3.9395000000E+04, 3.1988778794E+01, 4.9022893325E+00, 1.5469592146E+01, 3.3345533855E+00, 9.6700021416E-01],
	[3.9400000000E+04, 3.1995845363E+01, 4.9023204358E+00, 1.5475997347E+01, 3.3349420805E+00, 9.6701501303E-01],
	[3.9405000000E+04, 3.2002912597E+01, 4.9023515354E+00, 1.5482404386E+01, 3.3353306765E+00, 9.6702980450E-01],
	[3.9410000000E+04, 3.2009980494E+01, 4.9023826312E+00, 1.5488813263E+01, 3.3357191736E+00, 9.6704458858E-01],
	[3.9415000000E+04, 3.2017049056E+01, 4.9024137233E+00, 1.5495223978E+01, 3.3361075718E+00, 9.6705936526E-01],
	[3.9420000000E+04, 3.2024118281E+01, 4.9024448117E+00, 1.5501636533E+01, 3.3364958710E+00, 9.6707413456E-01],
	[3.9425000000E+04, 3.2031188171E+01, 4.9024758963E+00, 1.5508050927E+01, 3.3368840714E+00, 9.6708889648E-01],
	[3.9430000000E+04, 3.2038258724E+01, 4.9025069772E+00, 1.5514467160E+01, 3.3372721729E+00, 9.6710365102E-01],
	[3.9435000000E+04, 3.2045329941E+01, 4.9025380543E+00, 1.5520885232E+01, 3.3376601756E+00, 9.6711839818E-01],
	[3.9440000000E+04, 3.2052401822E+01, 4.9025691276E+00, 1.5527305145E+01, 3.3380480795E+00, 9.6713313797E-01],
	[3.9445000000E+04, 3.2059474368E+01, 4.9026001973E+00, 1.5533726898E+01, 3.3384358845E+00, 9.6714787039E-01],
	[3.9450000000E+04, 3.2066547576E+01, 4.9026312632E+00, 1.5540150492E+01, 3.3388235908E+00, 9.6716259545E-01],
	[3.9455000000E+04, 3.2073621449E+01, 4.9026623253E+00, 1.5546575927E+01, 3.3392111983E+00, 9.6717731315E-01],
	[3.9460000000E+04, 3.2080695986E+01, 4.9026933837E+00, 1.5553003203E+01, 3.3395987071E+00, 9.6719202350E-01],
	[3.9465000000E+04, 3.2087771186E+01, 4.9027244384E+00, 1.5559432320E+01, 3.3399861171E+00, 9.6720672649E-01],
	[3.9470000000E+04, 3.2094847050E+01, 4.9027554893E+00, 1.5565863279E+01, 3.3403734285E+00, 9.6722142214E-01],
	[3.9475000000E+04, 3.2101923578E+01, 4.9027865365E+00, 1.5572296080E+01, 3.3407606411E+00, 9.6723611044E-01],
	[3.9480000000E+04, 3.2109000770E+01, 4.9028175800E+00, 1.5578730724E+01, 3.3411477551E+00, 9.6725079141E-01],
	[3.9485000000E+04, 3.2116078625E+01, 4.9028486197E+00, 1.5585167210E+01, 3.3415347705E+00, 9.6726546504E-01],
	[3.9490000000E+04, 3.2123157144E+01, 4.9028796557E+00, 1.5591605539E+01, 3.3419216872E+00, 9.6728013133E-01],
	[3.9495000000E+04, 3.2130236326E+01, 4.9029106880E+00, 1.5598045712E+01, 3.3423085053E+00, 9.6729479030E-01],
	[3.9500000000E+04, 3.2137316173E+01, 4.9029417165E+00, 1.5604487728E+01, 3.3426952248E+00, 9.6730944195E-01],
	[3.9505000000E+04, 3.2144396682E+01, 4.9029727413E+00, 1.5610931588E+01, 3.3430818458E+00, 9.6732408627E-01],
	[3.9510000000E+04, 3.2151477856E+01, 4.9030037624E+00, 1.5617377291E+01, 3.3434683682E+00, 9.6733872328E-01],
	[3.9515000000E+04, 3.2158559693E+01, 4.9030347797E+00, 1.5623824840E+01, 3.3438547922E+00, 9.6735335298E-01],
	[3.9520000000E+04, 3.2165642193E+01, 4.9030657933E+00, 1.5630274233E+01, 3.3442411176E+00, 9.6736797537E-01],
	[3.9525000000E+04, 3.2172725357E+01, 4.9030968032E+00, 1.5636725471E+01, 3.3446273445E+00, 9.6738259046E-01],
	[3.9530000000E+04, 3.2179809185E+01, 4.9031278093E+00, 1.5643178555E+01, 3.3450134729E+00, 9.6739719824E-01],
	[3.9535000000E+04, 3.2186893676E+01, 4.9031588118E+00, 1.5649633484E+01, 3.3453995029E+00, 9.6741179873E-01],
	[3.9540000000E+04, 3.2193978830E+01, 4.9031898105E+00, 1.5656090259E+01, 3.3457854345E+00, 9.6742639193E-01],
	[3.9545000000E+04, 3.2201064648E+01, 4.9032208055E+00, 1.5662548880E+01, 3.3461712677E+00, 9.6744097784E-01],
	[3.9550000000E+04, 3.2208151130E+01, 4.9032517967E+00, 1.5669009347E+01, 3.3465570025E+00, 9.6745555646E-01],
	[3.9555000000E+04, 3.2215238274E+01, 4.9032827843E+00, 1.5675471662E+01, 3.3469426389E+00, 9.6747012781E-01],
	[3.9560000000E+04, 3.2222326083E+01, 4.9033137681E+00, 1.5681935823E+01, 3.3473281770E+00, 9.6748469187E-01],
	[3.9565000000E+04, 3.2229414554E+01, 4.9033447482E+00, 1.5688401832E+01, 3.3477136168E+00, 9.6749924867E-01],
	[3.9570000000E+04, 3.2236503689E+01, 4.9033757245E+00, 1.5694869689E+01, 3.3480989582E+00, 9.6751379819E-01],
	[3.9575000000E+04, 3.2243593487E+01, 4.9034066972E+00, 1.5701339393E+01, 3.3484842014E+00, 9.6752834045E-01],
	[3.9580000000E+04, 3.2250683948E+01, 4.9034376661E+00, 1.5707810946E+01, 3.3488693463E+00, 9.6754287545E-01],
	[3.9585000000E+04, 3.2257775073E+01, 4.9034686314E+00, 1.5714284347E+01, 3.3492543930E+00, 9.6755740320E-01],
	[3.9590000000E+04, 3.2264866861E+01, 4.9034995929E+00, 1.5720759597E+01, 3.3496393414E+00, 9.6757192369E-01],
	[3.9595000000E+04, 3.2271959312E+01, 4.9035305507E+00, 1.5727236696E+01, 3.3500241916E+00, 9.6758643693E-01],
	[3.9600000000E+04, 3.2279052426E+01, 4.9035615048E+00, 1.5733715645E+01, 3.3504089437E+00, 9.6760094292E-01],
	[3.9605000000E+04, 3.2286146204E+01, 4.9035924551E+00, 1.5740196443E+01, 3.3507935976E+00, 9.6761544168E-01],
	[3.9610000000E+04, 3.2293240644E+01, 4.9036234018E+00, 1.5746679092E+01, 3.3511781533E+00, 9.6762993320E-01],
	[3.9615000000E+04, 3.2300335748E+01, 4.9036543447E+00, 1.5753163590E+01, 3.3515626109E+00, 9.6764441748E-01],
	[3.9620000000E+04, 3.2307431515E+01, 4.9036852840E+00, 1.5759649940E+01, 3.3519469704E+00, 9.6765889453E-01],
	[3.9625000000E+04, 3.2314527945E+01, 4.9037162195E+00, 1.5766138140E+01, 3.3523312319E+00, 9.6767336436E-01],
	[3.9630000000E+04, 3.2321625038E+01, 4.9037471513E+00, 1.5772628191E+01, 3.3527153952E+00, 9.6768782697E-01],
	[3.9635000000E+04, 3.2328722794E+01, 4.9037780794E+00, 1.5779120094E+01, 3.3530994605E+00, 9.6770228236E-01],
	[3.9640000000E+04, 3.2335821213E+01, 4.9038090038E+00, 1.5785613849E+01, 3.3534834278E+00, 9.6771673053E-01],
	[3.9645000000E+04, 3.2342920295E+01, 4.9038399245E+00, 1.5792109456E+01, 3.3538672971E+00, 9.6773117150E-01],
	[3.9650000000E+04, 3.2350020040E+01, 4.9038708415E+00, 1.5798606915E+01, 3.3542510684E+00, 9.6774560526E-01],
	[3.9655000000E+04, 3.2357120448E+01, 4.9039017548E+00, 1.5805106227E+01, 3.3546347418E+00, 9.6776003181E-01],
	[3.9660000000E+04, 3.2364221519E+01, 4.9039326644E+00, 1.5811607391E+01, 3.3550183172E+00, 9.6777445117E-01],
	[3.9665000000E+04, 3.2371323253E+01, 4.9039635703E+00, 1.5818110409E+01, 3.3554017946E+00, 9.6778886334E-01],
	[3.9670000000E+04, 3.2378425650E+01, 4.9039944725E+00, 1.5824615281E+01, 3.3557851742E+00, 9.6780326831E-01],
	[3.9675000000E+04, 3.2385528709E+01, 4.9040253710E+00, 1.5831122006E+01, 3.3561684559E+00, 9.6781766610E-01],
	[3.9680000000E+04, 3.2392632432E+01, 4.9040562657E+00, 1.5837630586E+01, 3.3565516397E+00, 9.6783205670E-01],
	[3.9685000000E+04, 3.2399736817E+01, 4.9040871568E+00, 1.5844141020E+01, 3.3569347257E+00, 9.6784644013E-01],
	[3.9690000000E+04, 3.2406841865E+01, 4.9041180442E+00, 1.5850653308E+01, 3.3573177139E+00, 9.6786081638E-01],
	[3.9695000000E+04, 3.2413947576E+01, 4.9041489279E+00, 1.5857167452E+01, 3.3577006042E+00, 9.6787518546E-01],
	[3.9700000000E+04, 3.2421053950E+01, 4.9041798079E+00, 1.5863683451E+01, 3.3580833968E+00, 9.6788954737E-01],
	[3.9705000000E+04, 3.2428160986E+01, 4.9042106842E+00, 1.5870201305E+01, 3.3584660916E+00, 9.6790390212E-01],
	[3.9710000000E+04, 3.2435268685E+01, 4.9042415568E+00, 1.5876721016E+01, 3.3588486887E+00, 9.6791824971E-01],
	[3.9715000000E+04, 3.2442377047E+01, 4.9042724258E+00, 1.5883242583E+01, 3.3592311880E+00, 9.6793259014E-01],
	[3.9720000000E+04, 3.2449486071E+01, 4.9043032910E+00, 1.5889766006E+01, 3.3596135896E+00, 9.6794692342E-01],
	[3.9725000000E+04, 3.2456595759E+01, 4.9043341525E+00, 1.5896291286E+01, 3.3599958936E+00, 9.6796124956E-01],
	[3.9730000000E+04, 3.2463706108E+01, 4.9043650104E+00, 1.5902818423E+01, 3.3603780999E+00, 9.6797556855E-01],
	[3.9735000000E+04, 3.2470817121E+01, 4.9043958645E+00, 1.5909347417E+01, 3.3607602085E+00, 9.6798988040E-01],
	[3.9740000000E+04, 3.2477928796E+01, 4.9044267150E+00, 1.5915878269E+01, 3.3611422196E+00, 9.6800418512E-01],
	[3.9745000000E+04, 3.2485041133E+01, 4.9044575618E+00, 1.5922410979E+01, 3.3615241330E+00, 9.6801848270E-01],
	[3.9750000000E+04, 3.2492154133E+01, 4.9044884049E+00, 1.5928945547E+01, 3.3619059489E+00, 9.6803277316E-01],
	[3.9755000000E+04, 3.2499267796E+01, 4.9045192443E+00, 1.5935481974E+01, 3.3622876671E+00, 9.6804705649E-01],
	[3.9760000000E+04, 3.2506382121E+01, 4.9045500800E+00, 1.5942020260E+01, 3.3626692879E+00, 9.6806133270E-01],
	[3.9765000000E+04, 3.2513497109E+01, 4.9045809120E+00, 1.5948560405E+01, 3.3630508111E+00, 9.6807560179E-01],
	[3.9770000000E+04, 3.2520612759E+01, 4.9046117404E+00, 1.5955102409E+01, 3.3634322368E+00, 9.6808986377E-01],
	[3.9775000000E+04, 3.2527729071E+01, 4.9046425651E+00, 1.5961646273E+01, 3.3638135651E+00, 9.6810411865E-01],
	[3.9780000000E+04, 3.2534846046E+01, 4.9046733861E+00, 1.5968191997E+01, 3.3641947959E+00, 9.6811836641E-01],
	[3.9785000000E+04, 3.2541963683E+01, 4.9047042034E+00, 1.5974739581E+01, 3.3645759292E+00, 9.6813260708E-01],
	[3.9790000000E+04, 3.2549081983E+01, 4.9047350170E+00, 1.5981289026E+01, 3.3649569651E+00, 9.6814684065E-01],
	[3.9795000000E+04, 3.2556200945E+01, 4.9047658270E+00, 1.5987840332E+01, 3.3653379037E+00, 9.6816106712E-01],
	[3.9800000000E+04, 3.2563320570E+01, 4.9047966333E+00, 1.5994393499E+01, 3.3657187448E+00, 9.6817528651E-01],
	[3.9805000000E+04, 3.2570440856E+01, 4.9048274359E+00, 1.6000948527E+01, 3.3660994886E+00, 9.6818949881E-01],
	[3.9810000000E+04, 3.2577561805E+01, 4.9048582348E+00, 1.6007505418E+01, 3.3664801350E+00, 9.6820370403E-01],
	[3.9815000000E+04, 3.2584683416E+01, 4.9048890301E+00, 1.6014064170E+01, 3.3668606842E+00, 9.6821790217E-01],
	[3.9820000000E+04, 3.2591805690E+01, 4.9049198216E+00, 1.6020624785E+01, 3.3672411360E+00, 9.6823209324E-01],
	[3.9825000000E+04, 3.2598928626E+01, 4.9049506095E+00, 1.6027187262E+01, 3.3676214905E+00, 9.6824627723E-01],
	[3.9830000000E+04, 3.2606052223E+01, 4.9049813938E+00, 1.6033751602E+01, 3.3680017478E+00, 9.6826045416E-01],
	[3.9835000000E+04, 3.2613176484E+01, 4.9050121744E+00, 1.6040317806E+01, 3.3683819079E+00, 9.6827462403E-01],
	[3.9840000000E+04, 3.2620301406E+01, 4.9050429512E+00, 1.6046885873E+01, 3.3687619707E+00, 9.6828878684E-01],
	[3.9845000000E+04, 3.2627426990E+01, 4.9050737245E+00, 1.6053455804E+01, 3.3691419364E+00, 9.6830294260E-01],
	[3.9850000000E+04, 3.2634553237E+01, 4.9051044940E+00, 1.6060027599E+01, 3.3695218048E+00, 9.6831709130E-01],
	[3.9855000000E+04, 3.2641680145E+01, 4.9051352599E+00, 1.6066601259E+01, 3.3699015761E+00, 9.6833123296E-01],
	[3.9860000000E+04, 3.2648807716E+01, 4.9051660221E+00, 1.6073176783E+01, 3.3702812503E+00, 9.6834536757E-01],
	[3.9865000000E+04, 3.2655935948E+01, 4.9051967807E+00, 1.6079754173E+01, 3.3706608274E+00, 9.6835949515E-01],
	[3.9870000000E+04, 3.2663070179E+01, 4.9052281949E+00, 1.6086333428E+01, 3.3710406755E+00, 9.6837361569E-01],
	[3.9875000000E+04, 3.2670216305E+01, 4.9052609926E+00, 1.6092914548E+01, 3.3714212017E+00, 9.6838772919E-01],
	[3.9880000000E+04, 3.2677363097E+01, 4.9052937864E+00, 1.6099497534E+01, 3.3718016310E+00, 9.6840183567E-01],
	[3.9885000000E+04, 3.2684510557E+01, 4.9053265764E+00, 1.6106082387E+01, 3.3721819637E+00, 9.6841593513E-01],
	[3.9890000000E+04, 3.2691658684E+01, 4.9053593625E+00, 1.6112669105E+01, 3.3725621995E+00, 9.6843002757E-01],
	[3.9895000000E+04, 3.2698807478E+01, 4.9053921446E+00, 1.6119257691E+01, 3.3729423387E+00, 9.6844411298E-01],
	[3.9900000000E+04, 3.2705956939E+01, 4.9054249229E+00, 1.6125848144E+01, 3.3733223812E+00, 9.6845819139E-01],
	[3.9905000000E+04, 3.2713107067E+01, 4.9054576973E+00, 1.6132440464E+01, 3.3737023270E+00, 9.6847226279E-01],
	[3.9910000000E+04, 3.2720257862E+01, 4.9054904678E+00, 1.6139034652E+01, 3.3740821761E+00, 9.6848632719E-01],
	[3.9915000000E+04, 3.2727409324E+01, 4.9055232344E+00, 1.6145630708E+01, 3.3744619287E+00, 9.6850038458E-01],
	[3.9920000000E+04, 3.2734561453E+01, 4.9055559972E+00, 1.6152228632E+01, 3.3748415846E+00, 9.6851443498E-01],
	[3.9925000000E+04, 3.2741714249E+01, 4.9055887560E+00, 1.6158828425E+01, 3.3752211439E+00, 9.6852847838E-01],
	[3.9930000000E+04, 3.2748867712E+01, 4.9056215110E+00, 1.6165430086E+01, 3.3756006066E+00, 9.6854251479E-01],
	[3.9935000000E+04, 3.2756021842E+01, 4.9056542621E+00, 1.6172033617E+01, 3.3759799728E+00, 9.6855654422E-01],
	[3.9940000000E+04, 3.2763176639E+01, 4.9056870093E+00, 1.6178639017E+01, 3.3763592425E+00, 9.6857056667E-01],
	[3.9945000000E+04, 3.2770332102E+01, 4.9057197526E+00, 1.6185246287E+01, 3.3767384156E+00, 9.6858458214E-01],
	[3.9950000000E+04, 3.2777488233E+01, 4.9057524920E+00, 1.6191855427E+01, 3.3771174923E+00, 9.6859859063E-01],
	[3.9955000000E+04, 3.2784645030E+01, 4.9057852276E+00, 1.6198466437E+01, 3.3774964725E+00, 9.6861259216E-01],
	[3.9960000000E+04, 3.2791802494E+01, 4.9058179593E+00, 1.6205079318E+01, 3.3778753562E+00, 9.6862658672E-01],
	[3.9965000000E+04, 3.2798960625E+01, 4.9058506871E+00, 1.6211694070E+01, 3.3782541436E+00, 9.6864057431E-01],
	[3.9970000000E+04, 3.2806119422E+01, 4.9058834110E+00, 1.6218310693E+01, 3.3786328345E+00, 9.6865455495E-01],
	[3.9975000000E+04, 3.2813278887E+01, 4.9059161311E+00, 1.6224929188E+01, 3.3790114290E+00, 9.6866852863E-01],
	[3.9980000000E+04, 3.2820439018E+01, 4.9059488473E+00, 1.6231549554E+01, 3.3793899271E+00, 9.6868249536E-01],
	[3.9985000000E+04, 3.2827599816E+01, 4.9059815596E+00, 1.6238171792E+01, 3.3797683289E+00, 9.6869645515E-01],
	[3.9990000000E+04, 3.2834761280E+01, 4.9060142680E+00, 1.6244795903E+01, 3.3801466344E+00, 9.6871040799E-01],
	[3.9995000000E+04, 3.2841923411E+01, 4.9060469726E+00, 1.6251421887E+01, 3.3805248435E+00, 9.6872435389E-01],
	[4.0000000000E+04, 3.2849086209E+01, 4.9060796733E+00, 1.6258049743E+01, 3.3809029564E+00, 9.6873829286E-01],
	[4.0005000000E+04, 3.2856249673E+01, 4.9061123701E+00, 1.6264701001E+01, 3.3812819034E+00, 9.6875222489E-01],
	[4.0010000000E+04, 3.2863413804E+01, 4.9061450631E+00, 1.6271354148E+01, 3.3816607537E+00, 9.6876615000E-01],
	[4.0015000000E+04, 3.2870578602E+01, 4.9061777522E+00, 1.6278009183E+01, 3.3820395074E+00, 9.6878006818E-01],
	[4.0020000000E+04, 3.2877744066E+01, 4.9062104374E+00, 1.6284666108E+01, 3.3824181644E+00, 9.6879397944E-01],
	[4.0025000000E+04, 3.2884910196E+01, 4.9062431187E+00, 1.6291324922E+01, 3.3827967247E+00, 9.6880788379E-01],
	[4.0030000000E+04, 3.2892076994E+01, 4.9062757962E+00, 1.6297985625E+01, 3.3831751884E+00, 9.6882178122E-01],
	[4.0035000000E+04, 3.2899244457E+01, 4.9063084699E+00, 1.6304648219E+01, 3.3835535555E+00, 9.6883567174E-01],
	[4.0040000000E+04, 3.2906412587E+01, 4.9063411396E+00, 1.6311312703E+01, 3.3839318260E+00, 9.6884955536E-01],
	[4.0045000000E+04, 3.2913581384E+01, 4.9063738055E+00, 1.6317979077E+01, 3.3843099999E+00, 9.6886343207E-01],
	[4.0050000000E+04, 3.2920750847E+01, 4.9064064676E+00, 1.6324647343E+01, 3.3846880773E+00, 9.6887730189E-01],
	[4.0055000000E+04, 3.2927920976E+01, 4.9064391258E+00, 1.6331317499E+01, 3.3850660582E+00, 9.6889116482E-01],
	[4.0060000000E+04, 3.2935091772E+01, 4.9064717801E+00, 1.6337989548E+01, 3.3854439426E+00, 9.6890502085E-01],
	[4.0065000000E+04, 3.2942263234E+01, 4.9065044305E+00, 1.6344663487E+01, 3.3858217305E+00, 9.6891887000E-01],
	[4.0070000000E+04, 3.2949435362E+01, 4.9065370772E+00, 1.6351339319E+01, 3.3861994219E+00, 9.6893271227E-01],
	[4.0075000000E+04, 3.2956608157E+01, 4.9065697199E+00, 1.6358017044E+01, 3.3865770169E+00, 9.6894654765E-01],
	[4.0080000000E+04, 3.2963781618E+01, 4.9066023588E+00, 1.6364696661E+01, 3.3869545155E+00, 9.6896037617E-01],
	[4.0085000000E+04, 3.2970955745E+01, 4.9066349939E+00, 1.6371378171E+01, 3.3873319177E+00, 9.6897419781E-01],
	[4.0090000000E+04, 3.2978130539E+01, 4.9066676250E+00, 1.6378061574E+01, 3.3877092235E+00, 9.6898801258E-01],
	[4.0095000000E+04, 3.2985305999E+01, 4.9067002524E+00, 1.6384746871E+01, 3.3880864329E+00, 9.6900182049E-01],
	[4.0100000000E+04, 3.2992482125E+01, 4.9067328759E+00, 1.6391434062E+01, 3.3884635460E+00, 9.6901562154E-01],
	[4.0105000000E+04, 3.2999658917E+01, 4.9067654955E+00, 1.6398123147E+01, 3.3888405628E+00, 9.6902941574E-01],
	[4.0110000000E+04, 3.3006836375E+01, 4.9067981113E+00, 1.6404814127E+01, 3.3892174833E+00, 9.6904320308E-01],
	[4.0115000000E+04, 3.3014014500E+01, 4.9068307232E+00, 1.6411507001E+01, 3.3895943075E+00, 9.6905698358E-01],
	[4.0120000000E+04, 3.3021193290E+01, 4.9068633313E+00, 1.6418201771E+01, 3.3899710355E+00, 9.6907075723E-01],
	[4.0125000000E+04, 3.3028372747E+01, 4.9068959356E+00, 1.6424898436E+01, 3.3903476672E+00, 9.6908452404E-01],
	[4.0130000000E+04, 3.3035552870E+01, 4.9069285360E+00, 1.6431596996E+01, 3.3907242027E+00, 9.6909828401E-01],
	[4.0135000000E+04, 3.3042733659E+01, 4.9069611325E+00, 1.6438297453E+01, 3.3911006420E+00, 9.6911203715E-01],
	[4.0140000000E+04, 3.3049915114E+01, 4.9069937252E+00, 1.6444999806E+01, 3.3914769851E+00, 9.6912578346E-01],
	[4.0145000000E+04, 3.3057097234E+01, 4.9070263141E+00, 1.6451704055E+01, 3.3918532321E+00, 9.6913952295E-01],
	[4.0150000000E+04, 3.3064280021E+01, 4.9070588991E+00, 1.6458410201E+01, 3.3922293829E+00, 9.6915325561E-01],
	[4.0155000000E+04, 3.3071463474E+01, 4.9070914803E+00, 1.6465118245E+01, 3.3926054376E+00, 9.6916698146E-01],
	[4.0160000000E+04, 3.3078647593E+01, 4.9071240576E+00, 1.6471828186E+01, 3.3929813963E+00, 9.6918070049E-01],
	[4.0165000000E+04, 3.3085832378E+01, 4.9071566311E+00, 1.6478540025E+01, 3.3933572588E+00, 9.6919441271E-01],
	[4.0170000000E+04, 3.3093017829E+01, 4.9071892008E+00, 1.6485253762E+01, 3.3937330253E+00, 9.6920811813E-01],
	[4.0175000000E+04, 3.3100203945E+01, 4.9072217666E+00, 1.6491969397E+01, 3.3941086958E+00, 9.6922181674E-01],
	[4.0180000000E+04, 3.3107390728E+01, 4.9072543286E+00, 1.6498686931E+01, 3.3944842703E+00, 9.6923550855E-01],
	[4.0185000000E+04, 3.3114578176E+01, 4.9072868867E+00, 1.6505406364E+01, 3.3948597487E+00, 9.6924919357E-01],
	[4.0190000000E+04, 3.3121766290E+01, 4.9073194411E+00, 1.6512127697E+01, 3.3952351312E+00, 9.6926287179E-01],
	[4.0195000000E+04, 3.3128955070E+01, 4.9073519915E+00, 1.6518850928E+01, 3.3956104178E+00, 9.6927654323E-01],
	[4.0200000000E+04, 3.3136144516E+01, 4.9073845382E+00, 1.6525576060E+01, 3.3959856084E+00, 9.6929020788E-01],
	[4.0205000000E+04, 3.3143334627E+01, 4.9074170810E+00, 1.6532303092E+01, 3.3963607031E+00, 9.6930386575E-01],
	[4.0210000000E+04, 3.3150525405E+01, 4.9074496200E+00, 1.6539032025E+01, 3.3967357019E+00, 9.6931751685E-01],
	[4.0215000000E+04, 3.3157716848E+01, 4.9074821552E+00, 1.6545762858E+01, 3.3971106049E+00, 9.6933116117E-01],
	[4.0220000000E+04, 3.3164908956E+01, 4.9075146865E+00, 1.6552495593E+01, 3.3974854120E+00, 9.6934479873E-01],
	[4.0225000000E+04, 3.3172101731E+01, 4.9075472140E+00, 1.6559230228E+01, 3.3978601233E+00, 9.6935842952E-01],
	[4.0230000000E+04, 3.3179295171E+01, 4.9075797377E+00, 1.6565966766E+01, 3.3982347388E+00, 9.6937205355E-01],
	[4.0235000000E+04, 3.3186489276E+01, 4.9076122575E+00, 1.6572705205E+01, 3.3986092585E+00, 9.6938567082E-01],
	[4.0240000000E+04, 3.3193684048E+01, 4.9076447735E+00, 1.6579445547E+01, 3.3989836824E+00, 9.6939928133E-01],
	[4.0245000000E+04, 3.3200879484E+01, 4.9076772857E+00, 1.6586187792E+01, 3.3993580106E+00, 9.6941288510E-01],
	[4.0250000000E+04, 3.3208075587E+01, 4.9077097941E+00, 1.6592931939E+01, 3.3997322431E+00, 9.6942648212E-01],
	[4.0255000000E+04, 3.3215272355E+01, 4.9077422986E+00, 1.6599677990E+01, 3.4001063798E+00, 9.6944007239E-01],
	[4.0260000000E+04, 3.3222469788E+01, 4.9077747994E+00, 1.6606425944E+01, 3.4004804209E+00, 9.6945365593E-01],
	[4.0265000000E+04, 3.3229667887E+01, 4.9078072963E+00, 1.6613175801E+01, 3.4008543663E+00, 9.6946723273E-01],
	[4.0270000000E+04, 3.3236866652E+01, 4.9078397894E+00, 1.6619927563E+01, 3.4012282161E+00, 9.6948080280E-01],
	[4.0275000000E+04, 3.3244066082E+01, 4.9078722786E+00, 1.6626681230E+01, 3.4016019702E+00, 9.6949436615E-01],
	[4.0280000000E+04, 3.3251266177E+01, 4.9079047641E+00, 1.6633436801E+01, 3.4019756288E+00, 9.6950792276E-01],
	[4.0285000000E+04, 3.3258466938E+01, 4.9079372457E+00, 1.6640194277E+01, 3.4023491917E+00, 9.6952147266E-01],
	[4.0290000000E+04, 3.3265668364E+01, 4.9079697235E+00, 1.6646953658E+01, 3.4027226592E+00, 9.6953501585E-01],
	[4.0295000000E+04, 3.3272870456E+01, 4.9080021975E+00, 1.6653714945E+01, 3.4030960310E+00, 9.6954855231E-01],
	[4.0300000000E+04, 3.3280073213E+01, 4.9080346677E+00, 1.6660478138E+01, 3.4034693074E+00, 9.6956208207E-01],
	[4.0305000000E+04, 3.3287276635E+01, 4.9080671341E+00, 1.6667243237E+01, 3.4038424883E+00, 9.6957560513E-01],
	[4.0310000000E+04, 3.3294480723E+01, 4.9080995966E+00, 1.6674010243E+01, 3.4042155736E+00, 9.6958912148E-01],
	[4.0315000000E+04, 3.3301685476E+01, 4.9081320554E+00, 1.6680779155E+01, 3.4045885636E+00, 9.6960263114E-01],
	[4.0320000000E+04, 3.3308890894E+01, 4.9081645103E+00, 1.6687549974E+01, 3.4049614580E+00, 9.6961613410E-01],
	[4.0325000000E+04, 3.3316096978E+01, 4.9081969615E+00, 1.6694322701E+01, 3.4053342571E+00, 9.6962963037E-01],
	[4.0330000000E+04, 3.3323303727E+01, 4.9082294088E+00, 1.6701097336E+01, 3.4057069608E+00, 9.6964311995E-01],
	[4.0335000000E+04, 3.3330511141E+01, 4.9082618523E+00, 1.6707873878E+01, 3.4060795691E+00, 9.6965660286E-01],
	[4.0340000000E+04, 3.3337719220E+01, 4.9082942920E+00, 1.6714652329E+01, 3.4064520821E+00, 9.6967007908E-01],
	[4.0345000000E+04, 3.3344927964E+01, 4.9083267279E+00, 1.6721432689E+01, 3.4068244997E+00, 9.6968354862E-01],
	[4.0350000000E+04, 3.3352137374E+01, 4.9083591600E+00, 1.6728214957E+01, 3.4071968220E+00, 9.6969701150E-01],
	[4.0355000000E+04, 3.3359347448E+01, 4.9083915883E+00, 1.6734999135E+01, 3.4075690490E+00, 9.6971046770E-01],
	[4.0360000000E+04, 3.3366558188E+01, 4.9084240127E+00, 1.6741785222E+01, 3.4079411808E+00, 9.6972391725E-01],
	[4.0365000000E+04, 3.3373769593E+01, 4.9084564334E+00, 1.6748573219E+01, 3.4083132173E+00, 9.6973736013E-01],
	[4.0370000000E+04, 3.3380981663E+01, 4.9084888503E+00, 1.6755363126E+01, 3.4086851585E+00, 9.6975079635E-01],
	[4.0375000000E+04, 3.3388194398E+01, 4.9085212634E+00, 1.6762154943E+01, 3.4090570046E+00, 9.6976422592E-01],
	[4.0380000000E+04, 3.3395407798E+01, 4.9085536727E+00, 1.6768948671E+01, 3.4094287555E+00, 9.6977764885E-01],
	[4.0385000000E+04, 3.3402621863E+01, 4.9085860781E+00, 1.6775744311E+01, 3.4098004112E+00, 9.6979106512E-01],
	[4.0390000000E+04, 3.3409836593E+01, 4.9086184798E+00, 1.6782541861E+01, 3.4101719717E+00, 9.6980447476E-01],
	[4.0395000000E+04, 3.3417051988E+01, 4.9086508777E+00, 1.6789341323E+01, 3.4105434372E+00, 9.6981787775E-01],
	[4.0400000000E+04, 3.3424268047E+01, 4.9086832718E+00, 1.6796142697E+01, 3.4109148075E+00, 9.6983127411E-01],
	[4.0405000000E+04, 3.3431484772E+01, 4.9087156621E+00, 1.6802945983E+01, 3.4112860827E+00, 9.6984466384E-01],
	[4.0410000000E+04, 3.3438702162E+01, 4.9087480486E+00, 1.6809751182E+01, 3.4116572629E+00, 9.6985804694E-01],
	[4.0415000000E+04, 3.3445920216E+01, 4.9087804313E+00, 1.6816558293E+01, 3.4120283481E+00, 9.6987142342E-01],
	[4.0420000000E+04, 3.3453138936E+01, 4.9088128102E+00, 1.6823367318E+01, 3.4123993382E+00, 9.6988479327E-01],
	[4.0425000000E+04, 3.3460358320E+01, 4.9088451853E+00, 1.6830178256E+01, 3.4127702333E+00, 9.6989815650E-01],
	[4.0430000000E+04, 3.3467578369E+01, 4.9088775567E+00, 1.6836991108E+01, 3.4131410334E+00, 9.6991151312E-01],
	[4.0435000000E+04, 3.3474799083E+01, 4.9089099242E+00, 1.6843805874E+01, 3.4135117386E+00, 9.6992486313E-01],
	[4.0440000000E+04, 3.3482020462E+01, 4.9089422880E+00, 1.6850622554E+01, 3.4138823488E+00, 9.6993820652E-01],
	[4.0445000000E+04, 3.3489242505E+01, 4.9089746479E+00, 1.6857441149E+01, 3.4142528641E+00, 9.6995154331E-01],
	[4.0450000000E+04, 3.3496465213E+01, 4.9090070041E+00, 1.6864261658E+01, 3.4146232846E+00, 9.6996487350E-01],
	[4.0455000000E+04, 3.3503688586E+01, 4.9090393565E+00, 1.6871084083E+01, 3.4149936101E+00, 9.6997819708E-01],
	[4.0460000000E+04, 3.3510912624E+01, 4.9090717051E+00, 1.6877908423E+01, 3.4153638408E+00, 9.6999151408E-01],
	[4.0465000000E+04, 3.3518137326E+01, 4.9091040499E+00, 1.6884734680E+01, 3.4157339766E+00, 9.7000482447E-01],
	[4.0470000000E+04, 3.3525362693E+01, 4.9091363910E+00, 1.6891562852E+01, 3.4161040177E+00, 9.7001812828E-01],
	[4.0475000000E+04, 3.3532588724E+01, 4.9091687282E+00, 1.6898392941E+01, 3.4164739639E+00, 9.7003142550E-01],
	[4.0480000000E+04, 3.3539815420E+01, 4.9092010617E+00, 1.6905224946E+01, 3.4168438154E+00, 9.7004471614E-01],
	[4.0485000000E+04, 3.3547042781E+01, 4.9092333914E+00, 1.6912058869E+01, 3.4172135721E+00, 9.7005800019E-01],
	[4.0490000000E+04, 3.3554270806E+01, 4.9092657173E+00, 1.6918894708E+01, 3.4175832340E+00, 9.7007127767E-01],
	[4.0495000000E+04, 3.3561499496E+01, 4.9092980395E+00, 1.6925732466E+01, 3.4179528013E+00, 9.7008454858E-01],
	[4.0500000000E+04, 3.3568728850E+01, 4.9093303578E+00, 1.6932572141E+01, 3.4183222739E+00, 9.7009781292E-01],
	[4.0505000000E+04, 3.3575958869E+01, 4.9093626724E+00, 1.6939413735E+01, 3.4186916518E+00, 9.7011107069E-01],
	[4.0510000000E+04, 3.3583189552E+01, 4.9093949832E+00, 1.6946257247E+01, 3.4190609350E+00, 9.7012432189E-01],
	[4.0515000000E+04, 3.3590436634E+01, 4.9094292056E+00, 1.6953102678E+01, 3.4194312159E+00, 9.7013756654E-01],
	[4.0520000000E+04, 3.3597685096E+01, 4.9094635105E+00, 1.6959950028E+01, 3.4198014517E+00, 9.7015080463E-01],
	[4.0525000000E+04, 3.3604934228E+01, 4.9094978115E+00, 1.6966799297E+01, 3.4201715932E+00, 9.7016403616E-01],
	[4.0530000000E+04, 3.3612184029E+01, 4.9095321084E+00, 1.6973650487E+01, 3.4205416405E+00, 9.7017726114E-01],
	[4.0535000000E+04, 3.3619434500E+01, 4.9095664014E+00, 1.6980503596E+01, 3.4209115934E+00, 9.7019047958E-01],
	[4.0540000000E+04, 3.3626685640E+01, 4.9096006904E+00, 1.6987358625E+01, 3.4212814521E+00, 9.7020369147E-01],
	[4.0545000000E+04, 3.3633937449E+01, 4.9096349754E+00, 1.6994215576E+01, 3.4216512166E+00, 9.7021689682E-01],
	[4.0550000000E+04, 3.3641189928E+01, 4.9096692564E+00, 1.7001074447E+01, 3.4220208868E+00, 9.7023009563E-01],
	[4.0555000000E+04, 3.3648443076E+01, 4.9097035334E+00, 1.7007935239E+01, 3.4223904628E+00, 9.7024328791E-01],
	[4.0560000000E+04, 3.3655696893E+01, 4.9097378064E+00, 1.7014797953E+01, 3.4227599447E+00, 9.7025647365E-01],
	[4.0565000000E+04, 3.3662951380E+01, 4.9097720754E+00, 1.7021662589E+01, 3.4231293324E+00, 9.7026965287E-01],
	[4.0570000000E+04, 3.3670206536E+01, 4.9098063405E+00, 1.7028529147E+01, 3.4234986259E+00, 9.7028282557E-01],
	[4.0575000000E+04, 3.3677462361E+01, 4.9098406016E+00, 1.7035397627E+01, 3.4238678254E+00, 9.7029599174E-01],
	[4.0580000000E+04, 3.3684718856E+01, 4.9098748587E+00, 1.7042268030E+01, 3.4242369308E+00, 9.7030915139E-01],
	[4.0585000000E+04, 3.3691976020E+01, 4.9099091118E+00, 1.7049140356E+01, 3.4246059420E+00, 9.7032230453E-01],
	[4.0590000000E+04, 3.3699233853E+01, 4.9099433609E+00, 1.7056014606E+01, 3.4249748593E+00, 9.7033545116E-01],
	[4.0595000000E+04, 3.3706492355E+01, 4.9099776060E+00, 1.7062890779E+01, 3.4253436825E+00, 9.7034859128E-01],
	[4.0600000000E+04, 3.3713751526E+01, 4.9100118472E+00, 1.7069768876E+01, 3.4257124116E+00, 9.7036172489E-01],
	[4.0605000000E+04, 3.3721011367E+01, 4.9100460844E+00, 1.7076648897E+01, 3.4260810468E+00, 9.7037485200E-01],
	[4.0610000000E+04, 3.3728271876E+01, 4.9100803176E+00, 1.7083530843E+01, 3.4264495881E+00, 9.7038797262E-01],
	[4.0615000000E+04, 3.3735533055E+01, 4.9101145468E+00, 1.7090414713E+01, 3.4268180353E+00, 9.7040108673E-01],
	[4.0620000000E+04, 3.3742794903E+01, 4.9101487721E+00, 1.7097300509E+01, 3.4271863887E+00, 9.7041419436E-01],
	[4.0625000000E+04, 3.3750057420E+01, 4.9101829934E+00, 1.7104188230E+01, 3.4275546481E+00, 9.7042729549E-01],
	[4.0630000000E+04, 3.3757320606E+01, 4.9102172107E+00, 1.7111077877E+01, 3.4279228137E+00, 9.7044039014E-01],
	[4.0635000000E+04, 3.3764584461E+01, 4.9102514240E+00, 1.7117969450E+01, 3.4282908853E+00, 9.7045347831E-01],
	[4.0640000000E+04, 3.3771848984E+01, 4.9102856334E+00, 1.7124862950E+01, 3.4286588632E+00, 9.7046656000E-01],
	[4.0645000000E+04, 3.3779114177E+01, 4.9103198388E+00, 1.7131758376E+01, 3.4290267472E+00, 9.7047963521E-01],
	[4.0650000000E+04, 3.3786380039E+01, 4.9103540402E+00, 1.7138655729E+01, 3.4293945374E+00, 9.7049270395E-01],
	[4.0655000000E+04, 3.3793646570E+01, 4.9103882377E+00, 1.7145555009E+01, 3.4297622338E+00, 9.7050576622E-01],
	[4.0660000000E+04, 3.3800913770E+01, 4.9104224312E+00, 1.7152456217E+01, 3.4301298364E+00, 9.7051882203E-01],
	[4.0665000000E+04, 3.3808181638E+01, 4.9104566207E+00, 1.7159359352E+01, 3.4304973454E+00, 9.7053187137E-01],
	[4.0670000000E+04, 3.3815450176E+01, 4.9104908063E+00, 1.7166264416E+01, 3.4308647605E+00, 9.7054491425E-01],
	[4.0675000000E+04, 3.3822719382E+01, 4.9105249879E+00, 1.7173171408E+01, 3.4312320820E+00, 9.7055795068E-01],
	[4.0680000000E+04, 3.3829989257E+01, 4.9105591655E+00, 1.7180080329E+01, 3.4315993098E+00, 9.7057098065E-01],
	[4.0685000000E+04, 3.3837259801E+01, 4.9105933392E+00, 1.7186991179E+01, 3.4319664440E+00, 9.7058400417E-01],
	[4.0690000000E+04, 3.3844531014E+01, 4.9106275089E+00, 1.7193903959E+01, 3.4323334845E+00, 9.7059702124E-01],
	[4.0695000000E+04, 3.3851802896E+01, 4.9106616747E+00, 1.7200818668E+01, 3.4327004314E+00, 9.7061003188E-01],
	[4.0700000000E+04, 3.3859075446E+01, 4.9106958364E+00, 1.7207735307E+01, 3.4330672847E+00, 9.7062303607E-01],
	[4.0705000000E+04, 3.3866348665E+01, 4.9107299943E+00, 1.7214653876E+01, 3.4334340444E+00, 9.7063603382E-01],
	[4.0710000000E+04, 3.3873622553E+01, 4.9107641481E+00, 1.7221574376E+01, 3.4338007105E+00, 9.7064902514E-01],
	[4.0715000000E+04, 3.3880897109E+01, 4.9107982981E+00, 1.7228496807E+01, 3.4341672831E+00, 9.7066201003E-01],
	[4.0720000000E+04, 3.3888172334E+01, 4.9108324440E+00, 1.7235421169E+01, 3.4345337622E+00, 9.7067498849E-01],
	[4.0725000000E+04, 3.3895448228E+01, 4.9108665860E+00, 1.7242347462E+01, 3.4349001478E+00, 9.7068796053E-01],
	[4.0730000000E+04, 3.3902724791E+01, 4.9109007241E+00, 1.7249275687E+01, 3.4352664400E+00, 9.7070092615E-01],
	[4.0735000000E+04, 3.3910002022E+01, 4.9109348582E+00, 1.7256205845E+01, 3.4356326387E+00, 9.7071388535E-01],
	[4.0740000000E+04, 3.3917279921E+01, 4.9109689883E+00, 1.7263137934E+01, 3.4359987439E+00, 9.7072683814E-01],
	[4.0745000000E+04, 3.3924558489E+01, 4.9110031145E+00, 1.7270071956E+01, 3.4363647557E+00, 9.7073978451E-01],
	[4.0750000000E+04, 3.3931837726E+01, 4.9110372368E+00, 1.7277007912E+01, 3.4367306742E+00, 9.7075272448E-01],
	[4.0755000000E+04, 3.3939117631E+01, 4.9110713550E+00, 1.7283945800E+01, 3.4370964993E+00, 9.7076565804E-01],
	[4.0760000000E+04, 3.3946398205E+01, 4.9111054694E+00, 1.7290885622E+01, 3.4374622310E+00, 9.7077858520E-01],
	[4.0765000000E+04, 3.3953679447E+01, 4.9111395798E+00, 1.7297827378E+01, 3.4378278694E+00, 9.7079150596E-01],
	[4.0770000000E+04, 3.3960961358E+01, 4.9111736862E+00, 1.7304771068E+01, 3.4381934145E+00, 9.7080442033E-01],
	[4.0775000000E+04, 3.3968243937E+01, 4.9112077887E+00, 1.7311716693E+01, 3.4385588663E+00, 9.7081732831E-01],
	[4.0780000000E+04, 3.3975527184E+01, 4.9112418873E+00, 1.7318664252E+01, 3.4389242248E+00, 9.7083022990E-01],
	[4.0785000000E+04, 3.3982811100E+01, 4.9112759819E+00, 1.7325613747E+01, 3.4392894901E+00, 9.7084312510E-01],
	[4.0790000000E+04, 3.3990095685E+01, 4.9113100726E+00, 1.7332565177E+01, 3.4396546622E+00, 9.7085601392E-01],
	[4.0795000000E+04, 3.3997380937E+01, 4.9113441593E+00, 1.7339518542E+01, 3.4400197410E+00, 9.7086889636E-01],
	[4.0800000000E+04, 3.4004666858E+01, 4.9113782421E+00, 1.7346473844E+01, 3.4403847267E+00, 9.7088177243E-01],
	[4.0805000000E+04, 3.4011953448E+01, 4.9114123210E+00, 1.7353431081E+01, 3.4407496192E+00, 9.7089464212E-01],
	[4.0810000000E+04, 3.4019240705E+01, 4.9114463959E+00, 1.7360390256E+01, 3.4411144186E+00, 9.7090750545E-01],
	[4.0815000000E+04, 3.4026528631E+01, 4.9114804669E+00, 1.7367351367E+01, 3.4414791248E+00, 9.7092036241E-01],
	[4.0820000000E+04, 3.4033817225E+01, 4.9115145339E+00, 1.7374314416E+01, 3.4418437380E+00, 9.7093321300E-01],
	[4.0825000000E+04, 3.4041106488E+01, 4.9115485970E+00, 1.7381279402E+01, 3.4422082581E+00, 9.7094605724E-01],
	[4.0830000000E+04, 3.4048396418E+01, 4.9115826562E+00, 1.7388246325E+01, 3.4425726851E+00, 9.7095889512E-01],
	[4.0835000000E+04, 3.4055687017E+01, 4.9116167114E+00, 1.7395215187E+01, 3.4429370190E+00, 9.7097172665E-01],
	[4.0840000000E+04, 3.4062978284E+01, 4.9116507627E+00, 1.7402185988E+01, 3.4433012600E+00, 9.7098455183E-01],
	[4.0845000000E+04, 3.4070270219E+01, 4.9116848100E+00, 1.7409158727E+01, 3.4436654080E+00, 9.7099737067E-01],
	[4.0850000000E+04, 3.4077562823E+01, 4.9117188535E+00, 1.7416133404E+01, 3.4440294629E+00, 9.7101018316E-01],
	[4.0855000000E+04, 3.4084856094E+01, 4.9117528930E+00, 1.7423110022E+01, 3.4443934250E+00, 9.7102298931E-01],
	[4.0860000000E+04, 3.4092150034E+01, 4.9117869285E+00, 1.7430088579E+01, 3.4447572941E+00, 9.7103578912E-01],
	[4.0865000000E+04, 3.4099444641E+01, 4.9118209602E+00, 1.7437069075E+01, 3.4451210702E+00, 9.7104858260E-01],
	[4.0870000000E+04, 3.4106739917E+01, 4.9118549879E+00, 1.7444051512E+01, 3.4454847535E+00, 9.7106136975E-01],
	[4.0875000000E+04, 3.4114035860E+01, 4.9118890117E+00, 1.7451035890E+01, 3.4458483440E+00, 9.7107415057E-01],
	[4.0880000000E+04, 3.4121332472E+01, 4.9119230316E+00, 1.7458022208E+01, 3.4462118415E+00, 9.7108692507E-01],
	[4.0885000000E+04, 3.4128629752E+01, 4.9119570475E+00, 1.7465010468E+01, 3.4465752463E+00, 9.7109969325E-01],
	[4.0890000000E+04, 3.4135927699E+01, 4.9119910595E+00, 1.7472000668E+01, 3.4469385582E+00, 9.7111245511E-01],
	[4.0895000000E+04, 3.4143226315E+01, 4.9120250676E+00, 1.7478992811E+01, 3.4473017773E+00, 9.7112521066E-01],
	[4.0900000000E+04, 3.4150525598E+01, 4.9120590718E+00, 1.7485986895E+01, 3.4476649037E+00, 9.7113795990E-01],
	[4.0905000000E+04, 3.4157825550E+01, 4.9120930720E+00, 1.7492982922E+01, 3.4480279373E+00, 9.7115070283E-01],
	[4.0910000000E+04, 3.4165126169E+01, 4.9121270683E+00, 1.7499980892E+01, 3.4483908782E+00, 9.7116343945E-01],
	[4.0915000000E+04, 3.4172427456E+01, 4.9121610607E+00, 1.7506980804E+01, 3.4487537264E+00, 9.7117616978E-01],
	[4.0920000000E+04, 3.4179729411E+01, 4.9121950492E+00, 1.7513982660E+01, 3.4491164819E+00, 9.7118889380E-01],
	[4.0925000000E+04, 3.4187032034E+01, 4.9122290338E+00, 1.7520986459E+01, 3.4494791448E+00, 9.7120161153E-01],
	[4.0930000000E+04, 3.4194335324E+01, 4.9122630144E+00, 1.7527992202E+01, 3.4498417150E+00, 9.7121432297E-01],
	[4.0935000000E+04, 3.4201639283E+01, 4.9122969912E+00, 1.7534999889E+01, 3.4502041926E+00, 9.7122702812E-01],
	[4.0940000000E+04, 3.4208943909E+01, 4.9123309640E+00, 1.7542009521E+01, 3.4505665775E+00, 9.7123972699E-01],
	[4.0945000000E+04, 3.4216249203E+01, 4.9123649329E+00, 1.7549021097E+01, 3.4509288699E+00, 9.7125241957E-01],
	[4.0950000000E+04, 3.4223555164E+01, 4.9123988979E+00, 1.7556034618E+01, 3.4512910698E+00, 9.7126510588E-01],
	[4.0955000000E+04, 3.4230861794E+01, 4.9124328590E+00, 1.7563050085E+01, 3.4516531771E+00, 9.7127778591E-01],
	[4.0960000000E+04, 3.4238169091E+01, 4.9124668162E+00, 1.7570067497E+01, 3.4520151919E+00, 9.7129045967E-01],
	[4.0965000000E+04, 3.4245477055E+01, 4.9125007694E+00, 1.7577086855E+01, 3.4523771142E+00, 9.7130312716E-01],
	[4.0970000000E+04, 3.4252785688E+01, 4.9125347188E+00, 1.7584108159E+01, 3.4527389440E+00, 9.7131578838E-01],
	[4.0975000000E+04, 3.4260094988E+01, 4.9125686642E+00, 1.7591131410E+01, 3.4531006813E+00, 9.7132844334E-01],
	[4.0980000000E+04, 3.4267404955E+01, 4.9126026058E+00, 1.7598156608E+01, 3.4534623263E+00, 9.7134109205E-01],
	[4.0985000000E+04, 3.4274715590E+01, 4.9126365434E+00, 1.7605183753E+01, 3.4538238788E+00, 9.7135373449E-01],
	[4.0990000000E+04, 3.4282026893E+01, 4.9126704771E+00, 1.7612212846E+01, 3.4541853389E+00, 9.7136637069E-01],
	[4.0995000000E+04, 3.4289338863E+01, 4.9127044069E+00, 1.7619243886E+01, 3.4545467067E+00, 9.7137900063E-01],
	[4.1000000000E+04, 3.4296651501E+01, 4.9127383328E+00, 1.7626276874E+01, 3.4549079820E+00, 9.7139162433E-01],
	[4.1005000000E+04, 3.4303964806E+01, 4.9127722549E+00, 1.7633311810E+01, 3.4552691651E+00, 9.7140424178E-01],
	[4.1010000000E+04, 3.4311278779E+01, 4.9128061730E+00, 1.7640348696E+01, 3.4556302559E+00, 9.7141685300E-01],
	[4.1015000000E+04, 3.4318593419E+01, 4.9128400872E+00, 1.7647387530E+01, 3.4559912543E+00, 9.7142945797E-01],
	[4.1020000000E+04, 3.4325908727E+01, 4.9128739975E+00, 1.7654428313E+01, 3.4563521606E+00, 9.7144205672E-01],
	[4.1025000000E+04, 3.4333224702E+01, 4.9129079039E+00, 1.7661471046E+01, 3.4567129745E+00, 9.7145464923E-01],
	[4.1030000000E+04, 3.4340541344E+01, 4.9129418064E+00, 1.7668515729E+01, 3.4570736962E+00, 9.7146723552E-01],
	[4.1035000000E+04, 3.4347858654E+01, 4.9129757050E+00, 1.7675562362E+01, 3.4574343258E+00, 9.7147981558E-01],
	[4.1040000000E+04, 3.4355176631E+01, 4.9130095997E+00, 1.7682610945E+01, 3.4577948631E+00, 9.7149238942E-01],
	[4.1045000000E+04, 3.4362495275E+01, 4.9130434906E+00, 1.7689661479E+01, 3.4581553083E+00, 9.7150495705E-01],
	[4.1050000000E+04, 3.4369814587E+01, 4.9130773775E+00, 1.7696713965E+01, 3.4585156613E+00, 9.7151751846E-01],
	[4.1055000000E+04, 3.4377134566E+01, 4.9131112605E+00, 1.7703768401E+01, 3.4588759223E+00, 9.7153007366E-01],
	[4.1060000000E+04, 3.4384455212E+01, 4.9131451397E+00, 1.7710824789E+01, 3.4592360911E+00, 9.7154262265E-01],
	[4.1065000000E+04, 3.4391776526E+01, 4.9131790149E+00, 1.7717883130E+01, 3.4595961678E+00, 9.7155516544E-01],
	[4.1070000000E+04, 3.4399098507E+01, 4.9132128863E+00, 1.7724943422E+01, 3.4599561525E+00, 9.7156770202E-01],
	[4.1075000000E+04, 3.4406421155E+01, 4.9132467538E+00, 1.7732005667E+01, 3.4603160452E+00, 9.7158023241E-01],
	[4.1080000000E+04, 3.4413744470E+01, 4.9132806173E+00, 1.7739069865E+01, 3.4606758458E+00, 9.7159275660E-01],
	[4.1085000000E+04, 3.4421068453E+01, 4.9133144770E+00, 1.7746136016E+01, 3.4610355544E+00, 9.7160527460E-01],
	[4.1090000000E+04, 3.4428393102E+01, 4.9133483328E+00, 1.7753204121E+01, 3.4613951711E+00, 9.7161778641E-01],
	[4.1095000000E+04, 3.4435718419E+01, 4.9133821848E+00, 1.7760274179E+01, 3.4617546958E+00, 9.7163029204E-01],
	[4.1100000000E+04, 3.4443044402E+01, 4.9134160328E+00, 1.7767346192E+01, 3.4621141286E+00, 9.7164279148E-01],
	[4.1105000000E+04, 3.4450371053E+01, 4.9134498769E+00, 1.7774420159E+01, 3.4624734694E+00, 9.7165528475E-01],
	[4.1110000000E+04, 3.4457698371E+01, 4.9134837172E+00, 1.7781496080E+01, 3.4628327184E+00, 9.7166777184E-01],
	[4.1115000000E+04, 3.4465026356E+01, 4.9135175536E+00, 1.7788573957E+01, 3.4631918755E+00, 9.7168025276E-01],
	[4.1120000000E+04, 3.4472355008E+01, 4.9135513861E+00, 1.7795653789E+01, 3.4635509408E+00, 9.7169272750E-01],
	[4.1125000000E+04, 3.4479684327E+01, 4.9135852147E+00, 1.7802735576E+01, 3.4639099142E+00, 9.7170519608E-01],
	[4.1130000000E+04, 3.4487014313E+01, 4.9136190395E+00, 1.7809819320E+01, 3.4642687958E+00, 9.7171765850E-01],
	[4.1135000000E+04, 3.4494344966E+01, 4.9136528603E+00, 1.7816905019E+01, 3.4646275856E+00, 9.7173011476E-01],
	[4.1140000000E+04, 3.4501676286E+01, 4.9136866773E+00, 1.7823992675E+01, 3.4649862837E+00, 9.7174256486E-01],
	[4.1145000000E+04, 3.4509008273E+01, 4.9137204904E+00, 1.7831082288E+01, 3.4653448900E+00, 9.7175500881E-01],
	[4.1150000000E+04, 3.4516340927E+01, 4.9137542997E+00, 1.7838173858E+01, 3.4657034046E+00, 9.7176744661E-01],
	[4.1155000000E+04, 3.4523674247E+01, 4.9137881050E+00, 1.7845267385E+01, 3.4660618275E+00, 9.7177987826E-01],
	[4.1160000000E+04, 3.4531008235E+01, 4.9138219065E+00, 1.7852362870E+01, 3.4664201587E+00, 9.7179230377E-01],
	[4.1165000000E+04, 3.4538351476E+01, 4.9138567319E+00, 1.7859460313E+01, 3.4667789964E+00, 9.7180472314E-01],
	[4.1170000000E+04, 3.4545703160E+01, 4.9138924834E+00, 1.7866559715E+01, 3.4671382839E+00, 9.7181713637E-01],
	[4.1175000000E+04, 3.4553055517E+01, 4.9139282309E+00, 1.7873661075E+01, 3.4674974800E+00, 9.7182954346E-01],
	[4.1180000000E+04, 3.4560408544E+01, 4.9139639744E+00, 1.7880764394E+01, 3.4678565848E+00, 9.7184194443E-01],
	[4.1185000000E+04, 3.4567762244E+01, 4.9139997137E+00, 1.7887869672E+01, 3.4682155983E+00, 9.7185433927E-01],
	[4.1190000000E+04, 3.4575116615E+01, 4.9140354490E+00, 1.7894976909E+01, 3.4685745205E+00, 9.7186672798E-01],
	[4.1195000000E+04, 3.4582471658E+01, 4.9140711802E+00, 1.7902086107E+01, 3.4689333513E+00, 9.7187911057E-01],
	[4.1200000000E+04, 3.4589827373E+01, 4.9141069073E+00, 1.7909197264E+01, 3.4692920909E+00, 9.7189148704E-01],
	[4.1205000000E+04, 3.4597183759E+01, 4.9141426303E+00, 1.7916310382E+01, 3.4696507393E+00, 9.7190385740E-01],
	[4.1210000000E+04, 3.4604540817E+01, 4.9141783493E+00, 1.7923425461E+01, 3.4700092965E+00, 9.7191622165E-01],
	[4.1215000000E+04, 3.4611898547E+01, 4.9142140642E+00, 1.7930542501E+01, 3.4703677624E+00, 9.7192857978E-01],
	[4.1220000000E+04, 3.4619256948E+01, 4.9142497750E+00, 1.7937661502E+01, 3.4707261372E+00, 9.7194093181E-01],
	[4.1225000000E+04, 3.4626616020E+01, 4.9142854817E+00, 1.7944782465E+01, 3.4710844208E+00, 9.7195327774E-01],
	[4.1230000000E+04, 3.4633975765E+01, 4.9143211844E+00, 1.7951905389E+01, 3.4714426132E+00, 9.7196561757E-01],
	[4.1235000000E+04, 3.4641336180E+01, 4.9143568830E+00, 1.7959030276E+01, 3.4718007146E+00, 9.7197795131E-01],
	[4.1240000000E+04, 3.4648697268E+01, 4.9143925775E+00, 1.7966157126E+01, 3.4721587248E+00, 9.7199027895E-01],
	[4.1245000000E+04, 3.4656059026E+01, 4.9144282680E+00, 1.7973285938E+01, 3.4725166440E+00, 9.7200260050E-01],
	[4.1250000000E+04, 3.4663421457E+01, 4.9144639544E+00, 1.7980416713E+01, 3.4728744721E+00, 9.7201491597E-01],
	[4.1255000000E+04, 3.4670784558E+01, 4.9144996367E+00, 1.7987549452E+01, 3.4732322091E+00, 9.7202722535E-01],
	[4.1260000000E+04, 3.4678148331E+01, 4.9145353149E+00, 1.7994684155E+01, 3.4735898552E+00, 9.7203952865E-01],
	[4.1265000000E+04, 3.4685512776E+01, 4.9145709891E+00, 1.8001820822E+01, 3.4739474102E+00, 9.7205182588E-01],
	[4.1270000000E+04, 3.4692877892E+01, 4.9146066593E+00, 1.8008959453E+01, 3.4743048743E+00, 9.7206411703E-01],
	[4.1275000000E+04, 3.4700243679E+01, 4.9146423254E+00, 1.8016100048E+01, 3.4746622474E+00, 9.7207640211E-01],
	[4.1280000000E+04, 3.4707610138E+01, 4.9146779874E+00, 1.8023242609E+01, 3.4750195296E+00, 9.7208868113E-01],
	[4.1285000000E+04, 3.4714977268E+01, 4.9147136453E+00, 1.8030387135E+01, 3.4753767209E+00, 9.7210095408E-01],
	[4.1290000000E+04, 3.4722345069E+01, 4.9147492992E+00, 1.8037533626E+01, 3.4757338213E+00, 9.7211322097E-01],
	[4.1295000000E+04, 3.4729713542E+01, 4.9147849490E+00, 1.8044682084E+01, 3.4760908309E+00, 9.7212548180E-01],
	[4.1300000000E+04, 3.4737082685E+01, 4.9148205948E+00, 1.8051832507E+01, 3.4764477495E+00, 9.7213773658E-01],
	[4.1305000000E+04, 3.4744452500E+01, 4.9148562365E+00, 1.8058984897E+01, 3.4768045774E+00, 9.7214998530E-01],
	[4.1310000000E+04, 3.4751822987E+01, 4.9148918742E+00, 1.8066139254E+01, 3.4771613144E+00, 9.7216222798E-01],
	[4.1315000000E+04, 3.4759194144E+01, 4.9149275078E+00, 1.8073295578E+01, 3.4775179607E+00, 9.7217446461E-01],
	[4.1320000000E+04, 3.4766565973E+01, 4.9149631374E+00, 1.8080453869E+01, 3.4778745162E+00, 9.7218669520E-01],
	[4.1325000000E+04, 3.4773938473E+01, 4.9149987629E+00, 1.8087614128E+01, 3.4782309809E+00, 9.7219891975E-01],
	[4.1330000000E+04, 3.4781311644E+01, 4.9150343843E+00, 1.8094776355E+01, 3.4785873549E+00, 9.7221113827E-01],
	[4.1335000000E+04, 3.4788685486E+01, 4.9150700017E+00, 1.8101940550E+01, 3.4789436383E+00, 9.7222335075E-01],
	[4.1340000000E+04, 3.4796059999E+01, 4.9151056150E+00, 1.8109106714E+01, 3.4792998309E+00, 9.7223555721E-01],
	[4.1345000000E+04, 3.4803435183E+01, 4.9151412243E+00, 1.8116274846E+01, 3.4796559329E+00, 9.7224775764E-01],
	[4.1350000000E+04, 3.4810811039E+01, 4.9151768296E+00, 1.8123444948E+01, 3.4800119442E+00, 9.7225995204E-01],
	[4.1355000000E+04, 3.4818187565E+01, 4.9152124308E+00, 1.8130617019E+01, 3.4803678649E+00, 9.7227214043E-01],
	[4.1360000000E+04, 3.4825564763E+01, 4.9152480280E+00, 1.8137791061E+01, 3.4807236950E+00, 9.7228432280E-01],
	[4.1365000000E+04, 3.4832942631E+01, 4.9152836211E+00, 1.8144967072E+01, 3.4810794346E+00, 9.7229649916E-01],
	[4.1370000000E+04, 3.4840321171E+01, 4.9153192101E+00, 1.8152145053E+01, 3.4814350836E+00, 9.7230866950E-01],
	[4.1375000000E+04, 3.4847700381E+01, 4.9153547952E+00, 1.8159325006E+01, 3.4817906420E+00, 9.7232083384E-01],
	[4.1380000000E+04, 3.4855080263E+01, 4.9153903761E+00, 1.8166506929E+01, 3.4821461099E+00, 9.7233299218E-01],
	[4.1385000000E+04, 3.4862460815E+01, 4.9154259531E+00, 1.8173690824E+01, 3.4825014874E+00, 9.7234514451E-01],
	[4.1390000000E+04, 3.4869842038E+01, 4.9154615260E+00, 1.8180876690E+01, 3.4828567743E+00, 9.7235729085E-01],
	[4.1395000000E+04, 3.4877223932E+01, 4.9154970948E+00, 1.8188064528E+01, 3.4832119709E+00, 9.7236943119E-01],
	[4.1400000000E+04, 3.4884606497E+01, 4.9155326597E+00, 1.8195254338E+01, 3.4835670769E+00, 9.7238156555E-01],
	[4.1405000000E+04, 3.4891989733E+01, 4.9155682204E+00, 1.8202446121E+01, 3.4839220926E+00, 9.7239369391E-01],
	[4.1410000000E+04, 3.4899373640E+01, 4.9156037772E+00, 1.8209639877E+01, 3.4842770179E+00, 9.7240581629E-01],
	[4.1415000000E+04, 3.4906758217E+01, 4.9156393299E+00, 1.8216835606E+01, 3.4846318528E+00, 9.7241793269E-01],
	[4.1420000000E+04, 3.4914143465E+01, 4.9156748786E+00, 1.8224033308E+01, 3.4849865974E+00, 9.7243004311E-01],
	[4.1425000000E+04, 3.4921529384E+01, 4.9157104232E+00, 1.8231232984E+01, 3.4853412516E+00, 9.7244214755E-01],
	[4.1430000000E+04, 3.4928915974E+01, 4.9157459638E+00, 1.8238434634E+01, 3.4856958155E+00, 9.7245424602E-01],
	[4.1435000000E+04, 3.4936303234E+01, 4.9157815004E+00, 1.8245638259E+01, 3.4860502892E+00, 9.7246633852E-01],
	[4.1440000000E+04, 3.4943691166E+01, 4.9158170329E+00, 1.8252843858E+01, 3.4864046725E+00, 9.7247842506E-01],
	[4.1445000000E+04, 3.4951079767E+01, 4.9158525615E+00, 1.8260051431E+01, 3.4867589657E+00, 9.7249050563E-01],
	[4.1450000000E+04, 3.4958469040E+01, 4.9158880859E+00, 1.8267260981E+01, 3.4871131686E+00, 9.7250258025E-01],
	[4.1455000000E+04, 3.4965858983E+01, 4.9159236064E+00, 1.8274472505E+01, 3.4874672813E+00, 9.7251464890E-01],
	[4.1460000000E+04, 3.4973249597E+01, 4.9159591228E+00, 1.8281686006E+01, 3.4878213038E+00, 9.7252671161E-01],
	[4.1465000000E+04, 3.4980640881E+01, 4.9159946352E+00, 1.8288901483E+01, 3.4881752362E+00, 9.7253876836E-01],
	[4.1470000000E+04, 3.4988032836E+01, 4.9160301436E+00, 1.8296118936E+01, 3.4885290784E+00, 9.7255081917E-01],
	[4.1475000000E+04, 3.4995425462E+01, 4.9160656480E+00, 1.8303338366E+01, 3.4888828305E+00, 9.7256286403E-01],
	[4.1480000000E+04, 3.5002818758E+01, 4.9161011483E+00, 1.8310559773E+01, 3.4892364926E+00, 9.7257490295E-01],
	[4.1485000000E+04, 3.5010212724E+01, 4.9161366446E+00, 1.8317783157E+01, 3.4895900645E+00, 9.7258693594E-01],
	[4.1490000000E+04, 3.5017607362E+01, 4.9161721369E+00, 1.8325008519E+01, 3.4899435464E+00, 9.7259896299E-01],
	[4.1495000000E+04, 3.5025002669E+01, 4.9162076252E+00, 1.8332235859E+01, 3.4902969382E+00, 9.7261098411E-01],
	[4.1500000000E+04, 3.5032398647E+01, 4.9162431094E+00, 1.8339465177E+01, 3.4906502401E+00, 9.7262299930E-01],
	[4.1505000000E+04, 3.5039795296E+01, 4.9162785896E+00, 1.8346696474E+01, 3.4910034519E+00, 9.7263500857E-01],
	[4.1510000000E+04, 3.5047192615E+01, 4.9163140658E+00, 1.8353929750E+01, 3.4913565738E+00, 9.7264701191E-01],
	[4.1515000000E+04, 3.5054590604E+01, 4.9163495380E+00, 1.8361165005E+01, 3.4917096057E+00, 9.7265900934E-01],
	[4.1520000000E+04, 3.5061989264E+01, 4.9163850062E+00, 1.8368402239E+01, 3.4920625477E+00, 9.7267100085E-01],
	[4.1525000000E+04, 3.5069388594E+01, 4.9164204704E+00, 1.8375641453E+01, 3.4924153998E+00, 9.7268298644E-01],
	[4.1530000000E+04, 3.5076788594E+01, 4.9164559305E+00, 1.8382882647E+01, 3.4927681620E+00, 9.7269496613E-01],
	[4.1535000000E+04, 3.5084189265E+01, 4.9164913866E+00, 1.8390125822E+01, 3.4931208343E+00, 9.7270693991E-01],
	[4.1540000000E+04, 3.5091590606E+01, 4.9165268388E+00, 1.8397370977E+01, 3.4934734168E+00, 9.7271890779E-01],
	[4.1545000000E+04, 3.5098992617E+01, 4.9165622869E+00, 1.8404618113E+01, 3.4938259094E+00, 9.7273086977E-01],
	[4.1550000000E+04, 3.5106395299E+01, 4.9165977310E+00, 1.8411867231E+01, 3.4941783123E+00, 9.7274282586E-01],
	[4.1555000000E+04, 3.5113798651E+01, 4.9166331711E+00, 1.8419118330E+01, 3.4945306253E+00, 9.7275477604E-01],
	[4.1560000000E+04, 3.5121202673E+01, 4.9166686071E+00, 1.8426371411E+01, 3.4948828486E+00, 9.7276672034E-01],
	[4.1565000000E+04, 3.5128607365E+01, 4.9167040392E+00, 1.8433626474E+01, 3.4952349822E+00, 9.7277865875E-01],
	[4.1570000000E+04, 3.5136012728E+01, 4.9167394673E+00, 1.8440883520E+01, 3.4955870260E+00, 9.7279059128E-01],
	[4.1575000000E+04, 3.5143418761E+01, 4.9167748913E+00, 1.8448142549E+01, 3.4959389802E+00, 9.7280251793E-01],
	[4.1580000000E+04, 3.5150825463E+01, 4.9168103114E+00, 1.8455403561E+01, 3.4962908446E+00, 9.7281443870E-01],
	[4.1585000000E+04, 3.5158232836E+01, 4.9168457274E+00, 1.8462666556E+01, 3.4966426194E+00, 9.7282635359E-01],
	[4.1590000000E+04, 3.5165640879E+01, 4.9168811395E+00, 1.8469931534E+01, 3.4969943046E+00, 9.7283826261E-01],
	[4.1595000000E+04, 3.5173049592E+01, 4.9169165475E+00, 1.8477198497E+01, 3.4973459001E+00, 9.7285016576E-01],
	[4.1600000000E+04, 3.5180458976E+01, 4.9169519516E+00, 1.8484467445E+01, 3.4976974061E+00, 9.7286206305E-01],
	[4.1605000000E+04, 3.5187869029E+01, 4.9169873516E+00, 1.8491738376E+01, 3.4980488225E+00, 9.7287395448E-01],
	[4.1610000000E+04, 3.5195279752E+01, 4.9170227477E+00, 1.8499011293E+01, 3.4984001493E+00, 9.7288584004E-01],
	[4.1615000000E+04, 3.5202691145E+01, 4.9170581397E+00, 1.8506286195E+01, 3.4987513866E+00, 9.7289771976E-01],
	[4.1620000000E+04, 3.5210103209E+01, 4.9170935278E+00, 1.8513563083E+01, 3.4991025344E+00, 9.7290959361E-01],
	[4.1625000000E+04, 3.5217515942E+01, 4.9171289118E+00, 1.8520841956E+01, 3.4994535927E+00, 9.7292146162E-01],
	[4.1630000000E+04, 3.5224929345E+01, 4.9171642919E+00, 1.8528122815E+01, 3.4998045615E+00, 9.7293332378E-01],
	[4.1635000000E+04, 3.5232343418E+01, 4.9171996680E+00, 1.8535405661E+01, 3.5001554409E+00, 9.7294518010E-01],
	[4.1640000000E+04, 3.5239758161E+01, 4.9172350400E+00, 1.8542690494E+01, 3.5005062308E+00, 9.7295703058E-01],
	[4.1645000000E+04, 3.5247173574E+01, 4.9172704081E+00, 1.8549977314E+01, 3.5008569314E+00, 9.7296887522E-01],
	[4.1650000000E+04, 3.5254589657E+01, 4.9173057722E+00, 1.8557266121E+01, 3.5012075425E+00, 9.7298071402E-01],
	[4.1655000000E+04, 3.5262006409E+01, 4.9173411323E+00, 1.8564556916E+01, 3.5015580643E+00, 9.7299254700E-01],
	[4.1660000000E+04, 3.5269423832E+01, 4.9173764884E+00, 1.8571849698E+01, 3.5019084968E+00, 9.7300437414E-01],
	[4.1665000000E+04, 3.5276841924E+01, 4.9174118405E+00, 1.8579144469E+01, 3.5022588399E+00, 9.7301619547E-01],
	[4.1670000000E+04, 3.5284260686E+01, 4.9174471886E+00, 1.8586441229E+01, 3.5026090937E+00, 9.7302801097E-01],
	[4.1675000000E+04, 3.5291680118E+01, 4.9174825328E+00, 1.8593739977E+01, 3.5029592583E+00, 9.7303982065E-01],
	[4.1680000000E+04, 3.5299100219E+01, 4.9175178729E+00, 1.8601040715E+01, 3.5033093335E+00, 9.7305162451E-01],
	[4.1685000000E+04, 3.5306520990E+01, 4.9175532091E+00, 1.8608343442E+01, 3.5036593196E+00, 9.7306342257E-01],
	[4.1690000000E+04, 3.5313942431E+01, 4.9175885413E+00, 1.8615648159E+01, 3.5040092164E+00, 9.7307521481E-01],
	[4.1695000000E+04, 3.5321364542E+01, 4.9176238695E+00, 1.8622954865E+01, 3.5043590240E+00, 9.7308700125E-01],
	[4.1700000000E+04, 3.5328787322E+01, 4.9176591937E+00, 1.8630263563E+01, 3.5047087425E+00, 9.7309878189E-01],
	[4.1705000000E+04, 3.5336210772E+01, 4.9176945139E+00, 1.8637574251E+01, 3.5050583718E+00, 9.7311055672E-01],
	[4.1710000000E+04, 3.5343634892E+01, 4.9177298302E+00, 1.8644886930E+01, 3.5054079120E+00, 9.7312232576E-01],
	[4.1715000000E+04, 3.5351059681E+01, 4.9177651425E+00, 1.8652201600E+01, 3.5057573630E+00, 9.7313408901E-01],
	[4.1720000000E+04, 3.5358485140E+01, 4.9178004508E+00, 1.8659518262E+01, 3.5061067250E+00, 9.7314584646E-01],
	[4.1725000000E+04, 3.5365911268E+01, 4.9178357551E+00, 1.8666836916E+01, 3.5064559979E+00, 9.7315759813E-01],
	[4.1730000000E+04, 3.5373338066E+01, 4.9178710554E+00, 1.8674157561E+01, 3.5068051817E+00, 9.7316934401E-01],
	[4.1735000000E+04, 3.5380765533E+01, 4.9179063518E+00, 1.8681480200E+01, 3.5071542765E+00, 9.7318108411E-01],
	[4.1740000000E+04, 3.5388193670E+01, 4.9179416442E+00, 1.8688804831E+01, 3.5075032823E+00, 9.7319281844E-01],
	[4.1745000000E+04, 3.5395622477E+01, 4.9179769326E+00, 1.8696131456E+01, 3.5078521991E+00, 9.7320454698E-01],
	[4.1750000000E+04, 3.5403051953E+01, 4.9180122171E+00, 1.8703460073E+01, 3.5082010270E+00, 9.7321626976E-01],
	[4.1755000000E+04, 3.5410482098E+01, 4.9180474975E+00, 1.8710790685E+01, 3.5085497659E+00, 9.7322798677E-01],
	[4.1760000000E+04, 3.5417912913E+01, 4.9180827740E+00, 1.8718123290E+01, 3.5088984158E+00, 9.7323969801E-01],
	[4.1765000000E+04, 3.5425344397E+01, 4.9181180466E+00, 1.8725457890E+01, 3.5092469769E+00, 9.7325140349E-01],
	[4.1770000000E+04, 3.5432776550E+01, 4.9181533151E+00, 1.8732794485E+01, 3.5095954491E+00, 9.7326310321E-01],
	[4.1775000000E+04, 3.5440209373E+01, 4.9181885797E+00, 1.8740133074E+01, 3.5099438324E+00, 9.7327479717E-01],
	[4.1780000000E+04, 3.5447642866E+01, 4.9182238404E+00, 1.8747473659E+01, 3.5102921269E+00, 9.7328648538E-01],
	[4.1785000000E+04, 3.5455077027E+01, 4.9182590970E+00, 1.8754816239E+01, 3.5106403326E+00, 9.7329816784E-01],
	[4.1790000000E+04, 3.5462511858E+01, 4.9182943497E+00, 1.8762160815E+01, 3.5109884495E+00, 9.7330984455E-01],
	[4.1795000000E+04, 3.5469947358E+01, 4.9183295984E+00, 1.8769507387E+01, 3.5113364776E+00, 9.7332151552E-01],
	[4.1800000000E+04, 3.5477383528E+01, 4.9183648432E+00, 1.8776855956E+01, 3.5116844169E+00, 9.7333318075E-01],
	[4.1805000000E+04, 3.5484820367E+01, 4.9184000840E+00, 1.8784206521E+01, 3.5120322675E+00, 9.7334484024E-01],
	[4.1810000000E+04, 3.5492257875E+01, 4.9184353208E+00, 1.8791559084E+01, 3.5123800294E+00, 9.7335649399E-01],
	[4.1815000000E+04, 3.5499696052E+01, 4.9184705537E+00, 1.8798913643E+01, 3.5127277026E+00, 9.7336814201E-01],
	[4.1820000000E+04, 3.5507134898E+01, 4.9185057826E+00, 1.8806270201E+01, 3.5130752871E+00, 9.7337978431E-01],
	[4.1825000000E+04, 3.5514574414E+01, 4.9185410076E+00, 1.8813628756E+01, 3.5134227830E+00, 9.7339142087E-01],
	[4.1830000000E+04, 3.5522030761E+01, 4.9185781307E+00, 1.8820989310E+01, 3.5137713191E+00, 9.7340305172E-01],
	[4.1835000000E+04, 3.5529487893E+01, 4.9186152625E+00, 1.8828351862E+01, 3.5141197745E+00, 9.7341467685E-01],
	[4.1840000000E+04, 3.5536945698E+01, 4.9186523902E+00, 1.8835716413E+01, 3.5144681415E+00, 9.7342629626E-01],
	[4.1845000000E+04, 3.5544404178E+01, 4.9186895137E+00, 1.8843082964E+01, 3.5148164202E+00, 9.7343790995E-01],
	[4.1850000000E+04, 3.5551863331E+01, 4.9187266330E+00, 1.8850451513E+01, 3.5151646106E+00, 9.7344951794E-01],
	[4.1855000000E+04, 3.5559323158E+01, 4.9187637482E+00, 1.8857822063E+01, 3.5155127127E+00, 9.7346112022E-01],
	[4.1860000000E+04, 3.5566783659E+01, 4.9188008593E+00, 1.8865194613E+01, 3.5158607266E+00, 9.7347271680E-01],
	[4.1865000000E+04, 3.5574244834E+01, 4.9188379662E+00, 1.8872569163E+01, 3.5162086521E+00, 9.7348430767E-01],
	[4.1870000000E+04, 3.5581706683E+01, 4.9188750689E+00, 1.8879945713E+01, 3.5165564895E+00, 9.7349589285E-01],
	[4.1875000000E+04, 3.5589169206E+01, 4.9189121675E+00, 1.8887324265E+01, 3.5169042386E+00, 9.7350747233E-01],
	[4.1880000000E+04, 3.5596632403E+01, 4.9189492620E+00, 1.8894704818E+01, 3.5172518996E+00, 9.7351904612E-01],
	[4.1885000000E+04, 3.5604096273E+01, 4.9189863523E+00, 1.8902087373E+01, 3.5175994724E+00, 9.7353061422E-01],
	[4.1890000000E+04, 3.5611560817E+01, 4.9190234384E+00, 1.8909471929E+01, 3.5179469570E+00, 9.7354217664E-01],
	[4.1895000000E+04, 3.5619026035E+01, 4.9190605204E+00, 1.8916858488E+01, 3.5182943535E+00, 9.7355373337E-01],
	[4.1900000000E+04, 3.5626491927E+01, 4.9190975983E+00, 1.8924247049E+01, 3.5186416619E+00, 9.7356528443E-01],
	[4.1905000000E+04, 3.5633958492E+01, 4.9191346720E+00, 1.8931637614E+01, 3.5189888822E+00, 9.7357682980E-01],
	[4.1910000000E+04, 3.5641425732E+01, 4.9191717415E+00, 1.8939030181E+01, 3.5193360145E+00, 9.7358836951E-01],
	[4.1915000000E+04, 3.5648893645E+01, 4.9192088070E+00, 1.8946424751E+01, 3.5196830587E+00, 9.7359990354E-01],
	[4.1920000000E+04, 3.5656362231E+01, 4.9192458683E+00, 1.8953821326E+01, 3.5200300149E+00, 9.7361143191E-01],
	[4.1925000000E+04, 3.5663831491E+01, 4.9192829254E+00, 1.8961219904E+01, 3.5203768831E+00, 9.7362295461E-01],
	[4.1930000000E+04, 3.5671301425E+01, 4.9193199784E+00, 1.8968620487E+01, 3.5207236633E+00, 9.7363447166E-01],
	[4.1935000000E+04, 3.5678772033E+01, 4.9193570273E+00, 1.8976023074E+01, 3.5210703556E+00, 9.7364598304E-01],
	[4.1940000000E+04, 3.5686243314E+01, 4.9193940720E+00, 1.8983427667E+01, 3.5214169599E+00, 9.7365748877E-01],
	[4.1945000000E+04, 3.5693715269E+01, 4.9194311126E+00, 1.8990834264E+01, 3.5217634763E+00, 9.7366898885E-01],
	[4.1950000000E+04, 3.5701187897E+01, 4.9194681490E+00, 1.8998242867E+01, 3.5221099048E+00, 9.7368048328E-01],
	[4.1955000000E+04, 3.5708661199E+01, 4.9195051813E+00, 1.9005653476E+01, 3.5224562454E+00, 9.7369197206E-01],
	[4.1960000000E+04, 3.5716135174E+01, 4.9195422095E+00, 1.9013066092E+01, 3.5228024982E+00, 9.7370345520E-01],
	[4.1965000000E+04, 3.5723609823E+01, 4.9195792336E+00, 1.9020480713E+01, 3.5231486631E+00, 9.7371493270E-01],
	[4.1970000000E+04, 3.5731085145E+01, 4.9196162535E+00, 1.9027897341E+01, 3.5234947402E+00, 9.7372640457E-01],
	[4.1975000000E+04, 3.5738561141E+01, 4.9196532693E+00, 1.9035315977E+01, 3.5238407295E+00, 9.7373787080E-01],
	[4.1980000000E+04, 3.5746037810E+01, 4.9196902809E+00, 1.9042736620E+01, 3.5241866311E+00, 9.7374933140E-01],
	[4.1985000000E+04, 3.5753515152E+01, 4.9197272884E+00, 1.9050159270E+01, 3.5245324449E+00, 9.7376078638E-01],
	[4.1990000000E+04, 3.5760993168E+01, 4.9197642918E+00, 1.9057583929E+01, 3.5248781710E+00, 9.7377223573E-01],
	[4.1995000000E+04, 3.5768471858E+01, 4.9198012911E+00, 1.9065010595E+01, 3.5252238094E+00, 9.7378367945E-01],
	[4.2000000000E+04, 3.5775951221E+01, 4.9198382862E+00, 1.9072439271E+01, 3.5255693600E+00, 9.7379511756E-01],
	[4.2005000000E+04, 3.5783431257E+01, 4.9198752773E+00, 1.9079869955E+01, 3.5259148230E+00, 9.7380655006E-01],
	[4.2010000000E+04, 3.5790911966E+01, 4.9199122641E+00, 1.9087302648E+01, 3.5262601984E+00, 9.7381797694E-01],
	[4.2015000000E+04, 3.5798393349E+01, 4.9199492469E+00, 1.9094737351E+01, 3.5266054862E+00, 9.7382939822E-01],
	[4.2020000000E+04, 3.5805875405E+01, 4.9199862256E+00, 1.9102174064E+01, 3.5269506863E+00, 9.7384081388E-01],
	[4.2025000000E+04, 3.5813358134E+01, 4.9200232001E+00, 1.9109612787E+01, 3.5272957988E+00, 9.7385222395E-01],
	[4.2030000000E+04, 3.5820841537E+01, 4.9200601705E+00, 1.9117053520E+01, 3.5276408238E+00, 9.7386362842E-01],
	[4.2035000000E+04, 3.5828325612E+01, 4.9200971368E+00, 1.9124496264E+01, 3.5279857613E+00, 9.7387502728E-01],
	[4.2040000000E+04, 3.5835810361E+01, 4.9201340989E+00, 1.9131941019E+01, 3.5283306112E+00, 9.7388642056E-01],
	[4.2045000000E+04, 3.5843295784E+01, 4.9201710570E+00, 1.9139387785E+01, 3.5286753736E+00, 9.7389780824E-01],
	[4.2050000000E+04, 3.5850781879E+01, 4.9202080109E+00, 1.9146836563E+01, 3.5290200486E+00, 9.7390919034E-01],
	[4.2055000000E+04, 3.5858268647E+01, 4.9202449607E+00, 1.9154287353E+01, 3.5293646361E+00, 9.7392056685E-01],
	[4.2060000000E+04, 3.5865756089E+01, 4.9202819064E+00, 1.9161740155E+01, 3.5297091361E+00, 9.7393193778E-01],
	[4.2065000000E+04, 3.5873244204E+01, 4.9203188480E+00, 1.9169194970E+01, 3.5300535488E+00, 9.7394330313E-01],
	[4.2070000000E+04, 3.5880732991E+01, 4.9203557854E+00, 1.9176651797E+01, 3.5303978740E+00, 9.7395466291E-01],
	[4.2075000000E+04, 3.5888222452E+01, 4.9203927188E+00, 1.9184110638E+01, 3.5307421119E+00, 9.7396601711E-01],
	[4.2080000000E+04, 3.5895712586E+01, 4.9204296480E+00, 1.9191571492E+01, 3.5310862624E+00, 9.7397736574E-01],
	[4.2085000000E+04, 3.5903203393E+01, 4.9204665732E+00, 1.9199034359E+01, 3.5314303256E+00, 9.7398870881E-01],
	[4.2090000000E+04, 3.5910694873E+01, 4.9205034942E+00, 1.9206499241E+01, 3.5317743014E+00, 9.7400004632E-01],
	[4.2095000000E+04, 3.5918187026E+01, 4.9205404111E+00, 1.9213966137E+01, 3.5321181900E+00, 9.7401137826E-01],
	[4.2100000000E+04, 3.5925679852E+01, 4.9205773239E+00, 1.9221435048E+01, 3.5324619913E+00, 9.7402270465E-01],
	[4.2105000000E+04, 3.5933173351E+01, 4.9206142326E+00, 1.9228905974E+01, 3.5328057054E+00, 9.7403402548E-01],
	[4.2110000000E+04, 3.5940667523E+01, 4.9206511372E+00, 1.9236378915E+01, 3.5331493322E+00, 9.7404534076E-01],
	[4.2115000000E+04, 3.5948162368E+01, 4.9206880377E+00, 1.9243853872E+01, 3.5334928718E+00, 9.7405665049E-01],
	[4.2120000000E+04, 3.5955657885E+01, 4.9207249341E+00, 1.9251330844E+01, 3.5338363243E+00, 9.7406795468E-01],
	[4.2125000000E+04, 3.5963154076E+01, 4.9207618263E+00, 1.9258809833E+01, 3.5341796895E+00, 9.7407925332E-01],
	[4.2130000000E+04, 3.5970650939E+01, 4.9207987145E+00, 1.9266290838E+01, 3.5345229677E+00, 9.7409054643E-01],
	[4.2135000000E+04, 3.5978148475E+01, 4.9208355986E+00, 1.9273773860E+01, 3.5348661587E+00, 9.7410183400E-01],
	[4.2140000000E+04, 3.5985646684E+01, 4.9208724786E+00, 1.9281258899E+01, 3.5352092626E+00, 9.7411311603E-01],
	[4.2145000000E+04, 3.5993145566E+01, 4.9209093545E+00, 1.9288745956E+01, 3.5355522794E+00, 9.7412439254E-01],
	[4.2150000000E+04, 3.6000645121E+01, 4.9209462262E+00, 1.9296235030E+01, 3.5358952091E+00, 9.7413566352E-01],
	[4.2155000000E+04, 3.6008145348E+01, 4.9209830939E+00, 1.9303726122E+01, 3.5362380518E+00, 9.7414692898E-01],
	[4.2160000000E+04, 3.6015646248E+01, 4.9210199575E+00, 1.9311219233E+01, 3.5365808075E+00, 9.7415818891E-01],
	[4.2165000000E+04, 3.6023147821E+01, 4.9210568170E+00, 1.9318714362E+01, 3.5369234762E+00, 9.7416944333E-01],
	[4.2170000000E+04, 3.6030650067E+01, 4.9210936724E+00, 1.9326211510E+01, 3.5372660579E+00, 9.7418069223E-01],
	[4.2175000000E+04, 3.6038152985E+01, 4.9211305237E+00, 1.9333710677E+01, 3.5376085527E+00, 9.7419193562E-01],
	[4.2180000000E+04, 3.6045656576E+01, 4.9211673709E+00, 1.9341211864E+01, 3.5379509605E+00, 9.7420317350E-01],
	[4.2185000000E+04, 3.6053160839E+01, 4.9212042140E+00, 1.9348715070E+01, 3.5382932814E+00, 9.7421440587E-01],
	[4.2190000000E+04, 3.6060665775E+01, 4.9212410530E+00, 1.9356220297E+01, 3.5386355154E+00, 9.7422563274E-01],
	[4.2195000000E+04, 3.6068171384E+01, 4.9212778880E+00, 1.9363727544E+01, 3.5389776626E+00, 9.7423685411E-01],
	[4.2200000000E+04, 3.6075677666E+01, 4.9213147188E+00, 1.9371236812E+01, 3.5393197229E+00, 9.7424806999E-01],
	[4.2205000000E+04, 3.6083184619E+01, 4.9213515456E+00, 1.9378748101E+01, 3.5396616963E+00, 9.7425928037E-01],
	[4.2210000000E+04, 3.6090692246E+01, 4.9213883683E+00, 1.9386261411E+01, 3.5400035830E+00, 9.7427048526E-01],
	[4.2215000000E+04, 3.6098200545E+01, 4.9214251869E+00, 1.9393776743E+01, 3.5403453828E+00, 9.7428168466E-01],
	[4.2220000000E+04, 3.6105709516E+01, 4.9214620014E+00, 1.9401294097E+01, 3.5406870959E+00, 9.7429287857E-01],
	[4.2225000000E+04, 3.6113219160E+01, 4.9214988118E+00, 1.9408813473E+01, 3.5410287222E+00, 9.7430406701E-01],
	[4.2230000000E+04, 3.6120729477E+01, 4.9215356181E+00, 1.9416334872E+01, 3.5413702618E+00, 9.7431524996E-01],
	[4.2235000000E+04, 3.6128240466E+01, 4.9215724204E+00, 1.9423858294E+01, 3.5417117148E+00, 9.7432642744E-01],
	[4.2240000000E+04, 3.6135752127E+01, 4.9216092185E+00, 1.9431383739E+01, 3.5420530810E+00, 9.7433759945E-01],
	[4.2245000000E+04, 3.6143264461E+01, 4.9216460126E+00, 1.9438911207E+01, 3.5423943605E+00, 9.7434876599E-01],
	[4.2250000000E+04, 3.6150777467E+01, 4.9216828026E+00, 1.9446440699E+01, 3.5427355534E+00, 9.7435992706E-01],
	[4.2255000000E+04, 3.6158291145E+01, 4.9217195886E+00, 1.9453972215E+01, 3.5430766597E+00, 9.7437108266E-01],
	[4.2260000000E+04, 3.6165805496E+01, 4.9217563704E+00, 1.9461505756E+01, 3.5434176794E+00, 9.7438223281E-01],
	[4.2265000000E+04, 3.6173320519E+01, 4.9217931482E+00, 1.9469041321E+01, 3.5437586125E+00, 9.7439337749E-01],
	[4.2270000000E+04, 3.6180836215E+01, 4.9218299219E+00, 1.9476578911E+01, 3.5440994591E+00, 9.7440451673E-01],
	[4.2275000000E+04, 3.6188352582E+01, 4.9218666915E+00, 1.9484118527E+01, 3.5444402191E+00, 9.7441565051E-01],
	[4.2280000000E+04, 3.6195869623E+01, 4.9219034571E+00, 1.9491660168E+01, 3.5447808926E+00, 9.7442677884E-01],
	[4.2285000000E+04, 3.6203387335E+01, 4.9219402185E+00, 1.9499203835E+01, 3.5451214796E+00, 9.7443790172E-01],
	[4.2290000000E+04, 3.6210905719E+01, 4.9219769760E+00, 1.9506749528E+01, 3.5454619801E+00, 9.7444901917E-01],
	[4.2295000000E+04, 3.6218424776E+01, 4.9220137293E+00, 1.9514297248E+01, 3.5458023941E+00, 9.7446013117E-01],
	[4.2300000000E+04, 3.6225944505E+01, 4.9220504786E+00, 1.9521846994E+01, 3.5461427218E+00, 9.7447123773E-01],
	[4.2305000000E+04, 3.6233464906E+01, 4.9220872238E+00, 1.9529398768E+01, 3.5464829630E+00, 9.7448233886E-01],
	[4.2310000000E+04, 3.6240985980E+01, 4.9221239649E+00, 1.9536952569E+01, 3.5468231178E+00, 9.7449343456E-01],
	[4.2315000000E+04, 3.6248507725E+01, 4.9221607019E+00, 1.9544508398E+01, 3.5471631863E+00, 9.7450452484E-01],
	[4.2320000000E+04, 3.6256030142E+01, 4.9221974349E+00, 1.9552066255E+01, 3.5475031684E+00, 9.7451560968E-01],
	[4.2325000000E+04, 3.6263553232E+01, 4.9222341639E+00, 1.9559626140E+01, 3.5478430641E+00, 9.7452668911E-01],
	[4.2330000000E+04, 3.6271076994E+01, 4.9222708887E+00, 1.9567188054E+01, 3.5481828736E+00, 9.7453776311E-01],
	[4.2335000000E+04, 3.6278601428E+01, 4.9223076095E+00, 1.9574751997E+01, 3.5485225968E+00, 9.7454883170E-01],
	[4.2340000000E+04, 3.6286126533E+01, 4.9223443263E+00, 1.9582317969E+01, 3.5488622337E+00, 9.7455989488E-01],
	[4.2345000000E+04, 3.6293652311E+01, 4.9223810389E+00, 1.9589885971E+01, 3.5492017843E+00, 9.7457095265E-01],
	[4.2350000000E+04, 3.6301178761E+01, 4.9224177476E+00, 1.9597456003E+01, 3.5495412488E+00, 9.7458200501E-01],
	[4.2355000000E+04, 3.6308705883E+01, 4.9224544521E+00, 1.9605028064E+01, 3.5498806270E+00, 9.7459305196E-01],
	[4.2360000000E+04, 3.6316233677E+01, 4.9224911526E+00, 1.9612602157E+01, 3.5502199190E+00, 9.7460409352E-01],
	[4.2365000000E+04, 3.6323762143E+01, 4.9225278490E+00, 1.9620178280E+01, 3.5505591249E+00, 9.7461512967E-01],
	[4.2370000000E+04, 3.6331291280E+01, 4.9225645414E+00, 1.9627756434E+01, 3.5508982447E+00, 9.7462616043E-01],
	[4.2375000000E+04, 3.6338821090E+01, 4.9226012298E+00, 1.9635336619E+01, 3.5512372783E+00, 9.7463718580E-01],
	[4.2380000000E+04, 3.6346351571E+01, 4.9226379140E+00, 1.9642918836E+01, 3.5515762258E+00, 9.7464820578E-01],
	[4.2385000000E+04, 3.6353882725E+01, 4.9226745942E+00, 1.9650503085E+01, 3.5519150872E+00, 9.7465922037E-01],
	[4.2390000000E+04, 3.6361414550E+01, 4.9227112704E+00, 1.9658089367E+01, 3.5522538626E+00, 9.7467022958E-01],
	[4.2395000000E+04, 3.6368947047E+01, 4.9227479425E+00, 1.9665677681E+01, 3.5525925520E+00, 9.7468123341E-01],
	[4.2400000000E+04, 3.6376480216E+01, 4.9227846106E+00, 1.9673268028E+01, 3.5529311553E+00, 9.7469223186E-01],
	[4.2405000000E+04, 3.6384014056E+01, 4.9228212746E+00, 1.9680860408E+01, 3.5532696726E+00, 9.7470322494E-01],
	[4.2410000000E+04, 3.6391548569E+01, 4.9228579345E+00, 1.9688454822E+01, 3.5536081040E+00, 9.7471421264E-01],
	[4.2415000000E+04, 3.6399083753E+01, 4.9228945904E+00, 1.9696051269E+01, 3.5539464494E+00, 9.7472519498E-01],
	[4.2420000000E+04, 3.6406619609E+01, 4.9229312423E+00, 1.9703649751E+01, 3.5542847089E+00, 9.7473617195E-01],
	[4.2425000000E+04, 3.6414156136E+01, 4.9229678901E+00, 1.9711250267E+01, 3.5546228825E+00, 9.7474714356E-01],
	[4.2430000000E+04, 3.6421693336E+01, 4.9230045339E+00, 1.9718852818E+01, 3.5549609701E+00, 9.7475810980E-01],
	[4.2435000000E+04, 3.6429231206E+01, 4.9230411736E+00, 1.9726457404E+01, 3.5552989719E+00, 9.7476907070E-01],
	[4.2440000000E+04, 3.6436769749E+01, 4.9230778093E+00, 1.9734064025E+01, 3.5556368879E+00, 9.7478002623E-01],
	[4.2445000000E+04, 3.6444308963E+01, 4.9231144409E+00, 1.9741672682E+01, 3.5559747180E+00, 9.7479097642E-01],
	[4.2450000000E+04, 3.6451848849E+01, 4.9231510685E+00, 1.9749283375E+01, 3.5563124623E+00, 9.7480192126E-01],
	[4.2455000000E+04, 3.6459389407E+01, 4.9231876920E+00, 1.9756896104E+01, 3.5566501209E+00, 9.7481286075E-01],
	[4.2460000000E+04, 3.6466930636E+01, 4.9232243115E+00, 1.9764510870E+01, 3.5569876936E+00, 9.7482379490E-01],
	[4.2465000000E+04, 3.6474472536E+01, 4.9232609270E+00, 1.9772127672E+01, 3.5573251807E+00, 9.7483472372E-01],
	[4.2470000000E+04, 3.6482015108E+01, 4.9232975384E+00, 1.9779746512E+01, 3.5576625820E+00, 9.7484564719E-01],
	[4.2475000000E+04, 3.6489558352E+01, 4.9233341458E+00, 1.9787367389E+01, 3.5579998976E+00, 9.7485656534E-01],
	[4.2480000000E+04, 3.6497102267E+01, 4.9233707492E+00, 1.9794990304E+01, 3.5583371275E+00, 9.7486747815E-01],
	[4.2485000000E+04, 3.6504646854E+01, 4.9234073485E+00, 1.9802615257E+01, 3.5586742717E+00, 9.7487838564E-01],
	[4.2490000000E+04, 3.6512192112E+01, 4.9234439438E+00, 1.9810242249E+01, 3.5590113303E+00, 9.7488928780E-01],
	[4.2495000000E+04, 3.6519738042E+01, 4.9234805351E+00, 1.9817871279E+01, 3.5593483033E+00, 9.7490018464E-01],
	[4.2500000000E+04, 3.6527289950E+01, 4.9235177367E+00, 1.9825502348E+01, 3.5596855623E+00, 9.7491107616E-01],
	[4.2505000000E+04, 3.6534853405E+01, 4.9235561928E+00, 1.9833135456E+01, 3.5600234970E+00, 9.7492196237E-01],
	[4.2510000000E+04, 3.6542417537E+01, 4.9235946446E+00, 1.9840770604E+01, 3.5603613464E+00, 9.7493284326E-01],
	[4.2515000000E+04, 3.6549982345E+01, 4.9236330923E+00, 1.9848407792E+01, 3.5606991104E+00, 9.7494371885E-01],
	[4.2520000000E+04, 3.6557547828E+01, 4.9236715357E+00, 1.9856047021E+01, 3.5610367892E+00, 9.7495458912E-01],
	[4.2525000000E+04, 3.6565113988E+01, 4.9237099749E+00, 1.9863688289E+01, 3.5613743826E+00, 9.7496545410E-01],
	[4.2530000000E+04, 3.6572680824E+01, 4.9237484098E+00, 1.9871331599E+01, 3.5617118908E+00, 9.7497631377E-01],
	[4.2535000000E+04, 3.6580248336E+01, 4.9237868406E+00, 1.9878976950E+01, 3.5620493138E+00, 9.7498716815E-01],
	[4.2540000000E+04, 3.6587816525E+01, 4.9238252671E+00, 1.9886624342E+01, 3.5623866516E+00, 9.7499801723E-01],
	[4.2545000000E+04, 3.6595385389E+01, 4.9238636894E+00, 1.9894273776E+01, 3.5627239041E+00, 9.7500886101E-01],
	[4.2550000000E+04, 3.6602954929E+01, 4.9239021075E+00, 1.9901925252E+01, 3.5630610715E+00, 9.7501969951E-01],
	[4.2555000000E+04, 3.6610525145E+01, 4.9239405214E+00, 1.9909578770E+01, 3.5633981538E+00, 9.7503053273E-01],
	[4.2560000000E+04, 3.6618096037E+01, 4.9239789311E+00, 1.9917234331E+01, 3.5637351509E+00, 9.7504136066E-01],
	[4.2565000000E+04, 3.6625667606E+01, 4.9240173366E+00, 1.9924891935E+01, 3.5640720629E+00, 9.7505218331E-01],
	[4.2570000000E+04, 3.6633239850E+01, 4.9240557378E+00, 1.9932551582E+01, 3.5644088898E+00, 9.7506300068E-01],
	[4.2575000000E+04, 3.6640812770E+01, 4.9240941349E+00, 1.9940213273E+01, 3.5647456317E+00, 9.7507381278E-01],
	[4.2580000000E+04, 3.6648386366E+01, 4.9241325277E+00, 1.9947877007E+01, 3.5650822885E+00, 9.7508461960E-01],
	[4.2585000000E+04, 3.6655960638E+01, 4.9241709163E+00, 1.9955542786E+01, 3.5654188603E+00, 9.7509542116E-01],
	[4.2590000000E+04, 3.6663535585E+01, 4.9242093007E+00, 1.9963210609E+01, 3.5657553470E+00, 9.7510621745E-01],
	[4.2595000000E+04, 3.6671111209E+01, 4.9242476810E+00, 1.9970880477E+01, 3.5660917488E+00, 9.7511700848E-01],
	[4.2600000000E+04, 3.6678687508E+01, 4.9242860570E+00, 1.9978552390E+01, 3.5664280656E+00, 9.7512779425E-01],
	[4.2605000000E+04, 3.6686264483E+01, 4.9243244288E+00, 1.9986226349E+01, 3.5667642975E+00, 9.7513857475E-01],
	[4.2610000000E+04, 3.6693842134E+01, 4.9243627963E+00, 1.9993902353E+01, 3.5671004444E+00, 9.7514935001E-01],
	[4.2615000000E+04, 3.6701420461E+01, 4.9244011597E+00, 2.0001580404E+01, 3.5674365065E+00, 9.7516012001E-01],
	[4.2620000000E+04, 3.6708999464E+01, 4.9244395189E+00, 2.0009260500E+01, 3.5677724837E+00, 9.7517088475E-01],
	[4.2625000000E+04, 3.6716579142E+01, 4.9244778739E+00, 2.0016942643E+01, 3.5681083760E+00, 9.7518164425E-01],
	[4.2630000000E+04, 3.6724159496E+01, 4.9245162247E+00, 2.0024626834E+01, 3.5684441834E+00, 9.7519239851E-01],
	[4.2635000000E+04, 3.6731740526E+01, 4.9245545713E+00, 2.0032313071E+01, 3.5687799061E+00, 9.7520314752E-01],
	[4.2640000000E+04, 3.6739322231E+01, 4.9245929137E+00, 2.0040001356E+01, 3.5691155439E+00, 9.7521389129E-01],
	[4.2645000000E+04, 3.6746904612E+01, 4.9246312519E+00, 2.0047691689E+01, 3.5694510970E+00, 9.7522462982E-01],
	[4.2650000000E+04, 3.6754487669E+01, 4.9246695859E+00, 2.0055384070E+01, 3.5697865653E+00, 9.7523536312E-01],
	[4.2655000000E+04, 3.6762071401E+01, 4.9247079157E+00, 2.0063078499E+01, 3.5701219489E+00, 9.7524609118E-01],
	[4.2660000000E+04, 3.6769655809E+01, 4.9247462413E+00, 2.0070774977E+01, 3.5704572477E+00, 9.7525681402E-01],
	[4.2665000000E+04, 3.6777240892E+01, 4.9247845627E+00, 2.0078473504E+01, 3.5707924619E+00, 9.7526753163E-01],
	[4.2670000000E+04, 3.6784826651E+01, 4.9248228799E+00, 2.0086174081E+01, 3.5711275914E+00, 9.7527824401E-01],
	[4.2675000000E+04, 3.6792413086E+01, 4.9248611929E+00, 2.0093876707E+01, 3.5714626362E+00, 9.7528895117E-01],
	[4.2680000000E+04, 3.6800000196E+01, 4.9248995018E+00, 2.0101581383E+01, 3.5717975964E+00, 9.7529965311E-01],
	[4.2685000000E+04, 3.6807587982E+01, 4.9249378064E+00, 2.0109288110E+01, 3.5721324720E+00, 9.7531034984E-01],
	[4.2690000000E+04, 3.6815176443E+01, 4.9249761069E+00, 2.0116996887E+01, 3.5724672630E+00, 9.7532104135E-01],
	[4.2695000000E+04, 3.6822765580E+01, 4.9250144032E+00, 2.0124707714E+01, 3.5728019695E+00, 9.7533172764E-01],
	[4.2700000000E+04, 3.6830355392E+01, 4.9250526952E+00, 2.0132420594E+01, 3.5731365913E+00, 9.7534240873E-01],
	[4.2705000000E+04, 3.6837945879E+01, 4.9250909831E+00, 2.0140135524E+01, 3.5734711287E+00, 9.7535308461E-01],
	[4.2710000000E+04, 3.6845537042E+01, 4.9251292669E+00, 2.0147852507E+01, 3.5738055815E+00, 9.7536375529E-01],
	[4.2715000000E+04, 3.6853128880E+01, 4.9251675464E+00, 2.0155571541E+01, 3.5741399499E+00, 9.7537442077E-01],
	[4.2720000000E+04, 3.6860721394E+01, 4.9252058217E+00, 2.0163292628E+01, 3.5744742338E+00, 9.7538508105E-01],
	[4.2725000000E+04, 3.6868314583E+01, 4.9252440929E+00, 2.0171015768E+01, 3.5748084332E+00, 9.7539573613E-01],
	[4.2730000000E+04, 3.6875908447E+01, 4.9252823599E+00, 2.0178740960E+01, 3.5751425483E+00, 9.7540638602E-01],
	[4.2735000000E+04, 3.6883502987E+01, 4.9253206227E+00, 2.0186468207E+01, 3.5754765789E+00, 9.7541703071E-01],
	[4.2740000000E+04, 3.6891098202E+01, 4.9253588813E+00, 2.0194197506E+01, 3.5758105251E+00, 9.7542767022E-01],
	[4.2745000000E+04, 3.6898694092E+01, 4.9253971357E+00, 2.0201928860E+01, 3.5761443870E+00, 9.7543830455E-01],
	[4.2750000000E+04, 3.6906290658E+01, 4.9254353860E+00, 2.0209662268E+01, 3.5764781645E+00, 9.7544893369E-01],
	[4.2755000000E+04, 3.6913887898E+01, 4.9254736321E+00, 2.0217397730E+01, 3.5768118577E+00, 9.7545955764E-01],
	[4.2760000000E+04, 3.6921485814E+01, 4.9255118740E+00, 2.0225135247E+01, 3.5771454666E+00, 9.7547017643E-01],
	[4.2765000000E+04, 3.6929084406E+01, 4.9255501118E+00, 2.0232874820E+01, 3.5774789913E+00, 9.7548079003E-01],
	[4.2770000000E+04, 3.6936683672E+01, 4.9255883453E+00, 2.0240616448E+01, 3.5778124316E+00, 9.7549139846E-01],
	[4.2775000000E+04, 3.6944283614E+01, 4.9256265747E+00, 2.0248360131E+01, 3.5781457878E+00, 9.7550200173E-01],
	[4.2780000000E+04, 3.6951884230E+01, 4.9256648000E+00, 2.0256105871E+01, 3.5784790597E+00, 9.7551259982E-01],
	[4.2785000000E+04, 3.6959485522E+01, 4.9257030210E+00, 2.0263853667E+01, 3.5788122474E+00, 9.7552319275E-01],
	[4.2790000000E+04, 3.6967087489E+01, 4.9257412379E+00, 2.0271603520E+01, 3.5791453510E+00, 9.7553378052E-01],
	[4.2795000000E+04, 3.6974690131E+01, 4.9257794506E+00, 2.0279355430E+01, 3.5794783703E+00, 9.7554436313E-01],
	[4.2800000000E+04, 3.6982293448E+01, 4.9258176591E+00, 2.0287109397E+01, 3.5798113056E+00, 9.7555494058E-01],
	[4.2805000000E+04, 3.6989897440E+01, 4.9258558635E+00, 2.0294865421E+01, 3.5801441567E+00, 9.7556551287E-01],
	[4.2810000000E+04, 3.6997502107E+01, 4.9258940637E+00, 2.0302623504E+01, 3.5804769238E+00, 9.7557608001E-01],
	[4.2815000000E+04, 3.7005107450E+01, 4.9259322598E+00, 2.0310383645E+01, 3.5808096068E+00, 9.7558664201E-01],
	[4.2820000000E+04, 3.7012713467E+01, 4.9259704517E+00, 2.0318145844E+01, 3.5811422057E+00, 9.7559719885E-01],
	[4.2825000000E+04, 3.7020320159E+01, 4.9260086394E+00, 2.0325910102E+01, 3.5814747206E+00, 9.7560775056E-01],
	[4.2830000000E+04, 3.7027927526E+01, 4.9260468230E+00, 2.0333676419E+01, 3.5818071515E+00, 9.7561829712E-01],
	[4.2835000000E+04, 3.7035535568E+01, 4.9260850023E+00, 2.0341444796E+01, 3.5821394984E+00, 9.7562883854E-01],
	[4.2840000000E+04, 3.7043144285E+01, 4.9261231776E+00, 2.0349215233E+01, 3.5824717613E+00, 9.7563937482E-01],
	[4.2845000000E+04, 3.7050753677E+01, 4.9261613487E+00, 2.0356987729E+01, 3.5828039403E+00, 9.7564990598E-01],
	[4.2850000000E+04, 3.7058363744E+01, 4.9261995156E+00, 2.0364762286E+01, 3.5831360353E+00, 9.7566043200E-01],
	[4.2855000000E+04, 3.7065974485E+01, 4.9262376783E+00, 2.0372538903E+01, 3.5834680465E+00, 9.7567095289E-01],
	[4.2860000000E+04, 3.7073585902E+01, 4.9262758369E+00, 2.0380317582E+01, 3.5837999738E+00, 9.7568146865E-01],
	[4.2865000000E+04, 3.7081197993E+01, 4.9263139914E+00, 2.0388098322E+01, 3.5841318172E+00, 9.7569197929E-01],
	[4.2870000000E+04, 3.7088810759E+01, 4.9263521417E+00, 2.0395881123E+01, 3.5844635767E+00, 9.7570248481E-01],
	[4.2875000000E+04, 3.7096424200E+01, 4.9263902878E+00, 2.0403665986E+01, 3.5847952524E+00, 9.7571298521E-01],
	[4.2880000000E+04, 3.7104038316E+01, 4.9264284298E+00, 2.0411452911E+01, 3.5851268444E+00, 9.7572348050E-01],
	[4.2885000000E+04, 3.7111653106E+01, 4.9264665676E+00, 2.0419241899E+01, 3.5854583525E+00, 9.7573397067E-01],
	[4.2890000000E+04, 3.7119268572E+01, 4.9265047013E+00, 2.0427032950E+01, 3.5857897769E+00, 9.7574445573E-01],
	[4.2895000000E+04, 3.7126884711E+01, 4.9265428309E+00, 2.0434826064E+01, 3.5861211176E+00, 9.7575493569E-01],
	[4.2900000000E+04, 3.7134501526E+01, 4.9265809562E+00, 2.0442621241E+01, 3.5864523745E+00, 9.7576541053E-01],
	[4.2905000000E+04, 3.7142119015E+01, 4.9266190775E+00, 2.0450418481E+01, 3.5867835477E+00, 9.7577588028E-01],
	[4.2910000000E+04, 3.7149737179E+01, 4.9266571946E+00, 2.0458217786E+01, 3.5871146373E+00, 9.7578634492E-01],
	[4.2915000000E+04, 3.7157356018E+01, 4.9266953075E+00, 2.0466019155E+01, 3.5874456432E+00, 9.7579680447E-01],
	[4.2920000000E+04, 3.7164975531E+01, 4.9267334163E+00, 2.0473822589E+01, 3.5877765655E+00, 9.7580725892E-01],
	[4.2925000000E+04, 3.7172595719E+01, 4.9267715210E+00, 2.0481628088E+01, 3.5881074041E+00, 9.7581770828E-01],
	[4.2930000000E+04, 3.7180216581E+01, 4.9268096215E+00, 2.0489435652E+01, 3.5884381592E+00, 9.7582815255E-01],
	[4.2935000000E+04, 3.7187838118E+01, 4.9268477178E+00, 2.0497245281E+01, 3.5887688306E+00, 9.7583859173E-01],
	[4.2940000000E+04, 3.7195460329E+01, 4.9268858101E+00, 2.0505056977E+01, 3.5890994186E+00, 9.7584902583E-01],
	[4.2945000000E+04, 3.7203083215E+01, 4.9269238981E+00, 2.0512870738E+01, 3.5894299230E+00, 9.7585945484E-01],
	[4.2950000000E+04, 3.7210706776E+01, 4.9269619821E+00, 2.0520686566E+01, 3.5897603438E+00, 9.7586987878E-01],
	[4.2955000000E+04, 3.7218331011E+01, 4.9270000619E+00, 2.0528504461E+01, 3.5900906812E+00, 9.7588029764E-01],
	[4.2960000000E+04, 3.7225955920E+01, 4.9270381376E+00, 2.0536324423E+01, 3.5904209352E+00, 9.7589071142E-01],
	[4.2965000000E+04, 3.7233581504E+01, 4.9270762091E+00, 2.0544146452E+01, 3.5907511056E+00, 9.7590112013E-01],
	[4.2970000000E+04, 3.7241207762E+01, 4.9271142765E+00, 2.0551970549E+01, 3.5910811927E+00, 9.7591152377E-01],
	[4.2975000000E+04, 3.7248834695E+01, 4.9271523397E+00, 2.0559796713E+01, 3.5914111963E+00, 9.7592192235E-01],
	[4.2980000000E+04, 3.7256462302E+01, 4.9271903989E+00, 2.0567624947E+01, 3.5917411166E+00, 9.7593231586E-01],
	[4.2985000000E+04, 3.7264090584E+01, 4.9272284539E+00, 2.0575455248E+01, 3.5920709534E+00, 9.7594270431E-01],
	[4.2990000000E+04, 3.7271719540E+01, 4.9272665047E+00, 2.0583287619E+01, 3.5924007070E+00, 9.7595308769E-01],
	[4.2995000000E+04, 3.7279349170E+01, 4.9273045514E+00, 2.0591122059E+01, 3.5927303772E+00, 9.7596346603E-01],
	[4.3000000000E+04, 3.7286979474E+01, 4.9273425940E+00, 2.0598958568E+01, 3.5930599641E+00, 9.7597383931E-01],
	[4.3005000000E+04, 3.7294610453E+01, 4.9273806325E+00, 2.0606797147E+01, 3.5933894677E+00, 9.7598420754E-01],
	[4.3010000000E+04, 3.7302242106E+01, 4.9274186668E+00, 2.0614637796E+01, 3.5937188881E+00, 9.7599457071E-01],
	[4.3015000000E+04, 3.7309874433E+01, 4.9274566970E+00, 2.0622480516E+01, 3.5940482252E+00, 9.7600492885E-01],
	[4.3020000000E+04, 3.7317507435E+01, 4.9274947231E+00, 2.0630325306E+01, 3.5943774791E+00, 9.7601528194E-01],
	[4.3025000000E+04, 3.7325141111E+01, 4.9275327451E+00, 2.0638172168E+01, 3.5947066498E+00, 9.7602562998E-01],
	[4.3030000000E+04, 3.7332775461E+01, 4.9275707629E+00, 2.0646021101E+01, 3.5950357373E+00, 9.7603597299E-01],
	[4.3035000000E+04, 3.7340410485E+01, 4.9276087766E+00, 2.0653872105E+01, 3.5953647417E+00, 9.7604631097E-01],
	[4.3040000000E+04, 3.7348046183E+01, 4.9276467862E+00, 2.0661725182E+01, 3.5956936629E+00, 9.7605664391E-01],
	[4.3045000000E+04, 3.7355682556E+01, 4.9276847917E+00, 2.0669580330E+01, 3.5960225010E+00, 9.7606697182E-01],
	[4.3050000000E+04, 3.7363319602E+01, 4.9277227930E+00, 2.0677437552E+01, 3.5963512560E+00, 9.7607729470E-01],
	[4.3055000000E+04, 3.7370957323E+01, 4.9277607902E+00, 2.0685296846E+01, 3.5966799280E+00, 9.7608761255E-01],
	[4.3060000000E+04, 3.7378595718E+01, 4.9277987833E+00, 2.0693158213E+01, 3.5970085168E+00, 9.7609792539E-01],
	[4.3065000000E+04, 3.7386234787E+01, 4.9278367723E+00, 2.0701021654E+01, 3.5973370227E+00, 9.7610823320E-01],
	[4.3070000000E+04, 3.7393874530E+01, 4.9278747572E+00, 2.0708887168E+01, 3.5976654455E+00, 9.7611853599E-01],
	[4.3075000000E+04, 3.7401514947E+01, 4.9279127379E+00, 2.0716754757E+01, 3.5979937853E+00, 9.7612883377E-01],
	[4.3080000000E+04, 3.7409156038E+01, 4.9279507146E+00, 2.0724624420E+01, 3.5983220422E+00, 9.7613912654E-01],
	[4.3085000000E+04, 3.7416797803E+01, 4.9279886871E+00, 2.0732496158E+01, 3.5986502161E+00, 9.7614941429E-01],
	[4.3090000000E+04, 3.7424440242E+01, 4.9280266555E+00, 2.0740369971E+01, 3.5989783071E+00, 9.7615969704E-01],
	[4.3095000000E+04, 3.7432083355E+01, 4.9280646198E+00, 2.0748245859E+01, 3.5993063152E+00, 9.7616997478E-01],
	[4.3100000000E+04, 3.7439727142E+01, 4.9281025800E+00, 2.0756123823E+01, 3.5996342403E+00, 9.7618024752E-01],
	[4.3105000000E+04, 3.7447371603E+01, 4.9281405360E+00, 2.0764003862E+01, 3.5999620827E+00, 9.7619051526E-01],
	[4.3110000000E+04, 3.7455016737E+01, 4.9281784880E+00, 2.0771885978E+01, 3.6002898421E+00, 9.7620077800E-01],
	[4.3115000000E+04, 3.7462662546E+01, 4.9282164358E+00, 2.0779770171E+01, 3.6006175188E+00, 9.7621103575E-01],
	[4.3120000000E+04, 3.7470309028E+01, 4.9282543796E+00, 2.0787656440E+01, 3.6009451126E+00, 9.7622128851E-01],
	[4.3125000000E+04, 3.7477956185E+01, 4.9282923192E+00, 2.0795544786E+01, 3.6012726236E+00, 9.7623153627E-01],
	[4.3130000000E+04, 3.7485604015E+01, 4.9283302547E+00, 2.0803435210E+01, 3.6016000519E+00, 9.7624177905E-01],
	[4.3135000000E+04, 3.7493252519E+01, 4.9283681862E+00, 2.0811327712E+01, 3.6019273975E+00, 9.7625201685E-01],
	[4.3140000000E+04, 3.7500901697E+01, 4.9284061135E+00, 2.0819222292E+01, 3.6022546603E+00, 9.7626224966E-01],
	[4.3145000000E+04, 3.7508551548E+01, 4.9284440367E+00, 2.0827118950E+01, 3.6025818404E+00, 9.7627247749E-01],
	[4.3150000000E+04, 3.7516202073E+01, 4.9284819558E+00, 2.0835017687E+01, 3.6029089378E+00, 9.7628270035E-01],
	[4.3155000000E+04, 3.7523853272E+01, 4.9285198708E+00, 2.0842918503E+01, 3.6032359526E+00, 9.7629291823E-01],
	[4.3160000000E+04, 3.7531505145E+01, 4.9285577817E+00, 2.0850821398E+01, 3.6035628847E+00, 9.7630313114E-01],
	[4.3165000000E+04, 3.7539157692E+01, 4.9285956885E+00, 2.0858726372E+01, 3.6038897342E+00, 9.7631333908E-01],
	[4.3170000000E+04, 3.7546810912E+01, 4.9286335912E+00, 2.0866633427E+01, 3.6042165011E+00, 9.7632354205E-01],
	[4.3175000000E+04, 3.7554464805E+01, 4.9286714898E+00, 2.0874542562E+01, 3.6045431854E+00, 9.7633374006E-01],
	[4.3180000000E+04, 3.7562119373E+01, 4.9287093843E+00, 2.0882453777E+01, 3.6048697872E+00, 9.7634393310E-01],
	[4.3185000000E+04, 3.7569782574E+01, 4.9287481813E+00, 2.0890367074E+01, 3.6051968648E+00, 9.7635412119E-01],
	[4.3190000000E+04, 3.7577454578E+01, 4.9287878994E+00, 2.0898282451E+01, 3.6055244299E+00, 9.7636430432E-01],
	[4.3195000000E+04, 3.7585127259E+01, 4.9288276132E+00, 2.0906199910E+01, 3.6058519127E+00, 9.7637448250E-01],
	[4.3200000000E+04, 3.7592800619E+01, 4.9288673227E+00, 2.0914119450E+01, 3.6061793133E+00, 9.7638465573E-01],
	[4.3205000000E+04, 3.7600474657E+01, 4.9289070280E+00, 2.0922041073E+01, 3.6065066316E+00, 9.7639482401E-01],
	[4.3210000000E+04, 3.7608149374E+01, 4.9289467290E+00, 2.0929964778E+01, 3.6068338677E+00, 9.7640498734E-01],
	[4.3215000000E+04, 3.7615824768E+01, 4.9289864256E+00, 2.0937890565E+01, 3.6071610215E+00, 9.7641514573E-01],
	[4.3220000000E+04, 3.7623500841E+01, 4.9290261181E+00, 2.0945818436E+01, 3.6074880932E+00, 9.7642529917E-01],
	[4.3225000000E+04, 3.7631177592E+01, 4.9290658062E+00, 2.0953748389E+01, 3.6078150827E+00, 9.7643544768E-01],
	[4.3230000000E+04, 3.7638855021E+01, 4.9291054901E+00, 2.0961680427E+01, 3.6081419900E+00, 9.7644559125E-01],
	[4.3235000000E+04, 3.7646533128E+01, 4.9291451697E+00, 2.0969614548E+01, 3.6084688153E+00, 9.7645572989E-01],
	[4.3240000000E+04, 3.7654211914E+01, 4.9291848451E+00, 2.0977550754E+01, 3.6087955584E+00, 9.7646586360E-01],
	[4.3245000000E+04, 3.7661891377E+01, 4.9292245161E+00, 2.0985489044E+01, 3.6091222194E+00, 9.7647599238E-01],
	[4.3250000000E+04, 3.7669571519E+01, 4.9292641829E+00, 2.0993429418E+01, 3.6094487984E+00, 9.7648611623E-01],
	[4.3255000000E+04, 3.7677252338E+01, 4.9293038455E+00, 2.1001371878E+01, 3.6097752953E+00, 9.7649623516E-01],
	[4.3260000000E+04, 3.7684933836E+01, 4.9293435037E+00, 2.1009316423E+01, 3.6101017102E+00, 9.7650634917E-01],
	[4.3265000000E+04, 3.7692616012E+01, 4.9293831578E+00, 2.1017263054E+01, 3.6104280430E+00, 9.7651645826E-01],
	[4.3270000000E+04, 3.7700298866E+01, 4.9294228075E+00, 2.1025211771E+01, 3.6107542939E+00, 9.7652656243E-01],
	[4.3275000000E+04, 3.7707982397E+01, 4.9294624530E+00, 2.1033162575E+01, 3.6110804629E+00, 9.7653666169E-01],
	[4.3280000000E+04, 3.7715666607E+01, 4.9295020942E+00, 2.1041115465E+01, 3.6114065499E+00, 9.7654675605E-01],
	[4.3285000000E+04, 3.7723351494E+01, 4.9295417312E+00, 2.1049070442E+01, 3.6117325549E+00, 9.7655684549E-01],
	[4.3290000000E+04, 3.7731037060E+01, 4.9295813639E+00, 2.1057027506E+01, 3.6120584781E+00, 9.7656693003E-01],
	[4.3295000000E+04, 3.7738723303E+01, 4.9296209923E+00, 2.1064986658E+01, 3.6123843194E+00, 9.7657700966E-01],
	[4.3300000000E+04, 3.7746410225E+01, 4.9296606165E+00, 2.1072947897E+01, 3.6127100788E+00, 9.7658708440E-01],
	[4.3305000000E+04, 3.7754097824E+01, 4.9297002364E+00, 2.1080911225E+01, 3.6130357564E+00, 9.7659715423E-01],
	[4.3310000000E+04, 3.7761786101E+01, 4.9297398521E+00, 2.1088876641E+01, 3.6133613522E+00, 9.7660721917E-01],
	[4.3315000000E+04, 3.7769475056E+01, 4.9297794635E+00, 2.1096844147E+01, 3.6136868661E+00, 9.7661727922E-01],
	[4.3320000000E+04, 3.7777164689E+01, 4.9298190707E+00, 2.1104813741E+01, 3.6140122983E+00, 9.7662733438E-01],
	[4.3325000000E+04, 3.7784854999E+01, 4.9298586736E+00, 2.1112785424E+01, 3.6143376488E+00, 9.7663738465E-01],
	[4.3330000000E+04, 3.7792545988E+01, 4.9298982723E+00, 2.1120759198E+01, 3.6146629174E+00, 9.7664743003E-01],
	[4.3335000000E+04, 3.7800237654E+01, 4.9299378667E+00, 2.1128735061E+01, 3.6149881044E+00, 9.7665747054E-01],
	[4.3340000000E+04, 3.7807929998E+01, 4.9299774568E+00, 2.1136713014E+01, 3.6153132097E+00, 9.7666750616E-01],
	[4.3345000000E+04, 3.7815623019E+01, 4.9300170427E+00, 2.1144693059E+01, 3.6156382333E+00, 9.7667753690E-01],
	[4.3350000000E+04, 3.7823316719E+01, 4.9300566244E+00, 2.1152675194E+01, 3.6159631752E+00, 9.7668756277E-01],
	[4.3355000000E+04, 3.7831011095E+01, 4.9300962018E+00, 2.1160659420E+01, 3.6162880355E+00, 9.7669758377E-01],
	[4.3360000000E+04, 3.7838706150E+01, 4.9301357750E+00, 2.1168645738E+01, 3.6166128142E+00, 9.7670759990E-01],
	[4.3365000000E+04, 3.7846401882E+01, 4.9301753439E+00, 2.1176634148E+01, 3.6169375113E+00, 9.7671761115E-01],
	[4.3370000000E+04, 3.7854098292E+01, 4.9302149086E+00, 2.1184624649E+01, 3.6172621269E+00, 9.7672761755E-01],
	[4.3375000000E+04, 3.7861795380E+01, 4.9302544690E+00, 2.1192617244E+01, 3.6175866609E+00, 9.7673761908E-01],
	[4.3380000000E+04, 3.7869493145E+01, 4.9302940252E+00, 2.1200611931E+01, 3.6179111133E+00, 9.7674761575E-01],
	[4.3385000000E+04, 3.7877191588E+01, 4.9303335771E+00, 2.1208608711E+01, 3.6182354842E+00, 9.7675760757E-01],
	[4.3390000000E+04, 3.7884890708E+01, 4.9303731248E+00, 2.1216607585E+01, 3.6185597737E+00, 9.7676759453E-01],
	[4.3395000000E+04, 3.7892590506E+01, 4.9304126683E+00, 2.1224608552E+01, 3.6188839816E+00, 9.7677757664E-01],
	[4.3400000000E+04, 3.7900290982E+01, 4.9304522075E+00, 2.1232611613E+01, 3.6192081082E+00, 9.7678755390E-01],
	[4.3405000000E+04, 3.7907992134E+01, 4.9304917425E+00, 2.1240616769E+01, 3.6195321533E+00, 9.7679752631E-01],
	[4.3410000000E+04, 3.7915693965E+01, 4.9305312733E+00, 2.1248624019E+01, 3.6198561169E+00, 9.7680749387E-01],
	[4.3415000000E+04, 3.7923396473E+01, 4.9305707998E+00, 2.1256633364E+01, 3.6201799992E+00, 9.7681745660E-01],
	[4.3420000000E+04, 3.7931099658E+01, 4.9306103221E+00, 2.1264644804E+01, 3.6205038002E+00, 9.7682741448E-01],
	[4.3425000000E+04, 3.7938803521E+01, 4.9306498401E+00, 2.1272658340E+01, 3.6208275197E+00, 9.7683736753E-01],
	[4.3430000000E+04, 3.7946508061E+01, 4.9306893539E+00, 2.1280673971E+01, 3.6211511580E+00, 9.7684731574E-01],
	[4.3435000000E+04, 3.7954213278E+01, 4.9307288635E+00, 2.1288691699E+01, 3.6214747149E+00, 9.7685725912E-01],
	[4.3440000000E+04, 3.7961919173E+01, 4.9307683689E+00, 2.1296711523E+01, 3.6217981906E+00, 9.7686719767E-01],
	[4.3445000000E+04, 3.7969625746E+01, 4.9308078700E+00, 2.1304733444E+01, 3.6221215850E+00, 9.7687713140E-01],
	[4.3450000000E+04, 3.7977332995E+01, 4.9308473669E+00, 2.1312757462E+01, 3.6224448981E+00, 9.7688706030E-01],
	[4.3455000000E+04, 3.7985040922E+01, 4.9308868595E+00, 2.1320783578E+01, 3.6227681301E+00, 9.7689698438E-01],
	[4.3460000000E+04, 3.7992749527E+01, 4.9309263480E+00, 2.1328811791E+01, 3.6230912808E+00, 9.7690690364E-01],
	[4.3465000000E+04, 3.8000458808E+01, 4.9309658322E+00, 2.1336842102E+01, 3.6234143503E+00, 9.7691681808E-01],
	[4.3470000000E+04, 3.8008168767E+01, 4.9310053122E+00, 2.1344874511E+01, 3.6237373387E+00, 9.7692672770E-01],
	[4.3475000000E+04, 3.8015879403E+01, 4.9310447879E+00, 2.1352909019E+01, 3.6240602459E+00, 9.7693663252E-01],
	[4.3480000000E+04, 3.8023590716E+01, 4.9310842595E+00, 2.1360945625E+01, 3.6243830720E+00, 9.7694653253E-01],
	[4.3485000000E+04, 3.8031302707E+01, 4.9311237268E+00, 2.1368984331E+01, 3.6247058170E+00, 9.7695642773E-01],
	[4.3490000000E+04, 3.8039015375E+01, 4.9311631899E+00, 2.1377025137E+01, 3.6250284810E+00, 9.7696631812E-01],
	[4.3495000000E+04, 3.8046728719E+01, 4.9312026487E+00, 2.1385068042E+01, 3.6253510638E+00, 9.7697620371E-01],
	[4.3500000000E+04, 3.8054442742E+01, 4.9312421034E+00, 2.1393113047E+01, 3.6256735657E+00, 9.7698608451E-01],
	[4.3505000000E+04, 3.8062157441E+01, 4.9312815538E+00, 2.1401160153E+01, 3.6259959865E+00, 9.7699596051E-01],
	[4.3510000000E+04, 3.8069872817E+01, 4.9313210000E+00, 2.1409209360E+01, 3.6263183263E+00, 9.7700583171E-01],
	[4.3515000000E+04, 3.8077588870E+01, 4.9313604420E+00, 2.1417260667E+01, 3.6266405851E+00, 9.7701569812E-01],
	[4.3520000000E+04, 3.8085305601E+01, 4.9313998798E+00, 2.1425314076E+01, 3.6269627630E+00, 9.7702555974E-01],
	[4.3525000000E+04, 3.8093023009E+01, 4.9314393134E+00, 2.1433369587E+01, 3.6272848600E+00, 9.7703541658E-01],
	[4.3530000000E+04, 3.8100741093E+01, 4.9314787427E+00, 2.1441427199E+01, 3.6276068760E+00, 9.7704526863E-01],
	[4.3535000000E+04, 3.8108459855E+01, 4.9315181678E+00, 2.1449486914E+01, 3.6279288111E+00, 9.7705511590E-01],
	[4.3540000000E+04, 3.8116179293E+01, 4.9315575888E+00, 2.1457548731E+01, 3.6282506654E+00, 9.7706495839E-01],
	[4.3545000000E+04, 3.8123899409E+01, 4.9315970055E+00, 2.1465612651E+01, 3.6285724388E+00, 9.7707479610E-01],
	[4.3550000000E+04, 3.8131620202E+01, 4.9316364180E+00, 2.1473678675E+01, 3.6288941313E+00, 9.7708462904E-01],
	[4.3555000000E+04, 3.8139341671E+01, 4.9316758263E+00, 2.1481746802E+01, 3.6292157431E+00, 9.7709445721E-01],
	[4.3560000000E+04, 3.8147063818E+01, 4.9317152303E+00, 2.1489817032E+01, 3.6295372740E+00, 9.7710428061E-01],
	[4.3565000000E+04, 3.8154786641E+01, 4.9317546302E+00, 2.1497889367E+01, 3.6298587242E+00, 9.7711409924E-01],
	[4.3570000000E+04, 3.8162510142E+01, 4.9317940259E+00, 2.1505963806E+01, 3.6301800937E+00, 9.7712391311E-01],
	[4.3575000000E+04, 3.8170234319E+01, 4.9318334173E+00, 2.1514040350E+01, 3.6305013824E+00, 9.7713372221E-01],
	[4.3580000000E+04, 3.8177959173E+01, 4.9318728046E+00, 2.1522118999E+01, 3.6308225904E+00, 9.7714352656E-01],
	[4.3585000000E+04, 3.8185684704E+01, 4.9319121876E+00, 2.1530199754E+01, 3.6311437177E+00, 9.7715332615E-01],
	[4.3590000000E+04, 3.8193410912E+01, 4.9319515665E+00, 2.1538282613E+01, 3.6314647643E+00, 9.7716312099E-01],
	[4.3595000000E+04, 3.8201137796E+01, 4.9319909411E+00, 2.1546367579E+01, 3.6317857303E+00, 9.7717291107E-01],
	[4.3600000000E+04, 3.8208865358E+01, 4.9320303116E+00, 2.1554454651E+01, 3.6321066156E+00, 9.7718269641E-01],
	[4.3605000000E+04, 3.8216593596E+01, 4.9320696778E+00, 2.1562543830E+01, 3.6324274204E+00, 9.7719247700E-01],
	[4.3610000000E+04, 3.8224322511E+01, 4.9321090399E+00, 2.1570635116E+01, 3.6327481445E+00, 9.7720225284E-01],
	[4.3615000000E+04, 3.8232052102E+01, 4.9321483977E+00, 2.1578728508E+01, 3.6330687881E+00, 9.7721202395E-01],
	[4.3620000000E+04, 3.8239782370E+01, 4.9321877514E+00, 2.1586824008E+01, 3.6333893511E+00, 9.7722179031E-01],
	[4.3625000000E+04, 3.8247513316E+01, 4.9322271008E+00, 2.1594921616E+01, 3.6337098336E+00, 9.7723155194E-01],
	[4.3630000000E+04, 3.8255244937E+01, 4.9322664461E+00, 2.1603021332E+01, 3.6340302356E+00, 9.7724130883E-01],
	[4.3635000000E+04, 3.8262977236E+01, 4.9323057871E+00, 2.1611123157E+01, 3.6343505572E+00, 9.7725106099E-01],
	[4.3640000000E+04, 3.8270710211E+01, 4.9323451240E+00, 2.1619227090E+01, 3.6346707982E+00, 9.7726080843E-01],
	[4.3645000000E+04, 3.8278443862E+01, 4.9323844567E+00, 2.1627333132E+01, 3.6349909588E+00, 9.7727055113E-01],
	[4.3650000000E+04, 3.8286178191E+01, 4.9324237851E+00, 2.1635441284E+01, 3.6353110390E+00, 9.7728028912E-01],
	[4.3655000000E+04, 3.8293913195E+01, 4.9324631094E+00, 2.1643551545E+01, 3.6356310388E+00, 9.7729002238E-01],
	[4.3660000000E+04, 3.8301648877E+01, 4.9325024295E+00, 2.1651663916E+01, 3.6359509582E+00, 9.7729975092E-01],
	[4.3665000000E+04, 3.8309385235E+01, 4.9325417454E+00, 2.1659778397E+01, 3.6362707972E+00, 9.7730947474E-01],
	[4.3670000000E+04, 3.8317122269E+01, 4.9325810572E+00, 2.1667894989E+01, 3.6365905559E+00, 9.7731919386E-01],
	[4.3675000000E+04, 3.8324859980E+01, 4.9326203647E+00, 2.1676013692E+01, 3.6369102343E+00, 9.7732890825E-01],
	[4.3680000000E+04, 3.8332598368E+01, 4.9326596680E+00, 2.1684134505E+01, 3.6372298323E+00, 9.7733861794E-01],
	[4.3685000000E+04, 3.8340337432E+01, 4.9326989672E+00, 2.1692257431E+01, 3.6375493501E+00, 9.7734832293E-01],
	[4.3690000000E+04, 3.8348077172E+01, 4.9327382622E+00, 2.1700382468E+01, 3.6378687876E+00, 9.7735802321E-01],
	[4.3695000000E+04, 3.8355817589E+01, 4.9327775530E+00, 2.1708509617E+01, 3.6381881449E+00, 9.7736771878E-01],
	[4.3700000000E+04, 3.8363558682E+01, 4.9328168396E+00, 2.1716638879E+01, 3.6385074220E+00, 9.7737740966E-01],
	[4.3705000000E+04, 3.8371300452E+01, 4.9328561220E+00, 2.1724770253E+01, 3.6388266189E+00, 9.7738709584E-01],
	[4.3710000000E+04, 3.8379042898E+01, 4.9328954003E+00, 2.1732903740E+01, 3.6391457355E+00, 9.7739677733E-01],
	[4.3715000000E+04, 3.8386786021E+01, 4.9329346743E+00, 2.1741039341E+01, 3.6394647721E+00, 9.7740645413E-01],
	[4.3720000000E+04, 3.8394529820E+01, 4.9329739442E+00, 2.1749177055E+01, 3.6397837285E+00, 9.7741612623E-01],
	[4.3725000000E+04, 3.8402274295E+01, 4.9330132099E+00, 2.1757316883E+01, 3.6401026047E+00, 9.7742579365E-01],
	[4.3730000000E+04, 3.8410019446E+01, 4.9330524715E+00, 2.1765458825E+01, 3.6404214009E+00, 9.7743545639E-01],
	[4.3735000000E+04, 3.8417765274E+01, 4.9330917288E+00, 2.1773602882E+01, 3.6407401170E+00, 9.7744511444E-01],
	[4.3740000000E+04, 3.8425511778E+01, 4.9331309820E+00, 2.1781749054E+01, 3.6410587531E+00, 9.7745476782E-01],
	[4.3745000000E+04, 3.8433258958E+01, 4.9331702310E+00, 2.1789897340E+01, 3.6413773091E+00, 9.7746441652E-01],
	[4.3750000000E+04, 3.8441006815E+01, 4.9332094758E+00, 2.1798047743E+01, 3.6416957851E+00, 9.7747406054E-01],
	[4.3755000000E+04, 3.8448755348E+01, 4.9332487165E+00, 2.1806200261E+01, 3.6420141811E+00, 9.7748369989E-01],
	[4.3760000000E+04, 3.8456504557E+01, 4.9332879530E+00, 2.1814354895E+01, 3.6423324971E+00, 9.7749333457E-01],
	[4.3765000000E+04, 3.8464254442E+01, 4.9333271853E+00, 2.1822511645E+01, 3.6426507332E+00, 9.7750296459E-01],
	[4.3770000000E+04, 3.8472005003E+01, 4.9333664134E+00, 2.1830670513E+01, 3.6429688893E+00, 9.7751258994E-01],
	[4.3775000000E+04, 3.8479756241E+01, 4.9334056374E+00, 2.1838831497E+01, 3.6432869655E+00, 9.7752221063E-01],
	[4.3780000000E+04, 3.8487508154E+01, 4.9334448572E+00, 2.1846994598E+01, 3.6436049618E+00, 9.7753182665E-01],
	[4.3785000000E+04, 3.8495260744E+01, 4.9334840729E+00, 2.1855159817E+01, 3.6439228783E+00, 9.7754143803E-01],
	[4.3790000000E+04, 3.8503014010E+01, 4.9335232844E+00, 2.1863327154E+01, 3.6442407149E+00, 9.7755104474E-01],
	[4.3795000000E+04, 3.8510767952E+01, 4.9335624917E+00, 2.1871496609E+01, 3.6445584717E+00, 9.7756064681E-01],
	[4.3800000000E+04, 3.8518522570E+01, 4.9336016948E+00, 2.1879668183E+01, 3.6448761487E+00, 9.7757024423E-01],
	[4.3805000000E+04, 3.8526277864E+01, 4.9336408938E+00, 2.1887841876E+01, 3.6451937458E+00, 9.7757983699E-01],
	[4.3810000000E+04, 3.8534033834E+01, 4.9336800886E+00, 2.1896017688E+01, 3.6455112632E+00, 9.7758942512E-01],
	[4.3815000000E+04, 3.8541790480E+01, 4.9337192793E+00, 2.1904195619E+01, 3.6458287009E+00, 9.7759900860E-01],
	[4.3820000000E+04, 3.8549547802E+01, 4.9337584658E+00, 2.1912375670E+01, 3.6461460588E+00, 9.7760858744E-01],
	[4.3825000000E+04, 3.8557305800E+01, 4.9337976481E+00, 2.1920557841E+01, 3.6464633371E+00, 9.7761816165E-01],
	[4.3830000000E+04, 3.8565064474E+01, 4.9338368263E+00, 2.1928742132E+01, 3.6467805356E+00, 9.7762773122E-01],
	[4.3835000000E+04, 3.8572823824E+01, 4.9338760003E+00, 2.1936928544E+01, 3.6470976545E+00, 9.7763729615E-01],
	[4.3840000000E+04, 3.8580583850E+01, 4.9339151702E+00, 2.1945117077E+01, 3.6474146937E+00, 9.7764685646E-01],
	[4.3845000000E+04, 3.8588344551E+01, 4.9339543359E+00, 2.1953307731E+01, 3.6477316533E+00, 9.7765641214E-01],
	[4.3850000000E+04, 3.8596105929E+01, 4.9339934974E+00, 2.1961500507E+01, 3.6480485333E+00, 9.7766596320E-01],
	[4.3855000000E+04, 3.8603867982E+01, 4.9340326548E+00, 2.1969695405E+01, 3.6483653337E+00, 9.7767550963E-01],
	[4.3860000000E+04, 3.8611630711E+01, 4.9340718081E+00, 2.1977892425E+01, 3.6486820545E+00, 9.7768505145E-01],
	[4.3865000000E+04, 3.8619394117E+01, 4.9341109572E+00, 2.1986091567E+01, 3.6489986958E+00, 9.7769458864E-01],
	[4.3870000000E+04, 3.8627158197E+01, 4.9341501021E+00, 2.1994292833E+01, 3.6493152575E+00, 9.7770412122E-01],
	[4.3875000000E+04, 3.8634922954E+01, 4.9341892429E+00, 2.2002496221E+01, 3.6496317398E+00, 9.7771364919E-01],
	[4.3880000000E+04, 3.8642695723E+01, 4.9342292018E+00, 2.2010701733E+01, 3.6499486579E+00, 9.7772317255E-01],
	[4.3885000000E+04, 3.8650477821E+01, 4.9342701258E+00, 2.2018909369E+01, 3.6502661044E+00, 9.7773269130E-01],
	[4.3890000000E+04, 3.8658260599E+01, 4.9343110455E+00, 2.2027119129E+01, 3.6505834716E+00, 9.7774220544E-01],
	[4.3895000000E+04, 3.8666044058E+01, 4.9343519609E+00, 2.2035331013E+01, 3.6509007596E+00, 9.7775171499E-01],
	[4.3900000000E+04, 3.8673828197E+01, 4.9343928720E+00, 2.2043545022E+01, 3.6512179683E+00, 9.7776121993E-01],
	[4.3905000000E+04, 3.8681613016E+01, 4.9344337788E+00, 2.2051761155E+01, 3.6515350979E+00, 9.7777072027E-01],
	[4.3910000000E+04, 3.8689398515E+01, 4.9344746812E+00, 2.2059979414E+01, 3.6518521483E+00, 9.7778021602E-01],
	[4.3915000000E+04, 3.8697184695E+01, 4.9345155794E+00, 2.2068199799E+01, 3.6521691195E+00, 9.7778970718E-01],
	[4.3920000000E+04, 3.8704971555E+01, 4.9345564732E+00, 2.2076422310E+01, 3.6524860116E+00, 9.7779919374E-01],
	[4.3925000000E+04, 3.8712759095E+01, 4.9345973626E+00, 2.2084646946E+01, 3.6528028246E+00, 9.7780867572E-01],
	[4.3930000000E+04, 3.8720547315E+01, 4.9346382478E+00, 2.2092873709E+01, 3.6531195585E+00, 9.7781815311E-01],
	[4.3935000000E+04, 3.8728336216E+01, 4.9346791287E+00, 2.2101102600E+01, 3.6534362133E+00, 9.7782762592E-01],
	[4.3940000000E+04, 3.8736125797E+01, 4.9347200052E+00, 2.2109333617E+01, 3.6537527891E+00, 9.7783709415E-01],
	[4.3945000000E+04, 3.8743916057E+01, 4.9347608775E+00, 2.2117566761E+01, 3.6540692859E+00, 9.7784655780E-01],
	[4.3950000000E+04, 3.8751706998E+01, 4.9348017454E+00, 2.2125802034E+01, 3.6543857036E+00, 9.7785601687E-01],
	[4.3955000000E+04, 3.8759498619E+01, 4.9348426090E+00, 2.2134039434E+01, 3.6547020423E+00, 9.7786547137E-01],
	[4.3960000000E+04, 3.8767290921E+01, 4.9348834683E+00, 2.2142278963E+01, 3.6550183021E+00, 9.7787492130E-01],
	[4.3965000000E+04, 3.8775083902E+01, 4.9349243233E+00, 2.2150520620E+01, 3.6553344829E+00, 9.7788436666E-01],
	[4.3970000000E+04, 3.8782877563E+01, 4.9349651740E+00, 2.2158764407E+01, 3.6556505848E+00, 9.7789380746E-01],
	[4.3975000000E+04, 3.8790671904E+01, 4.9350060204E+00, 2.2167010323E+01, 3.6559666078E+00, 9.7790324369E-01],
	[4.3980000000E+04, 3.8798466926E+01, 4.9350468624E+00, 2.2175258368E+01, 3.6562825519E+00, 9.7791267536E-01],
	[4.3985000000E+04, 3.8806262627E+01, 4.9350877002E+00, 2.2183508543E+01, 3.6565984171E+00, 9.7792210247E-01],
	[4.3990000000E+04, 3.8814059008E+01, 4.9351285337E+00, 2.2191760848E+01, 3.6569142035E+00, 9.7793152503E-01],
	[4.3995000000E+04, 3.8821856070E+01, 4.9351693628E+00, 2.2200015284E+01, 3.6572299111E+00, 9.7794094303E-01],
	[4.4000000000E+04, 3.8829653811E+01, 4.9352101877E+00, 2.2208271851E+01, 3.6575455398E+00, 9.7795035648E-01],
	[4.4005000000E+04, 3.8837452232E+01, 4.9352510082E+00, 2.2216530549E+01, 3.6578610897E+00, 9.7795976538E-01],
	[4.4010000000E+04, 3.8845251333E+01, 4.9352918245E+00, 2.2224791378E+01, 3.6581765609E+00, 9.7796916974E-01],
	[4.4015000000E+04, 3.8853051114E+01, 4.9353326364E+00, 2.2233054339E+01, 3.6584919534E+00, 9.7797856955E-01],
	[4.4020000000E+04, 3.8860851575E+01, 4.9353734441E+00, 2.2241319432E+01, 3.6588072671E+00, 9.7798796482E-01],
	[4.4025000000E+04, 3.8868652715E+01, 4.9354142475E+00, 2.2249586658E+01, 3.6591225021E+00, 9.7799735555E-01],
	[4.4030000000E+04, 3.8876454536E+01, 4.9354550465E+00, 2.2257856016E+01, 3.6594376584E+00, 9.7800674175E-01],
	[4.4035000000E+04, 3.8884257036E+01, 4.9354958413E+00, 2.2266127507E+01, 3.6597527360E+00, 9.7801612341E-01],
	[4.4040000000E+04, 3.8892060216E+01, 4.9355366318E+00, 2.2274401131E+01, 3.6600677350E+00, 9.7802550053E-01],
	[4.4045000000E+04, 3.8899864076E+01, 4.9355774179E+00, 2.2282676889E+01, 3.6603826554E+00, 9.7803487313E-01],
	[4.4050000000E+04, 3.8907668616E+01, 4.9356181998E+00, 2.2290954781E+01, 3.6606974972E+00, 9.7804424120E-01],
	[4.4055000000E+04, 3.8915473835E+01, 4.9356589774E+00, 2.2299234807E+01, 3.6610122604E+00, 9.7805360475E-01],
	[4.4060000000E+04, 3.8923279735E+01, 4.9356997507E+00, 2.2307516967E+01, 3.6613269450E+00, 9.7806296378E-01],
	[4.4065000000E+04, 3.8931086313E+01, 4.9357405197E+00, 2.2315801263E+01, 3.6616415511E+00, 9.7807231828E-01],
	[4.4070000000E+04, 3.8938893572E+01, 4.9357812845E+00, 2.2324087693E+01, 3.6619560786E+00, 9.7808166827E-01],
	[4.4075000000E+04, 3.8946701510E+01, 4.9358220449E+00, 2.2332376259E+01, 3.6622705276E+00, 9.7809101374E-01],
	[4.4080000000E+04, 3.8954510128E+01, 4.9358628011E+00, 2.2340666961E+01, 3.6625848982E+00, 9.7810035470E-01],
	[4.4085000000E+04, 3.8962319426E+01, 4.9359035529E+00, 2.2348959798E+01, 3.6628991903E+00, 9.7810969115E-01],
	[4.4090000000E+04, 3.8970129403E+01, 4.9359443005E+00, 2.2357254772E+01, 3.6632134040E+00, 9.7811902310E-01],
	[4.4095000000E+04, 3.8977940060E+01, 4.9359850438E+00, 2.2365551883E+01, 3.6635275392E+00, 9.7812835054E-01],
	[4.4100000000E+04, 3.8985751396E+01, 4.9360257828E+00, 2.2373851131E+01, 3.6638415960E+00, 9.7813767347E-01],
	[4.4105000000E+04, 3.8993563412E+01, 4.9360665175E+00, 2.2382152516E+01, 3.6641555744E+00, 9.7814699191E-01],
	[4.4110000000E+04, 3.9001376107E+01, 4.9361072480E+00, 2.2390456038E+01, 3.6644694745E+00, 9.7815630584E-01],
	[4.4115000000E+04, 3.9009189482E+01, 4.9361479741E+00, 2.2398761699E+01, 3.6647832962E+00, 9.7816561529E-01],
	[4.4120000000E+04, 3.9017003537E+01, 4.9361886960E+00, 2.2407069497E+01, 3.6650970397E+00, 9.7817492024E-01],
	[4.4125000000E+04, 3.9024818271E+01, 4.9362294136E+00, 2.2415379434E+01, 3.6654107048E+00, 9.7818422069E-01],
	[4.4130000000E+04, 3.9032633684E+01, 4.9362701270E+00, 2.2423691510E+01, 3.6657242916E+00, 9.7819351666E-01],
	[4.4135000000E+04, 3.9040449777E+01, 4.9363108360E+00, 2.2432005725E+01, 3.6660378002E+00, 9.7820280815E-01],
	[4.4140000000E+04, 3.9048266550E+01, 4.9363515408E+00, 2.2440322080E+01, 3.6663512305E+00, 9.7821209515E-01],
	[4.4145000000E+04, 3.9056084002E+01, 4.9363922413E+00, 2.2448640574E+01, 3.6666645826E+00, 9.7822137767E-01],
	[4.4150000000E+04, 3.9063902133E+01, 4.9364329375E+00, 2.2456961208E+01, 3.6669778565E+00, 9.7823065571E-01],
	[4.4155000000E+04, 3.9071720943E+01, 4.9364736295E+00, 2.2465283983E+01, 3.6672910522E+00, 9.7823992928E-01],
	[4.4160000000E+04, 3.9079540433E+01, 4.9365143172E+00, 2.2473608898E+01, 3.6676041697E+00, 9.7824919837E-01],
	[4.4165000000E+04, 3.9087360603E+01, 4.9365550006E+00, 2.2481935955E+01, 3.6679172092E+00, 9.7825846299E-01],
	[4.4170000000E+04, 3.9095181451E+01, 4.9365956797E+00, 2.2490265152E+01, 3.6682301705E+00, 9.7826772314E-01],
	[4.4175000000E+04, 3.9103002979E+01, 4.9366363546E+00, 2.2498596491E+01, 3.6685430536E+00, 9.7827697883E-01],
	[4.4180000000E+04, 3.9110825187E+01, 4.9366770252E+00, 2.2506929972E+01, 3.6688558588E+00, 9.7828623005E-01],
	[4.4185000000E+04, 3.9118648073E+01, 4.9367176915E+00, 2.2515265595E+01, 3.6691685858E+00, 9.7829547681E-01],
	[4.4190000000E+04, 3.9126471639E+01, 4.9367583536E+00, 2.2523603361E+01, 3.6694812348E+00, 9.7830471911E-01],
	[4.4195000000E+04, 3.9134295884E+01, 4.9367990114E+00, 2.2531943270E+01, 3.6697938058E+00, 9.7831395696E-01],
	[4.4200000000E+04, 3.9142120808E+01, 4.9368396649E+00, 2.2540285321E+01, 3.6701062988E+00, 9.7832319035E-01],
	[4.4205000000E+04, 3.9149946412E+01, 4.9368803142E+00, 2.2548629516E+01, 3.6704187138E+00, 9.7833241928E-01],
	[4.4210000000E+04, 3.9157772695E+01, 4.9369209592E+00, 2.2556975855E+01, 3.6707310509E+00, 9.7834164377E-01],
	[4.4215000000E+04, 3.9165599657E+01, 4.9369616000E+00, 2.2565324338E+01, 3.6710433100E+00, 9.7835086381E-01],
	[4.4220000000E+04, 3.9173427298E+01, 4.9370022365E+00, 2.2573674965E+01, 3.6713554912E+00, 9.7836007941E-01],
	[4.4225000000E+04, 3.9181255618E+01, 4.9370428687E+00, 2.2582027737E+01, 3.6716675945E+00, 9.7836929056E-01],
	[4.4230000000E+04, 3.9189084617E+01, 4.9370834967E+00, 2.2590382654E+01, 3.6719796199E+00, 9.7837849728E-01],
	[4.4235000000E+04, 3.9196914295E+01, 4.9371241204E+00, 2.2598739716E+01, 3.6722915675E+00, 9.7838769955E-01],
	[4.4240000000E+04, 3.9204744653E+01, 4.9371647398E+00, 2.2607098924E+01, 3.6726034372E+00, 9.7839689739E-01],
	[4.4245000000E+04, 3.9212575690E+01, 4.9372053550E+00, 2.2615460278E+01, 3.6729152291E+00, 9.7840609080E-01],
	[4.4250000000E+04, 3.9220407405E+01, 4.9372459660E+00, 2.2623823777E+01, 3.6732269432E+00, 9.7841527978E-01],
	[4.4255000000E+04, 3.9228239800E+01, 4.9372865726E+00, 2.2632189424E+01, 3.6735385795E+00, 9.7842446433E-01],
	[4.4260000000E+04, 3.9236072873E+01, 4.9373271751E+00, 2.2640557217E+01, 3.6738501381E+00, 9.7843364446E-01],
	[4.4265000000E+04, 3.9243906626E+01, 4.9373677733E+00, 2.2648927157E+01, 3.6741616189E+00, 9.7844282016E-01],
	[4.4270000000E+04, 3.9251741058E+01, 4.9374083672E+00, 2.2657299245E+01, 3.6744730220E+00, 9.7845199144E-01],
	[4.4275000000E+04, 3.9259576168E+01, 4.9374489569E+00, 2.2665673480E+01, 3.6747843475E+00, 9.7846115830E-01],
	[4.4280000000E+04, 3.9267411958E+01, 4.9374895423E+00, 2.2674049864E+01, 3.6750955952E+00, 9.7847032075E-01],
	[4.4285000000E+04, 3.9275248426E+01, 4.9375301235E+00, 2.2682428396E+01, 3.6754067653E+00, 9.7847947878E-01],
	[4.4290000000E+04, 3.9283085574E+01, 4.9375707004E+00, 2.2690809076E+01, 3.6757178577E+00, 9.7848863240E-01],
	[4.4295000000E+04, 3.9290923400E+01, 4.9376112731E+00, 2.2699191906E+01, 3.6760288726E+00, 9.7849778161E-01],
	[4.4300000000E+04, 3.9298761905E+01, 4.9376518415E+00, 2.2707576885E+01, 3.6763398098E+00, 9.7850692642E-01],
	[4.4305000000E+04, 3.9306601089E+01, 4.9376924057E+00, 2.2715964013E+01, 3.6766506695E+00, 9.7851606682E-01],
	[4.4310000000E+04, 3.9314440952E+01, 4.9377329657E+00, 2.2724353291E+01, 3.6769614516E+00, 9.7852520282E-01],
	[4.4315000000E+04, 3.9322281493E+01, 4.9377735214E+00, 2.2732744720E+01, 3.6772721561E+00, 9.7853433442E-01],
	[4.4320000000E+04, 3.9330122714E+01, 4.9378140728E+00, 2.2741138299E+01, 3.6775827832E+00, 9.7854346163E-01],
	[4.4325000000E+04, 3.9337964613E+01, 4.9378546201E+00, 2.2749534029E+01, 3.6778933328E+00, 9.7855258444E-01],
	[4.4330000000E+04, 3.9345807191E+01, 4.9378951630E+00, 2.2757931910E+01, 3.6782038048E+00, 9.7856170286E-01],
	[4.4335000000E+04, 3.9353650448E+01, 4.9379357018E+00, 2.2766331942E+01, 3.6785141995E+00, 9.7857081689E-01],
	[4.4340000000E+04, 3.9361494383E+01, 4.9379762363E+00, 2.2774734126E+01, 3.6788245167E+00, 9.7857992653E-01],
	[4.4345000000E+04, 3.9369338997E+01, 4.9380167665E+00, 2.2783138462E+01, 3.6791347564E+00, 9.7858903178E-01],
	[4.4350000000E+04, 3.9377184290E+01, 4.9380572926E+00, 2.2791544951E+01, 3.6794449188E+00, 9.7859813266E-01],
	[4.4355000000E+04, 3.9385030262E+01, 4.9380978144E+00, 2.2799953592E+01, 3.6797550038E+00, 9.7860722915E-01],
	[4.4360000000E+04, 3.9392876912E+01, 4.9381383319E+00, 2.2808364386E+01, 3.6800650115E+00, 9.7861632126E-01],
	[4.4365000000E+04, 3.9400724241E+01, 4.9381788452E+00, 2.2816777334E+01, 3.6803749418E+00, 9.7862540900E-01],
	[4.4370000000E+04, 3.9408572248E+01, 4.9382193543E+00, 2.2825192435E+01, 3.6806847948E+00, 9.7863449237E-01],
	[4.4375000000E+04, 3.9416420934E+01, 4.9382598592E+00, 2.2833609690E+01, 3.6809945705E+00, 9.7864357137E-01],
	[4.4380000000E+04, 3.9424270299E+01, 4.9383003598E+00, 2.2842029099E+01, 3.6813042689E+00, 9.7865264600E-01],
	[4.4385000000E+04, 3.9432120342E+01, 4.9383408562E+00, 2.2850450663E+01, 3.6816138901E+00, 9.7866171626E-01],
	[4.4390000000E+04, 3.9439971064E+01, 4.9383813484E+00, 2.2858874381E+01, 3.6819234341E+00, 9.7867078216E-01],
	[4.4395000000E+04, 3.9447822464E+01, 4.9384218363E+00, 2.2867300255E+01, 3.6822329008E+00, 9.7867984369E-01],
	[4.4400000000E+04, 3.9455674543E+01, 4.9384623200E+00, 2.2875728284E+01, 3.6825422903E+00, 9.7868890087E-01],
	[4.4405000000E+04, 3.9463527300E+01, 4.9385027995E+00, 2.2884158469E+01, 3.6828516027E+00, 9.7869795369E-01],
	[4.4410000000E+04, 3.9471380736E+01, 4.9385432747E+00, 2.2892590810E+01, 3.6831608379E+00, 9.7870700216E-01],
	[4.4415000000E+04, 3.9479234850E+01, 4.9385837458E+00, 2.2901025307E+01, 3.6834699960E+00, 9.7871604628E-01],
	[4.4420000000E+04, 3.9487089643E+01, 4.9386242126E+00, 2.2909461961E+01, 3.6837790769E+00, 9.7872508604E-01],
	[4.4425000000E+04, 3.9494945114E+01, 4.9386646751E+00, 2.2917900772E+01, 3.6840880808E+00, 9.7873412146E-01],
	[4.4430000000E+04, 3.9502801263E+01, 4.9387051335E+00, 2.2926341741E+01, 3.6843970076E+00, 9.7874315254E-01],
	[4.4435000000E+04, 3.9510658091E+01, 4.9387455876E+00, 2.2934784867E+01, 3.6847058574E+00, 9.7875217927E-01],
	[4.4440000000E+04, 3.9518515598E+01, 4.9387860376E+00, 2.2943230150E+01, 3.6850146301E+00, 9.7876120167E-01],
	[4.4445000000E+04, 3.9526373782E+01, 4.9388264833E+00, 2.2951677592E+01, 3.6853233258E+00, 9.7877021972E-01],
	[4.4450000000E+04, 3.9534232645E+01, 4.9388669247E+00, 2.2960127193E+01, 3.6856319445E+00, 9.7877923344E-01],
	[4.4455000000E+04, 3.9542092186E+01, 4.9389073620E+00, 2.2968578952E+01, 3.6859404862E+00, 9.7878824283E-01],
	[4.4460000000E+04, 3.9549952406E+01, 4.9389477950E+00, 2.2977032871E+01, 3.6862489510E+00, 9.7879724789E-01],
	[4.4465000000E+04, 3.9557813304E+01, 4.9389882239E+00, 2.2985488949E+01, 3.6865573388E+00, 9.7880624862E-01],
	[4.4470000000E+04, 3.9565674880E+01, 4.9390286485E+00, 2.2993947187E+01, 3.6868656498E+00, 9.7881524502E-01],
	[4.4475000000E+04, 3.9573537134E+01, 4.9390690689E+00, 2.3002407584E+01, 3.6871738838E+00, 9.7882423710E-01],
	[4.4480000000E+04, 3.9581400067E+01, 4.9391094851E+00, 2.3010870143E+01, 3.6874820410E+00, 9.7883322486E-01],
	[4.4485000000E+04, 3.9589263678E+01, 4.9391498970E+00, 2.3019334861E+01, 3.6877901213E+00, 9.7884220830E-01],
	[4.4490000000E+04, 3.9597127967E+01, 4.9391903048E+00, 2.3027801741E+01, 3.6880981248E+00, 9.7885118742E-01],
	[4.4495000000E+04, 3.9604992934E+01, 4.9392307084E+00, 2.3036270782E+01, 3.6884060515E+00, 9.7886016224E-01],
	[4.4500000000E+04, 3.9612858579E+01, 4.9392711077E+00, 2.3044741985E+01, 3.6887139014E+00, 9.7886913273E-01],
	[4.4505000000E+04, 3.9620724903E+01, 4.9393115028E+00, 2.3053215350E+01, 3.6890216745E+00, 9.7887809892E-01],
	[4.4510000000E+04, 3.9628591905E+01, 4.9393518938E+00, 2.3061690877E+01, 3.6893293708E+00, 9.7888706081E-01],
	[4.4515000000E+04, 3.9636459584E+01, 4.9393922805E+00, 2.3070168566E+01, 3.6896369905E+00, 9.7889601838E-01],
	[4.4520000000E+04, 3.9644327942E+01, 4.9394326630E+00, 2.3078648419E+01, 3.6899445334E+00, 9.7890497166E-01],
	[4.4525000000E+04, 3.9652196978E+01, 4.9394730413E+00, 2.3087130434E+01, 3.6902519996E+00, 9.7891392064E-01],
	[4.4530000000E+04, 3.9660066692E+01, 4.9395134154E+00, 2.3095614613E+01, 3.6905593891E+00, 9.7892286532E-01],
	[4.4535000000E+04, 3.9667937084E+01, 4.9395537853E+00, 2.3104100956E+01, 3.6908667020E+00, 9.7893180570E-01],
	[4.4540000000E+04, 3.9675808154E+01, 4.9395941510E+00, 2.3112589462E+01, 3.6911739383E+00, 9.7894074179E-01],
	[4.4545000000E+04, 3.9683679902E+01, 4.9396345125E+00, 2.3121080134E+01, 3.6914810980E+00, 9.7894967359E-01],
	[4.4550000000E+04, 3.9691552328E+01, 4.9396748698E+00, 2.3129572969E+01, 3.6917881810E+00, 9.7895860110E-01],
	[4.4555000000E+04, 3.9699425432E+01, 4.9397152229E+00, 2.3138067970E+01, 3.6920951875E+00, 9.7896752433E-01],
	[4.4560000000E+04, 3.9707299214E+01, 4.9397555718E+00, 2.3146565136E+01, 3.6924021175E+00, 9.7897644327E-01],
	[4.4565000000E+04, 3.9715173674E+01, 4.9397959165E+00, 2.3155064468E+01, 3.6927089709E+00, 9.7898535793E-01],
	[4.4570000000E+04, 3.9723048811E+01, 4.9398362570E+00, 2.3163565966E+01, 3.6930157478E+00, 9.7899426832E-01],
	[4.4575000000E+04, 3.9730924627E+01, 4.9398765933E+00, 2.3172069630E+01, 3.6933224482E+00, 9.7900317443E-01],
	[4.4580000000E+04, 3.9738801120E+01, 4.9399169254E+00, 2.3180575460E+01, 3.6936290721E+00, 9.7901207626E-01],
	[4.4585000000E+04, 3.9746681225E+01, 4.9399575769E+00, 2.3189083458E+01, 3.6939358259E+00, 9.7902097382E-01],
	[4.4590000000E+04, 3.9754574961E+01, 4.9399996529E+00, 2.3197593622E+01, 3.6942434141E+00, 9.7902986711E-01],
	[4.4595000000E+04, 3.9762469379E+01, 4.9400417246E+00, 2.3206105954E+01, 3.6945509261E+00, 9.7903875614E-01],
	[4.4600000000E+04, 3.9770364480E+01, 4.9400837919E+00, 2.3214620454E+01, 3.6948583619E+00, 9.7904764090E-01],
	[4.4605000000E+04, 3.9778260263E+01, 4.9401258549E+00, 2.3223137122E+01, 3.6951657214E+00, 9.7905652139E-01],
	[4.4610000000E+04, 3.9786156729E+01, 4.9401679134E+00, 2.3231655958E+01, 3.6954730048E+00, 9.7906539763E-01],
	[4.4615000000E+04, 3.9794053876E+01, 4.9402099677E+00, 2.3240176963E+01, 3.6957802121E+00, 9.7907426961E-01],
	[4.4620000000E+04, 3.9801951706E+01, 4.9402520176E+00, 2.3248700137E+01, 3.6960873432E+00, 9.7908313734E-01],
	[4.4625000000E+04, 3.9809850219E+01, 4.9402940631E+00, 2.3257225480E+01, 3.6963943982E+00, 9.7909200081E-01],
	[4.4630000000E+04, 3.9817749413E+01, 4.9403361043E+00, 2.3265752993E+01, 3.6967013770E+00, 9.7910086003E-01],
	[4.4635000000E+04, 3.9825649290E+01, 4.9403781411E+00, 2.3274282676E+01, 3.6970082799E+00, 9.7910971500E-01],
	[4.4640000000E+04, 3.9833549848E+01, 4.9404201735E+00, 2.3282814529E+01, 3.6973151066E+00, 9.7911856573E-01],
	[4.4645000000E+04, 3.9841451089E+01, 4.9404622017E+00, 2.3291348553E+01, 3.6976218573E+00, 9.7912741221E-01],
	[4.4650000000E+04, 3.9849353013E+01, 4.9405042254E+00, 2.3299884747E+01, 3.6979285320E+00, 9.7913625445E-01],
	[4.4655000000E+04, 3.9857255618E+01, 4.9405462448E+00, 2.3308423113E+01, 3.6982351307E+00, 9.7914509245E-01],
	[4.4660000000E+04, 3.9865158905E+01, 4.9405882599E+00, 2.3316963650E+01, 3.6985416535E+00, 9.7915392622E-01],
	[4.4665000000E+04, 3.9873062875E+01, 4.9406302706E+00, 2.3325506359E+01, 3.6988481002E+00, 9.7916275575E-01],
	[4.4670000000E+04, 3.9880967526E+01, 4.9406722770E+00, 2.3334051240E+01, 3.6991544711E+00, 9.7917158105E-01],
	[4.4675000000E+04, 3.9888872860E+01, 4.9407142791E+00, 2.3342598294E+01, 3.6994607660E+00, 9.7918040212E-01],
	[4.4680000000E+04, 3.9896778875E+01, 4.9407562768E+00, 2.3351147520E+01, 3.6997669850E+00, 9.7918921896E-01],
	[4.4685000000E+04, 3.9904685573E+01, 4.9407982701E+00, 2.3359698919E+01, 3.7000731282E+00, 9.7919803157E-01],
	[4.4690000000E+04, 3.9912592953E+01, 4.9408402591E+00, 2.3368252492E+01, 3.7003791954E+00, 9.7920683996E-01],
	[4.4695000000E+04, 3.9920501015E+01, 4.9408822438E+00, 2.3376808238E+01, 3.7006851869E+00, 9.7921564413E-01],
	[4.4700000000E+04, 3.9928409758E+01, 4.9409242241E+00, 2.3385366158E+01, 3.7009911025E+00, 9.7922444407E-01],
	[4.4705000000E+04, 3.9936319184E+01, 4.9409662001E+00, 2.3393926253E+01, 3.7012969423E+00, 9.7923323980E-01],
	[4.4710000000E+04, 3.9944229291E+01, 4.9410081718E+00, 2.3402488522E+01, 3.7016027064E+00, 9.7924203132E-01],
	[4.4715000000E+04, 3.9952140081E+01, 4.9410501391E+00, 2.3411052966E+01, 3.7019083947E+00, 9.7925081861E-01],
	[4.4720000000E+04, 3.9960051552E+01, 4.9410921021E+00, 2.3419619585E+01, 3.7022140072E+00, 9.7925960170E-01],
	[4.4725000000E+04, 3.9967963706E+01, 4.9411340607E+00, 2.3428188379E+01, 3.7025195441E+00, 9.7926838058E-01],
	[4.4730000000E+04, 3.9975876541E+01, 4.9411760150E+00, 2.3436759350E+01, 3.7028250052E+00, 9.7927715525E-01],
	[4.4735000000E+04, 3.9983790058E+01, 4.9412179650E+00, 2.3445332496E+01, 3.7031303906E+00, 9.7928592571E-01],
	[4.4740000000E+04, 3.9991704257E+01, 4.9412599106E+00, 2.3453907819E+01, 3.7034357004E+00, 9.7929469198E-01],
	[4.4745000000E+04, 3.9999619137E+01, 4.9413018519E+00, 2.3462485319E+01, 3.7037409346E+00, 9.7930345404E-01],
	[4.4750000000E+04, 4.0007534700E+01, 4.9413437889E+00, 2.3471064996E+01, 3.7040460931E+00, 9.7931221190E-01],
	[4.4755000000E+04, 4.0015450944E+01, 4.9413857216E+00, 2.3479646850E+01, 3.7043511761E+00, 9.7932096556E-01],
	[4.4760000000E+04, 4.0023367870E+01, 4.9414276499E+00, 2.3488230881E+01, 3.7046561834E+00, 9.7932971503E-01],
	[4.4765000000E+04, 4.0031285478E+01, 4.9414695739E+00, 2.3496817091E+01, 3.7049611152E+00, 9.7933846031E-01],
	[4.4770000000E+04, 4.0039203768E+01, 4.9415114936E+00, 2.3505405479E+01, 3.7052659715E+00, 9.7934720139E-01],
	[4.4775000000E+04, 4.0047122739E+01, 4.9415534089E+00, 2.3513996046E+01, 3.7055707522E+00, 9.7935593829E-01],
	[4.4780000000E+04, 4.0055042392E+01, 4.9415953199E+00, 2.3522588791E+01, 3.7058754575E+00, 9.7936467100E-01],
	[4.4785000000E+04, 4.0062962726E+01, 4.9416372266E+00, 2.3531183716E+01, 3.7061800872E+00, 9.7937339952E-01],
	[4.4790000000E+04, 4.0070883743E+01, 4.9416791290E+00, 2.3539780820E+01, 3.7064846415E+00, 9.7938212386E-01],
	[4.4795000000E+04, 4.0078805440E+01, 4.9417210270E+00, 2.3548380104E+01, 3.7067891204E+00, 9.7939084403E-01],
	[4.4800000000E+04, 4.0086727820E+01, 4.9417629208E+00, 2.3556981568E+01, 3.7070935238E+00, 9.7939956001E-01],
	[4.4805000000E+04, 4.0094650881E+01, 4.9418048102E+00, 2.3565585213E+01, 3.7073978518E+00, 9.7940827182E-01],
	[4.4810000000E+04, 4.0102574624E+01, 4.9418466953E+00, 2.3574191038E+01, 3.7077021045E+00, 9.7941697945E-01],
	[4.4815000000E+04, 4.0110499048E+01, 4.9418885760E+00, 2.3582799044E+01, 3.7080062818E+00, 9.7942568291E-01],
	[4.4820000000E+04, 4.0118424154E+01, 4.9419304525E+00, 2.3591409232E+01, 3.7083103837E+00, 9.7943438220E-01],
	[4.4825000000E+04, 4.0126349942E+01, 4.9419723246E+00, 2.3600021601E+01, 3.7086144103E+00, 9.7944307733E-01],
	[4.4830000000E+04, 4.0134276411E+01, 4.9420141924E+00, 2.3608636153E+01, 3.7089183616E+00, 9.7945176828E-01],
	[4.4835000000E+04, 4.0142203561E+01, 4.9420560559E+00, 2.3617252887E+01, 3.7092222377E+00, 9.7946045508E-01],
	[4.4840000000E+04, 4.0150131393E+01, 4.9420979151E+00, 2.3625871803E+01, 3.7095260384E+00, 9.7946913771E-01],
	[4.4845000000E+04, 4.0158059906E+01, 4.9421397700E+00, 2.3634492902E+01, 3.7098297640E+00, 9.7947781618E-01],
	[4.4850000000E+04, 4.0165989101E+01, 4.9421816206E+00, 2.3643116184E+01, 3.7101334143E+00, 9.7948649050E-01],
	[4.4855000000E+04, 4.0173918977E+01, 4.9422234668E+00, 2.3651741650E+01, 3.7104369894E+00, 9.7949516066E-01],
	[4.4860000000E+04, 4.0181849535E+01, 4.9422653088E+00, 2.3660369300E+01, 3.7107404893E+00, 9.7950382667E-01],
	[4.4865000000E+04, 4.0189780774E+01, 4.9423071464E+00, 2.3668999134E+01, 3.7110439141E+00, 9.7951248852E-01],
	[4.4870000000E+04, 4.0197712695E+01, 4.9423489798E+00, 2.3677631153E+01, 3.7113472637E+00, 9.7952114623E-01],
	[4.4875000000E+04, 4.0205645297E+01, 4.9423908088E+00, 2.3686265356E+01, 3.7116505382E+00, 9.7952979979E-01],
	[4.4880000000E+04, 4.0213578580E+01, 4.9424326335E+00, 2.3694901744E+01, 3.7119537375E+00, 9.7953844920E-01],
	[4.4885000000E+04, 4.0221512544E+01, 4.9424744539E+00, 2.3703540318E+01, 3.7122568618E+00, 9.7954709447E-01],
	[4.4890000000E+04, 4.0229447190E+01, 4.9425162700E+00, 2.3712181077E+01, 3.7125599111E+00, 9.7955573560E-01],
	[4.4895000000E+04, 4.0237382517E+01, 4.9425580818E+00, 2.3720824022E+01, 3.7128628853E+00, 9.7956437259E-01],
	[4.4900000000E+04, 4.0245318526E+01, 4.9425998893E+00, 2.3729469154E+01, 3.7131657844E+00, 9.7957300545E-01],
	[4.4905000000E+04, 4.0253255216E+01, 4.9426416925E+00, 2.3738116472E+01, 3.7134686086E+00, 9.7958163417E-01],
	[4.4910000000E+04, 4.0261192587E+01, 4.9426834914E+00, 2.3746765977E+01, 3.7137713578E+00, 9.7959025875E-01],
	[4.4915000000E+04, 4.0269130639E+01, 4.9427252860E+00, 2.3755417670E+01, 3.7140740320E+00, 9.7959887921E-01],
	[4.4920000000E+04, 4.0277069372E+01, 4.9427670763E+00, 2.3764071550E+01, 3.7143766312E+00, 9.7960749554E-01],
	[4.4925000000E+04, 4.0285008787E+01, 4.9428088623E+00, 2.3772727618E+01, 3.7146791556E+00, 9.7961610774E-01],
	[4.4930000000E+04, 4.0292948882E+01, 4.9428506440E+00, 2.3781385874E+01, 3.7149816050E+00, 9.7962471582E-01],
	[4.4935000000E+04, 4.0300889659E+01, 4.9428924214E+00, 2.3790046318E+01, 3.7152839795E+00, 9.7963331978E-01],
	[4.4940000000E+04, 4.0308831117E+01, 4.9429341945E+00, 2.3798708951E+01, 3.7155862792E+00, 9.7964191961E-01],
	[4.4945000000E+04, 4.0316773257E+01, 4.9429759633E+00, 2.3807373774E+01, 3.7158885040E+00, 9.7965051533E-01],
	[4.4950000000E+04, 4.0324716077E+01, 4.9430177278E+00, 2.3816040785E+01, 3.7161906540E+00, 9.7965910693E-01],
	[4.4955000000E+04, 4.0332659578E+01, 4.9430594881E+00, 2.3824709987E+01, 3.7164927292E+00, 9.7966769442E-01],
	[4.4960000000E+04, 4.0340603761E+01, 4.9431012440E+00, 2.3833381378E+01, 3.7167947296E+00, 9.7967627780E-01],
	[4.4965000000E+04, 4.0348548624E+01, 4.9431429957E+00, 2.3842054960E+01, 3.7170966552E+00, 9.7968485706E-01],
	[4.4970000000E+04, 4.0356494169E+01, 4.9431847430E+00, 2.3850730733E+01, 3.7173985061E+00, 9.7969343222E-01],
	[4.4975000000E+04, 4.0364440394E+01, 4.9432264861E+00, 2.3859408696E+01, 3.7177002823E+00, 9.7970200328E-01],
	[4.4980000000E+04, 4.0372387301E+01, 4.9432682249E+00, 2.3868088851E+01, 3.7180019837E+00, 9.7971057023E-01],
	[4.4985000000E+04, 4.0380334888E+01, 4.9433099593E+00, 2.3876771197E+01, 3.7183036105E+00, 9.7971913308E-01],
	[4.4990000000E+04, 4.0388283157E+01, 4.9433516896E+00, 2.3885455735E+01, 3.7186051626E+00, 9.7972769183E-01],
	[4.4995000000E+04, 4.0396232106E+01, 4.9433934155E+00, 2.3894142465E+01, 3.7189066400E+00, 9.7973624648E-01],
	[4.5000000000E+04, 4.0404181737E+01, 4.9434351371E+00, 2.3902831388E+01, 3.7192080428E+00, 9.7974479703E-01],
	[4.5005000000E+04, 4.0412132048E+01, 4.9434768545E+00, 2.3911542823E+01, 3.7195098627E+00, 9.7975334350E-01],
	[4.5010000000E+04, 4.0420083040E+01, 4.9435185675E+00, 2.3920256464E+01, 3.7198116077E+00, 9.7976188587E-01],
	[4.5015000000E+04, 4.0428034713E+01, 4.9435602763E+00, 2.3928972311E+01, 3.7201132779E+00, 9.7977042415E-01],
	[4.5020000000E+04, 4.0435987067E+01, 4.9436019808E+00, 2.3937690364E+01, 3.7204148733E+00, 9.7977895835E-01],
	[4.5025000000E+04, 4.0443940102E+01, 4.9436436811E+00, 2.3946410624E+01, 3.7207163939E+00, 9.7978748846E-01],
	[4.5030000000E+04, 4.0451893818E+01, 4.9436853770E+00, 2.3955133091E+01, 3.7210178397E+00, 9.7979601449E-01],
	[4.5035000000E+04, 4.0459848214E+01, 4.9437270687E+00, 2.3963857766E+01, 3.7213192108E+00, 9.7980453644E-01],
	[4.5040000000E+04, 4.0467803291E+01, 4.9437687561E+00, 2.3972584648E+01, 3.7216205072E+00, 9.7981305431E-01],
	[4.5045000000E+04, 4.0475759049E+01, 4.9438104392E+00, 2.3981313738E+01, 3.7219217289E+00, 9.7982156810E-01],
	[4.5050000000E+04, 4.0483715488E+01, 4.9438521180E+00, 2.3990045036E+01, 3.7222228759E+00, 9.7983007782E-01],
	[4.5055000000E+04, 4.0491672607E+01, 4.9438937926E+00, 2.3998778543E+01, 3.7225239483E+00, 9.7983858347E-01],
	[4.5060000000E+04, 4.0499630408E+01, 4.9439354629E+00, 2.4007514259E+01, 3.7228249460E+00, 9.7984708504E-01],
	[4.5065000000E+04, 4.0507588889E+01, 4.9439771289E+00, 2.4016252184E+01, 3.7231258690E+00, 9.7985558255E-01],
	[4.5070000000E+04, 4.0515548050E+01, 4.9440187907E+00, 2.4024992319E+01, 3.7234267175E+00, 9.7986407599E-01],
	[4.5075000000E+04, 4.0523507892E+01, 4.9440604482E+00, 2.4033734663E+01, 3.7237274914E+00, 9.7987256537E-01],
	[4.5080000000E+04, 4.0531468415E+01, 4.9441021014E+00, 2.4042479218E+01, 3.7240281907E+00, 9.7988105068E-01],
	[4.5085000000E+04, 4.0539429619E+01, 4.9441437503E+00, 2.4051225983E+01, 3.7243288155E+00, 9.7988953193E-01],
	[4.5090000000E+04, 4.0547391503E+01, 4.9441853950E+00, 2.4059974958E+01, 3.7246293657E+00, 9.7989800913E-01],
	[4.5095000000E+04, 4.0555354068E+01, 4.9442270354E+00, 2.4068726145E+01, 3.7249298415E+00, 9.7990648227E-01],
	[4.5100000000E+04, 4.0563317313E+01, 4.9442686716E+00, 2.4077479544E+01, 3.7252302428E+00, 9.7991495136E-01],
	[4.5105000000E+04, 4.0571281239E+01, 4.9443103034E+00, 2.4086235154E+01, 3.7255305696E+00, 9.7992341639E-01],
	[4.5110000000E+04, 4.0579245846E+01, 4.9443519310E+00, 2.4094992976E+01, 3.7258308219E+00, 9.7993187738E-01],
	[4.5115000000E+04, 4.0587211133E+01, 4.9443935544E+00, 2.4103753010E+01, 3.7261309998E+00, 9.7994033431E-01],
	[4.5120000000E+04, 4.0595177100E+01, 4.9444351735E+00, 2.4112515257E+01, 3.7264311034E+00, 9.7994878720E-01],
	[4.5125000000E+04, 4.0603143748E+01, 4.9444767883E+00, 2.4121279717E+01, 3.7267311325E+00, 9.7995723605E-01],
	[4.5130000000E+04, 4.0611111077E+01, 4.9445183989E+00, 2.4130046391E+01, 3.7270310873E+00, 9.7996568086E-01],
	[4.5135000000E+04, 4.0619079086E+01, 4.9445600052E+00, 2.4138815278E+01, 3.7273309677E+00, 9.7997412163E-01],
	[4.5140000000E+04, 4.0627047775E+01, 4.9446016072E+00, 2.4147586378E+01, 3.7276307738E+00, 9.7998255835E-01],
	[4.5145000000E+04, 4.0635017145E+01, 4.9446432050E+00, 2.4156359694E+01, 3.7279305056E+00, 9.7999099105E-01],
	[4.5150000000E+04, 4.0642987196E+01, 4.9446847985E+00, 2.4165135223E+01, 3.7282301631E+00, 9.7999941971E-01],
	[4.5155000000E+04, 4.0650957926E+01, 4.9447263878E+00, 2.4173912968E+01, 3.7285297463E+00, 9.8000784434E-01],
	[4.5160000000E+04, 4.0658929337E+01, 4.9447679728E+00, 2.4182692927E+01, 3.7288292553E+00, 9.8001626494E-01],
	[4.5165000000E+04, 4.0666901429E+01, 4.9448095536E+00, 2.4191475102E+01, 3.7291286901E+00, 9.8002468151E-01],
	[4.5170000000E+04, 4.0674874201E+01, 4.9448511301E+00, 2.4200259493E+01, 3.7294280506E+00, 9.8003309406E-01],
	[4.5175000000E+04, 4.0682847653E+01, 4.9448927024E+00, 2.4209046100E+01, 3.7297273370E+00, 9.8004150258E-01],
	[4.5180000000E+04, 4.0690821785E+01, 4.9449342704E+00, 2.4217834924E+01, 3.7300265492E+00, 9.8004990709E-01],
	[4.5185000000E+04, 4.0698796598E+01, 4.9449758342E+00, 2.4226625964E+01, 3.7303256872E+00, 9.8005830757E-01],
	[4.5190000000E+04, 4.0706772091E+01, 4.9450173937E+00, 2.4235419221E+01, 3.7306247511E+00, 9.8006670404E-01],
	[4.5195000000E+04, 4.0714748264E+01, 4.9450589489E+00, 2.4244214696E+01, 3.7309237410E+00, 9.8007509649E-01],
	[4.5200000000E+04, 4.0722725118E+01, 4.9451004999E+00, 2.4253012388E+01, 3.7312226567E+00, 9.8008348493E-01],
	[4.5205000000E+04, 4.0730702651E+01, 4.9451420467E+00, 2.4261812299E+01, 3.7315214983E+00, 9.8009186936E-01],
	[4.5210000000E+04, 4.0738680865E+01, 4.9451835892E+00, 2.4270614427E+01, 3.7318202659E+00, 9.8010024978E-01],
	[4.5215000000E+04, 4.0746659759E+01, 4.9452251275E+00, 2.4279418774E+01, 3.7321189595E+00, 9.8010862620E-01],
	[4.5220000000E+04, 4.0754639333E+01, 4.9452666615E+00, 2.4288225341E+01, 3.7324175790E+00, 9.8011699861E-01],
	[4.5225000000E+04, 4.0762619588E+01, 4.9453081913E+00, 2.4297034126E+01, 3.7327161246E+00, 9.8012536701E-01],
	[4.5230000000E+04, 4.0770600522E+01, 4.9453497169E+00, 2.4305845131E+01, 3.7330145962E+00, 9.8013373142E-01],
	[4.5235000000E+04, 4.0778582137E+01, 4.9453912382E+00, 2.4314658356E+01, 3.7333129938E+00, 9.8014209183E-01],
	[4.5240000000E+04, 4.0786564432E+01, 4.9454327552E+00, 2.4323473801E+01, 3.7336113175E+00, 9.8015044824E-01],
	[4.5245000000E+04, 4.0794547407E+01, 4.9454742680E+00, 2.4332291466E+01, 3.7339095673E+00, 9.8015880066E-01],
	[4.5250000000E+04, 4.0802531062E+01, 4.9455157766E+00, 2.4341111353E+01, 3.7342077432E+00, 9.8016714908E-01],
	[4.5255000000E+04, 4.0810515397E+01, 4.9455572810E+00, 2.4349933460E+01, 3.7345058452E+00, 9.8017549352E-01],
	[4.5260000000E+04, 4.0818500412E+01, 4.9455987811E+00, 2.4358757789E+01, 3.7348038734E+00, 9.8018383396E-01],
	[4.5265000000E+04, 4.0826486107E+01, 4.9456402769E+00, 2.4367584340E+01, 3.7351018277E+00, 9.8019217042E-01],
	[4.5270000000E+04, 4.0834472482E+01, 4.9456817686E+00, 2.4376413112E+01, 3.7353997083E+00, 9.8020050290E-01],
	[4.5275000000E+04, 4.0842459537E+01, 4.9457232560E+00, 2.4385244107E+01, 3.7356975150E+00, 9.8020883139E-01],
	[4.5280000000E+04, 4.0850447272E+01, 4.9457647391E+00, 2.4394077325E+01, 3.7359952479E+00, 9.8021715591E-01],
	[4.5285000000E+04, 4.0858435687E+01, 4.9458062181E+00, 2.4402912766E+01, 3.7362929071E+00, 9.8022547645E-01],
	[4.5290000000E+04, 4.0866424782E+01, 4.9458476928E+00, 2.4411750430E+01, 3.7365904926E+00, 9.8023379301E-01],
	[4.5295000000E+04, 4.0874414556E+01, 4.9458891633E+00, 2.4420590318E+01, 3.7368880044E+00, 9.8024210559E-01],
	[4.5300000000E+04, 4.0882405011E+01, 4.9459306295E+00, 2.4429432429E+01, 3.7371854424E+00, 9.8025041421E-01],
	[4.5305000000E+04, 4.0890406209E+01, 4.9459731822E+00, 2.4438276765E+01, 3.7374835136E+00, 9.8025871885E-01],
	[4.5310000000E+04, 4.0898413850E+01, 4.9460163545E+00, 2.4447123326E+01, 3.7377819158E+00, 9.8026701953E-01],
	[4.5315000000E+04, 4.0906422174E+01, 4.9460595225E+00, 2.4455972111E+01, 3.7380802445E+00, 9.8027531624E-01],
	[4.5320000000E+04, 4.0914431183E+01, 4.9461026861E+00, 2.4464823122E+01, 3.7383784997E+00, 9.8028360899E-01],
	[4.5325000000E+04, 4.0922440876E+01, 4.9461458453E+00, 2.4473676358E+01, 3.7386766816E+00, 9.8029189777E-01],
	[4.5330000000E+04, 4.0930451253E+01, 4.9461890001E+00, 2.4482531820E+01, 3.7389747899E+00, 9.8030018260E-01],
	[4.5335000000E+04, 4.0938462314E+01, 4.9462321505E+00, 2.4491389508E+01, 3.7392728249E+00, 9.8030846347E-01],
	[4.5340000000E+04, 4.0946474060E+01, 4.9462752965E+00, 2.4500249422E+01, 3.7395707865E+00, 9.8031674038E-01],
	[4.5345000000E+04, 4.0954486490E+01, 4.9463184382E+00, 2.4509111564E+01, 3.7398686748E+00, 9.8032501334E-01],
	[4.5350000000E+04, 4.0962499604E+01, 4.9463615755E+00, 2.4517975932E+01, 3.7401664897E+00, 9.8033328235E-01],
	[4.5355000000E+04, 4.0970513402E+01, 4.9464047084E+00, 2.4526842528E+01, 3.7404642313E+00, 9.8034154741E-01],
	[4.5360000000E+04, 4.0978527884E+01, 4.9464478369E+00, 2.4535711351E+01, 3.7407618996E+00, 9.8034980852E-01],
	[4.5365000000E+04, 4.0986543050E+01, 4.9464909610E+00, 2.4544582403E+01, 3.7410594947E+00, 9.8035806568E-01],
	[4.5370000000E+04, 4.0994558901E+01, 4.9465340808E+00, 2.4553455683E+01, 3.7413570164E+00, 9.8036631890E-01],
	[4.5375000000E+04, 4.1002575435E+01, 4.9465771962E+00, 2.4562331191E+01, 3.7416544649E+00, 9.8037456819E-01],
	[4.5380000000E+04, 4.1010592654E+01, 4.9466203072E+00, 2.4571208929E+01, 3.7419518403E+00, 9.8038281353E-01],
	[4.5385000000E+04, 4.1018610557E+01, 4.9466634138E+00, 2.4580088896E+01, 3.7422491424E+00, 9.8039105493E-01],
	[4.5390000000E+04, 4.1026629143E+01, 4.9467065161E+00, 2.4588971092E+01, 3.7425463713E+00, 9.8039929240E-01],
	[4.5395000000E+04, 4.1034648414E+01, 4.9467496140E+00, 2.4597855518E+01, 3.7428435270E+00, 9.8040752594E-01],
	[4.5400000000E+04, 4.1042668369E+01, 4.9467927075E+00, 2.4606742175E+01, 3.7431406097E+00, 9.8041575554E-01],
	[4.5405000000E+04, 4.1050689008E+01, 4.9468357967E+00, 2.4615631062E+01, 3.7434376192E+00, 9.8042398122E-01],
	[4.5410000000E+04, 4.1058710330E+01, 4.9468788815E+00, 2.4624522180E+01, 3.7437345555E+00, 9.8043220297E-01],
	[4.5415000000E+04, 4.1066732337E+01, 4.9469219619E+00, 2.4633415529E+01, 3.7440314189E+00, 9.8044042079E-01],
	[4.5420000000E+04, 4.1074755027E+01, 4.9469650379E+00, 2.4642311109E+01, 3.7443282091E+00, 9.8044863469E-01],
	[4.5425000000E+04, 4.1082778402E+01, 4.9470081096E+00, 2.4651208921E+01, 3.7446249263E+00, 9.8045684467E-01],
	[4.5430000000E+04, 4.1090802460E+01, 4.9470511769E+00, 2.4660108966E+01, 3.7449215705E+00, 9.8046505073E-01],
	[4.5435000000E+04, 4.1098827202E+01, 4.9470942399E+00, 2.4669011243E+01, 3.7452181416E+00, 9.8047325288E-01],
	[4.5440000000E+04, 4.1106852629E+01, 4.9471372985E+00, 2.4677915752E+01, 3.7455146398E+00, 9.8048145110E-01],
	[4.5445000000E+04, 4.1114878739E+01, 4.9471803527E+00, 2.4686822495E+01, 3.7458110650E+00, 9.8048964542E-01],
	[4.5450000000E+04, 4.1122905532E+01, 4.9472234026E+00, 2.4695731471E+01, 3.7461074173E+00, 9.8049783583E-01],
	[4.5455000000E+04, 4.1130933010E+01, 4.9472664481E+00, 2.4704642681E+01, 3.7464036966E+00, 9.8050602232E-01],
	[4.5460000000E+04, 4.1138961171E+01, 4.9473094892E+00, 2.4713556124E+01, 3.7466999031E+00, 9.8051420491E-01],
	[4.5465000000E+04, 4.1146990016E+01, 4.9473525260E+00, 2.4722471802E+01, 3.7469960366E+00, 9.8052238360E-01],
	[4.5470000000E+04, 4.1155019545E+01, 4.9473955584E+00, 2.4731389715E+01, 3.7472920973E+00, 9.8053055838E-01],
	[4.5475000000E+04, 4.1163049758E+01, 4.9474385865E+00, 2.4740309862E+01, 3.7475880851E+00, 9.8053872926E-01],
	[4.5480000000E+04, 4.1171080655E+01, 4.9474816102E+00, 2.4749232245E+01, 3.7478840001E+00, 9.8054689624E-01],
	[4.5485000000E+04, 4.1179112235E+01, 4.9475246295E+00, 2.4758156863E+01, 3.7481798422E+00, 9.8055505933E-01],
	[4.5490000000E+04, 4.1187144498E+01, 4.9475676445E+00, 2.4767083717E+01, 3.7484756116E+00, 9.8056321852E-01],
	[4.5495000000E+04, 4.1195177446E+01, 4.9476106552E+00, 2.4776012808E+01, 3.7487713082E+00, 9.8057137382E-01],
	[4.5500000000E+04, 4.1203211077E+01, 4.9476536615E+00, 2.4784944134E+01, 3.7490669321E+00, 9.8057952522E-01],
	[4.5505000000E+04, 4.1211245392E+01, 4.9476966634E+00, 2.4793877698E+01, 3.7493624832E+00, 9.8058767274E-01],
	[4.5510000000E+04, 4.1219280390E+01, 4.9477396610E+00, 2.4802813499E+01, 3.7496579616E+00, 9.8059581637E-01],
	[4.5515000000E+04, 4.1227316072E+01, 4.9477826542E+00, 2.4811751537E+01, 3.7499533673E+00, 9.8060395612E-01],
	[4.5520000000E+04, 4.1235352438E+01, 4.9478256431E+00, 2.4820691813E+01, 3.7502487004E+00, 9.8061209199E-01],
	[4.5525000000E+04, 4.1243389487E+01, 4.9478686277E+00, 2.4829634327E+01, 3.7505439608E+00, 9.8062022397E-01],
	[4.5530000000E+04, 4.1251427220E+01, 4.9479116079E+00, 2.4838579080E+01, 3.7508391485E+00, 9.8062835208E-01],
	[4.5535000000E+04, 4.1259465636E+01, 4.9479545837E+00, 2.4847526071E+01, 3.7511342636E+00, 9.8063647631E-01],
	[4.5540000000E+04, 4.1267504736E+01, 4.9479975552E+00, 2.4856475301E+01, 3.7514293062E+00, 9.8064459666E-01],
	[4.5545000000E+04, 4.1275544519E+01, 4.9480405224E+00, 2.4865426770E+01, 3.7517242761E+00, 9.8065271315E-01],
	[4.5550000000E+04, 4.1283584986E+01, 4.9480834852E+00, 2.4874380479E+01, 3.7520191735E+00, 9.8066082576E-01],
	[4.5555000000E+04, 4.1291626137E+01, 4.9481264437E+00, 2.4883336429E+01, 3.7523139984E+00, 9.8066893450E-01],
	[4.5560000000E+04, 4.1299667970E+01, 4.9481693978E+00, 2.4892294618E+01, 3.7526087507E+00, 9.8067703938E-01],
	[4.5565000000E+04, 4.1307710487E+01, 4.9482123476E+00, 2.4901255048E+01, 3.7529034306E+00, 9.8068514039E-01],
	[4.5570000000E+04, 4.1315753688E+01, 4.9482552930E+00, 2.4910217719E+01, 3.7531980379E+00, 9.8069323754E-01],
	[4.5575000000E+04, 4.1323797572E+01, 4.9482982341E+00, 2.4919182631E+01, 3.7534925728E+00, 9.8070133083E-01],
	[4.5580000000E+04, 4.1331842140E+01, 4.9483411709E+00, 2.4928149784E+01, 3.7537870353E+00, 9.8070942026E-01],
	[4.5585000000E+04, 4.1339887390E+01, 4.9483841034E+00, 2.4937119180E+01, 3.7540814253E+00, 9.8071750584E-01],
	[4.5590000000E+04, 4.1347933324E+01, 4.9484270314E+00, 2.4946090817E+01, 3.7543757429E+00, 9.8072558756E-01],
	[4.5595000000E+04, 4.1355979942E+01, 4.9484699552E+00, 2.4955064697E+01, 3.7546699882E+00, 9.8073366543E-01],
	[4.5600000000E+04, 4.1364027243E+01, 4.9485128746E+00, 2.4964040820E+01, 3.7549641610E+00, 9.8074173945E-01],
	[4.5605000000E+04, 4.1372075227E+01, 4.9485557897E+00, 2.4973019186E+01, 3.7552582616E+00, 9.8074980962E-01],
	[4.5610000000E+04, 4.1380123894E+01, 4.9485987005E+00, 2.4981999795E+01, 3.7555522898E+00, 9.8075787594E-01],
	[4.5615000000E+04, 4.1388173245E+01, 4.9486416069E+00, 2.4990982648E+01, 3.7558462457E+00, 9.8076593842E-01],
	[4.5620000000E+04, 4.1396223279E+01, 4.9486845090E+00, 2.4999967745E+01, 3.7561401293E+00, 9.8077399705E-01],
	[4.5625000000E+04, 4.1404273996E+01, 4.9487274068E+00, 2.5008955087E+01, 3.7564339406E+00, 9.8078205185E-01],
	[4.5630000000E+04, 4.1412325396E+01, 4.9487703002E+00, 2.5017944673E+01, 3.7567276797E+00, 9.8079010281E-01],
	[4.5635000000E+04, 4.1420377480E+01, 4.9488131893E+00, 2.5026936504E+01, 3.7570213466E+00, 9.8079814993E-01],
	[4.5640000000E+04, 4.1428430247E+01, 4.9488560741E+00, 2.5035930580E+01, 3.7573149412E+00, 9.8080619322E-01],
	[4.5645000000E+04, 4.1436483697E+01, 4.9488989546E+00, 2.5044926902E+01, 3.7576084637E+00, 9.8081423267E-01],
	[4.5650000000E+04, 4.1444537830E+01, 4.9489418307E+00, 2.5053925470E+01, 3.7579019140E+00, 9.8082226830E-01],
	[4.5655000000E+04, 4.1452592646E+01, 4.9489847025E+00, 2.5062926284E+01, 3.7581952921E+00, 9.8083030009E-01],
	[4.5660000000E+04, 4.1460648145E+01, 4.9490275700E+00, 2.5071929345E+01, 3.7584885981E+00, 9.8083832806E-01],
	[4.5665000000E+04, 4.1468704328E+01, 4.9490704332E+00, 2.5080934652E+01, 3.7587818320E+00, 9.8084635221E-01],
	[4.5670000000E+04, 4.1476761193E+01, 4.9491132920E+00, 2.5089942207E+01, 3.7590749938E+00, 9.8085437253E-01],
	[4.5675000000E+04, 4.1484818742E+01, 4.9491561465E+00, 2.5098952009E+01, 3.7593680836E+00, 9.8086238903E-01],
	[4.5680000000E+04, 4.1492876973E+01, 4.9491989967E+00, 2.5107964059E+01, 3.7596611012E+00, 9.8087040172E-01],
	[4.5685000000E+04, 4.1500935888E+01, 4.9492418426E+00, 2.5116978358E+01, 3.7599540469E+00, 9.8087841059E-01],
	[4.5690000000E+04, 4.1508995486E+01, 4.9492846842E+00, 2.5125994904E+01, 3.7602469205E+00, 9.8088641564E-01],
	[4.5695000000E+04, 4.1517055767E+01, 4.9493275214E+00, 2.5135013700E+01, 3.7605397221E+00, 9.8089441688E-01],
	[4.5700000000E+04, 4.1525116730E+01, 4.9493703543E+00, 2.5144034744E+01, 3.7608324518E+00, 9.8090241431E-01],
	[4.5705000000E+04, 4.1533178377E+01, 4.9494131830E+00, 2.5153058038E+01, 3.7611251095E+00, 9.8091040794E-01],
	[4.5710000000E+04, 4.1541240706E+01, 4.9494560073E+00, 2.5162083581E+01, 3.7614176952E+00, 9.8091839775E-01],
	[4.5715000000E+04, 4.1549303719E+01, 4.9494988272E+00, 2.5171111375E+01, 3.7617102090E+00, 9.8092638376E-01],
	[4.5720000000E+04, 4.1557367414E+01, 4.9495416429E+00, 2.5180141419E+01, 3.7620026510E+00, 9.8093436597E-01],
	[4.5725000000E+04, 4.1565431793E+01, 4.9495844543E+00, 2.5189173713E+01, 3.7622950210E+00, 9.8094234438E-01],
	[4.5730000000E+04, 4.1573496854E+01, 4.9496272613E+00, 2.5198208259E+01, 3.7625873192E+00, 9.8095031899E-01],
	[4.5735000000E+04, 4.1581562598E+01, 4.9496700641E+00, 2.5207245055E+01, 3.7628795456E+00, 9.8095828981E-01],
	[4.5740000000E+04, 4.1589629025E+01, 4.9497128625E+00, 2.5216284104E+01, 3.7631717001E+00, 9.8096625683E-01],
	[4.5745000000E+04, 4.1597696135E+01, 4.9497556566E+00, 2.5225325404E+01, 3.7634637828E+00, 9.8097422006E-01],
	[4.5750000000E+04, 4.1605763927E+01, 4.9497984464E+00, 2.5234368956E+01, 3.7637557937E+00, 9.8098217949E-01],
	[4.5755000000E+04, 4.1613832403E+01, 4.9498412319E+00, 2.5243414761E+01, 3.7640477329E+00, 9.8099013514E-01],
	[4.5760000000E+04, 4.1621901561E+01, 4.9498840131E+00, 2.5252462819E+01, 3.7643396003E+00, 9.8099808701E-01],
	[4.5765000000E+04, 4.1629971402E+01, 4.9499267900E+00, 2.5261513130E+01, 3.7646313960E+00, 9.8100603508E-01],
	[4.5770000000E+04, 4.1638041926E+01, 4.9499695626E+00, 2.5270565694E+01, 3.7649231200E+00, 9.8101397938E-01],
	[4.5775000000E+04, 4.1646113132E+01, 4.9500123309E+00, 2.5279620512E+01, 3.7652147723E+00, 9.8102191990E-01],
	[4.5780000000E+04, 4.1654185021E+01, 4.9500550949E+00, 2.5288677585E+01, 3.7655063529E+00, 9.8102985663E-01],
	[4.5785000000E+04, 4.1662257593E+01, 4.9500978546E+00, 2.5297736911E+01, 3.7657978619E+00, 9.8103778959E-01],
	[4.5790000000E+04, 4.1670330848E+01, 4.9501406100E+00, 2.5306798493E+01, 3.7660892993E+00, 9.8104571878E-01],
	[4.5795000000E+04, 4.1678404785E+01, 4.9501833611E+00, 2.5315862329E+01, 3.7663806650E+00, 9.8105364419E-01],
	[4.5800000000E+04, 4.1686479405E+01, 4.9502261079E+00, 2.5324928421E+01, 3.7666719592E+00, 9.8106156583E-01],
	[4.5805000000E+04, 4.1694554707E+01, 4.9502688504E+00, 2.5333996769E+01, 3.7669631818E+00, 9.8106948371E-01],
	[4.5810000000E+04, 4.1702630692E+01, 4.9503115886E+00, 2.5343067372E+01, 3.7672543328E+00, 9.8107739782E-01],
	[4.5815000000E+04, 4.1710707360E+01, 4.9503543225E+00, 2.5352140232E+01, 3.7675454123E+00, 9.8108530816E-01],
	[4.5820000000E+04, 4.1718784710E+01, 4.9503970521E+00, 2.5361215348E+01, 3.7678364203E+00, 9.8109321474E-01],
	[4.5825000000E+04, 4.1726862743E+01, 4.9504397774E+00, 2.5370292722E+01, 3.7681273567E+00, 9.8110111756E-01],
	[4.5830000000E+04, 4.1734941458E+01, 4.9504824984E+00, 2.5379372352E+01, 3.7684182218E+00, 9.8110901662E-01],
	[4.5835000000E+04, 4.1743020856E+01, 4.9505252151E+00, 2.5388454240E+01, 3.7687090153E+00, 9.8111691192E-01],
	[4.5840000000E+04, 4.1751100936E+01, 4.9505679276E+00, 2.5397538386E+01, 3.7689997374E+00, 9.8112480347E-01],
	[4.5845000000E+04, 4.1759181699E+01, 4.9506106357E+00, 2.5406624790E+01, 3.7692903881E+00, 9.8113269127E-01],
	[4.5850000000E+04, 4.1767263145E+01, 4.9506533396E+00, 2.5415713453E+01, 3.7695809674E+00, 9.8114057532E-01],
	[4.5855000000E+04, 4.1775345272E+01, 4.9506960392E+00, 2.5424804375E+01, 3.7698714753E+00, 9.8114845561E-01],
	[4.5860000000E+04, 4.1783428083E+01, 4.9507387344E+00, 2.5433897555E+01, 3.7701619119E+00, 9.8115633216E-01],
	[4.5865000000E+04, 4.1791511575E+01, 4.9507814254E+00, 2.5442992995E+01, 3.7704522771E+00, 9.8116420497E-01],
	[4.5870000000E+04, 4.1799595751E+01, 4.9508241122E+00, 2.5452090695E+01, 3.7707425710E+00, 9.8117207403E-01],
	[4.5875000000E+04, 4.1807680608E+01, 4.9508667946E+00, 2.5461190655E+01, 3.7710327936E+00, 9.8117993935E-01],
	[4.5880000000E+04, 4.1815766148E+01, 4.9509094727E+00, 2.5470292876E+01, 3.7713229449E+00, 9.8118780094E-01],
	[4.5885000000E+04, 4.1823852370E+01, 4.9509521466E+00, 2.5479397357E+01, 3.7716130249E+00, 9.8119565878E-01],
	[4.5890000000E+04, 4.1831939275E+01, 4.9509948162E+00, 2.5488504099E+01, 3.7719030337E+00, 9.8120351290E-01],
	[4.5895000000E+04, 4.1840026862E+01, 4.9510374815E+00, 2.5497613102E+01, 3.7721929713E+00, 9.8121136327E-01],
	[4.5900000000E+04, 4.1848115131E+01, 4.9510801425E+00, 2.5506724367E+01, 3.7724828377E+00, 9.8121920992E-01],
	[4.5905000000E+04, 4.1856204082E+01, 4.9511227992E+00, 2.5515837894E+01, 3.7727726329E+00, 9.8122705284E-01],
	[4.5910000000E+04, 4.1864293716E+01, 4.9511654517E+00, 2.5524953683E+01, 3.7730623569E+00, 9.8123489203E-01],
	[4.5915000000E+04, 4.1872384032E+01, 4.9512080998E+00, 2.5534071735E+01, 3.7733520097E+00, 9.8124272750E-01],
	[4.5920000000E+04, 4.1880475031E+01, 4.9512507437E+00, 2.5543192050E+01, 3.7736415915E+00, 9.8125055924E-01],
	[4.5925000000E+04, 4.1888566711E+01, 4.9512933834E+00, 2.5552314628E+01, 3.7739311021E+00, 9.8125838726E-01],
	[4.5930000000E+04, 4.1896659074E+01, 4.9513360187E+00, 2.5561439470E+01, 3.7742205416E+00, 9.8126621156E-01],
	[4.5935000000E+04, 4.1904752119E+01, 4.9513786498E+00, 2.5570566575E+01, 3.7745099101E+00, 9.8127403215E-01],
	[4.5940000000E+04, 4.1912845846E+01, 4.9514212766E+00, 2.5579695945E+01, 3.7747992075E+00, 9.8128184902E-01],
	[4.5945000000E+04, 4.1920940255E+01, 4.9514638991E+00, 2.5588827579E+01, 3.7750884339E+00, 9.8128966217E-01],
	[4.5950000000E+04, 4.1929035347E+01, 4.9515065174E+00, 2.5597961478E+01, 3.7753775892E+00, 9.8129747162E-01],
	[4.5955000000E+04, 4.1937131120E+01, 4.9515491314E+00, 2.5607097642E+01, 3.7756666736E+00, 9.8130527736E-01],
	[4.5960000000E+04, 4.1945227576E+01, 4.9515917411E+00, 2.5616236071E+01, 3.7759556870E+00, 9.8131307938E-01],
	[4.5965000000E+04, 4.1953324714E+01, 4.9516343466E+00, 2.5625376766E+01, 3.7762446294E+00, 9.8132087771E-01],
	[4.5970000000E+04, 4.1961422533E+01, 4.9516769478E+00, 2.5634519727E+01, 3.7765335009E+00, 9.8132867233E-01],
	[4.5975000000E+04, 4.1969521035E+01, 4.9517195447E+00, 2.5643664955E+01, 3.7768223015E+00, 9.8133646324E-01],
	[4.5980000000E+04, 4.1977620219E+01, 4.9517621373E+00, 2.5652812449E+01, 3.7771110312E+00, 9.8134425046E-01],
	[4.5985000000E+04, 4.1985720085E+01, 4.9518047257E+00, 2.5661962210E+01, 3.7773996900E+00, 9.8135203398E-01],
	[4.5990000000E+04, 4.1993820633E+01, 4.9518473098E+00, 2.5671114239E+01, 3.7776882779E+00, 9.8135981381E-01],
	[4.5995000000E+04, 4.2001921863E+01, 4.9518898897E+00, 2.5680268535E+01, 3.7779767950E+00, 9.8136758994E-01],
	[4.6000000000E+04, 4.2010023775E+01, 4.9519324653E+00, 2.5689425099E+01, 3.7782652413E+00, 9.8137536238E-01],
	[4.6005000000E+04, 4.2018126369E+01, 4.9519750366E+00, 2.5698583932E+01, 3.7785536167E+00, 9.8138313113E-01],
	[4.6010000000E+04, 4.2026229645E+01, 4.9520176037E+00, 2.5707745033E+01, 3.7788419214E+00, 9.8139089619E-01],
	[4.6015000000E+04, 4.2034333603E+01, 4.9520601665E+00, 2.5716908403E+01, 3.7791301553E+00, 9.8139865757E-01],
	[4.6020000000E+04, 4.2042438242E+01, 4.9521027251E+00, 2.5726074042E+01, 3.7794183185E+00, 9.8140641526E-01],
	[4.6025000000E+04, 4.2050543564E+01, 4.9521452794E+00, 2.5735241951E+01, 3.7797064109E+00, 9.8141416927E-01],
	[4.6030000000E+04, 4.2058649567E+01, 4.9521878294E+00, 2.5744412129E+01, 3.7799944327E+00, 9.8142191960E-01],
	[4.6035000000E+04, 4.2066768529E+01, 4.9522316789E+00, 2.5753584578E+01, 3.7802832425E+00, 9.8142966625E-01],
	[4.6040000000E+04, 4.2074891709E+01, 4.9522758991E+00, 2.5762759297E+01, 3.7805722289E+00, 9.8143740923E-01],
	[4.6045000000E+04, 4.2083015575E+01, 4.9523201149E+00, 2.5771936287E+01, 3.7808611449E+00, 9.8144514853E-01],
	[4.6050000000E+04, 4.2091140128E+01, 4.9523643262E+00, 2.5781115548E+01, 3.7811499903E+00, 9.8145288416E-01],
	[4.6055000000E+04, 4.2099265367E+01, 4.9524085332E+00, 2.5790297080E+01, 3.7814387653E+00, 9.8146061612E-01],
	[4.6060000000E+04, 4.2107391291E+01, 4.9524527358E+00, 2.5799480884E+01, 3.7817274698E+00, 9.8146834441E-01],
	[4.6065000000E+04, 4.2115517902E+01, 4.9524969340E+00, 2.5808666960E+01, 3.7820161039E+00, 9.8147606904E-01],
	[4.6070000000E+04, 4.2123645200E+01, 4.9525411277E+00, 2.5817855309E+01, 3.7823046676E+00, 9.8148379000E-01],
	[4.6075000000E+04, 4.2131773183E+01, 4.9525853171E+00, 2.5827045930E+01, 3.7825931610E+00, 9.8149150729E-01],
	[4.6080000000E+04, 4.2139901852E+01, 4.9526295021E+00, 2.5836238824E+01, 3.7828815839E+00, 9.8149922093E-01],
	[4.6085000000E+04, 4.2148031207E+01, 4.9526736826E+00, 2.5845433992E+01, 3.7831699365E+00, 9.8150693091E-01],
	[4.6090000000E+04, 4.2156161249E+01, 4.9527178588E+00, 2.5854631433E+01, 3.7834582188E+00, 9.8151463723E-01],
	[4.6095000000E+04, 4.2164291976E+01, 4.9527620306E+00, 2.5863831148E+01, 3.7837464308E+00, 9.8152233990E-01],
	[4.6100000000E+04, 4.2172423390E+01, 4.9528061980E+00, 2.5873033137E+01, 3.7840345725E+00, 9.8153003892E-01],
	[4.6105000000E+04, 4.2180555489E+01, 4.9528503609E+00, 2.5882237401E+01, 3.7843226439E+00, 9.8153773428E-01],
	[4.6110000000E+04, 4.2188688275E+01, 4.9528945195E+00, 2.5891443940E+01, 3.7846106451E+00, 9.8154542600E-01],
	[4.6115000000E+04, 4.2196821746E+01, 4.9529386737E+00, 2.5900652754E+01, 3.7848985760E+00, 9.8155311406E-01],
	[4.6120000000E+04, 4.2204955904E+01, 4.9529828235E+00, 2.5909863843E+01, 3.7851864367E+00, 9.8156079849E-01],
	[4.6125000000E+04, 4.2213090747E+01, 4.9530269689E+00, 2.5919077208E+01, 3.7854742272E+00, 9.8156847927E-01],
	[4.6130000000E+04, 4.2221226277E+01, 4.9530711099E+00, 2.5928292850E+01, 3.7857619476E+00, 9.8157615641E-01],
	[4.6135000000E+04, 4.2229362492E+01, 4.9531152465E+00, 2.5937510768E+01, 3.7860495978E+00, 9.8158382991E-01],
	[4.6140000000E+04, 4.2237499393E+01, 4.9531593787E+00, 2.5946730962E+01, 3.7863371778E+00, 9.8159149977E-01],
	[4.6145000000E+04, 4.2245636980E+01, 4.9532035066E+00, 2.5955953434E+01, 3.7866246877E+00, 9.8159916600E-01],
	[4.6150000000E+04, 4.2253775253E+01, 4.9532476300E+00, 2.5965178183E+01, 3.7869121276E+00, 9.8160682859E-01],
	[4.6155000000E+04, 4.2261914212E+01, 4.9532917491E+00, 2.5974405210E+01, 3.7871994973E+00, 9.8161448755E-01],
	[4.6160000000E+04, 4.2270053856E+01, 4.9533358638E+00, 2.5983634515E+01, 3.7874867970E+00, 9.8162214289E-01],
	[4.6165000000E+04, 4.2278194186E+01, 4.9533799741E+00, 2.5992866098E+01, 3.7877740266E+00, 9.8162979459E-01],
	[4.6170000000E+04, 4.2286335203E+01, 4.9534240800E+00, 2.6002099960E+01, 3.7880611862E+00, 9.8163744267E-01],
	[4.6175000000E+04, 4.2294476905E+01, 4.9534681815E+00, 2.6011336101E+01, 3.7883482758E+00, 9.8164508713E-01],
	[4.6180000000E+04, 4.2302619292E+01, 4.9535122786E+00, 2.6020574521E+01, 3.7886352955E+00, 9.8165272796E-01],
	[4.6185000000E+04, 4.2310762366E+01, 4.9535563714E+00, 2.6029815221E+01, 3.7889222451E+00, 9.8166036518E-01],
	[4.6190000000E+04, 4.2318906125E+01, 4.9536004598E+00, 2.6039058200E+01, 3.7892091248E+00, 9.8166799878E-01],
	[4.6195000000E+04, 4.2327050570E+01, 4.9536445438E+00, 2.6048303460E+01, 3.7894959346E+00, 9.8167562876E-01],
	[4.6200000000E+04, 4.2335195700E+01, 4.9536886234E+00, 2.6057551001E+01, 3.7897826745E+00, 9.8168325512E-01],
	[4.6205000000E+04, 4.2343341517E+01, 4.9537326986E+00, 2.6066800822E+01, 3.7900693444E+00, 9.8169087788E-01],
	[4.6210000000E+04, 4.2351488018E+01, 4.9537767695E+00, 2.6076052924E+01, 3.7903559445E+00, 9.8169849702E-01],
	[4.6215000000E+04, 4.2359635206E+01, 4.9538208360E+00, 2.6085307308E+01, 3.7906424748E+00, 9.8170611256E-01],
	[4.6220000000E+04, 4.2367783079E+01, 4.9538648981E+00, 2.6094563974E+01, 3.7909289352E+00, 9.8171372449E-01],
	[4.6225000000E+04, 4.2375931638E+01, 4.9539089558E+00, 2.6103822922E+01, 3.7912153258E+00, 9.8172133282E-01],
	[4.6230000000E+04, 4.2384080882E+01, 4.9539530092E+00, 2.6113084153E+01, 3.7915016466E+00, 9.8172893754E-01],
	[4.6235000000E+04, 4.2392230812E+01, 4.9539970582E+00, 2.6122347666E+01, 3.7917878976E+00, 9.8173653866E-01],
	[4.6240000000E+04, 4.2400381428E+01, 4.9540411028E+00, 2.6131613462E+01, 3.7920740788E+00, 9.8174413619E-01],
	[4.6245000000E+04, 4.2408532729E+01, 4.9540851430E+00, 2.6140881542E+01, 3.7923601904E+00, 9.8175173011E-01],
	[4.6250000000E+04, 4.2416684716E+01, 4.9541291789E+00, 2.6150151905E+01, 3.7926462322E+00, 9.8175932045E-01],
	[4.6255000000E+04, 4.2424837388E+01, 4.9541732104E+00, 2.6159424552E+01, 3.7929322042E+00, 9.8176690719E-01],
	[4.6260000000E+04, 4.2432990745E+01, 4.9542172376E+00, 2.6168699484E+01, 3.7932181067E+00, 9.8177449034E-01],
	[4.6265000000E+04, 4.2441144788E+01, 4.9542612604E+00, 2.6177976700E+01, 3.7935039394E+00, 9.8178206990E-01],
	[4.6270000000E+04, 4.2449299517E+01, 4.9543052788E+00, 2.6187256202E+01, 3.7937897025E+00, 9.8178964587E-01],
	[4.6275000000E+04, 4.2457454931E+01, 4.9543492928E+00, 2.6196537988E+01, 3.7940753960E+00, 9.8179721826E-01],
	[4.6280000000E+04, 4.2465611031E+01, 4.9543933025E+00, 2.6205822061E+01, 3.7943610198E+00, 9.8180478706E-01],
	[4.6285000000E+04, 4.2473767815E+01, 4.9544373078E+00, 2.6215108419E+01, 3.7946465741E+00, 9.8181235229E-01],
	[4.6290000000E+04, 4.2481925286E+01, 4.9544813088E+00, 2.6224397063E+01, 3.7949320588E+00, 9.8181991393E-01],
	[4.6295000000E+04, 4.2490083441E+01, 4.9545253053E+00, 2.6233687994E+01, 3.7952174739E+00, 9.8182747200E-01],
	[4.6300000000E+04, 4.2498242282E+01, 4.9545692976E+00, 2.6242981212E+01, 3.7955028196E+00, 9.8183502649E-01],
	[4.6305000000E+04, 4.2506401809E+01, 4.9546132854E+00, 2.6252276717E+01, 3.7957880957E+00, 9.8184257740E-01],
	[4.6310000000E+04, 4.2514562020E+01, 4.9546572690E+00, 2.6261574509E+01, 3.7960733023E+00, 9.8185012475E-01],
	[4.6315000000E+04, 4.2522722918E+01, 4.9547012481E+00, 2.6270874589E+01, 3.7963584394E+00, 9.8185766853E-01],
	[4.6320000000E+04, 4.2530884500E+01, 4.9547452229E+00, 2.6280176958E+01, 3.7966435071E+00, 9.8186520873E-01],
	[4.6325000000E+04, 4.2539046767E+01, 4.9547891933E+00, 2.6289481615E+01, 3.7969285053E+00, 9.8187274538E-01],
	[4.6330000000E+04, 4.2547209720E+01, 4.9548331594E+00, 2.6298788560E+01, 3.7972134341E+00, 9.8188027845E-01],
	[4.6335000000E+04, 4.2555373358E+01, 4.9548771212E+00, 2.6308097795E+01, 3.7974982935E+00, 9.8188780797E-01],
	[4.6340000000E+04, 4.2563537682E+01, 4.9549210785E+00, 2.6317409319E+01, 3.7977830836E+00, 9.8189533392E-01],
	[4.6345000000E+04, 4.2571702690E+01, 4.9549650315E+00, 2.6326723133E+01, 3.7980678042E+00, 9.8190285632E-01],
	[4.6350000000E+04, 4.2579868384E+01, 4.9550089802E+00, 2.6336039236E+01, 3.7983524555E+00, 9.8191037516E-01],
	[4.6355000000E+04, 4.2588034763E+01, 4.9550529245E+00, 2.6345357630E+01, 3.7986370375E+00, 9.8191789045E-01],
	[4.6360000000E+04, 4.2596201827E+01, 4.9550968645E+00, 2.6354678315E+01, 3.7989215502E+00, 9.8192540218E-01],
	[4.6365000000E+04, 4.2604369577E+01, 4.9551408001E+00, 2.6364001291E+01, 3.7992059936E+00, 9.8193291036E-01],
	[4.6370000000E+04, 4.2612538011E+01, 4.9551847314E+00, 2.6373326558E+01, 3.7994903678E+00, 9.8194041500E-01],
	[4.6375000000E+04, 4.2620707131E+01, 4.9552286583E+00, 2.6382654116E+01, 3.7997746727E+00, 9.8194791608E-01],
	[4.6380000000E+04, 4.2628876935E+01, 4.9552725809E+00, 2.6391983967E+01, 3.8000589083E+00, 9.8195541362E-01],
	[4.6385000000E+04, 4.2637047425E+01, 4.9553164991E+00, 2.6401316110E+01, 3.8003430747E+00, 9.8196290762E-01],
	[4.6390000000E+04, 4.2645218600E+01, 4.9553604130E+00, 2.6410650545E+01, 3.8006271720E+00, 9.8197039808E-01],
	[4.6395000000E+04, 4.2653390460E+01, 4.9554043226E+00, 2.6419987273E+01, 3.8009112001E+00, 9.8197788500E-01],
	[4.6400000000E+04, 4.2661563005E+01, 4.9554482278E+00, 2.6429326294E+01, 3.8011951590E+00, 9.8198536838E-01],
	[4.6405000000E+04, 4.2669736234E+01, 4.9554921286E+00, 2.6438667609E+01, 3.8014790488E+00, 9.8199284822E-01],
	[4.6410000000E+04, 4.2677910149E+01, 4.9555360251E+00, 2.6448011218E+01, 3.8017628694E+00, 9.8200032454E-01],
	[4.6415000000E+04, 4.2686084749E+01, 4.9555799173E+00, 2.6457357120E+01, 3.8020466210E+00, 9.8200779732E-01],
	[4.6420000000E+04, 4.2694260034E+01, 4.9556238052E+00, 2.6466705317E+01, 3.8023303035E+00, 9.8201526657E-01],
	[4.6425000000E+04, 4.2702436004E+01, 4.9556676887E+00, 2.6476055809E+01, 3.8026139169E+00, 9.8202273229E-01],
	[4.6430000000E+04, 4.2710612659E+01, 4.9557115678E+00, 2.6485408596E+01, 3.8028974612E+00, 9.8203019448E-01],
	[4.6435000000E+04, 4.2718789999E+01, 4.9557554427E+00, 2.6494763679E+01, 3.8031809366E+00, 9.8203765315E-01],
	[4.6440000000E+04, 4.2726968023E+01, 4.9557993131E+00, 2.6504121057E+01, 3.8034643429E+00, 9.8204510830E-01],
	[4.6445000000E+04, 4.2735146733E+01, 4.9558431793E+00, 2.6513480731E+01, 3.8037476803E+00, 9.8205255993E-01],
	[4.6450000000E+04, 4.2743326127E+01, 4.9558870411E+00, 2.6522842701E+01, 3.8040309487E+00, 9.8206000804E-01],
	[4.6455000000E+04, 4.2751506206E+01, 4.9559308986E+00, 2.6532206968E+01, 3.8043141481E+00, 9.8206745264E-01],
	[4.6460000000E+04, 4.2759686970E+01, 4.9559747518E+00, 2.6541573532E+01, 3.8045972786E+00, 9.8207489372E-01],
	[4.6465000000E+04, 4.2767868419E+01, 4.9560186006E+00, 2.6550942393E+01, 3.8048803402E+00, 9.8208233128E-01],
	[4.6470000000E+04, 4.2776050553E+01, 4.9560624451E+00, 2.6560313552E+01, 3.8051633329E+00, 9.8208976534E-01],
	[4.6475000000E+04, 4.2784233371E+01, 4.9561062853E+00, 2.6569687009E+01, 3.8054462568E+00, 9.8209719589E-01],
	[4.6480000000E+04, 4.2792416875E+01, 4.9561501211E+00, 2.6579062764E+01, 3.8057291117E+00, 9.8210462293E-01],
	[4.6485000000E+04, 4.2800601063E+01, 4.9561939526E+00, 2.6588440818E+01, 3.8060118979E+00, 9.8211204646E-01],
	[4.6490000000E+04, 4.2808785936E+01, 4.9562377798E+00, 2.6597821170E+01, 3.8062946152E+00, 9.8211946649E-01],
	[4.6495000000E+04, 4.2816971493E+01, 4.9562816026E+00, 2.6607203822E+01, 3.8065772637E+00, 9.8212688302E-01],
	[4.6500000000E+04, 4.2825157735E+01, 4.9563254212E+00, 2.6616588773E+01, 3.8068598435E+00, 9.8213429605E-01],
	[4.6505000000E+04, 4.2833344662E+01, 4.9563692354E+00, 2.6625976024E+01, 3.8071423544E+00, 9.8214170559E-01],
	[4.6510000000E+04, 4.2841532274E+01, 4.9564130453E+00, 2.6635365575E+01, 3.8074247967E+00, 9.8214911162E-01],
	[4.6515000000E+04, 4.2849720570E+01, 4.9564568508E+00, 2.6644757426E+01, 3.8077071702E+00, 9.8215651417E-01],
	[4.6520000000E+04, 4.2857909551E+01, 4.9565006521E+00, 2.6654151578E+01, 3.8079894750E+00, 9.8216391322E-01],
	[4.6525000000E+04, 4.2866099217E+01, 4.9565444490E+00, 2.6663548031E+01, 3.8082717111E+00, 9.8217130878E-01],
	[4.6530000000E+04, 4.2874289567E+01, 4.9565882416E+00, 2.6672946786E+01, 3.8085538785E+00, 9.8217870085E-01],
	[4.6535000000E+04, 4.2882480601E+01, 4.9566320299E+00, 2.6682347842E+01, 3.8088359773E+00, 9.8218608944E-01],
	[4.6540000000E+04, 4.2890672321E+01, 4.9566758138E+00, 2.6691751201E+01, 3.8091180075E+00, 9.8219347454E-01],
	[4.6545000000E+04, 4.2898864725E+01, 4.9567195935E+00, 2.6701156862E+01, 3.8093999691E+00, 9.8220085616E-01],
	[4.6550000000E+04, 4.2907057813E+01, 4.9567633688E+00, 2.6710564825E+01, 3.8096818620E+00, 9.8220823429E-01],
	[4.6555000000E+04, 4.2915251586E+01, 4.9568071398E+00, 2.6719975091E+01, 3.8099636864E+00, 9.8221560895E-01],
	[4.6560000000E+04, 4.2923446043E+01, 4.9568509065E+00, 2.6729387661E+01, 3.8102454423E+00, 9.8222298014E-01],
	[4.6565000000E+04, 4.2931641185E+01, 4.9568946689E+00, 2.6738802534E+01, 3.8105271296E+00, 9.8223034784E-01],
	[4.6570000000E+04, 4.2939837012E+01, 4.9569384270E+00, 2.6748219711E+01, 3.8108087483E+00, 9.8223771208E-01],
	[4.6575000000E+04, 4.2948033523E+01, 4.9569821808E+00, 2.6757639193E+01, 3.8110902986E+00, 9.8224507284E-01],
	[4.6580000000E+04, 4.2956230718E+01, 4.9570259302E+00, 2.6767060978E+01, 3.8113717804E+00, 9.8225243013E-01],
	[4.6585000000E+04, 4.2964428598E+01, 4.9570696754E+00, 2.6776485069E+01, 3.8116531938E+00, 9.8225978396E-01],
	[4.6590000000E+04, 4.2972627162E+01, 4.9571134162E+00, 2.6785911465E+01, 3.8119345387E+00, 9.8226713432E-01],
	[4.6595000000E+04, 4.2980826411E+01, 4.9571571527E+00, 2.6795340167E+01, 3.8122158151E+00, 9.8227448121E-01],
	[4.6600000000E+04, 4.2989026344E+01, 4.9572008849E+00, 2.6804771174E+01, 3.8124970232E+00, 9.8228182465E-01],
	[4.6605000000E+04, 4.2997226961E+01, 4.9572446129E+00, 2.6814204487E+01, 3.8127781629E+00, 9.8228916462E-01],
	[4.6610000000E+04, 4.3005428263E+01, 4.9572883365E+00, 2.6823640107E+01, 3.8130592342E+00, 9.8229650114E-01],
	[4.6615000000E+04, 4.3013630249E+01, 4.9573320558E+00, 2.6833078033E+01, 3.8133402371E+00, 9.8230383420E-01],
	[4.6620000000E+04, 4.3021832919E+01, 4.9573757708E+00, 2.6842518267E+01, 3.8136211717E+00, 9.8231116380E-01],
	[4.6625000000E+04, 4.3030036274E+01, 4.9574194815E+00, 2.6851960808E+01, 3.8139020381E+00, 9.8231848995E-01],
	[4.6630000000E+04, 4.3038240313E+01, 4.9574631879E+00, 2.6861405657E+01, 3.8141828361E+00, 9.8232581265E-01],
	[4.6635000000E+04, 4.3046445036E+01, 4.9575068900E+00, 2.6870852814E+01, 3.8144635658E+00, 9.8233313191E-01],
	[4.6640000000E+04, 4.3054650444E+01, 4.9575505878E+00, 2.6880302279E+01, 3.8147442273E+00, 9.8234044771E-01],
	[4.6645000000E+04, 4.3062856535E+01, 4.9575942812E+00, 2.6889754052E+01, 3.8150248206E+00, 9.8234776007E-01],
	[4.6650000000E+04, 4.3071063311E+01, 4.9576379704E+00, 2.6899208135E+01, 3.8153053456E+00, 9.8235506899E-01],
	[4.6655000000E+04, 4.3079270771E+01, 4.9576816553E+00, 2.6908664527E+01, 3.8155858024E+00, 9.8236237446E-01],
	[4.6660000000E+04, 4.3087478916E+01, 4.9577253359E+00, 2.6918123229E+01, 3.8158661911E+00, 9.8236967650E-01],
	[4.6665000000E+04, 4.3095687744E+01, 4.9577690123E+00, 2.6927584240E+01, 3.8161465115E+00, 9.8237697510E-01],
	[4.6670000000E+04, 4.3103897257E+01, 4.9578126843E+00, 2.6937047562E+01, 3.8164267639E+00, 9.8238427026E-01],
	[4.6675000000E+04, 4.3112107454E+01, 4.9578563520E+00, 2.6946513194E+01, 3.8167069481E+00, 9.8239156198E-01],
	[4.6680000000E+04, 4.3120318334E+01, 4.9579000154E+00, 2.6955981138E+01, 3.8169870642E+00, 9.8239885027E-01],
	[4.6685000000E+04, 4.3128529900E+01, 4.9579436745E+00, 2.6965451392E+01, 3.8172671122E+00, 9.8240613513E-01],
	[4.6690000000E+04, 4.3136742149E+01, 4.9579873294E+00, 2.6974923958E+01, 3.8175470921E+00, 9.8241341656E-01],
	[4.6695000000E+04, 4.3144955082E+01, 4.9580309799E+00, 2.6984398836E+01, 3.8178270040E+00, 9.8242069456E-01],
	[4.6700000000E+04, 4.3153168699E+01, 4.9580746262E+00, 2.6993876025E+01, 3.8181068479E+00, 9.8242796914E-01],
	[4.6705000000E+04, 4.3161383000E+01, 4.9581182682E+00, 2.7003355528E+01, 3.8183866237E+00, 9.8243524029E-01],
	[4.6710000000E+04, 4.3169597986E+01, 4.9581619059E+00, 2.7012837343E+01, 3.8186663316E+00, 9.8244250802E-01],
	[4.6715000000E+04, 4.3177813655E+01, 4.9582055393E+00, 2.7022321471E+01, 3.8189459715E+00, 9.8244977232E-01],
	[4.6720000000E+04, 4.3186030008E+01, 4.9582491684E+00, 2.7031807912E+01, 3.8192255434E+00, 9.8245703321E-01],
	[4.6725000000E+04, 4.3194247046E+01, 4.9582927932E+00, 2.7041296668E+01, 3.8195050473E+00, 9.8246429068E-01],
	[4.6730000000E+04, 4.3202464767E+01, 4.9583364137E+00, 2.7050787737E+01, 3.8197844834E+00, 9.8247154473E-01],
	[4.6735000000E+04, 4.3210683172E+01, 4.9583800300E+00, 2.7060281120E+01, 3.8200638515E+00, 9.8247879537E-01],
	[4.6740000000E+04, 4.3218902261E+01, 4.9584236420E+00, 2.7069776819E+01, 3.8203431518E+00, 9.8248604259E-01],
	[4.6745000000E+04, 4.3227122034E+01, 4.9584672497E+00, 2.7079274832E+01, 3.8206223842E+00, 9.8249328640E-01],
	[4.6750000000E+04, 4.3235342491E+01, 4.9585108531E+00, 2.7088775161E+01, 3.8209015488E+00, 9.8250052681E-01],
	[4.6755000000E+04, 4.3243563632E+01, 4.9585544522E+00, 2.7098277805E+01, 3.8211806455E+00, 9.8250776380E-01],
	[4.6760000000E+04, 4.3251785457E+01, 4.9585980471E+00, 2.7107782765E+01, 3.8214596744E+00, 9.8251499739E-01],
	[4.6765000000E+04, 4.3260007965E+01, 4.9586416377E+00, 2.7117290041E+01, 3.8217386355E+00, 9.8252222758E-01],
	[4.6770000000E+04, 4.3268231157E+01, 4.9586852240E+00, 2.7126799634E+01, 3.8220175289E+00, 9.8252945436E-01],
	[4.6775000000E+04, 4.3276464020E+01, 4.9587297411E+00, 2.7136311544E+01, 3.8222969802E+00, 9.8253667774E-01],
	[4.6780000000E+04, 4.3284704380E+01, 4.9587749625E+00, 2.7145825771E+01, 3.8225768380E+00, 9.8254389772E-01],
	[4.6785000000E+04, 4.3292945428E+01, 4.9588201795E+00, 2.7155342315E+01, 3.8228566283E+00, 9.8255111430E-01],
	[4.6790000000E+04, 4.3301187164E+01, 4.9588653920E+00, 2.7164861178E+01, 3.8231363511E+00, 9.8255832749E-01],
	[4.6795000000E+04, 4.3309429589E+01, 4.9589106001E+00, 2.7174382358E+01, 3.8234160062E+00, 9.8256553728E-01],
	[4.6800000000E+04, 4.3317672701E+01, 4.9589558039E+00, 2.7183905857E+01, 3.8236955939E+00, 9.8257274368E-01],
	[4.6805000000E+04, 4.3325916502E+01, 4.9590010032E+00, 2.7193431675E+01, 3.8239751141E+00, 9.8257994669E-01],
	[4.6810000000E+04, 4.3334160990E+01, 4.9590461981E+00, 2.7202959811E+01, 3.8242545668E+00, 9.8258714631E-01],
	[4.6815000000E+04, 4.3342406166E+01, 4.9590913885E+00, 2.7212490268E+01, 3.8245339520E+00, 9.8259434254E-01],
	[4.6820000000E+04, 4.3350652031E+01, 4.9591365746E+00, 2.7222023044E+01, 3.8248132697E+00, 9.8260153538E-01],
	[4.6825000000E+04, 4.3358898583E+01, 4.9591817562E+00, 2.7231558140E+01, 3.8250925201E+00, 9.8260872484E-01],
	[4.6830000000E+04, 4.3367145824E+01, 4.9592269335E+00, 2.7241095556E+01, 3.8253717030E+00, 9.8261591092E-01],
	[4.6835000000E+04, 4.3375393752E+01, 4.9592721063E+00, 2.7250635293E+01, 3.8256508185E+00, 9.8262309362E-01],
	[4.6840000000E+04, 4.3383642368E+01, 4.9593172747E+00, 2.7260177351E+01, 3.8259298667E+00, 9.8263027294E-01],
	[4.6845000000E+04, 4.3391891672E+01, 4.9593624387E+00, 2.7269721730E+01, 3.8262088475E+00, 9.8263744888E-01],
	[4.6850000000E+04, 4.3400141664E+01, 4.9594075983E+00, 2.7279268431E+01, 3.8264877609E+00, 9.8264462144E-01],
	[4.6855000000E+04, 4.3408392344E+01, 4.9594527535E+00, 2.7288817454E+01, 3.8267666071E+00, 9.8265179063E-01],
	[4.6860000000E+04, 4.3416643712E+01, 4.9594979042E+00, 2.7298368799E+01, 3.8270453859E+00, 9.8265895645E-01],
	[4.6865000000E+04, 4.3424895768E+01, 4.9595430506E+00, 2.7307922467E+01, 3.8273240975E+00, 9.8266611890E-01],
	[4.6870000000E+04, 4.3433148511E+01, 4.9595881926E+00, 2.7317478457E+01, 3.8276027418E+00, 9.8267327797E-01],
	[4.6875000000E+04, 4.3441401943E+01, 4.9596333301E+00, 2.7327036771E+01, 3.8278813188E+00, 9.8268043368E-01],
	[4.6880000000E+04, 4.3449656062E+01, 4.9596784633E+00, 2.7336597409E+01, 3.8281598286E+00, 9.8268758603E-01],
	[4.6885000000E+04, 4.3457910868E+01, 4.9597235920E+00, 2.7346160370E+01, 3.8284382712E+00, 9.8269473501E-01],
	[4.6890000000E+04, 4.3466166363E+01, 4.9597687164E+00, 2.7355725655E+01, 3.8287166467E+00, 9.8270188063E-01],
	[4.6895000000E+04, 4.3474422545E+01, 4.9598138363E+00, 2.7365293265E+01, 3.8289949549E+00, 9.8270902288E-01],
	[4.6900000000E+04, 4.3482679416E+01, 4.9598589519E+00, 2.7374863200E+01, 3.8292731960E+00, 9.8271616178E-01],
	[4.6905000000E+04, 4.3490936973E+01, 4.9599040630E+00, 2.7384435459E+01, 3.8295513700E+00, 9.8272329732E-01],
	[4.6910000000E+04, 4.3499195219E+01, 4.9599491698E+00, 2.7394010044E+01, 3.8298294768E+00, 9.8273042951E-01],
	[4.6915000000E+04, 4.3507454152E+01, 4.9599942721E+00, 2.7403586955E+01, 3.8301075166E+00, 9.8273755834E-01],
	[4.6920000000E+04, 4.3515713773E+01, 4.9600393701E+00, 2.7413166192E+01, 3.8303854892E+00, 9.8274468381E-01],
	[4.6925000000E+04, 4.3523974081E+01, 4.9600844636E+00, 2.7422747755E+01, 3.8306633948E+00, 9.8275180594E-01],
	[4.6930000000E+04, 4.3532235078E+01, 4.9601295528E+00, 2.7432331645E+01, 3.8309412334E+00, 9.8275892472E-01],
	[4.6935000000E+04, 4.3540496761E+01, 4.9601746376E+00, 2.7441917863E+01, 3.8312190049E+00, 9.8276604015E-01],
	[4.6940000000E+04, 4.3548759133E+01, 4.9602197180E+00, 2.7451506407E+01, 3.8314967094E+00, 9.8277315224E-01],
	[4.6945000000E+04, 4.3557022192E+01, 4.9602647940E+00, 2.7461097279E+01, 3.8317743470E+00, 9.8278026098E-01],
	[4.6950000000E+04, 4.3565285938E+01, 4.9603098655E+00, 2.7470690479E+01, 3.8320519175E+00, 9.8278736637E-01],
	[4.6955000000E+04, 4.3573550372E+01, 4.9603549328E+00, 2.7480286007E+01, 3.8323294212E+00, 9.8279446843E-01],
	[4.6960000000E+04, 4.3581815494E+01, 4.9603999956E+00, 2.7489883864E+01, 3.8326068578E+00, 9.8280156715E-01],
	[4.6965000000E+04, 4.3590081303E+01, 4.9604450540E+00, 2.7499484049E+01, 3.8328842276E+00, 9.8280866253E-01],
	[4.6970000000E+04, 4.3598347800E+01, 4.9604901080E+00, 2.7509086564E+01, 3.8331615305E+00, 9.8281575458E-01],
	[4.6975000000E+04, 4.3606614984E+01, 4.9605351577E+00, 2.7518691409E+01, 3.8334387665E+00, 9.8282284329E-01],
	[4.6980000000E+04, 4.3614882856E+01, 4.9605802030E+00, 2.7528298583E+01, 3.8337159356E+00, 9.8282992867E-01],
	[4.6985000000E+04, 4.3623151415E+01, 4.9606252438E+00, 2.7537908088E+01, 3.8339930379E+00, 9.8283701072E-01],
	[4.6990000000E+04, 4.3631420661E+01, 4.9606702803E+00, 2.7547519923E+01, 3.8342700734E+00, 9.8284408944E-01],
	[4.6995000000E+04, 4.3639690595E+01, 4.9607153125E+00, 2.7557134088E+01, 3.8345470420E+00, 9.8285116483E-01],
	[4.7000000000E+04, 4.3647961217E+01, 4.9607603402E+00, 2.7566750585E+01, 3.8348239439E+00, 9.8285823690E-01],
	[4.7005000000E+04, 4.3656232526E+01, 4.9608053636E+00, 2.7576369414E+01, 3.8351007790E+00, 9.8286530564E-01],
	[4.7010000000E+04, 4.3664504522E+01, 4.9608503825E+00, 2.7585990574E+01, 3.8353775474E+00, 9.8287237106E-01],
	[4.7015000000E+04, 4.3672777205E+01, 4.9608953971E+00, 2.7595614066E+01, 3.8356542490E+00, 9.8287943316E-01],
	[4.7020000000E+04, 4.3681050576E+01, 4.9609404073E+00, 2.7605239891E+01, 3.8359308839E+00, 9.8288649194E-01],
	[4.7025000000E+04, 4.3689324634E+01, 4.9609854132E+00, 2.7614868048E+01, 3.8362074521E+00, 9.8289354741E-01],
	[4.7030000000E+04, 4.3697599380E+01, 4.9610304146E+00, 2.7624498538E+01, 3.8364839537E+00, 9.8290059956E-01],
	[4.7035000000E+04, 4.3705874813E+01, 4.9610754117E+00, 2.7634131362E+01, 3.8367603886E+00, 9.8290764839E-01],
	[4.7040000000E+04, 4.3714150933E+01, 4.9611204044E+00, 2.7643766519E+01, 3.8370367568E+00, 9.8291469391E-01],
	[4.7045000000E+04, 4.3722427740E+01, 4.9611653928E+00, 2.7653404011E+01, 3.8373130584E+00, 9.8292173612E-01],
	[4.7050000000E+04, 4.3730705235E+01, 4.9612103767E+00, 2.7663043836E+01, 3.8375892934E+00, 9.8292877503E-01],
	[4.7055000000E+04, 4.3738983417E+01, 4.9612553563E+00, 2.7672685997E+01, 3.8378654619E+00, 9.8293581062E-01],
	[4.7060000000E+04, 4.3747262286E+01, 4.9613003315E+00, 2.7682330492E+01, 3.8381415637E+00, 9.8294284291E-01],
	[4.7065000000E+04, 4.3755541842E+01, 4.9613453024E+00, 2.7691977322E+01, 3.8384175991E+00, 9.8294987190E-01],
	[4.7070000000E+04, 4.3763822086E+01, 4.9613902689E+00, 2.7701626488E+01, 3.8386935678E+00, 9.8295689758E-01],
	[4.7075000000E+04, 4.3772103016E+01, 4.9614352310E+00, 2.7711277990E+01, 3.8389694701E+00, 9.8296391996E-01],
	[4.7080000000E+04, 4.3780384634E+01, 4.9614801887E+00, 2.7720931828E+01, 3.8392453059E+00, 9.8297093905E-01],
	[4.7085000000E+04, 4.3788666939E+01, 4.9615251421E+00, 2.7730588003E+01, 3.8395210752E+00, 9.8297795483E-01],
	[4.7090000000E+04, 4.3796949931E+01, 4.9615700911E+00, 2.7740246514E+01, 3.8397967781E+00, 9.8298496733E-01],
	[4.7095000000E+04, 4.3805233610E+01, 4.9616150357E+00, 2.7749907363E+01, 3.8400724145E+00, 9.8299197652E-01],
	[4.7100000000E+04, 4.3813517977E+01, 4.9616599760E+00, 2.7759570549E+01, 3.8403479844E+00, 9.8299898243E-01],
	[4.7105000000E+04, 4.3821803030E+01, 4.9617049119E+00, 2.7769236072E+01, 3.8406234880E+00, 9.8300598504E-01],
	[4.7110000000E+04, 4.3830088771E+01, 4.9617498435E+00, 2.7778903934E+01, 3.8408989252E+00, 9.8301298437E-01],
	[4.7115000000E+04, 4.3838375198E+01, 4.9617947707E+00, 2.7788574135E+01, 3.8411742961E+00, 9.8301998040E-01],
	[4.7120000000E+04, 4.3846662312E+01, 4.9618396935E+00, 2.7798246674E+01, 3.8414496006E+00, 9.8302697316E-01],
	[4.7125000000E+04, 4.3854950114E+01, 4.9618846120E+00, 2.7807921552E+01, 3.8417248387E+00, 9.8303396262E-01],
	[4.7130000000E+04, 4.3863238603E+01, 4.9619295261E+00, 2.7817598769E+01, 3.8420000106E+00, 9.8304094881E-01],
	[4.7135000000E+04, 4.3871527778E+01, 4.9619744358E+00, 2.7827278326E+01, 3.8422751161E+00, 9.8304793172E-01],
	[4.7140000000E+04, 4.3879817640E+01, 4.9620193412E+00, 2.7836960223E+01, 3.8425501554E+00, 9.8305491134E-01],
	[4.7145000000E+04, 4.3888108190E+01, 4.9620642423E+00, 2.7846644461E+01, 3.8428251284E+00, 9.8306188769E-01],
	[4.7150000000E+04, 4.3896399426E+01, 4.9621091389E+00, 2.7856331039E+01, 3.8431000352E+00, 9.8306886076E-01],
	[4.7155000000E+04, 4.3904691350E+01, 4.9621540313E+00, 2.7866019958E+01, 3.8433748758E+00, 9.8307583056E-01],
	[4.7160000000E+04, 4.3912983960E+01, 4.9621989192E+00, 2.7875711218E+01, 3.8436496501E+00, 9.8308279709E-01],
	[4.7165000000E+04, 4.3921277257E+01, 4.9622438029E+00, 2.7885404820E+01, 3.8439243583E+00, 9.8308976034E-01],
	[4.7170000000E+04, 4.3929571241E+01, 4.9622886821E+00, 2.7895100764E+01, 3.8441990003E+00, 9.8309672033E-01],
	[4.7175000000E+04, 4.3937865911E+01, 4.9623335571E+00, 2.7904799050E+01, 3.8444735762E+00, 9.8310367705E-01],
	[4.7180000000E+04, 4.3946161269E+01, 4.9623784276E+00, 2.7914499678E+01, 3.8447480859E+00, 9.8311063050E-01],
	[4.7185000000E+04, 4.3954457313E+01, 4.9624232938E+00, 2.7924202650E+01, 3.8450225295E+00, 9.8311758069E-01],
	[4.7190000000E+04, 4.3962754045E+01, 4.9624681557E+00, 2.7933907964E+01, 3.8452969070E+00, 9.8312452762E-01],
	[4.7195000000E+04, 4.3971051463E+01, 4.9625130132E+00, 2.7943615622E+01, 3.8455712185E+00, 9.8313147129E-01],
	[4.7200000000E+04, 4.3979349568E+01, 4.9625578664E+00, 2.7953325624E+01, 3.8458454639E+00, 9.8313841170E-01],
	[4.7205000000E+04, 4.3987648359E+01, 4.9626027152E+00, 2.7963037970E+01, 3.8461196433E+00, 9.8314534885E-01],
	[4.7210000000E+04, 4.3995947837E+01, 4.9626475597E+00, 2.7972752661E+01, 3.8463937566E+00, 9.8315228274E-01],
	[4.7215000000E+04, 4.4004248002E+01, 4.9626923999E+00, 2.7982469696E+01, 3.8466678039E+00, 9.8315921338E-01],
	[4.7220000000E+04, 4.4012548854E+01, 4.9627372357E+00, 2.7992189076E+01, 3.8469417853E+00, 9.8316614077E-01],
	[4.7225000000E+04, 4.4020850393E+01, 4.9627820671E+00, 2.8001910802E+01, 3.8472157007E+00, 9.8317306490E-01],
	[4.7230000000E+04, 4.4029152618E+01, 4.9628268942E+00, 2.8011634873E+01, 3.8474895501E+00, 9.8317998579E-01],
	[4.7235000000E+04, 4.4037455530E+01, 4.9628717170E+00, 2.8021361291E+01, 3.8477633336E+00, 9.8318690343E-01],
	[4.7240000000E+04, 4.4045759128E+01, 4.9629165355E+00, 2.8031090054E+01, 3.8480370512E+00, 9.8319381782E-01],
	[4.7245000000E+04, 4.4054063413E+01, 4.9629613495E+00, 2.8040821165E+01, 3.8483107030E+00, 9.8320072897E-01],
	[4.7250000000E+04, 4.4062368385E+01, 4.9630061593E+00, 2.8050554622E+01, 3.8485842888E+00, 9.8320763688E-01],
	[4.7255000000E+04, 4.4070674043E+01, 4.9630509647E+00, 2.8060290427E+01, 3.8488578088E+00, 9.8321454155E-01],
	[4.7260000000E+04, 4.4078980388E+01, 4.9630957658E+00, 2.8070028579E+01, 3.8491312629E+00, 9.8322144297E-01],
	[4.7265000000E+04, 4.4087287419E+01, 4.9631405626E+00, 2.8079769079E+01, 3.8494046512E+00, 9.8322834116E-01],
	[4.7270000000E+04, 4.4095595137E+01, 4.9631853550E+00, 2.8089511928E+01, 3.8496779737E+00, 9.8323523612E-01],
	[4.7275000000E+04, 4.4103903542E+01, 4.9632301431E+00, 2.8099257125E+01, 3.8499512305E+00, 9.8324212783E-01],
	[4.7280000000E+04, 4.4112212633E+01, 4.9632749268E+00, 2.8109004671E+01, 3.8502244214E+00, 9.8324901632E-01],
	[4.7285000000E+04, 4.4120522410E+01, 4.9633197062E+00, 2.8118754566E+01, 3.8504975467E+00, 9.8325590158E-01],
	[4.7290000000E+04, 4.4128832874E+01, 4.9633644813E+00, 2.8128506811E+01, 3.8507706062E+00, 9.8326278360E-01],
	[4.7295000000E+04, 4.4137144025E+01, 4.9634092521E+00, 2.8138261405E+01, 3.8510435999E+00, 9.8326966240E-01],
	[4.7300000000E+04, 4.4145455862E+01, 4.9634540185E+00, 2.8148018350E+01, 3.8513165280E+00, 9.8327653797E-01],
	[4.7305000000E+04, 4.4153768385E+01, 4.9634987806E+00, 2.8157777645E+01, 3.8515893904E+00, 9.8328341032E-01],
	[4.7310000000E+04, 4.4162081595E+01, 4.9635435384E+00, 2.8167539291E+01, 3.8518621872E+00, 9.8329027944E-01],
	[4.7315000000E+04, 4.4170395491E+01, 4.9635882918E+00, 2.8177303288E+01, 3.8521349183E+00, 9.8329714535E-01],
	[4.7320000000E+04, 4.4178710074E+01, 4.9636330409E+00, 2.8187069636E+01, 3.8524075838E+00, 9.8330400803E-01],
	[4.7325000000E+04, 4.4187025343E+01, 4.9636777857E+00, 2.8196838336E+01, 3.8526801837E+00, 9.8331086749E-01],
	[4.7330000000E+04, 4.4195341298E+01, 4.9637225262E+00, 2.8206609388E+01, 3.8529527180E+00, 9.8331772374E-01],
	[4.7335000000E+04, 4.4203657940E+01, 4.9637672623E+00, 2.8216382793E+01, 3.8532251867E+00, 9.8332457678E-01],
	[4.7340000000E+04, 4.4211975268E+01, 4.9638119942E+00, 2.8226158550E+01, 3.8534975899E+00, 9.8333142660E-01],
	[4.7345000000E+04, 4.4220293282E+01, 4.9638567217E+00, 2.8235936660E+01, 3.8537699276E+00, 9.8333827321E-01],
	[4.7350000000E+04, 4.4228611983E+01, 4.9639014449E+00, 2.8245717124E+01, 3.8540421997E+00, 9.8334511661E-01],
	[4.7355000000E+04, 4.4236931370E+01, 4.9639461637E+00, 2.8255499941E+01, 3.8543144064E+00, 9.8335195680E-01],
	[4.7360000000E+04, 4.4245251443E+01, 4.9639908783E+00, 2.8265285112E+01, 3.8545865475E+00, 9.8335879379E-01],
	[4.7365000000E+04, 4.4253572202E+01, 4.9640355885E+00, 2.8275072638E+01, 3.8548586233E+00, 9.8336562757E-01],
	[4.7370000000E+04, 4.4261893648E+01, 4.9640802944E+00, 2.8284862518E+01, 3.8551306335E+00, 9.8337245815E-01],
	[4.7375000000E+04, 4.4270215780E+01, 4.9641249960E+00, 2.8294654753E+01, 3.8554025784E+00, 9.8337928553E-01],
	[4.7380000000E+04, 4.4278538598E+01, 4.9641696933E+00, 2.8304449343E+01, 3.8556744579E+00, 9.8338610971E-01],
	[4.7385000000E+04, 4.4286862102E+01, 4.9642143863E+00, 2.8314246289E+01, 3.8559462719E+00, 9.8339293068E-01],
	[4.7390000000E+04, 4.4295186293E+01, 4.9642590749E+00, 2.8324045591E+01, 3.8562180206E+00, 9.8339974847E-01],
	[4.7395000000E+04, 4.4303511169E+01, 4.9643037593E+00, 2.8333847248E+01, 3.8564897040E+00, 9.8340656305E-01],
	[4.7400000000E+04, 4.4311836732E+01, 4.9643484393E+00, 2.8343651263E+01, 3.8567613220E+00, 9.8341337445E-01],
	[4.7405000000E+04, 4.4320162981E+01, 4.9643931150E+00, 2.8353457634E+01, 3.8570328747E+00, 9.8342018265E-01],
	[4.7410000000E+04, 4.4328489916E+01, 4.9644377864E+00, 2.8363266362E+01, 3.8573043621E+00, 9.8342698766E-01],
	[4.7415000000E+04, 4.4336817537E+01, 4.9644824535E+00, 2.8373077448E+01, 3.8575757842E+00, 9.8343378949E-01],
	[4.7420000000E+04, 4.4345145844E+01, 4.9645271163E+00, 2.8382890891E+01, 3.8578471411E+00, 9.8344058812E-01],
	[4.7425000000E+04, 4.4353474837E+01, 4.9645717748E+00, 2.8392706693E+01, 3.8581184327E+00, 9.8344738358E-01],
	[4.7430000000E+04, 4.4361804517E+01, 4.9646164290E+00, 2.8402524853E+01, 3.8583896592E+00, 9.8345417584E-01],
	[4.7435000000E+04, 4.4370134882E+01, 4.9646610788E+00, 2.8412345372E+01, 3.8586608204E+00, 9.8346096493E-01],
	[4.7440000000E+04, 4.4378465933E+01, 4.9647057244E+00, 2.8422168250E+01, 3.8589319164E+00, 9.8346775084E-01],
	[4.7445000000E+04, 4.4386797671E+01, 4.9647503657E+00, 2.8431993487E+01, 3.8592029472E+00, 9.8347453357E-01],
	[4.7450000000E+04, 4.4395130094E+01, 4.9647950026E+00, 2.8441821083E+01, 3.8594739129E+00, 9.8348131312E-01],
	[4.7455000000E+04, 4.4403463203E+01, 4.9648396353E+00, 2.8451651040E+01, 3.8597448135E+00, 9.8348808949E-01],
	[4.7460000000E+04, 4.4411796998E+01, 4.9648842636E+00, 2.8461483357E+01, 3.8600156489E+00, 9.8349486269E-01],
	[4.7465000000E+04, 4.4420131479E+01, 4.9649288877E+00, 2.8471318035E+01, 3.8602864193E+00, 9.8350163272E-01],
	[4.7470000000E+04, 4.4428466646E+01, 4.9649735075E+00, 2.8481155074E+01, 3.8605571245E+00, 9.8350839958E-01],
	[4.7475000000E+04, 4.4436802499E+01, 4.9650181229E+00, 2.8490994474E+01, 3.8608277647E+00, 9.8351516327E-01],
	[4.7480000000E+04, 4.4445139038E+01, 4.9650627341E+00, 2.8500836235E+01, 3.8610983399E+00, 9.8352192380E-01],
	[4.7485000000E+04, 4.4453476263E+01, 4.9651073409E+00, 2.8510680359E+01, 3.8613688500E+00, 9.8352868116E-01],
	[4.7490000000E+04, 4.4461814173E+01, 4.9651519435E+00, 2.8520526844E+01, 3.8616392952E+00, 9.8353543535E-01],
	[4.7495000000E+04, 4.4470152770E+01, 4.9651965418E+00, 2.8530375693E+01, 3.8619096753E+00, 9.8354218638E-01],
	[4.7500000000E+04, 4.4478492052E+01, 4.9652411358E+00, 2.8540226904E+01, 3.8621799905E+00, 9.8354893425E-01],
	[4.7505000000E+04, 4.4486832020E+01, 4.9652857254E+00, 2.8550080478E+01, 3.8624502407E+00, 9.8355567896E-01],
	[4.7510000000E+04, 4.4495172674E+01, 4.9653303108E+00, 2.8559936416E+01, 3.8627204260E+00, 9.8356242052E-01],
	[4.7515000000E+04, 4.4503514013E+01, 4.9653748919E+00, 2.8569794717E+01, 3.8629905464E+00, 9.8356915892E-01],
	[4.7520000000E+04, 4.4511856039E+01, 4.9654194687E+00, 2.8579655383E+01, 3.8632606018E+00, 9.8357589416E-01],
	[4.7525000000E+04, 4.4520198750E+01, 4.9654640413E+00, 2.8589518413E+01, 3.8635305924E+00, 9.8358262625E-01],
	[4.7530000000E+04, 4.4528557540E+01, 4.9655101791E+00, 2.8599383808E+01, 3.8638015844E+00, 9.8358935519E-01],
	[4.7535000000E+04, 4.4536917411E+01, 4.9655563524E+00, 2.8609251568E+01, 3.8640725387E+00, 9.8359608099E-01],
	[4.7540000000E+04, 4.4545277971E+01, 4.9656025212E+00, 2.8619121693E+01, 3.8643434284E+00, 9.8360280363E-01],
	[4.7545000000E+04, 4.4553639222E+01, 4.9656486855E+00, 2.8628994184E+01, 3.8646142533E+00, 9.8360952313E-01],
	[4.7550000000E+04, 4.4562001162E+01, 4.9656948455E+00, 2.8638869041E+01, 3.8648850136E+00, 9.8361623948E-01],
	[4.7555000000E+04, 4.4570363792E+01, 4.9657410010E+00, 2.8648746264E+01, 3.8651557092E+00, 9.8362295269E-01],
	[4.7560000000E+04, 4.4578727112E+01, 4.9657871521E+00, 2.8658625855E+01, 3.8654263402E+00, 9.8362966276E-01],
	[4.7565000000E+04, 4.4587091122E+01, 4.9658332988E+00, 2.8668507812E+01, 3.8656969066E+00, 9.8363636969E-01],
	[4.7570000000E+04, 4.4595455822E+01, 4.9658794410E+00, 2.8678392136E+01, 3.8659674084E+00, 9.8364307348E-01],
	[4.7575000000E+04, 4.4603821212E+01, 4.9659255789E+00, 2.8688278828E+01, 3.8662378456E+00, 9.8364977414E-01],
	[4.7580000000E+04, 4.4612187292E+01, 4.9659717123E+00, 2.8698167888E+01, 3.8665082183E+00, 9.8365647166E-01],
	[4.7585000000E+04, 4.4620554061E+01, 4.9660178413E+00, 2.8708059316E+01, 3.8667785265E+00, 9.8366316605E-01],
	[4.7590000000E+04, 4.4628921520E+01, 4.9660639659E+00, 2.8717953113E+01, 3.8670487701E+00, 9.8366985731E-01],
	[4.7595000000E+04, 4.4637289669E+01, 4.9661100860E+00, 2.8727849279E+01, 3.8673189492E+00, 9.8367654543E-01],
	[4.7600000000E+04, 4.4645658508E+01, 4.9661562018E+00, 2.8737747813E+01, 3.8675890638E+00, 9.8368323043E-01],
	[4.7605000000E+04, 4.4654028037E+01, 4.9662023131E+00, 2.8747648718E+01, 3.8678591140E+00, 9.8368991230E-01],
	[4.7610000000E+04, 4.4662398255E+01, 4.9662484200E+00, 2.8757551992E+01, 3.8681290997E+00, 9.8369659105E-01],
	[4.7615000000E+04, 4.4670769163E+01, 4.9662945225E+00, 2.8767457637E+01, 3.8683990210E+00, 9.8370326667E-01],
	[4.7620000000E+04, 4.4679140761E+01, 4.9663406206E+00, 2.8777365651E+01, 3.8686688778E+00, 9.8370993917E-01],
	[4.7625000000E+04, 4.4687513048E+01, 4.9663867143E+00, 2.8787276037E+01, 3.8689386703E+00, 9.8371660855E-01],
	[4.7630000000E+04, 4.4695886025E+01, 4.9664328035E+00, 2.8797188794E+01, 3.8692083984E+00, 9.8372327482E-01],
	[4.7635000000E+04, 4.4704259692E+01, 4.9664788884E+00, 2.8807103922E+01, 3.8694780621E+00, 9.8372993796E-01],
	[4.7640000000E+04, 4.4712634048E+01, 4.9665249688E+00, 2.8817021422E+01, 3.8697476615E+00, 9.8373659799E-01],
	[4.7645000000E+04, 4.4721009094E+01, 4.9665710449E+00, 2.8826941294E+01, 3.8700171966E+00, 9.8374325491E-01],
	[4.7650000000E+04, 4.4729384830E+01, 4.9666171165E+00, 2.8836863539E+01, 3.8702866673E+00, 9.8374990872E-01],
	[4.7655000000E+04, 4.4737761255E+01, 4.9666631837E+00, 2.8846788156E+01, 3.8705560738E+00, 9.8375655941E-01],
	[4.7660000000E+04, 4.4746138370E+01, 4.9667092465E+00, 2.8856715146E+01, 3.8708254160E+00, 9.8376320700E-01],
	[4.7665000000E+04, 4.4754516174E+01, 4.9667553050E+00, 2.8866644510E+01, 3.8710946939E+00, 9.8376985147E-01],
	[4.7670000000E+04, 4.4762894668E+01, 4.9668013590E+00, 2.8876576247E+01, 3.8713639076E+00, 9.8377649285E-01],
	[4.7675000000E+04, 4.4771273851E+01, 4.9668474086E+00, 2.8886510358E+01, 3.8716330571E+00, 9.8378313111E-01],
	[4.7680000000E+04, 4.4779653724E+01, 4.9668934538E+00, 2.8896446844E+01, 3.8719021424E+00, 9.8378976628E-01],
	[4.7685000000E+04, 4.4788034287E+01, 4.9669394946E+00, 2.8906385704E+01, 3.8721711635E+00, 9.8379639835E-01],
	[4.7690000000E+04, 4.4796415539E+01, 4.9669855310E+00, 2.8916326939E+01, 3.8724401205E+00, 9.8380302731E-01],
	[4.7695000000E+04, 4.4804797480E+01, 4.9670315630E+00, 2.8926270549E+01, 3.8727090133E+00, 9.8380965318E-01],
	[4.7700000000E+04, 4.4813180111E+01, 4.9670775906E+00, 2.8936216535E+01, 3.8729778419E+00, 9.8381627595E-01],
	[4.7705000000E+04, 4.4821563431E+01, 4.9671236138E+00, 2.8946164897E+01, 3.8732466065E+00, 9.8382289563E-01],
	[4.7710000000E+04, 4.4829947441E+01, 4.9671696326E+00, 2.8956115635E+01, 3.8735153069E+00, 9.8382951222E-01],
	[4.7715000000E+04, 4.4838332140E+01, 4.9672156470E+00, 2.8966068749E+01, 3.8737839433E+00, 9.8383612571E-01],
	[4.7720000000E+04, 4.4846717529E+01, 4.9672616570E+00, 2.8976024241E+01, 3.8740525156E+00, 9.8384273611E-01],
	[4.7725000000E+04, 4.4855103607E+01, 4.9673076626E+00, 2.8985982109E+01, 3.8743210239E+00, 9.8384934343E-01],
	[4.7730000000E+04, 4.4863490374E+01, 4.9673536638E+00, 2.8995942355E+01, 3.8745894682E+00, 9.8385594766E-01],
	[4.7735000000E+04, 4.4871877831E+01, 4.9673996607E+00, 2.9005904979E+01, 3.8748578484E+00, 9.8386254881E-01],
	[4.7740000000E+04, 4.4880265977E+01, 4.9674456531E+00, 2.9015869981E+01, 3.8751261647E+00, 9.8386914687E-01],
	[4.7745000000E+04, 4.4888654812E+01, 4.9674916411E+00, 2.9025837361E+01, 3.8753944170E+00, 9.8387574185E-01],
	[4.7750000000E+04, 4.4897044336E+01, 4.9675376248E+00, 2.9035807120E+01, 3.8756626053E+00, 9.8388233375E-01],
	[4.7755000000E+04, 4.4905434550E+01, 4.9675836041E+00, 2.9045779258E+01, 3.8759307298E+00, 9.8388892257E-01],
	[4.7760000000E+04, 4.4913825454E+01, 4.9676295790E+00, 2.9055753776E+01, 3.8761987903E+00, 9.8389550832E-01],
	[4.7765000000E+04, 4.4922217046E+01, 4.9676755494E+00, 2.9065730673E+01, 3.8764667869E+00, 9.8390209099E-01],
	[4.7770000000E+04, 4.4930609328E+01, 4.9677215156E+00, 2.9075709951E+01, 3.8767347196E+00, 9.8390867058E-01],
	[4.7775000000E+04, 4.4939002298E+01, 4.9677674773E+00, 2.9085691608E+01, 3.8770025884E+00, 9.8391524711E-01],
	[4.7780000000E+04, 4.4947395959E+01, 4.9678134346E+00, 2.9095675647E+01, 3.8772703934E+00, 9.8392182056E-01],
	[4.7785000000E+04, 4.4955790308E+01, 4.9678593876E+00, 2.9105662066E+01, 3.8775381346E+00, 9.8392839095E-01],
	[4.7790000000E+04, 4.4964185346E+01, 4.9679053361E+00, 2.9115650866E+01, 3.8778058120E+00, 9.8393495827E-01],
	[4.7795000000E+04, 4.4972581074E+01, 4.9679512803E+00, 2.9125642049E+01, 3.8780734255E+00, 9.8394152252E-01],
	[4.7800000000E+04, 4.4980977491E+01, 4.9679972201E+00, 2.9135635613E+01, 3.8783409753E+00, 9.8394808371E-01],
	[4.7805000000E+04, 4.4989374597E+01, 4.9680431556E+00, 2.9145631559E+01, 3.8786084614E+00, 9.8395464183E-01],
	[4.7810000000E+04, 4.4997772392E+01, 4.9680890866E+00, 2.9155629888E+01, 3.8788758837E+00, 9.8396119690E-01],
	[4.7815000000E+04, 4.5006170876E+01, 4.9681350133E+00, 2.9165630600E+01, 3.8791432423E+00, 9.8396774891E-01],
	[4.7820000000E+04, 4.5014570049E+01, 4.9681809356E+00, 2.9175633695E+01, 3.8794105371E+00, 9.8397429786E-01],
	[4.7825000000E+04, 4.5022969911E+01, 4.9682268535E+00, 2.9185639174E+01, 3.8796777683E+00, 9.8398084375E-01],
	[4.7830000000E+04, 4.5031370463E+01, 4.9682727670E+00, 2.9195647036E+01, 3.8799449359E+00, 9.8398738659E-01],
	[4.7835000000E+04, 4.5039771703E+01, 4.9683186762E+00, 2.9205657283E+01, 3.8802120397E+00, 9.8399392637E-01],
	[4.7840000000E+04, 4.5048173632E+01, 4.9683645810E+00, 2.9215669914E+01, 3.8804790800E+00, 9.8400046311E-01],
	[4.7845000000E+04, 4.5056576251E+01, 4.9684104814E+00, 2.9225684929E+01, 3.8807460566E+00, 9.8400699679E-01],
	[4.7850000000E+04, 4.5064979558E+01, 4.9684563774E+00, 2.9235702330E+01, 3.8810129696E+00, 9.8401352743E-01],
	[4.7855000000E+04, 4.5073383554E+01, 4.9685022691E+00, 2.9245722117E+01, 3.8812798190E+00, 9.8402005502E-01],
	[4.7860000000E+04, 4.5081788240E+01, 4.9685481564E+00, 2.9255744289E+01, 3.8815466049E+00, 9.8402657956E-01],
	[4.7865000000E+04, 4.5090193614E+01, 4.9685940393E+00, 2.9265768847E+01, 3.8818133272E+00, 9.8403310107E-01],
	[4.7870000000E+04, 4.5098599677E+01, 4.9686399179E+00, 2.9275795792E+01, 3.8820799860E+00, 9.8403961953E-01],
	[4.7875000000E+04, 4.5107006429E+01, 4.9686857921E+00, 2.9285825123E+01, 3.8823465813E+00, 9.8404613495E-01],
	[4.7880000000E+04, 4.5115413870E+01, 4.9687316619E+00, 2.9295856842E+01, 3.8826131131E+00, 9.8405264733E-01],
	[4.7885000000E+04, 4.5123822000E+01, 4.9687775274E+00, 2.9305890948E+01, 3.8828795815E+00, 9.8405915667E-01],
	[4.7890000000E+04, 4.5132230819E+01, 4.9688233884E+00, 2.9315927441E+01, 3.8831459863E+00, 9.8406566298E-01],
	[4.7895000000E+04, 4.5140640327E+01, 4.9688692452E+00, 2.9325966322E+01, 3.8834123277E+00, 9.8407216626E-01],
	[4.7900000000E+04, 4.5149050523E+01, 4.9689150975E+00, 2.9336007592E+01, 3.8836786057E+00, 9.8407866650E-01],
	[4.7905000000E+04, 4.5157461408E+01, 4.9689609455E+00, 2.9346051250E+01, 3.8839448203E+00, 9.8408516371E-01],
	[4.7910000000E+04, 4.5165872982E+01, 4.9690067892E+00, 2.9356097298E+01, 3.8842109716E+00, 9.8409165790E-01],
	[4.7915000000E+04, 4.5174285245E+01, 4.9690526285E+00, 2.9366145734E+01, 3.8844770594E+00, 9.8409814905E-01],
	[4.7920000000E+04, 4.5182698197E+01, 4.9690984634E+00, 2.9376196560E+01, 3.8847430839E+00, 9.8410463718E-01],
	[4.7925000000E+04, 4.5191111837E+01, 4.9691442939E+00, 2.9386249776E+01, 3.8850090450E+00, 9.8411112229E-01],
	[4.7930000000E+04, 4.5199526167E+01, 4.9691901201E+00, 2.9396305382E+01, 3.8852749429E+00, 9.8411760438E-01],
	[4.7935000000E+04, 4.5207941184E+01, 4.9692359420E+00, 2.9406363379E+01, 3.8855407774E+00, 9.8412408344E-01],
	[4.7940000000E+04, 4.5216356891E+01, 4.9692817595E+00, 2.9416423767E+01, 3.8858065487E+00, 9.8413055948E-01],
	[4.7945000000E+04, 4.5224773286E+01, 4.9693275726E+00, 2.9426486546E+01, 3.8860722567E+00, 9.8413703251E-01],
	[4.7950000000E+04, 4.5233190370E+01, 4.9693733814E+00, 2.9436551716E+01, 3.8863379014E+00, 9.8414350251E-01],
	[4.7955000000E+04, 4.5241608143E+01, 4.9694191858E+00, 2.9446619278E+01, 3.8866034830E+00, 9.8414996951E-01],
	[4.7960000000E+04, 4.5250026604E+01, 4.9694649859E+00, 2.9456689232E+01, 3.8868690013E+00, 9.8415643349E-01],
	[4.7965000000E+04, 4.5258445754E+01, 4.9695107816E+00, 2.9466761579E+01, 3.8871344564E+00, 9.8416289446E-01],
	[4.7970000000E+04, 4.5266865593E+01, 4.9695565729E+00, 2.9476836318E+01, 3.8873998483E+00, 9.8416935242E-01],
	[4.7975000000E+04, 4.5275286120E+01, 4.9696023599E+00, 2.9486913450E+01, 3.8876651771E+00, 9.8417580737E-01],
	[4.7980000000E+04, 4.5283707336E+01, 4.9696481426E+00, 2.9496992976E+01, 3.8879304427E+00, 9.8418225931E-01],
	[4.7985000000E+04, 4.5292129240E+01, 4.9696939209E+00, 2.9507074896E+01, 3.8881956452E+00, 9.8418870825E-01],
	[4.7990000000E+04, 4.5300551833E+01, 4.9697396949E+00, 2.9517159210E+01, 3.8884607847E+00, 9.8419515419E-01],
	[4.7995000000E+04, 4.5308975114E+01, 4.9697854645E+00, 2.9527245918E+01, 3.8887258610E+00, 9.8420159712E-01],
	[4.8000000000E+04, 4.5317399084E+01, 4.9698312298E+00, 2.9537335020E+01, 3.8889908742E+00, 9.8420803705E-01],
	[4.8005000000E+04, 4.5325823742E+01, 4.9698769907E+00, 2.9547426518E+01, 3.8892558244E+00, 9.8421447398E-01],
	[4.8010000000E+04, 4.5334249089E+01, 4.9699227473E+00, 2.9557520411E+01, 3.8895207116E+00, 9.8422090792E-01],
	[4.8015000000E+04, 4.5342675125E+01, 4.9699684995E+00, 2.9567616699E+01, 3.8897855357E+00, 9.8422733886E-01],
	[4.8020000000E+04, 4.5351101849E+01, 4.9700142474E+00, 2.9577715384E+01, 3.8900502969E+00, 9.8423376681E-01],
	[4.8025000000E+04, 4.5359529261E+01, 4.9700599909E+00, 2.9587816465E+01, 3.8903149950E+00, 9.8424019176E-01],
	[4.8030000000E+04, 4.5367957362E+01, 4.9701057302E+00, 2.9597919942E+01, 3.8905796302E+00, 9.8424661372E-01],
	[4.8035000000E+04, 4.5376386151E+01, 4.9701514650E+00, 2.9608025817E+01, 3.8908442025E+00, 9.8425303269E-01],
	[4.8040000000E+04, 4.5384815629E+01, 4.9701971956E+00, 2.9618134088E+01, 3.8911087118E+00, 9.8425944868E-01],
	[4.8045000000E+04, 4.5393245795E+01, 4.9702429217E+00, 2.9628244757E+01, 3.8913731582E+00, 9.8426586167E-01],
	[4.8050000000E+04, 4.5401676649E+01, 4.9702886436E+00, 2.9638357824E+01, 3.8916375417E+00, 9.8427227169E-01],
	[4.8055000000E+04, 4.5410108192E+01, 4.9703343611E+00, 2.9648473289E+01, 3.8919018623E+00, 9.8427867872E-01],
	[4.8060000000E+04, 4.5418540423E+01, 4.9703800743E+00, 2.9658591153E+01, 3.8921661201E+00, 9.8428508276E-01],
	[4.8065000000E+04, 4.5426973342E+01, 4.9704257831E+00, 2.9668711415E+01, 3.8924303150E+00, 9.8429148383E-01],
	[4.8070000000E+04, 4.5435406950E+01, 4.9704714877E+00, 2.9678834077E+01, 3.8926944471E+00, 9.8429788192E-01],
	[4.8075000000E+04, 4.5443841246E+01, 4.9705171878E+00, 2.9688959138E+01, 3.8929585164E+00, 9.8430427703E-01],
	[4.8080000000E+04, 4.5452276230E+01, 4.9705628837E+00, 2.9699086599E+01, 3.8932225229E+00, 9.8431066917E-01],
	[4.8085000000E+04, 4.5460711903E+01, 4.9706085752E+00, 2.9709216460E+01, 3.8934864666E+00, 9.8431705833E-01],
	[4.8090000000E+04, 4.5469148263E+01, 4.9706542624E+00, 2.9719348721E+01, 3.8937503476E+00, 9.8432344452E-01],
	[4.8095000000E+04, 4.5477585313E+01, 4.9706999452E+00, 2.9729483383E+01, 3.8940141658E+00, 9.8432982774E-01],
	[4.8100000000E+04, 4.5486023050E+01, 4.9707456237E+00, 2.9739620446E+01, 3.8942779213E+00, 9.8433620799E-01],
	[4.8105000000E+04, 4.5494461475E+01, 4.9707912979E+00, 2.9749759910E+01, 3.8945416141E+00, 9.8434258527E-01],
	[4.8110000000E+04, 4.5502900589E+01, 4.9708369678E+00, 2.9759901777E+01, 3.8948052442E+00, 9.8434895959E-01],
	[4.8115000000E+04, 4.5511340391E+01, 4.9708826333E+00, 2.9770046045E+01, 3.8950688117E+00, 9.8435533094E-01],
	[4.8120000000E+04, 4.5519780881E+01, 4.9709282946E+00, 2.9780192715E+01, 3.8953323165E+00, 9.8436169933E-01],
	[4.8125000000E+04, 4.5528222059E+01, 4.9709739515E+00, 2.9790341788E+01, 3.8955957586E+00, 9.8436806476E-01],
	[4.8130000000E+04, 4.5536663925E+01, 4.9710196040E+00, 2.9800493264E+01, 3.8958591382E+00, 9.8437442722E-01],
	[4.8135000000E+04, 4.5545106479E+01, 4.9710652523E+00, 2.9810647144E+01, 3.8961224551E+00, 9.8438078673E-01],
	[4.8140000000E+04, 4.5553549722E+01, 4.9711108962E+00, 2.9820803427E+01, 3.8963857095E+00, 9.8438714329E-01],
	[4.8145000000E+04, 4.5561993652E+01, 4.9711565358E+00, 2.9830962114E+01, 3.8966489013E+00, 9.8439349688E-01],
	[4.8150000000E+04, 4.5570438271E+01, 4.9712021711E+00, 2.9841123205E+01, 3.8969120306E+00, 9.8439984753E-01],
	[4.8155000000E+04, 4.5578883577E+01, 4.9712478020E+00, 2.9851286700E+01, 3.8971750973E+00, 9.8440619522E-01],
	[4.8160000000E+04, 4.5587329572E+01, 4.9712934287E+00, 2.9861452601E+01, 3.8974381015E+00, 9.8441253996E-01],
	[4.8165000000E+04, 4.5595776255E+01, 4.9713390510E+00, 2.9871620907E+01, 3.8977010432E+00, 9.8441888175E-01],
	[4.8170000000E+04, 4.5604223625E+01, 4.9713846690E+00, 2.9881791618E+01, 3.8979639225E+00, 9.8442522060E-01],
	[4.8175000000E+04, 4.5612671684E+01, 4.9714302827E+00, 2.9891964735E+01, 3.8982267393E+00, 9.8443155650E-01],
	[4.8180000000E+04, 4.5621120431E+01, 4.9714758920E+00, 2.9902140258E+01, 3.8984894936E+00, 9.8443788945E-01],
	[4.8185000000E+04, 4.5629569865E+01, 4.9715214971E+00, 2.9912318188E+01, 3.8987521855E+00, 9.8444421946E-01],
	[4.8190000000E+04, 4.5638019988E+01, 4.9715670978E+00, 2.9922498525E+01, 3.8990148150E+00, 9.8445054653E-01],
	[4.8195000000E+04, 4.5646470798E+01, 4.9716126943E+00, 2.9932681268E+01, 3.8992773822E+00, 9.8445687066E-01],
	[4.8200000000E+04, 4.5654922297E+01, 4.9716582864E+00, 2.9942866419E+01, 3.8995398869E+00, 9.8446319186E-01],
	[4.8205000000E+04, 4.5663374483E+01, 4.9717038742E+00, 2.9953053978E+01, 3.8998023293E+00, 9.8446951011E-01],
	[4.8210000000E+04, 4.5671827357E+01, 4.9717494577E+00, 2.9963243945E+01, 3.9000647094E+00, 9.8447582544E-01],
	[4.8215000000E+04, 4.5680280919E+01, 4.9717950369E+00, 2.9973436320E+01, 3.9003270271E+00, 9.8448213782E-01],
	[4.8220000000E+04, 4.5688735169E+01, 4.9718406118E+00, 2.9983631104E+01, 3.9005892825E+00, 9.8448844728E-01],
	[4.8225000000E+04, 4.5697190107E+01, 4.9718861823E+00, 2.9993828297E+01, 3.9008514757E+00, 9.8449475381E-01],
	[4.8230000000E+04, 4.5705645732E+01, 4.9719317486E+00, 3.0004027900E+01, 3.9011136066E+00, 9.8450105740E-01],
	[4.8235000000E+04, 4.5714102046E+01, 4.9719773106E+00, 3.0014229912E+01, 3.9013756752E+00, 9.8450735807E-01],
	[4.8240000000E+04, 4.5722559047E+01, 4.9720228682E+00, 3.0024434333E+01, 3.9016376816E+00, 9.8451365582E-01],
	[4.8245000000E+04, 4.5731016736E+01, 4.9720684216E+00, 3.0034641166E+01, 3.9018996258E+00, 9.8451995064E-01],
	[4.8250000000E+04, 4.5739475112E+01, 4.9721139706E+00, 3.0044850409E+01, 3.9021615077E+00, 9.8452624253E-01],
	[4.8255000000E+04, 4.5747934177E+01, 4.9721595153E+00, 3.0055062062E+01, 3.9024233275E+00, 9.8453253151E-01],
	[4.8260000000E+04, 4.5756393929E+01, 4.9722050558E+00, 3.0065276128E+01, 3.9026850852E+00, 9.8453881757E-01],
	[4.8265000000E+04, 4.5764854369E+01, 4.9722505919E+00, 3.0075492604E+01, 3.9029467807E+00, 9.8454510071E-01],
	[4.8270000000E+04, 4.5773315496E+01, 4.9722961238E+00, 3.0085711493E+01, 3.9032084140E+00, 9.8455138093E-01],
	[4.8275000000E+04, 4.5781777311E+01, 4.9723416513E+00, 3.0095932794E+01, 3.9034699853E+00, 9.8455765823E-01],
	[4.8280000000E+04, 4.5790239814E+01, 4.9723871745E+00, 3.0106156507E+01, 3.9037314944E+00, 9.8456393263E-01],
	[4.8285000000E+04, 4.5798703005E+01, 4.9724326935E+00, 3.0116382633E+01, 3.9039929415E+00, 9.8457020411E-01],
	[4.8290000000E+04, 4.5807166883E+01, 4.9724782081E+00, 3.0126611172E+01, 3.9042543265E+00, 9.8457647268E-01],
	[4.8295000000E+04, 4.5815646544E+01, 4.9725252271E+00, 3.0136842125E+01, 3.9045166893E+00, 9.8458273835E-01],
	[4.8300000000E+04, 4.5824127569E+01, 4.9725723088E+00, 3.0147075492E+01, 3.9047790365E+00, 9.8458900110E-01],
	[4.8305000000E+04, 4.5832609286E+01, 4.9726193862E+00, 3.0157311273E+01, 3.9050413218E+00, 9.8459526095E-01],
	[4.8310000000E+04, 4.5841091695E+01, 4.9726664591E+00, 3.0167549468E+01, 3.9053035452E+00, 9.8460151790E-01],
	[4.8315000000E+04, 4.5849574796E+01, 4.9727135276E+00, 3.0177790078E+01, 3.9055657068E+00, 9.8460777194E-01],
	[4.8320000000E+04, 4.5858058589E+01, 4.9727605916E+00, 3.0188033103E+01, 3.9058278065E+00, 9.8461402309E-01],
	[4.8325000000E+04, 4.5866543073E+01, 4.9728076513E+00, 3.0198278543E+01, 3.9060898444E+00, 9.8462027133E-01],
	[4.8330000000E+04, 4.5875028249E+01, 4.9728547065E+00, 3.0208526400E+01, 3.9063518206E+00, 9.8462651667E-01],
	[4.8335000000E+04, 4.5883514116E+01, 4.9729017573E+00, 3.0218776672E+01, 3.9066137349E+00, 9.8463275912E-01],
	[4.8340000000E+04, 4.5892000676E+01, 4.9729488036E+00, 3.0229029360E+01, 3.9068755874E+00, 9.8463899868E-01],
	[4.8345000000E+04, 4.5900487927E+01, 4.9729958456E+00, 3.0239284466E+01, 3.9071373782E+00, 9.8464523534E-01],
	[4.8350000000E+04, 4.5908975869E+01, 4.9730428831E+00, 3.0249541988E+01, 3.9073991073E+00, 9.8465146911E-01],
	[4.8355000000E+04, 4.5917464504E+01, 4.9730899162E+00, 3.0259801928E+01, 3.9076607747E+00, 9.8465769999E-01],
	[4.8360000000E+04, 4.5925953830E+01, 4.9731369449E+00, 3.0270064285E+01, 3.9079223803E+00, 9.8466392798E-01],
	[4.8365000000E+04, 4.5934443847E+01, 4.9731839692E+00, 3.0280329060E+01, 3.9081839243E+00, 9.8467015308E-01],
	[4.8370000000E+04, 4.5942934556E+01, 4.9732309891E+00, 3.0290596254E+01, 3.9084454066E+00, 9.8467637529E-01],
	[4.8375000000E+04, 4.5951425957E+01, 4.9732780045E+00, 3.0300865866E+01, 3.9087068273E+00, 9.8468259463E-01],
	[4.8380000000E+04, 4.5959918049E+01, 4.9733250155E+00, 3.0311137897E+01, 3.9089681863E+00, 9.8468881108E-01],
	[4.8385000000E+04, 4.5968410833E+01, 4.9733720221E+00, 3.0321412347E+01, 3.9092294837E+00, 9.8469502465E-01],
	[4.8390000000E+04, 4.5976904308E+01, 4.9734190243E+00, 3.0331689217E+01, 3.9094907195E+00, 9.8470123534E-01],
	[4.8395000000E+04, 4.5985398475E+01, 4.9734660221E+00, 3.0341968507E+01, 3.9097518937E+00, 9.8470744315E-01],
	[4.8400000000E+04, 4.5993893333E+01, 4.9735130155E+00, 3.0352250217E+01, 3.9100130064E+00, 9.8471364808E-01],
	[4.8405000000E+04, 4.6002388883E+01, 4.9735600045E+00, 3.0362534347E+01, 3.9102740575E+00, 9.8471985014E-01],
	[4.8410000000E+04, 4.6010885125E+01, 4.9736069890E+00, 3.0372820898E+01, 3.9105350471E+00, 9.8472604933E-01],
	[4.8415000000E+04, 4.6019382057E+01, 4.9736539692E+00, 3.0383109871E+01, 3.9107959752E+00, 9.8473224564E-01],
	[4.8420000000E+04, 4.6027879681E+01, 4.9737009449E+00, 3.0393401265E+01, 3.9110568418E+00, 9.8473843909E-01],
	[4.8425000000E+04, 4.6036377997E+01, 4.9737479162E+00, 3.0403695080E+01, 3.9113176469E+00, 9.8474462966E-01],
	[4.8430000000E+04, 4.6044877004E+01, 4.9737948832E+00, 3.0413991318E+01, 3.9115783905E+00, 9.8475081737E-01],
	[4.8435000000E+04, 4.6053376703E+01, 4.9738418457E+00, 3.0424289978E+01, 3.9118390727E+00, 9.8475700221E-01],
	[4.8440000000E+04, 4.6061877092E+01, 4.9738888038E+00, 3.0434591061E+01, 3.9120996935E+00, 9.8476318419E-01],
	[4.8445000000E+04, 4.6070378173E+01, 4.9739357575E+00, 3.0444894567E+01, 3.9123602529E+00, 9.8476936330E-01],
	[4.8450000000E+04, 4.6078879946E+01, 4.9739827068E+00, 3.0455200497E+01, 3.9126207509E+00, 9.8477553956E-01],
	[4.8455000000E+04, 4.6087382410E+01, 4.9740296517E+00, 3.0465508850E+01, 3.9128811875E+00, 9.8478171295E-01],
	[4.8460000000E+04, 4.6095885565E+01, 4.9740765922E+00, 3.0475819627E+01, 3.9131415627E+00, 9.8478788348E-01],
	[4.8465000000E+04, 4.6104389411E+01, 4.9741235283E+00, 3.0486132829E+01, 3.9134018766E+00, 9.8479405116E-01],
	[4.8470000000E+04, 4.6112893949E+01, 4.9741704600E+00, 3.0496448455E+01, 3.9136621292E+00, 9.8480021599E-01],
	[4.8475000000E+04, 4.6121399178E+01, 4.9742173874E+00, 3.0506766506E+01, 3.9139223205E+00, 9.8480637796E-01],
	[4.8480000000E+04, 4.6129905098E+01, 4.9742643103E+00, 3.0517086983E+01, 3.9141824505E+00, 9.8481253707E-01],
	[4.8485000000E+04, 4.6138411710E+01, 4.9743112288E+00, 3.0527409885E+01, 3.9144425192E+00, 9.8481869334E-01],
	[4.8490000000E+04, 4.6146919013E+01, 4.9743581429E+00, 3.0537735213E+01, 3.9147025266E+00, 9.8482484676E-01],
	[4.8495000000E+04, 4.6155427007E+01, 4.9744050526E+00, 3.0548062967E+01, 3.9149624729E+00, 9.8483099733E-01],
	[4.8500000000E+04, 4.6163935692E+01, 4.9744519580E+00, 3.0558393148E+01, 3.9152223579E+00, 9.8483714505E-01],
	[4.8505000000E+04, 4.6172445068E+01, 4.9744988589E+00, 3.0568725756E+01, 3.9154821817E+00, 9.8484328993E-01],
	[4.8510000000E+04, 4.6180955136E+01, 4.9745457554E+00, 3.0579060791E+01, 3.9157419443E+00, 9.8484943197E-01],
	[4.8515000000E+04, 4.6189465894E+01, 4.9745926476E+00, 3.0589398253E+01, 3.9160016457E+00, 9.8485557116E-01],
	[4.8520000000E+04, 4.6197977344E+01, 4.9746395354E+00, 3.0599738144E+01, 3.9162612860E+00, 9.8486170752E-01],
	[4.8525000000E+04, 4.6206489485E+01, 4.9746864187E+00, 3.0610080463E+01, 3.9165208651E+00, 9.8486784103E-01],
	[4.8530000000E+04, 4.6215002317E+01, 4.9747332977E+00, 3.0620425210E+01, 3.9167803832E+00, 9.8487397171E-01],
	[4.8535000000E+04, 4.6223515840E+01, 4.9747801723E+00, 3.0630772386E+01, 3.9170398401E+00, 9.8488009956E-01],
	[4.8540000000E+04, 4.6232030054E+01, 4.9748270425E+00, 3.0641121991E+01, 3.9172992360E+00, 9.8488622457E-01],
	[4.8545000000E+04, 4.6240544960E+01, 4.9748739083E+00, 3.0651474025E+01, 3.9175585707E+00, 9.8489234674E-01],
	[4.8550000000E+04, 4.6249060556E+01, 4.9749207698E+00, 3.0661828490E+01, 3.9178178445E+00, 9.8489846609E-01],
	[4.8555000000E+04, 4.6257576843E+01, 4.9749676268E+00, 3.0672185384E+01, 3.9180770572E+00, 9.8490458261E-01],
	[4.8560000000E+04, 4.6266093822E+01, 4.9750144795E+00, 3.0682544709E+01, 3.9183362088E+00, 9.8491069630E-01],
	[4.8565000000E+04, 4.6274611491E+01, 4.9750613278E+00, 3.0692906465E+01, 3.9185952995E+00, 9.8491680716E-01],
	[4.8570000000E+04, 4.6283129851E+01, 4.9751081717E+00, 3.0703270652E+01, 3.9188543292E+00, 9.8492291519E-01],
	[4.8575000000E+04, 4.6291648903E+01, 4.9751550112E+00, 3.0713637270E+01, 3.9191132980E+00, 9.8492902041E-01],
	[4.8580000000E+04, 4.6300168645E+01, 4.9752018464E+00, 3.0724006319E+01, 3.9193722057E+00, 9.8493512280E-01],
	[4.8585000000E+04, 4.6308689078E+01, 4.9752486771E+00, 3.0734377801E+01, 3.9196310526E+00, 9.8494122237E-01],
	[4.8590000000E+04, 4.6317210202E+01, 4.9752955035E+00, 3.0744751715E+01, 3.9198898385E+00, 9.8494731911E-01],
	[4.8595000000E+04, 4.6325732017E+01, 4.9753423255E+00, 3.0755128062E+01, 3.9201485636E+00, 9.8495341304E-01],
	[4.8600000000E+04, 4.6334254523E+01, 4.9753891432E+00, 3.0765506842E+01, 3.9204072277E+00, 9.8495950416E-01],
	[4.8605000000E+04, 4.6342777720E+01, 4.9754359564E+00, 3.0775888055E+01, 3.9206658310E+00, 9.8496559245E-01],
	[4.8610000000E+04, 4.6351301608E+01, 4.9754827653E+00, 3.0786271702E+01, 3.9209243735E+00, 9.8497167794E-01],
	[4.8615000000E+04, 4.6359826186E+01, 4.9755295698E+00, 3.0796657782E+01, 3.9211828551E+00, 9.8497776061E-01],
	[4.8620000000E+04, 4.6368351455E+01, 4.9755763699E+00, 3.0807046297E+01, 3.9214412759E+00, 9.8498384047E-01],
	[4.8625000000E+04, 4.6376877416E+01, 4.9756231657E+00, 3.0817437247E+01, 3.9216996360E+00, 9.8498991751E-01],
	[4.8630000000E+04, 4.6385404067E+01, 4.9756699571E+00, 3.0827830631E+01, 3.9219579352E+00, 9.8499599175E-01],
	[4.8635000000E+04, 4.6393931408E+01, 4.9757167441E+00, 3.0838226451E+01, 3.9222161737E+00, 9.8500206319E-01],
	[4.8640000000E+04, 4.6402459441E+01, 4.9757635268E+00, 3.0848624706E+01, 3.9224743514E+00, 9.8500813181E-01],
	[4.8645000000E+04, 4.6410988164E+01, 4.9758103050E+00, 3.0859025397E+01, 3.9227324684E+00, 9.8501419763E-01],
	[4.8650000000E+04, 4.6419517578E+01, 4.9758570790E+00, 3.0869428524E+01, 3.9229905247E+00, 9.8502026065E-01],
	[4.8655000000E+04, 4.6428047683E+01, 4.9759038485E+00, 3.0879834088E+01, 3.9232485203E+00, 9.8502632087E-01],
	[4.8660000000E+04, 4.6436578479E+01, 4.9759506137E+00, 3.0890242088E+01, 3.9235064552E+00, 9.8503237828E-01],
	[4.8665000000E+04, 4.6445109965E+01, 4.9759973745E+00, 3.0900652526E+01, 3.9237643295E+00, 9.8503843290E-01],
	[4.8670000000E+04, 4.6453642142E+01, 4.9760441309E+00, 3.0911065401E+01, 3.9240221431E+00, 9.8504448471E-01],
	[4.8675000000E+04, 4.6462175009E+01, 4.9760908830E+00, 3.0921480714E+01, 3.9242798961E+00, 9.8505053374E-01],
	[4.8680000000E+04, 4.6470708567E+01, 4.9761376307E+00, 3.0931898465E+01, 3.9245375885E+00, 9.8505657996E-01],
	[4.8685000000E+04, 4.6479242816E+01, 4.9761843741E+00, 3.0942318654E+01, 3.9247952203E+00, 9.8506262340E-01],
	[4.8690000000E+04, 4.6487777756E+01, 4.9762311131E+00, 3.0952741282E+01, 3.9250527916E+00, 9.8506866404E-01],
	[4.8695000000E+04, 4.6496313386E+01, 4.9762778477E+00, 3.0963166349E+01, 3.9253103022E+00, 9.8507470189E-01],
	[4.8700000000E+04, 4.6504849706E+01, 4.9763245780E+00, 3.0973593856E+01, 3.9255677524E+00, 9.8508073695E-01],
	[4.8705000000E+04, 4.6513386718E+01, 4.9763713039E+00, 3.0984023802E+01, 3.9258251420E+00, 9.8508676922E-01],
	[4.8710000000E+04, 4.6521924420E+01, 4.9764180255E+00, 3.0994456188E+01, 3.9260824711E+00, 9.8509279870E-01],
	[4.8715000000E+04, 4.6530462812E+01, 4.9764647427E+00, 3.1004891015E+01, 3.9263397397E+00, 9.8509882540E-01],
	[4.8720000000E+04, 4.6539001895E+01, 4.9765114555E+00, 3.1015328282E+01, 3.9265969478E+00, 9.8510484932E-01],
	[4.8725000000E+04, 4.6547541668E+01, 4.9765581640E+00, 3.1025767990E+01, 3.9268540955E+00, 9.8511087045E-01],
	[4.8730000000E+04, 4.6556082132E+01, 4.9766048682E+00, 3.1036210140E+01, 3.9271111827E+00, 9.8511688880E-01],
	[4.8735000000E+04, 4.6564623287E+01, 4.9766515680E+00, 3.1046654731E+01, 3.9273682096E+00, 9.8512290437E-01],
	[4.8740000000E+04, 4.6573165131E+01, 4.9766982634E+00, 3.1057101764E+01, 3.9276251760E+00, 9.8512891716E-01],
	[4.8745000000E+04, 4.6581707667E+01, 4.9767449545E+00, 3.1067551239E+01, 3.9278820820E+00, 9.8513492718E-01],
	[4.8750000000E+04, 4.6590250893E+01, 4.9767916412E+00, 3.1078003157E+01, 3.9281389277E+00, 9.8514093442E-01],
	[4.8755000000E+04, 4.6598794809E+01, 4.9768383236E+00, 3.1088457518E+01, 3.9283957130E+00, 9.8514693888E-01],
	[4.8760000000E+04, 4.6607339415E+01, 4.9768850016E+00, 3.1098914322E+01, 3.9286524379E+00, 9.8515294058E-01],
	[4.8765000000E+04, 4.6615884713E+01, 4.9769316753E+00, 3.1109373570E+01, 3.9289091026E+00, 9.8515893950E-01],
	[4.8770000000E+04, 4.6624430700E+01, 4.9769783446E+00, 3.1119835261E+01, 3.9291657069E+00, 9.8516493565E-01],
	[4.8775000000E+04, 4.6632977378E+01, 4.9770250096E+00, 3.1130299397E+01, 3.9294222509E+00, 9.8517092903E-01],
	[4.8780000000E+04, 4.6641524746E+01, 4.9770716702E+00, 3.1140765977E+01, 3.9296787347E+00, 9.8517691964E-01],
	[4.8785000000E+04, 4.6650072804E+01, 4.9771183265E+00, 3.1151235002E+01, 3.9299351582E+00, 9.8518290749E-01],
	[4.8790000000E+04, 4.6658621553E+01, 4.9771649785E+00, 3.1161706472E+01, 3.9301915215E+00, 9.8518889257E-01],
	[4.8795000000E+04, 4.6667170992E+01, 4.9772116261E+00, 3.1172180387E+01, 3.9304478246E+00, 9.8519487489E-01],
	[4.8800000000E+04, 4.6675721122E+01, 4.9772582693E+00, 3.1182656748E+01, 3.9307040675E+00, 9.8520085444E-01],
	[4.8805000000E+04, 4.6684271941E+01, 4.9773049083E+00, 3.1193135556E+01, 3.9309602502E+00, 9.8520683124E-01],
	[4.8810000000E+04, 4.6692823451E+01, 4.9773515428E+00, 3.1203616810E+01, 3.9312163727E+00, 9.8521280527E-01],
	[4.8815000000E+04, 4.6701375651E+01, 4.9773981731E+00, 3.1214100510E+01, 3.9314724350E+00, 9.8521877655E-01],
	[4.8820000000E+04, 4.6709928542E+01, 4.9774447990E+00, 3.1224586658E+01, 3.9317284373E+00, 9.8522474507E-01],
	[4.8825000000E+04, 4.6718482123E+01, 4.9774914206E+00, 3.1235075253E+01, 3.9319843794E+00, 9.8523071084E-01],
	[4.8830000000E+04, 4.6727036393E+01, 4.9775380378E+00, 3.1245566295E+01, 3.9322402614E+00, 9.8523667385E-01],
	[4.8835000000E+04, 4.6735591354E+01, 4.9775846507E+00, 3.1256059786E+01, 3.9324960833E+00, 9.8524263411E-01],
	[4.8840000000E+04, 4.6744147006E+01, 4.9776312592E+00, 3.1266555725E+01, 3.9327518451E+00, 9.8524859162E-01],
	[4.8845000000E+04, 4.6752703347E+01, 4.9776778634E+00, 3.1277054113E+01, 3.9330075469E+00, 9.8525454638E-01],
	[4.8850000000E+04, 4.6761260379E+01, 4.9777244633E+00, 3.1287554949E+01, 3.9332631887E+00, 9.8526049839E-01],
	[4.8855000000E+04, 4.6769818100E+01, 4.9777710589E+00, 3.1298058235E+01, 3.9335187705E+00, 9.8526644765E-01],
	[4.8860000000E+04, 4.6778376512E+01, 4.9778176501E+00, 3.1308563971E+01, 3.9337742922E+00, 9.8527239417E-01],
	[4.8865000000E+04, 4.6786935614E+01, 4.9778642370E+00, 3.1319072156E+01, 3.9340297540E+00, 9.8527833794E-01],
	[4.8870000000E+04, 4.6795495406E+01, 4.9779108195E+00, 3.1329582792E+01, 3.9342851558E+00, 9.8528427897E-01],
	[4.8875000000E+04, 4.6804055888E+01, 4.9779573978E+00, 3.1340095879E+01, 3.9345404976E+00, 9.8529021726E-01],
	[4.8880000000E+04, 4.6812617060E+01, 4.9780039717E+00, 3.1350611416E+01, 3.9347957795E+00, 9.8529615280E-01],
	[4.8885000000E+04, 4.6821178922E+01, 4.9780505412E+00, 3.1361129404E+01, 3.9350510015E+00, 9.8530208561E-01],
	[4.8890000000E+04, 4.6829741474E+01, 4.9780971065E+00, 3.1371649844E+01, 3.9353061636E+00, 9.8530801568E-01],
	[4.8895000000E+04, 4.6838304716E+01, 4.9781436674E+00, 3.1382172736E+01, 3.9355612659E+00, 9.8531394302E-01],
	[4.8900000000E+04, 4.6846868648E+01, 4.9781902240E+00, 3.1392698080E+01, 3.9358163082E+00, 9.8531986762E-01],
	[4.8905000000E+04, 4.6855433271E+01, 4.9782367762E+00, 3.1403225877E+01, 3.9360712907E+00, 9.8532578948E-01],
	[4.8910000000E+04, 4.6863998583E+01, 4.9782833242E+00, 3.1413756126E+01, 3.9363262134E+00, 9.8533170861E-01],
	[4.8915000000E+04, 4.6872564585E+01, 4.9783298678E+00, 3.1424288829E+01, 3.9365810762E+00, 9.8533762502E-01],
	[4.8920000000E+04, 4.6881131277E+01, 4.9783764071E+00, 3.1434823985E+01, 3.9368358793E+00, 9.8534353869E-01],
	[4.8925000000E+04, 4.6889698658E+01, 4.9784229421E+00, 3.1445361594E+01, 3.9370906225E+00, 9.8534944964E-01],
	[4.8930000000E+04, 4.6898266730E+01, 4.9784694727E+00, 3.1455901658E+01, 3.9373453060E+00, 9.8535535786E-01],
	[4.8935000000E+04, 4.6906835492E+01, 4.9785159991E+00, 3.1466444176E+01, 3.9375999298E+00, 9.8536126335E-01],
	[4.8940000000E+04, 4.6915404944E+01, 4.9785625211E+00, 3.1476989150E+01, 3.9378544938E+00, 9.8536716612E-01],
	[4.8945000000E+04, 4.6923975085E+01, 4.9786090388E+00, 3.1487536578E+01, 3.9381089981E+00, 9.8537306616E-01],
	[4.8950000000E+04, 4.6932545916E+01, 4.9786555522E+00, 3.1498086461E+01, 3.9383634427E+00, 9.8537896349E-01],
	[4.8955000000E+04, 4.6941117437E+01, 4.9787020612E+00, 3.1508638800E+01, 3.9386178277E+00, 9.8538485810E-01],
	[4.8960000000E+04, 4.6949689648E+01, 4.9787485660E+00, 3.1519193595E+01, 3.9388721529E+00, 9.8539074998E-01],
	[4.8965000000E+04, 4.6958262549E+01, 4.9787950664E+00, 3.1529750847E+01, 3.9391264185E+00, 9.8539663915E-01],
	[4.8970000000E+04, 4.6966836139E+01, 4.9788415625E+00, 3.1540310555E+01, 3.9393806245E+00, 9.8540252561E-01],
	[4.8975000000E+04, 4.6975410420E+01, 4.9788880543E+00, 3.1550872720E+01, 3.9396347709E+00, 9.8540840935E-01],
	[4.8980000000E+04, 4.6983985390E+01, 4.9789345418E+00, 3.1561437343E+01, 3.9398888577E+00, 9.8541429037E-01],
	[4.8985000000E+04, 4.6992561049E+01, 4.9789810250E+00, 3.1572004423E+01, 3.9401428848E+00, 9.8542016869E-01],
	[4.8990000000E+04, 4.7001137399E+01, 4.9790275039E+00, 3.1582573961E+01, 3.9403968525E+00, 9.8542604429E-01],
	[4.8995000000E+04, 4.7009714438E+01, 4.9790739784E+00, 3.1593145958E+01, 3.9406507605E+00, 9.8543191718E-01],
	[4.9000000000E+04, 4.7018292167E+01, 4.9791204487E+00, 3.1603720413E+01, 3.9409046091E+00, 9.8543778737E-01],
	[4.9005000000E+04, 4.7026870585E+01, 4.9791669146E+00, 3.1614297326E+01, 3.9411583981E+00, 9.8544365485E-01],
	[4.9010000000E+04, 4.7035449694E+01, 4.9792133763E+00, 3.1624876699E+01, 3.9414121276E+00, 9.8544951963E-01],
	[4.9015000000E+04, 4.7044029492E+01, 4.9792598336E+00, 3.1635458532E+01, 3.9416657977E+00, 9.8545538170E-01],
	[4.9020000000E+04, 4.7052609979E+01, 4.9793062866E+00, 3.1646042825E+01, 3.9419194083E+00, 9.8546124107E-01],
	[4.9025000000E+04, 4.7061191156E+01, 4.9793527354E+00, 3.1656629577E+01, 3.9421729594E+00, 9.8546709774E-01],
	[4.9030000000E+04, 4.7069773023E+01, 4.9793991798E+00, 3.1667218791E+01, 3.9424264511E+00, 9.8547295171E-01],
	[4.9035000000E+04, 4.7078355579E+01, 4.9794456199E+00, 3.1677810465E+01, 3.9426798834E+00, 9.8547880298E-01],
	[4.9040000000E+04, 4.7086938825E+01, 4.9794920557E+00, 3.1688404600E+01, 3.9429332563E+00, 9.8548465155E-01],
	[4.9045000000E+04, 4.7095522761E+01, 4.9795384872E+00, 3.1699001196E+01, 3.9431865698E+00, 9.8549049743E-01],
	[4.9050000000E+04, 4.7104107386E+01, 4.9795849144E+00, 3.1709600255E+01, 3.9434398240E+00, 9.8549634061E-01],
	[4.9055000000E+04, 4.7112692700E+01, 4.9796313373E+00, 3.1720201776E+01, 3.9436930188E+00, 9.8550218111E-01],
	[4.9060000000E+04, 4.7121278704E+01, 4.9796777560E+00, 3.1730805759E+01, 3.9439461542E+00, 9.8550801890E-01],
	[4.9065000000E+04, 4.7129865398E+01, 4.9797241703E+00, 3.1741412204E+01, 3.9441992304E+00, 9.8551385401E-01],
	[4.9070000000E+04, 4.7138460277E+01, 4.9797713147E+00, 3.1752021113E+01, 3.9444527605E+00, 9.8551968644E-01],
	[4.9075000000E+04, 4.7147064102E+01, 4.9798192634E+00, 3.1762632485E+01, 3.9447067966E+00, 9.8552551617E-01],
	[4.9080000000E+04, 4.7155668620E+01, 4.9798672076E+00, 3.1773246321E+01, 3.9449607734E+00, 9.8553134322E-01],
	[4.9085000000E+04, 4.7164273832E+01, 4.9799151473E+00, 3.1783862621E+01, 3.9452146912E+00, 9.8553716758E-01],
	[4.9090000000E+04, 4.7172879737E+01, 4.9799630827E+00, 3.1794481386E+01, 3.9454685498E+00, 9.8554298926E-01],
	[4.9095000000E+04, 4.7181486336E+01, 4.9800110136E+00, 3.1805102615E+01, 3.9457223493E+00, 9.8554880825E-01],
	[4.9100000000E+04, 4.7190093629E+01, 4.9800589402E+00, 3.1815726309E+01, 3.9459760897E+00, 9.8555462457E-01],
	[4.9105000000E+04, 4.7198701615E+01, 4.9801068623E+00, 3.1826352468E+01, 3.9462297711E+00, 9.8556043821E-01],
	[4.9110000000E+04, 4.7207310294E+01, 4.9801547799E+00, 3.1836981093E+01, 3.9464833934E+00, 9.8556624917E-01],
	[4.9115000000E+04, 4.7215919667E+01, 4.9802026932E+00, 3.1847612184E+01, 3.9467369566E+00, 9.8557205745E-01],
	[4.9120000000E+04, 4.7224529734E+01, 4.9802506020E+00, 3.1858245741E+01, 3.9469904608E+00, 9.8557786305E-01],
	[4.9125000000E+04, 4.7233140494E+01, 4.9802985065E+00, 3.1868881765E+01, 3.9472439060E+00, 9.8558366599E-01],
	[4.9130000000E+04, 4.7241751947E+01, 4.9803464065E+00, 3.1879520256E+01, 3.9474972923E+00, 9.8558946625E-01],
	[4.9135000000E+04, 4.7250364094E+01, 4.9803943021E+00, 3.1890161214E+01, 3.9477506195E+00, 9.8559526384E-01],
	[4.9140000000E+04, 4.7258976934E+01, 4.9804421933E+00, 3.1900804640E+01, 3.9480038878E+00, 9.8560105875E-01],
	[4.9145000000E+04, 4.7267590468E+01, 4.9804900801E+00, 3.1911450533E+01, 3.9482570972E+00, 9.8560685100E-01],
	[4.9150000000E+04, 4.7276204695E+01, 4.9805379624E+00, 3.1922098895E+01, 3.9485102476E+00, 9.8561264059E-01],
	[4.9155000000E+04, 4.7284819616E+01, 4.9805858404E+00, 3.1932749725E+01, 3.9487633391E+00, 9.8561842750E-01],
	[4.9160000000E+04, 4.7293435229E+01, 4.9806337139E+00, 3.1943403024E+01, 3.9490163718E+00, 9.8562421176E-01],
	[4.9165000000E+04, 4.7302051537E+01, 4.9806815831E+00, 3.1954058792E+01, 3.9492693455E+00, 9.8562999335E-01],
	[4.9170000000E+04, 4.7310668537E+01, 4.9807294478E+00, 3.1964717030E+01, 3.9495222604E+00, 9.8563577227E-01],
	[4.9175000000E+04, 4.7319286231E+01, 4.9807773081E+00, 3.1975377737E+01, 3.9497751165E+00, 9.8564154854E-01],
	[4.9180000000E+04, 4.7327904618E+01, 4.9808251640E+00, 3.1986040915E+01, 3.9500279137E+00, 9.8564732215E-01],
	[4.9185000000E+04, 4.7336523698E+01, 4.9808730155E+00, 3.1996706563E+01, 3.9502806522E+00, 9.8565309310E-01],
	[4.9190000000E+04, 4.7345143472E+01, 4.9809208626E+00, 3.2007374682E+01, 3.9505333318E+00, 9.8565886139E-01],
	[4.9195000000E+04, 4.7353763939E+01, 4.9809687054E+00, 3.2018045272E+01, 3.9507859527E+00, 9.8566462703E-01],
	[4.9200000000E+04, 4.7362385099E+01, 4.9810165437E+00, 3.2028718333E+01, 3.9510385148E+00, 9.8567039001E-01],
	[4.9205000000E+04, 4.7371006952E+01, 4.9810643775E+00, 3.2039393867E+01, 3.9512910181E+00, 9.8567615034E-01],
	[4.9210000000E+04, 4.7379629499E+01, 4.9811122070E+00, 3.2050071872E+01, 3.9515434627E+00, 9.8568190802E-01],
	[4.9215000000E+04, 4.7388252739E+01, 4.9811600321E+00, 3.2060752349E+01, 3.9517958487E+00, 9.8568766305E-01],
	[4.9220000000E+04, 4.7396876672E+01, 4.9812078528E+00, 3.2071435300E+01, 3.9520481759E+00, 9.8569341543E-01],
	[4.9225000000E+04, 4.7405501298E+01, 4.9812556691E+00, 3.2082120723E+01, 3.9523004444E+00, 9.8569916517E-01],
	[4.9230000000E+04, 4.7414126617E+01, 4.9813034810E+00, 3.2092808619E+01, 3.9525526543E+00, 9.8570491226E-01],
	[4.9235000000E+04, 4.7422752630E+01, 4.9813512885E+00, 3.2103498990E+01, 3.9528048056E+00, 9.8571065670E-01],
	[4.9240000000E+04, 4.7431379335E+01, 4.9813990916E+00, 3.2114191834E+01, 3.9530568982E+00, 9.8571639850E-01],
	[4.9245000000E+04, 4.7440006734E+01, 4.9814468904E+00, 3.2124887153E+01, 3.9533089322E+00, 9.8572213766E-01],
	[4.9250000000E+04, 4.7448634826E+01, 4.9814946847E+00, 3.2135584946E+01, 3.9535609076E+00, 9.8572787418E-01],
	[4.9255000000E+04, 4.7457263611E+01, 4.9815424746E+00, 3.2146285214E+01, 3.9538128245E+00, 9.8573360806E-01],
	[4.9260000000E+04, 4.7465893088E+01, 4.9815902601E+00, 3.2156987957E+01, 3.9540646827E+00, 9.8573933930E-01],
	[4.9265000000E+04, 4.7474523259E+01, 4.9816380413E+00, 3.2167693176E+01, 3.9543164825E+00, 9.8574506791E-01],
	[4.9270000000E+04, 4.7483154123E+01, 4.9816858180E+00, 3.2178400871E+01, 3.9545682236E+00, 9.8575079388E-01],
	[4.9275000000E+04, 4.7491785680E+01, 4.9817335904E+00, 3.2189111042E+01, 3.9548199063E+00, 9.8575651721E-01],
	[4.9280000000E+04, 4.7500417930E+01, 4.9817813583E+00, 3.2199823690E+01, 3.9550715305E+00, 9.8576223792E-01],
	[4.9285000000E+04, 4.7509050873E+01, 4.9818291219E+00, 3.2210538815E+01, 3.9553230962E+00, 9.8576795599E-01],
	[4.9290000000E+04, 4.7517684509E+01, 4.9818768811E+00, 3.2221256416E+01, 3.9555746035E+00, 9.8577367143E-01],
	[4.9295000000E+04, 4.7526318838E+01, 4.9819246359E+00, 3.2231976496E+01, 3.9558260523E+00, 9.8577938425E-01],
	[4.9300000000E+04, 4.7534953860E+01, 4.9819723863E+00, 3.2242699053E+01, 3.9560774427E+00, 9.8578509444E-01],
	[4.9305000000E+04, 4.7543589575E+01, 4.9820201324E+00, 3.2253424088E+01, 3.9563287746E+00, 9.8579080200E-01],
	[4.9310000000E+04, 4.7552225983E+01, 4.9820678740E+00, 3.2264151602E+01, 3.9565800482E+00, 9.8579650693E-01],
	[4.9315000000E+04, 4.7560863084E+01, 4.9821156113E+00, 3.2274881594E+01, 3.9568312633E+00, 9.8580220925E-01],
	[4.9320000000E+04, 4.7569500877E+01, 4.9821633442E+00, 3.2285614066E+01, 3.9570824202E+00, 9.8580790894E-01],
	[4.9325000000E+04, 4.7578139364E+01, 4.9822110727E+00, 3.2296349017E+01, 3.9573335186E+00, 9.8581360601E-01],
	[4.9330000000E+04, 4.7586778543E+01, 4.9822587968E+00, 3.2307086448E+01, 3.9575845587E+00, 9.8581930046E-01],
	[4.9335000000E+04, 4.7595418415E+01, 4.9823065166E+00, 3.2317826358E+01, 3.9578355406E+00, 9.8582499230E-01],
	[4.9340000000E+04, 4.7604058980E+01, 4.9823542319E+00, 3.2328568750E+01, 3.9580864641E+00, 9.8583068152E-01],
	[4.9345000000E+04, 4.7612700238E+01, 4.9824019429E+00, 3.2339313622E+01, 3.9583373293E+00, 9.8583636812E-01],
	[4.9350000000E+04, 4.7621342188E+01, 4.9824496495E+00, 3.2350060975E+01, 3.9585881363E+00, 9.8584205211E-01],
	[4.9355000000E+04, 4.7629984832E+01, 4.9824973518E+00, 3.2360810809E+01, 3.9588388850E+00, 9.8584773348E-01],
	[4.9360000000E+04, 4.7638628168E+01, 4.9825450496E+00, 3.2371563125E+01, 3.9590895755E+00, 9.8585341225E-01],
	[4.9365000000E+04, 4.7647272197E+01, 4.9825927431E+00, 3.2382317924E+01, 3.9593402077E+00, 9.8585908840E-01],
	[4.9370000000E+04, 4.7655916918E+01, 4.9826404322E+00, 3.2393075204E+01, 3.9595907818E+00, 9.8586476195E-01],
	[4.9375000000E+04, 4.7664562333E+01, 4.9826881169E+00, 3.2403834967E+01, 3.9598412977E+00, 9.8587043289E-01],
	[4.9380000000E+04, 4.7673208440E+01, 4.9827357973E+00, 3.2414597213E+01, 3.9600917554E+00, 9.8587610122E-01],
	[4.9385000000E+04, 4.7681855240E+01, 4.9827834733E+00, 3.2425361943E+01, 3.9603421549E+00, 9.8588176695E-01],
	[4.9390000000E+04, 4.7690502732E+01, 4.9828311449E+00, 3.2436129156E+01, 3.9605924964E+00, 9.8588743008E-01],
	[4.9395000000E+04, 4.7699150917E+01, 4.9828788122E+00, 3.2446898852E+01, 3.9608427797E+00, 9.8589309060E-01],
	[4.9400000000E+04, 4.7707799795E+01, 4.9829264750E+00, 3.2457671034E+01, 3.9610930049E+00, 9.8589874852E-01],
	[4.9405000000E+04, 4.7716449366E+01, 4.9829741336E+00, 3.2468445699E+01, 3.9613431720E+00, 9.8590440385E-01],
	[4.9410000000E+04, 4.7725099629E+01, 4.9830217877E+00, 3.2479222850E+01, 3.9615932810E+00, 9.8591005657E-01],
	[4.9415000000E+04, 4.7733750584E+01, 4.9830694375E+00, 3.2490002486E+01, 3.9618433320E+00, 9.8591570670E-01],
	[4.9420000000E+04, 4.7742402233E+01, 4.9831170829E+00, 3.2500784607E+01, 3.9620933250E+00, 9.8592135423E-01],
	[4.9425000000E+04, 4.7751054573E+01, 4.9831647240E+00, 3.2511569215E+01, 3.9623432599E+00, 9.8592699917E-01],
	[4.9430000000E+04, 4.7759707607E+01, 4.9832123606E+00, 3.2522356308E+01, 3.9625931368E+00, 9.8593264152E-01],
	[4.9435000000E+04, 4.7768361333E+01, 4.9832599930E+00, 3.2533145888E+01, 3.9628429558E+00, 9.8593828128E-01],
	[4.9440000000E+04, 4.7777015751E+01, 4.9833076209E+00, 3.2543937955E+01, 3.9630927167E+00, 9.8594391844E-01],
	[4.9445000000E+04, 4.7785670862E+01, 4.9833552445E+00, 3.2554732509E+01, 3.9633424197E+00, 9.8594955302E-01],
	[4.9450000000E+04, 4.7794326666E+01, 4.9834028638E+00, 3.2565529550E+01, 3.9635920648E+00, 9.8595518501E-01],
	[4.9455000000E+04, 4.7802983162E+01, 4.9834504786E+00, 3.2576329079E+01, 3.9638416519E+00, 9.8596081441E-01],
	[4.9460000000E+04, 4.7811640350E+01, 4.9834980892E+00, 3.2587131097E+01, 3.9640911812E+00, 9.8596644123E-01],
	[4.9465000000E+04, 4.7820298231E+01, 4.9835456953E+00, 3.2597935602E+01, 3.9643406525E+00, 9.8597206547E-01],
	[4.9470000000E+04, 4.7828956805E+01, 4.9835932971E+00, 3.2608742597E+01, 3.9645900660E+00, 9.8597768712E-01],
	[4.9475000000E+04, 4.7837616071E+01, 4.9836408946E+00, 3.2619552080E+01, 3.9648394216E+00, 9.8598330619E-01],
	[4.9480000000E+04, 4.7846276029E+01, 4.9836884877E+00, 3.2630364053E+01, 3.9650887193E+00, 9.8598892268E-01],
	[4.9485000000E+04, 4.7854936680E+01, 4.9837360764E+00, 3.2641178516E+01, 3.9653379593E+00, 9.8599453660E-01],
	[4.9490000000E+04, 4.7863598023E+01, 4.9837836608E+00, 3.2651995469E+01, 3.9655871414E+00, 9.8600014794E-01],
	[4.9495000000E+04, 4.7872260058E+01, 4.9838312408E+00, 3.2662814912E+01, 3.9658362658E+00, 9.8600575670E-01],
	[4.9500000000E+04, 4.7880922786E+01, 4.9838788165E+00, 3.2673636845E+01, 3.9660853323E+00, 9.8601136289E-01],
	[4.9505000000E+04, 4.7889586206E+01, 4.9839263878E+00, 3.2684461270E+01, 3.9663343411E+00, 9.8601696650E-01],
	[4.9510000000E+04, 4.7898250319E+01, 4.9839739548E+00, 3.2695288186E+01, 3.9665832922E+00, 9.8602256755E-01],
	[4.9515000000E+04, 4.7906915124E+01, 4.9840215174E+00, 3.2706117594E+01, 3.9668321855E+00, 9.8602816602E-01],
	[4.9520000000E+04, 4.7915580621E+01, 4.9840690757E+00, 3.2716949494E+01, 3.9670810211E+00, 9.8603376192E-01],
	[4.9525000000E+04, 4.7924246810E+01, 4.9841166297E+00, 3.2727783886E+01, 3.9673297990E+00, 9.8603935526E-01],
	[4.9530000000E+04, 4.7932913692E+01, 4.9841641792E+00, 3.2738620770E+01, 3.9675785192E+00, 9.8604494603E-01],
	[4.9535000000E+04, 4.7941581266E+01, 4.9842117245E+00, 3.2749460148E+01, 3.9678271818E+00, 9.8605053423E-01],
	[4.9540000000E+04, 4.7950249532E+01, 4.9842592654E+00, 3.2760302018E+01, 3.9680757867E+00, 9.8605611988E-01],
	[4.9545000000E+04, 4.7958918490E+01, 4.9843068019E+00, 3.2771146383E+01, 3.9683243340E+00, 9.8606170295E-01],
	[4.9550000000E+04, 4.7967588141E+01, 4.9843543341E+00, 3.2781993241E+01, 3.9685728237E+00, 9.8606728347E-01],
	[4.9555000000E+04, 4.7976258484E+01, 4.9844018620E+00, 3.2792842594E+01, 3.9688212558E+00, 9.8607286143E-01],
	[4.9560000000E+04, 4.7984929519E+01, 4.9844493855E+00, 3.2803694441E+01, 3.9690696303E+00, 9.8607843683E-01],
	[4.9565000000E+04, 4.7993601246E+01, 4.9844969047E+00, 3.2814548782E+01, 3.9693179472E+00, 9.8608400967E-01],
	[4.9570000000E+04, 4.8002273666E+01, 4.9845444195E+00, 3.2825405619E+01, 3.9695662066E+00, 9.8608957996E-01],
	[4.9575000000E+04, 4.8010946777E+01, 4.9845919300E+00, 3.2836264952E+01, 3.9698144084E+00, 9.8609514769E-01],
	[4.9580000000E+04, 4.8019620581E+01, 4.9846394362E+00, 3.2847126780E+01, 3.9700625528E+00, 9.8610071287E-01],
	[4.9585000000E+04, 4.8028295077E+01, 4.9846869380E+00, 3.2857991105E+01, 3.9703106396E+00, 9.8610627550E-01],
	[4.9590000000E+04, 4.8036970264E+01, 4.9847344355E+00, 3.2868857926E+01, 3.9705586689E+00, 9.8611183557E-01],
	[4.9595000000E+04, 4.8045646144E+01, 4.9847819286E+00, 3.2879727243E+01, 3.9708066408E+00, 9.8611739310E-01],
	[4.9600000000E+04, 4.8054322716E+01, 4.9848294174E+00, 3.2890599058E+01, 3.9710545552E+00, 9.8612294808E-01],
	[4.9605000000E+04, 4.8062999980E+01, 4.9848769019E+00, 3.2901473371E+01, 3.9713024122E+00, 9.8612850051E-01],
	[4.9610000000E+04, 4.8071677937E+01, 4.9849243821E+00, 3.2912350181E+01, 3.9715502118E+00, 9.8613405040E-01],
	[4.9615000000E+04, 4.8080356585E+01, 4.9849718579E+00, 3.2923229489E+01, 3.9717979539E+00, 9.8613959774E-01],
	[4.9620000000E+04, 4.8089035925E+01, 4.9850193294E+00, 3.2934111295E+01, 3.9720456387E+00, 9.8614514254E-01],
	[4.9625000000E+04, 4.8097715957E+01, 4.9850667965E+00, 3.2944995601E+01, 3.9722932661E+00, 9.8615068480E-01],
	[4.9630000000E+04, 4.8106396681E+01, 4.9851142593E+00, 3.2955882405E+01, 3.9725408361E+00, 9.8615622452E-01],
	[4.9635000000E+04, 4.8115078097E+01, 4.9851617178E+00, 3.2966771709E+01, 3.9727883488E+00, 9.8616176169E-01],
	[4.9640000000E+04, 4.8123760205E+01, 4.9852091720E+00, 3.2977663512E+01, 3.9730358042E+00, 9.8616729634E-01],
	[4.9645000000E+04, 4.8132443005E+01, 4.9852566218E+00, 3.2988557815E+01, 3.9732832023E+00, 9.8617282844E-01],
	[4.9650000000E+04, 4.8141126497E+01, 4.9853040673E+00, 3.2999454619E+01, 3.9735305431E+00, 9.8617835801E-01],
	[4.9655000000E+04, 4.8149810681E+01, 4.9853515085E+00, 3.3010353923E+01, 3.9737778266E+00, 9.8618388505E-01],
	[4.9660000000E+04, 4.8158495557E+01, 4.9853989453E+00, 3.3021255728E+01, 3.9740250528E+00, 9.8618940955E-01],
	[4.9665000000E+04, 4.8167181124E+01, 4.9854463779E+00, 3.3032160035E+01, 3.9742722218E+00, 9.8619493153E-01],
	[4.9670000000E+04, 4.8175867384E+01, 4.9854938061E+00, 3.3043066843E+01, 3.9745193336E+00, 9.8620045097E-01],
	[4.9675000000E+04, 4.8184554335E+01, 4.9855412300E+00, 3.3053976153E+01, 3.9747663881E+00, 9.8620596788E-01],
	[4.9680000000E+04, 4.8193241978E+01, 4.9855886495E+00, 3.3064887966E+01, 3.9750133855E+00, 9.8621148227E-01],
	[4.9685000000E+04, 4.8201930313E+01, 4.9856360648E+00, 3.3075802281E+01, 3.9752603257E+00, 9.8621699413E-01],
	[4.9690000000E+04, 4.8210619340E+01, 4.9856834757E+00, 3.3086719098E+01, 3.9755072087E+00, 9.8622250347E-01],
	[4.9695000000E+04, 4.8219309059E+01, 4.9857308823E+00, 3.3097638420E+01, 3.9757540346E+00, 9.8622801028E-01],
	[4.9700000000E+04, 4.8227999469E+01, 4.9857782845E+00, 3.3108560244E+01, 3.9760008033E+00, 9.8623351458E-01],
	[4.9705000000E+04, 4.8236690571E+01, 4.9858256825E+00, 3.3119484573E+01, 3.9762475150E+00, 9.8623901635E-01],
	[4.9710000000E+04, 4.8245382365E+01, 4.9858730761E+00, 3.3130411405E+01, 3.9764941695E+00, 9.8624451560E-01],
	[4.9715000000E+04, 4.8254074851E+01, 4.9859204655E+00, 3.3141340742E+01, 3.9767407669E+00, 9.8625001233E-01],
	[4.9720000000E+04, 4.8262768028E+01, 4.9859678505E+00, 3.3152272584E+01, 3.9769873073E+00, 9.8625550655E-01],
	[4.9725000000E+04, 4.8271461897E+01, 4.9860152312E+00, 3.3163206932E+01, 3.9772337907E+00, 9.8626099825E-01],
	[4.9730000000E+04, 4.8280156458E+01, 4.9860626076E+00, 3.3174143784E+01, 3.9774802170E+00, 9.8626648744E-01],
	[4.9735000000E+04, 4.8288851711E+01, 4.9861099796E+00, 3.3185083143E+01, 3.9777265863E+00, 9.8627197411E-01],
	[4.9740000000E+04, 4.8297547655E+01, 4.9861573474E+00, 3.3196025007E+01, 3.9779728985E+00, 9.8627745828E-01],
	[4.9745000000E+04, 4.8306244290E+01, 4.9862047108E+00, 3.3206969378E+01, 3.9782191538E+00, 9.8628293993E-01],
	[4.9750000000E+04, 4.8314941618E+01, 4.9862520700E+00, 3.3217916256E+01, 3.9784653522E+00, 9.8628841907E-01],
	[4.9755000000E+04, 4.8323639637E+01, 4.9862994248E+00, 3.3228865641E+01, 3.9787114935E+00, 9.8629389571E-01],
	[4.9760000000E+04, 4.8332338347E+01, 4.9863467753E+00, 3.3239817533E+01, 3.9789575780E+00, 9.8629936984E-01],
	[4.9765000000E+04, 4.8341037750E+01, 4.9863941215E+00, 3.3250771933E+01, 3.9792036055E+00, 9.8630484146E-01],
	[4.9770000000E+04, 4.8349737843E+01, 4.9864414634E+00, 3.3261728841E+01, 3.9794495761E+00, 9.8631031058E-01],
	[4.9775000000E+04, 4.8358438629E+01, 4.9864888010E+00, 3.3272688257E+01, 3.9796954898E+00, 9.8631577720E-01],
	[4.9780000000E+04, 4.8367140106E+01, 4.9865361343E+00, 3.3283650182E+01, 3.9799413467E+00, 9.8632124131E-01],
	[4.9785000000E+04, 4.8375842274E+01, 4.9865834633E+00, 3.3294614616E+01, 3.9801871467E+00, 9.8632670293E-01],
	[4.9790000000E+04, 4.8384545134E+01, 4.9866307880E+00, 3.3305581560E+01, 3.9804328898E+00, 9.8633216205E-01],
	[4.9795000000E+04, 4.8393248685E+01, 4.9866781084E+00, 3.3316551013E+01, 3.9806785761E+00, 9.8633761867E-01],
	[4.9800000000E+04, 4.8401952928E+01, 4.9867254244E+00, 3.3327522976E+01, 3.9809242057E+00, 9.8634307279E-01],
	[4.9805000000E+04, 4.8410657863E+01, 4.9867727362E+00, 3.3338497449E+01, 3.9811697784E+00, 9.8634852442E-01],
	[4.9810000000E+04, 4.8419363489E+01, 4.9868200437E+00, 3.3349474433E+01, 3.9814152943E+00, 9.8635397356E-01],
	[4.9815000000E+04, 4.8428069806E+01, 4.9868673469E+00, 3.3360453928E+01, 3.9816607535E+00, 9.8635942020E-01],
	[4.9820000000E+04, 4.8436776815E+01, 4.9869146457E+00, 3.3371435934E+01, 3.9819061559E+00, 9.8636486435E-01],
	[4.9825000000E+04, 4.8445484515E+01, 4.9869619403E+00, 3.3382420452E+01, 3.9821515017E+00, 9.8637030602E-01],
	[4.9830000000E+04, 4.8454192906E+01, 4.9870092306E+00, 3.3393407482E+01, 3.9823967907E+00, 9.8637574519E-01],
	[4.9835000000E+04, 4.8462901989E+01, 4.9870565166E+00, 3.3404397024E+01, 3.9826420230E+00, 9.8638118188E-01],
	[4.9840000000E+04, 4.8471611764E+01, 4.9871037983E+00, 3.3415389078E+01, 3.9828871986E+00, 9.8638661608E-01],
	[4.9845000000E+04, 4.8480322229E+01, 4.9871510757E+00, 3.3426383645E+01, 3.9831323175E+00, 9.8639204780E-01],
	[4.9850000000E+04, 4.8489033386E+01, 4.9871983488E+00, 3.3437380726E+01, 3.9833773798E+00, 9.8639747703E-01],
	[4.9855000000E+04, 4.8497745235E+01, 4.9872456176E+00, 3.3448380320E+01, 3.9836223855E+00, 9.8640290378E-01],
	[4.9860000000E+04, 4.8506465512E+01, 4.9872936249E+00, 3.3459382428E+01, 3.9838678607E+00, 9.8640832805E-01],
	[4.9865000000E+04, 4.8515194485E+01, 4.9873423960E+00, 3.3470387050E+01, 3.9841138236E+00, 9.8641374984E-01],
	[4.9870000000E+04, 4.8523924154E+01, 4.9873911627E+00, 3.3481394187E+01, 3.9843597299E+00, 9.8641916916E-01],
	[4.9875000000E+04, 4.8532654518E+01, 4.9874399250E+00, 3.3492403838E+01, 3.9846055798E+00, 9.8642458599E-01],
	[4.9880000000E+04, 4.8541385577E+01, 4.9874886829E+00, 3.3503416005E+01, 3.9848513732E+00, 9.8643000035E-01],
	[4.9885000000E+04, 4.8550117332E+01, 4.9875374363E+00, 3.3514430686E+01, 3.9850971102E+00, 9.8643541224E-01],
	[4.9890000000E+04, 4.8558849781E+01, 4.9875861854E+00, 3.3525447884E+01, 3.9853427908E+00, 9.8644082165E-01],
	[4.9895000000E+04, 4.8567582927E+01, 4.9876349300E+00, 3.3536467598E+01, 3.9855884149E+00, 9.8644622860E-01],
	[4.9900000000E+04, 4.8576316767E+01, 4.9876836703E+00, 3.3547489828E+01, 3.9858339827E+00, 9.8645163307E-01],
	[4.9905000000E+04, 4.8585051303E+01, 4.9877324061E+00, 3.3558514575E+01, 3.9860794941E+00, 9.8645703507E-01],
	[4.9910000000E+04, 4.8593786534E+01, 4.9877811375E+00, 3.3569541839E+01, 3.9863249491E+00, 9.8646243460E-01],
	[4.9915000000E+04, 4.8602522460E+01, 4.9878298645E+00, 3.3580571621E+01, 3.9865703478E+00, 9.8646783167E-01],
	[4.9920000000E+04, 4.8611259082E+01, 4.9878785872E+00, 3.3591603920E+01, 3.9868156902E+00, 9.8647322627E-01],
	[4.9925000000E+04, 4.8619996398E+01, 4.9879273054E+00, 3.3602638737E+01, 3.9870609762E+00, 9.8647861841E-01],
	[4.9930000000E+04, 4.8628734410E+01, 4.9879760192E+00, 3.3613676073E+01, 3.9873062060E+00, 9.8648400809E-01],
	[4.9935000000E+04, 4.8637473117E+01, 4.9880247286E+00, 3.3624715927E+01, 3.9875513795E+00, 9.8648939530E-01],
	[4.9940000000E+04, 4.8646212520E+01, 4.9880734336E+00, 3.3635758300E+01, 3.9877964967E+00, 9.8649478005E-01],
	[4.9945000000E+04, 4.8654952617E+01, 4.9881221342E+00, 3.3646803192E+01, 3.9880415577E+00, 9.8650016235E-01],
	[4.9950000000E+04, 4.8663693410E+01, 4.9881708304E+00, 3.3657850605E+01, 3.9882865624E+00, 9.8650554219E-01],
	[4.9955000000E+04, 4.8672434897E+01, 4.9882195222E+00, 3.3668900537E+01, 3.9885315109E+00, 9.8651091957E-01],
	[4.9960000000E+04, 4.8681177080E+01, 4.9882682096E+00, 3.3679952989E+01, 3.9887764033E+00, 9.8651629449E-01],
	[4.9965000000E+04, 4.8689919958E+01, 4.9883168926E+00, 3.3691007962E+01, 3.9890212394E+00, 9.8652166696E-01],
	[4.9970000000E+04, 4.8698663531E+01, 4.9883655712E+00, 3.3702065456E+01, 3.9892660194E+00, 9.8652703698E-01],
	[4.9975000000E+04, 4.8707407799E+01, 4.9884142454E+00, 3.3713125471E+01, 3.9895107432E+00, 9.8653240455E-01],
	[4.9980000000E+04, 4.8716152762E+01, 4.9884629153E+00, 3.3724188008E+01, 3.9897554109E+00, 9.8653776967E-01],
	[4.9985000000E+04, 4.8724898420E+01, 4.9885115807E+00, 3.3735253067E+01, 3.9900000224E+00, 9.8654313234E-01],
	[4.9990000000E+04, 4.8733644773E+01, 4.9885602417E+00, 3.3746320648E+01, 3.9902445779E+00, 9.8654849256E-01],
	[4.9995000000E+04, 4.8742391821E+01, 4.9886088984E+00, 3.3757390751E+01, 3.9904890772E+00, 9.8655385033E-01],
	[5.0000000000E+04, 4.8751139565E+01, 4.9886575506E+00, 3.3768463377E+01, 3.9907335205E+00, 9.8655920567E-01],
	[5.0005000000E+04, 4.8759888003E+01, 4.9887061985E+00, 3.3779547832E+01, 3.9909780377E+00, 9.8656455855E-01],
	[5.0010000000E+04, 4.8768637136E+01, 4.9887548420E+00, 3.3790634817E+01, 3.9912224987E+00, 9.8656990900E-01],
	[5.0015000000E+04, 4.8777386964E+01, 4.9888034810E+00, 3.3801724330E+01, 3.9914669036E+00, 9.8657525700E-01],
	[5.0020000000E+04, 4.8786137487E+01, 4.9888521157E+00, 3.3812816372E+01, 3.9917112525E+00, 9.8658060256E-01],
	[5.0025000000E+04, 4.8794888