import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

breast_MFP = np.array([
	[5.0000000000E+03, 2.4563690218E+00, 7.7265642073E+00, 3.7958630335E-02, 3.7200998873E-02, 3.4183377686E-01],
	[5.0050000000E+03, 2.4591807242E+00, 7.7236231605E+00, 3.8074943540E-02, 3.7313287931E-02, 3.4208795768E-01],
	[5.0100000000E+03, 2.4619928327E+00, 7.7206861682E+00, 3.8191496323E-02, 3.7425799008E-02, 3.4234190787E-01],
	[5.0150000000E+03, 2.4648053470E+00, 7.7177532207E+00, 3.8308288937E-02, 3.7538532296E-02, 3.4259562807E-01],
	[5.0200000000E+03, 2.4676182668E+00, 7.7148243084E+00, 3.8425321634E-02, 3.7651487989E-02, 3.4284911889E-01],
	[5.0250000000E+03, 2.4704315916E+00, 7.7118994218E+00, 3.8542594669E-02, 3.7764666279E-02, 3.4310238094E-01],
	[5.0300000000E+03, 2.4732453212E+00, 7.7089785514E+00, 3.8660108293E-02, 3.7878067358E-02, 3.4335541485E-01],
	[5.0350000000E+03, 2.4760594551E+00, 7.7060616875E+00, 3.8777862760E-02, 3.7991691419E-02, 3.4360822121E-01],
	[5.0400000000E+03, 2.4788739932E+00, 7.7031488209E+00, 3.8895858324E-02, 3.8105538654E-02, 3.4386080064E-01],
	[5.0450000000E+03, 2.4816889349E+00, 7.7002399419E+00, 3.9014095238E-02, 3.8219609256E-02, 3.4411315375E-01],
	[5.0500000000E+03, 2.4845042800E+00, 7.6973350413E+00, 3.9132573755E-02, 3.8333903415E-02, 3.4436528114E-01],
	[5.0550000000E+03, 2.4873200282E+00, 7.6944341097E+00, 3.9251294128E-02, 3.8448421325E-02, 3.4461718341E-01],
	[5.0600000000E+03, 2.4901361790E+00, 7.6915371377E+00, 3.9370256610E-02, 3.8563163175E-02, 3.4486886118E-01],
	[5.0650000000E+03, 2.4929527322E+00, 7.6886441160E+00, 3.9489461455E-02, 3.8678129159E-02, 3.4512031502E-01],
	[5.0700000000E+03, 2.4957696873E+00, 7.6857550353E+00, 3.9608908916E-02, 3.8793319467E-02, 3.4537154555E-01],
	[5.0750000000E+03, 2.4985870442E+00, 7.6828698864E+00, 3.9728599246E-02, 3.8908734291E-02, 3.4562255336E-01],
	[5.0800000000E+03, 2.5014048024E+00, 7.6799886601E+00, 3.9848532698E-02, 3.9024373822E-02, 3.4587333904E-01],
	[5.0850000000E+03, 2.5042367208E+00, 7.6771486655E+00, 3.9968709527E-02, 3.9140242581E-02, 3.4612390319E-01],
	[5.0900000000E+03, 2.5070703939E+00, 7.6743161300E+00, 4.0089129985E-02, 3.9256336891E-02, 3.4637424639E-01],
	[5.0950000000E+03, 2.5099044865E+00, 7.6714874191E+00, 4.0209794325E-02, 3.9372656525E-02, 3.4662436922E-01],
	[5.1000000000E+03, 2.5127389982E+00, 7.6686625240E+00, 4.0330702802E-02, 3.9489201673E-02, 3.4687427229E-01],
	[5.1050000000E+03, 2.5155739288E+00, 7.6658414357E+00, 4.0451855667E-02, 3.9605972526E-02, 3.4712395616E-01],
	[5.1100000000E+03, 2.5184092779E+00, 7.6630241453E+00, 4.0573253176E-02, 3.9722969275E-02, 3.4737342143E-01],
	[5.1150000000E+03, 2.5212450450E+00, 7.6602106442E+00, 4.0694895580E-02, 3.9840192109E-02, 3.4762266867E-01],
	[5.1200000000E+03, 2.5240812300E+00, 7.6574009234E+00, 4.0816783134E-02, 3.9957641219E-02, 3.4787169846E-01],
	[5.1250000000E+03, 2.5269178324E+00, 7.6545949742E+00, 4.0938916092E-02, 4.0075316795E-02, 3.4812051138E-01],
	[5.1300000000E+03, 2.5297548519E+00, 7.6517927879E+00, 4.1061294705E-02, 4.0193219027E-02, 3.4836910800E-01],
	[5.1350000000E+03, 2.5325922881E+00, 7.6489943558E+00, 4.1183919228E-02, 4.0311348105E-02, 3.4861748889E-01],
	[5.1400000000E+03, 2.5354301407E+00, 7.6461996692E+00, 4.1306789915E-02, 4.0429704218E-02, 3.4886565463E-01],
	[5.1450000000E+03, 2.5382684094E+00, 7.6434087194E+00, 4.1429907019E-02, 4.0548287556E-02, 3.4911360578E-01],
	[5.1500000000E+03, 2.5411070938E+00, 7.6406214978E+00, 4.1553270792E-02, 4.0667098308E-02, 3.4936134307E-01],
	[5.1550000000E+03, 2.5439461936E+00, 7.6378379958E+00, 4.1676881490E-02, 4.0786136663E-02, 3.4960886733E-01],
	[5.1600000000E+03, 2.5467857083E+00, 7.6350582050E+00, 4.1800739365E-02, 4.0905402811E-02, 3.4985617921E-01],
	[5.1650000000E+03, 2.5496337147E+00, 7.6323039864E+00, 4.1924844671E-02, 4.1024899663E-02, 3.5010327933E-01],
	[5.1700000000E+03, 2.5524886552E+00, 7.6295710249E+00, 4.2049197661E-02, 4.1144626913E-02, 3.5035016833E-01],
	[5.1750000000E+03, 2.5553440281E+00, 7.6268416824E+00, 4.2173798589E-02, 4.1264582567E-02, 3.5059684683E-01],
	[5.1800000000E+03, 2.5581998332E+00, 7.6241159506E+00, 4.2298647709E-02, 4.1384766814E-02, 3.5084331546E-01],
	[5.1850000000E+03, 2.5610560699E+00, 7.6213938214E+00, 4.2423745274E-02, 4.1505179842E-02, 3.5108957485E-01],
	[5.1900000000E+03, 2.5639127381E+00, 7.6186752863E+00, 4.2549091538E-02, 4.1625821840E-02, 3.5133562561E-01],
	[5.1950000000E+03, 2.5667698373E+00, 7.6159603373E+00, 4.2674686754E-02, 4.1746692996E-02, 3.5158146837E-01],
	[5.2000000000E+03, 2.5696273672E+00, 7.6132489662E+00, 4.2800531176E-02, 4.1867793498E-02, 3.5182710374E-01],
	[5.2050000000E+03, 2.5724853274E+00, 7.6105411648E+00, 4.2926625058E-02, 4.1989123534E-02, 3.5207253234E-01],
	[5.2100000000E+03, 2.5753437176E+00, 7.6078369250E+00, 4.3052968653E-02, 4.2110683292E-02, 3.5231775478E-01],
	[5.2150000000E+03, 2.5782025374E+00, 7.6051362388E+00, 4.3179562215E-02, 4.2232472960E-02, 3.5256277168E-01],
	[5.2200000000E+03, 2.5810617865E+00, 7.6024390979E+00, 4.3306405997E-02, 4.2354492725E-02, 3.5280758363E-01],
	[5.2250000000E+03, 2.5839214646E+00, 7.5997454945E+00, 4.3433500254E-02, 4.2476742774E-02, 3.5305219126E-01],
	[5.2300000000E+03, 2.5867815713E+00, 7.5970554204E+00, 4.3560845239E-02, 4.2599223296E-02, 3.5329659517E-01],
	[5.2350000000E+03, 2.5896421062E+00, 7.5943688677E+00, 4.3688441206E-02, 4.2721934476E-02, 3.5354079595E-01],
	[5.2400000000E+03, 2.5925030690E+00, 7.5916858284E+00, 4.3816288408E-02, 4.2844876503E-02, 3.5378479421E-01],
	[5.2450000000E+03, 2.5953644594E+00, 7.5890062946E+00, 4.3944387099E-02, 4.2968049562E-02, 3.5402859055E-01],
	[5.2500000000E+03, 2.5982394081E+00, 7.5863657569E+00, 4.4072737534E-02, 4.3091458599E-02, 3.5427218556E-01],
	[5.2550000000E+03, 2.6011157450E+00, 7.5837312013E+00, 4.4201339965E-02, 4.3215099427E-02, 3.5451557984E-01],
	[5.2600000000E+03, 2.6039925262E+00, 7.5811000648E+00, 4.4330194646E-02, 4.3338971895E-02, 3.5475877398E-01],
	[5.2650000000E+03, 2.6068697513E+00, 7.5784723397E+00, 4.4459301832E-02, 4.3463076187E-02, 3.5500176858E-01],
	[5.2700000000E+03, 2.6097474198E+00, 7.5758480184E+00, 4.4588661776E-02, 4.3587412492E-02, 3.5524456421E-01],
	[5.2750000000E+03, 2.6126255314E+00, 7.5732270934E+00, 4.4718274732E-02, 4.3711980994E-02, 3.5548716148E-01],
	[5.2800000000E+03, 2.6155040859E+00, 7.5706095568E+00, 4.4848140954E-02, 4.3836781879E-02, 3.5572956095E-01],
	[5.2850000000E+03, 2.6183830828E+00, 7.5679954012E+00, 4.4978260695E-02, 4.3961815335E-02, 3.5597176322E-01],
	[5.2900000000E+03, 2.6212625217E+00, 7.5653846191E+00, 4.5108634210E-02, 4.4087081545E-02, 3.5621376887E-01],
	[5.2950000000E+03, 2.6241424024E+00, 7.5627772028E+00, 4.5239261752E-02, 4.4212580697E-02, 3.5645557848E-01],
	[5.3000000000E+03, 2.6270227245E+00, 7.5601731449E+00, 4.5370143575E-02, 4.4338312975E-02, 3.5669719261E-01],
	[5.3050000000E+03, 2.6299034876E+00, 7.5575724378E+00, 4.5501279933E-02, 4.4464278565E-02, 3.5693861186E-01],
	[5.3100000000E+03, 2.6327846914E+00, 7.5549750742E+00, 4.5632671081E-02, 4.4590477651E-02, 3.5717983678E-01],
	[5.3150000000E+03, 2.6356663355E+00, 7.5523810465E+00, 4.5764317271E-02, 4.4716910420E-02, 3.5742086796E-01],
	[5.3200000000E+03, 2.6385484197E+00, 7.5497903474E+00, 4.5896218758E-02, 4.4843577055E-02, 3.5766170596E-01],
	[5.3250000000E+03, 2.6414309435E+00, 7.5472029695E+00, 4.6028375797E-02, 4.4970477742E-02, 3.5790235135E-01],
	[5.3300000000E+03, 2.6443145078E+00, 7.5446205332E+00, 4.6160788639E-02, 4.5097612898E-02, 3.5814280470E-01],
	[5.3350000000E+03, 2.6472114747E+00, 7.5420764483E+00, 4.6293457541E-02, 4.5224987519E-02, 3.5838306656E-01],
	[5.3400000000E+03, 2.6501088971E+00, 7.5395356032E+00, 4.6426382755E-02, 4.5352596792E-02, 3.5862313751E-01],
	[5.3450000000E+03, 2.6530067747E+00, 7.5369979909E+00, 4.6559564537E-02, 4.5480440901E-02, 3.5886301810E-01],
	[5.3500000000E+03, 2.6559051071E+00, 7.5344636042E+00, 4.6693003138E-02, 4.5608520031E-02, 3.5910270889E-01],
	[5.3550000000E+03, 2.6588038939E+00, 7.5319324359E+00, 4.6826698815E-02, 4.5736834364E-02, 3.5934221044E-01],
	[5.3600000000E+03, 2.6617031349E+00, 7.5294044791E+00, 4.6960651821E-02, 4.5865384085E-02, 3.5958152330E-01],
	[5.3650000000E+03, 2.6646028296E+00, 7.5268797267E+00, 4.7094862409E-02, 4.5994169377E-02, 3.5982064802E-01],
	[5.3700000000E+03, 2.6675029776E+00, 7.5243581715E+00, 4.7229330834E-02, 4.6123190426E-02, 3.6005958517E-01],
	[5.3750000000E+03, 2.6704035787E+00, 7.5218398066E+00, 4.7364057350E-02, 4.6252447412E-02, 3.6029833528E-01],
	[5.3800000000E+03, 2.6733046325E+00, 7.5193246250E+00, 4.7499042212E-02, 4.6381940521E-02, 3.6053689890E-01],
	[5.3850000000E+03, 2.6762061387E+00, 7.5168126197E+00, 4.7634285672E-02, 4.6511669935E-02, 3.6077527659E-01],
	[5.3900000000E+03, 2.6791080968E+00, 7.5143037838E+00, 4.7769787986E-02, 4.6641635837E-02, 3.6101346888E-01],
	[5.3950000000E+03, 2.6820105066E+00, 7.5117981103E+00, 4.7905549407E-02, 4.6771838410E-02, 3.6125147631E-01],
	[5.4000000000E+03, 2.6849133677E+00, 7.5092955923E+00, 4.8041570190E-02, 4.6902277836E-02, 3.6148929944E-01],
	[5.4050000000E+03, 2.6878166797E+00, 7.5067962229E+00, 4.8177850588E-02, 4.7032954299E-02, 3.6172693880E-01],
	[5.4100000000E+03, 2.6907204423E+00, 7.5042999953E+00, 4.8314390857E-02, 4.7163867980E-02, 3.6196439492E-01],
	[5.4150000000E+03, 2.6936246551E+00, 7.5018069025E+00, 4.8451191249E-02, 4.7295019061E-02, 3.6220166834E-01],
	[5.4200000000E+03, 2.6965408528E+00, 7.4993481834E+00, 4.8588252019E-02, 4.7426412543E-02, 3.6243875960E-01],
	[5.4250000000E+03, 2.6994590300E+00, 7.4968966363E+00, 4.8725573422E-02, 4.7558044468E-02, 3.6267566923E-01],
	[5.4300000000E+03, 2.7023776726E+00, 7.4944481480E+00, 4.8863155712E-02, 4.7689914386E-02, 3.6291239776E-01],
	[5.4350000000E+03, 2.7052967801E+00, 7.4920027118E+00, 4.9000999142E-02, 4.7822022481E-02, 3.6314894572E-01],
	[5.4400000000E+03, 2.7082163523E+00, 7.4895603211E+00, 4.9139103968E-02, 4.7954368934E-02, 3.6338531363E-01],
	[5.4450000000E+03, 2.7111363888E+00, 7.4871209694E+00, 4.9277470442E-02, 4.8086953926E-02, 3.6362150203E-01],
	[5.4500000000E+03, 2.7140568892E+00, 7.4846846500E+00, 4.9416098821E-02, 4.8219777639E-02, 3.6385751143E-01],
	[5.4550000000E+03, 2.7169778532E+00, 7.4822513564E+00, 4.9554989357E-02, 4.8352840254E-02, 3.6409334237E-01],
	[5.4600000000E+03, 2.7198992804E+00, 7.4798210822E+00, 4.9694142305E-02, 4.8486141952E-02, 3.6432899536E-01],
	[5.4650000000E+03, 2.7228211704E+00, 7.4773938207E+00, 4.9833557920E-02, 4.8619682914E-02, 3.6456447092E-01],
	[5.4700000000E+03, 2.7257435230E+00, 7.4749695656E+00, 4.9973236456E-02, 4.8753463320E-02, 3.6479976956E-01],
	[5.4750000000E+03, 2.7286663378E+00, 7.4725483102E+00, 5.0113178166E-02, 4.8887483352E-02, 3.6503489182E-01],
	[5.4800000000E+03, 2.7315896144E+00, 7.4701300483E+00, 5.0253794734E-02, 4.9022134698E-02, 3.6526983819E-01],
	[5.4850000000E+03, 2.7345133525E+00, 7.4677147733E+00, 5.0395008952E-02, 4.9157343712E-02, 3.6550460920E-01],
	[5.4900000000E+03, 2.7374375517E+00, 7.4653024789E+00, 5.0536490646E-02, 4.9292796113E-02, 3.6573920536E-01],
	[5.4950000000E+03, 2.7403622116E+00, 7.4628931587E+00, 5.0678240079E-02, 4.9428492085E-02, 3.6597362717E-01],
	[5.5000000000E+03, 2.7432873320E+00, 7.4604868062E+00, 5.0820257512E-02, 4.9564431815E-02, 3.6620787515E-01],
	[5.5050000000E+03, 2.7462185167E+00, 7.4580986537E+00, 5.0962543207E-02, 4.9700617999E-02, 3.6644194981E-01],
	[5.5100000000E+03, 2.7491570992E+00, 7.4557322532E+00, 5.1105097426E-02, 4.9837051453E-02, 3.6667585164E-01],
	[5.5150000000E+03, 2.7520961564E+00, 7.4533687489E+00, 5.1247920432E-02, 4.9973729270E-02, 3.6690958115E-01],
	[5.5200000000E+03, 2.7550356880E+00, 7.4510081346E+00, 5.1391012486E-02, 5.0110651634E-02, 3.6714313885E-01],
	[5.5250000000E+03, 2.7579756937E+00, 7.4486504043E+00, 5.1534373851E-02, 5.0247818732E-02, 3.6737652524E-01],
	[5.5300000000E+03, 2.7609161731E+00, 7.4462955517E+00, 5.1678004788E-02, 5.0385230748E-02, 3.6760974082E-01],
	[5.5350000000E+03, 2.7638571259E+00, 7.4439435708E+00, 5.1821905559E-02, 5.0522887867E-02, 3.6784278608E-01],
	[5.5400000000E+03, 2.7667985516E+00, 7.4415944554E+00, 5.1966076428E-02, 5.0660790274E-02, 3.6807566152E-01],
	[5.5450000000E+03, 2.7697404500E+00, 7.4392481996E+00, 5.2110517655E-02, 5.0798938153E-02, 3.6830836765E-01],
	[5.5500000000E+03, 2.7726828207E+00, 7.4369047972E+00, 5.2255229503E-02, 5.0937331689E-02, 3.6854090494E-01],
	[5.5550000000E+03, 2.7756256633E+00, 7.4345642422E+00, 5.2400212235E-02, 5.1075971066E-02, 3.6877327390E-01],
	[5.5600000000E+03, 2.7785689775E+00, 7.4322265286E+00, 5.2545466112E-02, 5.1214856468E-02, 3.6900547504E-01],
	[5.5650000000E+03, 2.7815127630E+00, 7.4298916505E+00, 5.2690991396E-02, 5.1353988079E-02, 3.6923750900E-01],
	[5.5700000000E+03, 2.7844570194E+00, 7.4275596017E+00, 5.2836788351E-02, 5.1493366083E-02, 3.6946937633E-01],
	[5.5750000000E+03, 2.7874017463E+00, 7.4252303763E+00, 5.2982857237E-02, 5.1632990662E-02, 3.6970107753E-01],
	[5.5800000000E+03, 2.7903469434E+00, 7.4229039685E+00, 5.3129198318E-02, 5.1772862002E-02, 3.6993261312E-01],
	[5.5850000000E+03, 2.7932926104E+00, 7.4205803722E+00, 5.3275811855E-02, 5.1912980284E-02, 3.7016398359E-01],
	[5.5900000000E+03, 2.7962387469E+00, 7.4182595816E+00, 5.3422698111E-02, 5.2053345693E-02, 3.7039518946E-01],
	[5.5950000000E+03, 2.7991941222E+00, 7.4159655438E+00, 5.3569857348E-02, 5.2193962645E-02, 3.7062623122E-01],
	[5.6000000000E+03, 2.8021532255E+00, 7.4136831243E+00, 5.3717289829E-02, 5.2334828701E-02, 3.7085710937E-01],
	[5.6050000000E+03, 2.8051128118E+00, 7.4114034432E+00, 5.3864995815E-02, 5.2475942480E-02, 3.7108782441E-01],
	[5.6100000000E+03, 2.8080728809E+00, 7.4091264950E+00, 5.4012975570E-02, 5.2617304167E-02, 3.7131837685E-01],
	[5.6150000000E+03, 2.8110334323E+00, 7.4068522738E+00, 5.4161229355E-02, 5.2758913943E-02, 3.7154876717E-01],
	[5.6200000000E+03, 2.8139944658E+00, 7.4045807739E+00, 5.4309757433E-02, 5.2900771991E-02, 3.7177899588E-01],
	[5.6250000000E+03, 2.8169559809E+00, 7.4023119897E+00, 5.4458560066E-02, 5.3042878493E-02, 3.7200906345E-01],
	[5.6300000000E+03, 2.8199179774E+00, 7.4000459156E+00, 5.4607637517E-02, 5.3185233631E-02, 3.7223897040E-01],
	[5.6350000000E+03, 2.8228804549E+00, 7.3977825459E+00, 5.4756990048E-02, 5.3327837587E-02, 3.7246871720E-01],
	[5.6400000000E+03, 2.8258434130E+00, 7.3955218749E+00, 5.4906617922E-02, 5.3470690542E-02, 3.7269830435E-01],
	[5.6450000000E+03, 2.8288068513E+00, 7.3932638972E+00, 5.5056521401E-02, 5.3613792679E-02, 3.7292773234E-01],
	[5.6500000000E+03, 2.8317707696E+00, 7.3910086070E+00, 5.5206700747E-02, 5.3757144178E-02, 3.7315700164E-01],
	[5.6550000000E+03, 2.8347351675E+00, 7.3887559988E+00, 5.5357156223E-02, 5.3900745222E-02, 3.7338611274E-01],
	[5.6600000000E+03, 2.8377000446E+00, 7.3865060670E+00, 5.5507888092E-02, 5.4044595990E-02, 3.7361506613E-01],
	[5.6650000000E+03, 2.8406654006E+00, 7.3842588062E+00, 5.5658896616E-02, 5.4188696664E-02, 3.7384386229E-01],
	[5.6700000000E+03, 2.8436312352E+00, 7.3820142107E+00, 5.5810182058E-02, 5.4333047424E-02, 3.7407250170E-01],
	[5.6750000000E+03, 2.8465975479E+00, 7.3797722751E+00, 5.5961744680E-02, 5.4477648452E-02, 3.7430098483E-01],
	[5.6800000000E+03, 2.8495643386E+00, 7.3775329939E+00, 5.6113584745E-02, 5.4622499927E-02, 3.7452931217E-01],
	[5.6850000000E+03, 2.8525399671E+00, 7.3753193518E+00, 5.6265702515E-02, 5.4767606379E-02, 3.7475748419E-01],
	[5.6900000000E+03, 2.8555192211E+00, 7.3731169374E+00, 5.6418098253E-02, 5.4912965314E-02, 3.7498550137E-01],
	[5.6950000000E+03, 2.8584989658E+00, 7.3709171143E+00, 5.6570772222E-02, 5.5058575288E-02, 3.7521336417E-01],
	[5.7000000000E+03, 2.8614792008E+00, 7.3687198772E+00, 5.6723724684E-02, 5.5204436480E-02, 3.7544107307E-01],
	[5.7050000000E+03, 2.8644599258E+00, 7.3665252208E+00, 5.6876955902E-02, 5.5350549070E-02, 3.7566862855E-01],
	[5.7100000000E+03, 2.8674411404E+00, 7.3643331398E+00, 5.7030466139E-02, 5.5496913238E-02, 3.7589603106E-01],
	[5.7150000000E+03, 2.8704228443E+00, 7.3621436289E+00, 5.7184255657E-02, 5.5643529164E-02, 3.7612328109E-01],
	[5.7200000000E+03, 2.8734050372E+00, 7.3599566828E+00, 5.7338324719E-02, 5.5790397025E-02, 3.7635037908E-01],
	[5.7250000000E+03, 2.8763877186E+00, 7.3577722964E+00, 5.7492673588E-02, 5.5937517003E-02, 3.7657732552E-01],
	[5.7300000000E+03, 2.8793708882E+00, 7.3555904644E+00, 5.7647302527E-02, 5.6084889275E-02, 3.7680412086E-01],
	[5.7350000000E+03, 2.8823545457E+00, 7.3534111815E+00, 5.7802211798E-02, 5.6232514021E-02, 3.7703076557E-01],
	[5.7400000000E+03, 2.8853386908E+00, 7.3512344426E+00, 5.7957401663E-02, 5.6380391420E-02, 3.7725726010E-01],
	[5.7450000000E+03, 2.8883233231E+00, 7.3490602426E+00, 5.8112872387E-02, 5.6528521648E-02, 3.7748360492E-01],
	[5.7500000000E+03, 2.8913084422E+00, 7.3468885761E+00, 5.8268624232E-02, 5.6676904886E-02, 3.7770980049E-01],
	[5.7550000000E+03, 2.8942940478E+00, 7.3447194382E+00, 5.8424657459E-02, 5.6825541311E-02, 3.7793584727E-01],
	[5.7600000000E+03, 2.8972801396E+00, 7.3425528236E+00, 5.8580972334E-02, 5.6974431101E-02, 3.7816174570E-01],
	[5.7650000000E+03, 2.9002667173E+00, 7.3403887272E+00, 5.8737569117E-02, 5.7123574433E-02, 3.7838749624E-01],
	[5.7700000000E+03, 2.9032537804E+00, 7.3382271439E+00, 5.8894448073E-02, 5.7272971487E-02, 3.7861309936E-01],
	[5.7750000000E+03, 2.9062460992E+00, 7.3360813087E+00, 5.9051609463E-02, 5.7422625111E-02, 3.7883855549E-01],
	[5.7800000000E+03, 2.9092451148E+00, 7.3339551593E+00, 5.9209053552E-02, 5.7572536324E-02, 3.7906386510E-01],
	[5.7850000000E+03, 2.9122446279E+00, 7.3318314637E+00, 5.9366780601E-02, 5.7722701841E-02, 3.7928902863E-01],
	[5.7900000000E+03, 2.9152446383E+00, 7.3297102169E+00, 5.9524790874E-02, 5.7873121838E-02, 3.7951404653E-01],
	[5.7950000000E+03, 2.9182451455E+00, 7.3275914141E+00, 5.9683084634E-02, 5.8023796494E-02, 3.7973891925E-01],
	[5.8000000000E+03, 2.9212461492E+00, 7.3254750504E+00, 5.9841662144E-02, 5.8174725984E-02, 3.7996364723E-01],
	[5.8050000000E+03, 2.9242476491E+00, 7.3233611208E+00, 6.0000523666E-02, 5.8325910486E-02, 3.8018823092E-01],
	[5.8100000000E+03, 2.9272496448E+00, 7.3212496204E+00, 6.0159669464E-02, 5.8477350176E-02, 3.8041267077E-01],
	[5.8150000000E+03, 2.9302521360E+00, 7.3191405444E+00, 6.0319099800E-02, 5.8629045230E-02, 3.8063696721E-01],
	[5.8200000000E+03, 2.9332551223E+00, 7.3170338878E+00, 6.0478814939E-02, 5.8780995825E-02, 3.8086112068E-01],
	[5.8250000000E+03, 2.9362586034E+00, 7.3149296459E+00, 6.0638815142E-02, 5.8933202136E-02, 3.8108513164E-01],
	[5.8300000000E+03, 2.9392625789E+00, 7.3128278138E+00, 6.0799100673E-02, 5.9085664340E-02, 3.8130900051E-01],
	[5.8350000000E+03, 2.9422670485E+00, 7.3107283867E+00, 6.0959671795E-02, 5.9238382612E-02, 3.8153272773E-01],
	[5.8400000000E+03, 2.9452720119E+00, 7.3086313598E+00, 6.1120528771E-02, 5.9391357127E-02, 3.8175631375E-01],
	[5.8450000000E+03, 2.9482774687E+00, 7.3065367282E+00, 6.1281671865E-02, 5.9544588061E-02, 3.8197975899E-01],
	[5.8500000000E+03, 2.9512834186E+00, 7.3044444873E+00, 6.1443101338E-02, 5.9698075589E-02, 3.8220306390E-01],
	[5.8550000000E+03, 2.9542898612E+00, 7.3023546321E+00, 6.1604817455E-02, 5.9851819887E-02, 3.8242622890E-01],
	[5.8600000000E+03, 2.9572967962E+00, 7.3002671580E+00, 6.1766820479E-02, 6.0005821127E-02, 3.8264925442E-01],
	[5.8650000000E+03, 2.9603042232E+00, 7.2981820603E+00, 6.1929110672E-02, 6.0160079486E-02, 3.8287214091E-01],
	[5.8700000000E+03, 2.9633210031E+00, 7.2961241890E+00, 6.2091688299E-02, 6.0314600508E-02, 3.8309488878E-01],
	[5.8750000000E+03, 2.9663398763E+00, 7.2940731076E+00, 6.2254553622E-02, 6.0469380008E-02, 3.8331749847E-01],
	[5.8800000000E+03, 2.9693592529E+00, 7.2920243468E+00, 6.2417706904E-02, 6.0624417202E-02, 3.8353997040E-01],
	[5.8850000000E+03, 2.9723791326E+00, 7.2899779022E+00, 6.2581148409E-02, 6.0779712263E-02, 3.8376230501E-01],
	[5.8900000000E+03, 2.9753995149E+00, 7.2879337692E+00, 6.2744878400E-02, 6.0935265366E-02, 3.8398450271E-01],
	[5.8950000000E+03, 2.9784203996E+00, 7.2858919431E+00, 6.2908897140E-02, 6.1091076684E-02, 3.8420656393E-01],
	[5.9000000000E+03, 2.9814417863E+00, 7.2838524194E+00, 6.3073204893E-02, 6.1247146391E-02, 3.8442848910E-01],
	[5.9050000000E+03, 2.9844636746E+00, 7.2818151936E+00, 6.3237801921E-02, 6.1403474660E-02, 3.8465027863E-01],
	[5.9100000000E+03, 2.9874860643E+00, 7.2797802612E+00, 6.3402688489E-02, 6.1560061666E-02, 3.8487193295E-01],
	[5.9150000000E+03, 2.9905089550E+00, 7.2777476175E+00, 6.3567864859E-02, 6.1716907580E-02, 3.8509345248E-01],
	[5.9200000000E+03, 2.9935323463E+00, 7.2757172582E+00, 6.3733331296E-02, 6.1874012576E-02, 3.8531483764E-01],
	[5.9250000000E+03, 2.9965562379E+00, 7.2736891787E+00, 6.3899088061E-02, 6.2031376827E-02, 3.8553608884E-01],
	[5.9300000000E+03, 2.9995806294E+00, 7.2716633745E+00, 6.4065135419E-02, 6.2189000505E-02, 3.8575720651E-01],
	[5.9350000000E+03, 3.0026055206E+00, 7.2696398413E+00, 6.4231473633E-02, 6.2346883783E-02, 3.8597819105E-01],
	[5.9400000000E+03, 3.0056309111E+00, 7.2676185744E+00, 6.4398102967E-02, 6.2505026832E-02, 3.8619904289E-01],
	[5.9450000000E+03, 3.0086568005E+00, 7.2655995695E+00, 6.4565023683E-02, 6.2663429826E-02, 3.8641976245E-01],
	[5.9500000000E+03, 3.0116831886E+00, 7.2635828222E+00, 6.4732236046E-02, 6.2822092935E-02, 3.8664035023E-01],
	[5.9550000000E+03, 3.0147100749E+00, 7.2615683279E+00, 6.4899740318E-02, 6.2981016332E-02, 3.8686080662E-01],
	[5.9600000000E+03, 3.0177374591E+00, 7.2595560825E+00, 6.5067536764E-02, 6.3140200188E-02, 3.8708113204E-01],
	[5.9650000000E+03, 3.0207748911E+00, 7.2575732196E+00, 6.5235625647E-02, 6.3299650933E-02, 3.8730132688E-01],
	[5.9700000000E+03, 3.0238132125E+00, 7.2555936400E+00, 6.5404007230E-02, 6.3459362780E-02, 3.8752139155E-01],
	[5.9750000000E+03, 3.0268520424E+00, 7.2536162569E+00, 6.5572681777E-02, 6.3619335653E-02, 3.8774132644E-01],
	[5.9800000000E+03, 3.0298913805E+00, 7.2516410660E+00, 6.5741649551E-02, 6.3779569722E-02, 3.8796113196E-01],
	[5.9850000000E+03, 3.0329312264E+00, 7.2496680632E+00, 6.5910910816E-02, 6.3940065159E-02, 3.8818080850E-01],
	[5.9900000000E+03, 3.0359715799E+00, 7.2476972441E+00, 6.6080465836E-02, 6.4100822134E-02, 3.8840035646E-01],
	[5.9950000000E+03, 3.0390124405E+00, 7.2457286045E+00, 6.6250314873E-02, 6.4261840818E-02, 3.8861977624E-01],
	[6.0000000000E+03, 3.0420538080E+00, 7.2437621401E+00, 6.6420458193E-02, 6.4423121381E-02, 3.8883906822E-01],
	[6.0050000000E+03, 3.0450956820E+00, 7.2417978468E+00, 6.6591868641E-02, 6.4585578855E-02, 3.8905823282E-01],
	[6.0100000000E+03, 3.0481380622E+00, 7.2398357204E+00, 6.6763578073E-02, 6.4748302261E-02, 3.8927727041E-01],
	[6.0150000000E+03, 3.0511809482E+00, 7.2378757567E+00, 6.6935586760E-02, 6.4911291773E-02, 3.8949618139E-01],
	[6.0200000000E+03, 3.0542243397E+00, 7.2359179514E+00, 6.7107894975E-02, 6.5074547568E-02, 3.8971496615E-01],
	[6.0250000000E+03, 3.0572682363E+00, 7.2339623005E+00, 6.7280502988E-02, 6.5238069821E-02, 3.8993362509E-01],
	[6.0300000000E+03, 3.0603126378E+00, 7.2320087998E+00, 6.7453411073E-02, 6.5401858706E-02, 3.9015215859E-01],
	[6.0350000000E+03, 3.0633575437E+00, 7.2300574450E+00, 6.7626619499E-02, 6.5565914398E-02, 3.9037056703E-01],
	[6.0400000000E+03, 3.0664029538E+00, 7.2281082322E+00, 6.7800128540E-02, 6.5730237073E-02, 3.9058885082E-01],
	[6.0450000000E+03, 3.0694488677E+00, 7.2261611571E+00, 6.7973938467E-02, 6.5894826905E-02, 3.9080701032E-01],
	[6.0500000000E+03, 3.0724952851E+00, 7.2242162157E+00, 6.8148049552E-02, 6.6059684068E-02, 3.9102504594E-01],
	[6.0550000000E+03, 3.0755422057E+00, 7.2222734039E+00, 6.8322462067E-02, 6.6224808736E-02, 3.9124295805E-01],
	[6.0600000000E+03, 3.0785969519E+00, 7.2203536629E+00, 6.8497176283E-02, 6.6390206261E-02, 3.9146074703E-01],
	[6.0650000000E+03, 3.0816543795E+00, 7.2184422152E+00, 6.8672192473E-02, 6.6555873219E-02, 3.9167841328E-01],
	[6.0700000000E+03, 3.0847123202E+00, 7.2165328480E+00, 6.8847510908E-02, 6.6721808258E-02, 3.9189595716E-01],
	[6.0750000000E+03, 3.0877707738E+00, 7.2146255573E+00, 6.9023131861E-02, 6.6888011552E-02, 3.9211337907E-01],
	[6.0800000000E+03, 3.0908297398E+00, 7.2127203393E+00, 6.9199055603E-02, 6.7054483275E-02, 3.9233067938E-01],
	[6.0850000000E+03, 3.0938892179E+00, 7.2108171899E+00, 6.9375282407E-02, 6.7221223598E-02, 3.9254785847E-01],
	[6.0900000000E+03, 3.0969492078E+00, 7.2089161053E+00, 6.9551812544E-02, 6.7388232697E-02, 3.9276491671E-01],
	[6.0950000000E+03, 3.1000097092E+00, 7.2070170814E+00, 6.9728646286E-02, 6.7555510742E-02, 3.9298185450E-01],
	[6.1000000000E+03, 3.1030707218E+00, 7.2051201143E+00, 6.9905783905E-02, 6.7723057909E-02, 3.9319867219E-01],
	[6.1050000000E+03, 3.1061322451E+00, 7.2032252002E+00, 7.0083225674E-02, 6.7890874368E-02, 3.9341537018E-01],
	[6.1100000000E+03, 3.1091942788E+00, 7.2013323352E+00, 7.0260971865E-02, 6.8058960292E-02, 3.9363194882E-01],
	[6.1150000000E+03, 3.1122568227E+00, 7.1994415153E+00, 7.0439022749E-02, 6.8227315854E-02, 3.9384840850E-01],
	[6.1200000000E+03, 3.1153198764E+00, 7.1975527367E+00, 7.0617378598E-02, 6.8395941225E-02, 3.9406474959E-01],
	[6.1250000000E+03, 3.1183834396E+00, 7.1956659955E+00, 7.0796039686E-02, 6.8564836578E-02, 3.9428097246E-01],
	[6.1300000000E+03, 3.1214475119E+00, 7.1937812878E+00, 7.0975006283E-02, 6.8734002084E-02, 3.9449707748E-01],
	[6.1350000000E+03, 3.1245120929E+00, 7.1918986098E+00, 7.1154278663E-02, 6.8903437914E-02, 3.9471306502E-01],
	[6.1400000000E+03, 3.1275771825E+00, 7.1900179577E+00, 7.1333857097E-02, 6.9073144240E-02, 3.9492893545E-01],
	[6.1450000000E+03, 3.1306427802E+00, 7.1881393276E+00, 7.1513741858E-02, 6.9243121232E-02, 3.9514468914E-01],
	[6.1500000000E+03, 3.1337088857E+00, 7.1862627158E+00, 7.1693933217E-02, 6.9413369063E-02, 3.9536032646E-01],
	[6.1550000000E+03, 3.1367779822E+00, 7.1843952285E+00, 7.1874431448E-02, 6.9583889790E-02, 3.9557584777E-01],
	[6.1600000000E+03, 3.1398542281E+00, 7.1825487271E+00, 7.2055236822E-02, 6.9754686779E-02, 3.9579125343E-01],
	[6.1650000000E+03, 3.1429309913E+00, 7.1807041978E+00, 7.2236349611E-02, 6.9925755173E-02, 3.9600654383E-01],
	[6.1700000000E+03, 3.1460082714E+00, 7.1788616369E+00, 7.2417770088E-02, 7.0097095141E-02, 3.9622171931E-01],
	[6.1750000000E+03, 3.1490860681E+00, 7.1770210409E+00, 7.2599498526E-02, 7.0268706854E-02, 3.9643678025E-01],
	[6.1800000000E+03, 3.1521643811E+00, 7.1751824060E+00, 7.2781535196E-02, 7.0440590482E-02, 3.9665172699E-01],
	[6.1850000000E+03, 3.1552432100E+00, 7.1733457285E+00, 7.2963880371E-02, 7.0612746195E-02, 3.9686655992E-01],
	[6.1900000000E+03, 3.1583225546E+00, 7.1715110047E+00, 7.3146534324E-02, 7.0785174162E-02, 3.9708127938E-01],
	[6.1950000000E+03, 3.1614024144E+00, 7.1696782311E+00, 7.3329497326E-02, 7.0957874553E-02, 3.9729588575E-01],
	[6.2000000000E+03, 3.1644827892E+00, 7.1678474039E+00, 7.3512769650E-02, 7.1130847537E-02, 3.9751037937E-01],
	[6.2050000000E+03, 3.1675636786E+00, 7.1660185195E+00, 7.3696351569E-02, 7.1304093283E-02, 3.9772476060E-01],
	[6.2100000000E+03, 3.1706450823E+00, 7.1641915744E+00, 7.3880243355E-02, 7.1477611960E-02, 3.9793902981E-01],
	[6.2150000000E+03, 3.1737269999E+00, 7.1623665648E+00, 7.4064445281E-02, 7.1651403737E-02, 3.9815318735E-01],
	[6.2200000000E+03, 3.1768094312E+00, 7.1605434872E+00, 7.4248957618E-02, 7.1825468782E-02, 3.9836723358E-01],
	[6.2250000000E+03, 3.1798923758E+00, 7.1587223380E+00, 7.4433780640E-02, 7.1999807263E-02, 3.9858116885E-01],
	[6.2300000000E+03, 3.1829758334E+00, 7.1569031136E+00, 7.4618914620E-02, 7.2174419349E-02, 3.9879499351E-01],
	[6.2350000000E+03, 3.1860598037E+00, 7.1550858104E+00, 7.4804359829E-02, 7.2349305208E-02, 3.9900870793E-01],
	[6.2400000000E+03, 3.1891442863E+00, 7.1532704249E+00, 7.4990116540E-02, 7.2524465006E-02, 3.9922231246E-01],
	[6.2450000000E+03, 3.1922292808E+00, 7.1514569535E+00, 7.5176185026E-02, 7.2699898913E-02, 3.9943580744E-01],
	[6.2500000000E+03, 3.1953147871E+00, 7.1496453926E+00, 7.5362565559E-02, 7.2875607094E-02, 3.9964919323E-01],
	[6.2550000000E+03, 3.1984048236E+00, 7.1478472610E+00, 7.5549258413E-02, 7.3051593017E-02, 3.9986247018E-01],
	[6.2600000000E+03, 3.2015001093E+00, 7.1460645731E+00, 7.5736263859E-02, 7.3227857476E-02, 4.0007563864E-01],
	[6.2650000000E+03, 3.2045959157E+00, 7.1442837526E+00, 7.5923582171E-02, 7.3404396766E-02, 4.0028869896E-01],
	[6.2700000000E+03, 3.2076922424E+00, 7.1425047960E+00, 7.6111213621E-02, 7.3581211055E-02, 4.0050165149E-01],
	[6.2750000000E+03, 3.2107890890E+00, 7.1407276999E+00, 7.6299158482E-02, 7.3758300510E-02, 4.0071449658E-01],
	[6.2800000000E+03, 3.2138864552E+00, 7.1389524608E+00, 7.6487417026E-02, 7.3935665297E-02, 4.0092723457E-01],
	[6.2850000000E+03, 3.2169843408E+00, 7.1371790755E+00, 7.6675989527E-02, 7.4113305582E-02, 4.0113986581E-01],
	[6.2900000000E+03, 3.2200827454E+00, 7.1354075403E+00, 7.6864876256E-02, 7.4291221532E-02, 4.0135239065E-01],
	[6.2950000000E+03, 3.2231816686E+00, 7.1336378521E+00, 7.7054077488E-02, 7.4469413312E-02, 4.0156480943E-01],
	[6.3000000000E+03, 3.2262811101E+00, 7.1318700072E+00, 7.7243593494E-02, 7.4647881087E-02, 4.0177712249E-01],
	[6.3050000000E+03, 3.2293810696E+00, 7.1301040025E+00, 7.7433424548E-02, 7.4826625024E-02, 4.0198933019E-01],
	[6.3100000000E+03, 3.2324815469E+00, 7.1283398345E+00, 7.7623570922E-02, 7.5005645287E-02, 4.0220143289E-01],
	[6.3150000000E+03, 3.2355825415E+00, 7.1265774998E+00, 7.7814032889E-02, 7.5184942041E-02, 4.0241343091E-01],
	[6.3200000000E+03, 3.2386840531E+00, 7.1248169951E+00, 7.8004810722E-02, 7.5364515452E-02, 4.0262532457E-01],
	[6.3250000000E+03, 3.2417860814E+00, 7.1230583170E+00, 7.8195904695E-02, 7.5544365684E-02, 4.0283711419E-01],
	[6.3300000000E+03, 3.2448886261E+00, 7.1213014623E+00, 7.8387315079E-02, 7.5724492902E-02, 4.0304880008E-01],
	[6.3350000000E+03, 3.2479916869E+00, 7.1195464275E+00, 7.8579042148E-02, 7.5904897269E-02, 4.0326038256E-01],
	[6.3400000000E+03, 3.2510952634E+00, 7.1177932094E+00, 7.8771086175E-02, 7.6085578951E-02, 4.0347186195E-01],
	[6.3450000000E+03, 3.2541993554E+00, 7.1160418046E+00, 7.8963447433E-02, 7.6266538110E-02, 4.0368323856E-01],
	[6.3500000000E+03, 3.2573039625E+00, 7.1142922099E+00, 7.9156126195E-02, 7.6447774910E-02, 4.0389451271E-01],
	[6.3550000000E+03, 3.2604118261E+00, 7.1125523109E+00, 7.9349122733E-02, 7.6629291946E-02, 4.0410568471E-01],
	[6.3600000000E+03, 3.2635258456E+00, 7.1108304091E+00, 7.9542437321E-02, 7.6811091982E-02, 4.0431675488E-01],
	[6.3650000000E+03, 3.2666403886E+00, 7.1091102769E+00, 7.9736070232E-02, 7.6993170208E-02, 4.0452772353E-01],
	[6.3700000000E+03, 3.2697554548E+00, 7.1073919110E+00, 7.9930021739E-02, 7.7175526785E-02, 4.0473859097E-01],
	[6.3750000000E+03, 3.2728710439E+00, 7.1056753082E+00, 8.0124292116E-02, 7.7358161877E-02, 4.0494935751E-01],
	[6.3800000000E+03, 3.2759871555E+00, 7.1039604654E+00, 8.0318881634E-02, 7.7541075646E-02, 4.0516002347E-01],
	[6.3850000000E+03, 3.2791037894E+00, 7.1022473793E+00, 8.0513790568E-02, 7.7724268256E-02, 4.0537058915E-01],
	[6.3900000000E+03, 3.2822209452E+00, 7.1005360468E+00, 8.0709019190E-02, 7.7907739867E-02, 4.0558105487E-01],
	[6.3950000000E+03, 3.2853386226E+00, 7.0988264648E+00, 8.0904567773E-02, 7.8091490644E-02, 4.0579142093E-01],
	[6.4000000000E+03, 3.2884568212E+00, 7.0971186300E+00, 8.1100436592E-02, 7.8275520747E-02, 4.0600168764E-01],
	[6.4050000000E+03, 3.2915755409E+00, 7.0954125393E+00, 8.1296625918E-02, 7.8459830338E-02, 4.0621185531E-01],
	[6.4100000000E+03, 3.2946947811E+00, 7.0937081896E+00, 8.1493136026E-02, 7.8644419580E-02, 4.0642192425E-01],
	[6.4150000000E+03, 3.2978145417E+00, 7.0920055777E+00, 8.1689967188E-02, 7.8829288632E-02, 4.0663189477E-01],
	[6.4200000000E+03, 3.3009348222E+00, 7.0903047005E+00, 8.1887119678E-02, 7.9014437657E-02, 4.0684176716E-01],
	[6.4250000000E+03, 3.3040556225E+00, 7.0886055550E+00, 8.2084593769E-02, 7.9199866815E-02, 4.0705154174E-01],
	[6.4300000000E+03, 3.3071769421E+00, 7.0869081379E+00, 8.2282389734E-02, 7.9385576267E-02, 4.0726121882E-01],
	[6.4350000000E+03, 3.3102987807E+00, 7.0852124463E+00, 8.2480507847E-02, 7.9571566174E-02, 4.0747079869E-01],
	[6.4400000000E+03, 3.3134211381E+00, 7.0835184769E+00, 8.2678948381E-02, 7.9757836696E-02, 4.0768028166E-01],
	[6.4450000000E+03, 3.3165440139E+00, 7.0818262267E+00, 8.2877711609E-02, 7.9944387993E-02, 4.0788966803E-01],
	[6.4500000000E+03, 3.3196674077E+00, 7.0801356927E+00, 8.3076797805E-02, 8.0131220225E-02, 4.0809895811E-01],
	[6.4550000000E+03, 3.3227913194E+00, 7.0784468718E+00, 8.3276207242E-02, 8.0318333552E-02, 4.0830815219E-01],
	[6.4600000000E+03, 3.3259227223E+00, 7.0767799219E+00, 8.3475940193E-02, 8.0505734828E-02, 4.0851725058E-01],
	[6.4650000000E+03, 3.3290556817E+00, 7.0751176325E+00, 8.3675996933E-02, 8.0693418563E-02, 4.0872625359E-01],
	[6.4700000000E+03, 3.3321891668E+00, 7.0734570183E+00, 8.3876377733E-02, 8.0881383929E-02, 4.0893516150E-01],
	[6.4750000000E+03, 3.3353231773E+00, 7.0717980762E+00, 8.4077082869E-02, 8.1069631085E-02, 4.0914397463E-01],
	[6.4800000000E+03, 3.3384577128E+00, 7.0701408033E+00, 8.4278112612E-02, 8.1258160191E-02, 4.0935269326E-01],
	[6.4850000000E+03, 3.3415927731E+00, 7.0684851966E+00, 8.4479467238E-02, 8.1446971406E-02, 4.0956131771E-01],
	[6.4900000000E+03, 3.3447283578E+00, 7.0668312531E+00, 8.4681147019E-02, 8.1636064887E-02, 4.0976984826E-01],
	[6.4950000000E+03, 3.3478644666E+00, 7.0651789700E+00, 8.4883152229E-02, 8.1825440794E-02, 4.0997828521E-01],
	[6.5000000000E+03, 3.3510010991E+00, 7.0635283441E+00, 8.5085483141E-02, 8.2015099285E-02, 4.1018662887E-01],
	[6.5050000000E+03, 3.3541382552E+00, 7.0618793727E+00, 8.5288140029E-02, 8.2205040517E-02, 4.1039487952E-01],
	[6.5100000000E+03, 3.3572759344E+00, 7.0602320528E+00, 8.5491123167E-02, 8.2395264649E-02, 4.1060303746E-01],
	[6.5150000000E+03, 3.3604141364E+00, 7.0585863814E+00, 8.5694432828E-02, 8.2585771837E-02, 4.1081110300E-01],
	[6.5200000000E+03, 3.3635528610E+00, 7.0569423557E+00, 8.5898069285E-02, 8.2776562239E-02, 4.1101907642E-01],
	[6.5250000000E+03, 3.3666921078E+00, 7.0552999727E+00, 8.6102032814E-02, 8.2967636013E-02, 4.1122695802E-01],
	[6.5300000000E+03, 3.3698318765E+00, 7.0536592296E+00, 8.6306323686E-02, 8.3158993316E-02, 4.1143474808E-01],
	[6.5350000000E+03, 3.3729721668E+00, 7.0520201234E+00, 8.6510942177E-02, 8.3350634303E-02, 4.1164244692E-01],
	[6.5400000000E+03, 3.3761129783E+00, 7.0503826513E+00, 8.6715888558E-02, 8.3542559132E-02, 4.1185005481E-01],
	[6.5450000000E+03, 3.3792543108E+00, 7.0487468104E+00, 8.6921163106E-02, 8.3734767959E-02, 4.1205757206E-01],
	[6.5500000000E+03, 3.3823961640E+00, 7.0471125978E+00, 8.7126766092E-02, 8.3927260940E-02, 4.1226499894E-01],
	[6.5550000000E+03, 3.3855385375E+00, 7.0454800107E+00, 8.7332697791E-02, 8.4120038232E-02, 4.1247233576E-01],
	[6.5600000000E+03, 3.3886820851E+00, 7.0438509532E+00, 8.7538958476E-02, 8.4313100667E-02, 4.1267958281E-01],
	[6.5650000000E+03, 3.3918331276E+00, 7.0422438234E+00, 8.7745548422E-02, 8.4506454982E-02, 4.1288674036E-01],
	[6.5700000000E+03, 3.3949846979E+00, 7.0406382835E+00, 8.7952467902E-02, 8.4700094134E-02, 4.1309380873E-01],
	[6.5750000000E+03, 3.3981367956E+00, 7.0390343306E+00, 8.8159717190E-02, 8.4894018276E-02, 4.1330078818E-01],
	[6.5800000000E+03, 3.4012894204E+00, 7.0374319620E+00, 8.8367296559E-02, 8.5088227565E-02, 4.1350767902E-01],
	[6.5850000000E+03, 3.4044425720E+00, 7.0358311749E+00, 8.8575206285E-02, 8.5282722156E-02, 4.1371448153E-01],
	[6.5900000000E+03, 3.4075962502E+00, 7.0342319664E+00, 8.8783446640E-02, 8.5477502203E-02, 4.1392119599E-01],
	[6.5950000000E+03, 3.4107504545E+00, 7.0326343340E+00, 8.8992017899E-02, 8.5672567860E-02, 4.1412782271E-01],
	[6.6000000000E+03, 3.4139051847E+00, 7.0310382748E+00, 8.9200920335E-02, 8.5867919283E-02, 4.1433436195E-01],
	[6.6050000000E+03, 3.4170604405E+00, 7.0294437861E+00, 8.9410154222E-02, 8.6063556624E-02, 4.1454081401E-01],
	[6.6100000000E+03, 3.4202162216E+00, 7.0278508652E+00, 8.9619719835E-02, 8.6259480039E-02, 4.1474717918E-01],
	[6.6150000000E+03, 3.4233725276E+00, 7.0262595093E+00, 8.9829617447E-02, 8.6455689680E-02, 4.1495345774E-01],
	[6.6200000000E+03, 3.4265293582E+00, 7.0246697157E+00, 9.0039847332E-02, 8.6652185701E-02, 4.1515964997E-01],
	[6.6250000000E+03, 3.4296867132E+00, 7.0230814817E+00, 9.0250409765E-02, 8.6848968256E-02, 4.1536575616E-01],
	[6.6300000000E+03, 3.4328445922E+00, 7.0214948046E+00, 9.0461305019E-02, 8.7046037497E-02, 4.1557177659E-01],
	[6.6350000000E+03, 3.4360029949E+00, 7.0199096817E+00, 9.0672533368E-02, 8.7243393578E-02, 4.1577771155E-01],
	[6.6400000000E+03, 3.4391619210E+00, 7.0183261103E+00, 9.0884095087E-02, 8.7441036651E-02, 4.1598356132E-01],
	[6.6450000000E+03, 3.4423213702E+00, 7.0167440878E+00, 9.1095990450E-02, 8.7638966868E-02, 4.1618932618E-01],
	[6.6500000000E+03, 3.4454813422E+00, 7.0151636114E+00, 9.1308219730E-02, 8.7837184382E-02, 4.1639500640E-01],
	[6.6550000000E+03, 3.4486418367E+00, 7.0135846784E+00, 9.1520783202E-02, 8.8035689345E-02, 4.1660060225E-01],
	[6.6600000000E+03, 3.4518028533E+00, 7.0120072863E+00, 9.1733681140E-02, 8.8234481908E-02, 4.1680611398E-01],
	[6.6650000000E+03, 3.4549643919E+00, 7.0104314323E+00, 9.1946913818E-02, 8.8433562223E-02, 4.1701154183E-01],
	[6.6700000000E+03, 3.4581334528E+00, 7.0088777084E+00, 9.2160481510E-02, 8.8632938335E-02, 4.1721688606E-01],
	[6.6750000000E+03, 3.4613032910E+00, 7.0073262227E+00, 9.2374384491E-02, 8.8832602840E-02, 4.1742214691E-01],
	[6.6800000000E+03, 3.4644736580E+00, 7.0057762417E+00, 9.2588623034E-02, 8.9032555611E-02, 4.1762732464E-01],
	[6.6850000000E+03, 3.4676445534E+00, 7.0042277629E+00, 9.2803197414E-02, 8.9232796799E-02, 4.1783241949E-01],
	[6.6900000000E+03, 3.4708159770E+00, 7.0026807837E+00, 9.3018107906E-02, 8.9433326556E-02, 4.1803743172E-01],
	[6.6950000000E+03, 3.4739879285E+00, 7.0011353016E+00, 9.3233354783E-02, 8.9634145031E-02, 4.1824236158E-01],
	[6.7000000000E+03, 3.4771604076E+00, 6.9995913139E+00, 9.3448938319E-02, 8.9835252375E-02, 4.1844720930E-01],
	[6.7050000000E+03, 3.4803334139E+00, 6.9980488182E+00, 9.3664858790E-02, 9.0036648738E-02, 4.1865197515E-01],
	[6.7100000000E+03, 3.4835069472E+00, 6.9965078119E+00, 9.3881116469E-02, 9.0238334270E-02, 4.1885665936E-01],
	[6.7150000000E+03, 3.4866810071E+00, 6.9949682923E+00, 9.4097711631E-02, 9.0440309121E-02, 4.1906126219E-01],
	[6.7200000000E+03, 3.4898555934E+00, 6.9934302571E+00, 9.4314644549E-02, 9.0642573441E-02, 4.1926578388E-01],
	[6.7250000000E+03, 3.4930307057E+00, 6.9918937035E+00, 9.4531915499E-02, 9.0845127378E-02, 4.1947022467E-01],
	[6.7300000000E+03, 3.4962063437E+00, 6.9903586293E+00, 9.4749524755E-02, 9.1047971082E-02, 4.1967458482E-01],
	[6.7350000000E+03, 3.4993825072E+00, 6.9888250317E+00, 9.4967472591E-02, 9.1251104702E-02, 4.1987886457E-01],
	[6.7400000000E+03, 3.5025591958E+00, 6.9872929083E+00, 9.5185759282E-02, 9.1454528385E-02, 4.2008306417E-01],
	[6.7450000000E+03, 3.5057364092E+00, 6.9857622565E+00, 9.5404385102E-02, 9.1658242282E-02, 4.2028718385E-01],
	[6.7500000000E+03, 3.5089141471E+00, 6.9842330740E+00, 9.5623350325E-02, 9.1862246540E-02, 4.2049122387E-01],
	[6.7550000000E+03, 3.5120924092E+00, 6.9827053581E+00, 9.5842655227E-02, 9.2066541306E-02, 4.2069518447E-01],
	[6.7600000000E+03, 3.5152711953E+00, 6.9811791064E+00, 9.6062300081E-02, 9.2271126730E-02, 4.2089906588E-01],
	[6.7650000000E+03, 3.5184505050E+00, 6.9796543164E+00, 9.6282285162E-02, 9.2476002958E-02, 4.2110286837E-01],
	[6.7700000000E+03, 3.5216303380E+00, 6.9781309856E+00, 9.6502610745E-02, 9.2681170137E-02, 4.2130659216E-01],
	[6.7750000000E+03, 3.5248141661E+00, 6.9766194616E+00, 9.6723277103E-02, 9.2886632662E-02, 4.2151023750E-01],
	[6.7800000000E+03, 3.5280019160E+00, 6.9751194900E+00, 9.6944284513E-02, 9.3092390628E-02, 4.2171380464E-01],
	[6.7850000000E+03, 3.5311901957E+00, 6.9736209463E+00, 9.7165633248E-02, 9.3298440049E-02, 4.2191729381E-01],
	[6.7900000000E+03, 3.5343790048E+00, 6.9721238281E+00, 9.7387323582E-02, 9.3504781070E-02, 4.2212070525E-01],
	[6.7950000000E+03, 3.5375683431E+00, 6.9706281329E+00, 9.7609355792E-02, 9.3711413838E-02, 4.2232403922E-01],
	[6.8000000000E+03, 3.5407582102E+00, 6.9691338585E+00, 9.7831730150E-02, 9.3918338501E-02, 4.2252729594E-01],
	[6.8050000000E+03, 3.5439486059E+00, 6.9676410023E+00, 9.8054446932E-02, 9.4125555203E-02, 4.2273047566E-01],
	[6.8100000000E+03, 3.5471395298E+00, 6.9661495621E+00, 9.8277506413E-02, 9.4333064091E-02, 4.2293357862E-01],
	[6.8150000000E+03, 3.5503309816E+00, 6.9646595354E+00, 9.8500908867E-02, 9.4540865310E-02, 4.2313660506E-01],
	[6.8200000000E+03, 3.5535229611E+00, 6.9631709198E+00, 9.8724654569E-02, 9.4748959006E-02, 4.2333955522E-01],
	[6.8250000000E+03, 3.5567154679E+00, 6.9616837130E+00, 9.8948743794E-02, 9.4957345325E-02, 4.2354242934E-01],
	[6.8300000000E+03, 3.5599085017E+00, 6.9601979127E+00, 9.9173176815E-02, 9.5166024410E-02, 4.2374522765E-01],
	[6.8350000000E+03, 3.5631020623E+00, 6.9587135164E+00, 9.9397953910E-02, 9.5374996408E-02, 4.2394795040E-01],
	[6.8400000000E+03, 3.5662961494E+00, 6.9572305218E+00, 9.9623075351E-02, 9.5584261463E-02, 4.2415059782E-01],
	[6.8450000000E+03, 3.5694907626E+00, 6.9557489266E+00, 9.9848541413E-02, 9.5793819718E-02, 4.2435317015E-01],
	[6.8500000000E+03, 3.5726859016E+00, 6.9542687284E+00, 1.0007435237E-01, 9.6003671319E-02, 4.2455566763E-01],
	[6.8550000000E+03, 3.5758815662E+00, 6.9527899249E+00, 1.0030050850E-01, 9.6213816408E-02, 4.2475809050E-01],
	[6.8600000000E+03, 3.5790777560E+00, 6.9513125138E+00, 1.0052701008E-01, 9.6424255131E-02, 4.2496043899E-01],
	[6.8650000000E+03, 3.5822744708E+00, 6.9498364927E+00, 1.0075385738E-01, 9.6634987630E-02, 4.2516271333E-01],
	[6.8700000000E+03, 3.5854717102E+00, 6.9483618593E+00, 1.0098105067E-01, 9.6846014049E-02, 4.2536491377E-01],
	[6.8750000000E+03, 3.5886694741E+00, 6.9468886113E+00, 1.0120859024E-01, 9.7057334531E-02, 4.2556704054E-01],
	[6.8800000000E+03, 3.5918677619E+00, 6.9454167464E+00, 1.0143647635E-01, 9.7268949218E-02, 4.2576909388E-01],
	[6.8850000000E+03, 3.5950711124E+00, 6.9439600052E+00, 1.0166470928E-01, 9.7480864299E-02, 4.2597107402E-01],
	[6.8900000000E+03, 3.5982769356E+00, 6.9425105075E+00, 1.0189328931E-01, 9.7693076511E-02, 4.2617298119E-01],
	[6.8950000000E+03, 3.6014832887E+00, 6.9410623635E+00, 1.0212221671E-01, 9.7905583419E-02, 4.2637481564E-01],
	[6.9000000000E+03, 3.6046901716E+00, 6.9396155711E+00, 1.0235149175E-01, 9.8118385164E-02, 4.2657657759E-01],
	[6.9050000000E+03, 3.6078975839E+00, 6.9381701279E+00, 1.0258111471E-01, 9.8331481889E-02, 4.2677826727E-01],
	[6.9100000000E+03, 3.6111055254E+00, 6.9367260318E+00, 1.0281108587E-01, 9.8544873735E-02, 4.2697988493E-01],
	[6.9150000000E+03, 3.6143139957E+00, 6.9352832804E+00, 1.0304140551E-01, 9.8758560843E-02, 4.2718143080E-01],
	[6.9200000000E+03, 3.6175229945E+00, 6.9338418716E+00, 1.0327207388E-01, 9.8972543356E-02, 4.2738290510E-01],
	[6.9250000000E+03, 3.6207325215E+00, 6.9324018032E+00, 1.0350309128E-01, 9.9186821413E-02, 4.2758430808E-01],
	[6.9300000000E+03, 3.6239425766E+00, 6.9309630729E+00, 1.0373445797E-01, 9.9401395157E-02, 4.2778563996E-01],
	[6.9350000000E+03, 3.6271531592E+00, 6.9295256786E+00, 1.0396617424E-01, 9.9616264728E-02, 4.2798690097E-01],
	[6.9400000000E+03, 3.6303642693E+00, 6.9280896180E+00, 1.0419824035E-01, 9.9831430266E-02, 4.2818809135E-01],
	[6.9450000000E+03, 3.6335759064E+00, 6.9266548889E+00, 1.0443065658E-01, 1.0004689191E-01, 4.2838921134E-01],
	[6.9500000000E+03, 3.6367880703E+00, 6.9252214892E+00, 1.0466342321E-01, 1.0026264980E-01, 4.2859026115E-01],
	[6.9550000000E+03, 3.6400007607E+00, 6.9237894167E+00, 1.0489654051E-01, 1.0047870409E-01, 4.2879124102E-01],
	[6.9600000000E+03, 3.6432139772E+00, 6.9223586691E+00, 1.0513000876E-01, 1.0069505489E-01, 4.2899215118E-01],
	[6.9650000000E+03, 3.6464277197E+00, 6.9209292443E+00, 1.0536382823E-01, 1.0091170237E-01, 4.2919299187E-01],
	[6.9700000000E+03, 3.6496419878E+00, 6.9195011402E+00, 1.0559799920E-01, 1.0112864664E-01, 4.2939376330E-01],
	[6.9750000000E+03, 3.6528567811E+00, 6.9180743545E+00, 1.0583252194E-01, 1.0134588787E-01, 4.2959446570E-01],
	[6.9800000000E+03, 3.6560720996E+00, 6.9166488851E+00, 1.0606739673E-01, 1.0156342617E-01, 4.2979509924E-01],
	[6.9850000000E+03, 3.6592879427E+00, 6.9152247299E+00, 1.0630262384E-01, 1.0178126170E-01, 4.2999566414E-01],
	[6.9900000000E+03, 3.6625043103E+00, 6.9138018866E+00, 1.0653820355E-01, 1.0199939459E-01, 4.3019616060E-01],
	[6.9950000000E+03, 3.6657245301E+00, 6.9123905867E+00, 1.0677413614E-01, 1.0221782980E-01, 4.3039658880E-01],
	[7.0000000000E+03, 3.6689480723E+00, 6.9109891685E+00, 1.0701042187E-01, 1.0243656674E-01, 4.3059694894E-01],
	[7.0050000000E+03, 3.6721721444E+00, 6.9095890348E+00, 1.0724894899E-01, 1.0265733129E-01, 4.3079724123E-01],
	[7.0100000000E+03, 3.6753967462E+00, 6.9081901834E+00, 1.0748783687E-01, 1.0287839977E-01, 4.3099746585E-01],
	[7.0150000000E+03, 3.6786218773E+00, 6.9067926123E+00, 1.0772708581E-01, 1.0309977234E-01, 4.3119762301E-01],
	[7.0200000000E+03, 3.6818475376E+00, 6.9053963194E+00, 1.0796669609E-01, 1.0332144914E-01, 4.3139771290E-01],
	[7.0250000000E+03, 3.6850737266E+00, 6.9040013027E+00, 1.0820666800E-01, 1.0354343031E-01, 4.3159773571E-01],
	[7.0300000000E+03, 3.6883004441E+00, 6.9026075600E+00, 1.0844700183E-01, 1.0376571600E-01, 4.3179769165E-01],
	[7.0350000000E+03, 3.6915276899E+00, 6.9012150894E+00, 1.0868769786E-01, 1.0398830635E-01, 4.3199758091E-01],
	[7.0400000000E+03, 3.6947554635E+00, 6.8998238886E+00, 1.0892875638E-01, 1.0421120151E-01, 4.3219740368E-01],
	[7.0450000000E+03, 3.6979837649E+00, 6.8984339557E+00, 1.0917017769E-01, 1.0443440161E-01, 4.3239716016E-01],
	[7.0500000000E+03, 3.7012125935E+00, 6.8970452886E+00, 1.0941196206E-01, 1.0465790681E-01, 4.3259685053E-01],
	[7.0550000000E+03, 3.7044419492E+00, 6.8956578853E+00, 1.0965410979E-01, 1.0488171725E-01, 4.3279647501E-01],
	[7.0600000000E+03, 3.7076718317E+00, 6.8942717438E+00, 1.0989662116E-01, 1.0510583306E-01, 4.3299603378E-01],
	[7.0650000000E+03, 3.7109022407E+00, 6.8928868619E+00, 1.1013949646E-01, 1.0533025439E-01, 4.3319552703E-01],
	[7.0700000000E+03, 3.7141331758E+00, 6.8915032376E+00, 1.1038273598E-01, 1.0555498138E-01, 4.3339495497E-01],
	[7.0750000000E+03, 3.7173646369E+00, 6.8901208689E+00, 1.1062634000E-01, 1.0578001418E-01, 4.3359431777E-01],
	[7.0800000000E+03, 3.7205966236E+00, 6.8887397539E+00, 1.1087030882E-01, 1.0600535293E-01, 4.3379361565E-01],
	[7.0850000000E+03, 3.7238291356E+00, 6.8873598904E+00, 1.1111464272E-01, 1.0623099776E-01, 4.3399284878E-01],
	[7.0900000000E+03, 3.7270621727E+00, 6.8859812765E+00, 1.1135934199E-01, 1.0645694882E-01, 4.3419201736E-01],
	[7.0950000000E+03, 3.7302957346E+00, 6.8846039101E+00, 1.1160440691E-01, 1.0668320626E-01, 4.3439112159E-01],
	[7.1000000000E+03, 3.7335298209E+00, 6.8832277892E+00, 1.1184983778E-01, 1.0690977020E-01, 4.3459016166E-01],
	[7.1050000000E+03, 3.7367646105E+00, 6.8818534615E+00, 1.1209563488E-01, 1.0713664107E-01, 4.3478913776E-01],
	[7.1100000000E+03, 3.7400056378E+00, 6.8804978893E+00, 1.1234179850E-01, 1.0736382772E-01, 4.3498805008E-01],
	[7.1150000000E+03, 3.7432471947E+00, 6.8791435368E+00, 1.1258832893E-01, 1.0759132135E-01, 4.3518689882E-01],
	[7.1200000000E+03, 3.7464892811E+00, 6.8777904021E+00, 1.1283522645E-01, 1.0781912213E-01, 4.3538568416E-01],
	[7.1250000000E+03, 3.7497318966E+00, 6.8764384831E+00, 1.1308249136E-01, 1.0804723019E-01, 4.3558440630E-01],
	[7.1300000000E+03, 3.7529750409E+00, 6.8750877780E+00, 1.1333012394E-01, 1.0827564566E-01, 4.3578306543E-01],
	[7.1350000000E+03, 3.7562187138E+00, 6.8737382848E+00, 1.1357812448E-01, 1.0850436868E-01, 4.3598166174E-01],
	[7.1400000000E+03, 3.7594629150E+00, 6.8723900015E+00, 1.1382649327E-01, 1.0873339941E-01, 4.3618019542E-01],
	[7.1450000000E+03, 3.7627076441E+00, 6.8710429263E+00, 1.1407523059E-01, 1.0896273797E-01, 4.3637866666E-01],
	[7.1500000000E+03, 3.7659529009E+00, 6.8696970572E+00, 1.1432433674E-01, 1.0919238450E-01, 4.3657707566E-01],
	[7.1550000000E+03, 3.7691986851E+00, 6.8683523923E+00, 1.1457381199E-01, 1.0942233914E-01, 4.3677542259E-01],
	[7.1600000000E+03, 3.7724449965E+00, 6.8670089296E+00, 1.1482365665E-01, 1.0965260203E-01, 4.3697370766E-01],
	[7.1650000000E+03, 3.7756918347E+00, 6.8656666673E+00, 1.1507387100E-01, 1.0988317332E-01, 4.3717193106E-01],
	[7.1700000000E+03, 3.7789391995E+00, 6.8643256034E+00, 1.1532445532E-01, 1.1011405312E-01, 4.3737009296E-01],
	[7.1750000000E+03, 3.7821870906E+00, 6.8629857361E+00, 1.1557540990E-01, 1.1034524160E-01, 4.3756819357E-01],
	[7.1800000000E+03, 3.7854355076E+00, 6.8616470634E+00, 1.1582673504E-01, 1.1057673887E-01, 4.3776623307E-01],
	[7.1850000000E+03, 3.7886844504E+00, 6.8603095835E+00, 1.1607843102E-01, 1.1080854508E-01, 4.3796421165E-01],
	[7.1900000000E+03, 3.7919339186E+00, 6.8589732944E+00, 1.1633049813E-01, 1.1104066036E-01, 4.3816212950E-01],
	[7.1950000000E+03, 3.7951839120E+00, 6.8576381943E+00, 1.1658293665E-01, 1.1127308486E-01, 4.3835998680E-01],
	[7.2000000000E+03, 3.7984344303E+00, 6.8563042812E+00, 1.1683574688E-01, 1.1150581870E-01, 4.3855778376E-01],
	[7.2050000000E+03, 3.8016854732E+00, 6.8549715534E+00, 1.1708892910E-01, 1.1173886203E-01, 4.3875552055E-01],
	[7.2100000000E+03, 3.8049370404E+00, 6.8536400089E+00, 1.1734248361E-01, 1.1197221498E-01, 4.3895319736E-01],
	[7.2150000000E+03, 3.8081891316E+00, 6.8523096459E+00, 1.1759641068E-01, 1.1220587768E-01, 4.3915081438E-01],
	[7.2200000000E+03, 3.8114426284E+00, 6.8509831467E+00, 1.1785071061E-01, 1.1243985177E-01, 4.3934837181E-01],
	[7.2250000000E+03, 3.8147014692E+00, 6.8496724789E+00, 1.1810538369E-01, 1.1267414406E-01, 4.3954586982E-01],
	[7.2300000000E+03, 3.8179608390E+00, 6.8483629682E+00, 1.1836043021E-01, 1.1290874657E-01, 4.3974330860E-01],
	[7.2350000000E+03, 3.8212207374E+00, 6.8470546129E+00, 1.1861585045E-01, 1.1314365946E-01, 4.3994068835E-01],
	[7.2400000000E+03, 3.8244811644E+00, 6.8457474112E+00, 1.1887164470E-01, 1.1337888283E-01, 4.4013800925E-01],
	[7.2450000000E+03, 3.8277421194E+00, 6.8444413613E+00, 1.1912781325E-01, 1.1361441684E-01, 4.4033527148E-01],
	[7.2500000000E+03, 3.8310036024E+00, 6.8431364613E+00, 1.1938435639E-01, 1.1385026162E-01, 4.4053247524E-01],
	[7.2550000000E+03, 3.8342656129E+00, 6.8418327094E+00, 1.1964127440E-01, 1.1408641730E-01, 4.4072962070E-01],
	[7.2600000000E+03, 3.8375281508E+00, 6.8405301039E+00, 1.1989856759E-01, 1.1432288401E-01, 4.4092670807E-01],
	[7.2650000000E+03, 3.8407912157E+00, 6.8392286430E+00, 1.2015623622E-01, 1.1455966189E-01, 4.4112373751E-01],
	[7.2700000000E+03, 3.8440548074E+00, 6.8379283247E+00, 1.2041428061E-01, 1.1479675106E-01, 4.4132070922E-01],
	[7.2750000000E+03, 3.8473189255E+00, 6.8366291475E+00, 1.2067270102E-01, 1.1503415168E-01, 4.4151762339E-01],
	[7.2800000000E+03, 3.8505835699E+00, 6.8353311094E+00, 1.2093149775E-01, 1.1527186385E-01, 4.4171448019E-01],
	[7.2850000000E+03, 3.8538487402E+00, 6.8340342088E+00, 1.2119067109E-01, 1.1550988773E-01, 4.4191127979E-01],
	[7.2900000000E+03, 3.8571144362E+00, 6.8327384438E+00, 1.2145022133E-01, 1.1574822344E-01, 4.4210802233E-01],
	[7.2950000000E+03, 3.8603806575E+00, 6.8314438126E+00, 1.2171014876E-01, 1.1598687111E-01, 4.4230470798E-01],
	[7.3000000000E+03, 3.8636474039E+00, 6.8301503135E+00, 1.2197045366E-01, 1.1622583088E-01, 4.4250133689E-01],
	[7.3050000000E+03, 3.8669146752E+00, 6.8288579447E+00, 1.2223113632E-01, 1.1646510287E-01, 4.4269790921E-01],
	[7.3100000000E+03, 3.8701824710E+00, 6.8275667045E+00, 1.2249219704E-01, 1.1670468722E-01, 4.4289442509E-01],
	[7.3150000000E+03, 3.8734507911E+00, 6.8262765911E+00, 1.2275363610E-01, 1.1694458406E-01, 4.4309088470E-01],
	[7.3200000000E+03, 3.8767196352E+00, 6.8249876028E+00, 1.2301545379E-01, 1.1718479352E-01, 4.4328728818E-01],
	[7.3250000000E+03, 3.8799890030E+00, 6.8236997377E+00, 1.2327765039E-01, 1.1742531573E-01, 4.4348363569E-01],
	[7.3300000000E+03, 3.8832588943E+00, 6.8224129942E+00, 1.2354022621E-01, 1.1766615082E-01, 4.4367992738E-01],
	[7.3350000000E+03, 3.8865293088E+00, 6.8211273705E+00, 1.2380318152E-01, 1.1790729891E-01, 4.4387616341E-01],
	[7.3400000000E+03, 3.8898052633E+00, 6.8198580212E+00, 1.2406651662E-01, 1.1814876933E-01, 4.4407234394E-01],
	[7.3450000000E+03, 3.8930822372E+00, 6.8185912561E+00, 1.2433023179E-01, 1.1839055398E-01, 4.4426846910E-01],
	[7.3500000000E+03, 3.8963597390E+00, 6.8173255881E+00, 1.2459432732E-01, 1.1863265211E-01, 4.4446453906E-01],
	[7.3550000000E+03, 3.8996377684E+00, 6.8160610155E+00, 1.2485880351E-01, 1.1887506382E-01, 4.4466055397E-01],
	[7.3600000000E+03, 3.9029163252E+00, 6.8147975365E+00, 1.2512366064E-01, 1.1911778927E-01, 4.4485651399E-01],
	[7.3650000000E+03, 3.9061954090E+00, 6.8135351497E+00, 1.2538889899E-01, 1.1936082857E-01, 4.4505241926E-01],
	[7.3700000000E+03, 3.9094750196E+00, 6.8122738531E+00, 1.2565451887E-01, 1.1960418186E-01, 4.4524826995E-01],
	[7.3750000000E+03, 3.9127551567E+00, 6.8110136452E+00, 1.2592052056E-01, 1.1984784925E-01, 4.4544406619E-01],
	[7.3800000000E+03, 3.9160358200E+00, 6.8097545243E+00, 1.2618690434E-01, 1.2009183089E-01, 4.4563980815E-01],
	[7.3850000000E+03, 3.9193170093E+00, 6.8084964886E+00, 1.2645367051E-01, 1.2033612690E-01, 4.4583549598E-01],
	[7.3900000000E+03, 3.9225987243E+00, 6.8072395367E+00, 1.2672081935E-01, 1.2058073740E-01, 4.4603112983E-01],
	[7.3950000000E+03, 3.9258809648E+00, 6.8059836666E+00, 1.2698835116E-01, 1.2082566253E-01, 4.4622670985E-01],
	[7.4000000000E+03, 3.9291637304E+00, 6.8047288769E+00, 1.2725626623E-01, 1.2107090241E-01, 4.4642223619E-01],
	[7.4050000000E+03, 3.9324470208E+00, 6.8034751659E+00, 1.2752456483E-01, 1.2131645717E-01, 4.4661770902E-01],
	[7.4100000000E+03, 3.9357308359E+00, 6.8022225318E+00, 1.2779324727E-01, 1.2156232693E-01, 4.4681312847E-01],
	[7.4150000000E+03, 3.9390151754E+00, 6.8009709731E+00, 1.2806231383E-01, 1.2180851182E-01, 4.4700849470E-01],
	[7.4200000000E+03, 3.9423000389E+00, 6.7997204881E+00, 1.2833176480E-01, 1.2205501197E-01, 4.4720380786E-01],
	[7.4250000000E+03, 3.9455854262E+00, 6.7984710751E+00, 1.2860160047E-01, 1.2230182750E-01, 4.4739906811E-01],
	[7.4300000000E+03, 3.9488713370E+00, 6.7972227326E+00, 1.2887182113E-01, 1.2254895854E-01, 4.4759427560E-01],
	[7.4350000000E+03, 3.9521577712E+00, 6.7959754588E+00, 1.2914242707E-01, 1.2279640522E-01, 4.4778943047E-01],
	[7.4400000000E+03, 3.9554447283E+00, 6.7947292522E+00, 1.2941341858E-01, 1.2304416765E-01, 4.4798453288E-01],
	[7.4450000000E+03, 3.9587322081E+00, 6.7934841111E+00, 1.2968479594E-01, 1.2329224597E-01, 4.4817958298E-01],
	[7.4500000000E+03, 3.9620202104E+00, 6.7922400338E+00, 1.2995655945E-01, 1.2354064029E-01, 4.4837458092E-01],
	[7.4550000000E+03, 3.9653102898E+00, 6.7910016917E+00, 1.3022870940E-01, 1.2378935382E-01, 4.4856952685E-01],
	[7.4600000000E+03, 3.9686046527E+00, 6.7897756942E+00, 1.3050124607E-01, 1.2403839106E-01, 4.4876442092E-01],
	[7.4650000000E+03, 3.9718995426E+00, 6.7885507392E+00, 1.3077416975E-01, 1.2428774476E-01, 4.4895926329E-01],
	[7.4700000000E+03, 3.9751949591E+00, 6.7873268251E+00, 1.3104748074E-01, 1.2453741503E-01, 4.4915405410E-01],
	[7.4750000000E+03, 3.9784909020E+00, 6.7861039505E+00, 1.3132117933E-01, 1.2478740201E-01, 4.4934879351E-01],
	[7.4800000000E+03, 3.9817873710E+00, 6.7848821136E+00, 1.3159526579E-01, 1.2503770580E-01, 4.4954348166E-01],
	[7.4850000000E+03, 3.9850843658E+00, 6.7836613130E+00, 1.3186974043E-01, 1.2528832654E-01, 4.4973811871E-01],
	[7.4900000000E+03, 3.9883818862E+00, 6.7824415471E+00, 1.3214460353E-01, 1.2553926435E-01, 4.4993270481E-01],
	[7.4950000000E+03, 3.9916799319E+00, 6.7812228142E+00, 1.3241985539E-01, 1.2579051935E-01, 4.5012724010E-01],
	[7.5000000000E+03, 3.9949785027E+00, 6.7800051129E+00, 1.3269549628E-01, 1.2604209167E-01, 4.5032172474E-01],
	[7.5050000000E+03, 3.9982775982E+00, 6.7787884416E+00, 1.3297152651E-01, 1.2629398142E-01, 4.5051615887E-01],
	[7.5100000000E+03, 4.0015772182E+00, 6.7775727987E+00, 1.3324794636E-01, 1.2654618873E-01, 4.5071054265E-01],
	[7.5150000000E+03, 4.0048773625E+00, 6.7763581826E+00, 1.3352475612E-01, 1.2679871372E-01, 4.5090487623E-01],
	[7.5200000000E+03, 4.0081780308E+00, 6.7751445919E+00, 1.3380195607E-01, 1.2705155651E-01, 4.5109915975E-01],
	[7.5250000000E+03, 4.0114792227E+00, 6.7739320249E+00, 1.3407954652E-01, 1.2730471722E-01, 4.5129339337E-01],
	[7.5300000000E+03, 4.0147809381E+00, 6.7727204802E+00, 1.3435752775E-01, 1.2755819598E-01, 4.5148757723E-01],
	[7.5350000000E+03, 4.0180831767E+00, 6.7715099561E+00, 1.3463590004E-01, 1.2781199290E-01, 4.5168171149E-01],
	[7.5400000000E+03, 4.0213859382E+00, 6.7703004512E+00, 1.3491466370E-01, 1.2806610810E-01, 4.5187579629E-01],
	[7.5450000000E+03, 4.0246892223E+00, 6.7690919639E+00, 1.3519381900E-01, 1.2832054171E-01, 4.5206983178E-01],
	[7.5500000000E+03, 4.0279930289E+00, 6.7678844927E+00, 1.3547336625E-01, 1.2857529384E-01, 4.5226381812E-01],
	[7.5550000000E+03, 4.0312973575E+00, 6.7666780360E+00, 1.3575330572E-01, 1.2883036462E-01, 4.5245775544E-01],
	[7.5600000000E+03, 4.0346022080E+00, 6.7654725924E+00, 1.3603363771E-01, 1.2908575416E-01, 4.5265164391E-01],
	[7.5650000000E+03, 4.0379075802E+00, 6.7642681603E+00, 1.3631436250E-01, 1.2934146258E-01, 4.5284548367E-01],
	[7.5700000000E+03, 4.0412134736E+00, 6.7630647382E+00, 1.3659548040E-01, 1.2959749000E-01, 4.5303927486E-01],
	[7.5750000000E+03, 4.0445213943E+00, 6.7618668302E+00, 1.3687699168E-01, 1.2985383976E-01, 4.5323301764E-01],
	[7.5800000000E+03, 4.0478334508E+00, 6.7606807234E+00, 1.3715889664E-01, 1.3011051651E-01, 4.5342671214E-01],
	[7.5850000000E+03, 4.0511460329E+00, 6.7594956067E+00, 1.3744119557E-01, 1.3036751269E-01, 4.5362035847E-01],
	[7.5900000000E+03, 4.0544591403E+00, 6.7583114785E+00, 1.3772388876E-01, 1.3062482841E-01, 4.5381395676E-01],
	[7.5950000000E+03, 4.0577727727E+00, 6.7571283373E+00, 1.3800697650E-01, 1.3088246380E-01, 4.5400750712E-01],
	[7.6000000000E+03, 4.0610869298E+00, 6.7559461817E+00, 1.3829045907E-01, 1.3114041898E-01, 4.5420100967E-01],
	[7.6050000000E+03, 4.0644016114E+00, 6.7547650101E+00, 1.3857433677E-01, 1.3139869405E-01, 4.5439446455E-01],
	[7.6100000000E+03, 4.0677168173E+00, 6.7535848212E+00, 1.3885860989E-01, 1.3165728914E-01, 4.5458787185E-01],
	[7.6150000000E+03, 4.0710325471E+00, 6.7524056135E+00, 1.3914327871E-01, 1.3191620436E-01, 4.5478123171E-01],
	[7.6200000000E+03, 4.0743488007E+00, 6.7512273855E+00, 1.3942834354E-01, 1.3217543983E-01, 4.5497454425E-01],
	[7.6250000000E+03, 4.0776655777E+00, 6.7500501357E+00, 1.3971380465E-01, 1.3243499567E-01, 4.5516780958E-01],
	[7.6300000000E+03, 4.0809828779E+00, 6.7488738627E+00, 1.3999966235E-01, 1.3269487200E-01, 4.5536102782E-01],
	[7.6350000000E+03, 4.0843007010E+00, 6.7476985650E+00, 1.4028591691E-01, 1.3295506892E-01, 4.5555419910E-01],
	[7.6400000000E+03, 4.0876190467E+00, 6.7465242413E+00, 1.4057256863E-01, 1.3321558655E-01, 4.5574732353E-01],
	[7.6450000000E+03, 4.0909379149E+00, 6.7453508900E+00, 1.4085961779E-01, 1.3347642502E-01, 4.5594040123E-01],
	[7.6500000000E+03, 4.0942573053E+00, 6.7441785097E+00, 1.4114706470E-01, 1.3373758443E-01, 4.5613343232E-01],
	[7.6550000000E+03, 4.0975772175E+00, 6.7430070990E+00, 1.4143490964E-01, 1.3399906490E-01, 4.5632641693E-01],
	[7.6600000000E+03, 4.1008976513E+00, 6.7418366564E+00, 1.4172315290E-01, 1.3426086654E-01, 4.5651935517E-01],
	[7.6650000000E+03, 4.1042186065E+00, 6.7406671806E+00, 1.4201179476E-01, 1.3452298947E-01, 4.5671224716E-01],
	[7.6700000000E+03, 4.1075400829E+00, 6.7394986700E+00, 1.4230083553E-01, 1.3478543380E-01, 4.5690509302E-01],
	[7.6750000000E+03, 4.1108620801E+00, 6.7383311233E+00, 1.4259027549E-01, 1.3504819965E-01, 4.5709789287E-01],
	[7.6800000000E+03, 4.1141845979E+00, 6.7371645391E+00, 1.4288011493E-01, 1.3531128713E-01, 4.5729064683E-01],
	[7.6850000000E+03, 4.1175076360E+00, 6.7359989158E+00, 1.4317035414E-01, 1.3557469635E-01, 4.5748335501E-01],
	[7.6900000000E+03, 4.1208311942E+00, 6.7348342522E+00, 1.4346099342E-01, 1.3583842742E-01, 4.5767601754E-01],
	[7.6950000000E+03, 4.1241552722E+00, 6.7336705467E+00, 1.4375203304E-01, 1.3610248046E-01, 4.5786863454E-01],
	[7.7000000000E+03, 4.1274843476E+00, 6.7325211406E+00, 1.4404347331E-01, 1.3636686595E-01, 4.5806120612E-01],
	[7.7050000000E+03, 4.1308143919E+00, 6.7313740022E+00, 1.4433531452E-01, 1.3663157473E-01, 4.5825373241E-01],
	[7.7100000000E+03, 4.1341449599E+00, 6.7302278032E+00, 1.4462755694E-01, 1.3689660588E-01, 4.5844621352E-01],
	[7.7150000000E+03, 4.1374760515E+00, 6.7290825422E+00, 1.4492020088E-01, 1.3716195953E-01, 4.5863864957E-01],
	[7.7200000000E+03, 4.1408076664E+00, 6.7279382180E+00, 1.4521324663E-01, 1.3742763579E-01, 4.5883104068E-01],
	[7.7250000000E+03, 4.1441398043E+00, 6.7267948290E+00, 1.4550669447E-01, 1.3769363475E-01, 4.5902338697E-01],
	[7.7300000000E+03, 4.1474724650E+00, 6.7256523741E+00, 1.4580054470E-01, 1.3795995655E-01, 4.5921568856E-01],
	[7.7350000000E+03, 4.1508056482E+00, 6.7245108516E+00, 1.4609479760E-01, 1.3822660128E-01, 4.5940794557E-01],
	[7.7400000000E+03, 4.1541393536E+00, 6.7233702604E+00, 1.4638945347E-01, 1.3849356905E-01, 4.5960015811E-01],
	[7.7450000000E+03, 4.1574735811E+00, 6.7222305991E+00, 1.4668451260E-01, 1.3876085999E-01, 4.5979232630E-01],
	[7.7500000000E+03, 4.1608083303E+00, 6.7210918663E+00, 1.4697997528E-01, 1.3902847419E-01, 4.5998445027E-01],
	[7.7550000000E+03, 4.1641436009E+00, 6.7199540606E+00, 1.4727584180E-01, 1.3929641177E-01, 4.6017653013E-01],
	[7.7600000000E+03, 4.1674793929E+00, 6.7188171806E+00, 1.4757211245E-01, 1.3956467283E-01, 4.6036856600E-01],
	[7.7650000000E+03, 4.1708157057E+00, 6.7176812252E+00, 1.4786878752E-01, 1.3983325749E-01, 4.6056055799E-01],
	[7.7700000000E+03, 4.1741525394E+00, 6.7165461928E+00, 1.4816586730E-01, 1.4010216586E-01, 4.6075250623E-01],
	[7.7750000000E+03, 4.1774898934E+00, 6.7154120822E+00, 1.4846335208E-01, 1.4037139804E-01, 4.6094441084E-01],
	[7.7800000000E+03, 4.1808277677E+00, 6.7142788919E+00, 1.4876124216E-01, 1.4064095415E-01, 4.6113627193E-01],
	[7.7850000000E+03, 4.1841661620E+00, 6.7131466208E+00, 1.4905953781E-01, 1.4091083428E-01, 4.6132808962E-01],
	[7.7900000000E+03, 4.1875050760E+00, 6.7120152674E+00, 1.4935823935E-01, 1.4118103856E-01, 4.6151986403E-01],
	[7.7950000000E+03, 4.1908445094E+00, 6.7108848304E+00, 1.4965734705E-01, 1.4145156708E-01, 4.6171159528E-01],
	[7.8000000000E+03, 4.1941844621E+00, 6.7097553085E+00, 1.4995686121E-01, 1.4172241996E-01, 4.6190328348E-01],
	[7.8050000000E+03, 4.1975249337E+00, 6.7086267003E+00, 1.5025678211E-01, 1.4199359730E-01, 4.6209492876E-01],
	[7.8100000000E+03, 4.2008659240E+00, 6.7074990046E+00, 1.5055711005E-01, 1.4226509920E-01, 4.6228653123E-01],
	[7.8150000000E+03, 4.2042074328E+00, 6.7063722199E+00, 1.5085784532E-01, 1.4253692578E-01, 4.6247809101E-01],
	[7.8200000000E+03, 4.2075500847E+00, 6.7052482053E+00, 1.5115898822E-01, 1.4280907871E-01, 4.6266960822E-01],
	[7.8250000000E+03, 4.2108973551E+00, 6.7041372889E+00, 1.5146053902E-01, 1.4308156682E-01, 4.6286108297E-01],
	[7.8300000000E+03, 4.2142451477E+00, 6.7030272661E+00, 1.5176249802E-01, 1.4335438000E-01, 4.6305251539E-01],
	[7.8350000000E+03, 4.2175934622E+00, 6.7019181354E+00, 1.5206486552E-01, 1.4362751836E-01, 4.6324390558E-01],
	[7.8400000000E+03, 4.2209422984E+00, 6.7008098957E+00, 1.5236764181E-01, 1.4390098200E-01, 4.6343525368E-01],
	[7.8450000000E+03, 4.2242916561E+00, 6.6997025456E+00, 1.5267082716E-01, 1.4417477103E-01, 4.6362655980E-01],
	[7.8500000000E+03, 4.2276415349E+00, 6.6985960839E+00, 1.5297442189E-01, 1.4444888555E-01, 4.6381782405E-01],
	[7.8550000000E+03, 4.2309919347E+00, 6.6974905093E+00, 1.5327842627E-01, 1.4472332566E-01, 4.6400904655E-01],
	[7.8600000000E+03, 4.2343428551E+00, 6.6963858205E+00, 1.5358284060E-01, 1.4499809148E-01, 4.6420022742E-01],
	[7.8650000000E+03, 4.2376942959E+00, 6.6952820162E+00, 1.5388766517E-01, 1.4527318310E-01, 4.6439136693E-01],
	[7.8700000000E+03, 4.2410462570E+00, 6.6941790952E+00, 1.5419290028E-01, 1.4554860064E-01, 4.6458246531E-01],
	[7.8750000000E+03, 4.2443987379E+00, 6.6930770562E+00, 1.5449854620E-01, 1.4582434418E-01, 4.6477352263E-01],
	[7.8800000000E+03, 4.2477517386E+00, 6.6919758979E+00, 1.5480460324E-01, 1.4610041385E-01, 4.6496453897E-01],
	[7.8850000000E+03, 4.2511052586E+00, 6.6908756191E+00, 1.5511107168E-01, 1.4637680974E-01, 4.6515551442E-01],
	[7.8900000000E+03, 4.2544592979E+00, 6.6897762186E+00, 1.5541795182E-01, 1.4665353194E-01, 4.6534644905E-01],
	[7.8950000000E+03, 4.2578138560E+00, 6.6886776950E+00, 1.5572524394E-01, 1.4693058058E-01, 4.6553734295E-01],
	[7.9000000000E+03, 4.2611689329E+00, 6.6875800471E+00, 1.5603294835E-01, 1.4720795574E-01, 4.6572819620E-01],
	[7.9050000000E+03, 4.2645245282E+00, 6.6864832736E+00, 1.5634106532E-01, 1.4748565754E-01, 4.6591900887E-01],
	[7.9100000000E+03, 4.2678806416E+00, 6.6853873733E+00, 1.5664959516E-01, 1.4776368607E-01, 4.6610978105E-01],
	[7.9150000000E+03, 4.2712372730E+00, 6.6842923450E+00, 1.5695853815E-01, 1.4804204143E-01, 4.6630051282E-01],
	[7.9200000000E+03, 4.2745944221E+00, 6.6831981875E+00, 1.5726789458E-01, 1.4832072373E-01, 4.6649120426E-01],
	[7.9250000000E+03, 4.2779520887E+00, 6.6821048994E+00, 1.5757766475E-01, 1.4859973307E-01, 4.6668185544E-01],
	[7.9300000000E+03, 4.2813102724E+00, 6.6810124795E+00, 1.5788784894E-01, 1.4887906954E-01, 4.6687246646E-01],
	[7.9350000000E+03, 4.2846689731E+00, 6.6799209266E+00, 1.5819844745E-01, 1.4915873325E-01, 4.6706303738E-01],
	[7.9400000000E+03, 4.2880281905E+00, 6.6788302395E+00, 1.5850946057E-01, 1.4943872430E-01, 4.6725356830E-01],
	[7.9450000000E+03, 4.2913879243E+00, 6.6777404169E+00, 1.5882088860E-01, 1.4971904279E-01, 4.6744405928E-01],
	[7.9500000000E+03, 4.2947525078E+00, 6.6766643265E+00, 1.5913273181E-01, 1.4999970060E-01, 4.6763451042E-01],
	[7.9550000000E+03, 4.2981178099E+00, 6.6755896753E+00, 1.5944499051E-01, 1.5028068667E-01, 4.6782492178E-01],
	[7.9600000000E+03, 4.3014836320E+00, 6.6745158722E+00, 1.5975766499E-01, 1.5056200055E-01, 4.6801529346E-01],
	[7.9650000000E+03, 4.3048499739E+00, 6.6734429159E+00, 1.6007075553E-01, 1.5084364235E-01, 4.6820562554E-01],
	[7.9700000000E+03, 4.3082168352E+00, 6.6723708053E+00, 1.6038426243E-01, 1.5112561216E-01, 4.6839591808E-01],
	[7.9750000000E+03, 4.3115842157E+00, 6.6712995391E+00, 1.6069818599E-01, 1.5140791008E-01, 4.6858617118E-01],
	[7.9800000000E+03, 4.3149521152E+00, 6.6702291162E+00, 1.6101252648E-01, 1.5169053621E-01, 4.6877638491E-01],
	[7.9850000000E+03, 4.3183205334E+00, 6.6691595353E+00, 1.6132728421E-01, 1.5197349066E-01, 4.6896655936E-01],
	[7.9900000000E+03, 4.3216894702E+00, 6.6680907954E+00, 1.6164245946E-01, 1.5225677351E-01, 4.6915669461E-01],
	[7.9950000000E+03, 4.3250589252E+00, 6.6670228951E+00, 1.6195805253E-01, 1.5254038487E-01, 4.6934679073E-01],
	[8.0000000000E+03, 4.3284288981E+00, 6.6659558334E+00, 1.6227406372E-01, 1.5282432483E-01, 4.6953684780E-01],
	[8.0050000000E+03, 4.3317993889E+00, 6.6648896089E+00, 1.6259242002E-01, 1.5311030203E-01, 4.6972686592E-01],
	[8.0100000000E+03, 4.3351703972E+00, 6.6638242207E+00, 1.6291120131E-01, 1.5339661301E-01, 4.6991684515E-01],
	[8.0150000000E+03, 4.3385419227E+00, 6.6627596674E+00, 1.6323040790E-01, 1.5368325785E-01, 4.7010678558E-01],
	[8.0200000000E+03, 4.3419139652E+00, 6.6616959478E+00, 1.6355004009E-01, 1.5397023666E-01, 4.7029668729E-01],
	[8.0250000000E+03, 4.3452865246E+00, 6.6606330610E+00, 1.6387009817E-01, 1.5425754954E-01, 4.7048655036E-01],
	[8.0300000000E+03, 4.3486596005E+00, 6.6595710055E+00, 1.6419058245E-01, 1.5454519659E-01, 4.7067637487E-01],
	[8.0350000000E+03, 4.3520331927E+00, 6.6585097804E+00, 1.6451149323E-01, 1.5483317791E-01, 4.7086616090E-01],
	[8.0400000000E+03, 4.3554073009E+00, 6.6574493844E+00, 1.6483283081E-01, 1.5512149360E-01, 4.7105590853E-01],
	[8.0450000000E+03, 4.3587819250E+00, 6.6563898163E+00, 1.6515459549E-01, 1.5541014376E-01, 4.7124561784E-01],
	[8.0500000000E+03, 4.3621570646E+00, 6.6553310751E+00, 1.6547678757E-01, 1.5569912848E-01, 4.7143528892E-01],
	[8.0550000000E+03, 4.3655327196E+00, 6.6542731595E+00, 1.6579940736E-01, 1.5598844787E-01, 4.7162492184E-01],
	[8.0600000000E+03, 4.3689088896E+00, 6.6532160684E+00, 1.6612245515E-01, 1.5627810203E-01, 4.7181451669E-01],
	[8.0650000000E+03, 4.3722855745E+00, 6.6521598006E+00, 1.6644593125E-01, 1.5656809104E-01, 4.7200407354E-01],
	[8.0700000000E+03, 4.3756627740E+00, 6.6511043550E+00, 1.6676983596E-01, 1.5685841502E-01, 4.7219359247E-01],
	[8.0750000000E+03, 4.3790421558E+00, 6.6500545802E+00, 1.6709416957E-01, 1.5714907892E-01, 4.7238307357E-01],
	[8.0800000000E+03, 4.3824248375E+00, 6.6490137087E+00, 1.6741893240E-01, 1.5744008613E-01, 4.7257251692E-01],
	[8.0850000000E+03, 4.3858080372E+00, 6.6479736438E+00, 1.6774412474E-01, 1.5773142867E-01, 4.7276192260E-01],
	[8.0900000000E+03, 4.3891917546E+00, 6.6469343845E+00, 1.6806974689E-01, 1.5802310665E-01, 4.7295129068E-01],
	[8.0950000000E+03, 4.3925759895E+00, 6.6458959297E+00, 1.6839579916E-01, 1.5831512016E-01, 4.7314062125E-01],
	[8.1000000000E+03, 4.3959607417E+00, 6.6448582781E+00, 1.6872228185E-01, 1.5860746929E-01, 4.7332991440E-01],
	[8.1050000000E+03, 4.3993460110E+00, 6.6438214288E+00, 1.6904919525E-01, 1.5890015415E-01, 4.7351917019E-01],
	[8.1100000000E+03, 4.4027317971E+00, 6.6427853805E+00, 1.6937653968E-01, 1.5919317482E-01, 4.7370838871E-01],
	[8.1150000000E+03, 4.4061180997E+00, 6.6417501322E+00, 1.6970431543E-01, 1.5948653141E-01, 4.7389757005E-01],
	[8.1200000000E+03, 4.4095049186E+00, 6.6407156827E+00, 1.7003252280E-01, 1.5978022401E-01, 4.7408671428E-01],
	[8.1250000000E+03, 4.4128922536E+00, 6.6396820310E+00, 1.7036116209E-01, 1.6007425272E-01, 4.7427582149E-01],
	[8.1300000000E+03, 4.4162801045E+00, 6.6386491759E+00, 1.7069023361E-01, 1.6036861762E-01, 4.7446489174E-01],
	[8.1350000000E+03, 4.4196684710E+00, 6.6376171164E+00, 1.7101973766E-01, 1.6066331882E-01, 4.7465392514E-01],
	[8.1400000000E+03, 4.4230573528E+00, 6.6365858513E+00, 1.7134967455E-01, 1.6095835641E-01, 4.7484292175E-01],
	[8.1450000000E+03, 4.4264467497E+00, 6.6355553796E+00, 1.7168004456E-01, 1.6125373048E-01, 4.7503188166E-01],
	[8.1500000000E+03, 4.4298366616E+00, 6.6345257000E+00, 1.7201084801E-01, 1.6154944112E-01, 4.7522080494E-01],
	[8.1550000000E+03, 4.4332270881E+00, 6.6334968117E+00, 1.7234208519E-01, 1.6184548844E-01, 4.7540969168E-01],
	[8.1600000000E+03, 4.4366180290E+00, 6.6324687133E+00, 1.7267375641E-01, 1.6214187252E-01, 4.7559854197E-01],
	[8.1650000000E+03, 4.4400094840E+00, 6.6314414040E+00, 1.7300586197E-01, 1.6243859346E-01, 4.7578735587E-01],
	[8.1700000000E+03, 4.4434014530E+00, 6.6304148825E+00, 1.7333840217E-01, 1.6273565135E-01, 4.7597613347E-01],
	[8.1750000000E+03, 4.4467939358E+00, 6.6293891478E+00, 1.7367137731E-01, 1.6303304628E-01, 4.7616487486E-01],
	[8.1800000000E+03, 4.4501869319E+00, 6.6283641988E+00, 1.7400478770E-01, 1.6333077834E-01, 4.7635358011E-01],
	[8.1850000000E+03, 4.4535804413E+00, 6.6273400345E+00, 1.7433863363E-01, 1.6362884763E-01, 4.7654224931E-01],
	[8.1900000000E+03, 4.4569744637E+00, 6.6263166536E+00, 1.7467291542E-01, 1.6392725424E-01, 4.7673088252E-01],
	[8.1950000000E+03, 4.4603689989E+00, 6.6252940553E+00, 1.7500763335E-01, 1.6422599825E-01, 4.7691947985E-01],
	[8.2000000000E+03, 4.4637640466E+00, 6.6242722383E+00, 1.7534278774E-01, 1.6452507977E-01, 4.7710804136E-01],
	[8.2050000000E+03, 4.4671613102E+00, 6.6232559629E+00, 1.7567837888E-01, 1.6482450414E-01, 4.7729656714E-01],
	[8.2100000000E+03, 4.4705618511E+00, 6.6222481787E+00, 1.7601440708E-01, 1.6512427479E-01, 4.7748505727E-01],
	[8.2150000000E+03, 4.4739629079E+00, 6.6212411612E+00, 1.7635087264E-01, 1.6542438330E-01, 4.7767351183E-01],
	[8.2200000000E+03, 4.4773644803E+00, 6.6202349095E+00, 1.7668777586E-01, 1.6572482976E-01, 4.7786193090E-01],
	[8.2250000000E+03, 4.4807665682E+00, 6.6192294224E+00, 1.7702511705E-01, 1.6602561425E-01, 4.7805031456E-01],
	[8.2300000000E+03, 4.4841691712E+00, 6.6182246990E+00, 1.7736289650E-01, 1.6632673687E-01, 4.7823866289E-01],
	[8.2350000000E+03, 4.4875722892E+00, 6.6172207381E+00, 1.7770111451E-01, 1.6662819770E-01, 4.7842697598E-01],
	[8.2400000000E+03, 4.4909759218E+00, 6.6162175388E+00, 1.7803977140E-01, 1.6692999683E-01, 4.7861525390E-01],
	[8.2450000000E+03, 4.4943800690E+00, 6.6152151000E+00, 1.7837886746E-01, 1.6723213436E-01, 4.7880349674E-01],
	[8.2500000000E+03, 4.4977847304E+00, 6.6142134206E+00, 1.7871840299E-01, 1.6753461037E-01, 4.7899170457E-01],
	[8.2550000000E+03, 4.5011899058E+00, 6.6132124997E+00, 1.7905837831E-01, 1.6783742495E-01, 4.7917987748E-01],
	[8.2600000000E+03, 4.5045955950E+00, 6.6122123362E+00, 1.7939879370E-01, 1.6814057819E-01, 4.7936801555E-01],
	[8.2650000000E+03, 4.5080017977E+00, 6.6112129290E+00, 1.7973964947E-01, 1.6844407017E-01, 4.7955611887E-01],
	[8.2700000000E+03, 4.5114085137E+00, 6.6102142772E+00, 1.8008094592E-01, 1.6874790098E-01, 4.7974418750E-01],
	[8.2750000000E+03, 4.5148157428E+00, 6.6092163797E+00, 1.8042268337E-01, 1.6905207071E-01, 4.7993222154E-01],
	[8.2800000000E+03, 4.5182234848E+00, 6.6082192355E+00, 1.8076486210E-01, 1.6935657944E-01, 4.8012022105E-01],
	[8.2850000000E+03, 4.5216317394E+00, 6.6072228436E+00, 1.8110748242E-01, 1.6966142727E-01, 4.8030818614E-01],
	[8.2900000000E+03, 4.5250405063E+00, 6.6062272028E+00, 1.8145054464E-01, 1.6996661428E-01, 4.8049611687E-01],
	[8.2950000000E+03, 4.5284497854E+00, 6.6052323124E+00, 1.8179404905E-01, 1.7027214055E-01, 4.8068401333E-01],
	[8.3000000000E+03, 4.5318595764E+00, 6.6042381711E+00, 1.8213799596E-01, 1.7057800617E-01, 4.8087187559E-01],
	[8.3050000000E+03, 4.5352698790E+00, 6.6032447780E+00, 1.8248238567E-01, 1.7088421122E-01, 4.8105970375E-01],
	[8.3100000000E+03, 4.5386806932E+00, 6.6022521321E+00, 1.8282721848E-01, 1.7119075580E-01, 4.8124749787E-01],
	[8.3150000000E+03, 4.5420920185E+00, 6.6012602323E+00, 1.8317249471E-01, 1.7149763998E-01, 4.8143525805E-01],
	[8.3200000000E+03, 4.5455038548E+00, 6.6002690777E+00, 1.8351821464E-01, 1.7180486384E-01, 4.8162298436E-01],
	[8.3250000000E+03, 4.5489162019E+00, 6.5992786673E+00, 1.8386437858E-01, 1.7211242748E-01, 4.8181067689E-01],
	[8.3300000000E+03, 4.5523290596E+00, 6.5982890000E+00, 1.8421098684E-01, 1.7242033098E-01, 4.8199833571E-01],
	[8.3350000000E+03, 4.5557424275E+00, 6.5973000749E+00, 1.8455803971E-01, 1.7272857442E-01, 4.8218596091E-01],
	[8.3400000000E+03, 4.5591606553E+00, 6.5963235594E+00, 1.8490553750E-01, 1.7303717217E-01, 4.8237355256E-01],
	[8.3450000000E+03, 4.5625795327E+00, 6.5953481375E+00, 1.8525348052E-01, 1.7334611057E-01, 4.8256111076E-01],
	[8.3500000000E+03, 4.5659989237E+00, 6.5943734439E+00, 1.8560186906E-01, 1.7365538924E-01, 4.8274863558E-01],
	[8.3550000000E+03, 4.5694188281E+00, 6.5933994777E+00, 1.8595070342E-01, 1.7396500828E-01, 4.8293612710E-01],
	[8.3600000000E+03, 4.5728392457E+00, 6.5924262379E+00, 1.8629998392E-01, 1.7427496776E-01, 4.8312358540E-01],
	[8.3650000000E+03, 4.5762601762E+00, 6.5914537235E+00, 1.8664971085E-01, 1.7458526776E-01, 4.8331101057E-01],
	[8.3700000000E+03, 4.5796816194E+00, 6.5904819336E+00, 1.8699988452E-01, 1.7489590837E-01, 4.8349840269E-01],
	[8.3750000000E+03, 4.5831035752E+00, 6.5895108672E+00, 1.8735050523E-01, 1.7520688967E-01, 4.8368576183E-01],
	[8.3800000000E+03, 4.5865260432E+00, 6.5885405234E+00, 1.8770157328E-01, 1.7551821174E-01, 4.8387308809E-01],
	[8.3850000000E+03, 4.5899490232E+00, 6.5875709010E+00, 1.8805308897E-01, 1.7582987467E-01, 4.8406038153E-01],
	[8.3900000000E+03, 4.5933725150E+00, 6.5866019993E+00, 1.8840505261E-01, 1.7614187852E-01, 4.8424764225E-01],
	[8.3950000000E+03, 4.5967965184E+00, 6.5856338172E+00, 1.8875746450E-01, 1.7645422339E-01, 4.8443487032E-01],
	[8.4000000000E+03, 4.6002210332E+00, 6.5846663537E+00, 1.8911032495E-01, 1.7676690935E-01, 4.8462206582E-01],
	[8.4050000000E+03, 4.6036460590E+00, 6.5836996080E+00, 1.8946363425E-01, 1.7707993648E-01, 4.8480922883E-01],
	[8.4100000000E+03, 4.6070715958E+00, 6.5827335789E+00, 1.8981739272E-01, 1.7739330486E-01, 4.8499635933E-01],
	[8.4150000000E+03, 4.6104976432E+00, 6.5817682657E+00, 1.9017160064E-01, 1.7770701457E-01, 4.8518345736E-01],
	[8.4200000000E+03, 4.6139242011E+00, 6.5808036673E+00, 1.9052625834E-01, 1.7802106570E-01, 4.8537052295E-01],
	[8.4250000000E+03, 4.6173512691E+00, 6.5798397827E+00, 1.9088136610E-01, 1.7833545831E-01, 4.8555755615E-01],
	[8.4300000000E+03, 4.6207788472E+00, 6.5788766111E+00, 1.9123692423E-01, 1.7865019249E-01, 4.8574455699E-01],
	[8.4350000000E+03, 4.6242069350E+00, 6.5779141515E+00, 1.9159293304E-01, 1.7896526831E-01, 4.8593152553E-01],
	[8.4400000000E+03, 4.6276355323E+00, 6.5769524028E+00, 1.9194939283E-01, 1.7928068585E-01, 4.8611846180E-01],
	[8.4450000000E+03, 4.6310646389E+00, 6.5759913643E+00, 1.9230630389E-01, 1.7959644520E-01, 4.8630536584E-01],
	[8.4500000000E+03, 4.6344942546E+00, 6.5750310349E+00, 1.9266366655E-01, 1.7991254642E-01, 4.8649223770E-01],
	[8.4550000000E+03, 4.6379243792E+00, 6.5740714137E+00, 1.9302148109E-01, 1.8022898959E-01, 4.8667907741E-01],
	[8.4600000000E+03, 4.6413550123E+00, 6.5731124997E+00, 1.9337974782E-01, 1.8054577480E-01, 4.8686588503E-01],
	[8.4650000000E+03, 4.6447861539E+00, 6.5721542921E+00, 1.9373846705E-01, 1.8086290211E-01, 4.8705266059E-01],
	[8.4700000000E+03, 4.6482184017E+00, 6.5711983313E+00, 1.9409763908E-01, 1.8118037368E-01, 4.8723940414E-01],
	[8.4750000000E+03, 4.6516550641E+00, 6.5702531327E+00, 1.9445726421E-01, 1.8149820115E-01, 4.8742611571E-01],
	[8.4800000000E+03, 4.6550922382E+00, 6.5693086273E+00, 1.9481734274E-01, 1.8181637104E-01, 4.8761279535E-01],
	[8.4850000000E+03, 4.6585299237E+00, 6.5683648143E+00, 1.9517787498E-01, 1.8213488344E-01, 4.8779944311E-01],
	[8.4900000000E+03, 4.6619681205E+00, 6.5674216928E+00, 1.9553886123E-01, 1.8245373841E-01, 4.8798605902E-01],
	[8.4950000000E+03, 4.6654068284E+00, 6.5664792619E+00, 1.9590030180E-01, 1.8277293604E-01, 4.8817264312E-01],
	[8.5000000000E+03, 4.6688460471E+00, 6.5655375206E+00, 1.9626219699E-01, 1.8309247639E-01, 4.8835919547E-01],
	[8.5050000000E+03, 4.6722857764E+00, 6.5645964680E+00, 1.9662454710E-01, 1.8341235954E-01, 4.8854571610E-01],
	[8.5100000000E+03, 4.6757260160E+00, 6.5636561033E+00, 1.9698735243E-01, 1.8373258557E-01, 4.8873220505E-01],
	[8.5150000000E+03, 4.6791667658E+00, 6.5627164256E+00, 1.9735061329E-01, 1.8405315455E-01, 4.8891866237E-01],
	[8.5200000000E+03, 4.6826080255E+00, 6.5617774338E+00, 1.9771432999E-01, 1.8437406655E-01, 4.8910508810E-01],
	[8.5250000000E+03, 4.6860497949E+00, 6.5608391272E+00, 1.9807850282E-01, 1.8469532164E-01, 4.8929148229E-01],
	[8.5300000000E+03, 4.6894920738E+00, 6.5599015048E+00, 1.9844313209E-01, 1.8501691990E-01, 4.8947784496E-01],
	[8.5350000000E+03, 4.6929348619E+00, 6.5589645657E+00, 1.9880821810E-01, 1.8533886140E-01, 4.8966417618E-01],
	[8.5400000000E+03, 4.6963781591E+00, 6.5580283091E+00, 1.9917376116E-01, 1.8566114622E-01, 4.8985047598E-01],
	[8.5450000000E+03, 4.6998219650E+00, 6.5570927339E+00, 1.9953976158E-01, 1.8598377441E-01, 4.9003674440E-01],
	[8.5500000000E+03, 4.7032662796E+00, 6.5561578395E+00, 1.9990621964E-01, 1.8630674607E-01, 4.9022298149E-01],
	[8.5550000000E+03, 4.7067111025E+00, 6.5552236247E+00, 2.0027313567E-01, 1.8663006125E-01, 4.9040918729E-01],
	[8.5600000000E+03, 4.7101564335E+00, 6.5542900888E+00, 2.0064050995E-01, 1.8695372003E-01, 4.9059536185E-01],
	[8.5650000000E+03, 4.7136022725E+00, 6.5533572308E+00, 2.0100834280E-01, 1.8727772247E-01, 4.9078150520E-01],
	[8.5700000000E+03, 4.7170486191E+00, 6.5524250500E+00, 2.0137663453E-01, 1.8760206866E-01, 4.9096761739E-01],
	[8.5750000000E+03, 4.7204954732E+00, 6.5514935453E+00, 2.0174538542E-01, 1.8792675865E-01, 4.9115369846E-01],
	[8.5800000000E+03, 4.7239428346E+00, 6.5505627159E+00, 2.0211459579E-01, 1.8825179253E-01, 4.9133974846E-01],
	[8.5850000000E+03, 4.7273907030E+00, 6.5496325609E+00, 2.0248426594E-01, 1.8857717035E-01, 4.9152576742E-01],
	[8.5900000000E+03, 4.7308390782E+00, 6.5487030795E+00, 2.0285439618E-01, 1.8890289219E-01, 4.9171175540E-01],
	[8.5950000000E+03, 4.7342879600E+00, 6.5477742707E+00, 2.0322498681E-01, 1.8922895812E-01, 4.9189771244E-01],
	[8.6000000000E+03, 4.7377373481E+00, 6.5468461338E+00, 2.0359603812E-01, 1.8955536820E-01, 4.9208363857E-01],
	[8.6050000000E+03, 4.7411872424E+00, 6.5459186677E+00, 2.0396755044E-01, 1.8988212250E-01, 4.9226953385E-01],
	[8.6100000000E+03, 4.7446415496E+00, 6.5450015317E+00, 2.0433952405E-01, 1.9020923554E-01, 4.9245539831E-01],
	[8.6150000000E+03, 4.7480969818E+00, 6.5440865780E+00, 2.0471195927E-01, 1.9053669530E-01, 4.9264123200E-01],
	[8.6200000000E+03, 4.7515529234E+00, 6.5431722829E+00, 2.0508485640E-01, 1.9086449958E-01, 4.9282703497E-01],
	[8.6250000000E+03, 4.7550093742E+00, 6.5422586457E+00, 2.0545821574E-01, 1.9119264846E-01, 4.9301280725E-01],
	[8.6300000000E+03, 4.7584663341E+00, 6.5413456654E+00, 2.0583203760E-01, 1.9152114199E-01, 4.9319854889E-01],
	[8.6350000000E+03, 4.7619238027E+00, 6.5404333413E+00, 2.0620632227E-01, 1.9184998025E-01, 4.9338425994E-01],
	[8.6400000000E+03, 4.7653817799E+00, 6.5395216723E+00, 2.0658107008E-01, 1.9217916330E-01, 4.9356994043E-01],
	[8.6450000000E+03, 4.7688402654E+00, 6.5386106578E+00, 2.0695628131E-01, 1.9250869121E-01, 4.9375559042E-01],
	[8.6500000000E+03, 4.7722992590E+00, 6.5377002968E+00, 2.0733195627E-01, 1.9283856405E-01, 4.9394120994E-01],
	[8.6550000000E+03, 4.7757587606E+00, 6.5367905886E+00, 2.0770809527E-01, 1.9316878188E-01, 4.9412679904E-01],
	[8.6600000000E+03, 4.7792187698E+00, 6.5358815322E+00, 2.0808469861E-01, 1.9349934476E-01, 4.9431235777E-01],
	[8.6650000000E+03, 4.7826792865E+00, 6.5349731268E+00, 2.0846176660E-01, 1.9383025276E-01, 4.9449788616E-01],
	[8.6700000000E+03, 4.7861403105E+00, 6.5340653716E+00, 2.0883929954E-01, 1.9416150595E-01, 4.9468338426E-01],
	[8.6750000000E+03, 4.7896018414E+00, 6.5331582657E+00, 2.0921729773E-01, 1.9449310439E-01, 4.9486885211E-01],
	[8.6800000000E+03, 4.7930638792E+00, 6.5322518084E+00, 2.0959576148E-01, 1.9482504814E-01, 4.9505428977E-01],
	[8.6850000000E+03, 4.7965264236E+00, 6.5313459986E+00, 2.0997469110E-01, 1.9515733727E-01, 4.9523969727E-01],
	[8.6900000000E+03, 4.7999894744E+00, 6.5304408358E+00, 2.1035408688E-01, 1.9548997184E-01, 4.9542507465E-01],
	[8.6950000000E+03, 4.8034530313E+00, 6.5295363189E+00, 2.1073394913E-01, 1.9582295191E-01, 4.9561042197E-01],
	[8.7000000000E+03, 4.8069170942E+00, 6.5286324472E+00, 2.1111427816E-01, 1.9615627756E-01, 4.9579573927E-01],
	[8.7050000000E+03, 4.8103816628E+00, 6.5277292198E+00, 2.1149507427E-01, 1.9648994883E-01, 4.9598102658E-01],
	[8.7100000000E+03, 4.8138467369E+00, 6.5268266359E+00, 2.1187633776E-01, 1.9682396579E-01, 4.9616628396E-01],
	[8.7150000000E+03, 4.8173123162E+00, 6.5259246947E+00, 2.1225806894E-01, 1.9715832852E-01, 4.9635151144E-01],
	[8.7200000000E+03, 4.8207784007E+00, 6.5250233953E+00, 2.1264026812E-01, 1.9749303705E-01, 4.9653670908E-01],
	[8.7250000000E+03, 4.8242449900E+00, 6.5241227369E+00, 2.1302293559E-01, 1.9782809147E-01, 4.9672187692E-01],
	[8.7300000000E+03, 4.8277120840E+00, 6.5232227188E+00, 2.1340607167E-01, 1.9816349182E-01, 4.9690701500E-01],
	[8.7350000000E+03, 4.8311796824E+00, 6.5223233400E+00, 2.1378967665E-01, 1.9849923818E-01, 4.9709212337E-01],
	[8.7400000000E+03, 4.8346477850E+00, 6.5214245998E+00, 2.1417375085E-01, 1.9883533059E-01, 4.9727720206E-01],
	[8.7450000000E+03, 4.8381170996E+00, 6.5205281781E+00, 2.1455829456E-01, 1.9917177189E-01, 4.9746225114E-01],
	[8.7500000000E+03, 4.8415907523E+00, 6.5196414862E+00, 2.1494330809E-01, 1.9950857442E-01, 4.9764727063E-01],
	[8.7550000000E+03, 4.8450649125E+00, 6.5187554213E+00, 2.1532879175E-01, 1.9984572329E-01, 4.9783226059E-01],
	[8.7600000000E+03, 4.8485395799E+00, 6.5178699826E+00, 2.1571474584E-01, 2.0018321856E-01, 4.9801722105E-01],
	[8.7650000000E+03, 4.8520147544E+00, 6.5169851693E+00, 2.1610117066E-01, 2.0052106029E-01, 4.9820215208E-01],
	[8.7700000000E+03, 4.8554904358E+00, 6.5161009806E+00, 2.1648806652E-01, 2.0085924854E-01, 4.9838705370E-01],
	[8.7750000000E+03, 4.8589666237E+00, 6.5152174157E+00, 2.1687543373E-01, 2.0119778337E-01, 4.9857192596E-01],
	[8.7800000000E+03, 4.8624433181E+00, 6.5143344739E+00, 2.1726327259E-01, 2.0153666484E-01, 4.9875676892E-01],
	[8.7850000000E+03, 4.8659205187E+00, 6.5134521542E+00, 2.1765158340E-01, 2.0187589300E-01, 4.9894158260E-01],
	[8.7900000000E+03, 4.8693982253E+00, 6.5125704560E+00, 2.1804036647E-01, 2.0221546792E-01, 4.9912636707E-01],
	[8.7950000000E+03, 4.8728764376E+00, 6.5116893785E+00, 2.1842962210E-01, 2.0255538965E-01, 4.9931112236E-01],
	[8.8000000000E+03, 4.8763551554E+00, 6.5108089208E+00, 2.1881935060E-01, 2.0289565825E-01, 4.9949584852E-01],
	[8.8050000000E+03, 4.8798343787E+00, 6.5099290821E+00, 2.1920955227E-01, 2.0323627377E-01, 4.9968054560E-01],
	[8.8100000000E+03, 4.8833141070E+00, 6.5090498618E+00, 2.1960022743E-01, 2.0357723628E-01, 4.9986521363E-01],
	[8.8150000000E+03, 4.8867943402E+00, 6.5081712589E+00, 2.1999137636E-01, 2.0391854582E-01, 5.0004985266E-01],
	[8.8200000000E+03, 4.8902750782E+00, 6.5072932727E+00, 2.2038299938E-01, 2.0426020246E-01, 5.0023446275E-01],
	[8.8250000000E+03, 4.8937563206E+00, 6.5064159025E+00, 2.2077509680E-01, 2.0460220625E-01, 5.0041904393E-01],
	[8.8300000000E+03, 4.8972380673E+00, 6.5055391474E+00, 2.2116766891E-01, 2.0494455724E-01, 5.0060359625E-01],
	[8.8350000000E+03, 4.9007203180E+00, 6.5046630067E+00, 2.2156071603E-01, 2.0528725550E-01, 5.0078811976E-01],
	[8.8400000000E+03, 4.9042030726E+00, 6.5037874796E+00, 2.2195423845E-01, 2.0563030107E-01, 5.0097261450E-01],
	[8.8450000000E+03, 4.9076863309E+00, 6.5029125653E+00, 2.2234823649E-01, 2.0597369401E-01, 5.0115708051E-01],
	[8.8500000000E+03, 4.9111700925E+00, 6.5020382630E+00, 2.2274271045E-01, 2.0631743438E-01, 5.0134151784E-01],
	[8.8550000000E+03, 4.9146543574E+00, 6.5011645720E+00, 2.2313766063E-01, 2.0666152222E-01, 5.0152592654E-01],
	[8.8600000000E+03, 4.9181391253E+00, 6.5002914915E+00, 2.2353308733E-01, 2.0700595760E-01, 5.0171030666E-01],
	[8.8650000000E+03, 4.9216243959E+00, 6.4994190207E+00, 2.2392899087E-01, 2.0735074056E-01, 5.0189465823E-01],
	[8.8700000000E+03, 4.9251101692E+00, 6.4985471589E+00, 2.2432537155E-01, 2.0769587116E-01, 5.0207898130E-01],
	[8.8750000000E+03, 4.9285964448E+00, 6.4976759052E+00, 2.2472222967E-01, 2.0804134945E-01, 5.0226327593E-01],
	[8.8800000000E+03, 4.9320832225E+00, 6.4968052590E+00, 2.2511956554E-01, 2.0838717549E-01, 5.0244754215E-01],
	[8.8850000000E+03, 4.9355705110E+00, 6.4959352394E+00, 2.2551737947E-01, 2.0873334936E-01, 5.0263178001E-01],
	[8.8900000000E+03, 4.9390628534E+00, 6.4950761864E+00, 2.2591567175E-01, 2.0907988996E-01, 5.0281598955E-01],
	[8.8950000000E+03, 4.9425557012E+00, 6.4942177300E+00, 2.2631444270E-01, 2.0942677858E-01, 5.0300017083E-01],
	[8.9000000000E+03, 4.9460490542E+00, 6.4933598694E+00, 2.2671369262E-01, 2.0977401525E-01, 5.0318432389E-01],
	[8.9050000000E+03, 4.9495429122E+00, 6.4925026038E+00, 2.2711342182E-01, 2.1012160003E-01, 5.0336844877E-01],
	[8.9100000000E+03, 4.9530372749E+00, 6.4916459325E+00, 2.2751363059E-01, 2.1046953296E-01, 5.0355254552E-01],
	[8.9150000000E+03, 4.9565321423E+00, 6.4907898547E+00, 2.2791431925E-01, 2.1081781411E-01, 5.0373661417E-01],
	[8.9200000000E+03, 4.9600275139E+00, 6.4899343697E+00, 2.2831548810E-01, 2.1116644352E-01, 5.0392065471E-01],
	[8.9250000000E+03, 4.9635233898E+00, 6.4890794768E+00, 2.2871713745E-01, 2.1151542124E-01, 5.0410466713E-01],
	[8.9300000000E+03, 4.9670197695E+00, 6.4882251752E+00, 2.2911926760E-01, 2.1186474731E-01, 5.0428865146E-01],
	[8.9350000000E+03, 4.9705166530E+00, 6.4873714642E+00, 2.2952187886E-01, 2.1221442180E-01, 5.0447260772E-01],
	[8.9400000000E+03, 4.9740140400E+00, 6.4865183430E+00, 2.2992497153E-01, 2.1256444474E-01, 5.0465653591E-01],
	[8.9450000000E+03, 4.9775119302E+00, 6.4856658109E+00, 2.3032854592E-01, 2.1291481619E-01, 5.0484043606E-01],
	[8.9500000000E+03, 4.9810103236E+00, 6.4848138672E+00, 2.3073260234E-01, 2.1326553620E-01, 5.0502430819E-01],
	[8.9550000000E+03, 4.9845092199E+00, 6.4839625111E+00, 2.3113714108E-01, 2.1361660481E-01, 5.0520815230E-01],
	[8.9600000000E+03, 4.9880086188E+00, 6.4831117419E+00, 2.3154216246E-01, 2.1396802207E-01, 5.0539196841E-01],
	[8.9650000000E+03, 4.9915085203E+00, 6.4822615588E+00, 2.3194766678E-01, 2.1431978803E-01, 5.0557575655E-01],
	[8.9700000000E+03, 4.9950089239E+00, 6.4814119612E+00, 2.3235365434E-01, 2.1467190274E-01, 5.0575951672E-01],
	[8.9750000000E+03, 4.9985098297E+00, 6.4805629483E+00, 2.3276012546E-01, 2.1502436624E-01, 5.0594324895E-01],
	[8.9800000000E+03, 5.0020112372E+00, 6.4797145194E+00, 2.3316708044E-01, 2.1537717858E-01, 5.0612695325E-01],
	[8.9850000000E+03, 5.0055131464E+00, 6.4788666737E+00, 2.3357451958E-01, 2.1573033980E-01, 5.0631062964E-01],
	[8.9900000000E+03, 5.0090155571E+00, 6.4780194106E+00, 2.3398244318E-01, 2.1608384996E-01, 5.0649427814E-01],
	[8.9950000000E+03, 5.0125184690E+00, 6.4771727293E+00, 2.3439085157E-01, 2.1643770910E-01, 5.0667789875E-01],
	[9.0000000000E+03, 5.0160218818E+00, 6.4763266290E+00, 2.3479974503E-01, 2.1679191725E-01, 5.0686149151E-01],
	[9.0050000000E+03, 5.0195257955E+00, 6.4754811091E+00, 2.3521095697E-01, 2.1714803684E-01, 5.0704505642E-01],
	[9.0100000000E+03, 5.0230302098E+00, 6.4746361688E+00, 2.3562266004E-01, 2.1750450950E-01, 5.0722859351E-01],
	[9.0150000000E+03, 5.0265351245E+00, 6.4737918075E+00, 2.3603485456E-01, 2.1786133527E-01, 5.0741210278E-01],
	[9.0200000000E+03, 5.0300405394E+00, 6.4729480243E+00, 2.3644754083E-01, 2.1821851422E-01, 5.0759558427E-01],
	[9.0250000000E+03, 5.0335464543E+00, 6.4721048186E+00, 2.3686071918E-01, 2.1857604637E-01, 5.0777903797E-01],
	[9.0300000000E+03, 5.0370546921E+00, 6.4712661458E+00, 2.3727438991E-01, 2.1893393976E-01, 5.0796246392E-01],
	[9.0350000000E+03, 5.0405662284E+00, 6.4704341110E+00, 2.3768855334E-01, 2.1929219876E-01, 5.0814586213E-01],
	[9.0400000000E+03, 5.0440782680E+00, 6.4696026434E+00, 2.3810320978E-01, 2.1965081122E-01, 5.0832923262E-01],
	[9.0450000000E+03, 5.0475908107E+00, 6.4687717423E+00, 2.3851835954E-01, 2.2000977719E-01, 5.0851257540E-01],
	[9.0500000000E+03, 5.0511038562E+00, 6.4679414071E+00, 2.3893400295E-01, 2.2036909671E-01, 5.0869589049E-01],
	[9.0550000000E+03, 5.0546174043E+00, 6.4671116369E+00, 2.3935014030E-01, 2.2072876983E-01, 5.0887917791E-01],
	[9.0600000000E+03, 5.0581314548E+00, 6.4662824311E+00, 2.3976677193E-01, 2.2108879659E-01, 5.0906243768E-01],
	[9.0650000000E+03, 5.0616460075E+00, 6.4654537891E+00, 2.4018389813E-01, 2.2144917704E-01, 5.0924566982E-01],
	[9.0700000000E+03, 5.0651610623E+00, 6.4646257101E+00, 2.4060151922E-01, 2.2180991122E-01, 5.0942887433E-01],
	[9.0750000000E+03, 5.0686766188E+00, 6.4637981935E+00, 2.4101963552E-01, 2.2217099918E-01, 5.0961205125E-01],
	[9.0800000000E+03, 5.0721926770E+00, 6.4629712385E+00, 2.4143824734E-01, 2.2253244096E-01, 5.0979520059E-01],
	[9.0850000000E+03, 5.0757092365E+00, 6.4621448444E+00, 2.4185735499E-01, 2.2289423660E-01, 5.0997832236E-01],
	[9.0900000000E+03, 5.0792262973E+00, 6.4613190107E+00, 2.4227695879E-01, 2.2325638614E-01, 5.1016141659E-01],
	[9.0950000000E+03, 5.0827438590E+00, 6.4604937365E+00, 2.4269705905E-01, 2.2361888963E-01, 5.1034448329E-01],
	[9.1000000000E+03, 5.0862619215E+00, 6.4596690212E+00, 2.4311765608E-01, 2.2398174710E-01, 5.1052752247E-01],
	[9.1050000000E+03, 5.0897804846E+00, 6.4588448641E+00, 2.4353875020E-01, 2.2434495861E-01, 5.1071053417E-01],
	[9.1100000000E+03, 5.0932995481E+00, 6.4580212645E+00, 2.4396034172E-01, 2.2470852420E-01, 5.1089351840E-01],
	[9.1150000000E+03, 5.0968191117E+00, 6.4571982218E+00, 2.4438243096E-01, 2.2507244389E-01, 5.1107647517E-01],
	[9.1200000000E+03, 5.1003391753E+00, 6.4563757352E+00, 2.4480501822E-01, 2.2543671774E-01, 5.1125940450E-01],
	[9.1250000000E+03, 5.1038597387E+00, 6.4555538041E+00, 2.4522810383E-01, 2.2580134579E-01, 5.1144230642E-01],
	[9.1300000000E+03, 5.1073808016E+00, 6.4547324278E+00, 2.4565168810E-01, 2.2616632807E-01, 5.1162518093E-01],
	[9.1350000000E+03, 5.1109023639E+00, 6.4539116056E+00, 2.4607577133E-01, 2.2653166462E-01, 5.1180802806E-01],
	[9.1400000000E+03, 5.1144244253E+00, 6.4530913369E+00, 2.4650035385E-01, 2.2689735549E-01, 5.1199084784E-01],
	[9.1450000000E+03, 5.1179469857E+00, 6.4522716210E+00, 2.4692543597E-01, 2.2726340072E-01, 5.1217364026E-01],
	[9.1500000000E+03, 5.1214700449E+00, 6.4514524571E+00, 2.4735101800E-01, 2.2762980034E-01, 5.1235640536E-01],
	[9.1550000000E+03, 5.1249936026E+00, 6.4506338447E+00, 2.4777710025E-01, 2.2799655439E-01, 5.1253914316E-01],
	[9.1600000000E+03, 5.1285176587E+00, 6.4498157830E+00, 2.4820368305E-01, 2.2836366291E-01, 5.1272185366E-01],
	[9.1650000000E+03, 5.1320422129E+00, 6.4489982714E+00, 2.4863076670E-01, 2.2873112594E-01, 5.1290453690E-01],
	[9.1700000000E+03, 5.1355672650E+00, 6.4481813092E+00, 2.4905835151E-01, 2.2909894351E-01, 5.1308719289E-01],
	[9.1750000000E+03, 5.1390943744E+00, 6.4473680750E+00, 2.4948643781E-01, 2.2946712281E-01, 5.1326982164E-01],
	[9.1800000000E+03, 5.1426251953E+00, 6.4465619303E+00, 2.4991502591E-01, 2.2983567149E-01, 5.1345242319E-01],
	[9.1850000000E+03, 5.1461565174E+00, 6.4457563253E+00, 2.5034411611E-01, 2.3020457496E-01, 5.1363499753E-01],
	[9.1900000000E+03, 5.1496883407E+00, 6.4449512593E+00, 2.5077370874E-01, 2.3057383324E-01, 5.1381754471E-01],
	[9.1950000000E+03, 5.1532206648E+00, 6.4441467316E+00, 2.5120380411E-01, 2.3094344636E-01, 5.1400006473E-01],
	[9.2000000000E+03, 5.1567534897E+00, 6.4433427417E+00, 2.5163440253E-01, 2.3131341438E-01, 5.1418255761E-01],
	[9.2050000000E+03, 5.1602868150E+00, 6.4425392888E+00, 2.5206550431E-01, 2.3168373731E-01, 5.1436502338E-01],
	[9.2100000000E+03, 5.1638206406E+00, 6.4417363724E+00, 2.5249710978E-01, 2.3205441520E-01, 5.1454746205E-01],
	[9.2150000000E+03, 5.1673549663E+00, 6.4409339917E+00, 2.5292921924E-01, 2.3242544808E-01, 5.1472987364E-01],
	[9.2200000000E+03, 5.1708897918E+00, 6.4401321461E+00, 2.5336183301E-01, 2.3279683599E-01, 5.1491225817E-01],
	[9.2250000000E+03, 5.1744251171E+00, 6.4393308349E+00, 2.5379495141E-01, 2.3316857896E-01, 5.1509461566E-01],
	[9.2300000000E+03, 5.1779609418E+00, 6.4385300576E+00, 2.5422857474E-01, 2.3354067703E-01, 5.1527694613E-01],
	[9.2350000000E+03, 5.1814972658E+00, 6.4377298135E+00, 2.5466270333E-01, 2.3391313023E-01, 5.1545924960E-01],
	[9.2400000000E+03, 5.1850340889E+00, 6.4369301019E+00, 2.5509733748E-01, 2.3428593859E-01, 5.1564152609E-01],
	[9.2450000000E+03, 5.1885714109E+00, 6.4361309222E+00, 2.5553247751E-01, 2.3465910215E-01, 5.1582377562E-01],
	[9.2500000000E+03, 5.1921092316E+00, 6.4353322737E+00, 2.5596812374E-01, 2.3503262093E-01, 5.1600599820E-01],
	[9.2550000000E+03, 5.1956475507E+00, 6.4345341559E+00, 2.5640427648E-01, 2.3540649498E-01, 5.1618819387E-01],
	[9.2600000000E+03, 5.1991863681E+00, 6.4337365680E+00, 2.5684093604E-01, 2.3578072433E-01, 5.1637036263E-01],
	[9.2650000000E+03, 5.2027256837E+00, 6.4329395094E+00, 2.5727810274E-01, 2.3615530900E-01, 5.1655250451E-01],
	[9.2700000000E+03, 5.2062654971E+00, 6.4321429796E+00, 2.5771577690E-01, 2.3653024903E-01, 5.1673461953E-01],
	[9.2750000000E+03, 5.2098058082E+00, 6.4313469778E+00, 2.5815395882E-01, 2.3690554445E-01, 5.1691670771E-01],
	[9.2800000000E+03, 5.2133466167E+00, 6.4305515034E+00, 2.5859264883E-01, 2.3728119529E-01, 5.1709876906E-01],
	[9.2850000000E+03, 5.2168879226E+00, 6.4297565558E+00, 2.5903184723E-01, 2.3765720158E-01, 5.1728080361E-01],
	[9.2900000000E+03, 5.2204297256E+00, 6.4289621344E+00, 2.5947155435E-01, 2.3803356336E-01, 5.1746281138E-01],
	[9.2950000000E+03, 5.2239720255E+00, 6.4281682385E+00, 2.5991177049E-01, 2.3841028065E-01, 5.1764479239E-01],
	[9.3000000000E+03, 5.2275148220E+00, 6.4273748675E+00, 2.6035249597E-01, 2.3878735348E-01, 5.1782674665E-01],
	[9.3050000000E+03, 5.2310581151E+00, 6.4265820207E+00, 2.6079373110E-01, 2.3916478188E-01, 5.1800867420E-01],
	[9.3100000000E+03, 5.2346019045E+00, 6.4257896976E+00, 2.6123547621E-01, 2.3954256589E-01, 5.1819057504E-01],
	[9.3150000000E+03, 5.2381461900E+00, 6.4249978976E+00, 2.6167773160E-01, 2.3992070552E-01, 5.1837244920E-01],
	[9.3200000000E+03, 5.2416909713E+00, 6.4242066199E+00, 2.6212049760E-01, 2.4029920081E-01, 5.1855429670E-01],
	[9.3250000000E+03, 5.2452401545E+00, 6.4234233332E+00, 2.6256377450E-01, 2.4067807050E-01, 5.1873611756E-01],
	[9.3300000000E+03, 5.2487908679E+00, 6.4226425329E+00, 2.6300756264E-01, 2.4105730095E-01, 5.1891791180E-01],
	[9.3350000000E+03, 5.2523420807E+00, 6.4218622458E+00, 2.6345186232E-01, 2.4143688728E-01, 5.1909967944E-01],
	[9.3400000000E+03, 5.2558937927E+00, 6.4210824712E+00, 2.6389667386E-01, 2.4181682949E-01, 5.1928142050E-01],
	[9.3450000000E+03, 5.2594460036E+00, 6.4203032086E+00, 2.6434199758E-01, 2.4219712763E-01, 5.1946313501E-01],
	[9.3500000000E+03, 5.2629987132E+00, 6.4195244572E+00, 2.6478783378E-01, 2.4257778173E-01, 5.1964482297E-01],
	[9.3550000000E+03, 5.2665519214E+00, 6.4187462166E+00, 2.6523418279E-01, 2.4295879179E-01, 5.1982648443E-01],
	[9.3600000000E+03, 5.2701056280E+00, 6.4179684861E+00, 2.6568104491E-01, 2.4334015786E-01, 5.2000811938E-01],
	[9.3650000000E+03, 5.2736598328E+00, 6.4171912651E+00, 2.6612842047E-01, 2.4372187996E-01, 5.2018972786E-01],
	[9.3700000000E+03, 5.2772145355E+00, 6.4164145530E+00, 2.6657630978E-01, 2.4410395812E-01, 5.2037130989E-01],
	[9.3750000000E+03, 5.2807697360E+00, 6.4156383492E+00, 2.6702471315E-01, 2.4448639235E-01, 5.2055286548E-01],
	[9.3800000000E+03, 5.2843254341E+00, 6.4148626531E+00, 2.6747363090E-01, 2.4486918269E-01, 5.2073439466E-01],
	[9.3850000000E+03, 5.2878816296E+00, 6.4140874641E+00, 2.6792306335E-01, 2.4525232916E-01, 5.2091589745E-01],
	[9.3900000000E+03, 5.2914383222E+00, 6.4133127815E+00, 2.6837301080E-01, 2.4563583178E-01, 5.2109737387E-01],
	[9.3950000000E+03, 5.2949955119E+00, 6.4125386048E+00, 2.6882347358E-01, 2.4601969059E-01, 5.2127882394E-01],
	[9.4000000000E+03, 5.2985531983E+00, 6.4117649335E+00, 2.6927445200E-01, 2.4640390559E-01, 5.2146024765E-01],
	[9.4050000000E+03, 5.3021113814E+00, 6.4109917668E+00, 2.6972594637E-01, 2.4678847682E-01, 5.2164164497E-01],
	[9.4100000000E+03, 5.3056700609E+00, 6.4102191042E+00, 2.7017795701E-01, 2.4717340430E-01, 5.2182301592E-01],
	[9.4150000000E+03, 5.3092292366E+00, 6.4094469450E+00, 2.7063048424E-01, 2.4755868805E-01, 5.2200436048E-01],
	[9.4200000000E+03, 5.3127889083E+00, 6.4086752888E+00, 2.7108352836E-01, 2.4794432810E-01, 5.2218567865E-01],
	[9.4250000000E+03, 5.3163490758E+00, 6.4079041349E+00, 2.7153708971E-01, 2.4833032446E-01, 5.2236697044E-01],
	[9.4300000000E+03, 5.3199097390E+00, 6.4071334827E+00, 2.7199116858E-01, 2.4871667716E-01, 5.2254823585E-01],
	[9.4350000000E+03, 5.3234708976E+00, 6.4063633316E+00, 2.7244576530E-01, 2.4910338622E-01, 5.2272947487E-01],
	[9.4400000000E+03, 5.3270325515E+00, 6.4055936811E+00, 2.7290088018E-01, 2.4949045166E-01, 5.2291068750E-01],
	[9.4450000000E+03, 5.3305947004E+00, 6.4048245305E+00, 2.7335651354E-01, 2.4987787350E-01, 5.2309187375E-01],
	[9.4500000000E+03, 5.3341573442E+00, 6.4040558792E+00, 2.7381266569E-01, 2.5026565176E-01, 5.2327303360E-01],
	[9.4550000000E+03, 5.3377204826E+00, 6.4032877267E+00, 2.7426933694E-01, 2.5065378647E-01, 5.2345416707E-01],
	[9.4600000000E+03, 5.3412841155E+00, 6.4025200724E+00, 2.7472652762E-01, 2.5104227764E-01, 5.2363527415E-01],
	[9.4650000000E+03, 5.3448482427E+00, 6.4017529156E+00, 2.7518423804E-01, 2.5143112529E-01, 5.2381635484E-01],
	[9.4700000000E+03, 5.3484128640E+00, 6.4009862559E+00, 2.7564246852E-01, 2.5182032944E-01, 5.2399740914E-01],
	[9.4750000000E+03, 5.3519819599E+00, 6.4002272412E+00, 2.7610121936E-01, 2.5220991006E-01, 5.2417843705E-01],
	[9.4800000000E+03, 5.3555526766E+00, 6.3994707334E+00, 2.7656049089E-01, 2.5259985296E-01, 5.2435943857E-01],
	[9.4850000000E+03, 5.3591238908E+00, 6.3987147139E+00, 2.7702028342E-01, 2.5299015255E-01, 5.2454041370E-01],
	[9.4900000000E+03, 5.3626956025E+00, 6.3979591820E+00, 2.7748059726E-01, 2.5338080885E-01, 5.2472136244E-01],
	[9.4950000000E+03, 5.3662678114E+00, 6.3972041372E+00, 2.7794143274E-01, 2.5377182187E-01, 5.2490228478E-01],
	[9.5000000000E+03, 5.3698405173E+00, 6.3964495789E+00, 2.7840279016E-01, 2.5416319164E-01, 5.2508318074E-01],
	[9.5050000000E+03, 5.3734137201E+00, 6.3956955066E+00, 2.7886466985E-01, 2.5455491818E-01, 5.2526405031E-01],
	[9.5100000000E+03, 5.3769874196E+00, 6.3949419197E+00, 2.7932707212E-01, 2.5494700149E-01, 5.2544489349E-01],
	[9.5150000000E+03, 5.3805616155E+00, 6.3941888176E+00, 2.7978999728E-01, 2.5533944160E-01, 5.2562571027E-01],
	[9.5200000000E+03, 5.3841363077E+00, 6.3934361998E+00, 2.8025344565E-01, 2.5573223852E-01, 5.2580650067E-01],
	[9.5250000000E+03, 5.3877114960E+00, 6.3926840657E+00, 2.8071741755E-01, 2.5612539227E-01, 5.2598726468E-01],
	[9.5300000000E+03, 5.3912871801E+00, 6.3919324147E+00, 2.8118191329E-01, 2.5651890287E-01, 5.2616800230E-01],
	[9.5350000000E+03, 5.3948633600E+00, 6.3911812463E+00, 2.8164693318E-01, 2.5691277032E-01, 5.2634871354E-01],
	[9.5400000000E+03, 5.3984400354E+00, 6.3904305598E+00, 2.8211247755E-01, 2.5730699465E-01, 5.2652939838E-01],
	[9.5450000000E+03, 5.4020172061E+00, 6.3896803549E+00, 2.8257854671E-01, 2.5770157587E-01, 5.2671005684E-01],
	[9.5500000000E+03, 5.4055948719E+00, 6.3889306308E+00, 2.8304514098E-01, 2.5809651400E-01, 5.2689068891E-01],
	[9.5550000000E+03, 5.4091730326E+00, 6.3881813870E+00, 2.8351226067E-01, 2.5849180904E-01, 5.2707129460E-01],
	[9.5600000000E+03, 5.4127516881E+00, 6.3874326230E+00, 2.8397990609E-01, 2.5888746102E-01, 5.2725187390E-01],
	[9.5650000000E+03, 5.4163308382E+00, 6.3866843382E+00, 2.8444807757E-01, 2.5928346994E-01, 5.2743242681E-01],
	[9.5700000000E+03, 5.4199104826E+00, 6.3859365320E+00, 2.8491677541E-01, 2.5967983583E-01, 5.2761295335E-01],
	[9.5750000000E+03, 5.4234906212E+00, 6.3851892039E+00, 2.8538599994E-01, 2.6007655868E-01, 5.2779345350E-01],
	[9.5800000000E+03, 5.4270712538E+00, 6.3844423534E+00, 2.8585575147E-01, 2.6047363852E-01, 5.2797392727E-01],
	[9.5850000000E+03, 5.4306523801E+00, 6.3836959798E+00, 2.8632603032E-01, 2.6087107536E-01, 5.2815437466E-01],
	[9.5900000000E+03, 5.4342340001E+00, 6.3829500827E+00, 2.8679683681E-01, 2.6126886920E-01, 5.2833479567E-01],
	[9.5950000000E+03, 5.4378161135E+00, 6.3822046615E+00, 2.8726817124E-01, 2.6166702007E-01, 5.2851519031E-01],
	[9.6000000000E+03, 5.4413987201E+00, 6.3814597156E+00, 2.8774003394E-01, 2.6206552797E-01, 5.2869555857E-01],
	[9.6050000000E+03, 5.4449818197E+00, 6.3807152444E+00, 2.8821242521E-01, 2.6246439291E-01, 5.2887590045E-01],
	[9.6100000000E+03, 5.4485654122E+00, 6.3799712475E+00, 2.8868534539E-01, 2.6286361491E-01, 5.2905621596E-01],
	[9.6150000000E+03, 5.4521494974E+00, 6.3792277243E+00, 2.8915879478E-01, 2.6326319397E-01, 5.2923650509E-01],
	[9.6200000000E+03, 5.4557340750E+00, 6.3784846742E+00, 2.8963277370E-01, 2.6366313010E-01, 5.2941676786E-01],
	[9.6250000000E+03, 5.4593206502E+00, 6.3777446381E+00, 2.9010728247E-01, 2.6406343119E-01, 5.2959700426E-01],
	[9.6300000000E+03, 5.4629114863E+00, 6.3770114282E+00, 2.9058232140E-01, 2.6446410918E-01, 5.2977721429E-01],
	[9.6350000000E+03, 5.4665028185E+00, 6.3762786831E+00, 2.9105789081E-01, 2.6486514442E-01, 5.2995739795E-01],
	[9.6400000000E+03, 5.4700946466E+00, 6.3755464023E+00, 2.9153399101E-01, 2.6526653690E-01, 5.3013755525E-01],
	[9.6450000000E+03, 5.4736869705E+00, 6.3748145852E+00, 2.9201062233E-01, 2.6566828664E-01, 5.3031768618E-01],
	[9.6500000000E+03, 5.4772797898E+00, 6.3740832314E+00, 2.9248778507E-01, 2.6607039366E-01, 5.3049779076E-01],
	[9.6550000000E+03, 5.4808731045E+00, 6.3733523402E+00, 2.9296547956E-01, 2.6647285795E-01, 5.3067786898E-01],
	[9.6600000000E+03, 5.4844669144E+00, 6.3726219112E+00, 2.9344370611E-01, 2.6687567952E-01, 5.3085792084E-01],
	[9.6650000000E+03, 5.4880612192E+00, 6.3718919438E+00, 2.9392246504E-01, 2.6727885839E-01, 5.3103794634E-01],
	[9.6700000000E+03, 5.4916560188E+00, 6.3711624375E+00, 2.9440175666E-01, 2.6768239456E-01, 5.3121794550E-01],
	[9.6750000000E+03, 5.4952513130E+00, 6.3704333917E+00, 2.9488158129E-01, 2.6808628803E-01, 5.3139791830E-01],
	[9.6800000000E+03, 5.4988471016E+00, 6.3697048060E+00, 2.9536193924E-01, 2.6849053882E-01, 5.3157786475E-01],
	[9.6850000000E+03, 5.5024433844E+00, 6.3689766798E+00, 2.9584283084E-01, 2.6889514693E-01, 5.3175778486E-01],
	[9.6900000000E+03, 5.5060401612E+00, 6.3682490126E+00, 2.9632425640E-01, 2.6930011236E-01, 5.3193767862E-01],
	[9.6950000000E+03, 5.5096374319E+00, 6.3675218038E+00, 2.9680621624E-01, 2.6970543512E-01, 5.3211754604E-01],
	[9.7000000000E+03, 5.5132351962E+00, 6.3667950529E+00, 2.9728871067E-01, 2.7011111521E-01, 5.3229738713E-01],
	[9.7050000000E+03, 5.5168334540E+00, 6.3660687594E+00, 2.9777174001E-01, 2.7051715265E-01, 5.3247720187E-01],
	[9.7100000000E+03, 5.5204322050E+00, 6.3653429229E+00, 2.9825530457E-01, 2.7092354743E-01, 5.3265699028E-01],
	[9.7150000000E+03, 5.5240314492E+00, 6.3646175426E+00, 2.9873940468E-01, 2.7133029957E-01, 5.3283675236E-01],
	[9.7200000000E+03, 5.5276311862E+00, 6.3638926182E+00, 2.9922404065E-01, 2.7173740905E-01, 5.3301648811E-01],
	[9.7250000000E+03, 5.5312314160E+00, 6.3631681491E+00, 2.9970921280E-01, 2.7214487589E-01, 5.3319619754E-01],
	[9.7300000000E+03, 5.5348321383E+00, 6.3624441348E+00, 3.0019492143E-01, 2.7255270009E-01, 5.3337588064E-01],
	[9.7350000000E+03, 5.5384333530E+00, 6.3617205748E+00, 3.0068116688E-01, 2.7296088166E-01, 5.3355553742E-01],
	[9.7400000000E+03, 5.5420350598E+00, 6.3609974685E+00, 3.0116794945E-01, 2.7336942059E-01, 5.3373516788E-01],
	[9.7450000000E+03, 5.5456372586E+00, 6.3602748155E+00, 3.0165526947E-01, 2.7377831689E-01, 5.3391477202E-01],
	[9.7500000000E+03, 5.5492399492E+00, 6.3595526152E+00, 3.0214312725E-01, 2.7418757055E-01, 5.3409434986E-01],
	[9.7550000000E+03, 5.5528431314E+00, 6.3588308671E+00, 3.0263152310E-01, 2.7459718159E-01, 5.3427390138E-01],
	[9.7600000000E+03, 5.5564468050E+00, 6.3581095707E+00, 3.0312045735E-01, 2.7500715001E-01, 5.3445342660E-01],
	[9.7650000000E+03, 5.5600509699E+00, 6.3573887254E+00, 3.0360993031E-01, 2.7541747579E-01, 5.3463292552E-01],
	[9.7700000000E+03, 5.5636556258E+00, 6.3566683309E+00, 3.0409994230E-01, 2.7582815895E-01, 5.3481239813E-01],
	[9.7750000000E+03, 5.5672607726E+00, 6.3559483865E+00, 3.0459049364E-01, 2.7623919949E-01, 5.3499184445E-01],
	[9.7800000000E+03, 5.5708680439E+00, 6.3552314859E+00, 3.0508158463E-01, 2.7665060634E-01, 5.3517126447E-01],
	[9.7850000000E+03, 5.5744796160E+00, 6.3545210754E+00, 3.0557321560E-01, 2.7706239151E-01, 5.3535065821E-01],
	[9.7900000000E+03, 5.5780916826E+00, 6.3538111072E+00, 3.0606538687E-01, 2.7747453421E-01, 5.3553002566E-01],
	[9.7950000000E+03, 5.5817042436E+00, 6.3531015808E+00, 3.0655809876E-01, 2.7788703442E-01, 5.3570936682E-01],
	[9.8000000000E+03, 5.5853172988E+00, 6.3523924957E+00, 3.0705135157E-01, 2.7829989216E-01, 5.3588868170E-01],
	[9.8050000000E+03, 5.5889308481E+00, 6.3516838513E+00, 3.0754514563E-01, 2.7871310741E-01, 5.3606797031E-01],
	[9.8100000000E+03, 5.5925448912E+00, 6.3509756472E+00, 3.0803948126E-01, 2.7912668019E-01, 5.3624723265E-01],
	[9.8150000000E+03, 5.5961594279E+00, 6.3502678829E+00, 3.0853435876E-01, 2.7954061048E-01, 5.3642646871E-01],
	[9.8200000000E+03, 5.5997744582E+00, 6.3495605579E+00, 3.0902977847E-01, 2.7995489828E-01, 5.3660567851E-01],
	[9.8250000000E+03, 5.6033899817E+00, 6.3488536716E+00, 3.0952574069E-01, 2.8036954360E-01, 5.3678486205E-01],
	[9.8300000000E+03, 5.6070059983E+00, 6.3481472236E+00, 3.1002224574E-01, 2.8078454643E-01, 5.3696401933E-01],
	[9.8350000000E+03, 5.6106225079E+00, 6.3474412134E+00, 3.1051929394E-01, 2.8119990676E-01, 5.3714315036E-01],
	[9.8400000000E+03, 5.6142395102E+00, 6.3467356405E+00, 3.1101688561E-01, 2.8161562459E-01, 5.3732225513E-01],
	[9.8450000000E+03, 5.6178570050E+00, 6.3460305044E+00, 3.1151502107E-01, 2.8203169993E-01, 5.3750133366E-01],
	[9.8500000000E+03, 5.6214749922E+00, 6.3453258046E+00, 3.1201370063E-01, 2.8244813276E-01, 5.3768038595E-01],
	[9.8550000000E+03, 5.6250934717E+00, 6.3446215406E+00, 3.1251292461E-01, 2.8286492307E-01, 5.3785941200E-01],
	[9.8600000000E+03, 5.6287124431E+00, 6.3439177120E+00, 3.1301269332E-01, 2.8328207087E-01, 5.3803841177E-01],
	[9.8650000000E+03, 5.6323319063E+00, 6.3432143182E+00, 3.1351300709E-01, 2.8369957616E-01, 5.3821738526E-01],
	[9.8700000000E+03, 5.6359518612E+00, 6.3425113587E+00, 3.1401386623E-01, 2.8411743891E-01, 5.3839633245E-01],
	[9.8750000000E+03, 5.6395723076E+00, 6.3418088331E+00, 3.1451527106E-01, 2.8453565914E-01, 5.3857525332E-01],
	[9.8800000000E+03, 5.6431932452E+00, 6.3411067409E+00, 3.1501722190E-01, 2.8495423683E-01, 5.3875414787E-01],
	[9.8850000000E+03, 5.6468146739E+00, 6.3404050816E+00, 3.1551971906E-01, 2.8537317197E-01, 5.3893301608E-01],
	[9.8900000000E+03, 5.6504365936E+00, 6.3397038546E+00, 3.1602276286E-01, 2.8579246457E-01, 5.3911185795E-01],
	[9.8950000000E+03, 5.6540590039E+00, 6.3390030596E+00, 3.1652635362E-01, 2.8621211461E-01, 5.3929067345E-01],
	[9.9000000000E+03, 5.6576819048E+00, 6.3383026961E+00, 3.1703049166E-01, 2.8663212208E-01, 5.3946946258E-01],
	[9.9050000000E+03, 5.6613052961E+00, 6.3376027634E+00, 3.1753517729E-01, 2.8705248698E-01, 5.3964822532E-01],
	[9.9100000000E+03, 5.6649291776E+00, 6.3369032613E+00, 3.1804041083E-01, 2.8747320930E-01, 5.3982696166E-01],
	[9.9150000000E+03, 5.6685535491E+00, 6.3362041891E+00, 3.1854619260E-01, 2.8789428903E-01, 5.4000567160E-01],
	[9.9200000000E+03, 5.6721784104E+00, 6.3355055464E+00, 3.1905252292E-01, 2.8831572616E-01, 5.4018435511E-01],
	[9.9250000000E+03, 5.6758037614E+00, 6.3348073328E+00, 3.1955940211E-01, 2.8873752068E-01, 5.4036301219E-01],
	[9.9300000000E+03, 5.6794296018E+00, 6.3341095477E+00, 3.2006683047E-01, 2.8915967259E-01, 5.4054164282E-01],
	[9.9350000000E+03, 5.6830559315E+00, 6.3334121907E+00, 3.2057480834E-01, 2.8958218188E-01, 5.4072024700E-01],
	[9.9400000000E+03, 5.6866873397E+00, 6.3327221074E+00, 3.2108333603E-01, 2.9000507482E-01, 5.4089882471E-01],
	[9.9450000000E+03, 5.6903202745E+00, 6.3320339877E+00, 3.2159241385E-01, 2.9042833118E-01, 5.4107737594E-01],
	[9.9500000000E+03, 5.6939537024E+00, 6.3313462886E+00, 3.2210204212E-01, 2.9085194504E-01, 5.4125590068E-01],
	[9.9550000000E+03, 5.6975876231E+00, 6.3306590096E+00, 3.2261222117E-01, 2.9127591639E-01, 5.4143439892E-01],
	[9.9600000000E+03, 5.7012220366E+00, 6.3299721503E+00, 3.2312295130E-01, 2.9170024522E-01, 5.4161287064E-01],
	[9.9650000000E+03, 5.7048569427E+00, 6.3292857102E+00, 3.2363423284E-01, 2.9212493152E-01, 5.4179131584E-01],
	[9.9700000000E+03, 5.7084923411E+00, 6.3285996888E+00, 3.2414606611E-01, 2.9254997527E-01, 5.4196973450E-01],
	[9.9750000000E+03, 5.7121282317E+00, 6.3279140856E+00, 3.2465845142E-01, 2.9297537647E-01, 5.4214812661E-01],
	[9.9800000000E+03, 5.7157646143E+00, 6.3272289003E+00, 3.2517138908E-01, 2.9340113510E-01, 5.4232649217E-01],
	[9.9850000000E+03, 5.7194014888E+00, 6.3265441322E+00, 3.2568487943E-01, 2.9382725115E-01, 5.4250483115E-01],
	[9.9900000000E+03, 5.7230388549E+00, 6.3258597811E+00, 3.2619892278E-01, 2.9425372461E-01, 5.4268314355E-01],
	[9.9950000000E+03, 5.7266767125E+00, 6.3251758463E+00, 3.2671351943E-01, 2.9468055546E-01, 5.4286142937E-01],
	[1.0000000000E+04, 5.7303150613E+00, 6.3244923275E+00, 3.2722866973E-01, 2.9510774370E-01, 5.4303968858E-01],
	[1.0005000000E+04, 5.7339539013E+00, 6.3238092241E+00, 3.2774723970E-01, 2.9553761944E-01, 5.4321792117E-01],
	[1.0010000000E+04, 5.7375932322E+00, 6.3231265358E+00, 3.2826637152E-01, 2.9596785752E-01, 5.4339612714E-01],
	[1.0015000000E+04, 5.7412330539E+00, 6.3224442621E+00, 3.2878606552E-01, 2.9639845790E-01, 5.4357430648E-01],
	[1.0020000000E+04, 5.7448733661E+00, 6.3217624024E+00, 3.2930632202E-01, 2.9682942059E-01, 5.4375245917E-01],
	[1.0025000000E+04, 5.7485141688E+00, 6.3210809564E+00, 3.2982714136E-01, 2.9726074557E-01, 5.4393058521E-01],
	[1.0030000000E+04, 5.7521554616E+00, 6.3203999236E+00, 3.3034852385E-01, 2.9769243282E-01, 5.4410868458E-01],
	[1.0035000000E+04, 5.7557972445E+00, 6.3197193035E+00, 3.3087046984E-01, 2.9812448233E-01, 5.4428675727E-01],
	[1.0040000000E+04, 5.7594395172E+00, 6.3190390957E+00, 3.3139297963E-01, 2.9855689409E-01, 5.4446480327E-01],
	[1.0045000000E+04, 5.7630822797E+00, 6.3183592997E+00, 3.3191605357E-01, 2.9898966808E-01, 5.4464282258E-01],
	[1.0050000000E+04, 5.7667255316E+00, 6.3176799151E+00, 3.3243969198E-01, 2.9942280428E-01, 5.4482081518E-01],
	[1.0055000000E+04, 5.7703692729E+00, 6.3170009414E+00, 3.3296389518E-01, 2.9985630269E-01, 5.4499878106E-01],
	[1.0060000000E+04, 5.7740135033E+00, 6.3163223782E+00, 3.3348866351E-01, 3.0029016328E-01, 5.4517672022E-01],
	[1.0065000000E+04, 5.7776582226E+00, 6.3156442250E+00, 3.3401399729E-01, 3.0072438604E-01, 5.4535463263E-01],
	[1.0070000000E+04, 5.7813034308E+00, 6.3149664813E+00, 3.3453989685E-01, 3.0115897096E-01, 5.4553251830E-01],
	[1.0075000000E+04, 5.7849491276E+00, 6.3142891467E+00, 3.3506636251E-01, 3.0159391801E-01, 5.4571037721E-01],
	[1.0080000000E+04, 5.7885953128E+00, 6.3136122208E+00, 3.3559339461E-01, 3.0202922718E-01, 5.4588820935E-01],
	[1.0085000000E+04, 5.7922419863E+00, 6.3129357032E+00, 3.3612099347E-01, 3.0246489845E-01, 5.4606601471E-01],
	[1.0090000000E+04, 5.7958891479E+00, 6.3122595932E+00, 3.3664915942E-01, 3.0290093181E-01, 5.4624379329E-01],
	[1.0095000000E+04, 5.7995367974E+00, 6.3115838906E+00, 3.3717789279E-01, 3.0333732723E-01, 5.4642154507E-01],
	[1.0100000000E+04, 5.8031898417E+00, 6.3109153622E+00, 3.3770719390E-01, 3.0377411382E-01, 5.4659927004E-01],
	[1.0105000000E+04, 5.8068444171E+00, 6.3102486682E+00, 3.3823706308E-01, 3.0421126877E-01, 5.4677696819E-01],
	[1.0110000000E+04, 5.8104994843E+00, 6.3095823744E+00, 3.3876750067E-01, 3.0464878590E-01, 5.4695463952E-01],
	[1.0115000000E+04, 5.8141550434E+00, 6.3089164803E+00, 3.3929850698E-01, 3.0508666519E-01, 5.4713228401E-01],
	[1.0120000000E+04, 5.8178110939E+00, 6.3082509856E+00, 3.3983008235E-01, 3.0552490662E-01, 5.4730990165E-01],
	[1.0125000000E+04, 5.8214676359E+00, 6.3075858897E+00, 3.4036222710E-01, 3.0596351017E-01, 5.4748749244E-01],
	[1.0130000000E+04, 5.8251246691E+00, 6.3069211922E+00, 3.4089494157E-01, 3.0640247583E-01, 5.4766505637E-01],
	[1.0135000000E+04, 5.8287821933E+00, 6.3062568927E+00, 3.4142822607E-01, 3.0684180356E-01, 5.4784259343E-01],
	[1.0140000000E+04, 5.8324402083E+00, 6.3055929908E+00, 3.4196208094E-01, 3.0728149336E-01, 5.4802010360E-01],
	[1.0145000000E+04, 5.8360987141E+00, 6.3049294861E+00, 3.4249650651E-01, 3.0772154520E-01, 5.4819758688E-01],
	[1.0150000000E+04, 5.8397577103E+00, 6.3042663780E+00, 3.4303150310E-01, 3.0816195906E-01, 5.4837504326E-01],
	[1.0155000000E+04, 5.8434171969E+00, 6.3036036662E+00, 3.4356707104E-01, 3.0860273491E-01, 5.4855247273E-01],
	[1.0160000000E+04, 5.8470771736E+00, 6.3029413502E+00, 3.4410321066E-01, 3.0904387274E-01, 5.4872987528E-01],
	[1.0165000000E+04, 5.8507376403E+00, 6.3022794296E+00, 3.4463992229E-01, 3.0948537252E-01, 5.4890725090E-01],
	[1.0170000000E+04, 5.8543985968E+00, 6.3016179040E+00, 3.4517720626E-01, 3.0992723424E-01, 5.4908459959E-01],
	[1.0175000000E+04, 5.8580600430E+00, 6.3009567729E+00, 3.4571506289E-01, 3.1036945786E-01, 5.4926192133E-01],
	[1.0180000000E+04, 5.8617219786E+00, 6.3002960360E+00, 3.4625349251E-01, 3.1081204337E-01, 5.4943921611E-01],
	[1.0185000000E+04, 5.8653844034E+00, 6.2996356927E+00, 3.4679249544E-01, 3.1125499073E-01, 5.4961648394E-01],
	[1.0190000000E+04, 5.8690473174E+00, 6.2989757427E+00, 3.4733207203E-01, 3.1169829994E-01, 5.4979372479E-01],
	[1.0195000000E+04, 5.8727107203E+00, 6.2983161855E+00, 3.4787222260E-01, 3.1214197096E-01, 5.4997093866E-01],
	[1.0200000000E+04, 5.8763746120E+00, 6.2976570207E+00, 3.4841294747E-01, 3.1258600376E-01, 5.5014812554E-01],
	[1.0205000000E+04, 5.8800389922E+00, 6.2969982479E+00, 3.4895424697E-01, 3.1303039833E-01, 5.5032528543E-01],
	[1.0210000000E+04, 5.8837038608E+00, 6.2963398666E+00, 3.4949612143E-01, 3.1347515463E-01, 5.5050241831E-01],
	[1.0215000000E+04, 5.8873692177E+00, 6.2956818765E+00, 3.5003857118E-01, 3.1392027265E-01, 5.5067952418E-01],
	[1.0220000000E+04, 5.8910350626E+00, 6.2950242771E+00, 3.5058159655E-01, 3.1436575235E-01, 5.5085660302E-01],
	[1.0225000000E+04, 5.8947013954E+00, 6.2943670679E+00, 3.5112519787E-01, 3.1481159372E-01, 5.5103365484E-01],
	[1.0230000000E+04, 5.8983682159E+00, 6.2937102486E+00, 3.5166937546E-01, 3.1525779672E-01, 5.5121067961E-01],
	[1.0235000000E+04, 5.9020355240E+00, 6.2930538188E+00, 3.5221412965E-01, 3.1570436132E-01, 5.5138767734E-01],
	[1.0240000000E+04, 5.9057033194E+00, 6.2923977779E+00, 3.5275946078E-01, 3.1615128750E-01, 5.5156464802E-01],
	[1.0245000000E+04, 5.9093716020E+00, 6.2917421257E+00, 3.5330536917E-01, 3.1659857523E-01, 5.5174159163E-01],
	[1.0250000000E+04, 5.9130403716E+00, 6.2910868616E+00, 3.5385185514E-01, 3.1704622449E-01, 5.5191850817E-01],
	[1.0255000000E+04, 5.9167096281E+00, 6.2904319853E+00, 3.5439891903E-01, 3.1749423524E-01, 5.5209539763E-01],
	[1.0260000000E+04, 5.9203814084E+00, 6.2897800699E+00, 3.5494656116E-01, 3.1794261991E-01, 5.5227226000E-01],
	[1.0265000000E+04, 5.9240580224E+00, 6.2891340252E+00, 3.5549478187E-01, 3.1839139269E-01, 5.5244909528E-01],
	[1.0270000000E+04, 5.9277351275E+00, 6.2884883615E+00, 3.5604358149E-01, 3.1884052706E-01, 5.5262590346E-01],
	[1.0275000000E+04, 5.9314127236E+00, 6.2878430783E+00, 3.5659296033E-01, 3.1929002299E-01, 5.5280268452E-01],
	[1.0280000000E+04, 5.9350908104E+00, 6.2871981751E+00, 3.5714291873E-01, 3.1973988045E-01, 5.5297943847E-01],
	[1.0285000000E+04, 5.9387693879E+00, 6.2865536517E+00, 3.5769345703E-01, 3.2019009941E-01, 5.5315616529E-01],
	[1.0290000000E+04, 5.9424484558E+00, 6.2859095075E+00, 3.5824457554E-01, 3.2064067985E-01, 5.5333286498E-01],
	[1.0295000000E+04, 5.9461280140E+00, 6.2852657423E+00, 3.5879627459E-01, 3.2109162173E-01, 5.5350953759E-01],
	[1.0300000000E+04, 5.9498080623E+00, 6.2846223554E+00, 3.5934855452E-01, 3.2154292502E-01, 5.5368618321E-01],
	[1.0305000000E+04, 5.9534886004E+00, 6.2839793467E+00, 3.5990141566E-01, 3.2199458969E-01, 5.5386280182E-01],
	[1.0310000000E+04, 5.9571696284E+00, 6.2833367156E+00, 3.6045485832E-01, 3.2244661571E-01, 5.5403939340E-01],
	[1.0315000000E+04, 5.9608511459E+00, 6.2826944617E+00, 3.6100888285E-01, 3.2289900304E-01, 5.5421595792E-01],
	[1.0320000000E+04, 5.9645331528E+00, 6.2820525847E+00, 3.6156348957E-01, 3.2335175166E-01, 5.5439249535E-01],
	[1.0325000000E+04, 5.9682156489E+00, 6.2814110841E+00, 3.6211867880E-01, 3.2380486153E-01, 5.5456900568E-01],
	[1.0330000000E+04, 5.9718986341E+00, 6.2807699596E+00, 3.6267445089E-01, 3.2425833262E-01, 5.5474548887E-01],
	[1.0335000000E+04, 5.9755821082E+00, 6.2801292107E+00, 3.6323080615E-01, 3.2471216490E-01, 5.5492194491E-01],
	[1.0340000000E+04, 5.9792660710E+00, 6.2794888371E+00, 3.6378774492E-01, 3.2516635833E-01, 5.5509837377E-01],
	[1.0345000000E+04, 5.9829505223E+00, 6.2788488382E+00, 3.6434526752E-01, 3.2562091287E-01, 5.5527477542E-01],
	[1.0350000000E+04, 5.9866354621E+00, 6.2782092139E+00, 3.6490337428E-01, 3.2607582850E-01, 5.5545114984E-01],
	[1.0355000000E+04, 5.9903208900E+00, 6.2775699635E+00, 3.6546206554E-01, 3.2653110518E-01, 5.5562749700E-01],
	[1.0360000000E+04, 5.9940068059E+00, 6.2769310868E+00, 3.6602134162E-01, 3.2698674287E-01, 5.5580381689E-01],
	[1.0365000000E+04, 5.9976932097E+00, 6.2762925833E+00, 3.6658120285E-01, 3.2744274155E-01, 5.5598010947E-01],
	[1.0370000000E+04, 6.0013801012E+00, 6.2756544526E+00, 3.6714164957E-01, 3.2789910116E-01, 5.5615637473E-01],
	[1.0375000000E+04, 6.0050674802E+00, 6.2750166944E+00, 3.6770268209E-01, 3.2835582169E-01, 5.5633261263E-01],
	[1.0380000000E+04, 6.0087553466E+00, 6.2743793083E+00, 3.6826430075E-01, 3.2881290308E-01, 5.5650882316E-01],
	[1.0385000000E+04, 6.0124437001E+00, 6.2737422938E+00, 3.6882650587E-01, 3.2927034531E-01, 5.5668500629E-01],
	[1.0390000000E+04, 6.0161325407E+00, 6.2731056505E+00, 3.6938929780E-01, 3.2972814834E-01, 5.5686116199E-01],
	[1.0395000000E+04, 6.0198218680E+00, 6.2724693781E+00, 3.6995267685E-01, 3.3018631214E-01, 5.5703729025E-01],
	[1.0400000000E+04, 6.0235116821E+00, 6.2718334762E+00, 3.7051664335E-01, 3.3064483665E-01, 5.5721339104E-01],
	[1.0405000000E+04, 6.0272019826E+00, 6.2711979443E+00, 3.7108119764E-01, 3.3110372185E-01, 5.5738946433E-01],
	[1.0410000000E+04, 6.0308927695E+00, 6.2705627821E+00, 3.7164634004E-01, 3.3156296770E-01, 5.5756551011E-01],
	[1.0415000000E+04, 6.0345840425E+00, 6.2699279892E+00, 3.7221207089E-01, 3.3202257415E-01, 5.5774152834E-01],
	[1.0420000000E+04, 6.0382758015E+00, 6.2692935652E+00, 3.7277839051E-01, 3.3248254118E-01, 5.5791751901E-01],
	[1.0425000000E+04, 6.0419700252E+00, 6.2686618075E+00, 3.7334529923E-01, 3.3294288123E-01, 5.5809348210E-01],
	[1.0430000000E+04, 6.0456695827E+00, 6.2680360406E+00, 3.7391279739E-01, 3.3340361248E-01, 5.5826941757E-01],
	[1.0435000000E+04, 6.0493696309E+00, 6.2674106360E+00, 3.7448088530E-01, 3.3386470437E-01, 5.5844532540E-01],
	[1.0440000000E+04, 6.0530701694E+00, 6.2667855934E+00, 3.7504956331E-01, 3.3432615688E-01, 5.5862120558E-01],
	[1.0445000000E+04, 6.0567711981E+00, 6.2661609124E+00, 3.7561883173E-01, 3.3478796995E-01, 5.5879705807E-01],
	[1.0450000000E+04, 6.0604727169E+00, 6.2655365925E+00, 3.7618869091E-01, 3.3525014356E-01, 5.5897288287E-01],
	[1.0455000000E+04, 6.0641747255E+00, 6.2649126334E+00, 3.7675914116E-01, 3.3571267765E-01, 5.5914867993E-01],
	[1.0460000000E+04, 6.0678772239E+00, 6.2642890348E+00, 3.7733018282E-01, 3.3617557218E-01, 5.5932444925E-01],
	[1.0465000000E+04, 6.0715802118E+00, 6.2636657962E+00, 3.7790181622E-01, 3.3663882713E-01, 5.5950019079E-01],
	[1.0470000000E+04, 6.0752836890E+00, 6.2630429173E+00, 3.7847404169E-01, 3.3710244243E-01, 5.5967590454E-01],
	[1.0475000000E+04, 6.0789876555E+00, 6.2624203976E+00, 3.7904685956E-01, 3.3756641806E-01, 5.5985159046E-01],
	[1.0480000000E+04, 6.0826921110E+00, 6.2617982369E+00, 3.7962027015E-01, 3.3803075396E-01, 5.6002724855E-01],
	[1.0485000000E+04, 6.0863970553E+00, 6.2611764347E+00, 3.8019427380E-01, 3.3849545010E-01, 5.6020287877E-01],
	[1.0490000000E+04, 6.0901024884E+00, 6.2605549906E+00, 3.8076887084E-01, 3.3896050644E-01, 5.6037848111E-01],
	[1.0495000000E+04, 6.0938084099E+00, 6.2599339043E+00, 3.8134406159E-01, 3.3942592292E-01, 5.6055405554E-01],
	[1.0500000000E+04, 6.0975148198E+00, 6.2593131754E+00, 3.8191984639E-01, 3.3989169951E-01, 5.6072960203E-01],
	[1.0505000000E+04, 6.1012217179E+00, 6.2586928036E+00, 3.8249622557E-01, 3.4035783617E-01, 5.6090512058E-01],
	[1.0510000000E+04, 6.1049291040E+00, 6.2580727883E+00, 3.8307319945E-01, 3.4082433283E-01, 5.6108061114E-01],
	[1.0515000000E+04, 6.1086369780E+00, 6.2574531294E+00, 3.8365076837E-01, 3.4129118948E-01, 5.6125607371E-01],
	[1.0520000000E+04, 6.1123453397E+00, 6.2568338263E+00, 3.8422893265E-01, 3.4175840604E-01, 5.6143150826E-01],
	[1.0525000000E+04, 6.1160541888E+00, 6.2562148788E+00, 3.8480769263E-01, 3.4222598250E-01, 5.6160691477E-01],
	[1.0530000000E+04, 6.1197635253E+00, 6.2555962864E+00, 3.8538704863E-01, 3.4269391878E-01, 5.6178229321E-01],
	[1.0535000000E+04, 6.1234733490E+00, 6.2549780488E+00, 3.8596700099E-01, 3.4316221486E-01, 5.6195764356E-01],
	[1.0540000000E+04, 6.1271836597E+00, 6.2543601656E+00, 3.8654755004E-01, 3.4363087068E-01, 5.6213296581E-01],
	[1.0545000000E+04, 6.1308944573E+00, 6.2537426365E+00, 3.8712869610E-01, 3.4409988620E-01, 5.6230825993E-01],
	[1.0550000000E+04, 6.1346057415E+00, 6.2531254610E+00, 3.8771043950E-01, 3.4456926137E-01, 5.6248352590E-01],
	[1.0555000000E+04, 6.1383175122E+00, 6.2525086388E+00, 3.8829278059E-01, 3.4503899614E-01, 5.6265876369E-01],
	[1.0560000000E+04, 6.1420297693E+00, 6.2518921696E+00, 3.8887571967E-01, 3.4550909047E-01, 5.6283397328E-01],
	[1.0565000000E+04, 6.1457425126E+00, 6.2512760529E+00, 3.8945925710E-01, 3.4597954430E-01, 5.6300915466E-01],
	[1.0570000000E+04, 6.1494557419E+00, 6.2506602883E+00, 3.9004339319E-01, 3.4645035759E-01, 5.6318430781E-01],
	[1.0575000000E+04, 6.1531694570E+00, 6.2500448756E+00, 3.9062812827E-01, 3.4692153029E-01, 5.6335943269E-01],
	[1.0580000000E+04, 6.1568836578E+00, 6.2494298144E+00, 3.9121346268E-01, 3.4739306235E-01, 5.6353452929E-01],
	[1.0585000000E+04, 6.1605983441E+00, 6.2488151043E+00, 3.9179939675E-01, 3.4786495372E-01, 5.6370959758E-01],
	[1.0590000000E+04, 6.1643135158E+00, 6.2482007448E+00, 3.9238593081E-01, 3.4833720435E-01, 5.6388463756E-01],
	[1.0595000000E+04, 6.1680344737E+00, 6.2475924133E+00, 3.9297306518E-01, 3.4880984884E-01, 5.6405964919E-01],
	[1.0600000000E+04, 6.1717578919E+00, 6.2469865380E+00, 3.9356080020E-01, 3.4928286556E-01, 5.6423463245E-01],
	[1.0605000000E+04, 6.1754818003E+00, 6.2463810071E+00, 3.9414913620E-01, 3.4975624160E-01, 5.6440958732E-01],
	[1.0610000000E+04, 6.1792061987E+00, 6.2457758203E+00, 3.9473807351E-01, 3.5022997692E-01, 5.6458451379E-01],
	[1.0615000000E+04, 6.1829310870E+00, 6.2451709773E+00, 3.9532761245E-01, 3.5070407145E-01, 5.6475941183E-01],
	[1.0620000000E+04, 6.1866564649E+00, 6.2445664776E+00, 3.9591775336E-01, 3.5117852515E-01, 5.6493428141E-01],
	[1.0625000000E+04, 6.1903823324E+00, 6.2439623209E+00, 3.9650849657E-01, 3.5165333798E-01, 5.6510912253E-01],
	[1.0630000000E+04, 6.1941086893E+00, 6.2433585068E+00, 3.9709984242E-01, 3.5212850986E-01, 5.6528393515E-01],
	[1.0635000000E+04, 6.1978355353E+00, 6.2427550350E+00, 3.9769179122E-01, 3.5260404077E-01, 5.6545871927E-01],
	[1.0640000000E+04, 6.2015628703E+00, 6.2421519052E+00, 3.9828434331E-01, 3.5307993063E-01, 5.6563347484E-01],
	[1.0645000000E+04, 6.2052906942E+00, 6.2415491170E+00, 3.9887749903E-01, 3.5355617940E-01, 5.6580820187E-01],
	[1.0650000000E+04, 6.2090190068E+00, 6.2409466700E+00, 3.9947125869E-01, 3.5403278703E-01, 5.6598290031E-01],
	[1.0655000000E+04, 6.2127478080E+00, 6.2403445639E+00, 4.0006562264E-01, 3.5450975346E-01, 5.6615757017E-01],
	[1.0660000000E+04, 6.2164770975E+00, 6.2397427983E+00, 4.0066059120E-01, 3.5498707863E-01, 5.6633221141E-01],
	[1.0665000000E+04, 6.2202068751E+00, 6.2391413729E+00, 4.0125616471E-01, 3.5546476250E-01, 5.6650682401E-01],
	[1.0670000000E+04, 6.2239371409E+00, 6.2385402873E+00, 4.0185234348E-01, 3.5594280501E-01, 5.6668140796E-01],
	[1.0675000000E+04, 6.2276678944E+00, 6.2379395412E+00, 4.0244912787E-01, 3.5642120611E-01, 5.6685596323E-01],
	[1.0680000000E+04, 6.2313991357E+00, 6.2373391343E+00, 4.0304651819E-01, 3.5689996573E-01, 5.6703048980E-01],
	[1.0685000000E+04, 6.2351308646E+00, 6.2367390660E+00, 4.0364451477E-01, 3.5737908382E-01, 5.6720498766E-01],
	[1.0690000000E+04, 6.2388630808E+00, 6.2361393363E+00, 4.0424311796E-01, 3.5785856033E-01, 5.6737945678E-01],
	[1.0695000000E+04, 6.2425957842E+00, 6.2355399445E+00, 4.0484232807E-01, 3.5833839521E-01, 5.6755389714E-01],
	[1.0700000000E+04, 6.2463289746E+00, 6.2349408905E+00, 4.0544214544E-01, 3.5881858838E-01, 5.6772830872E-01],
	[1.0705000000E+04, 6.2500626519E+00, 6.2343421739E+00, 4.0604257040E-01, 3.5929913981E-01, 5.6790269151E-01],
	[1.0710000000E+04, 6.2537968160E+00, 6.2337437944E+00, 4.0664360327E-01, 3.5978004943E-01, 5.6807704549E-01],
	[1.0715000000E+04, 6.2575314666E+00, 6.2331457515E+00, 4.0724524440E-01, 3.6026131717E-01, 5.6825137062E-01],
	[1.0720000000E+04, 6.2612666036E+00, 6.2325480449E+00, 4.0784749412E-01, 3.6074294300E-01, 5.6842566690E-01],
	[1.0725000000E+04, 6.2650022268E+00, 6.2319506743E+00, 4.0845035274E-01, 3.6122492684E-01, 5.6859993431E-01],
	[1.0730000000E+04, 6.2687383360E+00, 6.2313536394E+00, 4.0905382061E-01, 3.6170726863E-01, 5.6877417282E-01],
	[1.0735000000E+04, 6.2724749312E+00, 6.2307569398E+00, 4.0965789806E-01, 3.6218996833E-01, 5.6894838241E-01],
	[1.0740000000E+04, 6.2762120121E+00, 6.2301605751E+00, 4.1026258541E-01, 3.6267302587E-01, 5.6912256307E-01],
	[1.0745000000E+04, 6.2799495786E+00, 6.2295645451E+00, 4.1086788299E-01, 3.6315644118E-01, 5.6929671478E-01],
	[1.0750000000E+04, 6.2836876305E+00, 6.2289688493E+00, 4.1147379115E-01, 3.6364021422E-01, 5.6947083751E-01],
	[1.0755000000E+04, 6.2874261676E+00, 6.2283734874E+00, 4.1208031020E-01, 3.6412434492E-01, 5.6964493125E-01],
	[1.0760000000E+04, 6.2911651898E+00, 6.2277784592E+00, 4.1268744049E-01, 3.6460883322E-01, 5.6981899598E-01],
	[1.0765000000E+04, 6.2949095444E+00, 6.2271885703E+00, 4.1329518234E-01, 3.6509371188E-01, 5.6999303168E-01],
	[1.0770000000E+04, 6.2986572633E+00, 6.2266018606E+00, 4.1390353607E-01, 3.6557896767E-01, 5.7016703833E-01],
	[1.0775000000E+04, 6.3024054723E+00, 6.2260154785E+00, 4.1451250204E-01, 3.6606458111E-01, 5.7034101591E-01],
	[1.0780000000E+04, 6.3061541714E+00, 6.2254294236E+00, 4.1512208055E-01, 3.6655055213E-01, 5.7051496440E-01],
	[1.0785000000E+04, 6.3099033603E+00, 6.2248436956E+00, 4.1573227196E-01, 3.6703688068E-01, 5.7068888379E-01],
	[1.0790000000E+04, 6.3136530389E+00, 6.2242582942E+00, 4.1634307658E-01, 3.6752356668E-01, 5.7086277404E-01],
	[1.0795000000E+04, 6.3174032071E+00, 6.2236732190E+00, 4.1695449475E-01, 3.6801061008E-01, 5.7103663516E-01],
	[1.0800000000E+04, 6.3211538647E+00, 6.2230884697E+00, 4.1756652680E-01, 3.6849801081E-01, 5.7121046711E-01],
	[1.0805000000E+04, 6.3249050114E+00, 6.2225040459E+00, 4.1817917306E-01, 3.6898576882E-01, 5.7138426988E-01],
	[1.0810000000E+04, 6.3286566472E+00, 6.2219199473E+00, 4.1879243386E-01, 3.6947388403E-01, 5.7155804344E-01],
	[1.0815000000E+04, 6.3324087719E+00, 6.2213361737E+00, 4.1940630954E-01, 3.6996235639E-01, 5.7173178779E-01],
	[1.0820000000E+04, 6.3361613854E+00, 6.2207527246E+00, 4.2002080042E-01, 3.7045118582E-01, 5.7190550290E-01],
	[1.0825000000E+04, 6.3399144874E+00, 6.2201695998E+00, 4.2063590684E-01, 3.7094037228E-01, 5.7207918875E-01],
	[1.0830000000E+04, 6.3436680778E+00, 6.2195867988E+00, 4.2125162913E-01, 3.7142991568E-01, 5.7225284533E-01],
	[1.0835000000E+04, 6.3474221564E+00, 6.2190043214E+00, 4.2186796762E-01, 3.7191981598E-01, 5.7242647261E-01],
	[1.0840000000E+04, 6.3511767232E+00, 6.2184221673E+00, 4.2248492264E-01, 3.7241007309E-01, 5.7260007059E-01],
	[1.0845000000E+04, 6.3549317778E+00, 6.2178403361E+00, 4.2310249452E-01, 3.7290068696E-01, 5.7277363923E-01],
	[1.0850000000E+04, 6.3586873202E+00, 6.2172588275E+00, 4.2372068360E-01, 3.7339165751E-01, 5.7294717852E-01],
	[1.0855000000E+04, 6.3624433502E+00, 6.2166776411E+00, 4.2433949020E-01, 3.7388298470E-01, 5.7312068845E-01],
	[1.0860000000E+04, 6.3661998676E+00, 6.2160967767E+00, 4.2495891466E-01, 3.7437466843E-01, 5.7329416899E-01],
	[1.0865000000E+04, 6.3699568723E+00, 6.2155162339E+00, 4.2557895731E-01, 3.7486670866E-01, 5.7346762013E-01],
	[1.0870000000E+04, 6.3737143641E+00, 6.2149360123E+00, 4.2619961848E-01, 3.7535910531E-01, 5.7364104185E-01],
	[1.0875000000E+04, 6.3774723429E+00, 6.2143561117E+00, 4.2682089851E-01, 3.7585185832E-01, 5.7381443413E-01],
	[1.0880000000E+04, 6.3812308084E+00, 6.2137765318E+00, 4.2744279771E-01, 3.7634496761E-01, 5.7398779695E-01],
	[1.0885000000E+04, 6.3849897606E+00, 6.2131972721E+00, 4.2806531644E-01, 3.7683843312E-01, 5.7416113030E-01],
	[1.0890000000E+04, 6.3887491992E+00, 6.2126183325E+00, 4.2868845501E-01, 3.7733225478E-01, 5.7433443416E-01],
	[1.0895000000E+04, 6.3925091242E+00, 6.2120397125E+00, 4.2931221376E-01, 3.7782643252E-01, 5.7450770851E-01],
	[1.0900000000E+04, 6.3962695353E+00, 6.2114614118E+00, 4.2993659302E-01, 3.7832096627E-01, 5.7468095333E-01],
	[1.0905000000E+04, 6.4000304323E+00, 6.2108834302E+00, 4.3056159312E-01, 3.7881585596E-01, 5.7485416861E-01],
	[1.0910000000E+04, 6.4037918153E+00, 6.2103057672E+00, 4.3118721440E-01, 3.7931110153E-01, 5.7502735432E-01],
	[1.0915000000E+04, 6.4075536838E+00, 6.2097284226E+00, 4.3181345719E-01, 3.7980670290E-01, 5.7520051045E-01],
	[1.0920000000E+04, 6.4113160379E+00, 6.2091513961E+00, 4.3244032181E-01, 3.8030266000E-01, 5.7537363699E-01],
	[1.0925000000E+04, 6.4150788773E+00, 6.2085746873E+00, 4.3306780861E-01, 3.8079897276E-01, 5.7554673391E-01],
	[1.0930000000E+04, 6.4188422020E+00, 6.2079982959E+00, 4.3369591791E-01, 3.8129564111E-01, 5.7571980119E-01],
	[1.0935000000E+04, 6.4226060116E+00, 6.2074222215E+00, 4.3432465004E-01, 3.8179266497E-01, 5.7589283883E-01],
	[1.0940000000E+04, 6.4263783003E+00, 6.2068538205E+00, 4.3495400534E-01, 3.8229010048E-01, 5.7606584680E-01],
	[1.0945000000E+04, 6.4301512638E+00, 6.2062859009E+00, 4.3558398414E-01, 3.8278789290E-01, 5.7623882509E-01],
	[1.0950000000E+04, 6.4339247178E+00, 6.2057182926E+00, 4.3621458677E-01, 3.8328604087E-01, 5.7641177368E-01],
	[1.0955000000E+04, 6.4376986620E+00, 6.2051509953E+00, 4.3684581356E-01, 3.8378454431E-01, 5.7658469254E-01],
	[1.0960000000E+04, 6.4414730963E+00, 6.2045840087E+00, 4.3747766485E-01, 3.8428340315E-01, 5.7675758168E-01],
	[1.0965000000E+04, 6.4452480205E+00, 6.2040173324E+00, 4.3811014096E-01, 3.8478261732E-01, 5.7693044106E-01],
	[1.0970000000E+04, 6.4490234345E+00, 6.2034509662E+00, 4.3874324223E-01, 3.8528218674E-01, 5.7710327067E-01],
	[1.0975000000E+04, 6.4527993381E+00, 6.2028849098E+00, 4.3937696900E-01, 3.8578211134E-01, 5.7727607050E-01],
	[1.0980000000E+04, 6.4565757311E+00, 6.2023191628E+00, 4.4001132158E-01, 3.8628239106E-01, 5.7744884052E-01],
	[1.0985000000E+04, 6.4603526134E+00, 6.2017537249E+00, 4.4064630033E-01, 3.8678302580E-01, 5.7762158072E-01],
	[1.0990000000E+04, 6.4641299849E+00, 6.2011885959E+00, 4.4128190556E-01, 3.8728401550E-01, 5.7779429109E-01],
	[1.0995000000E+04, 6.4679078453E+00, 6.2006237754E+00, 4.4191813761E-01, 3.8778536009E-01, 5.7796697161E-01],
	[1.1000000000E+04, 6.4716861945E+00, 6.2000592630E+00, 4.4255499681E-01, 3.8828705948E-01, 5.7813962225E-01],
	[1.1005000000E+04, 6.4754650323E+00, 6.1994950586E+00, 4.4319248350E-01, 3.8878911361E-01, 5.7831224301E-01],
	[1.1010000000E+04, 6.4792443587E+00, 6.1989311618E+00, 4.4383059800E-01, 3.8929152239E-01, 5.7848483387E-01],
	[1.1015000000E+04, 6.4830241734E+00, 6.1983675722E+00, 4.4446934066E-01, 3.8979428575E-01, 5.7865739481E-01],
	[1.1020000000E+04, 6.4868044762E+00, 6.1978042897E+00, 4.4510871180E-01, 3.9029740362E-01, 5.7882992581E-01],
	[1.1025000000E+04, 6.4905852671E+00, 6.1972413138E+00, 4.4574871175E-01, 3.9080087591E-01, 5.7900242686E-01],
	[1.1030000000E+04, 6.4943665458E+00, 6.1966786442E+00, 4.4638934085E-01, 3.9130470255E-01, 5.7917489795E-01],
	[1.1035000000E+04, 6.4981483122E+00, 6.1961162807E+00, 4.4703059942E-01, 3.9180888346E-01, 5.7934733905E-01],
	[1.1040000000E+04, 6.5019305662E+00, 6.1955542230E+00, 4.4767248781E-01, 3.9231341857E-01, 5.7951975015E-01],
	[1.1045000000E+04, 6.5057133075E+00, 6.1949924707E+00, 4.4831500635E-01, 3.9281830779E-01, 5.7969213124E-01],
	[1.1050000000E+04, 6.5094965360E+00, 6.1944310236E+00, 4.4895815536E-01, 3.9332355105E-01, 5.7986448229E-01],
	[1.1055000000E+04, 6.5132802516E+00, 6.1938698813E+00, 4.4960193518E-01, 3.9382914827E-01, 5.8003680329E-01],
	[1.1060000000E+04, 6.5170644542E+00, 6.1933090435E+00, 4.5024634614E-01, 3.9433509937E-01, 5.8020909423E-01],
	[1.1065000000E+04, 6.5208491434E+00, 6.1927485100E+00, 4.5089138857E-01, 3.9484140427E-01, 5.8038135509E-01],
	[1.1070000000E+04, 6.5246343193E+00, 6.1921882804E+00, 4.5153706282E-01, 3.9534806288E-01, 5.8055358586E-01],
	[1.1075000000E+04, 6.5284199816E+00, 6.1916283544E+00, 4.5218336920E-01, 3.9585507514E-01, 5.8072578651E-01],
	[1.1080000000E+04, 6.5322061302E+00, 6.1910687318E+00, 4.5283030806E-01, 3.9636244095E-01, 5.8089795704E-01],
	[1.1085000000E+04, 6.5359927649E+00, 6.1905094121E+00, 4.5347787972E-01, 3.9687016024E-01, 5.8107009742E-01],
	[1.1090000000E+04, 6.5397798855E+00, 6.1899503953E+00, 4.5412608451E-01, 3.9737823293E-01, 5.8124220764E-01],
	[1.1095000000E+04, 6.5435674920E+00, 6.1893916808E+00, 4.5477492278E-01, 3.9788665894E-01, 5.8141428769E-01],
	[1.1100000000E+04, 6.5473555841E+00, 6.1888332685E+00, 4.5542439486E-01, 3.9839543818E-01, 5.8158633755E-01],
	[1.1105000000E+04, 6.5511441617E+00, 6.1882751579E+00, 4.5607450107E-01, 3.9890457057E-01, 5.8175835721E-01],
	[1.1110000000E+04, 6.5549332247E+00, 6.1877173490E+00, 4.5672524175E-01, 3.9941405602E-01, 5.8193034664E-01],
	[1.1115000000E+04, 6.5587294182E+00, 6.1871655343E+00, 4.5737661723E-01, 3.9992394296E-01, 5.8210230584E-01],
	[1.1120000000E+04, 6.5625280941E+00, 6.1866157232E+00, 4.5802862784E-01, 4.0043419757E-01, 5.8227423474E-01],
	[1.1125000000E+04, 6.5663272611E+00, 6.1860662080E+00, 4.5868127392E-01, 4.0094480527E-01, 5.8244613328E-01],
	[1.1130000000E+04, 6.5701269189E+00, 6.1855169885E+00, 4.5933455581E-01, 4.0145576596E-01, 5.8261800141E-01],
	[1.1135000000E+04, 6.5739270673E+00, 6.1849680644E+00, 4.5998847383E-01, 4.0196707956E-01, 5.8278983912E-01],
	[1.1140000000E+04, 6.5777277063E+00, 6.1844194355E+00, 4.6064302831E-01, 4.0247874600E-01, 5.8296164635E-01],
	[1.1145000000E+04, 6.5815288356E+00, 6.1838711013E+00, 4.6129821960E-01, 4.0299076518E-01, 5.8313342310E-01],
	[1.1150000000E+04, 6.5853304551E+00, 6.1833230617E+00, 4.6195404801E-01, 4.0350313703E-01, 5.8330516933E-01],
	[1.1155000000E+04, 6.5891325646E+00, 6.1827753163E+00, 4.6261051389E-01, 4.0401586146E-01, 5.8347688500E-01],
	[1.1160000000E+04, 6.5929351640E+00, 6.1822278649E+00, 4.6326761758E-01, 4.0452893838E-01, 5.8364857009E-01],
	[1.1165000000E+04, 6.5967382531E+00, 6.1816807071E+00, 4.6392535939E-01, 4.0504236770E-01, 5.8382022458E-01],
	[1.1170000000E+04, 6.6005418318E+00, 6.1811338427E+00, 4.6458373967E-01, 4.0555614935E-01, 5.8399184842E-01],
	[1.1175000000E+04, 6.6043458999E+00, 6.1805872714E+00, 4.6524275874E-01, 4.0607028323E-01, 5.8416344159E-01],
	[1.1180000000E+04, 6.6081504572E+00, 6.1800409929E+00, 4.6590241695E-01, 4.0658476926E-01, 5.8433500406E-01],
	[1.1185000000E+04, 6.6119555036E+00, 6.1794950069E+00, 4.6656566751E-01, 4.0710185552E-01, 5.8450653580E-01],
	[1.1190000000E+04, 6.6157610390E+00, 6.1789493131E+00, 4.6722975369E-01, 4.0761944143E-01, 5.8467803678E-01],
	[1.1195000000E+04, 6.6195670631E+00, 6.1784039112E+00, 4.6789448758E-01, 4.0813738355E-01, 5.8484950697E-01],
	[1.1200000000E+04, 6.6233735759E+00, 6.1778588010E+00, 4.6855986952E-01, 4.0865568178E-01, 5.8502094635E-01],
	[1.1205000000E+04, 6.6271805772E+00, 6.1773139821E+00, 4.6922589985E-01, 4.0917433604E-01, 5.8519235488E-01],
	[1.1210000000E+04, 6.6309880668E+00, 6.1767694544E+00, 4.6989257892E-01, 4.0969334624E-01, 5.8536373253E-01],
	[1.1215000000E+04, 6.6347960445E+00, 6.1762252174E+00, 4.7055990707E-01, 4.1021271229E-01, 5.8553507928E-01],
	[1.1220000000E+04, 6.6386045102E+00, 6.1756812709E+00, 4.7122788463E-01, 4.1073243410E-01, 5.8570639510E-01],
	[1.1225000000E+04, 6.6424134638E+00, 6.1751376146E+00, 4.7189651195E-01, 4.1125251159E-01, 5.8587767995E-01],
	[1.1230000000E+04, 6.6462229051E+00, 6.1745942483E+00, 4.7256578938E-01, 4.1177294466E-01, 5.8604893381E-01],
	[1.1235000000E+04, 6.6500328340E+00, 6.1740511716E+00, 4.7323571725E-01, 4.1229373322E-01, 5.8622015665E-01],
	[1.1240000000E+04, 6.6538432502E+00, 6.1735083843E+00, 4.7390629590E-01, 4.1281487719E-01, 5.8639134844E-01],
	[1.1245000000E+04, 6.6576541537E+00, 6.1729658861E+00, 4.7457752568E-01, 4.1333637647E-01, 5.8656250916E-01],
	[1.1250000000E+04, 6.6614655442E+00, 6.1724236767E+00, 4.7524940694E-01, 4.1385823097E-01, 5.8673363877E-01],
	[1.1255000000E+04, 6.6652774217E+00, 6.1718817558E+00, 4.7592194000E-01, 4.1438044061E-01, 5.8690473724E-01],
	[1.1260000000E+04, 6.6690897859E+00, 6.1713401231E+00, 4.7659512522E-01, 4.1490300529E-01, 5.8707580455E-01],
	[1.1265000000E+04, 6.6729026367E+00, 6.1707987784E+00, 4.7726896293E-01, 4.1542592491E-01, 5.8724684067E-01],
	[1.1270000000E+04, 6.6767159741E+00, 6.1702577214E+00, 4.7794345348E-01, 4.1594919940E-01, 5.8741784557E-01],
	[1.1275000000E+04, 6.6805297977E+00, 6.1697169518E+00, 4.7861859721E-01, 4.1647282864E-01, 5.8758881922E-01],
	[1.1280000000E+04, 6.6843441075E+00, 6.1691764693E+00, 4.7929439447E-01, 4.1699681256E-01, 5.8775976159E-01],
	[1.1285000000E+04, 6.6881589032E+00, 6.1686362736E+00, 4.7997084558E-01, 4.1752115106E-01, 5.8793067266E-01],
	[1.1290000000E+04, 6.6919741849E+00, 6.1680963645E+00, 4.8064795091E-01, 4.1804584405E-01, 5.8810155240E-01],
	[1.1295000000E+04, 6.6957990040E+00, 6.1675639763E+00, 4.8132571078E-01, 4.1857096012E-01, 5.8827240077E-01],
	[1.1300000000E+04, 6.6996243653E+00, 6.1670319097E+00, 4.8200412554E-01, 4.1909643115E-01, 5.8844321776E-01],
	[1.1305000000E+04, 6.7034502183E+00, 6.1665001244E+00, 4.8268319554E-01, 4.1962225667E-01, 5.8861400333E-01],
	[1.1310000000E+04, 6.7072765630E+00, 6.1659686200E+00, 4.8336292111E-01, 4.2014843658E-01, 5.8878475745E-01],
	[1.1315000000E+04, 6.7111033990E+00, 6.1654373963E+00, 4.8404330260E-01, 4.2067497079E-01, 5.8895548011E-01],
	[1.1320000000E+04, 6.7149307264E+00, 6.1649064531E+00, 4.8472434035E-01, 4.2120185920E-01, 5.8912617126E-01],
	[1.1325000000E+04, 6.7187585448E+00, 6.1643757900E+00, 4.8540603471E-01, 4.2172910172E-01, 5.8929683089E-01],
	[1.1330000000E+04, 6.7225868543E+00, 6.1638454068E+00, 4.8608838601E-01, 4.2225669825E-01, 5.8946745896E-01],
	[1.1335000000E+04, 6.7264156545E+00, 6.1633153033E+00, 4.8677139459E-01, 4.2278464869E-01, 5.8963805544E-01],
	[1.1340000000E+04, 6.7302449455E+00, 6.1627854790E+00, 4.8745506081E-01, 4.2331295296E-01, 5.8980862032E-01],
	[1.1345000000E+04, 6.7340747269E+00, 6.1622559339E+00, 4.8813938500E-01, 4.2384161096E-01, 5.8997915356E-01],
	[1.1350000000E+04, 6.7379049987E+00, 6.1617266675E+00, 4.8882436750E-01, 4.2437062258E-01, 5.9014965513E-01],
	[1.1355000000E+04, 6.7417357607E+00, 6.1611976797E+00, 4.8951000866E-01, 4.2489998773E-01, 5.9032012502E-01],
	[1.1360000000E+04, 6.7455670128E+00, 6.1606689701E+00, 4.9019630882E-01, 4.2542970631E-01, 5.9049056318E-01],
	[1.1365000000E+04, 6.7493987548E+00, 6.1601405385E+00, 4.9088326832E-01, 4.2595977824E-01, 5.9066096960E-01],
	[1.1370000000E+04, 6.7532309865E+00, 6.1596123847E+00, 4.9157088751E-01, 4.2649020340E-01, 5.9083134424E-01],
	[1.1375000000E+04, 6.7570637078E+00, 6.1590845083E+00, 4.9225916673E-01, 4.2702098170E-01, 5.9100168708E-01],
	[1.1380000000E+04, 6.7608969185E+00, 6.1585569091E+00, 4.9294810632E-01, 4.2755211304E-01, 5.9117199809E-01],
	[1.1385000000E+04, 6.7647306186E+00, 6.1580295869E+00, 4.9363770662E-01, 4.2808359732E-01, 5.9134227725E-01],
	[1.1390000000E+04, 6.7685648077E+00, 6.1575025413E+00, 4.9432796797E-01, 4.2861543445E-01, 5.9151252453E-01],
	[1.1395000000E+04, 6.7723994859E+00, 6.1569757720E+00, 4.9501889073E-01, 4.2914762431E-01, 5.9168273990E-01],
	[1.1400000000E+04, 6.7762346529E+00, 6.1564492790E+00, 4.9571047522E-01, 4.2968016683E-01, 5.9185292334E-01],
	[1.1405000000E+04, 6.7800703086E+00, 6.1559230617E+00, 4.9640272181E-01, 4.3021306188E-01, 5.9202307481E-01],
	[1.1410000000E+04, 6.7839064528E+00, 6.1553971201E+00, 4.9709563081E-01, 4.3074630938E-01, 5.9219319429E-01],
	[1.1415000000E+04, 6.7877430853E+00, 6.1548714538E+00, 4.9778920259E-01, 4.3127990922E-01, 5.9236328176E-01],
	[1.1420000000E+04, 6.7915802061E+00, 6.1543460625E+00, 4.9848343748E-01, 4.3181386130E-01, 5.9253333719E-01],
	[1.1425000000E+04, 6.7954178150E+00, 6.1538209461E+00, 4.9917833583E-01, 4.3234816552E-01, 5.9270336056E-01],
	[1.1430000000E+04, 6.7992559118E+00, 6.1532961042E+00, 4.9987389798E-01, 4.3288282178E-01, 5.9287335182E-01],
	[1.1435000000E+04, 6.8030944964E+00, 6.1527715365E+00, 5.0057012427E-01, 4.3341782997E-01, 5.9304331097E-01],
	[1.1440000000E+04, 6.8069335686E+00, 6.1522472429E+00, 5.0126701504E-01, 4.3395318999E-01, 5.9321323797E-01],
	[1.1445000000E+04, 6.8107731282E+00, 6.1517232230E+00, 5.0196457064E-01, 4.3448890174E-01, 5.9338313280E-01],
	[1.1450000000E+04, 6.8146131752E+00, 6.1511994766E+00, 5.0266279141E-01, 4.3502496512E-01, 5.9355299543E-01],
	[1.1455000000E+04, 6.8184537093E+00, 6.1506760035E+00, 5.0336167770E-01, 4.3556138002E-01, 5.9372282583E-01],
	[1.1460000000E+04, 6.8222947305E+00, 6.1501528032E+00, 5.0406122984E-01, 4.3609814634E-01, 5.9389262399E-01],
	[1.1465000000E+04, 6.8261362385E+00, 6.1496298757E+00, 5.0476144819E-01, 4.3663526398E-01, 5.9406238986E-01],
	[1.1470000000E+04, 6.8299782332E+00, 6.1491072206E+00, 5.0546233307E-01, 4.3717273282E-01, 5.9423212344E-01],
	[1.1475000000E+04, 6.8338268740E+00, 6.1485894421E+00, 5.0616388485E-01, 4.3771060138E-01, 5.9440182469E-01],
	[1.1480000000E+04, 6.8376794165E+00, 6.1480744808E+00, 5.0686610385E-01, 4.3824884808E-01, 5.9457149358E-01],
	[1.1485000000E+04, 6.8415324520E+00, 6.1475597869E+00, 5.0756899043E-01, 4.3878744599E-01, 5.9474113009E-01],
	[1.1490000000E+04, 6.8453859801E+00, 6.1470453601E+00, 5.0827254492E-01, 4.3932639498E-01, 5.9491073420E-01],
	[1.1495000000E+04, 6.8492400008E+00, 6.1465312001E+00, 5.0897676767E-01, 4.3986569496E-01, 5.9508030587E-01],
	[1.1500000000E+04, 6.8530945139E+00, 6.1460173067E+00, 5.0968165903E-01, 4.4040534582E-01, 5.9524984509E-01],
	[1.1505000000E+04, 6.8569495193E+00, 6.1455036796E+00, 5.1038721933E-01, 4.4094534745E-01, 5.9541935183E-01],
	[1.1510000000E+04, 6.8608050168E+00, 6.1449903186E+00, 5.1109344892E-01, 4.4148569975E-01, 5.9558882606E-01],
	[1.1515000000E+04, 6.8646610062E+00, 6.1444772233E+00, 5.1180034815E-01, 4.4202640261E-01, 5.9575826776E-01],
	[1.1520000000E+04, 6.8685174875E+00, 6.1439643937E+00, 5.1250791735E-01, 4.4256745592E-01, 5.9592767690E-01],
	[1.1525000000E+04, 6.8723744604E+00, 6.1434518293E+00, 5.1321615687E-01, 4.4310885957E-01, 5.9609705345E-01],
	[1.1530000000E+04, 6.8762319248E+00, 6.1429395300E+00, 5.1392506705E-01, 4.4365061347E-01, 5.9626639740E-01],
	[1.1535000000E+04, 6.8800898806E+00, 6.1424274956E+00, 5.1463464825E-01, 4.4419271749E-01, 5.9643570872E-01],
	[1.1540000000E+04, 6.8839483275E+00, 6.1419157256E+00, 5.1534490079E-01, 4.4473517154E-01, 5.9660498737E-01],
	[1.1545000000E+04, 6.8878072656E+00, 6.1414042200E+00, 5.1605582502E-01, 4.4527797550E-01, 5.9677423335E-01],
	[1.1550000000E+04, 6.8916666945E+00, 6.1408929784E+00, 5.1676742130E-01, 4.4582112926E-01, 5.9694344661E-01],
	[1.1555000000E+04, 6.8955266142E+00, 6.1403820006E+00, 5.1747968995E-01, 4.4636463271E-01, 5.9711262714E-01],
	[1.1560000000E+04, 6.8993870244E+00, 6.1398712864E+00, 5.1819263133E-01, 4.4690848575E-01, 5.9728177492E-01],
	[1.1565000000E+04, 6.9032479252E+00, 6.1393608354E+00, 5.1890624578E-01, 4.4745268827E-01, 5.9745088991E-01],
	[1.1570000000E+04, 6.9071093162E+00, 6.1388506475E+00, 5.1962053364E-01, 4.4799724015E-01, 5.9761997209E-01],
	[1.1575000000E+04, 6.9109711974E+00, 6.1383407225E+00, 5.2033549526E-01, 4.4854214128E-01, 5.9778902145E-01],
	[1.1580000000E+04, 6.9148335686E+00, 6.1378310599E+00, 5.2105113098E-01, 4.4908739156E-01, 5.9795803794E-01],
	[1.1585000000E+04, 6.9186964297E+00, 6.1373216597E+00, 5.2176744114E-01, 4.4963299086E-01, 5.9812702156E-01],
	[1.1590000000E+04, 6.9225597805E+00, 6.1368125215E+00, 5.2248442608E-01, 4.5017893909E-01, 5.9829597227E-01],
	[1.1595000000E+04, 6.9264236208E+00, 6.1363036451E+00, 5.2320208616E-01, 4.5072523612E-01, 5.9846489005E-01],
	[1.1600000000E+04, 6.9302879505E+00, 6.1357950303E+00, 5.2392042172E-01, 4.5127188185E-01, 5.9863377487E-01],
	[1.1605000000E+04, 6.9341527695E+00, 6.1352866768E+00, 5.2463943309E-01, 4.5181887617E-01, 5.9880262672E-01],
	[1.1610000000E+04, 6.9380180776E+00, 6.1347785844E+00, 5.2535912062E-01, 4.5236621895E-01, 5.9897144557E-01],
	[1.1615000000E+04, 6.9418838747E+00, 6.1342707528E+00, 5.2607948467E-01, 4.5291391009E-01, 5.9914023138E-01],
	[1.1620000000E+04, 6.9457501605E+00, 6.1337631818E+00, 5.2680052556E-01, 4.5346194947E-01, 5.9930898415E-01],
	[1.1625000000E+04, 6.9496169351E+00, 6.1332558711E+00, 5.2752224365E-01, 4.5401033699E-01, 5.9947770384E-01],
	[1.1630000000E+04, 6.9534841981E+00, 6.1327488204E+00, 5.2824463927E-01, 4.5455907252E-01, 5.9964639044E-01],
	[1.1635000000E+04, 6.9573519495E+00, 6.1322420297E+00, 5.2896771278E-01, 4.5510815595E-01, 5.9981504391E-01],
	[1.1640000000E+04, 6.9612201892E+00, 6.1317354985E+00, 5.2969146452E-01, 4.5565758716E-01, 5.9998366423E-01],
	[1.1645000000E+04, 6.9650889169E+00, 6.1312292266E+00, 5.3041589482E-01, 4.5620736605E-01, 6.0015225139E-01],
	[1.1650000000E+04, 6.9689581325E+00, 6.1307232139E+00, 5.3114100405E-01, 4.5675749249E-01, 6.0032080535E-01],
	[1.1655000000E+04, 6.9728278359E+00, 6.1302174600E+00, 5.3186679253E-01, 4.5730796637E-01, 6.0048932609E-01],
	[1.1660000000E+04, 6.9767051338E+00, 6.1297169418E+00, 5.3259326061E-01, 4.5785884595E-01, 6.0065781359E-01],
	[1.1665000000E+04, 6.9805858609E+00, 6.1292187347E+00, 5.3332040864E-01, 4.5841009713E-01, 6.0082626783E-01],
	[1.1670000000E+04, 6.9844670823E+00, 6.1287207815E+00, 5.3404823696E-01, 4.5896169572E-01, 6.0099468878E-01],
	[1.1675000000E+04, 6.9883487976E+00, 6.1282230820E+00, 5.3477674592E-01, 4.5951364161E-01, 6.0116307641E-01],
	[1.1680000000E+04, 6.9922310069E+00, 6.1277256360E+00, 5.3550593586E-01, 4.6006593467E-01, 6.0133143071E-01],
	[1.1685000000E+04, 6.9961137099E+00, 6.1272284433E+00, 5.3623580713E-01, 4.6061857480E-01, 6.0149975165E-01],
	[1.1690000000E+04, 6.9999969064E+00, 6.1267315036E+00, 5.3696636006E-01, 4.6117156187E-01, 6.0166803921E-01],
	[1.1695000000E+04, 7.0038805964E+00, 6.1262348167E+00, 5.3769759500E-01, 4.6172489577E-01, 6.0183629337E-01],
	[1.1700000000E+04, 7.0077647798E+00, 6.1257383823E+00, 5.3842951231E-01, 4.6227857637E-01, 6.0200451409E-01],
	[1.1705000000E+04, 7.0116494562E+00, 6.1252422003E+00, 5.3916211231E-01, 4.6283260357E-01, 6.0217270137E-01],
	[1.1710000000E+04, 7.0155346256E+00, 6.1247462703E+00, 5.3989539537E-01, 4.6338697723E-01, 6.0234085517E-01],
	[1.1715000000E+04, 7.0194202879E+00, 6.1242505921E+00, 5.4062936181E-01, 4.6394169725E-01, 6.0250897547E-01],
	[1.1720000000E+04, 7.0233064429E+00, 6.1237551656E+00, 5.4136401199E-01, 4.6449676350E-01, 6.0267706225E-01],
	[1.1725000000E+04, 7.0271930904E+00, 6.1232599904E+00, 5.4209934624E-01, 4.6505217587E-01, 6.0284511549E-01],
	[1.1730000000E+04, 7.0310802303E+00, 6.1227650663E+00, 5.4283536493E-01, 4.6560793423E-01, 6.0301313516E-01],
	[1.1735000000E+04, 7.0349678625E+00, 6.1222703932E+00, 5.4357206838E-01, 4.6616403846E-01, 6.0318112125E-01],
	[1.1740000000E+04, 7.0388559868E+00, 6.1217759707E+00, 5.4430945694E-01, 4.6672048845E-01, 6.0334907372E-01],
	[1.1745000000E+04, 7.0427446031E+00, 6.1212817986E+00, 5.4504753097E-01, 4.6727728407E-01, 6.0351699256E-01],
	[1.1750000000E+04, 7.0466337111E+00, 6.1207878767E+00, 5.4578629079E-01, 4.6783442520E-01, 6.0368487774E-01],
	[1.1755000000E+04, 7.0505233108E+00, 6.1202942048E+00, 5.4652573677E-01, 4.6839191172E-01, 6.0385272924E-01],
	[1.1760000000E+04, 7.0544134021E+00, 6.1198007827E+00, 5.4726586923E-01, 4.6894974351E-01, 6.0402054704E-01],
	[1.1765000000E+04, 7.0583039847E+00, 6.1193076100E+00, 5.4800668854E-01, 4.6950792044E-01, 6.0418833111E-01],
	[1.1770000000E+04, 7.0621950585E+00, 6.1188146866E+00, 5.4874819502E-01, 4.7006644240E-01, 6.0435608144E-01],
	[1.1775000000E+04, 7.0660866235E+00, 6.1183220122E+00, 5.4949038903E-01, 4.7062530925E-01, 6.0452379800E-01],
	[1.1780000000E+04, 7.0699786793E+00, 6.1178295866E+00, 5.5023327091E-01, 4.7118452089E-01, 6.0469148077E-01],
	[1.1785000000E+04, 7.0738712259E+00, 6.1173374096E+00, 5.5097684101E-01, 4.7174407718E-01, 6.0485912972E-01],
	[1.1790000000E+04, 7.0777642632E+00, 6.1168454810E+00, 5.5172109967E-01, 4.7230397800E-01, 6.0502674484E-01],
	[1.1795000000E+04, 7.0816577910E+00, 6.1163538004E+00, 5.5246604724E-01, 4.7286422323E-01, 6.0519432610E-01],
	[1.1800000000E+04, 7.0855518091E+00, 6.1158623678E+00, 5.5321168405E-01, 4.7342481274E-01, 6.0536187348E-01],
	[1.1805000000E+04, 7.0894463174E+00, 6.1153711827E+00, 5.5395801046E-01, 4.7398574640E-01, 6.0552938696E-01],
	[1.1810000000E+04, 7.0933413157E+00, 6.1148802451E+00, 5.5470502682E-01, 4.7454702410E-01, 6.0569686651E-01],
	[1.1815000000E+04, 7.0972368040E+00, 6.1143895547E+00, 5.5545273345E-01, 4.7510864571E-01, 6.0586431212E-01],
	[1.1820000000E+04, 7.1011327820E+00, 6.1138991113E+00, 5.5620113072E-01, 4.7567061110E-01, 6.0603172376E-01],
	[1.1825000000E+04, 7.1050292497E+00, 6.1134089146E+00, 5.5695021897E-01, 4.7623292015E-01, 6.0619910141E-01],
	[1.1830000000E+04, 7.1089262068E+00, 6.1129189644E+00, 5.5769999853E-01, 4.7679557273E-01, 6.0636644505E-01],
	[1.1835000000E+04, 7.1128236533E+00, 6.1124292605E+00, 5.5845046976E-01, 4.7735856871E-01, 6.0653375466E-01],
	[1.1840000000E+04, 7.1167215889E+00, 6.1119398026E+00, 5.5920163300E-01, 4.7792190796E-01, 6.0670103021E-01],
	[1.1845000000E+04, 7.1206218756E+00, 6.1114518149E+00, 5.5995348860E-01, 4.7848560628E-01, 6.0686827169E-01],
	[1.1850000000E+04, 7.1245313122E+00, 6.1109697628E+00, 5.6070603690E-01, 4.7904972181E-01, 6.0703547907E-01],
	[1.1855000000E+04, 7.1284412446E+00, 6.1104879521E+00, 5.6145927824E-01, 4.7961418057E-01, 6.0720265233E-01],
	[1.1860000000E+04, 7.1323516727E+00, 6.1100063825E+00, 5.6221321298E-01, 4.8017898244E-01, 6.0736979145E-01],
	[1.1865000000E+04, 7.1362625963E+00, 6.1095250538E+00, 5.6296784145E-01, 4.8074412729E-01, 6.0753689641E-01],
	[1.1870000000E+04, 7.1401740154E+00, 6.1090439658E+00, 5.6372316401E-01, 4.8130961499E-01, 6.0770396718E-01],
	[1.1875000000E+04, 7.1440859297E+00, 6.1085631183E+00, 5.6447918099E-01, 4.8187544542E-01, 6.0787100376E-01],
	[1.1880000000E+04, 7.1479983391E+00, 6.1080825110E+00, 5.6523589274E-01, 4.8244161844E-01, 6.0803800610E-01],
	[1.1885000000E+04, 7.1519112435E+00, 6.1076021437E+00, 5.6599329962E-01, 4.8300813393E-01, 6.0820497420E-01],
	[1.1890000000E+04, 7.1558246427E+00, 6.1071220162E+00, 5.6675140195E-01, 4.8357499176E-01, 6.0837190799E-01],
	[1.1895000000E+04, 7.1597385366E+00, 6.1066421283E+00, 5.6751020010E-01, 4.8414219179E-01, 6.0853880743E-01],
	[1.1900000000E+04, 7.1636529250E+00, 6.1061624798E+00, 5.6826969440E-01, 4.8470973391E-01, 6.0870567249E-01],
	[1.1905000000E+04, 7.1675678077E+00, 6.1056830704E+00, 5.6902988520E-01, 4.8527761797E-01, 6.0887250314E-01],
	[1.1910000000E+04, 7.1714831847E+00, 6.1052038999E+00, 5.6979077284E-01, 4.8584584385E-01, 6.0903929936E-01],
	[1.1915000000E+04, 7.1753990558E+00, 6.1047249682E+00, 5.7055235768E-01, 4.8641441141E-01, 6.0920606111E-01],
	[1.1920000000E+04, 7.1793154208E+00, 6.1042462749E+00, 5.7131464005E-01, 4.8698332053E-01, 6.0937278837E-01],
	[1.1925000000E+04, 7.1832322797E+00, 6.1037678199E+00, 5.7207762030E-01, 4.8755257108E-01, 6.0953948109E-01],
	[1.1930000000E+04, 7.1871496322E+00, 6.1032896029E+00, 5.7284129878E-01, 4.8812216292E-01, 6.0970613926E-01],
	[1.1935000000E+04, 7.1910674782E+00, 6.1028116237E+00, 5.7360567584E-01, 4.8869209591E-01, 6.0987276284E-01],
	[1.1940000000E+04, 7.1949858175E+00, 6.1023338822E+00, 5.7437075181E-01, 4.8926236994E-01, 6.1003935181E-01],
	[1.1945000000E+04, 7.1989046501E+00, 6.1018563781E+00, 5.7513652705E-01, 4.8983298486E-01, 6.1020590613E-01],
	[1.1950000000E+04, 7.2028239758E+00, 6.1013791111E+00, 5.7590300189E-01, 4.9040394055E-01, 6.1037242577E-01],
	[1.1955000000E+04, 7.2067437943E+00, 6.1009020811E+00, 5.7667017669E-01, 4.9097523686E-01, 6.1053891071E-01],
	[1.1960000000E+04, 7.2106641057E+00, 6.1004252878E+00, 5.7743805180E-01, 4.9154687367E-01, 6.1070536092E-01],
	[1.1965000000E+04, 7.2145849097E+00, 6.0999487311E+00, 5.7820662755E-01, 4.9211885084E-01, 6.1087177636E-01],
	[1.1970000000E+04, 7.2185062063E+00, 6.0994724106E+00, 5.7897590429E-01, 4.9269116824E-01, 6.1103815701E-01],
	[1.1975000000E+04, 7.2224279951E+00, 6.0989963263E+00, 5.7974588237E-01, 4.9326382573E-01, 6.1120450283E-01],
	[1.1980000000E+04, 7.2263502762E+00, 6.0985204778E+00, 5.8051656214E-01, 4.9383682318E-01, 6.1137081381E-01],
	[1.1985000000E+04, 7.2302730494E+00, 6.0980448651E+00, 5.8128794394E-01, 4.9441016045E-01, 6.1153708990E-01],
	[1.1990000000E+04, 7.2341963144E+00, 6.0975694877E+00, 5.8206002811E-01, 4.9498383742E-01, 6.1170333108E-01],
	[1.1995000000E+04, 7.2381200713E+00, 6.0970943456E+00, 5.8283281500E-01, 4.9555785393E-01, 6.1186953733E-01],
	[1.2000000000E+04, 7.2420443198E+00, 6.0966194385E+00, 5.8360630497E-01, 4.9613220986E-01, 6.1203570861E-01],
	[1.2005000000E+04, 7.2459690598E+00, 6.0961447662E+00, 5.8438049835E-01, 4.9670690507E-01, 6.1220184489E-01],
	[1.2010000000E+04, 7.2498942911E+00, 6.0956703285E+00, 5.8515539548E-01, 4.9728193942E-01, 6.1236794615E-01],
	[1.2015000000E+04, 7.2538200137E+00, 6.0951961252E+00, 5.8593099673E-01, 4.9785731278E-01, 6.1253401236E-01],
	[1.2020000000E+04, 7.2577462273E+00, 6.0947221560E+00, 5.8670730242E-01, 4.9843302500E-01, 6.1270004348E-01],
	[1.2025000000E+04, 7.2616729318E+00, 6.0942484208E+00, 5.8748431292E-01, 4.9900907596E-01, 6.1286603949E-01],
	[1.2030000000E+04, 7.2656001271E+00, 6.0937749193E+00, 5.8826202856E-01, 4.9958546551E-01, 6.1303200036E-01],
	[1.2035000000E+04, 7.2695282772E+00, 6.0933019383E+00, 5.8904044968E-01, 5.0016219765E-01, 6.1319792607E-01],
	[1.2040000000E+04, 7.2734674587E+00, 6.0928357033E+00, 5.8981957665E-01, 5.0073936207E-01, 6.1336381658E-01],
	[1.2045000000E+04, 7.2774071378E+00, 6.0923696974E+00, 5.9059940980E-01, 5.0131686502E-01, 6.1352967186E-01],
	[1.2050000000E+04, 7.2813473145E+00, 6.0919039206E+00, 5.9137994947E-01, 5.0189470638E-01, 6.1369549189E-01],
	[1.2055000000E+04, 7.2852879886E+00, 6.0914383726E+00, 5.9216119603E-01, 5.0247288601E-01, 6.1386127664E-01],
	[1.2060000000E+04, 7.2892291599E+00, 6.0909730532E+00, 5.9294314980E-01, 5.0305140375E-01, 6.1402702608E-01],
	[1.2065000000E+04, 7.2931708283E+00, 6.0905079622E+00, 5.9372581114E-01, 5.0363025949E-01, 6.1419274019E-01],
	[1.2070000000E+04, 7.2971129937E+00, 6.0900430994E+00, 5.9450918040E-01, 5.0420945306E-01, 6.1435841893E-01],
	[1.2075000000E+04, 7.3010556560E+00, 6.0895784646E+00, 5.9529325791E-01, 5.0478898435E-01, 6.1452406227E-01],
	[1.2080000000E+04, 7.3049988149E+00, 6.0891140576E+00, 5.9607804404E-01, 5.0536885320E-01, 6.1468967020E-01],
	[1.2085000000E+04, 7.3089424703E+00, 6.0886498782E+00, 5.9686353911E-01, 5.0594905947E-01, 6.1485524267E-01],
	[1.2090000000E+04, 7.3128866221E+00, 6.0881859261E+00, 5.9764974349E-01, 5.0652960303E-01, 6.1502077967E-01],
	[1.2095000000E+04, 7.3168312702E+00, 6.0877222012E+00, 5.9843665751E-01, 5.0711048373E-01, 6.1518628117E-01],
	[1.2100000000E+04, 7.3207764144E+00, 6.0872587032E+00, 5.9922428152E-01, 5.0769170143E-01, 6.1535174713E-01],
	[1.2105000000E+04, 7.3247220546E+00, 6.0867954321E+00, 6.0001261587E-01, 5.0827325599E-01, 6.1551717754E-01],
	[1.2110000000E+04, 7.3286681906E+00, 6.0863323874E+00, 6.0080166091E-01, 5.0885514727E-01, 6.1568257235E-01],
	[1.2115000000E+04, 7.3326148223E+00, 6.0858695691E+00, 6.0159141698E-01, 5.0943737512E-01, 6.1584793156E-01],
	[1.2120000000E+04, 7.3365619495E+00, 6.0854069770E+00, 6.0238188442E-01, 5.1001993941E-01, 6.1601325512E-01],
	[1.2125000000E+04, 7.3405095721E+00, 6.0849446108E+00, 6.0317306360E-01, 5.1060283999E-01, 6.1617854301E-01],
	[1.2130000000E+04, 7.3444576899E+00, 6.0844824703E+00, 6.0396495484E-01, 5.1118607671E-01, 6.1634379521E-01],
	[1.2135000000E+04, 7.3484063029E+00, 6.0840205553E+00, 6.0475755850E-01, 5.1176964944E-01, 6.1650901168E-01],
	[1.2140000000E+04, 7.3523554108E+00, 6.0835588657E+00, 6.0555087493E-01, 5.1235355802E-01, 6.1667419240E-01],
	[1.2145000000E+04, 7.3563050136E+00, 6.0830974012E+00, 6.0634490447E-01, 5.1293780232E-01, 6.1683933735E-01],
	[1.2150000000E+04, 7.3602551111E+00, 6.0826361617E+00, 6.0713964746E-01, 5.1352238219E-01, 6.1700444649E-01],
	[1.2155000000E+04, 7.3642057031E+00, 6.0821751468E+00, 6.0793510426E-01, 5.1410729749E-01, 6.1716951979E-01],
	[1.2160000000E+04, 7.3681567895E+00, 6.0817143565E+00, 6.0873127522E-01, 5.1469254807E-01, 6.1733455724E-01],
	[1.2165000000E+04, 7.3721083702E+00, 6.0812537905E+00, 6.0952816067E-01, 5.1527813378E-01, 6.1749955881E-01],
	[1.2170000000E+04, 7.3760604449E+00, 6.0807934486E+00, 6.1032576097E-01, 5.1586405448E-01, 6.1766452446E-01],
	[1.2175000000E+04, 7.3800130137E+00, 6.0803333307E+00, 6.1112407645E-01, 5.1645031003E-01, 6.1782945417E-01],
	[1.2180000000E+04, 7.3839660763E+00, 6.0798734364E+00, 6.1192310748E-01, 5.1703690027E-01, 6.1799434792E-01],
	[1.2185000000E+04, 7.3879196326E+00, 6.0794137657E+00, 6.1272285440E-01, 5.1762382507E-01, 6.1815920567E-01],
	[1.2190000000E+04, 7.3918736825E+00, 6.0789543183E+00, 6.1352331754E-01, 5.1821108427E-01, 6.1832402741E-01],
	[1.2195000000E+04, 7.3958282258E+00, 6.0784950940E+00, 6.1432449727E-01, 5.1879867773E-01, 6.1848881310E-01],
	[1.2200000000E+04, 7.3997832623E+00, 6.0780360926E+00, 6.1512639392E-01, 5.1938660529E-01, 6.1865356272E-01],
	[1.2205000000E+04, 7.4037387920E+00, 6.0775773139E+00, 6.1592900785E-01, 5.1997486682E-01, 6.1881827624E-01],
	[1.2210000000E+04, 7.4076948147E+00, 6.0771187578E+00, 6.1673233940E-01, 5.2056346216E-01, 6.1898295364E-01],
	[1.2215000000E+04, 7.4116513302E+00, 6.0766604239E+00, 6.1753638891E-01, 5.2115239117E-01, 6.1914759489E-01],
	[1.2220000000E+04, 7.4156083385E+00, 6.0762023122E+00, 6.1834115674E-01, 5.2174165370E-01, 6.1931219996E-01],
	[1.2225000000E+04, 7.4195658393E+00, 6.0757444224E+00, 6.1914664324E-01, 5.2233124959E-01, 6.1947676883E-01],
	[1.2230000000E+04, 7.4235272042E+00, 6.0752887169E+00, 6.1995284874E-01, 5.2292120997E-01, 6.1964130147E-01],
	[1.2235000000E+04, 7.4274971847E+00, 6.0748379558E+00, 6.2075977359E-01, 5.2351157896E-01, 6.1980579786E-01],
	[1.2240000000E+04, 7.4314676649E+00, 6.0743874123E+00, 6.2156741815E-01, 5.2410228126E-01, 6.1997025796E-01],
	[1.2245000000E+04, 7.4354386446E+00, 6.0739370862E+00, 6.2237578276E-01, 5.2469331670E-01, 6.2013468176E-01],
	[1.2250000000E+04, 7.4394101238E+00, 6.0734869773E+00, 6.2318486777E-01, 5.2528468516E-01, 6.2029906923E-01],
	[1.2255000000E+04, 7.4433821023E+00, 6.0730370854E+00, 6.2399467353E-01, 5.2587638647E-01, 6.2046342034E-01],
	[1.2260000000E+04, 7.4473545800E+00, 6.0725874104E+00, 6.2480520037E-01, 5.2646842048E-01, 6.2062773506E-01],
	[1.2265000000E+04, 7.4513275566E+00, 6.0721379519E+00, 6.2561644866E-01, 5.2706078705E-01, 6.2079201338E-01],
	[1.2270000000E+04, 7.4553010322E+00, 6.0716887100E+00, 6.2642841873E-01, 5.2765348603E-01, 6.2095625526E-01],
	[1.2275000000E+04, 7.4592750065E+00, 6.0712396842E+00, 6.2724111093E-01, 5.2824651725E-01, 6.2112046068E-01],
	[1.2280000000E+04, 7.4632494794E+00, 6.0707908745E+00, 6.2805452562E-01, 5.2883988058E-01, 6.2128462962E-01],
	[1.2285000000E+04, 7.4672244507E+00, 6.0703422807E+00, 6.2886866314E-01, 5.2943357585E-01, 6.2144876204E-01],
	[1.2290000000E+04, 7.4711999203E+00, 6.0698939025E+00, 6.2968352383E-01, 5.3002760292E-01, 6.2161285793E-01],
	[1.2295000000E+04, 7.4751758882E+00, 6.0694457398E+00, 6.3049910805E-01, 5.3062196164E-01, 6.2177691726E-01],
	[1.2300000000E+04, 7.4791523540E+00, 6.0689977925E+00, 6.3131541614E-01, 5.3121665185E-01, 6.2194094000E-01],
	[1.2305000000E+04, 7.4831293178E+00, 6.0685500602E+00, 6.3213244844E-01, 5.3181167340E-01, 6.2210492612E-01],
	[1.2310000000E+04, 7.4871067793E+00, 6.0681025428E+00, 6.3295020531E-01, 5.3240702613E-01, 6.2226887561E-01],
	[1.2315000000E+04, 7.4910847384E+00, 6.0676552401E+00, 6.3376868710E-01, 5.3300270990E-01, 6.2243278844E-01],
	[1.2320000000E+04, 7.4950631950E+00, 6.0672081519E+00, 6.3458789415E-01, 5.3359872454E-01, 6.2259666459E-01],
	[1.2325000000E+04, 7.4990421490E+00, 6.0667612781E+00, 6.3540782681E-01, 5.3419506991E-01, 6.2276050402E-01],
	[1.2330000000E+04, 7.5030216001E+00, 6.0663146184E+00, 6.3622848542E-01, 5.3479174585E-01, 6.2292430671E-01],
	[1.2335000000E+04, 7.5070015483E+00, 6.0658681727E+00, 6.3704987034E-01, 5.3538875220E-01, 6.2308807264E-01],
	[1.2340000000E+04, 7.5109819934E+00, 6.0654219407E+00, 6.3787198191E-01, 5.3598608882E-01, 6.2325180179E-01],
	[1.2345000000E+04, 7.5149629353E+00, 6.0649759224E+00, 6.3869482047E-01, 5.3658375554E-01, 6.2341549412E-01],
	[1.2350000000E+04, 7.5189443738E+00, 6.0645301174E+00, 6.3951838639E-01, 5.3718175220E-01, 6.2357914962E-01],
	[1.2355000000E+04, 7.5229263089E+00, 6.0640845256E+00, 6.4034268000E-01, 5.3778007867E-01, 6.2374276826E-01],
	[1.2360000000E+04, 7.5269087402E+00, 6.0636391468E+00, 6.4116770166E-01, 5.3837873477E-01, 6.2390635002E-01],
	[1.2365000000E+04, 7.5308916678E+00, 6.0631939809E+00, 6.4199345170E-01, 5.3897772035E-01, 6.2406989486E-01],
	[1.2370000000E+04, 7.5348750915E+00, 6.0627490275E+00, 6.4281993048E-01, 5.3957703526E-01, 6.2423340278E-01],
	[1.2375000000E+04, 7.5388590112E+00, 6.0623042867E+00, 6.4364713835E-01, 5.4017667933E-01, 6.2439687373E-01],
	[1.2380000000E+04, 7.5428434266E+00, 6.0618597581E+00, 6.4447507565E-01, 5.4077665241E-01, 6.2456030771E-01],
	[1.2385000000E+04, 7.5468283377E+00, 6.0614154415E+00, 6.4530374274E-01, 5.4137695435E-01, 6.2472370467E-01],
	[1.2390000000E+04, 7.5508137443E+00, 6.0609713369E+00, 6.4613313995E-01, 5.4197758498E-01, 6.2488706461E-01],
	[1.2395000000E+04, 7.5547996464E+00, 6.0605274439E+00, 6.4696326765E-01, 5.4257854414E-01, 6.2505038750E-01],
	[1.2400000000E+04, 7.5587860436E+00, 6.0600837625E+00, 6.4779412617E-01, 5.4317983169E-01, 6.2521367330E-01],
	[1.2405000000E+04, 7.5627729360E+00, 6.0596402924E+00, 6.4862571586E-01, 5.4378144745E-01, 6.2537692200E-01],
	[1.2410000000E+04, 7.5667603234E+00, 6.0591970335E+00, 6.4945803707E-01, 5.4438339127E-01, 6.2554013358E-01],
	[1.2415000000E+04, 7.5707482056E+00, 6.0587539855E+00, 6.5029109016E-01, 5.4498566300E-01, 6.2570330801E-01],
	[1.2420000000E+04, 7.5747365824E+00, 6.0583111482E+00, 6.5112487546E-01, 5.4558826246E-01, 6.2586644526E-01],
	[1.2425000000E+04, 7.5787254539E+00, 6.0578685216E+00, 6.5195939333E-01, 5.4619118951E-01, 6.2602954532E-01],
	[1.2430000000E+04, 7.5827258620E+00, 6.0574321633E+00, 6.5279464411E-01, 5.4679455076E-01, 6.2619260815E-01],
	[1.2435000000E+04, 7.5867277204E+00, 6.0569965320E+00, 6.5363062815E-01, 5.4739824883E-01, 6.2635563374E-01],
	[1.2440000000E+04, 7.5907300807E+00, 6.0565611071E+00, 6.5446734581E-01, 5.4800227441E-01, 6.2651862206E-01],
	[1.2445000000E+04, 7.5947329429E+00, 6.0561258885E+00, 6.5530479742E-01, 5.4860662734E-01, 6.2668157309E-01],
	[1.2450000000E+04, 7.5987363067E+00, 6.0556908760E+00, 6.5614298334E-01, 5.4921130745E-01, 6.2684448681E-01],
	[1.2455000000E+04, 7.6027401720E+00, 6.0552560694E+00, 6.5698190392E-01, 5.4981631459E-01, 6.2700736318E-01],
	[1.2460000000E+04, 7.6067445388E+00, 6.0548214685E+00, 6.5782155950E-01, 5.5042164860E-01, 6.2717020220E-01],
	[1.2465000000E+04, 7.6107494068E+00, 6.0543870732E+00, 6.5866195043E-01, 5.5102730931E-01, 6.2733300383E-01],
	[1.2470000000E+04, 7.6147547760E+00, 6.0539528832E+00, 6.5950307706E-01, 5.5163329656E-01, 6.2749576805E-01],
	[1.2475000000E+04, 7.6187606461E+00, 6.0535188983E+00, 6.6034493974E-01, 5.5223961019E-01, 6.2765849484E-01],
	[1.2480000000E+04, 7.6227670171E+00, 6.0530851185E+00, 6.6118753881E-01, 5.5284625004E-01, 6.2782118417E-01],
	[1.2485000000E+04, 7.6267738889E+00, 6.0526515435E+00, 6.6203087463E-01, 5.5345321594E-01, 6.2798383603E-01],
	[1.2490000000E+04, 7.6307812612E+00, 6.0522181731E+00, 6.6287494755E-01, 5.5406050773E-01, 6.2814645038E-01],
	[1.2495000000E+04, 7.6347891339E+00, 6.0517850072E+00, 6.6371975790E-01, 5.5466812526E-01, 6.2830902722E-01],
	[1.2500000000E+04, 7.6387975069E+00, 6.0513520456E+00, 6.6456530605E-01, 5.5527606834E-01, 6.2847156650E-01],
	[1.2505000000E+04, 7.6428063801E+00, 6.0509192881E+00, 6.6541426049E-01, 5.5588619891E-01, 6.2863406822E-01],
	[1.2510000000E+04, 7.6468157533E+00, 6.0504867345E+00, 6.6626395911E-01, 5.5649665737E-01, 6.2879653234E-01],
	[1.2515000000E+04, 7.6508256264E+00, 6.0500543847E+00, 6.6711440227E-01, 5.5710744354E-01, 6.2895895885E-01],
	[1.2520000000E+04, 7.6548359993E+00, 6.0496222385E+00, 6.6796559033E-01, 5.5771855727E-01, 6.2912134773E-01],
	[1.2525000000E+04, 7.6588468717E+00, 6.0491902956E+00, 6.6881752363E-01, 5.5832999839E-01, 6.2928369894E-01],
	[1.2530000000E+04, 7.6628582437E+00, 6.0487585560E+00, 6.6967020254E-01, 5.5894176673E-01, 6.2944601247E-01],
	[1.2535000000E+04, 7.6668701149E+00, 6.0483270194E+00, 6.7052362740E-01, 5.5955386213E-01, 6.2960828830E-01],
	[1.2540000000E+04, 7.6708824854E+00, 6.0478956856E+00, 6.7137779857E-01, 5.6016628442E-01, 6.2977052640E-01],
	[1.2545000000E+04, 7.6748953549E+00, 6.0474645546E+00, 6.7223271641E-01, 5.6077903343E-01, 6.2993272674E-01],
	[1.2550000000E+04, 7.6789087234E+00, 6.0470336261E+00, 6.7308838127E-01, 5.6139210900E-01, 6.3009488932E-01],
	[1.2555000000E+04, 7.6829225907E+00, 6.0466028999E+00, 6.7394479350E-01, 5.6200551096E-01, 6.3025701410E-01],
	[1.2560000000E+04, 7.6869369566E+00, 6.0461723759E+00, 6.7480195346E-01, 5.6261923913E-01, 6.3041910107E-01],
	[1.2565000000E+04, 7.6909518210E+00, 6.0457420539E+00, 6.7565986150E-01, 5.6323329337E-01, 6.3058115020E-01],
	[1.2570000000E+04, 7.6949671838E+00, 6.0453119336E+00, 6.7651851798E-01, 5.6384767348E-01, 6.3074316147E-01],
	[1.2575000000E+04, 7.6989830449E+00, 6.0448820151E+00, 6.7737792326E-01, 5.6446237932E-01, 6.3090513485E-01],
	[1.2580000000E+04, 7.7029994040E+00, 6.0444522979E+00, 6.7823807767E-01, 5.6507741070E-01, 6.3106707033E-01],
	[1.2585000000E+04, 7.7070162611E+00, 6.0440227821E+00, 6.7909898159E-01, 5.6569276746E-01, 6.3122896788E-01],
	[1.2590000000E+04, 7.7110336161E+00, 6.0435934674E+00, 6.7996063537E-01, 5.6630844942E-01, 6.3139082749E-01],
	[1.2595000000E+04, 7.7150514688E+00, 6.0431643536E+00, 6.8082303935E-01, 5.6692445643E-01, 6.3155264912E-01],
	[1.2600000000E+04, 7.7190698190E+00, 6.0427354406E+00, 6.8168619390E-01, 5.6754078831E-01, 6.3171443277E-01],
	[1.2605000000E+04, 7.7230886666E+00, 6.0423067282E+00, 6.8255009936E-01, 5.6815744488E-01, 6.3187617840E-01],
	[1.2610000000E+04, 7.7271080116E+00, 6.0418782162E+00, 6.8341475610E-01, 5.6877442598E-01, 6.3203788597E-01],
	[1.2615000000E+04, 7.7311278537E+00, 6.0414499045E+00, 6.8428016447E-01, 5.6939173145E-01, 6.3219955546E-01],
	[1.2620000000E+04, 7.7351481928E+00, 6.0410217928E+00, 6.8514632482E-01, 5.7000936109E-01, 6.3236118683E-01],
	[1.2625000000E+04, 7.7391690288E+00, 6.0405938811E+00, 6.8601323751E-01, 5.7062731475E-01, 6.3252278006E-01],
	[1.2630000000E+04, 7.7432018516E+00, 6.0401721183E+00, 6.8688090289E-01, 5.7124570801E-01, 6.3268433512E-01],
	[1.2635000000E+04, 7.7472362529E+00, 6.0397511079E+00, 6.8774932132E-01, 5.7186443617E-01, 6.3284585198E-01],
	[1.2640000000E+04, 7.7512711587E+00, 6.0393302934E+00, 6.8861849315E-01, 5.7248348827E-01, 6.3300733061E-01],
	[1.2645000000E+04, 7.7553065690E+00, 6.0389096746E+00, 6.8948841874E-01, 5.7310286413E-01, 6.3316877099E-01],
	[1.2650000000E+04, 7.7593424836E+00, 6.0384892514E+00, 6.9035909844E-01, 5.7372256358E-01, 6.3333017310E-01],
	[1.2655000000E+04, 7.7633789024E+00, 6.0380690236E+00, 6.9123053261E-01, 5.7434258645E-01, 6.3349153689E-01],
	[1.2660000000E+04, 7.7674158251E+00, 6.0376489910E+00, 6.9210272159E-01, 5.7496293256E-01, 6.3365286235E-01],
	[1.2665000000E+04, 7.7714532518E+00, 6.0372291535E+00, 6.9297566576E-01, 5.7558360175E-01, 6.3381414945E-01],
	[1.2670000000E+04, 7.7754911822E+00, 6.0368095108E+00, 6.9384936545E-01, 5.7620459384E-01, 6.3397539817E-01],
	[1.2675000000E+04, 7.7795296163E+00, 6.0363900629E+00, 6.9472382103E-01, 5.7682590866E-01, 6.3413660846E-01],
	[1.2680000000E+04, 7.7835685538E+00, 6.0359708095E+00, 6.9559903286E-01, 5.7744754603E-01, 6.3429778032E-01],
	[1.2685000000E+04, 7.7876079947E+00, 6.0355517506E+00, 6.9647500127E-01, 5.7806950578E-01, 6.3445891371E-01],
	[1.2690000000E+04, 7.7916479388E+00, 6.0351328858E+00, 6.9735172665E-01, 5.7869178773E-01, 6.3462000860E-01],
	[1.2695000000E+04, 7.7956883860E+00, 6.0347142151E+00, 6.9822920932E-01, 5.7931439172E-01, 6.3478106497E-01],
	[1.2700000000E+04, 7.7997293361E+00, 6.0342957383E+00, 6.9910744966E-01, 5.7993731755E-01, 6.3494208279E-01],
	[1.2705000000E+04, 7.8037707890E+00, 6.0338774553E+00, 6.9998644802E-01, 5.8056056507E-01, 6.3510306204E-01],
	[1.2710000000E+04, 7.8078127446E+00, 6.0334593657E+00, 7.0086620474E-01, 5.8118413410E-01, 6.3526400269E-01],
	[1.2715000000E+04, 7.8118552027E+00, 6.0330414696E+00, 7.0174672020E-01, 5.8180802445E-01, 6.3542490470E-01],
	[1.2720000000E+04, 7.8158981632E+00, 6.0326237667E+00, 7.0262799474E-01, 5.8243223595E-01, 6.3558576807E-01],
	[1.2725000000E+04, 7.8199416260E+00, 6.0322062569E+00, 7.0351002871E-01, 5.8305676843E-01, 6.3574659275E-01],
	[1.2730000000E+04, 7.8239855909E+00, 6.0317889399E+00, 7.0439282248E-01, 5.8368162172E-01, 6.3590737873E-01],
	[1.2735000000E+04, 7.8280300578E+00, 6.0313718157E+00, 7.0527637640E-01, 5.8430679562E-01, 6.3606812598E-01],
	[1.2740000000E+04, 7.8320750266E+00, 6.0309548841E+00, 7.0616069082E-01, 5.8493228997E-01, 6.3622883446E-01],
	[1.2745000000E+04, 7.8361204971E+00, 6.0305381449E+00, 7.0704576610E-01, 5.8555810459E-01, 6.3638950416E-01],
	[1.2750000000E+04, 7.8401664692E+00, 6.0301215979E+00, 7.0793160259E-01, 5.8618423930E-01, 6.3655013506E-01],
	[1.2755000000E+04, 7.8442129428E+00, 6.0297052429E+00, 7.0881820065E-01, 5.8681069393E-01, 6.3671072711E-01],
	[1.2760000000E+04, 7.8482599176E+00, 6.0292890799E+00, 7.0970556064E-01, 5.8743746829E-01, 6.3687128030E-01],
	[1.2765000000E+04, 7.8523073937E+00, 6.0288731087E+00, 7.1059368291E-01, 5.8806456220E-01, 6.3703179461E-01],
	[1.2770000000E+04, 7.8563553708E+00, 6.0284573290E+00, 7.1148256781E-01, 5.8869197549E-01, 6.3719227000E-01],
	[1.2775000000E+04, 7.8604038488E+00, 6.0280417407E+00, 7.1237221571E-01, 5.8931970799E-01, 6.3735270645E-01],
	[1.2780000000E+04, 7.8644528276E+00, 6.0276263437E+00, 7.1326262695E-01, 5.8994775950E-01, 6.3751310393E-01],
	[1.2785000000E+04, 7.8685023071E+00, 6.0272111378E+00, 7.1415380190E-01, 5.9057612985E-01, 6.3767346243E-01],
	[1.2790000000E+04, 7.8725522871E+00, 6.0267961229E+00, 7.1504574091E-01, 5.9120481886E-01, 6.3783378191E-01],
	[1.2795000000E+04, 7.8766027675E+00, 6.0263812987E+00, 7.1593844433E-01, 5.9183382635E-01, 6.3799406235E-01],
	[1.2800000000E+04, 7.8806537481E+00, 6.0259666651E+00, 7.1683191251E-01, 5.9246315214E-01, 6.3815430372E-01],
	[1.2805000000E+04, 7.8847052288E+00, 6.0255522219E+00, 7.1772614583E-01, 5.9309279606E-01, 6.3831450600E-01],
	[1.2810000000E+04, 7.8887572095E+00, 6.0251379690E+00, 7.1862114462E-01, 5.9372275790E-01, 6.3847466916E-01],
	[1.2815000000E+04, 7.8928096901E+00, 6.0247239063E+00, 7.1951690925E-01, 5.9435303751E-01, 6.3863479318E-01],
	[1.2820000000E+04, 7.8968626704E+00, 6.0243100335E+00, 7.2041344008E-01, 5.9498363469E-01, 6.3879487803E-01],
	[1.2825000000E+04, 7.9009161502E+00, 6.0238963505E+00, 7.2131073745E-01, 5.9561454926E-01, 6.3895492369E-01],
	[1.2830000000E+04, 7.9049736131E+00, 6.0234845627E+00, 7.2220880173E-01, 5.9624581758E-01, 6.3911493013E-01],
	[1.2835000000E+04, 7.9090412888E+00, 6.0230777149E+00, 7.2310763326E-01, 5.9687750501E-01, 6.3927489733E-01],
	[1.2840000000E+04, 7.9131094720E+00, 6.0226710531E+00, 7.2400723242E-01, 5.9750950976E-01, 6.3943482527E-01],
	[1.2845000000E+04, 7.9171781627E+00, 6.0222645771E+00, 7.2490759954E-01, 5.9814183164E-01, 6.3959471391E-01],
	[1.2850000000E+04, 7.9212473608E+00, 6.0218582867E+00, 7.2580873499E-01, 5.9877447047E-01, 6.3975456323E-01],
	[1.2855000000E+04, 7.9253170660E+00, 6.0214521817E+00, 7.2671063913E-01, 5.9940742605E-01, 6.3991437322E-01],
	[1.2860000000E+04, 7.9293872783E+00, 6.0210462620E+00, 7.2761331230E-01, 6.0004069822E-01, 6.4007414384E-01],
	[1.2865000000E+04, 7.9334579975E+00, 6.0206405275E+00, 7.2851675487E-01, 6.0067428679E-01, 6.4023387506E-01],
	[1.2870000000E+04, 7.9375292235E+00, 6.0202349779E+00, 7.2942096719E-01, 6.0130819157E-01, 6.4039356688E-01],
	[1.2875000000E+04, 7.9416009561E+00, 6.0198296132E+00, 7.3032594962E-01, 6.0194241239E-01, 6.4055321925E-01],
	[1.2880000000E+04, 7.9456731953E+00, 6.0194244331E+00, 7.3123170251E-01, 6.0257694905E-01, 6.4071283216E-01],
	[1.2885000000E+04, 7.9497459408E+00, 6.0190194376E+00, 7.3213822622E-01, 6.0321180137E-01, 6.4087240558E-01],
	[1.2890000000E+04, 7.9538191926E+00, 6.0186146264E+00, 7.3304552111E-01, 6.0384696917E-01, 6.4103193949E-01],
	[1.2895000000E+04, 7.9578929506E+00, 6.0182099994E+00, 7.3395358752E-01, 6.0448245226E-01, 6.4119143387E-01],
	[1.2900000000E+04, 7.9619672145E+00, 6.0178055565E+00, 7.3486242583E-01, 6.0511825046E-01, 6.4135088868E-01],
	[1.2905000000E+04, 7.9660419843E+00, 6.0174012975E+00, 7.3577203638E-01, 6.0575436359E-01, 6.4151030391E-01],
	[1.2910000000E+04, 7.9701172597E+00, 6.0169972222E+00, 7.3668241953E-01, 6.0639079145E-01, 6.4166967953E-01],
	[1.2915000000E+04, 7.9741930408E+00, 6.0165933305E+00, 7.3759357564E-01, 6.0702753387E-01, 6.4182901552E-01],
	[1.2920000000E+04, 7.9782693273E+00, 6.0161896222E+00, 7.3850550506E-01, 6.0766459065E-01, 6.4198831185E-01],
	[1.2925000000E+04, 7.9823461192E+00, 6.0157860972E+00, 7.3941820815E-01, 6.0830196160E-01, 6.4214756850E-01],
	[1.2930000000E+04, 7.9864234162E+00, 6.0153827553E+00, 7.4033168527E-01, 6.0893964656E-01, 6.4230678545E-01],
	[1.2935000000E+04, 7.9905012183E+00, 6.0149795964E+00, 7.4124593676E-01, 6.0957764531E-01, 6.4246596267E-01],
	[1.2940000000E+04, 7.9945795254E+00, 6.0145766203E+00, 7.4216096300E-01, 6.1021595769E-01, 6.4262510014E-01],
	[1.2945000000E+04, 7.9986583372E+00, 6.0141738269E+00, 7.4307676433E-01, 6.1085458349E-01, 6.4278419784E-01],
	[1.2950000000E+04, 8.0027376536E+00, 6.0137712159E+00, 7.4399334111E-01, 6.1149352254E-01, 6.4294325574E-01],
	[1.2955000000E+04, 8.0068174746E+00, 6.0133687874E+00, 7.4491069370E-01, 6.1213277465E-01, 6.4310227381E-01],
	[1.2960000000E+04, 8.0108978000E+00, 6.0129665410E+00, 7.4582882245E-01, 6.1277233962E-01, 6.4326125204E-01],
	[1.2965000000E+04, 8.0149786297E+00, 6.0125644767E+00, 7.4674772772E-01, 6.1341221727E-01, 6.4342019041E-01],
	[1.2970000000E+04, 8.0190599634E+00, 6.0121625943E+00, 7.4766740987E-01, 6.1405240741E-01, 6.4357908888E-01],
	[1.2975000000E+04, 8.0231418012E+00, 6.0117608936E+00, 7.4858786926E-01, 6.1469290985E-01, 6.4373794743E-01],
	[1.2980000000E+04, 8.0272241428E+00, 6.0113593745E+00, 7.4950910623E-01, 6.1533372440E-01, 6.4389676605E-01],
	[1.2985000000E+04, 8.0313069882E+00, 6.0109580369E+00, 7.5043112115E-01, 6.1597485088E-01, 6.4405554471E-01],
	[1.2990000000E+04, 8.0353903372E+00, 6.0105568805E+00, 7.5135391437E-01, 6.1661628908E-01, 6.4421428339E-01],
	[1.2995000000E+04, 8.0394741896E+00, 6.0101559053E+00, 7.5227748626E-01, 6.1725803883E-01, 6.4437298205E-01],
	[1.3000000000E+04, 8.0435585454E+00, 6.0097551110E+00, 7.5320183716E-01, 6.1790009993E-01, 6.4453164069E-01],
	[1.3005000000E+04, 8.0476434044E+00, 6.0093544976E+00, 7.5412696743E-01, 6.1854247219E-01, 6.4469025928E-01],
	[1.3010000000E+04, 8.0517287664E+00, 6.0089540649E+00, 7.5505287744E-01, 6.1918515542E-01, 6.4484883779E-01],
	[1.3015000000E+04, 8.0558146314E+00, 6.0085538127E+00, 7.5597956753E-01, 6.1982814943E-01, 6.4500737620E-01],
	[1.3020000000E+04, 8.0599009992E+00, 6.0081537409E+00, 7.5690703806E-01, 6.2047145403E-01, 6.4516587449E-01],
	[1.3025000000E+04, 8.0639878697E+00, 6.0077538493E+00, 7.5783528940E-01, 6.2111506903E-01, 6.4532433263E-01],
	[1.3030000000E+04, 8.0680752428E+00, 6.0073541379E+00, 7.5876432189E-01, 6.2175899422E-01, 6.4548275062E-01],
	[1.3035000000E+04, 8.0721631182E+00, 6.0069546063E+00, 7.5969413589E-01, 6.2240322943E-01, 6.4564112841E-01],
	[1.3040000000E+04, 8.0762647649E+00, 6.0065614023E+00, 7.6062473177E-01, 6.2304791958E-01, 6.4579946599E-01],
	[1.3045000000E+04, 8.0803674864E+00, 6.0061686361E+00, 7.6155610988E-01, 6.2369292601E-01, 6.4595776334E-01],
	[1.3050000000E+04, 8.0844707186E+00, 6.0057760461E+00, 7.6248827057E-01, 6.2433824236E-01, 6.4611602043E-01],
	[1.3055000000E+04, 8.0885744615E+00, 6.0053836322E+00, 7.6342121420E-01, 6.2498386845E-01, 6.4627423725E-01],
	[1.3060000000E+04, 8.0926787148E+00, 6.0049913941E+00, 7.6435494113E-01, 6.2562980409E-01, 6.4643241376E-01],
	[1.3065000000E+04, 8.0967834785E+00, 6.0045993318E+00, 7.6528945172E-01, 6.2627604908E-01, 6.4659054995E-01],
	[1.3070000000E+04, 8.1008887524E+00, 6.0042074450E+00, 7.6622474632E-01, 6.2692260322E-01, 6.4674864580E-01],
	[1.3075000000E+04, 8.1049945364E+00, 6.0038157337E+00, 7.6716082529E-01, 6.2756946633E-01, 6.4690670128E-01],
	[1.3080000000E+04, 8.1091008304E+00, 6.0034241978E+00, 7.6809768899E-01, 6.2821663821E-01, 6.4706471638E-01],
	[1.3085000000E+04, 8.1132076342E+00, 6.0030328369E+00, 7.6903533777E-01, 6.2886411866E-01, 6.4722269106E-01],
	[1.3090000000E+04, 8.1173149477E+00, 6.0026416511E+00, 7.6997377199E-01, 6.2951190750E-01, 6.4738062531E-01],
	[1.3095000000E+04, 8.1214227707E+00, 6.0022506402E+00, 7.7091299201E-01, 6.3016000452E-01, 6.4753851911E-01],
	[1.3100000000E+04, 8.1255311032E+00, 6.0018598040E+00, 7.7185299819E-01, 6.3080840954E-01, 6.4769637243E-01],
	[1.3105000000E+04, 8.1296399450E+00, 6.0014691424E+00, 7.7279379088E-01, 6.3145712236E-01, 6.4785418526E-01],
	[1.3110000000E+04, 8.1337492959E+00, 6.0010786552E+00, 7.7373537044E-01, 6.3210614277E-01, 6.4801195756E-01],
	[1.3115000000E+04, 8.1378591559E+00, 6.0006883423E+00, 7.7467773722E-01, 6.3275547060E-01, 6.4816968933E-01],
	[1.3120000000E+04, 8.1419695248E+00, 6.0002982035E+00, 7.7562089160E-01, 6.3340510564E-01, 6.4832738053E-01],
	[1.3125000000E+04, 8.1460804024E+00, 5.9999082388E+00, 7.7656483391E-01, 6.3405504769E-01, 6.4848503115E-01],
	[1.3130000000E+04, 8.1501917887E+00, 5.9995184479E+00, 7.7750956452E-01, 6.3470529656E-01, 6.4864264117E-01],
	[1.3135000000E+04, 8.1543036836E+00, 5.9991288307E+00, 7.7845508379E-01, 6.3535585206E-01, 6.4880021056E-01],
	[1.3140000000E+04, 8.1584160868E+00, 5.9987393871E+00, 7.7940139208E-01, 6.3600671398E-01, 6.4895773930E-01],
	[1.3145000000E+04, 8.1625289982E+00, 5.9983501169E+00, 7.8034848973E-01, 6.3665788213E-01, 6.4911522737E-01],
	[1.3150000000E+04, 8.1666424178E+00, 5.9979610200E+00, 7.8129637712E-01, 6.3730935631E-01, 6.4927267476E-01],
	[1.3155000000E+04, 8.1707563454E+00, 5.9975720963E+00, 7.8224505459E-01, 6.3796113632E-01, 6.4943008143E-01],
	[1.3160000000E+04, 8.1748707808E+00, 5.9971833455E+00, 7.8319452251E-01, 6.3861322197E-01, 6.4958744737E-01],
	[1.3165000000E+04, 8.1789857240E+00, 5.9967947676E+00, 7.8414478122E-01, 6.3926561306E-01, 6.4974477256E-01],
	[1.3170000000E+04, 8.1831011747E+00, 5.9964063625E+00, 7.8509583110E-01, 6.3991830939E-01, 6.4990205697E-01],
	[1.3175000000E+04, 8.1872171330E+00, 5.9960181299E+00, 7.8604767249E-01, 6.4057131076E-01, 6.5005930059E-01],
	[1.3180000000E+04, 8.1913335985E+00, 5.9956300697E+00, 7.8700030576E-01, 6.4122461698E-01, 6.5021650340E-01],
	[1.3185000000E+04, 8.1954505713E+00, 5.9952421818E+00, 7.8795373126E-01, 6.4187822783E-01, 6.5037366537E-01],
	[1.3190000000E+04, 8.1995680512E+00, 5.9948544661E+00, 7.8890794935E-01, 6.4253214313E-01, 6.5053078648E-01],
	[1.3195000000E+04, 8.2036860380E+00, 5.9944669223E+00, 7.8986296039E-01, 6.4318636268E-01, 6.5068786671E-01],
	[1.3200000000E+04, 8.2078045316E+00, 5.9940795505E+00, 7.9081876473E-01, 6.4384088627E-01, 6.5084490605E-01],
	[1.3205000000E+04, 8.2119235319E+00, 5.9936923503E+00, 7.9177536273E-01, 6.4449571370E-01, 6.5100190446E-01],
	[1.3210000000E+04, 8.2160430388E+00, 5.9933053217E+00, 7.9273275476E-01, 6.4515084478E-01, 6.5115886194E-01],
	[1.3215000000E+04, 8.2201630522E+00, 5.9929184646E+00, 7.9369094116E-01, 6.4580627931E-01, 6.5131577846E-01],
	[1.3220000000E+04, 8.2242835718E+00, 5.9925317788E+00, 7.9464992230E-01, 6.4646201707E-01, 6.5147265400E-01],
	[1.3225000000E+04, 8.2284045976E+00, 5.9921452641E+00, 7.9560969853E-01, 6.4711805788E-01, 6.5162948854E-01],
	[1.3230000000E+04, 8.2325261294E+00, 5.9917589205E+00, 7.9657027021E-01, 6.4777440153E-01, 6.5178628206E-01],
	[1.3235000000E+04, 8.2366481672E+00, 5.9913727477E+00, 7.9753163771E-01, 6.4843104782E-01, 6.5194303453E-01],
	[1.3240000000E+04, 8.2407707107E+00, 5.9909867457E+00, 7.9849380137E-01, 6.4908799655E-01, 6.5209974595E-01],
	[1.3245000000E+04, 8.2448937599E+00, 5.9906009143E+00, 7.9945676155E-01, 6.4974524751E-01, 6.5225641629E-01],
	[1.3250000000E+04, 8.2490316402E+00, 5.9902215470E+00, 8.0042051863E-01, 6.5040296376E-01, 6.5241304552E-01],
	[1.3255000000E+04, 8.2531701881E+00, 5.9898424143E+00, 8.0138507294E-01, 6.5106098411E-01, 6.5256963364E-01],
	[1.3260000000E+04, 8.2573092504E+00, 5.9894634485E+00, 8.0235042485E-01, 6.5171930661E-01, 6.5272618061E-01],
	[1.3265000000E+04, 8.2614488268E+00, 5.9890846495E+00, 8.0331657472E-01, 6.5237793106E-01, 6.5288268642E-01],
	[1.3270000000E+04, 8.2655889173E+00, 5.9887060173E+00, 8.0428352290E-01, 6.5303685726E-01, 6.5303915106E-01],
	[1.3275000000E+04, 8.2697295217E+00, 5.9883275516E+00, 8.0525126976E-01, 6.5369608501E-01, 6.5319557449E-01],
	[1.3280000000E+04, 8.2738706398E+00, 5.9879492523E+00, 8.0621981565E-01, 6.5435561410E-01, 6.5335195670E-01],
	[1.3285000000E+04, 8.2780122717E+00, 5.9875711193E+00, 8.0718916093E-01, 6.5501544434E-01, 6.5350829768E-01],
	[1.3290000000E+04, 8.2821544170E+00, 5.9871931525E+00, 8.0815930595E-01, 6.5567557550E-01, 6.5366459738E-01],
	[1.3295000000E+04, 8.2862970758E+00, 5.9868153517E+00, 8.0913025109E-01, 6.5633600740E-01, 6.5382085580E-01],
	[1.3300000000E+04, 8.2904402478E+00, 5.9864377168E+00, 8.1010199668E-01, 6.5699673983E-01, 6.5397707289E-01],
	[1.3305000000E+04, 8.2945839330E+00, 5.9860602476E+00, 8.1107454310E-01, 6.5765777259E-01, 6.5413324865E-01],
	[1.3310000000E+04, 8.2987281312E+00, 5.9856829441E+00, 8.1204789070E-01, 6.5831910546E-01, 6.5428938303E-01],
	[1.3315000000E+04, 8.3028728422E+00, 5.9853058060E+00, 8.1302203984E-01, 6.5898073825E-01, 6.5444547603E-01],
	[1.3320000000E+04, 8.3070180660E+00, 5.9849288333E+00, 8.1399699088E-01, 6.5964267075E-01, 6.5460152761E-01],
	[1.3325000000E+04, 8.3111638025E+00, 5.9845520257E+00, 8.1497274418E-01, 6.6030490275E-01, 6.5475753776E-01],
	[1.3330000000E+04, 8.3153100514E+00, 5.9841753833E+00, 8.1594930008E-01, 6.6096743406E-01, 6.5491350644E-01],
	[1.3335000000E+04, 8.3194568127E+00, 5.9837989058E+00, 8.1692665896E-01, 6.6163026446E-01, 6.5506943365E-01],
	[1.3340000000E+04, 8.3236040862E+00, 5.9834225931E+00, 8.1790482117E-01, 6.6229339375E-01, 6.5522531934E-01],
	[1.3345000000E+04, 8.3277518718E+00, 5.9830464450E+00, 8.1888378708E-01, 6.6295682172E-01, 6.5538116351E-01],
	[1.3350000000E+04, 8.3319001694E+00, 5.9826704615E+00, 8.1986355702E-01, 6.6362054816E-01, 6.5553696613E-01],
	[1.3355000000E+04, 8.3360489789E+00, 5.9822946425E+00, 8.2084413138E-01, 6.6428457288E-01, 6.5569272716E-01],
	[1.3360000000E+04, 8.3401983001E+00, 5.9819189876E+00, 8.2182551050E-01, 6.6494889566E-01, 6.5584844660E-01],
	[1.3365000000E+04, 8.3443481329E+00, 5.9815434970E+00, 8.2280769474E-01, 6.6561351629E-01, 6.5600412442E-01],
	[1.3370000000E+04, 8.3484984771E+00, 5.9811681703E+00, 8.2379068447E-01, 6.6627843457E-01, 6.5615976059E-01],
	[1.3375000000E+04, 8.3526493327E+00, 5.9807930075E+00, 8.2477448003E-01, 6.6694365029E-01, 6.5631535510E-01],
	[1.3380000000E+04, 8.3568006994E+00, 5.9804180084E+00, 8.2575908180E-01, 6.6760916325E-01, 6.5647090791E-01],
	[1.3385000000E+04, 8.3609525773E+00, 5.9800431730E+00, 8.2674449012E-01, 6.6827497322E-01, 6.5662641901E-01],
	[1.3390000000E+04, 8.3651049661E+00, 5.9796685010E+00, 8.2773070536E-01, 6.6894108002E-01, 6.5678188838E-01],
	[1.3395000000E+04, 8.3692578658E+00, 5.9792939924E+00, 8.2871772788E-01, 6.6960748342E-01, 6.5693731598E-01],
	[1.3400000000E+04, 8.3734112761E+00, 5.9789196470E+00, 8.2970555802E-01, 6.7027418322E-01, 6.5709270181E-01],
	[1.3405000000E+04, 8.3775651970E+00, 5.9785454646E+00, 8.3069419617E-01, 6.7094117922E-01, 6.5724804583E-01],
	[1.3410000000E+04, 8.3817196283E+00, 5.9781714452E+00, 8.3168364266E-01, 6.7160847119E-01, 6.5740334803E-01],
	[1.3415000000E+04, 8.3858745700E+00, 5.9777975887E+00, 8.3267389786E-01, 6.7227605893E-01, 6.5755860838E-01],
	[1.3420000000E+04, 8.3900300218E+00, 5.9774238948E+00, 8.3366496213E-01, 6.7294394224E-01, 6.5771382686E-01],
	[1.3425000000E+04, 8.3941859837E+00, 5.9770503634E+00, 8.3465683583E-01, 6.7361212089E-01, 6.5786900345E-01],
	[1.3430000000E+04, 8.3983424555E+00, 5.9766769945E+00, 8.3564951932E-01, 6.7428059469E-01, 6.5802413812E-01],
	[1.3435000000E+04, 8.4024994372E+00, 5.9763037879E+00, 8.3664301295E-01, 6.7494936342E-01, 6.5817923086E-01],
	[1.3440000000E+04, 8.4066569285E+00, 5.9759307434E+00, 8.3763731709E-01, 6.7561842687E-01, 6.5833428163E-01],
	[1.3445000000E+04, 8.4108149293E+00, 5.9755578609E+00, 8.3863243209E-01, 6.7628778483E-01, 6.5848929043E-01],
	[1.3450000000E+04, 8.4149734396E+00, 5.9751851404E+00, 8.3962835831E-01, 6.7695743709E-01, 6.5864425722E-01],
	[1.3455000000E+04, 8.4191324592E+00, 5.9748125816E+00, 8.4062509612E-01, 6.7762738343E-01, 6.5879918199E-01],
	[1.3460000000E+04, 8.4232971914E+00, 5.9744423561E+00, 8.4162264586E-01, 6.7829768538E-01, 6.5895406472E-01],
	[1.3465000000E+04, 8.4274723644E+00, 5.9740764323E+00, 8.4262100790E-01, 6.7896839913E-01, 6.5910890537E-01],
	[1.3470000000E+04, 8.4316480557E+00, 5.9737106667E+00, 8.4362018261E-01, 6.7963940688E-01, 6.5926370394E-01],
	[1.3475000000E+04, 8.4358242651E+00, 5.9733450593E+00, 8.4462017033E-01, 6.8031070843E-01, 6.5941846039E-01],
	[1.3480000000E+04, 8.4400009924E+00, 5.9729796098E+00, 8.4562097143E-01, 6.8098230357E-01, 6.5957317471E-01],
	[1.3485000000E+04, 8.4441782377E+00, 5.9726143183E+00, 8.4662258626E-01, 6.8165419208E-01, 6.5972784688E-01],
	[1.3490000000E+04, 8.4483560007E+00, 5.9722491844E+00, 8.4762501519E-01, 6.8232637375E-01, 6.5988247687E-01],
	[1.3495000000E+04, 8.4525342814E+00, 5.9718842082E+00, 8.4862825857E-01, 6.8299884836E-01, 6.6003706467E-01],
	[1.3500000000E+04, 8.4567130795E+00, 5.9715193895E+00, 8.4963231676E-01, 6.8367161572E-01, 6.6019161024E-01],
	[1.3505000000E+04, 8.4608923950E+00, 5.9711547282E+00, 8.5063719013E-01, 6.8434467559E-01, 6.6034611358E-01],
	[1.3510000000E+04, 8.4650722277E+00, 5.9707902241E+00, 8.5164287903E-01, 6.8501802778E-01, 6.6050057466E-01],
	[1.3515000000E+04, 8.4692525776E+00, 5.9704258771E+00, 8.5264938383E-01, 6.8569167206E-01, 6.6065499345E-01],
	[1.3520000000E+04, 8.4734334444E+00, 5.9700616871E+00, 8.5365670487E-01, 6.8636560823E-01, 6.6080936995E-01],
	[1.3525000000E+04, 8.4776148281E+00, 5.9696976539E+00, 8.5466484252E-01, 6.8703983606E-01, 6.6096370411E-01],
	[1.3530000000E+04, 8.4817967285E+00, 5.9693337775E+00, 8.5567379714E-01, 6.8771435535E-01, 6.6111799594E-01],
	[1.3535000000E+04, 8.4859791455E+00, 5.9689700578E+00, 8.5668356909E-01, 6.8838916588E-01, 6.6127224539E-01],
	[1.3540000000E+04, 8.4901620790E+00, 5.9686064945E+00, 8.5769415873E-01, 6.8906426744E-01, 6.6142645247E-01],
	[1.3545000000E+04, 8.4943455289E+00, 5.9682430875E+00, 8.5870556642E-01, 6.8973965981E-01, 6.6158061713E-01],
	[1.3550000000E+04, 8.4985294950E+00, 5.9678798368E+00, 8.5971779251E-01, 6.9041534278E-01, 6.6173473937E-01],
	[1.3555000000E+04, 8.5027139771E+00, 5.9675167422E+00, 8.6073083737E-01, 6.9109131613E-01, 6.6188881915E-01],
	[1.3560000000E+04, 8.5068989753E+00, 5.9671538036E+00, 8.6174470136E-01, 6.9176757964E-01, 6.6204285647E-01],
	[1.3565000000E+04, 8.5110844892E+00, 5.9667910209E+00, 8.6275938483E-01, 6.9244413310E-01, 6.6219685130E-01],
	[1.3570000000E+04, 8.5152705189E+00, 5.9664283939E+00, 8.6377488815E-01, 6.9312097630E-01, 6.6235080362E-01],
	[1.3575000000E+04, 8.5194570642E+00, 5.9660659225E+00, 8.6479121167E-01, 6.9379810902E-01, 6.6250471341E-01],
	[1.3580000000E+04, 8.5236441250E+00, 5.9657036067E+00, 8.6580835575E-01, 6.9447553104E-01, 6.6265858064E-01],
	[1.3585000000E+04, 8.5278317011E+00, 5.9653414461E+00, 8.6682632076E-01, 6.9515324215E-01, 6.6281240531E-01],
	[1.3590000000E+04, 8.5320197923E+00, 5.9649794409E+00, 8.6784510706E-01, 6.9583124212E-01, 6.6296618738E-01],
	[1.3595000000E+04, 8.5362083987E+00, 5.9646175907E+00, 8.6886471499E-01, 6.9650953075E-01, 6.6311992685E-01],
	[1.3600000000E+04, 8.5403975201E+00, 5.9642558955E+00, 8.6988514493E-01, 6.9718810781E-01, 6.6327362368E-01],
	[1.3605000000E+04, 8.5445871562E+00, 5.9638943553E+00, 8.7090639724E-01, 6.9786697309E-01, 6.6342727785E-01],
	[1.3610000000E+04, 8.5487773071E+00, 5.9635329697E+00, 8.7192847226E-01, 6.9854612637E-01, 6.6358088936E-01],
	[1.3615000000E+04, 8.5529679725E+00, 5.9631717388E+00, 8.7295137037E-01, 6.9922556743E-01, 6.6373445818E-01],
	[1.3620000000E+04, 8.5571591524E+00, 5.9628106624E+00, 8.7397509192E-01, 6.9990529605E-01, 6.6388798428E-01],
	[1.3625000000E+04, 8.5613508467E+00, 5.9624497404E+00, 8.7499963727E-01, 7.0058531202E-01, 6.6404146765E-01],
	[1.3630000000E+04, 8.5655430551E+00, 5.9620889726E+00, 8.7602500678E-01, 7.0126561512E-01, 6.6419490828E-01],
	[1.3635000000E+04, 8.5697357776E+00, 5.9617283590E+00, 8.7705120082E-01, 7.0194620512E-01, 6.6434830613E-01],
	[1.3640000000E+04, 8.5739290141E+00, 5.9613678993E+00, 8.7807821974E-01, 7.0262708181E-01, 6.6450166119E-01],
	[1.3645000000E+04, 8.5781227644E+00, 5.9610075936E+00, 8.7910606389E-01, 7.0330824498E-01, 6.6465497344E-01],
	[1.3650000000E+04, 8.5823170283E+00, 5.9606474417E+00, 8.8013473365E-01, 7.0398969439E-01, 6.6480824286E-01],
	[1.3655000000E+04, 8.5865118059E+00, 5.9602874433E+00, 8.8116422938E-01, 7.0467142983E-01, 6.6496146943E-01],
	[1.3660000000E+04, 8.5907070969E+00, 5.9599275986E+00, 8.8219455142E-01, 7.0535345109E-01, 6.6511465313E-01],
	[1.3665000000E+04, 8.5949029013E+00, 5.9595679072E+00, 8.8322570014E-01, 7.0603575793E-01, 6.6526779394E-01],
	[1.3670000000E+04, 8.5990992188E+00, 5.9592083691E+00, 8.8425767591E-01, 7.0671835015E-01, 6.6542089185E-01],
	[1.3675000000E+04, 8.6032962381E+00, 5.9588490590E+00, 8.8529047908E-01, 7.0740122985E-01, 6.6557394683E-01],
	[1.3680000000E+04, 8.6075093746E+00, 5.9584960917E+00, 8.8632411001E-01, 7.0808458749E-01, 6.6572695887E-01],
	[1.3685000000E+04, 8.6117230335E+00, 5.9581432742E+00, 8.8735856906E-01, 7.0876823043E-01, 6.6587992794E-01],
	[1.3690000000E+04, 8.6159372149E+00, 5.9577906065E+00, 8.8839385660E-01, 7.0945215844E-01, 6.6603285403E-01],
	[1.3695000000E+04, 8.6201519184E+00, 5.9574380884E+00, 8.8943177019E-01, 7.1013751698E-01, 6.6618573711E-01],
	[1.3700000000E+04, 8.6243671441E+00, 5.9570857199E+00, 8.9047345177E-01, 7.1082503187E-01, 6.6633857717E-01],
	[1.3705000000E+04, 8.6285828918E+00, 5.9567335008E+00, 8.9151597232E-01, 7.1151283471E-01, 6.6649137419E-01],
	[1.3710000000E+04, 8.6327991613E+00, 5.9563814310E+00, 8.9255933220E-01, 7.1220092529E-01, 6.6664412816E-01],
	[1.3715000000E+04, 8.6370159525E+00, 5.9560295103E+00, 8.9360353178E-01, 7.1288930338E-01, 6.6679683904E-01],
	[1.3720000000E+04, 8.6412332653E+00, 5.9556777387E+00, 8.9464857144E-01, 7.1357796876E-01, 6.6694950683E-01],
	[1.3725000000E+04, 8.6454510996E+00, 5.9553261160E+00, 8.9569445153E-01, 7.1426692121E-01, 6.6710213150E-01],
	[1.3730000000E+04, 8.6496694553E+00, 5.9549746422E+00, 8.9674117244E-01, 7.1495616050E-01, 6.6725471304E-01],
	[1.3735000000E+04, 8.6538883322E+00, 5.9546233170E+00, 8.9778873452E-01, 7.1564568641E-01, 6.6740725142E-01],
	[1.3740000000E+04, 8.6581077302E+00, 5.9542721405E+00, 8.9883713816E-01, 7.1633549871E-01, 6.6755974664E-01],
	[1.3745000000E+04, 8.6623276492E+00, 5.9539211124E+00, 8.9988638371E-01, 7.1702559717E-01, 6.6771219866E-01],
	[1.3750000000E+04, 8.6665480890E+00, 5.9535702327E+00, 9.0093647154E-01, 7.1771598158E-01, 6.6786460748E-01],
	[1.3755000000E+04, 8.6707690495E+00, 5.9532195012E+00, 9.0198740203E-01, 7.1840665170E-01, 6.6801697307E-01],
	[1.3760000000E+04, 8.6749905307E+00, 5.9528689178E+00, 9.0303917555E-01, 7.1909760732E-01, 6.6816929541E-01],
	[1.3765000000E+04, 8.6792125323E+00, 5.9525184824E+00, 9.0409179246E-01, 7.1978884820E-01, 6.6832157449E-01],
	[1.3770000000E+04, 8.6834350543E+00, 5.9521681950E+00, 9.0514525313E-01, 7.2048037412E-01, 6.6847381029E-01],
	[1.3775000000E+04, 8.6876580965E+00, 5.9518180552E+00, 9.0619955794E-01, 7.2117218485E-01, 6.6862600280E-01],
	[1.3780000000E+04, 8.6918816587E+00, 5.9514680632E+00, 9.0725470725E-01, 7.2186428017E-01, 6.6877815198E-01],
	[1.3785000000E+04, 8.6961057410E+00, 5.9511182187E+00, 9.0831070143E-01, 7.2255665984E-01, 6.6893025783E-01],
	[1.3790000000E+04, 8.7003303431E+00, 5.9507685216E+00, 9.0936754084E-01, 7.2324932366E-01, 6.6908232033E-01],
	[1.3795000000E+04, 8.7045554650E+00, 5.9504189718E+00, 9.1042522587E-01, 7.2394227137E-01, 6.6923433945E-01],
	[1.3800000000E+04, 8.7087811065E+00, 5.9500695692E+00, 9.1148375688E-01, 7.2463550277E-01, 6.6938631519E-01],
	[1.3805000000E+04, 8.7130072674E+00, 5.9497203137E+00, 9.1254313424E-01, 7.2532901761E-01, 6.6953824752E-01],
	[1.3810000000E+04, 8.7172339477E+00, 5.9493712051E+00, 9.1360335832E-01, 7.2602281568E-01, 6.6969013643E-01],
	[1.3815000000E+04, 8.7214611472E+00, 5.9490222434E+00, 9.1466442948E-01, 7.2671689674E-01, 6.6984198189E-01],
	[1.3820000000E+04, 8.7256888658E+00, 5.9486734284E+00, 9.1572634810E-01, 7.2741126057E-01, 6.6999378390E-01],
	[1.3825000000E+04, 8.7299171034E+00, 5.9483247601E+00, 9.1678911455E-01, 7.2810590694E-01, 6.7014554243E-01],
	[1.3830000000E+04, 8.7341458599E+00, 5.9479762382E+00, 9.1785272920E-01, 7.2880083562E-01, 6.7029725746E-01],
	[1.3835000000E+04, 8.7383751351E+00, 5.9476278628E+00, 9.1891719241E-01, 7.2949604638E-01, 6.7044892899E-01],
	[1.3840000000E+04, 8.7426049289E+00, 5.9472796336E+00, 9.1998250455E-01, 7.3019153899E-01, 6.7060055698E-01],
	[1.3845000000E+04, 8.7468352411E+00, 5.9469315506E+00, 9.2104866601E-01, 7.3088731322E-01, 6.7075214143E-01],
	[1.3850000000E+04, 8.7510660718E+00, 5.9465836136E+00, 9.2211567713E-01, 7.3158336884E-01, 6.7090368231E-01],
	[1.3855000000E+04, 8.7552974207E+00, 5.9462358225E+00, 9.2318353831E-01, 7.3227970563E-01, 6.7105517961E-01],
	[1.3860000000E+04, 8.7595292877E+00, 5.9458881773E+00, 9.2425224989E-01, 7.3297632335E-01, 6.7120663332E-01],
	[1.3865000000E+04, 8.7637616727E+00, 5.9455406778E+00, 9.2532181227E-01, 7.3367322177E-01, 6.7135804340E-01],
	[1.3870000000E+04, 8.7679945755E+00, 5.9451933238E+00, 9.2639222579E-01, 7.3437040067E-01, 6.7150940986E-01],
	[1.3875000000E+04, 8.7722279961E+00, 5.9448461154E+00, 9.2746349084E-01, 7.3506785981E-01, 6.7166073267E-01],
	[1.3880000000E+04, 8.7764619344E+00, 5.9444990523E+00, 9.2853560779E-01, 7.3576559896E-01, 6.7181201181E-01],
	[1.3885000000E+04, 8.7806963901E+00, 5.9441521344E+00, 9.2960857700E-01, 7.3646361789E-01, 6.7196324727E-01],
	[1.3890000000E+04, 8.7849313632E+00, 5.9438053617E+00, 9.3068239884E-01, 7.3716191636E-01, 6.7211443903E-01],
	[1.3895000000E+04, 8.7891668535E+00, 5.9434587340E+00, 9.3175707368E-01, 7.3786049416E-01, 6.7226558707E-01],
	[1.3900000000E+04, 8.7934190322E+00, 5.9431183579E+00, 9.3283260190E-01, 7.3855955942E-01, 6.7241669138E-01],
	[1.3905000000E+04, 8.7976720281E+00, 5.9427782332E+00, 9.3390898387E-01, 7.3925890790E-01, 6.7256775194E-01],
	[1.3910000000E+04, 8.8019255508E+00, 5.9424382503E+00, 9.3498621994E-01, 7.3995853563E-01, 6.7271876874E-01],
	[1.3915000000E+04, 8.8061796003E+00, 5.9420984090E+00, 9.3606431050E-01, 7.4065844238E-01, 6.7286974175E-01],
	[1.3920000000E+04, 8.8104341763E+00, 5.9417587092E+00, 9.3714325592E-01, 7.4135862791E-01, 6.7302067096E-01],
	[1.3925000000E+04, 8.8146892788E+00, 5.9414191509E+00, 9.3822305656E-01, 7.4205909200E-01, 6.7317155635E-01],
	[1.3930000000E+04, 8.8189449077E+00, 5.9410797338E+00, 9.3930371279E-01, 7.4275983440E-01, 6.7332239792E-01],
	[1.3935000000E+04, 8.8232010628E+00, 5.9407404579E+00, 9.4038522499E-01, 7.4346085490E-01, 6.7347319563E-01],
	[1.3940000000E+04, 8.8274577440E+00, 5.9404013231E+00, 9.4146759352E-01, 7.4416215326E-01, 6.7362394948E-01],
	[1.3945000000E+04, 8.8317149513E+00, 5.9400623292E+00, 9.4255081876E-01, 7.4486372923E-01, 6.7377465943E-01],
	[1.3950000000E+04, 8.8359726843E+00, 5.9397234763E+00, 9.4363490107E-01, 7.4556558260E-01, 6.7392532547E-01],
	[1.3955000000E+04, 8.8402309431E+00, 5.9393847640E+00, 9.4471984082E-01, 7.4626771313E-01, 6.7407594758E-01],
	[1.3960000000E+04, 8.8444897275E+00, 5.9390461924E+00, 9.4580563840E-01, 7.4697012059E-01, 6.7422652574E-01],
	[1.3965000000E+04, 8.8487490374E+00, 5.9387077614E+00, 9.4689229415E-01, 7.4767280473E-01, 6.7437705993E-01],
	[1.3970000000E+04, 8.8530088727E+00, 5.9383694707E+00, 9.4797980847E-01, 7.4837576533E-01, 6.7452755014E-01],
	[1.3975000000E+04, 8.8572692332E+00, 5.9380313204E+00, 9.4906818171E-01, 7.4907900216E-01, 6.7467799633E-01],
	[1.3980000000E+04, 8.8615301188E+00, 5.9376933103E+00, 9.5015741425E-01, 7.4978251498E-01, 6.7482839850E-01],
	[1.3985000000E+04, 8.8657915295E+00, 5.9373554403E+00, 9.5124750645E-01, 7.5048630355E-01, 6.7497875662E-01],
	[1.3990000000E+04, 8.8700534650E+00, 5.9370177103E+00, 9.5233845870E-01, 7.5119036764E-01, 6.7512907068E-01],
	[1.3995000000E+04, 8.8743159252E+00, 5.9366801201E+00, 9.5343027135E-01, 7.5189470702E-01, 6.7527934066E-01],
	[1.4000000000E+04, 8.8785789101E+00, 5.9363426698E+00, 9.5452294478E-01, 7.5259932145E-01, 6.7542956653E-01],
	[1.4005000000E+04, 8.8828424195E+00, 5.9360053591E+00, 9.5561647936E-01, 7.5330421070E-01, 6.7557974829E-01],
	[1.4010000000E+04, 8.8871064532E+00, 5.9356681879E+00, 9.5671087546E-01, 7.5400937452E-01, 6.7572988590E-01],
	[1.4015000000E+04, 8.8913710112E+00, 5.9353311562E+00, 9.5780613345E-01, 7.5471481270E-01, 6.7587997936E-01],
	[1.4020000000E+04, 8.8956360934E+00, 5.9349942639E+00, 9.5890225370E-01, 7.5542052498E-01, 6.7603002864E-01],
	[1.4025000000E+04, 8.8999016996E+00, 5.9346575108E+00, 9.5999923658E-01, 7.5612651113E-01, 6.7618003372E-01],
	[1.4030000000E+04, 8.9041678296E+00, 5.9343208968E+00, 9.6109708247E-01, 7.5683277092E-01, 6.7632999460E-01],
	[1.4035000000E+04, 8.9084344835E+00, 5.9339844219E+00, 9.6219579173E-01, 7.5753930412E-01, 6.7647991124E-01],
	[1.4040000000E+04, 8.9127016610E+00, 5.9336480859E+00, 9.6329536473E-01, 7.5824611047E-01, 6.7662978363E-01],
	[1.4045000000E+04, 8.9169693620E+00, 5.9333118886E+00, 9.6439580185E-01, 7.5895318976E-01, 6.7677961175E-01],
	[1.4050000000E+04, 8.9212375864E+00, 5.9329758301E+00, 9.6549710345E-01, 7.5966054173E-01, 6.7692939558E-01],
	[1.4055000000E+04, 8.9255063341E+00, 5.9326399102E+00, 9.6659926991E-01, 7.6036816616E-01, 6.7707913511E-01],
	[1.4060000000E+04, 8.9297756049E+00, 5.9323041288E+00, 9.6770230160E-01, 7.6107606281E-01, 6.7722883032E-01],
	[1.4065000000E+04, 8.9340453988E+00, 5.9319684857E+00, 9.6880619888E-01, 7.6178423143E-01, 6.7737848119E-01],
	[1.4070000000E+04, 8.9383157156E+00, 5.9316329809E+00, 9.6991096214E-01, 7.6249267179E-01, 6.7752808770E-01],
	[1.4075000000E+04, 8.9425865552E+00, 5.9312976143E+00, 9.7101659173E-01, 7.6320138366E-01, 6.7767764983E-01],
	[1.4080000000E+04, 8.9468579174E+00, 5.9309623858E+00, 9.7212308804E-01, 7.6391036679E-01, 6.7782716757E-01],
	[1.4085000000E+04, 8.9511298022E+00, 5.9306272952E+00, 9.7323045142E-01, 7.6461962094E-01, 6.7797664090E-01],
	[1.4090000000E+04, 8.9554022095E+00, 5.9302923425E+00, 9.7433868226E-01, 7.6532914589E-01, 6.7812606979E-01],
	[1.4095000000E+04, 8.9596751390E+00, 5.9299575275E+00, 9.7544778092E-01, 7.6603894138E-01, 6.7827545424E-01],
	[1.4100000000E+04, 8.9639485908E+00, 5.9296228502E+00, 9.7655774778E-01, 7.6674900718E-01, 6.7842479422E-01],
	[1.4105000000E+04, 8.9682225645E+00, 5.9292883104E+00, 9.7766858320E-01, 7.6745934306E-01, 6.7857408972E-01],
	[1.4110000000E+04, 8.9724970603E+00, 5.9289539081E+00, 9.7878028756E-01, 7.6816994876E-01, 6.7872334073E-01],
	[1.4115000000E+04, 8.9767720778E+00, 5.9286196430E+00, 9.7989286123E-01, 7.6888082405E-01, 6.7887254721E-01],
	[1.4120000000E+04, 8.9810517974E+00, 5.9282870202E+00, 9.8100630458E-01, 7.6959202476E-01, 6.7902170916E-01],
	[1.4125000000E+04, 8.9853449993E+00, 5.9279591966E+00, 9.8212061797E-01, 7.7030366871E-01, 6.7917082655E-01],
	[1.4130000000E+04, 8.9896387330E+00, 5.9276315071E+00, 9.8323580179E-01, 7.7101558219E-01, 6.7931989938E-01],
	[1.4135000000E+04, 8.9939329982E+00, 5.9273039517E+00, 9.8435185640E-01, 7.7172776496E-01, 6.7946892762E-01],
	[1.4140000000E+04, 8.9982277950E+00, 5.9269765302E+00, 9.8546878218E-01, 7.7244021679E-01, 6.7961791125E-01],
	[1.4145000000E+04, 9.0025231232E+00, 5.9266492425E+00, 9.8658657949E-01, 7.7315293743E-01, 6.7976685027E-01],
	[1.4150000000E+04, 9.0068189825E+00, 5.9263220886E+00, 9.8770524871E-01, 7.7386592665E-01, 6.7991574465E-01],
	[1.4155000000E+04, 9.0111153731E+00, 5.9259950683E+00, 9.8882479021E-01, 7.7457918419E-01, 6.8006459437E-01],
	[1.4160000000E+04, 9.0154122946E+00, 5.9256681816E+00, 9.8994520435E-01, 7.7529270983E-01, 6.8021339942E-01],
	[1.4165000000E+04, 9.0197097470E+00, 5.9253414282E+00, 9.9106649152E-01, 7.7600650333E-01, 6.8036215978E-01],
	[1.4170000000E+04, 9.0240077301E+00, 5.9250148082E+00, 9.9218865208E-01, 7.7672056443E-01, 6.8051087544E-01],
	[1.4175000000E+04, 9.0283062439E+00, 5.9246883214E+00, 9.9331168640E-01, 7.7743489290E-01, 6.8065954637E-01],
	[1.4180000000E+04, 9.0326052882E+00, 5.9243619678E+00, 9.9443559486E-01, 7.7814948851E-01, 6.8080817256E-01],
	[1.4185000000E+04, 9.0369048629E+00, 5.9240357471E+00, 9.9556037782E-01, 7.7886435100E-01, 6.8095675400E-01],
	[1.4190000000E+04, 9.0412049679E+00, 5.9237096594E+00, 9.9668603566E-01, 7.7957948013E-01, 6.8110529067E-01],
	[1.4195000000E+04, 9.0455056031E+00, 5.9233837045E+00, 9.9781256876E-01, 7.8029487568E-01, 6.8125378255E-01],
	[1.4200000000E+04, 9.0498067682E+00, 5.9230578823E+00, 9.9893997747E-01, 7.8101053738E-01, 6.8140222962E-01],
	[1.4205000000E+04, 9.0541084633E+00, 5.9227321928E+00, 1.0000682622E+00, 7.8172646500E-01, 6.8155063188E-01],
	[1.4210000000E+04, 9.0584106881E+00, 5.9224066357E+00, 1.0011974232E+00, 7.8244265830E-01, 6.8169898929E-01],
	[1.4215000000E+04, 9.0627134427E+00, 5.9220812111E+00, 1.0023274611E+00, 7.8315911704E-01, 6.8184730185E-01],
	[1.4220000000E+04, 9.0670167267E+00, 5.9217559188E+00, 1.0034583760E+00, 7.8387584097E-01, 6.8199556954E-01],
	[1.4225000000E+04, 9.0713205402E+00, 5.9214307587E+00, 1.0045901684E+00, 7.8459282985E-01, 6.8214379234E-01],
	[1.4230000000E+04, 9.0756248830E+00, 5.9211057307E+00, 1.0057228386E+00, 7.8531008343E-01, 6.8229197025E-01],
	[1.4235000000E+04, 9.0799297550E+00, 5.9207808348E+00, 1.0068563871E+00, 7.8602760148E-01, 6.8244010323E-01],
	[1.4240000000E+04, 9.0842351560E+00, 5.9204560707E+00, 1.0079908141E+00, 7.8674538375E-01, 6.8258819128E-01],
	[1.4245000000E+04, 9.0885410860E+00, 5.9201314385E+00, 1.0091261202E+00, 7.8746342999E-01, 6.8273623437E-01],
	[1.4250000000E+04, 9.0928475448E+00, 5.9198069380E+00, 1.0102623055E+00, 7.8818173997E-01, 6.8288423250E-01],
	[1.4255000000E+04, 9.0971545323E+00, 5.9194825691E+00, 1.0113993706E+00, 7.8890031343E-01, 6.8303218565E-01],
	[1.4260000000E+04, 9.1014620484E+00, 5.9191583318E+00, 1.0125373158E+00, 7.8961915014E-01, 6.8318009380E-01],
	[1.4265000000E+04, 9.1057700929E+00, 5.9188342258E+00, 1.0136761414E+00, 7.9033824985E-01, 6.8332795694E-01],
	[1.4270000000E+04, 9.1100786658E+00, 5.9185102512E+00, 1.0148158478E+00, 7.9105761231E-01, 6.8347577505E-01],
	[1.4275000000E+04, 9.1143877669E+00, 5.9181864077E+00, 1.0159564355E+00, 7.9177723728E-01, 6.8362354811E-01],
	[1.4280000000E+04, 9.1186973961E+00, 5.9178626955E+00, 1.0170979047E+00, 7.9249712452E-01, 6.8377127611E-01],
	[1.4285000000E+04, 9.1230075533E+00, 5.9175391142E+00, 1.0182402559E+00, 7.9321727377E-01, 6.8391895904E-01],
	[1.4290000000E+04, 9.1273182383E+00, 5.9172156638E+00, 1.0193834893E+00, 7.9393768480E-01, 6.8406659688E-01],
	[1.4295000000E+04, 9.1316294510E+00, 5.9168923443E+00, 1.0205276055E+00, 7.9465835736E-01, 6.8421418960E-01],
	[1.4300000000E+04, 9.1359411914E+00, 5.9165691555E+00, 1.0216726047E+00, 7.9537929121E-01, 6.8436173721E-01],
	[1.4305000000E+04, 9.1402534593E+00, 5.9162460973E+00, 1.0228184873E+00, 7.9610048609E-01, 6.8450923968E-01],
	[1.4310000000E+04, 9.1445662545E+00, 5.9159231697E+00, 1.0239652538E+00, 7.9682194176E-01, 6.8465669699E-01],
	[1.4315000000E+04, 9.1488795770E+00, 5.9156003725E+00, 1.0251129044E+00, 7.9754365798E-01, 6.8480410914E-01],
	[1.4320000000E+04, 9.1531934267E+00, 5.9152777056E+00, 1.0262614396E+00, 7.9826563449E-01, 6.8495147611E-01],
	[1.4325000000E+04, 9.1575078033E+00, 5.9149551690E+00, 1.0274108597E+00, 7.9898787106E-01, 6.8509879787E-01],
	[1.4330000000E+04, 9.1618227069E+00, 5.9146327624E+00, 1.0285611650E+00, 7.9971036744E-01, 6.8524607443E-01],
	[1.4335000000E+04, 9.1661381372E+00, 5.9143104860E+00, 1.0297123561E+00, 8.0043312337E-01, 6.8539330576E-01],
	[1.4340000000E+04, 9.1704540942E+00, 5.9139883394E+00, 1.0308644332E+00, 8.0115613861E-01, 6.8554049184E-01],
	[1.4345000000E+04, 9.1747705778E+00, 5.9136663228E+00, 1.0320173966E+00, 8.0187941292E-01, 6.8568763267E-01],
	[1.4350000000E+04, 9.1791015847E+00, 5.9133492418E+00, 1.0331712469E+00, 8.0260314159E-01, 6.8583472822E-01],
	[1.4355000000E+04, 9.1834369534E+00, 5.9130336016E+00, 1.0343259843E+00, 8.0332718290E-01, 6.8598177849E-01],
	[1.4360000000E+04, 9.1877728588E+00, 5.9127180882E+00, 1.0354816093E+00, 8.0405148323E-01, 6.8612878345E-01],
	[1.4365000000E+04, 9.1921093009E+00, 5.9124027015E+00, 1.0366381221E+00, 8.0477604233E-01, 6.8627574310E-01],
	[1.4370000000E+04, 9.1964462795E+00, 5.9120874413E+00, 1.0377955233E+00, 8.0550085995E-01, 6.8642265742E-01],
	[1.4375000000E+04, 9.2007837946E+00, 5.9117723076E+00, 1.0389538130E+00, 8.0622593584E-01, 6.8656952639E-01],
	[1.4380000000E+04, 9.2051218459E+00, 5.9114573003E+00, 1.0401129918E+00, 8.0695126976E-01, 6.8671635001E-01],
	[1.4385000000E+04, 9.2094604333E+00, 5.9111424193E+00, 1.0412730600E+00, 8.0767686146E-01, 6.8686312825E-01],
	[1.4390000000E+04, 9.2137995569E+00, 5.9108276645E+00, 1.0424340179E+00, 8.0840271070E-01, 6.8700986110E-01],
	[1.4395000000E+04, 9.2181392163E+00, 5.9105130358E+00, 1.0435958659E+00, 8.0912881721E-01, 6.8715654854E-01],
	[1.4400000000E+04, 9.2224794116E+00, 5.9101985330E+00, 1.0447586045E+00, 8.0985518076E-01, 6.8730319057E-01],
	[1.4405000000E+04, 9.2268201425E+00, 5.9098841562E+00, 1.0459222340E+00, 8.1058180110E-01, 6.8744978717E-01],
	[1.4410000000E+04, 9.2311614090E+00, 5.9095699052E+00, 1.0470867547E+00, 8.1130867797E-01, 6.8759633833E-01],
	[1.4415000000E+04, 9.2355032110E+00, 5.9092557799E+00, 1.0482521670E+00, 8.1203581113E-01, 6.8774284402E-01],
	[1.4420000000E+04, 9.2398455483E+00, 5.9089417803E+00, 1.0494184713E+00, 8.1276320033E-01, 6.8788930425E-01],
	[1.4425000000E+04, 9.2441884208E+00, 5.9086279062E+00, 1.0505856680E+00, 8.1349084532E-01, 6.8803571898E-01],
	[1.4430000000E+04, 9.2485318284E+00, 5.9083141575E+00, 1.0517537574E+00, 8.1421874585E-01, 6.8818208822E-01],
	[1.4435000000E+04, 9.2528757709E+00, 5.9080005342E+00, 1.0529227400E+00, 8.1494690167E-01, 6.8832841193E-01],
	[1.4440000000E+04, 9.2572202484E+00, 5.9076870361E+00, 1.0540926160E+00, 8.1567531253E-01, 6.8847469012E-01],
	[1.4445000000E+04, 9.2615652605E+00, 5.9073736632E+00, 1.0552633859E+00, 8.1640397818E-01, 6.8862092277E-01],
	[1.4450000000E+04, 9.2659108073E+00, 5.9070604153E+00, 1.0564350500E+00, 8.1713289837E-01, 6.8876710986E-01],
	[1.4455000000E+04, 9.2702568885E+00, 5.9067472925E+00, 1.0576076088E+00, 8.1786207285E-01, 6.8891325139E-01],
	[1.4460000000E+04, 9.2746035041E+00, 5.9064342945E+00, 1.0587810625E+00, 8.1859150138E-01, 6.8905934732E-01],
	[1.4465000000E+04, 9.2789506540E+00, 5.9061214212E+00, 1.0599554116E+00, 8.1932118369E-01, 6.8920539767E-01],
	[1.4470000000E+04, 9.2832983380E+00, 5.9058086727E+00, 1.0611306563E+00, 8.2005111954E-01, 6.8935140240E-01],
	[1.4475000000E+04, 9.2876465560E+00, 5.9054960488E+00, 1.0623067972E+00, 8.2078130867E-01, 6.8949736151E-01],
	[1.4480000000E+04, 9.2919953080E+00, 5.9051835494E+00, 1.0634838346E+00, 8.2151175084E-01, 6.8964327498E-01],
	[1.4485000000E+04, 9.2963445937E+00, 5.9048711744E+00, 1.0646617688E+00, 8.2224244580E-01, 6.8978914280E-01],
	[1.4490000000E+04, 9.3006944130E+00, 5.9045589238E+00, 1.0658406003E+00, 8.2297339329E-01, 6.8993496495E-01],
	[1.4495000000E+04, 9.3050447659E+00, 5.9042467973E+00, 1.0670203293E+00, 8.2370459306E-01, 6.9008074143E-01],
	[1.4500000000E+04, 9.3093956523E+00, 5.9039347950E+00, 1.0682009563E+00, 8.2443604487E-01, 6.9022647222E-01],
	[1.4505000000E+04, 9.3137470719E+00, 5.9036229168E+00, 1.0693824816E+00, 8.2516774844E-01, 6.9037215731E-01],
	[1.4510000000E+04, 9.3180990247E+00, 5.9033111625E+00, 1.0705649056E+00, 8.2589970355E-01, 6.9051779668E-01],
	[1.4515000000E+04, 9.3224515106E+00, 5.9029995321E+00, 1.0717482287E+00, 8.2663190992E-01, 6.9066339032E-01],
	[1.4520000000E+04, 9.3268045294E+00, 5.9026880254E+00, 1.0729324513E+00, 8.2736436732E-01, 6.9080893822E-01],
	[1.4525000000E+04, 9.3311580811E+00, 5.9023766424E+00, 1.0741175737E+00, 8.2809707549E-01, 6.9095444037E-01],
	[1.4530000000E+04, 9.3355121655E+00, 5.9020653831E+00, 1.0753035963E+00, 8.2883003417E-01, 6.9109989675E-01],
	[1.4535000000E+04, 9.3398667825E+00, 5.9017542472E+00, 1.0764905195E+00, 8.2956324311E-01, 6.9124530734E-01],
	[1.4540000000E+04, 9.3442219319E+00, 5.9014432347E+00, 1.0776783437E+00, 8.3029670206E-01, 6.9139067215E-01],
	[1.4545000000E+04, 9.3485776137E+00, 5.9011323455E+00, 1.0788670691E+00, 8.3103041076E-01, 6.9153599115E-01],
	[1.4550000000E+04, 9.3529338277E+00, 5.9008215796E+00, 1.0800566963E+00, 8.3176436897E-01, 6.9168126433E-01],
	[1.4555000000E+04, 9.3572905739E+00, 5.9005109367E+00, 1.0812472255E+00, 8.3249857643E-01, 6.9182649168E-01],
	[1.4560000000E+04, 9.3616478521E+00, 5.9002004170E+00, 1.0824386572E+00, 8.3323303288E-01, 6.9197167323E-01],
	[1.4565000000E+04, 9.3660056621E+00, 5.8998900201E+00, 1.0836309917E+00, 8.3396773807E-01, 6.9211680899E-01],
	[1.4570000000E+04, 9.3703640040E+00, 5.8995797462E+00, 1.0848242294E+00, 8.3470269174E-01, 6.9226189893E-01],
	[1.4575000000E+04, 9.3747228774E+00, 5.8992695950E+00, 1.0860183706E+00, 8.3543789365E-01, 6.9240694304E-01],
	[1.4580000000E+04, 9.3790932975E+00, 5.8989631782E+00, 1.0872134158E+00, 8.3617350365E-01, 6.9255194130E-01],
	[1.4585000000E+04, 9.3834717588E+00, 5.8986593416E+00, 1.0884093653E+00, 8.3690947101E-01, 6.9269689370E-01],
	[1.4590000000E+04, 9.3878507623E+00, 5.8983556247E+00, 1.0896062195E+00, 8.3764568656E-01, 6.9284180023E-01],
	[1.4595000000E+04, 9.3922303078E+00, 5.8980520275E+00, 1.0908039788E+00, 8.3838215006E-01, 6.9298666086E-01],
	[1.4600000000E+04, 9.3966103954E+00, 5.8977485499E+00, 1.0920026434E+00, 8.3911886124E-01, 6.9313147557E-01],
	[1.4605000000E+04, 9.4009910247E+00, 5.8974451918E+00, 1.0932022139E+00, 8.3985581987E-01, 6.9327624437E-01],
	[1.4610000000E+04, 9.4053721958E+00, 5.8971419531E+00, 1.0944026906E+00, 8.4059302567E-01, 6.9342096722E-01],
	[1.4615000000E+04, 9.4097539085E+00, 5.8968388338E+00, 1.0956040738E+00, 8.4133047841E-01, 6.9356564411E-01],
	[1.4620000000E+04, 9.4141361627E+00, 5.8965358338E+00, 1.0968063640E+00, 8.4206817781E-01, 6.9371027503E-01],
	[1.4625000000E+04, 9.4185189582E+00, 5.8962329529E+00, 1.0980095614E+00, 8.4280612363E-01, 6.9385485996E-01],
	[1.4630000000E+04, 9.4229022950E+00, 5.8959301911E+00, 1.0992136665E+00, 8.4354431561E-01, 6.9399939889E-01],
	[1.4635000000E+04, 9.4272861730E+00, 5.8956275483E+00, 1.1004186797E+00, 8.4428275350E-01, 6.9414389180E-01],
	[1.4640000000E+04, 9.4316705919E+00, 5.8953250244E+00, 1.1016246013E+00, 8.4502143704E-01, 6.9428833867E-01],
	[1.4645000000E+04, 9.4360555517E+00, 5.8950226193E+00, 1.1028314317E+00, 8.4576036598E-01, 6.9443273949E-01],
	[1.4650000000E+04, 9.4404410523E+00, 5.8947203330E+00, 1.1040391713E+00, 8.4649954005E-01, 6.9457709425E-01],
	[1.4655000000E+04, 9.4448270936E+00, 5.8944181653E+00, 1.1052478204E+00, 8.4723895901E-01, 6.9472140292E-01],
	[1.4660000000E+04, 9.4492136754E+00, 5.8941161161E+00, 1.1064573794E+00, 8.4797862259E-01, 6.9486566550E-01],
	[1.4665000000E+04, 9.4536007977E+00, 5.8938141855E+00, 1.1076678488E+00, 8.4871853055E-01, 6.9500988197E-01],
	[1.4670000000E+04, 9.4579884602E+00, 5.8935123732E+00, 1.1088792288E+00, 8.4945868262E-01, 6.9515405231E-01],
	[1.4675000000E+04, 9.4623766629E+00, 5.8932106792E+00, 1.1100915198E+00, 8.5019907854E-01, 6.9529817651E-01],
	[1.4680000000E+04, 9.4667654057E+00, 5.8929091034E+00, 1.1113047223E+00, 8.5093971807E-01, 6.9544225456E-01],
	[1.4685000000E+04, 9.4711546885E+00, 5.8926076457E+00, 1.1125188365E+00, 8.5168060094E-01, 6.9558628643E-01],
	[1.4690000000E+04, 9.4755445111E+00, 5.8923063061E+00, 1.1137338629E+00, 8.5242172690E-01, 6.9573027212E-01],
	[1.4695000000E+04, 9.4799348734E+00, 5.8920050845E+00, 1.1149498019E+00, 8.5316309568E-01, 6.9587421160E-01],
	[1.4700000000E+04, 9.4843257753E+00, 5.8917039806E+00, 1.1161666537E+00, 8.5390470704E-01, 6.9601810488E-01],
	[1.4705000000E+04, 9.4887172167E+00, 5.8914029946E+00, 1.1173844189E+00, 8.5464656071E-01, 6.9616195192E-01],
	[1.4710000000E+04, 9.4931091974E+00, 5.8911021263E+00, 1.1186030977E+00, 8.5538865644E-01, 6.9630575271E-01],
	[1.4715000000E+04, 9.4975017175E+00, 5.8908013756E+00, 1.1198226905E+00, 8.5613099396E-01, 6.9644950725E-01],
	[1.4720000000E+04, 9.5018947766E+00, 5.8905007424E+00, 1.1210431978E+00, 8.5687357303E-01, 6.9659321552E-01],
	[1.4725000000E+04, 9.5062883747E+00, 5.8902002266E+00, 1.1222646198E+00, 8.5761639338E-01, 6.9673687749E-01],
	[1.4730000000E+04, 9.5106825118E+00, 5.8898998282E+00, 1.1234869570E+00, 8.5835945475E-01, 6.9688049317E-01],
	[1.4735000000E+04, 9.5150771876E+00, 5.8895995470E+00, 1.1247102097E+00, 8.5910275689E-01, 6.9702406252E-01],
	[1.4740000000E+04, 9.5194724021E+00, 5.8892993830E+00, 1.1259343783E+00, 8.5984629953E-01, 6.9716758555E-01],
	[1.4745000000E+04, 9.5238681552E+00, 5.8889993361E+00, 1.1271594633E+00, 8.6059008243E-01, 6.9731106223E-01],
	[1.4750000000E+04, 9.5282644467E+00, 5.8886994062E+00, 1.1283854648E+00, 8.6133410531E-01, 6.9745449256E-01],
	[1.4755000000E+04, 9.5326612765E+00, 5.8883995933E+00, 1.1296123834E+00, 8.6207836792E-01, 6.9759787650E-01],
	[1.4760000000E+04, 9.5370586445E+00, 5.8880998972E+00, 1.1308402194E+00, 8.6282287000E-01, 6.9774121407E-01],
	[1.4765000000E+04, 9.5414565505E+00, 5.8878003178E+00, 1.1320689732E+00, 8.6356761130E-01, 6.9788450523E-01],
	[1.4770000000E+04, 9.5458549946E+00, 5.8875008551E+00, 1.1332986451E+00, 8.6431259154E-01, 6.9802774997E-01],
	[1.4775000000E+04, 9.5502539765E+00, 5.8872015090E+00, 1.1345292356E+00, 8.6505781048E-01, 6.9817094829E-01],
	[1.4780000000E+04, 9.5546534961E+00, 5.8869022793E+00, 1.1357607450E+00, 8.6580326785E-01, 6.9831410016E-01],
	[1.4785000000E+04, 9.5590535533E+00, 5.8866031661E+00, 1.1369931736E+00, 8.6654896339E-01, 6.9845720558E-01],
	[1.4790000000E+04, 9.5634541481E+00, 5.8863041692E+00, 1.1382265219E+00, 8.6729489684E-01, 6.9860026453E-01],
	[1.4795000000E+04, 9.5678552802E+00, 5.8860052886E+00, 1.1394607902E+00, 8.6804106795E-01, 6.9874327699E-01],
	[1.4800000000E+04, 9.5722569496E+00, 5.8857065241E+00, 1.1406959790E+00, 8.6878747644E-01, 6.9888624296E-01],
	[1.4805000000E+04, 9.5766591561E+00, 5.8854078757E+00, 1.1419320885E+00, 8.6953412207E-01, 6.9902916242E-01],
	[1.4810000000E+04, 9.5810618997E+00, 5.8851093433E+00, 1.1431691191E+00, 8.7028100457E-01, 6.9917203535E-01],
	[1.4815000000E+04, 9.5854778812E+00, 5.8848149068E+00, 1.1444070713E+00, 8.7102831574E-01, 6.9931486174E-01],
	[1.4820000000E+04, 9.5899009273E+00, 5.8845226268E+00, 1.1456459454E+00, 8.7177596248E-01, 6.9945764159E-01],
	[1.4825000000E+04, 9.5943245214E+00, 5.8842304599E+00, 1.1468857417E+00, 8.7252384608E-01, 6.9960037487E-01],
	[1.4830000000E+04, 9.5987486632E+00, 5.8839384060E+00, 1.1481264607E+00, 8.7327196627E-01, 6.9974306157E-01],
	[1.4835000000E+04, 9.6031733527E+00, 5.8836464650E+00, 1.1493681028E+00, 8.7402032279E-01, 6.9988570168E-01],
	[1.4840000000E+04, 9.6075985897E+00, 5.8833546369E+00, 1.1506106682E+00, 8.7476891538E-01, 7.0002829519E-01],
	[1.4845000000E+04, 9.6120243742E+00, 5.8830629215E+00, 1.1518541574E+00, 8.7551774379E-01, 7.0017084208E-01],
	[1.4850000000E+04, 9.6164507060E+00, 5.8827713189E+00, 1.1530985708E+00, 8.7626680775E-01, 7.0031334234E-01],
	[1.4855000000E+04, 9.6208775850E+00, 5.8824798288E+00, 1.1543439086E+00, 8.7701610699E-01, 7.0045579596E-01],
	[1.4860000000E+04, 9.6253050110E+00, 5.8821884513E+00, 1.1555901714E+00, 8.7776564127E-01, 7.0059820292E-01],
	[1.4865000000E+04, 9.6297329841E+00, 5.8818971863E+00, 1.1568373595E+00, 8.7851541031E-01, 7.0074056321E-01],
	[1.4870000000E+04, 9.6341615039E+00, 5.8816060336E+00, 1.1580854732E+00, 8.7926541386E-01, 7.0088287683E-01],
	[1.4875000000E+04, 9.6385905706E+00, 5.8813149932E+00, 1.1593345129E+00, 8.8001565165E-01, 7.0102514375E-01],
	[1.4880000000E+04, 9.6430201838E+00, 5.8810240650E+00, 1.1605844791E+00, 8.8076612342E-01, 7.0116736396E-01],
	[1.4885000000E+04, 9.6474503435E+00, 5.8807332490E+00, 1.1618353720E+00, 8.8151682892E-01, 7.0130953745E-01],
	[1.4890000000E+04, 9.6518810496E+00, 5.8804425449E+00, 1.1630871920E+00, 8.8226776787E-01, 7.0145166422E-01],
	[1.4895000000E+04, 9.6563123020E+00, 5.8801519529E+00, 1.1643399396E+00, 8.8301894002E-01, 7.0159374423E-01],
	[1.4900000000E+04, 9.6607441005E+00, 5.8798614727E+00, 1.1655936151E+00, 8.8377034510E-01, 7.0173577750E-01],
	[1.4905000000E+04, 9.6651764451E+00, 5.8795711043E+00, 1.1668482189E+00, 8.8452198285E-01, 7.0187776399E-01],
	[1.4910000000E+04, 9.6696093356E+00, 5.8792808477E+00, 1.1681037513E+00, 8.8527385301E-01, 7.0201970370E-01],
	[1.4915000000E+04, 9.6740427718E+00, 5.8789907027E+00, 1.1693602127E+00, 8.8602595531E-01, 7.0216159662E-01],
	[1.4920000000E+04, 9.6784767538E+00, 5.8787006692E+00, 1.1706176036E+00, 8.8677828950E-01, 7.0230344273E-01],
	[1.4925000000E+04, 9.6829112813E+00, 5.8784107473E+00, 1.1718759242E+00, 8.8753085530E-01, 7.0244524202E-01],
	[1.4930000000E+04, 9.6873463543E+00, 5.8781209367E+00, 1.1731351750E+00, 8.8828365246E-01, 7.0258699449E-01],
	[1.4935000000E+04, 9.6917819727E+00, 5.8778312375E+00, 1.1743953563E+00, 8.8903668071E-01, 7.0272870011E-01],
	[1.4940000000E+04, 9.6962181362E+00, 5.8775416495E+00, 1.1756564685E+00, 8.8978993979E-01, 7.0287035888E-01],
	[1.4945000000E+04, 9.7006548449E+00, 5.8772521726E+00, 1.1769185120E+00, 8.9054342944E-01, 7.0301197078E-01],
	[1.4950000000E+04, 9.7050920986E+00, 5.8769628069E+00, 1.1781814871E+00, 8.9129714939E-01, 7.0315353581E-01],
	[1.4955000000E+04, 9.7095298971E+00, 5.8766735521E+00, 1.1794453943E+00, 8.9205109937E-01, 7.0329505394E-01],
	[1.4960000000E+04, 9.7139682404E+00, 5.8763844083E+00, 1.1807102339E+00, 8.9280527913E-01, 7.0343652517E-01],
	[1.4965000000E+04, 9.7184071283E+00, 5.8760953753E+00, 1.1819760063E+00, 8.9355968840E-01, 7.0357794949E-01],
	[1.4970000000E+04, 9.7228465608E+00, 5.8758064531E+00, 1.1832427118E+00, 8.9431432691E-01, 7.0371932689E-01],
	[1.4975000000E+04, 9.7272865377E+00, 5.8755176415E+00, 1.1845103508E+00, 8.9506919440E-01, 7.0386065735E-01],
	[1.4980000000E+04, 9.7317270589E+00, 5.8752289406E+00, 1.1857789238E+00, 8.9582429061E-01, 7.0400194086E-01],
	[1.4985000000E+04, 9.7361681243E+00, 5.8749403502E+00, 1.1870484310E+00, 8.9657961527E-01, 7.0414317741E-01],
	[1.4990000000E+04, 9.7406097338E+00, 5.8746518702E+00, 1.1883188729E+00, 8.9733516812E-01, 7.0428436699E-01],
	[1.4995000000E+04, 9.7450518872E+00, 5.8743635006E+00, 1.1895902499E+00, 8.9809094889E-01, 7.0442550958E-01],
	[1.5000000000E+04, 9.7494945845E+00, 5.8740752413E+00, 1.1908625622E+00, 8.9884695731E-01, 7.0456660519E-01],
	[1.5005000000E+04, 9.7539378255E+00, 5.8737870921E+00, 1.1921394472E+00, 8.9960526406E-01, 7.0470765378E-01],
	[1.5010000000E+04, 9.7583816101E+00, 5.8734990532E+00, 1.1934172748E+00, 9.0036379980E-01, 7.0484865537E-01],
	[1.5015000000E+04, 9.7628259382E+00, 5.8732111242E+00, 1.1946960456E+00, 9.0112256427E-01, 7.0498960992E-01],
	[1.5020000000E+04, 9.7672708097E+00, 5.8729233053E+00, 1.1959757600E+00, 9.0188155718E-01, 7.0513051744E-01],
	[1.5025000000E+04, 9.7717162244E+00, 5.8726355962E+00, 1.1972564182E+00, 9.0264077828E-01, 7.0527137790E-01],
	[1.5030000000E+04, 9.7761621823E+00, 5.8723479970E+00, 1.1985380207E+00, 9.0340022731E-01, 7.0541219131E-01],
	[1.5035000000E+04, 9.7806086833E+00, 5.8720605075E+00, 1.1998205679E+00, 9.0415990398E-01, 7.0555295764E-01],
	[1.5040000000E+04, 9.7850557272E+00, 5.8717731276E+00, 1.2011040601E+00, 9.0491980803E-01, 7.0569367689E-01],
	[1.5045000000E+04, 9.7895033139E+00, 5.8714858573E+00, 1.2023884977E+00, 9.0567993920E-01, 7.0583434905E-01],
	[1.5050000000E+04, 9.7939514432E+00, 5.8711986966E+00, 1.2036738812E+00, 9.0644029722E-01, 7.0597497410E-01],
	[1.5055000000E+04, 9.7984194148E+00, 5.8709174428E+00, 1.2049602108E+00, 9.0720118569E-01, 7.0611555204E-01],
	[1.5060000000E+04, 9.8028885124E+00, 5.8706364678E+00, 1.2062474871E+00, 9.0796231027E-01, 7.0625608286E-01],
	[1.5065000000E+04, 9.8073581637E+00, 5.8703555995E+00, 1.2075357102E+00, 9.0872366170E-01, 7.0639656653E-01],
	[1.5070000000E+04, 9.8118283688E+00, 5.8700748379E+00, 1.2088248807E+00, 9.0948523971E-01, 7.0653700306E-01],
	[1.5075000000E+04, 9.8162991275E+00, 5.8697941828E+00, 1.2101149989E+00, 9.1024704402E-01, 7.0667739243E-01],
	[1.5080000000E+04, 9.8207704397E+00, 5.8695136341E+00, 1.2114060653E+00, 9.1100907438E-01, 7.0681773464E-01],
	[1.5085000000E+04, 9.8252423053E+00, 5.8692331919E+00, 1.2126980800E+00, 9.1177133051E-01, 7.0695802966E-01],
	[1.5090000000E+04, 9.8297147242E+00, 5.8689528560E+00, 1.2139910437E+00, 9.1253381215E-01, 7.0709827750E-01],
	[1.5095000000E+04, 9.8341876962E+00, 5.8686726264E+00, 1.2152849566E+00, 9.1329651902E-01, 7.0723847814E-01],
	[1.5100000000E+04, 9.8386612212E+00, 5.8683925030E+00, 1.2165798191E+00, 9.1405945086E-01, 7.0737863157E-01],
	[1.5105000000E+04, 9.8431352991E+00, 5.8681124856E+00, 1.2178756317E+00, 9.1482260740E-01, 7.0751873777E-01],
	[1.5110000000E+04, 9.8476099299E+00, 5.8678325743E+00, 1.2191723946E+00, 9.1558598836E-01, 7.0765879675E-01],
	[1.5115000000E+04, 9.8520851134E+00, 5.8675527690E+00, 1.2204701083E+00, 9.1634959349E-01, 7.0779880849E-01],
	[1.5120000000E+04, 9.8565608494E+00, 5.8672730695E+00, 1.2217687731E+00, 9.1711342251E-01, 7.0793877298E-01],
	[1.5125000000E+04, 9.8610371379E+00, 5.8669934758E+00, 1.2230683895E+00, 9.1787747515E-01, 7.0807869021E-01],
	[1.5130000000E+04, 9.8655139787E+00, 5.8667139879E+00, 1.2243689578E+00, 9.1864175115E-01, 7.0821856017E-01],
	[1.5135000000E+04, 9.8699913718E+00, 5.8664346056E+00, 1.2256704784E+00, 9.1940625022E-01, 7.0835838285E-01],
	[1.5140000000E+04, 9.8744693169E+00, 5.8661553288E+00, 1.2269729516E+00, 9.2017097211E-01, 7.0849815824E-01],
	[1.5145000000E+04, 9.8789478141E+00, 5.8658761576E+00, 1.2282763780E+00, 9.2093591654E-01, 7.0863788633E-01],
	[1.5150000000E+04, 9.8834268632E+00, 5.8655970919E+00, 1.2295807578E+00, 9.2170108325E-01, 7.0877756711E-01],
	[1.5155000000E+04, 9.8879064641E+00, 5.8653181314E+00, 1.2308860914E+00, 9.2246647196E-01, 7.0891720057E-01],
	[1.5160000000E+04, 9.8923866166E+00, 5.8650392763E+00, 1.2321923792E+00, 9.2323208240E-01, 7.0905678670E-01],
	[1.5165000000E+04, 9.8968673206E+00, 5.8647605264E+00, 1.2334996216E+00, 9.2399791430E-01, 7.0919632549E-01],
	[1.5170000000E+04, 9.9013485761E+00, 5.8644818816E+00, 1.2348078190E+00, 9.2476396740E-01, 7.0933581694E-01],
	[1.5175000000E+04, 9.9058303829E+00, 5.8642033418E+00, 1.2361169717E+00, 9.2553024141E-01, 7.0947526103E-01],
	[1.5180000000E+04, 9.9103127410E+00, 5.8639249071E+00, 1.2374270802E+00, 9.2629673608E-01, 7.0961465775E-01],
	[1.5185000000E+04, 9.9147956501E+00, 5.8636465772E+00, 1.2387381448E+00, 9.2706345113E-01, 7.0975400710E-01],
	[1.5190000000E+04, 9.9192791102E+00, 5.8633683522E+00, 1.2400501659E+00, 9.2783038628E-01, 7.0989330906E-01],
	[1.5195000000E+04, 9.9237631211E+00, 5.8630902319E+00, 1.2413631438E+00, 9.2859754128E-01, 7.1003256363E-01],
	[1.5200000000E+04, 9.9282476828E+00, 5.8628122164E+00, 1.2426770791E+00, 9.2936491584E-01, 7.1017177079E-01],
	[1.5205000000E+04, 9.9327327952E+00, 5.8625343054E+00, 1.2439919720E+00, 9.3013250969E-01, 7.1031093054E-01],
	[1.5210000000E+04, 9.9372184580E+00, 5.8622564990E+00, 1.2453078229E+00, 9.3090032257E-01, 7.1045004287E-01],
	[1.5215000000E+04, 9.9417046713E+00, 5.8619787971E+00, 1.2466246323E+00, 9.3166835420E-01, 7.1058910776E-01],
	[1.5220000000E+04, 9.9461914349E+00, 5.8617011995E+00, 1.2479424004E+00, 9.3243660431E-01, 7.1072812522E-01],
	[1.5225000000E+04, 9.9506787487E+00, 5.8614237063E+00, 1.2492611277E+00, 9.3320507263E-01, 7.1086709522E-01],
	[1.5230000000E+04, 9.9551666125E+00, 5.8611463173E+00, 1.2505808146E+00, 9.3397375889E-01, 7.1100601777E-01],
	[1.5235000000E+04, 9.9596550263E+00, 5.8608690325E+00, 1.2519014615E+00, 9.3474266281E-01, 7.1114489285E-01],
	[1.5240000000E+04, 9.9641439899E+00, 5.8605918518E+00, 1.2532230686E+00, 9.3551178412E-01, 7.1128372045E-01],
	[1.5245000000E+04, 9.9686335033E+00, 5.8603147751E+00, 1.2545456365E+00, 9.3628112256E-01, 7.1142250057E-01],
	[1.5250000000E+04, 9.9731235663E+00, 5.8600378023E+00, 1.2558691654E+00, 9.3705067784E-01, 7.1156123320E-01],
	[1.5255000000E+04, 9.9776141787E+00, 5.8597609335E+00, 1.2571936559E+00, 9.3782044970E-01, 7.1169991832E-01],
	[1.5260000000E+04, 9.9821053406E+00, 5.8594841684E+00, 1.2585191082E+00, 9.3859043786E-01, 7.1183855594E-01],
	[1.5265000000E+04, 9.9865970518E+00, 5.8592075071E+00, 1.2598455227E+00, 9.3936064205E-01, 7.1197714603E-01],
	[1.5270000000E+04, 9.9910893121E+00, 5.8589309495E+00, 1.2611728998E+00, 9.4013106199E-01, 7.1211568860E-01],
	[1.5275000000E+04, 9.9955821215E+00, 5.8586544954E+00, 1.2625012400E+00, 9.4090169742E-01, 7.1225418362E-01],
	[1.5280000000E+04, 1.0000075480E+01, 5.8583781448E+00, 1.2638305436E+00, 9.4167254807E-01, 7.1239263111E-01],
	[1.5285000000E+04, 1.0004569387E+01, 5.8581018977E+00, 1.2651608109E+00, 9.4244361365E-01, 7.1253103104E-01],
	[1.5290000000E+04, 1.0009063843E+01, 5.8578257540E+00, 1.2664920424E+00, 9.4321489389E-01, 7.1266938341E-01],
	[1.5295000000E+04, 1.0013569326E+01, 5.8575527492E+00, 1.2678242384E+00, 9.4398656049E-01, 7.1280768821E-01],
	[1.5300000000E+04, 1.0018085281E+01, 5.8572827179E+00, 1.2691573993E+00, 9.4475860455E-01, 7.1294594543E-01],
	[1.5305000000E+04, 1.0022601796E+01, 5.8570127873E+00, 1.2704915255E+00, 9.4553086328E-01, 7.1308415507E-01],
	[1.5310000000E+04, 1.0027118870E+01, 5.8567429572E+00, 1.2718266175E+00, 9.4630333643E-01, 7.1322231711E-01],
	[1.5315000000E+04, 1.0031636505E+01, 5.8564732277E+00, 1.2731626755E+00, 9.4707602371E-01, 7.1336043155E-01],
	[1.5320000000E+04, 1.0036154699E+01, 5.8562035987E+00, 1.2744996999E+00, 9.4784892485E-01, 7.1349849837E-01],
	[1.5325000000E+04, 1.0040673453E+01, 5.8559340700E+00, 1.2758376912E+00, 9.4862203958E-01, 7.1363651758E-01],
	[1.5330000000E+04, 1.0045192767E+01, 5.8556646417E+00, 1.2771766497E+00, 9.4939536762E-01, 7.1377448917E-01],
	[1.5335000000E+04, 1.0049712639E+01, 5.8553953136E+00, 1.2785165758E+00, 9.5016890871E-01, 7.1391241312E-01],
	[1.5340000000E+04, 1.0054233071E+01, 5.8551260857E+00, 1.2798574699E+00, 9.5094266257E-01, 7.1405028943E-01],
	[1.5345000000E+04, 1.0058754063E+01, 5.8548569579E+00, 1.2811993323E+00, 9.5171662892E-01, 7.1418811808E-01],
	[1.5350000000E+04, 1.0063275613E+01, 5.8545879302E+00, 1.2825421635E+00, 9.5249080750E-01, 7.1432589908E-01],
	[1.5355000000E+04, 1.0067797722E+01, 5.8543190024E+00, 1.2838859639E+00, 9.5326519802E-01, 7.1446363242E-01],
	[1.5360000000E+04, 1.0072320390E+01, 5.8540501745E+00, 1.2852307337E+00, 9.5403980022E-01, 7.1460131808E-01],
	[1.5365000000E+04, 1.0076843617E+01, 5.8537814465E+00, 1.2865764735E+00, 9.5481461381E-01, 7.1473895606E-01],
	[1.5370000000E+04, 1.0081367402E+01, 5.8535128182E+00, 1.2879231835E+00, 9.5558963854E-01, 7.1487654636E-01],
	[1.5375000000E+04, 1.0085891746E+01, 5.8532442897E+00, 1.2892708642E+00, 9.5636487411E-01, 7.1501408896E-01],
	[1.5380000000E+04, 1.0090416648E+01, 5.8529758607E+00, 1.2906195160E+00, 9.5714032026E-01, 7.1515158385E-01],
	[1.5385000000E+04, 1.0094942109E+01, 5.8527075313E+00, 1.2919691392E+00, 9.5791597671E-01, 7.1528903104E-01],
	[1.5390000000E+04, 1.0099468127E+01, 5.8524393014E+00, 1.2933197342E+00, 9.5869184319E-01, 7.1542643051E-01],
	[1.5395000000E+04, 1.0103994704E+01, 5.8521711709E+00, 1.2946713014E+00, 9.5946791942E-01, 7.1556378225E-01],
	[1.5400000000E+04, 1.0108521838E+01, 5.8519031398E+00, 1.2960238412E+00, 9.6024420513E-01, 7.1570108626E-01],
	[1.5405000000E+04, 1.0113049530E+01, 5.8516352079E+00, 1.2973773539E+00, 9.6102070004E-01, 7.1583834253E-01],
	[1.5410000000E+04, 1.0117577780E+01, 5.8513673753E+00, 1.2987318401E+00, 9.6179740389E-01, 7.1597555106E-01],
	[1.5415000000E+04, 1.0122106588E+01, 5.8510996417E+00, 1.3000872999E+00, 9.6257431638E-01, 7.1611271183E-01],
	[1.5420000000E+04, 1.0126635953E+01, 5.8508320073E+00, 1.3014437339E+00, 9.6335143725E-01, 7.1624982484E-01],
	[1.5425000000E+04, 1.0131165875E+01, 5.8505644719E+00, 1.3028011423E+00, 9.6412876623E-01, 7.1638689009E-01],
	[1.5430000000E+04, 1.0135696355E+01, 5.8502970354E+00, 1.3041595257E+00, 9.6490630303E-01, 7.1652390756E-01],
	[1.5435000000E+04, 1.0140227392E+01, 5.8500296977E+00, 1.3055188843E+00, 9.6568404738E-01, 7.1666087724E-01],
	[1.5440000000E+04, 1.0144758985E+01, 5.8497624589E+00, 1.3068792186E+00, 9.6646199901E-01, 7.1679779915E-01],
	[1.5445000000E+04, 1.0149291136E+01, 5.8494953188E+00, 1.3082405289E+00, 9.6724015764E-01, 7.1693467325E-01],
	[1.5450000000E+04, 1.0153823844E+01, 5.8492282773E+00, 1.3096028156E+00, 9.6801852300E-01, 7.1707149955E-01],
	[1.5455000000E+04, 1.0158357108E+01, 5.8489613345E+00, 1.3109660791E+00, 9.6879709480E-01, 7.1720827805E-01],
	[1.5460000000E+04, 1.0162890928E+01, 5.8486944901E+00, 1.3123303199E+00, 9.6957587277E-01, 7.1734500873E-01],
	[1.5465000000E+04, 1.0167425306E+01, 5.8484277443E+00, 1.3136955381E+00, 9.7035485664E-01, 7.1748169159E-01],
	[1.5470000000E+04, 1.0171960239E+01, 5.8481610968E+00, 1.3150617344E+00, 9.7113404613E-01, 7.1761832662E-01],
	[1.5475000000E+04, 1.0176495729E+01, 5.8478945476E+00, 1.3164289090E+00, 9.7191344097E-01, 7.1775491382E-01],
	[1.5480000000E+04, 1.0181031775E+01, 5.8476280967E+00, 1.3177970623E+00, 9.7269304087E-01, 7.1789145317E-01],
	[1.5485000000E+04, 1.0185568377E+01, 5.8473617439E+00, 1.3191661947E+00, 9.7347284556E-01, 7.1802794468E-01],
	[1.5490000000E+04, 1.0190105534E+01, 5.8470954893E+00, 1.3205363066E+00, 9.7425285477E-01, 7.1816438833E-01],
	[1.5495000000E+04, 1.0194643248E+01, 5.8468293327E+00, 1.3219073984E+00, 9.7503306821E-01, 7.1830078412E-01],
	[1.5500000000E+04, 1.0199181517E+01, 5.8465632741E+00, 1.3232794704E+00, 9.7581348561E-01, 7.1843713205E-01],
	[1.5505000000E+04, 1.0203720342E+01, 5.8462973135E+00, 1.3246525231E+00, 9.7659410670E-01, 7.1857343210E-01],
	[1.5510000000E+04, 1.0208259722E+01, 5.8460314506E+00, 1.3260265568E+00, 9.7737493120E-01, 7.1870968428E-01],
	[1.5515000000E+04, 1.0212799658E+01, 5.8457656856E+00, 1.3274015719E+00, 9.7815595882E-01, 7.1884588857E-01],
	[1.5520000000E+04, 1.0217340149E+01, 5.8455000182E+00, 1.3287775688E+00, 9.7893718929E-01, 7.1898204496E-01],
	[1.5525000000E+04, 1.0221881195E+01, 5.8452344485E+00, 1.3301545479E+00, 9.7971862234E-01, 7.1911815347E-01],
	[1.5530000000E+04, 1.0226422796E+01, 5.8449689764E+00, 1.3315325095E+00, 9.8050025769E-01, 7.1925421406E-01],
	[1.5535000000E+04, 1.0230964952E+01, 5.8447036018E+00, 1.3329114541E+00, 9.8128209506E-01, 7.1939022675E-01],
	[1.5540000000E+04, 1.0235513440E+01, 5.8444399401E+00, 1.3342913821E+00, 9.8206423297E-01, 7.1952619153E-01],
	[1.5545000000E+04, 1.0240077618E+01, 5.8441806038E+00, 1.3356722937E+00, 9.8284683159E-01, 7.1966210838E-01],
	[1.5550000000E+04, 1.0244642362E+01, 5.8439213624E+00, 1.3370541894E+00, 9.8362963226E-01, 7.1979797730E-01],
	[1.5555000000E+04, 1.0249207673E+01, 5.8436622159E+00, 1.3384370697E+00, 9.8441263471E-01, 7.1993379830E-01],
	[1.5560000000E+04, 1.0253773550E+01, 5.8434031642E+00, 1.3398209348E+00, 9.8519583866E-01, 7.2006957135E-01],
	[1.5565000000E+04, 1.0258339993E+01, 5.8431442071E+00, 1.3412057851E+00, 9.8597924383E-01, 7.2020529646E-01],
	[1.5570000000E+04, 1.0262907002E+01, 5.8428853447E+00, 1.3425916211E+00, 9.8676284995E-01, 7.2034097363E-01],
	[1.5575000000E+04, 1.0267474577E+01, 5.8426265769E+00, 1.3439784431E+00, 9.8754665674E-01, 7.2047660283E-01],
	[1.5580000000E+04, 1.0272042718E+01, 5.8423679036E+00, 1.3453662515E+00, 9.8833066392E-01, 7.2061218408E-01],
	[1.5585000000E+04, 1.0276611424E+01, 5.8421093248E+00, 1.3467550467E+00, 9.8911487122E-01, 7.2074771736E-01],
	[1.5590000000E+04, 1.0281180696E+01, 5.8418508403E+00, 1.3481448291E+00, 9.8989927836E-01, 7.2088320267E-01],
	[1.5595000000E+04, 1.0285750533E+01, 5.8415924501E+00, 1.3495355990E+00, 9.9068388505E-01, 7.2101864000E-01],
	[1.5600000000E+04, 1.0290320936E+01, 5.8413341542E+00, 1.3509273569E+00, 9.9146869102E-01, 7.2115402935E-01],
	[1.5605000000E+04, 1.0294891904E+01, 5.8410759525E+00, 1.3523201031E+00, 9.9225369600E-01, 7.2128937072E-01],
	[1.5610000000E+04, 1.0299463437E+01, 5.8408178449E+00, 1.3537138380E+00, 9.9303889970E-01, 7.2142466409E-01],
	[1.5615000000E+04, 1.0304035535E+01, 5.8405598314E+00, 1.3551085620E+00, 9.9382430185E-01, 7.2155990946E-01],
	[1.5620000000E+04, 1.0308608198E+01, 5.8403019119E+00, 1.3565042755E+00, 9.9460990217E-01, 7.2169510683E-01],
	[1.5625000000E+04, 1.0313181425E+01, 5.8400440863E+00, 1.3579009788E+00, 9.9539570038E-01, 7.2183025619E-01],
	[1.5630000000E+04, 1.0317755218E+01, 5.8397863545E+00, 1.3592986724E+00, 9.9618169621E-01, 7.2196535754E-01],
	[1.5635000000E+04, 1.0322329574E+01, 5.8395287166E+00, 1.3606973567E+00, 9.9696788936E-01, 7.2210041087E-01],
	[1.5640000000E+04, 1.0326904496E+01, 5.8392711724E+00, 1.3620970319E+00, 9.9775427957E-01, 7.2223541618E-01],
	[1.5645000000E+04, 1.0331479981E+01, 5.8390137219E+00, 1.3634976986E+00, 9.9854086656E-01, 7.2237037346E-01],
	[1.5650000000E+04, 1.0336056031E+01, 5.8387563650E+00, 1.3648993570E+00, 9.9932765005E-01, 7.2250528270E-01],
	[1.5655000000E+04, 1.0340632645E+01, 5.8384991016E+00, 1.3663020077E+00, 1.0001146298E+00, 7.2264014391E-01],
	[1.5660000000E+04, 1.0345209823E+01, 5.8382419318E+00, 1.3677056508E+00, 1.0009018054E+00, 7.2277495708E-01],
	[1.5665000000E+04, 1.0349787565E+01, 5.8379848553E+00, 1.3691102870E+00, 1.0016891767E+00, 7.2290972220E-01],
	[1.5670000000E+04, 1.0354365870E+01, 5.8377278722E+00, 1.3705159164E+00, 1.0024767434E+00, 7.2304443926E-01],
	[1.5675000000E+04, 1.0358944739E+01, 5.8374709824E+00, 1.3719225396E+00, 1.0032645052E+00, 7.2317910827E-01],
	[1.5680000000E+04, 1.0363524172E+01, 5.8372141858E+00, 1.3733301569E+00, 1.0040524618E+00, 7.2331372922E-01],
	[1.5685000000E+04, 1.0368104168E+01, 5.8369574824E+00, 1.3747387686E+00, 1.0048406130E+00, 7.2344830210E-01],
	[1.5690000000E+04, 1.0372684728E+01, 5.8367008721E+00, 1.3761483753E+00, 1.0056289584E+00, 7.2358282692E-01],
	[1.5695000000E+04, 1.0377265851E+01, 5.8364443549E+00, 1.3775589771E+00, 1.0064174978E+00, 7.2371730365E-01],
	[1.5700000000E+04, 1.0381847536E+01, 5.8361879306E+00, 1.3789705746E+00, 1.0072062309E+00, 7.2385173231E-01],
	[1.5705000000E+04, 1.0386429785E+01, 5.8359315992E+00, 1.3803831682E+00, 1.0079951575E+00, 7.2398611289E-01],
	[1.5710000000E+04, 1.0391012597E+01, 5.8356753606E+00, 1.3817967581E+00, 1.0087842772E+00, 7.2412044537E-01],
	[1.5715000000E+04, 1.0395595972E+01, 5.8354192149E+00, 1.3832113449E+00, 1.0095735897E+00, 7.2425472977E-01],
	[1.5720000000E+04, 1.0400179909E+01, 5.8351631619E+00, 1.3846269288E+00, 1.0103630949E+00, 7.2438896607E-01],
	[1.5725000000E+04, 1.0404764409E+01, 5.8349072015E+00, 1.3860435103E+00, 1.0111527923E+00, 7.2452315426E-01],
	[1.5730000000E+04, 1.0409349471E+01, 5.8346513337E+00, 1.3874610897E+00, 1.0119426818E+00, 7.2465729432E-01],
	[1.5735000000E+04, 1.0413935095E+01, 5.8343955585E+00, 1.3888796674E+00, 1.0127327630E+00, 7.2479138626E-01],
	[1.5740000000E+04, 1.0418521282E+01, 5.8341398757E+00, 1.3902992439E+00, 1.0135230357E+00, 7.2492543006E-01],
	[1.5745000000E+04, 1.0423108031E+01, 5.8338842853E+00, 1.3917198195E+00, 1.0143134996E+00, 7.2505942571E-01],
	[1.5750000000E+04, 1.0427695342E+01, 5.8336287873E+00, 1.3931413946E+00, 1.0151041544E+00, 7.2519337321E-01],
	[1.5755000000E+04, 1.0432283215E+01, 5.8333733816E+00, 1.3945639695E+00, 1.0158949998E+00, 7.2532727255E-01],
	[1.5760000000E+04, 1.0436871649E+01, 5.8331180680E+00, 1.3959875448E+00, 1.0166860356E+00, 7.2546112372E-01],
	[1.5765000000E+04, 1.0441460646E+01, 5.8328628467E+00, 1.3974121206E+00, 1.0174772614E+00, 7.2559492671E-01],
	[1.5770000000E+04, 1.0446050203E+01, 5.8326077174E+00, 1.3988376975E+00, 1.0182686770E+00, 7.2572868152E-01],
	[1.5775000000E+04, 1.0450640323E+01, 5.8323526802E+00, 1.4002642758E+00, 1.0190602821E+00, 7.2586238814E-01],
	[1.5780000000E+04, 1.0455231003E+01, 5.8320977349E+00, 1.4016918559E+00, 1.0198520765E+00, 7.2599604656E-01],
	[1.5785000000E+04, 1.0459822245E+01, 5.8318428816E+00, 1.4031204382E+00, 1.0206440597E+00, 7.2612965677E-01],
	[1.5790000000E+04, 1.0464419325E+01, 5.8315895441E+00, 1.4045500231E+00, 1.0214363256E+00, 7.2626321876E-01],
	[1.5795000000E+04, 1.0469033122E+01, 5.8313406557E+00, 1.4059806109E+00, 1.0222290681E+00, 7.2639673254E-01],
	[1.5800000000E+04, 1.0473647493E+01, 5.8310918566E+00, 1.4074122021E+00, 1.0230219995E+00, 7.2653019808E-01],
	[1.5805000000E+04, 1.0478262436E+01, 5.8308431470E+00, 1.4088447970E+00, 1.0238151197E+00, 7.2666361539E-01],
	[1.5810000000E+04, 1.0482877952E+01, 5.8305945265E+00, 1.4102783960E+00, 1.0246084282E+00, 7.2679698446E-01],
	[1.5815000000E+04, 1.0487494041E+01, 5.8303459953E+00, 1.4117129995E+00, 1.0254019250E+00, 7.2693030528E-01],
	[1.5820000000E+04, 1.0492110703E+01, 5.8300975532E+00, 1.4131486079E+00, 1.0261956096E+00, 7.2706357784E-01],
	[1.5825000000E+04, 1.0496727936E+01, 5.8298492003E+00, 1.4145852216E+00, 1.0269894818E+00, 7.2719680213E-01],
	[1.5830000000E+04, 1.0501345743E+01, 5.8296009363E+00, 1.4160228409E+00, 1.0277835414E+00, 7.2732997816E-01],
	[1.5835000000E+04, 1.0505964121E+01, 5.8293527613E+00, 1.4174614663E+00, 1.0285777879E+00, 7.2746310591E-01],
	[1.5840000000E+04, 1.0510583071E+01, 5.8291046753E+00, 1.4189010981E+00, 1.0293722213E+00, 7.2759618537E-01],
	[1.5845000000E+04, 1.0515202594E+01, 5.8288566781E+00, 1.4203417367E+00, 1.0301668410E+00, 7.2772921654E-01],
	[1.5850000000E+04, 1.0519822688E+01, 5.8286087697E+00, 1.4217833825E+00, 1.0309616470E+00, 7.2786219941E-01],
	[1.5855000000E+04, 1.0524443354E+01, 5.8283609500E+00, 1.4232260359E+00, 1.0317566389E+00, 7.2799513398E-01],
	[1.5860000000E+04, 1.0529064592E+01, 5.8281132189E+00, 1.4246696973E+00, 1.0325518165E+00, 7.2812802023E-01],
	[1.5865000000E+04, 1.0533686401E+01, 5.8278655765E+00, 1.4261143670E+00, 1.0333471793E+00, 7.2826085817E-01],
	[1.5870000000E+04, 1.0538308782E+01, 5.8276180227E+00, 1.4275600455E+00, 1.0341427273E+00, 7.2839364778E-01],
	[1.5875000000E+04, 1.0542931734E+01, 5.8273705573E+00, 1.4290067331E+00, 1.0349384600E+00, 7.2852638906E-01],
	[1.5880000000E+04, 1.0547555257E+01, 5.8271231804E+00, 1.4304544302E+00, 1.0357343772E+00, 7.2865908200E-01],
	[1.5885000000E+04, 1.0552179352E+01, 5.8268758918E+00, 1.4319031372E+00, 1.0365304787E+00, 7.2879172660E-01],
	[1.5890000000E+04, 1.0556804017E+01, 5.8266286916E+00, 1.4333528545E+00, 1.0373267641E+00, 7.2892432284E-01],
	[1.5895000000E+04, 1.0561429253E+01, 5.8263815796E+00, 1.4348035825E+00, 1.0381232331E+00, 7.2905687073E-01],
	[1.5900000000E+04, 1.0566055060E+01, 5.8261345558E+00, 1.4362553216E+00, 1.0389198856E+00, 7.2918937026E-01],
	[1.5905000000E+04, 1.0570681438E+01, 5.8258876202E+00, 1.4377080720E+00, 1.0397167211E+00, 7.2932182142E-01],
	[1.5910000000E+04, 1.0575308387E+01, 5.8256407726E+00, 1.4391618344E+00, 1.0405137394E+00, 7.2945422420E-01],
	[1.5915000000E+04, 1.0579935905E+01, 5.8253940130E+00, 1.4406166089E+00, 1.0413109403E+00, 7.2958657860E-01],
	[1.5920000000E+04, 1.0584563994E+01, 5.8251473414E+00, 1.4420723961E+00, 1.0421083234E+00, 7.2971888461E-01],
	[1.5925000000E+04, 1.0589192654E+01, 5.8249007577E+00, 1.4435291962E+00, 1.0429058885E+00, 7.2985114223E-01],
	[1.5930000000E+04, 1.0593821883E+01, 5.8246542619E+00, 1.4449870097E+00, 1.0437036353E+00, 7.2998335145E-01],
	[1.5935000000E+04, 1.0598451683E+01, 5.8244078538E+00, 1.4464458370E+00, 1.0445015635E+00, 7.3011551226E-01],
	[1.5940000000E+04, 1.0603082052E+01, 5.8241615334E+00, 1.4479056784E+00, 1.0452996728E+00, 7.3024762467E-01],
	[1.5945000000E+04, 1.0607712992E+01, 5.8239153007E+00, 1.4493665344E+00, 1.0460979629E+00, 7.3037968865E-01],
	[1.5950000000E+04, 1.0612344501E+01, 5.8236691557E+00, 1.4508284052E+00, 1.0468964337E+00, 7.3051170421E-01],
	[1.5955000000E+04, 1.0616976579E+01, 5.8234230981E+00, 1.4522912914E+00, 1.0476950846E+00, 7.3064367135E-01],
	[1.5960000000E+04, 1.0621609227E+01, 5.8231771281E+00, 1.4537551933E+00, 1.0484939156E+00, 7.3077559005E-01],
	[1.5965000000E+04, 1.0626242445E+01, 5.8229312455E+00, 1.4552201113E+00, 1.0492929263E+00, 7.3090746031E-01],
	[1.5970000000E+04, 1.0630876231E+01, 5.8226854502E+00, 1.4566860457E+00, 1.0500921164E+00, 7.3103928212E-01],
	[1.5975000000E+04, 1.0635510587E+01, 5.8224397423E+00, 1.4581529970E+00, 1.0508914856E+00, 7.3117105548E-01],
	[1.5980000000E+04, 1.0640145512E+01, 5.8221941216E+00, 1.4596209655E+00, 1.0516910337E+00, 7.3130278039E-01],
	[1.5985000000E+04, 1.0644781006E+01, 5.8219485882E+00, 1.4610899517E+00, 1.0524907604E+00, 7.3143445684E-01],
	[1.5990000000E+04, 1.0649417068E+01, 5.8217031418E+00, 1.4625599558E+00, 1.0532906654E+00, 7.3156608481E-01],
	[1.5995000000E+04, 1.0654053700E+01, 5.8214577826E+00, 1.4640309784E+00, 1.0540907484E+00, 7.3169766432E-01],
	[1.6000000000E+04, 1.0658690900E+01, 5.8212125103E+00, 1.4655030197E+00, 1.0548910092E+00, 7.3182919535E-01],
	[1.6005000000E+04, 1.0663328668E+01, 5.8209673251E+00, 1.4669760802E+00, 1.0556914473E+00, 7.3196067789E-01],
	[1.6010000000E+04, 1.0667967005E+01, 5.8207222267E+00, 1.4684501603E+00, 1.0564920627E+00, 7.3209211195E-01],
	[1.6015000000E+04, 1.0672605910E+01, 5.8204772152E+00, 1.4699252603E+00, 1.0572928549E+00, 7.3222349752E-01],
	[1.6020000000E+04, 1.0677245384E+01, 5.8202322905E+00, 1.4714013807E+00, 1.0580938237E+00, 7.3235483458E-01],
	[1.6025000000E+04, 1.0681885425E+01, 5.8199874525E+00, 1.4728785218E+00, 1.0588949689E+00, 7.3248612314E-01],
	[1.6030000000E+04, 1.0686526034E+01, 5.8197427012E+00, 1.4743566840E+00, 1.0596962900E+00, 7.3261736320E-01],
	[1.6035000000E+04, 1.0691167212E+01, 5.8194980365E+00, 1.4758358676E+00, 1.0604977869E+00, 7.3274855474E-01],
	[1.6040000000E+04, 1.0695808957E+01, 5.8192534583E+00, 1.4773160732E+00, 1.0612994593E+00, 7.3287969776E-01],
	[1.6045000000E+04, 1.0700460287E+01, 5.8190113164E+00, 1.4787973010E+00, 1.0621014740E+00, 7.3301079227E-01],
	[1.6050000000E+04, 1.0705125132E+01, 5.8187726305E+00, 1.4802795515E+00, 1.0629039040E+00, 7.3314183824E-01],
	[1.6055000000E+04, 1.0709790557E+01, 5.8185340287E+00, 1.4817628250E+00, 1.0637065096E+00, 7.3327283568E-01],
	[1.6060000000E+04, 1.0714456561E+01, 5.8182955110E+00, 1.4832471219E+00, 1.0645092904E+00, 7.3340378459E-01],
	[1.6065000000E+04, 1.0719123144E+01, 5.8180570773E+00, 1.4847324427E+00, 1.0653122462E+00, 7.3353468495E-01],
	[1.6070000000E+04, 1.0723790307E+01, 5.8178187275E+00, 1.4862187877E+00, 1.0661153767E+00, 7.3366553677E-01],
	[1.6075000000E+04, 1.0728458050E+01, 5.8175804617E+00, 1.4877061572E+00, 1.0669186816E+00, 7.3379634003E-01],
	[1.6080000000E+04, 1.0733126371E+01, 5.8173422797E+00, 1.4891945517E+00, 1.0677221606E+00, 7.3392709474E-01],
	[1.6085000000E+04, 1.0737795271E+01, 5.8171041815E+00, 1.4906839716E+00, 1.0685258135E+00, 7.3405780090E-01],
	[1.6090000000E+04, 1.0742464751E+01, 5.8168661671E+00, 1.4921744172E+00, 1.0693296400E+00, 7.3418845848E-01],
	[1.6095000000E+04, 1.0747134809E+01, 5.8166282364E+00, 1.4936658890E+00, 1.0701336397E+00, 7.3431906750E-01],
	[1.6100000000E+04, 1.0751805446E+01, 5.8163903892E+00, 1.4951583873E+00, 1.0709378124E+00, 7.3444962795E-01],
	[1.6105000000E+04, 1.0756476661E+01, 5.8161526257E+00, 1.4966519125E+00, 1.0717421579E+00, 7.3458013982E-01],
	[1.6110000000E+04, 1.0761148455E+01, 5.8159149457E+00, 1.4981464649E+00, 1.0725466758E+00, 7.3471060311E-01],
	[1.6115000000E+04, 1.0765820827E+01, 5.8156773491E+00, 1.4996420451E+00, 1.0733513658E+00, 7.3484101782E-01],
	[1.6120000000E+04, 1.0770493778E+01, 5.8154398360E+00, 1.5011386534E+00, 1.0741562277E+00, 7.3497138393E-01],
	[1.6125000000E+04, 1.0775167307E+01, 5.8152024062E+00, 1.5026362901E+00, 1.0749612611E+00, 7.3510170145E-01],
	[1.6130000000E+04, 1.0779841414E+01, 5.8149650597E+00, 1.5041349556E+00, 1.0757664659E+00, 7.3523197038E-01],
	[1.6135000000E+04, 1.0784516098E+01, 5.8147277964E+00, 1.5056346504E+00, 1.0765718417E+00, 7.3536219070E-01],
	[1.6140000000E+04, 1.0789191361E+01, 5.8144906164E+00, 1.5071353748E+00, 1.0773773882E+00, 7.3549236242E-01],
	[1.6145000000E+04, 1.0793867201E+01, 5.8142535194E+00, 1.5086371292E+00, 1.0781831051E+00, 7.3562248553E-01],
	[1.6150000000E+04, 1.0798543619E+01, 5.8140165056E+00, 1.5101399140E+00, 1.0789889922E+00, 7.3575256003E-01],
	[1.6155000000E+04, 1.0803220615E+01, 5.8137795748E+00, 1.5116437296E+00, 1.0797950492E+00, 7.3588258591E-01],
	[1.6160000000E+04, 1.0807898188E+01, 5.8135427269E+00, 1.5131485764E+00, 1.0806012758E+00, 7.3601256317E-01],
	[1.6165000000E+04, 1.0812576338E+01, 5.8133059620E+00, 1.5146544547E+00, 1.0814076717E+00, 7.3614249181E-01],
	[1.6170000000E+04, 1.0817255065E+01, 5.8130692799E+00, 1.5161613649E+00, 1.0822142366E+00, 7.3627237182E-01],
	[1.6175000000E+04, 1.0821934370E+01, 5.8128326806E+00, 1.5176693075E+00, 1.0830209702E+00, 7.3640220319E-01],
	[1.6180000000E+04, 1.0826614252E+01, 5.8125961641E+00, 1.5191782828E+00, 1.0838278723E+00, 7.3653198594E-01],
	[1.6185000000E+04, 1.0831294710E+01, 5.8123597303E+00, 1.5206882912E+00, 1.0846349426E+00, 7.3666172004E-01],
	[1.6190000000E+04, 1.0835975745E+01, 5.8121233791E+00, 1.5221993331E+00, 1.0854421808E+00, 7.3679140551E-01],
	[1.6195000000E+04, 1.0840657357E+01, 5.8118871105E+00, 1.5237114089E+00, 1.0862495866E+00, 7.3692104233E-01],
	[1.6200000000E+04, 1.0845339545E+01, 5.8116509245E+00, 1.5252245190E+00, 1.0870571597E+00, 7.3705063050E-01],
	[1.6205000000E+04, 1.0850022310E+01, 5.8114148209E+00, 1.5267386637E+00, 1.0878648998E+00, 7.3718017001E-01],
	[1.6210000000E+04, 1.0854705651E+01, 5.8111787997E+00, 1.5282538435E+00, 1.0886728067E+00, 7.3730966088E-01],
	[1.6215000000E+04, 1.0859389569E+01, 5.8109428610E+00, 1.5297700587E+00, 1.0894808801E+00, 7.3743910308E-01],
	[1.6220000000E+04, 1.0864074062E+01, 5.8107070045E+00, 1.5312873097E+00, 1.0902891196E+00, 7.3756849663E-01],
	[1.6225000000E+04, 1.0868759132E+01, 5.8104712303E+00, 1.5328055969E+00, 1.0910975251E+00, 7.3769784151E-01],
	[1.6230000000E+04, 1.0873444778E+01, 5.8102355383E+00, 1.5343249207E+00, 1.0919060961E+00, 7.3782713772E-01],
	[1.6235000000E+04, 1.0878130999E+01, 5.8099999285E+00, 1.5358452815E+00, 1.0927148325E+00, 7.3795638526E-01],
	[1.6240000000E+04, 1.0882817796E+01, 5.8097644007E+00, 1.5373666797E+00, 1.0935237339E+00, 7.3808558413E-01],
	[1.6245000000E+04, 1.0887505169E+01, 5.8095289550E+00, 1.5388891156E+00, 1.0943328001E+00, 7.3821473433E-01],
	[1.6250000000E+04, 1.0892193117E+01, 5.8092935913E+00, 1.5404125897E+00, 1.0951420308E+00, 7.3834383584E-01],
	[1.6255000000E+04, 1.0896881640E+01, 5.8090583096E+00, 1.5419371023E+00, 1.0959514257E+00, 7.3847288867E-01],
	[1.6260000000E+04, 1.0901570739E+01, 5.8088231097E+00, 1.5434626538E+00, 1.0967609844E+00, 7.3860189282E-01],
	[1.6265000000E+04, 1.0906260413E+01, 5.8085879917E+00, 1.5449892446E+00, 1.0975707068E+00, 7.3873084828E-01],
	[1.6270000000E+04, 1.0910950662E+01, 5.8083529554E+00, 1.5465168752E+00, 1.0983805925E+00, 7.3885975504E-01],
	[1.6275000000E+04, 1.0915641486E+01, 5.8081180009E+00, 1.5480455458E+00, 1.0991906413E+00, 7.3898861312E-01],
	[1.6280000000E+04, 1.0920332885E+01, 5.8078831280E+00, 1.5495752569E+00, 1.1000008529E+00, 7.3911742250E-01],
	[1.6285000000E+04, 1.0925024858E+01, 5.8076483368E+00, 1.5511060089E+00, 1.1008112269E+00, 7.3924618318E-01],
	[1.6290000000E+04, 1.0929717406E+01, 5.8074136271E+00, 1.5526378021E+00, 1.1016217631E+00, 7.3937489516E-01],
	[1.6295000000E+04, 1.0934410529E+01, 5.8071789989E+00, 1.5541706369E+00, 1.1024324612E+00, 7.3950355844E-01],
	[1.6300000000E+04, 1.0939104226E+01, 5.8069444522E+00, 1.5557045138E+00, 1.1032433210E+00, 7.3963217301E-01],
	[1.6305000000E+04, 1.0943815522E+01, 5.8067142700E+00, 1.5572394331E+00, 1.1040546702E+00, 7.3976073887E-01],
	[1.6310000000E+04, 1.0948532875E+01, 5.8064855435E+00, 1.5587753952E+00, 1.1048662868E+00, 7.3988925603E-01],
	[1.6315000000E+04, 1.0953250813E+01, 5.8062568961E+00, 1.5603124005E+00, 1.1056780650E+00, 7.4001772447E-01],
	[1.6320000000E+04, 1.0957969338E+01, 5.8060283278E+00, 1.5618504493E+00, 1.1064900048E+00, 7.4014614419E-01],
	[1.6325000000E+04, 1.0962688450E+01, 5.8057998385E+00, 1.5633895421E+00, 1.1073021056E+00, 7.4027451520E-01],
	[1.6330000000E+04, 1.0967408147E+01, 5.8055714282E+00, 1.5649296793E+00, 1.1081143674E+00, 7.4040283749E-01],
	[1.6335000000E+04, 1.0972128431E+01, 5.8053430967E+00, 1.5664708612E+00, 1.1089267898E+00, 7.4053111106E-01],
	[1.6340000000E+04, 1.0976849301E+01, 5.8051148442E+00, 1.5680130883E+00, 1.1097393724E+00, 7.4065933590E-01],
	[1.6345000000E+04, 1.0981570757E+01, 5.8048866704E+00, 1.5695563609E+00, 1.1105521151E+00, 7.4078751202E-01],
	[1.6350000000E+04, 1.0986292798E+01, 5.8046585754E+00, 1.5711006794E+00, 1.1113650176E+00, 7.4091563941E-01],
	[1.6355000000E+04, 1.0991015426E+01, 5.8044305591E+00, 1.5726460441E+00, 1.1121780795E+00, 7.4104371808E-01],
	[1.6360000000E+04, 1.0995738638E+01, 5.8042026214E+00, 1.5741924556E+00, 1.1129913005E+00, 7.4117174801E-01],
	[1.6365000000E+04, 1.1000462437E+01, 5.8039747624E+00, 1.5757399142E+00, 1.1138046805E+00, 7.4129972920E-01],
	[1.6370000000E+04, 1.1005186820E+01, 5.8037469818E+00, 1.5772884202E+00, 1.1146182190E+00, 7.4142766167E-01],
	[1.6375000000E+04, 1.1009911789E+01, 5.8035192798E+00, 1.5788379740E+00, 1.1154319159E+00, 7.4155554539E-01],
	[1.6380000000E+04, 1.1014637344E+01, 5.8032916563E+00, 1.5803885761E+00, 1.1162457708E+00, 7.4168338038E-01],
	[1.6385000000E+04, 1.1019363483E+01, 5.8030641111E+00, 1.5819402268E+00, 1.1170597835E+00, 7.4181116662E-01],
	[1.6390000000E+04, 1.1024090207E+01, 5.8028366442E+00, 1.5834929266E+00, 1.1178739536E+00, 7.4193890413E-01],
	[1.6395000000E+04, 1.1028817516E+01, 5.8026092557E+00, 1.5850466757E+00, 1.1186882809E+00, 7.4206659289E-01],
	[1.6400000000E+04, 1.1033545410E+01, 5.8023819454E+00, 1.5866014746E+00, 1.1195027651E+00, 7.4219423291E-01],
	[1.6405000000E+04, 1.1038273888E+01, 5.8021547133E+00, 1.5881573237E+00, 1.1203174058E+00, 7.4232182417E-01],
	[1.6410000000E+04, 1.1043002951E+01, 5.8019275593E+00, 1.5897142234E+00, 1.1211322030E+00, 7.4244936670E-01],
	[1.6415000000E+04, 1.1047732599E+01, 5.8017004835E+00, 1.5912721741E+00, 1.1219471561E+00, 7.4257686047E-01],
	[1.6420000000E+04, 1.1052462830E+01, 5.8014734856E+00, 1.5928311761E+00, 1.1227622650E+00, 7.4270430549E-01],
	[1.6425000000E+04, 1.1057193646E+01, 5.8012465658E+00, 1.5943912298E+00, 1.1235775294E+00, 7.4283170176E-01],
	[1.6430000000E+04, 1.1061925046E+01, 5.8010197239E+00, 1.5959523356E+00, 1.1243929489E+00, 7.4295904927E-01],
	[1.6435000000E+04, 1.1066657031E+01, 5.8007929599E+00, 1.5975144940E+00, 1.1252085234E+00, 7.4308634803E-01],
	[1.6440000000E+04, 1.1071389598E+01, 5.8005662737E+00, 1.5990777053E+00, 1.1260242524E+00, 7.4321359804E-01],
	[1.6445000000E+04, 1.1076122750E+01, 5.8003396653E+00, 1.6006419698E+00, 1.1268401358E+00, 7.4334079929E-01],
	[1.6450000000E+04, 1.1080856486E+01, 5.8001131347E+00, 1.6022072881E+00, 1.1276561732E+00, 7.4346795178E-01],
	[1.6455000000E+04, 1.1085590805E+01, 5.7998866817E+00, 1.6037736604E+00, 1.1284723644E+00, 7.4359505551E-01],
	[1.6460000000E+04, 1.1090325707E+01, 5.7996603064E+00, 1.6053410871E+00, 1.1292887090E+00, 7.4372211048E-01],
	[1.6465000000E+04, 1.1095061193E+01, 5.7994340086E+00, 1.6069095688E+00, 1.1301052069E+00, 7.4384911669E-01],
	[1.6470000000E+04, 1.1099797262E+01, 5.7992077884E+00, 1.6084791056E+00, 1.1309218576E+00, 7.4397607413E-01],
	[1.6475000000E+04, 1.1104533915E+01, 5.7989816457E+00, 1.6100496981E+00, 1.1317386609E+00, 7.4410298282E-01],
	[1.6480000000E+04, 1.1109271150E+01, 5.7987555804E+00, 1.6116213466E+00, 1.1325556166E+00, 7.4422984274E-01],
	[1.6485000000E+04, 1.1114008968E+01, 5.7985295925E+00, 1.6131940515E+00, 1.1333727243E+00, 7.4435665389E-01],
	[1.6490000000E+04, 1.1118747369E+01, 5.7983036819E+00, 1.6147678132E+00, 1.1341899838E+00, 7.4448341628E-01],
	[1.6495000000E+04, 1.1123486353E+01, 5.7980778487E+00, 1.6163426320E+00, 1.1350073947E+00, 7.4461012990E-01],
	[1.6500000000E+04, 1.1128225920E+01, 5.7978520926E+00, 1.6179185085E+00, 1.1358249568E+00, 7.4473679476E-01],
	[1.6505000000E+04, 1.1132966069E+01, 5.7976264138E+00, 1.6194954429E+00, 1.1366426699E+00, 7.4486341085E-01],
	[1.6510000000E+04, 1.1137706801E+01, 5.7974008121E+00, 1.6210734356E+00, 1.1374605335E+00, 7.4498997817E-01],
	[1.6515000000E+04, 1.1142448114E+01, 5.7971752874E+00, 1.6226524871E+00, 1.1382785475E+00, 7.4511649672E-01],
	[1.6520000000E+04, 1.1147190010E+01, 5.7969498398E+00, 1.6242325977E+00, 1.1390967115E+00, 7.4524296650E-01],
	[1.6525000000E+04, 1.1151932489E+01, 5.7967244692E+00, 1.6258137678E+00, 1.1399150252E+00, 7.4536938751E-01],
	[1.6530000000E+04, 1.1156675549E+01, 5.7964991756E+00, 1.6273959978E+00, 1.1407334885E+00, 7.4549575975E-01],
	[1.6535000000E+04, 1.1161419191E+01, 5.7962739588E+00, 1.6289792882E+00, 1.1415521009E+00, 7.4562208322E-01],
	[1.6540000000E+04, 1.1166163415E+01, 5.7960488189E+00, 1.6305636392E+00, 1.1423708622E+00, 7.4574835792E-01],
	[1.6545000000E+04, 1.1170908220E+01, 5.7958237557E+00, 1.6321490512E+00, 1.1431897722E+00, 7.4587458385E-01],
	[1.6550000000E+04, 1.1175653608E+01, 5.7955987693E+00, 1.6337355248E+00, 1.1440088304E+00, 7.4600076101E-01],
	[1.6555000000E+04, 1.1180399576E+01, 5.7953738596E+00, 1.6353230602E+00, 1.1448280368E+00, 7.4612688939E-01],
	[1.6560000000E+04, 1.1185146126E+01, 5.7951490265E+00, 1.6369116578E+00, 1.1456473908E+00, 7.4625296900E-01],
	[1.6565000000E+04, 1.1189899508E+01, 5.7949257893E+00, 1.6385013181E+00, 1.1464670174E+00, 7.4637899984E-01],
	[1.6570000000E+04, 1.1194670267E+01, 5.7947067075E+00, 1.6400920414E+00, 1.1472871278E+00, 7.4650498191E-01],
	[1.6575000000E+04, 1.1199441619E+01, 5.7944877001E+00, 1.6416838281E+00, 1.1481073860E+00, 7.4663091521E-01],
	[1.6580000000E+04, 1.1204213565E+01, 5.7942687670E+00, 1.6432766786E+00, 1.1489277919E+00, 7.4675679973E-01],
	[1.6585000000E+04, 1.1208986105E+01, 5.7940499082E+00, 1.6448705932E+00, 1.1497483451E+00, 7.4688263548E-01],
	[1.6590000000E+04, 1.1213759237E+01, 5.7938311236E+00, 1.6464655725E+00, 1.1505690453E+00, 7.4700842246E-01],
	[1.6595000000E+04, 1.1218532963E+01, 5.7936124133E+00, 1.6480616167E+00, 1.1513898922E+00, 7.4713416066E-01],
	[1.6600000000E+04, 1.1223307283E+01, 5.7933937770E+00, 1.6496587263E+00, 1.1522108857E+00, 7.4725985010E-01],
	[1.6605000000E+04, 1.1228082195E+01, 5.7931752148E+00, 1.6512569016E+00, 1.1530320253E+00, 7.4738549076E-01],
	[1.6610000000E+04, 1.1232857700E+01, 5.7929567267E+00, 1.6528561431E+00, 1.1538533107E+00, 7.4751108265E-01],
	[1.6615000000E+04, 1.1237633799E+01, 5.7927383126E+00, 1.6544564511E+00, 1.1546747418E+00, 7.4763662577E-01],
	[1.6620000000E+04, 1.1242410490E+01, 5.7925199724E+00, 1.6560578260E+00, 1.1554963183E+00, 7.4776212011E-01],
	[1.6625000000E+04, 1.1247187773E+01, 5.7923017062E+00, 1.6576602682E+00, 1.1563180397E+00, 7.4788756569E-01],
	[1.6630000000E+04, 1.1251965649E+01, 5.7920835138E+00, 1.6592637781E+00, 1.1571399060E+00, 7.4801296250E-01],
	[1.6635000000E+04, 1.1256744118E+01, 5.7918653952E+00, 1.6608683561E+00, 1.1579619166E+00, 7.4813831053E-01],
	[1.6640000000E+04, 1.1261523179E+01, 5.7916473503E+00, 1.6624740026E+00, 1.1587840715E+00, 7.4826360980E-01],
	[1.6645000000E+04, 1.1266302832E+01, 5.7914293792E+00, 1.6640807179E+00, 1.1596063703E+00, 7.4838886030E-01],
	[1.6650000000E+04, 1.1271083077E+01, 5.7912114817E+00, 1.6656885025E+00, 1.1604288126E+00, 7.4851406202E-01],
	[1.6655000000E+04, 1.1275863915E+01, 5.7909936579E+00, 1.6672973568E+00, 1.1612513983E+00, 7.4863921498E-01],
	[1.6660000000E+04, 1.1280645344E+01, 5.7907759076E+00, 1.6689072810E+00, 1.1620741271E+00, 7.4876431918E-01],
	[1.6665000000E+04, 1.1285427365E+01, 5.7905582309E+00, 1.6705182757E+00, 1.1628969986E+00, 7.4888937460E-01],
	[1.6670000000E+04, 1.1290209978E+01, 5.7903406276E+00, 1.6721303412E+00, 1.1637200125E+00, 7.4901438126E-01],
	[1.6675000000E+04, 1.1294993183E+01, 5.7901230978E+00, 1.6737434779E+00, 1.1645431687E+00, 7.4913933916E-01],
	[1.6680000000E+04, 1.1299776978E+01, 5.7899056413E+00, 1.6753576862E+00, 1.1653664667E+00, 7.4926424829E-01],
	[1.6685000000E+04, 1.1304561366E+01, 5.7896882582E+00, 1.6769729665E+00, 1.1661899064E+00, 7.4938910866E-01],
	[1.6690000000E+04, 1.1309346345E+01, 5.7894709484E+00, 1.6785893192E+00, 1.1670134874E+00, 7.4951392026E-01],
	[1.6695000000E+04, 1.1314131914E+01, 5.7892537118E+00, 1.6802067446E+00, 1.1678372094E+00, 7.4963868310E-01],
	[1.6700000000E+04, 1.1318918075E+01, 5.7890365484E+00, 1.6818252432E+00, 1.1686610722E+00, 7.4976339719E-01],
	[1.6705000000E+04, 1.1323704827E+01, 5.7888194582E+00, 1.6834448153E+00, 1.1694850755E+00, 7.4988806251E-01],
	[1.6710000000E+04, 1.1328492170E+01, 5.7886024411E+00, 1.6850654614E+00, 1.1703092189E+00, 7.5001267907E-01],
	[1.6715000000E+04, 1.1333280104E+01, 5.7883854970E+00, 1.6866871817E+00, 1.1711335022E+00, 7.5013724687E-01],
	[1.6720000000E+04, 1.1338068628E+01, 5.7881686260E+00, 1.6883099768E+00, 1.1719579252E+00, 7.5026176592E-01],
	[1.6725000000E+04, 1.1342857743E+01, 5.7879518279E+00, 1.6899338470E+00, 1.1727824875E+00, 7.5038623621E-01],
	[1.6730000000E+04, 1.1347647448E+01, 5.7877351027E+00, 1.6915587927E+00, 1.1736071888E+00, 7.5051065775E-01],
	[1.6735000000E+04, 1.1352437744E+01, 5.7875184504E+00, 1.6931848143E+00, 1.1744320289E+00, 7.5063503054E-01],
	[1.6740000000E+04, 1.1357228630E+01, 5.7873018709E+00, 1.6948119122E+00, 1.1752570075E+00, 7.5075935457E-01],
	[1.6745000000E+04, 1.1362020106E+01, 5.7870853643E+00, 1.6964400867E+00, 1.1760821242E+00, 7.5088362985E-01],
	[1.6750000000E+04, 1.1366812172E+01, 5.7868689303E+00, 1.6980693383E+00, 1.1769073788E+00, 7.5100785638E-01],
	[1.6755000000E+04, 1.1371604828E+01, 5.7866525691E+00, 1.6996996673E+00, 1.1777327711E+00, 7.5113203417E-01],
	[1.6760000000E+04, 1.1376398074E+01, 5.7864362804E+00, 1.7013310742E+00, 1.1785583007E+00, 7.5125616320E-01],
	[1.6765000000E+04, 1.1381191910E+01, 5.7862200644E+00, 1.7029635593E+00, 1.1793839673E+00, 7.5138024350E-01],
	[1.6770000000E+04, 1.1385986335E+01, 5.7860039209E+00, 1.7045971230E+00, 1.1802097707E+00, 7.5150427505E-01],
	[1.6775000000E+04, 1.1390781350E+01, 5.7857878500E+00, 1.7062317657E+00, 1.1810357106E+00, 7.5162825785E-01],
	[1.6780000000E+04, 1.1395576955E+01, 5.7855718515E+00, 1.7078674878E+00, 1.1818617866E+00, 7.5175219192E-01],
	[1.6785000000E+04, 1.1400373148E+01, 5.7853559254E+00, 1.7095042897E+00, 1.1826879986E+00, 7.5187607725E-01],
	[1.6790000000E+04, 1.1405169931E+01, 5.7851400716E+00, 1.7111421718E+00, 1.1835143461E+00, 7.5199991383E-01],
	[1.6795000000E+04, 1.1409967303E+01, 5.7849242902E+00, 1.7127811344E+00, 1.1843408290E+00, 7.5212370169E-01],
	[1.6800000000E+04, 1.1414765264E+01, 5.7847085811E+00, 1.7144211781E+00, 1.1851674470E+00, 7.5224744081E-01],
	[1.6805000000E+04, 1.1419563814E+01, 5.7844929442E+00, 1.7160623030E+00, 1.1859941997E+00, 7.5237113120E-01],
	[1.6810000000E+04, 1.1424362953E+01, 5.7842773795E+00, 1.7177045097E+00, 1.1868210868E+00, 7.5249477281E-01],
	[1.6815000000E+04, 1.1429162680E+01, 5.7840618869E+00, 1.7193477986E+00, 1.1876481082E+00, 7.5261836559E-01],
	[1.6820000000E+04, 1.1433962996E+01, 5.7838464664E+00, 1.7209921699E+00, 1.1884752635E+00, 7.5274190955E-01],
	[1.6825000000E+04, 1.1438763901E+01, 5.7836311179E+00, 1.7226376242E+00, 1.1893025523E+00, 7.5286540469E-01],
	[1.6830000000E+04, 1.1443565394E+01, 5.7834158415E+00, 1.7242841618E+00, 1.1901299745E+00, 7.5298885100E-01],
	[1.6835000000E+04, 1.1448389678E+01, 5.7832058487E+00, 1.7259317831E+00, 1.1909579911E+00, 7.5311224848E-01],
	[1.6840000000E+04, 1.1453215956E+01, 5.7829962531E+00, 1.7275804885E+00, 1.1917861703E+00, 7.5323559715E-01],
	[1.6845000000E+04, 1.1458042836E+01, 5.7827867273E+00, 1.7292302783E+00, 1.1926144831E+00, 7.5335889698E-01],
	[1.6850000000E+04, 1.1462870317E+01, 5.7825772714E+00, 1.7308811530E+00, 1.1934429291E+00, 7.5348214800E-01],
	[1.6855000000E+04, 1.1467698398E+01, 5.7823678851E+00, 1.7325331130E+00, 1.1942715080E+00, 7.5360535019E-01],
	[1.6860000000E+04, 1.1472527080E+01, 5.7821585685E+00, 1.7341861586E+00, 1.1951002195E+00, 7.5372850356E-01],
	[1.6865000000E+04, 1.1477356362E+01, 5.7819493216E+00, 1.7358402903E+00, 1.1959290634E+00, 7.5385160812E-01],
	[1.6870000000E+04, 1.1482186245E+01, 5.7817401442E+00, 1.7374955084E+00, 1.1967580393E+00, 7.5397466385E-01],
	[1.6875000000E+04, 1.1487016728E+01, 5.7815310364E+00, 1.7391518133E+00, 1.1975871470E+00, 7.5409767076E-01],
	[1.6880000000E+04, 1.1491847811E+01, 5.7813219982E+00, 1.7408092054E+00, 1.1984163863E+00, 7.5422062885E-01],
	[1.6885000000E+04, 1.1496679494E+01, 5.7811130293E+00, 1.7424676851E+00, 1.1992457567E+00, 7.5434353812E-01],
	[1.6890000000E+04, 1.1501511778E+01, 5.7809041299E+00, 1.7441272529E+00, 1.2000752581E+00, 7.5446639858E-01],
	[1.6895000000E+04, 1.1506344661E+01, 5.7806952999E+00, 1.7457879090E+00, 1.2009048901E+00, 7.5458921022E-01],
	[1.6900000000E+04, 1.1511178144E+01, 5.7804865392E+00, 1.7474496539E+00, 1.2017346525E+00, 7.5471197305E-01],
	[1.6905000000E+04, 1.1516012227E+01, 5.7802778478E+00, 1.7491124879E+00, 1.2025645450E+00, 7.5483468706E-01],
	[1.6910000000E+04, 1.1520846909E+01, 5.7800692257E+00, 1.7507764116E+00, 1.2033945672E+00, 7.5495735226E-01],
	[1.6915000000E+04, 1.1525682191E+01, 5.7798606727E+00, 1.7524414251E+00, 1.2042247189E+00, 7.5507996864E-01],
	[1.6920000000E+04, 1.1530518072E+01, 5.7796521889E+00, 1.7541075291E+00, 1.2050549999E+00, 7.5520253622E-01],
	[1.6925000000E+04, 1.1535354553E+01, 5.7794437743E+00, 1.7557747237E+00, 1.2058854098E+00, 7.5532505498E-01],
	[1.6930000000E+04, 1.1540191632E+01, 5.7792354287E+00, 1.7574430095E+00, 1.2067159484E+00, 7.5544752494E-01],
	[1.6935000000E+04, 1.1545029311E+01, 5.7790271521E+00, 1.7591123868E+00, 1.2075466153E+00, 7.5556994609E-01],
	[1.6940000000E+04, 1.1549867589E+01, 5.7788189445E+00, 1.7607828560E+00, 1.2083774103E+00, 7.5569231843E-01],
	[1.6945000000E+04, 1.1554706466E+01, 5.7786108059E+00, 1.7624544175E+00, 1.2092083330E+00, 7.5581464197E-01],
	[1.6950000000E+04, 1.1559545941E+01, 5.7784027361E+00, 1.7641270717E+00, 1.2100393833E+00, 7.5593691670E-01],
	[1.6955000000E+04, 1.1564386015E+01, 5.7781947353E+00, 1.7658008189E+00, 1.2108705609E+00, 7.5605914263E-01],
	[1.6960000000E+04, 1.1569226688E+01, 5.7779868032E+00, 1.7674756597E+00, 1.2117018653E+00, 7.5618131976E-01],
	[1.6965000000E+04, 1.1574067959E+01, 5.7777789399E+00, 1.7691515943E+00, 1.2125332964E+00, 7.5630344810E-01],
	[1.6970000000E+04, 1.1578909828E+01, 5.7775711453E+00, 1.7708286231E+00, 1.2133648539E+00, 7.5642552763E-01],
	[1.6975000000E+04, 1.1583752296E+01, 5.7773634194E+00, 1.7725067466E+00, 1.2141965375E+00, 7.5654755837E-01],
	[1.6980000000E+04, 1.1588595361E+01, 5.7771557622E+00, 1.7741859652E+00, 1.2150283469E+00, 7.5666954031E-01],
	[1.6985000000E+04, 1.1593439025E+01, 5.7769481736E+00, 1.7758662791E+00, 1.2158602817E+00, 7.5679147346E-01],
	[1.6990000000E+04, 1.1598283287E+01, 5.7767406535E+00, 1.7775476889E+00, 1.2166923419E+00, 7.5691335782E-01],
	[1.6995000000E+04, 1.1603128147E+01, 5.7765332019E+00, 1.7792301949E+00, 1.2175245269E+00, 7.5703519339E-01],
	[1.7000000000E+04, 1.1607973604E+01, 5.7763258188E+00, 1.7809137976E+00, 1.2183568366E+00, 7.5715698017E-01],
	[1.7005000000E+04, 1.1612819659E+01, 5.7761185041E+00, 1.7825984972E+00, 1.2191892707E+00, 7.5727871816E-01],
	[1.7010000000E+04, 1.1617666312E+01, 5.7759112578E+00, 1.7842842942E+00, 1.2200218289E+00, 7.5740040737E-01],
	[1.7015000000E+04, 1.1622513562E+01, 5.7757040799E+00, 1.7859711889E+00, 1.2208545109E+00, 7.5752204780E-01],
	[1.7020000000E+04, 1.1627361409E+01, 5.7754969702E+00, 1.7876591819E+00, 1.2216873164E+00, 7.5764363945E-01],
	[1.7025000000E+04, 1.1632209854E+01, 5.7752899289E+00, 1.7893482734E+00, 1.2225202452E+00, 7.5776518232E-01],
	[1.7030000000E+04, 1.1637058896E+01, 5.7750829557E+00, 1.7910384638E+00, 1.2233532969E+00, 7.5788667641E-01],
	[1.7035000000E+04, 1.1641908534E+01, 5.7748760507E+00, 1.7927297537E+00, 1.2241864712E+00, 7.5800812173E-01],
	[1.7040000000E+04, 1.1646758770E+01, 5.7746692138E+00, 1.7944221432E+00, 1.2250197680E+00, 7.5812951827E-01],
	[1.7045000000E+04, 1.1651609603E+01, 5.7744624450E+00, 1.7961156329E+00, 1.2258531868E+00, 7.5825086605E-01],
	[1.7050000000E+04, 1.1656461032E+01, 5.7742557443E+00, 1.7978102231E+00, 1.2266867275E+00, 7.5837216506E-01],
	[1.7055000000E+04, 1.1661313058E+01, 5.7740491116E+00, 1.7995059142E+00, 1.2275203897E+00, 7.5849341530E-01],
	[1.7060000000E+04, 1.1666165680E+01, 5.7738425468E+00, 1.8012027066E+00, 1.2283541731E+00, 7.5861461677E-01],
	[1.7065000000E+04, 1.1671018899E+01, 5.7736360499E+00, 1.8029006007E+00, 1.2291880775E+00, 7.5873576949E-01],
	[1.7070000000E+04, 1.1675872714E+01, 5.7734296209E+00, 1.8045995969E+00, 1.2300221025E+00, 7.5885687344E-01],
	[1.7075000000E+04, 1.1680727125E+01, 5.7732232598E+00, 1.8062996956E+00, 1.2308562480E+00, 7.5897792864E-01],
	[1.7080000000E+04, 1.1685582133E+01, 5.7730169664E+00, 1.8080008971E+00, 1.2316905136E+00, 7.5909893509E-01],
	[1.7085000000E+04, 1.1690437736E+01, 5.7728107408E+00, 1.8097032019E+00, 1.2325248989E+00, 7.5921989278E-01],
	[1.7090000000E+04, 1.1695293936E+01, 5.7726045829E+00, 1.8114066104E+00, 1.2333594038E+00, 7.5934080172E-01],
	[1.7095000000E+04, 1.1700150731E+01, 5.7723984927E+00, 1.8131111229E+00, 1.2341940280E+00, 7.5946166191E-01],
	[1.7100000000E+04, 1.1705008122E+01, 5.7721924701E+00, 1.8148167399E+00, 1.2350287711E+00, 7.5958247336E-01],
	[1.7105000000E+04, 1.1709884274E+01, 5.7719906357E+00, 1.8165234617E+00, 1.2358640242E+00, 7.5970323607E-01],
	[1.7110000000E+04, 1.1714767027E+01, 5.7717902265E+00, 1.8182312887E+00, 1.2366995256E+00, 7.5982395004E-01],
	[1.7115000000E+04, 1.1719650387E+01, 5.7715898828E+00, 1.8199402213E+00, 1.2375351462E+00, 7.5994461527E-01],
	[1.7120000000E+04, 1.1724534357E+01, 5.7713896046E+00, 1.8216502600E+00, 1.2383708857E+00, 7.6006523176E-01],
	[1.7125000000E+04, 1.1729418934E+01, 5.7711893918E+00, 1.8233614050E+00, 1.2392067438E+00, 7.6018579953E-01],
	[1.7130000000E+04, 1.1734304120E+01, 5.7709892444E+00, 1.8250736569E+00, 1.2400427202E+00, 7.6030631856E-01],
	[1.7135000000E+04, 1.1739189913E+01, 5.7707891624E+00, 1.8267870159E+00, 1.2408788146E+00, 7.6042678887E-01],
	[1.7140000000E+04, 1.1744076315E+01, 5.7705891457E+00, 1.8285014825E+00, 1.2417150267E+00, 7.6054721046E-01],
	[1.7145000000E+04, 1.1748963324E+01, 5.7703891942E+00, 1.8302170571E+00, 1.2425513564E+00, 7.6066758332E-01],
	[1.7150000000E+04, 1.1753850941E+01, 5.7701893080E+00, 1.8319337400E+00, 1.2433878031E+00, 7.6078790747E-01],
	[1.7155000000E+04, 1.1758739166E+01, 5.7699894869E+00, 1.8336515317E+00, 1.2442243668E+00, 7.6090818290E-01],
	[1.7160000000E+04, 1.1763627998E+01, 5.7697897310E+00, 1.8353704325E+00, 1.2450610471E+00, 7.6102840963E-01],
	[1.7165000000E+04, 1.1768517438E+01, 5.7695900402E+00, 1.8370904429E+00, 1.2458978437E+00, 7.6114858764E-01],
	[1.7170000000E+04, 1.1773407484E+01, 5.7693904145E+00, 1.8388115632E+00, 1.2467347564E+00, 7.6126871695E-01],
	[1.7175000000E+04, 1.1778298139E+01, 5.7691908538E+00, 1.8405337938E+00, 1.2475717848E+00, 7.6138879755E-01],
	[1.7180000000E+04, 1.1783189400E+01, 5.7689913581E+00, 1.8422571352E+00, 1.2484089286E+00, 7.6150882946E-01],
	[1.7185000000E+04, 1.1788081268E+01, 5.7687919273E+00, 1.8439815877E+00, 1.2492461877E+00, 7.6162881267E-01],
	[1.7190000000E+04, 1.1792973743E+01, 5.7685925615E+00, 1.8457071516E+00, 1.2500835617E+00, 7.6174874718E-01],
	[1.7195000000E+04, 1.1797866825E+01, 5.7683932605E+00, 1.8474338275E+00, 1.2509210502E+00, 7.6186863301E-01],
	[1.7200000000E+04, 1.1802760514E+01, 5.7681940243E+00, 1.8491616156E+00, 1.2517586532E+00, 7.6198847015E-01],
	[1.7205000000E+04, 1.1807654810E+01, 5.7679948529E+00, 1.8508905164E+00, 1.2525963701E+00, 7.6210825861E-01],
	[1.7210000000E+04, 1.1812549711E+01, 5.7677957463E+00, 1.8526205303E+00, 1.2534342009E+00, 7.6222799838E-01],
	[1.7215000000E+04, 1.1817445220E+01, 5.7675967044E+00, 1.8543516577E+00, 1.2542721451E+00, 7.6234768949E-01],
	[1.7220000000E+04, 1.1822341334E+01, 5.7673977271E+00, 1.8560838989E+00, 1.2551102026E+00, 7.6246733191E-01],
	[1.7225000000E+04, 1.1827238055E+01, 5.7671988145E+00, 1.8578172543E+00, 1.2559483729E+00, 7.6258692567E-01],
	[1.7230000000E+04, 1.1832135382E+01, 5.7669999665E+00, 1.8595517244E+00, 1.2567866559E+00, 7.6270647076E-01],
	[1.7235000000E+04, 1.1837033315E+01, 5.7668011830E+00, 1.8612873096E+00, 1.2576250512E+00, 7.6282596719E-01],
	[1.7240000000E+04, 1.1841931854E+01, 5.7666024640E+00, 1.8630240102E+00, 1.2584635587E+00, 7.6294541496E-01],
	[1.7245000000E+04, 1.1846830998E+01, 5.7664038095E+00, 1.8647618265E+00, 1.2593021779E+00, 7.6306481408E-01],
	[1.7250000000E+04, 1.1851730749E+01, 5.7662052195E+00, 1.8665007591E+00, 1.2601409086E+00, 7.6318416454E-01],
	[1.7255000000E+04, 1.1856631105E+01, 5.7660066938E+00, 1.8682408083E+00, 1.2609797505E+00, 7.6330346635E-01],
	[1.7260000000E+04, 1.1861532066E+01, 5.7658082324E+00, 1.8699819746E+00, 1.2618187033E+00, 7.6342271952E-01],
	[1.7265000000E+04, 1.1866433633E+01, 5.7656098354E+00, 1.8717242582E+00, 1.2626577669E+00, 7.6354192405E-01],
	[1.7270000000E+04, 1.1871335805E+01, 5.7654115027E+00, 1.8734676595E+00, 1.2634969407E+00, 7.6366107995E-01],
	[1.7275000000E+04, 1.1876238582E+01, 5.7652132341E+00, 1.8752121791E+00, 1.2643362247E+00, 7.6378018720E-01],
	[1.7280000000E+04, 1.1881141965E+01, 5.7650150298E+00, 1.8769578172E+00, 1.2651756185E+00, 7.6389924583E-01],
	[1.7285000000E+04, 1.1886045952E+01, 5.7648168896E+00, 1.8787045743E+00, 1.2660151218E+00, 7.6401825584E-01],
	[1.7290000000E+04, 1.1890950545E+01, 5.7646188136E+00, 1.8804524508E+00, 1.2668547343E+00, 7.6413721722E-01],
	[1.7295000000E+04, 1.1895855742E+01, 5.7644208016E+00, 1.8822014470E+00, 1.2676944558E+00, 7.6425612999E-01],
	[1.7300000000E+04, 1.1900761544E+01, 5.7642228537E+00, 1.8839515633E+00, 1.2685342859E+00, 7.6437499414E-01],
	[1.7305000000E+04, 1.1905667950E+01, 5.7640249697E+00, 1.8857028002E+00, 1.2693742245E+00, 7.6449380968E-01],
	[1.7310000000E+04, 1.1910574961E+01, 5.7638271497E+00, 1.8874551580E+00, 1.2702142711E+00, 7.6461257662E-01],
	[1.7315000000E+04, 1.1915482576E+01, 5.7636293936E+00, 1.8892086371E+00, 1.2710544256E+00, 7.6473129496E-01],
	[1.7320000000E+04, 1.1920390796E+01, 5.7634317014E+00, 1.8909632380E+00, 1.2718946876E+00, 7.6484996469E-01],
	[1.7325000000E+04, 1.1925299620E+01, 5.7632340731E+00, 1.8927189609E+00, 1.2727350568E+00, 7.6496858584E-01],
	[1.7330000000E+04, 1.1930209048E+01, 5.7630365085E+00, 1.8944758063E+00, 1.2735755331E+00, 7.6508715840E-01],
	[1.7335000000E+04, 1.1935119080E+01, 5.7628390077E+00, 1.8962337747E+00, 1.2744161160E+00, 7.6520568237E-01],
	[1.7340000000E+04, 1.1940029715E+01, 5.7626415707E+00, 1.8979928663E+00, 1.2752568053E+00, 7.6532415776E-01],
	[1.7345000000E+04, 1.1944940955E+01, 5.7624441973E+00, 1.8997530816E+00, 1.2760976008E+00, 7.6544258458E-01],
	[1.7350000000E+04, 1.1949852798E+01, 5.7622468876E+00, 1.9015144210E+00, 1.2769385021E+00, 7.6556096282E-01],
	[1.7355000000E+04, 1.1954765245E+01, 5.7620496414E+00, 1.9032768849E+00, 1.2777795089E+00, 7.6567929250E-01],
	[1.7360000000E+04, 1.1959678296E+01, 5.7618524589E+00, 1.9050404736E+00, 1.2786206210E+00, 7.6579757361E-01],
	[1.7365000000E+04, 1.1964591950E+01, 5.7616553398E+00, 1.9068051876E+00, 1.2794618382E+00, 7.6591580617E-01],
	[1.7370000000E+04, 1.1969506207E+01, 5.7614582843E+00, 1.9085710272E+00, 1.2803031600E+00, 7.6603399017E-01],
	[1.7375000000E+04, 1.1974421067E+01, 5.7612612922E+00, 1.9103379928E+00, 1.2811445863E+00, 7.6615212562E-01],
	[1.7380000000E+04, 1.1979353605E+01, 5.7610681078E+00, 1.9121060849E+00, 1.2819864976E+00, 7.6627021253E-01],
	[1.7385000000E+04, 1.1984294408E+01, 5.7608766626E+00, 1.9138753038E+00, 1.2828286844E+00, 7.6638825090E-01],
	[1.7390000000E+04, 1.1989235826E+01, 5.7606852788E+00, 1.9156456500E+00, 1.2836709759E+00, 7.6650624073E-01],
	[1.7395000000E+04, 1.1994177861E+01, 5.7604939564E+00, 1.9174171237E+00, 1.2845133717E+00, 7.6662418203E-01],
	[1.7400000000E+04, 1.1999120511E+01, 5.7603026954E+00, 1.9191897255E+00, 1.2853558717E+00, 7.6674207480E-01],
	[1.7405000000E+04, 1.2004063778E+01, 5.7601114956E+00, 1.9209634556E+00, 1.2861984754E+00, 7.6685991905E-01],
	[1.7410000000E+04, 1.2009007660E+01, 5.7599203571E+00, 1.9227383146E+00, 1.2870411827E+00, 7.6697771479E-01],
	[1.7415000000E+04, 1.2013952158E+01, 5.7597292798E+00, 1.9245143027E+00, 1.2878839932E+00, 7.6709546201E-01],
	[1.7420000000E+04, 1.2018897271E+01, 5.7595382638E+00, 1.9262914204E+00, 1.2887269067E+00, 7.6721316073E-01],
	[1.7425000000E+04, 1.2023843000E+01, 5.7593473088E+00, 1.9280696681E+00, 1.2895699229E+00, 7.6733081094E-01],
	[1.7430000000E+04, 1.2028789344E+01, 5.7591564150E+00, 1.9298490462E+00, 1.2904130414E+00, 7.6744841266E-01],
	[1.7435000000E+04, 1.2033736303E+01, 5.7589655823E+00, 1.9316295550E+00, 1.2912562621E+00, 7.6756596588E-01],
	[1.7440000000E+04, 1.2038683877E+01, 5.7587748106E+00, 1.9334111950E+00, 1.2920995847E+00, 7.6768347062E-01],
	[1.7445000000E+04, 1.2043632067E+01, 5.7585840999E+00, 1.9351939666E+00, 1.2929430087E+00, 7.6780092687E-01],
	[1.7450000000E+04, 1.2048580871E+01, 5.7583934501E+00, 1.9369778700E+00, 1.2937865341E+00, 7.6791833465E-01],
	[1.7455000000E+04, 1.2053530290E+01, 5.7582028613E+00, 1.9387629059E+00, 1.2946301605E+00, 7.6803569395E-01],
	[1.7460000000E+04, 1.2058480324E+01, 5.7580123334E+00, 1.9405490744E+00, 1.2954738875E+00, 7.6815300478E-01],
	[1.7465000000E+04, 1.2063430972E+01, 5.7578218664E+00, 1.9423363761E+00, 1.2963177150E+00, 7.6827026716E-01],
	[1.7470000000E+04, 1.2068382235E+01, 5.7576314601E+00, 1.9441248113E+00, 1.2971616427E+00, 7.6838748107E-01],
	[1.7475000000E+04, 1.2073334113E+01, 5.7574411147E+00, 1.9459143804E+00, 1.2980056702E+00, 7.6850464654E-01],
	[1.7480000000E+04, 1.2078286605E+01, 5.7572508299E+00, 1.9477050838E+00, 1.2988497973E+00, 7.6862176355E-01],
	[1.7485000000E+04, 1.2083239711E+01, 5.7570606059E+00, 1.9494969219E+00, 1.2996940238E+00, 7.6873883213E-01],
	[1.7490000000E+04, 1.2088193431E+01, 5.7568704426E+00, 1.9512898951E+00, 1.3005383492E+00, 7.6885585227E-01],
	[1.7495000000E+04, 1.2093147765E+01, 5.7566803399E+00, 1.9530840038E+00, 1.3013827734E+00, 7.6897282398E-01],
	[1.7500000000E+04, 1.2098102713E+01, 5.7564902978E+00, 1.9548792484E+00, 1.3022272960E+00, 7.6908974726E-01],
	[1.7505000000E+04, 1.2103058275E+01, 5.7563003163E+00, 1.9566887285E+00, 1.3030777264E+00, 7.6920662212E-01],
	[1.7510000000E+04, 1.2108014451E+01, 5.7561103952E+00, 1.9584993656E+00, 1.3039282575E+00, 7.6932344857E-01],
	[1.7515000000E+04, 1.2112971240E+01, 5.7559205347E+00, 1.9603111602E+00, 1.3047788888E+00, 7.6944022661E-01],
	[1.7520000000E+04, 1.2117928643E+01, 5.7557307346E+00, 1.9621241127E+00, 1.3056296203E+00, 7.6955695625E-01],
	[1.7525000000E+04, 1.2122886659E+01, 5.7555409950E+00, 1.9639382235E+00, 1.3064804515E+00, 7.6967363748E-01],
	[1.7530000000E+04, 1.2127845289E+01, 5.7553513157E+00, 1.9657534930E+00, 1.3073313823E+00, 7.6979027033E-01],
	[1.7535000000E+04, 1.2132804532E+01, 5.7551616968E+00, 1.9675699217E+00, 1.3081824122E+00, 7.6990685479E-01],
	[1.7540000000E+04, 1.2137764388E+01, 5.7549721381E+00, 1.9693875098E+00, 1.3090335410E+00, 7.7002339086E-01],
	[1.7545000000E+04, 1.2142724857E+01, 5.7547826397E+00, 1.9712062579E+00, 1.3098847685E+00, 7.7013987856E-01],
	[1.7550000000E+04, 1.2147685939E+01, 5.7545932016E+00, 1.9730261663E+00, 1.3107360944E+00, 7.7025631789E-01],
	[1.7555000000E+04, 1.2152647634E+01, 5.7544038237E+00, 1.9748472355E+00, 1.3115875183E+00, 7.7037270886E-01],
	[1.7560000000E+04, 1.2157609941E+01, 5.7542145059E+00, 1.9766694659E+00, 1.3124390399E+00, 7.7048905146E-01],
	[1.7565000000E+04, 1.2162572861E+01, 5.7540252482E+00, 1.9784928578E+00, 1.3132906591E+00, 7.7060534572E-01],
	[1.7570000000E+04, 1.2167536394E+01, 5.7538360507E+00, 1.9803174117E+00, 1.3141423754E+00, 7.7072159163E-01],
	[1.7575000000E+04, 1.2172500539E+01, 5.7536469132E+00, 1.9821431280E+00, 1.3149941887E+00, 7.7083778919E-01],
	[1.7580000000E+04, 1.2177465297E+01, 5.7534578357E+00, 1.9839700070E+00, 1.3158460986E+00, 7.7095393842E-01],
	[1.7585000000E+04, 1.2182430667E+01, 5.7532688181E+00, 1.9857980493E+00, 1.3166981049E+00, 7.7107003932E-01],
	[1.7590000000E+04, 1.2187396649E+01, 5.7530798606E+00, 1.9876272553E+00, 1.3175502072E+00, 7.7118609190E-01],
	[1.7595000000E+04, 1.2192363243E+01, 5.7528909629E+00, 1.9894576252E+00, 1.3184024052E+00, 7.7130209616E-01],
	[1.7600000000E+04, 1.2197330449E+01, 5.7527021251E+00, 1.9912891596E+00, 1.3192546988E+00, 7.7141805211E-01],
	[1.7605000000E+04, 1.2202298266E+01, 5.7525133471E+00, 1.9931218588E+00, 1.3201070875E+00, 7.7153395975E-01],
	[1.7610000000E+04, 1.2207266696E+01, 5.7523246290E+00, 1.9949557233E+00, 1.3209595712E+00, 7.7164981909E-01],
	[1.7615000000E+04, 1.2212235737E+01, 5.7521359706E+00, 1.9967907534E+00, 1.3218121495E+00, 7.7176563014E-01],
	[1.7620000000E+04, 1.2217205390E+01, 5.7519473719E+00, 1.9986269496E+00, 1.3226648221E+00, 7.7188139291E-01],
	[1.7625000000E+04, 1.2222175654E+01, 5.7517588329E+00, 2.0004643123E+00, 1.3235175888E+00, 7.7199710739E-01],
	[1.7630000000E+04, 1.2227146530E+01, 5.7515703536E+00, 2.0023028419E+00, 1.3243704492E+00, 7.7211277359E-01],
	[1.7635000000E+04, 1.2232118017E+01, 5.7513819339E+00, 2.0041425388E+00, 1.3252234031E+00, 7.7222839153E-01],
	[1.7640000000E+04, 1.2237090115E+01, 5.7511935738E+00, 2.0059834034E+00, 1.3260764502E+00, 7.7234396121E-01],
	[1.7645000000E+04, 1.2242062824E+01, 5.7510052732E+00, 2.0078254361E+00, 1.3269295903E+00, 7.7245948263E-01],
	[1.7650000000E+04, 1.2247036144E+01, 5.7508170322E+00, 2.0096686374E+00, 1.3277828229E+00, 7.7257495580E-01],
	[1.7655000000E+04, 1.2252010075E+01, 5.7506288506E+00, 2.0115130076E+00, 1.3286361479E+00, 7.7269038072E-01],
	[1.7660000000E+04, 1.2257003326E+01, 5.7504447155E+00, 2.0133585471E+00, 1.3294899982E+00, 7.7280575741E-01],
	[1.7665000000E+04, 1.2262003677E+01, 5.7502620185E+00, 2.0152052565E+00, 1.3303440912E+00, 7.7292108587E-01],
	[1.7670000000E+04, 1.2267004651E+01, 5.7500793789E+00, 2.0170531359E+00, 1.3311982767E+00, 7.7303636611E-01],
	[1.7675000000E+04, 1.2272006249E+01, 5.7498967968E+00, 2.0189021860E+00, 1.3320525546E+00, 7.7315159812E-01],
	[1.7680000000E+04, 1.2277008470E+01, 5.7497142721E+00, 2.0207524070E+00, 1.3329069245E+00, 7.7326678193E-01],
	[1.7685000000E+04, 1.2282011316E+01, 5.7495318048E+00, 2.0226037995E+00, 1.3337613862E+00, 7.7338191753E-01],
	[1.7690000000E+04, 1.2287014785E+01, 5.7493493949E+00, 2.0244563637E+00, 1.3346159393E+00, 7.7349700493E-01],
	[1.7695000000E+04, 1.2292018877E+01, 5.7491670424E+00, 2.0263101002E+00, 1.3354705835E+00, 7.7361204414E-01],
	[1.7700000000E+04, 1.2297023593E+01, 5.7489847471E+00, 2.0281650093E+00, 1.3363253187E+00, 7.7372703517E-01],
	[1.7705000000E+04, 1.2302028932E+01, 5.7488025091E+00, 2.0300210914E+00, 1.3371801444E+00, 7.7384197802E-01],
	[1.7710000000E+04, 1.2307034894E+01, 5.7486203284E+00, 2.0318783470E+00, 1.3380350605E+00, 7.7395687269E-01],
	[1.7715000000E+04, 1.2312041479E+01, 5.7484382048E+00, 2.0337367765E+00, 1.3388900665E+00, 7.7407171921E-01],
	[1.7720000000E+04, 1.2317048688E+01, 5.7482561384E+00, 2.0355963802E+00, 1.3397451624E+00, 7.7418651756E-01],
	[1.7725000000E+04, 1.2322056519E+01, 5.7480741291E+00, 2.0374571586E+00, 1.3406003477E+00, 7.7430126776E-01],
	[1.7730000000E+04, 1.2327064972E+01, 5.7478921770E+00, 2.0393191120E+00, 1.3414556221E+00, 7.7441596982E-01],
	[1.7735000000E+04, 1.2332074049E+01, 5.7477102818E+00, 2.0411822410E+00, 1.3423109855E+00, 7.7453062374E-01],
	[1.7740000000E+04, 1.2337083748E+01, 5.7475284438E+00, 2.0430465459E+00, 1.3431664375E+00, 7.7464522953E-01],
	[1.7745000000E+04, 1.2342094070E+01, 5.7473466627E+00, 2.0449120271E+00, 1.3440219777E+00, 7.7475978719E-01],
	[1.7750000000E+04, 1.2347105013E+01, 5.7471649385E+00, 2.0467786850E+00, 1.3448776061E+00, 7.7487429674E-01],
	[1.7755000000E+04, 1.2352116580E+01, 5.7469832713E+00, 2.0486465201E+00, 1.3457333222E+00, 7.7498875818E-01],
	[1.7760000000E+04, 1.2357128768E+01, 5.7468016610E+00, 2.0505155327E+00, 1.3465891257E+00, 7.7510317152E-01],
	[1.7765000000E+04, 1.2362141578E+01, 5.7466201076E+00, 2.0523857233E+00, 1.3474450164E+00, 7.7521753675E-01],
	[1.7770000000E+04, 1.2367155011E+01, 5.7464386109E+00, 2.0542570922E+00, 1.3483009941E+00, 7.7533185390E-01],
	[1.7775000000E+04, 1.2372169065E+01, 5.7462571711E+00, 2.0561296400E+00, 1.3491570584E+00, 7.7544612297E-01],
	[1.7780000000E+04, 1.2377183741E+01, 5.7460757880E+00, 2.0580033669E+00, 1.3500132089E+00, 7.7556034397E-01],
	[1.7785000000E+04, 1.2382199039E+01, 5.7458944617E+00, 2.0598782734E+00, 1.3508694456E+00, 7.7567451689E-01],
	[1.7790000000E+04, 1.2387214958E+01, 5.7457131920E+00, 2.0617543599E+00, 1.3517257680E+00, 7.7578864176E-01],
	[1.7795000000E+04, 1.2392231499E+01, 5.7455319790E+00, 2.0636316269E+00, 1.3525821759E+00, 7.7590271857E-01],
	[1.7800000000E+04, 1.2397248661E+01, 5.7453508226E+00, 2.0655100746E+00, 1.3534386690E+00, 7.7601674733E-01],
	[1.7805000000E+04, 1.2402266444E+01, 5.7451697228E+00, 2.0673897037E+00, 1.3542952470E+00, 7.7613072806E-01],
	[1.7810000000E+04, 1.2407284849E+01, 5.7449886796E+00, 2.0692705143E+00, 1.3551519097E+00, 7.7624466076E-01],
	[1.7815000000E+04, 1.2412303875E+01, 5.7448076928E+00, 2.0711525071E+00, 1.3560086567E+00, 7.7635854543E-01],
	[1.7820000000E+04, 1.2417323521E+01, 5.7446267626E+00, 2.0730356823E+00, 1.3568654877E+00, 7.7647238208E-01],
	[1.7825000000E+04, 1.2422343789E+01, 5.7444458888E+00, 2.0749200404E+00, 1.3577224026E+00, 7.7658617073E-01],
	[1.7830000000E+04, 1.2427364678E+01, 5.7442650715E+00, 2.0768055817E+00, 1.3585794009E+00, 7.7669991152E-01],
	[1.7835000000E+04, 1.2432386187E+01, 5.7440843105E+00, 2.0786923068E+00, 1.3594364825E+00, 7.7681360458E-01],
	[1.7840000000E+04, 1.2437408317E+01, 5.7439036059E+00, 2.0805802160E+00, 1.3602936470E+00, 7.7692724989E-01],
	[1.7845000000E+04, 1.2442431067E+01, 5.7437229576E+00, 2.0824693098E+00, 1.3611508941E+00, 7.7704084746E-01],
	[1.7850000000E+04, 1.2447454438E+01, 5.7435423656E+00, 2.0843595884E+00, 1.3620082236E+00, 7.7715439731E-01],
	[1.7855000000E+04, 1.2452478429E+01, 5.7433618298E+00, 2.0862510525E+00, 1.3628656352E+00, 7.7726789942E-01],
	[1.7860000000E+04, 1.2457503040E+01, 5.7431813503E+00, 2.0881437022E+00, 1.3637231286E+00, 7.7738135381E-01],
	[1.7865000000E+04, 1.2462528271E+01, 5.7430009270E+00, 2.0900375382E+00, 1.3645807035E+00, 7.7749476047E-01],
	[1.7870000000E+04, 1.2467554123E+01, 5.7428205598E+00, 2.0919325607E+00, 1.3654383597E+00, 7.7760811942E-01],
	[1.7875000000E+04, 1.2472580594E+01, 5.7426402487E+00, 2.0938287702E+00, 1.3662960968E+00, 7.7772143065E-01],
	[1.7880000000E+04, 1.2477607685E+01, 5.7424599937E+00, 2.0957261671E+00, 1.3671539146E+00, 7.7783469417E-01],
	[1.7885000000E+04, 1.2482635396E+01, 5.7422797948E+00, 2.0976247519E+00, 1.3680118127E+00, 7.7794790998E-01],
	[1.7890000000E+04, 1.2487663727E+01, 5.7420996519E+00, 2.0995245248E+00, 1.3688697910E+00, 7.7806107809E-01],
	[1.7895000000E+04, 1.2492692677E+01, 5.7419195650E+00, 2.1014254864E+00, 1.3697278491E+00, 7.7817419850E-01],
	[1.7900000000E+04, 1.2497722246E+01, 5.7417395340E+00, 2.1033276370E+00, 1.3705859867E+00, 7.7828727121E-01],
	[1.7905000000E+04, 1.2502752435E+01, 5.7415595590E+00, 2.1052309771E+00, 1.3714442036E+00, 7.7840029623E-01],
	[1.7910000000E+04, 1.2507783243E+01, 5.7413796399E+00, 2.1071355071E+00, 1.3723024994E+00, 7.7851327356E-01],
	[1.7915000000E+04, 1.2512814671E+01, 5.7411997766E+00, 2.1090412273E+00, 1.3731608740E+00, 7.7862620321E-01],
	[1.7920000000E+04, 1.2517846717E+01, 5.7410199691E+00, 2.1109481382E+00, 1.3740193269E+00, 7.7873908518E-01],
	[1.7925000000E+04, 1.2522879382E+01, 5.7408402175E+00, 2.1128562402E+00, 1.3748778580E+00, 7.7885191947E-01],
	[1.7930000000E+04, 1.2527912666E+01, 5.7406605216E+00, 2.1147655338E+00, 1.3757364670E+00, 7.7896470609E-01],
	[1.7935000000E+04, 1.2532946569E+01, 5.7404808814E+00, 2.1166760192E+00, 1.3765951535E+00, 7.7907744504E-01],
	[1.7940000000E+04, 1.2537981091E+01, 5.7403012969E+00, 2.1185876970E+00, 1.3774539172E+00, 7.7919013633E-01],
	[1.7945000000E+04, 1.2543039090E+01, 5.7401265228E+00, 2.1205005675E+00, 1.3783133082E+00, 7.7930277996E-01],
	[1.7950000000E+04, 1.2548100418E+01, 5.7399523639E+00, 2.1224146312E+00, 1.3791728419E+00, 7.7941537594E-01],
	[1.7955000000E+04, 1.2553162378E+01, 5.7397782587E+00, 2.1243298885E+00, 1.3800324531E+00, 7.7952792426E-01],
	[1.7960000000E+04, 1.2558224969E+01, 5.7396042073E+00, 2.1262463397E+00, 1.3808921416E+00, 7.7964042494E-01],
	[1.7965000000E+04, 1.2563288192E+01, 5.7394302097E+00, 2.1281639854E+00, 1.3817519072E+00, 7.7975287797E-01],
	[1.7970000000E+04, 1.2568352047E+01, 5.7392562657E+00, 2.1300828258E+00, 1.3826117494E+00, 7.7986528337E-01],
	[1.7975000000E+04, 1.2573416533E+01, 5.7390823754E+00, 2.1320028614E+00, 1.3834716682E+00, 7.7997764113E-01],
	[1.7980000000E+04, 1.2578481651E+01, 5.7389085388E+00, 2.1339240927E+00, 1.3843316630E+00, 7.8008995127E-01],
	[1.7985000000E+04, 1.2583547400E+01, 5.7387347557E+00, 2.1358465200E+00, 1.3851917338E+00, 7.8020221378E-01],
	[1.7990000000E+04, 1.2588613780E+01, 5.7385610262E+00, 2.1377701437E+00, 1.3860518802E+00, 7.8031442867E-01],
	[1.7995000000E+04, 1.2593680791E+01, 5.7383873502E+00, 2.1396949643E+00, 1.3869121019E+00, 7.8042659594E-01],
	[1.8000000000E+04, 1.2598748433E+01, 5.7382137277E+00, 2.1416209822E+00, 1.3877723986E+00, 7.8053871561E-01],
	[1.8005000000E+04, 1.2603816706E+01, 5.7380401587E+00, 2.1435481978E+00, 1.3886327701E+00, 7.8065078767E-01],
	[1.8010000000E+04, 1.2608885610E+01, 5.7378666432E+00, 2.1454766114E+00, 1.3894932161E+00, 7.8076281213E-01],
	[1.8015000000E+04, 1.2613955144E+01, 5.7376931810E+00, 2.1474062236E+00, 1.3903537362E+00, 7.8087478899E-01],
	[1.8020000000E+04, 1.2619025309E+01, 5.7375197723E+00, 2.1493370346E+00, 1.3912143303E+00, 7.8098671826E-01],
	[1.8025000000E+04, 1.2624096104E+01, 5.7373464169E+00, 2.1512690450E+00, 1.3920749981E+00, 7.8109859994E-01],
	[1.8030000000E+04, 1.2629167530E+01, 5.7371731148E+00, 2.1532022552E+00, 1.3929357392E+00, 7.8121043404E-01],
	[1.8035000000E+04, 1.2634239586E+01, 5.7369998659E+00, 2.1551366654E+00, 1.3937965533E+00, 7.8132222056E-01],
	[1.8040000000E+04, 1.2639312272E+01, 5.7368266704E+00, 2.1570722763E+00, 1.3946574403E+00, 7.8143395952E-01],
	[1.8045000000E+04, 1.2644385589E+01, 5.7366535280E+00, 2.1590090881E+00, 1.3955183998E+00, 7.8154565090E-01],
	[1.8050000000E+04, 1.2649459535E+01, 5.7364804389E+00, 2.1609471013E+00, 1.3963794316E+00, 7.8165729472E-01],
	[1.8055000000E+04, 1.2654534111E+01, 5.7363074029E+00, 2.1628863163E+00, 1.3972405352E+00, 7.8176889098E-01],
	[1.8060000000E+04, 1.2659609317E+01, 5.7361344201E+00, 2.1648267335E+00, 1.3981017106E+00, 7.8188043970E-01],
	[1.8065000000E+04, 1.2664685153E+01, 5.7359614903E+00, 2.1667683534E+00, 1.3989629574E+00, 7.8199194086E-01],
	[1.8070000000E+04, 1.2669761618E+01, 5.7357886136E+00, 2.1687111763E+00, 1.3998242753E+00, 7.8210339448E-01],
	[1.8075000000E+04, 1.2674838713E+01, 5.7356157900E+00, 2.1706552026E+00, 1.4006856640E+00, 7.8221480057E-01],
	[1.8080000000E+04, 1.2679916438E+01, 5.7354430193E+00, 2.1726004327E+00, 1.4015471233E+00, 7.8232615912E-01],
	[1.8085000000E+04, 1.2684994791E+01, 5.7352703017E+00, 2.1745468672E+00, 1.4024086529E+00, 7.8243747014E-01],
	[1.8090000000E+04, 1.2690073774E+01, 5.7350976369E+00, 2.1764945063E+00, 1.4032702525E+00, 7.8254873365E-01],
	[1.8095000000E+04, 1.2695153386E+01, 5.7349250251E+00, 2.1784433505E+00, 1.4041319218E+00, 7.8265994964E-01],
	[1.8100000000E+04, 1.2700233627E+01, 5.7347524662E+00, 2.1803934003E+00, 1.4049936605E+00, 7.8277111812E-01],
	[1.8105000000E+04, 1.2705314497E+01, 5.7345799601E+00, 2.1823446559E+00, 1.4058554685E+00, 7.8288223909E-01],
	[1.8110000000E+04, 1.2710395996E+01, 5.7344075068E+00, 2.1842971179E+00, 1.4067173453E+00, 7.8299331256E-01],
	[1.8115000000E+04, 1.2715478123E+01, 5.7342351064E+00, 2.1862507866E+00, 1.4075792907E+00, 7.8310433854E-01],
	[1.8120000000E+04, 1.2720560879E+01, 5.7340627587E+00, 2.1882056624E+00, 1.4084413044E+00, 7.8321531703E-01],
	[1.8125000000E+04, 1.2725644264E+01, 5.7338904637E+00, 2.1901617459E+00, 1.4093033862E+00, 7.8332624803E-01],
	[1.8130000000E+04, 1.2730728277E+01, 5.7337182214E+00, 2.1921190373E+00, 1.4101655357E+00, 7.8343713156E-01],
	[1.8135000000E+04, 1.2735812919E+01, 5.7335460318E+00, 2.1940775371E+00, 1.4110277528E+00, 7.8354796761E-01],
	[1.8140000000E+04, 1.2740898189E+01, 5.7333738948E+00, 2.1960372457E+00, 1.4118900371E+00, 7.8365875620E-01],
	[1.8145000000E+04, 1.2745984087E+01, 5.7332018104E+00, 2.1979981635E+00, 1.4127523882E+00, 7.8376949732E-01],
	[1.8150000000E+04, 1.2751070613E+01, 5.7330297786E+00, 2.1999602909E+00, 1.4136148061E+00, 7.8388019099E-01],
	[1.8155000000E+04, 1.2756157767E+01, 5.7328577994E+00, 2.2019236284E+00, 1.4144772903E+00, 7.8399083721E-01],
	[1.8160000000E+04, 1.2761245549E+01, 5.7326858727E+00, 2.2038881764E+00, 1.4153398406E+00, 7.8410143599E-01],
	[1.8165000000E+04, 1.2766333958E+01, 5.7325139984E+00, 2.2058539351E+00, 1.4162024568E+00, 7.8421198733E-01],
	[1.8170000000E+04, 1.2771422996E+01, 5.7323421766E+00, 2.2078209052E+00, 1.4170651385E+00, 7.8432249123E-01],
	[1.8175000000E+04, 1.2776512661E+01, 5.7321704072E+00, 2.2097890870E+00, 1.4179278854E+00, 7.8443294771E-01],
	[1.8180000000E+04, 1.2781602953E+01, 5.7319986902E+00, 2.2117584808E+00, 1.4187906974E+00, 7.8454335676E-01],
	[1.8185000000E+04, 1.2786693873E+01, 5.7318270256E+00, 2.2137290872E+00, 1.4196535740E+00, 7.8465371841E-01],
	[1.8190000000E+04, 1.2791785421E+01, 5.7316554133E+00, 2.2157009065E+00, 1.4205165151E+00, 7.8476403264E-01],
	[1.8195000000E+04, 1.2796877595E+01, 5.7314838533E+00, 2.2176739392E+00, 1.4213795203E+00, 7.8487429947E-01],
	[1.8200000000E+04, 1.2801970397E+01, 5.7313123456E+00, 2.2196481856E+00, 1.4222425894E+00, 7.8498451890E-01],
	[1.8205000000E+04, 1.2807063825E+01, 5.7311408902E+00, 2.2216236461E+00, 1.4231057221E+00, 7.8509469094E-01],
	[1.8210000000E+04, 1.2812157881E+01, 5.7309694869E+00, 2.2236003213E+00, 1.4239689182E+00, 7.8520481560E-01],
	[1.8215000000E+04, 1.2817252563E+01, 5.7307981358E+00, 2.2255782114E+00, 1.4248321772E+00, 7.8531489287E-01],
	[1.8220000000E+04, 1.2822347873E+01, 5.7306268369E+00, 2.2275573169E+00, 1.4256954990E+00, 7.8542492278E-01],
	[1.8225000000E+04, 1.2827443808E+01, 5.7304555901E+00, 2.2295376382E+00, 1.4265588834E+00, 7.8553490531E-01],
	[1.8230000000E+04, 1.2832543762E+01, 5.7302850842E+00, 2.2315191758E+00, 1.4274224146E+00, 7.8564484049E-01],
	[1.8235000000E+04, 1.2837666883E+01, 5.7301192065E+00, 2.2335019300E+00, 1.4282865712E+00, 7.8575472831E-01],
	[1.8240000000E+04, 1.2842790644E+01, 5.7299533792E+00, 2.2354859013E+00, 1.4291507907E+00, 7.8586456879E-01],
	[1.8245000000E+04, 1.2847915044E+01, 5.7297876021E+00, 2.2374710900E+00, 1.4300150727E+00, 7.8597436192E-01],
	[1.8250000000E+04, 1.2853040085E+01, 5.7296218752E+00, 2.2394574966E+00, 1.4308794169E+00, 7.8608410772E-01],
	[1.8255000000E+04, 1.2858165765E+01, 5.7294561985E+00, 2.2414451215E+00, 1.4317438231E+00, 7.8619380618E-01],
	[1.8260000000E+04, 1.2863292085E+01, 5.7292905720E+00, 2.2434339651E+00, 1.4326082910E+00, 7.8630345733E-01],
	[1.8265000000E+04, 1.2868419044E+01, 5.7291249956E+00, 2.2454240278E+00, 1.4334728204E+00, 7.8641306116E-01],
	[1.8270000000E+04, 1.2873546642E+01, 5.7289594693E+00, 2.2474153100E+00, 1.4343374109E+00, 7.8652261768E-01],
	[1.8275000000E+04, 1.2878674880E+01, 5.7287939930E+00, 2.2494078122E+00, 1.4352020623E+00, 7.8663212689E-01],
	[1.8280000000E+04, 1.2883803756E+01, 5.7286285669E+00, 2.2514015348E+00, 1.4360667743E+00, 7.8674158881E-01],
	[1.8285000000E+04, 1.2888933272E+01, 5.7284631907E+00, 2.2533964781E+00, 1.4369315466E+00, 7.8685100344E-01],
	[1.8290000000E+04, 1.2894063427E+01, 5.7282978645E+00, 2.2553926426E+00, 1.4377963789E+00, 7.8696037079E-01],
	[1.8295000000E+04, 1.2899194220E+01, 5.7281325883E+00, 2.2573900287E+00, 1.4386612710E+00, 7.8706969086E-01],
	[1.8300000000E+04, 1.2904325653E+01, 5.7279673620E+00, 2.2593886368E+00, 1.4395262227E+00, 7.8717896366E-01],
	[1.8305000000E+04, 1.2909457724E+01, 5.7278021856E+00, 2.2613884673E+00, 1.4403912335E+00, 7.8728818919E-01],
	[1.8310000000E+04, 1.2914590433E+01, 5.7276370591E+00, 2.2633895206E+00, 1.4412563033E+00, 7.8739736747E-01],
	[1.8315000000E+04, 1.2919723781E+01, 5.7274719825E+00, 2.2653917972E+00, 1.4421214317E+00, 7.8750649850E-01],
	[1.8320000000E+04, 1.2924857768E+01, 5.7273069556E+00, 2.2673952975E+00, 1.4429866186E+00, 7.8761558228E-01],
	[1.8325000000E+04, 1.2929992392E+01, 5.7271419786E+00, 2.2694000218E+00, 1.4438518636E+00, 7.8772461883E-01],
	[1.8330000000E+04, 1.2935127655E+01, 5.7269770513E+00, 2.2714059707E+00, 1.4447171664E+00, 7.8783360815E-01],
	[1.8335000000E+04, 1.2940263556E+01, 5.7268121737E+00, 2.2734131444E+00, 1.4455825268E+00, 7.8794255024E-01],
	[1.8340000000E+04, 1.2945400095E+01, 5.7266473458E+00, 2.2754215434E+00, 1.4464479445E+00, 7.8805144512E-01],
	[1.8345000000E+04, 1.2950537272E+01, 5.7264825676E+00, 2.2774311682E+00, 1.4473134192E+00, 7.8816029279E-01],
	[1.8350000000E+04, 1.2955675087E+01, 5.7263178391E+00, 2.2794420191E+00, 1.4481789506E+00, 7.8826909326E-01],
	[1.8355000000E+04, 1.2960813539E+01, 5.7261531601E+00, 2.2814540966E+00, 1.4490445385E+00, 7.8837784653E-01],
	[1.8360000000E+04, 1.2965952629E+01, 5.7259885308E+00, 2.2834674010E+00, 1.4499101826E+00, 7.8848655262E-01],
	[1.8365000000E+04, 1.2971092357E+01, 5.7258239510E+00, 2.2854819328E+00, 1.4507758827E+00, 7.8859521152E-01],
	[1.8370000000E+04, 1.2976232721E+01, 5.7256594207E+00, 2.2874976924E+00, 1.4516416383E+00, 7.8870382325E-01],
	[1.8375000000E+04, 1.2981373724E+01, 5.7254949399E+00, 2.2895146802E+00, 1.4525074494E+00, 7.8881238782E-01],
	[1.8380000000E+04, 1.2986515363E+01, 5.7253305086E+00, 2.2915328966E+00, 1.4533733155E+00, 7.8892090522E-01],
	[1.8385000000E+04, 1.2991657640E+01, 5.7251661268E+00, 2.2935523421E+00, 1.4542392365E+00, 7.8902937547E-01],
	[1.8390000000E+04, 1.2996800554E+01, 5.7250017944E+00, 2.2955730170E+00, 1.4551052120E+00, 7.8913779858E-01],
	[1.8395000000E+04, 1.3001944104E+01, 5.7248375113E+00, 2.2975949218E+00, 1.4559712418E+00, 7.8924617455E-01],
	[1.8400000000E+04, 1.3007088292E+01, 5.7246732777E+00, 2.2996180568E+00, 1.4568373256E+00, 7.8935450339E-01],
	[1.8405000000E+04, 1.3012233116E+01, 5.7245090933E+00, 2.3016424226E+00, 1.4577034631E+00, 7.8946278510E-01],
	[1.8410000000E+04, 1.3017378577E+01, 5.7243449583E+00, 2.3036680194E+00, 1.4585696541E+00, 7.8957101970E-01],
	[1.8415000000E+04, 1.3022524675E+01, 5.7241808725E+00, 2.3056948478E+00, 1.4594358983E+00, 7.8967920719E-01],
	[1.8420000000E+04, 1.3027671409E+01, 5.7240168360E+00, 2.3077229080E+00, 1.4603021953E+00, 7.8978734758E-01],
	[1.8425000000E+04, 1.3032818779E+01, 5.7238528487E+00, 2.3097522007E+00, 1.4611685450E+00, 7.8989544087E-01],
	[1.8430000000E+04, 1.3037966786E+01, 5.7236889106E+00, 2.3117827261E+00, 1.4620349471E+00, 7.9000348708E-01],
	[1.8435000000E+04, 1.3043115429E+01, 5.7235250216E+00, 2.3138144846E+00, 1.4629014012E+00, 7.9011148621E-01],
	[1.8440000000E+04, 1.3048264708E+01, 5.7233611818E+00, 2.3158474768E+00, 1.4637679072E+00, 7.9021943827E-01],
	[1.8445000000E+04, 1.3053414623E+01, 5.7231973911E+00, 2.3178817029E+00, 1.4646344647E+00, 7.9032734327E-01],
	[1.8450000000E+04, 1.3058565174E+01, 5.7230336495E+00, 2.3199171635E+00, 1.4655010734E+00, 7.9043520121E-01],
	[1.8455000000E+04, 1.3063716361E+01, 5.7228699569E+00, 2.3219538589E+00, 1.4663677332E+00, 7.9054301210E-01],
	[1.8460000000E+04, 1.3068868183E+01, 5.7227063134E+00, 2.3239917895E+00, 1.4672344436E+00, 7.9065077594E-01],
	[1.8465000000E+04, 1.3074020642E+01, 5.7225427188E+00, 2.3260309558E+00, 1.4681012046E+00, 7.9075849276E-01],
	[1.8470000000E+04, 1.3079173735E+01, 5.7223791733E+00, 2.3280713581E+00, 1.4689680157E+00, 7.9086616255E-01],
	[1.8475000000E+04, 1.3084327465E+01, 5.7222156766E+00, 2.3301129970E+00, 1.4698348767E+00, 7.9097378532E-01],
	[1.8480000000E+04, 1.3089481829E+01, 5.7220522289E+00, 2.3321558727E+00, 1.4707017873E+00, 7.9108136109E-01],
	[1.8485000000E+04, 1.3094636829E+01, 5.7218888300E+00, 2.3341999857E+00, 1.4715687473E+00, 7.9118888985E-01],
	[1.8490000000E+04, 1.3099792464E+01, 5.7217254800E+00, 2.3362453365E+00, 1.4724357564E+00, 7.9129637161E-01],
	[1.8495000000E+04, 1.3104948734E+01, 5.7215621789E+00, 2.3382919254E+00, 1.4733028142E+00, 7.9140380639E-01],
	[1.8500000000E+04, 1.3110105639E+01, 5.7213989265E+00, 2.3403397529E+00, 1.4741699207E+00, 7.9151119419E-01],
	[1.8505000000E+04, 1.3115263179E+01, 5.7212357229E+00, 2.3423888193E+00, 1.4750370754E+00, 7.9161853502E-01],
	[1.8510000000E+04, 1.3120421354E+01, 5.7210725681E+00, 2.3444391251E+00, 1.4759042780E+00, 7.9172582889E-01],
	[1.8515000000E+04, 1.3125580163E+01, 5.7209094619E+00, 2.3464906707E+00, 1.4767715285E+00, 7.9183307580E-01],
	[1.8520000000E+04, 1.3130739607E+01, 5.7207464045E+00, 2.3485434565E+00, 1.4776388263E+00, 7.9194027577E-01],
	[1.8525000000E+04, 1.3135911189E+01, 5.7205856763E+00, 2.3505974830E+00, 1.4785064694E+00, 7.9204742879E-01],
	[1.8530000000E+04, 1.3141098219E+01, 5.7204279305E+00, 2.3526527504E+00, 1.4793745439E+00, 7.9215453489E-01],
	[1.8535000000E+04, 1.3146285897E+01, 5.7202702316E+00, 2.3547092594E+00, 1.4802426662E+00, 7.9226159406E-01],
	[1.8540000000E+04, 1.3151474222E+01, 5.7201125795E+00, 2.3567670102E+00, 1.4811108360E+00, 7.9236860632E-01],
	[1.8545000000E+04, 1.3156663195E+01, 5.7199549743E+00, 2.3588260033E+00, 1.4819790531E+00, 7.9247557167E-01],
	[1.8550000000E+04, 1.3161852816E+01, 5.7197974159E+00, 2.3608862390E+00, 1.4828473172E+00, 7.9258249012E-01],
	[1.8555000000E+04, 1.3167043085E+01, 5.7196399044E+00, 2.3629477179E+00, 1.4837156280E+00, 7.9268936169E-01],
	[1.8560000000E+04, 1.3172234001E+01, 5.7194824396E+00, 2.3650104403E+00, 1.4845839852E+00, 7.9279618637E-01],
	[1.8565000000E+04, 1.3177425564E+01, 5.7193250215E+00, 2.3670744067E+00, 1.4854523887E+00, 7.9290296417E-01],
	[1.8570000000E+04, 1.3182617775E+01, 5.7191676502E+00, 2.3691396174E+00, 1.4863208381E+00, 7.9300969512E-01],
	[1.8575000000E+04, 1.3187810633E+01, 5.7190103256E+00, 2.3712060729E+00, 1.4871893331E+00, 7.9311637920E-01],
	[1.8580000000E+04, 1.3193004138E+01, 5.7188530476E+00, 2.3732737735E+00, 1.4880578735E+00, 7.9322301644E-01],
	[1.8585000000E+04, 1.3198198290E+01, 5.7186958163E+00, 2.3753427198E+00, 1.4889264590E+00, 7.9332960684E-01],
	[1.8590000000E+04, 1.3203393089E+01, 5.7185386316E+00, 2.3774129121E+00, 1.4897950893E+00, 7.9343615040E-01],
	[1.8595000000E+04, 1.3208588535E+01, 5.7183814935E+00, 2.3794843508E+00, 1.4906637642E+00, 7.9354264714E-01],
	[1.8600000000E+04, 1.3213784627E+01, 5.7182244020E+00, 2.3815570363E+00, 1.4915324834E+00, 7.9364909707E-01],
	[1.8605000000E+04, 1.3218981367E+01, 5.7180673569E+00, 2.3836309691E+00, 1.4924012467E+00, 7.9375550019E-01],
	[1.8610000000E+04, 1.3224178752E+01, 5.7179103584E+00, 2.3857061496E+00, 1.4932700537E+00, 7.9386185651E-01],
	[1.8615000000E+04, 1.3229376784E+01, 5.7177534064E+00, 2.3877825781E+00, 1.4941389041E+00, 7.9396816604E-01],
	[1.8620000000E+04, 1.3234575463E+01, 5.7175965009E+00, 2.3898602552E+00, 1.4950077978E+00, 7.9407442879E-01],
	[1.8625000000E+04, 1.3239774788E+01, 5.7174396418E+00, 2.3919391812E+00, 1.4958767345E+00, 7.9418064477E-01],
	[1.8630000000E+04, 1.3244974759E+01, 5.7172828290E+00, 2.3940193565E+00, 1.4967457138E+00, 7.9428681398E-01],
	[1.8635000000E+04, 1.3250175376E+01, 5.7171260627E+00, 2.3961007815E+00, 1.4976147355E+00, 7.9439293644E-01],
	[1.8640000000E+04, 1.3255376639E+01, 5.7169693427E+00, 2.3981834567E+00, 1.4984837994E+00, 7.9449901215E-01],
	[1.8645000000E+04, 1.3260578548E+01, 5.7168126691E+00, 2.4002673825E+00, 1.4993529052E+00, 7.9460504113E-01],
	[1.8650000000E+04, 1.3265781103E+01, 5.7166560417E+00, 2.4023525593E+00, 1.5002220525E+00, 7.9471102338E-01],
	[1.8655000000E+04, 1.3270984303E+01, 5.7164994606E+00, 2.4044389874E+00, 1.5010912412E+00, 7.9481695890E-01],
	[1.8660000000E+04, 1.3276188149E+01, 5.7163429258E+00, 2.4065266674E+00, 1.5019604709E+00, 7.9492284772E-01],
	[1.8665000000E+04, 1.3281392641E+01, 5.7161864372E+00, 2.4086155997E+00, 1.5028297415E+00, 7.9502868983E-01],
	[1.8670000000E+04, 1.3286597778E+01, 5.7160299948E+00, 2.4107057846E+00, 1.5036990526E+00, 7.9513448525E-01],
	[1.8675000000E+04, 1.3291803560E+01, 5.7158735985E+00, 2.4127972225E+00, 1.5045684039E+00, 7.9524023398E-01],
	[1.8680000000E+04, 1.3297009988E+01, 5.7157172484E+00, 2.4148899139E+00, 1.5054377953E+00, 7.9534593604E-01],
	[1.8685000000E+04, 1.3302217061E+01, 5.7155609444E+00, 2.4169838593E+00, 1.5063072263E+00, 7.9545159143E-01],
	[1.8690000000E+04, 1.3307424779E+01, 5.7154046866E+00, 2.4190790589E+00, 1.5071766968E+00, 7.9555720017E-01],
	[1.8695000000E+04, 1.3312633141E+01, 5.7152484747E+00, 2.4211755132E+00, 1.5080462065E+00, 7.9566276225E-01],
	[1.8700000000E+04, 1.3317842149E+01, 5.7150923090E+00, 2.4232732228E+00, 1.5089157552E+00, 7.9576827769E-01],
	[1.8705000000E+04, 1.3323051801E+01, 5.7149361892E+00, 2.4253721878E+00, 1.5097853424E+00, 7.9587374651E-01],
	[1.8710000000E+04, 1.3328262099E+01, 5.7147801154E+00, 2.4274726020E+00, 1.5106550429E+00, 7.9597916870E-01],
	[1.8715000000E+04, 1.3333473040E+01, 5.7146240876E+00, 2.4295746481E+00, 1.5115249268E+00, 7.9608454427E-01],
	[1.8720000000E+04, 1.3338684627E+01, 5.7144681058E+00, 2.4316779519E+00, 1.5123948486E+00, 7.9618987325E-01],
	[1.8725000000E+04, 1.3343896857E+01, 5.7143121698E+00, 2.4337825138E+00, 1.5132648080E+00, 7.9629515563E-01],
	[1.8730000000E+04, 1.3349109732E+01, 5.7141562797E+00, 2.4358883342E+00, 1.5141348049E+00, 7.9640039142E-01],
	[1.8735000000E+04, 1.3354323252E+01, 5.7140004355E+00, 2.4379954136E+00, 1.5150048389E+00, 7.9650558064E-01],
	[1.8740000000E+04, 1.3359537415E+01, 5.7138446371E+00, 2.4401037523E+00, 1.5158749098E+00, 7.9661072329E-01],
	[1.8745000000E+04, 1.3364752222E+01, 5.7136888846E+00, 2.4422133508E+00, 1.5167450172E+00, 7.9671581938E-01],
	[1.8750000000E+04, 1.3369967674E+01, 5.7135331778E+00, 2.4443242095E+00, 1.5176151610E+00, 7.9682086892E-01],
	[1.8755000000E+04, 1.3375183769E+01, 5.7133775168E+00, 2.4464363288E+00, 1.5184853409E+00, 7.9692587193E-01],
	[1.8760000000E+04, 1.3380400508E+01, 5.7132219015E+00, 2.4485497091E+00, 1.5193555566E+00, 7.9703082840E-01],
	[1.8765000000E+04, 1.3385617890E+01, 5.7130663319E+00, 2.4506643508E+00, 1.5202258078E+00, 7.9713573836E-01],
	[1.8770000000E+04, 1.3390835917E+01, 5.7129108080E+00, 2.4527802545E+00, 1.5210960943E+00, 7.9724060180E-01],
	[1.8775000000E+04, 1.3396054586E+01, 5.7127553297E+00, 2.4548974203E+00, 1.5219664158E+00, 7.9734541874E-01],
	[1.8780000000E+04, 1.3401273899E+01, 5.7125998971E+00, 2.4570158489E+00, 1.5228367720E+00, 7.9745018919E-01],
	[1.8785000000E+04, 1.3406493856E+01, 5.7124445101E+00, 2.4591355406E+00, 1.5237071627E+00, 7.9755491315E-01],
	[1.8790000000E+04, 1.3411714456E+01, 5.7122891687E+00, 2.4612564958E+00, 1.5245775876E+00, 7.9765959065E-01],
	[1.8795000000E+04, 1.3416935698E+01, 5.7121338728E+00, 2.4633787149E+00, 1.5254480465E+00, 7.9776422167E-01],
	[1.8800000000E+04, 1.3422157584E+01, 5.7119786224E+00, 2.4655021984E+00, 1.5263185390E+00, 7.9786880624E-01],
	[1.8805000000E+04, 1.3427380113E+01, 5.7118234176E+00, 2.4676269466E+00, 1.5271890649E+00, 7.9797334435E-01],
	[1.8810000000E+04, 1.3432603284E+01, 5.7116682582E+00, 2.4697529601E+00, 1.5280596240E+00, 7.9807783602E-01],
	[1.8815000000E+04, 1.3437827099E+01, 5.7115131443E+00, 2.4718802391E+00, 1.5289302159E+00, 7.9818228126E-01],
	[1.8820000000E+04, 1.3443051556E+01, 5.7113580758E+00, 2.4740087842E+00, 1.5298008404E+00, 7.9828668006E-01],
	[1.8825000000E+04, 1.3448297982E+01, 5.7112071791E+00, 2.4761385956E+00, 1.5306720700E+00, 7.9839103244E-01],
	[1.8830000000E+04, 1.3453550434E+01, 5.7110573653E+00, 2.4782696740E+00, 1.5315434769E+00, 7.9849533840E-01],
	[1.8835000000E+04, 1.3458803541E+01, 5.7109075952E+00, 2.4804020196E+00, 1.5324149168E+00, 7.9859959795E-01],
	[1.8840000000E+04, 1.3464057305E+01, 5.7107578689E+00, 2.4825356329E+00, 1.5332863895E+00, 7.9870381111E-01],
	[1.8845000000E+04, 1.3469311724E+01, 5.7106081861E+00, 2.4846705143E+00, 1.5341578946E+00, 7.9880797787E-01],
	[1.8850000000E+04, 1.3474566799E+01, 5.7104585470E+00, 2.4868066642E+00, 1.5350294320E+00, 7.9891209824E-01],
	[1.8855000000E+04, 1.3479822530E+01, 5.7103089515E+00, 2.4889440830E+00, 1.5359010013E+00, 7.9901617224E-01],
	[1.8860000000E+04, 1.3485078917E+01, 5.7101593996E+00, 2.4910827712E+00, 1.5367726022E+00, 7.9912019987E-01],
	[1.8865000000E+04, 1.3490335959E+01, 5.7100098912E+00, 2.4932227292E+00, 1.5376442346E+00, 7.9922418113E-01],
	[1.8870000000E+04, 1.3495593656E+01, 5.7098604264E+00, 2.4953639574E+00, 1.5385158982E+00, 7.9932811603E-01],
	[1.8875000000E+04, 1.3500852009E+01, 5.7097110051E+00, 2.4975064561E+00, 1.5393875926E+00, 7.9943200459E-01],
	[1.8880000000E+04, 1.3506111017E+01, 5.7095616272E+00, 2.4996502259E+00, 1.5402593177E+00, 7.9953584681E-01],
	[1.8885000000E+04, 1.3511370681E+01, 5.7094122929E+00, 2.5017952671E+00, 1.5411310731E+00, 7.9963964270E-01],
	[1.8890000000E+04, 1.3516630999E+01, 5.7092630019E+00, 2.5039415802E+00, 1.5420028586E+00, 7.9974339226E-01],
	[1.8895000000E+04, 1.3521891973E+01, 5.7091137544E+00, 2.5060891655E+00, 1.5428746740E+00, 7.9984709550E-01],
	[1.8900000000E+04, 1.3527153601E+01, 5.7089645503E+00, 2.5082380235E+00, 1.5437465189E+00, 7.9995075243E-01],
	[1.8905000000E+04, 1.3532415884E+01, 5.7088153895E+00, 2.5103881546E+00, 1.5446183931E+00, 8.0005436307E-01],
	[1.8910000000E+04, 1.3537678822E+01, 5.7086662721E+00, 2.5125395593E+00, 1.5454902964E+00, 8.0015792740E-01],
	[1.8915000000E+04, 1.3542942414E+01, 5.7085171980E+00, 2.5146922379E+00, 1.5463622284E+00, 8.0026144546E-01],
	[1.8920000000E+04, 1.3548206661E+01, 5.7083681672E+00, 2.5168461908E+00, 1.5472341890E+00, 8.0036491723E-01],
	[1.8925000000E+04, 1.3553471563E+01, 5.7082191796E+00, 2.5190014185E+00, 1.5481061778E+00, 8.0046834274E-01],
	[1.8930000000E+04, 1.3558737118E+01, 5.7080702353E+00, 2.5211579214E+00, 1.5489781947E+00, 8.0057172198E-01],
	[1.8935000000E+04, 1.3564003329E+01, 5.7079213342E+00, 2.5233156999E+00, 1.5498502392E+00, 8.0067505497E-01],
	[1.8940000000E+04, 1.3569270193E+01, 5.7077724763E+00, 2.5254747544E+00, 1.5507223112E+00, 8.0077834171E-01],
	[1.8945000000E+04, 1.3574537711E+01, 5.7076236616E+00, 2.5276350854E+00, 1.5515944105E+00, 8.0088158222E-01],
	[1.8950000000E+04, 1.3579805883E+01, 5.7074748900E+00, 2.5297966932E+00, 1.5524665366E+00, 8.0098477649E-01],
	[1.8955000000E+04, 1.3585074709E+01, 5.7073261616E+00, 2.5319595783E+00, 1.5533386895E+00, 8.0108792454E-01],
	[1.8960000000E+04, 1.3590344189E+01, 5.7071774763E+00, 2.5341237411E+00, 1.5542108688E+00, 8.0119102638E-01],
	[1.8965000000E+04, 1.3595614323E+01, 5.7070288340E+00, 2.5362891819E+00, 1.5550830742E+00, 8.0129408202E-01],
	[1.8970000000E+04, 1.3600885110E+01, 5.7068802348E+00, 2.5384559014E+00, 1.5559553055E+00, 8.0139709146E-01],
	[1.8975000000E+04, 1.3606156551E+01, 5.7067316786E+00, 2.5406238997E+00, 1.5568275624E+00, 8.0150005470E-01],
	[1.8980000000E+04, 1.3611428645E+01, 5.7065831654E+00, 2.5427931774E+00, 1.5576998448E+00, 8.0160297177E-01],
	[1.8985000000E+04, 1.3616701393E+01, 5.7064346952E+00, 2.5449637349E+00, 1.5585721522E+00, 8.0170584267E-01],
	[1.8990000000E+04, 1.3621974794E+01, 5.7062862680E+00, 2.5471355726E+00, 1.5594444845E+00, 8.0180866740E-01],
	[1.8995000000E+04, 1.3627248848E+01, 5.7061378837E+00, 2.5493086909E+00, 1.5603168413E+00, 8.0191144597E-01],
	[1.9000000000E+04, 1.3632523555E+01, 5.7059895423E+00, 2.5514830903E+00, 1.5611892225E+00, 8.0201417840E-01],
	[1.9005000000E+04, 1.3637798915E+01, 5.7058412438E+00, 2.5536587710E+00, 1.5620616278E+00, 8.0211686469E-01],
	[1.9010000000E+04, 1.3643074928E+01, 5.7056929881E+00, 2.5558357337E+00, 1.5629340568E+00, 8.0221950485E-01],
	[1.9015000000E+04, 1.3648351594E+01, 5.7055447753E+00, 2.5580139786E+00, 1.5638065094E+00, 8.0232209889E-01],
	[1.9020000000E+04, 1.3653628912E+01, 5.7053966054E+00, 2.5601935063E+00, 1.5646789853E+00, 8.0242464681E-01],
	[1.9025000000E+04, 1.3658906883E+01, 5.7052484782E+00, 2.5623743170E+00, 1.5655514842E+00, 8.0252714863E-01],
	[1.9030000000E+04, 1.3664185507E+01, 5.7051003937E+00, 2.5645564113E+00, 1.5664240058E+00, 8.0262960435E-01],
	[1.9035000000E+04, 1.3669464783E+01, 5.7049523521E+00, 2.5667397895E+00, 1.5672965500E+00, 8.0273201399E-01],
	[1.9040000000E+04, 1.3674744711E+01, 5.7048043531E+00, 2.5689244521E+00, 1.5681691164E+00, 8.0283437754E-01],
	[1.9045000000E+04, 1.3680025292E+01, 5.7046563968E+00, 2.5711103995E+00, 1.5690417048E+00, 8.0293669503E-01],
	[1.9050000000E+04, 1.3685306525E+01, 5.7045084832E+00, 2.5732976321E+00, 1.5699143149E+00, 8.0303896645E-01],
	[1.9055000000E+04, 1.3690588409E+01, 5.7043606123E+00, 2.5754861504E+00, 1.5707869464E+00, 8.0314119182E-01],
	[1.9060000000E+04, 1.3695870946E+01, 5.7042127840E+00, 2.5776759546E+00, 1.5716595992E+00, 8.0324337114E-01],
	[1.9065000000E+04, 1.3701154135E+01, 5.7040649983E+00, 2.5798670454E+00, 1.5725322729E+00, 8.0334550444E-01],
	[1.9070000000E+04, 1.3706437976E+01, 5.7039172552E+00, 2.5820594230E+00, 1.5734049672E+00, 8.0344759170E-01],
	[1.9075000000E+04, 1.3711722468E+01, 5.7037695546E+00, 2.5842530879E+00, 1.5742776820E+00, 8.0354963294E-01],
	[1.9080000000E+04, 1.3717007612E+01, 5.7036218966E+00, 2.5864480405E+00, 1.5751504170E+00, 8.0365162818E-01],
	[1.9085000000E+04, 1.3722293407E+01, 5.7034742811E+00, 2.5886442812E+00, 1.5760231718E+00, 8.0375357742E-01],
	[1.9090000000E+04, 1.3727579854E+01, 5.7033267080E+00, 2.5908418105E+00, 1.5768959463E+00, 8.0385548066E-01],
	[1.9095000000E+04, 1.3732866952E+01, 5.7031791775E+00, 2.5930406288E+00, 1.5777687402E+00, 8.0395733792E-01],
	[1.9100000000E+04, 1.3738154701E+01, 5.7030316893E+00, 2.5952407364E+00, 1.5786415532E+00, 8.0405914921E-01],
	[1.9105000000E+04, 1.3743443102E+01, 5.7028842436E+00, 2.5974421338E+00, 1.5795143851E+00, 8.0416091454E-01],
	[1.9110000000E+04, 1.3748732154E+01, 5.7027368403E+00, 2.5996448215E+00, 1.5803872355E+00, 8.0426263390E-01],
	[1.9115000000E+04, 1.3754021856E+01, 5.7025894793E+00, 2.6018487998E+00, 1.5812601044E+00, 8.0436430733E-01],
	[1.9120000000E+04, 1.3759312210E+01, 5.7024421607E+00, 2.6040540692E+00, 1.5821329913E+00, 8.0446593481E-01],
	[1.9125000000E+04, 1.3764608641E+01, 5.7022959095E+00, 2.6062606300E+00, 1.5830060468E+00, 8.0456751637E-01],
	[1.9130000000E+04, 1.3769927393E+01, 5.7021537911E+00, 2.6084684827E+00, 1.5838797224E+00, 8.0466905201E-01],
	[1.9135000000E+04, 1.3775246808E+01, 5.7020117134E+00, 2.6106776278E+00, 1.5847534166E+00, 8.0477054174E-01],
	[1.9140000000E+04, 1.3780566888E+01, 5.7018696764E+00, 2.6128880655E+00, 1.5856271290E+00, 8.0487198556E-01],
	[1.9145000000E+04, 1.3785887633E+01, 5.7017276799E+00, 2.6150997965E+00, 1.5865008594E+00, 8.0497338350E-01],
	[1.9150000000E+04, 1.3791209041E+01, 5.7015857241E+00, 2.6173128209E+00, 1.5873746076E+00, 8.0507473555E-01],
	[1.9155000000E+04, 1.3796531114E+01, 5.7014438089E+00, 2.6195271394E+00, 1.5882483732E+00, 8.0517604173E-01],
	[1.9160000000E+04, 1.3801853850E+01, 5.7013019343E+00, 2.6217427523E+00, 1.5891221561E+00, 8.0527730205E-01],
	[1.9165000000E+04, 1.3807177251E+01, 5.7011601002E+00, 2.6239596599E+00, 1.5899959560E+00, 8.0537851651E-01],
	[1.9170000000E+04, 1.3812501315E+01, 5.7010183066E+00, 2.6261778629E+00, 1.5908697726E+00, 8.0547968513E-01],
	[1.9175000000E+04, 1.3817826043E+01, 5.7008765536E+00, 2.6283973615E+00, 1.5917436057E+00, 8.0558080791E-01],
	[1.9180000000E+04, 1.3823151434E+01, 5.7007348410E+00, 2.6306181561E+00, 1.5926174550E+00, 8.0568188486E-01],
	[1.9185000000E+04, 1.3828477490E+01, 5.7005931689E+00, 2.6328402473E+00, 1.5934913202E+00, 8.0578291600E-01],
	[1.9190000000E+04, 1.3833804208E+01, 5.7004515372E+00, 2.6350636353E+00, 1.5943652011E+00, 8.0588390133E-01],
	[1.9195000000E+04, 1.3839131590E+01, 5.7003099459E+00, 2.6372883207E+00, 1.5952390975E+00, 8.0598484087E-01],
	[1.9200000000E+04, 1.3844459635E+01, 5.7001683950E+00, 2.6395143039E+00, 1.5961130090E+00, 8.0608573461E-01],
	[1.9205000000E+04, 1.3849788343E+01, 5.7000268845E+00, 2.6417415852E+00, 1.5969869355E+00, 8.0618658258E-01],
	[1.9210000000E+04, 1.3855117714E+01, 5.6998854144E+00, 2.6439701651E+00, 1.5978608767E+00, 8.0628738477E-01],
	[1.9215000000E+04, 1.3860447749E+01, 5.6997439845E+00, 2.6462000440E+00, 1.5987348322E+00, 8.0638814121E-01],
	[1.9220000000E+04, 1.3865778446E+01, 5.6996025950E+00, 2.6484312223E+00, 1.5996088019E+00, 8.0648885189E-01],
	[1.9225000000E+04, 1.3871109806E+01, 5.6994612458E+00, 2.6506637005E+00, 1.6004827856E+00, 8.0658951684E-01],
	[1.9230000000E+04, 1.3876441828E+01, 5.6993199368E+00, 2.6528974789E+00, 1.6013567828E+00, 8.0669013606E-01],
	[1.9235000000E+04, 1.3881774514E+01, 5.6991786680E+00, 2.6551325580E+00, 1.6022307935E+00, 8.0679070955E-01],
	[1.9240000000E+04, 1.3887107861E+01, 5.6990374395E+00, 2.6573689382E+00, 1.6031048173E+00, 8.0689123733E-01],
	[1.9245000000E+04, 1.3892441872E+01, 5.6988962512E+00, 2.6596066199E+00, 1.6039788540E+00, 8.0699171941E-01],
	[1.9250000000E+04, 1.3897776544E+01, 5.6987551030E+00, 2.6618456036E+00, 1.6048529033E+00, 8.0709215580E-01],
	[1.9255000000E+04, 1.3903111879E+01, 5.6986139950E+00, 2.6640858896E+00, 1.6057269650E+00, 8.0719254651E-01],
	[1.9260000000E+04, 1.3908447876E+01, 5.6984729272E+00, 2.6663274784E+00, 1.6066010388E+00, 8.0729289154E-01],
	[1.9265000000E+04, 1.3913784535E+01, 5.6983318994E+00, 2.6685703704E+00, 1.6074751245E+00, 8.0739319092E-01],
	[1.9270000000E+04, 1.3919121856E+01, 5.6981909117E+00, 2.6708145660E+00, 1.6083492218E+00, 8.0749344464E-01],
	[1.9275000000E+04, 1.3924459839E+01, 5.6980499641E+00, 2.6730600656E+00, 1.6092233304E+00, 8.0759365271E-01],
	[1.9280000000E+04, 1.3929798484E+01, 5.6979090565E+00, 2.6753068696E+00, 1.6100974501E+00, 8.0769381516E-01],
	[1.9285000000E+04, 1.3935137790E+01, 5.6977681890E+00, 2.6775549786E+00, 1.6109715807E+00, 8.0779393198E-01],
	[1.9290000000E+04, 1.3940477758E+01, 5.6976273614E+00, 2.6798043928E+00, 1.6118457219E+00, 8.0789400319E-01],
	[1.9295000000E+04, 1.3945818388E+01, 5.6974865738E+00, 2.6820551127E+00, 1.6127198734E+00, 8.0799402879E-01],
	[1.9300000000E+04, 1.3951159679E+01, 5.6973458262E+00, 2.6843071388E+00, 1.6135940350E+00, 8.0809400881E-01],
	[1.9305000000E+04, 1.3956501632E+01, 5.6972051185E+00, 2.6865604714E+00, 1.6144682064E+00, 8.0819394324E-01],
	[1.9310000000E+04, 1.3961844245E+01, 5.6970644508E+00, 2.6888151109E+00, 1.6153423874E+00, 8.0829383210E-01],
	[1.9315000000E+04, 1.3967187520E+01, 5.6969238229E+00, 2.6910710578E+00, 1.6162165777E+00, 8.0839367539E-01],
	[1.9320000000E+04, 1.3972531456E+01, 5.6967832349E+00, 2.6933283126E+00, 1.6170907771E+00, 8.0849347314E-01],
	[1.9325000000E+04, 1.3977876053E+01, 5.6966426867E+00, 2.6955868755E+00, 1.6179649854E+00, 8.0859322534E-01],
	[1.9330000000E+04, 1.3983221311E+01, 5.6965021784E+00, 2.6978467471E+00, 1.6188392021E+00, 8.0869293201E-01],
	[1.9335000000E+04, 1.3988567230E+01, 5.6963617098E+00, 2.7001079278E+00, 1.6197134272E+00, 8.0879259316E-01],
	[1.9340000000E+04, 1.3993913809E+01, 5.6962212811E+00, 2.7023704179E+00, 1.6205876604E+00, 8.0889220879E-01],
	[1.9345000000E+04, 1.3999261050E+01, 5.6960808921E+00, 2.7046342179E+00, 1.6214619013E+00, 8.0899177893E-01],
	[1.9350000000E+04, 1.4004608950E+01, 5.6959405428E+00, 2.7068993283E+00, 1.6223361499E+00, 8.0909130357E-01],
	[1.9355000000E+04, 1.4009957511E+01, 5.6958002333E+00, 2.7091657494E+00, 1.6232104057E+00, 8.0919078274E-01],
	[1.9360000000E+04, 1.4015306733E+01, 5.6956599634E+00, 2.7114334816E+00, 1.6240846685E+00, 8.0929021643E-01],
	[1.9365000000E+04, 1.4020656615E+01, 5.6955197333E+00, 2.7137025254E+00, 1.6249589382E+00, 8.0938960466E-01],
	[1.9370000000E+04, 1.4026007157E+01, 5.6953795428E+00, 2.7159728812E+00, 1.6258332144E+00, 8.0948894745E-01],
	[1.9375000000E+04, 1.4031358359E+01, 5.6952393919E+00, 2.7182445494E+00, 1.6267074969E+00, 8.0958824479E-01],
	[1.9380000000E+04, 1.4036710221E+01, 5.6950992806E+00, 2.7205175304E+00, 1.6275817854E+00, 8.0968749671E-01],
	[1.9385000000E+04, 1.4042062743E+01, 5.6949592089E+00, 2.7227918247E+00, 1.6284560798E+00, 8.0978670320E-01],
	[1.9390000000E+04, 1.4047415925E+01, 5.6948191768E+00, 2.7250674327E+00, 1.6293303796E+00, 8.0988586429E-01],
	[1.9395000000E+04, 1.4052769767E+01, 5.6946791843E+00, 2.7273443547E+00, 1.6302046848E+00, 8.0998497998E-01],
	[1.9400000000E+04, 1.4058124268E+01, 5.6945392312E+00, 2.7296225913E+00, 1.6310789950E+00, 8.1008405029E-01],
	[1.9405000000E+04, 1.4063479429E+01, 5.6943993177E+00, 2.7319021428E+00, 1.6319533100E+00, 8.1018307522E-01],
	[1.9410000000E+04, 1.4068835250E+01, 5.6942594436E+00, 2.7341830096E+00, 1.6328276295E+00, 8.1028205478E-01],
	[1.9415000000E+04, 1.4074191729E+01, 5.6941196091E+00, 2.7364651922E+00, 1.6337019533E+00, 8.1038098899E-01],
	[1.9420000000E+04, 1.4079548869E+01, 5.6939798139E+00, 2.7387486910E+00, 1.6345762811E+00, 8.1047987786E-01],
	[1.9425000000E+04, 1.4084906667E+01, 5.6938400582E+00, 2.7410335064E+00, 1.6354506127E+00, 8.1057872139E-01],
	[1.9430000000E+04, 1.4090265125E+01, 5.6937003418E+00, 2.7433196389E+00, 1.6363249478E+00, 8.1067751959E-01],
	[1.9435000000E+04, 1.4095641460E+01, 5.6935638384E+00, 2.7456070888E+00, 1.6371997809E+00, 8.1077627249E-01],
	[1.9440000000E+04, 1.4101028740E+01, 5.6934292668E+00, 2.7478958565E+00, 1.6380749133E+00, 8.1087498008E-01],
	[1.9445000000E+04, 1.4106416694E+01, 5.6932947330E+00, 2.7501859425E+00, 1.6389500496E+00, 8.1097364238E-01],
	[1.9450000000E+04, 1.4111805320E+01, 5.6931602369E+00, 2.7524773473E+00, 1.6398251897E+00, 8.1107225941E-01],
	[1.9455000000E+04, 1.4117194618E+01, 5.6930257786E+00, 2.7547700711E+00, 1.6407003334E+00, 8.1117083116E-01],
	[1.9460000000E+04, 1.4122584590E+01, 5.6928913581E+00, 2.7570641145E+00, 1.6415754802E+00, 8.1126935765E-01],
	[1.9465000000E+04, 1.4127975233E+01, 5.6927569752E+00, 2.7593594779E+00, 1.6424506301E+00, 8.1136783890E-01],
	[1.9470000000E+04, 1.4133366549E+01, 5.6926226300E+00, 2.7616561617E+00, 1.6433257827E+00, 8.1146627491E-01],
	[1.9475000000E+04, 1.4138758537E+01, 5.6924883225E+00, 2.7639541662E+00, 1.6442009378E+00, 8.1156466569E-01],
	[1.9480000000E+04, 1.4144151197E+01, 5.6923540526E+00, 2.7662534920E+00, 1.6450760952E+00, 8.1166301126E-01],
	[1.9485000000E+04, 1.4149544529E+01, 5.6922198204E+00, 2.7685541394E+00, 1.6459512546E+00, 8.1176131163E-01],
	[1.9490000000E+04, 1.4154938534E+01, 5.6920856257E+00, 2.7708561089E+00, 1.6468264158E+00, 8.1185956680E-01],
	[1.9495000000E+04, 1.4160333210E+01, 5.6919514687E+00, 2.7731594009E+00, 1.6477015784E+00, 8.1195777679E-01],
	[1.9500000000E+04, 1.4165728558E+01, 5.6918173492E+00, 2.7754640158E+00, 1.6485767424E+00, 8.1205594161E-01],
	[1.9505000000E+04, 1.4171124577E+01, 5.6916832672E+00, 2.7777699540E+00, 1.6494519073E+00, 8.1215406127E-01],
	[1.9510000000E+04, 1.4176521268E+01, 5.6915492228E+00, 2.7800772160E+00, 1.6503270731E+00, 8.1225213578E-01],
	[1.9515000000E+04, 1.4181918631E+01, 5.6914152159E+00, 2.7823858021E+00, 1.6512022393E+00, 8.1235016515E-01],
	[1.9520000000E+04, 1.4187316665E+01, 5.6912812465E+00, 2.7846957128E+00, 1.6520774058E+00, 8.1244814939E-01],
	[1.9525000000E+04, 1.4192715370E+01, 5.6911473145E+00, 2.7870069485E+00, 1.6529525723E+00, 8.1254608852E-01],
	[1.9530000000E+04, 1.4198114747E+01, 5.6910134200E+00, 2.7893195097E+00, 1.6538277386E+00, 8.1264398254E-01],
	[1.9535000000E+04, 1.4203514795E+01, 5.6908795629E+00, 2.7916333967E+00, 1.6547029045E+00, 8.1274183147E-01],
	[1.9540000000E+04, 1.4208915514E+01, 5.6907457432E+00, 2.7939486099E+00, 1.6555780696E+00, 8.1283963532E-01],
	[1.9545000000E+04, 1.4214316904E+01, 5.6906119608E+00, 2.7962651499E+00, 1.6564532338E+00, 8.1293739410E-01],
	[1.9550000000E+04, 1.4219718964E+01, 5.6904782159E+00, 2.7985830169E+00, 1.6573283967E+00, 8.1303510782E-01],
	[1.9555000000E+04, 1.4225121696E+01, 5.6903445083E+00, 2.8009022115E+00, 1.6582035582E+00, 8.1313277649E-01],
	[1.9560000000E+04, 1.4230525098E+01, 5.6902108380E+00, 2.8032227340E+00, 1.6590787180E+00, 8.1323040012E-01],
	[1.9565000000E+04, 1.4235929171E+01, 5.6900772050E+00, 2.8055445849E+00, 1.6599538758E+00, 8.1332797872E-01],
	[1.9570000000E+04, 1.4241333915E+01, 5.6899436093E+00, 2.8078677646E+00, 1.6608290314E+00, 8.1342551232E-01],
	[1.9575000000E+04, 1.4246739329E+01, 5.6898100509E+00, 2.8101922734E+00, 1.6617041846E+00, 8.1352300090E-01],
	[1.9580000000E+04, 1.4252145413E+01, 5.6896765297E+00, 2.8125181120E+00, 1.6625793351E+00, 8.1362044450E-01],
	[1.9585000000E+04, 1.4257552168E+01, 5.6895430457E+00, 2.8148452805E+00, 1.6634544827E+00, 8.1371784311E-01],
	[1.9590000000E+04, 1.4262959592E+01, 5.6894095990E+00, 2.8171737795E+00, 1.6643296271E+00, 8.1381519676E-01],
	[1.9595000000E+04, 1.4268367687E+01, 5.6892761894E+00, 2.8195036095E+00, 1.6652047680E+00, 8.1391250545E-01],
	[1.9600000000E+04, 1.4273776452E+01, 5.6891428170E+00, 2.8218347707E+00, 1.6660799053E+00, 8.1400976919E-01],
	[1.9605000000E+04, 1.4279185887E+01, 5.6890094817E+00, 2.8241672637E+00, 1.6669550386E+00, 8.1410698800E-01],
	[1.9610000000E+04, 1.4284595992E+01, 5.6888761835E+00, 2.8265010888E+00, 1.6678301678E+00, 8.1420416188E-01],
	[1.9615000000E+04, 1.4290006766E+01, 5.6887429225E+00, 2.8288362465E+00, 1.6687052926E+00, 8.1430129086E-01],
	[1.9620000000E+04, 1.4295418210E+01, 5.6886096986E+00, 2.8311727372E+00, 1.6695804127E+00, 8.1439837493E-01],
	[1.9625000000E+04, 1.4300830324E+01, 5.6884765117E+00, 2.8335105612E+00, 1.6704555279E+00, 8.1449541411E-01],
	[1.9630000000E+04, 1.4306243107E+01, 5.6883433618E+00, 2.8358497192E+00, 1.6713306379E+00, 8.1459240842E-01],
	[1.9635000000E+04, 1.4311656559E+01, 5.6882102490E+00, 2.8381902114E+00, 1.6722057426E+00, 8.1468935786E-01],
	[1.9640000000E+04, 1.4317070681E+01, 5.6880771732E+00, 2.8405320382E+00, 1.6730808417E+00, 8.1478626245E-01],
	[1.9645000000E+04, 1.4322485472E+01, 5.6879441344E+00, 2.8428752002E+00, 1.6739559348E+00, 8.1488312219E-01],
	[1.9650000000E+04, 1.4327900932E+01, 5.6878111325E+00, 2.8452196977E+00, 1.6748310218E+00, 8.1497993711E-01],
	[1.9655000000E+04, 1.4333317061E+01, 5.6876781676E+00, 2.8475655311E+00, 1.6757061025E+00, 8.1507670720E-01],
	[1.9660000000E+04, 1.4338733860E+01, 5.6875452396E+00, 2.8499127008E+00, 1.6765811766E+00, 8.1517343249E-01],
	[1.9665000000E+04, 1.4344151327E+01, 5.6874123485E+00, 2.8522612074E+00, 1.6774562438E+00, 8.1527011299E-01],
	[1.9670000000E+04, 1.4349569463E+01, 5.6872794944E+00, 2.8546110511E+00, 1.6783313038E+00, 8.1536674870E-01],
	[1.9675000000E+04, 1.4354988267E+01, 5.6871466770E+00, 2.8569622325E+00, 1.6792063566E+00, 8.1546333963E-01],
	[1.9680000000E+04, 1.4360407740E+01, 5.6870138966E+00, 2.8593147519E+00, 1.6800814017E+00, 8.1555988581E-01],
	[1.9685000000E+04, 1.4365827882E+01, 5.6868811529E+00, 2.8616686098E+00, 1.6809564391E+00, 8.1565638724E-01],
	[1.9690000000E+04, 1.4371248692E+01, 5.6867484461E+00, 2.8640238066E+00, 1.6818314683E+00, 8.1575284394E-01],
	[1.9695000000E+04, 1.4376670171E+01, 5.6866157761E+00, 2.8663803427E+00, 1.6827064893E+00, 8.1584925591E-01],
	[1.9700000000E+04, 1.4382092317E+01, 5.6864831428E+00, 2.8687382185E+00, 1.6835815016E+00, 8.1594562316E-01],
	[1.9705000000E+04, 1.4387515132E+01, 5.6863505463E+00, 2.8710974344E+00, 1.6844565052E+00, 8.1604194572E-01],
	[1.9710000000E+04, 1.4392938615E+01, 5.6862179865E+00, 2.8734579909E+00, 1.6853314997E+00, 8.1613822359E-01],
	[1.9715000000E+04, 1.4398362766E+01, 5.6860854634E+00, 2.8758198884E+00, 1.6862064850E+00, 8.1623445677E-01],
	[1.9720000000E+04, 1.4403787585E+01, 5.6859529771E+00, 2.8781831273E+00, 1.6870814607E+00, 8.1633064529E-01],
	[1.9725000000E+04, 1.4409213072E+01, 5.6858205273E+00, 2.8805477081E+00, 1.6879564266E+00, 8.1642678915E-01],
	[1.9730000000E+04, 1.4414639226E+01, 5.6856881143E+00, 2.8829136311E+00, 1.6888313825E+00, 8.1652288835E-01],
	[1.9735000000E+04, 1.4420066048E+01, 5.6855557379E+00, 2.8852808968E+00, 1.6897063281E+00, 8.1661894292E-01],
	[1.9740000000E+04, 1.4425493538E+01, 5.6854233981E+00, 2.8876495055E+00, 1.6905812633E+00, 8.1671495285E-01],
	[1.9745000000E+04, 1.4430923396E+01, 5.6852914008E+00, 2.8900194578E+00, 1.6914562382E+00, 8.1681091817E-01],
	[1.9750000000E+04, 1.4436380128E+01, 5.6851641525E+00, 2.8923907540E+00, 1.6923319798E+00, 8.1690683887E-01],
	[1.9755000000E+04, 1.4441837541E+01, 5.6850369393E+00, 2.8947633946E+00, 1.6932077115E+00, 8.1700271498E-01],
	[1.9760000000E+04, 1.4447295636E+01, 5.6849097611E+00, 2.8971373800E+00, 1.6940834329E+00, 8.1709854649E-01],
	[1.9765000000E+04, 1.4452754412E+01, 5.6847826179E+00, 2.8995127106E+00, 1.6949591439E+00, 8.1719433343E-01],
	[1.9770000000E+04, 1.4458213869E+01, 5.6846555098E+00, 2.9018893868E+00, 1.6958348441E+00, 8.1729007579E-01],
	[1.9775000000E+04, 1.4463674006E+01, 5.6845284366E+00, 2.9042674090E+00, 1.6967105334E+00, 8.1738577359E-01],
	[1.9780000000E+04, 1.4469134825E+01, 5.6844013984E+00, 2.9066467777E+00, 1.6975862115E+00, 8.1748142685E-01],
	[1.9785000000E+04, 1.4474596324E+01, 5.6842743951E+00, 2.9090274933E+00, 1.6984618782E+00, 8.1757703556E-01],
	[1.9790000000E+04, 1.4480058504E+01, 5.6841474268E+00, 2.9114095562E+00, 1.6993375332E+00, 8.1767259974E-01],
	[1.9795000000E+04, 1.4485521365E+01, 5.6840204934E+00, 2.9137929668E+00, 1.7002131762E+00, 8.1776811941E-01],
	[1.9800000000E+04, 1.4490984906E+01, 5.6838935948E+00, 2.9161777256E+00, 1.7010888072E+00, 8.1786359456E-01],
	[1.9805000000E+04, 1.4496449128E+01, 5.6837667312E+00, 2.9185638330E+00, 1.7019644257E+00, 8.1795902522E-01],
	[1.9810000000E+04, 1.4501914030E+01, 5.6836399024E+00, 2.9209512893E+00, 1.7028400316E+00, 8.1805441139E-01],
	[1.9815000000E+04, 1.4507379612E+01, 5.6835131084E+00, 2.9233400951E+00, 1.7037156246E+00, 8.1814975308E-01],
	[1.9820000000E+04, 1.4512845874E+01, 5.6833863493E+00, 2.9257302507E+00, 1.7045912045E+00, 8.1824505030E-01],
	[1.9825000000E+04, 1.4518312816E+01, 5.6832596249E+00, 2.9281217566E+00, 1.7054667710E+00, 8.1834030307E-01],
	[1.9830000000E+04, 1.4523780438E+01, 5.6831329353E+00, 2.9305146131E+00, 1.7063423240E+00, 8.1843551139E-01],
	[1.9835000000E+04, 1.4529248740E+01, 5.6830062805E+00, 2.9329088208E+00, 1.7072178631E+00, 8.1853067527E-01],
	[1.9840000000E+04, 1.4534717722E+01, 5.6828796605E+00, 2.9353043800E+00, 1.7080933882E+00, 8.1862579472E-01],
	[1.9845000000E+04, 1.4540187384E+01, 5.6827530751E+00, 2.9377012911E+00, 1.7089688989E+00, 8.1872086977E-01],
	[1.9850000000E+04, 1.4545657725E+01, 5.6826265245E+00, 2.9400995546E+00, 1.7098443951E+00, 8.1881590040E-01],
	[1.9855000000E+04, 1.4551128746E+01, 5.6825000086E+00, 2.9424991709E+00, 1.7107198766E+00, 8.1891088664E-01],
	[1.9860000000E+04, 1.4556600446E+01, 5.6823735273E+00, 2.9449001404E+00, 1.7115953430E+00, 8.1900582850E-01],
	[1.9865000000E+04, 1.4562072826E+01, 5.6822470807E+00, 2.9473024636E+00, 1.7124707941E+00, 8.1910072598E-01],
	[1.9870000000E+04, 1.4567545885E+01, 5.6821206687E+00, 2.9497061408E+00, 1.7133462297E+00, 8.1919557910E-01],
	[1.9875000000E+04, 1.4573019623E+01, 5.6819942913E+00, 2.9521111724E+00, 1.7142216496E+00, 8.1929038787E-01],
	[1.9880000000E+04, 1.4578494040E+01, 5.6818679486E+00, 2.9545175590E+00, 1.7150970536E+00, 8.1938515230E-01],
	[1.9885000000E+04, 1.4583969137E+01, 5.6817416404E+00, 2.9569253009E+00, 1.7159724413E+00, 8.1947987240E-01],
	[1.9890000000E+04, 1.4589444912E+01, 5.6816153668E+00, 2.9593343986E+00, 1.7168478125E+00, 8.1957454817E-01],
	[1.9895000000E+04, 1.4594921366E+01, 5.6814891277E+00, 2.9617448524E+00, 1.7177231671E+00, 8.1966917964E-01],
	[1.9900000000E+04, 1.4600398499E+01, 5.6813629232E+00, 2.9641566628E+00, 1.7185985047E+00, 8.1976376681E-01],
	[1.9905000000E+04, 1.4605876310E+01, 5.6812367531E+00, 2.9665698302E+00, 1.7194738252E+00, 8.1985830969E-01],
	[1.9910000000E+04, 1.4611354800E+01, 5.6811106176E+00, 2.9689843550E+00, 1.7203491283E+00, 8.1995280829E-01],
	[1.9915000000E+04, 1.4616833969E+01, 5.6809845165E+00, 2.9714002377E+00, 1.7212244138E+00, 8.2004726263E-01],
	[1.9920000000E+04, 1.4622313816E+01, 5.6808584499E+00, 2.9738174787E+00, 1.7220996813E+00, 8.2014167271E-01],
	[1.9925000000E+04, 1.4627794341E+01, 5.6807324177E+00, 2.9762360784E+00, 1.7229749308E+00, 8.2023603855E-01],
	[1.9930000000E+04, 1.4633275544E+01, 5.6806064199E+00, 2.9786560372E+00, 1.7238501619E+00, 8.2033036015E-01],
	[1.9935000000E+04, 1.4638757426E+01, 5.6804804565E+00, 2.9810773555E+00, 1.7247253745E+00, 8.2042463753E-01],
	[1.9940000000E+04, 1.4644239986E+01, 5.6803545275E+00, 2.9835000338E+00, 1.7256005682E+00, 8.2051887070E-01],
	[1.9945000000E+04, 1.4649723224E+01, 5.6802286329E+00, 2.9859240725E+00, 1.7264757429E+00, 8.2061305967E-01],
	[1.9950000000E+04, 1.4655207139E+01, 5.6801027726E+00, 2.9883494720E+00, 1.7273508983E+00, 8.2070720445E-01],
	[1.9955000000E+04, 1.4660691733E+01, 5.6799769467E+00, 2.9907762328E+00, 1.7282260341E+00, 8.2080130505E-01],
	[1.9960000000E+04, 1.4666177004E+01, 5.6798511550E+00, 2.9932043552E+00, 1.7291011502E+00, 8.2089536148E-01],
	[1.9965000000E+04, 1.4671662953E+01, 5.6797253977E+00, 2.9956338396E+00, 1.7299762463E+00, 8.2098937376E-01],
	[1.9970000000E+04, 1.4677149579E+01, 5.6795996746E+00, 2.9980646866E+00, 1.7308513222E+00, 8.2108334189E-01],
	[1.9975000000E+04, 1.4682636883E+01, 5.6794739858E+00, 3.0004968965E+00, 1.7317263776E+00, 8.2117726589E-01],
	[1.9980000000E+04, 1.4688124864E+01, 5.6793483312E+00, 3.0029304697E+00, 1.7326014123E+00, 8.2127114576E-01],
	[1.9985000000E+04, 1.4693613523E+01, 5.6792227108E+00, 3.0053654067E+00, 1.7334764261E+00, 8.2136498152E-01],
	[1.9990000000E+04, 1.4699102858E+01, 5.6790971247E+00, 3.0078017079E+00, 1.7343514187E+00, 8.2145877318E-01],
	[1.9995000000E+04, 1.4704592871E+01, 5.6789715727E+00, 3.0102393737E+00, 1.7352263899E+00, 8.2155252075E-01],
	[2.0000000000E+04, 1.4710083561E+01, 5.6788460549E+00, 3.0126784046E+00, 1.7361013395E+00, 8.2164622424E-01],
	[2.0005000000E+04, 1.4715574928E+01, 5.6787205712E+00, 3.0151219365E+00, 1.7369773078E+00, 8.2173988366E-01],
	[2.0010000000E+04, 1.4721066972E+01, 5.6785951217E+00, 3.0175668385E+00, 1.7378532542E+00, 8.2183349903E-01],
	[2.0015000000E+04, 1.4726559692E+01, 5.6784697063E+00, 3.0200131111E+00, 1.7387291783E+00, 8.2192707036E-01],
	[2.0020000000E+04, 1.4732053089E+01, 5.6783443250E+00, 3.0224607547E+00, 1.7396050800E+00, 8.2202059765E-01],
	[2.0025000000E+04, 1.4737547163E+01, 5.6782189777E+00, 3.0249097697E+00, 1.7404809591E+00, 8.2211408091E-01],
	[2.0030000000E+04, 1.4743041913E+01, 5.6780936645E+00, 3.0273601565E+00, 1.7413568152E+00, 8.2220752017E-01],
	[2.0035000000E+04, 1.4748537340E+01, 5.6779683854E+00, 3.0298119156E+00, 1.7422326482E+00, 8.2230091543E-01],
	[2.0040000000E+04, 1.4754033443E+01, 5.6778431403E+00, 3.0322650474E+00, 1.7431084578E+00, 8.2239426670E-01],
	[2.0045000000E+04, 1.4759530223E+01, 5.6777179291E+00, 3.0347195523E+00, 1.7439842438E+00, 8.2248757399E-01],
	[2.0050000000E+04, 1.4765027678E+01, 5.6775927520E+00, 3.0371754307E+00, 1.7448600060E+00, 8.2258083732E-01],
	[2.0055000000E+04, 1.4770525810E+01, 5.6774676089E+00, 3.0396326831E+00, 1.7457357441E+00, 8.2267405670E-01],
	[2.0060000000E+04, 1.4776024617E+01, 5.6773424997E+00, 3.0420913099E+00, 1.7466114579E+00, 8.2276723213E-01],
	[2.0065000000E+04, 1.4781537883E+01, 5.6772198483E+00, 3.0445513115E+00, 1.7474875694E+00, 8.2286036363E-01],
	[2.0070000000E+04, 1.4787066271E+01, 5.6770997687E+00, 3.0470126884E+00, 1.7483640994E+00, 8.2295345122E-01],
	[2.0075000000E+04, 1.4792595349E+01, 5.6769797216E+00, 3.0494754409E+00, 1.7492406056E+00, 8.2304649490E-01],
	[2.0080000000E+04, 1.4798125117E+01, 5.6768597068E+00, 3.0519395695E+00, 1.7501170878E+00, 8.2313949468E-01],
	[2.0085000000E+04, 1.4803655574E+01, 5.6767397246E+00, 3.0544050747E+00, 1.7509935458E+00, 8.2323245057E-01],
	[2.0090000000E+04, 1.4809186721E+01, 5.6766197747E+00, 3.0568719567E+00, 1.7518699793E+00, 8.2332536260E-01],
	[2.0095000000E+04, 1.4814718558E+01, 5.6764998572E+00, 3.0593402162E+00, 1.7527463882E+00, 8.2341823076E-01],
	[2.0100000000E+04, 1.4820251083E+01, 5.6763799720E+00, 3.0618098534E+00, 1.7536227721E+00, 8.2351105507E-01],
	[2.0105000000E+04, 1.4825784298E+01, 5.6762601192E+00, 3.0642808689E+00, 1.7544991308E+00, 8.2360383555E-01],
	[2.0110000000E+04, 1.4831318202E+01, 5.6761402988E+00, 3.0667532630E+00, 1.7553754642E+00, 8.2369657220E-01],
	[2.0115000000E+04, 1.4836852795E+01, 5.6760205106E+00, 3.0692270362E+00, 1.7562517719E+00, 8.2378926504E-01],
	[2.0120000000E+04, 1.4842388077E+01, 5.6759007548E+00, 3.0717021889E+00, 1.7571280538E+00, 8.2388191407E-01],
	[2.0125000000E+04, 1.4847924048E+01, 5.6757810312E+00, 3.0741787215E+00, 1.7580043096E+00, 8.2397451931E-01],
	[2.0130000000E+04, 1.4853460708E+01, 5.6756613399E+00, 3.0766566345E+00, 1.7588805391E+00, 8.2406708078E-01],
	[2.0135000000E+04, 1.4858998057E+01, 5.6755416809E+00, 3.0791359282E+00, 1.7597567420E+00, 8.2415959848E-01],
	[2.0140000000E+04, 1.4864536094E+01, 5.6754220540E+00, 3.0816166032E+00, 1.7606329182E+00, 8.2425207242E-01],
	[2.0145000000E+04, 1.4870074820E+01, 5.6753024594E+00, 3.0840986597E+00, 1.7615090673E+00, 8.2434450262E-01],
	[2.0150000000E+04, 1.4875614235E+01, 5.6751828970E+00, 3.0865820984E+00, 1.7623851892E+00, 8.2443688909E-01],
	[2.0155000000E+04, 1.4881154337E+01, 5.6750633668E+00, 3.0890669195E+00, 1.7632612837E+00, 8.2452923183E-01],
	[2.0160000000E+04, 1.4886695128E+01, 5.6749438688E+00, 3.0915531235E+00, 1.7641373504E+00, 8.2462153088E-01],
	[2.0165000000E+04, 1.4892236608E+01, 5.6748244029E+00, 3.0940407109E+00, 1.7650133892E+00, 8.2471378622E-01],
	[2.0170000000E+04, 1.4897778775E+01, 5.6747049691E+00, 3.0965296820E+00, 1.7658893999E+00, 8.2480599788E-01],
	[2.0175000000E+04, 1.4903321631E+01, 5.6745855674E+00, 3.0990200373E+00, 1.7667653821E+00, 8.2489816587E-01],
	[2.0180000000E+04, 1.4908865174E+01, 5.6744661979E+00, 3.1015117772E+00, 1.7676413357E+00, 8.2499029021E-01],
	[2.0185000000E+04, 1.4914409406E+01, 5.6743468604E+00, 3.1040049021E+00, 1.7685172605E+00, 8.2508237089E-01],
	[2.0190000000E+04, 1.4919954325E+01, 5.6742275550E+00, 3.1064994125E+00, 1.7693931562E+00, 8.2517440794E-01],
	[2.0195000000E+04, 1.4925499932E+01, 5.6741082816E+00, 3.1089953088E+00, 1.7702690226E+00, 8.2526640136E-01],
	[2.0200000000E+04, 1.4931046227E+01, 5.6739890403E+00, 3.1114925914E+00, 1.7711448595E+00, 8.2535835118E-01],
	[2.0205000000E+04, 1.4936593209E+01, 5.6738698310E+00, 3.1139912608E+00, 1.7720206666E+00, 8.2545025739E-01],
	[2.0210000000E+04, 1.4942140878E+01, 5.6737506537E+00, 3.1164913173E+00, 1.7728964437E+00, 8.2554212002E-01],
	[2.0215000000E+04, 1.4947689235E+01, 5.6736315084E+00, 3.1189927615E+00, 1.7737721906E+00, 8.2563393907E-01],
	[2.0220000000E+04, 1.4953238280E+01, 5.6735123950E+00, 3.1214955936E+00, 1.7746479070E+00, 8.2572571456E-01],
	[2.0225000000E+04, 1.4958788011E+01, 5.6733933136E+00, 3.1239998142E+00, 1.7755235927E+00, 8.2581744650E-01],
	[2.0230000000E+04, 1.4964338430E+01, 5.6732742641E+00, 3.1265054237E+00, 1.7763992476E+00, 8.2590913490E-01],
	[2.0235000000E+04, 1.4969889536E+01, 5.6731552466E+00, 3.1290124224E+00, 1.7772748713E+00, 8.2600077978E-01],
	[2.0240000000E+04, 1.4975441328E+01, 5.6730362609E+00, 3.1315208109E+00, 1.7781504636E+00, 8.2609238114E-01],
	[2.0245000000E+04, 1.4980993808E+01, 5.6729173071E+00, 3.1340305896E+00, 1.7790260243E+00, 8.2618393900E-01],
	[2.0250000000E+04, 1.4986546974E+01, 5.6727983852E+00, 3.1365417588E+00, 1.7799015533E+00, 8.2627545337E-01],
	[2.0255000000E+04, 1.4992100827E+01, 5.6726794952E+00, 3.1390543190E+00, 1.7807770501E+00, 8.2636692426E-01],
	[2.0260000000E+04, 1.4997655367E+01, 5.6725606370E+00, 3.1415682707E+00, 1.7816525147E+00, 8.2645835169E-01],
	[2.0265000000E+04, 1.5003210593E+01, 5.6724418106E+00, 3.1440836142E+00, 1.7825279468E+00, 8.2654973567E-01],
	[2.0270000000E+04, 1.5008766506E+01, 5.6723230160E+00, 3.1466003500E+00, 1.7834033462E+00, 8.2664107621E-01],
	[2.0275000000E+04, 1.5014323105E+01, 5.6722042532E+00, 3.1491184786E+00, 1.7842787126E+00, 8.2673237332E-01],
	[2.0280000000E+04, 1.5019880390E+01, 5.6720855221E+00, 3.1516380002E+00, 1.7851540458E+00, 8.2682362702E-01],
	[2.0285000000E+04, 1.5025438362E+01, 5.6719668229E+00, 3.1541589155E+00, 1.7860293456E+00, 8.2691483731E-01],
	[2.0290000000E+04, 1.5030997019E+01, 5.6718481553E+00, 3.1566812247E+00, 1.7869046118E+00, 8.2700600421E-01],
	[2.0295000000E+04, 1.5036556363E+01, 5.6717295195E+00, 3.1592049283E+00, 1.7877798441E+00, 8.2709712774E-01],
	[2.0300000000E+04, 1.5042116392E+01, 5.6716109154E+00, 3.1617300268E+00, 1.7886550424E+00, 8.2718820790E-01],
	[2.0305000000E+04, 1.5047677108E+01, 5.6714923429E+00, 3.1642565206E+00, 1.7895302063E+00, 8.2727924471E-01],
	[2.0310000000E+04, 1.5053238509E+01, 5.6713738022E+00, 3.1667844100E+00, 1.7904053357E+00, 8.2737023818E-01],
	[2.0315000000E+04, 1.5058800596E+01, 5.6712552931E+00, 3.1693136956E+00, 1.7912804303E+00, 8.2746118832E-01],
	[2.0320000000E+04, 1.5064363369E+01, 5.6711368156E+00, 3.1718443778E+00, 1.7921554899E+00, 8.2755209514E-01],
	[2.0325000000E+04, 1.5069926827E+01, 5.6710183698E+00, 3.1743764569E+00, 1.7930305143E+00, 8.2764295867E-01],
	[2.0330000000E+04, 1.5075490970E+01, 5.6708999555E+00, 3.1769099334E+00, 1.7939055032E+00, 8.2773377890E-01],
	[2.0335000000E+04, 1.5081055799E+01, 5.6707815729E+00, 3.1794448078E+00, 1.7947804565E+00, 8.2782455586E-01],
	[2.0340000000E+04, 1.5086621313E+01, 5.6706632218E+00, 3.1819810804E+00, 1.7956553739E+00, 8.2791528955E-01],
	[2.0345000000E+04, 1.5092187512E+01, 5.6705449023E+00, 3.1845187518E+00, 1.7965302552E+00, 8.2800597999E-01],
	[2.0350000000E+04, 1.5097754397E+01, 5.6704266144E+00, 3.1870578222E+00, 1.7974051002E+00, 8.2809662720E-01],
	[2.0355000000E+04, 1.5103321966E+01, 5.6703083579E+00, 3.1895982922E+00, 1.7982799085E+00, 8.2818723117E-01],
	[2.0360000000E+04, 1.5108890221E+01, 5.6701901330E+00, 3.1921401621E+00, 1.7991546801E+00, 8.2827779193E-01],
	[2.0365000000E+04, 1.5114459160E+01, 5.6700719396E+00, 3.1946834325E+00, 1.8000294147E+00, 8.2836830950E-01],
	[2.0370000000E+04, 1.5120028784E+01, 5.6699537776E+00, 3.1972281036E+00, 1.8009041120E+00, 8.2845878387E-01],
	[2.0375000000E+04, 1.5125599093E+01, 5.6698356471E+00, 3.1997741760E+00, 1.8017787719E+00, 8.2854921507E-01],
	[2.0380000000E+04, 1.5131170086E+01, 5.6697175481E+00, 3.2023216501E+00, 1.8026533941E+00, 8.2863960311E-01],
	[2.0385000000E+04, 1.5136741764E+01, 5.6695994804E+00, 3.2048705263E+00, 1.8035279784E+00, 8.2872994799E-01],
	[2.0390000000E+04, 1.5142339389E+01, 5.6694858080E+00, 3.2074208051E+00, 1.8044033253E+00, 8.2882024974E-01],
	[2.0395000000E+04, 1.5147940756E+01, 5.6693726916E+00, 3.2099724868E+00, 1.8052787315E+00, 8.2891050837E-01],
	[2.0400000000E+04, 1.5153542822E+01, 5.6692596052E+00, 3.2125255718E+00, 1.8061541004E+00, 8.2900072388E-01],
	[2.0405000000E+04, 1.5159145586E+01, 5.6691465488E+00, 3.2150800607E+00, 1.8070294317E+00, 8.2909089630E-01],
	[2.0410000000E+04, 1.5164749048E+01, 5.6690335223E+00, 3.2176359539E+00, 1.8079047253E+00, 8.2918102563E-01],
	[2.0415000000E+04, 1.5170353207E+01, 5.6689205257E+00, 3.2201932517E+00, 1.8087799808E+00, 8.2927111189E-01],
	[2.0420000000E+04, 1.5175958065E+01, 5.6688075591E+00, 3.2227519546E+00, 1.8096551981E+00, 8.2936115509E-01],
	[2.0425000000E+04, 1.5181563621E+01, 5.6686946224E+00, 3.2253120630E+00, 1.8105303770E+00, 8.2945115525E-01],
	[2.0430000000E+04, 1.5187169874E+01, 5.6685817156E+00, 3.2278735774E+00, 1.8114055172E+00, 8.2954111237E-01],
	[2.0435000000E+04, 1.5192776825E+01, 5.6684688387E+00, 3.2304364981E+00, 1.8122806186E+00, 8.2963102647E-01],
	[2.0440000000E+04, 1.5198384473E+01, 5.6683559916E+00, 3.2330008257E+00, 1.8131556808E+00, 8.2972089756E-01],
	[2.0445000000E+04, 1.5203992819E+01, 5.6682431743E+00, 3.2355665605E+00, 1.8140307036E+00, 8.2981072566E-01],
	[2.0450000000E+04, 1.5209601862E+01, 5.6681303869E+00, 3.2381337029E+00, 1.8149056870E+00, 8.2990051078E-01],
	[2.0455000000E+04, 1.5215211602E+01, 5.6680176294E+00, 3.2407022535E+00, 1.8157806305E+00, 8.2999025293E-01],
	[2.0460000000E+04, 1.5220822040E+01, 5.6679049016E+00, 3.2432722125E+00, 1.8166555341E+00, 8.3007995213E-01],
	[2.0465000000E+04, 1.5226433175E+01, 5.6677922036E+00, 3.2458435805E+00, 1.8175303974E+00, 8.3016960838E-01],
	[2.0470000000E+04, 1.5232045007E+01, 5.6676795353E+00, 3.2484163579E+00, 1.8184052203E+00, 8.3025922170E-01],
	[2.0475000000E+04, 1.5237657535E+01, 5.6675668969E+00, 3.2509905451E+00, 1.8192800025E+00, 8.3034879211E-01],
	[2.0480000000E+04, 1.5243270761E+01, 5.6674542881E+00, 3.2535661425E+00, 1.8201547439E+00, 8.3043831962E-01],
	[2.0485000000E+04, 1.5248884683E+01, 5.6673417091E+00, 3.2561431505E+00, 1.8210294441E+00, 8.3052780424E-01],
	[2.0490000000E+04, 1.5254499303E+01, 5.6672291598E+00, 3.2587215696E+00, 1.8219041030E+00, 8.3061724598E-01],
	[2.0495000000E+04, 1.5260114618E+01, 5.6671166402E+00, 3.2613014003E+00, 1.8227787204E+00, 8.3070664486E-01],
	[2.0500000000E+04, 1.5265730631E+01, 5.6670041503E+00, 3.2638826428E+00, 1.8236532960E+00, 8.3079600088E-01],
	[2.0505000000E+04, 1.5271347339E+01, 5.6668916901E+00, 3.2664652978E+00, 1.8245278297E+00, 8.3088531408E-01],
	[2.0510000000E+04, 1.5276964745E+01, 5.6667792595E+00, 3.2690493655E+00, 1.8254023211E+00, 8.3097458445E-01],
	[2.0515000000E+04, 1.5282582846E+01, 5.6666668585E+00, 3.2716348465E+00, 1.8262767702E+00, 8.3106381201E-01],
	[2.0520000000E+04, 1.5288201644E+01, 5.6665544872E+00, 3.2742217411E+00, 1.8271511766E+00, 8.3115299677E-01],
	[2.0525000000E+04, 1.5293821137E+01, 5.6664421454E+00, 3.2768100498E+00, 1.8280255401E+00, 8.3124213875E-01],
	[2.0530000000E+04, 1.5299441327E+01, 5.6663298333E+00, 3.2793997730E+00, 1.8288998606E+00, 8.3133123796E-01],
	[2.0535000000E+04, 1.5305062213E+01, 5.6662175507E+00, 3.2819909111E+00, 1.8297741377E+00, 8.3142029441E-01],
	[2.0540000000E+04, 1.5310683794E+01, 5.6661052977E+00, 3.2845834646E+00, 1.8306483714E+00, 8.3150930813E-01],
	[2.0545000000E+04, 1.5316306072E+01, 5.6659930742E+00, 3.2871774338E+00, 1.8315225613E+00, 8.3159827911E-01],
	[2.0550000000E+04, 1.5321929045E+01, 5.6658808803E+00, 3.2897728193E+00, 1.8323967073E+00, 8.3168720737E-01],
	[2.0555000000E+04, 1.5327552713E+01, 5.6657687158E+00, 3.2923696214E+00, 1.8332708091E+00, 8.3177609293E-01],
	[2.0560000000E+04, 1.5333177078E+01, 5.6656565809E+00, 3.2949678406E+00, 1.8341448665E+00, 8.3186493581E-01],
	[2.0565000000E+04, 1.5338802137E+01, 5.6655444755E+00, 3.2975674773E+00, 1.8350188793E+00, 8.3195373600E-01],
	[2.0570000000E+04, 1.5344427892E+01, 5.6654323995E+00, 3.3001685320E+00, 1.8358928473E+00, 8.3204249354E-01],
	[2.0575000000E+04, 1.5350054342E+01, 5.6653203530E+00, 3.3027710049E+00, 1.8367667703E+00, 8.3213120842E-01],
	[2.0580000000E+04, 1.5355681488E+01, 5.6652083359E+00, 3.3053748967E+00, 1.8376406480E+00, 8.3221988067E-01],
	[2.0585000000E+04, 1.5361309329E+01, 5.6650963483E+00, 3.3079802077E+00, 1.8385144802E+00, 8.3230851030E-01],
	[2.0590000000E+04, 1.5366937864E+01, 5.6649843900E+00, 3.3105869383E+00, 1.8393882668E+00, 8.3239709732E-01],
	[2.0595000000E+04, 1.5372567095E+01, 5.6648724612E+00, 3.3131950890E+00, 1.8402620074E+00, 8.3248564174E-01],
	[2.0600000000E+04, 1.5378197020E+01, 5.6647605617E+00, 3.3158046602E+00, 1.8411357019E+00, 8.3257414357E-01],
	[2.0605000000E+04, 1.5383827641E+01, 5.6646486916E+00, 3.3184156523E+00, 1.8420093501E+00, 8.3266260283E-01],
	[2.0610000000E+04, 1.5389458956E+01, 5.6645368509E+00, 3.3210280658E+00, 1.8428829517E+00, 8.3275101952E-01],
	[2.0615000000E+04, 1.5395090965E+01, 5.6644250395E+00, 3.3236419010E+00, 1.8437565065E+00, 8.3283939366E-01],
	[2.0620000000E+04, 1.5400723669E+01, 5.6643132574E+00, 3.3262571585E+00, 1.8446300144E+00, 8.3292772526E-01],
	[2.0625000000E+04, 1.5406357068E+01, 5.6642015046E+00, 3.3288738386E+00, 1.8455034750E+00, 8.3301601433E-01],
	[2.0630000000E+04, 1.5411991161E+01, 5.6640897811E+00, 3.3314919418E+00, 1.8463768882E+00, 8.3310426089E-01],
	[2.0635000000E+04, 1.5417625948E+01, 5.6639780869E+00, 3.3341114684E+00, 1.8472502538E+00, 8.3319246494E-01],
	[2.0640000000E+04, 1.5423261430E+01, 5.6638664220E+00, 3.3367324190E+00, 1.8481235715E+00, 8.3328062649E-01],
	[2.0645000000E+04, 1.5428897605E+01, 5.6637547863E+00, 3.3393547940E+00, 1.8489968412E+00, 8.3336874557E-01],
	[2.0650000000E+04, 1.5434534475E+01, 5.6636431798E+00, 3.3419785937E+00, 1.8498700626E+00, 8.3345682217E-01],
	[2.0655000000E+04, 1.5440172038E+01, 5.6635316026E+00, 3.3446038186E+00, 1.8507432355E+00, 8.3354485632E-01],
	[2.0660000000E+04, 1.5445810296E+01, 5.6634200545E+00, 3.3472304692E+00, 1.8516163597E+00, 8.3363284802E-01],
	[2.0665000000E+04, 1.5451449247E+01, 5.6633085357E+00, 3.3498585458E+00, 1.8524894349E+00, 8.3372079729E-01],
	[2.0670000000E+04, 1.5457088892E+01, 5.6631970460E+00, 3.3524880490E+00, 1.8533624610E+00, 8.3380870414E-01],
	[2.0675000000E+04, 1.5462729231E+01, 5.6630855855E+00, 3.3551189790E+00, 1.8542354378E+00, 8.3389656858E-01],
	[2.0680000000E+04, 1.5468370263E+01, 5.6629741541E+00, 3.3577513365E+00, 1.8551083650E+00, 8.3398439062E-01],
	[2.0685000000E+04, 1.5474011989E+01, 5.6628627519E+00, 3.3603851217E+00, 1.8559812424E+00, 8.3407217027E-01],
	[2.0690000000E+04, 1.5479654408E+01, 5.6627513788E+00, 3.3630203351E+00, 1.8568540698E+00, 8.3415990756E-01],
	[2.0695000000E+04, 1.5485297520E+01, 5.6626400347E+00, 3.3656569771E+00, 1.8577268470E+00, 8.3424760247E-01],
	[2.0700000000E+04, 1.5490941325E+01, 5.6625287198E+00, 3.3682950482E+00, 1.8585995738E+00, 8.3433525505E-01],
	[2.0705000000E+04, 1.5496585824E+01, 5.6624174339E+00, 3.3709345488E+00, 1.8594722499E+00, 8.3442286528E-01],
	[2.0710000000E+04, 1.5502231016E+01, 5.6623061771E+00, 3.3735754794E+00, 1.8603448752E+00, 8.3451043319E-01],
	[2.0715000000E+04, 1.5507884176E+01, 5.6621961850E+00, 3.3762178403E+00, 1.8612176877E+00, 8.3459795878E-01],
	[2.0720000000E+04, 1.5513559123E+01, 5.6620898017E+00, 3.3788616319E+00, 1.8620911404E+00, 8.3468544207E-01],
	[2.0725000000E+04, 1.5519234776E+01, 5.6619834461E+00, 3.3815068548E+00, 1.8629645428E+00, 8.3477288308E-01],
	[2.0730000000E+04, 1.5524911136E+01, 5.6618771182E+00, 3.3841535094E+00, 1.8638378947E+00, 8.3486028181E-01],
	[2.0735000000E+04, 1.5530588202E+01, 5.6617708179E+00, 3.3868015960E+00, 1.8647111959E+00, 8.3494763827E-01],
	[2.0740000000E+04, 1.5536265974E+01, 5.6616645452E+00, 3.3894511151E+00, 1.8655844463E+00, 8.3503495248E-01],
	[2.0745000000E+04, 1.5541944453E+01, 5.6615583001E+00, 3.3921020671E+00, 1.8664576456E+00, 8.3512222446E-01],
	[2.0750000000E+04, 1.5547623639E+01, 5.6614520826E+00, 3.3947544525E+00, 1.8673307935E+00, 8.3520945420E-01],
	[2.0755000000E+04, 1.5553303530E+01, 5.6613458927E+00, 3.3974082716E+00, 1.8682038899E+00, 8.3529664173E-01],
	[2.0760000000E+04, 1.5558984127E+01, 5.6612397304E+00, 3.4000635250E+00, 1.8690769346E+00, 8.3538378706E-01],
	[2.0765000000E+04, 1.5564665431E+01, 5.6611335957E+00, 3.4027202130E+00, 1.8699499274E+00, 8.3547089019E-01],
	[2.0770000000E+04, 1.5570347440E+01, 5.6610274884E+00, 3.4053783361E+00, 1.8708228680E+00, 8.3555795115E-01],
	[2.0775000000E+04, 1.5576030155E+01, 5.6609214087E+00, 3.4080378947E+00, 1.8716957562E+00, 8.3564496994E-01],
	[2.0780000000E+04, 1.5581713576E+01, 5.6608153566E+00, 3.4106988893E+00, 1.8725685919E+00, 8.3573194658E-01],
	[2.0785000000E+04, 1.5587397703E+01, 5.6607093319E+00, 3.4133613202E+00, 1.8734413748E+00, 8.3581888108E-01],
	[2.0790000000E+04, 1.5593082535E+01, 5.6606033347E+00, 3.4160251879E+00, 1.8743141046E+00, 8.3590577345E-01],
	[2.0795000000E+04, 1.5598768073E+01, 5.6604973650E+00, 3.4186904928E+00, 1.8751867813E+00, 8.3599262371E-01],
	[2.0800000000E+04, 1.5604454316E+01, 5.6603914227E+00, 3.4213572353E+00, 1.8760594046E+00, 8.3607943186E-01],
	[2.0805000000E+04, 1.5610141265E+01, 5.6602855079E+00, 3.4240254160E+00, 1.8769319742E+00, 8.3616619792E-01],
	[2.0810000000E+04, 1.5615828919E+01, 5.6601796205E+00, 3.4266950351E+00, 1.8778044900E+00, 8.3625292190E-01],
	[2.0815000000E+04, 1.5621517278E+01, 5.6600737606E+00, 3.4293660932E+00, 1.8786769517E+00, 8.3633960381E-01],
	[2.0820000000E+04, 1.5627206342E+01, 5.6599679280E+00, 3.4320385906E+00, 1.8795493592E+00, 8.3642624367E-01],
	[2.0825000000E+04, 1.5632896111E+01, 5.6598621228E+00, 3.4347125278E+00, 1.8804217122E+00, 8.3651284149E-01],
	[2.0830000000E+04, 1.5638586585E+01, 5.6597563451E+00, 3.4373879053E+00, 1.8812940105E+00, 8.3659939729E-01],
	[2.0835000000E+04, 1.5644277764E+01, 5.6596505946E+00, 3.4400647234E+00, 1.8821662539E+00, 8.3668591106E-01],
	[2.0840000000E+04, 1.5649969647E+01, 5.6595448716E+00, 3.4427429826E+00, 1.8830384423E+00, 8.3677238284E-01],
	[2.0845000000E+04, 1.5655662236E+01, 5.6594391758E+00, 3.4454226833E+00, 1.8839105753E+00, 8.3685881262E-01],
	[2.0850000000E+04, 1.5661355529E+01, 5.6593335074E+00, 3.4481038260E+00, 1.8847826528E+00, 8.3694520043E-01],
	[2.0855000000E+04, 1.5667049526E+01, 5.6592278663E+00, 3.4507864110E+00, 1.8856546746E+00, 8.3703154627E-01],
	[2.0860000000E+04, 1.5672744228E+01, 5.6591222525E+00, 3.4534704388E+00, 1.8865266405E+00, 8.3711785016E-01],
	[2.0865000000E+04, 1.5678439634E+01, 5.6590166660E+00, 3.4561559099E+00, 1.8873985503E+00, 8.3720411211E-01],
	[2.0870000000E+04, 1.5684135745E+01, 5.6589111067E+00, 3.4588428246E+00, 1.8882704037E+00, 8.3729033214E-01],
	[2.0875000000E+04, 1.5689832560E+01, 5.6588055747E+00, 3.4615311834E+00, 1.8891422005E+00, 8.3737651025E-01],
	[2.0880000000E+04, 1.5695530079E+01, 5.6587000699E+00, 3.4642209867E+00, 1.8900139406E+00, 8.3746264645E-01],
	[2.0885000000E+04, 1.5701228302E+01, 5.6585945924E+00, 3.4669122350E+00, 1.8908856237E+00, 8.3754874077E-01],
	[2.0890000000E+04, 1.5706927229E+01, 5.6584891421E+00, 3.4696049286E+00, 1.8917572496E+00, 8.3763479322E-01],
	[2.0895000000E+04, 1.5712626859E+01, 5.6583837190E+00, 3.4722990681E+00, 1.8926288182E+00, 8.3772080380E-01],
	[2.0900000000E+04, 1.5718327194E+01, 5.6582783230E+00, 3.4749946538E+00, 1.8935003292E+00, 8.3780677253E-01],
	[2.0905000000E+04, 1.5724028232E+01, 5.6581729543E+00, 3.4776916862E+00, 1.8943717823E+00, 8.3789269943E-01],
	[2.0910000000E+04, 1.5729729974E+01, 5.6580676127E+00, 3.4803901656E+00, 1.8952431775E+00, 8.3797858450E-01],
	[2.0915000000E+04, 1.5735432420E+01, 5.6579622982E+00, 3.4830900926E+00, 1.8961145144E+00, 8.3806442776E-01],
	[2.0920000000E+04, 1.5741135569E+01, 5.6578570109E+00, 3.4857914676E+00, 1.8969857930E+00, 8.3815022922E-01],
	[2.0925000000E+04, 1.5746839421E+01, 5.6577517507E+00, 3.4884942909E+00, 1.8978570129E+00, 8.3823598890E-01],
	[2.0930000000E+04, 1.5752543976E+01, 5.6576465176E+00, 3.4911985631E+00, 1.8987281740E+00, 8.3832170681E-01],
	[2.0935000000E+04, 1.5758249235E+01, 5.6575413116E+00, 3.4939042845E+00, 1.8995992760E+00, 8.3840738295E-01],
	[2.0940000000E+04, 1.5763955197E+01, 5.6574361327E+00, 3.4966114556E+00, 1.9004703189E+00, 8.3849301735E-01],
	[2.0945000000E+04, 1.5769661862E+01, 5.6573309808E+00, 3.4993200768E+00, 1.9013413022E+00, 8.3857861002E-01],
	[2.0950000000E+04, 1.5775369230E+01, 5.6572258560E+00, 3.5020301485E+00, 1.9022122259E+00, 8.3866416097E-01],
	[2.0955000000E+04, 1.5781077301E+01, 5.6571207583E+00, 3.5047416712E+00, 1.9030830898E+00, 8.3874967020E-01],
	[2.0960000000E+04, 1.5786786075E+01, 5.6570156875E+00, 3.5074546453E+00, 1.9039538936E+00, 8.3883513775E-01],
	[2.0965000000E+04, 1.5792495551E+01, 5.6569106438E+00, 3.5101690712E+00, 1.9048246371E+00, 8.3892056361E-01],
	[2.0970000000E+04, 1.5798205731E+01, 5.6568056271E+00, 3.5128849494E+00, 1.9056953202E+00, 8.3900594781E-01],
	[2.0975000000E+04, 1.5803916612E+01, 5.6567006374E+00, 3.5156022803E+00, 1.9065659426E+00, 8.3909129035E-01],
	[2.0980000000E+04, 1.5809628196E+01, 5.6565956746E+00, 3.5183210643E+00, 1.9074365041E+00, 8.3917659125E-01],
	[2.0985000000E+04, 1.5815340483E+01, 5.6564907388E+00, 3.5210413018E+00, 1.9083070045E+00, 8.3926185053E-01],
	[2.0990000000E+04, 1.5821053472E+01, 5.6563858299E+00, 3.5237629933E+00, 1.9091774437E+00, 8.3934706818E-01],
	[2.0995000000E+04, 1.5826767163E+01, 5.6562809480E+00, 3.5264861392E+00, 1.9100478213E+00, 8.3943224424E-01],
	[2.1000000000E+04, 1.5832481556E+01, 5.6561760930E+00, 3.5292107400E+00, 1.9109181372E+00, 8.3951737871E-01],
	[2.1005000000E+04, 1.5838196652E+01, 5.6560712649E+00, 3.5319367960E+00, 1.9117883913E+00, 8.3960247160E-01],
	[2.1010000000E+04, 1.5843912449E+01, 5.6559664637E+00, 3.5346643077E+00, 1.9126585832E+00, 8.3968752292E-01],
	[2.1015000000E+04, 1.5849628949E+01, 5.6558616893E+00, 3.5373932756E+00, 1.9135287129E+00, 8.3977253270E-01],
	[2.1020000000E+04, 1.5855346150E+01, 5.6557569419E+00, 3.5401237000E+00, 1.9143987800E+00, 8.3985750095E-01],
	[2.1025000000E+04, 1.5861064053E+01, 5.6556522213E+00, 3.5428555814E+00, 1.9152687844E+00, 8.3994242767E-01],
	[2.1030000000E+04, 1.5866782658E+01, 5.6555475275E+00, 3.5455889203E+00, 1.9161387259E+00, 8.4002731288E-01],
	[2.1035000000E+04, 1.5872501964E+01, 5.6554428605E+00, 3.5483237169E+00, 1.9170086043E+00, 8.4011215660E-01],
	[2.1040000000E+04, 1.5878221972E+01, 5.6553382204E+00, 3.5510599719E+00, 1.9178784193E+00, 8.4019695884E-01],
	[2.1045000000E+04, 1.5883942681E+01, 5.6552336070E+00, 3.5537976856E+00, 1.9187481709E+00, 8.4028171960E-01],
	[2.1050000000E+04, 1.5889680122E+01, 5.6551316960E+00, 3.5565368584E+00, 1.9196184009E+00, 8.4036643891E-01],
	[2.1055000000E+04, 1.5895430666E+01, 5.6550318788E+00, 3.5592774908E+00, 1.9204889872E+00, 8.4045111678E-01],
	[2.1060000000E+04, 1.5901181926E+01, 5.6549320871E+00, 3.5620195832E+00, 1.9213595105E+00, 8.4053575322E-01],
	[2.1065000000E+04, 1.5906933900E+01, 5.6548323208E+00, 3.5647631360E+00, 1.9222299708E+00, 8.4062034824E-01],
	[2.1070000000E+04, 1.5912686589E+01, 5.6547325800E+00, 3.5675081497E+00, 1.9231003677E+00, 8.4070490186E-01],
	[2.1075000000E+04, 1.5918439993E+01, 5.6546328646E+00, 3.5702546247E+00, 1.9239707012E+00, 8.4078941410E-01],
	[2.1080000000E+04, 1.5924194111E+01, 5.6545331746E+00, 3.5730025614E+00, 1.9248409710E+00, 8.4087388496E-01],
	[2.1085000000E+04, 1.5929948944E+01, 5.6544335100E+00, 3.5757519603E+00, 1.9257111768E+00, 8.4095831445E-01],
	[2.1090000000E+04, 1.5935704491E+01, 5.6543338708E+00, 3.5785028217E+00, 1.9265813186E+00, 8.4104270260E-01],
	[2.1095000000E+04, 1.5941460753E+01, 5.6542342570E+00, 3.5812551462E+00, 1.9274513960E+00, 8.4112704942E-01],
	[2.1100000000E+04, 1.5947217729E+01, 5.6541346685E+00, 3.5840089341E+00, 1.9283214090E+00, 8.4121135491E-01],
	[2.1105000000E+04, 1.5952975420E+01, 5.6540351054E+00, 3.5867641859E+00, 1.9291913573E+00, 8.4129561910E-01],
	[2.1110000000E+04, 1.5958733824E+01, 5.6539355676E+00, 3.5895209020E+00, 1.9300612406E+00, 8.4137984199E-01],
	[2.1115000000E+04, 1.5964492943E+01, 5.6538360551E+00, 3.5922790829E+00, 1.9309310589E+00, 8.4146402361E-01],
	[2.1120000000E+04, 1.5970252775E+01, 5.6537365680E+00, 3.5950387289E+00, 1.9318008118E+00, 8.4154816395E-01],
	[2.1125000000E+04, 1.5976013322E+01, 5.6536371061E+00, 3.5977998406E+00, 1.9326704993E+00, 8.4163226305E-01],
	[2.1130000000E+04, 1.5981774582E+01, 5.6535376696E+00, 3.6005624182E+00, 1.9335401210E+00, 8.4171632090E-01],
	[2.1135000000E+04, 1.5987536557E+01, 5.6534382583E+00, 3.6033264623E+00, 1.9344096769E+00, 8.4180033753E-01],
	[2.1140000000E+04, 1.5993299244E+01, 5.6533388723E+00, 3.6060919734E+00, 1.9352791666E+00, 8.4188431295E-01],
	[2.1145000000E+04, 1.5999062646E+01, 5.6532395115E+00, 3.6088589517E+00, 1.9361485900E+00, 8.4196824717E-01],
	[2.1150000000E+04, 1.6004826761E+01, 5.6531401760E+00, 3.6116273978E+00, 1.9370179470E+00, 8.4205214020E-01],
	[2.1155000000E+04, 1.6010591589E+01, 5.6530408657E+00, 3.6143973121E+00, 1.9378872373E+00, 8.4213599207E-01],
	[2.1160000000E+04, 1.6016357131E+01, 5.6529415806E+00, 3.6171686950E+00, 1.9387564606E+00, 8.4221980278E-01],
	[2.1165000000E+04, 1.6022123386E+01, 5.6528423207E+00, 3.6199415470E+00, 1.9396256169E+00, 8.4230357234E-01],
	[2.1170000000E+04, 1.6027890354E+01, 5.6527430860E+00, 3.6227158685E+00, 1.9404947059E+00, 8.4238730078E-01],
	[2.1175000000E+04, 1.6033658035E+01, 5.6526438765E+00, 3.6254916598E+00, 1.9413637274E+00, 8.4247098810E-01],
	[2.1180000000E+04, 1.6039426430E+01, 5.6525446921E+00, 3.6282689215E+00, 1.9422326812E+00, 8.4255463431E-01],
	[2.1185000000E+04, 1.6045195537E+01, 5.6524455329E+00, 3.6310476540E+00, 1.9431015671E+00, 8.4263823944E-01],
	[2.1190000000E+04, 1.6050965357E+01, 5.6523463988E+00, 3.6338278577E+00, 1.9439703849E+00, 8.4272180350E-01],
	[2.1195000000E+04, 1.6056735890E+01, 5.6522472899E+00, 3.6366095330E+00, 1.9448391345E+00, 8.4280532649E-01],
	[2.1200000000E+04, 1.6062507136E+01, 5.6521482060E+00, 3.6393926804E+00, 1.9457078156E+00, 8.4288880844E-01],
	[2.1205000000E+04, 1.6068279094E+01, 5.6520491473E+00, 3.6421773003E+00, 1.9465764280E+00, 8.4297224936E-01],
	[2.1210000000E+04, 1.6074051765E+01, 5.6519501137E+00, 3.6449633931E+00, 1.9474449715E+00, 8.4305564926E-01],
	[2.1215000000E+04, 1.6079825148E+01, 5.6518511051E+00, 3.6477509593E+00, 1.9483134460E+00, 8.4313900815E-01],
	[2.1220000000E+04, 1.6085599244E+01, 5.6517521216E+00, 3.6505399993E+00, 1.9491818512E+00, 8.4322232605E-01],
	[2.1225000000E+04, 1.6091374052E+01, 5.6516531632E+00, 3.6533305135E+00, 1.9500501870E+00, 8.4330560298E-01],
	[2.1230000000E+04, 1.6097149572E+01, 5.6515542298E+00, 3.6561225023E+00, 1.9509184530E+00, 8.4338883894E-01],
	[2.1235000000E+04, 1.6102925805E+01, 5.6514553214E+00, 3.6589159663E+00, 1.9517866493E+00, 8.4347203395E-01],
	[2.1240000000E+04, 1.6108702749E+01, 5.6513564381E+00, 3.6617109057E+00, 1.9526547755E+00, 8.4355518803E-01],
	[2.1245000000E+04, 1.6114480406E+01, 5.6512575797E+00, 3.6645073212E+00, 1.9535228314E+00, 8.4363830119E-01],
	[2.1250000000E+04, 1.6120258774E+01, 5.6511587463E+00, 3.6673052130E+00, 1.9543908170E+00, 8.4372137344E-01],
	[2.1255000000E+04, 1.6126037854E+01, 5.6510599380E+00, 3.6701045816E+00, 1.9552587318E+00, 8.4380440480E-01],
	[2.1260000000E+04, 1.6131817646E+01, 5.6509611546E+00, 3.6729054274E+00, 1.9561265759E+00, 8.4388739528E-01],
	[2.1265000000E+04, 1.6137598150E+01, 5.6508623961E+00, 3.6757077510E+00, 1.9569943489E+00, 8.4397034489E-01],
	[2.1270000000E+04, 1.6143379365E+01, 5.6507636626E+00, 3.6785115526E+00, 1.9578620507E+00, 8.4405325365E-01],
	[2.1275000000E+04, 1.6149161292E+01, 5.6506649540E+00, 3.6813168328E+00, 1.9587296811E+00, 8.4413612158E-01],
	[2.1280000000E+04, 1.6154943930E+01, 5.6505662703E+00, 3.6841235920E+00, 1.9595972399E+00, 8.4421894869E-01],
	[2.1285000000E+04, 1.6160727280E+01, 5.6504676116E+00, 3.6869318305E+00, 1.9604647269E+00, 8.4430173498E-01],
	[2.1290000000E+04, 1.6166511341E+01, 5.6503689777E+00, 3.6897415489E+00, 1.9613321419E+00, 8.4438448048E-01],
	[2.1295000000E+04, 1.6172296113E+01, 5.6502703688E+00, 3.6925527476E+00, 1.9621994847E+00, 8.4446718520E-01],
	[2.1300000000E+04, 1.6178081596E+01, 5.6501717847E+00, 3.6953654269E+00, 1.9630667551E+00, 8.4454984916E-01],
	[2.1305000000E+04, 1.6183867790E+01, 5.6500732254E+00, 3.6981795874E+00, 1.9639339529E+00, 8.4463247236E-01],
	[2.1310000000E+04, 1.6189654695E+01, 5.6499746910E+00, 3.7009952295E+00, 1.9648010780E+00, 8.4471505483E-01],
	[2.1315000000E+04, 1.6195442311E+01, 5.6498761814E+00, 3.7038123535E+00, 1.9656681301E+00, 8.4479759657E-01],
	[2.1320000000E+04, 1.6201230638E+01, 5.6497776967E+00, 3.7066309600E+00, 1.9665351090E+00, 8.4488009760E-01],
	[2.1325000000E+04, 1.6207019675E+01, 5.6496792368E+00, 3.7094510493E+00, 1.9674020146E+00, 8.4496255794E-01],
	[2.1330000000E+04, 1.6212809424E+01, 5.6495808016E+00, 3.7122726219E+00, 1.9682688466E+00, 8.4504497760E-01],
	[2.1335000000E+04, 1.6218599882E+01, 5.6494823913E+00, 3.7150956782E+00, 1.9691356049E+00, 8.4512735659E-01],
	[2.1340000000E+04, 1.6224391052E+01, 5.6493840057E+00, 3.7179202187E+00, 1.9700022893E+00, 8.4520969493E-01],
	[2.1345000000E+04, 1.6230182931E+01, 5.6492856449E+00, 3.7207462438E+00, 1.9708688995E+00, 8.4529199263E-01],
	[2.1350000000E+04, 1.6235975521E+01, 5.6491873088E+00, 3.7235737539E+00, 1.9717354355E+00, 8.4537424971E-01],
	[2.1355000000E+04, 1.6241768821E+01, 5.6490889975E+00, 3.7264027494E+00, 1.9726018969E+00, 8.4545646618E-01],
	[2.1360000000E+04, 1.6247562832E+01, 5.6489907109E+00, 3.7292332308E+00, 1.9734682836E+00, 8.4553864205E-01],
	[2.1365000000E+04, 1.6253357552E+01, 5.6488924490E+00, 3.7320651986E+00, 1.9743345955E+00, 8.4562077734E-01],
	[2.1370000000E+04, 1.6259152983E+01, 5.6487942118E+00, 3.7348986530E+00, 1.9752008322E+00, 8.4570287207E-01],
	[2.1375000000E+04, 1.6264949123E+01, 5.6486959993E+00, 3.7377335947E+00, 1.9760669937E+00, 8.4578492624E-01],
	[2.1380000000E+04, 1.6270745973E+01, 5.6485978115E+00, 3.7405700239E+00, 1.9769330797E+00, 8.4586693988E-01],
	[2.1385000000E+04, 1.6276543533E+01, 5.6484996484E+00, 3.7434079412E+00, 1.9777990901E+00, 8.4594891299E-01],
	[2.1390000000E+04, 1.6282364529E+01, 5.6484052376E+00, 3.7462473470E+00, 1.9786658177E+00, 8.4603084559E-01],
	[2.1395000000E+04, 1.6288192006E+01, 5.6483117949E+00, 3.7490882417E+00, 1.9795326713E+00, 8.4611273770E-01],
	[2.1400000000E+04, 1.6294020206E+01, 5.6482183756E+00, 3.7519306257E+00, 1.9803994499E+00, 8.4619458933E-01],
	[2.1405000000E+04, 1.6299849129E+01, 5.6481249797E+00, 3.7547744995E+00, 1.9812661533E+00, 8.4627640050E-01],
	[2.1410000000E+04, 1.6305678775E+01, 5.6480316072E+00, 3.7576198635E+00, 1.9821327813E+00, 8.4635817121E-01],
	[2.1415000000E+04, 1.6311509144E+01, 5.6479382579E+00, 3.7604667181E+00, 1.9829993338E+00, 8.4643990149E-01],
	[2.1420000000E+04, 1.6317340237E+01, 5.6478449321E+00, 3.7633150638E+00, 1.9838658105E+00, 8.4652159135E-01],
	[2.1425000000E+04, 1.6323172051E+01, 5.6477516295E+00, 3.7661649010E+00, 1.9847322112E+00, 8.4660324079E-01],
	[2.1430000000E+04, 1.6329004589E+01, 5.6476583502E+00, 3.7690162301E+00, 1.9855985359E+00, 8.4668484985E-01],
	[2.1435000000E+04, 1.6334837849E+01, 5.6475650943E+00, 3.7718690516E+00, 1.9864647841E+00, 8.4676641852E-01],
	[2.1440000000E+04, 1.6340671832E+01, 5.6474718616E+00, 3.7747233659E+00, 1.9873309559E+00, 8.4684794682E-01],
	[2.1445000000E+04, 1.6346506537E+01, 5.6473786523E+00, 3.7775791734E+00, 1.9881970510E+00, 8.4692943476E-01],
	[2.1450000000E+04, 1.6352341965E+01, 5.6472854661E+00, 3.7804364745E+00, 1.9890630691E+00, 8.4701088236E-01],
	[2.1455000000E+04, 1.6358178115E+01, 5.6471923033E+00, 3.7832952698E+00, 1.9899290102E+00, 8.4709228964E-01],
	[2.1460000000E+04, 1.6364014987E+01, 5.6470991637E+00, 3.7861555596E+00, 1.9907948740E+00, 8.4717365659E-01],
	[2.1465000000E+04, 1.6369852582E+01, 5.6470060473E+00, 3.7890173443E+00, 1.9916606604E+00, 8.4725498324E-01],
	[2.1470000000E+04, 1.6375690899E+01, 5.6469129542E+00, 3.7918806244E+00, 1.9925263690E+00, 8.4733626959E-01],
	[2.1475000000E+04, 1.6381529937E+01, 5.6468198842E+00, 3.7947454004E+00, 1.9933919999E+00, 8.4741751567E-01],
	[2.1480000000E+04, 1.6387369698E+01, 5.6467268375E+00, 3.7976116726E+00, 1.9942575527E+00, 8.4749872148E-01],
	[2.1485000000E+04, 1.6393210180E+01, 5.6466338139E+00, 3.8004794415E+00, 1.9951230273E+00, 8.4757988704E-01],
	[2.1490000000E+04, 1.6399051385E+01, 5.6465408135E+00, 3.8033487075E+00, 1.9959884236E+00, 8.4766101236E-01],
	[2.1495000000E+04, 1.6404893311E+01, 5.6464478363E+00, 3.8062194711E+00, 1.9968537412E+00, 8.4774209745E-01],
	[2.1500000000E+04, 1.6410735958E+01, 5.6463548823E+00, 3.8090917327E+00, 1.9977189800E+00, 8.4782314233E-01],
	[2.1505000000E+04, 1.6416579327E+01, 5.6462619514E+00, 3.8119654927E+00, 1.9985841399E+00, 8.4790414701E-01],
	[2.1510000000E+04, 1.6422423418E+01, 5.6461690436E+00, 3.8148407515E+00, 1.9994492207E+00, 8.4798511150E-01],
	[2.1515000000E+04, 1.6428268230E+01, 5.6460761589E+00, 3.8177175096E+00, 2.0003142221E+00, 8.4806603581E-01],
	[2.1520000000E+04, 1.6434113763E+01, 5.6459832974E+00, 3.8205957675E+00, 2.0011791440E+00, 8.4814691996E-01],
	[2.1525000000E+04, 1.6439960018E+01, 5.6458904590E+00, 3.8234755254E+00, 2.0020439861E+00, 8.4822776396E-01],
	[2.1530000000E+04, 1.6445806993E+01, 5.6457976436E+00, 3.8263567840E+00, 2.0029087484E+00, 8.4830856783E-01],
	[2.1535000000E+04, 1.6451654690E+01, 5.6457048513E+00, 3.8292395436E+00, 2.0037734306E+00, 8.4838933158E-01],
	[2.1540000000E+04, 1.6457503108E+01, 5.6456120821E+00, 3.8321238046E+00, 2.0046380325E+00, 8.4847005521E-01],
	[2.1545000000E+04, 1.6463352247E+01, 5.6455193360E+00, 3.8350095675E+00, 2.0055025540E+00, 8.4855073875E-01],
	[2.1550000000E+04, 1.6469202106E+01, 5.6454266129E+00, 3.8378968328E+00, 2.0063669949E+00, 8.4863138221E-01],
	[2.1555000000E+04, 1.6475052687E+01, 5.6453339128E+00, 3.8407856008E+00, 2.0072313549E+00, 8.4871198560E-01],
	[2.1560000000E+04, 1.6480903988E+01, 5.6452412357E+00, 3.8436758719E+00, 2.0080956339E+00, 8.4879254893E-01],
	[2.1565000000E+04, 1.6486756009E+01, 5.6451485817E+00, 3.8465676467E+00, 2.0089598317E+00, 8.4887307221E-01],
	[2.1570000000E+04, 1.6492608752E+01, 5.6450559507E+00, 3.8494609255E+00, 2.0098239481E+00, 8.4895355547E-01],
	[2.1575000000E+04, 1.6498462214E+01, 5.6449633426E+00, 3.8523557088E+00, 2.0106879830E+00, 8.4903399871E-01],
	[2.1580000000E+04, 1.6504316397E+01, 5.6448707575E+00, 3.8552519970E+00, 2.0115519361E+00, 8.4911440195E-01],
	[2.1585000000E+04, 1.6510171300E+01, 5.6447781954E+00, 3.8581497906E+00, 2.0124158073E+00, 8.4919476520E-01],
	[2.1590000000E+04, 1.6516026924E+01, 5.6446856563E+00, 3.8610490899E+00, 2.0132795964E+00, 8.4927508847E-01],
	[2.1595000000E+04, 1.6521883268E+01, 5.6445931401E+00, 3.8639498954E+00, 2.0141433032E+00, 8.4935537177E-01],
	[2.1600000000E+04, 1.6527740331E+01, 5.6445006468E+00, 3.8668522076E+00, 2.0150069275E+00, 8.4943561513E-01],
	[2.1605000000E+04, 1.6533598115E+01, 5.6444081764E+00, 3.8697560269E+00, 2.0158704691E+00, 8.4951581855E-01],
	[2.1610000000E+04, 1.6539456619E+01, 5.6443157290E+00, 3.8726613537E+00, 2.0167339278E+00, 8.4959598205E-01],
	[2.1615000000E+04, 1.6545315842E+01, 5.6442233045E+00, 3.8755681884E+00, 2.0175973036E+00, 8.4967610563E-01],
	[2.1620000000E+04, 1.6551175785E+01, 5.6441309028E+00, 3.8784765315E+00, 2.0184605961E+00, 8.4975618932E-01],
	[2.1625000000E+04, 1.6557036448E+01, 5.6440385241E+00, 3.8813863834E+00, 2.0193238052E+00, 8.4983623313E-01],
	[2.1630000000E+04, 1.6562897830E+01, 5.6439461682E+00, 3.8842977446E+00, 2.0201869307E+00, 8.4991623706E-01],
	[2.1635000000E+04, 1.6568759932E+01, 5.6438538351E+00, 3.8872106154E+00, 2.0210499725E+00, 8.4999620115E-01],
	[2.1640000000E+04, 1.6574622754E+01, 5.6437615249E+00, 3.8901249964E+00, 2.0219129303E+00, 8.5007612538E-01],
	[2.1645000000E+04, 1.6580486295E+01, 5.6436692376E+00, 3.8930408879E+00, 2.0227758040E+00, 8.5015600979E-01],
	[2.1650000000E+04, 1.6586350555E+01, 5.6435769730E+00, 3.8959582903E+00, 2.0236385934E+00, 8.5023585438E-01],
	[2.1655000000E+04, 1.6592215534E+01, 5.6434847313E+00, 3.8988772042E+00, 2.0245012982E+00, 8.5031565918E-01],
	[2.1660000000E+04, 1.6598081232E+01, 5.6433925124E+00, 3.9017976300E+00, 2.0253639184E+00, 8.5039542418E-01],
	[2.1665000000E+04, 1.6603947650E+01, 5.6433003163E+00, 3.9047195680E+00, 2.0262264538E+00, 8.5047514940E-01],
	[2.1670000000E+04, 1.6609814786E+01, 5.6432081429E+00, 3.9076430187E+00, 2.0270889041E+00, 8.5055483487E-01],
	[2.1675000000E+04, 1.6615682641E+01, 5.6431159923E+00, 3.9105679825E+00, 2.0279512691E+00, 8.5063448059E-01],
	[2.1680000000E+04, 1.6621551215E+01, 5.6430238645E+00, 3.9134944600E+00, 2.0288135488E+00, 8.5071408657E-01],
	[2.1685000000E+04, 1.6627420508E+01, 5.6429317595E+00, 3.9164224514E+00, 2.0296757429E+00, 8.5079365283E-01],
	[2.1690000000E+04, 1.6633290520E+01, 5.6428396771E+00, 3.9193519573E+00, 2.0305378512E+00, 8.5087317939E-01],
	[2.1695000000E+04, 1.6639161250E+01, 5.6427476175E+00, 3.9222829781E+00, 2.0313998736E+00, 8.5095266625E-01],
	[2.1700000000E+04, 1.6645032698E+01, 5.6426555806E+00, 3.9252155142E+00, 2.0322618098E+00, 8.5103211343E-01],
	[2.1705000000E+04, 1.6650904865E+01, 5.6425635665E+00, 3.9281495661E+00, 2.0331236597E+00, 8.5111152095E-01],
	[2.1710000000E+04, 1.6656777750E+01, 5.6424715750E+00, 3.9310851341E+00, 2.0339854232E+00, 8.5119088881E-01],
	[2.1715000000E+04, 1.6662651354E+01, 5.6423796062E+00, 3.9340222187E+00, 2.0348471000E+00, 8.5127021703E-01],
	[2.1720000000E+04, 1.6668525676E+01, 5.6422876600E+00, 3.9369608204E+00, 2.0357086899E+00, 8.5134950563E-01],
	[2.1725000000E+04, 1.6674400716E+01, 5.6421957366E+00, 3.9399009396E+00, 2.0365701928E+00, 8.5142875462E-01],
	[2.1730000000E+04, 1.6680276474E+01, 5.6421038357E+00, 3.9428425766E+00, 2.0374316085E+00, 8.5150796401E-01],
	[2.1735000000E+04, 1.6686179807E+01, 5.6420162870E+00, 3.9457857321E+00, 2.0382939027E+00, 8.5158713382E-01],
	[2.1740000000E+04, 1.6692085564E+01, 5.6419290327E+00, 3.9487304063E+00, 2.0391561713E+00, 8.5166626406E-01],
	[2.1745000000E+04, 1.6697992053E+01, 5.6418417997E+00, 3.9516765997E+00, 2.0400183534E+00, 8.5174535474E-01],
	[2.1750000000E+04, 1.6703899274E+01, 5.6417545882E+00, 3.9546243128E+00, 2.0408804488E+00, 8.5182440587E-01],
	[2.1755000000E+04, 1.6709807225E+01, 5.6416673981E+00, 3.9575735460E+00, 2.0417424573E+00, 8.5190341748E-01],
	[2.1760000000E+04, 1.6715715907E+01, 5.6415802293E+00, 3.9605242997E+00, 2.0426043788E+00, 8.5198238958E-01],
	[2.1765000000E+04, 1.6721625321E+01, 5.6414930819E+00, 3.9634765743E+00, 2.0434662130E+00, 8.5206132217E-01],
	[2.1770000000E+04, 1.6727535466E+01, 5.6414059559E+00, 3.9664303703E+00, 2.0443279598E+00, 8.5214021528E-01],
	[2.1775000000E+04, 1.6733446341E+01, 5.6413188512E+00, 3.9693856882E+00, 2.0451896191E+00, 8.5221906892E-01],
	[2.1780000000E+04, 1.6739357948E+01, 5.6412317679E+00, 3.9723425283E+00, 2.0460511905E+00, 8.5229788309E-01],
	[2.1785000000E+04, 1.6745270285E+01, 5.6411447059E+00, 3.9753008911E+00, 2.0469126740E+00, 8.5237665782E-01],
	[2.1790000000E+04, 1.6751183353E+01, 5.6410576652E+00, 3.9782607770E+00, 2.0477740693E+00, 8.5245539312E-01],
	[2.1795000000E+04, 1.6757097152E+01, 5.6409706459E+00, 3.9812221865E+00, 2.0486353764E+00, 8.5253408900E-01],
	[2.1800000000E+04, 1.6763011681E+01, 5.6408836478E+00, 3.9841851199E+00, 2.0494965949E+00, 8.5261274548E-01],
	[2.1805000000E+04, 1.6768926940E+01, 5.6407966711E+00, 3.9871495778E+00, 2.0503577248E+00, 8.5269136257E-01],
	[2.1810000000E+04, 1.6774842930E+01, 5.6407097156E+00, 3.9901155606E+00, 2.0512187659E+00, 8.5276994028E-01],
	[2.1815000000E+04, 1.6780759650E+01, 5.6406227814E+00, 3.9930830686E+00, 2.0520797180E+00, 8.5284847863E-01],
	[2.1820000000E+04, 1.6786677101E+01, 5.6405358685E+00, 3.9960521024E+00, 2.0529405808E+00, 8.5292697764E-01],
	[2.1825000000E+04, 1.6792595281E+01, 5.6404489768E+00, 3.9990226623E+00, 2.0538013543E+00, 8.5300543731E-01],
	[2.1830000000E+04, 1.6798514192E+01, 5.6403621063E+00, 4.0019947488E+00, 2.0546620383E+00, 8.5308385766E-01],
	[2.1835000000E+04, 1.6804433833E+01, 5.6402752571E+00, 4.0049683624E+00, 2.0555226325E+00, 8.5316223870E-01],
	[2.1840000000E+04, 1.6810354204E+01, 5.6401884291E+00, 4.0079435034E+00, 2.0563831368E+00, 8.5324058046E-01],
	[2.1845000000E+04, 1.6816275304E+01, 5.6401016223E+00, 4.0109201724E+00, 2.0572435511E+00, 8.5331888293E-01],
	[2.1850000000E+04, 1.6822197134E+01, 5.6400148368E+00, 4.0138983696E+00, 2.0581038751E+00, 8.5339714615E-01],
	[2.1855000000E+04, 1.6828119694E+01, 5.6399280724E+00, 4.0168780956E+00, 2.0589641087E+00, 8.5347537011E-01],
	[2.1860000000E+04, 1.6834042984E+01, 5.6398413292E+00, 4.0198593509E+00, 2.0598242517E+00, 8.5355355484E-01],
	[2.1865000000E+04, 1.6839967003E+01, 5.6397546071E+00, 4.0228421357E+00, 2.0606843039E+00, 8.5363170035E-01],
	[2.1870000000E+04, 1.6845891752E+01, 5.6396679063E+00, 4.0258264507E+00, 2.0615442652E+00, 8.5370980665E-01],
	[2.1875000000E+04, 1.6851817230E+01, 5.6395812266E+00, 4.0288122961E+00, 2.0624041353E+00, 8.5378787376E-01],
	[2.1880000000E+04, 1.6857743437E+01, 5.6394945680E+00, 4.0317996725E+00, 2.0632639142E+00, 8.5386590170E-01],
	[2.1885000000E+04, 1.6863670373E+01, 5.6394079305E+00, 4.0347885803E+00, 2.0641236016E+00, 8.5394389046E-01],
	[2.1890000000E+04, 1.6869598039E+01, 5.6393213142E+00, 4.0377790198E+00, 2.0649831973E+00, 8.5402184008E-01],
	[2.1895000000E+04, 1.6875526434E+01, 5.6392347190E+00, 4.0407709917E+00, 2.0658427013E+00, 8.5409975056E-01],
	[2.1900000000E+04, 1.6881455558E+01, 5.6391481449E+00, 4.0437644961E+00, 2.0667021132E+00, 8.5417762192E-01],
	[2.1905000000E+04, 1.6887385410E+01, 5.6390615919E+00, 4.0467595337E+00, 2.0675614330E+00, 8.5425545418E-01],
	[2.1910000000E+04, 1.6893315992E+01, 5.6389750600E+00, 4.0497561049E+00, 2.0684206604E+00, 8.5433324734E-01],
	[2.1915000000E+04, 1.6899247302E+01, 5.6388885491E+00, 4.0527542100E+00, 2.0692797953E+00, 8.5441100142E-01],
	[2.1920000000E+04, 1.6905179341E+01, 5.6388020593E+00, 4.0557538496E+00, 2.0701388375E+00, 8.5448871644E-01],
	[2.1925000000E+04, 1.6911112109E+01, 5.6387155905E+00, 4.0587550240E+00, 2.0709977869E+00, 8.5456639240E-01],
	[2.1930000000E+04, 1.6917045605E+01, 5.6386291428E+00, 4.0617577337E+00, 2.0718566432E+00, 8.5464402933E-01],
	[2.1935000000E+04, 1.6922979830E+01, 5.6385427162E+00, 4.0647619791E+00, 2.0727154064E+00, 8.5472162724E-01],
	[2.1940000000E+04, 1.6928914783E+01, 5.6384563105E+00, 4.0677677607E+00, 2.0735740761E+00, 8.5479918615E-01],
	[2.1945000000E+04, 1.6934850464E+01, 5.6383699259E+00, 4.0707750788E+00, 2.0744326523E+00, 8.5487670606E-01],
	[2.1950000000E+04, 1.6940786873E+01, 5.6382835623E+00, 4.0737839340E+00, 2.0752911348E+00, 8.5495418699E-01],
	[2.1955000000E+04, 1.6946724011E+01, 5.6381972196E+00, 4.0767943267E+00, 2.0761495234E+00, 8.5503162895E-01],
	[2.1960000000E+04, 1.6952661877E+01, 5.6381108980E+00, 4.0798062572E+00, 2.0770078179E+00, 8.5510903197E-01],
	[2.1965000000E+04, 1.6958600471E+01, 5.6380245973E+00, 4.0828197261E+00, 2.0778660182E+00, 8.5518639605E-01],
	[2.1970000000E+04, 1.6964539792E+01, 5.6379383176E+00, 4.0858347337E+00, 2.0787241241E+00, 8.5526372121E-01],
	[2.1975000000E+04, 1.6970479842E+01, 5.6378520588E+00, 4.0888512806E+00, 2.0795821353E+00, 8.5534100747E-01],
	[2.1980000000E+04, 1.6976420619E+01, 5.6377658210E+00, 4.0918693671E+00, 2.0804400519E+00, 8.5541825483E-01],
	[2.1985000000E+04, 1.6982362124E+01, 5.6376796041E+00, 4.0948889936E+00, 2.0812978735E+00, 8.5549546331E-01],
	[2.1990000000E+04, 1.6988304357E+01, 5.6375934081E+00, 4.0979101607E+00, 2.0821556000E+00, 8.5557263294E-01],
	[2.1995000000E+04, 1.6994247317E+01, 5.6375072331E+00, 4.1009328686E+00, 2.0830132313E+00, 8.5564976371E-01],
	[2.2000000000E+04, 1.7000191005E+01, 5.6374210789E+00, 4.1039571180E+00, 2.0838707671E+00, 8.5572685565E-01],
	[2.2005000000E+04, 1.7006135420E+01, 5.6373349457E+00, 4.1069829092E+00, 2.0847282074E+00, 8.5580390876E-01],
	[2.2010000000E+04, 1.7012080563E+01, 5.6372488333E+00, 4.1100102426E+00, 2.0855855518E+00, 8.5588092308E-01],
	[2.2015000000E+04, 1.7018026432E+01, 5.6371627418E+00, 4.1130391187E+00, 2.0864428003E+00, 8.5595789860E-01],
	[2.2020000000E+04, 1.7023973029E+01, 5.6370766712E+00, 4.1160695380E+00, 2.0872999527E+00, 8.5603483535E-01],
	[2.2025000000E+04, 1.7029920353E+01, 5.6369906214E+00, 4.1191015007E+00, 2.0881570088E+00, 8.5611173333E-01],
	[2.2030000000E+04, 1.7035868404E+01, 5.6369045925E+00, 4.1221350075E+00, 2.0890139685E+00, 8.5618859257E-01],
	[2.2035000000E+04, 1.7041817182E+01, 5.6368185844E+00, 4.1251700587E+00, 2.0898708315E+00, 8.5626541307E-01],
	[2.2040000000E+04, 1.7047766686E+01, 5.6367325971E+00, 4.1282066547E+00, 2.0907275977E+00, 8.5634219486E-01],
	[2.2045000000E+04, 1.7053716918E+01, 5.6366466307E+00, 4.1312447960E+00, 2.0915842670E+00, 8.5641893794E-01],
	[2.2050000000E+04, 1.7059667876E+01, 5.6365606850E+00, 4.1342844831E+00, 2.0924408391E+00, 8.5649564234E-01],
	[2.2055000000E+04, 1.7065619561E+01, 5.6364747602E+00, 4.1373257163E+00, 2.0932973140E+00, 8.5657230806E-01],
	[2.2060000000E+04, 1.7071571972E+01, 5.6363888561E+00, 4.1403684962E+00, 2.0941536914E+00, 8.5664893512E-01],
	[2.2065000000E+04, 1.7077525110E+01, 5.6363029728E+00, 4.1434128230E+00, 2.0950099711E+00, 8.5672552353E-01],
	[2.2070000000E+04, 1.7083478974E+01, 5.6362171103E+00, 4.1464586973E+00, 2.0958661531E+00, 8.5680207332E-01],
	[2.2075000000E+04, 1.7089433565E+01, 5.6361312686E+00, 4.1495061196E+00, 2.0967222370E+00, 8.5687858449E-01],
	[2.2080000000E+04, 1.7095388882E+01, 5.6360454476E+00, 4.1525550901E+00, 2.0975782229E+00, 8.5695505706E-01],
	[2.2085000000E+04, 1.7101372829E+01, 5.6359640680E+00, 4.1556056095E+00, 2.0984351434E+00, 8.5703149104E-01],
	[2.2090000000E+04, 1.7107358229E+01, 5.6358828211E+00, 4.1586576780E+00, 2.0992919930E+00, 8.5710788645E-01],
	[2.2095000000E+04, 1.7113344368E+01, 5.6358015938E+00, 4.1617112962E+00, 2.1001487452E+00, 8.5718424330E-01],
	[2.2100000000E+04, 1.7119331247E+01, 5.6357203860E+00, 4.1647664645E+00, 2.1010053998E+00, 8.5726056161E-01],
	[2.2105000000E+04, 1.7125318865E+01, 5.6356391977E+00, 4.1678231833E+00, 2.1018619567E+00, 8.5733684140E-01],
	[2.2110000000E+04, 1.7131307223E+01, 5.6355580290E+00, 4.1708814531E+00, 2.1027184156E+00, 8.5741308267E-01],
	[2.2115000000E+04, 1.7137296320E+01, 5.6354768798E+00, 4.1739412742E+00, 2.1035747764E+00, 8.5748928544E-01],
	[2.2120000000E+04, 1.7143286156E+01, 5.6353957501E+00, 4.1770026472E+00, 2.1044310389E+00, 8.5756544973E-01],
	[2.2125000000E+04, 1.7149276731E+01, 5.6353146399E+00, 4.1800655724E+00, 2.1052872030E+00, 8.5764157555E-01],
	[2.2130000000E+04, 1.7155268045E+01, 5.6352335492E+00, 4.1831300504E+00, 2.1061432685E+00, 8.5771766292E-01],
	[2.2135000000E+04, 1.7161260098E+01, 5.6351524780E+00, 4.1861960814E+00, 2.1069992352E+00, 8.5779371185E-01],
	[2.2140000000E+04, 1.7167252889E+01, 5.6350714263E+00, 4.1892636660E+00, 2.1078551030E+00, 8.5786972235E-01],
	[2.2145000000E+04, 1.7173246420E+01, 5.6349903940E+00, 4.1923328047E+00, 2.1087108717E+00, 8.5794569445E-01],
	[2.2150000000E+04, 1.7179240689E+01, 5.6349093812E+00, 4.1954034977E+00, 2.1095665411E+00, 8.5802162815E-01],
	[2.2155000000E+04, 1.7185235697E+01, 5.6348283879E+00, 4.1984757457E+00, 2.1104221111E+00, 8.5809752347E-01],
	[2.2160000000E+04, 1.7191231443E+01, 5.6347474140E+00, 4.2015495489E+00, 2.1112775815E+00, 8.5817338043E-01],
	[2.2165000000E+04, 1.7197227928E+01, 5.6346664595E+00, 4.2046249079E+00, 2.1121329522E+00, 8.5824919903E-01],
	[2.2170000000E+04, 1.7203225151E+01, 5.6345855244E+00, 4.2077018231E+00, 2.1129882229E+00, 8.5832497930E-01],
	[2.2175000000E+04, 1.7209223113E+01, 5.6345046088E+00, 4.2107802949E+00, 2.1138433935E+00, 8.5840072125E-01],
	[2.2180000000E+04, 1.7215221813E+01, 5.6344237125E+00, 4.2138603238E+00, 2.1146984639E+00, 8.5847642490E-01],
	[2.2185000000E+04, 1.7221221251E+01, 5.6343428357E+00, 4.2169419101E+00, 2.1155534339E+00, 8.5855209025E-01],
	[2.2190000000E+04, 1.7227221427E+01, 5.6342619782E+00, 4.2200250544E+00, 2.1164083032E+00, 8.5862771733E-01],
	[2.2195000000E+04, 1.7233222341E+01, 5.6341811402E+00, 4.2231097570E+00, 2.1172630719E+00, 8.5870330615E-01],
	[2.2200000000E+04, 1.7239223993E+01, 5.6341003214E+00, 4.2261960185E+00, 2.1181177396E+00, 8.5877885672E-01],
	[2.2205000000E+04, 1.7245226383E+01, 5.6340195221E+00, 4.2292838391E+00, 2.1189723062E+00, 8.5885436907E-01],
	[2.2210000000E+04, 1.7251229510E+01, 5.6339387421E+00, 4.2323732195E+00, 2.1198267716E+00, 8.5892984319E-01],
	[2.2215000000E+04, 1.7257233376E+01, 5.6338579814E+00, 4.2354641599E+00, 2.1206811356E+00, 8.5900527912E-01],
	[2.2220000000E+04, 1.7263237979E+01, 5.6337772401E+00, 4.2385566609E+00, 2.1215353981E+00, 8.5908067686E-01],
	[2.2225000000E+04, 1.7269243319E+01, 5.6336965181E+00, 4.2416507229E+00, 2.1223895588E+00, 8.5915603643E-01],
	[2.2230000000E+04, 1.7275249397E+01, 5.6336158154E+00, 4.2447463462E+00, 2.1232436176E+00, 8.5923135784E-01],
	[2.2235000000E+04, 1.7281256213E+01, 5.6335351320E+00, 4.2478435315E+00, 2.1240975744E+00, 8.5930664113E-01],
	[2.2240000000E+04, 1.7287263766E+01, 5.6334544679E+00, 4.2509422790E+00, 2.1249514290E+00, 8.5938188635E-01],
	[2.2245000000E+04, 1.7293272056E+01, 5.6333738231E+00, 4.2540425892E+00, 2.1258051812E+00, 8.5945709352E-01],
	[2.2250000000E+04, 1.7299281083E+01, 5.6332931976E+00, 4.2571444626E+00, 2.1266588308E+00, 8.5953226264E-01],
	[2.2255000000E+04, 1.7305290847E+01, 5.6332125913E+00, 4.2602478996E+00, 2.1275123777E+00, 8.5960739373E-01],
	[2.2260000000E+04, 1.7311301349E+01, 5.6331320043E+00, 4.2633529006E+00, 2.1283658218E+00, 8.5968248681E-01],
	[2.2265000000E+04, 1.7317312587E+01, 5.6330514366E+00, 4.2664594661E+00, 2.1292191629E+00, 8.5975754188E-01],
	[2.2270000000E+04, 1.7323324562E+01, 5.6329708881E+00, 4.2695675965E+00, 2.1300724008E+00, 8.5983255896E-01],
	[2.2275000000E+04, 1.7329337274E+01, 5.6328903588E+00, 4.2726772923E+00, 2.1309255353E+00, 8.5990753805E-01],
	[2.2280000000E+04, 1.7335350723E+01, 5.6328098488E+00, 4.2757885538E+00, 2.1317785663E+00, 8.5998247918E-01],
	[2.2285000000E+04, 1.7341364908E+01, 5.6327293580E+00, 4.2789013815E+00, 2.1326314936E+00, 8.6005738236E-01],
	[2.2290000000E+04, 1.7347379830E+01, 5.6326488863E+00, 4.2820157759E+00, 2.1334843171E+00, 8.6013224760E-01],
	[2.2295000000E+04, 1.7353395489E+01, 5.6325684339E+00, 4.2851317374E+00, 2.1343370367E+00, 8.6020707490E-01],
	[2.2300000000E+04, 1.7359411884E+01, 5.6324880007E+00, 4.2882492664E+00, 2.1351896520E+00, 8.6028186429E-01],
	[2.2305000000E+04, 1.7365429015E+01, 5.6324075866E+00, 4.2913683633E+00, 2.1360421631E+00, 8.6035661578E-01],
	[2.2310000000E+04, 1.7371446883E+01, 5.6323271918E+00, 4.2944890287E+00, 2.1368945697E+00, 8.6043132937E-01],
	[2.2315000000E+04, 1.7377465486E+01, 5.6322468161E+00, 4.2976112629E+00, 2.1377468716E+00, 8.6050600509E-01],
	[2.2320000000E+04, 1.7383484826E+01, 5.6321664595E+00, 4.3007350663E+00, 2.1385990688E+00, 8.6058064294E-01],
	[2.2325000000E+04, 1.7389504902E+01, 5.6320861221E+00, 4.3038604395E+00, 2.1394511610E+00, 8.6065524294E-01],
	[2.2330000000E+04, 1.7395525714E+01, 5.6320058038E+00, 4.3069873828E+00, 2.1403031481E+00, 8.6072980510E-01],
	[2.2335000000E+04, 1.7401547262E+01, 5.6319255046E+00, 4.3101158967E+00, 2.1411550299E+00, 8.6080432944E-01],
	[2.2340000000E+04, 1.7407569546E+01, 5.6318452246E+00, 4.3132459816E+00, 2.1420068063E+00, 8.6087881595E-01],
	[2.2345000000E+04, 1.7413592565E+01, 5.6317649637E+00, 4.3163776379E+00, 2.1428584771E+00, 8.6095326467E-01],
	[2.2350000000E+04, 1.7419616320E+01, 5.6316847219E+00, 4.3195108662E+00, 2.1437100422E+00, 8.6102767560E-01],
	[2.2355000000E+04, 1.7425640811E+01, 5.6316044991E+00, 4.3226456668E+00, 2.1445615013E+00, 8.6110204876E-01],
	[2.2360000000E+04, 1.7431666037E+01, 5.6315242955E+00, 4.3257820401E+00, 2.1454128544E+00, 8.6117638415E-01],
	[2.2365000000E+04, 1.7437691999E+01, 5.6314441109E+00, 4.3289341466E+00, 2.1462675820E+00, 8.6125068179E-01],
	[2.2370000000E+04, 1.7443718696E+01, 5.6313639454E+00, 4.3320901508E+00, 2.1471227696E+00, 8.6132494170E-01],
	[2.2375000000E+04, 1.7449746128E+01, 5.6312837990E+00, 4.3352477496E+00, 2.1479778502E+00, 8.6139916388E-01],
	[2.2380000000E+04, 1.7455774296E+01, 5.6312036716E+00, 4.3384069432E+00, 2.1488328239E+00, 8.6147334835E-01],
	[2.2385000000E+04, 1.7461803199E+01, 5.6311235632E+00, 4.3415677323E+00, 2.1496876904E+00, 8.6154749513E-01],
	[2.2390000000E+04, 1.7467832837E+01, 5.6310434739E+00, 4.3447301172E+00, 2.1505424495E+00, 8.6162160422E-01],
	[2.2395000000E+04, 1.7473863210E+01, 5.6309634035E+00, 4.3478940983E+00, 2.1513971011E+00, 8.6169567563E-01],
	[2.2400000000E+04, 1.7479894318E+01, 5.6308833523E+00, 4.3510596762E+00, 2.1522516451E+00, 8.6176970939E-01],
	[2.2405000000E+04, 1.7485926160E+01, 5.6308033200E+00, 4.3542268513E+00, 2.1531060812E+00, 8.6184370551E-01],
	[2.2410000000E+04, 1.7491958738E+01, 5.6307233067E+00, 4.3573956240E+00, 2.1539604094E+00, 8.6191766399E-01],
	[2.2415000000E+04, 1.7497992050E+01, 5.6306433123E+00, 4.3605659948E+00, 2.1548146294E+00, 8.6199158485E-01],
	[2.2420000000E+04, 1.7504026097E+01, 5.6305633370E+00, 4.3637379641E+00, 2.1556687411E+00, 8.6206546811E-01],
	[2.2425000000E+04, 1.7510060878E+01, 5.6304833807E+00, 4.3669115324E+00, 2.1565227444E+00, 8.6213931377E-01],
	[2.2430000000E+04, 1.7516096394E+01, 5.6304034432E+00, 4.3700867001E+00, 2.1573766390E+00, 8.6221312185E-01],
	[2.2435000000E+04, 1.7522132644E+01, 5.6303235248E+00, 4.3732634677E+00, 2.1582304249E+00, 8.6228689237E-01],
	[2.2440000000E+04, 1.7528194961E+01, 5.6302475696E+00, 4.3764418356E+00, 2.1590850662E+00, 8.6236062533E-01],
	[2.2445000000E+04, 1.7534261379E+01, 5.6301721545E+00, 4.3796218043E+00, 2.1599397272E+00, 8.6243432075E-01],
	[2.2450000000E+04, 1.7540328544E+01, 5.6300967572E+00, 4.3828033742E+00, 2.1607942802E+00, 8.6250797865E-01],
	[2.2455000000E+04, 1.7546396456E+01, 5.6300213777E+00, 4.3859865458E+00, 2.1616487250E+00, 8.6258159903E-01],
	[2.2460000000E+04, 1.7552465116E+01, 5.6299460160E+00, 4.3891713195E+00, 2.1625030614E+00, 8.6265518191E-01],
	[2.2465000000E+04, 1.7558534524E+01, 5.6298706721E+00, 4.3923576958E+00, 2.1633572893E+00, 8.6272872730E-01],
	[2.2470000000E+04, 1.7564604679E+01, 5.6297953459E+00, 4.3955456751E+00, 2.1642114085E+00, 8.6280223522E-01],
	[2.2475000000E+04, 1.7570675581E+01, 5.6297200376E+00, 4.3987352579E+00, 2.1650654189E+00, 8.6287570568E-01],
	[2.2480000000E+04, 1.7576747230E+01, 5.6296447469E+00, 4.4019264446E+00, 2.1659193203E+00, 8.6294913869E-01],
	[2.2485000000E+04, 1.7582819626E+01, 5.6295694741E+00, 4.4051192356E+00, 2.1667731125E+00, 8.6302253426E-01],
	[2.2490000000E+04, 1.7588892770E+01, 5.6294942190E+00, 4.4083136315E+00, 2.1676267954E+00, 8.6309589241E-01],
	[2.2495000000E+04, 1.7594966660E+01, 5.6294189816E+00, 4.4115096326E+00, 2.1684803688E+00, 8.6316921316E-01],
	[2.2500000000E+04, 1.7601041297E+01, 5.6293437619E+00, 4.4147072395E+00, 2.1693338327E+00, 8.6324249651E-01],
	[2.2505000000E+04, 1.7607116681E+01, 5.6292685600E+00, 4.4179064525E+00, 2.1701871867E+00, 8.6331574248E-01],
	[2.2510000000E+04, 1.7613192812E+01, 5.6291933757E+00, 4.4211072721E+00, 2.1710404308E+00, 8.6338895108E-01],
	[2.2515000000E+04, 1.7619269689E+01, 5.6291182092E+00, 4.4243096988E+00, 2.1718935648E+00, 8.6346212233E-01],
	[2.2520000000E+04, 1.7625347313E+01, 5.6290430604E+00, 4.4275137330E+00, 2.1727465886E+00, 8.6353525624E-01],
	[2.2525000000E+04, 1.7631425683E+01, 5.6289679292E+00, 4.4307193752E+00, 2.1735995019E+00, 8.6360835282E-01],
	[2.2530000000E+04, 1.7637504800E+01, 5.6288928157E+00, 4.4339266257E+00, 2.1744523047E+00, 8.6368141208E-01],
	[2.2535000000E+04, 1.7643584663E+01, 5.6288177199E+00, 4.4371354852E+00, 2.1753049968E+00, 8.6375443404E-01],
	[2.2540000000E+04, 1.7649665272E+01, 5.6287426418E+00, 4.4403459539E+00, 2.1761575780E+00, 8.6382741872E-01],
	[2.2545000000E+04, 1.7655746628E+01, 5.6286675813E+00, 4.4435580324E+00, 2.1770100482E+00, 8.6390036612E-01],
	[2.2550000000E+04, 1.7661828730E+01, 5.6285925385E+00, 4.4467717212E+00, 2.1778624072E+00, 8.6397327627E-01],
	[2.2555000000E+04, 1.7667911577E+01, 5.6285175133E+00, 4.4499870206E+00, 2.1787146548E+00, 8.6404614916E-01],
	[2.2560000000E+04, 1.7673995171E+01, 5.6284425057E+00, 4.4532039310E+00, 2.1795667910E+00, 8.6411898482E-01],
	[2.2565000000E+04, 1.7680079511E+01, 5.6283675157E+00, 4.4564224531E+00, 2.1804188155E+00, 8.6419178327E-01],
	[2.2570000000E+04, 1.7686164596E+01, 5.6282925434E+00, 4.4596425872E+00, 2.1812707282E+00, 8.6426454450E-01],
	[2.2575000000E+04, 1.7692250427E+01, 5.6282175887E+00, 4.4628643337E+00, 2.1821225290E+00, 8.6433726855E-01],
	[2.2580000000E+04, 1.7698337004E+01, 5.6281426515E+00, 4.4660876931E+00, 2.1829742177E+00, 8.6440995541E-01],
	[2.2585000000E+04, 1.7704424327E+01, 5.6280677320E+00, 4.4693126659E+00, 2.1838257941E+00, 8.6448260511E-01],
	[2.2590000000E+04, 1.7710512395E+01, 5.6279928300E+00, 4.4725392525E+00, 2.1846772581E+00, 8.6455521766E-01],
	[2.2595000000E+04, 1.7716601208E+01, 5.6279179456E+00, 4.4757674534E+00, 2.1855286095E+00, 8.6462779306E-01],
	[2.2600000000E+04, 1.7722690767E+01, 5.6278430788E+00, 4.4789972689E+00, 2.1863798482E+00, 8.6470033135E-01],
	[2.2605000000E+04, 1.7728781071E+01, 5.6277682295E+00, 4.4822286996E+00, 2.1872309740E+00, 8.6477283252E-01],
	[2.2610000000E+04, 1.7734872121E+01, 5.6276933978E+00, 4.4854617460E+00, 2.1880819868E+00, 8.6484529659E-01],
	[2.2615000000E+04, 1.7740963916E+01, 5.6276185836E+00, 4.4886964084E+00, 2.1889328864E+00, 8.6491772359E-01],
	[2.2620000000E+04, 1.7747056455E+01, 5.6275437870E+00, 4.4919326873E+00, 2.1897836727E+00, 8.6499011351E-01],
	[2.2625000000E+04, 1.7753149740E+01, 5.6274690079E+00, 4.4951705831E+00, 2.1906343455E+00, 8.6506246637E-01],
	[2.2630000000E+04, 1.7759243770E+01, 5.6273942463E+00, 4.4984100964E+00, 2.1914849046E+00, 8.6513478219E-01],
	[2.2635000000E+04, 1.7765338544E+01, 5.6273195022E+00, 4.5016512275E+00, 2.1923353500E+00, 8.6520706099E-01],
	[2.2640000000E+04, 1.7771434064E+01, 5.6272447756E+00, 4.5048939770E+00, 2.1931856814E+00, 8.6527930276E-01],
	[2.2645000000E+04, 1.7777530328E+01, 5.6271700665E+00, 4.5081383452E+00, 2.1940358988E+00, 8.6535150754E-01],
	[2.2650000000E+04, 1.7783627336E+01, 5.6270953748E+00, 4.5113843326E+00, 2.1948860019E+00, 8.6542367533E-01],
	[2.2655000000E+04, 1.7789725090E+01, 5.6270207007E+00, 4.5146319396E+00, 2.1957359906E+00, 8.6549580614E-01],
	[2.2660000000E+04, 1.7795823587E+01, 5.6269460440E+00, 4.5178811668E+00, 2.1965858647E+00, 8.6556789999E-01],
	[2.2665000000E+04, 1.7801922830E+01, 5.6268714048E+00, 4.5211320145E+00, 2.1974356242E+00, 8.6563995690E-01],
	[2.2670000000E+04, 1.7808022816E+01, 5.6267967831E+00, 4.5243844833E+00, 2.1982852688E+00, 8.6571197688E-01],
	[2.2675000000E+04, 1.7814123547E+01, 5.6267221788E+00, 4.5276385735E+00, 2.1991347984E+00, 8.6578395993E-01],
	[2.2680000000E+04, 1.7820225022E+01, 5.6266475919E+00, 4.5308942856E+00, 2.1999842128E+00, 8.6585590608E-01],
	[2.2685000000E+04, 1.7826327241E+01, 5.6265730225E+00, 4.5341516200E+00, 2.2008335120E+00, 8.6592781534E-01],
	[2.2690000000E+04, 1.7832430205E+01, 5.6264984705E+00, 4.5374105773E+00, 2.2016826957E+00, 8.6599968772E-01],
	[2.2695000000E+04, 1.7838533912E+01, 5.6264239358E+00, 4.5406711579E+00, 2.2025317638E+00, 8.6607152324E-01],
	[2.2700000000E+04, 1.7844638363E+01, 5.6263494187E+00, 4.5439333621E+00, 2.2033807161E+00, 8.6614332191E-01],
	[2.2705000000E+04, 1.7850743558E+01, 5.6262749189E+00, 4.5471971905E+00, 2.2042295525E+00, 8.6621508374E-01],
	[2.2710000000E+04, 1.7856849497E+01, 5.6262004364E+00, 4.5504626436E+00, 2.2050782729E+00, 8.6628680876E-01],
	[2.2715000000E+04, 1.7862956179E+01, 5.6261259714E+00, 4.5537297217E+00, 2.2059268771E+00, 8.6635849696E-01],
	[2.2720000000E+04, 1.7869063606E+01, 5.6260515238E+00, 4.5569984253E+00, 2.2067753650E+00, 8.6643014837E-01],
	[2.2725000000E+04, 1.7875171775E+01, 5.6259770935E+00, 4.5602687549E+00, 2.2076237363E+00, 8.6650176300E-01],
	[2.2730000000E+04, 1.7881280688E+01, 5.6259026806E+00, 4.5635407109E+00, 2.2084719910E+00, 8.6657334086E-01],
	[2.2735000000E+04, 1.7887390345E+01, 5.6258282850E+00, 4.5668142937E+00, 2.2093201289E+00, 8.6664488197E-01],
	[2.2740000000E+04, 1.7893500745E+01, 5.6257539067E+00, 4.5700895039E+00, 2.2101681499E+00, 8.6671638635E-01],
	[2.2745000000E+04, 1.7899611888E+01, 5.6256795459E+00, 4.5733663418E+00, 2.2110160538E+00, 8.6678785399E-01],
	[2.2750000000E+04, 1.7905723774E+01, 5.6256052023E+00, 4.5766448080E+00, 2.2118638404E+00, 8.6685928493E-01],
	[2.2755000000E+04, 1.7911836404E+01, 5.6255308760E+00, 4.5799249028E+00, 2.2127115096E+00, 8.6693067918E-01],
	[2.2760000000E+04, 1.7917949776E+01, 5.6254565671E+00, 4.5832066268E+00, 2.2135590613E+00, 8.6700203674E-01],
	[2.2765000000E+04, 1.7924063892E+01, 5.6253822755E+00, 4.5864899803E+00, 2.2144064954E+00, 8.6707335763E-01],
	[2.2770000000E+04, 1.7930178750E+01, 5.6253080011E+00, 4.5897749638E+00, 2.2152538115E+00, 8.6714464187E-01],
	[2.2775000000E+04, 1.7936294351E+01, 5.6252337441E+00, 4.5930615778E+00, 2.2161010097E+00, 8.6721588947E-01],
	[2.2780000000E+04, 1.7942410695E+01, 5.6251595043E+00, 4.5963498227E+00, 2.2169480898E+00, 8.6728710044E-01],
	[2.2785000000E+04, 1.7948527782E+01, 5.6250852818E+00, 4.5996396990E+00, 2.2177950516E+00, 8.6735827480E-01],
	[2.2790000000E+04, 1.7954645611E+01, 5.6250110766E+00, 4.6029312072E+00, 2.2186418950E+00, 8.6742941256E-01],
	[2.2795000000E+04, 1.7960764183E+01, 5.6249368886E+00, 4.6062243476E+00, 2.2194886199E+00, 8.6750051374E-01],
	[2.2800000000E+04, 1.7966902091E+01, 5.6248655633E+00, 4.6095191207E+00, 2.2203359533E+00, 8.6757157835E-01],
	[2.2805000000E+04, 1.7973050914E+01, 5.6247958095E+00, 4.6128155270E+00, 2.2211835664E+00, 8.6764260641E-01],
	[2.2810000000E+04, 1.7979200493E+01, 5.6247260719E+00, 4.6161135669E+00, 2.2220310616E+00, 8.6771359792E-01],
	[2.2815000000E+04, 1.7985350828E+01, 5.6246563504E+00, 4.6194132410E+00, 2.2228784389E+00, 8.6778455291E-01],
	[2.2820000000E+04, 1.7991501918E+01, 5.6245866450E+00, 4.6227145495E+00, 2.2237256981E+00, 8.6785547138E-01],
	[2.2825000000E+04, 1.7997653764E+01, 5.6245169558E+00, 4.6260174930E+00, 2.2245728390E+00, 8.6792635336E-01],
	[2.2830000000E+04, 1.8003806364E+01, 5.6244472827E+00, 4.6293220720E+00, 2.2254198615E+00, 8.6799719885E-01],
	[2.2835000000E+04, 1.8009959721E+01, 5.6243776258E+00, 4.6326282868E+00, 2.2262667655E+00, 8.6806800787E-01],
	[2.2840000000E+04, 1.8016113832E+01, 5.6243079849E+00, 4.6359361380E+00, 2.2271135507E+00, 8.6813878043E-01],
	[2.2845000000E+04, 1.8022268699E+01, 5.6242383602E+00, 4.6392456259E+00, 2.2279602172E+00, 8.6820951655E-01],
	[2.2850000000E+04, 1.8028424320E+01, 5.6241687515E+00, 4.6425567511E+00, 2.2288067646E+00, 8.6828021625E-01],
	[2.2855000000E+04, 1.8034580697E+01, 5.6240991590E+00, 4.6458695140E+00, 2.2296531930E+00, 8.6835087953E-01],
	[2.2860000000E+04, 1.8040737828E+01, 5.6240295825E+00, 4.6491839150E+00, 2.2304995020E+00, 8.6842150641E-01],
	[2.2865000000E+04, 1.8046895715E+01, 5.6239600221E+00, 4.6524999546E+00, 2.2313456916E+00, 8.6849209691E-01],
	[2.2870000000E+04, 1.8053054356E+01, 5.6238904778E+00, 4.6558176333E+00, 2.2321917617E+00, 8.6856265104E-01],
	[2.2875000000E+04, 1.8059213752E+01, 5.6238209495E+00, 4.6591369514E+00, 2.2330377121E+00, 8.6863316881E-01],
	[2.2880000000E+04, 1.8065373902E+01, 5.6237514373E+00, 4.6624579095E+00, 2.2338835426E+00, 8.6870365023E-01],
	[2.2885000000E+04, 1.8071534807E+01, 5.6236819412E+00, 4.6657805080E+00, 2.2347292532E+00, 8.6877409533E-01],
	[2.2890000000E+04, 1.8077696467E+01, 5.6236124610E+00, 4.6691047474E+00, 2.2355748436E+00, 8.6884450412E-01],
	[2.2895000000E+04, 1.8083858880E+01, 5.6235429969E+00, 4.6724306280E+00, 2.2364203137E+00, 8.6891487661E-01],
	[2.2900000000E+04, 1.8090022049E+01, 5.6234735489E+00, 4.6757581504E+00, 2.2372656634E+00, 8.6898521281E-01],
	[2.2905000000E+04, 1.8096185971E+01, 5.6234041168E+00, 4.6790873150E+00, 2.2381108925E+00, 8.6905551275E-01],
	[2.2910000000E+04, 1.8102350648E+01, 5.6233347008E+00, 4.6824181222E+00, 2.2389560009E+00, 8.6912577642E-01],
	[2.2915000000E+04, 1.8108516079E+01, 5.6232653008E+00, 4.6857505725E+00, 2.2398009885E+00, 8.6919600386E-01],
	[2.2920000000E+04, 1.8114682263E+01, 5.6231959168E+00, 4.6890846664E+00, 2.2406458550E+00, 8.6926619507E-01],
	[2.2925000000E+04, 1.8120849202E+01, 5.6231265487E+00, 4.6924204043E+00, 2.2414906005E+00, 8.6933635006E-01],
	[2.2930000000E+04, 1.8127016895E+01, 5.6230571967E+00, 4.6957577867E+00, 2.2423352246E+00, 8.6940646886E-01],
	[2.2935000000E+04, 1.8133185341E+01, 5.6229878606E+00, 4.6990968140E+00, 2.2431797274E+00, 8.6947655147E-01],
	[2.2940000000E+04, 1.8139354542E+01, 5.6229185405E+00, 4.7024374866E+00, 2.2440241085E+00, 8.6954659792E-01],
	[2.2945000000E+04, 1.8145524496E+01, 5.6228492363E+00, 4.7057798051E+00, 2.2448683680E+00, 8.6961660820E-01],
	[2.2950000000E+04, 1.8151695203E+01, 5.6227799482E+00, 4.7091237698E+00, 2.2457125056E+00, 8.6968658235E-01],
	[2.2955000000E+04, 1.8157866664E+01, 5.6227106759E+00, 4.7124693812E+00, 2.2465565212E+00, 8.6975652037E-01],
	[2.2960000000E+04, 1.8164038879E+01, 5.6226414196E+00, 4.7158166398E+00, 2.2474004147E+00, 8.6982642228E-01],
	[2.2965000000E+04, 1.8170211847E+01, 5.6225721792E+00, 4.7191655460E+00, 2.2482441860E+00, 8.6989628809E-01],
	[2.2970000000E+04, 1.8176385568E+01, 5.6225029548E+00, 4.7225161003E+00, 2.2490878348E+00, 8.6996611782E-01],
	[2.2975000000E+04, 1.8182560043E+01, 5.6224337463E+00, 4.7258683031E+00, 2.2499313611E+00, 8.7003591148E-01],
	[2.2980000000E+04, 1.8188735270E+01, 5.6223645536E+00, 4.7292221549E+00, 2.2507747646E+00, 8.7010566909E-01],
	[2.2985000000E+04, 1.8194911251E+01, 5.6222953769E+00, 4.7325776562E+00, 2.2516180454E+00, 8.7017539066E-01],
	[2.2990000000E+04, 1.8201087985E+01, 5.6222262161E+00, 4.7359348073E+00, 2.2524612031E+00, 8.7024507620E-01],
	[2.2995000000E+04, 1.8207265472E+01, 5.6221570712E+00, 4.7392936087E+00, 2.2533042378E+00, 8.7031472574E-01],
	[2.3000000000E+04, 1.8213443712E+01, 5.6220879422E+00, 4.7426540609E+00, 2.2541471492E+00, 8.7038433927E-01],
	[2.3005000000E+04, 1.8219622704E+01, 5.6220188290E+00, 4.7460161644E+00, 2.2549899372E+00, 8.7045391683E-01],
	[2.3010000000E+04, 1.8225802449E+01, 5.6219497317E+00, 4.7493799195E+00, 2.2558326017E+00, 8.7052345842E-01],
	[2.3015000000E+04, 1.8231982947E+01, 5.6218806503E+00, 4.7527453268E+00, 2.2566751424E+00, 8.7059296406E-01],
	[2.3020000000E+04, 1.8238164198E+01, 5.6218115847E+00, 4.7561123867E+00, 2.2575175594E+00, 8.7066243376E-01],
	[2.3025000000E+04, 1.8244346201E+01, 5.6217425350E+00, 4.7594810996E+00, 2.2583598525E+00, 8.7073186753E-01],
	[2.3030000000E+04, 1.8250528957E+01, 5.6216735011E+00, 4.7628514661E+00, 2.2592020214E+00, 8.7080126540E-01],
	[2.3035000000E+04, 1.8256712464E+01, 5.6216044830E+00, 4.7662234864E+00, 2.2600440661E+00, 8.7087062738E-01],
	[2.3040000000E+04, 1.8262896725E+01, 5.6215354808E+00, 4.7695971612E+00, 2.2608859865E+00, 8.7093995347E-01],
	[2.3045000000E+04, 1.8269081737E+01, 5.6214664944E+00, 4.7729724908E+00, 2.2617277823E+00, 8.7100924370E-01],
	[2.3050000000E+04, 1.8275267502E+01, 5.6213975238E+00, 4.7763494757E+00, 2.2625694535E+00, 8.7107849809E-01],
	[2.3055000000E+04, 1.8281454019E+01, 5.6213285690E+00, 4.7797281164E+00, 2.2634109999E+00, 8.7114771663E-01],
	[2.3060000000E+04, 1.8287641287E+01, 5.6212596300E+00, 4.7831084133E+00, 2.2642524214E+00, 8.7121689936E-01],
	[2.3065000000E+04, 1.8293829308E+01, 5.6211907068E+00, 4.7864903669E+00, 2.2650937179E+00, 8.7128604628E-01],
	[2.3070000000E+04, 1.8300018081E+01, 5.6211217994E+00, 4.7898739775E+00, 2.2659348891E+00, 8.7135515741E-01],
	[2.3075000000E+04, 1.8306207605E+01, 5.6210529077E+00, 4.7932592458E+00, 2.2667759350E+00, 8.7142423277E-01],
	[2.3080000000E+04, 1.8312397881E+01, 5.6209840319E+00, 4.7966461720E+00, 2.2676168554E+00, 8.7149327236E-01],
	[2.3085000000E+04, 1.8318588909E+01, 5.6209151718E+00, 4.8000347568E+00, 2.2684576503E+00, 8.7156227620E-01],
	[2.3090000000E+04, 1.8324780689E+01, 5.6208463274E+00, 4.8034250004E+00, 2.2692983193E+00, 8.7163124431E-01],
	[2.3095000000E+04, 1.8330973220E+01, 5.6207774988E+00, 4.8068169034E+00, 2.2701388625E+00, 8.7170017671E-01],
	[2.3100000000E+04, 1.8337166502E+01, 5.6207086859E+00, 4.8102104663E+00, 2.2709792797E+00, 8.7176907340E-01],
	[2.3105000000E+04, 1.8343360536E+01, 5.6206398888E+00, 4.8136056894E+00, 2.2718195708E+00, 8.7183793441E-01],
	[2.3110000000E+04, 1.8349555321E+01, 5.6205711074E+00, 4.8170025733E+00, 2.2726597355E+00, 8.7190675974E-01],
	[2.3115000000E+04, 1.8355750857E+01, 5.6205023417E+00, 4.8204011183E+00, 2.2734997738E+00, 8.7197554941E-01],
	[2.3120000000E+04, 1.8361947145E+01, 5.6204335918E+00, 4.8238013250E+00, 2.2743396856E+00, 8.7204430344E-01],
	[2.3125000000E+04, 1.8368144184E+01, 5.6203648575E+00, 4.8272031938E+00, 2.2751794706E+00, 8.7211302184E-01],
	[2.3130000000E+04, 1.8374341973E+01, 5.6202961390E+00, 4.8306067252E+00, 2.2760191288E+00, 8.7218170462E-01],
	[2.3135000000E+04, 1.8380540514E+01, 5.6202274361E+00, 4.8340119195E+00, 2.2768586601E+00, 8.7225035181E-01],
	[2.3140000000E+04, 1.8386739805E+01, 5.6201587489E+00, 4.8374187773E+00, 2.2776980642E+00, 8.7231896341E-01],
	[2.3145000000E+04, 1.8392939848E+01, 5.6200900774E+00, 4.8408272989E+00, 2.2785373411E+00, 8.7238753944E-01],
	[2.3150000000E+04, 1.8399140641E+01, 5.6200214216E+00, 4.8442374850E+00, 2.2793764906E+00, 8.7245607992E-01],
	[2.3155000000E+04, 1.8405342185E+01, 5.6199527815E+00, 4.8476493358E+00, 2.2802155126E+00, 8.7252458485E-01],
	[2.3160000000E+04, 1.8411544479E+01, 5.6198841570E+00, 4.8510628519E+00, 2.2810544070E+00, 8.7259305427E-01],
	[2.3165000000E+04, 1.8417754650E+01, 5.6198166200E+00, 4.8544780337E+00, 2.2818934597E+00, 8.7266148817E-01],
	[2.3170000000E+04, 1.8423987281E+01, 5.6197523621E+00, 4.8578948817E+00, 2.2827332565E+00, 8.7272988657E-01],
	[2.3175000000E+04, 1.8430220676E+01, 5.6196881187E+00, 4.8613133963E+00, 2.2835729264E+00, 8.7279824949E-01],
	[2.3180000000E+04, 1.8436454834E+01, 5.6196238900E+00, 4.8647335779E+00, 2.2844124693E+00, 8.7286657695E-01],
	[2.3185000000E+04, 1.8442689755E+01, 5.6195596758E+00, 4.8681554271E+00, 2.2852518851E+00, 8.7293486896E-01],
	[2.3190000000E+04, 1.8448925440E+01, 5.6194954762E+00, 4.8715789443E+00, 2.2860911735E+00, 8.7300312553E-01],
	[2.3195000000E+04, 1.8455161888E+01, 5.6194312912E+00, 4.8750041299E+00, 2.2869303346E+00, 8.7307134668E-01],
	[2.3200000000E+04, 1.8461399099E+01, 5.6193671208E+00, 4.8784309844E+00, 2.2877693681E+00, 8.7313953242E-01],
	[2.3205000000E+04, 1.8467637074E+01, 5.6193029649E+00, 4.8818595082E+00, 2.2886082739E+00, 8.7320768278E-01],
	[2.3210000000E+04, 1.8473875812E+01, 5.6192388236E+00, 4.8852897018E+00, 2.2894470520E+00, 8.7327579775E-01],
	[2.3215000000E+04, 1.8480115313E+01, 5.6191746968E+00, 4.8887215656E+00, 2.2902857020E+00, 8.7334387737E-01],
	[2.3220000000E+04, 1.8486355577E+01, 5.6191105846E+00, 4.8921551002E+00, 2.2911242240E+00, 8.7341192163E-01],
	[2.3225000000E+04, 1.8492596603E+01, 5.6190464869E+00, 4.8955903058E+00, 2.2919626178E+00, 8.7347993057E-01],
	[2.3230000000E+04, 1.8498838393E+01, 5.6189824037E+00, 4.8990271831E+00, 2.2928008832E+00, 8.7354790419E-01],
	[2.3235000000E+04, 1.8505080945E+01, 5.6189183350E+00, 4.9024657325E+00, 2.2936390202E+00, 8.7361584250E-01],
	[2.3240000000E+04, 1.8511324260E+01, 5.6188542809E+00, 4.9059059543E+00, 2.2944770286E+00, 8.7368374553E-01],
	[2.3245000000E+04, 1.8517568338E+01, 5.6187902413E+00, 4.9093478491E+00, 2.2953149082E+00, 8.7375161329E-01],
	[2.3250000000E+04, 1.8523813178E+01, 5.6187262162E+00, 4.9127914174E+00, 2.2961526589E+00, 8.7381944579E-01],
	[2.3255000000E+04, 1.8530058781E+01, 5.6186622055E+00, 4.9162366595E+00, 2.2969902807E+00, 8.7388724305E-01],
	[2.3260000000E+04, 1.8536305146E+01, 5.6185982094E+00, 4.9196835759E+00, 2.2978277733E+00, 8.7395500508E-01],
	[2.3265000000E+04, 1.8542552274E+01, 5.6185342277E+00, 4.9231321671E+00, 2.2986651366E+00, 8.7402273190E-01],
	[2.3270000000E+04, 1.8548800164E+01, 5.6184702606E+00, 4.9265824335E+00, 2.2995023706E+00, 8.7409042353E-01],
	[2.3275000000E+04, 1.8555048816E+01, 5.6184063079E+00, 4.9300343756E+00, 2.3003394750E+00, 8.7415807997E-01],
	[2.3280000000E+04, 1.8561298230E+01, 5.6183423696E+00, 4.9334879938E+00, 2.3011764497E+00, 8.7422570125E-01],
	[2.3285000000E+04, 1.8567548406E+01, 5.6182784458E+00, 4.9369432886E+00, 2.3020132947E+00, 8.7429328737E-01],
	[2.3290000000E+04, 1.8573799344E+01, 5.6182145365E+00, 4.9404002605E+00, 2.3028500097E+00, 8.7436083835E-01],
	[2.3295000000E+04, 1.8580051044E+01, 5.6181506416E+00, 4.9438589098E+00, 2.3036865947E+00, 8.7442835422E-01],
	[2.3300000000E+04, 1.8586303506E+01, 5.6180867612E+00, 4.9473192371E+00, 2.3045230495E+00, 8.7449583498E-01],
	[2.3305000000E+04, 1.8592556730E+01, 5.6180228952E+00, 4.9507812428E+00, 2.3053593740E+00, 8.7456328064E-01],
	[2.3310000000E+04, 1.8598810715E+01, 5.6179590436E+00, 4.9542449274E+00, 2.3061955681E+00, 8.7463069123E-01],
	[2.3315000000E+04, 1.8605065463E+01, 5.6178952064E+00, 4.9577102912E+00, 2.3070316316E+00, 8.7469806676E-01],
	[2.3320000000E+04, 1.8611320971E+01, 5.6178313837E+00, 4.9611773348E+00, 2.3078675643E+00, 8.7476540724E-01],
	[2.3325000000E+04, 1.8617577241E+01, 5.6177675753E+00, 4.9646460587E+00, 2.3087033663E+00, 8.7483271269E-01],
	[2.3330000000E+04, 1.8623834273E+01, 5.6177037814E+00, 4.9681164632E+00, 2.3095390373E+00, 8.7489998313E-01],
	[2.3335000000E+04, 1.8630092066E+01, 5.6176400018E+00, 4.9715885488E+00, 2.3103745772E+00, 8.7496721856E-01],
	[2.3340000000E+04, 1.8636350620E+01, 5.6175762367E+00, 4.9750623160E+00, 2.3112099859E+00, 8.7503441901E-01],
	[2.3345000000E+04, 1.8642609936E+01, 5.6175124859E+00, 4.9785377652E+00, 2.3120452632E+00, 8.7510158449E-01],
	[2.3350000000E+04, 1.8648870012E+01, 5.6174487495E+00, 4.9820148970E+00, 2.3128804091E+00, 8.7516871501E-01],
	[2.3355000000E+04, 1.8655130850E+01, 5.6173850275E+00, 4.9854937116E+00, 2.3137154234E+00, 8.7523581059E-01],
	[2.3360000000E+04, 1.8661392449E+01, 5.6173213198E+00, 4.9889742097E+00, 2.3145503059E+00, 8.7530287124E-01],
	[2.3365000000E+04, 1.8667654808E+01, 5.6172576265E+00, 4.9924563916E+00, 2.3153850566E+00, 8.7536989699E-01],
	[2.3370000000E+04, 1.8673917929E+01, 5.6171939475E+00, 4.9959402577E+00, 2.3162196752E+00, 8.7543688784E-01],
	[2.3375000000E+04, 1.8680181810E+01, 5.6171302829E+00, 4.9994258087E+00, 2.3170541618E+00, 8.7550384381E-01],
	[2.3380000000E+04, 1.8686446452E+01, 5.6170666326E+00, 5.0029130448E+00, 2.3178885161E+00, 8.7557076491E-01],
	[2.3385000000E+04, 1.8692711855E+01, 5.6170029967E+00, 5.0064019666E+00, 2.3187227381E+00, 8.7563765116E-01],
	[2.3390000000E+04, 1.8698978018E+01, 5.6169393751E+00, 5.0098925746E+00, 2.3195568276E+00, 8.7570450259E-01],
	[2.3395000000E+04, 1.8705244942E+01, 5.6168757678E+00, 5.0133848690E+00, 2.3203907844E+00, 8.7577131919E-01],
	[2.3400000000E+04, 1.8711512626E+01, 5.6168121748E+00, 5.0168788506E+00, 2.3212246085E+00, 8.7583810098E-01],
	[2.3405000000E+04, 1.8717781071E+01, 5.6167485961E+00, 5.0203745195E+00, 2.3220582997E+00, 8.7590484799E-01],
	[2.3410000000E+04, 1.8724050276E+01, 5.6166850317E+00, 5.0238718765E+00, 2.3228918579E+00, 8.7597156023E-01],
	[2.3415000000E+04, 1.8730320241E+01, 5.6166214816E+00, 5.0273709218E+00, 2.3237252829E+00, 8.7603823770E-01],
	[2.3420000000E+04, 1.8736590966E+01, 5.6165579458E+00, 5.0308716559E+00, 2.3245585747E+00, 8.7610488044E-01],
	[2.3425000000E+04, 1.8742862452E+01, 5.6164944243E+00, 5.0343740793E+00, 2.3253917332E+00, 8.7617148844E-01],
	[2.3430000000E+04, 1.8749134697E+01, 5.6164309171E+00, 5.0378781925E+00, 2.3262247581E+00, 8.7623806173E-01],
	[2.3435000000E+04, 1.8755407702E+01, 5.6163674241E+00, 5.0413839959E+00, 2.3270576494E+00, 8.7630460033E-01],
	[2.3440000000E+04, 1.8761681468E+01, 5.6163039454E+00, 5.0448914899E+00, 2.3278904069E+00, 8.7637110424E-01],
	[2.3445000000E+04, 1.8767955993E+01, 5.6162404809E+00, 5.0484006751E+00, 2.3287230305E+00, 8.7643757348E-01],
	[2.3450000000E+04, 1.8774231278E+01, 5.6161770307E+00, 5.0519115518E+00, 2.3295555201E+00, 8.7650400808E-01],
	[2.3455000000E+04, 1.8780507322E+01, 5.6161135948E+00, 5.0554241205E+00, 2.3303878756E+00, 8.7657040803E-01],
	[2.3460000000E+04, 1.8786784126E+01, 5.6160501730E+00, 5.0589383817E+00, 2.3312200968E+00, 8.7663677337E-01],
	[2.3465000000E+04, 1.8793061690E+01, 5.6159867655E+00, 5.0624543358E+00, 2.3320521837E+00, 8.7670310410E-01],
	[2.3470000000E+04, 1.8799340013E+01, 5.6159233723E+00, 5.0659719833E+00, 2.3328841360E+00, 8.7676940024E-01],
	[2.3475000000E+04, 1.8805619095E+01, 5.6158599932E+00, 5.0694913246E+00, 2.3337159537E+00, 8.7683566180E-01],
	[2.3480000000E+04, 1.8811898937E+01, 5.6157966284E+00, 5.0730123603E+00, 2.3345476366E+00, 8.7690188880E-01],
	[2.3485000000E+04, 1.8818179538E+01, 5.6157332778E+00, 5.0765350906E+00, 2.3353791846E+00, 8.7696808126E-01],
	[2.3490000000E+04, 1.8824460898E+01, 5.6156699413E+00, 5.0800595162E+00, 2.3362105977E+00, 8.7703423919E-01],
	[2.3495000000E+04, 1.8830743018E+01, 5.6156066191E+00, 5.0835856374E+00, 2.3370418755E+00, 8.7710036261E-01],
	[2.3500000000E+04, 1.8837025896E+01, 5.6155433111E+00, 5.0871134547E+00, 2.3378730182E+00, 8.7716645152E-01],
	[2.3505000000E+04, 1.8843309534E+01, 5.6154800172E+00, 5.0906429686E+00, 2.3387040254E+00, 8.7723250596E-01],
	[2.3510000000E+04, 1.8849593930E+01, 5.6154167375E+00, 5.0941741795E+00, 2.3395348972E+00, 8.7729852592E-01],
	[2.3515000000E+04, 1.8855879085E+01, 5.6153534720E+00, 5.0977070879E+00, 2.3403656333E+00, 8.7736451143E-01],
	[2.3520000000E+04, 1.8862164999E+01, 5.6152902206E+00, 5.1012416942E+00, 2.3411962337E+00, 8.7743046250E-01],
	[2.3525000000E+04, 1.8868451671E+01, 5.6152269834E+00, 5.1047779988E+00, 2.3420266982E+00, 8.7749637916E-01],
	[2.3530000000E+04, 1.8874739103E+01, 5.6151637604E+00, 5.1083160023E+00, 2.3428570267E+00, 8.7756226140E-01],
	[2.3535000000E+04, 1.8881027292E+01, 5.6151005515E+00, 5.1118557051E+00, 2.3436872191E+00, 8.7762810925E-01],
	[2.3540000000E+04, 1.8887335498E+01, 5.6150402028E+00, 5.1153971077E+00, 2.3445180682E+00, 8.7769392273E-01],
	[2.3545000000E+04, 1.8893654122E+01, 5.6149812933E+00, 5.1189402104E+00, 2.3453491791E+00, 8.7775970185E-01],
	[2.3550000000E+04, 1.8899973517E+01, 5.6149223970E+00, 5.1224850138E+00, 2.3461801547E+00, 8.7782544662E-01],
	[2.3555000000E+04, 1.8906293684E+01, 5.6148635137E+00, 5.1260315183E+00, 2.3470109949E+00, 8.7789115706E-01],
	[2.3560000000E+04, 1.8912614622E+01, 5.6148046436E+00, 5.1295797243E+00, 2.3478416995E+00, 8.7795683318E-01],
	[2.3565000000E+04, 1.8918936331E+01, 5.6147457866E+00, 5.1331296324E+00, 2.3486722684E+00, 8.7802247501E-01],
	[2.3570000000E+04, 1.8925258812E+01, 5.6146869427E+00, 5.1366812430E+00, 2.3495027014E+00, 8.7808808255E-01],
	[2.3575000000E+04, 1.8931582064E+01, 5.6146281119E+00, 5.1402345564E+00, 2.3503329986E+00, 8.7815365583E-01],
	[2.3580000000E+04, 1.8937906087E+01, 5.6145692942E+00, 5.1437895733E+00, 2.3511631596E+00, 8.7821919485E-01],
	[2.3585000000E+04, 1.8944230881E+01, 5.6145104896E+00, 5.1473462940E+00, 2.3519931845E+00, 8.7828469963E-01],
	[2.3590000000E+04, 1.8950556445E+01, 5.6144516981E+00, 5.1509047190E+00, 2.3528230731E+00, 8.7835017019E-01],
	[2.3595000000E+04, 1.8956882781E+01, 5.6143929196E+00, 5.1544648487E+00, 2.3536528252E+00, 8.7841560655E-01],
	[2.3600000000E+04, 1.8963209888E+01, 5.6143341542E+00, 5.1580266836E+00, 2.3544824408E+00, 8.7848100871E-01],
	[2.3605000000E+04, 1.8969537765E+01, 5.6142754019E+00, 5.1615902242E+00, 2.3553119197E+00, 8.7854637670E-01],
	[2.3610000000E+04, 1.8975866413E+01, 5.6142166626E+00, 5.1651554709E+00, 2.3561412619E+00, 8.7861171052E-01],
	[2.3615000000E+04, 1.8982195831E+01, 5.6141579364E+00, 5.1687224242E+00, 2.3569704671E+00, 8.7867701021E-01],
	[2.3620000000E+04, 1.8988526020E+01, 5.6140992233E+00, 5.1722910844E+00, 2.3577995353E+00, 8.7874227576E-01],
	[2.3625000000E+04, 1.8994856980E+01, 5.6140405231E+00, 5.1758614522E+00, 2.3586284664E+00, 8.7880750720E-01],
	[2.3630000000E+04, 1.9001188710E+01, 5.6139818360E+00, 5.1794335279E+00, 2.3594572602E+00, 8.7887270453E-01],
	[2.3635000000E+04, 1.9007521210E+01, 5.6139231620E+00, 5.1830073120E+00, 2.3602859166E+00, 8.7893786779E-01],
	[2.3640000000E+04, 1.9013854480E+01, 5.6138645009E+00, 5.1865828049E+00, 2.3611144355E+00, 8.7900299698E-01],
	[2.3645000000E+04, 1.9020188521E+01, 5.6138058529E+00, 5.1901600071E+00, 2.3619428168E+00, 8.7906809211E-01],
	[2.3650000000E+04, 1.9026523332E+01, 5.6137472179E+00, 5.1937389191E+00, 2.3627710603E+00, 8.7913315321E-01],
	[2.3655000000E+04, 1.9032858913E+01, 5.6136885959E+00, 5.1973195413E+00, 2.3635991660E+00, 8.7919818029E-01],
	[2.3660000000E+04, 1.9039195263E+01, 5.6136299869E+00, 5.2009018741E+00, 2.3644271336E+00, 8.7926317336E-01],
	[2.3665000000E+04, 1.9045532384E+01, 5.6135713909E+00, 5.2044859180E+00, 2.3652549632E+00, 8.7932813244E-01],
	[2.3670000000E+04, 1.9051870275E+01, 5.6135128079E+00, 5.2080716736E+00, 2.3660826546E+00, 8.7939305755E-01],
	[2.3675000000E+04, 1.9058208935E+01, 5.6134542379E+00, 5.2116591411E+00, 2.3669102076E+00, 8.7945794869E-01],
	[2.3680000000E+04, 1.9064548365E+01, 5.6133956808E+00, 5.2152483212E+00, 2.3677376222E+00, 8.7952280590E-01],
	[2.3685000000E+04, 1.9070888564E+01, 5.6133371368E+00, 5.2188392142E+00, 2.3685648982E+00, 8.7958762917E-01],
	[2.3690000000E+04, 1.9077229534E+01, 5.6132786057E+00, 5.2224318205E+00, 2.3693920355E+00, 8.7965241853E-01],
	[2.3695000000E+04, 1.9083571272E+01, 5.6132200875E+00, 5.2260261408E+00, 2.3702190340E+00, 8.7971717400E-01],
	[2.3700000000E+04, 1.9089913780E+01, 5.6131615823E+00, 5.2296221753E+00, 2.3710458936E+00, 8.7978189558E-01],
	[2.3705000000E+04, 1.9096257058E+01, 5.6131030901E+00, 5.2332199246E+00, 2.3718726141E+00, 8.7984658329E-01],
	[2.3710000000E+04, 1.9102601105E+01, 5.6130446108E+00, 5.2368193891E+00, 2.3726991955E+00, 8.7991123716E-01],
	[2.3715000000E+04, 1.9108945920E+01, 5.6129861445E+00, 5.2404205693E+00, 2.3735256375E+00, 8.7997585719E-01],
	[2.3720000000E+04, 1.9115291506E+01, 5.6129276910E+00, 5.2440234656E+00, 2.3743519402E+00, 8.8004044340E-01],
	[2.3725000000E+04, 1.9121637860E+01, 5.6128692506E+00, 5.2476280785E+00, 2.3751781034E+00, 8.8010499580E-01],
	[2.3730000000E+04, 1.9127984983E+01, 5.6128108230E+00, 5.2512344084E+00, 2.3760041270E+00, 8.8016951442E-01],
	[2.3735000000E+04, 1.9134332875E+01, 5.6127524083E+00, 5.2548424558E+00, 2.3768300108E+00, 8.8023399927E-01],
	[2.3740000000E+04, 1.9140681536E+01, 5.6126940066E+00, 5.2584522212E+00, 2.3776557547E+00, 8.8029845035E-01],
	[2.3745000000E+04, 1.9147030966E+01, 5.6126356178E+00, 5.2620637050E+00, 2.3784813587E+00, 8.8036286770E-01],
	[2.3750000000E+04, 1.9153381164E+01, 5.6125772419E+00, 5.2656769076E+00, 2.3793068226E+00, 8.8042725131E-01],
	[2.3755000000E+04, 1.9159732131E+01, 5.6125188788E+00, 5.2692918296E+00, 2.3801321462E+00, 8.8049160122E-01],
	[2.3760000000E+04, 1.9166083867E+01, 5.6124605287E+00, 5.2729084713E+00, 2.3809573296E+00, 8.8055591743E-01],
	[2.3765000000E+04, 1.9172436371E+01, 5.6124021914E+00, 5.2765268333E+00, 2.3817823725E+00, 8.8062019997E-01],
	[2.3770000000E+04, 1.9178789644E+01, 5.6123438671E+00, 5.2801469159E+00, 2.3826072748E+00, 8.8068444883E-01],
	[2.3775000000E+04, 1.9185143685E+01, 5.6122855555E+00, 5.2837687197E+00, 2.3834320365E+00, 8.8074866404E-01],
	[2.3780000000E+04, 1.9191498495E+01, 5.6122272569E+00, 5.2873922451E+00, 2.3842566574E+00, 8.8081284562E-01],
	[2.3785000000E+04, 1.9197854072E+01, 5.6121689711E+00, 5.2910174925E+00, 2.3850811374E+00, 8.8087699356E-01],
	[2.3790000000E+04, 1.9204210418E+01, 5.6121106982E+00, 5.2946444625E+00, 2.3859054763E+00, 8.8094110789E-01],
	[2.3795000000E+04, 1.9210567532E+01, 5.6120524381E+00, 5.2982731554E+00, 2.3867296742E+00, 8.8100518861E-01],
	[2.3800000000E+04, 1.9216925414E+01, 5.6119941909E+00, 5.3019035717E+00, 2.3875537308E+00, 8.8106923575E-01],
	[2.3805000000E+04, 1.9223284064E+01, 5.6119359565E+00, 5.3055357119E+00, 2.3883776460E+00, 8.8113324931E-01],
	[2.3810000000E+04, 1.9229643482E+01, 5.6118777350E+00, 5.3091695764E+00, 2.3892014198E+00, 8.8119722931E-01],
	[2.3815000000E+04, 1.9236003668E+01, 5.6118195263E+00, 5.3128051658E+00, 2.3900250520E+00, 8.8126117576E-01],
	[2.3820000000E+04, 1.9242364622E+01, 5.6117613304E+00, 5.3164424803E+00, 2.3908485425E+00, 8.8132508868E-01],
	[2.3825000000E+04, 1.9248726343E+01, 5.6117031473E+00, 5.3200815206E+00, 2.3916718912E+00, 8.8138896807E-01],
	[2.3830000000E+04, 1.9255088832E+01, 5.6116449770E+00, 5.3237222870E+00, 2.3924950979E+00, 8.8145281395E-01],
	[2.3835000000E+04, 1.9261452088E+01, 5.6115868196E+00, 5.3273647801E+00, 2.3933181627E+00, 8.8151662633E-01],
	[2.3840000000E+04, 1.9267816112E+01, 5.6115286749E+00, 5.3310090002E+00, 2.3941410852E+00, 8.8158040523E-01],
	[2.3845000000E+04, 1.9274180903E+01, 5.6114705431E+00, 5.3346549478E+00, 2.3949638655E+00, 8.8164415066E-01],
	[2.3850000000E+04, 1.9280546462E+01, 5.6114124240E+00, 5.3383026234E+00, 2.3957865034E+00, 8.8170786263E-01],
	[2.3855000000E+04, 1.9286912788E+01, 5.6113543177E+00, 5.3419520275E+00, 2.3966089989E+00, 8.8177154116E-01],
	[2.3860000000E+04, 1.9293279881E+01, 5.6112962242E+00, 5.3456031604E+00, 2.3974313517E+00, 8.8183518625E-01],
	[2.3865000000E+04, 1.9299647742E+01, 5.6112381435E+00, 5.3492560227E+00, 2.3982535618E+00, 8.8189879793E-01],
	[2.3870000000E+04, 1.9306016369E+01, 5.6111800755E+00, 5.3529106148E+00, 2.3990756291E+00, 8.8196237621E-01],
	[2.3875000000E+04, 1.9312385764E+01, 5.6111220203E+00, 5.3565669371E+00, 2.3998975534E+00, 8.8202592109E-01],
	[2.3880000000E+04, 1.9318755925E+01, 5.6110639778E+00, 5.3602249902E+00, 2.4007193347E+00, 8.8208943259E-01],
	[2.3885000000E+04, 1.9325126854E+01, 5.6110059481E+00, 5.3638847745E+00, 2.4015409729E+00, 8.8215291073E-01],
	[2.3890000000E+04, 1.9331498549E+01, 5.6109479312E+00, 5.3675462904E+00, 2.4023624677E+00, 8.8221635552E-01],
	[2.3895000000E+04, 1.9337871011E+01, 5.6108899270E+00, 5.3712095383E+00, 2.4031838192E+00, 8.8227976697E-01],
	[2.3900000000E+04, 1.9344244239E+01, 5.6108319355E+00, 5.3748745188E+00, 2.4040050272E+00, 8.8234314510E-01],
	[2.3905000000E+04, 1.9350618234E+01, 5.6107739568E+00, 5.3785412324E+00, 2.4048260915E+00, 8.8240648991E-01],
	[2.3910000000E+04, 1.9356992996E+01, 5.6107159908E+00, 5.3822096793E+00, 2.4056470122E+00, 8.8246980142E-01],
	[2.3915000000E+04, 1.9363368524E+01, 5.6106580375E+00, 5.3858798602E+00, 2.4064677890E+00, 8.8253307965E-01],
	[2.3920000000E+04, 1.9369770459E+01, 5.6106038202E+00, 5.3895517755E+00, 2.4072895033E+00, 8.8259632461E-01],
	[2.3925000000E+04, 1.9376176518E+01, 5.6105501008E+00, 5.3932254256E+00, 2.4081112159E+00, 8.8265953631E-01],
	[2.3930000000E+04, 1.9382583357E+01, 5.6104963931E+00, 5.3969008109E+00, 2.4089327854E+00, 8.8272271477E-01],
	[2.3935000000E+04, 1.9388990975E+01, 5.6104426972E+00, 5.4005779320E+00, 2.4097542117E+00, 8.8278585999E-01],
	[2.3940000000E+04, 1.9395399372E+01, 5.6103890130E+00, 5.4042567893E+00, 2.4105754948E+00, 8.8284897200E-01],
	[2.3945000000E+04, 1.9401808549E+01, 5.6103353405E+00, 5.4079373833E+00, 2.4113966346E+00, 8.8291205080E-01],
	[2.3950000000E+04, 1.9408218504E+01, 5.6102816797E+00, 5.4116197144E+00, 2.4122176309E+00, 8.8297509641E-01],
	[2.3955000000E+04, 1.9414629239E+01, 5.6102280306E+00, 5.4153037830E+00, 2.4130384836E+00, 8.8303810884E-01],
	[2.3960000000E+04, 1.9421040752E+01, 5.6101743933E+00, 5.4189895897E+00, 2.4138591926E+00, 8.8310108811E-01],
	[2.3965000000E+04, 1.9427453045E+01, 5.6101207676E+00, 5.4226771348E+00, 2.4146797578E+00, 8.8316403422E-01],
	[2.3970000000E+04, 1.9433866116E+01, 5.6100671537E+00, 5.4263664189E+00, 2.4155001791E+00, 8.8322694720E-01],
	[2.3975000000E+04, 1.9440279965E+01, 5.6100135514E+00, 5.4300574424E+00, 2.4163204564E+00, 8.8328982705E-01],
	[2.3980000000E+04, 1.9446694594E+01, 5.6099599608E+00, 5.4337502057E+00, 2.4171405896E+00, 8.8335267380E-01],
	[2.3985000000E+04, 1.9453110001E+01, 5.6099063820E+00, 5.4374447093E+00, 2.4179605786E+00, 8.8341548744E-01],
	[2.3990000000E+04, 1.9459526187E+01, 5.6098528148E+00, 5.4411409537E+00, 2.4187804232E+00, 8.8347826801E-01],
	[2.3995000000E+04, 1.9465943151E+01, 5.6097992592E+00, 5.4448389393E+00, 2.4196001233E+00, 8.8354101550E-01],
	[2.4000000000E+04, 1.9472360893E+01, 5.6097457154E+00, 5.4485386666E+00, 2.4204196789E+00, 8.8360372993E-01],
	[2.4005000000E+04, 1.9478779414E+01, 5.6096921832E+00, 5.4522401360E+00, 2.4212390898E+00, 8.8366641133E-01],
	[2.4010000000E+04, 1.9485198713E+01, 5.6096386627E+00, 5.4559433481E+00, 2.4220583560E+00, 8.8372905969E-01],
	[2.4015000000E+04, 1.9491618790E+01, 5.6095851538E+00, 5.4596483031E+00, 2.4228774773E+00, 8.8379167503E-01],
	[2.4020000000E+04, 1.9498039645E+01, 5.6095316565E+00, 5.4633550017E+00, 2.4236964535E+00, 8.8385425738E-01],
	[2.4025000000E+04, 1.9504461279E+01, 5.6094781710E+00, 5.4670634442E+00, 2.4245152847E+00, 8.8391680673E-01],
	[2.4030000000E+04, 1.9510883690E+01, 5.6094246970E+00, 5.4707736312E+00, 2.4253339707E+00, 8.8397932311E-01],
	[2.4035000000E+04, 1.9517306879E+01, 5.6093712347E+00, 5.4744855630E+00, 2.4261525114E+00, 8.8404180653E-01],
	[2.4040000000E+04, 1.9523730846E+01, 5.6093177840E+00, 5.4781992402E+00, 2.4269709066E+00, 8.8410425699E-01],
	[2.4045000000E+04, 1.9530155591E+01, 5.6092643450E+00, 5.4819146632E+00, 2.4277891564E+00, 8.8416667453E-01],
	[2.4050000000E+04, 1.9536581114E+01, 5.6092109176E+00, 5.4856318324E+00, 2.4286072604E+00, 8.8422905914E-01],
	[2.4055000000E+04, 1.9543007414E+01, 5.6091575017E+00, 5.4893507483E+00, 2.4294252188E+00, 8.8429141085E-01],
	[2.4060000000E+04, 1.9549434492E+01, 5.6091040975E+00, 5.4930714114E+00, 2.4302430313E+00, 8.8435372966E-01],
	[2.4065000000E+04, 1.9555862347E+01, 5.6090507049E+00, 5.4967938221E+00, 2.4310606979E+00, 8.8441601559E-01],
	[2.4070000000E+04, 1.9562290980E+01, 5.6089973239E+00, 5.5005179809E+00, 2.4318782184E+00, 8.8447826865E-01],
	[2.4075000000E+04, 1.9568720390E+01, 5.6089439545E+00, 5.5042438882E+00, 2.4326955927E+00, 8.8454048886E-01],
	[2.4080000000E+04, 1.9575150577E+01, 5.6088905967E+00, 5.5079715445E+00, 2.4335128208E+00, 8.8460267623E-01],
	[2.4085000000E+04, 1.9581581542E+01, 5.6088372505E+00, 5.5117009503E+00, 2.4343299025E+00, 8.8466483078E-01],
	[2.4090000000E+04, 1.9588013284E+01, 5.6087839158E+00, 5.5154321060E+00, 2.4351468377E+00, 8.8472695251E-01],
	[2.4095000000E+04, 1.9594445803E+01, 5.6087305927E+00, 5.5191650120E+00, 2.4359636263E+00, 8.8478904145E-01],
	[2.4100000000E+04, 1.9600879099E+01, 5.6086772812E+00, 5.5228996689E+00, 2.4367802682E+00, 8.8485109760E-01],
	[2.4105000000E+04, 1.9607313172E+01, 5.6086239813E+00, 5.5266360770E+00, 2.4375967633E+00, 8.8491312098E-01],
	[2.4110000000E+04, 1.9613748022E+01, 5.6085706929E+00, 5.5303742369E+00, 2.4384131116E+00, 8.8497511160E-01],
	[2.4115000000E+04, 1.9620183648E+01, 5.6085174161E+00, 5.5341141489E+00, 2.4392293128E+00, 8.8503706948E-01],
	[2.4120000000E+04, 1.9626620052E+01, 5.6084641508E+00, 5.5378558137E+00, 2.4400453669E+00, 8.8509899463E-01],
	[2.4125000000E+04, 1.9633057232E+01, 5.6084108971E+00, 5.5415992315E+00, 2.4408612738E+00, 8.8516088706E-01],
	[2.4130000000E+04, 1.9639495189E+01, 5.6083576549E+00, 5.5453444029E+00, 2.4416770334E+00, 8.8522274679E-01],
	[2.4135000000E+04, 1.9645933922E+01, 5.6083044243E+00, 5.5490913283E+00, 2.4424926456E+00, 8.8528457383E-01],
	[2.4140000000E+04, 1.9652373432E+01, 5.6082512052E+00, 5.5528400082E+00, 2.4433081102E+00, 8.8534636820E-01],
	[2.4145000000E+04, 1.9658813718E+01, 5.6081979976E+00, 5.5565904431E+00, 2.4441234272E+00, 8.8540812990E-01],
	[2.4150000000E+04, 1.9665254781E+01, 5.6081448015E+00, 5.5603426333E+00, 2.4449385965E+00, 8.8546985896E-01],
	[2.4155000000E+04, 1.9671696619E+01, 5.6080916170E+00, 5.5640965794E+00, 2.4457536179E+00, 8.8553155539E-01],
	[2.4160000000E+04, 1.9678139235E+01, 5.6080384439E+00, 5.5678522818E+00, 2.4465684914E+00, 8.8559321919E-01],
	[2.4165000000E+04, 1.9684582626E+01, 5.6079852824E+00, 5.5716097410E+00, 2.4473832168E+00, 8.8565485039E-01],
	[2.4170000000E+04, 1.9691026793E+01, 5.6079321324E+00, 5.5753689574E+00, 2.4481977941E+00, 8.8571644900E-01],
	[2.4175000000E+04, 1.9697471737E+01, 5.6078789939E+00, 5.5791299316E+00, 2.4490122231E+00, 8.8577801503E-01],
	[2.4180000000E+04, 1.9703917456E+01, 5.6078258668E+00, 5.5828926638E+00, 2.4498265038E+00, 8.8583954849E-01],
	[2.4185000000E+04, 1.9710363951E+01, 5.6077727513E+00, 5.5866571546E+00, 2.4506406361E+00, 8.8590104941E-01],
	[2.4190000000E+04, 1.9716811222E+01, 5.6077196472E+00, 5.5904234046E+00, 2.4514546197E+00, 8.8596251778E-01],
	[2.4195000000E+04, 1.9723259269E+01, 5.6076665546E+00, 5.5941914140E+00, 2.4522684547E+00, 8.8602395364E-01],
	[2.4200000000E+04, 1.9729708092E+01, 5.6076134735E+00, 5.5979611834E+00, 2.4530821410E+00, 8.8608535698E-01],
	[2.4205000000E+04, 1.9736157690E+01, 5.6075604039E+00, 5.6017327132E+00, 2.4538956784E+00, 8.8614672783E-01],
	[2.4210000000E+04, 1.9742608064E+01, 5.6075073457E+00, 5.6055060040E+00, 2.4547090668E+00, 8.8620806620E-01],
	[2.4215000000E+04, 1.9749059213E+01, 5.6074542990E+00, 5.6092810560E+00, 2.4555223061E+00, 8.8626937210E-01],
	[2.4220000000E+04, 1.9755511138E+01, 5.6074012637E+00, 5.6130578699E+00, 2.4563353963E+00, 8.8633064555E-01],
	[2.4225000000E+04, 1.9761963838E+01, 5.6073482399E+00, 5.6168364461E+00, 2.4571483372E+00, 8.8639188656E-01],
	[2.4230000000E+04, 1.9768417313E+01, 5.6072952275E+00, 5.6206167850E+00, 2.4579611288E+00, 8.8645309514E-01],
	[2.4235000000E+04, 1.9774871563E+01, 5.6072422266E+00, 5.6243988870E+00, 2.4587737708E+00, 8.8651427131E-01],
	[2.4240000000E+04, 1.9781326589E+01, 5.6071892370E+00, 5.6281827527E+00, 2.4595862633E+00, 8.8657541509E-01],
	[2.4245000000E+04, 1.9787782390E+01, 5.6071362590E+00, 5.6319683825E+00, 2.4603986061E+00, 8.8663652648E-01],
	[2.4250000000E+04, 1.9794238966E+01, 5.6070832923E+00, 5.6357557769E+00, 2.4612107992E+00, 8.8669760549E-01],
	[2.4255000000E+04, 1.9800696316E+01, 5.6070303371E+00, 5.6395449363E+00, 2.4620228423E+00, 8.8675865216E-01],
	[2.4260000000E+04, 1.9807154442E+01, 5.6069773933E+00, 5.6433358611E+00, 2.4628347355E+00, 8.8681966648E-01],
	[2.4265000000E+04, 1.9813613342E+01, 5.6069244609E+00, 5.6471285519E+00, 2.4636464786E+00, 8.8688064847E-01],
	[2.4270000000E+04, 1.9820073018E+01, 5.6068715399E+00, 5.6509230090E+00, 2.4644580715E+00, 8.8694159815E-01],
	[2.4275000000E+04, 1.9826533468E+01, 5.6068186303E+00, 5.6547192331E+00, 2.4652695142E+00, 8.8700251553E-01],
	[2.4280000000E+04, 1.9832994692E+01, 5.6067657321E+00, 5.6585172244E+00, 2.4660808065E+00, 8.8706340062E-01],
	[2.4285000000E+04, 1.9839456691E+01, 5.6067128453E+00, 5.6623169835E+00, 2.4668919483E+00, 8.8712425344E-01],
	[2.4290000000E+04, 1.9845919465E+01, 5.6066599699E+00, 5.6661185108E+00, 2.4677029395E+00, 8.8718507401E-01],
	[2.4295000000E+04, 1.9852383013E+01, 5.6066071058E+00, 5.6699218068E+00, 2.4685137800E+00, 8.8724586232E-01],
	[2.4300000000E+04, 1.9858847335E+01, 5.6065542532E+00, 5.6737268719E+00, 2.4693244698E+00, 8.8730661841E-01],
	[2.4305000000E+04, 1.9865338095E+01, 5.6065050741E+00, 5.6775337066E+00, 2.4701361164E+00, 8.8736734228E-01],
	[2.4310000000E+04, 1.9871833045E+01, 5.6064563912E+00, 5.6813423114E+00, 2.4709477600E+00, 8.8742803395E-01],
	[2.4315000000E+04, 1.9878328782E+01, 5.6064077188E+00, 5.6851526867E+00, 2.4717592536E+00, 8.8748869344E-01],
	[2.4320000000E+04, 1.9884825307E+01, 5.6063590569E+00, 5.6889648330E+00, 2.4725705972E+00, 8.8754932074E-01],
	[2.4325000000E+04, 1.9891322618E+01, 5.6063104053E+00, 5.6927787507E+00, 2.4733817906E+00, 8.8760991589E-01],
	[2.4330000000E+04, 1.9897820717E+01, 5.6062617642E+00, 5.6965944403E+00, 2.4741928337E+00, 8.8767047889E-01],
	[2.4335000000E+04, 1.9904319602E+01, 5.6062131335E+00, 5.7004119022E+00, 2.4750037265E+00, 8.8773100976E-01],
	[2.4340000000E+04, 1.9910819274E+01, 5.6061645132E+00, 5.7042311370E+00, 2.4758144689E+00, 8.8779150852E-01],
	[2.4345000000E+04, 1.9917319733E+01, 5.6061159033E+00, 5.7080521450E+00, 2.4766250607E+00, 8.8785197517E-01],
	[2.4350000000E+04, 1.9923820978E+01, 5.6060673038E+00, 5.7118749267E+00, 2.4774355018E+00, 8.8791240972E-01],
	[2.4355000000E+04, 1.9930323010E+01, 5.6060187148E+00, 5.7156994827E+00, 2.4782457922E+00, 8.8797281221E-01],
	[2.4360000000E+04, 1.9936825829E+01, 5.6059701361E+00, 5.7195258132E+00, 2.4790559318E+00, 8.8803318263E-01],
	[2.4365000000E+04, 1.9943329434E+01, 5.6059215678E+00, 5.7233539189E+00, 2.4798659204E+00, 8.8809352101E-01],
	[2.4370000000E+04, 1.9949833826E+01, 5.6058730099E+00, 5.7271838001E+00, 2.4806757580E+00, 8.8815382735E-01],
	[2.4375000000E+04, 1.9956339003E+01, 5.6058244623E+00, 5.7310154574E+00, 2.4814854444E+00, 8.8821410167E-01],
	[2.4380000000E+04, 1.9962844968E+01, 5.6057759252E+00, 5.7348488911E+00, 2.4822949796E+00, 8.8827434399E-01],
	[2.4385000000E+04, 1.9969351718E+01, 5.6057273984E+00, 5.7386841018E+00, 2.4831043635E+00, 8.8833455432E-01],
	[2.4390000000E+04, 1.9975859254E+01, 5.6056788820E+00, 5.7425210898E+00, 2.4839135960E+00, 8.8839473267E-01],
	[2.4395000000E+04, 1.9982367577E+01, 5.6056303760E+00, 5.7463598558E+00, 2.4847226770E+00, 8.8845487906E-01],
	[2.4400000000E+04, 1.9988876685E+01, 5.6055818803E+00, 5.7502004000E+00, 2.4855316063E+00, 8.8851499350E-01],
	[2.4405000000E+04, 1.9995386580E+01, 5.6055333949E+00, 5.7540427230E+00, 2.4863403839E+00, 8.8857507601E-01],
	[2.4410000000E+04, 2.0001897260E+01, 5.6054849200E+00, 5.7578868252E+00, 2.4871490097E+00, 8.8863512659E-01],
	[2.4415000000E+04, 2.0008408727E+01, 5.6054364553E+00, 5.7617327071E+00, 2.4879574836E+00, 8.8869514527E-01],
	[2.4420000000E+04, 2.0014920978E+01, 5.6053880011E+00, 5.7655803692E+00, 2.4887658055E+00, 8.8875513206E-01],
	[2.4425000000E+04, 2.0021434016E+01, 5.6053395571E+00, 5.7694298119E+00, 2.4895739753E+00, 8.8881508697E-01],
	[2.4430000000E+04, 2.0027947839E+01, 5.6052911235E+00, 5.7732810356E+00, 2.4903819929E+00, 8.8887501002E-01],
	[2.4435000000E+04, 2.0034462448E+01, 5.6052427002E+00, 5.7771340409E+00, 2.4911898582E+00, 8.8893490122E-01],
	[2.4440000000E+04, 2.0040977842E+01, 5.6051942873E+00, 5.7809888281E+00, 2.4919975712E+00, 8.8899476059E-01],
	[2.4445000000E+04, 2.0047494022E+01, 5.6051458846E+00, 5.7848453978E+00, 2.4928051316E+00, 8.8905458813E-01],
	[2.4450000000E+04, 2.0054010987E+01, 5.6050974923E+00, 5.7887037504E+00, 2.4936125395E+00, 8.8911438387E-01],
	[2.4455000000E+04, 2.0060528737E+01, 5.6050491103E+00, 5.7925638864E+00, 2.4944197947E+00, 8.8917414781E-01],
	[2.4460000000E+04, 2.0067047273E+01, 5.6050007386E+00, 5.7964258062E+00, 2.4952268972E+00, 8.8923387998E-01],
	[2.4465000000E+04, 2.0073566594E+01, 5.6049523772E+00, 5.8002895102E+00, 2.4960338468E+00, 8.8929358039E-01],
	[2.4470000000E+04, 2.0080086699E+01, 5.6049040261E+00, 5.8041549990E+00, 2.4968406434E+00, 8.8935324904E-01],
	[2.4475000000E+04, 2.0086607590E+01, 5.6048556853E+00, 5.8080222731E+00, 2.4976472870E+00, 8.8941288596E-01],
	[2.4480000000E+04, 2.0093129266E+01, 5.6048073548E+00, 5.8118913327E+00, 2.4984537775E+00, 8.8947249116E-01],
	[2.4485000000E+04, 2.0099651727E+01, 5.6047590346E+00, 5.8157621785E+00, 2.4992601147E+00, 8.8953206465E-01],
	[2.4490000000E+04, 2.0106174972E+01, 5.6047107247E+00, 5.8196348109E+00, 2.5000662987E+00, 8.8959160645E-01],
	[2.4495000000E+04, 2.0112699002E+01, 5.6046624250E+00, 5.8235092302E+00, 2.5008723291E+00, 8.8965111657E-01],
	[2.4500000000E+04, 2.0119223817E+01, 5.6046141356E+00, 5.8273854371E+00, 2.5016782061E+00, 8.8971059503E-01],
	[2.4505000000E+04, 2.0125749417E+01, 5.6045658565E+00, 5.8312634320E+00, 2.5024839295E+00, 8.8977004184E-01],
	[2.4510000000E+04, 2.0132275801E+01, 5.6045175877E+00, 5.8351432152E+00, 2.5032894991E+00, 8.8982945701E-01],
	[2.4515000000E+04, 2.0138802970E+01, 5.6044693291E+00, 5.8390247874E+00, 2.5040949150E+00, 8.8988884056E-01],
	[2.4520000000E+04, 2.0145330923E+01, 5.6044210808E+00, 5.8429081489E+00, 2.5049001770E+00, 8.8994819251E-01],
	[2.4525000000E+04, 2.0151859660E+01, 5.6043728427E+00, 5.8467933001E+00, 2.5057052850E+00, 8.9000751286E-01],
	[2.4530000000E+04, 2.0158389182E+01, 5.6043246149E+00, 5.8506802416E+00, 2.5065102390E+00, 8.9006680164E-01],
	[2.4535000000E+04, 2.0164919488E+01, 5.6042763973E+00, 5.8545689739E+00, 2.5073150387E+00, 8.9012605885E-01],
	[2.4540000000E+04, 2.0171450578E+01, 5.6042281899E+00, 5.8584594973E+00, 2.5081196843E+00, 8.9018528451E-01],
	[2.4545000000E+04, 2.0177982452E+01, 5.6041799928E+00, 5.8623518123E+00, 2.5089241755E+00, 8.9024447864E-01],
	[2.4550000000E+04, 2.0184515110E+01, 5.6041318060E+00, 5.8662459194E+00, 2.5097285122E+00, 8.9030364125E-01],
	[2.4555000000E+04, 2.0191048552E+01, 5.6040836293E+00, 5.8701418191E+00, 2.5105326944E+00, 8.9036277235E-01],
	[2.4560000000E+04, 2.0197582778E+01, 5.6040354629E+00, 5.8740395118E+00, 2.5113367220E+00, 8.9042187196E-01],
	[2.4565000000E+04, 2.0204117788E+01, 5.6039873067E+00, 5.8779389979E+00, 2.5121405949E+00, 8.9048094009E-01],
	[2.4570000000E+04, 2.0210653582E+01, 5.6039391607E+00, 5.8818402780E+00, 2.5129443129E+00, 8.9053997676E-01],
	[2.4575000000E+04, 2.0217190159E+01, 5.6038910249E+00, 5.8857433525E+00, 2.5137478761E+00, 8.9059898197E-01],
	[2.4580000000E+04, 2.0223727520E+01, 5.6038428993E+00, 5.8896482218E+00, 2.5145512843E+00, 8.9065795576E-01],
	[2.4585000000E+04, 2.0230265665E+01, 5.6037947840E+00, 5.8935548864E+00, 2.5153545374E+00, 8.9071689812E-01],
	[2.4590000000E+04, 2.0236804593E+01, 5.6037466788E+00, 5.8974633468E+00, 2.5161576353E+00, 8.9077580908E-01],
	[2.4595000000E+04, 2.0243344305E+01, 5.6036985838E+00, 5.9013736034E+00, 2.5169605780E+00, 8.9083468865E-01],
	[2.4600000000E+04, 2.0249884800E+01, 5.6036504990E+00, 5.9052856568E+00, 2.5177633653E+00, 8.9089353684E-01],
	[2.4605000000E+04, 2.0256426078E+01, 5.6036024244E+00, 5.9091995072E+00, 2.5185659972E+00, 8.9095235367E-01],
	[2.4610000000E+04, 2.0262968140E+01, 5.6035543600E+00, 5.9131151553E+00, 2.5193684736E+00, 8.9101113914E-01],
	[2.4615000000E+04, 2.0269510984E+01, 5.6035063057E+00, 5.9170326014E+00, 2.5201707943E+00, 8.9106989329E-01],
	[2.4620000000E+04, 2.0276054612E+01, 5.6034582616E+00, 5.9209518461E+00, 2.5209729593E+00, 8.9112861612E-01],
	[2.4625000000E+04, 2.0282599023E+01, 5.6034102277E+00, 5.9248728898E+00, 2.5217749686E+00, 8.9118730764E-01],
	[2.4630000000E+04, 2.0289144217E+01, 5.6033622040E+00, 5.9287957329E+00, 2.5225768219E+00, 8.9124596787E-01],
	[2.4635000000E+04, 2.0295690194E+01, 5.6033141904E+00, 5.9327203759E+00, 2.5233785193E+00, 8.9130459682E-01],
	[2.4640000000E+04, 2.0302236953E+01, 5.6032661870E+00, 5.9366468193E+00, 2.5241800606E+00, 8.9136319452E-01],
	[2.4645000000E+04, 2.0308784496E+01, 5.6032181937E+00, 5.9405750635E+00, 2.5249814457E+00, 8.9142176096E-01],
	[2.4650000000E+04, 2.0315332821E+01, 5.6031702105E+00, 5.9445051090E+00, 2.5257826746E+00, 8.9148029618E-01],
	[2.4655000000E+04, 2.0321881929E+01, 5.6031222375E+00, 5.9484369562E+00, 2.5265837471E+00, 8.9153880017E-01],
	[2.4660000000E+04, 2.0328431819E+01, 5.6030742747E+00, 5.9523706057E+00, 2.5273846633E+00, 8.9159727296E-01],
	[2.4665000000E+04, 2.0334982492E+01, 5.6030263220E+00, 5.9563060578E+00, 2.5281854229E+00, 8.9165571456E-01],
	[2.4670000000E+04, 2.0341533948E+01, 5.6029783794E+00, 5.9602433131E+00, 2.5289860259E+00, 8.9171412499E-01],
	[2.4675000000E+04, 2.0348086185E+01, 5.6029304469E+00, 5.9641823719E+00, 2.5297864722E+00, 8.9177250425E-01],
	[2.4680000000E+04, 2.0354639206E+01, 5.6028825246E+00, 5.9681232348E+00, 2.5305867618E+00, 8.9183085237E-01],
	[2.4685000000E+04, 2.0361193008E+01, 5.6028346123E+00, 5.9720659022E+00, 2.5313868945E+00, 8.9188916936E-01],
	[2.4690000000E+04, 2.0367747593E+01, 5.6027867102E+00, 5.9760103746E+00, 2.5321868702E+00, 8.9194745523E-01],
	[2.4695000000E+04, 2.0374321662E+01, 5.6027414410E+00, 5.9799566524E+00, 2.5329875141E+00, 8.9200571000E-01],
	[2.4700000000E+04, 2.0380906969E+01, 5.6026976462E+00, 5.9839047361E+00, 2.5337884626E+00, 8.9206393368E-01],
	[2.4705000000E+04, 2.0387493072E+01, 5.6026538605E+00, 5.9878546261E+00, 2.5345892549E+00, 8.9212212629E-01],
	[2.4710000000E+04, 2.0394079969E+01, 5.6026100840E+00, 5.9918063230E+00, 2.5353898911E+00, 8.9218028784E-01],
	[2.4715000000E+04, 2.0400667661E+01, 5.6025663168E+00, 5.9957598271E+00, 2.5361903709E+00, 8.9223841834E-01],
	[2.4720000000E+04, 2.0407256148E+01, 5.6025225587E+00, 5.9997151390E+00, 2.5369906944E+00, 8.9229651782E-01],
	[2.4725000000E+04, 2.0413845430E+01, 5.6024788098E+00, 6.0036722590E+00, 2.5377908613E+00, 8.9235458627E-01],
	[2.4730000000E+04, 2.0420435506E+01, 5.6024350701E+00, 6.0076311877E+00, 2.5385908718E+00, 8.9241262373E-01],
	[2.4735000000E+04, 2.0427026376E+01, 5.6023913396E+00, 6.0115919256E+00, 2.5393907255E+00, 8.9247063020E-01],
	[2.4740000000E+04, 2.0433618041E+01, 5.6023476182E+00, 6.0155544730E+00, 2.5401904225E+00, 8.9252860570E-01],
	[2.4745000000E+04, 2.0440210501E+01, 5.6023039061E+00, 6.0195188304E+00, 2.5409899628E+00, 8.9258655024E-01],
	[2.4750000000E+04, 2.0446803755E+01, 5.6022602031E+00, 6.0234849983E+00, 2.5417893460E+00, 8.9264446384E-01],
	[2.4755000000E+04, 2.0453397803E+01, 5.6022165093E+00, 6.0274529772E+00, 2.5425885723E+00, 8.9270234651E-01],
	[2.4760000000E+04, 2.0459992645E+01, 5.6021728246E+00, 6.0314227675E+00, 2.5433876416E+00, 8.9276019826E-01],
	[2.4765000000E+04, 2.0466588281E+01, 5.6021291492E+00, 6.0353943697E+00, 2.5441865536E+00, 8.9281801912E-01],
	[2.4770000000E+04, 2.0473184712E+01, 5.6020854828E+00, 6.0393677842E+00, 2.5449853084E+00, 8.9287580909E-01],
	[2.4775000000E+04, 2.0479781936E+01, 5.6020418256E+00, 6.0433430115E+00, 2.5457839059E+00, 8.9293356819E-01],
	[2.4780000000E+04, 2.0486379954E+01, 5.6019981776E+00, 6.0473200521E+00, 2.5465823459E+00, 8.9299129643E-01],
	[2.4785000000E+04, 2.0492978767E+01, 5.6019545387E+00, 6.0512989064E+00, 2.5473806284E+00, 8.9304899384E-01],
	[2.4790000000E+04, 2.0499578373E+01, 5.6019109090E+00, 6.0552795749E+00, 2.5481787533E+00, 8.9310666042E-01],
	[2.4795000000E+04, 2.0506178773E+01, 5.6018672884E+00, 6.0592620580E+00, 2.5489767206E+00, 8.9316429618E-01],
	[2.4800000000E+04, 2.0512779966E+01, 5.6018236769E+00, 6.0632463562E+00, 2.5497745301E+00, 8.9322190115E-01],
	[2.4805000000E+04, 2.0519381953E+01, 5.6017800746E+00, 6.0672324700E+00, 2.5505721817E+00, 8.9327947534E-01],
	[2.4810000000E+04, 2.0525984734E+01, 5.6017364814E+00, 6.0712203998E+00, 2.5513696754E+00, 8.9333701875E-01],
	[2.4815000000E+04, 2.0532588308E+01, 5.6016928973E+00, 6.0752101461E+00, 2.5521670111E+00, 8.9339453142E-01],
	[2.4820000000E+04, 2.0539192675E+01, 5.6016493223E+00, 6.0792017093E+00, 2.5529641887E+00, 8.9345201334E-01],
	[2.4825000000E+04, 2.0545797836E+01, 5.6016057565E+00, 6.0831950900E+00, 2.5537612080E+00, 8.9350946454E-01],
	[2.4830000000E+04, 2.0552403790E+01, 5.6015621998E+00, 6.0871902885E+00, 2.5545580691E+00, 8.9356688503E-01],
	[2.4835000000E+04, 2.0559010538E+01, 5.6015186521E+00, 6.0911873054E+00, 2.5553547719E+00, 8.9362427482E-01],
	[2.4840000000E+04, 2.0565618078E+01, 5.6014751136E+00, 6.0951861410E+00, 2.5561513162E+00, 8.9368163394E-01],
	[2.4845000000E+04, 2.0572226412E+01, 5.6014315842E+00, 6.0991867959E+00, 2.5569477020E+00, 8.9373896239E-01],
	[2.4850000000E+04, 2.0578835539E+01, 5.6013880639E+00, 6.1031892705E+00, 2.5577439292E+00, 8.9379626018E-01],
	[2.4855000000E+04, 2.0585445458E+01, 5.6013445526E+00, 6.1071935653E+00, 2.5585399977E+00, 8.9385352734E-01],
	[2.4860000000E+04, 2.0592056171E+01, 5.6013010505E+00, 6.1111996807E+00, 2.5593359074E+00, 8.9391076388E-01],
	[2.4865000000E+04, 2.0598667676E+01, 5.6012575575E+00, 6.1152076172E+00, 2.5601316583E+00, 8.9396796981E-01],
	[2.4870000000E+04, 2.0605279974E+01, 5.6012140735E+00, 6.1192173752E+00, 2.5609272502E+00, 8.9402514514E-01],
	[2.4875000000E+04, 2.0611893065E+01, 5.6011705986E+00, 6.1232289553E+00, 2.5617226831E+00, 8.9408228990E-01],
	[2.4880000000E+04, 2.0618506949E+01, 5.6011271328E+00, 6.1272423579E+00, 2.5625179569E+00, 8.9413940410E-01],
	[2.4885000000E+04, 2.0625121625E+01, 5.6010836760E+00, 6.1312575834E+00, 2.5633130715E+00, 8.9419648774E-01],
	[2.4890000000E+04, 2.0631737093E+01, 5.6010402284E+00, 6.1352746323E+00, 2.5641080269E+00, 8.9425354085E-01],
	[2.4895000000E+04, 2.0638353354E+01, 5.6009967898E+00, 6.1392935050E+00, 2.5649028229E+00, 8.9431056344E-01],
	[2.4900000000E+04, 2.0644970408E+01, 5.6009533602E+00, 6.1433142021E+00, 2.5656974594E+00, 8.9436755553E-01],
	[2.4905000000E+04, 2.0651588254E+01, 5.6009099397E+00, 6.1473367240E+00, 2.5664919365E+00, 8.9442451712E-01],
	[2.4910000000E+04, 2.0658206892E+01, 5.6008665283E+00, 6.1513610711E+00, 2.5672862539E+00, 8.9448144824E-01],
	[2.4915000000E+04, 2.0664826322E+01, 5.6008231259E+00, 6.1553872439E+00, 2.5680804117E+00, 8.9453834890E-01],
	[2.4920000000E+04, 2.0671446544E+01, 5.6007797325E+00, 6.1594152429E+00, 2.5688744097E+00, 8.9459521911E-01],
	[2.4925000000E+04, 2.0678067559E+01, 5.6007363482E+00, 6.1634450686E+00, 2.5696682479E+00, 8.9465205889E-01],
	[2.4930000000E+04, 2.0684689365E+01, 5.6006929729E+00, 6.1674767213E+00, 2.5704619261E+00, 8.9470886825E-01],
	[2.4935000000E+04, 2.0691311963E+01, 5.6006496067E+00, 6.1715102015E+00, 2.5712554443E+00, 8.9476564721E-01],
	[2.4940000000E+04, 2.0697935354E+01, 5.6006062495E+00, 6.1755455098E+00, 2.5720488025E+00, 8.9482239578E-01],
	[2.4945000000E+04, 2.0704559536E+01, 5.6005629013E+00, 6.1795826466E+00, 2.5728420005E+00, 8.9487911398E-01],
	[2.4950000000E+04, 2.0711184509E+01, 5.6005195622E+00, 6.1836216123E+00, 2.5736350382E+00, 8.9493580182E-01],
	[2.4955000000E+04, 2.0717810275E+01, 5.6004762320E+00, 6.1876624074E+00, 2.5744279156E+00, 8.9499245931E-01],
	[2.4960000000E+04, 2.0724436832E+01, 5.6004329109E+00, 6.1917050324E+00, 2.5752206326E+00, 8.9504908648E-01],
	[2.4965000000E+04, 2.0731064181E+01, 5.6003895988E+00, 6.1957494877E+00, 2.5760131891E+00, 8.9510568333E-01],
	[2.4970000000E+04, 2.0737692321E+01, 5.6003462957E+00, 6.1997957737E+00, 2.5768055850E+00, 8.9516224988E-01],
	[2.4975000000E+04, 2.0744321252E+01, 5.6003030016E+00, 6.2038438911E+00, 2.5775978203E+00, 8.9521878615E-01],
	[2.4980000000E+04, 2.0750950975E+01, 5.6002597165E+00, 6.2078938401E+00, 2.5783898949E+00, 8.9527529214E-01],
	[2.4985000000E+04, 2.0757581489E+01, 5.6002164405E+00, 6.2119456213E+00, 2.5791818087E+00, 8.9533176788E-01],
	[2.4990000000E+04, 2.0764212795E+01, 5.6001731734E+00, 6.2159992351E+00, 2.5799735615E+00, 8.9538821338E-01],
	[2.4995000000E+04, 2.0770844891E+01, 5.6001299152E+00, 6.2200546821E+00, 2.5807651534E+00, 8.9544462865E-01],
	[2.5000000000E+04, 2.0777477779E+01, 5.6000866661E+00, 6.2241119625E+00, 2.5815565843E+00, 8.9550101372E-01],
	[2.5005000000E+04, 2.0784111458E+01, 5.6000434260E+00, 6.2281813988E+00, 2.5823496285E+00, 8.9555736858E-01],
	[2.5010000000E+04, 2.0790745928E+01, 5.6000001948E+00, 6.2322526810E+00, 2.5831425109E+00, 8.9561369326E-01],
	[2.5015000000E+04, 2.0797381188E+01, 5.5999569726E+00, 6.2363258094E+00, 2.5839352316E+00, 8.9566998777E-01],
	[2.5020000000E+04, 2.0804017240E+01, 5.5999137594E+00, 6.2404007847E+00, 2.5847277905E+00, 8.9572625213E-01],
	[2.5025000000E+04, 2.0810654082E+01, 5.5998705552E+00, 6.2444776072E+00, 2.5855201873E+00, 8.9578248636E-01],
	[2.5030000000E+04, 2.0817291715E+01, 5.5998273599E+00, 6.2485562774E+00, 2.5863124222E+00, 8.9583869046E-01],
	[2.5035000000E+04, 2.0823930139E+01, 5.5997841736E+00, 6.2526367959E+00, 2.5871044950E+00, 8.9589486445E-01],
	[2.5040000000E+04, 2.0830569353E+01, 5.5997409962E+00, 6.2567191629E+00, 2.5878964055E+00, 8.9595100834E-01],
	[2.5045000000E+04, 2.0837209358E+01, 5.5996978278E+00, 6.2608033791E+00, 2.5886881539E+00, 8.9600712216E-01],
	[2.5050000000E+04, 2.0843850153E+01, 5.5996546684E+00, 6.2648894449E+00, 2.5894797398E+00, 8.9606320591E-01],
	[2.5055000000E+04, 2.0850491739E+01, 5.5996115178E+00, 6.2689773608E+00, 2.5902711634E+00, 8.9611925961E-01],
	[2.5060000000E+04, 2.0857134115E+01, 5.5995683763E+00, 6.2730671272E+00, 2.5910624245E+00, 8.9617528328E-01],
	[2.5065000000E+04, 2.0863777281E+01, 5.5995252436E+00, 6.2771587446E+00, 2.5918535230E+00, 8.9623127693E-01],
	[2.5070000000E+04, 2.0870421238E+01, 5.5994821199E+00, 6.2812522134E+00, 2.5926444588E+00, 8.9628724057E-01],
	[2.5075000000E+04, 2.0877065985E+01, 5.5994390052E+00, 6.2853475342E+00, 2.5934352319E+00, 8.9634317422E-01],
	[2.5080000000E+04, 2.0883711521E+01, 5.5993958993E+00, 6.2894447074E+00, 2.5942258422E+00, 8.9639907789E-01],
	[2.5085000000E+04, 2.0890357848E+01, 5.5993528024E+00, 6.2935437335E+00, 2.5950162896E+00, 8.9645495160E-01],
	[2.5090000000E+04, 2.0897009066E+01, 5.5993102807E+00, 6.2976446129E+00, 2.5958067591E+00, 8.9651079537E-01],
	[2.5095000000E+04, 2.0903686115E+01, 5.5992712236E+00, 6.3017473461E+00, 2.5965981952E+00, 8.9656660920E-01],
	[2.5100000000E+04, 2.0910363966E+01, 5.5992321745E+00, 6.3058519336E+00, 2.5973894692E+00, 8.9662239312E-01],
	[2.5105000000E+04, 2.0917042620E+01, 5.5991931335E+00, 6.3099583758E+00, 2.5981805811E+00, 8.9667814714E-01],
	[2.5110000000E+04, 2.0923722076E+01, 5.5991541005E+00, 6.3140666732E+00, 2.5989715308E+00, 8.9673387126E-01],
	[2.5115000000E+04, 2.0930402334E+01, 5.5991150756E+00, 6.3181768264E+00, 2.5997623182E+00, 8.9678956551E-01],
	[2.5120000000E+04, 2.0937083395E+01, 5.5990760587E+00, 6.3222888356E+00, 2.6005529433E+00, 8.9684522991E-01],
	[2.5125000000E+04, 2.0943765259E+01, 5.5990370499E+00, 6.3264027015E+00, 2.6013434059E+00, 8.9690086446E-01],
	[2.5130000000E+04, 2.0950447924E+01, 5.5989980490E+00, 6.3305184245E+00, 2.6021337060E+00, 8.9695646919E-01],
	[2.5135000000E+04, 2.0957131392E+01, 5.5989590562E+00, 6.3346360050E+00, 2.6029238435E+00, 8.9701204409E-01],
	[2.5140000000E+04, 2.0963815661E+01, 5.5989200715E+00, 6.3387554435E+00, 2.6037138184E+00, 8.9706758920E-01],
	[2.5145000000E+04, 2.0970500733E+01, 5.5988810947E+00, 6.3428767405E+00, 2.6045036305E+00, 8.9712310453E-01],
	[2.5150000000E+04, 2.0977186607E+01, 5.5988421260E+00, 6.3469998965E+00, 2.6052932797E+00, 8.9717859009E-01],
	[2.5155000000E+04, 2.0983873282E+01, 5.5988031653E+00, 6.3511249119E+00, 2.6060827661E+00, 8.9723404589E-01],
	[2.5160000000E+04, 2.0990560760E+01, 5.5987642126E+00, 6.3552517872E+00, 2.6068720895E+00, 8.9728947195E-01],
	[2.5165000000E+04, 2.0997249039E+01, 5.5987252680E+00, 6.3593805229E+00, 2.6076612499E+00, 8.9734486828E-01],
	[2.5170000000E+04, 2.1003938120E+01, 5.5986863313E+00, 6.3635111194E+00, 2.6084502471E+00, 8.9740023491E-01],
	[2.5175000000E+04, 2.1010628002E+01, 5.5986474026E+00, 6.3676435772E+00, 2.6092390812E+00, 8.9745557184E-01],
	[2.5180000000E+04, 2.1017318687E+01, 5.5986084820E+00, 6.3717778968E+00, 2.6100277520E+00, 8.9751087909E-01],
	[2.5185000000E+04, 2.1024010172E+01, 5.5985695693E+00, 6.3759140786E+00, 2.6108162594E+00, 8.9756615667E-01],
	[2.5190000000E+04, 2.1030702460E+01, 5.5985306647E+00, 6.3800521231E+00, 2.6116046034E+00, 8.9762140460E-01],
	[2.5195000000E+04, 2.1037395548E+01, 5.5984917680E+00, 6.3841920308E+00, 2.6123927839E+00, 8.9767662289E-01],
	[2.5200000000E+04, 2.1044089438E+01, 5.5984528793E+00, 6.3883338021E+00, 2.6131808008E+00, 8.9773181156E-01],
	[2.5205000000E+04, 2.1050784129E+01, 5.5984139986E+00, 6.3924774375E+00, 2.6139686541E+00, 8.9778697063E-01],
	[2.5210000000E+04, 2.1057479622E+01, 5.5983751259E+00, 6.3966229375E+00, 2.6147563436E+00, 8.9784210010E-01],
	[2.5215000000E+04, 2.1064175915E+01, 5.5983362611E+00, 6.4007703026E+00, 2.6155438694E+00, 8.9789719999E-01],
	[2.5220000000E+04, 2.1070873010E+01, 5.5982974044E+00, 6.4049195332E+00, 2.6163312313E+00, 8.9795227032E-01],
	[2.5225000000E+04, 2.1077570905E+01, 5.5982585556E+00, 6.4090706298E+00, 2.6171184292E+00, 8.9800731108E-01],
	[2.5230000000E+04, 2.1084269602E+01, 5.5982197148E+00, 6.4132235928E+00, 2.6179054631E+00, 8.9806232231E-01],
	[2.5235000000E+04, 2.1090969099E+01, 5.5981808819E+00, 6.4173784228E+00, 2.6186923330E+00, 8.9811730400E-01],
	[2.5240000000E+04, 2.1097669398E+01, 5.5981420570E+00, 6.4215351201E+00, 2.6194790386E+00, 8.9817225618E-01],
	[2.5245000000E+04, 2.1104370497E+01, 5.5981032401E+00, 6.4256936853E+00, 2.6202655801E+00, 8.9822717885E-01],
	[2.5250000000E+04, 2.1111072397E+01, 5.5980644311E+00, 6.4298541188E+00, 2.6210519572E+00, 8.9828207203E-01],
	[2.5255000000E+04, 2.1117775097E+01, 5.5980256301E+00, 6.4340164212E+00, 2.6218381699E+00, 8.9833693573E-01],
	[2.5260000000E+04, 2.1124478598E+01, 5.5979868370E+00, 6.4381805928E+00, 2.6226242181E+00, 8.9839176997E-01],
	[2.5265000000E+04, 2.1131182900E+01, 5.5979480519E+00, 6.4423466341E+00, 2.6234101019E+00, 8.9844657475E-01],
	[2.5270000000E+04, 2.1137888002E+01, 5.5979092747E+00, 6.4465145457E+00, 2.6241958210E+00, 8.9850135009E-01],
	[2.5275000000E+04, 2.1144593904E+01, 5.5978705054E+00, 6.4506843279E+00, 2.6249813754E+00, 8.9855609600E-01],
	[2.5280000000E+04, 2.1151300607E+01, 5.5978317441E+00, 6.4548559813E+00, 2.6257667651E+00, 8.9861081250E-01],
	[2.5285000000E+04, 2.1158008110E+01, 5.5977929908E+00, 6.4590295063E+00, 2.6265519900E+00, 8.9866549959E-01],
	[2.5290000000E+04, 2.1164716413E+01, 5.5977542453E+00, 6.4632049033E+00, 2.6273370499E+00, 8.9872015730E-01],
	[2.5295000000E+04, 2.1171425516E+01, 5.5977155078E+00, 6.4673821729E+00, 2.6281219449E+00, 8.9877478563E-01],
	[2.5300000000E+04, 2.1178135420E+01, 5.5976767782E+00, 6.4715613156E+00, 2.6289066749E+00, 8.9882938459E-01],
	[2.5305000000E+04, 2.1184846123E+01, 5.5976380565E+00, 6.4757423317E+00, 2.6296912397E+00, 8.9888395420E-01],
	[2.5310000000E+04, 2.1191557627E+01, 5.5975993428E+00, 6.4799252218E+00, 2.6304756394E+00, 8.9893849448E-01],
	[2.5315000000E+04, 2.1198269930E+01, 5.5975606369E+00, 6.4841099863E+00, 2.6312598738E+00, 8.9899300543E-01],
	[2.5320000000E+04, 2.1204983033E+01, 5.5975219390E+00, 6.4882966257E+00, 2.6320439429E+00, 8.9904748706E-01],
	[2.5325000000E+04, 2.1211696936E+01, 5.5974832490E+00, 6.4924851405E+00, 2.6328278465E+00, 8.9910193940E-01],
	[2.5330000000E+04, 2.1218411639E+01, 5.5974445669E+00, 6.4966755311E+00, 2.6336115847E+00, 8.9915636245E-01],
	[2.5335000000E+04, 2.1225127141E+01, 5.5974058927E+00, 6.5008677981E+00, 2.6343951574E+00, 8.9921075622E-01],
	[2.5340000000E+04, 2.1231843443E+01, 5.5973672264E+00, 6.5050619418E+00, 2.6351785645E+00, 8.9926512073E-01],
	[2.5345000000E+04, 2.1238560544E+01, 5.5973285680E+00, 6.5092579627E+00, 2.6359618058E+00, 8.9931945600E-01],
	[2.5350000000E+04, 2.1245278445E+01, 5.5972899174E+00, 6.5134558614E+00, 2.6367448814E+00, 8.9937376203E-01],
	[2.5355000000E+04, 2.1251997145E+01, 5.5972512748E+00, 6.5176556382E+00, 2.6375277912E+00, 8.9942803884E-01],
	[2.5360000000E+04, 2.1258716644E+01, 5.5972126401E+00, 6.5218572937E+00, 2.6383105351E+00, 8.9948228643E-01],
	[2.5365000000E+04, 2.1265436943E+01, 5.5971740132E+00, 6.5260608283E+00, 2.6390931131E+00, 8.9953650483E-01],
	[2.5370000000E+04, 2.1272158041E+01, 5.5971353942E+00, 6.5302662425E+00, 2.6398755250E+00, 8.9959069405E-01],
	[2.5375000000E+04, 2.1278879938E+01, 5.5970967831E+00, 6.5344735368E+00, 2.6406577707E+00, 8.9964485410E-01],
	[2.5380000000E+04, 2.1285602634E+01, 5.5970581799E+00, 6.5386827116E+00, 2.6414398504E+00, 8.9969898498E-01],
	[2.5385000000E+04, 2.1292326129E+01, 5.5970195845E+00, 6.5428937674E+00, 2.6422217637E+00, 8.9975308673E-01],
	[2.5390000000E+04, 2.1299050424E+01, 5.5969809970E+00, 6.5471067047E+00, 2.6430035108E+00, 8.9980715934E-01],
	[2.5395000000E+04, 2.1305775517E+01, 5.5969424174E+00, 6.5513215239E+00, 2.6437850915E+00, 8.9986120283E-01],
	[2.5400000000E+04, 2.1312501408E+01, 5.5969038456E+00, 6.5555382255E+00, 2.6445665057E+00, 8.9991521722E-01],
	[2.5405000000E+04, 2.1319228099E+01, 5.5968652817E+00, 6.5597568100E+00, 2.6453477534E+00, 8.9996920251E-01],
	[2.5410000000E+04, 2.1325955588E+01, 5.5968267256E+00, 6.5639772779E+00, 2.6461288345E+00, 9.0002315872E-01],
	[2.5415000000E+04, 2.1332683876E+01, 5.5967881774E+00, 6.5681996295E+00, 2.6469097489E+00, 9.0007708586E-01],
	[2.5420000000E+04, 2.1339412963E+01, 5.5967496371E+00, 6.5724238655E+00, 2.6476904966E+00, 9.0013098396E-01],
	[2.5425000000E+04, 2.1346142848E+01, 5.5967111046E+00, 6.5766499862E+00, 2.6484710775E+00, 9.0018485301E-01],
	[2.5430000000E+04, 2.1352873531E+01, 5.5966725799E+00, 6.5808779921E+00, 2.6492514916E+00, 9.0023869303E-01],
	[2.5435000000E+04, 2.1359605013E+01, 5.5966340631E+00, 6.5851078838E+00, 2.6500317387E+00, 9.0029250403E-01],
	[2.5440000000E+04, 2.1366337294E+01, 5.5965955541E+00, 6.5893396616E+00, 2.6508118188E+00, 9.0034628604E-01],
	[2.5445000000E+04, 2.1373070372E+01, 5.5965570529E+00, 6.5935733260E+00, 2.6515917319E+00, 9.0040003905E-01],
	[2.5450000000E+04, 2.1379804249E+01, 5.5965185596E+00, 6.5978088776E+00, 2.6523714778E+00, 9.0045376309E-01],
	[2.5455000000E+04, 2.1386538924E+01, 5.5964800741E+00, 6.6020463167E+00, 2.6531510565E+00, 9.0050745816E-01],
	[2.5460000000E+04, 2.1393274397E+01, 5.5964415964E+00, 6.6062856439E+00, 2.6539304679E+00, 9.0056112429E-01],
	[2.5465000000E+04, 2.1400010667E+01, 5.5964031265E+00, 6.6105268596E+00, 2.6547097119E+00, 9.0061476148E-01],
	[2.5470000000E+04, 2.1406747736E+01, 5.5963646645E+00, 6.6147699642E+00, 2.6554887886E+00, 9.0066836974E-01],
	[2.5475000000E+04, 2.1413485603E+01, 5.5963262103E+00, 6.6190149584E+00, 2.6562676978E+00, 9.0072194910E-01],
	[2.5480000000E+04, 2.1420224268E+01, 5.5962877638E+00, 6.6232618424E+00, 2.6570464394E+00, 9.0077549955E-01],
	[2.5485000000E+04, 2.1426963730E+01, 5.5962493252E+00, 6.6275106169E+00, 2.6578250135E+00, 9.0082902112E-01],
	[2.5490000000E+04, 2.1433703990E+01, 5.5962108944E+00, 6.6317612822E+00, 2.6586034198E+00, 9.0088251382E-01],
	[2.5495000000E+04, 2.1440455463E+01, 5.5961738920E+00, 6.6360138389E+00, 2.6593821395E+00, 9.0093597766E-01],
	[2.5500000000E+04, 2.1447226252E+01, 5.5961394213E+00, 6.6402682873E+00, 2.6601615469E+00, 9.0098941266E-01],
	[2.5505000000E+04, 2.1453997851E+01, 5.5961049577E+00, 6.6445246281E+00, 2.6609407875E+00, 9.0104281882E-01],
	[2.5510000000E+04, 2.1460770260E+01, 5.5960705010E+00, 6.6487828616E+00, 2.6617198611E+00, 9.0109619616E-01],
	[2.5515000000E+04, 2.1467543479E+01, 5.5960360512E+00, 6.6530429883E+00, 2.6624987678E+00, 9.0114954470E-01],
	[2.5520000000E+04, 2.1474317508E+01, 5.5960016084E+00, 6.6573050087E+00, 2.6632775075E+00, 9.0120286444E-01],
	[2.5525000000E+04, 2.1481092346E+01, 5.5959671726E+00, 6.6615689232E+00, 2.6640560800E+00, 9.0125615540E-01],
	[2.5530000000E+04, 2.1487867994E+01, 5.5959327438E+00, 6.6658347324E+00, 2.6648344854E+00, 9.0130941760E-01],
	[2.5535000000E+04, 2.1494644453E+01, 5.5958983219E+00, 6.6701024367E+00, 2.6656127235E+00, 9.0136265104E-01],
	[2.5540000000E+04, 2.1501421720E+01, 5.5958639069E+00, 6.6743720365E+00, 2.6663907943E+00, 9.0141585575E-01],
	[2.5545000000E+04, 2.1508199798E+01, 5.5958294989E+00, 6.6786435324E+00, 2.6671686977E+00, 9.0146903172E-01],
	[2.5550000000E+04, 2.1514978684E+01, 5.5957950979E+00, 6.6829169248E+00, 2.6679464337E+00, 9.0152217898E-01],
	[2.5555000000E+04, 2.1521758381E+01, 5.5957607037E+00, 6.6871922142E+00, 2.6687240022E+00, 9.0157529754E-01],
	[2.5560000000E+04, 2.1528538886E+01, 5.5957263166E+00, 6.6914694010E+00, 2.6695014031E+00, 9.0162838741E-01],
	[2.5565000000E+04, 2.1535320201E+01, 5.5956919363E+00, 6.6957484858E+00, 2.6702786364E+00, 9.0168144861E-01],
	[2.5570000000E+04, 2.1542102326E+01, 5.5956575630E+00, 6.7000294689E+00, 2.6710557019E+00, 9.0173448114E-01],
	[2.5575000000E+04, 2.1548885259E+01, 5.5956231967E+00, 6.7043123509E+00, 2.6718325997E+00, 9.0178748503E-01],
	[2.5580000000E+04, 2.1555669002E+01, 5.5955888372E+00, 6.7085971323E+00, 2.6726093297E+00, 9.0184046028E-01],
	[2.5585000000E+04, 2.1562453553E+01, 5.5955544847E+00, 6.7128838134E+00, 2.6733858918E+00, 9.0189340691E-01],
	[2.5590000000E+04, 2.1569238914E+01, 5.5955201391E+00, 6.7171723948E+00, 2.6741622859E+00, 9.0194632493E-01],
	[2.5595000000E+04, 2.1576025084E+01, 5.5954858004E+00, 6.7214628770E+00, 2.6749385119E+00, 9.0199921435E-01],
	[2.5600000000E+04, 2.1582812062E+01, 5.5954514687E+00, 6.7257552603E+00, 2.6757145699E+00, 9.0205207519E-01],
	[2.5605000000E+04, 2.1589599850E+01, 5.5954171438E+00, 6.7300495454E+00, 2.6764904598E+00, 9.0210490746E-01],
	[2.5610000000E+04, 2.1596388446E+01, 5.5953828259E+00, 6.7343457326E+00, 2.6772661814E+00, 9.0215771118E-01],
	[2.5615000000E+04, 2.1603177851E+01, 5.5953485149E+00, 6.7386438224E+00, 2.6780417347E+00, 9.0221048635E-01],
	[2.5620000000E+04, 2.1609968065E+01, 5.5953142108E+00, 6.7429438154E+00, 2.6788171197E+00, 9.0226323299E-01],
	[2.5625000000E+04, 2.1616759087E+01, 5.5952799136E+00, 6.7472457119E+00, 2.6795923363E+00, 9.0231595112E-01],
	[2.5630000000E+04, 2.1623550918E+01, 5.5952456233E+00, 6.7515495124E+00, 2.6803673844E+00, 9.0236864074E-01],
	[2.5635000000E+04, 2.1630343557E+01, 5.5952113399E+00, 6.7558552175E+00, 2.6811422639E+00, 9.0242130188E-01],
	[2.5640000000E+04, 2.1637137005E+01, 5.5951770634E+00, 6.7601628275E+00, 2.6819169749E+00, 9.0247393453E-01],
	[2.5645000000E+04, 2.1643931261E+01, 5.5951427938E+00, 6.7644723430E+00, 2.6826915172E+00, 9.0252653872E-01],
	[2.5650000000E+04, 2.1650726325E+01, 5.5951085310E+00, 6.7687837644E+00, 2.6834658907E+00, 9.0257911447E-01],
	[2.5655000000E+04, 2.1657522197E+01, 5.5950742752E+00, 6.7730970922E+00, 2.6842400955E+00, 9.0263166177E-01],
	[2.5660000000E+04, 2.1664318878E+01, 5.5950400263E+00, 6.7774123269E+00, 2.6850141314E+00, 9.0268418065E-01],
	[2.5665000000E+04, 2.1671116367E+01, 5.5950057842E+00, 6.7817294689E+00, 2.6857879984E+00, 9.0273667112E-01],
	[2.5670000000E+04, 2.1677914664E+01, 5.5949715490E+00, 6.7860485187E+00, 2.6865616965E+00, 9.0278913320E-01],
	[2.5675000000E+04, 2.1684713768E+01, 5.5949373207E+00, 6.7903694768E+00, 2.6873352254E+00, 9.0284156689E-01],
	[2.5680000000E+04, 2.1691513681E+01, 5.5949030993E+00, 6.7946923436E+00, 2.6881085853E+00, 9.0289397221E-01],
	[2.5685000000E+04, 2.1698314402E+01, 5.5948688847E+00, 6.7990171196E+00, 2.6888817760E+00, 9.0294634917E-01],
	[2.5690000000E+04, 2.1705115930E+01, 5.5948346770E+00, 6.8033438054E+00, 2.6896547975E+00, 9.0299869779E-01],
	[2.5695000000E+04, 2.1711918266E+01, 5.5948004762E+00, 6.8076724013E+00, 2.6904276497E+00, 9.0305101807E-01],
	[2.5700000000E+04, 2.1718721410E+01, 5.5947662822E+00, 6.8120029078E+00, 2.6912003325E+00, 9.0310331004E-01],
	[2.5705000000E+04, 2.1725525361E+01, 5.5947320951E+00, 6.8163353254E+00, 2.6919728460E+00, 9.0315557371E-01],
	[2.5710000000E+04, 2.1732330120E+01, 5.5946979149E+00, 6.8206696547E+00, 2.6927451899E+00, 9.0320780908E-01],
	[2.5715000000E+04, 2.1739135687E+01, 5.5946637415E+00, 6.8250058959E+00, 2.6935173643E+00, 9.0326001618E-01],
	[2.5720000000E+04, 2.1745942060E+01, 5.5946295749E+00, 6.8293440497E+00, 2.6942893692E+00, 9.0331219501E-01],
	[2.5725000000E+04, 2.1752749242E+01, 5.5945954152E+00, 6.8336841164E+00, 2.6950612043E+00, 9.0336434559E-01],
	[2.5730000000E+04, 2.1759557230E+01, 5.5945612624E+00, 6.8380260967E+00, 2.6958328698E+00, 9.0341646794E-01],
	[2.5735000000E+04, 2.1766366026E+01, 5.5945271164E+00, 6.8423699908E+00, 2.6966043654E+00, 9.0346856206E-01],
	[2.5740000000E+04, 2.1773175629E+01, 5.5944929772E+00, 6.8467157994E+00, 2.6973756912E+00, 9.0352062796E-01],
	[2.5745000000E+04, 2.1779986039E+01, 5.5944588449E+00, 6.8510635228E+00, 2.6981468471E+00, 9.0357266568E-01],
	[2.5750000000E+04, 2.1786797256E+01, 5.5944247194E+00, 6.8554131616E+00, 2.6989178331E+00, 9.0362467520E-01],
	[2.5755000000E+04, 2.1793609280E+01, 5.5943906008E+00, 6.8597647161E+00, 2.6996886490E+00, 9.0367665656E-01],
	[2.5760000000E+04, 2.1800422111E+01, 5.5943564890E+00, 6.8641181870E+00, 2.7004592949E+00, 9.0372860976E-01],
	[2.5765000000E+04, 2.1807235749E+01, 5.5943223840E+00, 6.8684735747E+00, 2.7012297706E+00, 9.0378053481E-01],
	[2.5770000000E+04, 2.1814050194E+01, 5.5942882858E+00, 6.8728308795E+00, 2.7020000761E+00, 9.0383243173E-01],
	[2.5775000000E+04, 2.1820865446E+01, 5.5942541945E+00, 6.8771901021E+00, 2.7027702113E+00, 9.0388430054E-01],
	[2.5780000000E+04, 2.1827681504E+01, 5.5942201100E+00, 6.8815512428E+00, 2.7035401762E+00, 9.0393614124E-01],
	[2.5785000000E+04, 2.1834498369E+01, 5.5941860323E+00, 6.8859143022E+00, 2.7043099707E+00, 9.0398795385E-01],
	[2.5790000000E+04, 2.1841316040E+01, 5.5941519614E+00, 6.8902792807E+00, 2.7050795948E+00, 9.0403973838E-01],
	[2.5795000000E+04, 2.1848134518E+01, 5.5941178973E+00, 6.8946461788E+00, 2.7058490484E+00, 9.0409149485E-01],
	[2.5800000000E+04, 2.1854953803E+01, 5.5940838401E+00, 6.8990149969E+00, 2.7066183314E+00, 9.0414322327E-01],
	[2.5805000000E+04, 2.1861773894E+01, 5.5940497896E+00, 6.9033857356E+00, 2.7073874438E+00, 9.0419492365E-01],
	[2.5810000000E+04, 2.1868594791E+01, 5.5940157460E+00, 6.9077583953E+00, 2.7081563855E+00, 9.0424659601E-01],
	[2.5815000000E+04, 2.1875416494E+01, 5.5939817091E+00, 6.9121329764E+00, 2.7089251565E+00, 9.0429824036E-01],
	[2.5820000000E+04, 2.1882239004E+01, 5.5939476791E+00, 6.9165094795E+00, 2.7096937567E+00, 9.0434985671E-01],
	[2.5825000000E+04, 2.1889062320E+01, 5.5939136558E+00, 6.9208879050E+00, 2.7104621860E+00, 9.0440144507E-01],
	[2.5830000000E+04, 2.1895886441E+01, 5.5938796393E+00, 6.9252682535E+00, 2.7112304444E+00, 9.0445300547E-01],
	[2.5835000000E+04, 2.1902711369E+01, 5.5938456297E+00, 6.9296505252E+00, 2.7119985319E+00, 9.0450453791E-01],
	[2.5840000000E+04, 2.1909537103E+01, 5.5938116268E+00, 6.9340347208E+00, 2.7127664483E+00, 9.0455604241E-01],
	[2.5845000000E+04, 2.1916363643E+01, 5.5937776307E+00, 6.9384208407E+00, 2.7135341936E+00, 9.0460751897E-01],
	[2.5850000000E+04, 2.1923190988E+01, 5.5937436414E+00, 6.9428088854E+00, 2.7143017678E+00, 9.0465896762E-01],
	[2.5855000000E+04, 2.1930019140E+01, 5.5937096588E+00, 6.9471988553E+00, 2.7150691708E+00, 9.0471038837E-01],
	[2.5860000000E+04, 2.1936848097E+01, 5.5936756831E+00, 6.9515907510E+00, 2.7158364025E+00, 9.0476178123E-01],
	[2.5865000000E+04, 2.1943677860E+01, 5.5936417141E+00, 6.9559845728E+00, 2.7166034629E+00, 9.0481314621E-01],
	[2.5870000000E+04, 2.1950508428E+01, 5.5936077519E+00, 6.9603803213E+00, 2.7173703519E+00, 9.0486448332E-01],
	[2.5875000000E+04, 2.1957339802E+01, 5.5935737964E+00, 6.9647779970E+00, 2.7181370694E+00, 9.0491579259E-01],
	[2.5880000000E+04, 2.1964171981E+01, 5.5935398478E+00, 6.9691776002E+00, 2.7189036155E+00, 9.0496707402E-01],
	[2.5885000000E+04, 2.1971004966E+01, 5.5935059059E+00, 6.9735791316E+00, 2.7196699901E+00, 9.0501832763E-01],
	[2.5890000000E+04, 2.1977838756E+01, 5.5934719707E+00, 6.9779825915E+00, 2.7204361930E+00, 9.0506955344E-01],
	[2.5895000000E+04, 2.1984673352E+01, 5.5934380423E+00, 6.9823879804E+00, 2.7212022243E+00, 9.0512075144E-01],
	[2.5900000000E+04, 2.1991508753E+01, 5.5934041207E+00, 6.9867952988E+00, 2.7219680838E+00, 9.0517192166E-01],
	[2.5905000000E+04, 2.1998352959E+01, 5.5933712847E+00, 6.9912045471E+00, 2.7227341498E+00, 9.0522306412E-01],
	[2.5910000000E+04, 2.2005218662E+01, 5.5933412441E+00, 6.9956157259E+00, 2.7235010223E+00, 9.0527417882E-01],
	[2.5915000000E+04, 2.2012085183E+01, 5.5933112094E+00, 7.0000288357E+00, 2.7242677240E+00, 9.0532526578E-01],
	[2.5920000000E+04, 2.2018952520E+01, 5.5932811807E+00, 7.0044438768E+00, 2.7250342547E+00, 9.0537632501E-01],
	[2.5925000000E+04, 2.2025820676E+01, 5.5932511580E+00, 7.0088608498E+00, 2.7258006144E+00, 9.0542735652E-01],
	[2.5930000000E+04, 2.2032689648E+01, 5.5932211412E+00, 7.0132797551E+00, 2.7265668030E+00, 9.0547836033E-01],
	[2.5935000000E+04, 2.2039559437E+01, 5.5931911303E+00, 7.0177005931E+00, 2.7273328205E+00, 9.0552933646E-01],
	[2.5940000000E+04, 2.2046430044E+01, 5.5931611254E+00, 7.0221233645E+00, 2.7280986669E+00, 9.0558028491E-01],
	[2.5945000000E+04, 2.2053301467E+01, 5.5931311265E+00, 7.0265480696E+00, 2.7288643420E+00, 9.0563120570E-01],
	[2.5950000000E+04, 2.2060173708E+01, 5.5931011335E+00, 7.0309747090E+00, 2.7296298459E+00, 9.0568209884E-01],
	[2.5955000000E+04, 2.2067046765E+01, 5.5930711464E+00, 7.0354032830E+00, 2.7303951784E+00, 9.0573296435E-01],
	[2.5960000000E+04, 2.2073920640E+01, 5.5930411653E+00, 7.0398337922E+00, 2.7311603395E+00, 9.0578380224E-01],
	[2.5965000000E+04, 2.2080795331E+01, 5.5930111901E+00, 7.0442662370E+00, 2.7319253292E+00, 9.0583461252E-01],
	[2.5970000000E+04, 2.2087670838E+01, 5.5929812208E+00, 7.0487006180E+00, 2.7326901474E+00, 9.0588539521E-01],
	[2.5975000000E+04, 2.2094547163E+01, 5.5929512575E+00, 7.0531369355E+00, 2.7334547940E+00, 9.0593615032E-01],
	[2.5980000000E+04, 2.2101424304E+01, 5.5929213000E+00, 7.0575751900E+00, 2.7342192690E+00, 9.0598687786E-01],
	[2.5985000000E+04, 2.2108302261E+01, 5.5928913486E+00, 7.0620153821E+00, 2.7349835723E+00, 9.0603757785E-01],
	[2.5990000000E+04, 2.2115181035E+01, 5.5928614030E+00, 7.0664575122E+00, 2.7357477039E+00, 9.0608825030E-01],
	[2.5995000000E+04, 2.2122060626E+01, 5.5928314634E+00, 7.0709015808E+00, 2.7365116637E+00, 9.0613889523E-01],
	[2.6000000000E+04, 2.2128941033E+01, 5.5928015296E+00, 7.0753475883E+00, 2.7372754517E+00, 9.0618951264E-01],
	[2.6005000000E+04, 2.2135822256E+01, 5.5927716018E+00, 7.0797955352E+00, 2.7380390678E+00, 9.0624010255E-01],
	[2.6010000000E+04, 2.2142704295E+01, 5.5927416799E+00, 7.0842454220E+00, 2.7388025120E+00, 9.0629066498E-01],
	[2.6015000000E+04, 2.2149587151E+01, 5.5927117639E+00, 7.0886972492E+00, 2.7395657842E+00, 9.0634119993E-01],
	[2.6020000000E+04, 2.2156470822E+01, 5.5926818539E+00, 7.0931510172E+00, 2.7403288843E+00, 9.0639170743E-01],
	[2.6025000000E+04, 2.2163355310E+01, 5.5926519497E+00, 7.0976067265E+00, 2.7410918123E+00, 9.0644218749E-01],
	[2.6030000000E+04, 2.2170240614E+01, 5.5926220514E+00, 7.1020643776E+00, 2.7418545682E+00, 9.0649264011E-01],
	[2.6035000000E+04, 2.2177126733E+01, 5.5925921591E+00, 7.1065239709E+00, 2.7426171518E+00, 9.0654306531E-01],
	[2.6040000000E+04, 2.2184013669E+01, 5.5925622726E+00, 7.1109855070E+00, 2.7433795632E+00, 9.0659346311E-01],
	[2.6045000000E+04, 2.2190901420E+01, 5.5925323921E+00, 7.1154489862E+00, 2.7441418022E+00, 9.0664383352E-01],
	[2.6050000000E+04, 2.2197789987E+01, 5.5925025174E+00, 7.1199144092E+00, 2.7449038689E+00, 9.0669417656E-01],
	[2.6055000000E+04, 2.2204679370E+01, 5.5924726486E+00, 7.1243817762E+00, 2.7456657632E+00, 9.0674449223E-01],
	[2.6060000000E+04, 2.2211569569E+01, 5.5924427857E+00, 7.1288510879E+00, 2.7464274850E+00, 9.0679478055E-01],
	[2.6065000000E+04, 2.2218460583E+01, 5.5924129287E+00, 7.1333223447E+00, 2.7471890342E+00, 9.0684504153E-01],
	[2.6070000000E+04, 2.2225352412E+01, 5.5923830776E+00, 7.1377955470E+00, 2.7479504109E+00, 9.0689527519E-01],
	[2.6075000000E+04, 2.2232245057E+01, 5.5923532324E+00, 7.1422706954E+00, 2.7487116149E+00, 9.0694548154E-01],
	[2.6080000000E+04, 2.2239138518E+01, 5.5923233931E+00, 7.1467477903E+00, 2.7494726462E+00, 9.0699566060E-01],
	[2.6085000000E+04, 2.2246032794E+01, 5.5922935596E+00, 7.1512268321E+00, 2.7502335048E+00, 9.0704581237E-01],
	[2.6090000000E+04, 2.2252927885E+01, 5.5922637320E+00, 7.1557078215E+00, 2.7509941906E+00, 9.0709593688E-01],
	[2.6095000000E+04, 2.2259823791E+01, 5.5922339103E+00, 7.1601907587E+00, 2.7517547036E+00, 9.0714603413E-01],
	[2.6100000000E+04, 2.2266720512E+01, 5.5922040945E+00, 7.1646756443E+00, 2.7525150436E+00, 9.0719610414E-01],
	[2.6105000000E+04, 2.2273618049E+01, 5.5921742845E+00, 7.1691624788E+00, 2.7532752107E+00, 9.0724614692E-01],
	[2.6110000000E+04, 2.2280516400E+01, 5.5921444804E+00, 7.1736512627E+00, 2.7540352048E+00, 9.0729616249E-01],
	[2.6115000000E+04, 2.2287415567E+01, 5.5921146822E+00, 7.1781419964E+00, 2.7547950259E+00, 9.0734615085E-01],
	[2.6120000000E+04, 2.2294315548E+01, 5.5920848898E+00, 7.1826346803E+00, 2.7555546738E+00, 9.0739611203E-01],
	[2.6125000000E+04, 2.2301216345E+01, 5.5920551033E+00, 7.1871293151E+00, 2.7563141486E+00, 9.0744604604E-01],
	[2.6130000000E+04, 2.2308117956E+01, 5.5920253226E+00, 7.1916259010E+00, 2.7570734501E+00, 9.0749595289E-01],
	[2.6135000000E+04, 2.2315020382E+01, 5.5919955478E+00, 7.1961244387E+00, 2.7578325784E+00, 9.0754583259E-01],
	[2.6140000000E+04, 2.2321923622E+01, 5.5919657789E+00, 7.2006249286E+00, 2.7585915334E+00, 9.0759568515E-01],
	[2.6145000000E+04, 2.2328827677E+01, 5.5919360158E+00, 7.2051273711E+00, 2.7593503151E+00, 9.0764551060E-01],
	[2.6150000000E+04, 2.2335732547E+01, 5.5919062586E+00, 7.2096317668E+00, 2.7601089233E+00, 9.0769530894E-01],
	[2.6155000000E+04, 2.2342638231E+01, 5.5918765072E+00, 7.2141381160E+00, 2.7608673580E+00, 9.0774508019E-01],
	[2.6160000000E+04, 2.2349544730E+01, 5.5918467616E+00, 7.2186464193E+00, 2.7616256192E+00, 9.0779482437E-01],
	[2.6165000000E+04, 2.2356452043E+01, 5.5918170219E+00, 7.2231566772E+00, 2.7623837069E+00, 9.0784454147E-01],
	[2.6170000000E+04, 2.2363360170E+01, 5.5917872881E+00, 7.2276688901E+00, 2.7631416209E+00, 9.0789423153E-01],
	[2.6175000000E+04, 2.2370269112E+01, 5.5917575600E+00, 7.2321830585E+00, 2.7638993613E+00, 9.0794389455E-01],
	[2.6180000000E+04, 2.2377178868E+01, 5.5917278379E+00, 7.2366991829E+00, 2.7646569280E+00, 9.0799353054E-01],
	[2.6185000000E+04, 2.2384089438E+01, 5.5916981215E+00, 7.2412172637E+00, 2.7654143209E+00, 9.0804313953E-01],
	[2.6190000000E+04, 2.2391000822E+01, 5.5916684110E+00, 7.2457373015E+00, 2.7661715399E+00, 9.0809272152E-01],
	[2.6195000000E+04, 2.2397913020E+01, 5.5916387063E+00, 7.2502592966E+00, 2.7669285851E+00, 9.0814227652E-01],
	[2.6200000000E+04, 2.2404826032E+01, 5.5916090074E+00, 7.2547832496E+00, 2.7676854564E+00, 9.0819180455E-01],
	[2.6205000000E+04, 2.2411739858E+01, 5.5915793144E+00, 7.2593091610E+00, 2.7684421537E+00, 9.0824130563E-01],
	[2.6210000000E+04, 2.2418654498E+01, 5.5915496272E+00, 7.2638370311E+00, 2.7691986770E+00, 9.0829077977E-01],
	[2.6215000000E+04, 2.2425569952E+01, 5.5915199458E+00, 7.2683668605E+00, 2.7699550263E+00, 9.0834022698E-01],
	[2.6220000000E+04, 2.2432486219E+01, 5.5914902702E+00, 7.2728986497E+00, 2.7707112014E+00, 9.0838964727E-01],
	[2.6225000000E+04, 2.2439403300E+01, 5.5914606004E+00, 7.2774323992E+00, 2.7714672024E+00, 9.0843904066E-01],
	[2.6230000000E+04, 2.2446321195E+01, 5.5914309365E+00, 7.2819681093E+00, 2.7722230291E+00, 9.0848840717E-01],
	[2.6235000000E+04, 2.2453239903E+01, 5.5914012783E+00, 7.2865057806E+00, 2.7729786816E+00, 9.0853774680E-01],
	[2.6240000000E+04, 2.2460159425E+01, 5.5913716260E+00, 7.2910454136E+00, 2.7737341597E+00, 9.0858705956E-01],
	[2.6245000000E+04, 2.2467079760E+01, 5.5913419795E+00, 7.2955870087E+00, 2.7744894636E+00, 9.0863634549E-01],
	[2.6250000000E+04, 2.2474000908E+01, 5.5913123388E+00, 7.3001305664E+00, 2.7752445930E+00, 9.0868560457E-01],
	[2.6255000000E+04, 2.2480922870E+01, 5.5912827038E+00, 7.3046760871E+00, 2.7759995479E+00, 9.0873483684E-01],
	[2.6260000000E+04, 2.2487845645E+01, 5.5912530747E+00, 7.3092235715E+00, 2.7767543283E+00, 9.0878404231E-01],
	[2.6265000000E+04, 2.2494769233E+01, 5.5912234514E+00, 7.3137730198E+00, 2.7775089342E+00, 9.0883322098E-01],
	[2.6270000000E+04, 2.2501693635E+01, 5.5911938339E+00, 7.3183244327E+00, 2.7782633655E+00, 9.0888237287E-01],
	[2.6275000000E+04, 2.2508618849E+01, 5.5911642222E+00, 7.3228778105E+00, 2.7790176221E+00, 9.0893149799E-01],
	[2.6280000000E+04, 2.2515544877E+01, 5.5911346162E+00, 7.3274331537E+00, 2.7797717041E+00, 9.0898059637E-01],
	[2.6285000000E+04, 2.2522471717E+01, 5.5911050161E+00, 7.3319904629E+00, 2.7805256112E+00, 9.0902966800E-01],
	[2.6290000000E+04, 2.2529399370E+01, 5.5910754217E+00, 7.3365497385E+00, 2.7812793436E+00, 9.0907871292E-01],
	[2.6295000000E+04, 2.2536327836E+01, 5.5910458331E+00, 7.3411109809E+00, 2.7820329012E+00, 9.0912773112E-01],
	[2.6300000000E+04, 2.2543257115E+01, 5.5910162503E+00, 7.3456741907E+00, 2.7827862839E+00, 9.0917672262E-01],
	[2.6305000000E+04, 2.2550187207E+01, 5.5909866733E+00, 7.3502393683E+00, 2.7835394916E+00, 9.0922568744E-01],
	[2.6310000000E+04, 2.2557118111E+01, 5.5909571021E+00, 7.3548065142E+00, 2.7842925243E+00, 9.0927462559E-01],
	[2.6315000000E+04, 2.2564049828E+01, 5.5909275366E+00, 7.3593756288E+00, 2.7850453821E+00, 9.0932353709E-01],
	[2.6320000000E+04, 2.2570982358E+01, 5.5908979769E+00, 7.3639467127E+00, 2.7857980647E+00, 9.0937242194E-01],
	[2.6325000000E+04, 2.2577940626E+01, 5.5908717465E+00, 7.3685197663E+00, 2.7865517775E+00, 9.0942128017E-01],
	[2.6330000000E+04, 2.2584903235E+01, 5.5908459900E+00, 7.3730947901E+00, 2.7873054861E+00, 9.0947011178E-01],
	[2.6335000000E+04, 2.2591866669E+01, 5.5908202384E+00, 7.3776717845E+00, 2.7880590204E+00, 9.0951891678E-01],
	[2.6340000000E+04, 2.2598830927E+01, 5.5907944919E+00, 7.3822507501E+00, 2.7888123805E+00, 9.0956769520E-01],
	[2.6345000000E+04, 2.2605796009E+01, 5.5907687505E+00, 7.3868316873E+00, 2.7895655662E+00, 9.0961644705E-01],
	[2.6350000000E+04, 2.2612761915E+01, 5.5907430140E+00, 7.3914145965E+00, 2.7903185775E+00, 9.0966517233E-01],
	[2.6355000000E+04, 2.2619728646E+01, 5.5907172825E+00, 7.3959994783E+00, 2.7910714144E+00, 9.0971387107E-01],
	[2.6360000000E+04, 2.2626696201E+01, 5.5906915560E+00, 7.4005863332E+00, 2.7918240768E+00, 9.0976254327E-01],
	[2.6365000000E+04, 2.2633664580E+01, 5.5906658345E+00, 7.4051751615E+00, 2.7925765646E+00, 9.0981118896E-01],
	[2.6370000000E+04, 2.2640633783E+01, 5.5906401180E+00, 7.4097659639E+00, 2.7933288779E+00, 9.0985980813E-01],
	[2.6375000000E+04, 2.2647603810E+01, 5.5906144065E+00, 7.4143587406E+00, 2.7940810166E+00, 9.0990840082E-01],
	[2.6380000000E+04, 2.2654574661E+01, 5.5905887000E+00, 7.4189534924E+00, 2.7948329806E+00, 9.0995696703E-01],
	[2.6385000000E+04, 2.2661546336E+01, 5.5905629985E+00, 7.4235502195E+00, 2.7955847699E+00, 9.1000550677E-01],
	[2.6390000000E+04, 2.2668518835E+01, 5.5905373019E+00, 7.4281489225E+00, 2.7963363844E+00, 9.1005402006E-01],
	[2.6395000000E+04, 2.2675492157E+01, 5.5905116104E+00, 7.4327496018E+00, 2.7970878242E+00, 9.1010250691E-01],
	[2.6400000000E+04, 2.2682466303E+01, 5.5904859238E+00, 7.4373522580E+00, 2.7978390890E+00, 9.1015096734E-01],
	[2.6405000000E+04, 2.2689441273E+01, 5.5904602422E+00, 7.4419568915E+00, 2.7985901790E+00, 9.1019940136E-01],
	[2.6410000000E+04, 2.2696417067E+01, 5.5904345656E+00, 7.4465635027E+00, 2.7993410941E+00, 9.1024780898E-01],
	[2.6415000000E+04, 2.2703393683E+01, 5.5904088940E+00, 7.4511720922E+00, 2.8000918342E+00, 9.1029619022E-01],
	[2.6420000000E+04, 2.2710371124E+01, 5.5903832274E+00, 7.4557826604E+00, 2.8008423992E+00, 9.1034454509E-01],
	[2.6425000000E+04, 2.2717349388E+01, 5.5903575657E+00, 7.4603952078E+00, 2.8015927892E+00, 9.1039287361E-01],
	[2.6430000000E+04, 2.2724328475E+01, 5.5903319090E+00, 7.4650097349E+00, 2.8023430040E+00, 9.1044117578E-01],
	[2.6435000000E+04, 2.2731308385E+01, 5.5903062573E+00, 7.4696262422E+00, 2.8030930437E+00, 9.1048945162E-01],
	[2.6440000000E+04, 2.2738289119E+01, 5.5902806105E+00, 7.4742447300E+00, 2.8038429082E+00, 9.1053770115E-01],
	[2.6445000000E+04, 2.2745270676E+01, 5.5902549687E+00, 7.4788651990E+00, 2.8045925974E+00, 9.1058592438E-01],
	[2.6450000000E+04, 2.2752253056E+01, 5.5902293319E+00, 7.4834876495E+00, 2.8053421114E+00, 9.1063412131E-01],
	[2.6455000000E+04, 2.2759236259E+01, 5.5902037000E+00, 7.4881120821E+00, 2.8060914499E+00, 9.1068229198E-01],
	[2.6460000000E+04, 2.2766220285E+01, 5.5901780731E+00, 7.4927384972E+00, 2.8068406132E+00, 9.1073043639E-01],
	[2.6465000000E+04, 2.2773205134E+01, 5.5901524512E+00, 7.4973668953E+00, 2.8075896009E+00, 9.1077855455E-01],
	[2.6470000000E+04, 2.2780190806E+01, 5.5901268342E+00, 7.5019972768E+00, 2.8083384132E+00, 9.1082664647E-01],
	[2.6475000000E+04, 2.2787177301E+01, 5.5901012222E+00, 7.5066296423E+00, 2.8090870500E+00, 9.1087471218E-01],
	[2.6480000000E+04, 2.2794164618E+01, 5.5900756151E+00, 7.5112639923E+00, 2.8098355113E+00, 9.1092275168E-01],
	[2.6485000000E+04, 2.2801152758E+01, 5.5900500130E+00, 7.5159003271E+00, 2.8105837969E+00, 9.1097076499E-01],
	[2.6490000000E+04, 2.2808141721E+01, 5.5900244158E+00, 7.5205386473E+00, 2.8113319069E+00, 9.1101875212E-01],
	[2.6495000000E+04, 2.2815131506E+01, 5.5899988236E+00, 7.5251789533E+00, 2.8120798412E+00, 9.1106671309E-01],
	[2.6500000000E+04, 2.2822122114E+01, 5.5899732363E+00, 7.5298212457E+00, 2.8128275997E+00, 9.1111464790E-01],
	[2.6505000000E+04, 2.2829113545E+01, 5.5899476540E+00, 7.5344655249E+00, 2.8135751825E+00, 9.1116255658E-01],
	[2.6510000000E+04, 2.2836105798E+01, 5.5899220766E+00, 7.5391117913E+00, 2.8143225895E+00, 9.1121043914E-01],
	[2.6515000000E+04, 2.2843098873E+01, 5.5898965042E+00, 7.5437600455E+00, 2.8150698206E+00, 9.1125829558E-01],
	[2.6520000000E+04, 2.2850092770E+01, 5.5898709366E+00, 7.5484102879E+00, 2.8158168758E+00, 9.1130612593E-01],
	[2.6525000000E+04, 2.2857087490E+01, 5.5898453741E+00, 7.5530625190E+00, 2.8165637550E+00, 9.1135393020E-01],
	[2.6530000000E+04, 2.2864083032E+01, 5.5898198164E+00, 7.5577167392E+00, 2.8173104583E+00, 9.1140170840E-01],
	[2.6535000000E+04, 2.2871079396E+01, 5.5897942637E+00, 7.5623729491E+00, 2.8180569855E+00, 9.1144946054E-01],
	[2.6540000000E+04, 2.2878076582E+01, 5.5897687160E+00, 7.5670311492E+00, 2.8188033367E+00, 9.1149718664E-01],
	[2.6545000000E+04, 2.2885074590E+01, 5.5897431731E+00, 7.5716913398E+00, 2.8195495117E+00, 9.1154488672E-01],
	[2.6550000000E+04, 2.2892073420E+01, 5.5897176352E+00, 7.5763535215E+00, 2.8202955106E+00, 9.1159256078E-01],
	[2.6555000000E+04, 2.2899073072E+01, 5.5896921022E+00, 7.5810176947E+00, 2.8210413333E+00, 9.1164020884E-01],
	[2.6560000000E+04, 2.2906073546E+01, 5.5896665741E+00, 7.5856838600E+00, 2.8217869798E+00, 9.1168783091E-01],
	[2.6565000000E+04, 2.2913074842E+01, 5.5896410510E+00, 7.5903520178E+00, 2.8225324499E+00, 9.1173542701E-01],
	[2.6570000000E+04, 2.2920076959E+01, 5.5896155328E+00, 7.5950221685E+00, 2.8232777438E+00, 9.1178299715E-01],
	[2.6575000000E+04, 2.2927079898E+01, 5.5895900195E+00, 7.5996943127E+00, 2.8240228612E+00, 9.1183054134E-01],
	[2.6580000000E+04, 2.2934083658E+01, 5.5895645111E+00, 7.6043684508E+00, 2.8247678023E+00, 9.1187805960E-01],
	[2.6585000000E+04, 2.2941088240E+01, 5.5895390076E+00, 7.6090445833E+00, 2.8255125669E+00, 9.1192555193E-01],
	[2.6590000000E+04, 2.2948093644E+01, 5.5895135090E+00, 7.6137227107E+00, 2.8262571550E+00, 9.1197301835E-01],
	[2.6595000000E+04, 2.2955099869E+01, 5.5894880154E+00, 7.6184028334E+00, 2.8270015666E+00, 9.1202045888E-01],
	[2.6600000000E+04, 2.2962106915E+01, 5.5894625266E+00, 7.6230849519E+00, 2.8277458017E+00, 9.1206787351E-01],
	[2.6605000000E+04, 2.2969114783E+01, 5.5894370428E+00, 7.6277690668E+00, 2.8284898601E+00, 9.1211526227E-01],
	[2.6610000000E+04, 2.2976123472E+01, 5.5894115639E+00, 7.6324551784E+00, 2.8292337418E+00, 9.1216262517E-01],
	[2.6615000000E+04, 2.2983132982E+01, 5.5893860898E+00, 7.6371432873E+00, 2.8299774469E+00, 9.1220996222E-01],
	[2.6620000000E+04, 2.2990143313E+01, 5.5893606207E+00, 7.6418333939E+00, 2.8307209752E+00, 9.1225727342E-01],
	[2.6625000000E+04, 2.2997154465E+01, 5.5893351565E+00, 7.6465254987E+00, 2.8314643268E+00, 9.1230455880E-01],
	[2.6630000000E+04, 2.3004166439E+01, 5.5893096971E+00, 7.6512196022E+00, 2.8322075015E+00, 9.1235181836E-01],
	[2.6635000000E+04, 2.3011179233E+01, 5.5892842427E+00, 7.6559157048E+00, 2.8329504994E+00, 9.1239905212E-01],
	[2.6640000000E+04, 2.3018192848E+01, 5.5892587932E+00, 7.6606138071E+00, 2.8336933204E+00, 9.1244626009E-01],
	[2.6645000000E+04, 2.3025207284E+01, 5.5892333485E+00, 7.6653139095E+00, 2.8344359645E+00, 9.1249344228E-01],
	[2.6650000000E+04, 2.3032222541E+01, 5.5892079087E+00, 7.6700160124E+00, 2.8351784315E+00, 9.1254059870E-01],
	[2.6655000000E+04, 2.3039238619E+01, 5.5891824739E+00, 7.6747201164E+00, 2.8359207216E+00, 9.1258772936E-01],
	[2.6660000000E+04, 2.3046255517E+01, 5.5891570439E+00, 7.6794262220E+00, 2.8366628346E+00, 9.1263483429E-01],
	[2.6665000000E+04, 2.3053273236E+01, 5.5891316188E+00, 7.6841343295E+00, 2.8374047706E+00, 9.1268191348E-01],
	[2.6670000000E+04, 2.3060291775E+01, 5.5891061986E+00, 7.6888444396E+00, 2.8381465293E+00, 9.1272896695E-01],
	[2.6675000000E+04, 2.3067311135E+01, 5.5890807832E+00, 7.6935565525E+00, 2.8388881110E+00, 9.1277599471E-01],
	[2.6680000000E+04, 2.3074331315E+01, 5.5890553728E+00, 7.6982706690E+00, 2.8396295154E+00, 9.1282299678E-01],
	[2.6685000000E+04, 2.3081352316E+01, 5.5890299672E+00, 7.7029867893E+00, 2.8403707425E+00, 9.1286997317E-01],
	[2.6690000000E+04, 2.3088374137E+01, 5.5890045665E+00, 7.7077049140E+00, 2.8411117924E+00, 9.1291692388E-01],
	[2.6695000000E+04, 2.3095396778E+01, 5.5889791706E+00, 7.7124250436E+00, 2.8418526650E+00, 9.1296384894E-01],
	[2.6700000000E+04, 2.3102420240E+01, 5.5889537797E+00, 7.7171471785E+00, 2.8425933601E+00, 9.1301074835E-01],
	[2.6705000000E+04, 2.3109444521E+01, 5.5889283936E+00, 7.7218713193E+00, 2.8433338779E+00, 9.1305762212E-01],
	[2.6710000000E+04, 2.3116469623E+01, 5.5889030124E+00, 7.7265974663E+00, 2.8440742182E+00, 9.1310447027E-01],
	[2.6715000000E+04, 2.3123495545E+01, 5.5888776360E+00, 7.7313256201E+00, 2.8448143811E+00, 9.1315129281E-01],
	[2.6720000000E+04, 2.3130522286E+01, 5.5888522645E+00, 7.7360557811E+00, 2.8455543664E+00, 9.1319808975E-01],
	[2.6725000000E+04, 2.3137549848E+01, 5.5888268979E+00, 7.7407879499E+00, 2.8462941742E+00, 9.1324486111E-01],
	[2.6730000000E+04, 2.3144578230E+01, 5.5888015361E+00, 7.7455221269E+00, 2.8470338044E+00, 9.1329160689E-01],
	[2.6735000000E+04, 2.3151607431E+01, 5.5887761792E+00, 7.7502583125E+00, 2.8477732569E+00, 9.1333832711E-01],
	[2.6740000000E+04, 2.3158637452E+01, 5.5887508271E+00, 7.7549965072E+00, 2.8485125318E+00, 9.1338502178E-01],
	[2.6745000000E+04, 2.3165671989E+01, 5.5887259676E+00, 7.7597367116E+00, 2.8492518117E+00, 9.1343169091E-01],
	[2.6750000000E+04, 2.3172731846E+01, 5.5887043437E+00, 7.7644789261E+00, 2.8499921246E+00, 9.1347833451E-01],
	[2.6755000000E+04, 2.3179792534E+01, 5.5886827239E+00, 7.7692231512E+00, 2.8507322608E+00, 9.1352495260E-01],
	[2.6760000000E+04, 2.3186854053E+01, 5.5886611082E+00, 7.7739693873E+00, 2.8514722200E+00, 9.1357154519E-01],
	[2.6765000000E+04, 2.3193916404E+01, 5.5886394966E+00, 7.7787176349E+00, 2.8522120023E+00, 9.1361811229E-01],
	[2.6770000000E+04, 2.3200979586E+01, 5.5886178891E+00, 7.7834678946E+00, 2.8529516077E+00, 9.1366465391E-01],
	[2.6775000000E+04, 2.3208043599E+01, 5.5885962858E+00, 7.7882201667E+00, 2.8536910360E+00, 9.1371117007E-01],
	[2.6780000000E+04, 2.3215108444E+01, 5.5885746866E+00, 7.7929744518E+00, 2.8544302873E+00, 9.1375766077E-01],
	[2.6785000000E+04, 2.3222174119E+01, 5.5885530915E+00, 7.7977307503E+00, 2.8551693616E+00, 9.1380412603E-01],
	[2.6790000000E+04, 2.3229240626E+01, 5.5885315005E+00, 7.8024890627E+00, 2.8559082587E+00, 9.1385056586E-01],
	[2.6795000000E+04, 2.3236307963E+01, 5.5885099136E+00, 7.8072493895E+00, 2.8566469787E+00, 9.1389698028E-01],
	[2.6800000000E+04, 2.3243376132E+01, 5.5884883308E+00, 7.8120117312E+00, 2.8573855215E+00, 9.1394336929E-01],
	[2.6805000000E+04, 2.3250445131E+01, 5.5884667522E+00, 7.8167760882E+00, 2.8581238871E+00, 9.1398973291E-01],
	[2.6810000000E+04, 2.3257514961E+01, 5.5884451776E+00, 7.8215424610E+00, 2.8588620754E+00, 9.1403607115E-01],
	[2.6815000000E+04, 2.3264585622E+01, 5.5884236072E+00, 7.8263108502E+00, 2.8596000864E+00, 9.1408238402E-01],
	[2.6820000000E+04, 2.3271657114E+01, 5.5884020408E+00, 7.8310812560E+00, 2.8603379201E+00, 9.1412867154E-01],
	[2.6825000000E+04, 2.3278729436E+01, 5.5883804786E+00, 7.8358536792E+00, 2.8610755765E+00, 9.1417493371E-01],
	[2.6830000000E+04, 2.3285802589E+01, 5.5883589205E+00, 7.8406281200E+00, 2.8618130554E+00, 9.1422117055E-01],
	[2.6835000000E+04, 2.3292876572E+01, 5.5883373664E+00, 7.8454045790E+00, 2.8625503569E+00, 9.1426738207E-01],
	[2.6840000000E+04, 2.3299951386E+01, 5.5883158165E+00, 7.8501830568E+00, 2.8632874809E+00, 9.1431356828E-01],
	[2.6845000000E+04, 2.3307027030E+01, 5.5882942707E+00, 7.8549635536E+00, 2.8640244274E+00, 9.1435972920E-01],
	[2.6850000000E+04, 2.3314103505E+01, 5.5882727289E+00, 7.8597460701E+00, 2.8647611963E+00, 9.1440586483E-01],
	[2.6855000000E+04, 2.3321180810E+01, 5.5882511913E+00, 7.8645306067E+00, 2.8654977877E+00, 9.1445197520E-01],
	[2.6860000000E+04, 2.3328258945E+01, 5.5882296577E+00, 7.8693171639E+00, 2.8662342014E+00, 9.1449806030E-01],
	[2.6865000000E+04, 2.3335337910E+01, 5.5882081283E+00, 7.8741057421E+00, 2.8669704375E+00, 9.1454412016E-01],
	[2.6870000000E+04, 2.3342417706E+01, 5.5881866029E+00, 7.8788963419E+00, 2.8677064959E+00, 9.1459015479E-01],
	[2.6875000000E+04, 2.3349498331E+01, 5.5881650816E+00, 7.8836889637E+00, 2.8684423766E+00, 9.1463616419E-01],
	[2.6880000000E+04, 2.3356579787E+01, 5.5881435644E+00, 7.8884836079E+00, 2.8691780795E+00, 9.1468214839E-01],
	[2.6885000000E+04, 2.3363662072E+01, 5.5881220513E+00, 7.8932802752E+00, 2.8699136046E+00, 9.1472810739E-01],
	[2.6890000000E+04, 2.3370745188E+01, 5.5881005423E+00, 7.8980789658E+00, 2.8706489519E+00, 9.1477404120E-01],
	[2.6895000000E+04, 2.3377829133E+01, 5.5880790373E+00, 7.9028796804E+00, 2.8713841214E+00, 9.1481994984E-01],
	[2.6900000000E+04, 2.3384913908E+01, 5.5880575364E+00, 7.9076824194E+00, 2.8721191129E+00, 9.1486583332E-01],
	[2.6905000000E+04, 2.3391999513E+01, 5.5880360397E+00, 7.9124871832E+00, 2.8728539265E+00, 9.1491169165E-01],
	[2.6910000000E+04, 2.3399085947E+01, 5.5880145469E+00, 7.9172939724E+00, 2.8735885621E+00, 9.1495752484E-01],
	[2.6915000000E+04, 2.3406173212E+01, 5.5879930583E+00, 7.9221027875E+00, 2.8743230198E+00, 9.1500333291E-01],
	[2.6920000000E+04, 2.3413261305E+01, 5.5879715737E+00, 7.9269136288E+00, 2.8750572993E+00, 9.1504911587E-01],
	[2.6925000000E+04, 2.3420350228E+01, 5.5879500932E+00, 7.9317264969E+00, 2.8757914009E+00, 9.1509487373E-01],
	[2.6930000000E+04, 2.3427439981E+01, 5.5879286168E+00, 7.9365413923E+00, 2.8765253243E+00, 9.1514060651E-01],
	[2.6935000000E+04, 2.3434530563E+01, 5.5879071445E+00, 7.9413583153E+00, 2.8772590695E+00, 9.1518631420E-01],
	[2.6940000000E+04, 2.3441621974E+01, 5.5878856762E+00, 7.9461772667E+00, 2.8779926366E+00, 9.1523199684E-01],
	[2.6945000000E+04, 2.3448714215E+01, 5.5878642120E+00, 7.9509982466E+00, 2.8787260255E+00, 9.1527765442E-01],
	[2.6950000000E+04, 2.3455807284E+01, 5.5878427518E+00, 7.9558212558E+00, 2.8794592362E+00, 9.1532328697E-01],
	[2.6955000000E+04, 2.3462901183E+01, 5.5878212958E+00, 7.9606462946E+00, 2.8801922686E+00, 9.1536889449E-01],
	[2.6960000000E+04, 2.3469995911E+01, 5.5877998437E+00, 7.9654733635E+00, 2.8809251226E+00, 9.1541447700E-01],
	[2.6965000000E+04, 2.3477091469E+01, 5.5877783958E+00, 7.9703024630E+00, 2.8816577984E+00, 9.1546003450E-01],
	[2.6970000000E+04, 2.3484187855E+01, 5.5877569519E+00, 7.9751335936E+00, 2.8823902957E+00, 9.1550556702E-01],
	[2.6975000000E+04, 2.3491285070E+01, 5.5877355120E+00, 7.9799667557E+00, 2.8831226147E+00, 9.1555107456E-01],
	[2.6980000000E+04, 2.3498383114E+01, 5.5877140762E+00, 7.9848019499E+00, 2.8838547552E+00, 9.1559655713E-01],
	[2.6985000000E+04, 2.3505481986E+01, 5.5876926445E+00, 7.9896391766E+00, 2.8845867172E+00, 9.1564201476E-01],
	[2.6990000000E+04, 2.3512581688E+01, 5.5876712168E+00, 7.9944784362E+00, 2.8853185007E+00, 9.1568744744E-01],
	[2.6995000000E+04, 2.3519682218E+01, 5.5876497932E+00, 7.9993197293E+00, 2.8860501057E+00, 9.1573285520E-01],
	[2.7000000000E+04, 2.3526783577E+01, 5.5876283736E+00, 8.0041630563E+00, 2.8867815321E+00, 9.1577823804E-01],
	[2.7005000000E+04, 2.3533885764E+01, 5.5876069580E+00, 8.0090084178E+00, 2.8875127799E+00, 9.1582359598E-01],
	[2.7010000000E+04, 2.3540988780E+01, 5.5875855466E+00, 8.0138558141E+00, 2.8882438491E+00, 9.1586892902E-01],
	[2.7015000000E+04, 2.3548092625E+01, 5.5875641391E+00, 8.0187052459E+00, 2.8889747396E+00, 9.1591423719E-01],
	[2.7020000000E+04, 2.3555197297E+01, 5.5875427357E+00, 8.0235567134E+00, 2.8897054514E+00, 9.1595952049E-01],
	[2.7025000000E+04, 2.3562302799E+01, 5.5875213364E+00, 8.0284102173E+00, 2.8904359845E+00, 9.1600477894E-01],
	[2.7030000000E+04, 2.3569409128E+01, 5.5874999410E+00, 8.0332657580E+00, 2.8911663388E+00, 9.1605001255E-01],
	[2.7035000000E+04, 2.3576516286E+01, 5.5874785498E+00, 8.0381233359E+00, 2.8918965143E+00, 9.1609522133E-01],
	[2.7040000000E+04, 2.3583624272E+01, 5.5874571625E+00, 8.0429829517E+00, 2.8926265110E+00, 9.1614040529E-01],
	[2.7045000000E+04, 2.3590733086E+01, 5.5874357793E+00, 8.0478446056E+00, 2.8933563288E+00, 9.1618556445E-01],
	[2.7050000000E+04, 2.3597842728E+01, 5.5874144002E+00, 8.0527082983E+00, 2.8940859678E+00, 9.1623069881E-01],
	[2.7055000000E+04, 2.3604953198E+01, 5.5873930250E+00, 8.0575740301E+00, 2.8948154278E+00, 9.1627580840E-01],
	[2.7060000000E+04, 2.3612064497E+01, 5.5873716539E+00, 8.0624418016E+00, 2.8955447088E+00, 9.1632089321E-01],
	[2.7065000000E+04, 2.3619176623E+01, 5.5873502869E+00, 8.0673116133E+00, 2.8962738109E+00, 9.1636595328E-01],
	[2.7070000000E+04, 2.3626289577E+01, 5.5873289238E+00, 8.0721834656E+00, 2.8970027339E+00, 9.1641098860E-01],
	[2.7075000000E+04, 2.3633403358E+01, 5.5873075648E+00, 8.0770573590E+00, 2.8977314779E+00, 9.1645599918E-01],
	[2.7080000000E+04, 2.3640517968E+01, 5.5872862098E+00, 8.0819332939E+00, 2.8984600429E+00, 9.1650098506E-01],
	[2.7085000000E+04, 2.3647633405E+01, 5.5872648588E+00, 8.0868112709E+00, 2.8991884287E+00, 9.1654594622E-01],
	[2.7090000000E+04, 2.3654749670E+01, 5.5872435119E+00, 8.0916912905E+00, 2.8999166353E+00, 9.1659088269E-01],
	[2.7095000000E+04, 2.3661866762E+01, 5.5872221690E+00, 8.0965733530E+00, 2.9006446629E+00, 9.1663579448E-01],
	[2.7100000000E+04, 2.3668984682E+01, 5.5872008301E+00, 8.1014574591E+00, 2.9013725112E+00, 9.1668068160E-01],
	[2.7105000000E+04, 2.3676103429E+01, 5.5871794952E+00, 8.1063436091E+00, 2.9021001802E+00, 9.1672554407E-01],
	[2.7110000000E+04, 2.3683223004E+01, 5.5871581643E+00, 8.1112318035E+00, 2.9028276700E+00, 9.1677038189E-01],
	[2.7115000000E+04, 2.3690343406E+01, 5.5871368375E+00, 8.1161220429E+00, 2.9035549805E+00, 9.1681519508E-01],
	[2.7120000000E+04, 2.3697464636E+01, 5.5871155146E+00, 8.1210143277E+00, 2.9042821117E+00, 9.1685998365E-01],
	[2.7125000000E+04, 2.3704586692E+01, 5.5870941958E+00, 8.1259086583E+00, 2.9050090636E+00, 9.1690474761E-01],
	[2.7130000000E+04, 2.3711709576E+01, 5.5870728810E+00, 8.1308050353E+00, 2.9057358360E+00, 9.1694948698E-01],
	[2.7135000000E+04, 2.3718833287E+01, 5.5870515702E+00, 8.1357034592E+00, 2.9064624291E+00, 9.1699420177E-01],
	[2.7140000000E+04, 2.3725957825E+01, 5.5870302634E+00, 8.1406039303E+00, 2.9071888427E+00, 9.1703889199E-01],
	[2.7145000000E+04, 2.3733083190E+01, 5.5870089606E+00, 8.1455064493E+00, 2.9079150768E+00, 9.1708355764E-01],
	[2.7150000000E+04, 2.3740209382E+01, 5.5869876618E+00, 8.1504110165E+00, 2.9086411314E+00, 9.1712819876E-01],
	[2.7155000000E+04, 2.3747336401E+01, 5.5869663670E+00, 8.1553176324E+00, 2.9093670065E+00, 9.1717281534E-01],
	[2.7160000000E+04, 2.3754464246E+01, 5.5869450762E+00, 8.1602262976E+00, 2.9100927021E+00, 9.1721740740E-01],
	[2.7165000000E+04, 2.3761592919E+01, 5.5869237894E+00, 8.1651370125E+00, 2.9108182180E+00, 9.1726197495E-01],
	[2.7170000000E+04, 2.3768722418E+01, 5.5869025066E+00, 8.1700497775E+00, 2.9115435543E+00, 9.1730651801E-01],
	[2.7175000000E+04, 2.3775853348E+01, 5.5868813067E+00, 8.1749645932E+00, 2.9122687415E+00, 9.1735103658E-01],
	[2.7180000000E+04, 2.3783012441E+01, 5.5868636782E+00, 8.1798814601E+00, 2.9129951290E+00, 9.1739553068E-01],
	[2.7185000000E+04, 2.3790172373E+01, 5.5868460530E+00, 8.1848003785E+00, 2.9137213376E+00, 9.1744000033E-01],
	[2.7190000000E+04, 2.3797333142E+01, 5.5868284311E+00, 8.1897213491E+00, 2.9144473674E+00, 9.1748444553E-01],
	[2.7195000000E+04, 2.3804494749E+01, 5.5868108125E+00, 8.1946443722E+00, 2.9151732184E+00, 9.1752886629E-01],
	[2.7200000000E+04, 2.3811657195E+01, 5.5867931972E+00, 8.1995694484E+00, 2.9158988904E+00, 9.1757326263E-01],
	[2.7205000000E+04, 2.3818820478E+01, 5.5867755851E+00, 8.2044965781E+00, 2.9166243836E+00, 9.1761763457E-01],
	[2.7210000000E+04, 2.3825984600E+01, 5.5867579764E+00, 8.2094257618E+00, 2.9173496978E+00, 9.1766198211E-01],
	[2.7215000000E+04, 2.3833149559E+01, 5.5867403709E+00, 8.2143570000E+00, 2.9180748330E+00, 9.1770630526E-01],
	[2.7220000000E+04, 2.3840315356E+01, 5.5867227688E+00, 8.2192902931E+00, 2.9187997892E+00, 9.1775060404E-01],
	[2.7225000000E+04, 2.3847481991E+01, 5.5867051699E+00, 8.2242256417E+00, 2.9195245663E+00, 9.1779487846E-01],
	[2.7230000000E+04, 2.3854649464E+01, 5.5866875743E+00, 8.2291630462E+00, 2.9202491645E+00, 9.1783912854E-01],
	[2.7235000000E+04, 2.3861817774E+01, 5.5866699820E+00, 8.2341025071E+00, 2.9209735835E+00, 9.1788335428E-01],
	[2.7240000000E+04, 2.3868986922E+01, 5.5866523930E+00, 8.2390440249E+00, 2.9216978234E+00, 9.1792755570E-01],
	[2.7245000000E+04, 2.3876156907E+01, 5.5866348073E+00, 8.2439876000E+00, 2.9224218841E+00, 9.1797173281E-01],
	[2.7250000000E+04, 2.3883327730E+01, 5.5866172248E+00, 8.2489332330E+00, 2.9231457657E+00, 9.1801588562E-01],
	[2.7255000000E+04, 2.3890499390E+01, 5.5865996457E+00, 8.2538809243E+00, 2.9238694681E+00, 9.1806001414E-01],
	[2.7260000000E+04, 2.3897671888E+01, 5.5865820698E+00, 8.2588306744E+00, 2.9245929912E+00, 9.1810411840E-01],
	[2.7265000000E+04, 2.3904845223E+01, 5.5865644972E+00, 8.2637824837E+00, 2.9253163351E+00, 9.1814819839E-01],
	[2.7270000000E+04, 2.3912019395E+01, 5.5865469279E+00, 8.2687363528E+00, 2.9260394997E+00, 9.1819225414E-01],
	[2.7275000000E+04, 2.3919194405E+01, 5.5865293618E+00, 8.2736922821E+00, 2.9267624850E+00, 9.1823628565E-01],
	[2.7280000000E+04, 2.3926370251E+01, 5.5865117990E+00, 8.2786502721E+00, 2.9274852910E+00, 9.1828029294E-01],
	[2.7285000000E+04, 2.3933546935E+01, 5.5864942395E+00, 8.2836103233E+00, 2.9282079175E+00, 9.1832427602E-01],
	[2.7290000000E+04, 2.3940724455E+01, 5.5864766833E+00, 8.2885724361E+00, 2.9289303647E+00, 9.1836823490E-01],
	[2.7295000000E+04, 2.3947902813E+01, 5.5864591303E+00, 8.2935366111E+00, 2.9296526325E+00, 9.1841216959E-01],
	[2.7300000000E+04, 2.3955082008E+01, 5.5864415806E+00, 8.2985028488E+00, 2.9303747208E+00, 9.1845608011E-01],
	[2.7305000000E+04, 2.3962262039E+01, 5.5864240342E+00, 8.3034711495E+00, 2.9310966296E+00, 9.1849996647E-01],
	[2.7310000000E+04, 2.3969442907E+01, 5.5864064911E+00, 8.3084415138E+00, 2.9318183590E+00, 9.1854382868E-01],
	[2.7315000000E+04, 2.3976624612E+01, 5.5863889512E+00, 8.3134139421E+00, 2.9325399088E+00, 9.1858766676E-01],
	[2.7320000000E+04, 2.3983807154E+01, 5.5863714146E+00, 8.3183884350E+00, 2.9332612791E+00, 9.1863148071E-01],
	[2.7325000000E+04, 2.3990990532E+01, 5.5863538812E+00, 8.3233649929E+00, 2.9339824697E+00, 9.1867527055E-01],
	[2.7330000000E+04, 2.3998174747E+01, 5.5863363511E+00, 8.3283436163E+00, 2.9347034808E+00, 9.1871903630E-01],
	[2.7335000000E+04, 2.4005359799E+01, 5.5863188243E+00, 8.3333243056E+00, 2.9354243122E+00, 9.1876277795E-01],
	[2.7340000000E+04, 2.4012545687E+01, 5.5863013007E+00, 8.3383070614E+00, 2.9361449640E+00, 9.1880649554E-01],
	[2.7345000000E+04, 2.4019732411E+01, 5.5862837804E+00, 8.3432918842E+00, 2.9368654361E+00, 9.1885018906E-01],
	[2.7350000000E+04, 2.4026919972E+01, 5.5862662634E+00, 8.3482787743E+00, 2.9375857285E+00, 9.1889385853E-01],
	[2.7355000000E+04, 2.4034108369E+01, 5.5862487496E+00, 8.3532677323E+00, 2.9383058411E+00, 9.1893750397E-01],
	[2.7360000000E+04, 2.4041297602E+01, 5.5862312390E+00, 8.3582587587E+00, 2.9390257740E+00, 9.1898112538E-01],
	[2.7365000000E+04, 2.4048487671E+01, 5.5862137317E+00, 8.3632518539E+00, 2.9397455271E+00, 9.1902472278E-01],
	[2.7370000000E+04, 2.4055678577E+01, 5.5861962277E+00, 8.3682470185E+00, 2.9404651004E+00, 9.1906829618E-01],
	[2.7375000000E+04, 2.4062870319E+01, 5.5861787269E+00, 8.3732442529E+00, 2.9411844938E+00, 9.1911184560E-01],
	[2.7380000000E+04, 2.4070062897E+01, 5.5861612294E+00, 8.3782435575E+00, 2.9419037074E+00, 9.1915537104E-01],
	[2.7385000000E+04, 2.4077256310E+01, 5.5861437351E+00, 8.3832449329E+00, 2.9426227411E+00, 9.1919887252E-01],
	[2.7390000000E+04, 2.4084450560E+01, 5.5861262441E+00, 8.3882483796E+00, 2.9433415948E+00, 9.1924235005E-01],
	[2.7395000000E+04, 2.4091645645E+01, 5.5861087563E+00, 8.3932538979E+00, 2.9440602686E+00, 9.1928580364E-01],
	[2.7400000000E+04, 2.4098841567E+01, 5.5860912718E+00, 8.3982614885E+00, 2.9447787625E+00, 9.1932923331E-01],
	[2.7405000000E+04, 2.4106038324E+01, 5.5860737905E+00, 8.4032711517E+00, 2.9454970764E+00, 9.1937263907E-01],
	[2.7410000000E+04, 2.4113235916E+01, 5.5860563124E+00, 8.4082828881E+00, 2.9462152102E+00, 9.1941602092E-01],
	[2.7415000000E+04, 2.4120434345E+01, 5.5860388376E+00, 8.4132966982E+00, 2.9469331640E+00, 9.1945937889E-01],
	[2.7420000000E+04, 2.4127633609E+01, 5.5860213661E+00, 8.4183125823E+00, 2.9476509378E+00, 9.1950271299E-01],
	[2.7425000000E+04, 2.4134833708E+01, 5.5860038977E+00, 8.4233305411E+00, 2.9483685314E+00, 9.1954602322E-01],
	[2.7430000000E+04, 2.4142034643E+01, 5.5859864326E+00, 8.4283505749E+00, 2.9490859450E+00, 9.1958930960E-01],
	[2.7435000000E+04, 2.4149236414E+01, 5.5859689708E+00, 8.4333726842E+00, 2.9498031784E+00, 9.1963257215E-01],
	[2.7440000000E+04, 2.4156439019E+01, 5.5859515122E+00, 8.4383968696E+00, 2.9505202316E+00, 9.1967581087E-01],
	[2.7445000000E+04, 2.4163642460E+01, 5.5859340568E+00, 8.4434231316E+00, 2.9512371047E+00, 9.1971902578E-01],
	[2.7450000000E+04, 2.4170846737E+01, 5.5859166047E+00, 8.4484514705E+00, 2.9519537975E+00, 9.1976221689E-01],
	[2.7455000000E+04, 2.4178051848E+01, 5.5858991558E+00, 8.4534818868E+00, 2.9526703102E+00, 9.1980538421E-01],
	[2.7460000000E+04, 2.4185257795E+01, 5.5858817101E+00, 8.4585143812E+00, 2.9533866425E+00, 9.1984852775E-01],
	[2.7465000000E+04, 2.4192464577E+01, 5.5858642676E+00, 8.4635489539E+00, 2.9541027946E+00, 9.1989164754E-01],
	[2.7470000000E+04, 2.4199672194E+01, 5.5858468284E+00, 8.4685856056E+00, 2.9548187664E+00, 9.1993474357E-01],
	[2.7475000000E+04, 2.4206880645E+01, 5.5858293924E+00, 8.4736243367E+00, 2.9555345578E+00, 9.1997781587E-01],
	[2.7480000000E+04, 2.4214089932E+01, 5.5858119597E+00, 8.4786651476E+00, 2.9562501689E+00, 9.2002086444E-01],
	[2.7485000000E+04, 2.4221300054E+01, 5.5857945302E+00, 8.4837080389E+00, 2.9569655996E+00, 9.2006388930E-01],
	[2.7490000000E+04, 2.4228511010E+01, 5.5857771038E+00, 8.4887530110E+00, 2.9576808500E+00, 9.2010689045E-01],
	[2.7495000000E+04, 2.4235722801E+01, 5.5857596808E+00, 8.4938000644E+00, 2.9583959199E+00, 9.2014986792E-01],
	[2.7500000000E+04, 2.4242935427E+01, 5.5857422609E+00, 8.4988491996E+00, 2.9591108093E+00, 9.2019282172E-01],
	[2.7505000000E+04, 2.4250148887E+01, 5.5857248443E+00, 8.5039004170E+00, 2.9598255183E+00, 9.2023575185E-01],
	[2.7510000000E+04, 2.4257363183E+01, 5.5857074308E+00, 8.5089537172E+00, 2.9605400468E+00, 9.2027865833E-01],
	[2.7515000000E+04, 2.4264578312E+01, 5.5856900206E+00, 8.5140091007E+00, 2.9612543948E+00, 9.2032154117E-01],
	[2.7520000000E+04, 2.4271794276E+01, 5.5856726137E+00, 8.5190665678E+00, 2.9619685623E+00, 9.2036440039E-01],
	[2.7525000000E+04, 2.4279011075E+01, 5.5856552099E+00, 8.5241261191E+00, 2.9626825492E+00, 9.2040723599E-01],
	[2.7530000000E+04, 2.4286228708E+01, 5.5856378093E+00, 8.5291877551E+00, 2.9633963555E+00, 9.2045004800E-01],
	[2.7535000000E+04, 2.4293447175E+01, 5.5856204120E+00, 8.5342514763E+00, 2.9641099812E+00, 9.2049283641E-01],
	[2.7540000000E+04, 2.4300666476E+01, 5.5856030179E+00, 8.5393172830E+00, 2.9648234263E+00, 9.2053560125E-01],
	[2.7545000000E+04, 2.4307886612E+01, 5.5855856270E+00, 8.5443851759E+00, 2.9655366907E+00, 9.2057834253E-01],
	[2.7550000000E+04, 2.4315107582E+01, 5.5855682393E+00, 8.5494551554E+00, 2.9662497745E+00, 9.2062106025E-01],
	[2.7555000000E+04, 2.4322329386E+01, 5.5855508548E+00, 8.5545272219E+00, 2.9669626776E+00, 9.2066375444E-01],
	[2.7560000000E+04, 2.4329552024E+01, 5.5855334735E+00, 8.5596013760E+00, 2.9676754000E+00, 9.2070642510E-01],
	[2.7565000000E+04, 2.4336775496E+01, 5.5855160954E+00, 8.5646776180E+00, 2.9683879416E+00, 9.2074907225E-01],
	[2.7570000000E+04, 2.4343999802E+01, 5.5854987205E+00, 8.5697559486E+00, 2.9691003025E+00, 9.2079169590E-01],
	[2.7575000000E+04, 2.4351224941E+01, 5.5854813489E+00, 8.5748363682E+00, 2.9698124826E+00, 9.2083429606E-01],
	[2.7580000000E+04, 2.4358450915E+01, 5.5854639804E+00, 8.5799188773E+00, 2.9705244819E+00, 9.2087687274E-01],
	[2.7585000000E+04, 2.4365677722E+01, 5.5854466151E+00, 8.5850034763E+00, 2.9712363004E+00, 9.2091942596E-01],
	[2.7590000000E+04, 2.4372905363E+01, 5.5854292531E+00, 8.5900901657E+00, 2.9719479380E+00, 9.2096195573E-01],
	[2.7595000000E+04, 2.4380133838E+01, 5.5854118942E+00, 8.5951789460E+00, 2.9726593948E+00, 9.2100446206E-01],
	[2.7600000000E+04, 2.4387363146E+01, 5.5853945386E+00, 8.6002698177E+00, 2.9733706707E+00, 9.2104694496E-01],
	[2.7605000000E+04, 2.4394593288E+01, 5.5853771861E+00, 8.6053627813E+00, 2.9740817657E+00, 9.2108940445E-01],
	[2.7610000000E+04, 2.4401824264E+01, 5.5853598368E+00, 8.6104578372E+00, 2.9747926797E+00, 9.2113184054E-01],
	[2.7615000000E+04, 2.4409070628E+01, 5.5853443712E+00, 8.6155549859E+00, 2.9755041628E+00, 9.2117425324E-01],
	[2.7620000000E+04, 2.4416330957E+01, 5.5853306036E+00, 8.6206542280E+00, 2.9762161418E+00, 9.2121664256E-01],
	[2.7625000000E+04, 2.4423592130E+01, 5.5853168386E+00, 8.6257555638E+00, 2.9769279406E+00, 9.2125900852E-01],
	[2.7630000000E+04, 2.4430854149E+01, 5.5853030761E+00, 8.6308589939E+00, 2.9776395593E+00, 9.2130135113E-01],
	[2.7635000000E+04, 2.4438117012E+01, 5.5852893161E+00, 8.6359645187E+00, 2.9783509978E+00, 9.2134367040E-01],
	[2.7640000000E+04, 2.4445380720E+01, 5.5852755586E+00, 8.6410721388E+00, 2.9790622561E+00, 9.2138596634E-01],
	[2.7645000000E+04, 2.4452645272E+01, 5.5852618037E+00, 8.6461818546E+00, 2.9797733342E+00, 9.2142823897E-01],
	[2.7650000000E+04, 2.4459910669E+01, 5.5852480513E+00, 8.6512936666E+00, 2.9804842321E+00, 9.2147048830E-01],
	[2.7655000000E+04, 2.4467176910E+01, 5.5852343014E+00, 8.6564075752E+00, 2.9811949498E+00, 9.2151271434E-01],
	[2.7660000000E+04, 2.4474443995E+01, 5.5852205540E+00, 8.6615235810E+00, 2.9819054872E+00, 9.2155491710E-01],
	[2.7665000000E+04, 2.4481711925E+01, 5.5852068091E+00, 8.6666416844E+00, 2.9826158443E+00, 9.2159709660E-01],
	[2.7670000000E+04, 2.4488980699E+01, 5.5851930668E+00, 8.6717618859E+00, 2.9833260211E+00, 9.2163925284E-01],
	[2.7675000000E+04, 2.4496250317E+01, 5.5851793270E+00, 8.6768841861E+00, 2.9840360176E+00, 9.2168138585E-01],
	[2.7680000000E+04, 2.4503520780E+01, 5.5851655897E+00, 8.6820085852E+00, 2.9847458337E+00, 9.2172349563E-01],
	[2.7685000000E+04, 2.4510792086E+01, 5.5851518549E+00, 8.6871350840E+00, 2.9854554694E+00, 9.2176558220E-01],
	[2.7690000000E+04, 2.4518064237E+01, 5.5851381226E+00, 8.6922636827E+00, 2.9861649248E+00, 9.2180764556E-01],
	[2.7695000000E+04, 2.4525337231E+01, 5.5851243928E+00, 8.6973943820E+00, 2.9868741998E+00, 9.2184968574E-01],
	[2.7700000000E+04, 2.4532611070E+01, 5.5851106656E+00, 8.7025271823E+00, 2.9875832943E+00, 9.2189170273E-01],
	[2.7705000000E+04, 2.4539885752E+01, 5.5850969408E+00, 8.7076620840E+00, 2.9882922084E+00, 9.2193369657E-01],
	[2.7710000000E+04, 2.4547161278E+01, 5.5850832186E+00, 8.7127990877E+00, 2.9890009420E+00, 9.2197566725E-01],
	[2.7715000000E+04, 2.4554437648E+01, 5.5850694989E+00, 8.7179381939E+00, 2.9897094951E+00, 9.2201761479E-01],
	[2.7720000000E+04, 2.4561714862E+01, 5.5850557816E+00, 8.7230794029E+00, 2.9904178677E+00, 9.2205953921E-01],
	[2.7725000000E+04, 2.4568992919E+01, 5.5850420669E+00, 8.7282227154E+00, 2.9911260599E+00, 9.2210144051E-01],
	[2.7730000000E+04, 2.4576271820E+01, 5.5850283547E+00, 8.7333681317E+00, 2.9918340714E+00, 9.2214331871E-01],
	[2.7735000000E+04, 2.4583551564E+01, 5.5850146450E+00, 8.7385156524E+00, 2.9925419024E+00, 9.2218517381E-01],
	[2.7740000000E+04, 2.4590832152E+01, 5.5850009378E+00, 8.7436652779E+00, 2.9932495528E+00, 9.2222700585E-01],
	[2.7745000000E+04, 2.4598113583E+01, 5.5849872331E+00, 8.7488170087E+00, 2.9939570227E+00, 9.2226881481E-01],
	[2.7750000000E+04, 2.4605395858E+01, 5.5849735310E+00, 8.7539708454E+00, 2.9946643119E+00, 9.2231060073E-01],
	[2.7755000000E+04, 2.4612678976E+01, 5.5849598313E+00, 8.7591267883E+00, 2.9953714204E+00, 9.2235236360E-01],
	[2.7760000000E+04, 2.4619962938E+01, 5.5849461341E+00, 8.7642848379E+00, 2.9960783483E+00, 9.2239410345E-01],
	[2.7765000000E+04, 2.4627247742E+01, 5.5849324394E+00, 8.7694449949E+00, 2.9967850956E+00, 9.2243582028E-01],
	[2.7770000000E+04, 2.4634533390E+01, 5.5849187472E+00, 8.7746072595E+00, 2.9974916621E+00, 9.2247751411E-01],
	[2.7775000000E+04, 2.4641819881E+01, 5.5849050576E+00, 8.7797716324E+00, 2.9981980479E+00, 9.2251918495E-01],
	[2.7780000000E+04, 2.4649107215E+01, 5.5848913704E+00, 8.7849381139E+00, 2.9989042531E+00, 9.2256083281E-01],
	[2.7785000000E+04, 2.4656395392E+01, 5.5848776857E+00, 8.7901067046E+00, 2.9996102774E+00, 9.2260245771E-01],
	[2.7790000000E+04, 2.4663684412E+01, 5.5848640035E+00, 8.7952774049E+00, 3.0003161210E+00, 9.2264405965E-01],
	[2.7795000000E+04, 2.4670974274E+01, 5.5848503238E+00, 8.8004502154E+00, 3.0010217838E+00, 9.2268563866E-01],
	[2.7800000000E+04, 2.4678264980E+01, 5.5848366466E+00, 8.8056251365E+00, 3.0017272658E+00, 9.2272719473E-01],
	[2.7805000000E+04, 2.4685556529E+01, 5.5848229719E+00, 8.8108021687E+00, 3.0024325670E+00, 9.2276872789E-01],
	[2.7810000000E+04, 2.4692848920E+01, 5.5848092997E+00, 8.8159813124E+00, 3.0031376874E+00, 9.2281023815E-01],
	[2.7815000000E+04, 2.4700142154E+01, 5.5847956299E+00, 8.8211625682E+00, 3.0038426268E+00, 9.2285172552E-01],
	[2.7820000000E+04, 2.4707436230E+01, 5.5847819627E+00, 8.8263459365E+00, 3.0045473855E+00, 9.2289319001E-01],
	[2.7825000000E+04, 2.4714731149E+01, 5.5847682980E+00, 8.8315314179E+00, 3.0052519632E+00, 9.2293463163E-01],
	[2.7830000000E+04, 2.4722026911E+01, 5.5847546357E+00, 8.8367190127E+00, 3.0059563600E+00, 9.2297605040E-01],
	[2.7835000000E+04, 2.4729323515E+01, 5.5847409759E+00, 8.8419087215E+00, 3.0066605759E+00, 9.2301744633E-01],
	[2.7840000000E+04, 2.4736620961E+01, 5.5847273187E+00, 8.8471005448E+00, 3.0073646109E+00, 9.2305881943E-01],
	[2.7845000000E+04, 2.4743919250E+01, 5.5847136639E+00, 8.8522944830E+00, 3.0080684649E+00, 9.2310016972E-01],
	[2.7850000000E+04, 2.4751218381E+01, 5.5847000116E+00, 8.8574905367E+00, 3.0087721380E+00, 9.2314149720E-01],
	[2.7855000000E+04, 2.4758518354E+01, 5.5846863617E+00, 8.8626887062E+00, 3.0094756300E+00, 9.2318280189E-01],
	[2.7860000000E+04, 2.4765819170E+01, 5.5846727144E+00, 8.8678889921E+00, 3.0101789410E+00, 9.2322408381E-01],
	[2.7865000000E+04, 2.4773120828E+01, 5.5846590695E+00, 8.8730913949E+00, 3.0108820710E+00, 9.2326534296E-01],
	[2.7870000000E+04, 2.4780423327E+01, 5.5846454271E+00, 8.8782959151E+00, 3.0115850200E+00, 9.2330657935E-01],
	[2.7875000000E+04, 2.4787726669E+01, 5.5846317872E+00, 8.8835025530E+00, 3.0122877879E+00, 9.2334779300E-01],
	[2.7880000000E+04, 2.4795030853E+01, 5.5846181498E+00, 8.8887113093E+00, 3.0129903748E+00, 9.2338898392E-01],
	[2.7885000000E+04, 2.4802335879E+01, 5.5846045149E+00, 8.8939221843E+00, 3.0136927805E+00, 9.2343015212E-01],
	[2.7890000000E+04, 2.4809641746E+01, 5.5845908824E+00, 8.8991351787E+00, 3.0143950051E+00, 9.2347129760E-01],
	[2.7895000000E+04, 2.4816948456E+01, 5.5845772524E+00, 8.9043502928E+00, 3.0150970486E+00, 9.2351242039E-01],
	[2.7900000000E+04, 2.4824256007E+01, 5.5845636249E+00, 8.9095675271E+00, 3.0157989110E+00, 9.2355352049E-01],
	[2.7905000000E+04, 2.4831564400E+01, 5.5845499999E+00, 8.9147868821E+00, 3.0165005922E+00, 9.2359459792E-01],
	[2.7910000000E+04, 2.4838873634E+01, 5.5845363773E+00, 8.9200083584E+00, 3.0172020923E+00, 9.2363565268E-01],
	[2.7915000000E+04, 2.4846183710E+01, 5.5845227572E+00, 8.9252319563E+00, 3.0179034111E+00, 9.2367668478E-01],
	[2.7920000000E+04, 2.4853494628E+01, 5.5845091396E+00, 8.9304576764E+00, 3.0186045488E+00, 9.2371769424E-01],
	[2.7925000000E+04, 2.4860806387E+01, 5.5844955245E+00, 8.9356855191E+00, 3.0193055052E+00, 9.2375868107E-01],
	[2.7930000000E+04, 2.4868118988E+01, 5.5844819118E+00, 8.9409154849E+00, 3.0200062804E+00, 9.2379964527E-01],
	[2.7935000000E+04, 2.4875432430E+01, 5.5844683016E+00, 8.9461475744E+00, 3.0207068744E+00, 9.2384058687E-01],
	[2.7940000000E+04, 2.4882746713E+01, 5.5844546939E+00, 8.9513817879E+00, 3.0214072871E+00, 9.2388150586E-01],
	[2.7945000000E+04, 2.4890061838E+01, 5.5844410886E+00, 8.9566181260E+00, 3.0221075185E+00, 9.2392240227E-01],
	[2.7950000000E+04, 2.4897377804E+01, 5.5844274858E+00, 8.9618565892E+00, 3.0228075686E+00, 9.2396327610E-01],
	[2.7955000000E+04, 2.4904694611E+01, 5.5844138855E+00, 8.9670971779E+00, 3.0235074374E+00, 9.2400412737E-01],
	[2.7960000000E+04, 2.4912012259E+01, 5.5844002876E+00, 8.9723398926E+00, 3.0242071249E+00, 9.2404495608E-01],
	[2.7965000000E+04, 2.4919330748E+01, 5.5843866922E+00, 8.9775847338E+00, 3.0249066310E+00, 9.2408576224E-01],
	[2.7970000000E+04, 2.4926650078E+01, 5.5843730993E+00, 8.9828317020E+00, 3.0256059558E+00, 9.2412654587E-01],
	[2.7975000000E+04, 2.4933970249E+01, 5.5843595088E+00, 8.9880807976E+00, 3.0263050992E+00, 9.2416730698E-01],
	[2.7980000000E+04, 2.4941291261E+01, 5.5843459208E+00, 8.9933320212E+00, 3.0270040612E+00, 9.2420804558E-01],
	[2.7985000000E+04, 2.4948613114E+01, 5.5843323352E+00, 8.9985853732E+00, 3.0277028419E+00, 9.2424876168E-01],
	[2.7990000000E+04, 2.4955935808E+01, 5.5843187522E+00, 9.0038408541E+00, 3.0284014411E+00, 9.2428945529E-01],
	[2.7995000000E+04, 2.4963259342E+01, 5.5843051715E+00, 9.0090984644E+00, 3.0290998589E+00, 9.2433012643E-01],
	[2.8000000000E+04, 2.4970583717E+01, 5.5842915934E+00, 9.0143582046E+00, 3.0297980952E+00, 9.2437077509E-01],
	[2.8005000000E+04, 2.4977908933E+01, 5.5842780176E+00, 9.0196200751E+00, 3.0304961501E+00, 9.2441140131E-01],
	[2.8010000000E+04, 2.4985234990E+01, 5.5842644444E+00, 9.0248840765E+00, 3.0311940235E+00, 9.2445200507E-01],
	[2.8015000000E+04, 2.4992561886E+01, 5.5842508736E+00, 9.0301502091E+00, 3.0318917155E+00, 9.2449258641E-01],
	[2.8020000000E+04, 2.4999889624E+01, 5.5842373052E+00, 9.0354184736E+00, 3.0325892259E+00, 9.2453314532E-01],
	[2.8025000000E+04, 2.5007218202E+01, 5.5842237393E+00, 9.0406888703E+00, 3.0332865548E+00, 9.2457368182E-01],
	[2.8030000000E+04, 2.5014547620E+01, 5.5842101759E+00, 9.0459613999E+00, 3.0339837022E+00, 9.2461419593E-01],
	[2.8035000000E+04, 2.5021877878E+01, 5.5841966149E+00, 9.0512360626E+00, 3.0346806681E+00, 9.2465468764E-01],
	[2.8040000000E+04, 2.5029208977E+01, 5.5841830564E+00, 9.0565128591E+00, 3.0353774523E+00, 9.2469515698E-01],
	[2.8045000000E+04, 2.5036540916E+01, 5.5841695003E+00, 9.0617917898E+00, 3.0360740551E+00, 9.2473560395E-01],
	[2.8050000000E+04, 2.5043873695E+01, 5.5841559466E+00, 9.0670728552E+00, 3.0367704762E+00, 9.2477602856E-01],
	[2.8055000000E+04, 2.5051207314E+01, 5.5841423954E+00, 9.0723560557E+00, 3.0374667158E+00, 9.2481643083E-01],
	[2.8060000000E+04, 2.5058558813E+01, 5.5841310263E+00, 9.0776413919E+00, 3.0381636694E+00, 9.2485681077E-01],
	[2.8065000000E+04, 2.5065921535E+01, 5.5841209862E+00, 9.0829288643E+00, 3.0388609874E+00, 9.2489716839E-01],
	[2.8070000000E+04, 2.5073285108E+01, 5.5841109479E+00, 9.0882184733E+00, 3.0395581246E+00, 9.2493750369E-01],
	[2.8075000000E+04, 2.5080649532E+01, 5.5841009113E+00, 9.0935102193E+00, 3.0402550810E+00, 9.2497781670E-01],
	[2.8080000000E+04, 2.5088014807E+01, 5.5840908766E+00, 9.0988041030E+00, 3.0409518565E+00, 9.2501810742E-01],
	[2.8085000000E+04, 2.5095380933E+01, 5.5840808437E+00, 9.1041001247E+00, 3.0416484513E+00, 9.2505837586E-01],
	[2.8090000000E+04, 2.5102747911E+01, 5.5840708126E+00, 9.1093982850E+00, 3.0423448651E+00, 9.2509862203E-01],
	[2.8095000000E+04, 2.5110115739E+01, 5.5840607833E+00, 9.1146985843E+00, 3.0430410981E+00, 9.2513884595E-01],
	[2.8100000000E+04, 2.5117484417E+01, 5.5840507558E+00, 9.1200010231E+00, 3.0437371502E+00, 9.2517904763E-01],
	[2.8105000000E+04, 2.5124853947E+01, 5.5840407301E+00, 9.1253056019E+00, 3.0444330214E+00, 9.2521922707E-01],
	[2.8110000000E+04, 2.5132224327E+01, 5.5840307062E+00, 9.1306123212E+00, 3.0451287117E+00, 9.2525938430E-01],
	[2.8115000000E+04, 2.5139595558E+01, 5.5840206841E+00, 9.1359211815E+00, 3.0458242211E+00, 9.2529951931E-01],
	[2.8120000000E+04, 2.5146967640E+01, 5.5840106638E+00, 9.1412321832E+00, 3.0465195496E+00, 9.2533963212E-01],
	[2.8125000000E+04, 2.5154340572E+01, 5.5840006453E+00, 9.1465453268E+00, 3.0472146971E+00, 9.2537972275E-01],
	[2.8130000000E+04, 2.5161714354E+01, 5.5839906286E+00, 9.1518606128E+00, 3.0479096637E+00, 9.2541979120E-01],
	[2.8135000000E+04, 2.5169088987E+01, 5.5839806137E+00, 9.1571780417E+00, 3.0486044492E+00, 9.2545983748E-01],
	[2.8140000000E+04, 2.5176464471E+01, 5.5839706006E+00, 9.1624976140E+00, 3.0492990538E+00, 9.2549986161E-01],
	[2.8145000000E+04, 2.5183840805E+01, 5.5839605893E+00, 9.1678193302E+00, 3.0499934775E+00, 9.2553986359E-01],
	[2.8150000000E+04, 2.5191217989E+01, 5.5839505798E+00, 9.1731431907E+00, 3.0506877201E+00, 9.2557984345E-01],
	[2.8155000000E+04, 2.5198596023E+01, 5.5839405721E+00, 9.1784691960E+00, 3.0513817816E+00, 9.2561980118E-01],
	[2.8160000000E+04, 2.5205974907E+01, 5.5839305662E+00, 9.1837973466E+00, 3.0520756622E+00, 9.2565973681E-01],
	[2.8165000000E+04, 2.5213354642E+01, 5.5839205620E+00, 9.1891276430E+00, 3.0527693617E+00, 9.2569965033E-01],
	[2.8170000000E+04, 2.5220735226E+01, 5.5839105597E+00, 9.1944600857E+00, 3.0534628802E+00, 9.2573954177E-01],
	[2.8175000000E+04, 2.5228116661E+01, 5.5839005592E+00, 9.1997946751E+00, 3.0541562175E+00, 9.2577941113E-01],
	[2.8180000000E+04, 2.5235498946E+01, 5.5838905604E+00, 9.2051314118E+00, 3.0548493738E+00, 9.2581925843E-01],
	[2.8185000000E+04, 2.5242882080E+01, 5.5838805635E+00, 9.2104702962E+00, 3.0555423491E+00, 9.2585908367E-01],
	[2.8190000000E+04, 2.5250266065E+01, 5.5838705683E+00, 9.2158113288E+00, 3.0562351432E+00, 9.2589888687E-01],
	[2.8195000000E+04, 2.5257650899E+01, 5.5838605750E+00, 9.2211545101E+00, 3.0569277562E+00, 9.2593866804E-01],
	[2.8200000000E+04, 2.5265036583E+01, 5.5838505834E+00, 9.2264998405E+00, 3.0576201881E+00, 9.2597842719E-01],
	[2.8205000000E+04, 2.5272423116E+01, 5.5838405936E+00, 9.2318473206E+00, 3.0583124388E+00, 9.2601816433E-01],
	[2.8210000000E+04, 2.5279810500E+01, 5.5838306056E+00, 9.2371969508E+00, 3.0590045084E+00, 9.2605787947E-01],
	[2.8215000000E+04, 2.5287198732E+01, 5.5838206194E+00, 9.2425487316E+00, 3.0596963969E+00, 9.2609757263E-01],
	[2.8220000000E+04, 2.5294587815E+01, 5.5838106349E+00, 9.2479026636E+00, 3.0603881041E+00, 9.2613724381E-01],
	[2.8225000000E+04, 2.5301977747E+01, 5.5838006523E+00, 9.2532587471E+00, 3.0610796302E+00, 9.2617689303E-01],
	[2.8230000000E+04, 2.5309368528E+01, 5.5837906714E+00, 9.2586169827E+00, 3.0617709751E+00, 9.2621652030E-01],
	[2.8235000000E+04, 2.5316760159E+01, 5.5837806924E+00, 9.2639773708E+00, 3.0624621388E+00, 9.2625612562E-01],
	[2.8240000000E+04, 2.5324152639E+01, 5.5837707151E+00, 9.2693399120E+00, 3.0631531213E+00, 9.2629570901E-01],
	[2.8245000000E+04, 2.5331545968E+01, 5.5837607396E+00, 9.2747046067E+00, 3.0638439226E+00, 9.2633527048E-01],
	[2.8250000000E+04, 2.5338940147E+01, 5.5837507659E+00, 9.2800714553E+00, 3.0645345426E+00, 9.2637481005E-01],
	[2.8255000000E+04, 2.5346335174E+01, 5.5837407939E+00, 9.2854404585E+00, 3.0652249814E+00, 9.2641432772E-01],
	[2.8260000000E+04, 2.5353731051E+01, 5.5837308238E+00, 9.2908116166E+00, 3.0659152390E+00, 9.2645382350E-01],
	[2.8265000000E+04, 2.5361127777E+01, 5.5837208554E+00, 9.2961849302E+00, 3.0666053152E+00, 9.2649329741E-01],
	[2.8270000000E+04, 2.5368525352E+01, 5.5837108888E+00, 9.3015603997E+00, 3.0672952102E+00, 9.2653274946E-01],
	[2.8275000000E+04, 2.5375923776E+01, 5.5837009240E+00, 9.3069380256E+00, 3.0679849240E+00, 9.2657217965E-01],
	[2.8280000000E+04, 2.5383323049E+01, 5.5836909610E+00, 9.3123178084E+00, 3.0686744564E+00, 9.2661158801E-01],
	[2.8285000000E+04, 2.5390723170E+01, 5.5836809997E+00, 9.3176997486E+00, 3.0693638075E+00, 9.2665097453E-01],
	[2.8290000000E+04, 2.5398124141E+01, 5.5836710403E+00, 9.3230838466E+00, 3.0700529773E+00, 9.2669033924E-01],
	[2.8295000000E+04, 2.5405525960E+01, 5.5836610826E+00, 9.3284701030E+00, 3.0707419658E+00, 9.2672968214E-01],
	[2.8300000000E+04, 2.5412928628E+01, 5.5836511267E+00, 9.3338585182E+00, 3.0714307729E+00, 9.2676900324E-01],
	[2.8305000000E+04, 2.5420332144E+01, 5.5836411725E+00, 9.3392490927E+00, 3.0721193987E+00, 9.2680830256E-01],
	[2.8310000000E+04, 2.5427736509E+01, 5.5836312201E+00, 9.3446418271E+00, 3.0728078432E+00, 9.2684758011E-01],
	[2.8315000000E+04, 2.5435141723E+01, 5.5836212696E+00, 9.3500367217E+00, 3.0734961063E+00, 9.2688683589E-01],
	[2.8320000000E+04, 2.5442547785E+01, 5.5836113207E+00, 9.3554337771E+00, 3.0741841880E+00, 9.2692606992E-01],
	[2.8325000000E+04, 2.5449954696E+01, 5.5836013737E+00, 9.3608329937E+00, 3.0748720883E+00, 9.2696528222E-01],
	[2.8330000000E+04, 2.5457362454E+01, 5.5835914284E+00, 9.3662343720E+00, 3.0755598073E+00, 9.2700447279E-01],
	[2.8335000000E+04, 2.5464771062E+01, 5.5835814849E+00, 9.3716379126E+00, 3.0762473448E+00, 9.2704364163E-01],
	[2.8340000000E+04, 2.5472180517E+01, 5.5835715432E+00, 9.3770436159E+00, 3.0769347009E+00, 9.2708278878E-01],
	[2.8345000000E+04, 2.5479590821E+01, 5.5835616033E+00, 9.3824514823E+00, 3.0776218756E+00, 9.2712191423E-01],
	[2.8350000000E+04, 2.5487001973E+01, 5.5835516651E+00, 9.3878615124E+00, 3.0783088689E+00, 9.2716101799E-01],
	[2.8355000000E+04, 2.5494413973E+01, 5.5835417287E+00, 9.3932737066E+00, 3.0789956808E+00, 9.2720010009E-01],
	[2.8360000000E+04, 2.5501826821E+01, 5.5835317941E+00, 9.3986880655E+00, 3.0796823112E+00, 9.2723916052E-01],
	[2.8365000000E+04, 2.5509240517E+01, 5.5835218612E+00, 9.4041045895E+00, 3.0803687602E+00, 9.2727819930E-01],
	[2.8370000000E+04, 2.5516655061E+01, 5.5835119301E+00, 9.4095232791E+00, 3.0810550277E+00, 9.2731721645E-01],
	[2.8375000000E+04, 2.5524070453E+01, 5.5835020007E+00, 9.4149441348E+00, 3.0817411137E+00, 9.2735621197E-01],
	[2.8380000000E+04, 2.5531486693E+01, 5.5834920732E+00, 9.4203671570E+00, 3.0824270182E+00, 9.2739518587E-01],
	[2.8385000000E+04, 2.5538903781E+01, 5.5834821474E+00, 9.4257923463E+00, 3.0831127413E+00, 9.2743413817E-01],
	[2.8390000000E+04, 2.5546321716E+01, 5.5834722233E+00, 9.4312197032E+00, 3.0837982829E+00, 9.2747306887E-01],
	[2.8395000000E+04, 2.5553740499E+01, 5.5834623011E+00, 9.4366492280E+00, 3.0844836429E+00, 9.2751197800E-01],
	[2.8400000000E+04, 2.5561160130E+01, 5.5834523806E+00, 9.4420809214E+00, 3.0851688215E+00, 9.2755086555E-01],
	[2.8405000000E+04, 2.5568580608E+01, 5.5834424618E+00, 9.4475147837E+00, 3.0858538185E+00, 9.2758973154E-01],
	[2.8410000000E+04, 2.5576001934E+01, 5.5834325449E+00, 9.4529508155E+00, 3.0865386340E+00, 9.2762857599E-01],
	[2.8415000000E+04, 2.5583424108E+01, 5.5834226296E+00, 9.4583890172E+00, 3.0872232680E+00, 9.2766739889E-01],
	[2.8420000000E+04, 2.5590847128E+01, 5.5834127162E+00, 9.4638293894E+00, 3.0879077204E+00, 9.2770620028E-01],
	[2.8425000000E+04, 2.5598270996E+01, 5.5834028045E+00, 9.4692719325E+00, 3.0885919913E+00, 9.2774498014E-01],
	[2.8430000000E+04, 2.5605695712E+01, 5.5833928946E+00, 9.4747166470E+00, 3.0892760806E+00, 9.2778373851E-01],
	[2.8435000000E+04, 2.5613121275E+01, 5.5833829864E+00, 9.4801635334E+00, 3.0899599884E+00, 9.2782247538E-01],
	[2.8440000000E+04, 2.5620547685E+01, 5.5833730800E+00, 9.4856125922E+00, 3.0906437146E+00, 9.2786119078E-01],
	[2.8445000000E+04, 2.5627974942E+01, 5.5833631753E+00, 9.4910638238E+00, 3.0913272592E+00, 9.2789988470E-01],
	[2.8450000000E+04, 2.5635403046E+01, 5.5833532725E+00, 9.4965172288E+00, 3.0920106222E+00, 9.2793855716E-01],
	[2.8455000000E+04, 2.5642831998E+01, 5.5833433713E+00, 9.5019728076E+00, 3.0926938036E+00, 9.2797720818E-01],
	[2.8460000000E+04, 2.5650261796E+01, 5.5833334719E+00, 9.5074305607E+00, 3.0933768034E+00, 9.2801583777E-01],
	[2.8465000000E+04, 2.5657692441E+01, 5.5833235743E+00, 9.5128904886E+00, 3.0940596216E+00, 9.2805444592E-01],
	[2.8470000000E+04, 2.5665123934E+01, 5.5833136785E+00, 9.5183525918E+00, 3.0947422582E+00, 9.2809303267E-01],
	[2.8475000000E+04, 2.5672556273E+01, 5.5833037843E+00, 9.5238168707E+00, 3.0954247132E+00, 9.2813159801E-01],
	[2.8480000000E+04, 2.5679989459E+01, 5.5832938920E+00, 9.5292833259E+00, 3.0961069865E+00, 9.2817014197E-01],
	[2.8485000000E+04, 2.5687423491E+01, 5.5832840014E+00, 9.5347519578E+00, 3.0967890782E+00, 9.2820866454E-01],
	[2.8490000000E+04, 2.5694858371E+01, 5.5832741125E+00, 9.5402227669E+00, 3.0974709883E+00, 9.2824716575E-01],
	[2.8495000000E+04, 2.5702294097E+01, 5.5832642255E+00, 9.5456957537E+00, 3.0981527167E+00, 9.2828564560E-01],
	[2.8500000000E+04, 2.5709730669E+01, 5.5832543401E+00, 9.5511709187E+00, 3.0988342634E+00, 9.2832410411E-01],
	[2.8505000000E+04, 2.5717168089E+01, 5.5832444565E+00, 9.5566482623E+00, 3.0995156285E+00, 9.2836254128E-01],
	[2.8510000000E+04, 2.5724614117E+01, 5.5832355583E+00, 9.5621277851E+00, 3.1001972280E+00, 9.2840095713E-01],
	[2.8515000000E+04, 2.5732080377E+01, 5.5832291170E+00, 9.5676094876E+00, 3.1008796848E+00, 9.2843935166E-01],
	[2.8520000000E+04, 2.5739547495E+01, 5.5832226768E+00, 9.5730933702E+00, 3.1015619607E+00, 9.2847772490E-01],
	[2.8525000000E+04, 2.5747015470E+01, 5.5832162378E+00, 9.5785794333E+00, 3.1022440558E+00, 9.2851607685E-01],
	[2.8530000000E+04, 2.5754484303E+01, 5.5832097999E+00, 9.5840676776E+00, 3.1029259700E+00, 9.2855440752E-01],
	[2.8535000000E+04, 2.5761953992E+01, 5.5832033631E+00, 9.5895581034E+00, 3.1036077032E+00, 9.2859271692E-01],
	[2.8540000000E+04, 2.5769424539E+01, 5.5831969275E+00, 9.5950507113E+00, 3.1042892556E+00, 9.2863100507E-01],
	[2.8545000000E+04, 2.5776895943E+01, 5.5831904930E+00, 9.6005455017E+00, 3.1049706270E+00, 9.2866927198E-01],
	[2.8550000000E+04, 2.5784368203E+01, 5.5831840596E+00, 9.6060424751E+00, 3.1056518175E+00, 9.2870751765E-01],
	[2.8555000000E+04, 2.5791841321E+01, 5.5831776273E+00, 9.6115416321E+00, 3.1063328271E+00, 9.2874574210E-01],
	[2.8560000000E+04, 2.5799315296E+01, 5.5831711962E+00, 9.6170429730E+00, 3.1070136557E+00, 9.2878394534E-01],
	[2.8565000000E+04, 2.5806790128E+01, 5.5831647663E+00, 9.6225464985E+00, 3.1076943034E+00, 9.2882212738E-01],
	[2.8570000000E+04, 2.5814265816E+01, 5.5831583374E+00, 9.6280522088E+00, 3.1083747702E+00, 9.2886028824E-01],
	[2.8575000000E+04, 2.5821742361E+01, 5.5831519097E+00, 9.6335601047E+00, 3.1090550560E+00, 9.2889842792E-01],
	[2.8580000000E+04, 2.5829219763E+01, 5.5831454832E+00, 9.6390701864E+00, 3.1097351609E+00, 9.2893654643E-01],
	[2.8585000000E+04, 2.5836698022E+01, 5.5831390577E+00, 9.6445824546E+00, 3.1104150848E+00, 9.2897464379E-01],
	[2.8590000000E+04, 2.5844177137E+01, 5.5831326334E+00, 9.6500969097E+00, 3.1110948277E+00, 9.2901272001E-01],
	[2.8595000000E+04, 2.5851657109E+01, 5.5831262102E+00, 9.6556135522E+00, 3.1117743896E+00, 9.2905077510E-01],
	[2.8600000000E+04, 2.5859137938E+01, 5.5831197882E+00, 9.6611323825E+00, 3.1124537706E+00, 9.2908880907E-01],
	[2.8605000000E+04, 2.5866619622E+01, 5.5831133673E+00, 9.6666534012E+00, 3.1131329706E+00, 9.2912682193E-01],
	[2.8610000000E+04, 2.5874102164E+01, 5.5831069475E+00, 9.6721766088E+00, 3.1138119896E+00, 9.2916481369E-01],
	[2.8615000000E+04, 2.5881585561E+01, 5.5831005288E+00, 9.6777020056E+00, 3.1144908276E+00, 9.2920278437E-01],
	[2.8620000000E+04, 2.5889069815E+01, 5.5830941113E+00, 9.6832295923E+00, 3.1151694846E+00, 9.2924073397E-01],
	[2.8625000000E+04, 2.5896554926E+01, 5.5830876949E+00, 9.6887593693E+00, 3.1158479606E+00, 9.2927866251E-01],
	[2.8630000000E+04, 2.5904040892E+01, 5.5830812796E+00, 9.6942913370E+00, 3.1165262556E+00, 9.2931657000E-01],
	[2.8635000000E+04, 2.5911527715E+01, 5.5830748655E+00, 9.6998254960E+00, 3.1172043696E+00, 9.2935445645E-01],
	[2.8640000000E+04, 2.5919015394E+01, 5.5830684525E+00, 9.7053618468E+00, 3.1178823025E+00, 9.2939232186E-01],
	[2.8645000000E+04, 2.5926503928E+01, 5.5830620406E+00, 9.7109003898E+00, 3.1185600545E+00, 9.2943016626E-01],
	[2.8650000000E+04, 2.5933993319E+01, 5.5830556298E+00, 9.7164411255E+00, 3.1192376254E+00, 9.2946798965E-01],
	[2.8655000000E+04, 2.5941483566E+01, 5.5830492202E+00, 9.7219840544E+00, 3.1199150152E+00, 9.2950579205E-01],
	[2.8660000000E+04, 2.5948974669E+01, 5.5830428117E+00, 9.7275291770E+00, 3.1205922241E+00, 9.2954357346E-01],
	[2.8665000000E+04, 2.5956466627E+01, 5.5830364043E+00, 9.7330764938E+00, 3.1212692518E+00, 9.2958133390E-01],
	[2.8670000000E+04, 2.5963959442E+01, 5.5830299980E+00, 9.7386260052E+00, 3.1219460986E+00, 9.2961907338E-01],
	[2.8675000000E+04, 2.5971453112E+01, 5.5830235929E+00, 9.7441777118E+00, 3.1226227643E+00, 9.2965679191E-01],
	[2.8680000000E+04, 2.5978947638E+01, 5.5830171889E+00, 9.7497316140E+00, 3.1232992489E+00, 9.2969448950E-01],
	[2.8685000000E+04, 2.5986443019E+01, 5.5830107860E+00, 9.7552877124E+00, 3.1239755525E+00, 9.2973216616E-01],
	[2.8690000000E+04, 2.5993939256E+01, 5.5830043842E+00, 9.7608460073E+00, 3.1246516750E+00, 9.2976982190E-01],
	[2.8695000000E+04, 2.6001436349E+01, 5.5829979835E+00, 9.7664064993E+00, 3.1253276165E+00, 9.2980745674E-01],
	[2.8700000000E+04, 2.6008934297E+01, 5.5829915840E+00, 9.7719691889E+00, 3.1260033768E+00, 9.2984507069E-01],
	[2.8705000000E+04, 2.6016433101E+01, 5.5829851856E+00, 9.7775340765E+00, 3.1266789561E+00, 9.2988266375E-01],
	[2.8710000000E+04, 2.6023932760E+01, 5.5829787884E+00, 9.7831011627E+00, 3.1273543544E+00, 9.2992023594E-01],
	[2.8715000000E+04, 2.6031433274E+01, 5.5829723922E+00, 9.7886704479E+00, 3.1280295715E+00, 9.2995778727E-01],
	[2.8720000000E+04, 2.6038934643E+01, 5.5829659972E+00, 9.7942419326E+00, 3.1287046076E+00, 9.2999531775E-01],
	[2.8725000000E+04, 2.6046436868E+01, 5.5829596032E+00, 9.7998156173E+00, 3.1293794625E+00, 9.3003282739E-01],
	[2.8730000000E+04, 2.6053939948E+01, 5.5829532104E+00, 9.8053915025E+00, 3.1300541364E+00, 9.3007031621E-01],
	[2.8735000000E+04, 2.6061443883E+01, 5.5829468188E+00, 9.8109695886E+00, 3.1307286292E+00, 9.3010778422E-01],
	[2.8740000000E+04, 2.6068948674E+01, 5.5829404282E+00, 9.8165498762E+00, 3.1314029408E+00, 9.3014523142E-01],
	[2.8745000000E+04, 2.6076454319E+01, 5.5829340388E+00, 9.8221323658E+00, 3.1320770714E+00, 9.3018265782E-01],
	[2.8750000000E+04, 2.6083960819E+01, 5.5829276505E+00, 9.8277170577E+00, 3.1327510209E+00, 9.3022006345E-01],
	[2.8755000000E+04, 2.6091468174E+01, 5.5829212633E+00, 9.8333039526E+00, 3.1334247892E+00, 9.3025744830E-01],
	[2.8760000000E+04, 2.6098976384E+01, 5.5829148772E+00, 9.8388930508E+00, 3.1340983765E+00, 9.3029481240E-01],
	[2.8765000000E+04, 2.6106485449E+01, 5.5829084922E+00, 9.8444843530E+00, 3.1347717826E+00, 9.3033215575E-01],
	[2.8770000000E+04, 2.6113995369E+01, 5.5829021084E+00, 9.8500778595E+00, 3.1354450076E+00, 9.3036947837E-01],
	[2.8775000000E+04, 2.6121506143E+01, 5.5828957256E+00, 9.8556735708E+00, 3.1361180515E+00, 9.3040678025E-01],
	[2.8780000000E+04, 2.6129017773E+01, 5.5828893440E+00, 9.8612714875E+00, 3.1367909143E+00, 9.3044406143E-01],
	[2.8785000000E+04, 2.6136530256E+01, 5.5828829635E+00, 9.8668716100E+00, 3.1374635959E+00, 9.3048132190E-01],
	[2.8790000000E+04, 2.6144043594E+01, 5.5828765841E+00, 9.8724739388E+00, 3.1381360964E+00, 9.3051856169E-01],
	[2.8795000000E+04, 2.6151557787E+01, 5.5828702059E+00, 9.8780784744E+00, 3.1388084158E+00, 9.3055578079E-01],
	[2.8800000000E+04, 2.6159072835E+01, 5.5828638287E+00, 9.8836852173E+00, 3.1394805541E+00, 9.3059297923E-01],
	[2.8805000000E+04, 2.6166588736E+01, 5.5828574527E+00, 9.8892941679E+00, 3.1401525112E+00, 9.3063015700E-01],
	[2.8810000000E+04, 2.6174105492E+01, 5.5828510778E+00, 9.8949053268E+00, 3.1408242872E+00, 9.3066731414E-01],
	[2.8815000000E+04, 2.6181623103E+01, 5.5828447039E+00, 9.9005186944E+00, 3.1414958820E+00, 9.3070445063E-01],
	[2.8820000000E+04, 2.6189141567E+01, 5.5828383312E+00, 9.9061342713E+00, 3.1421672957E+00, 9.3074156651E-01],
	[2.8825000000E+04, 2.6196660886E+01, 5.5828319597E+00, 9.9117520578E+00, 3.1428385282E+00, 9.3077866177E-01],
	[2.8830000000E+04, 2.6204181059E+01, 5.5828255892E+00, 9.9173720546E+00, 3.1435095796E+00, 9.3081573643E-01],
	[2.8835000000E+04, 2.6211702086E+01, 5.5828192198E+00, 9.9229942620E+00, 3.1441804499E+00, 9.3085279050E-01],
	[2.8840000000E+04, 2.6219223967E+01, 5.5828128516E+00, 9.9286186805E+00, 3.1448511390E+00, 9.3088982400E-01],
	[2.8845000000E+04, 2.6226746702E+01, 5.5828064844E+00, 9.9342453108E+00, 3.1455216469E+00, 9.3092683692E-01],
	[2.8850000000E+04, 2.6234270292E+01, 5.5828001184E+00, 9.9398741531E+00, 3.1461919737E+00, 9.3096382930E-01],
	[2.8855000000E+04, 2.6241794735E+01, 5.5827937535E+00, 9.9455052081E+00, 3.1468621194E+00, 9.3100080112E-01],
	[2.8860000000E+04, 2.6249320032E+01, 5.5827873897E+00, 9.9511384762E+00, 3.1475320839E+00, 9.3103775242E-01],
	[2.8865000000E+04, 2.6256846182E+01, 5.5827810270E+00, 9.9567739579E+00, 3.1482018672E+00, 9.3107468319E-01],
	[2.8870000000E+04, 2.6264373187E+01, 5.5827746654E+00, 9.9624116536E+00, 3.1488714694E+00, 9.3111159345E-01],
	[2.8875000000E+04, 2.6271901045E+01, 5.5827683049E+00, 9.9680515639E+00, 3.1495408904E+00, 9.3114848321E-01],
	[2.8880000000E+04, 2.6279429757E+01, 5.5827619455E+00, 9.9736936893E+00, 3.1502101302E+00, 9.3118535249E-01],
	[2.8885000000E+04, 2.6286959322E+01, 5.5827555873E+00, 9.9793380302E+00, 3.1508791889E+00, 9.3122220129E-01],
	[2.8890000000E+04, 2.6294489741E+01, 5.5827492301E+00, 9.9849845871E+00, 3.1515480664E+00, 9.3125902962E-01],
	[2.8895000000E+04, 2.6302021013E+01, 5.5827428741E+00, 9.9906333605E+00, 3.1522167627E+00, 9.3129583750E-01],
	[2.8900000000E+04, 2.6309553139E+01, 5.5827365191E+00, 9.9962843509E+00, 3.1528852779E+00, 9.3133262493E-01],
	[2.8905000000E+04, 2.6317086119E+01, 5.5827301653E+00, 1.0001937559E+01, 3.1535536119E+00, 9.3136939194E-01],
	[2.8910000000E+04, 2.6324619951E+01, 5.5827238126E+00, 1.0007592985E+01, 3.1542217648E+00, 9.3140613852E-01],
	[2.8915000000E+04, 2.6332154637E+01, 5.5827174610E+00, 1.0013250629E+01, 3.1548897364E+00, 9.3144286469E-01],
	[2.8920000000E+04, 2.6339690176E+01, 5.5827111104E+00, 1.0018910492E+01, 3.1555575269E+00, 9.3147957047E-01],
	[2.8925000000E+04, 2.6347226569E+01, 5.5827047610E+00, 1.0024572575E+01, 3.1562251363E+00, 9.3151625586E-01],
	[2.8930000000E+04, 2.6354763814E+01, 5.5826984127E+00, 1.0030236878E+01, 3.1568925644E+00, 9.3155292087E-01],
	[2.8935000000E+04, 2.6362301913E+01, 5.5826920655E+00, 1.0035903401E+01, 3.1575598114E+00, 9.3158956552E-01],
	[2.8940000000E+04, 2.6369840865E+01, 5.5826857194E+00, 1.0041572144E+01, 3.1582268772E+00, 9.3162618982E-01],
	[2.8945000000E+04, 2.6377380669E+01, 5.5826793744E+00, 1.0047243110E+01, 3.1588937619E+00, 9.3166279378E-01],
	[2.8950000000E+04, 2.6384921327E+01, 5.5826730305E+00, 1.0052916297E+01, 3.1595604654E+00, 9.3169937740E-01],
	[2.8955000000E+04, 2.6392462837E+01, 5.5826666878E+00, 1.0058591706E+01, 3.1602269877E+00, 9.3173594071E-01],
	[2.8960000000E+04, 2.6400005201E+01, 5.5826603461E+00, 1.0064269338E+01, 3.1608933288E+00, 9.3177248371E-01],
	[2.8965000000E+04, 2.6407548417E+01, 5.5826540055E+00, 1.0069949194E+01, 3.1615594887E+00, 9.3180900641E-01],
	[2.8970000000E+04, 2.6415105816E+01, 5.5826493396E+00, 1.0075631273E+01, 3.1622261955E+00, 9.3184550883E-01],
	[2.8975000000E+04, 2.6422677611E+01, 5.5826463737E+00, 1.0081315577E+01, 3.1628934609E+00, 9.3188199097E-01],
	[2.8980000000E+04, 2.6430250270E+01, 5.5826434083E+00, 1.0087002105E+01, 3.1635605459E+00, 9.3191845285E-01],
	[2.8985000000E+04, 2.6437823791E+01, 5.5826404435E+00, 1.0092690859E+01, 3.1642274505E+00, 9.3195489447E-01],
	[2.8990000000E+04, 2.6445398177E+01, 5.5826374791E+00, 1.0098381839E+01, 3.1648941747E+00, 9.3199131586E-01],
	[2.8995000000E+04, 2.6452973425E+01, 5.5826345153E+00, 1.0104075044E+01, 3.1655607185E+00, 9.3202771702E-01],
	[2.9000000000E+04, 2.6460549537E+01, 5.5826315519E+00, 1.0109770477E+01, 3.1662270819E+00, 9.3206409796E-01],
	[2.9005000000E+04, 2.6468126511E+01, 5.5826285891E+00, 1.0115468136E+01, 3.1668932648E+00, 9.3210045870E-01],
	[2.9010000000E+04, 2.6475704349E+01, 5.5826256268E+00, 1.0121168023E+01, 3.1675592674E+00, 9.3213679923E-01],
	[2.9015000000E+04, 2.6483283050E+01, 5.5826226651E+00, 1.0126870139E+01, 3.1682250895E+00, 9.3217311959E-01],
	[2.9020000000E+04, 2.6490862614E+01, 5.5826197038E+00, 1.0132574483E+01, 3.1688907313E+00, 9.3220941977E-01],
	[2.9025000000E+04, 2.6498443040E+01, 5.5826167430E+00, 1.0138281056E+01, 3.1695561926E+00, 9.3224569979E-01],
	[2.9030000000E+04, 2.6506024330E+01, 5.5826137828E+00, 1.0143989859E+01, 3.1702214735E+00, 9.3228195966E-01],
	[2.9035000000E+04, 2.6513606482E+01, 5.5826108230E+00, 1.0149700892E+01, 3.1708865740E+00, 9.3231819939E-01],
	[2.9040000000E+04, 2.6521189497E+01, 5.5826078638E+00, 1.0155414156E+01, 3.1715514941E+00, 9.3235441899E-01],
	[2.9045000000E+04, 2.6528773375E+01, 5.5826049051E+00, 1.0161129651E+01, 3.1722162338E+00, 9.3239061848E-01],
	[2.9050000000E+04, 2.6536358115E+01, 5.5826019469E+00, 1.0166847377E+01, 3.1728807931E+00, 9.3242679786E-01],
	[2.9055000000E+04, 2.6543943719E+01, 5.5825989892E+00, 1.0172567335E+01, 3.1735451720E+00, 9.3246295714E-01],
	[2.9060000000E+04, 2.6551530184E+01, 5.5825960320E+00, 1.0178289526E+01, 3.1742093705E+00, 9.3249909634E-01],
	[2.9065000000E+04, 2.6559117512E+01, 5.5825930753E+00, 1.0184013950E+01, 3.1748733886E+00, 9.3253521547E-01],
	[2.9070000000E+04, 2.6566705703E+01, 5.5825901192E+00, 1.0189740608E+01, 3.1755372263E+00, 9.3257131454E-01],
	[2.9075000000E+04, 2.6574294756E+01, 5.5825871635E+00, 1.0195469499E+01, 3.1762008836E+00, 9.3260739356E-01],
	[2.9080000000E+04, 2.6581884671E+01, 5.5825842084E+00, 1.0201200626E+01, 3.1768643605E+00, 9.3264345255E-01],
	[2.9085000000E+04, 2.6589475449E+01, 5.5825812537E+00, 1.0206933987E+01, 3.1775276570E+00, 9.3267949150E-01],
	[2.9090000000E+04, 2.6597067089E+01, 5.5825782996E+00, 1.0212669583E+01, 3.1781907731E+00, 9.3271551044E-01],
	[2.9095000000E+04, 2.6604659591E+01, 5.5825753460E+00, 1.0218407416E+01, 3.1788537088E+00, 9.3275150938E-01],
	[2.9100000000E+04, 2.6612252956E+01, 5.5825723929E+00, 1.0224147485E+01, 3.1795164641E+00, 9.3278748832E-01],
	[2.9105000000E+04, 2.6619847182E+01, 5.5825694403E+00, 1.0229889790E+01, 3.1801790390E+00, 9.3282344728E-01],
	[2.9110000000E+04, 2.6627442271E+01, 5.5825664882E+00, 1.0235634334E+01, 3.1808414335E+00, 9.3285938627E-01],
	[2.9115000000E+04, 2.6635038221E+01, 5.5825635366E+00, 1.0241381115E+01, 3.1815036477E+00, 9.3289530530E-01],
	[2.9120000000E+04, 2.6642635034E+01, 5.5825605855E+00, 1.0247130135E+01, 3.1821656814E+00, 9.3293120437E-01],
	[2.9125000000E+04, 2.6650232708E+01, 5.5825576350E+00, 1.0252881393E+01, 3.1828275348E+00, 9.3296708351E-01],
	[2.9130000000E+04, 2.6657831244E+01, 5.5825546849E+00, 1.0258634891E+01, 3.1834892077E+00, 9.3300294271E-01],
	[2.9135000000E+04, 2.6665430642E+01, 5.5825517354E+00, 1.0264390629E+01, 3.1841507003E+00, 9.3303878199E-01],
	[2.9140000000E+04, 2.6673030902E+01, 5.5825487863E+00, 1.0270148607E+01, 3.1848120126E+00, 9.3307460136E-01],
	[2.9145000000E+04, 2.6680632024E+01, 5.5825458378E+00, 1.0275908826E+01, 3.1854731444E+00, 9.3311040084E-01],
	[2.9150000000E+04, 2.6688234007E+01, 5.5825428898E+00, 1.0281671286E+01, 3.1861340959E+00, 9.3314618041E-01],
	[2.9155000000E+04, 2.6695836852E+01, 5.5825399423E+00, 1.0287435988E+01, 3.1867948670E+00, 9.3318194011E-01],
	[2.9160000000E+04, 2.6703440558E+01, 5.5825369953E+00, 1.0293202933E+01, 3.1874554577E+00, 9.3321767994E-01],
	[2.9165000000E+04, 2.6711045126E+01, 5.5825340487E+00, 1.0298972120E+01, 3.1881158680E+00, 9.3325339991E-01],
	[2.9170000000E+04, 2.6718650555E+01, 5.5825311028E+00, 1.0304743550E+01, 3.1887760980E+00, 9.3328910003E-01],
	[2.9175000000E+04, 2.6726256846E+01, 5.5825281573E+00, 1.0310517224E+01, 3.1894361476E+00, 9.3332478030E-01],
	[2.9180000000E+04, 2.6733863998E+01, 5.5825252123E+00, 1.0316293143E+01, 3.1900960169E+00, 9.3336044075E-01],
	[2.9185000000E+04, 2.6741472012E+01, 5.5825222678E+00, 1.0322071306E+01, 3.1907557058E+00, 9.3339608137E-01],
	[2.9190000000E+04, 2.6749080886E+01, 5.5825193238E+00, 1.0327851714E+01, 3.1914152143E+00, 9.3343170219E-01],
	[2.9195000000E+04, 2.6756690622E+01, 5.5825163804E+00, 1.0333634368E+01, 3.1920745425E+00, 9.3346730320E-01],
	[2.9200000000E+04, 2.6764301219E+01, 5.5825134374E+00, 1.0339419269E+01, 3.1927336903E+00, 9.3350288443E-01],
	[2.9205000000E+04, 2.6771912677E+01, 5.5825104949E+00, 1.0345206416E+01, 3.1933926578E+00, 9.3353844587E-01],
	[2.9210000000E+04, 2.6779524997E+01, 5.5825075530E+00, 1.0350995810E+01, 3.1940514449E+00, 9.3357398754E-01],
	[2.9215000000E+04, 2.6787138177E+01, 5.5825046115E+00, 1.0356787452E+01, 3.1947100517E+00, 9.3360950946E-01],
	[2.9220000000E+04, 2.6794752218E+01, 5.5825016706E+00, 1.0362581342E+01, 3.1953684782E+00, 9.3364501162E-01],
	[2.9225000000E+04, 2.6802367120E+01, 5.5824987302E+00, 1.0368377480E+01, 3.1960267243E+00, 9.3368049405E-01],
	[2.9230000000E+04, 2.6809982883E+01, 5.5824957902E+00, 1.0374175868E+01, 3.1966847901E+00, 9.3371595674E-01],
	[2.9235000000E+04, 2.6817599507E+01, 5.5824928508E+00, 1.0379976505E+01, 3.1973426755E+00, 9.3375139972E-01],
	[2.9240000000E+04, 2.6825216991E+01, 5.5824899119E+00, 1.0385779393E+01, 3.1980003806E+00, 9.3378682298E-01],
	[2.9245000000E+04, 2.6832835336E+01, 5.5824869735E+00, 1.0391584531E+01, 3.1986579054E+00, 9.3382222655E-01],
	[2.9250000000E+04, 2.6840454542E+01, 5.5824840356E+00, 1.0397391920E+01, 3.1993152499E+00, 9.3385761043E-01],
	[2.9255000000E+04, 2.6848074609E+01, 5.5824810981E+00, 1.0403201560E+01, 3.1999724141E+00, 9.3389297462E-01],
	[2.9260000000E+04, 2.6855695536E+01, 5.5824781612E+00, 1.0409013453E+01, 3.2006293979E+00, 9.3392831915E-01],
	[2.9265000000E+04, 2.6863317323E+01, 5.5824752248E+00, 1.0414827598E+01, 3.2012862015E+00, 9.3396364402E-01],
	[2.9270000000E+04, 2.6870939971E+01, 5.5824722889E+00, 1.0420643996E+01, 3.2019428247E+00, 9.3399894924E-01],
	[2.9275000000E+04, 2.6878563480E+01, 5.5824693535E+00, 1.0426462648E+01, 3.2025992676E+00, 9.3403423483E-01],
	[2.9280000000E+04, 2.6886187848E+01, 5.5824664186E+00, 1.0432283554E+01, 3.2032555303E+00, 9.3406950078E-01],
	[2.9285000000E+04, 2.6893813077E+01, 5.5824634842E+00, 1.0438106714E+01, 3.2039116126E+00, 9.3410474712E-01],
	[2.9290000000E+04, 2.6901439167E+01, 5.5824605504E+00, 1.0443932129E+01, 3.2045675146E+00, 9.3413997384E-01],
	[2.9295000000E+04, 2.6909066116E+01, 5.5824576170E+00, 1.0449759800E+01, 3.2052232364E+00, 9.3417518097E-01],
	[2.9300000000E+04, 2.6916693926E+01, 5.5824546841E+00, 1.0455589726E+01, 3.2058787779E+00, 9.3421036851E-01],
	[2.9305000000E+04, 2.6924322596E+01, 5.5824517517E+00, 1.0461421910E+01, 3.2065341390E+00, 9.3424553647E-01],
	[2.9310000000E+04, 2.6931952126E+01, 5.5824488198E+00, 1.0467256349E+01, 3.2071893200E+00, 9.3428068487E-01],
	[2.9315000000E+04, 2.6939582516E+01, 5.5824458884E+00, 1.0473093047E+01, 3.2078443206E+00, 9.3431581370E-01],
	[2.9320000000E+04, 2.6947213765E+01, 5.5824429576E+00, 1.0478932002E+01, 3.2084991410E+00, 9.3435092299E-01],
	[2.9325000000E+04, 2.6954845875E+01, 5.5824400272E+00, 1.0484773216E+01, 3.2091537811E+00, 9.3438601274E-01],
	[2.9330000000E+04, 2.6962478845E+01, 5.5824370973E+00, 1.0490616688E+01, 3.2098082410E+00, 9.3442108297E-01],
	[2.9335000000E+04, 2.6970112674E+01, 5.5824341679E+00, 1.0496462420E+01, 3.2104625206E+00, 9.3445613367E-01],
	[2.9340000000E+04, 2.6977747363E+01, 5.5824312391E+00, 1.0502310412E+01, 3.2111166199E+00, 9.3449116487E-01],
	[2.9345000000E+04, 2.6985382912E+01, 5.5824283107E+00, 1.0508160664E+01, 3.2117705391E+00, 9.3452617658E-01],
	[2.9350000000E+04, 2.6993019321E+01, 5.5824253828E+00, 1.0514013177E+01, 3.2124242779E+00, 9.3456116879E-01],
	[2.9355000000E+04, 2.7000656589E+01, 5.5824224554E+00, 1.0519867951E+01, 3.2130778366E+00, 9.3459614153E-01],
	[2.9360000000E+04, 2.7008294717E+01, 5.5824195286E+00, 1.0525724987E+01, 3.2137312150E+00, 9.3463109480E-01],
	[2.9365000000E+04, 2.7015933704E+01, 5.5824166022E+00, 1.0531584286E+01, 3.2143844132E+00, 9.3466602862E-01],
	[2.9370000000E+04, 2.7023573551E+01, 5.5824136763E+00, 1.0537445847E+01, 3.2150374311E+00, 9.3470094299E-01],
	[2.9375000000E+04, 2.7031214257E+01, 5.5824107509E+00, 1.0543309671E+01, 3.2156902689E+00, 9.3473583792E-01],
	[2.9380000000E+04, 2.7038855822E+01, 5.5824078261E+00, 1.0549175759E+01, 3.2163429264E+00, 9.3477071342E-01],
	[2.9385000000E+04, 2.7046498247E+01, 5.5824049017E+00, 1.0555044111E+01, 3.2169954038E+00, 9.3480556951E-01],
	[2.9390000000E+04, 2.7054141531E+01, 5.5824019778E+00, 1.0560914729E+01, 3.2176477009E+00, 9.3484040620E-01],
	[2.9395000000E+04, 2.7061785674E+01, 5.5823990544E+00, 1.0566787611E+01, 3.2182998179E+00, 9.3487522349E-01],
	[2.9400000000E+04, 2.7069430677E+01, 5.5823961316E+00, 1.0572662759E+01, 3.2189517546E+00, 9.3491002139E-01],
	[2.9405000000E+04, 2.7077076538E+01, 5.5823932092E+00, 1.0578540173E+01, 3.2196035112E+00, 9.3494479992E-01],
	[2.9410000000E+04, 2.7084723259E+01, 5.5823902873E+00, 1.0584419854E+01, 3.2202550876E+00, 9.3497955908E-01],
	[2.9415000000E+04, 2.7092370839E+01, 5.5823873659E+00, 1.0590301802E+01, 3.2209064838E+00, 9.3501429889E-01],
	[2.9420000000E+04, 2.7100019277E+01, 5.5823844450E+00, 1.0596186018E+01, 3.2215576999E+00, 9.3504901935E-01],
	[2.9425000000E+04, 2.7107668575E+01, 5.5823815246E+00, 1.0602072502E+01, 3.2222087358E+00, 9.3508372048E-01],
	[2.9430000000E+04, 2.7115318731E+01, 5.5823786048E+00, 1.0607961254E+01, 3.2228595915E+00, 9.3511840228E-01],
	[2.9435000000E+04, 2.7122975824E+01, 5.5823764418E+00, 1.0613852276E+01, 3.2235106052E+00, 9.3515306477E-01],
	[2.9440000000E+04, 2.7130654286E+01, 5.5823768308E+00, 1.0619745567E+01, 3.2241625796E+00, 9.3518770795E-01],
	[2.9445000000E+04, 2.7138333617E+01, 5.5823772198E+00, 1.0625641129E+01, 3.2248143747E+00, 9.3522233184E-01],
	[2.9450000000E+04, 2.7146013817E+01, 5.5823776087E+00, 1.0631538961E+01, 3.2254659903E+00, 9.3525693645E-01],
	[2.9455000000E+04, 2.7153694886E+01, 5.5823779975E+00, 1.0637439064E+01, 3.2261174266E+00, 9.3529152178E-01],
	[2.9460000000E+04, 2.7161376824E+01, 5.5823783863E+00, 1.0643341438E+01, 3.2267686835E+00, 9.3532608785E-01],
	[2.9465000000E+04, 2.7169059632E+01, 5.5823787750E+00, 1.0649246085E+01, 3.2274197610E+00, 9.3536063466E-01],
	[2.9470000000E+04, 2.7176743308E+01, 5.5823791636E+00, 1.0655153004E+01, 3.2280706591E+00, 9.3539516223E-01],
	[2.9475000000E+04, 2.7184427853E+01, 5.5823795522E+00, 1.0661062197E+01, 3.2287213778E+00, 9.3542967057E-01],
	[2.9480000000E+04, 2.7192113268E+01, 5.5823799407E+00, 1.0666973662E+01, 3.2293719172E+00, 9.3546415968E-01],
	[2.9485000000E+04, 2.7199799551E+01, 5.5823803291E+00, 1.0672887402E+01, 3.2300222772E+00, 9.3549862958E-01],
	[2.9490000000E+04, 2.7207486702E+01, 5.5823807174E+00, 1.0678803416E+01, 3.2306724579E+00, 9.3553308028E-01],
	[2.9495000000E+04, 2.7215174723E+01, 5.5823811057E+00, 1.0684721706E+01, 3.2313224592E+00, 9.3556751178E-01],
	[2.9500000000E+04, 2.7222863612E+01, 5.5823814940E+00, 1.0690642271E+01, 3.2319722811E+00, 9.3560192411E-01],
	[2.9505000000E+04, 2.7230553370E+01, 5.5823818821E+00, 1.0696565111E+01, 3.2326219238E+00, 9.3563631726E-01],
	[2.9510000000E+04, 2.7238243996E+01, 5.5823822702E+00, 1.0702490228E+01, 3.2332713871E+00, 9.3567069124E-01],
	[2.9515000000E+04, 2.7245935491E+01, 5.5823826583E+00, 1.0708417623E+01, 3.2339206711E+00, 9.3570504608E-01],
	[2.9520000000E+04, 2.7253627855E+01, 5.5823830463E+00, 1.0714347294E+01, 3.2345697757E+00, 9.3573938177E-01],
	[2.9525000000E+04, 2.7261321087E+01, 5.5823834342E+00, 1.0720279244E+01, 3.2352187011E+00, 9.3577369834E-01],
	[2.9530000000E+04, 2.7269015187E+01, 5.5823838220E+00, 1.0726213472E+01, 3.2358674471E+00, 9.3580799578E-01],
	[2.9535000000E+04, 2.7276710155E+01, 5.5823842098E+00, 1.0732149978E+01, 3.2365160139E+00, 9.3584227411E-01],
	[2.9540000000E+04, 2.7284405992E+01, 5.5823845975E+00, 1.0738088765E+01, 3.2371644014E+00, 9.3587653333E-01],
	[2.9545000000E+04, 2.7292102698E+01, 5.5823849851E+00, 1.0744029831E+01, 3.2378126095E+00, 9.3591077347E-01],
	[2.9550000000E+04, 2.7299800271E+01, 5.5823853727E+00, 1.0749973177E+01, 3.2384606385E+00, 9.3594499453E-01],
	[2.9555000000E+04, 2.7307498712E+01, 5.5823857602E+00, 1.0755918804E+01, 3.2391084881E+00, 9.3597919651E-01],
	[2.9560000000E+04, 2.7315198022E+01, 5.5823861477E+00, 1.0761866713E+01, 3.2397561585E+00, 9.3601337944E-01],
	[2.9565000000E+04, 2.7322898200E+01, 5.5823865350E+00, 1.0767816904E+01, 3.2404036496E+00, 9.3604754331E-01],
	[2.9570000000E+04, 2.7330599245E+01, 5.5823869223E+00, 1.0773769376E+01, 3.2410509614E+00, 9.3608168814E-01],
	[2.9575000000E+04, 2.7338301159E+01, 5.5823873096E+00, 1.0779724132E+01, 3.2416980941E+00, 9.3611581395E-01],
	[2.9580000000E+04, 2.7346003940E+01, 5.5823876968E+00, 1.0785681171E+01, 3.2423450475E+00, 9.3614992073E-01],
	[2.9585000000E+04, 2.7353707590E+01, 5.5823880839E+00, 1.0791640494E+01, 3.2429918216E+00, 9.3618400850E-01],
	[2.9590000000E+04, 2.7361412107E+01, 5.5823884709E+00, 1.0797602101E+01, 3.2436384166E+00, 9.3621807728E-01],
	[2.9595000000E+04, 2.7369117492E+01, 5.5823888579E+00, 1.0803565992E+01, 3.2442848323E+00, 9.3625212706E-01],
	[2.9600000000E+04, 2.7376823745E+01, 5.5823892449E+00, 1.0809532169E+01, 3.2449310688E+00, 9.3628615787E-01],
	[2.9605000000E+04, 2.7384530865E+01, 5.5823896317E+00, 1.0815500632E+01, 3.2455771262E+00, 9.3632016970E-01],
	[2.9610000000E+04, 2.7392238853E+01, 5.5823900185E+00, 1.0821471381E+01, 3.2462230043E+00, 9.3635416258E-01],
	[2.9615000000E+04, 2.7399947708E+01, 5.5823904052E+00, 1.0827444417E+01, 3.2468687032E+00, 9.3638813651E-01],
	[2.9620000000E+04, 2.7407657431E+01, 5.5823907919E+00, 1.0833419740E+01, 3.2475142230E+00, 9.3642209150E-01],
	[2.9625000000E+04, 2.7415368022E+01, 5.5823911785E+00, 1.0839397350E+01, 3.2481595636E+00, 9.3645602756E-01],
	[2.9630000000E+04, 2.7423079479E+01, 5.5823915650E+00, 1.0845377249E+01, 3.2488047251E+00, 9.3648994470E-01],
	[2.9635000000E+04, 2.7430791805E+01, 5.5823919515E+00, 1.0851359437E+01, 3.2494497074E+00, 9.3652384294E-01],
	[2.9640000000E+04, 2.7438504997E+01, 5.5823923379E+00, 1.0857343913E+01, 3.2500945105E+00, 9.3655772228E-01],
	[2.9645000000E+04, 2.7446219057E+01, 5.5823927242E+00, 1.0863330680E+01, 3.2507391346E+00, 9.3659158273E-01],
	[2.9650000000E+04, 2.7453933984E+01, 5.5823931105E+00, 1.0869319736E+01, 3.2513835795E+00, 9.3662542430E-01],
	[2.9655000000E+04, 2.7461649778E+01, 5.5823934967E+00, 1.0875311083E+01, 3.2520278452E+00, 9.3665924700E-01],
	[2.9660000000E+04, 2.7469366440E+01, 5.5823938828E+00, 1.0881304722E+01, 3.2526719319E+00, 9.3669305085E-01],
	[2.9665000000E+04, 2.7477083968E+01, 5.5823942689E+00, 1.0887300652E+01, 3.2533158394E+00, 9.3672683585E-01],
	[2.9670000000E+04, 2.7484802363E+01, 5.5823946549E+00, 1.0893298874E+01, 3.2539595679E+00, 9.3676060201E-01],
	[2.9675000000E+04, 2.7492521626E+01, 5.5823950409E+00, 1.0899299388E+01, 3.2546031173E+00, 9.3679434935E-01],
	[2.9680000000E+04, 2.7500241755E+01, 5.5823954267E+00, 1.0905302196E+01, 3.2552464876E+00, 9.3682807787E-01],
	[2.9685000000E+04, 2.7507962751E+01, 5.5823958126E+00, 1.0911307297E+01, 3.2558896788E+00, 9.3686178758E-01],
	[2.9690000000E+04, 2.7515684614E+01, 5.5823961983E+00, 1.0917314692E+01, 3.2565326910E+00, 9.3689547850E-01],
	[2.9695000000E+04, 2.7523407344E+01, 5.5823965840E+00, 1.0923324382E+01, 3.2571755241E+00, 9.3692915063E-01],
	[2.9700000000E+04, 2.7531130941E+01, 5.5823969696E+00, 1.0929336367E+01, 3.2578181781E+00, 9.3696280398E-01],
	[2.9705000000E+04, 2.7538855404E+01, 5.5823973552E+00, 1.0935350648E+01, 3.2584606532E+00, 9.3699643857E-01],
	[2.9710000000E+04, 2.7546580734E+01, 5.5823977407E+00, 1.0941367224E+01, 3.2591029492E+00, 9.3703005441E-01],
	[2.9715000000E+04, 2.7554306930E+01, 5.5823981261E+00, 1.0947386097E+01, 3.2597450661E+00, 9.3706365150E-01],
	[2.9720000000E+04, 2.7562033993E+01, 5.5823985114E+00, 1.0953407267E+01, 3.2603870041E+00, 9.3709722985E-01],
	[2.9725000000E+04, 2.7569761922E+01, 5.5823988967E+00, 1.0959430734E+01, 3.2610287631E+00, 9.3713078948E-01],
	[2.9730000000E+04, 2.7577490718E+01, 5.5823992820E+00, 1.0965456500E+01, 3.2616703431E+00, 9.3716433039E-01],
	[2.9735000000E+04, 2.7585220381E+01, 5.5823996671E+00, 1.0971484564E+01, 3.2623117440E+00, 9.3719785260E-01],
	[2.9740000000E+04, 2.7592950909E+01, 5.5824000522E+00, 1.0977514927E+01, 3.2629529661E+00, 9.3723135611E-01],
	[2.9745000000E+04, 2.7600682304E+01, 5.5824004373E+00, 1.0983547589E+01, 3.2635940091E+00, 9.3726484094E-01],
	[2.9750000000E+04, 2.7608414565E+01, 5.5824008222E+00, 1.0989582551E+01, 3.2642348732E+00, 9.3729830710E-01],
	[2.9755000000E+04, 2.7616147693E+01, 5.5824012071E+00, 1.0995619814E+01, 3.2648755584E+00, 9.3733175459E-01],
	[2.9760000000E+04, 2.7623881686E+01, 5.5824015920E+00, 1.1001659378E+01, 3.2655160646E+00, 9.3736518343E-01],
	[2.9765000000E+04, 2.7631616546E+01, 5.5824019768E+00, 1.1007701243E+01, 3.2661563919E+00, 9.3739859362E-01],
	[2.9770000000E+04, 2.7639352272E+01, 5.5824023615E+00, 1.1013745410E+01, 3.2667965402E+00, 9.3743198518E-01],
	[2.9775000000E+04, 2.7647088863E+01, 5.5824027461E+00, 1.1019791879E+01, 3.2674365097E+00, 9.3746535812E-01],
	[2.9780000000E+04, 2.7654826321E+01, 5.5824031307E+00, 1.1025840651E+01, 3.2680763003E+00, 9.3749871244E-01],
	[2.9785000000E+04, 2.7662564644E+01, 5.5824035152E+00, 1.1031891727E+01, 3.2687159119E+00, 9.3753204816E-01],
	[2.9790000000E+04, 2.7670303834E+01, 5.5824038997E+00, 1.1037945106E+01, 3.2693553447E+00, 9.3756536529E-01],
	[2.9795000000E+04, 2.7678043889E+01, 5.5824042841E+00, 1.1044000790E+01, 3.2699945986E+00, 9.3759866384E-01],
	[2.9800000000E+04, 2.7685784810E+01, 5.5824046684E+00, 1.1050058779E+01, 3.2706336737E+00, 9.3763194381E-01],
	[2.9805000000E+04, 2.7693526597E+01, 5.5824050527E+00, 1.1056119073E+01, 3.2712725699E+00, 9.3766520522E-01],
	[2.9810000000E+04, 2.7701269249E+01, 5.5824054369E+00, 1.1062181672E+01, 3.2719112873E+00, 9.3769844808E-01],
	[2.9815000000E+04, 2.7709012767E+01, 5.5824058210E+00, 1.1068246579E+01, 3.2725498258E+00, 9.3773167239E-01],
	[2.9820000000E+04, 2.7716757150E+01, 5.5824062051E+00, 1.1074313791E+01, 3.2731881855E+00, 9.3776487818E-01],
	[2.9825000000E+04, 2.7724502399E+01, 5.5824065891E+00, 1.1080383312E+01, 3.2738263664E+00, 9.3779806544E-01],
	[2.9830000000E+04, 2.7732248514E+01, 5.5824069730E+00, 1.1086455140E+01, 3.2744643685E+00, 9.3783123419E-01],
	[2.9835000000E+04, 2.7739995494E+01, 5.5824073569E+00, 1.1092529276E+01, 3.2751021918E+00, 9.3786438444E-01],
	[2.9840000000E+04, 2.7747743339E+01, 5.5824077407E+00, 1.1098605721E+01, 3.2757398364E+00, 9.3789751620E-01],
	[2.9845000000E+04, 2.7755492050E+01, 5.5824081244E+00, 1.1104684475E+01, 3.2763773021E+00, 9.3793062948E-01],
	[2.9850000000E+04, 2.7763241626E+01, 5.5824085081E+00, 1.1110765539E+01, 3.2770145891E+00, 9.3796372428E-01],
	[2.9855000000E+04, 2.7770992067E+01, 5.5824088917E+00, 1.1116848913E+01, 3.2776516974E+00, 9.3799680063E-01],
	[2.9860000000E+04, 2.7778743373E+01, 5.5824092753E+00, 1.1122934598E+01, 3.2782886269E+00, 9.3802985852E-01],
	[2.9865000000E+04, 2.7786495544E+01, 5.5824096588E+00, 1.1129022594E+01, 3.2789253777E+00, 9.3806289798E-01],
	[2.9870000000E+04, 2.7794248581E+01, 5.5824100422E+00, 1.1135112902E+01, 3.2795619497E+00, 9.3809591900E-01],
	[2.9875000000E+04, 2.7802002482E+01, 5.5824104256E+00, 1.1141205522E+01, 3.2801983431E+00, 9.3812892161E-01],
	[2.9880000000E+04, 2.7809757249E+01, 5.5824108089E+00, 1.1147300455E+01, 3.2808345577E+00, 9.3816190580E-01],
	[2.9885000000E+04, 2.7817512880E+01, 5.5824111921E+00, 1.1153397701E+01, 3.2814705937E+00, 9.3819487160E-01],
	[2.9890000000E+04, 2.7825269377E+01, 5.5824115753E+00, 1.1159497261E+01, 3.2821064510E+00, 9.3822781900E-01],
	[2.9895000000E+04, 2.7833026738E+01, 5.5824119584E+00, 1.1165599134E+01, 3.2827421296E+00, 9.3826074803E-01],
	[2.9900000000E+04, 2.7840784964E+01, 5.5824123414E+00, 1.1171703323E+01, 3.2833776296E+00, 9.3829365868E-01],
	[2.9905000000E+04, 2.7848544055E+01, 5.5824127244E+00, 1.1177809826E+01, 3.2840129509E+00, 9.3832655098E-01],
	[2.9910000000E+04, 2.7856316098E+01, 5.5824145985E+00, 1.1183918645E+01, 3.2846487780E+00, 9.3835942493E-01],
	[2.9915000000E+04, 2.7864103223E+01, 5.5824182252E+00, 1.1190029781E+01, 3.2852852313E+00, 9.3839228054E-01],
	[2.9920000000E+04, 2.7871891223E+01, 5.5824218512E+00, 1.1196143233E+01, 3.2859215068E+00, 9.3842511782E-01],
	[2.9925000000E+04, 2.7879680098E+01, 5.5824254767E+00, 1.1202259002E+01, 3.2865576044E+00, 9.3845793678E-01],
	[2.9930000000E+04, 2.7887469848E+01, 5.5824291015E+00, 1.1208377088E+01, 3.2871935241E+00, 9.3849073743E-01],
	[2.9935000000E+04, 2.7895260472E+01, 5.5824327258E+00, 1.1214497493E+01, 3.2878292659E+00, 9.3852351979E-01],
	[2.9940000000E+04, 2.7903051971E+01, 5.5824363494E+00, 1.1220620216E+01, 3.2884648298E+00, 9.3855628386E-01],
	[2.9945000000E+04, 2.7910844345E+01, 5.5824399725E+00, 1.1226745258E+01, 3.2891002159E+00, 9.3858902965E-01],
	[2.9950000000E+04, 2.7918637594E+01, 5.5824435949E+00, 1.1232872620E+01, 3.2897354241E+00, 9.3862175717E-01],
	[2.9955000000E+04, 2.7926431717E+01, 5.5824472168E+00, 1.1239002302E+01, 3.2903704545E+00, 9.3865446643E-01],
	[2.9960000000E+04, 2.7934226714E+01, 5.5824508380E+00, 1.1245134304E+01, 3.2910053071E+00, 9.3868715745E-01],
	[2.9965000000E+04, 2.7942022586E+01, 5.5824544586E+00, 1.1251268628E+01, 3.2916399819E+00, 9.3871983023E-01],
	[2.9970000000E+04, 2.7949819332E+01, 5.5824580787E+00, 1.1257405273E+01, 3.2922744789E+00, 9.3875248478E-01],
	[2.9975000000E+04, 2.7957616953E+01, 5.5824616981E+00, 1.1263544240E+01, 3.2929087980E+00, 9.3878512111E-01],
	[2.9980000000E+04, 2.7965415448E+01, 5.5824653169E+00, 1.1269685529E+01, 3.2935429394E+00, 9.3881773924E-01],
	[2.9985000000E+04, 2.7973214817E+01, 5.5824689352E+00, 1.1275829141E+01, 3.2941769031E+00, 9.3885033917E-01],
	[2.9990000000E+04, 2.7981015060E+01, 5.5824725528E+00, 1.1281975077E+01, 3.2948106889E+00, 9.3888292092E-01],
	[2.9995000000E+04, 2.7988816178E+01, 5.5824761698E+00, 1.1288123337E+01, 3.2954442971E+00, 9.3891548448E-01],
	[3.0000000000E+04, 2.7996618170E+01, 5.5824797863E+00, 1.1294273921E+01, 3.2960777275E+00, 9.3894802989E-01],
	[3.0005000000E+04, 2.8004421035E+01, 5.5824834021E+00, 1.1300460797E+01, 3.2967138709E+00, 9.3898055713E-01],
	[3.0010000000E+04, 2.8012224775E+01, 5.5824870173E+00, 1.1306650030E+01, 3.2973498353E+00, 9.3901306623E-01],
	[3.0015000000E+04, 2.8020029389E+01, 5.5824906319E+00, 1.1312841620E+01, 3.2979856206E+00, 9.3904555719E-01],
	[3.0020000000E+04, 2.8027834877E+01, 5.5824942460E+00, 1.1319035568E+01, 3.2986212268E+00, 9.3907803003E-01],
	[3.0025000000E+04, 2.8035641238E+01, 5.5824978594E+00, 1.1325231875E+01, 3.2992566539E+00, 9.3911048475E-01],
	[3.0030000000E+04, 2.8043448474E+01, 5.5825014722E+00, 1.1331430541E+01, 3.2998919020E+00, 9.3914292137E-01],
	[3.0035000000E+04, 2.8051256583E+01, 5.5825050845E+00, 1.1337631566E+01, 3.3005269709E+00, 9.3917533989E-01],
	[3.0040000000E+04, 2.8059065566E+01, 5.5825086961E+00, 1.1343834951E+01, 3.3011618609E+00, 9.3920774032E-01],
	[3.0045000000E+04, 2.8066875422E+01, 5.5825123071E+00, 1.1350040697E+01, 3.3017965718E+00, 9.3924012268E-01],
	[3.0050000000E+04, 2.8074686153E+01, 5.5825159176E+00, 1.1356248803E+01, 3.3024311037E+00, 9.3927248698E-01],
	[3.0055000000E+04, 2.8082497756E+01, 5.5825195274E+00, 1.1362459272E+01, 3.3030654566E+00, 9.3930483322E-01],
	[3.0060000000E+04, 2.8090310234E+01, 5.5825231366E+00, 1.1368672102E+01, 3.3036996305E+00, 9.3933716141E-01],
	[3.0065000000E+04, 2.8098123585E+01, 5.5825267453E+00, 1.1374887295E+01, 3.3043336254E+00, 9.3936947157E-01],
	[3.0070000000E+04, 2.8105937809E+01, 5.5825303533E+00, 1.1381104851E+01, 3.3049674413E+00, 9.3940176371E-01],
	[3.0075000000E+04, 2.8113752907E+01, 5.5825339608E+00, 1.1387324770E+01, 3.3056010783E+00, 9.3943403783E-01],
	[3.0080000000E+04, 2.8121568878E+01, 5.5825375676E+00, 1.1393547054E+01, 3.3062345363E+00, 9.3946629395E-01],
	[3.0085000000E+04, 2.8129385722E+01, 5.5825411739E+00, 1.1399771702E+01, 3.3068678154E+00, 9.3949853207E-01],
	[3.0090000000E+04, 2.8137203440E+01, 5.5825447795E+00, 1.1405998715E+01, 3.3075009156E+00, 9.3953075221E-01],
	[3.0095000000E+04, 2.8145022031E+01, 5.5825483846E+00, 1.1412228094E+01, 3.3081338369E+00, 9.3956295437E-01],
	[3.0100000000E+04, 2.8152841495E+01, 5.5825519890E+00, 1.1418459838E+01, 3.3087665793E+00, 9.3959513858E-01],
	[3.0105000000E+04, 2.8160661832E+01, 5.5825555929E+00, 1.1424693950E+01, 3.3093991428E+00, 9.3962730482E-01],
	[3.0110000000E+04, 2.8168483042E+01, 5.5825591962E+00, 1.1430930428E+01, 3.3100315274E+00, 9.3965945313E-01],
	[3.0115000000E+04, 2.8176305125E+01, 5.5825627988E+00, 1.1437169274E+01, 3.3106637331E+00, 9.3969158350E-01],
	[3.0120000000E+04, 2.8184128081E+01, 5.5825664009E+00, 1.1443410488E+01, 3.3112957600E+00, 9.3972369594E-01],
	[3.0125000000E+04, 2.8191951910E+01, 5.5825700024E+00, 1.1449654071E+01, 3.3119276081E+00, 9.3975579048E-01],
	[3.0130000000E+04, 2.8199776612E+01, 5.5825736033E+00, 1.1455900023E+01, 3.3125592774E+00, 9.3978786711E-01],
	[3.0135000000E+04, 2.8207602187E+01, 5.5825772036E+00, 1.1462148344E+01, 3.3131907678E+00, 9.3981992584E-01],
	[3.0140000000E+04, 2.8215428635E+01, 5.5825808032E+00, 1.1468399036E+01, 3.3138220795E+00, 9.3985196670E-01],
	[3.0145000000E+04, 2.8223255955E+01, 5.5825844023E+00, 1.1474652098E+01, 3.3144532123E+00, 9.3988398968E-01],
	[3.0150000000E+04, 2.8231084148E+01, 5.5825880008E+00, 1.1480907531E+01, 3.3150841664E+00, 9.3991599480E-01],
	[3.0155000000E+04, 2.8238913214E+01, 5.5825915988E+00, 1.1487165336E+01, 3.3157149418E+00, 9.3994798206E-01],
	[3.0160000000E+04, 2.8246743152E+01, 5.5825951961E+00, 1.1493425514E+01, 3.3163455384E+00, 9.3997995149E-01],
	[3.0165000000E+04, 2.8254573963E+01, 5.5825987928E+00, 1.1499688063E+01, 3.3169759563E+00, 9.4001190308E-01],
	[3.0170000000E+04, 2.8262405646E+01, 5.5826023889E+00, 1.1505952986E+01, 3.3176061954E+00, 9.4004383684E-01],
	[3.0175000000E+04, 2.8270238202E+01, 5.5826059845E+00, 1.1512220283E+01, 3.3182362559E+00, 9.4007575280E-01],
	[3.0180000000E+04, 2.8278071630E+01, 5.5826095794E+00, 1.1518489953E+01, 3.3188661377E+00, 9.4010765095E-01],
	[3.0185000000E+04, 2.8285905930E+01, 5.5826131737E+00, 1.1524761999E+01, 3.3194958408E+00, 9.4013953132E-01],
	[3.0190000000E+04, 2.8293741103E+01, 5.5826167675E+00, 1.1531036419E+01, 3.3201253652E+00, 9.4017139389E-01],
	[3.0195000000E+04, 2.8301577148E+01, 5.5826203607E+00, 1.1537313216E+01, 3.3207547110E+00, 9.4020323870E-01],
	[3.0200000000E+04, 2.8309414066E+01, 5.5826239532E+00, 1.1543592388E+01, 3.3213838781E+00, 9.4023506575E-01],
	[3.0205000000E+04, 2.8317251855E+01, 5.5826275452E+00, 1.1549873937E+01, 3.3220128666E+00, 9.4026687504E-01],
	[3.0210000000E+04, 2.8325090517E+01, 5.5826311366E+00, 1.1556157863E+01, 3.3226416765E+00, 9.4029866659E-01],
	[3.0215000000E+04, 2.8332930050E+01, 5.5826347274E+00, 1.1562444167E+01, 3.3232703079E+00, 9.4033044042E-01],
	[3.0220000000E+04, 2.8340770456E+01, 5.5826383176E+00, 1.1568732850E+01, 3.3238987606E+00, 9.4036219651E-01],
	[3.0225000000E+04, 2.8348611734E+01, 5.5826419072E+00, 1.1575023911E+01, 3.3245270348E+00, 9.4039393490E-01],
	[3.0230000000E+04, 2.8356453883E+01, 5.5826454962E+00, 1.1581317351E+01, 3.3251551304E+00, 9.4042565559E-01],
	[3.0235000000E+04, 2.8364296905E+01, 5.5826490846E+00, 1.1587613171E+01, 3.3257830475E+00, 9.4045735858E-01],
	[3.0240000000E+04, 2.8372140798E+01, 5.5826526725E+00, 1.1593911371E+01, 3.3264107860E+00, 9.4048904390E-01],
	[3.0245000000E+04, 2.8379985563E+01, 5.5826562597E+00, 1.1600211952E+01, 3.3270383461E+00, 9.4052071154E-01],
	[3.0250000000E+04, 2.8387831200E+01, 5.5826598464E+00, 1.1606514914E+01, 3.3276657276E+00, 9.4055236152E-01],
	[3.0255000000E+04, 2.8395677708E+01, 5.5826634324E+00, 1.1612820257E+01, 3.3282929307E+00, 9.4058399385E-01],
	[3.0260000000E+04, 2.8403525089E+01, 5.5826670179E+00, 1.1619127984E+01, 3.3289199553E+00, 9.4061560854E-01],
	[3.0265000000E+04, 2.8411373340E+01, 5.5826706028E+00, 1.1625438092E+01, 3.3295468015E+00, 9.4064720560E-01],
	[3.0270000000E+04, 2.8419222464E+01, 5.5826741871E+00, 1.1631750584E+01, 3.3301734692E+00, 9.4067878504E-01],
	[3.0275000000E+04, 2.8427072458E+01, 5.5826777708E+00, 1.1638065460E+01, 3.3307999584E+00, 9.4071034687E-01],
	[3.0280000000E+04, 2.8434923325E+01, 5.5826813539E+00, 1.1644382721E+01, 3.3314262693E+00, 9.4074189109E-01],
	[3.0285000000E+04, 2.8442775062E+01, 5.5826849364E+00, 1.1650702365E+01, 3.3320524018E+00, 9.4077341773E-01],
	[3.0290000000E+04, 2.8450627671E+01, 5.5826885184E+00, 1.1657024396E+01, 3.3326783559E+00, 9.4080492679E-01],
	[3.0295000000E+04, 2.8458481152E+01, 5.5826920997E+00, 1.1663348812E+01, 3.3333041316E+00, 9.4083641827E-01],
	[3.0300000000E+04, 2.8466335503E+01, 5.5826956805E+00, 1.1669675614E+01, 3.3339297290E+00, 9.4086789219E-01],
	[3.0305000000E+04, 2.8474190726E+01, 5.5826992606E+00, 1.1676004803E+01, 3.3345551480E+00, 9.4089934857E-01],
	[3.0310000000E+04, 2.8482046820E+01, 5.5827028402E+00, 1.1682336380E+01, 3.3351803887E+00, 9.4093078740E-01],
	[3.0315000000E+04, 2.8489903785E+01, 5.5827064192E+00, 1.1688670344E+01, 3.3358054511E+00, 9.4096220869E-01],
	[3.0320000000E+04, 2.8497761622E+01, 5.5827099976E+00, 1.1695006697E+01, 3.3364303352E+00, 9.4099361246E-01],
	[3.0325000000E+04, 2.8505620329E+01, 5.5827135754E+00, 1.1701345438E+01, 3.3370550411E+00, 9.4102499872E-01],
	[3.0330000000E+04, 2.8513479907E+01, 5.5827171527E+00, 1.1707686569E+01, 3.3376795686E+00, 9.4105636746E-01],
	[3.0335000000E+04, 2.8521340356E+01, 5.5827207293E+00, 1.1714030090E+01, 3.3383039179E+00, 9.4108771872E-01],
	[3.0340000000E+04, 2.8529201676E+01, 5.5827243054E+00, 1.1720376001E+01, 3.3389280890E+00, 9.4111905248E-01],
	[3.0345000000E+04, 2.8537063867E+01, 5.5827278808E+00, 1.1726724302E+01, 3.3395520819E+00, 9.4115036876E-01],
	[3.0350000000E+04, 2.8544926929E+01, 5.5827314557E+00, 1.1733074996E+01, 3.3401758966E+00, 9.4118166757E-01],
	[3.0355000000E+04, 2.8552790862E+01, 5.5827350300E+00, 1.1739428081E+01, 3.3407995330E+00, 9.4121294893E-01],
	[3.0360000000E+04, 2.8560655665E+01, 5.5827386037E+00, 1.1745783558E+01, 3.3414229913E+00, 9.4124421283E-01],
	[3.0365000000E+04, 2.8568521339E+01, 5.5827421768E+00, 1.1752141428E+01, 3.3420462715E+00, 9.4127545928E-01],
	[3.0370000000E+04, 2.8576387883E+01, 5.5827457494E+00, 1.1758501692E+01, 3.3426693735E+00, 9.4130668831E-01],
	[3.0375000000E+04, 2.8584255298E+01, 5.5827493213E+00, 1.1764864350E+01, 3.3432922973E+00, 9.4133789991E-01],
	[3.0380000000E+04, 2.8592123584E+01, 5.5827528927E+00, 1.1771229402E+01, 3.3439150431E+00, 9.4136909409E-01],
	[3.0385000000E+04, 2.8599992740E+01, 5.5827564635E+00, 1.1777596849E+01, 3.3445376108E+00, 9.4140027087E-01],
	[3.0390000000E+04, 2.8607867062E+01, 5.5827605579E+00, 1.1783966691E+01, 3.3451602473E+00, 9.4143143025E-01],
	[3.0395000000E+04, 2.8615764004E+01, 5.5827673044E+00, 1.1790338930E+01, 3.3457839560E+00, 9.4146257224E-01],
	[3.0400000000E+04, 2.8623661826E+01, 5.5827740498E+00, 1.1796713564E+01, 3.3464074872E+00, 9.4149369685E-01],
	[3.0405000000E+04, 2.8631560529E+01, 5.5827807941E+00, 1.1803090596E+01, 3.3470308412E+00, 9.4152480409E-01],
	[3.0410000000E+04, 2.8639460112E+01, 5.5827875373E+00, 1.1809470025E+01, 3.3476540177E+00, 9.4155589398E-01],
	[3.0415000000E+04, 2.8647360575E+01, 5.5827942793E+00, 1.1815851852E+01, 3.3482770170E+00, 9.4158696650E-01],
	[3.0420000000E+04, 2.8655261919E+01, 5.5828010203E+00, 1.1822236078E+01, 3.3488998389E+00, 9.4161802169E-01],
	[3.0425000000E+04, 2.8663164142E+01, 5.5828077602E+00, 1.1828622702E+01, 3.3495224835E+00, 9.4164905955E-01],
	[3.0430000000E+04, 2.8671067246E+01, 5.5828144990E+00, 1.1835011726E+01, 3.3501449508E+00, 9.4168008007E-01],
	[3.0435000000E+04, 2.8678971230E+01, 5.5828212367E+00, 1.1841403150E+01, 3.3507672409E+00, 9.4171108329E-01],
	[3.0440000000E+04, 2.8686876093E+01, 5.5828279733E+00, 1.1847796975E+01, 3.3513893537E+00, 9.4174206920E-01],
	[3.0445000000E+04, 2.8694781837E+01, 5.5828347088E+00, 1.1854193200E+01, 3.3520112893E+00, 9.4177303781E-01],
	[3.0450000000E+04, 2.8702688461E+01, 5.5828414432E+00, 1.1860591827E+01, 3.3526330476E+00, 9.4180398913E-01],
	[3.0455000000E+04, 2.8710595964E+01, 5.5828481765E+00, 1.1866992856E+01, 3.3532546287E+00, 9.4183492317E-01],
	[3.0460000000E+04, 2.8718504348E+01, 5.5828549087E+00, 1.1873396287E+01, 3.3538760327E+00, 9.4186583995E-01],
	[3.0465000000E+04, 2.8726413611E+01, 5.5828616398E+00, 1.1879802122E+01, 3.3544972594E+00, 9.4189673946E-01],
	[3.0470000000E+04, 2.8734323754E+01, 5.5828683698E+00, 1.1886210360E+01, 3.3551183090E+00, 9.4192762172E-01],
	[3.0475000000E+04, 2.8742234776E+01, 5.5828750987E+00, 1.1892621002E+01, 3.3557391815E+00, 9.4195848674E-01],
	[3.0480000000E+04, 2.8750146679E+01, 5.5828818266E+00, 1.1899034048E+01, 3.3563598768E+00, 9.4198933453E-01],
	[3.0485000000E+04, 2.8758059460E+01, 5.5828885533E+00, 1.1905449500E+01, 3.3569803950E+00, 9.4202016509E-01],
	[3.0490000000E+04, 2.8765973122E+01, 5.5828952789E+00, 1.1911867357E+01, 3.3576007362E+00, 9.4205097844E-01],
	[3.0495000000E+04, 2.8773887663E+01, 5.5829020035E+00, 1.1918287620E+01, 3.3582209002E+00, 9.4208177458E-01],
	[3.0500000000E+04, 2.8781803083E+01, 5.5829087269E+00, 1.1924710290E+01, 3.3588408872E+00, 9.4211255353E-01],
	[3.0505000000E+04, 2.8789719383E+01, 5.5829154492E+00, 1.1931135367E+01, 3.3594606971E+00, 9.4214331528E-01],
	[3.0510000000E+04, 2.8797636562E+01, 5.5829221705E+00, 1.1937562851E+01, 3.3600803300E+00, 9.4217405986E-01],
	[3.0515000000E+04, 2.8805554621E+01, 5.5829288906E+00, 1.1943992744E+01, 3.3606997859E+00, 9.4220478727E-01],
	[3.0520000000E+04, 2.8813473558E+01, 5.5829356097E+00, 1.1950425045E+01, 3.3613190648E+00, 9.4223549752E-01],
	[3.0525000000E+04, 2.8821393375E+01, 5.5829423277E+00, 1.1956859755E+01, 3.3619381667E+00, 9.4226619062E-01],
	[3.0530000000E+04, 2.8829314072E+01, 5.5829490446E+00, 1.1963296875E+01, 3.3625570916E+00, 9.4229686658E-01],
	[3.0535000000E+04, 2.8837235647E+01, 5.5829557604E+00, 1.1969736405E+01, 3.3631758396E+00, 9.4232752540E-01],
	[3.0540000000E+04, 2.8845158101E+01, 5.5829624751E+00, 1.1976178346E+01, 3.3637944107E+00, 9.4235816710E-01],
	[3.0545000000E+04, 2.8853081435E+01, 5.5829691887E+00, 1.1982622697E+01, 3.3644128048E+00, 9.4238879169E-01],
	[3.0550000000E+04, 2.8861005647E+01, 5.5829759012E+00, 1.1989069461E+01, 3.3650310220E+00, 9.4241939917E-01],
	[3.0555000000E+04, 2.8868930739E+01, 5.5829826126E+00, 1.1995518636E+01, 3.3656490624E+00, 9.4244998955E-01],
	[3.0560000000E+04, 2.8876856709E+01, 5.5829893229E+00, 1.2001970224E+01, 3.3662669259E+00, 9.4248056285E-01],
	[3.0565000000E+04, 2.8884783558E+01, 5.5829960322E+00, 1.2008424226E+01, 3.3668846125E+00, 9.4251111907E-01],
	[3.0570000000E+04, 2.8892711286E+01, 5.5830027403E+00, 1.2014880641E+01, 3.3675021224E+00, 9.4254165821E-01],
	[3.0575000000E+04, 2.8900639893E+01, 5.5830094474E+00, 1.2021339470E+01, 3.3681194554E+00, 9.4257218030E-01],
	[3.0580000000E+04, 2.8908569378E+01, 5.5830161534E+00, 1.2027800714E+01, 3.3687366116E+00, 9.4260268534E-01],
	[3.0585000000E+04, 2.8916499743E+01, 5.5830228583E+00, 1.2034264373E+01, 3.3693535910E+00, 9.4263317334E-01],
	[3.0590000000E+04, 2.8924430985E+01, 5.5830295621E+00, 1.2040730448E+01, 3.3699703936E+00, 9.4266364431E-01],
	[3.0595000000E+04, 2.8932363107E+01, 5.5830362648E+00, 1.2047198939E+01, 3.3705870196E+00, 9.4269409825E-01],
	[3.0600000000E+04, 2.8940296107E+01, 5.5830429664E+00, 1.2053669846E+01, 3.3712034687E+00, 9.4272453518E-01],
	[3.0605000000E+04, 2.8948229985E+01, 5.5830496669E+00, 1.2060143171E+01, 3.3718197412E+00, 9.4275495510E-01],
	[3.0610000000E+04, 2.8956164742E+01, 5.5830563664E+00, 1.2066618914E+01, 3.3724358370E+00, 9.4278535803E-01],
	[3.0615000000E+04, 2.8964100377E+01, 5.5830630648E+00, 1.2073097075E+01, 3.3730517561E+00, 9.4281574397E-01],
	[3.0620000000E+04, 2.8972036891E+01, 5.5830697620E+00, 1.2079577654E+01, 3.3736674985E+00, 9.4284611293E-01],
	[3.0625000000E+04, 2.8979974283E+01, 5.5830764582E+00, 1.2086060653E+01, 3.3742830643E+00, 9.4287646493E-01],
	[3.0630000000E+04, 2.8987912553E+01, 5.5830831534E+00, 1.2092546072E+01, 3.3748984535E+00, 9.4290679997E-01],
	[3.0635000000E+04, 2.8995851701E+01, 5.5830898474E+00, 1.2099033911E+01, 3.3755136661E+00, 9.4293711805E-01],
	[3.0640000000E+04, 2.9003791728E+01, 5.5830965403E+00, 1.2105524170E+01, 3.3761287020E+00, 9.4296741920E-01],
	[3.0645000000E+04, 2.9011732632E+01, 5.5831032322E+00, 1.2112016851E+01, 3.3767435614E+00, 9.4299770341E-01],
	[3.0650000000E+04, 2.9019674415E+01, 5.5831099229E+00, 1.2118511954E+01, 3.3773582443E+00, 9.4302797070E-01],
	[3.0655000000E+04, 2.9027617076E+01, 5.5831166126E+00, 1.2125009479E+01, 3.3779727506E+00, 9.4305822108E-01],
	[3.0660000000E+04, 2.9035560615E+01, 5.5831233012E+00, 1.2131509427E+01, 3.3785870804E+00, 9.4308845455E-01],
	[3.0665000000E+04, 2.9043505031E+01, 5.5831299888E+00, 1.2138011798E+01, 3.3792012337E+00, 9.4311867113E-01],
	[3.0670000000E+04, 2.9051450326E+01, 5.5831366752E+00, 1.2144516593E+01, 3.3798152105E+00, 9.4314887082E-01],
	[3.0675000000E+04, 2.9059396498E+01, 5.5831433606E+00, 1.2151023813E+01, 3.3804290109E+00, 9.4317905363E-01],
	[3.0680000000E+04, 2.9067343549E+01, 5.5831500449E+00, 1.2157533457E+01, 3.3810426348E+00, 9.4320921958E-01],
	[3.0685000000E+04, 2.9075291477E+01, 5.5831567280E+00, 1.2164045526E+01, 3.3816560822E+00, 9.4323936866E-01],
	[3.0690000000E+04, 2.9083240282E+01, 5.5831634102E+00, 1.2170560022E+01, 3.3822693533E+00, 9.4326950090E-01],
	[3.0695000000E+04, 2.9091189966E+01, 5.5831700912E+00, 1.2177076944E+01, 3.3828824480E+00, 9.4329961630E-01],
	[3.0700000000E+04, 2.9099140526E+01, 5.5831767712E+00, 1.2183596292E+01, 3.3834953663E+00, 9.4332971487E-01],
	[3.0705000000E+04, 2.9107091965E+01, 5.5831834500E+00, 1.2190118068E+01, 3.3841081082E+00, 9.4335979661E-01],
	[3.0710000000E+04, 2.9115044281E+01, 5.5831901278E+00, 1.2196642272E+01, 3.3847206738E+00, 9.4338986154E-01],
	[3.0715000000E+04, 2.9122997474E+01, 5.5831968045E+00, 1.2203168904E+01, 3.3853330631E+00, 9.4341990967E-01],
	[3.0720000000E+04, 2.9130951545E+01, 5.5832034802E+00, 1.2209697966E+01, 3.3859452760E+00, 9.4344994100E-01],
	[3.0725000000E+04, 2.9138906494E+01, 5.5832101547E+00, 1.2216229456E+01, 3.3865573127E+00, 9.4347995555E-01],
	[3.0730000000E+04, 2.9146862319E+01, 5.5832168282E+00, 1.2222763377E+01, 3.3871691731E+00, 9.4350995332E-01],
	[3.0735000000E+04, 2.9154819022E+01, 5.5832235006E+00, 1.2229299728E+01, 3.3877808573E+00, 9.4353993432E-01],
	[3.0740000000E+04, 2.9162776602E+01, 5.5832301720E+00, 1.2235838509E+01, 3.3883923653E+00, 9.4356989857E-01],
	[3.0745000000E+04, 2.9170735060E+01, 5.5832368422E+00, 1.2242379723E+01, 3.3890036970E+00, 9.4359984606E-01],
	[3.0750000000E+04, 2.9178694394E+01, 5.5832435114E+00, 1.2248923368E+01, 3.3896148526E+00, 9.4362977682E-01],
	[3.0755000000E+04, 2.9186654606E+01, 5.5832501795E+00, 1.2255469446E+01, 3.3902258319E+00, 9.4365969084E-01],
	[3.0760000000E+04, 2.9194615695E+01, 5.5832568465E+00, 1.2262017957E+01, 3.3908366352E+00, 9.4368958815E-01],
	[3.0765000000E+04, 2.9202577660E+01, 5.5832635124E+00, 1.2268568901E+01, 3.3914472623E+00, 9.4371946874E-01],
	[3.0770000000E+04, 2.9210540503E+01, 5.5832701773E+00, 1.2275122279E+01, 3.3920577132E+00, 9.4374933263E-01],
	[3.0775000000E+04, 2.9218504223E+01, 5.5832768411E+00, 1.2281678092E+01, 3.3926679881E+00, 9.4377917982E-01],
	[3.0780000000E+04, 2.9226468819E+01, 5.5832835038E+00, 1.2288236339E+01, 3.3932780869E+00, 9.4380901033E-01],
	[3.0785000000E+04, 2.9234434293E+01, 5.5832901655E+00, 1.2294797023E+01, 3.3938880096E+00, 9.4383882416E-01],
	[3.0790000000E+04, 2.9242400643E+01, 5.5832968260E+00, 1.2301360142E+01, 3.3944977563E+00, 9.4386862133E-01],
	[3.0795000000E+04, 2.9250367869E+01, 5.5833034855E+00, 1.2307925698E+01, 3.3951073270E+00, 9.4389840183E-01],
	[3.0800000000E+04, 2.9258335973E+01, 5.5833101440E+00, 1.2314493690E+01, 3.3957167217E+00, 9.4392816569E-01],
	[3.0805000000E+04, 2.9266304953E+01, 5.5833168013E+00, 1.2321064121E+01, 3.3963259404E+00, 9.4395791291E-01],
	[3.0810000000E+04, 2.9274274810E+01, 5.5833234576E+00, 1.2327636989E+01, 3.3969349831E+00, 9.4398764350E-01],
	[3.0815000000E+04, 2.9282245543E+01, 5.5833301128E+00, 1.2334212296E+01, 3.3975438499E+00, 9.4401735747E-01],
	[3.0820000000E+04, 2.9290217153E+01, 5.5833367669E+00, 1.2340790042E+01, 3.3981525407E+00, 9.4404705483E-01],
	[3.0825000000E+04, 2.9298189639E+01, 5.5833434200E+00, 1.2347370228E+01, 3.3987610557E+00, 9.4407673558E-01],
	[3.0830000000E+04, 2.9306163002E+01, 5.5833500720E+00, 1.2353952853E+01, 3.3993693947E+00, 9.4410639974E-01],
	[3.0835000000E+04, 2.9314137241E+01, 5.5833567229E+00, 1.2360537920E+01, 3.3999775579E+00, 9.4413604732E-01],
	[3.0840000000E+04, 2.9322112357E+01, 5.5833633728E+00, 1.2367125427E+01, 3.4005855453E+00, 9.4416567832E-01],
	[3.0845000000E+04, 2.9330088348E+01, 5.5833700215E+00, 1.2373715376E+01, 3.4011933568E+00, 9.4419529275E-01],
	[3.0850000000E+04, 2.9338065216E+01, 5.5833766693E+00, 1.2380307767E+01, 3.4018009925E+00, 9.4422489063E-01],
	[3.0855000000E+04, 2.9346042960E+01, 5.5833833159E+00, 1.2386902601E+01, 3.4024084524E+00, 9.4425447196E-01],
	[3.0860000000E+04, 2.9354021581E+01, 5.5833899615E+00, 1.2393499878E+01, 3.4030157366E+00, 9.4428403675E-01],
	[3.0865000000E+04, 2.9362001077E+01, 5.5833966060E+00, 1.2400099598E+01, 3.4036228450E+00, 9.4431358501E-01],
	[3.0870000000E+04, 2.9369981449E+01, 5.5834032494E+00, 1.2406701763E+01, 3.4042297776E+00, 9.4434311675E-01],
	[3.0875000000E+04, 2.9377962698E+01, 5.5834098918E+00, 1.2413306373E+01, 3.4048365346E+00, 9.4437263197E-01],
	[3.0880000000E+04, 2.9385953079E+01, 5.5834175285E+00, 1.2419913427E+01, 3.4054435971E+00, 9.4440213070E-01],
	[3.0885000000E+04, 2.9393961878E+01, 5.5834272780E+00, 1.2426522927E+01, 3.4060515062E+00, 9.4443161293E-01],
	[3.0890000000E+04, 2.9401971563E+01, 5.5834370260E+00, 1.2433134874E+01, 3.4066592404E+00, 9.4446107868E-01],
	[3.0895000000E+04, 2.9409982133E+01, 5.5834467723E+00, 1.2439749267E+01, 3.4072667996E+00, 9.4449052795E-01],
	[3.0900000000E+04, 2.9417993589E+01, 5.5834565172E+00, 1.2446366107E+01, 3.4078741837E+00, 9.4451996076E-01],
	[3.0905000000E+04, 2.9426005931E+01, 5.5834662604E+00, 1.2452985395E+01, 3.4084813930E+00, 9.4454937711E-01],
	[3.0910000000E+04, 2.9434019158E+01, 5.5834760021E+00, 1.2459607132E+01, 3.4090884273E+00, 9.4457877701E-01],
	[3.0915000000E+04, 2.9442033271E+01, 5.5834857423E+00, 1.2466231317E+01, 3.4096952866E+00, 9.4460816048E-01],
	[3.0920000000E+04, 2.9450048269E+01, 5.5834954808E+00, 1.2472857951E+01, 3.4103019711E+00, 9.4463752751E-01],
	[3.0925000000E+04, 2.9458064152E+01, 5.5835052179E+00, 1.2479487035E+01, 3.4109084807E+00, 9.4466687813E-01],
	[3.0930000000E+04, 2.9466080921E+01, 5.5835149533E+00, 1.2486118569E+01, 3.4115148155E+00, 9.4469621233E-01],
	[3.0935000000E+04, 2.9474098575E+01, 5.5835246872E+00, 1.2492752555E+01, 3.4121209754E+00, 9.4472553013E-01],
	[3.0940000000E+04, 2.9482117115E+01, 5.5835344196E+00, 1.2499388991E+01, 3.4127269604E+00, 9.4475483154E-01],
	[3.0945000000E+04, 2.9490136540E+01, 5.5835441504E+00, 1.2506027879E+01, 3.4133327707E+00, 9.4478411656E-01],
	[3.0950000000E+04, 2.9498156850E+01, 5.5835538796E+00, 1.2512669220E+01, 3.4139384062E+00, 9.4481338521E-01],
	[3.0955000000E+04, 2.9506178045E+01, 5.5835636073E+00, 1.2519313013E+01, 3.4145438670E+00, 9.4484263750E-01],
	[3.0960000000E+04, 2.9514200125E+01, 5.5835733335E+00, 1.2525959260E+01, 3.4151491530E+00, 9.4487187342E-01],
	[3.0965000000E+04, 2.9522223090E+01, 5.5835830580E+00, 1.2532607960E+01, 3.4157542643E+00, 9.4490109301E-01],
	[3.0970000000E+04, 2.9530246940E+01, 5.5835927811E+00, 1.2539259115E+01, 3.4163592009E+00, 9.4493029625E-01],
	[3.0975000000E+04, 2.9538271675E+01, 5.5836025025E+00, 1.2545912724E+01, 3.4169639628E+00, 9.4495948316E-01],
	[3.0980000000E+04, 2.9546297295E+01, 5.5836122225E+00, 1.2552568789E+01, 3.4175685501E+00, 9.4498865375E-01],
	[3.0985000000E+04, 2.9554323800E+01, 5.5836219408E+00, 1.2559227310E+01, 3.4181729627E+00, 9.4501780804E-01],
	[3.0990000000E+04, 2.9562351190E+01, 5.5836316576E+00, 1.2565888288E+01, 3.4187772007E+00, 9.4504694602E-01],
	[3.0995000000E+04, 2.9570379465E+01, 5.5836413729E+00, 1.2572551722E+01, 3.4193812641E+00, 9.4507606771E-01],
	[3.1000000000E+04, 2.9578408624E+01, 5.5836510866E+00, 1.2579217613E+01, 3.4199851530E+00, 9.4510517311E-01],
	[3.1005000000E+04, 2.9586438668E+01, 5.5836607988E+00, 1.2585885963E+01, 3.4205888672E+00, 9.4513426224E-01],
	[3.1010000000E+04, 2.9594469596E+01, 5.5836705094E+00, 1.2592556771E+01, 3.4211924070E+00, 9.4516333511E-01],
	[3.1015000000E+04, 2.9602501409E+01, 5.5836802185E+00, 1.2599230037E+01, 3.4217957722E+00, 9.4519239172E-01],
	[3.1020000000E+04, 2.9610534107E+01, 5.5836899260E+00, 1.2605905764E+01, 3.4223989630E+00, 9.4522143208E-01],
	[3.1025000000E+04, 2.9618567689E+01, 5.5836996320E+00, 1.2612583950E+01, 3.4230019792E+00, 9.4525045620E-01],
	[3.1030000000E+04, 2.9626602156E+01, 5.5837093364E+00, 1.2619264596E+01, 3.4236048210E+00, 9.4527946410E-01],
	[3.1035000000E+04, 2.9634637507E+01, 5.5837190393E+00, 1.2625947704E+01, 3.4242074884E+00, 9.4530845577E-01],
	[3.1040000000E+04, 2.9642673743E+01, 5.5837287406E+00, 1.2632633273E+01, 3.4248099814E+00, 9.4533743124E-01],
	[3.1045000000E+04, 2.9650710863E+01, 5.5837384404E+00, 1.2639321304E+01, 3.4254122999E+00, 9.4536639050E-01],
	[3.1050000000E+04, 2.9658748867E+01, 5.5837481387E+00, 1.2646011798E+01, 3.4260144441E+00, 9.4539533357E-01],
	[3.1055000000E+04, 2.9666787755E+01, 5.5837578354E+00, 1.2652704754E+01, 3.4266164140E+00, 9.4542426046E-01],
	[3.1060000000E+04, 2.9674827527E+01, 5.5837675305E+00, 1.2659400174E+01, 3.4272182095E+00, 9.4545317117E-01],
	[3.1065000000E+04, 2.9682868184E+01, 5.5837772241E+00, 1.2666098058E+01, 3.4278198308E+00, 9.4548206572E-01],
	[3.1070000000E+04, 2.9690909725E+01, 5.5837869162E+00, 1.2672798407E+01, 3.4284212777E+00, 9.4551094411E-01],
	[3.1075000000E+04, 2.9698952150E+01, 5.5837966067E+00, 1.2679501221E+01, 3.4290225504E+00, 9.4553980636E-01],
	[3.1080000000E+04, 2.9706995458E+01, 5.5838062957E+00, 1.2686206500E+01, 3.4296236488E+00, 9.4556865246E-01],
	[3.1085000000E+04, 2.9715039651E+01, 5.5838159831E+00, 1.2692914245E+01, 3.4302245730E+00, 9.4559748244E-01],
	[3.1090000000E+04, 2.9723084728E+01, 5.5838256690E+00, 1.2699624457E+01, 3.4308253230E+00, 9.4562629630E-01],
	[3.1095000000E+04, 2.9731130688E+01, 5.5838353534E+00, 1.2706337136E+01, 3.4314258988E+00, 9.4565509405E-01],
	[3.1100000000E+04, 2.9739177533E+01, 5.5838450362E+00, 1.2713052282E+01, 3.4320263005E+00, 9.4568387570E-01],
	[3.1105000000E+04, 2.9747225261E+01, 5.5838547175E+00, 1.2719769897E+01, 3.4326265280E+00, 9.4571264125E-01],
	[3.1110000000E+04, 2.9755273873E+01, 5.5838643972E+00, 1.2726489980E+01, 3.4332265814E+00, 9.4574139072E-01],
	[3.1115000000E+04, 2.9763323369E+01, 5.5838740754E+00, 1.2733212533E+01, 3.4338264608E+00, 9.4577012412E-01],
	[3.1120000000E+04, 2.9771373748E+01, 5.5838837521E+00, 1.2739937554E+01, 3.4344261660E+00, 9.4579884145E-01],
	[3.1125000000E+04, 2.9779425011E+01, 5.5838934272E+00, 1.2746665047E+01, 3.4350256972E+00, 9.4582754273E-01],
	[3.1130000000E+04, 2.9787477157E+01, 5.5839031008E+00, 1.2753395009E+01, 3.4356250543E+00, 9.4585622796E-01],
	[3.1135000000E+04, 2.9795530187E+01, 5.5839127729E+00, 1.2760127443E+01, 3.4362242375E+00, 9.4588489715E-01],
	[3.1140000000E+04, 2.9803584100E+01, 5.5839224434E+00, 1.2766862349E+01, 3.4368232467E+00, 9.4591355031E-01],
	[3.1145000000E+04, 2.9811638897E+01, 5.5839321123E+00, 1.2773599727E+01, 3.4374220819E+00, 9.4594218745E-01],
	[3.1150000000E+04, 2.9819694577E+01, 5.5839417798E+00, 1.2780339577E+01, 3.4380207431E+00, 9.4597080858E-01],
	[3.1155000000E+04, 2.9827751141E+01, 5.5839514457E+00, 1.2787081901E+01, 3.4386192304E+00, 9.4599941371E-01],
	[3.1160000000E+04, 2.9835808588E+01, 5.5839611101E+00, 1.2793826698E+01, 3.4392175439E+00, 9.4602800285E-01],
	[3.1165000000E+04, 2.9843866918E+01, 5.5839707729E+00, 1.2800573970E+01, 3.4398156834E+00, 9.4605657601E-01],
	[3.1170000000E+04, 2.9851926131E+01, 5.5839804342E+00, 1.2807323716E+01, 3.4404136491E+00, 9.4608513319E-01],
	[3.1175000000E+04, 2.9859986227E+01, 5.5839900940E+00, 1.2814075938E+01, 3.4410114410E+00, 9.4611367440E-01],
	[3.1180000000E+04, 2.9868047207E+01, 5.5839997522E+00, 1.2820830635E+01, 3.4416090590E+00, 9.4614219966E-01],
	[3.1185000000E+04, 2.9876109070E+01, 5.5840094089E+00, 1.2827587809E+01, 3.4422065033E+00, 9.4617070897E-01],
	[3.1190000000E+04, 2.9884171815E+01, 5.5840190641E+00, 1.2834347459E+01, 3.4428037738E+00, 9.4619920235E-01],
	[3.1195000000E+04, 2.9892235444E+01, 5.5840287178E+00, 1.2841109587E+01, 3.4434008705E+00, 9.4622767979E-01],
	[3.1200000000E+04, 2.9900299955E+01, 5.5840383699E+00, 1.2847874192E+01, 3.4439977935E+00, 9.4625614132E-01],
	[3.1205000000E+04, 2.9908365350E+01, 5.5840480205E+00, 1.2854641276E+01, 3.4445945428E+00, 9.4628458693E-01],
	[3.1210000000E+04, 2.9916431627E+01, 5.5840576695E+00, 1.2861410838E+01, 3.4451911185E+00, 9.4631301665E-01],
	[3.1215000000E+04, 2.9924498787E+01, 5.5840673170E+00, 1.2868182880E+01, 3.4457875204E+00, 9.4634143047E-01],
	[3.1220000000E+04, 2.9932566830E+01, 5.5840769630E+00, 1.2874957402E+01, 3.4463837488E+00, 9.4636982840E-01],
	[3.1225000000E+04, 2.9940635755E+01, 5.5840866075E+00, 1.2881734404E+01, 3.4469798035E+00, 9.4639821046E-01],
	[3.1230000000E+04, 2.9948705563E+01, 5.5840962505E+00, 1.2888513887E+01, 3.4475756846E+00, 9.4642657666E-01],
	[3.1235000000E+04, 2.9956776254E+01, 5.5841058919E+00, 1.2895295851E+01, 3.4481713922E+00, 9.4645492700E-01],
	[3.1240000000E+04, 2.9964847827E+01, 5.5841155318E+00, 1.2902080298E+01, 3.4487669262E+00, 9.4648326149E-01],
	[3.1245000000E+04, 2.9972920283E+01, 5.5841251701E+00, 1.2908867226E+01, 3.4493622867E+00, 9.4651158015E-01],
	[3.1250000000E+04, 2.9980993622E+01, 5.5841348070E+00, 1.2915656638E+01, 3.4499574737E+00, 9.4653988297E-01],
	[3.1255000000E+04, 2.9989067842E+01, 5.5841444423E+00, 1.2922448532E+01, 3.4505524872E+00, 9.4656816998E-01],
	[3.1260000000E+04, 2.9997142946E+01, 5.5841540761E+00, 1.2929242911E+01, 3.4511473272E+00, 9.4659644117E-01],
	[3.1265000000E+04, 3.0005218931E+01, 5.5841637083E+00, 1.2936039774E+01, 3.4517419938E+00, 9.4662469656E-01],
	[3.1270000000E+04, 3.0013295799E+01, 5.5841733391E+00, 1.2942839123E+01, 3.4523364870E+00, 9.4665293616E-01],
	[3.1275000000E+04, 3.0021373549E+01, 5.5841829683E+00, 1.2949640956E+01, 3.4529308068E+00, 9.4668115997E-01],
	[3.1280000000E+04, 3.0029452181E+01, 5.5841925960E+00, 1.2956445276E+01, 3.4535249533E+00, 9.4670936801E-01],
	[3.1285000000E+04, 3.0037531696E+01, 5.5842022221E+00, 1.2963252082E+01, 3.4541189264E+00, 9.4673756029E-01],
	[3.1290000000E+04, 3.0045612092E+01, 5.5842118468E+00, 1.2970061375E+01, 3.4547127262E+00, 9.4676573680E-01],
	[3.1295000000E+04, 3.0053693371E+01, 5.5842214699E+00, 1.2976873155E+01, 3.4553063526E+00, 9.4679389757E-01],
	[3.1300000000E+04, 3.0061775532E+01, 5.5842310915E+00, 1.2983687424E+01, 3.4558998058E+00, 9.4682204260E-01],
	[3.1305000000E+04, 3.0069858574E+01, 5.5842407116E+00, 1.2990504181E+01, 3.4564930858E+00, 9.4685017190E-01],
	[3.1310000000E+04, 3.0077942499E+01, 5.5842503302E+00, 1.2997323427E+01, 3.4570861925E+00, 9.4687828548E-01],
	[3.1315000000E+04, 3.0086027306E+01, 5.5842599472E+00, 1.3004145163E+01, 3.4576791260E+00, 9.4690638335E-01],
	[3.1320000000E+04, 3.0094112994E+01, 5.5842695628E+00, 1.3010969389E+01, 3.4582718864E+00, 9.4693446551E-01],
	[3.1325000000E+04, 3.0102199564E+01, 5.5842791768E+00, 1.3017796105E+01, 3.4588644735E+00, 9.4696253198E-01],
	[3.1330000000E+04, 3.0110287016E+01, 5.5842887893E+00, 1.3024625312E+01, 3.4594568876E+00, 9.4699058277E-01],
	[3.1335000000E+04, 3.0118375350E+01, 5.5842984002E+00, 1.3031457011E+01, 3.4600491285E+00, 9.4701861788E-01],
	[3.1340000000E+04, 3.0126464565E+01, 5.5843080097E+00, 1.3038291202E+01, 3.4606411963E+00, 9.4704663732E-01],
	[3.1345000000E+04, 3.0134554662E+01, 5.5843176176E+00, 1.3045127886E+01, 3.4612330911E+00, 9.4707464111E-01],
	[3.1350000000E+04, 3.0142645641E+01, 5.5843272241E+00, 1.3051967062E+01, 3.4618248128E+00, 9.4710262925E-01],
	[3.1355000000E+04, 3.0150737501E+01, 5.5843368290E+00, 1.3058808733E+01, 3.4624163615E+00, 9.4713060175E-01],
	[3.1360000000E+04, 3.0158830242E+01, 5.5843464324E+00, 1.3065652897E+01, 3.4630077372E+00, 9.4715855861E-01],
	[3.1365000000E+04, 3.0166923866E+01, 5.5843560342E+00, 1.3072499556E+01, 3.4635989399E+00, 9.4718649986E-01],
	[3.1370000000E+04, 3.0175018370E+01, 5.5843656346E+00, 1.3079348711E+01, 3.4641899697E+00, 9.4721442549E-01],
	[3.1375000000E+04, 3.0183113756E+01, 5.5843752335E+00, 1.3086200360E+01, 3.4647808265E+00, 9.4724233552E-01],
	[3.1380000000E+04, 3.0191233012E+01, 5.5843875701E+00, 1.3093054507E+01, 3.4653728682E+00, 9.4727022996E-01],
	[3.1385000000E+04, 3.0199355711E+01, 5.5844002089E+00, 1.3099911149E+01, 3.4659648882E+00, 9.4729810881E-01],
	[3.1390000000E+04, 3.0207479300E+01, 5.5844128457E+00, 1.3106770290E+01, 3.4665567361E+00, 9.4732597208E-01],
	[3.1395000000E+04, 3.0215603781E+01, 5.5844254805E+00, 1.3113631927E+01, 3.4671484116E+00, 9.4735381979E-01],
	[3.1400000000E+04, 3.0223729152E+01, 5.5844381133E+00, 1.3120496063E+01, 3.4677399150E+00, 9.4738165194E-01],
	[3.1405000000E+04, 3.0231855413E+01, 5.5844507442E+00, 1.3127362698E+01, 3.4683312462E+00, 9.4740946854E-01],
	[3.1410000000E+04, 3.0239982566E+01, 5.5844633730E+00, 1.3134231832E+01, 3.4689224052E+00, 9.4743726960E-01],
	[3.1415000000E+04, 3.0248110609E+01, 5.5844759999E+00, 1.3141103466E+01, 3.4695133921E+00, 9.4746505512E-01],
	[3.1420000000E+04, 3.0256239543E+01, 5.5844886248E+00, 1.3147977600E+01, 3.4701042069E+00, 9.4749282513E-01],
	[3.1425000000E+04, 3.0264369368E+01, 5.5845012477E+00, 1.3154854235E+01, 3.4706948496E+00, 9.4752057962E-01],
	[3.1430000000E+04, 3.0272500082E+01, 5.5845138687E+00, 1.3161733371E+01, 3.4712853202E+00, 9.4754831860E-01],
	[3.1435000000E+04, 3.0280631688E+01, 5.5845264876E+00, 1.3168615009E+01, 3.4718756188E+00, 9.4757604210E-01],
	[3.1440000000E+04, 3.0288764184E+01, 5.5845391046E+00, 1.3175499149E+01, 3.4724657453E+00, 9.4760375010E-01],
	[3.1445000000E+04, 3.0296897570E+01, 5.5845517196E+00, 1.3182385792E+01, 3.4730556999E+00, 9.4763144263E-01],
	[3.1450000000E+04, 3.0305031847E+01, 5.5845643326E+00, 1.3189274938E+01, 3.4736454825E+00, 9.4765911968E-01],
	[3.1455000000E+04, 3.0313167014E+01, 5.5845769437E+00, 1.3196166589E+01, 3.4742350931E+00, 9.4768678128E-01],
	[3.1460000000E+04, 3.0321303071E+01, 5.5845895527E+00, 1.3203060743E+01, 3.4748245318E+00, 9.4771442742E-01],
	[3.1465000000E+04, 3.0329440018E+01, 5.5846021598E+00, 1.3209957403E+01, 3.4754137986E+00, 9.4774205811E-01],
	[3.1470000000E+04, 3.0337577856E+01, 5.5846147650E+00, 1.3216856568E+01, 3.4760028936E+00, 9.4776967337E-01],
	[3.1475000000E+04, 3.0345716584E+01, 5.5846273681E+00, 1.3223758238E+01, 3.4765918167E+00, 9.4779727320E-01],
	[3.1480000000E+04, 3.0353856201E+01, 5.5846399693E+00, 1.3230662416E+01, 3.4771805679E+00, 9.4782485761E-01],
	[3.1485000000E+04, 3.0361996709E+01, 5.5846525685E+00, 1.3237569100E+01, 3.4777691473E+00, 9.4785242661E-01],
	[3.1490000000E+04, 3.0370138107E+01, 5.5846651657E+00, 1.3244478291E+01, 3.4783575550E+00, 9.4787998020E-01],
	[3.1495000000E+04, 3.0378280395E+01, 5.5846777610E+00, 1.3251389991E+01, 3.4789457909E+00, 9.4790751839E-01],
	[3.1500000000E+04, 3.0386423573E+01, 5.5846903542E+00, 1.3258304199E+01, 3.4795338550E+00, 9.4793504120E-01],
	[3.1505000000E+04, 3.0394567640E+01, 5.5847029456E+00, 1.3265220916E+01, 3.4801217475E+00, 9.4796254862E-01],
	[3.1510000000E+04, 3.0402712598E+01, 5.5847155349E+00, 1.3272140142E+01, 3.4807094683E+00, 9.4799004068E-01],
	[3.1515000000E+04, 3.0410858445E+01, 5.5847281223E+00, 1.3279061879E+01, 3.4812970174E+00, 9.4801751737E-01],
	[3.1520000000E+04, 3.0419005182E+01, 5.5847407077E+00, 1.3285986126E+01, 3.4818843948E+00, 9.4804497871E-01],
	[3.1525000000E+04, 3.0427152809E+01, 5.5847532911E+00, 1.3292912883E+01, 3.4824716007E+00, 9.4807242469E-01],
	[3.1530000000E+04, 3.0435301325E+01, 5.5847658726E+00, 1.3299842153E+01, 3.4830586349E+00, 9.4809985534E-01],
	[3.1535000000E+04, 3.0443450731E+01, 5.5847784521E+00, 1.3306773934E+01, 3.4836454976E+00, 9.4812727066E-01],
	[3.1540000000E+04, 3.0451601026E+01, 5.5847910297E+00, 1.3313708229E+01, 3.4842321888E+00, 9.4815467066E-01],
	[3.1545000000E+04, 3.0459752211E+01, 5.5848036052E+00, 1.3320645036E+01, 3.4848187084E+00, 9.4818205534E-01],
	[3.1550000000E+04, 3.0467904286E+01, 5.5848161788E+00, 1.3327584356E+01, 3.4854050566E+00, 9.4820942472E-01],
	[3.1555000000E+04, 3.0476057249E+01, 5.5848287505E+00, 1.3334526191E+01, 3.4859912332E+00, 9.4823677879E-01],
	[3.1560000000E+04, 3.0484211103E+01, 5.5848413202E+00, 1.3341470541E+01, 3.4865772384E+00, 9.4826411758E-01],
	[3.1565000000E+04, 3.0492365845E+01, 5.5848538879E+00, 1.3348417405E+01, 3.4871630723E+00, 9.4829144109E-01],
	[3.1570000000E+04, 3.0500521477E+01, 5.5848664536E+00, 1.3355366785E+01, 3.4877487347E+00, 9.4831874932E-01],
	[3.1575000000E+04, 3.0508677998E+01, 5.5848790174E+00, 1.3362318682E+01, 3.4883342257E+00, 9.4834604229E-01],
	[3.1580000000E+04, 3.0516835409E+01, 5.5848915793E+00, 1.3369273095E+01, 3.4889195454E+00, 9.4837332000E-01],
	[3.1585000000E+04, 3.0524993708E+01, 5.5849041391E+00, 1.3376230025E+01, 3.4895046938E+00, 9.4840058246E-01],
	[3.1590000000E+04, 3.0533152897E+01, 5.5849166971E+00, 1.3383189472E+01, 3.4900896709E+00, 9.4842782968E-01],
	[3.1595000000E+04, 3.0541312975E+01, 5.5849292530E+00, 1.3390151438E+01, 3.4906744767E+00, 9.4845506167E-01],
	[3.1600000000E+04, 3.0549473941E+01, 5.5849418070E+00, 1.3397115923E+01, 3.4912591112E+00, 9.4848227843E-01],
	[3.1605000000E+04, 3.0557635797E+01, 5.5849543590E+00, 1.3404082927E+01, 3.4918435746E+00, 9.4850947998E-01],
	[3.1610000000E+04, 3.0565798542E+01, 5.5849669091E+00, 1.3411052451E+01, 3.4924278667E+00, 9.4853666632E-01],
	[3.1615000000E+04, 3.0573962175E+01, 5.5849794572E+00, 1.3418024494E+01, 3.4930119877E+00, 9.4856383746E-01],
	[3.1620000000E+04, 3.0582126698E+01, 5.5849920034E+00, 1.3424999059E+01, 3.4935959375E+00, 9.4859099341E-01],
	[3.1625000000E+04, 3.0590292109E+01, 5.5850045476E+00, 1.3431976145E+01, 3.4941797162E+00, 9.4861813418E-01],
	[3.1630000000E+04, 3.0598458409E+01, 5.5850170899E+00, 1.3438955752E+01, 3.4947633237E+00, 9.4864525977E-01],
	[3.1635000000E+04, 3.0606625598E+01, 5.5850296302E+00, 1.3445937882E+01, 3.4953467603E+00, 9.4867237019E-01],
	[3.1640000000E+04, 3.0614793675E+01, 5.5850421685E+00, 1.3452922535E+01, 3.4959300257E+00, 9.4869946546E-01],
	[3.1645000000E+04, 3.0622962642E+01, 5.5850547049E+00, 1.3459909711E+01, 3.4965131202E+00, 9.4872654557E-01],
	[3.1650000000E+04, 3.0631132496E+01, 5.5850672394E+00, 1.3466899411E+01, 3.4970960436E+00, 9.4875361054E-01],
	[3.1655000000E+04, 3.0639303239E+01, 5.5850797719E+00, 1.3473891635E+01, 3.4976787961E+00, 9.4878066038E-01],
	[3.1660000000E+04, 3.0647474871E+01, 5.5850923024E+00, 1.3480886384E+01, 3.4982613776E+00, 9.4880769509E-01],
	[3.1665000000E+04, 3.0655647391E+01, 5.5851048310E+00, 1.3487883659E+01, 3.4988437882E+00, 9.4883471469E-01],
	[3.1670000000E+04, 3.0663820800E+01, 5.5851173576E+00, 1.3494883459E+01, 3.4994260279E+00, 9.4886171918E-01],
	[3.1675000000E+04, 3.0671995097E+01, 5.5851298823E+00, 1.3501885785E+01, 3.5000080968E+00, 9.4888870856E-01],
	[3.1680000000E+04, 3.0680170282E+01, 5.5851424051E+00, 1.3508890639E+01, 3.5005899948E+00, 9.4891568285E-01],
	[3.1685000000E+04, 3.0688346356E+01, 5.5851549259E+00, 1.3515898020E+01, 3.5011717219E+00, 9.4894264206E-01],
	[3.1690000000E+04, 3.0696523318E+01, 5.5851674447E+00, 1.3522907929E+01, 3.5017532783E+00, 9.4896958619E-01],
	[3.1695000000E+04, 3.0704701168E+01, 5.5851799616E+00, 1.3529920366E+01, 3.5023346639E+00, 9.4899651525E-01],
	[3.1700000000E+04, 3.0712879906E+01, 5.5851924765E+00, 1.3536935332E+01, 3.5029158787E+00, 9.4902342925E-01],
	[3.1705000000E+04, 3.0721059533E+01, 5.5852049896E+00, 1.3543952828E+01, 3.5034969229E+00, 9.4905032820E-01],
	[3.1710000000E+04, 3.0729240047E+01, 5.5852175006E+00, 1.3550972854E+01, 3.5040777963E+00, 9.4907721210E-01],
	[3.1715000000E+04, 3.0737421450E+01, 5.5852300097E+00, 1.3557995410E+01, 3.5046584991E+00, 9.4910408097E-01],
	[3.1720000000E+04, 3.0745603740E+01, 5.5852425169E+00, 1.3565020497E+01, 3.5052390312E+00, 9.4913093481E-01],
	[3.1725000000E+04, 3.0753786918E+01, 5.5852550221E+00, 1.3572048116E+01, 3.5058193927E+00, 9.4915777363E-01],
	[3.1730000000E+04, 3.0761970985E+01, 5.5852675254E+00, 1.3579078267E+01, 3.5063995836E+00, 9.4918459745E-01],
	[3.1735000000E+04, 3.0770155939E+01, 5.5852800268E+00, 1.3586110950E+01, 3.5069796039E+00, 9.4921140625E-01],
	[3.1740000000E+04, 3.0778341781E+01, 5.5852925262E+00, 1.3593146166E+01, 3.5075594537E+00, 9.4923820007E-01],
	[3.1745000000E+04, 3.0786528511E+01, 5.5853050236E+00, 1.3600183916E+01, 3.5081391330E+00, 9.4926497890E-01],
	[3.1750000000E+04, 3.0794716128E+01, 5.5853175191E+00, 1.3607224200E+01, 3.5087186418E+00, 9.4929174275E-01],
	[3.1755000000E+04, 3.0802904633E+01, 5.5853300127E+00, 1.3614267019E+01, 3.5092979802E+00, 9.4931849162E-01],
	[3.1760000000E+04, 3.0811094026E+01, 5.5853425044E+00, 1.3621312372E+01, 3.5098771481E+00, 9.4934522554E-01],
	[3.1765000000E+04, 3.0819284306E+01, 5.5853549941E+00, 1.3628360261E+01, 3.5104561455E+00, 9.4937194450E-01],
	[3.1770000000E+04, 3.0827475474E+01, 5.5853674818E+00, 1.3635410687E+01, 3.5110349726E+00, 9.4939864852E-01],
	[3.1775000000E+04, 3.0835667530E+01, 5.5853799677E+00, 1.3642463649E+01, 3.5116136294E+00, 9.4942533760E-01],
	[3.1780000000E+04, 3.0843860472E+01, 5.5853924516E+00, 1.3649519148E+01, 3.5121921158E+00, 9.4945201175E-01],
	[3.1785000000E+04, 3.0852054303E+01, 5.5854049335E+00, 1.3656577185E+01, 3.5127704318E+00, 9.4947867099E-01],
	[3.1790000000E+04, 3.0860249020E+01, 5.5854174135E+00, 1.3663637760E+01, 3.5133485777E+00, 9.4950531530E-01],
	[3.1795000000E+04, 3.0868444625E+01, 5.5854298916E+00, 1.3670700874E+01, 3.5139265532E+00, 9.4953194472E-01],
	[3.1800000000E+04, 3.0876641118E+01, 5.5854423678E+00, 1.3677766527E+01, 3.5145043585E+00, 9.4955855923E-01],
	[3.1805000000E+04, 3.0884838497E+01, 5.5854548420E+00, 1.3684834719E+01, 3.5150819936E+00, 9.4958515886E-01],
	[3.1810000000E+04, 3.0893036764E+01, 5.5854673143E+00, 1.3691905452E+01, 3.5156594586E+00, 9.4961174361E-01],
	[3.1815000000E+04, 3.0901235918E+01, 5.5854797846E+00, 1.3698978726E+01, 3.5162367534E+00, 9.4963831349E-01],
	[3.1820000000E+04, 3.0909435959E+01, 5.5854922531E+00, 1.3706054541E+01, 3.5168138780E+00, 9.4966486850E-01],
	[3.1825000000E+04, 3.0917636887E+01, 5.5855047195E+00, 1.3713132898E+01, 3.5173908326E+00, 9.4969140866E-01],
	[3.1830000000E+04, 3.0925838702E+01, 5.5855171841E+00, 1.3720213796E+01, 3.5179676171E+00, 9.4971793397E-01],
	[3.1835000000E+04, 3.0934041404E+01, 5.5855296467E+00, 1.3727297238E+01, 3.5185442315E+00, 9.4974444445E-01],
	[3.1840000000E+04, 3.0942244993E+01, 5.5855421074E+00, 1.3734383223E+01, 3.5191206759E+00, 9.4977094009E-01],
	[3.1845000000E+04, 3.0950449469E+01, 5.5855545662E+00, 1.3741471752E+01, 3.5196969503E+00, 9.4979742091E-01],
	[3.1850000000E+04, 3.0958654832E+01, 5.5855670230E+00, 1.3748562826E+01, 3.5202730548E+00, 9.4982388691E-01],
	[3.1855000000E+04, 3.0966861081E+01, 5.5855794780E+00, 1.3755656444E+01, 3.5208489893E+00, 9.4985033811E-01],
	[3.1860000000E+04, 3.0975068218E+01, 5.5855919309E+00, 1.3762752607E+01, 3.5214247539E+00, 9.4987677451E-01],
	[3.1865000000E+04, 3.0983276241E+01, 5.5856043820E+00, 1.3769851316E+01, 3.5220003486E+00, 9.4990319612E-01],
	[3.1870000000E+04, 3.0991485150E+01, 5.5856168311E+00, 1.3776952572E+01, 3.5225757735E+00, 9.4992960295E-01],
	[3.1875000000E+04, 3.0999694947E+01, 5.5856292784E+00, 1.3784056375E+01, 3.5231510285E+00, 9.4995599501E-01],
	[3.1880000000E+04, 3.1007905630E+01, 5.5856417236E+00, 1.3791162725E+01, 3.5237261137E+00, 9.4998237230E-01],
	[3.1885000000E+04, 3.1016139434E+01, 5.5856567869E+00, 1.3798271623E+01, 3.5243023592E+00, 9.5000873484E-01],
	[3.1890000000E+04, 3.1024377179E+01, 5.5856722068E+00, 1.3805383069E+01, 3.5248786177E+00, 9.5003508262E-01],
	[3.1895000000E+04, 3.1032615820E+01, 5.5856876242E+00, 1.3812497065E+01, 3.5254547070E+00, 9.5006141566E-01],
	[3.1900000000E+04, 3.1040855357E+01, 5.5857030393E+00, 1.3819613610E+01, 3.5260306272E+00, 9.5008773398E-01],
	[3.1905000000E+04, 3.1049095790E+01, 5.5857184520E+00, 1.3826732705E+01, 3.5266063783E+00, 9.5011403756E-01],
	[3.1910000000E+04, 3.1057337118E+01, 5.5857338624E+00, 1.3833854350E+01, 3.5271819604E+00, 9.5014032644E-01],
	[3.1915000000E+04, 3.1065579343E+01, 5.5857492703E+00, 1.3840978546E+01, 3.5277573733E+00, 9.5016660060E-01],
	[3.1920000000E+04, 3.1073822463E+01, 5.5857646759E+00, 1.3848105294E+01, 3.5283326173E+00, 9.5019286006E-01],
	[3.1925000000E+04, 3.1082066478E+01, 5.5857800792E+00, 1.3855234594E+01, 3.5289076922E+00, 9.5021910484E-01],
	[3.1930000000E+04, 3.1090311390E+01, 5.5857954800E+00, 1.3862366447E+01, 3.5294825982E+00, 9.5024533493E-01],
	[3.1935000000E+04, 3.1098557196E+01, 5.5858108785E+00, 1.3869500852E+01, 3.5300573352E+00, 9.5027155034E-01],
	[3.1940000000E+04, 3.1106803899E+01, 5.5858262746E+00, 1.3876637812E+01, 3.5306319033E+00, 9.5029775109E-01],
	[3.1945000000E+04, 3.1115051496E+01, 5.5858416684E+00, 1.3883777325E+01, 3.5312063025E+00, 9.5032393718E-01],
	[3.1950000000E+04, 3.1123299990E+01, 5.5858570597E+00, 1.3890919393E+01, 3.5317805329E+00, 9.5035010861E-01],
	[3.1955000000E+04, 3.1131549378E+01, 5.5858724488E+00, 1.3898064016E+01, 3.5323545944E+00, 9.5037626541E-01],
	[3.1960000000E+04, 3.1139799662E+01, 5.5858878354E+00, 1.3905211195E+01, 3.5329284871E+00, 9.5040240757E-01],
	[3.1965000000E+04, 3.1148050841E+01, 5.5859032197E+00, 1.3912360929E+01, 3.5335022110E+00, 9.5042853511E-01],
	[3.1970000000E+04, 3.1156302916E+01, 5.5859186016E+00, 1.3919513221E+01, 3.5340757662E+00, 9.5045464802E-01],
	[3.1975000000E+04, 3.1164555886E+01, 5.5859339812E+00, 1.3926668070E+01, 3.5346491526E+00, 9.5048074633E-01],
	[3.1980000000E+04, 3.1172809751E+01, 5.5859493584E+00, 1.3933825476E+01, 3.5352223703E+00, 9.5050683004E-01],
	[3.1985000000E+04, 3.1181064511E+01, 5.5859647332E+00, 1.3940985440E+01, 3.5357954194E+00, 9.5053289915E-01],
	[3.1990000000E+04, 3.1189320166E+01, 5.5859801057E+00, 1.3948147964E+01, 3.5363682997E+00, 9.5055895368E-01],
	[3.1995000000E+04, 3.1197576716E+01, 5.5859954758E+00, 1.3955313046E+01, 3.5369410115E+00, 9.5058499363E-01],
	[3.2000000000E+04, 3.1205834161E+01, 5.5860108436E+00, 1.3962480689E+01, 3.5375135547E+00, 9.5061101901E-01],
	[3.2005000000E+04, 3.1214092501E+01, 5.5860262090E+00, 1.3969650891E+01, 3.5380859293E+00, 9.5063702983E-01],
	[3.2010000000E+04, 3.1222351736E+01, 5.5860415720E+00, 1.3976823655E+01, 3.5386581353E+00, 9.5066302610E-01],
	[3.2015000000E+04, 3.1230611866E+01, 5.5860569327E+00, 1.3983998979E+01, 3.5392301729E+00, 9.5068900782E-01],
	[3.2020000000E+04, 3.1238872891E+01, 5.5860722910E+00, 1.3991176866E+01, 3.5398020419E+00, 9.5071497501E-01],
	[3.2025000000E+04, 3.1247134811E+01, 5.5860876470E+00, 1.3998357314E+01, 3.5403737425E+00, 9.5074092767E-01],
	[3.2030000000E+04, 3.1255397625E+01, 5.5861030006E+00, 1.4005540326E+01, 3.5409452747E+00, 9.5076686581E-01],
	[3.2035000000E+04, 3.1263661334E+01, 5.5861183518E+00, 1.4012725901E+01, 3.5415166384E+00, 9.5079278944E-01],
	[3.2040000000E+04, 3.1271925938E+01, 5.5861337007E+00, 1.4019914040E+01, 3.5420878338E+00, 9.5081869856E-01],
	[3.2045000000E+04, 3.1280191436E+01, 5.5861490473E+00, 1.4027104743E+01, 3.5426588608E+00, 9.5084459319E-01],
	[3.2050000000E+04, 3.1288457829E+01, 5.5861643915E+00, 1.4034298011E+01, 3.5432297195E+00, 9.5087047334E-01],
	[3.2055000000E+04, 3.1296725116E+01, 5.5861797334E+00, 1.4041493845E+01, 3.5438004099E+00, 9.5089633900E-01],
	[3.2060000000E+04, 3.1304993298E+01, 5.5861950728E+00, 1.4048692244E+01, 3.5443709320E+00, 9.5092219019E-01],
	[3.2065000000E+04, 3.1313262375E+01, 5.5862104100E+00, 1.4055893210E+01, 3.5449412859E+00, 9.5094802692E-01],
	[3.2070000000E+04, 3.1321532345E+01, 5.5862257448E+00, 1.4063096743E+01, 3.5455114716E+00, 9.5097384920E-01],
	[3.2075000000E+04, 3.1329803211E+01, 5.5862410772E+00, 1.4070302843E+01, 3.5460814891E+00, 9.5099965703E-01],
	[3.2080000000E+04, 3.1338074970E+01, 5.5862564074E+00, 1.4077511511E+01, 3.5466513384E+00, 9.5102545042E-01],
	[3.2085000000E+04, 3.1346347624E+01, 5.5862717351E+00, 1.4084722748E+01, 3.5472210196E+00, 9.5105122938E-01],
	[3.2090000000E+04, 3.1354621172E+01, 5.5862870605E+00, 1.4091936554E+01, 3.5477905327E+00, 9.5107699392E-01],
	[3.2095000000E+04, 3.1362895614E+01, 5.5863023836E+00, 1.4099152929E+01, 3.5483598777E+00, 9.5110274405E-01],
	[3.2100000000E+04, 3.1371170950E+01, 5.5863177043E+00, 1.4106371874E+01, 3.5489290546E+00, 9.5112847977E-01],
	[3.2105000000E+04, 3.1379447181E+01, 5.5863330227E+00, 1.4113593390E+01, 3.5494980636E+00, 9.5115420109E-01],
	[3.2110000000E+04, 3.1387724305E+01, 5.5863483387E+00, 1.4120817477E+01, 3.5500669045E+00, 9.5117990803E-01],
	[3.2115000000E+04, 3.1396002324E+01, 5.5863636524E+00, 1.4128044136E+01, 3.5506355775E+00, 9.5120560058E-01],
	[3.2120000000E+04, 3.1404281236E+01, 5.5863789637E+00, 1.4135273366E+01, 3.5512040825E+00, 9.5123127876E-01],
	[3.2125000000E+04, 3.1412561043E+01, 5.5863942727E+00, 1.4142505170E+01, 3.5517724196E+00, 9.5125694257E-01],
	[3.2130000000E+04, 3.1420841743E+01, 5.5864095794E+00, 1.4149739546E+01, 3.5523405888E+00, 9.5128259203E-01],
	[3.2135000000E+04, 3.1429123337E+01, 5.5864248837E+00, 1.4156976496E+01, 3.5529085902E+00, 9.5130822714E-01],
	[3.2140000000E+04, 3.1437405825E+01, 5.5864401857E+00, 1.4164216020E+01, 3.5534764238E+00, 9.5133384791E-01],
	[3.2145000000E+04, 3.1445689207E+01, 5.5864554854E+00, 1.4171458119E+01, 3.5540440895E+00, 9.5135945435E-01],
	[3.2150000000E+04, 3.1453973482E+01, 5.5864707827E+00, 1.4178702793E+01, 3.5546115875E+00, 9.5138504646E-01],
	[3.2155000000E+04, 3.1462258651E+01, 5.5864860776E+00, 1.4185950043E+01, 3.5551789177E+00, 9.5141062426E-01],
	[3.2160000000E+04, 3.1470544714E+01, 5.5865013703E+00, 1.4193199869E+01, 3.5557460802E+00, 9.5143618775E-01],
	[3.2165000000E+04, 3.1478831670E+01, 5.5865166606E+00, 1.4200452271E+01, 3.5563130751E+00, 9.5146173694E-01],
	[3.2170000000E+04, 3.1487119520E+01, 5.5865319485E+00, 1.4207707251E+01, 3.5568799022E+00, 9.5148727184E-01],
	[3.2175000000E+04, 3.1495408264E+01, 5.5865472342E+00, 1.4214964809E+01, 3.5574465618E+00, 9.5151279246E-01],
	[3.2180000000E+04, 3.1503697901E+01, 5.5865625175E+00, 1.4222224945E+01, 3.5580130537E+00, 9.5153829880E-01],
	[3.2185000000E+04, 3.1511988431E+01, 5.5865777984E+00, 1.4229487660E+01, 3.5585793781E+00, 9.5156379087E-01],
	[3.2190000000E+04, 3.1520279855E+01, 5.5865930771E+00, 1.4236752954E+01, 3.5591455349E+00, 9.5158926868E-01],
	[3.2195000000E+04, 3.1528572172E+01, 5.5866083534E+00, 1.4244020828E+01, 3.5597115242E+00, 9.5161473225E-01],
	[3.2200000000E+04, 3.1536865382E+01, 5.5866236273E+00, 1.4251291282E+01, 3.5602773459E+00, 9.5164018157E-01],
	[3.2205000000E+04, 3.1545159486E+01, 5.5866388990E+00, 1.4258564317E+01, 3.5608430003E+00, 9.5166561666E-01],
	[3.2210000000E+04, 3.1553454483E+01, 5.5866541683E+00, 1.4265839933E+01, 3.5614084872E+00, 9.5169103752E-01],
	[3.2215000000E+04, 3.1561750373E+01, 5.5866694353E+00, 1.4273118131E+01, 3.5619738067E+00, 9.5171644416E-01],
	[3.2220000000E+04, 3.1570047156E+01, 5.5866846999E+00, 1.4280398912E+01, 3.5625389588E+00, 9.5174183659E-01],
	[3.2225000000E+04, 3.1578344832E+01, 5.5866999623E+00, 1.4287682276E+01, 3.5631039435E+00, 9.5176721482E-01],
	[3.2230000000E+04, 3.1586643401E+01, 5.5867152223E+00, 1.4294968223E+01, 3.5636687610E+00, 9.5179257886E-01],
	[3.2235000000E+04, 3.1594942863E+01, 5.5867304800E+00, 1.4302256754E+01, 3.5642334111E+00, 9.5181792871E-01],
	[3.2240000000E+04, 3.1603243219E+01, 5.5867457353E+00, 1.4309547869E+01, 3.5647978940E+00, 9.5184326438E-01],
	[3.2245000000E+04, 3.1611544467E+01, 5.5867609883E+00, 1.4316841569E+01, 3.5653622097E+00, 9.5186858588E-01],
	[3.2250000000E+04, 3.1619846608E+01, 5.5867762390E+00, 1.4324137855E+01, 3.5659263581E+00, 9.5189389322E-01],
	[3.2255000000E+04, 3.1628149641E+01, 5.5867914874E+00, 1.4331436727E+01, 3.5664903394E+00, 9.5191918641E-01],
	[3.2260000000E+04, 3.1636453568E+01, 5.5868067335E+00, 1.4338738185E+01, 3.5670541535E+00, 9.5194446546E-01],
	[3.2265000000E+04, 3.1644758387E+01, 5.5868219772E+00, 1.4346042231E+01, 3.5676178005E+00, 9.5196973036E-01],
	[3.2270000000E+04, 3.1653064099E+01, 5.5868372186E+00, 1.4353348864E+01, 3.5681812804E+00, 9.5199498114E-01],
	[3.2275000000E+04, 3.1661370704E+01, 5.5868524577E+00, 1.4360658085E+01, 3.5687445932E+00, 9.5202021780E-01],
	[3.2280000000E+04, 3.1669678202E+01, 5.5868676945E+00, 1.4367969894E+01, 3.5693077390E+00, 9.5204544034E-01],
	[3.2285000000E+04, 3.1677986591E+01, 5.5868829290E+00, 1.4375284293E+01, 3.5698707178E+00, 9.5207064878E-01],
	[3.2290000000E+04, 3.1686295874E+01, 5.5868981611E+00, 1.4382601281E+01, 3.5704335296E+00, 9.5209584312E-01],
	[3.2295000000E+04, 3.1694606049E+01, 5.5869133910E+00, 1.4389920860E+01, 3.5709961744E+00, 9.5212102338E-01],
	[3.2300000000E+04, 3.1702917116E+01, 5.5869286185E+00, 1.4397243029E+01, 3.5715586524E+00, 9.5214618955E-01],
	[3.2305000000E+04, 3.1711229076E+01, 5.5869438437E+00, 1.4404567789E+01, 3.5721209634E+00, 9.5217134165E-01],
	[3.2310000000E+04, 3.1719541928E+01, 5.5869590665E+00, 1.4411895141E+01, 3.5726831076E+00, 9.5219647969E-01],
	[3.2315000000E+04, 3.1727855673E+01, 5.5869742871E+00, 1.4419225085E+01, 3.5732450850E+00, 9.5222160367E-01],
	[3.2320000000E+04, 3.1736170309E+01, 5.5869895054E+00, 1.4426557622E+01, 3.5738068955E+00, 9.5224671361E-01],
	[3.2325000000E+04, 3.1744485838E+01, 5.5870047213E+00, 1.4433892752E+01, 3.5743685393E+00, 9.5227180950E-01],
	[3.2330000000E+04, 3.1752802260E+01, 5.5870199349E+00, 1.4441230475E+01, 3.5749300163E+00, 9.5229689137E-01],
	[3.2335000000E+04, 3.1761119573E+01, 5.5870351463E+00, 1.4448570793E+01, 3.5754913266E+00, 9.5232195920E-01],
	[3.2340000000E+04, 3.1769437778E+01, 5.5870503553E+00, 1.4455913706E+01, 3.5760524702E+00, 9.5234701303E-01],
	[3.2345000000E+04, 3.1777756876E+01, 5.5870655620E+00, 1.4463259214E+01, 3.5766134471E+00, 9.5237205284E-01],
	[3.2350000000E+04, 3.1786076865E+01, 5.5870807663E+00, 1.4470607318E+01, 3.5771742575E+00, 9.5239707866E-01],
	[3.2355000000E+04, 3.1794397747E+01, 5.5870959684E+00, 1.4477958018E+01, 3.5777349012E+00, 9.5242209049E-01],
	[3.2360000000E+04, 3.1802719521E+01, 5.5871111682E+00, 1.4485311315E+01, 3.5782953783E+00, 9.5244708833E-01],
	[3.2365000000E+04, 3.1811042186E+01, 5.5871263657E+00, 1.4492667209E+01, 3.5788556889E+00, 9.5247207220E-01],
	[3.2370000000E+04, 3.1819365743E+01, 5.5871415608E+00, 1.4500025701E+01, 3.5794158330E+00, 9.5249704210E-01],
	[3.2375000000E+04, 3.1827690192E+01, 5.5871567537E+00, 1.4507386792E+01, 3.5799758106E+00, 9.5252199804E-01],
	[3.2380000000E+04, 3.1836015533E+01, 5.5871719442E+00, 1.4514750481E+01, 3.5805356217E+00, 9.5254694003E-01],
	[3.2385000000E+04, 3.1844341766E+01, 5.5871871325E+00, 1.4522116770E+01, 3.5810952664E+00, 9.5257186808E-01],
	[3.2390000000E+04, 3.1852668890E+01, 5.5872023184E+00, 1.4529485658E+01, 3.5816547448E+00, 9.5259678220E-01],
	[3.2395000000E+04, 3.1861002725E+01, 5.5872181804E+00, 1.4536857147E+01, 3.5822144091E+00, 9.5262168238E-01],
	[3.2400000000E+04, 3.1869356648E+01, 5.5872362773E+00, 1.4544231238E+01, 3.5827750698E+00, 9.5264656865E-01],
	[3.2405000000E+04, 3.1877711471E+01, 5.5872543715E+00, 1.4551607929E+01, 3.5833355647E+00, 9.5267144101E-01],
	[3.2410000000E+04, 3.1886067196E+01, 5.5872724629E+00, 1.4558987223E+01, 3.5838958939E+00, 9.5269629947E-01],
	[3.2415000000E+04, 3.1894423821E+01, 5.5872905516E+00, 1.4566369119E+01, 3.5844560574E+00, 9.5272114403E-01],
	[3.2420000000E+04, 3.1902781347E+01, 5.5873086375E+00, 1.4573753618E+01, 3.5850160551E+00, 9.5274597471E-01],
	[3.2425000000E+04, 3.1911139774E+01, 5.5873267207E+00, 1.4581140720E+01, 3.5855758873E+00, 9.5277079150E-01],
	[3.2430000000E+04, 3.1919499101E+01, 5.5873448012E+00, 1.4588530427E+01, 3.5861355538E+00, 9.5279559443E-01],
	[3.2435000000E+04, 3.1927859329E+01, 5.5873628790E+00, 1.4595922738E+01, 3.5866950547E+00, 9.5282038350E-01],
	[3.2440000000E+04, 3.1936220457E+01, 5.5873809540E+00, 1.4603317654E+01, 3.5872543900E+00, 9.5284515871E-01],
	[3.2445000000E+04, 3.1944582486E+01, 5.5873990263E+00, 1.4610715176E+01, 3.5878135598E+00, 9.5286992007E-01],
	[3.2450000000E+04, 3.1952945415E+01, 5.5874170959E+00, 1.4618115304E+01, 3.5883725641E+00, 9.5289466760E-01],
	[3.2455000000E+04, 3.1961309245E+01, 5.5874351627E+00, 1.4625518039E+01, 3.5889314029E+00, 9.5291940130E-01],
	[3.2460000000E+04, 3.1969673974E+01, 5.5874532269E+00, 1.4632923380E+01, 3.5894900763E+00, 9.5294412118E-01],
	[3.2465000000E+04, 3.1978039605E+01, 5.5874712883E+00, 1.4640331330E+01, 3.5900485843E+00, 9.5296882724E-01],
	[3.2470000000E+04, 3.1986406135E+01, 5.5874893470E+00, 1.4647741887E+01, 3.5906069268E+00, 9.5299351950E-01],
	[3.2475000000E+04, 3.1994773566E+01, 5.5875074029E+00, 1.4655155054E+01, 3.5911651040E+00, 9.5301819796E-01],
	[3.2480000000E+04, 3.2003141896E+01, 5.5875254562E+00, 1.4662570829E+01, 3.5917231159E+00, 9.5304286263E-01],
	[3.2485000000E+04, 3.2011511127E+01, 5.5875435067E+00, 1.4669989214E+01, 3.5922809625E+00, 9.5306751352E-01],
	[3.2490000000E+04, 3.2019881258E+01, 5.5875615545E+00, 1.4677410210E+01, 3.5928386438E+00, 9.5309215063E-01],
	[3.2495000000E+04, 3.2028252289E+01, 5.5875795995E+00, 1.4684833816E+01, 3.5933961598E+00, 9.5311677398E-01],
	[3.2500000000E+04, 3.2036624220E+01, 5.5875976419E+00, 1.4692260033E+01, 3.5939535107E+00, 9.5314138358E-01],
	[3.2505000000E+04, 3.2044997051E+01, 5.5876156815E+00, 1.4699688863E+01, 3.5945106963E+00, 9.5316597942E-01],
	[3.2510000000E+04, 3.2053370782E+01, 5.5876337185E+00, 1.4707120304E+01, 3.5950677168E+00, 9.5319056152E-01],
	[3.2515000000E+04, 3.2061745413E+01, 5.5876517527E+00, 1.4714554359E+01, 3.5956245722E+00, 9.5321512989E-01],
	[3.2520000000E+04, 3.2070120944E+01, 5.5876697842E+00, 1.4721991026E+01, 3.5961812625E+00, 9.5323968454E-01],
	[3.2525000000E+04, 3.2078497374E+01, 5.5876878130E+00, 1.4729430308E+01, 3.5967377877E+00, 9.5326422546E-01],
	[3.2530000000E+04, 3.2086874704E+01, 5.5877058390E+00, 1.4736872204E+01, 3.5972941479E+00, 9.5328875268E-01],
	[3.2535000000E+04, 3.2095252934E+01, 5.5877238624E+00, 1.4744316715E+01, 3.5978503431E+00, 9.5331326620E-01],
	[3.2540000000E+04, 3.2103632064E+01, 5.5877418830E+00, 1.4751763841E+01, 3.5984063733E+00, 9.5333776602E-01],
	[3.2545000000E+04, 3.2112012093E+01, 5.5877599010E+00, 1.4759213583E+01, 3.5989622385E+00, 9.5336225216E-01],
	[3.2550000000E+04, 3.2120393022E+01, 5.5877779162E+00, 1.4766665942E+01, 3.5995179388E+00, 9.5338672462E-01],
	[3.2555000000E+04, 3.2128774850E+01, 5.5877959287E+00, 1.4774120917E+01, 3.6000734743E+00, 9.5341118341E-01],
	[3.2560000000E+04, 3.2137157578E+01, 5.5878139385E+00, 1.4781578510E+01, 3.6006288449E+00, 9.5343562854E-01],
	[3.2565000000E+04, 3.2145541205E+01, 5.5878319456E+00, 1.4789038721E+01, 3.6011840507E+00, 9.5346006001E-01],
	[3.2570000000E+04, 3.2153925732E+01, 5.5878499500E+00, 1.4796501551E+01, 3.6017390916E+00, 9.5348447783E-01],
	[3.2575000000E+04, 3.2162311158E+01, 5.5878679517E+00, 1.4803966999E+01, 3.6022939678E+00, 9.5350888201E-01],
	[3.2580000000E+04, 3.2170697484E+01, 5.5878859507E+00, 1.4811435067E+01, 3.6028486793E+00, 9.5353327256E-01],
	[3.2585000000E+04, 3.2179084708E+01, 5.5879039469E+00, 1.4818905756E+01, 3.6034032261E+00, 9.5355764948E-01],
	[3.2590000000E+04, 3.2187472832E+01, 5.5879219405E+00, 1.4826379064E+01, 3.6039576081E+00, 9.5358201279E-01],
	[3.2595000000E+04, 3.2195861855E+01, 5.5879399314E+00, 1.4833854994E+01, 3.6045118256E+00, 9.5360636248E-01],
	[3.2600000000E+04, 3.2204251778E+01, 5.5879579196E+00, 1.4841333546E+01, 3.6050658784E+00, 9.5363069856E-01],
	[3.2605000000E+04, 3.2212642599E+01, 5.5879759050E+00, 1.4848814719E+01, 3.6056197666E+00, 9.5365502105E-01],
	[3.2610000000E+04, 3.2221034320E+01, 5.5879938878E+00, 1.4856298515E+01, 3.6061734903E+00, 9.5367932996E-01],
	[3.2615000000E+04, 3.2229426939E+01, 5.5880118679E+00, 1.4863784935E+01, 3.6067270494E+00, 9.5370362527E-01],
	[3.2620000000E+04, 3.2237820458E+01, 5.5880298452E+00, 1.4871273978E+01, 3.6072804441E+00, 9.5372790702E-01],
	[3.2625000000E+04, 3.2246214876E+01, 5.5880478199E+00, 1.4878765645E+01, 3.6078336743E+00, 9.5375217519E-01],
	[3.2630000000E+04, 3.2254610192E+01, 5.5880657919E+00, 1.4886259937E+01, 3.6083867400E+00, 9.5377642981E-01],
	[3.2635000000E+04, 3.2263006407E+01, 5.5880837612E+00, 1.4893756854E+01, 3.6089396414E+00, 9.5380067087E-01],
	[3.2640000000E+04, 3.2271403522E+01, 5.5881017278E+00, 1.4901256397E+01, 3.6094923783E+00, 9.5382489839E-01],
	[3.2645000000E+04, 3.2279801535E+01, 5.5881196917E+00, 1.4908758566E+01, 3.6100449509E+00, 9.5384911237E-01],
	[3.2650000000E+04, 3.2288200446E+01, 5.5881376529E+00, 1.4916263362E+01, 3.6105973592E+00, 9.5387331282E-01],
	[3.2655000000E+04, 3.2296600257E+01, 5.5881556114E+00, 1.4923770785E+01, 3.6111496033E+00, 9.5389749974E-01],
	[3.2660000000E+04, 3.2305000966E+01, 5.5881735672E+00, 1.4931280836E+01, 3.6117016830E+00, 9.5392167315E-01],
	[3.2665000000E+04, 3.2313402574E+01, 5.5881915203E+00, 1.4938793515E+01, 3.6122535986E+00, 9.5394583305E-01],
	[3.2670000000E+04, 3.2321805080E+01, 5.5882094707E+00, 1.4946308823E+01, 3.6128053499E+00, 9.5396997945E-01],
	[3.2675000000E+04, 3.2330208485E+01, 5.5882274185E+00, 1.4953826761E+01, 3.6133569371E+00, 9.5399411236E-01],
	[3.2680000000E+04, 3.2338612789E+01, 5.5882453635E+00, 1.4961347328E+01, 3.6139083601E+00, 9.5401823178E-01],
	[3.2685000000E+04, 3.2347017990E+01, 5.5882633059E+00, 1.4968870526E+01, 3.6144596191E+00, 9.5404233772E-01],
	[3.2690000000E+04, 3.2355424091E+01, 5.5882812456E+00, 1.4976396355E+01, 3.6150107139E+00, 9.5406643018E-01],
	[3.2695000000E+04, 3.2363831089E+01, 5.5882991826E+00, 1.4983924815E+01, 3.6155616448E+00, 9.5409050919E-01],
	[3.2700000000E+04, 3.2372238987E+01, 5.5883171169E+00, 1.4991455907E+01, 3.6161124116E+00, 9.5411457473E-01],
	[3.2705000000E+04, 3.2380647782E+01, 5.5883350485E+00, 1.4998989631E+01, 3.6166630144E+00, 9.5413862683E-01],
	[3.2710000000E+04, 3.2389057475E+01, 5.5883529775E+00, 1.5006525989E+01, 3.6172134533E+00, 9.5416266548E-01],
	[3.2715000000E+04, 3.2397468067E+01, 5.5883709037E+00, 1.5014064980E+01, 3.6177637283E+00, 9.5418669070E-01],
	[3.2720000000E+04, 3.2405879557E+01, 5.5883888273E+00, 1.5021606605E+01, 3.6183138394E+00, 9.5421070249E-01],
	[3.2725000000E+04, 3.2414291945E+01, 5.5884067482E+00, 1.5029150864E+01, 3.6188637866E+00, 9.5423470086E-01],
	[3.2730000000E+04, 3.2422705232E+01, 5.5884246664E+00, 1.5036697759E+01, 3.6194135700E+00, 9.5425868581E-01],
	[3.2735000000E+04, 3.2431119416E+01, 5.5884425819E+00, 1.5044247289E+01, 3.6199631896E+00, 9.5428265737E-01],
	[3.2740000000E+04, 3.2439534498E+01, 5.5884604948E+00, 1.5051799455E+01, 3.6205126454E+00, 9.5430661552E-01],
	[3.2745000000E+04, 3.2447950478E+01, 5.5884784050E+00, 1.5059354258E+01, 3.6210619375E+00, 9.5433056028E-01],
	[3.2750000000E+04, 3.2456367356E+01, 5.5884963125E+00, 1.5066911698E+01, 3.6216110659E+00, 9.5435449166E-01],
	[3.2755000000E+04, 3.2464785133E+01, 5.5885142173E+00, 1.5074471776E+01, 3.6221600306E+00, 9.5437840966E-01],
	[3.2760000000E+04, 3.2473203806E+01, 5.5885321194E+00, 1.5082034492E+01, 3.6227088317E+00, 9.5440231429E-01],
	[3.2765000000E+04, 3.2481623378E+01, 5.5885500189E+00, 1.5089599846E+01, 3.6232574692E+00, 9.5442620556E-01],
	[3.2770000000E+04, 3.2490043848E+01, 5.5885679157E+00, 1.5097167840E+01, 3.6238059431E+00, 9.5445008348E-01],
	[3.2775000000E+04, 3.2498465215E+01, 5.5885858098E+00, 1.5104738473E+01, 3.6243542534E+00, 9.5447394805E-01],
	[3.2780000000E+04, 3.2506887480E+01, 5.5886037013E+00, 1.5112311746E+01, 3.6249024002E+00, 9.5449779928E-01],
	[3.2785000000E+04, 3.2515310642E+01, 5.5886215901E+00, 1.5119887661E+01, 3.6254503835E+00, 9.5452163717E-01],
	[3.2790000000E+04, 3.2523734702E+01, 5.5886394762E+00, 1.5127466216E+01, 3.6259982034E+00, 9.5454546175E-01],
	[3.2795000000E+04, 3.2532159660E+01, 5.5886573596E+00, 1.5135047414E+01, 3.6265458598E+00, 9.5456927300E-01],
	[3.2800000000E+04, 3.2540585515E+01, 5.5886752404E+00, 1.5142631253E+01, 3.6270933529E+00, 9.5459307095E-01],
	[3.2805000000E+04, 3.2549012268E+01, 5.5886931185E+00, 1.5150217736E+01, 3.6276406826E+00, 9.5461685559E-01],
	[3.2810000000E+04, 3.2557439918E+01, 5.5887109940E+00, 1.5157806861E+01, 3.6281878489E+00, 9.5464062694E-01],
	[3.2815000000E+04, 3.2565868465E+01, 5.5887288667E+00, 1.5165398631E+01, 3.6287348520E+00, 9.5466438499E-01],
	[3.2820000000E+04, 3.2574297910E+01, 5.5887467368E+00, 1.5172993045E+01, 3.6292816918E+00, 9.5468812977E-01],
	[3.2825000000E+04, 3.2582728252E+01, 5.5887646043E+00, 1.5180590104E+01, 3.6298283683E+00, 9.5471186127E-01],
	[3.2830000000E+04, 3.2591159491E+01, 5.5887824690E+00, 1.5188189808E+01, 3.6303748816E+00, 9.5473557951E-01],
	[3.2835000000E+04, 3.2599591628E+01, 5.5888003312E+00, 1.5195792158E+01, 3.6309212318E+00, 9.5475928449E-01],
	[3.2840000000E+04, 3.2608024662E+01, 5.5888181906E+00, 1.5203397155E+01, 3.6314674188E+00, 9.5478297622E-01],
	[3.2845000000E+04, 3.2616458593E+01, 5.5888360474E+00, 1.5211004799E+01, 3.6320134427E+00, 9.5480665470E-01],
	[3.2850000000E+04, 3.2624893421E+01, 5.5888539015E+00, 1.5218615090E+01, 3.6325593035E+00, 9.5483031995E-01],
	[3.2855000000E+04, 3.2633329146E+01, 5.5888717530E+00, 1.5226228029E+01, 3.6331050012E+00, 9.5485397197E-01],
	[3.2860000000E+04, 3.2641765768E+01, 5.5888896018E+00, 1.5233843616E+01, 3.6336505360E+00, 9.5487761076E-01],
	[3.2865000000E+04, 3.2650203287E+01, 5.5889074479E+00, 1.5241461853E+01, 3.6341959077E+00, 9.5490123634E-01],
	[3.2870000000E+04, 3.2658641703E+01, 5.5889252914E+00, 1.5249082739E+01, 3.6347411165E+00, 9.5492484871E-01],
	[3.2875000000E+04, 3.2667081016E+01, 5.5889431323E+00, 1.5256706275E+01, 3.6352861624E+00, 9.5494844789E-01],
	[3.2880000000E+04, 3.2675521226E+01, 5.5889609704E+00, 1.5264332462E+01, 3.6358310453E+00, 9.5497203387E-01],
	[3.2885000000E+04, 3.2683962333E+01, 5.5889788060E+00, 1.5271961300E+01, 3.6363757654E+00, 9.5499560666E-01],
	[3.2890000000E+04, 3.2692404336E+01, 5.5889966388E+00, 1.5279592789E+01, 3.6369203227E+00, 9.5501916628E-01],
	[3.2895000000E+04, 3.2700847236E+01, 5.5890144690E+00, 1.5287226931E+01, 3.6374647172E+00, 9.5504271273E-01],
	[3.2900000000E+04, 3.2709291033E+01, 5.5890322966E+00, 1.5294863725E+01, 3.6380089489E+00, 9.5506624601E-01],
	[3.2905000000E+04, 3.2717735726E+01, 5.5890501215E+00, 1.5302503173E+01, 3.6385530178E+00, 9.5508976614E-01],
	[3.2910000000E+04, 3.2726181316E+01, 5.5890679438E+00, 1.5310145274E+01, 3.6390969241E+00, 9.5511327311E-01],
	[3.2915000000E+04, 3.2734627803E+01, 5.5890857634E+00, 1.5317790029E+01, 3.6396406677E+00, 9.5513676695E-01],
	[3.2920000000E+04, 3.2743098275E+01, 5.5891062440E+00, 1.5325437439E+01, 3.6401856639E+00, 9.5516024765E-01],
	[3.2925000000E+04, 3.2751571302E+01, 5.5891269118E+00, 1.5333087504E+01, 3.6407305990E+00, 9.5518371523E-01],
	[3.2930000000E+04, 3.2760045235E+01, 5.5891475765E+00, 1.5340740226E+01, 3.6412753721E+00, 9.5520716969E-01],
	[3.2935000000E+04, 3.2768520073E+01, 5.5891682382E+00, 1.5348395603E+01, 3.6418199832E+00, 9.5523061103E-01],
	[3.2940000000E+04, 3.2776995816E+01, 5.5891888968E+00, 1.5356053637E+01, 3.6423644323E+00, 9.5525403927E-01],
	[3.2945000000E+04, 3.2785472464E+01, 5.5892095524E+00, 1.5363714328E+01, 3.6429087194E+00, 9.5527745442E-01],
	[3.2950000000E+04, 3.2793950018E+01, 5.5892302049E+00, 1.5371377678E+01, 3.6434528445E+00, 9.5530085647E-01],
	[3.2955000000E+04, 3.2802428478E+01, 5.5892508544E+00, 1.5379043685E+01, 3.6439968077E+00, 9.5532424544E-01],
	[3.2960000000E+04, 3.2810907842E+01, 5.5892715008E+00, 1.5386712352E+01, 3.6445406091E+00, 9.5534762133E-01],
	[3.2965000000E+04, 3.2819388112E+01, 5.5892921441E+00, 1.5394383678E+01, 3.6450842486E+00, 9.5537098416E-01],
	[3.2970000000E+04, 3.2827869286E+01, 5.5893127844E+00, 1.5402057664E+01, 3.6456277262E+00, 9.5539433393E-01],
	[3.2975000000E+04, 3.2836351366E+01, 5.5893334217E+00, 1.5409734310E+01, 3.6461710421E+00, 9.5541767064E-01],
	[3.2980000000E+04, 3.2844834351E+01, 5.5893540558E+00, 1.5417413617E+01, 3.6467141963E+00, 9.5544099431E-01],
	[3.2985000000E+04, 3.2853318241E+01, 5.5893746870E+00, 1.5425095586E+01, 3.6472571887E+00, 9.5546430493E-01],
	[3.2990000000E+04, 3.2861803036E+01, 5.5893953151E+00, 1.5432780217E+01, 3.6478000194E+00, 9.5548760253E-01],
	[3.2995000000E+04, 3.2870288736E+01, 5.5894159401E+00, 1.5440467510E+01, 3.6483426884E+00, 9.5551088710E-01],
	[3.3000000000E+04, 3.2878775341E+01, 5.5894365621E+00, 1.5448157466E+01, 3.6488851958E+00, 9.5553415866E-01],
	[3.3005000000E+04, 3.2887262850E+01, 5.5894571810E+00, 1.5455850086E+01, 3.6494275417E+00, 9.5555741721E-01],
	[3.3010000000E+04, 3.2895751265E+01, 5.5894777969E+00, 1.5463545369E+01, 3.6499697259E+00, 9.5558066275E-01],
	[3.3015000000E+04, 3.2904240584E+01, 5.5894984097E+00, 1.5471243318E+01, 3.6505117486E+00, 9.5560389530E-01],
	[3.3020000000E+04, 3.2912730808E+01, 5.5895190195E+00, 1.5478943931E+01, 3.6510536098E+00, 9.5562711486E-01],
	[3.3025000000E+04, 3.2921221937E+01, 5.5895396263E+00, 1.5486647210E+01, 3.6515953096E+00, 9.5565032145E-01],
	[3.3030000000E+04, 3.2929713970E+01, 5.5895602300E+00, 1.5494353155E+01, 3.6521368479E+00, 9.5567351506E-01],
	[3.3035000000E+04, 3.2938206908E+01, 5.5895808306E+00, 1.5502061767E+01, 3.6526782248E+00, 9.5569669570E-01],
	[3.3040000000E+04, 3.2946700750E+01, 5.5896014283E+00, 1.5509773046E+01, 3.6532194403E+00, 9.5571986339E-01],
	[3.3045000000E+04, 3.2955195497E+01, 5.5896220228E+00, 1.5517486993E+01, 3.6537604944E+00, 9.5574301812E-01],
	[3.3050000000E+04, 3.2963691149E+01, 5.5896426144E+00, 1.5525203608E+01, 3.6543013873E+00, 9.5576615991E-01],
	[3.3055000000E+04, 3.2972187705E+01, 5.5896632029E+00, 1.5532922892E+01, 3.6548421189E+00, 9.5578928877E-01],
	[3.3060000000E+04, 3.2980685165E+01, 5.5896837883E+00, 1.5540644844E+01, 3.6553826892E+00, 9.5581240469E-01],
	[3.3065000000E+04, 3.2989183530E+01, 5.5897043708E+00, 1.5548369467E+01, 3.6559230983E+00, 9.5583550770E-01],
	[3.3070000000E+04, 3.2997682799E+01, 5.5897249502E+00, 1.5556096760E+01, 3.6564633462E+00, 9.5585859779E-01],
	[3.3075000000E+04, 3.3006182973E+01, 5.5897455265E+00, 1.5563826724E+01, 3.6570034330E+00, 9.5588167497E-01],
	[3.3080000000E+04, 3.3014684051E+01, 5.5897660998E+00, 1.5571559359E+01, 3.6575433586E+00, 9.5590473926E-01],
	[3.3085000000E+04, 3.3023186032E+01, 5.5897866701E+00, 1.5579294666E+01, 3.6580831232E+00, 9.5592779065E-01],
	[3.3090000000E+04, 3.3031688918E+01, 5.5898072374E+00, 1.5587032645E+01, 3.6586227267E+00, 9.5595082916E-01],
	[3.3095000000E+04, 3.3040192709E+01, 5.5898278016E+00, 1.5594773297E+01, 3.6591621692E+00, 9.5597385479E-01],
	[3.3100000000E+04, 3.3048697403E+01, 5.5898483628E+00, 1.5602516623E+01, 3.6597014506E+00, 9.5599686755E-01],
	[3.3105000000E+04, 3.3057203001E+01, 5.5898689209E+00, 1.5610262622E+01, 3.6602405711E+00, 9.5601986744E-01],
	[3.3110000000E+04, 3.3065709504E+01, 5.5898894761E+00, 1.5618011296E+01, 3.6607795307E+00, 9.5604285448E-01],
	[3.3115000000E+04, 3.3074216910E+01, 5.5899100282E+00, 1.5625762645E+01, 3.6613183294E+00, 9.5606582867E-01],
	[3.3120000000E+04, 3.3082725220E+01, 5.5899305772E+00, 1.5633516669E+01, 3.6618569672E+00, 9.5608879002E-01],
	[3.3125000000E+04, 3.3091234434E+01, 5.5899511233E+00, 1.5641273369E+01, 3.6623954442E+00, 9.5611173854E-01],
	[3.3130000000E+04, 3.3099744552E+01, 5.5899716663E+00, 1.5649032746E+01, 3.6629337604E+00, 9.5613467423E-01],
	[3.3135000000E+04, 3.3108255574E+01, 5.5899922063E+00, 1.5656794800E+01, 3.6634719158E+00, 9.5615759710E-01],
	[3.3140000000E+04, 3.3116767500E+01, 5.5900127433E+00, 1.5664559531E+01, 3.6640099105E+00, 9.5618050716E-01],
	[3.3145000000E+04, 3.3125280329E+01, 5.5900332772E+00, 1.5672326941E+01, 3.6645477445E+00, 9.5620340442E-01],
	[3.3150000000E+04, 3.3133794062E+01, 5.5900538082E+00, 1.5680097029E+01, 3.6650854178E+00, 9.5622628887E-01],
	[3.3155000000E+04, 3.3142308699E+01, 5.5900743361E+00, 1.5687869796E+01, 3.6656229304E+00, 9.5624916054E-01],
	[3.3160000000E+04, 3.3150824239E+01, 5.5900948610E+00, 1.5695645243E+01, 3.6661602825E+00, 9.5627201942E-01],
	[3.3165000000E+04, 3.3159340683E+01, 5.5901153828E+00, 1.5703423370E+01, 3.6666974740E+00, 9.5629486553E-01],
	[3.3170000000E+04, 3.3167858030E+01, 5.5901359017E+00, 1.5711204177E+01, 3.6672345049E+00, 9.5631769887E-01],
	[3.3175000000E+04, 3.3176376281E+01, 5.5901564175E+00, 1.5718987666E+01, 3.6677713753E+00, 9.5634051945E-01],
	[3.3180000000E+04, 3.3184895435E+01, 5.5901769303E+00, 1.5726773836E+01, 3.6683080852E+00, 9.5636332728E-01],
	[3.3185000000E+04, 3.3193415493E+01, 5.5901974401E+00, 1.5734562689E+01, 3.6688446347E+00, 9.5638612236E-01],
	[3.3190000000E+04, 3.3201936454E+01, 5.5902179469E+00, 1.5742354225E+01, 3.6693810238E+00, 9.5640890470E-01],
	[3.3195000000E+04, 3.3210458318E+01, 5.5902384507E+00, 1.5750148443E+01, 3.6699172525E+00, 9.5643167431E-01],
	[3.3200000000E+04, 3.3218981086E+01, 5.5902589514E+00, 1.5757945346E+01, 3.6704533209E+00, 9.5645443119E-01],
	[3.3205000000E+04, 3.3227504757E+01, 5.5902794492E+00, 1.5765744933E+01, 3.6709892289E+00, 9.5647717536E-01],
	[3.3210000000E+04, 3.3236029331E+01, 5.5902999439E+00, 1.5773547204E+01, 3.6715249766E+00, 9.5649990681E-01],
	[3.3215000000E+04, 3.3244554808E+01, 5.5903204356E+00, 1.5781352161E+01, 3.6720605641E+00, 9.5652262557E-01],
	[3.3220000000E+04, 3.3253081188E+01, 5.5903409244E+00, 1.5789159804E+01, 3.6725959914E+00, 9.5654533163E-01],
	[3.3225000000E+04, 3.3261608472E+01, 5.5903614101E+00, 1.5796970133E+01, 3.6731312585E+00, 9.5656802500E-01],
	[3.3230000000E+04, 3.3270136658E+01, 5.5903818928E+00, 1.5804783149E+01, 3.6736663654E+00, 9.5659070569E-01],
	[3.3235000000E+04, 3.3278665748E+01, 5.5904023725E+00, 1.5812598853E+01, 3.6742013123E+00, 9.5661337371E-01],
	[3.3240000000E+04, 3.3287195740E+01, 5.5904228492E+00, 1.5820417244E+01, 3.6747360990E+00, 9.5663602906E-01],
	[3.3245000000E+04, 3.3295726635E+01, 5.5904433228E+00, 1.5828238324E+01, 3.6752707256E+00, 9.5665867175E-01],
	[3.3250000000E+04, 3.3304258434E+01, 5.5904637935E+00, 1.5836062093E+01, 3.6758051923E+00, 9.5668130179E-01],
	[3.3255000000E+04, 3.3312791135E+01, 5.5904842612E+00, 1.5843888551E+01, 3.6763394989E+00, 9.5670391919E-01],
	[3.3260000000E+04, 3.3321324739E+01, 5.5905047259E+00, 1.5851717700E+01, 3.6768736456E+00, 9.5672652395E-01],
	[3.3265000000E+04, 3.3329859245E+01, 5.5905251875E+00, 1.5859549539E+01, 3.6774076324E+00, 9.5674911607E-01],
	[3.3270000000E+04, 3.3338394655E+01, 5.5905456462E+00, 1.5867384069E+01, 3.6779414593E+00, 9.5677169558E-01],
	[3.3275000000E+04, 3.3346930967E+01, 5.5905661019E+00, 1.5875221290E+01, 3.6784751263E+00, 9.5679426247E-01],
	[3.3280000000E+04, 3.3355468181E+01, 5.5905865546E+00, 1.5883061204E+01, 3.6790086335E+00, 9.5681681675E-01],
	[3.3285000000E+04, 3.3364006299E+01, 5.5906070042E+00, 1.5890903810E+01, 3.6795419809E+00, 9.5683935844E-01],
	[3.3290000000E+04, 3.3372545318E+01, 5.5906274509E+00, 1.5898749110E+01, 3.6800751685E+00, 9.5686188753E-01],
	[3.3295000000E+04, 3.3381085241E+01, 5.5906478946E+00, 1.5906597103E+01, 3.6806081964E+00, 9.5688440403E-01],
	[3.3300000000E+04, 3.3389626066E+01, 5.5906683353E+00, 1.5914447790E+01, 3.6811410646E+00, 9.5690690795E-01],
	[3.3305000000E+04, 3.3398167793E+01, 5.5906887730E+00, 1.5922301172E+01, 3.6816737731E+00, 9.5692939930E-01],
	[3.3310000000E+04, 3.3406710422E+01, 5.5907092077E+00, 1.5930157249E+01, 3.6822063220E+00, 9.5695187809E-01],
	[3.3315000000E+04, 3.3415253955E+01, 5.5907296394E+00, 1.5938016022E+01, 3.6827387113E+00, 9.5697434432E-01],
	[3.3320000000E+04, 3.3423798389E+01, 5.5907500681E+00, 1.5945877491E+01, 3.6832709411E+00, 9.5699679800E-01],
	[3.3325000000E+04, 3.3432343725E+01, 5.5907704938E+00, 1.5953741657E+01, 3.6838030113E+00, 9.5701923914E-01],
	[3.3330000000E+04, 3.3440889964E+01, 5.5907909166E+00, 1.5961608520E+01, 3.6843349220E+00, 9.5704166774E-01],
	[3.3335000000E+04, 3.3449437105E+01, 5.5908113363E+00, 1.5969478081E+01, 3.6848666733E+00, 9.5706408381E-01],
	[3.3340000000E+04, 3.3457985149E+01, 5.5908317531E+00, 1.5977350341E+01, 3.6853982651E+00, 9.5708648737E-01],
	[3.3345000000E+04, 3.3466534094E+01, 5.5908521668E+00, 1.5985225299E+01, 3.6859296975E+00, 9.5710887840E-01],
	[3.3350000000E+04, 3.3475083941E+01, 5.5908725776E+00, 1.5993102957E+01, 3.6864609705E+00, 9.5713125694E-01],
	[3.3355000000E+04, 3.3483634691E+01, 5.5908929854E+00, 1.6000983314E+01, 3.6869920842E+00, 9.5715362297E-01],
	[3.3360000000E+04, 3.3492186342E+01, 5.5909133902E+00, 1.6008866372E+01, 3.6875230386E+00, 9.5717597651E-01],
	[3.3365000000E+04, 3.3500738896E+01, 5.5909337921E+00, 1.6016752131E+01, 3.6880538338E+00, 9.5719831757E-01],
	[3.3370000000E+04, 3.3509292351E+01, 5.5909541909E+00, 1.6024640591E+01, 3.6885844697E+00, 9.5722064615E-01],
	[3.3375000000E+04, 3.3517846708E+01, 5.5909745868E+00, 1.6032531754E+01, 3.6891149464E+00, 9.5724296226E-01],
	[3.3380000000E+04, 3.3526401967E+01, 5.5909949797E+00, 1.6040425618E+01, 3.6896452639E+00, 9.5726526590E-01],
	[3.3385000000E+04, 3.3534958128E+01, 5.5910153696E+00, 1.6048322186E+01, 3.6901754223E+00, 9.5728755709E-01],
	[3.3390000000E+04, 3.3543515191E+01, 5.5910357565E+00, 1.6056221457E+01, 3.6907054216E+00, 9.5730983583E-01],
	[3.3395000000E+04, 3.3552073155E+01, 5.5910561404E+00, 1.6064123433E+01, 3.6912352619E+00, 9.5733210213E-01],
	[3.3400000000E+04, 3.3560632021E+01, 5.5910765214E+00, 1.6072028113E+01, 3.6917649431E+00, 9.5735435600E-01],
	[3.3405000000E+04, 3.3569191788E+01, 5.5910968994E+00, 1.6079935498E+01, 3.6922944653E+00, 9.5737659744E-01],
	[3.3410000000E+04, 3.3577752458E+01, 5.5911172744E+00, 1.6087845589E+01, 3.6928238285E+00, 9.5739882646E-01],
	[3.3415000000E+04, 3.3586314028E+01, 5.5911376465E+00, 1.6095758385E+01, 3.6933530328E+00, 9.5742104307E-01],
	[3.3420000000E+04, 3.3594876501E+01, 5.5911580155E+00, 1.6103673889E+01, 3.6938820781E+00, 9.5744324727E-01],
	[3.3425000000E+04, 3.3603439874E+01, 5.5911783816E+00, 1.6111592100E+01, 3.6944109647E+00, 9.5746543907E-01],
	[3.3430000000E+04, 3.3612004150E+01, 5.5911987448E+00, 1.6119513018E+01, 3.6949396923E+00, 9.5748761849E-01],
	[3.3435000000E+04, 3.3620569326E+01, 5.5912191049E+00, 1.6127436645E+01, 3.6954682612E+00, 9.5750978552E-01],
	[3.3440000000E+04, 3.3629135404E+01, 5.5912394621E+00, 1.6135362980E+01, 3.6959966713E+00, 9.5753194017E-01],
	[3.3445000000E+04, 3.3637702383E+01, 5.5912598163E+00, 1.6143292025E+01, 3.6965249227E+00, 9.5755408245E-01],
	[3.3450000000E+04, 3.3646293618E+01, 5.5912828351E+00, 1.6151223779E+01, 3.6970544636E+00, 9.5757621238E-01],
	[3.3455000000E+04, 3.3654886866E+01, 5.5913059766E+00, 1.6159158244E+01, 3.6975839147E+00, 9.5759832994E-01],
	[3.3460000000E+04, 3.3663481023E+01, 5.5913291146E+00, 1.6167095419E+01, 3.6981132076E+00, 9.5762043516E-01],
	[3.3465000000E+04, 3.3672076090E+01, 5.5913522493E+00, 1.6175035306E+01, 3.6986423425E+00, 9.5764252804E-01],
	[3.3470000000E+04, 3.3680672067E+01, 5.5913753806E+00, 1.6182977905E+01, 3.6991713192E+00, 9.5766460859E-01],
	[3.3475000000E+04, 3.3689268954E+01, 5.5913985086E+00, 1.6190923216E+01, 3.6997001379E+00, 9.5768667681E-01],
	[3.3480000000E+04, 3.3697866751E+01, 5.5914216332E+00, 1.6198871240E+01, 3.7002287985E+00, 9.5770873272E-01],
	[3.3485000000E+04, 3.3706465458E+01, 5.5914447544E+00, 1.6206821978E+01, 3.7007573012E+00, 9.5773077631E-01],
	[3.3490000000E+04, 3.3715065074E+01, 5.5914678723E+00, 1.6214775429E+01, 3.7012856459E+00, 9.5775280760E-01],
	[3.3495000000E+04, 3.3723665601E+01, 5.5914909869E+00, 1.6222731595E+01, 3.7018138327E+00, 9.5777482659E-01],
	[3.3500000000E+04, 3.3732267037E+01, 5.5915140980E+00, 1.6230690476E+01, 3.7023418616E+00, 9.5779683329E-01],
	[3.3505000000E+04, 3.3740869382E+01, 5.5915372059E+00, 1.6238652072E+01, 3.7028697326E+00, 9.5781882770E-01],
	[3.3510000000E+04, 3.3749472637E+01, 5.5915603103E+00, 1.6246616385E+01, 3.7033974458E+00, 9.5784080985E-01],
	[3.3515000000E+04, 3.3758076802E+01, 5.5915834115E+00, 1.6254583413E+01, 3.7039250012E+00, 9.5786277972E-01],
	[3.3520000000E+04, 3.3766681877E+01, 5.5916065092E+00, 1.6262553160E+01, 3.7044523989E+00, 9.5788473734E-01],
	[3.3525000000E+04, 3.3775287860E+01, 5.5916296037E+00, 1.6270525623E+01, 3.7049796388E+00, 9.5790668269E-01],
	[3.3530000000E+04, 3.3783894754E+01, 5.5916526947E+00, 1.6278500805E+01, 3.7055067211E+00, 9.5792861581E-01],
	[3.3535000000E+04, 3.3792502556E+01, 5.5916757825E+00, 1.6286478705E+01, 3.7060336457E+00, 9.5795053668E-01],
	[3.3540000000E+04, 3.3801111269E+01, 5.5916988668E+00, 1.6294459325E+01, 3.7065604126E+00, 9.5797244532E-01],
	[3.3545000000E+04, 3.3809720890E+01, 5.5917219479E+00, 1.6302442664E+01, 3.7070870220E+00, 9.5799434174E-01],
	[3.3550000000E+04, 3.3818331421E+01, 5.5917450256E+00, 1.6310428724E+01, 3.7076134738E+00, 9.5801622594E-01],
	[3.3555000000E+04, 3.3826942861E+01, 5.5917680999E+00, 1.6318417504E+01, 3.7081397681E+00, 9.5803809792E-01],
	[3.3560000000E+04, 3.3835555210E+01, 5.5917911709E+00, 1.6326409005E+01, 3.7086659049E+00, 9.5805995771E-01],
	[3.3565000000E+04, 3.3844168469E+01, 5.5918142386E+00, 1.6334403228E+01, 3.7091918843E+00, 9.5808180530E-01],
	[3.3570000000E+04, 3.3852782636E+01, 5.5918373029E+00, 1.6342400174E+01, 3.7097177062E+00, 9.5810364069E-01],
	[3.3575000000E+04, 3.3861397713E+01, 5.5918603639E+00, 1.6350399842E+01, 3.7102433708E+00, 9.5812546391E-01],
	[3.3580000000E+04, 3.3870013699E+01, 5.5918834215E+00, 1.6358402234E+01, 3.7107688779E+00, 9.5814727495E-01],
	[3.3585000000E+04, 3.3878630593E+01, 5.5919064758E+00, 1.6366407349E+01, 3.7112942278E+00, 9.5816907383E-01],
	[3.3590000000E+04, 3.3887248397E+01, 5.5919295268E+00, 1.6374415189E+01, 3.7118194204E+00, 9.5819086054E-01],
	[3.3595000000E+04, 3.3895867110E+01, 5.5919525744E+00, 1.6382425753E+01, 3.7123444557E+00, 9.5821263510E-01],
	[3.3600000000E+04, 3.3904486731E+01, 5.5919756187E+00, 1.6390439043E+01, 3.7128693338E+00, 9.5823439751E-01],
	[3.3605000000E+04, 3.3913107262E+01, 5.5919986597E+00, 1.6398455060E+01, 3.7133940547E+00, 9.5825614779E-01],
	[3.3610000000E+04, 3.3921728701E+01, 5.5920216973E+00, 1.6406473802E+01, 3.7139186184E+00, 9.5827788593E-01],
	[3.3615000000E+04, 3.3930351049E+01, 5.5920447316E+00, 1.6414495271E+01, 3.7144430251E+00, 9.5829961196E-01],
	[3.3620000000E+04, 3.3938974306E+01, 5.5920677625E+00, 1.6422519468E+01, 3.7149672746E+00, 9.5832132591E-01],
	[3.3625000000E+04, 3.3947598472E+01, 5.5920907902E+00, 1.6430546393E+01, 3.7154913671E+00, 9.5834302776E-01],
	[3.3630000000E+04, 3.3956223546E+01, 5.5921138145E+00, 1.6438576047E+01, 3.7160153026E+00, 9.5836471754E-01],
	[3.3635000000E+04, 3.3964849529E+01, 5.5921368355E+00, 1.6446608429E+01, 3.7165390811E+00, 9.5838639525E-01],
	[3.3640000000E+04, 3.3973476420E+01, 5.5921598531E+00, 1.6454643542E+01, 3.7170627026E+00, 9.5840806090E-01],
	[3.3645000000E+04, 3.3982104221E+01, 5.5921828674E+00, 1.6462681384E+01, 3.7175861672E+00, 9.5842971448E-01],
	[3.3650000000E+04, 3.3990732929E+01, 5.5922058784E+00, 1.6470721957E+01, 3.7181094749E+00, 9.5845135601E-01],
	[3.3655000000E+04, 3.3999362546E+01, 5.5922288861E+00, 1.6478765261E+01, 3.7186326258E+00, 9.5847298550E-01],
	[3.3660000000E+04, 3.4007993072E+01, 5.5922518905E+00, 1.6486811296E+01, 3.7191556199E+00, 9.5849460295E-01],
	[3.3665000000E+04, 3.4016624505E+01, 5.5922748915E+00, 1.6494860064E+01, 3.7196784572E+00, 9.5851620836E-01],
	[3.3670000000E+04, 3.4025256848E+01, 5.5922978892E+00, 1.6502911565E+01, 3.7202011377E+00, 9.5853780174E-01],
	[3.3675000000E+04, 3.4033890098E+01, 5.5923208836E+00, 1.6510965799E+01, 3.7207236615E+00, 9.5855938311E-01],
	[3.3680000000E+04, 3.4042524257E+01, 5.5923438746E+00, 1.6519022766E+01, 3.7212460286E+00, 9.5858095245E-01],
	[3.3685000000E+04, 3.4051159324E+01, 5.5923668624E+00, 1.6527082468E+01, 3.7217682391E+00, 9.5860250979E-01],
	[3.3690000000E+04, 3.4059795299E+01, 5.5923898468E+00, 1.6535144905E+01, 3.7222902930E+00, 9.5862405513E-01],
	[3.3695000000E+04, 3.4068432183E+01, 5.5924128279E+00, 1.6543210077E+01, 3.7228121903E+00, 9.5864558847E-01],
	[3.3700000000E+04, 3.4077069974E+01, 5.5924358057E+00, 1.6551277985E+01, 3.7233339310E+00, 9.5866710982E-01],
	[3.3705000000E+04, 3.4085708674E+01, 5.5924587802E+00, 1.6559348629E+01, 3.7238555153E+00, 9.5868861919E-01],
	[3.3710000000E+04, 3.4094348281E+01, 5.5924817514E+00, 1.6567422010E+01, 3.7243769430E+00, 9.5871011657E-01],
	[3.3715000000E+04, 3.4102988797E+01, 5.5925047193E+00, 1.6575498128E+01, 3.7248982143E+00, 9.5873160199E-01],
	[3.3720000000E+04, 3.4111630221E+01, 5.5925276838E+00, 1.6583576985E+01, 3.7254193292E+00, 9.5875307544E-01],
	[3.3725000000E+04, 3.4120272552E+01, 5.5925506450E+00, 1.6591658579E+01, 3.7259402877E+00, 9.5877453694E-01],
	[3.3730000000E+04, 3.4128915792E+01, 5.5925736030E+00, 1.6599742913E+01, 3.7264610899E+00, 9.5879598648E-01],
	[3.3735000000E+04, 3.4137559939E+01, 5.5925965576E+00, 1.6607829987E+01, 3.7269817358E+00, 9.5881742407E-01],
	[3.3740000000E+04, 3.4146204994E+01, 5.5926195089E+00, 1.6615919800E+01, 3.7275022254E+00, 9.5883884973E-01],
	[3.3745000000E+04, 3.4154850957E+01, 5.5926424569E+00, 1.6624012354E+01, 3.7280225587E+00, 9.5886026345E-01],
	[3.3750000000E+04, 3.4163497828E+01, 5.5926654016E+00, 1.6632107649E+01, 3.7285427359E+00, 9.5888166524E-01],
	[3.3755000000E+04, 3.4172145606E+01, 5.5926883430E+00, 1.6640205685E+01, 3.7290627569E+00, 9.5890305512E-01],
	[3.3760000000E+04, 3.4180794292E+01, 5.5927112811E+00, 1.6648306464E+01, 3.7295826217E+00, 9.5892443307E-01],
	[3.3765000000E+04, 3.4189443885E+01, 5.5927342159E+00, 1.6656409985E+01, 3.7301023304E+00, 9.5894579912E-01],
	[3.3770000000E+04, 3.4198094387E+01, 5.5927571474E+00, 1.6664516249E+01, 3.7306218831E+00, 9.5896715327E-01],
	[3.3775000000E+04, 3.4206745795E+01, 5.5927800755E+00, 1.6672625257E+01, 3.7311412797E+00, 9.5898849552E-01],
	[3.3780000000E+04, 3.4215398111E+01, 5.5928030004E+00, 1.6680737010E+01, 3.7316605204E+00, 9.5900982588E-01],
	[3.3785000000E+04, 3.4224051335E+01, 5.5928259220E+00, 1.6688851507E+01, 3.7321796050E+00, 9.5903114436E-01],
	[3.3790000000E+04, 3.4232705466E+01, 5.5928488403E+00, 1.6696968749E+01, 3.7326985337E+00, 9.5905245095E-01],
	[3.3795000000E+04, 3.4241360504E+01, 5.5928717553E+00, 1.6705088737E+01, 3.7332173066E+00, 9.5907374568E-01],
	[3.3800000000E+04, 3.4250016450E+01, 5.5928946670E+00, 1.6713211471E+01, 3.7337359235E+00, 9.5909502855E-01],
	[3.3805000000E+04, 3.4258673303E+01, 5.5929175754E+00, 1.6721336952E+01, 3.7342543847E+00, 9.5911629955E-01],
	[3.3810000000E+04, 3.4267331063E+01, 5.5929404805E+00, 1.6729465180E+01, 3.7347726900E+00, 9.5913755870E-01],
	[3.3815000000E+04, 3.4275989731E+01, 5.5929633823E+00, 1.6737596156E+01, 3.7352908396E+00, 9.5915880601E-01],
	[3.3820000000E+04, 3.4284649306E+01, 5.5929862808E+00, 1.6745729881E+01, 3.7358088335E+00, 9.5918004148E-01],
	[3.3825000000E+04, 3.4293309787E+01, 5.5930091760E+00, 1.6753866354E+01, 3.7363266716E+00, 9.5920126511E-01],
	[3.3830000000E+04, 3.4301971176E+01, 5.5930320680E+00, 1.6762005577E+01, 3.7368443541E+00, 9.5922247692E-01],
	[3.3835000000E+04, 3.4310633472E+01, 5.5930549566E+00, 1.6770147550E+01, 3.7373618810E+00, 9.5924367690E-01],
	[3.3840000000E+04, 3.4319296675E+01, 5.5930778420E+00, 1.6778292273E+01, 3.7378792523E+00, 9.5926486507E-01],
	[3.3845000000E+04, 3.4327960785E+01, 5.5931007240E+00, 1.6786439748E+01, 3.7383964680E+00, 9.5928604144E-01],
	[3.3850000000E+04, 3.4336625802E+01, 5.5931236028E+00, 1.6794589973E+01, 3.7389135282E+00, 9.5930720600E-01],
	[3.3855000000E+04, 3.4345291726E+01, 5.5931464783E+00, 1.6802742951E+01, 3.7394304329E+00, 9.5932835876E-01],
	[3.3860000000E+04, 3.4353958557E+01, 5.5931693505E+00, 1.6810898681E+01, 3.7399471822E+00, 9.5934949974E-01],
	[3.3865000000E+04, 3.4362626295E+01, 5.5931922195E+00, 1.6819057165E+01, 3.7404637761E+00, 9.5937062893E-01],
	[3.3870000000E+04, 3.4371294939E+01, 5.5932150851E+00, 1.6827218402E+01, 3.7409802145E+00, 9.5939174635E-01],
	[3.3875000000E+04, 3.4379964490E+01, 5.5932379475E+00, 1.6835382393E+01, 3.7414964977E+00, 9.5941285199E-01],
	[3.3880000000E+04, 3.4388634948E+01, 5.5932608066E+00, 1.6843549138E+01, 3.7420126255E+00, 9.5943394587E-01],
	[3.3885000000E+04, 3.4397306312E+01, 5.5932836624E+00, 1.6851718639E+01, 3.7425285980E+00, 9.5945502799E-01],
	[3.3890000000E+04, 3.4405978583E+01, 5.5933065149E+00, 1.6859890896E+01, 3.7430444153E+00, 9.5947609836E-01],
	[3.3895000000E+04, 3.4414651761E+01, 5.5933293641E+00, 1.6868065909E+01, 3.7435600774E+00, 9.5949715699E-01],
	[3.3900000000E+04, 3.4423325845E+01, 5.5933522101E+00, 1.6876243678E+01, 3.7440755843E+00, 9.5951820387E-01],
	[3.3905000000E+04, 3.4432000836E+01, 5.5933750528E+00, 1.6884424205E+01, 3.7445909360E+00, 9.5953923902E-01],
	[3.3910000000E+04, 3.4440676734E+01, 5.5933978922E+00, 1.6892607489E+01, 3.7451061327E+00, 9.5956026245E-01],
	[3.3915000000E+04, 3.4449353537E+01, 5.5934207284E+00, 1.6900793532E+01, 3.7456211743E+00, 9.5958127415E-01],
	[3.3920000000E+04, 3.4458031247E+01, 5.5934435612E+00, 1.6908982334E+01, 3.7461360608E+00, 9.5960227415E-01],
	[3.3925000000E+04, 3.4466709864E+01, 5.5934663908E+00, 1.6917173895E+01, 3.7466507923E+00, 9.5962326243E-01],
	[3.3930000000E+04, 3.4475389387E+01, 5.5934892172E+00, 1.6925368215E+01, 3.7471653689E+00, 9.5964423901E-01],
	[3.3935000000E+04, 3.4484069816E+01, 5.5935120402E+00, 1.6933565296E+01, 3.7476797905E+00, 9.5966520390E-01],
	[3.3940000000E+04, 3.4492751151E+01, 5.5935348600E+00, 1.6941765139E+01, 3.7481940573E+00, 9.5968615709E-01],
	[3.3945000000E+04, 3.4501433393E+01, 5.5935576765E+00, 1.6949967742E+01, 3.7487081691E+00, 9.5970709861E-01],
	[3.3950000000E+04, 3.4510116540E+01, 5.5935804898E+00, 1.6958173108E+01, 3.7492221262E+00, 9.5972802845E-01],
	[3.3955000000E+04, 3.4518800594E+01, 5.5936032998E+00, 1.6966381236E+01, 3.7497359284E+00, 9.5974894661E-01],
	[3.3960000000E+04, 3.4527485554E+01, 5.5936261065E+00, 1.6974592126E+01, 3.7502495759E+00, 9.5976985312E-01],
	[3.3965000000E+04, 3.4536171420E+01, 5.5936489100E+00, 1.6982805781E+01, 3.7507630687E+00, 9.5979074796E-01],
	[3.3970000000E+04, 3.4544858192E+01, 5.5936717102E+00, 1.6991022199E+01, 3.7512764067E+00, 9.5981163116E-01],
	[3.3975000000E+04, 3.4553545870E+01, 5.5936945071E+00, 1.6999241383E+01, 3.7517895902E+00, 9.5983250271E-01],
	[3.3980000000E+04, 3.4562234454E+01, 5.5937173007E+00, 1.7007463331E+01, 3.7523026190E+00, 9.5985336262E-01],
	[3.3985000000E+04, 3.4570930478E+01, 5.5937408306E+00, 1.7015688044E+01, 3.7528159030E+00, 9.5987421090E-01],
	[3.3990000000E+04, 3.4579645043E+01, 5.5937663521E+00, 1.7023915524E+01, 3.7533301385E+00, 9.5989504755E-01],
	[3.3995000000E+04, 3.4588360523E+01, 5.5937918699E+00, 1.7032145771E+01, 3.7538442200E+00, 9.5991587258E-01],
	[3.4000000000E+04, 3.4597076917E+01, 5.5938173842E+00, 1.7040378785E+01, 3.7543581474E+00, 9.5993668600E-01],
	[3.4005000000E+04, 3.4605794226E+01, 5.5938428948E+00, 1.7048614566E+01, 3.7548719209E+00, 9.5995748781E-01],
	[3.4010000000E+04, 3.4614512449E+01, 5.5938684017E+00, 1.7056853116E+01, 3.7553855404E+00, 9.5997827802E-01],
	[3.4015000000E+04, 3.4623231586E+01, 5.5938939050E+00, 1.7065094434E+01, 3.7558990059E+00, 9.5999905664E-01],
	[3.4020000000E+04, 3.4631951638E+01, 5.5939194047E+00, 1.7073338522E+01, 3.7564123176E+00, 9.6001982367E-01],
	[3.4025000000E+04, 3.4640672603E+01, 5.5939449008E+00, 1.7081585380E+01, 3.7569254754E+00, 9.6004057911E-01],
	[3.4030000000E+04, 3.4649394483E+01, 5.5939703932E+00, 1.7089835007E+01, 3.7574384794E+00, 9.6006132298E-01],
	[3.4035000000E+04, 3.4658117277E+01, 5.5939958820E+00, 1.7098087406E+01, 3.7579513296E+00, 9.6008205528E-01],
	[3.4040000000E+04, 3.4666840985E+01, 5.5940213672E+00, 1.7106342576E+01, 3.7584640261E+00, 9.6010277602E-01],
	[3.4045000000E+04, 3.4675565607E+01, 5.5940468487E+00, 1.7114600518E+01, 3.7589765688E+00, 9.6012348519E-01],
	[3.4050000000E+04, 3.4684291143E+01, 5.5940723266E+00, 1.7122861232E+01, 3.7594889578E+00, 9.6014418282E-01],
	[3.4055000000E+04, 3.4693017593E+01, 5.5940978009E+00, 1.7131124720E+01, 3.7600011932E+00, 9.6016486891E-01],
	[3.4060000000E+04, 3.4701744957E+01, 5.5941232716E+00, 1.7139390980E+01, 3.7605132750E+00, 9.6018554345E-01],
	[3.4065000000E+04, 3.4710473235E+01, 5.5941487386E+00, 1.7147660015E+01, 3.7610252032E+00, 9.6020620647E-01],
	[3.4070000000E+04, 3.4719202427E+01, 5.5941742021E+00, 1.7155931824E+01, 3.7615369779E+00, 9.6022685795E-01],
	[3.4075000000E+04, 3.4727932532E+01, 5.5941996619E+00, 1.7164206409E+01, 3.7620485991E+00, 9.6024749792E-01],
	[3.4080000000E+04, 3.4736663552E+01, 5.5942251180E+00, 1.7172483768E+01, 3.7625600667E+00, 9.6026812638E-01],
	[3.4085000000E+04, 3.4745395485E+01, 5.5942505706E+00, 1.7180763904E+01, 3.7630713810E+00, 9.6028874333E-01],
	[3.4090000000E+04, 3.4754128332E+01, 5.5942760196E+00, 1.7189046817E+01, 3.7635825418E+00, 9.6030934877E-01],
	[3.4095000000E+04, 3.4762862092E+01, 5.5943014649E+00, 1.7197332506E+01, 3.7640935492E+00, 9.6032994273E-01],
	[3.4100000000E+04, 3.4771596766E+01, 5.5943269066E+00, 1.7205620974E+01, 3.7646044034E+00, 9.6035052520E-01],
	[3.4105000000E+04, 3.4780332353E+01, 5.5943523447E+00, 1.7213912219E+01, 3.7651151042E+00, 9.6037109618E-01],
	[3.4110000000E+04, 3.4789068855E+01, 5.5943777792E+00, 1.7222206243E+01, 3.7656256517E+00, 9.6039165569E-01],
	[3.4115000000E+04, 3.4797806269E+01, 5.5944032101E+00, 1.7230503047E+01, 3.7661360461E+00, 9.6041220373E-01],
	[3.4120000000E+04, 3.4806544597E+01, 5.5944286373E+00, 1.7238802630E+01, 3.7666462872E+00, 9.6043274031E-01],
	[3.4125000000E+04, 3.4815283839E+01, 5.5944540610E+00, 1.7247104993E+01, 3.7671563752E+00, 9.6045326543E-01],
	[3.4130000000E+04, 3.4824023994E+01, 5.5944794810E+00, 1.7255410137E+01, 3.7676663100E+00, 9.6047377910E-01],
	[3.4135000000E+04, 3.4832765062E+01, 5.5945048975E+00, 1.7263718063E+01, 3.7681760917E+00, 9.6049428132E-01],
	[3.4140000000E+04, 3.4841507044E+01, 5.5945303103E+00, 1.7272028770E+01, 3.7686857204E+00, 9.6051477211E-01],
	[3.4145000000E+04, 3.4850249938E+01, 5.5945557195E+00, 1.7280342259E+01, 3.7691951961E+00, 9.6053525147E-01],
	[3.4150000000E+04, 3.4858993746E+01, 5.5945811251E+00, 1.7288658532E+01, 3.7697045188E+00, 9.6055571940E-01],
	[3.4155000000E+04, 3.4867738468E+01, 5.5946065271E+00, 1.7296977588E+01, 3.7702136885E+00, 9.6057617592E-01],
	[3.4160000000E+04, 3.4876484102E+01, 5.5946319255E+00, 1.7305299428E+01, 3.7707227053E+00, 9.6059662102E-01],
	[3.4165000000E+04, 3.4885230650E+01, 5.5946573203E+00, 1.7313624052E+01, 3.7712315692E+00, 9.6061705471E-01],
	[3.4170000000E+04, 3.4893978110E+01, 5.5946827115E+00, 1.7321951461E+01, 3.7717402803E+00, 9.6063747701E-01],
	[3.4175000000E+04, 3.4902726484E+01, 5.5947080992E+00, 1.7330281656E+01, 3.7722488386E+00, 9.6065788791E-01],
	[3.4180000000E+04, 3.4911475771E+01, 5.5947334832E+00, 1.7338614637E+01, 3.7727572440E+00, 9.6067828742E-01],
	[3.4185000000E+04, 3.4920225970E+01, 5.5947588636E+00, 1.7346950404E+01, 3.7732654968E+00, 9.6069867556E-01],
	[3.4190000000E+04, 3.4928977083E+01, 5.5947842404E+00, 1.7355288959E+01, 3.7737735968E+00, 9.6071905231E-01],
	[3.4195000000E+04, 3.4937729108E+01, 5.5948096136E+00, 1.7363630301E+01, 3.7742815442E+00, 9.6073941770E-01],
	[3.4200000000E+04, 3.4946482047E+01, 5.5948349832E+00, 1.7371974431E+01, 3.7747893389E+00, 9.6075977173E-01],
	[3.4205000000E+04, 3.4955235898E+01, 5.5948603492E+00, 1.7380321350E+01, 3.7752969810E+00, 9.6078011440E-01],
	[3.4210000000E+04, 3.4963990662E+01, 5.5948857117E+00, 1.7388671057E+01, 3.7758044706E+00, 9.6080044572E-01],
	[3.4215000000E+04, 3.4972746339E+01, 5.5949110705E+00, 1.7397023555E+01, 3.7763118076E+00, 9.6082076570E-01],
	[3.4220000000E+04, 3.4981502928E+01, 5.5949364258E+00, 1.7405378843E+01, 3.7768189922E+00, 9.6084107434E-01],
	[3.4225000000E+04, 3.4990260430E+01, 5.5949617774E+00, 1.7413736922E+01, 3.7773260242E+00, 9.6086137165E-01],
	[3.4230000000E+04, 3.4999018845E+01, 5.5949871255E+00, 1.7422097791E+01, 3.7778329039E+00, 9.6088165764E-01],
	[3.4235000000E+04, 3.5007778172E+01, 5.5950124700E+00, 1.7430461453E+01, 3.7783396311E+00, 9.6090193230E-01],
	[3.4240000000E+04, 3.5016538412E+01, 5.5950378109E+00, 1.7438827907E+01, 3.7788462060E+00, 9.6092219566E-01],
	[3.4245000000E+04, 3.5025299564E+01, 5.5950631482E+00, 1.7447197154E+01, 3.7793526286E+00, 9.6094244771E-01],
	[3.4250000000E+04, 3.5034061629E+01, 5.5950884820E+00, 1.7455569194E+01, 3.7798588989E+00, 9.6096268846E-01],
	[3.4255000000E+04, 3.5042824606E+01, 5.5951138121E+00, 1.7463944028E+01, 3.7803650169E+00, 9.6098291791E-01],
	[3.4260000000E+04, 3.5051588495E+01, 5.5951391387E+00, 1.7472321656E+01, 3.7808709827E+00, 9.6100313608E-01],
	[3.4265000000E+04, 3.5060353297E+01, 5.5951644617E+00, 1.7480702080E+01, 3.7813767964E+00, 9.6102334297E-01],
	[3.4270000000E+04, 3.5069119011E+01, 5.5951897811E+00, 1.7489085299E+01, 3.7818824579E+00, 9.6104353859E-01],
	[3.4275000000E+04, 3.5077885638E+01, 5.5952150969E+00, 1.7497471313E+01, 3.7823879673E+00, 9.6106372293E-01],
	[3.4280000000E+04, 3.5086653177E+01, 5.5952404091E+00, 1.7505860125E+01, 3.7828933246E+00, 9.6108389602E-01],
	[3.4285000000E+04, 3.5095421628E+01, 5.5952657178E+00, 1.7514251733E+01, 3.7833985298E+00, 9.6110405785E-01],
	[3.4290000000E+04, 3.5104190991E+01, 5.5952910229E+00, 1.7522646139E+01, 3.7839035831E+00, 9.6112420843E-01],
	[3.4295000000E+04, 3.5112961266E+01, 5.5953163244E+00, 1.7531043343E+01, 3.7844084844E+00, 9.6114434776E-01],
	[3.4300000000E+04, 3.5121732453E+01, 5.5953416223E+00, 1.7539443345E+01, 3.7849132338E+00, 9.6116447586E-01],
	[3.4305000000E+04, 3.5130504553E+01, 5.5953669167E+00, 1.7547846147E+01, 3.7854178313E+00, 9.6118459273E-01],
	[3.4310000000E+04, 3.5139277564E+01, 5.5953922075E+00, 1.7556251748E+01, 3.7859222769E+00, 9.6120469838E-01],
	[3.4315000000E+04, 3.5148051488E+01, 5.5954174947E+00, 1.7564660150E+01, 3.7864265707E+00, 9.6122479281E-01],
	[3.4320000000E+04, 3.5156826323E+01, 5.5954427784E+00, 1.7573071352E+01, 3.7869307126E+00, 9.6124487602E-01],
	[3.4325000000E+04, 3.5165602070E+01, 5.5954680585E+00, 1.7581485356E+01, 3.7874347029E+00, 9.6126494803E-01],
	[3.4330000000E+04, 3.5174378729E+01, 5.5954933350E+00, 1.7589902161E+01, 3.7879385414E+00, 9.6128500884E-01],
	[3.4335000000E+04, 3.5183156300E+01, 5.5955186080E+00, 1.7598321768E+01, 3.7884422282E+00, 9.6130505846E-01],
	[3.4340000000E+04, 3.5191934783E+01, 5.5955438773E+00, 1.7606744179E+01, 3.7889457634E+00, 9.6132509690E-01],
	[3.4345000000E+04, 3.5200714177E+01, 5.5955691432E+00, 1.7615169392E+01, 3.7894491470E+00, 9.6134512415E-01],
	[3.4350000000E+04, 3.5209494483E+01, 5.5955944054E+00, 1.7623597410E+01, 3.7899523790E+00, 9.6136514022E-01],
	[3.4355000000E+04, 3.5218275701E+01, 5.5956196641E+00, 1.7632028231E+01, 3.7904554594E+00, 9.6138514513E-01],
	[3.4360000000E+04, 3.5227057831E+01, 5.5956449193E+00, 1.7640461858E+01, 3.7909583883E+00, 9.6140513888E-01],
	[3.4365000000E+04, 3.5235840872E+01, 5.5956701708E+00, 1.7648898290E+01, 3.7914611658E+00, 9.6142512148E-01],
	[3.4370000000E+04, 3.5244624824E+01, 5.5956954188E+00, 1.7657337528E+01, 3.7919637918E+00, 9.6144509292E-01],
	[3.4375000000E+04, 3.5253409688E+01, 5.5957206633E+00, 1.7665779573E+01, 3.7924662664E+00, 9.6146505322E-01],
	[3.4380000000E+04, 3.5262195464E+01, 5.5957459042E+00, 1.7674224424E+01, 3.7929685897E+00, 9.6148500239E-01],
	[3.4385000000E+04, 3.5270982151E+01, 5.5957711415E+00, 1.7682672083E+01, 3.7934707616E+00, 9.6150494042E-01],
	[3.4390000000E+04, 3.5279769750E+01, 5.5957963753E+00, 1.7691122550E+01, 3.7939727822E+00, 9.6152486733E-01],
	[3.4395000000E+04, 3.5288558259E+01, 5.5958216055E+00, 1.7699575826E+01, 3.7944746516E+00, 9.6154478312E-01],
	[3.4400000000E+04, 3.5297347680E+01, 5.5958468322E+00, 1.7708031911E+01, 3.7949763698E+00, 9.6156468781E-01],
	[3.4405000000E+04, 3.5306138013E+01, 5.5958720553E+00, 1.7716490805E+01, 3.7954779367E+00, 9.6158458138E-01],
	[3.4410000000E+04, 3.5314929257E+01, 5.5958972749E+00, 1.7724952510E+01, 3.7959793525E+00, 9.6160446386E-01],
	[3.4415000000E+04, 3.5323721411E+01, 5.5959224909E+00, 1.7733417025E+01, 3.7964806172E+00, 9.6162433525E-01],
	[3.4420000000E+04, 3.5332514477E+01, 5.5959477034E+00, 1.7741884351E+01, 3.7969817308E+00, 9.6164419554E-01],
	[3.4425000000E+04, 3.5341308455E+01, 5.5959729123E+00, 1.7750354489E+01, 3.7974826934E+00, 9.6166404476E-01],
	[3.4430000000E+04, 3.5350103343E+01, 5.5959981177E+00, 1.7758827439E+01, 3.7979835049E+00, 9.6168388291E-01],
	[3.4435000000E+04, 3.5358899142E+01, 5.5960233195E+00, 1.7767303202E+01, 3.7984841655E+00, 9.6170370998E-01],
	[3.4440000000E+04, 3.5367695853E+01, 5.5960485178E+00, 1.7775781779E+01, 3.7989846752E+00, 9.6172352600E-01],
	[3.4445000000E+04, 3.5376493474E+01, 5.5960737125E+00, 1.7784263169E+01, 3.7994850339E+00, 9.6174333096E-01],
	[3.4450000000E+04, 3.5385292006E+01, 5.5960989037E+00, 1.7792747373E+01, 3.7999852418E+00, 9.6176312487E-01],
	[3.4455000000E+04, 3.5394091450E+01, 5.5961240914E+00, 1.7801234393E+01, 3.8004852988E+00, 9.6178290774E-01],
	[3.4460000000E+04, 3.5402891804E+01, 5.5961492755E+00, 1.7809724228E+01, 3.8009852050E+00, 9.6180267958E-01],
	[3.4465000000E+04, 3.5411693069E+01, 5.5961744561E+00, 1.7818216878E+01, 3.8014849605E+00, 9.6182244038E-01],
	[3.4470000000E+04, 3.5420495244E+01, 5.5961996331E+00, 1.7826712345E+01, 3.8019845653E+00, 9.6184219016E-01],
	[3.4475000000E+04, 3.5429298331E+01, 5.5962248066E+00, 1.7835210630E+01, 3.8024840194E+00, 9.6186192892E-01],
	[3.4480000000E+04, 3.5438102328E+01, 5.5962499765E+00, 1.7843711731E+01, 3.8029833228E+00, 9.6188165667E-01],
	[3.4485000000E+04, 3.5446907236E+01, 5.5962751430E+00, 1.7852215651E+01, 3.8034824756E+00, 9.6190137341E-01],
	[3.4490000000E+04, 3.5455713054E+01, 5.5963003058E+00, 1.7860722389E+01, 3.8039814778E+00, 9.6192107916E-01],
	[3.4495000000E+04, 3.5464519784E+01, 5.5963254652E+00, 1.7869231946E+01, 3.8044803295E+00, 9.6194077391E-01],
	[3.4500000000E+04, 3.5473327423E+01, 5.5963506210E+00, 1.7877744323E+01, 3.8049790306E+00, 9.6196045768E-01],
	[3.4505000000E+04, 3.5482135973E+01, 5.5963757733E+00, 1.7886259520E+01, 3.8054775813E+00, 9.6198013047E-01],
	[3.4510000000E+04, 3.5490945434E+01, 5.5964009220E+00, 1.7894777537E+01, 3.8059759815E+00, 9.6199979228E-01],
	[3.4515000000E+04, 3.5499755805E+01, 5.5964260673E+00, 1.7903298376E+01, 3.8064742314E+00, 9.6201944313E-01],
	[3.4520000000E+04, 3.5508567087E+01, 5.5964512089E+00, 1.7911822036E+01, 3.8069723309E+00, 9.6203908301E-01],
	[3.4525000000E+04, 3.5517379279E+01, 5.5964763471E+00, 1.7920348519E+01, 3.8074702800E+00, 9.6205871194E-01],
	[3.4530000000E+04, 3.5526192381E+01, 5.5965014817E+00, 1.7928877824E+01, 3.8079680789E+00, 9.6207832992E-01],
	[3.4535000000E+04, 3.5535026738E+01, 5.5965288942E+00, 1.7937409953E+01, 3.8084670176E+00, 9.6209793696E-01],
	[3.4540000000E+04, 3.5543865538E+01, 5.5965566982E+00, 1.7945944906E+01, 3.8089660301E+00, 9.6211753306E-01],
	[3.4545000000E+04, 3.5552705257E+01, 5.5965844983E+00, 1.7954482682E+01, 3.8094648929E+00, 9.6213711823E-01],
	[3.4550000000E+04, 3.5561545895E+01, 5.5966122945E+00, 1.7963023284E+01, 3.8099636059E+00, 9.6215669248E-01],
	[3.4555000000E+04, 3.5570387451E+01, 5.5966400868E+00, 1.7971566711E+01, 3.8104621692E+00, 9.6217625581E-01],
	[3.4560000000E+04, 3.5579229925E+01, 5.5966678752E+00, 1.7980112964E+01, 3.8109605829E+00, 9.6219580823E-01],
	[3.4565000000E+04, 3.5588073318E+01, 5.5966956598E+00, 1.7988662043E+01, 3.8114588469E+00, 9.6221534974E-01],
	[3.4570000000E+04, 3.5596917629E+01, 5.5967234404E+00, 1.7997213949E+01, 3.8119569614E+00, 9.6223488035E-01],
	[3.4575000000E+04, 3.5605762859E+01, 5.5967512172E+00, 1.8005768683E+01, 3.8124549263E+00, 9.6225440007E-01],
	[3.4580000000E+04, 3.5614609007E+01, 5.5967789901E+00, 1.8014326245E+01, 3.8129527417E+00, 9.6227390891E-01],
	[3.4585000000E+04, 3.5623456074E+01, 5.5968067592E+00, 1.8022886635E+01, 3.8134504076E+00, 9.6229340686E-01],
	[3.4590000000E+04, 3.5632304059E+01, 5.5968345243E+00, 1.8031449854E+01, 3.8139479241E+00, 9.6231289394E-01],
	[3.4595000000E+04, 3.5641152962E+01, 5.5968622856E+00, 1.8040015903E+01, 3.8144452911E+00, 9.6233237015E-01],
	[3.4600000000E+04, 3.5650002783E+01, 5.5968900430E+00, 1.8048584782E+01, 3.8149425088E+00, 9.6235183550E-01],
	[3.4605000000E+04, 3.5658853523E+01, 5.5969177965E+00, 1.8057156491E+01, 3.8154395772E+00, 9.6237129000E-01],
	[3.4610000000E+04, 3.5667705180E+01, 5.5969455462E+00, 1.8065731032E+01, 3.8159364963E+00, 9.6239073365E-01],
	[3.4615000000E+04, 3.5676557756E+01, 5.5969732920E+00, 1.8074308404E+01, 3.8164332661E+00, 9.6241016645E-01],
	[3.4620000000E+04, 3.5685411250E+01, 5.5970010339E+00, 1.8082888609E+01, 3.8169298866E+00, 9.6242958842E-01],
	[3.4625000000E+04, 3.5694265662E+01, 5.5970287719E+00, 1.8091471646E+01, 3.8174263580E+00, 9.6244899955E-01],
	[3.4630000000E+04, 3.5703120992E+01, 5.5970565061E+00, 1.8100057517E+01, 3.8179226803E+00, 9.6246839986E-01],
	[3.4635000000E+04, 3.5711977239E+01, 5.5970842364E+00, 1.8108646221E+01, 3.8184188534E+00, 9.6248778936E-01],
	[3.4640000000E+04, 3.5720834405E+01, 5.5971119629E+00, 1.8117237760E+01, 3.8189148774E+00, 9.6250716804E-01],
	[3.4645000000E+04, 3.5729692489E+01, 5.5971396855E+00, 1.8125832133E+01, 3.8194107524E+00, 9.6252653591E-01],
	[3.4650000000E+04, 3.5738551490E+01, 5.5971674042E+00, 1.8134429342E+01, 3.8199064783E+00, 9.6254589299E-01],
	[3.4655000000E+04, 3.5747411409E+01, 5.5971951190E+00, 1.8143029387E+01, 3.8204020553E+00, 9.6256523927E-01],
	[3.4660000000E+04, 3.5756272246E+01, 5.5972228300E+00, 1.8151632268E+01, 3.8208974834E+00, 9.6258457477E-01],
	[3.4665000000E+04, 3.5765134001E+01, 5.5972505372E+00, 1.8160237986E+01, 3.8213927625E+00, 9.6260389948E-01],
	[3.4670000000E+04, 3.5773996674E+01, 5.5972782404E+00, 1.8168846542E+01, 3.8218878928E+00, 9.6262321343E-01],
	[3.4675000000E+04, 3.5782860264E+01, 5.5973059399E+00, 1.8177457935E+01, 3.8223828742E+00, 9.6264251660E-01],
	[3.4680000000E+04, 3.5791724771E+01, 5.5973336354E+00, 1.8186072167E+01, 3.8228777069E+00, 9.6266180901E-01],
	[3.4685000000E+04, 3.5800590197E+01, 5.5973613271E+00, 1.8194689238E+01, 3.8233723908E+00, 9.6268109066E-01],
	[3.4690000000E+04, 3.5809456539E+01, 5.5973890150E+00, 1.8203309149E+01, 3.8238669259E+00, 9.6270036157E-01],
	[3.4695000000E+04, 3.5818323800E+01, 5.5974166990E+00, 1.8211931900E+01, 3.8243613124E+00, 9.6271962173E-01],
	[3.4700000000E+04, 3.5827191978E+01, 5.5974443791E+00, 1.8220557491E+01, 3.8248555502E+00, 9.6273887115E-01],
	[3.4705000000E+04, 3.5836061073E+01, 5.5974720554E+00, 1.8229185923E+01, 3.8253496394E+00, 9.6275810984E-01],
	[3.4710000000E+04, 3.5844931086E+01, 5.5974997279E+00, 1.8237817198E+01, 3.8258435800E+00, 9.6277733781E-01],
	[3.4715000000E+04, 3.5853802016E+01, 5.5975273965E+00, 1.8246451314E+01, 3.8263373721E+00, 9.6279655506E-01],
	[3.4720000000E+04, 3.5862673863E+01, 5.5975550612E+00, 1.8255088273E+01, 3.8268310156E+00, 9.6281576160E-01],
	[3.4725000000E+04, 3.5871546628E+01, 5.5975827221E+00, 1.8263728075E+01, 3.8273245107E+00, 9.6283495743E-01],
	[3.4730000000E+04, 3.5880420309E+01, 5.5976103792E+00, 1.8272370721E+01, 3.8278178573E+00, 9.6285414256E-01],
	[3.4735000000E+04, 3.5889294909E+01, 5.5976380324E+00, 1.8281016212E+01, 3.8283110556E+00, 9.6287331699E-01],
	[3.4740000000E+04, 3.5898170425E+01, 5.5976656818E+00, 1.8289664547E+01, 3.8288041055E+00, 9.6289248074E-01],
	[3.4745000000E+04, 3.5907046858E+01, 5.5976933273E+00, 1.8298315727E+01, 3.8292970070E+00, 9.6291163381E-01],
	[3.4750000000E+04, 3.5915924209E+01, 5.5977209690E+00, 1.8306969754E+01, 3.8297897603E+00, 9.6293077620E-01],
	[3.4755000000E+04, 3.5924802476E+01, 5.5977486068E+00, 1.8315626627E+01, 3.8302823653E+00, 9.6294990792E-01],
	[3.4760000000E+04, 3.5933681661E+01, 5.5977762408E+00, 1.8324286346E+01, 3.8307748220E+00, 9.6296902898E-01],
	[3.4765000000E+04, 3.5942561762E+01, 5.5978038710E+00, 1.8332948914E+01, 3.8312671306E+00, 9.6298813939E-01],
	[3.4770000000E+04, 3.5951442781E+01, 5.5978314973E+00, 1.8341614329E+01, 3.8317592910E+00, 9.6300723914E-01],
	[3.4775000000E+04, 3.5960324716E+01, 5.5978591198E+00, 1.8350282593E+01, 3.8322513034E+00, 9.6302632825E-01],
	[3.4780000000E+04, 3.5969207569E+01, 5.5978867384E+00, 1.8358953705E+01, 3.8327431676E+00, 9.6304540672E-01],
	[3.4785000000E+04, 3.5978091338E+01, 5.5979143533E+00, 1.8367627668E+01, 3.8332348838E+00, 9.6306447455E-01],
	[3.4790000000E+04, 3.5986976024E+01, 5.5979419643E+00, 1.8376304480E+01, 3.8337264520E+00, 9.6308353176E-01],
	[3.4795000000E+04, 3.5995861626E+01, 5.5979695714E+00, 1.8384984143E+01, 3.8342178722E+00, 9.6310257836E-01],
	[3.4800000000E+04, 3.6004748146E+01, 5.5979971747E+00, 1.8393666657E+01, 3.8347091445E+00, 9.6312161433E-01],
	[3.4805000000E+04, 3.6013635582E+01, 5.5980247742E+00, 1.8402352023E+01, 3.8352002689E+00, 9.6314063971E-01],
	[3.4810000000E+04, 3.6022523935E+01, 5.5980523699E+00, 1.8411040241E+01, 3.8356912455E+00, 9.6315965448E-01],
	[3.4815000000E+04, 3.6031413204E+01, 5.5980799617E+00, 1.8419731312E+01, 3.8361820742E+00, 9.6317865865E-01],
	[3.4820000000E+04, 3.6040303390E+01, 5.5981075498E+00, 1.8428425236E+01, 3.8366727551E+00, 9.6319765224E-01],
	[3.4825000000E+04, 3.6049194493E+01, 5.5981351339E+00, 1.8437122013E+01, 3.8371632882E+00, 9.6321663524E-01],
	[3.4830000000E+04, 3.6058086512E+01, 5.5981627143E+00, 1.8445821645E+01, 3.8376536737E+00, 9.6323560767E-01],
	[3.4835000000E+04, 3.6066979447E+01, 5.5981902908E+00, 1.8454524132E+01, 3.8381439115E+00, 9.6325456952E-01],
	[3.4840000000E+04, 3.6075873299E+01, 5.5982178636E+00, 1.8463229474E+01, 3.8386340016E+00, 9.6327352082E-01],
	[3.4845000000E+04, 3.6084768067E+01, 5.5982454325E+00, 1.8471937673E+01, 3.8391239441E+00, 9.6329246155E-01],
	[3.4850000000E+04, 3.6093663752E+01, 5.5982729975E+00, 1.8480648727E+01, 3.8396137391E+00, 9.6331139173E-01],
	[3.4855000000E+04, 3.6102560353E+01, 5.5983005588E+00, 1.8489362638E+01, 3.8401033865E+00, 9.6333031137E-01],
	[3.4860000000E+04, 3.6111457870E+01, 5.5983281162E+00, 1.8498079407E+01, 3.8405928864E+00, 9.6334922047E-01],
	[3.4865000000E+04, 3.6120356304E+01, 5.5983556699E+00, 1.8506799034E+01, 3.8410822388E+00, 9.6336811903E-01],
	[3.4870000000E+04, 3.6129255653E+01, 5.5983832197E+00, 1.8515521520E+01, 3.8415714439E+00, 9.6338700707E-01],
	[3.4875000000E+04, 3.6138155919E+01, 5.5984107657E+00, 1.8524246864E+01, 3.8420605015E+00, 9.6340588459E-01],
	[3.4880000000E+04, 3.6147057101E+01, 5.5984383079E+00, 1.8532975068E+01, 3.8425494118E+00, 9.6342475159E-01],
	[3.4885000000E+04, 3.6155959199E+01, 5.5984658462E+00, 1.8541706132E+01, 3.8430381747E+00, 9.6344360808E-01],
	[3.4890000000E+04, 3.6164862214E+01, 5.5984933808E+00, 1.8550440057E+01, 3.8435267904E+00, 9.6346245407E-01],
	[3.4895000000E+04, 3.6173766144E+01, 5.5985209115E+00, 1.8559176843E+01, 3.8440152588E+00, 9.6348128957E-01],
	[3.4900000000E+04, 3.6182670990E+01, 5.5985484385E+00, 1.8567916490E+01, 3.8445035800E+00, 9.6350011457E-01],
	[3.4905000000E+04, 3.6191576752E+01, 5.5985759616E+00, 1.8576659000E+01, 3.8449917541E+00, 9.6351892909E-01],
	[3.4910000000E+04, 3.6200483430E+01, 5.5986034809E+00, 1.8585404373E+01, 3.8454797810E+00, 9.6353773313E-01],
	[3.4915000000E+04, 3.6209391024E+01, 5.5986309964E+00, 1.8594152608E+01, 3.8459676608E+00, 9.6355652670E-01],
	[3.4920000000E+04, 3.6218299534E+01, 5.5986585082E+00, 1.8602903708E+01, 3.8464553936E+00, 9.6357530981E-01],
	[3.4925000000E+04, 3.6227208959E+01, 5.5986860161E+00, 1.8611657672E+01, 3.8469429793E+00, 9.6359408245E-01],
	[3.4930000000E+04, 3.6236119301E+01, 5.5987135202E+00, 1.8620414500E+01, 3.8474304180E+00, 9.6361284465E-01],
	[3.4935000000E+04, 3.6245030558E+01, 5.5987410205E+00, 1.8629174194E+01, 3.8479177098E+00, 9.6363159639E-01],
	[3.4940000000E+04, 3.6253942731E+01, 5.5987685170E+00, 1.8637936754E+01, 3.8484048546E+00, 9.6365033769E-01],
	[3.4945000000E+04, 3.6262855819E+01, 5.5987960097E+00, 1.8646702181E+01, 3.8488918526E+00, 9.6366906856E-01],
	[3.4950000000E+04, 3.6271769823E+01, 5.5988234986E+00, 1.8655470474E+01, 3.8493787037E+00, 9.6368778900E-01],
	[3.4955000000E+04, 3.6280684742E+01, 5.5988509837E+00, 1.8664241635E+01, 3.8498654080E+00, 9.6370649902E-01],
	[3.4960000000E+04, 3.6289600578E+01, 5.5988784650E+00, 1.8673015663E+01, 3.8503519656E+00, 9.6372519862E-01],
	[3.4965000000E+04, 3.6298517328E+01, 5.5989059425E+00, 1.8681792561E+01, 3.8508383764E+00, 9.6374388781E-01],
	[3.4970000000E+04, 3.6307434994E+01, 5.5989334163E+00, 1.8690572327E+01, 3.8513246405E+00, 9.6376256660E-01],
	[3.4975000000E+04, 3.6316353576E+01, 5.5989608862E+00, 1.8699354963E+01, 3.8518107579E+00, 9.6378123499E-01],
	[3.4980000000E+04, 3.6325273073E+01, 5.5989883523E+00, 1.8708140469E+01, 3.8522967287E+00, 9.6379989298E-01],
	[3.4985000000E+04, 3.6334193485E+01, 5.5990158147E+00, 1.8716928845E+01, 3.8527825530E+00, 9.6381854059E-01],
	[3.4990000000E+04, 3.6343114813E+01, 5.5990432732E+00, 1.8725720093E+01, 3.8532682306E+00, 9.6383717782E-01],
	[3.4995000000E+04, 3.6352037055E+01, 5.5990707280E+00, 1.8734514213E+01, 3.8537537618E+00, 9.6385580468E-01],
	[3.5000000000E+04, 3.6360960214E+01, 5.5990981790E+00, 1.8743311204E+01, 3.8542391465E+00, 9.6387442117E-01],
	[3.5005000000E+04, 3.6369884287E+01, 5.5991256262E+00, 1.8752123101E+01, 3.8547248931E+00, 9.6389302730E-01],
	[3.5010000000E+04, 3.6378809275E+01, 5.5991530696E+00, 1.8760937879E+01, 3.8552104930E+00, 9.6391162307E-01],
	[3.5015000000E+04, 3.6387735179E+01, 5.5991805092E+00, 1.8769755542E+01, 3.8556959463E+00, 9.6393020849E-01],
	[3.5020000000E+04, 3.6396661998E+01, 5.5992079450E+00, 1.8778576088E+01, 3.8561812529E+00, 9.6394878358E-01],
	[3.5025000000E+04, 3.6405589732E+01, 5.5992353771E+00, 1.8787399518E+01, 3.8566664129E+00, 9.6396734832E-01],
	[3.5030000000E+04, 3.6414518380E+01, 5.5992628054E+00, 1.8796225834E+01, 3.8571514264E+00, 9.6398590273E-01],
	[3.5035000000E+04, 3.6423447944E+01, 5.5992902299E+00, 1.8805055035E+01, 3.8576362933E+00, 9.6400444682E-01],
	[3.5040000000E+04, 3.6432378423E+01, 5.5993176506E+00, 1.8813887122E+01, 3.8581210138E+00, 9.6402298059E-01],
	[3.5045000000E+04, 3.6441309817E+01, 5.5993450675E+00, 1.8822722095E+01, 3.8586055878E+00, 9.6404150405E-01],
	[3.5050000000E+04, 3.6450242125E+01, 5.5993724807E+00, 1.8831559956E+01, 3.8590900154E+00, 9.6406001720E-01],
	[3.5055000000E+04, 3.6459175349E+01, 5.5993998901E+00, 1.8840400704E+01, 3.8595742967E+00, 9.6407852005E-01],
	[3.5060000000E+04, 3.6468109487E+01, 5.5994272957E+00, 1.8849244340E+01, 3.8600584316E+00, 9.6409701261E-01],
	[3.5065000000E+04, 3.6477044540E+01, 5.5994546975E+00, 1.8858090865E+01, 3.8605424202E+00, 9.6411549488E-01],
	[3.5070000000E+04, 3.6485980507E+01, 5.5994820956E+00, 1.8866940279E+01, 3.8610262625E+00, 9.6413396686E-01],
	[3.5075000000E+04, 3.6494917390E+01, 5.5995094899E+00, 1.8875792583E+01, 3.8615099586E+00, 9.6415242857E-01],
	[3.5080000000E+04, 3.6503855187E+01, 5.5995368804E+00, 1.8884647778E+01, 3.8619935085E+00, 9.6417088001E-01],
	[3.5085000000E+04, 3.6512793899E+01, 5.5995642671E+00, 1.8893505862E+01, 3.8624769123E+00, 9.6418932119E-01],
	[3.5090000000E+04, 3.6521749404E+01, 5.5995934124E+00, 1.8902366839E+01, 3.8629611862E+00, 9.6420775211E-01],
	[3.5095000000E+04, 3.6530713555E+01, 5.5996234108E+00, 1.8911230707E+01, 3.8634458088E+00, 9.6422617278E-01],
	[3.5100000000E+04, 3.6539678630E+01, 5.5996534052E+00, 1.8920097467E+01, 3.8639302858E+00, 9.6424458320E-01],
	[3.5105000000E+04, 3.6548644626E+01, 5.5996833954E+00, 1.8928967121E+01, 3.8644146172E+00, 9.6426298339E-01],
	[3.5110000000E+04, 3.6557611546E+01, 5.5997133815E+00, 1.8937839668E+01, 3.8648988030E+00, 9.6428137334E-01],
	[3.5115000000E+04, 3.6566579388E+01, 5.5997433636E+00, 1.8946715108E+01, 3.8653828433E+00, 9.6429975306E-01],
	[3.5120000000E+04, 3.6575548153E+01, 5.5997733415E+00, 1.8955593444E+01, 3.8658667381E+00, 9.6431812256E-01],
	[3.5125000000E+04, 3.6584517840E+01, 5.5998033153E+00, 1.8964474674E+01, 3.8663504874E+00, 9.6433648185E-01],
	[3.5130000000E+04, 3.6593488450E+01, 5.5998332850E+00, 1.8973358800E+01, 3.8668340912E+00, 9.6435483093E-01],
	[3.5135000000E+04, 3.6602459982E+01, 5.5998632506E+00, 1.8982245822E+01, 3.8673175497E+00, 9.6437316980E-01],
	[3.5140000000E+04, 3.6611432437E+01, 5.5998932120E+00, 1.8991135741E+01, 3.8678008629E+00, 9.6439149848E-01],
	[3.5145000000E+04, 3.6620405814E+01, 5.5999231694E+00, 1.9000028557E+01, 3.8682840307E+00, 9.6440981697E-01],
	[3.5150000000E+04, 3.6629380113E+01, 5.5999531227E+00, 1.9008924270E+01, 3.8687670532E+00, 9.6442812527E-01],
	[3.5155000000E+04, 3.6638355335E+01, 5.5999830719E+00, 1.9017822882E+01, 3.8692499305E+00, 9.6444642340E-01],
	[3.5160000000E+04, 3.6647331479E+01, 5.6000130170E+00, 1.9026724393E+01, 3.8697326626E+00, 9.6446471135E-01],
	[3.5165000000E+04, 3.6656308545E+01, 5.6000429580E+00, 1.9035628803E+01, 3.8702152495E+00, 9.6448298914E-01],
	[3.5170000000E+04, 3.6665286534E+01, 5.6000728949E+00, 1.9044536112E+01, 3.8706976913E+00, 9.6450125676E-01],
	[3.5175000000E+04, 3.6674265444E+01, 5.6001028276E+00, 1.9053446322E+01, 3.8711799880E+00, 9.6451951423E-01],
	[3.5180000000E+04, 3.6683245277E+01, 5.6001327563E+00, 1.9062359433E+01, 3.8716621396E+00, 9.6453776155E-01],
	[3.5185000000E+04, 3.6692226032E+01, 5.6001626810E+00, 1.9071275445E+01, 3.8721441462E+00, 9.6455599874E-01],
	[3.5190000000E+04, 3.6701207709E+01, 5.6001926015E+00, 1.9080194360E+01, 3.8726260078E+00, 9.6457422578E-01],
	[3.5195000000E+04, 3.6710190308E+01, 5.6002225179E+00, 1.9089116177E+01, 3.8731077244E+00, 9.6459244270E-01],
	[3.5200000000E+04, 3.6719173829E+01, 5.6002524302E+00, 1.9098040896E+01, 3.8735892962E+00, 9.6461064949E-01],
	[3.5205000000E+04, 3.6728158272E+01, 5.6002823385E+00, 1.9106968520E+01, 3.8740707230E+00, 9.6462884616E-01],
	[3.5210000000E+04, 3.6737143637E+01, 5.6003122426E+00, 1.9115899047E+01, 3.8745520050E+00, 9.6464703272E-01],
	[3.5215000000E+04, 3.6746129923E+01, 5.6003421427E+00, 1.9124832479E+01, 3.8750331422E+00, 9.6466520917E-01],
	[3.5220000000E+04, 3.6755117132E+01, 5.6003720387E+00, 1.9133768816E+01, 3.8755141347E+00, 9.6468337553E-01],
	[3.5225000000E+04, 3.6764105262E+01, 5.6004019306E+00, 1.9142708059E+01, 3.8759949824E+00, 9.6470153179E-01],
	[3.5230000000E+04, 3.6773094314E+01, 5.6004318184E+00, 1.9151650208E+01, 3.8764756854E+00, 9.6471967796E-01],
	[3.5235000000E+04, 3.6782084288E+01, 5.6004617021E+00, 1.9160595264E+01, 3.8769562437E+00, 9.6473781406E-01],
	[3.5240000000E+04, 3.6791075184E+01, 5.6004915818E+00, 1.9169543227E+01, 3.8774366575E+00, 9.6475594007E-01],
	[3.5245000000E+04, 3.6800067001E+01, 5.6005214574E+00, 1.9178494098E+01, 3.8779169266E+00, 9.6477405602E-01],
	[3.5250000000E+04, 3.6809059740E+01, 5.6005513288E+00, 1.9187447877E+01, 3.8783970512E+00, 9.6479216190E-01],
	[3.5255000000E+04, 3.6818053400E+01, 5.6005811963E+00, 1.9196404565E+01, 3.8788770313E+00, 9.6481025773E-01],
	[3.5260000000E+04, 3.6827047982E+01, 5.6006110596E+00, 1.9205364162E+01, 3.8793568669E+00, 9.6482834350E-01],
	[3.5265000000E+04, 3.6836043486E+01, 5.6006409189E+00, 1.9214326670E+01, 3.8798365580E+00, 9.6484641923E-01],
	[3.5270000000E+04, 3.6845039911E+01, 5.6006707741E+00, 1.9223292088E+01, 3.8803161048E+00, 9.6486448492E-01],
	[3.5275000000E+04, 3.6854037257E+01, 5.6007006252E+00, 1.9232260416E+01, 3.8807955072E+00, 9.6488254057E-01],
	[3.5280000000E+04, 3.6863035525E+01, 5.6007304722E+00, 1.9241231657E+01, 3.8812747652E+00, 9.6490058620E-01],
	[3.5285000000E+04, 3.6872034714E+01, 5.6007603152E+00, 1.9250205809E+01, 3.8817538790E+00, 9.6491862181E-01],
	[3.5290000000E+04, 3.6881034825E+01, 5.6007901541E+00, 1.9259182874E+01, 3.8822328485E+00, 9.6493664740E-01],
	[3.5295000000E+04, 3.6890035856E+01, 5.6008199890E+00, 1.9268162852E+01, 3.8827116738E+00, 9.6495466298E-01],
	[3.5300000000E+04, 3.6899037810E+01, 5.6008498197E+00, 1.9277145744E+01, 3.8831903549E+00, 9.6497266856E-01],
	[3.5305000000E+04, 3.6908040684E+01, 5.6008796464E+00, 1.9286131550E+01, 3.8836688919E+00, 9.6499066414E-01],
	[3.5310000000E+04, 3.6917044479E+01, 5.6009094691E+00, 1.9295120271E+01, 3.8841472847E+00, 9.6500864973E-01],
	[3.5315000000E+04, 3.6926049196E+01, 5.6009392876E+00, 1.9304111907E+01, 3.8846255335E+00, 9.6502662534E-01],
	[3.5320000000E+04, 3.6935054834E+01, 5.6009691022E+00, 1.9313106458E+01, 3.8851036383E+00, 9.6504459096E-01],
	[3.5325000000E+04, 3.6944061393E+01, 5.6009989126E+00, 1.9322103926E+01, 3.8855815990E+00, 9.6506254661E-01],
	[3.5330000000E+04, 3.6953068873E+01, 5.6010287190E+00, 1.9331104311E+01, 3.8860594158E+00, 9.6508049230E-01],
	[3.5335000000E+04, 3.6962077274E+01, 5.6010585213E+00, 1.9340107613E+01, 3.8865370886E+00, 9.6509842802E-01],
	[3.5340000000E+04, 3.6971086596E+01, 5.6010883196E+00, 1.9349113834E+01, 3.8870146176E+00, 9.6511635379E-01],
	[3.5345000000E+04, 3.6980096838E+01, 5.6011181138E+00, 1.9358122972E+01, 3.8874920027E+00, 9.6513426961E-01],
	[3.5350000000E+04, 3.6989108002E+01, 5.6011479040E+00, 1.9367135030E+01, 3.8879692440E+00, 9.6515217548E-01],
	[3.5355000000E+04, 3.6998120087E+01, 5.6011776901E+00, 1.9376150007E+01, 3.8884463416E+00, 9.6517007142E-01],
	[3.5360000000E+04, 3.7007133092E+01, 5.6012074721E+00, 1.9385167904E+01, 3.8889232953E+00, 9.6518795743E-01],
	[3.5365000000E+04, 3.7016147018E+01, 5.6012372501E+00, 1.9394188722E+01, 3.8894001054E+00, 9.6520583351E-01],
	[3.5370000000E+04, 3.7025161865E+01, 5.6012670241E+00, 1.9403212460E+01, 3.8898767718E+00, 9.6522369967E-01],
	[3.5375000000E+04, 3.7034177633E+01, 5.6012967940E+00, 1.9412239121E+01, 3.8903532946E+00, 9.6524155592E-01],
	[3.5380000000E+04, 3.7043194322E+01, 5.6013265598E+00, 1.9421268704E+01, 3.8908296738E+00, 9.6525940226E-01],
	[3.5385000000E+04, 3.7052211931E+01, 5.6013563216E+00, 1.9430301209E+01, 3.8913059094E+00, 9.6527723870E-01],
	[3.5390000000E+04, 3.7061230460E+01, 5.6013860794E+00, 1.9439336638E+01, 3.8917820015E+00, 9.6529506525E-01],
	[3.5395000000E+04, 3.7070249910E+01, 5.6014158331E+00, 1.9448374990E+01, 3.8922579501E+00, 9.6531288190E-01],
	[3.5400000000E+04, 3.7079270281E+01, 5.6014455828E+00, 1.9457416267E+01, 3.8927337553E+00, 9.6533068867E-01],
	[3.5405000000E+04, 3.7088291573E+01, 5.6014753284E+00, 1.9466460468E+01, 3.8932094170E+00, 9.6534848557E-01],
	[3.5410000000E+04, 3.7097313784E+01, 5.6015050699E+00, 1.9475507595E+01, 3.8936849354E+00, 9.6536627259E-01],
	[3.5415000000E+04, 3.7106336916E+01, 5.6015348075E+00, 1.9484557648E+01, 3.8941603105E+00, 9.6538404975E-01],
	[3.5420000000E+04, 3.7115360969E+01, 5.6015645410E+00, 1.9493610627E+01, 3.8946355422E+00, 9.6540181705E-01],
	[3.5425000000E+04, 3.7124385942E+01, 5.6015942704E+00, 1.9502666533E+01, 3.8951106307E+00, 9.6541957449E-01],
	[3.5430000000E+04, 3.7133411835E+01, 5.6016239958E+00, 1.9511725367E+01, 3.8955855759E+00, 9.6543732209E-01],
	[3.5435000000E+04, 3.7142438649E+01, 5.6016537172E+00, 1.9520787128E+01, 3.8960603780E+00, 9.6545505984E-01],
	[3.5440000000E+04, 3.7151466383E+01, 5.6016834346E+00, 1.9529851819E+01, 3.8965350369E+00, 9.6547278776E-01],
	[3.5445000000E+04, 3.7160495037E+01, 5.6017131479E+00, 1.9538919438E+01, 3.8970095527E+00, 9.6549050585E-01],
	[3.5450000000E+04, 3.7169524611E+01, 5.6017428572E+00, 1.9547989987E+01, 3.8974839255E+00, 9.6550821411E-01],
	[3.5455000000E+04, 3.7178555105E+01, 5.6017725624E+00, 1.9557063466E+01, 3.8979581551E+00, 9.6552591256E-01],
	[3.5460000000E+04, 3.7187586520E+01, 5.6018022636E+00, 1.9566139876E+01, 3.8984322418E+00, 9.6554360120E-01],
	[3.5465000000E+04, 3.7196618854E+01, 5.6018319608E+00, 1.9575219217E+01, 3.8989061855E+00, 9.6556128003E-01],
	[3.5470000000E+04, 3.7205652109E+01, 5.6018616539E+00, 1.9584301490E+01, 3.8993799863E+00, 9.6557894906E-01],
	[3.5475000000E+04, 3.7214686283E+01, 5.6018913431E+00, 1.9593386695E+01, 3.8998536442E+00, 9.6559660829E-01],
	[3.5480000000E+04, 3.7223721378E+01, 5.6019210282E+00, 1.9602474833E+01, 3.9003271592E+00, 9.6561425774E-01],
	[3.5485000000E+04, 3.7232757392E+01, 5.6019507092E+00, 1.9611565904E+01, 3.9008005314E+00, 9.6563189740E-01],
	[3.5490000000E+04, 3.7241794327E+01, 5.6019803863E+00, 1.9620659909E+01, 3.9012737608E+00, 9.6564952729E-01],
	[3.5495000000E+04, 3.7250832181E+01, 5.6020100593E+00, 1.9629756849E+01, 3.9017468475E+00, 9.6566714741E-01],
	[3.5500000000E+04, 3.7259870955E+01, 5.6020397283E+00, 1.9638856724E+01, 3.9022197915E+00, 9.6568475777E-01],
	[3.5505000000E+04, 3.7268910649E+01, 5.6020693933E+00, 1.9647959534E+01, 3.9026925927E+00, 9.6570235836E-01],
	[3.5510000000E+04, 3.7277951262E+01, 5.6020990542E+00, 1.9657065280E+01, 3.9031652514E+00, 9.6571994920E-01],
	[3.5515000000E+04, 3.7286992795E+01, 5.6021287112E+00, 1.9666173962E+01, 3.9036377675E+00, 9.6573753030E-01],
	[3.5520000000E+04, 3.7296035248E+01, 5.6021583641E+00, 1.9675285582E+01, 3.9041101410E+00, 9.6575510166E-01],
	[3.5525000000E+04, 3.7305078621E+01, 5.6021880130E+00, 1.9684400140E+01, 3.9045823719E+00, 9.6577266328E-01],
	[3.5530000000E+04, 3.7314122913E+01, 5.6022176579E+00, 1.9693517635E+01, 3.9050544604E+00, 9.6579021517E-01],
	[3.5535000000E+04, 3.7323168125E+01, 5.6022472988E+00, 1.9702638069E+01, 3.9055264064E+00, 9.6580775734E-01],
	[3.5540000000E+04, 3.7332214256E+01, 5.6022769356E+00, 1.9711761443E+01, 3.9059982101E+00, 9.6582528979E-01],
	[3.5545000000E+04, 3.7341261307E+01, 5.6023065685E+00, 1.9720887756E+01, 3.9064698713E+00, 9.6584281253E-01],
	[3.5550000000E+04, 3.7350309277E+01, 5.6023361973E+00, 1.9730017010E+01, 3.9069413902E+00, 9.6586032557E-01],
	[3.5555000000E+04, 3.7359358167E+01, 5.6023658222E+00, 1.9739149204E+01, 3.9074127668E+00, 9.6587782891E-01],
	[3.5560000000E+04, 3.7368407976E+01, 5.6023954430E+00, 1.9748284340E+01, 3.9078840011E+00, 9.6589532255E-01],
	[3.5565000000E+04, 3.7377458704E+01, 5.6024250598E+00, 1.9757422417E+01, 3.9083550933E+00, 9.6591280651E-01],
	[3.5570000000E+04, 3.7386510352E+01, 5.6024546726E+00, 1.9766563437E+01, 3.9088260432E+00, 9.6593028078E-01],
	[3.5575000000E+04, 3.7395562919E+01, 5.6024842814E+00, 1.9775707400E+01, 3.9092968509E+00, 9.6594774538E-01],
	[3.5580000000E+04, 3.7404616405E+01, 5.6025138862E+00, 1.9784854307E+01, 3.9097675166E+00, 9.6596520031E-01],
	[3.5585000000E+04, 3.7413670811E+01, 5.6025434870E+00, 1.9794004157E+01, 3.9102380401E+00, 9.6598264558E-01],
	[3.5590000000E+04, 3.7422726135E+01, 5.6025730837E+00, 1.9803156952E+01, 3.9107084217E+00, 9.6600008118E-01],
	[3.5595000000E+04, 3.7431782379E+01, 5.6026026765E+00, 1.9812312693E+01, 3.9111786612E+00, 9.6601750714E-01],
	[3.5600000000E+04, 3.7440839542E+01, 5.6026322653E+00, 1.9821471378E+01, 3.9116487587E+00, 9.6603492345E-01],
	[3.5605000000E+04, 3.7449897624E+01, 5.6026618501E+00, 1.9830633010E+01, 3.9121187143E+00, 9.6605233012E-01],
	[3.5610000000E+04, 3.7458956625E+01, 5.6026914309E+00, 1.9839797589E+01, 3.9125885281E+00, 9.6606972715E-01],
	[3.5615000000E+04, 3.7468016545E+01, 5.6027210077E+00, 1.9848965115E+01, 3.9130581999E+00, 9.6608711456E-01],
	[3.5620000000E+04, 3.7477077384E+01, 5.6027505805E+00, 1.9858135588E+01, 3.9135277300E+00, 9.6610449234E-01],
	[3.5625000000E+04, 3.7486139142E+01, 5.6027801493E+00, 1.9867309010E+01, 3.9139971182E+00, 9.6612186051E-01],
	[3.5630000000E+04, 3.7495201818E+01, 5.6028097141E+00, 1.9876485381E+01, 3.9144663647E+00, 9.6613921907E-01],
	[3.5635000000E+04, 3.7504265414E+01, 5.6028392749E+00, 1.9885664701E+01, 3.9149354695E+00, 9.6615656802E-01],
	[3.5640000000E+04, 3.7513329928E+01, 5.6028688317E+00, 1.9894846971E+01, 3.9154044327E+00, 9.6617390737E-01],
	[3.5645000000E+04, 3.7522395362E+01, 5.6028983845E+00, 1.9904032192E+01, 3.9158732541E+00, 9.6619123713E-01],
	[3.5650000000E+04, 3.7531461713E+01, 5.6029279334E+00, 1.9913220363E+01, 3.9163419340E+00, 9.6620855730E-01],
	[3.5655000000E+04, 3.7540545467E+01, 5.6029592800E+00, 1.9922411486E+01, 3.9168115323E+00, 9.6622586789E-01],
	[3.5660000000E+04, 3.7549637099E+01, 5.6029913823E+00, 1.9931605561E+01, 3.9172814364E+00, 9.6624316890E-01],
	[3.5665000000E+04, 3.7558729657E+01, 5.6030234804E+00, 1.9940802588E+01, 3.9177511995E+00, 9.6626046033E-01],
	[3.5670000000E+04, 3.7567823143E+01, 5.6030555741E+00, 1.9950002569E+01, 3.9182208214E+00, 9.6627774220E-01],
	[3.5675000000E+04, 3.7576917555E+01, 5.6030876635E+00, 1.9959205503E+01, 3.9186903024E+00, 9.6629501451E-01],
	[3.5680000000E+04, 3.7586012893E+01, 5.6031197486E+00, 1.9968411391E+01, 3.9191596423E+00, 9.6631227725E-01],
	[3.5685000000E+04, 3.7595109158E+01, 5.6031518294E+00, 1.9977620234E+01, 3.9196288413E+00, 9.6632953045E-01],
	[3.5690000000E+04, 3.7604206350E+01, 5.6031839059E+00, 1.9986832033E+01, 3.9200978993E+00, 9.6634677409E-01],
	[3.5695000000E+04, 3.7613304468E+01, 5.6032159781E+00, 1.9996046787E+01, 3.9205668164E+00, 9.6636400819E-01],
	[3.5700000000E+04, 3.7622403512E+01, 5.6032480459E+00, 2.0005264497E+01, 3.9210355927E+00, 9.6638123276E-01],
	[3.5705000000E+04, 3.7631503483E+01, 5.6032801095E+00, 2.0014485164E+01, 3.9215042282E+00, 9.6639844779E-01],
	[3.5710000000E+04, 3.7640604380E+01, 5.6033121687E+00, 2.0023708789E+01, 3.9219727228E+00, 9.6641565329E-01],
	[3.5715000000E+04, 3.7649706204E+01, 5.6033442237E+00, 2.0032935371E+01, 3.9224410768E+00, 9.6643284927E-01],
	[3.5720000000E+04, 3.7658808954E+01, 5.6033762743E+00, 2.0042164912E+01, 3.9229092900E+00, 9.6645003574E-01],
	[3.5725000000E+04, 3.7667912630E+01, 5.6034083206E+00, 2.0051397412E+01, 3.9233773626E+00, 9.6646721269E-01],
	[3.5730000000E+04, 3.7677017232E+01, 5.6034403627E+00, 2.0060632872E+01, 3.9238452945E+00, 9.6648438013E-01],
	[3.5735000000E+04, 3.7686122761E+01, 5.6034724004E+00, 2.0069871291E+01, 3.9243130858E+00, 9.6650153807E-01],
	[3.5740000000E+04, 3.7695229215E+01, 5.6035044338E+00, 2.0079112671E+01, 3.9247807366E+00, 9.6651868651E-01],
	[3.5745000000E+04, 3.7704336596E+01, 5.6035364630E+00, 2.0088357012E+01, 3.9252482468E+00, 9.6653582546E-01],
	[3.5750000000E+04, 3.7713444903E+01, 5.6035684878E+00, 2.0097604315E+01, 3.9257156166E+00, 9.6655295493E-01],
	[3.5755000000E+04, 3.7722554136E+01, 5.6036005083E+00, 2.0106854580E+01, 3.9261828459E+00, 9.6657007491E-01],
	[3.5760000000E+04, 3.7731664295E+01, 5.6036325246E+00, 2.0116107808E+01, 3.9266499348E+00, 9.6658718541E-01],
	[3.5765000000E+04, 3.7740775380E+01, 5.6036645365E+00, 2.0125363998E+01, 3.9271168833E+00, 9.6660428644E-01],
	[3.5770000000E+04, 3.7749887391E+01, 5.6036965442E+00, 2.0134623153E+01, 3.9275836915E+00, 9.6662137801E-01],
	[3.5775000000E+04, 3.7759000327E+01, 5.6037285476E+00, 2.0143885272E+01, 3.9280503594E+00, 9.6663846011E-01],
	[3.5780000000E+04, 3.7768114190E+01, 5.6037605466E+00, 2.0153150356E+01, 3.9285168870E+00, 9.6665553275E-01],
	[3.5785000000E+04, 3.7777228979E+01, 5.6037925414E+00, 2.0162418405E+01, 3.9289832744E+00, 9.6667259595E-01],
	[3.5790000000E+04, 3.7786344693E+01, 5.6038245319E+00, 2.0171689420E+01, 3.9294495216E+00, 9.6668964969E-01],
	[3.5795000000E+04, 3.7795461333E+01, 5.6038565182E+00, 2.0180963402E+01, 3.9299156286E+00, 9.6670669400E-01],
	[3.5800000000E+04, 3.7804578899E+01, 5.6038885001E+00, 2.0190240350E+01, 3.9303815955E+00, 9.6672372887E-01],
	[3.5805000000E+04, 3.7813697390E+01, 5.6039204777E+00, 2.0199520266E+01, 3.9308474224E+00, 9.6674075430E-01],
	[3.5810000000E+04, 3.7822816807E+01, 5.6039524511E+00, 2.0208803151E+01, 3.9313131092E+00, 9.6675777031E-01],
	[3.5815000000E+04, 3.7831937150E+01, 5.6039844202E+00, 2.0218089003E+01, 3.9317786560E+00, 9.6677477690E-01],
	[3.5820000000E+04, 3.7841058418E+01, 5.6040163850E+00, 2.0227377825E+01, 3.9322440628E+00, 9.6679177407E-01],
	[3.5825000000E+04, 3.7850180612E+01, 5.6040483455E+00, 2.0236669617E+01, 3.9327093297E+00, 9.6680876183E-01],
	[3.5830000000E+04, 3.7859303732E+01, 5.6040803018E+00, 2.0245964378E+01, 3.9331744568E+00, 9.6682574018E-01],
	[3.5835000000E+04, 3.7868427777E+01, 5.6041122537E+00, 2.0255262111E+01, 3.9336394439E+00, 9.6684270914E-01],
	[3.5840000000E+04, 3.7877552747E+01, 5.6041442014E+00, 2.0264562814E+01, 3.9341042912E+00, 9.6685966869E-01],
	[3.5845000000E+04, 3.7886678643E+01, 5.6041761448E+00, 2.0273866490E+01, 3.9345689988E+00, 9.6687661886E-01],
	[3.5850000000E+04, 3.7895805464E+01, 5.6042080840E+00, 2.0283173138E+01, 3.9350335666E+00, 9.6689355964E-01],
	[3.5855000000E+04, 3.7904933210E+01, 5.6042400189E+00, 2.0292482758E+01, 3.9354979947E+00, 9.6691049103E-01],
	[3.5860000000E+04, 3.7914061882E+01, 5.6042719495E+00, 2.0301795352E+01, 3.9359622831E+00, 9.6692741306E-01],
	[3.5865000000E+04, 3.7923191479E+01, 5.6043038758E+00, 2.0311110920E+01, 3.9364264319E+00, 9.6694432571E-01],
	[3.5870000000E+04, 3.7932322002E+01, 5.6043357979E+00, 2.0320429463E+01, 3.9368904411E+00, 9.6696122899E-01],
	[3.5875000000E+04, 3.7941453449E+01, 5.6043677157E+00, 2.0329750980E+01, 3.9373543107E+00, 9.6697812292E-01],
	[3.5880000000E+04, 3.7950585822E+01, 5.6043996292E+00, 2.0339075473E+01, 3.9378180408E+00, 9.6699500748E-01],
	[3.5885000000E+04, 3.7959719120E+01, 5.6044315385E+00, 2.0348402942E+01, 3.9382816314E+00, 9.6701188270E-01],
	[3.5890000000E+04, 3.7968853343E+01, 5.6044634435E+00, 2.0357733388E+01, 3.9387450826E+00, 9.6702874858E-01],
	[3.5895000000E+04, 3.7977988491E+01, 5.6044953442E+00, 2.0367066811E+01, 3.9392083943E+00, 9.6704560511E-01],
	[3.5900000000E+04, 3.7987124564E+01, 5.6045272407E+00, 2.0376403211E+01, 3.9396715667E+00, 9.6706245230E-01],
	[3.5905000000E+04, 3.7996261562E+01, 5.6045591329E+00, 2.0385742590E+01, 3.9401345997E+00, 9.6707929017E-01],
	[3.5910000000E+04, 3.8005399484E+01, 5.6045910208E+00, 2.0395084947E+01, 3.9405974935E+00, 9.6709611871E-01],
	[3.5915000000E+04, 3.8014538332E+01, 5.6046229045E+00, 2.0404430284E+01, 3.9410602479E+00, 9.6711293793E-01],
	[3.5920000000E+04, 3.8023678105E+01, 5.6046547840E+00, 2.0413778601E+01, 3.9415228632E+00, 9.6712974784E-01],
	[3.5925000000E+04, 3.8032818803E+01, 5.6046866592E+00, 2.0423129897E+01, 3.9419853392E+00, 9.6714654843E-01],
	[3.5930000000E+04, 3.8041960425E+01, 5.6047185301E+00, 2.0432484175E+01, 3.9424476761E+00, 9.6716333972E-01],
	[3.5935000000E+04, 3.8051102972E+01, 5.6047503968E+00, 2.0441841434E+01, 3.9429098739E+00, 9.6718012171E-01],
	[3.5940000000E+04, 3.8060246444E+01, 5.6047822592E+00, 2.0451201676E+01, 3.9433719326E+00, 9.6719689441E-01],
	[3.5945000000E+04, 3.8069390841E+01, 5.6048141174E+00, 2.0460564899E+01, 3.9438338523E+00, 9.6721365781E-01],
	[3.5950000000E+04, 3.8078536162E+01, 5.6048459713E+00, 2.0469931106E+01, 3.9442956330E+00, 9.6723041193E-01],
	[3.5955000000E+04, 3.8087682408E+01, 5.6048778210E+00, 2.0479300296E+01, 3.9447572746E+00, 9.6724715677E-01],
	[3.5960000000E+04, 3.8096829579E+01, 5.6049096664E+00, 2.0488672470E+01, 3.9452187774E+00, 9.6726389234E-01],
	[3.5965000000E+04, 3.8105977674E+01, 5.6049415076E+00, 2.0498047629E+01, 3.9456801413E+00, 9.6728061864E-01],
	[3.5970000000E+04, 3.8115126694E+01, 5.6049733445E+00, 2.0507425773E+01, 3.9461413663E+00, 9.6729733567E-01],
	[3.5975000000E+04, 3.8124276638E+01, 5.6050051772E+00, 2.0516806903E+01, 3.9466024525E+00, 9.6731404344E-01],
	[3.5980000000E+04, 3.8133427506E+01, 5.6050370056E+00, 2.0526191019E+01, 3.9470633999E+00, 9.6733074196E-01],
	[3.5985000000E+04, 3.8142579299E+01, 5.6050688298E+00, 2.0535578122E+01, 3.9475242085E+00, 9.6734743123E-01],
	[3.5990000000E+04, 3.8151732017E+01, 5.6051006498E+00, 2.0544968212E+01, 3.9479848785E+00, 9.6736411125E-01],
	[3.5995000000E+04, 3.8160885659E+01, 5.6051324655E+00, 2.0554361290E+01, 3.9484454098E+00, 9.6738078204E-01],
	[3.6000000000E+04, 3.8170040225E+01, 5.6051642770E+00, 2.0563757357E+01, 3.9489058024E+00, 9.6739744359E-01],
	[3.6005000000E+04, 3.8179195715E+01, 5.6051960843E+00, 2.0573156412E+01, 3.9493660565E+00, 9.6741409591E-01],
	[3.6010000000E+04, 3.8188352130E+01, 5.6052278873E+00, 2.0582558457E+01, 3.9498261720E+00, 9.6743073901E-01],
	[3.6015000000E+04, 3.8197509469E+01, 5.6052596860E+00, 2.0591963491E+01, 3.9502861490E+00, 9.6744737289E-01],
	[3.6020000000E+04, 3.8206667732E+01, 5.6052914806E+00, 2.0601371516E+01, 3.9507459875E+00, 9.6746399755E-01],
	[3.6025000000E+04, 3.8215826919E+01, 5.6053232709E+00, 2.0610782533E+01, 3.9512056875E+00, 9.6748061301E-01],
	[3.6030000000E+04, 3.8224987030E+01, 5.6053550570E+00, 2.0620196541E+01, 3.9516652491E+00, 9.6749721926E-01],
	[3.6035000000E+04, 3.8234148066E+01, 5.6053868388E+00, 2.0629613541E+01, 3.9521246724E+00, 9.6751381631E-01],
	[3.6040000000E+04, 3.8243310025E+01, 5.6054186164E+00, 2.0639033533E+01, 3.9525839573E+00, 9.6753040417E-01],
	[3.6045000000E+04, 3.8252472909E+01, 5.6054503898E+00, 2.0648456519E+01, 3.9530431039E+00, 9.6754698284E-01],
	[3.6050000000E+04, 3.8261636716E+01, 5.6054821590E+00, 2.0657882499E+01, 3.9535021123E+00, 9.6756355233E-01],
	[3.6055000000E+04, 3.8270801448E+01, 5.6055139239E+00, 2.0667311472E+01, 3.9539609824E+00, 9.6758011264E-01],
	[3.6060000000E+04, 3.8279967103E+01, 5.6055456846E+00, 2.0676743441E+01, 3.9544197144E+00, 9.6759666378E-01],
	[3.6065000000E+04, 3.8289133682E+01, 5.6055774411E+00, 2.0686178405E+01, 3.9548783082E+00, 9.6761320574E-01],
	[3.6070000000E+04, 3.8298301185E+01, 5.6056091934E+00, 2.0695616365E+01, 3.9553367639E+00, 9.6762973855E-01],
	[3.6075000000E+04, 3.8307469612E+01, 5.6056409414E+00, 2.0705057321E+01, 3.9557950815E+00, 9.6764626219E-01],
	[3.6080000000E+04, 3.8316638962E+01, 5.6056726852E+00, 2.0714501274E+01, 3.9562532611E+00, 9.6766277669E-01],
	[3.6085000000E+04, 3.8325809237E+01, 5.6057044248E+00, 2.0723948225E+01, 3.9567113026E+00, 9.6767928203E-01],
	[3.6090000000E+04, 3.8334980435E+01, 5.6057361602E+00, 2.0733398174E+01, 3.9571692063E+00, 9.6769577823E-01],
	[3.6095000000E+04, 3.8344152556E+01, 5.6057678914E+00, 2.0742851121E+01, 3.9576269719E+00, 9.6771226529E-01],
	[3.6100000000E+04, 3.8353325602E+01, 5.6057996184E+00, 2.0752307067E+01, 3.9580845997E+00, 9.6772874322E-01],
	[3.6105000000E+04, 3.8362499570E+01, 5.6058313411E+00, 2.0761766013E+01, 3.9585420897E+00, 9.6774521203E-01],
	[3.6110000000E+04, 3.8371674463E+01, 5.6058630596E+00, 2.0771227959E+01, 3.9589994418E+00, 9.6776167171E-01],
	[3.6115000000E+04, 3.8380850279E+01, 5.6058947739E+00, 2.0780692906E+01, 3.9594566561E+00, 9.6777812227E-01],
	[3.6120000000E+04, 3.8390027018E+01, 5.6059264840E+00, 2.0790160854E+01, 3.9599137327E+00, 9.6779456372E-01],
	[3.6125000000E+04, 3.8399204681E+01, 5.6059581899E+00, 2.0799631804E+01, 3.9603706716E+00, 9.6781099606E-01],
	[3.6130000000E+04, 3.8408383267E+01, 5.6059898916E+00, 2.0809105756E+01, 3.9608274729E+00, 9.6782741930E-01],
	[3.6135000000E+04, 3.8417562777E+01, 5.6060215891E+00, 2.0818582711E+01, 3.9612841365E+00, 9.6784383344E-01],
	[3.6140000000E+04, 3.8426743210E+01, 5.6060532824E+00, 2.0828062669E+01, 3.9617406625E+00, 9.6786023848E-01],
	[3.6145000000E+04, 3.8435924566E+01, 5.6060849714E+00, 2.0837545631E+01, 3.9621970510E+00, 9.6787663445E-01],
	[3.6150000000E+04, 3.8445106846E+01, 5.6061166563E+00, 2.0847031598E+01, 3.9626533019E+00, 9.6789302132E-01],
	[3.6155000000E+04, 3.8454290049E+01, 5.6061483369E+00, 2.0856520569E+01, 3.9631094154E+00, 9.6790939913E-01],
	[3.6160000000E+04, 3.8463474175E+01, 5.6061800134E+00, 2.0866012546E+01, 3.9635653914E+00, 9.6792576785E-01],
	[3.6165000000E+04, 3.8472659224E+01, 5.6062116856E+00, 2.0875507530E+01, 3.9640212300E+00, 9.6794212752E-01],
	[3.6170000000E+04, 3.8481845196E+01, 5.6062433537E+00, 2.0885005519E+01, 3.9644769312E+00, 9.6795847811E-01],
	[3.6175000000E+04, 3.8491032091E+01, 5.6062750176E+00, 2.0894506516E+01, 3.9649324952E+00, 9.6797481966E-01],
	[3.6180000000E+04, 3.8500219910E+01, 5.6063066772E+00, 2.0904010521E+01, 3.9653879218E+00, 9.6799115215E-01],
	[3.6185000000E+04, 3.8509408651E+01, 5.6063383327E+00, 2.0913517534E+01, 3.9658432111E+00, 9.6800747559E-01],
	[3.6190000000E+04, 3.8518598316E+01, 5.6063699839E+00, 2.0923027555E+01, 3.9662983633E+00, 9.6802378999E-01],
	[3.6195000000E+04, 3.8527788903E+01, 5.6064016310E+00, 2.0932540586E+01, 3.9667533782E+00, 9.6804009535E-01],
	[3.6200000000E+04, 3.8536980414E+01, 5.6064332739E+00, 2.0942056626E+01, 3.9672082561E+00, 9.6805639168E-01],
	[3.6205000000E+04, 3.8546172847E+01, 5.6064649126E+00, 2.0951575677E+01, 3.9676629968E+00, 9.6807267899E-01],
	[3.6210000000E+04, 3.8555366203E+01, 5.6064965471E+00, 2.0961097739E+01, 3.9681176004E+00, 9.6808895727E-01],
	[3.6215000000E+04, 3.8564560482E+01, 5.6065281774E+00, 2.0970622812E+01, 3.9685720670E+00, 9.6810522654E-01],
	[3.6220000000E+04, 3.8573755684E+01, 5.6065598035E+00, 2.0980150897E+01, 3.9690263966E+00, 9.6812148679E-01],
	[3.6225000000E+04, 3.8582951808E+01, 5.6065914255E+00, 2.0989681995E+01, 3.9694805893E+00, 9.6813773804E-01],
	[3.6230000000E+04, 3.8592170162E+01, 5.6066253359E+00, 2.0999216105E+01, 3.9699360200E+00, 9.6815398029E-01],
	[3.6235000000E+04, 3.8601391419E+01, 5.6066594541E+00, 2.1008753230E+01, 3.9703914415E+00, 9.6817021354E-01],
	[3.6240000000E+04, 3.8610613607E+01, 5.6066935679E+00, 2.1018293368E+01, 3.9708467264E+00, 9.6818643779E-01],
	[3.6245000000E+04, 3.8619836724E+01, 5.6067276771E+00, 2.1027836521E+01, 3.9713018750E+00, 9.6820265307E-01],
	[3.6250000000E+04, 3.8629060773E+01, 5.6067617819E+00, 2.1037382689E+01, 3.9717568870E+00, 9.6821885936E-01],
	[3.6255000000E+04, 3.8638285752E+01, 5.6067958822E+00, 2.1046931873E+01, 3.9722117627E+00, 9.6823505667E-01],
	[3.6260000000E+04, 3.8647511661E+01, 5.6068299779E+00, 2.1056484073E+01, 3.9726665021E+00, 9.6825124501E-01],
	[3.6265000000E+04, 3.8656738501E+01, 5.6068640692E+00, 2.1066039289E+01, 3.9731211051E+00, 9.6826742439E-01],
	[3.6270000000E+04, 3.8665966271E+01, 5.6068981560E+00, 2.1075597523E+01, 3.9735755719E+00, 9.6828359480E-01],
	[3.6275000000E+04, 3.8675194971E+01, 5.6069322382E+00, 2.1085158775E+01, 3.9740299024E+00, 9.6829975626E-01],
	[3.6280000000E+04, 3.8684424602E+01, 5.6069663160E+00, 2.1094723046E+01, 3.9744840967E+00, 9.6831590877E-01],
	[3.6285000000E+04, 3.8693655163E+01, 5.6070003893E+00, 2.1104290335E+01, 3.9749381549E+00, 9.6833205233E-01],
	[3.6290000000E+04, 3.8702886654E+01, 5.6070344582E+00, 2.1113860644E+01, 3.9753920769E+00, 9.6834818695E-01],
	[3.6295000000E+04, 3.8712119075E+01, 5.6070685225E+00, 2.1123433972E+01, 3.9758458629E+00, 9.6836431263E-01],
	[3.6300000000E+04, 3.8721352426E+01, 5.6071025823E+00, 2.1133010321E+01, 3.9762995128E+00, 9.6838042938E-01],
	[3.6305000000E+04, 3.8730586708E+01, 5.6071366377E+00, 2.1142589692E+01, 3.9767530266E+00, 9.6839653721E-01],
	[3.6310000000E+04, 3.8739821919E+01, 5.6071706886E+00, 2.1152172084E+01, 3.9772064045E+00, 9.6841263611E-01],
	[3.6315000000E+04, 3.8749058061E+01, 5.6072047350E+00, 2.1161757498E+01, 3.9776596465E+00, 9.6842872610E-01],
	[3.6320000000E+04, 3.8758295132E+01, 5.6072387769E+00, 2.1171345934E+01, 3.9781127525E+00, 9.6844480718E-01],
	[3.6325000000E+04, 3.8767533134E+01, 5.6072728143E+00, 2.1180937394E+01, 3.9785657227E+00, 9.6846087935E-01],
	[3.6330000000E+04, 3.8776772065E+01, 5.6073068473E+00, 2.1190531878E+01, 3.9790185571E+00, 9.6847694262E-01],
	[3.6335000000E+04, 3.8786011926E+01, 5.6073408758E+00, 2.1200129386E+01, 3.9794712556E+00, 9.6849299700E-01],
	[3.6340000000E+04, 3.8795252717E+01, 5.6073748998E+00, 2.1209729919E+01, 3.9799238184E+00, 9.6850904249E-01],
	[3.6345000000E+04, 3.8804494438E+01, 5.6074089193E+00, 2.1219333477E+01, 3.9803762455E+00, 9.6852507908E-01],
	[3.6350000000E+04, 3.8813737089E+01, 5.6074429344E+00, 2.1228940061E+01, 3.9808285369E+00, 9.6854110680E-01],
	[3.6355000000E+04, 3.8822980670E+01, 5.6074769449E+00, 2.1238549671E+01, 3.9812806926E+00, 9.6855712564E-01],
	[3.6360000000E+04, 3.8832225180E+01, 5.6075109511E+00, 2.1248162309E+01, 3.9817327128E+00, 9.6857313562E-01],
	[3.6365000000E+04, 3.8841470620E+01, 5.6075449527E+00, 2.1257777974E+01, 3.9821845973E+00, 9.6858913672E-01],
	[3.6370000000E+04, 3.8850716989E+01, 5.6075789499E+00, 2.1267396667E+01, 3.9826363464E+00, 9.6860512897E-01],
	[3.6375000000E+04, 3.8859964288E+01, 5.6076129426E+00, 2.1277018388E+01, 3.9830879599E+00, 9.6862111236E-01],
	[3.6380000000E+04, 3.8869212517E+01, 5.6076469308E+00, 2.1286643139E+01, 3.9835394380E+00, 9.6863708690E-01],
	[3.6385000000E+04, 3.8878461676E+01, 5.6076809146E+00, 2.1296270919E+01, 3.9839907806E+00, 9.6865305259E-01],
	[3.6390000000E+04, 3.8887711763E+01, 5.6077148939E+00, 2.1305901730E+01, 3.9844419879E+00, 9.6866900944E-01],
	[3.6395000000E+04, 3.8896962781E+01, 5.6077488688E+00, 2.1315535571E+01, 3.9848930598E+00, 9.6868495746E-01],
	[3.6400000000E+04, 3.8906214727E+01, 5.6077828391E+00, 2.1325172443E+01, 3.9853439964E+00, 9.6870089665E-01],
	[3.6405000000E+04, 3.8915467604E+01, 5.6078168051E+00, 2.1334812348E+01, 3.9857947978E+00, 9.6871682701E-01],
	[3.6410000000E+04, 3.8924721409E+01, 5.6078507665E+00, 2.1344455284E+01, 3.9862454639E+00, 9.6873274855E-01],
	[3.6415000000E+04, 3.8933976144E+01, 5.6078847236E+00, 2.1354101254E+01, 3.9866959947E+00, 9.6874866127E-01],
	[3.6420000000E+04, 3.8943231808E+01, 5.6079186761E+00, 2.1363750257E+01, 3.9871463905E+00, 9.6876456519E-01],
	[3.6425000000E+04, 3.8952488402E+01, 5.6079526242E+00, 2.1373402294E+01, 3.9875966511E+00, 9.6878046030E-01],
	[3.6430000000E+04, 3.8961745924E+01, 5.6079865679E+00, 2.1383057365E+01, 3.9880467766E+00, 9.6879634661E-01],
	[3.6435000000E+04, 3.8971004376E+01, 5.6080205071E+00, 2.1392715471E+01, 3.9884967671E+00, 9.6881222412E-01],
	[3.6440000000E+04, 3.8980263757E+01, 5.6080544418E+00, 2.1402376613E+01, 3.9889466225E+00, 9.6882809285E-01],
	[3.6445000000E+04, 3.8989524067E+01, 5.6080883721E+00, 2.1412040791E+01, 3.9893963430E+00, 9.6884395278E-01],
	[3.6450000000E+04, 3.8998785307E+01, 5.6081222979E+00, 2.1421708006E+01, 3.9898459285E+00, 9.6885980394E-01],
	[3.6455000000E+04, 3.9008047475E+01, 5.6081562193E+00, 2.1431378258E+01, 3.9902953792E+00, 9.6887564632E-01],
	[3.6460000000E+04, 3.9017310572E+01, 5.6081901363E+00, 2.1441051547E+01, 3.9907446949E+00, 9.6889147994E-01],
	[3.6465000000E+04, 3.9026574599E+01, 5.6082240488E+00, 2.1450727875E+01, 3.9911938759E+00, 9.6890730478E-01],
	[3.6470000000E+04, 3.9035839554E+01, 5.6082579568E+00, 2.1460407242E+01, 3.9916429220E+00, 9.6892312087E-01],
	[3.6475000000E+04, 3.9045105438E+01, 5.6082918604E+00, 2.1470089648E+01, 3.9920918334E+00, 9.6893892820E-01],
	[3.6480000000E+04, 3.9054372252E+01, 5.6083257596E+00, 2.1479775093E+01, 3.9925406101E+00, 9.6895472678E-01],
	[3.6485000000E+04, 3.9063639994E+01, 5.6083596543E+00, 2.1489463580E+01, 3.9929892521E+00, 9.6897051662E-01],
	[3.6490000000E+04, 3.9072908665E+01, 5.6083935446E+00, 2.1499155107E+01, 3.9934377594E+00, 9.6898629771E-01],
	[3.6495000000E+04, 3.9082178264E+01, 5.6084274305E+00, 2.1508849675E+01, 3.9938861321E+00, 9.6900207007E-01],
	[3.6500000000E+04, 3.9091448793E+01, 5.6084613119E+00, 2.1518547286E+01, 3.9943343703E+00, 9.6901783370E-01],
	[3.6505000000E+04, 3.9100720250E+01, 5.6084951888E+00, 2.1528247939E+01, 3.9947824740E+00, 9.6903358861E-01],
	[3.6510000000E+04, 3.9109992636E+01, 5.6085290614E+00, 2.1537951635E+01, 3.9952304431E+00, 9.6904933479E-01],
	[3.6515000000E+04, 3.9119265950E+01, 5.6085629295E+00, 2.1547658375E+01, 3.9956782778E+00, 9.6906507226E-01],
	[3.6520000000E+04, 3.9128540193E+01, 5.6085967932E+00, 2.1557368159E+01, 3.9961259781E+00, 9.6908080102E-01],
	[3.6525000000E+04, 3.9137815365E+01, 5.6086306524E+00, 2.1567080987E+01, 3.9965735439E+00, 9.6909652107E-01],
	[3.6530000000E+04, 3.9147091465E+01, 5.6086645072E+00, 2.1576796861E+01, 3.9970209755E+00, 9.6911223243E-01],
	[3.6535000000E+04, 3.9156368494E+01, 5.6086983576E+00, 2.1586515781E+01, 3.9974682727E+00, 9.6912793508E-01],
	[3.6540000000E+04, 3.9165646451E+01, 5.6087322036E+00, 2.1596237747E+01, 3.9979154357E+00, 9.6914362905E-01],
	[3.6545000000E+04, 3.9174925337E+01, 5.6087660451E+00, 2.1605962760E+01, 3.9983624644E+00, 9.6915931433E-01],
	[3.6550000000E+04, 3.9184205151E+01, 5.6087998822E+00, 2.1615690820E+01, 3.9988093589E+00, 9.6917499094E-01],
	[3.6555000000E+04, 3.9193485894E+01, 5.6088337149E+00, 2.1625421928E+01, 3.9992561193E+00, 9.6919065886E-01],
	[3.6560000000E+04, 3.9202767565E+01, 5.6088675431E+00, 2.1635156085E+01, 3.9997027455E+00, 9.6920631812E-01],
	[3.6565000000E+04, 3.9212050164E+01, 5.6089013670E+00, 2.1644893290E+01, 4.0001492377E+00, 9.6922196871E-01],
	[3.6570000000E+04, 3.9221333691E+01, 5.6089351864E+00, 2.1654633545E+01, 4.0005955958E+00, 9.6923761064E-01],
	[3.6575000000E+04, 3.9230618147E+01, 5.6089690014E+00, 2.1664376851E+01, 4.0010418199E+00, 9.6925324392E-01],
	[3.6580000000E+04, 3.9239903531E+01, 5.6090028119E+00, 2.1674123206E+01, 4.0014879100E+00, 9.6926886855E-01],
	[3.6585000000E+04, 3.9249189843E+01, 5.6090366181E+00, 2.1683872613E+01, 4.0019338662E+00, 9.6928448453E-01],
	[3.6590000000E+04, 3.9258477083E+01, 5.6090704198E+00, 2.1693625072E+01, 4.0023796885E+00, 9.6930009187E-01],
	[3.6595000000E+04, 3.9267765252E+01, 5.6091042172E+00, 2.1703380583E+01, 4.0028253769E+00, 9.6931569057E-01],
	[3.6600000000E+04, 3.9277054348E+01, 5.6091380101E+00, 2.1713139146E+01, 4.0032709315E+00, 9.6933128065E-01],
	[3.6605000000E+04, 3.9286344373E+01, 5.6091717986E+00, 2.1722900763E+01, 4.0037163523E+00, 9.6934686209E-01],
	[3.6610000000E+04, 3.9295635325E+01, 5.6092055826E+00, 2.1732665434E+01, 4.0041616394E+00, 9.6936243492E-01],
	[3.6615000000E+04, 3.9304927205E+01, 5.6092393623E+00, 2.1742433159E+01, 4.0046067927E+00, 9.6937799914E-01],
	[3.6620000000E+04, 3.9314220014E+01, 5.6092731376E+00, 2.1752203939E+01, 4.0050518124E+00, 9.6939355474E-01],
	[3.6625000000E+04, 3.9323513750E+01, 5.6093069084E+00, 2.1761977774E+01, 4.0054966984E+00, 9.6940910174E-01],
	[3.6630000000E+04, 3.9332808414E+01, 5.6093406749E+00, 2.1771754666E+01, 4.0059414508E+00, 9.6942464013E-01],
	[3.6635000000E+04, 3.9342104006E+01, 5.6093744369E+00, 2.1781534614E+01, 4.0063860697E+00, 9.6944016993E-01],
	[3.6640000000E+04, 3.9351400526E+01, 5.6094081946E+00, 2.1791317619E+01, 4.0068305550E+00, 9.6945569115E-01],
	[3.6645000000E+04, 3.9360697974E+01, 5.6094419478E+00, 2.1801103681E+01, 4.0072749068E+00, 9.6947120377E-01],
	[3.6650000000E+04, 3.9369996349E+01, 5.6094756967E+00, 2.1810892802E+01, 4.0077191252E+00, 9.6948670782E-01],
	[3.6655000000E+04, 3.9379295652E+01, 5.6095094411E+00, 2.1820684982E+01, 4.0081632102E+00, 9.6950220329E-01],
	[3.6660000000E+04, 3.9388595883E+01, 5.6095431811E+00, 2.1830480220E+01, 4.0086071618E+00, 9.6951769018E-01],
	[3.6665000000E+04, 3.9397897041E+01, 5.6095769168E+00, 2.1840278519E+01, 4.0090509800E+00, 9.6953316852E-01],
	[3.6670000000E+04, 3.9407199127E+01, 5.6096106480E+00, 2.1850079877E+01, 4.0094946650E+00, 9.6954863829E-01],
	[3.6675000000E+04, 3.9416502141E+01, 5.6096443749E+00, 2.1859884297E+01, 4.0099382166E+00, 9.6956409951E-01],
	[3.6680000000E+04, 3.9425806082E+01, 5.6096780973E+00, 2.1869691778E+01, 4.0103816351E+00, 9.6957955217E-01],
	[3.6685000000E+04, 3.9435110950E+01, 5.6097118154E+00, 2.1879502320E+01, 4.0108249203E+00, 9.6959499629E-01],
	[3.6690000000E+04, 3.9444416746E+01, 5.6097455290E+00, 2.1889315926E+01, 4.0112680724E+00, 9.6961043187E-01],
	[3.6695000000E+04, 3.9453723470E+01, 5.6097792383E+00, 2.1899132594E+01, 4.0117110914E+00, 9.6962585891E-01],
	[3.6700000000E+04, 3.9463031120E+01, 5.6098129432E+00, 2.1908952326E+01, 4.0121539773E+00, 9.6964127743E-01],
	[3.6705000000E+04, 3.9472339699E+01, 5.6098466437E+00, 2.1918775121E+01, 4.0125967301E+00, 9.6965668741E-01],
	[3.6710000000E+04, 3.9481649204E+01, 5.6098803398E+00, 2.1928600982E+01, 4.0130393500E+00, 9.6967208888E-01],
	[3.6715000000E+04, 3.9490959637E+01, 5.6099140315E+00, 2.1938429907E+01, 4.0134818369E+00, 9.6968748183E-01],
	[3.6720000000E+04, 3.9500270997E+01, 5.6099477188E+00, 2.1948261899E+01, 4.0139241908E+00, 9.6970286627E-01],
	[3.6725000000E+04, 3.9509583284E+01, 5.6099814018E+00, 2.1958096956E+01, 4.0143664118E+00, 9.6971824220E-01],
	[3.6730000000E+04, 3.9518896499E+01, 5.6100150803E+00, 2.1967935080E+01, 4.0148085000E+00, 9.6973360963E-01],
	[3.6735000000E+04, 3.9528210640E+01, 5.6100487545E+00, 2.1977776271E+01, 4.0152504554E+00, 9.6974896857E-01],
	[3.6740000000E+04, 3.9537525709E+01, 5.6100824243E+00, 2.1987620531E+01, 4.0156922780E+00, 9.6976431901E-01],
	[3.6745000000E+04, 3.9546841705E+01, 5.6101160897E+00, 2.1997467858E+01, 4.0161339678E+00, 9.6977966097E-01],
	[3.6750000000E+04, 3.9556158628E+01, 5.6101497508E+00, 2.2007318255E+01, 4.0165755249E+00, 9.6979499445E-01],
	[3.6755000000E+04, 3.9565476478E+01, 5.6101834074E+00, 2.2017171721E+01, 4.0170169494E+00, 9.6981031945E-01],
	[3.6760000000E+04, 3.9574795255E+01, 5.6102170597E+00, 2.2027028257E+01, 4.0174582412E+00, 9.6982563598E-01],
	[3.6765000000E+04, 3.9584114959E+01, 5.6102507076E+00, 2.2036887863E+01, 4.0178994004E+00, 9.6984094404E-01],
	[3.6770000000E+04, 3.9593435590E+01, 5.6102843512E+00, 2.2046750541E+01, 4.0183404270E+00, 9.6985624364E-01],
	[3.6775000000E+04, 3.9602757147E+01, 5.6103179903E+00, 2.2056616290E+01, 4.0187813212E+00, 9.6987153478E-01],
	[3.6780000000E+04, 3.9612079632E+01, 5.6103516251E+00, 2.2066485111E+01, 4.0192220828E+00, 9.6988681748E-01],
	[3.6785000000E+04, 3.9621403043E+01, 5.6103852556E+00, 2.2076357005E+01, 4.0196627120E+00, 9.6990209172E-01],
	[3.6790000000E+04, 3.9630727381E+01, 5.6104188816E+00, 2.2086231972E+01, 4.0201032088E+00, 9.6991735753E-01],
	[3.6795000000E+04, 3.9640052646E+01, 5.6104525033E+00, 2.2096110013E+01, 4.0205435732E+00, 9.6993261490E-01],
	[3.6800000000E+04, 3.9649378838E+01, 5.6104861206E+00, 2.2105991128E+01, 4.0209838053E+00, 9.6994786383E-01],
	[3.6805000000E+04, 3.9658705956E+01, 5.6105197336E+00, 2.2115875318E+01, 4.0214239050E+00, 9.6996310434E-01],
	[3.6810000000E+04, 3.9668040456E+01, 5.6105540262E+00, 2.2125762584E+01, 4.0218642904E+00, 9.6997833643E-01],
	[3.6815000000E+04, 3.9677392547E+01, 5.6105900798E+00, 2.2135652925E+01, 4.0223056222E+00, 9.6999356010E-01],
	[3.6820000000E+04, 3.9686745572E+01, 5.6106261288E+00, 2.2145546342E+01, 4.0227468222E+00, 9.7000877536E-01],
	[3.6825000000E+04, 3.9696099532E+01, 5.6106621731E+00, 2.2155442837E+01, 4.0231878904E+00, 9.7002398221E-01],
	[3.6830000000E+04, 3.9705454426E+01, 5.6106982127E+00, 2.2165342409E+01, 4.0236288267E+00, 9.7003918065E-01],
	[3.6835000000E+04, 3.9714810254E+01, 5.6107342477E+00, 2.2175245060E+01, 4.0240696313E+00, 9.7005437071E-01],
	[3.6840000000E+04, 3.9724167017E+01, 5.6107702780E+00, 2.2185150788E+01, 4.0245103042E+00, 9.7006955237E-01],
	[3.6845000000E+04, 3.9733524713E+01, 5.6108063037E+00, 2.2195059596E+01, 4.0249508454E+00, 9.7008472564E-01],
	[3.6850000000E+04, 3.9742883344E+01, 5.6108423247E+00, 2.2204971484E+01, 4.0253912550E+00, 9.7009989053E-01],
	[3.6855000000E+04, 3.9752242909E+01, 5.6108783410E+00, 2.2214886452E+01, 4.0258315330E+00, 9.7011504704E-01],
	[3.6860000000E+04, 3.9761603408E+01, 5.6109143527E+00, 2.2224804501E+01, 4.0262716794E+00, 9.7013019518E-01],
	[3.6865000000E+04, 3.9770964840E+01, 5.6109503598E+00, 2.2234725631E+01, 4.0267116942E+00, 9.7014533495E-01],
	[3.6870000000E+04, 3.9780327207E+01, 5.6109863622E+00, 2.2244649842E+01, 4.0271515776E+00, 9.7016046635E-01],
	[3.6875000000E+04, 3.9789690508E+01, 5.6110223599E+00, 2.2254577136E+01, 4.0275913295E+00, 9.7017558941E-01],
	[3.6880000000E+04, 3.9799054743E+01, 5.6110583530E+00, 2.2264507513E+01, 4.0280309500E+00, 9.7019070410E-01],
	[3.6885000000E+04, 3.9808419912E+01, 5.6110943414E+00, 2.2274440974E+01, 4.0284704391E+00, 9.7020581045E-01],
	[3.6890000000E+04, 3.9817786014E+01, 5.6111303252E+00, 2.2284377518E+01, 4.0289097969E+00, 9.7022090846E-01],
	[3.6895000000E+04, 3.9827153050E+01, 5.6111663043E+00, 2.2294317147E+01, 4.0293490233E+00, 9.7023599813E-01],
	[3.6900000000E+04, 3.9836521021E+01, 5.6112022788E+00, 2.2304259861E+01, 4.0297881185E+00, 9.7025107946E-01],
	[3.6905000000E+04, 3.9845889924E+01, 5.6112382487E+00, 2.2314205661E+01, 4.0302270825E+00, 9.7026615247E-01],
	[3.6910000000E+04, 3.9855259762E+01, 5.6112742139E+00, 2.2324154547E+01, 4.0306659152E+00, 9.7028121715E-01],
	[3.6915000000E+04, 3.9864630533E+01, 5.6113101745E+00, 2.2334106519E+01, 4.0311046168E+00, 9.7029627351E-01],
	[3.6920000000E+04, 3.9874002238E+01, 5.6113461304E+00, 2.2344061579E+01, 4.0315431873E+00, 9.7031132156E-01],
	[3.6925000000E+04, 3.9883374877E+01, 5.6113820817E+00, 2.2354019727E+01, 4.0319816266E+00, 9.7032636131E-01],
	[3.6930000000E+04, 3.9892748449E+01, 5.6114180284E+00, 2.2363980962E+01, 4.0324199350E+00, 9.7034139274E-01],
	[3.6935000000E+04, 3.9902122955E+01, 5.6114539704E+00, 2.2373945287E+01, 4.0328581123E+00, 9.7035641588E-01],
	[3.6940000000E+04, 3.9911498394E+01, 5.6114899078E+00, 2.2383912701E+01, 4.0332961586E+00, 9.7037143073E-01],
	[3.6945000000E+04, 3.9920874767E+01, 5.6115258405E+00, 2.2393883205E+01, 4.0337340740E+00, 9.7038643728E-01],
	[3.6950000000E+04, 3.9930252073E+01, 5.6115617686E+00, 2.2403856799E+01, 4.0341718585E+00, 9.7040143555E-01],
	[3.6955000000E+04, 3.9939630313E+01, 5.6115976921E+00, 2.2413833485E+01, 4.0346095121E+00, 9.7041642555E-01],
	[3.6960000000E+04, 3.9949009486E+01, 5.6116336110E+00, 2.2423813261E+01, 4.0350470349E+00, 9.7043140726E-01],
	[3.6965000000E+04, 3.9958389592E+01, 5.6116695252E+00, 2.2433796130E+01, 4.0354844269E+00, 9.7044638071E-01],
	[3.6970000000E+04, 3.9967770632E+01, 5.6117054348E+00, 2.2443782092E+01, 4.0359216882E+00, 9.7046134590E-01],
	[3.6975000000E+04, 3.9977152605E+01, 5.6117413398E+00, 2.2453771147E+01, 4.0363588187E+00, 9.7047630282E-01],
	[3.6980000000E+04, 3.9986535511E+01, 5.6117772401E+00, 2.2463763295E+01, 4.0367958185E+00, 9.7049125149E-01],
	[3.6985000000E+04, 3.9995919351E+01, 5.6118131358E+00, 2.2473758538E+01, 4.0372326877E+00, 9.7050619191E-01],
	[3.6990000000E+04, 4.0005304123E+01, 5.6118490269E+00, 2.2483756875E+01, 4.0376694263E+00, 9.7052112408E-01],
	[3.6995000000E+04, 4.0014689829E+01, 5.6118849134E+00, 2.2493758308E+01, 4.0381060344E+00, 9.7053604802E-01],
	[3.7000000000E+04, 4.0024076468E+01, 5.6119207953E+00, 2.2503762836E+01, 4.0385425119E+00, 9.7055096371E-01],
	[3.7005000000E+04, 4.0033464040E+01, 5.6119566725E+00, 2.2513770461E+01, 4.0389788589E+00, 9.7056587118E-01],
	[3.7010000000E+04, 4.0042852545E+01, 5.6119925451E+00, 2.2523781183E+01, 4.0394150754E+00, 9.7058077042E-01],
	[3.7015000000E+04, 4.0052241983E+01, 5.6120284131E+00, 2.2533795003E+01, 4.0398511615E+00, 9.7059566145E-01],
	[3.7020000000E+04, 4.0061632354E+01, 5.6120642765E+00, 2.2543811920E+01, 4.0402871173E+00, 9.7061054425E-01],
	[3.7025000000E+04, 4.0071023659E+01, 5.6121001353E+00, 2.2553831936E+01, 4.0407229427E+00, 9.7062541885E-01],
	[3.7030000000E+04, 4.0080415896E+01, 5.6121359894E+00, 2.2563855051E+01, 4.0411586377E+00, 9.7064028524E-01],
	[3.7035000000E+04, 4.0089809065E+01, 5.6121718390E+00, 2.2573881266E+01, 4.0415942025E+00, 9.7065514342E-01],
	[3.7040000000E+04, 4.0099203168E+01, 5.6122076839E+00, 2.2583910580E+01, 4.0420296371E+00, 9.7066999342E-01],
	[3.7045000000E+04, 4.0108598204E+01, 5.6122435243E+00, 2.2593942996E+01, 4.0424649415E+00, 9.7068483522E-01],
	[3.7050000000E+04, 4.0117994172E+01, 5.6122793600E+00, 2.2603978513E+01, 4.0429001157E+00, 9.7069966883E-01],
	[3.7055000000E+04, 4.0127391073E+01, 5.6123151911E+00, 2.2614017131E+01, 4.0433351597E+00, 9.7071449426E-01],
	[3.7060000000E+04, 4.0136788907E+01, 5.6123510176E+00, 2.2624058852E+01, 4.0437700737E+00, 9.7072931152E-01],
	[3.7065000000E+04, 4.0146187674E+01, 5.6123868395E+00, 2.2634103676E+01, 4.0442048577E+00, 9.7074412060E-01],
	[3.7070000000E+04, 4.0155587373E+01, 5.6124226568E+00, 2.2644151603E+01, 4.0446395116E+00, 9.7075892152E-01],
	[3.7075000000E+04, 4.0164988005E+01, 5.6124584695E+00, 2.2654202634E+01, 4.0450740355E+00, 9.7077371427E-01],
	[3.7080000000E+04, 4.0174389569E+01, 5.6124942776E+00, 2.2664256770E+01, 4.0455084295E+00, 9.7078849887E-01],
	[3.7085000000E+04, 4.0183792066E+01, 5.6125300811E+00, 2.2674314010E+01, 4.0459426936E+00, 9.7080327531E-01],
	[3.7090000000E+04, 4.0193195496E+01, 5.6125658800E+00, 2.2684374356E+01, 4.0463768278E+00, 9.7081804361E-01],
	[3.7095000000E+04, 4.0202599858E+01, 5.6126016743E+00, 2.2694437809E+01, 4.0468108322E+00, 9.7083280376E-01],
	[3.7100000000E+04, 4.0212005152E+01, 5.6126374640E+00, 2.2704504367E+01, 4.0472447068E+00, 9.7084755578E-01],
	[3.7105000000E+04, 4.0221411379E+01, 5.6126732491E+00, 2.2714574034E+01, 4.0476784517E+00, 9.7086229966E-01],
	[3.7110000000E+04, 4.0230818538E+01, 5.6127090296E+00, 2.2724646807E+01, 4.0481120668E+00, 9.7087703542E-01],
	[3.7115000000E+04, 4.0240226630E+01, 5.6127448055E+00, 2.2734722689E+01, 4.0485455523E+00, 9.7089176305E-01],
	[3.7120000000E+04, 4.0249635654E+01, 5.6127805769E+00, 2.2744801680E+01, 4.0489789081E+00, 9.7090648256E-01],
	[3.7125000000E+04, 4.0259045610E+01, 5.6128163436E+00, 2.2754883781E+01, 4.0494121343E+00, 9.7092119396E-01],
	[3.7130000000E+04, 4.0268456498E+01, 5.6128521058E+00, 2.2764968991E+01, 4.0498452309E+00, 9.7093589725E-01],
	[3.7135000000E+04, 4.0277868319E+01, 5.6128878633E+00, 2.2775057311E+01, 4.0502781980E+00, 9.7095059244E-01],
	[3.7140000000E+04, 4.0287281072E+01, 5.6129236163E+00, 2.2785148743E+01, 4.0507110356E+00, 9.7096527952E-01],
	[3.7145000000E+04, 4.0296694757E+01, 5.6129593647E+00, 2.2795243286E+01, 4.0511437437E+00, 9.7097995852E-01],
	[3.7150000000E+04, 4.0306109374E+01, 5.6129951085E+00, 2.2805340941E+01, 4.0515763224E+00, 9.7099462942E-01],
	[3.7155000000E+04, 4.0315524924E+01, 5.6130308478E+00, 2.2815441708E+01, 4.0520087717E+00, 9.7100929224E-01],
	[3.7160000000E+04, 4.0324941405E+01, 5.6130665824E+00, 2.2825545589E+01, 4.0524410917E+00, 9.7102394698E-01],
	[3.7165000000E+04, 4.0334358818E+01, 5.6131023125E+00, 2.2835652583E+01, 4.0528732823E+00, 9.7103859365E-01],
	[3.7170000000E+04, 4.0343777164E+01, 5.6131380379E+00, 2.2845762692E+01, 4.0533053437E+00, 9.7105323224E-01],
	[3.7175000000E+04, 4.0353196441E+01, 5.6131737589E+00, 2.2855875915E+01, 4.0537372758E+00, 9.7106786277E-01],
	[3.7180000000E+04, 4.0362616650E+01, 5.6132094752E+00, 2.2865992254E+01, 4.0541690788E+00, 9.7108248524E-01],
	[3.7185000000E+04, 4.0372037791E+01, 5.6132451869E+00, 2.2876111709E+01, 4.0546007526E+00, 9.7109709965E-01],
	[3.7190000000E+04, 4.0381459864E+01, 5.6132808941E+00, 2.2886234279E+01, 4.0550322972E+00, 9.7111170601E-01],
	[3.7195000000E+04, 4.0390882869E+01, 5.6133165967E+00, 2.2896359967E+01, 4.0554637128E+00, 9.7112630433E-01],
	[3.7200000000E+04, 4.0400306806E+01, 5.6133522948E+00, 2.2906488772E+01, 4.0558949993E+00, 9.7114089461E-01],
	[3.7205000000E+04, 4.0409731674E+01, 5.6133879882E+00, 2.2916620695E+01, 4.0563261567E+00, 9.7115547685E-01],
	[3.7210000000E+04, 4.0419157474E+01, 5.6134236771E+00, 2.2926755737E+01, 4.0567571852E+00, 9.7117005105E-01],
	[3.7215000000E+04, 4.0428584206E+01, 5.6134593615E+00, 2.2936893898E+01, 4.0571880848E+00, 9.7118461724E-01],
	[3.7220000000E+04, 4.0438011870E+01, 5.6134950412E+00, 2.2947035178E+01, 4.0576188555E+00, 9.7119917540E-01],
	[3.7225000000E+04, 4.0447440465E+01, 5.6135307164E+00, 2.2957179579E+01, 4.0580494972E+00, 9.7121372554E-01],
	[3.7230000000E+04, 4.0456869992E+01, 5.6135663870E+00, 2.2967327100E+01, 4.0584800102E+00, 9.7122826767E-01],
	[3.7235000000E+04, 4.0466300450E+01, 5.6136020531E+00, 2.2977477742E+01, 4.0589103944E+00, 9.7124280179E-01],
	[3.7240000000E+04, 4.0475731840E+01, 5.6136377146E+00, 2.2987631507E+01, 4.0593406498E+00, 9.7125732791E-01],
	[3.7245000000E+04, 4.0485164161E+01, 5.6136733715E+00, 2.2997788393E+01, 4.0597707764E+00, 9.7127184604E-01],
	[3.7250000000E+04, 4.0494597414E+01, 5.6137090239E+00, 2.3007948403E+01, 4.0602007744E+00, 9.7128635617E-01],
	[3.7255000000E+04, 4.0504031598E+01, 5.6137446717E+00, 2.3018111535E+01, 4.0606306438E+00, 9.7130085831E-01],
	[3.7260000000E+04, 4.0513466714E+01, 5.6137803150E+00, 2.3028277792E+01, 4.0610603845E+00, 9.7131535247E-01],
	[3.7265000000E+04, 4.0522902761E+01, 5.6138159537E+00, 2.3038447173E+01, 4.0614899967E+00, 9.7132983865E-01],
	[3.7270000000E+04, 4.0532339739E+01, 5.6138515879E+00, 2.3048619679E+01, 4.0619194803E+00, 9.7134431685E-01],
	[3.7275000000E+04, 4.0541777648E+01, 5.6138872175E+00, 2.3058795311E+01, 4.0623488354E+00, 9.7135878709E-01],
	[3.7280000000E+04, 4.0551216489E+01, 5.6139228425E+00, 2.3068974069E+01, 4.0627780621E+00, 9.7137324936E-01],
	[3.7285000000E+04, 4.0560656261E+01, 5.6139584630E+00, 2.3079155953E+01, 4.0632071603E+00, 9.7138770368E-01],
	[3.7290000000E+04, 4.0570096965E+01, 5.6139940790E+00, 2.3089340965E+01, 4.0636361302E+00, 9.7140215004E-01],
	[3.7295000000E+04, 4.0579538599E+01, 5.6140296903E+00, 2.3099529104E+01, 4.0640649717E+00, 9.7141658845E-01],
	[3.7300000000E+04, 4.0588981165E+01, 5.6140652972E+00, 2.3109720372E+01, 4.0644936849E+00, 9.7143101891E-01],
	[3.7305000000E+04, 4.0598424661E+01, 5.6141008995E+00, 2.3119914768E+01, 4.0649222698E+00, 9.7144544144E-01],
	[3.7310000000E+04, 4.0607869089E+01, 5.6141364972E+00, 2.3130112294E+01, 4.0653507264E+00, 9.7145985603E-01],
	[3.7315000000E+04, 4.0617314448E+01, 5.6141720905E+00, 2.3140312950E+01, 4.0657790549E+00, 9.7147426269E-01],
	[3.7320000000E+04, 4.0626760738E+01, 5.6142076791E+00, 2.3150516736E+01, 4.0662072552E+00, 9.7148866142E-01],
	[3.7325000000E+04, 4.0636207958E+01, 5.6142432632E+00, 2.3160723653E+01, 4.0666353274E+00, 9.7150305223E-01],
	[3.7330000000E+04, 4.0645656110E+01, 5.6142788428E+00, 2.3170933701E+01, 4.0670632714E+00, 9.7151743513E-01],
	[3.7335000000E+04, 4.0655105193E+01, 5.6143144179E+00, 2.3181146882E+01, 4.0674910875E+00, 9.7153181011E-01],
	[3.7340000000E+04, 4.0664555206E+01, 5.6143499884E+00, 2.3191363195E+01, 4.0679187754E+00, 9.7154617719E-01],
	[3.7345000000E+04, 4.0674006150E+01, 5.6143855543E+00, 2.3201582641E+01, 4.0683463355E+00, 9.7156053637E-01],
	[3.7350000000E+04, 4.0683458026E+01, 5.6144211158E+00, 2.3211805221E+01, 4.0687737675E+00, 9.7157488765E-01],
	[3.7355000000E+04, 4.0692910831E+01, 5.6144566727E+00, 2.3222030935E+01, 4.0692010717E+00, 9.7158923103E-01],
	[3.7360000000E+04, 4.0702364568E+01, 5.6144922250E+00, 2.3232259784E+01, 4.0696282480E+00, 9.7160356653E-01],
	[3.7365000000E+04, 4.0711819235E+01, 5.6145277729E+00, 2.3242491768E+01, 4.0700552964E+00, 9.7161789415E-01],
	[3.7370000000E+04, 4.0721274833E+01, 5.6145633162E+00, 2.3252726888E+01, 4.0704822171E+00, 9.7163221389E-01],
	[3.7375000000E+04, 4.0730731362E+01, 5.6145988549E+00, 2.3262965145E+01, 4.0709090100E+00, 9.7164652575E-01],
	[3.7380000000E+04, 4.0740188821E+01, 5.6146343892E+00, 2.3273206538E+01, 4.0713356752E+00, 9.7166082975E-01],
	[3.7385000000E+04, 4.0749647211E+01, 5.6146699189E+00, 2.3283451069E+01, 4.0717622127E+00, 9.7167512588E-01],
	[3.7390000000E+04, 4.0759106531E+01, 5.6147054441E+00, 2.3293698737E+01, 4.0721886225E+00, 9.7168941416E-01],
	[3.7395000000E+04, 4.0768566782E+01, 5.6147409647E+00, 2.3303949545E+01, 4.0726149047E+00, 9.7170369458E-01],
	[3.7400000000E+04, 4.0778027964E+01, 5.6147764808E+00, 2.3314203491E+01, 4.0730410594E+00, 9.7171796715E-01],
	[3.7405000000E+04, 4.0787507644E+01, 5.6148138262E+00, 2.3324460577E+01, 4.0734682268E+00, 9.7173223187E-01],
	[3.7410000000E+04, 4.0796993641E+01, 5.6148517283E+00, 2.3334720803E+01, 4.0738956163E+00, 9.7174648876E-01],
	[3.7415000000E+04, 4.0806480577E+01, 5.6148896256E+00, 2.3344984170E+01, 4.0743228786E+00, 9.7176073781E-01],
	[3.7420000000E+04, 4.0815968450E+01, 5.6149275180E+00, 2.3355250678E+01, 4.0747500138E+00, 9.7177497903E-01],
	[3.7425000000E+04, 4.0825457262E+01, 5.6149654057E+00, 2.3365520328E+01, 4.0751770219E+00, 9.7178921243E-01],
	[3.7430000000E+04, 4.0834947011E+01, 5.6150032886E+00, 2.3375793120E+01, 4.0756039029E+00, 9.7180343800E-01],
	[3.7435000000E+04, 4.0844437698E+01, 5.6150411666E+00, 2.3386069055E+01, 4.0760306569E+00, 9.7181765576E-01],
	[3.7440000000E+04, 4.0853929323E+01, 5.6150790399E+00, 2.3396348133E+01, 4.0764572840E+00, 9.7183186570E-01],
	[3.7445000000E+04, 4.0863421885E+01, 5.6151169083E+00, 2.3406630355E+01, 4.0768837840E+00, 9.7184606784E-01],
	[3.7450000000E+04, 4.0872915385E+01, 5.6151547720E+00, 2.3416915722E+01, 4.0773101572E+00, 9.7186026218E-01],
	[3.7455000000E+04, 4.0882409823E+01, 5.6151926308E+00, 2.3427204234E+01, 4.0777364035E+00, 9.7187444872E-01],
	[3.7460000000E+04, 4.0891905199E+01, 5.6152304849E+00, 2.3437495892E+01, 4.0781625230E+00, 9.7188862747E-01],
	[3.7465000000E+04, 4.0901401512E+01, 5.6152683342E+00, 2.3447790695E+01, 4.0785885157E+00, 9.7190279843E-01],
	[3.7470000000E+04, 4.0910898763E+01, 5.6153061786E+00, 2.3458088645E+01, 4.0790143816E+00, 9.7191696161E-01],
	[3.7475000000E+04, 4.0920396952E+01, 5.6153440183E+00, 2.3468389743E+01, 4.0794401208E+00, 9.7193111701E-01],
	[3.7480000000E+04, 4.0929896078E+01, 5.6153818532E+00, 2.3478693988E+01, 4.0798657334E+00, 9.7194526463E-01],
	[3.7485000000E+04, 4.0939396142E+01, 5.6154196832E+00, 2.3489001381E+01, 4.0802912192E+00, 9.7195940449E-01],
	[3.7490000000E+04, 4.0948897143E+01, 5.6154575085E+00, 2.3499311924E+01, 4.0807165785E+00, 9.7197353658E-01],
	[3.7495000000E+04, 4.0958399081E+01, 5.6154953290E+00, 2.3509625615E+01, 4.0811418112E+00, 9.7198766092E-01],
	[3.7500000000E+04, 4.0967901957E+01, 5.6155331447E+00, 2.3519942457E+01, 4.0815669173E+00, 9.7200177750E-01],
	[3.7505000000E+04, 4.0977405771E+01, 5.6155709557E+00, 2.3530262449E+01, 4.0819918969E+00, 9.7201588633E-01],
	[3.7510000000E+04, 4.0986910521E+01, 5.6156087618E+00, 2.3540585592E+01, 4.0824167501E+00, 9.7202998741E-01],
	[3.7515000000E+04, 4.0996416209E+01, 5.6156465632E+00, 2.3550911886E+01, 4.0828414768E+00, 9.7204408075E-01],
	[3.7520000000E+04, 4.1005922834E+01, 5.6156843597E+00, 2.3561241333E+01, 4.0832660772E+00, 9.7205816636E-01],
	[3.7525000000E+04, 4.1015430397E+01, 5.6157221515E+00, 2.3571573932E+01, 4.0836905512E+00, 9.7207224424E-01],
	[3.7530000000E+04, 4.1024938897E+01, 5.6157599385E+00, 2.3581909684E+01, 4.0841148988E+00, 9.7208631439E-01],
	[3.7535000000E+04, 4.1034448334E+01, 5.6157977208E+00, 2.3592248590E+01, 4.0845391202E+00, 9.7210037682E-01],
	[3.7540000000E+04, 4.1043958708E+01, 5.6158354982E+00, 2.3602590650E+01, 4.0849632154E+00, 9.7211443153E-01],
	[3.7545000000E+04, 4.1053470019E+01, 5.6158732709E+00, 2.3612935865E+01, 4.0853871843E+00, 9.7212847853E-01],
	[3.7550000000E+04, 4.1062982267E+01, 5.6159110388E+00, 2.3623284236E+01, 4.0858110271E+00, 9.7214251782E-01],
	[3.7555000000E+04, 4.1072495453E+01, 5.6159488019E+00, 2.3633635762E+01, 4.0862347437E+00, 9.7215654941E-01],
	[3.7560000000E+04, 4.1082009575E+01, 5.6159865603E+00, 2.3643990444E+01, 4.0866583342E+00, 9.7217057330E-01],
	[3.7565000000E+04, 4.1091524634E+01, 5.6160243138E+00, 2.3654348284E+01, 4.0870817987E+00, 9.7218458950E-01],
	[3.7570000000E+04, 4.1101040631E+01, 5.6160620626E+00, 2.3664709281E+01, 4.0875051371E+00, 9.7219859801E-01],
	[3.7575000000E+04, 4.1110557564E+01, 5.6160998067E+00, 2.3675073436E+01, 4.0879283495E+00, 9.7221259884E-01],
	[3.7580000000E+04, 4.1120075434E+01, 5.6161375459E+00, 2.3685440750E+01, 4.0883514360E+00, 9.7222659198E-01],
	[3.7585000000E+04, 4.1129594241E+01, 5.6161752804E+00, 2.3695811222E+01, 4.0887743966E+00, 9.7224057745E-01],
	[3.7590000000E+04, 4.1139113985E+01, 5.6162130102E+00, 2.3706184855E+01, 4.0891972313E+00, 9.7225455525E-01],
	[3.7595000000E+04, 4.1148634666E+01, 5.6162507351E+00, 2.3716561647E+01, 4.0896199401E+00, 9.7226852538E-01],
	[3.7600000000E+04, 4.1158156283E+01, 5.6162884554E+00, 2.3726941601E+01, 4.0900425232E+00, 9.7228248785E-01],
	[3.7605000000E+04, 4.1167678837E+01, 5.6163261708E+00, 2.3737324715E+01, 4.0904649804E+00, 9.7229644265E-01],
	[3.7610000000E+04, 4.1177202328E+01, 5.6163638815E+00, 2.3747710992E+01, 4.0908873120E+00, 9.7231038980E-01],
	[3.7615000000E+04, 4.1186726756E+01, 5.6164015874E+00, 2.3758100431E+01, 4.0913095178E+00, 9.7232432930E-01],
	[3.7620000000E+04, 4.1196252120E+01, 5.6164392886E+00, 2.3768493032E+01, 4.0917315980E+00, 9.7233826116E-01],
	[3.7625000000E+04, 4.1205778421E+01, 5.6164769850E+00, 2.3778888798E+01, 4.0921535526E+00, 9.7235218537E-01],
	[3.7630000000E+04, 4.1215305658E+01, 5.6165146766E+00, 2.3789287727E+01, 4.0925753815E+00, 9.7236610193E-01],
	[3.7635000000E+04, 4.1224833832E+01, 5.6165523635E+00, 2.3799689820E+01, 4.0929970850E+00, 9.7238001087E-01],
	[3.7640000000E+04, 4.1234362942E+01, 5.6165900457E+00, 2.3810095079E+01, 4.0934186629E+00, 9.7239391217E-01],
	[3.7645000000E+04, 4.1243892989E+01, 5.6166277230E+00, 2.3820503503E+01, 4.0938401153E+00, 9.7240780585E-01],
	[3.7650000000E+04, 4.1253423972E+01, 5.6166653957E+00, 2.3830915094E+01, 4.0942614423E+00, 9.7242169190E-01],
	[3.7655000000E+04, 4.1262955892E+01, 5.6167030636E+00, 2.3841329851E+01, 4.0946826439E+00, 9.7243557034E-01],
	[3.7660000000E+04, 4.1272488748E+01, 5.6167407267E+00, 2.3851747776E+01, 4.0951037201E+00, 9.7244944116E-01],
	[3.7665000000E+04, 4.1282022541E+01, 5.6167783851E+00, 2.3862168868E+01, 4.0955246710E+00, 9.7246330437E-01],
	[3.7670000000E+04, 4.1291557269E+01, 5.6168160387E+00, 2.3872593129E+01, 4.0959454966E+00, 9.7247715998E-01],
	[3.7675000000E+04, 4.1301092934E+01, 5.6168536876E+00, 2.3883020558E+01, 4.0963661969E+00, 9.7249100798E-01],
	[3.7680000000E+04, 4.1310629536E+01, 5.6168913318E+00, 2.3893451157E+01, 4.0967867720E+00, 9.7250484838E-01],
	[3.7685000000E+04, 4.1320167073E+01, 5.6169289712E+00, 2.3903884926E+01, 4.0972072219E+00, 9.7251868119E-01],
	[3.7690000000E+04, 4.1329705547E+01, 5.6169666059E+00, 2.3914321865E+01, 4.0976275467E+00, 9.7253250641E-01],
	[3.7695000000E+04, 4.1339244957E+01, 5.6170042358E+00, 2.3924761975E+01, 4.0980477464E+00, 9.7254632404E-01],
	[3.7700000000E+04, 4.1348785303E+01, 5.6170418610E+00, 2.3935205257E+01, 4.0984678210E+00, 9.7256013410E-01],
	[3.7705000000E+04, 4.1358326585E+01, 5.6170794815E+00, 2.3945651711E+01, 4.0988877705E+00, 9.7257393657E-01],
	[3.7710000000E+04, 4.1367868803E+01, 5.6171170972E+00, 2.3956101338E+01, 4.0993075951E+00, 9.7258773147E-01],
	[3.7715000000E+04, 4.1377411957E+01, 5.6171547082E+00, 2.3966554138E+01, 4.0997272947E+00, 9.7260151880E-01],
	[3.7720000000E+04, 4.1386956047E+01, 5.6171923144E+00, 2.3977010112E+01, 4.1001468694E+00, 9.7261529857E-01],
	[3.7725000000E+04, 4.1396501073E+01, 5.6172299159E+00, 2.3987469260E+01, 4.1005663191E+00, 9.7262907078E-01],
	[3.7730000000E+04, 4.1406047035E+01, 5.6172675127E+00, 2.3997931583E+01, 4.1009856441E+00, 9.7264283542E-01],
	[3.7735000000E+04, 4.1415593933E+01, 5.6173051048E+00, 2.4008397081E+01, 4.1014048442E+00, 9.7265659252E-01],
	[3.7740000000E+04, 4.1425141767E+01, 5.6173426921E+00, 2.4018865755E+01, 4.1018239195E+00, 9.7267034206E-01],
	[3.7745000000E+04, 4.1434690536E+01, 5.6173802747E+00, 2.4029337606E+01, 4.1022428700E+00, 9.7268408407E-01],
	[3.7750000000E+04, 4.1444240241E+01, 5.6174178525E+00, 2.4039812633E+01, 4.1026616959E+00, 9.7269781853E-01],
	[3.7755000000E+04, 4.1453790883E+01, 5.6174554257E+00, 2.4050290838E+01, 4.1030803971E+00, 9.7271154545E-01],
	[3.7760000000E+04, 4.1463342459E+01, 5.6174929941E+00, 2.4060772222E+01, 4.1034989737E+00, 9.7272526484E-01],
	[3.7765000000E+04, 4.1472894972E+01, 5.6175305578E+00, 2.4071256784E+01, 4.1039174256E+00, 9.7273897670E-01],
	[3.7770000000E+04, 4.1482448420E+01, 5.6175681168E+00, 2.4081744525E+01, 4.1043357530E+00, 9.7275268104E-01],
	[3.7775000000E+04, 4.1492002804E+01, 5.6176056710E+00, 2.4092235445E+01, 4.1047539559E+00, 9.7276637786E-01],
	[3.7780000000E+04, 4.1501558123E+01, 5.6176432206E+00, 2.4102729547E+01, 4.1051720343E+00, 9.7278006716E-01],
	[3.7785000000E+04, 4.1511114379E+01, 5.6176807654E+00, 2.4113226828E+01, 4.1055899882E+00, 9.7279374895E-01],
	[3.7790000000E+04, 4.1520671569E+01, 5.6177183055E+00, 2.4123727292E+01, 4.1060078177E+00, 9.7280742324E-01],
	[3.7795000000E+04, 4.1530229695E+01, 5.6177558409E+00, 2.4134230937E+01, 4.1064255228E+00, 9.7282109001E-01],
	[3.7800000000E+04, 4.1539788757E+01, 5.6177933715E+00, 2.4144737764E+01, 4.1068431036E+00, 9.7283474929E-01],
	[3.7805000000E+04, 4.1549348754E+01, 5.6178308975E+00, 2.4155247775E+01, 4.1072605601E+00, 9.7284840108E-01],
	[3.7810000000E+04, 4.1558909686E+01, 5.6178684187E+00, 2.4165760969E+01, 4.1076778923E+00, 9.7286204537E-01],
	[3.7815000000E+04, 4.1568471554E+01, 5.6179059353E+00, 2.4176277347E+01, 4.1080951003E+00, 9.7287568217E-01],
	[3.7820000000E+04, 4.1578034357E+01, 5.6179434471E+00, 2.4186796910E+01, 4.1085121841E+00, 9.7288931149E-01],
	[3.7825000000E+04, 4.1587598095E+01, 5.6179809542E+00, 2.4197319657E+01, 4.1089291437E+00, 9.7290293333E-01],
	[3.7830000000E+04, 4.1597162769E+01, 5.6180184566E+00, 2.4207845591E+01, 4.1093459792E+00, 9.7291654770E-01],
	[3.7835000000E+04, 4.1606728378E+01, 5.6180559543E+00, 2.4218374711E+01, 4.1097626906E+00, 9.7293015459E-01],
	[3.7840000000E+04, 4.1616294922E+01, 5.6180934473E+00, 2.4228907017E+01, 4.1101792780E+00, 9.7294375402E-01],
	[3.7845000000E+04, 4.1625862402E+01, 5.6181309356E+00, 2.4239442511E+01, 4.1105957413E+00, 9.7295734599E-01],
	[3.7850000000E+04, 4.1635430816E+01, 5.6181684192E+00, 2.4249981193E+01, 4.1110120807E+00, 9.7297093049E-01],
	[3.7855000000E+04, 4.1645000166E+01, 5.6182058981E+00, 2.4260523063E+01, 4.1114282961E+00, 9.7298450755E-01],
	[3.7860000000E+04, 4.1654570450E+01, 5.6182433723E+00, 2.4271068122E+01, 4.1118443877E+00, 9.7299807715E-01],
	[3.7865000000E+04, 4.1664141670E+01, 5.6182808418E+00, 2.4281616371E+01, 4.1122603553E+00, 9.7301163930E-01],
	[3.7870000000E+04, 4.1673713825E+01, 5.6183183066E+00, 2.4292167809E+01, 4.1126761992E+00, 9.7302519402E-01],
	[3.7875000000E+04, 4.1683286915E+01, 5.6183557667E+00, 2.4302722439E+01, 4.1130919192E+00, 9.7303874129E-01],
	[3.7880000000E+04, 4.1692860939E+01, 5.6183932221E+00, 2.4313280259E+01, 4.1135075155E+00, 9.7305228113E-01],
	[3.7885000000E+04, 4.1702435899E+01, 5.6184306728E+00, 2.4323841271E+01, 4.1139229880E+00, 9.7306581354E-01],
	[3.7890000000E+04, 4.1712011794E+01, 5.6184681188E+00, 2.4334405475E+01, 4.1143383369E+00, 9.7307933852E-01],
	[3.7895000000E+04, 4.1721588623E+01, 5.6185055601E+00, 2.4344972872E+01, 4.1147535621E+00, 9.7309285609E-01],
	[3.7900000000E+04, 4.1731166387E+01, 5.6185429967E+00, 2.4355543462E+01, 4.1151686637E+00, 9.7310636623E-01],
	[3.7905000000E+04, 4.1740745086E+01, 5.6185804287E+00, 2.4366117247E+01, 4.1155836417E+00, 9.7311986896E-01],
	[3.7910000000E+04, 4.1750324720E+01, 5.6186178559E+00, 2.4376694225E+01, 4.1159984962E+00, 9.7313336428E-01],
	[3.7915000000E+04, 4.1759905289E+01, 5.6186552785E+00, 2.4387274398E+01, 4.1164132272E+00, 9.7314685220E-01],
	[3.7920000000E+04, 4.1769486792E+01, 5.6186926964E+00, 2.4397857767E+01, 4.1168278347E+00, 9.7316033271E-01],
	[3.7925000000E+04, 4.1779069230E+01, 5.6187301096E+00, 2.4408444332E+01, 4.1172423188E+00, 9.7317380583E-01],
	[3.7930000000E+04, 4.1788652603E+01, 5.6187675181E+00, 2.4419034094E+01, 4.1176566795E+00, 9.7318727155E-01],
	[3.7935000000E+04, 4.1798236910E+01, 5.6188049219E+00, 2.4429627052E+01, 4.1180709169E+00, 9.7320072989E-01],
	[3.7940000000E+04, 4.1807822151E+01, 5.6188423211E+00, 2.4440223208E+01, 4.1184850309E+00, 9.7321418083E-01],
	[3.7945000000E+04, 4.1817408328E+01, 5.6188797155E+00, 2.4450822563E+01, 4.1188990216E+00, 9.7322762440E-01],
	[3.7950000000E+04, 4.1826995439E+01, 5.6189171053E+00, 2.4461425116E+01, 4.1193128891E+00, 9.7324106059E-01],
	[3.7955000000E+04, 4.1836583484E+01, 5.6189544905E+00, 2.4472030868E+01, 4.1197266334E+00, 9.7325448941E-01],
	[3.7960000000E+04, 4.1846172464E+01, 5.6189918709E+00, 2.4482639820E+01, 4.1201402545E+00, 9.7326791086E-01],
	[3.7965000000E+04, 4.1855762378E+01, 5.6190292467E+00, 2.4493251973E+01, 4.1205537525E+00, 9.7328132495E-01],
	[3.7970000000E+04, 4.1865353226E+01, 5.6190666178E+00, 2.4503867326E+01, 4.1209671273E+00, 9.7329473167E-01],
	[3.7975000000E+04, 4.1874945009E+01, 5.6191039842E+00, 2.4514485881E+01, 4.1213803791E+00, 9.7330813104E-01],
	[3.7980000000E+04, 4.1884537726E+01, 5.6191413459E+00, 2.4525107638E+01, 4.1217935079E+00, 9.7332152305E-01],
	[3.7985000000E+04, 4.1894131378E+01, 5.6191787030E+00, 2.4535732598E+01, 4.1222065137E+00, 9.7333490772E-01],
	[3.7990000000E+04, 4.1903725963E+01, 5.6192160554E+00, 2.4546360760E+01, 4.1226193965E+00, 9.7334828504E-01],
	[3.7995000000E+04, 4.1913321483E+01, 5.6192534032E+00, 2.4556992126E+01, 4.1230321564E+00, 9.7336165503E-01],
	[3.8000000000E+04, 4.1922917937E+01, 5.6192907462E+00, 2.4567626696E+01, 4.1234447934E+00, 9.7337501767E-01],
	[3.8005000000E+04, 4.1932523159E+01, 5.6193288903E+00, 2.4578264471E+01, 4.1238578173E+00, 9.7338837299E-01],
	[3.8010000000E+04, 4.1942144260E+01, 5.6193685662E+00, 2.4588905452E+01, 4.1242716906E+00, 9.7340172098E-01],
	[3.8015000000E+04, 4.1951766303E+01, 5.6194082370E+00, 2.4599549638E+01, 4.1246854413E+00, 9.7341506164E-01],
	[3.8020000000E+04, 4.1961389287E+01, 5.6194479030E+00, 2.4610197030E+01, 4.1250990697E+00, 9.7342839498E-01],
	[3.8025000000E+04, 4.1971013212E+01, 5.6194875640E+00, 2.4620847629E+01, 4.1255125756E+00, 9.7344172101E-01],
	[3.8030000000E+04, 4.1980638079E+01, 5.6195272201E+00, 2.4631501436E+01, 4.1259259591E+00, 9.7345503973E-01],
	[3.8035000000E+04, 4.1990263887E+01, 5.6195668712E+00, 2.4642158451E+01, 4.1263392203E+00, 9.7346835113E-01],
	[3.8040000000E+04, 4.1999890637E+01, 5.6196065174E+00, 2.4652818674E+01, 4.1267523591E+00, 9.7348165524E-01],
	[3.8045000000E+04, 4.2009518328E+01, 5.6196461587E+00, 2.4663482106E+01, 4.1271653757E+00, 9.7349495205E-01],
	[3.8050000000E+04, 4.2019146960E+01, 5.6196857950E+00, 2.4674148748E+01, 4.1275782700E+00, 9.7350824156E-01],
	[3.8055000000E+04, 4.2028776534E+01, 5.6197254264E+00, 2.4684818600E+01, 4.1279910422E+00, 9.7352152378E-01],
	[3.8060000000E+04, 4.2038407049E+01, 5.6197650529E+00, 2.4695491663E+01, 4.1284036922E+00, 9.7353479871E-01],
	[3.8065000000E+04, 4.2048038505E+01, 5.6198046745E+00, 2.4706167936E+01, 4.1288162200E+00, 9.7354806636E-01],
	[3.8070000000E+04, 4.2057670902E+01, 5.6198442911E+00, 2.4716847422E+01, 4.1292286258E+00, 9.7356132673E-01],
	[3.8075000000E+04, 4.2067304240E+01, 5.6198839029E+00, 2.4727530120E+01, 4.1296409095E+00, 9.7357457982E-01],
	[3.8080000000E+04, 4.2076938520E+01, 5.6199235096E+00, 2.4738216031E+01, 4.1300530711E+00, 9.7358782565E-01],
	[3.8085000000E+04, 4.2086573740E+01, 5.6199631115E+00, 2.4748905155E+01, 4.1304651108E+00, 9.7360106421E-01],
	[3.8090000000E+04, 4.2096209902E+01, 5.6200027085E+00, 2.4759597493E+01, 4.1308770285E+00, 9.7361429550E-01],
	[3.8095000000E+04, 4.2105847005E+01, 5.6200423005E+00, 2.4770293046E+01, 4.1312888244E+00, 9.7362751954E-01],
	[3.8100000000E+04, 4.2115485048E+01, 5.6200818876E+00, 2.4780991814E+01, 4.1317004983E+00, 9.7364073632E-01],
	[3.8105000000E+04, 4.2125124033E+01, 5.6201214698E+00, 2.4791693797E+01, 4.1321120504E+00, 9.7365394586E-01],
	[3.8110000000E+04, 4.2134763959E+01, 5.6201610471E+00, 2.4802398997E+01, 4.1325234807E+00, 9.7366714814E-01],
	[3.8115000000E+04, 4.2144404825E+01, 5.6202006195E+00, 2.4813107413E+01, 4.1329347892E+00, 9.7368034319E-01],
	[3.8120000000E+04, 4.2154046633E+01, 5.6202401869E+00, 2.4823819046E+01, 4.1333459760E+00, 9.7369353099E-01],
	[3.8125000000E+04, 4.2163689381E+01, 5.6202797495E+00, 2.4834533897E+01, 4.1337570411E+00, 9.7370671156E-01],
	[3.8130000000E+04, 4.2173333070E+01, 5.6203193071E+00, 2.4845251967E+01, 4.1341679845E+00, 9.7371988491E-01],
	[3.8135000000E+04, 4.2182977700E+01, 5.6203588599E+00, 2.4855973255E+01, 4.1345788064E+00, 9.7373305102E-01],
	[3.8140000000E+04, 4.2192623270E+01, 5.6203984077E+00, 2.4866697763E+01, 4.1349895066E+00, 9.7374620991E-01],
	[3.8145000000E+04, 4.2202269781E+01, 5.6204379506E+00, 2.4877425490E+01, 4.1354000853E+00, 9.7375936159E-01],
	[3.8150000000E+04, 4.2211917233E+01, 5.6204774886E+00, 2.4888156438E+01, 4.1358105424E+00, 9.7377250605E-01],
	[3.8155000000E+04, 4.2221565626E+01, 5.6205170217E+00, 2.4898890608E+01, 4.1362208781E+00, 9.7378564330E-01],
	[3.8160000000E+04, 4.2231214959E+01, 5.6205565499E+00, 2.4909627998E+01, 4.1366310923E+00, 9.7379877335E-01],
	[3.8165000000E+04, 4.2240865233E+01, 5.6205960732E+00, 2.4920368611E+01, 4.1370411851E+00, 9.7381189620E-01],
	[3.8170000000E+04, 4.2250516447E+01, 5.6206355916E+00, 2.4931112447E+01, 4.1374511566E+00, 9.7382501184E-01],
	[3.8175000000E+04, 4.2260168602E+01, 5.6206751052E+00, 2.4941859505E+01, 4.1378610067E+00, 9.7383812030E-01],
	[3.8180000000E+04, 4.2269821697E+01, 5.6207146138E+00, 2.4952609788E+01, 4.1382707355E+00, 9.7385122156E-01],
	[3.8185000000E+04, 4.2279475733E+01, 5.6207541175E+00, 2.4963363294E+01, 4.1386803431E+00, 9.7386431564E-01],
	[3.8190000000E+04, 4.2289130709E+01, 5.6207936163E+00, 2.4974120026E+01, 4.1390898294E+00, 9.7387740254E-01],
	[3.8195000000E+04, 4.2298786626E+01, 5.6208331102E+00, 2.4984879983E+01, 4.1394991945E+00, 9.7389048226E-01],
	[3.8200000000E+04, 4.2308443483E+01, 5.6208725993E+00, 2.4995643166E+01, 4.1399084385E+00, 9.7390355481E-01],
	[3.8205000000E+04, 4.2318101280E+01, 5.6209120834E+00, 2.5006409575E+01, 4.1403175614E+00, 9.7391662019E-01],
	[3.8210000000E+04, 4.2327760018E+01, 5.6209515627E+00, 2.5017179211E+01, 4.1407265632E+00, 9.7392967840E-01],
	[3.8215000000E+04, 4.2337419696E+01, 5.6209910370E+00, 2.5027952075E+01, 4.1411354439E+00, 9.7394272946E-01],
	[3.8220000000E+04, 4.2347080314E+01, 5.6210305065E+00, 2.5038728167E+01, 4.1415442036E+00, 9.7395577335E-01],
	[3.8225000000E+04, 4.2356741873E+01, 5.6210699711E+00, 2.5049507488E+01, 4.1419528424E+00, 9.7396881010E-01],
	[3.8230000000E+04, 4.2366404371E+01, 5.6211094308E+00, 2.5060290038E+01, 4.1423613602E+00, 9.7398183969E-01],
	[3.8235000000E+04, 4.2376067810E+01, 5.6211488856E+00, 2.5071075817E+01, 4.1427697571E+00, 9.7399486214E-01],
	[3.8240000000E+04, 4.2385732189E+01, 5.6211883356E+00, 2.5081864827E+01, 4.1431780332E+00, 9.7400787745E-01],
	[3.8245000000E+04, 4.2395397507E+01, 5.6212277806E+00, 2.5092657068E+01, 4.1435861884E+00, 9.7402088562E-01],
	[3.8250000000E+04, 4.2405063766E+01, 5.6212672208E+00, 2.5103452540E+01, 4.1439942228E+00, 9.7403388666E-01],
	[3.8255000000E+04, 4.2414730965E+01, 5.6213066561E+00, 2.5114251244E+01, 4.1444021365E+00, 9.7404688058E-01],
	[3.8260000000E+04, 4.2424399104E+01, 5.6213460865E+00, 2.5125053181E+01, 4.1448099294E+00, 9.7405986736E-01],
	[3.8265000000E+04, 4.2434068183E+01, 5.6213855121E+00, 2.5135858350E+01, 4.1452176017E+00, 9.7407284703E-01],
	[3.8270000000E+04, 4.2443738202E+01, 5.6214249327E+00, 2.5146666753E+01, 4.1456251533E+00, 9.7408581958E-01],
	[3.8275000000E+04, 4.2453409161E+01, 5.6214643485E+00, 2.5157478390E+01, 4.1460325843E+00, 9.7409878502E-01],
	[3.8280000000E+04, 4.2463081059E+01, 5.6215037595E+00, 2.5168293262E+01, 4.1464398947E+00, 9.7411174335E-01],
	[3.8285000000E+04, 4.2472753898E+01, 5.6215431655E+00, 2.5179111369E+01, 4.1468470845E+00, 9.7412469457E-01],
	[3.8290000000E+04, 4.2482427676E+01, 5.6215825667E+00, 2.5189932712E+01, 4.1472541539E+00, 9.7413763870E-01],
	[3.8295000000E+04, 4.2492102394E+01, 5.6216219630E+00, 2.5200757290E+01, 4.1476611028E+00, 9.7415057573E-01],
	[3.8300000000E+04, 4.2501778051E+01, 5.6216613545E+00, 2.5211585106E+01, 4.1480679313E+00, 9.7416350567E-01],
	[3.8305000000E+04, 4.2511454649E+01, 5.6217007411E+00, 2.5222416159E+01, 4.1484746394E+00, 9.7417642852E-01],
	[3.8310000000E+04, 4.2521132186E+01, 5.6217401228E+00, 2.5233250450E+01, 4.1488812271E+00, 9.7418934428E-01],
	[3.8315000000E+04, 4.2530810663E+01, 5.6217794996E+00, 2.5244087980E+01, 4.1492876944E+00, 9.7420225297E-01],
	[3.8320000000E+04, 4.2540490079E+01, 5.6218188716E+00, 2.5254928748E+01, 4.1496940415E+00, 9.7421515458E-01],
	[3.8325000000E+04, 4.2550170435E+01, 5.6218582388E+00, 2.5265772756E+01, 4.1501002684E+00, 9.7422804912E-01],
	[3.8330000000E+04, 4.2559851730E+01, 5.6218976010E+00, 2.5276620005E+01, 4.1505063750E+00, 9.7424093659E-01],
	[3.8335000000E+04, 4.2569533965E+01, 5.6219369584E+00, 2.5287470493E+01, 4.1509123615E+00, 9.7425381699E-01],
	[3.8340000000E+04, 4.2579217140E+01, 5.6219763110E+00, 2.5298324223E+01, 4.1513182278E+00, 9.7426669034E-01],
	[3.8345000000E+04, 4.2588901254E+01, 5.6220156587E+00, 2.5309181195E+01, 4.1517239739E+00, 9.7427955663E-01],
	[3.8350000000E+04, 4.2598586307E+01, 5.6220550015E+00, 2.5320041409E+01, 4.1521296001E+00, 9.7429241587E-01],
	[3.8355000000E+04, 4.2608272300E+01, 5.6220943395E+00, 2.5330904866E+01, 4.1525351061E+00, 9.7430526806E-01],
	[3.8360000000E+04, 4.2617959232E+01, 5.6221336727E+00, 2.5341771566E+01, 4.1529404922E+00, 9.7431811321E-01],
	[3.8365000000E+04, 4.2627647103E+01, 5.6221730010E+00, 2.5352641510E+01, 4.1533457583E+00, 9.7433095132E-01],
	[3.8370000000E+04, 4.2637335914E+01, 5.6222123244E+00, 2.5363514698E+01, 4.1537509045E+00, 9.7434378240E-01],
	[3.8375000000E+04, 4.2647025664E+01, 5.6222516430E+00, 2.5374391132E+01, 4.1541559308E+00, 9.7435660644E-01],
	[3.8380000000E+04, 4.2656716353E+01, 5.6222909567E+00, 2.5385270811E+01, 4.1545608373E+00, 9.7436942345E-01],
	[3.8385000000E+04, 4.2666407981E+01, 5.6223302656E+00, 2.5396153736E+01, 4.1549656239E+00, 9.7438223345E-01],
	[3.8390000000E+04, 4.2676100549E+01, 5.6223695697E+00, 2.5407039908E+01, 4.1553702907E+00, 9.7439503642E-01],
	[3.8395000000E+04, 4.2685794056E+01, 5.6224088689E+00, 2.5417929326E+01, 4.1557748378E+00, 9.7440783237E-01],
	[3.8400000000E+04, 4.2695488502E+01, 5.6224481632E+00, 2.5428821993E+01, 4.1561792652E+00, 9.7442062132E-01],
	[3.8405000000E+04, 4.2705183886E+01, 5.6224874527E+00, 2.5439717908E+01, 4.1565835729E+00, 9.7443340326E-01],
	[3.8410000000E+04, 4.2714880210E+01, 5.6225267374E+00, 2.5450617072E+01, 4.1569877609E+00, 9.7444617819E-01],
	[3.8415000000E+04, 4.2724577473E+01, 5.6225660173E+00, 2.5461519485E+01, 4.1573918294E+00, 9.7445894613E-01],
	[3.8420000000E+04, 4.2734275675E+01, 5.6226052923E+00, 2.5472425148E+01, 4.1577957782E+00, 9.7447170707E-01],
	[3.8425000000E+04, 4.2743974816E+01, 5.6226445624E+00, 2.5483334061E+01, 4.1581996076E+00, 9.7448446102E-01],
	[3.8430000000E+04, 4.2753674896E+01, 5.6226838278E+00, 2.5494246225E+01, 4.1586033174E+00, 9.7449720798E-01],
	[3.8435000000E+04, 4.2763375915E+01, 5.6227230883E+00, 2.5505161641E+01, 4.1590069078E+00, 9.7450994796E-01],
	[3.8440000000E+04, 4.2773077872E+01, 5.6227623439E+00, 2.5516080309E+01, 4.1594103788E+00, 9.7452268096E-01],
	[3.8445000000E+04, 4.2782780769E+01, 5.6228015947E+00, 2.5527002230E+01, 4.1598137304E+00, 9.7453540699E-01],
	[3.8450000000E+04, 4.2792484604E+01, 5.6228408407E+00, 2.5537927404E+01, 4.1602169626E+00, 9.7454812604E-01],
	[3.8455000000E+04, 4.2802189378E+01, 5.6228800819E+00, 2.5548855831E+01, 4.1606200755E+00, 9.7456083813E-01],
	[3.8460000000E+04, 4.2811895091E+01, 5.6229193183E+00, 2.5559787513E+01, 4.1610230691E+00, 9.7457354326E-01],
	[3.8465000000E+04, 4.2821601742E+01, 5.6229585498E+00, 2.5570722450E+01, 4.1614259435E+00, 9.7458624142E-01],
	[3.8470000000E+04, 4.2831309332E+01, 5.6229977765E+00, 2.5581660642E+01, 4.1618286986E+00, 9.7459893263E-01],
	[3.8475000000E+04, 4.2841017861E+01, 5.6230369983E+00, 2.5592602090E+01, 4.1622313346E+00, 9.7461161689E-01],
	[3.8480000000E+04, 4.2850727328E+01, 5.6230762154E+00, 2.5603546794E+01, 4.1626338515E+00, 9.7462429420E-01],
	[3.8485000000E+04, 4.2860437734E+01, 5.6231154276E+00, 2.5614494756E+01, 4.1630362492E+00, 9.7463696457E-01],
	[3.8490000000E+04, 4.2870149078E+01, 5.6231546350E+00, 2.5625445974E+01, 4.1634385279E+00, 9.7464962801E-01],
	[3.8495000000E+04, 4.2879861361E+01, 5.6231938376E+00, 2.5636400451E+01, 4.1638406876E+00, 9.7466228450E-01],
	[3.8500000000E+04, 4.2889574583E+01, 5.6232330353E+00, 2.5647358187E+01, 4.1642427282E+00, 9.7467493407E-01],
	[3.8505000000E+04, 4.2899288743E+01, 5.6232722283E+00, 2.5658319182E+01, 4.1646446500E+00, 9.7468757671E-01],
	[3.8510000000E+04, 4.2909003841E+01, 5.6233114164E+00, 2.5669283436E+01, 4.1650464527E+00, 9.7470021242E-01],
	[3.8515000000E+04, 4.2918719878E+01, 5.6233505997E+00, 2.5680250951E+01, 4.1654481366E+00, 9.7471284122E-01],
	[3.8520000000E+04, 4.2928436853E+01, 5.6233897782E+00, 2.5691221727E+01, 4.1658497017E+00, 9.7472546310E-01],
	[3.8525000000E+04, 4.2938154766E+01, 5.6234289519E+00, 2.5702195764E+01, 4.1662511479E+00, 9.7473807807E-01],
	[3.8530000000E+04, 4.2947873618E+01, 5.6234681208E+00, 2.5713173062E+01, 4.1666524754E+00, 9.7475068614E-01],
	[3.8535000000E+04, 4.2957593408E+01, 5.6235072849E+00, 2.5724153624E+01, 4.1670536841E+00, 9.7476328730E-01],
	[3.8540000000E+04, 4.2967314136E+01, 5.6235464441E+00, 2.5735137448E+01, 4.1674547741E+00, 9.7477588156E-01],
	[3.8545000000E+04, 4.2977035802E+01, 5.6235855986E+00, 2.5746124536E+01, 4.1678557454E+00, 9.7478846893E-01],
	[3.8550000000E+04, 4.2986758407E+01, 5.6236247482E+00, 2.5757114888E+01, 4.1682565981E+00, 9.7480104941E-01],
	[3.8555000000E+04, 4.2996481949E+01, 5.6236638931E+00, 2.5768108504E+01, 4.1686573322E+00, 9.7481362300E-01],
	[3.8560000000E+04, 4.3006206430E+01, 5.6237030331E+00, 2.5779105386E+01, 4.1690579477E+00, 9.7482618971E-01],
	[3.8565000000E+04, 4.3015931849E+01, 5.6237421683E+00, 2.5790105534E+01, 4.1694584448E+00, 9.7483874953E-01],
	[3.8570000000E+04, 4.3025658206E+01, 5.6237812988E+00, 2.5801108947E+01, 4.1698588233E+00, 9.7485130249E-01],
	[3.8575000000E+04, 4.3035385501E+01, 5.6238204244E+00, 2.5812115628E+01, 4.1702590833E+00, 9.7486384857E-01],
	[3.8580000000E+04, 4.3045113734E+01, 5.6238595452E+00, 2.5823125576E+01, 4.1706592250E+00, 9.7487638779E-01],
	[3.8585000000E+04, 4.3054842905E+01, 5.6238986613E+00, 2.5834138792E+01, 4.1710592482E+00, 9.7488892014E-01],
	[3.8590000000E+04, 4.3064573013E+01, 5.6239377725E+00, 2.5845155276E+01, 4.1714591531E+00, 9.7490144564E-01],
	[3.8595000000E+04, 4.3074304060E+01, 5.6239768790E+00, 2.5856175029E+01, 4.1718589397E+00, 9.7491396428E-01],
	[3.8600000000E+04, 4.3084036045E+01, 5.6240159806E+00, 2.5867198052E+01, 4.1722586080E+00, 9.7492647607E-01],
	[3.8605000000E+04, 4.3093768967E+01, 5.6240550775E+00, 2.5878224345E+01, 4.1726581581E+00, 9.7493898101E-01],
	[3.8610000000E+04, 4.3103502827E+01, 5.6240941695E+00, 2.5889253909E+01, 4.1730575900E+00, 9.7495147911E-01],
	[3.8615000000E+04, 4.3113237625E+01, 5.6241332568E+00, 2.5900286743E+01, 4.1734569037E+00, 9.7496397037E-01],
	[3.8620000000E+04, 4.3122995590E+01, 5.6241745924E+00, 2.5911322850E+01, 4.1738575484E+00, 9.7497645480E-01],
	[3.8625000000E+04, 4.3132754867E+01, 5.6242159601E+00, 2.5922362229E+01, 4.1742580992E+00, 9.7498893239E-01],
	[3.8630000000E+04, 4.3142515089E+01, 5.6242573228E+00, 2.5933404880E+01, 4.1746585322E+00, 9.7500140316E-01],
	[3.8635000000E+04, 4.3152276256E+01, 5.6242986804E+00, 2.5944450805E+01, 4.1750588474E+00, 9.7501386711E-01],
	[3.8640000000E+04, 4.3162038368E+01, 5.6243400329E+00, 2.5955500004E+01, 4.1754590449E+00, 9.7502632424E-01],
	[3.8645000000E+04, 4.3171801425E+01, 5.6243813805E+00, 2.5966552478E+01, 4.1758591247E+00, 9.7503877455E-01],
	[3.8650000000E+04, 4.3181565426E+01, 5.6244227229E+00, 2.5977608226E+01, 4.1762590869E+00, 9.7505121805E-01],
	[3.8655000000E+04, 4.3191330373E+01, 5.6244640604E+00, 2.5988667250E+01, 4.1766589314E+00, 9.7506365474E-01],
	[3.8660000000E+04, 4.3201096264E+01, 5.6245053928E+00, 2.5999729550E+01, 4.1770586583E+00, 9.7507608463E-01],
	[3.8665000000E+04, 4.3210863100E+01, 5.6245467201E+00, 2.6010795127E+01, 4.1774582677E+00, 9.7508850773E-01],
	[3.8670000000E+04, 4.3220630881E+01, 5.6245880424E+00, 2.6021863981E+01, 4.1778577596E+00, 9.7510092402E-01],
	[3.8675000000E+04, 4.3230399606E+01, 5.6246293597E+00, 2.6032936112E+01, 4.1782571340E+00, 9.7511333353E-01],
	[3.8680000000E+04, 4.3240169276E+01, 5.6246706719E+00, 2.6044011522E+01, 4.1786563909E+00, 9.7512573625E-01],
	[3.8685000000E+04, 4.3249939890E+01, 5.6247119791E+00, 2.6055090211E+01, 4.1790555304E+00, 9.7513813218E-01],
	[3.8690000000E+04, 4.3259711450E+01, 5.6247532813E+00, 2.6066172179E+01, 4.1794545526E+00, 9.7515052134E-01],
	[3.8695000000E+04, 4.3269483953E+01, 5.6247945784E+00, 2.6077257427E+01, 4.1798534574E+00, 9.7516290372E-01],
	[3.8700000000E+04, 4.3279257402E+01, 5.6248358705E+00, 2.6088345956E+01, 4.1802522449E+00, 9.7517527933E-01],
	[3.8705000000E+04, 4.3289031794E+01, 5.6248771575E+00, 2.6099437765E+01, 4.1806509151E+00, 9.7518764817E-01],
	[3.8710000000E+04, 4.3298807132E+01, 5.6249184396E+00, 2.6110532857E+01, 4.1810494681E+00, 9.7520001025E-01],
	[3.8715000000E+04, 4.3308583413E+01, 5.6249597166E+00, 2.6121631230E+01, 4.1814479039E+00, 9.7521236557E-01],
	[3.8720000000E+04, 4.3318360639E+01, 5.6250009885E+00, 2.6132732886E+01, 4.1818462226E+00, 9.7522471414E-01],
	[3.8725000000E+04, 4.3328138810E+01, 5.6250422555E+00, 2.6143837825E+01, 4.1822444241E+00, 9.7523705595E-01],
	[3.8730000000E+04, 4.3337917925E+01, 5.6250835174E+00, 2.6154946048E+01, 4.1826425085E+00, 9.7524939102E-01],
	[3.8735000000E+04, 4.3347697984E+01, 5.6251247743E+00, 2.6166057555E+01, 4.1830404759E+00, 9.7526171934E-01],
	[3.8740000000E+04, 4.3357478987E+01, 5.6251660262E+00, 2.6177172347E+01, 4.1834383262E+00, 9.7527404093E-01],
	[3.8745000000E+04, 4.3367260935E+01, 5.6252072730E+00, 2.6188290425E+01, 4.1838360596E+00, 9.7528635578E-01],
	[3.8750000000E+04, 4.3377043827E+01, 5.6252485149E+00, 2.6199411788E+01, 4.1842336760E+00, 9.7529866389E-01],
	[3.8755000000E+04, 4.3386827663E+01, 5.6252897517E+00, 2.6210536438E+01, 4.1846311755E+00, 9.7531096528E-01],
	[3.8760000000E+04, 4.3396612443E+01, 5.6253309835E+00, 2.6221664375E+01, 4.1850285581E+00, 9.7532325995E-01],
	[3.8765000000E+04, 4.3406398168E+01, 5.6253722103E+00, 2.6232795599E+01, 4.1854258239E+00, 9.7533554789E-01],
	[3.8770000000E+04, 4.3416184836E+01, 5.6254134320E+00, 2.6243930112E+01, 4.1858229729E+00, 9.7534782912E-01],
	[3.8775000000E+04, 4.3425972449E+01, 5.6254546488E+00, 2.6255067913E+01, 4.1862200051E+00, 9.7536010364E-01],
	[3.8780000000E+04, 4.3435761005E+01, 5.6254958605E+00, 2.6266209004E+01, 4.1866169205E+00, 9.7537237145E-01],
	[3.8785000000E+04, 4.3445550506E+01, 5.6255370672E+00, 2.6277353384E+01, 4.1870137193E+00, 9.7538463256E-01],
	[3.8790000000E+04, 4.3455340950E+01, 5.6255782690E+00, 2.6288501055E+01, 4.1874104014E+00, 9.7539688696E-01],
	[3.8795000000E+04, 4.3465132339E+01, 5.6256194657E+00, 2.6299652016E+01, 4.1878069669E+00, 9.7540913468E-01],
	[3.8800000000E+04, 4.3474924671E+01, 5.6256606574E+00, 2.6310806269E+01, 4.1882034157E+00, 9.7542137569E-01],
	[3.8805000000E+04, 4.3484717948E+01, 5.6257018441E+00, 2.6321963814E+01, 4.1885997480E+00, 9.7543361003E-01],
	[3.8810000000E+04, 4.3494512168E+01, 5.6257430258E+00, 2.6333124651E+01, 4.1889959638E+00, 9.7544583767E-01],
	[3.8815000000E+04, 4.3504307332E+01, 5.6257842024E+00, 2.6344288781E+01, 4.1893920631E+00, 9.7545805864E-01],
	[3.8820000000E+04, 4.3514103440E+01, 5.6258253741E+00, 2.6355456205E+01, 4.1897880460E+00, 9.7547027293E-01],
	[3.8825000000E+04, 4.3523900492E+01, 5.6258665408E+00, 2.6366626924E+01, 4.1901839124E+00, 9.7548248055E-01],
	[3.8830000000E+04, 4.3533698487E+01, 5.6259077025E+00, 2.6377800936E+01, 4.1905796625E+00, 9.7549468150E-01],
	[3.8835000000E+04, 4.3543497426E+01, 5.6259488592E+00, 2.6388978244E+01, 4.1909752962E+00, 9.7550687578E-01],
	[3.8840000000E+04, 4.3553297309E+01, 5.6259900109E+00, 2.6400158848E+01, 4.1913708136E+00, 9.7551906341E-01],
	[3.8845000000E+04, 4.3563098135E+01, 5.6260311575E+00, 2.6411342749E+01, 4.1917662147E+00, 9.7553124438E-01],
	[3.8850000000E+04, 4.3572899905E+01, 5.6260722992E+00, 2.6422529946E+01, 4.1921614996E+00, 9.7554341869E-01],
	[3.8855000000E+04, 4.3582702618E+01, 5.6261134359E+00, 2.6433720440E+01, 4.1925566683E+00, 9.7555558636E-01],
	[3.8860000000E+04, 4.3592506276E+01, 5.6261545677E+00, 2.6444914233E+01, 4.1929517208E+00, 9.7556774738E-01],
	[3.8865000000E+04, 4.3602310876E+01, 5.6261956944E+00, 2.6456111324E+01, 4.1933466571E+00, 9.7557990176E-01],
	[3.8870000000E+04, 4.3612116420E+01, 5.6262368161E+00, 2.6467311714E+01, 4.1937414774E+00, 9.7559204951E-01],
	[3.8875000000E+04, 4.3621922908E+01, 5.6262779328E+00, 2.6478515403E+01, 4.1941361816E+00, 9.7560419062E-01],
	[3.8880000000E+04, 4.3631730339E+01, 5.6263190446E+00, 2.6489722393E+01, 4.1945307698E+00, 9.7561632510E-01],
	[3.8885000000E+04, 4.3641538713E+01, 5.6263601513E+00, 2.6500932684E+01, 4.1949252420E+00, 9.7562845296E-01],
	[3.8890000000E+04, 4.3651348031E+01, 5.6264012531E+00, 2.6512146276E+01, 4.1953195982E+00, 9.7564057420E-01],
	[3.8895000000E+04, 4.3661158292E+01, 5.6264423499E+00, 2.6523363169E+01, 4.1957138385E+00, 9.7565268881E-01],
	[3.8900000000E+04, 4.3670969496E+01, 5.6264834417E+00, 2.6534583365E+01, 4.1961079630E+00, 9.7566479682E-01],
	[3.8905000000E+04, 4.3680781644E+01, 5.6265245286E+00, 2.6545806864E+01, 4.1965019715E+00, 9.7567689822E-01],
	[3.8910000000E+04, 4.3690594735E+01, 5.6265656104E+00, 2.6557033666E+01, 4.1968958643E+00, 9.7568899301E-01],
	[3.8915000000E+04, 4.3700408769E+01, 5.6266066873E+00, 2.6568263773E+01, 4.1972896413E+00, 9.7570108120E-01],
	[3.8920000000E+04, 4.3710223746E+01, 5.6266477592E+00, 2.6579497183E+01, 4.1976833025E+00, 9.7571316279E-01],
	[3.8925000000E+04, 4.3720039667E+01, 5.6266888261E+00, 2.6590733899E+01, 4.1980768480E+00, 9.7572523779E-01],
	[3.8930000000E+04, 4.3729856531E+01, 5.6267298880E+00, 2.6601973921E+01, 4.1984702779E+00, 9.7573730620E-01],
	[3.8935000000E+04, 4.3739674337E+01, 5.6267709450E+00, 2.6613217249E+01, 4.1988635921E+00, 9.7574936802E-01],
	[3.8940000000E+04, 4.3749493087E+01, 5.6268119970E+00, 2.6624463883E+01, 4.1992567907E+00, 9.7576142326E-01],
	[3.8945000000E+04, 4.3759312780E+01, 5.6268530440E+00, 2.6635713825E+01, 4.1996498737E+00, 9.7577347192E-01],
	[3.8950000000E+04, 4.3769133415E+01, 5.6268940861E+00, 2.6646967075E+01, 4.2000428412E+00, 9.7578551401E-01],
	[3.8955000000E+04, 4.3778954994E+01, 5.6269351232E+00, 2.6658223633E+01, 4.2004356932E+00, 9.7579754953E-01],
	[3.8960000000E+04, 4.3788777516E+01, 5.6269761553E+00, 2.6669483500E+01, 4.2008284298E+00, 9.7580957848E-01],
	[3.8965000000E+04, 4.3798600980E+01, 5.6270171824E+00, 2.6680746676E+01, 4.2012210509E+00, 9.7582160087E-01],
	[3.8970000000E+04, 4.3808425388E+01, 5.6270582046E+00, 2.6692013162E+01, 4.2016135566E+00, 9.7583361670E-01],
	[3.8975000000E+04, 4.3818250738E+01, 5.6270992219E+00, 2.6703282959E+01, 4.2020059470E+00, 9.7584562598E-01],
	[3.8980000000E+04, 4.3828077031E+01, 5.6271402341E+00, 2.6714556067E+01, 4.2023982220E+00, 9.7585762871E-01],
	[3.8985000000E+04, 4.3837904267E+01, 5.6271812414E+00, 2.6725832487E+01, 4.2027903818E+00, 9.7586962488E-01],
	[3.8990000000E+04, 4.3847732446E+01, 5.6272222438E+00, 2.6737112219E+01, 4.2031824263E+00, 9.7588161452E-01],
	[3.8995000000E+04, 4.3857561567E+01, 5.6272632411E+00, 2.6748395264E+01, 4.2035743556E+00, 9.7589359762E-01],
	[3.9000000000E+04, 4.3867391631E+01, 5.6273042336E+00, 2.6759681622E+01, 4.2039661697E+00, 9.7590557418E-01],
	[3.9005000000E+04, 4.3877222638E+01, 5.6273452210E+00, 2.6770971294E+01, 4.2043578687E+00, 9.7591754421E-01],
	[3.9010000000E+04, 4.3887054588E+01, 5.6273862035E+00, 2.6782264280E+01, 4.2047494526E+00, 9.7592950771E-01],
	[3.9015000000E+04, 4.3896887480E+01, 5.6274271811E+00, 2.6793560581E+01, 4.2051409213E+00, 9.7594146469E-01],
	[3.9020000000E+04, 4.3906721314E+01, 5.6274681537E+00, 2.6804860198E+01, 4.2055322751E+00, 9.7595341516E-01],
	[3.9025000000E+04, 4.3916556091E+01, 5.6275091213E+00, 2.6816163130E+01, 4.2059235138E+00, 9.7596535910E-01],
	[3.9030000000E+04, 4.3926391811E+01, 5.6275500840E+00, 2.6827469380E+01, 4.2063146376E+00, 9.7597729653E-01],
	[3.9035000000E+04, 4.3936228473E+01, 5.6275910418E+00, 2.6838778946E+01, 4.2067056465E+00, 9.7598922746E-01],
	[3.9040000000E+04, 4.3946066078E+01, 5.6276319946E+00, 2.6850091830E+01, 4.2070965404E+00, 9.7600115188E-01],
	[3.9045000000E+04, 4.3955904625E+01, 5.6276729425E+00, 2.6861408033E+01, 4.2074873195E+00, 9.7601306980E-01],
	[3.9050000000E+04, 4.3965744114E+01, 5.6277138854E+00, 2.6872727554E+01, 4.2078779837E+00, 9.7602498123E-01],
	[3.9055000000E+04, 4.3975584546E+01, 5.6277548233E+00, 2.6884050394E+01, 4.2082685332E+00, 9.7603688616E-01],
	[3.9060000000E+04, 4.3985425920E+01, 5.6277957564E+00, 2.6895376555E+01, 4.2086589679E+00, 9.7604878461E-01],
	[3.9065000000E+04, 4.3995268236E+01, 5.6278366844E+00, 2.6906706035E+01, 4.2090492879E+00, 9.7606067657E-01],
	[3.9070000000E+04, 4.4005111495E+01, 5.6278776076E+00, 2.6918038837E+01, 4.2094394932E+00, 9.7607256204E-01],
	[3.9075000000E+04, 4.4014955696E+01, 5.6279185258E+00, 2.6929374961E+01, 4.2098295838E+00, 9.7608444105E-01],
	[3.9080000000E+04, 4.4024800839E+01, 5.6279594390E+00, 2.6940714406E+01, 4.2102195599E+00, 9.7609631358E-01],
	[3.9085000000E+04, 4.4034646924E+01, 5.6280003474E+00, 2.6952057174E+01, 4.2106094213E+00, 9.7610817964E-01],
	[3.9090000000E+04, 4.4044493951E+01, 5.6280412508E+00, 2.6963403265E+01, 4.2109991682E+00, 9.7612003923E-01],
	[3.9095000000E+04, 4.4054341921E+01, 5.6280821492E+00, 2.6974752680E+01, 4.2113888006E+00, 9.7613189237E-01],
	[3.9100000000E+04, 4.4064190833E+01, 5.6281230427E+00, 2.6986105419E+01, 4.2117783185E+00, 9.7614373904E-01],
	[3.9105000000E+04, 4.4074040686E+01, 5.6281639313E+00, 2.6997461483E+01, 4.2121677220E+00, 9.7615557927E-01],
	[3.9110000000E+04, 4.4083891482E+01, 5.6282048150E+00, 2.7008820872E+01, 4.2125570111E+00, 9.7616741304E-01],
	[3.9115000000E+04, 4.4093743220E+01, 5.6282456937E+00, 2.7020183587E+01, 4.2129461858E+00, 9.7617924037E-01],
	[3.9120000000E+04, 4.4103595899E+01, 5.6282865675E+00, 2.7031549629E+01, 4.2133352461E+00, 9.7619106125E-01],
	[3.9125000000E+04, 4.4113449521E+01, 5.6283274364E+00, 2.7042918998E+01, 4.2137241922E+00, 9.7620287570E-01],
	[3.9130000000E+04, 4.4123304084E+01, 5.6283683004E+00, 2.7054291694E+01, 4.2141130240E+00, 9.7621468372E-01],
	[3.9135000000E+04, 4.4133159590E+01, 5.6284091594E+00, 2.7065667718E+01, 4.2145017416E+00, 9.7622648530E-01],
	[3.9140000000E+04, 4.4143016037E+01, 5.6284500135E+00, 2.7077047071E+01, 4.2148903449E+00, 9.7623828046E-01],
	[3.9145000000E+04, 4.4152873426E+01, 5.6284908627E+00, 2.7088429753E+01, 4.2152788342E+00, 9.7625006919E-01],
	[3.9150000000E+04, 4.4162731757E+01, 5.6285317069E+00, 2.7099815765E+01, 4.2156672092E+00, 9.7626185151E-01],
	[3.9155000000E+04, 4.4172591029E+01, 5.6285725463E+00, 2.7111205107E+01, 4.2160554703E+00, 9.7627362741E-01],
	[3.9160000000E+04, 4.4182451244E+01, 5.6286133807E+00, 2.7122597780E+01, 4.2164436172E+00, 9.7628539690E-01],
	[3.9165000000E+04, 4.4192312400E+01, 5.6286542102E+00, 2.7133993785E+01, 4.2168316501E+00, 9.7629715998E-01],
	[3.9170000000E+04, 4.4202174497E+01, 5.6286950348E+00, 2.7145393121E+01, 4.2172195691E+00, 9.7630891666E-01],
	[3.9175000000E+04, 4.4212037537E+01, 5.6287358545E+00, 2.7156795790E+01, 4.2176073741E+00, 9.7632066694E-01],
	[3.9180000000E+04, 4.4221901518E+01, 5.6287766692E+00, 2.7168201792E+01, 4.2179950652E+00, 9.7633241082E-01],
	[3.9185000000E+04, 4.4231766440E+01, 5.6288174791E+00, 2.7179611127E+01, 4.2183826424E+00, 9.7634414831E-01],
	[3.9190000000E+04, 4.4241632304E+01, 5.6288582840E+00, 2.7191023797E+01, 4.2187701057E+00, 9.7635587942E-01],
	[3.9195000000E+04, 4.4251499110E+01, 5.6288990840E+00, 2.7202439801E+01, 4.2191574553E+00, 9.7636760413E-01],
	[3.9200000000E+04, 4.4261366857E+01, 5.6289398792E+00, 2.7213859141E+01, 4.2195446911E+00, 9.7637932247E-01],
	[3.9205000000E+04, 4.4271235545E+01, 5.6289806694E+00, 2.7225281816E+01, 4.2199318131E+00, 9.7639103444E-01],
	[3.9210000000E+04, 4.4281105175E+01, 5.6290214547E+00, 2.7236707828E+01, 4.2203188215E+00, 9.7640274003E-01],
	[3.9215000000E+04, 4.4290975746E+01, 5.6290622351E+00, 2.7248137176E+01, 4.2207057161E+00, 9.7641443925E-01],
	[3.9220000000E+04, 4.4300847259E+01, 5.6291030106E+00, 2.7259569862E+01, 4.2210924972E+00, 9.7642613211E-01],
	[3.9225000000E+04, 4.4310719713E+01, 5.6291437812E+00, 2.7271005886E+01, 4.2214791646E+00, 9.7643781860E-01],
	[3.9230000000E+04, 4.4320593108E+01, 5.6291845469E+00, 2.7282445248E+01, 4.2218657185E+00, 9.7644949874E-01],
	[3.9235000000E+04, 4.4330467444E+01, 5.6292253076E+00, 2.7293887950E+01, 4.2222521588E+00, 9.7646117253E-01],
	[3.9240000000E+04, 4.4340357372E+01, 5.6292675276E+00, 2.7305333991E+01, 4.2226394424E+00, 9.7647283996E-01],
	[3.9245000000E+04, 4.4350256006E+01, 5.6293105179E+00, 2.7316783372E+01, 4.2230271194E+00, 9.7648450105E-01],
	[3.9250000000E+04, 4.4360155589E+01, 5.6293535031E+00, 2.7328236094E+01, 4.2234146832E+00, 9.7649615580E-01],
	[3.9255000000E+04, 4.4370056120E+01, 5.6293964832E+00, 2.7339692157E+01, 4.2238021339E+00, 9.7650780421E-01],
	[3.9260000000E+04, 4.4379957600E+01, 5.6294394581E+00, 2.7351151562E+01, 4.2241894714E+00, 9.7651944628E-01],
	[3.9265000000E+04, 4.4389860028E+01, 5.6294824279E+00, 2.7362614310E+01, 4.2245766959E+00, 9.7653108203E-01],
	[3.9270000000E+04, 4.4399763404E+01, 5.6295253925E+00, 2.7374080400E+01, 4.2249638074E+00, 9.7654271145E-01],
	[3.9275000000E+04, 4.4409667728E+01, 5.6295683520E+00, 2.7385549834E+01, 4.2253508058E+00, 9.7655433454E-01],
	[3.9280000000E+04, 4.4419573000E+01, 5.6296113063E+00, 2.7397022611E+01, 4.2257376913E+00, 9.7656595132E-01],
	[3.9285000000E+04, 4.4429479220E+01, 5.6296542555E+00, 2.7408498734E+01, 4.2261244638E+00, 9.7657756178E-01],
	[3.9290000000E+04, 4.4439386388E+01, 5.6296971996E+00, 2.7419978201E+01, 4.2265111234E+00, 9.7658916593E-01],
	[3.9295000000E+04, 4.4449294505E+01, 5.6297401385E+00, 2.7431461014E+01, 4.2268976702E+00, 9.7660076377E-01],
	[3.9300000000E+04, 4.4459203569E+01, 5.6297830723E+00, 2.7442947174E+01, 4.2272841041E+00, 9.7661235531E-01],
	[3.9305000000E+04, 4.4469113582E+01, 5.6298260010E+00, 2.7454436680E+01, 4.2276704252E+00, 9.7662394055E-01],
	[3.9310000000E+04, 4.4479024542E+01, 5.6298689245E+00, 2.7465929533E+01, 4.2280566336E+00, 9.7663551949E-01],
	[3.9315000000E+04, 4.4488936451E+01, 5.6299118429E+00, 2.7477425734E+01, 4.2284427292E+00, 9.7664709214E-01],
	[3.9320000000E+04, 4.4498849307E+01, 5.6299547562E+00, 2.7488925284E+01, 4.2288287121E+00, 9.7665865851E-01],
	[3.9325000000E+04, 4.4508763111E+01, 5.6299976643E+00, 2.7500428182E+01, 4.2292145824E+00, 9.7667021858E-01],
	[3.9330000000E+04, 4.4518677863E+01, 5.6300405673E+00, 2.7511934430E+01, 4.2296003400E+00, 9.7668177238E-01],
	[3.9335000000E+04, 4.4528593563E+01, 5.6300834652E+00, 2.7523444028E+01, 4.2299859851E+00, 9.7669331990E-01],
	[3.9340000000E+04, 4.4538510210E+01, 5.6301263579E+00, 2.7534956977E+01, 4.2303715176E+00, 9.7670486115E-01],
	[3.9345000000E+04, 4.4548427805E+01, 5.6301692456E+00, 2.7546473277E+01, 4.2307569376E+00, 9.7671639612E-01],
	[3.9350000000E+04, 4.4558346348E+01, 5.6302121281E+00, 2.7557992929E+01, 4.2311422451E+00, 9.7672792483E-01],
	[3.9355000000E+04, 4.4568265839E+01, 5.6302550054E+00, 2.7569515932E+01, 4.2315274401E+00, 9.7673944728E-01],
	[3.9360000000E+04, 4.4578186277E+01, 5.6302978777E+00, 2.7581042289E+01, 4.2319125227E+00, 9.7675096347E-01],
	[3.9365000000E+04, 4.4588107663E+01, 5.6303407448E+00, 2.7592571999E+01, 4.2322974929E+00, 9.7676247341E-01],
	[3.9370000000E+04, 4.4598029997E+01, 5.6303836069E+00, 2.7604105063E+01, 4.2326823508E+00, 9.7677397710E-01],
	[3.9375000000E+04, 4.4607953278E+01, 5.6304264638E+00, 2.7615641481E+01, 4.2330670964E+00, 9.7678547454E-01],
	[3.9380000000E+04, 4.4617877507E+01, 5.6304693156E+00, 2.7627181254E+01, 4.2334517297E+00, 9.7679696573E-01],
	[3.9385000000E+04, 4.4627802683E+01, 5.6305121622E+00, 2.7638724383E+01, 4.2338362508E+00, 9.7680845069E-01],
	[3.9390000000E+04, 4.4637728806E+01, 5.6305550038E+00, 2.7650270868E+01, 4.2342206596E+00, 9.7681992942E-01],
	[3.9395000000E+04, 4.4647655878E+01, 5.6305978403E+00, 2.7661820709E+01, 4.2346049563E+00, 9.7683140191E-01],
	[3.9400000000E+04, 4.4657583896E+01, 5.6306406716E+00, 2.7673373908E+01, 4.2349891408E+00, 9.7684286817E-01],
	[3.9405000000E+04, 4.4667512862E+01, 5.6306834978E+00, 2.7684930464E+01, 4.2353732132E+00, 9.7685432821E-01],
	[3.9410000000E+04, 4.4677442775E+01, 5.6307263189E+00, 2.7696490379E+01, 4.2357571736E+00, 9.7686578203E-01],
	[3.9415000000E+04, 4.4687373636E+01, 5.6307691350E+00, 2.7708053652E+01, 4.2361410219E+00, 9.7687722963E-01],
	[3.9420000000E+04, 4.4697305444E+01, 5.6308119459E+00, 2.7719620285E+01, 4.2365247582E+00, 9.7688867102E-01],
	[3.9425000000E+04, 4.4707238199E+01, 5.6308547517E+00, 2.7731190278E+01, 4.2369083826E+00, 9.7690010620E-01],
	[3.9430000000E+04, 4.4717171901E+01, 5.6308975524E+00, 2.7742763632E+01, 4.2372918950E+00, 9.7691153517E-01],
	[3.9435000000E+04, 4.4727106551E+01, 5.6309403480E+00, 2.7754340346E+01, 4.2376752955E+00, 9.7692295794E-01],
	[3.9440000000E+04, 4.4737042148E+01, 5.6309831385E+00, 2.7765920422E+01, 4.2380585841E+00, 9.7693437451E-01],
	[3.9445000000E+04, 4.4746978692E+01, 5.6310259239E+00, 2.7777503860E+01, 4.2384417610E+00, 9.7694578488E-01],
	[3.9450000000E+04, 4.4756916183E+01, 5.6310687042E+00, 2.7789090661E+01, 4.2388248260E+00, 9.7695718905E-01],
	[3.9455000000E+04, 4.4766854621E+01, 5.6311114794E+00, 2.7800680825E+01, 4.2392077793E+00, 9.7696858704E-01],
	[3.9460000000E+04, 4.4776794006E+01, 5.6311542495E+00, 2.7812274353E+01, 4.2395906208E+00, 9.7697997884E-01],
	[3.9465000000E+04, 4.4786734339E+01, 5.6311970145E+00, 2.7823871245E+01, 4.2399733507E+00, 9.7699136445E-01],
	[3.9470000000E+04, 4.4796675618E+01, 5.6312397745E+00, 2.7835471502E+01, 4.2403559689E+00, 9.7700274389E-01],
	[3.9475000000E+04, 4.4806617844E+01, 5.6312825293E+00, 2.7847075124E+01, 4.2407384755E+00, 9.7701411715E-01],
	[3.9480000000E+04, 4.4816561017E+01, 5.6313252790E+00, 2.7858682112E+01, 4.2411208705E+00, 9.7702548423E-01],
	[3.9485000000E+04, 4.4826505137E+01, 5.6313680237E+00, 2.7870292467E+01, 4.2415031539E+00, 9.7703684515E-01],
	[3.9490000000E+04, 4.4836450204E+01, 5.6314107632E+00, 2.7881906189E+01, 4.2418853259E+00, 9.7704819990E-01],
	[3.9495000000E+04, 4.4846396218E+01, 5.6314534977E+00, 2.7893523279E+01, 4.2422673863E+00, 9.7705954848E-01],
	[3.9500000000E+04, 4.4856343179E+01, 5.6314962271E+00, 2.7905143737E+01, 4.2426493353E+00, 9.7707089090E-01],
	[3.9505000000E+04, 4.4866291086E+01, 5.6315389514E+00, 2.7916767563E+01, 4.2430311729E+00, 9.7708222717E-01],
	[3.9510000000E+04, 4.4876239941E+01, 5.6315816706E+00, 2.7928394759E+01, 4.2434128991E+00, 9.7709355729E-01],
	[3.9515000000E+04, 4.4886189741E+01, 5.6316243848E+00, 2.7940025325E+01, 4.2437945140E+00, 9.7710488125E-01],
	[3.9520000000E+04, 4.4896140489E+01, 5.6316670938E+00, 2.7951659261E+01, 4.2441760176E+00, 9.7711619907E-01],
	[3.9525000000E+04, 4.4906092183E+01, 5.6317097978E+00, 2.7963296568E+01, 4.2445574098E+00, 9.7712751074E-01],
	[3.9530000000E+04, 4.4916044824E+01, 5.6317524967E+00, 2.7974937246E+01, 4.2449386909E+00, 9.7713881627E-01],
	[3.9535000000E+04, 4.4925998412E+01, 5.6317951906E+00, 2.7986581297E+01, 4.2453198607E+00, 9.7715011567E-01],
	[3.9540000000E+04, 4.4935952946E+01, 5.6318378793E+00, 2.7998228720E+01, 4.2457009194E+00, 9.7716140893E-01],
	[3.9545000000E+04, 4.4945908427E+01, 5.6318805630E+00, 2.8009879516E+01, 4.2460818669E+00, 9.7717269606E-01],
	[3.9550000000E+04, 4.4955864854E+01, 5.6319232416E+00, 2.8021533686E+01, 4.2464627033E+00, 9.7718397707E-01],
	[3.9555000000E+04, 4.4965822228E+01, 5.6319659151E+00, 2.8033191230E+01, 4.2468434287E+00, 9.7719525195E-01],
	[3.9560000000E+04, 4.4975780548E+01, 5.6320085836E+00, 2.8044852148E+01, 4.2472240430E+00, 9.7720652071E-01],
	[3.9565000000E+04, 4.4985739815E+01, 5.6320512470E+00, 2.8056516443E+01, 4.2476045464E+00, 9.7721778335E-01],
	[3.9570000000E+04, 4.4995700028E+01, 5.6320939053E+00, 2.8068184113E+01, 4.2479849387E+00, 9.7722903988E-01],
	[3.9575000000E+04, 4.5005661187E+01, 5.6321365586E+00, 2.8079855159E+01, 4.2483652202E+00, 9.7724029031E-01],
	[3.9580000000E+04, 4.5015623293E+01, 5.6321792068E+00, 2.8091529582E+01, 4.2487453907E+00, 9.7725153462E-01],
	[3.9585000000E+04, 4.5025586345E+01, 5.6322218499E+00, 2.8103207383E+01, 4.2491254504E+00, 9.7726277283E-01],
	[3.9590000000E+04, 4.5035550344E+01, 5.6322644880E+00, 2.8114888562E+01, 4.2495053992E+00, 9.7727400494E-01],
	[3.9595000000E+04, 4.5045515289E+01, 5.6323071210E+00, 2.8126573120E+01, 4.2498852373E+00, 9.7728523095E-01],
	[3.9600000000E+04, 4.5055481179E+01, 5.6323497489E+00, 2.8138261057E+01, 4.2502649646E+00, 9.7729645087E-01],
	[3.9605000000E+04, 4.5065448017E+01, 5.6323923718E+00, 2.8149952373E+01, 4.2506445812E+00, 9.7730766470E-01],
	[3.9610000000E+04, 4.5075415800E+01, 5.6324349896E+00, 2.8161647070E+01, 4.2510240870E+00, 9.7731887245E-01],
	[3.9615000000E+04, 4.5085384529E+01, 5.6324776024E+00, 2.8173345148E+01, 4.2514034823E+00, 9.7733007411E-01],
	[3.9620000000E+04, 4.5095354205E+01, 5.6325202101E+00, 2.8185046607E+01, 4.2517827669E+00, 9.7734126969E-01],
	[3.9625000000E+04, 4.5105324826E+01, 5.6325628128E+00, 2.8196751448E+01, 4.2521619409E+00, 9.7735245919E-01],
	[3.9630000000E+04, 4.5115296394E+01, 5.6326054104E+00, 2.8208459671E+01, 4.2525410044E+00, 9.7736364262E-01],
	[3.9635000000E+04, 4.5125268908E+01, 5.6326480029E+00, 2.8220171278E+01, 4.2529199574E+00, 9.7737481998E-01],
	[3.9640000000E+04, 4.5135242367E+01, 5.6326905904E+00, 2.8231886268E+01, 4.2532987999E+00, 9.7738599127E-01],
	[3.9645000000E+04, 4.5145216773E+01, 5.6327331729E+00, 2.8243604642E+01, 4.2536775319E+00, 9.7739715650E-01],
	[3.9650000000E+04, 4.5155192125E+01, 5.6327757503E+00, 2.8255326401E+01, 4.2540561535E+00, 9.7740831566E-01],
	[3.9655000000E+04, 4.5165168422E+01, 5.6328183226E+00, 2.8267051545E+01, 4.2544346648E+00, 9.7741946878E-01],
	[3.9660000000E+04, 4.5175145666E+01, 5.6328608899E+00, 2.8278780075E+01, 4.2548130657E+00, 9.7743061583E-01],
	[3.9665000000E+04, 4.5185123855E+01, 5.6329034522E+00, 2.8290511991E+01, 4.2551913562E+00, 9.7744175684E-01],
	[3.9670000000E+04, 4.5195102990E+01, 5.6329460094E+00, 2.8302247294E+01, 4.2555695366E+00, 9.7745289180E-01],
	[3.9675000000E+04, 4.5205083071E+01, 5.6329885616E+00, 2.8313985985E+01, 4.2559476066E+00, 9.7746402072E-01],
	[3.9680000000E+04, 4.5215064097E+01, 5.6330311088E+00, 2.8325728063E+01, 4.2563255665E+00, 9.7747514360E-01],
	[3.9685000000E+04, 4.5225046069E+01, 5.6330736509E+00, 2.8337473530E+01, 4.2567034162E+00, 9.7748626044E-01],
	[3.9690000000E+04, 4.5235028987E+01, 5.6331161879E+00, 2.8349222386E+01, 4.2570811557E+00, 9.7749737124E-01],
	[3.9695000000E+04, 4.5245012851E+01, 5.6331587199E+00, 2.8360974632E+01, 4.2574587852E+00, 9.7750847602E-01],
	[3.9700000000E+04, 4.5254997660E+01, 5.6332012469E+00, 2.8372730268E+01, 4.2578363046E+00, 9.7751957477E-01],
	[3.9705000000E+04, 4.5264983415E+01, 5.6332437689E+00, 2.8384489295E+01, 4.2582137139E+00, 9.7753066750E-01],
	[3.9710000000E+04, 4.5274970116E+01, 5.6332862858E+00, 2.8396251713E+01, 4.2585910132E+00, 9.7754175420E-01],
	[3.9715000000E+04, 4.5284957762E+01, 5.6333287977E+00, 2.8408017522E+01, 4.2589682026E+00, 9.7755283489E-01],
	[3.9720000000E+04, 4.5294946353E+01, 5.6333713046E+00, 2.8419786725E+01, 4.2593452821E+00, 9.7756390957E-01],
	[3.9725000000E+04, 4.5304935890E+01, 5.6334138064E+00, 2.8431559320E+01, 4.2597222516E+00, 9.7757497823E-01],
	[3.9730000000E+04, 4.5314926373E+01, 5.6334563032E+00, 2.8443335308E+01, 4.2600991113E+00, 9.7758604089E-01],
	[3.9735000000E+04, 4.5324917801E+01, 5.6334987950E+00, 2.8455114691E+01, 4.2604758612E+00, 9.7759709754E-01],
	[3.9740000000E+04, 4.5334910174E+01, 5.6335412817E+00, 2.8466897468E+01, 4.2608525012E+00, 9.7760814820E-01],
	[3.9745000000E+04, 4.5344903493E+01, 5.6335837634E+00, 2.8478683640E+01, 4.2612290315E+00, 9.7761919285E-01],
	[3.9750000000E+04, 4.5354897757E+01, 5.6336262401E+00, 2.8490473208E+01, 4.2616054521E+00, 9.7763023152E-01],
	[3.9755000000E+04, 4.5364892966E+01, 5.6336687118E+00, 2.8502266173E+01, 4.2619817630E+00, 9.7764126419E-01],
	[3.9760000000E+04, 4.5374889121E+01, 5.6337111784E+00, 2.8514062534E+01, 4.2623579642E+00, 9.7765229088E-01],
	[3.9765000000E+04, 4.5384886221E+01, 5.6337536401E+00, 2.8525862292E+01, 4.2627340558E+00, 9.7766331158E-01],
	[3.9770000000E+04, 4.5394884266E+01, 5.6337960967E+00, 2.8537665449E+01, 4.2631100378E+00, 9.7767432630E-01],
	[3.9775000000E+04, 4.5404883256E+01, 5.6338385483E+00, 2.8549472003E+01, 4.2634859103E+00, 9.7768533505E-01],
	[3.9780000000E+04, 4.5414883192E+01, 5.6338809949E+00, 2.8561281957E+01, 4.2638616732E+00, 9.7769633782E-01],
	[3.9785000000E+04, 4.5424884072E+01, 5.6339234364E+00, 2.8573095310E+01, 4.2642373266E+00, 9.7770733462E-01],
	[3.9790000000E+04, 4.5434885898E+01, 5.6339658730E+00, 2.8584912064E+01, 4.2646128706E+00, 9.7771832546E-01],
	[3.9795000000E+04, 4.5444888669E+01, 5.6340083045E+00, 2.8596732218E+01, 4.2649883052E+00, 9.7772931033E-01],
	[3.9800000000E+04, 4.5454892385E+01, 5.6340507311E+00, 2.8608555773E+01, 4.2653636304E+00, 9.7774028924E-01],
	[3.9805000000E+04, 4.5464897046E+01, 5.6340931526E+00, 2.8620382730E+01, 4.2657388462E+00, 9.7775126219E-01],
	[3.9810000000E+04, 4.5474902652E+01, 5.6341355691E+00, 2.8632213089E+01, 4.2661139528E+00, 9.7776222919E-01],
	[3.9815000000E+04, 4.5484909202E+01, 5.6341779806E+00, 2.8644046851E+01, 4.2664889500E+00, 9.7777319024E-01],
	[3.9820000000E+04, 4.5494916698E+01, 5.6342203871E+00, 2.8655884017E+01, 4.2668638380E+00, 9.7778414534E-01],
	[3.9825000000E+04, 4.5504925139E+01, 5.6342627886E+00, 2.8667724586E+01, 4.2672386168E+00, 9.7779509449E-01],
	[3.9830000000E+04, 4.5514934524E+01, 5.6343051851E+00, 2.8679568560E+01, 4.2676132864E+00, 9.7780603771E-01],
	[3.9835000000E+04, 4.5524944855E+01, 5.6343475765E+00, 2.8691415940E+01, 4.2679878469E+00, 9.7781697499E-01],
	[3.9840000000E+04, 4.5534956130E+01, 5.6343899630E+00, 2.8703266724E+01, 4.2683622982E+00, 9.7782790634E-01],
	[3.9845000000E+04, 4.5544968350E+01, 5.6344323445E+00, 2.8715120915E+01, 4.2687366405E+00, 9.7783883175E-01],
	[3.9850000000E+04, 4.5554981515E+01, 5.6344747210E+00, 2.8726978513E+01, 4.2691108737E+00, 9.7784975124E-01],
	[3.9855000000E+04, 4.5564995624E+01, 5.6345170925E+00, 2.8738839517E+01, 4.2694849980E+00, 9.7786066481E-01],
	[3.9860000000E+04, 4.5575010678E+01, 5.6345594590E+00, 2.8750703930E+01, 4.2698590132E+00, 9.7787157245E-01],
	[3.9865000000E+04, 4.5585026677E+01, 5.6346018204E+00, 2.8762571751E+01, 4.2702329195E+00, 9.7788247418E-01],
	[3.9870000000E+04, 4.5595050781E+01, 5.6346448825E+00, 2.8774442981E+01, 4.2706071850E+00, 9.7789336999E-01],
	[3.9875000000E+04, 4.5605090904E+01, 5.6346894240E+00, 2.8786317620E+01, 4.2709823269E+00, 9.7790425989E-01],
	[3.9880000000E+04, 4.5615131978E+01, 5.6347339603E+00, 2.8798195669E+01, 4.2713573601E+00, 9.7791514388E-01],
	[3.9885000000E+04, 4.5625174004E+01, 5.6347784914E+00, 2.8810077129E+01, 4.2717322848E+00, 9.7792602197E-01],
	[3.9890000000E+04, 4.5635216981E+01, 5.6348230173E+00, 2.8821962000E+01, 4.2721071009E+00, 9.7793689416E-01],
	[3.9895000000E+04, 4.5645260909E+01, 5.6348675379E+00, 2.8833850283E+01, 4.2724818085E+00, 9.7794776045E-01],
	[3.9900000000E+04, 4.5655305789E+01, 5.6349120533E+00, 2.8845741978E+01, 4.2728564076E+00, 9.7795862085E-01],
	[3.9905000000E+04, 4.5665351621E+01, 5.6349565635E+00, 2.8857637086E+01, 4.2732308983E+00, 9.7796947536E-01],
	[3.9910000000E+04, 4.5675398404E+01, 5.6350010685E+00, 2.8869535607E+01, 4.2736052806E+00, 9.7798032398E-01],
	[3.9915000000E+04, 4.5685446138E+01, 5.6350455682E+00, 2.8881437542E+01, 4.2739795545E+00, 9.7799116671E-01],
	[3.9920000000E+04, 4.5695494824E+01, 5.6350900627E+00, 2.8893342891E+01, 4.2743537200E+00, 9.7800200357E-01],
	[3.9925000000E+04, 4.5705544461E+01, 5.6351345520E+00, 2.8905251655E+01, 4.2747277772E+00, 9.7801283454E-01],
	[3.9930000000E+04, 4.5715595049E+01, 5.6351790361E+00, 2.8917163835E+01, 4.2751017262E+00, 9.7802365965E-01],
	[3.9935000000E+04, 4.5725646588E+01, 5.6352235149E+00, 2.8929079431E+01, 4.2754755669E+00, 9.7803447888E-01],
	[3.9940000000E+04, 4.5735699079E+01, 5.6352679885E+00, 2.8940998444E+01, 4.2758492994E+00, 9.7804529224E-01],
	[3.9945000000E+04, 4.5745752521E+01, 5.6353124569E+00, 2.8952920873E+01, 4.2762229238E+00, 9.7805609974E-01],
	[3.9950000000E+04, 4.5755806914E+01, 5.6353569201E+00, 2.8964846721E+01, 4.2765964399E+00, 9.7806690138E-01],
	[3.9955000000E+04, 4.5765862258E+01, 5.6354013781E+00, 2.8976775987E+01, 4.2769698480E+00, 9.7807769716E-01],
	[3.9960000000E+04, 4.5775918553E+01, 5.6354458309E+00, 2.8988708671E+01, 4.2773431480E+00, 9.7808848708E-01],
	[3.9965000000E+04, 4.5785975800E+01, 5.6354902785E+00, 2.9000644775E+01, 4.2777163400E+00, 9.7809927116E-01],
	[3.9970000000E+04, 4.5796033997E+01, 5.6355347208E+00, 2.9012584299E+01, 4.2780894240E+00, 9.7811004938E-01],
	[3.9975000000E+04, 4.5806093145E+01, 5.6355791579E+00, 2.9024527244E+01, 4.2784624000E+00, 9.7812082177E-01],
	[3.9980000000E+04, 4.5816153245E+01, 5.6356235899E+00, 2.9036473609E+01, 4.2788352681E+00, 9.7813158831E-01],
	[3.9985000000E+04, 4.5826214295E+01, 5.6356680166E+00, 2.9048423396E+01, 4.2792080282E+00, 9.7814234901E-01],
	[3.9990000000E+04, 4.5836276296E+01, 5.6357124381E+00, 2.9060376605E+01, 4.2795806805E+00, 9.7815310388E-01],
	[3.9995000000E+04, 4.5846339249E+01, 5.6357568545E+00, 2.9072333237E+01, 4.2799532249E+00, 9.7816385291E-01],
	[4.0000000000E+04, 4.5856403152E+01, 5.6358012656E+00, 2.9084293292E+01, 4.2803256616E+00, 9.7817459612E-01],
	[4.0005000000E+04, 4.5866468006E+01, 5.6358456715E+00, 2.9096288080E+01, 4.2806986681E+00, 9.7818533351E-01],
	[4.0010000000E+04, 4.5876533810E+01, 5.6358900722E+00, 2.9108286313E+01, 4.2810715665E+00, 9.7819606507E-01],
	[4.0015000000E+04, 4.5886600566E+01, 5.6359344677E+00, 2.9120287993E+01, 4.2814443568E+00, 9.7820679081E-01],
	[4.0020000000E+04, 4.5896668272E+01, 5.6359788580E+00, 2.9132293121E+01, 4.2818170391E+00, 9.7821751074E-01],
	[4.0025000000E+04, 4.5906736929E+01, 5.6360232432E+00, 2.9144301697E+01, 4.2821896133E+00, 9.7822822486E-01],
	[4.0030000000E+04, 4.5916806537E+01, 5.6360676231E+00, 2.9156313722E+01, 4.2825620795E+00, 9.7823893317E-01],
	[4.0035000000E+04, 4.5926877095E+01, 5.6361119978E+00, 2.9168329195E+01, 4.2829344377E+00, 9.7824963567E-01],
	[4.0040000000E+04, 4.5936948604E+01, 5.6361563674E+00, 2.9180348119E+01, 4.2833066880E+00, 9.7826033237E-01],
	[4.0045000000E+04, 4.5947021063E+01, 5.6362007317E+00, 2.9192370492E+01, 4.2836788303E+00, 9.7827102328E-01],
	[4.0050000000E+04, 4.5957094474E+01, 5.6362450909E+00, 2.9204396317E+01, 4.2840508649E+00, 9.7828170838E-01],
	[4.0055000000E+04, 4.5967168834E+01, 5.6362894449E+00, 2.9216425593E+01, 4.2844227915E+00, 9.7829238770E-01],
	[4.0060000000E+04, 4.5977244146E+01, 5.6363337937E+00, 2.9228458320E+01, 4.2847946104E+00, 9.7830306123E-01],
	[4.0065000000E+04, 4.5987320407E+01, 5.6363781373E+00, 2.9240494501E+01, 4.2851663216E+00, 9.7831372897E-01],
	[4.0070000000E+04, 4.5997397619E+01, 5.6364224757E+00, 2.9252534134E+01, 4.2855379249E+00, 9.7832439093E-01],
	[4.0075000000E+04, 4.6007475782E+01, 5.6364668089E+00, 2.9264577221E+01, 4.2859094206E+00, 9.7833504711E-01],
	[4.0080000000E+04, 4.6017554895E+01, 5.6365111369E+00, 2.9276623762E+01, 4.2862808087E+00, 9.7834569752E-01],
	[4.0085000000E+04, 4.6027634958E+01, 5.6365554598E+00, 2.9288673758E+01, 4.2866520891E+00, 9.7835634215E-01],
	[4.0090000000E+04, 4.6037715972E+01, 5.6365997775E+00, 2.9300727210E+01, 4.2870232619E+00, 9.7836698102E-01],
	[4.0095000000E+04, 4.6047797936E+01, 5.6366440900E+00, 2.9312784117E+01, 4.2873943271E+00, 9.7837761412E-01],
	[4.0100000000E+04, 4.6057880851E+01, 5.6366883974E+00, 2.9324844480E+01, 4.2877652848E+00, 9.7838824146E-01],
	[4.0105000000E+04, 4.6067964715E+01, 5.6367326995E+00, 2.9336908301E+01, 4.2881361350E+00, 9.7839886304E-01],
	[4.0110000000E+04, 4.6078049530E+01, 5.6367769965E+00, 2.9348975579E+01, 4.2885068778E+00, 9.7840947886E-01],
	[4.0115000000E+04, 4.6088135295E+01, 5.6368212883E+00, 2.9361046315E+01, 4.2888775131E+00, 9.7842008893E-01],
	[4.0120000000E+04, 4.6098222010E+01, 5.6368655749E+00, 2.9373120510E+01, 4.2892480410E+00, 9.7843069325E-01],
	[4.0125000000E+04, 4.6108309676E+01, 5.6369098564E+00, 2.9385198164E+01, 4.2896184616E+00, 9.7844129182E-01],
	[4.0130000000E+04, 4.6118398291E+01, 5.6369541327E+00, 2.9397279278E+01, 4.2899887749E+00, 9.7845188466E-01],
	[4.0135000000E+04, 4.6128487857E+01, 5.6369984038E+00, 2.9409363852E+01, 4.2903589808E+00, 9.7846247175E-01],
	[4.0140000000E+04, 4.6138578373E+01, 5.6370426698E+00, 2.9421451888E+01, 4.2907290795E+00, 9.7847305311E-01],
	[4.0145000000E+04, 4.6148669838E+01, 5.6370869306E+00, 2.9433543384E+01, 4.2910990710E+00, 9.7848362873E-01],
	[4.0150000000E+04, 4.6158762254E+01, 5.6371311862E+00, 2.9445638343E+01, 4.2914689553E+00, 9.7849419863E-01],
	[4.0155000000E+04, 4.6168855620E+01, 5.6371754367E+00, 2.9457736764E+01, 4.2918387324E+00, 9.7850476279E-01],
	[4.0160000000E+04, 4.6178949935E+01, 5.6372196820E+00, 2.9469838648E+01, 4.2922084024E+00, 9.7851532124E-01],
	[4.0165000000E+04, 4.6189045201E+01, 5.6372639221E+00, 2.9481943996E+01, 4.2925779654E+00, 9.7852587396E-01],
	[4.0170000000E+04, 4.6199141416E+01, 5.6373081571E+00, 2.9494052809E+01, 4.2929474212E+00, 9.7853642097E-01],
	[4.0175000000E+04, 4.6209238581E+01, 5.6373523869E+00, 2.9506165086E+01, 4.2933167701E+00, 9.7854696227E-01],
	[4.0180000000E+04, 4.6219336697E+01, 5.6373966116E+00, 2.9518280828E+01, 4.2936860119E+00, 9.7855749786E-01],
	[4.0185000000E+04, 4.6229435761E+01, 5.6374408311E+00, 2.9530400037E+01, 4.2940551468E+00, 9.7856802774E-01],
	[4.0190000000E+04, 4.6239535776E+01, 5.6374850455E+00, 2.9542522712E+01, 4.2944241748E+00, 9.7857855191E-01],
	[4.0195000000E+04, 4.6249636741E+01, 5.6375292547E+00, 2.9554648854E+01, 4.2947930959E+00, 9.7858907039E-01],
	[4.0200000000E+04, 4.6259738655E+01, 5.6375734587E+00, 2.9566778463E+01, 4.2951619102E+00, 9.7859958317E-01],
	[4.0205000000E+04, 4.6269841518E+01, 5.6376176576E+00, 2.9578911541E+01, 4.2955306176E+00, 9.7861009025E-01],
	[4.0210000000E+04, 4.6279945332E+01, 5.6376618514E+00, 2.9591048088E+01, 4.2958992182E+00, 9.7862059165E-01],
	[4.0215000000E+04, 4.6290050095E+01, 5.6377060400E+00, 2.9603188104E+01, 4.2962677121E+00, 9.7863108736E-01],
	[4.0220000000E+04, 4.6300155808E+01, 5.6377502234E+00, 2.9615331589E+01, 4.2966360993E+00, 9.7864157738E-01],
	[4.0225000000E+04, 4.6310262470E+01, 5.6377944017E+00, 2.9627478546E+01, 4.2970043798E+00, 9.7865206173E-01],
	[4.0230000000E+04, 4.6320370082E+01, 5.6378385749E+00, 2.9639628973E+01, 4.2973725536E+00, 9.7866254039E-01],
	[4.0235000000E+04, 4.6330478643E+01, 5.6378827429E+00, 2.9651782871E+01, 4.2977406208E+00, 9.7867301339E-01],
	[4.0240000000E+04, 4.6340588154E+01, 5.6379269058E+00, 2.9663940242E+01, 4.2981085814E+00, 9.7868348071E-01],
	[4.0245000000E+04, 4.6350698614E+01, 5.6379710635E+00, 2.9676101086E+01, 4.2984764355E+00, 9.7869394236E-01],
	[4.0250000000E+04, 4.6360810024E+01, 5.6380152161E+00, 2.9688265402E+01, 4.2988441831E+00, 9.7870439835E-01],
	[4.0255000000E+04, 4.6370922383E+01, 5.6380593635E+00, 2.9700433193E+01, 4.2992118242E+00, 9.7871484868E-01],
	[4.0260000000E+04, 4.6381035691E+01, 5.6381035059E+00, 2.9712604457E+01, 4.2995793588E+00, 9.7872529336E-01],
	[4.0265000000E+04, 4.6391149949E+01, 5.6381476430E+00, 2.9724779197E+01, 4.2999467871E+00, 9.7873573237E-01],
	[4.0270000000E+04, 4.6401265156E+01, 5.6381917751E+00, 2.9736957412E+01, 4.3003141089E+00, 9.7874616574E-01],
	[4.0275000000E+04, 4.6411381313E+01, 5.6382359020E+00, 2.9749139103E+01, 4.3006813244E+00, 9.7875659346E-01],
	[4.0280000000E+04, 4.6421498418E+01, 5.6382800238E+00, 2.9761324271E+01, 4.3010484336E+00, 9.7876701553E-01],
	[4.0285000000E+04, 4.6431616473E+01, 5.6383241404E+00, 2.9773512916E+01, 4.3014154365E+00, 9.7877743197E-01],
	[4.0290000000E+04, 4.6441735477E+01, 5.6383682520E+00, 2.9785705039E+01, 4.3017823331E+00, 9.7878784276E-01],
	[4.0295000000E+04, 4.6451855430E+01, 5.6384123583E+00, 2.9797900640E+01, 4.3021491236E+00, 9.7879824792E-01],
	[4.0300000000E+04, 4.6461976333E+01, 5.6384564596E+00, 2.9810099719E+01, 4.3025158078E+00, 9.7880864745E-01],
	[4.0305000000E+04, 4.6472098184E+01, 5.6385005557E+00, 2.9822302278E+01, 4.3028823859E+00, 9.7881904135E-01],
	[4.0310000000E+04, 4.6482220985E+01, 5.6385446468E+00, 2.9834508317E+01, 4.3032488579E+00, 9.7882942962E-01],
	[4.0315000000E+04, 4.6492344734E+01, 5.6385887326E+00, 2.9846717837E+01, 4.3036152239E+00, 9.7883981227E-01],
	[4.0320000000E+04, 4.6502469433E+01, 5.6386328134E+00, 2.9858930838E+01, 4.3039814838E+00, 9.7885018931E-01],
	[4.0325000000E+04, 4.6512595080E+01, 5.6386768890E+00, 2.9871147320E+01, 4.3043476376E+00, 9.7886056073E-01],
	[4.0330000000E+04, 4.6522721677E+01, 5.6387209596E+00, 2.9883367284E+01, 4.3047136855E+00, 9.7887092653E-01],
	[4.0335000000E+04, 4.6532849222E+01, 5.6387650250E+00, 2.9895590731E+01, 4.3050796275E+00, 9.7888128673E-01],
	[4.0340000000E+04, 4.6542977717E+01, 5.6388090853E+00, 2.9907817662E+01, 4.3054454635E+00, 9.7889164132E-01],
	[4.0345000000E+04, 4.6553107160E+01, 5.6388531404E+00, 2.9920048076E+01, 4.3058111936E+00, 9.7890199031E-01],
	[4.0350000000E+04, 4.6563237552E+01, 5.6388971905E+00, 2.9932281975E+01, 4.3061768180E+00, 9.7891233370E-01],
	[4.0355000000E+04, 4.6573368893E+01, 5.6389412354E+00, 2.9944519359E+01, 4.3065423365E+00, 9.7892267150E-01],
	[4.0360000000E+04, 4.6583501183E+01, 5.6389852752E+00, 2.9956760228E+01, 4.3069077492E+00, 9.7893300370E-01],
	[4.0365000000E+04, 4.6593634421E+01, 5.6390293100E+00, 2.9969004583E+01, 4.3072730562E+00, 9.7894333031E-01],
	[4.0370000000E+04, 4.6603768609E+01, 5.6390733396E+00, 2.9981252425E+01, 4.3076382574E+00, 9.7895365134E-01],
	[4.0375000000E+04, 4.6613903745E+01, 5.6391173641E+00, 2.9993503755E+01, 4.3080033530E+00, 9.7896396678E-01],
	[4.0380000000E+04, 4.6624039829E+01, 5.6391613834E+00, 3.0005758572E+01, 4.3083683430E+00, 9.7897427665E-01],
	[4.0385000000E+04, 4.6634176862E+01, 5.6392053977E+00, 3.0018016877E+01, 4.3087332273E+00, 9.7898458093E-01],
	[4.0390000000E+04, 4.6644314844E+01, 5.6392494069E+00, 3.0030278672E+01, 4.3090980061E+00, 9.7899487965E-01],
	[4.0395000000E+04, 4.6654453775E+01, 5.6392934110E+00, 3.0042543955E+01, 4.3094626793E+00, 9.7900517279E-01],
	[4.0400000000E+04, 4.6664593654E+01, 5.6393374099E+00, 3.0054812729E+01, 4.3098272470E+00, 9.7901546037E-01],
	[4.0405000000E+04, 4.6674734481E+01, 5.6393814038E+00, 3.0067084994E+01, 4.3101917093E+00, 9.7902574238E-01],
	[4.0410000000E+04, 4.6684876258E+01, 5.6394253926E+00, 3.0079360749E+01, 4.3105560661E+00, 9.7903601883E-01],
	[4.0415000000E+04, 4.6695018982E+01, 5.6394693762E+00, 3.0091639997E+01, 4.3109203175E+00, 9.7904628973E-01],
	[4.0420000000E+04, 4.6705162655E+01, 5.6395133548E+00, 3.0103922736E+01, 4.3112844635E+00, 9.7905655507E-01],
	[4.0425000000E+04, 4.6715307277E+01, 5.6395573283E+00, 3.0116208969E+01, 4.3116485041E+00, 9.7906681486E-01],
	[4.0430000000E+04, 4.6725452846E+01, 5.6396012966E+00, 3.0128498695E+01, 4.3120124395E+00, 9.7907706911E-01],
	[4.0435000000E+04, 4.6735599365E+01, 5.6396452599E+00, 3.0140791914E+01, 4.3123762696E+00, 9.7908731781E-01],
	[4.0440000000E+04, 4.6745746831E+01, 5.6396892181E+00, 3.0153088629E+01, 4.3127399944E+00, 9.7909756097E-01],
	[4.0445000000E+04, 4.6755895246E+01, 5.6397331712E+00, 3.0165388838E+01, 4.3131036141E+00, 9.7910779859E-01],
	[4.0450000000E+04, 4.6766044609E+01, 5.6397771192E+00, 3.0177692543E+01, 4.3134671285E+00, 9.7911803068E-01],
	[4.0455000000E+04, 4.6776194920E+01, 5.6398210621E+00, 3.0189999745E+01, 4.3138305379E+00, 9.7912825723E-01],
	[4.0460000000E+04, 4.6786346180E+01, 5.6398649999E+00, 3.0202310443E+01, 4.3141938421E+00, 9.7913847826E-01],
	[4.0465000000E+04, 4.6796498388E+01, 5.6399089327E+00, 3.0214624638E+01, 4.3145570412E+00, 9.7914869376E-01],
	[4.0470000000E+04, 4.6806651544E+01, 5.6399528603E+00, 3.0226942331E+01, 4.3149201353E+00, 9.7915890375E-01],
	[4.0475000000E+04, 4.6816805648E+01, 5.6399967829E+00, 3.0239263523E+01, 4.3152831244E+00, 9.7916910821E-01],
	[4.0480000000E+04, 4.6826960700E+01, 5.6400407004E+00, 3.0251588214E+01, 4.3156460085E+00, 9.7917930716E-01],
	[4.0485000000E+04, 4.6837116700E+01, 5.6400846128E+00, 3.0263916404E+01, 4.3160087877E+00, 9.7918950059E-01],
	[4.0490000000E+04, 4.6847273648E+01, 5.6401285201E+00, 3.0276248094E+01, 4.3163714620E+00, 9.7919968852E-01],
	[4.0495000000E+04, 4.6857431545E+01, 5.6401724224E+00, 3.0288583285E+01, 4.3167340314E+00, 9.7920987094E-01],
	[4.0500000000E+04, 4.6867590389E+01, 5.6402163195E+00, 3.0300921978E+01, 4.3170964959E+00, 9.7922004786E-01],
	[4.0505000000E+04, 4.6877750181E+01, 5.6402602116E+00, 3.0313264172E+01, 4.3174588557E+00, 9.7923021928E-01],
	[4.0510000000E+04, 4.6887910922E+01, 5.6403040986E+00, 3.0325609868E+01, 4.3178211106E+00, 9.7924038521E-01],
	[4.0515000000E+04, 4.6898093799E+01, 5.6403500314E+00, 3.0337959068E+01, 4.3181846426E+00, 9.7925054564E-01],
	[4.0520000000E+04, 4.6908278588E+01, 5.6403960517E+00, 3.0350311771E+01, 4.3185481325E+00, 9.7926070058E-01],
	[4.0525000000E+04, 4.6918464333E+01, 5.6404420666E+00, 3.0362667978E+01, 4.3189115179E+00, 9.7927085004E-01],
	[4.0530000000E+04, 4.6928651032E+01, 5.6404880762E+00, 3.0375027690E+01, 4.3192747989E+00, 9.7928099401E-01],
	[4.0535000000E+04, 4.6938838685E+01, 5.6405340805E+00, 3.0387390907E+01, 4.3196379755E+00, 9.7929113250E-01],
	[4.0540000000E+04, 4.6949027294E+01, 5.6405800795E+00, 3.0399757629E+01, 4.3200010477E+00, 9.7930126552E-01],
	[4.0545000000E+04, 4.6959216856E+01, 5.6406260732E+00, 3.0412127858E+01, 4.3203640156E+00, 9.7931139306E-01],
	[4.0550000000E+04, 4.6969407374E+01, 5.6406720616E+00, 3.0424501594E+01, 4.3207268791E+00, 9.7932151514E-01],
	[4.0555000000E+04, 4.6979598846E+01, 5.6407180448E+00, 3.0436878837E+01, 4.3210896384E+00, 9.7933163174E-01],
	[4.0560000000E+04, 4.6989791272E+01, 5.6407640226E+00, 3.0449259588E+01, 4.3214522935E+00, 9.7934174289E-01],
	[4.0565000000E+04, 4.6999984653E+01, 5.6408099951E+00, 3.0461643848E+01, 4.3218148444E+00, 9.7935184857E-01],
	[4.0570000000E+04, 4.7010178989E+01, 5.6408559624E+00, 3.0474031617E+01, 4.3221772911E+00, 9.7936194879E-01],
	[4.0575000000E+04, 4.7020374279E+01, 5.6409019243E+00, 3.0486422895E+01, 4.3225396336E+00, 9.7937204356E-01],
	[4.0580000000E+04, 4.7030570523E+01, 5.6409478810E+00, 3.0498817684E+01, 4.3229018721E+00, 9.7938213288E-01],
	[4.0585000000E+04, 4.7040767722E+01, 5.6409938324E+00, 3.0511215984E+01, 4.3232640064E+00, 9.7939221676E-01],
	[4.0590000000E+04, 4.7050965875E+01, 5.6410397784E+00, 3.0523617794E+01, 4.3236260368E+00, 9.7940229518E-01],
	[4.0595000000E+04, 4.7061164983E+01, 5.6410857192E+00, 3.0536023117E+01, 4.3239879631E+00, 9.7941236817E-01],
	[4.0600000000E+04, 4.7071365044E+01, 5.6411316548E+00, 3.0548431953E+01, 4.3243497855E+00, 9.7942243572E-01],
	[4.0605000000E+04, 4.7081566060E+01, 5.6411775850E+00, 3.0560844301E+01, 4.3247115039E+00, 9.7943249783E-01],
	[4.0610000000E+04, 4.7091768030E+01, 5.6412235100E+00, 3.0573260163E+01, 4.3250731184E+00, 9.7944255451E-01],
	[4.0615000000E+04, 4.7101970955E+01, 5.6412694296E+00, 3.0585679539E+01, 4.3254346290E+00, 9.7945260576E-01],
	[4.0620000000E+04, 4.7112174834E+01, 5.6413153440E+00, 3.0598102430E+01, 4.3257960358E+00, 9.7946265159E-01],
	[4.0625000000E+04, 4.7122379666E+01, 5.6413612531E+00, 3.0610528836E+01, 4.3261573388E+00, 9.7947269200E-01],
	[4.0630000000E+04, 4.7132585453E+01, 5.6414071570E+00, 3.0622958758E+01, 4.3265185380E+00, 9.7948272698E-01],
	[4.0635000000E+04, 4.7142792194E+01, 5.6414530556E+00, 3.0635392196E+01, 4.3268796335E+00, 9.7949275655E-01],
	[4.0640000000E+04, 4.7152999889E+01, 5.6414989489E+00, 3.0647829152E+01, 4.3272406252E+00, 9.7950278071E-01],
	[4.0645000000E+04, 4.7163208539E+01, 5.6415448369E+00, 3.0660269625E+01, 4.3276015133E+00, 9.7951279946E-01],
	[4.0650000000E+04, 4.7173418142E+01, 5.6415907196E+00, 3.0672713616E+01, 4.3279622978E+00, 9.7952281280E-01],
	[4.0655000000E+04, 4.7183628699E+01, 5.6416365971E+00, 3.0685161125E+01, 4.3283229786E+00, 9.7953282074E-01],
	[4.0660000000E+04, 4.7193840210E+01, 5.6416824693E+00, 3.0697612154E+01, 4.3286835559E+00, 9.7954282328E-01],
	[4.0665000000E+04, 4.7204052675E+01, 5.6417283363E+00, 3.0710066703E+01, 4.3290440296E+00, 9.7955282042E-01],
	[4.0670000000E+04, 4.7214266094E+01, 5.6417741979E+00, 3.0722524772E+01, 4.3294043998E+00, 9.7956281217E-01],
	[4.0675000000E+04, 4.7224480467E+01, 5.6418200543E+00, 3.0734986362E+01, 4.3297646665E+00, 9.7957279852E-01],
	[4.0680000000E+04, 4.7234695793E+01, 5.6418659055E+00, 3.0747451473E+01, 4.3301248298E+00, 9.7958277950E-01],
	[4.0685000000E+04, 4.7244912074E+01, 5.6419117514E+00, 3.0759920107E+01, 4.3304848896E+00, 9.7959275508E-01],
	[4.0690000000E+04, 4.7255129308E+01, 5.6419575920E+00, 3.0772392263E+01, 4.3308448461E+00, 9.7960272529E-01],
	[4.0695000000E+04, 4.7265347496E+01, 5.6420034274E+00, 3.0784867942E+01, 4.3312046992E+00, 9.7961269012E-01],
	[4.0700000000E+04, 4.7275566638E+01, 5.6420492575E+00, 3.0797347145E+01, 4.3315644491E+00, 9.7962264957E-01],
	[4.0705000000E+04, 4.7285786733E+01, 5.6420950823E+00, 3.0809829872E+01, 4.3319240956E+00, 9.7963260365E-01],
	[4.0710000000E+04, 4.7296007783E+01, 5.6421409019E+00, 3.0822316124E+01, 4.3322836389E+00, 9.7964255237E-01],
	[4.0715000000E+04, 4.7306229785E+01, 5.6421867162E+00, 3.0834805901E+01, 4.3326430790E+00, 9.7965249572E-01],
	[4.0720000000E+04, 4.7316452742E+01, 5.6422325253E+00, 3.0847299205E+01, 4.3330024159E+00, 9.7966243371E-01],
	[4.0725000000E+04, 4.7326676652E+01, 5.6422783291E+00, 3.0859796035E+01, 4.3333616496E+00, 9.7967236634E-01],
	[4.0730000000E+04, 4.7336901515E+01, 5.6423241277E+00, 3.0872296392E+01, 4.3337207803E+00, 9.7968229361E-01],
	[4.0735000000E+04, 4.7347127332E+01, 5.6423699210E+00, 3.0884800276E+01, 4.3340798078E+00, 9.7969221553E-01],
	[4.0740000000E+04, 4.7357354103E+01, 5.6424157091E+00, 3.0897307689E+01, 4.3344387323E+00, 9.7970213210E-01],
	[4.0745000000E+04, 4.7367581827E+01, 5.6424614919E+00, 3.0909818631E+01, 4.3347975538E+00, 9.7971204333E-01],
	[4.0750000000E+04, 4.7377810505E+01, 5.6425072695E+00, 3.0922333102E+01, 4.3351562723E+00, 9.7972194921E-01],
	[4.0755000000E+04, 4.7388040136E+01, 5.6425530419E+00, 3.0934851103E+01, 4.3355148878E+00, 9.7973184976E-01],
	[4.0760000000E+04, 4.7398270720E+01, 5.6425988090E+00, 3.0947372634E+01, 4.3358734004E+00, 9.7974174497E-01],
	[4.0765000000E+04, 4.7408502258E+01, 5.6426445708E+00, 3.0959897696E+01, 4.3362318102E+00, 9.7975163484E-01],
	[4.0770000000E+04, 4.7418734749E+01, 5.6426903274E+00, 3.0972426290E+01, 4.3365901170E+00, 9.7976151938E-01],
	[4.0775000000E+04, 4.7428968193E+01, 5.6427360788E+00, 3.0984958416E+01, 4.3369483211E+00, 9.7977139860E-01],
	[4.0780000000E+04, 4.7439202591E+01, 5.6427818249E+00, 3.0997494075E+01, 4.3373064224E+00, 9.7978127250E-01],
	[4.0785000000E+04, 4.7449437942E+01, 5.6428275658E+00, 3.1010033267E+01, 4.3376644209E+00, 9.7979114107E-01],
	[4.0790000000E+04, 4.7459674246E+01, 5.6428733015E+00, 3.1022575993E+01, 4.3380223167E+00, 9.7980100432E-01],
	[4.0795000000E+04, 4.7469911504E+01, 5.6429190319E+00, 3.1035122253E+01, 4.3383801098E+00, 9.7981086226E-01],
	[4.0800000000E+04, 4.7480149714E+01, 5.6429647571E+00, 3.1047672049E+01, 4.3387378002E+00, 9.7982071489E-01],
	[4.0805000000E+04, 4.7490388878E+01, 5.6430104770E+00, 3.1060225380E+01, 4.3390953880E+00, 9.7983056222E-01],
	[4.0810000000E+04, 4.7500628995E+01, 5.6430561918E+00, 3.1072782246E+01, 4.3394528733E+00, 9.7984040423E-01],
	[4.0815000000E+04, 4.7510870065E+01, 5.6431019012E+00, 3.1085342650E+01, 4.3398102559E+00, 9.7985024095E-01],
	[4.0820000000E+04, 4.7521112088E+01, 5.6431476055E+00, 3.1097906591E+01, 4.3401675361E+00, 9.7986007237E-01],
	[4.0825000000E+04, 4.7531355063E+01, 5.6431933045E+00, 3.1110474069E+01, 4.3405247137E+00, 9.7986989849E-01],
	[4.0830000000E+04, 4.7541598992E+01, 5.6432389983E+00, 3.1123045086E+01, 4.3408817889E+00, 9.7987971932E-01],
	[4.0835000000E+04, 4.7551843874E+01, 5.6432846869E+00, 3.1135619642E+01, 4.3412387616E+00, 9.7988953486E-01],
	[4.0840000000E+04, 4.7562089709E+01, 5.6433303703E+00, 3.1148197737E+01, 4.3415956320E+00, 9.7989934511E-01],
	[4.0845000000E+04, 4.7572336497E+01, 5.6433760484E+00, 3.1160779372E+01, 4.3419524000E+00, 9.7990915008E-01],
	[4.0850000000E+04, 4.7582584238E+01, 5.6434217213E+00, 3.1173364548E+01, 4.3423090657E+00, 9.7991894977E-01],
	[4.0855000000E+04, 4.7592832932E+01, 5.6434673890E+00, 3.1185953265E+01, 4.3426656290E+00, 9.7992874419E-01],
	[4.0860000000E+04, 4.7603082578E+01, 5.6435130515E+00, 3.1198545524E+01, 4.3430220902E+00, 9.7993853333E-01],
	[4.0865000000E+04, 4.7613333177E+01, 5.6435587088E+00, 3.1211141325E+01, 4.3433784490E+00, 9.7994831720E-01],
	[4.0870000000E+04, 4.7623584729E+01, 5.6436043608E+00, 3.1223740668E+01, 4.3437347057E+00, 9.7995809580E-01],
	[4.0875000000E+04, 4.7633837234E+01, 5.6436500076E+00, 3.1236343556E+01, 4.3440908602E+00, 9.7996786914E-01],
	[4.0880000000E+04, 4.7644090691E+01, 5.6436956492E+00, 3.1248949987E+01, 4.3444469126E+00, 9.7997763722E-01],
	[4.0885000000E+04, 4.7654345102E+01, 5.6437412856E+00, 3.1261559962E+01, 4.3448028629E+00, 9.7998740004E-01],
	[4.0890000000E+04, 4.7664600464E+01, 5.6437869168E+00, 3.1274173483E+01, 4.3451587111E+00, 9.7999715761E-01],
	[4.0895000000E+04, 4.7674856780E+01, 5.6438325428E+00, 3.1286790549E+01, 4.3455144572E+00, 9.8000690992E-01],
	[4.0900000000E+04, 4.7685114048E+01, 5.6438781636E+00, 3.1299411162E+01, 4.3458701014E+00, 9.8001665699E-01],
	[4.0905000000E+04, 4.7695372269E+01, 5.6439237791E+00, 3.1312035321E+01, 4.3462256436E+00, 9.8002639881E-01],
	[4.0910000000E+04, 4.7705631442E+01, 5.6439693895E+00, 3.1324663028E+01, 4.3465810838E+00, 9.8003613539E-01],
	[4.0915000000E+04, 4.7715891568E+01, 5.6440149946E+00, 3.1337294283E+01, 4.3469364222E+00, 9.8004586673E-01],
	[4.0920000000E+04, 4.7726152646E+01, 5.6440605946E+00, 3.1349929086E+01, 4.3472916587E+00, 9.8005559284E-01],
	[4.0925000000E+04, 4.7736414677E+01, 5.6441061893E+00, 3.1362567438E+01, 4.3476467933E+00, 9.8006531371E-01],
	[4.0930000000E+04, 4.7746677660E+01, 5.6441517788E+00, 3.1375209340E+01, 4.3480018261E+00, 9.8007502935E-01],
	[4.0935000000E+04, 4.7756941596E+01, 5.6441973632E+00, 3.1387854792E+01, 4.3483567572E+00, 9.8008473977E-01],
	[4.0940000000E+04, 4.7767206484E+01, 5.6442429423E+00, 3.1400503794E+01, 4.3487115865E+00, 9.8009444496E-01],
	[4.0945000000E+04, 4.7777472324E+01, 5.6442885162E+00, 3.1413156348E+01, 4.3490663141E+00, 9.8010414493E-01],
	[4.0950000000E+04, 4.7787739117E+01, 5.6443340850E+00, 3.1425812454E+01, 4.3494209400E+00, 9.8011383969E-01],
	[4.0955000000E+04, 4.7798006862E+01, 5.6443796485E+00, 3.1438472112E+01, 4.3497754643E+00, 9.8012352923E-01],
	[4.0960000000E+04, 4.7808275559E+01, 5.6444252069E+00, 3.1451135323E+01, 4.3501298869E+00, 9.8013321356E-01],
	[4.0965000000E+04, 4.7818545208E+01, 5.6444707600E+00, 3.1463802087E+01, 4.3504842080E+00, 9.8014289268E-01],
	[4.0970000000E+04, 4.7828815810E+01, 5.6445163080E+00, 3.1476472406E+01, 4.3508384275E+00, 9.8015256660E-01],
	[4.0975000000E+04, 4.7839087364E+01, 5.6445618508E+00, 3.1489146279E+01, 4.3511925455E+00, 9.8016223532E-01],
	[4.0980000000E+04, 4.7849359870E+01, 5.6446073884E+00, 3.1501823708E+01, 4.3515465621E+00, 9.8017189883E-01],
	[4.0985000000E+04, 4.7859633328E+01, 5.6446529208E+00, 3.1514504692E+01, 4.3519004772E+00, 9.8018155716E-01],
	[4.0990000000E+04, 4.7869907739E+01, 5.6446984480E+00, 3.1527189233E+01, 4.3522542908E+00, 9.8019121029E-01],
	[4.0995000000E+04, 4.7880183101E+01, 5.6447439700E+00, 3.1539877331E+01, 4.3526080031E+00, 9.8020085823E-01],
	[4.1000000000E+04, 4.7890459415E+01, 5.6447894868E+00, 3.1552568986E+01, 4.3529616140E+00, 9.8021050099E-01],
	[4.1005000000E+04, 4.7900736682E+01, 5.6448349985E+00, 3.1565264199E+01, 4.3533151236E+00, 9.8022013856E-01],
	[4.1010000000E+04, 4.7911014900E+01, 5.6448805050E+00, 3.1577962971E+01, 4.3536685320E+00, 9.8022977095E-01],
	[4.1015000000E+04, 4.7921294071E+01, 5.6449260062E+00, 3.1590665301E+01, 4.3540218390E+00, 9.8023939817E-01],
	[4.1020000000E+04, 4.7931574193E+01, 5.6449715024E+00, 3.1603371192E+01, 4.3543750449E+00, 9.8024902021E-01],
	[4.1025000000E+04, 4.7941855267E+01, 5.6450169933E+00, 3.1616080643E+01, 4.3547281495E+00, 9.8025863708E-01],
	[4.1030000000E+04, 4.7952137294E+01, 5.6450624790E+00, 3.1628793655E+01, 4.3550811530E+00, 9.8026824879E-01],
	[4.1035000000E+04, 4.7962420272E+01, 5.6451079596E+00, 3.1641510228E+01, 4.3554340554E+00, 9.8027785533E-01],
	[4.1040000000E+04, 4.7972704202E+01, 5.6451534350E+00, 3.1654230363E+01, 4.3557868567E+00, 9.8028745671E-01],
	[4.1045000000E+04, 4.7982989083E+01, 5.6451989053E+00, 3.1666954061E+01, 4.3561395569E+00, 9.8029705293E-01],
	[4.1050000000E+04, 4.7993274917E+01, 5.6452443703E+00, 3.1679681321E+01, 4.3564921561E+00, 9.8030664399E-01],
	[4.1055000000E+04, 4.8003561702E+01, 5.6452898302E+00, 3.1692412146E+01, 4.3568446543E+00, 9.8031622991E-01],
	[4.1060000000E+04, 4.8013849439E+01, 5.6453352849E+00, 3.1705146535E+01, 4.3571970515E+00, 9.8032581068E-01],
	[4.1065000000E+04, 4.8024138127E+01, 5.6453807345E+00, 3.1717884488E+01, 4.3575493478E+00, 9.8033538630E-01],
	[4.1070000000E+04, 4.8034427768E+01, 5.6454261788E+00, 3.1730626007E+01, 4.3579015432E+00, 9.8034495677E-01],
	[4.1075000000E+04, 4.8044718359E+01, 5.6454716181E+00, 3.1743371092E+01, 4.3582536377E+00, 9.8035452211E-01],
	[4.1080000000E+04, 4.8055009903E+01, 5.6455170521E+00, 3.1756119743E+01, 4.3586056314E+00, 9.8036408231E-01],
	[4.1085000000E+04, 4.8065302398E+01, 5.6455624810E+00, 3.1768871961E+01, 4.3589575243E+00, 9.8037363738E-01],
	[4.1090000000E+04, 4.8075595845E+01, 5.6456079047E+00, 3.1781627747E+01, 4.3593093164E+00, 9.8038318732E-01],
	[4.1095000000E+04, 4.8085890243E+01, 5.6456533233E+00, 3.1794387101E+01, 4.3596610078E+00, 9.8039273213E-01],
	[4.1100000000E+04, 4.8096185592E+01, 5.6456987367E+00, 3.1807150024E+01, 4.3600125985E+00, 9.8040227182E-01],
	[4.1105000000E+04, 4.8106481894E+01, 5.6457441449E+00, 3.1819916516E+01, 4.3603640885E+00, 9.8041180638E-01],
	[4.1110000000E+04, 4.8116779146E+01, 5.6457895480E+00, 3.1832686578E+01, 4.3607154779E+00, 9.8042133583E-01],
	[4.1115000000E+04, 4.8127077350E+01, 5.6458349459E+00, 3.1845460210E+01, 4.3610667666E+00, 9.8043086016E-01],
	[4.1120000000E+04, 4.8137376505E+01, 5.6458803387E+00, 3.1858237414E+01, 4.3614179548E+00, 9.8044037939E-01],
	[4.1125000000E+04, 4.8147676612E+01, 5.6459257263E+00, 3.1871018189E+01, 4.3617690425E+00, 9.8044989350E-01],
	[4.1130000000E+04, 4.8157977670E+01, 5.6459711088E+00, 3.1883802536E+01, 4.3621200296E+00, 9.8045940250E-01],
	[4.1135000000E+04, 4.8168279679E+01, 5.6460164861E+00, 3.1896590456E+01, 4.3624709163E+00, 9.8046890641E-01],
	[4.1140000000E+04, 4.8178582640E+01, 5.6460618582E+00, 3.1909381949E+01, 4.3628217025E+00, 9.8047840521E-01],
	[4.1145000000E+04, 4.8188886552E+01, 5.6461072252E+00, 3.1922177016E+01, 4.3631723883E+00, 9.8048789892E-01],
	[4.1150000000E+04, 4.8199191415E+01, 5.6461525871E+00, 3.1934975657E+01, 4.3635229737E+00, 9.8049738754E-01],
	[4.1155000000E+04, 4.8209497229E+01, 5.6461979438E+00, 3.1947777873E+01, 4.3638734588E+00, 9.8050687106E-01],
	[4.1160000000E+04, 4.8219803995E+01, 5.6462432954E+00, 3.1960583665E+01, 4.3642238435E+00, 9.8051634950E-01],
	[4.1165000000E+04, 4.8230123313E+01, 5.6462897435E+00, 3.1973393033E+01, 4.3645748813E+00, 9.8052582286E-01],
	[4.1170000000E+04, 4.8240454088E+01, 5.6463371835E+00, 3.1986205977E+01, 4.3649265008E+00, 9.8053529113E-01],
	[4.1175000000E+04, 4.8250785821E+01, 5.6463846181E+00, 3.1999022498E+01, 4.3652780202E+00, 9.8054475432E-01],
	[4.1180000000E+04, 4.8261118511E+01, 5.6464320474E+00, 3.2011842598E+01, 4.3656294397E+00, 9.8055421244E-01],
	[4.1185000000E+04, 4.8271452160E+01, 5.6464794713E+00, 3.2024666275E+01, 4.3659807592E+00, 9.8056366548E-01],
	[4.1190000000E+04, 4.8281786766E+01, 5.6465268898E+00, 3.2037493532E+01, 4.3663319787E+00, 9.8057311346E-01],
	[4.1195000000E+04, 4.8292122330E+01, 5.6465743030E+00, 3.2050324368E+01, 4.3666830984E+00, 9.8058255636E-01],
	[4.1200000000E+04, 4.8302458852E+01, 5.6466217108E+00, 3.2063158784E+01, 4.3670341182E+00, 9.8059199420E-01],
	[4.1205000000E+04, 4.8312796331E+01, 5.6466691133E+00, 3.2075996781E+01, 4.3673850381E+00, 9.8060142698E-01],
	[4.1210000000E+04, 4.8323134768E+01, 5.6467165104E+00, 3.2088838358E+01, 4.3677358583E+00, 9.8061085470E-01],
	[4.1215000000E+04, 4.8333474163E+01, 5.6467639022E+00, 3.2101683518E+01, 4.3680865786E+00, 9.8062027736E-01],
	[4.1220000000E+04, 4.8343814515E+01, 5.6468112886E+00, 3.2114532260E+01, 4.3684371993E+00, 9.8062969496E-01],
	[4.1225000000E+04, 4.8354155825E+01, 5.6468586696E+00, 3.2127384584E+01, 4.3687877202E+00, 9.8063910752E-01],
	[4.1230000000E+04, 4.8364498092E+01, 5.6469060454E+00, 3.2140240492E+01, 4.3691381414E+00, 9.8064851503E-01],
	[4.1235000000E+04, 4.8374841317E+01, 5.6469534157E+00, 3.2153099984E+01, 4.3694884630E+00, 9.8065791749E-01],
	[4.1240000000E+04, 4.8385185500E+01, 5.6470007807E+00, 3.2165963061E+01, 4.3698386849E+00, 9.8066731490E-01],
	[4.1245000000E+04, 4.8395530640E+01, 5.6470481404E+00, 3.2178829722E+01, 4.3701888073E+00, 9.8067670728E-01],
	[4.1250000000E+04, 4.8405876737E+01, 5.6470954948E+00, 3.2191699969E+01, 4.3705388302E+00, 9.8068609462E-01],
	[4.1255000000E+04, 4.8416223792E+01, 5.6471428437E+00, 3.2204573803E+01, 4.3708887535E+00, 9.8069547692E-01],
	[4.1260000000E+04, 4.8426571804E+01, 5.6471901874E+00, 3.2217451223E+01, 4.3712385773E+00, 9.8070485419E-01],
	[4.1265000000E+04, 4.8436920773E+01, 5.6472375257E+00, 3.2230332231E+01, 4.3715883017E+00, 9.8071422643E-01],
	[4.1270000000E+04, 4.8447270700E+01, 5.6472848587E+00, 3.2243216826E+01, 4.3719379266E+00, 9.8072359365E-01],
	[4.1275000000E+04, 4.8457621584E+01, 5.6473321863E+00, 3.2256105010E+01, 4.3722874522E+00, 9.8073295584E-01],
	[4.1280000000E+04, 4.8467973426E+01, 5.6473795086E+00, 3.2268996783E+01, 4.3726368784E+00, 9.8074231301E-01],
	[4.1285000000E+04, 4.8478326225E+01, 5.6474268255E+00, 3.2281892146E+01, 4.3729862053E+00, 9.8075166516E-01],
	[4.1290000000E+04, 4.8488679980E+01, 5.6474741372E+00, 3.2294791099E+01, 4.3733354328E+00, 9.8076101229E-01],
	[4.1295000000E+04, 4.8499034693E+01, 5.6475214435E+00, 3.2307693642E+01, 4.3736845611E+00, 9.8077035441E-01],
	[4.1300000000E+04, 4.8509390364E+01, 5.6475687444E+00, 3.2320599777E+01, 4.3740335902E+00, 9.8077969152E-01],
	[4.1305000000E+04, 4.8519746991E+01, 5.6476160401E+00, 3.2333509504E+01, 4.3743825201E+00, 9.8078902362E-01],
	[4.1310000000E+04, 4.8530104576E+01, 5.6476633304E+00, 3.2346422823E+01, 4.3747313508E+00, 9.8079835072E-01],
	[4.1315000000E+04, 4.8540463117E+01, 5.6477106153E+00, 3.2359339735E+01, 4.3750800824E+00, 9.8080767282E-01],
	[4.1320000000E+04, 4.8550822616E+01, 5.6477578950E+00, 3.2372260241E+01, 4.3754287149E+00, 9.8081698991E-01],
	[4.1325000000E+04, 4.8561183071E+01, 5.6478051693E+00, 3.2385184340E+01, 4.3757772483E+00, 9.8082630201E-01],
	[4.1330000000E+04, 4.8571544484E+01, 5.6478524383E+00, 3.2398112035E+01, 4.3761256826E+00, 9.8083560911E-01],
	[4.1335000000E+04, 4.8581906854E+01, 5.6478997020E+00, 3.2411043325E+01, 4.3764740180E+00, 9.8084491123E-01],
	[4.1340000000E+04, 4.8592270180E+01, 5.6479469603E+00, 3.2423978210E+01, 4.3768222543E+00, 9.8085420835E-01],
	[4.1345000000E+04, 4.8602634464E+01, 5.6479942134E+00, 3.2436916692E+01, 4.3771703918E+00, 9.8086350049E-01],
	[4.1350000000E+04, 4.8612999704E+01, 5.6480414611E+00, 3.2449858771E+01, 4.3775184303E+00, 9.8087278764E-01],
	[4.1355000000E+04, 4.8623365901E+01, 5.6480887035E+00, 3.2462804447E+01, 4.3778663699E+00, 9.8088206982E-01],
	[4.1360000000E+04, 4.8633733055E+01, 5.6481359406E+00, 3.2475753722E+01, 4.3782142107E+00, 9.8089134702E-01],
	[4.1365000000E+04, 4.8644101166E+01, 5.6481831724E+00, 3.2488706595E+01, 4.3785619527E+00, 9.8090061924E-01],
	[4.1370000000E+04, 4.8654470234E+01, 5.6482303988E+00, 3.2501663067E+01, 4.3789095958E+00, 9.8090988649E-01],
	[4.1375000000E+04, 4.8664840258E+01, 5.6482776199E+00, 3.2514623140E+01, 4.3792571403E+00, 9.8091914877E-01],
	[4.1380000000E+04, 4.8675211239E+01, 5.6483248358E+00, 3.2527586812E+01, 4.3796045860E+00, 9.8092840608E-01],
	[4.1385000000E+04, 4.8685583177E+01, 5.6483720463E+00, 3.2540554085E+01, 4.3799519330E+00, 9.8093765843E-01],
	[4.1390000000E+04, 4.8695956072E+01, 5.6484192515E+00, 3.2553524960E+01, 4.3802991813E+00, 9.8094690582E-01],
	[4.1395000000E+04, 4.8706329923E+01, 5.6484664514E+00, 3.2566499437E+01, 4.3806463311E+00, 9.8095614824E-01],
	[4.1400000000E+04, 4.8716704731E+01, 5.6485136460E+00, 3.2579477516E+01, 4.3809933822E+00, 9.8096538572E-01],
	[4.1405000000E+04, 4.8727080495E+01, 5.6485608353E+00, 3.2592459199E+01, 4.3813403347E+00, 9.8097461824E-01],
	[4.1410000000E+04, 4.8737457216E+01, 5.6486080193E+00, 3.2605444485E+01, 4.3816871888E+00, 9.8098384580E-01],
	[4.1415000000E+04, 4.8747834893E+01, 5.6486551980E+00, 3.2618433376E+01, 4.3820339443E+00, 9.8099306843E-01],
	[4.1420000000E+04, 4.8758213527E+01, 5.6487023714E+00, 3.2631425871E+01, 4.3823806014E+00, 9.8100228610E-01],
	[4.1425000000E+04, 4.8768593118E+01, 5.6487495394E+00, 3.2644421972E+01, 4.3827271600E+00, 9.8101149883E-01],
	[4.1430000000E+04, 4.8778973665E+01, 5.6487967022E+00, 3.2657421679E+01, 4.3830736202E+00, 9.8102070663E-01],
	[4.1435000000E+04, 4.8789355168E+01, 5.6488438597E+00, 3.2670424992E+01, 4.3834199821E+00, 9.8102990949E-01],
	[4.1440000000E+04, 4.8799737628E+01, 5.6488910119E+00, 3.2683431913E+01, 4.3837662456E+00, 9.8103910741E-01],
	[4.1445000000E+04, 4.8810121044E+01, 5.6489381588E+00, 3.2696442441E+01, 4.3841124108E+00, 9.8104830040E-01],
	[4.1450000000E+04, 4.8820505416E+01, 5.6489853004E+00, 3.2709456578E+01, 4.3844584777E+00, 9.8105748846E-01],
	[4.1455000000E+04, 4.8830890745E+01, 5.6490324367E+00, 3.2722474323E+01, 4.3848044464E+00, 9.8106667160E-01],
	[4.1460000000E+04, 4.8841277030E+01, 5.6490795677E+00, 3.2735495678E+01, 4.3851503168E+00, 9.8107584981E-01],
	[4.1465000000E+04, 4.8851664271E+01, 5.6491266934E+00, 3.2748520642E+01, 4.3854960891E+00, 9.8108502311E-01],
	[4.1470000000E+04, 4.8862052469E+01, 5.6491738139E+00, 3.2761549217E+01, 4.3858417632E+00, 9.8109419148E-01],
	[4.1475000000E+04, 4.8872441623E+01, 5.6492209290E+00, 3.2774581403E+01, 4.3861873392E+00, 9.8110335494E-01],
	[4.1480000000E+04, 4.8882831733E+01, 5.6492680389E+00, 3.2787617201E+01, 4.3865328171E+00, 9.8111251349E-01],
	[4.1485000000E+04, 4.8893222799E+01, 5.6493151435E+00, 3.2800656611E+01, 4.3868781970E+00, 9.8112166712E-01],
	[4.1490000000E+04, 4.8903614821E+01, 5.6493622428E+00, 3.2813699634E+01, 4.3872234788E+00, 9.8113081585E-01],
	[4.1495000000E+04, 4.8914007799E+01, 5.6494093368E+00, 3.2826746270E+01, 4.3875686626E+00, 9.8113995968E-01],
	[4.1500000000E+04, 4.8924401734E+01, 5.6494564255E+00, 3.2839796520E+01, 4.3879137485E+00, 9.8114909861E-01],
	[4.1505000000E+04, 4.8934796624E+01, 5.6495035089E+00, 3.2852850384E+01, 4.3882587365E+00, 9.8115823263E-01],
	[4.1510000000E+04, 4.8945192471E+01, 5.6495505871E+00, 3.2865907864E+01, 4.3886036265E+00, 9.8116736176E-01],
	[4.1515000000E+04, 4.8955589273E+01, 5.6495976600E+00, 3.2878968959E+01, 4.3889484187E+00, 9.8117648600E-01],
	[4.1520000000E+04, 4.8965987031E+01, 5.6496447276E+00, 3.2892033670E+01, 4.3892931130E+00, 9.8118560534E-01],
	[4.1525000000E+04, 4.8976385746E+01, 5.6496917899E+00, 3.2905101998E+01, 4.3896377096E+00, 9.8119471980E-01],
	[4.1530000000E+04, 4.8986785416E+01, 5.6497388470E+00, 3.2918173943E+01, 4.3899822083E+00, 9.8120382937E-01],
	[4.1535000000E+04, 4.8997186042E+01, 5.6497858988E+00, 3.2931249506E+01, 4.3903266094E+00, 9.8121293406E-01],
	[4.1540000000E+04, 4.9007587624E+01, 5.6498329453E+00, 3.2944328687E+01, 4.3906709127E+00, 9.8122203387E-01],
	[4.1545000000E+04, 4.9017990162E+01, 5.6498799866E+00, 3.2957411488E+01, 4.3910151183E+00, 9.8123112880E-01],
	[4.1550000000E+04, 4.9028393655E+01, 5.6499270225E+00, 3.2970497908E+01, 4.3913592263E+00, 9.8124021886E-01],
	[4.1555000000E+04, 4.9038798105E+01, 5.6499740532E+00, 3.2983587948E+01, 4.3917032367E+00, 9.8124930405E-01],
	[4.1560000000E+04, 4.9049203510E+01, 5.6500210787E+00, 3.2996681609E+01, 4.3920471495E+00, 9.8125838437E-01],
	[4.1565000000E+04, 4.9059609871E+01, 5.6500680989E+00, 3.3009778891E+01, 4.3923909647E+00, 9.8126745982E-01],
	[4.1570000000E+04, 4.9070017187E+01, 5.6501151138E+00, 3.3022879795E+01, 4.3927346824E+00, 9.8127653040E-01],
	[4.1575000000E+04, 4.9080425459E+01, 5.6501621234E+00, 3.3035984321E+01, 4.3930783026E+00, 9.8128559613E-01],
	[4.1580000000E+04, 4.9090834687E+01, 5.6502091278E+00, 3.3049092470E+01, 4.3934218254E+00, 9.8129465700E-01],
	[4.1585000000E+04, 4.9101244871E+01, 5.6502561269E+00, 3.3062204243E+01, 4.3937652508E+00, 9.8130371301E-01],
	[4.1590000000E+04, 4.9111656010E+01, 5.6503031208E+00, 3.3075319640E+01, 4.3941085787E+00, 9.8131276417E-01],
	[4.1595000000E+04, 4.9122068104E+01, 5.6503501094E+00, 3.3088438661E+01, 4.3944518093E+00, 9.8132181048E-01],
	[4.1600000000E+04, 4.9132481154E+01, 5.6503970927E+00, 3.3101561308E+01, 4.3947949426E+00, 9.8133085195E-01],
	[4.1605000000E+04, 4.9142895160E+01, 5.6504440708E+00, 3.3114687580E+01, 4.3951379785E+00, 9.8133988856E-01],
	[4.1610000000E+04, 4.9153310121E+01, 5.6504910437E+00, 3.3127817479E+01, 4.3954809172E+00, 9.8134892034E-01],
	[4.1615000000E+04, 4.9163726037E+01, 5.6505380112E+00, 3.3140951004E+01, 4.3958237587E+00, 9.8135794728E-01],
	[4.1620000000E+04, 4.9174142909E+01, 5.6505849736E+00, 3.3154088157E+01, 4.3961665029E+00, 9.8136696938E-01],
	[4.1625000000E+04, 4.9184560737E+01, 5.6506319307E+00, 3.3167228938E+01, 4.3965091500E+00, 9.8137598664E-01],
	[4.1630000000E+04, 4.9194979519E+01, 5.6506788825E+00, 3.3180373348E+01, 4.3968516999E+00, 9.8138499908E-01],
	[4.1635000000E+04, 4.9205399257E+01, 5.6507258291E+00, 3.3193521387E+01, 4.3971941527E+00, 9.8139400669E-01],
	[4.1640000000E+04, 4.9215819951E+01, 5.6507727704E+00, 3.3206673055E+01, 4.3975365085E+00, 9.8140300947E-01],
	[4.1645000000E+04, 4.9226241599E+01, 5.6508197065E+00, 3.3219828354E+01, 4.3978787671E+00, 9.8141200743E-01],
	[4.1650000000E+04, 4.9236664203E+01, 5.6508666373E+00, 3.3232987284E+01, 4.3982209288E+00, 9.8142100057E-01],
	[4.1655000000E+04, 4.9247087762E+01, 5.6509135629E+00, 3.3246149845E+01, 4.3985629935E+00, 9.8142998889E-01],
	[4.1660000000E+04, 4.9257512277E+01, 5.6509604833E+00, 3.3259316038E+01, 4.3989049612E+00, 9.8143897239E-01],
	[4.1665000000E+04, 4.9267937746E+01, 5.6510073984E+00, 3.3272485864E+01, 4.3992468320E+00, 9.8144795109E-01],
	[4.1670000000E+04, 4.9278364171E+01, 5.6510543083E+00, 3.3285659323E+01, 4.3995886060E+00, 9.8145692497E-01],
	[4.1675000000E+04, 4.9288791550E+01, 5.6511012129E+00, 3.3298836415E+01, 4.3999302830E+00, 9.8146589405E-01],
	[4.1680000000E+04, 4.9299219885E+01, 5.6511481123E+00, 3.3312017142E+01, 4.4002718632E+00, 9.8147485832E-01],
	[4.1685000000E+04, 4.9309649175E+01, 5.6511950065E+00, 3.3325201504E+01, 4.4006133467E+00, 9.8148381779E-01],
	[4.1690000000E+04, 4.9320079420E+01, 5.6512418954E+00, 3.3338389501E+01, 4.4009547333E+00, 9.8149277246E-01],
	[4.1695000000E+04, 4.9330510620E+01, 5.6512887791E+00, 3.3351581134E+01, 4.4012960232E+00, 9.8150172234E-01],
	[4.1700000000E+04, 4.9340942775E+01, 5.6513356575E+00, 3.3364776403E+01, 4.4016372165E+00, 9.8151066742E-01],
	[4.1705000000E+04, 4.9351375885E+01, 5.6513825308E+00, 3.3377975310E+01, 4.4019783130E+00, 9.8151960772E-01],
	[4.1710000000E+04, 4.9361809950E+01, 5.6514293988E+00, 3.3391177854E+01, 4.4023193129E+00, 9.8152854322E-01],
	[4.1715000000E+04, 4.9372244969E+01, 5.6514762615E+00, 3.3404384037E+01, 4.4026602162E+00, 9.8153747394E-01],
	[4.1720000000E+04, 4.9382680944E+01, 5.6515231191E+00, 3.3417593858E+01, 4.4030010229E+00, 9.8154639988E-01],
	[4.1725000000E+04, 4.9393117873E+01, 5.6515699714E+00, 3.3430807318E+01, 4.4033417331E+00, 9.8155532104E-01],
	[4.1730000000E+04, 4.9403555758E+01, 5.6516168185E+00, 3.3444024419E+01, 4.4036823468E+00, 9.8156423742E-01],
	[4.1735000000E+04, 4.9413994597E+01, 5.6516636603E+00, 3.3457245160E+01, 4.4040228639E+00, 9.8157314902E-01],
	[4.1740000000E+04, 4.9424434390E+01, 5.6517104970E+00, 3.3470469542E+01, 4.4043632846E+00, 9.8158205586E-01],
	[4.1745000000E+04, 4.9434875139E+01, 5.6517573284E+00, 3.3483697565E+01, 4.4047036089E+00, 9.8159095792E-01],
	[4.1750000000E+04, 4.9445316842E+01, 5.6518041546E+00, 3.3496929231E+01, 4.4050438368E+00, 9.8159985522E-01],
	[4.1755000000E+04, 4.9455759500E+01, 5.6518509755E+00, 3.3510164540E+01, 4.4053839684E+00, 9.8160874776E-01],
	[4.1760000000E+04, 4.9466203113E+01, 5.6518977913E+00, 3.3523403492E+01, 4.4057240036E+00, 9.8161763553E-01],
	[4.1765000000E+04, 4.9476647680E+01, 5.6519446018E+00, 3.3536646087E+01, 4.4060639425E+00, 9.8162651855E-01],
	[4.1770000000E+04, 4.9487093202E+01, 5.6519914072E+00, 3.3549892328E+01, 4.4064037851E+00, 9.8163539681E-01],
	[4.1775000000E+04, 4.9497539678E+01, 5.6520382073E+00, 3.3563142213E+01, 4.4067435316E+00, 9.8164427031E-01],
	[4.1780000000E+04, 4.9507987109E+01, 5.6520850022E+00, 3.3576395744E+01, 4.4070831818E+00, 9.8165313907E-01],
	[4.1785000000E+04, 4.9518435495E+01, 5.6521317918E+00, 3.3589652921E+01, 4.4074227358E+00, 9.8166200308E-01],
	[4.1790000000E+04, 4.9528884835E+01, 5.6521785763E+00, 3.3602913744E+01, 4.4077621937E+00, 9.8167086234E-01],
	[4.1795000000E+04, 4.9539335129E+01, 5.6522253556E+00, 3.3616178215E+01, 4.4081015555E+00, 9.8167971686E-01],
	[4.1800000000E+04, 4.9549786378E+01, 5.6522721296E+00, 3.3629446334E+01, 4.4084408212E+00, 9.8168856665E-01],
	[4.1805000000E+04, 4.9560238582E+01, 5.6523188985E+00, 3.3642718101E+01, 4.4087799908E+00, 9.8169741169E-01],
	[4.1810000000E+04, 4.9570691739E+01, 5.6523656621E+00, 3.3655993517E+01, 4.4091190645E+00, 9.8170625200E-01],
	[4.1815000000E+04, 4.9581145852E+01, 5.6524124205E+00, 3.3669272583E+01, 4.4094580421E+00, 9.8171508758E-01],
	[4.1820000000E+04, 4.9591600918E+01, 5.6524591738E+00, 3.3682555299E+01, 4.4097969238E+00, 9.8172391844E-01],
	[4.1825000000E+04, 4.9602056939E+01, 5.6525059218E+00, 3.3695841666E+01, 4.4101357096E+00, 9.8173274456E-01],
	[4.1830000000E+04, 4.9612535823E+01, 5.6525547058E+00, 3.3709131683E+01, 4.4104758153E+00, 9.8174156596E-01],
	[4.1835000000E+04, 4.9623015817E+01, 5.6526034982E+00, 3.3722425353E+01, 4.4108158350E+00, 9.8175038264E-01],
	[4.1840000000E+04, 4.9633496771E+01, 5.6526522852E+00, 3.3735722675E+01, 4.4111557589E+00, 9.8175919461E-01],
	[4.1845000000E+04, 4.9643978687E+01, 5.6527010668E+00, 3.3749023650E+01, 4.4114955873E+00, 9.8176800185E-01],
	[4.1850000000E+04, 4.9654461563E+01, 5.6527498430E+00, 3.3762328278E+01, 4.4118353200E+00, 9.8177680439E-01],
	[4.1855000000E+04, 4.9664945400E+01, 5.6527986138E+00, 3.3775636561E+01, 4.4121749572E+00, 9.8178560221E-01],
	[4.1860000000E+04, 4.9675430198E+01, 5.6528473792E+00, 3.3788948498E+01, 4.4125144989E+00, 9.8179439533E-01],
	[4.1865000000E+04, 4.9685915957E+01, 5.6528961392E+00, 3.3802264090E+01, 4.4128539450E+00, 9.8180318374E-01],
	[4.1870000000E+04, 4.9696402676E+01, 5.6529448938E+00, 3.3815583338E+01, 4.4131932957E+00, 9.8181196746E-01],
	[4.1875000000E+04, 4.9706890357E+01, 5.6529936430E+00, 3.3828906243E+01, 4.4135325509E+00, 9.8182074647E-01],
	[4.1880000000E+04, 4.9717378998E+01, 5.6530423868E+00, 3.3842232804E+01, 4.4138717108E+00, 9.8182952078E-01],
	[4.1885000000E+04, 4.9727868599E+01, 5.6530911252E+00, 3.3855563023E+01, 4.4142107752E+00, 9.8183829040E-01],
	[4.1890000000E+04, 4.9738359161E+01, 5.6531398581E+00, 3.3868896900E+01, 4.4145497443E+00, 9.8184705533E-01],
	[4.1895000000E+04, 4.9748850684E+01, 5.6531885857E+00, 3.3882234435E+01, 4.4148886181E+00, 9.8185581557E-01],
	[4.1900000000E+04, 4.9759343167E+01, 5.6532373079E+00, 3.3895575630E+01, 4.4152273966E+00, 9.8186457113E-01],
	[4.1905000000E+04, 4.9769836611E+01, 5.6532860247E+00, 3.3908920484E+01, 4.4155660799E+00, 9.8187332200E-01],
	[4.1910000000E+04, 4.9780331016E+01, 5.6533347362E+00, 3.3922268999E+01, 4.4159046679E+00, 9.8188206819E-01],
	[4.1915000000E+04, 4.9790826381E+01, 5.6533834422E+00, 3.3935621175E+01, 4.4162431607E+00, 9.8189080970E-01],
	[4.1920000000E+04, 4.9801322706E+01, 5.6534321428E+00, 3.3948977012E+01, 4.4165815584E+00, 9.8189954654E-01],
	[4.1925000000E+04, 4.9811819992E+01, 5.6534808380E+00, 3.3962336511E+01, 4.4169198609E+00, 9.8190827871E-01],
	[4.1930000000E+04, 4.9822318238E+01, 5.6535295279E+00, 3.3975699673E+01, 4.4172580684E+00, 9.8191700620E-01],
	[4.1935000000E+04, 4.9832817445E+01, 5.6535782124E+00, 3.3989066498E+01, 4.4175961807E+00, 9.8192572903E-01],
	[4.1940000000E+04, 4.9843317612E+01, 5.6536268914E+00, 3.4002436986E+01, 4.4179341980E+00, 9.8193444719E-01],
	[4.1945000000E+04, 4.9853818739E+01, 5.6536755651E+00, 3.4015811139E+01, 4.4182721204E+00, 9.8194316069E-01],
	[4.1950000000E+04, 4.9864320827E+01, 5.6537242334E+00, 3.4029188957E+01, 4.4186099477E+00, 9.8195186954E-01],
	[4.1955000000E+04, 4.9874823875E+01, 5.6537728964E+00, 3.4042570440E+01, 4.4189476801E+00, 9.8196057372E-01],
	[4.1960000000E+04, 4.9885327883E+01, 5.6538215539E+00, 3.4055955589E+01, 4.4192853176E+00, 9.8196927325E-01],
	[4.1965000000E+04, 4.9895832852E+01, 5.6538702061E+00, 3.4069344404E+01, 4.4196228601E+00, 9.8197796813E-01],
	[4.1970000000E+04, 4.9906338780E+01, 5.6539188529E+00, 3.4082736887E+01, 4.4199603079E+00, 9.8198665837E-01],
	[4.1975000000E+04, 4.9916845669E+01, 5.6539674943E+00, 3.4096133037E+01, 4.4202976608E+00, 9.8199534395E-01],
	[4.1980000000E+04, 4.9927353518E+01, 5.6540161304E+00, 3.4109532856E+01, 4.4206349189E+00, 9.8200402489E-01],
	[4.1985000000E+04, 4.9937862327E+01, 5.6540647610E+00, 3.4122936344E+01, 4.4209720822E+00, 9.8201270120E-01],
	[4.1990000000E+04, 4.9948372096E+01, 5.6541133863E+00, 3.4136343500E+01, 4.4213091509E+00, 9.8202137286E-01],
	[4.1995000000E+04, 4.9958882826E+01, 5.6541620062E+00, 3.4149754327E+01, 4.4216461248E+00, 9.8203003989E-01],
	[4.2000000000E+04, 4.9969394515E+01, 5.6542106208E+00, 3.4163168825E+01, 4.4219830040E+00, 9.8203870228E-01],
	[4.2005000000E+04, 4.9979907164E+01, 5.6542592300E+00, 3.4176586993E+01, 4.4223197886E+00, 9.8204736005E-01],
	[4.2010000000E+04, 4.9990420774E+01, 5.6543078338E+00, 3.4190008833E+01, 4.4226564786E+00, 9.8205601319E-01],
	[4.2015000000E+04, 5.0000935343E+01, 5.6543564323E+00, 3.4203434345E+01, 4.4229930741E+00, 9.8206466170E-01],
	[4.2020000000E+04, 5.0011450872E+01, 5.6544050253E+00, 3.4216863530E+01, 4.4233295749E+00, 9.8207330559E-01],
	[4.2025000000E+04, 5.0021967361E+01, 5.6544536131E+00, 3.4230296389E+01, 4.4236659813E+00, 9.8208194486E-01],
	[4.2030000000E+04, 5.0032484811E+01, 5.6545021954E+00, 3.4243732921E+01, 4.4240022931E+00, 9.8209057952E-01],
	[4.2035000000E+04, 5.0043003219E+01, 5.6545507724E+00, 3.4257173128E+01, 4.4243385106E+00, 9.8209920956E-01],
	[4.2040000000E+04, 5.0053522588E+01, 5.6545993440E+00, 3.4270617010E+01, 4.4246746335E+00, 9.8210783499E-01],
	[4.2045000000E+04, 5.0064042917E+01, 5.6546479103E+00, 3.4284064568E+01, 4.4250106621E+00, 9.8211645581E-01],
	[4.2050000000E+04, 5.0074564205E+01, 5.6546964712E+00, 3.4297515801E+01, 4.4253465964E+00, 9.8212507203E-01],
	[4.2055000000E+04, 5.0085086453E+01, 5.6547450268E+00, 3.4310970712E+01, 4.4256824363E+00, 9.8213368364E-01],
	[4.2060000000E+04, 5.0095609661E+01, 5.6547935770E+00, 3.4324429300E+01, 4.4260181818E+00, 9.8214229065E-01],
	[4.2065000000E+04, 5.0106133828E+01, 5.6548421219E+00, 3.4337891565E+01, 4.4263538332E+00, 9.8215089306E-01],
	[4.2070000000E+04, 5.0116658956E+01, 5.6548906614E+00, 3.4351357510E+01, 4.4266893902E+00, 9.8215949088E-01],
	[4.2075000000E+04, 5.0127185042E+01, 5.6549391955E+00, 3.4364827133E+01, 4.4270248531E+00, 9.8216808410E-01],
	[4.2080000000E+04, 5.0137712089E+01, 5.6549877243E+00, 3.4378300436E+01, 4.4273602218E+00, 9.8217667273E-01],
	[4.2085000000E+04, 5.0148240095E+01, 5.6550362477E+00, 3.4391777419E+01, 4.4276954963E+00, 9.8218525678E-01],
	[4.2090000000E+04, 5.0158769061E+01, 5.6550847658E+00, 3.4405258082E+01, 4.4280306768E+00, 9.8219383624E-01],
	[4.2095000000E+04, 5.0169298986E+01, 5.6551332786E+00, 3.4418742427E+01, 4.4283657631E+00, 9.8220241112E-01],
	[4.2100000000E+04, 5.0179829870E+01, 5.6551817860E+00, 3.4432230454E+01, 4.4287007554E+00, 9.8221098142E-01],
	[4.2105000000E+04, 5.0190361714E+01, 5.6552302880E+00, 3.4445722164E+01, 4.4290356536E+00, 9.8221954714E-01],
	[4.2110000000E+04, 5.0200894518E+01, 5.6552787848E+00, 3.4459217556E+01, 4.4293704578E+00, 9.8222810829E-01],
	[4.2115000000E+04, 5.0211428281E+01, 5.6553272761E+00, 3.4472716632E+01, 4.4297051681E+00, 9.8223666486E-01],
	[4.2120000000E+04, 5.0221963004E+01, 5.6553757622E+00, 3.4486219392E+01, 4.4300397845E+00, 9.8224521687E-01],
	[4.2125000000E+04, 5.0232498685E+01, 5.6554242429E+00, 3.4499725837E+01, 4.4303743069E+00, 9.8225376431E-01],
	[4.2130000000E+04, 5.0243035327E+01, 5.6554727182E+00, 3.4513235967E+01, 4.4307087355E+00, 9.8226230719E-01],
	[4.2135000000E+04, 5.0253572927E+01, 5.6555211882E+00, 3.4526749782E+01, 4.4310430702E+00, 9.8227084550E-01],
	[4.2140000000E+04, 5.0264111487E+01, 5.6555696529E+00, 3.4540267285E+01, 4.4313773111E+00, 9.8227937926E-01],
	[4.2145000000E+04, 5.0274651006E+01, 5.6556181123E+00, 3.4553788474E+01, 4.4317114582E+00, 9.8228790846E-01],
	[4.2150000000E+04, 5.0285191484E+01, 5.6556665663E+00, 3.4567313351E+01, 4.4320455116E+00, 9.8229643311E-01],
	[4.2155000000E+04, 5.0295732922E+01, 5.6557150149E+00, 3.4580841916E+01, 4.4323794712E+00, 9.8230495320E-01],
	[4.2160000000E+04, 5.0306275319E+01, 5.6557634583E+00, 3.4594374169E+01, 4.4327133372E+00, 9.8231346875E-01],
	[4.2165000000E+04, 5.0316818675E+01, 5.6558118963E+00, 3.4607910112E+01, 4.4330471095E+00, 9.8232197975E-01],
	[4.2170000000E+04, 5.0327362990E+01, 5.6558603290E+00, 3.4621449745E+01, 4.4333807881E+00, 9.8233048621E-01],
	[4.2175000000E+04, 5.0337908264E+01, 5.6559087564E+00, 3.4634993068E+01, 4.4337143732E+00, 9.8233898813E-01],
	[4.2180000000E+04, 5.0348454497E+01, 5.6559571784E+00, 3.4648540082E+01, 4.4340478647E+00, 9.8234748552E-01],
	[4.2185000000E+04, 5.0359001689E+01, 5.6560055951E+00, 3.4662090787E+01, 4.4343812627E+00, 9.8235597836E-01],
	[4.2190000000E+04, 5.0369549841E+01, 5.6560540065E+00, 3.4675645185E+01, 4.4347145671E+00, 9.8236446668E-01],
	[4.2195000000E+04, 5.0380098951E+01, 5.6561024126E+00, 3.4689203275E+01, 4.4350477781E+00, 9.8237295047E-01],
	[4.2200000000E+04, 5.0390649021E+01, 5.6561508133E+00, 3.4702765059E+01, 4.4353808956E+00, 9.8238142973E-01],
	[4.2205000000E+04, 5.0401200049E+01, 5.6561992087E+00, 3.4716330536E+01, 4.4357139197E+00, 9.8238990446E-01],
	[4.2210000000E+04, 5.0411752036E+01, 5.6562475988E+00, 3.4729899708E+01, 4.4360468504E+00, 9.8239837467E-01],
	[4.2215000000E+04, 5.0422304982E+01, 5.6562959836E+00, 3.4743472574E+01, 4.4363796877E+00, 9.8240684037E-01],
	[4.2220000000E+04, 5.0432858887E+01, 5.6563443631E+00, 3.4757049137E+01, 4.4367124318E+00, 9.8241530154E-01],
	[4.2225000000E+04, 5.0443413751E+01, 5.6563927372E+00, 3.4770629395E+01, 4.4370450825E+00, 9.8242375821E-01],
	[4.2230000000E+04, 5.0453969574E+01, 5.6564411061E+00, 3.4784213349E+01, 4.4373776399E+00, 9.8243221036E-01],
	[4.2235000000E+04, 5.0464526356E+01, 5.6564894696E+00, 3.4797801001E+01, 4.4377101042E+00, 9.8244065800E-01],
	[4.2240000000E+04, 5.0475084096E+01, 5.6565378278E+00, 3.4811392351E+01, 4.4380424752E+00, 9.8244910114E-01],
	[4.2245000000E+04, 5.0485642795E+01, 5.6565861807E+00, 3.4824987399E+01, 4.4383747530E+00, 9.8245753977E-01],
	[4.2250000000E+04, 5.0496202453E+01, 5.6566345283E+00, 3.4838586146E+01, 4.4387069377E+00, 9.8246597391E-01],
	[4.2255000000E+04, 5.0506763069E+01, 5.6566828706E+00, 3.4852188593E+01, 4.4390390293E+00, 9.8247440354E-01],
	[4.2260000000E+04, 5.0517324644E+01, 5.6567312076E+00, 3.4865794739E+01, 4.4393710278E+00, 9.8248282868E-01],
	[4.2265000000E+04, 5.0527887178E+01, 5.6567795393E+00, 3.4879404587E+01, 4.4397029333E+00, 9.8249124933E-01],
	[4.2270000000E+04, 5.0538450670E+01, 5.6568278656E+00, 3.4893018135E+01, 4.4400347457E+00, 9.8249966549E-01],
	[4.2275000000E+04, 5.0549015121E+01, 5.6568761867E+00, 3.4906635385E+01, 4.4403664651E+00, 9.8250807715E-01],
	[4.2280000000E+04, 5.0559580531E+01, 5.6569245025E+00, 3.4920256337E+01, 4.4406980916E+00, 9.8251648434E-01],
	[4.2285000000E+04, 5.0570146899E+01, 5.6569728129E+00, 3.4933880993E+01, 4.4410296251E+00, 9.8252488704E-01],
	[4.2290000000E+04, 5.0580714225E+01, 5.6570211181E+00, 3.4947509351E+01, 4.4413610658E+00, 9.8253328526E-01],
	[4.2295000000E+04, 5.0591282511E+01, 5.6570694180E+00, 3.4961141414E+01, 4.4416924135E+00, 9.8254167900E-01],
	[4.2300000000E+04, 5.0601851754E+01, 5.6571177125E+00, 3.4974777181E+01, 4.4420236684E+00, 9.8255006827E-01],
	[4.2305000000E+04, 5.0612421956E+01, 5.6571660018E+00, 3.4988416654E+01, 4.4423548305E+00, 9.8255845307E-01],
	[4.2310000000E+04, 5.0622993116E+01, 5.6572142858E+00, 3.5002059832E+01, 4.4426858999E+00, 9.8256683340E-01],
	[4.2315000000E+04, 5.0633565235E+01, 5.6572625645E+00, 3.5015706717E+01, 4.4430168764E+00, 9.8257520926E-01],
	[4.2320000000E+04, 5.0644138312E+01, 5.6573108379E+00, 3.5029357308E+01, 4.4433477603E+00, 9.8258358066E-01],
	[4.2325000000E+04, 5.0654712347E+01, 5.6573591060E+00, 3.5043011607E+01, 4.4436785514E+00, 9.8259194759E-01],
	[4.2330000000E+04, 5.0665287341E+01, 5.6574073688E+00, 3.5056669614E+01, 4.4440092499E+00, 9.8260031007E-01],
	[4.2335000000E+04, 5.0675863293E+01, 5.6574556263E+00, 3.5070331329E+01, 4.4443398558E+00, 9.8260866809E-01],
	[4.2340000000E+04, 5.0686440203E+01, 5.6575038785E+00, 3.5083996754E+01, 4.4446703691E+00, 9.8261702166E-01],
	[4.2345000000E+04, 5.0697018072E+01, 5.6575521255E+00, 3.5097665888E+01, 4.4450007898E+00, 9.8262537077E-01],
	[4.2350000000E+04, 5.0707596898E+01, 5.6576003671E+00, 3.5111338733E+01, 4.4453311179E+00, 9.8263371544E-01],
	[4.2355000000E+04, 5.0718176683E+01, 5.6576486035E+00, 3.5125015288E+01, 4.4456613536E+00, 9.8264205566E-01],
	[4.2360000000E+04, 5.0728757426E+01, 5.6576968346E+00, 3.5138695555E+01, 4.4459914968E+00, 9.8265039144E-01],
	[4.2365000000E+04, 5.0739339127E+01, 5.6577450604E+00, 3.5152379534E+01, 4.4463215475E+00, 9.8265872277E-01],
	[4.2370000000E+04, 5.0749921786E+01, 5.6577932810E+00, 3.5166067225E+01, 4.4466515058E+00, 9.8266704967E-01],
	[4.2375000000E+04, 5.0760505403E+01, 5.6578414962E+00, 3.5179758629E+01, 4.4469813717E+00, 9.8267537213E-01],
	[4.2380000000E+04, 5.0771089979E+01, 5.6578897062E+00, 3.5193453747E+01, 4.4473111452E+00, 9.8268369016E-01],
	[4.2385000000E+04, 5.0781675512E+01, 5.6579379109E+00, 3.5207152580E+01, 4.4476408265E+00, 9.8269200376E-01],
	[4.2390000000E+04, 5.0792262003E+01, 5.6579861103E+00, 3.5220855127E+01, 4.4479704154E+00, 9.8270031293E-01],
	[4.2395000000E+04, 5.0802849452E+01, 5.6580343045E+00, 3.5234561390E+01, 4.4482999120E+00, 9.8270861768E-01],
	[4.2400000000E+04, 5.0813437859E+01, 5.6580824933E+00, 3.5248271368E+01, 4.4486293165E+00, 9.8271691800E-01],
	[4.2405000000E+04, 5.0824027224E+01, 5.6581306769E+00, 3.5261985063E+01, 4.4489586287E+00, 9.8272521391E-01],
	[4.2410000000E+04, 5.0834617547E+01, 5.6581788553E+00, 3.5275702476E+01, 4.4492878487E+00, 9.8273350539E-01],
	[4.2415000000E+04, 5.0845208828E+01, 5.6582270283E+00, 3.5289423606E+01, 4.4496169766E+00, 9.8274179246E-01],
	[4.2420000000E+04, 5.0855801066E+01, 5.6582751961E+00, 3.5303148454E+01, 4.4499460124E+00, 9.8275007512E-01],
	[4.2425000000E+04, 5.0866394263E+01, 5.6583233587E+00, 3.5316877021E+01, 4.4502749560E+00, 9.8275835337E-01],
	[4.2430000000E+04, 5.0876988417E+01, 5.6583715159E+00, 3.5330609307E+01, 4.4506038076E+00, 9.8276662721E-01],
	[4.2435000000E+04, 5.0887583528E+01, 5.6584196679E+00, 3.5344345313E+01, 4.4509325672E+00, 9.8277489665E-01],
	[4.2440000000E+04, 5.0898179598E+01, 5.6584678147E+00, 3.5358085040E+01, 4.4512612348E+00, 9.8278316169E-01],
	[4.2445000000E+04, 5.0908776625E+01, 5.6585159561E+00, 3.5371828488E+01, 4.4515898105E+00, 9.8279142233E-01],
	[4.2450000000E+04, 5.0919374610E+01, 5.6585640924E+00, 3.5385575657E+01, 4.4519182941E+00, 9.8279967857E-01],
	[4.2455000000E+04, 5.0929973553E+01, 5.6586122233E+00, 3.5399326549E+01, 4.4522466859E+00, 9.8280793041E-01],
	[4.2460000000E+04, 5.0940573453E+01, 5.6586603490E+00, 3.5413081164E+01, 4.4525749858E+00, 9.8281617787E-01],
	[4.2465000000E+04, 5.0951174311E+01, 5.6587084694E+00, 3.5426839502E+01, 4.4529031939E+00, 9.8282442093E-01],
	[4.2470000000E+04, 5.0961776126E+01, 5.6587565846E+00, 3.5440601563E+01, 4.4532313101E+00, 9.8283265961E-01],
	[4.2475000000E+04, 5.0972378899E+01, 5.6588046945E+00, 3.5454367350E+01, 4.4535593345E+00, 9.8284089391E-01],
	[4.2480000000E+04, 5.0982982629E+01, 5.6588527992E+00, 3.5468136861E+01, 4.4538872672E+00, 9.8284912382E-01],
	[4.2485000000E+04, 5.0993587317E+01, 5.6589008986E+00, 3.5481910098E+01, 4.4542151082E+00, 9.8285734935E-01],
	[4.2490000000E+04, 5.1004192962E+01, 5.6589489928E+00, 3.5495687061E+01, 4.4545428575E+00, 9.8286557051E-01],
	[4.2495000000E+04, 5.1014799565E+01, 5.6589970817E+00, 3.5509467751E+01, 4.4548705150E+00, 9.8287378730E-01],
	[4.2500000000E+04, 5.1025414344E+01, 5.6590458254E+00, 3.5523252169E+01, 4.4551985452E+00, 9.8288199971E-01],
	[4.2505000000E+04, 5.1036044873E+01, 5.6590959159E+00, 3.5537040314E+01, 4.4555274345E+00, 9.8289020776E-01],
	[4.2510000000E+04, 5.1046676365E+01, 5.6591460010E+00, 3.5550832188E+01, 4.4558562325E+00, 9.8289841144E-01],
	[4.2515000000E+04, 5.1057308821E+01, 5.6591960806E+00, 3.5564627791E+01, 4.4561849391E+00, 9.8290661076E-01],
	[4.2520000000E+04, 5.1067942241E+01, 5.6592461548E+00, 3.5578427123E+01, 4.4565135543E+00, 9.8291480571E-01],
	[4.2525000000E+04, 5.1078576625E+01, 5.6592962235E+00, 3.5592230186E+01, 4.4568420782E+00, 9.8292299631E-01],
	[4.2530000000E+04, 5.1089211973E+01, 5.6593462867E+00, 3.5606036979E+01, 4.4571705108E+00, 9.8293118256E-01],
	[4.2535000000E+04, 5.1099848284E+01, 5.6593963446E+00, 3.5619847504E+01, 4.4574988521E+00, 9.8293936445E-01],
	[4.2540000000E+04, 5.1110485560E+01, 5.6594463970E+00, 3.5633661760E+01, 4.4578271021E+00, 9.8294754199E-01],
	[4.2545000000E+04, 5.1121123799E+01, 5.6594964439E+00, 3.5647479750E+01, 4.4581552610E+00, 9.8295571518E-01],
	[4.2550000000E+04, 5.1131763002E+01, 5.6595464854E+00, 3.5661301472E+01, 4.4584833287E+00, 9.8296388402E-01],
	[4.2555000000E+04, 5.1142403168E+01, 5.6595965215E+00, 3.5675126927E+01, 4.4588113052E+00, 9.8297204853E-01],
	[4.2560000000E+04, 5.1153044298E+01, 5.6596465521E+00, 3.5688956117E+01, 4.4591391906E+00, 9.8298020869E-01],
	[4.2565000000E+04, 5.1163686392E+01, 5.6596965773E+00, 3.5702789042E+01, 4.4594669849E+00, 9.8298836452E-01],
	[4.2570000000E+04, 5.1174329449E+01, 5.6597465971E+00, 3.5716625702E+01, 4.4597946882E+00, 9.8299651601E-01],
	[4.2575000000E+04, 5.1184973470E+01, 5.6597966114E+00, 3.5730466098E+01, 4.4601223004E+00, 9.8300466317E-01],
	[4.2580000000E+04, 5.1195618455E+01, 5.6598466203E+00, 3.5744310230E+01, 4.4604498216E+00, 9.8301280600E-01],
	[4.2585000000E+04, 5.1206264403E+01, 5.6598966238E+00, 3.5758158100E+01, 4.4607772519E+00, 9.8302094450E-01],
	[4.2590000000E+04, 5.1216911314E+01, 5.6599466218E+00, 3.5772009706E+01, 4.4611045912E+00, 9.8302907868E-01],
	[4.2595000000E+04, 5.1227559189E+01, 5.6599966144E+00, 3.5785865052E+01, 4.4614318395E+00, 9.8303720853E-01],
	[4.2600000000E+04, 5.1238208028E+01, 5.6600466016E+00, 3.5799724135E+01, 4.4617589970E+00, 9.8304533407E-01],
	[4.2605000000E+04, 5.1248857830E+01, 5.6600965834E+00, 3.5813586959E+01, 4.4620860637E+00, 9.8305345529E-01],
	[4.2610000000E+04, 5.1259508595E+01, 5.6601465597E+00, 3.5827453522E+01, 4.4624130395E+00, 9.8306157219E-01],
	[4.2615000000E+04, 5.1270160324E+01, 5.6601965306E+00, 3.5841323825E+01, 4.4627399245E+00, 9.8306968478E-01],
	[4.2620000000E+04, 5.1280813016E+01, 5.6602464961E+00, 3.5855197870E+01, 4.4630667188E+00, 9.8307779306E-01],
	[4.2625000000E+04, 5.1291466671E+01, 5.6602964562E+00, 3.5869075656E+01, 4.4633934223E+00, 9.8308589704E-01],
	[4.2630000000E+04, 5.1302121290E+01, 5.6603464109E+00, 3.5882957184E+01, 4.4637200351E+00, 9.8309399671E-01],
	[4.2635000000E+04, 5.1312776872E+01, 5.6603963601E+00, 3.5896842455E+01, 4.4640465573E+00, 9.8310209208E-01],
	[4.2640000000E+04, 5.1323433417E+01, 5.6604463039E+00, 3.5910731469E+01, 4.4643729887E+00, 9.8311018315E-01],
	[4.2645000000E+04, 5.1334090925E+01, 5.6604962423E+00, 3.5924624227E+01, 4.4646993296E+00, 9.8311826992E-01],
	[4.2650000000E+04, 5.1344749397E+01, 5.6605461753E+00, 3.5938520730E+01, 4.4650255799E+00, 9.8312635240E-01],
	[4.2655000000E+04, 5.1355408831E+01, 5.6605961029E+00, 3.5952420977E+01, 4.4653517396E+00, 9.8313443059E-01],
	[4.2660000000E+04, 5.1366069229E+01, 5.6606460251E+00, 3.5966324970E+01, 4.4656778088E+00, 9.8314250449E-01],
	[4.2665000000E+04, 5.1376730590E+01, 5.6606959418E+00, 3.5980232710E+01, 4.4660037875E+00, 9.8315057410E-01],
	[4.2670000000E+04, 5.1387392915E+01, 5.6607458532E+00, 3.5994144196E+01, 4.4663296757E+00, 9.8315863943E-01],
	[4.2675000000E+04, 5.1398056202E+01, 5.6607957591E+00, 3.6008059429E+01, 4.4666554735E+00, 9.8316670047E-01],
	[4.2680000000E+04, 5.1408720452E+01, 5.6608456596E+00, 3.6021978410E+01, 4.4669811809E+00, 9.8317475724E-01],
	[4.2685000000E+04, 5.1419385665E+01, 5.6608955547E+00, 3.6035901139E+01, 4.4673067979E+00, 9.8318280973E-01],
	[4.2690000000E+04, 5.1430051841E+01, 5.6609454445E+00, 3.6049827618E+01, 4.4676323245E+00, 9.8319085795E-01],
	[4.2695000000E+04, 5.1440718981E+01, 5.6609953288E+00, 3.6063757846E+01, 4.4679577608E+00, 9.8319890190E-01],
	[4.2700000000E+04, 5.1451387083E+01, 5.6610452077E+00, 3.6077691824E+01, 4.4682831068E+00, 9.8320694158E-01],
	[4.2705000000E+04, 5.1462056148E+01, 5.6610950812E+00, 3.6091629553E+01, 4.4686083626E+00, 9.8321497699E-01],
	[4.2710000000E+04, 5.1472726176E+01, 5.6611449493E+00, 3.6105571033E+01, 4.4689335281E+00, 9.8322300814E-01],
	[4.2715000000E+04, 5.1483397166E+01, 5.6611948120E+00, 3.6119516265E+01, 4.4692586034E+00, 9.8323103502E-01],
	[4.2720000000E+04, 5.1494069120E+01, 5.6612446694E+00, 3.6133465250E+01, 4.4695835886E+00, 9.8323905765E-01],
	[4.2725000000E+04, 5.1504742036E+01, 5.6612945213E+00, 3.6147417987E+01, 4.4699084836E+00, 9.8324707602E-01],
	[4.2730000000E+04, 5.1515415916E+01, 5.6613443678E+00, 3.6161374478E+01, 4.4702332884E+00, 9.8325509014E-01],
	[4.2735000000E+04, 5.1526090758E+01, 5.6613942089E+00, 3.6175334723E+01, 4.4705580032E+00, 9.8326310001E-01],
	[4.2740000000E+04, 5.1536766562E+01, 5.6614440447E+00, 3.6189298723E+01, 4.4708826280E+00, 9.8327110563E-01],
	[4.2745000000E+04, 5.1547443330E+01, 5.6614938750E+00, 3.6203266478E+01, 4.4712071627E+00, 9.8327910700E-01],
	[4.2750000000E+04, 5.1558121060E+01, 5.6615437000E+00, 3.6217237989E+01, 4.4715316074E+00, 9.8328710413E-01],
	[4.2755000000E+04, 5.1568799752E+01, 5.6615935196E+00, 3.6231213256E+01, 4.4718559621E+00, 9.8329509702E-01],
	[4.2760000000E+04, 5.1579479408E+01, 5.6616433337E+00, 3.6245192280E+01, 4.4721802269E+00, 9.8330308567E-01],
	[4.2765000000E+04, 5.1590160026E+01, 5.6616931425E+00, 3.6259175062E+01, 4.4725044018E+00, 9.8331107009E-01],
	[4.2770000000E+04, 5.1600841606E+01, 5.6617429460E+00, 3.6273161602E+01, 4.4728284868E+00, 9.8331905027E-01],
	[4.2775000000E+04, 5.1611524149E+01, 5.6617927440E+00, 3.6287151901E+01, 4.4731524819E+00, 9.8332702622E-01],
	[4.2780000000E+04, 5.1622207655E+01, 5.6618425366E+00, 3.6301145958E+01, 4.4734763873E+00, 9.8333499794E-01],
	[4.2785000000E+04, 5.1632892123E+01, 5.6618923239E+00, 3.6315143776E+01, 4.4738002028E+00, 9.8334296544E-01],
	[4.2790000000E+04, 5.1643577554E+01, 5.6619421058E+00, 3.6329145354E+01, 4.4741239286E+00, 9.8335092871E-01],
	[4.2795000000E+04, 5.1654263947E+01, 5.6619918823E+00, 3.6343150693E+01, 4.4744475646E+00, 9.8335888776E-01],
	[4.2800000000E+04, 5.1664951302E+01, 5.6620416534E+00, 3.6357159794E+01, 4.4747711110E+00, 9.8336684260E-01],
	[4.2805000000E+04, 5.1675639620E+01, 5.6620914192E+00, 3.6371172657E+01, 4.4750945676E+00, 9.8337479322E-01],
	[4.2810000000E+04, 5.1686328900E+01, 5.6621411795E+00, 3.6385189282E+01, 4.4754179346E+00, 9.8338273962E-01],
	[4.2815000000E+04, 5.1697019143E+01, 5.6621909345E+00, 3.6399209670E+01, 4.4757412120E+00, 9.8339068182E-01],
	[4.2820000000E+04, 5.1707710348E+01, 5.6622406842E+00, 3.6413233823E+01, 4.4760643998E+00, 9.8339861981E-01],
	[4.2825000000E+04, 5.1718402515E+01, 5.6622904284E+00, 3.6427261740E+01, 4.4763874981E+00, 9.8340655359E-01],
	[4.2830000000E+04, 5.1729095644E+01, 5.6623401673E+00, 3.6441293422E+01, 4.4767105068E+00, 9.8341448317E-01],
	[4.2835000000E+04, 5.1739789736E+01, 5.6623899008E+00, 3.6455328869E+01, 4.4770334260E+00, 9.8342240854E-01],
	[4.2840000000E+04, 5.1750484790E+01, 5.6624396290E+00, 3.6469368082E+01, 4.4773562557E+00, 9.8343032972E-01],
	[4.2845000000E+04, 5.1761180806E+01, 5.6624893517E+00, 3.6483411062E+01, 4.4776789961E+00, 9.8343824671E-01],
	[4.2850000000E+04, 5.1771877784E+01, 5.6625390692E+00, 3.6497457810E+01, 4.4780016469E+00, 9.8344615950E-01],
	[4.2855000000E+04, 5.1782575724E+01, 5.6625887812E+00, 3.6511508325E+01, 4.4783242085E+00, 9.8345406810E-01],
	[4.2860000000E+04, 5.1793274627E+01, 5.6626384879E+00, 3.6525562608E+01, 4.4786466806E+00, 9.8346197251E-01],
	[4.2865000000E+04, 5.1803974491E+01, 5.6626881892E+00, 3.6539620661E+01, 4.4789690634E+00, 9.8346987273E-01],
	[4.2870000000E+04, 5.1814675318E+01, 5.6627378852E+00, 3.6553682483E+01, 4.4792913570E+00, 9.8347776877E-01],
	[4.2875000000E+04, 5.1825377107E+01, 5.6627875758E+00, 3.6567748075E+01, 4.4796135613E+00, 9.8348566063E-01],
	[4.2880000000E+04, 5.1836079857E+01, 5.6628372610E+00, 3.6581817438E+01, 4.4799356763E+00, 9.8349354831E-01],
	[4.2885000000E+04, 5.1846783570E+01, 5.6628869409E+00, 3.6595890572E+01, 4.4802577021E+00, 9.8350143181E-01],
	[4.2890000000E+04, 5.1857488244E+01, 5.6629366155E+00, 3.6609967477E+01, 4.4805796388E+00, 9.8350931113E-01],
	[4.2895000000E+04, 5.1868193881E+01, 5.6629862846E+00, 3.6624048156E+01, 4.4809014863E+00, 9.8351718628E-01],
	[4.2900000000E+04, 5.1878900479E+01, 5.6630359485E+00, 3.6638132607E+01, 4.4812232446E+00, 9.8352505726E-01],
	[4.2905000000E+04, 5.1889608040E+01, 5.6630856069E+00, 3.6652220831E+01, 4.4815449139E+00, 9.8353292407E-01],
	[4.2910000000E+04, 5.1900316562E+01, 5.6631352601E+00, 3.6666312830E+01, 4.4818664942E+00, 9.8354078672E-01],
	[4.2915000000E+04, 5.1911026046E+01, 5.6631849078E+00, 3.6680408603E+01, 4.4821879853E+00, 9.8354864520E-01],
	[4.2920000000E+04, 5.1921736492E+01, 5.6632345502E+00, 3.6694508152E+01, 4.4825093875E+00, 9.8355649952E-01],
	[4.2925000000E+04, 5.1932447899E+01, 5.6632841873E+00, 3.6708611477E+01, 4.4828307008E+00, 9.8356434968E-01],
	[4.2930000000E+04, 5.1943160269E+01, 5.6633338190E+00, 3.6722718577E+01, 4.4831519250E+00, 9.8357219568E-01],
	[4.2935000000E+04, 5.1953873600E+01, 5.6633834454E+00, 3.6736829455E+01, 4.4834730604E+00, 9.8358003753E-01],
	[4.2940000000E+04, 5.1964587892E+01, 5.6634330665E+00, 3.6750944110E+01, 4.4837941068E+00, 9.8358787522E-01],
	[4.2945000000E+04, 5.1975303147E+01, 5.6634826822E+00, 3.6765062544E+01, 4.4841150645E+00, 9.8359570876E-01],
	[4.2950000000E+04, 5.1986019363E+01, 5.6635322925E+00, 3.6779184756E+01, 4.4844359332E+00, 9.8360353816E-01],
	[4.2955000000E+04, 5.1996736541E+01, 5.6635818975E+00, 3.6793310747E+01, 4.4847567132E+00, 9.8361136341E-01],
	[4.2960000000E+04, 5.2007454680E+01, 5.6636314972E+00, 3.6807440518E+01, 4.4850774044E+00, 9.8361918451E-01],
	[4.2965000000E+04, 5.2018173781E+01, 5.6636810915E+00, 3.6821574070E+01, 4.4853980069E+00, 9.8362700148E-01],
	[4.2970000000E+04, 5.2028893843E+01, 5.6637306805E+00, 3.6835711402E+01, 4.4857185207E+00, 9.8363481430E-01],
	[4.2975000000E+04, 5.2039614867E+01, 5.6637802642E+00, 3.6849852516E+01, 4.4860389457E+00, 9.8364262299E-01],
	[4.2980000000E+04, 5.2050336853E+01, 5.6638298425E+00, 3.6863997412E+01, 4.4863592822E+00, 9.8365042754E-01],
	[4.2985000000E+04, 5.2061059800E+01, 5.6638794155E+00, 3.6878146090E+01, 4.4866795300E+00, 9.8365822796E-01],
	[4.2990000000E+04, 5.2071783708E+01, 5.6639289832E+00, 3.6892298552E+01, 4.4869996892E+00, 9.8366602425E-01],
	[4.2995000000E+04, 5.2082508578E+01, 5.6639785455E+00, 3.6906454798E+01, 4.4873197598E+00, 9.8367381641E-01],
	[4.3000000000E+04, 5.2093234409E+01, 5.6640281025E+00, 3.6920614828E+01, 4.4876397419E+00, 9.8368160444E-01],
	[4.3005000000E+04, 5.2103961201E+01, 5.6640776542E+00, 3.6934778643E+01, 4.4879596355E+00, 9.8368938835E-01],
	[4.3010000000E+04, 5.2114688955E+01, 5.6641272005E+00, 3.6948946243E+01, 4.4882794406E+00, 9.8369716814E-01],
	[4.3015000000E+04, 5.2125417670E+01, 5.6641767415E+00, 3.6963117630E+01, 4.4885991572E+00, 9.8370494381E-01],
	[4.3020000000E+04, 5.2136147347E+01, 5.6642262772E+00, 3.6977292803E+01, 4.4889187855E+00, 9.8371271537E-01],
	[4.3025000000E+04, 5.2146877985E+01, 5.6642758076E+00, 3.6991471764E+01, 4.4892383253E+00, 9.8372048281E-01],
	[4.3030000000E+04, 5.2157609584E+01, 5.6643253327E+00, 3.7005654512E+01, 4.4895577768E+00, 9.8372824613E-01],
	[4.3035000000E+04, 5.2168342144E+01, 5.6643748524E+00, 3.7019841048E+01, 4.4898771399E+00, 9.8373600535E-01],
	[4.3040000000E+04, 5.2179075665E+01, 5.6644243668E+00, 3.7034031374E+01, 4.4901964148E+00, 9.8374376046E-01],
	[4.3045000000E+04, 5.2189810148E+01, 5.6644738759E+00, 3.7048225489E+01, 4.4905156013E+00, 9.8375151146E-01],
	[4.3050000000E+04, 5.2200545591E+01, 5.6645233796E+00, 3.7062423394E+01, 4.4908346996E+00, 9.8375925836E-01],
	[4.3055000000E+04, 5.2211281996E+01, 5.6645728781E+00, 3.7076625090E+01, 4.4911537097E+00, 9.8376700116E-01],
	[4.3060000000E+04, 5.2222019362E+01, 5.6646223712E+00, 3.7090830577E+01, 4.4914726316E+00, 9.8377473986E-01],
	[4.3065000000E+04, 5.2232757689E+01, 5.6646718591E+00, 3.7105039856E+01, 4.4917914653E+00, 9.8378247446E-01],
	[4.3070000000E+04, 5.2243496977E+01, 5.6647213416E+00, 3.7119252927E+01, 4.4921102110E+00, 9.8379020497E-01],
	[4.3075000000E+04, 5.2254237226E+01, 5.6647708188E+00, 3.7133469791E+01, 4.4924288685E+00, 9.8379793139E-01],
	[4.3080000000E+04, 5.2264978436E+01, 5.6648202906E+00, 3.7147690449E+01, 4.4927474379E+00, 9.8380565371E-01],
	[4.3085000000E+04, 5.2275720607E+01, 5.6648697572E+00, 3.7161914901E+01, 4.4930659193E+00, 9.8381337195E-01],
	[4.3090000000E+04, 5.2286463739E+01, 5.6649192185E+00, 3.7176143147E+01, 4.4933843126E+00, 9.8382108611E-01],
	[4.3095000000E+04, 5.2297207831E+01, 5.6649686745E+00, 3.7190375189E+01, 4.4937026180E+00, 9.8382879618E-01],
	[4.3100000000E+04, 5.2307952885E+01, 5.6650181251E+00, 3.7204611026E+01, 4.4940208354E+00, 9.8383650216E-01],
	[4.3105000000E+04, 5.2318698900E+01, 5.6650675705E+00, 3.7218850660E+01, 4.4943389649E+00, 9.8384420407E-01],
	[4.3110000000E+04, 5.2329445875E+01, 5.6651170105E+00, 3.7233094091E+01, 4.4946570065E+00, 9.8385190191E-01],
	[4.3115000000E+04, 5.2340193811E+01, 5.6651664453E+00, 3.7247341319E+01, 4.4949749602E+00, 9.8385959567E-01],
	[4.3120000000E+04, 5.2350942708E+01, 5.6652158747E+00, 3.7261592345E+01, 4.4952928261E+00, 9.8386728535E-01],
	[4.3125000000E+04, 5.2361692566E+01, 5.6652652988E+00, 3.7275847170E+01, 4.4956106041E+00, 9.8387497097E-01],
	[4.3130000000E+04, 5.2372443384E+01, 5.6653147177E+00, 3.7290105794E+01, 4.4959282944E+00, 9.8388265252E-01],
	[4.3135000000E+04, 5.2383195163E+01, 5.6653641312E+00, 3.7304368218E+01, 4.4962458969E+00, 9.8389033000E-01],
	[4.3140000000E+04, 5.2393947903E+01, 5.6654135395E+00, 3.7318634443E+01, 4.4965634117E+00, 9.8389800343E-01],
	[4.3145000000E+04, 5.2404701603E+01, 5.6654629424E+00, 3.7332904468E+01, 4.4968808388E+00, 9.8390567279E-01],
	[4.3150000000E+04, 5.2415456264E+01, 5.6655123401E+00, 3.7347178295E+01, 4.4971981782E+00, 9.8391333809E-01],
	[4.3155000000E+04, 5.2426211886E+01, 5.6655617325E+00, 3.7361455924E+01, 4.4975154300E+00, 9.8392099933E-01],
	[4.3160000000E+04, 5.2436968468E+01, 5.6656111195E+00, 3.7375737356E+01, 4.4978325941E+00, 9.8392865653E-01],
	[4.3165000000E+04, 5.2447726011E+01, 5.6656605013E+00, 3.7390022590E+01, 4.4981496707E+00, 9.8393630966E-01],
	[4.3170000000E+04, 5.2458484514E+01, 5.6657098778E+00, 3.7404311629E+01, 4.4984666597E+00, 9.8394395875E-01],
	[4.3175000000E+04, 5.2469243978E+01, 5.6657592490E+00, 3.7418604472E+01, 4.4987835612E+00, 9.8395160380E-01],
	[4.3180000000E+04, 5.2480004402E+01, 5.6658086150E+00, 3.7432901120E+01, 4.4991003752E+00, 9.8395924479E-01],
	[4.3185000000E+04, 5.2490776652E+01, 5.6658589506E+00, 3.7447201574E+01, 4.4994177965E+00, 9.8396688175E-01],
	[4.3190000000E+04, 5.2501560957E+01, 5.6659102761E+00, 3.7461505833E+01, 4.4997358395E+00, 9.8397451466E-01],
	[4.3195000000E+04, 5.2512346228E+01, 5.6659615961E+00, 3.7475813899E+01, 4.5000537952E+00, 9.8398214354E-01],
	[4.3200000000E+04, 5.2523132467E+01, 5.6660129106E+00, 3.7490125773E+01, 4.5003716638E+00, 9.8398976837E-01],
	[4.3205000000E+04, 5.2533919672E+01, 5.6660642196E+00, 3.7504441454E+01, 4.5006894451E+00, 9.8399738918E-01],
	[4.3210000000E+04, 5.2544707844E+01, 5.6661155231E+00, 3.7518760944E+01, 4.5010071392E+00, 9.8400500595E-01],
	[4.3215000000E+04, 5.2555496983E+01, 5.6661668212E+00, 3.7533084242E+01, 4.5013247462E+00, 9.8401261870E-01],
	[4.3220000000E+04, 5.2566287088E+01, 5.6662181138E+00, 3.7547411351E+01, 4.5016422660E+00, 9.8402022741E-01],
	[4.3225000000E+04, 5.2577078160E+01, 5.6662694010E+00, 3.7561742269E+01, 4.5019596988E+00, 9.8402783210E-01],
	[4.3230000000E+04, 5.2587870199E+01, 5.6663206826E+00, 3.7576076998E+01, 4.5022770444E+00, 9.8403543277E-01],
	[4.3235000000E+04, 5.2598663205E+01, 5.6663719588E+00, 3.7590415538E+01, 4.5025943031E+00, 9.8404302942E-01],
	[4.3240000000E+04, 5.2609457177E+01, 5.6664232296E+00, 3.7604757890E+01, 4.5029114747E+00, 9.8405062205E-01],
	[4.3245000000E+04, 5.2620252116E+01, 5.6664744949E+00, 3.7619104054E+01, 4.5032285594E+00, 9.8405821066E-01],
	[4.3250000000E+04, 5.2631048021E+01, 5.6665257547E+00, 3.7633454031E+01, 4.5035455571E+00, 9.8406579526E-01],
	[4.3255000000E+04, 5.2641844893E+01, 5.6665770090E+00, 3.7647807822E+01, 4.5038624679E+00, 9.8407337584E-01],
	[4.3260000000E+04, 5.2652642732E+01, 5.6666282579E+00, 3.7662165427E+01, 4.5041792917E+00, 9.8408095242E-01],
	[4.3265000000E+04, 5.2663441537E+01, 5.6666795013E+00, 3.7676526847E+01, 4.5044960288E+00, 9.8408852499E-01],
	[4.3270000000E+04, 5.2674241308E+01, 5.6667307393E+00, 3.7690892082E+01, 4.5048126789E+00, 9.8409609356E-01],
	[4.3275000000E+04, 5.2685042046E+01, 5.6667819718E+00, 3.7705261132E+01, 4.5051292423E+00, 9.8410365812E-01],
	[4.3280000000E+04, 5.2695843751E+01, 5.6668331989E+00, 3.7719633999E+01, 4.5054457189E+00, 9.8411121868E-01],
	[4.3285000000E+04, 5.2706646421E+01, 5.6668844205E+00, 3.7734010683E+01, 4.5057621087E+00, 9.8411877524E-01],
	[4.3290000000E+04, 5.2717450059E+01, 5.6669356366E+00, 3.7748391185E+01, 4.5060784118E+00, 9.8412632781E-01],
	[4.3295000000E+04, 5.2728254662E+01, 5.6669868473E+00, 3.7762775505E+01, 4.5063946282E+00, 9.8413387638E-01],
	[4.3300000000E+04, 5.2739060232E+01, 5.6670380526E+00, 3.7777163643E+01, 4.5067107579E+00, 9.8414142096E-01],
	[4.3305000000E+04, 5.2749866768E+01, 5.6670892524E+00, 3.7791555600E+01, 4.5070268010E+00, 9.8414896156E-01],
	[4.3310000000E+04, 5.2760674271E+01, 5.6671404467E+00, 3.7805951378E+01, 4.5073427575E+00, 9.8415649816E-01],
	[4.3315000000E+04, 5.2771482740E+01, 5.6671916356E+00, 3.7820350976E+01, 4.5076586274E+00, 9.8416403078E-01],
	[4.3320000000E+04, 5.2782292174E+01, 5.6672428191E+00, 3.7834754394E+01, 4.5079744108E+00, 9.8417155942E-01],
	[4.3325000000E+04, 5.2793102576E+01, 5.6672939971E+00, 3.7849161635E+01, 4.5082901076E+00, 9.8417908407E-01],
	[4.3330000000E+04, 5.2803913943E+01, 5.6673451696E+00, 3.7863572697E+01, 4.5086057179E+00, 9.8418660475E-01],
	[4.3335000000E+04, 5.2814726277E+01, 5.6673963368E+00, 3.7877987582E+01, 4.5089212418E+00, 9.8419412145E-01],
	[4.3340000000E+04, 5.2825539576E+01, 5.6674474984E+00, 3.7892406291E+01, 4.5092366792E+00, 9.8420163418E-01],
	[4.3345000000E+04, 5.2836353842E+01, 5.6674986547E+00, 3.7906828823E+01, 4.5095520302E+00, 9.8420914294E-01],
	[4.3350000000E+04, 5.2847169074E+01, 5.6675498055E+00, 3.7921255180E+01, 4.5098672948E+00, 9.8421664772E-01],
	[4.3355000000E+04, 5.2857985272E+01, 5.6676009509E+00, 3.7935685361E+01, 4.5101824731E+00, 9.8422414854E-01],
	[4.3360000000E+04, 5.2868802436E+01, 5.6676520908E+00, 3.7950119368E+01, 4.5104975650E+00, 9.8423164540E-01],
	[4.3365000000E+04, 5.2879620566E+01, 5.6677032253E+00, 3.7964557202E+01, 4.5108125706E+00, 9.8423913829E-01],
	[4.3370000000E+04, 5.2890439662E+01, 5.6677543543E+00, 3.7978998862E+01, 4.5111274900E+00, 9.8424662722E-01],
	[4.3375000000E+04, 5.2901259724E+01, 5.6678054780E+00, 3.7993444349E+01, 4.5114423231E+00, 9.8425411219E-01],
	[4.3380000000E+04, 5.2912080752E+01, 5.6678565961E+00, 3.8007893664E+01, 4.5117570700E+00, 9.8426159321E-01],
	[4.3385000000E+04, 5.2922902745E+01, 5.6679077089E+00, 3.8022346807E+01, 4.5120717307E+00, 9.8426907027E-01],
	[4.3390000000E+04, 5.2933725705E+01, 5.6679588162E+00, 3.8036803780E+01, 4.5123863053E+00, 9.8427654338E-01],
	[4.3395000000E+04, 5.2944549631E+01, 5.6680099181E+00, 3.8051264582E+01, 4.5127007937E+00, 9.8428401254E-01],
	[4.3400000000E+04, 5.2955374522E+01, 5.6680610146E+00, 3.8065729214E+01, 4.5130151960E+00, 9.8429147776E-01],
	[4.3405000000E+04, 5.2966200379E+01, 5.6681121057E+00, 3.8080197677E+01, 4.5133295123E+00, 9.8429893902E-01],
	[4.3410000000E+04, 5.2977027202E+01, 5.6681631913E+00, 3.8094669971E+01, 4.5136437425E+00, 9.8430639635E-01],
	[4.3415000000E+04, 5.2987854991E+01, 5.6682142715E+00, 3.8109146097E+01, 4.5139578867E+00, 9.8431384973E-01],
	[4.3420000000E+04, 5.2998683745E+01, 5.6682653463E+00, 3.8123626056E+01, 4.5142719449E+00, 9.8432129918E-01],
	[4.3425000000E+04, 5.3009513465E+01, 5.6683164156E+00, 3.8138109847E+01, 4.5145859171E+00, 9.8432874469E-01],
	[4.3430000000E+04, 5.3020344151E+01, 5.6683674796E+00, 3.8152597472E+01, 4.5148998034E+00, 9.8433618627E-01],
	[4.3435000000E+04, 5.3031175803E+01, 5.6684185381E+00, 3.8167088931E+01, 4.5152136038E+00, 9.8434362391E-01],
	[4.3440000000E+04, 5.3042008420E+01, 5.6684695912E+00, 3.8181584225E+01, 4.5155273184E+00, 9.8435105763E-01],
	[4.3445000000E+04, 5.3052842002E+01, 5.6685206389E+00, 3.8196083354E+01, 4.5158409470E+00, 9.8435848741E-01],
	[4.3450000000E+04, 5.3063676551E+01, 5.6685716812E+00, 3.8210586319E+01, 4.5161544899E+00, 9.8436591327E-01],
	[4.3455000000E+04, 5.3074512065E+01, 5.6686227180E+00, 3.8225093121E+01, 4.5164679470E+00, 9.8437333521E-01],
	[4.3460000000E+04, 5.3085348544E+01, 5.6686737495E+00, 3.8239603759E+01, 4.5167813183E+00, 9.8438075323E-01],
	[4.3465000000E+04, 5.3096185989E+01, 5.6687247755E+00, 3.8254118235E+01, 4.5170946038E+00, 9.8438816733E-01],
	[4.3470000000E+04, 5.3107024399E+01, 5.6687757961E+00, 3.8268636549E+01, 4.5174078037E+00, 9.8439557751E-01],
	[4.3475000000E+04, 5.3117863775E+01, 5.6688268114E+00, 3.8283158702E+01, 4.5177209179E+00, 9.8440298378E-01],
	[4.3480000000E+04, 5.3128704116E+01, 5.6688778212E+00, 3.8297684694E+01, 4.5180339464E+00, 9.8441038614E-01],
	[4.3485000000E+04, 5.3139545423E+01, 5.6689288256E+00, 3.8312214527E+01, 4.5183468893E+00, 9.8441778459E-01],
	[4.3490000000E+04, 5.3150387695E+01, 5.6689798246E+00, 3.8326748199E+01, 4.5186597467E+00, 9.8442517913E-01],
	[4.3495000000E+04, 5.3161230933E+01, 5.6690308181E+00, 3.8341285713E+01, 4.5189725184E+00, 9.8443256976E-01],
	[4.3500000000E+04, 5.3172075135E+01, 5.6690818063E+00, 3.8355827068E+01, 4.5192852046E+00, 9.8443995649E-01],
	[4.3505000000E+04, 5.3182920303E+01, 5.6691327891E+00, 3.8370372265E+01, 4.5195978053E+00, 9.8444733932E-01],
	[4.3510000000E+04, 5.3193766437E+01, 5.6691837665E+00, 3.8384921305E+01, 4.5199103206E+00, 9.8445471825E-01],
	[4.3515000000E+04, 5.3204613535E+01, 5.6692347385E+00, 3.8399474189E+01, 4.5202227503E+00, 9.8446209329E-01],
	[4.3520000000E+04, 5.3215461599E+01, 5.6692857051E+00, 3.8414030916E+01, 4.5205350947E+00, 9.8446946443E-01],
	[4.3525000000E+04, 5.3226310628E+01, 5.6693366663E+00, 3.8428591487E+01, 4.5208473536E+00, 9.8447683167E-01],
	[4.3530000000E+04, 5.3237160622E+01, 5.6693876221E+00, 3.8443155904E+01, 4.5211595272E+00, 9.8448419503E-01],
	[4.3535000000E+04, 5.3248011582E+01, 5.6694385725E+00, 3.8457724167E+01, 4.5214716154E+00, 9.8449155450E-01],
	[4.3540000000E+04, 5.3258863506E+01, 5.6694895175E+00, 3.8472296275E+01, 4.5217836184E+00, 9.8449891009E-01],
	[4.3545000000E+04, 5.3269716396E+01, 5.6695404571E+00, 3.8486872230E+01, 4.5220955360E+00, 9.8450626179E-01],
	[4.3550000000E+04, 5.3280570251E+01, 5.6695913913E+00, 3.8501452033E+01, 4.5224073684E+00, 9.8451360961E-01],
	[4.3555000000E+04, 5.3291425070E+01, 5.6696423202E+00, 3.8516035683E+01, 4.5227191155E+00, 9.8452095355E-01],
	[4.3560000000E+04, 5.3302280855E+01, 5.6696932436E+00, 3.8530623182E+01, 4.5230307775E+00, 9.8452829362E-01],
	[4.3565000000E+04, 5.3313137605E+01, 5.6697441617E+00, 3.8545214530E+01, 4.5233423543E+00, 9.8453562981E-01],
	[4.3570000000E+04, 5.3323995320E+01, 5.6697950743E+00, 3.8559809728E+01, 4.5236538459E+00, 9.8454296212E-01],
	[4.3575000000E+04, 5.3334853999E+01, 5.6698459816E+00, 3.8574408776E+01, 4.5239652524E+00, 9.8455029057E-01],
	[4.3580000000E+04, 5.3345713644E+01, 5.6698968835E+00, 3.8589011674E+01, 4.5242765738E+00, 9.8455761515E-01],
	[4.3585000000E+04, 5.3356574254E+01, 5.6699477800E+00, 3.8603618424E+01, 4.5245878102E+00, 9.8456493586E-01],
	[4.3590000000E+04, 5.3367435828E+01, 5.6699986712E+00, 3.8618229026E+01, 4.5248989615E+00, 9.8457225271E-01],
	[4.3595000000E+04, 5.3378298367E+01, 5.6700495569E+00, 3.8632843481E+01, 4.5252100278E+00, 9.8457956570E-01],
	[4.3600000000E+04, 5.3389161872E+01, 5.6701004373E+00, 3.8647461788E+01, 4.5255210092E+00, 9.8458687483E-01],
	[4.3605000000E+04, 5.3400026341E+01, 5.6701513123E+00, 3.8662083949E+01, 4.5258319056E+00, 9.8459418010E-01],
	[4.3610000000E+04, 5.3410891774E+01, 5.6702021819E+00, 3.8676709964E+01, 4.5261427171E+00, 9.8460148152E-01],
	[4.3615000000E+04, 5.3421758173E+01, 5.6702530462E+00, 3.8691339834E+01, 4.5264534436E+00, 9.8460877909E-01],
	[4.3620000000E+04, 5.3432625536E+01, 5.6703039050E+00, 3.8705973560E+01, 4.5267640854E+00, 9.8461607280E-01],
	[4.3625000000E+04, 5.3443493864E+01, 5.6703547585E+00, 3.8720611141E+01, 4.5270746422E+00, 9.8462336267E-01],
	[4.3630000000E+04, 5.3454363157E+01, 5.6704056067E+00, 3.8735252579E+01, 4.5273851143E+00, 9.8463064869E-01],
	[4.3635000000E+04, 5.3465233414E+01, 5.6704564494E+00, 3.8749897874E+01, 4.5276955016E+00, 9.8463793086E-01],
	[4.3640000000E+04, 5.3476104636E+01, 5.6705072868E+00, 3.8764547026E+01, 4.5280058041E+00, 9.8464520920E-01],
	[4.3645000000E+04, 5.3486976822E+01, 5.6705581188E+00, 3.8779200037E+01, 4.5283160219E+00, 9.8465248369E-01],
	[4.3650000000E+04, 5.3497849973E+01, 5.6706089455E+00, 3.8793856906E+01, 4.5286261550E+00, 9.8465975435E-01],
	[4.3655000000E+04, 5.3508724089E+01, 5.6706597668E+00, 3.8808517635E+01, 4.5289362035E+00, 9.8466702117E-01],
	[4.3660000000E+04, 5.3519599169E+01, 5.6707105827E+00, 3.8823182224E+01, 4.5292461673E+00, 9.8467428416E-01],
	[4.3665000000E+04, 5.3530475214E+01, 5.6707613932E+00, 3.8837850674E+01, 4.5295560465E+00, 9.8468154332E-01],
	[4.3670000000E+04, 5.3541352223E+01, 5.6708121984E+00, 3.8852522984E+01, 4.5298658410E+00, 9.8468879865E-01],
	[4.3675000000E+04, 5.3552230197E+01, 5.6708629983E+00, 3.8867199156E+01, 4.5301755511E+00, 9.8469605015E-01],
	[4.3680000000E+04, 5.3563109135E+01, 5.6709137927E+00, 3.8881879191E+01, 4.5304851766E+00, 9.8470329783E-01],
	[4.3685000000E+04, 5.3573989037E+01, 5.6709645818E+00, 3.8896563088E+01, 4.5307947176E+00, 9.8471054169E-01],
	[4.3690000000E+04, 5.3584869904E+01, 5.6710153656E+00, 3.8911250848E+01, 4.5311041741E+00, 9.8471778173E-01],
	[4.3695000000E+04, 5.3595751735E+01, 5.6710661440E+00, 3.8925942473E+01, 4.5314135462E+00, 9.8472501795E-01],
	[4.3700000000E+04, 5.3606634531E+01, 5.6711169170E+00, 3.8940637962E+01, 4.5317228338E+00, 9.8473225035E-01],
	[4.3705000000E+04, 5.3617518291E+01, 5.6711676847E+00, 3.8955337316E+01, 4.5320320371E+00, 9.8473947894E-01],
	[4.3710000000E+04, 5.3628403015E+01, 5.6712184471E+00, 3.8970040536E+01, 4.5323411560E+00, 9.8474670372E-01],
	[4.3715000000E+04, 5.3639288703E+01, 5.6712692040E+00, 3.8984747622E+01, 4.5326501906E+00, 9.8475392469E-01],
	[4.3720000000E+04, 5.3650175356E+01, 5.6713199557E+00, 3.8999458575E+01, 4.5329591408E+00, 9.8476114185E-01],
	[4.3725000000E+04, 5.3661062973E+01, 5.6713707020E+00, 3.9014173396E+01, 4.5332680068E+00, 9.8476835521E-01],
	[4.3730000000E+04, 5.3671951554E+01, 5.6714214429E+00, 3.9028892084E+01, 4.5335767885E+00, 9.8477556477E-01],
	[4.3735000000E+04, 5.3682841099E+01, 5.6714721785E+00, 3.9043614641E+01, 4.5338854860E+00, 9.8478277053E-01],
	[4.3740000000E+04, 5.3693731608E+01, 5.6715229087E+00, 3.9058341067E+01, 4.5341940993E+00, 9.8478997248E-01],
	[4.3745000000E+04, 5.3704623082E+01, 5.6715736336E+00, 3.9073071363E+01, 4.5345026284E+00, 9.8479717065E-01],
	[4.3750000000E+04, 5.3715515519E+01, 5.6716243531E+00, 3.9087805529E+01, 4.5348110734E+00, 9.8480436501E-01],
	[4.3755000000E+04, 5.3726408921E+01, 5.6716750674E+00, 3.9102543566E+01, 4.5351194343E+00, 9.8481155559E-01],
	[4.3760000000E+04, 5.3737303286E+01, 5.6717257762E+00, 3.9117285474E+01, 4.5354277111E+00, 9.8481874238E-01],
	[4.3765000000E+04, 5.3748198616E+01, 5.6717764797E+00, 3.9132031254E+01, 4.5357359038E+00, 9.8482592538E-01],
	[4.3770000000E+04, 5.3759094910E+01, 5.6718271779E+00, 3.9146780907E+01, 4.5360440125E+00, 9.8483310459E-01],
	[4.3775000000E+04, 5.3769992167E+01, 5.6718778708E+00, 3.9161534433E+01, 4.5363520371E+00, 9.8484028003E-01],
	[4.3780000000E+04, 5.3780890389E+01, 5.6719285583E+00, 3.9176291833E+01, 4.5366599779E+00, 9.8484745168E-01],
	[4.3785000000E+04, 5.3791789574E+01, 5.6719792405E+00, 3.9191053107E+01, 4.5369678346E+00, 9.8485461955E-01],
	[4.3790000000E+04, 5.3802689723E+01, 5.6720299173E+00, 3.9205818256E+01, 4.5372756075E+00, 9.8486178365E-01],
	[4.3795000000E+04, 5.3813590837E+01, 5.6720805888E+00, 3.9220587280E+01, 4.5375832964E+00, 9.8486894397E-01],
	[4.3800000000E+04, 5.3824492914E+01, 5.6721312550E+00, 3.9235360180E+01, 4.5378909015E+00, 9.8487610052E-01],
	[4.3805000000E+04, 5.3835395954E+01, 5.6721819158E+00, 3.9250136957E+01, 4.5381984227E+00, 9.8488325330E-01],
	[4.3810000000E+04, 5.3846299959E+01, 5.6722325713E+00, 3.9264917612E+01, 4.5385058602E+00, 9.8489040231E-01],
	[4.3815000000E+04, 5.3857204927E+01, 5.6722832215E+00, 3.9279702143E+01, 4.5388132138E+00, 9.8489754756E-01],
	[4.3820000000E+04, 5.3868110859E+01, 5.6723338664E+00, 3.9294490554E+01, 4.5391204837E+00, 9.8490468904E-01],
	[4.3825000000E+04, 5.3879017755E+01, 5.6723845059E+00, 3.9309282843E+01, 4.5394276699E+00, 9.8491182676E-01],
	[4.3830000000E+04, 5.3889925615E+01, 5.6724351401E+00, 3.9324079011E+01, 4.5397347723E+00, 9.8491896073E-01],
	[4.3835000000E+04, 5.3900834438E+01, 5.6724857690E+00, 3.9338879060E+01, 4.5400417911E+00, 9.8492609093E-01],
	[4.3840000000E+04, 5.3911744225E+01, 5.6725363926E+00, 3.9353682989E+01, 4.5403487263E+00, 9.8493321738E-01],
	[4.3845000000E+04, 5.3922654975E+01, 5.6725870108E+00, 3.9368490799E+01, 4.5406555778E+00, 9.8494034008E-01],
	[4.3850000000E+04, 5.3933566689E+01, 5.6726376237E+00, 3.9383302492E+01, 4.5409623457E+00, 9.8494745903E-01],
	[4.3855000000E+04, 5.3944479367E+01, 5.6726882313E+00, 3.9398118066E+01, 4.5412690301E+00, 9.8495457423E-01],
	[4.3860000000E+04, 5.3955393008E+01, 5.6727388336E+00, 3.9412937524E+01, 4.5415756310E+00, 9.8496168569E-01],
	[4.3865000000E+04, 5.3966307612E+01, 5.6727894306E+00, 3.9427760865E+01, 4.5418821483E+00, 9.8496879340E-01],
	[4.3870000000E+04, 5.3977223180E+01, 5.6728400222E+00, 3.9442588089E+01, 4.5421885822E+00, 9.8497589736E-01],
	[4.3875000000E+04, 5.3988139712E+01, 5.6728906086E+00, 3.9457419199E+01, 4.5424949326E+00, 9.8498299759E-01],
	[4.3880000000E+04, 5.3999067257E+01, 5.6729420749E+00, 3.9472254194E+01, 4.5428018384E+00, 9.8499009408E-01],
	[4.3885000000E+04, 5.4010007619E+01, 5.6729945797E+00, 3.9487093075E+01, 4.5431094142E+00, 9.8499718684E-01],
	[4.3890000000E+04, 5.4020948950E+01, 5.6730470789E+00, 3.9501935841E+01, 4.5434169067E+00, 9.8500427586E-01],
	[4.3895000000E+04, 5.4031891252E+01, 5.6730995727E+00, 3.9516782495E+01, 4.5437243160E+00, 9.8501136115E-01],
	[4.3900000000E+04, 5.4042834523E+01, 5.6731520610E+00, 3.9531633037E+01, 4.5440316421E+00, 9.8501844271E-01],
	[4.3905000000E+04, 5.4053778764E+01, 5.6732045437E+00, 3.9546487466E+01, 4.5443388851E+00, 9.8502552055E-01],
	[4.3910000000E+04, 5.4064723974E+01, 5.6732570210E+00, 3.9561345784E+01, 4.5446460450E+00, 9.8503259466E-01],
	[4.3915000000E+04, 5.4075670154E+01, 5.6733094928E+00, 3.9576207992E+01, 4.5449531217E+00, 9.8503966505E-01],
	[4.3920000000E+04, 5.4086617304E+01, 5.6733619591E+00, 3.9591074089E+01, 4.5452601154E+00, 9.8504673172E-01],
	[4.3925000000E+04, 5.4097565423E+01, 5.6734144199E+00, 3.9605944077E+01, 4.5455670260E+00, 9.8505379467E-01],
	[4.3930000000E+04, 5.4108514512E+01, 5.6734668753E+00, 3.9620817955E+01, 4.5458738536E+00, 9.8506085390E-01],
	[4.3935000000E+04, 5.4119464570E+01, 5.6735193251E+00, 3.9635695725E+01, 4.5461805983E+00, 9.8506790942E-01],
	[4.3940000000E+04, 5.4130415598E+01, 5.6735717695E+00, 3.9650577388E+01, 4.5464872599E+00, 9.8507496123E-01],
	[4.3945000000E+04, 5.4141367596E+01, 5.6736242084E+00, 3.9665462942E+01, 4.5467938386E+00, 9.8508200933E-01],
	[4.3950000000E+04, 5.4152320563E+01, 5.6736766418E+00, 3.9680352391E+01, 4.5471003345E+00, 9.8508905372E-01],
	[4.3955000000E+04, 5.4163274499E+01, 5.6737290697E+00, 3.9695245733E+01, 4.5474067474E+00, 9.8509609441E-01],
	[4.3960000000E+04, 5.4174229405E+01, 5.6737814921E+00, 3.9710142969E+01, 4.5477130775E+00, 9.8510313139E-01],
	[4.3965000000E+04, 5.4185185280E+01, 5.6738339091E+00, 3.9725044100E+01, 4.5480193247E+00, 9.8511016467E-01],
	[4.3970000000E+04, 5.4196142124E+01, 5.6738863206E+00, 3.9739949127E+01, 4.5483254892E+00, 9.8511719425E-01],
	[4.3975000000E+04, 5.4207099938E+01, 5.6739387266E+00, 3.9754858050E+01, 4.5486315708E+00, 9.8512422014E-01],
	[4.3980000000E+04, 5.4218058721E+01, 5.6739911271E+00, 3.9769770870E+01, 4.5489375698E+00, 9.8513124233E-01],
	[4.3985000000E+04, 5.4229018474E+01, 5.6740435222E+00, 3.9784687587E+01, 4.5492434860E+00, 9.8513826083E-01],
	[4.3990000000E+04, 5.4239979195E+01, 5.6740959118E+00, 3.9799608202E+01, 4.5495493195E+00, 9.8514527564E-01],
	[4.3995000000E+04, 5.4250940886E+01, 5.6741482959E+00, 3.9814532715E+01, 4.5498550703E+00, 9.8515228676E-01],
	[4.4000000000E+04, 5.4261903547E+01, 5.6742006746E+00, 3.9829461128E+01, 4.5501607385E+00, 9.8515929420E-01],
	[4.4005000000E+04, 5.4272867176E+01, 5.6742530478E+00, 3.9844393440E+01, 4.5504663241E+00, 9.8516629795E-01],
	[4.4010000000E+04, 5.4283831774E+01, 5.6743054155E+00, 3.9859329652E+01, 4.5507718272E+00, 9.8517329802E-01],
	[4.4015000000E+04, 5.4294797342E+01, 5.6743577777E+00, 3.9874269765E+01, 4.5510772476E+00, 9.8518029441E-01],
	[4.4020000000E+04, 5.4305763879E+01, 5.6744101345E+00, 3.9889213779E+01, 4.5513825856E+00, 9.8518728712E-01],
	[4.4025000000E+04, 5.4316731385E+01, 5.6744624858E+00, 3.9904161695E+01, 4.5516878410E+00, 9.8519427616E-01],
	[4.4030000000E+04, 5.4327699860E+01, 5.6745148317E+00, 3.9919113514E+01, 4.5519930140E+00, 9.8520126152E-01],
	[4.4035000000E+04, 5.4338669304E+01, 5.6745671721E+00, 3.9934069235E+01, 4.5522981045E+00, 9.8520824321E-01],
	[4.4040000000E+04, 5.4349639717E+01, 5.6746195070E+00, 3.9949028860E+01, 4.5526031126E+00, 9.8521522124E-01],
	[4.4045000000E+04, 5.4360611099E+01, 5.6746718365E+00, 3.9963992390E+01, 4.5529080383E+00, 9.8522219560E-01],
	[4.4050000000E+04, 5.4371583450E+01, 5.6747241605E+00, 3.9978959824E+01, 4.5532128816E+00, 9.8522916629E-01],
	[4.4055000000E+04, 5.4382556770E+01, 5.6747764791E+00, 3.9993931163E+01, 4.5535176426E+00, 9.8523613332E-01],
	[4.4060000000E+04, 5.4393531059E+01, 5.6748287922E+00, 4.0008906409E+01, 4.5538223213E+00, 9.8524309669E-01],
	[4.4065000000E+04, 5.4404506317E+01, 5.6748810999E+00, 4.0023885560E+01, 4.5541269177E+00, 9.8525005640E-01],
	[4.4070000000E+04, 5.4415482543E+01, 5.6749334021E+00, 4.0038868619E+01, 4.5544314318E+00, 9.8525701245E-01],
	[4.4075000000E+04, 5.4426459739E+01, 5.6749856988E+00, 4.0053855586E+01, 4.5547358637E+00, 9.8526396486E-01],
	[4.4080000000E+04, 5.4437437903E+01, 5.6750379901E+00, 4.0068846461E+01, 4.5550402135E+00, 9.8527091360E-01],
	[4.4085000000E+04, 5.4448417037E+01, 5.6750902760E+00, 4.0083841244E+01, 4.5553444810E+00, 9.8527785870E-01],
	[4.4090000000E+04, 5.4459397138E+01, 5.6751425564E+00, 4.0098839937E+01, 4.5556486664E+00, 9.8528480016E-01],
	[4.4095000000E+04, 5.4470378209E+01, 5.6751948313E+00, 4.0113842540E+01, 4.5559527696E+00, 9.8529173796E-01],
	[4.4100000000E+04, 5.4481360249E+01, 5.6752471008E+00, 4.0128849053E+01, 4.5562567908E+00, 9.8529867212E-01],
	[4.4105000000E+04, 5.4492343257E+01, 5.6752993649E+00, 4.0143859478E+01, 4.5565607299E+00, 9.8530560265E-01],
	[4.4110000000E+04, 5.4503327234E+01, 5.6753516235E+00, 4.0158873814E+01, 4.5568645870E+00, 9.8531252953E-01],
	[4.4115000000E+04, 5.4514312179E+01, 5.6754038767E+00, 4.0173892062E+01, 4.5571683620E+00, 9.8531945277E-01],
	[4.4120000000E+04, 5.4525298093E+01, 5.6754561245E+00, 4.0188914224E+01, 4.5574720551E+00, 9.8532637238E-01],
	[4.4125000000E+04, 5.4536284976E+01, 5.6755083668E+00, 4.0203940298E+01, 4.5577756662E+00, 9.8533328836E-01],
	[4.4130000000E+04, 5.4547272827E+01, 5.6755606036E+00, 4.0218970287E+01, 4.5580791953E+00, 9.8534020071E-01],
	[4.4135000000E+04, 5.4558261647E+01, 5.6756128350E+00, 4.0234004190E+01, 4.5583826426E+00, 9.8534710943E-01],
	[4.4140000000E+04, 5.4569251436E+01, 5.6756650610E+00, 4.0249042008E+01, 4.5586860080E+00, 9.8535401452E-01],
	[4.4145000000E+04, 5.4580242193E+01, 5.6757172816E+00, 4.0264083742E+01, 4.5589892915E+00, 9.8536091599E-01],
	[4.4150000000E+04, 5.4591233918E+01, 5.6757694967E+00, 4.0279129392E+01, 4.5592924932E+00, 9.8536781383E-01],
	[4.4155000000E+04, 5.4602226612E+01, 5.6758217064E+00, 4.0294178959E+01, 4.5595956131E+00, 9.8537470806E-01],
	[4.4160000000E+04, 5.4613220274E+01, 5.6758739106E+00, 4.0309232444E+01, 4.5598986512E+00, 9.8538159867E-01],
	[4.4165000000E+04, 5.4624214905E+01, 5.6759261095E+00, 4.0324289846E+01, 4.5602016076E+00, 9.8538848566E-01],
	[4.4170000000E+04, 5.4635210504E+01, 5.6759783029E+00, 4.0339351167E+01, 4.5605044823E+00, 9.8539536904E-01],
	[4.4175000000E+04, 5.4646207072E+01, 5.6760304908E+00, 4.0354416408E+01, 4.5608072753E+00, 9.8540224880E-01],
	[4.4180000000E+04, 5.4657204608E+01, 5.6760826734E+00, 4.0369485568E+01, 4.5611099866E+00, 9.8540912496E-01],
	[4.4185000000E+04, 5.4668203112E+01, 5.6761348505E+00, 4.0384558648E+01, 4.5614126163E+00, 9.8541599751E-01],
	[4.4190000000E+04, 5.4679202584E+01, 5.6761870222E+00, 4.0399635649E+01, 4.5617151644E+00, 9.8542286645E-01],
	[4.4195000000E+04, 5.4690203025E+01, 5.6762391884E+00, 4.0414716572E+01, 4.5620176309E+00, 9.8542973179E-01],
	[4.4200000000E+04, 5.4701204434E+01, 5.6762913493E+00, 4.0429801416E+01, 4.5623200158E+00, 9.8543659353E-01],
	[4.4205000000E+04, 5.4712206811E+01, 5.6763435047E+00, 4.0444890184E+01, 4.5626223192E+00, 9.8544345167E-01],
	[4.4210000000E+04, 5.4723210156E+01, 5.6763956547E+00, 4.0459982874E+01, 4.5629245411E+00, 9.8545030622E-01],
	[4.4215000000E+04, 5.4734214470E+01, 5.6764477993E+00, 4.0475079488E+01, 4.5632266815E+00, 9.8545715716E-01],
	[4.4220000000E+04, 5.4745219752E+01, 5.6764999385E+00, 4.0490180027E+01, 4.5635287405E+00, 9.8546400452E-01],
	[4.4225000000E+04, 5.4756226002E+01, 5.6765520722E+00, 4.0505284490E+01, 4.5638307181E+00, 9.8547084829E-01],
	[4.4230000000E+04, 5.4767233219E+01, 5.6766042005E+00, 4.0520392879E+01, 4.5641326142E+00, 9.8547768846E-01],
	[4.4235000000E+04, 5.4778241405E+01, 5.6766563235E+00, 4.0535505194E+01, 4.5644344290E+00, 9.8548452505E-01],
	[4.4240000000E+04, 5.4789250560E+01, 5.6767084410E+00, 4.0550621436E+01, 4.5647361625E+00, 9.8549135806E-01],
	[4.4245000000E+04, 5.4800260682E+01, 5.6767605531E+00, 4.0565741604E+01, 4.5650378146E+00, 9.8549818748E-01],
	[4.4250000000E+04, 5.4811271772E+01, 5.6768126598E+00, 4.0580865701E+01, 4.5653393855E+00, 9.8550501333E-01],
	[4.4255000000E+04, 5.4822283830E+01, 5.6768647610E+00, 4.0595993726E+01, 4.5656408751E+00, 9.8551183560E-01],
	[4.4260000000E+04, 5.4833296856E+01, 5.6769168569E+00, 4.0611125680E+01, 4.5659422835E+00, 9.8551865429E-01],
	[4.4265000000E+04, 5.4844310850E+01, 5.6769689474E+00, 4.0626261563E+01, 4.5662436106E+00, 9.8552546940E-01],
	[4.4270000000E+04, 5.4855325812E+01, 5.6770210324E+00, 4.0641401377E+01, 4.5665448566E+00, 9.8553228095E-01],
	[4.4275000000E+04, 5.4866341741E+01, 5.6770731121E+00, 4.0656545121E+01, 4.5668460214E+00, 9.8553908892E-01],
	[4.4280000000E+04, 5.4877358639E+01, 5.6771251863E+00, 4.0671692797E+01, 4.5671471051E+00, 9.8554589333E-01],
	[4.4285000000E+04, 5.4888376504E+01, 5.6771772552E+00, 4.0686844404E+01, 4.5674481077E+00, 9.8555269417E-01],
	[4.4290000000E+04, 5.4899395337E+01, 5.6772293186E+00, 4.0701999944E+01, 4.5677490292E+00, 9.8555949145E-01],
	[4.4295000000E+04, 5.4910415139E+01, 5.6772813767E+00, 4.0717159416E+01, 4.5680498697E+00, 9.8556628517E-01],
	[4.4300000000E+04, 5.4921435907E+01, 5.6773334293E+00, 4.0732322823E+01, 4.5683506291E+00, 9.8557307533E-01],
	[4.4305000000E+04, 5.4932457644E+01, 5.6773854766E+00, 4.0747490163E+01, 4.5686513076E+00, 9.8557986193E-01],
	[4.4310000000E+04, 5.4943480348E+01, 5.6774375184E+00, 4.0762661438E+01, 4.5689519051E+00, 9.8558664498E-01],
	[4.4315000000E+04, 5.4954504020E+01, 5.6774895549E+00, 4.0777836648E+01, 4.5692524216E+00, 9.8559342447E-01],
	[4.4320000000E+04, 5.4965528659E+01, 5.6775415859E+00, 4.0793015795E+01, 4.5695528573E+00, 9.8560020042E-01],
	[4.4325000000E+04, 5.4976554267E+01, 5.6775936116E+00, 4.0808198877E+01, 4.5698532120E+00, 9.8560697281E-01],
	[4.4330000000E+04, 5.4987580841E+01, 5.6776456319E+00, 4.0823385897E+01, 4.5701534859E+00, 9.8561374166E-01],
	[4.4335000000E+04, 5.4998608384E+01, 5.6776976468E+00, 4.0838576854E+01, 4.5704536790E+00, 9.8562050696E-01],
	[4.4340000000E+04, 5.5009636894E+01, 5.6777496563E+00, 4.0853771750E+01, 4.5707537913E+00, 9.8562726872E-01],
	[4.4345000000E+04, 5.5020666371E+01, 5.6778016604E+00, 4.0868970584E+01, 4.5710538227E+00, 9.8563402695E-01],
	[4.4350000000E+04, 5.5031696816E+01, 5.6778536591E+00, 4.0884173357E+01, 4.5713537735E+00, 9.8564078163E-01],
	[4.4355000000E+04, 5.5042728229E+01, 5.6779056525E+00, 4.0899380071E+01, 4.5716536435E+00, 9.8564753277E-01],
	[4.4360000000E+04, 5.5053760609E+01, 5.6779576404E+00, 4.0914590725E+01, 4.5719534328E+00, 9.8565428039E-01],
	[4.4365000000E+04, 5.5064793956E+01, 5.6780096230E+00, 4.0929805320E+01, 4.5722531414E+00, 9.8566102447E-01],
	[4.4370000000E+04, 5.5075828271E+01, 5.6780616002E+00, 4.0945023856E+01, 4.5725527694E+00, 9.8566776502E-01],
	[4.4375000000E+04, 5.5086863553E+01, 5.6781135720E+00, 4.0960246335E+01, 4.5728523167E+00, 9.8567450204E-01],
	[4.4380000000E+04, 5.5097899803E+01, 5.6781655384E+00, 4.0975472756E+01, 4.5731517835E+00, 9.8568123554E-01],
	[4.4385000000E+04, 5.5108937020E+01, 5.6782174995E+00, 4.0990703121E+01, 4.5734511697E+00, 9.8568796551E-01],
	[4.4390000000E+04, 5.5119975204E+01, 5.6782694551E+00, 4.1005937430E+01, 4.5737504753E+00, 9.8569469196E-01],
	[4.4395000000E+04, 5.5131014356E+01, 5.6783214054E+00, 4.1021175683E+01, 4.5740497005E+00, 9.8570141490E-01],
	[4.4400000000E+04, 5.5142054475E+01, 5.6783733503E+00, 4.1036417882E+01, 4.5743488451E+00, 9.8570813431E-01],
	[4.4405000000E+04, 5.5153095561E+01, 5.6784252899E+00, 4.1051664026E+01, 4.5746479093E+00, 9.8571485021E-01],
	[4.4410000000E+04, 5.5164137614E+01, 5.6784772241E+00, 4.1066914116E+01, 4.5749468931E+00, 9.8572156260E-01],
	[4.4415000000E+04, 5.5175180635E+01, 5.6785291529E+00, 4.1082168153E+01, 4.5752457965E+00, 9.8572827147E-01],
	[4.4420000000E+04, 5.5186224622E+01, 5.6785810763E+00, 4.1097426138E+01, 4.5755446195E+00, 9.8573497684E-01],
	[4.4425000000E+04, 5.5197269577E+01, 5.6786329943E+00, 4.1112688070E+01, 4.5758433621E+00, 9.8574167870E-01],
	[4.4430000000E+04, 5.5208315499E+01, 5.6786849070E+00, 4.1127953951E+01, 4.5761420244E+00, 9.8574837705E-01],
	[4.4435000000E+04, 5.5219362388E+01, 5.6787368144E+00, 4.1143223781E+01, 4.5764406064E+00, 9.8575507190E-01],
	[4.4440000000E+04, 5.5230410245E+01, 5.6787887163E+00, 4.1158497561E+01, 4.5767391081E+00, 9.8576176325E-01],
	[4.4445000000E+04, 5.5241459068E+01, 5.6788406129E+00, 4.1173775291E+01, 4.5770375296E+00, 9.8576845110E-01],
	[4.4450000000E+04, 5.5252508858E+01, 5.6788925041E+00, 4.1189056972E+01, 4.5773358708E+00, 9.8577513546E-01],
	[4.4455000000E+04, 5.5263559615E+01, 5.6789443900E+00, 4.1204342604E+01, 4.5776341319E+00, 9.8578181631E-01],
	[4.4460000000E+04, 5.5274611340E+01, 5.6789962705E+00, 4.1219632189E+01, 4.5779323128E+00, 9.8578849368E-01],
	[4.4465000000E+04, 5.5285664031E+01, 5.6790481457E+00, 4.1234925726E+01, 4.5782304135E+00, 9.8579516756E-01],
	[4.4470000000E+04, 5.5296717689E+01, 5.6791000154E+00, 4.1250223216E+01, 4.5785284341E+00, 9.8580183796E-01],
	[4.4475000000E+04, 5.5307772314E+01, 5.6791518799E+00, 4.1265524660E+01, 4.5788263747E+00, 9.8580850490E-01],
	[4.4480000000E+04, 5.5318827906E+01, 5.6792037389E+00, 4.1280830058E+01, 4.5791242352E+00, 9.8581516836E-01],
	[4.4485000000E+04, 5.5329884465E+01, 5.6792555927E+00, 4.1296139411E+01, 4.5794220156E+00, 9.8582182835E-01],
	[4.4490000000E+04, 5.5340941991E+01, 5.6793074410E+00, 4.1311452720E+01, 4.5797197160E+00, 9.8582848487E-01],
	[4.4495000000E+04, 5.5352000483E+01, 5.6793592840E+00, 4.1326769984E+01, 4.5800173365E+00, 9.8583513793E-01],
	[4.4500000000E+04, 5.5363059942E+01, 5.6794111217E+00, 4.1342091205E+01, 4.5803148770E+00, 9.8584178752E-01],
	[4.4505000000E+04, 5.5374120368E+01, 5.6794629540E+00, 4.1357416384E+01, 4.5806123375E+00, 9.8584843366E-01],
	[4.4510000000E+04, 5.5385181761E+01, 5.6795147809E+00, 4.1372745520E+01, 4.5809097182E+00, 9.8585507633E-01],
	[4.4515000000E+04, 5.5396244121E+01, 5.6795666025E+00, 4.1388078615E+01, 4.5812070190E+00, 9.8586171554E-01],
	[4.4520000000E+04, 5.5407307447E+01, 5.6796184188E+00, 4.1403415668E+01, 4.5815042399E+00, 9.8586835130E-01],
	[4.4525000000E+04, 5.5418371740E+01, 5.6796702297E+00, 4.1418756681E+01, 4.5818013810E+00, 9.8587498360E-01],
	[4.4530000000E+04, 5.5429436999E+01, 5.6797220353E+00, 4.1434101654E+01, 4.5820984423E+00, 9.8588161245E-01],
	[4.4535000000E+04, 5.5440503225E+01, 5.6797738355E+00, 4.1449450588E+01, 4.5823954238E+00, 9.8588823785E-01],
	[4.4540000000E+04, 5.5451570418E+01, 5.6798256304E+00, 4.1464803483E+01, 4.5826923256E+00, 9.8589485979E-01],
	[4.4545000000E+04, 5.5462638577E+01, 5.6798774199E+00, 4.1480160340E+01, 4.5829891477E+00, 9.8590147829E-01],
	[4.4550000000E+04, 5.5473707703E+01, 5.6799292041E+00, 4.1495521159E+01, 4.5832858900E+00, 9.8590809335E-01],
	[4.4555000000E+04, 5.5484777796E+01, 5.6799809830E+00, 4.1510885941E+01, 4.5835825528E+00, 9.8591470495E-01],
	[4.4560000000E+04, 5.5495848855E+01, 5.6800327565E+00, 4.1526254687E+01, 4.5838791358E+00, 9.8592131312E-01],
	[4.4565000000E+04, 5.5506920880E+01, 5.6800845247E+00, 4.1541627396E+01, 4.5841756393E+00, 9.8592791784E-01],
	[4.4570000000E+04, 5.5517993872E+01, 5.6801362875E+00, 4.1557004071E+01, 4.5844720631E+00, 9.8593451913E-01],
	[4.4575000000E+04, 5.5529067830E+01, 5.6801880450E+00, 4.1572384711E+01, 4.5847684074E+00, 9.8594111697E-01],
	[4.4580000000E+04, 5.5540142755E+01, 5.6802397972E+00, 4.1587769316E+01, 4.5850646722E+00, 9.8594771139E-01],
	[4.4585000000E+04, 5.5551222679E+01, 5.6802918929E+00, 4.1603157888E+01, 4.5853611122E+00, 9.8595430236E-01],
	[4.4590000000E+04, 5.5562321380E+01, 5.6803455233E+00, 4.1618550428E+01, 4.5856585978E+00, 9.8596088991E-01],
	[4.4595000000E+04, 5.5573421053E+01, 5.6803991482E+00, 4.1633946934E+01, 4.5859560041E+00, 9.8596747402E-01],
	[4.4600000000E+04, 5.5584521700E+01, 5.6804527677E+00, 4.1649347409E+01, 4.5862533311E+00, 9.8597405471E-01],
	[4.4605000000E+04, 5.5595623319E+01, 5.6805063816E+00, 4.1664751853E+01, 4.5865505788E+00, 9.8598063196E-01],
	[4.4610000000E+04, 5.5606725910E+01, 5.6805599900E+00, 4.1680160266E+01, 4.5868477472E+00, 9.8598720579E-01],
	[4.4615000000E+04, 5.5617829474E+01, 5.6806135929E+00, 4.1695572649E+01, 4.5871448364E+00, 9.8599377620E-01],
	[4.4620000000E+04, 5.5628934011E+01, 5.6806671903E+00, 4.1710989002E+01, 4.5874418464E+00, 9.8600034319E-01],
	[4.4625000000E+04, 5.5640039520E+01, 5.6807207823E+00, 4.1726409326E+01, 4.5877387772E+00, 9.8600690676E-01],
	[4.4630000000E+04, 5.5651146001E+01, 5.6807743687E+00, 4.1741833622E+01, 4.5880356288E+00, 9.8601346690E-01],
	[4.4635000000E+04, 5.5662253455E+01, 5.6808279496E+00, 4.1757261891E+01, 4.5883324014E+00, 9.8602002363E-01],
	[4.4640000000E+04, 5.5673361881E+01, 5.6808815250E+00, 4.1772694132E+01, 4.5886290948E+00, 9.8602657695E-01],
	[4.4645000000E+04, 5.5684471279E+01, 5.6809350950E+00, 4.1788130346E+01, 4.5889257091E+00, 9.8603312685E-01],
	[4.4650000000E+04, 5.5695581650E+01, 5.6809886594E+00, 4.1803570534E+01, 4.5892222444E+00, 9.8603967335E-01],
	[4.4655000000E+04, 5.5706692993E+01, 5.6810422183E+00, 4.1819014697E+01, 4.5895187007E+00, 9.8604621643E-01],
	[4.4660000000E+04, 5.5717805309E+01, 5.6810957718E+00, 4.1834462835E+01, 4.5898150780E+00, 9.8605275610E-01],
	[4.4665000000E+04, 5.5728918596E+01, 5.6811493197E+00, 4.1849914949E+01, 4.5901113763E+00, 9.8605929237E-01],
	[4.4670000000E+04, 5.5740032856E+01, 5.6812028622E+00, 4.1865371039E+01, 4.5904075957E+00, 9.8606582523E-01],
	[4.4675000000E+04, 5.5751148089E+01, 5.6812563992E+00, 4.1880831105E+01, 4.5907037361E+00, 9.8607235469E-01],
	[4.4680000000E+04, 5.5762264293E+01, 5.6813099307E+00, 4.1896295149E+01, 4.5909997977E+00, 9.8607888075E-01],
	[4.4685000000E+04, 5.5773381470E+01, 5.6813634567E+00, 4.1911763172E+01, 4.5912957803E+00, 9.8608540341E-01],
	[4.4690000000E+04, 5.5784499618E+01, 5.6814169772E+00, 4.1927235172E+01, 4.5915916842E+00, 9.8609192267E-01],
	[4.4695000000E+04, 5.5795618739E+01, 5.6814704923E+00, 4.1942711152E+01, 4.5918875092E+00, 9.8609843854E-01],
	[4.4700000000E+04, 5.5806738832E+01, 5.6815240018E+00, 4.1958191112E+01, 4.5921832554E+00, 9.8610495101E-01],
	[4.4705000000E+04, 5.5817859897E+01, 5.6815775059E+00, 4.1973675051E+01, 4.5924789229E+00, 9.8611146009E-01],
	[4.4710000000E+04, 5.5828981934E+01, 5.6816310045E+00, 4.1989162972E+01, 4.5927745117E+00, 9.8611796578E-01],
	[4.4715000000E+04, 5.5840104943E+01, 5.6816844976E+00, 4.2004654874E+01, 4.5930700217E+00, 9.8612446808E-01],
	[4.4720000000E+04, 5.5851228924E+01, 5.6817379853E+00, 4.2020150758E+01, 4.5933654530E+00, 9.8613096699E-01],
	[4.4725000000E+04, 5.5862353877E+01, 5.6817914674E+00, 4.2035650625E+01, 4.5936608057E+00, 9.8613746252E-01],
	[4.4730000000E+04, 5.5873479803E+01, 5.6818449441E+00, 4.2051154475E+01, 4.5939560798E+00, 9.8614395466E-01],
	[4.4735000000E+04, 5.5884606700E+01, 5.6818984153E+00, 4.2066662309E+01, 4.5942512752E+00, 9.8615044343E-01],
	[4.4740000000E+04, 5.5895734568E+01, 5.6819518811E+00, 4.2082174127E+01, 4.5945463921E+00, 9.8615692881E-01],
	[4.4745000000E+04, 5.5906863409E+01, 5.6820053413E+00, 4.2097689930E+01, 4.5948414304E+00, 9.8616341081E-01],
	[4.4750000000E+04, 5.5917993222E+01, 5.6820587961E+00, 4.2113209719E+01, 4.5951363901E+00, 9.8616988944E-01],
	[4.4755000000E+04, 5.5929124006E+01, 5.6821122455E+00, 4.2128733493E+01, 4.5954312714E+00, 9.8617636469E-01],
	[4.4760000000E+04, 5.5940255763E+01, 5.6821656893E+00, 4.2144261255E+01, 4.5957260742E+00, 9.8618283657E-01],
	[4.4765000000E+04, 5.5951388491E+01, 5.6822191277E+00, 4.2159793003E+01, 4.5960207985E+00, 9.8618930508E-01],
	[4.4770000000E+04, 5.5962522191E+01, 5.6822725606E+00, 4.2175328739E+01, 4.5963154444E+00, 9.8619577022E-01],
	[4.4775000000E+04, 5.5973656862E+01, 5.6823259881E+00, 4.2190868464E+01, 4.5966100120E+00, 9.8620223199E-01],
	[4.4780000000E+04, 5.5984792506E+01, 5.6823794101E+00, 4.2206412178E+01, 4.5969045011E+00, 9.8620869039E-01],
	[4.4785000000E+04, 5.5995929121E+01, 5.6824328266E+00, 4.2221959881E+01, 4.5971989119E+00, 9.8621514543E-01],
	[4.4790000000E+04, 5.6007066708E+01, 5.6824862377E+00, 4.2237511574E+01, 4.5974932444E+00, 9.8622159711E-01],
	[4.4795000000E+04, 5.6018205266E+01, 5.6825396433E+00, 4.2253067258E+01, 4.5977874985E+00, 9.8622804542E-01],
	[4.4800000000E+04, 5.6029344796E+01, 5.6825930435E+00, 4.2268626934E+01, 4.5980816744E+00, 9.8623449038E-01],
	[4.4805000000E+04, 5.6040485298E+01, 5.6826464382E+00, 4.2284190601E+01, 4.5983757721E+00, 9.8624093198E-01],
	[4.4810000000E+04, 5.6051626771E+01, 5.6826998274E+00, 4.2299758261E+01, 4.5986697915E+00, 9.8624737022E-01],
	[4.4815000000E+04, 5.6062769216E+01, 5.6827532112E+00, 4.2315329913E+01, 4.5989637328E+00, 9.8625380511E-01],
	[4.4820000000E+04, 5.6073912632E+01, 5.6828065896E+00, 4.2330905560E+01, 4.5992575958E+00, 9.8626023665E-01],
	[4.4825000000E+04, 5.6085057020E+01, 5.6828599624E+00, 4.2346485200E+01, 4.5995513808E+00, 9.8626666484E-01],
	[4.4830000000E+04, 5.6096202379E+01, 5.6829133299E+00, 4.2362068835E+01, 4.5998450876E+00, 9.8627308968E-01],
	[4.4835000000E+04, 5.6107348710E+01, 5.6829666918E+00, 4.2377656466E+01, 4.6001387163E+00, 9.8627951117E-01],
	[4.4840000000E+04, 5.6118496012E+01, 5.6830200484E+00, 4.2393248092E+01, 4.6004322670E+00, 9.8628592931E-01],
	[4.4845000000E+04, 5.6129644285E+01, 5.6830733995E+00, 4.2408843715E+01, 4.6007257396E+00, 9.8629234411E-01],
	[4.4850000000E+04, 5.6140793530E+01, 5.6831267451E+00, 4.2424443335E+01, 4.6010191342E+00, 9.8629875558E-01],
	[4.4855000000E+04, 5.6151943747E+01, 5.6831800853E+00, 4.2440046953E+01, 4.6013124508E+00, 9.8630516370E-01],
	[4.4860000000E+04, 5.6163094935E+01, 5.6832334200E+00, 4.2455654568E+01, 4.6016056895E+00, 9.8631156848E-01],
	[4.4865000000E+04, 5.6174247094E+01, 5.6832867493E+00, 4.2471266183E+01, 4.6018988502E+00, 9.8631796992E-01],
	[4.4870000000E+04, 5.6185400224E+01, 5.6833400732E+00, 4.2486881797E+01, 4.6021919330E+00, 9.8632436803E-01],
	[4.4875000000E+04, 5.6196554325E+01, 5.6833933916E+00, 4.2502501411E+01, 4.6024849379E+00, 9.8633076281E-01],
	[4.4880000000E+04, 5.6207709398E+01, 5.6834467045E+00, 4.2518125026E+01, 4.6027778650E+00, 9.8633715426E-01],
	[4.4885000000E+04, 5.6218865442E+01, 5.6835000121E+00, 4.2533752641E+01, 4.6030707142E+00, 9.8634354237E-01],
	[4.4890000000E+04, 5.6230022458E+01, 5.6835533142E+00, 4.2549384259E+01, 4.6033634857E+00, 9.8634992716E-01],
	[4.4895000000E+04, 5.6241180444E+01, 5.6836066108E+00, 4.2565019878E+01, 4.6036561793E+00, 9.8635630863E-01],
	[4.4900000000E+04, 5.6252339402E+01, 5.6836599021E+00, 4.2580659501E+01, 4.6039487952E+00, 9.8636268676E-01],
	[4.4905000000E+04, 5.6263499330E+01, 5.6837131878E+00, 4.2596303127E+01, 4.6042413333E+00, 9.8636906158E-01],
	[4.4910000000E+04, 5.6274660230E+01, 5.6837664682E+00, 4.2611950756E+01, 4.6045337938E+00, 9.8637543307E-01],
	[4.4915000000E+04, 5.6285822101E+01, 5.6838197431E+00, 4.2627602391E+01, 4.6048261766E+00, 9.8638180125E-01],
	[4.4920000000E+04, 5.6296984943E+01, 5.6838730126E+00, 4.2643258030E+01, 4.6051184817E+00, 9.8638816611E-01],
	[4.4925000000E+04, 5.6308148756E+01, 5.6839262767E+00, 4.2658917676E+01, 4.6054107092E+00, 9.8639452765E-01],
	[4.4930000000E+04, 5.6319313540E+01, 5.6839795353E+00, 4.2674581328E+01, 4.6057028591E+00, 9.8640088588E-01],
	[4.4935000000E+04, 5.6330479295E+01, 5.6840327885E+00, 4.2690248986E+01, 4.6059949314E+00, 9.8640724080E-01],
	[4.4940000000E+04, 5.6341646021E+01, 5.6840860363E+00, 4.2705920652E+01, 4.6062869262E+00, 9.8641359240E-01],
	[4.4945000000E+04, 5.6352813718E+01, 5.6841392787E+00, 4.2721596326E+01, 4.6065788434E+00, 9.8641994070E-01],
	[4.4950000000E+04, 5.6363982386E+01, 5.6841925156E+00, 4.2737276009E+01, 4.6068706831E+00, 9.8642628569E-01],
	[4.4955000000E+04, 5.6375152025E+01, 5.6842457471E+00, 4.2752959701E+01, 4.6071624454E+00, 9.8643262737E-01],
	[4.4960000000E+04, 5.6386322635E+01, 5.6842989732E+00, 4.2768647403E+01, 4.6074541302E+00, 9.8643896576E-01],
	[4.4965000000E+04, 5.6397494215E+01, 5.6843521938E+00, 4.2784339115E+01, 4.6077457376E+00, 9.8644530083E-01],
	[4.4970000000E+04, 5.6408666766E+01, 5.6844054091E+00, 4.2800034838E+01, 4.6080372676E+00, 9.8645163261E-01],
	[4.4975000000E+04, 5.6419840288E+01, 5.6844586189E+00, 4.2815734573E+01, 4.6083287202E+00, 9.8645796110E-01],
	[4.4980000000E+04, 5.6431014781E+01, 5.6845118233E+00, 4.2831438320E+01, 4.6086200955E+00, 9.8646428628E-01],
	[4.4985000000E+04, 5.6442190245E+01, 5.6845650223E+00, 4.2847146079E+01, 4.6089113935E+00, 9.8647060817E-01],
	[4.4990000000E+04, 5.6453366679E+01, 5.6846182159E+00, 4.2862857852E+01, 4.6092026141E+00, 9.8647692677E-01],
	[4.4995000000E+04, 5.6464544084E+01, 5.6846714041E+00, 4.2878573639E+01, 4.6094937575E+00, 9.8648324207E-01],
	[4.5000000000E+04, 5.6475722460E+01, 5.6847245868E+00, 4.2894293440E+01, 4.6097848236E+00, 9.8648955409E-01],
	[4.5005000000E+04, 5.6486901806E+01, 5.6847777642E+00, 4.2910040406E+01, 4.6100760798E+00, 9.8649586282E-01],
	[4.5010000000E+04, 5.6498082124E+01, 5.6848309361E+00, 4.2925791402E+01, 4.6103672586E+00, 9.8650216826E-01],
	[4.5015000000E+04, 5.6509263411E+01, 5.6848841026E+00, 4.2941546430E+01, 4.6106583600E+00, 9.8650847042E-01],
	[4.5020000000E+04, 5.6520445669E+01, 5.6849372637E+00, 4.2957305488E+01, 4.6109493842E+00, 9.8651476929E-01],
	[4.5025000000E+04, 5.6531628898E+01, 5.6849904194E+00, 4.2973068578E+01, 4.6112403311E+00, 9.8652106489E-01],
	[4.5030000000E+04, 5.6542813098E+01, 5.6850435697E+00, 4.2988835701E+01, 4.6115312007E+00, 9.8652735720E-01],
	[4.5035000000E+04, 5.6553998267E+01, 5.6850967146E+00, 4.3004606856E+01, 4.6118219932E+00, 9.8653364624E-01],
	[4.5040000000E+04, 5.6565184408E+01, 5.6851498541E+00, 4.3020382045E+01, 4.6121127084E+00, 9.8653993200E-01],
	[4.5045000000E+04, 5.6576371519E+01, 5.6852029882E+00, 4.3036161269E+01, 4.6124033464E+00, 9.8654621449E-01],
	[4.5050000000E+04, 5.6587559600E+01, 5.6852561169E+00, 4.3051944527E+01, 4.6126939073E+00, 9.8655249370E-01],
	[4.5055000000E+04, 5.6598748652E+01, 5.6853092402E+00, 4.3067731820E+01, 4.6129843911E+00, 9.8655876965E-01],
	[4.5060000000E+04, 5.6609938674E+01, 5.6853623581E+00, 4.3083523150E+01, 4.6132747978E+00, 9.8656504232E-01],
	[4.5065000000E+04, 5.6621129666E+01, 5.6854154706E+00, 4.3099318515E+01, 4.6135651274E+00, 9.8657131173E-01],
	[4.5070000000E+04, 5.6632321629E+01, 5.6854685777E+00, 4.3115117918E+01, 4.6138553800E+00, 9.8657757788E-01],
	[4.5075000000E+04, 5.6643514562E+01, 5.6855216794E+00, 4.3130921359E+01, 4.6141455556E+00, 9.8658384076E-01],
	[4.5080000000E+04, 5.6654708466E+01, 5.6855747757E+00, 4.3146728838E+01, 4.6144356541E+00, 9.8659010038E-01],
	[4.5085000000E+04, 5.6665903339E+01, 5.6856278666E+00, 4.3162540355E+01, 4.6147256757E+00, 9.8659635674E-01],
	[4.5090000000E+04, 5.6677099183E+01, 5.6856809521E+00, 4.3178355912E+01, 4.6150156204E+00, 9.8660260984E-01],
	[4.5095000000E+04, 5.6688295998E+01, 5.6857340323E+00, 4.3194175510E+01, 4.6153054881E+00, 9.8660885968E-01],
	[4.5100000000E+04, 5.6699493782E+01, 5.6857871070E+00, 4.3209999147E+01, 4.6155952789E+00, 9.8661510627E-01],
	[4.5105000000E+04, 5.6710692537E+01, 5.6858401763E+00, 4.3225826826E+01, 4.6158849929E+00, 9.8662134960E-01],
	[4.5110000000E+04, 5.6721892262E+01, 5.6858932403E+00, 4.3241658547E+01, 4.6161746301E+00, 9.8662758969E-01],
	[4.5115000000E+04, 5.6733092957E+01, 5.6859462989E+00, 4.3257494309E+01, 4.6164641904E+00, 9.8663382652E-01],
	[4.5120000000E+04, 5.6744294622E+01, 5.6859993521E+00, 4.3273334115E+01, 4.6167536739E+00, 9.8664006011E-01],
	[4.5125000000E+04, 5.6755497257E+01, 5.6860523999E+00, 4.3289177965E+01, 4.6170430807E+00, 9.8664629045E-01],
	[4.5130000000E+04, 5.6766700862E+01, 5.6861054423E+00, 4.3305025858E+01, 4.6173324107E+00, 9.8665251754E-01],
	[4.5135000000E+04, 5.6777905437E+01, 5.6861584794E+00, 4.3320877796E+01, 4.6176216640E+00, 9.8665874140E-01],
	[4.5140000000E+04, 5.6789110983E+01, 5.6862115111E+00, 4.3336733779E+01, 4.6179108406E+00, 9.8666496201E-01],
	[4.5145000000E+04, 5.6800317498E+01, 5.6862645373E+00, 4.3352593808E+01, 4.6181999406E+00, 9.8667117938E-01],
	[4.5150000000E+04, 5.6811524983E+01, 5.6863175582E+00, 4.3368457884E+01, 4.6184889639E+00, 9.8667739352E-01],
	[4.5155000000E+04, 5.6822733439E+01, 5.6863705738E+00, 4.3384326007E+01, 4.6187779106E+00, 9.8668360442E-01],
	[4.5160000000E+04, 5.6833942864E+01, 5.6864235839E+00, 4.3400198177E+01, 4.6190667808E+00, 9.8668981208E-01],
	[4.5165000000E+04, 5.6845153259E+01, 5.6864765887E+00, 4.3416074395E+01, 4.6193555743E+00, 9.8669601652E-01],
	[4.5170000000E+04, 5.6856364624E+01, 5.6865295881E+00, 4.3431954662E+01, 4.6196442914E+00, 9.8670221772E-01],
	[4.5175000000E+04, 5.6867576959E+01, 5.6865825822E+00, 4.3447838979E+01, 4.6199329319E+00, 9.8670841569E-01],
	[4.5180000000E+04, 5.6878790263E+01, 5.6866355708E+00, 4.3463727345E+01, 4.6202214959E+00, 9.8671461044E-01],
	[4.5185000000E+04, 5.6890004538E+01, 5.6866885541E+00, 4.3479619762E+01, 4.6205099835E+00, 9.8672080196E-01],
	[4.5190000000E+04, 5.6901219782E+01, 5.6867415321E+00, 4.3495516230E+01, 4.6207983946E+00, 9.8672699026E-01],
	[4.5195000000E+04, 5.6912435996E+01, 5.6867945046E+00, 4.3511416749E+01, 4.6210867294E+00, 9.8673317533E-01],
	[4.5200000000E+04, 5.6923653180E+01, 5.6868474718E+00, 4.3527321321E+01, 4.6213749877E+00, 9.8673935719E-01],
	[4.5205000000E+04, 5.6934871333E+01, 5.6869004336E+00, 4.3543229946E+01, 4.6216631697E+00, 9.8674553582E-01],
	[4.5210000000E+04, 5.6946090456E+01, 5.6869533901E+00, 4.3559142624E+01, 4.6219512753E+00, 9.8675171124E-01],
	[4.5215000000E+04, 5.6957310549E+01, 5.6870063412E+00, 4.3575059356E+01, 4.6222393047E+00, 9.8675788345E-01],
	[4.5220000000E+04, 5.6968531612E+01, 5.6870592869E+00, 4.3590980143E+01, 4.6225272577E+00, 9.8676405244E-01],
	[4.5225000000E+04, 5.6979753644E+01, 5.6871122273E+00, 4.3606904985E+01, 4.6228151345E+00, 9.8677021822E-01],
	[4.5230000000E+04, 5.6990976646E+01, 5.6871651623E+00, 4.3622833883E+01, 4.6231029351E+00, 9.8677638079E-01],
	[4.5235000000E+04, 5.7002200617E+01, 5.6872180920E+00, 4.3638766837E+01, 4.6233906595E+00, 9.8678254015E-01],
	[4.5240000000E+04, 5.7013425558E+01, 5.6872710163E+00, 4.3654703848E+01, 4.6236783076E+00, 9.8678869630E-01],
	[4.5245000000E+04, 5.7024651468E+01, 5.6873239352E+00, 4.3670644916E+01, 4.6239658797E+00, 9.8679484925E-01],
	[4.5250000000E+04, 5.7035878348E+01, 5.6873768488E+00, 4.3686590043E+01, 4.6242533755E+00, 9.8680099900E-01],
	[4.5255000000E+04, 5.7047106198E+01, 5.6874297570E+00, 4.3702539228E+01, 4.6245407953E+00, 9.8680714555E-01],
	[4.5260000000E+04, 5.7058335016E+01, 5.6874826599E+00, 4.3718492473E+01, 4.6248281390E+00, 9.8681328889E-01],
	[4.5265000000E+04, 5.7069564805E+01, 5.6875355574E+00, 4.3734449777E+01, 4.6251154067E+00, 9.8681942904E-01],
	[4.5270000000E+04, 5.7080795562E+01, 5.6875884496E+00, 4.3750411142E+01, 4.6254025983E+00, 9.8682556600E-01],
	[4.5275000000E+04, 5.7092027289E+01, 5.6876413364E+00, 4.3766376568E+01, 4.6256897139E+00, 9.8683169975E-01],
	[4.5280000000E+04, 5.7103259986E+01, 5.6876942179E+00, 4.3782346055E+01, 4.6259767535E+00, 9.8683783032E-01],
	[4.5285000000E+04, 5.7114493652E+01, 5.6877470940E+00, 4.3798319605E+01, 4.6262637172E+00, 9.8684395770E-01],
	[4.5290000000E+04, 5.7125728287E+01, 5.6877999648E+00, 4.3814297217E+01, 4.6265506049E+00, 9.8685008188E-01],
	[4.5295000000E+04, 5.7136963891E+01, 5.6878528303E+00, 4.3830278893E+01, 4.6268374167E+00, 9.8685620288E-01],
	[4.5300000000E+04, 5.7148200465E+01, 5.6879056904E+00, 4.3846264633E+01, 4.6271241527E+00, 9.8686232069E-01],
	[4.5305000000E+04, 5.7159451893E+01, 5.6879597222E+00, 4.3862254437E+01, 4.6274116829E+00, 9.8686843532E-01],
	[4.5310000000E+04, 5.7170712239E+01, 5.6880144221E+00, 4.3878248307E+01, 4.6276996351E+00, 9.8687454677E-01],
	[4.5315000000E+04, 5.7181973561E+01, 5.6880691165E+00, 4.3894246242E+01, 4.6279875117E+00, 9.8688065503E-01],
	[4.5320000000E+04, 5.7193235859E+01, 5.6881238053E+00, 4.3910248243E+01, 4.6282753126E+00, 9.8688676012E-01],
	[4.5325000000E+04, 5.7204499131E+01, 5.6881784887E+00, 4.3926254311E+01, 4.6285630378E+00, 9.8689286203E-01],
	[4.5330000000E+04, 5.7215763379E+01, 5.6882331665E+00, 4.3942264447E+01, 4.6288506875E+00, 9.8689896077E-01],
	[4.5335000000E+04, 5.7227028603E+01, 5.6882878389E+00, 4.3958278651E+01, 4.6291382615E+00, 9.8690505633E-01],
	[4.5340000000E+04, 5.7238294801E+01, 5.6883425057E+00, 4.3974296923E+01, 4.6294257600E+00, 9.8691114872E-01],
	[4.5345000000E+04, 5.7249561975E+01, 5.6883971670E+00, 4.3990319265E+01, 4.6297131829E+00, 9.8691723794E-01],
	[4.5350000000E+04, 5.7260830124E+01, 5.6884518229E+00, 4.4006345676E+01, 4.6300005303E+00, 9.8692332399E-01],
	[4.5355000000E+04, 5.7272099248E+01, 5.6885064732E+00, 4.4022376158E+01, 4.6302878022E+00, 9.8692940687E-01],
	[4.5360000000E+04, 5.7283369348E+01, 5.6885611180E+00, 4.4038410711E+01, 4.6305749986E+00, 9.8693548659E-01],
	[4.5365000000E+04, 5.7294640422E+01, 5.6886157574E+00, 4.4054449335E+01, 4.6308621196E+00, 9.8694156314E-01],
	[4.5370000000E+04, 5.7305912472E+01, 5.6886703912E+00, 4.4070492031E+01, 4.6311491651E+00, 9.8694763654E-01],
	[4.5375000000E+04, 5.7317185497E+01, 5.6887250196E+00, 4.4086538800E+01, 4.6314361353E+00, 9.8695370677E-01],
	[4.5380000000E+04, 5.7328459496E+01, 5.6887796424E+00, 4.4102589643E+01, 4.6317230301E+00, 9.8695977385E-01],
	[4.5385000000E+04, 5.7339734471E+01, 5.6888342598E+00, 4.4118644559E+01, 4.6320098495E+00, 9.8696583777E-01],
	[4.5390000000E+04, 5.7351010421E+01, 5.6888888716E+00, 4.4134703550E+01, 4.6322965936E+00, 9.8697189853E-01],
	[4.5395000000E+04, 5.7362287346E+01, 5.6889434780E+00, 4.4150766615E+01, 4.6325832624E+00, 9.8697795614E-01],
	[4.5400000000E+04, 5.7373565246E+01, 5.6889980789E+00, 4.4166833757E+01, 4.6328698560E+00, 9.8698401060E-01],
	[4.5405000000E+04, 5.7384844121E+01, 5.6890526743E+00, 4.4182904975E+01, 4.6331563743E+00, 9.8699006191E-01],
	[4.5410000000E+04, 5.7396123971E+01, 5.6891072642E+00, 4.4198980269E+01, 4.6334428174E+00, 9.8699611008E-01],
	[4.5415000000E+04, 5.7407404796E+01, 5.6891618486E+00, 4.4215059641E+01, 4.6337291853E+00, 9.8700215509E-01],
	[4.5420000000E+04, 5.7418686596E+01, 5.6892164275E+00, 4.4231143091E+01, 4.6340154780E+00, 9.8700819697E-01],
	[4.5425000000E+04, 5.7429969371E+01, 5.6892710010E+00, 4.4247230619E+01, 4.6343016955E+00, 9.8701423570E-01],
	[4.5430000000E+04, 5.7441253120E+01, 5.6893255689E+00, 4.4263322227E+01, 4.6345878380E+00, 9.8702027128E-01],
	[4.5435000000E+04, 5.7452537844E+01, 5.6893801314E+00, 4.4279417914E+01, 4.6348739053E+00, 9.8702630373E-01],
	[4.5440000000E+04, 5.7463823543E+01, 5.6894346884E+00, 4.4295517682E+01, 4.6351598976E+00, 9.8703233305E-01],
	[4.5445000000E+04, 5.7475110217E+01, 5.6894892399E+00, 4.4311621530E+01, 4.6354458148E+00, 9.8703835922E-01],
	[4.5450000000E+04, 5.7486397866E+01, 5.6895437860E+00, 4.4327729460E+01, 4.6357316570E+00, 9.8704438226E-01],
	[4.5455000000E+04, 5.7497686489E+01, 5.6895983265E+00, 4.4343841472E+01, 4.6360174242E+00, 9.8705040217E-01],
	[4.5460000000E+04, 5.7508976088E+01, 5.6896528616E+00, 4.4359957567E+01, 4.6363031164E+00, 9.8705641895E-01],
	[4.5465000000E+04, 5.7520266660E+01, 5.6897073912E+00, 4.4376077745E+01, 4.6365887337E+00, 9.8706243260E-01],
	[4.5470000000E+04, 5.7531558208E+01, 5.6897619154E+00, 4.4392202007E+01, 4.6368742760E+00, 9.8706844312E-01],
	[4.5475000000E+04, 5.7542850730E+01, 5.6898164340E+00, 4.4408330353E+01, 4.6371597435E+00, 9.8707445052E-01],
	[4.5480000000E+04, 5.7554144227E+01, 5.6898709472E+00, 4.4424462784E+01, 4.6374451360E+00, 9.8708045479E-01],
	[4.5485000000E+04, 5.7565438698E+01, 5.6899254550E+00, 4.4440599301E+01, 4.6377304537E+00, 9.8708645594E-01],
	[4.5490000000E+04, 5.7576734144E+01, 5.6899799572E+00, 4.4456739904E+01, 4.6380156966E+00, 9.8709245397E-01],
	[4.5495000000E+04, 5.7588030565E+01, 5.6900344540E+00, 4.4472884594E+01, 4.6383008647E+00, 9.8709844889E-01],
	[4.5500000000E+04, 5.7599327960E+01, 5.6900889453E+00, 4.4489033371E+01, 4.6385859580E+00, 9.8710444068E-01],
	[4.5505000000E+04, 5.7610626329E+01, 5.6901434312E+00, 4.4505186236E+01, 4.6388709766E+00, 9.8711042936E-01],
	[4.5510000000E+04, 5.7621925673E+01, 5.6901979116E+00, 4.4521343189E+01, 4.6391559204E+00, 9.8711641493E-01],
	[4.5515000000E+04, 5.7633225992E+01, 5.6902523865E+00, 4.4537504232E+01, 4.6394407896E+00, 9.8712239738E-01],
	[4.5520000000E+04, 5.7644527285E+01, 5.6903068559E+00, 4.4553669364E+01, 4.6397255840E+00, 9.8712837672E-01],
	[4.5525000000E+04, 5.7655829552E+01, 5.6903613199E+00, 4.4569838587E+01, 4.6400103038E+00, 9.8713435296E-01],
	[4.5530000000E+04, 5.7667132794E+01, 5.6904157785E+00, 4.4586011900E+01, 4.6402949490E+00, 9.8714032609E-01],
	[4.5535000000E+04, 5.7678437010E+01, 5.6904702316E+00, 4.4602189305E+01, 4.6405795196E+00, 9.8714629611E-01],
	[4.5540000000E+04, 5.7689742200E+01, 5.6905246792E+00, 4.4618370802E+01, 4.6408640156E+00, 9.8715226303E-01],
	[4.5545000000E+04, 5.7701048365E+01, 5.6905791213E+00, 4.4634556392E+01, 4.6411484370E+00, 9.8715822685E-01],
	[4.5550000000E+04, 5.7712355504E+01, 5.6906335581E+00, 4.4650746074E+01, 4.6414327839E+00, 9.8716418757E-01],
	[4.5555000000E+04, 5.7723663618E+01, 5.6906879893E+00, 4.4666939851E+01, 4.6417170563E+00, 9.8717014519E-01],
	[4.5560000000E+04, 5.7734972705E+01, 5.6907424151E+00, 4.4683137722E+01, 4.6420012542E+00, 9.8717609972E-01],
	[4.5565000000E+04, 5.7746282767E+01, 5.6907968355E+00, 4.4699339687E+01, 4.6422853777E+00, 9.8718205114E-01],
	[4.5570000000E+04, 5.7757593803E+01, 5.6908512504E+00, 4.4715545749E+01, 4.6425694267E+00, 9.8718799948E-01],
	[4.5575000000E+04, 5.7768905814E+01, 5.6909056598E+00, 4.4731755906E+01, 4.6428534013E+00, 9.8719394473E-01],
	[4.5580000000E+04, 5.7780218798E+01, 5.6909600638E+00, 4.4747970160E+01, 4.6431373016E+00, 9.8719988688E-01],
	[4.5585000000E+04, 5.7791532757E+01, 5.6910144624E+00, 4.4764188512E+01, 4.6434211275E+00, 9.8720582595E-01],
	[4.5590000000E+04, 5.7802847689E+01, 5.6910688555E+00, 4.4780410961E+01, 4.6437048790E+00, 9.8721176193E-01],
	[4.5595000000E+04, 5.7814163596E+01, 5.6911232431E+00, 4.4796637509E+01, 4.6439885563E+00, 9.8721769483E-01],
	[4.5600000000E+04, 5.7825480477E+01, 5.6911776254E+00, 4.4812868156E+01, 4.6442721592E+00, 9.8722362464E-01],
	[4.5605000000E+04, 5.7836798332E+01, 5.6912320021E+00, 4.4829102902E+01, 4.6445556879E+00, 9.8722955137E-01],
	[4.5610000000E+04, 5.7848117161E+01, 5.6912863735E+00, 4.4845341749E+01, 4.6448391424E+00, 9.8723547502E-01],
	[4.5615000000E+04, 5.7859436964E+01, 5.6913407394E+00, 4.4861584696E+01, 4.6451225226E+00, 9.8724139560E-01],
	[4.5620000000E+04, 5.7870757741E+01, 5.6913950998E+00, 4.4877831745E+01, 4.6454058287E+00, 9.8724731310E-01],
	[4.5625000000E+04, 5.7882079491E+01, 5.6914494548E+00, 4.4894082896E+01, 4.6456890606E+00, 9.8725322752E-01],
	[4.5630000000E+04, 5.7893402216E+01, 5.6915038044E+00, 4.4910338149E+01, 4.6459722184E+00, 9.8725913888E-01],
	[4.5635000000E+04, 5.7904725915E+01, 5.6915581485E+00, 4.4926597506E+01, 4.6462553020E+00, 9.8726504716E-01],
	[4.5640000000E+04, 5.7916050588E+01, 5.6916124872E+00, 4.4942860966E+01, 4.6465383116E+00, 9.8727095237E-01],
	[4.5645000000E+04, 5.7927376234E+01, 5.6916668205E+00, 4.4959128531E+01, 4.6468212471E+00, 9.8727685451E-01],
	[4.5650000000E+04, 5.7938702854E+01, 5.6917211483E+00, 4.4975400201E+01, 4.6471041086E+00, 9.8728275359E-01],
	[4.5655000000E+04, 5.7950030449E+01, 5.6917754708E+00, 4.4991675976E+01, 4.6473868960E+00, 9.8728864961E-01],
	[4.5660000000E+04, 5.7961359017E+01, 5.6918297877E+00, 4.5007955857E+01, 4.6476696095E+00, 9.8729454256E-01],
	[4.5665000000E+04, 5.7972688558E+01, 5.6918840993E+00, 4.5024239844E+01, 4.6479522490E+00, 9.8730043245E-01],
	[4.5670000000E+04, 5.7984019074E+01, 5.6919384054E+00, 4.5040527940E+01, 4.6482348146E+00, 9.8730631928E-01],
	[4.5675000000E+04, 5.7995350563E+01, 5.6919927061E+00, 4.5056820142E+01, 4.6485173062E+00, 9.8731220306E-01],
	[4.5680000000E+04, 5.8006683026E+01, 5.6920470013E+00, 4.5073116454E+01, 4.6487997239E+00, 9.8731808378E-01],
	[4.5685000000E+04, 5.8018016462E+01, 5.6921012912E+00, 4.5089416874E+01, 4.6490820678E+00, 9.8732396144E-01],
	[4.5690000000E+04, 5.8029350873E+01, 5.6921555756E+00, 4.5105721404E+01, 4.6493643379E+00, 9.8732983606E-01],
	[4.5695000000E+04, 5.8040686257E+01, 5.6922098546E+00, 4.5122030044E+01, 4.6496465341E+00, 9.8733570762E-01],
	[4.5700000000E+04, 5.8052022614E+01, 5.6922641282E+00, 4.5138342795E+01, 4.6499286565E+00, 9.8734157613E-01],
	[4.5705000000E+04, 5.8063359945E+01, 5.6923183963E+00, 4.5154659657E+01, 4.6502107052E+00, 9.8734744160E-01],
	[4.5710000000E+04, 5.8074698250E+01, 5.6923726591E+00, 4.5170980631E+01, 4.6504926801E+00, 9.8735330402E-01],
	[4.5715000000E+04, 5.8086037528E+01, 5.6924269164E+00, 4.5187305718E+01, 4.6507745813E+00, 9.8735916340E-01],
	[4.5720000000E+04, 5.8097377780E+01, 5.6924811683E+00, 4.5203634918E+01, 4.6510564087E+00, 9.8736501973E-01],
	[4.5725000000E+04, 5.8108719005E+01, 5.6925354147E+00, 4.5219968231E+01, 4.6513381626E+00, 9.8737087303E-01],
	[4.5730000000E+04, 5.8120061204E+01, 5.6925896558E+00, 4.5236305659E+01, 4.6516198427E+00, 9.8737672328E-01],
	[4.5735000000E+04, 5.8131404376E+01, 5.6926438915E+00, 4.5252647202E+01, 4.6519014493E+00, 9.8738257050E-01],
	[4.5740000000E+04, 5.8142748521E+01, 5.6926981217E+00, 4.5268992860E+01, 4.6521829822E+00, 9.8738841469E-01],
	[4.5745000000E+04, 5.8154093640E+01, 5.6927523465E+00, 4.5285342634E+01, 4.6524644416E+00, 9.8739425584E-01],
	[4.5750000000E+04, 5.8165439733E+01, 5.6928065660E+00, 4.5301696525E+01, 4.6527458274E+00, 9.8740009395E-01],
	[4.5755000000E+04, 5.8176786798E+01, 5.6928607800E+00, 4.5318054533E+01, 4.6530271397E+00, 9.8740592904E-01],
	[4.5760000000E+04, 5.8188134838E+01, 5.6929149886E+00, 4.5334416658E+01, 4.6533083785E+00, 9.8741176110E-01],
	[4.5765000000E+04, 5.8199483850E+01, 5.6929691918E+00, 4.5350782902E+01, 4.6535895438E+00, 9.8741759013E-01],
	[4.5770000000E+04, 5.8210833836E+01, 5.6930233896E+00, 4.5367153266E+01, 4.6538706356E+00, 9.8742341614E-01],
	[4.5775000000E+04, 5.8222184795E+01, 5.6930775819E+00, 4.5383527748E+01, 4.6541516541E+00, 9.8742923913E-01],
	[4.5780000000E+04, 5.8233536727E+01, 5.6931317689E+00, 4.5399906351E+01, 4.6544325991E+00, 9.8743505909E-01],
	[4.5785000000E+04, 5.8244889632E+01, 5.6931859505E+00, 4.5416289075E+01, 4.6547134707E+00, 9.8744087603E-01],
	[4.5790000000E+04, 5.8256243511E+01, 5.6932401267E+00, 4.5432675920E+01, 4.6549942690E+00, 9.8744668995E-01],
	[4.5795000000E+04, 5.8267598363E+01, 5.6932942975E+00, 4.5449066886E+01, 4.6552749940E+00, 9.8745250086E-01],
	[4.5800000000E+04, 5.8278954188E+01, 5.6933484629E+00, 4.5465461976E+01, 4.6555556456E+00, 9.8745830875E-01],
	[4.5805000000E+04, 5.8290310986E+01, 5.6934026228E+00, 4.5481861188E+01, 4.6558362240E+00, 9.8746411363E-01],
	[4.5810000000E+04, 5.8301668757E+01, 5.6934567774E+00, 4.5498264524E+01, 4.6561167291E+00, 9.8746991550E-01],
	[4.5815000000E+04, 5.8313027501E+01, 5.6935109266E+00, 4.5514671984E+01, 4.6563971609E+00, 9.8747571435E-01],
	[4.5820000000E+04, 5.8324387219E+01, 5.6935650704E+00, 4.5531083570E+01, 4.6566775196E+00, 9.8748151020E-01],
	[4.5825000000E+04, 5.8335747909E+01, 5.6936192088E+00, 4.5547499280E+01, 4.6569578051E+00, 9.8748730304E-01],
	[4.5830000000E+04, 5.8347109572E+01, 5.6936733418E+00, 4.5563919117E+01, 4.6572380174E+00, 9.8749309288E-01],
	[4.5835000000E+04, 5.8358472209E+01, 5.6937274695E+00, 4.5580343080E+01, 4.6575181565E+00, 9.8749887971E-01],
	[4.5840000000E+04, 5.8369835818E+01, 5.6937815917E+00, 4.5596771170E+01, 4.6577982226E+00, 9.8750466355E-01],
	[4.5845000000E+04, 5.8381200401E+01, 5.6938357085E+00, 4.5613203388E+01, 4.6580782156E+00, 9.8751044438E-01],
	[4.5850000000E+04, 5.8392565956E+01, 5.6938898200E+00, 4.5629639735E+01, 4.6583581354E+00, 9.8751622221E-01],
	[4.5855000000E+04, 5.8403932484E+01, 5.6939439260E+00, 4.5646080210E+01, 4.6586379823E+00, 9.8752199705E-01],
	[4.5860000000E+04, 5.8415299985E+01, 5.6939980267E+00, 4.5662524815E+01, 4.6589177561E+00, 9.8752776889E-01],
	[4.5865000000E+04, 5.8426668459E+01, 5.6940521220E+00, 4.5678973550E+01, 4.6591974570E+00, 9.8753353774E-01],
	[4.5870000000E+04, 5.8438037906E+01, 5.6941062119E+00, 4.5695426416E+01, 4.6594770849E+00, 9.8753930360E-01],
	[4.5875000000E+04, 5.8449408325E+01, 5.6941602965E+00, 4.5711883413E+01, 4.6597566398E+00, 9.8754506647E-01],
	[4.5880000000E+04, 5.8460779718E+01, 5.6942143756E+00, 4.5728344542E+01, 4.6600361218E+00, 9.8755082635E-01],
	[4.5885000000E+04, 5.8472152083E+01, 5.6942684494E+00, 4.5744809803E+01, 4.6603155309E+00, 9.8755658324E-01],
	[4.5890000000E+04, 5.8483525421E+01, 5.6943225178E+00, 4.5761279198E+01, 4.6605948671E+00, 9.8756233715E-01],
	[4.5895000000E+04, 5.8494899731E+01, 5.6943765808E+00, 4.5777752726E+01, 4.6608741305E+00, 9.8756808808E-01],
	[4.5900000000E+04, 5.8506275015E+01, 5.6944306385E+00, 4.5794230388E+01, 4.6611533211E+00, 9.8757383602E-01],
	[4.5905000000E+04, 5.8517651271E+01, 5.6944846907E+00, 4.5810712185E+01, 4.6614324388E+00, 9.8757958099E-01],
	[4.5910000000E+04, 5.8529028499E+01, 5.6945387376E+00, 4.5827198118E+01, 4.6617114838E+00, 9.8758532297E-01],
	[4.5915000000E+04, 5.8540406700E+01, 5.6945927791E+00, 4.5843688187E+01, 4.6619904561E+00, 9.8759106198E-01],
	[4.5920000000E+04, 5.8551785874E+01, 5.6946468153E+00, 4.5860182392E+01, 4.6622693556E+00, 9.8759679802E-01],
	[4.5925000000E+04, 5.8563166021E+01, 5.6947008461E+00, 4.5876680734E+01, 4.6625481824E+00, 9.8760253108E-01],
	[4.5930000000E+04, 5.8574547140E+01, 5.6947548715E+00, 4.5893183214E+01, 4.6628269365E+00, 9.8760826117E-01],
	[4.5935000000E+04, 5.8585929231E+01, 5.6948088915E+00, 4.5909689832E+01, 4.6631056180E+00, 9.8761398829E-01],
	[4.5940000000E+04, 5.8597312295E+01, 5.6948629062E+00, 4.5926200589E+01, 4.6633842268E+00, 9.8761971245E-01],
	[4.5945000000E+04, 5.8608696332E+01, 5.6949169155E+00, 4.5942715486E+01, 4.6636627630E+00, 9.8762543363E-01],
	[4.5950000000E+04, 5.8620081341E+01, 5.6949709194E+00, 4.5959234523E+01, 4.6639412267E+00, 9.8763115186E-01],
	[4.5955000000E+04, 5.8631467322E+01, 5.6950249180E+00, 4.5975757701E+01, 4.6642196177E+00, 9.8763686712E-01],
	[4.5960000000E+04, 5.8642854276E+01, 5.6950789112E+00, 4.5992285019E+01, 4.6644979363E+00, 9.8764257941E-01],
	[4.5965000000E+04, 5.8654242203E+01, 5.6951328991E+00, 4.6008816480E+01, 4.6647761823E+00, 9.8764828875E-01],
	[4.5970000000E+04, 5.8665631101E+01, 5.6951868815E+00, 4.6025352083E+01, 4.6650543559E+00, 9.8765399513E-01],
	[4.5975000000E+04, 5.8677020972E+01, 5.6952408587E+00, 4.6041891829E+01, 4.6653324569E+00, 9.8765969856E-01],
	[4.5980000000E+04, 5.8688411816E+01, 5.6952948304E+00, 4.6058435719E+01, 4.6656104856E+00, 9.8766539903E-01],
	[4.5985000000E+04, 5.8699803632E+01, 5.6953487969E+00, 4.6074983753E+01, 4.6658884418E+00, 9.8767109654E-01],
	[4.5990000000E+04, 5.8711196420E+01, 5.6954027579E+00, 4.6091535932E+01, 4.6661663256E+00, 9.8767679111E-01],
	[4.5995000000E+04, 5.8722590180E+01, 5.6954567136E+00, 4.6108092256E+01, 4.6664441371E+00, 9.8768248272E-01],
	[4.6000000000E+04, 5.8733984912E+01, 5.6955106640E+00, 4.6124652726E+01, 4.6667218762E+00, 9.8768817139E-01],
	[4.6005000000E+04, 5.8745380617E+01, 5.6955646090E+00, 4.6141217342E+01, 4.6669995430E+00, 9.8769385711E-01],
	[4.6010000000E+04, 5.8756777294E+01, 5.6956185486E+00, 4.6157786106E+01, 4.6672771375E+00, 9.8769953989E-01],
	[4.6015000000E+04, 5.8768174943E+01, 5.6956724829E+00, 4.6174359018E+01, 4.6675546597E+00, 9.8770521972E-01],
	[4.6020000000E+04, 5.8779573564E+01, 5.6957264119E+00, 4.6190936077E+01, 4.6678321097E+00, 9.8771089662E-01],
	[4.6025000000E+04, 5.8790973158E+01, 5.6957803354E+00, 4.6207517286E+01, 4.6681094875E+00, 9.8771657057E-01],
	[4.6030000000E+04, 5.8802373723E+01, 5.6958342537E+00, 4.6224102644E+01, 4.6683867930E+00, 9.8772224158E-01],
	[4.6035000000E+04, 5.8813792249E+01, 5.6958895754E+00, 4.6240692153E+01, 4.6686650799E+00, 9.8772790966E-01],
	[4.6040000000E+04, 5.8825216641E+01, 5.6959452969E+00, 4.6257285812E+01, 4.6689435979E+00, 9.8773357481E-01],
	[4.6045000000E+04, 5.8836642011E+01, 5.6960010130E+00, 4.6273883622E+01, 4.6692220438E+00, 9.8773923702E-01],
	[4.6050000000E+04, 5.8848068360E+01, 5.6960567235E+00, 4.6290485584E+01, 4.6695004178E+00, 9.8774489630E-01],
	[4.6055000000E+04, 5.8859495686E+01, 5.6961124286E+00, 4.6307091698E+01, 4.6697787197E+00, 9.8775055265E-01],
	[4.6060000000E+04, 5.8870923991E+01, 5.6961681281E+00, 4.6323701966E+01, 4.6700569497E+00, 9.8775620607E-01],
	[4.6065000000E+04, 5.8882353273E+01, 5.6962238222E+00, 4.6340316387E+01, 4.6703351078E+00, 9.8776185657E-01],
	[4.6070000000E+04, 5.8893783534E+01, 5.6962795107E+00, 4.6356934962E+01, 4.6706131939E+00, 9.8776750414E-01],
	[4.6075000000E+04, 5.8905214773E+01, 5.6963351938E+00, 4.6373557692E+01, 4.6708912082E+00, 9.8777314878E-01],
	[4.6080000000E+04, 5.8916646989E+01, 5.6963908713E+00, 4.6390184577E+01, 4.6711691506E+00, 9.8777879051E-01],
	[4.6085000000E+04, 5.8928080184E+01, 5.6964465434E+00, 4.6406815619E+01, 4.6714470211E+00, 9.8778442932E-01],
	[4.6090000000E+04, 5.8939514357E+01, 5.6965022099E+00, 4.6423450817E+01, 4.6717248199E+00, 9.8779006521E-01],
	[4.6095000000E+04, 5.8950949507E+01, 5.6965578710E+00, 4.6440090172E+01, 4.6720025468E+00, 9.8779569818E-01],
	[4.6100000000E+04, 5.8962385636E+01, 5.6966135266E+00, 4.6456733684E+01, 4.6722802020E+00, 9.8780132824E-01],
	[4.6105000000E+04, 5.8973822742E+01, 5.6966691767E+00, 4.6473381355E+01, 4.6725577854E+00, 9.8780695538E-01],
	[4.6110000000E+04, 5.8985260826E+01, 5.6967248212E+00, 4.6490033185E+01, 4.6728352971E+00, 9.8781257962E-01],
	[4.6115000000E+04, 5.8996699888E+01, 5.6967804603E+00, 4.6506689175E+01, 4.6731127371E+00, 9.8781820094E-01],
	[4.6120000000E+04, 5.9008139928E+01, 5.6968360939E+00, 4.6523349324E+01, 4.6733901055E+00, 9.8782381935E-01],
	[4.6125000000E+04, 5.9019580946E+01, 5.6968917221E+00, 4.6540013634E+01, 4.6736674022E+00, 9.8782943486E-01],
	[4.6130000000E+04, 5.9031022941E+01, 5.6969473447E+00, 4.6556682106E+01, 4.6739446272E+00, 9.8783504747E-01],
	[4.6135000000E+04, 5.9042465914E+01, 5.6970029618E+00, 4.6573354739E+01, 4.6742217807E+00, 9.8784065717E-01],
	[4.6140000000E+04, 5.9053909865E+01, 5.6970585735E+00, 4.6590031534E+01, 4.6744988625E+00, 9.8784626397E-01],
	[4.6145000000E+04, 5.9065354794E+01, 5.6971141797E+00, 4.6606712493E+01, 4.6747758728E+00, 9.8785186787E-01],
	[4.6150000000E+04, 5.9076800700E+01, 5.6971697804E+00, 4.6623397615E+01, 4.6750528116E+00, 9.8785746887E-01],
	[4.6155000000E+04, 5.9088247584E+01, 5.6972253756E+00, 4.6640086901E+01, 4.6753296789E+00, 9.8786306698E-01],
	[4.6160000000E+04, 5.9099695446E+01, 5.6972809653E+00, 4.6656780353E+01, 4.6756064747E+00, 9.8786866219E-01],
	[4.6165000000E+04, 5.9111144285E+01, 5.6973365496E+00, 4.6673477969E+01, 4.6758831990E+00, 9.8787425450E-01],
	[4.6170000000E+04, 5.9122594102E+01, 5.6973921284E+00, 4.6690179751E+01, 4.6761598519E+00, 9.8787984393E-01],
	[4.6175000000E+04, 5.9134044896E+01, 5.6974477017E+00, 4.6706885700E+01, 4.6764364334E+00, 9.8788543046E-01],
	[4.6180000000E+04, 5.9145496668E+01, 5.6975032695E+00, 4.6723595816E+01, 4.6767129434E+00, 9.8789101411E-01],
	[4.6185000000E+04, 5.9156949417E+01, 5.6975588318E+00, 4.6740310100E+01, 4.6769893821E+00, 9.8789659487E-01],
	[4.6190000000E+04, 5.9168403144E+01, 5.6976143887E+00, 4.6757028552E+01, 4.6772657495E+00, 9.8790217275E-01],
	[4.6195000000E+04, 5.9179857849E+01, 5.6976699401E+00, 4.6773751173E+01, 4.6775420456E+00, 9.8790774774E-01],
	[4.6200000000E+04, 5.9191313531E+01, 5.6977254861E+00, 4.6790477964E+01, 4.6778182703E+00, 9.8791331985E-01],
	[4.6205000000E+04, 5.9202770190E+01, 5.6977810265E+00, 4.6807208924E+01, 4.6780944238E+00, 9.8791888908E-01],
	[4.6210000000E+04, 5.9214227827E+01, 5.6978365615E+00, 4.6823944055E+01, 4.6783705060E+00, 9.8792445543E-01],
	[4.6215000000E+04, 5.9225686441E+01, 5.6978920911E+00, 4.6840683357E+01, 4.6786465170E+00, 9.8793001891E-01],
	[4.6220000000E+04, 5.9237146032E+01, 5.6979476151E+00, 4.6857426832E+01, 4.6789224568E+00, 9.8793557951E-01],
	[4.6225000000E+04, 5.9248606601E+01, 5.6980031337E+00, 4.6874174478E+01, 4.6791983254E+00, 9.8794113723E-01],
	[4.6230000000E+04, 5.9260068147E+01, 5.6980586469E+00, 4.6890926298E+01, 4.6794741229E+00, 9.8794669209E-01],
	[4.6235000000E+04, 5.9271530671E+01, 5.6981141545E+00, 4.6907682291E+01, 4.6797498492E+00, 9.8795224407E-01],
	[4.6240000000E+04, 5.9282994171E+01, 5.6981696567E+00, 4.6924442458E+01, 4.6800255044E+00, 9.8795779319E-01],
	[4.6245000000E+04, 5.9294458649E+01, 5.6982251535E+00, 4.6941206800E+01, 4.6803010885E+00, 9.8796333944E-01],
	[4.6250000000E+04, 5.9305924105E+01, 5.6982806448E+00, 4.6957975318E+01, 4.6805766016E+00, 9.8796888282E-01],
	[4.6255000000E+04, 5.9317390537E+01, 5.6983361306E+00, 4.6974748011E+01, 4.6808520436E+00, 9.8797442334E-01],
	[4.6260000000E+04, 5.9328857947E+01, 5.6983916110E+00, 4.6991524881E+01, 4.6811274146E+00, 9.8797996100E-01],
	[4.6265000000E+04, 5.9340326334E+01, 5.6984470859E+00, 4.7008305928E+01, 4.6814027147E+00, 9.8798549580E-01],
	[4.6270000000E+04, 5.9351795698E+01, 5.6985025554E+00, 4.7025091153E+01, 4.6816779437E+00, 9.8799102774E-01],
	[4.6275000000E+04, 5.9363266039E+01, 5.6985580194E+00, 4.7041880556E+01, 4.6819531018E+00, 9.8799655682E-01],
	[4.6280000000E+04, 5.9374737357E+01, 5.6986134779E+00, 4.7058674138E+01, 4.6822281890E+00, 9.8800208305E-01],
	[4.6285000000E+04, 5.9386209652E+01, 5.6986689310E+00, 4.7075471899E+01, 4.6825032053E+00, 9.8800760642E-01],
	[4.6290000000E+04, 5.9397682924E+01, 5.6987243787E+00, 4.7092273840E+01, 4.6827781507E+00, 9.8801312694E-01],
	[4.6295000000E+04, 5.9409157174E+01, 5.6987798209E+00, 4.7109079962E+01, 4.6830530253E+00, 9.8801864461E-01],
	[4.6300000000E+04, 5.9420632400E+01, 5.6988352577E+00, 4.7125890266E+01, 4.6833278290E+00, 9.8802415944E-01],
	[4.6305000000E+04, 5.9432108603E+01, 5.6988906890E+00, 4.7142704751E+01, 4.6836025619E+00, 9.8802967141E-01],
	[4.6310000000E+04, 5.9443585784E+01, 5.6989461148E+00, 4.7159523418E+01, 4.6838772241E+00, 9.8803518054E-01],
	[4.6315000000E+04, 5.9455063941E+01, 5.6990015352E+00, 4.7176346269E+01, 4.6841518155E+00, 9.8804068682E-01],
	[4.6320000000E+04, 5.9466543075E+01, 5.6990569502E+00, 4.7193173303E+01, 4.6844263361E+00, 9.8804619027E-01],
	[4.6325000000E+04, 5.9478023186E+01, 5.6991123598E+00, 4.7210004521E+01, 4.6847007861E+00, 9.8805169087E-01],
	[4.6330000000E+04, 5.9489504274E+01, 5.6991677638E+00, 4.7226839924E+01, 4.6849751653E+00, 9.8805718863E-01],
	[4.6335000000E+04, 5.9500986339E+01, 5.6992231625E+00, 4.7243679513E+01, 4.6852494739E+00, 9.8806268356E-01],
	[4.6340000000E+04, 5.9512469381E+01, 5.6992785557E+00, 4.7260523287E+01, 4.6855237119E+00, 9.8806817565E-01],
	[4.6345000000E+04, 5.9523953399E+01, 5.6993339435E+00, 4.7277371248E+01, 4.6857978792E+00, 9.8807366490E-01],
	[4.6350000000E+04, 5.9535438395E+01, 5.6993893258E+00, 4.7294223396E+01, 4.6860719759E+00, 9.8807915132E-01],
	[4.6355000000E+04, 5.9546924367E+01, 5.6994447027E+00, 4.7311079731E+01, 4.6863460021E+00, 9.8808463491E-01],
	[4.6360000000E+04, 5.9558411315E+01, 5.6995000742E+00, 4.7327940255E+01, 4.6866199577E+00, 9.8809011568E-01],
	[4.6365000000E+04, 5.9569899241E+01, 5.6995554402E+00, 4.7344804968E+01, 4.6868938428E+00, 9.8809559361E-01],
	[4.6370000000E+04, 5.9581388143E+01, 5.6996108008E+00, 4.7361673870E+01, 4.6871676574E+00, 9.8810106872E-01],
	[4.6375000000E+04, 5.9592878022E+01, 5.6996661560E+00, 4.7378546963E+01, 4.6874414015E+00, 9.8810654100E-01],
	[4.6380000000E+04, 5.9604368877E+01, 5.6997215057E+00, 4.7395424246E+01, 4.6877150752E+00, 9.8811201047E-01],
	[4.6385000000E+04, 5.9615860710E+01, 5.6997768500E+00, 4.7412305720E+01, 4.6879886784E+00, 9.8811747711E-01],
	[4.6390000000E+04, 5.9627353518E+01, 5.6998321889E+00, 4.7429191386E+01, 4.6882622112E+00, 9.8812294093E-01],
	[4.6395000000E+04, 5.9638847304E+01, 5.6998875223E+00, 4.7446081245E+01, 4.6885356736E+00, 9.8812840193E-01],
	[4.6400000000E+04, 5.9650342066E+01, 5.6999428504E+00, 4.7462975296E+01, 4.6888090657E+00, 9.8813386012E-01],
	[4.6405000000E+04, 5.9661837804E+01, 5.6999981730E+00, 4.7479873541E+01, 4.6890823875E+00, 9.8813931549E-01],
	[4.6410000000E+04, 5.9673334519E+01, 5.7000534902E+00, 4.7496775981E+01, 4.6893556389E+00, 9.8814476805E-01],
	[4.6415000000E+04, 5.9684832211E+01, 5.7001088019E+00, 4.7513682615E+01, 4.6896288200E+00, 9.8815021779E-01],
	[4.6420000000E+04, 5.9696330879E+01, 5.7001641082E+00, 4.7530593444E+01, 4.6899019309E+00, 9.8815566473E-01],
	[4.6425000000E+04, 5.9707830523E+01, 5.7002194092E+00, 4.7547508469E+01, 4.6901749715E+00, 9.8816110886E-01],
	[4.6430000000E+04, 5.9719331144E+01, 5.7002747046E+00, 4.7564427691E+01, 4.6904479419E+00, 9.8816655018E-01],
	[4.6435000000E+04, 5.9730832741E+01, 5.7003299947E+00, 4.7581351110E+01, 4.6907208420E+00, 9.8817198870E-01],
	[4.6440000000E+04, 5.9742335315E+01, 5.7003852794E+00, 4.7598278727E+01, 4.6909936721E+00, 9.8817742441E-01],
	[4.6445000000E+04, 5.9753838865E+01, 5.7004405586E+00, 4.7615210542E+01, 4.6912664319E+00, 9.8818285733E-01],
	[4.6450000000E+04, 5.9765343391E+01, 5.7004958325E+00, 4.7632146556E+01, 4.6915391217E+00, 9.8818828744E-01],
	[4.6455000000E+04, 5.9776848894E+01, 5.7005511009E+00, 4.7649086769E+01, 4.6918117413E+00, 9.8819371475E-01],
	[4.6460000000E+04, 5.9788355373E+01, 5.7006063639E+00, 4.7666031183E+01, 4.6920842908E+00, 9.8819913927E-01],
	[4.6465000000E+04, 5.9799862828E+01, 5.7006616215E+00, 4.7682979797E+01, 4.6923567703E+00, 9.8820456099E-01],
	[4.6470000000E+04, 5.9811371260E+01, 5.7007168736E+00, 4.7699932612E+01, 4.6926291797E+00, 9.8820997992E-01],
	[4.6475000000E+04, 5.9822880667E+01, 5.7007721204E+00, 4.7716889630E+01, 4.6929015192E+00, 9.8821539606E-01],
	[4.6480000000E+04, 5.9834391051E+01, 5.7008273618E+00, 4.7733850849E+01, 4.6931737886E+00, 9.8822080940E-01],
	[4.6485000000E+04, 5.9845902411E+01, 5.7008825977E+00, 4.7750816272E+01, 4.6934459881E+00, 9.8822621996E-01],
	[4.6490000000E+04, 5.9857414748E+01, 5.7009378283E+00, 4.7767785898E+01, 4.6937181176E+00, 9.8823162773E-01],
	[4.6495000000E+04, 5.9868928060E+01, 5.7009930534E+00, 4.7784759729E+01, 4.6939901772E+00, 9.8823703271E-01],
	[4.6500000000E+04, 5.9880442349E+01, 5.7010482732E+00, 4.7801737764E+01, 4.6942621669E+00, 9.8824243491E-01],
	[4.6505000000E+04, 5.9891957613E+01, 5.7011034875E+00, 4.7818720005E+01, 4.6945340868E+00, 9.8824783433E-01],
	[4.6510000000E+04, 5.9903473854E+01, 5.7011586965E+00, 4.7835706451E+01, 4.6948059367E+00, 9.8825323097E-01],
	[4.6515000000E+04, 5.9914991071E+01, 5.7012139000E+00, 4.7852697104E+01, 4.6950777169E+00, 9.8825862483E-01],
	[4.6520000000E+04, 5.9926509264E+01, 5.7012690981E+00, 4.7869691964E+01, 4.6953494272E+00, 9.8826401591E-01],
	[4.6525000000E+04, 5.9938028433E+01, 5.7013242909E+00, 4.7886691032E+01, 4.6956210678E+00, 9.8826940421E-01],
	[4.6530000000E+04, 5.9949548577E+01, 5.7013794782E+00, 4.7903694309E+01, 4.6958926386E+00, 9.8827478974E-01],
	[4.6535000000E+04, 5.9961069698E+01, 5.7014346602E+00, 4.7920701794E+01, 4.6961641397E+00, 9.8828017250E-01],
	[4.6540000000E+04, 5.9972591795E+01, 5.7014898367E+00, 4.7937713489E+01, 4.6964355710E+00, 9.8828555249E-01],
	[4.6545000000E+04, 5.9984114868E+01, 5.7015450079E+00, 4.7954729393E+01, 4.6967069327E+00, 9.8829092970E-01],
	[4.6550000000E+04, 5.9995638916E+01, 5.7016001736E+00, 4.7971749509E+01, 4.6969782246E+00, 9.8829630415E-01],
	[4.6555000000E+04, 6.0007163941E+01, 5.7016553340E+00, 4.7988773836E+01, 4.6972494470E+00, 9.8830167584E-01],
	[4.6560000000E+04, 6.0018689941E+01, 5.7017104890E+00, 4.8005802374E+01, 4.6975205997E+00, 9.8830704475E-01],
	[4.6565000000E+04, 6.0030216917E+01, 5.7017656386E+00, 4.8022835125E+01, 4.6977916828E+00, 9.8831241091E-01],
	[4.6570000000E+04, 6.0041744869E+01, 5.7018207828E+00, 4.8039872089E+01, 4.6980626964E+00, 9.8831777430E-01],
	[4.6575000000E+04, 6.0053273797E+01, 5.7018759216E+00, 4.8056913267E+01, 4.6983336404E+00, 9.8832313494E-01],
	[4.6580000000E+04, 6.0064803700E+01, 5.7019310551E+00, 4.8073958659E+01, 4.6986045149E+00, 9.8832849281E-01],
	[4.6585000000E+04, 6.0076334579E+01, 5.7019861831E+00, 4.8091008266E+01, 4.6988753198E+00, 9.8833384793E-01],
	[4.6590000000E+04, 6.0087866434E+01, 5.7020413058E+00, 4.8108062088E+01, 4.6991460553E+00, 9.8833920029E-01],
	[4.6595000000E+04, 6.0099399265E+01, 5.7020964231E+00, 4.8125120126E+01, 4.6994167213E+00, 9.8834454990E-01],
	[4.6600000000E+04, 6.0110933071E+01, 5.7021515350E+00, 4.8142182380E+01, 4.6996873179E+00, 9.8834989676E-01],
	[4.6605000000E+04, 6.0122467853E+01, 5.7022066415E+00, 4.8159248852E+01, 4.6999578450E+00, 9.8835524087E-01],
	[4.6610000000E+04, 6.0134003611E+01, 5.7022617426E+00, 4.8176319542E+01, 4.7002283028E+00, 9.8836058223E-01],
	[4.6615000000E+04, 6.0145540344E+01, 5.7023168384E+00, 4.8193394450E+01, 4.7004986912E+00, 9.8836592084E-01],
	[4.6620000000E+04, 6.0157078053E+01, 5.7023719288E+00, 4.8210473576E+01, 4.7007690103E+00, 9.8837125671E-01],
	[4.6625000000E+04, 6.0168616737E+01, 5.7024270138E+00, 4.8227556923E+01, 4.7010392600E+00, 9.8837658983E-01],
	[4.6630000000E+04, 6.0180156397E+01, 5.7024820934E+00, 4.8244644489E+01, 4.7013094404E+00, 9.8838192021E-01],
	[4.6635000000E+04, 6.0191697033E+01, 5.7025371677E+00, 4.8261736276E+01, 4.7015795516E+00, 9.8838724785E-01],
	[4.6640000000E+04, 6.0203238644E+01, 5.7025922366E+00, 4.8278832285E+01, 4.7018495935E+00, 9.8839257276E-01],
	[4.6645000000E+04, 6.0214781230E+01, 5.7026473001E+00, 4.8295932515E+01, 4.7021195661E+00, 9.8839789492E-01],
	[4.6650000000E+04, 6.0226324792E+01, 5.7027023582E+00, 4.8313036968E+01, 4.7023894696E+00, 9.8840321435E-01],
	[4.6655000000E+04, 6.0237869329E+01, 5.7027574110E+00, 4.8330145643E+01, 4.7026593038E+00, 9.8840853104E-01],
	[4.6660000000E+04, 6.0249414842E+01, 5.7028124584E+00, 4.8347258543E+01, 4.7029290689E+00, 9.8841384500E-01],
	[4.6665000000E+04, 6.0260961330E+01, 5.7028675005E+00, 4.8364375666E+01, 4.7031987649E+00, 9.8841915623E-01],
	[4.6670000000E+04, 6.0272508794E+01, 5.7029225372E+00, 4.8381497015E+01, 4.7034683918E+00, 9.8842446473E-01],
	[4.6675000000E+04, 6.0284057232E+01, 5.7029775685E+00, 4.8398622589E+01, 4.7037379495E+00, 9.8842977050E-01],
	[4.6680000000E+04, 6.0295606647E+01, 5.7030325944E+00, 4.8415752389E+01, 4.7040074382E+00, 9.8843507355E-01],
	[4.6685000000E+04, 6.0307157036E+01, 5.7030876150E+00, 4.8432886415E+01, 4.7042768578E+00, 9.8844037387E-01],
	[4.6690000000E+04, 6.0318708401E+01, 5.7031426302E+00, 4.8450024669E+01, 4.7045462084E+00, 9.8844567146E-01],
	[4.6695000000E+04, 6.0330260741E+01, 5.7031976401E+00, 4.8467167150E+01, 4.7048154900E+00, 9.8845096634E-01],
	[4.6700000000E+04, 6.0341814056E+01, 5.7032526446E+00, 4.8484313860E+01, 4.7050847026E+00, 9.8845625850E-01],
	[4.6705000000E+04, 6.0353368346E+01, 5.7033076437E+00, 4.8501464799E+01, 4.7053538463E+00, 9.8846154793E-01],
	[4.6710000000E+04, 6.0364923612E+01, 5.7033626375E+00, 4.8518619967E+01, 4.7056229210E+00, 9.8846683465E-01],
	[4.6715000000E+04, 6.0376479853E+01, 5.7034176260E+00, 4.8535779366E+01, 4.7058919268E+00, 9.8847211866E-01],
	[4.6720000000E+04, 6.0388037069E+01, 5.7034726090E+00, 4.8552942995E+01, 4.7061608638E+00, 9.8847739995E-01],
	[4.6725000000E+04, 6.0399595260E+01, 5.7035275868E+00, 4.8570110855E+01, 4.7064297318E+00, 9.8848267853E-01],
	[4.6730000000E+04, 6.0411154426E+01, 5.7035825591E+00, 4.8587282948E+01, 4.7066985310E+00, 9.8848795440E-01],
	[4.6735000000E+04, 6.0422714567E+01, 5.7036375261E+00, 4.8604459273E+01, 4.7069672614E+00, 9.8849322756E-01],
	[4.6740000000E+04, 6.0434275684E+01, 5.7036924878E+00, 4.8621639831E+01, 4.7072359230E+00, 9.8849849801E-01],
	[4.6745000000E+04, 6.0445837775E+01, 5.7037474441E+00, 4.8638824622E+01, 4.7075045158E+00, 9.8850376576E-01],
	[4.6750000000E+04, 6.0457400841E+01, 5.7038023951E+00, 4.8656013648E+01, 4.7077730399E+00, 9.8850903080E-01],
	[4.6755000000E+04, 6.0468964883E+01, 5.7038573407E+00, 4.8673206909E+01, 4.7080414952E+00, 9.8851429314E-01],
	[4.6760000000E+04, 6.0480529899E+01, 5.7039122810E+00, 4.8690404405E+01, 4.7083098819E+00, 9.8851955278E-01],
	[4.6765000000E+04, 6.0492095890E+01, 5.7039672159E+00, 4.8707606137E+01, 4.7085781998E+00, 9.8852480972E-01],
	[4.6770000000E+04, 6.0503662856E+01, 5.7040221455E+00, 4.8724812106E+01, 4.7088464491E+00, 9.8853006396E-01],
	[4.6775000000E+04, 6.0515243271E+01, 5.7040780815E+00, 4.8742022312E+01, 4.7091153948E+00, 9.8853531551E-01],
	[4.6780000000E+04, 6.0526834118E+01, 5.7041347788E+00, 4.8759236756E+01, 4.7093848519E+00, 9.8854056436E-01],
	[4.6785000000E+04, 6.0538425946E+01, 5.7041914707E+00, 4.8776455438E+01, 4.7096542405E+00, 9.8854581052E-01],
	[4.6790000000E+04, 6.0550018755E+01, 5.7042481570E+00, 4.8793678360E+01, 4.7099235605E+00, 9.8855105398E-01],
	[4.6795000000E+04, 6.0561612545E+01, 5.7043048378E+00, 4.8810905520E+01, 4.7101928122E+00, 9.8855629476E-01],
	[4.6800000000E+04, 6.0573207315E+01, 5.7043615132E+00, 4.8828136921E+01, 4.7104619953E+00, 9.8856153285E-01],
	[4.6805000000E+04, 6.0584803067E+01, 5.7044181830E+00, 4.8845372563E+01, 4.7107311101E+00, 9.8856676825E-01],
	[4.6810000000E+04, 6.0596399799E+01, 5.7044748474E+00, 4.8862612446E+01, 4.7110001565E+00, 9.8857200096E-01],
	[4.6815000000E+04, 6.0607997512E+01, 5.7045315063E+00, 4.8879856571E+01, 4.7112691344E+00, 9.8857723100E-01],
	[4.6820000000E+04, 6.0619596206E+01, 5.7045881597E+00, 4.8897104939E+01, 4.7115380441E+00, 9.8858245834E-01],
	[4.6825000000E+04, 6.0631195880E+01, 5.7046448076E+00, 4.8914357549E+01, 4.7118068854E+00, 9.8858768301E-01],
	[4.6830000000E+04, 6.0642796535E+01, 5.7047014500E+00, 4.8931614404E+01, 4.7120756584E+00, 9.8859290500E-01],
	[4.6835000000E+04, 6.0654398171E+01, 5.7047580869E+00, 4.8948875502E+01, 4.7123443632E+00, 9.8859812432E-01],
	[4.6840000000E+04, 6.0666000788E+01, 5.7048147184E+00, 4.8966140846E+01, 4.7126129997E+00, 9.8860334095E-01],
	[4.6845000000E+04, 6.0677604385E+01, 5.7048713443E+00, 4.8983410435E+01, 4.7128815679E+00, 9.8860855492E-01],
	[4.6850000000E+04, 6.0689208963E+01, 5.7049279648E+00, 4.9000684270E+01, 4.7131500679E+00, 9.8861376621E-01],
	[4.6855000000E+04, 6.0700814521E+01, 5.7049845798E+00, 4.9017962352E+01, 4.7134184998E+00, 9.8861897482E-01],
	[4.6860000000E+04, 6.0712421060E+01, 5.7050411893E+00, 4.9035244681E+01, 4.7136868635E+00, 9.8862418077E-01],
	[4.6865000000E+04, 6.0724028580E+01, 5.7050977933E+00, 4.9052531258E+01, 4.7139551590E+00, 9.8862938405E-01],
	[4.6870000000E+04, 6.0735637080E+01, 5.7051543919E+00, 4.9069822083E+01, 4.7142233864E+00, 9.8863458467E-01],
	[4.6875000000E+04, 6.0747246560E+01, 5.7052109850E+00, 4.9087117157E+01, 4.7144915457E+00, 9.8863978262E-01],
	[4.6880000000E+04, 6.0758857021E+01, 5.7052675726E+00, 4.9104416481E+01, 4.7147596369E+00, 9.8864497790E-01],
	[4.6885000000E+04, 6.0770468463E+01, 5.7053241547E+00, 4.9121720055E+01, 4.7150276601E+00, 9.8865017053E-01],
	[4.6890000000E+04, 6.0782080885E+01, 5.7053807314E+00, 4.9139027880E+01, 4.7152956152E+00, 9.8865536049E-01],
	[4.6895000000E+04, 6.0793694287E+01, 5.7054373026E+00, 4.9156339956E+01, 4.7155635024E+00, 9.8866054780E-01],
	[4.6900000000E+04, 6.0805308670E+01, 5.7054938683E+00, 4.9173656285E+01, 4.7158313215E+00, 9.8866573245E-01],
	[4.6905000000E+04, 6.0816924034E+01, 5.7055504286E+00, 4.9190976865E+01, 4.7160990727E+00, 9.8867091444E-01],
	[4.6910000000E+04, 6.0828540377E+01, 5.7056069834E+00, 4.9208301699E+01, 4.7163667559E+00, 9.8867609378E-01],
	[4.6915000000E+04, 6.0840157701E+01, 5.7056635327E+00, 4.9225630787E+01, 4.7166343712E+00, 9.8868127046E-01],
	[4.6920000000E+04, 6.0851776005E+01, 5.7057200765E+00, 4.9242964129E+01, 4.7169019186E+00, 9.8868644450E-01],
	[4.6925000000E+04, 6.0863395290E+01, 5.7057766149E+00, 4.9260301726E+01, 4.7171693982E+00, 9.8869161588E-01],
	[4.6930000000E+04, 6.0875015555E+01, 5.7058331479E+00, 4.9277643579E+01, 4.7174368099E+00, 9.8869678462E-01],
	[4.6935000000E+04, 6.0886636800E+01, 5.7058896753E+00, 4.9294989687E+01, 4.7177041537E+00, 9.8870195072E-01],
	[4.6940000000E+04, 6.0898259025E+01, 5.7059461973E+00, 4.9312340052E+01, 4.7179714298E+00, 9.8870711416E-01],
	[4.6945000000E+04, 6.0909882231E+01, 5.7060027139E+00, 4.9329694675E+01, 4.7182386380E+00, 9.8871227497E-01],
	[4.6950000000E+04, 6.0921506416E+01, 5.7060592249E+00, 4.9347053555E+01, 4.7185057785E+00, 9.8871743313E-01],
	[4.6955000000E+04, 6.0933131582E+01, 5.7061157306E+00, 4.9364416694E+01, 4.7187728512E+00, 9.8872258865E-01],
	[4.6960000000E+04, 6.0944757728E+01, 5.7061722307E+00, 4.9381784092E+01, 4.7190398563E+00, 9.8872774154E-01],
	[4.6965000000E+04, 6.0956384854E+01, 5.7062287254E+00, 4.9399155750E+01, 4.7193067936E+00, 9.8873289178E-01],
	[4.6970000000E+04, 6.0968012961E+01, 5.7062852147E+00, 4.9416531668E+01, 4.7195736632E+00, 9.8873803940E-01],
	[4.6975000000E+04, 6.0979642047E+01, 5.7063416985E+00, 4.9433911847E+01, 4.7198404652E+00, 9.8874318438E-01],
	[4.6980000000E+04, 6.0991272113E+01, 5.7063981768E+00, 4.9451296287E+01, 4.7201071996E+00, 9.8874832672E-01],
	[4.6985000000E+04, 6.1002903160E+01, 5.7064546497E+00, 4.9468684989E+01, 4.7203738664E+00, 9.8875346644E-01],
	[4.6990000000E+04, 6.1014535186E+01, 5.7065111172E+00, 4.9486077954E+01, 4.7206404655E+00, 9.8875860352E-01],
	[4.6995000000E+04, 6.1026168192E+01, 5.7065675792E+00, 4.9503475182E+01, 4.7209069972E+00, 9.8876373798E-01],
	[4.7000000000E+04, 6.1037802179E+01, 5.7066240357E+00, 4.9520876674E+01, 4.7211734612E+00, 9.8876886981E-01],
	[4.7005000000E+04, 6.1049437145E+01, 5.7066804868E+00, 4.9538282430E+01, 4.7214398578E+00, 9.8877399902E-01],
	[4.7010000000E+04, 6.1061073091E+01, 5.7067369325E+00, 4.9555692451E+01, 4.7217061868E+00, 9.8877912561E-01],
	[4.7015000000E+04, 6.1072710018E+01, 5.7067933727E+00, 4.9573106738E+01, 4.7219724484E+00, 9.8878424957E-01],
	[4.7020000000E+04, 6.1084347924E+01, 5.7068498074E+00, 4.9590525291E+01, 4.7222386425E+00, 9.8878937092E-01],
	[4.7025000000E+04, 6.1095986810E+01, 5.7069062367E+00, 4.9607948110E+01, 4.7225047692E+00, 9.8879448964E-01],
	[4.7030000000E+04, 6.1107626675E+01, 5.7069626606E+00, 4.9625375197E+01, 4.7227708285E+00, 9.8879960575E-01],
	[4.7035000000E+04, 6.1119267521E+01, 5.7070190791E+00, 4.9642806552E+01, 4.7230368204E+00, 9.8880471924E-01],
	[4.7040000000E+04, 6.1130909346E+01, 5.7070754921E+00, 4.9660242175E+01, 4.7233027449E+00, 9.8880983012E-01],
	[4.7045000000E+04, 6.1142552151E+01, 5.7071318996E+00, 4.9677682068E+01, 4.7235686021E+00, 9.8881493839E-01],
	[4.7050000000E+04, 6.1154195936E+01, 5.7071883017E+00, 4.9695126230E+01, 4.7238343920E+00, 9.8882004405E-01],
	[4.7055000000E+04, 6.1165840701E+01, 5.7072446984E+00, 4.9712574662E+01, 4.7241001146E+00, 9.8882514710E-01],
	[4.7060000000E+04, 6.1177486445E+01, 5.7073010897E+00, 4.9730027366E+01, 4.7243657699E+00, 9.8883024754E-01],
	[4.7065000000E+04, 6.1189133169E+01, 5.7073574755E+00, 4.9747484341E+01, 4.7246313579E+00, 9.8883534537E-01],
	[4.7070000000E+04, 6.1200780873E+01, 5.7074138559E+00, 4.9764945588E+01, 4.7248968787E+00, 9.8884044060E-01],
	[4.7075000000E+04, 6.1212429556E+01, 5.7074702308E+00, 4.9782411107E+01, 4.7251623323E+00, 9.8884553323E-01],
	[4.7080000000E+04, 6.1224079219E+01, 5.7075266004E+00, 4.9799880900E+01, 4.7254277188E+00, 9.8885062325E-01],
	[4.7085000000E+04, 6.1235729862E+01, 5.7075829645E+00, 4.9817354967E+01, 4.7256930380E+00, 9.8885571068E-01],
	[4.7090000000E+04, 6.1247381484E+01, 5.7076393231E+00, 4.9834833308E+01, 4.7259582901E+00, 9.8886079551E-01],
	[4.7095000000E+04, 6.1259034086E+01, 5.7076956764E+00, 4.9852315924E+01, 4.7262234751E+00, 9.8886587774E-01],
	[4.7100000000E+04, 6.1270687667E+01, 5.7077520242E+00, 4.9869802816E+01, 4.7264885930E+00, 9.8887095737E-01],
	[4.7105000000E+04, 6.1282342228E+01, 5.7078083666E+00, 4.9887293984E+01, 4.7267536438E+00, 9.8887603442E-01],
	[4.7110000000E+04, 6.1293997768E+01, 5.7078647035E+00, 4.9904789428E+01, 4.7270186276E+00, 9.8888110887E-01],
	[4.7115000000E+04, 6.1305654288E+01, 5.7079210351E+00, 4.9922289151E+01, 4.7272835443E+00, 9.8888618072E-01],
	[4.7120000000E+04, 6.1317311787E+01, 5.7079773612E+00, 4.9939793151E+01, 4.7275483941E+00, 9.8889124999E-01],
	[4.7125000000E+04, 6.1328970265E+01, 5.7080336819E+00, 4.9957301429E+01, 4.7278131768E+00, 9.8889631668E-01],
	[4.7130000000E+04, 6.1340629723E+01, 5.7080899971E+00, 4.9974813987E+01, 4.7280778926E+00, 9.8890138077E-01],
	[4.7135000000E+04, 6.1352290161E+01, 5.7081463070E+00, 4.9992330825E+01, 4.7283425414E+00, 9.8890644228E-01],
	[4.7140000000E+04, 6.1363951578E+01, 5.7082026114E+00, 5.0009851943E+01, 4.7286071233E+00, 9.8891150121E-01],
	[4.7145000000E+04, 6.1375613974E+01, 5.7082589105E+00, 5.0027377342E+01, 4.7288716383E+00, 9.8891655756E-01],
	[4.7150000000E+04, 6.1387277349E+01, 5.7083152041E+00, 5.0044907022E+01, 4.7291360865E+00, 9.8892161133E-01],
	[4.7155000000E+04, 6.1398941704E+01, 5.7083714923E+00, 5.0062440985E+01, 4.7294004677E+00, 9.8892666251E-01],
	[4.7160000000E+04, 6.1410607038E+01, 5.7084277750E+00, 5.0079979230E+01, 4.7296647822E+00, 9.8893171113E-01],
	[4.7165000000E+04, 6.1422273351E+01, 5.7084840524E+00, 5.0097521758E+01, 4.7299290298E+00, 9.8893675716E-01],
	[4.7170000000E+04, 6.1433940644E+01, 5.7085403244E+00, 5.0115068571E+01, 4.7301932107E+00, 9.8894180062E-01],
	[4.7175000000E+04, 6.1445608915E+01, 5.7085965909E+00, 5.0132619668E+01, 4.7304573247E+00, 9.8894684151E-01],
	[4.7180000000E+04, 6.1457278166E+01, 5.7086528521E+00, 5.0150175050E+01, 4.7307213721E+00, 9.8895187983E-01],
	[4.7185000000E+04, 6.1468948396E+01, 5.7087091078E+00, 5.0167734718E+01, 4.7309853527E+00, 9.8895691558E-01],
	[4.7190000000E+04, 6.1480619605E+01, 5.7087653581E+00, 5.0185298671E+01, 4.7312492666E+00, 9.8896194876E-01],
	[4.7195000000E+04, 6.1492291794E+01, 5.7088216030E+00, 5.0202866912E+01, 4.7315131138E+00, 9.8896697938E-01],
	[4.7200000000E+04, 6.1503964961E+01, 5.7088778425E+00, 5.0220439441E+01, 4.7317768944E+00, 9.8897200743E-01],
	[4.7205000000E+04, 6.1515639108E+01, 5.7089340767E+00, 5.0238016257E+01, 4.7320406083E+00, 9.8897703292E-01],
	[4.7210000000E+04, 6.1527314233E+01, 5.7089903054E+00, 5.0255597362E+01, 4.7323042556E+00, 9.8898205584E-01],
	[4.7215000000E+04, 6.1538990338E+01, 5.7090465287E+00, 5.0273182756E+01, 4.7325678364E+00, 9.8898707621E-01],
	[4.7220000000E+04, 6.1550667422E+01, 5.7091027466E+00, 5.0290772440E+01, 4.7328313505E+00, 9.8899209402E-01],
	[4.7225000000E+04, 6.1562345484E+01, 5.7091589591E+00, 5.0308366414E+01, 4.7330947981E+00, 9.8899710927E-01],
	[4.7230000000E+04, 6.1574024526E+01, 5.7092151662E+00, 5.0325964680E+01, 4.7333581792E+00, 9.8900212196E-01],
	[4.7235000000E+04, 6.1585704546E+01, 5.7092713679E+00, 5.0343567237E+01, 4.7336214938E+00, 9.8900713210E-01],
	[4.7240000000E+04, 6.1597385546E+01, 5.7093275642E+00, 5.0361174086E+01, 4.7338847419E+00, 9.8901213969E-01],
	[4.7245000000E+04, 6.1609067524E+01, 5.7093837552E+00, 5.0378785228E+01, 4.7341479236E+00, 9.8901714473E-01],
	[4.7250000000E+04, 6.1620750482E+01, 5.7094399407E+00, 5.0396400663E+01, 4.7344110388E+00, 9.8902214721E-01],
	[4.7255000000E+04, 6.1632434418E+01, 5.7094961208E+00, 5.0414020392E+01, 4.7346740876E+00, 9.8902714715E-01],
	[4.7260000000E+04, 6.1644119333E+01, 5.7095522956E+00, 5.0431644416E+01, 4.7349370699E+00, 9.8903214454E-01],
	[4.7265000000E+04, 6.1655805227E+01, 5.7096084649E+00, 5.0449272735E+01, 4.7351999860E+00, 9.8903713939E-01],
	[4.7270000000E+04, 6.1667492099E+01, 5.7096646289E+00, 5.0466905350E+01, 4.7354628356E+00, 9.8904213169E-01],
	[4.7275000000E+04, 6.1679179951E+01, 5.7097207875E+00, 5.0484542261E+01, 4.7357256190E+00, 9.8904712145E-01],
	[4.7280000000E+04, 6.1690868781E+01, 5.7097769407E+00, 5.0502183469E+01, 4.7359883360E+00, 9.8905210868E-01],
	[4.7285000000E+04, 6.1702558590E+01, 5.7098330885E+00, 5.0519828974E+01, 4.7362509868E+00, 9.8905709336E-01],
	[4.7290000000E+04, 6.1714249377E+01, 5.7098892309E+00, 5.0537478778E+01, 4.7365135713E+00, 9.8906207550E-01],
	[4.7295000000E+04, 6.1725941144E+01, 5.7099453679E+00, 5.0555132880E+01, 4.7367760895E+00, 9.8906705511E-01],
	[4.7300000000E+04, 6.1737633889E+01, 5.7100014996E+00, 5.0572791281E+01, 4.7370385416E+00, 9.8907203218E-01],
	[4.7305000000E+04, 6.1749327612E+01, 5.7100576259E+00, 5.0590453983E+01, 4.7373009274E+00, 9.8907700672E-01],
	[4.7310000000E+04, 6.1761022314E+01, 5.7101137468E+00, 5.0608120985E+01, 4.7375632470E+00, 9.8908197873E-01],
	[4.7315000000E+04, 6.1772717995E+01, 5.7101698623E+00, 5.0625792287E+01, 4.7378255005E+00, 9.8908694821E-01],
	[4.7320000000E+04, 6.1784414655E+01, 5.7102259724E+00, 5.0643467892E+01, 4.7380876879E+00, 9.8909191516E-01],
	[4.7325000000E+04, 6.1796112293E+01, 5.7102820772E+00, 5.0661147799E+01, 4.7383498092E+00, 9.8909687959E-01],
	[4.7330000000E+04, 6.1807810909E+01, 5.7103381766E+00, 5.0678832009E+01, 4.7386118644E+00, 9.8910184148E-01],
	[4.7335000000E+04, 6.1819510504E+01, 5.7103942706E+00, 5.0696520522E+01, 4.7388738535E+00, 9.8910680086E-01],
	[4.7340000000E+04, 6.1831211078E+01, 5.7104503592E+00, 5.0714213339E+01, 4.7391357765E+00, 9.8911175771E-01],
	[4.7345000000E+04, 6.1842912630E+01, 5.7105064425E+00, 5.0731910461E+01, 4.7393976336E+00, 9.8911671204E-01],
	[4.7350000000E+04, 6.1854615161E+01, 5.7105625203E+00, 5.0749611888E+01, 4.7396594246E+00, 9.8912166385E-01],
	[4.7355000000E+04, 6.1866318670E+01, 5.7106185929E+00, 5.0767317620E+01, 4.7399211497E+00, 9.8912661314E-01],
	[4.7360000000E+04, 6.1878023157E+01, 5.7106746600E+00, 5.0785027659E+01, 4.7401828088E+00, 9.8913155992E-01],
	[4.7365000000E+04, 6.1889728623E+01, 5.7107307218E+00, 5.0802742006E+01, 4.7404444019E+00, 9.8913650418E-01],
	[4.7370000000E+04, 6.1901435067E+01, 5.7107867782E+00, 5.0820460659E+01, 4.7407059292E+00, 9.8914144593E-01],
	[4.7375000000E+04, 6.1913142489E+01, 5.7108428292E+00, 5.0838183621E+01, 4.7409673905E+00, 9.8914638516E-01],
	[4.7380000000E+04, 6.1924850890E+01, 5.7108988749E+00, 5.0855910892E+01, 4.7412287860E+00, 9.8915132189E-01],
	[4.7385000000E+04, 6.1936560269E+01, 5.7109549152E+00, 5.0873642472E+01, 4.7414901157E+00, 9.8915625611E-01],
	[4.7390000000E+04, 6.1948270627E+01, 5.7110109502E+00, 5.0891378362E+01, 4.7417513795E+00, 9.8916118781E-01],
	[4.7395000000E+04, 6.1959981963E+01, 5.7110669798E+00, 5.0909118562E+01, 4.7420125775E+00, 9.8916611702E-01],
	[4.7400000000E+04, 6.1971694276E+01, 5.7111230040E+00, 5.0926863074E+01, 4.7422737097E+00, 9.8917104372E-01],
	[4.7405000000E+04, 6.1983407569E+01, 5.7111790229E+00, 5.0944611897E+01, 4.7425347761E+00, 9.8917596791E-01],
	[4.7410000000E+04, 6.1995121839E+01, 5.7112350364E+00, 5.0962365033E+01, 4.7427957769E+00, 9.8918088960E-01],
	[4.7415000000E+04, 6.2006837087E+01, 5.7112910446E+00, 5.0980122482E+01, 4.7430567119E+00, 9.8918580880E-01],
	[4.7420000000E+04, 6.2018553314E+01, 5.7113470473E+00, 5.0997884244E+01, 4.7433175812E+00, 9.8919072549E-01],
	[4.7425000000E+04, 6.2030270519E+01, 5.7114030448E+00, 5.1015650320E+01, 4.7435783848E+00, 9.8919563969E-01],
	[4.7430000000E+04, 6.2041988702E+01, 5.7114590369E+00, 5.1033420711E+01, 4.7438391228E+00, 9.8920055139E-01],
	[4.7435000000E+04, 6.2053707863E+01, 5.7115150236E+00, 5.1051195417E+01, 4.7440997951E+00, 9.8920546060E-01],
	[4.7440000000E+04, 6.2065428002E+01, 5.7115710050E+00, 5.1068974439E+01, 4.7443604018E+00, 9.8921036731E-01],
	[4.7445000000E+04, 6.2077149119E+01, 5.7116269810E+00, 5.1086757777E+01, 4.7446209430E+00, 9.8921527154E-01],
	[4.7450000000E+04, 6.2088871214E+01, 5.7116829517E+00, 5.1104545433E+01, 4.7448814185E+00, 9.8922017327E-01],
	[4.7455000000E+04, 6.2100594287E+01, 5.7117389170E+00, 5.1122337406E+01, 4.7451418286E+00, 9.8922507252E-01],
	[4.7460000000E+04, 6.2112318339E+01, 5.7117948770E+00, 5.1140133698E+01, 4.7454021731E+00, 9.8922996927E-01],
	[4.7465000000E+04, 6.2124043368E+01, 5.7118508316E+00, 5.1157934308E+01, 4.7456624521E+00, 9.8923486355E-01],
	[4.7470000000E+04, 6.2135769375E+01, 5.7119067809E+00, 5.1175739238E+01, 4.7459226656E+00, 9.8923975534E-01],
	[4.7475000000E+04, 6.2147496360E+01, 5.7119627249E+00, 5.1193548488E+01, 4.7461828136E+00, 9.8924464465E-01],
	[4.7480000000E+04, 6.2159224323E+01, 5.7120186635E+00, 5.1211362058E+01, 4.7464428962E+00, 9.8924953147E-01],
	[4.7485000000E+04, 6.2170953263E+01, 5.7120745967E+00, 5.1229179950E+01, 4.7467029134E+00, 9.8925441582E-01],
	[4.7490000000E+04, 6.2182683182E+01, 5.7121305247E+00, 5.1247002163E+01, 4.7469628653E+00, 9.8925929769E-01],
	[4.7495000000E+04, 6.2194414078E+01, 5.7121864472E+00, 5.1264828699E+01, 4.7472227517E+00, 9.8926417708E-01],
	[4.7500000000E+04, 6.2206145953E+01, 5.7122423645E+00, 5.1282659557E+01, 4.7474825728E+00, 9.8926905400E-01],
	[4.7505000000E+04, 6.2217878805E+01, 5.7122982764E+00, 5.1300494740E+01, 4.7477423285E+00, 9.8927392844E-01],
	[4.7510000000E+04, 6.2229612635E+01, 5.7123541829E+00, 5.1318334246E+01, 4.7480020190E+00, 9.8927880042E-01],
	[4.7515000000E+04, 6.2241347442E+01, 5.7124100841E+00, 5.1336178078E+01, 4.7482616441E+00, 9.8928366992E-01],
	[4.7520000000E+04, 6.2253083227E+01, 5.7124659800E+00, 5.1354026234E+01, 4.7485212040E+00, 9.8928853695E-01],
	[4.7525000000E+04, 6.2264819990E+01, 5.7125218706E+00, 5.1371878717E+01, 4.7487806987E+00, 9.8929340152E-01],
	[4.7530000000E+04, 6.2276579164E+01, 5.7125794563E+00, 5.1389735526E+01, 4.7490414279E+00, 9.8929826362E-01],
	[4.7535000000E+04, 6.2288339865E+01, 5.7126370797E+00, 5.1407596662E+01, 4.7493021251E+00, 9.8930312325E-01],
	[4.7540000000E+04, 6.2300101550E+01, 5.7126946976E+00, 5.1425462127E+01, 4.7495627571E+00, 9.8930798042E-01],
	[4.7545000000E+04, 6.2311864218E+01, 5.7127523100E+00, 5.1443331919E+01, 4.7498233241E+00, 9.8931283513E-01],
	[4.7550000000E+04, 6.2323627869E+01, 5.7128099169E+00, 5.1461206040E+01, 4.7500838260E+00, 9.8931768737E-01],
	[4.7555000000E+04, 6.2335392504E+01, 5.7128675184E+00, 5.1479084491E+01, 4.7503442628E+00, 9.8932253716E-01],
	[4.7560000000E+04, 6.2347158123E+01, 5.7129251143E+00, 5.1496967272E+01, 4.7506046347E+00, 9.8932738448E-01],
	[4.7565000000E+04, 6.2358924725E+01, 5.7129827048E+00, 5.1514854383E+01, 4.7508649415E+00, 9.8933222935E-01],
	[4.7570000000E+04, 6.2370692311E+01, 5.7130402899E+00, 5.1532745826E+01, 4.7511251834E+00, 9.8933707176E-01],
	[4.7575000000E+04, 6.2382460880E+01, 5.7130978694E+00, 5.1550641601E+01, 4.7513853603E+00, 9.8934191172E-01],
	[4.7580000000E+04, 6.2394230433E+01, 5.7131554435E+00, 5.1568541708E+01, 4.7516454723E+00, 9.8934674922E-01],
	[4.7585000000E+04, 6.2406000969E+01, 5.7132130121E+00, 5.1586446149E+01, 4.7519055194E+00, 9.8935158426E-01],
	[4.7590000000E+04, 6.2417772489E+01, 5.7132705753E+00, 5.1604354923E+01, 4.7521655016E+00, 9.8935641686E-01],
	[4.7595000000E+04, 6.2429544992E+01, 5.7133281330E+00, 5.1622268031E+01, 4.7524254190E+00, 9.8936124700E-01],
	[4.7600000000E+04, 6.2441318478E+01, 5.7133856852E+00, 5.1640185474E+01, 4.7526852715E+00, 9.8936607470E-01],
	[4.7605000000E+04, 6.2453092947E+01, 5.7134432319E+00, 5.1658107253E+01, 4.7529450591E+00, 9.8937089994E-01],
	[4.7610000000E+04, 6.2464868400E+01, 5.7135007732E+00, 5.1676033367E+01, 4.7532047820E+00, 9.8937572274E-01],
	[4.7615000000E+04, 6.2476644837E+01, 5.7135583090E+00, 5.1693963818E+01, 4.7534644401E+00, 9.8938054309E-01],
	[4.7620000000E+04, 6.2488422256E+01, 5.7136158394E+00, 5.1711898607E+01, 4.7537240334E+00, 9.8938536100E-01],
	[4.7625000000E+04, 6.2500200659E+01, 5.7136733643E+00, 5.1729837733E+01, 4.7539835620E+00, 9.8939017647E-01],
	[4.7630000000E+04, 6.2511980045E+01, 5.7137308837E+00, 5.1747781198E+01, 4.7542430259E+00, 9.8939498949E-01],
	[4.7635000000E+04, 6.2523760414E+01, 5.7137883977E+00, 5.1765729001E+01, 4.7545024251E+00, 9.8939980007E-01],
	[4.7640000000E+04, 6.2535541767E+01, 5.7138459062E+00, 5.1783681145E+01, 4.7547617596E+00, 9.8940460821E-01],
	[4.7645000000E+04, 6.2547324102E+01, 5.7139034093E+00, 5.1801637628E+01, 4.7550210294E+00, 9.8940941392E-01],
	[4.7650000000E+04, 6.2559107421E+01, 5.7139609069E+00, 5.1819598452E+01, 4.7552802347E+00, 9.8941421718E-01],
	[4.7655000000E+04, 6.2570891723E+01, 5.7140183991E+00, 5.1837563618E+01, 4.7555393753E+00, 9.8941901801E-01],
	[4.7660000000E+04, 6.2582677008E+01, 5.7140758858E+00, 5.1855533126E+01, 4.7557984513E+00, 9.8942381641E-01],
	[4.7665000000E+04, 6.2594463276E+01, 5.7141333670E+00, 5.1873506976E+01, 4.7560574628E+00, 9.8942861237E-01],
	[4.7670000000E+04, 6.2606250527E+01, 5.7141908428E+00, 5.1891485169E+01, 4.7563164097E+00, 9.8943340590E-01],
	[4.7675000000E+04, 6.2618038762E+01, 5.7142483132E+00, 5.1909467706E+01, 4.7565752921E+00, 9.8943819700E-01],
	[4.7680000000E+04, 6.2629827979E+01, 5.7143057781E+00, 5.1927454588E+01, 4.7568341099E+00, 9.8944298567E-01],
	[4.7685000000E+04, 6.2641618179E+01, 5.7143632375E+00, 5.1945445814E+01, 4.7570928633E+00, 9.8944777191E-01],
	[4.7690000000E+04, 6.2653409362E+01, 5.7144206915E+00, 5.1963441386E+01, 4.7573515523E+00, 9.8945255572E-01],
	[4.7695000000E+04, 6.2665201529E+01, 5.7144781401E+00, 5.1981441304E+01, 4.7576101768E+00, 9.8945733711E-01],
	[4.7700000000E+04, 6.2676994678E+01, 5.7145355832E+00, 5.1999445569E+01, 4.7578687369E+00, 9.8946211607E-01],
	[4.7705000000E+04, 6.2688788810E+01, 5.7145930209E+00, 5.2017454181E+01, 4.7581272325E+00, 9.8946689261E-01],
	[4.7710000000E+04, 6.2700583925E+01, 5.7146504531E+00, 5.2035467141E+01, 4.7583856638E+00, 9.8947166673E-01],
	[4.7715000000E+04, 6.2712380023E+01, 5.7147078799E+00, 5.2053484449E+01, 4.7586440308E+00, 9.8947643842E-01],
	[4.7720000000E+04, 6.2724177104E+01, 5.7147653012E+00, 5.2071506107E+01, 4.7589023334E+00, 9.8948120769E-01],
	[4.7725000000E+04, 6.2735975167E+01, 5.7148227171E+00, 5.2089532114E+01, 4.7591605717E+00, 9.8948597455E-01],
	[4.7730000000E+04, 6.2747774214E+01, 5.7148801276E+00, 5.2107562472E+01, 4.7594187457E+00, 9.8949073899E-01],
	[4.7735000000E+04, 6.2759574243E+01, 5.7149375326E+00, 5.2125597180E+01, 4.7596768554E+00, 9.8949550101E-01],
	[4.7740000000E+04, 6.2771375255E+01, 5.7149949322E+00, 5.2143636240E+01, 4.7599349009E+00, 9.8950026062E-01],
	[4.7745000000E+04, 6.2783177250E+01, 5.7150523264E+00, 5.2161679652E+01, 4.7601928822E+00, 9.8950501781E-01],
	[4.7750000000E+04, 6.2794980227E+01, 5.7151097151E+00, 5.2179727417E+01, 4.7604507992E+00, 9.8950977259E-01],
	[4.7755000000E+04, 6.2806784187E+01, 5.7151670984E+00, 5.2197779534E+01, 4.7607086521E+00, 9.8951452496E-01],
	[4.7760000000E+04, 6.2818589130E+01, 5.7152244763E+00, 5.2215836006E+01, 4.7609664408E+00, 9.8951927492E-01],
	[4.7765000000E+04, 6.2830395056E+01, 5.7152818487E+00, 5.2233896832E+01, 4.7612241653E+00, 9.8952402247E-01],
	[4.7770000000E+04, 6.2842201964E+01, 5.7153392157E+00, 5.2251962014E+01, 4.7614818258E+00, 9.8952876761E-01],
	[4.7775000000E+04, 6.2854009855E+01, 5.7153965773E+00, 5.2270031550E+01, 4.7617394221E+00, 9.8953351034E-01],
	[4.7780000000E+04, 6.2865818728E+01, 5.7154539334E+00, 5.2288105443E+01, 4.7619969543E+00, 9.8953825068E-01],
	[4.7785000000E+04, 6.2877628584E+01, 5.7155112841E+00, 5.2306183693E+01, 4.7622544225E+00, 9.8954298860E-01],
	[4.7790000000E+04, 6.2889439423E+01, 5.7155686294E+00, 5.2324266301E+01, 4.7625118267E+00, 9.8954772413E-01],
	[4.7795000000E+04, 6.2901251244E+01, 5.7156259693E+00, 5.2342353266E+01, 4.7627691668E+00, 9.8955245725E-01],
	[4.7800000000E+04, 6.2913064048E+01, 5.7156833037E+00, 5.2360444590E+01, 4.7630264429E+00, 9.8955718797E-01],
	[4.7805000000E+04, 6.2924877834E+01, 5.7157406328E+00, 5.2378540273E+01, 4.7632836551E+00, 9.8956191629E-01],
	[4.7810000000E+04, 6.2936692603E+01, 5.7157979564E+00, 5.2396640316E+01, 4.7635408033E+00, 9.8956664222E-01],
	[4.7815000000E+04, 6.2948508354E+01, 5.7158552745E+00, 5.2414744719E+01, 4.7637978875E+00, 9.8957136575E-01],
	[4.7820000000E+04, 6.2960325087E+01, 5.7159125873E+00, 5.2432853483E+01, 4.7640549079E+00, 9.8957608688E-01],
	[4.7825000000E+04, 6.2972142803E+01, 5.7159698947E+00, 5.2450966609E+01, 4.7643118643E+00, 9.8958080562E-01],
	[4.7830000000E+04, 6.2983961502E+01, 5.7160271966E+00, 5.2469084097E+01, 4.7645687569E+00, 9.8958552196E-01],
	[4.7835000000E+04, 6.2995781182E+01, 5.7160844931E+00, 5.2487205948E+01, 4.7648255856E+00, 9.8959023592E-01],
	[4.7840000000E+04, 6.3007601845E+01, 5.7161417842E+00, 5.2505332162E+01, 4.7650823505E+00, 9.8959494748E-01],
	[4.7845000000E+04, 6.3019423491E+01, 5.7161990699E+00, 5.2523462740E+01, 4.7653390516E+00, 9.8959965665E-01],
	[4.7850000000E+04, 6.3031246119E+01, 5.7162563502E+00, 5.2541597682E+01, 4.7655956889E+00, 9.8960436344E-01],
	[4.7855000000E+04, 6.3043069729E+01, 5.7163136250E+00, 5.2559736990E+01, 4.7658522625E+00, 9.8960906784E-01],
	[4.7860000000E+04, 6.3054894321E+01, 5.7163708945E+00, 5.2577880663E+01, 4.7661087723E+00, 9.8961376985E-01],
	[4.7865000000E+04, 6.3066719895E+01, 5.7164281585E+00, 5.2596028703E+01, 4.7663652184E+00, 9.8961846948E-01],
	[4.7870000000E+04, 6.3078546452E+01, 5.7164854172E+00, 5.2614181110E+01, 4.7666216007E+00, 9.8962316673E-01],
	[4.7875000000E+04, 6.3090373991E+01, 5.7165426704E+00, 5.2632337884E+01, 4.7668779194E+00, 9.8962786160E-01],
	[4.7880000000E+04, 6.3102202512E+01, 5.7165999182E+00, 5.2650499026E+01, 4.7671341744E+00, 9.8963255408E-01],
	[4.7885000000E+04, 6.3114032016E+01, 5.7166571606E+00, 5.2668664537E+01, 4.7673903658E+00, 9.8963724418E-01],
	[4.7890000000E+04, 6.3125862501E+01, 5.7167143977E+00, 5.2686834417E+01, 4.7676464936E+00, 9.8964193191E-01],
	[4.7895000000E+04, 6.3137693969E+01, 5.7167716293E+00, 5.2705008667E+01, 4.7679025577E+00, 9.8964661726E-01],
	[4.7900000000E+04, 6.3149526419E+01, 5.7168288555E+00, 5.2723187288E+01, 4.7681585583E+00, 9.8965130023E-01],
	[4.7905000000E+04, 6.3161359850E+01, 5.7168860763E+00, 5.2741370280E+01, 4.7684144954E+00, 9.8965598083E-01],
	[4.7910000000E+04, 6.3173194264E+01, 5.7169432917E+00, 5.2759557643E+01, 4.7686703689E+00, 9.8966065906E-01],
	[4.7915000000E+04, 6.3185029660E+01, 5.7170005017E+00, 5.2777749379E+01, 4.7689261788E+00, 9.8966533491E-01],
	[4.7920000000E+04, 6.3196866038E+01, 5.7170577063E+00, 5.2795945487E+01, 4.7691819253E+00, 9.8967000840E-01],
	[4.7925000000E+04, 6.3208703398E+01, 5.7171149056E+00, 5.2814145969E+01, 4.7694376083E+00, 9.8967467951E-01],
	[4.7930000000E+04, 6.3220541740E+01, 5.7171720994E+00, 5.2832350825E+01, 4.7696932279E+00, 9.8967934825E-01],
	[4.7935000000E+04, 6.3232381064E+01, 5.7172292878E+00, 5.2850560056E+01, 4.7699487840E+00, 9.8968401463E-01],
	[4.7940000000E+04, 6.3244221370E+01, 5.7172864709E+00, 5.2868773662E+01, 4.7702042767E+00, 9.8968867864E-01],
	[4.7945000000E+04, 6.3256062657E+01, 5.7173436485E+00, 5.2886991644E+01, 4.7704597060E+00, 9.8969334029E-01],
	[4.7950000000E+04, 6.3267904927E+01, 5.7174008208E+00, 5.2905214002E+01, 4.7707150720E+00, 9.8969799957E-01],
	[4.7955000000E+04, 6.3279748178E+01, 5.7174579876E+00, 5.2923440737E+01, 4.7709703746E+00, 9.8970265650E-01],
	[4.7960000000E+04, 6.3291592412E+01, 5.7175151491E+00, 5.2941671850E+01, 4.7712256139E+00, 9.8970731106E-01],
	[4.7965000000E+04, 6.3303437627E+01, 5.7175723052E+00, 5.2959907341E+01, 4.7714807898E+00, 9.8971196326E-01],
	[4.7970000000E+04, 6.3315283824E+01, 5.7176294559E+00, 5.2978147211E+01, 4.7717359025E+00, 9.8971661310E-01],
	[4.7975000000E+04, 6.3327131002E+01, 5.7176866012E+00, 5.2996391460E+01, 4.7719909519E+00, 9.8972126058E-01],
	[4.7980000000E+04, 6.3338979163E+01, 5.7177437411E+00, 5.3014640089E+01, 4.7722459381E+00, 9.8972590571E-01],
	[4.7985000000E+04, 6.3350828305E+01, 5.7178008757E+00, 5.3032893099E+01, 4.7725008610E+00, 9.8973054849E-01],
	[4.7990000000E+04, 6.3362678429E+01, 5.7178580049E+00, 5.3051150490E+01, 4.7727557208E+00, 9.8973518891E-01],
	[4.7995000000E+04, 6.3374529535E+01, 5.7179151287E+00, 5.3069412263E+01, 4.7730105173E+00, 9.8973982698E-01],
	[4.8000000000E+04, 6.3386381622E+01, 5.7179722471E+00, 5.3087678418E+01, 4.7732652507E+00, 9.8974446269E-01],
	[4.8005000000E+04, 6.3398234691E+01, 5.7180293601E+00, 5.3105948956E+01, 4.7735199210E+00, 9.8974909606E-01],
	[4.8010000000E+04, 6.3410088742E+01, 5.7180864677E+00, 5.3124223878E+01, 4.7737745281E+00, 9.8975372708E-01],
	[4.8015000000E+04, 6.3421943774E+01, 5.7181435700E+00, 5.3142503183E+01, 4.7740290722E+00, 9.8975835575E-01],
	[4.8020000000E+04, 6.3433799788E+01, 5.7182006669E+00, 5.3160786874E+01, 4.7742835531E+00, 9.8976298207E-01],
	[4.8025000000E+04, 6.3445656784E+01, 5.7182577584E+00, 5.3179074950E+01, 4.7745379710E+00, 9.8976760605E-01],
	[4.8030000000E+04, 6.3457514761E+01, 5.7183148446E+00, 5.3197367412E+01, 4.7747923259E+00, 9.8977222768E-01],
	[4.8035000000E+04, 6.3469373719E+01, 5.7183719254E+00, 5.3215664260E+01, 4.7750466178E+00, 9.8977684698E-01],
	[4.8040000000E+04, 6.3481233659E+01, 5.7184290008E+00, 5.3233965496E+01, 4.7753008466E+00, 9.8978146393E-01],
	[4.8045000000E+04, 6.3493094581E+01, 5.7184860708E+00, 5.3252271119E+01, 4.7755550125E+00, 9.8978607854E-01],
	[4.8050000000E+04, 6.3504956484E+01, 5.7185431355E+00, 5.3270581131E+01, 4.7758091154E+00, 9.8979069081E-01],
	[4.8055000000E+04, 6.3516819368E+01, 5.7186001948E+00, 5.3288895531E+01, 4.7760631554E+00, 9.8979530074E-01],
	[4.8060000000E+04, 6.3528683234E+01, 5.7186572487E+00, 5.3307214322E+01, 4.7763171325E+00, 9.8979990834E-01],
	[4.8065000000E+04, 6.3540548082E+01, 5.7187142972E+00, 5.3325537502E+01, 4.7765710466E+00, 9.8980451360E-01],
	[4.8070000000E+04, 6.3552413910E+01, 5.7187713404E+00, 5.3343865073E+01, 4.7768248980E+00, 9.8980911653E-01],
	[4.8075000000E+04, 6.3564280721E+01, 5.7188283783E+00, 5.3362197035E+01, 4.7770786864E+00, 9.8981371713E-01],
	[4.8080000000E+04, 6.3576148512E+01, 5.7188854107E+00, 5.3380533389E+01, 4.7773324120E+00, 9.8981831539E-01],
	[4.8085000000E+04, 6.3588017285E+01, 5.7189424379E+00, 5.3398874135E+01, 4.7775860749E+00, 9.8982291132E-01],
	[4.8090000000E+04, 6.3599887039E+01, 5.7189994596E+00, 5.3417219275E+01, 4.7778396749E+00, 9.8982750493E-01],
	[4.8095000000E+04, 6.3611757774E+01, 5.7190564760E+00, 5.3435568808E+01, 4.7780932121E+00, 9.8983209620E-01],
	[4.8100000000E+04, 6.3623629491E+01, 5.7191134870E+00, 5.3453922736E+01, 4.7783466866E+00, 9.8983668515E-01],
	[4.8105000000E+04, 6.3635502189E+01, 5.7191704927E+00, 5.3472281059E+01, 4.7786000984E+00, 9.8984127178E-01],
	[4.8110000000E+04, 6.3647375868E+01, 5.7192274930E+00, 5.3490643777E+01, 4.7788534475E+00, 9.8984585607E-01],
	[4.8115000000E+04, 6.3659250528E+01, 5.7192844880E+00, 5.3509010891E+01, 4.7791067339E+00, 9.8985043805E-01],
	[4.8120000000E+04, 6.3671126170E+01, 5.7193414776E+00, 5.3527382401E+01, 4.7793599576E+00, 9.8985501771E-01],
	[4.8125000000E+04, 6.3683002792E+01, 5.7193984618E+00, 5.3545758309E+01, 4.7796131187E+00, 9.8985959504E-01],
	[4.8130000000E+04, 6.3694880396E+01, 5.7194554407E+00, 5.3564138615E+01, 4.7798662172E+00, 9.8986417005E-01],
	[4.8135000000E+04, 6.3706758981E+01, 5.7195124143E+00, 5.3582523319E+01, 4.7801192530E+00, 9.8986874275E-01],
	[4.8140000000E+04, 6.3718638547E+01, 5.7195693825E+00, 5.3600912422E+01, 4.7803722263E+00, 9.8987331313E-01],
	[4.8145000000E+04, 6.3730519094E+01, 5.7196263453E+00, 5.3619305925E+01, 4.7806251370E+00, 9.8987788119E-01],
	[4.8150000000E+04, 6.3742400622E+01, 5.7196833028E+00, 5.3637703828E+01, 4.7808779851E+00, 9.8988244694E-01],
	[4.8155000000E+04, 6.3754283131E+01, 5.7197402550E+00, 5.3656106132E+01, 4.7811307708E+00, 9.8988701038E-01],
	[4.8160000000E+04, 6.3766166622E+01, 5.7197972018E+00, 5.3674512838E+01, 4.7813834939E+00, 9.8989157150E-01],
	[4.8165000000E+04, 6.3778051093E+01, 5.7198541432E+00, 5.3692923945E+01, 4.7816361546E+00, 9.8989613031E-01],
	[4.8170000000E+04, 6.3789936545E+01, 5.7199110793E+00, 5.3711339455E+01, 4.7818887528E+00, 9.8990068681E-01],
	[4.8175000000E+04, 6.3801822978E+01, 5.7199680101E+00, 5.3729759368E+01, 4.7821412885E+00, 9.8990524101E-01],
	[4.8180000000E+04, 6.3813710392E+01, 5.7200249355E+00, 5.3748183685E+01, 4.7823937619E+00, 9.8990979290E-01],
	[4.8185000000E+04, 6.3825598787E+01, 5.7200818556E+00, 5.3766612407E+01, 4.7826461728E+00, 9.8991434248E-01],
	[4.8190000000E+04, 6.3837488163E+01, 5.7201387704E+00, 5.3785045533E+01, 4.7828985214E+00, 9.8991888975E-01],
	[4.8195000000E+04, 6.3849378520E+01, 5.7201956798E+00, 5.3803483065E+01, 4.7831508076E+00, 9.8992343473E-01],
	[4.8200000000E+04, 6.3861269857E+01, 5.7202525839E+00, 5.3821925003E+01, 4.7834030314E+00, 9.8992797740E-01],
	[4.8205000000E+04, 6.3873162175E+01, 5.7203094826E+00, 5.3840371348E+01, 4.7836551930E+00, 9.8993251777E-01],
	[4.8210000000E+04, 6.3885055475E+01, 5.7203663760E+00, 5.3858822100E+01, 4.7839072922E+00, 9.8993705583E-01],
	[4.8215000000E+04, 6.3896949755E+01, 5.7204232641E+00, 5.3877277261E+01, 4.7841593292E+00, 9.8994159160E-01],
	[4.8220000000E+04, 6.3908845015E+01, 5.7204801468E+00, 5.3895736830E+01, 4.7844113039E+00, 9.8994612508E-01],
	[4.8225000000E+04, 6.3920741257E+01, 5.7205370242E+00, 5.3914200808E+01, 4.7846632164E+00, 9.8995065625E-01],
	[4.8230000000E+04, 6.3932638479E+01, 5.7205938963E+00, 5.3932669195E+01, 4.7849150667E+00, 9.8995518514E-01],
	[4.8235000000E+04, 6.3944536682E+01, 5.7206507630E+00, 5.3951141993E+01, 4.7851668548E+00, 9.8995971172E-01],
	[4.8240000000E+04, 6.3956435865E+01, 5.7207076244E+00, 5.3969619202E+01, 4.7854185807E+00, 9.8996423602E-01],
	[4.8245000000E+04, 6.3968336030E+01, 5.7207644805E+00, 5.3988100823E+01, 4.7856702444E+00, 9.8996875802E-01],
	[4.8250000000E+04, 6.3980237175E+01, 5.7208213313E+00, 5.4006586856E+01, 4.7859218460E+00, 9.8997327774E-01],
	[4.8255000000E+04, 6.3992139300E+01, 5.7208781767E+00, 5.4025077301E+01, 4.7861733855E+00, 9.8997779516E-01],
	[4.8260000000E+04, 6.4004042406E+01, 5.7209350168E+00, 5.4043572160E+01, 4.7864248629E+00, 9.8998231030E-01],
	[4.8265000000E+04, 6.4015946493E+01, 5.7209918516E+00, 5.4062071433E+01, 4.7866762783E+00, 9.8998682315E-01],
	[4.8270000000E+04, 6.4027851560E+01, 5.7210486810E+00, 5.4080575120E+01, 4.7869276316E+00, 9.8999133371E-01],
	[4.8275000000E+04, 6.4039757608E+01, 5.7211055052E+00, 5.4099083222E+01, 4.7871789228E+00, 9.8999584199E-01],
	[4.8280000000E+04, 6.4051664636E+01, 5.7211623240E+00, 5.4117595741E+01, 4.7874301521E+00, 9.9000034799E-01],
	[4.8285000000E+04, 6.4063572645E+01, 5.7212191375E+00, 5.4136112675E+01, 4.7876813193E+00, 9.9000485171E-01],
	[4.8290000000E+04, 6.4075481634E+01, 5.7212759457E+00, 5.4154634026E+01, 4.7879324246E+00, 9.9000935314E-01],
	[4.8295000000E+04, 6.4087412688E+01, 5.7213343850E+00, 5.4173159795E+01, 4.7881847318E+00, 9.9001385230E-01],
	[4.8300000000E+04, 6.4099345668E+01, 5.7213928918E+00, 5.4191689982E+01, 4.7884370335E+00, 9.9001834918E-01],
	[4.8305000000E+04, 6.4111279635E+01, 5.7214513932E+00, 5.4210224588E+01, 4.7886892734E+00, 9.9002284378E-01],
	[4.8310000000E+04, 6.4123214588E+01, 5.7215098892E+00, 5.4228763613E+01, 4.7889414515E+00, 9.9002733610E-01],
	[4.8315000000E+04, 6.4135150527E+01, 5.7215683796E+00, 5.4247307057E+01, 4.7891935678E+00, 9.9003182616E-01],
	[4.8320000000E+04, 6.4147087452E+01, 5.7216268647E+00, 5.4265854923E+01, 4.7894456222E+00, 9.9003631393E-01],
	[4.8325000000E+04, 6.4159025364E+01, 5.7216853442E+00, 5.4284407209E+01, 4.7896976150E+00, 9.9004079944E-01],
	[4.8330000000E+04, 6.4170964262E+01, 5.7217438184E+00, 5.4302963917E+01, 4.7899495460E+00, 9.9004528268E-01],
	[4.8335000000E+04, 6.4182904146E+01, 5.7218022870E+00, 5.4321525047E+01, 4.7902014152E+00, 9.9004976364E-01],
	[4.8340000000E+04, 6.4194845016E+01, 5.7218607502E+00, 5.4340090600E+01, 4.7904532228E+00, 9.9005424234E-01],
	[4.8345000000E+04, 6.4206786873E+01, 5.7219192080E+00, 5.4358660577E+01, 4.7907049687E+00, 9.9005871877E-01],
	[4.8350000000E+04, 6.4218729715E+01, 5.7219776603E+00, 5.4377234978E+01, 4.7909566530E+00, 9.9006319293E-01],
	[4.8355000000E+04, 6.4230673544E+01, 5.7220361072E+00, 5.4395813803E+01, 4.7912082756E+00, 9.9006766483E-01],
	[4.8360000000E+04, 6.4242618359E+01, 5.7220945486E+00, 5.4414397054E+01, 4.7914598366E+00, 9.9007213447E-01],
	[4.8365000000E+04, 6.4254564159E+01, 5.7221529846E+00, 5.4432984730E+01, 4.7917113360E+00, 9.9007660184E-01],
	[4.8370000000E+04, 6.4266510946E+01, 5.7222114151E+00, 5.4451576833E+01, 4.7919627738E+00, 9.9008106695E-01],
	[4.8375000000E+04, 6.4278458719E+01, 5.7222698402E+00, 5.4470173363E+01, 4.7922141501E+00, 9.9008552981E-01],
	[4.8380000000E+04, 6.4290407478E+01, 5.7223282599E+00, 5.4488774320E+01, 4.7924654648E+00, 9.9008999040E-01],
	[4.8385000000E+04, 6.4302357223E+01, 5.7223866741E+00, 5.4507379706E+01, 4.7927167180E+00, 9.9009444874E-01],
	[4.8390000000E+04, 6.4314307954E+01, 5.7224450828E+00, 5.4525989521E+01, 4.7929679098E+00, 9.9009890482E-01],
	[4.8395000000E+04, 6.4326259671E+01, 5.7225034862E+00, 5.4544603765E+01, 4.7932190400E+00, 9.9010335864E-01],
	[4.8400000000E+04, 6.4338212374E+01, 5.7225618841E+00, 5.4563222439E+01, 4.7934701088E+00, 9.9010781021E-01],
	[4.8405000000E+04, 6.4350166063E+01, 5.7226202765E+00, 5.4581845543E+01, 4.7937211162E+00, 9.9011225953E-01],
	[4.8410000000E+04, 6.4362120737E+01, 5.7226786635E+00, 5.4600473079E+01, 4.7939720621E+00, 9.9011670660E-01],
	[4.8415000000E+04, 6.4374076398E+01, 5.7227370451E+00, 5.4619105047E+01, 4.7942229467E+00, 9.9012115142E-01],
	[4.8420000000E+04, 6.4386033044E+01, 5.7227954213E+00, 5.4637741447E+01, 4.7944737698E+00, 9.9012559398E-01],
	[4.8425000000E+04, 6.4397990676E+01, 5.7228537920E+00, 5.4656382280E+01, 4.7947245317E+00, 9.9013003430E-01],
	[4.8430000000E+04, 6.4409949294E+01, 5.7229121573E+00, 5.4675027547E+01, 4.7949752322E+00, 9.9013447238E-01],
	[4.8435000000E+04, 6.4421908898E+01, 5.7229705171E+00, 5.4693677248E+01, 4.7952258713E+00, 9.9013890821E-01],
	[4.8440000000E+04, 6.4433869488E+01, 5.7230288716E+00, 5.4712331383E+01, 4.7954764492E+00, 9.9014334179E-01],
	[4.8445000000E+04, 6.4445831063E+01, 5.7230872206E+00, 5.4730989955E+01, 4.7957269658E+00, 9.9014777313E-01],
	[4.8450000000E+04, 6.4457793624E+01, 5.7231455641E+00, 5.4749652962E+01, 4.7959774212E+00, 9.9015220223E-01],
	[4.8455000000E+04, 6.4469757171E+01, 5.7232039023E+00, 5.4768320405E+01, 4.7962278153E+00, 9.9015662909E-01],
	[4.8460000000E+04, 6.4481721703E+01, 5.7232622350E+00, 5.4786992286E+01, 4.7964781482E+00, 9.9016105371E-01],
	[4.8465000000E+04, 6.4493687221E+01, 5.7233205623E+00, 5.4805668605E+01, 4.7967284199E+00, 9.9016547609E-01],
	[4.8470000000E+04, 6.4505653725E+01, 5.7233788842E+00, 5.4824349362E+01, 4.7969786305E+00, 9.9016989623E-01],
	[4.8475000000E+04, 6.4517621214E+01, 5.7234372006E+00, 5.4843034558E+01, 4.7972287798E+00, 9.9017431414E-01],
	[4.8480000000E+04, 6.4529589689E+01, 5.7234955116E+00, 5.4861724193E+01, 4.7974788681E+00, 9.9017872981E-01],
	[4.8485000000E+04, 6.4541559150E+01, 5.7235538173E+00, 5.4880418269E+01, 4.7977288952E+00, 9.9018314326E-01],
	[4.8490000000E+04, 6.4553529596E+01, 5.7236121175E+00, 5.4899116785E+01, 4.7979788613E+00, 9.9018755446E-01],
	[4.8495000000E+04, 6.4565501028E+01, 5.7236704122E+00, 5.4917819743E+01, 4.7982287663E+00, 9.9019196344E-01],
	[4.8500000000E+04, 6.4577473445E+01, 5.7237287016E+00, 5.4936527143E+01, 4.7984786102E+00, 9.9019637019E-01],
	[4.8505000000E+04, 6.4589446848E+01, 5.7237869855E+00, 5.4955238985E+01, 4.7987283931E+00, 9.9020077471E-01],
	[4.8510000000E+04, 6.4601421236E+01, 5.7238452641E+00, 5.4973955270E+01, 4.7989781149E+00, 9.9020517700E-01],
	[4.8515000000E+04, 6.4613396609E+01, 5.7239035372E+00, 5.4992675999E+01, 4.7992277758E+00, 9.9020957706E-01],
	[4.8520000000E+04, 6.4625372968E+01, 5.7239618049E+00, 5.5011401173E+01, 4.7994773757E+00, 9.9021397490E-01],
	[4.8525000000E+04, 6.4637350313E+01, 5.7240200672E+00, 5.5030130791E+01, 4.7997269147E+00, 9.9021837052E-01],
	[4.8530000000E+04, 6.4649328643E+01, 5.7240783241E+00, 5.5048864855E+01, 4.7999763927E+00, 9.9022276392E-01],
	[4.8535000000E+04, 6.4661307958E+01, 5.7241365755E+00, 5.5067603365E+01, 4.8002258098E+00, 9.9022715509E-01],
	[4.8540000000E+04, 6.4673288259E+01, 5.7241948216E+00, 5.5086346322E+01, 4.8004751660E+00, 9.9023154404E-01],
	[4.8545000000E+04, 6.4685269545E+01, 5.7242530623E+00, 5.5105093726E+01, 4.8007244613E+00, 9.9023593078E-01],
	[4.8550000000E+04, 6.4697251816E+01, 5.7243112975E+00, 5.5123845578E+01, 4.8009736958E+00, 9.9024031529E-01],
	[4.8555000000E+04, 6.4709235073E+01, 5.7243695274E+00, 5.5142601879E+01, 4.8012228695E+00, 9.9024469759E-01],
	[4.8560000000E+04, 6.4721219314E+01, 5.7244277518E+00, 5.5161362628E+01, 4.8014719823E+00, 9.9024907767E-01],
	[4.8565000000E+04, 6.4733204542E+01, 5.7244859709E+00, 5.5180127828E+01, 4.8017210343E+00, 9.9025345554E-01],
	[4.8570000000E+04, 6.4745190754E+01, 5.7245441845E+00, 5.5198897477E+01, 4.8019700256E+00, 9.9025783120E-01],
	[4.8575000000E+04, 6.4757177951E+01, 5.7246023927E+00, 5.5217671578E+01, 4.8022189561E+00, 9.9026220465E-01],
	[4.8580000000E+04, 6.4769166134E+01, 5.7246605956E+00, 5.5236450130E+01, 4.8024678259E+00, 9.9026657588E-01],
	[4.8585000000E+04, 6.4781155302E+01, 5.7247187930E+00, 5.5255233134E+01, 4.8027166349E+00, 9.9027094491E-01],
	[4.8590000000E+04, 6.4793145455E+01, 5.7247769851E+00, 5.5274020591E+01, 4.8029653833E+00, 9.9027531173E-01],
	[4.8595000000E+04, 6.4805136594E+01, 5.7248351717E+00, 5.5292812501E+01, 4.8032140710E+00, 9.9027967634E-01],
	[4.8600000000E+04, 6.4817128717E+01, 5.7248933530E+00, 5.5311608865E+01, 4.8034626980E+00, 9.9028403874E-01],
	[4.8605000000E+04, 6.4829121825E+01, 5.7249515288E+00, 5.5330409684E+01, 4.8037112644E+00, 9.9028839894E-01],
	[4.8610000000E+04, 6.4841115919E+01, 5.7250096993E+00, 5.5349214957E+01, 4.8039597702E+00, 9.9029275694E-01],
	[4.8615000000E+04, 6.4853110997E+01, 5.7250678644E+00, 5.5368024687E+01, 4.8042082154E+00, 9.9029711273E-01],
	[4.8620000000E+04, 6.4865107061E+01, 5.7251260241E+00, 5.5386838872E+01, 4.8044566000E+00, 9.9030146633E-01],
	[4.8625000000E+04, 6.4877104110E+01, 5.7251841783E+00, 5.5405657515E+01, 4.8047049241E+00, 9.9030581772E-01],
	[4.8630000000E+04, 6.4889102143E+01, 5.7252423272E+00, 5.5424480615E+01, 4.8049531876E+00, 9.9031016691E-01],
	[4.8635000000E+04, 6.4901101162E+01, 5.7253004708E+00, 5.5443308173E+01, 4.8052013906E+00, 9.9031451391E-01],
	[4.8640000000E+04, 6.4913101165E+01, 5.7253586089E+00, 5.5462140189E+01, 4.8054495331E+00, 9.9031885871E-01],
	[4.8645000000E+04, 6.4925102154E+01, 5.7254167416E+00, 5.5480976665E+01, 4.8056976151E+00, 9.9032320132E-01],
	[4.8650000000E+04, 6.4937104127E+01, 5.7254748690E+00, 5.5499817601E+01, 4.8059456367E+00, 9.9032754173E-01],
	[4.8655000000E+04, 6.4949107085E+01, 5.7255329910E+00, 5.5518662997E+01, 4.8061935978E+00, 9.9033187995E-01],
	[4.8660000000E+04, 6.4961111028E+01, 5.7255911076E+00, 5.5537512854E+01, 4.8064414985E+00, 9.9033621598E-01],
	[4.8665000000E+04, 6.4973115956E+01, 5.7256492188E+00, 5.5556367173E+01, 4.8066893389E+00, 9.9034054982E-01],
	[4.8670000000E+04, 6.4985121869E+01, 5.7257073246E+00, 5.5575225955E+01, 4.8069371188E+00, 9.9034488147E-01],
	[4.8675000000E+04, 6.4997128767E+01, 5.7257654251E+00, 5.5594089199E+01, 4.8071848384E+00, 9.9034921093E-01],
	[4.8680000000E+04, 6.5009136649E+01, 5.7258235201E+00, 5.5612956906E+01, 4.8074324976E+00, 9.9035353821E-01],
	[4.8685000000E+04, 6.5021145516E+01, 5.7258816098E+00, 5.5631829077E+01, 4.8076800966E+00, 9.9035786330E-01],
	[4.8690000000E+04, 6.5033155368E+01, 5.7259396941E+00, 5.5650705714E+01, 4.8079276352E+00, 9.9036218620E-01],
	[4.8695000000E+04, 6.5045166205E+01, 5.7259977731E+00, 5.5669586815E+01, 4.8081751135E+00, 9.9036650693E-01],
	[4.8700000000E+04, 6.5057178026E+01, 5.7260558467E+00, 5.5688472382E+01, 4.8084225316E+00, 9.9037082547E-01],
	[4.8705000000E+04, 6.5069190832E+01, 5.7261139149E+00, 5.5707362416E+01, 4.8086698895E+00, 9.9037514183E-01],
	[4.8710000000E+04, 6.5081204623E+01, 5.7261719777E+00, 5.5726256916E+01, 4.8089171871E+00, 9.9037945601E-01],
	[4.8715000000E+04, 6.5093219398E+01, 5.7262300351E+00, 5.5745155885E+01, 4.8091644245E+00, 9.9038376801E-01],
	[4.8720000000E+04, 6.5105235158E+01, 5.7262880872E+00, 5.5764059321E+01, 4.8094116018E+00, 9.9038807783E-01],
	[4.8725000000E+04, 6.5117251903E+01, 5.7263461339E+00, 5.5782967227E+01, 4.8096587188E+00, 9.9039238548E-01],
	[4.8730000000E+04, 6.5129269632E+01, 5.7264041753E+00, 5.5801879601E+01, 4.8099057758E+00, 9.9039669096E-01],
	[4.8735000000E+04, 6.5141288346E+01, 5.7264622113E+00, 5.5820796446E+01, 4.8101527726E+00, 9.9040099426E-01],
	[4.8740000000E+04, 6.5153308044E+01, 5.7265202419E+00, 5.5839717761E+01, 4.8103997093E+00, 9.9040529539E-01],
	[4.8745000000E+04, 6.5165328727E+01, 5.7265782671E+00, 5.5858643548E+01, 4.8106465860E+00, 9.9040959434E-01],
	[4.8750000000E+04, 6.5177350394E+01, 5.7266362870E+00, 5.5877573806E+01, 4.8108934025E+00, 9.9041389113E-01],
	[4.8755000000E+04, 6.5189373046E+01, 5.7266943015E+00, 5.5896508537E+01, 4.8111401591E+00, 9.9041818575E-01],
	[4.8760000000E+04, 6.5201396682E+01, 5.7267523107E+00, 5.5915447741E+01, 4.8113868556E+00, 9.9042247820E-01],
	[4.8765000000E+04, 6.5213421303E+01, 5.7268103145E+00, 5.5934391418E+01, 4.8116334921E+00, 9.9042676848E-01],
	[4.8770000000E+04, 6.5225446908E+01, 5.7268683129E+00, 5.5953339570E+01, 4.8118800686E+00, 9.9043105660E-01],
	[4.8775000000E+04, 6.5237473497E+01, 5.7269263060E+00, 5.5972292196E+01, 4.8121265851E+00, 9.9043534256E-01],
	[4.8780000000E+04, 6.5249501071E+01, 5.7269842937E+00, 5.5991249298E+01, 4.8123730417E+00, 9.9043962635E-01],
	[4.8785000000E+04, 6.5261529629E+01, 5.7270422761E+00, 5.6010210876E+01, 4.8126194384E+00, 9.9044390798E-01],
	[4.8790000000E+04, 6.5273559172E+01, 5.7271002531E+00, 5.6029176930E+01, 4.8128657752E+00, 9.9044818745E-01],
	[4.8795000000E+04, 6.5285589699E+01, 5.7271582248E+00, 5.6048147462E+01, 4.8131120521E+00, 9.9045246476E-01],
	[4.8800000000E+04, 6.5297621210E+01, 5.7272161911E+00, 5.6067122471E+01, 4.8133582691E+00, 9.9045673991E-01],
	[4.8805000000E+04, 6.5309653705E+01, 5.7272741520E+00, 5.6086101959E+01, 4.8136044263E+00, 9.9046101291E-01],
	[4.8810000000E+04, 6.5321687185E+01, 5.7273321076E+00, 5.6105085925E+01, 4.8138505236E+00, 9.9046528375E-01],
	[4.8815000000E+04, 6.5333721649E+01, 5.7273900579E+00, 5.6124074372E+01, 4.8140965612E+00, 9.9046955243E-01],
	[4.8820000000E+04, 6.5345757097E+01, 5.7274480028E+00, 5.6143067298E+01, 4.8143425389E+00, 9.9047381897E-01],
	[4.8825000000E+04, 6.5357793529E+01, 5.7275059423E+00, 5.6162064705E+01, 4.8145884569E+00, 9.9047808335E-01],
	[4.8830000000E+04, 6.5369830946E+01, 5.7275638765E+00, 5.6181066594E+01, 4.8148343152E+00, 9.9048234558E-01],
	[4.8835000000E+04, 6.5381869347E+01, 5.7276218054E+00, 5.6200072965E+01, 4.8150801137E+00, 9.9048660565E-01],
	[4.8840000000E+04, 6.5393908732E+01, 5.7276797289E+00, 5.6219083818E+01, 4.8153258525E+00, 9.9049086358E-01],
	[4.8845000000E+04, 6.5405949100E+01, 5.7277376471E+00, 5.6238099154E+01, 4.8155715316E+00, 9.9049511937E-01],
	[4.8850000000E+04, 6.5417990454E+01, 5.7277955599E+00, 5.6257118974E+01, 4.8158171510E+00, 9.9049937300E-01],
	[4.8855000000E+04, 6.5430032791E+01, 5.7278534674E+00, 5.6276143278E+01, 4.8160627108E+00, 9.9050362449E-01],
	[4.8860000000E+04, 6.5442076112E+01, 5.7279113695E+00, 5.6295172068E+01, 4.8163082109E+00, 9.9050787384E-01],
	[4.8865000000E+04, 6.5454120417E+01, 5.7279692664E+00, 5.6314205343E+01, 4.8165536515E+00, 9.9051212105E-01],
	[4.8870000000E+04, 6.5466165706E+01, 5.7280271578E+00, 5.6333243104E+01, 4.8167990324E+00, 9.9051636611E-01],
	[4.8875000000E+04, 6.5478211979E+01, 5.7280850440E+00, 5.6352285352E+01, 4.8170443538E+00, 9.9052060903E-01],
	[4.8880000000E+04, 6.5490259237E+01, 5.7281429247E+00, 5.6371332087E+01, 4.8172896156E+00, 9.9052484982E-01],
	[4.8885000000E+04, 6.5502307478E+01, 5.7282008002E+00, 5.6390383310E+01, 4.8175348179E+00, 9.9052908846E-01],
	[4.8890000000E+04, 6.5514356703E+01, 5.7282586703E+00, 5.6409439022E+01, 4.8177799606E+00, 9.9053332497E-01],
	[4.8895000000E+04, 6.5526406912E+01, 5.7283165351E+00, 5.6428499222E+01, 4.8180250439E+00, 9.9053755934E-01],
	[4.8900000000E+04, 6.5538458105E+01, 5.7283743946E+00, 5.6447563913E+01, 4.8182700677E+00, 9.9054179158E-01],
	[4.8905000000E+04, 6.5550510282E+01, 5.7284322487E+00, 5.6466633094E+01, 4.8185150320E+00, 9.9054602169E-01],
	[4.8910000000E+04, 6.5562563442E+01, 5.7284900975E+00, 5.6485706766E+01, 4.8187599369E+00, 9.9055024966E-01],
	[4.8915000000E+04, 6.5574617587E+01, 5.7285479410E+00, 5.6504784929E+01, 4.8190047824E+00, 9.9055447550E-01],
	[4.8920000000E+04, 6.5586672715E+01, 5.7286057791E+00, 5.6523867585E+01, 4.8192495685E+00, 9.9055869921E-01],
	[4.8925000000E+04, 6.5598728827E+01, 5.7286636119E+00, 5.6542954733E+01, 4.8194942952E+00, 9.9056292080E-01],
	[4.8930000000E+04, 6.5610785923E+01, 5.7287214394E+00, 5.6562046375E+01, 4.8197389625E+00, 9.9056714025E-01],
	[4.8935000000E+04, 6.5622844002E+01, 5.7287792616E+00, 5.6581142510E+01, 4.8199835705E+00, 9.9057135758E-01],
	[4.8940000000E+04, 6.5634903065E+01, 5.7288370784E+00, 5.6600243140E+01, 4.8202281192E+00, 9.9057557279E-01],
	[4.8945000000E+04, 6.5646963112E+01, 5.7288948899E+00, 5.6619348265E+01, 4.8204726086E+00, 9.9057978587E-01],
	[4.8950000000E+04, 6.5659024143E+01, 5.7289526961E+00, 5.6638457886E+01, 4.8207170387E+00, 9.9058399682E-01],
	[4.8955000000E+04, 6.5671086158E+01, 5.7290104970E+00, 5.6657572003E+01, 4.8209614095E+00, 9.9058820566E-01],
	[4.8960000000E+04, 6.5683149156E+01, 5.7290682925E+00, 5.6676690618E+01, 4.8212057211E+00, 9.9059241238E-01],
	[4.8965000000E+04, 6.5695213137E+01, 5.7291260827E+00, 5.6695813729E+01, 4.8214499734E+00, 9.9059661697E-01],
	[4.8970000000E+04, 6.5707278102E+01, 5.7291838676E+00, 5.6714941339E+01, 4.8216941666E+00, 9.9060081945E-01],
	[4.8975000000E+04, 6.5719344051E+01, 5.7292416472E+00, 5.6734073448E+01, 4.8219383006E+00, 9.9060501981E-01],
	[4.8980000000E+04, 6.5731410984E+01, 5.7292994215E+00, 5.6753210055E+01, 4.8221823754E+00, 9.9060921806E-01],
	[4.8985000000E+04, 6.5743478900E+01, 5.7293571905E+00, 5.6772351163E+01, 4.8224263910E+00, 9.9061341419E-01],
	[4.8990000000E+04, 6.5755547799E+01, 5.7294149541E+00, 5.6791496771E+01, 4.8226703476E+00, 9.9061760821E-01],
	[4.8995000000E+04, 6.5767617682E+01, 5.7294727125E+00, 5.6810646881E+01, 4.8229142450E+00, 9.9062180011E-01],
	[4.9000000000E+04, 6.5779688549E+01, 5.7295304655E+00, 5.6829801492E+01, 4.8231580833E+00, 9.9062598991E-01],
	[4.9005000000E+04, 6.5791760399E+01, 5.7295882132E+00, 5.6848960605E+01, 4.8234018626E+00, 9.9063017759E-01],
	[4.9010000000E+04, 6.5803833232E+01, 5.7296459556E+00, 5.6868124222E+01, 4.8236455828E+00, 9.9063436317E-01],
	[4.9015000000E+04, 6.5815907049E+01, 5.7297036927E+00, 5.6887292341E+01, 4.8238892440E+00, 9.9063854664E-01],
	[4.9020000000E+04, 6.5827981849E+01, 5.7297614245E+00, 5.6906464965E+01, 4.8241328462E+00, 9.9064272800E-01],
	[4.9025000000E+04, 6.5840057633E+01, 5.7298191510E+00, 5.6925642094E+01, 4.8243763894E+00, 9.9064690726E-01],
	[4.9030000000E+04, 6.5852134400E+01, 5.7298768721E+00, 5.6944823728E+01, 4.8246198736E+00, 9.9065108441E-01],
	[4.9035000000E+04, 6.5864212150E+01, 5.7299345880E+00, 5.6964009868E+01, 4.8248632988E+00, 9.9065525946E-01],
	[4.9040000000E+04, 6.5876290884E+01, 5.7299922986E+00, 5.6983200514E+01, 4.8251066652E+00, 9.9065943241E-01],
	[4.9045000000E+04, 6.5888370600E+01, 5.7300500038E+00, 5.7002395667E+01, 4.8253499726E+00, 9.9066360326E-01],
	[4.9050000000E+04, 6.5900451301E+01, 5.7301077038E+00, 5.7021595328E+01, 4.8255932211E+00, 9.9066777201E-01],
	[4.9055000000E+04, 6.5912532984E+01, 5.7301653985E+00, 5.7040799498E+01, 4.8258364107E+00, 9.9067193866E-01],
	[4.9060000000E+04, 6.5924615651E+01, 5.7302230878E+00, 5.7060008176E+01, 4.8260795415E+00, 9.9067610321E-01],
	[4.9065000000E+04, 6.5936699301E+01, 5.7302807719E+00, 5.7079221364E+01, 4.8263226134E+00, 9.9068026567E-01],
	[4.9070000000E+04, 6.5948794439E+01, 5.7303392484E+00, 5.7098439062E+01, 4.8265662487E+00, 9.9068442603E-01],
	[4.9075000000E+04, 6.5960902129E+01, 5.7303985978E+00, 5.7117661270E+01, 4.8268105103E+00, 9.9068858430E-01],
	[4.9080000000E+04, 6.5973010808E+01, 5.7304579417E+00, 5.7136887990E+01, 4.8270547132E+00, 9.9069274048E-01],
	[4.9085000000E+04, 6.5985120476E+01, 5.7305172802E+00, 5.7156119222E+01, 4.8272988574E+00, 9.9069689456E-01],
	[4.9090000000E+04, 6.5997231134E+01, 5.7305766133E+00, 5.7175354966E+01, 4.8275429429E+00, 9.9070104656E-01],
	[4.9095000000E+04, 6.6009342780E+01, 5.7306359409E+00, 5.7194595224E+01, 4.8277869697E+00, 9.9070519647E-01],
	[4.9100000000E+04, 6.6021455415E+01, 5.7306952632E+00, 5.7213839995E+01, 4.8280309379E+00, 9.9070934429E-01],
	[4.9105000000E+04, 6.6033569039E+01, 5.7307545800E+00, 5.7233089280E+01, 4.8282748475E+00, 9.9071349002E-01],
	[4.9110000000E+04, 6.6045683652E+01, 5.7308138913E+00, 5.7252343080E+01, 4.8285186985E+00, 9.9071763367E-01],
	[4.9115000000E+04, 6.6057799254E+01, 5.7308731973E+00, 5.7271601396E+01, 4.8287624909E+00, 9.9072177523E-01],
	[4.9120000000E+04, 6.6069915844E+01, 5.7309324978E+00, 5.7290864227E+01, 4.8290062247E+00, 9.9072591471E-01],
	[4.9125000000E+04, 6.6082033424E+01, 5.7309917929E+00, 5.7310131576E+01, 4.8292499000E+00, 9.9073005211E-01],
	[4.9130000000E+04, 6.6094151992E+01, 5.7310510826E+00, 5.7329403442E+01, 4.8294935168E+00, 9.9073418742E-01],
	[4.9135000000E+04, 6.6106271549E+01, 5.7311103668E+00, 5.7348679825E+01, 4.8297370750E+00, 9.9073832066E-01],
	[4.9140000000E+04, 6.6118392095E+01, 5.7311696457E+00, 5.7367960727E+01, 4.8299805748E+00, 9.9074245182E-01],
	[4.9145000000E+04, 6.6130513630E+01, 5.7312289191E+00, 5.7387246148E+01, 4.8302240161E+00, 9.9074658090E-01],
	[4.9150000000E+04, 6.6142636153E+01, 5.7312881871E+00, 5.7406536089E+01, 4.8304673989E+00, 9.9075070791E-01],
	[4.9155000000E+04, 6.6154759665E+01, 5.7313474497E+00, 5.7425830550E+01, 4.8307107233E+00, 9.9075483284E-01],
	[4.9160000000E+04, 6.6166884166E+01, 5.7314067069E+00, 5.7445129532E+01, 4.8309539893E+00, 9.9075895570E-01],
	[4.9165000000E+04, 6.6179009655E+01, 5.7314659586E+00, 5.7464433035E+01, 4.8311971969E+00, 9.9076307648E-01],
	[4.9170000000E+04, 6.6191136133E+01, 5.7315252050E+00, 5.7483741061E+01, 4.8314403461E+00, 9.9076719520E-01],
	[4.9175000000E+04, 6.6203263600E+01, 5.7315844459E+00, 5.7503053609E+01, 4.8316834370E+00, 9.9077131184E-01],
	[4.9180000000E+04, 6.6215392055E+01, 5.7316436814E+00, 5.7522370681E+01, 4.8319264695E+00, 9.9077542641E-01],
	[4.9185000000E+04, 6.6227521499E+01, 5.7317029115E+00, 5.7541692276E+01, 4.8321694438E+00, 9.9077953892E-01],
	[4.9190000000E+04, 6.6239651932E+01, 5.7317621362E+00, 5.7561018396E+01, 4.8324123597E+00, 9.9078364936E-01],
	[4.9195000000E+04, 6.6251783353E+01, 5.7318213555E+00, 5.7580349040E+01, 4.8326552173E+00, 9.9078775773E-01],
	[4.9200000000E+04, 6.6263915762E+01, 5.7318805694E+00, 5.7599684211E+01, 4.8328980167E+00, 9.9079186404E-01],
	[4.9205000000E+04, 6.6276049160E+01, 5.7319397779E+00, 5.7619023908E+01, 4.8331407579E+00, 9.9079596828E-01],
	[4.9210000000E+04, 6.6288183547E+01, 5.7319989810E+00, 5.7638368131E+01, 4.8333834408E+00, 9.9080007047E-01],
	[4.9215000000E+04, 6.6300318922E+01, 5.7320581786E+00, 5.7657716882E+01, 4.8336260655E+00, 9.9080417059E-01],
	[4.9220000000E+04, 6.6312455286E+01, 5.7321173709E+00, 5.7677070162E+01, 4.8338686320E+00, 9.9080826865E-01],
	[4.9225000000E+04, 6.6324592638E+01, 5.7321765578E+00, 5.7696427969E+01, 4.8341111404E+00, 9.9081236465E-01],
	[4.9230000000E+04, 6.6336730978E+01, 5.7322357392E+00, 5.7715790306E+01, 4.8343535906E+00, 9.9081645860E-01],
	[4.9235000000E+04, 6.6348870307E+01, 5.7322949153E+00, 5.7735157173E+01, 4.8345959827E+00, 9.9082055049E-01],
	[4.9240000000E+04, 6.6361010624E+01, 5.7323540860E+00, 5.7754528571E+01, 4.8348383167E+00, 9.9082464032E-01],
	[4.9245000000E+04, 6.6373151929E+01, 5.7324132513E+00, 5.7773904499E+01, 4.8350805926E+00, 9.9082872810E-01],
	[4.9250000000E+04, 6.6385294223E+01, 5.7324724111E+00, 5.7793284959E+01, 4.8353228104E+00, 9.9083281383E-01],
	[4.9255000000E+04, 6.6397437505E+01, 5.7325315656E+00, 5.7812669952E+01, 4.8355649702E+00, 9.9083689750E-01],
	[4.9260000000E+04, 6.6409581775E+01, 5.7325907147E+00, 5.7832059477E+01, 4.8358070719E+00, 9.9084097913E-01],
	[4.9265000000E+04, 6.6421727034E+01, 5.7326498584E+00, 5.7851453536E+01, 4.8360491156E+00, 9.9084505870E-01],
	[4.9270000000E+04, 6.6433873281E+01, 5.7327089967E+00, 5.7870852128E+01, 4.8362911014E+00, 9.9084913623E-01],
	[4.9275000000E+04, 6.6446020516E+01, 5.7327681296E+00, 5.7890255256E+01, 4.8365330291E+00, 9.9085321171E-01],
	[4.9280000000E+04, 6.6458168740E+01, 5.7328272571E+00, 5.7909662918E+01, 4.8367748989E+00, 9.9085728514E-01],
	[4.9285000000E+04, 6.6470317951E+01, 5.7328863793E+00, 5.7929075117E+01, 4.8370167108E+00, 9.9086135653E-01],
	[4.9290000000E+04, 6.6482468151E+01, 5.7329454960E+00, 5.7948491852E+01, 4.8372584647E+00, 9.9086542587E-01],
	[4.9295000000E+04, 6.6494619339E+01, 5.7330046074E+00, 5.7967913124E+01, 4.8375001607E+00, 9.9086949317E-01],
	[4.9300000000E+04, 6.6506771515E+01, 5.7330637133E+00, 5.7987338934E+01, 4.8377417989E+00, 9.9087355843E-01],
	[4.9305000000E+04, 6.6518924679E+01, 5.7331228139E+00, 5.8006769282E+01, 4.8379833792E+00, 9.9087762165E-01],
	[4.9310000000E+04, 6.6531078831E+01, 5.7331819091E+00, 5.8026204168E+01, 4.8382249016E+00, 9.9088168283E-01],
	[4.9315000000E+04, 6.6543233972E+01, 5.7332409989E+00, 5.8045643595E+01, 4.8384663662E+00, 9.9088574198E-01],
	[4.9320000000E+04, 6.6555390100E+01, 5.7333000834E+00, 5.8065087561E+01, 4.8387077730E+00, 9.9088979908E-01],
	[4.9325000000E+04, 6.6567547216E+01, 5.7333591624E+00, 5.8084536068E+01, 4.8389491221E+00, 9.9089385415E-01],
	[4.9330000000E+04, 6.6579705321E+01, 5.7334182361E+00, 5.8103989116E+01, 4.8391904133E+00, 9.9089790719E-01],
	[4.9335000000E+04, 6.6591864413E+01, 5.7334773044E+00, 5.8123446706E+01, 4.8394316468E+00, 9.9090195819E-01],
	[4.9340000000E+04, 6.6604024494E+01, 5.7335363673E+00, 5.8142908839E+01, 4.8396728226E+00, 9.9090600716E-01],
	[4.9345000000E+04, 6.6616185562E+01, 5.7335954249E+00, 5.8162375514E+01, 4.8399139407E+00, 9.9091005409E-01],
	[4.9350000000E+04, 6.6628347618E+01, 5.7336544770E+00, 5.8181846734E+01, 4.8401550010E+00, 9.9091409900E-01],
	[4.9355000000E+04, 6.6640510662E+01, 5.7337135238E+00, 5.8201322497E+01, 4.8403960037E+00, 9.9091814188E-01],
	[4.9360000000E+04, 6.6652674694E+01, 5.7337725653E+00, 5.8220802805E+01, 4.8406369488E+00, 9.9092218273E-01],
	[4.9365000000E+04, 6.6664839714E+01, 5.7338316013E+00, 5.8240287659E+01, 4.8408778362E+00, 9.9092622155E-01],
	[4.9370000000E+04, 6.6677005722E+01, 5.7338906320E+00, 5.8259777059E+01, 4.8411186659E+00, 9.9093025835E-01],
	[4.9375000000E+04, 6.6689172718E+01, 5.7339496573E+00, 5.8279271005E+01, 4.8413594381E+00, 9.9093429313E-01],
	[4.9380000000E+04, 6.6701340701E+01, 5.7340086772E+00, 5.8298769499E+01, 4.8416001527E+00, 9.9093832588E-01],
	[4.9385000000E+04, 6.6713509673E+01, 5.7340676918E+00, 5.8318272541E+01, 4.8418408098E+00, 9.9094235661E-01],
	[4.9390000000E+04, 6.6725679632E+01, 5.7341267010E+00, 5.8337780131E+01, 4.8420814093E+00, 9.9094638532E-01],
	[4.9395000000E+04, 6.6737850579E+01, 5.7341857048E+00, 5.8357292270E+01, 4.8423219512E+00, 9.9095041200E-01],
	[4.9400000000E+04, 6.6750022513E+01, 5.7342447033E+00, 5.8376808959E+01, 4.8425624357E+00, 9.9095443667E-01],
	[4.9405000000E+04, 6.6762195435E+01, 5.7343036964E+00, 5.8396330198E+01, 4.8428028627E+00, 9.9095845933E-01],
	[4.9410000000E+04, 6.6774369345E+01, 5.7343626841E+00, 5.8415855987E+01, 4.8430432322E+00, 9.9096247996E-01],
	[4.9415000000E+04, 6.6786544243E+01, 5.7344216665E+00, 5.8435386329E+01, 4.8432835442E+00, 9.9096649858E-01],
	[4.9420000000E+04, 6.6798720128E+01, 5.7344806435E+00, 5.8454921222E+01, 4.8435237988E+00, 9.9097051519E-01],
	[4.9425000000E+04, 6.6810897001E+01, 5.7345396152E+00, 5.8474460668E+01, 4.8437639961E+00, 9.9097452978E-01],
	[4.9430000000E+04, 6.6823074862E+01, 5.7345985815E+00, 5.8494004667E+01, 4.8440041359E+00, 9.9097854236E-01],
	[4.9435000000E+04, 6.6835253710E+01, 5.7346575424E+00, 5.8513553220E+01, 4.8442442183E+00, 9.9098255293E-01],
	[4.9440000000E+04, 6.6847433546E+01, 5.7347164980E+00, 5.8533106328E+01, 4.8444842434E+00, 9.9098656150E-01],
	[4.9445000000E+04, 6.6859614369E+01, 5.7347754482E+00, 5.8552663991E+01, 4.8447242111E+00, 9.9099056805E-01],
	[4.9450000000E+04, 6.6871796180E+01, 5.7348343931E+00, 5.8572226209E+01, 4.8449641216E+00, 9.9099457259E-01],
	[4.9455000000E+04, 6.6883978978E+01, 5.7348933326E+00, 5.8591792983E+01, 4.8452039747E+00, 9.9099857513E-01],
	[4.9460000000E+04, 6.6896162764E+01, 5.7349522668E+00, 5.8611364315E+01, 4.8454437705E+00, 9.9100257567E-01],
	[4.9465000000E+04, 6.6908347537E+01, 5.7350111956E+00, 5.8630940203E+01, 4.8456835091E+00, 9.9100657420E-01],
	[4.9470000000E+04, 6.6920533298E+01, 5.7350701191E+00, 5.8650520650E+01, 4.8459231905E+00, 9.9101057073E-01],
	[4.9475000000E+04, 6.6932720046E+01, 5.7351290372E+00, 5.8670105656E+01, 4.8461628146E+00, 9.9101456525E-01],
	[4.9480000000E+04, 6.6944907782E+01, 5.7351879499E+00, 5.8689695221E+01, 4.8464023815E+00, 9.9101855778E-01],
	[4.9485000000E+04, 6.6957096505E+01, 5.7352468574E+00, 5.8709289345E+01, 4.8466418912E+00, 9.9102254830E-01],
	[4.9490000000E+04, 6.6969286215E+01, 5.7353057594E+00, 5.8728888030E+01, 4.8468813437E+00, 9.9102653683E-01],
	[4.9495000000E+04, 6.6981476913E+01, 5.7353646562E+00, 5.8748491276E+01, 4.8471207391E+00, 9.9103052336E-01],
	[4.9500000000E+04, 6.6993668598E+01, 5.7354235475E+00, 5.8768099084E+01, 4.8473600774E+00, 9.9103450790E-01],
	[4.9505000000E+04, 6.7005861271E+01, 5.7354824336E+00, 5.8787711454E+01, 4.8475993585E+00, 9.9103849044E-01],
	[4.9510000000E+04, 6.7018054931E+01, 5.7355413143E+00, 5.8807328387E+01, 4.8478385826E+00, 9.9104247098E-01],
	[4.9515000000E+04, 6.7030249578E+01, 5.7356001896E+00, 5.8826949884E+01, 4.8480777495E+00, 9.9104644954E-01],
	[4.9520000000E+04, 6.7042445212E+01, 5.7356590596E+00, 5.8846575944E+01, 4.8483168595E+00, 9.9105042610E-01],
	[4.9525000000E+04, 6.7054641834E+01, 5.7357179243E+00, 5.8866206569E+01, 4.8485559123E+00, 9.9105440067E-01],
	[4.9530000000E+04, 6.7066839442E+01, 5.7357767836E+00, 5.8885841759E+01, 4.8487949082E+00, 9.9105837325E-01],
	[4.9535000000E+04, 6.7079038038E+01, 5.7358356376E+00, 5.8905481516E+01, 4.8490338470E+00, 9.9106234385E-01],
	[4.9540000000E+04, 6.7091237621E+01, 5.7358944863E+00, 5.8925125838E+01, 4.8492727289E+00, 9.9106631245E-01],
	[4.9545000000E+04, 6.7103438192E+01, 5.7359533296E+00, 5.8944774728E+01, 4.8495115538E+00, 9.9107027908E-01],
	[4.9550000000E+04, 6.7115639749E+01, 5.7360121676E+00, 5.8964428185E+01, 4.8497503217E+00, 9.9107424371E-01],
	[4.9555000000E+04, 6.7127842294E+01, 5.7360710002E+00, 5.8984086211E+01, 4.8499890327E+00, 9.9107820637E-01],
	[4.9560000000E+04, 6.7140045825E+01, 5.7361298276E+00, 5.9003748805E+01, 4.8502276868E+00, 9.9108216704E-01],
	[4.9565000000E+04, 6.7152250344E+01, 5.7361886496E+00, 5.9023415969E+01, 4.8504662841E+00, 9.9108612573E-01],
	[4.9570000000E+04, 6.7164455850E+01, 5.7362474662E+00, 5.9043087703E+01, 4.8507048244E+00, 9.9109008243E-01],
	[4.9575000000E+04, 6.7176662343E+01, 5.7363062775E+00, 5.9062764008E+01, 4.8509433079E+00, 9.9109403717E-01],
	[4.9580000000E+04, 6.7188869823E+01, 5.7363650835E+00, 5.9082444884E+01, 4.8511817345E+00, 9.9109798992E-01],
	[4.9585000000E+04, 6.7201078290E+01, 5.7364238842E+00, 5.9102130332E+01, 4.8514201044E+00, 9.9110194069E-01],
	[4.9590000000E+04, 6.7213287744E+01, 5.7364826796E+00, 5.9121820352E+01, 4.8516584174E+00, 9.9110588949E-01],
	[4.9595000000E+04, 6.7225498185E+01, 5.7365414696E+00, 5.9141514945E+01, 4.8518966737E+00, 9.9110983632E-01],
	[4.9600000000E+04, 6.7237709612E+01, 5.7366002543E+00, 5.9161214112E+01, 4.8521348731E+00, 9.9111378117E-01],
	[4.9605000000E+04, 6.7249922027E+01, 5.7366590337E+00, 5.9180917854E+01, 4.8523730159E+00, 9.9111772405E-01],
	[4.9610000000E+04, 6.7262135429E+01, 5.7367178077E+00, 5.9200626170E+01, 4.8526111019E+00, 9.9112166496E-01],
	[4.9615000000E+04, 6.7274349817E+01, 5.7367765765E+00, 5.9220339061E+01, 4.8528491312E+00, 9.9112560389E-01],
	[4.9620000000E+04, 6.7286565193E+01, 5.7368353399E+00, 5.9240056529E+01, 4.8530871038E+00, 9.9112954086E-01],
	[4.9625000000E+04, 6.7298781555E+01, 5.7368940980E+00, 5.9259778573E+01, 4.8533250198E+00, 9.9113347586E-01],
	[4.9630000000E+04, 6.7310998904E+01, 5.7369528507E+00, 5.9279505195E+01, 4.8535628791E+00, 9.9113740890E-01],
	[4.9635000000E+04, 6.7323217240E+01, 5.7370115982E+00, 5.9299236394E+01, 4.8538006818E+00, 9.9114133997E-01],
	[4.9640000000E+04, 6.7335436563E+01, 5.7370703403E+00, 5.9318972172E+01, 4.8540384278E+00, 9.9114526907E-01],
	[4.9645000000E+04, 6.7347656872E+01, 5.7371290772E+00, 5.9338712529E+01, 4.8542761173E+00, 9.9114919621E-01],
	[4.9650000000E+04, 6.7359878168E+01, 5.7371878087E+00, 5.9358457466E+01, 4.8545137501E+00, 9.9115312139E-01],
	[4.9655000000E+04, 6.7372100451E+01, 5.7372465349E+00, 5.9378206983E+01, 4.8547513265E+00, 9.9115704461E-01],
	[4.9660000000E+04, 6.7384323721E+01, 5.7373052558E+00, 5.9397961081E+01, 4.8549888462E+00, 9.9116096586E-01],
	[4.9665000000E+04, 6.7396547977E+01, 5.7373639713E+00, 5.9417719760E+01, 4.8552263095E+00, 9.9116488516E-01],
	[4.9670000000E+04, 6.7408773220E+01, 5.7374226816E+00, 5.9437483022E+01, 4.8554637162E+00, 9.9116880250E-01],
	[4.9675000000E+04, 6.7420999450E+01, 5.7374813866E+00, 5.9457250866E+01, 4.8557010665E+00, 9.9117271789E-01],
	[4.9680000000E+04, 6.7433226666E+01, 5.7375400862E+00, 5.9477023293E+01, 4.8559383603E+00, 9.9117663131E-01],
	[4.9685000000E+04, 6.7445454869E+01, 5.7375987805E+00, 5.9496800304E+01, 4.8561755976E+00, 9.9118054279E-01],
	[4.9690000000E+04, 6.7457684058E+01, 5.7376574696E+00, 5.9516581900E+01, 4.8564127786E+00, 9.9118445231E-01],
	[4.9695000000E+04, 6.7469914234E+01, 5.7377161533E+00, 5.9536368081E+01, 4.8566499031E+00, 9.9118835988E-01],
	[4.9700000000E+04, 6.7482145397E+01, 5.7377748317E+00, 5.9556158847E+01, 4.8568869712E+00, 9.9119226549E-01],
	[4.9705000000E+04, 6.7494377546E+01, 5.7378335049E+00, 5.9575954200E+01, 4.8571239829E+00, 9.9119616916E-01],
	[4.9710000000E+04, 6.7506610682E+01, 5.7378921727E+00, 5.9595754140E+01, 4.8573609383E+00, 9.9120007088E-01],
	[4.9715000000E+04, 6.7518844804E+01, 5.7379508352E+00, 5.9615558667E+01, 4.8575978373E+00, 9.9120397065E-01],
	[4.9720000000E+04, 6.7531079913E+01, 5.7380094924E+00, 5.9635367782E+01, 4.8578346800E+00, 9.9120786847E-01],
	[4.9725000000E+04, 6.7543316008E+01, 5.7380681443E+00, 5.9655181486E+01, 4.8580714664E+00, 9.9121176435E-01],
	[4.9730000000E+04, 6.7555553089E+01, 5.7381267910E+00, 5.9674999779E+01, 4.8583081965E+00, 9.9121565828E-01],
	[4.9735000000E+04, 6.7567791157E+01, 5.7381854323E+00, 5.9694822663E+01, 4.8585448704E+00, 9.9121955027E-01],
	[4.9740000000E+04, 6.7580030211E+01, 5.7382440683E+00, 5.9714650136E+01, 4.8587814880E+00, 9.9122344032E-01],
	[4.9745000000E+04, 6.7592270252E+01, 5.7383026991E+00, 5.9734482201E+01, 4.8590180494E+00, 9.9122732842E-01],
	[4.9750000000E+04, 6.7604511279E+01, 5.7383613245E+00, 5.9754318857E+01, 4.8592545545E+00, 9.9123121459E-01],
	[4.9755000000E+04, 6.7616753292E+01, 5.7384199447E+00, 5.9774160106E+01, 4.8594910035E+00, 9.9123509882E-01],
	[4.9760000000E+04, 6.7628996292E+01, 5.7384785595E+00, 5.9794005948E+01, 4.8597273963E+00, 9.9123898111E-01],
	[4.9765000000E+04, 6.7641240278E+01, 5.7385371691E+00, 5.9813856383E+01, 4.8599637330E+00, 9.9124286146E-01],
	[4.9770000000E+04, 6.7653485250E+01, 5.7385957734E+00, 5.9833711412E+01, 4.8602000135E+00, 9.9124673988E-01],
	[4.9775000000E+04, 6.7665731209E+01, 5.7386543723E+00, 5.9853571036E+01, 4.8604362378E+00, 9.9125061636E-01],
	[4.9780000000E+04, 6.7677978154E+01, 5.7387129660E+00, 5.9873435255E+01, 4.8606724061E+00, 9.9125449091E-01],
	[4.9785000000E+04, 6.7690226085E+01, 5.7387715545E+00, 5.9893304070E+01, 4.8609085183E+00, 9.9125836353E-01],
	[4.9790000000E+04, 6.7702475002E+01, 5.7388301376E+00, 5.9913177482E+01, 4.8611445744E+00, 9.9126223421E-01],
	[4.9795000000E+04, 6.7714724905E+01, 5.7388887154E+00, 5.9933055490E+01, 4.8613805745E+00, 9.9126610297E-01],
	[4.9800000000E+04, 6.7726975795E+01, 5.7389472880E+00, 5.9952938097E+01, 4.8616165186E+00, 9.9126996980E-01],
	[4.9805000000E+04, 6.7739227670E+01, 5.7390058553E+00, 5.9972825302E+01, 4.8618524066E+00, 9.9127383469E-01],
	[4.9810000000E+04, 6.7751480532E+01, 5.7390644173E+00, 5.9992717105E+01, 4.8620882387E+00, 9.9127769767E-01],
	[4.9815000000E+04, 6.7763734380E+01, 5.7391229740E+00, 6.0012613508E+01, 4.8623240148E+00, 9.9128155871E-01],
	[4.9820000000E+04, 6.7775989214E+01, 5.7391815254E+00, 6.0032514512E+01, 4.8625597349E+00, 9.9128541783E-01],
	[4.9825000000E+04, 6.7788245034E+01, 5.7392400716E+00, 6.0052420116E+01, 4.8627953991E+00, 9.9128927503E-01],
	[4.9830000000E+04, 6.7800501840E+01, 5.7392986124E+00, 6.0072330321E+01, 4.8630310073E+00, 9.9129313031E-01],
	[4.9835000000E+04, 6.7812759632E+01, 5.7393571480E+00, 6.0092245128E+01, 4.8632665597E+00, 9.9129698366E-01],
	[4.9840000000E+04, 6.7825018410E+01, 5.7394156784E+00, 6.0112164538E+01, 4.8635020562E+00, 9.9130083510E-01],
	[4.9845000000E+04, 6.7837278174E+01, 5.7394742034E+00, 6.0132088551E+01, 4.8637374968E+00, 9.9130468461E-01],
	[4.9850000000E+04, 6.7849538924E+01, 5.7395327232E+00, 6.0152017168E+01, 4.8639728815E+00, 9.9130853221E-01],
	[4.9855000000E+04, 6.7861800660E+01, 5.7395912377E+00, 6.0171950389E+01, 4.8642082105E+00, 9.9131237789E-01],
	[4.9860000000E+04, 6.7874074258E+01, 5.7396505548E+00, 6.0191888214E+01, 4.8644441197E+00, 9.9131622165E-01],
	[4.9865000000E+04, 6.7886360092E+01, 5.7397107020E+00, 6.0211830646E+01, 4.8646806311E+00, 9.9132006350E-01],
	[4.9870000000E+04, 6.7898646919E+01, 5.7397708438E+00, 6.0231777683E+01, 4.8649170868E+00, 9.9132390344E-01],
	[4.9875000000E+04, 6.7910934737E+01, 5.7398309802E+00, 6.0251729328E+01, 4.8651534868E+00, 9.9132774146E-01],
	[4.9880000000E+04, 6.7923223546E+01, 5.7398911112E+00, 6.0271685579E+01, 4.8653898311E+00, 9.9133157758E-01],
	[4.9885000000E+04, 6.7935513348E+01, 5.7399512368E+00, 6.0291646439E+01, 4.8656261197E+00, 9.9133541178E-01],
	[4.9890000000E+04, 6.7947804141E+01, 5.7400113571E+00, 6.0311611907E+01, 4.8658623527E+00, 9.9133924407E-01],
	[4.9895000000E+04, 6.7960095925E+01, 5.7400714719E+00, 6.0331581984E+01, 4.8660985300E+00, 9.9134307446E-01],
	[4.9900000000E+04, 6.7972388701E+01, 5.7401315813E+00, 6.0351556671E+01, 4.8663346517E+00, 9.9134690293E-01],
	[4.9905000000E+04, 6.7984682469E+01, 5.7401916853E+00, 6.0371535968E+01, 4.8665707179E+00, 9.9135072951E-01],
	[4.9910000000E+04, 6.7996977228E+01, 5.7402517840E+00, 6.0391519877E+01, 4.8668067284E+00, 9.9135455417E-01],
	[4.9915000000E+04, 6.8009272978E+01, 5.7403118772E+00, 6.0411508396E+01, 4.8670426835E+00, 9.9135837694E-01],
	[4.9920000000E+04, 6.8021569720E+01, 5.7403719651E+00, 6.0431501528E+01, 4.8672785829E+00, 9.9136219780E-01],
	[4.9925000000E+04, 6.8033867454E+01, 5.7404320476E+00, 6.0451499273E+01, 4.8675144269E+00, 9.9136601676E-01],
	[4.9930000000E+04, 6.8046166179E+01, 5.7404921246E+00, 6.0471501631E+01, 4.8677502153E+00, 9.9136983381E-01],
	[4.9935000000E+04, 6.8058465895E+01, 5.7405521963E+00, 6.0491508603E+01, 4.8679859483E+00, 9.9137364897E-01],
	[4.9940000000E+04, 6.8070766603E+01, 5.7406122626E+00, 6.0511520190E+01, 4.8682216258E+00, 9.9137746223E-01],
	[4.9945000000E+04, 6.8083068302E+01, 5.7406723236E+00, 6.0531536391E+01, 4.8684572478E+00, 9.9138127360E-01],
	[4.9950000000E+04, 6.8095370992E+01, 5.7407323791E+00, 6.0551557209E+01, 4.8686928144E+00, 9.9138508306E-01],
	[4.9955000000E+04, 6.8107674674E+01, 5.7407924293E+00, 6.0571582643E+01, 4.8689283256E+00, 9.9138889064E-01],
	[4.9960000000E+04, 6.8119979347E+01, 5.7408524740E+00, 6.0591612694E+01, 4.8691637815E+00, 9.9139269632E-01],
	[4.9965000000E+04, 6.8132285011E+01, 5.7409125134E+00, 6.0611647362E+01, 4.8693991819E+00, 9.9139650010E-01],
	[4.9970000000E+04, 6.8144591667E+01, 5.7409725474E+00, 6.0631686649E+01, 4.8696345270E+00, 9.9140030200E-01],
	[4.9975000000E+04, 6.8156899314E+01, 5.7410325761E+00, 6.0651730554E+01, 4.8698698167E+00, 9.9140410200E-01],
	[4.9980000000E+04, 6.8169207952E+01, 5.7410925993E+00, 6.0671779079E+01, 4.8701050511E+00, 9.9140790011E-01],
	[4.9985000000E+04, 6.8181517582E+01, 5.7411526172E+00, 6.0691832223E+01, 4.8703402302E+00, 9.9141169634E-01],
	[4.9990000000E+04, 6.8193828202E+01, 5.7412126297E+00, 6.0711889989E+01, 4.8705753540E+00, 9.9141549067E-01],
	[4.9995000000E+04, 6.8206139814E+01, 5.7412726368E+00, 6.0731952375E+01, 4.8708104226E+00, 9.9141928313E-01],
	[5.0000000000E+04, 6.8218452417E+01, 5.7413326386E+00, 6.0752019383E+01, 4.8710454358E+00, 9.9142307369E-01],
	[5.0005000000E+04, 6.8230766011E+01, 5.7413926350E+00, 6.0772106503E+01, 4.8712804934E+00, 9.9142686237E-01],
	[5.0010000000E+04, 6.8243080596E+01, 5.7414526260E+00, 6.0792198254E+01, 4.8715154957E+00, 9.9143064917E-01],
	[5.0015000000E+04, 6.8255396173E+01, 5.7415126116E+00, 6.0812294638E+01, 4.8717504428E+00, 9.9143443409E-01],
	[5.0020000000E+04, 6.8267712740E+01, 5.7415725919E+00, 6.0832395654E+01, 4.8719853346E+00, 9.9143821713E-01],
	[5.0025000000E+04, 6.8280030299E+01, 5.7