#### X-Ray Mass Attenuation Coefficients from NIST (https://www.nist.gov/pml/x-ray-mass-attenuation-coefficients)
# Energy in MeV, Mass Attenuation Coef, Mass Energy-Absorbition Coef
import numpy as np

# Energy [MeV], Mass Attenuation Coef (\mu / \rho) [cm^2 / g], Mass Energy-Absorbtion Coef (\mu_{en} / \rho) [cm^2 / g]

bone = np.array([[1.00000E-03,3.781E+03,3.772E+03],
                 [1.03542E-03,3.452E+03,3.444E+03],
                 [1.07210E-03,3.150E+03,3.143E+03],
                 [1.07210E-03,3.156E+03,3.149E+03],
                 [1.18283E-03,2.434E+03,2.429E+03],
                 [1.30500E-03,1.873E+03,1.869E+03],
                 [1.30500E-03,1.883E+03,1.878E+03],
                 [1.50000E-03,1.295E+03,1.291E+03],
                 [2.00000E-03,5.869E+02,5.846E+02],
                 [2.14550E-03,4.824E+02,4.803E+02],
                 [2.14550E-03,7.114E+02,6.961E+02],
                 [2.30297E-03,5.916E+02,5.789E+02],
                 [2.47200E-03,4.907E+02,4.805E+02],
                 [2.47200E-03,4.962E+02,4.857E+02],
                 [3.00000E-03,2.958E+02,2.897E+02],
                 [4.00000E-03,1.331E+02,1.303E+02],
                 [4.03810E-03,1.296E+02,1.269E+02],
                 [4.03810E-03,3.332E+02,3.006E+02],
                 [5.00000E-03,1.917E+02,1.757E+02],
                 [6.00000E-03,1.171E+02,1.085E+02],
                 [8.00000E-03,5.323E+01,4.987E+01],
                 [1.00000E-02,2.851E+01,2.680E+01],
                 [1.50000E-02,9.032E+00,8.388E+00],
                 [2.00000E-02,4.001E+00,3.601E+00],
                 [3.00000E-02,1.331E+00,1.070E+00],
                 [4.00000E-02,6.655E-01,4.507E-01],
                 [5.00000E-02,4.242E-01,2.336E-01],
                 [6.00000E-02,3.148E-01,1.400E-01],
                 [8.00000E-02,2.229E-01,6.896E-02],
                 [1.00000E-01,1.855E-01,4.585E-02],
                 [1.50000E-01,1.480E-01,3.183E-02],
                 [2.00000E-01,1.309E-01,3.003E-02],
                 [3.00000E-01,1.113E-01,3.032E-02],
                 [4.00000E-01,9.908E-02,3.069E-02],
                 [5.00000E-01,9.022E-02,3.073E-02],
                 [6.00000E-01,8.332E-02,3.052E-02],
                 [8.00000E-01,7.308E-02,2.973E-02],
                 [1.00000E+00,6.566E-02,2.875E-02],
                 [1.25000E+00,5.871E-02,2.745E-02],
                 [1.50000E+00,5.346E-02,2.623E-02],
                 [2.00000E+00,4.607E-02,2.421E-02],
                 [3.00000E+00,3.745E-02,2.145E-02],
                 [4.00000E+00,3.257E-02,1.975E-02],
                 [5.00000E+00,2.946E-02,1.864E-02],
                 [6.00000E+00,2.734E-02,1.788E-02],
                 [8.00000E+00,2.467E-02,1.695E-02],
                 [1.00000E+01,2.314E-02,1.644E-02],
                 [1.50000E+01,2.132E-02,1.587E-02],
                 [2.00000E+01,2.068E-02,1.568E-02]]) #cortical bone
softTissue = np.array([[1.00000E-03,3.712E+03,3.701E+03],
                       [1.03542E-03,3.386E+03,3.376E+03],
                       [1.07210E-03,3.087E+03,3.079E+03],
                       [1.07210E-03,3.099E+03,3.090E+03],
                       [1.50000E-03,1.251E+03,1.247E+03],
                       [2.00000E-03,5.596E+02,5.577E+02],
                       [2.14550E-03,4.583E+02,4.566E+02],
                       [2.14550E-03,4.650E+02,4.629E+02],
                       [2.30297E-03,3.800E+02,3.782E+02],
                       [2.47200E-03,3.102E+02,3.086E+02],
                       [2.47200E-03,3.158E+02,3.137E+02],
                       [2.64140E-03,2.612E+02,2.594E+02],
                       [2.82240E-03,2.158E+02,2.142E+02],
                       [2.82240E-03,2.188E+02,2.169E+02],
                       [3.00000E-03,1.836E+02,1.819E+02],
                       [3.60740E-03,1.073E+02,1.061E+02],
                       [3.60740E-03,1.105E+02,1.089E+02],
                       [4.00000E-03,8.161E+01,8.030E+01],
                       [5.00000E-03,4.224E+01,4.135E+01],
                       [6.00000E-03,2.456E+01,2.389E+01],
                       [8.00000E-03,1.042E+01,9.935E+00],
                       [1.00000E-02,5.379E+00,4.987E+00],
                       [1.50000E-02,1.699E+00,1.402E+00],
                       [2.00000E-02,8.230E-01,5.663E-01],
                       [3.00000E-02,3.790E-01,1.616E-01],
                       [4.00000E-02,2.688E-01,7.216E-02],
                       [5.00000E-02,2.264E-01,4.360E-02],
                       [6.00000E-02,2.048E-01,3.264E-02],
                       [8.00000E-02,1.823E-01,2.617E-02],
                       [1.00000E-01,1.693E-01,2.545E-02],
                       [1.50000E-01,1.492E-01,2.745E-02],
                       [2.00000E-01,1.358E-01,2.942E-02],
                       [3.00000E-01,1.175E-01,3.164E-02],
                       [4.00000E-01,1.052E-01,3.249E-02],
                       [5.00000E-01,9.598E-02,3.269E-02],
                       [6.00000E-01,8.873E-02,3.254E-02],
                       [8.00000E-01,7.793E-02,3.176E-02],
                       [1.00000E+00,7.006E-02,3.074E-02],
                       [1.25000E+00,6.265E-02,2.938E-02],
                       [1.50000E+00,5.701E-02,2.807E-02],
                       [2.00000E+00,4.895E-02,2.583E-02],
                       [3.00000E+00,3.931E-02,2.259E-02],
                       [4.00000E+00,3.369E-02,2.045E-02],
                       [5.00000E+00,3.000E-02,1.895E-02],
                       [6.00000E+00,2.741E-02,1.786E-02],
                       [8.00000E+00,2.401E-02,1.639E-02],
                       [1.00000E+01,2.193E-02,1.547E-02],
                       [1.50000E+01,1.915E-02,1.422E-02],
                       [2.00000E+01,1.787E-02,1.362E-02]]) #ICRU-44
air = np.array([[1.00000E-03,3.606E+03,3.599E+03],
                [1.50000E-03,1.191E+03,1.188E+03],
                [2.00000E-03,5.279E+02,5.262E+02],
                [3.00000E-03,1.625E+02,1.614E+02],
                [3.20290E-03,1.340E+02,1.330E+02],
                [3.20290E-03,1.485E+02,1.460E+02],
                [4.00000E-03,7.788E+01,7.636E+01],
                [5.00000E-03,4.027E+01,3.931E+01],
                [6.00000E-03,2.341E+01,2.270E+01],
                [8.00000E-03,9.921E+00,9.446E+00],
                [1.00000E-02,5.120E+00,4.742E+00],
                [1.50000E-02,1.614E+00,1.334E+00],
                [2.00000E-02,7.779E-01,5.389E-01],
                [3.00000E-02,3.538E-01,1.537E-01],
                [4.00000E-02,2.485E-01,6.833E-02],
                [5.00000E-02,2.080E-01,4.098E-02],
                [6.00000E-02,1.875E-01,3.041E-02],
                [8.00000E-02,1.662E-01,2.407E-02],
                [1.00000E-01,1.541E-01,2.325E-02],
                [1.50000E-01,1.356E-01,2.496E-02],
                [2.00000E-01,1.233E-01,2.672E-02],
                [3.00000E-01,1.067E-01,2.872E-02],
                [4.00000E-01,9.549E-02,2.949E-02],
                [5.00000E-01,8.712E-02,2.966E-02],
                [6.00000E-01,8.055E-02,2.953E-02],
                [8.00000E-01,7.074E-02,2.882E-02],
                [1.00000E+00,6.358E-02,2.789E-02],
                [1.25000E+00,5.687E-02,2.666E-02],
                [1.50000E+00,5.175E-02,2.547E-02],
                [2.00000E+00,4.447E-02,2.345E-02],
                [3.00000E+00,3.581E-02,2.057E-02],
                [4.00000E+00,3.079E-02,1.870E-02],
                [5.00000E+00,2.751E-02,1.740E-02],
                [6.00000E+00,2.522E-02,1.647E-02],
                [8.00000E+00,2.225E-02,1.525E-02],
                [1.00000E+01,2.045E-02,1.450E-02],
                [1.50000E+01,1.810E-02,1.353E-02],
                [2.00000E+01,1.705E-02,1.311E-02]]) #Air, Dry (Near Sea Level)

iron =  np.array([[1.00000E-03,9.085E+03,9.052E+03],
[1.50000E-03,3.399E+03,3.388E+03],
[2.00000E-03,1.626E+03,1.620E+03],
[3.00000E-03,5.576E+02,5.535E+02],
[4.00000E-03,2.567E+02,2.536E+02],
[5.00000E-03,1.398E+02,1.372E+02],
[6.00000E-03,8.484E+01,8.265E+01],
[7.11200E-03,5.319E+01,5.133E+01],
[7.11200E-03,4.076E+02,2.978E+02],
[8.00000E-03,3.056E+02,2.316E+02],
[1.00000E-02,1.706E+02,1.369E+02],
[1.50000E-02,5.708E+01,4.896E+01],
[2.00000E-02,2.568E+01,2.260E+01],
[3.00000E-02,8.176E+00,7.251E+00],
[4.00000E-02,3.629E+00,3.155E+00],
[5.00000E-02,1.958E+00,1.638E+00],
[6.00000E-02,1.205E+00,9.555E-01],
[8.00000E-02,5.952E-01,4.104E-01],
[1.00000E-01,3.717E-01,2.177E-01],
[1.50000E-01,1.964E-01,7.961E-02],
[2.00000E-01,1.460E-01,4.825E-02],
[3.00000E-01,1.099E-01,3.361E-02],
[4.00000E-01,9.400E-02,3.039E-02],
[5.00000E-01,8.414E-02,2.914E-02],
[6.00000E-01,7.704E-02,2.836E-02],
[8.00000E-01,6.699E-02,2.714E-02],
[1.00000E+00,5.995E-02,2.603E-02],
[1.25000E+00,5.350E-02,2.472E-02],
[1.50000E+00,4.883E-02,2.360E-02],
[2.00000E+00,4.265E-02,2.199E-02],
[3.00000E+00,3.621E-02,2.042E-02],
[4.00000E+00,3.312E-02,1.990E-02],
[5.00000E+00,3.146E-02,1.983E-02],
[6.00000E+00,3.057E-02,1.997E-02],
[8.00000E+00,2.991E-02,2.050E-02],
[1.00000E+01,2.994E-02,2.108E-02],
[1.50000E+01,3.092E-02,2.221E-02],
[2.00000E+01,3.224E-02,2.292E-02]])

lung = np.array([[1.00000E-03,3.803E+03,3.791E+03],
[1.03542E-03,3.469E+03,3.459E+03],
[1.07210E-03,3.164E+03,3.155E+03],
[1.07210E-03,3.176E+03,3.167E+03],
[1.50000E-03,1.283E+03,1.280E+03],
[2.00000E-03,5.746E+02,5.727E+02],
[2.14550E-03,4.707E+02,4.690E+02],
[2.14550E-03,4.752E+02,4.732E+02],
[2.30297E-03,3.883E+02,3.865E+02],
[2.47200E-03,3.170E+02,3.154E+02],
[2.47200E-03,3.226E+02,3.206E+02],
[2.64140E-03,2.668E+02,2.650E+02],
[2.82240E-03,2.204E+02,2.189E+02],
[2.82240E-03,2.248E+02,2.229E+02],
[3.00000E-03,1.888E+02,1.870E+02],
[3.60740E-03,1.103E+02,1.091E+02],
[3.60740E-03,1.125E+02,1.110E+02],
[4.00000E-03,8.306E+01,8.181E+01],
[5.00000E-03,4.296E+01,4.210E+01],
[6.00000E-03,2.497E+01,2.431E+01],
[8.00000E-03,1.058E+01,1.010E+01],
[1.00000E-02,5.459E+00,5.067E+00],
[1.50000E-02,1.721E+00,1.423E+00],
[2.00000E-02,8.316E-01,5.740E-01],
[3.00000E-02,3.815E-01,1.635E-01],
[4.00000E-02,2.699E-01,7.286E-02],
[5.00000E-02,2.270E-01,4.393E-02],
[6.00000E-02,2.053E-01,3.282E-02],
[8.00000E-02,1.826E-01,2.625E-02],
[1.00000E-01,1.695E-01,2.550E-02],
[1.50000E-01,1.493E-01,2.748E-02],
[2.00000E-01,1.359E-01,2.945E-02],
[3.00000E-01,1.177E-01,3.167E-02],
[4.00000E-01,1.053E-01,3.252E-02],
[5.00000E-01,9.607E-02,3.272E-02],
[6.00000E-01,8.882E-02,3.257E-02],
[8.00000E-01,7.800E-02,3.179E-02],
[1.00000E+00,7.013E-02,3.077E-02],
[1.25000E+00,6.271E-02,2.940E-02],
[1.50000E+00,5.706E-02,2.810E-02],
[2.00000E+00,4.900E-02,2.586E-02],
[3.00000E+00,3.935E-02,2.262E-02],
[4.00000E+00,3.374E-02,2.048E-02],
[5.00000E+00,3.005E-02,1.898E-02],
[6.00000E+00,2.746E-02,1.789E-02],
[8.00000E+00,2.407E-02,1.643E-02],
[1.00000E+01,2.198E-02,1.551E-02],
[1.50000E+01,1.922E-02,1.427E-02],
[2.00000E+01,1.794E-02,1.367E-02]])

titanium = np.array([[1.00000E-03,5.869E+03,5.860E+03],
[1.50000E-03,2.096E+03,2.091E+03],
[2.00000E-03,9.860E+02,9.824E+02],
[3.00000E-03,3.323E+02,3.295E+02],
[4.00000E-03,1.517E+02,1.494E+02],
[4.96640E-03,8.380E+01,8.188E+01],
[4.96640E-03,6.878E+02,5.684E+02],
[5.00000E-03,6.838E+02,5.657E+02],
[6.00000E-03,4.323E+02,3.691E+02],
[8.00000E-03,2.023E+02,1.793E+02],
[1.00000E-02,1.107E+02,1.001E+02],
[1.50000E-02,3.587E+01,3.311E+01],
[2.00000E-02,1.585E+01,1.465E+01],
[3.00000E-02,4.972E+00,4.488E+00],
[4.00000E-02,2.214E+00,1.904E+00],
[5.00000E-02,1.213E+00,9.737E-01],
[6.00000E-02,7.661E-01,5.634E-01],
[8.00000E-02,4.052E-01,2.422E-01],
[1.00000E-01,2.721E-01,1.312E-01],
[1.50000E-01,1.649E-01,5.393E-02],
[2.00000E-01,1.314E-01,3.726E-02],
[3.00000E-01,1.043E-01,3.007E-02],
[4.00000E-01,9.081E-02,2.864E-02],
[5.00000E-01,8.191E-02,2.804E-02],
[6.00000E-01,7.529E-02,2.756E-02],
[8.00000E-01,6.572E-02,2.661E-02],
[1.00000E+00,5.891E-02,2.561E-02],
[1.25000E+00,5.263E-02,2.439E-02],
[1.50000E+00,4.801E-02,2.330E-02],
[2.00000E+00,4.180E-02,2.166E-02],
[3.00000E+00,3.512E-02,1.989E-02],
[4.00000E+00,3.173E-02,1.913E-02],
[5.00000E+00,2.982E-02,1.884E-02],
[6.00000E+00,2.868E-02,1.879E-02],
[8.00000E+00,2.759E-02,1.899E-02],
[1.00000E+01,2.727E-02,1.933E-02],
[1.50000E+01,2.762E-02,2.013E-02],
[2.00000E+01,2.844E-02,2.067E-02]])

teflon = np.array([[1.00000E-03,4.823E+03,4.797E+03],
[1.50000E-03,1.672E+03,1.664E+03],
[2.00000E-03,7.601E+02,7.567E+02],
[3.00000E-03,2.411E+02,2.396E+02],
[4.00000E-03,1.045E+02,1.035E+02],
[5.00000E-03,5.409E+01,5.329E+01],
[6.00000E-03,3.142E+01,3.077E+01],
[8.00000E-03,1.327E+01,1.278E+01],
[1.00000E-02,6.805E+00,6.408E+00],
[1.50000E-02,2.088E+00,1.796E+00],
[2.00000E-02,9.667E-01,7.221E-01],
[3.00000E-02,4.025E-01,2.022E-01],
[4.00000E-02,2.647E-01,8.674E-02],
[5.00000E-02,2.132E-01,4.943E-02],
[6.00000E-02,1.880E-01,3.470E-02],
[8.00000E-02,1.632E-01,2.523E-02],
[1.00000E-01,1.500E-01,2.335E-02],
[1.50000E-01,1.310E-01,2.424E-02],
[2.00000E-01,1.189E-01,2.579E-02],
[3.00000E-01,1.027E-01,2.763E-02],
[4.00000E-01,9.187E-02,2.836E-02],
[5.00000E-01,8.380E-02,2.852E-02],
[6.00000E-01,7.747E-02,2.838E-02],
[8.00000E-01,6.803E-02,2.771E-02],
[1.00000E+00,6.115E-02,2.681E-02],
[1.25000E+00,5.469E-02,2.562E-02],
[1.50000E+00,4.979E-02,2.448E-02],
[2.00000E+00,4.280E-02,2.255E-02],
[3.00000E+00,3.456E-02,1.984E-02],
[4.00000E+00,2.981E-02,1.809E-02],
[5.00000E+00,2.674E-02,1.690E-02],
[6.00000E+00,2.460E-02,1.606E-02],
[8.00000E+00,2.185E-02,1.496E-02],
[1.00000E+01,2.020E-02,1.430E-02],
[1.50000E+01,1.811E-02,1.346E-02],
[2.00000E+01,1.722E-02,1.310E-02]])


material_coefficients = {
    "bone": bone, 
    "soft tissue": softTissue, 
    "air": air, 
    "iron": iron, 
    "lung": lung, 
    "titanium": titanium,
    "teflon": teflon,
    "bone external": bone, 
    "soft tissue external": softTissue, 
    "air external": air, 
    "iron external": iron, 
    "lung external": lung, 
    "titanium external": titanium, 
    "teflon external": teflon,
}