"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUrlIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * (experimental) The HTTP Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class HttpUrlIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct.
     * @param url the URL to proxy to.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id, url, props = {}) {
        super(id);
        this.url = url;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpUrlIntegrationProps(props);
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_) {
        var _b;
        return {
            method: (_b = this.props.method) !== null && _b !== void 0 ? _b : aws_apigatewayv2_alpha_1.HttpMethod.ANY,
            payloadFormatVersion: aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0,
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.url,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpUrlIntegration = HttpUrlIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpUrlIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", version: "2.8.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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