import matplotlib.pyplot as plt

class Visualizer2D():
    def __init__(self,x:list=[],y:list=[],title="NeuraPy Graphs",x_label="X-Axis",y_label="Y-Axis"):
        self.x=x
        self.y=y
        self.title=title
        self.x_label=x_label
        self.y_label=y_label
    def bar_graph(self):
        plt.bar(self.x,self.y)
        plt.title(self.title)
        plt.xlabel(self.x_label)
        plt.ylabel(self.y_label)
    def pie_chart(self):
        plt.pie(self.y,labels=self.x,radius=1)
        plt.title(self.title)
        plt.xlabel(self.x_label)
        plt.ylabel(self.y_label)
    def line_graph(self):
        plt.plot(self.x,self.y)
        plt.title(self.title)
        plt.xlabel(self.x_label)
        plt.ylabel(self.y_label)
    def scatter_graph(self):
        plt.scatter(self.x, self.y)
        plt.title(self.title)
        plt.xlabel(self.x_label)
        plt.ylabel(self.y_label)
    def HorizontalBar_chart(self):
        plt.barh(self.x, self.y)
        plt.title(self.title)
        plt.xlabel(self.x_label)
        plt.ylabel(self.y_label)
        
        
    def polar_graph(self):
        if len(self.x) != len(self.y):
            raise ValueError("x and y must be of the same length for polar plotting")

        plt.figure(figsize=(6, 6))
        ax = plt.subplot(111, polar=True)
        ax.plot(self.x, self.y, marker='o', linestyle='-', color='b')
        ax.fill(self.x, self.y, alpha=0.2)
        ax.set_title(self.title, va='bottom')
    
    
    
    
    def show(self):
        plt.show()


#____________________________3D Graphs_____________________________
class Visualizer3D():
    def __init__(self,x=[],y=[],z=[],title="NeuraPy 3D",x_label="X-Axis",y_label="Y-Axis",z_label="Z-Axis"):
        self.x=x
        self.y=y
        self.z=z
        self.title=title
        self.x_label=x_label
        self.y_label=y_label
        self.z_label=z_label
    def plot(self):
        fig = plt.figure()
        ax = fig.add_subplot(111, projection='3d')
        ax.plot(self.x, self.y, self.z)
        ax.set_title(self.title)
        ax.set_xlabel(self.x_label)
        ax.set_ylabel(self.y_label)
        ax.set_zlabel(self.z_label)
    
    
    
    
    def show(self):
        plt.show()