from PIL import Image
import matplotlib.pyplot as plt
import pygame
import cv2

class Media():
    def image(self,path_of_image,width,height,title="NeuraPy Image"):
        img = Image.open(path_of_image)
        img = img.resize((width, height))
        plt.imshow(img)
        plt.title(title)
        plt.axis('off')
        plt.show()
        
    def audio(self,path_of_audio):
        try:
            pygame.mixer.init()
            pygame.mixer.music.load(path_of_audio)
            pygame.mixer.music.play()
            while pygame.mixer.music.get_busy():
                pygame.time.Clock().tick(10)
        except Exception as e:
            print(f"Error playing audio: {e}")
    def video(self,path_of_video,width,height):
        cap = cv2.VideoCapture(path_of_video)
        if not cap.isOpened():
            print("Error: Cannot open video.")
            return
        
        while cap.isOpened():
            ret, frame = cap.read()
            if not ret:
                break
            frame = cv2.resize(frame, (width, height))
            cv2.imshow('Video', frame)
            
            # 'q' to quit
            if cv2.waitKey(25) & 0xFF == ord('q'):
                break
        
        cap.release()
        cv2.destroyAllWindows()
