import sqlite3

class Database():
    def create(self,path_of_db,name_of_table="Default_Table",columns=[{"name":"ID","datatype":"INT","constraint":""},{"name":"Name","datatype":"TEXT","constraint":""}]):
        conn=sqlite3.connect(fr"{path_of_db}")
        cursor=conn.cursor()
        cursor.execute(f"""
                CREATE TABLE IF NOT EXISTS {name_of_table} ({columns[0].get("name")} {columns[0].get("datatype")} {columns[0].get("constraint")});
                """)
        for i in range(1,len(columns)):
            conn.execute(f"""
                        
                        ALTER TABLE {name_of_table}
                        ADD {columns[i].get("name")} {columns[i].get("datatype")} {columns[i].get("constraint")};
                        """)
        conn.commit()
        conn.close()
    def retrieve_data(self,path_of_db,name_of_table):
        conn=sqlite3.connect(path_of_db)
        cursor=conn.cursor()
        cursor.execute(f"""
                    SELECT * FROM {name_of_table}
                    """)
        rows = cursor.fetchall()
        column_names = [description[0] for description in cursor.description]
        result = [dict(zip(column_names, row)) for row in rows]
        conn.close()
        return result
    

        
    def run_query(self,path_of_db,name_of_table,query):
        conn=sqlite3.connect(path_of_db)
        cursor=conn.cursor()
        cursor.execute(f"""
                    
                    {query.format(table=name_of_table)}
                    """)
        conn.commit()
        conn.close()
    
    
    def insert_data(self, path_of_db, name_of_table,data={"ID": [1, 2, 3, 4, 5],"Name": ["Name1", "Name2", "Name3", "Name4", "Name5"]}):
    
        conn = sqlite3.connect(path_of_db)
        cursor = conn.cursor()
        
        columns = list(data.keys())
        rows = len(data[columns[0]])  # Number of entries
        
        for j in range(rows):
            # Collect row values
            values = []
            for col in columns:
                val = data[col][j]
                if isinstance(val, str):
                    val = f'"{val}"'  # Add quotes for strings
                values.append(str(val))
            
            cursor.execute(f"""
                INSERT INTO {name_of_table} ({', '.join(columns)})
                VALUES ({', '.join(values)});
            """)
        
        conn.commit()
        conn.close()
        