from sympy import (
    symbols, sin, cos, diff, integrate, limit, sympify, Matrix,
    CoordSys3D, curl, series, summation, Function, Eq, dsolve
)
class Calculus:
    def __init__(self):
        from sympy import symbols, sin, cos

    # 1️⃣ Derivative
    def derivative(self, expr, var='x', order=1):
        x = symbols(var)
        expr = sympify(expr)
        return diff(expr, x, order)

    # 2️⃣ Integral
    def integral(self, expr, var='x', lower=None, upper=None):
        x = symbols(var)
        expr = sympify(expr)
        if lower is not None and upper is not None:
            return integrate(expr, (x, lower, upper))
        return integrate(expr, x)

    # 3️⃣ Limit
    def calc_limit(self, expr, var='x', point=0):
        x = symbols(var)
        expr = sympify(expr)
        return limit(expr, x, point)

    # 4️⃣ Partial Derivative
    def partial_derivative(self, expr, var):
        expr = sympify(expr)
        return diff(expr, symbols(var))

    # 5️⃣ Gradient
    def gradient(self, expr, vars_list):
        vars = symbols(vars_list)
        expr = sympify(expr)
        return Matrix([diff(expr, v) for v in vars])


    # 7️⃣ Curl
    def calc_curl(self, Fx, Fy, Fz):
        N = CoordSys3D('N')
        Fx, Fy, Fz = sympify(Fx), sympify(Fy), sympify(Fz)
        F = Fx * N.i + Fy * N.j + Fz * N.k
        return curl(F)

    # 8️⃣ Taylor / Maclaurin Series
    def taylor_series(self, expr, var='x', point=0, n=5):
        x = symbols(var)
        expr = sympify(expr)
        return series(expr, x, point, n)

    # 9️⃣ Summation
    def summation_func(self, expr, var='n', start=1, end=10):
        n = symbols(var)
        expr = sympify(expr)
        return summation(expr, (n, start, end))

    # 🔟 Differential Equation Solver (fixed)
    def solve_diff_eq(self, equation, var='x'):
        x = symbols(var)
        y = Function('y')
        expr = sympify(equation)  # ✅ FIXED: parse string to symbolic expression
        eq = Eq(y(x).diff(x), expr)
        return dsolve(eq)

    # 11️⃣ Jacobian Matrix
    def jacobian_matrix(self, funcs, vars_list):
        vars = symbols(vars_list)
        f = Matrix([sympify(fn) for fn in funcs])
        return f.jacobian(vars)

    # 12️⃣ Hessian Matrix
    def hessian_matrix(self, expr, vars_list):
        vars = symbols(vars_list)
        f = sympify(expr)
        return Matrix([[diff(f, vi, vj) for vj in vars] for vi in vars])
