from __future__ import annotations 
import os
import qrcode
os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'     # 0 = all logs, 1 = INFO, 2 = WARNING, 3 = ERROR
os.environ['TF_ENABLE_ONEDNN_OPTS'] = '0'
import numpy as np
import pandas as pd
from math import *
from flask import *
import numpy as np
import webbrowser
import pyttsx3
import speech_recognition as sr
import pandas as pd
import cv2
import calendar
import datetime
from docx import Document
import json
import pdfplumber
from bs4 import BeautifulSoup
import pdf2docx
import docx2pdf
import fitz
from fpdf import FPDF
import markdown
import openpyxl  # for Excel writing in pandas
import lxml       # for BeautifulSoup XML parsing
import warnings
warnings.filterwarnings("ignore", category=UserWarning)
from .Adv_MAths import *
from .ai import *
from .assembly import *
from .calculus import *
from .chemistry import *
from .complex_number import *
from .database import *
from .encoding_decoding import *
from .encryption import *
from .ftp import *
from .gui import *
from .machine_learning import *
from .matrices import *
from .media import *
from .neural_network import *
from .number_system import *
from .os_module import *
from .physics import *
from .quantum import *
from .sensors import *
from .stats import *
from .vectors import *
from .visualizers import *
from .web_server import *
from .web_scrapper import *


#__________________________Web searches___________________________

def search_chrome(thing):
    webbrowser.open(rf"https://www.google.com/search?q={thing}")
def search_youtube(thing):
    webbrowser.open(fr"https://www.youtube.com/results?search_query={thing}")
def open_whatsapp():
    webbrowser.open("https://wa.me/")
def open_whatsapp_chat(phone_number:str,message:str="Hi"):
    webbrowser.open(fr"https://wa.me/{phone_number}?text={message}")
def open_other(link):
    webbrowser.open(f"https://www.google.com/search?q={link}")

#________________________Graph Plot_______________________________

#_______________________Speech____________________________________
def speak(text="Hi I am Neura Python"):
    engine=pyttsx3.init()
    engine.say(text)
    engine.runAndWait()
    engine.stop()
    
    
def voice_input(message="Please say Something: "):
    r = sr.Recognizer()

    
    with sr.Microphone() as source:
        print(message)
        r.adjust_for_ambient_noise(source) 
        audio = r.listen(source)

    try:
        
        text = r.recognize_google(audio)
        return text
    except sr.UnknownValueError:
        print("Sorry, could not understand your voice.")
    except sr.RequestError:
        print("Could not request results; check your internet connection.")





    
#_____________________________Databases_______________________________

#________________________________Media_____________________________________





#________________________________Machine Learning_________________________

#__________________________________AI_________________________________________


#___________________________________Vectors______________________________________



#_____________________________Calender_________________________________
def Calender(year=None, month=None):
    now = datetime.datetime.now()
    if year is None:
        year = now.year
    if month is None:
        month = now.month
    cal = calendar.month(year, month)
    print(cal)


#_________________________Readers_____________________________________
class Reader():
    def html_reader(self,path):
        with open(rf"{path}","r",encoding="utf-8") as html:
            content=html.read()
        return content
    
    def excel_reader(self,path):
        data=pd.read_excel(rf"{path}")
        return data.to_string()
    
    def docx_reader(self,path):
        doc = Document(path)
        text = "\n".join([para.text for para in doc.paragraphs])
        return text
    
    def json_reader(self,path):
        with open(path, 'r', encoding='utf-8') as file:
            data = json.load(file)  
        return data
    
    def csv_reader(self,path):
        data=pd.read_csv(rf"{path}")
        return data.to_string()
    
    def text_reader(self,path):
        with open(path, 'r', encoding='utf-8') as file:
            content = file.read()  
        return content
    
    def pdf_reader(self,path):
        text = ""
        with pdfplumber.open(path) as pdf:
            for page in pdf.pages:
                text += page.extract_text() + "\n"
        return text
    def markdown_reader(self,path):
        with open(path, 'r', encoding='utf-8') as file:
            content = file.read()  # Read as plain text
        return content
    def xml_reader(self,path):
        with open(path, 'r', encoding='utf-8') as file:
            content = file.read()
        soup = BeautifulSoup(content, 'xml')
        return soup.prettify()
#___________________________Converters_____________________________
class Converter():
    def pdf_to_docx(self,pdf_path,docx_path):
        cv = pdf2docx.Converter(pdf_path)
        cv.convert(docx_path, start=0, end=None)
        cv.close()
    
    def docx_to_pdf(self,docx_path,pdf_path):
        docx2pdf.convert(docx_path, pdf_path)

    def pdf_to_text(self,pdf_path,txt_path):
        pdf = fitz.open(pdf_path)
        text = ""

        for page in pdf:
            text += page.get_text("text") + "\n"

        pdf.close()

        if txt_path:
            with open(txt_path, "w", encoding="utf-8") as f:
                f.write(text)
    
    def text_to_pdf(self,txt_path,pdf_path):
        pdf = FPDF()
        pdf.set_auto_page_break(auto=True, margin=15)
        pdf.add_page()
        pdf.set_font("Arial", size=12)

        with open(txt_path, "r", encoding="utf-8") as f:
            text = f.read()

        pdf.multi_cell(0, 10, text)
        pdf.output(pdf_path)
        
    def excel_to_csv(self,excel_path,csv_path):
        df = pd.read_excel(excel_path)
        df.to_csv(csv_path, index=False)
        
    def csv_to_excel(self,csv_path,xlsx_path):
        df = pd.read_csv(csv_path)
        df.to_excel(xlsx_path, index=False, engine='openpyxl')
        
    def json_to_csv(self,json_path,csv_path):
        df = pd.read_json(json_path)
        df.to_csv(csv_path, index=False)
        
    def json_to_excel(self,json_path,excel_path):
        data = pd.read_json(json_path)
        data.to_excel(excel_path, index=False)
        
    def csv_to_json(self,csv_path,json_path):
        data = pd.read_csv(csv_path)
        data.to_json(json_path, orient="records", indent=4)
        
    def excel_to_json(self,excel_path,json_path):
        data = pd.read_excel(excel_path)
        data.to_json(json_path, orient="records", indent=4)
    def markdown_to_html(self,markdown_path,html_path):
        with open(markdown_path, "r", encoding="utf-8") as md_file:
            md_content = md_file.read()

        html_content = markdown.markdown(md_content, extensions=[
        "fenced_code",  # ``` code blocks ```
        "tables",       # Markdown tables
        "attr_list"     # Attributes like {: .class }
        ])

        html_template = f"""<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{markdown_path}</title>
    <style>
        body {{
            font-family: Arial, sans-serif;
            margin: 40px;
            line-height: 1.6;
            background-color: #fafafa;
        }}
        pre, code {{
            background: #f5f5f5;
            padding: 5px;
            border-radius: 4px;
        }}
        table {{
            border-collapse: collapse;
            margin-top: 10px;
        }}
        th, td {{
            border: 1px solid #ccc;
            padding: 8px;
        }}
    </style>
</head>
<body>
{html_content}
</body>
</html>"""

        with open(html_path, "w", encoding="utf-8") as html_file:
            html_file.write(html_template)
            
            
            
            
    def string_to_pdf(self, text: str, pdf_path: str, font="Arial", size=12):
        """
        Create a PDF from a string.
        """
        pdf = FPDF()
        pdf.set_auto_page_break(auto=True, margin=15)
        pdf.add_page()
        pdf.set_font(font, size=size)
        pdf.multi_cell(0, 10, text)
        pdf.output(pdf_path)

    # 🔹 NEW METHOD 2: Convert string directly to DOCX
    def string_to_docx(self, text: str, docx_path: str, title: str = None):
        """
        Create a DOCX file from a string.
        """
        doc = Document()
        if title:
            doc.add_heading(title, level=1)
        doc.add_paragraph(text)
        doc.save(docx_path)


class QR_Code:
    @staticmethod
    def generator(data, file_path="qrcode.png", box_size=10, border=4):
        """
        Generate a QR code image from the given data.
        """
        qr = qrcode.QRCode(
            version=1,
            error_correction=qrcode.constants.ERROR_CORRECT_L,
            box_size=box_size,
            border=border,
        )
        qr.add_data(data)
        qr.make(fit=True)
        img = qr.make_image(fill_color="black", back_color="white")
        img.save(file_path)
        return f"QR code saved as {file_path}"

    @staticmethod
    def reader(file_path):
        """
        Read and decode a QR code from an image.
        """
        img = cv2.imread(file_path)
        detector = cv2.QRCodeDetector()
        data, points, _ = detector.detectAndDecode(img)
        if data:
            return f"Decoded data: {data}"
        else:
            return "No QR code detected or unable to decode."
        



#________________________Translator_____________________________
import asyncio
from googletrans import Translator as GoogleTranslator, LANGUAGES

class Translator:
    def __init__(self):
        self.translator = GoogleTranslator()

    async def _translate_async(self, input_text, output_language):
        # Detect language
        detected = await self.translator.detect(input_text)
        detected_lang_code = detected.lang
        detected_lang_name = LANGUAGES.get(detected_lang_code, "Unknown").capitalize()

        # Find target language code
        output_lang_code = None
        for code, name in LANGUAGES.items():
            if name.lower() == output_language.lower():
                output_lang_code = code
                break
        if not output_lang_code:
            return {"Error": f"Output language '{output_language}' not supported."}

        # Translate text
        translation = await self.translator.translate(input_text, src=detected_lang_code, dest=output_lang_code)
        return {
            "Detected Language": detected_lang_name,
            "Target Language": output_language.capitalize(),
            "Input Text": input_text,
            "Translated Text": translation.text
        }

    def translate(self, input_text="Hello", output_language="Urdu"):
        """
        Synchronous wrapper for users.
        They can call this normally without async knowledge.
        """
        try:
            loop = asyncio.get_running_loop()
            return loop.run_until_complete(self._translate_async(input_text, output_language))
        except RuntimeError:
            return asyncio.run(self._translate_async(input_text, output_language))
