import math
import statistics as stats
import random

class Advanced_Maths:
    def __init__(self):
        print("🧮 Advanced_Maths initialized — arithmetic, algebra, and statistics toolkit.")

# -----------------------------------------------------------
# 🔢 BASIC ARITHMETIC (MULTIPLE ARGUMENTS)
# -----------------------------------------------------------
    def add(self, *args):
        """Add all numbers together."""
        return sum(args)

    def subtract(self, *args):
        """Subtract all numbers in sequence."""
        if len(args) < 2:
            raise ValueError("Need at least two numbers to subtract.")
        result = args[0]
        for num in args[1:]:
            result -= num
        return result

    def multiply(self, *args):
        """Multiply all numbers together."""
        result = 1
        for num in args:
            result *= num
        return result

    def divide(self, *args):
        """Divide numbers in sequence (a / b / c / ...)."""
        if len(args) < 2:
            raise ValueError("Need at least two numbers to divide.")
        result = args[0]
        for num in args[1:]:
            if num == 0:
                raise ZeroDivisionError("Cannot divide by zero.")
            result /= num
        return result

    def power(self, base, exponent): return base ** exponent
    def sqrt(self, x): return math.sqrt(x)
    def mod(self, a, b): return a % b

# -----------------------------------------------------------
# 🔣 NUMBER THEORY
# -----------------------------------------------------------
    def factorial(self, n): return math.factorial(n)
    def combination(self, n, r): return math.comb(n, r)
    def permutation(self, n, r): return math.perm(n, r)
    def gcd(self, a, b): return math.gcd(a, b)
    def lcm(self, a, b): return math.lcm(a, b)
    def is_prime(self, n):
        if n < 2: return False
        for i in range(2, int(n ** 0.5) + 1):
            if n % i == 0:
                return False
        return True

# -----------------------------------------------------------
# 📊 STATISTICS
# -----------------------------------------------------------
    def mean(self, data): return stats.mean(data)
    def median(self, data): return stats.median(data)
    def mode(self, data): return stats.mode(data)
    def variance(self, data): return stats.variance(data)
    def stdev(self, data): return stats.stdev(data)
    def data_range(self, data): return max(data) - min(data)

# -----------------------------------------------------------
# 🎲 PROBABILITY & RANDOM
# -----------------------------------------------------------
    def random_choice(self, data): return random.choice(data)
    def random_sample(self, data, k): return random.sample(data, k)
    def random_int(self, a, b): return random.randint(a, b)
    def random_float(self, a=0.0, b=1.0): return random.uniform(a, b)
    def probability(self, favorable, total):
        return favorable / total if total > 0 else 0

# -----------------------------------------------------------
# 🔢 SEQUENCES AND SERIES
# -----------------------------------------------------------
    def arithmetic_series(self, a1, d, n):
        """Sum of arithmetic progression."""
        return n / 2 * (2 * a1 + (n - 1) * d)

    def geometric_series(self, a1, r, n):
        """Sum of geometric progression."""
        if r == 1:
            return a1 * n
        return a1 * (1 - r ** n) / (1 - r)

# -----------------------------------------------------------
# 📏 CONVERSIONS & MISC
# -----------------------------------------------------------
    def deg_to_rad(self, deg): return math.radians(deg)
    def rad_to_deg(self, rad): return math.degrees(rad)
    def absolute(self, x): return abs(x)