# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AddTagsToResourceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class AddTagsToResourceRequest(TeaModel):
    def __init__(
        self,
        tag: List[AddTagsToResourceRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        proxy_id: str = None,
        region_id: str = None,
        dbinstance_id: str = None,
        tags: str = None,
        owner_account: str = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.proxy_id = proxy_id
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.tags = tags
        self.owner_account = owner_account

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsToResourceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class AddTagsToResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagsToResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddTagsToResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddTagsToResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateInstancePublicConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        connection_string_prefix: str = None,
        port: str = None,
        owner_account: str = None,
        general_group_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.connection_string_prefix = connection_string_prefix
        self.port = port
        self.owner_account = owner_account
        self.general_group_name = general_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.port is not None:
            result['Port'] = self.port
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        return self


class AllocateInstancePublicConnectionResponseBody(TeaModel):
    def __init__(
        self,
        db_instance_name: str = None,
        request_id: str = None,
        connection_string: str = None,
    ):
        self.db_instance_name = db_instance_name
        self.request_id = request_id
        self.connection_string = connection_string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_name is not None:
            result['DbInstanceName'] = self.db_instance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbInstanceName') is not None:
            self.db_instance_name = m.get('DbInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        return self


class AllocateInstancePublicConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateInstancePublicConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateInstancePublicConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateReadWriteSplittingConnectionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        connection_string_prefix: str = None,
        port: str = None,
        max_delay_time: str = None,
        net_type: str = None,
        distribution_type: str = None,
        weight: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.connection_string_prefix = connection_string_prefix
        self.port = port
        self.max_delay_time = max_delay_time
        self.net_type = net_type
        self.distribution_type = distribution_type
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.port is not None:
            result['Port'] = self.port
        if self.max_delay_time is not None:
            result['MaxDelayTime'] = self.max_delay_time
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.distribution_type is not None:
            result['DistributionType'] = self.distribution_type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('MaxDelayTime') is not None:
            self.max_delay_time = m.get('MaxDelayTime')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('DistributionType') is not None:
            self.distribution_type = m.get('DistributionType')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AllocateReadWriteSplittingConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateReadWriteSplittingConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AllocateReadWriteSplittingConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AllocateReadWriteSplittingConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CalculateDBInstanceWeightRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight(TeaModel):
    def __init__(
        self,
        readonly_instance_sqldelayed_time: str = None,
        weight: str = None,
        dbinstance_type: str = None,
        dbinstance_id: str = None,
        role: str = None,
    ):
        self.readonly_instance_sqldelayed_time = readonly_instance_sqldelayed_time
        self.weight = weight
        self.dbinstance_type = dbinstance_type
        self.dbinstance_id = dbinstance_id
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.readonly_instance_sqldelayed_time is not None:
            result['ReadonlyInstanceSQLDelayedTime'] = self.readonly_instance_sqldelayed_time
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReadonlyInstanceSQLDelayedTime') is not None:
            self.readonly_instance_sqldelayed_time = m.get('ReadonlyInstanceSQLDelayedTime')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class CalculateDBInstanceWeightResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_weight: List[CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight] = None,
    ):
        self.dbinstance_weight = dbinstance_weight

    def validate(self):
        if self.dbinstance_weight:
            for k in self.dbinstance_weight:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceWeight'] = []
        if self.dbinstance_weight is not None:
            for k in self.dbinstance_weight:
                result['DBInstanceWeight'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_weight = []
        if m.get('DBInstanceWeight') is not None:
            for k in m.get('DBInstanceWeight'):
                temp_model = CalculateDBInstanceWeightResponseBodyItemsDBInstanceWeight()
                self.dbinstance_weight.append(temp_model.from_map(k))
        return self


class CalculateDBInstanceWeightResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        items: CalculateDBInstanceWeightResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = CalculateDBInstanceWeightResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class CalculateDBInstanceWeightResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CalculateDBInstanceWeightResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CalculateDBInstanceWeightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelImportRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        import_id: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.import_id = import_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CancelImportResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelImportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelImportResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelImportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckAccountNameAvailableRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        account_name: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.account_name = account_name
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CheckAccountNameAvailableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckAccountNameAvailableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckAccountNameAvailableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckAccountNameAvailableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckCloudResourceAuthorizedRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dbinstance_id: str = None,
        target_region_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.target_region_id = target_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        return self


class CheckCloudResourceAuthorizedResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        role_arn: str = None,
        authorization_state: int = None,
    ):
        self.request_id = request_id
        self.role_arn = role_arn
        self.authorization_state = authorization_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.authorization_state is not None:
            result['AuthorizationState'] = self.authorization_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('AuthorizationState') is not None:
            self.authorization_state = m.get('AuthorizationState')
        return self


class CheckCloudResourceAuthorizedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckCloudResourceAuthorizedResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckCloudResourceAuthorizedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckCreateDdrDBInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        engine: str = None,
        engine_version: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        restore_type: str = None,
        backup_set_id: str = None,
        restore_time: str = None,
        source_region: str = None,
        source_dbinstance_name: str = None,
        binlog_name: str = None,
        binlog_position: str = None,
        binlog_role: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.engine = engine
        self.engine_version = engine_version
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.restore_type = restore_type
        self.backup_set_id = backup_set_id
        self.restore_time = restore_time
        self.source_region = source_region
        self.source_dbinstance_name = source_dbinstance_name
        self.binlog_name = binlog_name
        self.binlog_position = binlog_position
        self.binlog_role = binlog_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_dbinstance_name is not None:
            result['SourceDBInstanceName'] = self.source_dbinstance_name
        if self.binlog_name is not None:
            result['BinlogName'] = self.binlog_name
        if self.binlog_position is not None:
            result['BinlogPosition'] = self.binlog_position
        if self.binlog_role is not None:
            result['BinlogRole'] = self.binlog_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceDBInstanceName') is not None:
            self.source_dbinstance_name = m.get('SourceDBInstanceName')
        if m.get('BinlogName') is not None:
            self.binlog_name = m.get('BinlogName')
        if m.get('BinlogPosition') is not None:
            self.binlog_position = m.get('BinlogPosition')
        if m.get('BinlogRole') is not None:
            self.binlog_role = m.get('BinlogRole')
        return self


class CheckCreateDdrDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        is_valid: str = None,
        request_id: str = None,
    ):
        self.is_valid = is_valid
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_valid is not None:
            result['IsValid'] = self.is_valid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsValid') is not None:
            self.is_valid = m.get('IsValid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckCreateDdrDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckCreateDdrDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckCreateDdrDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckDBNameAvailableRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        dbname: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CheckDBNameAvailableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckDBNameAvailableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckDBNameAvailableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckDBNameAvailableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckInstanceExistRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class CheckInstanceExistResponseBody(TeaModel):
    def __init__(
        self,
        is_exist_instance: bool = None,
        request_id: str = None,
    ):
        self.is_exist_instance = is_exist_instance
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_exist_instance is not None:
            result['IsExistInstance'] = self.is_exist_instance
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsExistInstance') is not None:
            self.is_exist_instance = m.get('IsExistInstance')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckInstanceExistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckInstanceExistResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckInstanceExistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearDedicatedHostRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dedicated_host_id: str = None,
        failover_mode: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id
        self.failover_mode = failover_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.failover_mode is not None:
            result['FailoverMode'] = self.failover_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('FailoverMode') is not None:
            self.failover_mode = m.get('FailoverMode')
        return self


class ClearDedicatedHostResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_host_id: str = None,
        task_id: str = None,
        request_id: str = None,
    ):
        self.dedicated_host_id = dedicated_host_id
        self.task_id = task_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClearDedicatedHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ClearDedicatedHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearDedicatedHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneDBInstanceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        zone_id: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        db_names: str = None,
        pay_type: str = None,
        instance_network_type: str = None,
        dbinstance_id: str = None,
        backup_id: str = None,
        restore_time: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        private_ip_address: str = None,
        used_time: int = None,
        period: str = None,
        category: str = None,
        dbinstance_storage_type: str = None,
        restore_table: str = None,
        table_meta: str = None,
        dedicated_host_group_id: str = None,
        backup_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.db_names = db_names
        self.pay_type = pay_type
        self.instance_network_type = instance_network_type
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.restore_time = restore_time
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id
        self.private_ip_address = private_ip_address
        self.used_time = used_time
        self.period = period
        self.category = category
        self.dbinstance_storage_type = dbinstance_storage_type
        self.restore_table = restore_table
        self.table_meta = table_meta
        self.dedicated_host_group_id = dedicated_host_group_id
        self.backup_type = backup_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.period is not None:
            result['Period'] = self.period
        if self.category is not None:
            result['Category'] = self.category
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.restore_table is not None:
            result['RestoreTable'] = self.restore_table
        if self.table_meta is not None:
            result['TableMeta'] = self.table_meta
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('RestoreTable') is not None:
            self.restore_table = m.get('RestoreTable')
        if m.get('TableMeta') is not None:
            self.table_meta = m.get('TableMeta')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        return self


class CloneDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        order_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CloneDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneParameterGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        target_region_id: str = None,
        parameter_group_id: str = None,
        parameter_group_name: str = None,
        parameter_group_desc: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.target_region_id = target_region_id
        self.parameter_group_id = parameter_group_id
        self.parameter_group_name = parameter_group_name
        self.parameter_group_desc = parameter_group_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        return self


class CloneParameterGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneParameterGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneParameterGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyDatabaseRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CopyDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        dbname: str = None,
        task_id: str = None,
        dbstatus: str = None,
    ):
        self.dbname = dbname
        self.task_id = task_id
        self.dbstatus = dbstatus

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.dbstatus is not None:
            result['DBStatus'] = self.dbstatus
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('DBStatus') is not None:
            self.dbstatus = m.get('DBStatus')
        return self


class CopyDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyDatabaseBetweenInstancesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        target_dbinstance_id: str = None,
        db_names: str = None,
        backup_id: str = None,
        restore_time: str = None,
        sync_user_privilege: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.target_dbinstance_id = target_dbinstance_id
        self.db_names = db_names
        self.backup_id = backup_id
        self.restore_time = restore_time
        self.sync_user_privilege = sync_user_privilege

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.target_dbinstance_id is not None:
            result['TargetDBInstanceId'] = self.target_dbinstance_id
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.sync_user_privilege is not None:
            result['SyncUserPrivilege'] = self.sync_user_privilege
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('TargetDBInstanceId') is not None:
            self.target_dbinstance_id = m.get('TargetDBInstanceId')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('SyncUserPrivilege') is not None:
            self.sync_user_privilege = m.get('SyncUserPrivilege')
        return self


class CopyDatabaseBetweenInstancesResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyDatabaseBetweenInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyDatabaseBetweenInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyDatabaseBetweenInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAccountRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        account_name: str = None,
        account_password: str = None,
        account_description: str = None,
        account_type: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.account_name = account_name
        self.account_password = account_password
        self.account_description = account_description
        self.account_type = account_type
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAccountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
        backup_strategy: str = None,
        backup_method: str = None,
        backup_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.backup_strategy = backup_strategy
        self.backup_method = backup_method
        self.backup_type = backup_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_strategy is not None:
            result['BackupStrategy'] = self.backup_strategy
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupStrategy') is not None:
            self.backup_strategy = m.get('BackupStrategy')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        return self


class CreateBackupResponseBody(TeaModel):
    def __init__(
        self,
        backup_job_id: str = None,
        request_id: str = None,
    ):
        self.backup_job_id = backup_job_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBackupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDatabaseRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
        character_set_name: str = None,
        dbdescription: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.character_set_name = character_set_name
        self.dbdescription = dbdescription
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.character_set_name is not None:
            result['CharacterSetName'] = self.character_set_name
        if self.dbdescription is not None:
            result['DBDescription'] = self.dbdescription
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('CharacterSetName') is not None:
            self.character_set_name = m.get('CharacterSetName')
        if m.get('DBDescription') is not None:
            self.dbdescription = m.get('DBDescription')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBInstanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDBInstanceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        engine: str = None,
        engine_version: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        system_dbcharset: str = None,
        dbinstance_net_type: str = None,
        dbinstance_description: str = None,
        security_iplist: str = None,
        client_token: str = None,
        pay_type: str = None,
        zone_id: str = None,
        zone_id_slave_1: str = None,
        zone_id_slave_2: str = None,
        instance_network_type: str = None,
        connection_mode: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        private_ip_address: str = None,
        used_time: str = None,
        period: str = None,
        resource_group_id: str = None,
        dbinstance_storage_type: str = None,
        business_info: str = None,
        encryption_key: str = None,
        role_arn: str = None,
        auto_renew: str = None,
        category: str = None,
        dedicated_host_group_id: str = None,
        target_dedicated_host_id_for_master: str = None,
        target_dedicated_host_id_for_slave: str = None,
        target_dedicated_host_id_for_log: str = None,
        dbparam_group_id: str = None,
        dbtime_zone: str = None,
        dbis_ignore_case: str = None,
        target_minor_version: str = None,
        storage_auto_scale: str = None,
        storage_threshold: int = None,
        storage_upper_bound: int = None,
        dry_run: bool = None,
        user_backup_id: str = None,
        amount: int = None,
        create_strategy: str = None,
        tag: List[CreateDBInstanceRequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.engine = engine
        self.engine_version = engine_version
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.system_dbcharset = system_dbcharset
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_description = dbinstance_description
        self.security_iplist = security_iplist
        self.client_token = client_token
        self.pay_type = pay_type
        self.zone_id = zone_id
        self.zone_id_slave_1 = zone_id_slave_1
        self.zone_id_slave_2 = zone_id_slave_2
        self.instance_network_type = instance_network_type
        self.connection_mode = connection_mode
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id
        self.private_ip_address = private_ip_address
        self.used_time = used_time
        self.period = period
        self.resource_group_id = resource_group_id
        self.dbinstance_storage_type = dbinstance_storage_type
        self.business_info = business_info
        self.encryption_key = encryption_key
        self.role_arn = role_arn
        self.auto_renew = auto_renew
        self.category = category
        self.dedicated_host_group_id = dedicated_host_group_id
        self.target_dedicated_host_id_for_master = target_dedicated_host_id_for_master
        self.target_dedicated_host_id_for_slave = target_dedicated_host_id_for_slave
        self.target_dedicated_host_id_for_log = target_dedicated_host_id_for_log
        self.dbparam_group_id = dbparam_group_id
        self.dbtime_zone = dbtime_zone
        self.dbis_ignore_case = dbis_ignore_case
        self.target_minor_version = target_minor_version
        self.storage_auto_scale = storage_auto_scale
        self.storage_threshold = storage_threshold
        self.storage_upper_bound = storage_upper_bound
        self.dry_run = dry_run
        self.user_backup_id = user_backup_id
        self.amount = amount
        self.create_strategy = create_strategy
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.system_dbcharset is not None:
            result['SystemDBCharset'] = self.system_dbcharset
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_id_slave_1 is not None:
            result['ZoneIdSlave1'] = self.zone_id_slave_1
        if self.zone_id_slave_2 is not None:
            result['ZoneIdSlave2'] = self.zone_id_slave_2
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.period is not None:
            result['Period'] = self.period
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.role_arn is not None:
            result['RoleARN'] = self.role_arn
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.category is not None:
            result['Category'] = self.category
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.target_dedicated_host_id_for_master is not None:
            result['TargetDedicatedHostIdForMaster'] = self.target_dedicated_host_id_for_master
        if self.target_dedicated_host_id_for_slave is not None:
            result['TargetDedicatedHostIdForSlave'] = self.target_dedicated_host_id_for_slave
        if self.target_dedicated_host_id_for_log is not None:
            result['TargetDedicatedHostIdForLog'] = self.target_dedicated_host_id_for_log
        if self.dbparam_group_id is not None:
            result['DBParamGroupId'] = self.dbparam_group_id
        if self.dbtime_zone is not None:
            result['DBTimeZone'] = self.dbtime_zone
        if self.dbis_ignore_case is not None:
            result['DBIsIgnoreCase'] = self.dbis_ignore_case
        if self.target_minor_version is not None:
            result['TargetMinorVersion'] = self.target_minor_version
        if self.storage_auto_scale is not None:
            result['StorageAutoScale'] = self.storage_auto_scale
        if self.storage_threshold is not None:
            result['StorageThreshold'] = self.storage_threshold
        if self.storage_upper_bound is not None:
            result['StorageUpperBound'] = self.storage_upper_bound
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.user_backup_id is not None:
            result['UserBackupId'] = self.user_backup_id
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.create_strategy is not None:
            result['CreateStrategy'] = self.create_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('SystemDBCharset') is not None:
            self.system_dbcharset = m.get('SystemDBCharset')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneIdSlave1') is not None:
            self.zone_id_slave_1 = m.get('ZoneIdSlave1')
        if m.get('ZoneIdSlave2') is not None:
            self.zone_id_slave_2 = m.get('ZoneIdSlave2')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('RoleARN') is not None:
            self.role_arn = m.get('RoleARN')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('TargetDedicatedHostIdForMaster') is not None:
            self.target_dedicated_host_id_for_master = m.get('TargetDedicatedHostIdForMaster')
        if m.get('TargetDedicatedHostIdForSlave') is not None:
            self.target_dedicated_host_id_for_slave = m.get('TargetDedicatedHostIdForSlave')
        if m.get('TargetDedicatedHostIdForLog') is not None:
            self.target_dedicated_host_id_for_log = m.get('TargetDedicatedHostIdForLog')
        if m.get('DBParamGroupId') is not None:
            self.dbparam_group_id = m.get('DBParamGroupId')
        if m.get('DBTimeZone') is not None:
            self.dbtime_zone = m.get('DBTimeZone')
        if m.get('DBIsIgnoreCase') is not None:
            self.dbis_ignore_case = m.get('DBIsIgnoreCase')
        if m.get('TargetMinorVersion') is not None:
            self.target_minor_version = m.get('TargetMinorVersion')
        if m.get('StorageAutoScale') is not None:
            self.storage_auto_scale = m.get('StorageAutoScale')
        if m.get('StorageThreshold') is not None:
            self.storage_threshold = m.get('StorageThreshold')
        if m.get('StorageUpperBound') is not None:
            self.storage_upper_bound = m.get('StorageUpperBound')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('UserBackupId') is not None:
            self.user_backup_id = m.get('UserBackupId')
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('CreateStrategy') is not None:
            self.create_strategy = m.get('CreateStrategy')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDBInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        dry_run_result: bool = None,
        tag_result: bool = None,
        request_id: str = None,
        connection_string: str = None,
        message: str = None,
        dbinstance_id: str = None,
        port: str = None,
        task_id: str = None,
        dry_run: bool = None,
        order_id: str = None,
    ):
        self.dry_run_result = dry_run_result
        self.tag_result = tag_result
        self.request_id = request_id
        self.connection_string = connection_string
        self.message = message
        self.dbinstance_id = dbinstance_id
        self.port = port
        self.task_id = task_id
        self.dry_run = dry_run
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run_result is not None:
            result['DryRunResult'] = self.dry_run_result
        if self.tag_result is not None:
            result['TagResult'] = self.tag_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.message is not None:
            result['Message'] = self.message
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.port is not None:
            result['Port'] = self.port
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DryRunResult') is not None:
            self.dry_run_result = m.get('DryRunResult')
        if m.get('TagResult') is not None:
            self.tag_result = m.get('TagResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDBProxyEndpointAddressRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        dbinstance_id: str = None,
        dbproxy_endpoint_id: str = None,
        connection_string_prefix: str = None,
        dbproxy_new_connect_string_port: str = None,
        dbproxy_connect_string_net_type: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
    ):
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.dbproxy_endpoint_id = dbproxy_endpoint_id
        self.connection_string_prefix = connection_string_prefix
        self.dbproxy_new_connect_string_port = dbproxy_new_connect_string_port
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.connection_string_prefix is not None:
            result['ConnectionStringPrefix'] = self.connection_string_prefix
        if self.dbproxy_new_connect_string_port is not None:
            result['DBProxyNewConnectStringPort'] = self.dbproxy_new_connect_string_port
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('ConnectionStringPrefix') is not None:
            self.connection_string_prefix = m.get('ConnectionStringPrefix')
        if m.get('DBProxyNewConnectStringPort') is not None:
            self.dbproxy_new_connect_string_port = m.get('DBProxyNewConnectStringPort')
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateDBProxyEndpointAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDBProxyEndpointAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDBProxyEndpointAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDBProxyEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDdrInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        engine: str = None,
        engine_version: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        system_dbcharset: str = None,
        dbinstance_net_type: str = None,
        dbinstance_description: str = None,
        security_iplist: str = None,
        client_token: str = None,
        pay_type: str = None,
        zone_id: str = None,
        instance_network_type: str = None,
        connection_mode: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        private_ip_address: str = None,
        owner_account: str = None,
        used_time: str = None,
        period: str = None,
        resource_group_id: str = None,
        restore_type: str = None,
        backup_set_id: str = None,
        restore_time: str = None,
        source_region: str = None,
        source_dbinstance_name: str = None,
        dbinstance_storage_type: str = None,
        binlog_name: str = None,
        binlog_position: str = None,
        binlog_role: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.engine = engine
        self.engine_version = engine_version
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.system_dbcharset = system_dbcharset
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_description = dbinstance_description
        self.security_iplist = security_iplist
        self.client_token = client_token
        self.pay_type = pay_type
        self.zone_id = zone_id
        self.instance_network_type = instance_network_type
        self.connection_mode = connection_mode
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id
        self.private_ip_address = private_ip_address
        self.owner_account = owner_account
        self.used_time = used_time
        self.period = period
        self.resource_group_id = resource_group_id
        self.restore_type = restore_type
        self.backup_set_id = backup_set_id
        self.restore_time = restore_time
        self.source_region = source_region
        self.source_dbinstance_name = source_dbinstance_name
        self.dbinstance_storage_type = dbinstance_storage_type
        self.binlog_name = binlog_name
        self.binlog_position = binlog_position
        self.binlog_role = binlog_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.system_dbcharset is not None:
            result['SystemDBCharset'] = self.system_dbcharset
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.period is not None:
            result['Period'] = self.period
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_dbinstance_name is not None:
            result['SourceDBInstanceName'] = self.source_dbinstance_name
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.binlog_name is not None:
            result['BinlogName'] = self.binlog_name
        if self.binlog_position is not None:
            result['BinlogPosition'] = self.binlog_position
        if self.binlog_role is not None:
            result['BinlogRole'] = self.binlog_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('SystemDBCharset') is not None:
            self.system_dbcharset = m.get('SystemDBCharset')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceDBInstanceName') is not None:
            self.source_dbinstance_name = m.get('SourceDBInstanceName')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('BinlogName') is not None:
            self.binlog_name = m.get('BinlogName')
        if m.get('BinlogPosition') is not None:
            self.binlog_position = m.get('BinlogPosition')
        if m.get('BinlogRole') is not None:
            self.binlog_role = m.get('BinlogRole')
        return self


class CreateDdrInstanceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        port: str = None,
        connection_string: str = None,
        order_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.port = port
        self.connection_string = connection_string
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.port is not None:
            result['Port'] = self.port
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateDdrInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDdrInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDdrInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dedicated_host_group_id: str = None,
        host_name: str = None,
        zone_id: str = None,
        v_switch_id: str = None,
        host_class: str = None,
        pay_type: str = None,
        period: str = None,
        used_time: str = None,
        client_token: str = None,
        auto_renew: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dedicated_host_group_id = dedicated_host_group_id
        self.host_name = host_name
        self.zone_id = zone_id
        self.v_switch_id = v_switch_id
        self.host_class = host_class
        self.pay_type = pay_type
        self.period = period
        self.used_time = used_time
        self.client_token = client_token
        self.auto_renew = auto_renew

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.host_class is not None:
            result['HostClass'] = self.host_class
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('HostClass') is not None:
            self.host_class = m.get('HostClass')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        return self


class CreateDedicatedHostResponseBodyDedicateHostListDedicateHostList(TeaModel):
    def __init__(
        self,
        dedicated_host_id: str = None,
    ):
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class CreateDedicatedHostResponseBodyDedicateHostList(TeaModel):
    def __init__(
        self,
        dedicate_host_list: List[CreateDedicatedHostResponseBodyDedicateHostListDedicateHostList] = None,
    ):
        self.dedicate_host_list = dedicate_host_list

    def validate(self):
        if self.dedicate_host_list:
            for k in self.dedicate_host_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicateHostList'] = []
        if self.dedicate_host_list is not None:
            for k in self.dedicate_host_list:
                result['DedicateHostList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicate_host_list = []
        if m.get('DedicateHostList') is not None:
            for k in m.get('DedicateHostList'):
                temp_model = CreateDedicatedHostResponseBodyDedicateHostListDedicateHostList()
                self.dedicate_host_list.append(temp_model.from_map(k))
        return self


class CreateDedicatedHostResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicate_host_list: CreateDedicatedHostResponseBodyDedicateHostList = None,
        order_id: int = None,
    ):
        self.request_id = request_id
        self.dedicate_host_list = dedicate_host_list
        self.order_id = order_id

    def validate(self):
        if self.dedicate_host_list:
            self.dedicate_host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicate_host_list is not None:
            result['DedicateHostList'] = self.dedicate_host_list.to_map()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicateHostList') is not None:
            temp_model = CreateDedicatedHostResponseBodyDedicateHostList()
            self.dedicate_host_list = temp_model.from_map(m['DedicateHostList'])
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateDedicatedHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostAccountRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dedicated_host_id: str = None,
        account_name: str = None,
        account_password: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dedicated_host_id = dedicated_host_id
        self.account_name = account_name
        self.account_password = account_password
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateDedicatedHostAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedHostAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedHostAccountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        engine: str = None,
        cpu_allocation_ratio: int = None,
        mem_allocation_ratio: int = None,
        disk_allocation_ratio: int = None,
        allocation_policy: str = None,
        vpcid: str = None,
        host_replace_policy: str = None,
        client_token: str = None,
        open_permission: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.engine = engine
        self.cpu_allocation_ratio = cpu_allocation_ratio
        self.mem_allocation_ratio = mem_allocation_ratio
        self.disk_allocation_ratio = disk_allocation_ratio
        self.allocation_policy = allocation_policy
        self.vpcid = vpcid
        self.host_replace_policy = host_replace_policy
        self.client_token = client_token
        self.open_permission = open_permission

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.cpu_allocation_ratio is not None:
            result['CpuAllocationRatio'] = self.cpu_allocation_ratio
        if self.mem_allocation_ratio is not None:
            result['MemAllocationRatio'] = self.mem_allocation_ratio
        if self.disk_allocation_ratio is not None:
            result['DiskAllocationRatio'] = self.disk_allocation_ratio
        if self.allocation_policy is not None:
            result['AllocationPolicy'] = self.allocation_policy
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.host_replace_policy is not None:
            result['HostReplacePolicy'] = self.host_replace_policy
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.open_permission is not None:
            result['OpenPermission'] = self.open_permission
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('CpuAllocationRatio') is not None:
            self.cpu_allocation_ratio = m.get('CpuAllocationRatio')
        if m.get('MemAllocationRatio') is not None:
            self.mem_allocation_ratio = m.get('MemAllocationRatio')
        if m.get('DiskAllocationRatio') is not None:
            self.disk_allocation_ratio = m.get('DiskAllocationRatio')
        if m.get('AllocationPolicy') is not None:
            self.allocation_policy = m.get('AllocationPolicy')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('HostReplacePolicy') is not None:
            self.host_replace_policy = m.get('HostReplacePolicy')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OpenPermission') is not None:
            self.open_permission = m.get('OpenPermission')
        return self


class CreateDedicatedHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_host_group_id: str = None,
    ):
        self.request_id = request_id
        self.dedicated_host_group_id = dedicated_host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        return self


class CreateDedicatedHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostUserRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dedicated_host_name: str = None,
        user_name: str = None,
        user_password: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dedicated_host_name = dedicated_host_name
        self.user_name = user_name
        self.user_password = user_password
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_password is not None:
            result['UserPassword'] = self.user_password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserPassword') is not None:
            self.user_password = m.get('UserPassword')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateDedicatedHostUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedHostUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedHostUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticReportRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateDiagnosticReportResponseBody(TeaModel):
    def __init__(
        self,
        report_id: str = None,
        request_id: str = None,
    ):
        self.report_id = report_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnosticReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDiagnosticReportResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMigrateTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
        backup_mode: str = None,
        is_online_db: str = None,
        check_dbmode: str = None,
        oss_object_positions: str = None,
        ossurls: str = None,
        migrate_task_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.backup_mode = backup_mode
        self.is_online_db = is_online_db
        self.check_dbmode = check_dbmode
        self.oss_object_positions = oss_object_positions
        self.ossurls = ossurls
        self.migrate_task_id = migrate_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.is_online_db is not None:
            result['IsOnlineDB'] = self.is_online_db
        if self.check_dbmode is not None:
            result['CheckDBMode'] = self.check_dbmode
        if self.oss_object_positions is not None:
            result['OssObjectPositions'] = self.oss_object_positions
        if self.ossurls is not None:
            result['OSSUrls'] = self.ossurls
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('IsOnlineDB') is not None:
            self.is_online_db = m.get('IsOnlineDB')
        if m.get('CheckDBMode') is not None:
            self.check_dbmode = m.get('CheckDBMode')
        if m.get('OssObjectPositions') is not None:
            self.oss_object_positions = m.get('OssObjectPositions')
        if m.get('OSSUrls') is not None:
            self.ossurls = m.get('OSSUrls')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        return self


class CreateMigrateTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dbname: str = None,
        backup_mode: str = None,
        dbinstance_id: str = None,
        migrate_task_id: str = None,
        task_id: str = None,
    ):
        self.request_id = request_id
        self.dbname = dbname
        self.backup_mode = backup_mode
        self.dbinstance_id = dbinstance_id
        self.migrate_task_id = migrate_task_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateMigrateTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMigrateTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMigrateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMigrateTaskForSQLServerRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
        task_type: str = None,
        is_online_db: str = None,
        ossurls: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.task_type = task_type
        self.is_online_db = is_online_db
        self.ossurls = ossurls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.is_online_db is not None:
            result['IsOnlineDB'] = self.is_online_db
        if self.ossurls is not None:
            result['OSSUrls'] = self.ossurls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('IsOnlineDB') is not None:
            self.is_online_db = m.get('IsOnlineDB')
        if m.get('OSSUrls') is not None:
            self.ossurls = m.get('OSSUrls')
        return self


class CreateMigrateTaskForSQLServerResponseBody(TeaModel):
    def __init__(
        self,
        migrate_iask_id: str = None,
        task_type: str = None,
        dbinstance_name: str = None,
        request_id: str = None,
        dbname: str = None,
        dbinstance_id: str = None,
        task_id: str = None,
    ):
        self.migrate_iask_id = migrate_iask_id
        self.task_type = task_type
        self.dbinstance_name = dbinstance_name
        self.request_id = request_id
        self.dbname = dbname
        self.dbinstance_id = dbinstance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migrate_iask_id is not None:
            result['MigrateIaskId'] = self.migrate_iask_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MigrateIaskId') is not None:
            self.migrate_iask_id = m.get('MigrateIaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateMigrateTaskForSQLServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMigrateTaskForSQLServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMigrateTaskForSQLServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOnlineDatabaseTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        dbname: str = None,
        migrate_task_id: str = None,
        check_dbmode: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.migrate_task_id = migrate_task_id
        self.check_dbmode = check_dbmode
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.check_dbmode is not None:
            result['CheckDBMode'] = self.check_dbmode
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('CheckDBMode') is not None:
            self.check_dbmode = m.get('CheckDBMode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateOnlineDatabaseTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOnlineDatabaseTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOnlineDatabaseTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOnlineDatabaseTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateParameterGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        parameter_group_name: str = None,
        engine: str = None,
        engine_version: str = None,
        parameters: str = None,
        parameter_group_desc: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.parameter_group_name = parameter_group_name
        self.engine = engine
        self.engine_version = engine_version
        self.parameters = parameters
        self.parameter_group_desc = parameter_group_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('Parameters') is not None:
            self.parameters = m.get('Parameters')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        return self


class CreateParameterGroupResponseBody(TeaModel):
    def __init__(
        self,
        parameter_group_id: str = None,
        request_id: str = None,
    ):
        self.parameter_group_id = parameter_group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateParameterGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateParameterGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateReadOnlyDBInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        zone_id: str = None,
        dbinstance_id: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        engine_version: str = None,
        pay_type: str = None,
        dbinstance_description: str = None,
        instance_network_type: str = None,
        vpcid: str = None,
        v_switch_id: str = None,
        private_ip_address: str = None,
        owner_account: str = None,
        resource_group_id: str = None,
        category: str = None,
        dbinstance_storage_type: str = None,
        dedicated_host_group_id: str = None,
        target_dedicated_host_id_for_master: str = None,
        gdn_instance_name: str = None,
        tddl_biz_type: str = None,
        tddl_region_config: str = None,
        instruction_set_arch: str = None,
        used_time: str = None,
        period: str = None,
        auto_renew: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.zone_id = zone_id
        self.dbinstance_id = dbinstance_id
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.engine_version = engine_version
        self.pay_type = pay_type
        self.dbinstance_description = dbinstance_description
        self.instance_network_type = instance_network_type
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id
        self.private_ip_address = private_ip_address
        self.owner_account = owner_account
        self.resource_group_id = resource_group_id
        self.category = category
        self.dbinstance_storage_type = dbinstance_storage_type
        self.dedicated_host_group_id = dedicated_host_group_id
        self.target_dedicated_host_id_for_master = target_dedicated_host_id_for_master
        self.gdn_instance_name = gdn_instance_name
        self.tddl_biz_type = tddl_biz_type
        self.tddl_region_config = tddl_region_config
        self.instruction_set_arch = instruction_set_arch
        self.used_time = used_time
        self.period = period
        self.auto_renew = auto_renew

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category is not None:
            result['Category'] = self.category
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.target_dedicated_host_id_for_master is not None:
            result['TargetDedicatedHostIdForMaster'] = self.target_dedicated_host_id_for_master
        if self.gdn_instance_name is not None:
            result['GdnInstanceName'] = self.gdn_instance_name
        if self.tddl_biz_type is not None:
            result['TddlBizType'] = self.tddl_biz_type
        if self.tddl_region_config is not None:
            result['TddlRegionConfig'] = self.tddl_region_config
        if self.instruction_set_arch is not None:
            result['InstructionSetArch'] = self.instruction_set_arch
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.period is not None:
            result['Period'] = self.period
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('TargetDedicatedHostIdForMaster') is not None:
            self.target_dedicated_host_id_for_master = m.get('TargetDedicatedHostIdForMaster')
        if m.get('GdnInstanceName') is not None:
            self.gdn_instance_name = m.get('GdnInstanceName')
        if m.get('TddlBizType') is not None:
            self.tddl_biz_type = m.get('TddlBizType')
        if m.get('TddlRegionConfig') is not None:
            self.tddl_region_config = m.get('TddlRegionConfig')
        if m.get('InstructionSetArch') is not None:
            self.instruction_set_arch = m.get('InstructionSetArch')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        return self


class CreateReadOnlyDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        port: str = None,
        connection_string: str = None,
        order_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.port = port
        self.connection_string = connection_string
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.port is not None:
            result['Port'] = self.port
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateReadOnlyDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateReadOnlyDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateReadOnlyDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTempDBInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_id: int = None,
        restore_time: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.restore_time = restore_time
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class CreateTempDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        temp_dbinstance_id: str = None,
        request_id: str = None,
    ):
        self.temp_dbinstance_id = temp_dbinstance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTempDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTempDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTempDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAccountRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        account_name: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.account_name = account_name
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteAccountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DeleteBackupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupFileRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dbinstance_id: str = None,
        backup_id: str = None,
        dbname: str = None,
        backup_time: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.dbname = dbname
        self.backup_time = backup_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_time is not None:
            result['BackupTime'] = self.backup_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupTime') is not None:
            self.backup_time = m.get('BackupTime')
        return self


class DeleteBackupFileResponseBodyDeletedBaksetIds(TeaModel):
    def __init__(
        self,
        deleted_bakset_ids: List[int] = None,
    ):
        self.deleted_bakset_ids = deleted_bakset_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deleted_bakset_ids is not None:
            result['DeletedBaksetIds'] = self.deleted_bakset_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeletedBaksetIds') is not None:
            self.deleted_bakset_ids = m.get('DeletedBaksetIds')
        return self


class DeleteBackupFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        deleted_bakset_ids: DeleteBackupFileResponseBodyDeletedBaksetIds = None,
    ):
        self.request_id = request_id
        self.deleted_bakset_ids = deleted_bakset_ids

    def validate(self):
        if self.deleted_bakset_ids:
            self.deleted_bakset_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.deleted_bakset_ids is not None:
            result['DeletedBaksetIds'] = self.deleted_bakset_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeletedBaksetIds') is not None:
            temp_model = DeleteBackupFileResponseBodyDeletedBaksetIds()
            self.deleted_bakset_ids = temp_model.from_map(m['DeletedBaksetIds'])
        return self


class DeleteBackupFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDatabaseRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        return self


class DeleteDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
        released_keep_policy: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account
        self.released_keep_policy = released_keep_policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        return self


class DeleteDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        request_id: str = None,
    ):
        self.region_id = region_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDBProxyEndpointAddressRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        dbinstance_id: str = None,
        dbproxy_endpoint_id: str = None,
        dbproxy_connect_string_net_type: str = None,
    ):
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.dbproxy_endpoint_id = dbproxy_endpoint_id
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        return self


class DeleteDBProxyEndpointAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDBProxyEndpointAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDBProxyEndpointAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDBProxyEndpointAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedHostAccountRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dedicated_host_id: str = None,
        account_name: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dedicated_host_id = dedicated_host_id
        self.account_name = account_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDedicatedHostAccountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedHostAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDedicatedHostAccountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedHostAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedHostGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dedicated_host_group_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dedicated_host_group_id = dedicated_host_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDedicatedHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDedicatedHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteParameterGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        parameter_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.parameter_group_id = parameter_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        return self


class DeleteParameterGroupResponseBody(TeaModel):
    def __init__(
        self,
        parameter_group_id: str = None,
        request_id: str = None,
    ):
        self.parameter_group_id = parameter_group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteParameterGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteParameterGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserBackupFileRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        backup_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.backup_id = backup_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteUserBackupFileResponseBody(TeaModel):
    def __init__(
        self,
        backup_id: str = None,
        request_id: str = None,
    ):
        self.backup_id = backup_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserBackupFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteUserBackupFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteUserBackupFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescibeImportsFromDatabaseRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        engine: str = None,
        import_id: int = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.import_id = import_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB(TeaModel):
    def __init__(
        self,
        incremental_importing_time: str = None,
        import_id: int = None,
        import_data_status: str = None,
        import_data_type: str = None,
        import_data_status_description: str = None,
    ):
        self.incremental_importing_time = incremental_importing_time
        self.import_id = import_id
        self.import_data_status = import_data_status
        self.import_data_type = import_data_type
        self.import_data_status_description = import_data_status_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.incremental_importing_time is not None:
            result['IncrementalImportingTime'] = self.incremental_importing_time
        if self.import_id is not None:
            result['ImportId'] = self.import_id
        if self.import_data_status is not None:
            result['ImportDataStatus'] = self.import_data_status
        if self.import_data_type is not None:
            result['ImportDataType'] = self.import_data_type
        if self.import_data_status_description is not None:
            result['ImportDataStatusDescription'] = self.import_data_status_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncrementalImportingTime') is not None:
            self.incremental_importing_time = m.get('IncrementalImportingTime')
        if m.get('ImportId') is not None:
            self.import_id = m.get('ImportId')
        if m.get('ImportDataStatus') is not None:
            self.import_data_status = m.get('ImportDataStatus')
        if m.get('ImportDataType') is not None:
            self.import_data_type = m.get('ImportDataType')
        if m.get('ImportDataStatusDescription') is not None:
            self.import_data_status_description = m.get('ImportDataStatusDescription')
        return self


class DescibeImportsFromDatabaseResponseBodyItems(TeaModel):
    def __init__(
        self,
        import_result_from_db: List[DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB] = None,
    ):
        self.import_result_from_db = import_result_from_db

    def validate(self):
        if self.import_result_from_db:
            for k in self.import_result_from_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImportResultFromDB'] = []
        if self.import_result_from_db is not None:
            for k in self.import_result_from_db:
                result['ImportResultFromDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.import_result_from_db = []
        if m.get('ImportResultFromDB') is not None:
            for k in m.get('ImportResultFromDB'):
                temp_model = DescibeImportsFromDatabaseResponseBodyItemsImportResultFromDB()
                self.import_result_from_db.append(temp_model.from_map(k))
        return self


class DescibeImportsFromDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescibeImportsFromDatabaseResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescibeImportsFromDatabaseResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescibeImportsFromDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescibeImportsFromDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescibeImportsFromDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        account_name: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.account_name = account_name
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege(TeaModel):
    def __init__(
        self,
        dbname: str = None,
        account_privilege: str = None,
        account_privilege_detail: str = None,
    ):
        self.dbname = dbname
        self.account_privilege = account_privilege
        self.account_privilege_detail = account_privilege_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.account_privilege is not None:
            result['AccountPrivilege'] = self.account_privilege
        if self.account_privilege_detail is not None:
            result['AccountPrivilegeDetail'] = self.account_privilege_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('AccountPrivilege') is not None:
            self.account_privilege = m.get('AccountPrivilege')
        if m.get('AccountPrivilegeDetail') is not None:
            self.account_privilege_detail = m.get('AccountPrivilegeDetail')
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges(TeaModel):
    def __init__(
        self,
        database_privilege: List[DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege] = None,
    ):
        self.database_privilege = database_privilege

    def validate(self):
        if self.database_privilege:
            for k in self.database_privilege:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DatabasePrivilege'] = []
        if self.database_privilege is not None:
            for k in self.database_privilege:
                result['DatabasePrivilege'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.database_privilege = []
        if m.get('DatabasePrivilege') is not None:
            for k in m.get('DatabasePrivilege'):
                temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivilegesDatabasePrivilege()
                self.database_privilege.append(temp_model.from_map(k))
        return self


class DescribeAccountsResponseBodyAccountsDBInstanceAccount(TeaModel):
    def __init__(
        self,
        account_status: str = None,
        account_description: str = None,
        dbinstance_id: str = None,
        priv_exceeded: str = None,
        account_type: str = None,
        account_name: str = None,
        database_privileges: DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges = None,
    ):
        self.account_status = account_status
        self.account_description = account_description
        self.dbinstance_id = dbinstance_id
        self.priv_exceeded = priv_exceeded
        self.account_type = account_type
        self.account_name = account_name
        self.database_privileges = database_privileges

    def validate(self):
        if self.database_privileges:
            self.database_privileges.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_status is not None:
            result['AccountStatus'] = self.account_status
        if self.account_description is not None:
            result['AccountDescription'] = self.account_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.priv_exceeded is not None:
            result['PrivExceeded'] = self.priv_exceeded
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.database_privileges is not None:
            result['DatabasePrivileges'] = self.database_privileges.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountStatus') is not None:
            self.account_status = m.get('AccountStatus')
        if m.get('AccountDescription') is not None:
            self.account_description = m.get('AccountDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PrivExceeded') is not None:
            self.priv_exceeded = m.get('PrivExceeded')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DatabasePrivileges') is not None:
            temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccountDatabasePrivileges()
            self.database_privileges = temp_model.from_map(m['DatabasePrivileges'])
        return self


class DescribeAccountsResponseBodyAccounts(TeaModel):
    def __init__(
        self,
        dbinstance_account: List[DescribeAccountsResponseBodyAccountsDBInstanceAccount] = None,
    ):
        self.dbinstance_account = dbinstance_account

    def validate(self):
        if self.dbinstance_account:
            for k in self.dbinstance_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAccount'] = []
        if self.dbinstance_account is not None:
            for k in self.dbinstance_account:
                result['DBInstanceAccount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_account = []
        if m.get('DBInstanceAccount') is not None:
            for k in m.get('DBInstanceAccount'):
                temp_model = DescribeAccountsResponseBodyAccountsDBInstanceAccount()
                self.dbinstance_account.append(temp_model.from_map(k))
        return self


class DescribeAccountsResponseBody(TeaModel):
    def __init__(
        self,
        system_admin_account_status: str = None,
        system_admin_account_first_activation_time: str = None,
        page_number: int = None,
        request_id: str = None,
        total_record_count: int = None,
        accounts: DescribeAccountsResponseBodyAccounts = None,
    ):
        self.system_admin_account_status = system_admin_account_status
        self.system_admin_account_first_activation_time = system_admin_account_first_activation_time
        self.page_number = page_number
        self.request_id = request_id
        self.total_record_count = total_record_count
        self.accounts = accounts

    def validate(self):
        if self.accounts:
            self.accounts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_admin_account_status is not None:
            result['SystemAdminAccountStatus'] = self.system_admin_account_status
        if self.system_admin_account_first_activation_time is not None:
            result['SystemAdminAccountFirstActivationTime'] = self.system_admin_account_first_activation_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.accounts is not None:
            result['Accounts'] = self.accounts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SystemAdminAccountStatus') is not None:
            self.system_admin_account_status = m.get('SystemAdminAccountStatus')
        if m.get('SystemAdminAccountFirstActivationTime') is not None:
            self.system_admin_account_first_activation_time = m.get('SystemAdminAccountFirstActivationTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Accounts') is not None:
            temp_model = DescribeAccountsResponseBodyAccounts()
            self.accounts = temp_model.from_map(m['Accounts'])
        return self


class DescribeAccountsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccountsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccountsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActionEventPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeActionEventPolicyResponseBody(TeaModel):
    def __init__(
        self,
        enable_event_log: str = None,
        request_id: str = None,
        region_id: str = None,
    ):
        self.enable_event_log = enable_event_log
        self.request_id = request_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_event_log is not None:
            result['EnableEventLog'] = self.enable_event_log
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableEventLog') is not None:
            self.enable_event_log = m.get('EnableEventLog')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeActionEventPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeActionEventPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeActionEventPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableClassesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        zone_id: str = None,
        instance_charge_type: str = None,
        engine: str = None,
        engine_version: str = None,
        dbinstance_id: str = None,
        order_type: str = None,
        dbinstance_storage_type: str = None,
        category: str = None,
        commodity_code: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.instance_charge_type = instance_charge_type
        self.engine = engine
        self.engine_version = engine_version
        self.dbinstance_id = dbinstance_id
        self.order_type = order_type
        self.dbinstance_storage_type = dbinstance_storage_type
        self.category = category
        self.commodity_code = commodity_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.category is not None:
            result['Category'] = self.category
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        return self


class DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange(TeaModel):
    def __init__(
        self,
        step: int = None,
        min_value: int = None,
        max_value: int = None,
    ):
        self.step = step
        self.min_value = min_value
        self.max_value = max_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.step is not None:
            result['Step'] = self.step
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        return self


class DescribeAvailableClassesResponseBodyDBInstanceClasses(TeaModel):
    def __init__(
        self,
        dbinstance_class: str = None,
        dbinstance_storage_range: DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange = None,
    ):
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage_range = dbinstance_storage_range

    def validate(self):
        if self.dbinstance_storage_range:
            self.dbinstance_storage_range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage_range is not None:
            result['DBInstanceStorageRange'] = self.dbinstance_storage_range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorageRange') is not None:
            temp_model = DescribeAvailableClassesResponseBodyDBInstanceClassesDBInstanceStorageRange()
            self.dbinstance_storage_range = temp_model.from_map(m['DBInstanceStorageRange'])
        return self


class DescribeAvailableClassesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dbinstance_classes: List[DescribeAvailableClassesResponseBodyDBInstanceClasses] = None,
    ):
        self.request_id = request_id
        self.dbinstance_classes = dbinstance_classes

    def validate(self):
        if self.dbinstance_classes:
            for k in self.dbinstance_classes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['DBInstanceClasses'] = []
        if self.dbinstance_classes is not None:
            for k in self.dbinstance_classes:
                result['DBInstanceClasses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.dbinstance_classes = []
        if m.get('DBInstanceClasses') is not None:
            for k in m.get('DBInstanceClasses'):
                temp_model = DescribeAvailableClassesResponseBodyDBInstanceClasses()
                self.dbinstance_classes.append(temp_model.from_map(k))
        return self


class DescribeAvailableClassesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableClassesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableClassesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableCrossRegionRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAvailableCrossRegionResponseBodyRegions(TeaModel):
    def __init__(
        self,
        region: List[str] = None,
    ):
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeAvailableCrossRegionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        regions: DescribeAvailableCrossRegionResponseBodyRegions = None,
    ):
        self.request_id = request_id
        self.regions = regions

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Regions') is not None:
            temp_model = DescribeAvailableCrossRegionResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        return self


class DescribeAvailableCrossRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableCrossRegionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableCrossRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableDedicatedHostClassesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        zone_id: str = None,
        storage_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.zone_id = zone_id
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeAvailableDedicatedHostClassesResponseBodyHostClassesHostClasses(TeaModel):
    def __init__(
        self,
        description: str = None,
        host_class_name: str = None,
    ):
        self.description = description
        self.host_class_name = host_class_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.host_class_name is not None:
            result['HostClassName'] = self.host_class_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostClassName') is not None:
            self.host_class_name = m.get('HostClassName')
        return self


class DescribeAvailableDedicatedHostClassesResponseBodyHostClasses(TeaModel):
    def __init__(
        self,
        host_classes: List[DescribeAvailableDedicatedHostClassesResponseBodyHostClassesHostClasses] = None,
    ):
        self.host_classes = host_classes

    def validate(self):
        if self.host_classes:
            for k in self.host_classes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostClasses'] = []
        if self.host_classes is not None:
            for k in self.host_classes:
                result['HostClasses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_classes = []
        if m.get('HostClasses') is not None:
            for k in m.get('HostClasses'):
                temp_model = DescribeAvailableDedicatedHostClassesResponseBodyHostClassesHostClasses()
                self.host_classes.append(temp_model.from_map(k))
        return self


class DescribeAvailableDedicatedHostClassesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        host_classes: DescribeAvailableDedicatedHostClassesResponseBodyHostClasses = None,
    ):
        self.request_id = request_id
        self.host_classes = host_classes

    def validate(self):
        if self.host_classes:
            self.host_classes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_classes is not None:
            result['HostClasses'] = self.host_classes.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostClasses') is not None:
            temp_model = DescribeAvailableDedicatedHostClassesResponseBodyHostClasses()
            self.host_classes = temp_model.from_map(m['HostClasses'])
        return self


class DescribeAvailableDedicatedHostClassesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableDedicatedHostClassesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableDedicatedHostClassesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableDedicatedHostZonesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAvailableDedicatedHostZonesResponseBodyZonesDedicatedHostZones(TeaModel):
    def __init__(
        self,
        description: str = None,
        zone_id: str = None,
    ):
        self.description = description
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableDedicatedHostZonesResponseBodyZones(TeaModel):
    def __init__(
        self,
        dedicated_host_zones: List[DescribeAvailableDedicatedHostZonesResponseBodyZonesDedicatedHostZones] = None,
    ):
        self.dedicated_host_zones = dedicated_host_zones

    def validate(self):
        if self.dedicated_host_zones:
            for k in self.dedicated_host_zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostZones'] = []
        if self.dedicated_host_zones is not None:
            for k in self.dedicated_host_zones:
                result['DedicatedHostZones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host_zones = []
        if m.get('DedicatedHostZones') is not None:
            for k in m.get('DedicatedHostZones'):
                temp_model = DescribeAvailableDedicatedHostZonesResponseBodyZonesDedicatedHostZones()
                self.dedicated_host_zones.append(temp_model.from_map(k))
        return self


class DescribeAvailableDedicatedHostZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zones: DescribeAvailableDedicatedHostZonesResponseBodyZones = None,
    ):
        self.request_id = request_id
        self.zones = zones

    def validate(self):
        if self.zones:
            self.zones.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.zones is not None:
            result['Zones'] = self.zones.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Zones') is not None:
            temp_model = DescribeAvailableDedicatedHostZonesResponseBodyZones()
            self.zones = temp_model.from_map(m['Zones'])
        return self


class DescribeAvailableDedicatedHostZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableDedicatedHostZonesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableDedicatedHostZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableMetricsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_name = dbinstance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class DescribeAvailableMetricsResponseBodyItems(TeaModel):
    def __init__(
        self,
        group_key: str = None,
        sort_rule: int = None,
        description: str = None,
        unit: str = None,
        metrics_key: str = None,
        group_key_type: str = None,
        metrics_key_alias: str = None,
        method: str = None,
        dimension: str = None,
    ):
        self.group_key = group_key
        self.sort_rule = sort_rule
        self.description = description
        self.unit = unit
        self.metrics_key = metrics_key
        self.group_key_type = group_key_type
        self.metrics_key_alias = metrics_key_alias
        self.method = method
        self.dimension = dimension

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_key is not None:
            result['GroupKey'] = self.group_key
        if self.sort_rule is not None:
            result['SortRule'] = self.sort_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metrics_key is not None:
            result['MetricsKey'] = self.metrics_key
        if self.group_key_type is not None:
            result['GroupKeyType'] = self.group_key_type
        if self.metrics_key_alias is not None:
            result['MetricsKeyAlias'] = self.metrics_key_alias
        if self.method is not None:
            result['Method'] = self.method
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupKey') is not None:
            self.group_key = m.get('GroupKey')
        if m.get('SortRule') is not None:
            self.sort_rule = m.get('SortRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricsKey') is not None:
            self.metrics_key = m.get('MetricsKey')
        if m.get('GroupKeyType') is not None:
            self.group_key_type = m.get('GroupKeyType')
        if m.get('MetricsKeyAlias') is not None:
            self.metrics_key_alias = m.get('MetricsKeyAlias')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        return self


class DescribeAvailableMetricsResponseBody(TeaModel):
    def __init__(
        self,
        total_record_count: int = None,
        request_id: str = None,
        items: List[DescribeAvailableMetricsResponseBodyItems] = None,
    ):
        self.total_record_count = total_record_count
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeAvailableMetricsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        return self


class DescribeAvailableMetricsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableMetricsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableRecoveryTimeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        cross_backup_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.cross_backup_id = cross_backup_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAvailableRecoveryTimeResponseBody(TeaModel):
    def __init__(
        self,
        recovery_end_time: str = None,
        request_id: str = None,
        cross_backup_id: int = None,
        recovery_begin_time: str = None,
        region_id: str = None,
    ):
        self.recovery_end_time = recovery_end_time
        self.request_id = request_id
        self.cross_backup_id = cross_backup_id
        self.recovery_begin_time = recovery_begin_time
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovery_end_time is not None:
            result['RecoveryEndTime'] = self.recovery_end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.recovery_begin_time is not None:
            result['RecoveryBeginTime'] = self.recovery_begin_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecoveryEndTime') is not None:
            self.recovery_end_time = m.get('RecoveryEndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('RecoveryBeginTime') is not None:
            self.recovery_begin_time = m.get('RecoveryBeginTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAvailableRecoveryTimeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableRecoveryTimeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableRecoveryTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableZonesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        engine: str = None,
        zone_id: str = None,
        engine_version: str = None,
        commodity_code: str = None,
        dispense_mode: str = None,
        dbinstance_name: str = None,
        category: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.engine = engine
        self.zone_id = zone_id
        self.engine_version = engine_version
        self.commodity_code = commodity_code
        self.dispense_mode = dispense_mode
        self.dbinstance_name = dbinstance_name
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.dispense_mode is not None:
            result['DispenseMode'] = self.dispense_mode
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DispenseMode') is not None:
            self.dispense_mode = m.get('DispenseMode')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes(TeaModel):
    def __init__(
        self,
        storage_type: str = None,
    ):
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys(TeaModel):
    def __init__(
        self,
        category: str = None,
        supported_storage_types: List[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes] = None,
    ):
        self.category = category
        self.supported_storage_types = supported_storage_types

    def validate(self):
        if self.supported_storage_types:
            for k in self.supported_storage_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        result['SupportedStorageTypes'] = []
        if self.supported_storage_types is not None:
            for k in self.supported_storage_types:
                result['SupportedStorageTypes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        self.supported_storage_types = []
        if m.get('SupportedStorageTypes') is not None:
            for k in m.get('SupportedStorageTypes'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorysSupportedStorageTypes()
                self.supported_storage_types.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions(TeaModel):
    def __init__(
        self,
        version: str = None,
        supported_categorys: List[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys] = None,
    ):
        self.version = version
        self.supported_categorys = supported_categorys

    def validate(self):
        if self.supported_categorys:
            for k in self.supported_categorys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.version is not None:
            result['Version'] = self.version
        result['SupportedCategorys'] = []
        if self.supported_categorys is not None:
            for k in self.supported_categorys:
                result['SupportedCategorys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Version') is not None:
            self.version = m.get('Version')
        self.supported_categorys = []
        if m.get('SupportedCategorys') is not None:
            for k in m.get('SupportedCategorys'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersionsSupportedCategorys()
                self.supported_categorys.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines(TeaModel):
    def __init__(
        self,
        engine: str = None,
        supported_engine_versions: List[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions] = None,
    ):
        self.engine = engine
        self.supported_engine_versions = supported_engine_versions

    def validate(self):
        if self.supported_engine_versions:
            for k in self.supported_engine_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        result['SupportedEngineVersions'] = []
        if self.supported_engine_versions is not None:
            for k in self.supported_engine_versions:
                result['SupportedEngineVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        self.supported_engine_versions = []
        if m.get('SupportedEngineVersions') is not None:
            for k in m.get('SupportedEngineVersions'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEnginesSupportedEngineVersions()
                self.supported_engine_versions.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBodyAvailableZones(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
        region_id: str = None,
        supported_engines: List[DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines] = None,
    ):
        self.zone_id = zone_id
        self.region_id = region_id
        self.supported_engines = supported_engines

    def validate(self):
        if self.supported_engines:
            for k in self.supported_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['SupportedEngines'] = []
        if self.supported_engines is not None:
            for k in self.supported_engines:
                result['SupportedEngines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.supported_engines = []
        if m.get('SupportedEngines') is not None:
            for k in m.get('SupportedEngines'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZonesSupportedEngines()
                self.supported_engines.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        available_zones: List[DescribeAvailableZonesResponseBodyAvailableZones] = None,
    ):
        self.request_id = request_id
        self.available_zones = available_zones

    def validate(self):
        if self.available_zones:
            for k in self.available_zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['AvailableZones'] = []
        if self.available_zones is not None:
            for k in self.available_zones:
                result['AvailableZones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.available_zones = []
        if m.get('AvailableZones') is not None:
            for k in m.get('AvailableZones'):
                temp_model = DescribeAvailableZonesResponseBodyAvailableZones()
                self.available_zones.append(temp_model.from_map(k))
        return self


class DescribeAvailableZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAvailableZonesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAvailableZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupDatabaseRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        return self


class DescribeBackupDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        database_names: str = None,
        request_id: str = None,
    ):
        self.database_names = database_names
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_names is not None:
            result['DatabaseNames'] = self.database_names
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseNames') is not None:
            self.database_names = m.get('DatabaseNames')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_policy_mode: str = None,
        owner_account: str = None,
        compress_type: str = None,
        released_keep_policy: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_policy_mode = backup_policy_mode
        self.owner_account = owner_account
        self.compress_type = compress_type
        self.released_keep_policy = released_keep_policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_policy_mode is not None:
            result['BackupPolicyMode'] = self.backup_policy_mode
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.compress_type is not None:
            result['CompressType'] = self.compress_type
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupPolicyMode') is not None:
            self.backup_policy_mode = m.get('BackupPolicyMode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('CompressType') is not None:
            self.compress_type = m.get('CompressType')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        log_backup_retention_period: int = None,
        archive_backup_keep_policy: str = None,
        archive_backup_keep_count: str = None,
        local_log_retention_hours: int = None,
        backup_retention_period: int = None,
        request_id: str = None,
        preferred_backup_period: str = None,
        compress_type: str = None,
        support_released_keep: int = None,
        local_log_retention_space: str = None,
        support_volume_shadow_copy: int = None,
        backup_method: str = None,
        log_backup_frequency: str = None,
        preferred_next_backup_time: str = None,
        high_space_usage_protection: str = None,
        archive_backup_retention_period: str = None,
        backup_interval: str = None,
        released_keep_policy: str = None,
        preferred_backup_time: str = None,
        log_backup_local_retention_number: int = None,
        category: str = None,
        enable_backup_log: str = None,
        backup_log: str = None,
    ):
        self.log_backup_retention_period = log_backup_retention_period
        self.archive_backup_keep_policy = archive_backup_keep_policy
        self.archive_backup_keep_count = archive_backup_keep_count
        self.local_log_retention_hours = local_log_retention_hours
        self.backup_retention_period = backup_retention_period
        self.request_id = request_id
        self.preferred_backup_period = preferred_backup_period
        self.compress_type = compress_type
        self.support_released_keep = support_released_keep
        self.local_log_retention_space = local_log_retention_space
        self.support_volume_shadow_copy = support_volume_shadow_copy
        self.backup_method = backup_method
        self.log_backup_frequency = log_backup_frequency
        self.preferred_next_backup_time = preferred_next_backup_time
        self.high_space_usage_protection = high_space_usage_protection
        self.archive_backup_retention_period = archive_backup_retention_period
        self.backup_interval = backup_interval
        self.released_keep_policy = released_keep_policy
        self.preferred_backup_time = preferred_backup_time
        self.log_backup_local_retention_number = log_backup_local_retention_number
        self.category = category
        self.enable_backup_log = enable_backup_log
        self.backup_log = backup_log

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_backup_retention_period is not None:
            result['LogBackupRetentionPeriod'] = self.log_backup_retention_period
        if self.archive_backup_keep_policy is not None:
            result['ArchiveBackupKeepPolicy'] = self.archive_backup_keep_policy
        if self.archive_backup_keep_count is not None:
            result['ArchiveBackupKeepCount'] = self.archive_backup_keep_count
        if self.local_log_retention_hours is not None:
            result['LocalLogRetentionHours'] = self.local_log_retention_hours
        if self.backup_retention_period is not None:
            result['BackupRetentionPeriod'] = self.backup_retention_period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.compress_type is not None:
            result['CompressType'] = self.compress_type
        if self.support_released_keep is not None:
            result['SupportReleasedKeep'] = self.support_released_keep
        if self.local_log_retention_space is not None:
            result['LocalLogRetentionSpace'] = self.local_log_retention_space
        if self.support_volume_shadow_copy is not None:
            result['SupportVolumeShadowCopy'] = self.support_volume_shadow_copy
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.log_backup_frequency is not None:
            result['LogBackupFrequency'] = self.log_backup_frequency
        if self.preferred_next_backup_time is not None:
            result['PreferredNextBackupTime'] = self.preferred_next_backup_time
        if self.high_space_usage_protection is not None:
            result['HighSpaceUsageProtection'] = self.high_space_usage_protection
        if self.archive_backup_retention_period is not None:
            result['ArchiveBackupRetentionPeriod'] = self.archive_backup_retention_period
        if self.backup_interval is not None:
            result['BackupInterval'] = self.backup_interval
        if self.released_keep_policy is not None:
            result['ReleasedKeepPolicy'] = self.released_keep_policy
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        if self.log_backup_local_retention_number is not None:
            result['LogBackupLocalRetentionNumber'] = self.log_backup_local_retention_number
        if self.category is not None:
            result['Category'] = self.category
        if self.enable_backup_log is not None:
            result['EnableBackupLog'] = self.enable_backup_log
        if self.backup_log is not None:
            result['BackupLog'] = self.backup_log
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogBackupRetentionPeriod') is not None:
            self.log_backup_retention_period = m.get('LogBackupRetentionPeriod')
        if m.get('ArchiveBackupKeepPolicy') is not None:
            self.archive_backup_keep_policy = m.get('ArchiveBackupKeepPolicy')
        if m.get('ArchiveBackupKeepCount') is not None:
            self.archive_backup_keep_count = m.get('ArchiveBackupKeepCount')
        if m.get('LocalLogRetentionHours') is not None:
            self.local_log_retention_hours = m.get('LocalLogRetentionHours')
        if m.get('BackupRetentionPeriod') is not None:
            self.backup_retention_period = m.get('BackupRetentionPeriod')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('CompressType') is not None:
            self.compress_type = m.get('CompressType')
        if m.get('SupportReleasedKeep') is not None:
            self.support_released_keep = m.get('SupportReleasedKeep')
        if m.get('LocalLogRetentionSpace') is not None:
            self.local_log_retention_space = m.get('LocalLogRetentionSpace')
        if m.get('SupportVolumeShadowCopy') is not None:
            self.support_volume_shadow_copy = m.get('SupportVolumeShadowCopy')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('LogBackupFrequency') is not None:
            self.log_backup_frequency = m.get('LogBackupFrequency')
        if m.get('PreferredNextBackupTime') is not None:
            self.preferred_next_backup_time = m.get('PreferredNextBackupTime')
        if m.get('HighSpaceUsageProtection') is not None:
            self.high_space_usage_protection = m.get('HighSpaceUsageProtection')
        if m.get('ArchiveBackupRetentionPeriod') is not None:
            self.archive_backup_retention_period = m.get('ArchiveBackupRetentionPeriod')
        if m.get('BackupInterval') is not None:
            self.backup_interval = m.get('BackupInterval')
        if m.get('ReleasedKeepPolicy') is not None:
            self.released_keep_policy = m.get('ReleasedKeepPolicy')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        if m.get('LogBackupLocalRetentionNumber') is not None:
            self.log_backup_local_retention_number = m.get('LogBackupLocalRetentionNumber')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('EnableBackupLog') is not None:
            self.enable_backup_log = m.get('EnableBackupLog')
        if m.get('BackupLog') is not None:
            self.backup_log = m.get('BackupLog')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_id: str = None,
        backup_status: str = None,
        backup_mode: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.backup_status = backup_status
        self.backup_mode = backup_mode
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB(TeaModel):
    def __init__(
        self,
        intranet_download_link: str = None,
        data_base: str = None,
        download_link: str = None,
    ):
        self.intranet_download_link = intranet_download_link
        self.data_base = data_base
        self.download_link = download_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        if self.data_base is not None:
            result['DataBase'] = self.data_base
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        if m.get('DataBase') is not None:
            self.data_base = m.get('DataBase')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        return self


class DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB(TeaModel):
    def __init__(
        self,
        backup_download_link_by_db: List[DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB] = None,
    ):
        self.backup_download_link_by_db = backup_download_link_by_db

    def validate(self):
        if self.backup_download_link_by_db:
            for k in self.backup_download_link_by_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupDownloadLinkByDB'] = []
        if self.backup_download_link_by_db is not None:
            for k in self.backup_download_link_by_db:
                result['BackupDownloadLinkByDB'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup_download_link_by_db = []
        if m.get('BackupDownloadLinkByDB') is not None:
            for k in m.get('BackupDownloadLinkByDB'):
                temp_model = DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDBBackupDownloadLinkByDB()
                self.backup_download_link_by_db.append(temp_model.from_map(k))
        return self


class DescribeBackupsResponseBodyItemsBackup(TeaModel):
    def __init__(
        self,
        storage_class: str = None,
        encryption: str = None,
        backup_status: str = None,
        store_status: str = None,
        consistent_time: int = None,
        backup_type: str = None,
        copy_only_backup: str = None,
        backup_end_time: str = None,
        meta_status: str = None,
        backup_initiator: str = None,
        backup_intranet_download_url: str = None,
        backup_method: str = None,
        backup_start_time: str = None,
        backup_download_url: str = None,
        is_avail: int = None,
        backup_id: str = None,
        host_instance_id: str = None,
        backup_size: int = None,
        backup_mode: str = None,
        dbinstance_id: str = None,
        backup_download_link_by_db: DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB = None,
    ):
        self.storage_class = storage_class
        self.encryption = encryption
        self.backup_status = backup_status
        self.store_status = store_status
        self.consistent_time = consistent_time
        self.backup_type = backup_type
        self.copy_only_backup = copy_only_backup
        self.backup_end_time = backup_end_time
        self.meta_status = meta_status
        self.backup_initiator = backup_initiator
        self.backup_intranet_download_url = backup_intranet_download_url
        self.backup_method = backup_method
        self.backup_start_time = backup_start_time
        self.backup_download_url = backup_download_url
        self.is_avail = is_avail
        self.backup_id = backup_id
        self.host_instance_id = host_instance_id
        self.backup_size = backup_size
        self.backup_mode = backup_mode
        self.dbinstance_id = dbinstance_id
        self.backup_download_link_by_db = backup_download_link_by_db

    def validate(self):
        if self.backup_download_link_by_db:
            self.backup_download_link_by_db.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.encryption is not None:
            result['Encryption'] = self.encryption
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.store_status is not None:
            result['StoreStatus'] = self.store_status
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.copy_only_backup is not None:
            result['CopyOnlyBackup'] = self.copy_only_backup
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.meta_status is not None:
            result['MetaStatus'] = self.meta_status
        if self.backup_initiator is not None:
            result['BackupInitiator'] = self.backup_initiator
        if self.backup_intranet_download_url is not None:
            result['BackupIntranetDownloadURL'] = self.backup_intranet_download_url
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_download_url is not None:
            result['BackupDownloadURL'] = self.backup_download_url
        if self.is_avail is not None:
            result['IsAvail'] = self.is_avail
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.host_instance_id is not None:
            result['HostInstanceID'] = self.host_instance_id
        if self.backup_size is not None:
            result['BackupSize'] = self.backup_size
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_download_link_by_db is not None:
            result['BackupDownloadLinkByDB'] = self.backup_download_link_by_db.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('Encryption') is not None:
            self.encryption = m.get('Encryption')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('StoreStatus') is not None:
            self.store_status = m.get('StoreStatus')
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('CopyOnlyBackup') is not None:
            self.copy_only_backup = m.get('CopyOnlyBackup')
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('MetaStatus') is not None:
            self.meta_status = m.get('MetaStatus')
        if m.get('BackupInitiator') is not None:
            self.backup_initiator = m.get('BackupInitiator')
        if m.get('BackupIntranetDownloadURL') is not None:
            self.backup_intranet_download_url = m.get('BackupIntranetDownloadURL')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupDownloadURL') is not None:
            self.backup_download_url = m.get('BackupDownloadURL')
        if m.get('IsAvail') is not None:
            self.is_avail = m.get('IsAvail')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('HostInstanceID') is not None:
            self.host_instance_id = m.get('HostInstanceID')
        if m.get('BackupSize') is not None:
            self.backup_size = m.get('BackupSize')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupDownloadLinkByDB') is not None:
            temp_model = DescribeBackupsResponseBodyItemsBackupBackupDownloadLinkByDB()
            self.backup_download_link_by_db = temp_model.from_map(m['BackupDownloadLinkByDB'])
        return self


class DescribeBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        backup: List[DescribeBackupsResponseBodyItemsBackup] = None,
    ):
        self.backup = backup

    def validate(self):
        if self.backup:
            for k in self.backup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Backup'] = []
        if self.backup is not None:
            for k in self.backup:
                result['Backup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup = []
        if m.get('Backup') is not None:
            for k in m.get('Backup'):
                temp_model = DescribeBackupsResponseBodyItemsBackup()
                self.backup.append(temp_model.from_map(k))
        return self


class DescribeBackupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_ecs_snapshot_size: int = None,
        page_record_count: str = None,
        total_record_count: str = None,
        page_number: str = None,
        items: DescribeBackupsResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.total_ecs_snapshot_size = total_ecs_snapshot_size
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_ecs_snapshot_size is not None:
            result['TotalEcsSnapshotSize'] = self.total_ecs_snapshot_size
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalEcsSnapshotSize') is not None:
            self.total_ecs_snapshot_size = m.get('TotalEcsSnapshotSize')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = DescribeBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupTasksRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        flag: str = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        backup_job_id: int = None,
        backup_mode: str = None,
        backup_job_status: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.flag = flag
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.backup_job_id = backup_job_id
        self.backup_mode = backup_mode
        self.backup_job_status = backup_job_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_job_status is not None:
            result['BackupJobStatus'] = self.backup_job_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupJobStatus') is not None:
            self.backup_job_status = m.get('BackupJobStatus')
        return self


class DescribeBackupTasksResponseBodyItemsBackupJob(TeaModel):
    def __init__(
        self,
        process: str = None,
        backup_job_id: str = None,
        backup_status: str = None,
        job_mode: str = None,
        backup_progress_status: str = None,
        backup_id: str = None,
        task_action: str = None,
    ):
        self.process = process
        self.backup_job_id = backup_job_id
        self.backup_status = backup_status
        self.job_mode = job_mode
        self.backup_progress_status = backup_progress_status
        self.backup_id = backup_id
        self.task_action = task_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process is not None:
            result['Process'] = self.process
        if self.backup_job_id is not None:
            result['BackupJobId'] = self.backup_job_id
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.job_mode is not None:
            result['JobMode'] = self.job_mode
        if self.backup_progress_status is not None:
            result['BackupProgressStatus'] = self.backup_progress_status
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.task_action is not None:
            result['TaskAction'] = self.task_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('BackupJobId') is not None:
            self.backup_job_id = m.get('BackupJobId')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('JobMode') is not None:
            self.job_mode = m.get('JobMode')
        if m.get('BackupProgressStatus') is not None:
            self.backup_progress_status = m.get('BackupProgressStatus')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('TaskAction') is not None:
            self.task_action = m.get('TaskAction')
        return self


class DescribeBackupTasksResponseBodyItems(TeaModel):
    def __init__(
        self,
        backup_job: List[DescribeBackupTasksResponseBodyItemsBackupJob] = None,
    ):
        self.backup_job = backup_job

    def validate(self):
        if self.backup_job:
            for k in self.backup_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupJob'] = []
        if self.backup_job is not None:
            for k in self.backup_job:
                result['BackupJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup_job = []
        if m.get('BackupJob') is not None:
            for k in m.get('BackupJob'):
                temp_model = DescribeBackupTasksResponseBodyItemsBackupJob()
                self.backup_job.append(temp_model.from_map(k))
        return self


class DescribeBackupTasksResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        items: DescribeBackupTasksResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeBackupTasksResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeBackupTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBinlogFilesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeBinlogFilesResponseBodyItemsBinLogFile(TeaModel):
    def __init__(
        self,
        remote_status: str = None,
        intranet_download_link: str = None,
        log_begin_time: str = None,
        link_expired_time: str = None,
        download_link: str = None,
        log_file_name: str = None,
        checksum: str = None,
        log_end_time: str = None,
        host_instance_id: str = None,
        file_size: int = None,
    ):
        self.remote_status = remote_status
        self.intranet_download_link = intranet_download_link
        self.log_begin_time = log_begin_time
        self.link_expired_time = link_expired_time
        self.download_link = download_link
        self.log_file_name = log_file_name
        self.checksum = checksum
        self.log_end_time = log_end_time
        self.host_instance_id = host_instance_id
        self.file_size = file_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remote_status is not None:
            result['RemoteStatus'] = self.remote_status
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        if self.log_begin_time is not None:
            result['LogBeginTime'] = self.log_begin_time
        if self.link_expired_time is not None:
            result['LinkExpiredTime'] = self.link_expired_time
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        if self.log_file_name is not None:
            result['LogFileName'] = self.log_file_name
        if self.checksum is not None:
            result['Checksum'] = self.checksum
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        if self.host_instance_id is not None:
            result['HostInstanceID'] = self.host_instance_id
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemoteStatus') is not None:
            self.remote_status = m.get('RemoteStatus')
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        if m.get('LogBeginTime') is not None:
            self.log_begin_time = m.get('LogBeginTime')
        if m.get('LinkExpiredTime') is not None:
            self.link_expired_time = m.get('LinkExpiredTime')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        if m.get('LogFileName') is not None:
            self.log_file_name = m.get('LogFileName')
        if m.get('Checksum') is not None:
            self.checksum = m.get('Checksum')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        if m.get('HostInstanceID') is not None:
            self.host_instance_id = m.get('HostInstanceID')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class DescribeBinlogFilesResponseBodyItems(TeaModel):
    def __init__(
        self,
        bin_log_file: List[DescribeBinlogFilesResponseBodyItemsBinLogFile] = None,
    ):
        self.bin_log_file = bin_log_file

    def validate(self):
        if self.bin_log_file:
            for k in self.bin_log_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BinLogFile'] = []
        if self.bin_log_file is not None:
            for k in self.bin_log_file:
                result['BinLogFile'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bin_log_file = []
        if m.get('BinLogFile') is not None:
            for k in m.get('BinLogFile'):
                temp_model = DescribeBinlogFilesResponseBodyItemsBinLogFile()
                self.bin_log_file.append(temp_model.from_map(k))
        return self


class DescribeBinlogFilesResponseBody(TeaModel):
    def __init__(
        self,
        total_file_size: int = None,
        page_number: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeBinlogFilesResponseBodyItems = None,
    ):
        self.total_file_size = total_file_size
        self.page_number = page_number
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_file_size is not None:
            result['TotalFileSize'] = self.total_file_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalFileSize') is not None:
            self.total_file_size = m.get('TotalFileSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeBinlogFilesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeBinlogFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBinlogFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBinlogFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCharacterSetNameRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        engine: str = None,
        region_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.engine = engine
        self.region_id = region_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeCharacterSetNameResponseBodyCharacterSetNameItems(TeaModel):
    def __init__(
        self,
        character_set_name: List[str] = None,
    ):
        self.character_set_name = character_set_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_set_name is not None:
            result['CharacterSetName'] = self.character_set_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharacterSetName') is not None:
            self.character_set_name = m.get('CharacterSetName')
        return self


class DescribeCharacterSetNameResponseBody(TeaModel):
    def __init__(
        self,
        engine: str = None,
        request_id: str = None,
        character_set_name_items: DescribeCharacterSetNameResponseBodyCharacterSetNameItems = None,
    ):
        self.engine = engine
        self.request_id = request_id
        self.character_set_name_items = character_set_name_items

    def validate(self):
        if self.character_set_name_items:
            self.character_set_name_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.character_set_name_items is not None:
            result['CharacterSetNameItems'] = self.character_set_name_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CharacterSetNameItems') is not None:
            temp_model = DescribeCharacterSetNameResponseBodyCharacterSetNameItems()
            self.character_set_name_items = temp_model.from_map(m['CharacterSetNameItems'])
        return self


class DescribeCharacterSetNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCharacterSetNameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCharacterSetNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCollationTimeZonesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone(TeaModel):
    def __init__(
        self,
        time_zone: str = None,
        standard_time_offset: str = None,
        description: str = None,
    ):
        self.time_zone = time_zone
        self.standard_time_offset = standard_time_offset
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.standard_time_offset is not None:
            result['StandardTimeOffset'] = self.standard_time_offset
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('StandardTimeOffset') is not None:
            self.standard_time_offset = m.get('StandardTimeOffset')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeCollationTimeZonesResponseBodyCollationTimeZones(TeaModel):
    def __init__(
        self,
        collation_time_zone: List[DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone] = None,
    ):
        self.collation_time_zone = collation_time_zone

    def validate(self):
        if self.collation_time_zone:
            for k in self.collation_time_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CollationTimeZone'] = []
        if self.collation_time_zone is not None:
            for k in self.collation_time_zone:
                result['CollationTimeZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.collation_time_zone = []
        if m.get('CollationTimeZone') is not None:
            for k in m.get('CollationTimeZone'):
                temp_model = DescribeCollationTimeZonesResponseBodyCollationTimeZonesCollationTimeZone()
                self.collation_time_zone.append(temp_model.from_map(k))
        return self


class DescribeCollationTimeZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        collation_time_zones: DescribeCollationTimeZonesResponseBodyCollationTimeZones = None,
    ):
        self.request_id = request_id
        self.collation_time_zones = collation_time_zones

    def validate(self):
        if self.collation_time_zones:
            self.collation_time_zones.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.collation_time_zones is not None:
            result['CollationTimeZones'] = self.collation_time_zones.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CollationTimeZones') is not None:
            temp_model = DescribeCollationTimeZonesResponseBodyCollationTimeZones()
            self.collation_time_zones = temp_model.from_map(m['CollationTimeZones'])
        return self


class DescribeCollationTimeZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCollationTimeZonesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCollationTimeZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossBackupMetaListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        backup_set_id: str = None,
        get_db_name: str = None,
        pattern: str = None,
        page_size: str = None,
        page_index: str = None,
        region: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.backup_set_id = backup_set_id
        self.get_db_name = get_db_name
        self.pattern = pattern
        self.page_size = page_size
        self.page_index = page_index
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.get_db_name is not None:
            result['GetDbName'] = self.get_db_name
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('GetDbName') is not None:
            self.get_db_name = m.get('GetDbName')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeCrossBackupMetaListResponseBodyItemsMeta(TeaModel):
    def __init__(
        self,
        tables: str = None,
        database: str = None,
        size: str = None,
    ):
        self.tables = tables
        self.database = database
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tables is not None:
            result['Tables'] = self.tables
        if self.database is not None:
            result['Database'] = self.database
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeCrossBackupMetaListResponseBodyItems(TeaModel):
    def __init__(
        self,
        meta: List[DescribeCrossBackupMetaListResponseBodyItemsMeta] = None,
    ):
        self.meta = meta

    def validate(self):
        if self.meta:
            for k in self.meta:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Meta'] = []
        if self.meta is not None:
            for k in self.meta:
                result['Meta'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.meta = []
        if m.get('Meta') is not None:
            for k in m.get('Meta'):
                temp_model = DescribeCrossBackupMetaListResponseBodyItemsMeta()
                self.meta.append(temp_model.from_map(k))
        return self


class DescribeCrossBackupMetaListResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_name: str = None,
        total_page_count: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        page_number: int = None,
        items: DescribeCrossBackupMetaListResponseBodyItems = None,
    ):
        self.dbinstance_name = dbinstance_name
        self.total_page_count = total_page_count
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.total_page_count is not None:
            result['TotalPageCount'] = self.total_page_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('TotalPageCount') is not None:
            self.total_page_count = m.get('TotalPageCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = DescribeCrossBackupMetaListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeCrossBackupMetaListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCrossBackupMetaListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCrossBackupMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionBackupDBInstanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dbinstance_id: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        log_backup_enabled_time: str = None,
        backup_enabled: str = None,
        dbinstance_status: str = None,
        lock_mode: str = None,
        engine_version: str = None,
        log_backup_enabled: str = None,
        retent_type: int = None,
        retention: int = None,
        cross_backup_type: str = None,
        cross_backup_region: str = None,
        dbinstance_id: str = None,
        engine: str = None,
        backup_enabled_time: str = None,
        dbinstance_description: str = None,
    ):
        self.log_backup_enabled_time = log_backup_enabled_time
        self.backup_enabled = backup_enabled
        self.dbinstance_status = dbinstance_status
        self.lock_mode = lock_mode
        self.engine_version = engine_version
        self.log_backup_enabled = log_backup_enabled
        self.retent_type = retent_type
        self.retention = retention
        self.cross_backup_type = cross_backup_type
        self.cross_backup_region = cross_backup_region
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.backup_enabled_time = backup_enabled_time
        self.dbinstance_description = dbinstance_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_backup_enabled_time is not None:
            result['LogBackupEnabledTime'] = self.log_backup_enabled_time
        if self.backup_enabled is not None:
            result['BackupEnabled'] = self.backup_enabled
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.log_backup_enabled is not None:
            result['LogBackupEnabled'] = self.log_backup_enabled
        if self.retent_type is not None:
            result['RetentType'] = self.retent_type
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.cross_backup_type is not None:
            result['CrossBackupType'] = self.cross_backup_type
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.backup_enabled_time is not None:
            result['BackupEnabledTime'] = self.backup_enabled_time
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogBackupEnabledTime') is not None:
            self.log_backup_enabled_time = m.get('LogBackupEnabledTime')
        if m.get('BackupEnabled') is not None:
            self.backup_enabled = m.get('BackupEnabled')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('LogBackupEnabled') is not None:
            self.log_backup_enabled = m.get('LogBackupEnabled')
        if m.get('RetentType') is not None:
            self.retent_type = m.get('RetentType')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('CrossBackupType') is not None:
            self.cross_backup_type = m.get('CrossBackupType')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('BackupEnabledTime') is not None:
            self.backup_enabled_time = m.get('BackupEnabledTime')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        return self


class DescribeCrossRegionBackupDBInstanceResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionBackupDBInstanceResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionBackupDBInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_records: int = None,
        items_numbers: int = None,
        page_size: int = None,
        page_number: int = None,
        region_id: str = None,
        items: DescribeCrossRegionBackupDBInstanceResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.total_records = total_records
        self.items_numbers = items_numbers
        self.page_size = page_size
        self.page_number = page_number
        self.region_id = region_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_records is not None:
            result['TotalRecords'] = self.total_records
        if self.items_numbers is not None:
            result['ItemsNumbers'] = self.items_numbers
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalRecords') is not None:
            self.total_records = m.get('TotalRecords')
        if m.get('ItemsNumbers') is not None:
            self.items_numbers = m.get('ItemsNumbers')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionBackupDBInstanceResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeCrossRegionBackupDBInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCrossRegionBackupDBInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionBackupDBInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionBackupsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
        cross_backup_region: str = None,
        cross_backup_id: int = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        backup_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id
        self.cross_backup_region = cross_backup_region
        self.cross_backup_id = cross_backup_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.backup_id = backup_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        return self


class DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions(TeaModel):
    def __init__(
        self,
        restore_region: List[str] = None,
    ):
        self.restore_region = restore_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.restore_region is not None:
            result['RestoreRegion'] = self.restore_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RestoreRegion') is not None:
            self.restore_region = m.get('RestoreRegion')
        return self


class DescribeCrossRegionBackupsResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        consistent_time: str = None,
        dbinstance_storage_type: str = None,
        cross_backup_id: int = None,
        backup_type: str = None,
        backup_start_time: str = None,
        cross_backup_set_location: str = None,
        instance_id: int = None,
        cross_backup_download_link: str = None,
        backup_end_time: str = None,
        engine_version: str = None,
        backup_set_status: int = None,
        cross_backup_set_file: str = None,
        backup_set_scale: int = None,
        cross_backup_set_size: int = None,
        cross_backup_region: str = None,
        category: str = None,
        engine: str = None,
        backup_method: str = None,
        restore_regions: DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions = None,
    ):
        self.consistent_time = consistent_time
        self.dbinstance_storage_type = dbinstance_storage_type
        self.cross_backup_id = cross_backup_id
        self.backup_type = backup_type
        self.backup_start_time = backup_start_time
        self.cross_backup_set_location = cross_backup_set_location
        self.instance_id = instance_id
        self.cross_backup_download_link = cross_backup_download_link
        self.backup_end_time = backup_end_time
        self.engine_version = engine_version
        self.backup_set_status = backup_set_status
        self.cross_backup_set_file = cross_backup_set_file
        self.backup_set_scale = backup_set_scale
        self.cross_backup_set_size = cross_backup_set_size
        self.cross_backup_region = cross_backup_region
        self.category = category
        self.engine = engine
        self.backup_method = backup_method
        self.restore_regions = restore_regions

    def validate(self):
        if self.restore_regions:
            self.restore_regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.cross_backup_id is not None:
            result['CrossBackupId'] = self.cross_backup_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.cross_backup_set_location is not None:
            result['CrossBackupSetLocation'] = self.cross_backup_set_location
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.cross_backup_download_link is not None:
            result['CrossBackupDownloadLink'] = self.cross_backup_download_link
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.backup_set_status is not None:
            result['BackupSetStatus'] = self.backup_set_status
        if self.cross_backup_set_file is not None:
            result['CrossBackupSetFile'] = self.cross_backup_set_file
        if self.backup_set_scale is not None:
            result['BackupSetScale'] = self.backup_set_scale
        if self.cross_backup_set_size is not None:
            result['CrossBackupSetSize'] = self.cross_backup_set_size
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.category is not None:
            result['Category'] = self.category
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.restore_regions is not None:
            result['RestoreRegions'] = self.restore_regions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('CrossBackupId') is not None:
            self.cross_backup_id = m.get('CrossBackupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('CrossBackupSetLocation') is not None:
            self.cross_backup_set_location = m.get('CrossBackupSetLocation')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CrossBackupDownloadLink') is not None:
            self.cross_backup_download_link = m.get('CrossBackupDownloadLink')
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('BackupSetStatus') is not None:
            self.backup_set_status = m.get('BackupSetStatus')
        if m.get('CrossBackupSetFile') is not None:
            self.cross_backup_set_file = m.get('CrossBackupSetFile')
        if m.get('BackupSetScale') is not None:
            self.backup_set_scale = m.get('BackupSetScale')
        if m.get('CrossBackupSetSize') is not None:
            self.cross_backup_set_size = m.get('CrossBackupSetSize')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('RestoreRegions') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBodyItemsItemRestoreRegions()
            self.restore_regions = temp_model.from_map(m['RestoreRegions'])
        return self


class DescribeCrossRegionBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[DescribeCrossRegionBackupsResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionBackupsResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionBackupsResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        page_number: int = None,
        region_id: str = None,
        items: DescribeCrossRegionBackupsResponseBodyItems = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.page_number = page_number
        self.region_id = region_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeCrossRegionBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCrossRegionBackupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCrossRegionLogBackupFilesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
        cross_backup_region: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id
        self.cross_backup_region = cross_backup_region
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeCrossRegionLogBackupFilesResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        log_begin_time: str = None,
        link_expired_time: str = None,
        cross_intranet_download_link: str = None,
        log_file_name: str = None,
        cross_backup_region: str = None,
        cross_download_link: str = None,
        cross_log_backup_size: int = None,
        instance_id: int = None,
        cross_log_backup_id: int = None,
        log_end_time: str = None,
    ):
        self.log_begin_time = log_begin_time
        self.link_expired_time = link_expired_time
        self.cross_intranet_download_link = cross_intranet_download_link
        self.log_file_name = log_file_name
        self.cross_backup_region = cross_backup_region
        self.cross_download_link = cross_download_link
        self.cross_log_backup_size = cross_log_backup_size
        self.instance_id = instance_id
        self.cross_log_backup_id = cross_log_backup_id
        self.log_end_time = log_end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_begin_time is not None:
            result['LogBeginTime'] = self.log_begin_time
        if self.link_expired_time is not None:
            result['LinkExpiredTime'] = self.link_expired_time
        if self.cross_intranet_download_link is not None:
            result['CrossIntranetDownloadLink'] = self.cross_intranet_download_link
        if self.log_file_name is not None:
            result['LogFileName'] = self.log_file_name
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.cross_download_link is not None:
            result['CrossDownloadLink'] = self.cross_download_link
        if self.cross_log_backup_size is not None:
            result['CrossLogBackupSize'] = self.cross_log_backup_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.cross_log_backup_id is not None:
            result['CrossLogBackupId'] = self.cross_log_backup_id
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogBeginTime') is not None:
            self.log_begin_time = m.get('LogBeginTime')
        if m.get('LinkExpiredTime') is not None:
            self.link_expired_time = m.get('LinkExpiredTime')
        if m.get('CrossIntranetDownloadLink') is not None:
            self.cross_intranet_download_link = m.get('CrossIntranetDownloadLink')
        if m.get('LogFileName') is not None:
            self.log_file_name = m.get('LogFileName')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('CrossDownloadLink') is not None:
            self.cross_download_link = m.get('CrossDownloadLink')
        if m.get('CrossLogBackupSize') is not None:
            self.cross_log_backup_size = m.get('CrossLogBackupSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CrossLogBackupId') is not None:
            self.cross_log_backup_id = m.get('CrossLogBackupId')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        return self


class DescribeCrossRegionLogBackupFilesResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[DescribeCrossRegionLogBackupFilesResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeCrossRegionLogBackupFilesResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeCrossRegionLogBackupFilesResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        dbinstance_id: str = None,
        page_number: int = None,
        region_id: str = None,
        items: DescribeCrossRegionLogBackupFilesResponseBodyItems = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.dbinstance_id = dbinstance_id
        self.page_number = page_number
        self.region_id = region_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Items') is not None:
            temp_model = DescribeCrossRegionLogBackupFilesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeCrossRegionLogBackupFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCrossRegionLogBackupFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCrossRegionLogBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDatabasesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbname: str = None,
        dbstatus: str = None,
        owner_account: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbname = dbname
        self.dbstatus = dbstatus
        self.owner_account = owner_account
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbstatus is not None:
            result['DBStatus'] = self.dbstatus
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBStatus') is not None:
            self.dbstatus = m.get('DBStatus')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeDatabasesResponseBodyDatabasesDatabaseAccountsAccountPrivilegeInfo(TeaModel):
    def __init__(
        self,
        account: str = None,
        account_privilege: str = None,
        account_privilege_detail: str = None,
    ):
        self.account = account
        self.account_privilege = account_privilege
        self.account_privilege_detail = account_privilege_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.account_privilege is not None:
            result['AccountPrivilege'] = self.account_privilege
        if self.account_privilege_detail is not None:
            result['AccountPrivilegeDetail'] = self.account_privilege_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('AccountPrivilege') is not None:
            self.account_privilege = m.get('AccountPrivilege')
        if m.get('AccountPrivilegeDetail') is not None:
            self.account_privilege_detail = m.get('AccountPrivilegeDetail')
        return self


class DescribeDatabasesResponseBodyDatabasesDatabaseAccounts(TeaModel):
    def __init__(
        self,
        account_privilege_info: List[DescribeDatabasesResponseBodyDatabasesDatabaseAccountsAccountPrivilegeInfo] = None,
    ):
        self.account_privilege_info = account_privilege_info

    def validate(self):
        if self.account_privilege_info:
            for k in self.account_privilege_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountPrivilegeInfo'] = []
        if self.account_privilege_info is not None:
            for k in self.account_privilege_info:
                result['AccountPrivilegeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.account_privilege_info = []
        if m.get('AccountPrivilegeInfo') is not None:
            for k in m.get('AccountPrivilegeInfo'):
                temp_model = DescribeDatabasesResponseBodyDatabasesDatabaseAccountsAccountPrivilegeInfo()
                self.account_privilege_info.append(temp_model.from_map(k))
        return self


class DescribeDatabasesResponseBodyDatabasesDatabase(TeaModel):
    def __init__(
        self,
        dbdescription: str = None,
        dbstatus: str = None,
        dbname: str = None,
        dbinstance_id: str = None,
        engine: str = None,
        character_set_name: str = None,
        accounts: DescribeDatabasesResponseBodyDatabasesDatabaseAccounts = None,
    ):
        self.dbdescription = dbdescription
        self.dbstatus = dbstatus
        self.dbname = dbname
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.character_set_name = character_set_name
        self.accounts = accounts

    def validate(self):
        if self.accounts:
            self.accounts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbdescription is not None:
            result['DBDescription'] = self.dbdescription
        if self.dbstatus is not None:
            result['DBStatus'] = self.dbstatus
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.character_set_name is not None:
            result['CharacterSetName'] = self.character_set_name
        if self.accounts is not None:
            result['Accounts'] = self.accounts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBDescription') is not None:
            self.dbdescription = m.get('DBDescription')
        if m.get('DBStatus') is not None:
            self.dbstatus = m.get('DBStatus')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('CharacterSetName') is not None:
            self.character_set_name = m.get('CharacterSetName')
        if m.get('Accounts') is not None:
            temp_model = DescribeDatabasesResponseBodyDatabasesDatabaseAccounts()
            self.accounts = temp_model.from_map(m['Accounts'])
        return self


class DescribeDatabasesResponseBodyDatabases(TeaModel):
    def __init__(
        self,
        database: List[DescribeDatabasesResponseBodyDatabasesDatabase] = None,
    ):
        self.database = database

    def validate(self):
        if self.database:
            for k in self.database:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Database'] = []
        if self.database is not None:
            for k in self.database:
                result['Database'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.database = []
        if m.get('Database') is not None:
            for k in m.get('Database'):
                temp_model = DescribeDatabasesResponseBodyDatabasesDatabase()
                self.database.append(temp_model.from_map(k))
        return self


class DescribeDatabasesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        databases: DescribeDatabasesResponseBodyDatabases = None,
    ):
        self.request_id = request_id
        self.databases = databases

    def validate(self):
        if self.databases:
            self.databases.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.databases is not None:
            result['Databases'] = self.databases.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Databases') is not None:
            temp_model = DescribeDatabasesResponseBodyDatabases()
            self.databases = temp_model.from_map(m['Databases'])
        return self


class DescribeDatabasesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDatabasesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDatabasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceAttributeRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        expired: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.expired = expired

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.expired is not None:
            result['Expired'] = self.expired
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
    ):
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones(TeaModel):
    def __init__(
        self,
        slave_zone: List[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone] = None,
    ):
        self.slave_zone = slave_zone

    def validate(self):
        if self.slave_zone:
            for k in self.slave_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlaveZone'] = []
        if self.slave_zone is not None:
            for k in self.slave_zone:
                result['SlaveZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.slave_zone = []
        if m.get('SlaveZone') is not None:
            for k in m.get('SlaveZone'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZonesSlaveZone()
                self.slave_zone.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds(TeaModel):
    def __init__(
        self,
        read_only_dbinstance_id: List[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId] = None,
    ):
        self.read_only_dbinstance_id = read_only_dbinstance_id

    def validate(self):
        if self.read_only_dbinstance_id:
            for k in self.read_only_dbinstance_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyDBInstanceId'] = []
        if self.read_only_dbinstance_id is not None:
            for k in self.read_only_dbinstance_id:
                result['ReadOnlyDBInstanceId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.read_only_dbinstance_id = []
        if m.get('ReadOnlyDBInstanceId') is not None:
            for k in m.get('ReadOnlyDBInstanceId'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIdsReadOnlyDBInstanceId()
                self.read_only_dbinstance_id.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds(TeaModel):
    def __init__(
        self,
        dbinstance_id: List[str] = None,
    ):
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra(TeaModel):
    def __init__(
        self,
        dbinstance_ids: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds = None,
    ):
        self.dbinstance_ids = dbinstance_ids

    def validate(self):
        if self.dbinstance_ids:
            self.dbinstance_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_ids is not None:
            result['DBInstanceIds'] = self.dbinstance_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceIds') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtraDBInstanceIds()
            self.dbinstance_ids = temp_model.from_map(m['DBInstanceIds'])
        return self


class DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        creation_time: str = None,
        increment_source_dbinstance_id: str = None,
        maintain_time: str = None,
        pay_type: str = None,
        availability_value: str = None,
        engine_version: str = None,
        dedicated_host_group_id: str = None,
        connection_string: str = None,
        super_permission_mode: str = None,
        instance_network_type: str = None,
        master_instance_id: str = None,
        auto_upgrade_minor_version: str = None,
        expire_time: str = None,
        account_max_quantity: int = None,
        master_zone: str = None,
        guard_dbinstance_id: str = None,
        dbinstance_storage: int = None,
        time_zone: str = None,
        latest_kernel_version: str = None,
        tips_level: int = None,
        zone_id: str = None,
        max_connections: int = None,
        dbinstance_id: str = None,
        temp_dbinstance_id: str = None,
        advanced_features: str = None,
        dbinstance_storage_type: str = None,
        dbinstance_memory: int = None,
        console_version: str = None,
        connection_mode: str = None,
        port: str = None,
        lock_mode: str = None,
        general_group_name: str = None,
        vpc_cloud_instance_id: str = None,
        collation: str = None,
        max_iops: int = None,
        tips: str = None,
        security_ipmode: str = None,
        dbinstance_class_type: str = None,
        proxy_type: int = None,
        current_kernel_version: str = None,
        dbinstance_description: str = None,
        dbinstance_cpu: str = None,
        dbinstance_net_type: str = None,
        dbinstance_type: str = None,
        lock_reason: str = None,
        dbinstance_status: str = None,
        dbmax_quantity: int = None,
        region_id: str = None,
        readonly_instance_sqldelayed_time: str = None,
        v_switch_id: str = None,
        resource_group_id: str = None,
        category: str = None,
        dbinstance_class: str = None,
        engine: str = None,
        slave_zones: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones = None,
        read_only_dbinstance_ids: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds = None,
        extra: DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra = None,
    ):
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.increment_source_dbinstance_id = increment_source_dbinstance_id
        self.maintain_time = maintain_time
        self.pay_type = pay_type
        self.availability_value = availability_value
        self.engine_version = engine_version
        self.dedicated_host_group_id = dedicated_host_group_id
        self.connection_string = connection_string
        self.super_permission_mode = super_permission_mode
        self.instance_network_type = instance_network_type
        self.master_instance_id = master_instance_id
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.expire_time = expire_time
        self.account_max_quantity = account_max_quantity
        self.master_zone = master_zone
        self.guard_dbinstance_id = guard_dbinstance_id
        self.dbinstance_storage = dbinstance_storage
        self.time_zone = time_zone
        self.latest_kernel_version = latest_kernel_version
        self.tips_level = tips_level
        self.zone_id = zone_id
        self.max_connections = max_connections
        self.dbinstance_id = dbinstance_id
        self.temp_dbinstance_id = temp_dbinstance_id
        self.advanced_features = advanced_features
        self.dbinstance_storage_type = dbinstance_storage_type
        self.dbinstance_memory = dbinstance_memory
        self.console_version = console_version
        self.connection_mode = connection_mode
        self.port = port
        self.lock_mode = lock_mode
        self.general_group_name = general_group_name
        self.vpc_cloud_instance_id = vpc_cloud_instance_id
        self.collation = collation
        self.max_iops = max_iops
        self.tips = tips
        self.security_ipmode = security_ipmode
        self.dbinstance_class_type = dbinstance_class_type
        self.proxy_type = proxy_type
        self.current_kernel_version = current_kernel_version
        self.dbinstance_description = dbinstance_description
        self.dbinstance_cpu = dbinstance_cpu
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_type = dbinstance_type
        self.lock_reason = lock_reason
        self.dbinstance_status = dbinstance_status
        self.dbmax_quantity = dbmax_quantity
        self.region_id = region_id
        self.readonly_instance_sqldelayed_time = readonly_instance_sqldelayed_time
        self.v_switch_id = v_switch_id
        self.resource_group_id = resource_group_id
        self.category = category
        self.dbinstance_class = dbinstance_class
        self.engine = engine
        self.slave_zones = slave_zones
        self.read_only_dbinstance_ids = read_only_dbinstance_ids
        self.extra = extra

    def validate(self):
        if self.slave_zones:
            self.slave_zones.validate()
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()
        if self.extra:
            self.extra.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.increment_source_dbinstance_id is not None:
            result['IncrementSourceDBInstanceId'] = self.increment_source_dbinstance_id
        if self.maintain_time is not None:
            result['MaintainTime'] = self.maintain_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.availability_value is not None:
            result['AvailabilityValue'] = self.availability_value
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.super_permission_mode is not None:
            result['SuperPermissionMode'] = self.super_permission_mode
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.auto_upgrade_minor_version is not None:
            result['AutoUpgradeMinorVersion'] = self.auto_upgrade_minor_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.account_max_quantity is not None:
            result['AccountMaxQuantity'] = self.account_max_quantity
        if self.master_zone is not None:
            result['MasterZone'] = self.master_zone
        if self.guard_dbinstance_id is not None:
            result['GuardDBInstanceId'] = self.guard_dbinstance_id
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.latest_kernel_version is not None:
            result['LatestKernelVersion'] = self.latest_kernel_version
        if self.tips_level is not None:
            result['TipsLevel'] = self.tips_level
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.max_connections is not None:
            result['MaxConnections'] = self.max_connections
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.advanced_features is not None:
            result['AdvancedFeatures'] = self.advanced_features
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.console_version is not None:
            result['ConsoleVersion'] = self.console_version
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.port is not None:
            result['Port'] = self.port
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.collation is not None:
            result['Collation'] = self.collation
        if self.max_iops is not None:
            result['MaxIOPS'] = self.max_iops
        if self.tips is not None:
            result['Tips'] = self.tips
        if self.security_ipmode is not None:
            result['SecurityIPMode'] = self.security_ipmode
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.proxy_type is not None:
            result['ProxyType'] = self.proxy_type
        if self.current_kernel_version is not None:
            result['CurrentKernelVersion'] = self.current_kernel_version
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_cpu is not None:
            result['DBInstanceCPU'] = self.dbinstance_cpu
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbmax_quantity is not None:
            result['DBMaxQuantity'] = self.dbmax_quantity
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.readonly_instance_sqldelayed_time is not None:
            result['ReadonlyInstanceSQLDelayedTime'] = self.readonly_instance_sqldelayed_time
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category is not None:
            result['Category'] = self.category
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.slave_zones is not None:
            result['SlaveZones'] = self.slave_zones.to_map()
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        if self.extra is not None:
            result['Extra'] = self.extra.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('IncrementSourceDBInstanceId') is not None:
            self.increment_source_dbinstance_id = m.get('IncrementSourceDBInstanceId')
        if m.get('MaintainTime') is not None:
            self.maintain_time = m.get('MaintainTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('AvailabilityValue') is not None:
            self.availability_value = m.get('AvailabilityValue')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('SuperPermissionMode') is not None:
            self.super_permission_mode = m.get('SuperPermissionMode')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('AutoUpgradeMinorVersion') is not None:
            self.auto_upgrade_minor_version = m.get('AutoUpgradeMinorVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('AccountMaxQuantity') is not None:
            self.account_max_quantity = m.get('AccountMaxQuantity')
        if m.get('MasterZone') is not None:
            self.master_zone = m.get('MasterZone')
        if m.get('GuardDBInstanceId') is not None:
            self.guard_dbinstance_id = m.get('GuardDBInstanceId')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('LatestKernelVersion') is not None:
            self.latest_kernel_version = m.get('LatestKernelVersion')
        if m.get('TipsLevel') is not None:
            self.tips_level = m.get('TipsLevel')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('MaxConnections') is not None:
            self.max_connections = m.get('MaxConnections')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('AdvancedFeatures') is not None:
            self.advanced_features = m.get('AdvancedFeatures')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('ConsoleVersion') is not None:
            self.console_version = m.get('ConsoleVersion')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('Collation') is not None:
            self.collation = m.get('Collation')
        if m.get('MaxIOPS') is not None:
            self.max_iops = m.get('MaxIOPS')
        if m.get('Tips') is not None:
            self.tips = m.get('Tips')
        if m.get('SecurityIPMode') is not None:
            self.security_ipmode = m.get('SecurityIPMode')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('ProxyType') is not None:
            self.proxy_type = m.get('ProxyType')
        if m.get('CurrentKernelVersion') is not None:
            self.current_kernel_version = m.get('CurrentKernelVersion')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceCPU') is not None:
            self.dbinstance_cpu = m.get('DBInstanceCPU')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBMaxQuantity') is not None:
            self.dbmax_quantity = m.get('DBMaxQuantity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReadonlyInstanceSQLDelayedTime') is not None:
            self.readonly_instance_sqldelayed_time = m.get('ReadonlyInstanceSQLDelayedTime')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('SlaveZones') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeSlaveZones()
            self.slave_zones = temp_model.from_map(m['SlaveZones'])
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        if m.get('Extra') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttributeExtra()
            self.extra = temp_model.from_map(m['Extra'])
        return self


class DescribeDBInstanceAttributeResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_attribute: List[DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute] = None,
    ):
        self.dbinstance_attribute = dbinstance_attribute

    def validate(self):
        if self.dbinstance_attribute:
            for k in self.dbinstance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAttribute'] = []
        if self.dbinstance_attribute is not None:
            for k in self.dbinstance_attribute:
                result['DBInstanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_attribute = []
        if m.get('DBInstanceAttribute') is not None:
            for k in m.get('DBInstanceAttribute'):
                temp_model = DescribeDBInstanceAttributeResponseBodyItemsDBInstanceAttribute()
                self.dbinstance_attribute.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceAttributeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        items: DescribeDBInstanceAttributeResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstanceAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceDetailRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceDetailResponseBody(TeaModel):
    def __init__(
        self,
        activation_state: str = None,
        dbinstance_id: str = None,
        license_type: str = None,
        request_id: str = None,
        region_id: str = None,
    ):
        self.activation_state = activation_state
        self.dbinstance_id = dbinstance_id
        self.license_type = license_type
        self.request_id = request_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_state is not None:
            result['ActivationState'] = self.activation_state
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.license_type is not None:
            result['LicenseType'] = self.license_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActivationState') is not None:
            self.activation_state = m.get('ActivationState')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('LicenseType') is not None:
            self.license_type = m.get('LicenseType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBInstanceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceEncryptionKeyRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        region_id: str = None,
        dbinstance_id: str = None,
        encryption_key: str = None,
        target_region_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.encryption_key = encryption_key
        self.target_region_id = target_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.target_region_id is not None:
            result['TargetRegionId'] = self.target_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('TargetRegionId') is not None:
            self.target_region_id = m.get('TargetRegionId')
        return self


class DescribeDBInstanceEncryptionKeyResponseBody(TeaModel):
    def __init__(
        self,
        delete_date: str = None,
        request_id: str = None,
        description: str = None,
        origin: str = None,
        material_expire_time: str = None,
        encryption_key_status: str = None,
        key_usage: str = None,
        encryption_key: str = None,
        creator: str = None,
    ):
        self.delete_date = delete_date
        self.request_id = request_id
        self.description = description
        self.origin = origin
        self.material_expire_time = material_expire_time
        self.encryption_key_status = encryption_key_status
        self.key_usage = key_usage
        self.encryption_key = encryption_key
        self.creator = creator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_date is not None:
            result['DeleteDate'] = self.delete_date
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.origin is not None:
            result['Origin'] = self.origin
        if self.material_expire_time is not None:
            result['MaterialExpireTime'] = self.material_expire_time
        if self.encryption_key_status is not None:
            result['EncryptionKeyStatus'] = self.encryption_key_status
        if self.key_usage is not None:
            result['KeyUsage'] = self.key_usage
        if self.encryption_key is not None:
            result['EncryptionKey'] = self.encryption_key
        if self.creator is not None:
            result['Creator'] = self.creator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteDate') is not None:
            self.delete_date = m.get('DeleteDate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Origin') is not None:
            self.origin = m.get('Origin')
        if m.get('MaterialExpireTime') is not None:
            self.material_expire_time = m.get('MaterialExpireTime')
        if m.get('EncryptionKeyStatus') is not None:
            self.encryption_key_status = m.get('EncryptionKeyStatus')
        if m.get('KeyUsage') is not None:
            self.key_usage = m.get('KeyUsage')
        if m.get('EncryptionKey') is not None:
            self.encryption_key = m.get('EncryptionKey')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        return self


class DescribeDBInstanceEncryptionKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceEncryptionKeyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceEncryptionKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceHAConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo(TeaModel):
    def __init__(
        self,
        log_sync_time: str = None,
        node_type: str = None,
        zone_id: str = None,
        sync_status: str = None,
        data_sync_time: str = None,
        node_id: str = None,
        region_id: str = None,
    ):
        self.log_sync_time = log_sync_time
        self.node_type = node_type
        self.zone_id = zone_id
        self.sync_status = sync_status
        self.data_sync_time = data_sync_time
        self.node_id = node_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_sync_time is not None:
            result['LogSyncTime'] = self.log_sync_time
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        if self.data_sync_time is not None:
            result['DataSyncTime'] = self.data_sync_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogSyncTime') is not None:
            self.log_sync_time = m.get('LogSyncTime')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        if m.get('DataSyncTime') is not None:
            self.data_sync_time = m.get('DataSyncTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos(TeaModel):
    def __init__(
        self,
        node_info: List[DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo] = None,
    ):
        self.node_info = node_info

    def validate(self):
        if self.node_info:
            for k in self.node_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInfo'] = []
        if self.node_info is not None:
            for k in self.node_info:
                result['NodeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_info = []
        if m.get('NodeInfo') is not None:
            for k in m.get('NodeInfo'):
                temp_model = DescribeDBInstanceHAConfigResponseBodyHostInstanceInfosNodeInfo()
                self.node_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceHAConfigResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        hamode: str = None,
        sync_mode: str = None,
        host_instance_infos: DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.hamode = hamode
        self.sync_mode = sync_mode
        self.host_instance_infos = host_instance_infos

    def validate(self):
        if self.host_instance_infos:
            self.host_instance_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.hamode is not None:
            result['HAMode'] = self.hamode
        if self.sync_mode is not None:
            result['SyncMode'] = self.sync_mode
        if self.host_instance_infos is not None:
            result['HostInstanceInfos'] = self.host_instance_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HAMode') is not None:
            self.hamode = m.get('HAMode')
        if m.get('SyncMode') is not None:
            self.sync_mode = m.get('SyncMode')
        if m.get('HostInstanceInfos') is not None:
            temp_model = DescribeDBInstanceHAConfigResponseBodyHostInstanceInfos()
            self.host_instance_infos = temp_model.from_map(m['HostInstanceInfos'])
        return self


class DescribeDBInstanceHAConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceHAConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceHAConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIPArrayListRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
        whitelist_network_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account
        self.whitelist_network_type = whitelist_network_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.whitelist_network_type is not None:
            result['WhitelistNetworkType'] = self.whitelist_network_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('WhitelistNetworkType') is not None:
            self.whitelist_network_type = m.get('WhitelistNetworkType')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray(TeaModel):
    def __init__(
        self,
        dbinstance_iparray_attribute: str = None,
        dbinstance_iparray_name: str = None,
        security_iptype: str = None,
        security_iplist: str = None,
    ):
        self.dbinstance_iparray_attribute = dbinstance_iparray_attribute
        self.dbinstance_iparray_name = dbinstance_iparray_name
        self.security_iptype = security_iptype
        self.security_iplist = security_iplist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_iparray_attribute is not None:
            result['DBInstanceIPArrayAttribute'] = self.dbinstance_iparray_attribute
        if self.dbinstance_iparray_name is not None:
            result['DBInstanceIPArrayName'] = self.dbinstance_iparray_name
        if self.security_iptype is not None:
            result['SecurityIPType'] = self.security_iptype
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceIPArrayAttribute') is not None:
            self.dbinstance_iparray_attribute = m.get('DBInstanceIPArrayAttribute')
        if m.get('DBInstanceIPArrayName') is not None:
            self.dbinstance_iparray_name = m.get('DBInstanceIPArrayName')
        if m.get('SecurityIPType') is not None:
            self.security_iptype = m.get('SecurityIPType')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        return self


class DescribeDBInstanceIPArrayListResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_iparray: List[DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray] = None,
    ):
        self.dbinstance_iparray = dbinstance_iparray

    def validate(self):
        if self.dbinstance_iparray:
            for k in self.dbinstance_iparray:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceIPArray'] = []
        if self.dbinstance_iparray is not None:
            for k in self.dbinstance_iparray:
                result['DBInstanceIPArray'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_iparray = []
        if m.get('DBInstanceIPArray') is not None:
            for k in m.get('DBInstanceIPArray'):
                temp_model = DescribeDBInstanceIPArrayListResponseBodyItemsDBInstanceIPArray()
                self.dbinstance_iparray.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceIPArrayListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        items: DescribeDBInstanceIPArrayListResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstanceIPArrayListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceIPArrayListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIPArrayListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceIpHostnameRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBInstanceIpHostnameResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        ip_hostname_infos: str = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.ip_hostname_infos = ip_hostname_infos

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_hostname_infos is not None:
            result['IpHostnameInfos'] = self.ip_hostname_infos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpHostnameInfos') is not None:
            self.ip_hostname_infos = m.get('IpHostnameInfos')
        return self


class DescribeDBInstanceIpHostnameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceIpHostnameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceIpHostnameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceMetricsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_name = dbinstance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        return self


class DescribeDBInstanceMetricsResponseBodyItems(TeaModel):
    def __init__(
        self,
        group_key: str = None,
        sort_rule: int = None,
        description: str = None,
        unit: str = None,
        metrics_key: str = None,
        group_key_type: str = None,
        method: str = None,
        dimension: str = None,
        metrics_key_alias: str = None,
    ):
        self.group_key = group_key
        self.sort_rule = sort_rule
        self.description = description
        self.unit = unit
        self.metrics_key = metrics_key
        self.group_key_type = group_key_type
        self.method = method
        self.dimension = dimension
        self.metrics_key_alias = metrics_key_alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_key is not None:
            result['GroupKey'] = self.group_key
        if self.sort_rule is not None:
            result['SortRule'] = self.sort_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metrics_key is not None:
            result['MetricsKey'] = self.metrics_key
        if self.group_key_type is not None:
            result['GroupKeyType'] = self.group_key_type
        if self.method is not None:
            result['Method'] = self.method
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.metrics_key_alias is not None:
            result['MetricsKeyAlias'] = self.metrics_key_alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupKey') is not None:
            self.group_key = m.get('GroupKey')
        if m.get('SortRule') is not None:
            self.sort_rule = m.get('SortRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricsKey') is not None:
            self.metrics_key = m.get('MetricsKey')
        if m.get('GroupKeyType') is not None:
            self.group_key_type = m.get('GroupKeyType')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('MetricsKeyAlias') is not None:
            self.metrics_key_alias = m.get('MetricsKeyAlias')
        return self


class DescribeDBInstanceMetricsResponseBody(TeaModel):
    def __init__(
        self,
        total_record_count: int = None,
        request_id: str = None,
        items: List[DescribeDBInstanceMetricsResponseBodyItems] = None,
    ):
        self.total_record_count = total_record_count
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeDBInstanceMetricsResponseBodyItems()
                self.items.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceMetricsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceMetricsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceMonitorRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstanceMonitorResponseBody(TeaModel):
    def __init__(
        self,
        period: str = None,
        request_id: str = None,
    ):
        self.period = period
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDBInstanceMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceMonitorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceNetInfoRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        flag: int = None,
        dbinstance_net_rwsplit_type: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.flag = flag
        self.dbinstance_net_rwsplit_type = dbinstance_net_rwsplit_type
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.dbinstance_net_rwsplit_type is not None:
            result['DBInstanceNetRWSplitType'] = self.dbinstance_net_rwsplit_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('DBInstanceNetRWSplitType') is not None:
            self.dbinstance_net_rwsplit_type = m.get('DBInstanceNetRWSplitType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup(TeaModel):
    def __init__(
        self,
        security_ips: str = None,
        security_ipgroup_name: str = None,
    ):
        self.security_ips = security_ips
        self.security_ipgroup_name = security_ipgroup_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_ips is not None:
            result['SecurityIPs'] = self.security_ips
        if self.security_ipgroup_name is not None:
            result['SecurityIPGroupName'] = self.security_ipgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityIPs') is not None:
            self.security_ips = m.get('SecurityIPs')
        if m.get('SecurityIPGroupName') is not None:
            self.security_ipgroup_name = m.get('SecurityIPGroupName')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups(TeaModel):
    def __init__(
        self,
        security_ipgroup: List[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup] = None,
    ):
        self.security_ipgroup = security_ipgroup

    def validate(self):
        if self.security_ipgroup:
            for k in self.security_ipgroup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['securityIPGroup'] = []
        if self.security_ipgroup is not None:
            for k in self.security_ipgroup:
                result['securityIPGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.security_ipgroup = []
        if m.get('securityIPGroup') is not None:
            for k in m.get('securityIPGroup'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroupsSecurityIPGroup()
                self.security_ipgroup.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight(TeaModel):
    def __init__(
        self,
        availability: str = None,
        weight: str = None,
        dbinstance_id: str = None,
        role: str = None,
        dbinstance_type: str = None,
    ):
        self.availability = availability
        self.weight = weight
        self.dbinstance_id = dbinstance_id
        self.role = role
        self.dbinstance_type = dbinstance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability is not None:
            result['Availability'] = self.availability
        if self.weight is not None:
            result['Weight'] = self.weight
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.role is not None:
            result['Role'] = self.role
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Availability') is not None:
            self.availability = m.get('Availability')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights(TeaModel):
    def __init__(
        self,
        dbinstance_weight: List[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight] = None,
    ):
        self.dbinstance_weight = dbinstance_weight

    def validate(self):
        if self.dbinstance_weight:
            for k in self.dbinstance_weight:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceWeight'] = []
        if self.dbinstance_weight is not None:
            for k in self.dbinstance_weight:
                result['DBInstanceWeight'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_weight = []
        if m.get('DBInstanceWeight') is not None:
            for k in m.get('DBInstanceWeight'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeightsDBInstanceWeight()
                self.dbinstance_weight.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo(TeaModel):
    def __init__(
        self,
        v_switch_id: str = None,
        connection_string_type: str = None,
        connection_string: str = None,
        expired_time: str = None,
        upgradeable: str = None,
        max_delay_time: str = None,
        iptype: str = None,
        port: str = None,
        vpcid: str = None,
        distribution_type: str = None,
        ipaddress: str = None,
        security_ipgroups: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups = None,
        dbinstance_weights: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights = None,
    ):
        self.v_switch_id = v_switch_id
        self.connection_string_type = connection_string_type
        self.connection_string = connection_string
        self.expired_time = expired_time
        self.upgradeable = upgradeable
        self.max_delay_time = max_delay_time
        self.iptype = iptype
        self.port = port
        self.vpcid = vpcid
        self.distribution_type = distribution_type
        self.ipaddress = ipaddress
        self.security_ipgroups = security_ipgroups
        self.dbinstance_weights = dbinstance_weights

    def validate(self):
        if self.security_ipgroups:
            self.security_ipgroups.validate()
        if self.dbinstance_weights:
            self.dbinstance_weights.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.connection_string_type is not None:
            result['ConnectionStringType'] = self.connection_string_type
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.upgradeable is not None:
            result['Upgradeable'] = self.upgradeable
        if self.max_delay_time is not None:
            result['MaxDelayTime'] = self.max_delay_time
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.port is not None:
            result['Port'] = self.port
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.distribution_type is not None:
            result['DistributionType'] = self.distribution_type
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.security_ipgroups is not None:
            result['SecurityIPGroups'] = self.security_ipgroups.to_map()
        if self.dbinstance_weights is not None:
            result['DBInstanceWeights'] = self.dbinstance_weights.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ConnectionStringType') is not None:
            self.connection_string_type = m.get('ConnectionStringType')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('Upgradeable') is not None:
            self.upgradeable = m.get('Upgradeable')
        if m.get('MaxDelayTime') is not None:
            self.max_delay_time = m.get('MaxDelayTime')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('DistributionType') is not None:
            self.distribution_type = m.get('DistributionType')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('SecurityIPGroups') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoSecurityIPGroups()
            self.security_ipgroups = temp_model.from_map(m['SecurityIPGroups'])
        if m.get('DBInstanceWeights') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfoDBInstanceWeights()
            self.dbinstance_weights = temp_model.from_map(m['DBInstanceWeights'])
        return self


class DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos(TeaModel):
    def __init__(
        self,
        dbinstance_net_info: List[DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo] = None,
    ):
        self.dbinstance_net_info = dbinstance_net_info

    def validate(self):
        if self.dbinstance_net_info:
            for k in self.dbinstance_net_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceNetInfo'] = []
        if self.dbinstance_net_info is not None:
            for k in self.dbinstance_net_info:
                result['DBInstanceNetInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_net_info = []
        if m.get('DBInstanceNetInfo') is not None:
            for k in m.get('DBInstanceNetInfo'):
                temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfosDBInstanceNetInfo()
                self.dbinstance_net_info.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceNetInfoResponseBody(TeaModel):
    def __init__(
        self,
        security_ipmode: str = None,
        request_id: str = None,
        instance_network_type: str = None,
        dbinstance_net_infos: DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos = None,
    ):
        self.security_ipmode = security_ipmode
        self.request_id = request_id
        self.instance_network_type = instance_network_type
        self.dbinstance_net_infos = dbinstance_net_infos

    def validate(self):
        if self.dbinstance_net_infos:
            self.dbinstance_net_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_ipmode is not None:
            result['SecurityIPMode'] = self.security_ipmode
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.dbinstance_net_infos is not None:
            result['DBInstanceNetInfos'] = self.dbinstance_net_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityIPMode') is not None:
            self.security_ipmode = m.get('SecurityIPMode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('DBInstanceNetInfos') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBodyDBInstanceNetInfos()
            self.dbinstance_net_infos = temp_model.from_map(m['DBInstanceNetInfos'])
        return self


class DescribeDBInstanceNetInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceNetInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceNetInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancePerformanceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        key: str = None,
        start_time: str = None,
        end_time: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.key = key
        self.start_time = start_time
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.key is not None:
            result['Key'] = self.key
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue(TeaModel):
    def __init__(
        self,
        date: str = None,
        value: str = None,
    ):
        self.date = date
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues(TeaModel):
    def __init__(
        self,
        performance_value: List[DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue] = None,
    ):
        self.performance_value = performance_value

    def validate(self):
        if self.performance_value:
            for k in self.performance_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceValue'] = []
        if self.performance_value is not None:
            for k in self.performance_value:
                result['PerformanceValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performance_value = []
        if m.get('PerformanceValue') is not None:
            for k in m.get('PerformanceValue'):
                temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue()
                self.performance_value.append(temp_model.from_map(k))
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey(TeaModel):
    def __init__(
        self,
        key: str = None,
        value_format: str = None,
        unit: str = None,
        values: DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues = None,
    ):
        self.key = key
        self.value_format = value_format
        self.unit = unit
        self.values = values

    def validate(self):
        if self.values:
            self.values.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.values is not None:
            result['Values'] = self.values.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Values') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKeyValues()
            self.values = temp_model.from_map(m['Values'])
        return self


class DescribeDBInstancePerformanceResponseBodyPerformanceKeys(TeaModel):
    def __init__(
        self,
        performance_key: List[DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey] = None,
    ):
        self.performance_key = performance_key

    def validate(self):
        if self.performance_key:
            for k in self.performance_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceKey'] = []
        if self.performance_key is not None:
            for k in self.performance_key:
                result['PerformanceKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performance_key = []
        if m.get('PerformanceKey') is not None:
            for k in m.get('PerformanceKey'):
                temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeysPerformanceKey()
                self.performance_key.append(temp_model.from_map(k))
        return self


class DescribeDBInstancePerformanceResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        dbinstance_id: str = None,
        engine: str = None,
        request_id: str = None,
        performance_keys: DescribeDBInstancePerformanceResponseBodyPerformanceKeys = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.request_id = request_id
        self.performance_keys = performance_keys

    def validate(self):
        if self.performance_keys:
            self.performance_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.performance_keys is not None:
            result['PerformanceKeys'] = self.performance_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PerformanceKeys') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBodyPerformanceKeys()
            self.performance_keys = temp_model.from_map(m['PerformanceKeys'])
        return self


class DescribeDBInstancePerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancePerformanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceProxyConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstanceProxyConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        persistent_connections_configuration: str = None,
        attacks_protection_configuration: str = None,
        request_id: str = None,
        transparent_switch_configuration: str = None,
    ):
        self.persistent_connections_configuration = persistent_connections_configuration
        self.attacks_protection_configuration = attacks_protection_configuration
        self.request_id = request_id
        self.transparent_switch_configuration = transparent_switch_configuration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.persistent_connections_configuration is not None:
            result['PersistentConnectionsConfiguration'] = self.persistent_connections_configuration
        if self.attacks_protection_configuration is not None:
            result['AttacksProtectionConfiguration'] = self.attacks_protection_configuration
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transparent_switch_configuration is not None:
            result['TransparentSwitchConfiguration'] = self.transparent_switch_configuration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PersistentConnectionsConfiguration') is not None:
            self.persistent_connections_configuration = m.get('PersistentConnectionsConfiguration')
        if m.get('AttacksProtectionConfiguration') is not None:
            self.attacks_protection_configuration = m.get('AttacksProtectionConfiguration')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransparentSwitchConfiguration') is not None:
            self.transparent_switch_configuration = m.get('TransparentSwitchConfiguration')
        return self


class DescribeDBInstanceProxyConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceProxyConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceProxyConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        proxy_id: str = None,
        engine: str = None,
        zone_id: str = None,
        resource_group_id: str = None,
        dbinstance_status: str = None,
        expired: str = None,
        search_key: str = None,
        dbinstance_id: str = None,
        dbinstance_type: str = None,
        region_id: str = None,
        page_size: int = None,
        page_number: int = None,
        instance_network_type: str = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        dbinstance_class: str = None,
        engine_version: str = None,
        pay_type: str = None,
        connection_mode: str = None,
        tags: str = None,
        owner_account: str = None,
        dedicated_host_group_id: str = None,
        dedicated_host_id: str = None,
        instance_level: int = None,
        connection_string: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.proxy_id = proxy_id
        self.engine = engine
        self.zone_id = zone_id
        self.resource_group_id = resource_group_id
        self.dbinstance_status = dbinstance_status
        self.expired = expired
        self.search_key = search_key
        self.dbinstance_id = dbinstance_id
        self.dbinstance_type = dbinstance_type
        self.region_id = region_id
        self.page_size = page_size
        self.page_number = page_number
        self.instance_network_type = instance_network_type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.dbinstance_class = dbinstance_class
        self.engine_version = engine_version
        self.pay_type = pay_type
        self.connection_mode = connection_mode
        self.tags = tags
        self.owner_account = owner_account
        self.dedicated_host_group_id = dedicated_host_group_id
        self.dedicated_host_id = dedicated_host_id
        self.instance_level = instance_level
        self.connection_string = connection_string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.instance_level is not None:
            result['InstanceLevel'] = self.instance_level
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('InstanceLevel') is not None:
            self.instance_level = m.get('InstanceLevel')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        return self


class DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIds(TeaModel):
    def __init__(
        self,
        read_only_dbinstance_id: List[DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId] = None,
    ):
        self.read_only_dbinstance_id = read_only_dbinstance_id

    def validate(self):
        if self.read_only_dbinstance_id:
            for k in self.read_only_dbinstance_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyDBInstanceId'] = []
        if self.read_only_dbinstance_id is not None:
            for k in self.read_only_dbinstance_id:
                result['ReadOnlyDBInstanceId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.read_only_dbinstance_id = []
        if m.get('ReadOnlyDBInstanceId') is not None:
            for k in m.get('ReadOnlyDBInstanceId'):
                temp_model = DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId()
                self.read_only_dbinstance_id.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesResponseBodyItemsDBInstance(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        dedicated_host_id_for_log: str = None,
        create_time: str = None,
        pay_type: str = None,
        dedicated_host_name_for_log: str = None,
        mutri_orsignle: bool = None,
        dedicated_host_group_name: str = None,
        engine_version: str = None,
        dedicated_host_group_id: str = None,
        vpc_name: str = None,
        dedicated_host_zone_id_for_master: str = None,
        connection_string: str = None,
        instance_network_type: str = None,
        master_instance_id: str = None,
        auto_upgrade_minor_version: str = None,
        expire_time: str = None,
        destroy_time: str = None,
        guard_dbinstance_id: str = None,
        dedicated_host_name_for_master: str = None,
        zone_id: str = None,
        tips_level: int = None,
        dbinstance_id: str = None,
        dedicated_host_id_for_master: str = None,
        temp_dbinstance_id: str = None,
        dbinstance_storage_type: str = None,
        connection_mode: str = None,
        lock_mode: str = None,
        general_group_name: str = None,
        vpc_cloud_instance_id: str = None,
        dedicated_host_zone_id_for_slave: str = None,
        tips: str = None,
        dedicated_host_zone_id_for_log: str = None,
        dedicated_host_name_for_slave: str = None,
        dbinstance_description: str = None,
        dbinstance_net_type: str = None,
        dbinstance_type: str = None,
        lock_reason: str = None,
        dbinstance_status: str = None,
        region_id: str = None,
        v_switch_id: str = None,
        dedicated_host_id_for_slave: str = None,
        resource_group_id: str = None,
        category: str = None,
        engine: str = None,
        dbinstance_class: str = None,
        switch_weight: int = None,
        read_only_dbinstance_ids: DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIds = None,
    ):
        self.vpc_id = vpc_id
        self.dedicated_host_id_for_log = dedicated_host_id_for_log
        self.create_time = create_time
        self.pay_type = pay_type
        self.dedicated_host_name_for_log = dedicated_host_name_for_log
        self.mutri_orsignle = mutri_orsignle
        self.dedicated_host_group_name = dedicated_host_group_name
        self.engine_version = engine_version
        self.dedicated_host_group_id = dedicated_host_group_id
        self.vpc_name = vpc_name
        self.dedicated_host_zone_id_for_master = dedicated_host_zone_id_for_master
        self.connection_string = connection_string
        self.instance_network_type = instance_network_type
        self.master_instance_id = master_instance_id
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.expire_time = expire_time
        self.destroy_time = destroy_time
        self.guard_dbinstance_id = guard_dbinstance_id
        self.dedicated_host_name_for_master = dedicated_host_name_for_master
        self.zone_id = zone_id
        self.tips_level = tips_level
        self.dbinstance_id = dbinstance_id
        self.dedicated_host_id_for_master = dedicated_host_id_for_master
        self.temp_dbinstance_id = temp_dbinstance_id
        self.dbinstance_storage_type = dbinstance_storage_type
        self.connection_mode = connection_mode
        self.lock_mode = lock_mode
        self.general_group_name = general_group_name
        self.vpc_cloud_instance_id = vpc_cloud_instance_id
        self.dedicated_host_zone_id_for_slave = dedicated_host_zone_id_for_slave
        self.tips = tips
        self.dedicated_host_zone_id_for_log = dedicated_host_zone_id_for_log
        self.dedicated_host_name_for_slave = dedicated_host_name_for_slave
        self.dbinstance_description = dbinstance_description
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_type = dbinstance_type
        self.lock_reason = lock_reason
        self.dbinstance_status = dbinstance_status
        self.region_id = region_id
        self.v_switch_id = v_switch_id
        self.dedicated_host_id_for_slave = dedicated_host_id_for_slave
        self.resource_group_id = resource_group_id
        self.category = category
        self.engine = engine
        self.dbinstance_class = dbinstance_class
        self.switch_weight = switch_weight
        self.read_only_dbinstance_ids = read_only_dbinstance_ids

    def validate(self):
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.dedicated_host_id_for_log is not None:
            result['DedicatedHostIdForLog'] = self.dedicated_host_id_for_log
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.dedicated_host_name_for_log is not None:
            result['DedicatedHostNameForLog'] = self.dedicated_host_name_for_log
        if self.mutri_orsignle is not None:
            result['MutriORsignle'] = self.mutri_orsignle
        if self.dedicated_host_group_name is not None:
            result['DedicatedHostGroupName'] = self.dedicated_host_group_name
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.dedicated_host_zone_id_for_master is not None:
            result['DedicatedHostZoneIdForMaster'] = self.dedicated_host_zone_id_for_master
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.auto_upgrade_minor_version is not None:
            result['AutoUpgradeMinorVersion'] = self.auto_upgrade_minor_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.destroy_time is not None:
            result['DestroyTime'] = self.destroy_time
        if self.guard_dbinstance_id is not None:
            result['GuardDBInstanceId'] = self.guard_dbinstance_id
        if self.dedicated_host_name_for_master is not None:
            result['DedicatedHostNameForMaster'] = self.dedicated_host_name_for_master
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.tips_level is not None:
            result['TipsLevel'] = self.tips_level
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dedicated_host_id_for_master is not None:
            result['DedicatedHostIdForMaster'] = self.dedicated_host_id_for_master
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.general_group_name is not None:
            result['GeneralGroupName'] = self.general_group_name
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.dedicated_host_zone_id_for_slave is not None:
            result['DedicatedHostZoneIdForSlave'] = self.dedicated_host_zone_id_for_slave
        if self.tips is not None:
            result['Tips'] = self.tips
        if self.dedicated_host_zone_id_for_log is not None:
            result['DedicatedHostZoneIdForLog'] = self.dedicated_host_zone_id_for_log
        if self.dedicated_host_name_for_slave is not None:
            result['DedicatedHostNameForSlave'] = self.dedicated_host_name_for_slave
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.dedicated_host_id_for_slave is not None:
            result['DedicatedHostIdForSlave'] = self.dedicated_host_id_for_slave
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category is not None:
            result['Category'] = self.category
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.switch_weight is not None:
            result['SwitchWeight'] = self.switch_weight
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('DedicatedHostIdForLog') is not None:
            self.dedicated_host_id_for_log = m.get('DedicatedHostIdForLog')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DedicatedHostNameForLog') is not None:
            self.dedicated_host_name_for_log = m.get('DedicatedHostNameForLog')
        if m.get('MutriORsignle') is not None:
            self.mutri_orsignle = m.get('MutriORsignle')
        if m.get('DedicatedHostGroupName') is not None:
            self.dedicated_host_group_name = m.get('DedicatedHostGroupName')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('DedicatedHostZoneIdForMaster') is not None:
            self.dedicated_host_zone_id_for_master = m.get('DedicatedHostZoneIdForMaster')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('AutoUpgradeMinorVersion') is not None:
            self.auto_upgrade_minor_version = m.get('AutoUpgradeMinorVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('DestroyTime') is not None:
            self.destroy_time = m.get('DestroyTime')
        if m.get('GuardDBInstanceId') is not None:
            self.guard_dbinstance_id = m.get('GuardDBInstanceId')
        if m.get('DedicatedHostNameForMaster') is not None:
            self.dedicated_host_name_for_master = m.get('DedicatedHostNameForMaster')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('TipsLevel') is not None:
            self.tips_level = m.get('TipsLevel')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DedicatedHostIdForMaster') is not None:
            self.dedicated_host_id_for_master = m.get('DedicatedHostIdForMaster')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('GeneralGroupName') is not None:
            self.general_group_name = m.get('GeneralGroupName')
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('DedicatedHostZoneIdForSlave') is not None:
            self.dedicated_host_zone_id_for_slave = m.get('DedicatedHostZoneIdForSlave')
        if m.get('Tips') is not None:
            self.tips = m.get('Tips')
        if m.get('DedicatedHostZoneIdForLog') is not None:
            self.dedicated_host_zone_id_for_log = m.get('DedicatedHostZoneIdForLog')
        if m.get('DedicatedHostNameForSlave') is not None:
            self.dedicated_host_name_for_slave = m.get('DedicatedHostNameForSlave')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('DedicatedHostIdForSlave') is not None:
            self.dedicated_host_id_for_slave = m.get('DedicatedHostIdForSlave')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('SwitchWeight') is not None:
            self.switch_weight = m.get('SwitchWeight')
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDBInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        return self


class DescribeDBInstancesResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance: List[DescribeDBInstancesResponseBodyItemsDBInstance] = None,
    ):
        self.dbinstance = dbinstance

    def validate(self):
        if self.dbinstance:
            for k in self.dbinstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstance'] = []
        if self.dbinstance is not None:
            for k in self.dbinstance:
                result['DBInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance = []
        if m.get('DBInstance') is not None:
            for k in m.get('DBInstance'):
                temp_model = DescribeDBInstancesResponseBodyItemsDBInstance()
                self.dbinstance.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeDBInstancesResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesAsCsvRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstancesAsCsvResponseBodyItemsDBInstanceAttribute(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        creation_time: str = None,
        temp_dbinstance_id: str = None,
        support_upgrade_account_type: str = None,
        increment_source_dbinstance_id: str = None,
        dbinstance_memory: int = None,
        maintain_time: str = None,
        pay_type: str = None,
        tags: str = None,
        availability_value: str = None,
        read_delay_time: str = None,
        connection_mode: str = None,
        port: str = None,
        account_type: str = None,
        lock_mode: str = None,
        engine_version: str = None,
        max_iops: int = None,
        connection_string: str = None,
        instance_network_type: str = None,
        security_iplist: str = None,
        master_instance_id: str = None,
        dbinstance_class_type: str = None,
        dbinstance_description: str = None,
        dbinstance_cpu: str = None,
        expire_time: str = None,
        dbinstance_net_type: str = None,
        dbinstance_type: str = None,
        account_max_quantity: int = None,
        lock_reason: str = None,
        dbinstance_status: str = None,
        dbmax_quantity: int = None,
        guard_dbinstance_id: str = None,
        region_id: str = None,
        dbinstance_storage: int = None,
        v_switch_id: str = None,
        zone_id: str = None,
        category: str = None,
        max_connections: int = None,
        dbinstance_id: str = None,
        dbinstance_class: str = None,
        engine: str = None,
    ):
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.temp_dbinstance_id = temp_dbinstance_id
        self.support_upgrade_account_type = support_upgrade_account_type
        self.increment_source_dbinstance_id = increment_source_dbinstance_id
        self.dbinstance_memory = dbinstance_memory
        self.maintain_time = maintain_time
        self.pay_type = pay_type
        self.tags = tags
        self.availability_value = availability_value
        self.read_delay_time = read_delay_time
        self.connection_mode = connection_mode
        self.port = port
        self.account_type = account_type
        self.lock_mode = lock_mode
        self.engine_version = engine_version
        self.max_iops = max_iops
        self.connection_string = connection_string
        self.instance_network_type = instance_network_type
        self.security_iplist = security_iplist
        self.master_instance_id = master_instance_id
        self.dbinstance_class_type = dbinstance_class_type
        self.dbinstance_description = dbinstance_description
        self.dbinstance_cpu = dbinstance_cpu
        self.expire_time = expire_time
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_type = dbinstance_type
        self.account_max_quantity = account_max_quantity
        self.lock_reason = lock_reason
        self.dbinstance_status = dbinstance_status
        self.dbmax_quantity = dbmax_quantity
        self.guard_dbinstance_id = guard_dbinstance_id
        self.region_id = region_id
        self.dbinstance_storage = dbinstance_storage
        self.v_switch_id = v_switch_id
        self.zone_id = zone_id
        self.category = category
        self.max_connections = max_connections
        self.dbinstance_id = dbinstance_id
        self.dbinstance_class = dbinstance_class
        self.engine = engine

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.support_upgrade_account_type is not None:
            result['SupportUpgradeAccountType'] = self.support_upgrade_account_type
        if self.increment_source_dbinstance_id is not None:
            result['IncrementSourceDBInstanceId'] = self.increment_source_dbinstance_id
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.maintain_time is not None:
            result['MaintainTime'] = self.maintain_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.availability_value is not None:
            result['AvailabilityValue'] = self.availability_value
        if self.read_delay_time is not None:
            result['ReadDelayTime'] = self.read_delay_time
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.port is not None:
            result['Port'] = self.port
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.max_iops is not None:
            result['MaxIOPS'] = self.max_iops
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.security_iplist is not None:
            result['SecurityIPList'] = self.security_iplist
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_cpu is not None:
            result['DBInstanceCPU'] = self.dbinstance_cpu
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.account_max_quantity is not None:
            result['AccountMaxQuantity'] = self.account_max_quantity
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbmax_quantity is not None:
            result['DBMaxQuantity'] = self.dbmax_quantity
        if self.guard_dbinstance_id is not None:
            result['GuardDBInstanceId'] = self.guard_dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.category is not None:
            result['Category'] = self.category
        if self.max_connections is not None:
            result['MaxConnections'] = self.max_connections
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.engine is not None:
            result['Engine'] = self.engine
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('SupportUpgradeAccountType') is not None:
            self.support_upgrade_account_type = m.get('SupportUpgradeAccountType')
        if m.get('IncrementSourceDBInstanceId') is not None:
            self.increment_source_dbinstance_id = m.get('IncrementSourceDBInstanceId')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('MaintainTime') is not None:
            self.maintain_time = m.get('MaintainTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('AvailabilityValue') is not None:
            self.availability_value = m.get('AvailabilityValue')
        if m.get('ReadDelayTime') is not None:
            self.read_delay_time = m.get('ReadDelayTime')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('MaxIOPS') is not None:
            self.max_iops = m.get('MaxIOPS')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('SecurityIPList') is not None:
            self.security_iplist = m.get('SecurityIPList')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceCPU') is not None:
            self.dbinstance_cpu = m.get('DBInstanceCPU')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('AccountMaxQuantity') is not None:
            self.account_max_quantity = m.get('AccountMaxQuantity')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBMaxQuantity') is not None:
            self.dbmax_quantity = m.get('DBMaxQuantity')
        if m.get('GuardDBInstanceId') is not None:
            self.guard_dbinstance_id = m.get('GuardDBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('MaxConnections') is not None:
            self.max_connections = m.get('MaxConnections')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        return self


class DescribeDBInstancesAsCsvResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_attribute: List[DescribeDBInstancesAsCsvResponseBodyItemsDBInstanceAttribute] = None,
    ):
        self.dbinstance_attribute = dbinstance_attribute

    def validate(self):
        if self.dbinstance_attribute:
            for k in self.dbinstance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceAttribute'] = []
        if self.dbinstance_attribute is not None:
            for k in self.dbinstance_attribute:
                result['DBInstanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_attribute = []
        if m.get('DBInstanceAttribute') is not None:
            for k in m.get('DBInstanceAttribute'):
                temp_model = DescribeDBInstancesAsCsvResponseBodyItemsDBInstanceAttribute()
                self.dbinstance_attribute.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesAsCsvResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        items: DescribeDBInstancesAsCsvResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesAsCsvResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstancesAsCsvResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancesAsCsvResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesAsCsvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesByExpireTimeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        proxy_id: str = None,
        expire_period: int = None,
        expired: bool = None,
        page_size: int = None,
        page_number: int = None,
        tags: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.proxy_id = proxy_id
        self.expire_period = expire_period
        self.expired = expired
        self.page_size = page_size
        self.page_number = page_number
        self.tags = tags
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.expire_period is not None:
            result['ExpirePeriod'] = self.expire_period
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('ExpirePeriod') is not None:
            self.expire_period = m.get('ExpirePeriod')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstancesByExpireTimeResponseBodyItemsDBInstanceExpireTime(TeaModel):
    def __init__(
        self,
        expire_time: str = None,
        pay_type: str = None,
        dbinstance_id: str = None,
        dbinstance_status: str = None,
        dbinstance_description: str = None,
        lock_mode: str = None,
    ):
        self.expire_time = expire_time
        self.pay_type = pay_type
        self.dbinstance_id = dbinstance_id
        self.dbinstance_status = dbinstance_status
        self.dbinstance_description = dbinstance_description
        self.lock_mode = lock_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        return self


class DescribeDBInstancesByExpireTimeResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_expire_time: List[DescribeDBInstancesByExpireTimeResponseBodyItemsDBInstanceExpireTime] = None,
    ):
        self.dbinstance_expire_time = dbinstance_expire_time

    def validate(self):
        if self.dbinstance_expire_time:
            for k in self.dbinstance_expire_time:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceExpireTime'] = []
        if self.dbinstance_expire_time is not None:
            for k in self.dbinstance_expire_time:
                result['DBInstanceExpireTime'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_expire_time = []
        if m.get('DBInstanceExpireTime') is not None:
            for k in m.get('DBInstanceExpireTime'):
                temp_model = DescribeDBInstancesByExpireTimeResponseBodyItemsDBInstanceExpireTime()
                self.dbinstance_expire_time.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesByExpireTimeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeDBInstancesByExpireTimeResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesByExpireTimeResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstancesByExpireTimeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancesByExpireTimeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesByExpireTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesByPerformanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class DescribeDBInstancesByPerformanceRequest(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDBInstancesByPerformanceRequestTag] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        proxy_id: str = None,
        dbinstance_id: str = None,
        page_size: int = None,
        page_number: int = None,
        sort_method: str = None,
        sort_key: str = None,
        tags: str = None,
        owner_account: str = None,
        region_id: str = None,
    ):
        self.tag = tag
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.proxy_id = proxy_id
        self.dbinstance_id = dbinstance_id
        self.page_size = page_size
        self.page_number = page_number
        self.sort_method = sort_method
        self.sort_key = sort_key
        self.tags = tags
        self.owner_account = owner_account
        self.region_id = region_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.sort_method is not None:
            result['SortMethod'] = self.sort_method
        if self.sort_key is not None:
            result['SortKey'] = self.sort_key
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDBInstancesByPerformanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('SortMethod') is not None:
            self.sort_method = m.get('SortMethod')
        if m.get('SortKey') is not None:
            self.sort_key = m.get('SortKey')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBInstancesByPerformanceResponseBodyItemsDBInstancePerformance(TeaModel):
    def __init__(
        self,
        cpuusage: str = None,
        session_usage: str = None,
        dbinstance_id: str = None,
        dbinstance_description: str = None,
        iopsusage: str = None,
        disk_usage: str = None,
    ):
        self.cpuusage = cpuusage
        self.session_usage = session_usage
        self.dbinstance_id = dbinstance_id
        self.dbinstance_description = dbinstance_description
        self.iopsusage = iopsusage
        self.disk_usage = disk_usage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpuusage is not None:
            result['CPUUsage'] = self.cpuusage
        if self.session_usage is not None:
            result['SessionUsage'] = self.session_usage
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.iopsusage is not None:
            result['IOPSUsage'] = self.iopsusage
        if self.disk_usage is not None:
            result['DiskUsage'] = self.disk_usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CPUUsage') is not None:
            self.cpuusage = m.get('CPUUsage')
        if m.get('SessionUsage') is not None:
            self.session_usage = m.get('SessionUsage')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('IOPSUsage') is not None:
            self.iopsusage = m.get('IOPSUsage')
        if m.get('DiskUsage') is not None:
            self.disk_usage = m.get('DiskUsage')
        return self


class DescribeDBInstancesByPerformanceResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance_performance: List[DescribeDBInstancesByPerformanceResponseBodyItemsDBInstancePerformance] = None,
    ):
        self.dbinstance_performance = dbinstance_performance

    def validate(self):
        if self.dbinstance_performance:
            for k in self.dbinstance_performance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstancePerformance'] = []
        if self.dbinstance_performance is not None:
            for k in self.dbinstance_performance:
                result['DBInstancePerformance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_performance = []
        if m.get('DBInstancePerformance') is not None:
            for k in m.get('DBInstancePerformance'):
                temp_model = DescribeDBInstancesByPerformanceResponseBodyItemsDBInstancePerformance()
                self.dbinstance_performance.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesByPerformanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeDBInstancesByPerformanceResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesByPerformanceResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstancesByPerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancesByPerformanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesByPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstancesForCloneRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        proxy_id: str = None,
        engine: str = None,
        zone_id: str = None,
        dbinstance_status: str = None,
        expired: str = None,
        search_key: str = None,
        dbinstance_id: str = None,
        dbinstance_type: str = None,
        region_id: str = None,
        page_size: int = None,
        page_number: int = None,
        instance_network_type: str = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        dbinstance_class: str = None,
        engine_version: str = None,
        node_type: str = None,
        pay_type: str = None,
        connection_mode: str = None,
        owner_account: str = None,
        current_instance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.proxy_id = proxy_id
        self.engine = engine
        self.zone_id = zone_id
        self.dbinstance_status = dbinstance_status
        self.expired = expired
        self.search_key = search_key
        self.dbinstance_id = dbinstance_id
        self.dbinstance_type = dbinstance_type
        self.region_id = region_id
        self.page_size = page_size
        self.page_number = page_number
        self.instance_network_type = instance_network_type
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.dbinstance_class = dbinstance_class
        self.engine_version = engine_version
        self.node_type = node_type
        self.pay_type = pay_type
        self.connection_mode = connection_mode
        self.owner_account = owner_account
        self.current_instance_id = current_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.current_instance_id is not None:
            result['CurrentInstanceId'] = self.current_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('CurrentInstanceId') is not None:
            self.current_instance_id = m.get('CurrentInstanceId')
        return self


class DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIds(TeaModel):
    def __init__(
        self,
        read_only_dbinstance_id: List[DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId] = None,
    ):
        self.read_only_dbinstance_id = read_only_dbinstance_id

    def validate(self):
        if self.read_only_dbinstance_id:
            for k in self.read_only_dbinstance_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyDBInstanceId'] = []
        if self.read_only_dbinstance_id is not None:
            for k in self.read_only_dbinstance_id:
                result['ReadOnlyDBInstanceId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.read_only_dbinstance_id = []
        if m.get('ReadOnlyDBInstanceId') is not None:
            for k in m.get('ReadOnlyDBInstanceId'):
                temp_model = DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIdsReadOnlyDBInstanceId()
                self.read_only_dbinstance_id.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesForCloneResponseBodyItemsDBInstance(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        replicate_id: str = None,
        temp_dbinstance_id: str = None,
        dbinstance_storage_type: str = None,
        create_time: str = None,
        pay_type: str = None,
        mutri_orsignle: bool = None,
        connection_mode: str = None,
        lock_mode: str = None,
        engine_version: str = None,
        vpc_cloud_instance_id: str = None,
        ins_id: int = None,
        instance_network_type: str = None,
        master_instance_id: str = None,
        dbinstance_description: str = None,
        expire_time: str = None,
        dbinstance_net_type: str = None,
        dbinstance_type: str = None,
        destroy_time: str = None,
        lock_reason: str = None,
        dbinstance_status: str = None,
        guard_dbinstance_id: str = None,
        region_id: str = None,
        v_switch_id: str = None,
        resource_group_id: str = None,
        zone_id: str = None,
        dbinstance_id: str = None,
        category: str = None,
        engine: str = None,
        dbinstance_class: str = None,
        read_only_dbinstance_ids: DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIds = None,
    ):
        self.vpc_id = vpc_id
        self.replicate_id = replicate_id
        self.temp_dbinstance_id = temp_dbinstance_id
        self.dbinstance_storage_type = dbinstance_storage_type
        self.create_time = create_time
        self.pay_type = pay_type
        self.mutri_orsignle = mutri_orsignle
        self.connection_mode = connection_mode
        self.lock_mode = lock_mode
        self.engine_version = engine_version
        self.vpc_cloud_instance_id = vpc_cloud_instance_id
        self.ins_id = ins_id
        self.instance_network_type = instance_network_type
        self.master_instance_id = master_instance_id
        self.dbinstance_description = dbinstance_description
        self.expire_time = expire_time
        self.dbinstance_net_type = dbinstance_net_type
        self.dbinstance_type = dbinstance_type
        self.destroy_time = destroy_time
        self.lock_reason = lock_reason
        self.dbinstance_status = dbinstance_status
        self.guard_dbinstance_id = guard_dbinstance_id
        self.region_id = region_id
        self.v_switch_id = v_switch_id
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.dbinstance_id = dbinstance_id
        self.category = category
        self.engine = engine
        self.dbinstance_class = dbinstance_class
        self.read_only_dbinstance_ids = read_only_dbinstance_ids

    def validate(self):
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.replicate_id is not None:
            result['ReplicateId'] = self.replicate_id
        if self.temp_dbinstance_id is not None:
            result['TempDBInstanceId'] = self.temp_dbinstance_id
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.mutri_orsignle is not None:
            result['MutriORsignle'] = self.mutri_orsignle
        if self.connection_mode is not None:
            result['ConnectionMode'] = self.connection_mode
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.ins_id is not None:
            result['InsId'] = self.ins_id
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.dbinstance_net_type is not None:
            result['DBInstanceNetType'] = self.dbinstance_net_type
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.destroy_time is not None:
            result['DestroyTime'] = self.destroy_time
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.guard_dbinstance_id is not None:
            result['GuardDBInstanceId'] = self.guard_dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.category is not None:
            result['Category'] = self.category
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ReplicateId') is not None:
            self.replicate_id = m.get('ReplicateId')
        if m.get('TempDBInstanceId') is not None:
            self.temp_dbinstance_id = m.get('TempDBInstanceId')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('MutriORsignle') is not None:
            self.mutri_orsignle = m.get('MutriORsignle')
        if m.get('ConnectionMode') is not None:
            self.connection_mode = m.get('ConnectionMode')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('InsId') is not None:
            self.ins_id = m.get('InsId')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('DBInstanceNetType') is not None:
            self.dbinstance_net_type = m.get('DBInstanceNetType')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('DestroyTime') is not None:
            self.destroy_time = m.get('DestroyTime')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('GuardDBInstanceId') is not None:
            self.guard_dbinstance_id = m.get('GuardDBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDBInstancesForCloneResponseBodyItemsDBInstanceReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        return self


class DescribeDBInstancesForCloneResponseBodyItems(TeaModel):
    def __init__(
        self,
        dbinstance: List[DescribeDBInstancesForCloneResponseBodyItemsDBInstance] = None,
    ):
        self.dbinstance = dbinstance

    def validate(self):
        if self.dbinstance:
            for k in self.dbinstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstance'] = []
        if self.dbinstance is not None:
            for k in self.dbinstance:
                result['DBInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance = []
        if m.get('DBInstance') is not None:
            for k in m.get('DBInstance'):
                temp_model = DescribeDBInstancesForCloneResponseBodyItemsDBInstance()
                self.dbinstance.append(temp_model.from_map(k))
        return self


class DescribeDBInstancesForCloneResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeDBInstancesForCloneResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeDBInstancesForCloneResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDBInstancesForCloneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstancesForCloneResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstancesForCloneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceSSLRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstanceSSLResponseBody(TeaModel):
    def __init__(
        self,
        server_cert: str = None,
        client_cacert_expire_time: str = None,
        require_update_item: str = None,
        server_caurl: str = None,
        require_update: str = None,
        client_cert_revocation_list: str = None,
        sslexpire_time: str = None,
        catype: str = None,
        sslcreate_time: str = None,
        replication_acl: str = None,
        acl: str = None,
        request_id: str = None,
        last_modify_status: str = None,
        sslenabled: str = None,
        connection_string: str = None,
        require_update_reason: str = None,
        client_cacert: str = None,
        server_key: str = None,
        modify_status_reason: str = None,
    ):
        self.server_cert = server_cert
        self.client_cacert_expire_time = client_cacert_expire_time
        self.require_update_item = require_update_item
        self.server_caurl = server_caurl
        self.require_update = require_update
        self.client_cert_revocation_list = client_cert_revocation_list
        self.sslexpire_time = sslexpire_time
        self.catype = catype
        self.sslcreate_time = sslcreate_time
        self.replication_acl = replication_acl
        self.acl = acl
        self.request_id = request_id
        self.last_modify_status = last_modify_status
        self.sslenabled = sslenabled
        self.connection_string = connection_string
        self.require_update_reason = require_update_reason
        self.client_cacert = client_cacert
        self.server_key = server_key
        self.modify_status_reason = modify_status_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.server_cert is not None:
            result['ServerCert'] = self.server_cert
        if self.client_cacert_expire_time is not None:
            result['ClientCACertExpireTime'] = self.client_cacert_expire_time
        if self.require_update_item is not None:
            result['RequireUpdateItem'] = self.require_update_item
        if self.server_caurl is not None:
            result['ServerCAUrl'] = self.server_caurl
        if self.require_update is not None:
            result['RequireUpdate'] = self.require_update
        if self.client_cert_revocation_list is not None:
            result['ClientCertRevocationList'] = self.client_cert_revocation_list
        if self.sslexpire_time is not None:
            result['SSLExpireTime'] = self.sslexpire_time
        if self.catype is not None:
            result['CAType'] = self.catype
        if self.sslcreate_time is not None:
            result['SSLCreateTime'] = self.sslcreate_time
        if self.replication_acl is not None:
            result['ReplicationACL'] = self.replication_acl
        if self.acl is not None:
            result['ACL'] = self.acl
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.last_modify_status is not None:
            result['LastModifyStatus'] = self.last_modify_status
        if self.sslenabled is not None:
            result['SSLEnabled'] = self.sslenabled
        if self.connection_string is not None:
            result['ConnectionString'] = self.connection_string
        if self.require_update_reason is not None:
            result['RequireUpdateReason'] = self.require_update_reason
        if self.client_cacert is not None:
            result['ClientCACert'] = self.client_cacert
        if self.server_key is not None:
            result['ServerKey'] = self.server_key
        if self.modify_status_reason is not None:
            result['ModifyStatusReason'] = self.modify_status_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServerCert') is not None:
            self.server_cert = m.get('ServerCert')
        if m.get('ClientCACertExpireTime') is not None:
            self.client_cacert_expire_time = m.get('ClientCACertExpireTime')
        if m.get('RequireUpdateItem') is not None:
            self.require_update_item = m.get('RequireUpdateItem')
        if m.get('ServerCAUrl') is not None:
            self.server_caurl = m.get('ServerCAUrl')
        if m.get('RequireUpdate') is not None:
            self.require_update = m.get('RequireUpdate')
        if m.get('ClientCertRevocationList') is not None:
            self.client_cert_revocation_list = m.get('ClientCertRevocationList')
        if m.get('SSLExpireTime') is not None:
            self.sslexpire_time = m.get('SSLExpireTime')
        if m.get('CAType') is not None:
            self.catype = m.get('CAType')
        if m.get('SSLCreateTime') is not None:
            self.sslcreate_time = m.get('SSLCreateTime')
        if m.get('ReplicationACL') is not None:
            self.replication_acl = m.get('ReplicationACL')
        if m.get('ACL') is not None:
            self.acl = m.get('ACL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LastModifyStatus') is not None:
            self.last_modify_status = m.get('LastModifyStatus')
        if m.get('SSLEnabled') is not None:
            self.sslenabled = m.get('SSLEnabled')
        if m.get('ConnectionString') is not None:
            self.connection_string = m.get('ConnectionString')
        if m.get('RequireUpdateReason') is not None:
            self.require_update_reason = m.get('RequireUpdateReason')
        if m.get('ClientCACert') is not None:
            self.client_cacert = m.get('ClientCACert')
        if m.get('ServerKey') is not None:
            self.server_key = m.get('ServerKey')
        if m.get('ModifyStatusReason') is not None:
            self.modify_status_reason = m.get('ModifyStatusReason')
        return self


class DescribeDBInstanceSSLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceSSLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceSSLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceStatusRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        address_ip: str = None,
        address_port: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.address_ip = address_ip
        self.address_port = address_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.address_ip is not None:
            result['AddressIP'] = self.address_ip
        if self.address_port is not None:
            result['AddressPort'] = self.address_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AddressIP') is not None:
            self.address_ip = m.get('AddressIP')
        if m.get('AddressPort') is not None:
            self.address_port = m.get('AddressPort')
        return self


class DescribeDBInstanceStatusResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_name: str = None,
        request_id: str = None,
        dbinstance_cpu_cores: str = None,
        task_status: int = None,
        dbinstance_id: int = None,
        dbinstance_status: int = None,
        dbinstance_use_type: str = None,
    ):
        self.dbinstance_name = dbinstance_name
        self.request_id = request_id
        self.dbinstance_cpu_cores = dbinstance_cpu_cores
        self.task_status = task_status
        self.dbinstance_id = dbinstance_id
        self.dbinstance_status = dbinstance_status
        self.dbinstance_use_type = dbinstance_use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dbinstance_cpu_cores is not None:
            result['DBInstanceCpuCores'] = self.dbinstance_cpu_cores
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_use_type is not None:
            result['DBInstanceUseType'] = self.dbinstance_use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DBInstanceCpuCores') is not None:
            self.dbinstance_cpu_cores = m.get('DBInstanceCpuCores')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceUseType') is not None:
            self.dbinstance_use_type = m.get('DBInstanceUseType')
        return self


class DescribeDBInstanceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBInstanceTDERequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeDBInstanceTDEResponseBodyDatabasesDatabase(TeaModel):
    def __init__(
        self,
        dbname: str = None,
        tdestatus: str = None,
    ):
        self.dbname = dbname
        self.tdestatus = tdestatus

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.tdestatus is not None:
            result['TDEStatus'] = self.tdestatus
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('TDEStatus') is not None:
            self.tdestatus = m.get('TDEStatus')
        return self


class DescribeDBInstanceTDEResponseBodyDatabases(TeaModel):
    def __init__(
        self,
        database: List[DescribeDBInstanceTDEResponseBodyDatabasesDatabase] = None,
    ):
        self.database = database

    def validate(self):
        if self.database:
            for k in self.database:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Database'] = []
        if self.database is not None:
            for k in self.database:
                result['Database'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.database = []
        if m.get('Database') is not None:
            for k in m.get('Database'):
                temp_model = DescribeDBInstanceTDEResponseBodyDatabasesDatabase()
                self.database.append(temp_model.from_map(k))
        return self


class DescribeDBInstanceTDEResponseBody(TeaModel):
    def __init__(
        self,
        tdestatus: str = None,
        request_id: str = None,
        databases: DescribeDBInstanceTDEResponseBodyDatabases = None,
    ):
        self.tdestatus = tdestatus
        self.request_id = request_id
        self.databases = databases

    def validate(self):
        if self.databases:
            self.databases.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tdestatus is not None:
            result['TDEStatus'] = self.tdestatus
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.databases is not None:
            result['Databases'] = self.databases.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TDEStatus') is not None:
            self.tdestatus = m.get('TDEStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Databases') is not None:
            temp_model = DescribeDBInstanceTDEResponseBodyDatabases()
            self.databases = temp_model.from_map(m['Databases'])
        return self


class DescribeDBInstanceTDEResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBInstanceTDEResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBInstanceTDEResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBProxyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBProxyResponseBodyDBProxyConnectStringItemsDBProxyConnectStringItems(TeaModel):
    def __init__(
        self,
        dbproxy_connect_string_net_work_type: str = None,
        dbproxy_connect_string_net_type: str = None,
        dbproxy_vpc_instance_id: str = None,
        dbproxy_endpoint_name: str = None,
        dbproxy_endpoint_id: str = None,
        dbproxy_connect_string_port: str = None,
        dbproxy_connect_string: str = None,
    ):
        self.dbproxy_connect_string_net_work_type = dbproxy_connect_string_net_work_type
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type
        self.dbproxy_vpc_instance_id = dbproxy_vpc_instance_id
        self.dbproxy_endpoint_name = dbproxy_endpoint_name
        self.dbproxy_endpoint_id = dbproxy_endpoint_id
        self.dbproxy_connect_string_port = dbproxy_connect_string_port
        self.dbproxy_connect_string = dbproxy_connect_string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbproxy_connect_string_net_work_type is not None:
            result['DBProxyConnectStringNetWorkType'] = self.dbproxy_connect_string_net_work_type
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        if self.dbproxy_vpc_instance_id is not None:
            result['DBProxyVpcInstanceId'] = self.dbproxy_vpc_instance_id
        if self.dbproxy_endpoint_name is not None:
            result['DBProxyEndpointName'] = self.dbproxy_endpoint_name
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_connect_string_port is not None:
            result['DBProxyConnectStringPort'] = self.dbproxy_connect_string_port
        if self.dbproxy_connect_string is not None:
            result['DBProxyConnectString'] = self.dbproxy_connect_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBProxyConnectStringNetWorkType') is not None:
            self.dbproxy_connect_string_net_work_type = m.get('DBProxyConnectStringNetWorkType')
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        if m.get('DBProxyVpcInstanceId') is not None:
            self.dbproxy_vpc_instance_id = m.get('DBProxyVpcInstanceId')
        if m.get('DBProxyEndpointName') is not None:
            self.dbproxy_endpoint_name = m.get('DBProxyEndpointName')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyConnectStringPort') is not None:
            self.dbproxy_connect_string_port = m.get('DBProxyConnectStringPort')
        if m.get('DBProxyConnectString') is not None:
            self.dbproxy_connect_string = m.get('DBProxyConnectString')
        return self


class DescribeDBProxyResponseBodyDBProxyConnectStringItems(TeaModel):
    def __init__(
        self,
        dbproxy_connect_string_items: List[DescribeDBProxyResponseBodyDBProxyConnectStringItemsDBProxyConnectStringItems] = None,
    ):
        self.dbproxy_connect_string_items = dbproxy_connect_string_items

    def validate(self):
        if self.dbproxy_connect_string_items:
            for k in self.dbproxy_connect_string_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBProxyConnectStringItems'] = []
        if self.dbproxy_connect_string_items is not None:
            for k in self.dbproxy_connect_string_items:
                result['DBProxyConnectStringItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbproxy_connect_string_items = []
        if m.get('DBProxyConnectStringItems') is not None:
            for k in m.get('DBProxyConnectStringItems'):
                temp_model = DescribeDBProxyResponseBodyDBProxyConnectStringItemsDBProxyConnectStringItems()
                self.dbproxy_connect_string_items.append(temp_model.from_map(k))
        return self


class DescribeDBProxyResponseBodyDbProxyEndpointItemsDbProxyEndpointItems(TeaModel):
    def __init__(
        self,
        db_proxy_endpoint_aliases: str = None,
        db_proxy_endpoint_name: str = None,
        db_proxy_endpoint_type: str = None,
        db_proxy_read_write_mode: str = None,
    ):
        self.db_proxy_endpoint_aliases = db_proxy_endpoint_aliases
        self.db_proxy_endpoint_name = db_proxy_endpoint_name
        self.db_proxy_endpoint_type = db_proxy_endpoint_type
        self.db_proxy_read_write_mode = db_proxy_read_write_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_proxy_endpoint_aliases is not None:
            result['DbProxyEndpointAliases'] = self.db_proxy_endpoint_aliases
        if self.db_proxy_endpoint_name is not None:
            result['DbProxyEndpointName'] = self.db_proxy_endpoint_name
        if self.db_proxy_endpoint_type is not None:
            result['DbProxyEndpointType'] = self.db_proxy_endpoint_type
        if self.db_proxy_read_write_mode is not None:
            result['DbProxyReadWriteMode'] = self.db_proxy_read_write_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbProxyEndpointAliases') is not None:
            self.db_proxy_endpoint_aliases = m.get('DbProxyEndpointAliases')
        if m.get('DbProxyEndpointName') is not None:
            self.db_proxy_endpoint_name = m.get('DbProxyEndpointName')
        if m.get('DbProxyEndpointType') is not None:
            self.db_proxy_endpoint_type = m.get('DbProxyEndpointType')
        if m.get('DbProxyReadWriteMode') is not None:
            self.db_proxy_read_write_mode = m.get('DbProxyReadWriteMode')
        return self


class DescribeDBProxyResponseBodyDbProxyEndpointItems(TeaModel):
    def __init__(
        self,
        db_proxy_endpoint_items: List[DescribeDBProxyResponseBodyDbProxyEndpointItemsDbProxyEndpointItems] = None,
    ):
        self.db_proxy_endpoint_items = db_proxy_endpoint_items

    def validate(self):
        if self.db_proxy_endpoint_items:
            for k in self.db_proxy_endpoint_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbProxyEndpointItems'] = []
        if self.db_proxy_endpoint_items is not None:
            for k in self.db_proxy_endpoint_items:
                result['DbProxyEndpointItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.db_proxy_endpoint_items = []
        if m.get('DbProxyEndpointItems') is not None:
            for k in m.get('DbProxyEndpointItems'):
                temp_model = DescribeDBProxyResponseBodyDbProxyEndpointItemsDbProxyEndpointItems()
                self.db_proxy_endpoint_items.append(temp_model.from_map(k))
        return self


class DescribeDBProxyResponseBody(TeaModel):
    def __init__(
        self,
        dbproxy_instance_latest_minor_version: str = None,
        request_id: str = None,
        dbproxy_instance_current_minor_version: str = None,
        dbproxy_instance_num: int = None,
        dbproxy_instance_type: str = None,
        dbproxy_instance_status: str = None,
        dbproxy_service_status: str = None,
        dbproxy_instance_name: str = None,
        dbproxy_connect_string_items: DescribeDBProxyResponseBodyDBProxyConnectStringItems = None,
        db_proxy_endpoint_items: DescribeDBProxyResponseBodyDbProxyEndpointItems = None,
    ):
        self.dbproxy_instance_latest_minor_version = dbproxy_instance_latest_minor_version
        self.request_id = request_id
        self.dbproxy_instance_current_minor_version = dbproxy_instance_current_minor_version
        self.dbproxy_instance_num = dbproxy_instance_num
        self.dbproxy_instance_type = dbproxy_instance_type
        self.dbproxy_instance_status = dbproxy_instance_status
        self.dbproxy_service_status = dbproxy_service_status
        self.dbproxy_instance_name = dbproxy_instance_name
        self.dbproxy_connect_string_items = dbproxy_connect_string_items
        self.db_proxy_endpoint_items = db_proxy_endpoint_items

    def validate(self):
        if self.dbproxy_connect_string_items:
            self.dbproxy_connect_string_items.validate()
        if self.db_proxy_endpoint_items:
            self.db_proxy_endpoint_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbproxy_instance_latest_minor_version is not None:
            result['DBProxyInstanceLatestMinorVersion'] = self.dbproxy_instance_latest_minor_version
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dbproxy_instance_current_minor_version is not None:
            result['DBProxyInstanceCurrentMinorVersion'] = self.dbproxy_instance_current_minor_version
        if self.dbproxy_instance_num is not None:
            result['DBProxyInstanceNum'] = self.dbproxy_instance_num
        if self.dbproxy_instance_type is not None:
            result['DBProxyInstanceType'] = self.dbproxy_instance_type
        if self.dbproxy_instance_status is not None:
            result['DBProxyInstanceStatus'] = self.dbproxy_instance_status
        if self.dbproxy_service_status is not None:
            result['DBProxyServiceStatus'] = self.dbproxy_service_status
        if self.dbproxy_instance_name is not None:
            result['DBProxyInstanceName'] = self.dbproxy_instance_name
        if self.dbproxy_connect_string_items is not None:
            result['DBProxyConnectStringItems'] = self.dbproxy_connect_string_items.to_map()
        if self.db_proxy_endpoint_items is not None:
            result['DbProxyEndpointItems'] = self.db_proxy_endpoint_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBProxyInstanceLatestMinorVersion') is not None:
            self.dbproxy_instance_latest_minor_version = m.get('DBProxyInstanceLatestMinorVersion')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DBProxyInstanceCurrentMinorVersion') is not None:
            self.dbproxy_instance_current_minor_version = m.get('DBProxyInstanceCurrentMinorVersion')
        if m.get('DBProxyInstanceNum') is not None:
            self.dbproxy_instance_num = m.get('DBProxyInstanceNum')
        if m.get('DBProxyInstanceType') is not None:
            self.dbproxy_instance_type = m.get('DBProxyInstanceType')
        if m.get('DBProxyInstanceStatus') is not None:
            self.dbproxy_instance_status = m.get('DBProxyInstanceStatus')
        if m.get('DBProxyServiceStatus') is not None:
            self.dbproxy_service_status = m.get('DBProxyServiceStatus')
        if m.get('DBProxyInstanceName') is not None:
            self.dbproxy_instance_name = m.get('DBProxyInstanceName')
        if m.get('DBProxyConnectStringItems') is not None:
            temp_model = DescribeDBProxyResponseBodyDBProxyConnectStringItems()
            self.dbproxy_connect_string_items = temp_model.from_map(m['DBProxyConnectStringItems'])
        if m.get('DbProxyEndpointItems') is not None:
            temp_model = DescribeDBProxyResponseBodyDbProxyEndpointItems()
            self.db_proxy_endpoint_items = temp_model.from_map(m['DbProxyEndpointItems'])
        return self


class DescribeDBProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBProxyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBProxyEndpointRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbproxy_endpoint_id: str = None,
        dbproxy_connect_string: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbproxy_endpoint_id = dbproxy_endpoint_id
        self.dbproxy_connect_string = dbproxy_connect_string
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_connect_string is not None:
            result['DBProxyConnectString'] = self.dbproxy_connect_string
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyConnectString') is not None:
            self.dbproxy_connect_string = m.get('DBProxyConnectString')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDBProxyEndpointResponseBodyEndpointConnectItemsEndpointConnectItems(TeaModel):
    def __init__(
        self,
        db_proxy_endpoint_port: str = None,
        db_proxy_endpoint_connect_string: str = None,
        db_proxy_endpoint_net_type: str = None,
    ):
        self.db_proxy_endpoint_port = db_proxy_endpoint_port
        self.db_proxy_endpoint_connect_string = db_proxy_endpoint_connect_string
        self.db_proxy_endpoint_net_type = db_proxy_endpoint_net_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_proxy_endpoint_port is not None:
            result['DbProxyEndpointPort'] = self.db_proxy_endpoint_port
        if self.db_proxy_endpoint_connect_string is not None:
            result['DbProxyEndpointConnectString'] = self.db_proxy_endpoint_connect_string
        if self.db_proxy_endpoint_net_type is not None:
            result['DbProxyEndpointNetType'] = self.db_proxy_endpoint_net_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbProxyEndpointPort') is not None:
            self.db_proxy_endpoint_port = m.get('DbProxyEndpointPort')
        if m.get('DbProxyEndpointConnectString') is not None:
            self.db_proxy_endpoint_connect_string = m.get('DbProxyEndpointConnectString')
        if m.get('DbProxyEndpointNetType') is not None:
            self.db_proxy_endpoint_net_type = m.get('DbProxyEndpointNetType')
        return self


class DescribeDBProxyEndpointResponseBodyEndpointConnectItems(TeaModel):
    def __init__(
        self,
        endpoint_connect_items: List[DescribeDBProxyEndpointResponseBodyEndpointConnectItemsEndpointConnectItems] = None,
    ):
        self.endpoint_connect_items = endpoint_connect_items

    def validate(self):
        if self.endpoint_connect_items:
            for k in self.endpoint_connect_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EndpointConnectItems'] = []
        if self.endpoint_connect_items is not None:
            for k in self.endpoint_connect_items:
                result['EndpointConnectItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.endpoint_connect_items = []
        if m.get('EndpointConnectItems') is not None:
            for k in m.get('EndpointConnectItems'):
                temp_model = DescribeDBProxyEndpointResponseBodyEndpointConnectItemsEndpointConnectItems()
                self.endpoint_connect_items.append(temp_model.from_map(k))
        return self


class DescribeDBProxyEndpointResponseBody(TeaModel):
    def __init__(
        self,
        dbproxy_connect_string_net_type: str = None,
        dbproxy_features: str = None,
        request_id: str = None,
        read_only_instance_weight: str = None,
        read_only_instance_distribution_type: str = None,
        read_only_instance_max_delay_time: str = None,
        db_proxy_endpoint_read_write_mode: str = None,
        db_proxy_endpoint_aliases: str = None,
        dbproxy_endpoint_id: str = None,
        dbproxy_connect_string_port: str = None,
        dbproxy_connect_string: str = None,
        endpoint_connect_items: DescribeDBProxyEndpointResponseBodyEndpointConnectItems = None,
    ):
        self.dbproxy_connect_string_net_type = dbproxy_connect_string_net_type
        self.dbproxy_features = dbproxy_features
        self.request_id = request_id
        self.read_only_instance_weight = read_only_instance_weight
        self.read_only_instance_distribution_type = read_only_instance_distribution_type
        self.read_only_instance_max_delay_time = read_only_instance_max_delay_time
        self.db_proxy_endpoint_read_write_mode = db_proxy_endpoint_read_write_mode
        self.db_proxy_endpoint_aliases = db_proxy_endpoint_aliases
        self.dbproxy_endpoint_id = dbproxy_endpoint_id
        self.dbproxy_connect_string_port = dbproxy_connect_string_port
        self.dbproxy_connect_string = dbproxy_connect_string
        self.endpoint_connect_items = endpoint_connect_items

    def validate(self):
        if self.endpoint_connect_items:
            self.endpoint_connect_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbproxy_connect_string_net_type is not None:
            result['DBProxyConnectStringNetType'] = self.dbproxy_connect_string_net_type
        if self.dbproxy_features is not None:
            result['DBProxyFeatures'] = self.dbproxy_features
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.read_only_instance_weight is not None:
            result['ReadOnlyInstanceWeight'] = self.read_only_instance_weight
        if self.read_only_instance_distribution_type is not None:
            result['ReadOnlyInstanceDistributionType'] = self.read_only_instance_distribution_type
        if self.read_only_instance_max_delay_time is not None:
            result['ReadOnlyInstanceMaxDelayTime'] = self.read_only_instance_max_delay_time
        if self.db_proxy_endpoint_read_write_mode is not None:
            result['DbProxyEndpointReadWriteMode'] = self.db_proxy_endpoint_read_write_mode
        if self.db_proxy_endpoint_aliases is not None:
            result['DbProxyEndpointAliases'] = self.db_proxy_endpoint_aliases
        if self.dbproxy_endpoint_id is not None:
            result['DBProxyEndpointId'] = self.dbproxy_endpoint_id
        if self.dbproxy_connect_string_port is not None:
            result['DBProxyConnectStringPort'] = self.dbproxy_connect_string_port
        if self.dbproxy_connect_string is not None:
            result['DBProxyConnectString'] = self.dbproxy_connect_string
        if self.endpoint_connect_items is not None:
            result['EndpointConnectItems'] = self.endpoint_connect_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBProxyConnectStringNetType') is not None:
            self.dbproxy_connect_string_net_type = m.get('DBProxyConnectStringNetType')
        if m.get('DBProxyFeatures') is not None:
            self.dbproxy_features = m.get('DBProxyFeatures')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ReadOnlyInstanceWeight') is not None:
            self.read_only_instance_weight = m.get('ReadOnlyInstanceWeight')
        if m.get('ReadOnlyInstanceDistributionType') is not None:
            self.read_only_instance_distribution_type = m.get('ReadOnlyInstanceDistributionType')
        if m.get('ReadOnlyInstanceMaxDelayTime') is not None:
            self.read_only_instance_max_delay_time = m.get('ReadOnlyInstanceMaxDelayTime')
        if m.get('DbProxyEndpointReadWriteMode') is not None:
            self.db_proxy_endpoint_read_write_mode = m.get('DbProxyEndpointReadWriteMode')
        if m.get('DbProxyEndpointAliases') is not None:
            self.db_proxy_endpoint_aliases = m.get('DbProxyEndpointAliases')
        if m.get('DBProxyEndpointId') is not None:
            self.dbproxy_endpoint_id = m.get('DBProxyEndpointId')
        if m.get('DBProxyConnectStringPort') is not None:
            self.dbproxy_connect_string_port = m.get('DBProxyConnectStringPort')
        if m.get('DBProxyConnectString') is not None:
            self.dbproxy_connect_string = m.get('DBProxyConnectString')
        if m.get('EndpointConnectItems') is not None:
            temp_model = DescribeDBProxyEndpointResponseBodyEndpointConnectItems()
            self.endpoint_connect_items = temp_model.from_map(m['EndpointConnectItems'])
        return self


class DescribeDBProxyEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBProxyEndpointResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBProxyEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDBProxyPerformanceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        dbproxy_instance_type: str = None,
        start_time: str = None,
        end_time: str = None,
        region_id: str = None,
        metrics_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.dbproxy_instance_type = dbproxy_instance_type
        self.start_time = start_time
        self.end_time = end_time
        self.region_id = region_id
        self.metrics_name = metrics_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbproxy_instance_type is not None:
            result['DBProxyInstanceType'] = self.dbproxy_instance_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.metrics_name is not None:
            result['MetricsName'] = self.metrics_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBProxyInstanceType') is not None:
            self.dbproxy_instance_type = m.get('DBProxyInstanceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('MetricsName') is not None:
            self.metrics_name = m.get('MetricsName')
        return self


class DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue(TeaModel):
    def __init__(
        self,
        date: str = None,
        value: str = None,
    ):
        self.date = date
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValues(TeaModel):
    def __init__(
        self,
        performance_value: List[DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue] = None,
    ):
        self.performance_value = performance_value

    def validate(self):
        if self.performance_value:
            for k in self.performance_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceValue'] = []
        if self.performance_value is not None:
            for k in self.performance_value:
                result['PerformanceValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performance_value = []
        if m.get('PerformanceValue') is not None:
            for k in m.get('PerformanceValue'):
                temp_model = DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValuesPerformanceValue()
                self.performance_value.append(temp_model.from_map(k))
        return self


class DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKey(TeaModel):
    def __init__(
        self,
        value_format: str = None,
        key: str = None,
        values: DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValues = None,
    ):
        self.value_format = value_format
        self.key = key
        self.values = values

    def validate(self):
        if self.values:
            self.values.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value_format is not None:
            result['ValueFormat'] = self.value_format
        if self.key is not None:
            result['Key'] = self.key
        if self.values is not None:
            result['Values'] = self.values.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ValueFormat') is not None:
            self.value_format = m.get('ValueFormat')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Values') is not None:
            temp_model = DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKeyValues()
            self.values = temp_model.from_map(m['Values'])
        return self


class DescribeDBProxyPerformanceResponseBodyPerformanceKeys(TeaModel):
    def __init__(
        self,
        performance_key: List[DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKey] = None,
    ):
        self.performance_key = performance_key

    def validate(self):
        if self.performance_key:
            for k in self.performance_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceKey'] = []
        if self.performance_key is not None:
            for k in self.performance_key:
                result['PerformanceKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.performance_key = []
        if m.get('PerformanceKey') is not None:
            for k in m.get('PerformanceKey'):
                temp_model = DescribeDBProxyPerformanceResponseBodyPerformanceKeysPerformanceKey()
                self.performance_key.append(temp_model.from_map(k))
        return self


class DescribeDBProxyPerformanceResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        start_time: str = None,
        dbinstance_id: str = None,
        request_id: str = None,
        performance_keys: DescribeDBProxyPerformanceResponseBodyPerformanceKeys = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.performance_keys = performance_keys

    def validate(self):
        if self.performance_keys:
            self.performance_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.performance_keys is not None:
            result['PerformanceKeys'] = self.performance_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PerformanceKeys') is not None:
            temp_model = DescribeDBProxyPerformanceResponseBodyPerformanceKeys()
            self.performance_keys = temp_model.from_map(m['PerformanceKeys'])
        return self


class DescribeDBProxyPerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDBProxyPerformanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDBProxyPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dedicated_host_id: str = None,
        dedicated_host_group_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dedicated_host_id = dedicated_host_id
        self.dedicated_host_group_id = dedicated_host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        return self


class DescribeDedicatedHostAttributeResponseBody(TeaModel):
    def __init__(
        self,
        cpuallocation_ratio: str = None,
        disk_allocation_ratio: str = None,
        dedicated_host_id: str = None,
        instance_number: int = None,
        created_time: str = None,
        dedicated_host_group_id: str = None,
        auto_renew: str = None,
        image_category: str = None,
        host_storage: int = None,
        instance_number_slave: int = None,
        open_permission: str = None,
        host_type: str = None,
        expired_time: str = None,
        host_mem: int = None,
        memory_used: str = None,
        host_status: str = None,
        cpu_used: str = None,
        host_name: str = None,
        instance_number_roslave: int = None,
        allocation_status: str = None,
        request_id: str = None,
        mem_allocation_ratio: str = None,
        zone_id: str = None,
        instance_number_romaster: int = None,
        vpcid: str = None,
        v_switch_id: str = None,
        instance_number_master: int = None,
        storage_used: str = None,
        host_class: str = None,
        host_cpu: int = None,
        region_id: str = None,
        ipaddress: str = None,
        account_name: str = None,
    ):
        self.cpuallocation_ratio = cpuallocation_ratio
        self.disk_allocation_ratio = disk_allocation_ratio
        self.dedicated_host_id = dedicated_host_id
        self.instance_number = instance_number
        self.created_time = created_time
        self.dedicated_host_group_id = dedicated_host_group_id
        self.auto_renew = auto_renew
        self.image_category = image_category
        self.host_storage = host_storage
        self.instance_number_slave = instance_number_slave
        self.open_permission = open_permission
        self.host_type = host_type
        self.expired_time = expired_time
        self.host_mem = host_mem
        self.memory_used = memory_used
        self.host_status = host_status
        self.cpu_used = cpu_used
        self.host_name = host_name
        self.instance_number_roslave = instance_number_roslave
        self.allocation_status = allocation_status
        self.request_id = request_id
        self.mem_allocation_ratio = mem_allocation_ratio
        self.zone_id = zone_id
        self.instance_number_romaster = instance_number_romaster
        self.vpcid = vpcid
        self.v_switch_id = v_switch_id
        self.instance_number_master = instance_number_master
        self.storage_used = storage_used
        self.host_class = host_class
        self.host_cpu = host_cpu
        self.region_id = region_id
        self.ipaddress = ipaddress
        self.account_name = account_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpuallocation_ratio is not None:
            result['CPUAllocationRatio'] = self.cpuallocation_ratio
        if self.disk_allocation_ratio is not None:
            result['DiskAllocationRatio'] = self.disk_allocation_ratio
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.instance_number is not None:
            result['InstanceNumber'] = self.instance_number
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.image_category is not None:
            result['ImageCategory'] = self.image_category
        if self.host_storage is not None:
            result['HostStorage'] = self.host_storage
        if self.instance_number_slave is not None:
            result['InstanceNumberSlave'] = self.instance_number_slave
        if self.open_permission is not None:
            result['OpenPermission'] = self.open_permission
        if self.host_type is not None:
            result['HostType'] = self.host_type
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.host_mem is not None:
            result['HostMem'] = self.host_mem
        if self.memory_used is not None:
            result['MemoryUsed'] = self.memory_used
        if self.host_status is not None:
            result['HostStatus'] = self.host_status
        if self.cpu_used is not None:
            result['CpuUsed'] = self.cpu_used
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_number_roslave is not None:
            result['InstanceNumberROSlave'] = self.instance_number_roslave
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.mem_allocation_ratio is not None:
            result['MemAllocationRatio'] = self.mem_allocation_ratio
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_number_romaster is not None:
            result['InstanceNumberROMaster'] = self.instance_number_romaster
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_number_master is not None:
            result['InstanceNumberMaster'] = self.instance_number_master
        if self.storage_used is not None:
            result['StorageUsed'] = self.storage_used
        if self.host_class is not None:
            result['HostClass'] = self.host_class
        if self.host_cpu is not None:
            result['HostCPU'] = self.host_cpu
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CPUAllocationRatio') is not None:
            self.cpuallocation_ratio = m.get('CPUAllocationRatio')
        if m.get('DiskAllocationRatio') is not None:
            self.disk_allocation_ratio = m.get('DiskAllocationRatio')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('InstanceNumber') is not None:
            self.instance_number = m.get('InstanceNumber')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ImageCategory') is not None:
            self.image_category = m.get('ImageCategory')
        if m.get('HostStorage') is not None:
            self.host_storage = m.get('HostStorage')
        if m.get('InstanceNumberSlave') is not None:
            self.instance_number_slave = m.get('InstanceNumberSlave')
        if m.get('OpenPermission') is not None:
            self.open_permission = m.get('OpenPermission')
        if m.get('HostType') is not None:
            self.host_type = m.get('HostType')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HostMem') is not None:
            self.host_mem = m.get('HostMem')
        if m.get('MemoryUsed') is not None:
            self.memory_used = m.get('MemoryUsed')
        if m.get('HostStatus') is not None:
            self.host_status = m.get('HostStatus')
        if m.get('CpuUsed') is not None:
            self.cpu_used = m.get('CpuUsed')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceNumberROSlave') is not None:
            self.instance_number_roslave = m.get('InstanceNumberROSlave')
        if m.get('AllocationStatus') is not None:
            self.allocation_status = m.get('AllocationStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('MemAllocationRatio') is not None:
            self.mem_allocation_ratio = m.get('MemAllocationRatio')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceNumberROMaster') is not None:
            self.instance_number_romaster = m.get('InstanceNumberROMaster')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('InstanceNumberMaster') is not None:
            self.instance_number_master = m.get('InstanceNumberMaster')
        if m.get('StorageUsed') is not None:
            self.storage_used = m.get('StorageUsed')
        if m.get('HostClass') is not None:
            self.host_class = m.get('HostClass')
        if m.get('HostCPU') is not None:
            self.host_cpu = m.get('HostCPU')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        return self


class DescribeDedicatedHostAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostGroupsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dedicated_host_group_id: str = None,
        image_category: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dedicated_host_group_id = dedicated_host_group_id
        self.image_category = image_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.image_category is not None:
            result['ImageCategory'] = self.image_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('ImageCategory') is not None:
            self.image_category = m.get('ImageCategory')
        return self


class DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroupsZoneIDList(TeaModel):
    def __init__(
        self,
        zone_idlist: List[str] = None,
    ):
        self.zone_idlist = zone_idlist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_idlist is not None:
            result['ZoneIDList'] = self.zone_idlist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneIDList') is not None:
            self.zone_idlist = m.get('ZoneIDList')
        return self


class DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroups(TeaModel):
    def __init__(
        self,
        disk_allocate_ration: float = None,
        create_time: str = None,
        dedicated_host_count_group_by_host_type: Dict[str, Any] = None,
        text: str = None,
        dedicated_host_group_id: str = None,
        disk_utility: float = None,
        mem_used_amount: float = None,
        mem_allocated_amount: float = None,
        cpu_allocation_ratio: int = None,
        mem_allocation_ratio: int = None,
        mem_utility: float = None,
        mem_allocate_ration: float = None,
        cpu_allocated_amount: float = None,
        dedicated_host_group_desc: str = None,
        cpu_allocate_ration: float = None,
        instance_number: int = None,
        open_permission: str = None,
        vpcid: str = None,
        disk_allocated_amount: float = None,
        host_number: int = None,
        disk_used_amount: float = None,
        allocation_policy: str = None,
        engine: str = None,
        disk_allocation_ratio: int = None,
        bastion_instance_id: str = None,
        host_replace_policy: str = None,
        zone_idlist: DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroupsZoneIDList = None,
    ):
        self.disk_allocate_ration = disk_allocate_ration
        self.create_time = create_time
        self.dedicated_host_count_group_by_host_type = dedicated_host_count_group_by_host_type
        self.text = text
        self.dedicated_host_group_id = dedicated_host_group_id
        self.disk_utility = disk_utility
        self.mem_used_amount = mem_used_amount
        self.mem_allocated_amount = mem_allocated_amount
        self.cpu_allocation_ratio = cpu_allocation_ratio
        self.mem_allocation_ratio = mem_allocation_ratio
        self.mem_utility = mem_utility
        self.mem_allocate_ration = mem_allocate_ration
        self.cpu_allocated_amount = cpu_allocated_amount
        self.dedicated_host_group_desc = dedicated_host_group_desc
        self.cpu_allocate_ration = cpu_allocate_ration
        self.instance_number = instance_number
        self.open_permission = open_permission
        self.vpcid = vpcid
        self.disk_allocated_amount = disk_allocated_amount
        self.host_number = host_number
        self.disk_used_amount = disk_used_amount
        self.allocation_policy = allocation_policy
        self.engine = engine
        self.disk_allocation_ratio = disk_allocation_ratio
        self.bastion_instance_id = bastion_instance_id
        self.host_replace_policy = host_replace_policy
        self.zone_idlist = zone_idlist

    def validate(self):
        if self.zone_idlist:
            self.zone_idlist.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_allocate_ration is not None:
            result['DiskAllocateRation'] = self.disk_allocate_ration
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dedicated_host_count_group_by_host_type is not None:
            result['DedicatedHostCountGroupByHostType'] = self.dedicated_host_count_group_by_host_type
        if self.text is not None:
            result['Text'] = self.text
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.disk_utility is not None:
            result['DiskUtility'] = self.disk_utility
        if self.mem_used_amount is not None:
            result['MemUsedAmount'] = self.mem_used_amount
        if self.mem_allocated_amount is not None:
            result['MemAllocatedAmount'] = self.mem_allocated_amount
        if self.cpu_allocation_ratio is not None:
            result['CpuAllocationRatio'] = self.cpu_allocation_ratio
        if self.mem_allocation_ratio is not None:
            result['MemAllocationRatio'] = self.mem_allocation_ratio
        if self.mem_utility is not None:
            result['MemUtility'] = self.mem_utility
        if self.mem_allocate_ration is not None:
            result['MemAllocateRation'] = self.mem_allocate_ration
        if self.cpu_allocated_amount is not None:
            result['CpuAllocatedAmount'] = self.cpu_allocated_amount
        if self.dedicated_host_group_desc is not None:
            result['DedicatedHostGroupDesc'] = self.dedicated_host_group_desc
        if self.cpu_allocate_ration is not None:
            result['CpuAllocateRation'] = self.cpu_allocate_ration
        if self.instance_number is not None:
            result['InstanceNumber'] = self.instance_number
        if self.open_permission is not None:
            result['OpenPermission'] = self.open_permission
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.disk_allocated_amount is not None:
            result['DiskAllocatedAmount'] = self.disk_allocated_amount
        if self.host_number is not None:
            result['HostNumber'] = self.host_number
        if self.disk_used_amount is not None:
            result['DiskUsedAmount'] = self.disk_used_amount
        if self.allocation_policy is not None:
            result['AllocationPolicy'] = self.allocation_policy
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.disk_allocation_ratio is not None:
            result['DiskAllocationRatio'] = self.disk_allocation_ratio
        if self.bastion_instance_id is not None:
            result['BastionInstanceId'] = self.bastion_instance_id
        if self.host_replace_policy is not None:
            result['HostReplacePolicy'] = self.host_replace_policy
        if self.zone_idlist is not None:
            result['ZoneIDList'] = self.zone_idlist.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskAllocateRation') is not None:
            self.disk_allocate_ration = m.get('DiskAllocateRation')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DedicatedHostCountGroupByHostType') is not None:
            self.dedicated_host_count_group_by_host_type = m.get('DedicatedHostCountGroupByHostType')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('DiskUtility') is not None:
            self.disk_utility = m.get('DiskUtility')
        if m.get('MemUsedAmount') is not None:
            self.mem_used_amount = m.get('MemUsedAmount')
        if m.get('MemAllocatedAmount') is not None:
            self.mem_allocated_amount = m.get('MemAllocatedAmount')
        if m.get('CpuAllocationRatio') is not None:
            self.cpu_allocation_ratio = m.get('CpuAllocationRatio')
        if m.get('MemAllocationRatio') is not None:
            self.mem_allocation_ratio = m.get('MemAllocationRatio')
        if m.get('MemUtility') is not None:
            self.mem_utility = m.get('MemUtility')
        if m.get('MemAllocateRation') is not None:
            self.mem_allocate_ration = m.get('MemAllocateRation')
        if m.get('CpuAllocatedAmount') is not None:
            self.cpu_allocated_amount = m.get('CpuAllocatedAmount')
        if m.get('DedicatedHostGroupDesc') is not None:
            self.dedicated_host_group_desc = m.get('DedicatedHostGroupDesc')
        if m.get('CpuAllocateRation') is not None:
            self.cpu_allocate_ration = m.get('CpuAllocateRation')
        if m.get('InstanceNumber') is not None:
            self.instance_number = m.get('InstanceNumber')
        if m.get('OpenPermission') is not None:
            self.open_permission = m.get('OpenPermission')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('DiskAllocatedAmount') is not None:
            self.disk_allocated_amount = m.get('DiskAllocatedAmount')
        if m.get('HostNumber') is not None:
            self.host_number = m.get('HostNumber')
        if m.get('DiskUsedAmount') is not None:
            self.disk_used_amount = m.get('DiskUsedAmount')
        if m.get('AllocationPolicy') is not None:
            self.allocation_policy = m.get('AllocationPolicy')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('DiskAllocationRatio') is not None:
            self.disk_allocation_ratio = m.get('DiskAllocationRatio')
        if m.get('BastionInstanceId') is not None:
            self.bastion_instance_id = m.get('BastionInstanceId')
        if m.get('HostReplacePolicy') is not None:
            self.host_replace_policy = m.get('HostReplacePolicy')
        if m.get('ZoneIDList') is not None:
            temp_model = DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroupsZoneIDList()
            self.zone_idlist = temp_model.from_map(m['ZoneIDList'])
        return self


class DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroups(TeaModel):
    def __init__(
        self,
        dedicated_host_groups: List[DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroups] = None,
    ):
        self.dedicated_host_groups = dedicated_host_groups

    def validate(self):
        if self.dedicated_host_groups:
            for k in self.dedicated_host_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostGroups'] = []
        if self.dedicated_host_groups is not None:
            for k in self.dedicated_host_groups:
                result['DedicatedHostGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_host_groups = []
        if m.get('DedicatedHostGroups') is not None:
            for k in m.get('DedicatedHostGroups'):
                temp_model = DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroupsDedicatedHostGroups()
                self.dedicated_host_groups.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_host_groups: DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroups = None,
    ):
        self.request_id = request_id
        self.dedicated_host_groups = dedicated_host_groups

    def validate(self):
        if self.dedicated_host_groups:
            self.dedicated_host_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_groups is not None:
            result['DedicatedHostGroups'] = self.dedicated_host_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHostGroups') is not None:
            temp_model = DescribeDedicatedHostGroupsResponseBodyDedicatedHostGroups()
            self.dedicated_host_groups = temp_model.from_map(m['DedicatedHostGroups'])
        return self


class DescribeDedicatedHostGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostImageCategoriesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        host_group: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.host_group = host_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.host_group is not None:
            result['HostGroup'] = self.host_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('HostGroup') is not None:
            self.host_group = m.get('HostGroup')
        return self


class DescribeDedicatedHostImageCategoriesResponseBodyImagesImages(TeaModel):
    def __init__(
        self,
        image_code: str = None,
        image_name: str = None,
    ):
        self.image_code = image_code
        self.image_name = image_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_code is not None:
            result['ImageCode'] = self.image_code
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageCode') is not None:
            self.image_code = m.get('ImageCode')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        return self


class DescribeDedicatedHostImageCategoriesResponseBodyImages(TeaModel):
    def __init__(
        self,
        images: List[DescribeDedicatedHostImageCategoriesResponseBodyImagesImages] = None,
    ):
        self.images = images

    def validate(self):
        if self.images:
            for k in self.images:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = DescribeDedicatedHostImageCategoriesResponseBodyImagesImages()
                self.images.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostImageCategoriesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        images: DescribeDedicatedHostImageCategoriesResponseBodyImages = None,
    ):
        self.request_id = request_id
        self.images = images

    def validate(self):
        if self.images:
            self.images.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.images is not None:
            result['Images'] = self.images.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Images') is not None:
            temp_model = DescribeDedicatedHostImageCategoriesResponseBodyImages()
            self.images = temp_model.from_map(m['Images'])
        return self


class DescribeDedicatedHostImageCategoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostImageCategoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostImageCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        dedicated_host_group_id: str = None,
        order_id: int = None,
        host_type: str = None,
        host_status: str = None,
        allocation_status: str = None,
        zone_id: str = None,
        dedicated_host_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.dedicated_host_group_id = dedicated_host_group_id
        self.order_id = order_id
        self.host_type = host_type
        self.host_status = host_status
        self.allocation_status = allocation_status
        self.zone_id = zone_id
        self.dedicated_host_id = dedicated_host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.host_type is not None:
            result['HostType'] = self.host_type
        if self.host_status is not None:
            result['HostStatus'] = self.host_status
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('HostType') is not None:
            self.host_type = m.get('HostType')
        if m.get('HostStatus') is not None:
            self.host_status = m.get('HostStatus')
        if m.get('AllocationStatus') is not None:
            self.allocation_status = m.get('AllocationStatus')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHosts(TeaModel):
    def __init__(
        self,
        host_type: str = None,
        host_storage: str = None,
        memory_used: str = None,
        dedicated_host_group_id: str = None,
        allocation_status: str = None,
        storage_used: str = None,
        dedicated_host_id: str = None,
        mem_allocation_ratio: str = None,
        created_time: str = None,
        ipaddress: str = None,
        host_status: str = None,
        host_name: str = None,
        host_cpu: str = None,
        instance_number: str = None,
        open_permission: str = None,
        cpu_used: str = None,
        vpcid: str = None,
        host_class: str = None,
        end_time: str = None,
        v_switch_id: str = None,
        cpuallocation_ratio: str = None,
        zone_id: str = None,
        image_category: str = None,
        engine: str = None,
        disk_allocation_ratio: str = None,
        host_mem: str = None,
        bastion_instance_id: str = None,
        account_name: str = None,
    ):
        self.host_type = host_type
        self.host_storage = host_storage
        self.memory_used = memory_used
        self.dedicated_host_group_id = dedicated_host_group_id
        self.allocation_status = allocation_status
        self.storage_used = storage_used
        self.dedicated_host_id = dedicated_host_id
        self.mem_allocation_ratio = mem_allocation_ratio
        self.created_time = created_time
        self.ipaddress = ipaddress
        self.host_status = host_status
        self.host_name = host_name
        self.host_cpu = host_cpu
        self.instance_number = instance_number
        self.open_permission = open_permission
        self.cpu_used = cpu_used
        self.vpcid = vpcid
        self.host_class = host_class
        self.end_time = end_time
        self.v_switch_id = v_switch_id
        self.cpuallocation_ratio = cpuallocation_ratio
        self.zone_id = zone_id
        self.image_category = image_category
        self.engine = engine
        self.disk_allocation_ratio = disk_allocation_ratio
        self.host_mem = host_mem
        self.bastion_instance_id = bastion_instance_id
        self.account_name = account_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_type is not None:
            result['HostType'] = self.host_type
        if self.host_storage is not None:
            result['HostStorage'] = self.host_storage
        if self.memory_used is not None:
            result['MemoryUsed'] = self.memory_used
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.storage_used is not None:
            result['StorageUsed'] = self.storage_used
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.mem_allocation_ratio is not None:
            result['MemAllocationRatio'] = self.mem_allocation_ratio
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.ipaddress is not None:
            result['IPAddress'] = self.ipaddress
        if self.host_status is not None:
            result['HostStatus'] = self.host_status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_cpu is not None:
            result['HostCPU'] = self.host_cpu
        if self.instance_number is not None:
            result['InstanceNumber'] = self.instance_number
        if self.open_permission is not None:
            result['OpenPermission'] = self.open_permission
        if self.cpu_used is not None:
            result['CpuUsed'] = self.cpu_used
        if self.vpcid is not None:
            result['VPCId'] = self.vpcid
        if self.host_class is not None:
            result['HostClass'] = self.host_class
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.cpuallocation_ratio is not None:
            result['CPUAllocationRatio'] = self.cpuallocation_ratio
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.image_category is not None:
            result['ImageCategory'] = self.image_category
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.disk_allocation_ratio is not None:
            result['DiskAllocationRatio'] = self.disk_allocation_ratio
        if self.host_mem is not None:
            result['HostMem'] = self.host_mem
        if self.bastion_instance_id is not None:
            result['BastionInstanceId'] = self.bastion_instance_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostType') is not None:
            self.host_type = m.get('HostType')
        if m.get('HostStorage') is not None:
            self.host_storage = m.get('HostStorage')
        if m.get('MemoryUsed') is not None:
            self.memory_used = m.get('MemoryUsed')
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('AllocationStatus') is not None:
            self.allocation_status = m.get('AllocationStatus')
        if m.get('StorageUsed') is not None:
            self.storage_used = m.get('StorageUsed')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('MemAllocationRatio') is not None:
            self.mem_allocation_ratio = m.get('MemAllocationRatio')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('IPAddress') is not None:
            self.ipaddress = m.get('IPAddress')
        if m.get('HostStatus') is not None:
            self.host_status = m.get('HostStatus')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostCPU') is not None:
            self.host_cpu = m.get('HostCPU')
        if m.get('InstanceNumber') is not None:
            self.instance_number = m.get('InstanceNumber')
        if m.get('OpenPermission') is not None:
            self.open_permission = m.get('OpenPermission')
        if m.get('CpuUsed') is not None:
            self.cpu_used = m.get('CpuUsed')
        if m.get('VPCId') is not None:
            self.vpcid = m.get('VPCId')
        if m.get('HostClass') is not None:
            self.host_class = m.get('HostClass')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('CPUAllocationRatio') is not None:
            self.cpuallocation_ratio = m.get('CPUAllocationRatio')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ImageCategory') is not None:
            self.image_category = m.get('ImageCategory')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('DiskAllocationRatio') is not None:
            self.disk_allocation_ratio = m.get('DiskAllocationRatio')
        if m.get('HostMem') is not None:
            self.host_mem = m.get('HostMem')
        if m.get('BastionInstanceId') is not None:
            self.bastion_instance_id = m.get('BastionInstanceId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHosts(TeaModel):
    def __init__(
        self,
        dedicated_hosts: List[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHosts] = None,
    ):
        self.dedicated_hosts = dedicated_hosts

    def validate(self):
        if self.dedicated_hosts:
            for k in self.dedicated_hosts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHosts'] = []
        if self.dedicated_hosts is not None:
            for k in self.dedicated_hosts:
                result['DedicatedHosts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_hosts = []
        if m.get('DedicatedHosts') is not None:
            for k in m.get('DedicatedHosts'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHosts()
                self.dedicated_hosts.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_host_group_id: str = None,
        request_id: str = None,
        dedicated_hosts: DescribeDedicatedHostsResponseBodyDedicatedHosts = None,
    ):
        self.dedicated_host_group_id = dedicated_host_group_id
        self.request_id = request_id
        self.dedicated_hosts = dedicated_hosts

    def validate(self):
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_group_id is not None:
            result['DedicatedHostGroupId'] = self.dedicated_host_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedHostGroupId') is not None:
            self.dedicated_host_group_id = m.get('DedicatedHostGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(m['DedicatedHosts'])
        return self


class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDedicatedHostsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDetachedBackupsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        backup_id: str = None,
        backup_status: str = None,
        backup_mode: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        region: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.backup_id = backup_id
        self.backup_status = backup_status
        self.backup_mode = backup_mode
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeDetachedBackupsResponseBodyItemsBackup(TeaModel):
    def __init__(
        self,
        consistent_time: int = None,
        store_status: str = None,
        backup_status: str = None,
        backup_type: str = None,
        backup_start_time: str = None,
        backup_download_url: str = None,
        is_avail: int = None,
        meta_status: str = None,
        backup_end_time: str = None,
        backup_id: str = None,
        host_instance_id: str = None,
        backup_intranet_download_url: str = None,
        backup_size: int = None,
        backup_mode: str = None,
        dbinstance_id: str = None,
        backup_method: str = None,
    ):
        self.consistent_time = consistent_time
        self.store_status = store_status
        self.backup_status = backup_status
        self.backup_type = backup_type
        self.backup_start_time = backup_start_time
        self.backup_download_url = backup_download_url
        self.is_avail = is_avail
        self.meta_status = meta_status
        self.backup_end_time = backup_end_time
        self.backup_id = backup_id
        self.host_instance_id = host_instance_id
        self.backup_intranet_download_url = backup_intranet_download_url
        self.backup_size = backup_size
        self.backup_mode = backup_mode
        self.dbinstance_id = dbinstance_id
        self.backup_method = backup_method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_time is not None:
            result['ConsistentTime'] = self.consistent_time
        if self.store_status is not None:
            result['StoreStatus'] = self.store_status
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_download_url is not None:
            result['BackupDownloadURL'] = self.backup_download_url
        if self.is_avail is not None:
            result['IsAvail'] = self.is_avail
        if self.meta_status is not None:
            result['MetaStatus'] = self.meta_status
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.host_instance_id is not None:
            result['HostInstanceID'] = self.host_instance_id
        if self.backup_intranet_download_url is not None:
            result['BackupIntranetDownloadURL'] = self.backup_intranet_download_url
        if self.backup_size is not None:
            result['BackupSize'] = self.backup_size
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentTime') is not None:
            self.consistent_time = m.get('ConsistentTime')
        if m.get('StoreStatus') is not None:
            self.store_status = m.get('StoreStatus')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupDownloadURL') is not None:
            self.backup_download_url = m.get('BackupDownloadURL')
        if m.get('IsAvail') is not None:
            self.is_avail = m.get('IsAvail')
        if m.get('MetaStatus') is not None:
            self.meta_status = m.get('MetaStatus')
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('HostInstanceID') is not None:
            self.host_instance_id = m.get('HostInstanceID')
        if m.get('BackupIntranetDownloadURL') is not None:
            self.backup_intranet_download_url = m.get('BackupIntranetDownloadURL')
        if m.get('BackupSize') is not None:
            self.backup_size = m.get('BackupSize')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        return self


class DescribeDetachedBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        backup: List[DescribeDetachedBackupsResponseBodyItemsBackup] = None,
    ):
        self.backup = backup

    def validate(self):
        if self.backup:
            for k in self.backup:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Backup'] = []
        if self.backup is not None:
            for k in self.backup:
                result['Backup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup = []
        if m.get('Backup') is not None:
            for k in m.get('Backup'):
                temp_model = DescribeDetachedBackupsResponseBodyItemsBackup()
                self.backup.append(temp_model.from_map(k))
        return self


class DescribeDetachedBackupsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: str = None,
        request_id: str = None,
        page_record_count: str = None,
        total_record_count: str = None,
        items: DescribeDetachedBackupsResponseBodyItems = None,
    ):
        self.page_number = page_number
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeDetachedBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDetachedBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDetachedBackupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDetachedBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosticReportListRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
    ):
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeDiagnosticReportListResponseBodyReportList(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        diagnostic_time: str = None,
        start_time: str = None,
        score: int = None,
        download_url: str = None,
    ):
        self.end_time = end_time
        self.diagnostic_time = diagnostic_time
        self.start_time = start_time
        self.score = score
        self.download_url = download_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.diagnostic_time is not None:
            result['DiagnosticTime'] = self.diagnostic_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.score is not None:
            result['Score'] = self.score
        if self.download_url is not None:
            result['DownloadURL'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DiagnosticTime') is not None:
            self.diagnostic_time = m.get('DiagnosticTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('DownloadURL') is not None:
            self.download_url = m.get('DownloadURL')
        return self


class DescribeDiagnosticReportListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        report_list: List[DescribeDiagnosticReportListResponseBodyReportList] = None,
    ):
        self.request_id = request_id
        self.report_list = report_list

    def validate(self):
        if self.report_list:
            for k in self.report_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ReportList'] = []
        if self.report_list is not None:
            for k in self.report_list:
                result['ReportList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.report_list = []
        if m.get('ReportList') is not None:
            for k in m.get('ReportList'):
                temp_model = DescribeDiagnosticReportListResponseBodyReportList()
                self.report_list.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDiagnosticReportListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosticReportListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDownloadLinkDetailsRequest(TeaModel):
    def __init__(
        self,
        backup_set_id: int = None,
        max_records_per_page: int = None,
        page_numbers: int = None,
        region_id: str = None,
        data_base_name: str = None,
    ):
        # 实例 ID。
        self.backup_set_id = backup_set_id
        self.max_records_per_page = max_records_per_page
        self.page_numbers = page_numbers
        self.region_id = region_id
        self.data_base_name = data_base_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.max_records_per_page is not None:
            result['MaxRecordsPerPage'] = self.max_records_per_page
        if self.page_numbers is not None:
            result['PageNumbers'] = self.page_numbers
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.data_base_name is not None:
            result['DataBaseName'] = self.data_base_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('MaxRecordsPerPage') is not None:
            self.max_records_per_page = m.get('MaxRecordsPerPage')
        if m.get('PageNumbers') is not None:
            self.page_numbers = m.get('PageNumbers')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DataBaseName') is not None:
            self.data_base_name = m.get('DataBaseName')
        return self


class DescribeDownloadLinkDetailsResponseBodyDataBackupDownloadLinkByDB(TeaModel):
    def __init__(
        self,
        data_base: str = None,
        download_link: str = None,
        intranet_download_link: str = None,
    ):
        # 数据库名称
        self.data_base = data_base
        # 下载链接
        self.download_link = download_link
        # 内网下载链接
        self.intranet_download_link = intranet_download_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_base is not None:
            result['DataBase'] = self.data_base
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataBase') is not None:
            self.data_base = m.get('DataBase')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        return self


class DescribeDownloadLinkDetailsResponseBodyData(TeaModel):
    def __init__(
        self,
        backup_download_link_by_db: List[DescribeDownloadLinkDetailsResponseBodyDataBackupDownloadLinkByDB] = None,
        max_records_per_page: int = None,
        page_numbers: int = None,
        total_records: int = None,
        backup_start_time: str = None,
        backup_end_time: str = None,
        backup_type: str = None,
        backup_method: str = None,
        backup_status: str = None,
        host_instance_id: int = None,
    ):
        # 备份下载链接详情
        self.backup_download_link_by_db = backup_download_link_by_db
        self.max_records_per_page = max_records_per_page
        self.page_numbers = page_numbers
        self.total_records = total_records
        self.backup_start_time = backup_start_time
        self.backup_end_time = backup_end_time
        self.backup_type = backup_type
        self.backup_method = backup_method
        self.backup_status = backup_status
        self.host_instance_id = host_instance_id

    def validate(self):
        if self.backup_download_link_by_db:
            for k in self.backup_download_link_by_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupDownloadLinkByDB'] = []
        if self.backup_download_link_by_db is not None:
            for k in self.backup_download_link_by_db:
                result['BackupDownloadLinkByDB'].append(k.to_map() if k else None)
        if self.max_records_per_page is not None:
            result['MaxRecordsPerPage'] = self.max_records_per_page
        if self.page_numbers is not None:
            result['PageNumbers'] = self.page_numbers
        if self.total_records is not None:
            result['TotalRecords'] = self.total_records
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.backup_method is not None:
            result['BackupMethod'] = self.backup_method
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup_download_link_by_db = []
        if m.get('BackupDownloadLinkByDB') is not None:
            for k in m.get('BackupDownloadLinkByDB'):
                temp_model = DescribeDownloadLinkDetailsResponseBodyDataBackupDownloadLinkByDB()
                self.backup_download_link_by_db.append(temp_model.from_map(k))
        if m.get('MaxRecordsPerPage') is not None:
            self.max_records_per_page = m.get('MaxRecordsPerPage')
        if m.get('PageNumbers') is not None:
            self.page_numbers = m.get('PageNumbers')
        if m.get('TotalRecords') is not None:
            self.total_records = m.get('TotalRecords')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('BackupMethod') is not None:
            self.backup_method = m.get('BackupMethod')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        return self


class DescribeDownloadLinkDetailsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        message: str = None,
        data: DescribeDownloadLinkDetailsResponseBodyData = None,
        code: int = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.message = message
        self.data = data
        self.code = code

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Data') is not None:
            temp_model = DescribeDownloadLinkDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DescribeDownloadLinkDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDownloadLinkDetailsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDownloadLinkDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDTCSecurityIpHostsForSQLServerRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDTCSecurityIpHostsForSQLServerResponseBodyItemsWhiteListGroups(TeaModel):
    def __init__(
        self,
        security_ip_hosts: str = None,
        whitelist_group_name: str = None,
    ):
        self.security_ip_hosts = security_ip_hosts
        self.whitelist_group_name = whitelist_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_ip_hosts is not None:
            result['SecurityIpHosts'] = self.security_ip_hosts
        if self.whitelist_group_name is not None:
            result['WhitelistGroupName'] = self.whitelist_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityIpHosts') is not None:
            self.security_ip_hosts = m.get('SecurityIpHosts')
        if m.get('WhitelistGroupName') is not None:
            self.whitelist_group_name = m.get('WhitelistGroupName')
        return self


class DescribeDTCSecurityIpHostsForSQLServerResponseBodyItems(TeaModel):
    def __init__(
        self,
        white_list_groups: List[DescribeDTCSecurityIpHostsForSQLServerResponseBodyItemsWhiteListGroups] = None,
    ):
        self.white_list_groups = white_list_groups

    def validate(self):
        if self.white_list_groups:
            for k in self.white_list_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WhiteListGroups'] = []
        if self.white_list_groups is not None:
            for k in self.white_list_groups:
                result['WhiteListGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.white_list_groups = []
        if m.get('WhiteListGroups') is not None:
            for k in m.get('WhiteListGroups'):
                temp_model = DescribeDTCSecurityIpHostsForSQLServerResponseBodyItemsWhiteListGroups()
                self.white_list_groups.append(temp_model.from_map(k))
        return self


class DescribeDTCSecurityIpHostsForSQLServerResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        ip_host_pair_num: str = None,
        items: DescribeDTCSecurityIpHostsForSQLServerResponseBodyItems = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.ip_host_pair_num = ip_host_pair_num
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_host_pair_num is not None:
            result['IpHostPairNum'] = self.ip_host_pair_num
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpHostPairNum') is not None:
            self.ip_host_pair_num = m.get('IpHostPairNum')
        if m.get('Items') is not None:
            temp_model = DescribeDTCSecurityIpHostsForSQLServerResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeDTCSecurityIpHostsForSQLServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDTCSecurityIpHostsForSQLServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDTCSecurityIpHostsForSQLServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeErrorLogsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeErrorLogsResponseBodyItemsErrorLog(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_info: str = None,
    ):
        self.create_time = create_time
        self.error_info = error_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        return self


class DescribeErrorLogsResponseBodyItems(TeaModel):
    def __init__(
        self,
        error_log: List[DescribeErrorLogsResponseBodyItemsErrorLog] = None,
    ):
        self.error_log = error_log

    def validate(self):
        if self.error_log:
            for k in self.error_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ErrorLog'] = []
        if self.error_log is not None:
            for k in self.error_log:
                result['ErrorLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.error_log = []
        if m.get('ErrorLog') is not None:
            for k in m.get('ErrorLog'):
                temp_model = DescribeErrorLogsResponseBodyItemsErrorLog()
                self.error_log.append(temp_model.from_map(k))
        return self


class DescribeErrorLogsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeErrorLogsResponseBodyItems = None,
    ):
        self.page_number = page_number
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeErrorLogsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeErrorLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeErrorLogsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeErrorLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeEventsResponseBodyEventItemsEventItems(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_time: str = None,
        event_user_type: str = None,
        event_record_time: str = None,
        caller_uid: int = None,
        region_id: str = None,
        event_id: int = None,
        event_type: str = None,
        resource_type: str = None,
        event_payload: str = None,
        event_reason: str = None,
        resource_name: str = None,
    ):
        self.event_name = event_name
        self.event_time = event_time
        self.event_user_type = event_user_type
        self.event_record_time = event_record_time
        self.caller_uid = caller_uid
        self.region_id = region_id
        self.event_id = event_id
        self.event_type = event_type
        self.resource_type = resource_type
        self.event_payload = event_payload
        self.event_reason = event_reason
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.event_user_type is not None:
            result['EventUserType'] = self.event_user_type
        if self.event_record_time is not None:
            result['EventRecordTime'] = self.event_record_time
        if self.caller_uid is not None:
            result['CallerUid'] = self.caller_uid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.event_payload is not None:
            result['EventPayload'] = self.event_payload
        if self.event_reason is not None:
            result['EventReason'] = self.event_reason
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        if m.get('EventUserType') is not None:
            self.event_user_type = m.get('EventUserType')
        if m.get('EventRecordTime') is not None:
            self.event_record_time = m.get('EventRecordTime')
        if m.get('CallerUid') is not None:
            self.caller_uid = m.get('CallerUid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('EventPayload') is not None:
            self.event_payload = m.get('EventPayload')
        if m.get('EventReason') is not None:
            self.event_reason = m.get('EventReason')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class DescribeEventsResponseBodyEventItems(TeaModel):
    def __init__(
        self,
        event_items: List[DescribeEventsResponseBodyEventItemsEventItems] = None,
    ):
        self.event_items = event_items

    def validate(self):
        if self.event_items:
            for k in self.event_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventItems'] = []
        if self.event_items is not None:
            for k in self.event_items:
                result['EventItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_items = []
        if m.get('EventItems') is not None:
            for k in m.get('EventItems'):
                temp_model = DescribeEventsResponseBodyEventItemsEventItems()
                self.event_items.append(temp_model.from_map(k))
        return self


class DescribeEventsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        request_id: str = None,
        page_size: int = None,
        total_record_count: int = None,
        event_items: DescribeEventsResponseBodyEventItems = None,
    ):
        self.page_number = page_number
        self.request_id = request_id
        self.page_size = page_size
        self.total_record_count = total_record_count
        self.event_items = event_items

    def validate(self):
        if self.event_items:
            self.event_items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.event_items is not None:
            result['EventItems'] = self.event_items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('EventItems') is not None:
            temp_model = DescribeEventsResponseBodyEventItems()
            self.event_items = temp_model.from_map(m['EventItems'])
        return self


class DescribeEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHADiagnoseConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeHADiagnoseConfigResponseBody(TeaModel):
    def __init__(
        self,
        tcp_connection_type: str = None,
        request_id: str = None,
    ):
        self.tcp_connection_type = tcp_connection_type
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tcp_connection_type is not None:
            result['TcpConnectionType'] = self.tcp_connection_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TcpConnectionType') is not None:
            self.tcp_connection_type = m.get('TcpConnectionType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHADiagnoseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHADiagnoseConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHADiagnoseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHASwitchConfigRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeHASwitchConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        manual_hatime: str = None,
        haconfig: str = None,
    ):
        self.request_id = request_id
        self.manual_hatime = manual_hatime
        self.haconfig = haconfig

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.manual_hatime is not None:
            result['ManualHATime'] = self.manual_hatime
        if self.haconfig is not None:
            result['HAConfig'] = self.haconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ManualHATime') is not None:
            self.manual_hatime = m.get('ManualHATime')
        if m.get('HAConfig') is not None:
            self.haconfig = m.get('HAConfig')
        return self


class DescribeHASwitchConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHASwitchConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHASwitchConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAutoRenewalAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        proxy_id: str = None,
        region_id: str = None,
        dbinstance_id: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.proxy_id = proxy_id
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeInstanceAutoRenewalAttributeResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        status: str = None,
        duration: int = None,
        dbinstance_id: str = None,
        auto_renew: str = None,
        region_id: str = None,
    ):
        self.status = status
        self.duration = duration
        self.dbinstance_id = dbinstance_id
        self.auto_renew = auto_renew
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeInstanceAutoRenewalAttributeResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[DescribeInstanceAutoRenewalAttributeResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeInstanceAutoRenewalAttributeResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeInstanceAutoRenewalAttributeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeInstanceAutoRenewalAttributeResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeInstanceAutoRenewalAttributeResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeInstanceAutoRenewalAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceAutoRenewalAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAutoRenewalAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceCrossBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeInstanceCrossBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        log_backup_enabled_time: str = None,
        backup_enabled: str = None,
        dbinstance_status: str = None,
        lock_mode: str = None,
        engine_version: str = None,
        region_id: str = None,
        log_backup_enabled: str = None,
        request_id: str = None,
        retent_type: int = None,
        retention: int = None,
        cross_backup_type: str = None,
        cross_backup_region: str = None,
        dbinstance_id: str = None,
        engine: str = None,
        backup_enabled_time: str = None,
        dbinstance_description: str = None,
    ):
        self.log_backup_enabled_time = log_backup_enabled_time
        self.backup_enabled = backup_enabled
        self.dbinstance_status = dbinstance_status
        self.lock_mode = lock_mode
        self.engine_version = engine_version
        self.region_id = region_id
        self.log_backup_enabled = log_backup_enabled
        self.request_id = request_id
        self.retent_type = retent_type
        self.retention = retention
        self.cross_backup_type = cross_backup_type
        self.cross_backup_region = cross_backup_region
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.backup_enabled_time = backup_enabled_time
        self.dbinstance_description = dbinstance_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_backup_enabled_time is not None:
            result['LogBackupEnabledTime'] = self.log_backup_enabled_time
        if self.backup_enabled is not None:
            result['BackupEnabled'] = self.backup_enabled
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.log_backup_enabled is not None:
            result['LogBackupEnabled'] = self.log_backup_enabled
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.retent_type is not None:
            result['RetentType'] = self.retent_type
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.cross_backup_type is not None:
            result['CrossBackupType'] = self.cross_backup_type
        if self.cross_backup_region is not None:
            result['CrossBackupRegion'] = self.cross_backup_region
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.backup_enabled_time is not None:
            result['BackupEnabledTime'] = self.backup_enabled_time
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogBackupEnabledTime') is not None:
            self.log_backup_enabled_time = m.get('LogBackupEnabledTime')
        if m.get('BackupEnabled') is not None:
            self.backup_enabled = m.get('BackupEnabled')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LogBackupEnabled') is not None:
            self.log_backup_enabled = m.get('LogBackupEnabled')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetentType') is not None:
            self.retent_type = m.get('RetentType')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('CrossBackupType') is not None:
            self.cross_backup_type = m.get('CrossBackupType')
        if m.get('CrossBackupRegion') is not None:
            self.cross_backup_region = m.get('CrossBackupRegion')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('BackupEnabledTime') is not None:
            self.backup_enabled_time = m.get('BackupEnabledTime')
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        return self


class DescribeInstanceCrossBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceCrossBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceCrossBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceKeywordsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        key: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.key = key
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.key is not None:
            result['Key'] = self.key
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeInstanceKeywordsResponseBodyWords(TeaModel):
    def __init__(
        self,
        word: List[str] = None,
    ):
        self.word = word

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word is not None:
            result['word'] = self.word
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('word') is not None:
            self.word = m.get('word')
        return self


class DescribeInstanceKeywordsResponseBody(TeaModel):
    def __init__(
        self,
        key: str = None,
        request_id: str = None,
        words: DescribeInstanceKeywordsResponseBodyWords = None,
    ):
        self.key = key
        self.request_id = request_id
        self.words = words

    def validate(self):
        if self.words:
            self.words.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.words is not None:
            result['Words'] = self.words.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Words') is not None:
            temp_model = DescribeInstanceKeywordsResponseBodyWords()
            self.words = temp_model.from_map(m['Words'])
        return self


class DescribeInstanceKeywordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceKeywordsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceKeywordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLocalAvailableRecoveryTimeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        region: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeLocalAvailableRecoveryTimeResponseBody(TeaModel):
    def __init__(
        self,
        recovery_end_time: str = None,
        dbinstance_id: str = None,
        request_id: str = None,
        recovery_begin_time: str = None,
    ):
        self.recovery_end_time = recovery_end_time
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.recovery_begin_time = recovery_begin_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovery_end_time is not None:
            result['RecoveryEndTime'] = self.recovery_end_time
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.recovery_begin_time is not None:
            result['RecoveryBeginTime'] = self.recovery_begin_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecoveryEndTime') is not None:
            self.recovery_end_time = m.get('RecoveryEndTime')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RecoveryBeginTime') is not None:
            self.recovery_begin_time = m.get('RecoveryBeginTime')
        return self


class DescribeLocalAvailableRecoveryTimeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLocalAvailableRecoveryTimeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLocalAvailableRecoveryTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogBackupFilesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeLogBackupFilesResponseBodyItemsBinLogFile(TeaModel):
    def __init__(
        self,
        log_begin_time: str = None,
        intranet_download_link: str = None,
        link_expired_time: str = None,
        download_link: str = None,
        log_end_time: str = None,
        file_size: int = None,
    ):
        self.log_begin_time = log_begin_time
        self.intranet_download_link = intranet_download_link
        self.link_expired_time = link_expired_time
        self.download_link = download_link
        self.log_end_time = log_end_time
        self.file_size = file_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_begin_time is not None:
            result['LogBeginTime'] = self.log_begin_time
        if self.intranet_download_link is not None:
            result['IntranetDownloadLink'] = self.intranet_download_link
        if self.link_expired_time is not None:
            result['LinkExpiredTime'] = self.link_expired_time
        if self.download_link is not None:
            result['DownloadLink'] = self.download_link
        if self.log_end_time is not None:
            result['LogEndTime'] = self.log_end_time
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogBeginTime') is not None:
            self.log_begin_time = m.get('LogBeginTime')
        if m.get('IntranetDownloadLink') is not None:
            self.intranet_download_link = m.get('IntranetDownloadLink')
        if m.get('LinkExpiredTime') is not None:
            self.link_expired_time = m.get('LinkExpiredTime')
        if m.get('DownloadLink') is not None:
            self.download_link = m.get('DownloadLink')
        if m.get('LogEndTime') is not None:
            self.log_end_time = m.get('LogEndTime')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class DescribeLogBackupFilesResponseBodyItems(TeaModel):
    def __init__(
        self,
        bin_log_file: List[DescribeLogBackupFilesResponseBodyItemsBinLogFile] = None,
    ):
        self.bin_log_file = bin_log_file

    def validate(self):
        if self.bin_log_file:
            for k in self.bin_log_file:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BinLogFile'] = []
        if self.bin_log_file is not None:
            for k in self.bin_log_file:
                result['BinLogFile'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bin_log_file = []
        if m.get('BinLogFile') is not None:
            for k in m.get('BinLogFile'):
                temp_model = DescribeLogBackupFilesResponseBodyItemsBinLogFile()
                self.bin_log_file.append(temp_model.from_map(k))
        return self


class DescribeLogBackupFilesResponseBody(TeaModel):
    def __init__(
        self,
        total_file_size: int = None,
        page_number: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeLogBackupFilesResponseBodyItems = None,
    ):
        self.total_file_size = total_file_size
        self.page_number = page_number
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_file_size is not None:
            result['TotalFileSize'] = self.total_file_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalFileSize') is not None:
            self.total_file_size = m.get('TotalFileSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeLogBackupFilesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeLogBackupFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLogBackupFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLogBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetaListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        restore_type: str = None,
        backup_set_id: int = None,
        restore_time: str = None,
        get_db_name: str = None,
        pattern: str = None,
        page_size: int = None,
        page_index: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.restore_type = restore_type
        self.backup_set_id = backup_set_id
        self.restore_time = restore_time
        self.get_db_name = get_db_name
        self.pattern = pattern
        self.page_size = page_size
        self.page_index = page_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.backup_set_id is not None:
            result['BackupSetID'] = self.backup_set_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time
        if self.get_db_name is not None:
            result['GetDbName'] = self.get_db_name
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('BackupSetID') is not None:
            self.backup_set_id = m.get('BackupSetID')
        if m.get('RestoreTime') is not None:
            self.restore_time = m.get('RestoreTime')
        if m.get('GetDbName') is not None:
            self.get_db_name = m.get('GetDbName')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        return self


class DescribeMetaListResponseBodyItemsMeta(TeaModel):
    def __init__(
        self,
        tables: str = None,
        database: str = None,
        size: str = None,
    ):
        self.tables = tables
        self.database = database
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tables is not None:
            result['Tables'] = self.tables
        if self.database is not None:
            result['Database'] = self.database
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeMetaListResponseBodyItems(TeaModel):
    def __init__(
        self,
        meta: List[DescribeMetaListResponseBodyItemsMeta] = None,
    ):
        self.meta = meta

    def validate(self):
        if self.meta:
            for k in self.meta:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Meta'] = []
        if self.meta is not None:
            for k in self.meta:
                result['Meta'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.meta = []
        if m.get('Meta') is not None:
            for k in m.get('Meta'):
                temp_model = DescribeMetaListResponseBodyItemsMeta()
                self.meta.append(temp_model.from_map(k))
        return self


class DescribeMetaListResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_name: str = None,
        total_page_count: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        page_number: int = None,
        items: DescribeMetaListResponseBodyItems = None,
    ):
        self.dbinstance_name = dbinstance_name
        self.total_page_count = total_page_count
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.total_page_count is not None:
            result['TotalPageCount'] = self.total_page_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('TotalPageCount') is not None:
            self.total_page_count = m.get('TotalPageCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = DescribeMetaListResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeMetaListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMetaListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrateTaskByIdRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        migrate_task_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.migrate_task_id = migrate_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        return self


class DescribeMigrateTaskByIdResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        end_time: str = None,
        dbinstance_name: str = None,
        request_id: str = None,
        description: str = None,
        create_time: str = None,
        dbname: str = None,
        backup_mode: str = None,
        migrate_task_id: str = None,
        is_dbreplaced: str = None,
    ):
        self.status = status
        self.end_time = end_time
        self.dbinstance_name = dbinstance_name
        self.request_id = request_id
        self.description = description
        self.create_time = create_time
        self.dbname = dbname
        self.backup_mode = backup_mode
        self.migrate_task_id = migrate_task_id
        self.is_dbreplaced = is_dbreplaced

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.is_dbreplaced is not None:
            result['IsDBReplaced'] = self.is_dbreplaced
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('IsDBReplaced') is not None:
            self.is_dbreplaced = m.get('IsDBReplaced')
        return self


class DescribeMigrateTaskByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMigrateTaskByIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMigrateTaskByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrateTasksRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeMigrateTasksResponseBodyItemsMigrateTask(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        status: str = None,
        description: str = None,
        create_time: str = None,
        dbname: str = None,
        backup_mode: str = None,
        migrate_task_id: str = None,
        is_dbreplaced: str = None,
    ):
        self.end_time = end_time
        self.status = status
        self.description = description
        self.create_time = create_time
        self.dbname = dbname
        self.backup_mode = backup_mode
        self.migrate_task_id = migrate_task_id
        self.is_dbreplaced = is_dbreplaced

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.is_dbreplaced is not None:
            result['IsDBReplaced'] = self.is_dbreplaced
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('IsDBReplaced') is not None:
            self.is_dbreplaced = m.get('IsDBReplaced')
        return self


class DescribeMigrateTasksResponseBodyItems(TeaModel):
    def __init__(
        self,
        migrate_task: List[DescribeMigrateTasksResponseBodyItemsMigrateTask] = None,
    ):
        self.migrate_task = migrate_task

    def validate(self):
        if self.migrate_task:
            for k in self.migrate_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MigrateTask'] = []
        if self.migrate_task is not None:
            for k in self.migrate_task:
                result['MigrateTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.migrate_task = []
        if m.get('MigrateTask') is not None:
            for k in m.get('MigrateTask'):
                temp_model = DescribeMigrateTasksResponseBodyItemsMigrateTask()
                self.migrate_task.append(temp_model.from_map(k))
        return self


class DescribeMigrateTasksResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        page_number: int = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        items: DescribeMigrateTasksResponseBodyItems = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.page_number = page_number
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('Items') is not None:
            temp_model = DescribeMigrateTasksResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeMigrateTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMigrateTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMigrateTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrateTasksForSQLServerRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeMigrateTasksForSQLServerResponseBodyItemsMigrateTask(TeaModel):
    def __init__(
        self,
        migrate_iask_id: str = None,
        end_time: str = None,
        status: str = None,
        task_type: str = None,
        create_time: str = None,
        dbname: str = None,
        is_dbreplaced: str = None,
        desc: str = None,
    ):
        self.migrate_iask_id = migrate_iask_id
        self.end_time = end_time
        self.status = status
        self.task_type = task_type
        self.create_time = create_time
        self.dbname = dbname
        self.is_dbreplaced = is_dbreplaced
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migrate_iask_id is not None:
            result['MigrateIaskId'] = self.migrate_iask_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.is_dbreplaced is not None:
            result['IsDBReplaced'] = self.is_dbreplaced
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MigrateIaskId') is not None:
            self.migrate_iask_id = m.get('MigrateIaskId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('IsDBReplaced') is not None:
            self.is_dbreplaced = m.get('IsDBReplaced')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class DescribeMigrateTasksForSQLServerResponseBodyItems(TeaModel):
    def __init__(
        self,
        migrate_task: List[DescribeMigrateTasksForSQLServerResponseBodyItemsMigrateTask] = None,
    ):
        self.migrate_task = migrate_task

    def validate(self):
        if self.migrate_task:
            for k in self.migrate_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MigrateTask'] = []
        if self.migrate_task is not None:
            for k in self.migrate_task:
                result['MigrateTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.migrate_task = []
        if m.get('MigrateTask') is not None:
            for k in m.get('MigrateTask'):
                temp_model = DescribeMigrateTasksForSQLServerResponseBodyItemsMigrateTask()
                self.migrate_task.append(temp_model.from_map(k))
        return self


class DescribeMigrateTasksForSQLServerResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        dbinstance_name: str = None,
        start_time: str = None,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        dbinstance_id: str = None,
        page_number: int = None,
        items: DescribeMigrateTasksForSQLServerResponseBodyItems = None,
    ):
        self.end_time = end_time
        self.dbinstance_name = dbinstance_name
        self.start_time = start_time
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.dbinstance_id = dbinstance_id
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.dbinstance_id is not None:
            result['DBInstanceID'] = self.dbinstance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('DBInstanceID') is not None:
            self.dbinstance_id = m.get('DBInstanceID')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = DescribeMigrateTasksForSQLServerResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeMigrateTasksForSQLServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMigrateTasksForSQLServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMigrateTasksForSQLServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModifyParameterLogRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        start_time: str = None,
        end_time: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.start_time = start_time
        self.end_time = end_time
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeModifyParameterLogResponseBodyItemsParameterChangeLog(TeaModel):
    def __init__(
        self,
        status: str = None,
        old_parameter_value: str = None,
        parameter_name: str = None,
        new_parameter_value: str = None,
        modify_time: str = None,
    ):
        self.status = status
        self.old_parameter_value = old_parameter_value
        self.parameter_name = parameter_name
        self.new_parameter_value = new_parameter_value
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.old_parameter_value is not None:
            result['OldParameterValue'] = self.old_parameter_value
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.new_parameter_value is not None:
            result['NewParameterValue'] = self.new_parameter_value
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('OldParameterValue') is not None:
            self.old_parameter_value = m.get('OldParameterValue')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('NewParameterValue') is not None:
            self.new_parameter_value = m.get('NewParameterValue')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class DescribeModifyParameterLogResponseBodyItems(TeaModel):
    def __init__(
        self,
        parameter_change_log: List[DescribeModifyParameterLogResponseBodyItemsParameterChangeLog] = None,
    ):
        self.parameter_change_log = parameter_change_log

    def validate(self):
        if self.parameter_change_log:
            for k in self.parameter_change_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParameterChangeLog'] = []
        if self.parameter_change_log is not None:
            for k in self.parameter_change_log:
                result['ParameterChangeLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameter_change_log = []
        if m.get('ParameterChangeLog') is not None:
            for k in m.get('ParameterChangeLog'):
                temp_model = DescribeModifyParameterLogResponseBodyItemsParameterChangeLog()
                self.parameter_change_log.append(temp_model.from_map(k))
        return self


class DescribeModifyParameterLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_record_count: int = None,
        total_record_count: int = None,
        dbinstance_id: str = None,
        engine: str = None,
        page_number: int = None,
        engine_version: str = None,
        items: DescribeModifyParameterLogResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_record_count = page_record_count
        self.total_record_count = total_record_count
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.page_number = page_number
        self.engine_version = engine_version
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_record_count is not None:
            result['PageRecordCount'] = self.page_record_count
        if self.total_record_count is not None:
            result['TotalRecordCount'] = self.total_record_count
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageRecordCount') is not None:
            self.page_record_count = m.get('PageRecordCount')
        if m.get('TotalRecordCount') is not None:
            self.total_record_count = m.get('TotalRecordCount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('Items') is not None:
            temp_model = DescribeModifyParameterLogResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeModifyParameterLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeModifyParameterLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeModifyParameterLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOssDownloadsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        migrate_task_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.migrate_task_id = migrate_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        return self


class DescribeOssDownloadsResponseBodyItemsOssDownload(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        status: str = None,
        description: str = None,
        create_time: str = None,
        backup_mode: str = None,
        is_available: str = None,
        file_name: str = None,
        file_size: str = None,
    ):
        self.end_time = end_time
        self.status = status
        self.description = description
        self.create_time = create_time
        self.backup_mode = backup_mode
        self.is_available = is_available
        self.file_name = file_name
        self.file_size = file_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.is_available is not None:
            result['IsAvailable'] = self.is_available
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('IsAvailable') is not None:
            self.is_available = m.get('IsAvailable')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class DescribeOssDownloadsResponseBodyItems(TeaModel):
    def __init__(
        self,
        oss_download: List[DescribeOssDownloadsResponseBodyItemsOssDownload] = None,
    ):
        self.oss_download = oss_download

    def validate(self):
        if self.oss_download:
            for k in self.oss_download:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OssDownload'] = []
        if self.oss_download is not None:
            for k in self.oss_download:
                result['OssDownload'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.oss_download = []
        if m.get('OssDownload') is not None:
            for k in m.get('OssDownload'):
                temp_model = DescribeOssDownloadsResponseBodyItemsOssDownload()
                self.oss_download.append(temp_model.from_map(k))
        return self


class DescribeOssDownloadsResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        migrate_task_id: str = None,
        items: DescribeOssDownloadsResponseBodyItems = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.migrate_task_id = migrate_task_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        if m.get('Items') is not None:
            temp_model = DescribeOssDownloadsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeOssDownloadsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeOssDownloadsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeOssDownloadsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOssDownloadsForSQLServerRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        migrate_task_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.migrate_task_id = migrate_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.migrate_task_id is not None:
            result['MigrateTaskId'] = self.migrate_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('MigrateTaskId') is not None:
            self.migrate_task_id = m.get('MigrateTaskId')
        return self


class DescribeOssDownloadsForSQLServerResponseBodyItemsOssDownload(TeaModel):
    def __init__(
        self,
        status: str = None,
        create_time: str = None,
        is_avail: str = None,
        file_name: str = None,
        bak_type: str = None,
        desc: str = None,
        file_size: str = None,
    ):
        self.status = status
        self.create_time = create_time
        self.is_avail = is_avail
        self.file_name = file_name
        self.bak_type = bak_type
        self.desc = desc
        self.file_size = file_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_avail is not None:
            result['IsAvail'] = self.is_avail
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.bak_type is not None:
            result['BakType'] = self.bak_type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsAvail') is not None:
            self.is_avail = m.get('IsAvail')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('BakType') is not None:
            self.bak_type = m.get('BakType')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        return self


class DescribeOssDownloadsForSQLServerResponseBodyItems(TeaModel):
    def __init__(
        self,
        oss_download: List[DescribeOssDownloadsForSQLServerResponseBodyItemsOssDownload] = None,
    ):
        self.oss_download = oss_download

    def validate(self):
        if self.oss_download:
            for k in self.oss_download:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OssDownload'] = []
        if self.oss_download is not None:
            for k in self.oss_download:
                result['OssDownload'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.oss_download = []
        if m.get('OssDownload') is not None:
            for k in m.get('OssDownload'):
                temp_model = DescribeOssDownloadsForSQLServerResponseBodyItemsOssDownload()
                self.oss_download.append(temp_model.from_map(k))
        return self


class DescribeOssDownloadsForSQLServerResponseBody(TeaModel):
    def __init__(
        self,
        migrate_iask_id: str = None,
        dbinstance_name: str = None,
        request_id: str = None,
        items: DescribeOssDownloadsForSQLServerResponseBodyItems = None,
    ):
        self.migrate_iask_id = migrate_iask_id
        self.dbinstance_name = dbinstance_name
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migrate_iask_id is not None:
            result['MigrateIaskId'] = self.migrate_iask_id
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MigrateIaskId') is not None:
            self.migrate_iask_id = m.get('MigrateIaskId')
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeOssDownloadsForSQLServerResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeOssDownloadsForSQLServerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeOssDownloadsForSQLServerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeOssDownloadsForSQLServerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParameterGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        parameter_group_id: str = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.parameter_group_id = parameter_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetailParameterDetail(TeaModel):
    def __init__(
        self,
        param_name: str = None,
        param_value: str = None,
    ):
        self.param_name = param_name
        self.param_value = param_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetail(TeaModel):
    def __init__(
        self,
        parameter_detail: List[DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetailParameterDetail] = None,
    ):
        self.parameter_detail = parameter_detail

    def validate(self):
        if self.parameter_detail:
            for k in self.parameter_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParameterDetail'] = []
        if self.parameter_detail is not None:
            for k in self.parameter_detail:
                result['ParameterDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameter_detail = []
        if m.get('ParameterDetail') is not None:
            for k in m.get('ParameterDetail'):
                temp_model = DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetailParameterDetail()
                self.parameter_detail.append(temp_model.from_map(k))
        return self


class DescribeParameterGroupResponseBodyParamGroupParameterGroup(TeaModel):
    def __init__(
        self,
        update_time: str = None,
        parameter_group_desc: str = None,
        create_time: str = None,
        force_restart: int = None,
        parameter_group_id: str = None,
        parameter_group_name: str = None,
        engine: str = None,
        param_counts: int = None,
        engine_version: str = None,
        parameter_group_type: int = None,
        param_detail: DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetail = None,
    ):
        self.update_time = update_time
        self.parameter_group_desc = parameter_group_desc
        self.create_time = create_time
        self.force_restart = force_restart
        self.parameter_group_id = parameter_group_id
        self.parameter_group_name = parameter_group_name
        self.engine = engine
        self.param_counts = param_counts
        self.engine_version = engine_version
        self.parameter_group_type = parameter_group_type
        self.param_detail = param_detail

    def validate(self):
        if self.param_detail:
            self.param_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.force_restart is not None:
            result['ForceRestart'] = self.force_restart
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.param_counts is not None:
            result['ParamCounts'] = self.param_counts
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.parameter_group_type is not None:
            result['ParameterGroupType'] = self.parameter_group_type
        if self.param_detail is not None:
            result['ParamDetail'] = self.param_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ForceRestart') is not None:
            self.force_restart = m.get('ForceRestart')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ParamCounts') is not None:
            self.param_counts = m.get('ParamCounts')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ParameterGroupType') is not None:
            self.parameter_group_type = m.get('ParameterGroupType')
        if m.get('ParamDetail') is not None:
            temp_model = DescribeParameterGroupResponseBodyParamGroupParameterGroupParamDetail()
            self.param_detail = temp_model.from_map(m['ParamDetail'])
        return self


class DescribeParameterGroupResponseBodyParamGroup(TeaModel):
    def __init__(
        self,
        parameter_group: List[DescribeParameterGroupResponseBodyParamGroupParameterGroup] = None,
    ):
        self.parameter_group = parameter_group

    def validate(self):
        if self.parameter_group:
            for k in self.parameter_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParameterGroup'] = []
        if self.parameter_group is not None:
            for k in self.parameter_group:
                result['ParameterGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameter_group = []
        if m.get('ParameterGroup') is not None:
            for k in m.get('ParameterGroup'):
                temp_model = DescribeParameterGroupResponseBodyParamGroupParameterGroup()
                self.parameter_group.append(temp_model.from_map(k))
        return self


class DescribeParameterGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        param_group: DescribeParameterGroupResponseBodyParamGroup = None,
    ):
        self.request_id = request_id
        self.param_group = param_group

    def validate(self):
        if self.param_group:
            self.param_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.param_group is not None:
            result['ParamGroup'] = self.param_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ParamGroup') is not None:
            temp_model = DescribeParameterGroupResponseBodyParamGroup()
            self.param_group = temp_model.from_map(m['ParamGroup'])
        return self


class DescribeParameterGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeParameterGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeParameterGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParameterGroupsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        region_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeParameterGroupsResponseBodyParameterGroupsParameterGroup(TeaModel):
    def __init__(
        self,
        update_time: str = None,
        parameter_group_desc: str = None,
        create_time: str = None,
        force_restart: int = None,
        parameter_group_id: str = None,
        parameter_group_name: str = None,
        engine: str = None,
        param_counts: int = None,
        engine_version: str = None,
        parameter_group_type: int = None,
    ):
        self.update_time = update_time
        self.parameter_group_desc = parameter_group_desc
        self.create_time = create_time
        self.force_restart = force_restart
        self.parameter_group_id = parameter_group_id
        self.parameter_group_name = parameter_group_name
        self.engine = engine
        self.param_counts = param_counts
        self.engine_version = engine_version
        self.parameter_group_type = parameter_group_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.parameter_group_desc is not None:
            result['ParameterGroupDesc'] = self.parameter_group_desc
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.force_restart is not None:
            result['ForceRestart'] = self.force_restart
        if self.parameter_group_id is not None:
            result['ParameterGroupId'] = self.parameter_group_id
        if self.parameter_group_name is not None:
            result['ParameterGroupName'] = self.parameter_group_name
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.param_counts is not None:
            result['ParamCounts'] = self.param_counts
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.parameter_group_type is not None:
            result['ParameterGroupType'] = self.parameter_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ParameterGroupDesc') is not None:
            self.parameter_group_desc = m.get('ParameterGroupDesc')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ForceRestart') is not None:
            self.force_restart = m.get('ForceRestart')
        if m.get('ParameterGroupId') is not None:
            self.parameter_group_id = m.get('ParameterGroupId')
        if m.get('ParameterGroupName') is not None:
            self.parameter_group_name = m.get('ParameterGroupName')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ParamCounts') is not None:
            self.param_counts = m.get('ParamCounts')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ParameterGroupType') is not None:
            self.parameter_group_type = m.get('ParameterGroupType')
        return self


class DescribeParameterGroupsResponseBodyParameterGroups(TeaModel):
    def __init__(
        self,
        parameter_group: List[DescribeParameterGroupsResponseBodyParameterGroupsParameterGroup] = None,
    ):
        self.parameter_group = parameter_group

    def validate(self):
        if self.parameter_group:
            for k in self.parameter_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParameterGroup'] = []
        if self.parameter_group is not None:
            for k in self.parameter_group:
                result['ParameterGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameter_group = []
        if m.get('ParameterGroup') is not None:
            for k in m.get('ParameterGroup'):
                temp_model = DescribeParameterGroupsResponseBodyParameterGroupsParameterGroup()
                self.parameter_group.append(temp_model.from_map(k))
        return self


class DescribeParameterGroupsResponseBody(TeaModel):
    def __init__(
        self,
        signal_for_optimize_params: bool = None,
        request_id: str = None,
        parameter_groups: DescribeParameterGroupsResponseBodyParameterGroups = None,
    ):
        self.signal_for_optimize_params = signal_for_optimize_params
        self.request_id = request_id
        self.parameter_groups = parameter_groups

    def validate(self):
        if self.parameter_groups:
            self.parameter_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.signal_for_optimize_params is not None:
            result['SignalForOptimizeParams'] = self.signal_for_optimize_params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.parameter_groups is not None:
            result['ParameterGroups'] = self.parameter_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SignalForOptimizeParams') is not None:
            self.signal_for_optimize_params = m.get('SignalForOptimizeParams')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ParameterGroups') is not None:
            temp_model = DescribeParameterGroupsResponseBodyParameterGroups()
            self.parameter_groups = temp_model.from_map(m['ParameterGroups'])
        return self


class DescribeParameterGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeParameterGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeParameterGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParametersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeParametersResponseBodyConfigParametersDBInstanceParameter(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_value = parameter_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        return self


class DescribeParametersResponseBodyConfigParameters(TeaModel):
    def __init__(
        self,
        dbinstance_parameter: List[DescribeParametersResponseBodyConfigParametersDBInstanceParameter] = None,
    ):
        self.dbinstance_parameter = dbinstance_parameter

    def validate(self):
        if self.dbinstance_parameter:
            for k in self.dbinstance_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceParameter'] = []
        if self.dbinstance_parameter is not None:
            for k in self.dbinstance_parameter:
                result['DBInstanceParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_parameter = []
        if m.get('DBInstanceParameter') is not None:
            for k in m.get('DBInstanceParameter'):
                temp_model = DescribeParametersResponseBodyConfigParametersDBInstanceParameter()
                self.dbinstance_parameter.append(temp_model.from_map(k))
        return self


class DescribeParametersResponseBodyRunningParametersDBInstanceParameter(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        parameter_name: str = None,
        parameter_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.parameter_value = parameter_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        return self


class DescribeParametersResponseBodyRunningParameters(TeaModel):
    def __init__(
        self,
        dbinstance_parameter: List[DescribeParametersResponseBodyRunningParametersDBInstanceParameter] = None,
    ):
        self.dbinstance_parameter = dbinstance_parameter

    def validate(self):
        if self.dbinstance_parameter:
            for k in self.dbinstance_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstanceParameter'] = []
        if self.dbinstance_parameter is not None:
            for k in self.dbinstance_parameter:
                result['DBInstanceParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dbinstance_parameter = []
        if m.get('DBInstanceParameter') is not None:
            for k in m.get('DBInstanceParameter'):
                temp_model = DescribeParametersResponseBodyRunningParametersDBInstanceParameter()
                self.dbinstance_parameter.append(temp_model.from_map(k))
        return self


class DescribeParametersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        engine: str = None,
        engine_version: str = None,
        config_parameters: DescribeParametersResponseBodyConfigParameters = None,
        running_parameters: DescribeParametersResponseBodyRunningParameters = None,
    ):
        self.request_id = request_id
        self.engine = engine
        self.engine_version = engine_version
        self.config_parameters = config_parameters
        self.running_parameters = running_parameters

    def validate(self):
        if self.config_parameters:
            self.config_parameters.validate()
        if self.running_parameters:
            self.running_parameters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.config_parameters is not None:
            result['ConfigParameters'] = self.config_parameters.to_map()
        if self.running_parameters is not None:
            result['RunningParameters'] = self.running_parameters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ConfigParameters') is not None:
            temp_model = DescribeParametersResponseBodyConfigParameters()
            self.config_parameters = temp_model.from_map(m['ConfigParameters'])
        if m.get('RunningParameters') is not None:
            temp_model = DescribeParametersResponseBodyRunningParameters()
            self.running_parameters = temp_model.from_map(m['RunningParameters'])
        return self


class DescribeParametersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeParametersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeParametersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParameterTemplatesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        engine: str = None,
        engine_version: str = None,
        owner_account: str = None,
        category: str = None,
        region_id: str = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.engine = engine
        self.engine_version = engine_version
        self.owner_account = owner_account
        self.category = category
        self.region_id = region_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.category is not None:
            result['Category'] = self.category
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeParameterTemplatesResponseBodyParametersTemplateRecord(TeaModel):
    def __init__(
        self,
        checking_code: str = None,
        parameter_name: str = None,
        parameter_value: str = None,
        force_modify: str = None,
        force_restart: str = None,
        parameter_description: str = None,
    ):
        self.checking_code = checking_code
        self.parameter_name = parameter_name
        self.parameter_value = parameter_value
        self.force_modify = force_modify
        self.force_restart = force_restart
        self.parameter_description = parameter_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checking_code is not None:
            result['CheckingCode'] = self.checking_code
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        if self.force_modify is not None:
            result['ForceModify'] = self.force_modify
        if self.force_restart is not None:
            result['ForceRestart'] = self.force_restart
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckingCode') is not None:
            self.checking_code = m.get('CheckingCode')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        if m.get('ForceModify') is not None:
            self.force_modify = m.get('ForceModify')
        if m.get('ForceRestart') is not None:
            self.force_restart = m.get('ForceRestart')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        return self


class DescribeParameterTemplatesResponseBodyParameters(TeaModel):
    def __init__(
        self,
        template_record: List[DescribeParameterTemplatesResponseBodyParametersTemplateRecord] = None,
    ):
        self.template_record = template_record

    def validate(self):
        if self.template_record:
            for k in self.template_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TemplateRecord'] = []
        if self.template_record is not None:
            for k in self.template_record:
                result['TemplateRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template_record = []
        if m.get('TemplateRecord') is not None:
            for k in m.get('TemplateRecord'):
                temp_model = DescribeParameterTemplatesResponseBodyParametersTemplateRecord()
                self.template_record.append(temp_model.from_map(k))
        return self


class DescribeParameterTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        engine: str = None,
        parameter_count: str = None,
        engine_version: str = None,
        parameters: DescribeParameterTemplatesResponseBodyParameters = None,
    ):
        self.request_id = request_id
        self.engine = engine
        self.parameter_count = parameter_count
        self.engine_version = engine_version
        self.parameters = parameters

    def validate(self):
        if self.parameters:
            self.parameters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.parameter_count is not None:
            result['ParameterCount'] = self.parameter_count
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.parameters is not None:
            result['Parameters'] = self.parameters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('ParameterCount') is not None:
            self.parameter_count = m.get('ParameterCount')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('Parameters') is not None:
            temp_model = DescribeParameterTemplatesResponseBodyParameters()
            self.parameters = temp_model.from_map(m['Parameters'])
        return self


class DescribeParameterTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeParameterTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeParameterTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePriceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        commodity_code: str = None,
        region_id: str = None,
        engine: str = None,
        engine_version: str = None,
        dbinstance_class: str = None,
        dbinstance_storage: int = None,
        pay_type: str = None,
        zone_id: str = None,
        used_time: int = None,
        time_type: str = None,
        quantity: int = None,
        instance_used_type: int = None,
        order_type: str = None,
        dbinstance_storage_type: str = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.commodity_code = commodity_code
        self.region_id = region_id
        self.engine = engine
        self.engine_version = engine_version
        self.dbinstance_class = dbinstance_class
        self.dbinstance_storage = dbinstance_storage
        self.pay_type = pay_type
        self.zone_id = zone_id
        self.used_time = used_time
        self.time_type = time_type
        self.quantity = quantity
        self.instance_used_type = instance_used_type
        self.order_type = order_type
        self.dbinstance_storage_type = dbinstance_storage_type
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.time_type is not None:
            result['TimeType'] = self.time_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.instance_used_type is not None:
            result['InstanceUsedType'] = self.instance_used_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.dbinstance_storage_type is not None:
            result['DBInstanceStorageType'] = self.dbinstance_storage_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('TimeType') is not None:
            self.time_type = m.get('TimeType')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('InstanceUsedType') is not None:
            self.instance_used_type = m.get('InstanceUsedType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('DBInstanceStorageType') is not None:
            self.dbinstance_storage_type = m.get('DBInstanceStorageType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribePriceResponseBodyPriceInfoCouponsCoupon(TeaModel):
    def __init__(
        self,
        is_selected: str = None,
        coupon_no: str = None,
        name: str = None,
        description: str = None,
    ):
        self.is_selected = is_selected
        self.coupon_no = coupon_no
        self.name = name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_selected is not None:
            result['IsSelected'] = self.is_selected
        if self.coupon_no is not None:
            result['CouponNo'] = self.coupon_no
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsSelected') is not None:
            self.is_selected = m.get('IsSelected')
        if m.get('CouponNo') is not None:
            self.coupon_no = m.get('CouponNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribePriceResponseBodyPriceInfoCoupons(TeaModel):
    def __init__(
        self,
        coupon: List[DescribePriceResponseBodyPriceInfoCouponsCoupon] = None,
    ):
        self.coupon = coupon

    def validate(self):
        if self.coupon:
            for k in self.coupon:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Coupon'] = []
        if self.coupon is not None:
            for k in self.coupon:
                result['Coupon'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.coupon = []
        if m.get('Coupon') is not None:
            for k in m.get('Coupon'):
                temp_model = DescribePriceResponseBodyPriceInfoCouponsCoupon()
                self.coupon.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfoRuleIds(TeaModel):
    def __init__(
        self,
        rule_id: List[str] = None,
    ):
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribePriceResponseBodyPriceInfoActivityInfo(TeaModel):
    def __init__(
        self,
        check_err_msg: str = None,
        error_code: str = None,
        success: str = None,
    ):
        self.check_err_msg = check_err_msg
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_err_msg is not None:
            result['CheckErrMsg'] = self.check_err_msg
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckErrMsg') is not None:
            self.check_err_msg = m.get('CheckErrMsg')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribePriceResponseBodyPriceInfo(TeaModel):
    def __init__(
        self,
        original_price: float = None,
        discount_price: float = None,
        currency: str = None,
        trade_price: float = None,
        coupons: DescribePriceResponseBodyPriceInfoCoupons = None,
        rule_ids: DescribePriceResponseBodyPriceInfoRuleIds = None,
        activity_info: DescribePriceResponseBodyPriceInfoActivityInfo = None,
    ):
        self.original_price = original_price
        self.discount_price = discount_price
        self.currency = currency
        self.trade_price = trade_price
        self.coupons = coupons
        self.rule_ids = rule_ids
        self.activity_info = activity_info

    def validate(self):
        if self.coupons:
            self.coupons.validate()
        if self.rule_ids:
            self.rule_ids.validate()
        if self.activity_info:
            self.activity_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        if self.coupons is not None:
            result['Coupons'] = self.coupons.to_map()
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids.to_map()
        if self.activity_info is not None:
            result['ActivityInfo'] = self.activity_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        if m.get('Coupons') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoCoupons()
            self.coupons = temp_model.from_map(m['Coupons'])
        if m.get('RuleIds') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoRuleIds()
            self.rule_ids = temp_model.from_map(m['RuleIds'])
        if m.get('ActivityInfo') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoActivityInfo()
            self.activity_info = temp_model.from_map(m['ActivityInfo'])
        return self


class DescribePriceResponseBodyRulesRule(TeaModel):
    def __init__(
        self,
        name: str = None,
        description: str = None,
        rule_id: int = None,
    ):
        self.name = name
        self.description = description
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribePriceResponseBodyRules(TeaModel):
    def __init__(
        self,
        rule: List[DescribePriceResponseBodyRulesRule] = None,
    ):
        self.rule = rule

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribePriceResponseBodyRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        price_info: DescribePriceResponseBodyPriceInfo = None,
        rules: DescribePriceResponseBodyRules = None,
    ):
        self.request_id = request_id
        self.price_info = price_info
        self.rules = rules

    def validate(self):
        if self.price_info:
            self.price_info.validate()
        if self.rules:
            self.rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PriceInfo') is not None:
            temp_model = DescribePriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('Rules') is not None:
            temp_model = DescribePriceResponseBodyRules()
            self.rules = temp_model.from_map(m['Rules'])
        return self


class DescribePriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePriceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsResourceSettingsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        resource_niche: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.resource_niche = resource_niche

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_niche is not None:
            result['ResourceNiche'] = self.resource_niche
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceNiche') is not None:
            self.resource_niche = m.get('ResourceNiche')
        return self


class DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettingsRdsInstanceResourceSetting(TeaModel):
    def __init__(
        self,
        popped_up_button_type: str = None,
        notice_bar_content: str = None,
        end_date: str = None,
        popped_up_content: str = None,
        start_date: str = None,
        popped_up_button_text: str = None,
        is_top: str = None,
        resource_niche: str = None,
        popped_up_button_url: str = None,
    ):
        self.popped_up_button_type = popped_up_button_type
        self.notice_bar_content = notice_bar_content
        self.end_date = end_date
        self.popped_up_content = popped_up_content
        self.start_date = start_date
        self.popped_up_button_text = popped_up_button_text
        self.is_top = is_top
        self.resource_niche = resource_niche
        self.popped_up_button_url = popped_up_button_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.popped_up_button_type is not None:
            result['PoppedUpButtonType'] = self.popped_up_button_type
        if self.notice_bar_content is not None:
            result['NoticeBarContent'] = self.notice_bar_content
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.popped_up_content is not None:
            result['PoppedUpContent'] = self.popped_up_content
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.popped_up_button_text is not None:
            result['PoppedUpButtonText'] = self.popped_up_button_text
        if self.is_top is not None:
            result['IsTop'] = self.is_top
        if self.resource_niche is not None:
            result['ResourceNiche'] = self.resource_niche
        if self.popped_up_button_url is not None:
            result['PoppedUpButtonUrl'] = self.popped_up_button_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PoppedUpButtonType') is not None:
            self.popped_up_button_type = m.get('PoppedUpButtonType')
        if m.get('NoticeBarContent') is not None:
            self.notice_bar_content = m.get('NoticeBarContent')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PoppedUpContent') is not None:
            self.popped_up_content = m.get('PoppedUpContent')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('PoppedUpButtonText') is not None:
            self.popped_up_button_text = m.get('PoppedUpButtonText')
        if m.get('IsTop') is not None:
            self.is_top = m.get('IsTop')
        if m.get('ResourceNiche') is not None:
            self.resource_niche = m.get('ResourceNiche')
        if m.get('PoppedUpButtonUrl') is not None:
            self.popped_up_button_url = m.get('PoppedUpButtonUrl')
        return self


class DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettings(TeaModel):
    def __init__(
        self,
        rds_instance_resource_setting: List[DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettingsRdsInstanceResourceSetting] = None,
    ):
        self.rds_instance_resource_setting = rds_instance_resource_setting

    def validate(self):
        if self.rds_instance_resource_setting:
            for k in self.rds_instance_resource_setting:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsInstanceResourceSetting'] = []
        if self.rds_instance_resource_setting is not None:
            for k in self.rds_instance_resource_setting:
                result['RdsInstanceResourceSetting'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rds_instance_resource_setting = []
        if m.get('RdsInstanceResourceSetting') is not None:
            for k in m.get('RdsInstanceResourceSetting'):
                temp_model = DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettingsRdsInstanceResourceSetting()
                self.rds_instance_resource_setting.append(temp_model.from_map(k))
        return self


class DescribeRdsResourceSettingsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rds_instance_resource_settings: DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettings = None,
    ):
        self.request_id = request_id
        self.rds_instance_resource_settings = rds_instance_resource_settings

    def validate(self):
        if self.rds_instance_resource_settings:
            self.rds_instance_resource_settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rds_instance_resource_settings is not None:
            result['RdsInstanceResourceSettings'] = self.rds_instance_resource_settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RdsInstanceResourceSettings') is not None:
            temp_model = DescribeRdsResourceSettingsResponseBodyRdsInstanceResourceSettings()
            self.rds_instance_resource_settings = temp_model.from_map(m['RdsInstanceResourceSettings'])
        return self


class DescribeRdsResourceSettingsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRdsResourceSettingsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsResourceSettingsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReadDBInstanceDelayRequest(TeaModel):
    def __init__(
        self,
        security_token: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        read_instance_id: str = None,
    ):
        self.security_token = security_token
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.read_instance_id = read_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.read_instance_id is not None:
            result['ReadInstanceId'] = self.read_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ReadInstanceId') is not None:
            self.read_instance_id = m.get('ReadInstanceId')
        return self


class DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelayReadonlyInstanceDelay(TeaModel):
    def __init__(
        self,
        write_latency: str = None,
        flush_latency: str = None,
        read_dbinstance_name: str = None,
        write_lag: str = None,
        flush_lag: str = None,
        send_latency: str = None,
        replay_lag: str = None,
        replay_latency: str = None,
    ):
        self.write_latency = write_latency
        self.flush_latency = flush_latency
        self.read_dbinstance_name = read_dbinstance_name
        self.write_lag = write_lag
        self.flush_lag = flush_lag
        self.send_latency = send_latency
        self.replay_lag = replay_lag
        self.replay_latency = replay_latency

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.write_latency is not None:
            result['WriteLatency'] = self.write_latency
        if self.flush_latency is not None:
            result['FlushLatency'] = self.flush_latency
        if self.read_dbinstance_name is not None:
            result['ReadDBInstanceName'] = self.read_dbinstance_name
        if self.write_lag is not None:
            result['WriteLag'] = self.write_lag
        if self.flush_lag is not None:
            result['FlushLag'] = self.flush_lag
        if self.send_latency is not None:
            result['SendLatency'] = self.send_latency
        if self.replay_lag is not None:
            result['ReplayLag'] = self.replay_lag
        if self.replay_latency is not None:
            result['ReplayLatency'] = self.replay_latency
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WriteLatency') is not None:
            self.write_latency = m.get('WriteLatency')
        if m.get('FlushLatency') is not None:
            self.flush_latency = m.get('FlushLatency')
        if m.get('ReadDBInstanceName') is not None:
            self.read_dbinstance_name = m.get('ReadDBInstanceName')
        if m.get('WriteLag') is not None:
            self.write_lag = m.get('WriteLag')
        if m.get('FlushLag') is not None:
            self.flush_lag = m.get('FlushLag')
        if m.get('SendLatency') is not None:
            self.send_latency = m.get('SendLatency')
        if m.get('ReplayLag') is not None:
            self.replay_lag = m.get('ReplayLag')
        if m.get('ReplayLatency') is not None:
            self.replay_latency = m.get('ReplayLatency')
        return self


class DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelay(TeaModel):
    def __init__(
        self,
        readonly_instance_delay: List[DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelayReadonlyInstanceDelay] = None,
    ):
        self.readonly_instance_delay = readonly_instance_delay

    def validate(self):
        if self.readonly_instance_delay:
            for k in self.readonly_instance_delay:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadonlyInstanceDelay'] = []
        if self.readonly_instance_delay is not None:
            for k in self.readonly_instance_delay:
                result['ReadonlyInstanceDelay'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.readonly_instance_delay = []
        if m.get('ReadonlyInstanceDelay') is not None:
            for k in m.get('ReadonlyInstanceDelay'):
                temp_model = DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelayReadonlyInstanceDelay()
                self.readonly_instance_delay.append(temp_model.from_map(k))
        return self


class DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDelayTimes(TeaModel):
    def __init__(
        self,
        read_delay_time: List[str] = None,
    ):
        self.read_delay_time = read_delay_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_delay_time is not None:
            result['ReadDelayTime'] = self.read_delay_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReadDelayTime') is not None:
            self.read_delay_time = m.get('ReadDelayTime')
        return self


class DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDBInstanceNames(TeaModel):
    def __init__(
        self,
        read_dbinstance_name: List[str] = None,
    ):
        self.read_dbinstance_name = read_dbinstance_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_dbinstance_name is not None:
            result['ReadDBInstanceName'] = self.read_dbinstance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReadDBInstanceName') is not None:
            self.read_dbinstance_name = m.get('ReadDBInstanceName')
        return self


class DescribeReadDBInstanceDelayResponseBodyItemsItems(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        readonly_instance_delay: DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelay = None,
        read_delay_times: DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDelayTimes = None,
        read_dbinstance_names: DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDBInstanceNames = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.readonly_instance_delay = readonly_instance_delay
        self.read_delay_times = read_delay_times
        self.read_dbinstance_names = read_dbinstance_names

    def validate(self):
        if self.readonly_instance_delay:
            self.readonly_instance_delay.validate()
        if self.read_delay_times:
            self.read_delay_times.validate()
        if self.read_dbinstance_names:
            self.read_dbinstance_names.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.readonly_instance_delay is not None:
            result['ReadonlyInstanceDelay'] = self.readonly_instance_delay.to_map()
        if self.read_delay_times is not None:
            result['ReadDelayTimes'] = self.read_delay_times.to_map()
        if self.read_dbinstance_names is not None:
            result['ReadDBInstanceNames'] = self.read_dbinstance_names.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('ReadonlyInstanceDelay') is not None:
            temp_model = DescribeReadDBInstanceDelayResponseBodyItemsItemsReadonlyInstanceDelay()
            self.readonly_instance_delay = temp_model.from_map(m['ReadonlyInstanceDelay'])
        if m.get('ReadDelayTimes') is not None:
            temp_model = DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDelayTimes()
            self.read_delay_times = temp_model.from_map(m['ReadDelayTimes'])
        if m.get('ReadDBInstanceNames') is not None:
            temp_model = DescribeReadDBInstanceDelayResponseBodyItemsItemsReadDBInstanceNames()
            self.read_dbinstance_names = temp_model.from_map(m['ReadDBInstanceNames'])
        return self


class DescribeReadDBInstanceDelayResponseBodyItems(TeaModel):
    def __init__(
        self,
        items: List[DescribeReadDBInstanceDelayResponseBodyItemsItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeReadDBInstanceDelayResponseBodyItemsItems()
                self.items.append(temp_model.from_map(k))
        return self


class DescribeReadDBInstanceDelayResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        request_id: str = None,
        delay_time: int = None,
        read_dbinstance_id: str = None,
        items: DescribeReadDBInstanceDelayResponseBodyItems = None,
    ):
        self.dbinstance_id = dbinstance_id
        self.request_id = request_id
        self.delay_time = delay_time
        self.read_dbinstance_id = read_dbinstance_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.delay_time is not None:
            result['DelayTime'] = self.delay_time
        if self.read_dbinstance_id is not None:
            result['ReadDBInstanceId'] = self.read_dbinstance_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DelayTime') is not None:
            self.delay_time = m.get('DelayTime')
        if m.get('ReadDBInstanceId') is not None:
            self.read_dbinstance_id = m.get('ReadDBInstanceId')
        if m.get('Items') is not None:
            temp_model = DescribeReadDBInstanceDelayResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeReadDBInstanceDelayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeReadDBInstanceDelayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeReadDBInstanceDelayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionInfosRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        region_id: str = None,
        instance_used_type: str = None,
        specify_count: str = None,
        host_type: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.region_id = region_id
        self.instance_used_type = instance_used_type
        self.specify_count = specify_count
        self.host_type = host_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_used_type is not None:
            result['InstanceUsedType'] = self.instance_used_type
        if self.specify_count is not None:
            result['SpecifyCount'] = self.specify_count
        if self.host_type is not None:
            result['HostType'] = self.host_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('InstanceUsedType') is not None:
            self.instance_used_type = m.get('InstanceUsedType')
        if m.get('SpecifyCount') is not None:
            self.specify_count = m.get('SpecifyCount')
        if m.get('HostType') is not None:
            self.host_type = m.get('HostType')
        return self


class DescribeRegionInfosResponseBodyRegionsRDSRegion(TeaModel):
    def __init__(
        self,
        cn_local_name: str = None,
        region_name: str = None,
        avz: str = None,
        avz_status: str = None,
        region_endpoint: str = None,
        category: str = None,
        en_local_name: str = None,
        region_id: str = None,
    ):
        self.cn_local_name = cn_local_name
        self.region_name = region_name
        self.avz = avz
        self.avz_status = avz_status
        self.region_endpoint = region_endpoint
        self.category = category
        self.en_local_name = en_local_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cn_local_name is not None:
            result['CnLocalName'] = self.cn_local_name
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.avz is not None:
            result['Avz'] = self.avz
        if self.avz_status is not None:
            result['AvzStatus'] = self.avz_status
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.category is not None:
            result['Category'] = self.category
        if self.en_local_name is not None:
            result['EnLocalName'] = self.en_local_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CnLocalName') is not None:
            self.cn_local_name = m.get('CnLocalName')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Avz') is not None:
            self.avz = m.get('Avz')
        if m.get('AvzStatus') is not None:
            self.avz_status = m.get('AvzStatus')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('EnLocalName') is not None:
            self.en_local_name = m.get('EnLocalName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionInfosResponseBodyRegions(TeaModel):
    def __init__(
        self,
        rdsregion: List[DescribeRegionInfosResponseBodyRegionsRDSRegion] = None,
    ):
        self.rdsregion = rdsregion

    def validate(self):
        if self.rdsregion:
            for k in self.rdsregion:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RDSRegion'] = []
        if self.rdsregion is not None:
            for k in self.rdsregion:
                result['RDSRegion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rdsregion = []
        if m.get('RDSRegion') is not None:
            for k in m.get('RDSRegion'):
                temp_model = DescribeRegionInfosResponseBodyRegionsRDSRegion()
                self.rdsregion.append(temp_model.from_map(k))
        return self


class DescribeRegionInfosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        regions: DescribeRegionInfosResponseBodyRegions = None,
    ):
        self.request_id = request_id
        self.regions = regions

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Regions') is not None:
            temp_model = DescribeRegionInfosResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        return self


class DescribeRegionInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRegionInfosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        accept_language: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.accept_language = accept_language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        return self


class DescribeRegionsResponseBodyRegionsRDSRegion(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
        region_endpoint: str = None,
        local_name: str = None,
        region_id: str = None,
    ):
        self.zone_id = zone_id
        self.region_endpoint = region_endpoint
        self.local_name = local_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        rdsregion: List[DescribeRegionsResponseBodyRegionsRDSRegion] = None,
    ):
        self.rdsregion = rdsregion

    def validate(self):
        if self.rdsregion:
            for k in self.rdsregion:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RDSRegion'] = []
        if self.rdsregion is not None:
            for k in self.rdsregion:
                result['RDSRegion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rdsregion = []
        if m.get('RDSRegion') is not None:
            for k in m.get('RDSRegion'):
                temp_model = DescribeRegionsResponseBodyRegionsRDSRegion()
                self.rdsregion.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        regions: DescribeRegionsResponseBodyRegions = None,
    ):
        self.request_id = request_id
        self.regions = regions

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Regions') is not None:
            temp_model = DescribeRegionsResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRenewalPriceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        client_token: str = None,
        owner_account: str = None,
        dbinstance_id: str = None,
        region_id: str = None,
        pay_type: str = None,
        dbinstance_class: str = None,
        used_time: int = None,
        time_type: str = None,
        quantity: int = None,
        order_type: str = None,
        business_info: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.client_token = client_token
        self.owner_account = owner_account
        self.dbinstance_id = dbinstance_id
        self.region_id = region_id
        self.pay_type = pay_type
        self.dbinstance_class = dbinstance_class
        self.used_time = used_time
        self.time_type = time_type
        self.quantity = quantity
        self.order_type = order_type
        self.business_info = business_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.dbinstance_class is not None:
            result['DBInstanceClass'] = self.dbinstance_class
        if self.used_time is not None:
            result['UsedTime'] = self.used_time
        if self.time_type is not None:
            result['TimeType'] = self.time_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DBInstanceClass') is not None:
            self.dbinstance_class = m.get('DBInstanceClass')
        if m.get('UsedTime') is not None:
            self.used_time = m.get('UsedTime')
        if m.get('TimeType') is not None:
            self.time_type = m.get('TimeType')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        return self


class DescribeRenewalPriceResponseBodyPriceInfoCouponsCoupon(TeaModel):
    def __init__(
        self,
        is_selected: str = None,
        coupon_no: str = None,
        name: str = None,
        description: str = None,
    ):
        self.is_selected = is_selected
        self.coupon_no = coupon_no
        self.name = name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_selected is not None:
            result['IsSelected'] = self.is_selected
        if self.coupon_no is not None:
            result['CouponNo'] = self.coupon_no
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsSelected') is not None:
            self.is_selected = m.get('IsSelected')
        if m.get('CouponNo') is not None:
            self.coupon_no = m.get('CouponNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeRenewalPriceResponseBodyPriceInfoCoupons(TeaModel):
    def __init__(
        self,
        coupon: List[DescribeRenewalPriceResponseBodyPriceInfoCouponsCoupon] = None,
    ):
        self.coupon = coupon

    def validate(self):
        if self.coupon:
            for k in self.coupon:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Coupon'] = []
        if self.coupon is not None:
            for k in self.coupon:
                result['Coupon'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.coupon = []
        if m.get('Coupon') is not None:
            for k in m.get('Coupon'):
                temp_model = DescribeRenewalPriceResponseBodyPriceInfoCouponsCoupon()
                self.coupon.append(temp_model.from_map(k))
        return self


class DescribeRenewalPriceResponseBodyPriceInfoRuleIds(TeaModel):
    def __init__(
        self,
        rule_id: List[str] = None,
    ):
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeRenewalPriceResponseBodyPriceInfoActivityInfo(TeaModel):
    def __init__(
        self,
        check_err_msg: str = None,
        error_code: str = None,
        success: str = None,
    ):
        self.check_err_msg = check_err_msg
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_err_msg is not None:
            result['CheckErrMsg'] = self.check_err_msg
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckErrMsg') is not None:
            self.check_err_msg = m.get('CheckErrMsg')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRenewalPriceResponseBodyPriceInfo(TeaModel):
    def __init__(
        self,
        original_price: float = None,
        discount_price: float = None,
        currency: str = None,
        trade_price: float = None,
        coupons: DescribeRenewalPriceResponseBodyPriceInfoCoupons = None,
        rule_ids: DescribeRenewalPriceResponseBodyPriceInfoRuleIds = None,
        activity_info: DescribeRenewalPriceResponseBodyPriceInfoActivityInfo = None,
    ):
        self.original_price = original_price
        self.discount_price = discount_price
        self.currency = currency
        self.trade_price = trade_price
        self.coupons = coupons
        self.rule_ids = rule_ids
        self.activity_info = activity_info

    def validate(self):
        if self.coupons:
            self.coupons.validate()
        if self.rule_ids:
            self.rule_ids.validate()
        if self.activity_info:
            self.activity_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        if self.coupons is not None:
            result['Coupons'] = self.coupons.to_map()
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids.to_map()
        if self.activity_info is not None:
            result['ActivityInfo'] = self.activity_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        if m.get('Coupons') is not None:
            temp_model = DescribeRenewalPriceResponseBodyPriceInfoCoupons()
            self.coupons = temp_model.from_map(m['Coupons'])
        if m.get('RuleIds') is not None:
            temp_model = DescribeRenewalPriceResponseBodyPriceInfoRuleIds()
            self.rule_ids = temp_model.from_map(m['RuleIds'])
        if m.get('ActivityInfo') is not None:
            temp_model = DescribeRenewalPriceResponseBodyPriceInfoActivityInfo()
            self.activity_info = temp_model.from_map(m['ActivityInfo'])
        return self


class DescribeRenewalPriceResponseBodyRulesRule(TeaModel):
    def __init__(
        self,
        name: str = None,
        description: str = None,
        rule_id: int = None,
    ):
        self.name = name
        self.description = description
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeRenewalPriceResponseBodyRules(TeaModel):
    def __init__(
        self,
        rule: List[DescribeRenewalPriceResponseBodyRulesRule] = None,
    ):
        self.rule = rule

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribeRenewalPriceResponseBodyRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribeRenewalPriceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        price_info: DescribeRenewalPriceResponseBodyPriceInfo = None,
        rules: DescribeRenewalPriceResponseBodyRules = None,
    ):
        self.request_id = request_id
        self.price_info = price_info
        self.rules = rules

    def validate(self):
        if self.price_info:
            self.price_info.validate()
        if self.rules:
            self.rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PriceInfo') is not None:
            temp_model = DescribeRenewalPriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('Rules') is not None:
            temp_model = DescribeRenewalPriceResponseBodyRules()
            self.rules = temp_model.from_map(m['Rules'])
        return self


class DescribeRenewalPriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRenewalPriceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRenewalPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceUsageRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeResourceUsageResponseBody(TeaModel):
    def __init__(
        self,
        backup_oss_data_size: int = None,
        disk_used: int = None,
        archive_backup_size: int = None,
        backup_oss_log_size: int = None,
        backup_log_size: int = None,
        backup_data_size: int = None,
        cold_backup_size: int = None,
        data_size: int = None,
        paid_backup_size: int = None,
        request_id: str = None,
        log_size: int = None,
        backup_size: int = None,
        dbinstance_id: str = None,
        engine: str = None,
        sqlsize: int = None,
    ):
        self.backup_oss_data_size = backup_oss_data_size
        self.disk_used = disk_used
        self.archive_backup_size = archive_backup_size
        self.backup_oss_log_size = backup_oss_log_size
        self.backup_log_size = backup_log_size
        self.backup_data_size = backup_data_size
        self.cold_backup_size = cold_backup_size
        self.data_size = data_size
        self.paid_backup_size = paid_backup_size
        self.request_id = request_id
        self.log_size = log_size
        self.backup_size = backup_size
        self.dbinstance_id = dbinstance_id
        self.engine = engine
        self.sqlsize = sqlsize

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_oss_data_size is not None:
            result['BackupOssDataSize'] = self.backup_oss_data_size
        if self.disk_used is not None:
            result['DiskUsed'] = self.disk_used
        if self.archive_backup_size is not None:
            result['ArchiveBackupSize'] = self.archive_backup_size
        if self.backup_oss_log_size is not None:
            result['BackupOssLogSize'] = self.backup_oss_log_size
        if self.backup_log_size is not None:
            result['BackupLogSize'] = self.backup_log_size
        if self.backup_data_size is not None:
            result['BackupDataSize'] = self.backup_data_size
        if self.cold_backup_size is not None:
            result['ColdBackupSize'] = self.cold_backup_size
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.paid_backup_size is not None:
            result['PaidBackupSize'] = self.paid_backup_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.backup_size is not None:
            result['BackupSize'] = self.backup_size
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.sqlsize is not None:
            result['SQLSize'] = self.sqlsize
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupOssDataSize') is not None:
            self.backup_oss_data_size = m.get('BackupOssDataSize')
        if m.get('DiskUsed') is not None:
            self.disk_used = m.get('DiskUsed')
        if m.get('ArchiveBackupSize') is not None:
            self.archive_backup_size = m.get('ArchiveBackupSize')
        if m.get('BackupOssLogSize') is not None:
            self.backup_oss_log_size = m.get('BackupOssLogSize')
        if m.get('BackupLogSize') is not None:
            self.backup_log_size = m.get('BackupLogSize')
        if m.get('BackupDataSize') is not None:
            self.backup_data_size = m.get('BackupDataSize')
        if m.get('ColdBackupSize') is not None:
            self.cold_backup_size = m.get('ColdBackupSize')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('PaidBackupSize') is not None:
            self.paid_backup_size = m.get('PaidBackupSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('BackupSize') is not None:
            self.backup_size = m.get('BackupSize')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('SQLSize') is not None:
            self.sqlsize = m.get('SQLSize')
        return self


class DescribeResourceUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeResourceUsageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeResourceUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityGroupConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        return self


class DescribeSecurityGroupConfigurationResponseBodyItemsEcsSecurityGroupRelation(TeaModel):
    def __init__(
        self,
        network_type: str = None,
        security_group_id: str = None,
        region_id: str = None,
    ):
        self.network_type = network_type
        self.security_group_id = security_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSecurityGroupConfigurationResponseBodyItems(TeaModel):
    def __init__(
        self,
        ecs_security_group_relation: List[DescribeSecurityGroupConfigurationResponseBodyItemsEcsSecurityGroupRelation] = None,
    ):
        self.ecs_security_group_relation = ecs_security_group_relation

    def validate(self):
        if self.ecs_security_group_relation:
            for k in self.ecs_security_group_relation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EcsSecurityGroupRelation'] = []
        if self.ecs_security_group_relation is not None:
            for k in self.ecs_security_group_relation:
                result['EcsSecurityGroupRelation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ecs_security_group_relation = []
        if m.get('EcsSecurityGroupRelation') is not None:
            for k in m.get('EcsSecurityGroupRelation'):
                temp_model = DescribeSecurityGroupConfigurationResponseBodyItemsEcsSecurityGroupRelation()
                self.ecs_security_group_relation.append(temp_model.from_map(k))
        return self


class DescribeSecurityGroupConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        dbinstance_name: str = None,
        request_id: str = None,
        items: DescribeSecurityGroupConfigurationResponseBodyItems = None,
    ):
        self.dbinstance_name = dbinstance_name
        self.request_id = request_id
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_name is not None:
            result['DBInstanceName'] = self.dbinstance_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceName') is not None:
            self.dbinstance_name = m.get('DBInstanceName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Items') is not None:
            temp_model = DescribeSecurityGroupConfigurationResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class DescribeSecurityGroupConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityGroupConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityGroupConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSlowLogRecordsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        dbinstance_id: str = None,
        sqlhash: str = None,
        start_time: str = None,
        end_time: str = None,
        dbname: str = None,
        page_size: int = None,
        page_number: int = None,
        owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.dbinstance_id = dbinstance_id
        self.sqlhash = sqlhash
        self.start_time = start_time
        self.end_time = end_time
        self.dbname = dbname
        self.page_size = page_size
        self.page_number = page_number
        self.owner_account = owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.sqlhash is not None:
            result['SQLHASH'] = self.sqlhash
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('SQLHASH') is not None:
            self.sqlhash = m.get('SQLHASH')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        return self


class DescribeSlowLogRecordsResponseBodyItemsSQLSlowRecord(TeaModel):
    def __init__(
        self,
        host_address: str = None,
        rows_affected_count: int = None,
        query_times: int = None,
        sqltext: str = None,
        cpu_time: int = None,
        query_time_ms: int = None,
        application_name: str = None,
        lock_times: int = None,
        execution_start_time: str = None,
        logical_ioread: int = None,
        write_iocount: int = None,
        physical_ioread: int = None,
        return_row_counts: int = None,
        parse_row_counts: int = None,
        dbname: str = None,
        client_host_name: str = None,
        user_name: str = None,
        last_rows_affected_count: int = None,
    ):
        self.host_address = host_address
        self.rows_affected_count = rows_affected_count
        self.query_times = query_times
        self.sqltext = sqltext
        self.cpu_time = cpu_time
        self.query_time_ms = query_time_ms
        self.application_name = application_name
        self.lock_times = lock_times
        self.execution_start_time = execution_start_time
        self.logical_ioread = logical_ioread
        self.write_iocount = write_iocount
        self.physical_ioread = physical_ioread
        self.return_row_counts = return_row_counts
        self.parse_row_counts = parse_row_counts
        self.dbname = dbname
        self.client_host_name = client_host_name
        self.user_name = user_name
        self.last_rows_affected_count = last_rows_affected_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_address is not None:
            result['HostAddress'] = self.host_address
        if self.rows_affected_count is not None:
            result['RowsAffectedCount'] = self.rows_affected_count
        if self.query_times is not None:
            result['QueryTimes'] = self.query_times
        if self.sqltext is not None:
            result['SQLText'] = self.sqltext
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.query_time_ms is not None:
            result['QueryTimeMS'] = self.query_time_ms
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.lock_times is not None:
            result['LockTimes'] = self.lock_times
        if self.execution_start_time is not None:
            result['ExecutionStartTime'] = self.execution_start_time
        if self.logical_ioread is not None:
            result['LogicalIORead'] = self.logical_ioread
        if self.write_iocount is not None:
            result['WriteIOCount'] = self.write_iocount
        if self.physical_ioread is not None:
            result['PhysicalIORead'] = self.physical_ioread
        if self.return_row_counts is not None:
            result['ReturnRowCounts'] = self.return_row_counts
        if self.parse_row_counts is not None:
            result['ParseRowCounts'] = self.parse_row_counts
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.client_host_name is not None:
            result['ClientHostName'] = self.client_host_name
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.last_rows_affected_count is not None:
            result['LastRowsAffectedCount'] = self.last_rows_affected_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostAddress') is not None:
            self.host_address = m.get('HostAddress')
        if m.get('RowsAffectedCount') is not None:
            self.rows_affected_count = m.get('RowsAffectedCount')
        if m.get('QueryTimes') is not None:
            self.query_times = m.get('QueryTimes')
        if m.get('SQLText') is not None:
            self.sqltext = m.get('SQLText')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('QueryTimeMS') is not None:
            self.query_time_ms = m.get('QueryTimeMS')
      