# -*- coding: utf-8 -*-
"""
Public forms.
"""
from flask_wtf import Form
from megaqc.user.models import User
from wtforms import PasswordField, StringField
from wtforms.validators import DataRequired


class LoginForm(Form):
    """
    Login form.
    """

    username = StringField("Username", validators=[DataRequired()])
    password = PasswordField("Password", validators=[DataRequired()])

    def __init__(self, *args, **kwargs):
        """
        Create instance.
        """
        super(LoginForm, self).__init__(*args, **kwargs)
        self.user = None

    def validate(self):
        """
        Validate the form.
        """
        initial_validation = super(LoginForm, self).validate()
        if not initial_validation:
            return False

        self.user = User.query.filter_by(username=self.username.data).first()
        if not self.user:
            self.username.errors.append("Unknown username")
            return False

        if not self.user.check_password(self.password.data):
            self.password.errors.append("Invalid password")
            return False

        if not self.user.active:
            self.username.errors.append("User not activated")
            return False
        return True
