"""
empty message.

Revision ID: eb9fdf01bbae
Revises:
Create Date: 2020-08-05 11:55:10.348319
"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "eb9fdf01bbae"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "plot_config",
        sa.Column("config_id", sa.Integer(), nullable=False),
        sa.Column("config_type", sa.String(length=80), nullable=False),
        sa.Column("config_name", sa.String(length=80), nullable=False),
        sa.Column("config_dataset", sa.String(length=80), nullable=True),
        sa.Column("data", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("config_id"),
    )
    op.create_table(
        "sample_data_type",
        sa.Column("sample_data_type_id", sa.Integer(), nullable=False),
        sa.Column("data_id", sa.String(length=128), nullable=True),
        sa.Column("data_section", sa.String(length=80), nullable=True),
        sa.Column("data_key", sa.String(length=128), nullable=False),
        sa.PrimaryKeyConstraint("sample_data_type_id"),
    )
    op.create_table(
        "users",
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column(
            "username", sa.String(length=80, _expect_unicode=True), nullable=False
        ),
        sa.Column("email", sa.String(length=80, _expect_unicode=True), nullable=False),
        sa.Column("salt", sa.String(length=80, _expect_unicode=True), nullable=True),
        sa.Column(
            "password", sa.String(length=128, _expect_unicode=True), nullable=True
        ),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column(
            "first_name", sa.String(length=30, _expect_unicode=True), nullable=True
        ),
        sa.Column(
            "last_name", sa.String(length=30, _expect_unicode=True), nullable=True
        ),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("is_admin", sa.Boolean(), nullable=True),
        sa.Column(
            "api_token", sa.String(length=80, _expect_unicode=True), nullable=True
        ),
        sa.PrimaryKeyConstraint("user_id"),
        sa.UniqueConstraint("email"),
        sa.UniqueConstraint("username"),
    )
    op.create_table(
        "dashboard",
        sa.Column("dashboard_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("title", sa.String(length=2048), nullable=False),
        sa.Column("data", sa.String(length=2048), nullable=False),
        sa.Column("is_public", sa.Boolean(), nullable=True),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("dashboard_id"),
    )
    op.create_table(
        "plot_favourite",
        sa.Column("plot_favourite_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("title", sa.String(length=2048), nullable=False),
        sa.Column("description", sa.String(length=2048), nullable=True),
        sa.Column("plot_type", sa.String(length=128), nullable=False),
        sa.Column("data", sa.String(length=2048), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("plot_favourite_id"),
    )
    op.create_table(
        "report",
        sa.Column("report_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("report_hash", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("uploaded_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("report_id"),
    )
    op.create_table(
        "roles",
        sa.Column("role_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=80, _expect_unicode=True), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("role_id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "sample_filter",
        sa.Column("sample_filter_id", sa.Integer(), nullable=False),
        sa.Column("sample_filter_name", sa.String(length=80), nullable=True),
        sa.Column("sample_filter_tag", sa.String(length=80), nullable=True),
        sa.Column("is_public", sa.Boolean(), nullable=True),
        sa.Column("sample_filter_data", sa.String(length=2048), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("sample_filter_id"),
    )
    op.create_table(
        "uploads",
        sa.Column("upload_id", sa.Integer(), nullable=False),
        sa.Column("status", sa.String(length=80), nullable=True),
        sa.Column("path", sa.String(length=2048), nullable=True),
        sa.Column("message", sa.String(length=2048), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("upload_id"),
    )
    op.create_table(
        "user_plotconfig_map",
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("plot_config_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["plot_config_id"], ["plot_config.config_id"],),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
    )
    op.create_table(
        "user_sampletype_map",
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("sample_data_type_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["sample_data_type_id"], ["sample_data_type.sample_data_type_id"],
        ),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
    )
    op.create_table(
        "plot_category",
        sa.Column("plot_category_id", sa.Integer(), nullable=False),
        sa.Column("report_id", sa.Integer(), nullable=True),
        sa.Column("config_id", sa.Integer(), nullable=True),
        sa.Column("category_name", sa.String(length=128), nullable=True),
        sa.Column("data", sa.String(length=2048), nullable=False),
        sa.ForeignKeyConstraint(["config_id"], ["plot_config.config_id"],),
        sa.ForeignKeyConstraint(["report_id"], ["report.report_id"],),
        sa.PrimaryKeyConstraint("plot_category_id"),
    )
    op.create_table(
        "report_meta",
        sa.Column("report_meta_id", sa.Integer(), nullable=False),
        sa.Column("report_meta_key", sa.String(length=80), nullable=False),
        sa.Column("report_meta_value", sa.String(length=80), nullable=False),
        sa.Column("report_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["report_id"], ["report.report_id"],),
        sa.PrimaryKeyConstraint("report_meta_id"),
    )
    op.create_table(
        "sample",
        sa.Column("sample_id", sa.Integer(), nullable=False),
        sa.Column("sample_name", sa.String(length=80), nullable=True),
        sa.Column("report_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["report_id"], ["report.report_id"],),
        sa.PrimaryKeyConstraint("sample_id"),
    )
    op.create_table(
        "plot_data",
        sa.Column("plot_data_id", sa.Integer(), nullable=False),
        sa.Column("report_id", sa.Integer(), nullable=True),
        sa.Column("config_id", sa.Integer(), nullable=True),
        sa.Column("plot_category_id", sa.Integer(), nullable=True),
        sa.Column("sample_id", sa.Integer(), nullable=True),
        sa.Column("data", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["config_id"], ["plot_config.config_id"],),
        sa.ForeignKeyConstraint(
            ["plot_category_id"], ["plot_category.plot_category_id"],
        ),
        sa.ForeignKeyConstraint(["report_id"], ["report.report_id"],),
        sa.ForeignKeyConstraint(["sample_id"], ["sample.sample_id"],),
        sa.PrimaryKeyConstraint("plot_data_id"),
    )
    op.create_table(
        "sample_data",
        sa.Column("sample_data_id", sa.Integer(), nullable=False),
        sa.Column("report_id", sa.Integer(), nullable=True),
        sa.Column("sample_data_type_id", sa.Integer(), nullable=True),
        sa.Column("sample_id", sa.Integer(), nullable=True),
        sa.Column("value", sa.String(length=1024), nullable=True),
        sa.ForeignKeyConstraint(["report_id"], ["report.report_id"],),
        sa.ForeignKeyConstraint(
            ["sample_data_type_id"], ["sample_data_type.sample_data_type_id"],
        ),
        sa.ForeignKeyConstraint(["sample_id"], ["sample.sample_id"],),
        sa.PrimaryKeyConstraint("sample_data_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("sample_data")
    op.drop_table("plot_data")
    op.drop_table("sample")
    op.drop_table("report_meta")
    op.drop_table("plot_category")
    op.drop_table("user_sampletype_map")
    op.drop_table("user_plotconfig_map")
    op.drop_table("uploads")
    op.drop_table("sample_filter")
    op.drop_table("roles")
    op.drop_table("report")
    op.drop_table("plot_favourite")
    op.drop_table("dashboard")
    op.drop_table("users")
    op.drop_table("sample_data_type")
    op.drop_table("plot_config")
    # ### end Alembic commands ###
