"""
empty message.

Revision ID: 007c354223ec
Revises: e38ef2ac89ab
Create Date: 2020-08-05 12:01:31.378972
"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "007c354223ec"
down_revision = "e38ef2ac89ab"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_report_report_hash", table_name="report")
    op.create_index(
        op.f("ix_report_report_hash"), "report", ["report_hash"], unique=True
    )
    op.drop_constraint("report_user_id_fkey", "report", type_="foreignkey")
    op.create_foreign_key(
        None, "report", "users", ["user_id"], ["user_id"], ondelete="SET NULL"
    )
    op.alter_column(
        "report_meta", "report_id", existing_type=sa.INTEGER(), nullable=False
    )
    op.drop_constraint("report_meta_report_id_fkey", "report_meta", type_="foreignkey")
    op.create_foreign_key(
        None, "report_meta", "report", ["report_id"], ["report_id"], ondelete="CASCADE"
    )
    op.alter_column("sample", "report_id", existing_type=sa.INTEGER(), nullable=False)
    op.drop_constraint("sample_report_id_fkey", "sample", type_="foreignkey")
    op.create_foreign_key(
        None, "sample", "report", ["report_id"], ["report_id"], ondelete="CASCADE"
    )
    op.alter_column(
        "sample_data", "sample_data_type_id", existing_type=sa.INTEGER(), nullable=False
    )
    op.alter_column(
        "sample_data", "sample_id", existing_type=sa.INTEGER(), nullable=False
    )
    op.drop_constraint("sample_data_sample_id_fkey", "sample_data", type_="foreignkey")
    op.drop_constraint(
        "sample_data_sample_data_type_id_fkey", "sample_data", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "sample_data", "sample", ["sample_id"], ["sample_id"], ondelete="CASCADE"
    )
    op.create_foreign_key(
        None,
        "sample_data",
        "sample_data_type",
        ["sample_data_type_id"],
        ["sample_data_type_id"],
        ondelete="CASCADE",
    )
    op.add_column("sample_data_type", sa.Column("schema", sa.Unicode(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("sample_data_type", "schema")
    op.drop_constraint(None, "sample_data", type_="foreignkey")
    op.drop_constraint(None, "sample_data", type_="foreignkey")
    op.create_foreign_key(
        "sample_data_sample_data_type_id_fkey",
        "sample_data",
        "sample_data_type",
        ["sample_data_type_id"],
        ["sample_data_type_id"],
    )
    op.create_foreign_key(
        "sample_data_sample_id_fkey",
        "sample_data",
        "sample",
        ["sample_id"],
        ["sample_id"],
    )
    op.alter_column(
        "sample_data", "sample_id", existing_type=sa.INTEGER(), nullable=True
    )
    op.alter_column(
        "sample_data", "sample_data_type_id", existing_type=sa.INTEGER(), nullable=True
    )
    op.drop_constraint(None, "sample", type_="foreignkey")
    op.create_foreign_key(
        "sample_report_id_fkey", "sample", "report", ["report_id"], ["report_id"]
    )
    op.alter_column("sample", "report_id", existing_type=sa.INTEGER(), nullable=True)
    op.drop_constraint(None, "report_meta", type_="foreignkey")
    op.create_foreign_key(
        "report_meta_report_id_fkey",
        "report_meta",
        "report",
        ["report_id"],
        ["report_id"],
    )
    op.alter_column(
        "report_meta", "report_id", existing_type=sa.INTEGER(), nullable=True
    )
    op.drop_constraint(None, "report", type_="foreignkey")
    op.create_foreign_key(
        "report_user_id_fkey", "report", "users", ["user_id"], ["user_id"]
    )
    op.drop_index(op.f("ix_report_report_hash"), table_name="report")
    op.create_index("ix_report_report_hash", "report", ["report_hash"], unique=False)
    # ### end Alembic commands ###
