# toolbox

[![PyPI](https://img.shields.io/pypi/v/mdf_toolbox.svg)](https://pypi.python.org/pypi/mdf-toolbox) [![Build Status](https://travis-ci.org/materials-data-facility/toolbox.svg?branch=master)](https://travis-ci.org/materials-data-facility/toolbox) [![Coverage Status](https://coveralls.io/repos/github/materials-data-facility/toolbox/badge.svg?branch=master)](https://coveralls.io/github/materials-data-facility/toolbox?branch=master)


Toolbox is a collection of the Materials Data Facility tools and utilities.


# Installation

```
pip install mdf_toolbox
```

### For Developers
```
git clone https://github.com/materials-data-facility/toolbox.git
cd toolbox
pip install -e .
```

# Documentation and examples
Documentation can be found on [Read the Docs](https://mdf-toolbox.readthedocs.io/en/master/).
Tutorials can also be found in the `docs` directory. The Jupyter notebooks can be viewed on Read the Docs or GitHub, or run interactively with [Jupyter](http://jupyter.org/install).

# Requirements
* Toolbox requires Python 3.5 or greater.
* To submit data to the MDF, you must have an account recognized by Globus Auth (including Google, ORCiD, many academic institutions, or a [free Globus ID](https://www.globusid.org/create)).

# Contributions
If you find a bug or want a feature, feel free to open an issue here on GitHub (and please tag it accordingly). If you want to contribute code yourself, we're more than happy to accept merge requests.



# Support
This work was performed under financial assistance award 70NANB14H012 from U.S. Department of Commerce, National Institute of Standards and Technology as part of the [Center for Hierarchical Material Design (CHiMaD)](http://chimad.northwestern.edu). This work was performed under the following financial assistance award 70NANB19H005 from U.S. Department of Commerce, National Institute of Standards and Technology as part of the Center for Hierarchical Materials Design (CHiMaD). This work was also supported by the National Science Foundation as part of the [Midwest Big Data Hub](http://midwestbigdatahub.org) under NSF Award Number: 1636950 "BD Spokes: SPOKE: MIDWEST: Collaborative: Integrative Materials Design (IMaD): Leverage, Innovate, and Disseminate".
