from typing import Any, Dict, Optional, Union, cast

import httpx

from ...client import Client
from ...models.future import Future
from ...types import Response


def _get_kwargs(
    future_id: str,
    *,
    client: Client,

) -> Dict[str, Any]:
    url = "{}/v1/futures/{futureId}".format(
        client.base_url,futureId=future_id)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    

    

    

    

    

    return {
	    "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
    }


def _parse_response(*, response: httpx.Response) -> Optional[Union[Any, Future]]:
    if response.status_code == 200:
        response_200 = Future.from_dict(response.json())



        return response_200
    if response.status_code == 401:
        response_401 = cast(Any, None)
        return response_401
    return None


def _build_response(*, response: httpx.Response) -> Response[Union[Any, Future]]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    future_id: str,
    *,
    client: Client,

) -> Response[Union[Any, Future]]:
    """Check on the progress of your request

    Args:
        future_id (str):

    Returns:
        Response[Union[Any, Future]]
    """


    kwargs = _get_kwargs(
        future_id=future_id,
client=client,

    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)

def sync(
    future_id: str,
    *,
    client: Client,

) -> Optional[Union[Any, Future]]:
    """Check on the progress of your request

    Args:
        future_id (str):

    Returns:
        Response[Union[Any, Future]]
    """


    return sync_detailed(
        future_id=future_id,
client=client,

    ).parsed

async def asyncio_detailed(
    future_id: str,
    *,
    client: Client,

) -> Response[Union[Any, Future]]:
    """Check on the progress of your request

    Args:
        future_id (str):

    Returns:
        Response[Union[Any, Future]]
    """


    kwargs = _get_kwargs(
        future_id=future_id,
client=client,

    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(
            **kwargs
        )

    return _build_response(response=response)

async def asyncio(
    future_id: str,
    *,
    client: Client,

) -> Optional[Union[Any, Future]]:
    """Check on the progress of your request

    Args:
        future_id (str):

    Returns:
        Response[Union[Any, Future]]
    """


    return (await asyncio_detailed(
        future_id=future_id,
client=client,

    )).parsed
