# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-01-29 08:37
from __future__ import unicode_literals

import codenerix.models_people
import codenerix_pos.models
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('codenerix_products', '0008_auto_20180126_1711'),
        ('codenerix_storages', '0010_auto_20180123_1316'),
        ('codenerix_payments', '0001_initial'),
        ('codenerix_invoicing', '0001_initial'),
        ('codenerix_corporate', '0003_auto_20180118_1757'),
    ]

    operations = [
        migrations.CreateModel(
            name='POS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=250, unique=True, verbose_name='Name')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('key', models.CharField(default=codenerix_pos.models.keymaker, editable=False, max_length=32, unique=True, verbose_name='Key')),
                ('channel', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Channel')),
                ('commit', models.CharField(blank=True, default='LATEST', max_length=40, null=True, verbose_name='Commit')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSGroupProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('enable', models.BooleanField(default=True, verbose_name='Enable')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSHardware',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('kind', models.CharField(choices=[('TICKET', 'Ticket printer'), ('DNIE', 'DNIe card reader'), ('CASH', 'Cash drawer'), ('WEIGHT', 'Weight'), ('SIGN', 'Signature pad'), ('QUERY', 'Query service (Ex: Barcode)')], max_length=6, verbose_name='Kind')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('enable', models.BooleanField(default=True, verbose_name='Enable')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('key', models.CharField(default=codenerix_pos.models.keymaker, editable=False, max_length=32, unique=True, verbose_name='Key')),
                ('profile', models.CharField(blank=True, default='CONFIG', max_length=30, verbose_name='Profile')),
                ('config', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='config')),
                ('value', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='config')),
                ('pos', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='hardwares', to='codenerix_pos.POS', verbose_name='POS')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('log', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='LOG')),
                ('pos', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='codenerix_pos.POS', verbose_name='POS')),
                ('poshw', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='codenerix_pos.POSHardware', verbose_name='POS')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSOperator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('enable', models.BooleanField(default=True, verbose_name='Enable')),
                ('pos', models.ManyToManyField(related_name='pos_operators', to='codenerix_pos.POS', verbose_name='POS')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
            bases=(codenerix.models_people.GenRole, models.Model),
        ),
        migrations.CreateModel(
            name='POSPlant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=250, unique=True, verbose_name='Name')),
                ('billing_series', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='posplants', to='codenerix_invoicing.BillingSeries', verbose_name='Billing series')),
                ('corporate_image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='posplants', to='codenerix_corporate.CorporateImage', verbose_name='Corporate image')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('enable', models.BooleanField(default=True, verbose_name='Enable')),
                ('group_product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='posproducts', to='codenerix_pos.POSGroupProduct', verbose_name='Group Product')),
                ('product_final', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='posproducts', to='codenerix_products.ProductFinal', verbose_name='Product')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSSlot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=250, unique=True, verbose_name='Name')),
                ('pos_x', models.IntegerField(blank=True, default=None, editable=False, null=True, verbose_name='Pos X')),
                ('pos_y', models.IntegerField(blank=True, default=None, editable=False, null=True, verbose_name='Pos Y')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='POSZone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=250, unique=True, verbose_name='Name')),
                ('plant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='zones', to='codenerix_pos.POSPlant', verbose_name='Plant')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='posslot',
            name='zone',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='slots', to='codenerix_pos.POSZone', verbose_name='Zone'),
        ),
        migrations.AddField(
            model_name='pos',
            name='group_product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='poss', to='codenerix_pos.POSGroupProduct', verbose_name='Group product'),
        ),
        migrations.AddField(
            model_name='pos',
            name='hardware',
            field=models.ManyToManyField(blank=True, null=True, related_name='poss', to='codenerix_pos.POSHardware', verbose_name='Hardware it can use'),
        ),
        migrations.AddField(
            model_name='pos',
            name='payments',
            field=models.ManyToManyField(blank=True, related_name='poss', to='codenerix_payments.PaymentRequest', verbose_name='Payments'),
        ),
        migrations.AddField(
            model_name='pos',
            name='storage_query',
            field=models.ManyToManyField(blank=True, null=True, related_name='poss_storage_query', to='codenerix_storages.Storage', verbose_name='Storages where you can consult'),
        ),
        migrations.AddField(
            model_name='pos',
            name='storage_stock',
            field=models.ManyToManyField(blank=True, null=True, related_name='poss_storage_stock', to='codenerix_storages.Storage', verbose_name='Storages where the stock is subtracted'),
        ),
        migrations.AddField(
            model_name='pos',
            name='zone',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='poss', to='codenerix_pos.POSZone', verbose_name='Zone'),
        ),
        migrations.AlterUniqueTogether(
            name='posproduct',
            unique_together=set([('group_product', 'product_final')]),
        ),
        migrations.AlterUniqueTogether(
            name='poshardware',
            unique_together=set([('pos', 'kind', 'name')]),
        ),
    ]
