# thousandeyes-sdk-instant-tests
The Instant Tests API operations lets you create and run new instant tests. You will need to be an Account Admin.

The response does not include the immediate test results. Use the Test Results endpoints to get test results after creating and executing an instant test. You can find the URLs for these endpoints in the _links section of the test definition that is returned when you create the instant test.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 7.0.65
- Generator version: 7.6.0
- Build package: com.thousandeyes.api.codegen.ThousandeyesPythonGenerator

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

Install directly via PyPi:

```sh
pip install thousandeyes-sdk-instant-tests
```
(you may need to run `pip` with root permission: `sudo pip install thousandeyes-sdk-instant-tests`)

Then import the package:
```python
import thousandeyes_sdk.instant_tests
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import thousandeyes_sdk.instant_tests
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the installation procedure and then run the following:

```python

import thousandeyes_sdk.core
import thousandeyes_sdk.instant_tests
from thousandeyes_sdk.core.exceptions import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.thousandeyes.com/v7
# See configuration.py for a list of all supported configuration parameters.
configuration = thousandeyes_sdk.core.Configuration(
    host = "https://api.thousandeyes.com/v7"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = thousandeyes_sdk.core.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with thousandeyes_sdk.core.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = thousandeyes_sdk.instant_tests.APIInstantTestsApi(api_client)
    api_instant_test_request = thousandeyes_sdk.instant_tests.ApiInstantTestRequest() # ApiInstantTestRequest | 
    aid = '1234' # str | A unique identifier associated with your account group. You can retrieve your `AccountGroupId` from the `/account-groups` endpoint. Note that you must be assigned to the target account group. Specifying this parameter without being assigned to the target account group will result in an error response. (optional)
    expand = [thousandeyes_sdk.instant_tests.ExpandInstantTestOptions()] # List[ExpandInstantTestOptions] | (Optional) Indicates if the test sub-resources should be expanded. Defaults to no expansion. To expand the `agents` sub-resource, use the query `?expand=agent`. (optional)

    try:
        # Create API instant test
        api_response = api_instance.create_api_instant_test(api_instant_test_request, aid=aid, expand=expand)
        print("The response of APIInstantTestsApi->create_api_instant_test:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIInstantTestsApi->create_api_instant_test: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.thousandeyes.com/v7*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIInstantTestsApi* | [**create_api_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/APIInstantTestsApi.md#create_api_instant_test) | **POST** /tests/api/instant | Create API instant test
*AgentToAgentInstantTestsApi* | [**create_agent_to_agent_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentInstantTestsApi.md#create_agent_to_agent_instant_test) | **POST** /tests/agent-to-agent/instant | Create agent-to-agent instant test
*AgentToServerInstantTestsApi* | [**create_agent_to_server_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToServerInstantTestsApi.md#create_agent_to_server_instant_test) | **POST** /tests/agent-to-server/instant | Create agent-to-server instant test
*DNSSECInstantTestsApi* | [**create_dns_sec_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DNSSECInstantTestsApi.md#create_dns_sec_instant_test) | **POST** /tests/dnssec/instant | Create DNSSEC instant test
*DNSServerInstantTestsApi* | [**create_dns_server_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DNSServerInstantTestsApi.md#create_dns_server_instant_test) | **POST** /tests/dns-server/instant | Create DNS server instant test
*DNSTraceInstantTestsApi* | [**create_dns_trace_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DNSTraceInstantTestsApi.md#create_dns_trace_instant_test) | **POST** /tests/dns-trace/instant | Create DNS trace instant test
*FTPServerInstantTestsApi* | [**create_ftp_server_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FTPServerInstantTestsApi.md#create_ftp_server_instant_test) | **POST** /tests/ftp-server/instant | Create FTP server instant test
*HTTPPageLoadInstantTestsApi* | [**create_page_load_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HTTPPageLoadInstantTestsApi.md#create_page_load_instant_test) | **POST** /tests/page-load/instant | Create HTTP page load instant test
*HTTPServerInstantTestsApi* | [**create_http_server_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HTTPServerInstantTestsApi.md#create_http_server_instant_test) | **POST** /tests/http-server/instant | Create HTTP server instant test
*InstantTestsApi* | [**run_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/InstantTestsApi.md#run_instant_test) | **POST** /tests/{testId}/run | Run instant test
*SIPServerInstantTestsApi* | [**create_sip_server_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SIPServerInstantTestsApi.md#create_sip_server_instant_test) | **POST** /tests/sip-server/instant | Create SIP server instant test
*VoiceInstantTestsApi* | [**create_voice_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/VoiceInstantTestsApi.md#create_voice_instant_test) | **POST** /tests/voice/instant | Create voice instant test
*WebTransactionInstantTestsApi* | [**create_web_transaction_instant_test**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/WebTransactionInstantTestsApi.md#create_web_transaction_instant_test) | **POST** /tests/web-transactions/instant | Create web transactions instant test


## Documentation For Models

 - [AgentBase](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentBase.md)
 - [AgentInterfaces](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentInterfaces.md)
 - [AgentResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentResponse.md)
 - [AgentToAgentInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentInstantTest.md)
 - [AgentToAgentInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentInstantTestRequest.md)
 - [AgentToAgentInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentInstantTestResponse.md)
 - [AgentToAgentProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentProperties.md)
 - [AgentToAgentTestProtocol](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToAgentTestProtocol.md)
 - [AgentToServerInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToServerInstantTest.md)
 - [AgentToServerInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToServerInstantTestRequest.md)
 - [AgentToServerInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToServerInstantTestResponse.md)
 - [AgentToServerProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/AgentToServerProperties.md)
 - [ApiClientAuthentication](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiClientAuthentication.md)
 - [ApiInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiInstantTest.md)
 - [ApiInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiInstantTestRequest.md)
 - [ApiInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiInstantTestResponse.md)
 - [ApiPredefinedVariable](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiPredefinedVariable.md)
 - [ApiProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiProperties.md)
 - [ApiRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequest.md)
 - [ApiRequestAssertion](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestAssertion.md)
 - [ApiRequestAssertionName](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestAssertionName.md)
 - [ApiRequestAssertionOperator](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestAssertionOperator.md)
 - [ApiRequestAuthType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestAuthType.md)
 - [ApiRequestHeader](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestHeader.md)
 - [ApiRequestMethod](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestMethod.md)
 - [ApiRequestVariable](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ApiRequestVariable.md)
 - [CloudEnterpriseAgentType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/CloudEnterpriseAgentType.md)
 - [DnsQueryClass](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsQueryClass.md)
 - [DnsSecInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsSecInstantTest.md)
 - [DnsSecInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsSecInstantTestRequest.md)
 - [DnsSecInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsSecInstantTestResponse.md)
 - [DnsSecProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsSecProperties.md)
 - [DnsServerInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsServerInstantTest.md)
 - [DnsServerInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsServerInstantTestRequest.md)
 - [DnsServerInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsServerInstantTestResponse.md)
 - [DnsServerProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsServerProperties.md)
 - [DnsServersRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsServersRequest.md)
 - [DnsTraceInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsTraceInstantTest.md)
 - [DnsTraceInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsTraceInstantTestRequest.md)
 - [DnsTraceInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsTraceInstantTestResponse.md)
 - [DnsTraceProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/DnsTraceProperties.md)
 - [Error](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/Error.md)
 - [ExpandInstantTestOptions](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ExpandInstantTestOptions.md)
 - [FtpServerInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FtpServerInstantTest.md)
 - [FtpServerInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FtpServerInstantTestRequest.md)
 - [FtpServerInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FtpServerInstantTestResponse.md)
 - [FtpServerProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FtpServerProperties.md)
 - [FtpServerRequestType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/FtpServerRequestType.md)
 - [HttpServerBaseProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HttpServerBaseProperties.md)
 - [HttpServerInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HttpServerInstantTest.md)
 - [HttpServerInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HttpServerInstantTestRequest.md)
 - [HttpServerInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HttpServerInstantTestResponse.md)
 - [HttpServerProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/HttpServerProperties.md)
 - [InstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/InstantTest.md)
 - [InstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/InstantTestRequest.md)
 - [Link](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/Link.md)
 - [OAuth](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/OAuth.md)
 - [PageLoadInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/PageLoadInstantTest.md)
 - [PageLoadInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/PageLoadInstantTestRequest.md)
 - [PageLoadInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/PageLoadInstantTestResponse.md)
 - [PageLoadProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/PageLoadProperties.md)
 - [RequestMethod](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/RequestMethod.md)
 - [SharedWithAccount](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SharedWithAccount.md)
 - [SimpleAgent](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SimpleAgent.md)
 - [SipServerInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SipServerInstantTest.md)
 - [SipServerInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SipServerInstantTestRequest.md)
 - [SipServerInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SipServerInstantTestResponse.md)
 - [SipServerProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SipServerProperties.md)
 - [SipTestProtocol](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/SipTestProtocol.md)
 - [TestAgent](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestAgent.md)
 - [TestAuthType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestAuthType.md)
 - [TestCustomHeaders](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestCustomHeaders.md)
 - [TestDirection](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestDirection.md)
 - [TestDnsServer](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestDnsServer.md)
 - [TestDnsTransportProtocol](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestDnsTransportProtocol.md)
 - [TestDscpId](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestDscpId.md)
 - [TestIpv6Policy](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestIpv6Policy.md)
 - [TestLabel](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestLabel.md)
 - [TestLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestLinks.md)
 - [TestPageLoadingStrategy](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestPageLoadingStrategy.md)
 - [TestPathTraceMode](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestPathTraceMode.md)
 - [TestProbeMode](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestProbeMode.md)
 - [TestProtocol](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestProtocol.md)
 - [TestSelfLink](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestSelfLink.md)
 - [TestSipCredentials](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestSipCredentials.md)
 - [TestSslVersionId](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestSslVersionId.md)
 - [TestType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/TestType.md)
 - [UnauthorizedError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/UnauthorizedError.md)
 - [UnexpandedInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/UnexpandedInstantTest.md)
 - [ValidationError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ValidationError.md)
 - [ValidationErrorItem](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/ValidationErrorItem.md)
 - [VoiceInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/VoiceInstantTest.md)
 - [VoiceInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/VoiceInstantTestRequest.md)
 - [VoiceInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/VoiceInstantTestResponse.md)
 - [VoiceProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/VoiceProperties.md)
 - [WebTransactionInstantTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/WebTransactionInstantTest.md)
 - [WebTransactionInstantTestRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/WebTransactionInstantTestRequest.md)
 - [WebTransactionInstantTestResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/WebTransactionInstantTestResponse.md)
 - [WebTransactionProperties](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-instant-tests/docs/WebTransactionProperties.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author

<a href="mailto:api-team@thousandeyes.com">ThousandEyes API Team </a>


