import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabUserSshkeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user_sshkeys#id DataGitlabUserSshkeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the user to get the SSH keys for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user_sshkeys#user_id DataGitlabUserSshkeys#user_id}
    */
    readonly userId?: number;
    /**
    * Username of the user to get the SSH keys for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/user_sshkeys#username DataGitlabUserSshkeys#username}
    */
    readonly username?: string;
}
export interface DataGitlabUserSshkeysKeys {
}
export declare function dataGitlabUserSshkeysKeysToTerraform(struct?: DataGitlabUserSshkeysKeys): any;
export declare class DataGitlabUserSshkeysKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabUserSshkeysKeys | undefined;
    set internalValue(value: DataGitlabUserSshkeysKeys | undefined);
    get createdAt(): string;
    get expiresAt(): string;
    get key(): string;
    get keyId(): number;
    get title(): string;
    get userId(): number;
}
export declare class DataGitlabUserSshkeysKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabUserSshkeysKeysOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/user_sshkeys gitlab_user_sshkeys}
*/
export declare class DataGitlabUserSshkeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_user_sshkeys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/user_sshkeys gitlab_user_sshkeys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabUserSshkeysConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabUserSshkeysConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keys;
    get keys(): DataGitlabUserSshkeysKeysList;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
