import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectBranchesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_branches#id DataGitlabProjectBranches#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_branches#project DataGitlabProjectBranches#project}
    */
    readonly project: string;
}
export interface DataGitlabProjectBranchesBranchesCommit {
}
export declare function dataGitlabProjectBranchesBranchesCommitToTerraform(struct?: DataGitlabProjectBranchesBranchesCommit): any;
export declare class DataGitlabProjectBranchesBranchesCommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectBranchesBranchesCommit | undefined;
    set internalValue(value: DataGitlabProjectBranchesBranchesCommit | undefined);
    get authorEmail(): string;
    get authorName(): string;
    get authoredDate(): string;
    get committedDate(): string;
    get committerEmail(): string;
    get committerName(): string;
    get id(): string;
    get message(): string;
    get parentIds(): string[];
    get shortId(): string;
    get title(): string;
}
export declare class DataGitlabProjectBranchesBranchesCommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectBranchesBranchesCommitOutputReference;
}
export interface DataGitlabProjectBranchesBranches {
}
export declare function dataGitlabProjectBranchesBranchesToTerraform(struct?: DataGitlabProjectBranchesBranches): any;
export declare class DataGitlabProjectBranchesBranchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectBranchesBranches | undefined;
    set internalValue(value: DataGitlabProjectBranchesBranches | undefined);
    get canPush(): cdktf.IResolvable;
    private _commit;
    get commit(): DataGitlabProjectBranchesBranchesCommitList;
    get default(): cdktf.IResolvable;
    get developersCanMerge(): cdktf.IResolvable;
    get developersCanPush(): cdktf.IResolvable;
    get merged(): cdktf.IResolvable;
    get name(): string;
    get protected(): cdktf.IResolvable;
    get webUrl(): string;
}
export declare class DataGitlabProjectBranchesBranchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectBranchesBranchesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_branches gitlab_project_branches}
*/
export declare class DataGitlabProjectBranches extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_branches";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_branches gitlab_project_branches} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectBranchesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectBranchesConfig);
    private _branches;
    get branches(): DataGitlabProjectBranchesBranchesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
