import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set, abuse reports are sent to this address. Abuse reports are always available in the Admin Area.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#abuse_notification_email ApplicationSettings#abuse_notification_email}
    */
    readonly abuseNotificationEmail?: string;
    /**
    * Require administrators to enable Admin Mode by re-authenticating for administrative tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#admin_mode ApplicationSettings#admin_mode}
    */
    readonly adminMode?: boolean | cdktf.IResolvable;
    /**
    * Where to redirect users after logout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#after_sign_out_path ApplicationSettings#after_sign_out_path}
    */
    readonly afterSignOutPath?: string;
    /**
    * Text shown to the user after signing up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#after_sign_up_text ApplicationSettings#after_sign_up_text}
    */
    readonly afterSignUpText?: string;
    /**
    * API key for Akismet spam protection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#akismet_api_key ApplicationSettings#akismet_api_key}
    */
    readonly akismetApiKey?: string;
    /**
    * (If enabled, requires: akismet_api_key) Enable or disable Akismet spam protection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#akismet_enabled ApplicationSettings#akismet_enabled}
    */
    readonly akismetEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set to true to allow group owners to manage LDAP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#allow_group_owners_to_manage_ldap ApplicationSettings#allow_group_owners_to_manage_ldap}
    */
    readonly allowGroupOwnersToManageLdap?: boolean | cdktf.IResolvable;
    /**
    * Allow requests to the local network from system hooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#allow_local_requests_from_system_hooks ApplicationSettings#allow_local_requests_from_system_hooks}
    */
    readonly allowLocalRequestsFromSystemHooks?: boolean | cdktf.IResolvable;
    /**
    * Allow requests to the local network from web hooks and services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#allow_local_requests_from_web_hooks_and_services ApplicationSettings#allow_local_requests_from_web_hooks_and_services}
    */
    readonly allowLocalRequestsFromWebHooksAndServices?: boolean | cdktf.IResolvable;
    /**
    * Set the duration for which the jobs are considered as old and expired. After that time passes, the jobs are archived and no longer able to be retried. Make it empty to never expire jobs. It has to be no less than 1 day, for example: 15 days, 1 month, 2 years.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#archive_builds_in_human_readable ApplicationSettings#archive_builds_in_human_readable}
    */
    readonly archiveBuildsInHumanReadable?: string;
    /**
    * Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#asset_proxy_allowlist ApplicationSettings#asset_proxy_allowlist}
    */
    readonly assetProxyAllowlist?: string[];
    /**
    * (If enabled, requires: asset_proxy_url) Enable proxying of assets. GitLab restart is required to apply changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#asset_proxy_enabled ApplicationSettings#asset_proxy_enabled}
    */
    readonly assetProxyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Shared secret with the asset proxy server. GitLab restart is required to apply changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#asset_proxy_secret_key ApplicationSettings#asset_proxy_secret_key}
    */
    readonly assetProxySecretKey?: string;
    /**
    * URL of the asset proxy server. GitLab restart is required to apply changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#asset_proxy_url ApplicationSettings#asset_proxy_url}
    */
    readonly assetProxyUrl?: string;
    /**
    * By default, we write to the authorized_keys file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#authorized_keys_enabled ApplicationSettings#authorized_keys_enabled}
    */
    readonly authorizedKeysEnabled?: boolean | cdktf.IResolvable;
    /**
    * Specify a domain to use by default for every project’s Auto Review Apps and Auto Deploy stages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#auto_devops_domain ApplicationSettings#auto_devops_domain}
    */
    readonly autoDevopsDomain?: string;
    /**
    * Enable Auto DevOps for projects by default. It automatically builds, tests, and deploys applications based on a predefined CI/CD configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#auto_devops_enabled ApplicationSettings#auto_devops_enabled}
    */
    readonly autoDevopsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enabling this permits automatic allocation of purchased storage in a namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#automatic_purchased_storage_allocation ApplicationSettings#automatic_purchased_storage_allocation}
    */
    readonly automaticPurchasedStorageAllocation?: boolean | cdktf.IResolvable;
    /**
    * Enabling this makes only licensed EE features available to projects if the project namespace’s plan includes the feature or if the project is public.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#check_namespace_plan ApplicationSettings#check_namespace_plan}
    */
    readonly checkNamespacePlan?: boolean | cdktf.IResolvable;
    /**
    * Custom hostname (for private commit emails).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#commit_email_hostname ApplicationSettings#commit_email_hostname}
    */
    readonly commitEmailHostname?: string;
    /**
    * Enable cleanup policies for all projects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_expiration_policies_enable_historic_entries ApplicationSettings#container_expiration_policies_enable_historic_entries}
    */
    readonly containerExpirationPoliciesEnableHistoricEntries?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of tags that can be deleted in a single execution of cleanup policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_registry_cleanup_tags_service_max_list_size ApplicationSettings#container_registry_cleanup_tags_service_max_list_size}
    */
    readonly containerRegistryCleanupTagsServiceMaxListSize?: number;
    /**
    * The maximum time, in seconds, that the cleanup process can take to delete a batch of tags for cleanup policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_registry_delete_tags_service_timeout ApplicationSettings#container_registry_delete_tags_service_timeout}
    */
    readonly containerRegistryDeleteTagsServiceTimeout?: number;
    /**
    * Caching during the execution of cleanup policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_registry_expiration_policies_caching ApplicationSettings#container_registry_expiration_policies_caching}
    */
    readonly containerRegistryExpirationPoliciesCaching?: boolean | cdktf.IResolvable;
    /**
    * Number of workers for cleanup policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_registry_expiration_policies_worker_capacity ApplicationSettings#container_registry_expiration_policies_worker_capacity}
    */
    readonly containerRegistryExpirationPoliciesWorkerCapacity?: number;
    /**
    * Container Registry token duration in minutes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#container_registry_token_expire_delay ApplicationSettings#container_registry_token_expire_delay}
    */
    readonly containerRegistryTokenExpireDelay?: number;
    /**
    * Enable automatic deactivation of dormant users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#deactivate_dormant_users ApplicationSettings#deactivate_dormant_users}
    */
    readonly deactivateDormantUsers?: boolean | cdktf.IResolvable;
    /**
    * Set the default expiration time for each job’s artifacts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_artifacts_expire_in ApplicationSettings#default_artifacts_expire_in}
    */
    readonly defaultArtifactsExpireIn?: string;
    /**
    * Instance-level custom initial branch name (introduced in GitLab 13.2).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_branch_name ApplicationSettings#default_branch_name}
    */
    readonly defaultBranchName?: string;
    /**
    * Determine if developers can push to the default branch. Can take: 0 (not protected, both users with the Developer role or Maintainer role can push new commits and force push), 1 (partially protected, users with the Developer role or Maintainer role can push new commits, but cannot force push) or 2 (fully protected, users with the Developer or Maintainer role cannot push new commits, but users with the Developer or Maintainer role can; no one can force push) as a parameter. Default is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_branch_protection ApplicationSettings#default_branch_protection}
    */
    readonly defaultBranchProtection?: number;
    /**
    * Default CI/CD configuration file and path for new projects (.gitlab-ci.yml if not set).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_ci_config_path ApplicationSettings#default_ci_config_path}
    */
    readonly defaultCiConfigPath?: string;
    /**
    * What visibility level new groups receive. Can take private, internal and public as a parameter. Default is private.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_group_visibility ApplicationSettings#default_group_visibility}
    */
    readonly defaultGroupVisibility?: string;
    /**
    * Default project creation protection. Can take: 0 (No one), 1 (Maintainers) or 2 (Developers + Maintainers).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_project_creation ApplicationSettings#default_project_creation}
    */
    readonly defaultProjectCreation?: number;
    /**
    * What visibility level new projects receive. Can take private, internal and public as a parameter. Default is private.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_project_visibility ApplicationSettings#default_project_visibility}
    */
    readonly defaultProjectVisibility?: string;
    /**
    * Project limit per user. Default is 100000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_projects_limit ApplicationSettings#default_projects_limit}
    */
    readonly defaultProjectsLimit?: number;
    /**
    * What visibility level new snippets receive. Can take private, internal and public as a parameter. Default is private.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#default_snippet_visibility ApplicationSettings#default_snippet_visibility}
    */
    readonly defaultSnippetVisibility?: string;
    /**
    * Enable delayed group deletion. Default is true. Introduced in GitLab 15.0. From GitLab 15.1, disables and locks the group-level setting for delayed protect deletion when set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#delayed_group_deletion ApplicationSettings#delayed_group_deletion}
    */
    readonly delayedGroupDeletion?: boolean | cdktf.IResolvable;
    /**
    * Enable delayed project deletion by default in new groups. Default is false. From GitLab 15.1, can only be enabled when delayed_group_deletion is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#delayed_project_deletion ApplicationSettings#delayed_project_deletion}
    */
    readonly delayedProjectDeletion?: boolean | cdktf.IResolvable;
    /**
    * Enable inactive project deletion feature. Default is false. Introduced in GitLab 14.10. Became operational in GitLab 15.0 (with feature flag inactive_projects_deletion, disabled by default).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#delete_inactive_projects ApplicationSettings#delete_inactive_projects}
    */
    readonly deleteInactiveProjects?: boolean | cdktf.IResolvable;
    /**
    * The number of days to wait before deleting a project or group that is marked for deletion. Value must be between 1 and 90. Defaults to 7. From GitLab 15.1, a hook on deletion_adjourned_period sets the period to 1 on every update, and sets both delayed_project_deletion and delayed_group_deletion to false if the period is 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#deletion_adjourned_period ApplicationSettings#deletion_adjourned_period}
    */
    readonly deletionAdjournedPeriod?: number;
    /**
    * Maximum files in a diff.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#diff_max_files ApplicationSettings#diff_max_files}
    */
    readonly diffMaxFiles?: number;
    /**
    * Maximum lines in a diff.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#diff_max_lines ApplicationSettings#diff_max_lines}
    */
    readonly diffMaxLines?: number;
    /**
    * Maximum diff patch size, in bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#diff_max_patch_bytes ApplicationSettings#diff_max_patch_bytes}
    */
    readonly diffMaxPatchBytes?: number;
    /**
    * Disable display of RSS/Atom and calendar feed tokens (introduced in GitLab 13.7).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#disable_feed_token ApplicationSettings#disable_feed_token}
    */
    readonly disableFeedToken?: boolean | cdktf.IResolvable;
    /**
    * Disabled OAuth sign-in sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#disabled_oauth_sign_in_sources ApplicationSettings#disabled_oauth_sign_in_sources}
    */
    readonly disabledOauthSignInSources?: string[];
    /**
    * Enforce DNS rebinding attack protection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#dns_rebinding_protection_enabled ApplicationSettings#dns_rebinding_protection_enabled}
    */
    readonly dnsRebindingProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Force people to use only corporate emails for sign-up. Default is null, meaning there is no restriction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#domain_allowlist ApplicationSettings#domain_allowlist}
    */
    readonly domainAllowlist?: string[];
    /**
    * Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#domain_denylist ApplicationSettings#domain_denylist}
    */
    readonly domainDenylist?: string[];
    /**
    * (If enabled, requires: domain_denylist) Allows blocking sign-ups from emails from specific domains.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#domain_denylist_enabled ApplicationSettings#domain_denylist_enabled}
    */
    readonly domainDenylistEnabled?: boolean | cdktf.IResolvable;
    /**
    * The minimum allowed bit length of an uploaded DSA key. Default is 0 (no restriction). -1 disables DSA keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#dsa_key_restriction ApplicationSettings#dsa_key_restriction}
    */
    readonly dsaKeyRestriction?: number;
    /**
    * The minimum allowed curve size (in bits) of an uploaded ECDSA key. Default is 0 (no restriction). -1 disables ECDSA keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#ecdsa_key_restriction ApplicationSettings#ecdsa_key_restriction}
    */
    readonly ecdsaKeyRestriction?: number;
    /**
    * The minimum allowed curve size (in bits) of an uploaded ECDSA_SK key. Default is 0 (no restriction). -1 disables ECDSA_SK keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#ecdsa_sk_key_restriction ApplicationSettings#ecdsa_sk_key_restriction}
    */
    readonly ecdsaSkKeyRestriction?: number;
    /**
    * The minimum allowed curve size (in bits) of an uploaded ED25519 key. Default is 0 (no restriction). -1 disables ED25519 keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#ed25519_key_restriction ApplicationSettings#ed25519_key_restriction}
    */
    readonly ed25519KeyRestriction?: number;
    /**
    * The minimum allowed curve size (in bits) of an uploaded ED25519_SK key. Default is 0 (no restriction). -1 disables ED25519_SK keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#ed25519_sk_key_restriction ApplicationSettings#ed25519_sk_key_restriction}
    */
    readonly ed25519SkKeyRestriction?: number;
    /**
    * AWS IAM access key ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#eks_access_key_id ApplicationSettings#eks_access_key_id}
    */
    readonly eksAccessKeyId?: string;
    /**
    * Amazon account ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#eks_account_id ApplicationSettings#eks_account_id}
    */
    readonly eksAccountId?: string;
    /**
    * Enable integration with Amazon EKS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#eks_integration_enabled ApplicationSettings#eks_integration_enabled}
    */
    readonly eksIntegrationEnabled?: boolean | cdktf.IResolvable;
    /**
    * AWS IAM secret access key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#eks_secret_access_key ApplicationSettings#eks_secret_access_key}
    */
    readonly eksSecretAccessKey?: string;
    /**
    * Enable the use of AWS hosted Elasticsearch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_aws ApplicationSettings#elasticsearch_aws}
    */
    readonly elasticsearchAws?: boolean | cdktf.IResolvable;
    /**
    * AWS IAM access key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_aws_access_key ApplicationSettings#elasticsearch_aws_access_key}
    */
    readonly elasticsearchAwsAccessKey?: string;
    /**
    * The AWS region the Elasticsearch domain is configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_aws_region ApplicationSettings#elasticsearch_aws_region}
    */
    readonly elasticsearchAwsRegion?: string;
    /**
    * AWS IAM secret access key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_aws_secret_access_key ApplicationSettings#elasticsearch_aws_secret_access_key}
    */
    readonly elasticsearchAwsSecretAccessKey?: string;
    /**
    * Maximum size of text fields to index by Elasticsearch. 0 value means no limit. This does not apply to repository and wiki indexing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_indexed_field_length_limit ApplicationSettings#elasticsearch_indexed_field_length_limit}
    */
    readonly elasticsearchIndexedFieldLengthLimit?: number;
    /**
    * Maximum size of repository and wiki files that are indexed by Elasticsearch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_indexed_file_size_limit_kb ApplicationSettings#elasticsearch_indexed_file_size_limit_kb}
    */
    readonly elasticsearchIndexedFileSizeLimitKb?: number;
    /**
    * Enable Elasticsearch indexing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_indexing ApplicationSettings#elasticsearch_indexing}
    */
    readonly elasticsearchIndexing?: boolean | cdktf.IResolvable;
    /**
    * Limit Elasticsearch to index certain namespaces and projects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_limit_indexing ApplicationSettings#elasticsearch_limit_indexing}
    */
    readonly elasticsearchLimitIndexing?: boolean | cdktf.IResolvable;
    /**
    * Maximum concurrency of Elasticsearch bulk requests per indexing operation. This only applies to repository indexing operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_max_bulk_concurrency ApplicationSettings#elasticsearch_max_bulk_concurrency}
    */
    readonly elasticsearchMaxBulkConcurrency?: number;
    /**
    * Maximum size of Elasticsearch bulk indexing requests in MB. This only applies to repository indexing operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_max_bulk_size_mb ApplicationSettings#elasticsearch_max_bulk_size_mb}
    */
    readonly elasticsearchMaxBulkSizeMb?: number;
    /**
    * The namespaces to index via Elasticsearch if elasticsearch_limit_indexing is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_namespace_ids ApplicationSettings#elasticsearch_namespace_ids}
    */
    readonly elasticsearchNamespaceIds?: string[];
    /**
    * The password of your Elasticsearch instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_password ApplicationSettings#elasticsearch_password}
    */
    readonly elasticsearchPassword?: string;
    /**
    * The projects to index via Elasticsearch if elasticsearch_limit_indexing is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_project_ids ApplicationSettings#elasticsearch_project_ids}
    */
    readonly elasticsearchProjectIds?: string[];
    /**
    * Enable Elasticsearch search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_search ApplicationSettings#elasticsearch_search}
    */
    readonly elasticsearchSearch?: boolean | cdktf.IResolvable;
    /**
    * The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_url ApplicationSettings#elasticsearch_url}
    */
    readonly elasticsearchUrl?: string[];
    /**
    * The username of your Elasticsearch instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#elasticsearch_username ApplicationSettings#elasticsearch_username}
    */
    readonly elasticsearchUsername?: string;
    /**
    * Additional text added to the bottom of every email for legal/auditing/compliance reasons.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#email_additional_text ApplicationSettings#email_additional_text}
    */
    readonly emailAdditionalText?: string;
    /**
    * Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#email_author_in_body ApplicationSettings#email_author_in_body}
    */
    readonly emailAuthorInBody?: boolean | cdktf.IResolvable;
    /**
    * Enabled protocols for Git access. Allowed values are: ssh, http, and nil to allow both protocols.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#enabled_git_access_protocol ApplicationSettings#enabled_git_access_protocol}
    */
    readonly enabledGitAccessProtocol?: string;
    /**
    * Enabling this permits enforcement of namespace storage limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#enforce_namespace_storage_limit ApplicationSettings#enforce_namespace_storage_limit}
    */
    readonly enforceNamespaceStorageLimit?: boolean | cdktf.IResolvable;
    /**
    * (If enabled, requires: terms) Enforce application ToS to all users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#enforce_terms ApplicationSettings#enforce_terms}
    */
    readonly enforceTerms?: boolean | cdktf.IResolvable;
    /**
    * (If enabled, requires: external_auth_client_key) The certificate to use to authenticate with the external authorization service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_auth_client_cert ApplicationSettings#external_auth_client_cert}
    */
    readonly externalAuthClientCert?: string;
    /**
    * Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_auth_client_key ApplicationSettings#external_auth_client_key}
    */
    readonly externalAuthClientKey?: string;
    /**
    * Passphrase to use for the private key when authenticating with the external service this is encrypted when stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_auth_client_key_pass ApplicationSettings#external_auth_client_key_pass}
    */
    readonly externalAuthClientKeyPass?: string;
    /**
    * The default classification label to use when requesting authorization and no classification label has been specified on the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_authorization_service_default_label ApplicationSettings#external_authorization_service_default_label}
    */
    readonly externalAuthorizationServiceDefaultLabel?: string;
    /**
    * (If enabled, requires: external_authorization_service_default_label, external_authorization_service_timeout and external_authorization_service_url) Enable using an external authorization service for accessing projects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_authorization_service_enabled ApplicationSettings#external_authorization_service_enabled}
    */
    readonly externalAuthorizationServiceEnabled?: boolean | cdktf.IResolvable;
    /**
    * The timeout after which an authorization request is aborted, in seconds. When a request times out, access is denied to the user. (min: 0.001, max: 10, step: 0.001).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_authorization_service_timeout ApplicationSettings#external_authorization_service_timeout}
    */
    readonly externalAuthorizationServiceTimeout?: number;
    /**
    * URL to which authorization requests are directed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_authorization_service_url ApplicationSettings#external_authorization_service_url}
    */
    readonly externalAuthorizationServiceUrl?: string;
    /**
    * How long to wait for a response from the pipeline validation service. Assumes OK if it times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_pipeline_validation_service_timeout ApplicationSettings#external_pipeline_validation_service_timeout}
    */
    readonly externalPipelineValidationServiceTimeout?: number;
    /**
    * Optional. Token to include as the X-Gitlab-Token header in requests to the URL in external_pipeline_validation_service_url.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_pipeline_validation_service_token ApplicationSettings#external_pipeline_validation_service_token}
    */
    readonly externalPipelineValidationServiceToken?: string;
    /**
    * URL to use for pipeline validation requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#external_pipeline_validation_service_url ApplicationSettings#external_pipeline_validation_service_url}
    */
    readonly externalPipelineValidationServiceUrl?: string;
    /**
    * The ID of a project to load custom file templates from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#file_template_project_id ApplicationSettings#file_template_project_id}
    */
    readonly fileTemplateProjectId?: number;
    /**
    * Start day of the week for calendar views and date pickers. Valid values are 0 (default) for Sunday, 1 for Monday, and 6 for Saturday.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#first_day_of_week ApplicationSettings#first_day_of_week}
    */
    readonly firstDayOfWeek?: number;
    /**
    * Comma-separated list of IPs and CIDRs of allowed secondary nodes. For example, 1.1.1.1, 2.2.2.0/24.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#geo_node_allowed_ips ApplicationSettings#geo_node_allowed_ips}
    */
    readonly geoNodeAllowedIps?: string;
    /**
    * The amount of seconds after which a request to get a secondary node status times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#geo_status_timeout ApplicationSettings#geo_status_timeout}
    */
    readonly geoStatusTimeout?: number;
    /**
    * List of usernames excluded from Git anti-abuse rate limits. Default: [], Maximum: 100 usernames. Introduced in GitLab 15.2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#git_rate_limit_users_allowlist ApplicationSettings#git_rate_limit_users_allowlist}
    */
    readonly gitRateLimitUsersAllowlist?: string[];
    /**
    * Maximum duration (in minutes) of a session for Git operations when 2FA is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#git_two_factor_session_expiry ApplicationSettings#git_two_factor_session_expiry}
    */
    readonly gitTwoFactorSessionExpiry?: number;
    /**
    * Default Gitaly timeout, in seconds. This timeout is not enforced for Git fetch/push operations or Sidekiq jobs. Set to 0 to disable timeouts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#gitaly_timeout_default ApplicationSettings#gitaly_timeout_default}
    */
    readonly gitalyTimeoutDefault?: number;
    /**
    * Gitaly fast operation timeout, in seconds. Some Gitaly operations are expected to be fast. If they exceed this threshold, there may be a problem with a storage shard and ‘failing fast’ can help maintain the stability of the GitLab instance. Set to 0 to disable timeouts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#gitaly_timeout_fast ApplicationSettings#gitaly_timeout_fast}
    */
    readonly gitalyTimeoutFast?: number;
    /**
    * Medium Gitaly timeout, in seconds. This should be a value between the Fast and the Default timeout. Set to 0 to disable timeouts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#gitaly_timeout_medium ApplicationSettings#gitaly_timeout_medium}
    */
    readonly gitalyTimeoutMedium?: number;
    /**
    * Enable Grafana.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#grafana_enabled ApplicationSettings#grafana_enabled}
    */
    readonly grafanaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Grafana URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#grafana_url ApplicationSettings#grafana_url}
    */
    readonly grafanaUrl?: string;
    /**
    * Enable Gravatar.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#gravatar_enabled ApplicationSettings#gravatar_enabled}
    */
    readonly gravatarEnabled?: boolean | cdktf.IResolvable;
    /**
    * Prevent overrides of default branch protection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#group_owners_can_manage_default_branch_protection ApplicationSettings#group_owners_can_manage_default_branch_protection}
    */
    readonly groupOwnersCanManageDefaultBranchProtection?: boolean | cdktf.IResolvable;
    /**
    * Create new projects using hashed storage paths: Enable immutable, hash-based paths and repository names to store repositories on disk. This prevents repositories from having to be moved or renamed when the Project URL changes and may improve disk I/O performance. (Always enabled in GitLab versions 13.0 and later, configuration is scheduled for removal in 14.0).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#hashed_storage_enabled ApplicationSettings#hashed_storage_enabled}
    */
    readonly hashedStorageEnabled?: boolean | cdktf.IResolvable;
    /**
    * Hide marketing-related entries from help.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#help_page_hide_commercial_content ApplicationSettings#help_page_hide_commercial_content}
    */
    readonly helpPageHideCommercialContent?: boolean | cdktf.IResolvable;
    /**
    * Alternate support URL for help page and help dropdown.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#help_page_support_url ApplicationSettings#help_page_support_url}
    */
    readonly helpPageSupportUrl?: string;
    /**
    * Custom text displayed on the help page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#help_page_text ApplicationSettings#help_page_text}
    */
    readonly helpPageText?: string;
    /**
    * GitLab server administrator information.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#help_text ApplicationSettings#help_text}
    */
    readonly helpText?: string;
    /**
    * Do not display offers from third parties in GitLab.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#hide_third_party_offers ApplicationSettings#hide_third_party_offers}
    */
    readonly hideThirdPartyOffers?: boolean | cdktf.IResolvable;
    /**
    * Redirect to this URL when not logged in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#home_page_url ApplicationSettings#home_page_url}
    */
    readonly homePageUrl?: string;
    /**
    * (If enabled, requires: housekeeping_bitmaps_enabled, housekeeping_full_repack_period, housekeeping_gc_period, and housekeeping_incremental_repack_period) Enable or disable Git housekeeping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#housekeeping_enabled ApplicationSettings#housekeeping_enabled}
    */
    readonly housekeepingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Number of Git pushes after which an incremental git repack is run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#housekeeping_full_repack_period ApplicationSettings#housekeeping_full_repack_period}
    */
    readonly housekeepingFullRepackPeriod?: number;
    /**
    * Number of Git pushes after which git gc is run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#housekeeping_gc_period ApplicationSettings#housekeeping_gc_period}
    */
    readonly housekeepingGcPeriod?: number;
    /**
    * Number of Git pushes after which an incremental git repack is run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#housekeeping_incremental_repack_period ApplicationSettings#housekeeping_incremental_repack_period}
    */
    readonly housekeepingIncrementalRepackPeriod?: number;
    /**
    * Enable HTML emails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#html_emails_enabled ApplicationSettings#html_emails_enabled}
    */
    readonly htmlEmailsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#id ApplicationSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Sources to allow project import from, possible values: github, bitbucket, bitbucket_server, gitlab, fogbugz, git, gitlab_project, gitea, manifest, and phabricator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#import_sources ApplicationSettings#import_sources}
    */
    readonly importSources?: string[];
    /**
    * Enable in-product marketing emails. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#in_product_marketing_emails_enabled ApplicationSettings#in_product_marketing_emails_enabled}
    */
    readonly inProductMarketingEmailsEnabled?: boolean | cdktf.IResolvable;
    /**
    * If delete_inactive_projects is true, the time (in months) to wait before deleting inactive projects. Default is 2. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#inactive_projects_delete_after_months ApplicationSettings#inactive_projects_delete_after_months}
    */
    readonly inactiveProjectsDeleteAfterMonths?: number;
    /**
    * If delete_inactive_projects is true, the minimum repository size for projects to be checked for inactivity. Default is 0. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#inactive_projects_min_size_mb ApplicationSettings#inactive_projects_min_size_mb}
    */
    readonly inactiveProjectsMinSizeMb?: number;
    /**
    * If delete_inactive_projects is true, sets the time (in months) to wait before emailing maintainers that the project is scheduled be deleted because it is inactive. Default is 1. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#inactive_projects_send_warning_email_after_months ApplicationSettings#inactive_projects_send_warning_email_after_months}
    */
    readonly inactiveProjectsSendWarningEmailAfterMonths?: number;
    /**
    * Enable Invisible CAPTCHA spam detection during sign-up. Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#invisible_captcha_enabled ApplicationSettings#invisible_captcha_enabled}
    */
    readonly invisibleCaptchaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Max number of issue creation requests per minute per user. Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#issues_create_limit ApplicationSettings#issues_create_limit}
    */
    readonly issuesCreateLimit?: number;
    /**
    * Prevent the deletion of the artifacts from the most recent successful jobs, regardless of the expiry time. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#keep_latest_artifact ApplicationSettings#keep_latest_artifact}
    */
    readonly keepLatestArtifact?: boolean | cdktf.IResolvable;
    /**
    * Increase this value when any cached Markdown should be invalidated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#local_markdown_version ApplicationSettings#local_markdown_version}
    */
    readonly localMarkdownVersion?: number;
    /**
    * Enable Mailgun event receiver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mailgun_events_enabled ApplicationSettings#mailgun_events_enabled}
    */
    readonly mailgunEventsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The Mailgun HTTP webhook signing key for receiving events from webhook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mailgun_signing_key ApplicationSettings#mailgun_signing_key}
    */
    readonly mailgunSigningKey?: string;
    /**
    * When instance is in maintenance mode, non-administrative users can sign in with read-only access and make read-only API requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#maintenance_mode ApplicationSettings#maintenance_mode}
    */
    readonly maintenanceMode?: boolean | cdktf.IResolvable;
    /**
    * Message displayed when instance is in maintenance mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#maintenance_mode_message ApplicationSettings#maintenance_mode_message}
    */
    readonly maintenanceModeMessage?: string;
    /**
    * Maximum artifacts size in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_artifacts_size ApplicationSettings#max_artifacts_size}
    */
    readonly maxArtifactsSize?: number;
    /**
    * Limit attachment size in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_attachment_size ApplicationSettings#max_attachment_size}
    */
    readonly maxAttachmentSize?: number;
    /**
    * Maximum export size in MB. 0 for unlimited. Default = 0 (unlimited).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_export_size ApplicationSettings#max_export_size}
    */
    readonly maxExportSize?: number;
    /**
    * Maximum import size in MB. 0 for unlimited. Default = 0 (unlimited) Modified from 50MB to 0 in GitLab 13.8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_import_size ApplicationSettings#max_import_size}
    */
    readonly maxImportSize?: number;
    /**
    * Maximum number of unique repositories a user can download in the specified time period before they are banned. Default: 0, Maximum: 10,000 repositories. Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_number_of_repository_downloads ApplicationSettings#max_number_of_repository_downloads}
    */
    readonly maxNumberOfRepositoryDownloads?: number;
    /**
    * Reporting time period (in seconds). Default: 0, Maximum: 864000 seconds (10 days). Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_number_of_repository_downloads_within_time_period ApplicationSettings#max_number_of_repository_downloads_within_time_period}
    */
    readonly maxNumberOfRepositoryDownloadsWithinTimePeriod?: number;
    /**
    * Maximum size of pages repositories in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_pages_size ApplicationSettings#max_pages_size}
    */
    readonly maxPagesSize?: number;
    /**
    * Maximum allowable lifetime for access tokens in days.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_personal_access_token_lifetime ApplicationSettings#max_personal_access_token_lifetime}
    */
    readonly maxPersonalAccessTokenLifetime?: number;
    /**
    * Maximum allowable lifetime for SSH keys in days. Introduced in GitLab 14.6.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#max_ssh_key_lifetime ApplicationSettings#max_ssh_key_lifetime}
    */
    readonly maxSshKeyLifetime?: number;
    /**
    * A method call is only tracked when it takes longer than the given amount of milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#metrics_method_call_threshold ApplicationSettings#metrics_method_call_threshold}
    */
    readonly metricsMethodCallThreshold?: number;
    /**
    * Allow repository mirroring to configured by project Maintainers. If disabled, only Administrators can configure repository mirroring.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mirror_available ApplicationSettings#mirror_available}
    */
    readonly mirrorAvailable?: boolean | cdktf.IResolvable;
    /**
    * Minimum capacity to be available before scheduling more mirrors preemptively.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mirror_capacity_threshold ApplicationSettings#mirror_capacity_threshold}
    */
    readonly mirrorCapacityThreshold?: number;
    /**
    * Maximum number of mirrors that can be synchronizing at the same time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mirror_max_capacity ApplicationSettings#mirror_max_capacity}
    */
    readonly mirrorMaxCapacity?: number;
    /**
    * Maximum time (in minutes) between updates that a mirror can have when scheduled to synchronize.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#mirror_max_delay ApplicationSettings#mirror_max_delay}
    */
    readonly mirrorMaxDelay?: number;
    /**
    * Use npmjs.org as a default remote repository when the package is not found in the GitLab Package Registry for npm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#npm_package_requests_forwarding ApplicationSettings#npm_package_requests_forwarding}
    */
    readonly npmPackageRequestsForwarding?: boolean | cdktf.IResolvable;
    /**
    * Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#outbound_local_requests_whitelist ApplicationSettings#outbound_local_requests_whitelist}
    */
    readonly outboundLocalRequestsWhitelist?: string[];
    /**
    * Number of workers assigned to the packages cleanup policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#package_registry_cleanup_policies_worker_capacity ApplicationSettings#package_registry_cleanup_policies_worker_capacity}
    */
    readonly packageRegistryCleanupPoliciesWorkerCapacity?: number;
    /**
    * Require users to prove ownership of custom domains. Domain verification is an essential security measure for public GitLab sites. Users are required to demonstrate they control a domain before it is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#pages_domain_verification_enabled ApplicationSettings#pages_domain_verification_enabled}
    */
    readonly pagesDomainVerificationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable authentication for Git over HTTP(S) via a GitLab account password. Default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_authentication_enabled_for_git ApplicationSettings#password_authentication_enabled_for_git}
    */
    readonly passwordAuthenticationEnabledForGit?: boolean | cdktf.IResolvable;
    /**
    * Enable authentication for the web interface via a GitLab account password. Default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_authentication_enabled_for_web ApplicationSettings#password_authentication_enabled_for_web}
    */
    readonly passwordAuthenticationEnabledForWeb?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether passwords require at least one lowercase letter. Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_lowercase_required ApplicationSettings#password_lowercase_required}
    */
    readonly passwordLowercaseRequired?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether passwords require at least one number. Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_number_required ApplicationSettings#password_number_required}
    */
    readonly passwordNumberRequired?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether passwords require at least one symbol character. Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_symbol_required ApplicationSettings#password_symbol_required}
    */
    readonly passwordSymbolRequired?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether passwords require at least one uppercase letter. Introduced in GitLab 15.1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#password_uppercase_required ApplicationSettings#password_uppercase_required}
    */
    readonly passwordUppercaseRequired?: boolean | cdktf.IResolvable;
    /**
    * Path of the group that is allowed to toggle the performance bar.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#performance_bar_allowed_group_path ApplicationSettings#performance_bar_allowed_group_path}
    */
    readonly performanceBarAllowedGroupPath?: string;
    /**
    * Prefix for all generated personal access tokens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#personal_access_token_prefix ApplicationSettings#personal_access_token_prefix}
    */
    readonly personalAccessTokenPrefix?: string;
    /**
    * Maximum number of pipeline creation requests per minute per user and commit. Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#pipeline_limit_per_project_user_sha ApplicationSettings#pipeline_limit_per_project_user_sha}
    */
    readonly pipelineLimitPerProjectUserSha?: number;
    /**
    * (If enabled, requires: plantuml_url) Enable PlantUML integration. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#plantuml_enabled ApplicationSettings#plantuml_enabled}
    */
    readonly plantumlEnabled?: boolean | cdktf.IResolvable;
    /**
    * The PlantUML instance URL for integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#plantuml_url ApplicationSettings#plantuml_url}
    */
    readonly plantumlUrl?: string;
    /**
    * Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#polling_interval_multiplier ApplicationSettings#polling_interval_multiplier}
    */
    readonly pollingIntervalMultiplier?: number;
    /**
    * Enable project export.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#project_export_enabled ApplicationSettings#project_export_enabled}
    */
    readonly projectExportEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable Prometheus metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#prometheus_metrics_enabled ApplicationSettings#prometheus_metrics_enabled}
    */
    readonly prometheusMetricsEnabled?: boolean | cdktf.IResolvable;
    /**
    * CI/CD variables are protected by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#protected_ci_variables ApplicationSettings#protected_ci_variables}
    */
    readonly protectedCiVariables?: boolean | cdktf.IResolvable;
    /**
    * Number of changes (branches or tags) in a single push to determine whether individual push events or bulk push events are created. Bulk push events are created if it surpasses that value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#push_event_activities_limit ApplicationSettings#push_event_activities_limit}
    */
    readonly pushEventActivitiesLimit?: number;
    /**
    * Number of changes (branches or tags) in a single push to determine whether webhooks and services fire or not. Webhooks and services aren’t submitted if it surpasses that value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#push_event_hooks_limit ApplicationSettings#push_event_hooks_limit}
    */
    readonly pushEventHooksLimit?: number;
    /**
    * Use pypi.org as a default remote repository when the package is not found in the GitLab Package Registry for PyPI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#pypi_package_requests_forwarding ApplicationSettings#pypi_package_requests_forwarding}
    */
    readonly pypiPackageRequestsForwarding?: boolean | cdktf.IResolvable;
    /**
    * When rate limiting is enabled via the throttle_* settings, send this plain text response when a rate limit is exceeded. ‘Retry later’ is sent if this is blank.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#rate_limiting_response_text ApplicationSettings#rate_limiting_response_text}
    */
    readonly rateLimitingResponseText?: string;
    /**
    * Max number of requests per minute for each raw path. Default: 300. To disable throttling set to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#raw_blob_request_limit ApplicationSettings#raw_blob_request_limit}
    */
    readonly rawBlobRequestLimit?: number;
    /**
    * (If enabled, requires: recaptcha_private_key and recaptcha_site_key) Enable reCAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#recaptcha_enabled ApplicationSettings#recaptcha_enabled}
    */
    readonly recaptchaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Private key for reCAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#recaptcha_private_key ApplicationSettings#recaptcha_private_key}
    */
    readonly recaptchaPrivateKey?: string;
    /**
    * Site key for reCAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#recaptcha_site_key ApplicationSettings#recaptcha_site_key}
    */
    readonly recaptchaSiteKey?: string;
    /**
    * Maximum push size (MB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#receive_max_input_size ApplicationSettings#receive_max_input_size}
    */
    readonly receiveMaxInputSize?: number;
    /**
    * GitLab periodically runs git fsck in all project and wiki repositories to look for silent disk corruption issues.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#repository_checks_enabled ApplicationSettings#repository_checks_enabled}
    */
    readonly repositoryChecksEnabled?: boolean | cdktf.IResolvable;
    /**
    * Size limit per repository (MB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#repository_size_limit ApplicationSettings#repository_size_limit}
    */
    readonly repositorySizeLimit?: number;
    /**
    * (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#repository_storages ApplicationSettings#repository_storages}
    */
    readonly repositoryStorages?: string[];
    /**
    * (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#repository_storages_weighted ApplicationSettings#repository_storages_weighted}
    */
    readonly repositoryStoragesWeighted?: {
        [key: string]: number;
    };
    /**
    * When enabled, any user that signs up for an account using the registration form is placed under a Pending approval state and has to be explicitly approved by an administrator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#require_admin_approval_after_user_signup ApplicationSettings#require_admin_approval_after_user_signup}
    */
    readonly requireAdminApprovalAfterUserSignup?: boolean | cdktf.IResolvable;
    /**
    * (If enabled, requires: two_factor_grace_period) Require all users to set up Two-factor authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#require_two_factor_authentication ApplicationSettings#require_two_factor_authentication}
    */
    readonly requireTwoFactorAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Default is null which means there is no restriction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#restricted_visibility_levels ApplicationSettings#restricted_visibility_levels}
    */
    readonly restrictedVisibilityLevels?: string[];
    /**
    * The minimum allowed bit length of an uploaded RSA key. Default is 0 (no restriction). -1 disables RSA keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#rsa_key_restriction ApplicationSettings#rsa_key_restriction}
    */
    readonly rsaKeyRestriction?: number;
    /**
    * Max number of requests per minute for performing a search while authenticated. Default: 30. To disable throttling set to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#search_rate_limit ApplicationSettings#search_rate_limit}
    */
    readonly searchRateLimit?: number;
    /**
    * Max number of requests per minute for performing a search while unauthenticated. Default: 10. To disable throttling set to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#search_rate_limit_unauthenticated ApplicationSettings#search_rate_limit_unauthenticated}
    */
    readonly searchRateLimitUnauthenticated?: number;
    /**
    * Send confirmation email on sign-up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#send_user_confirmation_email ApplicationSettings#send_user_confirmation_email}
    */
    readonly sendUserConfirmationEmail?: boolean | cdktf.IResolvable;
    /**
    * Session duration in minutes. GitLab restart is required to apply changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#session_expire_delay ApplicationSettings#session_expire_delay}
    */
    readonly sessionExpireDelay?: number;
    /**
    * (If enabled, requires: shared_runners_text and shared_runners_minutes) Enable shared runners for new projects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#shared_runners_enabled ApplicationSettings#shared_runners_enabled}
    */
    readonly sharedRunnersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set the maximum number of CI/CD minutes that a group can use on shared runners per month.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#shared_runners_minutes ApplicationSettings#shared_runners_minutes}
    */
    readonly sharedRunnersMinutes?: number;
    /**
    * Shared runners text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#shared_runners_text ApplicationSettings#shared_runners_text}
    */
    readonly sharedRunnersText?: string;
    /**
    * The threshold in bytes at which Sidekiq jobs are compressed before being stored in Redis. Default: 100 000 bytes (100KB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sidekiq_job_limiter_compression_threshold_bytes ApplicationSettings#sidekiq_job_limiter_compression_threshold_bytes}
    */
    readonly sidekiqJobLimiterCompressionThresholdBytes?: number;
    /**
    * The threshold in bytes at which Sidekiq jobs are rejected. Default: 0 bytes (doesn’t reject any job).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sidekiq_job_limiter_limit_bytes ApplicationSettings#sidekiq_job_limiter_limit_bytes}
    */
    readonly sidekiqJobLimiterLimitBytes?: number;
    /**
    * track or compress. Sets the behavior for Sidekiq job size limits. Default: ‘compress’.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sidekiq_job_limiter_mode ApplicationSettings#sidekiq_job_limiter_mode}
    */
    readonly sidekiqJobLimiterMode?: string;
    /**
    * Text on the login page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sign_in_text ApplicationSettings#sign_in_text}
    */
    readonly signInText?: string;
    /**
    * Enable registration. Default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#signup_enabled ApplicationSettings#signup_enabled}
    */
    readonly signupEnabled?: boolean | cdktf.IResolvable;
    /**
    * (If enabled, requires: slack_app_id, slack_app_secret and slack_app_secret) Enable Slack app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#slack_app_enabled ApplicationSettings#slack_app_enabled}
    */
    readonly slackAppEnabled?: boolean | cdktf.IResolvable;
    /**
    * The app ID of the Slack-app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#slack_app_id ApplicationSettings#slack_app_id}
    */
    readonly slackAppId?: string;
    /**
    * The app secret of the Slack-app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#slack_app_secret ApplicationSettings#slack_app_secret}
    */
    readonly slackAppSecret?: string;
    /**
    * The signing secret of the Slack-app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#slack_app_signing_secret ApplicationSettings#slack_app_signing_secret}
    */
    readonly slackAppSigningSecret?: string;
    /**
    * The verification token of the Slack-app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#slack_app_verification_token ApplicationSettings#slack_app_verification_token}
    */
    readonly slackAppVerificationToken?: string;
    /**
    * Max snippet content size in bytes. Default: 52428800 Bytes (50MB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#snippet_size_limit ApplicationSettings#snippet_size_limit}
    */
    readonly snippetSizeLimit?: number;
    /**
    * The Snowplow site name / application ID. (for example, gitlab)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#snowplow_app_id ApplicationSettings#snowplow_app_id}
    */
    readonly snowplowAppId?: string;
    /**
    * The Snowplow collector hostname. (for example, snowplow.trx.gitlab.net)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#snowplow_collector_hostname ApplicationSettings#snowplow_collector_hostname}
    */
    readonly snowplowCollectorHostname?: string;
    /**
    * The Snowplow cookie domain. (for example, .gitlab.com)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#snowplow_cookie_domain ApplicationSettings#snowplow_cookie_domain}
    */
    readonly snowplowCookieDomain?: string;
    /**
    * Enable snowplow tracking.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#snowplow_enabled ApplicationSettings#snowplow_enabled}
    */
    readonly snowplowEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables Sourcegraph integration. Default is false. If enabled, requires sourcegraph_url.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sourcegraph_enabled ApplicationSettings#sourcegraph_enabled}
    */
    readonly sourcegraphEnabled?: boolean | cdktf.IResolvable;
    /**
    * Blocks Sourcegraph from being loaded on private and internal projects. Default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sourcegraph_public_only ApplicationSettings#sourcegraph_public_only}
    */
    readonly sourcegraphPublicOnly?: boolean | cdktf.IResolvable;
    /**
    * The Sourcegraph instance URL for integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#sourcegraph_url ApplicationSettings#sourcegraph_url}
    */
    readonly sourcegraphUrl?: string;
    /**
    * API key used by GitLab for accessing the Spam Check service endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#spam_check_api_key ApplicationSettings#spam_check_api_key}
    */
    readonly spamCheckApiKey?: string;
    /**
    * Enables spam checking using external Spam Check API endpoint. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#spam_check_endpoint_enabled ApplicationSettings#spam_check_endpoint_enabled}
    */
    readonly spamCheckEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * URL of the external Spamcheck service endpoint. Valid URI schemes are grpc or tls. Specifying tls forces communication to be encrypted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#spam_check_endpoint_url ApplicationSettings#spam_check_endpoint_url}
    */
    readonly spamCheckEndpointUrl?: string;
    /**
    * Enable pipeline suggestion banner.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#suggest_pipeline_enabled ApplicationSettings#suggest_pipeline_enabled}
    */
    readonly suggestPipelineEnabled?: boolean | cdktf.IResolvable;
    /**
    * Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#terminal_max_session_time ApplicationSettings#terminal_max_session_time}
    */
    readonly terminalMaxSessionTime?: number;
    /**
    * (Required by: enforce_terms) Markdown content for the ToS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#terms ApplicationSettings#terms}
    */
    readonly terms?: string;
    /**
    * (If enabled, requires: throttle_authenticated_api_period_in_seconds and throttle_authenticated_api_requests_per_period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_api_enabled ApplicationSettings#throttle_authenticated_api_enabled}
    */
    readonly throttleAuthenticatedApiEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period (in seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_api_period_in_seconds ApplicationSettings#throttle_authenticated_api_period_in_seconds}
    */
    readonly throttleAuthenticatedApiPeriodInSeconds?: number;
    /**
    * Maximum requests per period per user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_api_requests_per_period ApplicationSettings#throttle_authenticated_api_requests_per_period}
    */
    readonly throttleAuthenticatedApiRequestsPerPeriod?: number;
    /**
    * (If enabled, requires: throttle_authenticated_packages_api_period_in_seconds and throttle_authenticated_packages_api_requests_per_period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_packages_api_enabled ApplicationSettings#throttle_authenticated_packages_api_enabled}
    */
    readonly throttleAuthenticatedPackagesApiEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period (in seconds). View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_packages_api_period_in_seconds ApplicationSettings#throttle_authenticated_packages_api_period_in_seconds}
    */
    readonly throttleAuthenticatedPackagesApiPeriodInSeconds?: number;
    /**
    * Maximum requests per period per user. View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_packages_api_requests_per_period ApplicationSettings#throttle_authenticated_packages_api_requests_per_period}
    */
    readonly throttleAuthenticatedPackagesApiRequestsPerPeriod?: number;
    /**
    * (If enabled, requires: throttle_authenticated_web_period_in_seconds and throttle_authenticated_web_requests_per_period) Enable authenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_web_enabled ApplicationSettings#throttle_authenticated_web_enabled}
    */
    readonly throttleAuthenticatedWebEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period (in seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_web_period_in_seconds ApplicationSettings#throttle_authenticated_web_period_in_seconds}
    */
    readonly throttleAuthenticatedWebPeriodInSeconds?: number;
    /**
    * Maximum requests per period per user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_authenticated_web_requests_per_period ApplicationSettings#throttle_authenticated_web_requests_per_period}
    */
    readonly throttleAuthenticatedWebRequestsPerPeriod?: number;
    /**
    * (If enabled, requires: throttle_unauthenticated_api_period_in_seconds and throttle_unauthenticated_api_requests_per_period) Enable unauthenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_api_enabled ApplicationSettings#throttle_unauthenticated_api_enabled}
    */
    readonly throttleUnauthenticatedApiEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_api_period_in_seconds ApplicationSettings#throttle_unauthenticated_api_period_in_seconds}
    */
    readonly throttleUnauthenticatedApiPeriodInSeconds?: number;
    /**
    * Max requests per period per IP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_api_requests_per_period ApplicationSettings#throttle_unauthenticated_api_requests_per_period}
    */
    readonly throttleUnauthenticatedApiRequestsPerPeriod?: number;
    /**
    * (If enabled, requires: throttle_unauthenticated_packages_api_period_in_seconds and throttle_unauthenticated_packages_api_requests_per_period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_packages_api_enabled ApplicationSettings#throttle_unauthenticated_packages_api_enabled}
    */
    readonly throttleUnauthenticatedPackagesApiEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period (in seconds). View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_packages_api_period_in_seconds ApplicationSettings#throttle_unauthenticated_packages_api_period_in_seconds}
    */
    readonly throttleUnauthenticatedPackagesApiPeriodInSeconds?: number;
    /**
    * Maximum requests per period per user. View Package Registry rate limits for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_packages_api_requests_per_period ApplicationSettings#throttle_unauthenticated_packages_api_requests_per_period}
    */
    readonly throttleUnauthenticatedPackagesApiRequestsPerPeriod?: number;
    /**
    * (If enabled, requires: throttle_unauthenticated_web_period_in_seconds and throttle_unauthenticated_web_requests_per_period) Enable unauthenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_web_enabled ApplicationSettings#throttle_unauthenticated_web_enabled}
    */
    readonly throttleUnauthenticatedWebEnabled?: boolean | cdktf.IResolvable;
    /**
    * Rate limit period in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_web_period_in_seconds ApplicationSettings#throttle_unauthenticated_web_period_in_seconds}
    */
    readonly throttleUnauthenticatedWebPeriodInSeconds?: number;
    /**
    * Max requests per period per IP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#throttle_unauthenticated_web_requests_per_period ApplicationSettings#throttle_unauthenticated_web_requests_per_period}
    */
    readonly throttleUnauthenticatedWebRequestsPerPeriod?: number;
    /**
    * Limit display of time tracking units to hours. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#time_tracking_limit_to_hours ApplicationSettings#time_tracking_limit_to_hours}
    */
    readonly timeTrackingLimitToHours?: boolean | cdktf.IResolvable;
    /**
    * Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#two_factor_grace_period ApplicationSettings#two_factor_grace_period}
    */
    readonly twoFactorGracePeriod?: number;
    /**
    * (If enabled, requires: unique_ips_limit_per_user and unique_ips_limit_time_window) Limit sign in from multiple IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#unique_ips_limit_enabled ApplicationSettings#unique_ips_limit_enabled}
    */
    readonly uniqueIpsLimitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of IPs per user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#unique_ips_limit_per_user ApplicationSettings#unique_ips_limit_per_user}
    */
    readonly uniqueIpsLimitPerUser?: number;
    /**
    * How many seconds an IP is counted towards the limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#unique_ips_limit_time_window ApplicationSettings#unique_ips_limit_time_window}
    */
    readonly uniqueIpsLimitTimeWindow?: number;
    /**
    * Every week GitLab reports license usage back to GitLab, Inc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#usage_ping_enabled ApplicationSettings#usage_ping_enabled}
    */
    readonly usagePingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Send an email to users upon account deactivation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#user_deactivation_emails_enabled ApplicationSettings#user_deactivation_emails_enabled}
    */
    readonly userDeactivationEmailsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Newly registered users are external by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#user_default_external ApplicationSettings#user_default_external}
    */
    readonly userDefaultExternal?: boolean | cdktf.IResolvable;
    /**
    * Specify an email address regex pattern to identify default internal users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#user_default_internal_regex ApplicationSettings#user_default_internal_regex}
    */
    readonly userDefaultInternalRegex?: string;
    /**
    * Allow users to register any application to use GitLab as an OAuth provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#user_oauth_applications ApplicationSettings#user_oauth_applications}
    */
    readonly userOauthApplications?: boolean | cdktf.IResolvable;
    /**
    * When set to false disable the You won't be able to pull or push project code via SSH warning shown to users with no uploaded SSH key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#user_show_add_ssh_key_message ApplicationSettings#user_show_add_ssh_key_message}
    */
    readonly userShowAddSshKeyMessage?: boolean | cdktf.IResolvable;
    /**
    * Let GitLab inform you when an update is available.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#version_check_enabled ApplicationSettings#version_check_enabled}
    */
    readonly versionCheckEnabled?: boolean | cdktf.IResolvable;
    /**
    * Live Preview (allow live previews of JavaScript projects in the Web IDE using CodeSandbox Live Preview).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#web_ide_clientside_preview_enabled ApplicationSettings#web_ide_clientside_preview_enabled}
    */
    readonly webIdeClientsidePreviewEnabled?: boolean | cdktf.IResolvable;
    /**
    * What’s new variant, possible values: all_tiers, current_tier, and disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#whats_new_variant ApplicationSettings#whats_new_variant}
    */
    readonly whatsNewVariant?: string;
    /**
    * Maximum wiki page content size in bytes. Default: 52428800 Bytes (50 MB). The minimum value is 1024 bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings#wiki_page_max_content_bytes ApplicationSettings#wiki_page_max_content_bytes}
    */
    readonly wikiPageMaxContentBytes?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings}
*/
export declare class ApplicationSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_application_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationSettingsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ApplicationSettingsConfig);
    private _abuseNotificationEmail?;
    get abuseNotificationEmail(): string;
    set abuseNotificationEmail(value: string);
    resetAbuseNotificationEmail(): void;
    get abuseNotificationEmailInput(): string | undefined;
    private _adminMode?;
    get adminMode(): boolean | cdktf.IResolvable;
    set adminMode(value: boolean | cdktf.IResolvable);
    resetAdminMode(): void;
    get adminModeInput(): boolean | cdktf.IResolvable | undefined;
    private _afterSignOutPath?;
    get afterSignOutPath(): string;
    set afterSignOutPath(value: string);
    resetAfterSignOutPath(): void;
    get afterSignOutPathInput(): string | undefined;
    private _afterSignUpText?;
    get afterSignUpText(): string;
    set afterSignUpText(value: string);
    resetAfterSignUpText(): void;
    get afterSignUpTextInput(): string | undefined;
    private _akismetApiKey?;
    get akismetApiKey(): string;
    set akismetApiKey(value: string);
    resetAkismetApiKey(): void;
    get akismetApiKeyInput(): string | undefined;
    private _akismetEnabled?;
    get akismetEnabled(): boolean | cdktf.IResolvable;
    set akismetEnabled(value: boolean | cdktf.IResolvable);
    resetAkismetEnabled(): void;
    get akismetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGroupOwnersToManageLdap?;
    get allowGroupOwnersToManageLdap(): boolean | cdktf.IResolvable;
    set allowGroupOwnersToManageLdap(value: boolean | cdktf.IResolvable);
    resetAllowGroupOwnersToManageLdap(): void;
    get allowGroupOwnersToManageLdapInput(): boolean | cdktf.IResolvable | undefined;
    private _allowLocalRequestsFromSystemHooks?;
    get allowLocalRequestsFromSystemHooks(): boolean | cdktf.IResolvable;
    set allowLocalRequestsFromSystemHooks(value: boolean | cdktf.IResolvable);
    resetAllowLocalRequestsFromSystemHooks(): void;
    get allowLocalRequestsFromSystemHooksInput(): boolean | cdktf.IResolvable | undefined;
    private _allowLocalRequestsFromWebHooksAndServices?;
    get allowLocalRequestsFromWebHooksAndServices(): boolean | cdktf.IResolvable;
    set allowLocalRequestsFromWebHooksAndServices(value: boolean | cdktf.IResolvable);
    resetAllowLocalRequestsFromWebHooksAndServices(): void;
    get allowLocalRequestsFromWebHooksAndServicesInput(): boolean | cdktf.IResolvable | undefined;
    private _archiveBuildsInHumanReadable?;
    get archiveBuildsInHumanReadable(): string;
    set archiveBuildsInHumanReadable(value: string);
    resetArchiveBuildsInHumanReadable(): void;
    get archiveBuildsInHumanReadableInput(): string | undefined;
    private _assetProxyAllowlist?;
    get assetProxyAllowlist(): string[];
    set assetProxyAllowlist(value: string[]);
    resetAssetProxyAllowlist(): void;
    get assetProxyAllowlistInput(): string[] | undefined;
    private _assetProxyEnabled?;
    get assetProxyEnabled(): boolean | cdktf.IResolvable;
    set assetProxyEnabled(value: boolean | cdktf.IResolvable);
    resetAssetProxyEnabled(): void;
    get assetProxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _assetProxySecretKey?;
    get assetProxySecretKey(): string;
    set assetProxySecretKey(value: string);
    resetAssetProxySecretKey(): void;
    get assetProxySecretKeyInput(): string | undefined;
    private _assetProxyUrl?;
    get assetProxyUrl(): string;
    set assetProxyUrl(value: string);
    resetAssetProxyUrl(): void;
    get assetProxyUrlInput(): string | undefined;
    private _authorizedKeysEnabled?;
    get authorizedKeysEnabled(): boolean | cdktf.IResolvable;
    set authorizedKeysEnabled(value: boolean | cdktf.IResolvable);
    resetAuthorizedKeysEnabled(): void;
    get authorizedKeysEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoDevopsDomain?;
    get autoDevopsDomain(): string;
    set autoDevopsDomain(value: string);
    resetAutoDevopsDomain(): void;
    get autoDevopsDomainInput(): string | undefined;
    private _autoDevopsEnabled?;
    get autoDevopsEnabled(): boolean | cdktf.IResolvable;
    set autoDevopsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoDevopsEnabled(): void;
    get autoDevopsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticPurchasedStorageAllocation?;
    get automaticPurchasedStorageAllocation(): boolean | cdktf.IResolvable;
    set automaticPurchasedStorageAllocation(value: boolean | cdktf.IResolvable);
    resetAutomaticPurchasedStorageAllocation(): void;
    get automaticPurchasedStorageAllocationInput(): boolean | cdktf.IResolvable | undefined;
    private _checkNamespacePlan?;
    get checkNamespacePlan(): boolean | cdktf.IResolvable;
    set checkNamespacePlan(value: boolean | cdktf.IResolvable);
    resetCheckNamespacePlan(): void;
    get checkNamespacePlanInput(): boolean | cdktf.IResolvable | undefined;
    private _commitEmailHostname?;
    get commitEmailHostname(): string;
    set commitEmailHostname(value: string);
    resetCommitEmailHostname(): void;
    get commitEmailHostnameInput(): string | undefined;
    private _containerExpirationPoliciesEnableHistoricEntries?;
    get containerExpirationPoliciesEnableHistoricEntries(): boolean | cdktf.IResolvable;
    set containerExpirationPoliciesEnableHistoricEntries(value: boolean | cdktf.IResolvable);
    resetContainerExpirationPoliciesEnableHistoricEntries(): void;
    get containerExpirationPoliciesEnableHistoricEntriesInput(): boolean | cdktf.IResolvable | undefined;
    private _containerRegistryCleanupTagsServiceMaxListSize?;
    get containerRegistryCleanupTagsServiceMaxListSize(): number;
    set containerRegistryCleanupTagsServiceMaxListSize(value: number);
    resetContainerRegistryCleanupTagsServiceMaxListSize(): void;
    get containerRegistryCleanupTagsServiceMaxListSizeInput(): number | undefined;
    private _containerRegistryDeleteTagsServiceTimeout?;
    get containerRegistryDeleteTagsServiceTimeout(): number;
    set containerRegistryDeleteTagsServiceTimeout(value: number);
    resetContainerRegistryDeleteTagsServiceTimeout(): void;
    get containerRegistryDeleteTagsServiceTimeoutInput(): number | undefined;
    private _containerRegistryExpirationPoliciesCaching?;
    get containerRegistryExpirationPoliciesCaching(): boolean | cdktf.IResolvable;
    set containerRegistryExpirationPoliciesCaching(value: boolean | cdktf.IResolvable);
    resetContainerRegistryExpirationPoliciesCaching(): void;
    get containerRegistryExpirationPoliciesCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _containerRegistryExpirationPoliciesWorkerCapacity?;
    get containerRegistryExpirationPoliciesWorkerCapacity(): number;
    set containerRegistryExpirationPoliciesWorkerCapacity(value: number);
    resetContainerRegistryExpirationPoliciesWorkerCapacity(): void;
    get containerRegistryExpirationPoliciesWorkerCapacityInput(): number | undefined;
    private _containerRegistryTokenExpireDelay?;
    get containerRegistryTokenExpireDelay(): number;
    set containerRegistryTokenExpireDelay(value: number);
    resetContainerRegistryTokenExpireDelay(): void;
    get containerRegistryTokenExpireDelayInput(): number | undefined;
    private _deactivateDormantUsers?;
    get deactivateDormantUsers(): boolean | cdktf.IResolvable;
    set deactivateDormantUsers(value: boolean | cdktf.IResolvable);
    resetDeactivateDormantUsers(): void;
    get deactivateDormantUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultArtifactsExpireIn?;
    get defaultArtifactsExpireIn(): string;
    set defaultArtifactsExpireIn(value: string);
    resetDefaultArtifactsExpireIn(): void;
    get defaultArtifactsExpireInInput(): string | undefined;
    private _defaultBranchName?;
    get defaultBranchName(): string;
    set defaultBranchName(value: string);
    resetDefaultBranchName(): void;
    get defaultBranchNameInput(): string | undefined;
    private _defaultBranchProtection?;
    get defaultBranchProtection(): number;
    set defaultBranchProtection(value: number);
    resetDefaultBranchProtection(): void;
    get defaultBranchProtectionInput(): number | undefined;
    private _defaultCiConfigPath?;
    get defaultCiConfigPath(): string;
    set defaultCiConfigPath(value: string);
    resetDefaultCiConfigPath(): void;
    get defaultCiConfigPathInput(): string | undefined;
    private _defaultGroupVisibility?;
    get defaultGroupVisibility(): string;
    set defaultGroupVisibility(value: string);
    resetDefaultGroupVisibility(): void;
    get defaultGroupVisibilityInput(): string | undefined;
    private _defaultProjectCreation?;
    get defaultProjectCreation(): number;
    set defaultProjectCreation(value: number);
    resetDefaultProjectCreation(): void;
    get defaultProjectCreationInput(): number | undefined;
    private _defaultProjectVisibility?;
    get defaultProjectVisibility(): string;
    set defaultProjectVisibility(value: string);
    resetDefaultProjectVisibility(): void;
    get defaultProjectVisibilityInput(): string | undefined;
    private _defaultProjectsLimit?;
    get defaultProjectsLimit(): number;
    set defaultProjectsLimit(value: number);
    resetDefaultProjectsLimit(): void;
    get defaultProjectsLimitInput(): number | undefined;
    private _defaultSnippetVisibility?;
    get defaultSnippetVisibility(): string;
    set defaultSnippetVisibility(value: string);
    resetDefaultSnippetVisibility(): void;
    get defaultSnippetVisibilityInput(): string | undefined;
    private _delayedGroupDeletion?;
    get delayedGroupDeletion(): boolean | cdktf.IResolvable;
    set delayedGroupDeletion(value: boolean | cdktf.IResolvable);
    resetDelayedGroupDeletion(): void;
    get delayedGroupDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _delayedProjectDeletion?;
    get delayedProjectDeletion(): boolean | cdktf.IResolvable;
    set delayedProjectDeletion(value: boolean | cdktf.IResolvable);
    resetDelayedProjectDeletion(): void;
    get delayedProjectDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteInactiveProjects?;
    get deleteInactiveProjects(): boolean | cdktf.IResolvable;
    set deleteInactiveProjects(value: boolean | cdktf.IResolvable);
    resetDeleteInactiveProjects(): void;
    get deleteInactiveProjectsInput(): boolean | cdktf.IResolvable | undefined;
    private _deletionAdjournedPeriod?;
    get deletionAdjournedPeriod(): number;
    set deletionAdjournedPeriod(value: number);
    resetDeletionAdjournedPeriod(): void;
    get deletionAdjournedPeriodInput(): number | undefined;
    private _diffMaxFiles?;
    get diffMaxFiles(): number;
    set diffMaxFiles(value: number);
    resetDiffMaxFiles(): void;
    get diffMaxFilesInput(): number | undefined;
    private _diffMaxLines?;
    get diffMaxLines(): number;
    set diffMaxLines(value: number);
    resetDiffMaxLines(): void;
    get diffMaxLinesInput(): number | undefined;
    private _diffMaxPatchBytes?;
    get diffMaxPatchBytes(): number;
    set diffMaxPatchBytes(value: number);
    resetDiffMaxPatchBytes(): void;
    get diffMaxPatchBytesInput(): number | undefined;
    private _disableFeedToken?;
    get disableFeedToken(): boolean | cdktf.IResolvable;
    set disableFeedToken(value: boolean | cdktf.IResolvable);
    resetDisableFeedToken(): void;
    get disableFeedTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _disabledOauthSignInSources?;
    get disabledOauthSignInSources(): string[];
    set disabledOauthSignInSources(value: string[]);
    resetDisabledOauthSignInSources(): void;
    get disabledOauthSignInSourcesInput(): string[] | undefined;
    private _dnsRebindingProtectionEnabled?;
    get dnsRebindingProtectionEnabled(): boolean | cdktf.IResolvable;
    set dnsRebindingProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetDnsRebindingProtectionEnabled(): void;
    get dnsRebindingProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _domainAllowlist?;
    get domainAllowlist(): string[];
    set domainAllowlist(value: string[]);
    resetDomainAllowlist(): void;
    get domainAllowlistInput(): string[] | undefined;
    private _domainDenylist?;
    get domainDenylist(): string[];
    set domainDenylist(value: string[]);
    resetDomainDenylist(): void;
    get domainDenylistInput(): string[] | undefined;
    private _domainDenylistEnabled?;
    get domainDenylistEnabled(): boolean | cdktf.IResolvable;
    set domainDenylistEnabled(value: boolean | cdktf.IResolvable);
    resetDomainDenylistEnabled(): void;
    get domainDenylistEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dsaKeyRestriction?;
    get dsaKeyRestriction(): number;
    set dsaKeyRestriction(value: number);
    resetDsaKeyRestriction(): void;
    get dsaKeyRestrictionInput(): number | undefined;
    private _ecdsaKeyRestriction?;
    get ecdsaKeyRestriction(): number;
    set ecdsaKeyRestriction(value: number);
    resetEcdsaKeyRestriction(): void;
    get ecdsaKeyRestrictionInput(): number | undefined;
    private _ecdsaSkKeyRestriction?;
    get ecdsaSkKeyRestriction(): number;
    set ecdsaSkKeyRestriction(value: number);
    resetEcdsaSkKeyRestriction(): void;
    get ecdsaSkKeyRestrictionInput(): number | undefined;
    private _ed25519KeyRestriction?;
    get ed25519KeyRestriction(): number;
    set ed25519KeyRestriction(value: number);
    resetEd25519KeyRestriction(): void;
    get ed25519KeyRestrictionInput(): number | undefined;
    private _ed25519SkKeyRestriction?;
    get ed25519SkKeyRestriction(): number;
    set ed25519SkKeyRestriction(value: number);
    resetEd25519SkKeyRestriction(): void;
    get ed25519SkKeyRestrictionInput(): number | undefined;
    private _eksAccessKeyId?;
    get eksAccessKeyId(): string;
    set eksAccessKeyId(value: string);
    resetEksAccessKeyId(): void;
    get eksAccessKeyIdInput(): string | undefined;
    private _eksAccountId?;
    get eksAccountId(): string;
    set eksAccountId(value: string);
    resetEksAccountId(): void;
    get eksAccountIdInput(): string | undefined;
    private _eksIntegrationEnabled?;
    get eksIntegrationEnabled(): boolean | cdktf.IResolvable;
    set eksIntegrationEnabled(value: boolean | cdktf.IResolvable);
    resetEksIntegrationEnabled(): void;
    get eksIntegrationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eksSecretAccessKey?;
    get eksSecretAccessKey(): string;
    set eksSecretAccessKey(value: string);
    resetEksSecretAccessKey(): void;
    get eksSecretAccessKeyInput(): string | undefined;
    private _elasticsearchAws?;
    get elasticsearchAws(): boolean | cdktf.IResolvable;
    set elasticsearchAws(value: boolean | cdktf.IResolvable);
    resetElasticsearchAws(): void;
    get elasticsearchAwsInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticsearchAwsAccessKey?;
    get elasticsearchAwsAccessKey(): string;
    set elasticsearchAwsAccessKey(value: string);
    resetElasticsearchAwsAccessKey(): void;
    get elasticsearchAwsAccessKeyInput(): string | undefined;
    private _elasticsearchAwsRegion?;
    get elasticsearchAwsRegion(): string;
    set elasticsearchAwsRegion(value: string);
    resetElasticsearchAwsRegion(): void;
    get elasticsearchAwsRegionInput(): string | undefined;
    private _elasticsearchAwsSecretAccessKey?;
    get elasticsearchAwsSecretAccessKey(): string;
    set elasticsearchAwsSecretAccessKey(value: string);
    resetElasticsearchAwsSecretAccessKey(): void;
    get elasticsearchAwsSecretAccessKeyInput(): string | undefined;
    private _elasticsearchIndexedFieldLengthLimit?;
    get elasticsearchIndexedFieldLengthLimit(): number;
    set elasticsearchIndexedFieldLengthLimit(value: number);
    resetElasticsearchIndexedFieldLengthLimit(): void;
    get elasticsearchIndexedFieldLengthLimitInput(): number | undefined;
    private _elasticsearchIndexedFileSizeLimitKb?;
    get elasticsearchIndexedFileSizeLimitKb(): number;
    set elasticsearchIndexedFileSizeLimitKb(value: number);
    resetElasticsearchIndexedFileSizeLimitKb(): void;
    get elasticsearchIndexedFileSizeLimitKbInput(): number | undefined;
    private _elasticsearchIndexing?;
    get elasticsearchIndexing(): boolean | cdktf.IResolvable;
    set elasticsearchIndexing(value: boolean | cdktf.IResolvable);
    resetElasticsearchIndexing(): void;
    get elasticsearchIndexingInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticsearchLimitIndexing?;
    get elasticsearchLimitIndexing(): boolean | cdktf.IResolvable;
    set elasticsearchLimitIndexing(value: boolean | cdktf.IResolvable);
    resetElasticsearchLimitIndexing(): void;
    get elasticsearchLimitIndexingInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticsearchMaxBulkConcurrency?;
    get elasticsearchMaxBulkConcurrency(): number;
    set elasticsearchMaxBulkConcurrency(value: number);
    resetElasticsearchMaxBulkConcurrency(): void;
    get elasticsearchMaxBulkConcurrencyInput(): number | undefined;
    private _elasticsearchMaxBulkSizeMb?;
    get elasticsearchMaxBulkSizeMb(): number;
    set elasticsearchMaxBulkSizeMb(value: number);
    resetElasticsearchMaxBulkSizeMb(): void;
    get elasticsearchMaxBulkSizeMbInput(): number | undefined;
    private _elasticsearchNamespaceIds?;
    get elasticsearchNamespaceIds(): string[];
    set elasticsearchNamespaceIds(value: string[]);
    resetElasticsearchNamespaceIds(): void;
    get elasticsearchNamespaceIdsInput(): string[] | undefined;
    private _elasticsearchPassword?;
    get elasticsearchPassword(): string;
    set elasticsearchPassword(value: string);
    resetElasticsearchPassword(): void;
    get elasticsearchPasswordInput(): string | undefined;
    private _elasticsearchProjectIds?;
    get elasticsearchProjectIds(): string[];
    set elasticsearchProjectIds(value: string[]);
    resetElasticsearchProjectIds(): void;
    get elasticsearchProjectIdsInput(): string[] | undefined;
    private _elasticsearchSearch?;
    get elasticsearchSearch(): boolean | cdktf.IResolvable;
    set elasticsearchSearch(value: boolean | cdktf.IResolvable);
    resetElasticsearchSearch(): void;
    get elasticsearchSearchInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticsearchUrl?;
    get elasticsearchUrl(): string[];
    set elasticsearchUrl(value: string[]);
    resetElasticsearchUrl(): void;
    get elasticsearchUrlInput(): string[] | undefined;
    private _elasticsearchUsername?;
    get elasticsearchUsername(): string;
    set elasticsearchUsername(value: string);
    resetElasticsearchUsername(): void;
    get elasticsearchUsernameInput(): string | undefined;
    private _emailAdditionalText?;
    get emailAdditionalText(): string;
    set emailAdditionalText(value: string);
    resetEmailAdditionalText(): void;
    get emailAdditionalTextInput(): string | undefined;
    private _emailAuthorInBody?;
    get emailAuthorInBody(): boolean | cdktf.IResolvable;
    set emailAuthorInBody(value: boolean | cdktf.IResolvable);
    resetEmailAuthorInBody(): void;
    get emailAuthorInBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledGitAccessProtocol?;
    get enabledGitAccessProtocol(): string;
    set enabledGitAccessProtocol(value: string);
    resetEnabledGitAccessProtocol(): void;
    get enabledGitAccessProtocolInput(): string | undefined;
    private _enforceNamespaceStorageLimit?;
    get enforceNamespaceStorageLimit(): boolean | cdktf.IResolvable;
    set enforceNamespaceStorageLimit(value: boolean | cdktf.IResolvable);
    resetEnforceNamespaceStorageLimit(): void;
    get enforceNamespaceStorageLimitInput(): boolean | cdktf.IResolvable | undefined;
    private _enforceTerms?;
    get enforceTerms(): boolean | cdktf.IResolvable;
    set enforceTerms(value: boolean | cdktf.IResolvable);
    resetEnforceTerms(): void;
    get enforceTermsInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAuthClientCert?;
    get externalAuthClientCert(): string;
    set externalAuthClientCert(value: string);
    resetExternalAuthClientCert(): void;
    get externalAuthClientCertInput(): string | undefined;
    private _externalAuthClientKey?;
    get externalAuthClientKey(): string;
    set externalAuthClientKey(value: string);
    resetExternalAuthClientKey(): void;
    get externalAuthClientKeyInput(): string | undefined;
    private _externalAuthClientKeyPass?;
    get externalAuthClientKeyPass(): string;
    set externalAuthClientKeyPass(value: string);
    resetExternalAuthClientKeyPass(): void;
    get externalAuthClientKeyPassInput(): string | undefined;
    private _externalAuthorizationServiceDefaultLabel?;
    get externalAuthorizationServiceDefaultLabel(): string;
    set externalAuthorizationServiceDefaultLabel(value: string);
    resetExternalAuthorizationServiceDefaultLabel(): void;
    get externalAuthorizationServiceDefaultLabelInput(): string | undefined;
    private _externalAuthorizationServiceEnabled?;
    get externalAuthorizationServiceEnabled(): boolean | cdktf.IResolvable;
    set externalAuthorizationServiceEnabled(value: boolean | cdktf.IResolvable);
    resetExternalAuthorizationServiceEnabled(): void;
    get externalAuthorizationServiceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAuthorizationServiceTimeout?;
    get externalAuthorizationServiceTimeout(): number;
    set externalAuthorizationServiceTimeout(value: number);
    resetExternalAuthorizationServiceTimeout(): void;
    get externalAuthorizationServiceTimeoutInput(): number | undefined;
    private _externalAuthorizationServiceUrl?;
    get externalAuthorizationServiceUrl(): string;
    set externalAuthorizationServiceUrl(value: string);
    resetExternalAuthorizationServiceUrl(): void;
    get externalAuthorizationServiceUrlInput(): string | undefined;
    private _externalPipelineValidationServiceTimeout?;
    get externalPipelineValidationServiceTimeout(): number;
    set externalPipelineValidationServiceTimeout(value: number);
    resetExternalPipelineValidationServiceTimeout(): void;
    get externalPipelineValidationServiceTimeoutInput(): number | undefined;
    private _externalPipelineValidationServiceToken?;
    get externalPipelineValidationServiceToken(): string;
    set externalPipelineValidationServiceToken(value: string);
    resetExternalPipelineValidationServiceToken(): void;
    get externalPipelineValidationServiceTokenInput(): string | undefined;
    private _externalPipelineValidationServiceUrl?;
    get externalPipelineValidationServiceUrl(): string;
    set externalPipelineValidationServiceUrl(value: string);
    resetExternalPipelineValidationServiceUrl(): void;
    get externalPipelineValidationServiceUrlInput(): string | undefined;
    private _fileTemplateProjectId?;
    get fileTemplateProjectId(): number;
    set fileTemplateProjectId(value: number);
    resetFileTemplateProjectId(): void;
    get fileTemplateProjectIdInput(): number | undefined;
    private _firstDayOfWeek?;
    get firstDayOfWeek(): number;
    set firstDayOfWeek(value: number);
    resetFirstDayOfWeek(): void;
    get firstDayOfWeekInput(): number | undefined;
    private _geoNodeAllowedIps?;
    get geoNodeAllowedIps(): string;
    set geoNodeAllowedIps(value: string);
    resetGeoNodeAllowedIps(): void;
    get geoNodeAllowedIpsInput(): string | undefined;
    private _geoStatusTimeout?;
    get geoStatusTimeout(): number;
    set geoStatusTimeout(value: number);
    resetGeoStatusTimeout(): void;
    get geoStatusTimeoutInput(): number | undefined;
    private _gitRateLimitUsersAllowlist?;
    get gitRateLimitUsersAllowlist(): string[];
    set gitRateLimitUsersAllowlist(value: string[]);
    resetGitRateLimitUsersAllowlist(): void;
    get gitRateLimitUsersAllowlistInput(): string[] | undefined;
    private _gitTwoFactorSessionExpiry?;
    get gitTwoFactorSessionExpiry(): number;
    set gitTwoFactorSessionExpiry(value: number);
    resetGitTwoFactorSessionExpiry(): void;
    get gitTwoFactorSessionExpiryInput(): number | undefined;
    private _gitalyTimeoutDefault?;
    get gitalyTimeoutDefault(): number;
    set gitalyTimeoutDefault(value: number);
    resetGitalyTimeoutDefault(): void;
    get gitalyTimeoutDefaultInput(): number | undefined;
    private _gitalyTimeoutFast?;
    get gitalyTimeoutFast(): number;
    set gitalyTimeoutFast(value: number);
    resetGitalyTimeoutFast(): void;
    get gitalyTimeoutFastInput(): number | undefined;
    private _gitalyTimeoutMedium?;
    get gitalyTimeoutMedium(): number;
    set gitalyTimeoutMedium(value: number);
    resetGitalyTimeoutMedium(): void;
    get gitalyTimeoutMediumInput(): number | undefined;
    private _grafanaEnabled?;
    get grafanaEnabled(): boolean | cdktf.IResolvable;
    set grafanaEnabled(value: boolean | cdktf.IResolvable);
    resetGrafanaEnabled(): void;
    get grafanaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _grafanaUrl?;
    get grafanaUrl(): string;
    set grafanaUrl(value: string);
    resetGrafanaUrl(): void;
    get grafanaUrlInput(): string | undefined;
    private _gravatarEnabled?;
    get gravatarEnabled(): boolean | cdktf.IResolvable;
    set gravatarEnabled(value: boolean | cdktf.IResolvable);
    resetGravatarEnabled(): void;
    get gravatarEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _groupOwnersCanManageDefaultBranchProtection?;
    get groupOwnersCanManageDefaultBranchProtection(): boolean | cdktf.IResolvable;
    set groupOwnersCanManageDefaultBranchProtection(value: boolean | cdktf.IResolvable);
    resetGroupOwnersCanManageDefaultBranchProtection(): void;
    get groupOwnersCanManageDefaultBranchProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _hashedStorageEnabled?;
    get hashedStorageEnabled(): boolean | cdktf.IResolvable;
    set hashedStorageEnabled(value: boolean | cdktf.IResolvable);
    resetHashedStorageEnabled(): void;
    get hashedStorageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _helpPageHideCommercialContent?;
    get helpPageHideCommercialContent(): boolean | cdktf.IResolvable;
    set helpPageHideCommercialContent(value: boolean | cdktf.IResolvable);
    resetHelpPageHideCommercialContent(): void;
    get helpPageHideCommercialContentInput(): boolean | cdktf.IResolvable | undefined;
    private _helpPageSupportUrl?;
    get helpPageSupportUrl(): string;
    set helpPageSupportUrl(value: string);
    resetHelpPageSupportUrl(): void;
    get helpPageSupportUrlInput(): string | undefined;
    private _helpPageText?;
    get helpPageText(): string;
    set helpPageText(value: string);
    resetHelpPageText(): void;
    get helpPageTextInput(): string | undefined;
    private _helpText?;
    get helpText(): string;
    set helpText(value: string);
    resetHelpText(): void;
    get helpTextInput(): string | undefined;
    private _hideThirdPartyOffers?;
    get hideThirdPartyOffers(): boolean | cdktf.IResolvable;
    set hideThirdPartyOffers(value: boolean | cdktf.IResolvable);
    resetHideThirdPartyOffers(): void;
    get hideThirdPartyOffersInput(): boolean | cdktf.IResolvable | undefined;
    private _homePageUrl?;
    get homePageUrl(): string;
    set homePageUrl(value: string);
    resetHomePageUrl(): void;
    get homePageUrlInput(): string | undefined;
    private _housekeepingEnabled?;
    get housekeepingEnabled(): boolean | cdktf.IResolvable;
    set housekeepingEnabled(value: boolean | cdktf.IResolvable);
    resetHousekeepingEnabled(): void;
    get housekeepingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _housekeepingFullRepackPeriod?;
    get housekeepingFullRepackPeriod(): number;
    set housekeepingFullRepackPeriod(value: number);
    resetHousekeepingFullRepackPeriod(): void;
    get housekeepingFullRepackPeriodInput(): number | undefined;
    private _housekeepingGcPeriod?;
    get housekeepingGcPeriod(): number;
    set housekeepingGcPeriod(value: number);
    resetHousekeepingGcPeriod(): void;
    get housekeepingGcPeriodInput(): number | undefined;
    private _housekeepingIncrementalRepackPeriod?;
    get housekeepingIncrementalRepackPeriod(): number;
    set housekeepingIncrementalRepackPeriod(value: number);
    resetHousekeepingIncrementalRepackPeriod(): void;
    get housekeepingIncrementalRepackPeriodInput(): number | undefined;
    private _htmlEmailsEnabled?;
    get htmlEmailsEnabled(): boolean | cdktf.IResolvable;
    set htmlEmailsEnabled(value: boolean | cdktf.IResolvable);
    resetHtmlEmailsEnabled(): void;
    get htmlEmailsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importSources?;
    get importSources(): string[];
    set importSources(value: string[]);
    resetImportSources(): void;
    get importSourcesInput(): string[] | undefined;
    private _inProductMarketingEmailsEnabled?;
    get inProductMarketingEmailsEnabled(): boolean | cdktf.IResolvable;
    set inProductMarketingEmailsEnabled(value: boolean | cdktf.IResolvable);
    resetInProductMarketingEmailsEnabled(): void;
    get inProductMarketingEmailsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _inactiveProjectsDeleteAfterMonths?;
    get inactiveProjectsDeleteAfterMonths(): number;
    set inactiveProjectsDeleteAfterMonths(value: number);
    resetInactiveProjectsDeleteAfterMonths(): void;
    get inactiveProjectsDeleteAfterMonthsInput(): number | undefined;
    private _inactiveProjectsMinSizeMb?;
    get inactiveProjectsMinSizeMb(): number;
    set inactiveProjectsMinSizeMb(value: number);
    resetInactiveProjectsMinSizeMb(): void;
    get inactiveProjectsMinSizeMbInput(): number | undefined;
    private _inactiveProjectsSendWarningEmailAfterMonths?;
    get inactiveProjectsSendWarningEmailAfterMonths(): number;
    set inactiveProjectsSendWarningEmailAfterMonths(value: number);
    resetInactiveProjectsSendWarningEmailAfterMonths(): void;
    get inactiveProjectsSendWarningEmailAfterMonthsInput(): number | undefined;
    private _invisibleCaptchaEnabled?;
    get invisibleCaptchaEnabled(): boolean | cdktf.IResolvable;
    set invisibleCaptchaEnabled(value: boolean | cdktf.IResolvable);
    resetInvisibleCaptchaEnabled(): void;
    get invisibleCaptchaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuesCreateLimit?;
    get issuesCreateLimit(): number;
    set issuesCreateLimit(value: number);
    resetIssuesCreateLimit(): void;
    get issuesCreateLimitInput(): number | undefined;
    private _keepLatestArtifact?;
    get keepLatestArtifact(): boolean | cdktf.IResolvable;
    set keepLatestArtifact(value: boolean | cdktf.IResolvable);
    resetKeepLatestArtifact(): void;
    get keepLatestArtifactInput(): boolean | cdktf.IResolvable | undefined;
    private _localMarkdownVersion?;
    get localMarkdownVersion(): number;
    set localMarkdownVersion(value: number);
    resetLocalMarkdownVersion(): void;
    get localMarkdownVersionInput(): number | undefined;
    private _mailgunEventsEnabled?;
    get mailgunEventsEnabled(): boolean | cdktf.IResolvable;
    set mailgunEventsEnabled(value: boolean | cdktf.IResolvable);
    resetMailgunEventsEnabled(): void;
    get mailgunEventsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mailgunSigningKey?;
    get mailgunSigningKey(): string;
    set mailgunSigningKey(value: string);
    resetMailgunSigningKey(): void;
    get mailgunSigningKeyInput(): string | undefined;
    private _maintenanceMode?;
    get maintenanceMode(): boolean | cdktf.IResolvable;
    set maintenanceMode(value: boolean | cdktf.IResolvable);
    resetMaintenanceMode(): void;
    get maintenanceModeInput(): boolean | cdktf.IResolvable | undefined;
    private _maintenanceModeMessage?;
    get maintenanceModeMessage(): string;
    set maintenanceModeMessage(value: string);
    resetMaintenanceModeMessage(): void;
    get maintenanceModeMessageInput(): string | undefined;
    private _maxArtifactsSize?;
    get maxArtifactsSize(): number;
    set maxArtifactsSize(value: number);
    resetMaxArtifactsSize(): void;
    get maxArtifactsSizeInput(): number | undefined;
    private _maxAttachmentSize?;
    get maxAttachmentSize(): number;
    set maxAttachmentSize(value: number);
    resetMaxAttachmentSize(): void;
    get maxAttachmentSizeInput(): number | undefined;
    private _maxExportSize?;
    get maxExportSize(): number;
    set maxExportSize(value: number);
    resetMaxExportSize(): void;
    get maxExportSizeInput(): number | undefined;
    private _maxImportSize?;
    get maxImportSize(): number;
    set maxImportSize(value: number);
    resetMaxImportSize(): void;
    get maxImportSizeInput(): number | undefined;
    private _maxNumberOfRepositoryDownloads?;
    get maxNumberOfRepositoryDownloads(): number;
    set maxNumberOfRepositoryDownloads(value: number);
    resetMaxNumberOfRepositoryDownloads(): void;
    get maxNumberOfRepositoryDownloadsInput(): number | undefined;
    private _maxNumberOfRepositoryDownloadsWithinTimePeriod?;
    get maxNumberOfRepositoryDownloadsWithinTimePeriod(): number;
    set maxNumberOfRepositoryDownloadsWithinTimePeriod(value: number);
    resetMaxNumberOfRepositoryDownloadsWithinTimePeriod(): void;
    get maxNumberOfRepositoryDownloadsWithinTimePeriodInput(): number | undefined;
    private _maxPagesSize?;
    get maxPagesSize(): number;
    set maxPagesSize(value: number);
    resetMaxPagesSize(): void;
    get maxPagesSizeInput(): number | undefined;
    private _maxPersonalAccessTokenLifetime?;
    get maxPersonalAccessTokenLifetime(): number;
    set maxPersonalAccessTokenLifetime(value: number);
    resetMaxPersonalAccessTokenLifetime(): void;
    get maxPersonalAccessTokenLifetimeInput(): number | undefined;
    private _maxSshKeyLifetime?;
    get maxSshKeyLifetime(): number;
    set maxSshKeyLifetime(value: number);
    resetMaxSshKeyLifetime(): void;
    get maxSshKeyLifetimeInput(): number | undefined;
    private _metricsMethodCallThreshold?;
    get metricsMethodCallThreshold(): number;
    set metricsMethodCallThreshold(value: number);
    resetMetricsMethodCallThreshold(): void;
    get metricsMethodCallThresholdInput(): number | undefined;
    private _mirrorAvailable?;
    get mirrorAvailable(): boolean | cdktf.IResolvable;
    set mirrorAvailable(value: boolean | cdktf.IResolvable);
    resetMirrorAvailable(): void;
    get mirrorAvailableInput(): boolean | cdktf.IResolvable | undefined;
    private _mirrorCapacityThreshold?;
    get mirrorCapacityThreshold(): number;
    set mirrorCapacityThreshold(value: number);
    resetMirrorCapacityThreshold(): void;
    get mirrorCapacityThresholdInput(): number | undefined;
    private _mirrorMaxCapacity?;
    get mirrorMaxCapacity(): number;
    set mirrorMaxCapacity(value: number);
    resetMirrorMaxCapacity(): void;
    get mirrorMaxCapacityInput(): number | undefined;
    private _mirrorMaxDelay?;
    get mirrorMaxDelay(): number;
    set mirrorMaxDelay(value: number);
    resetMirrorMaxDelay(): void;
    get mirrorMaxDelayInput(): number | undefined;
    private _npmPackageRequestsForwarding?;
    get npmPackageRequestsForwarding(): boolean | cdktf.IResolvable;
    set npmPackageRequestsForwarding(value: boolean | cdktf.IResolvable);
    resetNpmPackageRequestsForwarding(): void;
    get npmPackageRequestsForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _outboundLocalRequestsWhitelist?;
    get outboundLocalRequestsWhitelist(): string[];
    set outboundLocalRequestsWhitelist(value: string[]);
    resetOutboundLocalRequestsWhitelist(): void;
    get outboundLocalRequestsWhitelistInput(): string[] | undefined;
    private _packageRegistryCleanupPoliciesWorkerCapacity?;
    get packageRegistryCleanupPoliciesWorkerCapacity(): number;
    set packageRegistryCleanupPoliciesWorkerCapacity(value: number);
    resetPackageRegistryCleanupPoliciesWorkerCapacity(): void;
    get packageRegistryCleanupPoliciesWorkerCapacityInput(): number | undefined;
    private _pagesDomainVerificationEnabled?;
    get pagesDomainVerificationEnabled(): boolean | cdktf.IResolvable;
    set pagesDomainVerificationEnabled(value: boolean | cdktf.IResolvable);
    resetPagesDomainVerificationEnabled(): void;
    get pagesDomainVerificationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordAuthenticationEnabledForGit?;
    get passwordAuthenticationEnabledForGit(): boolean | cdktf.IResolvable;
    set passwordAuthenticationEnabledForGit(value: boolean | cdktf.IResolvable);
    resetPasswordAuthenticationEnabledForGit(): void;
    get passwordAuthenticationEnabledForGitInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordAuthenticationEnabledForWeb?;
    get passwordAuthenticationEnabledForWeb(): boolean | cdktf.IResolvable;
    set passwordAuthenticationEnabledForWeb(value: boolean | cdktf.IResolvable);
    resetPasswordAuthenticationEnabledForWeb(): void;
    get passwordAuthenticationEnabledForWebInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordLowercaseRequired?;
    get passwordLowercaseRequired(): boolean | cdktf.IResolvable;
    set passwordLowercaseRequired(value: boolean | cdktf.IResolvable);
    resetPasswordLowercaseRequired(): void;
    get passwordLowercaseRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordNumberRequired?;
    get passwordNumberRequired(): boolean | cdktf.IResolvable;
    set passwordNumberRequired(value: boolean | cdktf.IResolvable);
    resetPasswordNumberRequired(): void;
    get passwordNumberRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordSymbolRequired?;
    get passwordSymbolRequired(): boolean | cdktf.IResolvable;
    set passwordSymbolRequired(value: boolean | cdktf.IResolvable);
    resetPasswordSymbolRequired(): void;
    get passwordSymbolRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordUppercaseRequired?;
    get passwordUppercaseRequired(): boolean | cdktf.IResolvable;
    set passwordUppercaseRequired(value: boolean | cdktf.IResolvable);
    resetPasswordUppercaseRequired(): void;
    get passwordUppercaseRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _performanceBarAllowedGroupPath?;
    get performanceBarAllowedGroupPath(): string;
    set performanceBarAllowedGroupPath(value: string);
    resetPerformanceBarAllowedGroupPath(): void;
    get performanceBarAllowedGroupPathInput(): string | undefined;
    private _personalAccessTokenPrefix?;
    get personalAccessTokenPrefix(): string;
    set personalAccessTokenPrefix(value: string);
    resetPersonalAccessTokenPrefix(): void;
    get personalAccessTokenPrefixInput(): string | undefined;
    private _pipelineLimitPerProjectUserSha?;
    get pipelineLimitPerProjectUserSha(): number;
    set pipelineLimitPerProjectUserSha(value: number);
    resetPipelineLimitPerProjectUserSha(): void;
    get pipelineLimitPerProjectUserShaInput(): number | undefined;
    private _plantumlEnabled?;
    get plantumlEnabled(): boolean | cdktf.IResolvable;
    set plantumlEnabled(value: boolean | cdktf.IResolvable);
    resetPlantumlEnabled(): void;
    get plantumlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _plantumlUrl?;
    get plantumlUrl(): string;
    set plantumlUrl(value: string);
    resetPlantumlUrl(): void;
    get plantumlUrlInput(): string | undefined;
    private _pollingIntervalMultiplier?;
    get pollingIntervalMultiplier(): number;
    set pollingIntervalMultiplier(value: number);
    resetPollingIntervalMultiplier(): void;
    get pollingIntervalMultiplierInput(): number | undefined;
    private _projectExportEnabled?;
    get projectExportEnabled(): boolean | cdktf.IResolvable;
    set projectExportEnabled(value: boolean | cdktf.IResolvable);
    resetProjectExportEnabled(): void;
    get projectExportEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _prometheusMetricsEnabled?;
    get prometheusMetricsEnabled(): boolean | cdktf.IResolvable;
    set prometheusMetricsEnabled(value: boolean | cdktf.IResolvable);
    resetPrometheusMetricsEnabled(): void;
    get prometheusMetricsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _protectedCiVariables?;
    get protectedCiVariables(): boolean | cdktf.IResolvable;
    set protectedCiVariables(value: boolean | cdktf.IResolvable);
    resetProtectedCiVariables(): void;
    get protectedCiVariablesInput(): boolean | cdktf.IResolvable | undefined;
    private _pushEventActivitiesLimit?;
    get pushEventActivitiesLimit(): number;
    set pushEventActivitiesLimit(value: number);
    resetPushEventActivitiesLimit(): void;
    get pushEventActivitiesLimitInput(): number | undefined;
    private _pushEventHooksLimit?;
    get pushEventHooksLimit(): number;
    set pushEventHooksLimit(value: number);
    resetPushEventHooksLimit(): void;
    get pushEventHooksLimitInput(): number | undefined;
    private _pypiPackageRequestsForwarding?;
    get pypiPackageRequestsForwarding(): boolean | cdktf.IResolvable;
    set pypiPackageRequestsForwarding(value: boolean | cdktf.IResolvable);
    resetPypiPackageRequestsForwarding(): void;
    get pypiPackageRequestsForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _rateLimitingResponseText?;
    get rateLimitingResponseText(): string;
    set rateLimitingResponseText(value: string);
    resetRateLimitingResponseText(): void;
    get rateLimitingResponseTextInput(): string | undefined;
    private _rawBlobRequestLimit?;
    get rawBlobRequestLimit(): number;
    set rawBlobRequestLimit(value: number);
    resetRawBlobRequestLimit(): void;
    get rawBlobRequestLimitInput(): number | undefined;
    private _recaptchaEnabled?;
    get recaptchaEnabled(): boolean | cdktf.IResolvable;
    set recaptchaEnabled(value: boolean | cdktf.IResolvable);
    resetRecaptchaEnabled(): void;
    get recaptchaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _recaptchaPrivateKey?;
    get recaptchaPrivateKey(): string;
    set recaptchaPrivateKey(value: string);
    resetRecaptchaPrivateKey(): void;
    get recaptchaPrivateKeyInput(): string | undefined;
    private _recaptchaSiteKey?;
    get recaptchaSiteKey(): string;
    set recaptchaSiteKey(value: string);
    resetRecaptchaSiteKey(): void;
    get recaptchaSiteKeyInput(): string | undefined;
    private _receiveMaxInputSize?;
    get receiveMaxInputSize(): number;
    set receiveMaxInputSize(value: number);
    resetReceiveMaxInputSize(): void;
    get receiveMaxInputSizeInput(): number | undefined;
    private _repositoryChecksEnabled?;
    get repositoryChecksEnabled(): boolean | cdktf.IResolvable;
    set repositoryChecksEnabled(value: boolean | cdktf.IResolvable);
    resetRepositoryChecksEnabled(): void;
    get repositoryChecksEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _repositorySizeLimit?;
    get repositorySizeLimit(): number;
    set repositorySizeLimit(value: number);
    resetRepositorySizeLimit(): void;
    get repositorySizeLimitInput(): number | undefined;
    private _repositoryStorages?;
    get repositoryStorages(): string[];
    set repositoryStorages(value: string[]);
    resetRepositoryStorages(): void;
    get repositoryStoragesInput(): string[] | undefined;
    private _repositoryStoragesWeighted?;
    get repositoryStoragesWeighted(): {
        [key: string]: number;
    };
    set repositoryStoragesWeighted(value: {
        [key: string]: number;
    });
    resetRepositoryStoragesWeighted(): void;
    get repositoryStoragesWeightedInput(): {
        [key: string]: number;
    } | undefined;
    private _requireAdminApprovalAfterUserSignup?;
    get requireAdminApprovalAfterUserSignup(): boolean | cdktf.IResolvable;
    set requireAdminApprovalAfterUserSignup(value: boolean | cdktf.IResolvable);
    resetRequireAdminApprovalAfterUserSignup(): void;
    get requireAdminApprovalAfterUserSignupInput(): boolean | cdktf.IResolvable | undefined;
    private _requireTwoFactorAuthentication?;
    get requireTwoFactorAuthentication(): boolean | cdktf.IResolvable;
    set requireTwoFactorAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireTwoFactorAuthentication(): void;
    get requireTwoFactorAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _restrictedVisibilityLevels?;
    get restrictedVisibilityLevels(): string[];
    set restrictedVisibilityLevels(value: string[]);
    resetRestrictedVisibilityLevels(): void;
    get restrictedVisibilityLevelsInput(): string[] | undefined;
    private _rsaKeyRestriction?;
    get rsaKeyRestriction(): number;
    set rsaKeyRestriction(value: number);
    resetRsaKeyRestriction(): void;
    get rsaKeyRestrictionInput(): number | undefined;
    private _searchRateLimit?;
    get searchRateLimit(): number;
    set searchRateLimit(value: number);
    resetSearchRateLimit(): void;
    get searchRateLimitInput(): number | undefined;
    private _searchRateLimitUnauthenticated?;
    get searchRateLimitUnauthenticated(): number;
    set searchRateLimitUnauthenticated(value: number);
    resetSearchRateLimitUnauthenticated(): void;
    get searchRateLimitUnauthenticatedInput(): number | undefined;
    private _sendUserConfirmationEmail?;
    get sendUserConfirmationEmail(): boolean | cdktf.IResolvable;
    set sendUserConfirmationEmail(value: boolean | cdktf.IResolvable);
    resetSendUserConfirmationEmail(): void;
    get sendUserConfirmationEmailInput(): boolean | cdktf.IResolvable | undefined;
    private _sessionExpireDelay?;
    get sessionExpireDelay(): number;
    set sessionExpireDelay(value: number);
    resetSessionExpireDelay(): void;
    get sessionExpireDelayInput(): number | undefined;
    private _sharedRunnersEnabled?;
    get sharedRunnersEnabled(): boolean | cdktf.IResolvable;
    set sharedRunnersEnabled(value: boolean | cdktf.IResolvable);
    resetSharedRunnersEnabled(): void;
    get sharedRunnersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedRunnersMinutes?;
    get sharedRunnersMinutes(): number;
    set sharedRunnersMinutes(value: number);
    resetSharedRunnersMinutes(): void;
    get sharedRunnersMinutesInput(): number | undefined;
    private _sharedRunnersText?;
    get sharedRunnersText(): string;
    set sharedRunnersText(value: string);
    resetSharedRunnersText(): void;
    get sharedRunnersTextInput(): string | undefined;
    private _sidekiqJobLimiterCompressionThresholdBytes?;
    get sidekiqJobLimiterCompressionThresholdBytes(): number;
    set sidekiqJobLimiterCompressionThresholdBytes(value: number);
    resetSidekiqJobLimiterCompressionThresholdBytes(): void;
    get sidekiqJobLimiterCompressionThresholdBytesInput(): number | undefined;
    private _sidekiqJobLimiterLimitBytes?;
    get sidekiqJobLimiterLimitBytes(): number;
    set sidekiqJobLimiterLimitBytes(value: number);
    resetSidekiqJobLimiterLimitBytes(): void;
    get sidekiqJobLimiterLimitBytesInput(): number | undefined;
    private _sidekiqJobLimiterMode?;
    get sidekiqJobLimiterMode(): string;
    set sidekiqJobLimiterMode(value: string);
    resetSidekiqJobLimiterMode(): void;
    get sidekiqJobLimiterModeInput(): string | undefined;
    private _signInText?;
    get signInText(): string;
    set signInText(value: string);
    resetSignInText(): void;
    get signInTextInput(): string | undefined;
    private _signupEnabled?;
    get signupEnabled(): boolean | cdktf.IResolvable;
    set signupEnabled(value: boolean | cdktf.IResolvable);
    resetSignupEnabled(): void;
    get signupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _slackAppEnabled?;
    get slackAppEnabled(): boolean | cdktf.IResolvable;
    set slackAppEnabled(value: boolean | cdktf.IResolvable);
    resetSlackAppEnabled(): void;
    get slackAppEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _slackAppId?;
    get slackAppId(): string;
    set slackAppId(value: string);
    resetSlackAppId(): void;
    get slackAppIdInput(): string | undefined;
    private _slackAppSecret?;
    get slackAppSecret(): string;
    set slackAppSecret(value: string);
    resetSlackAppSecret(): void;
    get slackAppSecretInput(): string | undefined;
    private _slackAppSigningSecret?;
    get slackAppSigningSecret(): string;
    set slackAppSigningSecret(value: string);
    resetSlackAppSigningSecret(): void;
    get slackAppSigningSecretInput(): string | undefined;
    private _slackAppVerificationToken?;
    get slackAppVerificationToken(): string;
    set slackAppVerificationToken(value: string);
    resetSlackAppVerificationToken(): void;
    get slackAppVerificationTokenInput(): string | undefined;
    private _snippetSizeLimit?;
    get snippetSizeLimit(): number;
    set snippetSizeLimit(value: number);
    resetSnippetSizeLimit(): void;
    get snippetSizeLimitInput(): number | undefined;
    private _snowplowAppId?;
    get snowplowAppId(): string;
    set snowplowAppId(value: string);
    resetSnowplowAppId(): void;
    get snowplowAppIdInput(): string | undefined;
    private _snowplowCollectorHostname?;
    get snowplowCollectorHostname(): string;
    set snowplowCollectorHostname(value: string);
    resetSnowplowCollectorHostname(): void;
    get snowplowCollectorHostnameInput(): string | undefined;
    private _snowplowCookieDomain?;
    get snowplowCookieDomain(): string;
    set snowplowCookieDomain(value: string);
    resetSnowplowCookieDomain(): void;
    get snowplowCookieDomainInput(): string | undefined;
    private _snowplowEnabled?;
    get snowplowEnabled(): boolean | cdktf.IResolvable;
    set snowplowEnabled(value: boolean | cdktf.IResolvable);
    resetSnowplowEnabled(): void;
    get snowplowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcegraphEnabled?;
    get sourcegraphEnabled(): boolean | cdktf.IResolvable;
    set sourcegraphEnabled(value: boolean | cdktf.IResolvable);
    resetSourcegraphEnabled(): void;
    get sourcegraphEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcegraphPublicOnly?;
    get sourcegraphPublicOnly(): boolean | cdktf.IResolvable;
    set sourcegraphPublicOnly(value: boolean | cdktf.IResolvable);
    resetSourcegraphPublicOnly(): void;
    get sourcegraphPublicOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcegraphUrl?;
    get sourcegraphUrl(): string;
    set sourcegraphUrl(value: string);
    resetSourcegraphUrl(): void;
    get sourcegraphUrlInput(): string | undefined;
    private _spamCheckApiKey?;
    get spamCheckApiKey(): string;
    set spamCheckApiKey(value: string);
    resetSpamCheckApiKey(): void;
    get spamCheckApiKeyInput(): string | undefined;
    private _spamCheckEndpointEnabled?;
    get spamCheckEndpointEnabled(): boolean | cdktf.IResolvable;
    set spamCheckEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetSpamCheckEndpointEnabled(): void;
    get spamCheckEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _spamCheckEndpointUrl?;
    get spamCheckEndpointUrl(): string;
    set spamCheckEndpointUrl(value: string);
    resetSpamCheckEndpointUrl(): void;
    get spamCheckEndpointUrlInput(): string | undefined;
    private _suggestPipelineEnabled?;
    get suggestPipelineEnabled(): boolean | cdktf.IResolvable;
    set suggestPipelineEnabled(value: boolean | cdktf.IResolvable);
    resetSuggestPipelineEnabled(): void;
    get suggestPipelineEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _terminalMaxSessionTime?;
    get terminalMaxSessionTime(): number;
    set terminalMaxSessionTime(value: number);
    resetTerminalMaxSessionTime(): void;
    get terminalMaxSessionTimeInput(): number | undefined;
    private _terms?;
    get terms(): string;
    set terms(value: string);
    resetTerms(): void;
    get termsInput(): string | undefined;
    private _throttleAuthenticatedApiEnabled?;
    get throttleAuthenticatedApiEnabled(): boolean | cdktf.IResolvable;
    set throttleAuthenticatedApiEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleAuthenticatedApiEnabled(): void;
    get throttleAuthenticatedApiEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleAuthenticatedApiPeriodInSeconds?;
    get throttleAuthenticatedApiPeriodInSeconds(): number;
    set throttleAuthenticatedApiPeriodInSeconds(value: number);
    resetThrottleAuthenticatedApiPeriodInSeconds(): void;
    get throttleAuthenticatedApiPeriodInSecondsInput(): number | undefined;
    private _throttleAuthenticatedApiRequestsPerPeriod?;
    get throttleAuthenticatedApiRequestsPerPeriod(): number;
    set throttleAuthenticatedApiRequestsPerPeriod(value: number);
    resetThrottleAuthenticatedApiRequestsPerPeriod(): void;
    get throttleAuthenticatedApiRequestsPerPeriodInput(): number | undefined;
    private _throttleAuthenticatedPackagesApiEnabled?;
    get throttleAuthenticatedPackagesApiEnabled(): boolean | cdktf.IResolvable;
    set throttleAuthenticatedPackagesApiEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleAuthenticatedPackagesApiEnabled(): void;
    get throttleAuthenticatedPackagesApiEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleAuthenticatedPackagesApiPeriodInSeconds?;
    get throttleAuthenticatedPackagesApiPeriodInSeconds(): number;
    set throttleAuthenticatedPackagesApiPeriodInSeconds(value: number);
    resetThrottleAuthenticatedPackagesApiPeriodInSeconds(): void;
    get throttleAuthenticatedPackagesApiPeriodInSecondsInput(): number | undefined;
    private _throttleAuthenticatedPackagesApiRequestsPerPeriod?;
    get throttleAuthenticatedPackagesApiRequestsPerPeriod(): number;
    set throttleAuthenticatedPackagesApiRequestsPerPeriod(value: number);
    resetThrottleAuthenticatedPackagesApiRequestsPerPeriod(): void;
    get throttleAuthenticatedPackagesApiRequestsPerPeriodInput(): number | undefined;
    private _throttleAuthenticatedWebEnabled?;
    get throttleAuthenticatedWebEnabled(): boolean | cdktf.IResolvable;
    set throttleAuthenticatedWebEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleAuthenticatedWebEnabled(): void;
    get throttleAuthenticatedWebEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleAuthenticatedWebPeriodInSeconds?;
    get throttleAuthenticatedWebPeriodInSeconds(): number;
    set throttleAuthenticatedWebPeriodInSeconds(value: number);
    resetThrottleAuthenticatedWebPeriodInSeconds(): void;
    get throttleAuthenticatedWebPeriodInSecondsInput(): number | undefined;
    private _throttleAuthenticatedWebRequestsPerPeriod?;
    get throttleAuthenticatedWebRequestsPerPeriod(): number;
    set throttleAuthenticatedWebRequestsPerPeriod(value: number);
    resetThrottleAuthenticatedWebRequestsPerPeriod(): void;
    get throttleAuthenticatedWebRequestsPerPeriodInput(): number | undefined;
    private _throttleUnauthenticatedApiEnabled?;
    get throttleUnauthenticatedApiEnabled(): boolean | cdktf.IResolvable;
    set throttleUnauthenticatedApiEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleUnauthenticatedApiEnabled(): void;
    get throttleUnauthenticatedApiEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleUnauthenticatedApiPeriodInSeconds?;
    get throttleUnauthenticatedApiPeriodInSeconds(): number;
    set throttleUnauthenticatedApiPeriodInSeconds(value: number);
    resetThrottleUnauthenticatedApiPeriodInSeconds(): void;
    get throttleUnauthenticatedApiPeriodInSecondsInput(): number | undefined;
    private _throttleUnauthenticatedApiRequestsPerPeriod?;
    get throttleUnauthenticatedApiRequestsPerPeriod(): number;
    set throttleUnauthenticatedApiRequestsPerPeriod(value: number);
    resetThrottleUnauthenticatedApiRequestsPerPeriod(): void;
    get throttleUnauthenticatedApiRequestsPerPeriodInput(): number | undefined;
    private _throttleUnauthenticatedPackagesApiEnabled?;
    get throttleUnauthenticatedPackagesApiEnabled(): boolean | cdktf.IResolvable;
    set throttleUnauthenticatedPackagesApiEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleUnauthenticatedPackagesApiEnabled(): void;
    get throttleUnauthenticatedPackagesApiEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleUnauthenticatedPackagesApiPeriodInSeconds?;
    get throttleUnauthenticatedPackagesApiPeriodInSeconds(): number;
    set throttleUnauthenticatedPackagesApiPeriodInSeconds(value: number);
    resetThrottleUnauthenticatedPackagesApiPeriodInSeconds(): void;
    get throttleUnauthenticatedPackagesApiPeriodInSecondsInput(): number | undefined;
    private _throttleUnauthenticatedPackagesApiRequestsPerPeriod?;
    get throttleUnauthenticatedPackagesApiRequestsPerPeriod(): number;
    set throttleUnauthenticatedPackagesApiRequestsPerPeriod(value: number);
    resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod(): void;
    get throttleUnauthenticatedPackagesApiRequestsPerPeriodInput(): number | undefined;
    private _throttleUnauthenticatedWebEnabled?;
    get throttleUnauthenticatedWebEnabled(): boolean | cdktf.IResolvable;
    set throttleUnauthenticatedWebEnabled(value: boolean | cdktf.IResolvable);
    resetThrottleUnauthenticatedWebEnabled(): void;
    get throttleUnauthenticatedWebEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _throttleUnauthenticatedWebPeriodInSeconds?;
    get throttleUnauthenticatedWebPeriodInSeconds(): number;
    set throttleUnauthenticatedWebPeriodInSeconds(value: number);
    resetThrottleUnauthenticatedWebPeriodInSeconds(): void;
    get throttleUnauthenticatedWebPeriodInSecondsInput(): number | undefined;
    private _throttleUnauthenticatedWebRequestsPerPeriod?;
    get throttleUnauthenticatedWebRequestsPerPeriod(): number;
    set throttleUnauthenticatedWebRequestsPerPeriod(value: number);
    resetThrottleUnauthenticatedWebRequestsPerPeriod(): void;
    get throttleUnauthenticatedWebRequestsPerPeriodInput(): number | undefined;
    private _timeTrackingLimitToHours?;
    get timeTrackingLimitToHours(): boolean | cdktf.IResolvable;
    set timeTrackingLimitToHours(value: boolean | cdktf.IResolvable);
    resetTimeTrackingLimitToHours(): void;
    get timeTrackingLimitToHoursInput(): boolean | cdktf.IResolvable | undefined;
    private _twoFactorGracePeriod?;
    get twoFactorGracePeriod(): number;
    set twoFactorGracePeriod(value: number);
    resetTwoFactorGracePeriod(): void;
    get twoFactorGracePeriodInput(): number | undefined;
    private _uniqueIpsLimitEnabled?;
    get uniqueIpsLimitEnabled(): boolean | cdktf.IResolvable;
    set uniqueIpsLimitEnabled(value: boolean | cdktf.IResolvable);
    resetUniqueIpsLimitEnabled(): void;
    get uniqueIpsLimitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _uniqueIpsLimitPerUser?;
    get uniqueIpsLimitPerUser(): number;
    set uniqueIpsLimitPerUser(value: number);
    resetUniqueIpsLimitPerUser(): void;
    get uniqueIpsLimitPerUserInput(): number | undefined;
    private _uniqueIpsLimitTimeWindow?;
    get uniqueIpsLimitTimeWindow(): number;
    set uniqueIpsLimitTimeWindow(value: number);
    resetUniqueIpsLimitTimeWindow(): void;
    get uniqueIpsLimitTimeWindowInput(): number | undefined;
    private _usagePingEnabled?;
    get usagePingEnabled(): boolean | cdktf.IResolvable;
    set usagePingEnabled(value: boolean | cdktf.IResolvable);
    resetUsagePingEnabled(): void;
    get usagePingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _userDeactivationEmailsEnabled?;
    get userDeactivationEmailsEnabled(): boolean | cdktf.IResolvable;
    set userDeactivationEmailsEnabled(value: boolean | cdktf.IResolvable);
    resetUserDeactivationEmailsEnabled(): void;
    get userDeactivationEmailsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _userDefaultExternal?;
    get userDefaultExternal(): boolean | cdktf.IResolvable;
    set userDefaultExternal(value: boolean | cdktf.IResolvable);
    resetUserDefaultExternal(): void;
    get userDefaultExternalInput(): boolean | cdktf.IResolvable | undefined;
    private _userDefaultInternalRegex?;
    get userDefaultInternalRegex(): string;
    set userDefaultInternalRegex(value: string);
    resetUserDefaultInternalRegex(): void;
    get userDefaultInternalRegexInput(): string | undefined;
    private _userOauthApplications?;
    get userOauthApplications(): boolean | cdktf.IResolvable;
    set userOauthApplications(value: boolean | cdktf.IResolvable);
    resetUserOauthApplications(): void;
    get userOauthApplicationsInput(): boolean | cdktf.IResolvable | undefined;
    private _userShowAddSshKeyMessage?;
    get userShowAddSshKeyMessage(): boolean | cdktf.IResolvable;
    set userShowAddSshKeyMessage(value: boolean | cdktf.IResolvable);
    resetUserShowAddSshKeyMessage(): void;
    get userShowAddSshKeyMessageInput(): boolean | cdktf.IResolvable | undefined;
    private _versionCheckEnabled?;
    get versionCheckEnabled(): boolean | cdktf.IResolvable;
    set versionCheckEnabled(value: boolean | cdktf.IResolvable);
    resetVersionCheckEnabled(): void;
    get versionCheckEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _webIdeClientsidePreviewEnabled?;
    get webIdeClientsidePreviewEnabled(): boolean | cdktf.IResolvable;
    set webIdeClientsidePreviewEnabled(value: boolean | cdktf.IResolvable);
    resetWebIdeClientsidePreviewEnabled(): void;
    get webIdeClientsidePreviewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _whatsNewVariant?;
    get whatsNewVariant(): string;
    set whatsNewVariant(value: string);
    resetWhatsNewVariant(): void;
    get whatsNewVariantInput(): string | undefined;
    private _wikiPageMaxContentBytes?;
    get wikiPageMaxContentBytes(): number;
    set wikiPageMaxContentBytes(value: number);
    resetWikiPageMaxContentBytes(): void;
    get wikiPageMaxContentBytesInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
