from pyspark.sql.types import ArrayType, StringType, StructField, StructType


# noinspection PyPep8Naming
class CapabilityStatement_Messaging:
    @staticmethod
    def get_schema(recursion_depth: int = 0) -> StructType:
        # from https://hl7.org/FHIR/patient.html
        from spark_fhir_schemas.r4.complex_types.extension import Extension
        from spark_fhir_schemas.r4.complex_types.capabilitystatement_endpoint import CapabilityStatement_Endpoint
        from spark_fhir_schemas.r4.complex_types.unsignedint import unsignedInt
        from spark_fhir_schemas.r4.complex_types.markdown import markdown
        from spark_fhir_schemas.r4.complex_types.capabilitystatement_supportedmessage import CapabilityStatement_SupportedMessage
        if recursion_depth > 3:
            return StructType([])
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension",
                    ArrayType(Extension.get_schema(recursion_depth + 1)), True
                ),
                StructField(
                    "modifierExtension",
                    ArrayType(Extension.get_schema(recursion_depth + 1)), True
                ),
                StructField(
                    "endpoint",
                    ArrayType(
                        CapabilityStatement_Endpoint.
                        get_schema(recursion_depth + 1)
                    ), True
                ),
                StructField(
                    "reliableCache",
                    unsignedInt.get_schema(recursion_depth + 1), True
                ),
                StructField(
                    "documentation", markdown.get_schema(recursion_depth + 1),
                    True
                ),
                StructField(
                    "supportedMessage",
                    ArrayType(
                        CapabilityStatement_SupportedMessage.
                        get_schema(recursion_depth + 1)
                    ), True
                ),
            ]
        )

        return schema
