# Copyright (c) 2016 MaxPoint Interactive, Inc.
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
# following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following
#    disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote
#    products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

from distutils.core import setup
from setuptools import find_packages
from os.path import exists
import os
version = "0.1.4"


def write_version_py():
    content = """\
version = '%s'
""" % version

    filename = os.path.join(os.path.dirname(__file__), 'spylon', 'version.py')
    with open(filename, 'w') as fo:
        fo.write(content)


write_version_py()


setup(name='spylon',
      version=version,
      packages=find_packages(),
      package_data={"spylon.spark": ["*.json"]},
      description='Utilities to work with Scala/Java code with py4j',
      long_description=(open('readme.rst').read() if exists('readme.rst') else ''),
      maintainer='MaxPoint Interactive',
      maintainer_email='marius.vanniekerk@maxpoint.com',
      author='MaxPoint Interactive',
      author_email='marius.vanniekerk@maxpoint.com',
      url='https://github.com/maxpoint/spylon',
      license='BSD 3-clause',
      )
