<p align="center">
<img width="33%" height="33%" src="https://mltraq.com/assets/img/logo-black.svg" alt="MLtraq Logo">
</p>

<p align="center">
<img src="https://www.mltraq.com/assets/img/badges/test.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/coverage.svg" alt="Coverage">
<img src="https://www.mltraq.com/assets/img/badges/python.svg" alt="Python">
<img src="https://www.mltraq.com/assets/img/badges/pypi.svg" alt="PyPi">
<img src="https://www.mltraq.com/assets/img/badges/license.svg" alt="License">
<img src="https://www.mltraq.com/assets/img/badges/code-style.svg" alt="Code style">
</p>

---

Open source **experiment tracking API** with **ML performance analysis** to build better models faster, facilitating collaboration and transparency within the team and with stakeholders.

---

* **Documentation**: [https://www.mltraq.com](https://www.mltraq.com)
* **Source code**: [https://github.com/elehcimd/mltraq](https://github.com/elehcimd/mltraq)

---

## Key features

* **Immediate**: start tracking experiments with a few lines of code.
* **Collaborative**: Backup and upstream experimental results with your team.
* **Interoperable**: Access the data anywhere with SQL, Pandas and Python API.
* **Flexible**: Track structured types including Numpy arrays and Pandas frames/series.
* **Steps library**: Use pre-built "steps" for tracking, testing, analysis and reporting.
* **Execution engine**: Define and execute parametrized experiment pipelines.

## Requirements

* **Python >=3.10**
* **SQLAlchemy**, **Pandas**, and **Joblib** (installed as dependencies)

## Installation

```
pip install mltraq
```

## License

This project is licensed under the terms of the [BSD 3-Clause License](https://mltraq.com/license).

