# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['monitor_commander']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'argcomplete>=1.12.3,<2.0.0', 'typedload>=2.12,<3.0']

entry_points = \
{'console_scripts': ['monitor-commander = '
                     'monitor_commander.monitor_commander:main']}

setup_kwargs = {
    'name': 'monitor-commander',
    'version': '0.1.1',
    'description': 'Control your monitors using ddc/ci',
    'long_description': '# monitor-commander\n\nmonitor-commander controls your monitors using [DDC/CI](https://en.wikipedia.org/wiki/Display_Data_Channel).\n\nUse cases:\n - Virtual KVM switch (switch monitors inputs between conputers)\n - Auto monitor settings if you often switch between desks\n\n## Installation\n\n### Supported platforms\n\nYou will need a linux distribution with python3.8 or above.\nIf not possible, check the alternatives section bellow.\n\n### ddcutil\n\nFirst, you will need to install and configure ddcutil. Check the documentation on [install](https://www.ddcutil.com/install/) and [configuration](https://www.ddcutil.com/config/).\n\nTo test your installation, run:\n\n```\n$ sudo ddcutil detect\n```\nIt must report some connected displays For example:\n```\nDisplay 1\n   I2C bus:             /dev/i2c-0\n   EDID synopsis:\n      Mfg id:           DEL\n      Model:            DELL P2411H\n      Serial number:    F8NDP11G119U\n      Manufacture year: 2011\n      EDID version:     1.3\n   VCP version:         2.1\n```\n\n### Dependencies\n\n```\n$ sudo apt install python3-argcomplete python3-typedload python3-yaml\n```\n\n### monitor-commander\n\nCopy the [monitor-commander script](monitor-commander/monitor-commander.py) to `/usr/local/bin/monitor-commander` and make it executable.\n```\n$ sudo chmod +x /usr/local/bin/monitor-commander\n```\n\n## Usage as a KVM Switch\n\nThe concept of the Virtual KVM Switch is to use the different inputs of monitors to plug your different computers.\nYou can the use the presence of a device like your keyboard or mouse to trigger the switch of your monitor(s).\nThis allows you to use much cheaper USB switch instead of a full KVM switch.\n\n### Check Monitor support\n\nFirst step is to check your monitor capabilities. For this VCP feature 60 (Input source is used)\n```\n$ sudo ddcutil -d 1 capabilities\n...\nFeature: 60 (Input Source)\n   Values:\n      0f: DisplayPort-1\n      11: HDMI-1\n...\n```\nHere the monitor has two inputs. Let\'s test that you can switch them.\n```\n$ sudo ddcutil -d 1 setvcp 60 0x0f\n$ sudo ddcutil -d 1 setvcp 60 0x11\n```\n\nIf the monitor is correctly switching, you can continue to next step.\n\nIf you have multiple monitors, repeat by increasing the value of the `-d` parameter.\n\n### Write configuration file\n\nNow you can start to write the configuration file.\nIn this exemple, there are two monitors (named left and right) connected to two computers (laptop and dektop).\n\nFirst let\'s identify the monitors:\n```\n$ sudo monitor-commander monitors\ndisplay: 1\nbus: 0\nmanufacturer: \'DEL\'\nmodel: \'DELL P2411H\'\nserial_number: \'F8NDP11G119U\'\nyear: 2011\nedid_version: \'1.3\'\nvcp_version: \'2.1\'\n=> No match in configured monitors\n\ndisplay: 2\nbus: 1\nmanufacturer: \'ACR\'\nmodel: \'Acer X243W\'\nserial_number: \'LAG040064310\'\nyear: 2007\nedid_version: \'1.3\'\nvcp_version: \'2.1\'\n=> No match in configured monitors\n```\n\nYou can now write the config file `/usr/local/etc/monitor-commander.yml`:\n```yml\nmonitors:\n  - name: left\n    selector:\n      serial_number: LAG040064310\n    presets:\n      desktop:\n        60: "0x11"\n      laptop:\n        60: "0x0f"\n  - name: right\n    selector:\n      serial_number: LAG040064310\n    presets:\n      desktop:\n        60: "0x11"\n      laptop:\n        60: "0x0f"\n```\nNote: One the laptop, replace `default: desktop` by `default: laptop`.\n\nYou should now be able to switch your monitors using\n```\n$ sudo monitor-commander set laptop\n$ sudo monitor-commander set desktop\n```\n\n### Udev rule\n\nThe last step is to automate this when the switch\n\n#### Identify device\n\nNow you need to identify the properties of the device you will use to do trigger the switch.\nRun the following command, plug the device and kill the command with ctrl+C.\nThe output is pretty verbose but you care only about the first block.\n```\n$ sudo udevadm monitor -p -s usb/usb_device\nmonitor will print the received events for:\nUDEV - the event which udev sends out after rule processing\nKERNEL - the kernel uevent\n\nKERNEL[6994.988641] add      /devices/pci0000:00/0000:00:14.0/usb2/2-3 (usb)\nACTION=add\nDEVPATH=/devices/pci0000:00/0000:00:14.0/usb2/2-3\nSUBSYSTEM=usb\nDEVNAME=/dev/bus/usb/002/003\nDEVTYPE=usb_device\nPRODUCT=3a2/936/6354\nTYPE=9/0/3\nBUSNUM=002\nDEVNUM=003\nSEQNUM=512\nMAJOR=189\nMINOR=134\n\n```\n\n#### Write udev rule\n\nMost likelly, you want to identify the device by the PRODUCT string. This is normally unique per usb device model.\nIn case you have several identical devices, you can use DEVPATH instead. Just replace PRODUCT and the associated value by DEVPATH bellow.\n\nCreate file `/etc/udev/rules.d/10-monitor-commander.rules`\n```\nSUBSYSTEM=="usb", ACTION=="add", ENV{DEVTYPE}=="usb_device", ENV{PRODUCT}=="3a2/936/6354", RUN+="/usr/bin/systemd-run --collect -u monitor-commander-udev /usr/local/bin/monitor-commander set desktop"\n```\nOf course replace `desktop` at the end by the name of the preset in the config file.\n\nCongratulation, you should be all set.\n\n#### Debug\n\nIn case of issues, you can use the command bellow\n```\n$ sudo journalctl -fu systemd-udevd --grep monitor-commander\n$ sudo journalctl -fu monitor-commander-udev\n```\n\n## Usage as a generic monitor configuration\n\nMonitors are often default to settings with very high brightness and too much blue.\nIf your company uses shared desk, setting screen every morning can quickly become a burden.\n\n```yml\nmonitors:\n  - name: U3011\n    selector:\n      model: DELL U3011 # Limit to known screen models\n    presets:\n      color:\n        10: 40 # Brightness\n        16: 99 # Video gain: Red\n        18: 99 # Video gain: Green\n        "1A": 90 # Video gain: Blue\n        12: 75 # Contrast\n```\nTo get the values, you can set them manually on your screen and use `sudo ddcutil getvcp ALL` to display the corresponding codes.\n\n```\n$ sudo monitor-commander set color\n```\n## Alternatives\n\n[display-switch](https://github.com/haimgel/display-switch) works for simple virtual KVM switch use cases. Advantage is that it is cross platform and the config files are simpler (but more limited).\n\nFor manual scripting, you can use [ddcutil (Linux)](https://www.ddcutil.com/), [ddcctl (OSX)](https://github.com/kfix/ddcctl), [winddcutil (Windows)](https://github.com/scottaxcell/winddcutil).\n',
    'author': 'Vincent Meurisse',
    'author_email': 'dev@meurisse.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/vmeurisse/monitor-commander',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
