# Generated by Django 3.1.3 on 2021-04-06 08:39

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('dcim', '0122_standardize_name_length'),
        ('ipam', '0043_add_tenancy_to_aggregates'),
        ('tenancy', '0011_standardize_name_length'),
        ('extras', '0053_rename_webhook_obj_type'),
        ('netbox_bgp', '0002_netbox_bgp'),
    ]

    operations = [
        migrations.CreateModel(
            name='BGPSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('status', models.CharField(default='active', max_length=50)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('local_address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='local_address', to='ipam.ipaddress')),
                ('local_as', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='local_as', to='netbox_bgp.asn')),
                ('remote_address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='remote_address', to='ipam.ipaddress')),
                ('remote_as', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='remote_as', to='netbox_bgp.asn')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='dcim.site')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='tenancy.tenant')),
            ],
            options={
                'verbose_name_plural': 'BGP Sessions',
            },
        ),
    ]
