/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.writer;

import com.github.viclovsky.swagger.coverage.SwaggerCoverageWriteException;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.writer.CoverageResultsWriter;
import com.github.viclovsky.swagger.coverage.utils.FreemarkerUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportResultsWriter
implements CoverageResultsWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReportResultsWriter.class);
    private String filename = "swagger-coverage-report.html";
    private String localeCode = "en";
    private String customTemplatePath = null;

    public HtmlReportResultsWriter() {
    }

    public HtmlReportResultsWriter(String localeCode, String filename, String customTemplatePath) {
        if (localeCode != null) {
            this.localeCode = localeCode;
        }
        if (filename != null) {
            this.filename = filename;
        }
        this.customTemplatePath = customTemplatePath;
    }

    @Override
    public void write(Results results) {
        Path path = Paths.get(this.filename, new String[0]);
        LOGGER.info(String.format("Write html report in file '%s'", path.toAbsolutePath()));
        try {
            String htmlReport = this.customTemplatePath == null ? FreemarkerUtils.processTemplate((String)"report.ftl", (String)this.localeCode, (Object)results) : FreemarkerUtils.processCustomTemplate((String)this.customTemplatePath, (String)this.localeCode, (Object)results);
            Files.write(Paths.get(this.filename, new String[0]), htmlReport.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not write results", (Throwable)e);
        }
    }
}

