/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.data;

import com.github.viclovsky.swagger.coverage.configuration.Configuration;
import com.github.viclovsky.swagger.coverage.core.model.Condition;
import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageState;
import java.util.List;

public class OperationResult {
    private boolean excludeDeprecated;
    private OperationKey operationKey;
    private List<Condition> conditions;
    private long allConditionCount;
    private long coveredConditionCount;
    private long processCount;
    private String description;
    private CoverageState state;
    private boolean deprecated;

    public OperationResult(Configuration configuration, List<Condition> conditions, Boolean isDeprecated) {
        this.conditions = conditions;
        this.deprecated = isDeprecated != null ? isDeprecated : false;
        this.allConditionCount = conditions.size();
        this.coveredConditionCount = conditions.stream().filter(Condition::isCovered).count();
        try {
            this.excludeDeprecated = configuration.getOption("exclude-deprecated").isEnable();
        }
        catch (NullPointerException e) {
            this.excludeDeprecated = false;
        }
        this.state = this.deprecated && this.excludeDeprecated ? CoverageState.DEPRECATED : (this.coveredConditionCount == 0L ? CoverageState.EMPTY : (this.allConditionCount == this.coveredConditionCount ? CoverageState.FULL : CoverageState.PARTY));
    }

    public long getAllConditionCount() {
        return this.allConditionCount;
    }

    public OperationResult setAllConditionCount(long allConditionCount) {
        this.allConditionCount = allConditionCount;
        return this;
    }

    public long getCoveredConditionCount() {
        return this.coveredConditionCount;
    }

    public OperationResult setCoveredConditionCount(long coveredConditionCount) {
        this.coveredConditionCount = coveredConditionCount;
        return this;
    }

    public long getProcessCount() {
        return this.processCount;
    }

    public OperationResult setProcessCount(long processCount) {
        this.processCount = processCount;
        return this;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public OperationResult setDescription(String description) {
        this.description = description;
        return this;
    }

    public CoverageState getState() {
        return this.state;
    }

    public OperationResult setState(CoverageState state) {
        this.state = state;
        return this;
    }

    public OperationKey getOperationKey() {
        return this.operationKey;
    }

    public OperationResult setOperationKey(OperationKey operationKey) {
        this.operationKey = operationKey;
        return this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean isDeprecated) {
        this.deprecated = isDeprecated;
    }
}

