/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.predicate;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.predicate.PropertyConditionPredicate;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PropertyValueNotOnlyConditionPredicate
extends PropertyConditionPredicate {
    private List<String> expectedValue = new ArrayList<String>();
    private List<String> currentValue = new ArrayList<String>();
    protected String reason;

    public PropertyValueNotOnlyConditionPredicate(String mediaTypeName, String propertyName, List<String> value) {
        super(mediaTypeName, propertyName);
        this.expectedValue.addAll(value);
    }

    @Override
    public boolean postCheck() {
        boolean covered = this.currentValue.containsAll(this.expectedValue);
        if (!covered) {
            this.expectedValue.removeAll(this.currentValue);
            this.reason = "Missed values " + this.expectedValue.toString();
        }
        return covered;
    }

    @Override
    public boolean hasPostCheck() {
        return true;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    protected boolean check(Optional<Schema> schema) {
        if (schema.isPresent()) {
            this.currentValue.add(SwaggerSpecificationProcessor.extractValue(schema.get()));
        }
        return true;
    }

    public List<String> getValue() {
        return this.expectedValue;
    }

    @Override
    public PropertyValueNotOnlyConditionPredicate setPropertyName(String propertyName) {
        return (PropertyValueNotOnlyConditionPredicate)super.setPropertyName(propertyName);
    }

    @Override
    public PropertyValueNotOnlyConditionPredicate setMediaTypeName(String mediaTypeName) {
        return (PropertyValueNotOnlyConditionPredicate)super.setMediaTypeName(mediaTypeName);
    }

    public PropertyValueNotOnlyConditionPredicate setValue(List<String> value) {
        this.expectedValue = value;
        return this;
    }
}

