# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class LibrariesDefinitionInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None,description=None, version=None, platform=None):
        """
        LibrariesDefinitionInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'version': 'str',
            'platform': 'LibrariesDefinitionInputPlatform',
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'version': 'version',
            'platform': 'platform',
        }

        self._name = name
        self._description = description
        self._version = version
        self._platform = platform

    @property
    def name(self):
        """
        Gets the name of this LibrariesDefinitionInput.


        :return: The name of this LibrariesDefinitionInput.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LibrariesDefinitionInput.


        :param name: The name of this LibrariesDefinitionInput.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this LibrariesDefinitionInput.


        :return: The description of this LibrariesDefinitionInput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LibrariesDefinitionInput.


        :param description: The description of this LibrariesDefinitionInput.
        :type: str
        """
        self._description = description

    @property
    def version(self):
        """
        Gets the version of this LibrariesDefinitionInput.


        :return: The version of this LibrariesDefinitionInput.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this LibrariesDefinitionInput.


        :param version: The version of this LibrariesDefinitionInput.
        :type: str
        """
        self._version = version

    @property
    def platform(self):
        """
        Gets the platform of this LibrariesDefinitionInput.


        :return: The platform of this LibrariesDefinitionInput.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this LibrariesDefinitionInput.


        :param platform: The platform of this LibrariesDefinitionInput.
        :type: str
        """
        self._platform = platform

    @property
    def platform_versions(self):
        """
        Gets the platform_versions of this LibrariesDefinitionInput.


        :return: The platform_versions of this LibrariesDefinitionInput.
        :rtype: list[str]
        """
        return self._platform_versions

    @platform_versions.setter
    def platform_versions(self, platform_versions):
        """
        Sets the platform_versions of this LibrariesDefinitionInput.


        :param platform_versions: The platform_versions of this LibrariesDefinitionInput.
        :type: list[str]
        """
        self._platform_versions = platform_versions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

