# Generated by Django 3.2.5 on 2021-07-21 14:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("torque", "0015_remove_tableofcontentscache_rendered_data"),
    ]

    def create_wikis(apps, schema_editor):
        classes = [
            apps.get_model("torque", "Template"),
            apps.get_model("torque", "CellEdit"),
            apps.get_model("torque", "SearchCacheRow"),
            apps.get_model("torque", "SheetConfig"),
        ]
        Wiki = apps.get_model("torque", "Wiki")
        db_alias = schema_editor.connection.alias
        for c in classes:
            for o in c.objects.using(db_alias).all():
                if o.wiki_key:
                    (wiki, created) = Wiki.objects.get_or_create(wiki_key=o.wiki_key)
                    o.wiki = wiki
                    o.save()

    operations = [
        migrations.CreateModel(
            name="Wiki",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("wiki_key", models.TextField()),
            ],
        ),
        migrations.AddField(
            model_name="celledit",
            name="wiki",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="torque.wiki"
            ),
        ),
        migrations.AddField(
            model_name="searchcacherow",
            name="wiki",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="torque.wiki"
            ),
        ),
        migrations.AddField(
            model_name="sheetconfig",
            name="wiki",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="configs",
                to="torque.wiki",
            ),
        ),
        migrations.AddField(
            model_name="template",
            name="wiki",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="torque.wiki"
            ),
        ),
        migrations.RunPython(create_wikis, None),
    ]
