# coding: utf-8

"""
    Autoenhance API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ReportIn(BaseModel):
    """
    ReportIn
    """ # noqa: E501
    categories: List[StrictStr] = Field(description="A list of categories to be reported.")
    comment: Optional[StrictStr] = Field(default=None, description="A comment to be sent along with the report.")
    score: Optional[Annotated[int, Field(le=5, strict=True, ge=0)]] = Field(default=None, description="A rating between 0 and 5 on how good the image enhancmeent. Higher is better.")
    source: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["categories", "comment", "score", "source"]

    @field_validator('categories')
    def categories_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(['AUTO_PRIVACY', 'COLOUR', 'CONTRAST', 'DOWNLOAD', 'DYNAMIC_RANGE', 'EXPOSURE', 'HDR', 'IMAGE_QUALITY', 'ITEM_REMOVAL', 'LENS_CORRECTION', 'NO_COMPLAINTS', 'NOISE', 'OTHER', 'PERSPECTIVE_CORRECTION', 'PROCESSING', 'SHARPNESS', 'SKY_REPLACEMENT', 'WHITE_BALANCE', 'WINDOW_PULL', 'PRIVACY']):
                raise ValueError("each list item must be one of ('AUTO_PRIVACY', 'COLOUR', 'CONTRAST', 'DOWNLOAD', 'DYNAMIC_RANGE', 'EXPOSURE', 'HDR', 'IMAGE_QUALITY', 'ITEM_REMOVAL', 'LENS_CORRECTION', 'NO_COMPLAINTS', 'NOISE', 'OTHER', 'PERSPECTIVE_CORRECTION', 'PROCESSING', 'SHARPNESS', 'SKY_REPLACEMENT', 'WHITE_BALANCE', 'WINDOW_PULL', 'PRIVACY')")
        return value

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['WEBAPP', 'API']):
            raise ValueError("must be one of enum values ('WEBAPP', 'API')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportIn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportIn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categories": obj.get("categories"),
            "comment": obj.get("comment"),
            "score": obj.get("score"),
            "source": obj.get("source")
        })
        return _obj


