# coding: utf-8

"""
    Autoenhance API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from autoenhance.models.image_out import ImageOut
from typing import Optional, Set
from typing_extensions import Self

class OrderOut(BaseModel):
    """
    OrderOut
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, description="The creation date of the order.")
    images: Optional[List[ImageOut]] = None
    is_deleted: Optional[StrictBool] = Field(default=None, description="The status of the order.")
    is_merging: Optional[StrictBool] = Field(default=None, description="The processing status for the order")
    is_processing: Optional[Any] = Field(default=None, description="The processing status for the order")
    last_updated_at: Optional[datetime] = Field(default=None, description="The last updated date of the order.")
    name: Optional[StrictStr] = Field(default=None, description="The name for the order.")
    order_id: Optional[StrictStr] = Field(default=None, description="The ID for the order.")
    status: Optional[Any] = Field(default=None, description="The status of the order.")
    total_images: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of images in the  order.")
    __properties: ClassVar[List[str]] = ["created_at", "images", "is_deleted", "is_merging", "is_processing", "last_updated_at", "name", "order_id", "status", "total_images"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_processing",
            "status",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['images'] = _items
        # set to None if is_processing (nullable) is None
        # and model_fields_set contains the field
        if self.is_processing is None and "is_processing" in self.model_fields_set:
            _dict['is_processing'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "images": [ImageOut.from_dict(_item) for _item in obj["images"]] if obj.get("images") is not None else None,
            "is_deleted": obj.get("is_deleted"),
            "is_merging": obj.get("is_merging"),
            "is_processing": obj.get("is_processing"),
            "last_updated_at": obj.get("last_updated_at"),
            "name": obj.get("name"),
            "order_id": obj.get("order_id"),
            "status": obj.get("status"),
            "total_images": obj.get("total_images")
        })
        return _obj


