# coding: utf-8

"""
    Autoenhance API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ImageOut(BaseModel):
    """
    ImageOut
    """ # noqa: E501
    ai_version: Optional[StrictStr] = Field(default=None, description="The version of the AI model to use for enhancing the image. Versions ending in an .x will use the latest minor version as soon as it's published.")
    cloud_type: Optional[StrictStr] = Field(default=None, description="The type of clouds in the new sky to replace the original sky with. Options include: CLEAR, LOW_CLOUD, HIGH_CLOUD")
    date_added: Optional[StrictInt] = Field(default=None, description="The date the image was registered with Autoenhance.")
    downloaded: Optional[StrictBool] = Field(default=None, description="Whether image has been already downloaded and paid for.")
    enhance: Optional[StrictBool] = Field(default=True, description="Whether to enhance the image.")
    enhance_type: Optional[StrictStr] = Field(default=None, description="The type of enhancement to apply to the image. PROPERTY or PROPERTY_USA is used with AI version < 4.0, for >= 4.0 use WARM or NEUTRAL..")
    image_id: Optional[StrictStr] = None
    image_name: Optional[StrictStr] = None
    image_type: Optional[StrictStr] = Field(default=None, description="The image type for the image.")
    is_threesixty: Optional[Any] = Field(default=None, description="Whether the image is a 360° image")
    lens_correction: Optional[StrictBool] = Field(default=True, description="Correct any lens distortion in the image.")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata for the image.")
    order_id: Optional[Any] = None
    privacy: Optional[StrictBool] = Field(default=None, description="Whether to blur any faces or license plates in the image.")
    rating: Optional[Annotated[int, Field(le=5, strict=True, ge=0)]] = Field(default=None, description="A rating between 0 and 5 on how good the image enhancmeent. Higher is better.")
    scene: Optional[StrictStr] = Field(default=None, description="The detected scene of the image i.e garden, patio, kitchen, etc.")
    sky_replacement: Optional[StrictBool] = Field(default=None, description="Whether the sky replacement feature was enabled for the image.")
    status: Optional[Any] = Field(default=None, description="The status of the order.")
    status_reason: Optional[Any] = Field(default=None, description="Reason for the image's current status")
    upscale: Optional[StrictBool] = Field(default=None, description="Whether to upscale the image.")
    user_id: Optional[Any] = Field(default=None, description="The user ID of the user who uploaded (owns) the image.")
    vertical_correction: Optional[StrictBool] = Field(default=None, description="Whether the vertical correction feature was enabled for the image.")
    window_pull: Optional[StrictBool] = Field(default=None, description="Whether to pull the windows in the image (used with AI version >= 4.0).")
    __properties: ClassVar[List[str]] = ["ai_version", "cloud_type", "date_added", "downloaded", "enhance", "enhance_type", "image_id", "image_name", "image_type", "is_threesixty", "lens_correction", "metadata", "order_id", "privacy", "rating", "scene", "sky_replacement", "status", "status_reason", "upscale", "user_id", "vertical_correction", "window_pull"]

    @field_validator('ai_version')
    def ai_version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['dev', '4.x', '4.7', '4.5', '4.4', '4.3', '4.2', '4.1', '4.0', '3.x', '3.5', '3.4', '3.3', '3.2', '3.1', '3.0']):
            raise ValueError("must be one of enum values ('dev', '4.x', '4.7', '4.5', '4.4', '4.3', '4.2', '4.1', '4.0', '3.x', '3.5', '3.4', '3.3', '3.2', '3.1', '3.0')")
        return value

    @field_validator('cloud_type')
    def cloud_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CLEAR', 'LOW_CLOUD', 'HIGH_CLOUD']):
            raise ValueError("must be one of enum values ('CLEAR', 'LOW_CLOUD', 'HIGH_CLOUD')")
        return value

    @field_validator('enhance_type')
    def enhance_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['property', 'property_usa', 'warm', 'neutral']):
            raise ValueError("must be one of enum values ('property', 'property_usa', 'warm', 'neutral')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_threesixty",
            "order_id",
            "status",
            "status_reason",
            "user_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if cloud_type (nullable) is None
        # and model_fields_set contains the field
        if self.cloud_type is None and "cloud_type" in self.model_fields_set:
            _dict['cloud_type'] = None

        # set to None if is_threesixty (nullable) is None
        # and model_fields_set contains the field
        if self.is_threesixty is None and "is_threesixty" in self.model_fields_set:
            _dict['is_threesixty'] = None

        # set to None if order_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_id is None and "order_id" in self.model_fields_set:
            _dict['order_id'] = None

        # set to None if privacy (nullable) is None
        # and model_fields_set contains the field
        if self.privacy is None and "privacy" in self.model_fields_set:
            _dict['privacy'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if status_reason (nullable) is None
        # and model_fields_set contains the field
        if self.status_reason is None and "status_reason" in self.model_fields_set:
            _dict['status_reason'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if window_pull (nullable) is None
        # and model_fields_set contains the field
        if self.window_pull is None and "window_pull" in self.model_fields_set:
            _dict['window_pull'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ai_version": obj.get("ai_version"),
            "cloud_type": obj.get("cloud_type"),
            "date_added": obj.get("date_added"),
            "downloaded": obj.get("downloaded"),
            "enhance": obj.get("enhance") if obj.get("enhance") is not None else True,
            "enhance_type": obj.get("enhance_type"),
            "image_id": obj.get("image_id"),
            "image_name": obj.get("image_name"),
            "image_type": obj.get("image_type"),
            "is_threesixty": obj.get("is_threesixty"),
            "lens_correction": obj.get("lens_correction") if obj.get("lens_correction") is not None else True,
            "metadata": obj.get("metadata"),
            "order_id": obj.get("order_id"),
            "privacy": obj.get("privacy"),
            "rating": obj.get("rating"),
            "scene": obj.get("scene"),
            "sky_replacement": obj.get("sky_replacement"),
            "status": obj.get("status"),
            "status_reason": obj.get("status_reason"),
            "upscale": obj.get("upscale"),
            "user_id": obj.get("user_id"),
            "vertical_correction": obj.get("vertical_correction"),
            "window_pull": obj.get("window_pull")
        })
        return _obj


