# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, client_side_availabilities=None, id=None, key=None, name=None, tags=None):
        if client_side_availabilities and not isinstance(client_side_availabilities, list):
            raise TypeError("Expected argument 'client_side_availabilities' to be a list")
        pulumi.set(__self__, "client_side_availabilities", client_side_availabilities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientSideAvailabilities")
    def client_side_availabilities(self) -> Sequence['outputs.GetProjectClientSideAvailabilityResult']:
        """
        A map describing whether flags in this project are available to the client-side JavaScript SDK by default. To learn more, read Nested Client-Side Availability Block.
        """
        return pulumi.get(self, "client_side_availabilities")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The project's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The project's set of tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            client_side_availabilities=self.client_side_availabilities,
            id=self.id,
            key=self.key,
            name=self.name,
            tags=self.tags)


def get_project(key: Optional[str] = None,
                tags: Optional[Sequence[str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Provides a LaunchDarkly project data source.

    This data source allows you to retrieve project information from your LaunchDarkly organization.

    > **Note:** LaunchDarkly data sources do not provide access to the project's environments. If you wish to import environment configurations as data sources you must use the [`Environment` data source](https://www.terraform.io/docs/providers/launchdarkly/d/environment.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_project(key="example-project")
    ```


    :param str key: The project's unique key.
    :param Sequence[str] tags: The project's set of tags.
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        client_side_availabilities=__ret__.client_side_availabilities,
        id=__ret__.id,
        key=__ret__.key,
        name=__ret__.name,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_project)
def get_project_output(key: Optional[pulumi.Input[str]] = None,
                       tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    Provides a LaunchDarkly project data source.

    This data source allows you to retrieve project information from your LaunchDarkly organization.

    > **Note:** LaunchDarkly data sources do not provide access to the project's environments. If you wish to import environment configurations as data sources you must use the [`Environment` data source](https://www.terraform.io/docs/providers/launchdarkly/d/environment.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_project(key="example-project")
    ```


    :param str key: The project's unique key.
    :param Sequence[str] tags: The project's set of tags.
    """
    ...
