# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFeatureFlagEnvironmentResult',
    'AwaitableGetFeatureFlagEnvironmentResult',
    'get_feature_flag_environment',
    'get_feature_flag_environment_output',
]

@pulumi.output_type
class GetFeatureFlagEnvironmentResult:
    """
    A collection of values returned by getFeatureFlagEnvironment.
    """
    def __init__(__self__, env_key=None, fallthrough=None, flag_id=None, id=None, off_variation=None, on=None, prerequisites=None, rules=None, targets=None, track_events=None):
        if env_key and not isinstance(env_key, str):
            raise TypeError("Expected argument 'env_key' to be a str")
        pulumi.set(__self__, "env_key", env_key)
        if fallthrough and not isinstance(fallthrough, dict):
            raise TypeError("Expected argument 'fallthrough' to be a dict")
        pulumi.set(__self__, "fallthrough", fallthrough)
        if flag_id and not isinstance(flag_id, str):
            raise TypeError("Expected argument 'flag_id' to be a str")
        pulumi.set(__self__, "flag_id", flag_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if off_variation and not isinstance(off_variation, int):
            raise TypeError("Expected argument 'off_variation' to be a int")
        pulumi.set(__self__, "off_variation", off_variation)
        if on and not isinstance(on, bool):
            raise TypeError("Expected argument 'on' to be a bool")
        pulumi.set(__self__, "on", on)
        if prerequisites and not isinstance(prerequisites, list):
            raise TypeError("Expected argument 'prerequisites' to be a list")
        pulumi.set(__self__, "prerequisites", prerequisites)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if track_events and not isinstance(track_events, bool):
            raise TypeError("Expected argument 'track_events' to be a bool")
        pulumi.set(__self__, "track_events", track_events)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> str:
        return pulumi.get(self, "env_key")

    @property
    @pulumi.getter
    def fallthrough(self) -> Optional['outputs.GetFeatureFlagEnvironmentFallthroughResult']:
        return pulumi.get(self, "fallthrough")

    @property
    @pulumi.getter(name="flagId")
    def flag_id(self) -> str:
        return pulumi.get(self, "flag_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> Optional[int]:
        """
        The index of the variation served when targeting is disabled.
        """
        return pulumi.get(self, "off_variation")

    @property
    @pulumi.getter
    def on(self) -> Optional[bool]:
        """
        Whether targeting is enabled.
        """
        return pulumi.get(self, "on")

    @property
    @pulumi.getter
    def prerequisites(self) -> Optional[Sequence['outputs.GetFeatureFlagEnvironmentPrerequisiteResult']]:
        """
        List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        """
        return pulumi.get(self, "prerequisites")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.GetFeatureFlagEnvironmentRuleResult']]:
        """
        List of logical targeting rules. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.GetFeatureFlagEnvironmentTargetResult']]:
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="trackEvents")
    def track_events(self) -> Optional[bool]:
        """
        Whether event data will be sent back to LaunchDarkly.
        """
        return pulumi.get(self, "track_events")


class AwaitableGetFeatureFlagEnvironmentResult(GetFeatureFlagEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureFlagEnvironmentResult(
            env_key=self.env_key,
            fallthrough=self.fallthrough,
            flag_id=self.flag_id,
            id=self.id,
            off_variation=self.off_variation,
            on=self.on,
            prerequisites=self.prerequisites,
            rules=self.rules,
            targets=self.targets,
            track_events=self.track_events)


def get_feature_flag_environment(env_key: Optional[str] = None,
                                 fallthrough: Optional[pulumi.InputType['GetFeatureFlagEnvironmentFallthroughArgs']] = None,
                                 flag_id: Optional[str] = None,
                                 off_variation: Optional[int] = None,
                                 on: Optional[bool] = None,
                                 prerequisites: Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentPrerequisiteArgs']]] = None,
                                 rules: Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentRuleArgs']]] = None,
                                 targets: Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentTargetArgs']]] = None,
                                 track_events: Optional[bool] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureFlagEnvironmentResult:
    """
    Provides a LaunchDarkly environment-specific feature flag data source.

    This data source allows you to retrieve environment-specific feature flag information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_feature_flag_environment(env_key="example-env",
        flag_id="example-project/example-flag")
    ```


    :param str env_key: The environment key.
    :param str flag_id: The feature flag's unique `id` in the format `project_key/flag_key`.
    :param int off_variation: The index of the variation served when targeting is disabled.
    :param bool on: Whether targeting is enabled.
    :param Sequence[pulumi.InputType['GetFeatureFlagEnvironmentPrerequisiteArgs']] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
    :param Sequence[pulumi.InputType['GetFeatureFlagEnvironmentRuleArgs']] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
    :param bool track_events: Whether event data will be sent back to LaunchDarkly.
    """
    __args__ = dict()
    __args__['envKey'] = env_key
    __args__['fallthrough'] = fallthrough
    __args__['flagId'] = flag_id
    __args__['offVariation'] = off_variation
    __args__['on'] = on
    __args__['prerequisites'] = prerequisites
    __args__['rules'] = rules
    __args__['targets'] = targets
    __args__['trackEvents'] = track_events
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getFeatureFlagEnvironment:getFeatureFlagEnvironment', __args__, opts=opts, typ=GetFeatureFlagEnvironmentResult).value

    return AwaitableGetFeatureFlagEnvironmentResult(
        env_key=__ret__.env_key,
        fallthrough=__ret__.fallthrough,
        flag_id=__ret__.flag_id,
        id=__ret__.id,
        off_variation=__ret__.off_variation,
        on=__ret__.on,
        prerequisites=__ret__.prerequisites,
        rules=__ret__.rules,
        targets=__ret__.targets,
        track_events=__ret__.track_events)


@_utilities.lift_output_func(get_feature_flag_environment)
def get_feature_flag_environment_output(env_key: Optional[pulumi.Input[str]] = None,
                                        fallthrough: Optional[pulumi.Input[Optional[pulumi.InputType['GetFeatureFlagEnvironmentFallthroughArgs']]]] = None,
                                        flag_id: Optional[pulumi.Input[str]] = None,
                                        off_variation: Optional[pulumi.Input[Optional[int]]] = None,
                                        on: Optional[pulumi.Input[Optional[bool]]] = None,
                                        prerequisites: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentPrerequisiteArgs']]]]] = None,
                                        rules: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentRuleArgs']]]]] = None,
                                        targets: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagEnvironmentTargetArgs']]]]] = None,
                                        track_events: Optional[pulumi.Input[Optional[bool]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeatureFlagEnvironmentResult]:
    """
    Provides a LaunchDarkly environment-specific feature flag data source.

    This data source allows you to retrieve environment-specific feature flag information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_feature_flag_environment(env_key="example-env",
        flag_id="example-project/example-flag")
    ```


    :param str env_key: The environment key.
    :param str flag_id: The feature flag's unique `id` in the format `project_key/flag_key`.
    :param int off_variation: The index of the variation served when targeting is disabled.
    :param bool on: Whether targeting is enabled.
    :param Sequence[pulumi.InputType['GetFeatureFlagEnvironmentPrerequisiteArgs']] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
    :param Sequence[pulumi.InputType['GetFeatureFlagEnvironmentRuleArgs']] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
    :param bool track_events: Whether event data will be sent back to LaunchDarkly.
    """
    ...
