# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class TaskQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instance_id': 'str',
        'process_instance_id_in': 'list[str]',
        'process_instance_business_key': 'str',
        'process_instance_business_key_expression': 'str',
        'process_instance_business_key_in': 'list[str]',
        'process_instance_business_key_like': 'str',
        'process_instance_business_key_like_expression': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_definition_key_in': 'list[str]',
        'process_definition_name': 'str',
        'process_definition_name_like': 'str',
        'execution_id': 'str',
        'case_instance_id': 'str',
        'case_instance_business_key': 'str',
        'case_instance_business_key_like': 'str',
        'case_definition_id': 'str',
        'case_definition_key': 'str',
        'case_definition_name': 'str',
        'case_definition_name_like': 'str',
        'case_execution_id': 'str',
        'activity_instance_id_in': 'list[str]',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'assignee': 'str',
        'assignee_expression': 'str',
        'assignee_like': 'str',
        'assignee_like_expression': 'str',
        'assignee_in': 'list[str]',
        'owner': 'str',
        'owner_expression': 'str',
        'candidate_group': 'str',
        'candidate_group_expression': 'str',
        'candidate_user': 'str',
        'candidate_user_expression': 'str',
        'include_assigned_tasks': 'bool',
        'involved_user': 'str',
        'involved_user_expression': 'str',
        'assigned': 'bool',
        'unassigned': 'bool',
        'task_definition_key': 'str',
        'task_definition_key_in': 'list[str]',
        'task_definition_key_like': 'str',
        'name': 'str',
        'name_not_equal': 'str',
        'name_like': 'str',
        'name_not_like': 'str',
        'description': 'str',
        'description_like': 'str',
        'priority': 'int',
        'max_priority': 'int',
        'min_priority': 'int',
        'due_date': 'datetime',
        'due_date_expression': 'str',
        'due_after': 'datetime',
        'due_after_expression': 'str',
        'due_before': 'datetime',
        'due_before_expression': 'str',
        'follow_up_date': 'datetime',
        'follow_up_date_expression': 'str',
        'follow_up_after': 'datetime',
        'follow_up_after_expression': 'str',
        'follow_up_before': 'str',
        'follow_up_before_expression': 'str',
        'follow_up_before_or_not_existent': 'datetime',
        'follow_up_before_or_not_existent_expression': 'str',
        'created_on': 'datetime',
        'created_on_expression': 'str',
        'created_after': 'datetime',
        'created_after_expression': 'str',
        'created_before': 'datetime',
        'created_before_expression': 'str',
        'delegation_state': 'str',
        'candidate_groups': 'list[str]',
        'candidate_groups_expression': 'str',
        'with_candidate_groups': 'bool',
        'without_candidate_groups': 'bool',
        'with_candidate_users': 'bool',
        'without_candidate_users': 'bool',
        'active': 'bool',
        'suspended': 'bool',
        'task_variables': 'list[VariableQueryParameterDto]',
        'process_variables': 'list[VariableQueryParameterDto]',
        'case_instance_variables': 'list[VariableQueryParameterDto]',
        'variable_names_ignore_case': 'bool',
        'variable_values_ignore_case': 'bool',
        'parent_task_id': 'str',
        'or_queries': 'list[TaskQueryDto]',
        'sorting': 'list[TaskQueryDtoSorting]'
    }

    attribute_map = {
        'process_instance_id': 'processInstanceId',
        'process_instance_id_in': 'processInstanceIdIn',
        'process_instance_business_key': 'processInstanceBusinessKey',
        'process_instance_business_key_expression': 'processInstanceBusinessKeyExpression',
        'process_instance_business_key_in': 'processInstanceBusinessKeyIn',
        'process_instance_business_key_like': 'processInstanceBusinessKeyLike',
        'process_instance_business_key_like_expression': 'processInstanceBusinessKeyLikeExpression',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_key_in': 'processDefinitionKeyIn',
        'process_definition_name': 'processDefinitionName',
        'process_definition_name_like': 'processDefinitionNameLike',
        'execution_id': 'executionId',
        'case_instance_id': 'caseInstanceId',
        'case_instance_business_key': 'caseInstanceBusinessKey',
        'case_instance_business_key_like': 'caseInstanceBusinessKeyLike',
        'case_definition_id': 'caseDefinitionId',
        'case_definition_key': 'caseDefinitionKey',
        'case_definition_name': 'caseDefinitionName',
        'case_definition_name_like': 'caseDefinitionNameLike',
        'case_execution_id': 'caseExecutionId',
        'activity_instance_id_in': 'activityInstanceIdIn',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'assignee': 'assignee',
        'assignee_expression': 'assigneeExpression',
        'assignee_like': 'assigneeLike',
        'assignee_like_expression': 'assigneeLikeExpression',
        'assignee_in': 'assigneeIn',
        'owner': 'owner',
        'owner_expression': 'ownerExpression',
        'candidate_group': 'candidateGroup',
        'candidate_group_expression': 'candidateGroupExpression',
        'candidate_user': 'candidateUser',
        'candidate_user_expression': 'candidateUserExpression',
        'include_assigned_tasks': 'includeAssignedTasks',
        'involved_user': 'involvedUser',
        'involved_user_expression': 'involvedUserExpression',
        'assigned': 'assigned',
        'unassigned': 'unassigned',
        'task_definition_key': 'taskDefinitionKey',
        'task_definition_key_in': 'taskDefinitionKeyIn',
        'task_definition_key_like': 'taskDefinitionKeyLike',
        'name': 'name',
        'name_not_equal': 'nameNotEqual',
        'name_like': 'nameLike',
        'name_not_like': 'nameNotLike',
        'description': 'description',
        'description_like': 'descriptionLike',
        'priority': 'priority',
        'max_priority': 'maxPriority',
        'min_priority': 'minPriority',
        'due_date': 'dueDate',
        'due_date_expression': 'dueDateExpression',
        'due_after': 'dueAfter',
        'due_after_expression': 'dueAfterExpression',
        'due_before': 'dueBefore',
        'due_before_expression': 'dueBeforeExpression',
        'follow_up_date': 'followUpDate',
        'follow_up_date_expression': 'followUpDateExpression',
        'follow_up_after': 'followUpAfter',
        'follow_up_after_expression': 'followUpAfterExpression',
        'follow_up_before': 'followUpBefore',
        'follow_up_before_expression': 'followUpBeforeExpression',
        'follow_up_before_or_not_existent': 'followUpBeforeOrNotExistent',
        'follow_up_before_or_not_existent_expression': 'followUpBeforeOrNotExistentExpression',
        'created_on': 'createdOn',
        'created_on_expression': 'createdOnExpression',
        'created_after': 'createdAfter',
        'created_after_expression': 'createdAfterExpression',
        'created_before': 'createdBefore',
        'created_before_expression': 'createdBeforeExpression',
        'delegation_state': 'delegationState',
        'candidate_groups': 'candidateGroups',
        'candidate_groups_expression': 'candidateGroupsExpression',
        'with_candidate_groups': 'withCandidateGroups',
        'without_candidate_groups': 'withoutCandidateGroups',
        'with_candidate_users': 'withCandidateUsers',
        'without_candidate_users': 'withoutCandidateUsers',
        'active': 'active',
        'suspended': 'suspended',
        'task_variables': 'taskVariables',
        'process_variables': 'processVariables',
        'case_instance_variables': 'caseInstanceVariables',
        'variable_names_ignore_case': 'variableNamesIgnoreCase',
        'variable_values_ignore_case': 'variableValuesIgnoreCase',
        'parent_task_id': 'parentTaskId',
        'or_queries': 'orQueries',
        'sorting': 'sorting'
    }

    def __init__(self, process_instance_id=None, process_instance_id_in=None, process_instance_business_key=None, process_instance_business_key_expression=None, process_instance_business_key_in=None, process_instance_business_key_like=None, process_instance_business_key_like_expression=None, process_definition_id=None, process_definition_key=None, process_definition_key_in=None, process_definition_name=None, process_definition_name_like=None, execution_id=None, case_instance_id=None, case_instance_business_key=None, case_instance_business_key_like=None, case_definition_id=None, case_definition_key=None, case_definition_name=None, case_definition_name_like=None, case_execution_id=None, activity_instance_id_in=None, tenant_id_in=None, without_tenant_id=False, assignee=None, assignee_expression=None, assignee_like=None, assignee_like_expression=None, assignee_in=None, owner=None, owner_expression=None, candidate_group=None, candidate_group_expression=None, candidate_user=None, candidate_user_expression=None, include_assigned_tasks=False, involved_user=None, involved_user_expression=None, assigned=False, unassigned=False, task_definition_key=None, task_definition_key_in=None, task_definition_key_like=None, name=None, name_not_equal=None, name_like=None, name_not_like=None, description=None, description_like=None, priority=None, max_priority=None, min_priority=None, due_date=None, due_date_expression=None, due_after=None, due_after_expression=None, due_before=None, due_before_expression=None, follow_up_date=None, follow_up_date_expression=None, follow_up_after=None, follow_up_after_expression=None, follow_up_before=None, follow_up_before_expression=None, follow_up_before_or_not_existent=None, follow_up_before_or_not_existent_expression=None, created_on=None, created_on_expression=None, created_after=None, created_after_expression=None, created_before=None, created_before_expression=None, delegation_state=None, candidate_groups=None, candidate_groups_expression=None, with_candidate_groups=False, without_candidate_groups=False, with_candidate_users=False, without_candidate_users=False, active=False, suspended=False, task_variables=None, process_variables=None, case_instance_variables=None, variable_names_ignore_case=False, variable_values_ignore_case=False, parent_task_id=None, or_queries=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """TaskQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instance_id = None
        self._process_instance_id_in = None
        self._process_instance_business_key = None
        self._process_instance_business_key_expression = None
        self._process_instance_business_key_in = None
        self._process_instance_business_key_like = None
        self._process_instance_business_key_like_expression = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_definition_key_in = None
        self._process_definition_name = None
        self._process_definition_name_like = None
        self._execution_id = None
        self._case_instance_id = None
        self._case_instance_business_key = None
        self._case_instance_business_key_like = None
        self._case_definition_id = None
        self._case_definition_key = None
        self._case_definition_name = None
        self._case_definition_name_like = None
        self._case_execution_id = None
        self._activity_instance_id_in = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._assignee = None
        self._assignee_expression = None
        self._assignee_like = None
        self._assignee_like_expression = None
        self._assignee_in = None
        self._owner = None
        self._owner_expression = None
        self._candidate_group = None
        self._candidate_group_expression = None
        self._candidate_user = None
        self._candidate_user_expression = None
        self._include_assigned_tasks = None
        self._involved_user = None
        self._involved_user_expression = None
        self._assigned = None
        self._unassigned = None
        self._task_definition_key = None
        self._task_definition_key_in = None
        self._task_definition_key_like = None
        self._name = None
        self._name_not_equal = None
        self._name_like = None
        self._name_not_like = None
        self._description = None
        self._description_like = None
        self._priority = None
        self._max_priority = None
        self._min_priority = None
        self._due_date = None
        self._due_date_expression = None
        self._due_after = None
        self._due_after_expression = None
        self._due_before = None
        self._due_before_expression = None
        self._follow_up_date = None
        self._follow_up_date_expression = None
        self._follow_up_after = None
        self._follow_up_after_expression = None
        self._follow_up_before = None
        self._follow_up_before_expression = None
        self._follow_up_before_or_not_existent = None
        self._follow_up_before_or_not_existent_expression = None
        self._created_on = None
        self._created_on_expression = None
        self._created_after = None
        self._created_after_expression = None
        self._created_before = None
        self._created_before_expression = None
        self._delegation_state = None
        self._candidate_groups = None
        self._candidate_groups_expression = None
        self._with_candidate_groups = None
        self._without_candidate_groups = None
        self._with_candidate_users = None
        self._without_candidate_users = None
        self._active = None
        self._suspended = None
        self._task_variables = None
        self._process_variables = None
        self._case_instance_variables = None
        self._variable_names_ignore_case = None
        self._variable_values_ignore_case = None
        self._parent_task_id = None
        self._or_queries = None
        self._sorting = None
        self.discriminator = None

        if process_instance_id is not None:
            self.process_instance_id = process_instance_id
        if process_instance_id_in is not None:
            self.process_instance_id_in = process_instance_id_in
        if process_instance_business_key is not None:
            self.process_instance_business_key = process_instance_business_key
        if process_instance_business_key_expression is not None:
            self.process_instance_business_key_expression = process_instance_business_key_expression
        if process_instance_business_key_in is not None:
            self.process_instance_business_key_in = process_instance_business_key_in
        if process_instance_business_key_like is not None:
            self.process_instance_business_key_like = process_instance_business_key_like
        if process_instance_business_key_like_expression is not None:
            self.process_instance_business_key_like_expression = process_instance_business_key_like_expression
        if process_definition_id is not None:
            self.process_definition_id = process_definition_id
        if process_definition_key is not None:
            self.process_definition_key = process_definition_key
        if process_definition_key_in is not None:
            self.process_definition_key_in = process_definition_key_in
        if process_definition_name is not None:
            self.process_definition_name = process_definition_name
        if process_definition_name_like is not None:
            self.process_definition_name_like = process_definition_name_like
        if execution_id is not None:
            self.execution_id = execution_id
        if case_instance_id is not None:
            self.case_instance_id = case_instance_id
        if case_instance_business_key is not None:
            self.case_instance_business_key = case_instance_business_key
        if case_instance_business_key_like is not None:
            self.case_instance_business_key_like = case_instance_business_key_like
        if case_definition_id is not None:
            self.case_definition_id = case_definition_id
        if case_definition_key is not None:
            self.case_definition_key = case_definition_key
        if case_definition_name is not None:
            self.case_definition_name = case_definition_name
        if case_definition_name_like is not None:
            self.case_definition_name_like = case_definition_name_like
        if case_execution_id is not None:
            self.case_execution_id = case_execution_id
        if activity_instance_id_in is not None:
            self.activity_instance_id_in = activity_instance_id_in
        if tenant_id_in is not None:
            self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        if assignee is not None:
            self.assignee = assignee
        if assignee_expression is not None:
            self.assignee_expression = assignee_expression
        if assignee_like is not None:
            self.assignee_like = assignee_like
        if assignee_like_expression is not None:
            self.assignee_like_expression = assignee_like_expression
        if assignee_in is not None:
            self.assignee_in = assignee_in
        if owner is not None:
            self.owner = owner
        if owner_expression is not None:
            self.owner_expression = owner_expression
        if candidate_group is not None:
            self.candidate_group = candidate_group
        if candidate_group_expression is not None:
            self.candidate_group_expression = candidate_group_expression
        if candidate_user is not None:
            self.candidate_user = candidate_user
        if candidate_user_expression is not None:
            self.candidate_user_expression = candidate_user_expression
        self.include_assigned_tasks = include_assigned_tasks
        if involved_user is not None:
            self.involved_user = involved_user
        if involved_user_expression is not None:
            self.involved_user_expression = involved_user_expression
        self.assigned = assigned
        self.unassigned = unassigned
        if task_definition_key is not None:
            self.task_definition_key = task_definition_key
        if task_definition_key_in is not None:
            self.task_definition_key_in = task_definition_key_in
        if task_definition_key_like is not None:
            self.task_definition_key_like = task_definition_key_like
        if name is not None:
            self.name = name
        if name_not_equal is not None:
            self.name_not_equal = name_not_equal
        if name_like is not None:
            self.name_like = name_like
        if name_not_like is not None:
            self.name_not_like = name_not_like
        if description is not None:
            self.description = description
        if description_like is not None:
            self.description_like = description_like
        self.priority = priority
        self.max_priority = max_priority
        self.min_priority = min_priority
        self.due_date = due_date
        if due_date_expression is not None:
            self.due_date_expression = due_date_expression
        self.due_after = due_after
        if due_after_expression is not None:
            self.due_after_expression = due_after_expression
        self.due_before = due_before
        if due_before_expression is not None:
            self.due_before_expression = due_before_expression
        self.follow_up_date = follow_up_date
        if follow_up_date_expression is not None:
            self.follow_up_date_expression = follow_up_date_expression
        self.follow_up_after = follow_up_after
        if follow_up_after_expression is not None:
            self.follow_up_after_expression = follow_up_after_expression
        if follow_up_before is not None:
            self.follow_up_before = follow_up_before
        if follow_up_before_expression is not None:
            self.follow_up_before_expression = follow_up_before_expression
        self.follow_up_before_or_not_existent = follow_up_before_or_not_existent
        if follow_up_before_or_not_existent_expression is not None:
            self.follow_up_before_or_not_existent_expression = follow_up_before_or_not_existent_expression
        self.created_on = created_on
        if created_on_expression is not None:
            self.created_on_expression = created_on_expression
        self.created_after = created_after
        if created_after_expression is not None:
            self.created_after_expression = created_after_expression
        self.created_before = created_before
        if created_before_expression is not None:
            self.created_before_expression = created_before_expression
        if delegation_state is not None:
            self.delegation_state = delegation_state
        if candidate_groups is not None:
            self.candidate_groups = candidate_groups
        if candidate_groups_expression is not None:
            self.candidate_groups_expression = candidate_groups_expression
        self.with_candidate_groups = with_candidate_groups
        self.without_candidate_groups = without_candidate_groups
        self.with_candidate_users = with_candidate_users
        self.without_candidate_users = without_candidate_users
        self.active = active
        self.suspended = suspended
        if task_variables is not None:
            self.task_variables = task_variables
        if process_variables is not None:
            self.process_variables = process_variables
        if case_instance_variables is not None:
            self.case_instance_variables = case_instance_variables
        self.variable_names_ignore_case = variable_names_ignore_case
        self.variable_values_ignore_case = variable_values_ignore_case
        if parent_task_id is not None:
            self.parent_task_id = parent_task_id
        if or_queries is not None:
            self.or_queries = or_queries
        if sorting is not None:
            self.sorting = sorting

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to process instances with the given id.  # noqa: E501

        :return: The process_instance_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this TaskQueryDto.

        Restrict to tasks that belong to process instances with the given id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_instance_id_in(self):
        """Gets the process_instance_id_in of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to process instances with the given ids.  # noqa: E501

        :return: The process_instance_id_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_id_in

    @process_instance_id_in.setter
    def process_instance_id_in(self, process_instance_id_in):
        """Sets the process_instance_id_in of this TaskQueryDto.

        Restrict to tasks that belong to process instances with the given ids.  # noqa: E501

        :param process_instance_id_in: The process_instance_id_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_id_in = process_instance_id_in

    @property
    def process_instance_business_key(self):
        """Gets the process_instance_business_key of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to process instances with the given business key.  # noqa: E501

        :return: The process_instance_business_key of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key

    @process_instance_business_key.setter
    def process_instance_business_key(self, process_instance_business_key):
        """Sets the process_instance_business_key of this TaskQueryDto.

        Restrict to tasks that belong to process instances with the given business key.  # noqa: E501

        :param process_instance_business_key: The process_instance_business_key of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key = process_instance_business_key

    @property
    def process_instance_business_key_expression(self):
        """Gets the process_instance_business_key_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.  # noqa: E501

        :return: The process_instance_business_key_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key_expression

    @process_instance_business_key_expression.setter
    def process_instance_business_key_expression(self, process_instance_business_key_expression):
        """Sets the process_instance_business_key_expression of this TaskQueryDto.

        Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.  # noqa: E501

        :param process_instance_business_key_expression: The process_instance_business_key_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key_expression = process_instance_business_key_expression

    @property
    def process_instance_business_key_in(self):
        """Gets the process_instance_business_key_in of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.  # noqa: E501

        :return: The process_instance_business_key_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_business_key_in

    @process_instance_business_key_in.setter
    def process_instance_business_key_in(self, process_instance_business_key_in):
        """Sets the process_instance_business_key_in of this TaskQueryDto.

        Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.  # noqa: E501

        :param process_instance_business_key_in: The process_instance_business_key_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_business_key_in = process_instance_business_key_in

    @property
    def process_instance_business_key_like(self):
        """Gets the process_instance_business_key_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a process instance business key that has the parameter  value as a substring.  # noqa: E501

        :return: The process_instance_business_key_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key_like

    @process_instance_business_key_like.setter
    def process_instance_business_key_like(self, process_instance_business_key_like):
        """Sets the process_instance_business_key_like of this TaskQueryDto.

        Restrict to tasks that have a process instance business key that has the parameter  value as a substring.  # noqa: E501

        :param process_instance_business_key_like: The process_instance_business_key_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key_like = process_instance_business_key_like

    @property
    def process_instance_business_key_like_expression(self):
        """Gets the process_instance_business_key_like_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The process_instance_business_key_like_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key_like_expression

    @process_instance_business_key_like_expression.setter
    def process_instance_business_key_like_expression(self, process_instance_business_key_like_expression):
        """Sets the process_instance_business_key_like_expression of this TaskQueryDto.

        Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param process_instance_business_key_like_expression: The process_instance_business_key_like_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key_like_expression = process_instance_business_key_like_expression

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with the given id.  # noqa: E501

        :return: The process_definition_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this TaskQueryDto.

        Restrict to tasks that belong to a process definition with the given id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with the given key.  # noqa: E501

        :return: The process_definition_key of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this TaskQueryDto.

        Restrict to tasks that belong to a process definition with the given key.  # noqa: E501

        :param process_definition_key: The process_definition_key of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_key_in(self):
        """Gets the process_definition_key_in of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.  # noqa: E501

        :return: The process_definition_key_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_definition_key_in

    @process_definition_key_in.setter
    def process_definition_key_in(self, process_definition_key_in):
        """Sets the process_definition_key_in of this TaskQueryDto.

        Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.  # noqa: E501

        :param process_definition_key_in: The process_definition_key_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_definition_key_in = process_definition_key_in

    @property
    def process_definition_name(self):
        """Gets the process_definition_name of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with the given name.  # noqa: E501

        :return: The process_definition_name of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name

    @process_definition_name.setter
    def process_definition_name(self, process_definition_name):
        """Sets the process_definition_name of this TaskQueryDto.

        Restrict to tasks that belong to a process definition with the given name.  # noqa: E501

        :param process_definition_name: The process_definition_name of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name = process_definition_name

    @property
    def process_definition_name_like(self):
        """Gets the process_definition_name_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a process definition name that has the parameter value as  a substring.  # noqa: E501

        :return: The process_definition_name_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name_like

    @process_definition_name_like.setter
    def process_definition_name_like(self, process_definition_name_like):
        """Sets the process_definition_name_like of this TaskQueryDto.

        Restrict to tasks that have a process definition name that has the parameter value as  a substring.  # noqa: E501

        :param process_definition_name_like: The process_definition_name_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name_like = process_definition_name_like

    @property
    def execution_id(self):
        """Gets the execution_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to an execution with the given id.  # noqa: E501

        :return: The execution_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this TaskQueryDto.

        Restrict to tasks that belong to an execution with the given id.  # noqa: E501

        :param execution_id: The execution_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to case instances with the given id.  # noqa: E501

        :return: The case_instance_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this TaskQueryDto.

        Restrict to tasks that belong to case instances with the given id.  # noqa: E501

        :param case_instance_id: The case_instance_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def case_instance_business_key(self):
        """Gets the case_instance_business_key of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to case instances with the given business key.  # noqa: E501

        :return: The case_instance_business_key of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_business_key

    @case_instance_business_key.setter
    def case_instance_business_key(self, case_instance_business_key):
        """Sets the case_instance_business_key of this TaskQueryDto.

        Restrict to tasks that belong to case instances with the given business key.  # noqa: E501

        :param case_instance_business_key: The case_instance_business_key of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_business_key = case_instance_business_key

    @property
    def case_instance_business_key_like(self):
        """Gets the case_instance_business_key_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a case instance business key that has the parameter value  as a substring.  # noqa: E501

        :return: The case_instance_business_key_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_business_key_like

    @case_instance_business_key_like.setter
    def case_instance_business_key_like(self, case_instance_business_key_like):
        """Sets the case_instance_business_key_like of this TaskQueryDto.

        Restrict to tasks that have a case instance business key that has the parameter value  as a substring.  # noqa: E501

        :param case_instance_business_key_like: The case_instance_business_key_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_business_key_like = case_instance_business_key_like

    @property
    def case_definition_id(self):
        """Gets the case_definition_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case definition with the given id.  # noqa: E501

        :return: The case_definition_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_id

    @case_definition_id.setter
    def case_definition_id(self, case_definition_id):
        """Sets the case_definition_id of this TaskQueryDto.

        Restrict to tasks that belong to a case definition with the given id.  # noqa: E501

        :param case_definition_id: The case_definition_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_id = case_definition_id

    @property
    def case_definition_key(self):
        """Gets the case_definition_key of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case definition with the given key.  # noqa: E501

        :return: The case_definition_key of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_key

    @case_definition_key.setter
    def case_definition_key(self, case_definition_key):
        """Sets the case_definition_key of this TaskQueryDto.

        Restrict to tasks that belong to a case definition with the given key.  # noqa: E501

        :param case_definition_key: The case_definition_key of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_key = case_definition_key

    @property
    def case_definition_name(self):
        """Gets the case_definition_name of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case definition with the given name.  # noqa: E501

        :return: The case_definition_name of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_name

    @case_definition_name.setter
    def case_definition_name(self, case_definition_name):
        """Sets the case_definition_name of this TaskQueryDto.

        Restrict to tasks that belong to a case definition with the given name.  # noqa: E501

        :param case_definition_name: The case_definition_name of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_name = case_definition_name

    @property
    def case_definition_name_like(self):
        """Gets the case_definition_name_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a case definition name that has the parameter value as a  substring.  # noqa: E501

        :return: The case_definition_name_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_name_like

    @case_definition_name_like.setter
    def case_definition_name_like(self, case_definition_name_like):
        """Sets the case_definition_name_like of this TaskQueryDto.

        Restrict to tasks that have a case definition name that has the parameter value as a  substring.  # noqa: E501

        :param case_definition_name_like: The case_definition_name_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_name_like = case_definition_name_like

    @property
    def case_execution_id(self):
        """Gets the case_execution_id of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case execution with the given id.  # noqa: E501

        :return: The case_execution_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_execution_id

    @case_execution_id.setter
    def case_execution_id(self, case_execution_id):
        """Sets the case_execution_id of this TaskQueryDto.

        Restrict to tasks that belong to a case execution with the given id.  # noqa: E501

        :param case_execution_id: The case_execution_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._case_execution_id = case_execution_id

    @property
    def activity_instance_id_in(self):
        """Gets the activity_instance_id_in of this TaskQueryDto.  # noqa: E501

        Only include tasks which belong to one of the passed and comma-separated activity  instance ids.  # noqa: E501

        :return: The activity_instance_id_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_instance_id_in

    @activity_instance_id_in.setter
    def activity_instance_id_in(self, activity_instance_id_in):
        """Sets the activity_instance_id_in of this TaskQueryDto.

        Only include tasks which belong to one of the passed and comma-separated activity  instance ids.  # noqa: E501

        :param activity_instance_id_in: The activity_instance_id_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_instance_id_in = activity_instance_id_in

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this TaskQueryDto.  # noqa: E501

        Only include tasks which belong to one of the passed and comma-separated  tenant ids.  # noqa: E501

        :return: The tenant_id_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this TaskQueryDto.

        Only include tasks which belong to one of the passed and comma-separated  tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this TaskQueryDto.  # noqa: E501

        Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this TaskQueryDto.

        Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def assignee(self):
        """Gets the assignee of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that the given user is assigned to.  # noqa: E501

        :return: The assignee of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this TaskQueryDto.

        Restrict to tasks that the given user is assigned to.  # noqa: E501

        :param assignee: The assignee of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._assignee = assignee

    @property
    def assignee_expression(self):
        """Gets the assignee_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that the user described by the given expression is assigned to. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The assignee_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee_expression

    @assignee_expression.setter
    def assignee_expression(self, assignee_expression):
        """Sets the assignee_expression of this TaskQueryDto.

        Restrict to tasks that the user described by the given expression is assigned to. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param assignee_expression: The assignee_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._assignee_expression = assignee_expression

    @property
    def assignee_like(self):
        """Gets the assignee_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have an assignee that has the parameter  value as a substring.  # noqa: E501

        :return: The assignee_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee_like

    @assignee_like.setter
    def assignee_like(self, assignee_like):
        """Sets the assignee_like of this TaskQueryDto.

        Restrict to tasks that have an assignee that has the parameter  value as a substring.  # noqa: E501

        :param assignee_like: The assignee_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._assignee_like = assignee_like

    @property
    def assignee_like_expression(self):
        """Gets the assignee_like_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The assignee_like_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee_like_expression

    @assignee_like_expression.setter
    def assignee_like_expression(self, assignee_like_expression):
        """Sets the assignee_like_expression of this TaskQueryDto.

        Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param assignee_like_expression: The assignee_like_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._assignee_like_expression = assignee_like_expression

    @property
    def assignee_in(self):
        """Gets the assignee_in of this TaskQueryDto.  # noqa: E501

        Only include tasks which are assigned to one of the passed and comma-separated user ids.  # noqa: E501

        :return: The assignee_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._assignee_in

    @assignee_in.setter
    def assignee_in(self, assignee_in):
        """Sets the assignee_in of this TaskQueryDto.

        Only include tasks which are assigned to one of the passed and comma-separated user ids.  # noqa: E501

        :param assignee_in: The assignee_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._assignee_in = assignee_in

    @property
    def owner(self):
        """Gets the owner of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that the given user owns.  # noqa: E501

        :return: The owner of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this TaskQueryDto.

        Restrict to tasks that the given user owns.  # noqa: E501

        :param owner: The owner of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._owner = owner

    @property
    def owner_expression(self):
        """Gets the owner_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The owner_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._owner_expression

    @owner_expression.setter
    def owner_expression(self, owner_expression):
        """Sets the owner_expression of this TaskQueryDto.

        Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param owner_expression: The owner_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._owner_expression = owner_expression

    @property
    def candidate_group(self):
        """Gets the candidate_group of this TaskQueryDto.  # noqa: E501

        Only include tasks that are offered to the given group.  # noqa: E501

        :return: The candidate_group of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._candidate_group

    @candidate_group.setter
    def candidate_group(self, candidate_group):
        """Sets the candidate_group of this TaskQueryDto.

        Only include tasks that are offered to the given group.  # noqa: E501

        :param candidate_group: The candidate_group of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._candidate_group = candidate_group

    @property
    def candidate_group_expression(self):
        """Gets the candidate_group_expression of this TaskQueryDto.  # noqa: E501

        Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The candidate_group_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._candidate_group_expression

    @candidate_group_expression.setter
    def candidate_group_expression(self, candidate_group_expression):
        """Sets the candidate_group_expression of this TaskQueryDto.

        Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param candidate_group_expression: The candidate_group_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._candidate_group_expression = candidate_group_expression

    @property
    def candidate_user(self):
        """Gets the candidate_user of this TaskQueryDto.  # noqa: E501

        Only include tasks that are offered to the given user or to one of his groups.  # noqa: E501

        :return: The candidate_user of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._candidate_user

    @candidate_user.setter
    def candidate_user(self, candidate_user):
        """Sets the candidate_user of this TaskQueryDto.

        Only include tasks that are offered to the given user or to one of his groups.  # noqa: E501

        :param candidate_user: The candidate_user of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._candidate_user = candidate_user

    @property
    def candidate_user_expression(self):
        """Gets the candidate_user_expression of this TaskQueryDto.  # noqa: E501

        Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :return: The candidate_user_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._candidate_user_expression

    @candidate_user_expression.setter
    def candidate_user_expression(self, candidate_user_expression):
        """Sets the candidate_user_expression of this TaskQueryDto.

        Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.  # noqa: E501

        :param candidate_user_expression: The candidate_user_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._candidate_user_expression = candidate_user_expression

    @property
    def include_assigned_tasks(self):
        """Gets the include_assigned_tasks of this TaskQueryDto.  # noqa: E501

        Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).  # noqa: E501

        :return: The include_assigned_tasks of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_assigned_tasks

    @include_assigned_tasks.setter
    def include_assigned_tasks(self, include_assigned_tasks):
        """Sets the include_assigned_tasks of this TaskQueryDto.

        Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).  # noqa: E501

        :param include_assigned_tasks: The include_assigned_tasks of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._include_assigned_tasks = include_assigned_tasks

    @property
    def involved_user(self):
        """Gets the involved_user of this TaskQueryDto.  # noqa: E501

        Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).  # noqa: E501

        :return: The involved_user of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._involved_user

    @involved_user.setter
    def involved_user(self, involved_user):
        """Sets the involved_user of this TaskQueryDto.

        Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).  # noqa: E501

        :param involved_user: The involved_user of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._involved_user = involved_user

    @property
    def involved_user_expression(self):
        """Gets the involved_user_expression of this TaskQueryDto.  # noqa: E501

        Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.  # noqa: E501

        :return: The involved_user_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._involved_user_expression

    @involved_user_expression.setter
    def involved_user_expression(self, involved_user_expression):
        """Sets the involved_user_expression of this TaskQueryDto.

        Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.  # noqa: E501

        :param involved_user_expression: The involved_user_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._involved_user_expression = involved_user_expression

    @property
    def assigned(self):
        """Gets the assigned of this TaskQueryDto.  # noqa: E501

        If set to `true`, restricts the query to all tasks that are assigned.  # noqa: E501

        :return: The assigned of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._assigned

    @assigned.setter
    def assigned(self, assigned):
        """Sets the assigned of this TaskQueryDto.

        If set to `true`, restricts the query to all tasks that are assigned.  # noqa: E501

        :param assigned: The assigned of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._assigned = assigned

    @property
    def unassigned(self):
        """Gets the unassigned of this TaskQueryDto.  # noqa: E501

        If set to `true`, restricts the query to all tasks that are unassigned.  # noqa: E501

        :return: The unassigned of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._unassigned

    @unassigned.setter
    def unassigned(self, unassigned):
        """Sets the unassigned of this TaskQueryDto.

        If set to `true`, restricts the query to all tasks that are unassigned.  # noqa: E501

        :param unassigned: The unassigned of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._unassigned = unassigned

    @property
    def task_definition_key(self):
        """Gets the task_definition_key of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have the given key.  # noqa: E501

        :return: The task_definition_key of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_definition_key

    @task_definition_key.setter
    def task_definition_key(self, task_definition_key):
        """Sets the task_definition_key of this TaskQueryDto.

        Restrict to tasks that have the given key.  # noqa: E501

        :param task_definition_key: The task_definition_key of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._task_definition_key = task_definition_key

    @property
    def task_definition_key_in(self):
        """Gets the task_definition_key_in of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.  # noqa: E501

        :return: The task_definition_key_in of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._task_definition_key_in

    @task_definition_key_in.setter
    def task_definition_key_in(self, task_definition_key_in):
        """Sets the task_definition_key_in of this TaskQueryDto.

        Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.  # noqa: E501

        :param task_definition_key_in: The task_definition_key_in of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._task_definition_key_in = task_definition_key_in

    @property
    def task_definition_key_like(self):
        """Gets the task_definition_key_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a key that has the parameter value as a substring.  # noqa: E501

        :return: The task_definition_key_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_definition_key_like

    @task_definition_key_like.setter
    def task_definition_key_like(self, task_definition_key_like):
        """Sets the task_definition_key_like of this TaskQueryDto.

        Restrict to tasks that have a key that has the parameter value as a substring.  # noqa: E501

        :param task_definition_key_like: The task_definition_key_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._task_definition_key_like = task_definition_key_like

    @property
    def name(self):
        """Gets the name of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have the given name.  # noqa: E501

        :return: The name of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TaskQueryDto.

        Restrict to tasks that have the given name.  # noqa: E501

        :param name: The name of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_not_equal(self):
        """Gets the name_not_equal of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that do not have the given name.  # noqa: E501

        :return: The name_not_equal of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name_not_equal

    @name_not_equal.setter
    def name_not_equal(self, name_not_equal):
        """Sets the name_not_equal of this TaskQueryDto.

        Restrict to tasks that do not have the given name.  # noqa: E501

        :param name_not_equal: The name_not_equal of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._name_not_equal = name_not_equal

    @property
    def name_like(self):
        """Gets the name_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a name with the given parameter value as substring.  # noqa: E501

        :return: The name_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name_like

    @name_like.setter
    def name_like(self, name_like):
        """Sets the name_like of this TaskQueryDto.

        Restrict to tasks that have a name with the given parameter value as substring.  # noqa: E501

        :param name_like: The name_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._name_like = name_like

    @property
    def name_not_like(self):
        """Gets the name_not_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that do not have a name with the given parameter value as substring.  # noqa: E501

        :return: The name_not_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name_not_like

    @name_not_like.setter
    def name_not_like(self, name_not_like):
        """Sets the name_not_like of this TaskQueryDto.

        Restrict to tasks that do not have a name with the given parameter value as substring.  # noqa: E501

        :param name_not_like: The name_not_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._name_not_like = name_not_like

    @property
    def description(self):
        """Gets the description of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have the given description.  # noqa: E501

        :return: The description of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TaskQueryDto.

        Restrict to tasks that have the given description.  # noqa: E501

        :param description: The description of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def description_like(self):
        """Gets the description_like of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a description that has the parameter value as a substring.  # noqa: E501

        :return: The description_like of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._description_like

    @description_like.setter
    def description_like(self, description_like):
        """Sets the description_like of this TaskQueryDto.

        Restrict to tasks that have a description that has the parameter value as a substring.  # noqa: E501

        :param description_like: The description_like of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._description_like = description_like

    @property
    def priority(self):
        """Gets the priority of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have the given priority.  # noqa: E501

        :return: The priority of this TaskQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this TaskQueryDto.

        Restrict to tasks that have the given priority.  # noqa: E501

        :param priority: The priority of this TaskQueryDto.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def max_priority(self):
        """Gets the max_priority of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a lower or equal priority.  # noqa: E501

        :return: The max_priority of this TaskQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._max_priority

    @max_priority.setter
    def max_priority(self, max_priority):
        """Sets the max_priority of this TaskQueryDto.

        Restrict to tasks that have a lower or equal priority.  # noqa: E501

        :param max_priority: The max_priority of this TaskQueryDto.  # noqa: E501
        :type: int
        """

        self._max_priority = max_priority

    @property
    def min_priority(self):
        """Gets the min_priority of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a higher or equal priority.  # noqa: E501

        :return: The min_priority of this TaskQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._min_priority

    @min_priority.setter
    def min_priority(self, min_priority):
        """Sets the min_priority of this TaskQueryDto.

        Restrict to tasks that have a higher or equal priority.  # noqa: E501

        :param min_priority: The min_priority of this TaskQueryDto.  # noqa: E501
        :type: int
        """

        self._min_priority = min_priority

    @property
    def due_date(self):
        """Gets the due_date of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.  # noqa: E501

        :return: The due_date of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this TaskQueryDto.

        Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.  # noqa: E501

        :param due_date: The due_date of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def due_date_expression(self):
        """Gets the due_date_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The due_date_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._due_date_expression

    @due_date_expression.setter
    def due_date_expression(self, due_date_expression):
        """Sets the due_date_expression of this TaskQueryDto.

        Restrict to tasks that are due on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param due_date_expression: The due_date_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._due_date_expression = due_date_expression

    @property
    def due_after(self):
        """Gets the due_after of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.  # noqa: E501

        :return: The due_after of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._due_after

    @due_after.setter
    def due_after(self, due_after):
        """Sets the due_after of this TaskQueryDto.

        Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.  # noqa: E501

        :param due_after: The due_after of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._due_after = due_after

    @property
    def due_after_expression(self):
        """Gets the due_after_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The due_after_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._due_after_expression

    @due_after_expression.setter
    def due_after_expression(self, due_after_expression):
        """Sets the due_after_expression of this TaskQueryDto.

        Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param due_after_expression: The due_after_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._due_after_expression = due_after_expression

    @property
    def due_before(self):
        """Gets the due_before of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.  # noqa: E501

        :return: The due_before of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._due_before

    @due_before.setter
    def due_before(self, due_before):
        """Sets the due_before of this TaskQueryDto.

        Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.  # noqa: E501

        :param due_before: The due_before of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._due_before = due_before

    @property
    def due_before_expression(self):
        """Gets the due_before_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The due_before_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._due_before_expression

    @due_before_expression.setter
    def due_before_expression(self, due_before_expression):
        """Sets the due_before_expression of this TaskQueryDto.

        Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param due_before_expression: The due_before_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._due_before_expression = due_before_expression

    @property
    def follow_up_date(self):
        """Gets the follow_up_date of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.  # noqa: E501

        :return: The follow_up_date of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._follow_up_date

    @follow_up_date.setter
    def follow_up_date(self, follow_up_date):
        """Sets the follow_up_date of this TaskQueryDto.

        Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.  # noqa: E501

        :param follow_up_date: The follow_up_date of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._follow_up_date = follow_up_date

    @property
    def follow_up_date_expression(self):
        """Gets the follow_up_date_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The follow_up_date_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._follow_up_date_expression

    @follow_up_date_expression.setter
    def follow_up_date_expression(self, follow_up_date_expression):
        """Sets the follow_up_date_expression of this TaskQueryDto.

        Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param follow_up_date_expression: The follow_up_date_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._follow_up_date_expression = follow_up_date_expression

    @property
    def follow_up_after(self):
        """Gets the follow_up_after of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.  # noqa: E501

        :return: The follow_up_after of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._follow_up_after

    @follow_up_after.setter
    def follow_up_after(self, follow_up_after):
        """Sets the follow_up_after of this TaskQueryDto.

        Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.  # noqa: E501

        :param follow_up_after: The follow_up_after of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._follow_up_after = follow_up_after

    @property
    def follow_up_after_expression(self):
        """Gets the follow_up_after_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The follow_up_after_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._follow_up_after_expression

    @follow_up_after_expression.setter
    def follow_up_after_expression(self, follow_up_after_expression):
        """Sets the follow_up_after_expression of this TaskQueryDto.

        Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param follow_up_after_expression: The follow_up_after_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._follow_up_after_expression = follow_up_after_expression

    @property
    def follow_up_before(self):
        """Gets the follow_up_before of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.  # noqa: E501

        :return: The follow_up_before of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._follow_up_before

    @follow_up_before.setter
    def follow_up_before(self, follow_up_before):
        """Sets the follow_up_before of this TaskQueryDto.

        Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.  # noqa: E501

        :param follow_up_before: The follow_up_before of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._follow_up_before = follow_up_before

    @property
    def follow_up_before_expression(self):
        """Gets the follow_up_before_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The follow_up_before_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._follow_up_before_expression

    @follow_up_before_expression.setter
    def follow_up_before_expression(self, follow_up_before_expression):
        """Sets the follow_up_before_expression of this TaskQueryDto.

        Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param follow_up_before_expression: The follow_up_before_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._follow_up_before_expression = follow_up_before_expression

    @property
    def follow_up_before_or_not_existent(self):
        """Gets the follow_up_before_or_not_existent of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.  # noqa: E501

        :return: The follow_up_before_or_not_existent of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._follow_up_before_or_not_existent

    @follow_up_before_or_not_existent.setter
    def follow_up_before_or_not_existent(self, follow_up_before_or_not_existent):
        """Sets the follow_up_before_or_not_existent of this TaskQueryDto.

        Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.  # noqa: E501

        :param follow_up_before_or_not_existent: The follow_up_before_or_not_existent of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._follow_up_before_or_not_existent = follow_up_before_or_not_existent

    @property
    def follow_up_before_or_not_existent_expression(self):
        """Gets the follow_up_before_or_not_existent_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The follow_up_before_or_not_existent_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._follow_up_before_or_not_existent_expression

    @follow_up_before_or_not_existent_expression.setter
    def follow_up_before_or_not_existent_expression(self, follow_up_before_or_not_existent_expression):
        """Sets the follow_up_before_or_not_existent_expression of this TaskQueryDto.

        Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param follow_up_before_or_not_existent_expression: The follow_up_before_or_not_existent_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._follow_up_before_or_not_existent_expression = follow_up_before_or_not_existent_expression

    @property
    def created_on(self):
        """Gets the created_on of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.  # noqa: E501

        :return: The created_on of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this TaskQueryDto.

        Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.  # noqa: E501

        :param created_on: The created_on of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._created_on = created_on

    @property
    def created_on_expression(self):
        """Gets the created_on_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The created_on_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._created_on_expression

    @created_on_expression.setter
    def created_on_expression(self, created_on_expression):
        """Sets the created_on_expression of this TaskQueryDto.

        Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param created_on_expression: The created_on_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._created_on_expression = created_on_expression

    @property
    def created_after(self):
        """Gets the created_after of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.  # noqa: E501

        :return: The created_after of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_after

    @created_after.setter
    def created_after(self, created_after):
        """Sets the created_after of this TaskQueryDto.

        Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.  # noqa: E501

        :param created_after: The created_after of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._created_after = created_after

    @property
    def created_after_expression(self):
        """Gets the created_after_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The created_after_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._created_after_expression

    @created_after_expression.setter
    def created_after_expression(self, created_after_expression):
        """Sets the created_after_expression of this TaskQueryDto.

        Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param created_after_expression: The created_after_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._created_after_expression = created_after_expression

    @property
    def created_before(self):
        """Gets the created_before of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.  # noqa: E501

        :return: The created_before of this TaskQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_before

    @created_before.setter
    def created_before(self, created_before):
        """Sets the created_before of this TaskQueryDto.

        Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.  # noqa: E501

        :param created_before: The created_before of this TaskQueryDto.  # noqa: E501
        :type: datetime
        """

        self._created_before = created_before

    @property
    def created_before_expression(self):
        """Gets the created_before_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :return: The created_before_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._created_before_expression

    @created_before_expression.setter
    def created_before_expression(self, created_before_expression):
        """Sets the created_before_expression of this TaskQueryDto.

        Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.  # noqa: E501

        :param created_before_expression: The created_before_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._created_before_expression = created_before_expression

    @property
    def delegation_state(self):
        """Gets the delegation_state of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.  # noqa: E501

        :return: The delegation_state of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._delegation_state

    @delegation_state.setter
    def delegation_state(self, delegation_state):
        """Sets the delegation_state of this TaskQueryDto.

        Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.  # noqa: E501

        :param delegation_state: The delegation_state of this TaskQueryDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["PENDING", "RESOLVED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and delegation_state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `delegation_state` ({0}), must be one of {1}"  # noqa: E501
                .format(delegation_state, allowed_values)
            )

        self._delegation_state = delegation_state

    @property
    def candidate_groups(self):
        """Gets the candidate_groups of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.  # noqa: E501

        :return: The candidate_groups of this TaskQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._candidate_groups

    @candidate_groups.setter
    def candidate_groups(self, candidate_groups):
        """Sets the candidate_groups of this TaskQueryDto.

        Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.  # noqa: E501

        :param candidate_groups: The candidate_groups of this TaskQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._candidate_groups = candidate_groups

    @property
    def candidate_groups_expression(self):
        """Gets the candidate_groups_expression of this TaskQueryDto.  # noqa: E501

        Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.  # noqa: E501

        :return: The candidate_groups_expression of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._candidate_groups_expression

    @candidate_groups_expression.setter
    def candidate_groups_expression(self, candidate_groups_expression):
        """Sets the candidate_groups_expression of this TaskQueryDto.

        Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.  # noqa: E501

        :param candidate_groups_expression: The candidate_groups_expression of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._candidate_groups_expression = candidate_groups_expression

    @property
    def with_candidate_groups(self):
        """Gets the with_candidate_groups of this TaskQueryDto.  # noqa: E501

        Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_candidate_groups of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_candidate_groups

    @with_candidate_groups.setter
    def with_candidate_groups(self, with_candidate_groups):
        """Sets the with_candidate_groups of this TaskQueryDto.

        Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_candidate_groups: The with_candidate_groups of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_candidate_groups = with_candidate_groups

    @property
    def without_candidate_groups(self):
        """Gets the without_candidate_groups of this TaskQueryDto.  # noqa: E501

        Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_candidate_groups of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_candidate_groups

    @without_candidate_groups.setter
    def without_candidate_groups(self, without_candidate_groups):
        """Sets the without_candidate_groups of this TaskQueryDto.

        Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_candidate_groups: The without_candidate_groups of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_candidate_groups = without_candidate_groups

    @property
    def with_candidate_users(self):
        """Gets the with_candidate_users of this TaskQueryDto.  # noqa: E501

        Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_candidate_users of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_candidate_users

    @with_candidate_users.setter
    def with_candidate_users(self, with_candidate_users):
        """Sets the with_candidate_users of this TaskQueryDto.

        Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_candidate_users: The with_candidate_users of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_candidate_users = with_candidate_users

    @property
    def without_candidate_users(self):
        """Gets the without_candidate_users of this TaskQueryDto.  # noqa: E501

        Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_candidate_users of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_candidate_users

    @without_candidate_users.setter
    def without_candidate_users(self, without_candidate_users):
        """Sets the without_candidate_users of this TaskQueryDto.

        Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_candidate_users: The without_candidate_users of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_candidate_users = without_candidate_users

    @property
    def active(self):
        """Gets the active of this TaskQueryDto.  # noqa: E501

        Only include active tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The active of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this TaskQueryDto.

        Only include active tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param active: The active of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this TaskQueryDto.  # noqa: E501

        Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The suspended of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this TaskQueryDto.

        Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param suspended: The suspended of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def task_variables(self):
        """Gets the task_variables of this TaskQueryDto.  # noqa: E501

        A JSON array to only include tasks that have variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :return: The task_variables of this TaskQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._task_variables

    @task_variables.setter
    def task_variables(self, task_variables):
        """Sets the task_variables of this TaskQueryDto.

        A JSON array to only include tasks that have variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :param task_variables: The task_variables of this TaskQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._task_variables = task_variables

    @property
    def process_variables(self):
        """Gets the process_variables of this TaskQueryDto.  # noqa: E501

        A JSON array to only include tasks that belong to a process instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :return: The process_variables of this TaskQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._process_variables

    @process_variables.setter
    def process_variables(self, process_variables):
        """Sets the process_variables of this TaskQueryDto.

        A JSON array to only include tasks that belong to a process instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :param process_variables: The process_variables of this TaskQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._process_variables = process_variables

    @property
    def case_instance_variables(self):
        """Gets the case_instance_variables of this TaskQueryDto.  # noqa: E501

        A JSON array to only include tasks that belong to a case instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :return: The case_instance_variables of this TaskQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._case_instance_variables

    @case_instance_variables.setter
    def case_instance_variables(self, case_instance_variables):
        """Sets the case_instance_variables of this TaskQueryDto.

        A JSON array to only include tasks that belong to a case instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :param case_instance_variables: The case_instance_variables of this TaskQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._case_instance_variables = case_instance_variables

    @property
    def variable_names_ignore_case(self):
        """Gets the variable_names_ignore_case of this TaskQueryDto.  # noqa: E501

        Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.  # noqa: E501

        :return: The variable_names_ignore_case of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_names_ignore_case

    @variable_names_ignore_case.setter
    def variable_names_ignore_case(self, variable_names_ignore_case):
        """Sets the variable_names_ignore_case of this TaskQueryDto.

        Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.  # noqa: E501

        :param variable_names_ignore_case: The variable_names_ignore_case of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_names_ignore_case = variable_names_ignore_case

    @property
    def variable_values_ignore_case(self):
        """Gets the variable_values_ignore_case of this TaskQueryDto.  # noqa: E501

        Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.  # noqa: E501

        :return: The variable_values_ignore_case of this TaskQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_values_ignore_case

    @variable_values_ignore_case.setter
    def variable_values_ignore_case(self, variable_values_ignore_case):
        """Sets the variable_values_ignore_case of this TaskQueryDto.

        Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.  # noqa: E501

        :param variable_values_ignore_case: The variable_values_ignore_case of this TaskQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_values_ignore_case = variable_values_ignore_case

    @property
    def parent_task_id(self):
        """Gets the parent_task_id of this TaskQueryDto.  # noqa: E501

        Restrict query to all tasks that are sub tasks of the given task. Takes a task id.  # noqa: E501

        :return: The parent_task_id of this TaskQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._parent_task_id

    @parent_task_id.setter
    def parent_task_id(self, parent_task_id):
        """Sets the parent_task_id of this TaskQueryDto.

        Restrict query to all tasks that are sub tasks of the given task. Takes a task id.  # noqa: E501

        :param parent_task_id: The parent_task_id of this TaskQueryDto.  # noqa: E501
        :type: str
        """

        self._parent_task_id = parent_task_id

    @property
    def or_queries(self):
        """Gets the or_queries of this TaskQueryDto.  # noqa: E501

        A JSON array of nested task queries with OR semantics. A task matches a nested query if it fulfills *at least one* of the query's predicates. With multiple nested queries, a task must fulfill at least one predicate of *each* query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task query properties can be used except for: `sorting`, `withCandidateGroups`, `withoutCandidateGroups`, `withCandidateUsers`, `withoutCandidateUsers`  See the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :return: The or_queries of this TaskQueryDto.  # noqa: E501
        :rtype: list[TaskQueryDto]
        """
        return self._or_queries

    @or_queries.setter
    def or_queries(self, or_queries):
        """Sets the or_queries of this TaskQueryDto.

        A JSON array of nested task queries with OR semantics. A task matches a nested query if it fulfills *at least one* of the query's predicates. With multiple nested queries, a task must fulfill at least one predicate of *each* query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task query properties can be used except for: `sorting`, `withCandidateGroups`, `withoutCandidateGroups`, `withCandidateUsers`, `withoutCandidateUsers`  See the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :param or_queries: The or_queries of this TaskQueryDto.  # noqa: E501
        :type: list[TaskQueryDto]
        """

        self._or_queries = or_queries

    @property
    def sorting(self):
        """Gets the sorting of this TaskQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this TaskQueryDto.  # noqa: E501
        :rtype: list[TaskQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this TaskQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this TaskQueryDto.  # noqa: E501
        :type: list[TaskQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskQueryDto):
            return True

        return self.to_dict() != other.to_dict()
