# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class SetJobRetriesByProcessDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instances': 'list[str]',
        'retries': 'int',
        'process_instance_query': 'ProcessInstanceQueryDto',
        'historic_process_instance_query': 'HistoricProcessInstanceQueryDto'
    }

    attribute_map = {
        'process_instances': 'processInstances',
        'retries': 'retries',
        'process_instance_query': 'processInstanceQuery',
        'historic_process_instance_query': 'historicProcessInstanceQuery'
    }

    def __init__(self, process_instances=None, retries=None, process_instance_query=None, historic_process_instance_query=None, local_vars_configuration=None):  # noqa: E501
        """SetJobRetriesByProcessDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instances = None
        self._retries = None
        self._process_instance_query = None
        self._historic_process_instance_query = None
        self.discriminator = None

        if process_instances is not None:
            self.process_instances = process_instances
        self.retries = retries
        if process_instance_query is not None:
            self.process_instance_query = process_instance_query
        if historic_process_instance_query is not None:
            self.historic_process_instance_query = historic_process_instance_query

    @property
    def process_instances(self):
        """Gets the process_instances of this SetJobRetriesByProcessDto.  # noqa: E501

        A list of process instance ids to fetch jobs, for which retries will be set.  # noqa: E501

        :return: The process_instances of this SetJobRetriesByProcessDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instances

    @process_instances.setter
    def process_instances(self, process_instances):
        """Sets the process_instances of this SetJobRetriesByProcessDto.

        A list of process instance ids to fetch jobs, for which retries will be set.  # noqa: E501

        :param process_instances: The process_instances of this SetJobRetriesByProcessDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instances = process_instances

    @property
    def retries(self):
        """Gets the retries of this SetJobRetriesByProcessDto.  # noqa: E501

        An integer representing the number of retries. Please note that the value cannot be negative or null.  # noqa: E501

        :return: The retries of this SetJobRetriesByProcessDto.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this SetJobRetriesByProcessDto.

        An integer representing the number of retries. Please note that the value cannot be negative or null.  # noqa: E501

        :param retries: The retries of this SetJobRetriesByProcessDto.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                retries is not None and retries < 0):  # noqa: E501
            raise ValueError("Invalid value for `retries`, must be a value greater than or equal to `0`")  # noqa: E501

        self._retries = retries

    @property
    def process_instance_query(self):
        """Gets the process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501


        :return: The process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501
        :rtype: ProcessInstanceQueryDto
        """
        return self._process_instance_query

    @process_instance_query.setter
    def process_instance_query(self, process_instance_query):
        """Sets the process_instance_query of this SetJobRetriesByProcessDto.


        :param process_instance_query: The process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501
        :type: ProcessInstanceQueryDto
        """

        self._process_instance_query = process_instance_query

    @property
    def historic_process_instance_query(self):
        """Gets the historic_process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501


        :return: The historic_process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501
        :rtype: HistoricProcessInstanceQueryDto
        """
        return self._historic_process_instance_query

    @historic_process_instance_query.setter
    def historic_process_instance_query(self, historic_process_instance_query):
        """Sets the historic_process_instance_query of this SetJobRetriesByProcessDto.


        :param historic_process_instance_query: The historic_process_instance_query of this SetJobRetriesByProcessDto.  # noqa: E501
        :type: HistoricProcessInstanceQueryDto
        """

        self._historic_process_instance_query = historic_process_instance_query

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SetJobRetriesByProcessDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SetJobRetriesByProcessDto):
            return True

        return self.to_dict() != other.to_dict()
