# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class RestartProcessInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instance_ids': 'list[str]',
        'historic_process_instance_query': 'HistoricProcessInstanceQueryDto',
        'skip_custom_listeners': 'bool',
        'skip_io_mappings': 'bool',
        'initial_variables': 'bool',
        'without_business_key': 'bool',
        'instructions': 'list[RestartProcessInstanceModificationInstructionDto]'
    }

    attribute_map = {
        'process_instance_ids': 'processInstanceIds',
        'historic_process_instance_query': 'historicProcessInstanceQuery',
        'skip_custom_listeners': 'skipCustomListeners',
        'skip_io_mappings': 'skipIoMappings',
        'initial_variables': 'initialVariables',
        'without_business_key': 'withoutBusinessKey',
        'instructions': 'instructions'
    }

    def __init__(self, process_instance_ids=None, historic_process_instance_query=None, skip_custom_listeners=None, skip_io_mappings=None, initial_variables=None, without_business_key=None, instructions=None, local_vars_configuration=None):  # noqa: E501
        """RestartProcessInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instance_ids = None
        self._historic_process_instance_query = None
        self._skip_custom_listeners = None
        self._skip_io_mappings = None
        self._initial_variables = None
        self._without_business_key = None
        self._instructions = None
        self.discriminator = None

        if process_instance_ids is not None:
            self.process_instance_ids = process_instance_ids
        if historic_process_instance_query is not None:
            self.historic_process_instance_query = historic_process_instance_query
        self.skip_custom_listeners = skip_custom_listeners
        self.skip_io_mappings = skip_io_mappings
        self.initial_variables = initial_variables
        self.without_business_key = without_business_key
        if instructions is not None:
            self.instructions = instructions

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this RestartProcessInstanceDto.  # noqa: E501

        A list of process instance ids to restart.  # noqa: E501

        :return: The process_instance_ids of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this RestartProcessInstanceDto.

        A list of process instance ids to restart.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this RestartProcessInstanceDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def historic_process_instance_query(self):
        """Gets the historic_process_instance_query of this RestartProcessInstanceDto.  # noqa: E501


        :return: The historic_process_instance_query of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: HistoricProcessInstanceQueryDto
        """
        return self._historic_process_instance_query

    @historic_process_instance_query.setter
    def historic_process_instance_query(self, historic_process_instance_query):
        """Sets the historic_process_instance_query of this RestartProcessInstanceDto.


        :param historic_process_instance_query: The historic_process_instance_query of this RestartProcessInstanceDto.  # noqa: E501
        :type: HistoricProcessInstanceQueryDto
        """

        self._historic_process_instance_query = historic_process_instance_query

    @property
    def skip_custom_listeners(self):
        """Gets the skip_custom_listeners of this RestartProcessInstanceDto.  # noqa: E501

        Skip execution listener invocation for activities that are started as part of this request.  # noqa: E501

        :return: The skip_custom_listeners of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_custom_listeners

    @skip_custom_listeners.setter
    def skip_custom_listeners(self, skip_custom_listeners):
        """Sets the skip_custom_listeners of this RestartProcessInstanceDto.

        Skip execution listener invocation for activities that are started as part of this request.  # noqa: E501

        :param skip_custom_listeners: The skip_custom_listeners of this RestartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._skip_custom_listeners = skip_custom_listeners

    @property
    def skip_io_mappings(self):
        """Gets the skip_io_mappings of this RestartProcessInstanceDto.  # noqa: E501

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.14/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started as part of this request.  # noqa: E501

        :return: The skip_io_mappings of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_io_mappings

    @skip_io_mappings.setter
    def skip_io_mappings(self, skip_io_mappings):
        """Sets the skip_io_mappings of this RestartProcessInstanceDto.

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.14/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started as part of this request.  # noqa: E501

        :param skip_io_mappings: The skip_io_mappings of this RestartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._skip_io_mappings = skip_io_mappings

    @property
    def initial_variables(self):
        """Gets the initial_variables of this RestartProcessInstanceDto.  # noqa: E501

        Set the initial set of variables during restart. By default, the last set of variables is used.  # noqa: E501

        :return: The initial_variables of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._initial_variables

    @initial_variables.setter
    def initial_variables(self, initial_variables):
        """Sets the initial_variables of this RestartProcessInstanceDto.

        Set the initial set of variables during restart. By default, the last set of variables is used.  # noqa: E501

        :param initial_variables: The initial_variables of this RestartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._initial_variables = initial_variables

    @property
    def without_business_key(self):
        """Gets the without_business_key of this RestartProcessInstanceDto.  # noqa: E501

        Do not take over the business key of the historic process instance.  # noqa: E501

        :return: The without_business_key of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_business_key

    @without_business_key.setter
    def without_business_key(self, without_business_key):
        """Sets the without_business_key of this RestartProcessInstanceDto.

        Do not take over the business key of the historic process instance.  # noqa: E501

        :param without_business_key: The without_business_key of this RestartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._without_business_key = without_business_key

    @property
    def instructions(self):
        """Gets the instructions of this RestartProcessInstanceDto.  # noqa: E501

        **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.  # noqa: E501

        :return: The instructions of this RestartProcessInstanceDto.  # noqa: E501
        :rtype: list[RestartProcessInstanceModificationInstructionDto]
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """Sets the instructions of this RestartProcessInstanceDto.

        **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.  # noqa: E501

        :param instructions: The instructions of this RestartProcessInstanceDto.  # noqa: E501
        :type: list[RestartProcessInstanceModificationInstructionDto]
        """

        self._instructions = instructions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RestartProcessInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RestartProcessInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
