# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ProcessInstanceQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'deployment_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_definition_key_in': 'list[str]',
        'process_definition_key_not_in': 'list[str]',
        'business_key': 'str',
        'business_key_like': 'str',
        'case_instance_id': 'str',
        'super_process_instance': 'str',
        'sub_process_instance': 'str',
        'super_case_instance': 'str',
        'sub_case_instance': 'str',
        'active': 'bool',
        'suspended': 'bool',
        'process_instance_ids': 'list[str]',
        'with_incident': 'bool',
        'incident_id': 'str',
        'incident_type': 'str',
        'incident_message': 'str',
        'incident_message_like': 'str',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'process_definition_without_tenant_id': 'bool',
        'activity_id_in': 'list[str]',
        'root_process_instances': 'bool',
        'leaf_process_instances': 'bool',
        'variables': 'list[VariableQueryParameterDto]',
        'variable_names_ignore_case': 'bool',
        'variable_values_ignore_case': 'bool',
        'or_queries': 'list[ProcessInstanceQueryDto]',
        'sorting': 'list[ProcessInstanceQueryDtoSorting]'
    }

    attribute_map = {
        'deployment_id': 'deploymentId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_key_in': 'processDefinitionKeyIn',
        'process_definition_key_not_in': 'processDefinitionKeyNotIn',
        'business_key': 'businessKey',
        'business_key_like': 'businessKeyLike',
        'case_instance_id': 'caseInstanceId',
        'super_process_instance': 'superProcessInstance',
        'sub_process_instance': 'subProcessInstance',
        'super_case_instance': 'superCaseInstance',
        'sub_case_instance': 'subCaseInstance',
        'active': 'active',
        'suspended': 'suspended',
        'process_instance_ids': 'processInstanceIds',
        'with_incident': 'withIncident',
        'incident_id': 'incidentId',
        'incident_type': 'incidentType',
        'incident_message': 'incidentMessage',
        'incident_message_like': 'incidentMessageLike',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'process_definition_without_tenant_id': 'processDefinitionWithoutTenantId',
        'activity_id_in': 'activityIdIn',
        'root_process_instances': 'rootProcessInstances',
        'leaf_process_instances': 'leafProcessInstances',
        'variables': 'variables',
        'variable_names_ignore_case': 'variableNamesIgnoreCase',
        'variable_values_ignore_case': 'variableValuesIgnoreCase',
        'or_queries': 'orQueries',
        'sorting': 'sorting'
    }

    def __init__(self, deployment_id=None, process_definition_id=None, process_definition_key=None, process_definition_key_in=None, process_definition_key_not_in=None, business_key=None, business_key_like=None, case_instance_id=None, super_process_instance=None, sub_process_instance=None, super_case_instance=None, sub_case_instance=None, active=None, suspended=None, process_instance_ids=None, with_incident=None, incident_id=None, incident_type=None, incident_message=None, incident_message_like=None, tenant_id_in=None, without_tenant_id=None, process_definition_without_tenant_id=None, activity_id_in=None, root_process_instances=None, leaf_process_instances=None, variables=None, variable_names_ignore_case=None, variable_values_ignore_case=None, or_queries=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """ProcessInstanceQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._deployment_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_definition_key_in = None
        self._process_definition_key_not_in = None
        self._business_key = None
        self._business_key_like = None
        self._case_instance_id = None
        self._super_process_instance = None
        self._sub_process_instance = None
        self._super_case_instance = None
        self._sub_case_instance = None
        self._active = None
        self._suspended = None
        self._process_instance_ids = None
        self._with_incident = None
        self._incident_id = None
        self._incident_type = None
        self._incident_message = None
        self._incident_message_like = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._process_definition_without_tenant_id = None
        self._activity_id_in = None
        self._root_process_instances = None
        self._leaf_process_instances = None
        self._variables = None
        self._variable_names_ignore_case = None
        self._variable_values_ignore_case = None
        self._or_queries = None
        self._sorting = None
        self.discriminator = None

        if deployment_id is not None:
            self.deployment_id = deployment_id
        if process_definition_id is not None:
            self.process_definition_id = process_definition_id
        if process_definition_key is not None:
            self.process_definition_key = process_definition_key
        if process_definition_key_in is not None:
            self.process_definition_key_in = process_definition_key_in
        if process_definition_key_not_in is not None:
            self.process_definition_key_not_in = process_definition_key_not_in
        if business_key is not None:
            self.business_key = business_key
        if business_key_like is not None:
            self.business_key_like = business_key_like
        if case_instance_id is not None:
            self.case_instance_id = case_instance_id
        if super_process_instance is not None:
            self.super_process_instance = super_process_instance
        if sub_process_instance is not None:
            self.sub_process_instance = sub_process_instance
        if super_case_instance is not None:
            self.super_case_instance = super_case_instance
        if sub_case_instance is not None:
            self.sub_case_instance = sub_case_instance
        self.active = active
        self.suspended = suspended
        if process_instance_ids is not None:
            self.process_instance_ids = process_instance_ids
        self.with_incident = with_incident
        if incident_id is not None:
            self.incident_id = incident_id
        if incident_type is not None:
            self.incident_type = incident_type
        if incident_message is not None:
            self.incident_message = incident_message
        if incident_message_like is not None:
            self.incident_message_like = incident_message_like
        if tenant_id_in is not None:
            self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.process_definition_without_tenant_id = process_definition_without_tenant_id
        if activity_id_in is not None:
            self.activity_id_in = activity_id_in
        self.root_process_instances = root_process_instances
        self.leaf_process_instances = leaf_process_instances
        if variables is not None:
            self.variables = variables
        self.variable_names_ignore_case = variable_names_ignore_case
        self.variable_values_ignore_case = variable_values_ignore_case
        if or_queries is not None:
            self.or_queries = or_queries
        if sorting is not None:
            self.sorting = sorting

    @property
    def deployment_id(self):
        """Gets the deployment_id of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the deployment the id belongs to.  # noqa: E501

        :return: The deployment_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this ProcessInstanceQueryDto.

        Filter by the deployment the id belongs to.  # noqa: E501

        :param deployment_id: The deployment_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the process definition the instances run on.  # noqa: E501

        :return: The process_definition_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this ProcessInstanceQueryDto.

        Filter by the process definition the instances run on.  # noqa: E501

        :param process_definition_id: The process_definition_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the key of the process definition the instances run on.  # noqa: E501

        :return: The process_definition_key of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this ProcessInstanceQueryDto.

        Filter by the key of the process definition the instances run on.  # noqa: E501

        :param process_definition_key: The process_definition_key of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_key_in(self):
        """Gets the process_definition_key_in of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of Strings.  # noqa: E501

        :return: The process_definition_key_in of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_definition_key_in

    @process_definition_key_in.setter
    def process_definition_key_in(self, process_definition_key_in):
        """Sets the process_definition_key_in of this ProcessInstanceQueryDto.

        Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of Strings.  # noqa: E501

        :param process_definition_key_in: The process_definition_key_in of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_definition_key_in = process_definition_key_in

    @property
    def process_definition_key_not_in(self):
        """Gets the process_definition_key_not_in of this ProcessInstanceQueryDto.  # noqa: E501

        Exclude instances by a list of process definition keys. A process instance must not have one of the given process definition keys. Must be a JSON array of Strings.  # noqa: E501

        :return: The process_definition_key_not_in of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_definition_key_not_in

    @process_definition_key_not_in.setter
    def process_definition_key_not_in(self, process_definition_key_not_in):
        """Sets the process_definition_key_not_in of this ProcessInstanceQueryDto.

        Exclude instances by a list of process definition keys. A process instance must not have one of the given process definition keys. Must be a JSON array of Strings.  # noqa: E501

        :param process_definition_key_not_in: The process_definition_key_not_in of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_definition_key_not_in = process_definition_key_not_in

    @property
    def business_key(self):
        """Gets the business_key of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance business key.  # noqa: E501

        :return: The business_key of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this ProcessInstanceQueryDto.

        Filter by process instance business key.  # noqa: E501

        :param business_key: The business_key of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def business_key_like(self):
        """Gets the business_key_like of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance business key that the parameter is a substring of.  # noqa: E501

        :return: The business_key_like of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key_like

    @business_key_like.setter
    def business_key_like(self, business_key_like):
        """Sets the business_key_like of this ProcessInstanceQueryDto.

        Filter by process instance business key that the parameter is a substring of.  # noqa: E501

        :param business_key_like: The business_key_like of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._business_key_like = business_key_like

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by case instance id.  # noqa: E501

        :return: The case_instance_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this ProcessInstanceQueryDto.

        Filter by case instance id.  # noqa: E501

        :param case_instance_id: The case_instance_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def super_process_instance(self):
        """Gets the super_process_instance of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.  # noqa: E501

        :return: The super_process_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._super_process_instance

    @super_process_instance.setter
    def super_process_instance(self, super_process_instance):
        """Sets the super_process_instance of this ProcessInstanceQueryDto.

        Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.  # noqa: E501

        :param super_process_instance: The super_process_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._super_process_instance = super_process_instance

    @property
    def sub_process_instance(self):
        """Gets the sub_process_instance of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.  # noqa: E501

        :return: The sub_process_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._sub_process_instance

    @sub_process_instance.setter
    def sub_process_instance(self, sub_process_instance):
        """Sets the sub_process_instance of this ProcessInstanceQueryDto.

        Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.  # noqa: E501

        :param sub_process_instance: The sub_process_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._sub_process_instance = sub_process_instance

    @property
    def super_case_instance(self):
        """Gets the super_case_instance of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :return: The super_case_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._super_case_instance

    @super_case_instance.setter
    def super_case_instance(self, super_case_instance):
        """Sets the super_case_instance of this ProcessInstanceQueryDto.

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :param super_case_instance: The super_case_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._super_case_instance = super_case_instance

    @property
    def sub_case_instance(self):
        """Gets the sub_case_instance of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.  # noqa: E501

        :return: The sub_case_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._sub_case_instance

    @sub_case_instance.setter
    def sub_case_instance(self, sub_case_instance):
        """Sets the sub_case_instance of this ProcessInstanceQueryDto.

        Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.  # noqa: E501

        :param sub_case_instance: The sub_case_instance of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._sub_case_instance = sub_case_instance

    @property
    def active(self):
        """Gets the active of this ProcessInstanceQueryDto.  # noqa: E501

        Only include active process instances. Value may only be true, as false is the default behavior.  # noqa: E501

        :return: The active of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this ProcessInstanceQueryDto.

        Only include active process instances. Value may only be true, as false is the default behavior.  # noqa: E501

        :param active: The active of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this ProcessInstanceQueryDto.  # noqa: E501

        Only include suspended process instances. Value may only be true, as false is the default behavior.  # noqa: E501

        :return: The suspended of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this ProcessInstanceQueryDto.

        Only include suspended process instances. Value may only be true, as false is the default behavior.  # noqa: E501

        :param suspended: The suspended of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of process instance ids. Must be a JSON array of Strings.  # noqa: E501

        :return: The process_instance_ids of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this ProcessInstanceQueryDto.

        Filter by a list of process instance ids. Must be a JSON array of Strings.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def with_incident(self):
        """Gets the with_incident of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by presence of incidents. Selects only process instances that have an incident.  # noqa: E501

        :return: The with_incident of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_incident

    @with_incident.setter
    def with_incident(self, with_incident):
        """Sets the with_incident of this ProcessInstanceQueryDto.

        Filter by presence of incidents. Selects only process instances that have an incident.  # noqa: E501

        :param with_incident: The with_incident of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_incident = with_incident

    @property
    def incident_id(self):
        """Gets the incident_id of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident id.  # noqa: E501

        :return: The incident_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_id

    @incident_id.setter
    def incident_id(self, incident_id):
        """Sets the incident_id of this ProcessInstanceQueryDto.

        Filter by the incident id.  # noqa: E501

        :param incident_id: The incident_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_id = incident_id

    @property
    def incident_type(self):
        """Gets the incident_type of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident type. See the User Guide for a list of incident types.  # noqa: E501

        :return: The incident_type of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this ProcessInstanceQueryDto.

        Filter by the incident type. See the User Guide for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def incident_message(self):
        """Gets the incident_message of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident message. Exact match.  # noqa: E501

        :return: The incident_message of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message

    @incident_message.setter
    def incident_message(self, incident_message):
        """Sets the incident_message of this ProcessInstanceQueryDto.

        Filter by the incident message. Exact match.  # noqa: E501

        :param incident_message: The incident_message of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message = incident_message

    @property
    def incident_message_like(self):
        """Gets the incident_message_like of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :return: The incident_message_like of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message_like

    @incident_message_like.setter
    def incident_message_like(self, incident_message_like):
        """Sets the incident_message_like of this ProcessInstanceQueryDto.

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :param incident_message_like: The incident_message_like of this ProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message_like = incident_message_like

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of Strings.  # noqa: E501

        :return: The tenant_id_in of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this ProcessInstanceQueryDto.

        Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of Strings.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501

        Only include process instances which belong to no tenant. Value may only be true, as false is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this ProcessInstanceQueryDto.

        Only include process instances which belong to no tenant. Value may only be true, as false is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def process_definition_without_tenant_id(self):
        """Gets the process_definition_without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501

        Only include process instances which process definition has no tenant id.  # noqa: E501

        :return: The process_definition_without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._process_definition_without_tenant_id

    @process_definition_without_tenant_id.setter
    def process_definition_without_tenant_id(self, process_definition_without_tenant_id):
        """Sets the process_definition_without_tenant_id of this ProcessInstanceQueryDto.

        Only include process instances which process definition has no tenant id.  # noqa: E501

        :param process_definition_without_tenant_id: The process_definition_without_tenant_id of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._process_definition_without_tenant_id = process_definition_without_tenant_id

    @property
    def activity_id_in(self):
        """Gets the activity_id_in of this ProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.  # noqa: E501

        :return: The activity_id_in of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_id_in

    @activity_id_in.setter
    def activity_id_in(self, activity_id_in):
        """Sets the activity_id_in of this ProcessInstanceQueryDto.

        Filter by a list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.  # noqa: E501

        :param activity_id_in: The activity_id_in of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_id_in = activity_id_in

    @property
    def root_process_instances(self):
        """Gets the root_process_instances of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict the query to all process instances that are top level process instances.  # noqa: E501

        :return: The root_process_instances of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._root_process_instances

    @root_process_instances.setter
    def root_process_instances(self, root_process_instances):
        """Sets the root_process_instances of this ProcessInstanceQueryDto.

        Restrict the query to all process instances that are top level process instances.  # noqa: E501

        :param root_process_instances: The root_process_instances of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._root_process_instances = root_process_instances

    @property
    def leaf_process_instances(self):
        """Gets the leaf_process_instances of this ProcessInstanceQueryDto.  # noqa: E501

        Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances)  # noqa: E501

        :return: The leaf_process_instances of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._leaf_process_instances

    @leaf_process_instances.setter
    def leaf_process_instances(self, leaf_process_instances):
        """Sets the leaf_process_instances of this ProcessInstanceQueryDto.

        Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances)  # noqa: E501

        :param leaf_process_instances: The leaf_process_instances of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._leaf_process_instances = leaf_process_instances

    @property
    def variables(self):
        """Gets the variables of this ProcessInstanceQueryDto.  # noqa: E501

        A JSON array to only include process instances that have variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (String) is the variable name, `operator` (String) is the comparison operator to be used and `value` the variable value. The `value` may be String, Number or Boolean.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  # noqa: E501

        :return: The variables of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this ProcessInstanceQueryDto.

        A JSON array to only include process instances that have variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (String) is the variable name, `operator` (String) is the comparison operator to be used and `value` the variable value. The `value` may be String, Number or Boolean.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  # noqa: E501

        :param variables: The variables of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._variables = variables

    @property
    def variable_names_ignore_case(self):
        """Gets the variable_names_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501

        Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.  # noqa: E501

        :return: The variable_names_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_names_ignore_case

    @variable_names_ignore_case.setter
    def variable_names_ignore_case(self, variable_names_ignore_case):
        """Sets the variable_names_ignore_case of this ProcessInstanceQueryDto.

        Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.  # noqa: E501

        :param variable_names_ignore_case: The variable_names_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_names_ignore_case = variable_names_ignore_case

    @property
    def variable_values_ignore_case(self):
        """Gets the variable_values_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501

        Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.  # noqa: E501

        :return: The variable_values_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_values_ignore_case

    @variable_values_ignore_case.setter
    def variable_values_ignore_case(self, variable_values_ignore_case):
        """Sets the variable_values_ignore_case of this ProcessInstanceQueryDto.

        Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.  # noqa: E501

        :param variable_values_ignore_case: The variable_values_ignore_case of this ProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_values_ignore_case = variable_values_ignore_case

    @property
    def or_queries(self):
        """Gets the or_queries of this ProcessInstanceQueryDto.  # noqa: E501

        A JSON array of nested process instance queries with OR semantics. A process instance matches a nested query if it fulfills at least one of the query's predicates. With multiple nested queries, a process instance must fulfill at least one predicate of each query (Conjunctive Normal Form). All process instance query properties can be used except for: `sorting` See the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :return: The or_queries of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[ProcessInstanceQueryDto]
        """
        return self._or_queries

    @or_queries.setter
    def or_queries(self, or_queries):
        """Sets the or_queries of this ProcessInstanceQueryDto.

        A JSON array of nested process instance queries with OR semantics. A process instance matches a nested query if it fulfills at least one of the query's predicates. With multiple nested queries, a process instance must fulfill at least one predicate of each query (Conjunctive Normal Form). All process instance query properties can be used except for: `sorting` See the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :param or_queries: The or_queries of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[ProcessInstanceQueryDto]
        """

        self._or_queries = or_queries

    @property
    def sorting(self):
        """Gets the sorting of this ProcessInstanceQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this ProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[ProcessInstanceQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this ProcessInstanceQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this ProcessInstanceQueryDto.  # noqa: E501
        :type: list[ProcessInstanceQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcessInstanceQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProcessInstanceQueryDto):
            return True

        return self.to_dict() != other.to_dict()
