# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class EventSubscriptionQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'event_subscription_id': 'str',
        'event_name': 'str',
        'event_type': 'str',
        'execution_id': 'str',
        'process_instance_id': 'str',
        'activity_id': 'str',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'include_event_subscriptions_without_tenant_id': 'bool',
        'sorting': 'list[EventSubscriptionQueryDtoSorting]'
    }

    attribute_map = {
        'event_subscription_id': 'eventSubscriptionId',
        'event_name': 'eventName',
        'event_type': 'eventType',
        'execution_id': 'executionId',
        'process_instance_id': 'processInstanceId',
        'activity_id': 'activityId',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'include_event_subscriptions_without_tenant_id': 'includeEventSubscriptionsWithoutTenantId',
        'sorting': 'sorting'
    }

    def __init__(self, event_subscription_id=None, event_name=None, event_type=None, execution_id=None, process_instance_id=None, activity_id=None, tenant_id_in=None, without_tenant_id=None, include_event_subscriptions_without_tenant_id=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """EventSubscriptionQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._event_subscription_id = None
        self._event_name = None
        self._event_type = None
        self._execution_id = None
        self._process_instance_id = None
        self._activity_id = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._include_event_subscriptions_without_tenant_id = None
        self._sorting = None
        self.discriminator = None

        if event_subscription_id is not None:
            self.event_subscription_id = event_subscription_id
        if event_name is not None:
            self.event_name = event_name
        if event_type is not None:
            self.event_type = event_type
        if execution_id is not None:
            self.execution_id = execution_id
        if process_instance_id is not None:
            self.process_instance_id = process_instance_id
        if activity_id is not None:
            self.activity_id = activity_id
        if tenant_id_in is not None:
            self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.include_event_subscriptions_without_tenant_id = include_event_subscriptions_without_tenant_id
        if sorting is not None:
            self.sorting = sorting

    @property
    def event_subscription_id(self):
        """Gets the event_subscription_id of this EventSubscriptionQueryDto.  # noqa: E501

        The id of the event subscription.  # noqa: E501

        :return: The event_subscription_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._event_subscription_id

    @event_subscription_id.setter
    def event_subscription_id(self, event_subscription_id):
        """Sets the event_subscription_id of this EventSubscriptionQueryDto.

        The id of the event subscription.  # noqa: E501

        :param event_subscription_id: The event_subscription_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """

        self._event_subscription_id = event_subscription_id

    @property
    def event_name(self):
        """Gets the event_name of this EventSubscriptionQueryDto.  # noqa: E501

        The name of the event this subscription belongs to as defined in the process model.  # noqa: E501

        :return: The event_name of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """Sets the event_name of this EventSubscriptionQueryDto.

        The name of the event this subscription belongs to as defined in the process model.  # noqa: E501

        :param event_name: The event_name of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """

        self._event_name = event_name

    @property
    def event_type(self):
        """Gets the event_type of this EventSubscriptionQueryDto.  # noqa: E501

        The type of the event subscription.  # noqa: E501

        :return: The event_type of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this EventSubscriptionQueryDto.

        The type of the event subscription.  # noqa: E501

        :param event_type: The event_type of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["message", "signal", "compensate", "conditional"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and event_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `event_type` ({0}), must be one of {1}"  # noqa: E501
                .format(event_type, allowed_values)
            )

        self._event_type = event_type

    @property
    def execution_id(self):
        """Gets the execution_id of this EventSubscriptionQueryDto.  # noqa: E501

        The execution that is subscribed on the referenced event.  # noqa: E501

        :return: The execution_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this EventSubscriptionQueryDto.

        The execution that is subscribed on the referenced event.  # noqa: E501

        :param execution_id: The execution_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this EventSubscriptionQueryDto.  # noqa: E501

        The process instance this subscription belongs to.  # noqa: E501

        :return: The process_instance_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this EventSubscriptionQueryDto.

        The process instance this subscription belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def activity_id(self):
        """Gets the activity_id of this EventSubscriptionQueryDto.  # noqa: E501

        The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.  # noqa: E501

        :return: The activity_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this EventSubscriptionQueryDto.

        The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.  # noqa: E501

        :param activity_id: The activity_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this EventSubscriptionQueryDto.  # noqa: E501

        Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.  # noqa: E501

        :return: The tenant_id_in of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this EventSubscriptionQueryDto.

        Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this EventSubscriptionQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501

        Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this EventSubscriptionQueryDto.

        Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def include_event_subscriptions_without_tenant_id(self):
        """Gets the include_event_subscriptions_without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501

        Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The include_event_subscriptions_without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_event_subscriptions_without_tenant_id

    @include_event_subscriptions_without_tenant_id.setter
    def include_event_subscriptions_without_tenant_id(self, include_event_subscriptions_without_tenant_id):
        """Sets the include_event_subscriptions_without_tenant_id of this EventSubscriptionQueryDto.

        Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param include_event_subscriptions_without_tenant_id: The include_event_subscriptions_without_tenant_id of this EventSubscriptionQueryDto.  # noqa: E501
        :type: bool
        """

        self._include_event_subscriptions_without_tenant_id = include_event_subscriptions_without_tenant_id

    @property
    def sorting(self):
        """Gets the sorting of this EventSubscriptionQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this EventSubscriptionQueryDto.  # noqa: E501
        :rtype: list[EventSubscriptionQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this EventSubscriptionQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this EventSubscriptionQueryDto.  # noqa: E501
        :type: list[EventSubscriptionQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventSubscriptionQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EventSubscriptionQueryDto):
            return True

        return self.to_dict() != other.to_dict()
