# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class EventSubscriptionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_event_subscriptions(self, **kwargs):  # noqa: E501
        """get_event_subscriptions  # noqa: E501

        Queries for event subscriptions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Event Subscriptions count](https://docs.camunda.org/manual/7.14/reference/rest/event-subscription/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_subscriptions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str event_subscription_id: Only select subscription with the given id.
        :param str event_name: Only select subscriptions for events with the given name.
        :param str event_type: Only select subscriptions for events with the given type. Valid values: `message`, `signal`, `compensate` and `conditional`.
        :param str execution_id: Only select subscriptions that belong to an execution with the given id.
        :param str process_instance_id: Only select subscriptions that belong to a process instance with the given id.
        :param str activity_id: Only select subscriptions that belong to an activity with the given id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
        :param bool without_tenant_id: Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.
        :param bool include_event_subscriptions_without_tenant_id: Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EventSubscriptionDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_event_subscriptions_with_http_info(**kwargs)  # noqa: E501

    def get_event_subscriptions_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_subscriptions  # noqa: E501

        Queries for event subscriptions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Event Subscriptions count](https://docs.camunda.org/manual/7.14/reference/rest/event-subscription/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_subscriptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str event_subscription_id: Only select subscription with the given id.
        :param str event_name: Only select subscriptions for events with the given name.
        :param str event_type: Only select subscriptions for events with the given type. Valid values: `message`, `signal`, `compensate` and `conditional`.
        :param str execution_id: Only select subscriptions that belong to an execution with the given id.
        :param str process_instance_id: Only select subscriptions that belong to a process instance with the given id.
        :param str activity_id: Only select subscriptions that belong to an activity with the given id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
        :param bool without_tenant_id: Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.
        :param bool include_event_subscriptions_without_tenant_id: Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EventSubscriptionDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'event_subscription_id',
            'event_name',
            'event_type',
            'execution_id',
            'process_instance_id',
            'activity_id',
            'tenant_id_in',
            'without_tenant_id',
            'include_event_subscriptions_without_tenant_id',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_subscriptions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_subscription_id' in local_var_params and local_var_params['event_subscription_id'] is not None:  # noqa: E501
            query_params.append(('eventSubscriptionId', local_var_params['event_subscription_id']))  # noqa: E501
        if 'event_name' in local_var_params and local_var_params['event_name'] is not None:  # noqa: E501
            query_params.append(('eventName', local_var_params['event_name']))  # noqa: E501
        if 'event_type' in local_var_params and local_var_params['event_type'] is not None:  # noqa: E501
            query_params.append(('eventType', local_var_params['event_type']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'include_event_subscriptions_without_tenant_id' in local_var_params and local_var_params['include_event_subscriptions_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('includeEventSubscriptionsWithoutTenantId', local_var_params['include_event_subscriptions_without_tenant_id']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/event-subscription', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EventSubscriptionDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_subscriptions_count(self, **kwargs):  # noqa: E501
        """get_event_subscriptions_count  # noqa: E501

        Queries for the number of event subscriptions that fulfill given parameters. Takes the same parameters as the [Get Event Subscriptions](https://docs.camunda.org/manual/7.14/reference/rest/event-subscription/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_subscriptions_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str event_subscription_id: Only select subscription with the given id.
        :param str event_name: Only select subscriptions for events with the given name.
        :param str event_type: Only select subscriptions for events with the given type. Valid values: `message`, `signal`, `compensate` and `conditional`.
        :param str execution_id: Only select subscriptions that belong to an execution with the given id.
        :param str process_instance_id: Only select subscriptions that belong to a process instance with the given id.
        :param str activity_id: Only select subscriptions that belong to an activity with the given id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
        :param bool without_tenant_id: Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.
        :param bool include_event_subscriptions_without_tenant_id: Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_event_subscriptions_count_with_http_info(**kwargs)  # noqa: E501

    def get_event_subscriptions_count_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_subscriptions_count  # noqa: E501

        Queries for the number of event subscriptions that fulfill given parameters. Takes the same parameters as the [Get Event Subscriptions](https://docs.camunda.org/manual/7.14/reference/rest/event-subscription/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_subscriptions_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str event_subscription_id: Only select subscription with the given id.
        :param str event_name: Only select subscriptions for events with the given name.
        :param str event_type: Only select subscriptions for events with the given type. Valid values: `message`, `signal`, `compensate` and `conditional`.
        :param str execution_id: Only select subscriptions that belong to an execution with the given id.
        :param str process_instance_id: Only select subscriptions that belong to a process instance with the given id.
        :param str activity_id: Only select subscriptions that belong to an activity with the given id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
        :param bool without_tenant_id: Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.
        :param bool include_event_subscriptions_without_tenant_id: Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'event_subscription_id',
            'event_name',
            'event_type',
            'execution_id',
            'process_instance_id',
            'activity_id',
            'tenant_id_in',
            'without_tenant_id',
            'include_event_subscriptions_without_tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_subscriptions_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_subscription_id' in local_var_params and local_var_params['event_subscription_id'] is not None:  # noqa: E501
            query_params.append(('eventSubscriptionId', local_var_params['event_subscription_id']))  # noqa: E501
        if 'event_name' in local_var_params and local_var_params['event_name'] is not None:  # noqa: E501
            query_params.append(('eventName', local_var_params['event_name']))  # noqa: E501
        if 'event_type' in local_var_params and local_var_params['event_type'] is not None:  # noqa: E501
            query_params.append(('eventType', local_var_params['event_type']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'include_event_subscriptions_without_tenant_id' in local_var_params and local_var_params['include_event_subscriptions_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('includeEventSubscriptionsWithoutTenantId', local_var_params['include_event_subscriptions_without_tenant_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/event-subscription/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
