# ------------------------------------------------------------ Imports ----------------------------------------------------------- #

# System
import os

# Local
from ..chrome_addon_install_settings import ChromeAddonInstallSettings

# -------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ Defines ----------------------------------------------------------- #

RESOURCES_FOLDER_NAME = 'resources'


# -------------------------------------------------------------------------------------------------------------------------------- #



# ---------------------------------------------- class: BuiltinAddonInstallSettings ---------------------------------------------- #

class BuiltinAddonInstallSettings(ChromeAddonInstallSettings):

    # --------------------------------------------------------- Init --------------------------------------------------------- #

    def __init__(self):
        if not self._name.endswith('.crx'):
            self._name += '.crx'

        super().__init__(
            os.path.join(
                os.path.dirname(os.path.abspath(__file__)),
                RESOURCES_FOLDER_NAME,
                self._name
            ),
            self._id
        )


    # --------------------------------------------------- Public properties -------------------------------------------------- #

    _name: str = ''
    _id:   str = ''


# -------------------------------------------------------------------------------------------------------------------------------- #