"""dcc-mcp-core: Foundational library for the DCC Model Context Protocol (MCP) ecosystem."""

# Import local modules
from dcc_mcp_core import logg_config
from dcc_mcp_core import models
from dcc_mcp_core import parameters
from dcc_mcp_core.actions.manager import create_action_manager
from dcc_mcp_core.actions.manager import get_action_manager
from dcc_mcp_core.actions.metadata import create_action_model
from dcc_mcp_core.actions.metadata import extract_action_metadata
from dcc_mcp_core.actions.metadata import extract_function_metadata
from dcc_mcp_core.logg_config import get_logger
from dcc_mcp_core.logg_config import setup_dcc_logging
from dcc_mcp_core.logg_config import setup_logging
from dcc_mcp_core.logg_config import setup_rpyc_logging
from dcc_mcp_core.parameters.processor import process_parameters
from dcc_mcp_core.utils.dependency_injector import inject_dependencies
from dcc_mcp_core.utils.filesystem import append_to_python_path
from dcc_mcp_core.utils.filesystem import convert_path_to_module
from dcc_mcp_core.utils.filesystem import discover_actions
from dcc_mcp_core.utils.module_loader import load_module_from_path

__all__ = [
    "append_to_python_path",
    "convert_path_to_module",
    "create_action_manager",
    "create_action_model",
    "discover_actions",
    "extract_action_metadata",
    "extract_function_metadata",
    "get_action_manager",
    "get_logger",
    "inject_dependencies",
    "load_module_from_path",
    "logg_config",
    "models",
    "parameters",
    "process_parameters",
    "setup_dcc_logging",
    "setup_logging",
    "setup_rpyc_logging"
]
