# nomad-envoy-utils-cli
This is the API descriptor for the EC Platform and customs utils. Developed by [Samarkand Global](https://samarkand.global), EC Platform including [Youzan](https://www.youzan.com/) Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for python with `pip install nomad_envoy_utils_cli` - Install for node with `npm install nomad_envoy_utils_cli`

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.3.0
- Package version: 1.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_envoy_utils_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_envoy_utils_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nomad_envoy_utils_cli
from nomad_envoy_utils_cli.rest import ApiException
from pprint import pprint


# Defining host is optional and default to https://nomad-envoy-utils.samarkand-global.cn
configuration.host = "https://nomad-envoy-utils.samarkand-global.cn"
# Enter a context with an instance of the API client
with nomad_envoy_utils_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nomad_envoy_utils_cli.HealthApi(api_client)
    
    try:
        # health
        api_response = api_instance.get_health()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling HealthApi->get_health: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad-envoy-utils.samarkand-global.cn*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthApi* | [**get_health**](docs/HealthApi.md#get_health) | **GET** /health | health
*HealthApi* | [**get_metrics**](docs/HealthApi.md#get_metrics) | **GET** /metrics | metrics
*PlatformApi* | [**batch_operate_cypher**](docs/PlatformApi.md#batch_operate_cypher) | **POST** /platform/cypher | cypher


## Documentation For Models

 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)
 - [Cypher](docs/Cypher.md)
 - [CypherOperation](docs/CypherOperation.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: URL query string


## ca_stage

- **Type**: API key
- **API key parameter name**: x-ca-stage
- **Location**: HTTP header


## Author

paul@samarkand.global


## Demo 
``` python
import nomad_envoy_utils_cli
from nomad_envoy_utils_cli.models import Cypher, CypherOperation

configuration = nomad_envoy_utils_cli.Configuration()
configuration.host = "https://nomad.samarkand-global.cn"
# Enter a context with an instance of the API client
with nomad_envoy_utils_cli.ApiClient(configuration) as api_client:
    api_client.set_default_header(
        "Authorization", "APPCODE test")

    api_instance = nomad_envoy_utils_cli.PlatformApi(api_client)
    cypher = Cypher(store_id="samarkand.youzan.kuiseng",
                    operation=CypherOperation.DECRYPTBATCH,
                    items=["$Kg7PP/qJTnIYX+22Y2pa+A==$1$"])
    try:
        api_response = api_instance.batch_operate_cypher(cypher=cypher)
        print(api_response, api_response.data)
    except Exception as e:
        print("Exception : %s\n" % str(e))
```

